/* rygel-content-directory.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-content-directory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2007 OpenedHand Ltd.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jorn Baayen <jorn@openedhand.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <rygel-core.h>
#include <uuid/uuid.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_IMPORT_RESOURCE (rygel_import_resource_get_type ())
#define RYGEL_IMPORT_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResource))
#define RYGEL_IMPORT_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResourceClass))
#define RYGEL_IS_IMPORT_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMPORT_RESOURCE))
#define RYGEL_IS_IMPORT_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMPORT_RESOURCE))
#define RYGEL_IMPORT_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResourceClass))

typedef struct _RygelImportResource RygelImportResource;
typedef struct _RygelImportResourceClass RygelImportResourceClass;

#define RYGEL_TYPE_LAST_CHANGE (rygel_last_change_get_type ())
#define RYGEL_LAST_CHANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE, RygelLastChange))
#define RYGEL_LAST_CHANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE, RygelLastChangeClass))
#define RYGEL_IS_LAST_CHANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE))
#define RYGEL_IS_LAST_CHANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE))
#define RYGEL_LAST_CHANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE, RygelLastChangeClass))

typedef struct _RygelLastChange RygelLastChange;
typedef struct _RygelLastChangeClass RygelLastChangeClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_SERVER_PLUGIN (rygel_media_server_plugin_get_type ())
#define RYGEL_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin))
#define RYGEL_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_MEDIA_SERVER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))

typedef struct _RygelMediaServerPlugin RygelMediaServerPlugin;
typedef struct _RygelMediaServerPluginClass RygelMediaServerPluginClass;

#define RYGEL_TYPE_TRACKABLE_CONTAINER (rygel_trackable_container_get_type ())
#define RYGEL_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainer))
#define RYGEL_IS_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER))
#define RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainerIface))

typedef struct _RygelTrackableContainer RygelTrackableContainer;
typedef struct _RygelTrackableContainerIface RygelTrackableContainerIface;

#define RYGEL_TYPE_OBJECT_EVENT_TYPE (rygel_object_event_type_get_type ())

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;

#define RYGEL_TYPE_BROWSE (rygel_browse_get_type ())
#define RYGEL_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BROWSE, RygelBrowse))
#define RYGEL_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BROWSE, RygelBrowseClass))
#define RYGEL_IS_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BROWSE))
#define RYGEL_IS_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BROWSE))
#define RYGEL_BROWSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BROWSE, RygelBrowseClass))

typedef struct _RygelBrowse RygelBrowse;
typedef struct _RygelBrowseClass RygelBrowseClass;

#define RYGEL_TYPE_SEARCH (rygel_search_get_type ())
#define RYGEL_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH, RygelSearch))
#define RYGEL_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH, RygelSearchClass))
#define RYGEL_IS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH))
#define RYGEL_IS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH))
#define RYGEL_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH, RygelSearchClass))

typedef struct _RygelSearch RygelSearch;
typedef struct _RygelSearchClass RygelSearchClass;

#define RYGEL_TYPE_OBJECT_CREATOR (rygel_object_creator_get_type ())
#define RYGEL_OBJECT_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreator))
#define RYGEL_OBJECT_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreatorClass))
#define RYGEL_IS_OBJECT_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_OBJECT_CREATOR))
#define RYGEL_IS_OBJECT_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_OBJECT_CREATOR))
#define RYGEL_OBJECT_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreatorClass))

typedef struct _RygelObjectCreator RygelObjectCreator;
typedef struct _RygelObjectCreatorClass RygelObjectCreatorClass;

#define RYGEL_TYPE_REFERENCE_CREATOR (rygel_reference_creator_get_type ())
#define RYGEL_REFERENCE_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_REFERENCE_CREATOR, RygelReferenceCreator))
#define RYGEL_REFERENCE_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_REFERENCE_CREATOR, RygelReferenceCreatorClass))
#define RYGEL_IS_REFERENCE_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_REFERENCE_CREATOR))
#define RYGEL_IS_REFERENCE_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_REFERENCE_CREATOR))
#define RYGEL_REFERENCE_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_REFERENCE_CREATOR, RygelReferenceCreatorClass))

typedef struct _RygelReferenceCreator RygelReferenceCreator;
typedef struct _RygelReferenceCreatorClass RygelReferenceCreatorClass;

#define RYGEL_TYPE_ITEM_DESTROYER (rygel_item_destroyer_get_type ())
#define RYGEL_ITEM_DESTROYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyer))
#define RYGEL_ITEM_DESTROYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyerClass))
#define RYGEL_IS_ITEM_DESTROYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_DESTROYER))
#define RYGEL_IS_ITEM_DESTROYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_DESTROYER))
#define RYGEL_ITEM_DESTROYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyerClass))

typedef struct _RygelItemDestroyer RygelItemDestroyer;
typedef struct _RygelItemDestroyerClass RygelItemDestroyerClass;

#define RYGEL_TYPE_ITEM_UPDATER (rygel_item_updater_get_type ())
#define RYGEL_ITEM_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdater))
#define RYGEL_ITEM_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdaterClass))
#define RYGEL_IS_ITEM_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_UPDATER))
#define RYGEL_IS_ITEM_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_UPDATER))
#define RYGEL_ITEM_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdaterClass))

typedef struct _RygelItemUpdater RygelItemUpdater;
typedef struct _RygelItemUpdaterClass RygelItemUpdaterClass;
typedef struct _RygelImportResourcePrivate RygelImportResourcePrivate;

#define RYGEL_TYPE_TRANSFER_STATUS (rygel_transfer_status_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_LAST_CHANGE_ENTRY (rygel_last_change_entry_get_type ())
#define RYGEL_LAST_CHANGE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE_ENTRY, RygelLastChangeEntry))
#define RYGEL_LAST_CHANGE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE_ENTRY, RygelLastChangeEntryClass))
#define RYGEL_IS_LAST_CHANGE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE_ENTRY))
#define RYGEL_IS_LAST_CHANGE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE_ENTRY))
#define RYGEL_LAST_CHANGE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE_ENTRY, RygelLastChangeEntryClass))

typedef struct _RygelLastChangeEntry RygelLastChangeEntry;
typedef struct _RygelLastChangeEntryClass RygelLastChangeEntryClass;

#define RYGEL_TYPE_LAST_CHANGE_ST_DONE (rygel_last_change_st_done_get_type ())
#define RYGEL_LAST_CHANGE_ST_DONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE_ST_DONE, RygelLastChangeStDone))
#define RYGEL_LAST_CHANGE_ST_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE_ST_DONE, RygelLastChangeStDoneClass))
#define RYGEL_IS_LAST_CHANGE_ST_DONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE_ST_DONE))
#define RYGEL_IS_LAST_CHANGE_ST_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE_ST_DONE))
#define RYGEL_LAST_CHANGE_ST_DONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE_ST_DONE, RygelLastChangeStDoneClass))

typedef struct _RygelLastChangeStDone RygelLastChangeStDone;
typedef struct _RygelLastChangeStDoneClass RygelLastChangeStDoneClass;
typedef struct _Block4Data Block4Data;

#define RYGEL_TYPE_LAST_CHANGE_OBJ_ADD (rygel_last_change_obj_add_get_type ())
#define RYGEL_LAST_CHANGE_OBJ_ADD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_ADD, RygelLastChangeObjAdd))
#define RYGEL_LAST_CHANGE_OBJ_ADD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_ADD, RygelLastChangeObjAddClass))
#define RYGEL_IS_LAST_CHANGE_OBJ_ADD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_ADD))
#define RYGEL_IS_LAST_CHANGE_OBJ_ADD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_ADD))
#define RYGEL_LAST_CHANGE_OBJ_ADD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_ADD, RygelLastChangeObjAddClass))

typedef struct _RygelLastChangeObjAdd RygelLastChangeObjAdd;
typedef struct _RygelLastChangeObjAddClass RygelLastChangeObjAddClass;

#define RYGEL_TYPE_LAST_CHANGE_OBJ_MOD (rygel_last_change_obj_mod_get_type ())
#define RYGEL_LAST_CHANGE_OBJ_MOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_MOD, RygelLastChangeObjMod))
#define RYGEL_LAST_CHANGE_OBJ_MOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_MOD, RygelLastChangeObjModClass))
#define RYGEL_IS_LAST_CHANGE_OBJ_MOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_MOD))
#define RYGEL_IS_LAST_CHANGE_OBJ_MOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_MOD))
#define RYGEL_LAST_CHANGE_OBJ_MOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_MOD, RygelLastChangeObjModClass))

typedef struct _RygelLastChangeObjMod RygelLastChangeObjMod;
typedef struct _RygelLastChangeObjModClass RygelLastChangeObjModClass;

#define RYGEL_TYPE_LAST_CHANGE_OBJ_DEL (rygel_last_change_obj_del_get_type ())
#define RYGEL_LAST_CHANGE_OBJ_DEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_DEL, RygelLastChangeObjDel))
#define RYGEL_LAST_CHANGE_OBJ_DEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_DEL, RygelLastChangeObjDelClass))
#define RYGEL_IS_LAST_CHANGE_OBJ_DEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_DEL))
#define RYGEL_IS_LAST_CHANGE_OBJ_DEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LAST_CHANGE_OBJ_DEL))
#define RYGEL_LAST_CHANGE_OBJ_DEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LAST_CHANGE_OBJ_DEL, RygelLastChangeObjDelClass))

typedef struct _RygelLastChangeObjDel RygelLastChangeObjDel;
typedef struct _RygelLastChangeObjDelClass RygelLastChangeObjDelClass;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelContentDirectoryServiceResetData RygelContentDirectoryServiceResetData;

#define RYGEL_TYPE_DLNA_PROFILE (rygel_dlna_profile_get_type ())
#define RYGEL_DLNA_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DLNA_PROFILE, RygelDLNAProfile))
#define RYGEL_DLNA_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DLNA_PROFILE, RygelDLNAProfileClass))
#define RYGEL_IS_DLNA_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DLNA_PROFILE))
#define RYGEL_IS_DLNA_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DLNA_PROFILE))
#define RYGEL_DLNA_PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DLNA_PROFILE, RygelDLNAProfileClass))

typedef struct _RygelDLNAProfile RygelDLNAProfile;
typedef struct _RygelDLNAProfileClass RygelDLNAProfileClass;
typedef struct _RygelDLNAProfilePrivate RygelDLNAProfilePrivate;
#define _rygel_dlna_profile_unref0(var) ((var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

/**
 * Errors used by ContentDirectory and deriving classes.
 */
typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA = 708,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER = 710,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER = 717,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

struct _RygelContentDirectoryPrivate {
	GeeArrayList* updated_containers;
	GeeArrayList* active_imports;
	GeeArrayList* finished_imports;
	gboolean clear_updated_containers;
	guint update_notify_id;
	RygelLastChange* last_change;
	gchar* service_reset_token;
	gchar* search_caps;
};

struct _RygelTrackableContainerIface {
	GTypeInterface parent_iface;
	void (*add_child) (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_child_finish) (RygelTrackableContainer* self, GAsyncResult* _res_);
	void (*remove_child) (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_child_finish) (RygelTrackableContainer* self, GAsyncResult* _res_);
	gchar* (*get_service_reset_token) (RygelTrackableContainer* self);
	void (*set_service_reset_token) (RygelTrackableContainer* self, const gchar* token);
	guint32 (*get_system_update_id) (RygelTrackableContainer* self);
};

typedef enum  {
	RYGEL_OBJECT_EVENT_TYPE_ADDED = 0,
	RYGEL_OBJECT_EVENT_TYPE_MODIFIED = 1,
	RYGEL_OBJECT_EVENT_TYPE_DELETED = 2
} RygelObjectEventType;

typedef enum  {
	RYGEL_TRANSFER_STATUS_COMPLETED,
	RYGEL_TRANSFER_STATUS_ERROR,
	RYGEL_TRANSFER_STATUS_IN_PROGRESS,
	RYGEL_TRANSFER_STATUS_STOPPED
} RygelTransferStatus;

struct _RygelImportResource {
	GObject parent_instance;
	RygelImportResourcePrivate * priv;
	gchar* source_uri;
	gchar* destination_uri;
	guint32 transfer_id;
	RygelTransferStatus status;
	gint64 bytes_copied;
	gint64 bytes_total;
};

struct _RygelImportResourceClass {
	GObjectClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	GeeArrayList* uris;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	guint32 update_id;
	gint64 storage_used;
	gint64 total_deleted_child_count;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _Block4Data {
	int _ref_count_;
	RygelContentDirectory * self;
	RygelImportResource* import;
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelContentDirectoryServiceResetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelContentDirectory* self;
	RygelMediaServerPlugin* plugin;
	GUPnPRootDevice* _tmp0_;
	GUPnPRootDevice* _tmp1_;
	GUPnPRootDevice* _tmp2_;
	GUPnPResourceFactory* _tmp3_;
	GUPnPResourceFactory* _tmp4_;
	RygelMediaServerPlugin* _tmp5_;
	RygelMediaServerPlugin* _tmp6_;
	RygelMediaServerPlugin* _tmp7_;
	gchar* _tmp8_;
	RygelMediaContainer* _tmp9_;
	RygelTrackableContainer* trackable;
	RygelMediaContainer* _tmp10_;
	RygelTrackableContainer* _tmp11_;
	RygelTrackableContainer* _tmp12_;
	const gchar* _tmp13_;
	RygelRelationalExpression* expression;
	RygelRelationalExpression* _tmp14_;
	RygelRelationalExpression* _tmp15_;
	gchar* _tmp16_;
	RygelRelationalExpression* _tmp17_;
	gchar* _tmp18_;
	RygelRelationalExpression* _tmp19_;
	RygelSearchableContainer* root;
	RygelMediaContainer* _tmp20_;
	RygelSearchableContainer* _tmp21_;
	RygelSearchableContainer* _tmp22_;
	guint32 matches;
	RygelMediaObjects* objects;
	RygelSearchableContainer* _tmp23_;
	RygelRelationalExpression* _tmp24_;
	guint _tmp25_;
	RygelMediaObjects* _tmp26_;
	RygelMediaObjects* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	guint32 count;
	RygelMediaObjects* _object_list;
	RygelMediaObjects* _tmp30_;
	RygelMediaObjects* _tmp31_;
	gint _object_size;
	RygelMediaObjects* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	gint _object_index;
	gint _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	RygelMediaObject* object;
	RygelMediaObjects* _tmp38_;
	gint _tmp39_;
	gpointer _tmp40_;
	RygelMediaObject* _tmp41_;
	guint32 _tmp42_;
	RygelMediaObject* _tmp43_;
	RygelMediaContainer* container;
	RygelMediaObject* _tmp44_;
	RygelMediaContainer* _tmp45_;
	RygelMediaContainer* _tmp46_;
	RygelMediaContainer* _tmp47_;
	guint _tmp48_;
	guint _tmp49_;
	RygelMediaContainer* _tmp50_;
	guint32 _tmp51_;
	guint32 _tmp52_;
	RygelMediaServerPlugin* _tmp53_;
	const gchar* _tmp54_;
	GError* _error_;
	GError * _inner_error_;
};

struct _RygelDLNAProfile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelDLNAProfilePrivate * priv;
	gchar* mime;
	gchar* name;
};

struct _RygelDLNAProfileClass {
	GTypeClass parent_class;
	void (*finalize) (RygelDLNAProfile *self);
};


static gpointer rygel_content_directory_parent_class = NULL;

GQuark rygel_content_directory_error_quark (void);
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_import_resource_get_type (void) G_GNUC_CONST;
GType rygel_last_change_get_type (void) G_GNUC_CONST;
#define RYGEL_CONTENT_DIRECTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryPrivate))
enum  {
	RYGEL_CONTENT_DIRECTORY_DUMMY_PROPERTY
};
#define RYGEL_CONTENT_DIRECTORY_UPNP_ID "urn:upnp-org:serviceId:ContentDirectory"
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE "urn:schemas-upnp-org:service:ContentDirectory:3"
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE_V1 "urn:schemas-upnp-org:service:ContentDirectory:1"
#define RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH "xml/ContentDirectory.xml"
#define RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH_NO_TRACK "xml/ContentDirectory-NoTrack.xml"
static void rygel_content_directory_real_constructed (GObject* base);
GType rygel_media_server_plugin_get_type (void) G_GNUC_CONST;
RygelMediaContainer* rygel_media_server_plugin_get_root_container (RygelMediaServerPlugin* self);
RygelHTTPServer* rygel_http_server_new (RygelContentDirectory* content_dir, const gchar* name);
RygelHTTPServer* rygel_http_server_construct (GType object_type, RygelContentDirectory* content_dir, const gchar* name);
static gboolean __lambda3_ (RygelContentDirectory* self, RygelMediaContainer* a, RygelMediaContainer* b);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
static gboolean ___lambda3__gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
GType rygel_trackable_container_get_type (void) G_GNUC_CONST;
gchar* rygel_trackable_container_get_service_reset_token (RygelTrackableContainer* self);
guint32 rygel_trackable_container_get_system_update_id (RygelTrackableContainer* self);
GType rygel_object_event_type_get_type (void) G_GNUC_CONST;
static void rygel_content_directory_on_container_updated (RygelContentDirectory* self, RygelMediaContainer* root_container, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static void _rygel_content_directory_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self);
static void rygel_content_directory_on_sub_tree_updates_finished (RygelContentDirectory* self, RygelMediaContainer* root_container, RygelMediaObject* sub_tree_root);
static void _rygel_content_directory_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished (RygelMediaContainer* _sender, RygelMediaObject* sub_tree_root, gpointer self);
RygelLastChange* rygel_last_change_new (void);
RygelLastChange* rygel_last_change_construct (GType object_type);
#define RYGEL_RELATIONAL_EXPRESSION_CAPS "@id,@parentID,@refID,upnp:class," "dc:title,upnp:artist,upnp:album," "dc:creator,upnp:createClass,@childCount"
static void rygel_content_directory_browse_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_browse_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_search_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_search_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_create_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_create_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_create_reference_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_create_reference_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_destroy_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_destroy_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_update_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_update_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_import_resource_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_import_resource_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_get_transfer_progress_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_transfer_progress_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_stop_transfer_resource_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_stop_transfer_resource_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_get_dlna_upload_profiles_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_dlna_upload_profiles_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_transfer_ids (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_transfer_ids_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_system_update_id_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_system_update_id_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_system_update_id (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_system_update_id_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_query_container_update_ids (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_container_update_ids_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_search_capabilities_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_search_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_search_capabilities (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_search_capabilities_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_sort_capabilities_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_sort_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_sort_capabilities (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_sort_capabilities_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_feature_list_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_feature_list_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_feature_list (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_feature_list_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_query_last_change (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_last_change_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_query_service_reset_token (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_service_reset_token_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_service_reset_token_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_service_reset_token_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
GType rygel_browse_get_type (void) G_GNUC_CONST;
static GUPnPServiceAction* _vala_GUPnPServiceAction_copy (GUPnPServiceAction* self);
RygelBrowse* rygel_browse_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelBrowse* rygel_browse_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_search_get_type (void) G_GNUC_CONST;
RygelSearch* rygel_search_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelSearch* rygel_search_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_object_creator_get_type (void) G_GNUC_CONST;
RygelObjectCreator* rygel_object_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelObjectCreator* rygel_object_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_reference_creator_get_type (void) G_GNUC_CONST;
RygelReferenceCreator* rygel_reference_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelReferenceCreator* rygel_reference_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_item_destroyer_get_type (void) G_GNUC_CONST;
RygelItemDestroyer* rygel_item_destroyer_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelItemDestroyer* rygel_item_destroyer_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_item_updater_get_type (void) G_GNUC_CONST;
RygelItemUpdater* rygel_item_updater_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelItemUpdater* rygel_item_updater_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelImportResource* rygel_import_resource_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelImportResource* rygel_import_resource_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
static void rygel_content_directory_on_import_completed (RygelContentDirectory* self, RygelStateMachine* machine);
static void _rygel_content_directory_on_import_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
static gchar* rygel_content_directory_create_transfer_ids (RygelContentDirectory* self);
static RygelImportResource* rygel_content_directory_find_import_for_action (RygelContentDirectory* self, GUPnPServiceAction* action, GError** error);
const gchar* rygel_import_resource_get_status_as_string (RygelImportResource* self);
GType rygel_transfer_status_get_type (void) G_GNUC_CONST;
static gchar* rygel_content_directory_create_container_update_ids (RygelContentDirectory* self);
#define RYGEL_MEDIA_OBJECTS_SORT_CAPS "@id,@parentID,dc:title,upnp:class," "upnp:artist,upnp:author,upnp:album," "dc:date,upnp:originalTrackNumber"
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
static gboolean rygel_content_directory_handle_system_update (RygelContentDirectory* self);
static void rygel_content_directory_service_reset (RygelContentDirectory* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_content_directory_service_reset_finish (RygelContentDirectory* self, GAsyncResult* _res_);
static void rygel_content_directory_handle_last_change (RygelContentDirectory* self, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static void rygel_content_directory_add_last_change_entry (RygelContentDirectory* self, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update);
static gboolean rygel_content_directory_set_update_ids (RygelContentDirectory* self, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
void rygel_media_object_set_object_update_id (RygelMediaObject* self, guint value);
static void rygel_content_directory_handle_container_update_ids (RygelContentDirectory* self, RygelMediaContainer* updated_container, RygelMediaObject* object);
static void rygel_content_directory_ensure_timeout (RygelContentDirectory* self);
GType rygel_last_change_entry_get_type (void) G_GNUC_CONST;
GType rygel_last_change_st_done_get_type (void) G_GNUC_CONST;
RygelLastChangeStDone* rygel_last_change_st_done_new (const gchar* id, guint update_id);
RygelLastChangeStDone* rygel_last_change_st_done_construct (GType object_type, const gchar* id, guint update_id);
void rygel_last_change_add_event (RygelLastChange* self, RygelLastChangeEntry* entry);
static gboolean rygel_content_directory_update_notify (RygelContentDirectory* self);
gchar* rygel_last_change_get_log (RygelLastChange* self);
void rygel_last_change_clear_on_new_event (RygelLastChange* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean __lambda9_ (Block4Data* _data4_);
static gboolean ___lambda9__gsource_func (gpointer self);
static gboolean _rygel_content_directory_update_notify_gsource_func (gpointer self);
RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self);
const gchar* rygel_media_object_get_upnp_class (RygelMediaObject* self);
RygelLastChangeObjAdd* rygel_last_change_obj_add_new (const gchar* id, guint update_id, gboolean sub_tree_update, const gchar* parent_id, const gchar* upnp_class);
RygelLastChangeObjAdd* rygel_last_change_obj_add_construct (GType object_type, const gchar* id, guint update_id, gboolean sub_tree_update, const gchar* parent_id, const gchar* upnp_class);
GType rygel_last_change_obj_add_get_type (void) G_GNUC_CONST;
RygelLastChangeObjMod* rygel_last_change_obj_mod_new (const gchar* id, guint update_id, gboolean sub_tree_update);
RygelLastChangeObjMod* rygel_last_change_obj_mod_construct (GType object_type, const gchar* id, guint update_id, gboolean sub_tree_update);
GType rygel_last_change_obj_mod_get_type (void) G_GNUC_CONST;
RygelLastChangeObjDel* rygel_last_change_obj_del_new (const gchar* id, guint update_id, gboolean sub_tree_update);
RygelLastChangeObjDel* rygel_last_change_obj_del_construct (GType object_type, const gchar* id, guint update_id, gboolean sub_tree_update);
GType rygel_last_change_obj_del_get_type (void) G_GNUC_CONST;
static void rygel_content_directory_service_reset_data_free (gpointer _data);
static gboolean rygel_content_directory_service_reset_co (RygelContentDirectoryServiceResetData* _data_);
void rygel_trackable_container_set_service_reset_token (RygelTrackableContainer* self, const gchar* token);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_content_directory_service_reset_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
guint rygel_media_object_get_object_update_id (RygelMediaObject* self);
gpointer rygel_dlna_profile_ref (gpointer instance);
void rygel_dlna_profile_unref (gpointer instance);
GParamSpec* rygel_param_spec_dlna_profile (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_dlna_profile (GValue* value, gpointer v_object);
void rygel_value_take_dlna_profile (GValue* value, gpointer v_object);
gpointer rygel_value_get_dlna_profile (const GValue* value);
GType rygel_dlna_profile_get_type (void) G_GNUC_CONST;
GList* rygel_media_server_plugin_get_upload_profiles (RygelMediaServerPlugin* self);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
RygelContentDirectory* rygel_content_directory_new (void);
RygelContentDirectory* rygel_content_directory_construct (GType object_type);
static void rygel_content_directory_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark rygel_content_directory_error_quark (void) {
	return g_quark_from_static_string ("rygel_content_directory_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return self ? g_object_ref (self) : NULL;
#line 770 "rygel-content-directory.c"
}


static gboolean __lambda3_ (RygelContentDirectory* self, RygelMediaContainer* a, RygelMediaContainer* b) {
	gboolean result = FALSE;
	RygelMediaContainer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	RygelMediaContainer* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_val_if_fail (a != NULL, FALSE);
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_val_if_fail (b != NULL, FALSE);
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = a;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp0_);
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = _tmp1_;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp3_ = b;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp3_);
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = _tmp4_;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	result = g_strcmp0 (_tmp2_, _tmp5_) == 0;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return result;
#line 802 "rygel-content-directory.c"
}


static gboolean ___lambda3__gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = __lambda3_ (self, a, b);
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return result;
#line 811 "rygel-content-directory.c"
}


static gchar* uuid_get (void) {
	gchar* result = NULL;
	guchar* id = NULL;
	guchar* _tmp0_ = NULL;
	gint id_length1 = 0;
	gint _id_size_ = 0;
	guchar* unparsed = NULL;
	guchar* _tmp1_ = NULL;
	gint unparsed_length1 = 0;
	gint _unparsed_size_ = 0;
	guchar* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	guchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	guchar* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	guchar _tmp6_ = '\0';
	guchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar* _tmp8_ = NULL;
#line 8 "../../src/librygel-core/uuid.vapi"
	_tmp0_ = g_new0 (guchar, 16);
#line 8 "../../src/librygel-core/uuid.vapi"
	id = _tmp0_;
#line 8 "../../src/librygel-core/uuid.vapi"
	id_length1 = 16;
#line 8 "../../src/librygel-core/uuid.vapi"
	_id_size_ = id_length1;
#line 9 "../../src/librygel-core/uuid.vapi"
	_tmp1_ = g_new0 (guchar, 51);
#line 9 "../../src/librygel-core/uuid.vapi"
	unparsed = _tmp1_;
#line 9 "../../src/librygel-core/uuid.vapi"
	unparsed_length1 = 51;
#line 9 "../../src/librygel-core/uuid.vapi"
	_unparsed_size_ = unparsed_length1;
#line 11 "../../src/librygel-core/uuid.vapi"
	_tmp2_ = id;
#line 11 "../../src/librygel-core/uuid.vapi"
	_tmp2__length1 = id_length1;
#line 11 "../../src/librygel-core/uuid.vapi"
	uuid_generate (_tmp2_);
#line 12 "../../src/librygel-core/uuid.vapi"
	_tmp3_ = id;
#line 12 "../../src/librygel-core/uuid.vapi"
	_tmp3__length1 = id_length1;
#line 12 "../../src/librygel-core/uuid.vapi"
	_tmp4_ = unparsed;
#line 12 "../../src/librygel-core/uuid.vapi"
	_tmp4__length1 = unparsed_length1;
#line 12 "../../src/librygel-core/uuid.vapi"
	uuid_unparse (_tmp3_, _tmp4_);
#line 13 "../../src/librygel-core/uuid.vapi"
	_tmp5_ = unparsed;
#line 13 "../../src/librygel-core/uuid.vapi"
	_tmp5__length1 = unparsed_length1;
#line 13 "../../src/librygel-core/uuid.vapi"
	_tmp5_[50] = (guchar) '\0';
#line 13 "../../src/librygel-core/uuid.vapi"
	_tmp6_ = _tmp5_[50];
#line 15 "../../src/librygel-core/uuid.vapi"
	_tmp7_ = unparsed;
#line 15 "../../src/librygel-core/uuid.vapi"
	_tmp7__length1 = unparsed_length1;
#line 15 "../../src/librygel-core/uuid.vapi"
	_tmp8_ = g_strdup ((const gchar*) _tmp7_);
#line 15 "../../src/librygel-core/uuid.vapi"
	result = _tmp8_;
#line 15 "../../src/librygel-core/uuid.vapi"
	unparsed = (g_free (unparsed), NULL);
#line 15 "../../src/librygel-core/uuid.vapi"
	id = (g_free (id), NULL);
#line 15 "../../src/librygel-core/uuid.vapi"
	return result;
#line 891 "rygel-content-directory.c"
}


static void _rygel_content_directory_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self) {
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_on_container_updated (self, _sender, container, object, event_type, sub_tree_update);
#line 898 "rygel-content-directory.c"
}


static void _rygel_content_directory_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished (RygelMediaContainer* _sender, RygelMediaObject* sub_tree_root, gpointer self) {
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_on_sub_tree_updates_finished (self, _sender, sub_tree_root);
#line 905 "rygel-content-directory.c"
}


static void _rygel_content_directory_browse_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_browse_cb (self, _sender, action);
#line 912 "rygel-content-directory.c"
}


static void _rygel_content_directory_search_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_search_cb (self, _sender, action);
#line 919 "rygel-content-directory.c"
}


static void _rygel_content_directory_create_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_create_object_cb (self, _sender, action);
#line 926 "rygel-content-directory.c"
}


static void _rygel_content_directory_create_reference_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_create_reference_cb (self, _sender, action);
#line 933 "rygel-content-directory.c"
}


static void _rygel_content_directory_destroy_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_destroy_object_cb (self, _sender, action);
#line 940 "rygel-content-directory.c"
}


static void _rygel_content_directory_update_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_update_object_cb (self, _sender, action);
#line 947 "rygel-content-directory.c"
}


static void _rygel_content_directory_import_resource_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_import_resource_cb (self, _sender, action);
#line 954 "rygel-content-directory.c"
}


static void _rygel_content_directory_get_transfer_progress_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_get_transfer_progress_cb (self, _sender, action);
#line 961 "rygel-content-directory.c"
}


static void _rygel_content_directory_stop_transfer_resource_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_stop_transfer_resource_cb (self, _sender, action);
#line 968 "rygel-content-directory.c"
}


static void _rygel_content_directory_get_dlna_upload_profiles_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_get_dlna_upload_profiles_cb (self, _sender, action);
#line 975 "rygel-content-directory.c"
}


static void _rygel_content_directory_query_transfer_ids_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_query_transfer_ids (self, _sender, variable, value);
#line 982 "rygel-content-directory.c"
}


static void _rygel_content_directory_get_system_update_id_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_get_system_update_id_cb (self, _sender, action);
#line 989 "rygel-content-directory.c"
}


static void _rygel_content_directory_query_system_update_id_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_query_system_update_id (self, _sender, variable, value);
#line 996 "rygel-content-directory.c"
}


static void _rygel_content_directory_query_container_update_ids_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_query_container_update_ids (self, _sender, variable, value);
#line 1003 "rygel-content-directory.c"
}


static void _rygel_content_directory_get_search_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_get_search_capabilities_cb (self, _sender, action);
#line 1010 "rygel-content-directory.c"
}


static void _rygel_content_directory_query_search_capabilities_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_query_search_capabilities (self, _sender, variable, value);
#line 1017 "rygel-content-directory.c"
}


static void _rygel_content_directory_get_sort_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_get_sort_capabilities_cb (self, _sender, action);
#line 1024 "rygel-content-directory.c"
}


static void _rygel_content_directory_query_sort_capabilities_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_query_sort_capabilities (self, _sender, variable, value);
#line 1031 "rygel-content-directory.c"
}


static void _rygel_content_directory_get_feature_list_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_get_feature_list_cb (self, _sender, action);
#line 1038 "rygel-content-directory.c"
}


static void _rygel_content_directory_query_feature_list_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_query_feature_list (self, _sender, variable, value);
#line 1045 "rygel-content-directory.c"
}


static void _rygel_content_directory_query_last_change_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_query_last_change (self, _sender, variable, value);
#line 1052 "rygel-content-directory.c"
}


static void _rygel_content_directory_query_service_reset_token_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_query_service_reset_token (self, _sender, variable, value);
#line 1059 "rygel-content-directory.c"
}


static void _rygel_content_directory_get_service_reset_token_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_get_service_reset_token_cb (self, _sender, action);
#line 1066 "rygel-content-directory.c"
}


static void rygel_content_directory_real_constructed (GObject* base) {
	RygelContentDirectory * self;
	GCancellable* _tmp0_ = NULL;
	RygelMediaServerPlugin* plugin = NULL;
	GUPnPRootDevice* _tmp1_ = NULL;
	GUPnPRootDevice* _tmp2_ = NULL;
	GUPnPRootDevice* _tmp3_ = NULL;
	GUPnPResourceFactory* _tmp4_ = NULL;
	GUPnPResourceFactory* _tmp5_ = NULL;
	RygelMediaServerPlugin* _tmp6_ = NULL;
	RygelMediaServerPlugin* _tmp7_ = NULL;
	RygelMediaServerPlugin* _tmp8_ = NULL;
	RygelMediaContainer* _tmp9_ = NULL;
	RygelMediaContainer* _tmp10_ = NULL;
	RygelMediaContainer* _tmp11_ = NULL;
	RygelMediaServerPlugin* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	RygelHTTPServer* _tmp15_ = NULL;
	GeeArrayList* _tmp16_ = NULL;
	GeeArrayList* _tmp17_ = NULL;
	GeeArrayList* _tmp18_ = NULL;
	RygelMediaContainer* _tmp19_ = NULL;
	RygelMediaContainer* _tmp27_ = NULL;
	RygelMediaContainer* _tmp28_ = NULL;
	RygelLastChange* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	RygelMediaServerPlugin* _tmp31_ = NULL;
	RygelPluginCapabilities _tmp32_ = 0;
	RygelPluginCapabilities _tmp33_ = 0;
	gchar* _tmp36_ = NULL;
	RygelHTTPServer* _tmp37_ = NULL;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self = (RygelContentDirectory*) base;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	G_OBJECT_CLASS (rygel_content_directory_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gupnp_service_get_type (), GUPnPService));
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = g_cancellable_new ();
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->cancellable);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->cancellable = _tmp0_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_object_get ((GUPnPService*) self, "root-device", &_tmp1_, NULL);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = _tmp1_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp3_ = _tmp2_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp3_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = _tmp4_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, RYGEL_TYPE_MEDIA_SERVER_PLUGIN) ? ((RygelMediaServerPlugin*) _tmp5_) : NULL);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp7_ = _tmp6_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (_tmp3_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	plugin = _tmp7_;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp8_ = plugin;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp9_ = rygel_media_server_plugin_get_root_container (_tmp8_);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp10_ = _tmp9_;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp11_ = _g_object_ref0 (_tmp10_);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->root_container);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->root_container = _tmp11_;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp12_ = plugin;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp13_ = rygel_plugin_get_name ((RygelPlugin*) _tmp12_);
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp14_ = _tmp13_;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp15_ = rygel_http_server_new (self, _tmp14_);
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->http_server);
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->http_server = _tmp15_;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp16_ = gee_array_list_new (RYGEL_TYPE_MEDIA_CONTAINER, (GBoxedCopyFunc) g_object_ref, g_object_unref, ___lambda3__gee_equal_data_func, g_object_ref (self), g_object_unref);
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->priv->updated_containers);
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->priv->updated_containers = _tmp16_;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp17_ = gee_array_list_new (RYGEL_TYPE_IMPORT_RESOURCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->priv->active_imports);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->priv->active_imports = _tmp17_;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp18_ = gee_array_list_new (RYGEL_TYPE_IMPORT_RESOURCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->priv->finished_imports);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->priv->finished_imports = _tmp18_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp19_ = self->root_container;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
#line 1176 "rygel-content-directory.c"
		RygelTrackableContainer* trackable = NULL;
		RygelMediaContainer* _tmp20_ = NULL;
		RygelTrackableContainer* _tmp21_ = NULL;
		RygelTrackableContainer* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		RygelTrackableContainer* _tmp24_ = NULL;
		guint32 _tmp25_ = 0U;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp20_ = self->root_container;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, RYGEL_TYPE_TRACKABLE_CONTAINER) ? ((RygelTrackableContainer*) _tmp20_) : NULL);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		trackable = _tmp21_;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp22_ = trackable;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp23_ = rygel_trackable_container_get_service_reset_token (_tmp22_);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_free0 (self->priv->service_reset_token);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		self->priv->service_reset_token = _tmp23_;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp24_ = trackable;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp25_ = rygel_trackable_container_get_system_update_id (_tmp24_);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		self->system_update_id = _tmp25_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (trackable);
#line 1206 "rygel-content-directory.c"
	} else {
		gchar* _tmp26_ = NULL;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp26_ = uuid_get ();
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_free0 (self->priv->service_reset_token);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		self->priv->service_reset_token = _tmp26_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		self->system_update_id = (guint32) 0;
#line 1217 "rygel-content-directory.c"
	}
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp27_ = self->root_container;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object (_tmp27_, "container-updated", (GCallback) _rygel_content_directory_on_container_updated_rygel_media_container_container_updated, self, 0);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp28_ = self->root_container;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object (_tmp28_, "sub-tree-updates-finished", (GCallback) _rygel_content_directory_on_sub_tree_updates_finished_rygel_media_container_sub_tree_updates_finished, self, 0);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp29_ = rygel_last_change_new ();
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->priv->last_change);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->priv->last_change = _tmp29_;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp30_ = g_strdup (RYGEL_RELATIONAL_EXPRESSION_CAPS);
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (self->priv->search_caps);
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->priv->search_caps = _tmp30_;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp31_ = plugin;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp32_ = rygel_plugin_get_capabilities ((RygelPlugin*) _tmp31_);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp33_ = _tmp32_;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if ((_tmp33_ & RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) == RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) {
#line 1247 "rygel-content-directory.c"
		const gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp34_ = self->priv->search_caps;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp35_ = g_strconcat (_tmp34_, ",upnp:objectUpdateID,upnp:containerUpdateID", NULL);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_free0 (self->priv->search_caps);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		self->priv->search_caps = _tmp35_;
#line 1258 "rygel-content-directory.c"
	}
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp36_ = g_strdup ("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" "<Features xmlns=\"urn:schemas-upnp-org:av:avs\" " "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " "xsi:schemaLocation=\"urn:schemas-upnp-org:av:avs" "http://www.upnp.org/schemas/av/avs-v1-20060531.xsd\">" "</Features>");
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (self->feature_list);
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->feature_list = _tmp36_;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Browse", (GCallback) _rygel_content_directory_browse_cb_gupnp_service_action_invoked, self, 0);
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Search", (GCallback) _rygel_content_directory_search_cb_gupnp_service_action_invoked, self, 0);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::CreateObject", (GCallback) _rygel_content_directory_create_object_cb_gupnp_service_action_invoked, self, 0);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::CreateReference", (GCallback) _rygel_content_directory_create_reference_cb_gupnp_service_action_invoked, self, 0);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::DestroyObject", (GCallback) _rygel_content_directory_destroy_object_cb_gupnp_service_action_invoked, self, 0);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::UpdateObject", (GCallback) _rygel_content_directory_update_object_cb_gupnp_service_action_invoked, self, 0);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::ImportResource", (GCallback) _rygel_content_directory_import_resource_cb_gupnp_service_action_invoked, self, 0);
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransferProgress", (GCallback) _rygel_content_directory_get_transfer_progress_cb_gupnp_service_action_invoked, self, 0);
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::StopTransferResource", (GCallback) _rygel_content_directory_stop_transfer_resource_cb_gupnp_service_action_invoked, self, 0);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::X_GetDLNAUploadProfiles", (GCallback) _rygel_content_directory_get_dlna_upload_profiles_cb_gupnp_service_action_invoked, self, 0);
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::TransferIDs", (GCallback) _rygel_content_directory_query_transfer_ids_gupnp_service_query_variable, self, 0);
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetSystemUpdateID", (GCallback) _rygel_content_directory_get_system_update_id_cb_gupnp_service_action_invoked, self, 0);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::SystemUpdateID", (GCallback) _rygel_content_directory_query_system_update_id_gupnp_service_query_variable, self, 0);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::ContainerUpdateIDs", (GCallback) _rygel_content_directory_query_container_update_ids_gupnp_service_query_variable, self, 0);
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetSearchCapabilities", (GCallback) _rygel_content_directory_get_search_capabilities_cb_gupnp_service_action_invoked, self, 0);
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::SearchCapabilities", (GCallback) _rygel_content_directory_query_search_capabilities_gupnp_service_query_variable, self, 0);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetSortCapabilities", (GCallback) _rygel_content_directory_get_sort_capabilities_cb_gupnp_service_action_invoked, self, 0);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::SortCapabilities", (GCallback) _rygel_content_directory_query_sort_capabilities_gupnp_service_query_variable, self, 0);
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetFeatureList", (GCallback) _rygel_content_directory_get_feature_list_cb_gupnp_service_action_invoked, self, 0);
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::FeatureList", (GCallback) _rygel_content_directory_query_feature_list_gupnp_service_query_variable, self, 0);
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::LastChange", (GCallback) _rygel_content_directory_query_last_change_gupnp_service_query_variable, self, 0);
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::ServiceResetToken", (GCallback) _rygel_content_directory_query_service_reset_token_gupnp_service_query_variable, self, 0);
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetServiceResetToken", (GCallback) _rygel_content_directory_get_service_reset_token_cb_gupnp_service_action_invoked, self, 0);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp37_ = self->http_server;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_state_machine_run ((RygelStateMachine*) _tmp37_, NULL, NULL);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (plugin);
#line 1318 "rygel-content-directory.c"
}


static GUPnPServiceAction* _vala_GUPnPServiceAction_copy (GUPnPServiceAction* self) {
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return g_boxed_copy (gupnp_service_action_get_type (), self);
#line 1325 "rygel-content-directory.c"
}


static gpointer __vala_GUPnPServiceAction_copy0 (gpointer self) {
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return self ? _vala_GUPnPServiceAction_copy (self) : NULL;
#line 1332 "rygel-content-directory.c"
}


static void rygel_content_directory_browse_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	RygelBrowse* browse = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	RygelBrowse* _tmp2_ = NULL;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = rygel_browse_new (self, _tmp1_);
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	browse = _tmp2_;
#line 200 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_state_machine_run ((RygelStateMachine*) browse, NULL, NULL);
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (browse);
#line 1359 "rygel-content-directory.c"
}


static void rygel_content_directory_search_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	RygelSearch* search = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	RygelSearch* _tmp2_ = NULL;
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = rygel_search_new (self, _tmp1_);
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	search = _tmp2_;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_state_machine_run ((RygelStateMachine*) search, NULL, NULL);
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (search);
#line 1386 "rygel-content-directory.c"
}


static void rygel_content_directory_create_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	RygelObjectCreator* creator = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	RygelObjectCreator* _tmp2_ = NULL;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = rygel_object_creator_new (self, _tmp1_);
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	creator = _tmp2_;
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_state_machine_run ((RygelStateMachine*) creator, NULL, NULL);
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (creator);
#line 1413 "rygel-content-directory.c"
}


static void rygel_content_directory_create_reference_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	RygelReferenceCreator* creator = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	RygelReferenceCreator* _tmp2_ = NULL;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = rygel_reference_creator_new (self, _tmp1_);
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	creator = _tmp2_;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_state_machine_run ((RygelStateMachine*) creator, NULL, NULL);
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (creator);
#line 1440 "rygel-content-directory.c"
}


static void rygel_content_directory_destroy_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	RygelItemDestroyer* destroyer = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	RygelItemDestroyer* _tmp2_ = NULL;
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = rygel_item_destroyer_new (self, _tmp1_);
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	destroyer = _tmp2_;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_state_machine_run ((RygelStateMachine*) destroyer, NULL, NULL);
#line 228 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (destroyer);
#line 1467 "rygel-content-directory.c"
}


static void rygel_content_directory_update_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	RygelItemUpdater* updater = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	RygelItemUpdater* _tmp2_ = NULL;
#line 236 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 236 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 236 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 238 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 238 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
#line 238 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = rygel_item_updater_new (self, _tmp1_);
#line 238 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	updater = _tmp2_;
#line 240 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_state_machine_run ((RygelStateMachine*) updater, NULL, NULL);
#line 236 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (updater);
#line 1494 "rygel-content-directory.c"
}


static void _rygel_content_directory_on_import_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_on_import_completed (self, _sender);
#line 1501 "rygel-content-directory.c"
}


static void rygel_content_directory_import_resource_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	RygelImportResource* import = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	RygelImportResource* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 244 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 244 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 244 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 246 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 246 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
#line 246 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = rygel_import_resource_new (self, _tmp1_);
#line 246 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	import = _tmp2_;
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_signal_connect_object ((RygelStateMachine*) import, "completed", (GCallback) _rygel_content_directory_on_import_completed_rygel_state_machine_completed, self, 0);
#line 249 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp3_ = self->priv->active_imports;
#line 249 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, import);
#line 251 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_state_machine_run ((RygelStateMachine*) import, NULL, NULL);
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = rygel_content_directory_create_transfer_ids (self);
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = _tmp4_;
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_notify ((GUPnPService*) self, "TransferIDs", G_TYPE_STRING, _tmp5_, NULL);
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (_tmp5_);
#line 244 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (import);
#line 1545 "rygel-content-directory.c"
}


static void rygel_content_directory_query_transfer_ids (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (variable != NULL);
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (value != NULL);
#line 262 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_init (value, G_TYPE_STRING);
#line 263 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = rygel_content_directory_create_transfer_ids (self);
#line 263 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = _tmp0_;
#line 263 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_set_string (value, _tmp1_);
#line 263 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (_tmp1_);
#line 1570 "rygel-content-directory.c"
}


static void rygel_content_directory_get_transfer_progress_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GError * _inner_error_ = NULL;
#line 267 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 267 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 267 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 269 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 269 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 269 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp1_ != ((guint) 1)) {
#line 1590 "rygel-content-directory.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = action;
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp3_ = _ ("Invalid argument");
#line 270 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 272 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return;
#line 1601 "rygel-content-directory.c"
	}
	{
		RygelImportResource* import = NULL;
		GUPnPServiceAction* _tmp4_ = NULL;
		RygelImportResource* _tmp5_ = NULL;
		GUPnPServiceAction* _tmp6_ = NULL;
		RygelImportResource* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		RygelImportResource* _tmp10_ = NULL;
		gint64 _tmp11_ = 0LL;
		RygelImportResource* _tmp12_ = NULL;
		gint64 _tmp13_ = 0LL;
		GUPnPServiceAction* _tmp14_ = NULL;
#line 276 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp4_ = action;
#line 276 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp5_ = rygel_content_directory_find_import_for_action (self, _tmp4_, &_inner_error_);
#line 276 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		import = _tmp5_;
#line 276 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		if (_inner_error_ != NULL) {
#line 1624 "rygel-content-directory.c"
			goto __catch22_g_error;
		}
#line 278 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp6_ = action;
#line 278 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp7_ = import;
#line 278 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp8_ = rygel_import_resource_get_status_as_string (_tmp7_);
#line 278 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp9_ = _tmp8_;
#line 278 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp10_ = import;
#line 278 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp11_ = _tmp10_->bytes_copied;
#line 278 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp12_ = import;
#line 278 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp13_ = _tmp12_->bytes_total;
#line 278 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_set (_tmp6_, "TransferStatus", G_TYPE_STRING, _tmp9_, "TransferLength", G_TYPE_INT64, _tmp11_, "TransferTotal", G_TYPE_INT64, _tmp13_, NULL);
#line 288 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp14_ = action;
#line 288 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_return (_tmp14_);
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (import);
#line 1651 "rygel-content-directory.c"
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError* _error_ = NULL;
		GUPnPServiceAction* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_error_ = _inner_error_;
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_inner_error_ = NULL;
#line 290 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp15_ = action;
#line 290 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp16_ = _error_;
#line 290 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp17_ = _tmp16_->code;
#line 290 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp18_ = _error_;
#line 290 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp19_ = _tmp18_->message;
#line 290 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp15_, (guint) _tmp17_, _tmp19_);
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_error_free0 (_error_);
#line 1680 "rygel-content-directory.c"
	}
	__finally22:
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_inner_error_ != NULL) {
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_clear_error (&_inner_error_);
#line 275 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return;
#line 1691 "rygel-content-directory.c"
	}
}


static void rygel_content_directory_stop_transfer_resource_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GError * _inner_error_ = NULL;
#line 295 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 295 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 295 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp1_ != ((guint) 1)) {
#line 1712 "rygel-content-directory.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = action;
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp3_ = _ ("Invalid argument");
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 300 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return;
#line 1723 "rygel-content-directory.c"
	}
	{
		RygelImportResource* import = NULL;
		GUPnPServiceAction* _tmp4_ = NULL;
		RygelImportResource* _tmp5_ = NULL;
		RygelImportResource* _tmp6_ = NULL;
		GCancellable* _tmp7_ = NULL;
		GCancellable* _tmp8_ = NULL;
		GUPnPServiceAction* _tmp9_ = NULL;
#line 304 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp4_ = action;
#line 304 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp5_ = rygel_content_directory_find_import_for_action (self, _tmp4_, &_inner_error_);
#line 304 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		import = _tmp5_;
#line 304 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		if (_inner_error_ != NULL) {
#line 1741 "rygel-content-directory.c"
			goto __catch23_g_error;
		}
#line 305 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp6_ = import;
#line 305 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp7_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _tmp6_);
#line 305 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp8_ = _tmp7_;
#line 305 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_cancellable_cancel (_tmp8_);
#line 307 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp9_ = action;
#line 307 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_return (_tmp9_);
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (import);
#line 1758 "rygel-content-directory.c"
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError* _error_ = NULL;
		GUPnPServiceAction* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_error_ = _inner_error_;
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_inner_error_ = NULL;
#line 309 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp10_ = action;
#line 309 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp11_ = _error_;
#line 309 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp12_ = _tmp11_->code;
#line 309 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp13_ = _error_;
#line 309 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp14_ = _tmp13_->message;
#line 309 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp10_, (guint) _tmp12_, _tmp14_);
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_error_free0 (_error_);
#line 1787 "rygel-content-directory.c"
	}
	__finally23:
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_inner_error_ != NULL) {
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_clear_error (&_inner_error_);
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return;
#line 1798 "rygel-content-directory.c"
	}
}


static void rygel_content_directory_get_system_update_id_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	guint32 _tmp5_ = 0U;
	GUPnPServiceAction* _tmp6_ = NULL;
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 316 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 316 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 316 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 1821 "rygel-content-directory.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = action;
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp3_ = _ ("Invalid argument");
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return;
#line 1832 "rygel-content-directory.c"
	}
#line 323 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = action;
#line 323 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = self->system_update_id;
#line 323 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_set (_tmp4_, "Id", G_TYPE_UINT, _tmp5_, NULL);
#line 325 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp6_ = action;
#line 325 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_return (_tmp6_);
#line 1844 "rygel-content-directory.c"
}


static void rygel_content_directory_query_system_update_id (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	guint32 _tmp0_ = 0U;
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (variable != NULL);
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (value != NULL);
#line 333 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_init (value, G_TYPE_UINT);
#line 334 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = self->system_update_id;
#line 334 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_set_uint (value, (guint) _tmp0_);
#line 1864 "rygel-content-directory.c"
}


static void rygel_content_directory_query_container_update_ids (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	gchar* update_ids = NULL;
	gchar* _tmp0_ = NULL;
#line 338 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 338 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 338 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (variable != NULL);
#line 338 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (value != NULL);
#line 341 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = rygel_content_directory_create_container_update_ids (self);
#line 341 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	update_ids = _tmp0_;
#line 344 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_init (value, G_TYPE_STRING);
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_set_string (value, update_ids);
#line 338 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (update_ids);
#line 1889 "rygel-content-directory.c"
}


static void rygel_content_directory_get_search_capabilities_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GUPnPServiceAction* _tmp6_ = NULL;
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 351 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 351 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 351 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 1911 "rygel-content-directory.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 352 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = action;
#line 352 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp3_ = _ ("Invalid argument");
#line 352 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 354 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return;
#line 1922 "rygel-content-directory.c"
	}
#line 358 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = action;
#line 358 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = self->priv->search_caps;
#line 358 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_set (_tmp4_, "SearchCaps", G_TYPE_STRING, _tmp5_, NULL);
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp6_ = action;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_return (_tmp6_);
#line 1934 "rygel-content-directory.c"
}


static void rygel_content_directory_query_search_capabilities (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	const gchar* _tmp0_ = NULL;
#line 364 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 364 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 364 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (variable != NULL);
#line 364 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (value != NULL);
#line 368 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_init (value, G_TYPE_STRING);
#line 369 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = self->priv->search_caps;
#line 369 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_set_string (value, _tmp0_);
#line 1954 "rygel-content-directory.c"
}


static void rygel_content_directory_get_sort_capabilities_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	GUPnPServiceAction* _tmp5_ = NULL;
#line 373 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 373 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 373 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 1975 "rygel-content-directory.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 377 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = action;
#line 377 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp3_ = _ ("Invalid argument");
#line 377 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return;
#line 1986 "rygel-content-directory.c"
	}
#line 383 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = action;
#line 383 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_set (_tmp4_, "SortCaps", G_TYPE_STRING, RYGEL_MEDIA_OBJECTS_SORT_CAPS, NULL);
#line 385 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = action;
#line 385 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_return (_tmp5_);
#line 1996 "rygel-content-directory.c"
}


static void rygel_content_directory_query_sort_capabilities (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
#line 389 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 389 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 389 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (variable != NULL);
#line 389 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (value != NULL);
#line 393 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_init (value, G_TYPE_STRING);
#line 394 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_set_string (value, RYGEL_MEDIA_OBJECTS_SORT_CAPS);
#line 2013 "rygel-content-directory.c"
}


static void rygel_content_directory_get_feature_list_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GUPnPServiceAction* _tmp6_ = NULL;
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 401 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 401 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 401 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 2035 "rygel-content-directory.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 402 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = action;
#line 402 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp3_ = _ ("Invalid argument");
#line 402 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 404 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return;
#line 2046 "rygel-content-directory.c"
	}
#line 408 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = action;
#line 408 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = self->feature_list;
#line 408 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_set (_tmp4_, "FeatureList", G_TYPE_STRING, _tmp5_, NULL);
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp6_ = action;
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_return (_tmp6_);
#line 2058 "rygel-content-directory.c"
}


static void rygel_content_directory_query_feature_list (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	const gchar* _tmp0_ = NULL;
#line 414 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 414 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 414 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (variable != NULL);
#line 414 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (value != NULL);
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_init (value, G_TYPE_STRING);
#line 419 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = self->feature_list;
#line 419 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_set_string (value, _tmp0_);
#line 2078 "rygel-content-directory.c"
}


static gchar* rygel_content_directory_create_container_update_ids (RygelContentDirectory* self) {
	gchar* result = NULL;
	gchar* update_ids = NULL;
	gchar* _tmp0_ = NULL;
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 423 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = g_strdup ("");
#line 423 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	update_ids = _tmp0_;
#line 2092 "rygel-content-directory.c"
	{
		GeeArrayList* _container_list = NULL;
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		gint _container_size = 0;
		GeeArrayList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _container_index = 0;
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp1_ = self->priv->updated_containers;
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_container_list = _tmp2_;
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp3_ = _container_list;
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp5_ = _tmp4_;
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_container_size = _tmp5_;
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_container_index = -1;
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		while (TRUE) {
#line 2120 "rygel-content-directory.c"
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			RygelMediaContainer* container = NULL;
			GeeArrayList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp15_ = NULL;
			RygelMediaContainer* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			RygelMediaContainer* _tmp21_ = NULL;
			guint32 _tmp22_ = 0U;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp6_ = _container_index;
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_container_index = _tmp6_ + 1;
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp7_ = _container_index;
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp8_ = _container_size;
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				break;
#line 2154 "rygel-content-directory.c"
			}
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp9_ = _container_list;
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp10_ = _container_index;
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			container = (RygelMediaContainer*) _tmp11_;
#line 426 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp12_ = update_ids;
#line 426 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			if (g_strcmp0 (_tmp12_, "") != 0) {
#line 2168 "rygel-content-directory.c"
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
#line 427 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp13_ = update_ids;
#line 427 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp14_ = g_strconcat (_tmp13_, ",", NULL);
#line 427 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_g_free0 (update_ids);
#line 427 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				update_ids = _tmp14_;
#line 2179 "rygel-content-directory.c"
			}
#line 430 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp15_ = update_ids;
#line 430 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp16_ = container;
#line 430 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp17_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp16_);
#line 430 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp18_ = _tmp17_;
#line 430 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp19_ = g_strconcat (_tmp18_, ",", NULL);
#line 430 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp20_ = _tmp19_;
#line 430 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp21_ = container;
#line 430 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp22_ = _tmp21_->update_id;
#line 430 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp23_ = g_strdup_printf ("%u", _tmp22_);
#line 430 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp24_ = _tmp23_;
#line 430 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp25_ = g_strconcat (_tmp20_, _tmp24_, NULL);
#line 430 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp26_ = _tmp25_;
#line 430 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp27_ = g_strconcat (_tmp15_, _tmp26_, NULL);
#line 430 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_free0 (update_ids);
#line 430 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			update_ids = _tmp27_;
#line 430 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_free0 (_tmp26_);
#line 430 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_free0 (_tmp24_);
#line 430 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_free0 (_tmp20_);
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (container);
#line 2219 "rygel-content-directory.c"
		}
#line 425 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (_container_list);
#line 2223 "rygel-content-directory.c"
	}
#line 433 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	result = update_ids;
#line 433 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return result;
#line 2229 "rygel-content-directory.c"
}


static gboolean rygel_content_directory_handle_system_update (RygelContentDirectory* self) {
	gboolean result = FALSE;
	RygelMediaServerPlugin* plugin = NULL;
	GUPnPRootDevice* _tmp0_ = NULL;
	GUPnPRootDevice* _tmp1_ = NULL;
	GUPnPRootDevice* _tmp2_ = NULL;
	GUPnPResourceFactory* _tmp3_ = NULL;
	GUPnPResourceFactory* _tmp4_ = NULL;
	RygelMediaServerPlugin* _tmp5_ = NULL;
	RygelMediaServerPlugin* _tmp6_ = NULL;
	guint32 _tmp7_ = 0U;
	gboolean _tmp8_ = FALSE;
	guint32 _tmp9_ = 0U;
	gboolean _tmp13_ = FALSE;
#line 436 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 437 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL);
#line 437 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = _tmp0_;
#line 437 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = _tmp1_;
#line 437 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp2_);
#line 437 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = _tmp3_;
#line 437 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_MEDIA_SERVER_PLUGIN) ? ((RygelMediaServerPlugin*) _tmp4_) : NULL);
#line 437 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp6_ = _tmp5_;
#line 437 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (_tmp2_);
#line 437 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	plugin = _tmp6_;
#line 442 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp7_ = self->system_update_id;
#line 442 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->system_update_id = _tmp7_ + 1;
#line 443 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp9_ = self->system_update_id;
#line 443 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp9_ == ((guint32) 0)) {
#line 2275 "rygel-content-directory.c"
		RygelMediaServerPlugin* _tmp10_ = NULL;
		RygelPluginCapabilities _tmp11_ = 0;
		RygelPluginCapabilities _tmp12_ = 0;
#line 444 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp10_ = plugin;
#line 444 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp11_ = rygel_plugin_get_capabilities ((RygelPlugin*) _tmp10_);
#line 444 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp12_ = _tmp11_;
#line 444 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp8_ = (_tmp12_ & RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) == RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES;
#line 2287 "rygel-content-directory.c"
	} else {
#line 443 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp8_ = FALSE;
#line 2291 "rygel-content-directory.c"
	}
#line 443 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp13_ = _tmp8_;
#line 443 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp13_) {
#line 447 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		rygel_content_directory_service_reset (self, NULL, NULL);
#line 449 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		result = TRUE;
#line 449 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (plugin);
#line 449 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return result;
#line 2305 "rygel-content-directory.c"
	}
#line 452 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	result = FALSE;
#line 452 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (plugin);
#line 452 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return result;
#line 2313 "rygel-content-directory.c"
}


static void rygel_content_directory_handle_last_change (RygelContentDirectory* self, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update) {
	RygelMediaContainer* _tmp0_ = NULL;
#line 455 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 455 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (updated_container != NULL);
#line 455 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (object != NULL);
#line 459 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = updated_container;
#line 459 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
#line 2329 "rygel-content-directory.c"
		RygelMediaObject* _tmp1_ = NULL;
		RygelObjectEventType _tmp2_ = 0;
		gboolean _tmp3_ = FALSE;
#line 460 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp1_ = object;
#line 460 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = event_type;
#line 460 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp3_ = sub_tree_update;
#line 460 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		rygel_content_directory_add_last_change_entry (self, _tmp1_, _tmp2_, _tmp3_);
#line 2341 "rygel-content-directory.c"
	}
}


static gboolean rygel_content_directory_set_update_ids (RygelContentDirectory* self, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type) {
	gboolean result = FALSE;
	gboolean container_changed = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	RygelObjectEventType _tmp2_ = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp9_ = FALSE;
	RygelMediaObject* _tmp12_ = NULL;
	guint32 _tmp13_ = 0U;
	RygelMediaObject* _tmp14_ = NULL;
#line 464 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 464 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_val_if_fail (updated_container != NULL, FALSE);
#line 464 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_val_if_fail (object != NULL, FALSE);
#line 467 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	container_changed = FALSE;
#line 469 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = event_type;
#line 469 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp2_ == RYGEL_OBJECT_EVENT_TYPE_ADDED) {
#line 469 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp1_ = TRUE;
#line 2371 "rygel-content-directory.c"
	} else {
		RygelObjectEventType _tmp3_ = 0;
#line 470 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp3_ = event_type;
#line 470 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp1_ = _tmp3_ == RYGEL_OBJECT_EVENT_TYPE_DELETED;
#line 2378 "rygel-content-directory.c"
	}
#line 469 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = _tmp1_;
#line 469 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp4_) {
#line 469 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp0_ = TRUE;
#line 2386 "rygel-content-directory.c"
	} else {
		gboolean _tmp5_ = FALSE;
		RygelObjectEventType _tmp6_ = 0;
		gboolean _tmp8_ = FALSE;
#line 471 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp6_ = event_type;
#line 471 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		if (_tmp6_ == RYGEL_OBJECT_EVENT_TYPE_MODIFIED) {
#line 2395 "rygel-content-directory.c"
			RygelMediaObject* _tmp7_ = NULL;
#line 472 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp7_ = object;
#line 472 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, RYGEL_TYPE_MEDIA_ITEM);
#line 2401 "rygel-content-directory.c"
		} else {
#line 471 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp5_ = FALSE;
#line 2405 "rygel-content-directory.c"
		}
#line 471 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp8_ = _tmp5_;
#line 471 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp0_ = _tmp8_;
#line 2411 "rygel-content-directory.c"
	}
#line 469 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp9_ = _tmp0_;
#line 469 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp9_) {
#line 2417 "rygel-content-directory.c"
		RygelMediaContainer* _tmp10_ = NULL;
		guint32 _tmp11_ = 0U;
#line 473 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp10_ = updated_container;
#line 473 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp11_ = self->system_update_id;
#line 473 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp10_->update_id = _tmp11_;
#line 474 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		container_changed = TRUE;
#line 2428 "rygel-content-directory.c"
	}
#line 477 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp12_ = object;
#line 477 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp13_ = self->system_update_id;
#line 477 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_media_object_set_object_update_id (_tmp12_, (guint) _tmp13_);
#line 480 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp14_ = object;
#line 480 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, RYGEL_TYPE_MEDIA_CONTAINER)) {
#line 2440 "rygel-content-directory.c"
		RygelMediaObject* _tmp15_ = NULL;
		guint32 _tmp16_ = 0U;
#line 481 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp15_ = object;
#line 481 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp16_ = self->system_update_id;
#line 481 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		(G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp15_) : NULL)->update_id = _tmp16_;
#line 2449 "rygel-content-directory.c"
	}
#line 484 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	result = container_changed;
#line 484 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return result;
#line 2455 "rygel-content-directory.c"
}


static void rygel_content_directory_handle_container_update_ids (RygelContentDirectory* self, RygelMediaContainer* updated_container, RygelMediaObject* object) {
	gboolean updated = FALSE;
	RygelMediaContainer* _tmp0_ = NULL;
	gboolean is_container = FALSE;
	RygelMediaObject* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp13_ = FALSE;
#line 487 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 487 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (object != NULL);
#line 489 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = updated_container;
#line 489 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	updated = _tmp0_ != NULL;
#line 490 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = object;
#line 490 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	is_container = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_MEDIA_CONTAINER);
#line 492 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp3_ = updated;
#line 492 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (!_tmp3_) {
#line 2486 "rygel-content-directory.c"
		gboolean _tmp4_ = FALSE;
#line 492 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp4_ = is_container;
#line 492 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = !_tmp4_;
#line 2492 "rygel-content-directory.c"
	} else {
#line 492 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = FALSE;
#line 2496 "rygel-content-directory.c"
	}
#line 492 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = _tmp2_;
#line 492 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp5_) {
#line 493 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return;
#line 2504 "rygel-content-directory.c"
	}
#line 496 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp6_ = self->priv->clear_updated_containers;
#line 496 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp6_) {
#line 2510 "rygel-content-directory.c"
		GeeArrayList* _tmp7_ = NULL;
#line 497 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp7_ = self->priv->updated_containers;
#line 497 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp7_);
#line 498 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		self->priv->clear_updated_containers = FALSE;
#line 2518 "rygel-content-directory.c"
	}
#line 502 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp8_ = updated;
#line 502 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp8_) {
#line 2524 "rygel-content-directory.c"
		GeeArrayList* _tmp9_ = NULL;
		RygelMediaContainer* _tmp10_ = NULL;
		GeeArrayList* _tmp11_ = NULL;
		RygelMediaContainer* _tmp12_ = NULL;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp9_ = self->priv->updated_containers;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp10_ = updated_container;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp9_, _tmp10_);
#line 504 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp11_ = self->priv->updated_containers;
#line 504 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp12_ = updated_container;
#line 504 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp12_);
#line 2541 "rygel-content-directory.c"
	}
#line 507 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp13_ = is_container;
#line 507 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp13_) {
#line 2547 "rygel-content-directory.c"
		RygelMediaContainer* container = NULL;
		RygelMediaObject* _tmp14_ = NULL;
		RygelMediaContainer* _tmp15_ = NULL;
		GeeArrayList* _tmp16_ = NULL;
		RygelMediaContainer* _tmp17_ = NULL;
		GeeArrayList* _tmp18_ = NULL;
		RygelMediaContainer* _tmp19_ = NULL;
#line 508 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp14_ = object;
#line 508 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp14_) : NULL);
#line 508 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		container = _tmp15_;
#line 510 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp16_ = self->priv->updated_containers;
#line 510 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp17_ = container;
#line 510 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp16_, _tmp17_);
#line 511 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp18_ = self->priv->updated_containers;
#line 511 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp19_ = container;
#line 511 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp19_);
#line 507 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (container);
#line 2575 "rygel-content-directory.c"
	}
}


/**
     * handler for container_updated signal on root_container. We don't
     * immediately send the notification for changes but schedule the
     * notification after 0.2 seconds. Also we don't clear the updated
     * container list immediately after notification but rather in this
     * function. Please refer to ContentDirectory version 2 specs for details
     * on why we do all this the way we do.
     *
     * @param root_container the root_container
     * @param updated_container the container that just got updated
     */
static void rygel_content_directory_on_container_updated (RygelContentDirectory* self, RygelMediaContainer* root_container, RygelMediaContainer* updated_container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update) {
	gboolean _tmp0_ = FALSE;
	RygelMediaContainer* _tmp1_ = NULL;
	RygelMediaObject* _tmp2_ = NULL;
	RygelObjectEventType _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gboolean changed = FALSE;
	RygelMediaContainer* _tmp5_ = NULL;
	RygelMediaObject* _tmp6_ = NULL;
	RygelObjectEventType _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	RygelMediaContainer* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	RygelMediaContainer* _tmp12_ = NULL;
	RygelMediaObject* _tmp13_ = NULL;
#line 526 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 526 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (root_container != NULL);
#line 526 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (updated_container != NULL);
#line 526 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (object != NULL);
#line 531 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = rygel_content_directory_handle_system_update (self);
#line 531 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp0_) {
#line 532 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return;
#line 2620 "rygel-content-directory.c"
	}
#line 534 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = updated_container;
#line 534 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = object;
#line 534 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp3_ = event_type;
#line 534 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = sub_tree_update;
#line 534 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_handle_last_change (self, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 539 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = updated_container;
#line 539 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp6_ = object;
#line 539 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp7_ = event_type;
#line 539 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp8_ = rygel_content_directory_set_update_ids (self, _tmp5_, _tmp6_, _tmp7_);
#line 539 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	changed = _tmp8_;
#line 540 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp10_ = changed;
#line 540 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp10_) {
#line 2646 "rygel-content-directory.c"
		RygelMediaContainer* _tmp11_ = NULL;
#line 540 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp11_ = updated_container;
#line 540 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp9_ = _tmp11_;
#line 2652 "rygel-content-directory.c"
	} else {
#line 540 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp9_ = NULL;
#line 2656 "rygel-content-directory.c"
	}
#line 540 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp12_ = _tmp9_;
#line 540 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp13_ = object;
#line 540 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_handle_container_update_ids (self, _tmp12_, _tmp13_);
#line 543 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_ensure_timeout (self);
#line 2666 "rygel-content-directory.c"
}


static void rygel_content_directory_on_sub_tree_updates_finished (RygelContentDirectory* self, RygelMediaContainer* root_container, RygelMediaObject* sub_tree_root) {
	RygelLastChangeStDone* entry = NULL;
	RygelMediaObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	guint32 _tmp3_ = 0U;
	RygelLastChangeStDone* _tmp4_ = NULL;
	RygelLastChange* _tmp5_ = NULL;
#line 546 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 546 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (root_container != NULL);
#line 546 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (sub_tree_root != NULL);
#line 550 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = sub_tree_root;
#line 550 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = rygel_media_object_get_id (_tmp0_);
#line 550 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = _tmp1_;
#line 550 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp3_ = self->system_update_id;
#line 550 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = rygel_last_change_st_done_new (_tmp2_, (guint) _tmp3_);
#line 550 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	entry = _tmp4_;
#line 553 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = self->priv->last_change;
#line 553 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_last_change_add_event (_tmp5_, (RygelLastChangeEntry*) entry);
#line 554 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_ensure_timeout (self);
#line 546 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (entry);
#line 2704 "rygel-content-directory.c"
}


static gboolean rygel_content_directory_update_notify (RygelContentDirectory* self) {
	gboolean result = FALSE;
	gchar* update_ids = NULL;
	gchar* _tmp0_ = NULL;
	guint32 _tmp1_ = 0U;
	RygelLastChange* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	RygelLastChange* _tmp5_ = NULL;
#line 557 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 558 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = rygel_content_directory_create_container_update_ids (self);
#line 558 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	update_ids = _tmp0_;
#line 560 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_notify ((GUPnPService*) self, "ContainerUpdateIDs", G_TYPE_STRING, update_ids, NULL);
#line 561 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = self->system_update_id;
#line 561 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_notify ((GUPnPService*) self, "SystemUpdateID", G_TYPE_UINT, _tmp1_, NULL);
#line 562 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = self->priv->last_change;
#line 562 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp3_ = rygel_last_change_get_log (_tmp2_);
#line 562 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = _tmp3_;
#line 562 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_notify ((GUPnPService*) self, "LastChange", G_TYPE_STRING, _tmp4_, NULL);
#line 562 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (_tmp4_);
#line 564 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->priv->clear_updated_containers = TRUE;
#line 565 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->priv->update_notify_id = (guint) 0;
#line 566 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = self->priv->last_change;
#line 566 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_last_change_clear_on_new_event (_tmp5_);
#line 568 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	result = FALSE;
#line 568 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (update_ids);
#line 568 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return result;
#line 2753 "rygel-content-directory.c"
}


static gchar* rygel_content_directory_create_transfer_ids (RygelContentDirectory* self) {
	gchar* result = NULL;
	gchar* ids = NULL;
	gchar* _tmp0_ = NULL;
#line 571 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 572 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = g_strdup ("");
#line 572 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	ids = _tmp0_;
#line 2767 "rygel-content-directory.c"
	{
		GeeArrayList* _import_list = NULL;
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		gint _import_size = 0;
		GeeArrayList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _import_index = 0;
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp1_ = self->priv->active_imports;
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_import_list = _tmp2_;
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp3_ = _import_list;
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp5_ = _tmp4_;
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_import_size = _tmp5_;
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_import_index = -1;
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		while (TRUE) {
#line 2795 "rygel-content-directory.c"
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			RygelImportResource* import = NULL;
			GeeArrayList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp15_ = NULL;
			RygelImportResource* _tmp16_ = NULL;
			guint32 _tmp17_ = 0U;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp6_ = _import_index;
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_import_index = _tmp6_ + 1;
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp7_ = _import_index;
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp8_ = _import_size;
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				break;
#line 2822 "rygel-content-directory.c"
			}
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp9_ = _import_list;
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp10_ = _import_index;
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			import = (RygelImportResource*) _tmp11_;
#line 575 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp12_ = ids;
#line 575 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			if (g_strcmp0 (_tmp12_, "") != 0) {
#line 2836 "rygel-content-directory.c"
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
#line 576 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp13_ = ids;
#line 576 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp14_ = g_strconcat (_tmp13_, ",", NULL);
#line 576 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_g_free0 (ids);
#line 576 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				ids = _tmp14_;
#line 2847 "rygel-content-directory.c"
			}
#line 579 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp15_ = ids;
#line 579 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp16_ = import;
#line 579 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp17_ = _tmp16_->transfer_id;
#line 579 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp18_ = g_strdup_printf ("%u", _tmp17_);
#line 579 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp19_ = _tmp18_;
#line 579 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp20_ = g_strconcat (_tmp15_, _tmp19_, NULL);
#line 579 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_free0 (ids);
#line 579 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			ids = _tmp20_;
#line 579 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_free0 (_tmp19_);
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (import);
#line 2869 "rygel-content-directory.c"
		}
#line 574 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (_import_list);
#line 2873 "rygel-content-directory.c"
	}
#line 582 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	result = ids;
#line 582 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return result;
#line 2879 "rygel-content-directory.c"
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 585 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 585 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return _data4_;
#line 2888 "rygel-content-directory.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 585 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 2897 "rygel-content-directory.c"
		RygelContentDirectory * self;
#line 585 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		self = _data4_->self;
#line 585 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (_data4_->import);
#line 585 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (self);
#line 585 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_slice_free (Block4Data, _data4_);
#line 2907 "rygel-content-directory.c"
	}
}


static gboolean __lambda9_ (Block4Data* _data4_) {
	RygelContentDirectory * self;
	gboolean result = FALSE;
	GeeArrayList* _tmp0_ = NULL;
#line 598 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self = _data4_->self;
#line 599 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = self->priv->finished_imports;
#line 599 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _data4_->import);
#line 601 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	result = FALSE;
#line 601 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return result;
#line 2926 "rygel-content-directory.c"
}


static gboolean ___lambda9__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda9_ (self);
#line 598 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return result;
#line 2935 "rygel-content-directory.c"
}


static void rygel_content_directory_on_import_completed (RygelContentDirectory* self, RygelStateMachine* machine) {
	Block4Data* _data4_;
	RygelStateMachine* _tmp0_ = NULL;
	RygelImportResource* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 585 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 585 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (machine != NULL);
#line 585 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 585 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data4_->_ref_count_ = 1;
#line 585 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data4_->self = g_object_ref (self);
#line 586 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = machine;
#line 586 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_IMPORT_RESOURCE) ? ((RygelImportResource*) _tmp0_) : NULL);
#line 586 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data4_->import = _tmp1_;
#line 588 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = self->priv->finished_imports;
#line 588 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, _data4_->import);
#line 589 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp3_ = self->priv->active_imports;
#line 589 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp3_, _data4_->import);
#line 592 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp4_ = rygel_content_directory_create_transfer_ids (self);
#line 592 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = _tmp4_;
#line 592 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_notify ((GUPnPService*) self, "TransferIDs", G_TYPE_STRING, _tmp5_, NULL);
#line 592 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (_tmp5_);
#line 598 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 30, ___lambda9__gsource_func, block4_data_ref (_data4_), block4_data_unref);
#line 585 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	block4_data_unref (_data4_);
#line 585 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data4_ = NULL;
#line 2985 "rygel-content-directory.c"
}


static RygelImportResource* rygel_content_directory_find_import_for_action (RygelContentDirectory* self, GUPnPServiceAction* action, GError** error) {
	RygelImportResource* result = NULL;
	RygelImportResource* ret = NULL;
	guint32 transfer_id = 0U;
	gchar* transfer_id_string = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	guint32 _tmp2_ = 0U;
	gboolean _tmp7_ = FALSE;
	RygelImportResource* _tmp42_ = NULL;
	GError * _inner_error_ = NULL;
#line 605 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 605 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 607 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	ret = NULL;
#line 612 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 612 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_get (_tmp0_, "TransferID", G_TYPE_UINT, &transfer_id, "TransferID", G_TYPE_STRING, &transfer_id_string, NULL);
#line 618 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = transfer_id;
#line 618 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp2_ == ((guint32) 0)) {
#line 3014 "rygel-content-directory.c"
		gboolean _tmp3_ = FALSE;
		const gchar* _tmp4_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp4_ = transfer_id_string;
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		if (_tmp4_ == NULL) {
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp3_ = TRUE;
#line 3024 "rygel-content-directory.c"
		} else {
			const gchar* _tmp5_ = NULL;
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp5_ = transfer_id_string;
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp3_ = g_strcmp0 (_tmp5_, "0") != 0;
#line 3031 "rygel-content-directory.c"
		}
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp6_ = _tmp3_;
#line 619 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp1_ = _tmp6_;
#line 3037 "rygel-content-directory.c"
	} else {
#line 618 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp1_ = FALSE;
#line 3041 "rygel-content-directory.c"
	}
#line 618 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp7_ = _tmp1_;
#line 618 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp7_) {
#line 3047 "rygel-content-directory.c"
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
#line 620 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp8_ = _ ("Invalid argument");
#line 620 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp9_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _tmp8_);
#line 620 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_inner_error_ = _tmp9_;
#line 620 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		if (_inner_error_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
#line 620 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			g_propagate_error (error, _inner_error_);
#line 620 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_free0 (transfer_id_string);
#line 620 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (ret);
#line 620 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			return NULL;
#line 3066 "rygel-content-directory.c"
		} else {
#line 620 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_free0 (transfer_id_string);
#line 620 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (ret);
#line 620 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 620 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			g_clear_error (&_inner_error_);
#line 620 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			return NULL;
#line 3078 "rygel-content-directory.c"
		}
	}
	{
		GeeArrayList* _import_list = NULL;
		GeeArrayList* _tmp10_ = NULL;
		GeeArrayList* _tmp11_ = NULL;
		gint _import_size = 0;
		GeeArrayList* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _import_index = 0;
#line 624 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp10_ = self->priv->active_imports;
#line 624 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp11_ = _g_object_ref0 (_tmp10_);
#line 624 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_import_list = _tmp11_;
#line 624 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp12_ = _import_list;
#line 624 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp13_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp12_);
#line 624 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp14_ = _tmp13_;
#line 624 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_import_size = _tmp14_;
#line 624 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_import_index = -1;
#line 624 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		while (TRUE) {
#line 3108 "rygel-content-directory.c"
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			RygelImportResource* import = NULL;
			GeeArrayList* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gpointer _tmp20_ = NULL;
			RygelImportResource* _tmp21_ = NULL;
			guint32 _tmp22_ = 0U;
			guint32 _tmp23_ = 0U;
#line 624 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp15_ = _import_index;
#line 624 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_import_index = _tmp15_ + 1;
#line 624 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp16_ = _import_index;
#line 624 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp17_ = _import_size;
#line 624 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			if (!(_tmp16_ < _tmp17_)) {
#line 624 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				break;
#line 3131 "rygel-content-directory.c"
			}
#line 624 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp18_ = _import_list;
#line 624 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp19_ = _import_index;
#line 624 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _tmp19_);
#line 624 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			import = (RygelImportResource*) _tmp20_;
#line 625 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp21_ = import;
#line 625 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp22_ = _tmp21_->transfer_id;
#line 625 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp23_ = transfer_id;
#line 625 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			if (_tmp22_ == _tmp23_) {
#line 3149 "rygel-content-directory.c"
				RygelImportResource* _tmp24_ = NULL;
				RygelImportResource* _tmp25_ = NULL;
#line 626 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp24_ = import;
#line 626 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp25_ = _g_object_ref0 (_tmp24_);
#line 626 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_g_object_unref0 (ret);
#line 626 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				ret = _tmp25_;
#line 628 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_g_object_unref0 (import);
#line 628 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				break;
#line 3164 "rygel-content-directory.c"
			}
#line 624 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (import);
#line 3168 "rygel-content-directory.c"
		}
#line 624 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (_import_list);
#line 3172 "rygel-content-directory.c"
	}
	{
		GeeArrayList* _import_list = NULL;
		GeeArrayList* _tmp26_ = NULL;
		GeeArrayList* _tmp27_ = NULL;
		gint _import_size = 0;
		GeeArrayList* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		gint _import_index = 0;
#line 632 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp26_ = self->priv->finished_imports;
#line 632 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp27_ = _g_object_ref0 (_tmp26_);
#line 632 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_import_list = _tmp27_;
#line 632 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp28_ = _import_list;
#line 632 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp29_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp28_);
#line 632 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp30_ = _tmp29_;
#line 632 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_import_size = _tmp30_;
#line 632 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_import_index = -1;
#line 632 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		while (TRUE) {
#line 3201 "rygel-content-directory.c"
			gint _tmp31_ = 0;
			gint _tmp32_ = 0;
			gint _tmp33_ = 0;
			RygelImportResource* import = NULL;
			GeeArrayList* _tmp34_ = NULL;
			gint _tmp35_ = 0;
			gpointer _tmp36_ = NULL;
			RygelImportResource* _tmp37_ = NULL;
			guint32 _tmp38_ = 0U;
			guint32 _tmp39_ = 0U;
#line 632 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp31_ = _import_index;
#line 632 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_import_index = _tmp31_ + 1;
#line 632 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp32_ = _import_index;
#line 632 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp33_ = _import_size;
#line 632 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			if (!(_tmp32_ < _tmp33_)) {
#line 632 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				break;
#line 3224 "rygel-content-directory.c"
			}
#line 632 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp34_ = _import_list;
#line 632 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp35_ = _import_index;
#line 632 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, _tmp35_);
#line 632 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			import = (RygelImportResource*) _tmp36_;
#line 633 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp37_ = import;
#line 633 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp38_ = _tmp37_->transfer_id;
#line 633 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp39_ = transfer_id;
#line 633 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			if (_tmp38_ == _tmp39_) {
#line 3242 "rygel-content-directory.c"
				RygelImportResource* _tmp40_ = NULL;
				RygelImportResource* _tmp41_ = NULL;
#line 634 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp40_ = import;
#line 634 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp41_ = _g_object_ref0 (_tmp40_);
#line 634 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_g_object_unref0 (ret);
#line 634 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				ret = _tmp41_;
#line 636 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_g_object_unref0 (import);
#line 636 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				break;
#line 3257 "rygel-content-directory.c"
			}
#line 632 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (import);
#line 3261 "rygel-content-directory.c"
		}
#line 632 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (_import_list);
#line 3265 "rygel-content-directory.c"
	}
#line 640 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp42_ = ret;
#line 640 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp42_ == NULL) {
#line 3271 "rygel-content-directory.c"
		const gchar* _tmp43_ = NULL;
		GError* _tmp44_ = NULL;
#line 641 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp43_ = _ ("No such file transfer");
#line 641 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp44_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER, _tmp43_);
#line 641 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_inner_error_ = _tmp44_;
#line 641 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		if (_inner_error_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
#line 641 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			g_propagate_error (error, _inner_error_);
#line 641 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_free0 (transfer_id_string);
#line 641 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (ret);
#line 641 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			return NULL;
#line 3290 "rygel-content-directory.c"
		} else {
#line 641 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_free0 (transfer_id_string);
#line 641 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (ret);
#line 641 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 641 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			g_clear_error (&_inner_error_);
#line 641 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			return NULL;
#line 3302 "rygel-content-directory.c"
		}
	}
#line 645 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	result = ret;
#line 645 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (transfer_id_string);
#line 645 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return result;
#line 3311 "rygel-content-directory.c"
}


static void rygel_content_directory_query_last_change (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	RygelLastChange* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 649 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 649 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 649 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (variable != NULL);
#line 649 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (value != NULL);
#line 652 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_init (value, G_TYPE_STRING);
#line 653 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = self->priv->last_change;
#line 653 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = rygel_last_change_get_log (_tmp0_);
#line 653 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = _tmp1_;
#line 653 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_set_string (value, _tmp2_);
#line 653 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (_tmp2_);
#line 3339 "rygel-content-directory.c"
}


static gboolean _rygel_content_directory_update_notify_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_content_directory_update_notify (self);
#line 659 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return result;
#line 3348 "rygel-content-directory.c"
}


static void rygel_content_directory_ensure_timeout (RygelContentDirectory* self) {
	guint _tmp0_ = 0U;
#line 656 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 658 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = self->priv->update_notify_id;
#line 658 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp0_ == ((guint) 0)) {
#line 3360 "rygel-content-directory.c"
		guint _tmp1_ = 0U;
#line 659 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp1_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _rygel_content_directory_update_notify_gsource_func, g_object_ref (self), g_object_unref);
#line 659 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		self->priv->update_notify_id = _tmp1_;
#line 3366 "rygel-content-directory.c"
	}
}


static void rygel_content_directory_add_last_change_entry (RygelContentDirectory* self, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update) {
	RygelLastChangeEntry* entry = NULL;
	RygelObjectEventType _tmp0_ = 0;
	RygelLastChange* _tmp27_ = NULL;
	RygelLastChangeEntry* _tmp28_ = NULL;
#line 663 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 663 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (object != NULL);
#line 669 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = event_type;
#line 669 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	switch (_tmp0_) {
#line 669 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		case RYGEL_OBJECT_EVENT_TYPE_ADDED:
#line 3386 "rygel-content-directory.c"
		{
			RygelMediaObject* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			const gchar* _tmp3_ = NULL;
			guint32 _tmp4_ = 0U;
			gboolean _tmp5_ = FALSE;
			RygelMediaObject* _tmp6_ = NULL;
			RygelMediaContainer* _tmp7_ = NULL;
			RygelMediaContainer* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			RygelMediaObject* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			RygelLastChangeObjAdd* _tmp14_ = NULL;
#line 671 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp1_ = object;
#line 671 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp2_ = rygel_media_object_get_id (_tmp1_);
#line 671 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp3_ = _tmp2_;
#line 671 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp4_ = self->system_update_id;
#line 671 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp5_ = sub_tree_update;
#line 671 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp6_ = object;
#line 671 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp7_ = rygel_media_object_get_parent (_tmp6_);
#line 671 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp8_ = _tmp7_;
#line 671 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp9_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp8_);
#line 671 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp10_ = _tmp9_;
#line 671 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp11_ = object;
#line 671 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp12_ = rygel_media_object_get_upnp_class (_tmp11_);
#line 671 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp13_ = _tmp12_;
#line 671 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp14_ = rygel_last_change_obj_add_new (_tmp3_, (guint) _tmp4_, _tmp5_, _tmp10_, _tmp13_);
#line 671 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (entry);
#line 671 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			entry = (RygelLastChangeEntry*) _tmp14_;
#line 676 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			break;
#line 3436 "rygel-content-directory.c"
		}
#line 669 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		case RYGEL_OBJECT_EVENT_TYPE_MODIFIED:
#line 3440 "rygel-content-directory.c"
		{
			RygelMediaObject* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			guint32 _tmp18_ = 0U;
			gboolean _tmp19_ = FALSE;
			RygelLastChangeObjMod* _tmp20_ = NULL;
#line 679 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp15_ = object;
#line 679 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp16_ = rygel_media_object_get_id (_tmp15_);
#line 679 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp17_ = _tmp16_;
#line 679 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp18_ = self->system_update_id;
#line 679 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp19_ = sub_tree_update;
#line 679 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp20_ = rygel_last_change_obj_mod_new (_tmp17_, (guint) _tmp18_, _tmp19_);
#line 679 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (entry);
#line 679 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			entry = (RygelLastChangeEntry*) _tmp20_;
#line 682 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			break;
#line 3466 "rygel-content-directory.c"
		}
#line 669 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		case RYGEL_OBJECT_EVENT_TYPE_DELETED:
#line 3470 "rygel-content-directory.c"
		{
			RygelMediaObject* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			guint32 _tmp24_ = 0U;
			gboolean _tmp25_ = FALSE;
			RygelLastChangeObjDel* _tmp26_ = NULL;
#line 685 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp21_ = object;
#line 685 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp22_ = rygel_media_object_get_id (_tmp21_);
#line 685 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp23_ = _tmp22_;
#line 685 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp24_ = self->system_update_id;
#line 685 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp25_ = sub_tree_update;
#line 685 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp26_ = rygel_last_change_obj_del_new (_tmp23_, (guint) _tmp24_, _tmp25_);
#line 685 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (entry);
#line 685 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			entry = (RygelLastChangeEntry*) _tmp26_;
#line 688 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			break;
#line 3496 "rygel-content-directory.c"
		}
		default:
		{
#line 691 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			g_assert_not_reached ();
#line 3502 "rygel-content-directory.c"
		}
	}
#line 694 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp27_ = self->priv->last_change;
#line 694 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp28_ = entry;
#line 694 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_last_change_add_event (_tmp27_, _tmp28_);
#line 663 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (entry);
#line 3513 "rygel-content-directory.c"
}


static void rygel_content_directory_get_service_reset_token_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GUPnPServiceAction* _tmp2_ = NULL;
#line 698 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 698 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 698 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 700 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 700 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = self->priv->service_reset_token;
#line 700 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_set (_tmp0_, "ResetToken", G_TYPE_STRING, _tmp1_, NULL);
#line 701 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp2_ = action;
#line 701 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_return (_tmp2_);
#line 3537 "rygel-content-directory.c"
}


static void rygel_content_directory_query_service_reset_token (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	const gchar* _tmp0_ = NULL;
#line 704 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 704 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 704 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (variable != NULL);
#line 704 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (value != NULL);
#line 707 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_init (value, G_TYPE_STRING);
#line 708 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = self->priv->service_reset_token;
#line 708 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_value_set_string (value, _tmp0_);
#line 3557 "rygel-content-directory.c"
}


static void rygel_content_directory_service_reset_data_free (gpointer _data) {
	RygelContentDirectoryServiceResetData* _data_;
	_data_ = _data;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (_data_->self);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_slice_free (RygelContentDirectoryServiceResetData, _data_);
#line 3568 "rygel-content-directory.c"
}


static void rygel_content_directory_service_reset (RygelContentDirectory* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelContentDirectoryServiceResetData* _data_;
	RygelContentDirectory* _tmp0_ = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_ = g_slice_new0 (RygelContentDirectoryServiceResetData);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_content_directory_service_reset);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_content_directory_service_reset_data_free);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->self = _tmp0_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_service_reset_co (_data_);
#line 3587 "rygel-content-directory.c"
}


static void rygel_content_directory_service_reset_finish (RygelContentDirectory* self, GAsyncResult* _res_) {
	RygelContentDirectoryServiceResetData* _data_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3595 "rygel-content-directory.c"
}


static void rygel_content_directory_service_reset_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelContentDirectoryServiceResetData* _data_;
#line 735 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_ = _user_data_;
#line 735 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_source_object_ = source_object;
#line 735 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_res_ = _res_;
#line 735 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_service_reset_co (_data_);
#line 3609 "rygel-content-directory.c"
}


static gboolean rygel_content_directory_service_reset_co (RygelContentDirectoryServiceResetData* _data_) {
#line 711 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	switch (_data_->_state_) {
#line 711 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		case 0:
#line 3618 "rygel-content-directory.c"
		goto _state_0;
#line 711 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		case 1:
#line 3622 "rygel-content-directory.c"
		goto _state_1;
		default:
#line 711 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_assert_not_reached ();
#line 3627 "rygel-content-directory.c"
	}
	_state_0:
#line 712 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_debug ("rygel-content-directory.vala:712: SystemUpdateID overflow, initiating " \
"service reset procedure");
#line 714 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp0_ = NULL;
#line 714 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_object_get ((GUPnPService*) _data_->self, "root-device", &_data_->_tmp0_, NULL);
#line 714 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp1_ = NULL;
#line 714 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp1_ = _data_->_tmp0_;
#line 714 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp2_ = NULL;
#line 714 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 714 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp3_ = NULL;
#line 714 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _data_->_tmp2_);
#line 714 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp4_ = NULL;
#line 714 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 714 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp5_ = NULL;
#line 714 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp4_, RYGEL_TYPE_MEDIA_SERVER_PLUGIN) ? ((RygelMediaServerPlugin*) _data_->_tmp4_) : NULL);
#line 714 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp6_ = NULL;
#line 714 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 714 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (_data_->_tmp2_);
#line 714 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->plugin = _data_->_tmp6_;
#line 715 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp7_ = NULL;
#line 715 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp7_ = _data_->plugin;
#line 715 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_plugin_set_active ((RygelPlugin*) _data_->_tmp7_, FALSE);
#line 716 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp8_ = NULL;
#line 716 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp8_ = uuid_get ();
#line 716 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (_data_->self->priv->service_reset_token);
#line 716 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->self->priv->service_reset_token = _data_->_tmp8_;
#line 717 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp9_ = NULL;
#line 717 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp9_ = _data_->self->root_container;
#line 717 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp9_, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
#line 718 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp10_ = NULL;
#line 718 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp10_ = _data_->self->root_container;
#line 718 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp11_ = NULL;
#line 718 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp10_, RYGEL_TYPE_TRACKABLE_CONTAINER) ? ((RygelTrackableContainer*) _data_->_tmp10_) : NULL);
#line 718 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->trackable = _data_->_tmp11_;
#line 719 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp12_ = NULL;
#line 719 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp12_ = _data_->trackable;
#line 719 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp13_ = NULL;
#line 719 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp13_ = _data_->self->priv->service_reset_token;
#line 719 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		rygel_trackable_container_set_service_reset_token (_data_->_tmp12_, _data_->_tmp13_);
#line 717 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (_data_->trackable);
#line 3706 "rygel-content-directory.c"
	}
#line 722 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp14_ = NULL;
#line 722 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp14_ = rygel_relational_expression_new ();
#line 722 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->expression = _data_->_tmp14_;
#line 723 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp15_ = NULL;
#line 723 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp15_ = _data_->expression;
#line 723 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp16_ = NULL;
#line 723 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp16_ = g_strdup ("upnp:objectUpdateID");
#line 723 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (((RygelSearchExpression*) _data_->_tmp15_)->operand1);
#line 723 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	((RygelSearchExpression*) _data_->_tmp15_)->operand1 = _data_->_tmp16_;
#line 724 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp17_ = NULL;
#line 724 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp17_ = _data_->expression;
#line 724 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp18_ = NULL;
#line 724 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp18_ = g_strdup ("true");
#line 724 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (((RygelSearchExpression*) _data_->_tmp17_)->operand2);
#line 724 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	((RygelSearchExpression*) _data_->_tmp17_)->operand2 = _data_->_tmp18_;
#line 725 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp19_ = NULL;
#line 725 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_data_->_tmp19_ = _data_->expression;
#line 725 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	((RygelSearchExpression*) _data_->_tmp19_)->op = (gpointer) ((gintptr) GUPNP_SEARCH_CRITERIA_OP_EXISTS);
#line 3744 "rygel-content-directory.c"
	{
#line 728 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp20_ = NULL;
#line 728 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp20_ = _data_->self->root_container;
#line 728 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp21_ = NULL;
#line 728 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp20_, RYGEL_TYPE_SEARCHABLE_CONTAINER) ? ((RygelSearchableContainer*) _data_->_tmp20_) : NULL);
#line 728 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->root = _data_->_tmp21_;
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp22_ = NULL;
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp22_ = _data_->root;
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		if (_data_->_tmp22_ == NULL) {
#line 731 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (_data_->root);
#line 731 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_rygel_search_expression_unref0 (_data_->expression);
#line 731 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (_data_->plugin);
#line 731 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			if (_data_->_state_ == 0) {
#line 731 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3772 "rygel-content-directory.c"
			} else {
#line 731 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 3776 "rygel-content-directory.c"
			}
#line 731 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			g_object_unref (_data_->_async_result);
#line 731 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			return FALSE;
#line 3782 "rygel-content-directory.c"
		}
#line 734 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->matches = (guint32) 0;
#line 735 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp23_ = NULL;
#line 735 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp23_ = _data_->root;
#line 735 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp24_ = NULL;
#line 735 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp24_ = _data_->expression;
#line 735 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp25_ = 0U;
#line 735 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_state_ = 1;
#line 735 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		rygel_searchable_container_search (_data_->_tmp23_, (RygelSearchExpression*) _data_->_tmp24_, (guint) 0, (guint) 0, "", NULL, rygel_content_directory_service_reset_ready, _data_);
#line 735 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return FALSE;
#line 3802 "rygel-content-directory.c"
		_state_1:
#line 735 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp26_ = NULL;
#line 735 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp26_ = rygel_searchable_container_search_finish (_data_->_tmp23_, _data_->_res_, &_data_->_tmp25_, &_data_->_inner_error_);
#line 735 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->matches = (guint32) _data_->_tmp25_;
#line 735 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->objects = _data_->_tmp26_;
#line 735 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		if (_data_->_inner_error_ != NULL) {
#line 735 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_g_object_unref0 (_data_->root);
#line 3816 "rygel-content-directory.c"
			goto __catch24_g_error;
		}
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp27_ = NULL;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp27_ = _data_->objects;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp28_ = 0;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp28_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp27_);
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp29_ = 0;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp29_ = _data_->_tmp28_;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		if (_data_->_tmp29_ > 0) {
#line 742 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_data_->count = (guint32) 1;
#line 3835 "rygel-content-directory.c"
			{
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_tmp30_ = NULL;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_tmp30_ = _data_->objects;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_tmp31_ = NULL;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_tmp31_ = _g_object_ref0 (_data_->_tmp30_);
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_object_list = _data_->_tmp31_;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_tmp32_ = NULL;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_tmp32_ = _data_->_object_list;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_tmp33_ = 0;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_tmp33_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp32_);
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_tmp34_ = 0;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_tmp34_ = _data_->_tmp33_;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_object_size = _data_->_tmp34_;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_data_->_object_index = -1;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				while (TRUE) {
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp35_ = 0;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp35_ = _data_->_object_index;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_object_index = _data_->_tmp35_ + 1;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp36_ = 0;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp36_ = _data_->_object_index;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp37_ = 0;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp37_ = _data_->_object_size;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					if (!(_data_->_tmp36_ < _data_->_tmp37_)) {
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						break;
#line 3883 "rygel-content-directory.c"
					}
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp38_ = NULL;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp38_ = _data_->_object_list;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp39_ = 0;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp39_ = _data_->_object_index;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp40_ = NULL;
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp38_, _data_->_tmp39_);
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->object = (RygelMediaObject*) _data_->_tmp40_;
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp41_ = NULL;
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp41_ = _data_->object;
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp42_ = 0U;
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp42_ = _data_->count;
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->count = _data_->_tmp42_ + 1;
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					rygel_media_object_set_object_update_id (_data_->_tmp41_, (guint) _data_->_tmp42_);
#line 746 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp43_ = NULL;
#line 746 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_data_->_tmp43_ = _data_->object;
#line 746 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp43_, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
#line 747 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp44_ = NULL;
#line 747 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp44_ = _data_->object;
#line 747 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp45_ = NULL;
#line 747 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp45_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp44_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _data_->_tmp44_) : NULL);
#line 747 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->container = _data_->_tmp45_;
#line 748 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp46_ = NULL;
#line 748 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp46_ = _data_->container;
#line 748 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp47_ = NULL;
#line 748 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp47_ = _data_->container;
#line 748 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp48_ = 0U;
#line 748 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp48_ = rygel_media_object_get_object_update_id ((RygelMediaObject*) _data_->_tmp47_);
#line 748 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp49_ = 0U;
#line 748 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp49_ = _data_->_tmp48_;
#line 748 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp46_->update_id = (guint32) _data_->_tmp49_;
#line 749 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp50_ = NULL;
#line 749 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp50_ = _data_->container;
#line 749 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_data_->_tmp50_->total_deleted_child_count = (gint64) 0;
#line 746 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
						_g_object_unref0 (_data_->container);
#line 3953 "rygel-content-directory.c"
					}
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_g_object_unref0 (_data_->object);
#line 3957 "rygel-content-directory.c"
				}
#line 743 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_g_object_unref0 (_data_->_object_list);
#line 3961 "rygel-content-directory.c"
			}
#line 754 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_data_->_tmp51_ = 0U;
#line 754 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_data_->_tmp51_ = _data_->count;
#line 754 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_data_->self->system_update_id = _data_->_tmp51_ - 1;
#line 755 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_data_->_tmp52_ = 0U;
#line 755 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_data_->_tmp52_ = _data_->self->system_update_id;
#line 755 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			g_debug ("rygel-content-directory.vala:755: New SystemUpdateID is %u", (guint) _data_->_tmp52_);
#line 3975 "rygel-content-directory.c"
		}
#line 758 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_debug ("rygel-content-directory.vala:758: Service reset procedure done, device" \
" coming up again");
#line 759 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp53_ = NULL;
#line 759 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp53_ = _data_->plugin;
#line 759 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		rygel_plugin_set_active ((RygelPlugin*) _data_->_tmp53_, TRUE);
#line 760 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp54_ = NULL;
#line 760 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_tmp54_ = _data_->self->priv->service_reset_token;
#line 760 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_debug ("rygel-content-directory.vala:760: New service reset token is %s", _data_->_tmp54_);
#line 727 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (_data_->objects);
#line 727 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (_data_->root);
#line 3995 "rygel-content-directory.c"
	}
	goto __finally24;
	__catch24_g_error:
	{
#line 727 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 727 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_data_->_inner_error_ = NULL;
#line 761 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_warning ("rygel-content-directory.vala:761: Failed to search for objects...");
#line 727 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_error_free0 (_data_->_error_);
#line 4008 "rygel-content-directory.c"
	}
	__finally24:
#line 727 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_data_->_inner_error_ != NULL) {
#line 727 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_rygel_search_expression_unref0 (_data_->expression);
#line 727 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_object_unref0 (_data_->plugin);
#line 727 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 727 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_clear_error (&_data_->_inner_error_);
#line 727 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return FALSE;
#line 4023 "rygel-content-directory.c"
	}
#line 711 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 711 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (_data_->plugin);
#line 711 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_data_->_state_ == 0) {
#line 711 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4033 "rygel-content-directory.c"
	} else {
#line 711 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4037 "rygel-content-directory.c"
	}
#line 711 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_object_unref (_data_->_async_result);
#line 711 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return FALSE;
#line 4043 "rygel-content-directory.c"
}


static gpointer _rygel_dlna_profile_ref0 (gpointer self) {
#line 781 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return self ? rygel_dlna_profile_ref (self) : NULL;
#line 4050 "rygel-content-directory.c"
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
#line 790 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	for (i = 0; i < stack_length; i++) {
#line 790 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 790 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			return TRUE;
#line 4062 "rygel-content-directory.c"
		}
	}
#line 790 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return FALSE;
#line 4067 "rygel-content-directory.c"
}


static void rygel_content_directory_get_dlna_upload_profiles_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	gchar* upload_profiles = NULL;
	GUPnPServiceAction* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	RygelMediaServerPlugin* plugin = NULL;
	GUPnPRootDevice* _tmp4_ = NULL;
	GUPnPRootDevice* _tmp5_ = NULL;
	GUPnPRootDevice* _tmp6_ = NULL;
	GUPnPResourceFactory* _tmp7_ = NULL;
	GUPnPResourceFactory* _tmp8_ = NULL;
	RygelMediaServerPlugin* _tmp9_ = NULL;
	RygelMediaServerPlugin* _tmp10_ = NULL;
	GList* profiles = NULL;
	RygelMediaServerPlugin* _tmp11_ = NULL;
	GList* _tmp12_ = NULL;
	GList* _tmp13_ = NULL;
	gchar** requested_profiles = NULL;
	const gchar* _tmp14_ = NULL;
	gchar** _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gint requested_profiles_length1 = 0;
	gint _requested_profiles_size_ = 0;
	GString* builder = NULL;
	GString* _tmp17_ = NULL;
	GList* _tmp18_ = NULL;
	GString* _tmp42_ = NULL;
	gssize _tmp43_ = 0L;
	GUPnPServiceAction* _tmp47_ = NULL;
	GString* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	GUPnPServiceAction* _tmp50_ = NULL;
#line 765 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 765 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 765 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 767 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	upload_profiles = NULL;
#line 769 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = action;
#line 769 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_get (_tmp0_, "UploadProfiles", G_TYPE_STRING, &upload_profiles, NULL);
#line 771 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp1_ = upload_profiles;
#line 771 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp1_ == NULL) {
#line 4118 "rygel-content-directory.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 772 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp2_ = action;
#line 772 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp3_ = _ ("Invalid argument");
#line 772 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 774 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_g_free0 (upload_profiles);
#line 774 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		return;
#line 4131 "rygel-content-directory.c"
	}
#line 777 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_object_get ((GUPnPService*) self, "root-device", &_tmp4_, NULL);
#line 777 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp5_ = _tmp4_;
#line 777 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp6_ = _tmp5_;
#line 777 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp7_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp6_);
#line 777 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp8_ = _tmp7_;
#line 777 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, RYGEL_TYPE_MEDIA_SERVER_PLUGIN) ? ((RygelMediaServerPlugin*) _tmp8_) : NULL);
#line 777 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp10_ = _tmp9_;
#line 777 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (_tmp6_);
#line 777 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	plugin = _tmp10_;
#line 778 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp11_ = plugin;
#line 778 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp12_ = rygel_media_server_plugin_get_upload_profiles (_tmp11_);
#line 778 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp13_ = _tmp12_;
#line 778 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	profiles = _tmp13_;
#line 779 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp14_ = upload_profiles;
#line 779 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, ",", 0);
#line 779 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	requested_profiles = _tmp16_;
#line 779 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	requested_profiles_length1 = _vala_array_length (_tmp15_);
#line 779 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_requested_profiles_size_ = requested_profiles_length1;
#line 780 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp17_ = g_string_new ("");
#line 780 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	builder = _tmp17_;
#line 781 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp18_ = profiles;
#line 4175 "rygel-content-directory.c"
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
#line 781 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		profile_collection = _tmp18_;
#line 781 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
#line 4183 "rygel-content-directory.c"
			RygelDLNAProfile* _tmp19_ = NULL;
			RygelDLNAProfile* profile = NULL;
#line 781 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			_tmp19_ = _rygel_dlna_profile_ref0 ((RygelDLNAProfile*) profile_it->data);
#line 781 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
			profile = _tmp19_;
#line 4190 "rygel-content-directory.c"
			{
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				RygelDLNAProfile* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				gboolean _tmp24_ = FALSE;
				gboolean _tmp28_ = FALSE;
				gboolean _tmp31_ = FALSE;
				gboolean _tmp32_ = FALSE;
				gchar** _tmp33_ = NULL;
				gint _tmp33__length1 = 0;
				gboolean _tmp37_ = FALSE;
#line 783 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp22_ = profile;
#line 783 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp23_ = _tmp22_->name;
#line 783 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp24_ = g_str_has_suffix (_tmp23_, "_ICO");
#line 783 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				if (_tmp24_) {
#line 783 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp21_ = TRUE;
#line 4213 "rygel-content-directory.c"
				} else {
					RygelDLNAProfile* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					gboolean _tmp27_ = FALSE;
#line 784 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp25_ = profile;
#line 784 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp26_ = _tmp25_->name;
#line 784 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp27_ = g_str_has_suffix (_tmp26_, "_TN");
#line 784 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp21_ = _tmp27_;
#line 4226 "rygel-content-directory.c"
				}
#line 783 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp28_ = _tmp21_;
#line 783 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				if (_tmp28_) {
#line 783 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp20_ = TRUE;
#line 4234 "rygel-content-directory.c"
				} else {
					RygelDLNAProfile* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
#line 785 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp29_ = profile;
#line 785 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp30_ = _tmp29_->name;
#line 785 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp20_ = g_strcmp0 (_tmp30_, "DIDL_S") == 0;
#line 4244 "rygel-content-directory.c"
				}
#line 783 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp31_ = _tmp20_;
#line 783 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				if (_tmp31_) {
#line 786 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_rygel_dlna_profile_unref0 (profile);
#line 786 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					continue;
#line 4254 "rygel-content-directory.c"
				}
#line 789 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp33_ = requested_profiles;
#line 789 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp33__length1 = requested_profiles_length1;
#line 789 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				if (_tmp33__length1 == 0) {
#line 789 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp32_ = TRUE;
#line 4264 "rygel-content-directory.c"
				} else {
					RygelDLNAProfile* _tmp34_ = NULL;
					const gchar* _tmp35_ = NULL;
					gchar** _tmp36_ = NULL;
					gint _tmp36__length1 = 0;
#line 790 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp34_ = profile;
#line 790 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp35_ = _tmp34_->name;
#line 790 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp36_ = requested_profiles;
#line 790 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp36__length1 = requested_profiles_length1;
#line 790 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp32_ = _vala_string_array_contains (_tmp36_, _tmp36__length1, _tmp35_);
#line 4280 "rygel-content-directory.c"
				}
#line 789 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_tmp37_ = _tmp32_;
#line 789 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				if (_tmp37_) {
#line 4286 "rygel-content-directory.c"
					GString* _tmp38_ = NULL;
					RygelDLNAProfile* _tmp39_ = NULL;
					const gchar* _tmp40_ = NULL;
					GString* _tmp41_ = NULL;
#line 791 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp38_ = builder;
#line 791 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp39_ = profile;
#line 791 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp40_ = _tmp39_->name;
#line 791 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					g_string_append (_tmp38_, _tmp40_);
#line 792 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					_tmp41_ = builder;
#line 792 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
					g_string_append (_tmp41_, ",");
#line 4303 "rygel-content-directory.c"
				}
#line 781 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
				_rygel_dlna_profile_unref0 (profile);
#line 4307 "rygel-content-directory.c"
			}
		}
	}
#line 796 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp42_ = builder;
#line 796 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp43_ = _tmp42_->len;
#line 796 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	if (_tmp43_ > ((gssize) 0)) {
#line 4317 "rygel-content-directory.c"
		GString* _tmp44_ = NULL;
		GString* _tmp45_ = NULL;
		gssize _tmp46_ = 0L;
#line 797 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp44_ = builder;
#line 797 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp45_ = builder;
#line 797 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		_tmp46_ = _tmp45_->len;
#line 797 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
		g_string_truncate (_tmp44_, (gsize) (_tmp46_ - 1));
#line 4329 "rygel-content-directory.c"
	}
#line 800 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp47_ = action;
#line 800 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp48_ = builder;
#line 800 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp49_ = _tmp48_->str;
#line 800 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_set (_tmp47_, "SupportedUploadProfiles", G_TYPE_STRING, _tmp49_, NULL);
#line 801 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp50_ = action;
#line 801 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	gupnp_service_action_return (_tmp50_);
#line 765 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_string_free0 (builder);
#line 765 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	requested_profiles = (_vala_array_free (requested_profiles, requested_profiles_length1, (GDestroyNotify) g_free), NULL);
#line 765 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (plugin);
#line 765 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (upload_profiles);
#line 4351 "rygel-content-directory.c"
}


RygelContentDirectory* rygel_content_directory_construct (GType object_type) {
	RygelContentDirectory * self = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self = (RygelContentDirectory*) g_object_new (object_type, NULL);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return self;
#line 4361 "rygel-content-directory.c"
}


RygelContentDirectory* rygel_content_directory_new (void) {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	return rygel_content_directory_construct (RYGEL_TYPE_CONTENT_DIRECTORY);
#line 4368 "rygel-content-directory.c"
}


static void rygel_content_directory_class_init (RygelContentDirectoryClass * klass) {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	rygel_content_directory_parent_class = g_type_class_peek_parent (klass);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_type_class_add_private (klass, sizeof (RygelContentDirectoryPrivate));
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	G_OBJECT_CLASS (klass)->constructed = rygel_content_directory_real_constructed;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_content_directory_finalize;
#line 4381 "rygel-content-directory.c"
}


static void rygel_content_directory_instance_init (RygelContentDirectory * self) {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self->priv = RYGEL_CONTENT_DIRECTORY_GET_PRIVATE (self);
#line 4388 "rygel-content-directory.c"
}


static void rygel_content_directory_finalize (GObject* obj) {
	RygelContentDirectory * self;
	GCancellable* _tmp0_ = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_tmp0_ = self->cancellable;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	g_cancellable_cancel (_tmp0_);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (self->feature_list);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->http_server);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->root_container);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->priv->updated_containers);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->priv->active_imports);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->priv->finished_imports);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->cancellable);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_object_unref0 (self->priv->last_change);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (self->priv->service_reset_token);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	_g_free0 (self->priv->search_caps);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-content-directory.vala"
	G_OBJECT_CLASS (rygel_content_directory_parent_class)->finalize (obj);
#line 4423 "rygel-content-directory.c"
}


/**
 * Basic implementation of UPnP ContentDirectory service version 2. Most often
 * plugins will provide a child of this class. The inheriting classes should
 * override create_root_container method.
 */
GType rygel_content_directory_get_type (void) {
	static volatile gsize rygel_content_directory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_content_directory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelContentDirectoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_content_directory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelContentDirectory), 0, (GInstanceInitFunc) rygel_content_directory_instance_init, NULL };
		GType rygel_content_directory_type_id;
		rygel_content_directory_type_id = g_type_register_static (gupnp_service_get_type (), "RygelContentDirectory", &g_define_type_info, 0);
		g_once_init_leave (&rygel_content_directory_type_id__volatile, rygel_content_directory_type_id);
	}
	return rygel_content_directory_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



