/* rygel-item-destroyer.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-item-destroyer.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_ITEM_DESTROYER (rygel_item_destroyer_get_type ())
#define RYGEL_ITEM_DESTROYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyer))
#define RYGEL_ITEM_DESTROYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyerClass))
#define RYGEL_IS_ITEM_DESTROYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_DESTROYER))
#define RYGEL_IS_ITEM_DESTROYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_DESTROYER))
#define RYGEL_ITEM_DESTROYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyerClass))

typedef struct _RygelItemDestroyer RygelItemDestroyer;
typedef struct _RygelItemDestroyerClass RygelItemDestroyerClass;
typedef struct _RygelItemDestroyerPrivate RygelItemDestroyerPrivate;

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelItemDestroyerRunData RygelItemDestroyerRunData;

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_OBJECT_REMOVAL_QUEUE (rygel_object_removal_queue_get_type ())
#define RYGEL_OBJECT_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueue))
#define RYGEL_OBJECT_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueueClass))
#define RYGEL_IS_OBJECT_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE))
#define RYGEL_IS_OBJECT_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE))
#define RYGEL_OBJECT_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueueClass))

typedef struct _RygelObjectRemovalQueue RygelObjectRemovalQueue;
typedef struct _RygelObjectRemovalQueueClass RygelObjectRemovalQueueClass;
typedef struct _RygelItemDestroyerRemoveObjectData RygelItemDestroyerRemoveObjectData;
typedef struct _RygelItemDestroyerFetchObjectData RygelItemDestroyerFetchObjectData;

typedef enum  {
	RYGEL_ITEM_DESTROYER_ERROR_PARSE
} RygelItemDestroyerError;
#define RYGEL_ITEM_DESTROYER_ERROR rygel_item_destroyer_error_quark ()
struct _RygelItemDestroyer {
	GObject parent_instance;
	RygelItemDestroyerPrivate * priv;
};

struct _RygelItemDestroyerClass {
	GObjectClass parent_class;
};

struct _RygelItemDestroyerPrivate {
	gchar* object_id;
	RygelContentDirectory* content_dir;
	GUPnPServiceAction* action;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA = 708,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER = 710,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER = 717,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelItemDestroyerRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemDestroyer* self;
	GUPnPServiceAction* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _tmp3_;
	GUPnPServiceAction* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GError* _error_;
	GError* _tmp7_;
	GUPnPServiceAction* _tmp8_;
	GError* _tmp9_;
	gint _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GUPnPServiceAction* _tmp13_;
	GError* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError * _inner_error_;
};

struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_container) (RygelWritableContainer* self, RygelMediaContainer* container, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_reference) (RygelWritableContainer* self, RygelMediaObject* object, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*add_reference_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_container) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

struct _RygelItemDestroyerRemoveObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemDestroyer* self;
	RygelMediaObject* media_object;
	RygelMediaObject* _tmp0_;
	RygelWritableContainer* parent;
	RygelMediaObject* _tmp1_;
	RygelMediaContainer* _tmp2_;
	RygelMediaContainer* _tmp3_;
	RygelWritableContainer* _tmp4_;
	RygelMediaObject* _tmp5_;
	RygelWritableContainer* _tmp6_;
	const gchar* _tmp7_;
	GCancellable* _tmp8_;
	GCancellable* _tmp9_;
	RygelMediaObject* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GeeArrayList* writables;
	RygelMediaObject* _tmp13_;
	GCancellable* _tmp14_;
	GCancellable* _tmp15_;
	GeeArrayList* _tmp16_;
	GeeArrayList* _file_list;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	gint _file_size;
	GeeArrayList* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gint _file_index;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	GFile* file;
	GeeArrayList* _tmp25_;
	gint _tmp26_;
	gpointer _tmp27_;
	GFile* _tmp28_;
	GCancellable* _tmp29_;
	GCancellable* _tmp30_;
	gboolean _tmp31_;
	GFile* _tmp32_;
	GCancellable* _tmp33_;
	GCancellable* _tmp34_;
	RygelWritableContainer* _tmp35_;
	const gchar* _tmp36_;
	GCancellable* _tmp37_;
	GCancellable* _tmp38_;
	RygelObjectRemovalQueue* _tmp39_;
	RygelObjectRemovalQueue* _tmp40_;
	RygelMediaObject* _tmp41_;
	GError * _inner_error_;
};

struct _RygelItemDestroyerFetchObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemDestroyer* self;
	RygelMediaObject* result;
	RygelMediaObject* media_object;
	RygelContentDirectory* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	RygelMediaObject* _tmp5_;
	RygelMediaObject* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	RygelMediaObject* _tmp9_;
	GUPnPOCMFlags _tmp10_;
	GUPnPOCMFlags _tmp11_;
	const gchar* _tmp12_;
	RygelMediaObject* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	GError* _tmp16_;
	RygelMediaObject* _tmp17_;
	RygelMediaContainer* _tmp18_;
	RygelMediaContainer* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gchar* msg;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	RygelMediaObject* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	GError* _tmp28_;
	GError * _inner_error_;
};


static gpointer rygel_item_destroyer_parent_class = NULL;
static RygelStateMachineIface* rygel_item_destroyer_rygel_state_machine_parent_iface = NULL;

GQuark rygel_item_destroyer_error_quark (void);
GType rygel_item_destroyer_get_type (void) G_GNUC_CONST;
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
#define RYGEL_ITEM_DESTROYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyerPrivate))
enum  {
	RYGEL_ITEM_DESTROYER_DUMMY_PROPERTY,
	RYGEL_ITEM_DESTROYER_CANCELLABLE
};
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
RygelItemDestroyer* rygel_item_destroyer_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelItemDestroyer* rygel_item_destroyer_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
static void rygel_item_destroyer_real_run_data_free (gpointer _data);
static void rygel_item_destroyer_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_item_destroyer_real_run_co (RygelItemDestroyerRunData* _data_);
GQuark rygel_content_directory_error_quark (void);
static void rygel_item_destroyer_remove_object (RygelItemDestroyer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_item_destroyer_remove_object_finish (RygelItemDestroyer* self, GAsyncResult* _res_, GError** error);
static void rygel_item_destroyer_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_item_destroyer_remove_object_data_free (gpointer _data);
static gboolean rygel_item_destroyer_remove_object_co (RygelItemDestroyerRemoveObjectData* _data_);
static void rygel_item_destroyer_fetch_object (RygelItemDestroyer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObject* rygel_item_destroyer_fetch_object_finish (RygelItemDestroyer* self, GAsyncResult* _res_, GError** error);
static void rygel_item_destroyer_remove_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self);
void rygel_writable_container_remove_item (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_remove_item_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
void rygel_media_object_get_writables (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GeeArrayList* rygel_media_object_get_writables_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
void rygel_writable_container_remove_container (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_remove_container_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
GType rygel_object_removal_queue_get_type (void) G_GNUC_CONST;
RygelObjectRemovalQueue* rygel_object_removal_queue_get_default (void);
gboolean rygel_object_removal_queue_dequeue (RygelObjectRemovalQueue* self, RygelMediaObject* object);
static void rygel_item_destroyer_fetch_object_data_free (gpointer _data);
static gboolean rygel_item_destroyer_fetch_object_co (RygelItemDestroyerFetchObjectData* _data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_item_destroyer_fetch_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
static void rygel_item_destroyer_finalize (GObject* obj);
static void _vala_rygel_item_destroyer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_item_destroyer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_item_destroyer_error_quark (void) {
	return g_quark_from_static_string ("rygel_item_destroyer_error-quark");
}


static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	g_boxed_free (gupnp_service_action_get_type (), self);
#line 400 "rygel-item-destroyer.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	return self ? g_object_ref (self) : NULL;
#line 407 "rygel-item-destroyer.c"
}


RygelItemDestroyer* rygel_item_destroyer_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	RygelItemDestroyer * self = NULL;
	RygelContentDirectory* _tmp0_ = NULL;
	RygelContentDirectory* _tmp1_ = NULL;
	RygelContentDirectory* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GUPnPServiceAction* _tmp4_ = NULL;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	g_return_val_if_fail (content_dir != NULL, NULL);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	self = (RygelItemDestroyer*) g_object_new (object_type, NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_tmp0_ = content_dir;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_g_object_unref0 (self->priv->content_dir);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	self->priv->content_dir = _tmp1_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_tmp2_ = content_dir;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_tmp3_ = _tmp2_->cancellable;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp3_);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_tmp4_ = action;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	action = NULL;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	__vala_GUPnPServiceAction_free0 (self->priv->action);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	self->priv->action = _tmp4_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	__vala_GUPnPServiceAction_free0 (action);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	return self;
#line 450 "rygel-item-destroyer.c"
}


RygelItemDestroyer* rygel_item_destroyer_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	return rygel_item_destroyer_construct (RYGEL_TYPE_ITEM_DESTROYER, content_dir, action);
#line 457 "rygel-item-destroyer.c"
}


static void rygel_item_destroyer_real_run_data_free (gpointer _data) {
	RygelItemDestroyerRunData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	g_slice_free (RygelItemDestroyerRunData, _data_);
#line 468 "rygel-item-destroyer.c"
}


static void rygel_item_destroyer_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemDestroyer * self;
	RygelItemDestroyerRunData* _data_;
	RygelItemDestroyer* _tmp0_ = NULL;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	self = (RygelItemDestroyer*) base;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_ = g_slice_new0 (RygelItemDestroyerRunData);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_destroyer_real_run);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_destroyer_real_run_data_free);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	rygel_item_destroyer_real_run_co (_data_);
#line 490 "rygel-item-destroyer.c"
}


static void rygel_item_destroyer_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelItemDestroyerRunData* _data_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 498 "rygel-item-destroyer.c"
}


static void rygel_item_destroyer_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemDestroyerRunData* _data_;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_ = _user_data_;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_source_object_ = source_object;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_res_ = _res_;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	rygel_item_destroyer_real_run_co (_data_);
#line 512 "rygel-item-destroyer.c"
}


static gboolean rygel_item_destroyer_real_run_co (RygelItemDestroyerRunData* _data_) {
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	switch (_data_->_state_) {
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		case 0:
#line 521 "rygel-item-destroyer.c"
		goto _state_0;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		case 1:
#line 525 "rygel-item-destroyer.c"
		goto _state_1;
		default:
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_assert_not_reached ();
#line 530 "rygel-item-destroyer.c"
	}
	_state_0:
	{
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp0_ = NULL;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp0_ = _data_->self->priv->action;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		gupnp_service_action_get (_data_->_tmp0_, "ObjectID", G_TYPE_STRING, &_data_->self->priv->object_id, NULL);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp1_ = NULL;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp1_ = _data_->self->priv->object_id;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		if (_data_->_tmp1_ == NULL) {
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp2_ = NULL;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp2_ = _ ("ContainerID missing");
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp3_ = NULL;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp3_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _data_->_tmp2_);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_inner_error_ = _data_->_tmp3_;
#line 556 "rygel-item-destroyer.c"
			goto __catch60_g_error;
		}
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_state_ = 1;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		rygel_item_destroyer_remove_object (_data_->self, rygel_item_destroyer_run_ready, _data_);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		return FALSE;
#line 565 "rygel-item-destroyer.c"
		_state_1:
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		rygel_item_destroyer_remove_object_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		if (_data_->_inner_error_ != NULL) {
#line 571 "rygel-item-destroyer.c"
			goto __catch60_g_error;
		}
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp4_ = NULL;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp4_ = _data_->self->priv->action;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		gupnp_service_action_return (_data_->_tmp4_);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp5_ = NULL;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp5_ = _ ("Successfully destroyed object '%s'");
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp6_ = NULL;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp6_ = _data_->self->priv->object_id;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_debug (_data_->_tmp5_, _data_->_tmp6_);
#line 590 "rygel-item-destroyer.c"
	}
	goto __finally60;
	__catch60_g_error:
	{
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_inner_error_ = NULL;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp7_ = NULL;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp7_ = _data_->_error_;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		if (_data_->_tmp7_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp8_ = NULL;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp8_ = _data_->self->priv->action;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp9_ = NULL;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp9_ = _data_->_error_;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp10_ = 0;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp10_ = _data_->_tmp9_->code;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp11_ = NULL;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp11_ = _data_->_error_;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp12_ = NULL;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp12_ = _data_->_tmp11_->message;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			gupnp_service_action_return_error (_data_->_tmp8_, (guint) _data_->_tmp10_, _data_->_tmp12_);
#line 627 "rygel-item-destroyer.c"
		} else {
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp13_ = NULL;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp13_ = _data_->self->priv->action;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp14_ = NULL;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp14_ = _data_->_error_;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp15_ = NULL;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp15_ = _data_->_tmp14_->message;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			gupnp_service_action_return_error (_data_->_tmp13_, (guint) 701, _data_->_tmp15_);
#line 643 "rygel-item-destroyer.c"
		}
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp16_ = NULL;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp16_ = _ ("Failed to destroy object '%s': %s");
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp17_ = NULL;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp17_ = _data_->self->priv->object_id;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp18_ = NULL;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp18_ = _data_->_error_;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp19_ = NULL;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp19_ = _data_->_tmp18_->message;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_warning (_data_->_tmp16_, _data_->_tmp17_, _data_->_tmp19_);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_g_error_free0 (_data_->_error_);
#line 665 "rygel-item-destroyer.c"
	}
	__finally60:
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	if (_data_->_inner_error_ != NULL) {
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_clear_error (&_data_->_inner_error_);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		return FALSE;
#line 676 "rygel-item-destroyer.c"
	}
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	if (_data_->_state_ == 0) {
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 684 "rygel-item-destroyer.c"
	} else {
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 688 "rygel-item-destroyer.c"
	}
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	g_object_unref (_data_->_async_result);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	return FALSE;
#line 694 "rygel-item-destroyer.c"
}


static void rygel_item_destroyer_remove_object_data_free (gpointer _data) {
	RygelItemDestroyerRemoveObjectData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	g_slice_free (RygelItemDestroyerRemoveObjectData, _data_);
#line 705 "rygel-item-destroyer.c"
}


static void rygel_item_destroyer_remove_object (RygelItemDestroyer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemDestroyerRemoveObjectData* _data_;
	RygelItemDestroyer* _tmp0_ = NULL;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_ = g_slice_new0 (RygelItemDestroyerRemoveObjectData);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_destroyer_remove_object);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_destroyer_remove_object_data_free);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	rygel_item_destroyer_remove_object_co (_data_);
#line 724 "rygel-item-destroyer.c"
}


static void rygel_item_destroyer_remove_object_finish (RygelItemDestroyer* self, GAsyncResult* _res_, GError** error) {
	RygelItemDestroyerRemoveObjectData* _data_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		return;
#line 734 "rygel-item-destroyer.c"
	}
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 738 "rygel-item-destroyer.c"
}


static void rygel_item_destroyer_remove_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemDestroyerRemoveObjectData* _data_;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_ = _user_data_;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_source_object_ = source_object;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_res_ = _res_;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	rygel_item_destroyer_remove_object_co (_data_);
#line 752 "rygel-item-destroyer.c"
}


static gboolean rygel_item_destroyer_remove_object_co (RygelItemDestroyerRemoveObjectData* _data_) {
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	switch (_data_->_state_) {
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		case 0:
#line 761 "rygel-item-destroyer.c"
		goto _state_0;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		case 1:
#line 765 "rygel-item-destroyer.c"
		goto _state_1;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		case 2:
#line 769 "rygel-item-destroyer.c"
		goto _state_2;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		case 3:
#line 773 "rygel-item-destroyer.c"
		goto _state_3;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		case 4:
#line 777 "rygel-item-destroyer.c"
		goto _state_4;
		default:
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_assert_not_reached ();
#line 782 "rygel-item-destroyer.c"
	}
	_state_0:
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_state_ = 1;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	rygel_item_destroyer_fetch_object (_data_->self, rygel_item_destroyer_remove_object_ready, _data_);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	return FALSE;
#line 791 "rygel-item-destroyer.c"
	_state_1:
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp0_ = NULL;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp0_ = rygel_item_destroyer_fetch_object_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->media_object = _data_->_tmp0_;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	if (_data_->_inner_error_ != NULL) {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_error_free (_data_->_inner_error_);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		if (_data_->_state_ == 0) {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 809 "rygel-item-destroyer.c"
		} else {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 813 "rygel-item-destroyer.c"
		}
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_object_unref (_data_->_async_result);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		return FALSE;
#line 819 "rygel-item-destroyer.c"
	}
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp1_ = NULL;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp1_ = _data_->media_object;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp2_ = NULL;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp2_ = rygel_media_object_get_parent (_data_->_tmp1_);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp3_ = NULL;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp4_ = NULL;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp3_, RYGEL_TYPE_WRITABLE_CONTAINER) ? ((RygelWritableContainer*) _data_->_tmp3_) : NULL);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->parent = _data_->_tmp4_;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp5_ = NULL;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp5_ = _data_->media_object;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp5_, RYGEL_TYPE_MEDIA_ITEM)) {
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp6_ = NULL;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp6_ = _data_->parent;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp7_ = NULL;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp7_ = _data_->self->priv->object_id;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp8_ = NULL;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp8_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp9_ = NULL;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp9_ = _data_->_tmp8_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_state_ = 2;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		rygel_writable_container_remove_item (_data_->_tmp6_, _data_->_tmp7_, _data_->_tmp9_, rygel_item_destroyer_remove_object_ready, _data_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		return FALSE;
#line 867 "rygel-item-destroyer.c"
		_state_2:
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		rygel_writable_container_remove_item_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		if (_data_->_inner_error_ != NULL) {
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			g_error_free (_data_->_inner_error_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_g_object_unref0 (_data_->parent);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_g_object_unref0 (_data_->media_object);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			if (_data_->_state_ == 0) {
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 885 "rygel-item-destroyer.c"
			} else {
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 889 "rygel-item-destroyer.c"
			}
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			g_object_unref (_data_->_async_result);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			return FALSE;
#line 895 "rygel-item-destroyer.c"
		}
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp10_ = NULL;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp10_ = _data_->media_object;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp11_ = FALSE;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp11_ = rygel_media_item_get_place_holder (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp10_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp10_) : NULL);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp12_ = FALSE;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp12_ = _data_->_tmp11_;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		if (!_data_->_tmp12_) {
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp13_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp13_ = _data_->media_object;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp14_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp14_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp15_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp15_ = _data_->_tmp14_;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_state_ = 3;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			rygel_media_object_get_writables (_data_->_tmp13_, _data_->_tmp15_, rygel_item_destroyer_remove_object_ready, _data_);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			return FALSE;
#line 929 "rygel-item-destroyer.c"
			_state_3:
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp16_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp16_ = rygel_media_object_get_writables_finish (_data_->_tmp13_, _data_->_res_, &_data_->_inner_error_);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->writables = _data_->_tmp16_;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			if (_data_->_inner_error_ != NULL) {
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				g_error_free (_data_->_inner_error_);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_g_object_unref0 (_data_->parent);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_g_object_unref0 (_data_->media_object);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				if (_data_->_state_ == 0) {
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 951 "rygel-item-destroyer.c"
				} else {
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 955 "rygel-item-destroyer.c"
				}
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				g_object_unref (_data_->_async_result);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				return FALSE;
#line 961 "rygel-item-destroyer.c"
			}
			{
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp17_ = NULL;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp17_ = _data_->writables;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp18_ = NULL;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp18_ = _g_object_ref0 (_data_->_tmp17_);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_file_list = _data_->_tmp18_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp19_ = NULL;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp19_ = _data_->_file_list;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp20_ = 0;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp20_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp19_);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp21_ = 0;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp21_ = _data_->_tmp20_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_file_size = _data_->_tmp21_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_file_index = -1;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				while (TRUE) {
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					_data_->_tmp22_ = 0;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					_data_->_tmp22_ = _data_->_file_index;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					_data_->_file_index = _data_->_tmp22_ + 1;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					_data_->_tmp23_ = 0;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					_data_->_tmp23_ = _data_->_file_index;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					_data_->_tmp24_ = 0;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					_data_->_tmp24_ = _data_->_file_size;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					if (!(_data_->_tmp23_ < _data_->_tmp24_)) {
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
						break;
#line 1010 "rygel-item-destroyer.c"
					}
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					_data_->_tmp25_ = NULL;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					_data_->_tmp25_ = _data_->_file_list;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					_data_->_tmp26_ = 0;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					_data_->_tmp26_ = _data_->_file_index;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					_data_->_tmp27_ = NULL;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					_data_->_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp25_, _data_->_tmp26_);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					_data_->file = (GFile*) _data_->_tmp27_;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					_data_->_tmp28_ = NULL;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					_data_->_tmp28_ = _data_->file;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					_data_->_tmp29_ = NULL;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					_data_->_tmp29_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					_data_->_tmp30_ = NULL;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					_data_->_tmp30_ = _data_->_tmp29_;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					_data_->_tmp31_ = FALSE;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					_data_->_tmp31_ = g_file_query_exists (_data_->_tmp28_, _data_->_tmp30_);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					if (_data_->_tmp31_) {
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
						_data_->_tmp32_ = NULL;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
						_data_->_tmp32_ = _data_->file;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
						_data_->_tmp33_ = NULL;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
						_data_->_tmp33_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
						_data_->_tmp34_ = NULL;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
						_data_->_tmp34_ = _data_->_tmp33_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
						g_file_delete (_data_->_tmp32_, _data_->_tmp34_, &_data_->_inner_error_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
						if (_data_->_inner_error_ != NULL) {
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
							g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
							g_error_free (_data_->_inner_error_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
							_g_object_unref0 (_data_->file);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
							_g_object_unref0 (_data_->_file_list);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
							_g_object_unref0 (_data_->writables);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
							_g_object_unref0 (_data_->parent);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
							_g_object_unref0 (_data_->media_object);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
							if (_data_->_state_ == 0) {
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
								g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1078 "rygel-item-destroyer.c"
							} else {
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
								g_simple_async_result_complete (_data_->_async_result);
#line 1082 "rygel-item-destroyer.c"
							}
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
							g_object_unref (_data_->_async_result);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
							return FALSE;
#line 1088 "rygel-item-destroyer.c"
						}
					}
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					_g_object_unref0 (_data_->file);
#line 1093 "rygel-item-destroyer.c"
				}
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_g_object_unref0 (_data_->_file_list);
#line 1097 "rygel-item-destroyer.c"
			}
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_g_object_unref0 (_data_->writables);
#line 1101 "rygel-item-destroyer.c"
		}
	} else {
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp35_ = NULL;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp35_ = _data_->parent;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp36_ = NULL;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp36_ = _data_->self->priv->object_id;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp37_ = NULL;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp37_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp38_ = NULL;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp38_ = _data_->_tmp37_;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_state_ = 4;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		rygel_writable_container_remove_container (_data_->_tmp35_, _data_->_tmp36_, _data_->_tmp38_, rygel_item_destroyer_remove_object_ready, _data_);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		return FALSE;
#line 1126 "rygel-item-destroyer.c"
		_state_4:
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		rygel_writable_container_remove_container_finish (_data_->_tmp35_, _data_->_res_, &_data_->_inner_error_);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		if (_data_->_inner_error_ != NULL) {
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			g_error_free (_data_->_inner_error_);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_g_object_unref0 (_data_->parent);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_g_object_unref0 (_data_->media_object);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			if (_data_->_state_ == 0) {
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1144 "rygel-item-destroyer.c"
			} else {
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1148 "rygel-item-destroyer.c"
			}
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			g_object_unref (_data_->_async_result);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			return FALSE;
#line 1154 "rygel-item-destroyer.c"
		}
	}
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp39_ = NULL;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp39_ = rygel_object_removal_queue_get_default ();
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp40_ = NULL;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp40_ = _data_->_tmp39_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp41_ = NULL;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp41_ = _data_->media_object;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	rygel_object_removal_queue_dequeue (_data_->_tmp40_, _data_->_tmp41_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_g_object_unref0 (_data_->_tmp40_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_g_object_unref0 (_data_->parent);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_g_object_unref0 (_data_->media_object);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	if (_data_->_state_ == 0) {
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1181 "rygel-item-destroyer.c"
	} else {
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1185 "rygel-item-destroyer.c"
	}
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	g_object_unref (_data_->_async_result);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	return FALSE;
#line 1191 "rygel-item-destroyer.c"
}


static void rygel_item_destroyer_fetch_object_data_free (gpointer _data) {
	RygelItemDestroyerFetchObjectData* _data_;
	_data_ = _data;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_g_object_unref0 (_data_->result);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_g_object_unref0 (_data_->self);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	g_slice_free (RygelItemDestroyerFetchObjectData, _data_);
#line 1204 "rygel-item-destroyer.c"
}


static void rygel_item_destroyer_fetch_object (RygelItemDestroyer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemDestroyerFetchObjectData* _data_;
	RygelItemDestroyer* _tmp0_ = NULL;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_ = g_slice_new0 (RygelItemDestroyerFetchObjectData);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_destroyer_fetch_object);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_destroyer_fetch_object_data_free);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->self = _tmp0_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	rygel_item_destroyer_fetch_object_co (_data_);
#line 1223 "rygel-item-destroyer.c"
}


static RygelMediaObject* rygel_item_destroyer_fetch_object_finish (RygelItemDestroyer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelItemDestroyerFetchObjectData* _data_;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		return NULL;
#line 1234 "rygel-item-destroyer.c"
	}
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	result = _data_->result;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->result = NULL;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	return result;
#line 1244 "rygel-item-destroyer.c"
}


static void rygel_item_destroyer_fetch_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemDestroyerFetchObjectData* _data_;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_ = _user_data_;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_source_object_ = source_object;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_res_ = _res_;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	rygel_item_destroyer_fetch_object_co (_data_);
#line 1258 "rygel-item-destroyer.c"
}


static gboolean rygel_item_destroyer_fetch_object_co (RygelItemDestroyerFetchObjectData* _data_) {
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	switch (_data_->_state_) {
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		case 0:
#line 1267 "rygel-item-destroyer.c"
		goto _state_0;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		case 1:
#line 1271 "rygel-item-destroyer.c"
		goto _state_1;
		default:
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_assert_not_reached ();
#line 1276 "rygel-item-destroyer.c"
	}
	_state_0:
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp0_ = NULL;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp0_ = _data_->self->priv->content_dir;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp1_ = NULL;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp1_ = _data_->_tmp0_->root_container;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp2_ = NULL;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp2_ = _data_->self->priv->object_id;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp3_ = NULL;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp3_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp4_ = NULL;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_state_ = 1;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	rygel_media_container_find_object (_data_->_tmp1_, _data_->_tmp2_, _data_->_tmp4_, rygel_item_destroyer_fetch_object_ready, _data_);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	return FALSE;
#line 1305 "rygel-item-destroyer.c"
	_state_1:
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp5_ = NULL;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp5_ = rygel_media_container_find_object_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->media_object = _data_->_tmp5_;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	if (_data_->_inner_error_ != NULL) {
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_error_free (_data_->_inner_error_);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		if (_data_->_state_ == 0) {
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1323 "rygel-item-destroyer.c"
		} else {
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1327 "rygel-item-destroyer.c"
		}
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_object_unref (_data_->_async_result);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		return FALSE;
#line 1333 "rygel-item-destroyer.c"
	}
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp6_ = NULL;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->_tmp6_ = _data_->media_object;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	if (_data_->_tmp6_ == NULL) {
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp7_ = NULL;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp7_ = _ ("No such object");
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp8_ = NULL;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp8_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _data_->_tmp7_);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_inner_error_ = _data_->_tmp8_;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_error_free (_data_->_inner_error_);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_g_object_unref0 (_data_->media_object);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		if (_data_->_state_ == 0) {
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1361 "rygel-item-destroyer.c"
		} else {
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1365 "rygel-item-destroyer.c"
		}
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_object_unref (_data_->_async_result);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		return FALSE;
#line 1371 "rygel-item-destroyer.c"
	} else {
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp9_ = NULL;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp9_ = _data_->media_object;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp10_ = 0;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp10_ = rygel_media_object_get_ocm_flags (_data_->_tmp9_);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp11_ = 0;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		_data_->_tmp11_ = _data_->_tmp10_;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		if (!((_data_->_tmp11_ & GUPNP_OCM_FLAGS_DESTROYABLE) == GUPNP_OCM_FLAGS_DESTROYABLE)) {
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp12_ = NULL;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp12_ = _ ("Removal of object %s not allowed");
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp13_ = NULL;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp13_ = _data_->media_object;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp14_ = NULL;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp14_ = rygel_media_object_get_id (_data_->_tmp13_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp15_ = NULL;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp15_ = _data_->_tmp14_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp16_ = NULL;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp16_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT, _data_->_tmp12_, _data_->_tmp15_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_inner_error_ = _data_->_tmp16_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			g_error_free (_data_->_inner_error_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_g_object_unref0 (_data_->media_object);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			if (_data_->_state_ == 0) {
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1419 "rygel-item-destroyer.c"
			} else {
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1423 "rygel-item-destroyer.c"
			}
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			g_object_unref (_data_->_async_result);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			return FALSE;
#line 1429 "rygel-item-destroyer.c"
		} else {
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp17_ = NULL;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp17_ = _data_->media_object;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp18_ = NULL;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp18_ = rygel_media_object_get_parent (_data_->_tmp17_);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp19_ = NULL;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp19_ = _data_->_tmp18_;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp20_ = FALSE;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp20_ = rygel_media_object_get_restricted ((RygelMediaObject*) _data_->_tmp19_);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp21_ = FALSE;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			_data_->_tmp21_ = _data_->_tmp20_;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
			if (_data_->_tmp21_) {
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp22_ = NULL;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp22_ = _ ("Object removal from %s not allowed");
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp23_ = NULL;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp23_ = g_strdup (_data_->_tmp22_);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->msg = _data_->_tmp23_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp24_ = NULL;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp24_ = _data_->msg;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp25_ = NULL;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp25_ = _data_->media_object;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp26_ = NULL;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp26_ = rygel_media_object_get_id (_data_->_tmp25_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp27_ = NULL;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp27_ = _data_->_tmp26_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp28_ = NULL;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_tmp28_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _data_->_tmp24_, _data_->_tmp27_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_data_->_inner_error_ = _data_->_tmp28_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				g_error_free (_data_->_inner_error_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_g_free0 (_data_->msg);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				_g_object_unref0 (_data_->media_object);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				if (_data_->_state_ == 0) {
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1497 "rygel-item-destroyer.c"
				} else {
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 1501 "rygel-item-destroyer.c"
				}
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				g_object_unref (_data_->_async_result);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
				return FALSE;
#line 1507 "rygel-item-destroyer.c"
			}
		}
	}
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_data_->result = _data_->media_object;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	if (_data_->_state_ == 0) {
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1517 "rygel-item-destroyer.c"
	} else {
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1521 "rygel-item-destroyer.c"
	}
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	g_object_unref (_data_->_async_result);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	return FALSE;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_g_object_unref0 (_data_->media_object);
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	if (_data_->_state_ == 0) {
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1533 "rygel-item-destroyer.c"
	} else {
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1537 "rygel-item-destroyer.c"
	}
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	g_object_unref (_data_->_async_result);
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	return FALSE;
#line 1543 "rygel-item-destroyer.c"
}


static GCancellable* rygel_item_destroyer_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelItemDestroyer* self;
	GCancellable* _tmp0_ = NULL;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	self = (RygelItemDestroyer*) base;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_tmp0_ = self->priv->_cancellable;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	result = _tmp0_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	return result;
#line 1559 "rygel-item-destroyer.c"
}


static void rygel_item_destroyer_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelItemDestroyer* self;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	self = (RygelItemDestroyer*) base;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_tmp0_ = value;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	self->priv->_cancellable = _tmp1_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 1579 "rygel-item-destroyer.c"
}


static void rygel_item_destroyer_class_init (RygelItemDestroyerClass * klass) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	rygel_item_destroyer_parent_class = g_type_class_peek_parent (klass);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	g_type_class_add_private (klass, sizeof (RygelItemDestroyerPrivate));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_item_destroyer_get_property;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_item_destroyer_set_property;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_item_destroyer_finalize;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_ITEM_DESTROYER_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1596 "rygel-item-destroyer.c"
}


static void rygel_item_destroyer_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	rygel_item_destroyer_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_item_destroyer_real_run;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	iface->run_finish = rygel_item_destroyer_real_run_finish;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	iface->get_cancellable = rygel_item_destroyer_real_get_cancellable;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	iface->set_cancellable = rygel_item_destroyer_real_set_cancellable;
#line 1611 "rygel-item-destroyer.c"
}


static void rygel_item_destroyer_instance_init (RygelItemDestroyer * self) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	self->priv = RYGEL_ITEM_DESTROYER_GET_PRIVATE (self);
#line 1618 "rygel-item-destroyer.c"
}


static void rygel_item_destroyer_finalize (GObject* obj) {
	RygelItemDestroyer * self;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyer);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_g_free0 (self->priv->object_id);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_g_object_unref0 (self->priv->content_dir);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	__vala_GUPnPServiceAction_free0 (self->priv->action);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	G_OBJECT_CLASS (rygel_item_destroyer_parent_class)->finalize (obj);
#line 1636 "rygel-item-destroyer.c"
}


/**
 * DestroyObject action implementation.
 */
GType rygel_item_destroyer_get_type (void) {
	static volatile gsize rygel_item_destroyer_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_item_destroyer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelItemDestroyerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_item_destroyer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelItemDestroyer), 0, (GInstanceInitFunc) rygel_item_destroyer_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_item_destroyer_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_item_destroyer_type_id;
		rygel_item_destroyer_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelItemDestroyer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_item_destroyer_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_item_destroyer_type_id__volatile, rygel_item_destroyer_type_id);
	}
	return rygel_item_destroyer_type_id__volatile;
}


static void _vala_rygel_item_destroyer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelItemDestroyer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyer);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	switch (property_id) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		case RYGEL_ITEM_DESTROYER_CANCELLABLE:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		break;
#line 1668 "rygel-item-destroyer.c"
		default:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		break;
#line 1674 "rygel-item-destroyer.c"
	}
}


static void _vala_rygel_item_destroyer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelItemDestroyer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyer);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
	switch (property_id) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		case RYGEL_ITEM_DESTROYER_CANCELLABLE:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		break;
#line 1690 "rygel-item-destroyer.c"
		default:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-item-destroyer.vala"
		break;
#line 1696 "rygel-item-destroyer.c"
	}
}



