/* rygel-media-art-store.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-media-art-store.vala, do not modify */

/*
 * Copyright (C) 2010 Jens Georg <mail@jensge.org>.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <glib/gstdio.h>


#define RYGEL_TYPE_MEDIA_ART_STORE (rygel_media_art_store_get_type ())
#define RYGEL_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStore))
#define RYGEL_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))
#define RYGEL_IS_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_IS_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_MEDIA_ART_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))

typedef struct _RygelMediaArtStore RygelMediaArtStore;
typedef struct _RygelMediaArtStoreClass RygelMediaArtStoreClass;
typedef struct _RygelMediaArtStorePrivate RygelMediaArtStorePrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

typedef enum  {
	MEDIA_ART_STORE_ERROR_NO_DIR,
	MEDIA_ART_STORE_ERROR_NO_MEDIA_ART
} MediaArtStoreError;
#define MEDIA_ART_STORE_ERROR media_art_store_error_quark ()
struct _RygelMediaArtStore {
	GObject parent_instance;
	RygelMediaArtStorePrivate * priv;
};

struct _RygelMediaArtStoreClass {
	GObjectClass parent_class;
};

struct _RygelMediaArtStorePrivate {
	GRegex* char_remove_regex;
	GRegex* char_convert_regex;
	GRegex* space_compress_regex;
	GRegex** block_regexes;
	gint block_regexes_length1;
	gint _block_regexes_size_;
	gchar* directory;
};


static gpointer rygel_media_art_store_parent_class = NULL;
static RygelMediaArtStore* rygel_media_art_store_media_art_store;
static RygelMediaArtStore* rygel_media_art_store_media_art_store = NULL;
static gboolean rygel_media_art_store_first_time;
static gboolean rygel_media_art_store_first_time = TRUE;

GQuark media_art_store_error_quark (void);
GType rygel_media_art_store_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_ART_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStorePrivate))
enum  {
	RYGEL_MEDIA_ART_STORE_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_ART_STORE_PLACEHOLDER_HASH "7215ee9c7d9dc229d2921a40e899ec5f"
#define RYGEL_MEDIA_ART_STORE_INVALID_CHARS "()[]<>{}_!@#$^&*+=|\\/\"'?~"
#define RYGEL_MEDIA_ART_STORE_CONVERT_CHARS "\t"
#define RYGEL_MEDIA_ART_STORE_BLOCK_PATTERN "%s[^%s]*%s"
RygelMediaArtStore* rygel_media_art_store_get_default (void);
static RygelMediaArtStore* rygel_media_art_store_new (GError** error);
static RygelMediaArtStore* rygel_media_art_store_construct (GType object_type, GError** error);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
RygelThumbnail* rygel_media_art_store_find_media_art (RygelMediaArtStore* self, RygelMusicItem* item, gboolean simple, GError** error);
GFile* rygel_media_art_store_get_media_art_file (RygelMediaArtStore* self, const gchar* type, RygelMusicItem* item, gboolean simple);
RygelThumbnail* rygel_thumbnail_new (const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
RygelThumbnail* rygel_thumbnail_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
RygelThumbnail* rygel_media_art_store_find_media_art_any (RygelMediaArtStore* self, RygelMusicItem* item, GError** error);
static gchar* rygel_media_art_store_get_simple_hash (RygelMediaArtStore* self, const gchar* type, RygelMusicItem* item);
static gchar* rygel_media_art_store_get_hash (RygelMediaArtStore* self, const gchar* type, RygelMusicItem* item);
static void _vala_array_add1 (GRegex*** array, int* length, int* size, GRegex* value);
static gchar* rygel_media_art_store_normalize_and_hash (RygelMediaArtStore* self, const gchar* input, gboolean utf8_only);
const gchar* rygel_music_item_get_artist (RygelMusicItem* self);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
const gchar* rygel_music_item_get_album (RygelMusicItem* self);
static gchar* rygel_media_art_store_strip_invalid_entities (RygelMediaArtStore* self, const gchar* original);
static void rygel_media_art_store_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* RYGEL_MEDIA_ART_STORE_BLOCKS[4] = {"()", "{}", "[]", "<>"};

GQuark media_art_store_error_quark (void) {
	return g_quark_from_static_string ("media_art_store_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	return self ? g_object_ref (self) : NULL;
#line 179 "rygel-media-art-store.c"
}


RygelMediaArtStore* rygel_media_art_store_get_default (void) {
	RygelMediaArtStore* result = NULL;
	gboolean _tmp0_ = FALSE;
	RygelMediaArtStore* _tmp5_ = NULL;
	RygelMediaArtStore* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp0_ = rygel_media_art_store_first_time;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	if (_tmp0_) {
#line 193 "rygel-media-art-store.c"
		{
			RygelMediaArtStore* _tmp1_ = NULL;
			RygelMediaArtStore* _tmp2_ = NULL;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_tmp2_ = rygel_media_art_store_new (&_inner_error_);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_tmp1_ = _tmp2_;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			if (_inner_error_ != NULL) {
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				if (_inner_error_->domain == MEDIA_ART_STORE_ERROR) {
#line 205 "rygel-media-art-store.c"
					goto __catch0_media_art_store_error;
				}
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				g_clear_error (&_inner_error_);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				return NULL;
#line 214 "rygel-media-art-store.c"
			}
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_object_unref0 (rygel_media_art_store_media_art_store);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			rygel_media_art_store_media_art_store = _tmp1_;
#line 220 "rygel-media-art-store.c"
		}
		goto __finally0;
		__catch0_media_art_store_error:
		{
			GError* _error_ = NULL;
			GError* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_error_ = _inner_error_;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_inner_error_ = NULL;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_tmp3_ = _error_;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_tmp4_ = _tmp3_->message;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_warning ("rygel-media-art-store.vala:54: No media art available: %s", _tmp4_);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_error_free0 (_error_);
#line 240 "rygel-media-art-store.c"
		}
		__finally0:
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		if (_inner_error_ != NULL) {
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_clear_error (&_inner_error_);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			return NULL;
#line 251 "rygel-media-art-store.c"
		}
	}
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	rygel_media_art_store_first_time = FALSE;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp5_ = rygel_media_art_store_media_art_store;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	result = _tmp6_;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	return result;
#line 264 "rygel-media-art-store.c"
}


RygelThumbnail* rygel_media_art_store_find_media_art (RygelMediaArtStore* self, RygelMusicItem* item, gboolean simple, GError** error) {
	RygelThumbnail* result = NULL;
	gchar** types = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint types_length1 = 0;
	gint _types_size_ = 0;
	GFile* file = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	GFile* _tmp14_ = NULL;
	GFileInfo* info = NULL;
	GFile* _tmp15_ = NULL;
	GFileInfo* _tmp16_ = NULL;
	GFileInfo* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	RygelThumbnail* thumb = NULL;
	RygelThumbnail* _tmp19_ = NULL;
	RygelThumbnail* _tmp20_ = NULL;
	GFile* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	RygelThumbnail* _tmp23_ = NULL;
	GFileInfo* _tmp24_ = NULL;
	gint64 _tmp25_ = 0LL;
	GError * _inner_error_ = NULL;
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 63 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp0_ = g_strdup ("track");
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp1_ = g_strdup ("album");
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp2_ = g_strdup ("artist");
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp3_ = g_strdup ("podcast");
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp4_ = g_strdup ("radio");
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp5_ = g_new0 (gchar*, 5 + 1);
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp5_[0] = _tmp0_;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp5_[1] = _tmp1_;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp5_[2] = _tmp2_;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp5_[3] = _tmp3_;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp5_[4] = _tmp4_;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	types = _tmp5_;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	types_length1 = 5;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_types_size_ = types_length1;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	file = NULL;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp6_ = types;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp6__length1 = types_length1;
#line 335 "rygel-media-art-store.c"
	{
		gchar** type_collection = NULL;
		gint type_collection_length1 = 0;
		gint _type_collection_size_ = 0;
		gint type_it = 0;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		type_collection = _tmp6_;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		type_collection_length1 = _tmp6__length1;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		for (type_it = 0; type_it < _tmp6__length1; type_it = type_it + 1) {
#line 347 "rygel-media-art-store.c"
			gchar* _tmp7_ = NULL;
			gchar* type = NULL;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_tmp7_ = g_strdup (type_collection[type_it]);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			type = _tmp7_;
#line 354 "rygel-media-art-store.c"
			{
				const gchar* _tmp8_ = NULL;
				RygelMusicItem* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
				GFile* _tmp11_ = NULL;
				GFile* _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp8_ = type;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp9_ = item;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp10_ = simple;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp11_ = rygel_media_art_store_get_media_art_file (self, _tmp8_, _tmp9_, _tmp10_);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_g_object_unref0 (file);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				file = _tmp11_;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp12_ = file;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp13_ = g_file_query_exists (_tmp12_, NULL);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				if (_tmp13_) {
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_g_free0 (type);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					break;
#line 384 "rygel-media-art-store.c"
				} else {
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_g_object_unref0 (file);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					file = NULL;
#line 390 "rygel-media-art-store.c"
				}
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_g_free0 (type);
#line 394 "rygel-media-art-store.c"
			}
		}
	}
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp14_ = file;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	if (_tmp14_ == NULL) {
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		result = NULL;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_object_unref0 (file);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		return result;
#line 410 "rygel-media-art-store.c"
	}
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp15_ = file;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp16_ = g_file_query_info (_tmp15_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	info = _tmp16_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	if (_inner_error_ != NULL) {
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		g_propagate_error (error, _inner_error_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_object_unref0 (file);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		return NULL;
#line 428 "rygel-media-art-store.c"
	}
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp17_ = info;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp18_ = g_file_info_get_attribute_boolean (_tmp17_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	if (!_tmp18_) {
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		result = NULL;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_object_unref0 (info);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_object_unref0 (file);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		return result;
#line 446 "rygel-media-art-store.c"
	}
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp19_ = rygel_thumbnail_new ("image/jpeg", "JPEG_TN", "jpg");
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	thumb = _tmp19_;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp20_ = thumb;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp21_ = file;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp22_ = g_file_get_uri (_tmp21_);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_g_free0 (((RygelIconInfo*) _tmp20_)->uri);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	((RygelIconInfo*) _tmp20_)->uri = _tmp22_;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp23_ = thumb;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp24_ = info;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp25_ = g_file_info_get_size (_tmp24_);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	((RygelIconInfo*) _tmp23_)->size = (gint64) _tmp25_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	result = thumb;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_g_object_unref0 (info);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_g_object_unref0 (file);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	return result;
#line 480 "rygel-media-art-store.c"
}


RygelThumbnail* rygel_media_art_store_find_media_art_any (RygelMediaArtStore* self, RygelMusicItem* item, GError** error) {
	RygelThumbnail* result = NULL;
	RygelThumbnail* thumb = NULL;
	RygelMusicItem* _tmp0_ = NULL;
	RygelThumbnail* _tmp1_ = NULL;
	RygelThumbnail* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp0_ = item;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp1_ = rygel_media_art_store_find_media_art (self, _tmp0_, FALSE, &_inner_error_);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	thumb = _tmp1_;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	if (_inner_error_ != NULL) {
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		g_propagate_error (error, _inner_error_);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		return NULL;
#line 507 "rygel-media-art-store.c"
	}
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp2_ = thumb;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	if (_tmp2_ == NULL) {
#line 513 "rygel-media-art-store.c"
		RygelThumbnail* _tmp3_ = NULL;
		RygelMusicItem* _tmp4_ = NULL;
		RygelThumbnail* _tmp5_ = NULL;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp4_ = item;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp5_ = rygel_media_art_store_find_media_art (self, _tmp4_, TRUE, &_inner_error_);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp3_ = _tmp5_;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		if (_inner_error_ != NULL) {
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_propagate_error (error, _inner_error_);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_rygel_icon_info_unref0 (thumb);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			return NULL;
#line 531 "rygel-media-art-store.c"
		}
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_rygel_icon_info_unref0 (thumb);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		thumb = _tmp3_;
#line 537 "rygel-media-art-store.c"
	}
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	result = thumb;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	return result;
#line 543 "rygel-media-art-store.c"
}


GFile* rygel_media_art_store_get_media_art_file (RygelMediaArtStore* self, const gchar* type, RygelMusicItem* item, gboolean simple) {
	GFile* result = NULL;
	gchar* hash = NULL;
	gchar* suffix = NULL;
	gboolean _tmp0_ = FALSE;
	gchar* file_path = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* path = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GFile* _tmp15_ = NULL;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_val_if_fail (type != NULL, NULL);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp0_ = simple;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	if (_tmp0_) {
#line 571 "rygel-media-art-store.c"
		const gchar* _tmp1_ = NULL;
		RygelMusicItem* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp1_ = type;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp2_ = item;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp3_ = rygel_media_art_store_get_simple_hash (self, _tmp1_, _tmp2_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_free0 (hash);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		hash = _tmp3_;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp4_ = g_strdup ("jpg");
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_free0 (suffix);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		suffix = _tmp4_;
#line 592 "rygel-media-art-store.c"
	} else {
		const gchar* _tmp5_ = NULL;
		RygelMusicItem* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp5_ = type;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp6_ = item;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp7_ = rygel_media_art_store_get_hash (self, _tmp5_, _tmp6_);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_free0 (hash);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		hash = _tmp7_;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp8_ = g_strdup ("jpeg");
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_free0 (suffix);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		suffix = _tmp8_;
#line 614 "rygel-media-art-store.c"
	}
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp9_ = type;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp10_ = hash;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp11_ = suffix;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp12_ = g_strdup_printf ("%s-%s.%s", _tmp9_, _tmp10_, _tmp11_);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	file_path = _tmp12_;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp13_ = self->priv->directory;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp14_ = g_build_filename (_tmp13_, file_path, NULL);
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	path = _tmp14_;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp15_ = g_file_new_for_path (path);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	result = _tmp15_;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_g_free0 (path);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_g_free0 (file_path);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_g_free0 (suffix);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_g_free0 (hash);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	return result;
#line 646 "rygel-media-art-store.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 965 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 966 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 966 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 966 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 966 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 664 "rygel-media-art-store.c"
}


static void _vala_array_add1 (GRegex*** array, int* length, int* size, GRegex* value) {
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	if ((*length) == (*size)) {
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		*array = g_renew (GRegex*, *array, (*size) + 1);
#line 675 "rygel-media-art-store.c"
	}
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	(*array)[(*length)++] = value;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	(*array)[*length] = NULL;
#line 681 "rygel-media-art-store.c"
}


static RygelMediaArtStore* rygel_media_art_store_construct (GType object_type, GError** error) {
	RygelMediaArtStore * self = NULL;
	gchar* dir = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GFile* file = NULL;
	const gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	self = (RygelMediaArtStore*) g_object_new (object_type, NULL);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp0_ = g_get_user_cache_dir ();
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp1_ = g_build_filename (_tmp0_, "media-art", NULL);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	dir = _tmp1_;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp2_ = dir;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp3_ = g_file_new_for_path (_tmp2_);
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	file = _tmp3_;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp4_ = file;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp5_ = g_file_query_exists (_tmp4_, NULL);
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	if (!_tmp5_) {
#line 718 "rygel-media-art-store.c"
		const gchar* _tmp6_ = NULL;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp6_ = dir;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		g_mkdir_with_parents (_tmp6_, 0750);
#line 724 "rygel-media-art-store.c"
	}
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp7_ = dir;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_g_free0 (self->priv->directory);
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	self->priv->directory = _tmp8_;
#line 734 "rygel-media-art-store.c"
	{
		gchar* regex_string = NULL;
		gchar* _tmp9_ = NULL;
		GRegex* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		GRegex* _tmp14_ = NULL;
		GRegex* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		GRegex* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		GRegex* _tmp21_ = NULL;
		GRegex* _tmp22_ = NULL;
		GRegex* _tmp23_ = NULL;
		GRegex* _tmp24_ = NULL;
		GRegex** _tmp25_ = NULL;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp9_ = g_regex_escape_string (RYGEL_MEDIA_ART_STORE_INVALID_CHARS, -1);
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		regex_string = _tmp9_;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp11_ = regex_string;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp12_ = g_strdup_printf ("[%s]", _tmp11_);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp13_ = _tmp12_;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp14_ = g_regex_new (_tmp13_, 0, 0, &_inner_error_);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp15_ = _tmp14_;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_free0 (_tmp13_);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp10_ = _tmp15_;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		if (_inner_error_ != NULL) {
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_free0 (regex_string);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 778 "rygel-media-art-store.c"
				goto __catch1_g_regex_error;
			}
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_free0 (regex_string);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_object_unref0 (file);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_free0 (dir);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_clear_error (&_inner_error_);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			return NULL;
#line 793 "rygel-media-art-store.c"
		}
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_regex_unref0 (self->priv->char_remove_regex);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		self->priv->char_remove_regex = _tmp10_;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp16_ = g_regex_escape_string (RYGEL_MEDIA_ART_STORE_CONVERT_CHARS, -1);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_free0 (regex_string);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		regex_string = _tmp16_;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp18_ = regex_string;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp19_ = g_strdup_printf ("[%s]", _tmp18_);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp20_ = _tmp19_;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp21_ = g_regex_new (_tmp20_, 0, 0, &_inner_error_);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp22_ = _tmp21_;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_free0 (_tmp20_);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp17_ = _tmp22_;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		if (_inner_error_ != NULL) {
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_free0 (regex_string);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 825 "rygel-media-art-store.c"
				goto __catch1_g_regex_error;
			}
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_free0 (regex_string);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_object_unref0 (file);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_free0 (dir);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_clear_error (&_inner_error_);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			return NULL;
#line 840 "rygel-media-art-store.c"
		}
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_regex_unref0 (self->priv->char_convert_regex);
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		self->priv->char_convert_regex = _tmp17_;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp24_ = g_regex_new ("\\s+", 0, 0, &_inner_error_);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp23_ = _tmp24_;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		if (_inner_error_ != NULL) {
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_free0 (regex_string);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 856 "rygel-media-art-store.c"
				goto __catch1_g_regex_error;
			}
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_free0 (regex_string);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_object_unref0 (file);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_free0 (dir);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_clear_error (&_inner_error_);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			return NULL;
#line 871 "rygel-media-art-store.c"
		}
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_regex_unref0 (self->priv->space_compress_regex);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		self->priv->space_compress_regex = _tmp23_;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp25_ = g_new0 (GRegex*, 0 + 1);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		self->priv->block_regexes = (_vala_array_free (self->priv->block_regexes, self->priv->block_regexes_length1, (GDestroyNotify) g_regex_unref), NULL);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		self->priv->block_regexes = _tmp25_;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		self->priv->block_regexes_length1 = 0;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		self->priv->_block_regexes_size_ = self->priv->block_regexes_length1;
#line 887 "rygel-media-art-store.c"
		{
			const gchar** block_collection = NULL;
			gint block_collection_length1 = 0;
			gint _block_collection_size_ = 0;
			gint block_it = 0;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			block_collection = RYGEL_MEDIA_ART_STORE_BLOCKS;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			block_collection_length1 = G_N_ELEMENTS (RYGEL_MEDIA_ART_STORE_BLOCKS);
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			for (block_it = 0; block_it < G_N_ELEMENTS (RYGEL_MEDIA_ART_STORE_BLOCKS); block_it = block_it + 1) {
#line 899 "rygel-media-art-store.c"
				const gchar* block = NULL;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				block = block_collection[block_it];
#line 903 "rygel-media-art-store.c"
				{
					gchar* block_re = NULL;
					const gchar* _tmp26_ = NULL;
					gchar _tmp27_ = '\0';
					gchar* _tmp28_ = NULL;
					gchar* _tmp29_ = NULL;
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_ = NULL;
					const gchar* _tmp32_ = NULL;
					gchar _tmp33_ = '\0';
					gchar* _tmp34_ = NULL;
					gchar* _tmp35_ = NULL;
					gchar* _tmp36_ = NULL;
					gchar* _tmp37_ = NULL;
					const gchar* _tmp38_ = NULL;
					gchar _tmp39_ = '\0';
					gchar* _tmp40_ = NULL;
					gchar* _tmp41_ = NULL;
					gchar* _tmp42_ = NULL;
					gchar* _tmp43_ = NULL;
					gchar* _tmp44_ = NULL;
					gchar* _tmp45_ = NULL;
					GRegex* _tmp46_ = NULL;
					const gchar* _tmp47_ = NULL;
					GRegex* _tmp48_ = NULL;
					GRegex** _tmp49_ = NULL;
					gint _tmp49__length1 = 0;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp26_ = block;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp27_ = string_get (_tmp26_, (glong) 0);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp28_ = g_strdup_printf ("%C", _tmp27_);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp29_ = _tmp28_;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp30_ = g_regex_escape_string (_tmp29_, -1);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp31_ = _tmp30_;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp32_ = block;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp33_ = string_get (_tmp32_, (glong) 1);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp34_ = g_strdup_printf ("%C", _tmp33_);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp35_ = _tmp34_;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp36_ = g_regex_escape_string (_tmp35_, -1);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp37_ = _tmp36_;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp38_ = block;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp39_ = string_get (_tmp38_, (glong) 1);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp40_ = g_strdup_printf ("%C", _tmp39_);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp41_ = _tmp40_;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp42_ = g_regex_escape_string (_tmp41_, -1);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp43_ = _tmp42_;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp44_ = g_strdup_printf (RYGEL_MEDIA_ART_STORE_BLOCK_PATTERN, _tmp31_, _tmp37_, _tmp43_);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp45_ = _tmp44_;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_g_free0 (_tmp43_);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_g_free0 (_tmp41_);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_g_free0 (_tmp37_);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_g_free0 (_tmp35_);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_g_free0 (_tmp31_);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_g_free0 (_tmp29_);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					block_re = _tmp45_;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp47_ = block_re;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp48_ = g_regex_new (_tmp47_, 0, 0, &_inner_error_);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp46_ = _tmp48_;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					if (_inner_error_ != NULL) {
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
						_g_free0 (block_re);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
						_g_free0 (regex_string);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
						if (_inner_error_->domain == G_REGEX_ERROR) {
#line 999 "rygel-media-art-store.c"
							goto __catch1_g_regex_error;
						}
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
						_g_free0 (block_re);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
						_g_free0 (regex_string);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
						_g_object_unref0 (file);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
						_g_free0 (dir);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
						g_clear_error (&_inner_error_);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
						return NULL;
#line 1016 "rygel-media-art-store.c"
					}
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp49_ = self->priv->block_regexes;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp49__length1 = self->priv->block_regexes_length1;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_vala_array_add1 (&self->priv->block_regexes, &self->priv->block_regexes_length1, &self->priv->_block_regexes_size_, _tmp46_);
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_g_free0 (block_re);
#line 1026 "rygel-media-art-store.c"
				}
			}
		}
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_free0 (regex_string);
#line 1032 "rygel-media-art-store.c"
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* _error_ = NULL;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_error_ = _inner_error_;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_inner_error_ = NULL;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		g_assert_not_reached ();
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_error_free0 (_error_);
#line 1046 "rygel-media-art-store.c"
	}
	__finally1:
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	if (_inner_error_ != NULL) {
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		if (_inner_error_->domain == MEDIA_ART_STORE_ERROR) {
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_propagate_error (error, _inner_error_);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_object_unref0 (file);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_free0 (dir);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_object_unref0 (self);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			return NULL;
#line 1063 "rygel-media-art-store.c"
		} else {
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_object_unref0 (file);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_free0 (dir);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_clear_error (&_inner_error_);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			return NULL;
#line 1075 "rygel-media-art-store.c"
		}
	}
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_g_object_unref0 (file);
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_g_free0 (dir);
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	return self;
#line 1084 "rygel-media-art-store.c"
}


static RygelMediaArtStore* rygel_media_art_store_new (GError** error) {
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	return rygel_media_art_store_construct (RYGEL_TYPE_MEDIA_ART_STORE, error);
#line 1091 "rygel-media-art-store.c"
}


static gchar* rygel_media_art_store_get_simple_hash (RygelMediaArtStore* self, const gchar* type, RygelMusicItem* item) {
	gchar* result = NULL;
	gchar* hash = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	static GQuark _tmp2_label0 = 0;
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	static GQuark _tmp2_label1 = 0;
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	static GQuark _tmp2_label2 = 0;
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	static GQuark _tmp2_label3 = 0;
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	static GQuark _tmp2_label4 = 0;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_val_if_fail (type != NULL, NULL);
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp0_ = type;
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp1_ = _tmp0_;
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	if ((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("artist")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("radio"))))) {
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		switch (0) {
#line 1127 "rygel-media-art-store.c"
			default:
			{
				RygelMusicItem* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp4_ = item;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp5_ = rygel_music_item_get_artist (_tmp4_);
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp6_ = _tmp5_;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp7_ = rygel_media_art_store_normalize_and_hash (self, _tmp6_, TRUE);
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_g_free0 (hash);
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				hash = _tmp7_;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				break;
#line 1148 "rygel-media-art-store.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("podcast")))) {
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		switch (0) {
#line 1154 "rygel-media-art-store.c"
			default:
			{
				RygelMusicItem* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp8_ = item;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp9_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp8_);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp10_ = _tmp9_;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp11_ = rygel_media_art_store_normalize_and_hash (self, _tmp10_, TRUE);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_g_free0 (hash);
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				hash = _tmp11_;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				break;
#line 1175 "rygel-media-art-store.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("album")))) {
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		switch (0) {
#line 1181 "rygel-media-art-store.c"
			default:
			{
				RygelMusicItem* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				RygelMusicItem* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp12_ = item;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp13_ = rygel_music_item_get_artist (_tmp12_);
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp14_ = _tmp13_;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp15_ = g_strconcat (_tmp14_, "\t", NULL);
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp16_ = _tmp15_;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp17_ = item;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp18_ = rygel_music_item_get_album (_tmp17_);
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp19_ = _tmp18_;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp20_ = g_strconcat (_tmp16_, _tmp19_, NULL);
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp21_ = _tmp20_;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp22_ = rygel_media_art_store_normalize_and_hash (self, _tmp21_, TRUE);
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_g_free0 (hash);
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				hash = _tmp22_;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_g_free0 (_tmp21_);
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_g_free0 (_tmp16_);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				break;
#line 1227 "rygel-media-art-store.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("track")))) {
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		switch (0) {
#line 1233 "rygel-media-art-store.c"
			default:
			{
				RygelMusicItem* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				const gchar* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				RygelMusicItem* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				gchar* _tmp31_ = NULL;
				gchar* _tmp32_ = NULL;
				gchar* _tmp33_ = NULL;
				gchar* _tmp34_ = NULL;
				RygelMusicItem* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				const gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				gchar* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp23_ = item;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp24_ = rygel_music_item_get_artist (_tmp23_);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp25_ = _tmp24_;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp26_ = g_strconcat (_tmp25_, "\t", NULL);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp27_ = _tmp26_;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp28_ = item;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp29_ = rygel_music_item_get_album (_tmp28_);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp30_ = _tmp29_;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp31_ = g_strconcat (_tmp27_, _tmp30_, NULL);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp32_ = _tmp31_;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp33_ = g_strconcat (_tmp32_, "\t", NULL);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp34_ = _tmp33_;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp35_ = item;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp36_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp35_);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp37_ = _tmp36_;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp38_ = g_strconcat (_tmp34_, _tmp37_, NULL);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp39_ = _tmp38_;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp40_ = rygel_media_art_store_normalize_and_hash (self, _tmp39_, TRUE);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_g_free0 (hash);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				hash = _tmp40_;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_g_free0 (_tmp39_);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_g_free0 (_tmp34_);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_g_free0 (_tmp32_);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_g_free0 (_tmp27_);
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				break;
#line 1304 "rygel-media-art-store.c"
			}
		}
	} else {
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		switch (0) {
#line 1310 "rygel-media-art-store.c"
			default:
			{
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				g_assert_not_reached ();
#line 1315 "rygel-media-art-store.c"
			}
		}
	}
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	result = hash;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	return result;
#line 1323 "rygel-media-art-store.c"
}


static gchar* rygel_media_art_store_get_hash (RygelMediaArtStore* self, const gchar* type, RygelMusicItem* item) {
	gchar* result = NULL;
	gchar* b = NULL;
	gchar* c = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	static GQuark _tmp2_label0 = 0;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	static GQuark _tmp2_label1 = 0;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	static GQuark _tmp2_label2 = 0;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	static GQuark _tmp2_label3 = 0;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	static GQuark _tmp2_label4 = 0;
#line 1344 "rygel-media-art-store.c"
	const gchar* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_val_if_fail (type != NULL, NULL);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	b = NULL;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	c = NULL;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp0_ = type;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp1_ = _tmp0_;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("track")))) {
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		switch (0) {
#line 1368 "rygel-media-art-store.c"
			default:
			{
				RygelMusicItem* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				RygelMusicItem* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				RygelMusicItem* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp4_ = item;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp5_ = rygel_music_item_get_artist (_tmp4_);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp6_ = _tmp5_;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp7_ = rygel_media_art_store_normalize_and_hash (self, _tmp6_, FALSE);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp8_ = _tmp7_;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp9_ = g_strconcat (_tmp8_, "-", NULL);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp10_ = _tmp9_;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp11_ = item;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp12_ = rygel_music_item_get_album (_tmp11_);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp13_ = _tmp12_;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp14_ = rygel_media_art_store_normalize_and_hash (self, _tmp13_, FALSE);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp15_ = _tmp14_;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp16_ = g_strconcat (_tmp10_, _tmp15_, NULL);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_g_free0 (b);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				b = _tmp16_;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_g_free0 (_tmp15_);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_g_free0 (_tmp10_);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_g_free0 (_tmp8_);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp17_ = item;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp18_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp17_);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp19_ = _tmp18_;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp20_ = rygel_media_art_store_normalize_and_hash (self, _tmp19_, FALSE);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_g_free0 (c);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				c = _tmp20_;
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				break;
#line 1438 "rygel-media-art-store.c"
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("album")))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("artist"))))) {
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		switch (0) {
#line 1444 "rygel-media-art-store.c"
			default:
			{
				RygelMusicItem* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				RygelMusicItem* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp21_ = item;
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp22_ = rygel_music_item_get_artist (_tmp21_);
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp23_ = _tmp22_;
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp24_ = rygel_media_art_store_normalize_and_hash (self, _tmp23_, FALSE);
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_g_free0 (b);
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				b = _tmp24_;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp25_ = item;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp26_ = rygel_music_item_get_album (_tmp25_);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp27_ = _tmp26_;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp28_ = rygel_media_art_store_normalize_and_hash (self, _tmp27_, FALSE);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_g_free0 (c);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				c = _tmp28_;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				break;
#line 1481 "rygel-media-art-store.c"
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("radio")))) || (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("podcast"))))) {
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		switch (0) {
#line 1487 "rygel-media-art-store.c"
			default:
			{
				RygelMusicItem* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				gchar* _tmp32_ = NULL;
				gchar* _tmp33_ = NULL;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp29_ = item;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp30_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp29_);
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp31_ = _tmp30_;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp32_ = rygel_media_art_store_normalize_and_hash (self, _tmp31_, FALSE);
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_g_free0 (b);
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				b = _tmp32_;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp33_ = g_strdup (RYGEL_MEDIA_ART_STORE_PLACEHOLDER_HASH);
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_g_free0 (c);
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				c = _tmp33_;
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				break;
#line 1515 "rygel-media-art-store.c"
			}
		}
	}
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp34_ = b;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp35_ = c;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp36_ = g_strdup_printf ("%s-%s", _tmp34_, _tmp35_);
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	result = _tmp36_;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_g_free0 (c);
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_g_free0 (b);
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	return result;
#line 1533 "rygel-media-art-store.c"
}


static gchar* rygel_media_art_store_normalize_and_hash (RygelMediaArtStore* self, const gchar* input, gboolean utf8_only) {
	gchar* result = NULL;
	gchar* normalized = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp0_ = g_strdup (" ");
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	normalized = _tmp0_;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp2_ = input;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	if (_tmp2_ != NULL) {
#line 1556 "rygel-media-art-store.c"
		const gchar* _tmp3_ = NULL;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp3_ = input;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp1_ = g_strcmp0 (_tmp3_, "") != 0;
#line 1562 "rygel-media-art-store.c"
	} else {
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp1_ = FALSE;
#line 1566 "rygel-media-art-store.c"
	}
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp4_ = _tmp1_;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	if (_tmp4_) {
#line 1572 "rygel-media-art-store.c"
		gboolean _tmp5_ = FALSE;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp5_ = utf8_only;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		if (_tmp5_) {
#line 1580 "rygel-media-art-store.c"
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_tmp6_ = input;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_tmp7_ = g_strdup (_tmp6_);
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_free0 (normalized);
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			normalized = _tmp7_;
#line 1591 "rygel-media-art-store.c"
		} else {
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_tmp8_ = input;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_tmp9_ = rygel_media_art_store_strip_invalid_entities (self, _tmp8_);
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_free0 (normalized);
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			normalized = _tmp9_;
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_tmp10_ = normalized;
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_tmp11_ = g_utf8_strdown (_tmp10_, (gssize) (-1));
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_free0 (normalized);
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			normalized = _tmp11_;
#line 1613 "rygel-media-art-store.c"
		}
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp12_ = normalized;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp13_ = g_utf8_normalize (_tmp12_, (gssize) (-1), G_NORMALIZE_ALL);
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_free0 (normalized);
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		normalized = _tmp13_;
#line 1623 "rygel-media-art-store.c"
	}
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp14_ = normalized;
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp15_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp14_, (gsize) (-1));
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	result = _tmp15_;
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_g_free0 (normalized);
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	return result;
#line 1635 "rygel-media-art-store.c"
}


static gpointer _g_regex_ref0 (gpointer self) {
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	return self ? g_regex_ref (self) : NULL;
#line 1642 "rygel-media-art-store.c"
}


static gchar* rygel_media_art_store_strip_invalid_entities (RygelMediaArtStore* self, const gchar* original) {
	gchar* result = NULL;
	gchar* p = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_return_val_if_fail (original != NULL, NULL);
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp0_ = original;
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_g_free0 (p);
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	p = _tmp1_;
#line 1664 "rygel-media-art-store.c"
	{
		GRegex** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		gchar* _tmp8_ = NULL;
		GRegex* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		GRegex* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		GRegex* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp2_ = self->priv->block_regexes;
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp2__length1 = self->priv->block_regexes_length1;
#line 1684 "rygel-media-art-store.c"
		{
			GRegex** re_collection = NULL;
			gint re_collection_length1 = 0;
			gint _re_collection_size_ = 0;
			gint re_it = 0;
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			re_collection = _tmp2_;
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			re_collection_length1 = _tmp2__length1;
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			for (re_it = 0; re_it < _tmp2__length1; re_it = re_it + 1) {
#line 1696 "rygel-media-art-store.c"
				GRegex* _tmp3_ = NULL;
				GRegex* re = NULL;
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				_tmp3_ = _g_regex_ref0 (re_collection[re_it]);
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
				re = _tmp3_;
#line 1703 "rygel-media-art-store.c"
				{
					gchar* _tmp4_ = NULL;
					GRegex* _tmp5_ = NULL;
					const gchar* _tmp6_ = NULL;
					gchar* _tmp7_ = NULL;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp5_ = re;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp6_ = p;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp7_ = g_regex_replace_literal (_tmp5_, _tmp6_, (gssize) (-1), 0, "", 0, &_inner_error_);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_tmp4_ = _tmp7_;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					if (_inner_error_ != NULL) {
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
						_g_regex_unref0 (re);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
						if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1723 "rygel-media-art-store.c"
							goto __catch2_g_regex_error;
						}
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
						_g_regex_unref0 (re);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
						_g_free0 (p);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
						g_clear_error (&_inner_error_);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
						return NULL;
#line 1736 "rygel-media-art-store.c"
					}
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_g_free0 (p);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					p = _tmp4_;
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
					_g_regex_unref0 (re);
#line 1744 "rygel-media-art-store.c"
				}
			}
		}
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp9_ = self->priv->char_remove_regex;
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp10_ = p;
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp11_ = g_regex_replace_literal (_tmp9_, _tmp10_, (gssize) (-1), 0, "", 0, &_inner_error_);
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp8_ = _tmp11_;
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		if (_inner_error_ != NULL) {
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1760 "rygel-media-art-store.c"
				goto __catch2_g_regex_error;
			}
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_free0 (p);
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_clear_error (&_inner_error_);
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			return NULL;
#line 1771 "rygel-media-art-store.c"
		}
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_free0 (p);
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		p = _tmp8_;
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp13_ = self->priv->char_convert_regex;
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp14_ = p;
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp15_ = g_regex_replace_literal (_tmp13_, _tmp14_, (gssize) (-1), 0, " ", 0, &_inner_error_);
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp12_ = _tmp15_;
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		if (_inner_error_ != NULL) {
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1789 "rygel-media-art-store.c"
				goto __catch2_g_regex_error;
			}
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_free0 (p);
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_clear_error (&_inner_error_);
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			return NULL;
#line 1800 "rygel-media-art-store.c"
		}
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_free0 (p);
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		p = _tmp12_;
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp17_ = self->priv->space_compress_regex;
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp18_ = p;
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp19_ = g_regex_replace_literal (_tmp17_, _tmp18_, (gssize) (-1), 0, " ", 0, &_inner_error_);
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_tmp16_ = _tmp19_;
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		if (_inner_error_ != NULL) {
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1818 "rygel-media-art-store.c"
				goto __catch2_g_regex_error;
			}
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			_g_free0 (p);
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			g_clear_error (&_inner_error_);
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
			return NULL;
#line 1829 "rygel-media-art-store.c"
		}
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_free0 (p);
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		p = _tmp16_;
#line 233 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		result = p;
#line 233 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		return result;
#line 1839 "rygel-media-art-store.c"
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError* _error_ = NULL;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_error_ = _inner_error_;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_inner_error_ = NULL;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		g_assert_not_reached ();
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
		_g_error_free0 (_error_);
#line 1853 "rygel-media-art-store.c"
	}
	__finally2:
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_g_free0 (p);
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_clear_error (&_inner_error_);
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	return NULL;
#line 1864 "rygel-media-art-store.c"
}


static void rygel_media_art_store_class_init (RygelMediaArtStoreClass * klass) {
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	rygel_media_art_store_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaArtStorePrivate));
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_art_store_finalize;
#line 1875 "rygel-media-art-store.c"
}


static void rygel_media_art_store_instance_init (RygelMediaArtStore * self) {
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	self->priv = RYGEL_MEDIA_ART_STORE_GET_PRIVATE (self);
#line 1882 "rygel-media-art-store.c"
}


static void rygel_media_art_store_finalize (GObject* obj) {
	RygelMediaArtStore * self;
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStore);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_g_regex_unref0 (self->priv->char_remove_regex);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_g_regex_unref0 (self->priv->char_convert_regex);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_g_regex_unref0 (self->priv->space_compress_regex);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	self->priv->block_regexes = (_vala_array_free (self->priv->block_regexes, self->priv->block_regexes_length1, (GDestroyNotify) g_regex_unref), NULL);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	_g_free0 (self->priv->directory);
#line 34 "/home/jens/Source/rygel/src/librygel-server/rygel-media-art-store.vala"
	G_OBJECT_CLASS (rygel_media_art_store_parent_class)->finalize (obj);
#line 1902 "rygel-media-art-store.c"
}


/**
 * This maps RygelMusicItem objects to their cached cover art,
 * implementing the GNOME [[https://live.gnome.org/MediaArtStorageSpec|MediaArt storage specification]]
 * and the simplified version that Banshee uses.
 */
GType rygel_media_art_store_get_type (void) {
	static volatile gsize rygel_media_art_store_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_art_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaArtStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_art_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaArtStore), 0, (GInstanceInitFunc) rygel_media_art_store_instance_init, NULL };
		GType rygel_media_art_store_type_id;
		rygel_media_art_store_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaArtStore", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_art_store_type_id__volatile, rygel_media_art_store_type_id);
	}
	return rygel_media_art_store_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



