/* rygel-relational-expression.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-relational-expression.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gio/gio.h>
#include <gee.h>


#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelRelationalExpressionPrivate RygelRelationalExpressionPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_TRACKABLE_CONTAINER (rygel_trackable_container_get_type ())
#define RYGEL_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainer))
#define RYGEL_IS_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER))
#define RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainerIface))

typedef struct _RygelTrackableContainer RygelTrackableContainer;
typedef struct _RygelTrackableContainerIface RygelTrackableContainerIface;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_TRACKABLE_ITEM (rygel_trackable_item_get_type ())
#define RYGEL_TRACKABLE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKABLE_ITEM, RygelTrackableItem))
#define RYGEL_IS_TRACKABLE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKABLE_ITEM))
#define RYGEL_TRACKABLE_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKABLE_ITEM, RygelTrackableItemIface))

typedef struct _RygelTrackableItem RygelTrackableItem;
typedef struct _RygelTrackableItemIface RygelTrackableItemIface;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;

#define RYGEL_TYPE_IMAGE_ITEM (rygel_image_item_get_type ())
#define RYGEL_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItem))
#define RYGEL_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))
#define RYGEL_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))

typedef struct _RygelImageItem RygelImageItem;
typedef struct _RygelImageItemClass RygelImageItemClass;

#define RYGEL_TYPE_PHOTO_ITEM (rygel_photo_item_get_type ())
#define RYGEL_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItem))
#define RYGEL_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))
#define RYGEL_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))

typedef struct _RygelPhotoItem RygelPhotoItem;
typedef struct _RygelPhotoItemClass RygelPhotoItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelRelationalExpression {
	RygelSearchExpression parent_instance;
	RygelRelationalExpressionPrivate * priv;
};

struct _RygelRelationalExpressionClass {
	RygelSearchExpressionClass parent_class;
};

struct _RygelTrackableContainerIface {
	GTypeInterface parent_iface;
	void (*add_child) (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_child_finish) (RygelTrackableContainer* self, GAsyncResult* _res_);
	void (*remove_child) (RygelTrackableContainer* self, RygelMediaObject* object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_child_finish) (RygelTrackableContainer* self, GAsyncResult* _res_);
	gchar* (*get_service_reset_token) (RygelTrackableContainer* self);
	void (*set_service_reset_token) (RygelTrackableContainer* self, const gchar* token);
	guint32 (*get_system_update_id) (RygelTrackableContainer* self);
};

struct _RygelTrackableItemIface {
	GTypeInterface parent_iface;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	GeeArrayList* uris;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	guint32 update_id;
	gint64 storage_used;
	gint64 total_deleted_child_count;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_container) (RygelWritableContainer* self, RygelMediaContainer* container, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_reference) (RygelWritableContainer* self, RygelMediaObject* object, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*add_reference_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_container) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};


static gpointer rygel_relational_expression_parent_class = NULL;

gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_RELATIONAL_EXPRESSION_DUMMY_PROPERTY
};
#define RYGEL_RELATIONAL_EXPRESSION_CAPS "@id,@parentID,@refID,upnp:class," "dc:title,upnp:artist,upnp:album," "dc:creator,upnp:createClass,@childCount"
static gboolean rygel_relational_expression_real_satisfied_by (RygelSearchExpression* base, RygelMediaObject* media_object);
gboolean rygel_relational_expression_compare_string (RygelRelationalExpression* self, const gchar* str);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
const gchar* rygel_media_object_get_ref_id (RygelMediaObject* self);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self);
const gchar* rygel_media_object_get_upnp_class (RygelMediaObject* self);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
GType rygel_trackable_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_trackable_item_get_type (void) G_GNUC_CONST;
gboolean rygel_relational_expression_compare_uint (RygelRelationalExpression* self, guint integer);
guint rygel_media_object_get_object_update_id (RygelMediaObject* self);
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
static gboolean rygel_relational_expression_compare_create_class (RygelRelationalExpression* self, RygelWritableContainer* container);
GType rygel_image_item_get_type (void) G_GNUC_CONST;
GType rygel_photo_item_get_type (void) G_GNUC_CONST;
const gchar* rygel_media_item_get_creator (RygelMediaItem* self);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
const gchar* rygel_music_item_get_artist (RygelMusicItem* self);
const gchar* rygel_music_item_get_album (RygelMusicItem* self);
gboolean rygel_relational_expression_compare_int (RygelRelationalExpression* self, gint integer);
gint rygel_media_container_get_child_count (RygelMediaContainer* self);
static gchar* rygel_relational_expression_real_to_string (RygelSearchExpression* base);
GeeArrayList* rygel_writable_container_get_create_classes (RygelWritableContainer* self);
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
RygelSearchExpression* rygel_search_expression_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GType h_type, GBoxedCopyFunc h_dup_func, GDestroyNotify h_destroy_func, GType i_type, GBoxedCopyFunc i_dup_func, GDestroyNotify i_destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	return self ? g_object_ref (self) : NULL;
#line 339 "rygel-relational-expression.c"
}


static gboolean rygel_relational_expression_real_satisfied_by (RygelSearchExpression* base, RygelMediaObject* media_object) {
	RygelRelationalExpression * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	static GQuark _tmp2_label0 = 0;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	static GQuark _tmp2_label1 = 0;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	static GQuark _tmp2_label2 = 0;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	static GQuark _tmp2_label3 = 0;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	static GQuark _tmp2_label4 = 0;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	static GQuark _tmp2_label5 = 0;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	static GQuark _tmp2_label6 = 0;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	static GQuark _tmp2_label7 = 0;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	static GQuark _tmp2_label8 = 0;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	static GQuark _tmp2_label9 = 0;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	static GQuark _tmp2_label10 = 0;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	static GQuark _tmp2_label11 = 0;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	self = (RygelRelationalExpression*) base;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	g_return_val_if_fail (media_object != NULL, FALSE);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	_tmp0_ = ((RygelSearchExpression*) self)->operand1;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	_tmp1_ = (const gchar*) _tmp0_;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("@id")))) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		switch (0) {
#line 387 "rygel-relational-expression.c"
			default:
			{
				RygelMediaObject* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp4_ = media_object;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp5_ = rygel_media_object_get_id (_tmp4_);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp6_ = _tmp5_;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp7_ = rygel_relational_expression_compare_string (self, _tmp6_);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				result = _tmp7_;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				return result;
#line 406 "rygel-relational-expression.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("@refID")))) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		switch (0) {
#line 412 "rygel-relational-expression.c"
			default:
			{
				RygelMediaObject* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp8_ = media_object;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp9_ = rygel_media_object_get_ref_id (_tmp8_);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp10_ = _tmp9_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp11_ = rygel_relational_expression_compare_string (self, _tmp10_);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				result = _tmp11_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				return result;
#line 431 "rygel-relational-expression.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("@parentID")))) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		switch (0) {
#line 437 "rygel-relational-expression.c"
			default:
			{
				RygelMediaObject* _tmp12_ = NULL;
				RygelMediaContainer* _tmp13_ = NULL;
				RygelMediaContainer* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				gboolean _tmp17_ = FALSE;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp12_ = media_object;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp13_ = rygel_media_object_get_parent (_tmp12_);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp14_ = _tmp13_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp15_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp14_);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp16_ = _tmp15_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp17_ = rygel_relational_expression_compare_string (self, _tmp16_);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				result = _tmp17_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				return result;
#line 462 "rygel-relational-expression.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("upnp:class")))) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		switch (0) {
#line 468 "rygel-relational-expression.c"
			default:
			{
				RygelMediaObject* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				gboolean _tmp21_ = FALSE;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp18_ = media_object;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp19_ = rygel_media_object_get_upnp_class (_tmp18_);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp20_ = _tmp19_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp21_ = rygel_relational_expression_compare_string (self, _tmp20_);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				result = _tmp21_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				return result;
#line 487 "rygel-relational-expression.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("dc:title")))) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		switch (0) {
#line 493 "rygel-relational-expression.c"
			default:
			{
				RygelMediaObject* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				gboolean _tmp25_ = FALSE;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp22_ = media_object;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp23_ = rygel_media_object_get_title (_tmp22_);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp24_ = _tmp23_;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp25_ = rygel_relational_expression_compare_string (self, _tmp24_);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				result = _tmp25_;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				return result;
#line 512 "rygel-relational-expression.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("upnp:objectUpdateID")))) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		switch (0) {
#line 518 "rygel-relational-expression.c"
			default:
			{
				gconstpointer _tmp26_ = NULL;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp26_ = ((RygelSearchExpression*) self)->op;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				if (((GUPnPSearchCriteriaOp) ((gintptr) _tmp26_)) == GUPNP_SEARCH_CRITERIA_OP_EXISTS) {
#line 526 "rygel-relational-expression.c"
					gconstpointer _tmp27_ = NULL;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					_tmp27_ = ((RygelSearchExpression*) self)->operand2;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					if (g_strcmp0 ((const gchar*) _tmp27_, "true") == 0) {
#line 532 "rygel-relational-expression.c"
						gboolean _tmp28_ = FALSE;
						RygelMediaObject* _tmp29_ = NULL;
						gboolean _tmp31_ = FALSE;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
						_tmp29_ = media_object;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
							_tmp28_ = TRUE;
#line 542 "rygel-relational-expression.c"
						} else {
							RygelMediaObject* _tmp30_ = NULL;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
							_tmp30_ = media_object;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
							_tmp28_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, RYGEL_TYPE_TRACKABLE_ITEM);
#line 549 "rygel-relational-expression.c"
						}
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
						_tmp31_ = _tmp28_;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
						result = _tmp31_;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
						return result;
#line 557 "rygel-relational-expression.c"
					} else {
						gboolean _tmp32_ = FALSE;
						RygelMediaObject* _tmp33_ = NULL;
						gboolean _tmp35_ = FALSE;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
						_tmp33_ = media_object;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
							_tmp32_ = TRUE;
#line 568 "rygel-relational-expression.c"
						} else {
							RygelMediaObject* _tmp34_ = NULL;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
							_tmp34_ = media_object;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
							_tmp32_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, RYGEL_TYPE_TRACKABLE_ITEM);
#line 575 "rygel-relational-expression.c"
						}
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
						_tmp35_ = _tmp32_;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
						result = !_tmp35_;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
						return result;
#line 583 "rygel-relational-expression.c"
					}
				} else {
					RygelMediaObject* _tmp36_ = NULL;
					guint _tmp37_ = 0U;
					guint _tmp38_ = 0U;
					gboolean _tmp39_ = FALSE;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					_tmp36_ = media_object;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					_tmp37_ = rygel_media_object_get_object_update_id (_tmp36_);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					_tmp38_ = _tmp37_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					_tmp39_ = rygel_relational_expression_compare_uint (self, _tmp38_);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					result = _tmp39_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					return result;
#line 602 "rygel-relational-expression.c"
				}
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("upnp:containerUpdateID")))) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		switch (0) {
#line 609 "rygel-relational-expression.c"
			default:
			{
				RygelMediaObject* _tmp40_ = NULL;
				gconstpointer _tmp41_ = NULL;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp40_ = media_object;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, RYGEL_TYPE_MEDIA_CONTAINER)) {
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					result = FALSE;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					return result;
#line 622 "rygel-relational-expression.c"
				}
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp41_ = ((RygelSearchExpression*) self)->op;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				if (((GUPnPSearchCriteriaOp) ((gintptr) _tmp41_)) == GUPNP_SEARCH_CRITERIA_OP_EXISTS) {
#line 628 "rygel-relational-expression.c"
					gconstpointer _tmp42_ = NULL;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					_tmp42_ = ((RygelSearchExpression*) self)->operand2;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					if (g_strcmp0 ((const gchar*) _tmp42_, "true") == 0) {
#line 634 "rygel-relational-expression.c"
						RygelMediaObject* _tmp43_ = NULL;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
						_tmp43_ = media_object;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
						result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp43_, RYGEL_TYPE_TRACKABLE_CONTAINER);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
						return result;
#line 642 "rygel-relational-expression.c"
					} else {
						RygelMediaObject* _tmp44_ = NULL;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
						_tmp44_ = media_object;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
						result = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, RYGEL_TYPE_TRACKABLE_CONTAINER);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
						return result;
#line 651 "rygel-relational-expression.c"
					}
				} else {
					RygelMediaContainer* container = NULL;
					RygelMediaObject* _tmp45_ = NULL;
					RygelMediaContainer* _tmp46_ = NULL;
					RygelMediaContainer* _tmp47_ = NULL;
					guint32 _tmp48_ = 0U;
					gboolean _tmp49_ = FALSE;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					_tmp45_ = media_object;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					_tmp46_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp45_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp45_) : NULL);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					container = _tmp46_;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					_tmp47_ = container;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					_tmp48_ = _tmp47_->update_id;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					_tmp49_ = rygel_relational_expression_compare_uint (self, (guint) _tmp48_);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					result = _tmp49_;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					_g_object_unref0 (container);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					return result;
#line 678 "rygel-relational-expression.c"
				}
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("upnp:createClass")))) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		switch (0) {
#line 685 "rygel-relational-expression.c"
			default:
			{
				RygelMediaObject* _tmp50_ = NULL;
				RygelMediaObject* _tmp51_ = NULL;
				gboolean _tmp52_ = FALSE;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp50_ = media_object;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, RYGEL_TYPE_WRITABLE_CONTAINER)) {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					result = FALSE;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					return result;
#line 699 "rygel-relational-expression.c"
				}
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp51_ = media_object;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp52_ = rygel_relational_expression_compare_create_class (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, RYGEL_TYPE_WRITABLE_CONTAINER) ? ((RygelWritableContainer*) _tmp51_) : NULL);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				result = _tmp52_;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				return result;
#line 709 "rygel-relational-expression.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("dc:creator")))) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		switch (0) {
#line 715 "rygel-relational-expression.c"
			default:
			{
				RygelMediaObject* _tmp53_ = NULL;
				RygelMediaObject* _tmp54_ = NULL;
				const gchar* _tmp55_ = NULL;
				const gchar* _tmp56_ = NULL;
				gboolean _tmp57_ = FALSE;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp53_ = media_object;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, RYGEL_TYPE_PHOTO_ITEM)) {
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					result = FALSE;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					return result;
#line 731 "rygel-relational-expression.c"
				}
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp54_ = media_object;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp55_ = rygel_media_item_get_creator ((RygelMediaItem*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, RYGEL_TYPE_PHOTO_ITEM) ? ((RygelPhotoItem*) _tmp54_) : NULL));
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp56_ = _tmp55_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp57_ = rygel_relational_expression_compare_string (self, _tmp56_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				result = _tmp57_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				return result;
#line 745 "rygel-relational-expression.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("upnp:artist")))) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		switch (0) {
#line 751 "rygel-relational-expression.c"
			default:
			{
				RygelMediaObject* _tmp58_ = NULL;
				RygelMediaObject* _tmp59_ = NULL;
				const gchar* _tmp60_ = NULL;
				const gchar* _tmp61_ = NULL;
				gboolean _tmp62_ = FALSE;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp58_ = media_object;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp58_, RYGEL_TYPE_MUSIC_ITEM)) {
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					result = FALSE;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					return result;
#line 767 "rygel-relational-expression.c"
				}
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp59_ = media_object;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp60_ = rygel_music_item_get_artist (G_TYPE_CHECK_INSTANCE_TYPE (_tmp59_, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) _tmp59_) : NULL);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp61_ = _tmp60_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp62_ = rygel_relational_expression_compare_string (self, _tmp61_);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				result = _tmp62_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				return result;
#line 781 "rygel-relational-expression.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("upnp:album")))) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		switch (0) {
#line 787 "rygel-relational-expression.c"
			default:
			{
				RygelMediaObject* _tmp63_ = NULL;
				RygelMediaObject* _tmp64_ = NULL;
				const gchar* _tmp65_ = NULL;
				const gchar* _tmp66_ = NULL;
				gboolean _tmp67_ = FALSE;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp63_ = media_object;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp63_, RYGEL_TYPE_MUSIC_ITEM)) {
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					result = FALSE;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					return result;
#line 803 "rygel-relational-expression.c"
				}
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp64_ = media_object;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp65_ = rygel_music_item_get_album (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) _tmp64_) : NULL);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp66_ = _tmp65_;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp67_ = rygel_relational_expression_compare_string (self, _tmp66_);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				result = _tmp67_;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				return result;
#line 817 "rygel-relational-expression.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("@childCount")))) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		switch (0) {
#line 823 "rygel-relational-expression.c"
			default:
			{
				RygelMediaObject* _tmp68_ = NULL;
				RygelMediaContainer* container = NULL;
				RygelMediaObject* _tmp69_ = NULL;
				RygelMediaContainer* _tmp70_ = NULL;
				RygelMediaContainer* _tmp71_ = NULL;
				gint _tmp72_ = 0;
				gint _tmp73_ = 0;
				gboolean _tmp74_ = FALSE;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp68_ = media_object;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp68_, RYGEL_TYPE_MEDIA_CONTAINER)) {
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					result = FALSE;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
					return result;
#line 842 "rygel-relational-expression.c"
				}
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp69_ = media_object;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp70_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp69_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp69_) : NULL);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				container = _tmp70_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp71_ = container;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp72_ = rygel_media_container_get_child_count (_tmp71_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp73_ = _tmp72_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp74_ = rygel_relational_expression_compare_int (self, _tmp73_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				result = _tmp74_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_g_object_unref0 (container);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				return result;
#line 864 "rygel-relational-expression.c"
			}
		}
	} else {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		switch (0) {
#line 870 "rygel-relational-expression.c"
			default:
			{
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				result = FALSE;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				return result;
#line 877 "rygel-relational-expression.c"
			}
		}
	}
}


static gchar* rygel_relational_expression_real_to_string (RygelSearchExpression* base) {
	RygelRelationalExpression * self;
	gchar* result = NULL;
	gconstpointer _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	self = (RygelRelationalExpression*) base;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	_tmp0_ = ((RygelSearchExpression*) self)->operand1;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	_tmp1_ = ((RygelSearchExpression*) self)->op;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	_tmp2_ = ((RygelSearchExpression*) self)->operand2;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	_tmp3_ = g_strdup_printf ("%s %d %s", (const gchar*) _tmp0_, (gint) ((GUPnPSearchCriteriaOp) ((gintptr) _tmp1_)), (const gchar*) _tmp2_);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	result = _tmp3_;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	return result;
#line 905 "rygel-relational-expression.c"
}


static gboolean rygel_relational_expression_compare_create_class (RygelRelationalExpression* self, RygelWritableContainer* container) {
	gboolean result = FALSE;
	gboolean ret = FALSE;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	g_return_val_if_fail (container != NULL, FALSE);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	ret = FALSE;
#line 918 "rygel-relational-expression.c"
	{
		GeeArrayList* _create_class_list = NULL;
		RygelWritableContainer* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		GeeArrayList* _tmp3_ = NULL;
		gint _create_class_size = 0;
		GeeArrayList* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _create_class_index = 0;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		_tmp0_ = container;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		_tmp1_ = rygel_writable_container_get_create_classes (_tmp0_);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		_tmp2_ = _tmp1_;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		_create_class_list = _tmp3_;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		_tmp4_ = _create_class_list;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		_tmp6_ = _tmp5_;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		_create_class_size = _tmp6_;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		_create_class_index = -1;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		while (TRUE) {
#line 952 "rygel-relational-expression.c"
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gchar* create_class = NULL;
			GeeArrayList* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gpointer _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp7_ = _create_class_index;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_create_class_index = _tmp7_ + 1;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp8_ = _create_class_index;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp9_ = _create_class_size;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			if (!(_tmp8_ < _tmp9_)) {
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				break;
#line 974 "rygel-relational-expression.c"
			}
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp10_ = _create_class_list;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp11_ = _create_class_index;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			create_class = (gchar*) _tmp12_;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp13_ = create_class;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp14_ = rygel_relational_expression_compare_string (self, _tmp13_);
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			if (_tmp14_) {
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				ret = TRUE;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_g_free0 (create_class);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				break;
#line 996 "rygel-relational-expression.c"
			}
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_g_free0 (create_class);
#line 1000 "rygel-relational-expression.c"
		}
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		_g_object_unref0 (_create_class_list);
#line 1004 "rygel-relational-expression.c"
	}
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	result = ret;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	return result;
#line 1010 "rygel-relational-expression.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1237 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1237 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1238 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1238 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1238 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1238 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 1030 "rygel-relational-expression.c"
}


gboolean rygel_relational_expression_compare_string (RygelRelationalExpression* self, const gchar* str) {
	gboolean result = FALSE;
	gchar* up_operand2 = NULL;
	gconstpointer _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* up_str = NULL;
	const gchar* _tmp2_ = NULL;
	gconstpointer _tmp5_ = NULL;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	_tmp0_ = ((RygelSearchExpression*) self)->operand2;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	_tmp1_ = g_utf8_strup ((const gchar*) _tmp0_, (gssize) (-1));
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	up_operand2 = _tmp1_;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	_tmp2_ = str;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	if (_tmp2_ != NULL) {
#line 1054 "rygel-relational-expression.c"
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		_tmp3_ = str;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		_tmp4_ = g_utf8_strup (_tmp3_, (gssize) (-1));
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		_g_free0 (up_str);
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		up_str = _tmp4_;
#line 1065 "rygel-relational-expression.c"
	} else {
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		_g_free0 (up_str);
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		up_str = NULL;
#line 1071 "rygel-relational-expression.c"
	}
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	_tmp5_ = ((RygelSearchExpression*) self)->op;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	switch ((GUPnPSearchCriteriaOp) ((gintptr) _tmp5_)) {
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_EXISTS:
#line 1079 "rygel-relational-expression.c"
		{
			gconstpointer _tmp6_ = NULL;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp6_ = ((RygelSearchExpression*) self)->operand2;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			if (g_strcmp0 ((const gchar*) _tmp6_, "true") == 0) {
#line 1086 "rygel-relational-expression.c"
				const gchar* _tmp7_ = NULL;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp7_ = up_str;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				result = _tmp7_ != NULL;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_g_free0 (up_str);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_g_free0 (up_operand2);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				return result;
#line 1098 "rygel-relational-expression.c"
			} else {
				const gchar* _tmp8_ = NULL;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_tmp8_ = up_str;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				result = _tmp8_ == NULL;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_g_free0 (up_str);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				_g_free0 (up_operand2);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
				return result;
#line 1111 "rygel-relational-expression.c"
			}
		}
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
#line 1116 "rygel-relational-expression.c"
		{
			const gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp9_ = up_operand2;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp10_ = up_str;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			result = g_strcmp0 (_tmp9_, _tmp10_) == 0;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_g_free0 (up_str);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_g_free0 (up_operand2);
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			return result;
#line 1132 "rygel-relational-expression.c"
		}
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
#line 1136 "rygel-relational-expression.c"
		{
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp11_ = up_operand2;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp12_ = up_str;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			result = g_strcmp0 (_tmp11_, _tmp12_) != 0;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_g_free0 (up_str);
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_g_free0 (up_operand2);
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			return result;
#line 1152 "rygel-relational-expression.c"
		}
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
#line 1156 "rygel-relational-expression.c"
		{
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			gboolean _tmp15_ = FALSE;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp13_ = up_str;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp14_ = up_operand2;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp15_ = string_contains (_tmp13_, _tmp14_);
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			result = _tmp15_;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_g_free0 (up_str);
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_g_free0 (up_operand2);
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			return result;
#line 1175 "rygel-relational-expression.c"
		}
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM:
#line 1179 "rygel-relational-expression.c"
		{
			const gchar* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp16_ = up_str;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp17_ = up_operand2;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp18_ = g_str_has_prefix (_tmp16_, _tmp17_);
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			result = _tmp18_;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_g_free0 (up_str);
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_g_free0 (up_operand2);
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			return result;
#line 1198 "rygel-relational-expression.c"
		}
		default:
		{
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			result = FALSE;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_g_free0 (up_str);
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_g_free0 (up_operand2);
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			return result;
#line 1210 "rygel-relational-expression.c"
		}
	}
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	_g_free0 (up_str);
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	_g_free0 (up_operand2);
#line 1217 "rygel-relational-expression.c"
}


gboolean rygel_relational_expression_compare_int (RygelRelationalExpression* self, gint integer) {
	gboolean result = FALSE;
	gint operand2 = 0;
	gconstpointer _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gconstpointer _tmp2_ = NULL;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	_tmp0_ = ((RygelSearchExpression*) self)->operand2;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	_tmp1_ = atoi ((const gchar*) _tmp0_);
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	operand2 = _tmp1_;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	_tmp2_ = ((RygelSearchExpression*) self)->op;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	switch ((GUPnPSearchCriteriaOp) ((gintptr) _tmp2_)) {
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
#line 1241 "rygel-relational-expression.c"
		{
			gint _tmp3_ = 0;
			gint _tmp4_ = 0;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp3_ = integer;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp4_ = operand2;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			result = _tmp3_ == _tmp4_;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			return result;
#line 1253 "rygel-relational-expression.c"
		}
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
#line 1257 "rygel-relational-expression.c"
		{
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp5_ = integer;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp6_ = operand2;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			result = _tmp5_ != _tmp6_;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			return result;
#line 1269 "rygel-relational-expression.c"
		}
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_LESS:
#line 1273 "rygel-relational-expression.c"
		{
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp7_ = integer;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp8_ = operand2;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			result = _tmp7_ < _tmp8_;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			return result;
#line 1285 "rygel-relational-expression.c"
		}
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_LEQ:
#line 1289 "rygel-relational-expression.c"
		{
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp9_ = integer;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp10_ = operand2;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			result = _tmp9_ <= _tmp10_;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			return result;
#line 1301 "rygel-relational-expression.c"
		}
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_GREATER:
#line 1305 "rygel-relational-expression.c"
		{
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp11_ = integer;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp12_ = operand2;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			result = _tmp11_ > _tmp12_;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			return result;
#line 1317 "rygel-relational-expression.c"
		}
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_GEQ:
#line 1321 "rygel-relational-expression.c"
		{
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp13_ = integer;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp14_ = operand2;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			result = _tmp13_ >= _tmp14_;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			return result;
#line 1333 "rygel-relational-expression.c"
		}
		default:
		{
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			result = FALSE;
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			return result;
#line 1341 "rygel-relational-expression.c"
		}
	}
}


static guint64 uint64_parse (const gchar* str) {
	guint64 result = 0ULL;
	const gchar* _tmp0_ = NULL;
	guint64 _tmp1_ = 0ULL;
#line 655 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0ULL);
#line 656 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 656 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = g_ascii_strtoull (_tmp0_, NULL, (guint) 0);
#line 656 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 656 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 1361 "rygel-relational-expression.c"
}


gboolean rygel_relational_expression_compare_uint (RygelRelationalExpression* self, guint integer) {
	gboolean result = FALSE;
	guint64 operand2 = 0ULL;
	gconstpointer _tmp0_ = NULL;
	guint64 _tmp1_ = 0ULL;
	gconstpointer _tmp2_ = NULL;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	_tmp0_ = ((RygelSearchExpression*) self)->operand2;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	_tmp1_ = uint64_parse ((const gchar*) _tmp0_);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	operand2 = _tmp1_;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	_tmp2_ = ((RygelSearchExpression*) self)->op;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	switch ((GUPnPSearchCriteriaOp) ((gintptr) _tmp2_)) {
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
#line 1385 "rygel-relational-expression.c"
		{
			guint _tmp3_ = 0U;
			guint64 _tmp4_ = 0ULL;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp3_ = integer;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp4_ = operand2;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			result = ((guint64) _tmp3_) == _tmp4_;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			return result;
#line 1397 "rygel-relational-expression.c"
		}
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
#line 1401 "rygel-relational-expression.c"
		{
			guint _tmp5_ = 0U;
			guint64 _tmp6_ = 0ULL;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp5_ = integer;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp6_ = operand2;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			result = ((guint64) _tmp5_) != _tmp6_;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			return result;
#line 1413 "rygel-relational-expression.c"
		}
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_LESS:
#line 1417 "rygel-relational-expression.c"
		{
			guint _tmp7_ = 0U;
			guint64 _tmp8_ = 0ULL;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp7_ = integer;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp8_ = operand2;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			result = ((guint64) _tmp7_) < _tmp8_;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			return result;
#line 1429 "rygel-relational-expression.c"
		}
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_LEQ:
#line 1433 "rygel-relational-expression.c"
		{
			guint _tmp9_ = 0U;
			guint64 _tmp10_ = 0ULL;
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp9_ = integer;
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp10_ = operand2;
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			result = ((guint64) _tmp9_) <= _tmp10_;
#line 191 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			return result;
#line 1445 "rygel-relational-expression.c"
		}
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_GREATER:
#line 1449 "rygel-relational-expression.c"
		{
			guint _tmp11_ = 0U;
			guint64 _tmp12_ = 0ULL;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp11_ = integer;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp12_ = operand2;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			result = ((guint64) _tmp11_) > _tmp12_;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			return result;
#line 1461 "rygel-relational-expression.c"
		}
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
		case GUPNP_SEARCH_CRITERIA_OP_GEQ:
#line 1465 "rygel-relational-expression.c"
		{
			guint _tmp13_ = 0U;
			guint64 _tmp14_ = 0ULL;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp13_ = integer;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			_tmp14_ = operand2;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			result = ((guint64) _tmp13_) >= _tmp14_;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			return result;
#line 1477 "rygel-relational-expression.c"
		}
		default:
		{
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			result = FALSE;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
			return result;
#line 1485 "rygel-relational-expression.c"
		}
	}
}


RygelRelationalExpression* rygel_relational_expression_construct (GType object_type) {
	RygelRelationalExpression* self = NULL;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	self = (RygelRelationalExpression*) rygel_search_expression_construct (object_type, gupnp_search_criteria_op_get_type (), NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	return self;
#line 1497 "rygel-relational-expression.c"
}


RygelRelationalExpression* rygel_relational_expression_new (void) {
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	return rygel_relational_expression_construct (RYGEL_TYPE_RELATIONAL_EXPRESSION);
#line 1504 "rygel-relational-expression.c"
}


static void rygel_relational_expression_class_init (RygelRelationalExpressionClass * klass) {
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	rygel_relational_expression_parent_class = g_type_class_peek_parent (klass);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	RYGEL_SEARCH_EXPRESSION_CLASS (klass)->satisfied_by = rygel_relational_expression_real_satisfied_by;
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-relational-expression.vala"
	RYGEL_SEARCH_EXPRESSION_CLASS (klass)->to_string = rygel_relational_expression_real_to_string;
#line 1515 "rygel-relational-expression.c"
}


static void rygel_relational_expression_instance_init (RygelRelationalExpression * self) {
}


/**
 * This is a parsed UPnP search expression consisting of two strings joined by a
 * relational operator such as such <, <=, ==, !=, >, >=, derivedFrom or exists.
 */
GType rygel_relational_expression_get_type (void) {
	static volatile gsize rygel_relational_expression_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_relational_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelRelationalExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_relational_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRelationalExpression), 0, (GInstanceInitFunc) rygel_relational_expression_instance_init, NULL };
		GType rygel_relational_expression_type_id;
		rygel_relational_expression_type_id = g_type_register_static (RYGEL_TYPE_SEARCH_EXPRESSION, "RygelRelationalExpression", &g_define_type_info, 0);
		g_once_init_leave (&rygel_relational_expression_type_id__volatile, rygel_relational_expression_type_id);
	}
	return rygel_relational_expression_type_id__volatile;
}



