/* rygel-searchable-container.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-searchable-container.vala, do not modify */

/*
 * Copyright (C) 2008,2010 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 MediaNet Inh.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelSearchableContainerSimpleSearchData RygelSearchableContainerSimpleSearchData;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;
typedef struct _RygelSearchableContainerFindObjectData RygelSearchableContainerFindObjectData;
typedef struct _RygelSearchableContainerSearchInChildrenData RygelSearchableContainerSearchInChildrenData;

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelSearchableContainerSimpleSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* _result_;
	RygelMediaObjects* _tmp0_;
	gint count;
	gint _tmp1_;
	gint _tmp2_;
	RygelSearchExpression* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	RygelMediaObjects* children;
	gint _tmp8_;
	const gchar* _tmp9_;
	GCancellable* _tmp10_;
	RygelMediaObjects* _tmp11_;
	guint limit;
	guint _tmp12_;
	guint _tmp13_;
	guint _tmp14_;
	RygelMediaObjects* _child_list;
	RygelMediaObjects* _tmp15_;
	RygelMediaObjects* _tmp16_;
	gint _child_size;
	RygelMediaObjects* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _child_index;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	RygelMediaObject* child;
	RygelMediaObjects* _tmp23_;
	gint _tmp24_;
	gpointer _tmp25_;
	gboolean _tmp26_;
	RygelSearchExpression* _tmp27_;
	RygelSearchExpression* _tmp28_;
	RygelMediaObject* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	RygelMediaObjects* _tmp32_;
	RygelMediaObject* _tmp33_;
	gboolean _tmp34_;
	guint _tmp35_;
	RygelMediaObjects* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	guint _tmp39_;
	gboolean _tmp40_;
	gboolean _tmp41_;
	guint _tmp42_;
	RygelMediaObjects* _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	guint _tmp46_;
	gboolean _tmp47_;
	guint _tmp48_;
	guint _tmp49_;
	guint _tmp50_;
	RygelMediaObjects* _tmp51_;
	gint _tmp52_;
	gint _tmp53_;
	guint child_limit;
	guint _tmp54_;
	RygelMediaObjects* child_results;
	RygelSearchExpression* _tmp55_;
	RygelMediaObjects* _tmp56_;
	guint _tmp57_;
	const gchar* _tmp58_;
	GCancellable* _tmp59_;
	RygelMediaObjects* _tmp60_;
	RygelMediaObjects* _tmp61_;
	RygelMediaObjects* _tmp62_;
	guint _tmp63_;
	RygelMediaObjects* _tmp64_;
	gint _tmp65_;
	gint _tmp66_;
	guint _tmp67_;
	RygelMediaObjects* _tmp68_;
	gint _tmp69_;
	gint _tmp70_;
	RygelMediaObjects* _tmp71_;
	gboolean _tmp72_;
	RygelMediaObjects* _tmp73_;
	gint _tmp74_;
	gint _tmp75_;
	gboolean _tmp76_;
	guint _tmp77_;
	guint _tmp78_;
	gboolean _tmp79_;
	gboolean _tmp80_;
	guint stop;
	gboolean _tmp81_;
	guint _tmp82_;
	guint _tmp83_;
	guint _tmp84_;
	RygelMediaObjects* _tmp85_;
	gint _tmp86_;
	gint _tmp87_;
	gboolean _tmp88_;
	guint _tmp89_;
	guint _tmp90_;
	RygelMediaObjects* _tmp91_;
	gint _tmp92_;
	gint _tmp93_;
	RygelMediaObjects* _tmp94_;
	guint _tmp95_;
	guint _tmp96_;
	GeeList* _tmp97_;
	RygelMediaObjects* _tmp98_;
	GError * _inner_error_;
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelSearchableContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelRelationalExpression* expression;
	RygelRelationalExpression* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	guint total_matches;
	RygelMediaObjects* results;
	GCancellable* _tmp4_;
	guint _tmp5_;
	RygelMediaObjects* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gpointer _tmp9_;
	GError * _inner_error_;
};

struct _RygelSearchableContainerSearchInChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	RygelSearchExpression* expression;
	RygelMediaObjects* children;
	guint limit;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* _result_;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* _child_list;
	RygelMediaObjects* _tmp1_;
	RygelMediaObjects* _tmp2_;
	gint _child_size;
	RygelMediaObjects* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _child_index;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	RygelMediaObject* child;
	RygelMediaObjects* _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_;
	RygelMediaObject* _tmp12_;
	RygelSearchableContainer* container;
	RygelMediaObject* _tmp13_;
	RygelSearchableContainer* _tmp14_;
	guint tmp;
	RygelMediaObjects* child_result;
	RygelSearchableContainer* _tmp15_;
	RygelSearchExpression* _tmp16_;
	guint _tmp17_;
	const gchar* _tmp18_;
	GCancellable* _tmp19_;
	guint _tmp20_;
	RygelMediaObjects* _tmp21_;
	RygelMediaObjects* _tmp22_;
	RygelMediaObjects* _tmp23_;
	gboolean _tmp24_;
	guint _tmp25_;
	RygelMediaObjects* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	guint _tmp29_;
	gboolean _tmp30_;
	GError * _inner_error_;
};



GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_searchable_container_simple_search_data_free (gpointer _data);
void rygel_searchable_container_simple_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static gboolean rygel_searchable_container_simple_search_co (RygelSearchableContainerSimpleSearchData* _data_);
RygelMediaObjects* rygel_media_objects_new (void);
RygelMediaObjects* rygel_media_objects_construct (GType object_type);
gint rygel_media_container_get_child_count (RygelMediaContainer* self);
void rygel_media_container_check_search_expression (RygelMediaContainer* self, RygelSearchExpression* expression);
gboolean rygel_media_container_get_create_mode_enabled (RygelMediaContainer* self);
gint rygel_media_container_get_all_child_count (RygelMediaContainer* self);
void rygel_media_container_get_children (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_searchable_container_simple_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean rygel_search_expression_satisfied_by (RygelSearchExpression* self, RygelMediaObject* media_object);
static void rygel_searchable_container_search_in_children (RygelSearchableContainer* self, RygelSearchExpression* expression, RygelMediaObjects* children, guint limit, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObjects* rygel_searchable_container_search_in_children_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_searchable_container_find_object_data_free (gpointer _data);
void rygel_searchable_container_find_object (RygelSearchableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_searchable_container_find_object_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_searchable_container_find_object_co (RygelSearchableContainerFindObjectData* _data_);
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
static void rygel_searchable_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_searchable_container_search_in_children_data_free (gpointer _data);
static gboolean rygel_searchable_container_search_in_children_co (RygelSearchableContainerSearchInChildrenData* _data_);
static void rygel_searchable_container_search_in_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self, GUPnPDIDLLiteContainer* didl_container);
GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self);
void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self, GeeArrayList* value);


void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->search (self, expression, offset, max_count, sort_criteria, cancellable, _callback_, _user_data_);
#line 384 "rygel-searchable-container.c"
}


RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->search_finish (self, _res_, total_matches, error);
#line 391 "rygel-searchable-container.c"
}


static void rygel_searchable_container_simple_search_data_free (gpointer _data) {
	RygelSearchableContainerSimpleSearchData* _data_;
	_data_ = _data;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->result);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->self);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_slice_free (RygelSearchableContainerSimpleSearchData, _data_);
#line 410 "rygel-searchable-container.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return self ? g_object_ref (self) : NULL;
#line 417 "rygel-searchable-container.c"
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return self ? rygel_search_expression_ref (self) : NULL;
#line 424 "rygel-searchable-container.c"
}


void rygel_searchable_container_simple_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerSimpleSearchData* _data_;
	RygelSearchableContainer* _tmp0_ = NULL;
	RygelSearchExpression* _tmp1_ = NULL;
	RygelSearchExpression* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GCancellable* _tmp7_ = NULL;
	GCancellable* _tmp8_ = NULL;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_ = g_slice_new0 (RygelSearchableContainerSimpleSearchData);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_searchable_container_simple_search);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_simple_search_data_free);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->self = _tmp0_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp1_ = expression;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->expression = _tmp2_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp3_ = offset;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->offset = _tmp3_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp4_ = max_count;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->max_count = _tmp4_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp5_ = sort_criteria;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->sort_criteria = _tmp6_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp7_ = cancellable;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->cancellable = _tmp8_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	rygel_searchable_container_simple_search_co (_data_);
#line 483 "rygel-searchable-container.c"
}


RygelMediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelSearchableContainerSimpleSearchData* _data_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		return NULL;
#line 494 "rygel-searchable-container.c"
	}
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (total_matches) {
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		*total_matches = _data_->total_matches;
#line 502 "rygel-searchable-container.c"
	}
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	result = _data_->result;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->result = NULL;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return result;
#line 510 "rygel-searchable-container.c"
}


/**
     * Utility method that retrieves all children and recursively searches for
     * all media objects that satisfy the given search expression in this
     * container.
     *
     * @param expression the search expression or `null` for wildcard
     * @param offset zero-based index of the first object to return
     * @param max_count maximum number of objects to return
     * @param total_matches sets it to the actual number of objects that satisfy
     *                      the given search expression. If it is not possible
     *                      to compute this value (in a timely mannger), it is
     *                      set to '0'.
     * @param cancellable optional cancellable for this operation
     *
     * @return A list of media objects.
     */
static void rygel_searchable_container_simple_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerSimpleSearchData* _data_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_ = _user_data_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_source_object_ = source_object;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_res_ = _res_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	rygel_searchable_container_simple_search_co (_data_);
#line 540 "rygel-searchable-container.c"
}


static gboolean rygel_searchable_container_simple_search_co (RygelSearchableContainerSimpleSearchData* _data_) {
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	switch (_data_->_state_) {
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		case 0:
#line 549 "rygel-searchable-container.c"
		goto _state_0;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		case 1:
#line 553 "rygel-searchable-container.c"
		goto _state_1;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		case 2:
#line 557 "rygel-searchable-container.c"
		goto _state_2;
		default:
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_assert_not_reached ();
#line 562 "rygel-searchable-container.c"
	}
	_state_0:
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp0_ = NULL;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp0_ = rygel_media_objects_new ();
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_result_ = _data_->_tmp0_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp1_ = 0;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp1_ = rygel_media_container_get_child_count ((RygelMediaContainer*) _data_->self);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp2_ = 0;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->count = _data_->_tmp2_;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp3_ = NULL;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp3_ = _data_->expression;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	rygel_media_container_check_search_expression ((RygelMediaContainer*) _data_->self, _data_->_tmp3_);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp4_ = FALSE;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp4_ = rygel_media_container_get_create_mode_enabled ((RygelMediaContainer*) _data_->self);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp5_ = FALSE;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp5_ = _data_->_tmp4_;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_tmp5_) {
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp6_ = 0;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp6_ = rygel_media_container_get_all_child_count ((RygelMediaContainer*) _data_->self);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp7_ = 0;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp7_ = _data_->_tmp6_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->count = _data_->_tmp7_;
#line 607 "rygel-searchable-container.c"
	}
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp8_ = 0;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp8_ = _data_->count;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp9_ = NULL;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp9_ = _data_->sort_criteria;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp10_ = NULL;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp10_ = _data_->cancellable;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_state_ = 1;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	rygel_media_container_get_children ((RygelMediaContainer*) _data_->self, (guint) 0, (guint) _data_->_tmp8_, _data_->_tmp9_, _data_->_tmp10_, rygel_searchable_container_simple_search_ready, _data_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return FALSE;
#line 627 "rygel-searchable-container.c"
	_state_1:
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp11_ = NULL;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp11_ = rygel_media_container_get_children_finish ((RygelMediaContainer*) _data_->self, _data_->_res_, &_data_->_inner_error_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->children = _data_->_tmp11_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_error_free (_data_->_inner_error_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_result_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 647 "rygel-searchable-container.c"
		} else {
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 651 "rygel-searchable-container.c"
		}
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		return FALSE;
#line 657 "rygel-searchable-container.c"
	}
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp12_ = 0U;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp12_ = _data_->max_count;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_tmp12_ > ((guint) 0)) {
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp13_ = 0U;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp13_ = _data_->offset;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp14_ = 0U;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp14_ = _data_->max_count;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->limit = _data_->_tmp13_ + _data_->_tmp14_;
#line 675 "rygel-searchable-container.c"
	} else {
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->limit = (guint) 0;
#line 679 "rygel-searchable-container.c"
	}
	{
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp15_ = NULL;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp15_ = _data_->children;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp16_ = NULL;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp16_ = _g_object_ref0 (_data_->_tmp15_);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_child_list = _data_->_tmp16_;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp17_ = NULL;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp17_ = _data_->_child_list;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp18_ = 0;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp18_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp17_);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp19_ = 0;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp19_ = _data_->_tmp18_;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_child_size = _data_->_tmp19_;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_child_index = -1;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		while (TRUE) {
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp20_ = 0;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp20_ = _data_->_child_index;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_child_index = _data_->_tmp20_ + 1;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp21_ = 0;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp21_ = _data_->_child_index;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp22_ = 0;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp22_ = _data_->_child_size;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			if (!(_data_->_tmp21_ < _data_->_tmp22_)) {
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				break;
#line 728 "rygel-searchable-container.c"
			}
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp23_ = NULL;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp23_ = _data_->_child_list;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp24_ = 0;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp24_ = _data_->_child_index;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp25_ = NULL;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp23_, _data_->_tmp24_);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->child = (RygelMediaObject*) _data_->_tmp25_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp27_ = NULL;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp27_ = _data_->expression;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			if (_data_->_tmp27_ == NULL) {
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp26_ = TRUE;
#line 752 "rygel-searchable-container.c"
			} else {
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp28_ = NULL;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp28_ = _data_->expression;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp29_ = NULL;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp29_ = _data_->child;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp30_ = FALSE;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp30_ = rygel_search_expression_satisfied_by (_data_->_tmp28_, _data_->_tmp29_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp26_ = _data_->_tmp30_;
#line 768 "rygel-searchable-container.c"
			}
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp31_ = FALSE;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp31_ = _data_->_tmp26_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			if (_data_->_tmp31_) {
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp32_ = NULL;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp32_ = _data_->_result_;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp33_ = NULL;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp33_ = _data_->child;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp32_, _data_->_tmp33_);
#line 786 "rygel-searchable-container.c"
			}
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp35_ = 0U;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp35_ = _data_->limit;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			if (_data_->_tmp35_ > ((guint) 0)) {
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp36_ = NULL;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp36_ = _data_->_result_;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp37_ = 0;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp37_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp36_);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp38_ = 0;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp38_ = _data_->_tmp37_;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp39_ = 0U;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp39_ = _data_->limit;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp34_ = ((guint) _data_->_tmp38_) >= _data_->_tmp39_;
#line 812 "rygel-searchable-container.c"
			} else {
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp34_ = FALSE;
#line 816 "rygel-searchable-container.c"
			}
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp40_ = FALSE;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp40_ = _data_->_tmp34_;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			if (_data_->_tmp40_) {
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->child);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				break;
#line 828 "rygel-searchable-container.c"
			}
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->child);
#line 832 "rygel-searchable-container.c"
		}
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_child_list);
#line 836 "rygel-searchable-container.c"
	}
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp42_ = 0U;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp42_ = _data_->limit;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_tmp42_ == ((guint) 0)) {
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp41_ = TRUE;
#line 846 "rygel-searchable-container.c"
	} else {
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp43_ = NULL;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp43_ = _data_->_result_;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp44_ = 0;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp44_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp43_);
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp45_ = 0;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp45_ = _data_->_tmp44_;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp46_ = 0U;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp46_ = _data_->limit;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp41_ = ((guint) _data_->_tmp45_) < _data_->_tmp46_;
#line 866 "rygel-searchable-container.c"
	}
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp47_ = FALSE;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp47_ = _data_->_tmp41_;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_tmp47_) {
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp49_ = 0U;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp49_ = _data_->limit;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		if (_data_->_tmp49_ == ((guint) 0)) {
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp48_ = (guint) 0;
#line 882 "rygel-searchable-container.c"
		} else {
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp50_ = 0U;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp50_ = _data_->limit;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp51_ = NULL;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp51_ = _data_->_result_;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp52_ = 0;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp52_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp51_);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp53_ = 0;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp53_ = _data_->_tmp52_;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp48_ = _data_->_tmp50_ - _data_->_tmp53_;
#line 902 "rygel-searchable-container.c"
		}
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp54_ = 0U;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp54_ = _data_->_tmp48_;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->child_limit = _data_->_tmp54_;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp55_ = NULL;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp55_ = _data_->expression;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp56_ = NULL;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp56_ = _data_->children;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp57_ = 0U;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp57_ = _data_->child_limit;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp58_ = NULL;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp58_ = _data_->sort_criteria;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp59_ = NULL;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp59_ = _data_->cancellable;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_state_ = 2;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		rygel_searchable_container_search_in_children (_data_->self, _data_->_tmp55_, _data_->_tmp56_, _data_->_tmp57_, _data_->_tmp58_, _data_->_tmp59_, rygel_searchable_container_simple_search_ready, _data_);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		return FALSE;
#line 936 "rygel-searchable-container.c"
		_state_2:
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp60_ = NULL;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp60_ = rygel_searchable_container_search_in_children_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->child_results = _data_->_tmp60_;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_error_free (_data_->_inner_error_);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->children);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->_result_);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			if (_data_->_state_ == 0) {
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 958 "rygel-searchable-container.c"
			} else {
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 962 "rygel-searchable-container.c"
			}
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_object_unref (_data_->_async_result);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			return FALSE;
#line 968 "rygel-searchable-container.c"
		}
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp61_ = NULL;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp61_ = _data_->_result_;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp62_ = NULL;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp62_ = _data_->child_results;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		gee_array_list_add_all ((GeeArrayList*) _data_->_tmp61_, (GeeCollection*) _data_->_tmp62_);
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->child_results);
#line 982 "rygel-searchable-container.c"
	}
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp63_ = 0U;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp63_ = _data_->max_count;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_tmp63_ > ((guint) 0)) {
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->total_matches = (guint) 0;
#line 992 "rygel-searchable-container.c"
	} else {
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp64_ = NULL;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp64_ = _data_->_result_;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp65_ = 0;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp65_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp64_);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp66_ = 0;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp66_ = _data_->_tmp65_;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->total_matches = (guint) _data_->_tmp66_;
#line 1008 "rygel-searchable-container.c"
	}
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp67_ = 0U;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp67_ = _data_->offset;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp68_ = NULL;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp68_ = _data_->_result_;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp69_ = 0;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp69_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp68_);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp70_ = 0;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp70_ = _data_->_tmp69_;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_tmp67_ >= ((guint) _data_->_tmp70_)) {
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp71_ = NULL;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp71_ = rygel_media_objects_new ();
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->result = _data_->_tmp71_;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->children);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_result_);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1042 "rygel-searchable-container.c"
		} else {
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1046 "rygel-searchable-container.c"
		}
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		return FALSE;
#line 1052 "rygel-searchable-container.c"
	}
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp73_ = NULL;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp73_ = _data_->_result_;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp74_ = 0;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp74_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp73_);
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp75_ = 0;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp75_ = _data_->_tmp74_;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_tmp75_ > 0) {
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp77_ = 0U;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp77_ = _data_->max_count;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		if (_data_->_tmp77_ > ((guint) 0)) {
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp76_ = TRUE;
#line 1076 "rygel-searchable-container.c"
		} else {
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp78_ = 0U;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp78_ = _data_->offset;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp76_ = _data_->_tmp78_ > ((guint) 0);
#line 1084 "rygel-searchable-container.c"
		}
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp79_ = FALSE;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp79_ = _data_->_tmp76_;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp72_ = _data_->_tmp79_;
#line 1092 "rygel-searchable-container.c"
	} else {
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp72_ = FALSE;
#line 1096 "rygel-searchable-container.c"
	}
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp80_ = FALSE;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp80_ = _data_->_tmp72_;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_tmp80_) {
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp82_ = 0U;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp82_ = _data_->max_count;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		if (_data_->_tmp82_ != ((guint) 0)) {
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp83_ = 0U;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp83_ = _data_->offset;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp84_ = 0U;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp84_ = _data_->max_count;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp85_ = NULL;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp85_ = _data_->_result_;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp86_ = 0;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp86_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp85_);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp87_ = 0;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp87_ = _data_->_tmp86_;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp81_ = (_data_->_tmp83_ + _data_->_tmp84_) <= ((guint) _data_->_tmp87_);
#line 1132 "rygel-searchable-container.c"
		} else {
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp81_ = FALSE;
#line 1136 "rygel-searchable-container.c"
		}
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp88_ = FALSE;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp88_ = _data_->_tmp81_;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		if (_data_->_tmp88_) {
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp89_ = 0U;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp89_ = _data_->offset;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp90_ = 0U;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp90_ = _data_->max_count;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->stop = _data_->_tmp89_ + _data_->_tmp90_;
#line 1154 "rygel-searchable-container.c"
		} else {
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp91_ = NULL;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp91_ = _data_->_result_;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp92_ = 0;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp92_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp91_);
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp93_ = 0;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp93_ = _data_->_tmp92_;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->stop = (guint) _data_->_tmp93_;
#line 1170 "rygel-searchable-container.c"
		}
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp94_ = NULL;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp94_ = _data_->_result_;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp95_ = 0U;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp95_ = _data_->offset;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp96_ = 0U;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp96_ = _data_->stop;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp97_ = NULL;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp97_ = gee_abstract_list_slice ((GeeAbstractList*) _data_->_tmp94_, (gint) _data_->_tmp95_, (gint) _data_->_tmp96_);
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp98_ = NULL;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp98_ = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp97_, RYGEL_TYPE_MEDIA_OBJECTS) ? ((RygelMediaObjects*) _data_->_tmp97_) : NULL;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		if (_data_->_tmp98_ == NULL) {
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->_tmp97_);
#line 1196 "rygel-searchable-container.c"
		}
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->result = _data_->_tmp98_;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->children);
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_result_);
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1208 "rygel-searchable-container.c"
		} else {
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1212 "rygel-searchable-container.c"
		}
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		return FALSE;
#line 1218 "rygel-searchable-container.c"
	}
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->result = _data_->_result_;
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->children);
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1228 "rygel-searchable-container.c"
	} else {
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1232 "rygel-searchable-container.c"
	}
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return FALSE;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->children);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->_result_);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1246 "rygel-searchable-container.c"
	} else {
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1250 "rygel-searchable-container.c"
	}
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return FALSE;
#line 1256 "rygel-searchable-container.c"
}


static void rygel_searchable_container_find_object_data_free (gpointer _data) {
	RygelSearchableContainerFindObjectData* _data_;
	_data_ = _data;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_free0 (_data_->id);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->result);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->self);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_slice_free (RygelSearchableContainerFindObjectData, _data_);
#line 1273 "rygel-searchable-container.c"
}


void rygel_searchable_container_find_object (RygelSearchableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerFindObjectData* _data_;
	RygelSearchableContainer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_ = g_slice_new0 (RygelSearchableContainerFindObjectData);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_searchable_container_find_object);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_find_object_data_free);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->self = _tmp0_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp1_ = id;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_free0 (_data_->id);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->id = _tmp2_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp3_ = cancellable;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->cancellable = _tmp4_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	rygel_searchable_container_find_object_co (_data_);
#line 1312 "rygel-searchable-container.c"
}


RygelMediaObject* rygel_searchable_container_find_object_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelSearchableContainerFindObjectData* _data_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		return NULL;
#line 1323 "rygel-searchable-container.c"
	}
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	result = _data_->result;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->result = NULL;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return result;
#line 1333 "rygel-searchable-container.c"
}


/**
     * Recursively searches for media object with the given id in this
     * container.
     *
     * @param id ID of the media object to search for
     * @param cancellable optional cancellable for this operation
     * @param callback function to call when result is ready
     *
     * @return the found media object.
     */
static void rygel_searchable_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerFindObjectData* _data_;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_ = _user_data_;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_source_object_ = source_object;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_res_ = _res_;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	rygel_searchable_container_find_object_co (_data_);
#line 1357 "rygel-searchable-container.c"
}


static gboolean rygel_searchable_container_find_object_co (RygelSearchableContainerFindObjectData* _data_) {
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	switch (_data_->_state_) {
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		case 0:
#line 1366 "rygel-searchable-container.c"
		goto _state_0;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		case 1:
#line 1370 "rygel-searchable-container.c"
		goto _state_1;
		default:
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_assert_not_reached ();
#line 1375 "rygel-searchable-container.c"
	}
	_state_0:
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp0_ = NULL;
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp0_ = rygel_relational_expression_new ();
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->expression = _data_->_tmp0_;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	((RygelSearchExpression*) _data_->expression)->op = (gpointer) ((gintptr) GUPNP_SEARCH_CRITERIA_OP_EQ);
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp1_ = NULL;
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp1_ = g_strdup ("@id");
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_free0 (((RygelSearchExpression*) _data_->expression)->operand1);
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	((RygelSearchExpression*) _data_->expression)->operand1 = _data_->_tmp1_;
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp2_ = NULL;
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp2_ = _data_->id;
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp3_ = NULL;
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_free0 (((RygelSearchExpression*) _data_->expression)->operand2);
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	((RygelSearchExpression*) _data_->expression)->operand2 = _data_->_tmp3_;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp4_ = NULL;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp4_ = _data_->cancellable;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp5_ = 0U;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_state_ = 1;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	rygel_searchable_container_search (_data_->self, (RygelSearchExpression*) _data_->expression, (guint) 0, (guint) 1, "", _data_->_tmp4_, rygel_searchable_container_find_object_ready, _data_);
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return FALSE;
#line 1418 "rygel-searchable-container.c"
	_state_1:
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp6_ = NULL;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp6_ = rygel_searchable_container_search_finish (_data_->self, _data_->_res_, &_data_->_tmp5_, &_data_->_inner_error_);
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->total_matches = _data_->_tmp5_;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->results = _data_->_tmp6_;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_error_free (_data_->_inner_error_);
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_rygel_search_expression_unref0 (_data_->expression);
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1440 "rygel-searchable-container.c"
		} else {
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1444 "rygel-searchable-container.c"
		}
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		return FALSE;
#line 1450 "rygel-searchable-container.c"
	}
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp7_ = 0;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->results);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp8_ = 0;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp8_ = _data_->_tmp7_;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_tmp8_ > 0) {
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp9_ = NULL;
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _data_->results, 0);
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->result = (RygelMediaObject*) _data_->_tmp9_;
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->results);
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_rygel_search_expression_unref0 (_data_->expression);
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1476 "rygel-searchable-container.c"
		} else {
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1480 "rygel-searchable-container.c"
		}
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		return FALSE;
#line 1486 "rygel-searchable-container.c"
	} else {
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->result = NULL;
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->results);
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_rygel_search_expression_unref0 (_data_->expression);
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1498 "rygel-searchable-container.c"
		} else {
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1502 "rygel-searchable-container.c"
		}
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 188 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		return FALSE;
#line 1508 "rygel-searchable-container.c"
	}
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->results);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1518 "rygel-searchable-container.c"
	} else {
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1522 "rygel-searchable-container.c"
	}
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return FALSE;
#line 1528 "rygel-searchable-container.c"
}


static void rygel_searchable_container_search_in_children_data_free (gpointer _data) {
	RygelSearchableContainerSearchInChildrenData* _data_;
	_data_ = _data;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->children);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->result);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->self);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_slice_free (RygelSearchableContainerSearchInChildrenData, _data_);
#line 1549 "rygel-searchable-container.c"
}


static void rygel_searchable_container_search_in_children (RygelSearchableContainer* self, RygelSearchExpression* expression, RygelMediaObjects* children, guint limit, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerSearchInChildrenData* _data_;
	RygelSearchableContainer* _tmp0_ = NULL;
	RygelSearchExpression* _tmp1_ = NULL;
	RygelSearchExpression* _tmp2_ = NULL;
	RygelMediaObjects* _tmp3_ = NULL;
	RygelMediaObjects* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GCancellable* _tmp8_ = NULL;
	GCancellable* _tmp9_ = NULL;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_ = g_slice_new0 (RygelSearchableContainerSearchInChildrenData);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_searchable_container_search_in_children);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_search_in_children_data_free);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->self = _tmp0_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp1_ = expression;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->expression = _tmp2_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp3_ = children;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->children);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->children = _tmp4_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp5_ = limit;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->limit = _tmp5_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp6_ = sort_criteria;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->sort_criteria = _tmp7_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp8_ = cancellable;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->cancellable = _tmp9_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	rygel_searchable_container_search_in_children_co (_data_);
#line 1613 "rygel-searchable-container.c"
}


static RygelMediaObjects* rygel_searchable_container_search_in_children_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelSearchableContainerSearchInChildrenData* _data_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		return NULL;
#line 1624 "rygel-searchable-container.c"
	}
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	result = _data_->result;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->result = NULL;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return result;
#line 1634 "rygel-searchable-container.c"
}


static void rygel_searchable_container_search_in_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerSearchInChildrenData* _data_;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_ = _user_data_;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_source_object_ = source_object;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_res_ = _res_;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	rygel_searchable_container_search_in_children_co (_data_);
#line 1648 "rygel-searchable-container.c"
}


static gboolean rygel_searchable_container_search_in_children_co (RygelSearchableContainerSearchInChildrenData* _data_) {
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	switch (_data_->_state_) {
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		case 0:
#line 1657 "rygel-searchable-container.c"
		goto _state_0;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		case 1:
#line 1661 "rygel-searchable-container.c"
		goto _state_1;
		default:
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_assert_not_reached ();
#line 1666 "rygel-searchable-container.c"
	}
	_state_0:
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp0_ = NULL;
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp0_ = rygel_media_objects_new ();
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_result_ = _data_->_tmp0_;
#line 1675 "rygel-searchable-container.c"
	{
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp1_ = NULL;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp1_ = _data_->children;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp2_ = NULL;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_child_list = _data_->_tmp2_;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp3_ = NULL;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp3_ = _data_->_child_list;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp4_ = 0;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp3_);
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp5_ = 0;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_child_size = _data_->_tmp5_;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_child_index = -1;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		while (TRUE) {
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp6_ = 0;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp6_ = _data_->_child_index;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_child_index = _data_->_tmp6_ + 1;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp7_ = 0;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp7_ = _data_->_child_index;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp8_ = 0;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp8_ = _data_->_child_size;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			if (!(_data_->_tmp7_ < _data_->_tmp8_)) {
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				break;
#line 1723 "rygel-searchable-container.c"
			}
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp9_ = NULL;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp9_ = _data_->_child_list;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp10_ = 0;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp10_ = _data_->_child_index;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp11_ = NULL;
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp9_, _data_->_tmp10_);
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->child = (RygelMediaObject*) _data_->_tmp11_;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp12_ = NULL;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp12_ = _data_->child;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp12_, RYGEL_TYPE_SEARCHABLE_CONTAINER)) {
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp13_ = NULL;
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp13_ = _data_->child;
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp14_ = NULL;
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp13_, RYGEL_TYPE_SEARCHABLE_CONTAINER) ? ((RygelSearchableContainer*) _data_->_tmp13_) : NULL);
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->container = _data_->_tmp14_;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp15_ = NULL;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp15_ = _data_->container;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp16_ = NULL;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp16_ = _data_->expression;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp17_ = 0U;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp17_ = _data_->limit;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp18_ = NULL;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp18_ = _data_->sort_criteria;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp19_ = NULL;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp19_ = _data_->cancellable;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp20_ = 0U;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_state_ = 1;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				rygel_searchable_container_search (_data_->_tmp15_, _data_->_tmp16_, (guint) 0, _data_->_tmp17_, _data_->_tmp18_, _data_->_tmp19_, rygel_searchable_container_search_in_children_ready, _data_);
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				return FALSE;
#line 1783 "rygel-searchable-container.c"
				_state_1:
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp21_ = NULL;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp21_ = rygel_searchable_container_search_finish (_data_->_tmp15_, _data_->_res_, &_data_->_tmp20_, &_data_->_inner_error_);
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->tmp = _data_->_tmp20_;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->child_result = _data_->_tmp21_;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				if (_data_->_inner_error_ != NULL) {
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
					g_error_free (_data_->_inner_error_);
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->container);
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->child);
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->_child_list);
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->_result_);
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
					if (_data_->_state_ == 0) {
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
						g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1811 "rygel-searchable-container.c"
					} else {
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
						g_simple_async_result_complete (_data_->_async_result);
#line 1815 "rygel-searchable-container.c"
					}
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
					g_object_unref (_data_->_async_result);
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
					return FALSE;
#line 1821 "rygel-searchable-container.c"
				}
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp22_ = NULL;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp22_ = _data_->_result_;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp23_ = NULL;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp23_ = _data_->child_result;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				gee_array_list_add_all ((GeeArrayList*) _data_->_tmp22_, (GeeCollection*) _data_->_tmp23_);
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->child_result);
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->container);
#line 1837 "rygel-searchable-container.c"
			}
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp25_ = 0U;
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp25_ = _data_->limit;
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			if (_data_->_tmp25_ > ((guint) 0)) {
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp26_ = NULL;
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp26_ = _data_->_result_;
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp27_ = 0;
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp27_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp26_);
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp28_ = 0;
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp28_ = _data_->_tmp27_;
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp29_ = 0U;
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp29_ = _data_->limit;
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp24_ = ((guint) _data_->_tmp28_) >= _data_->_tmp29_;
#line 1863 "rygel-searchable-container.c"
			} else {
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp24_ = FALSE;
#line 1867 "rygel-searchable-container.c"
			}
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp30_ = FALSE;
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp30_ = _data_->_tmp24_;
#line 216 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			if (_data_->_tmp30_) {
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->child);
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				break;
#line 1879 "rygel-searchable-container.c"
			}
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->child);
#line 1883 "rygel-searchable-container.c"
		}
#line 201 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_child_list);
#line 1887 "rygel-searchable-container.c"
	}
#line 221 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->result = _data_->_result_;
#line 221 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 221 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1895 "rygel-searchable-container.c"
	} else {
#line 221 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1899 "rygel-searchable-container.c"
	}
#line 221 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 221 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return FALSE;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->_result_);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1911 "rygel-searchable-container.c"
	} else {
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1915 "rygel-searchable-container.c"
	}
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return FALSE;
#line 1921 "rygel-searchable-container.c"
}


void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self, GUPnPDIDLLiteContainer* didl_container) {
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_return_if_fail (didl_container != NULL);
#line 1928 "rygel-searchable-container.c"
	{
		GeeArrayList* _search_class_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		gint _search_class_size = 0;
		GeeArrayList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _search_class_index = 0;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_tmp0_ = rygel_searchable_container_get_search_classes (self);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_tmp1_ = _tmp0_;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_search_class_list = _tmp2_;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_tmp3_ = _search_class_list;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_tmp5_ = _tmp4_;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_search_class_size = _tmp5_;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_search_class_index = -1;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		while (TRUE) {
#line 1959 "rygel-searchable-container.c"
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gchar* search_class = NULL;
			GeeArrayList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			GUPnPDIDLLiteContainer* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_tmp6_ = _search_class_index;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_search_class_index = _tmp6_ + 1;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_tmp7_ = _search_class_index;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_tmp8_ = _search_class_size;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				break;
#line 1981 "rygel-searchable-container.c"
			}
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_tmp9_ = _search_class_list;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_tmp10_ = _search_class_index;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			search_class = (gchar*) _tmp11_;
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_tmp12_ = didl_container;
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_tmp13_ = search_class;
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			gupnp_didl_lite_container_add_search_class (_tmp12_, _tmp13_);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_g_free0 (search_class);
#line 1999 "rygel-searchable-container.c"
		}
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_g_object_unref0 (_search_class_list);
#line 2003 "rygel-searchable-container.c"
	}
}


GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self) {
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->get_search_classes (self);
#line 2013 "rygel-searchable-container.c"
}


void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self, GeeArrayList* value) {
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_return_if_fail (self != NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->set_search_classes (self, value);
#line 2022 "rygel-searchable-container.c"
}


static void rygel_searchable_container_base_init (RygelSearchableContainerIface * iface) {
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	static gboolean initialized = FALSE;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (!initialized) {
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		initialized = TRUE;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_object_interface_install_property (iface, g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2035 "rygel-searchable-container.c"
	}
}


/**
 * The base class for searchable containers.
 *
 * Classes that implement this interface can, for instance:
 *
 *  # Allow backends to implement a UPnP Search call using native searching (such as SQL or SPARQL queries).
 *  # Implement searching via the naïve default implementation provided by rygel_searchable_container_simple_search(), which does a recursive tree walk.
 *
 * The search_classes property lists what information this container may be searched
 * for. It is mapped to upnp:searchClass (with includeDerived assumed to be false),
 */
GType rygel_searchable_container_get_type (void) {
	static volatile gsize rygel_searchable_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_searchable_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSearchableContainerIface), (GBaseInitFunc) rygel_searchable_container_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_searchable_container_type_id;
		rygel_searchable_container_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelSearchableContainer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_searchable_container_type_id, RYGEL_TYPE_MEDIA_CONTAINER);
		g_once_init_leave (&rygel_searchable_container_type_id__volatile, rygel_searchable_container_type_id);
	}
	return rygel_searchable_container_type_id__volatile;
}



