/* rygel-gst-data-source.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-gst-data-source.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <gst/gst.h>
#include <gst/base/gstadapter.h>
#include <gst/base/gstbaseparse.h>
#include <gst/base/gstbasesink.h>
#include <gst/base/gstbasesrc.h>
#include <gst/base/gstbasetransform.h>
#include <gst/base/gstbitreader.h>
#include <gst/base/gstbytereader.h>
#include <gst/base/gstbytewriter.h>
#include <gst/base/gstcollectpads.h>
#include <gst/base/gstpushsrc.h>
#include <gst/base/gsttypefindhelper.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_GST_DATA_SOURCE (rygel_gst_data_source_get_type ())
#define RYGEL_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSource))
#define RYGEL_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))
#define RYGEL_IS_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_IS_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_GST_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))

typedef struct _RygelGstDataSource RygelGstDataSource;
typedef struct _RygelGstDataSourceClass RygelGstDataSourceClass;
typedef struct _RygelGstDataSourcePrivate RygelGstDataSourcePrivate;

#define RYGEL_TYPE_GST_SINK (rygel_gst_sink_get_type ())
#define RYGEL_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_SINK, RygelGstSink))
#define RYGEL_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_SINK, RygelGstSinkClass))
#define RYGEL_IS_GST_SINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_SINK))
#define RYGEL_IS_GST_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_SINK))
#define RYGEL_GST_SINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_SINK, RygelGstSinkClass))

typedef struct _RygelGstSink RygelGstSink;
typedef struct _RygelGstSinkClass RygelGstSinkClass;
typedef struct _RygelGstSinkPrivate RygelGstSinkPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	RYGEL_GST_DATA_SOURCE_ERROR_NOT_COMPATIBLE
} RygelGstDataSourceError;
#define RYGEL_GST_DATA_SOURCE_ERROR rygel_gst_data_source_error_quark ()
struct _RygelGstDataSource {
	GObject parent_instance;
	RygelGstDataSourcePrivate * priv;
	GstElement* src;
};

struct _RygelGstDataSourceClass {
	GObjectClass parent_class;
};

struct _RygelGstDataSourcePrivate {
	GstPipeline* pipeline;
	RygelHTTPSeek* seek;
	RygelGstSink* sink;
	guint bus_watch_id;
};

struct _RygelGstSink {
	GstBaseSink parent_instance;
	RygelGstSinkPrivate * priv;
	GCancellable* cancellable;
};

struct _RygelGstSinkClass {
	GstBaseSinkClass parent_class;
};

typedef enum  {
	RYGEL_GST_ERROR_MISSING_PLUGIN,
	RYGEL_GST_ERROR_LINK
} RygelGstError;
#define RYGEL_GST_ERROR rygel_gst_error_quark ()

static gpointer rygel_gst_data_source_parent_class = NULL;
static RygelDataSourceIface* rygel_gst_data_source_rygel_data_source_parent_iface = NULL;

GQuark rygel_gst_data_source_error_quark (void);
GType rygel_gst_data_source_get_type (void) G_GNUC_CONST;
GType rygel_gst_sink_get_type (void) G_GNUC_CONST;
#define RYGEL_GST_DATA_SOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourcePrivate))
enum  {
	RYGEL_GST_DATA_SOURCE_DUMMY_PROPERTY
};
RygelGstDataSource* rygel_gst_data_source_new (const gchar* uri, GError** error);
RygelGstDataSource* rygel_gst_data_source_construct (GType object_type, const gchar* uri, GError** error);
GstElement* rygel_gst_utils_create_source_for_uri (const gchar* uri);
RygelGstDataSource* rygel_gst_data_source_new_from_element (GstElement* element);
RygelGstDataSource* rygel_gst_data_source_construct_from_element (GType object_type, GstElement* element);
static void rygel_gst_data_source_real_start (RygelDataSource* base, RygelHTTPSeek* offsets, GError** error);
static void rygel_gst_data_source_prepare_pipeline (RygelGstDataSource* self, const gchar* name, GstElement* src, GError** error);
static void rygel_gst_data_source_real_freeze (RygelDataSource* base);
void rygel_gst_sink_freeze (RygelGstSink* self);
static void rygel_gst_data_source_real_thaw (RygelDataSource* base);
void rygel_gst_sink_thaw (RygelGstSink* self);
static void rygel_gst_data_source_real_stop (RygelDataSource* base);
static gboolean __lambda4_ (RygelGstDataSource* self);
static gboolean ___lambda4__gsource_func (gpointer self);
RygelGstSink* rygel_gst_sink_new (RygelDataSource* source, RygelHTTPSeek* offsets);
RygelGstSink* rygel_gst_sink_construct (GType object_type, RygelDataSource* source, RygelHTTPSeek* offsets);
static void rygel_gst_data_source_src_pad_added (RygelGstDataSource* self, GstElement* src, GstPad* src_pad);
static void _rygel_gst_data_source_src_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self);
GQuark rygel_gst_error_quark (void);
static gboolean rygel_gst_data_source_bus_handler (RygelGstDataSource* self, GstBus* bus, GstMessage* message);
static gboolean _rygel_gst_data_source_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
#define RYGEL_GST_SINK_NAME "http-gst-sink"
GstElement* rygel_gst_utils_get_rtp_depayloader (GstCaps* caps);
static inline void _dynamic_set_streamable0 (GstElement* obj, gboolean value);
static inline void _dynamic_set_fragment_duration1 (GstElement* obj, gint value);
static gboolean rygel_gst_data_source_perform_seek (RygelGstDataSource* self);
static gboolean ___lambda3_ (RygelGstDataSource* self);
static gboolean ____lambda3__gsource_func (gpointer self);
static void rygel_gst_data_source_finalize (GObject* obj);


GQuark rygel_gst_data_source_error_quark (void) {
	return g_quark_from_static_string ("rygel_gst_data_source_error-quark");
}


RygelGstDataSource* rygel_gst_data_source_construct (GType object_type, const gchar* uri, GError** error) {
	RygelGstDataSource * self = NULL;
	const gchar* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	GstElement* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 36 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 36 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self = (RygelGstDataSource*) g_object_new (object_type, NULL);
#line 37 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp0_ = uri;
#line 37 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp1_ = rygel_gst_utils_create_source_for_uri (_tmp0_);
#line 37 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (self->src);
#line 37 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self->src = _tmp1_;
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp2_ = self->src;
#line 38 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp2_ == NULL) {
#line 179 "rygel-gst-data-source.c"
		gchar* msg = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
#line 39 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp3_ = _ ("Could not create GstElement for URI %s");
#line 39 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 39 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		msg = _tmp4_;
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp5_ = msg;
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp6_ = uri;
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp7_ = g_error_new (RYGEL_GST_DATA_SOURCE_ERROR, RYGEL_GST_DATA_SOURCE_ERROR_NOT_COMPATIBLE, _tmp5_, _tmp6_);
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_inner_error_ = _tmp7_;
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_propagate_error (error, _inner_error_);
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_g_free0 (msg);
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_g_object_unref0 (self);
#line 41 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		return NULL;
#line 208 "rygel-gst-data-source.c"
	}
#line 36 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return self;
#line 212 "rygel-gst-data-source.c"
}


RygelGstDataSource* rygel_gst_data_source_new (const gchar* uri, GError** error) {
#line 36 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return rygel_gst_data_source_construct (RYGEL_TYPE_GST_DATA_SOURCE, uri, error);
#line 219 "rygel-gst-data-source.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 56 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return self ? g_object_ref (self) : NULL;
#line 226 "rygel-gst-data-source.c"
}


RygelGstDataSource* rygel_gst_data_source_construct_from_element (GType object_type, GstElement* element) {
	RygelGstDataSource * self = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
#line 55 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_val_if_fail (element != NULL, NULL);
#line 55 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self = (RygelGstDataSource*) g_object_new (object_type, NULL);
#line 56 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp0_ = element;
#line 56 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 56 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (self->src);
#line 56 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self->src = _tmp1_;
#line 55 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return self;
#line 248 "rygel-gst-data-source.c"
}


RygelGstDataSource* rygel_gst_data_source_new_from_element (GstElement* element) {
#line 55 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return rygel_gst_data_source_construct_from_element (RYGEL_TYPE_GST_DATA_SOURCE, element);
#line 255 "rygel-gst-data-source.c"
}


static void rygel_gst_data_source_real_start (RygelDataSource* base, RygelHTTPSeek* offsets, GError** error) {
	RygelGstDataSource * self;
	RygelHTTPSeek* _tmp0_ = NULL;
	RygelHTTPSeek* _tmp1_ = NULL;
	GstElement* _tmp2_ = NULL;
	RygelHTTPSeek* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 59 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self = (RygelGstDataSource*) base;
#line 60 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp0_ = offsets;
#line 60 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 60 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (self->priv->seek);
#line 60 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self->priv->seek = _tmp1_;
#line 61 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp2_ = self->src;
#line 61 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	rygel_gst_data_source_prepare_pipeline (self, "RygelGstDataSource", _tmp2_, &_inner_error_);
#line 61 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_inner_error_ != NULL) {
#line 61 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_propagate_error (error, _inner_error_);
#line 61 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		return;
#line 286 "rygel-gst-data-source.c"
	}
#line 62 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp3_ = self->priv->seek;
#line 62 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp3_ != NULL) {
#line 292 "rygel-gst-data-source.c"
		GstPipeline* _tmp4_ = NULL;
#line 63 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp4_ = self->priv->pipeline;
#line 63 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		gst_element_set_state ((GstElement*) _tmp4_, GST_STATE_PAUSED);
#line 298 "rygel-gst-data-source.c"
	} else {
		GstPipeline* _tmp5_ = NULL;
#line 65 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp5_ = self->priv->pipeline;
#line 65 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		gst_element_set_state ((GstElement*) _tmp5_, GST_STATE_PLAYING);
#line 305 "rygel-gst-data-source.c"
	}
}


static void rygel_gst_data_source_real_freeze (RygelDataSource* base) {
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_ = NULL;
#line 69 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self = (RygelGstDataSource*) base;
#line 70 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp0_ = self->priv->sink;
#line 70 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	rygel_gst_sink_freeze (_tmp0_);
#line 319 "rygel-gst-data-source.c"
}


static void rygel_gst_data_source_real_thaw (RygelDataSource* base) {
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_ = NULL;
#line 73 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self = (RygelGstDataSource*) base;
#line 74 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp0_ = self->priv->sink;
#line 74 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	rygel_gst_sink_thaw (_tmp0_);
#line 332 "rygel-gst-data-source.c"
}


static gboolean __lambda4_ (RygelGstDataSource* self) {
	gboolean result = FALSE;
#line 82 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_signal_emit_by_name ((RygelDataSource*) self, "done");
#line 82 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	result = FALSE;
#line 82 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return result;
#line 344 "rygel-gst-data-source.c"
}


static gboolean ___lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda4_ (self);
#line 82 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return result;
#line 353 "rygel-gst-data-source.c"
}


static void rygel_gst_data_source_real_stop (RygelDataSource* base) {
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GstPipeline* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
#line 77 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self = (RygelGstDataSource*) base;
#line 79 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp0_ = self->priv->sink;
#line 79 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp1_ = _tmp0_->cancellable;
#line 79 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_cancellable_cancel (_tmp1_);
#line 80 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp2_ = self->priv->pipeline;
#line 80 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	gst_element_set_state ((GstElement*) _tmp2_, GST_STATE_NULL);
#line 81 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp3_ = self->priv->bus_watch_id;
#line 81 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_source_remove (_tmp3_);
#line 82 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
#line 381 "rygel-gst-data-source.c"
}


static void _rygel_gst_data_source_src_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self) {
#line 99 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	rygel_gst_data_source_src_pad_added (self, _sender, pad);
#line 388 "rygel-gst-data-source.c"
}


static gboolean _rygel_gst_data_source_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	gboolean result;
	result = rygel_gst_data_source_bus_handler (self, bus, message);
#line 111 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return result;
#line 397 "rygel-gst-data-source.c"
}


static void rygel_gst_data_source_prepare_pipeline (RygelGstDataSource* self, const gchar* name, GstElement* src, GError** error) {
	RygelHTTPSeek* _tmp0_ = NULL;
	RygelGstSink* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GstPipeline* _tmp3_ = NULL;
	GstPipeline* _tmp4_ = NULL;
	GstPipeline* _tmp7_ = NULL;
	GstElement* _tmp8_ = NULL;
	GstElement* _tmp9_ = NULL;
	RygelGstSink* _tmp10_ = NULL;
	GstElement* _tmp11_ = NULL;
	guint16 _tmp12_ = 0U;
	GstBus* bus = NULL;
	GstPipeline* _tmp28_ = NULL;
	GstBus* _tmp29_ = NULL;
	GstBus* _tmp30_ = NULL;
	guint _tmp31_ = 0U;
	GError * _inner_error_ = NULL;
#line 85 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_if_fail (self != NULL);
#line 85 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_if_fail (name != NULL);
#line 85 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_if_fail (src != NULL);
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp0_ = self->priv->seek;
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp1_ = rygel_gst_sink_new ((RygelDataSource*) self, _tmp0_);
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_object_ref_sink (_tmp1_);
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (self->priv->sink);
#line 87 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self->priv->sink = _tmp1_;
#line 89 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp2_ = name;
#line 89 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp3_ = (GstPipeline*) gst_pipeline_new (_tmp2_);
#line 89 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_object_ref_sink (_tmp3_);
#line 89 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (self->priv->pipeline);
#line 89 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self->priv->pipeline = _tmp3_;
#line 90 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp4_ = self->priv->pipeline;
#line 90 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp4_ == NULL) {
#line 449 "rygel-gst-data-source.c"
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
#line 91 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp5_ = _ ("Failed to create pipeline");
#line 91 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp6_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_GENERAL, _tmp5_);
#line 91 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_inner_error_ = _tmp6_;
#line 91 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_propagate_error (error, _inner_error_);
#line 91 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		return;
#line 462 "rygel-gst-data-source.c"
	}
#line 95 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp7_ = self->priv->pipeline;
#line 95 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp8_ = src;
#line 95 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 95 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp10_ = self->priv->sink;
#line 95 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	gst_bin_add_many ((GstBin*) _tmp7_, _tmp9_, _tmp10_, NULL);
#line 97 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp11_ = src;
#line 97 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp12_ = _tmp11_->numsrcpads;
#line 97 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (((gint) _tmp12_) == 0) {
#line 480 "rygel-gst-data-source.c"
		GstElement* _tmp13_ = NULL;
#line 99 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp13_ = src;
#line 99 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_signal_connect_object (_tmp13_, "pad-added", (GCallback) _rygel_gst_data_source_src_pad_added_gst_element_pad_added, self, 0);
#line 486 "rygel-gst-data-source.c"
	} else {
		GstElement* _tmp14_ = NULL;
		RygelGstSink* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
#line 102 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp14_ = src;
#line 102 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp15_ = self->priv->sink;
#line 102 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp16_ = gst_element_link (_tmp14_, (GstElement*) _tmp15_);
#line 102 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		if (!_tmp16_) {
#line 499 "rygel-gst-data-source.c"
			const gchar* _tmp17_ = NULL;
			GstElement* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			RygelGstSink* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			GError* _tmp26_ = NULL;
			GError* _tmp27_ = NULL;
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp17_ = _ ("Failed to link %s to %s");
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp18_ = src;
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			g_object_get ((GstObject*) _tmp18_, "name", &_tmp19_, NULL);
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp20_ = _tmp19_;
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp21_ = _tmp20_;
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp22_ = self->priv->sink;
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			g_object_get ((GstObject*) _tmp22_, "name", &_tmp23_, NULL);
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp24_ = _tmp23_;
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp25_ = _tmp24_;
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp26_ = g_error_new (RYGEL_GST_ERROR, RYGEL_GST_ERROR_LINK, _tmp17_, _tmp21_, _tmp25_);
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp27_ = _tmp26_;
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_g_free0 (_tmp25_);
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_g_free0 (_tmp21_);
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_inner_error_ = _tmp27_;
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			g_propagate_error (error, _inner_error_);
#line 103 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			return;
#line 543 "rygel-gst-data-source.c"
		}
	}
#line 110 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp28_ = self->priv->pipeline;
#line 110 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp29_ = gst_pipeline_get_bus (_tmp28_);
#line 110 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	bus = _tmp29_;
#line 111 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp30_ = bus;
#line 111 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp31_ = gst_bus_add_watch_full (_tmp30_, G_PRIORITY_DEFAULT, _rygel_gst_data_source_bus_handler_gst_bus_func, g_object_ref (self), g_object_unref);
#line 111 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self->priv->bus_watch_id = _tmp31_;
#line 85 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (bus);
#line 560 "rygel-gst-data-source.c"
}


static void rygel_gst_data_source_src_pad_added (RygelGstDataSource* self, GstElement* src, GstPad* src_pad) {
	GstCaps* caps = NULL;
	GstPad* _tmp0_ = NULL;
	GstCaps* _tmp1_ = NULL;
	GstElement* sink = NULL;
	GstPipeline* _tmp2_ = NULL;
	GstElement* _tmp3_ = NULL;
	GstPad* sink_pad = NULL;
	GstElement* depay = NULL;
	GstCaps* _tmp4_ = NULL;
	GstElement* _tmp5_ = NULL;
	GstElement* _tmp6_ = NULL;
	GstPad* _tmp30_ = NULL;
	GstPad* _tmp31_ = NULL;
	GstPadLinkReturn _tmp32_ = 0;
	GstElement* _tmp42_ = NULL;
#line 114 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_if_fail (self != NULL);
#line 114 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_if_fail (src != NULL);
#line 114 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_if_fail (src_pad != NULL);
#line 115 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp0_ = src_pad;
#line 115 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp1_ = gst_pad_query_caps (_tmp0_, NULL);
#line 115 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	caps = _tmp1_;
#line 117 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp2_ = self->priv->pipeline;
#line 117 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp3_ = gst_bin_get_by_name ((GstBin*) _tmp2_, RYGEL_GST_SINK_NAME);
#line 117 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	sink = _tmp3_;
#line 120 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp4_ = caps;
#line 120 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp5_ = rygel_gst_utils_get_rtp_depayloader (_tmp4_);
#line 120 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	depay = _tmp5_;
#line 121 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp6_ = depay;
#line 121 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp6_ != NULL) {
#line 608 "rygel-gst-data-source.c"
		GstPipeline* _tmp7_ = NULL;
		GstElement* _tmp8_ = NULL;
		GstElement* _tmp9_ = NULL;
		GstElement* _tmp10_ = NULL;
		GstElement* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		GstElement* _tmp22_ = NULL;
		GstPad* _tmp23_ = NULL;
		GstCaps* _tmp24_ = NULL;
		GstPad* _tmp25_ = NULL;
#line 122 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp7_ = self->priv->pipeline;
#line 122 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp8_ = depay;
#line 122 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 122 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		gst_bin_add ((GstBin*) _tmp7_, _tmp9_);
#line 123 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp10_ = depay;
#line 123 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp11_ = sink;
#line 123 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp12_ = gst_element_link (_tmp10_, _tmp11_);
#line 123 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		if (!_tmp12_) {
#line 635 "rygel-gst-data-source.c"
			const gchar* _tmp13_ = NULL;
			GstElement* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			GstElement* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
#line 124 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp13_ = _ ("Failed to link %s to %s");
#line 124 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp14_ = depay;
#line 124 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			g_object_get ((GstObject*) _tmp14_, "name", &_tmp15_, NULL);
#line 124 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp16_ = _tmp15_;
#line 124 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp17_ = _tmp16_;
#line 124 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp18_ = sink;
#line 124 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			g_object_get ((GstObject*) _tmp18_, "name", &_tmp19_, NULL);
#line 124 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp20_ = _tmp19_;
#line 124 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp21_ = _tmp20_;
#line 124 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			g_critical (_tmp13_, _tmp17_, _tmp21_);
#line 124 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_g_free0 (_tmp21_);
#line 124 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_g_free0 (_tmp17_);
#line 127 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			g_signal_emit_by_name ((RygelDataSource*) self, "done");
#line 129 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_g_object_unref0 (depay);
#line 129 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_g_object_unref0 (sink_pad);
#line 129 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_g_object_unref0 (sink);
#line 129 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_gst_caps_unref0 (caps);
#line 129 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			return;
#line 681 "rygel-gst-data-source.c"
		}
#line 132 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp22_ = depay;
#line 132 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp23_ = src_pad;
#line 132 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp24_ = caps;
#line 132 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp25_ = gst_element_get_compatible_pad (_tmp22_, _tmp23_, _tmp24_);
#line 132 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_g_object_unref0 (sink_pad);
#line 132 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		sink_pad = _tmp25_;
#line 695 "rygel-gst-data-source.c"
	} else {
		GstElement* _tmp26_ = NULL;
		GstPad* _tmp27_ = NULL;
		GstCaps* _tmp28_ = NULL;
		GstPad* _tmp29_ = NULL;
#line 134 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp26_ = sink;
#line 134 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp27_ = src_pad;
#line 134 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp28_ = caps;
#line 134 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp29_ = gst_element_get_compatible_pad (_tmp26_, _tmp27_, _tmp28_);
#line 134 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_g_object_unref0 (sink_pad);
#line 134 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		sink_pad = _tmp29_;
#line 713 "rygel-gst-data-source.c"
	}
#line 137 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp30_ = src_pad;
#line 137 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp31_ = sink_pad;
#line 137 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp32_ = gst_pad_link_full (_tmp30_, _tmp31_, GST_PAD_LINK_CHECK_DEFAULT);
#line 137 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp32_ != GST_PAD_LINK_OK) {
#line 723 "rygel-gst-data-source.c"
		const gchar* _tmp33_ = NULL;
		GstPad* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		GstPad* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
#line 138 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp33_ = _ ("Failed to link pad %s to %s");
#line 138 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp34_ = src_pad;
#line 138 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_object_get ((GstObject*) _tmp34_, "name", &_tmp35_, NULL);
#line 138 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp36_ = _tmp35_;
#line 138 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp37_ = _tmp36_;
#line 138 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp38_ = sink_pad;
#line 138 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_object_get ((GstObject*) _tmp38_, "name", &_tmp39_, NULL);
#line 138 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp40_ = _tmp39_;
#line 138 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp41_ = _tmp40_;
#line 138 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_critical (_tmp33_, _tmp37_, _tmp41_);
#line 138 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_g_free0 (_tmp41_);
#line 138 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_g_free0 (_tmp37_);
#line 141 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_signal_emit_by_name ((RygelDataSource*) self, "done");
#line 143 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_g_object_unref0 (depay);
#line 143 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_g_object_unref0 (sink_pad);
#line 143 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_g_object_unref0 (sink);
#line 143 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_gst_caps_unref0 (caps);
#line 143 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		return;
#line 769 "rygel-gst-data-source.c"
	}
#line 146 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp42_ = depay;
#line 146 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp42_ != NULL) {
#line 775 "rygel-gst-data-source.c"
		GstElement* _tmp43_ = NULL;
#line 147 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp43_ = depay;
#line 147 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		gst_element_sync_state_with_parent (_tmp43_);
#line 781 "rygel-gst-data-source.c"
	}
#line 114 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (depay);
#line 114 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (sink_pad);
#line 114 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (sink);
#line 114 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_gst_caps_unref0 (caps);
#line 791 "rygel-gst-data-source.c"
}


static inline void _dynamic_set_streamable0 (GstElement* obj, gboolean value) {
#line 174 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_object_set (obj, "streamable", value, NULL);
#line 798 "rygel-gst-data-source.c"
}


static inline void _dynamic_set_fragment_duration1 (GstElement* obj, gint value) {
#line 175 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_object_set (obj, "fragment-duration", value, NULL);
#line 805 "rygel-gst-data-source.c"
}


static gboolean ___lambda3_ (RygelGstDataSource* self) {
	gboolean result = FALSE;
#line 208 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_signal_emit_by_name ((RygelDataSource*) self, "done");
#line 210 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	result = FALSE;
#line 210 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return result;
#line 817 "rygel-gst-data-source.c"
}


static gboolean ____lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda3_ (self);
#line 207 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return result;
#line 826 "rygel-gst-data-source.c"
}


static gboolean rygel_gst_data_source_bus_handler (RygelGstDataSource* self, GstBus* bus, GstMessage* message) {
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GstMessage* _tmp0_ = NULL;
	GstMessageType _tmp1_ = 0;
	gboolean _tmp52_ = FALSE;
#line 151 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 151 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_val_if_fail (bus != NULL, FALSE);
#line 151 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_val_if_fail (message != NULL, FALSE);
#line 152 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	ret = TRUE;
#line 154 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp0_ = message;
#line 154 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp1_ = _tmp0_->type;
#line 154 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp1_ == GST_MESSAGE_EOS) {
#line 155 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		ret = FALSE;
#line 852 "rygel-gst-data-source.c"
	} else {
		GstMessage* _tmp2_ = NULL;
		GstMessageType _tmp3_ = 0;
#line 156 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp2_ = message;
#line 156 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp3_ = _tmp2_->type;
#line 156 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		if (_tmp3_ == GST_MESSAGE_STATE_CHANGED) {
#line 862 "rygel-gst-data-source.c"
			GstMessage* _tmp4_ = NULL;
			GstObject* _tmp5_ = NULL;
			GstPipeline* _tmp6_ = NULL;
			GstState old_state = 0;
			GstState new_state = 0;
			GstMessage* _tmp7_ = NULL;
			GstState _tmp8_ = 0;
			GstState _tmp9_ = 0;
			gboolean _tmp10_ = FALSE;
			GstState _tmp11_ = 0;
			gboolean _tmp13_ = FALSE;
			RygelHTTPSeek* _tmp23_ = NULL;
#line 157 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp4_ = message;
#line 157 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp5_ = _tmp4_->src;
#line 157 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp6_ = self->priv->pipeline;
#line 157 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			if (_tmp5_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gst_object_get_type (), GstObject)) {
#line 158 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				result = TRUE;
#line 158 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				return result;
#line 887 "rygel-gst-data-source.c"
			}
#line 164 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp7_ = message;
#line 164 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			gst_message_parse_state_changed (_tmp7_, &_tmp8_, &_tmp9_, NULL);
#line 164 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			old_state = _tmp8_;
#line 164 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			new_state = _tmp9_;
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp11_ = old_state;
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			if (_tmp11_ == GST_STATE_NULL) {
#line 901 "rygel-gst-data-source.c"
				GstState _tmp12_ = 0;
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp12_ = new_state;
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp10_ = _tmp12_ == GST_STATE_READY;
#line 907 "rygel-gst-data-source.c"
			} else {
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp10_ = FALSE;
#line 911 "rygel-gst-data-source.c"
			}
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp13_ = _tmp10_;
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			if (_tmp13_) {
#line 917 "rygel-gst-data-source.c"
				GstElement* element = NULL;
				GstPipeline* _tmp14_ = NULL;
				GstElement* _tmp15_ = NULL;
				GstElement* _tmp16_ = NULL;
#line 169 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp14_ = self->priv->pipeline;
#line 169 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp15_ = gst_bin_get_by_name ((GstBin*) _tmp14_, "muxer");
#line 169 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				element = _tmp15_;
#line 170 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp16_ = element;
#line 170 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				if (_tmp16_ != NULL) {
#line 932 "rygel-gst-data-source.c"
					gchar* name = NULL;
					GstElement* _tmp17_ = NULL;
					GstElementFactory* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
#line 171 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp17_ = element;
#line 171 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp18_ = gst_element_get_factory (_tmp17_);
#line 171 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp19_ = gst_object_get_name ((GstObject*) _tmp18_);
#line 171 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					name = _tmp19_;
#line 173 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp20_ = name;
#line 173 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					if (g_strcmp0 (_tmp20_, "mp4mux") == 0) {
#line 950 "rygel-gst-data-source.c"
						GstElement* _tmp21_ = NULL;
						GstElement* _tmp22_ = NULL;
#line 174 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
						_tmp21_ = element;
#line 174 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
						_dynamic_set_streamable0 (_tmp21_, TRUE);
#line 175 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
						_tmp22_ = element;
#line 175 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
						_dynamic_set_fragment_duration1 (_tmp22_, 1000);
#line 961 "rygel-gst-data-source.c"
					}
#line 170 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_g_free0 (name);
#line 965 "rygel-gst-data-source.c"
				}
#line 168 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_g_object_unref0 (element);
#line 969 "rygel-gst-data-source.c"
			}
#line 180 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp23_ = self->priv->seek;
#line 180 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			if (_tmp23_ != NULL) {
#line 975 "rygel-gst-data-source.c"
				gboolean _tmp24_ = FALSE;
				GstState _tmp25_ = 0;
				gboolean _tmp27_ = FALSE;
#line 181 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp25_ = old_state;
#line 181 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				if (_tmp25_ == GST_STATE_READY) {
#line 983 "rygel-gst-data-source.c"
					GstState _tmp26_ = 0;
#line 181 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp26_ = new_state;
#line 181 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp24_ = _tmp26_ == GST_STATE_PAUSED;
#line 989 "rygel-gst-data-source.c"
				} else {
#line 181 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp24_ = FALSE;
#line 993 "rygel-gst-data-source.c"
				}
#line 181 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp27_ = _tmp24_;
#line 181 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				if (_tmp27_) {
#line 999 "rygel-gst-data-source.c"
					gboolean _tmp28_ = FALSE;
#line 182 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp28_ = rygel_gst_data_source_perform_seek (self);
#line 182 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					if (_tmp28_) {
#line 1005 "rygel-gst-data-source.c"
						GstPipeline* _tmp29_ = NULL;
#line 183 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
						_tmp29_ = self->priv->pipeline;
#line 183 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
						gst_element_set_state ((GstElement*) _tmp29_, GST_STATE_PLAYING);
#line 1011 "rygel-gst-data-source.c"
					}
				}
			}
		} else {
			GError* err = NULL;
			gchar* err_msg = NULL;
			GstMessage* _tmp30_ = NULL;
			GstMessageType _tmp31_ = 0;
#line 191 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp30_ = message;
#line 191 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_tmp31_ = _tmp30_->type;
#line 191 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			if (_tmp31_ == GST_MESSAGE_ERROR) {
#line 1026 "rygel-gst-data-source.c"
				GstMessage* _tmp32_ = NULL;
				GError* _tmp33_ = NULL;
				gchar* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				GstPipeline* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				gchar* _tmp39_ = NULL;
				const gchar* _tmp40_ = NULL;
#line 192 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp32_ = message;
#line 192 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				gst_message_parse_error (_tmp32_, &_tmp33_, &_tmp34_);
#line 192 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_g_error_free0 (err);
#line 192 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				err = _tmp33_;
#line 192 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_g_free0 (err_msg);
#line 192 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				err_msg = _tmp34_;
#line 193 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp35_ = _ ("Error from pipeline %s: %s");
#line 193 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp36_ = self->priv->pipeline;
#line 193 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				g_object_get ((GstObject*) _tmp36_, "name", &_tmp37_, NULL);
#line 193 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp38_ = _tmp37_;
#line 193 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp39_ = _tmp38_;
#line 193 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp40_ = err_msg;
#line 193 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				g_critical (_tmp35_, _tmp39_, _tmp40_);
#line 193 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_g_free0 (_tmp39_);
#line 197 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				ret = FALSE;
#line 1066 "rygel-gst-data-source.c"
			} else {
				GstMessage* _tmp41_ = NULL;
				GstMessageType _tmp42_ = 0;
#line 198 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp41_ = message;
#line 198 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				_tmp42_ = _tmp41_->type;
#line 198 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
				if (_tmp42_ == GST_MESSAGE_WARNING) {
#line 1076 "rygel-gst-data-source.c"
					GstMessage* _tmp43_ = NULL;
					GError* _tmp44_ = NULL;
					gchar* _tmp45_ = NULL;
					const gchar* _tmp46_ = NULL;
					GstPipeline* _tmp47_ = NULL;
					gchar* _tmp48_ = NULL;
					gchar* _tmp49_ = NULL;
					gchar* _tmp50_ = NULL;
					const gchar* _tmp51_ = NULL;
#line 199 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp43_ = message;
#line 199 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					gst_message_parse_warning (_tmp43_, &_tmp44_, &_tmp45_);
#line 199 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_g_error_free0 (err);
#line 199 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					err = _tmp44_;
#line 199 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_g_free0 (err_msg);
#line 199 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					err_msg = _tmp45_;
#line 200 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp46_ = _ ("Warning from pipeline %s: %s");
#line 200 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp47_ = self->priv->pipeline;
#line 200 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					g_object_get ((GstObject*) _tmp47_, "name", &_tmp48_, NULL);
#line 200 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp49_ = _tmp48_;
#line 200 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp50_ = _tmp49_;
#line 200 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_tmp51_ = err_msg;
#line 200 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					g_warning (_tmp46_, _tmp50_, _tmp51_);
#line 200 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
					_g_free0 (_tmp50_);
#line 1114 "rygel-gst-data-source.c"
				}
			}
#line 156 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_g_free0 (err_msg);
#line 156 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
			_g_error_free0 (err);
#line 1121 "rygel-gst-data-source.c"
		}
	}
#line 206 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp52_ = ret;
#line 206 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (!_tmp52_) {
#line 207 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_idle_add_full (G_PRIORITY_DEFAULT, ____lambda3__gsource_func, g_object_ref (self), g_object_unref);
#line 1130 "rygel-gst-data-source.c"
	}
#line 214 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	result = ret;
#line 214 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return result;
#line 1136 "rygel-gst-data-source.c"
}


static gboolean rygel_gst_data_source_perform_seek (RygelGstDataSource* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	RygelHTTPSeek* _tmp1_ = NULL;
	gboolean _tmp8_ = FALSE;
	GstSeekType stop_type = 0;
	GstFormat format = 0;
	GstSeekFlags flags = 0;
	gint64 start = 0LL;
	gint64 stop = 0LL;
	RygelHTTPSeek* _tmp9_ = NULL;
	RygelHTTPSeekType _tmp10_ = 0;
	RygelHTTPSeekType _tmp11_ = 0;
	RygelHTTPSeek* _tmp26_ = NULL;
	gint64 _tmp27_ = 0LL;
	gint64 _tmp28_ = 0LL;
	GstPipeline* _tmp29_ = NULL;
	GstFormat _tmp30_ = 0;
	GstSeekFlags _tmp31_ = 0;
	gint64 _tmp32_ = 0LL;
	GstSeekType _tmp33_ = 0;
	gint64 _tmp34_ = 0LL;
	gboolean _tmp35_ = FALSE;
#line 217 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 218 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp1_ = self->priv->seek;
#line 218 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp1_ != NULL) {
#line 1169 "rygel-gst-data-source.c"
		RygelHTTPSeek* _tmp2_ = NULL;
		gint64 _tmp3_ = 0LL;
		gint64 _tmp4_ = 0LL;
		RygelHTTPSeek* _tmp5_ = NULL;
		gint64 _tmp6_ = 0LL;
		gint64 _tmp7_ = 0LL;
#line 219 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp2_ = self->priv->seek;
#line 219 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp3_ = rygel_http_seek_get_length (_tmp2_);
#line 219 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp4_ = _tmp3_;
#line 219 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp5_ = self->priv->seek;
#line 219 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp6_ = rygel_http_seek_get_total_length (_tmp5_);
#line 219 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp7_ = _tmp6_;
#line 219 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp0_ = _tmp4_ >= _tmp7_;
#line 1190 "rygel-gst-data-source.c"
	} else {
#line 218 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp0_ = FALSE;
#line 1194 "rygel-gst-data-source.c"
	}
#line 218 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp8_ = _tmp0_;
#line 218 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp8_) {
#line 220 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		result = TRUE;
#line 220 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		return result;
#line 1204 "rygel-gst-data-source.c"
	}
#line 223 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	stop_type = GST_SEEK_TYPE_NONE;
#line 225 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	flags = GST_SEEK_FLAG_FLUSH;
#line 228 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp9_ = self->priv->seek;
#line 228 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp10_ = rygel_http_seek_get_seek_type (_tmp9_);
#line 228 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp11_ = _tmp10_;
#line 228 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp11_ == RYGEL_HTTP_SEEK_TYPE_TIME) {
#line 1218 "rygel-gst-data-source.c"
		GstSeekFlags _tmp12_ = 0;
		RygelHTTPSeek* _tmp13_ = NULL;
		gint64 _tmp14_ = 0LL;
		gint64 _tmp15_ = 0LL;
		RygelHTTPSeek* _tmp16_ = NULL;
		gint64 _tmp17_ = 0LL;
		gint64 _tmp18_ = 0LL;
#line 229 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		format = GST_FORMAT_TIME;
#line 230 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp12_ = flags;
#line 230 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		flags = _tmp12_ | GST_SEEK_FLAG_KEY_UNIT;
#line 231 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp13_ = self->priv->seek;
#line 231 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp14_ = rygel_http_seek_get_start (_tmp13_);
#line 231 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp15_ = _tmp14_;
#line 231 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		start = _tmp15_ * GST_USECOND;
#line 232 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp16_ = self->priv->seek;
#line 232 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp17_ = rygel_http_seek_get_stop (_tmp16_);
#line 232 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp18_ = _tmp17_;
#line 232 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		stop = _tmp18_ * GST_USECOND;
#line 1248 "rygel-gst-data-source.c"
	} else {
		GstSeekFlags _tmp19_ = 0;
		RygelHTTPSeek* _tmp20_ = NULL;
		gint64 _tmp21_ = 0LL;
		gint64 _tmp22_ = 0LL;
		RygelHTTPSeek* _tmp23_ = NULL;
		gint64 _tmp24_ = 0LL;
		gint64 _tmp25_ = 0LL;
#line 234 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		format = GST_FORMAT_BYTES;
#line 235 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp19_ = flags;
#line 235 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		flags = _tmp19_ | GST_SEEK_FLAG_ACCURATE;
#line 236 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp20_ = self->priv->seek;
#line 236 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp21_ = rygel_http_seek_get_start (_tmp20_);
#line 236 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp22_ = _tmp21_;
#line 236 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		start = _tmp22_;
#line 237 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp23_ = self->priv->seek;
#line 237 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp24_ = rygel_http_seek_get_stop (_tmp23_);
#line 237 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp25_ = _tmp24_;
#line 237 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		stop = _tmp25_;
#line 1279 "rygel-gst-data-source.c"
	}
#line 240 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp26_ = self->priv->seek;
#line 240 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp27_ = rygel_http_seek_get_stop (_tmp26_);
#line 240 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp28_ = _tmp27_;
#line 240 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp28_ > ((gint64) 0)) {
#line 241 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		stop_type = GST_SEEK_TYPE_SET;
#line 1291 "rygel-gst-data-source.c"
	}
#line 244 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp29_ = self->priv->pipeline;
#line 244 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp30_ = format;
#line 244 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp31_ = flags;
#line 244 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp32_ = start;
#line 244 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp33_ = stop_type;
#line 244 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp34_ = stop;
#line 244 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp35_ = gst_element_seek ((GstElement*) _tmp29_, 1.0, _tmp30_, _tmp31_, GST_SEEK_TYPE_SET, _tmp32_, _tmp33_, _tmp34_ + 1);
#line 244 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (!_tmp35_) {
#line 1309 "rygel-gst-data-source.c"
		const gchar* _tmp36_ = NULL;
		RygelHTTPSeek* _tmp37_ = NULL;
		gint64 _tmp38_ = 0LL;
		gint64 _tmp39_ = 0LL;
		RygelHTTPSeek* _tmp40_ = NULL;
		gint64 _tmp41_ = 0LL;
		gint64 _tmp42_ = 0LL;
		const gchar* _tmp43_ = NULL;
		GError* _tmp44_ = NULL;
		GError* _tmp45_ = NULL;
#line 251 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp36_ = _ ("Failed to seek to offsets %lld:%lld");
#line 251 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp37_ = self->priv->seek;
#line 251 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp38_ = rygel_http_seek_get_start (_tmp37_);
#line 251 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp39_ = _tmp38_;
#line 251 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp40_ = self->priv->seek;
#line 251 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp41_ = rygel_http_seek_get_stop (_tmp40_);
#line 251 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp42_ = _tmp41_;
#line 251 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_warning (_tmp36_, _tmp39_, _tmp42_);
#line 255 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp43_ = _ ("Failed to seek");
#line 255 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp44_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED, _tmp43_);
#line 255 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp45_ = _tmp44_;
#line 255 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_signal_emit_by_name ((RygelDataSource*) self, "error", _tmp45_);
#line 255 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_g_error_free0 (_tmp45_);
#line 257 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		result = FALSE;
#line 257 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		return result;
#line 1350 "rygel-gst-data-source.c"
	}
#line 260 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	result = TRUE;
#line 260 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	return result;
#line 1356 "rygel-gst-data-source.c"
}


static void rygel_gst_data_source_class_init (RygelGstDataSourceClass * klass) {
#line 29 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	rygel_gst_data_source_parent_class = g_type_class_peek_parent (klass);
#line 29 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	g_type_class_add_private (klass, sizeof (RygelGstDataSourcePrivate));
#line 29 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_gst_data_source_finalize;
#line 1367 "rygel-gst-data-source.c"
}


static void rygel_gst_data_source_rygel_data_source_interface_init (RygelDataSourceIface * iface) {
#line 29 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	rygel_gst_data_source_rygel_data_source_parent_iface = g_type_interface_peek_parent (iface);
#line 29 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	iface->start = (void (*)(RygelDataSource*, RygelHTTPSeek*, GError**)) rygel_gst_data_source_real_start;
#line 29 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	iface->freeze = (void (*)(RygelDataSource*)) rygel_gst_data_source_real_freeze;
#line 29 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	iface->thaw = (void (*)(RygelDataSource*)) rygel_gst_data_source_real_thaw;
#line 29 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	iface->stop = (void (*)(RygelDataSource*)) rygel_gst_data_source_real_stop;
#line 1382 "rygel-gst-data-source.c"
}


static void rygel_gst_data_source_instance_init (RygelGstDataSource * self) {
#line 29 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self->priv = RYGEL_GST_DATA_SOURCE_GET_PRIVATE (self);
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self->priv->seek = NULL;
#line 1391 "rygel-gst-data-source.c"
}


static void rygel_gst_data_source_finalize (GObject* obj) {
	RygelGstDataSource * self;
	RygelGstSink* _tmp0_ = NULL;
	GstPipeline* _tmp3_ = NULL;
#line 29 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSource);
#line 46 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp0_ = self->priv->sink;
#line 46 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp0_ != NULL) {
#line 1405 "rygel-gst-data-source.c"
		RygelGstSink* _tmp1_ = NULL;
		GCancellable* _tmp2_ = NULL;
#line 47 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp1_ = self->priv->sink;
#line 47 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp2_ = _tmp1_->cancellable;
#line 47 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		g_cancellable_cancel (_tmp2_);
#line 1414 "rygel-gst-data-source.c"
	}
#line 50 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_tmp3_ = self->priv->pipeline;
#line 50 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	if (_tmp3_ != NULL) {
#line 1420 "rygel-gst-data-source.c"
		GstPipeline* _tmp4_ = NULL;
#line 51 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		_tmp4_ = self->priv->pipeline;
#line 51 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
		gst_element_set_state ((GstElement*) _tmp4_, GST_STATE_NULL);
#line 1426 "rygel-gst-data-source.c"
	}
#line 30 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (self->src);
#line 31 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (self->priv->pipeline);
#line 32 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (self->priv->seek);
#line 33 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	_g_object_unref0 (self->priv->sink);
#line 29 "/home/jens/Source/rygel/src/media-engines/gstreamer/rygel-gst-data-source.vala"
	G_OBJECT_CLASS (rygel_gst_data_source_parent_class)->finalize (obj);
#line 1438 "rygel-gst-data-source.c"
}


GType rygel_gst_data_source_get_type (void) {
	static volatile gsize rygel_gst_data_source_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_gst_data_source_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstDataSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_data_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstDataSource), 0, (GInstanceInitFunc) rygel_gst_data_source_instance_init, NULL };
		static const GInterfaceInfo rygel_data_source_info = { (GInterfaceInitFunc) rygel_gst_data_source_rygel_data_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_gst_data_source_type_id;
		rygel_gst_data_source_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelGstDataSource", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_gst_data_source_type_id, RYGEL_TYPE_DATA_SOURCE, &rygel_data_source_info);
		g_once_init_leave (&rygel_gst_data_source_type_id__volatile, rygel_gst_data_source_type_id);
	}
	return rygel_gst_data_source_type_id__volatile;
}



