/* rygel-media-export-database.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-media-export-database.vala, do not modify */

/*
 * Copyright (C) 2009,2011 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>


#define RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER (rygel_media_export_sqlite_wrapper_get_type ())
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapper))
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapperClass))
#define RYGEL_MEDIA_EXPORT_IS_SQLITE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER))
#define RYGEL_MEDIA_EXPORT_IS_SQLITE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER))
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapperClass))

typedef struct _RygelMediaExportSqliteWrapper RygelMediaExportSqliteWrapper;
typedef struct _RygelMediaExportSqliteWrapperClass RygelMediaExportSqliteWrapperClass;
typedef struct _RygelMediaExportSqliteWrapperPrivate RygelMediaExportSqliteWrapperPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_DATABASE (rygel_media_export_database_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabase))
#define RYGEL_MEDIA_EXPORT_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))

typedef struct _RygelMediaExportDatabase RygelMediaExportDatabase;
typedef struct _RygelMediaExportDatabaseClass RygelMediaExportDatabaseClass;
typedef struct _RygelMediaExportDatabasePrivate RygelMediaExportDatabasePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR (rygel_media_export_database_cursor_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursor))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursorClass))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursorClass))

typedef struct _RygelMediaExportDatabaseCursor RygelMediaExportDatabaseCursor;
typedef struct _RygelMediaExportDatabaseCursorClass RygelMediaExportDatabaseCursorClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
struct _RygelMediaExportSqliteWrapper {
	GObject parent_instance;
	RygelMediaExportSqliteWrapperPrivate * priv;
};

struct _RygelMediaExportSqliteWrapperClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportDatabase {
	RygelMediaExportSqliteWrapper parent_instance;
	RygelMediaExportDatabasePrivate * priv;
};

struct _RygelMediaExportDatabaseClass {
	RygelMediaExportSqliteWrapperClass parent_class;
};


static gpointer rygel_media_export_database_parent_class = NULL;

GQuark rygel_media_export_database_error_quark (void);
gint rygel_media_export_utf8_collate_str (guint8* a, int a_length1, guint8* b, int b_length1);
GType rygel_media_export_sqlite_wrapper_get_type (void) G_GNUC_CONST;
GType rygel_media_export_database_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_DUMMY_PROPERTY
};
static void rygel_media_export_database_utf8_contains (sqlite3_context* context, sqlite3_value** args, int args_length1);
static gint rygel_media_export_database_utf8_collate (gint alen, void* a, gint blen, void* b);
RygelMediaExportDatabase* rygel_media_export_database_new (const gchar* name, GError** error);
RygelMediaExportDatabase* rygel_media_export_database_construct (GType object_type, const gchar* name, GError** error);
RygelMediaExportSqliteWrapper* rygel_media_export_sqlite_wrapper_new (const gchar* path, GError** error);
RygelMediaExportSqliteWrapper* rygel_media_export_sqlite_wrapper_construct (GType object_type, const gchar* path, GError** error);
void rygel_media_export_database_exec (RygelMediaExportDatabase* self, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
sqlite3* rygel_media_export_sqlite_wrapper_get_db (RygelMediaExportSqliteWrapper* self);
static void _rygel_media_export_database_utf8_contains_sqlite_user_func_callback (sqlite3_context* context, int values_length1, sqlite3_value** values);
static gint _rygel_media_export_database_utf8_collate_sqlite_compare_callback (gpointer self, gint alen, void* a, gint blen, void* b);
GType rygel_media_export_database_cursor_get_type (void) G_GNUC_CONST;
RygelMediaExportDatabaseCursor* rygel_media_export_database_exec_cursor (RygelMediaExportDatabase* self, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
RygelMediaExportDatabaseCursor* rygel_media_export_database_cursor_new (sqlite3* db, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
RygelMediaExportDatabaseCursor* rygel_media_export_database_cursor_construct (GType object_type, sqlite3* db, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
void rygel_media_export_sqlite_wrapper_throw_if_code_is_error (RygelMediaExportSqliteWrapper* self, gint sqlite_error, GError** error);
gboolean rygel_media_export_database_cursor_has_next (RygelMediaExportDatabaseCursor* self, GError** error);
sqlite3_stmt* rygel_media_export_database_cursor_next (RygelMediaExportDatabaseCursor* self, GError** error);
gint rygel_media_export_database_query_value (RygelMediaExportDatabase* self, const gchar* sql, GValue* args, int args_length1, GError** error);
void rygel_media_export_database_analyze (RygelMediaExportDatabase* self);
void rygel_media_export_database_null (GValue* result);
void rygel_media_export_database_begin (RygelMediaExportDatabase* self, GError** error);
void rygel_media_export_database_commit (RygelMediaExportDatabase* self, GError** error);
void rygel_media_export_database_rollback (RygelMediaExportDatabase* self);


GQuark rygel_media_export_database_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_export_database_error-quark");
}


/**
     * Function to implement the custom SQL function 'contains'
     */
static void rygel_media_export_database_utf8_contains (sqlite3_context* context, sqlite3_value** args, int args_length1) {
	sqlite3_value** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gboolean _tmp1_ = FALSE;
	sqlite3_value** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	sqlite3_value* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp8_ = FALSE;
	gchar* pattern = NULL;
	sqlite3_value** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	sqlite3_value* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	sqlite3_value** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	sqlite3_value* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	g_return_if_fail (context != NULL);
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp0_ = args;
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp0__length1 = args_length1;
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	g_return_if_fail (_tmp0__length1 == 2);
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp2_ = args;
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp2__length1 = args_length1;
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp3_ = _tmp2_[0];
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp4_ = sqlite3_value_text (_tmp3_);
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	if (_tmp4_ == NULL) {
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp1_ = TRUE;
#line 178 "rygel-media-export-database.c"
	} else {
		sqlite3_value** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		sqlite3_value* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 49 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp5_ = args;
#line 49 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp5__length1 = args_length1;
#line 49 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp6_ = _tmp5_[1];
#line 49 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp7_ = sqlite3_value_text (_tmp6_);
#line 49 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp1_ = _tmp7_ == NULL;
#line 194 "rygel-media-export-database.c"
	}
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp8_ = _tmp1_;
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	if (_tmp8_) {
#line 200 "rygel-media-export-database.c"
		sqlite3_context* _tmp9_ = NULL;
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp9_ = context;
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		sqlite3_result_int (_tmp9_, 0);
#line 52 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		return;
#line 208 "rygel-media-export-database.c"
	}
#line 55 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp10_ = args;
#line 55 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp10__length1 = args_length1;
#line 55 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp11_ = _tmp10_[1];
#line 55 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp12_ = sqlite3_value_text (_tmp11_);
#line 55 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp13_ = g_regex_escape_string (_tmp12_, -1);
#line 55 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	pattern = _tmp13_;
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp14_ = pattern;
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp15_ = args;
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp15__length1 = args_length1;
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp16_ = _tmp15_[0];
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp17_ = sqlite3_value_text (_tmp16_);
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp18_ = g_regex_match_simple (_tmp14_, _tmp17_, G_REGEX_CASELESS, 0);
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	if (_tmp18_) {
#line 236 "rygel-media-export-database.c"
		sqlite3_context* _tmp19_ = NULL;
#line 59 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp19_ = context;
#line 59 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		sqlite3_result_int (_tmp19_, 1);
#line 242 "rygel-media-export-database.c"
	} else {
		sqlite3_context* _tmp20_ = NULL;
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp20_ = context;
#line 61 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		sqlite3_result_int (_tmp20_, 0);
#line 249 "rygel-media-export-database.c"
	}
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_g_free0 (pattern);
#line 253 "rygel-media-export-database.c"
}


/**
     * Function to implement the custom SQLite collation 'CASEFOLD'.
     *
     * Uses utf8 case-fold to compare the strings.
     */
static gint rygel_media_export_database_utf8_collate (gint alen, void* a, gint blen, void* b) {
	gint result = 0;
	guint8* _a = NULL;
	void* _tmp0_ = NULL;
	gint _a_length1 = 0;
	gint __a_size_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _b = NULL;
	void* _tmp3_ = NULL;
	gint _b_length1 = 0;
	gint __b_size_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp0_ = a;
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_a = (guint8*) _tmp0_;
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_a_length1 = -1;
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	__a_size_ = _a_length1;
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp1_ = alen;
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_a_length1 = _tmp1_;
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp2_ = _a_length1;
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp3_ = b;
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_b = (guint8*) _tmp3_;
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_b_length1 = -1;
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	__b_size_ = _b_length1;
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp4_ = blen;
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_b_length1 = _tmp4_;
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp5_ = _b_length1;
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp6_ = rygel_media_export_utf8_collate_str (_a, _a_length1, _b, _b_length1);
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	result = _tmp6_;
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	return result;
#line 311 "rygel-media-export-database.c"
}


/**
     * Open a database in the user's cache directory as defined by XDG
     *
     * @param name of the database, used to build full path
     * (<cache-dir>/rygel/<name>.db)
     */
static void _rygel_media_export_database_utf8_contains_sqlite_user_func_callback (sqlite3_context* context, int values_length1, sqlite3_value** values) {
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	rygel_media_export_database_utf8_contains (context, values, values_length1);
#line 324 "rygel-media-export-database.c"
}


static gint _rygel_media_export_database_utf8_collate_sqlite_compare_callback (gpointer self, gint alen, void* a, gint blen, void* b) {
	gint result;
	result = rygel_media_export_database_utf8_collate (alen, a, blen, b);
#line 116 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	return result;
#line 333 "rygel-media-export-database.c"
}


RygelMediaExportDatabase* rygel_media_export_database_construct (GType object_type, const gchar* name, GError** error) {
	RygelMediaExportDatabase * self = NULL;
	gchar* db_file = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	sqlite3* _tmp13_ = NULL;
	sqlite3* _tmp14_ = NULL;
	sqlite3* _tmp15_ = NULL;
	sqlite3* _tmp16_ = NULL;
	GError * _inner_error_ = NULL;
#line 87 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp0_ = name;
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	if (g_strcmp0 (_tmp0_, ":memory:") != 0) {
#line 354 "rygel-media-export-database.c"
		gchar* dirname = NULL;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 91 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp1_ = g_get_user_cache_dir ();
#line 91 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp2_ = g_build_filename (_tmp1_, "rygel", NULL);
#line 91 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		dirname = _tmp2_;
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp3_ = dirname;
#line 94 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		g_mkdir_with_parents (_tmp3_, 0750);
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp4_ = dirname;
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp5_ = name;
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp6_ = g_strdup_printf ("%s.db", _tmp5_);
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp7_ = _tmp6_;
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp8_ = g_build_filename (_tmp4_, _tmp7_, NULL);
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_g_free0 (db_file);
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		db_file = _tmp8_;
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_g_free0 (_tmp7_);
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_g_free0 (dirname);
#line 392 "rygel-media-export-database.c"
	} else {
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp9_ = name;
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp10_ = g_strdup (_tmp9_);
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_g_free0 (db_file);
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		db_file = _tmp10_;
#line 404 "rygel-media-export-database.c"
	}
#line 100 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp11_ = db_file;
#line 100 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	self = (RygelMediaExportDatabase*) rygel_media_export_sqlite_wrapper_construct (object_type, _tmp11_, &_inner_error_);
#line 100 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	if (_inner_error_ != NULL) {
#line 100 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 100 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_propagate_error (error, _inner_error_);
#line 100 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			_g_free0 (db_file);
#line 100 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			_g_object_unref0 (self);
#line 100 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			return NULL;
#line 422 "rygel-media-export-database.c"
		} else {
#line 100 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			_g_free0 (db_file);
#line 100 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 100 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_clear_error (&_inner_error_);
#line 100 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			return NULL;
#line 432 "rygel-media-export-database.c"
		}
	}
#line 102 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp12_ = db_file;
#line 102 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	g_debug ("rygel-media-export-database.vala:102: Using database file %s", _tmp12_);
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	rygel_media_export_database_exec (self, "PRAGMA synchronous = OFF", NULL, 0, &_inner_error_);
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	if (_inner_error_ != NULL) {
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_propagate_error (error, _inner_error_);
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			_g_free0 (db_file);
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			_g_object_unref0 (self);
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			return NULL;
#line 453 "rygel-media-export-database.c"
		} else {
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			_g_free0 (db_file);
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_clear_error (&_inner_error_);
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			return NULL;
#line 463 "rygel-media-export-database.c"
		}
	}
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	rygel_media_export_database_exec (self, "PRAGMA temp_store = MEMORY", NULL, 0, &_inner_error_);
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	if (_inner_error_ != NULL) {
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_propagate_error (error, _inner_error_);
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			_g_free0 (db_file);
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			_g_object_unref0 (self);
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			return NULL;
#line 480 "rygel-media-export-database.c"
		} else {
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			_g_free0 (db_file);
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_clear_error (&_inner_error_);
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			return NULL;
#line 490 "rygel-media-export-database.c"
		}
	}
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	rygel_media_export_database_exec (self, "PRAGMA count_changes = OFF", NULL, 0, &_inner_error_);
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	if (_inner_error_ != NULL) {
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_propagate_error (error, _inner_error_);
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			_g_free0 (db_file);
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			_g_object_unref0 (self);
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			return NULL;
#line 507 "rygel-media-export-database.c"
		} else {
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			_g_free0 (db_file);
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_clear_error (&_inner_error_);
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			return NULL;
#line 517 "rygel-media-export-database.c"
		}
	}
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp13_ = rygel_media_export_sqlite_wrapper_get_db ((RygelMediaExportSqliteWrapper*) self);
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp14_ = _tmp13_;
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	sqlite3_create_function (_tmp14_, "contains", 2, SQLITE_UTF8, NULL, _rygel_media_export_database_utf8_contains_sqlite_user_func_callback, NULL, NULL);
#line 116 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp15_ = rygel_media_export_sqlite_wrapper_get_db ((RygelMediaExportSqliteWrapper*) self);
#line 116 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp16_ = _tmp15_;
#line 116 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	sqlite3_create_collation (_tmp16_, "CASEFOLD", SQLITE_UTF8, NULL, (int (*)(void *, int,  const void *, int,  const void *)) _rygel_media_export_database_utf8_collate_sqlite_compare_callback);
#line 87 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_g_free0 (db_file);
#line 87 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	return self;
#line 536 "rygel-media-export-database.c"
}


RygelMediaExportDatabase* rygel_media_export_database_new (const gchar* name, GError** error) {
#line 87 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	return rygel_media_export_database_construct (RYGEL_MEDIA_EXPORT_TYPE_DATABASE, name, error);
#line 543 "rygel-media-export-database.c"
}


/**
     * SQL query function.
     *
     * Use for all queries that return a result set.
     *
     * @param sql The SQL query to run.
     * @param args Values to bind in the SQL query or null.
     * @throws DatabaseError if the underlying SQLite operation fails.
     */
RygelMediaExportDatabaseCursor* rygel_media_export_database_exec_cursor (RygelMediaExportDatabase* self, const gchar* sql, GValue* arguments, int arguments_length1, GError** error) {
	RygelMediaExportDatabaseCursor* result = NULL;
	RygelMediaExportDatabaseCursor* _tmp0_ = NULL;
	sqlite3* _tmp1_ = NULL;
	sqlite3* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GValue* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	g_return_val_if_fail (sql != NULL, NULL);
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp1_ = rygel_media_export_sqlite_wrapper_get_db ((RygelMediaExportSqliteWrapper*) self);
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp2_ = _tmp1_;
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp3_ = sql;
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp4_ = arguments;
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp4__length1 = arguments_length1;
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp5_ = rygel_media_export_database_cursor_new (_tmp2_, _tmp3_, _tmp4_, _tmp4__length1, &_inner_error_);
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp0_ = _tmp5_;
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	if (_inner_error_ != NULL) {
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_propagate_error (error, _inner_error_);
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			return NULL;
#line 592 "rygel-media-export-database.c"
		} else {
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_clear_error (&_inner_error_);
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			return NULL;
#line 600 "rygel-media-export-database.c"
		}
	}
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	result = _tmp0_;
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	return result;
#line 607 "rygel-media-export-database.c"
}


/**
     * Simple SQL query execution function.
     *
     * Use for all queries that don't return anything.
     *
     * @param sql The SQL query to run.
     * @param args Values to bind in the SQL query or null.
     * @throws DatabaseError if the underlying SQLite operation fails.
     */
static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback callback, void* callback_target, gchar** errmsg) {
	gchar* _vala_errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	sqlite3_callback _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	const gchar* _tmp6_ = NULL;
#line 34 "/usr/share/vala-0.22/vapi/sqlite3.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 34 "/usr/share/vala-0.22/vapi/sqlite3.vapi"
	g_return_val_if_fail (sql != NULL, 0);
#line 36 "/usr/share/vala-0.22/vapi/sqlite3.vapi"
	_tmp0_ = sql;
#line 36 "/usr/share/vala-0.22/vapi/sqlite3.vapi"
	_tmp1_ = callback;
#line 36 "/usr/share/vala-0.22/vapi/sqlite3.vapi"
	_tmp1__target = callback_target;
#line 36 "/usr/share/vala-0.22/vapi/sqlite3.vapi"
	_tmp3_ = sqlite3_exec (self, _tmp0_, _tmp1_, _tmp1__target, (char**) (&_tmp2_));
#line 36 "/usr/share/vala-0.22/vapi/sqlite3.vapi"
	sqlite_errmsg = _tmp2_;
#line 36 "/usr/share/vala-0.22/vapi/sqlite3.vapi"
	ec = _tmp3_;
#line 37 "/usr/share/vala-0.22/vapi/sqlite3.vapi"
	if ((&_vala_errmsg) != NULL) {
#line 649 "rygel-media-export-database.c"
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 38 "/usr/share/vala-0.22/vapi/sqlite3.vapi"
		_tmp4_ = sqlite_errmsg;
#line 38 "/usr/share/vala-0.22/vapi/sqlite3.vapi"
		_tmp5_ = g_strdup (_tmp4_);
#line 38 "/usr/share/vala-0.22/vapi/sqlite3.vapi"
		_g_free0 (_vala_errmsg);
#line 38 "/usr/share/vala-0.22/vapi/sqlite3.vapi"
		_vala_errmsg = _tmp5_;
#line 660 "rygel-media-export-database.c"
	}
#line 40 "/usr/share/vala-0.22/vapi/sqlite3.vapi"
	_tmp6_ = sqlite_errmsg;
#line 40 "/usr/share/vala-0.22/vapi/sqlite3.vapi"
	sqlite3_free ((void*) _tmp6_);
#line 41 "/usr/share/vala-0.22/vapi/sqlite3.vapi"
	result = ec;
#line 41 "/usr/share/vala-0.22/vapi/sqlite3.vapi"
	if (errmsg) {
#line 41 "/usr/share/vala-0.22/vapi/sqlite3.vapi"
		*errmsg = _vala_errmsg;
#line 672 "rygel-media-export-database.c"
	} else {
#line 41 "/usr/share/vala-0.22/vapi/sqlite3.vapi"
		_g_free0 (_vala_errmsg);
#line 676 "rygel-media-export-database.c"
	}
#line 41 "/usr/share/vala-0.22/vapi/sqlite3.vapi"
	return result;
#line 680 "rygel-media-export-database.c"
}


void rygel_media_export_database_exec (RygelMediaExportDatabase* self, const gchar* sql, GValue* arguments, int arguments_length1, GError** error) {
	GValue* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	RygelMediaExportDatabaseCursor* cursor = NULL;
	const gchar* _tmp5_ = NULL;
	GValue* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
#line 145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	g_return_if_fail (self != NULL);
#line 145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	g_return_if_fail (sql != NULL);
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp0_ = arguments;
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp0__length1 = arguments_length1;
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	if (_tmp0_ == NULL) {
#line 703 "rygel-media-export-database.c"
		sqlite3* _tmp1_ = NULL;
		sqlite3* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp1_ = rygel_media_export_sqlite_wrapper_get_db ((RygelMediaExportSqliteWrapper*) self);
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp2_ = _tmp1_;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp3_ = sql;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp4_ = _sqlite3_exec (_tmp2_, _tmp3_, NULL, NULL, NULL);
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		rygel_media_export_sqlite_wrapper_throw_if_code_is_error ((RygelMediaExportSqliteWrapper*) self, _tmp4_, &_inner_error_);
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		if (_inner_error_ != NULL) {
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
				g_propagate_error (error, _inner_error_);
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
				return;
#line 726 "rygel-media-export-database.c"
			} else {
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
				g_clear_error (&_inner_error_);
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
				return;
#line 734 "rygel-media-export-database.c"
			}
		}
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		return;
#line 739 "rygel-media-export-database.c"
	}
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp5_ = sql;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp6_ = arguments;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp6__length1 = arguments_length1;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp7_ = rygel_media_export_database_exec_cursor (self, _tmp5_, _tmp6_, _tmp6__length1, &_inner_error_);
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	cursor = _tmp7_;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	if (_inner_error_ != NULL) {
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_propagate_error (error, _inner_error_);
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			return;
#line 759 "rygel-media-export-database.c"
		} else {
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_clear_error (&_inner_error_);
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			return;
#line 767 "rygel-media-export-database.c"
		}
	}
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	while (TRUE) {
#line 772 "rygel-media-export-database.c"
		gboolean _tmp8_ = FALSE;
		RygelMediaExportDatabaseCursor* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		RygelMediaExportDatabaseCursor* _tmp11_ = NULL;
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp9_ = cursor;
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp10_ = rygel_media_export_database_cursor_has_next (_tmp9_, &_inner_error_);
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp8_ = _tmp10_;
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		if (_inner_error_ != NULL) {
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
				g_propagate_error (error, _inner_error_);
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
				_g_object_unref0 (cursor);
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
				return;
#line 793 "rygel-media-export-database.c"
			} else {
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
				_g_object_unref0 (cursor);
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
				g_clear_error (&_inner_error_);
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
				return;
#line 803 "rygel-media-export-database.c"
			}
		}
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		if (!_tmp8_) {
#line 155 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			break;
#line 810 "rygel-media-export-database.c"
		}
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp11_ = cursor;
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		rygel_media_export_database_cursor_next (_tmp11_, &_inner_error_);
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		if (_inner_error_ != NULL) {
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
				g_propagate_error (error, _inner_error_);
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
				_g_object_unref0 (cursor);
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
				return;
#line 826 "rygel-media-export-database.c"
			} else {
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
				_g_object_unref0 (cursor);
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
				g_clear_error (&_inner_error_);
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
				return;
#line 836 "rygel-media-export-database.c"
			}
		}
	}
#line 145 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_g_object_unref0 (cursor);
#line 842 "rygel-media-export-database.c"
}


/**
     * Execute a SQL query that returns a single number.
     *
     * @param sql The SQL query to run.
     * @param args Values to bind in the SQL query or null.
     * @return The contents of the first row's column as an int.
     * @throws DatabaseError if the underlying SQLite operation fails.
     */
gint rygel_media_export_database_query_value (RygelMediaExportDatabase* self, const gchar* sql, GValue* args, int args_length1, GError** error) {
	gint result = 0;
	RygelMediaExportDatabaseCursor* cursor = NULL;
	const gchar* _tmp0_ = NULL;
	GValue* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	RygelMediaExportDatabaseCursor* _tmp2_ = NULL;
	sqlite3_stmt* statement = NULL;
	RygelMediaExportDatabaseCursor* _tmp3_ = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	sqlite3_stmt* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GError * _inner_error_ = NULL;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp0_ = sql;
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp1_ = args;
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp1__length1 = args_length1;
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp2_ = rygel_media_export_database_exec_cursor (self, _tmp0_, _tmp1_, _tmp1__length1, &_inner_error_);
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	cursor = _tmp2_;
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	if (_inner_error_ != NULL) {
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_propagate_error (error, _inner_error_);
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			return 0;
#line 889 "rygel-media-export-database.c"
		} else {
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_clear_error (&_inner_error_);
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			return 0;
#line 897 "rygel-media-export-database.c"
		}
	}
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp3_ = cursor;
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp4_ = rygel_media_export_database_cursor_next (_tmp3_, &_inner_error_);
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	statement = _tmp4_;
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	if (_inner_error_ != NULL) {
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_propagate_error (error, _inner_error_);
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			_g_object_unref0 (cursor);
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			return 0;
#line 916 "rygel-media-export-database.c"
		} else {
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			_g_object_unref0 (cursor);
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_clear_error (&_inner_error_);
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			return 0;
#line 926 "rygel-media-export-database.c"
		}
	}
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp5_ = statement;
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp6_ = sqlite3_column_int (_tmp5_, 0);
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	result = _tmp6_;
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_g_object_unref0 (cursor);
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	return result;
#line 939 "rygel-media-export-database.c"
}


/**
     * Analyze triggers of database
     */
void rygel_media_export_database_analyze (RygelMediaExportDatabase* self) {
	sqlite3* _tmp0_ = NULL;
	sqlite3* _tmp1_ = NULL;
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	g_return_if_fail (self != NULL);
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp0_ = rygel_media_export_sqlite_wrapper_get_db ((RygelMediaExportSqliteWrapper*) self);
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_tmp1_ = _tmp0_;
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	_sqlite3_exec (_tmp1_, "ANALYZE", NULL, NULL, NULL);
#line 957 "rygel-media-export-database.c"
}


/**
     * Special GValue to pass to exec or exec_cursor to bind a column to
     * NULL
     */
void rygel_media_export_database_null (GValue* result) {
	GValue v = {0};
	GValue _tmp0_ = {0};
#line 188 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	g_value_init (&_tmp0_, G_TYPE_POINTER);
#line 188 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	v = _tmp0_;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	g_value_set_pointer (&v, NULL);
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	*result = v;
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	return;
#line 978 "rygel-media-export-database.c"
}


/**
     * Start a transaction
     */
void rygel_media_export_database_begin (RygelMediaExportDatabase* self, GError** error) {
	GError * _inner_error_ = NULL;
#line 197 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	g_return_if_fail (self != NULL);
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	rygel_media_export_database_exec (self, "BEGIN", NULL, 0, &_inner_error_);
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	if (_inner_error_ != NULL) {
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_propagate_error (error, _inner_error_);
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			return;
#line 999 "rygel-media-export-database.c"
		} else {
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_clear_error (&_inner_error_);
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			return;
#line 1007 "rygel-media-export-database.c"
		}
	}
}


/**
     * Commit a transaction
     */
void rygel_media_export_database_commit (RygelMediaExportDatabase* self, GError** error) {
	GError * _inner_error_ = NULL;
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	g_return_if_fail (self != NULL);
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	rygel_media_export_database_exec (self, "COMMIT", NULL, 0, &_inner_error_);
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	if (_inner_error_ != NULL) {
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_propagate_error (error, _inner_error_);
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			return;
#line 1030 "rygel-media-export-database.c"
		} else {
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_clear_error (&_inner_error_);
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			return;
#line 1038 "rygel-media-export-database.c"
		}
	}
}


/**
     * Rollback a transaction
     */
void rygel_media_export_database_rollback (RygelMediaExportDatabase* self) {
	GError * _inner_error_ = NULL;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	g_return_if_fail (self != NULL);
#line 1051 "rygel-media-export-database.c"
	{
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		rygel_media_export_database_exec (self, "ROLLBACK", NULL, 0, &_inner_error_);
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		if (_inner_error_ != NULL) {
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 1059 "rygel-media-export-database.c"
				goto __catch2_rygel_media_export_database_error;
			}
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			g_clear_error (&_inner_error_);
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
			return;
#line 1068 "rygel-media-export-database.c"
		}
	}
	goto __finally2;
	__catch2_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp0_ = NULL;
		GError* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_error_ = _inner_error_;
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_inner_error_ = NULL;
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp0_ = _ ("Failed to roll back transaction: %s");
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp1_ = _error_;
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_tmp2_ = _tmp1_->message;
#line 215 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		g_critical (_tmp0_, _tmp2_);
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		_g_error_free0 (_error_);
#line 1092 "rygel-media-export-database.c"
	}
	__finally2:
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	if (_inner_error_ != NULL) {
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		g_clear_error (&_inner_error_);
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
		return;
#line 1103 "rygel-media-export-database.c"
	}
}


static void rygel_media_export_database_class_init (RygelMediaExportDatabaseClass * klass) {
#line 40 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-database.vala"
	rygel_media_export_database_parent_class = g_type_class_peek_parent (klass);
#line 1111 "rygel-media-export-database.c"
}


static void rygel_media_export_database_instance_init (RygelMediaExportDatabase * self) {
}


/**
 * This class is a thin wrapper around SQLite's database object.
 *
 * It adds statement preparation based on GValue and a cancellable exec
 * function.
 */
GType rygel_media_export_database_get_type (void) {
	static volatile gsize rygel_media_export_database_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_database_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportDatabase), 0, (GInstanceInitFunc) rygel_media_export_database_instance_init, NULL };
		GType rygel_media_export_database_type_id;
		rygel_media_export_database_type_id = g_type_register_static (RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, "RygelMediaExportDatabase", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_database_type_id__volatile, rygel_media_export_database_type_id);
	}
	return rygel_media_export_database_type_id__volatile;
}



