/* rygel-media-export-harvester.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-media-export-harvester.vala, do not modify */

/*
 * Copyright (C) 2010 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-server.h>
#include <rygel-core.h>
#include <glib/gi18n-lib.h>


#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTER (rygel_media_export_harvester_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester))
#define RYGEL_MEDIA_EXPORT_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))

typedef struct _RygelMediaExportHarvester RygelMediaExportHarvester;
typedef struct _RygelMediaExportHarvesterClass RygelMediaExportHarvesterClass;
typedef struct _RygelMediaExportHarvesterPrivate RygelMediaExportHarvesterPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK (rygel_media_export_harvesting_task_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))

typedef struct _RygelMediaExportHarvestingTask RygelMediaExportHarvestingTask;
typedef struct _RygelMediaExportHarvestingTaskClass RygelMediaExportHarvestingTaskClass;

#define RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR (rygel_media_export_recursive_file_monitor_get_type ())
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitor))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))

typedef struct _RygelMediaExportRecursiveFileMonitor RygelMediaExportRecursiveFileMonitor;
typedef struct _RygelMediaExportRecursiveFileMonitorClass RygelMediaExportRecursiveFileMonitorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaExportHarvestingTaskPrivate RygelMediaExportHarvestingTaskPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;
typedef struct _Block4Data Block4Data;

struct _RygelMediaExportHarvester {
	GObject parent_instance;
	RygelMediaExportHarvesterPrivate * priv;
};

struct _RygelMediaExportHarvesterClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportHarvesterPrivate {
	GeeHashMap* tasks;
	GeeHashMap* extraction_grace_timers;
	RygelMediaExportRecursiveFileMonitor* monitor;
	GCancellable* cancellable;
	GeeArrayList* _locations;
};

struct _RygelMediaExportHarvestingTask {
	GObject parent_instance;
	RygelMediaExportHarvestingTaskPrivate * priv;
	GFile* origin;
};

struct _RygelMediaExportHarvestingTaskClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
struct _Block4Data {
	int _ref_count_;
	RygelMediaExportHarvester * self;
	GFile* file;
};


static gpointer rygel_media_export_harvester_parent_class = NULL;

GType rygel_media_export_harvester_get_type (void) G_GNUC_CONST;
GType rygel_media_export_harvesting_task_get_type (void) G_GNUC_CONST;
GType rygel_media_export_recursive_file_monitor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_HARVESTER_DUMMY_PROPERTY,
	RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS
};
#define RYGEL_MEDIA_EXPORT_HARVESTER_FILE_CHANGE_DEFAULT_GRACE_PERIOD ((guint) 5)
RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable, GeeArrayList* locations);
RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, GCancellable* cancellable, GeeArrayList* locations);
static void rygel_media_export_harvester_set_locations (RygelMediaExportHarvester* self, GeeArrayList* value);
GeeArrayList* rygel_media_export_harvester_get_locations (RygelMediaExportHarvester* self);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_new (GCancellable* cancellable);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_construct (GType object_type, GCancellable* cancellable);
static void rygel_media_export_harvester_on_file_changed (RygelMediaExportHarvester* self, GFile* file, GFile* other, GFileMonitorEvent event);
static void _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
gboolean rygel_media_export_harvester_is_eligible (GFileInfo* info);
void rygel_media_export_harvester_schedule_locations (RygelMediaExportHarvester* self, RygelMediaContainer* parent);
void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self, GFile* file, RygelMediaContainer* parent);
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self, GFile* file);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_new (RygelMediaExportRecursiveFileMonitor* monitor, GFile* file, RygelMediaContainer* parent);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_construct (GType object_type, RygelMediaExportRecursiveFileMonitor* monitor, GFile* file, RygelMediaContainer* parent);
static void rygel_media_export_harvester_on_file_harvested (RygelMediaExportHarvester* self, RygelStateMachine* state_machine);
static void _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
void rygel_media_export_harvesting_task_cancel (RygelMediaExportHarvestingTask* self);
static void rygel_media_export_harvester_on_changes_done (RygelMediaExportHarvester* self, GFile* file, GError** error);
static void rygel_media_export_harvester_on_file_removed (RygelMediaExportHarvester* self, GFile* file);
static void rygel_media_export_harvester_on_file_added (RygelMediaExportHarvester* self, GFile* file);
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (void);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
GQuark rygel_media_export_database_error_quark (void);
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const gchar* object_id, GError** error);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean __lambda3_ (Block4Data* _data4_);
static gboolean ___lambda3__gsource_func (gpointer self);
static void rygel_media_export_harvester_finalize (GObject* obj);
static void _vala_rygel_media_export_harvester_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_export_harvester_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Create a new instance of the meta-data extraction manager.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return self ? g_object_ref (self) : NULL;
#line 172 "rygel-media-export-harvester.c"
}


static void _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_on_file_changed (self, file, other_file, event_type);
#line 179 "rygel-media-export-harvester.c"
}


RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, GCancellable* cancellable, GeeArrayList* locations) {
	RygelMediaExportHarvester * self = NULL;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GCancellable* _tmp19_ = NULL;
	RygelMediaExportRecursiveFileMonitor* _tmp20_ = NULL;
	RygelMediaExportRecursiveFileMonitor* _tmp21_ = NULL;
	GeeHashMap* _tmp22_ = NULL;
	GeeHashMap* _tmp23_ = NULL;
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_val_if_fail (cancellable != NULL, NULL);
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_val_if_fail (locations != NULL, NULL);
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self = (RygelMediaExportHarvester*) g_object_new (object_type, NULL);
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = cancellable;
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv->cancellable = _tmp1_;
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = gee_array_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeEqualDataFunc) g_file_equal, NULL, NULL);
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp3_ = _tmp2_;
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_set_locations (self, _tmp3_);
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (_tmp3_);
#line 216 "rygel-media-export-harvester.c"
	{
		GeeArrayList* _file_list = NULL;
		GeeArrayList* _tmp4_ = NULL;
		GeeArrayList* _tmp5_ = NULL;
		gint _file_size = 0;
		GeeArrayList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _file_index = 0;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp4_ = locations;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_file_list = _tmp5_;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp6_ = _file_list;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp8_ = _tmp7_;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_file_size = _tmp8_;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_file_index = -1;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		while (TRUE) {
#line 244 "rygel-media-export-harvester.c"
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			GFile* file = NULL;
			GeeArrayList* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gpointer _tmp14_ = NULL;
			GFile* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp9_ = _file_index;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_file_index = _tmp9_ + 1;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp10_ = _file_index;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp11_ = _file_size;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			if (!(_tmp10_ < _tmp11_)) {
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				break;
#line 266 "rygel-media-export-harvester.c"
			}
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp12_ = _file_list;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp13_ = _file_index;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			file = (GFile*) _tmp14_;
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp15_ = file;
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp16_ = g_file_query_exists (_tmp15_, NULL);
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			if (_tmp16_) {
#line 282 "rygel-media-export-harvester.c"
				GeeArrayList* _tmp17_ = NULL;
				GFile* _tmp18_ = NULL;
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp17_ = self->priv->_locations;
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp18_ = file;
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
#line 291 "rygel-media-export-harvester.c"
			}
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_object_unref0 (file);
#line 295 "rygel-media-export-harvester.c"
		}
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (_file_list);
#line 299 "rygel-media-export-harvester.c"
	}
#line 52 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp19_ = cancellable;
#line 52 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp20_ = rygel_media_export_recursive_file_monitor_new (_tmp19_);
#line 52 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->monitor);
#line 52 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv->monitor = _tmp20_;
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp21_ = self->priv->monitor;
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_signal_connect_object (_tmp21_, "changed", (GCallback) _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed, self, 0);
#line 55 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp22_ = gee_hash_map_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeHashDataFunc) g_file_hash, NULL, NULL, (GeeEqualDataFunc) g_file_equal, NULL, NULL, NULL, NULL, NULL);
#line 55 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->tasks);
#line 55 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv->tasks = _tmp22_;
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp23_ = gee_hash_map_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, G_TYPE_UINT, NULL, NULL, (GeeHashDataFunc) g_file_hash, NULL, NULL, (GeeEqualDataFunc) g_file_equal, NULL, NULL, NULL, NULL, NULL);
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->extraction_grace_timers);
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv->extraction_grace_timers = _tmp23_;
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return self;
#line 327 "rygel-media-export-harvester.c"
}


RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable, GeeArrayList* locations) {
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return rygel_media_export_harvester_construct (RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, cancellable, locations);
#line 334 "rygel-media-export-harvester.c"
}


/**
     * Check if a FileInfo is considered for extraction
     *
     * @param info a FileInfo
     * @return true if file should be extracted, false otherwise
     */
gboolean rygel_media_export_harvester_is_eligible (GFileInfo* info) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GFileInfo* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp28_ = FALSE;
#line 69 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_val_if_fail (info != NULL, FALSE);
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp6_ = info;
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp7_ = g_file_info_get_content_type (_tmp6_);
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp8_ = g_str_has_prefix (_tmp7_, "image/");
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp8_) {
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp5_ = TRUE;
#line 373 "rygel-media-export-harvester.c"
	} else {
		GFileInfo* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp9_ = info;
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp10_ = g_file_info_get_content_type (_tmp9_);
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp11_ = g_str_has_prefix (_tmp10_, "video/");
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp5_ = _tmp11_;
#line 386 "rygel-media-export-harvester.c"
	}
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp12_ = _tmp5_;
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp12_) {
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp4_ = TRUE;
#line 394 "rygel-media-export-harvester.c"
	} else {
		GFileInfo* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp13_ = info;
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp14_ = g_file_info_get_content_type (_tmp13_);
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp15_ = g_str_has_prefix (_tmp14_, "audio/");
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp4_ = _tmp15_;
#line 407 "rygel-media-export-harvester.c"
	}
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp16_ = _tmp4_;
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp16_) {
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp3_ = TRUE;
#line 415 "rygel-media-export-harvester.c"
	} else {
		GFileInfo* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp17_ = info;
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp18_ = g_file_info_get_content_type (_tmp17_);
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp3_ = g_strcmp0 (_tmp18_, "application/ogg") == 0;
#line 425 "rygel-media-export-harvester.c"
	}
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp19_ = _tmp3_;
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp19_) {
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp2_ = TRUE;
#line 433 "rygel-media-export-harvester.c"
	} else {
		GFileInfo* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp20_ = info;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp21_ = g_file_info_get_content_type (_tmp20_);
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp2_ = g_strcmp0 (_tmp21_, "application/xml") == 0;
#line 443 "rygel-media-export-harvester.c"
	}
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp22_ = _tmp2_;
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp22_) {
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp1_ = TRUE;
#line 451 "rygel-media-export-harvester.c"
	} else {
		GFileInfo* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp23_ = info;
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp24_ = g_file_info_get_content_type (_tmp23_);
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp1_ = g_strcmp0 (_tmp24_, "text/xml") == 0;
#line 461 "rygel-media-export-harvester.c"
	}
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp25_ = _tmp1_;
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp25_) {
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp0_ = TRUE;
#line 469 "rygel-media-export-harvester.c"
	} else {
		GFileInfo* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp26_ = info;
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp27_ = g_file_info_get_content_type (_tmp26_);
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp0_ = g_strcmp0 (_tmp27_, "text/plain") == 0;
#line 479 "rygel-media-export-harvester.c"
	}
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp28_ = _tmp0_;
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	result = _tmp28_;
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return result;
#line 487 "rygel-media-export-harvester.c"
}


/**
     * Schedule rescan of all top-level locations known to the harvester.
     *
     * @param parent top-level container of the files
     */
void rygel_media_export_harvester_schedule_locations (RygelMediaExportHarvester* self, RygelMediaContainer* parent) {
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (parent != NULL);
#line 501 "rygel-media-export-harvester.c"
	{
		GeeArrayList* _file_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _file_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _file_index = 0;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp0_ = self->priv->_locations;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_file_list = _tmp1_;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp2_ = _file_list;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp4_ = _tmp3_;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_file_size = _tmp4_;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_file_index = -1;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		while (TRUE) {
#line 529 "rygel-media-export-harvester.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			GFile* file = NULL;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			GFile* _tmp11_ = NULL;
			RygelMediaContainer* _tmp12_ = NULL;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp5_ = _file_index;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_file_index = _tmp5_ + 1;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp6_ = _file_index;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp7_ = _file_size;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				break;
#line 551 "rygel-media-export-harvester.c"
			}
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp8_ = _file_list;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp9_ = _file_index;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			file = (GFile*) _tmp10_;
#line 86 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp11_ = file;
#line 86 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp12_ = parent;
#line 86 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			rygel_media_export_harvester_schedule (self, _tmp11_, _tmp12_);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_object_unref0 (file);
#line 569 "rygel-media-export-harvester.c"
		}
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (_file_list);
#line 573 "rygel-media-export-harvester.c"
	}
}


/**
     * Put a file on queue for meta-data extraction
     *
     * @param file the file to investigate
     * @param parent container of the filer to be harvested
     */
static void _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_on_file_harvested (self, _sender);
#line 587 "rygel-media-export-harvester.c"
}


void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self, GFile* file, RygelMediaContainer* parent) {
	GeeHashMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	RygelMediaExportHarvestingTask* task = NULL;
	RygelMediaExportRecursiveFileMonitor* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	RygelMediaContainer* _tmp5_ = NULL;
	RygelMediaExportHarvestingTask* _tmp6_ = NULL;
	GCancellable* _tmp7_ = NULL;
	GeeHashMap* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (parent != NULL);
#line 98 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = self->priv->extraction_grace_timers;
#line 98 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = file;
#line 98 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, _tmp1_, NULL);
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = file;
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_cancel (self, _tmp2_);
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp3_ = self->priv->monitor;
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp4_ = file;
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp5_ = parent;
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp6_ = rygel_media_export_harvesting_task_new (_tmp3_, _tmp4_, _tmp5_);
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	task = _tmp6_;
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp7_ = self->priv->cancellable;
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) task, _tmp7_);
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_signal_connect_object ((RygelStateMachine*) task, "completed", (GCallback) _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed, self, 0);
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp8_ = self->priv->tasks;
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp9_ = file;
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp9_, task);
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_state_machine_run ((RygelStateMachine*) task, NULL, NULL);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (task);
#line 645 "rygel-media-export-harvester.c"
}


/**
     * Cancel a running meta-data extraction run
     *
     * @param file file cancel the current run for
     */
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self, GFile* file) {
	GeeHashMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = self->priv->tasks;
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = file;
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp2_) {
#line 670 "rygel-media-export-harvester.c"
		RygelMediaExportHarvestingTask* task = NULL;
		GeeHashMap* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		RygelMediaExportHarvestingTask* _tmp6_ = NULL;
		guint _tmp7_ = 0U;
		GeeHashMap* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
		RygelMediaExportHarvestingTask* _tmp10_ = NULL;
#line 119 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp3_ = self->priv->tasks;
#line 119 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp4_ = file;
#line 119 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
#line 119 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		task = (RygelMediaExportHarvestingTask*) _tmp5_;
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp6_ = task;
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_signal_parse_name ("completed", RYGEL_TYPE_STATE_MACHINE, &_tmp7_, NULL, FALSE);
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_signal_handlers_disconnect_matched ((RygelStateMachine*) _tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed, self);
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp8_ = self->priv->tasks;
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp9_ = file;
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp8_, _tmp9_, NULL);
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp10_ = task;
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		rygel_media_export_harvesting_task_cancel (_tmp10_);
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (task);
#line 706 "rygel-media-export-harvester.c"
	}
}


/**
     * Callback for finished harvester.
     *
     * Updates book-keeping hash.
     * @param state_machine HarvestingTask sending the event
     */
static void rygel_media_export_harvester_on_file_harvested (RygelMediaExportHarvester* self, RygelStateMachine* state_machine) {
	RygelMediaExportHarvestingTask* task = NULL;
	RygelStateMachine* _tmp0_ = NULL;
	RygelMediaExportHarvestingTask* _tmp1_ = NULL;
	GFile* file = NULL;
	RygelMediaExportHarvestingTask* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GeeHashMap* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	GeeHashMap* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (state_machine != NULL);
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = state_machine;
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK) ? ((RygelMediaExportHarvestingTask*) _tmp0_) : NULL);
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	task = _tmp1_;
#line 134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = task;
#line 134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp3_ = _tmp2_->origin;
#line 134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	file = _tmp4_;
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp5_ = _ ("'%s' harvested");
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp6_ = file;
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp7_ = g_file_get_uri (_tmp6_);
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp8_ = _tmp7_;
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_message (_tmp5_, _tmp8_);
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_free0 (_tmp8_);
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp9_ = self->priv->tasks;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp10_ = file;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp9_, _tmp10_, NULL);
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp11_ = self->priv->tasks;
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp12_ = gee_map_get_is_empty ((GeeMap*) _tmp11_);
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp13_ = _tmp12_;
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp13_) {
#line 139 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_signal_emit_by_name (self, "done");
#line 780 "rygel-media-export-harvester.c"
	}
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (file);
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (task);
#line 786 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_on_file_changed (RygelMediaExportHarvester* self, GFile* file, GFile* other, GFileMonitorEvent event) {
	GError * _inner_error_ = NULL;
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 796 "rygel-media-export-harvester.c"
	{
		GFileMonitorEvent _tmp0_ = 0;
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp0_ = event;
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		switch (_tmp0_) {
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			case G_FILE_MONITOR_EVENT_CREATED:
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
#line 807 "rygel-media-export-harvester.c"
			{
				GFile* _tmp1_ = NULL;
#line 150 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp1_ = file;
#line 150 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				rygel_media_export_harvester_on_changes_done (self, _tmp1_, &_inner_error_);
#line 150 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				if (_inner_error_ != NULL) {
#line 816 "rygel-media-export-harvester.c"
					goto __catch59_g_error;
				}
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				break;
#line 821 "rygel-media-export-harvester.c"
			}
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			case G_FILE_MONITOR_EVENT_DELETED:
#line 825 "rygel-media-export-harvester.c"
			{
				GFile* _tmp2_ = NULL;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp2_ = file;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				rygel_media_export_harvester_on_file_removed (self, _tmp2_);
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				break;
#line 834 "rygel-media-export-harvester.c"
			}
			default:
			{
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				break;
#line 840 "rygel-media-export-harvester.c"
			}
		}
	}
	goto __finally59;
	__catch59_g_error:
	{
		GError* _error_ = NULL;
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_error_ = _inner_error_;
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_inner_error_ = NULL;
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_error_free0 (_error_);
#line 854 "rygel-media-export-harvester.c"
	}
	__finally59:
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_inner_error_ != NULL) {
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_clear_error (&_inner_error_);
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		return;
#line 865 "rygel-media-export-harvester.c"
	}
}


static void rygel_media_export_harvester_on_file_added (RygelMediaExportHarvester* self, GFile* file) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 161 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 161 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = file;
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = g_file_get_uri (_tmp0_);
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = _tmp1_;
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_debug ("rygel-media-export-harvester.vala:162: Filesystem events settled for %" \
"s, scheduling extraction…", _tmp2_);
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_free0 (_tmp2_);
#line 889 "rygel-media-export-harvester.c"
	{
		RygelMediaExportMediaCache* cache = NULL;
		RygelMediaExportMediaCache* _tmp3_ = NULL;
		GFileInfo* info = NULL;
		GFile* _tmp4_ = NULL;
		GCancellable* _tmp5_ = NULL;
		GFileInfo* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		GFileType _tmp8_ = 0;
		gboolean _tmp10_ = FALSE;
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp3_ = rygel_media_export_media_cache_get_default ();
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		cache = _tmp3_;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp4_ = file;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp5_ = self->priv->cancellable;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp6_ = g_file_query_info (_tmp4_, G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, _tmp5_, &_inner_error_);
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		info = _tmp6_;
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_inner_error_ != NULL) {
#line 166 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_object_unref0 (cache);
#line 916 "rygel-media-export-harvester.c"
			goto __catch60_g_error;
		}
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp8_ = g_file_info_get_file_type (info);
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_tmp8_ == G_FILE_TYPE_DIRECTORY) {
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp7_ = TRUE;
#line 925 "rygel-media-export-harvester.c"
		} else {
			gboolean _tmp9_ = FALSE;
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp9_ = rygel_media_export_harvester_is_eligible (info);
#line 171 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp7_ = _tmp9_;
#line 932 "rygel-media-export-harvester.c"
		}
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp10_ = _tmp7_;
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_tmp10_) {
#line 938 "rygel-media-export-harvester.c"
			gchar* id = NULL;
			GFile* _tmp11_ = NULL;
			GFile* _tmp12_ = NULL;
			GFile* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp11_ = file;
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp12_ = g_file_get_parent (_tmp11_);
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp13_ = _tmp12_;
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp14_ = rygel_media_export_media_cache_get_id (_tmp13_);
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp15_ = _tmp14_;
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_object_unref0 (_tmp13_);
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			id = _tmp15_;
#line 959 "rygel-media-export-harvester.c"
			{
				RygelMediaObject* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				RygelMediaObject* _tmp18_ = NULL;
				RygelMediaContainer* parent_container = NULL;
				RygelMediaContainer* _tmp19_ = NULL;
				GFile* _tmp20_ = NULL;
				RygelMediaContainer* _tmp21_ = NULL;
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp17_ = id;
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp18_ = rygel_media_export_media_cache_get_object (cache, _tmp17_, &_inner_error_);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp16_ = _tmp18_;
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				if (_inner_error_ != NULL) {
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 978 "rygel-media-export-harvester.c"
						goto __catch61_rygel_media_export_database_error;
					}
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_g_free0 (id);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_g_object_unref0 (info);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_g_object_unref0 (cache);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					g_clear_error (&_inner_error_);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					return;
#line 993 "rygel-media-export-harvester.c"
				}
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp19_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp16_) : NULL;
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				if (_tmp19_ == NULL) {
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_g_object_unref0 (_tmp16_);
#line 1001 "rygel-media-export-harvester.c"
				}
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				parent_container = _tmp19_;
#line 176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp20_ = file;
#line 176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp21_ = parent_container;
#line 176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				rygel_media_export_harvester_schedule (self, _tmp20_, _tmp21_);
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_object_unref0 (parent_container);
#line 1013 "rygel-media-export-harvester.c"
			}
			goto __finally61;
			__catch61_rygel_media_export_database_error:
			{
				GError* _error_ = NULL;
				const gchar* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				GError* _tmp24_ = NULL;
				const gchar* _tmp25_ = NULL;
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_error_ = _inner_error_;
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_inner_error_ = NULL;
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp22_ = _ ("Error fetching object '%s' from database: %s");
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp23_ = id;
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp24_ = _error_;
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp25_ = _tmp24_->message;
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				g_warning (_tmp22_, _tmp23_, _tmp25_);
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_error_free0 (_error_);
#line 1039 "rygel-media-export-harvester.c"
			}
			__finally61:
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			if (_inner_error_ != NULL) {
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_free0 (id);
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_object_unref0 (info);
#line 173 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_object_unref0 (cache);
#line 1050 "rygel-media-export-harvester.c"
				goto __catch60_g_error;
			}
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_free0 (id);
#line 1055 "rygel-media-export-harvester.c"
		} else {
			GFile* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
#line 183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp26_ = file;
#line 183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp27_ = g_file_get_uri (_tmp26_);
#line 183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp28_ = _tmp27_;
#line 183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			g_debug ("rygel-media-export-harvester.vala:183: %s is not eligible for extracti" \
"on", _tmp28_);
#line 183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_free0 (_tmp28_);
#line 1070 "rygel-media-export-harvester.c"
		}
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (info);
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (cache);
#line 1076 "rygel-media-export-harvester.c"
	}
	goto __finally60;
	__catch60_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp29_ = NULL;
		GFile* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		GError* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_error_ = _inner_error_;
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_inner_error_ = NULL;
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp29_ = _ ("Failed to query info of a file %s: %s");
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp30_ = file;
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp31_ = g_file_get_uri (_tmp30_);
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp32_ = _tmp31_;
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp33_ = _error_;
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp34_ = _tmp33_->message;
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_warning (_tmp29_, _tmp32_, _tmp34_);
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_free0 (_tmp32_);
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_error_free0 (_error_);
#line 1110 "rygel-media-export-harvester.c"
	}
	__finally60:
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_inner_error_ != NULL) {
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_clear_error (&_inner_error_);
#line 164 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		return;
#line 1121 "rygel-media-export-harvester.c"
	}
}


static void rygel_media_export_harvester_on_file_removed (RygelMediaExportHarvester* self, GFile* file) {
	RygelMediaExportMediaCache* cache = NULL;
	RygelMediaExportMediaCache* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 193 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = rygel_media_export_media_cache_get_default ();
#line 193 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	cache = _tmp0_;
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = self->priv->extraction_grace_timers;
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = file;
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _tmp2_);
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp3_) {
#line 1150 "rygel-media-export-harvester.c"
		GeeHashMap* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		gpointer _tmp6_ = NULL;
		GeeHashMap* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp4_ = self->priv->extraction_grace_timers;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp5_ = file;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_source_remove ((guint) ((guintptr) _tmp6_));
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp7_ = self->priv->extraction_grace_timers;
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp8_ = file;
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp7_, _tmp8_, NULL);
#line 1170 "rygel-media-export-harvester.c"
	}
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp9_ = file;
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_cancel (self, _tmp9_);
#line 1176 "rygel-media-export-harvester.c"
	{
		gchar* id = NULL;
		GFile* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		RygelMediaObject* object = NULL;
		RygelMediaExportMediaCache* _tmp12_ = NULL;
		RygelMediaObject* _tmp13_ = NULL;
		RygelMediaContainer* parent = NULL;
		gpointer _tmp14_ = NULL;
		RygelMediaContainer* _tmp15_ = NULL;
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp10_ = file;
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp11_ = rygel_media_export_media_cache_get_id (_tmp10_);
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		id = _tmp11_;
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp12_ = cache;
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp13_ = rygel_media_export_media_cache_get_object (_tmp12_, id, &_inner_error_);
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		object = _tmp13_;
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_inner_error_ != NULL) {
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_free0 (id);
#line 1203 "rygel-media-export-harvester.c"
			goto __catch62_g_error;
		}
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp14_ = NULL;
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp14_) : NULL);
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		parent = _tmp15_;
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (object != NULL) {
#line 1214 "rygel-media-export-harvester.c"
			RygelMediaContainer* _tmp16_ = NULL;
			RygelMediaContainer* _tmp17_ = NULL;
			RygelMediaContainer* _tmp18_ = NULL;
			RygelMediaContainer* _tmp19_ = NULL;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp16_ = rygel_media_object_get_parent (object);
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp17_ = _tmp16_;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp18_ = _g_object_ref0 (_tmp17_);
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_object_unref0 (parent);
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			parent = _tmp18_;
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp19_ = parent;
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
#line 1233 "rygel-media-export-harvester.c"
				RygelTrackableContainer* container = NULL;
				RygelMediaContainer* _tmp20_ = NULL;
				RygelTrackableContainer* _tmp21_ = NULL;
				RygelTrackableContainer* _tmp22_ = NULL;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp20_ = parent;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, RYGEL_TYPE_TRACKABLE_CONTAINER) ? ((RygelTrackableContainer*) _tmp20_) : NULL);
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				container = _tmp21_;
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp22_ = container;
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				rygel_trackable_container_remove_child_tracked (_tmp22_, object, NULL, NULL);
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_object_unref0 (container);
#line 1250 "rygel-media-export-harvester.c"
			}
		}
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (parent);
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (object);
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_free0 (id);
#line 1259 "rygel-media-export-harvester.c"
	}
	goto __finally62;
	__catch62_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp23_ = NULL;
		GError* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_error_ = _inner_error_;
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_inner_error_ = NULL;
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp23_ = _ ("Error removing object from database: %s");
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp24_ = _error_;
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp25_ = _tmp24_->message;
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_warning (_tmp23_, _tmp25_);
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_error_free0 (_error_);
#line 1282 "rygel-media-export-harvester.c"
	}
	__finally62:
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_inner_error_ != NULL) {
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (cache);
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_clear_error (&_inner_error_);
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		return;
#line 1295 "rygel-media-export-harvester.c"
	}
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (cache);
#line 1299 "rygel-media-export-harvester.c"
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return _data4_;
#line 1308 "rygel-media-export-harvester.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 1317 "rygel-media-export-harvester.c"
		RygelMediaExportHarvester * self;
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		self = _data4_->self;
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (_data4_->file);
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (self);
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_slice_free (Block4Data, _data4_);
#line 1327 "rygel-media-export-harvester.c"
	}
}


static gboolean __lambda3_ (Block4Data* _data4_) {
	RygelMediaExportHarvester * self;
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
#line 233 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self = _data4_->self;
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = _data4_->file;
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_on_file_added (self, _tmp0_);
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	result = FALSE;
#line 236 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return result;
#line 1346 "rygel-media-export-harvester.c"
}


static gboolean ___lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda3_ (self);
#line 233 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return result;
#line 1355 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_on_changes_done (RygelMediaExportHarvester* self, GFile* file, GError** error) {
	Block4Data* _data4_;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GeeHashMap* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GSourceFunc callback = NULL;
	void* callback_target = NULL;
	GDestroyNotify callback_target_destroy_notify = NULL;
	guint timeout = 0U;
	GSourceFunc _tmp16_ = NULL;
	void* _tmp16__target = NULL;
	GDestroyNotify _tmp16__target_destroy_notify = NULL;
	guint _tmp17_ = 0U;
	GeeHashMap* _tmp18_ = NULL;
	GFile* _tmp19_ = NULL;
	guint _tmp20_ = 0U;
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_data4_->_ref_count_ = 1;
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_data4_->self = g_object_ref (self);
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = file;
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (_data4_->file);
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_data4_->file = _tmp1_;
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = _data4_->file;
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp3_ = g_file_get_basename (_tmp2_);
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp4_ = _tmp3_;
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp5_ = g_str_has_prefix (_tmp4_, ".");
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp6_ = _tmp5_;
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_free0 (_tmp4_);
#line 222 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp6_) {
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		block4_data_unref (_data4_);
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_data4_ = NULL;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		return;
#line 1420 "rygel-media-export-harvester.c"
	}
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp7_ = self->priv->extraction_grace_timers;
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp8_ = _data4_->file;
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp9_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp7_, _tmp8_);
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp9_) {
#line 1430 "rygel-media-export-harvester.c"
		GeeHashMap* _tmp10_ = NULL;
		GFile* _tmp11_ = NULL;
		gpointer _tmp12_ = NULL;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp10_ = self->priv->extraction_grace_timers;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp11_ = _data4_->file;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, _tmp11_);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_source_remove ((guint) ((guintptr) _tmp12_));
#line 1442 "rygel-media-export-harvester.c"
	} else {
		GFile* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp13_ = _data4_->file;
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp14_ = g_file_get_uri (_tmp13_);
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp15_ = _tmp14_;
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_debug ("rygel-media-export-harvester.vala:229: Starting grace timer for harves" \
"ting %s…", _tmp15_);
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_free0 (_tmp15_);
#line 1457 "rygel-media-export-harvester.c"
	}
#line 233 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback = ___lambda3__gsource_func;
#line 233 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback_target = block4_data_ref (_data4_);
#line 233 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback_target_destroy_notify = block4_data_unref;
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp16_ = callback;
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp16__target = callback_target;
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp16__target_destroy_notify = callback_target_destroy_notify;
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback_target_destroy_notify = NULL;
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp17_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, RYGEL_MEDIA_EXPORT_HARVESTER_FILE_CHANGE_DEFAULT_GRACE_PERIOD, _tmp16_, _tmp16__target, _tmp16__target_destroy_notify);
#line 239 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	timeout = _tmp17_;
#line 241 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp18_ = self->priv->extraction_grace_timers;
#line 241 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp19_ = _data4_->file;
#line 241 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp20_ = timeout;
#line 241 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, _tmp19_, (gpointer) ((guintptr) _tmp20_));
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback = NULL;
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback_target = NULL;
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback_target_destroy_notify = NULL;
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	block4_data_unref (_data4_);
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_data4_ = NULL;
#line 1497 "rygel-media-export-harvester.c"
}


GeeArrayList* rygel_media_export_harvester_get_locations (RygelMediaExportHarvester* self) {
	GeeArrayList* result;
	GeeArrayList* _tmp0_ = NULL;
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = self->priv->_locations;
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	result = _tmp0_;
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return result;
#line 1512 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_set_locations (RygelMediaExportHarvester* self, GeeArrayList* value) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = value;
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->_locations);
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv->_locations = _tmp1_;
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_object_notify ((GObject *) self, "locations");
#line 1531 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_class_init (RygelMediaExportHarvesterClass * klass) {
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaExportHarvesterPrivate));
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_export_harvester_get_property;
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_export_harvester_set_property;
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_harvester_finalize;
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS, g_param_spec_object ("locations", "locations", "locations", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_signal_new ("done", RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1550 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_instance_init (RygelMediaExportHarvester * self) {
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv = RYGEL_MEDIA_EXPORT_HARVESTER_GET_PRIVATE (self);
#line 1557 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_finalize (GObject* obj) {
	RygelMediaExportHarvester * self;
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester);
#line 29 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->tasks);
#line 30 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->extraction_grace_timers);
#line 31 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->monitor);
#line 32 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->_locations);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	G_OBJECT_CLASS (rygel_media_export_harvester_parent_class)->finalize (obj);
#line 1577 "rygel-media-export-harvester.c"
}


/**
 * This class takes care of the book-keeping of running and finished
 * extraction tasks running within the media-export plugin
 */
GType rygel_media_export_harvester_get_type (void) {
	static volatile gsize rygel_media_export_harvester_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_harvester_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportHarvesterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_harvester_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportHarvester), 0, (GInstanceInitFunc) rygel_media_export_harvester_instance_init, NULL };
		GType rygel_media_export_harvester_type_id;
		rygel_media_export_harvester_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportHarvester", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_harvester_type_id__volatile, rygel_media_export_harvester_type_id);
	}
	return rygel_media_export_harvester_type_id__volatile;
}


static void _vala_rygel_media_export_harvester_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvester * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	switch (property_id) {
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		case RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS:
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_value_set_object (value, rygel_media_export_harvester_get_locations (self));
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		break;
#line 1608 "rygel-media-export-harvester.c"
		default:
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		break;
#line 1614 "rygel-media-export-harvester.c"
	}
}


static void _vala_rygel_media_export_harvester_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvester * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	switch (property_id) {
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		case RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS:
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		rygel_media_export_harvester_set_locations (self, g_value_get_object (value));
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		break;
#line 1630 "rygel-media-export-harvester.c"
		default:
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		break;
#line 1636 "rygel-media-export-harvester.c"
	}
}



