/* rygel-media-export-item-factory.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-media-export-item-factory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2012,2013 Intel Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gst/pbutils/codec-utils.h>
#include <gst/pbutils/descriptions.h>
#include <gst/pbutils/encoding-profile.h>
#include <gst/pbutils/encoding-target.h>
#include <gst/pbutils/gstdiscoverer.h>
#include <gst/pbutils/gstpluginsbaseversion.h>
#include <gst/pbutils/install-plugins.h>
#include <gst/pbutils/missing-plugins.h>
#include <gst/pbutils/pbutils-enumtypes.h>
#include <gst/pbutils/pbutils.h>
#include <libgupnp-dlna/gupnp-dlna.h>
#include <gst/gst.h>
#include <gst/tag/gsttagdemux.h>
#include <gst/tag/gsttagmux.h>
#include <gst/tag/tag.h>
#include <gst/tag/xmpwriter.h>
#include <libsoup/soup.h>


#define RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM (rygel_media_export_video_item_get_type ())
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItem))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))

typedef struct _RygelMediaExportVideoItem RygelMediaExportVideoItem;
typedef struct _RygelMediaExportVideoItemClass RygelMediaExportVideoItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM (rygel_media_export_photo_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItem))
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM))
#define RYGEL_MEDIA_EXPORT_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM, RygelMediaExportPhotoItemClass))

typedef struct _RygelMediaExportPhotoItem RygelMediaExportPhotoItem;
typedef struct _RygelMediaExportPhotoItemClass RygelMediaExportPhotoItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM (rygel_media_export_music_item_get_type ())
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItem))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))

typedef struct _RygelMediaExportMusicItem RygelMediaExportMusicItem;
typedef struct _RygelMediaExportMusicItemClass RygelMediaExportMusicItemClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM (rygel_media_export_playlist_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItem))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))

typedef struct _RygelMediaExportPlaylistItem RygelMediaExportPlaylistItem;
typedef struct _RygelMediaExportPlaylistItemClass RygelMediaExportPlaylistItemClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_tag_list_unref0(var) ((var == NULL) ? NULL : (var = (gst_tag_list_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT (rygel_media_export_updatable_object_get_type ())
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObject))
#define RYGEL_MEDIA_EXPORT_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT))
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObjectIface))

typedef struct _RygelMediaExportUpdatableObject RygelMediaExportUpdatableObject;
typedef struct _RygelMediaExportUpdatableObjectIface RygelMediaExportUpdatableObjectIface;
typedef struct _RygelMediaExportMusicItemPrivate RygelMediaExportMusicItemPrivate;
#define _gst_sample_unref0(var) ((var == NULL) ? NULL : (var = (gst_sample_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER (rygel_media_export_jpeg_writer_get_type ())
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriter))
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriterClass))
#define RYGEL_MEDIA_EXPORT_IS_JPEG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER))
#define RYGEL_MEDIA_EXPORT_IS_JPEG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER))
#define RYGEL_MEDIA_EXPORT_JPEG_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_JPEG_WRITER, RygelMediaExportJPEGWriterClass))

typedef struct _RygelMediaExportJPEGWriter RygelMediaExportJPEGWriter;
typedef struct _RygelMediaExportJPEGWriterClass RygelMediaExportJPEGWriterClass;
#define _gst_date_time_unref0(var) ((var == NULL) ? NULL : (var = (gst_date_time_unref (var), NULL)))
#define __vala_SoupDate_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupDate_free (var), NULL)))

struct _RygelMediaExportUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit_custom) (RygelMediaExportUpdatableObject* self, gboolean override_guarded, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_custom_finish) (RygelMediaExportUpdatableObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaExportMusicItem {
	RygelMusicItem parent_instance;
	RygelMediaExportMusicItemPrivate * priv;
	gint disc;
};

struct _RygelMediaExportMusicItemClass {
	RygelMusicItemClass parent_class;
};



RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, GFileInfo* info);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
RygelMediaExportVideoItem* rygel_media_export_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportVideoItem* rygel_media_export_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_video_item_get_type (void) G_GNUC_CONST;
RygelMediaExportPhotoItem* rygel_media_export_photo_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportPhotoItem* rygel_media_export_photo_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_photo_item_get_type (void) G_GNUC_CONST;
RygelMediaExportMusicItem* rygel_media_export_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportMusicItem* rygel_media_export_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_media_export_music_item_get_type (void) G_GNUC_CONST;
RygelMediaItem* rygel_media_export_item_factory_create_playlist_item (GFile* file, RygelMediaContainer* parent, const gchar* fallback_title);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
GType rygel_media_export_playlist_item_get_type (void) G_GNUC_CONST;
RygelMediaExportPlaylistItem* rygel_media_export_playlist_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaExportPlaylistItem* rygel_media_export_playlist_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GFileInfo* file_info);
RygelMediaItem* rygel_media_export_item_factory_fill_photo_item (RygelMediaExportPhotoItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererVideoInfo* video_info, GFileInfo* file_info);
RygelMediaItem* rygel_media_export_item_factory_fill_video_item (RygelMediaExportVideoItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererVideoInfo* video_info, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info);
RygelMediaItem* rygel_media_export_item_factory_fill_music_item (RygelMediaExportMusicItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info);
void rygel_media_export_item_factory_fill_audio_item (RygelAudioItem* item, GstDiscovererInfo* info, GstDiscovererAudioInfo* audio_info);
void rygel_media_export_item_factory_fill_media_item (RygelMediaItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GFileInfo* file_info);
GType rygel_media_export_updatable_object_get_type (void) G_GNUC_CONST;
GType rygel_media_export_jpeg_writer_get_type (void) G_GNUC_CONST;
RygelMediaExportJPEGWriter* rygel_media_export_jpeg_writer_new (GError** error);
RygelMediaExportJPEGWriter* rygel_media_export_jpeg_writer_construct (GType object_type, GError** error);
void rygel_media_export_jpeg_writer_write (RygelMediaExportJPEGWriter* self, GstBuffer* buffer, GFile* file);
static void _vala_SoupDate_free (SoupDate* self);


RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, GFileInfo* info) {
	RygelMediaItem* result = NULL;
	gchar* title = NULL;
	GFileInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	RygelMediaItem* item = NULL;
	gchar* mime = NULL;
	GFileInfo* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	RygelMediaItem* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	RygelMediaItem* _tmp41_ = NULL;
	GFileInfo* _tmp42_ = NULL;
	gint64 _tmp43_ = 0LL;
	RygelMediaItem* _tmp44_ = NULL;
	GFileInfo* _tmp45_ = NULL;
	guint64 _tmp46_ = 0ULL;
	RygelMediaItem* _tmp47_ = NULL;
	GFile* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
#line 34 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 34 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 34 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (info != NULL, NULL);
#line 37 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp0_ = info;
#line 37 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp1_ = g_file_info_get_display_name (_tmp0_);
#line 37 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 37 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	title = _tmp2_;
#line 39 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp3_ = info;
#line 39 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp4_ = g_file_info_get_content_type (_tmp3_);
#line 39 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp5_ = g_content_type_get_mime_type (_tmp4_);
#line 39 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	mime = _tmp5_;
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp6_ = mime;
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp7_ = g_str_has_prefix (_tmp6_, "video/");
#line 41 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	if (_tmp7_) {
#line 225 "rygel-media-export-item-factory.c"
		GFile* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		RygelMediaContainer* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		RygelMediaExportVideoItem* _tmp13_ = NULL;
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp8_ = file;
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp9_ = rygel_media_export_media_cache_get_id (_tmp8_);
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp10_ = _tmp9_;
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp11_ = parent;
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp12_ = title;
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp13_ = rygel_media_export_video_item_new (_tmp10_, _tmp11_, _tmp12_, RYGEL_VIDEO_ITEM_UPNP_CLASS);
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_g_object_unref0 (item);
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		item = (RygelMediaItem*) _tmp13_;
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_g_free0 (_tmp10_);
#line 250 "rygel-media-export-item-factory.c"
	} else {
		const gchar* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp14_ = mime;
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp15_ = g_str_has_prefix (_tmp14_, "image/");
#line 43 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		if (_tmp15_) {
#line 260 "rygel-media-export-item-factory.c"
			GFile* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			RygelMediaContainer* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			RygelMediaExportPhotoItem* _tmp21_ = NULL;
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp16_ = file;
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp17_ = rygel_media_export_media_cache_get_id (_tmp16_);
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp18_ = _tmp17_;
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp19_ = parent;
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp20_ = title;
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp21_ = rygel_media_export_photo_item_new (_tmp18_, _tmp19_, _tmp20_, RYGEL_PHOTO_ITEM_UPNP_CLASS);
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_g_object_unref0 (item);
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			item = (RygelMediaItem*) _tmp21_;
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_g_free0 (_tmp18_);
#line 285 "rygel-media-export-item-factory.c"
		} else {
			gboolean _tmp22_ = FALSE;
			const gchar* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp26_ = FALSE;
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp23_ = mime;
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp24_ = g_str_has_prefix (_tmp23_, "audio/");
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			if (_tmp24_) {
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp22_ = TRUE;
#line 299 "rygel-media-export-item-factory.c"
			} else {
				const gchar* _tmp25_ = NULL;
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp25_ = mime;
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp22_ = g_strcmp0 (_tmp25_, "application/ogg") == 0;
#line 306 "rygel-media-export-item-factory.c"
			}
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp26_ = _tmp22_;
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			if (_tmp26_) {
#line 312 "rygel-media-export-item-factory.c"
				GFile* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
				RygelMediaContainer* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				RygelMediaExportMusicItem* _tmp32_ = NULL;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp27_ = file;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp28_ = rygel_media_export_media_cache_get_id (_tmp27_);
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp29_ = _tmp28_;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp30_ = parent;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp31_ = title;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp32_ = rygel_media_export_music_item_new (_tmp29_, _tmp30_, _tmp31_, RYGEL_MUSIC_ITEM_UPNP_CLASS);
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_g_object_unref0 (item);
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				item = (RygelMediaItem*) _tmp32_;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_g_free0 (_tmp29_);
#line 337 "rygel-media-export-item-factory.c"
			} else {
				GFile* _tmp33_ = NULL;
				RygelMediaContainer* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				RygelMediaItem* _tmp36_ = NULL;
				RygelMediaItem* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp33_ = file;
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp34_ = parent;
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp35_ = title;
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp36_ = rygel_media_export_item_factory_create_playlist_item (_tmp33_, _tmp34_, _tmp35_);
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_g_object_unref0 (item);
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				item = _tmp36_;
#line 49 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp37_ = item;
#line 49 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				if (_tmp37_ == NULL) {
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
					result = NULL;
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
					_g_free0 (mime);
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
					_g_object_unref0 (item);
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
					_g_free0 (title);
#line 50 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
					return result;
#line 371 "rygel-media-export-item-factory.c"
				}
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp38_ = g_strdup ("text/xml");
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_g_free0 (mime);
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				mime = _tmp38_;
#line 379 "rygel-media-export-item-factory.c"
			}
		}
	}
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp39_ = item;
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp40_ = mime;
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_media_item_set_mime_type (_tmp39_, _tmp40_);
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp41_ = item;
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp42_ = info;
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp43_ = g_file_info_get_size (_tmp42_);
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_media_item_set_size (_tmp41_, (gint64) _tmp43_);
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp44_ = item;
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp45_ = info;
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp46_ = g_file_info_get_attribute_uint64 (_tmp45_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_media_object_set_modified ((RygelMediaObject*) _tmp44_, _tmp46_);
#line 60 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp47_ = item;
#line 60 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp48_ = file;
#line 60 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp49_ = g_file_get_uri (_tmp48_);
#line 60 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp50_ = _tmp49_;
#line 60 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_media_item_add_uri (_tmp47_, _tmp50_);
#line 60 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_g_free0 (_tmp50_);
#line 62 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	result = item;
#line 62 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_g_free0 (mime);
#line 62 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_g_free0 (title);
#line 62 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	return result;
#line 425 "rygel-media-export-item-factory.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 91 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 432 "rygel-media-export-item-factory.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 91 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 91 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_list_free (self);
#line 441 "rygel-media-export-item-factory.c"
}


RygelMediaItem* rygel_media_export_item_factory_create_playlist_item (GFile* file, RygelMediaContainer* parent, const gchar* fallback_title) {
	RygelMediaItem* result = NULL;
	GError * _inner_error_ = NULL;
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (fallback_title != NULL, NULL);
#line 454 "rygel-media-export-item-factory.c"
	{
		guint8* contents = NULL;
		gint contents_length1 = 0;
		gint _contents_size_ = 0;
		gboolean _tmp0_ = FALSE;
		GFile* _tmp1_ = NULL;
		guint8* _tmp2_ = NULL;
		gsize _tmp3_;
		gboolean _tmp4_ = FALSE;
		gint i = 0;
		guint8* _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		gint _tmp15_ = 0;
		guint8 _tmp16_ = 0U;
		GUPnPMediaCollection* didl_s = NULL;
		guint8* _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		GUPnPMediaCollection* _tmp18_ = NULL;
		gchar* author = NULL;
		GUPnPMediaCollection* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* title = NULL;
		GUPnPMediaCollection* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		const gchar* _tmp29_ = NULL;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp35_ = FALSE;
		const gchar* _tmp36_ = NULL;
		RygelMediaExportPlaylistItem* item = NULL;
		GFile* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		RygelMediaContainer* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		RygelMediaExportPlaylistItem* _tmp44_ = NULL;
		RygelMediaExportPlaylistItem* _tmp45_ = NULL;
		const gchar* _tmp46_ = NULL;
		RygelMediaExportPlaylistItem* _tmp49_ = NULL;
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp1_ = file;
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp4_ = g_file_load_contents (_tmp1_, NULL, &_tmp2_, &_tmp3_, NULL, &_inner_error_);
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		contents = (g_free (contents), NULL);
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		contents = _tmp2_;
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		contents_length1 = _tmp3_;
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_contents_size_ = contents_length1;
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp0_ = _tmp4_;
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		if (_inner_error_ != NULL) {
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			contents = (g_free (contents), NULL);
#line 517 "rygel-media-export-item-factory.c"
			goto __catch67_g_error;
		}
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		if (!_tmp0_) {
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			result = NULL;
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			contents = (g_free (contents), NULL);
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			return result;
#line 528 "rygel-media-export-item-factory.c"
		}
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		i = 0;
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		while (TRUE) {
#line 534 "rygel-media-export-item-factory.c"
			gboolean _tmp5_ = FALSE;
			guint8* _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
			gint _tmp7_ = 0;
			guint8 _tmp8_ = 0U;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp12_ = FALSE;
			gint _tmp13_ = 0;
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp6_ = contents;
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp6__length1 = contents_length1;
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp7_ = i;
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp8_ = _tmp6_[_tmp7_];
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp9_ = g_ascii_isspace ((gchar) _tmp8_);
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			if (_tmp9_) {
#line 555 "rygel-media-export-item-factory.c"
				gint _tmp10_ = 0;
				guint8* _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp10_ = i;
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp11_ = contents;
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp11__length1 = contents_length1;
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp5_ = _tmp10_ < _tmp11__length1;
#line 567 "rygel-media-export-item-factory.c"
			} else {
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp5_ = FALSE;
#line 571 "rygel-media-export-item-factory.c"
			}
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp12_ = _tmp5_;
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			if (!_tmp12_) {
#line 77 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				break;
#line 579 "rygel-media-export-item-factory.c"
			}
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp13_ = i;
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			i = _tmp13_ + 1;
#line 585 "rygel-media-export-item-factory.c"
		}
#line 81 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp14_ = contents;
#line 81 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp14__length1 = contents_length1;
#line 81 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp15_ = i;
#line 81 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp16_ = _tmp14_[_tmp15_];
#line 81 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		if (_tmp16_ != ((guint8) '<')) {
#line 82 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			result = NULL;
#line 82 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			contents = (g_free (contents), NULL);
#line 82 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			return result;
#line 603 "rygel-media-export-item-factory.c"
		}
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp17_ = contents;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp17__length1 = contents_length1;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp18_ = gupnp_media_collection_new_from_string ((const gchar*) _tmp17_);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		didl_s = _tmp18_;
#line 86 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp19_ = didl_s;
#line 86 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp20_ = gupnp_media_collection_get_author (_tmp19_);
#line 86 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp21_ = _tmp20_;
#line 86 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp22_ = g_strdup (_tmp21_);
#line 86 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		author = _tmp22_;
#line 87 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp23_ = didl_s;
#line 87 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp24_ = gupnp_media_collection_get_title (_tmp23_);
#line 87 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp25_ = _tmp24_;
#line 87 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp26_ = g_strdup (_tmp25_);
#line 87 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		title = _tmp26_;
#line 89 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp29_ = author;
#line 89 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		if (_tmp29_ == NULL) {
#line 637 "rygel-media-export-item-factory.c"
			const gchar* _tmp30_ = NULL;
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp30_ = title;
#line 90 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp28_ = _tmp30_ == NULL;
#line 643 "rygel-media-export-item-factory.c"
		} else {
#line 89 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp28_ = FALSE;
#line 647 "rygel-media-export-item-factory.c"
		}
#line 89 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp31_ = _tmp28_;
#line 89 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		if (_tmp31_) {
#line 653 "rygel-media-export-item-factory.c"
			GUPnPMediaCollection* _tmp32_ = NULL;
			GList* _tmp33_ = NULL;
			GList* _tmp34_ = NULL;
#line 91 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp32_ = didl_s;
#line 91 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp33_ = gupnp_media_collection_get_items (_tmp32_);
#line 91 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp34_ = _tmp33_;
#line 91 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp27_ = _tmp34_ == NULL;
#line 91 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			__g_list_free__g_object_unref0_0 (_tmp34_);
#line 667 "rygel-media-export-item-factory.c"
		} else {
#line 89 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp27_ = FALSE;
#line 671 "rygel-media-export-item-factory.c"
		}
#line 89 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp35_ = _tmp27_;
#line 89 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		if (_tmp35_) {
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			result = NULL;
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_g_free0 (title);
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_g_free0 (author);
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_g_object_unref0 (didl_s);
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			contents = (g_free (contents), NULL);
#line 92 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			return result;
#line 689 "rygel-media-export-item-factory.c"
		}
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp36_ = title;
#line 95 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		if (_tmp36_ == NULL) {
#line 695 "rygel-media-export-item-factory.c"
			const gchar* _tmp37_ = NULL;
			gchar* _tmp38_ = NULL;
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp37_ = fallback_title;
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp38_ = g_strdup (_tmp37_);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_g_free0 (title);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			title = _tmp38_;
#line 706 "rygel-media-export-item-factory.c"
		}
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp39_ = file;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp40_ = rygel_media_export_media_cache_get_id (_tmp39_);
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp41_ = _tmp40_;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp42_ = parent;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp43_ = title;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp44_ = rygel_media_export_playlist_item_new (_tmp41_, _tmp42_, _tmp43_, RYGEL_PLAYLIST_ITEM_UPNP_CLASS);
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp45_ = _tmp44_;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_g_free0 (_tmp41_);
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		item = _tmp45_;
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp46_ = author;
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		if (_tmp46_ != NULL) {
#line 730 "rygel-media-export-item-factory.c"
			RygelMediaExportPlaylistItem* _tmp47_ = NULL;
			const gchar* _tmp48_ = NULL;
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp47_ = item;
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp48_ = author;
#line 104 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			rygel_media_item_set_creator ((RygelMediaItem*) _tmp47_, _tmp48_);
#line 739 "rygel-media-export-item-factory.c"
		}
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp49_ = item;
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		rygel_media_item_set_dlna_profile ((RygelMediaItem*) _tmp49_, "DIDL_S");
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		result = (RygelMediaItem*) item;
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_g_free0 (title);
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_g_free0 (author);
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_g_object_unref0 (didl_s);
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		contents = (g_free (contents), NULL);
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		return result;
#line 757 "rygel-media-export-item-factory.c"
	}
	goto __finally67;
	__catch67_g_error:
	{
		GError* e = NULL;
#line 68 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		e = _inner_error_;
#line 68 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_inner_error_ = NULL;
#line 111 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		result = NULL;
#line 111 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_g_error_free0 (e);
#line 111 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		return result;
#line 773 "rygel-media-export-item-factory.c"
	}
	__finally67:
#line 68 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 68 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_clear_error (&_inner_error_);
#line 68 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	return NULL;
#line 782 "rygel-media-export-item-factory.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	return self ? g_object_ref (self) : NULL;
#line 789 "rygel-media-export-item-factory.c"
}


RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaItem* item = NULL;
	gchar* id = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GList* audio_streams = NULL;
	GList* video_streams = NULL;
	GstDiscovererInfo* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GstDiscovererInfo* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GList* _tmp7_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp13_ = FALSE;
	GList* _tmp14_ = NULL;
	gboolean _tmp18_ = FALSE;
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (info != NULL, NULL);
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (file_info != NULL, NULL);
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp0_ = file;
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp1_ = rygel_media_export_media_cache_get_id (_tmp0_);
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	id = _tmp1_;
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp2_ = info;
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp3_ = gst_discoverer_info_get_audio_streams (_tmp2_);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	__g_list_free__g_object_unref0_0 (audio_streams);
#line 125 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	audio_streams = (GList*) _tmp3_;
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp4_ = info;
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp5_ = gst_discoverer_info_get_video_streams (_tmp4_);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	__g_list_free__g_object_unref0_0 (video_streams);
#line 127 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	video_streams = (GList*) _tmp5_;
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp7_ = audio_streams;
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	if (_tmp7_ == NULL) {
#line 845 "rygel-media-export-item-factory.c"
		GList* _tmp8_ = NULL;
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp8_ = video_streams;
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp6_ = _tmp8_ == NULL;
#line 851 "rygel-media-export-item-factory.c"
	} else {
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp6_ = FALSE;
#line 855 "rygel-media-export-item-factory.c"
	}
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp9_ = _tmp6_;
#line 130 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	if (_tmp9_) {
#line 861 "rygel-media-export-item-factory.c"
		GFile* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp10_ = file;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp11_ = g_file_get_uri (_tmp10_);
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp12_ = _tmp11_;
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		g_debug ("%s had neither audio nor video/picture " "streams. Ignoring.", _tmp12_);
#line 131 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_g_free0 (_tmp12_);
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		result = NULL;
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		__g_list_free__g_object_unref0_0 (video_streams);
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		__g_list_free__g_object_unref0_0 (audio_streams);
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_g_free0 (id);
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_g_object_unref0 (item);
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		return result;
#line 887 "rygel-media-export-item-factory.c"
	}
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp14_ = audio_streams;
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	if (_tmp14_ == NULL) {
#line 893 "rygel-media-export-item-factory.c"
		GList* _tmp15_ = NULL;
		gconstpointer _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp15_ = video_streams;
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp16_ = _tmp15_->data;
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp17_ = gst_discoverer_video_info_is_image ((GstDiscovererVideoInfo*) _tmp16_);
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp13_ = _tmp17_;
#line 905 "rygel-media-export-item-factory.c"
	} else {
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp13_ = FALSE;
#line 909 "rygel-media-export-item-factory.c"
	}
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp18_ = _tmp13_;
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	if (_tmp18_) {
#line 915 "rygel-media-export-item-factory.c"
		const gchar* _tmp19_ = NULL;
		RygelMediaContainer* _tmp20_ = NULL;
		RygelMediaExportPhotoItem* _tmp21_ = NULL;
		RygelMediaItem* _tmp22_ = NULL;
		GFile* _tmp23_ = NULL;
		GstDiscovererInfo* _tmp24_ = NULL;
		GUPnPDLNAProfile* _tmp25_ = NULL;
		GList* _tmp26_ = NULL;
		gconstpointer _tmp27_ = NULL;
		GFileInfo* _tmp28_ = NULL;
		RygelMediaItem* _tmp29_ = NULL;
#line 139 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp19_ = id;
#line 139 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp20_ = parent;
#line 139 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp21_ = rygel_media_export_photo_item_new (_tmp19_, _tmp20_, "", RYGEL_PHOTO_ITEM_UPNP_CLASS);
#line 139 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_g_object_unref0 (item);
#line 139 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		item = (RygelMediaItem*) _tmp21_;
#line 140 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp22_ = item;
#line 140 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp23_ = file;
#line 140 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp24_ = info;
#line 140 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp25_ = profile;
#line 140 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp26_ = video_streams;
#line 140 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp27_ = _tmp26_->data;
#line 140 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp28_ = file_info;
#line 140 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp29_ = rygel_media_export_item_factory_fill_photo_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, RYGEL_MEDIA_EXPORT_TYPE_PHOTO_ITEM) ? ((RygelMediaExportPhotoItem*) _tmp22_) : NULL, _tmp23_, _tmp24_, _tmp25_, (GstDiscovererVideoInfo*) _tmp27_, _tmp28_);
#line 140 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		result = _tmp29_;
#line 140 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		__g_list_free__g_object_unref0_0 (video_streams);
#line 140 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		__g_list_free__g_object_unref0_0 (audio_streams);
#line 140 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_g_free0 (id);
#line 140 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_g_object_unref0 (item);
#line 140 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		return result;
#line 965 "rygel-media-export-item-factory.c"
	} else {
		GList* _tmp30_ = NULL;
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp30_ = video_streams;
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		if (_tmp30_ != NULL) {
#line 972 "rygel-media-export-item-factory.c"
			const gchar* _tmp31_ = NULL;
			RygelMediaContainer* _tmp32_ = NULL;
			RygelMediaExportVideoItem* _tmp33_ = NULL;
			GstDiscovererAudioInfo* audio_info = NULL;
			gpointer _tmp34_ = NULL;
			GstDiscovererAudioInfo* _tmp35_ = NULL;
			GList* _tmp36_ = NULL;
			RygelMediaItem* _tmp40_ = NULL;
			GFile* _tmp41_ = NULL;
			GstDiscovererInfo* _tmp42_ = NULL;
			GUPnPDLNAProfile* _tmp43_ = NULL;
			GList* _tmp44_ = NULL;
			gconstpointer _tmp45_ = NULL;
			GstDiscovererAudioInfo* _tmp46_ = NULL;
			GFileInfo* _tmp47_ = NULL;
			RygelMediaItem* _tmp48_ = NULL;
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp31_ = id;
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp32_ = parent;
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp33_ = rygel_media_export_video_item_new (_tmp31_, _tmp32_, "", RYGEL_VIDEO_ITEM_UPNP_CLASS);
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_g_object_unref0 (item);
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			item = (RygelMediaItem*) _tmp33_;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp34_ = NULL;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, gst_discoverer_audio_info_get_type ()) ? ((GstDiscovererAudioInfo*) _tmp34_) : NULL);
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			audio_info = _tmp35_;
#line 150 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp36_ = audio_streams;
#line 150 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			if (_tmp36_ != NULL) {
#line 1009 "rygel-media-export-item-factory.c"
				GList* _tmp37_ = NULL;
				gconstpointer _tmp38_ = NULL;
				GstDiscovererAudioInfo* _tmp39_ = NULL;
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp37_ = audio_streams;
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp38_ = _tmp37_->data;
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp39_ = _g_object_ref0 ((GstDiscovererAudioInfo*) _tmp38_);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_g_object_unref0 (audio_info);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				audio_info = _tmp39_;
#line 1023 "rygel-media-export-item-factory.c"
			}
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp40_ = item;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp41_ = file;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp42_ = info;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp43_ = profile;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp44_ = video_streams;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp45_ = _tmp44_->data;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp46_ = audio_info;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp47_ = file_info;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp48_ = rygel_media_export_item_factory_fill_video_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM) ? ((RygelMediaExportVideoItem*) _tmp40_) : NULL, _tmp41_, _tmp42_, _tmp43_, (GstDiscovererVideoInfo*) _tmp45_, _tmp46_, _tmp47_);
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			result = _tmp48_;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_g_object_unref0 (audio_info);
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			__g_list_free__g_object_unref0_0 (video_streams);
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			__g_list_free__g_object_unref0_0 (audio_streams);
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_g_free0 (id);
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_g_object_unref0 (item);
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			return result;
#line 1057 "rygel-media-export-item-factory.c"
		} else {
			GList* _tmp49_ = NULL;
#line 161 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp49_ = audio_streams;
#line 161 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			if (_tmp49_ != NULL) {
#line 1064 "rygel-media-export-item-factory.c"
				const gchar* _tmp50_ = NULL;
				RygelMediaContainer* _tmp51_ = NULL;
				RygelMediaExportMusicItem* _tmp52_ = NULL;
				RygelMediaItem* _tmp53_ = NULL;
				GFile* _tmp54_ = NULL;
				GstDiscovererInfo* _tmp55_ = NULL;
				GUPnPDLNAProfile* _tmp56_ = NULL;
				GList* _tmp57_ = NULL;
				gconstpointer _tmp58_ = NULL;
				GFileInfo* _tmp59_ = NULL;
				RygelMediaItem* _tmp60_ = NULL;
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp50_ = id;
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp51_ = parent;
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp52_ = rygel_media_export_music_item_new (_tmp50_, _tmp51_, "", RYGEL_MUSIC_ITEM_UPNP_CLASS);
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_g_object_unref0 (item);
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				item = (RygelMediaItem*) _tmp52_;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp53_ = item;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp54_ = file;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp55_ = info;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp56_ = profile;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp57_ = audio_streams;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp58_ = _tmp57_->data;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp59_ = file_info;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp60_ = rygel_media_export_item_factory_fill_music_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) _tmp53_) : NULL, _tmp54_, _tmp55_, _tmp56_, (GstDiscovererAudioInfo*) _tmp58_, _tmp59_);
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				result = _tmp60_;
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				__g_list_free__g_object_unref0_0 (video_streams);
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				__g_list_free__g_object_unref0_0 (audio_streams);
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_g_free0 (id);
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_g_object_unref0 (item);
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				return result;
#line 1114 "rygel-media-export-item-factory.c"
			} else {
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				result = NULL;
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				__g_list_free__g_object_unref0_0 (video_streams);
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				__g_list_free__g_object_unref0_0 (audio_streams);
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_g_free0 (id);
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_g_object_unref0 (item);
#line 170 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				return result;
#line 1128 "rygel-media-export-item-factory.c"
			}
		}
	}
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	__g_list_free__g_object_unref0_0 (video_streams);
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	__g_list_free__g_object_unref0_0 (audio_streams);
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_g_free0 (id);
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_g_object_unref0 (item);
#line 1140 "rygel-media-export-item-factory.c"
}


static gpointer _gst_tag_list_ref0 (gpointer self) {
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	return self ? gst_tag_list_ref (self) : NULL;
#line 1147 "rygel-media-export-item-factory.c"
}


void rygel_media_export_item_factory_fill_audio_item (RygelAudioItem* item, GstDiscovererInfo* info, GstDiscovererAudioInfo* audio_info) {
	GstDiscovererInfo* _tmp0_ = NULL;
	GstClockTime _tmp1_ = 0ULL;
	GstDiscovererAudioInfo* _tmp6_ = NULL;
	GstTagList* tags = NULL;
	GstDiscovererAudioInfo* _tmp7_ = NULL;
	GstTagList* _tmp8_ = NULL;
	GstTagList* _tmp9_ = NULL;
	GstTagList* _tmp10_ = NULL;
	RygelAudioItem* _tmp15_ = NULL;
	GstDiscovererAudioInfo* _tmp16_ = NULL;
	guint _tmp17_ = 0U;
	RygelAudioItem* _tmp18_ = NULL;
	GstDiscovererAudioInfo* _tmp19_ = NULL;
	guint _tmp20_ = 0U;
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_if_fail (item != NULL);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_if_fail (info != NULL);
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp0_ = info;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp1_ = gst_discoverer_info_get_duration (_tmp0_);
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	if (_tmp1_ > ((GstClockTime) 0)) {
#line 1176 "rygel-media-export-item-factory.c"
		RygelAudioItem* _tmp2_ = NULL;
		GstDiscovererInfo* _tmp3_ = NULL;
		GstClockTime _tmp4_ = 0ULL;
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp2_ = item;
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp3_ = info;
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp4_ = gst_discoverer_info_get_duration (_tmp3_);
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		rygel_audio_item_set_duration (_tmp2_, (glong) (_tmp4_ / GST_SECOND));
#line 1188 "rygel-media-export-item-factory.c"
	} else {
		RygelAudioItem* _tmp5_ = NULL;
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp5_ = item;
#line 180 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		rygel_audio_item_set_duration (_tmp5_, (glong) (-1));
#line 1195 "rygel-media-export-item-factory.c"
	}
#line 183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp6_ = audio_info;
#line 183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	if (_tmp6_ == NULL) {
#line 184 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		return;
#line 1203 "rygel-media-export-item-factory.c"
	}
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp7_ = audio_info;
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp8_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp7_);
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp9_ = _gst_tag_list_ref0 (_tmp8_);
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	tags = _tmp9_;
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp10_ = tags;
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	if (_tmp10_ != NULL) {
#line 1217 "rygel-media-export-item-factory.c"
		guint tmp = 0U;
		GstTagList* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		RygelAudioItem* _tmp13_ = NULL;
		guint _tmp14_ = 0U;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp11_ = tags;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		gst_tag_list_get_uint (_tmp11_, GST_TAG_BITRATE, &_tmp12_);
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		tmp = _tmp12_;
#line 190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp13_ = item;
#line 190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp14_ = tmp;
#line 190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		rygel_audio_item_set_bitrate (_tmp13_, ((gint) _tmp14_) / 8);
#line 1235 "rygel-media-export-item-factory.c"
	}
#line 193 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp15_ = item;
#line 193 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp16_ = audio_info;
#line 193 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp17_ = gst_discoverer_audio_info_get_channels (_tmp16_);
#line 193 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_audio_item_set_channels (_tmp15_, (gint) _tmp17_);
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp18_ = item;
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp19_ = audio_info;
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp20_ = gst_discoverer_audio_info_get_sample_rate (_tmp19_);
#line 194 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_audio_item_set_sample_freq (_tmp18_, (gint) _tmp20_);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_gst_tag_list_unref0 (tags);
#line 1255 "rygel-media-export-item-factory.c"
}


RygelMediaItem* rygel_media_export_item_factory_fill_video_item (RygelMediaExportVideoItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererVideoInfo* video_info, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaExportVideoItem* _tmp0_ = NULL;
	GstDiscovererInfo* _tmp1_ = NULL;
	GstDiscovererAudioInfo* _tmp2_ = NULL;
	RygelMediaExportVideoItem* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GstDiscovererInfo* _tmp5_ = NULL;
	GUPnPDLNAProfile* _tmp6_ = NULL;
	GFileInfo* _tmp7_ = NULL;
	RygelMediaExportVideoItem* _tmp8_ = NULL;
	GstDiscovererVideoInfo* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	RygelMediaExportVideoItem* _tmp11_ = NULL;
	GstDiscovererVideoInfo* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	gint color_depth = 0;
	GstDiscovererVideoInfo* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	RygelMediaExportVideoItem* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	RygelMediaExportVideoItem* _tmp21_ = NULL;
	RygelMediaItem* _tmp22_ = NULL;
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (info != NULL, NULL);
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (video_info != NULL, NULL);
#line 198 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (file_info != NULL, NULL);
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp0_ = item;
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp1_ = info;
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp2_ = audio_info;
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_media_export_item_factory_fill_audio_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp0_) : NULL, _tmp1_, _tmp2_);
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp3_ = item;
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp4_ = file;
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp5_ = info;
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp6_ = profile;
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp7_ = file_info;
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp3_, _tmp4_, _tmp5_, _tmp6_, _tmp7_);
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp8_ = item;
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp9_ = video_info;
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp10_ = gst_discoverer_video_info_get_width (_tmp9_);
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_visual_item_set_width ((RygelVisualItem*) _tmp8_, (gint) _tmp10_);
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp11_ = item;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp12_ = video_info;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp13_ = gst_discoverer_video_info_get_height (_tmp12_);
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_visual_item_set_height ((RygelVisualItem*) _tmp11_, (gint) _tmp13_);
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp14_ = video_info;
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp15_ = gst_discoverer_video_info_get_depth (_tmp14_);
#line 211 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	color_depth = (gint) _tmp15_;
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp17_ = color_depth;
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	if (_tmp17_ == 0) {
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp16_ = -1;
#line 1342 "rygel-media-export-item-factory.c"
	} else {
		gint _tmp18_ = 0;
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp18_ = color_depth;
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp16_ = _tmp18_;
#line 1349 "rygel-media-export-item-factory.c"
	}
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp19_ = item;
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp20_ = _tmp16_;
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_visual_item_set_color_depth ((RygelVisualItem*) _tmp19_, _tmp20_);
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp21_ = item;
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp22_ = _g_object_ref0 ((RygelMediaItem*) _tmp21_);
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	result = _tmp22_;
#line 214 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	return result;
#line 1365 "rygel-media-export-item-factory.c"
}


RygelMediaItem* rygel_media_export_item_factory_fill_photo_item (RygelMediaExportPhotoItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererVideoInfo* video_info, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaExportPhotoItem* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GstDiscovererInfo* _tmp2_ = NULL;
	GUPnPDLNAProfile* _tmp3_ = NULL;
	GFileInfo* _tmp4_ = NULL;
	RygelMediaExportPhotoItem* _tmp5_ = NULL;
	GstDiscovererVideoInfo* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	RygelMediaExportPhotoItem* _tmp8_ = NULL;
	GstDiscovererVideoInfo* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	gint color_depth = 0;
	GstDiscovererVideoInfo* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	RygelMediaExportPhotoItem* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	RygelMediaExportPhotoItem* _tmp18_ = NULL;
	RygelMediaItem* _tmp19_ = NULL;
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (info != NULL, NULL);
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (video_info != NULL, NULL);
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (file_info != NULL, NULL);
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp0_ = item;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp1_ = file;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp2_ = info;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp3_ = profile;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp4_ = file_info;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 225 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp5_ = item;
#line 225 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp6_ = video_info;
#line 225 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp7_ = gst_discoverer_video_info_get_width (_tmp6_);
#line 225 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_visual_item_set_width ((RygelVisualItem*) _tmp5_, (gint) _tmp7_);
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp8_ = item;
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp9_ = video_info;
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp10_ = gst_discoverer_video_info_get_height (_tmp9_);
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_visual_item_set_height ((RygelVisualItem*) _tmp8_, (gint) _tmp10_);
#line 228 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp11_ = video_info;
#line 228 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp12_ = gst_discoverer_video_info_get_depth (_tmp11_);
#line 228 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	color_depth = (gint) _tmp12_;
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp14_ = color_depth;
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	if (_tmp14_ == 0) {
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp13_ = -1;
#line 1441 "rygel-media-export-item-factory.c"
	} else {
		gint _tmp15_ = 0;
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp15_ = color_depth;
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp13_ = _tmp15_;
#line 1448 "rygel-media-export-item-factory.c"
	}
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp16_ = item;
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp17_ = _tmp13_;
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_visual_item_set_color_depth ((RygelVisualItem*) _tmp16_, _tmp17_);
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp18_ = item;
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp19_ = _g_object_ref0 ((RygelMediaItem*) _tmp18_);
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	result = _tmp19_;
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	return result;
#line 1464 "rygel-media-export-item-factory.c"
}


RygelMediaItem* rygel_media_export_item_factory_fill_music_item (RygelMediaExportMusicItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GstDiscovererAudioInfo* audio_info, GFileInfo* file_info) {
	RygelMediaItem* result = NULL;
	RygelMediaExportMusicItem* _tmp0_ = NULL;
	GstDiscovererInfo* _tmp1_ = NULL;
	GstDiscovererAudioInfo* _tmp2_ = NULL;
	RygelMediaExportMusicItem* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GstDiscovererInfo* _tmp5_ = NULL;
	GUPnPDLNAProfile* _tmp6_ = NULL;
	GFileInfo* _tmp7_ = NULL;
	GstDiscovererAudioInfo* _tmp8_ = NULL;
	GstTagList* tags = NULL;
	GstDiscovererAudioInfo* _tmp11_ = NULL;
	GstTagList* _tmp12_ = NULL;
	GstTagList* _tmp13_ = NULL;
	GstTagList* _tmp14_ = NULL;
	gchar* artist = NULL;
	GstTagList* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	RygelMediaExportMusicItem* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* album = NULL;
	GstTagList* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	RygelMediaExportMusicItem* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	gchar* genre = NULL;
	GstTagList* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	RygelMediaExportMusicItem* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	guint tmp = 0U;
	GstTagList* _tmp29_ = NULL;
	guint _tmp30_ = 0U;
	RygelMediaExportMusicItem* _tmp31_ = NULL;
	guint _tmp32_ = 0U;
	GstTagList* _tmp33_ = NULL;
	guint _tmp34_ = 0U;
	RygelMediaExportMusicItem* _tmp35_ = NULL;
	guint _tmp36_ = 0U;
	GstSample* sample = NULL;
	GstTagList* _tmp37_ = NULL;
	GstSample* _tmp38_ = NULL;
	GstSample* _tmp39_ = NULL;
	GstStructure* structure = NULL;
	GstSample* _tmp42_ = NULL;
	GstCaps* _tmp43_ = NULL;
	GstStructure* _tmp44_ = NULL;
	gint image_type = 0;
	GstStructure* _tmp45_ = NULL;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	RygelMediaExportMusicItem* _tmp57_ = NULL;
	RygelMediaItem* _tmp58_ = NULL;
	GError * _inner_error_ = NULL;
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (info != NULL, NULL);
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_val_if_fail (file_info != NULL, NULL);
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp0_ = item;
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp1_ = info;
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp2_ = audio_info;
#line 240 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_media_export_item_factory_fill_audio_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp0_) : NULL, _tmp1_, _tmp2_);
#line 241 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp3_ = item;
#line 241 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp4_ = file;
#line 241 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp5_ = info;
#line 241 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp6_ = profile;
#line 241 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp7_ = file_info;
#line 241 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_media_export_item_factory_fill_media_item ((RygelMediaItem*) _tmp3_, _tmp4_, _tmp5_, _tmp6_, _tmp7_);
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp8_ = audio_info;
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	if (_tmp8_ == NULL) {
#line 1555 "rygel-media-export-item-factory.c"
		RygelMediaExportMusicItem* _tmp9_ = NULL;
		RygelMediaItem* _tmp10_ = NULL;
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp9_ = item;
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp10_ = _g_object_ref0 ((RygelMediaItem*) _tmp9_);
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		result = _tmp10_;
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		return result;
#line 1566 "rygel-media-export-item-factory.c"
	}
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp11_ = audio_info;
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp12_ = gst_discoverer_stream_info_get_tags ((GstDiscovererStreamInfo*) _tmp11_);
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp13_ = _gst_tag_list_ref0 (_tmp12_);
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	tags = _tmp13_;
#line 248 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp14_ = tags;
#line 248 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	if (_tmp14_ == NULL) {
#line 1580 "rygel-media-export-item-factory.c"
		RygelMediaExportMusicItem* _tmp15_ = NULL;
		RygelMediaItem* _tmp16_ = NULL;
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp15_ = item;
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp16_ = _g_object_ref0 ((RygelMediaItem*) _tmp15_);
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		result = _tmp16_;
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_gst_tag_list_unref0 (tags);
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		return result;
#line 1593 "rygel-media-export-item-factory.c"
	}
#line 253 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp17_ = tags;
#line 253 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	gst_tag_list_get_string (_tmp17_, GST_TAG_ARTIST, &_tmp18_);
#line 253 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_g_free0 (artist);
#line 253 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	artist = _tmp18_;
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp19_ = item;
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp20_ = artist;
#line 254 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_music_item_set_artist ((RygelMusicItem*) _tmp19_, _tmp20_);
#line 257 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp21_ = tags;
#line 257 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	gst_tag_list_get_string (_tmp21_, GST_TAG_ALBUM, &_tmp22_);
#line 257 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_g_free0 (album);
#line 257 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	album = _tmp22_;
#line 258 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp23_ = item;
#line 258 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp24_ = album;
#line 258 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_music_item_set_album ((RygelMusicItem*) _tmp23_, _tmp24_);
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp25_ = tags;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	gst_tag_list_get_string (_tmp25_, GST_TAG_GENRE, &_tmp26_);
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_g_free0 (genre);
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	genre = _tmp26_;
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp27_ = item;
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp28_ = genre;
#line 262 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_music_item_set_genre ((RygelMusicItem*) _tmp27_, _tmp28_);
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp29_ = tags;
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	gst_tag_list_get_uint (_tmp29_, GST_TAG_ALBUM_VOLUME_NUMBER, &_tmp30_);
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	tmp = _tmp30_;
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp31_ = item;
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp32_ = tmp;
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp31_->disc = (gint) _tmp32_;
#line 268 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp33_ = tags;
#line 268 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	gst_tag_list_get_uint (_tmp33_, GST_TAG_TRACK_NUMBER, &_tmp34_);
#line 268 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	tmp = _tmp34_;
#line 269 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp35_ = item;
#line 269 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp36_ = tmp;
#line 269 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_music_item_set_track_number ((RygelMusicItem*) _tmp35_, (gint) _tmp36_);
#line 272 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp37_ = tags;
#line 272 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	gst_tag_list_get_sample (_tmp37_, GST_TAG_IMAGE, &_tmp38_);
#line 272 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_gst_sample_unref0 (sample);
#line 272 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	sample = _tmp38_;
#line 273 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp39_ = sample;
#line 273 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	if (_tmp39_ == NULL) {
#line 1673 "rygel-media-export-item-factory.c"
		RygelMediaExportMusicItem* _tmp40_ = NULL;
		RygelMediaItem* _tmp41_ = NULL;
#line 274 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp40_ = item;
#line 274 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp41_ = _g_object_ref0 ((RygelMediaItem*) _tmp40_);
#line 274 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		result = _tmp41_;
#line 274 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_gst_sample_unref0 (sample);
#line 274 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_g_free0 (genre);
#line 274 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_g_free0 (album);
#line 274 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_g_free0 (artist);
#line 274 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_gst_tag_list_unref0 (tags);
#line 274 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		return result;
#line 1694 "rygel-media-export-item-factory.c"
	}
#line 276 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp42_ = sample;
#line 276 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp43_ = gst_sample_get_caps (_tmp42_);
#line 276 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp44_ = gst_caps_get_structure (_tmp43_, (guint) 0);
#line 276 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	structure = _tmp44_;
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp45_ = structure;
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	gst_structure_get_enum (_tmp45_, "image-type", gst_tag_image_type_get_type (), &_tmp46_);
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	image_type = _tmp46_;
#line 282 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp47_ = image_type;
#line 282 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	switch (_tmp47_) {
#line 282 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		case GST_TAG_IMAGE_TYPE_UNDEFINED:
#line 282 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		case GST_TAG_IMAGE_TYPE_FRONT_COVER:
#line 1718 "rygel-media-export-item-factory.c"
		{
			RygelMediaArtStore* store = NULL;
			RygelMediaArtStore* _tmp48_ = NULL;
			GFile* thumb = NULL;
			RygelMediaArtStore* _tmp49_ = NULL;
			RygelMediaExportMusicItem* _tmp50_ = NULL;
			GFile* _tmp51_ = NULL;
#line 285 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp48_ = rygel_media_art_store_get_default ();
#line 285 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			store = _tmp48_;
#line 286 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp49_ = store;
#line 286 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp50_ = item;
#line 286 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp51_ = rygel_media_art_store_get_media_art_file (_tmp49_, "album", (RygelMusicItem*) _tmp50_, TRUE);
#line 286 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			thumb = _tmp51_;
#line 1738 "rygel-media-export-item-factory.c"
			{
				RygelMediaExportJPEGWriter* writer = NULL;
				RygelMediaExportJPEGWriter* _tmp52_ = NULL;
				RygelMediaExportJPEGWriter* _tmp53_ = NULL;
				GstSample* _tmp54_ = NULL;
				GstBuffer* _tmp55_ = NULL;
				GFile* _tmp56_ = NULL;
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp52_ = rygel_media_export_jpeg_writer_new (&_inner_error_);
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				writer = _tmp52_;
#line 288 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				if (_inner_error_ != NULL) {
#line 1752 "rygel-media-export-item-factory.c"
					goto __catch68_g_error;
				}
#line 289 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp53_ = writer;
#line 289 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp54_ = sample;
#line 289 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp55_ = gst_sample_get_buffer (_tmp54_);
#line 289 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp56_ = thumb;
#line 289 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				rygel_media_export_jpeg_writer_write (_tmp53_, _tmp55_, _tmp56_);
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_g_object_unref0 (writer);
#line 1767 "rygel-media-export-item-factory.c"
			}
			goto __finally68;
			__catch68_g_error:
			{
				GError* _error_ = NULL;
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_error_ = _inner_error_;
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_inner_error_ = NULL;
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_g_error_free0 (_error_);
#line 1779 "rygel-media-export-item-factory.c"
			}
			__finally68:
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			if (_inner_error_ != NULL) {
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_g_object_unref0 (thumb);
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_g_object_unref0 (store);
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_gst_sample_unref0 (sample);
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_g_free0 (genre);
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_g_free0 (album);
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_g_free0 (artist);
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_gst_tag_list_unref0 (tags);
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				g_clear_error (&_inner_error_);
#line 287 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				return NULL;
#line 1804 "rygel-media-export-item-factory.c"
			}
#line 291 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_g_object_unref0 (thumb);
#line 291 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_g_object_unref0 (store);
#line 291 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			break;
#line 1812 "rygel-media-export-item-factory.c"
		}
		default:
		{
#line 293 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			break;
#line 1818 "rygel-media-export-item-factory.c"
		}
	}
#line 296 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp57_ = item;
#line 296 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp58_ = _g_object_ref0 ((RygelMediaItem*) _tmp57_);
#line 296 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	result = _tmp58_;
#line 296 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_gst_sample_unref0 (sample);
#line 296 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_g_free0 (genre);
#line 296 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_g_free0 (album);
#line 296 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_g_free0 (artist);
#line 296 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_gst_tag_list_unref0 (tags);
#line 296 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	return result;
#line 1839 "rygel-media-export-item-factory.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1237 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1237 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1238 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1238 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1238 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1238 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 1859 "rygel-media-export-item-factory.c"
}


static void _vala_SoupDate_free (SoupDate* self) {
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_boxed_free (soup_date_get_type (), self);
#line 1866 "rygel-media-export-item-factory.c"
}


void rygel_media_export_item_factory_fill_media_item (RygelMediaItem* item, GFile* file, GstDiscovererInfo* info, GUPnPDLNAProfile* profile, GFileInfo* file_info) {
	gchar* title = NULL;
	GstTagList* tags = NULL;
	GstDiscovererInfo* _tmp0_ = NULL;
	GstTagList* _tmp1_ = NULL;
	GstTagList* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GstTagList* _tmp4_ = NULL;
	gboolean _tmp8_ = FALSE;
	GstDateTime* dt = NULL;
	gboolean _tmp12_ = FALSE;
	GstTagList* _tmp13_ = NULL;
	gboolean _tmp17_ = FALSE;
	RygelMediaItem* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	guint64 mtime = 0ULL;
	GFileInfo* _tmp47_ = NULL;
	guint64 _tmp48_ = 0ULL;
	RygelMediaItem* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	RygelMediaItem* _tmp57_ = NULL;
	const gchar* _tmp58_ = NULL;
	const gchar* _tmp59_ = NULL;
	gboolean _tmp60_ = FALSE;
	RygelMediaItem* _tmp69_ = NULL;
	GFileInfo* _tmp70_ = NULL;
	gint64 _tmp71_ = 0LL;
	RygelMediaItem* _tmp72_ = NULL;
	guint64 _tmp73_ = 0ULL;
	gboolean _tmp74_ = FALSE;
	GUPnPDLNAProfile* _tmp75_ = NULL;
	gboolean _tmp79_ = FALSE;
	RygelMediaItem* _tmp93_ = NULL;
	GFile* _tmp94_ = NULL;
	gchar* _tmp95_ = NULL;
	gchar* _tmp96_ = NULL;
#line 299 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_if_fail (item != NULL);
#line 299 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_if_fail (file != NULL);
#line 299 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_if_fail (info != NULL);
#line 299 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	g_return_if_fail (file_info != NULL);
#line 304 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	title = NULL;
#line 306 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp0_ = info;
#line 306 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp1_ = gst_discoverer_info_get_tags (_tmp0_);
#line 306 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp2_ = _gst_tag_list_ref0 (_tmp1_);
#line 306 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	tags = _tmp2_;
#line 307 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp4_ = tags;
#line 307 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	if (_tmp4_ == NULL) {
#line 307 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp3_ = TRUE;
#line 1931 "rygel-media-export-item-factory.c"
	} else {
		GstTagList* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
#line 308 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp5_ = tags;
#line 308 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp7_ = gst_tag_list_get_string (_tmp5_, GST_TAG_TITLE, &_tmp6_);
#line 308 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_g_free0 (title);
#line 308 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		title = _tmp6_;
#line 308 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp3_ = !_tmp7_;
#line 1946 "rygel-media-export-item-factory.c"
	}
#line 307 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp8_ = _tmp3_;
#line 307 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	if (_tmp8_) {
#line 1952 "rygel-media-export-item-factory.c"
		GFileInfo* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp9_ = file_info;
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp10_ = g_file_info_get_display_name (_tmp9_);
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp11_ = g_strdup (_tmp10_);
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_g_free0 (title);
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		title = _tmp11_;
#line 1966 "rygel-media-export-item-factory.c"
	}
#line 314 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	dt = NULL;
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp13_ = tags;
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	if (_tmp13_ != NULL) {
#line 1974 "rygel-media-export-item-factory.c"
		GstTagList* _tmp14_ = NULL;
		GstDateTime* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp14_ = tags;
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp16_ = gst_tag_list_get_date_time (_tmp14_, GST_TAG_DATE_TIME, &_tmp15_);
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_gst_date_time_unref0 (dt);
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		dt = _tmp15_;
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp12_ = _tmp16_;
#line 1988 "rygel-media-export-item-factory.c"
	} else {
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp12_ = FALSE;
#line 1992 "rygel-media-export-item-factory.c"
	}
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp17_ = _tmp12_;
#line 315 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	if (_tmp17_) {
#line 1998 "rygel-media-export-item-factory.c"
		gboolean _tmp18_ = FALSE;
		GstDateTime* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp23_ = FALSE;
#line 318 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp19_ = dt;
#line 318 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp20_ = gst_date_time_has_day (_tmp19_);
#line 318 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		if (!_tmp20_) {
#line 318 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp18_ = TRUE;
#line 2011 "rygel-media-export-item-factory.c"
		} else {
			GstDateTime* _tmp21_ = NULL;
			gboolean _tmp22_ = FALSE;
#line 318 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp21_ = dt;
#line 318 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp22_ = gst_date_time_has_month (_tmp21_);
#line 318 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp18_ = !_tmp22_;
#line 2021 "rygel-media-export-item-factory.c"
		}
#line 318 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp23_ = _tmp18_;
#line 318 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		if (_tmp23_) {
#line 2027 "rygel-media-export-item-factory.c"
			gint _tmp24_ = 0;
			GstDateTime* _tmp25_ = NULL;
			gboolean _tmp26_ = FALSE;
			gint _tmp29_ = 0;
			GstDateTime* _tmp30_ = NULL;
			gboolean _tmp31_ = FALSE;
			RygelMediaItem* _tmp34_ = NULL;
			GstDateTime* _tmp35_ = NULL;
			gint _tmp36_ = 0;
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
			gchar* _tmp39_ = NULL;
			gchar* _tmp40_ = NULL;
#line 320 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp25_ = dt;
#line 320 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp26_ = gst_date_time_has_month (_tmp25_);
#line 320 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			if (_tmp26_) {
#line 2047 "rygel-media-export-item-factory.c"
				GstDateTime* _tmp27_ = NULL;
				gint _tmp28_ = 0;
#line 321 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp27_ = dt;
#line 321 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp28_ = gst_date_time_get_month (_tmp27_);
#line 321 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp24_ = _tmp28_;
#line 2056 "rygel-media-export-item-factory.c"
			} else {
#line 321 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp24_ = 1;
#line 2060 "rygel-media-export-item-factory.c"
			}
#line 322 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp30_ = dt;
#line 322 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp31_ = gst_date_time_has_day (_tmp30_);
#line 322 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			if (_tmp31_) {
#line 2068 "rygel-media-export-item-factory.c"
				GstDateTime* _tmp32_ = NULL;
				gint _tmp33_ = 0;
#line 323 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp32_ = dt;
#line 323 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp33_ = gst_date_time_get_day (_tmp32_);
#line 323 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp29_ = _tmp33_;
#line 2077 "rygel-media-export-item-factory.c"
			} else {
#line 323 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
				_tmp29_ = 1;
#line 2081 "rygel-media-export-item-factory.c"
			}
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp34_ = item;
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp35_ = dt;
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp36_ = gst_date_time_get_year (_tmp35_);
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp37_ = _tmp24_;
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp38_ = _tmp29_;
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp39_ = g_strdup_printf ("%d-%02d-%02d", _tmp36_, _tmp37_, _tmp38_);
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp40_ = _tmp39_;
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			rygel_media_item_set_date (_tmp34_, _tmp40_);
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_g_free0 (_tmp40_);
#line 2101 "rygel-media-export-item-factory.c"
		} else {
			RygelMediaItem* _tmp41_ = NULL;
			GstDateTime* _tmp42_ = NULL;
			gchar* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
#line 325 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp41_ = item;
#line 325 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp42_ = dt;
#line 325 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp43_ = gst_date_time_to_iso8601_string (_tmp42_);
#line 325 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_tmp44_ = _tmp43_;
#line 325 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			rygel_media_item_set_date (_tmp41_, _tmp44_);
#line 325 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
			_g_free0 (_tmp44_);
#line 2119 "rygel-media-export-item-factory.c"
		}
	}
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp45_ = item;
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp46_ = title;
#line 329 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_media_object_set_title ((RygelMediaObject*) _tmp45_, _tmp46_);
#line 332 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp47_ = file_info;
#line 332 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp48_ = g_file_info_get_attribute_uint64 (_tmp47_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
#line 332 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	mtime = _tmp48_;
#line 335 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp49_ = item;
#line 335 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp50_ = rygel_media_item_get_date (_tmp49_);
#line 335 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp51_ = _tmp50_;
#line 335 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	if (_tmp51_ == NULL) {
#line 2142 "rygel-media-export-item-factory.c"
		GTimeVal tv = {0};
		guint64 _tmp52_ = 0ULL;
		GTimeVal _tmp53_ = {0};
		RygelMediaItem* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		gchar* _tmp56_ = NULL;
#line 336 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp52_ = mtime;
#line 336 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp53_.tv_sec = (glong) _tmp52_;
#line 336 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp53_.tv_usec = (glong) 0;
#line 336 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		tv = _tmp53_;
#line 337 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp54_ = item;
#line 337 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp55_ = g_time_val_to_iso8601 (&tv);
#line 337 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp56_ = _tmp55_;
#line 337 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		rygel_media_item_set_date (_tmp54_, _tmp56_);
#line 337 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_g_free0 (_tmp56_);
#line 2167 "rygel-media-export-item-factory.c"
	}
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp57_ = item;
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp58_ = rygel_media_item_get_date (_tmp57_);
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp59_ = _tmp58_;
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp60_ = string_contains (_tmp59_, "T");
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	if (_tmp60_) {
#line 2179 "rygel-media-export-item-factory.c"
		SoupDate* date = NULL;
		RygelMediaItem* _tmp61_ = NULL;
		const gchar* _tmp62_ = NULL;
		const gchar* _tmp63_ = NULL;
		SoupDate* _tmp64_ = NULL;
		RygelMediaItem* _tmp65_ = NULL;
		SoupDate* _tmp66_ = NULL;
		gchar* _tmp67_ = NULL;
		gchar* _tmp68_ = NULL;
#line 343 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp61_ = item;
#line 343 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp62_ = rygel_media_item_get_date (_tmp61_);
#line 343 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp63_ = _tmp62_;
#line 343 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp64_ = soup_date_new_from_string (_tmp63_);
#line 343 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		date = _tmp64_;
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp65_ = item;
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp66_ = date;
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp67_ = soup_date_to_string (_tmp66_, SOUP_DATE_ISO8601_FULL);
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp68_ = _tmp67_;
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		rygel_media_item_set_date (_tmp65_, _tmp68_);
#line 344 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_g_free0 (_tmp68_);
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		__vala_SoupDate_free0 (date);
#line 2213 "rygel-media-export-item-factory.c"
	}
#line 347 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp69_ = item;
#line 347 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp70_ = file_info;
#line 347 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp71_ = g_file_info_get_size (_tmp70_);
#line 347 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_media_item_set_size (_tmp69_, (gint64) _tmp71_);
#line 348 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp72_ = item;
#line 348 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp73_ = mtime;
#line 348 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_media_object_set_modified ((RygelMediaObject*) _tmp72_, (guint64) ((gint64) _tmp73_));
#line 349 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp75_ = profile;
#line 349 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	if (_tmp75_ != NULL) {
#line 2233 "rygel-media-export-item-factory.c"
		GUPnPDLNAProfile* _tmp76_ = NULL;
		const gchar* _tmp77_ = NULL;
		const gchar* _tmp78_ = NULL;
#line 349 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp76_ = profile;
#line 349 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp77_ = gupnp_dlna_profile_get_name (_tmp76_);
#line 349 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp78_ = _tmp77_;
#line 349 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp74_ = _tmp78_ != NULL;
#line 2245 "rygel-media-export-item-factory.c"
	} else {
#line 349 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp74_ = FALSE;
#line 2249 "rygel-media-export-item-factory.c"
	}
#line 349 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp79_ = _tmp74_;
#line 349 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	if (_tmp79_) {
#line 2255 "rygel-media-export-item-factory.c"
		RygelMediaItem* _tmp80_ = NULL;
		GUPnPDLNAProfile* _tmp81_ = NULL;
		const gchar* _tmp82_ = NULL;
		const gchar* _tmp83_ = NULL;
		RygelMediaItem* _tmp84_ = NULL;
		GUPnPDLNAProfile* _tmp85_ = NULL;
		const gchar* _tmp86_ = NULL;
		const gchar* _tmp87_ = NULL;
#line 350 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp80_ = item;
#line 350 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp81_ = profile;
#line 350 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp82_ = gupnp_dlna_profile_get_name (_tmp81_);
#line 350 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp83_ = _tmp82_;
#line 350 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		rygel_media_item_set_dlna_profile (_tmp80_, _tmp83_);
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp84_ = item;
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp85_ = profile;
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp86_ = gupnp_dlna_profile_get_mime (_tmp85_);
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp87_ = _tmp86_;
#line 351 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		rygel_media_item_set_mime_type (_tmp84_, _tmp87_);
#line 2284 "rygel-media-export-item-factory.c"
	} else {
		RygelMediaItem* _tmp88_ = NULL;
		GFileInfo* _tmp89_ = NULL;
		const gchar* _tmp90_ = NULL;
		gchar* _tmp91_ = NULL;
		gchar* _tmp92_ = NULL;
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp88_ = item;
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp89_ = file_info;
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp90_ = g_file_info_get_content_type (_tmp89_);
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp91_ = g_content_type_get_mime_type (_tmp90_);
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_tmp92_ = _tmp91_;
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		rygel_media_item_set_mime_type (_tmp88_, _tmp92_);
#line 353 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
		_g_free0 (_tmp92_);
#line 2305 "rygel-media-export-item-factory.c"
	}
#line 357 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp93_ = item;
#line 357 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp94_ = file;
#line 357 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp95_ = g_file_get_uri (_tmp94_);
#line 357 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_tmp96_ = _tmp95_;
#line 357 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	rygel_media_item_add_uri (_tmp93_, _tmp96_);
#line 357 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_g_free0 (_tmp96_);
#line 299 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_gst_date_time_unref0 (dt);
#line 299 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_gst_tag_list_unref0 (tags);
#line 299 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-item-factory.vala"
	_g_free0 (title);
#line 2325 "rygel-media-export-item-factory.c"
}



