/* rygel-http-get.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-http-get.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2006, 2007, 2008 OpenedHand Ltd.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jorn Baayen <jorn.baayen@gmail.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
#define _rygel_thumbnail_unref0(var) ((var == NULL) ? NULL : (var = (rygel_thumbnail_unref (var), NULL)))
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_http_get_handler_unref0(var) ((var == NULL) ? NULL : (var = (rygel_http_get_handler_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;

#define RYGEL_TYPE_HTTP_TRANSCODE_HANDLER (rygel_http_transcode_handler_get_type ())
#define RYGEL_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandler))
#define RYGEL_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_HTTP_TRANSCODE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))

typedef struct _RygelHTTPTranscodeHandler RygelHTTPTranscodeHandler;
typedef struct _RygelHTTPTranscodeHandlerClass RygelHTTPTranscodeHandlerClass;

#define RYGEL_TYPE_HTTP_PLAYLIST_HANDLER (rygel_http_playlist_handler_get_type ())
#define RYGEL_HTTP_PLAYLIST_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, RygelHTTPPlaylistHandler))
#define RYGEL_HTTP_PLAYLIST_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, RygelHTTPPlaylistHandlerClass))
#define RYGEL_IS_HTTP_PLAYLIST_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER))
#define RYGEL_IS_HTTP_PLAYLIST_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER))
#define RYGEL_HTTP_PLAYLIST_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, RygelHTTPPlaylistHandlerClass))

typedef struct _RygelHTTPPlaylistHandler RygelHTTPPlaylistHandler;
typedef struct _RygelHTTPPlaylistHandlerClass RygelHTTPPlaylistHandlerClass;

#define RYGEL_TYPE_HTTP_IDENTITY_HANDLER (rygel_http_identity_handler_get_type ())
#define RYGEL_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandler))
#define RYGEL_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_HTTP_IDENTITY_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))

typedef struct _RygelHTTPIdentityHandler RygelHTTPIdentityHandler;
typedef struct _RygelHTTPIdentityHandlerClass RygelHTTPIdentityHandlerClass;
typedef struct _RygelHttpGetHandleData RygelHttpGetHandleData;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;
#define _rygel_media_object_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_object_unref (var), NULL)))

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;
typedef struct _RygelHttpGetFindItemData RygelHttpGetFindItemData;

#define RYGEL_TYPE_HTTP_TIME_SEEK (rygel_http_time_seek_get_type ())
#define RYGEL_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeek))
#define RYGEL_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))
#define RYGEL_IS_HTTP_TIME_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_IS_HTTP_TIME_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK))
#define RYGEL_HTTP_TIME_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK, RygelHTTPTimeSeekClass))

typedef struct _RygelHTTPTimeSeek RygelHTTPTimeSeek;
typedef struct _RygelHTTPTimeSeekClass RygelHTTPTimeSeekClass;

#define RYGEL_TYPE_HTTP_BYTE_SEEK (rygel_http_byte_seek_get_type ())
#define RYGEL_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeek))
#define RYGEL_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))
#define RYGEL_IS_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_IS_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_HTTP_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))

typedef struct _RygelHTTPByteSeek RygelHTTPByteSeek;
typedef struct _RygelHTTPByteSeekClass RygelHTTPByteSeekClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelHttpGetHandleItemRequestData RygelHttpGetHandleItemRequestData;

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPSeek* seek;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

struct _RygelHTTPGetPrivate {
	gint thumbnail_index;
	gint subtitle_index;
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHttpGetHandleData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGet* self;
	gchar* header;
	SoupMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	SoupMessage* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	SoupMessage* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	const gchar* _tmp21_;
	GError* _tmp22_;
	RygelHTTPItemURI* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	RygelTranscoder* transcoder;
	RygelHTTPServer* _tmp26_;
	RygelHTTPItemURI* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	RygelTranscoder* _tmp30_;
	RygelTranscoder* _tmp31_;
	GCancellable* _tmp32_;
	GCancellable* _tmp33_;
	RygelHTTPTranscodeHandler* _tmp34_;
	gboolean _tmp35_;
	RygelHTTPItemURI* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	RygelHTTPItemURI* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	RygelHTTPItemURI* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	GCancellable* _tmp47_;
	GCancellable* _tmp48_;
	RygelHTTPPlaylistHandler* _tmp49_;
	RygelHTTPGetHandler* _tmp50_;
	GCancellable* _tmp51_;
	GCancellable* _tmp52_;
	RygelHTTPIdentityHandler* _tmp53_;
	GError * _inner_error_;
};

struct _RygelMediaObject {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* mime_type;
};

struct _RygelMediaObjectClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaObject *self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	glong size;
	GeeArrayList* uris;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	gint64 duration;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelMusicItem {
	RygelAudioItem parent_instance;
	RygelMusicItemPrivate * priv;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelVideoItem {
	RygelAudioItem parent_instance;
	RygelVideoItemPrivate * priv;
	GeeArrayList* subtitles;
};

struct _RygelVideoItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelHttpGetFindItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGet* self;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	RygelMediaObject* _tmp4_;
	const gchar* _tmp5_;
	GError* _tmp6_;
	RygelClientHacks* _tmp7_;
	RygelClientHacks* _tmp8_;
	RygelMediaObject* _tmp9_;
	RygelHTTPItemURI* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	RygelMediaObject* _tmp13_;
	RygelMusicItem* music;
	RygelMediaObject* _tmp14_;
	RygelMusicItem* _tmp15_;
	RygelMusicItem* _tmp16_;
	RygelThumbnail* _tmp17_;
	RygelThumbnail* _tmp18_;
	RygelMediaObject* _tmp19_;
	RygelVisualItem* visual;
	RygelMediaObject* _tmp20_;
	RygelVisualItem* _tmp21_;
	RygelHTTPItemURI* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	RygelVisualItem* _tmp25_;
	GeeArrayList* _tmp26_;
	GeeArrayList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	RygelVisualItem* _tmp30_;
	GeeArrayList* _tmp31_;
	GeeArrayList* _tmp32_;
	RygelHTTPItemURI* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	gpointer _tmp36_;
	RygelMediaObject* _tmp37_;
	const gchar* _tmp38_;
	GError* _tmp39_;
	gboolean _tmp40_;
	RygelHTTPItemURI* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	RygelMediaObject* _tmp44_;
	gboolean _tmp45_;
	RygelVideoItem* video;
	RygelMediaObject* _tmp46_;
	RygelVideoItem* _tmp47_;
	RygelHTTPItemURI* _tmp48_;
	gint _tmp49_;
	gint _tmp50_;
	RygelVideoItem* _tmp51_;
	GeeArrayList* _tmp52_;
	gint _tmp53_;
	gint _tmp54_;
	RygelVideoItem* _tmp55_;
	GeeArrayList* _tmp56_;
	RygelHTTPItemURI* _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
	gpointer _tmp60_;
	RygelMediaObject* _tmp61_;
	const gchar* _tmp62_;
	GError* _tmp63_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()
struct _RygelHttpGetHandleItemRequestData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGet* self;
	gboolean need_time_seek;
	gboolean _tmp0_;
	gboolean requested_time_seek;
	gboolean _tmp1_;
	gboolean need_byte_seek;
	gboolean _tmp2_;
	gboolean requested_byte_seek;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GError* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	RygelHTTPTimeSeek* _tmp19_;
	RygelHTTPTimeSeek* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	RygelHTTPByteSeek* _tmp25_;
	RygelHTTPByteSeek* _tmp26_;
	GError* _error_;
	SoupServer* _tmp27_;
	SoupMessage* _tmp28_;
	GError* _tmp29_;
	GError* _tmp30_;
	GError* _tmp31_;
	GError* _tmp32_;
	RygelHTTPGetHandler* _tmp33_;
	SoupMessage* _tmp34_;
	SoupMessageHeaders* _tmp35_;
	const gchar* _tmp36_;
	SoupMessage* _tmp37_;
	SoupMessage* _tmp38_;
	RygelHTTPGetHandler* _tmp39_;
	gboolean _tmp40_;
	SoupMessage* _tmp41_;
	SoupMessageHeaders* _tmp42_;
	SoupMessage* _tmp43_;
	SoupMessageHeaders* _tmp44_;
	SoupMessage* _tmp45_;
	SoupMessageHeaders* _tmp46_;
	SoupMessage* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gboolean _tmp51_;
	SoupServer* _tmp52_;
	SoupMessage* _tmp53_;
	RygelHTTPResponse* response;
	RygelHTTPGetHandler* _tmp54_;
	RygelHTTPResponse* _tmp55_;
	RygelHTTPResponse* _tmp56_;
	GError * _inner_error_;
};


static gpointer rygel_http_get_parent_class = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
gpointer rygel_media_object_ref (gpointer instance);
void rygel_media_object_unref (gpointer instance);
GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_media_object (GValue* value, gpointer v_object);
void rygel_value_take_media_object (GValue* value, gpointer v_object);
gpointer rygel_value_get_media_object (const GValue* value);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
gpointer rygel_client_hacks_ref (gpointer instance);
void rygel_client_hacks_unref (gpointer instance);
GParamSpec* rygel_param_spec_client_hacks (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_client_hacks (GValue* value, gpointer v_object);
void rygel_value_take_client_hacks (GValue* value, gpointer v_object);
gpointer rygel_value_get_client_hacks (const GValue* value);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
gpointer rygel_thumbnail_ref (gpointer instance);
void rygel_thumbnail_unref (gpointer instance);
GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_thumbnail (GValue* value, gpointer v_object);
void rygel_value_take_thumbnail (GValue* value, gpointer v_object);
gpointer rygel_value_get_thumbnail (const GValue* value);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
gpointer rygel_http_get_handler_ref (gpointer instance);
void rygel_http_get_handler_unref (gpointer instance);
GParamSpec* rygel_param_spec_http_get_handler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_http_get_handler (GValue* value, gpointer v_object);
void rygel_value_take_http_get_handler (GValue* value, gpointer v_object);
gpointer rygel_value_get_http_get_handler (const GValue* value);
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_GET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_GET, RygelHTTPGetPrivate))
enum  {
	RYGEL_HTTP_GET_DUMMY_PROPERTY
};
#define RYGEL_HTTP_GET_TRANSFER_MODE_HEADER "transferMode.dlna.org"
RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPRequest* rygel_http_request_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
static void rygel_http_get_real_handle_data_free (gpointer _data);
static void rygel_http_get_real_handle (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_get_real_handle_co (RygelHttpGetHandleData* _data_);
GQuark rygel_http_request_error_quark (void);
const gchar* rygel_http_item_uri_get_transcode_target (RygelHTTPItemURI* self);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (RygelTranscoder* transcoder, GCancellable* cancellable);
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type, RygelTranscoder* transcoder, GCancellable* cancellable);
GType rygel_http_transcode_handler_get_type (void) G_GNUC_CONST;
const gchar* rygel_http_item_uri_get_playlist_format (RygelHTTPItemURI* self);
gboolean rygel_http_playlist_handler_is_supported (const gchar* arg);
RygelHTTPPlaylistHandler* rygel_http_playlist_handler_new (const gchar* arg, GCancellable* cancellable);
RygelHTTPPlaylistHandler* rygel_http_playlist_handler_construct (GType object_type, const gchar* arg, GCancellable* cancellable);
GType rygel_http_playlist_handler_get_type (void) G_GNUC_CONST;
RygelHTTPIdentityHandler* rygel_http_identity_handler_new (GCancellable* cancellable);
RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type, GCancellable* cancellable);
GType rygel_http_identity_handler_get_type (void) G_GNUC_CONST;
static void rygel_http_get_ensure_correct_mode (RygelHTTPGet* self, GError** error);
static void rygel_http_get_handle_item_request (RygelHTTPGet* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_get_handle_item_request_finish (RygelHTTPGet* self, GAsyncResult* _res_, GError** error);
static void rygel_http_get_handle_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_http_get_real_find_item_data_free (gpointer _data);
static void rygel_http_get_real_find_item (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_get_real_find_item_co (RygelHttpGetFindItemData* _data_);
void rygel_http_request_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_http_request_find_item_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
static void rygel_http_get_find_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
void rygel_client_hacks_apply (RygelClientHacks* self, RygelMediaObject* item);
gint rygel_http_item_uri_get_thumbnail_index (RygelHTTPItemURI* self);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
gint rygel_http_item_uri_get_subtitle_index (RygelHTTPItemURI* self);
GType rygel_video_item_get_type (void) G_GNUC_CONST;
static void rygel_http_get_handle_item_request_data_free (gpointer _data);
static gboolean rygel_http_get_handle_item_request_co (RygelHttpGetHandleItemRequestData* _data_);
gboolean rygel_http_time_seek_needed (RygelHTTPGet* request);
gboolean rygel_http_time_seek_requested (RygelHTTPGet* request);
gboolean rygel_http_byte_seek_needed (RygelHTTPGet* request);
gboolean rygel_http_byte_seek_requested (RygelHTTPGet* request);
GType rygel_http_time_seek_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_error_quark (void);
RygelHTTPTimeSeek* rygel_http_time_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPTimeSeek* rygel_http_time_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_http_byte_seek_get_type (void) G_GNUC_CONST;
RygelHTTPByteSeek* rygel_http_byte_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
void rygel_http_request_end (RygelHTTPRequest* self, guint status);
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* get_request);
gboolean rygel_http_get_handler_knows_size (RygelHTTPGetHandler* self, RygelHTTPGet* request);
static void __lambda4_ (RygelHTTPGet* self, const gchar* name, const gchar* value);
static void ___lambda4__soup_message_headers_foreach_func (const gchar* name, const gchar* value, gpointer self);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* get_request);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
static void rygel_http_get_handle_item_request_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean rygel_media_item_streamable (RygelMediaItem* self);
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
static void rygel_http_get_finalize (GObject* obj);


RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
	RygelHTTPGet * self = NULL;
	RygelHTTPServer* _tmp0_ = NULL;
	SoupServer* _tmp1_ = NULL;
	SoupMessage* _tmp2_ = NULL;
#line 43 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 43 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	g_return_val_if_fail (server != NULL, NULL);
#line 43 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_tmp0_ = http_server;
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_tmp1_ = server;
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_tmp2_ = msg;
#line 46 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	self = (RygelHTTPGet*) rygel_http_request_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
#line 48 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	self->priv->thumbnail_index = -1;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	self->priv->subtitle_index = -1;
#line 43 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	return self;
#line 776 "rygel-http-get.c"
}


RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
#line 43 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	return rygel_http_get_construct (RYGEL_TYPE_HTTP_GET, http_server, server, msg);
#line 783 "rygel-http-get.c"
}


static void rygel_http_get_real_handle_data_free (gpointer _data) {
	RygelHttpGetHandleData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	g_slice_free (RygelHttpGetHandleData, _data_);
#line 794 "rygel-http-get.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	return self ? g_object_ref (self) : NULL;
#line 801 "rygel-http-get.c"
}


static void rygel_http_get_real_handle (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPGet * self;
	RygelHttpGetHandleData* _data_;
	RygelHTTPGet* _tmp0_ = NULL;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	self = (RygelHTTPGet*) base;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_ = g_slice_new0 (RygelHttpGetHandleData);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_real_handle);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_real_handle_data_free);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	rygel_http_get_real_handle_co (_data_);
#line 823 "rygel-http-get.c"
}


static void rygel_http_get_real_handle_finish (RygelHTTPRequest* base, GAsyncResult* _res_, GError** error) {
	RygelHttpGetHandleData* _data_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		return;
#line 833 "rygel-http-get.c"
	}
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 837 "rygel-http-get.c"
}


static void rygel_http_get_handle_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetHandleData* _data_;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_ = _user_data_;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_source_object_ = source_object;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_res_ = _res_;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	rygel_http_get_real_handle_co (_data_);
#line 851 "rygel-http-get.c"
}


static gboolean rygel_http_get_real_handle_co (RygelHttpGetHandleData* _data_) {
#line 52 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	switch (_data_->_state_) {
#line 52 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		case 0:
#line 860 "rygel-http-get.c"
		goto _state_0;
#line 52 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		case 1:
#line 864 "rygel-http-get.c"
		goto _state_1;
		default:
#line 52 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_assert_not_reached ();
#line 869 "rygel-http-get.c"
	}
	_state_0:
#line 53 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp0_ = NULL;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp0_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp1_ = NULL;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp1_ = _data_->_tmp0_->request_headers;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp2_ = NULL;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp2_ = soup_message_headers_get_one (_data_->_tmp1_, "getcontentFeatures.dlna.org");
#line 53 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp3_ = NULL;
#line 53 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
#line 53 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->header = _data_->_tmp3_;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp6_ = NULL;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp6_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp7_ = NULL;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	g_object_get (_data_->_tmp6_, "method", &_data_->_tmp7_, NULL);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp8_ = NULL;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp8_ = _data_->_tmp7_;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp9_ = NULL;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp9_ = _data_->_tmp8_;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp10_ = FALSE;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp10_ = g_strcmp0 (_data_->_tmp9_, "HEAD") != 0;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_g_free0 (_data_->_tmp9_);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_tmp10_) {
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp11_ = NULL;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp11_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp12_ = NULL;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_object_get (_data_->_tmp11_, "method", &_data_->_tmp12_, NULL);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp13_ = NULL;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp13_ = _data_->_tmp12_;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp14_ = NULL;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp14_ = _data_->_tmp13_;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp5_ = g_strcmp0 (_data_->_tmp14_, "GET") != 0;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_g_free0 (_data_->_tmp14_);
#line 934 "rygel-http-get.c"
	} else {
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp5_ = FALSE;
#line 938 "rygel-http-get.c"
	}
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp15_ = FALSE;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp15_ = _data_->_tmp5_;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_tmp15_) {
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp4_ = TRUE;
#line 948 "rygel-http-get.c"
	} else {
#line 58 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp17_ = NULL;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp17_ = _data_->header;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		if (_data_->_tmp17_ != NULL) {
#line 58 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp18_ = NULL;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp18_ = _data_->header;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp16_ = g_strcmp0 (_data_->_tmp18_, "1") != 0;
#line 962 "rygel-http-get.c"
		} else {
#line 58 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp16_ = FALSE;
#line 966 "rygel-http-get.c"
		}
#line 58 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp19_ = FALSE;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp19_ = _data_->_tmp16_;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp4_ = _data_->_tmp19_;
#line 974 "rygel-http-get.c"
	}
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp20_ = FALSE;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp20_ = _data_->_tmp4_;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_tmp20_) {
#line 59 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp21_ = NULL;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp21_ = _ ("Invalid Request");
#line 59 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp22_ = NULL;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp22_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _data_->_tmp21_);
#line 59 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_inner_error_ = _data_->_tmp22_;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 59 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_error_free (_data_->_inner_error_);
#line 59 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_g_free0 (_data_->header);
#line 59 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 59 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1002 "rygel-http-get.c"
		} else {
#line 59 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1006 "rygel-http-get.c"
		}
#line 59 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 59 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		return FALSE;
#line 1012 "rygel-http-get.c"
	}
#line 62 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp23_ = NULL;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp23_ = ((RygelHTTPRequest*) _data_->self)->uri;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp24_ = NULL;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp24_ = rygel_http_item_uri_get_transcode_target (_data_->_tmp23_);
#line 62 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp25_ = NULL;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp25_ = _data_->_tmp24_;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_tmp25_ != NULL) {
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp26_ = NULL;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp26_ = ((RygelHTTPRequest*) _data_->self)->http_server;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp27_ = NULL;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp27_ = ((RygelHTTPRequest*) _data_->self)->uri;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp28_ = NULL;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp28_ = rygel_http_item_uri_get_transcode_target (_data_->_tmp27_);
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp29_ = NULL;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp29_ = _data_->_tmp28_;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp30_ = NULL;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp30_ = rygel_http_server_get_transcoder (_data_->_tmp26_, _data_->_tmp29_, &_data_->_inner_error_);
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->transcoder = _data_->_tmp30_;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		if (_data_->_inner_error_ != NULL) {
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_error_free (_data_->_inner_error_);
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_g_free0 (_data_->header);
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			if (_data_->_state_ == 0) {
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1062 "rygel-http-get.c"
			} else {
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1066 "rygel-http-get.c"
			}
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_object_unref (_data_->_async_result);
#line 63 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			return FALSE;
#line 1072 "rygel-http-get.c"
		}
#line 65 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp31_ = NULL;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp31_ = _data_->transcoder;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp32_ = NULL;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp32_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 65 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp33_ = NULL;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp33_ = _data_->_tmp32_;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp34_ = NULL;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp34_ = rygel_http_transcode_handler_new (_data_->_tmp31_, _data_->_tmp33_);
#line 65 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_rygel_http_get_handler_unref0 (_data_->self->handler);
#line 65 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->self->handler = (RygelHTTPGetHandler*) _data_->_tmp34_;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_g_object_unref0 (_data_->transcoder);
#line 1096 "rygel-http-get.c"
	}
#line 69 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp36_ = NULL;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp36_ = ((RygelHTTPRequest*) _data_->self)->uri;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp37_ = NULL;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp37_ = rygel_http_item_uri_get_playlist_format (_data_->_tmp36_);
#line 69 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp38_ = NULL;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp38_ = _data_->_tmp37_;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_tmp38_ != NULL) {
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp39_ = NULL;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp39_ = ((RygelHTTPRequest*) _data_->self)->uri;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp40_ = NULL;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp40_ = rygel_http_item_uri_get_playlist_format (_data_->_tmp39_);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp41_ = NULL;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp41_ = _data_->_tmp40_;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp42_ = FALSE;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp42_ = rygel_http_playlist_handler_is_supported (_data_->_tmp41_);
#line 70 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp35_ = _data_->_tmp42_;
#line 1130 "rygel-http-get.c"
	} else {
#line 69 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp35_ = FALSE;
#line 1134 "rygel-http-get.c"
	}
#line 69 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp43_ = FALSE;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp43_ = _data_->_tmp35_;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_tmp43_) {
#line 71 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp44_ = NULL;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp44_ = ((RygelHTTPRequest*) _data_->self)->uri;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp45_ = NULL;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp45_ = rygel_http_item_uri_get_playlist_format (_data_->_tmp44_);
#line 71 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp46_ = NULL;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp46_ = _data_->_tmp45_;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp47_ = NULL;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp47_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 71 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp48_ = NULL;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp48_ = _data_->_tmp47_;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp49_ = NULL;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp49_ = rygel_http_playlist_handler_new (_data_->_tmp46_, _data_->_tmp48_);
#line 71 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_rygel_http_get_handler_unref0 (_data_->self->handler);
#line 71 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->self->handler = (RygelHTTPGetHandler*) _data_->_tmp49_;
#line 1170 "rygel-http-get.c"
	}
#line 75 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp50_ = NULL;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp50_ = _data_->self->handler;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_tmp50_ == NULL) {
#line 76 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp51_ = NULL;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp51_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 76 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp52_ = NULL;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp52_ = _data_->_tmp51_;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp53_ = NULL;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp53_ = rygel_http_identity_handler_new (_data_->_tmp52_);
#line 76 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_rygel_http_get_handler_unref0 (_data_->self->handler);
#line 76 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->self->handler = (RygelHTTPGetHandler*) _data_->_tmp53_;
#line 1194 "rygel-http-get.c"
	}
#line 79 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	rygel_http_get_ensure_correct_mode (_data_->self, &_data_->_inner_error_);
#line 79 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_inner_error_ != NULL) {
#line 79 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 79 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_error_free (_data_->_inner_error_);
#line 79 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_g_free0 (_data_->header);
#line 79 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 79 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1210 "rygel-http-get.c"
		} else {
#line 79 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1214 "rygel-http-get.c"
		}
#line 79 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 79 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		return FALSE;
#line 1220 "rygel-http-get.c"
	}
#line 81 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_state_ = 1;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	rygel_http_get_handle_item_request (_data_->self, rygel_http_get_handle_ready, _data_);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	return FALSE;
#line 1228 "rygel-http-get.c"
	_state_1:
#line 81 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	rygel_http_get_handle_item_request_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_inner_error_ != NULL) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_error_free (_data_->_inner_error_);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_g_free0 (_data_->header);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1244 "rygel-http-get.c"
		} else {
#line 81 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1248 "rygel-http-get.c"
		}
#line 81 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 81 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		return FALSE;
#line 1254 "rygel-http-get.c"
	}
#line 52 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_g_free0 (_data_->header);
#line 52 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_state_ == 0) {
#line 52 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1262 "rygel-http-get.c"
	} else {
#line 52 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1266 "rygel-http-get.c"
	}
#line 52 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	g_object_unref (_data_->_async_result);
#line 52 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	return FALSE;
#line 1272 "rygel-http-get.c"
}


static void rygel_http_get_real_find_item_data_free (gpointer _data) {
	RygelHttpGetFindItemData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	g_slice_free (RygelHttpGetFindItemData, _data_);
#line 1283 "rygel-http-get.c"
}


static void rygel_http_get_real_find_item (RygelHTTPRequest* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPGet * self;
	RygelHttpGetFindItemData* _data_;
	RygelHTTPGet* _tmp0_ = NULL;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	self = (RygelHTTPGet*) base;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_ = g_slice_new0 (RygelHttpGetFindItemData);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_real_find_item);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_real_find_item_data_free);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	rygel_http_get_real_find_item_co (_data_);
#line 1305 "rygel-http-get.c"
}


static void rygel_http_get_real_find_item_finish (RygelHTTPRequest* base, GAsyncResult* _res_, GError** error) {
	RygelHttpGetFindItemData* _data_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		return;
#line 1315 "rygel-http-get.c"
	}
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1319 "rygel-http-get.c"
}


static void rygel_http_get_find_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetFindItemData* _data_;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_ = _user_data_;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_source_object_ = source_object;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_res_ = _res_;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	rygel_http_get_real_find_item_co (_data_);
#line 1333 "rygel-http-get.c"
}


static gpointer _rygel_media_object_ref0 (gpointer self) {
#line 103 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	return self ? rygel_media_object_ref (self) : NULL;
#line 1340 "rygel-http-get.c"
}


static gpointer _rygel_thumbnail_ref0 (gpointer self) {
#line 104 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	return self ? rygel_thumbnail_ref (self) : NULL;
#line 1347 "rygel-http-get.c"
}


static gboolean rygel_http_get_real_find_item_co (RygelHttpGetFindItemData* _data_) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	switch (_data_->_state_) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		case 0:
#line 1356 "rygel-http-get.c"
		goto _state_0;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		case 1:
#line 1360 "rygel-http-get.c"
		goto _state_1;
		default:
#line 84 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_assert_not_reached ();
#line 1365 "rygel-http-get.c"
	}
	_state_0:
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_state_ = 1;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	RYGEL_HTTP_REQUEST_CLASS (rygel_http_get_parent_class)->find_item (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest), rygel_http_get_find_item_ready, _data_);
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	return FALSE;
#line 1374 "rygel-http-get.c"
	_state_1:
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	RYGEL_HTTP_REQUEST_CLASS (rygel_http_get_parent_class)->find_item_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest), _data_->_res_, &_data_->_inner_error_);
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_inner_error_ != NULL) {
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_error_free (_data_->_inner_error_);
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1388 "rygel-http-get.c"
		} else {
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1392 "rygel-http-get.c"
		}
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 85 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		return FALSE;
#line 1398 "rygel-http-get.c"
	}
#line 88 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp0_ = NULL;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp0_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp0_, RYGEL_TYPE_MEDIA_CONTAINER)) {
#line 89 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 89 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1410 "rygel-http-get.c"
		} else {
#line 89 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1414 "rygel-http-get.c"
		}
#line 89 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		return FALSE;
#line 1420 "rygel-http-get.c"
	}
#line 92 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp1_ = NULL;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp1_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp2_ = FALSE;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp2_ = (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _data_->_tmp1_) : NULL)->place_holder;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp3_ = FALSE;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp3_ = G_UNLIKELY (_data_->_tmp2_);
#line 92 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_tmp3_) {
#line 93 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp4_ = NULL;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp4_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp5_ = NULL;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp5_ = _data_->_tmp4_->id;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp6_ = NULL;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp6_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "Item '%s' is empty", _data_->_tmp5_);
#line 93 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_inner_error_ = _data_->_tmp6_;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 93 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_error_free (_data_->_inner_error_);
#line 93 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 93 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1458 "rygel-http-get.c"
		} else {
#line 93 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1462 "rygel-http-get.c"
		}
#line 93 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 93 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		return FALSE;
#line 1468 "rygel-http-get.c"
	}
#line 97 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp7_ = NULL;
#line 97 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp7_ = ((RygelHTTPRequest*) _data_->self)->hack;
#line 97 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_tmp7_ != NULL) {
#line 98 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp8_ = NULL;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp8_ = ((RygelHTTPRequest*) _data_->self)->hack;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp9_ = NULL;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp9_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		rygel_client_hacks_apply (_data_->_tmp8_, _data_->_tmp9_);
#line 1486 "rygel-http-get.c"
	}
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp10_ = NULL;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp10_ = ((RygelHTTPRequest*) _data_->self)->uri;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp11_ = 0;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp11_ = rygel_http_item_uri_get_thumbnail_index (_data_->_tmp10_);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp12_ = 0;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp12_ = _data_->_tmp11_;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_tmp12_ >= 0) {
#line 102 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp13_ = NULL;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp13_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 102 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp13_, RYGEL_TYPE_MUSIC_ITEM)) {
#line 103 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp14_ = NULL;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp14_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp15_ = NULL;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp15_ = _rygel_media_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp14_, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) _data_->_tmp14_) : NULL);
#line 103 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->music = _data_->_tmp15_;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp16_ = NULL;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp16_ = _data_->music;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp17_ = NULL;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp17_ = _data_->_tmp16_->album_art;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp18_ = NULL;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp18_ = _rygel_thumbnail_ref0 (_data_->_tmp17_);
#line 104 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_rygel_thumbnail_unref0 (_data_->self->thumbnail);
#line 104 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->self->thumbnail = _data_->_tmp18_;
#line 106 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_rygel_media_object_unref0 (_data_->music);
#line 106 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			if (_data_->_state_ == 0) {
#line 106 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1540 "rygel-http-get.c"
			} else {
#line 106 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1544 "rygel-http-get.c"
			}
#line 106 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_object_unref (_data_->_async_result);
#line 106 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			return FALSE;
#line 1550 "rygel-http-get.c"
		} else {
#line 107 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp19_ = NULL;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp19_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp19_, RYGEL_TYPE_VISUAL_ITEM)) {
#line 108 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp20_ = NULL;
#line 108 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp20_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 108 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp21_ = NULL;
#line 108 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp21_ = _rygel_media_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp20_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _data_->_tmp20_) : NULL);
#line 108 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->visual = _data_->_tmp21_;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp22_ = NULL;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp22_ = ((RygelHTTPRequest*) _data_->self)->uri;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp23_ = 0;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp23_ = rygel_http_item_uri_get_thumbnail_index (_data_->_tmp22_);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp24_ = 0;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp24_ = _data_->_tmp23_;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp25_ = NULL;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp25_ = _data_->visual;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp26_ = NULL;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp26_ = rygel_visual_item_get_thumbnails (_data_->_tmp25_);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp27_ = NULL;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp27_ = _data_->_tmp26_;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp28_ = 0;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp28_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp27_);
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp29_ = 0;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp29_ = _data_->_tmp28_;
#line 109 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				if (_data_->_tmp24_ < _data_->_tmp29_) {
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_data_->_tmp30_ = NULL;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_data_->_tmp30_ = _data_->visual;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_data_->_tmp31_ = NULL;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_data_->_tmp31_ = rygel_visual_item_get_thumbnails (_data_->_tmp30_);
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_data_->_tmp32_ = NULL;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_data_->_tmp32_ = _data_->_tmp31_;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_data_->_tmp33_ = NULL;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_data_->_tmp33_ = ((RygelHTTPRequest*) _data_->self)->uri;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_data_->_tmp34_ = 0;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_data_->_tmp34_ = rygel_http_item_uri_get_thumbnail_index (_data_->_tmp33_);
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_data_->_tmp35_ = 0;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_data_->_tmp35_ = _data_->_tmp34_;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_data_->_tmp36_ = NULL;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_data_->_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp32_, _data_->_tmp35_);
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_rygel_thumbnail_unref0 (_data_->self->thumbnail);
#line 110 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_data_->self->thumbnail = (RygelThumbnail*) _data_->_tmp36_;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_rygel_media_object_unref0 (_data_->visual);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					if (_data_->_state_ == 0) {
#line 113 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
						g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1640 "rygel-http-get.c"
					} else {
#line 113 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
						g_simple_async_result_complete (_data_->_async_result);
#line 1644 "rygel-http-get.c"
					}
#line 113 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					g_object_unref (_data_->_async_result);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					return FALSE;
#line 1650 "rygel-http-get.c"
				}
#line 107 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_rygel_media_object_unref0 (_data_->visual);
#line 1654 "rygel-http-get.c"
			}
		}
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp37_ = NULL;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp37_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp38_ = NULL;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp38_ = _data_->_tmp37_->id;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp39_ = NULL;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp39_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "No Thumbnail available for item '%s", _data_->_tmp38_);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_inner_error_ = _data_->_tmp39_;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_error_free (_data_->_inner_error_);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1679 "rygel-http-get.c"
		} else {
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1683 "rygel-http-get.c"
		}
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		return FALSE;
#line 1689 "rygel-http-get.c"
	}
#line 122 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp41_ = NULL;
#line 122 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp41_ = ((RygelHTTPRequest*) _data_->self)->uri;
#line 122 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp42_ = 0;
#line 122 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp42_ = rygel_http_item_uri_get_subtitle_index (_data_->_tmp41_);
#line 122 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp43_ = 0;
#line 122 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp43_ = _data_->_tmp42_;
#line 122 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_tmp43_ >= 0) {
#line 122 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp44_ = NULL;
#line 122 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp44_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 122 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp40_ = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp44_, RYGEL_TYPE_VIDEO_ITEM);
#line 1711 "rygel-http-get.c"
	} else {
#line 122 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp40_ = FALSE;
#line 1715 "rygel-http-get.c"
	}
#line 122 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp45_ = FALSE;
#line 122 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp45_ = _data_->_tmp40_;
#line 122 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_tmp45_) {
#line 123 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp46_ = NULL;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp46_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp47_ = NULL;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp47_ = _rygel_media_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp46_, RYGEL_TYPE_VIDEO_ITEM) ? ((RygelVideoItem*) _data_->_tmp46_) : NULL);
#line 123 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->video = _data_->_tmp47_;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp48_ = NULL;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp48_ = ((RygelHTTPRequest*) _data_->self)->uri;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp49_ = 0;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp49_ = rygel_http_item_uri_get_subtitle_index (_data_->_tmp48_);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp50_ = 0;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp50_ = _data_->_tmp49_;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp51_ = NULL;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp51_ = _data_->video;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp52_ = NULL;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp52_ = _data_->_tmp51_->subtitles;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp53_ = 0;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp53_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp52_);
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp54_ = 0;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp54_ = _data_->_tmp53_;
#line 125 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		if (_data_->_tmp50_ < _data_->_tmp54_) {
#line 126 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp55_ = NULL;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp55_ = _data_->video;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp56_ = NULL;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp56_ = _data_->_tmp55_->subtitles;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp57_ = NULL;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp57_ = ((RygelHTTPRequest*) _data_->self)->uri;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp58_ = 0;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp58_ = rygel_http_item_uri_get_subtitle_index (_data_->_tmp57_);
#line 126 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp59_ = 0;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp59_ = _data_->_tmp58_;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp60_ = NULL;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp60_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp56_, _data_->_tmp59_);
#line 126 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_rygel_subtitle_unref0 (_data_->self->subtitle);
#line 126 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->self->subtitle = (RygelSubtitle*) _data_->_tmp60_;
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_rygel_media_object_unref0 (_data_->video);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			if (_data_->_state_ == 0) {
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1797 "rygel-http-get.c"
			} else {
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1801 "rygel-http-get.c"
			}
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_object_unref (_data_->_async_result);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			return FALSE;
#line 1807 "rygel-http-get.c"
		}
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp61_ = NULL;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp61_ = ((RygelHTTPRequest*) _data_->self)->object;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp62_ = NULL;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp62_ = _data_->_tmp61_->id;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp63_ = NULL;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp63_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "No subtitles available for item '%s", _data_->_tmp62_);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_inner_error_ = _data_->_tmp63_;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_error_free (_data_->_inner_error_);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_rygel_media_object_unref0 (_data_->video);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1833 "rygel-http-get.c"
		} else {
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1837 "rygel-http-get.c"
		}
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		return FALSE;
#line 1843 "rygel-http-get.c"
	}
#line 84 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_state_ == 0) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1849 "rygel-http-get.c"
	} else {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1853 "rygel-http-get.c"
	}
#line 84 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	g_object_unref (_data_->_async_result);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	return FALSE;
#line 1859 "rygel-http-get.c"
}


static void rygel_http_get_handle_item_request_data_free (gpointer _data) {
	RygelHttpGetHandleItemRequestData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	g_slice_free (RygelHttpGetHandleItemRequestData, _data_);
#line 1870 "rygel-http-get.c"
}


static void rygel_http_get_handle_item_request (RygelHTTPGet* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpGetHandleItemRequestData* _data_;
	RygelHTTPGet* _tmp0_ = NULL;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_ = g_slice_new0 (RygelHttpGetHandleItemRequestData);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_handle_item_request);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_handle_item_request_data_free);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	rygel_http_get_handle_item_request_co (_data_);
#line 1889 "rygel-http-get.c"
}


static void rygel_http_get_handle_item_request_finish (RygelHTTPGet* self, GAsyncResult* _res_, GError** error) {
	RygelHttpGetHandleItemRequestData* _data_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		return;
#line 1899 "rygel-http-get.c"
	}
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1903 "rygel-http-get.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 162 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	return self ? g_error_copy (self) : NULL;
#line 1910 "rygel-http-get.c"
}


static void __lambda4_ (RygelHTTPGet* self, const gchar* name, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	g_return_if_fail (name != NULL);
#line 185 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	g_return_if_fail (value != NULL);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_tmp0_ = name;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_tmp1_ = value;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	g_debug ("rygel-http-get.vala:186: %s : %s", _tmp0_, _tmp1_);
#line 1927 "rygel-http-get.c"
}


static void ___lambda4__soup_message_headers_foreach_func (const gchar* name, const gchar* value, gpointer self) {
#line 185 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	__lambda4_ (self, name, value);
#line 1934 "rygel-http-get.c"
}


static void rygel_http_get_handle_item_request_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetHandleItemRequestData* _data_;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_ = _user_data_;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_source_object_ = source_object;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_res_ = _res_;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	rygel_http_get_handle_item_request_co (_data_);
#line 1948 "rygel-http-get.c"
}


static gboolean rygel_http_get_handle_item_request_co (RygelHttpGetHandleItemRequestData* _data_) {
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	switch (_data_->_state_) {
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		case 0:
#line 1957 "rygel-http-get.c"
		goto _state_0;
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		case 1:
#line 1961 "rygel-http-get.c"
		goto _state_1;
		default:
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_assert_not_reached ();
#line 1966 "rygel-http-get.c"
	}
	_state_0:
#line 138 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp0_ = FALSE;
#line 138 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp0_ = rygel_http_time_seek_needed (_data_->self);
#line 138 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->need_time_seek = _data_->_tmp0_;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp1_ = FALSE;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp1_ = rygel_http_time_seek_requested (_data_->self);
#line 139 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->requested_time_seek = _data_->_tmp1_;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp2_ = FALSE;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp2_ = rygel_http_byte_seek_needed (_data_->self);
#line 140 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->need_byte_seek = _data_->_tmp2_;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp3_ = FALSE;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp3_ = rygel_http_byte_seek_requested (_data_->self);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->requested_byte_seek = _data_->_tmp3_;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp6_ = FALSE;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp6_ = _data_->requested_time_seek;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_tmp6_) {
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp7_ = FALSE;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp7_ = _data_->need_time_seek;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp5_ = !_data_->_tmp7_;
#line 2005 "rygel-http-get.c"
	} else {
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp5_ = FALSE;
#line 2009 "rygel-http-get.c"
	}
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp8_ = FALSE;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp8_ = _data_->_tmp5_;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_tmp8_) {
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp4_ = TRUE;
#line 2019 "rygel-http-get.c"
	} else {
#line 144 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp10_ = FALSE;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp10_ = _data_->requested_byte_seek;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		if (_data_->_tmp10_) {
#line 144 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp11_ = FALSE;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp11_ = _data_->need_byte_seek;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp9_ = !_data_->_tmp11_;
#line 2033 "rygel-http-get.c"
		} else {
#line 144 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp9_ = FALSE;
#line 2037 "rygel-http-get.c"
		}
#line 144 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp12_ = FALSE;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp12_ = _data_->_tmp9_;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp4_ = _data_->_tmp12_;
#line 2045 "rygel-http-get.c"
	}
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp13_ = FALSE;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp13_ = _data_->_tmp4_;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_tmp13_) {
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp14_ = NULL;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp14_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE, "Invalid seek request");
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_inner_error_ = _data_->_tmp14_;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_error_free (_data_->_inner_error_);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2067 "rygel-http-get.c"
		} else {
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2071 "rygel-http-get.c"
		}
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		return FALSE;
#line 2077 "rygel-http-get.c"
	}
	{
#line 149 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp16_ = FALSE;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp16_ = _data_->need_time_seek;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		if (_data_->_tmp16_) {
#line 149 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp17_ = FALSE;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp17_ = _data_->requested_time_seek;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp15_ = _data_->_tmp17_;
#line 2092 "rygel-http-get.c"
		} else {
#line 149 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp15_ = FALSE;
#line 2096 "rygel-http-get.c"
		}
#line 149 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp18_ = FALSE;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp18_ = _data_->_tmp15_;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		if (_data_->_tmp18_) {
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp20_ = NULL;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp20_ = rygel_http_time_seek_new (_data_->self, &_data_->_inner_error_);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp19_ = _data_->_tmp20_;
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			if (_data_->_inner_error_ != NULL) {
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				if (_data_->_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 2114 "rygel-http-get.c"
					goto __catch3_rygel_http_seek_error;
				}
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				g_clear_error (&_data_->_inner_error_);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				return FALSE;
#line 2123 "rygel-http-get.c"
			}
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_g_object_unref0 (_data_->self->seek);
#line 150 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->self->seek = (RygelHTTPSeek*) _data_->_tmp19_;
#line 2129 "rygel-http-get.c"
		} else {
#line 151 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp22_ = FALSE;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp22_ = _data_->need_byte_seek;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			if (_data_->_tmp22_) {
#line 151 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp23_ = FALSE;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp23_ = _data_->requested_byte_seek;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp21_ = _data_->_tmp23_;
#line 2143 "rygel-http-get.c"
			} else {
#line 151 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp21_ = FALSE;
#line 2147 "rygel-http-get.c"
			}
#line 151 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp24_ = FALSE;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp24_ = _data_->_tmp21_;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			if (_data_->_tmp24_) {
#line 152 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp26_ = NULL;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp26_ = rygel_http_byte_seek_new (_data_->self, &_data_->_inner_error_);
#line 152 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp25_ = _data_->_tmp26_;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				if (_data_->_inner_error_ != NULL) {
#line 152 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					if (_data_->_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
#line 2165 "rygel-http-get.c"
						goto __catch3_rygel_http_seek_error;
					}
#line 152 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 152 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					g_clear_error (&_data_->_inner_error_);
#line 152 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					return FALSE;
#line 2174 "rygel-http-get.c"
				}
#line 152 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_g_object_unref0 (_data_->self->seek);
#line 152 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->self->seek = (RygelHTTPSeek*) _data_->_tmp25_;
#line 2180 "rygel-http-get.c"
			}
		}
	}
	goto __finally3;
	__catch3_rygel_http_seek_error:
	{
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_inner_error_ = NULL;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp27_ = NULL;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp27_ = ((RygelHTTPRequest*) _data_->self)->server;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp28_ = NULL;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp28_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		soup_server_unpause_message (_data_->_tmp27_, _data_->_tmp28_);
#line 157 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp29_ = NULL;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp29_ = _data_->_error_;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		if (g_error_matches (_data_->_tmp29_, RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE)) {
#line 158 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_BAD_REQUEST);
#line 2209 "rygel-http-get.c"
		} else {
#line 159 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp30_ = NULL;
#line 159 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_data_->_tmp30_ = _data_->_error_;
#line 159 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			if (g_error_matches (_data_->_tmp30_, RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE)) {
#line 160 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE);
#line 2219 "rygel-http-get.c"
			} else {
#line 162 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp31_ = NULL;
#line 162 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp31_ = _data_->_error_;
#line 162 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp32_ = NULL;
#line 162 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_tmp32_ = _g_error_copy0 (_data_->_tmp31_);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_data_->_inner_error_ = _data_->_tmp32_;
#line 162 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_g_error_free0 (_data_->_error_);
#line 2233 "rygel-http-get.c"
				goto __finally3;
			}
		}
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_g_error_free0 (_data_->_error_);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2243 "rygel-http-get.c"
		} else {
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2247 "rygel-http-get.c"
		}
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 165 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		return FALSE;
#line 2253 "rygel-http-get.c"
	}
	__finally3:
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_inner_error_ != NULL) {
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_error_free (_data_->_inner_error_);
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2266 "rygel-http-get.c"
		} else {
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2270 "rygel-http-get.c"
		}
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 148 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		return FALSE;
#line 2276 "rygel-http-get.c"
	}
#line 169 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp33_ = NULL;
#line 169 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp33_ = _data_->self->handler;
#line 169 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	rygel_http_get_handler_add_response_headers (_data_->_tmp33_, _data_->self);
#line 172 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp34_ = NULL;
#line 172 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp34_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 172 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp35_ = NULL;
#line 172 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp35_ = _data_->_tmp34_->request_headers;
#line 172 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp36_ = NULL;
#line 172 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp36_ = soup_message_headers_get_one (_data_->_tmp35_, "Range");
#line 172 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_tmp36_ != NULL) {
#line 173 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp37_ = NULL;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp37_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 173 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		soup_message_set_status (_data_->_tmp37_, (guint) SOUP_STATUS_PARTIAL_CONTENT);
#line 2304 "rygel-http-get.c"
	} else {
#line 175 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp38_ = NULL;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp38_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		soup_message_set_status (_data_->_tmp38_, (guint) SOUP_STATUS_OK);
#line 2312 "rygel-http-get.c"
	}
#line 178 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp39_ = NULL;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp39_ = _data_->self->handler;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp40_ = FALSE;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp40_ = rygel_http_get_handler_knows_size (_data_->_tmp39_, _data_->self);
#line 178 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_tmp40_) {
#line 179 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp41_ = NULL;
#line 179 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp41_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 179 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp42_ = NULL;
#line 179 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp42_ = _data_->_tmp41_->response_headers;
#line 179 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		soup_message_headers_set_encoding (_data_->_tmp42_, SOUP_ENCODING_CONTENT_LENGTH);
#line 2334 "rygel-http-get.c"
	} else {
#line 181 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp43_ = NULL;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp43_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp44_ = NULL;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp44_ = _data_->_tmp43_->response_headers;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		soup_message_headers_set_encoding (_data_->_tmp44_, SOUP_ENCODING_EOF);
#line 2346 "rygel-http-get.c"
	}
#line 184 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	g_debug ("rygel-http-get.vala:184: Following HTTP headers appended to response:");
#line 185 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp45_ = NULL;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp45_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp46_ = NULL;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp46_ = _data_->_tmp45_->response_headers;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	soup_message_headers_foreach (_data_->_tmp46_, ___lambda4__soup_message_headers_foreach_func, _data_->self);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp47_ = NULL;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp47_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp48_ = NULL;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	g_object_get (_data_->_tmp47_, "method", &_data_->_tmp48_, NULL);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp49_ = NULL;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp49_ = _data_->_tmp48_;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp50_ = NULL;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp50_ = _data_->_tmp49_;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp51_ = FALSE;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp51_ = g_strcmp0 (_data_->_tmp50_, "HEAD") == 0;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_g_free0 (_data_->_tmp50_);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_tmp51_) {
#line 191 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp52_ = NULL;
#line 191 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp52_ = ((RygelHTTPRequest*) _data_->self)->server;
#line 191 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp53_ = NULL;
#line 191 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_data_->_tmp53_ = ((RygelHTTPRequest*) _data_->self)->msg;
#line 191 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		soup_server_unpause_message (_data_->_tmp52_, _data_->_tmp53_);
#line 193 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		if (_data_->_state_ == 0) {
#line 193 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2398 "rygel-http-get.c"
		} else {
#line 193 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2402 "rygel-http-get.c"
		}
#line 193 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_object_unref (_data_->_async_result);
#line 193 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		return FALSE;
#line 2408 "rygel-http-get.c"
	}
#line 196 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp54_ = NULL;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp54_ = _data_->self->handler;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp55_ = NULL;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp55_ = rygel_http_get_handler_render_body (_data_->_tmp54_, _data_->self);
#line 196 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->response = _data_->_tmp55_;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp56_ = NULL;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_tmp56_ = _data_->response;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_data_->_state_ = 1;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	rygel_state_machine_run ((RygelStateMachine*) _data_->_tmp56_, rygel_http_get_handle_item_request_ready, _data_);
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	return FALSE;
#line 2430 "rygel-http-get.c"
	_state_1:
#line 198 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	rygel_state_machine_run_finish ((RygelStateMachine*) _data_->_tmp56_, _data_->_res_);
#line 200 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	rygel_http_request_end ((RygelHTTPRequest*) _data_->self, (guint) SOUP_STATUS_NONE);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_g_object_unref0 (_data_->response);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_data_->_state_ == 0) {
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2442 "rygel-http-get.c"
	} else {
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2446 "rygel-http-get.c"
	}
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	g_object_unref (_data_->_async_result);
#line 137 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	return FALSE;
#line 2452 "rygel-http-get.c"
}


static void rygel_http_get_ensure_correct_mode (RygelHTTPGet* self, GError** error) {
	gchar* mode = NULL;
	SoupMessage* _tmp0_ = NULL;
	SoupMessageHeaders* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean correct = FALSE;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GQuark _tmp7_ = 0U;
#line 207 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	static GQuark _tmp6_label0 = 0;
#line 207 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	static GQuark _tmp6_label1 = 0;
#line 2470 "rygel-http-get.c"
	gboolean _tmp40_ = FALSE;
	GError * _inner_error_ = NULL;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	g_return_if_fail (self != NULL);
#line 204 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_tmp0_ = ((RygelHTTPRequest*) self)->msg;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_tmp1_ = _tmp0_->request_headers;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_tmp2_ = soup_message_headers_get_one (_tmp1_, RYGEL_HTTP_GET_TRANSFER_MODE_HEADER);
#line 204 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 204 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	mode = _tmp3_;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	correct = TRUE;
#line 207 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_tmp4_ = mode;
#line 207 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_tmp5_ = _tmp4_;
#line 207 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
#line 207 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("Streaming")))) {
#line 207 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		switch (0) {
#line 2497 "rygel-http-get.c"
			default:
			{
				gboolean _tmp8_ = FALSE;
				RygelHTTPGetHandler* _tmp9_ = NULL;
				gboolean _tmp21_ = FALSE;
#line 209 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_tmp9_ = self->handler;
#line 209 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, RYGEL_TYPE_HTTP_PLAYLIST_HANDLER)) {
#line 2507 "rygel-http-get.c"
					gboolean _tmp10_ = FALSE;
					RygelHTTPGetHandler* _tmp11_ = NULL;
					gboolean _tmp20_ = FALSE;
#line 210 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_tmp11_ = self->handler;
#line 210 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_HTTP_TRANSCODE_HANDLER)) {
#line 210 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
						_tmp10_ = TRUE;
#line 2517 "rygel-http-get.c"
					} else {
						gboolean _tmp12_ = FALSE;
						gboolean _tmp13_ = FALSE;
						RygelMediaObject* _tmp14_ = NULL;
						gboolean _tmp15_ = FALSE;
						gboolean _tmp17_ = FALSE;
						gboolean _tmp19_ = FALSE;
#line 211 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
						_tmp14_ = ((RygelHTTPRequest*) self)->object;
#line 211 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
						_tmp15_ = rygel_media_item_streamable (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp14_) : NULL);
#line 211 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
						if (_tmp15_) {
#line 2531 "rygel-http-get.c"
							RygelSubtitle* _tmp16_ = NULL;
#line 212 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
							_tmp16_ = self->subtitle;
#line 212 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
							_tmp13_ = _tmp16_ == NULL;
#line 2537 "rygel-http-get.c"
						} else {
#line 211 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
							_tmp13_ = FALSE;
#line 2541 "rygel-http-get.c"
						}
#line 211 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
						_tmp17_ = _tmp13_;
#line 211 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
						if (_tmp17_) {
#line 2547 "rygel-http-get.c"
							RygelThumbnail* _tmp18_ = NULL;
#line 213 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
							_tmp18_ = self->thumbnail;
#line 213 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
							_tmp12_ = _tmp18_ == NULL;
#line 2553 "rygel-http-get.c"
						} else {
#line 211 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
							_tmp12_ = FALSE;
#line 2557 "rygel-http-get.c"
						}
#line 211 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
						_tmp19_ = _tmp12_;
#line 211 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
						_tmp10_ = _tmp19_;
#line 2563 "rygel-http-get.c"
					}
#line 210 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_tmp20_ = _tmp10_;
#line 210 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_tmp8_ = _tmp20_;
#line 2569 "rygel-http-get.c"
				} else {
#line 209 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_tmp8_ = FALSE;
#line 2573 "rygel-http-get.c"
				}
#line 209 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_tmp21_ = _tmp8_;
#line 209 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				correct = _tmp21_;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				break;
#line 2581 "rygel-http-get.c"
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("Interactive")))) {
#line 207 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		switch (0) {
#line 2587 "rygel-http-get.c"
			default:
			{
				gboolean _tmp22_ = FALSE;
				gboolean _tmp23_ = FALSE;
				RygelHTTPGetHandler* _tmp24_ = NULL;
				gboolean _tmp37_ = FALSE;
				gboolean _tmp39_ = FALSE;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_tmp24_ = self->handler;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, RYGEL_TYPE_HTTP_IDENTITY_HANDLER)) {
#line 2599 "rygel-http-get.c"
					gboolean _tmp25_ = FALSE;
					gboolean _tmp26_ = FALSE;
					RygelMediaObject* _tmp27_ = NULL;
					gboolean _tmp28_ = FALSE;
					gboolean _tmp31_ = FALSE;
					gboolean _tmp36_ = FALSE;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_tmp27_ = ((RygelHTTPRequest*) self)->object;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_tmp28_ = rygel_media_item_is_live_stream (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp27_) : NULL);
#line 218 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					if (!_tmp28_) {
#line 2612 "rygel-http-get.c"
						RygelMediaObject* _tmp29_ = NULL;
						gboolean _tmp30_ = FALSE;
#line 219 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
						_tmp29_ = ((RygelHTTPRequest*) self)->object;
#line 219 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
						_tmp30_ = rygel_media_item_streamable (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp29_) : NULL);
#line 219 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
						_tmp26_ = !_tmp30_;
#line 2621 "rygel-http-get.c"
					} else {
#line 218 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
						_tmp26_ = FALSE;
#line 2625 "rygel-http-get.c"
					}
#line 218 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_tmp31_ = _tmp26_;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					if (_tmp31_) {
#line 218 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
						_tmp25_ = TRUE;
#line 2633 "rygel-http-get.c"
					} else {
						gboolean _tmp32_ = FALSE;
						RygelSubtitle* _tmp33_ = NULL;
						gboolean _tmp35_ = FALSE;
#line 220 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
						_tmp33_ = self->subtitle;
#line 220 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
						if (_tmp33_ != NULL) {
#line 220 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
							_tmp32_ = TRUE;
#line 2644 "rygel-http-get.c"
						} else {
							RygelThumbnail* _tmp34_ = NULL;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
							_tmp34_ = self->thumbnail;
#line 221 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
							_tmp32_ = _tmp34_ != NULL;
#line 2651 "rygel-http-get.c"
						}
#line 220 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
						_tmp35_ = _tmp32_;
#line 220 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
						_tmp25_ = _tmp35_;
#line 2657 "rygel-http-get.c"
					}
#line 218 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_tmp36_ = _tmp25_;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_tmp23_ = _tmp36_;
#line 2663 "rygel-http-get.c"
				} else {
#line 217 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_tmp23_ = FALSE;
#line 2667 "rygel-http-get.c"
				}
#line 217 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_tmp37_ = _tmp23_;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				if (_tmp37_) {
#line 217 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_tmp22_ = TRUE;
#line 2675 "rygel-http-get.c"
				} else {
					RygelHTTPGetHandler* _tmp38_ = NULL;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_tmp38_ = self->handler;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
					_tmp22_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, RYGEL_TYPE_HTTP_PLAYLIST_HANDLER);
#line 2682 "rygel-http-get.c"
				}
#line 217 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				_tmp39_ = _tmp22_;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				correct = _tmp39_;
#line 224 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
				break;
#line 2690 "rygel-http-get.c"
			}
		}
	}
#line 227 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_tmp40_ = correct;
#line 227 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	if (!_tmp40_) {
#line 2698 "rygel-http-get.c"
		const gchar* _tmp41_ = NULL;
		RygelMediaObject* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		GError* _tmp44_ = NULL;
#line 228 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_tmp41_ = mode;
#line 228 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_tmp42_ = ((RygelHTTPRequest*) self)->object;
#line 228 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_tmp43_ = _tmp42_->id;
#line 228 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_tmp44_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE, "%s mode not supported for '%s'", _tmp41_, _tmp43_);
#line 228 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		_inner_error_ = _tmp44_;
#line 228 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 228 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_propagate_error (error, _inner_error_);
#line 228 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_g_free0 (mode);
#line 228 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			return;
#line 2721 "rygel-http-get.c"
		} else {
#line 228 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			_g_free0 (mode);
#line 228 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 228 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			g_clear_error (&_inner_error_);
#line 228 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
			return;
#line 2731 "rygel-http-get.c"
		}
	}
#line 203 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_g_free0 (mode);
#line 2736 "rygel-http-get.c"
}


static void rygel_http_get_class_init (RygelHTTPGetClass * klass) {
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	rygel_http_get_parent_class = g_type_class_peek_parent (klass);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPGetPrivate));
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	RYGEL_HTTP_REQUEST_CLASS (klass)->handle = rygel_http_get_real_handle;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	RYGEL_HTTP_REQUEST_CLASS (klass)->handle_finish = rygel_http_get_real_handle_finish;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	RYGEL_HTTP_REQUEST_CLASS (klass)->find_item = rygel_http_get_real_find_item;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	RYGEL_HTTP_REQUEST_CLASS (klass)->find_item_finish = rygel_http_get_real_find_item_finish;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_finalize;
#line 2755 "rygel-http-get.c"
}


static void rygel_http_get_instance_init (RygelHTTPGet * self) {
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	self->priv = RYGEL_HTTP_GET_GET_PRIVATE (self);
#line 2762 "rygel-http-get.c"
}


static void rygel_http_get_finalize (GObject* obj) {
	RygelHTTPGet * self;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_GET, RygelHTTPGet);
#line 34 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_rygel_thumbnail_unref0 (self->thumbnail);
#line 35 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_rygel_subtitle_unref0 (self->subtitle);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_g_object_unref0 (self->seek);
#line 41 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	_rygel_http_get_handler_unref0 (self->handler);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-get.vala"
	G_OBJECT_CLASS (rygel_http_get_parent_class)->finalize (obj);
#line 2780 "rygel-http-get.c"
}


/**
 * Responsible for handling HTTP GET & HEAD client requests.
 */
GType rygel_http_get_get_type (void) {
	static volatile gsize rygel_http_get_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGet), 0, (GInstanceInitFunc) rygel_http_get_instance_init, NULL };
		GType rygel_http_get_type_id;
		rygel_http_get_type_id = g_type_register_static (RYGEL_TYPE_HTTP_REQUEST, "RygelHTTPGet", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_type_id__volatile, rygel_http_get_type_id);
	}
	return rygel_http_get_type_id__volatile;
}



