/* rygel-http-item-uri_http-post.c generated by valac 0.22.0, the Vala compiler
 * generated from rygel-http-item-uri_http-post.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Authors: Jens Georg <mail@jensge.org>
 *          Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                                <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <glib/gi18n-lib.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>


#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;
typedef struct _RygelHTTPItemURIPrivate RygelHTTPItemURIPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_VISUAL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemClass))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_IS_VISUAL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemClass))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemClass RygelVisualItemClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelVisualItemPrivate RygelVisualItemPrivate;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

struct _RygelHTTPItemURI {
	GObject parent_instance;
	RygelHTTPItemURIPrivate * priv;
};

struct _RygelHTTPItemURIClass {
	GObjectClass parent_class;
};

struct _RygelHTTPItemURIPrivate {
	gchar* _item_id;
	gint _thumbnail_index;
	gint _subtitle_index;
	gchar* _transcode_target;
	gchar* _playlist_format;
	RygelHTTPServer* _http_server;
	gchar* real_extension;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	RygelMediaContainer* parent;
	gchar* mime_type;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	glong size;
	glong duration;
	GeeArrayList* uris;
	gboolean place_holder;
	GFile* file;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelVisualItem {
	RygelMediaItem parent_instance;
	RygelVisualItemPrivate * priv;
	GeeArrayList* thumbnails;
};

struct _RygelVisualItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelThumbnail {
	GObject parent_instance;
	RygelThumbnailPrivate * priv;
	gchar* file_extension;
};

struct _RygelThumbnailClass {
	GObjectClass parent_class;
};

struct _RygelMusicItem {
	RygelMediaItem parent_instance;
	RygelMusicItemPrivate * priv;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelVideoItem {
	RygelVisualItem parent_instance;
	RygelVideoItemPrivate * priv;
	GeeArrayList* subtitles;
};

struct _RygelVideoItemClass {
	RygelVisualItemClass parent_class;
};

struct _RygelSubtitle {
	GObject parent_instance;
	RygelSubtitlePrivate * priv;
	gchar* caption_type;
};

struct _RygelSubtitleClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};


static gpointer rygel_http_item_uri_parent_class = NULL;
extern GeeHashMap* rygel_http_item_uri_mime_to_ext;
GeeHashMap* rygel_http_item_uri_mime_to_ext = NULL;

GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_ITEM_URI_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIPrivate))
enum  {
	RYGEL_HTTP_ITEM_URI_DUMMY_PROPERTY,
	RYGEL_HTTP_ITEM_URI_ITEM_ID,
	RYGEL_HTTP_ITEM_URI_THUMBNAIL_INDEX,
	RYGEL_HTTP_ITEM_URI_SUBTITLE_INDEX,
	RYGEL_HTTP_ITEM_URI_TRANSCODE_TARGET,
	RYGEL_HTTP_ITEM_URI_PLAYLIST_FORMAT,
	RYGEL_HTTP_ITEM_URI_HTTP_SERVER,
	RYGEL_HTTP_ITEM_URI_EXTENSION
};
GType rygel_media_object_get_type (void) G_GNUC_CONST;
RygelHTTPItemURI* rygel_http_item_uri_new (RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_format);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_format);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
void rygel_http_item_uri_set_item_id (RygelHTTPItemURI* self, const gchar* value);
void rygel_http_item_uri_set_thumbnail_index (RygelHTTPItemURI* self, gint value);
void rygel_http_item_uri_set_subtitle_index (RygelHTTPItemURI* self, gint value);
void rygel_http_item_uri_set_transcode_target (RygelHTTPItemURI* self, const gchar* value);
void rygel_http_item_uri_set_http_server (RygelHTTPItemURI* self, RygelHTTPServer* value);
void rygel_http_item_uri_set_playlist_format (RygelHTTPItemURI* self, const gchar* value);
void rygel_http_item_uri_set_extension (RygelHTTPItemURI* self, const gchar* value);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
RygelHTTPServer* rygel_http_item_uri_get_http_server (RygelHTTPItemURI* self);
RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error);
const gchar* rygel_transcoder_get_extension (RygelTranscoder* self);
gchar* rygel_http_item_uri_get_extension (RygelHTTPItemURI* self);
static gchar* rygel_http_item_uri_ext_from_mime_type (RygelHTTPItemURI* self, const gchar* mime_type);
GQuark rygel_http_request_error_quark (void);
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
const gchar* rygel_http_item_uri_get_item_id (RygelHTTPItemURI* self);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
const gchar* rygel_http_item_uri_get_transcode_target (RygelHTTPItemURI* self);
gint rygel_http_item_uri_get_thumbnail_index (RygelHTTPItemURI* self);
gint rygel_http_item_uri_get_subtitle_index (RygelHTTPItemURI* self);
const gchar* rygel_http_item_uri_get_playlist_format (RygelHTTPItemURI* self);
static gchar* rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self, const gchar* path);
static void rygel_http_item_uri_finalize (GObject* obj);
static void _vala_rygel_http_item_uri_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_item_uri_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	return self ? g_object_ref (self) : NULL;
#line 342 "rygel-http-item-uri_http-post.c"
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 908 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 908 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 909 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 909 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 909 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 909 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 911 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 911 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 369 "rygel-http-item-uri_http-post.c"
		gchar* _tmp4_ = NULL;
#line 912 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 912 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 912 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 377 "rygel-http-item-uri_http-post.c"
	} else {
#line 914 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = -1;
#line 914 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 383 "rygel-http-item-uri_http-post.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1157 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1157 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 407 "rygel-http-item-uri_http-post.c"
		glong _tmp4_ = 0L;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 415 "rygel-http-item-uri_http-post.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 427 "rygel-http-item-uri_http-post.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
#line 1167 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 452 "rygel-http-item-uri_http-post.c"
		glong _tmp2_ = 0L;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 458 "rygel-http-item-uri_http-post.c"
	} else {
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 462 "rygel-http-item-uri_http-post.c"
	}
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 468 "rygel-http-item-uri_http-post.c"
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 480 "rygel-http-item-uri_http-post.c"
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 490 "rygel-http-item-uri_http-post.c"
	}
#line 1176 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1176 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 496 "rygel-http-item-uri_http-post.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1178 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1178 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 510 "rygel-http-item-uri_http-post.c"
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 520 "rygel-http-item-uri_http-post.c"
	}
#line 1182 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1182 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 526 "rygel-http-item-uri_http-post.c"
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 535 "rygel-http-item-uri_http-post.c"
	}
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 555 "rygel-http-item-uri_http-post.c"
}


RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_format) {
	RygelHTTPItemURI * self = NULL;
	RygelMediaObject* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
	RygelHTTPServer* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	RygelMediaObject* _tmp7_ = NULL;
	RygelMediaItem* item = NULL;
	RygelMediaObject* _tmp8_ = NULL;
	RygelMediaItem* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
	gboolean _tmp55_ = FALSE;
	GError * _inner_error_ = NULL;
#line 51 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_return_val_if_fail (object != NULL, NULL);
#line 51 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 51 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp0_ = object;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp1_ = _tmp0_->id;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	rygel_http_item_uri_set_item_id (self, _tmp1_);
#line 58 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp2_ = thumbnail_index;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	rygel_http_item_uri_set_thumbnail_index (self, _tmp2_);
#line 59 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp3_ = subtitle_index;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	rygel_http_item_uri_set_subtitle_index (self, _tmp3_);
#line 60 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp4_ = transcode_target;
#line 60 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	rygel_http_item_uri_set_transcode_target (self, _tmp4_);
#line 61 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp5_ = http_server;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	rygel_http_item_uri_set_http_server (self, _tmp5_);
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp6_ = playlist_format;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	rygel_http_item_uri_set_playlist_format (self, _tmp6_);
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	rygel_http_item_uri_set_extension (self, "");
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp7_ = object;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, RYGEL_TYPE_MEDIA_ITEM)) {
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		return self;
#line 618 "rygel-http-item-uri_http-post.c"
	}
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp8_ = object;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp8_) : NULL);
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	item = _tmp9_;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp10_ = thumbnail_index;
#line 70 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	if (_tmp10_ > (-1)) {
#line 630 "rygel-http-item-uri_http-post.c"
		RygelMediaItem* _tmp11_ = NULL;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp11_ = item;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_VISUAL_ITEM)) {
#line 636 "rygel-http-item-uri_http-post.c"
			GeeArrayList* thumbnails = NULL;
			RygelMediaItem* _tmp12_ = NULL;
			GeeArrayList* _tmp13_ = NULL;
			GeeArrayList* _tmp14_ = NULL;
			GeeArrayList* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp12_ = item;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp13_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _tmp12_) : NULL)->thumbnails;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp14_ = _g_object_ref0 (_tmp13_);
#line 72 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			thumbnails = _tmp14_;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp15_ = thumbnails;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp16_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp15_);
#line 74 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp17_ = _tmp16_;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp18_ = thumbnail_index;
#line 74 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			if (_tmp17_ > _tmp18_) {
#line 663 "rygel-http-item-uri_http-post.c"
				GeeArrayList* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				gpointer _tmp21_ = NULL;
				RygelThumbnail* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp19_ = thumbnails;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp20_ = thumbnail_index;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _tmp20_);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp22_ = (RygelThumbnail*) _tmp21_;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp23_ = _tmp22_->file_extension;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				rygel_http_item_uri_set_extension (self, _tmp23_);
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_g_object_unref0 (_tmp22_);
#line 683 "rygel-http-item-uri_http-post.c"
			}
#line 71 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_g_object_unref0 (thumbnails);
#line 687 "rygel-http-item-uri_http-post.c"
		} else {
			RygelMediaItem* _tmp24_ = NULL;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp24_ = item;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, RYGEL_TYPE_MUSIC_ITEM)) {
#line 694 "rygel-http-item-uri_http-post.c"
				RygelThumbnail* album_art = NULL;
				RygelMediaItem* _tmp25_ = NULL;
				RygelThumbnail* _tmp26_ = NULL;
				RygelThumbnail* _tmp27_ = NULL;
				RygelThumbnail* _tmp28_ = NULL;
#line 78 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp25_ = item;
#line 78 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp26_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) _tmp25_) : NULL)->album_art;
#line 78 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp27_ = _g_object_ref0 (_tmp26_);
#line 78 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				album_art = _tmp27_;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp28_ = album_art;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				if (_tmp28_ != NULL) {
#line 712 "rygel-http-item-uri_http-post.c"
					RygelThumbnail* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp29_ = album_art;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp30_ = _tmp29_->file_extension;
#line 81 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					rygel_http_item_uri_set_extension (self, _tmp30_);
#line 721 "rygel-http-item-uri_http-post.c"
				}
#line 77 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_g_object_unref0 (album_art);
#line 725 "rygel-http-item-uri_http-post.c"
			}
		}
	} else {
		gint _tmp31_ = 0;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp31_ = subtitle_index;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		if (_tmp31_ > (-1)) {
#line 734 "rygel-http-item-uri_http-post.c"
			RygelMediaItem* _tmp32_ = NULL;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp32_ = item;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, RYGEL_TYPE_VIDEO_ITEM)) {
#line 740 "rygel-http-item-uri_http-post.c"
				GeeArrayList* subtitles = NULL;
				RygelMediaItem* _tmp33_ = NULL;
				GeeArrayList* _tmp34_ = NULL;
				GeeArrayList* _tmp35_ = NULL;
				GeeArrayList* _tmp36_ = NULL;
				gint _tmp37_ = 0;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
#line 86 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp33_ = item;
#line 86 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp34_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, RYGEL_TYPE_VIDEO_ITEM) ? ((RygelVideoItem*) _tmp33_) : NULL)->subtitles;
#line 86 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp35_ = _g_object_ref0 (_tmp34_);
#line 86 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				subtitles = _tmp35_;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp36_ = subtitles;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp37_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp36_);
#line 88 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp38_ = _tmp37_;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp39_ = subtitle_index;
#line 88 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				if (_tmp38_ > _tmp39_) {
#line 767 "rygel-http-item-uri_http-post.c"
					GeeArrayList* _tmp40_ = NULL;
					gint _tmp41_ = 0;
					gpointer _tmp42_ = NULL;
					RygelSubtitle* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp40_ = subtitles;
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp41_ = subtitle_index;
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp42_ = gee_abstract_list_get ((GeeAbstractList*) _tmp40_, _tmp41_);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp43_ = (RygelSubtitle*) _tmp42_;
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp44_ = _tmp43_->caption_type;
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					rygel_http_item_uri_set_extension (self, _tmp44_);
#line 89 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_g_object_unref0 (_tmp43_);
#line 787 "rygel-http-item-uri_http-post.c"
				}
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_g_object_unref0 (subtitles);
#line 791 "rygel-http-item-uri_http-post.c"
			}
		} else {
			const gchar* _tmp45_ = NULL;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp45_ = transcode_target;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			if (_tmp45_ != NULL) {
#line 799 "rygel-http-item-uri_http-post.c"
				{
					RygelTranscoder* tc = NULL;
					RygelHTTPServer* _tmp46_ = NULL;
					const gchar* _tmp47_ = NULL;
					RygelTranscoder* _tmp48_ = NULL;
					RygelTranscoder* _tmp49_ = NULL;
					const gchar* _tmp50_ = NULL;
					const gchar* _tmp51_ = NULL;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp46_ = self->priv->_http_server;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp47_ = transcode_target;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp48_ = rygel_http_server_get_transcoder (_tmp46_, _tmp47_, &_inner_error_);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					tc = _tmp48_;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					if (_inner_error_ != NULL) {
#line 818 "rygel-http-item-uri_http-post.c"
						goto __catch13_g_error;
					}
#line 96 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp49_ = tc;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp50_ = rygel_transcoder_get_extension (_tmp49_);
#line 96 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp51_ = _tmp50_;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					rygel_http_item_uri_set_extension (self, _tmp51_);
#line 93 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_g_object_unref0 (tc);
#line 831 "rygel-http-item-uri_http-post.c"
				}
				goto __finally13;
				__catch13_g_error:
				{
					GError* _error_ = NULL;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_error_ = _inner_error_;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_inner_error_ = NULL;
#line 93 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_g_error_free0 (_error_);
#line 843 "rygel-http-item-uri_http-post.c"
				}
				__finally13:
#line 93 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				if (_inner_error_ != NULL) {
#line 93 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_g_object_unref0 (item);
#line 93 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 93 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					g_clear_error (&_inner_error_);
#line 93 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					return NULL;
#line 856 "rygel-http-item-uri_http-post.c"
				}
			}
		}
	}
#line 100 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp52_ = rygel_http_item_uri_get_extension (self);
#line 100 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp53_ = _tmp52_;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp54_ = _tmp53_;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp55_ = g_strcmp0 (_tmp54_, "") == 0;
#line 100 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_g_free0 (_tmp54_);
#line 100 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	if (_tmp55_) {
#line 873 "rygel-http-item-uri_http-post.c"
		gchar* uri_extension = NULL;
		gchar* _tmp56_ = NULL;
		const gchar* _tmp77_ = NULL;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp56_ = g_strdup ("");
#line 101 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		uri_extension = _tmp56_;
#line 881 "rygel-http-item-uri_http-post.c"
		{
			GeeArrayList* _uri_string_list = NULL;
			RygelMediaItem* _tmp57_ = NULL;
			GeeArrayList* _tmp58_ = NULL;
			GeeArrayList* _tmp59_ = NULL;
			gint _uri_string_size = 0;
			GeeArrayList* _tmp60_ = NULL;
			gint _tmp61_ = 0;
			gint _tmp62_ = 0;
			gint _uri_string_index = 0;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp57_ = item;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp58_ = _tmp57_->uris;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp59_ = _g_object_ref0 (_tmp58_);
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_uri_string_list = _tmp59_;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp60_ = _uri_string_list;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp61_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp60_);
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp62_ = _tmp61_;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_uri_string_size = _tmp62_;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_uri_string_index = -1;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			while (TRUE) {
#line 912 "rygel-http-item-uri_http-post.c"
				gint _tmp63_ = 0;
				gint _tmp64_ = 0;
				gint _tmp65_ = 0;
				gchar* uri_string = NULL;
				GeeArrayList* _tmp66_ = NULL;
				gint _tmp67_ = 0;
				gpointer _tmp68_ = NULL;
				gchar* basename = NULL;
				const gchar* _tmp69_ = NULL;
				gchar* _tmp70_ = NULL;
				gint dot_index = 0;
				const gchar* _tmp71_ = NULL;
				gint _tmp72_ = 0;
				gint _tmp73_ = 0;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp63_ = _uri_string_index;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_uri_string_index = _tmp63_ + 1;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp64_ = _uri_string_index;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp65_ = _uri_string_size;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				if (!(_tmp64_ < _tmp65_)) {
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					break;
#line 939 "rygel-http-item-uri_http-post.c"
				}
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp66_ = _uri_string_list;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp67_ = _uri_string_index;
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp68_ = gee_abstract_list_get ((GeeAbstractList*) _tmp66_, _tmp67_);
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				uri_string = (gchar*) _tmp68_;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp69_ = uri_string;
#line 104 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp70_ = g_path_get_basename (_tmp69_);
#line 104 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				basename = _tmp70_;
#line 105 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp71_ = basename;
#line 105 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp72_ = string_last_index_of (_tmp71_, ".", 0);
#line 105 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				dot_index = _tmp72_;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp73_ = dot_index;
#line 107 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				if (_tmp73_ > (-1)) {
#line 965 "rygel-http-item-uri_http-post.c"
					const gchar* _tmp74_ = NULL;
					gint _tmp75_ = 0;
					gchar* _tmp76_ = NULL;
#line 108 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp74_ = basename;
#line 108 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp75_ = dot_index;
#line 108 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp76_ = string_substring (_tmp74_, (glong) (_tmp75_ + 1), (glong) (-1));
#line 108 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_g_free0 (uri_extension);
#line 108 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					uri_extension = _tmp76_;
#line 110 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_g_free0 (basename);
#line 110 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_g_free0 (uri_string);
#line 110 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					break;
#line 985 "rygel-http-item-uri_http-post.c"
				}
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_g_free0 (basename);
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_g_free0 (uri_string);
#line 991 "rygel-http-item-uri_http-post.c"
			}
#line 103 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_g_object_unref0 (_uri_string_list);
#line 995 "rygel-http-item-uri_http-post.c"
		}
#line 114 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp77_ = uri_extension;
#line 114 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		if (g_strcmp0 (_tmp77_, "") == 0) {
#line 1001 "rygel-http-item-uri_http-post.c"
			RygelMediaItem* _tmp78_ = NULL;
			const gchar* _tmp79_ = NULL;
			gchar* _tmp80_ = NULL;
			gchar* _tmp81_ = NULL;
#line 115 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp78_ = item;
#line 115 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp79_ = ((RygelMediaObject*) _tmp78_)->mime_type;
#line 115 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp80_ = rygel_http_item_uri_ext_from_mime_type (self, _tmp79_);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp81_ = _tmp80_;
#line 115 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			rygel_http_item_uri_set_extension (self, _tmp81_);
#line 115 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_g_free0 (_tmp81_);
#line 1018 "rygel-http-item-uri_http-post.c"
		} else {
			const gchar* _tmp82_ = NULL;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp82_ = uri_extension;
#line 117 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			rygel_http_item_uri_set_extension (self, _tmp82_);
#line 1025 "rygel-http-item-uri_http-post.c"
		}
#line 100 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_g_free0 (uri_extension);
#line 1029 "rygel-http-item-uri_http-post.c"
	}
#line 51 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_g_object_unref0 (item);
#line 51 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	return self;
#line 1035 "rygel-http-item-uri_http-post.c"
}


RygelHTTPItemURI* rygel_http_item_uri_new (RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_format) {
#line 51 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	return rygel_http_item_uri_construct (RYGEL_TYPE_HTTP_ITEM_URI, object, http_server, thumbnail_index, subtitle_index, transcode_target, playlist_format);
#line 1042 "rygel-http-item-uri_http-post.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1241 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1241 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1241 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1055 "rygel-http-item-uri_http-post.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1085 "rygel-http-item-uri_http-post.c"
				goto __catch14_g_regex_error;
			}
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1243 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			return NULL;
#line 1094 "rygel-http-item-uri_http-post.c"
		}
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1110 "rygel-http-item-uri_http-post.c"
				goto __catch14_g_regex_error;
			}
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
			return NULL;
#line 1121 "rygel-http-item-uri_http-post.c"
		}
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = _tmp5_;
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1244 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 1129 "rygel-http-item-uri_http-post.c"
	}
	goto __finally14;
	__catch14_g_regex_error:
	{
		GError* e = NULL;
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1246 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 1143 "rygel-http-item-uri_http-post.c"
	}
	__finally14:
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1242 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return NULL;
#line 1154 "rygel-http-item-uri_http-post.c"
	}
}


RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error) {
	RygelHTTPItemURI * self = NULL;
	RygelHTTPServer* _tmp0_ = NULL;
	gchar* request_uri = NULL;
	const gchar* _tmp1_ = NULL;
	RygelHTTPServer* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar** parts = NULL;
	const gchar* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint parts_length1 = 0;
	gint _parts_size_ = 0;
	gboolean _tmp9_ = FALSE;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gboolean _tmp12_ = FALSE;
	gchar* last_part = NULL;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gchar** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gint dot_index = 0;
	const gchar* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	const gchar* _tmp75_ = NULL;
	GError * _inner_error_ = NULL;
#line 122 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 122 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 122 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
#line 126 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	rygel_http_item_uri_set_thumbnail_index (self, -1);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	rygel_http_item_uri_set_subtitle_index (self, -1);
#line 128 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	rygel_http_item_uri_set_transcode_target (self, NULL);
#line 129 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp0_ = http_server;
#line 129 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	rygel_http_item_uri_set_http_server (self, _tmp0_);
#line 130 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	rygel_http_item_uri_set_extension (self, "");
#line 132 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp1_ = uri;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp2_ = http_server;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp3_ = rygel_http_server_get_path_root (_tmp2_);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp4_ = _tmp3_;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp5_ = string_replace (_tmp1_, _tmp4_, "");
#line 132 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	request_uri = _tmp5_;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp6_ = request_uri;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "/", 0);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	parts = _tmp8_;
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	parts_length1 = _vala_array_length (_tmp7_);
#line 133 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_parts_size_ = parts_length1;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp10_ = parts;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp10__length1 = parts_length1;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	if (_tmp10__length1 < 2) {
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp9_ = TRUE;
#line 1239 "rygel-http-item-uri_http-post.c"
	} else {
		gchar** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp11_ = parts;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp11__length1 = parts_length1;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp9_ = (_tmp11__length1 % 2) == 0;
#line 1249 "rygel-http-item-uri_http-post.c"
	}
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp12_ = _tmp9_;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	if (_tmp12_) {
#line 1255 "rygel-http-item-uri_http-post.c"
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp13_ = _ ("Invalid URI '%s'");
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp14_ = request_uri;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp15_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _tmp13_, _tmp14_);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_inner_error_ = _tmp15_;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			g_propagate_error (error, _inner_error_);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_g_free0 (request_uri);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_g_object_unref0 (self);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			return NULL;
#line 1279 "rygel-http-item-uri_http-post.c"
		} else {
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_g_free0 (request_uri);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			g_clear_error (&_inner_error_);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			return NULL;
#line 1291 "rygel-http-item-uri_http-post.c"
		}
	}
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp16_ = parts;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp16__length1 = parts_length1;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp17_ = parts;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp17__length1 = parts_length1;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp18_ = _tmp16_[_tmp17__length1 - 1];
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp19_ = g_strdup (_tmp18_);
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	last_part = _tmp19_;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp20_ = last_part;
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp21_ = string_last_index_of (_tmp20_, ".", 0);
#line 141 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	dot_index = _tmp21_;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp22_ = dot_index;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	if (_tmp22_ > (-1)) {
#line 1318 "rygel-http-item-uri_http-post.c"
		const gchar* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar** _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		gchar** _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		const gchar* _tmp29_ = NULL;
		gint _tmp30_ = 0;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp23_ = last_part;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp24_ = dot_index;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp25_ = string_substring (_tmp23_, (glong) (_tmp24_ + 1), (glong) (-1));
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp26_ = _tmp25_;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		rygel_http_item_uri_set_extension (self, _tmp26_);
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_g_free0 (_tmp26_);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp27_ = parts;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp27__length1 = parts_length1;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp28_ = parts;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp28__length1 = parts_length1;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp29_ = last_part;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp30_ = dot_index;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp31_ = string_substring (_tmp29_, (glong) 0, (glong) _tmp30_);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_g_free0 (_tmp27_[_tmp28__length1 - 1]);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp27_[_tmp28__length1 - 1] = _tmp31_;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp32_ = _tmp27_[_tmp28__length1 - 1];
#line 1363 "rygel-http-item-uri_http-post.c"
	}
	{
		gint i = 0;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		i = 1;
#line 1369 "rygel-http-item-uri_http-post.c"
		{
			gboolean _tmp33_ = FALSE;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp33_ = TRUE;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			while (TRUE) {
#line 1376 "rygel-http-item-uri_http-post.c"
				gboolean _tmp34_ = FALSE;
				gint _tmp36_ = 0;
				gchar** _tmp37_ = NULL;
				gint _tmp37__length1 = 0;
				gchar** _tmp38_ = NULL;
				gint _tmp38__length1 = 0;
				gint _tmp39_ = 0;
				const gchar* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				GQuark _tmp43_ = 0U;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				static GQuark _tmp42_label0 = 0;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				static GQuark _tmp42_label1 = 0;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				static GQuark _tmp42_label2 = 0;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				static GQuark _tmp42_label3 = 0;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				static GQuark _tmp42_label4 = 0;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp34_ = _tmp33_;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				if (!_tmp34_) {
#line 1401 "rygel-http-item-uri_http-post.c"
					gint _tmp35_ = 0;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp35_ = i;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					i = _tmp35_ + 2;
#line 1407 "rygel-http-item-uri_http-post.c"
				}
#line 148 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp33_ = FALSE;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp36_ = i;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp37_ = parts;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp37__length1 = parts_length1;
#line 148 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				if (!(_tmp36_ < (_tmp37__length1 - 1))) {
#line 148 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					break;
#line 1421 "rygel-http-item-uri_http-post.c"
				}
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp38_ = parts;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp38__length1 = parts_length1;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp39_ = i;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp40_ = _tmp38_[_tmp39_];
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp41_ = _tmp40_;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp43_ = (NULL == _tmp41_) ? 0 : g_quark_from_string (_tmp41_);
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				if (_tmp43_ == ((0 != _tmp42_label0) ? _tmp42_label0 : (_tmp42_label0 = g_quark_from_static_string ("i")))) {
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					switch (0) {
#line 1439 "rygel-http-item-uri_http-post.c"
						default:
						{
							guchar* data = NULL;
							gchar** _tmp44_ = NULL;
							gint _tmp44__length1 = 0;
							gint _tmp45_ = 0;
							const gchar* _tmp46_ = NULL;
							gchar* _tmp47_ = NULL;
							gchar* _tmp48_ = NULL;
							size_t _tmp49_;
							guchar* _tmp50_ = NULL;
							guchar* _tmp51_ = NULL;
							gint _tmp51__length1 = 0;
							gint data_length1 = 0;
							gint _data_size_ = 0;
							GString* builder = NULL;
							GString* _tmp52_ = NULL;
							GString* _tmp53_ = NULL;
							guchar* _tmp54_ = NULL;
							gint _tmp54__length1 = 0;
							GString* _tmp55_ = NULL;
							const gchar* _tmp56_ = NULL;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp44_ = parts;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp44__length1 = parts_length1;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp45_ = i;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp46_ = _tmp44_[_tmp45_ + 1];
#line 151 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp47_ = soup_uri_decode (_tmp46_);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp48_ = _tmp47_;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp50_ = g_base64_decode (_tmp48_, &_tmp49_);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp51_ = _tmp50_;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp51__length1 = _tmp49_;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_g_free0 (_tmp48_);
#line 151 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							data = _tmp51_;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							data_length1 = _tmp51__length1;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_data_size_ = data_length1;
#line 152 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp52_ = g_string_new ("");
#line 152 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							builder = _tmp52_;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp53_ = builder;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp54_ = data;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp54__length1 = data_length1;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							g_string_append (_tmp53_, (const gchar*) _tmp54_);
#line 154 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp55_ = builder;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp56_ = _tmp55_->str;
#line 154 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							rygel_http_item_uri_set_item_id (self, _tmp56_);
#line 156 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_g_string_free0 (builder);
#line 156 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							data = (g_free (data), NULL);
#line 156 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							break;
#line 1512 "rygel-http-item-uri_http-post.c"
						}
					}
				} else if (_tmp43_ == ((0 != _tmp42_label1) ? _tmp42_label1 : (_tmp42_label1 = g_quark_from_static_string ("tr")))) {
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					switch (0) {
#line 1518 "rygel-http-item-uri_http-post.c"
						default:
						{
							gchar** _tmp57_ = NULL;
							gint _tmp57__length1 = 0;
							gint _tmp58_ = 0;
							const gchar* _tmp59_ = NULL;
							gchar* _tmp60_ = NULL;
							gchar* _tmp61_ = NULL;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp57_ = parts;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp57__length1 = parts_length1;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp58_ = i;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp59_ = _tmp57_[_tmp58_ + 1];
#line 158 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp60_ = soup_uri_decode (_tmp59_);
#line 158 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp61_ = _tmp60_;
#line 158 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							rygel_http_item_uri_set_transcode_target (self, _tmp61_);
#line 158 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_g_free0 (_tmp61_);
#line 160 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							break;
#line 1545 "rygel-http-item-uri_http-post.c"
						}
					}
				} else if (_tmp43_ == ((0 != _tmp42_label2) ? _tmp42_label2 : (_tmp42_label2 = g_quark_from_static_string ("th")))) {
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					switch (0) {
#line 1551 "rygel-http-item-uri_http-post.c"
						default:
						{
							gchar** _tmp62_ = NULL;
							gint _tmp62__length1 = 0;
							gint _tmp63_ = 0;
							const gchar* _tmp64_ = NULL;
							gint _tmp65_ = 0;
#line 162 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp62_ = parts;
#line 162 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp62__length1 = parts_length1;
#line 162 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp63_ = i;
#line 162 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp64_ = _tmp62_[_tmp63_ + 1];
#line 162 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp65_ = atoi (_tmp64_);
#line 162 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							rygel_http_item_uri_set_thumbnail_index (self, _tmp65_);
#line 164 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							break;
#line 1573 "rygel-http-item-uri_http-post.c"
						}
					}
				} else if (_tmp43_ == ((0 != _tmp42_label3) ? _tmp42_label3 : (_tmp42_label3 = g_quark_from_static_string ("sub")))) {
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					switch (0) {
#line 1579 "rygel-http-item-uri_http-post.c"
						default:
						{
							gchar** _tmp66_ = NULL;
							gint _tmp66__length1 = 0;
							gint _tmp67_ = 0;
							const gchar* _tmp68_ = NULL;
							gint _tmp69_ = 0;
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp66_ = parts;
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp66__length1 = parts_length1;
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp67_ = i;
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp68_ = _tmp66_[_tmp67_ + 1];
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp69_ = atoi (_tmp68_);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							rygel_http_item_uri_set_subtitle_index (self, _tmp69_);
#line 168 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							break;
#line 1601 "rygel-http-item-uri_http-post.c"
						}
					}
				} else if (_tmp43_ == ((0 != _tmp42_label4) ? _tmp42_label4 : (_tmp42_label4 = g_quark_from_static_string ("pl")))) {
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					switch (0) {
#line 1607 "rygel-http-item-uri_http-post.c"
						default:
						{
							gchar** _tmp70_ = NULL;
							gint _tmp70__length1 = 0;
							gint _tmp71_ = 0;
							const gchar* _tmp72_ = NULL;
							gchar* _tmp73_ = NULL;
							gchar* _tmp74_ = NULL;
#line 170 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp70_ = parts;
#line 170 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp70__length1 = parts_length1;
#line 170 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp71_ = i;
#line 170 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp72_ = _tmp70_[_tmp71_ + 1];
#line 170 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp73_ = soup_uri_decode (_tmp72_);
#line 170 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_tmp74_ = _tmp73_;
#line 170 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							rygel_http_item_uri_set_playlist_format (self, _tmp74_);
#line 170 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							_g_free0 (_tmp74_);
#line 172 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							break;
#line 1634 "rygel-http-item-uri_http-post.c"
						}
					}
				} else {
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					switch (0) {
#line 1640 "rygel-http-item-uri_http-post.c"
						default:
						{
#line 174 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
							break;
#line 1645 "rygel-http-item-uri_http-post.c"
						}
					}
				}
			}
		}
	}
#line 178 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp75_ = self->priv->_item_id;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	if (_tmp75_ == NULL) {
#line 1656 "rygel-http-item-uri_http-post.c"
		const gchar* _tmp76_ = NULL;
		GError* _tmp77_ = NULL;
#line 179 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp76_ = _ ("Not Found");
#line 179 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp77_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp76_);
#line 179 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_inner_error_ = _tmp77_;
#line 179 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 179 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			g_propagate_error (error, _inner_error_);
#line 179 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_g_free0 (last_part);
#line 179 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 179 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_g_free0 (request_uri);
#line 179 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_g_object_unref0 (self);
#line 179 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			return NULL;
#line 1679 "rygel-http-item-uri_http-post.c"
		} else {
#line 179 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_g_free0 (last_part);
#line 179 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 179 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_g_free0 (request_uri);
#line 179 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 179 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			g_clear_error (&_inner_error_);
#line 179 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			return NULL;
#line 1693 "rygel-http-item-uri_http-post.c"
		}
	}
#line 122 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_g_free0 (last_part);
#line 122 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 122 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_g_free0 (request_uri);
#line 122 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	return self;
#line 1704 "rygel-http-item-uri_http-post.c"
}


RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error) {
#line 122 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	return rygel_http_item_uri_construct_from_string (RYGEL_TYPE_HTTP_ITEM_URI, uri, http_server, error);
#line 1711 "rygel-http-item-uri_http-post.c"
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
#line 1266 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1267 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1267 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1267 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
#line 1267 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1267 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_result__length1 = _tmp1_ + 1;
#line 1267 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	__result__size_ = _result__length1;
#line 1268 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = _result__length1;
#line 1268 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_result__length1 = _tmp3_ - 1;
#line 1269 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp4_ = _result_;
#line 1269 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp4__length1 = _result__length1;
#line 1269 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp5_ = strlen (self);
#line 1269 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp6_ = _tmp5_;
#line 1269 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	memcpy (_tmp4_, self, (gsize) _tmp6_);
#line 1270 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp7_ = _result_;
#line 1270 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp7__length1 = _result__length1;
#line 1270 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1270 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		*result_length1 = _tmp7__length1;
#line 1766 "rygel-http-item-uri_http-post.c"
	}
#line 1270 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1270 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 1772 "rygel-http-item-uri_http-post.c"
}


gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self) {
	gchar* result = NULL;
	gchar* data = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	gchar* escaped = NULL;
	gchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* path = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
#line 183 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 187 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp0_ = self->priv->_item_id;
#line 187 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp2_ = string_to_utf8 (_tmp0_, &_tmp1_);
#line 187 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	data = _tmp2_;
#line 187 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	data_length1 = _tmp1_;
#line 187 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_data_size_ = data_length1;
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp3_ = data;
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp3__length1 = data_length1;
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp4_ = g_base64_encode ((guchar*) _tmp3_, (_tmp3__length1 * sizeof (gchar)) / sizeof (guchar));
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp5_ = _tmp4_;
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp6_ = g_uri_escape_string (_tmp5_, "", TRUE);
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp7_ = _tmp6_;
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_g_free0 (_tmp5_);
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	escaped = _tmp7_;
#line 191 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp8_ = escaped;
#line 191 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp9_ = g_strconcat ("/i/", _tmp8_, NULL);
#line 191 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	path = _tmp9_;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp10_ = self->priv->_transcode_target;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	if (_tmp10_ != NULL) {
#line 1840 "rygel-http-item-uri_http-post.c"
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp11_ = self->priv->_transcode_target;
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp12_ = g_uri_escape_string (_tmp11_, "", TRUE);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_g_free0 (escaped);
#line 194 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		escaped = _tmp12_;
#line 195 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp13_ = path;
#line 195 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp14_ = escaped;
#line 195 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp15_ = g_strconcat ("/tr/", _tmp14_, NULL);
#line 195 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp16_ = _tmp15_;
#line 195 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp17_ = g_strconcat (_tmp13_, _tmp16_, NULL);
#line 195 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_g_free0 (path);
#line 195 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		path = _tmp17_;
#line 195 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_g_free0 (_tmp16_);
#line 1872 "rygel-http-item-uri_http-post.c"
	} else {
		gint _tmp18_ = 0;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp18_ = self->priv->_thumbnail_index;
#line 196 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		if (_tmp18_ >= 0) {
#line 1879 "rygel-http-item-uri_http-post.c"
			const gchar* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp19_ = path;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp20_ = self->priv->_thumbnail_index;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp21_ = g_strdup_printf ("%i", _tmp20_);
#line 197 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp22_ = _tmp21_;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp23_ = g_strconcat ("/th/", _tmp22_, NULL);
#line 197 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp24_ = _tmp23_;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp25_ = g_strconcat (_tmp19_, _tmp24_, NULL);
#line 197 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_g_free0 (path);
#line 197 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			path = _tmp25_;
#line 197 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_g_free0 (_tmp24_);
#line 197 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_g_free0 (_tmp22_);
#line 1909 "rygel-http-item-uri_http-post.c"
		} else {
			gint _tmp26_ = 0;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			_tmp26_ = self->priv->_subtitle_index;
#line 198 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			if (_tmp26_ >= 0) {
#line 1916 "rygel-http-item-uri_http-post.c"
				const gchar* _tmp27_ = NULL;
				gint _tmp28_ = 0;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
				gchar* _tmp31_ = NULL;
				gchar* _tmp32_ = NULL;
				gchar* _tmp33_ = NULL;
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp27_ = path;
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp28_ = self->priv->_subtitle_index;
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp29_ = g_strdup_printf ("%i", _tmp28_);
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp30_ = _tmp29_;
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp31_ = g_strconcat ("/sub/", _tmp30_, NULL);
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp32_ = _tmp31_;
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp33_ = g_strconcat (_tmp27_, _tmp32_, NULL);
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_g_free0 (path);
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				path = _tmp33_;
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_g_free0 (_tmp32_);
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_g_free0 (_tmp30_);
#line 1946 "rygel-http-item-uri_http-post.c"
			} else {
				const gchar* _tmp34_ = NULL;
#line 200 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp34_ = self->priv->_playlist_format;
#line 200 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				if (_tmp34_ != NULL) {
#line 1953 "rygel-http-item-uri_http-post.c"
					const gchar* _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
					gchar* _tmp37_ = NULL;
					gchar* _tmp38_ = NULL;
					gchar* _tmp39_ = NULL;
					gchar* _tmp40_ = NULL;
					gchar* _tmp41_ = NULL;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp35_ = path;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp36_ = self->priv->_playlist_format;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp37_ = g_uri_escape_string (_tmp36_, "", TRUE);
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp38_ = _tmp37_;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp39_ = g_strconcat ("/pl/", _tmp38_, NULL);
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp40_ = _tmp39_;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp41_ = g_strconcat (_tmp35_, _tmp40_, NULL);
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_g_free0 (path);
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					path = _tmp41_;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_g_free0 (_tmp40_);
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_g_free0 (_tmp38_);
#line 1983 "rygel-http-item-uri_http-post.c"
				}
			}
		}
	}
#line 204 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp42_ = path;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp43_ = rygel_http_item_uri_get_extension (self);
#line 204 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp44_ = _tmp43_;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp45_ = _tmp44_;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp46_ = g_strconcat (_tmp42_, _tmp45_, NULL);
#line 204 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_g_free0 (path);
#line 204 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	path = _tmp46_;
#line 204 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_g_free0 (_tmp45_);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp47_ = path;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp48_ = rygel_http_item_uri_create_uri_for_path (self, _tmp47_);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	result = _tmp48_;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_g_free0 (path);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_g_free0 (escaped);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	data = (g_free (data), NULL);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	return result;
#line 2018 "rygel-http-item-uri_http-post.c"
}


static gchar* rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self, const gchar* path) {
	gchar* result = NULL;
	RygelHTTPServer* _tmp0_ = NULL;
	GUPnPContext* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	RygelHTTPServer* _tmp4_ = NULL;
	GUPnPContext* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	RygelHTTPServer* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
#line 209 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 209 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 210 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp0_ = self->priv->_http_server;
#line 210 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp1_ = _tmp0_->context;
#line 210 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp2_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp1_);
#line 210 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp3_ = _tmp2_;
#line 210 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp4_ = self->priv->_http_server;
#line 210 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp5_ = _tmp4_->context;
#line 210 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp6_ = gupnp_context_get_port (_tmp5_);
#line 210 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp7_ = _tmp6_;
#line 210 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp8_ = self->priv->_http_server;
#line 210 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp9_ = rygel_http_server_get_path_root (_tmp8_);
#line 210 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp10_ = _tmp9_;
#line 210 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp11_ = path;
#line 210 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp12_ = g_strdup_printf ("http://%s:%u%s%s", _tmp3_, _tmp7_, _tmp10_, _tmp11_);
#line 210 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	result = _tmp12_;
#line 210 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	return result;
#line 2071 "rygel-http-item-uri_http-post.c"
}


static gchar* rygel_http_item_uri_ext_from_mime_type (RygelHTTPItemURI* self, const gchar* mime_type) {
	gchar* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	gchar* _tmp35_ = NULL;
#line 216 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 216 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_return_val_if_fail (mime_type != NULL, NULL);
#line 217 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp0_ = rygel_http_item_uri_mime_to_ext;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	if (_tmp0_ == NULL) {
#line 2090 "rygel-http-item-uri_http-post.c"
		GeeHashMap* _tmp1_ = NULL;
		gchar** videos = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar** _tmp5_ = NULL;
		gint videos_length1 = 0;
		gint _videos_size_ = 0;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		GeeHashMap* _tmp13_ = NULL;
		GeeHashMap* _tmp14_ = NULL;
		GeeHashMap* _tmp15_ = NULL;
		gchar** images = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar** _tmp18_ = NULL;
		gint images_length1 = 0;
		gint _images_size_ = 0;
		gchar** _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		GeeHashMap* _tmp26_ = NULL;
		GeeHashMap* _tmp27_ = NULL;
		GeeHashMap* _tmp28_ = NULL;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_g_object_unref0 (rygel_http_item_uri_mime_to_ext);
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		rygel_http_item_uri_mime_to_ext = _tmp1_;
#line 220 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp2_ = g_strdup ("mpeg");
#line 220 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp3_ = g_strdup ("webm");
#line 220 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp4_ = g_strdup ("ogg");
#line 220 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp5_ = g_new0 (gchar*, 3 + 1);
#line 220 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp5_[0] = _tmp2_;
#line 220 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp5_[1] = _tmp3_;
#line 220 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp5_[2] = _tmp4_;
#line 220 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		videos = _tmp5_;
#line 220 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		videos_length1 = 3;
#line 220 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_videos_size_ = videos_length1;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp6_ = videos;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp6__length1 = videos_length1;
#line 2145 "rygel-http-item-uri_http-post.c"
		{
			gchar** video_collection = NULL;
			gint video_collection_length1 = 0;
			gint _video_collection_size_ = 0;
			gint video_it = 0;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			video_collection = _tmp6_;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			video_collection_length1 = _tmp6__length1;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			for (video_it = 0; video_it < _tmp6__length1; video_it = video_it + 1) {
#line 2157 "rygel-http-item-uri_http-post.c"
				gchar* _tmp7_ = NULL;
				gchar* video = NULL;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp7_ = g_strdup (video_collection[video_it]);
#line 222 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				video = _tmp7_;
#line 2164 "rygel-http-item-uri_http-post.c"
				{
					GeeHashMap* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					const gchar* _tmp12_ = NULL;
#line 223 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp8_ = rygel_http_item_uri_mime_to_ext;
#line 223 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp9_ = video;
#line 223 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp10_ = g_strconcat ("video/", _tmp9_, NULL);
#line 223 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp11_ = _tmp10_;
#line 223 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp12_ = video;
#line 223 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp11_, _tmp12_);
#line 223 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_g_free0 (_tmp11_);
#line 222 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_g_free0 (video);
#line 2187 "rygel-http-item-uri_http-post.c"
				}
			}
		}
#line 225 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp13_ = rygel_http_item_uri_mime_to_ext;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, "video/x-matroska", "mkv");
#line 228 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp14_ = rygel_http_item_uri_mime_to_ext;
#line 228 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, "audio/x-wav", "wav");
#line 229 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp15_ = rygel_http_item_uri_mime_to_ext;
#line 229 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, "audio/x-matroska", "mka");
#line 232 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp16_ = g_strdup ("jpeg");
#line 232 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp17_ = g_strdup ("png");
#line 232 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp18_ = g_new0 (gchar*, 2 + 1);
#line 232 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp18_[0] = _tmp16_;
#line 232 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp18_[1] = _tmp17_;
#line 232 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		images = _tmp18_;
#line 232 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		images_length1 = 2;
#line 232 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_images_size_ = images_length1;
#line 234 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp19_ = images;
#line 234 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp19__length1 = images_length1;
#line 2223 "rygel-http-item-uri_http-post.c"
		{
			gchar** image_collection = NULL;
			gint image_collection_length1 = 0;
			gint _image_collection_size_ = 0;
			gint image_it = 0;
#line 234 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			image_collection = _tmp19_;
#line 234 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			image_collection_length1 = _tmp19__length1;
#line 234 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
			for (image_it = 0; image_it < _tmp19__length1; image_it = image_it + 1) {
#line 2235 "rygel-http-item-uri_http-post.c"
				gchar* _tmp20_ = NULL;
				gchar* image = NULL;
#line 234 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				_tmp20_ = g_strdup (image_collection[image_it]);
#line 234 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
				image = _tmp20_;
#line 2242 "rygel-http-item-uri_http-post.c"
				{
					GeeHashMap* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					gchar* _tmp23_ = NULL;
					gchar* _tmp24_ = NULL;
					const gchar* _tmp25_ = NULL;
#line 235 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp21_ = rygel_http_item_uri_mime_to_ext;
#line 235 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp22_ = image;
#line 235 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp23_ = g_strconcat ("image/", _tmp22_, NULL);
#line 235 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp24_ = _tmp23_;
#line 235 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_tmp25_ = image;
#line 235 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, _tmp24_, _tmp25_);
#line 235 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_g_free0 (_tmp24_);
#line 234 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
					_g_free0 (image);
#line 2265 "rygel-http-item-uri_http-post.c"
				}
			}
		}
#line 239 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp26_ = rygel_http_item_uri_mime_to_ext;
#line 239 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp26_, "text/srt", "srt");
#line 240 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp27_ = rygel_http_item_uri_mime_to_ext;
#line 240 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, "text/xml", "xml");
#line 243 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp28_ = rygel_http_item_uri_mime_to_ext;
#line 243 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp28_, "application/ogg", "ogg");
#line 217 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		images = (_vala_array_free (images, images_length1, (GDestroyNotify) g_free), NULL);
#line 217 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		videos = (_vala_array_free (videos, videos_length1, (GDestroyNotify) g_free), NULL);
#line 2285 "rygel-http-item-uri_http-post.c"
	}
#line 246 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp29_ = rygel_http_item_uri_mime_to_ext;
#line 246 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp30_ = mime_type;
#line 246 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp31_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp29_, _tmp30_);
#line 246 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	if (_tmp31_) {
#line 2295 "rygel-http-item-uri_http-post.c"
		GeeHashMap* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		gpointer _tmp34_ = NULL;
#line 247 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp32_ = rygel_http_item_uri_mime_to_ext;
#line 247 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp33_ = mime_type;
#line 247 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp34_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp32_, _tmp33_);
#line 247 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		result = (gchar*) _tmp34_;
#line 247 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		return result;
#line 2309 "rygel-http-item-uri_http-post.c"
	}
#line 250 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp35_ = g_strdup ("");
#line 250 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	result = _tmp35_;
#line 250 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	return result;
#line 2317 "rygel-http-item-uri_http-post.c"
}


const gchar* rygel_http_item_uri_get_item_id (RygelHTTPItemURI* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp0_ = self->priv->_item_id;
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	result = _tmp0_;
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	return result;
#line 2332 "rygel-http-item-uri_http-post.c"
}


void rygel_http_item_uri_set_item_id (RygelHTTPItemURI* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_return_if_fail (self != NULL);
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp0_ = value;
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_g_free0 (self->priv->_item_id);
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	self->priv->_item_id = _tmp1_;
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_object_notify ((GObject *) self, "item-id");
#line 2351 "rygel-http-item-uri_http-post.c"
}


gint rygel_http_item_uri_get_thumbnail_index (RygelHTTPItemURI* self) {
	gint result;
	gint _tmp0_ = 0;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 30 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp0_ = self->priv->_thumbnail_index;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	result = _tmp0_;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	return result;
#line 2366 "rygel-http-item-uri_http-post.c"
}


void rygel_http_item_uri_set_thumbnail_index (RygelHTTPItemURI* self, gint value) {
	gint _tmp0_ = 0;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_return_if_fail (self != NULL);
#line 30 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp0_ = value;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	self->priv->_thumbnail_index = _tmp0_;
#line 30 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_object_notify ((GObject *) self, "thumbnail-index");
#line 2380 "rygel-http-item-uri_http-post.c"
}


gint rygel_http_item_uri_get_subtitle_index (RygelHTTPItemURI* self) {
	gint result;
	gint _tmp0_ = 0;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp0_ = self->priv->_subtitle_index;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	result = _tmp0_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	return result;
#line 2395 "rygel-http-item-uri_http-post.c"
}


void rygel_http_item_uri_set_subtitle_index (RygelHTTPItemURI* self, gint value) {
	gint _tmp0_ = 0;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_return_if_fail (self != NULL);
#line 31 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp0_ = value;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	self->priv->_subtitle_index = _tmp0_;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_object_notify ((GObject *) self, "subtitle-index");
#line 2409 "rygel-http-item-uri_http-post.c"
}


const gchar* rygel_http_item_uri_get_transcode_target (RygelHTTPItemURI* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp0_ = self->priv->_transcode_target;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	result = _tmp0_;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	return result;
#line 2424 "rygel-http-item-uri_http-post.c"
}


void rygel_http_item_uri_set_transcode_target (RygelHTTPItemURI* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_return_if_fail (self != NULL);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp0_ = value;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_g_free0 (self->priv->_transcode_target);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	self->priv->_transcode_target = _tmp1_;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_object_notify ((GObject *) self, "transcode-target");
#line 2443 "rygel-http-item-uri_http-post.c"
}


const gchar* rygel_http_item_uri_get_playlist_format (RygelHTTPItemURI* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp0_ = self->priv->_playlist_format;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	result = _tmp0_;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	return result;
#line 2458 "rygel-http-item-uri_http-post.c"
}


void rygel_http_item_uri_set_playlist_format (RygelHTTPItemURI* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_return_if_fail (self != NULL);
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp0_ = value;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_g_free0 (self->priv->_playlist_format);
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	self->priv->_playlist_format = _tmp1_;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_object_notify ((GObject *) self, "playlist-format");
#line 2477 "rygel-http-item-uri_http-post.c"
}


RygelHTTPServer* rygel_http_item_uri_get_http_server (RygelHTTPItemURI* self) {
	RygelHTTPServer* result;
	RygelHTTPServer* _tmp0_ = NULL;
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp0_ = self->priv->_http_server;
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	result = _tmp0_;
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	return result;
#line 2492 "rygel-http-item-uri_http-post.c"
}


void rygel_http_item_uri_set_http_server (RygelHTTPItemURI* self, RygelHTTPServer* value) {
	RygelHTTPServer* _tmp0_ = NULL;
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_return_if_fail (self != NULL);
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp0_ = value;
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	self->priv->_http_server = _tmp0_;
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_object_notify ((GObject *) self, "http-server");
#line 2506 "rygel-http-item-uri_http-post.c"
}


gchar* rygel_http_item_uri_get_extension (RygelHTTPItemURI* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp3_ = NULL;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 39 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp0_ = self->priv->real_extension;
#line 39 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	if (g_strcmp0 (_tmp0_, "") != 0) {
#line 2520 "rygel-http-item-uri_http-post.c"
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp1_ = self->priv->real_extension;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		_tmp2_ = g_strconcat (".", _tmp1_, NULL);
#line 40 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		result = _tmp2_;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		return result;
#line 2531 "rygel-http-item-uri_http-post.c"
	}
#line 42 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp3_ = g_strdup ("");
#line 42 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	result = _tmp3_;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	return result;
#line 2539 "rygel-http-item-uri_http-post.c"
}


void rygel_http_item_uri_set_extension (RygelHTTPItemURI* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_return_if_fail (self != NULL);
#line 45 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp0_ = value;
#line 45 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 45 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_g_free0 (self->priv->real_extension);
#line 45 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	self->priv->real_extension = _tmp1_;
#line 44 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_object_notify ((GObject *) self, "extension");
#line 2558 "rygel-http-item-uri_http-post.c"
}


static void rygel_http_item_uri_class_init (RygelHTTPItemURIClass * klass) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	rygel_http_item_uri_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPItemURIPrivate));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_item_uri_get_property;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_item_uri_set_property;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_item_uri_finalize;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_ITEM_ID, g_param_spec_string ("item-id", "item-id", "item-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_THUMBNAIL_INDEX, g_param_spec_int ("thumbnail-index", "thumbnail-index", "thumbnail-index", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_SUBTITLE_INDEX, g_param_spec_int ("subtitle-index", "subtitle-index", "subtitle-index", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_TRANSCODE_TARGET, g_param_spec_string ("transcode-target", "transcode-target", "transcode-target", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_PLAYLIST_FORMAT, g_param_spec_string ("playlist-format", "playlist-format", "playlist-format", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_HTTP_SERVER, g_param_spec_object ("http-server", "http-server", "http-server", RYGEL_TYPE_HTTP_SERVER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_EXTENSION, g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2587 "rygel-http-item-uri_http-post.c"
}


static void rygel_http_item_uri_instance_init (RygelHTTPItemURI * self) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	self->priv = RYGEL_HTTP_ITEM_URI_GET_PRIVATE (self);
#line 30 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	self->priv->_thumbnail_index = -1;
#line 31 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	self->priv->_subtitle_index = -1;
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	self->priv->_transcode_target = NULL;
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	self->priv->_playlist_format = NULL;
#line 2602 "rygel-http-item-uri_http-post.c"
}


static void rygel_http_item_uri_finalize (GObject* obj) {
	RygelHTTPItemURI * self;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI);
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_g_free0 (self->priv->_item_id);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_g_free0 (self->priv->_transcode_target);
#line 33 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_g_free0 (self->priv->_playlist_format);
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	_g_free0 (self->priv->real_extension);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	G_OBJECT_CLASS (rygel_http_item_uri_parent_class)->finalize (obj);
#line 2620 "rygel-http-item-uri_http-post.c"
}


GType rygel_http_item_uri_get_type (void) {
	static volatile gsize rygel_http_item_uri_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_item_uri_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPItemURIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_item_uri_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPItemURI), 0, (GInstanceInitFunc) rygel_http_item_uri_instance_init, NULL };
		GType rygel_http_item_uri_type_id;
		rygel_http_item_uri_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPItemURI", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_item_uri_type_id__volatile, rygel_http_item_uri_type_id);
	}
	return rygel_http_item_uri_type_id__volatile;
}


static void _vala_rygel_http_item_uri_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPItemURI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	switch (property_id) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		case RYGEL_HTTP_ITEM_URI_ITEM_ID:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		g_value_set_string (value, rygel_http_item_uri_get_item_id (self));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		break;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		case RYGEL_HTTP_ITEM_URI_THUMBNAIL_INDEX:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		g_value_set_int (value, rygel_http_item_uri_get_thumbnail_index (self));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		break;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		case RYGEL_HTTP_ITEM_URI_SUBTITLE_INDEX:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		g_value_set_int (value, rygel_http_item_uri_get_subtitle_index (self));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		break;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		case RYGEL_HTTP_ITEM_URI_TRANSCODE_TARGET:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		g_value_set_string (value, rygel_http_item_uri_get_transcode_target (self));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		break;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		case RYGEL_HTTP_ITEM_URI_PLAYLIST_FORMAT:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		g_value_set_string (value, rygel_http_item_uri_get_playlist_format (self));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		break;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		case RYGEL_HTTP_ITEM_URI_HTTP_SERVER:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		g_value_set_object (value, rygel_http_item_uri_get_http_server (self));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		break;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		case RYGEL_HTTP_ITEM_URI_EXTENSION:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		g_value_take_string (value, rygel_http_item_uri_get_extension (self));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		break;
#line 2683 "rygel-http-item-uri_http-post.c"
		default:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		break;
#line 2689 "rygel-http-item-uri_http-post.c"
	}
}


static void _vala_rygel_http_item_uri_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPItemURI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
	switch (property_id) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		case RYGEL_HTTP_ITEM_URI_ITEM_ID:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		rygel_http_item_uri_set_item_id (self, g_value_get_string (value));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		break;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		case RYGEL_HTTP_ITEM_URI_THUMBNAIL_INDEX:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		rygel_http_item_uri_set_thumbnail_index (self, g_value_get_int (value));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		break;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		case RYGEL_HTTP_ITEM_URI_SUBTITLE_INDEX:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		rygel_http_item_uri_set_subtitle_index (self, g_value_get_int (value));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		break;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		case RYGEL_HTTP_ITEM_URI_TRANSCODE_TARGET:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		rygel_http_item_uri_set_transcode_target (self, g_value_get_string (value));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		break;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		case RYGEL_HTTP_ITEM_URI_PLAYLIST_FORMAT:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		rygel_http_item_uri_set_playlist_format (self, g_value_get_string (value));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		break;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		case RYGEL_HTTP_ITEM_URI_HTTP_SERVER:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		rygel_http_item_uri_set_http_server (self, g_value_get_object (value));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		break;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		case RYGEL_HTTP_ITEM_URI_EXTENSION:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		rygel_http_item_uri_set_extension (self, g_value_get_string (value));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		break;
#line 2741 "rygel-http-item-uri_http-post.c"
		default:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri_http-post.vala"
		break;
#line 2747 "rygel-http-item-uri_http-post.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



