/* rygel-xbox-hacks.c generated by valac 0.22.0.18-aa6c, the Vala compiler
 * generated from rygel-xbox-hacks.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <libsoup/soup.h>
#include <rygel-core.h>
#include <libgupnp/gupnp.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelClientHacksPrivate RygelClientHacksPrivate;

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_XBOX_HACKS (rygel_xbox_hacks_get_type ())
#define RYGEL_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacks))
#define RYGEL_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))
#define RYGEL_IS_XBOX_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_IS_XBOX_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_XBOX_HACKS))
#define RYGEL_XBOX_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_XBOX_HACKS, RygelXBoxHacksClass))

typedef struct _RygelXBoxHacks RygelXBoxHacks;
typedef struct _RygelXBoxHacksClass RygelXBoxHacksClass;
typedef struct _RygelXBoxHacksPrivate RygelXBoxHacksPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_SEARCH (rygel_search_get_type ())
#define RYGEL_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH, RygelSearch))
#define RYGEL_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH, RygelSearchClass))
#define RYGEL_IS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH))
#define RYGEL_IS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH))
#define RYGEL_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH, RygelSearchClass))

typedef struct _RygelSearch RygelSearch;
typedef struct _RygelSearchClass RygelSearchClass;

#define RYGEL_TYPE_BROWSE (rygel_browse_get_type ())
#define RYGEL_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BROWSE, RygelBrowse))
#define RYGEL_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BROWSE, RygelBrowseClass))
#define RYGEL_IS_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BROWSE))
#define RYGEL_IS_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BROWSE))
#define RYGEL_BROWSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BROWSE, RygelBrowseClass))

typedef struct _RygelBrowse RygelBrowse;
typedef struct _RygelBrowseClass RygelBrowseClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;
typedef struct _RygelXboxHacksSearchData RygelXboxHacksSearchData;

#define RYGEL_TYPE_LOGICAL_EXPRESSION (rygel_logical_expression_get_type ())
#define RYGEL_LOGICAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpression))
#define RYGEL_LOGICAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpressionClass))
#define RYGEL_IS_LOGICAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION))
#define RYGEL_IS_LOGICAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LOGICAL_EXPRESSION))
#define RYGEL_LOGICAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpressionClass))

typedef struct _RygelLogicalExpression RygelLogicalExpression;
typedef struct _RygelLogicalExpressionClass RygelLogicalExpressionClass;

#define RYGEL_TYPE_LOGICAL_OPERATOR (rygel_logical_operator_get_type ())

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelClientHacks {
	GObject parent_instance;
	RygelClientHacksPrivate * priv;
	GRegex* agent_regex;
};

struct _RygelClientHacksClass {
	GObjectClass parent_class;
	void (*translate_container_id) (RygelClientHacks* self, RygelMediaQueryAction* action, gchar** container_id);
	void (*apply) (RygelClientHacks* self, RygelMediaObject* object);
	void (*filter_sort_criteria) (RygelClientHacks* self, gchar** sort_criteria);
	gboolean (*force_seek) (RygelClientHacks* self);
	void (*search) (RygelClientHacks* self, RygelSearchableContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelClientHacks* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelXBoxHacks {
	RygelClientHacks parent_instance;
	RygelXBoxHacksPrivate * priv;
};

struct _RygelXBoxHacksClass {
	RygelClientHacksClass parent_class;
};

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()
struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelXboxHacksSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelXBoxHacks* self;
	RygelSearchableContainer* container;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	gboolean set_total_matches;
	RygelSearchExpression* modified_expression;
	RygelSearchExpression* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	RygelRelationalExpression* rel_expression;
	RygelSearchExpression* _tmp3_;
	RygelRelationalExpression* _tmp4_;
	gboolean _tmp5_;
	RygelRelationalExpression* _tmp6_;
	gconstpointer _tmp7_;
	gboolean _tmp8_;
	RygelRelationalExpression* _tmp9_;
	gconstpointer _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	RygelRelationalExpression* _tmp15_;
	gconstpointer _tmp16_;
	RygelRelationalExpression* _tmp17_;
	gconstpointer _tmp18_;
	gboolean _tmp19_;
	RygelRelationalExpression* _tmp20_;
	gconstpointer _tmp21_;
	gboolean _tmp22_;
	RygelSearchableContainer* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gboolean _tmp26_;
	RygelSearchExpression* _tmp27_;
	RygelSearchExpression* _tmp28_;
	RygelMediaObjects* results;
	RygelSearchableContainer* _tmp29_;
	RygelSearchExpression* _tmp30_;
	guint _tmp31_;
	guint _tmp32_;
	const gchar* _tmp33_;
	GCancellable* _tmp34_;
	guint _tmp35_;
	RygelMediaObjects* _tmp36_;
	gboolean _tmp37_;
	guint _tmp38_;
	gboolean _tmp39_;
	gboolean _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_LOGICAL_OPERATOR_AND,
	RYGEL_LOGICAL_OPERATOR_OR
} RygelLogicalOperator;


static gpointer rygel_xbox_hacks_parent_class = NULL;

GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
GType rygel_xbox_hacks_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_XBOX_HACKS_DUMMY_PROPERTY
};
#define RYGEL_XBOX_HACKS_AGENT ".*Xbox.*"
#define RYGEL_XBOX_HACKS_DMS "urn:schemas-upnp-org:device:MediaServer"
#define RYGEL_XBOX_HACKS_DMS_V1 RYGEL_XBOX_HACKS_DMS ":1"
#define RYGEL_XBOX_HACKS_FRIENDLY_NAME_POSTFIX ":"
#define RYGEL_XBOX_HACKS_MODEL_NAME "Windows Media Player Sharing"
#define RYGEL_XBOX_HACKS_MODEL_VERSION "11"
#define RYGEL_XBOX_HACKS_CONTAINER_ID "ContainerID"
GQuark rygel_client_hacks_error_quark (void);
RygelXBoxHacks* rygel_xbox_hacks_new (SoupMessage* message, GError** error);
RygelXBoxHacks* rygel_xbox_hacks_construct (GType object_type, SoupMessage* message, GError** error);
RygelClientHacks* rygel_client_hacks_construct (GType object_type, const gchar* agent, SoupMessage* message, GError** error);
void rygel_client_hacks_set_object_id (RygelClientHacks* self, const gchar* value);
static gchar** _vala_array_dup2 (gchar** self, int length);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
void rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self, RygelRootDevice* device, const gchar* template_path, GError** error);
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_TYPE "urn:microsoft-com:service:X_MS_MediaReceiverRegistrar:1"
#define RYGEL_MEDIA_RECEIVER_REGISTRAR_COMPAT_TYPE "urn:microsoft.com:service:X_MS_MediaReceiverRegistrar:1"
static void rygel_xbox_hacks_real_translate_container_id (RygelClientHacks* base, RygelMediaQueryAction* action, gchar** container_id);
GType rygel_search_get_type (void) G_GNUC_CONST;
GType rygel_browse_get_type (void) G_GNUC_CONST;
static void rygel_xbox_hacks_real_apply (RygelClientHacks* base, RygelMediaObject* object);
const gchar* rygel_media_object_get_upnp_class (RygelMediaObject* self);
#define RYGEL_MEDIA_CONTAINER_UPNP_CLASS "object.container"
#define RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".storageFolder"
void rygel_media_object_set_upnp_class (RygelMediaObject* self, const gchar* value);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
const gchar* rygel_media_item_get_mime_type (RygelMediaItem* self);
void rygel_media_item_set_mime_type (RygelMediaItem* self, const gchar* value);
static void rygel_xbox_hacks_real_filter_sort_criteria (RygelClientHacks* base, gchar** sort_criteria);
static void rygel_xbox_hacks_real_search_data_free (gpointer _data);
static void rygel_xbox_hacks_real_search (RygelClientHacks* base, RygelSearchableContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_xbox_hacks_real_search_co (RygelXboxHacksSearchData* _data_);
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
#define RYGEL_AUDIO_ITEM_UPNP_CLASS "object.item.audioItem"
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
static RygelSearchExpression* rygel_xbox_hacks_rewrite_search_expression (RygelXBoxHacks* self, RygelSearchExpression* expression);
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_xbox_hacks_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
GType rygel_logical_expression_get_type (void) G_GNUC_CONST;
RygelLogicalExpression* rygel_logical_expression_new (void);
RygelLogicalExpression* rygel_logical_expression_construct (GType object_type);
GType rygel_logical_operator_get_type (void) G_GNUC_CONST;
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gboolean bool_parse (const gchar* str) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


RygelXBoxHacks* rygel_xbox_hacks_construct (GType object_type, SoupMessage* message, GError** error) {
	RygelXBoxHacks * self = NULL;
	SoupMessage* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupURI* uri = NULL;
	SoupMessage* _tmp2_ = NULL;
	SoupURI* _tmp3_ = NULL;
	const gchar* query = NULL;
	SoupURI* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GHashTable* params = NULL;
	const gchar* _tmp7_ = NULL;
	GHashTable* _tmp8_ = NULL;
	gchar* album_art = NULL;
	GHashTable* _tmp9_ = NULL;
	gconstpointer _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_ = NULL;
	gboolean _tmp16_ = FALSE;
	gchar* path = NULL;
	SoupURI* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar** particles = NULL;
	const gchar* _tmp20_ = NULL;
	gchar** _tmp21_ = NULL;
	gchar** _tmp22_ = NULL;
	gchar** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	gchar** _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	gchar** _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	gint particles_length1 = 0;
	gint _particles_size_ = 0;
	gchar** _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	gchar* _tmp27_ = NULL;
	gchar** _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	gchar* _tmp29_ = NULL;
	SoupURI* _tmp30_ = NULL;
	gchar** _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = message;
	self = (RygelXBoxHacks*) rygel_client_hacks_construct (object_type, RYGEL_XBOX_HACKS_AGENT, _tmp0_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_CLIENT_HACKS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	rygel_client_hacks_set_object_id ((RygelClientHacks*) self, RYGEL_XBOX_HACKS_CONTAINER_ID);
	_tmp1_ = message;
	if (_tmp1_ == NULL) {
		return self;
	}
	_tmp2_ = message;
	_tmp3_ = soup_message_get_uri (_tmp2_);
	uri = _tmp3_;
	_tmp4_ = uri;
	_tmp5_ = _tmp4_->query;
	query = _tmp5_;
	_tmp6_ = query;
	if (_tmp6_ == NULL) {
		return self;
	}
	_tmp7_ = query;
	_tmp8_ = soup_form_decode (_tmp7_);
	params = _tmp8_;
	_tmp9_ = params;
	_tmp10_ = g_hash_table_lookup (_tmp9_, "albumArt");
	_tmp11_ = g_strdup ((const gchar*) _tmp10_);
	album_art = _tmp11_;
	_tmp13_ = album_art;
	if (_tmp13_ == NULL) {
		_tmp12_ = TRUE;
	} else {
		const gchar* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		_tmp14_ = album_art;
		_tmp15_ = bool_parse (_tmp14_);
		_tmp12_ = !_tmp15_;
	}
	_tmp16_ = _tmp12_;
	if (_tmp16_) {
		_g_free0 (album_art);
		_g_hash_table_unref0 (params);
		return self;
	}
	_tmp17_ = uri;
	_tmp18_ = soup_uri_get_path (_tmp17_);
	_tmp19_ = g_strdup (_tmp18_);
	path = _tmp19_;
	_tmp20_ = path;
	_tmp22_ = _tmp21_ = g_strsplit (_tmp20_, "/", 0);
	_tmp23_ = _tmp22_;
	_tmp23__length1 = _vala_array_length (_tmp21_);
	_tmp24_ = ((_tmp23_ + 0) != NULL) ? _vala_array_dup2 (_tmp23_ + 0, 4 - 0) : ((gpointer) (_tmp23_ + 0));
	_tmp24__length1 = 4 - 0;
	_tmp25_ = _tmp24_;
	_tmp25__length1 = _tmp24__length1;
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
	particles = _tmp25_;
	particles_length1 = _tmp25__length1;
	_particles_size_ = particles_length1;
	_tmp26_ = particles;
	_tmp26__length1 = particles_length1;
	_tmp27_ = g_strdup ("th");
	_vala_array_add2 (&particles, &particles_length1, &_particles_size_, _tmp27_);
	_tmp28_ = particles;
	_tmp28__length1 = particles_length1;
	_tmp29_ = g_strdup ("0");
	_vala_array_add3 (&particles, &particles_length1, &_particles_size_, _tmp29_);
	_tmp30_ = uri;
	_tmp31_ = particles;
	_tmp31__length1 = particles_length1;
	_tmp32_ = g_strjoinv ("/", _tmp31_);
	_tmp33_ = _tmp32_;
	soup_uri_set_path (_tmp30_, _tmp33_);
	_g_free0 (_tmp33_);
	particles = (_vala_array_free (particles, particles_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (path);
	_g_free0 (album_art);
	_g_hash_table_unref0 (params);
	return self;
}


RygelXBoxHacks* rygel_xbox_hacks_new (SoupMessage* message, GError** error) {
	return rygel_xbox_hacks_construct (RYGEL_TYPE_XBOX_HACKS, message, error);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch73_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch73_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp5_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally73;
	__catch73_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally73:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


void rygel_xbox_hacks_apply_on_device (RygelXBoxHacks* self, RygelRootDevice* device, const gchar* template_path, GError** error) {
	RygelRootDevice* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	RygelDescriptionFile* description_file = NULL;
	const gchar* _tmp4_ = NULL;
	RygelDescriptionFile* _tmp5_ = NULL;
	RygelDescriptionFile* _tmp6_ = NULL;
	RygelDescriptionFile* _tmp7_ = NULL;
	gchar* friendly_name = NULL;
	RygelDescriptionFile* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	RygelDescriptionFile* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	RygelDescriptionFile* _tmp14_ = NULL;
	gchar* desc_path = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	RygelDescriptionFile* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* server_path = NULL;
	RygelRootDevice* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	RygelRootDevice* _tmp22_ = NULL;
	GUPnPContext* _tmp23_ = NULL;
	GUPnPContext* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	GRegex* _tmp27_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = device;
	_tmp1_ = gupnp_device_info_get_device_type ((GUPnPDeviceInfo*) _tmp0_);
	_tmp2_ = g_str_has_prefix (_tmp1_, RYGEL_XBOX_HACKS_DMS);
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = template_path;
	if (_tmp3_ == NULL) {
		return;
	}
	_tmp4_ = template_path;
	_tmp5_ = rygel_description_file_new (_tmp4_, &_inner_error_);
	description_file = _tmp5_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp6_ = description_file;
	rygel_description_file_set_model_name (_tmp6_, RYGEL_XBOX_HACKS_MODEL_NAME);
	_tmp7_ = description_file;
	rygel_description_file_set_model_number (_tmp7_, RYGEL_XBOX_HACKS_MODEL_VERSION);
	_tmp8_ = description_file;
	_tmp9_ = rygel_description_file_get_friendly_name (_tmp8_);
	friendly_name = _tmp9_;
	_tmp10_ = description_file;
	_tmp11_ = friendly_name;
	_tmp12_ = g_strconcat (_tmp11_, RYGEL_XBOX_HACKS_FRIENDLY_NAME_POSTFIX, NULL);
	_tmp13_ = _tmp12_;
	rygel_description_file_set_friendly_name (_tmp10_, _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = description_file;
	rygel_description_file_modify_service_type (_tmp14_, RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_TYPE, RYGEL_MEDIA_RECEIVER_REGISTRAR_COMPAT_TYPE);
	_tmp15_ = template_path;
	_tmp16_ = string_replace (_tmp15_, "v1.xml", "xbox.xml");
	desc_path = _tmp16_;
	_tmp17_ = description_file;
	_tmp18_ = desc_path;
	rygel_description_file_save (_tmp17_, _tmp18_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (desc_path);
		_g_free0 (friendly_name);
		_g_object_unref0 (description_file);
		return;
	}
	_tmp19_ = device;
	_tmp20_ = gupnp_root_device_get_relative_location ((GUPnPRootDevice*) _tmp19_);
	_tmp21_ = g_strconcat ("/", _tmp20_, NULL);
	server_path = _tmp21_;
	_tmp22_ = device;
	_tmp23_ = gupnp_device_info_get_context ((GUPnPDeviceInfo*) _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = desc_path;
	_tmp26_ = server_path;
	_tmp27_ = ((RygelClientHacks*) self)->agent_regex;
	gupnp_context_host_path_for_agent (_tmp24_, _tmp25_, _tmp26_, _tmp27_);
	_g_free0 (server_path);
	_g_free0 (desc_path);
	_g_free0 (friendly_name);
	_g_object_unref0 (description_file);
}


static void rygel_xbox_hacks_real_translate_container_id (RygelClientHacks* base, RygelMediaQueryAction* action, gchar** container_id) {
	RygelXBoxHacks * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	RygelMediaQueryAction* _tmp2_ = NULL;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp30_ = FALSE;
	self = (RygelXBoxHacks*) base;
	g_return_if_fail (action != NULL);
	g_return_if_fail (*container_id != NULL);
	_tmp2_ = action;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_SEARCH)) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp18_ = FALSE;
		_tmp8_ = *container_id;
		if (g_strcmp0 (_tmp8_, "1") == 0) {
			_tmp7_ = TRUE;
		} else {
			const gchar* _tmp9_ = NULL;
			_tmp9_ = *container_id;
			_tmp7_ = g_strcmp0 (_tmp9_, "4") == 0;
		}
		_tmp10_ = _tmp7_;
		if (_tmp10_) {
			_tmp6_ = TRUE;
		} else {
			const gchar* _tmp11_ = NULL;
			_tmp11_ = *container_id;
			_tmp6_ = g_strcmp0 (_tmp11_, "5") == 0;
		}
		_tmp12_ = _tmp6_;
		if (_tmp12_) {
			_tmp5_ = TRUE;
		} else {
			const gchar* _tmp13_ = NULL;
			_tmp13_ = *container_id;
			_tmp5_ = g_strcmp0 (_tmp13_, "6") == 0;
		}
		_tmp14_ = _tmp5_;
		if (_tmp14_) {
			_tmp4_ = TRUE;
		} else {
			const gchar* _tmp15_ = NULL;
			_tmp15_ = *container_id;
			_tmp4_ = g_strcmp0 (_tmp15_, "7") == 0;
		}
		_tmp16_ = _tmp4_;
		if (_tmp16_) {
			_tmp3_ = TRUE;
		} else {
			const gchar* _tmp17_ = NULL;
			_tmp17_ = *container_id;
			_tmp3_ = g_strcmp0 (_tmp17_, "F") == 0;
		}
		_tmp18_ = _tmp3_;
		_tmp1_ = _tmp18_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp19_ = _tmp1_;
	if (_tmp19_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		RygelMediaQueryAction* _tmp23_ = NULL;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp29_ = FALSE;
		_tmp23_ = action;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, RYGEL_TYPE_BROWSE)) {
			const gchar* _tmp24_ = NULL;
			_tmp24_ = *container_id;
			_tmp22_ = g_strcmp0 (_tmp24_, "15") == 0;
		} else {
			_tmp22_ = FALSE;
		}
		_tmp25_ = _tmp22_;
		if (_tmp25_) {
			_tmp21_ = TRUE;
		} else {
			const gchar* _tmp26_ = NULL;
			_tmp26_ = *container_id;
			_tmp21_ = g_strcmp0 (_tmp26_, "14") == 0;
		}
		_tmp27_ = _tmp21_;
		if (_tmp27_) {
			_tmp20_ = TRUE;
		} else {
			const gchar* _tmp28_ = NULL;
			_tmp28_ = *container_id;
			_tmp20_ = g_strcmp0 (_tmp28_, "16") == 0;
		}
		_tmp29_ = _tmp20_;
		_tmp0_ = _tmp29_;
	}
	_tmp30_ = _tmp0_;
	if (_tmp30_) {
		gchar* _tmp31_ = NULL;
		_tmp31_ = g_strdup ("0");
		_g_free0 (*container_id);
		*container_id = _tmp31_;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_xbox_hacks_real_apply (RygelClientHacks* base, RygelMediaObject* object) {
	RygelXBoxHacks * self;
	RygelMediaObject* _tmp0_ = NULL;
	RygelMediaItem* item = NULL;
	RygelMediaObject* _tmp5_ = NULL;
	RygelMediaItem* _tmp6_ = NULL;
	RygelMediaItem* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	self = (RygelXBoxHacks*) base;
	g_return_if_fail (object != NULL);
	_tmp0_ = object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_CONTAINER)) {
		RygelMediaObject* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		_tmp1_ = object;
		_tmp2_ = rygel_media_object_get_upnp_class (_tmp1_);
		_tmp3_ = _tmp2_;
		if (g_strcmp0 (_tmp3_, RYGEL_MEDIA_CONTAINER_UPNP_CLASS) == 0) {
			RygelMediaObject* _tmp4_ = NULL;
			_tmp4_ = object;
			rygel_media_object_set_upnp_class (_tmp4_, RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER);
		}
		return;
	}
	_tmp5_ = object;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp5_) : NULL);
	item = _tmp6_;
	_tmp7_ = item;
	_tmp8_ = rygel_media_item_get_mime_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (g_strcmp0 (_tmp9_, "video/x-msvideo") == 0) {
		RygelMediaItem* _tmp10_ = NULL;
		_tmp10_ = item;
		rygel_media_item_set_mime_type (_tmp10_, "video/avi");
	} else {
		RygelMediaItem* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		_tmp11_ = item;
		_tmp12_ = rygel_media_item_get_mime_type (_tmp11_);
		_tmp13_ = _tmp12_;
		if (g_strcmp0 (_tmp13_, "video/mpeg") == 0) {
			RygelMediaItem* _tmp14_ = NULL;
			_tmp14_ = item;
			rygel_media_item_set_mime_type (_tmp14_, "invalid/content");
		}
	}
	_g_object_unref0 (item);
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_ = 0L;
	gboolean _tmp17_ = FALSE;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static void rygel_xbox_hacks_real_filter_sort_criteria (RygelClientHacks* base, gchar** sort_criteria) {
	RygelXBoxHacks * self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	self = (RygelXBoxHacks*) base;
	g_return_if_fail (*sort_criteria != NULL);
	_tmp0_ = *sort_criteria;
	_tmp1_ = string_replace (_tmp0_, "+microsoft:sourceURL", "");
	_g_free0 (*sort_criteria);
	*sort_criteria = _tmp1_;
	_tmp2_ = *sort_criteria;
	_tmp3_ = string_replace (_tmp2_, ",,", ",");
	_g_free0 (*sort_criteria);
	*sort_criteria = _tmp3_;
	_tmp4_ = *sort_criteria;
	_tmp5_ = g_str_has_prefix (_tmp4_, ",");
	if (_tmp5_) {
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gchar* _tmp10_ = NULL;
		_tmp6_ = *sort_criteria;
		_tmp7_ = *sort_criteria;
		_tmp8_ = strlen (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = string_slice (_tmp6_, (glong) 1, (glong) _tmp9_);
		_g_free0 (*sort_criteria);
		*sort_criteria = _tmp10_;
	}
}


static void rygel_xbox_hacks_real_search_data_free (gpointer _data) {
	RygelXboxHacksSearchData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->container);
	_rygel_search_expression_unref0 (_data_->expression);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelXboxHacksSearchData, _data_);
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static void rygel_xbox_hacks_real_search (RygelClientHacks* base, RygelSearchableContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelXBoxHacks * self;
	RygelXboxHacksSearchData* _data_;
	RygelXBoxHacks* _tmp0_ = NULL;
	RygelSearchableContainer* _tmp1_ = NULL;
	RygelSearchableContainer* _tmp2_ = NULL;
	RygelSearchExpression* _tmp3_ = NULL;
	RygelSearchExpression* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GCancellable* _tmp9_ = NULL;
	GCancellable* _tmp10_ = NULL;
	self = (RygelXBoxHacks*) base;
	_data_ = g_slice_new0 (RygelXboxHacksSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_xbox_hacks_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_xbox_hacks_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = container;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->container);
	_data_->container = _tmp2_;
	_tmp3_ = expression;
	_tmp4_ = _rygel_search_expression_ref0 (_tmp3_);
	_rygel_search_expression_unref0 (_data_->expression);
	_data_->expression = _tmp4_;
	_tmp5_ = offset;
	_data_->offset = _tmp5_;
	_tmp6_ = max_count;
	_data_->max_count = _tmp6_;
	_tmp7_ = sort_criteria;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp8_;
	_tmp9_ = cancellable;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp10_;
	rygel_xbox_hacks_real_search_co (_data_);
}


static RygelMediaObjects* rygel_xbox_hacks_real_search_finish (RygelClientHacks* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelXboxHacksSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_xbox_hacks_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelXboxHacksSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_xbox_hacks_real_search_co (_data_);
}


static gboolean rygel_xbox_hacks_real_search_co (RygelXboxHacksSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->set_total_matches = FALSE;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->expression;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _rygel_search_expression_ref0 (_data_->_tmp0_);
	_data_->modified_expression = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->expression;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp2_, RYGEL_TYPE_RELATIONAL_EXPRESSION)) {
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->expression;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp3_, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) _data_->_tmp3_) : NULL);
		_data_->rel_expression = _data_->_tmp4_;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->rel_expression;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = ((RygelSearchExpression*) _data_->_tmp6_)->operand1;
		_data_->_tmp8_ = FALSE;
		_data_->_tmp8_ = G_LIKELY (((const gchar*) _data_->_tmp7_) != NULL);
		if (_data_->_tmp8_) {
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _data_->rel_expression;
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = ((RygelSearchExpression*) _data_->_tmp9_)->operand1;
			_data_->_tmp5_ = g_strcmp0 ((const gchar*) _data_->_tmp10_, "upnp:class") == 0;
		} else {
			_data_->_tmp5_ = FALSE;
		}
		_data_->_tmp11_ = FALSE;
		_data_->_tmp11_ = _data_->_tmp5_;
		if (_data_->_tmp11_) {
			_data_->set_total_matches = TRUE;
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->rel_expression;
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = ((RygelSearchExpression*) _data_->_tmp15_)->op;
			if (((GUPnPSearchCriteriaOp) ((gintptr) _data_->_tmp16_)) == GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM) {
				_data_->_tmp17_ = NULL;
				_data_->_tmp17_ = _data_->rel_expression;
				_data_->_tmp18_ = NULL;
				_data_->_tmp18_ = ((RygelSearchExpression*) _data_->_tmp17_)->operand2;
				_data_->_tmp14_ = ((const gchar*) _data_->_tmp18_) != NULL;
			} else {
				_data_->_tmp14_ = FALSE;
			}
			_data_->_tmp19_ = FALSE;
			_data_->_tmp19_ = _data_->_tmp14_;
			if (_data_->_tmp19_) {
				_data_->_tmp20_ = NULL;
				_data_->_tmp20_ = _data_->rel_expression;
				_data_->_tmp21_ = NULL;
				_data_->_tmp21_ = ((RygelSearchExpression*) _data_->_tmp20_)->operand2;
				_data_->_tmp13_ = g_strcmp0 ((const gchar*) _data_->_tmp21_, RYGEL_AUDIO_ITEM_UPNP_CLASS) == 0;
			} else {
				_data_->_tmp13_ = FALSE;
			}
			_data_->_tmp22_ = FALSE;
			_data_->_tmp22_ = _data_->_tmp13_;
			if (_data_->_tmp22_) {
				_data_->_tmp23_ = NULL;
				_data_->_tmp23_ = _data_->container;
				_data_->_tmp24_ = NULL;
				_data_->_tmp24_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp23_);
				_data_->_tmp25_ = NULL;
				_data_->_tmp25_ = _data_->_tmp24_;
				_data_->_tmp12_ = g_strcmp0 (_data_->_tmp25_, "0") == 0;
			} else {
				_data_->_tmp12_ = FALSE;
			}
			_data_->_tmp26_ = FALSE;
			_data_->_tmp26_ = _data_->_tmp12_;
			if (_data_->_tmp26_) {
				_data_->_tmp27_ = NULL;
				_data_->_tmp27_ = _data_->expression;
				_data_->_tmp28_ = NULL;
				_data_->_tmp28_ = rygel_xbox_hacks_rewrite_search_expression (_data_->self, _data_->_tmp27_);
				_rygel_search_expression_unref0 (_data_->modified_expression);
				_data_->modified_expression = _data_->_tmp28_;
			}
		}
		_rygel_search_expression_unref0 (_data_->rel_expression);
	}
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = _data_->container;
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _data_->modified_expression;
	_data_->_tmp31_ = 0U;
	_data_->_tmp31_ = _data_->offset;
	_data_->_tmp32_ = 0U;
	_data_->_tmp32_ = _data_->max_count;
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = _data_->sort_criteria;
	_data_->_tmp34_ = NULL;
	_data_->_tmp34_ = _data_->cancellable;
	_data_->_tmp35_ = 0U;
	_data_->_state_ = 1;
	rygel_searchable_container_search (_data_->_tmp29_, _data_->_tmp30_, _data_->_tmp31_, _data_->_tmp32_, _data_->_tmp33_, _data_->_tmp34_, rygel_xbox_hacks_search_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp36_ = NULL;
	_data_->_tmp36_ = rygel_searchable_container_search_finish (_data_->_tmp29_, _data_->_res_, &_data_->_tmp35_, &_data_->_inner_error_);
	_data_->total_matches = _data_->_tmp35_;
	_data_->results = _data_->_tmp36_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_rygel_search_expression_unref0 (_data_->modified_expression);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp38_ = 0U;
	_data_->_tmp38_ = _data_->total_matches;
	if (_data_->_tmp38_ == ((guint) 0)) {
		_data_->_tmp39_ = FALSE;
		_data_->_tmp39_ = _data_->set_total_matches;
		_data_->_tmp37_ = _data_->_tmp39_;
	} else {
		_data_->_tmp37_ = FALSE;
	}
	_data_->_tmp40_ = FALSE;
	_data_->_tmp40_ = _data_->_tmp37_;
	if (_data_->_tmp40_) {
		_data_->_tmp41_ = 0;
		_data_->_tmp41_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->results);
		_data_->_tmp42_ = 0;
		_data_->_tmp42_ = _data_->_tmp41_;
		_data_->total_matches = (guint) _data_->_tmp42_;
	}
	_data_->result = _data_->results;
	_rygel_search_expression_unref0 (_data_->modified_expression);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->results);
	_rygel_search_expression_unref0 (_data_->modified_expression);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static RygelSearchExpression* rygel_xbox_hacks_rewrite_search_expression (RygelXBoxHacks* self, RygelSearchExpression* expression) {
	RygelSearchExpression* result = NULL;
	RygelRelationalExpression* ref_id_expression = NULL;
	RygelRelationalExpression* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	RygelLogicalExpression* new_expression = NULL;
	RygelLogicalExpression* _tmp3_ = NULL;
	RygelSearchExpression* _tmp4_ = NULL;
	RygelSearchExpression* _tmp5_ = NULL;
	RygelSearchExpression* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expression != NULL, NULL);
	_tmp0_ = rygel_relational_expression_new ();
	ref_id_expression = _tmp0_;
	_tmp1_ = g_strdup ("@refID");
	_g_free0 (((RygelSearchExpression*) ref_id_expression)->operand1);
	((RygelSearchExpression*) ref_id_expression)->operand1 = _tmp1_;
	((RygelSearchExpression*) ref_id_expression)->op = (gpointer) ((gintptr) GUPNP_SEARCH_CRITERIA_OP_EXISTS);
	_tmp2_ = g_strdup ("false");
	_g_free0 (((RygelSearchExpression*) ref_id_expression)->operand2);
	((RygelSearchExpression*) ref_id_expression)->operand2 = _tmp2_;
	_tmp3_ = rygel_logical_expression_new ();
	new_expression = _tmp3_;
	_tmp4_ = expression;
	_tmp5_ = _rygel_search_expression_ref0 (_tmp4_);
	_rygel_search_expression_unref0 (((RygelSearchExpression*) new_expression)->operand1);
	((RygelSearchExpression*) new_expression)->operand1 = _tmp5_;
	((RygelSearchExpression*) new_expression)->op = (gpointer) ((gintptr) RYGEL_LOGICAL_OPERATOR_AND);
	_tmp6_ = _rygel_search_expression_ref0 ((RygelSearchExpression*) ref_id_expression);
	_rygel_search_expression_unref0 (((RygelSearchExpression*) new_expression)->operand2);
	((RygelSearchExpression*) new_expression)->operand2 = _tmp6_;
	result = (RygelSearchExpression*) new_expression;
	_rygel_search_expression_unref0 (ref_id_expression);
	return result;
}


static void rygel_xbox_hacks_class_init (RygelXBoxHacksClass * klass) {
	rygel_xbox_hacks_parent_class = g_type_class_peek_parent (klass);
	RYGEL_CLIENT_HACKS_CLASS (klass)->translate_container_id = rygel_xbox_hacks_real_translate_container_id;
	RYGEL_CLIENT_HACKS_CLASS (klass)->apply = rygel_xbox_hacks_real_apply;
	RYGEL_CLIENT_HACKS_CLASS (klass)->filter_sort_criteria = rygel_xbox_hacks_real_filter_sort_criteria;
	RYGEL_CLIENT_HACKS_CLASS (klass)->search = rygel_xbox_hacks_real_search;
	RYGEL_CLIENT_HACKS_CLASS (klass)->search_finish = rygel_xbox_hacks_real_search_finish;
}


static void rygel_xbox_hacks_instance_init (RygelXBoxHacks * self) {
}


GType rygel_xbox_hacks_get_type (void) {
	static volatile gsize rygel_xbox_hacks_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_xbox_hacks_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelXBoxHacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_xbox_hacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelXBoxHacks), 0, (GInstanceInitFunc) rygel_xbox_hacks_instance_init, NULL };
		GType rygel_xbox_hacks_type_id;
		rygel_xbox_hacks_type_id = g_type_register_static (RYGEL_TYPE_CLIENT_HACKS, "RygelXBoxHacks", &g_define_type_info, 0);
		g_once_init_leave (&rygel_xbox_hacks_type_id__volatile, rygel_xbox_hacks_type_id);
	}
	return rygel_xbox_hacks_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



