/* rygel-transcode-manager.c generated by valac 0.26.0.39-f3603, the Vala compiler
 * generated from rygel-transcode-manager.vala, do not modify */

/*
 * Copyright (C) 2009-2012 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>
#include <glib/gi18n-lib.h>
#include <libsoup/soup.h>


#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_ENGINE (rygel_media_engine_get_type ())
#define RYGEL_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngine))
#define RYGEL_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))
#define RYGEL_IS_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_IS_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_MEDIA_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))

typedef struct _RygelMediaEngine RygelMediaEngine;
typedef struct _RygelMediaEngineClass RygelMediaEngineClass;

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	gchar* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_target);
	gchar* (*get_protocol) (RygelTranscodeManager* self);
	GeeArrayList* (*get_protocol_info) (RygelTranscodeManager* self);
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()

static gpointer rygel_transcode_manager_parent_class = NULL;

GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_TRANSCODE_MANAGER_DUMMY_PROPERTY
};
static gboolean rygel_transcode_manager_protocol_equal_func (GUPnPProtocolInfo* a, GUPnPProtocolInfo* b);
RygelTranscodeManager* rygel_transcode_manager_construct (GType object_type);
gchar* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_target);
static gchar* rygel_transcode_manager_real_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_target);
void rygel_transcode_manager_add_resources (RygelTranscodeManager* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
GType rygel_media_engine_get_type (void) G_GNUC_CONST;
RygelMediaEngine* rygel_media_engine_get_default (void);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
GList* rygel_media_engine_get_transcoders (RygelMediaEngine* self);
guint rygel_transcoder_get_distance (RygelTranscoder* self, RygelMediaItem* item);
gint rygel_media_item_compare_transcoders (RygelMediaItem* self, RygelTranscoder* transcoder1, RygelTranscoder* transcoder2);
static gint _rygel_media_item_compare_transcoders_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
GUPnPDIDLLiteResource* rygel_transcoder_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
RygelTranscoder* rygel_transcode_manager_get_transcoder (RygelTranscodeManager* self, const gchar* target, GError** error);
gboolean rygel_transcoder_can_handle (RygelTranscoder* self, const gchar* target);
GQuark rygel_http_request_error_quark (void);
gchar* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self);
static gchar* rygel_transcode_manager_real_get_protocol (RygelTranscodeManager* self);
GeeArrayList* rygel_transcode_manager_get_protocol_info (RygelTranscodeManager* self);
static GeeArrayList* rygel_transcode_manager_real_get_protocol_info (RygelTranscodeManager* self);
static gboolean _rygel_transcode_manager_protocol_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
const gchar* rygel_transcoder_get_mime_type (RygelTranscoder* self);
const gchar* rygel_transcoder_get_dlna_profile (RygelTranscoder* self);


static gboolean rygel_transcode_manager_protocol_equal_func (GUPnPProtocolInfo* a, GUPnPProtocolInfo* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GUPnPProtocolInfo* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GUPnPProtocolInfo* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp1_ = a;
	_tmp2_ = gupnp_protocol_info_get_dlna_profile (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = b;
	_tmp5_ = gupnp_protocol_info_get_dlna_profile (_tmp4_);
	_tmp6_ = _tmp5_;
	if (g_strcmp0 (_tmp3_, _tmp6_) == 0) {
		GUPnPProtocolInfo* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GUPnPProtocolInfo* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		_tmp7_ = a;
		_tmp8_ = gupnp_protocol_info_get_mime_type (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = b;
		_tmp11_ = gupnp_protocol_info_get_mime_type (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp0_ = g_strcmp0 (_tmp9_, _tmp12_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


RygelTranscodeManager* rygel_transcode_manager_construct (GType object_type) {
	RygelTranscodeManager * self = NULL;
	self = (RygelTranscodeManager*) g_object_new (object_type, NULL);
	return self;
}


static gchar* rygel_transcode_manager_real_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_target) {
	g_critical ("Type `%s' does not implement abstract method `rygel_transcode_manager_create_uri_for_item'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_target) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_TRANSCODE_MANAGER_GET_CLASS (self)->create_uri_for_item (self, item, thumbnail_index, subtitle_index, transcode_target, playlist_target);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gint _rygel_media_item_compare_transcoders_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = rygel_media_item_compare_transcoders ((RygelMediaItem*) self, (RygelTranscoder*) a, (RygelTranscoder*) b);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


void rygel_transcode_manager_add_resources (RygelTranscodeManager* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error) {
	RygelMediaEngine* engine = NULL;
	RygelMediaEngine* _tmp0_ = NULL;
	GList* list = NULL;
	GList* transcoders = NULL;
	RygelMediaEngine* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	RygelMediaItem* _tmp10_ = NULL;
	GList* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (didl_item != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = rygel_media_engine_get_default ();
	engine = _tmp0_;
	list = NULL;
	_tmp1_ = engine;
	_tmp2_ = rygel_media_engine_get_transcoders (_tmp1_);
	transcoders = _tmp2_;
	_tmp3_ = transcoders;
	{
		GList* transcoder_collection = NULL;
		GList* transcoder_it = NULL;
		transcoder_collection = _tmp3_;
		for (transcoder_it = transcoder_collection; transcoder_it != NULL; transcoder_it = transcoder_it->next) {
			RygelTranscoder* _tmp4_ = NULL;
			RygelTranscoder* transcoder = NULL;
			_tmp4_ = _g_object_ref0 ((RygelTranscoder*) transcoder_it->data);
			transcoder = _tmp4_;
			{
				RygelTranscoder* _tmp5_ = NULL;
				RygelMediaItem* _tmp6_ = NULL;
				guint _tmp7_ = 0U;
				_tmp5_ = transcoder;
				_tmp6_ = item;
				_tmp7_ = rygel_transcoder_get_distance (_tmp5_, _tmp6_);
				if (_tmp7_ != G_MAXUINT) {
					RygelTranscoder* _tmp8_ = NULL;
					RygelTranscoder* _tmp9_ = NULL;
					_tmp8_ = transcoder;
					_tmp9_ = _g_object_ref0 (_tmp8_);
					list = g_list_append (list, _tmp9_);
				}
				_g_object_unref0 (transcoder);
			}
		}
	}
	_tmp10_ = item;
	list = g_list_sort_with_data (list, _rygel_media_item_compare_transcoders_gcompare_data_func, _tmp10_);
	_tmp11_ = list;
	{
		GList* transcoder_collection = NULL;
		GList* transcoder_it = NULL;
		transcoder_collection = _tmp11_;
		for (transcoder_it = transcoder_collection; transcoder_it != NULL; transcoder_it = transcoder_it->next) {
			RygelTranscoder* _tmp12_ = NULL;
			RygelTranscoder* transcoder = NULL;
			_tmp12_ = _g_object_ref0 ((RygelTranscoder*) transcoder_it->data);
			transcoder = _tmp12_;
			{
				RygelTranscoder* _tmp13_ = NULL;
				GUPnPDIDLLiteItem* _tmp14_ = NULL;
				RygelMediaItem* _tmp15_ = NULL;
				GUPnPDIDLLiteResource* _tmp16_ = NULL;
				GUPnPDIDLLiteResource* _tmp17_ = NULL;
				_tmp13_ = transcoder;
				_tmp14_ = didl_item;
				_tmp15_ = item;
				_tmp16_ = rygel_transcoder_add_resource (_tmp13_, _tmp14_, _tmp15_, self, &_inner_error_);
				_tmp17_ = _tmp16_;
				_g_object_unref0 (_tmp17_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (transcoder);
					__g_list_free__g_object_unref0_0 (list);
					_g_object_unref0 (engine);
					return;
				}
				_g_object_unref0 (transcoder);
			}
		}
	}
	__g_list_free__g_object_unref0_0 (list);
	_g_object_unref0 (engine);
}


RygelTranscoder* rygel_transcode_manager_get_transcoder (RygelTranscodeManager* self, const gchar* target, GError** error) {
	RygelTranscoder* result = NULL;
	RygelTranscoder* transcoder = NULL;
	RygelMediaEngine* _tmp0_ = NULL;
	RygelMediaEngine* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	RygelTranscoder* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (target != NULL, NULL);
	transcoder = NULL;
	_tmp0_ = rygel_media_engine_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = rygel_media_engine_get_transcoders (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	{
		GList* iter_collection = NULL;
		GList* iter_it = NULL;
		iter_collection = _tmp3_;
		for (iter_it = iter_collection; iter_it != NULL; iter_it = iter_it->next) {
			RygelTranscoder* _tmp4_ = NULL;
			RygelTranscoder* iter = NULL;
			_tmp4_ = _g_object_ref0 ((RygelTranscoder*) iter_it->data);
			iter = _tmp4_;
			{
				RygelTranscoder* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				_tmp5_ = iter;
				_tmp6_ = target;
				_tmp7_ = rygel_transcoder_can_handle (_tmp5_, _tmp6_);
				if (_tmp7_) {
					RygelTranscoder* _tmp8_ = NULL;
					RygelTranscoder* _tmp9_ = NULL;
					_tmp8_ = iter;
					_tmp9_ = _g_object_ref0 (_tmp8_);
					_g_object_unref0 (transcoder);
					transcoder = _tmp9_;
				}
				_g_object_unref0 (iter);
			}
		}
	}
	_tmp10_ = transcoder;
	if (_tmp10_ == NULL) {
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		_tmp11_ = _ ("No transcoder available for target format '%s'");
		_tmp12_ = target;
		_tmp13_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp11_, _tmp12_);
		_inner_error_ = _tmp13_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (transcoder);
		return NULL;
	}
	result = transcoder;
	return result;
}


static gchar* rygel_transcode_manager_real_get_protocol (RygelTranscodeManager* self) {
	g_critical ("Type `%s' does not implement abstract method `rygel_transcode_manager_get_protocol'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_TRANSCODE_MANAGER_GET_CLASS (self)->get_protocol (self);
}


static gboolean _rygel_transcode_manager_protocol_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = rygel_transcode_manager_protocol_equal_func ((GUPnPProtocolInfo*) a, (GUPnPProtocolInfo*) b);
	return result;
}


static GeeArrayList* rygel_transcode_manager_real_get_protocol_info (RygelTranscodeManager* self) {
	GeeArrayList* result = NULL;
	RygelMediaEngine* engine = NULL;
	RygelMediaEngine* _tmp0_ = NULL;
	GeeArrayList* protocol_infos = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GList* transcoders = NULL;
	RygelMediaEngine* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	_tmp0_ = rygel_media_engine_get_default ();
	engine = _tmp0_;
	_tmp1_ = gee_array_list_new (gupnp_protocol_info_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, _rygel_transcode_manager_protocol_equal_func_gee_equal_data_func, NULL, NULL);
	protocol_infos = _tmp1_;
	_tmp2_ = engine;
	_tmp3_ = rygel_media_engine_get_transcoders (_tmp2_);
	transcoders = _tmp3_;
	_tmp4_ = transcoders;
	{
		GList* transcoder_collection = NULL;
		GList* transcoder_it = NULL;
		transcoder_collection = _tmp4_;
		for (transcoder_it = transcoder_collection; transcoder_it != NULL; transcoder_it = transcoder_it->next) {
			RygelTranscoder* _tmp5_ = NULL;
			RygelTranscoder* transcoder = NULL;
			_tmp5_ = _g_object_ref0 ((RygelTranscoder*) transcoder_it->data);
			transcoder = _tmp5_;
			{
				GUPnPProtocolInfo* protocol_info = NULL;
				GUPnPProtocolInfo* _tmp6_ = NULL;
				GUPnPProtocolInfo* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				GUPnPProtocolInfo* _tmp10_ = NULL;
				RygelTranscoder* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				GUPnPProtocolInfo* _tmp14_ = NULL;
				RygelTranscoder* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				GeeArrayList* _tmp18_ = NULL;
				GUPnPProtocolInfo* _tmp19_ = NULL;
				_tmp6_ = gupnp_protocol_info_new ();
				protocol_info = _tmp6_;
				_tmp7_ = protocol_info;
				_tmp8_ = rygel_transcode_manager_get_protocol (self);
				_tmp9_ = _tmp8_;
				gupnp_protocol_info_set_protocol (_tmp7_, _tmp9_);
				_g_free0 (_tmp9_);
				_tmp10_ = protocol_info;
				_tmp11_ = transcoder;
				_tmp12_ = rygel_transcoder_get_mime_type (_tmp11_);
				_tmp13_ = _tmp12_;
				gupnp_protocol_info_set_mime_type (_tmp10_, _tmp13_);
				_tmp14_ = protocol_info;
				_tmp15_ = transcoder;
				_tmp16_ = rygel_transcoder_get_dlna_profile (_tmp15_);
				_tmp17_ = _tmp16_;
				gupnp_protocol_info_set_dlna_profile (_tmp14_, _tmp17_);
				_tmp18_ = protocol_infos;
				_tmp19_ = protocol_info;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp19_);
				_g_object_unref0 (protocol_info);
				_g_object_unref0 (transcoder);
			}
		}
	}
	result = protocol_infos;
	_g_object_unref0 (engine);
	return result;
}


GeeArrayList* rygel_transcode_manager_get_protocol_info (RygelTranscodeManager* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_TRANSCODE_MANAGER_GET_CLASS (self)->get_protocol_info (self);
}


static void rygel_transcode_manager_class_init (RygelTranscodeManagerClass * klass) {
	rygel_transcode_manager_parent_class = g_type_class_peek_parent (klass);
	((RygelTranscodeManagerClass *) klass)->create_uri_for_item = rygel_transcode_manager_real_create_uri_for_item;
	((RygelTranscodeManagerClass *) klass)->get_protocol = rygel_transcode_manager_real_get_protocol;
	((RygelTranscodeManagerClass *) klass)->get_protocol_info = rygel_transcode_manager_real_get_protocol_info;
}


static void rygel_transcode_manager_instance_init (RygelTranscodeManager * self) {
}


/**
 * Responsible for management of all transcoders:
 * # Gets the appropriate transcoder given a transcoding target.
 * # Provide all possible transcoding resources for items.
 */
GType rygel_transcode_manager_get_type (void) {
	static volatile gsize rygel_transcode_manager_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_transcode_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTranscodeManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_transcode_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTranscodeManager), 0, (GInstanceInitFunc) rygel_transcode_manager_instance_init, NULL };
		GType rygel_transcode_manager_type_id;
		rygel_transcode_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelTranscodeManager", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_transcode_manager_type_id__volatile, rygel_transcode_manager_type_id);
	}
	return rygel_transcode_manager_type_id__volatile;
}



