/* rygel-writable-user-config.c generated by valac 0.42.2, the Vala compiler
 * generated from rygel-writable-user-config.vala, do not modify */

/*
 * Copyright (C) 2008-2011 Nokia Corporation.
 * Copyright (C) 2008,2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <config.h>


#define RYGEL_TYPE_WRITABLE_USER_CONFIG (rygel_writable_user_config_get_type ())
#define RYGEL_WRITABLE_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_USER_CONFIG, RygelWritableUserConfig))
#define RYGEL_WRITABLE_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WRITABLE_USER_CONFIG, RygelWritableUserConfigClass))
#define RYGEL_IS_WRITABLE_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_USER_CONFIG))
#define RYGEL_IS_WRITABLE_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WRITABLE_USER_CONFIG))
#define RYGEL_WRITABLE_USER_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WRITABLE_USER_CONFIG, RygelWritableUserConfigClass))

typedef struct _RygelWritableUserConfig RygelWritableUserConfig;
typedef struct _RygelWritableUserConfigClass RygelWritableUserConfigClass;
typedef struct _RygelWritableUserConfigPrivate RygelWritableUserConfigPrivate;
enum  {
	RYGEL_WRITABLE_USER_CONFIG_0_PROPERTY,
	RYGEL_WRITABLE_USER_CONFIG_NUM_PROPERTIES
};
static GParamSpec* rygel_writable_user_config_properties[RYGEL_WRITABLE_USER_CONFIG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

struct _RygelWritableUserConfig {
	RygelUserConfig parent_instance;
	RygelWritableUserConfigPrivate * priv;
};

struct _RygelWritableUserConfigClass {
	RygelUserConfigClass parent_class;
};

struct _RygelWritableUserConfigPrivate {
	GFile* user_config;
};

struct _Block1Data {
	int _ref_count_;
	RygelWritableUserConfig* self;
	GMainLoop* loop;
};


static gint RygelWritableUserConfig_private_offset;
static gpointer rygel_writable_user_config_parent_class = NULL;

GType rygel_writable_user_config_get_type (void) G_GNUC_CONST;
#define RYGEL_WRITABLE_USER_CONFIG_RYGEL_SERVICE "org.gnome.Rygel1"
#define RYGEL_WRITABLE_USER_CONFIG_RYGEL_PATH "/org/gnome/Rygel1"
#define RYGEL_WRITABLE_USER_CONFIG_RYGEL_INTERFACE "org.gnome.Rygel1"
RygelWritableUserConfig* rygel_writable_user_config_new (GError** error);
RygelWritableUserConfig* rygel_writable_user_config_construct (GType object_type,
                                                               GError** error);
gboolean rygel_writable_user_config_is_upnp_enabled (RygelWritableUserConfig* self);
static GFile* rygel_writable_user_config_get_autostart_file (RygelWritableUserConfig* self,
                                                      GError** error);
void rygel_writable_user_config_set_upnp_enabled (RygelWritableUserConfig* self,
                                                  gboolean value);
static void rygel_writable_user_config_enable_upnp (RygelWritableUserConfig* self,
                                             gboolean enable);
void rygel_writable_user_config_set_interface (RygelWritableUserConfig* self,
                                               const gchar* value);
void rygel_writable_user_config_set_string (RygelWritableUserConfig* self,
                                            const gchar* section,
                                            const gchar* key,
                                            const gchar* value);
void rygel_writable_user_config_set_port (RygelWritableUserConfig* self,
                                          gint value);
void rygel_writable_user_config_set_int (RygelWritableUserConfig* self,
                                         const gchar* section,
                                         const gchar* key,
                                         gint value);
void rygel_writable_user_config_set_transcoding (RygelWritableUserConfig* self,
                                                 gboolean value);
void rygel_writable_user_config_set_bool (RygelWritableUserConfig* self,
                                          const gchar* section,
                                          const gchar* key,
                                          gboolean value);
void rygel_writable_user_config_set_allow_upload (RygelWritableUserConfig* self,
                                                  gboolean value,
                                                  GError** error);
void rygel_writable_user_config_set_allow_deletion (RygelWritableUserConfig* self,
                                                    gboolean value,
                                                    GError** error);
void rygel_writable_user_config_save (RygelWritableUserConfig* self);
void rygel_writable_user_config_set_string_list (RygelWritableUserConfig* self,
                                                 const gchar* section,
                                                 const gchar* key,
                                                 GeeArrayList* str_list);
static void rygel_writable_user_config_ensure_dir_exists (RygelWritableUserConfig* self,
                                                   const gchar* dir_path,
                                                   GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ____lambda4_ (Block1Data* _data1_);
static void _____lambda4__gbus_name_appeared_callback (GDBusConnection* connection,
                                                const gchar* name,
                                                const gchar* name_owner,
                                                gpointer self);
static void ____lambda5_ (Block1Data* _data1_);
static void _____lambda5__gbus_name_vanished_callback (GDBusConnection* connection,
                                                const gchar* name,
                                                gpointer self);
static void rygel_writable_user_config_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static inline gpointer
rygel_writable_user_config_get_instance_private (RygelWritableUserConfig* self)
{
	return G_STRUCT_MEMBER_P (self, RygelWritableUserConfig_private_offset);
}


RygelWritableUserConfig*
rygel_writable_user_config_construct (GType object_type,
                                      GError** error)
{
	RygelWritableUserConfig * self = NULL;
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_build_filename (_tmp0_, RYGEL_USER_CONFIG_CONFIG_FILE, NULL);
	path = _tmp1_;
	self = (RygelWritableUserConfig*) rygel_user_config_construct (object_type, path, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (path);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp2_ = g_file_new_for_path (path);
	_g_object_unref0 (self->priv->user_config);
	self->priv->user_config = _tmp2_;
	_tmp3_ = self->priv->user_config;
	if (!g_file_query_exists (_tmp3_, NULL)) {
		{
			GKeyFile* _tmp4_;
			GKeyFile* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp4_ = ((RygelUserConfig*) self)->key_file;
			_tmp5_ = ((RygelUserConfig*) self)->sys_key_file;
			_tmp6_ = g_key_file_to_data (_tmp5_, NULL, NULL);
			_tmp7_ = _tmp6_;
			g_key_file_load_from_data (_tmp4_, _tmp7_, (gsize) -1, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error_);
			_g_free0 (_tmp7_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* _error_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			g_assert_not_reached ();
			_g_error_free0 (_error_);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (path);
			_g_object_unref0 (self);
			return NULL;
		}
	}
	_g_free0 (path);
	return self;
}


RygelWritableUserConfig*
rygel_writable_user_config_new (GError** error)
{
	return rygel_writable_user_config_construct (RYGEL_TYPE_WRITABLE_USER_CONFIG, error);
}


gboolean
rygel_writable_user_config_is_upnp_enabled (RygelWritableUserConfig* self)
{
	gboolean result = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GFile* autostart_file = NULL;
		GFile* _tmp0_;
		_tmp0_ = rygel_writable_user_config_get_autostart_file (self, &_inner_error_);
		autostart_file = _tmp0_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		result = g_file_query_exists (autostart_file, NULL);
		_g_object_unref0 (autostart_file);
		return result;
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (_error_);
		return result;
	}
	__finally3:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return _tmp1_;
}


void
rygel_writable_user_config_set_upnp_enabled (RygelWritableUserConfig* self,
                                             gboolean value)
{
	gboolean enabled = FALSE;
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	enabled = FALSE;
	enabled = rygel_writable_user_config_is_upnp_enabled (self);
	_tmp0_ = enabled;
	if (value != _tmp0_) {
		rygel_writable_user_config_enable_upnp (self, value);
	}
}


void
rygel_writable_user_config_set_interface (RygelWritableUserConfig* self,
                                          const gchar* value)
{
	gchar* iface = NULL;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (iface);
		iface = _tmp0_;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		_g_free0 (iface);
		iface = _tmp1_;
	}
	_tmp2_ = iface;
	rygel_writable_user_config_set_string (self, "general", RYGEL_USER_CONFIG_IFACE_KEY, _tmp2_);
	_g_free0 (iface);
}


void
rygel_writable_user_config_set_port (RygelWritableUserConfig* self,
                                     gint value)
{
	g_return_if_fail (self != NULL);
	rygel_writable_user_config_set_int (self, "general", RYGEL_USER_CONFIG_PORT_KEY, value);
}


void
rygel_writable_user_config_set_transcoding (RygelWritableUserConfig* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	rygel_writable_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_TRANSCODING_KEY, value);
}


void
rygel_writable_user_config_set_allow_upload (RygelWritableUserConfig* self,
                                             gboolean value,
                                             GError** error)
{
	g_return_if_fail (self != NULL);
	rygel_writable_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_ALLOW_UPLOAD_KEY, value);
}


void
rygel_writable_user_config_set_allow_deletion (RygelWritableUserConfig* self,
                                               gboolean value,
                                               GError** error)
{
	g_return_if_fail (self != NULL);
	rygel_writable_user_config_set_bool (self, "general", RYGEL_USER_CONFIG_ALLOW_DELETION_KEY, value);
}


void
rygel_writable_user_config_save (RygelWritableUserConfig* self)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gsize length = 0UL;
	gchar* data = NULL;
	GKeyFile* _tmp2_;
	gsize _tmp3_ = 0UL;
	gchar* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_build_filename (_tmp0_, RYGEL_USER_CONFIG_CONFIG_FILE, NULL);
	path = _tmp1_;
	_tmp2_ = ((RygelUserConfig*) self)->key_file;
	_tmp4_ = g_key_file_to_data (_tmp2_, &_tmp3_, NULL);
	length = _tmp3_;
	data = _tmp4_;
	{
		g_file_set_contents (path, data, (gssize) ((glong) length), &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch4_g_file_error;
			}
			_g_free0 (data);
			_g_free0 (path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally4;
	__catch4_g_file_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = err;
		_tmp6_ = _tmp5_->message;
		g_critical (_ ("Failed to save configuration data to file “%s”: %s"), path, _tmp6_);
		_g_error_free0 (err);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (data);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (data);
	_g_free0 (path);
}


void
rygel_writable_user_config_set_string (RygelWritableUserConfig* self,
                                       const gchar* section,
                                       const gchar* key,
                                       const gchar* value)
{
	GKeyFile* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = ((RygelUserConfig*) self)->key_file;
	g_key_file_set_string (_tmp0_, section, key, value);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


void
rygel_writable_user_config_set_string_list (RygelWritableUserConfig* self,
                                            const gchar* section,
                                            const gchar* key,
                                            GeeArrayList* str_list)
{
	gchar** strings = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_;
	gint strings_length1;
	gint _strings_size_;
	gint i = 0;
	GKeyFile* _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (str_list != NULL);
	_tmp0_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) str_list);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gchar*, _tmp1_ + 1);
	strings = _tmp2_;
	strings_length1 = _tmp1_;
	_strings_size_ = strings_length1;
	i = 0;
	{
		GeeArrayList* _str_list = NULL;
		GeeArrayList* _tmp3_;
		gint _str_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _str_index = 0;
		_tmp3_ = _g_object_ref0 (str_list);
		_str_list = _tmp3_;
		_tmp4_ = _str_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_str_size = _tmp6_;
		_str_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gchar* str = NULL;
			GeeArrayList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			const gchar* _tmp13_;
			_tmp7_ = _str_index;
			_str_index = _tmp7_ + 1;
			_tmp8_ = _str_index;
			_tmp9_ = _str_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _str_list;
			_tmp11_ = _str_index;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
			str = (gchar*) _tmp12_;
			_tmp13_ = str;
			if (g_strcmp0 (_tmp13_, "") != 0) {
				gchar** _tmp14_;
				gint _tmp14__length1;
				gint _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp14_ = strings;
				_tmp14__length1 = strings_length1;
				_tmp15_ = i;
				i = _tmp15_ + 1;
				_tmp16_ = str;
				_tmp17_ = g_strdup (_tmp16_);
				_g_free0 (_tmp14_[_tmp15_]);
				_tmp14_[_tmp15_] = _tmp17_;
				_tmp18_ = _tmp14_[_tmp15_];
			}
			_g_free0 (str);
		}
		_g_object_unref0 (_str_list);
	}
	_tmp19_ = ((RygelUserConfig*) self)->key_file;
	_tmp20_ = strings;
	_tmp20__length1 = strings_length1;
	g_key_file_set_string_list (_tmp19_, section, key, (const gchar* const*) _tmp20_, _tmp20__length1);
	strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
}


void
rygel_writable_user_config_set_int (RygelWritableUserConfig* self,
                                    const gchar* section,
                                    const gchar* key,
                                    gint value)
{
	GKeyFile* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = ((RygelUserConfig*) self)->key_file;
	g_key_file_set_integer (_tmp0_, section, key, value);
}


void
rygel_writable_user_config_set_bool (RygelWritableUserConfig* self,
                                     const gchar* section,
                                     const gchar* key,
                                     gboolean value)
{
	GKeyFile* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = ((RygelUserConfig*) self)->key_file;
	g_key_file_set_boolean (_tmp0_, section, key, value);
}


static GFile*
rygel_writable_user_config_get_autostart_file (RygelWritableUserConfig* self,
                                               GError** error)
{
	GFile* result = NULL;
	gchar* config_dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* dest_dir = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* dest_path = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GFile* dest = NULL;
	const gchar* _tmp8_;
	GFile* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	config_dir = _tmp1_;
	_tmp2_ = config_dir;
	rygel_writable_user_config_ensure_dir_exists (self, _tmp2_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (config_dir);
		return NULL;
	}
	_tmp3_ = config_dir;
	_tmp4_ = g_build_filename (_tmp3_, "autostart", NULL);
	dest_dir = _tmp4_;
	_tmp5_ = dest_dir;
	rygel_writable_user_config_ensure_dir_exists (self, _tmp5_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (dest_dir);
		_g_free0 (config_dir);
		return NULL;
	}
	_tmp6_ = dest_dir;
	_tmp7_ = g_build_filename (_tmp6_, "rygel.desktop", NULL);
	dest_path = _tmp7_;
	_tmp8_ = dest_path;
	_tmp9_ = g_file_new_for_path (_tmp8_);
	dest = _tmp9_;
	result = dest;
	_g_free0 (dest_path);
	_g_free0 (dest_dir);
	_g_free0 (config_dir);
	return result;
}


static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RygelWritableUserConfig* self;
		self = _data1_->self;
		_g_main_loop_unref0 (_data1_->loop);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void
____lambda4_ (Block1Data* _data1_)
{
	RygelWritableUserConfig* self;
	GMainLoop* _tmp0_;
	self = _data1_->self;
	_tmp0_ = _data1_->loop;
	g_main_loop_quit (_tmp0_);
}


static void
_____lambda4__gbus_name_appeared_callback (GDBusConnection* connection,
                                           const gchar* name,
                                           const gchar* name_owner,
                                           gpointer self)
{
	____lambda4_ (self);
}


static void
____lambda5_ (Block1Data* _data1_)
{
	RygelWritableUserConfig* self;
	GMainLoop* _tmp0_;
	self = _data1_->self;
	_tmp0_ = _data1_->loop;
	g_main_loop_quit (_tmp0_);
}


static void
_____lambda5__gbus_name_vanished_callback (GDBusConnection* connection,
                                           const gchar* name,
                                           gpointer self)
{
	____lambda5_ (self);
}


static void
rygel_writable_user_config_enable_upnp (RygelWritableUserConfig* self,
                                        gboolean enable)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GFile* dest = NULL;
		GFile* _tmp0_;
		_tmp0_ = rygel_writable_user_config_get_autostart_file (self, &_inner_error_);
		dest = _tmp0_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
		if (enable) {
			Block1Data* _data1_;
			GMainLoop* _tmp1_;
			GMainLoop* _tmp2_;
			gchar* source_path = NULL;
			gchar* _tmp3_;
			_data1_ = g_slice_new0 (Block1Data);
			_data1_->_ref_count_ = 1;
			_data1_->self = g_object_ref (self);
			_tmp1_ = g_main_loop_new (NULL, FALSE);
			_data1_->loop = _tmp1_;
			g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, RYGEL_DBUS_INTERFACE_SERVICE_NAME, G_BUS_NAME_WATCHER_FLAGS_AUTO_START, (GClosure*) ((_____lambda4__gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _____lambda4__gbus_name_appeared_callback, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref)), (GClosure*) ((_____lambda5__gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _____lambda5__gbus_name_vanished_callback, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref)));
			_tmp2_ = _data1_->loop;
			g_main_loop_run (_tmp2_);
			_tmp3_ = g_build_filename (DESKTOP_DIR, "rygel.desktop", NULL);
			source_path = _tmp3_;
			{
				GFile* _tmp4_;
				const gchar* _tmp5_;
				_tmp4_ = dest;
				_tmp5_ = source_path;
				g_file_make_symbolic_link (_tmp4_, _tmp5_, NULL, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
						goto __catch6_g_io_error_exists;
					}
					goto __finally6;
				}
			}
			goto __finally6;
			__catch6_g_io_error_exists:
			{
				GError* err = NULL;
				err = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (err);
			}
			__finally6:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (source_path);
				block1_data_unref (_data1_);
				_data1_ = NULL;
				_g_object_unref0 (dest);
				goto __catch5_g_error;
			}
			_g_free0 (source_path);
			block1_data_unref (_data1_);
			_data1_ = NULL;
		} else {
			{
				GFile* _tmp6_;
				_tmp6_ = dest;
				g_file_delete (_tmp6_, NULL, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
						goto __catch7_g_io_error_not_found;
					}
					goto __finally7;
				}
			}
			goto __finally7;
			__catch7_g_io_error_not_found:
			{
				GError* err = NULL;
				err = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (err);
			}
			__finally7:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (dest);
				goto __catch5_g_error;
			}
			if (rygel_writable_user_config_is_upnp_enabled (self)) {
				RygelDBusInterface* rygel_proxy = NULL;
				RygelDBusInterface* _tmp7_;
				RygelDBusInterface* _tmp8_;
				_tmp7_ = g_initable_new (RYGEL_TYPE_DBUS_INTERFACE_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", RYGEL_DBUS_INTERFACE_SERVICE_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RYGEL_DBUS_INTERFACE_OBJECT_PATH, "g-interface-name", "org.gnome.Rygel1", "g-interface-info", g_type_get_qdata (RYGEL_TYPE_DBUS_INTERFACE, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
				rygel_proxy = (RygelDBusInterface*) _tmp7_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (dest);
					goto __catch5_g_error;
				}
				_tmp8_ = rygel_proxy;
				rygel_dbus_interface_shutdown (_tmp8_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (rygel_proxy);
					_g_object_unref0 (dest);
					goto __catch5_g_error;
				}
				_g_object_unref0 (rygel_proxy);
			}
		}
		_g_object_unref0 (dest);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* err = NULL;
		gchar* message = NULL;
		const gchar* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		err = _inner_error_;
		_inner_error_ = NULL;
		if (enable) {
			gchar* _tmp9_;
			_tmp9_ = g_strdup (_ ("Failed to start Rygel service: %s"));
			_g_free0 (message);
			message = _tmp9_;
		} else {
			gchar* _tmp10_;
			_tmp10_ = g_strdup (_ ("Failed to stop Rygel service: %s"));
			_g_free0 (message);
			message = _tmp10_;
		}
		_tmp11_ = message;
		_tmp12_ = err;
		_tmp13_ = _tmp12_->message;
		g_warning (_tmp11_, _tmp13_);
		_g_free0 (message);
		_g_error_free0 (err);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void
rygel_writable_user_config_ensure_dir_exists (RygelWritableUserConfig* self,
                                              const gchar* dir_path,
                                              GError** error)
{
	GFile* dir = NULL;
	GFile* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir_path != NULL);
	_tmp0_ = g_file_new_for_path (dir_path);
	dir = _tmp0_;
	{
		g_file_make_directory (dir, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
				goto __catch8_g_io_error_exists;
			}
			goto __finally8;
		}
	}
	goto __finally8;
	__catch8_g_io_error_exists:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (dir);
		return;
	}
	_g_object_unref0 (dir);
}


static void
rygel_writable_user_config_class_init (RygelWritableUserConfigClass * klass)
{
	rygel_writable_user_config_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelWritableUserConfig_private_offset);
	G_OBJECT_CLASS (klass)->finalize = rygel_writable_user_config_finalize;
}


static void
rygel_writable_user_config_instance_init (RygelWritableUserConfig * self)
{
	self->priv = rygel_writable_user_config_get_instance_private (self);
}


static void
rygel_writable_user_config_finalize (GObject * obj)
{
	RygelWritableUserConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_WRITABLE_USER_CONFIG, RygelWritableUserConfig);
	_g_object_unref0 (self->priv->user_config);
	G_OBJECT_CLASS (rygel_writable_user_config_parent_class)->finalize (obj);
}


/**
 * Manages the user configuration for Rygel.
 */
GType
rygel_writable_user_config_get_type (void)
{
	static volatile gsize rygel_writable_user_config_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_writable_user_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelWritableUserConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_writable_user_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelWritableUserConfig), 0, (GInstanceInitFunc) rygel_writable_user_config_instance_init, NULL };
		GType rygel_writable_user_config_type_id;
		rygel_writable_user_config_type_id = g_type_register_static (RYGEL_TYPE_USER_CONFIG, "RygelWritableUserConfig", &g_define_type_info, 0);
		RygelWritableUserConfig_private_offset = g_type_add_instance_private (rygel_writable_user_config_type_id, sizeof (RygelWritableUserConfigPrivate));
		g_once_init_leave (&rygel_writable_user_config_type_id__volatile, rygel_writable_user_config_type_id);
	}
	return rygel_writable_user_config_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



