/* rygel-l16-transcoder.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-l16-transcoder.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Prasanna Modem <prasanna@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <rygel-server.h>
#include <glib.h>
#include <gst/pbutils/pbutils.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>

#define RYGEL_TYPE_GST_TRANSCODER (rygel_gst_transcoder_get_type ())
#define RYGEL_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder))
#define RYGEL_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))
#define RYGEL_IS_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_IS_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_GST_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))

typedef struct _RygelGstTranscoder RygelGstTranscoder;
typedef struct _RygelGstTranscoderClass RygelGstTranscoderClass;
typedef struct _RygelGstTranscoderPrivate RygelGstTranscoderPrivate;

#define RYGEL_TYPE_AUDIO_TRANSCODER (rygel_audio_transcoder_get_type ())
#define RYGEL_AUDIO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoder))
#define RYGEL_AUDIO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoderClass))
#define RYGEL_IS_AUDIO_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_TRANSCODER))
#define RYGEL_IS_AUDIO_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_TRANSCODER))
#define RYGEL_AUDIO_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoderClass))

typedef struct _RygelAudioTranscoder RygelAudioTranscoder;
typedef struct _RygelAudioTranscoderClass RygelAudioTranscoderClass;
typedef struct _RygelAudioTranscoderPrivate RygelAudioTranscoderPrivate;

#define RYGEL_TYPE_L16_TRANSCODER (rygel_l16_transcoder_get_type ())
#define RYGEL_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16Transcoder))
#define RYGEL_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))
#define RYGEL_IS_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_IS_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_L16_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))

typedef struct _RygelL16Transcoder RygelL16Transcoder;
typedef struct _RygelL16TranscoderClass RygelL16TranscoderClass;
typedef struct _RygelL16TranscoderPrivate RygelL16TranscoderPrivate;
enum  {
	RYGEL_L16_TRANSCODER_0_PROPERTY,
	RYGEL_L16_TRANSCODER_NUM_PROPERTIES
};
static GParamSpec* rygel_l16_transcoder_properties[RYGEL_L16_TRANSCODER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelGstTranscoder {
	GObject parent_instance;
	RygelGstTranscoderPrivate * priv;
};

struct _RygelGstTranscoderClass {
	GObjectClass parent_class;
	RygelMediaResource* (*get_resource_for_item) (RygelGstTranscoder* self, RygelMediaFileItem* item);
	guint (*get_distance) (RygelGstTranscoder* self, RygelMediaFileItem* item);
	GstEncodingProfile* (*get_encoding_profile) (RygelGstTranscoder* self, RygelMediaFileItem* item);
};

struct _RygelAudioTranscoder {
	RygelGstTranscoder parent_instance;
	RygelAudioTranscoderPrivate * priv;
	gint audio_bitrate;
	GstCaps* container_format;
	GstCaps* audio_codec_format;
};

struct _RygelAudioTranscoderClass {
	RygelGstTranscoderClass parent_class;
};

struct _RygelL16Transcoder {
	RygelAudioTranscoder parent_instance;
	RygelL16TranscoderPrivate * priv;
};

struct _RygelL16TranscoderClass {
	RygelAudioTranscoderClass parent_class;
};

static gpointer rygel_l16_transcoder_parent_class = NULL;

GType rygel_gst_transcoder_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelGstTranscoder, g_object_unref)
GType rygel_audio_transcoder_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelAudioTranscoder, g_object_unref)
GType rygel_l16_transcoder_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelL16Transcoder, g_object_unref)
#define RYGEL_L16_TRANSCODER_CHANNELS 2
#define RYGEL_L16_TRANSCODER_FREQUENCY 44100
#define RYGEL_L16_TRANSCODER_WIDTH 16
#define RYGEL_L16_TRANSCODER_DEPTH 16
#define RYGEL_L16_TRANSCODER_SIGNED TRUE
#define RYGEL_L16_TRANSCODER_ENDIANNESS ((gint) G_BIG_ENDIAN)
#define RYGEL_L16_TRANSCODER_NAME "LPCM"
RygelL16Transcoder* rygel_l16_transcoder_new (void);
RygelL16Transcoder* rygel_l16_transcoder_construct (GType object_type);
#define RYGEL_AUDIO_TRANSCODER_NO_CONTAINER NULL
RygelAudioTranscoder* rygel_audio_transcoder_construct (GType object_type,
                                                        const gchar* name,
                                                        const gchar* content_type,
                                                        const gchar* dlna_profile,
                                                        gint audio_bitrate,
                                                        const gchar* container_caps,
                                                        const gchar* audio_codec_caps,
                                                        const gchar* extension);
static guint rygel_l16_transcoder_real_get_distance (RygelGstTranscoder* base,
                                              RygelMediaFileItem* item);
static RygelMediaResource* rygel_l16_transcoder_real_get_resource_for_item (RygelGstTranscoder* base,
                                                                     RygelMediaFileItem* item);
RygelMediaResource* rygel_gst_transcoder_get_resource_for_item (RygelGstTranscoder* self,
                                                                RygelMediaFileItem* item);

RygelL16Transcoder*
rygel_l16_transcoder_construct (GType object_type)
{
	RygelL16Transcoder * self = NULL;
	gchar* mime_type = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* caps_str = NULL;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	_tmp0_ = g_strdup_printf ("%i", RYGEL_L16_TRANSCODER_WIDTH);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("audio/L", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, ";rate=", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%i", RYGEL_L16_TRANSCODER_FREQUENCY);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp5_, _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, ";channels=", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("%i", RYGEL_L16_TRANSCODER_CHANNELS);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp11_, _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	mime_type = _tmp15_;
	_tmp16_ = g_strdup_printf ("%i", RYGEL_L16_TRANSCODER_CHANNELS);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat ("audio/x-raw,format=S16BE" ",channels=", _tmp17_, NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat (_tmp19_, ",rate=", NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strdup_printf ("%i", RYGEL_L16_TRANSCODER_FREQUENCY);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp21_, _tmp23_, NULL);
	_tmp25_ = _tmp24_;
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	caps_str = _tmp25_;
	self = (RygelL16Transcoder*) rygel_audio_transcoder_construct (object_type, RYGEL_L16_TRANSCODER_NAME, mime_type, RYGEL_L16_TRANSCODER_NAME, 0, RYGEL_AUDIO_TRANSCODER_NO_CONTAINER, caps_str, "lpcm");
	_g_free0 (caps_str);
	_g_free0 (mime_type);
	return self;
}

RygelL16Transcoder*
rygel_l16_transcoder_new (void)
{
	return rygel_l16_transcoder_construct (RYGEL_TYPE_L16_TRANSCODER);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static guint
rygel_l16_transcoder_real_get_distance (RygelGstTranscoder* base,
                                        RygelMediaFileItem* item)
{
	RygelL16Transcoder * self;
	guint result = 0U;
	gboolean _tmp0_ = FALSE;
	RygelAudioItem* audio_item = NULL;
	RygelAudioItem* _tmp1_;
	guint distance = 0U;
	RygelAudioItem* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	RygelAudioItem* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	RygelAudioItem* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	self = (RygelL16Transcoder*) base;
	g_return_val_if_fail (item != NULL, 0U);
	if (!G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_AUDIO_ITEM)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_VIDEO_ITEM);
	}
	if (_tmp0_) {
		result = G_MAXUINT;
		return result;
	}
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) item) : NULL);
	audio_item = _tmp1_;
	distance = 0;
	_tmp2_ = audio_item;
	_tmp3_ = rygel_audio_item_get_sample_freq (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		RygelAudioItem* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = audio_item;
		_tmp6_ = rygel_audio_item_get_sample_freq (_tmp5_);
		_tmp7_ = _tmp6_;
		distance += (guint) abs (_tmp7_ - RYGEL_L16_TRANSCODER_FREQUENCY);
	}
	_tmp8_ = audio_item;
	_tmp9_ = rygel_audio_item_get_channels (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ > 0) {
		RygelAudioItem* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp11_ = audio_item;
		_tmp12_ = rygel_audio_item_get_channels (_tmp11_);
		_tmp13_ = _tmp12_;
		distance += (guint) abs (_tmp13_ - RYGEL_L16_TRANSCODER_CHANNELS);
	}
	_tmp14_ = audio_item;
	_tmp15_ = rygel_audio_item_get_bits_per_sample (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ > 0) {
		RygelAudioItem* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		_tmp17_ = audio_item;
		_tmp18_ = rygel_audio_item_get_bits_per_sample (_tmp17_);
		_tmp19_ = _tmp18_;
		distance += (guint) abs (_tmp19_ - RYGEL_L16_TRANSCODER_WIDTH);
	}
	result = distance;
	_g_object_unref0 (audio_item);
	return result;
}

static RygelMediaResource*
rygel_l16_transcoder_real_get_resource_for_item (RygelGstTranscoder* base,
                                                 RygelMediaFileItem* item)
{
	RygelL16Transcoder * self;
	RygelMediaResource* result = NULL;
	RygelMediaResource* resource = NULL;
	RygelMediaResource* _tmp0_;
	RygelMediaResource* _tmp1_;
	RygelMediaResource* _tmp2_;
	RygelMediaResource* _tmp3_;
	RygelMediaResource* _tmp4_;
	RygelMediaResource* _tmp5_;
	self = (RygelL16Transcoder*) base;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = RYGEL_GST_TRANSCODER_CLASS (rygel_l16_transcoder_parent_class)->get_resource_for_item ((RygelGstTranscoder*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_AUDIO_TRANSCODER, RygelAudioTranscoder), item);
	resource = _tmp0_;
	_tmp1_ = resource;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_object_unref0 (resource);
		return result;
	}
	_tmp2_ = resource;
	rygel_media_resource_set_sample_freq (_tmp2_, RYGEL_L16_TRANSCODER_FREQUENCY);
	_tmp3_ = resource;
	rygel_media_resource_set_audio_channels (_tmp3_, RYGEL_L16_TRANSCODER_CHANNELS);
	_tmp4_ = resource;
	rygel_media_resource_set_bits_per_sample (_tmp4_, RYGEL_L16_TRANSCODER_WIDTH);
	_tmp5_ = resource;
	rygel_media_resource_set_bitrate (_tmp5_, ((RYGEL_L16_TRANSCODER_FREQUENCY * RYGEL_L16_TRANSCODER_CHANNELS) * RYGEL_L16_TRANSCODER_WIDTH) / 8);
	result = resource;
	return result;
}

static void
rygel_l16_transcoder_class_init (RygelL16TranscoderClass * klass,
                                 gpointer klass_data)
{
	rygel_l16_transcoder_parent_class = g_type_class_peek_parent (klass);
	((RygelGstTranscoderClass *) klass)->get_distance = (guint (*) (RygelGstTranscoder*, RygelMediaFileItem*)) rygel_l16_transcoder_real_get_distance;
	((RygelGstTranscoderClass *) klass)->get_resource_for_item = (RygelMediaResource* (*) (RygelGstTranscoder*, RygelMediaFileItem*)) rygel_l16_transcoder_real_get_resource_for_item;
}

static void
rygel_l16_transcoder_instance_init (RygelL16Transcoder * self,
                                    gpointer klass)
{
}

/**
 * Transcoder for linear PCM audio (LPCM).
 */
GType
rygel_l16_transcoder_get_type (void)
{
	static volatile gsize rygel_l16_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_l16_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelL16TranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_l16_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelL16Transcoder), 0, (GInstanceInitFunc) rygel_l16_transcoder_instance_init, NULL };
		GType rygel_l16_transcoder_type_id;
		rygel_l16_transcoder_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_TRANSCODER, "RygelL16Transcoder", &g_define_type_info, 0);
		g_once_init_leave (&rygel_l16_transcoder_type_id__volatile, rygel_l16_transcoder_type_id);
	}
	return rygel_l16_transcoder_type_id__volatile;
}

