/* rygel-dlna-profile.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-dlna-profile.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>

#define RYGEL_TYPE_DLNA_PROFILE (rygel_dlna_profile_get_type ())
#define RYGEL_DLNA_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DLNA_PROFILE, RygelDLNAProfile))
#define RYGEL_DLNA_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DLNA_PROFILE, RygelDLNAProfileClass))
#define RYGEL_IS_DLNA_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DLNA_PROFILE))
#define RYGEL_IS_DLNA_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DLNA_PROFILE))
#define RYGEL_DLNA_PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DLNA_PROFILE, RygelDLNAProfileClass))

typedef struct _RygelDLNAProfile RygelDLNAProfile;
typedef struct _RygelDLNAProfileClass RygelDLNAProfileClass;
typedef struct _RygelDLNAProfilePrivate RygelDLNAProfilePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelParamSpecDLNAProfile RygelParamSpecDLNAProfile;

struct _RygelDLNAProfile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelDLNAProfilePrivate * priv;
	gchar* mime;
	gchar* name;
};

struct _RygelDLNAProfileClass {
	GTypeClass parent_class;
	void (*finalize) (RygelDLNAProfile *self);
};

struct _RygelParamSpecDLNAProfile {
	GParamSpec parent_instance;
};

static gpointer rygel_dlna_profile_parent_class = NULL;

gpointer rygel_dlna_profile_ref (gpointer instance);
void rygel_dlna_profile_unref (gpointer instance);
GParamSpec* rygel_param_spec_dlna_profile (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void rygel_value_set_dlna_profile (GValue* value,
                                   gpointer v_object);
void rygel_value_take_dlna_profile (GValue* value,
                                    gpointer v_object);
gpointer rygel_value_get_dlna_profile (const GValue* value);
GType rygel_dlna_profile_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelDLNAProfile, rygel_dlna_profile_unref)
RygelDLNAProfile* rygel_dlna_profile_new (const gchar* name,
                                          const gchar* mime);
RygelDLNAProfile* rygel_dlna_profile_construct (GType object_type,
                                                const gchar* name,
                                                const gchar* mime);
gint rygel_dlna_profile_compare_by_name (RygelDLNAProfile* a,
                                         RygelDLNAProfile* b);
static void rygel_dlna_profile_finalize (RygelDLNAProfile * obj);

RygelDLNAProfile*
rygel_dlna_profile_construct (GType object_type,
                              const gchar* name,
                              const gchar* mime)
{
	RygelDLNAProfile* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (mime != NULL, NULL);
	self = (RygelDLNAProfile*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (mime);
	_g_free0 (self->mime);
	self->mime = _tmp0_;
	_tmp1_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp1_;
	return self;
}

RygelDLNAProfile*
rygel_dlna_profile_new (const gchar* name,
                        const gchar* mime)
{
	return rygel_dlna_profile_construct (RYGEL_TYPE_DLNA_PROFILE, name, mime);
}

/**
     * Compare two DLNA profiles by name
     */
gint
rygel_dlna_profile_compare_by_name (RygelDLNAProfile* a,
                                    RygelDLNAProfile* b)
{
	gint result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a->name;
	_tmp1_ = b->name;
	result = g_ascii_strcasecmp (_tmp0_, _tmp1_);
	return result;
}

static void
rygel_value_dlna_profile_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
rygel_value_dlna_profile_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		rygel_dlna_profile_unref (value->data[0].v_pointer);
	}
}

static void
rygel_value_dlna_profile_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_dlna_profile_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
rygel_value_dlna_profile_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
rygel_value_dlna_profile_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		RygelDLNAProfile * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_dlna_profile_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
rygel_value_dlna_profile_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	RygelDLNAProfile ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_dlna_profile_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
rygel_param_spec_dlna_profile (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	RygelParamSpecDLNAProfile* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_DLNA_PROFILE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
rygel_value_get_dlna_profile (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_DLNA_PROFILE), NULL);
	return value->data[0].v_pointer;
}

void
rygel_value_set_dlna_profile (GValue* value,
                              gpointer v_object)
{
	RygelDLNAProfile * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_DLNA_PROFILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_DLNA_PROFILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_dlna_profile_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_dlna_profile_unref (old);
	}
}

void
rygel_value_take_dlna_profile (GValue* value,
                               gpointer v_object)
{
	RygelDLNAProfile * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_DLNA_PROFILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_DLNA_PROFILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_dlna_profile_unref (old);
	}
}

static void
rygel_dlna_profile_class_init (RygelDLNAProfileClass * klass,
                               gpointer klass_data)
{
	rygel_dlna_profile_parent_class = g_type_class_peek_parent (klass);
	((RygelDLNAProfileClass *) klass)->finalize = rygel_dlna_profile_finalize;
}

static void
rygel_dlna_profile_instance_init (RygelDLNAProfile * self,
                                  gpointer klass)
{
	self->ref_count = 1;
}

static void
rygel_dlna_profile_finalize (RygelDLNAProfile * obj)
{
	RygelDLNAProfile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DLNA_PROFILE, RygelDLNAProfile);
	g_signal_handlers_destroy (self);
	_g_free0 (self->mime);
	_g_free0 (self->name);
}

/**
 * Data class representing a DLNA profile.
 * It contains the name and the corresponding DLNA mime type.
 *
 * Note: The mime type can deviate from mime types typically used elsewhere.
 */
GType
rygel_dlna_profile_get_type (void)
{
	static volatile gsize rygel_dlna_profile_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_dlna_profile_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_dlna_profile_init, rygel_value_dlna_profile_free_value, rygel_value_dlna_profile_copy_value, rygel_value_dlna_profile_peek_pointer, "p", rygel_value_dlna_profile_collect_value, "p", rygel_value_dlna_profile_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelDLNAProfileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_dlna_profile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDLNAProfile), 0, (GInstanceInitFunc) rygel_dlna_profile_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_dlna_profile_type_id;
		rygel_dlna_profile_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelDLNAProfile", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_dlna_profile_type_id__volatile, rygel_dlna_profile_type_id);
	}
	return rygel_dlna_profile_type_id__volatile;
}

gpointer
rygel_dlna_profile_ref (gpointer instance)
{
	RygelDLNAProfile * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
rygel_dlna_profile_unref (gpointer instance)
{
	RygelDLNAProfile * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_DLNA_PROFILE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

