/* rygel-tracker-interfaces.c generated by valac, the Vala compiler
 * generated from rygel-tracker-interfaces.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus.h>


#define RYGEL_TYPE_TRACKER_IFACE (rygel_tracker_iface_get_type ())
#define RYGEL_TRACKER_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_IFACE, RygelTrackerIface))
#define RYGEL_IS_TRACKER_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_IFACE))
#define RYGEL_TRACKER_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKER_IFACE, RygelTrackerIfaceIface))

typedef struct _RygelTrackerIface RygelTrackerIface;
typedef struct _RygelTrackerIfaceIface RygelTrackerIfaceIface;
typedef struct _RygelTrackerIfaceDBusProxy RygelTrackerIfaceDBusProxy;
typedef DBusGProxyClass RygelTrackerIfaceDBusProxyClass;
typedef struct _RygelTrackerIfaceDBusProxyGetVersionData RygelTrackerIfaceDBusProxyGetVersionData;

#define RYGEL_TYPE_TRACKER_KEYWORDS_IFACE (rygel_tracker_keywords_iface_get_type ())
#define RYGEL_TRACKER_KEYWORDS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_KEYWORDS_IFACE, RygelTrackerKeywordsIface))
#define RYGEL_IS_TRACKER_KEYWORDS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_KEYWORDS_IFACE))
#define RYGEL_TRACKER_KEYWORDS_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKER_KEYWORDS_IFACE, RygelTrackerKeywordsIfaceIface))

typedef struct _RygelTrackerKeywordsIface RygelTrackerKeywordsIface;
typedef struct _RygelTrackerKeywordsIfaceIface RygelTrackerKeywordsIfaceIface;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelTrackerKeywordsIfaceDBusProxy RygelTrackerKeywordsIfaceDBusProxy;
typedef DBusGProxyClass RygelTrackerKeywordsIfaceDBusProxyClass;
typedef struct _RygelTrackerKeywordsIfaceDBusProxyGetListData RygelTrackerKeywordsIfaceDBusProxyGetListData;

#define RYGEL_TYPE_TRACKER_METADATA_IFACE (rygel_tracker_metadata_iface_get_type ())
#define RYGEL_TRACKER_METADATA_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_METADATA_IFACE, RygelTrackerMetadataIface))
#define RYGEL_IS_TRACKER_METADATA_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_METADATA_IFACE))
#define RYGEL_TRACKER_METADATA_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKER_METADATA_IFACE, RygelTrackerMetadataIfaceIface))

typedef struct _RygelTrackerMetadataIface RygelTrackerMetadataIface;
typedef struct _RygelTrackerMetadataIfaceIface RygelTrackerMetadataIfaceIface;
typedef struct _RygelTrackerMetadataIfaceDBusProxy RygelTrackerMetadataIfaceDBusProxy;
typedef DBusGProxyClass RygelTrackerMetadataIfaceDBusProxyClass;
typedef struct _RygelTrackerMetadataIfaceDBusProxyGetUniqueValuesData RygelTrackerMetadataIfaceDBusProxyGetUniqueValuesData;
typedef struct _RygelTrackerMetadataIfaceDBusProxyGetData RygelTrackerMetadataIfaceDBusProxyGetData;

#define RYGEL_TYPE_TRACKER_SEARCH_IFACE (rygel_tracker_search_iface_get_type ())
#define RYGEL_TRACKER_SEARCH_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKER_SEARCH_IFACE, RygelTrackerSearchIface))
#define RYGEL_IS_TRACKER_SEARCH_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKER_SEARCH_IFACE))
#define RYGEL_TRACKER_SEARCH_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKER_SEARCH_IFACE, RygelTrackerSearchIfaceIface))

typedef struct _RygelTrackerSearchIface RygelTrackerSearchIface;
typedef struct _RygelTrackerSearchIfaceIface RygelTrackerSearchIfaceIface;
typedef struct _RygelTrackerSearchIfaceDBusProxy RygelTrackerSearchIfaceDBusProxy;
typedef DBusGProxyClass RygelTrackerSearchIfaceDBusProxyClass;
typedef struct _RygelTrackerSearchIfaceDBusProxyQueryData RygelTrackerSearchIfaceDBusProxyQueryData;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _RygelTrackerIfaceIface {
	GTypeInterface parent_iface;
	void (*get_version) (RygelTrackerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gint (*get_version_finish) (RygelTrackerIface* self, GAsyncResult* _res_, GError** error);
};

struct _RygelTrackerIfaceDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _RygelTrackerIfaceDBusProxyGetVersionData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _RygelTrackerKeywordsIfaceIface {
	GTypeInterface parent_iface;
	void (*get_list) (RygelTrackerKeywordsIface* self, const char* service, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char** (*get_list_finish) (RygelTrackerKeywordsIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
};

struct _RygelTrackerKeywordsIfaceDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _RygelTrackerKeywordsIfaceDBusProxyGetListData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _RygelTrackerMetadataIfaceIface {
	GTypeInterface parent_iface;
	void (*get_unique_values) (RygelTrackerMetadataIface* self, const char* service, char** meta_types, int meta_types_length1, const char* query, gboolean descending, gint offset, gint max_hits, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char** (*get_unique_values_finish) (RygelTrackerMetadataIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
	void (*get) (RygelTrackerMetadataIface* self, const char* service_type, const char* uri, char** keys, int keys_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char** (*get_finish) (RygelTrackerMetadataIface* self, GAsyncResult* _res_, int* result_length1, GError** error);
};

struct _RygelTrackerMetadataIfaceDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _RygelTrackerMetadataIfaceDBusProxyGetUniqueValuesData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _RygelTrackerMetadataIfaceDBusProxyGetData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _RygelTrackerSearchIfaceIface {
	GTypeInterface parent_iface;
	void (*query) (RygelTrackerSearchIface* self, gint live_query_id, const char* service, char** fields, int fields_length1, const char* search_text, char** keywords, int keywords_length1, const char* query_condition, gboolean sort_by_service, char** sort_fields, int sort_fields_length1, gboolean sort_descending, gint offset, gint max_hits, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char** (*query_finish) (RygelTrackerSearchIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
};

struct _RygelTrackerSearchIfaceDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _RygelTrackerSearchIfaceDBusProxyQueryData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



GType rygel_tracker_iface_get_type (void);
void rygel_tracker_iface_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _rygel_tracker_iface_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult rygel_tracker_iface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_rygel_tracker_iface_introspect (RygelTrackerIface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_tracker_iface_property_get_all (RygelTrackerIface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_tracker_iface_get_version (RygelTrackerIface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_rygel_tracker_iface_get_version_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
GType rygel_tracker_iface_dbus_proxy_get_type (void);
RygelTrackerIface* rygel_tracker_iface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
DBusHandlerResult rygel_tracker_iface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	RYGEL_TRACKER_IFACE_DBUS_PROXY_DUMMY_PROPERTY
};
static void rygel_tracker_iface_dbus_proxy_get_version_async (RygelTrackerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_iface_dbus_proxy_get_version_ready (DBusPendingCall* pending, void* user_data);
static gint rygel_tracker_iface_dbus_proxy_get_version_finish (RygelTrackerIface* self, GAsyncResult* _res_, GError** error);
static void rygel_tracker_iface_dbus_proxy_rygel_tracker_iface__interface_init (RygelTrackerIfaceIface* iface);
static void rygel_tracker_iface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_tracker_iface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType rygel_tracker_keywords_iface_get_type (void);
void rygel_tracker_keywords_iface_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _rygel_tracker_keywords_iface_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult rygel_tracker_keywords_iface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_rygel_tracker_keywords_iface_introspect (RygelTrackerKeywordsIface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_tracker_keywords_iface_property_get_all (RygelTrackerKeywordsIface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_tracker_keywords_iface_get_list (RygelTrackerKeywordsIface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_rygel_tracker_keywords_iface_get_list_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
GType rygel_tracker_keywords_iface_dbus_proxy_get_type (void);
RygelTrackerKeywordsIface* rygel_tracker_keywords_iface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
DBusHandlerResult rygel_tracker_keywords_iface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	RYGEL_TRACKER_KEYWORDS_IFACE_DBUS_PROXY_DUMMY_PROPERTY
};
static void rygel_tracker_keywords_iface_dbus_proxy_get_list_async (RygelTrackerKeywordsIface* self, const char* service, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_keywords_iface_dbus_proxy_get_list_ready (DBusPendingCall* pending, void* user_data);
static char** rygel_tracker_keywords_iface_dbus_proxy_get_list_finish (RygelTrackerKeywordsIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
static void rygel_tracker_keywords_iface_dbus_proxy_rygel_tracker_keywords_iface__interface_init (RygelTrackerKeywordsIfaceIface* iface);
static void rygel_tracker_keywords_iface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_tracker_keywords_iface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType rygel_tracker_metadata_iface_get_type (void);
void rygel_tracker_metadata_iface_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _rygel_tracker_metadata_iface_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult rygel_tracker_metadata_iface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_rygel_tracker_metadata_iface_introspect (RygelTrackerMetadataIface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_tracker_metadata_iface_property_get_all (RygelTrackerMetadataIface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_tracker_metadata_iface_get_unique_values (RygelTrackerMetadataIface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_rygel_tracker_metadata_iface_get_unique_values_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
static DBusHandlerResult _dbus_rygel_tracker_metadata_iface_get (RygelTrackerMetadataIface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_rygel_tracker_metadata_iface_get_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
GType rygel_tracker_metadata_iface_dbus_proxy_get_type (void);
RygelTrackerMetadataIface* rygel_tracker_metadata_iface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
DBusHandlerResult rygel_tracker_metadata_iface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	RYGEL_TRACKER_METADATA_IFACE_DBUS_PROXY_DUMMY_PROPERTY
};
static void rygel_tracker_metadata_iface_dbus_proxy_get_unique_values_async (RygelTrackerMetadataIface* self, const char* service, char** meta_types, int meta_types_length1, const char* query, gboolean descending, gint offset, gint max_hits, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_metadata_iface_dbus_proxy_get_unique_values_ready (DBusPendingCall* pending, void* user_data);
static char** rygel_tracker_metadata_iface_dbus_proxy_get_unique_values_finish (RygelTrackerMetadataIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
static void rygel_tracker_metadata_iface_dbus_proxy_get_async (RygelTrackerMetadataIface* self, const char* service_type, const char* uri, char** keys, int keys_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_metadata_iface_dbus_proxy_get_ready (DBusPendingCall* pending, void* user_data);
static char** rygel_tracker_metadata_iface_dbus_proxy_get_finish (RygelTrackerMetadataIface* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void rygel_tracker_metadata_iface_dbus_proxy_rygel_tracker_metadata_iface__interface_init (RygelTrackerMetadataIfaceIface* iface);
static void rygel_tracker_metadata_iface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_tracker_metadata_iface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType rygel_tracker_search_iface_get_type (void);
void rygel_tracker_search_iface_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _rygel_tracker_search_iface_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult rygel_tracker_search_iface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_rygel_tracker_search_iface_introspect (RygelTrackerSearchIface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_tracker_search_iface_property_get_all (RygelTrackerSearchIface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_rygel_tracker_search_iface_query (RygelTrackerSearchIface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_rygel_tracker_search_iface_query_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
GType rygel_tracker_search_iface_dbus_proxy_get_type (void);
RygelTrackerSearchIface* rygel_tracker_search_iface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
DBusHandlerResult rygel_tracker_search_iface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	RYGEL_TRACKER_SEARCH_IFACE_DBUS_PROXY_DUMMY_PROPERTY
};
static void rygel_tracker_search_iface_dbus_proxy_query_async (RygelTrackerSearchIface* self, gint live_query_id, const char* service, char** fields, int fields_length1, const char* search_text, char** keywords, int keywords_length1, const char* query_condition, gboolean sort_by_service, char** sort_fields, int sort_fields_length1, gboolean sort_descending, gint offset, gint max_hits, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_tracker_search_iface_dbus_proxy_query_ready (DBusPendingCall* pending, void* user_data);
static char** rygel_tracker_search_iface_dbus_proxy_query_finish (RygelTrackerSearchIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
static void rygel_tracker_search_iface_dbus_proxy_rygel_tracker_search_iface__interface_init (RygelTrackerSearchIfaceIface* iface);
static void rygel_tracker_search_iface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_tracker_search_iface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _rygel_tracker_iface_dbus_path_vtable = {_rygel_tracker_iface_dbus_unregister, rygel_tracker_iface_dbus_message};
static const _DBusObjectVTable _rygel_tracker_iface_dbus_vtable = {rygel_tracker_iface_dbus_register_object};
static const DBusObjectPathVTable _rygel_tracker_keywords_iface_dbus_path_vtable = {_rygel_tracker_keywords_iface_dbus_unregister, rygel_tracker_keywords_iface_dbus_message};
static const _DBusObjectVTable _rygel_tracker_keywords_iface_dbus_vtable = {rygel_tracker_keywords_iface_dbus_register_object};
static const DBusObjectPathVTable _rygel_tracker_metadata_iface_dbus_path_vtable = {_rygel_tracker_metadata_iface_dbus_unregister, rygel_tracker_metadata_iface_dbus_message};
static const _DBusObjectVTable _rygel_tracker_metadata_iface_dbus_vtable = {rygel_tracker_metadata_iface_dbus_register_object};
static const DBusObjectPathVTable _rygel_tracker_search_iface_dbus_path_vtable = {_rygel_tracker_search_iface_dbus_unregister, rygel_tracker_search_iface_dbus_message};
static const _DBusObjectVTable _rygel_tracker_search_iface_dbus_vtable = {rygel_tracker_search_iface_dbus_register_object};


void rygel_tracker_iface_get_version (RygelTrackerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RYGEL_TRACKER_IFACE_GET_INTERFACE (self)->get_version (self, _callback_, _user_data_);
}


gint rygel_tracker_iface_get_version_finish (RygelTrackerIface* self, GAsyncResult* _res_, GError** error) {
	return RYGEL_TRACKER_IFACE_GET_INTERFACE (self)->get_version_finish (self, _res_, error);
}


void _rygel_tracker_iface_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_rygel_tracker_iface_introspect (RygelTrackerIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.Tracker\">\n  <method name=\"GetVersion\">\n    <arg name=\"result\" type=\"i\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_tracker_iface_property_get_all (RygelTrackerIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.freedesktop.Tracker") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_tracker_iface_get_version (RygelTrackerIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	rygel_tracker_iface_get_version (self, _dbus_rygel_tracker_iface_get_version_ready, _user_data_);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_rygel_tracker_iface_get_version_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	gint result;
	DBusMessage* reply;
	dbus_int32_t _tmp1_;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	result = rygel_tracker_iface_get_version_finish (source_object, _res_, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp1_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_INT32, &_tmp1_);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


DBusHandlerResult rygel_tracker_iface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_rygel_tracker_iface_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_rygel_tracker_iface_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker", "GetVersion")) {
		result = _dbus_rygel_tracker_iface_get_version (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void rygel_tracker_iface_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_rygel_tracker_iface_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void rygel_tracker_iface_base_init (RygelTrackerIfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (RYGEL_TYPE_TRACKER_IFACE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_rygel_tracker_iface_dbus_vtable));
	}
}


GType rygel_tracker_iface_get_type (void) {
	static GType rygel_tracker_iface_type_id = 0;
	if (rygel_tracker_iface_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerIfaceIface), (GBaseInitFunc) rygel_tracker_iface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		rygel_tracker_iface_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelTrackerIface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_tracker_iface_type_id, DBUS_TYPE_G_PROXY);
		g_type_set_qdata (rygel_tracker_iface_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &rygel_tracker_iface_dbus_proxy_get_type);
	}
	return rygel_tracker_iface_type_id;
}


G_DEFINE_TYPE_EXTENDED (RygelTrackerIfaceDBusProxy, rygel_tracker_iface_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (RYGEL_TYPE_TRACKER_IFACE, rygel_tracker_iface_dbus_proxy_rygel_tracker_iface__interface_init) );
RygelTrackerIface* rygel_tracker_iface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	RygelTrackerIface* self;
	self = g_object_new (rygel_tracker_iface_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.Tracker", NULL);
	return self;
}


static GObject* rygel_tracker_iface_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (rygel_tracker_iface_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), rygel_tracker_iface_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult rygel_tracker_iface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void rygel_tracker_iface_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((RygelTrackerIfaceDBusProxy*) self)->disposed) {
		return;
	}
	((RygelTrackerIfaceDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), rygel_tracker_iface_dbus_proxy_filter, self);
	G_OBJECT_CLASS (rygel_tracker_iface_dbus_proxy_parent_class)->dispose (self);
}


static void rygel_tracker_iface_dbus_proxy_class_init (RygelTrackerIfaceDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = rygel_tracker_iface_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = rygel_tracker_iface_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = rygel_tracker_iface_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_tracker_iface_dbus_proxy_set_property;
}


static void rygel_tracker_iface_dbus_proxy_init (RygelTrackerIfaceDBusProxy* self) {
}


static void rygel_tracker_iface_dbus_proxy_get_version_async (RygelTrackerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	RygelTrackerIfaceDBusProxyGetVersionData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker", "GetVersion");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (RygelTrackerIfaceDBusProxyGetVersionData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, rygel_tracker_iface_dbus_proxy_get_version_ready, _data_, NULL);
}


static void rygel_tracker_iface_dbus_proxy_get_version_ready (DBusPendingCall* pending, void* user_data) {
	RygelTrackerIfaceDBusProxyGetVersionData* _data_;
	_data_ = user_data;
	g_simple_async_result_complete (g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _data_->_callback_, _data_->_user_data_, _data_));
}


static gint rygel_tracker_iface_dbus_proxy_get_version_finish (RygelTrackerIface* self, GAsyncResult* _res_, GError** error) {
	RygelTrackerIfaceDBusProxyGetVersionData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	gint _result;
	dbus_int32_t _tmp4_;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp3_;
			_edomain = DBUS_GERROR;
			_tmp3_ = _dbus_error.name + 27;
			if (strcmp (_tmp3_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp3_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp3_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp3_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp3_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp3_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp3_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp3_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp3_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp3_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp3_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp3_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp3_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp3_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp3_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp3_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp3_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp3_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp3_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp3_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp3_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp3_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp3_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp3_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp3_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp3_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp3_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp3_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp3_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp3_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp3_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp3_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp3_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error_literal (error, _edomain, _ecode, _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return 0;
	}
	if (strcmp (dbus_message_get_signature (_reply), "i")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "i", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp4_);
	dbus_message_iter_next (&_iter);
	_result = _tmp4_;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_tracker_iface_dbus_proxy_rygel_tracker_iface__interface_init (RygelTrackerIfaceIface* iface) {
	iface->get_version = rygel_tracker_iface_dbus_proxy_get_version_async;
	iface->get_version_finish = rygel_tracker_iface_dbus_proxy_get_version_finish;
}


static void rygel_tracker_iface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void rygel_tracker_iface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


void rygel_tracker_keywords_iface_get_list (RygelTrackerKeywordsIface* self, const char* service, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RYGEL_TRACKER_KEYWORDS_IFACE_GET_INTERFACE (self)->get_list (self, service, _callback_, _user_data_);
}


char** rygel_tracker_keywords_iface_get_list_finish (RygelTrackerKeywordsIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
	return RYGEL_TRACKER_KEYWORDS_IFACE_GET_INTERFACE (self)->get_list_finish (self, _res_, result_length1, result_length2, error);
}


void _rygel_tracker_keywords_iface_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_rygel_tracker_keywords_iface_introspect (RygelTrackerKeywordsIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.Tracker.Keywords\">\n  <method name=\"GetList\">\n    <arg name=\"service\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"aas\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_tracker_keywords_iface_property_get_all (RygelTrackerKeywordsIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp5_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp5_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp5_);
	if (strcmp (interface_name, "org.freedesktop.Tracker.Keywords") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_tracker_keywords_iface_get_list (RygelTrackerKeywordsIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* service = NULL;
	const char* _tmp6_;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp6_);
	dbus_message_iter_next (&iter);
	service = g_strdup (_tmp6_);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	rygel_tracker_keywords_iface_get_list (self, service, _dbus_rygel_tracker_keywords_iface_get_list_ready, _user_data_);
	_g_free0 (service);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_rygel_tracker_keywords_iface_get_list_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	char** result;
	int result_length1;
	int result_length2;
	DBusMessage* reply;
	char** _tmp7_;
	DBusMessageIter _tmp8_;
	int _tmp9_;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	result_length1 = 0;
	result_length2 = 0;
	result = rygel_tracker_keywords_iface_get_list_finish (source_object, _res_, &result_length1, &result_length2, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp7_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "as", &_tmp8_);
	for (_tmp9_ = 0; _tmp9_ < result_length1; _tmp9_++) {
		DBusMessageIter _tmp10_;
		int _tmp11_;
		dbus_message_iter_open_container (&_tmp8_, DBUS_TYPE_ARRAY, "s", &_tmp10_);
		for (_tmp11_ = 0; _tmp11_ < result_length2; _tmp11_++) {
			const char* _tmp12_;
			_tmp12_ = *_tmp7_;
			dbus_message_iter_append_basic (&_tmp10_, DBUS_TYPE_STRING, &_tmp12_);
			_tmp7_++;
		}
		dbus_message_iter_close_container (&_tmp8_, &_tmp10_);
	}
	dbus_message_iter_close_container (&iter, &_tmp8_);
	result = (_vala_array_free (result,  result_length1 *  result_length2, (GDestroyNotify) g_free), NULL);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


DBusHandlerResult rygel_tracker_keywords_iface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_rygel_tracker_keywords_iface_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_rygel_tracker_keywords_iface_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker.Keywords", "GetList")) {
		result = _dbus_rygel_tracker_keywords_iface_get_list (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void rygel_tracker_keywords_iface_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_rygel_tracker_keywords_iface_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void rygel_tracker_keywords_iface_base_init (RygelTrackerKeywordsIfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (RYGEL_TYPE_TRACKER_KEYWORDS_IFACE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_rygel_tracker_keywords_iface_dbus_vtable));
	}
}


GType rygel_tracker_keywords_iface_get_type (void) {
	static GType rygel_tracker_keywords_iface_type_id = 0;
	if (rygel_tracker_keywords_iface_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerKeywordsIfaceIface), (GBaseInitFunc) rygel_tracker_keywords_iface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		rygel_tracker_keywords_iface_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelTrackerKeywordsIface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_tracker_keywords_iface_type_id, DBUS_TYPE_G_PROXY);
		g_type_set_qdata (rygel_tracker_keywords_iface_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &rygel_tracker_keywords_iface_dbus_proxy_get_type);
	}
	return rygel_tracker_keywords_iface_type_id;
}


G_DEFINE_TYPE_EXTENDED (RygelTrackerKeywordsIfaceDBusProxy, rygel_tracker_keywords_iface_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (RYGEL_TYPE_TRACKER_KEYWORDS_IFACE, rygel_tracker_keywords_iface_dbus_proxy_rygel_tracker_keywords_iface__interface_init) );
RygelTrackerKeywordsIface* rygel_tracker_keywords_iface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	RygelTrackerKeywordsIface* self;
	self = g_object_new (rygel_tracker_keywords_iface_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.Tracker.Keywords", NULL);
	return self;
}


static GObject* rygel_tracker_keywords_iface_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (rygel_tracker_keywords_iface_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), rygel_tracker_keywords_iface_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult rygel_tracker_keywords_iface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void rygel_tracker_keywords_iface_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((RygelTrackerKeywordsIfaceDBusProxy*) self)->disposed) {
		return;
	}
	((RygelTrackerKeywordsIfaceDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), rygel_tracker_keywords_iface_dbus_proxy_filter, self);
	G_OBJECT_CLASS (rygel_tracker_keywords_iface_dbus_proxy_parent_class)->dispose (self);
}


static void rygel_tracker_keywords_iface_dbus_proxy_class_init (RygelTrackerKeywordsIfaceDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = rygel_tracker_keywords_iface_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = rygel_tracker_keywords_iface_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = rygel_tracker_keywords_iface_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_tracker_keywords_iface_dbus_proxy_set_property;
}


static void rygel_tracker_keywords_iface_dbus_proxy_init (RygelTrackerKeywordsIfaceDBusProxy* self) {
}


static void rygel_tracker_keywords_iface_dbus_proxy_get_list_async (RygelTrackerKeywordsIface* self, const char* service, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	const char* _tmp13_;
	RygelTrackerKeywordsIfaceDBusProxyGetListData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker.Keywords", "GetList");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp13_ = service;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp13_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (RygelTrackerKeywordsIfaceDBusProxyGetListData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, rygel_tracker_keywords_iface_dbus_proxy_get_list_ready, _data_, NULL);
}


static void rygel_tracker_keywords_iface_dbus_proxy_get_list_ready (DBusPendingCall* pending, void* user_data) {
	RygelTrackerKeywordsIfaceDBusProxyGetListData* _data_;
	_data_ = user_data;
	g_simple_async_result_complete (g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _data_->_callback_, _data_->_user_data_, _data_));
}


static char** rygel_tracker_keywords_iface_dbus_proxy_get_list_finish (RygelTrackerKeywordsIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
	RygelTrackerKeywordsIfaceDBusProxyGetListData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	char** _result;
	int _result_length1;
	int _result_length2;
	char** _tmp20_;
	int _tmp20__length;
	int _tmp20__size;
	int _tmp20__length1;
	DBusMessageIter _tmp21_;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp18_;
			_edomain = DBUS_GERROR;
			_tmp18_ = _dbus_error.name + 27;
			if (strcmp (_tmp18_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp18_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp18_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp18_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp18_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp18_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp18_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp18_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp18_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp18_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp18_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp18_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp18_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp18_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp18_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp18_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp18_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp18_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp18_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp18_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp18_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp18_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp18_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp18_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp18_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp18_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp18_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp18_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp18_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp18_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp18_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp18_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp18_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error_literal (error, _edomain, _ecode, _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "aas")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "aas", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp20_ = g_new (char*, 5);
	_tmp20__length = 0;
	_tmp20__size = 4;
	_tmp20__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp21_);
	for (; dbus_message_iter_get_arg_type (&_tmp21_); _tmp20__length1++) {
		int _tmp20__length2;
		DBusMessageIter _tmp22_;
		_tmp20__length2 = 0;
		dbus_message_iter_recurse (&_tmp21_, &_tmp22_);
		for (; dbus_message_iter_get_arg_type (&_tmp22_); _tmp20__length2++) {
			const char* _tmp23_;
			if (_tmp20__size == _tmp20__length) {
				_tmp20__size = 2 * _tmp20__size;
				_tmp20_ = g_renew (char*, _tmp20_, _tmp20__size + 1);
			}
			dbus_message_iter_get_basic (&_tmp22_, &_tmp23_);
			dbus_message_iter_next (&_tmp22_);
			_tmp20_[_tmp20__length++] = g_strdup (_tmp23_);
		}
		_result_length2 = _tmp20__length2;
		dbus_message_iter_next (&_tmp21_);
	}
	_result_length1 = _tmp20__length1;
	_tmp20_[_tmp20__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp20_;
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_tracker_keywords_iface_dbus_proxy_rygel_tracker_keywords_iface__interface_init (RygelTrackerKeywordsIfaceIface* iface) {
	iface->get_list = rygel_tracker_keywords_iface_dbus_proxy_get_list_async;
	iface->get_list_finish = rygel_tracker_keywords_iface_dbus_proxy_get_list_finish;
}


static void rygel_tracker_keywords_iface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void rygel_tracker_keywords_iface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


void rygel_tracker_metadata_iface_get_unique_values (RygelTrackerMetadataIface* self, const char* service, char** meta_types, int meta_types_length1, const char* query, gboolean descending, gint offset, gint max_hits, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RYGEL_TRACKER_METADATA_IFACE_GET_INTERFACE (self)->get_unique_values (self, service, meta_types, meta_types_length1, query, descending, offset, max_hits, _callback_, _user_data_);
}


char** rygel_tracker_metadata_iface_get_unique_values_finish (RygelTrackerMetadataIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
	return RYGEL_TRACKER_METADATA_IFACE_GET_INTERFACE (self)->get_unique_values_finish (self, _res_, result_length1, result_length2, error);
}


void rygel_tracker_metadata_iface_get (RygelTrackerMetadataIface* self, const char* service_type, const char* uri, char** keys, int keys_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RYGEL_TRACKER_METADATA_IFACE_GET_INTERFACE (self)->get (self, service_type, uri, keys, keys_length1, _callback_, _user_data_);
}


char** rygel_tracker_metadata_iface_get_finish (RygelTrackerMetadataIface* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	return RYGEL_TRACKER_METADATA_IFACE_GET_INTERFACE (self)->get_finish (self, _res_, result_length1, error);
}


void _rygel_tracker_metadata_iface_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_rygel_tracker_metadata_iface_introspect (RygelTrackerMetadataIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.Tracker.Metadata\">\n  <method name=\"GetUniqueValues\">\n    <arg name=\"service\" type=\"s\" direction=\"in\"/>\n    <arg name=\"meta_types\" type=\"as\" direction=\"in\"/>\n    <arg name=\"query\" type=\"s\" direction=\"in\"/>\n    <arg name=\"descending\" type=\"b\" direction=\"in\"/>\n    <arg name=\"offset\" type=\"i\" direction=\"in\"/>\n    <arg name=\"max_hits\" type=\"i\" direction=\"in\"/>\n    <arg name=\"result\" type=\"aas\" direction=\"out\"/>\n  </method>\n  <method name=\"Get\">\n    <arg name=\"service_type\" type=\"s\" direction=\"in\"/>\n    <arg name=\"uri\" type=\"s\" direction=\"in\"/>\n    <arg name=\"keys\" type=\"as\" direction=\"in\"/>\n    <arg name=\"result\" type=\"as\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_tracker_metadata_iface_property_get_all (RygelTrackerMetadataIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp24_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp24_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp24_);
	if (strcmp (interface_name, "org.freedesktop.Tracker.Metadata") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_tracker_metadata_iface_get_unique_values (RygelTrackerMetadataIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* service = NULL;
	const char* _tmp25_;
	char** meta_types = NULL;
	int meta_types_length1;
	char** _tmp26_;
	int _tmp26__length;
	int _tmp26__size;
	int _tmp26__length1;
	DBusMessageIter _tmp27_;
	char* query = NULL;
	const char* _tmp29_;
	gboolean descending = FALSE;
	dbus_bool_t _tmp30_;
	gint offset = 0;
	dbus_int32_t _tmp31_;
	gint max_hits = 0;
	dbus_int32_t _tmp32_;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "sassbii")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp25_);
	dbus_message_iter_next (&iter);
	service = g_strdup (_tmp25_);
	meta_types_length1 = 0;
	_tmp26_ = g_new (char*, 5);
	_tmp26__length = 0;
	_tmp26__size = 4;
	_tmp26__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp27_);
	for (; dbus_message_iter_get_arg_type (&_tmp27_); _tmp26__length1++) {
		const char* _tmp28_;
		if (_tmp26__size == _tmp26__length) {
			_tmp26__size = 2 * _tmp26__size;
			_tmp26_ = g_renew (char*, _tmp26_, _tmp26__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp27_, &_tmp28_);
		dbus_message_iter_next (&_tmp27_);
		_tmp26_[_tmp26__length++] = g_strdup (_tmp28_);
	}
	meta_types_length1 = _tmp26__length1;
	_tmp26_[_tmp26__length] = NULL;
	dbus_message_iter_next (&iter);
	meta_types = _tmp26_;
	dbus_message_iter_get_basic (&iter, &_tmp29_);
	dbus_message_iter_next (&iter);
	query = g_strdup (_tmp29_);
	dbus_message_iter_get_basic (&iter, &_tmp30_);
	dbus_message_iter_next (&iter);
	descending = _tmp30_;
	dbus_message_iter_get_basic (&iter, &_tmp31_);
	dbus_message_iter_next (&iter);
	offset = _tmp31_;
	dbus_message_iter_get_basic (&iter, &_tmp32_);
	dbus_message_iter_next (&iter);
	max_hits = _tmp32_;
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	rygel_tracker_metadata_iface_get_unique_values (self, service, meta_types, meta_types_length1, query, descending, offset, max_hits, _dbus_rygel_tracker_metadata_iface_get_unique_values_ready, _user_data_);
	_g_free0 (service);
	meta_types = (_vala_array_free (meta_types, meta_types_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (query);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_rygel_tracker_metadata_iface_get_unique_values_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	char** result;
	int result_length1;
	int result_length2;
	DBusMessage* reply;
	char** _tmp33_;
	DBusMessageIter _tmp34_;
	int _tmp35_;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	result_length1 = 0;
	result_length2 = 0;
	result = rygel_tracker_metadata_iface_get_unique_values_finish (source_object, _res_, &result_length1, &result_length2, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp33_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "as", &_tmp34_);
	for (_tmp35_ = 0; _tmp35_ < result_length1; _tmp35_++) {
		DBusMessageIter _tmp36_;
		int _tmp37_;
		dbus_message_iter_open_container (&_tmp34_, DBUS_TYPE_ARRAY, "s", &_tmp36_);
		for (_tmp37_ = 0; _tmp37_ < result_length2; _tmp37_++) {
			const char* _tmp38_;
			_tmp38_ = *_tmp33_;
			dbus_message_iter_append_basic (&_tmp36_, DBUS_TYPE_STRING, &_tmp38_);
			_tmp33_++;
		}
		dbus_message_iter_close_container (&_tmp34_, &_tmp36_);
	}
	dbus_message_iter_close_container (&iter, &_tmp34_);
	result = (_vala_array_free (result,  result_length1 *  result_length2, (GDestroyNotify) g_free), NULL);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


static DBusHandlerResult _dbus_rygel_tracker_metadata_iface_get (RygelTrackerMetadataIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* service_type = NULL;
	const char* _tmp39_;
	char* uri = NULL;
	const char* _tmp40_;
	char** keys = NULL;
	int keys_length1;
	char** _tmp41_;
	int _tmp41__length;
	int _tmp41__size;
	int _tmp41__length1;
	DBusMessageIter _tmp42_;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "ssas")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp39_);
	dbus_message_iter_next (&iter);
	service_type = g_strdup (_tmp39_);
	dbus_message_iter_get_basic (&iter, &_tmp40_);
	dbus_message_iter_next (&iter);
	uri = g_strdup (_tmp40_);
	keys_length1 = 0;
	_tmp41_ = g_new (char*, 5);
	_tmp41__length = 0;
	_tmp41__size = 4;
	_tmp41__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp42_);
	for (; dbus_message_iter_get_arg_type (&_tmp42_); _tmp41__length1++) {
		const char* _tmp43_;
		if (_tmp41__size == _tmp41__length) {
			_tmp41__size = 2 * _tmp41__size;
			_tmp41_ = g_renew (char*, _tmp41_, _tmp41__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp42_, &_tmp43_);
		dbus_message_iter_next (&_tmp42_);
		_tmp41_[_tmp41__length++] = g_strdup (_tmp43_);
	}
	keys_length1 = _tmp41__length1;
	_tmp41_[_tmp41__length] = NULL;
	dbus_message_iter_next (&iter);
	keys = _tmp41_;
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	rygel_tracker_metadata_iface_get (self, service_type, uri, keys, keys_length1, _dbus_rygel_tracker_metadata_iface_get_ready, _user_data_);
	_g_free0 (service_type);
	_g_free0 (uri);
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_rygel_tracker_metadata_iface_get_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	char** result;
	int result_length1;
	DBusMessage* reply;
	char** _tmp44_;
	DBusMessageIter _tmp45_;
	int _tmp46_;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	result_length1 = 0;
	result = rygel_tracker_metadata_iface_get_finish (source_object, _res_, &result_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp44_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "s", &_tmp45_);
	for (_tmp46_ = 0; _tmp46_ < result_length1; _tmp46_++) {
		const char* _tmp47_;
		_tmp47_ = *_tmp44_;
		dbus_message_iter_append_basic (&_tmp45_, DBUS_TYPE_STRING, &_tmp47_);
		_tmp44_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp45_);
	result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


DBusHandlerResult rygel_tracker_metadata_iface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_rygel_tracker_metadata_iface_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_rygel_tracker_metadata_iface_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker.Metadata", "GetUniqueValues")) {
		result = _dbus_rygel_tracker_metadata_iface_get_unique_values (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker.Metadata", "Get")) {
		result = _dbus_rygel_tracker_metadata_iface_get (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void rygel_tracker_metadata_iface_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_rygel_tracker_metadata_iface_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void rygel_tracker_metadata_iface_base_init (RygelTrackerMetadataIfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (RYGEL_TYPE_TRACKER_METADATA_IFACE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_rygel_tracker_metadata_iface_dbus_vtable));
	}
}


GType rygel_tracker_metadata_iface_get_type (void) {
	static GType rygel_tracker_metadata_iface_type_id = 0;
	if (rygel_tracker_metadata_iface_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerMetadataIfaceIface), (GBaseInitFunc) rygel_tracker_metadata_iface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		rygel_tracker_metadata_iface_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelTrackerMetadataIface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_tracker_metadata_iface_type_id, DBUS_TYPE_G_PROXY);
		g_type_set_qdata (rygel_tracker_metadata_iface_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &rygel_tracker_metadata_iface_dbus_proxy_get_type);
	}
	return rygel_tracker_metadata_iface_type_id;
}


G_DEFINE_TYPE_EXTENDED (RygelTrackerMetadataIfaceDBusProxy, rygel_tracker_metadata_iface_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (RYGEL_TYPE_TRACKER_METADATA_IFACE, rygel_tracker_metadata_iface_dbus_proxy_rygel_tracker_metadata_iface__interface_init) );
RygelTrackerMetadataIface* rygel_tracker_metadata_iface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	RygelTrackerMetadataIface* self;
	self = g_object_new (rygel_tracker_metadata_iface_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.Tracker.Metadata", NULL);
	return self;
}


static GObject* rygel_tracker_metadata_iface_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (rygel_tracker_metadata_iface_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), rygel_tracker_metadata_iface_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult rygel_tracker_metadata_iface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void rygel_tracker_metadata_iface_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((RygelTrackerMetadataIfaceDBusProxy*) self)->disposed) {
		return;
	}
	((RygelTrackerMetadataIfaceDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), rygel_tracker_metadata_iface_dbus_proxy_filter, self);
	G_OBJECT_CLASS (rygel_tracker_metadata_iface_dbus_proxy_parent_class)->dispose (self);
}


static void rygel_tracker_metadata_iface_dbus_proxy_class_init (RygelTrackerMetadataIfaceDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = rygel_tracker_metadata_iface_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = rygel_tracker_metadata_iface_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = rygel_tracker_metadata_iface_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_tracker_metadata_iface_dbus_proxy_set_property;
}


static void rygel_tracker_metadata_iface_dbus_proxy_init (RygelTrackerMetadataIfaceDBusProxy* self) {
}


static void rygel_tracker_metadata_iface_dbus_proxy_get_unique_values_async (RygelTrackerMetadataIface* self, const char* service, char** meta_types, int meta_types_length1, const char* query, gboolean descending, gint offset, gint max_hits, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	const char* _tmp48_;
	char** _tmp49_;
	DBusMessageIter _tmp50_;
	int _tmp51_;
	const char* _tmp53_;
	dbus_bool_t _tmp54_;
	dbus_int32_t _tmp55_;
	dbus_int32_t _tmp56_;
	RygelTrackerMetadataIfaceDBusProxyGetUniqueValuesData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker.Metadata", "GetUniqueValues");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp48_ = service;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp48_);
	_tmp49_ = meta_types;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "s", &_tmp50_);
	for (_tmp51_ = 0; _tmp51_ < meta_types_length1; _tmp51_++) {
		const char* _tmp52_;
		_tmp52_ = *_tmp49_;
		dbus_message_iter_append_basic (&_tmp50_, DBUS_TYPE_STRING, &_tmp52_);
		_tmp49_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp50_);
	_tmp53_ = query;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp53_);
	_tmp54_ = descending;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_BOOLEAN, &_tmp54_);
	_tmp55_ = offset;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp55_);
	_tmp56_ = max_hits;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp56_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (RygelTrackerMetadataIfaceDBusProxyGetUniqueValuesData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, rygel_tracker_metadata_iface_dbus_proxy_get_unique_values_ready, _data_, NULL);
}


static void rygel_tracker_metadata_iface_dbus_proxy_get_unique_values_ready (DBusPendingCall* pending, void* user_data) {
	RygelTrackerMetadataIfaceDBusProxyGetUniqueValuesData* _data_;
	_data_ = user_data;
	g_simple_async_result_complete (g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _data_->_callback_, _data_->_user_data_, _data_));
}


static char** rygel_tracker_metadata_iface_dbus_proxy_get_unique_values_finish (RygelTrackerMetadataIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
	RygelTrackerMetadataIfaceDBusProxyGetUniqueValuesData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	char** _result;
	int _result_length1;
	int _result_length2;
	char** _tmp71_;
	int _tmp71__length;
	int _tmp71__size;
	int _tmp71__length1;
	DBusMessageIter _tmp72_;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp61_;
			_edomain = DBUS_GERROR;
			_tmp61_ = _dbus_error.name + 27;
			if (strcmp (_tmp61_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp61_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp61_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp61_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp61_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp61_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp61_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp61_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp61_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp61_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp61_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp61_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp61_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp61_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp61_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp61_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp61_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp61_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp61_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp61_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp61_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp61_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp61_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp61_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp61_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp61_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp61_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp61_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp61_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp61_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp61_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp61_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp61_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error_literal (error, _edomain, _ecode, _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "aas")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "aas", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp71_ = g_new (char*, 5);
	_tmp71__length = 0;
	_tmp71__size = 4;
	_tmp71__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp72_);
	for (; dbus_message_iter_get_arg_type (&_tmp72_); _tmp71__length1++) {
		int _tmp71__length2;
		DBusMessageIter _tmp73_;
		_tmp71__length2 = 0;
		dbus_message_iter_recurse (&_tmp72_, &_tmp73_);
		for (; dbus_message_iter_get_arg_type (&_tmp73_); _tmp71__length2++) {
			const char* _tmp74_;
			if (_tmp71__size == _tmp71__length) {
				_tmp71__size = 2 * _tmp71__size;
				_tmp71_ = g_renew (char*, _tmp71_, _tmp71__size + 1);
			}
			dbus_message_iter_get_basic (&_tmp73_, &_tmp74_);
			dbus_message_iter_next (&_tmp73_);
			_tmp71_[_tmp71__length++] = g_strdup (_tmp74_);
		}
		_result_length2 = _tmp71__length2;
		dbus_message_iter_next (&_tmp72_);
	}
	_result_length1 = _tmp71__length1;
	_tmp71_[_tmp71__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp71_;
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_tracker_metadata_iface_dbus_proxy_get_async (RygelTrackerMetadataIface* self, const char* service_type, const char* uri, char** keys, int keys_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	const char* _tmp75_;
	const char* _tmp76_;
	char** _tmp77_;
	DBusMessageIter _tmp78_;
	int _tmp79_;
	RygelTrackerMetadataIfaceDBusProxyGetData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker.Metadata", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp75_ = service_type;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp75_);
	_tmp76_ = uri;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp76_);
	_tmp77_ = keys;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "s", &_tmp78_);
	for (_tmp79_ = 0; _tmp79_ < keys_length1; _tmp79_++) {
		const char* _tmp80_;
		_tmp80_ = *_tmp77_;
		dbus_message_iter_append_basic (&_tmp78_, DBUS_TYPE_STRING, &_tmp80_);
		_tmp77_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp78_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (RygelTrackerMetadataIfaceDBusProxyGetData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, rygel_tracker_metadata_iface_dbus_proxy_get_ready, _data_, NULL);
}


static void rygel_tracker_metadata_iface_dbus_proxy_get_ready (DBusPendingCall* pending, void* user_data) {
	RygelTrackerMetadataIfaceDBusProxyGetData* _data_;
	_data_ = user_data;
	g_simple_async_result_complete (g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _data_->_callback_, _data_->_user_data_, _data_));
}


static char** rygel_tracker_metadata_iface_dbus_proxy_get_finish (RygelTrackerMetadataIface* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	RygelTrackerMetadataIfaceDBusProxyGetData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	char** _result;
	int _result_length1;
	char** _tmp91_;
	int _tmp91__length;
	int _tmp91__size;
	int _tmp91__length1;
	DBusMessageIter _tmp92_;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp84_;
			_edomain = DBUS_GERROR;
			_tmp84_ = _dbus_error.name + 27;
			if (strcmp (_tmp84_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp84_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp84_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp84_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp84_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp84_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp84_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp84_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp84_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp84_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp84_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp84_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp84_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp84_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp84_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp84_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp84_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp84_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp84_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp84_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp84_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp84_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp84_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp84_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp84_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp84_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp84_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp84_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp84_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp84_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp84_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp84_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp84_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error_literal (error, _edomain, _ecode, _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "as")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "as", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp91_ = g_new (char*, 5);
	_tmp91__length = 0;
	_tmp91__size = 4;
	_tmp91__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp92_);
	for (; dbus_message_iter_get_arg_type (&_tmp92_); _tmp91__length1++) {
		const char* _tmp93_;
		if (_tmp91__size == _tmp91__length) {
			_tmp91__size = 2 * _tmp91__size;
			_tmp91_ = g_renew (char*, _tmp91_, _tmp91__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp92_, &_tmp93_);
		dbus_message_iter_next (&_tmp92_);
		_tmp91_[_tmp91__length++] = g_strdup (_tmp93_);
	}
	_result_length1 = _tmp91__length1;
	_tmp91_[_tmp91__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp91_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_tracker_metadata_iface_dbus_proxy_rygel_tracker_metadata_iface__interface_init (RygelTrackerMetadataIfaceIface* iface) {
	iface->get_unique_values = rygel_tracker_metadata_iface_dbus_proxy_get_unique_values_async;
	iface->get_unique_values_finish = rygel_tracker_metadata_iface_dbus_proxy_get_unique_values_finish;
	iface->get = rygel_tracker_metadata_iface_dbus_proxy_get_async;
	iface->get_finish = rygel_tracker_metadata_iface_dbus_proxy_get_finish;
}


static void rygel_tracker_metadata_iface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void rygel_tracker_metadata_iface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


void rygel_tracker_search_iface_query (RygelTrackerSearchIface* self, gint live_query_id, const char* service, char** fields, int fields_length1, const char* search_text, char** keywords, int keywords_length1, const char* query_condition, gboolean sort_by_service, char** sort_fields, int sort_fields_length1, gboolean sort_descending, gint offset, gint max_hits, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RYGEL_TRACKER_SEARCH_IFACE_GET_INTERFACE (self)->query (self, live_query_id, service, fields, fields_length1, search_text, keywords, keywords_length1, query_condition, sort_by_service, sort_fields, sort_fields_length1, sort_descending, offset, max_hits, _callback_, _user_data_);
}


char** rygel_tracker_search_iface_query_finish (RygelTrackerSearchIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
	return RYGEL_TRACKER_SEARCH_IFACE_GET_INTERFACE (self)->query_finish (self, _res_, result_length1, result_length2, error);
}


void _rygel_tracker_search_iface_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_rygel_tracker_search_iface_introspect (RygelTrackerSearchIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.Tracker.Search\">\n  <method name=\"Query\">\n    <arg name=\"live_query_id\" type=\"i\" direction=\"in\"/>\n    <arg name=\"service\" type=\"s\" direction=\"in\"/>\n    <arg name=\"fields\" type=\"as\" direction=\"in\"/>\n    <arg name=\"search_text\" type=\"s\" direction=\"in\"/>\n    <arg name=\"keywords\" type=\"as\" direction=\"in\"/>\n    <arg name=\"query_condition\" type=\"s\" direction=\"in\"/>\n    <arg name=\"sort_by_service\" type=\"b\" direction=\"in\"/>\n    <arg name=\"sort_fields\" type=\"as\" direction=\"in\"/>\n    <arg name=\"sort_descending\" type=\"b\" direction=\"in\"/>\n    <arg name=\"offset\" type=\"i\" direction=\"in\"/>\n    <arg name=\"max_hits\" type=\"i\" direction=\"in\"/>\n    <arg name=\"result\" type=\"aas\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_tracker_search_iface_property_get_all (RygelTrackerSearchIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp94_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp94_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp94_);
	if (strcmp (interface_name, "org.freedesktop.Tracker.Search") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_rygel_tracker_search_iface_query (RygelTrackerSearchIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	gint live_query_id = 0;
	dbus_int32_t _tmp95_;
	char* service = NULL;
	const char* _tmp96_;
	char** fields = NULL;
	int fields_length1;
	char** _tmp97_;
	int _tmp97__length;
	int _tmp97__size;
	int _tmp97__length1;
	DBusMessageIter _tmp98_;
	char* search_text = NULL;
	const char* _tmp100_;
	char** keywords = NULL;
	int keywords_length1;
	char** _tmp101_;
	int _tmp101__length;
	int _tmp101__size;
	int _tmp101__length1;
	DBusMessageIter _tmp102_;
	char* query_condition = NULL;
	const char* _tmp104_;
	gboolean sort_by_service = FALSE;
	dbus_bool_t _tmp105_;
	char** sort_fields = NULL;
	int sort_fields_length1;
	char** _tmp106_;
	int _tmp106__length;
	int _tmp106__size;
	int _tmp106__length1;
	DBusMessageIter _tmp107_;
	gboolean sort_descending = FALSE;
	dbus_bool_t _tmp109_;
	gint offset = 0;
	dbus_int32_t _tmp110_;
	gint max_hits = 0;
	dbus_int32_t _tmp111_;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "isassassbasbii")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp95_);
	dbus_message_iter_next (&iter);
	live_query_id = _tmp95_;
	dbus_message_iter_get_basic (&iter, &_tmp96_);
	dbus_message_iter_next (&iter);
	service = g_strdup (_tmp96_);
	fields_length1 = 0;
	_tmp97_ = g_new (char*, 5);
	_tmp97__length = 0;
	_tmp97__size = 4;
	_tmp97__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp98_);
	for (; dbus_message_iter_get_arg_type (&_tmp98_); _tmp97__length1++) {
		const char* _tmp99_;
		if (_tmp97__size == _tmp97__length) {
			_tmp97__size = 2 * _tmp97__size;
			_tmp97_ = g_renew (char*, _tmp97_, _tmp97__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp98_, &_tmp99_);
		dbus_message_iter_next (&_tmp98_);
		_tmp97_[_tmp97__length++] = g_strdup (_tmp99_);
	}
	fields_length1 = _tmp97__length1;
	_tmp97_[_tmp97__length] = NULL;
	dbus_message_iter_next (&iter);
	fields = _tmp97_;
	dbus_message_iter_get_basic (&iter, &_tmp100_);
	dbus_message_iter_next (&iter);
	search_text = g_strdup (_tmp100_);
	keywords_length1 = 0;
	_tmp101_ = g_new (char*, 5);
	_tmp101__length = 0;
	_tmp101__size = 4;
	_tmp101__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp102_);
	for (; dbus_message_iter_get_arg_type (&_tmp102_); _tmp101__length1++) {
		const char* _tmp103_;
		if (_tmp101__size == _tmp101__length) {
			_tmp101__size = 2 * _tmp101__size;
			_tmp101_ = g_renew (char*, _tmp101_, _tmp101__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp102_, &_tmp103_);
		dbus_message_iter_next (&_tmp102_);
		_tmp101_[_tmp101__length++] = g_strdup (_tmp103_);
	}
	keywords_length1 = _tmp101__length1;
	_tmp101_[_tmp101__length] = NULL;
	dbus_message_iter_next (&iter);
	keywords = _tmp101_;
	dbus_message_iter_get_basic (&iter, &_tmp104_);
	dbus_message_iter_next (&iter);
	query_condition = g_strdup (_tmp104_);
	dbus_message_iter_get_basic (&iter, &_tmp105_);
	dbus_message_iter_next (&iter);
	sort_by_service = _tmp105_;
	sort_fields_length1 = 0;
	_tmp106_ = g_new (char*, 5);
	_tmp106__length = 0;
	_tmp106__size = 4;
	_tmp106__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp107_);
	for (; dbus_message_iter_get_arg_type (&_tmp107_); _tmp106__length1++) {
		const char* _tmp108_;
		if (_tmp106__size == _tmp106__length) {
			_tmp106__size = 2 * _tmp106__size;
			_tmp106_ = g_renew (char*, _tmp106_, _tmp106__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp107_, &_tmp108_);
		dbus_message_iter_next (&_tmp107_);
		_tmp106_[_tmp106__length++] = g_strdup (_tmp108_);
	}
	sort_fields_length1 = _tmp106__length1;
	_tmp106_[_tmp106__length] = NULL;
	dbus_message_iter_next (&iter);
	sort_fields = _tmp106_;
	dbus_message_iter_get_basic (&iter, &_tmp109_);
	dbus_message_iter_next (&iter);
	sort_descending = _tmp109_;
	dbus_message_iter_get_basic (&iter, &_tmp110_);
	dbus_message_iter_next (&iter);
	offset = _tmp110_;
	dbus_message_iter_get_basic (&iter, &_tmp111_);
	dbus_message_iter_next (&iter);
	max_hits = _tmp111_;
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	rygel_tracker_search_iface_query (self, live_query_id, service, fields, fields_length1, search_text, keywords, keywords_length1, query_condition, sort_by_service, sort_fields, sort_fields_length1, sort_descending, offset, max_hits, _dbus_rygel_tracker_search_iface_query_ready, _user_data_);
	_g_free0 (service);
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (search_text);
	keywords = (_vala_array_free (keywords, keywords_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (query_condition);
	sort_fields = (_vala_array_free (sort_fields, sort_fields_length1, (GDestroyNotify) g_free), NULL);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_rygel_tracker_search_iface_query_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	char** result;
	int result_length1;
	int result_length2;
	DBusMessage* reply;
	char** _tmp112_;
	DBusMessageIter _tmp113_;
	int _tmp114_;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	result_length1 = 0;
	result_length2 = 0;
	result = rygel_tracker_search_iface_query_finish (source_object, _res_, &result_length1, &result_length2, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp112_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "as", &_tmp113_);
	for (_tmp114_ = 0; _tmp114_ < result_length1; _tmp114_++) {
		DBusMessageIter _tmp115_;
		int _tmp116_;
		dbus_message_iter_open_container (&_tmp113_, DBUS_TYPE_ARRAY, "s", &_tmp115_);
		for (_tmp116_ = 0; _tmp116_ < result_length2; _tmp116_++) {
			const char* _tmp117_;
			_tmp117_ = *_tmp112_;
			dbus_message_iter_append_basic (&_tmp115_, DBUS_TYPE_STRING, &_tmp117_);
			_tmp112_++;
		}
		dbus_message_iter_close_container (&_tmp113_, &_tmp115_);
	}
	dbus_message_iter_close_container (&iter, &_tmp113_);
	result = (_vala_array_free (result,  result_length1 *  result_length2, (GDestroyNotify) g_free), NULL);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


DBusHandlerResult rygel_tracker_search_iface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_rygel_tracker_search_iface_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_rygel_tracker_search_iface_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker.Search", "Query")) {
		result = _dbus_rygel_tracker_search_iface_query (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void rygel_tracker_search_iface_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_rygel_tracker_search_iface_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void rygel_tracker_search_iface_base_init (RygelTrackerSearchIfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (RYGEL_TYPE_TRACKER_SEARCH_IFACE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_rygel_tracker_search_iface_dbus_vtable));
	}
}


GType rygel_tracker_search_iface_get_type (void) {
	static GType rygel_tracker_search_iface_type_id = 0;
	if (rygel_tracker_search_iface_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerSearchIfaceIface), (GBaseInitFunc) rygel_tracker_search_iface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		rygel_tracker_search_iface_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelTrackerSearchIface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_tracker_search_iface_type_id, DBUS_TYPE_G_PROXY);
		g_type_set_qdata (rygel_tracker_search_iface_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &rygel_tracker_search_iface_dbus_proxy_get_type);
	}
	return rygel_tracker_search_iface_type_id;
}


G_DEFINE_TYPE_EXTENDED (RygelTrackerSearchIfaceDBusProxy, rygel_tracker_search_iface_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (RYGEL_TYPE_TRACKER_SEARCH_IFACE, rygel_tracker_search_iface_dbus_proxy_rygel_tracker_search_iface__interface_init) );
RygelTrackerSearchIface* rygel_tracker_search_iface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	RygelTrackerSearchIface* self;
	self = g_object_new (rygel_tracker_search_iface_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.Tracker.Search", NULL);
	return self;
}


static GObject* rygel_tracker_search_iface_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (rygel_tracker_search_iface_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), rygel_tracker_search_iface_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult rygel_tracker_search_iface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void rygel_tracker_search_iface_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((RygelTrackerSearchIfaceDBusProxy*) self)->disposed) {
		return;
	}
	((RygelTrackerSearchIfaceDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), rygel_tracker_search_iface_dbus_proxy_filter, self);
	G_OBJECT_CLASS (rygel_tracker_search_iface_dbus_proxy_parent_class)->dispose (self);
}


static void rygel_tracker_search_iface_dbus_proxy_class_init (RygelTrackerSearchIfaceDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = rygel_tracker_search_iface_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = rygel_tracker_search_iface_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = rygel_tracker_search_iface_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_tracker_search_iface_dbus_proxy_set_property;
}


static void rygel_tracker_search_iface_dbus_proxy_init (RygelTrackerSearchIfaceDBusProxy* self) {
}


static void rygel_tracker_search_iface_dbus_proxy_query_async (RygelTrackerSearchIface* self, gint live_query_id, const char* service, char** fields, int fields_length1, const char* search_text, char** keywords, int keywords_length1, const char* query_condition, gboolean sort_by_service, char** sort_fields, int sort_fields_length1, gboolean sort_descending, gint offset, gint max_hits, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	dbus_int32_t _tmp118_;
	const char* _tmp119_;
	char** _tmp120_;
	DBusMessageIter _tmp121_;
	int _tmp122_;
	const char* _tmp124_;
	char** _tmp125_;
	DBusMessageIter _tmp126_;
	int _tmp127_;
	const char* _tmp129_;
	dbus_bool_t _tmp130_;
	char** _tmp131_;
	DBusMessageIter _tmp132_;
	int _tmp133_;
	dbus_bool_t _tmp135_;
	dbus_int32_t _tmp136_;
	dbus_int32_t _tmp137_;
	RygelTrackerSearchIfaceDBusProxyQueryData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker.Search", "Query");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp118_ = live_query_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp118_);
	_tmp119_ = service;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp119_);
	_tmp120_ = fields;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "s", &_tmp121_);
	for (_tmp122_ = 0; _tmp122_ < fields_length1; _tmp122_++) {
		const char* _tmp123_;
		_tmp123_ = *_tmp120_;
		dbus_message_iter_append_basic (&_tmp121_, DBUS_TYPE_STRING, &_tmp123_);
		_tmp120_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp121_);
	_tmp124_ = search_text;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp124_);
	_tmp125_ = keywords;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "s", &_tmp126_);
	for (_tmp127_ = 0; _tmp127_ < keywords_length1; _tmp127_++) {
		const char* _tmp128_;
		_tmp128_ = *_tmp125_;
		dbus_message_iter_append_basic (&_tmp126_, DBUS_TYPE_STRING, &_tmp128_);
		_tmp125_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp126_);
	_tmp129_ = query_condition;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp129_);
	_tmp130_ = sort_by_service;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_BOOLEAN, &_tmp130_);
	_tmp131_ = sort_fields;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "s", &_tmp132_);
	for (_tmp133_ = 0; _tmp133_ < sort_fields_length1; _tmp133_++) {
		const char* _tmp134_;
		_tmp134_ = *_tmp131_;
		dbus_message_iter_append_basic (&_tmp132_, DBUS_TYPE_STRING, &_tmp134_);
		_tmp131_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp132_);
	_tmp135_ = sort_descending;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_BOOLEAN, &_tmp135_);
	_tmp136_ = offset;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp136_);
	_tmp137_ = max_hits;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp137_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (RygelTrackerSearchIfaceDBusProxyQueryData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, rygel_tracker_search_iface_dbus_proxy_query_ready, _data_, NULL);
}


static void rygel_tracker_search_iface_dbus_proxy_query_ready (DBusPendingCall* pending, void* user_data) {
	RygelTrackerSearchIfaceDBusProxyQueryData* _data_;
	_data_ = user_data;
	g_simple_async_result_complete (g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _data_->_callback_, _data_->_user_data_, _data_));
}


static char** rygel_tracker_search_iface_dbus_proxy_query_finish (RygelTrackerSearchIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error) {
	RygelTrackerSearchIfaceDBusProxyQueryData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	char** _result;
	int _result_length1;
	int _result_length2;
	char** _tmp163_;
	int _tmp163__length;
	int _tmp163__size;
	int _tmp163__length1;
	DBusMessageIter _tmp164_;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp142_;
			_edomain = DBUS_GERROR;
			_tmp142_ = _dbus_error.name + 27;
			if (strcmp (_tmp142_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp142_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp142_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp142_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp142_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp142_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp142_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp142_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp142_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp142_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp142_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp142_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp142_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp142_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp142_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp142_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp142_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp142_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp142_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp142_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp142_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp142_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp142_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp142_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp142_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp142_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp142_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp142_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp142_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp142_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp142_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp142_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp142_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error_literal (error, _edomain, _ecode, _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "aas")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "aas", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp163_ = g_new (char*, 5);
	_tmp163__length = 0;
	_tmp163__size = 4;
	_tmp163__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp164_);
	for (; dbus_message_iter_get_arg_type (&_tmp164_); _tmp163__length1++) {
		int _tmp163__length2;
		DBusMessageIter _tmp165_;
		_tmp163__length2 = 0;
		dbus_message_iter_recurse (&_tmp164_, &_tmp165_);
		for (; dbus_message_iter_get_arg_type (&_tmp165_); _tmp163__length2++) {
			const char* _tmp166_;
			if (_tmp163__size == _tmp163__length) {
				_tmp163__size = 2 * _tmp163__size;
				_tmp163_ = g_renew (char*, _tmp163_, _tmp163__size + 1);
			}
			dbus_message_iter_get_basic (&_tmp165_, &_tmp166_);
			dbus_message_iter_next (&_tmp165_);
			_tmp163_[_tmp163__length++] = g_strdup (_tmp166_);
		}
		_result_length2 = _tmp163__length2;
		dbus_message_iter_next (&_tmp164_);
	}
	_result_length1 = _tmp163__length1;
	_tmp163_[_tmp163__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp163_;
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	dbus_message_unref (_reply);
	return _result;
}


static void rygel_tracker_search_iface_dbus_proxy_rygel_tracker_search_iface__interface_init (RygelTrackerSearchIfaceIface* iface) {
	iface->query = rygel_tracker_search_iface_dbus_proxy_query_async;
	iface->query_finish = rygel_tracker_search_iface_dbus_proxy_query_finish;
}


static void rygel_tracker_search_iface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void rygel_tracker_search_iface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}




