/* rygel-http-item-uri_http-get.c generated by valac 0.11.6, the Vala compiler
 * generated from rygel-http-item-uri_http-get.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Authors: Jens Georg <mail@jensge.org>
 *          Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                                <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include <glib/gi18n-lib.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>


#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;
typedef struct _RygelHTTPItemURIPrivate RygelHTTPItemURIPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

struct _RygelHTTPItemURI {
	GObject parent_instance;
	RygelHTTPItemURIPrivate * priv;
	gchar* item_id;
	gint thumbnail_index;
	gint subtitle_index;
	gchar* transcode_target;
	RygelHTTPServer* http_server;
};

struct _RygelHTTPItemURIClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};


static gpointer rygel_http_item_uri_parent_class = NULL;

GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_ITEM_URI_DUMMY_PROPERTY
};
RygelHTTPItemURI* rygel_http_item_uri_new (const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
GQuark rygel_http_request_error_quark (void);
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static gchar* rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self, const gchar* path);
gpointer rygel_media_object_ref (gpointer instance);
void rygel_media_object_unref (gpointer instance);
GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_media_object (GValue* value, gpointer v_object);
void rygel_value_take_media_object (GValue* value, gpointer v_object);
gpointer rygel_value_get_media_object (const GValue* value);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
static void rygel_http_item_uri_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
	RygelHTTPItemURI * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	RygelHTTPServer* _tmp4_;
	RygelHTTPServer* _tmp5_;
	g_return_val_if_fail (item_id != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (item_id);
	_tmp1_ = _tmp0_;
	_g_free0 (self->item_id);
	self->item_id = _tmp1_;
	self->thumbnail_index = thumbnail_index;
	self->subtitle_index = subtitle_index;
	_tmp2_ = g_strdup (transcode_target);
	_tmp3_ = _tmp2_;
	_g_free0 (self->transcode_target);
	self->transcode_target = _tmp3_;
	_tmp4_ = _g_object_ref0 (http_server);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (self->http_server);
	self->http_server = _tmp5_;
	return self;
}


RygelHTTPItemURI* rygel_http_item_uri_new (const gchar* item_id, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
	return rygel_http_item_uri_construct (RYGEL_TYPE_HTTP_ITEM_URI, item_id, http_server, thumbnail_index, subtitle_index, transcode_target);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	regex = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch4_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch4_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error) {
	RygelHTTPItemURI * self = NULL;
	gchar* _tmp0_;
	RygelHTTPServer* _tmp1_;
	RygelHTTPServer* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* request_uri;
	gchar** _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** parts;
	gint parts_length1;
	gint _parts_size_;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
	self->thumbnail_index = -1;
	self->subtitle_index = -1;
	_tmp0_ = NULL;
	_g_free0 (self->transcode_target);
	self->transcode_target = _tmp0_;
	_tmp1_ = _g_object_ref0 (http_server);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (self->http_server);
	self->http_server = _tmp2_;
	_tmp3_ = rygel_http_server_get_path_root (http_server);
	_tmp4_ = string_replace (uri, _tmp3_, "");
	request_uri = _tmp4_;
	_tmp6_ = _tmp5_ = g_strsplit (request_uri, "/", 0);
	parts = _tmp6_;
	parts_length1 = _vala_array_length (_tmp5_);
	_parts_size_ = _vala_array_length (_tmp5_);
	if (parts_length1 < 2) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = (parts_length1 % 2) == 0;
	}
	if (_tmp7_) {
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		_tmp8_ = _ ("Invalid URI '%s'");
		_tmp9_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _tmp8_, request_uri);
		_inner_error_ = _tmp9_;
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (request_uri);
			_g_object_unref0 (self);
			return NULL;
		} else {
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (request_uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		gint i;
		i = 1;
		{
			gboolean _tmp10_;
			_tmp10_ = TRUE;
			while (TRUE) {
				const gchar* _tmp11_;
				GQuark _tmp12_;
				static GQuark _tmp12__label0 = 0;
				static GQuark _tmp12__label1 = 0;
				static GQuark _tmp12__label2 = 0;
				static GQuark _tmp12__label3 = 0;
				if (!_tmp10_) {
					i = i + 2;
				}
				_tmp10_ = FALSE;
				if (!(i < (parts_length1 - 1))) {
					break;
				}
				_tmp11_ = parts[i];
				_tmp12_ = (NULL == _tmp11_) ? 0 : g_quark_from_string (_tmp11_);
				if (_tmp12_ == ((0 != _tmp12__label0) ? _tmp12__label0 : (_tmp12__label0 = g_quark_from_static_string ("i")))) {
					switch (0) {
						default:
						{
							gchar* _tmp13_ = NULL;
							gchar* _tmp14_;
							size_t _tmp15_;
							guchar* _tmp16_ = NULL;
							guchar* _tmp17_;
							guchar* data;
							gint data_length1;
							gint _data_size_;
							GString* _tmp18_ = NULL;
							GString* builder;
							gchar* _tmp19_;
							gchar* _tmp20_;
							_tmp13_ = soup_uri_decode (parts[i + 1]);
							_tmp14_ = _tmp13_;
							_tmp16_ = g_base64_decode (_tmp14_, &_tmp15_);
							data = (_tmp17_ = _tmp16_, _g_free0 (_tmp14_), _tmp17_);
							data_length1 = _tmp15_;
							_data_size_ = _tmp15_;
							_tmp18_ = g_string_new ("");
							builder = _tmp18_;
							g_string_append (builder, (const gchar*) data);
							_tmp19_ = g_strdup (builder->str);
							_tmp20_ = _tmp19_;
							_g_free0 (self->item_id);
							self->item_id = _tmp20_;
							_g_string_free0 (builder);
							data = (g_free (data), NULL);
							break;
						}
					}
				} else if (_tmp12_ == ((0 != _tmp12__label1) ? _tmp12__label1 : (_tmp12__label1 = g_quark_from_static_string ("tr")))) {
					switch (0) {
						default:
						{
							gchar* _tmp21_ = NULL;
							gchar* _tmp22_;
							_tmp21_ = soup_uri_decode (parts[i + 1]);
							_tmp22_ = _tmp21_;
							_g_free0 (self->transcode_target);
							self->transcode_target = _tmp22_;
							break;
						}
					}
				} else if (_tmp12_ == ((0 != _tmp12__label2) ? _tmp12__label2 : (_tmp12__label2 = g_quark_from_static_string ("th")))) {
					switch (0) {
						default:
						{
							gint _tmp23_;
							_tmp23_ = atoi (parts[i + 1]);
							self->thumbnail_index = _tmp23_;
							break;
						}
					}
				} else if (_tmp12_ == ((0 != _tmp12__label3) ? _tmp12__label3 : (_tmp12__label3 = g_quark_from_static_string ("sub")))) {
					switch (0) {
						default:
						{
							gint _tmp24_;
							_tmp24_ = atoi (parts[i + 1]);
							self->subtitle_index = _tmp24_;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							break;
						}
					}
				}
			}
		}
	}
	if (self->item_id == NULL) {
		const gchar* _tmp25_ = NULL;
		GError* _tmp26_ = NULL;
		_tmp25_ = _ ("Not Found");
		_tmp26_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp25_);
		_inner_error_ = _tmp26_;
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (request_uri);
			_g_object_unref0 (self);
			return NULL;
		} else {
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (request_uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (request_uri);
	return self;
}


RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error) {
	return rygel_http_item_uri_construct_from_string (RYGEL_TYPE_HTTP_ITEM_URI, uri, http_server, error);
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = g_new0 (gchar, _tmp0_ + 1);
	_result_ = _tmp1_;
	_result__length1 = _tmp0_ + 1;
	__result__size_ = _tmp0_ + 1;
	_result__length1--;
	_tmp2_ = strlen (self);
	memcpy (_result_, self, (gsize) _tmp2_);
	_tmp3_ = _result_;
	*result_length1 = _result__length1;
	result = _tmp3_;
	return result;
}


gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self) {
	gchar* result = NULL;
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* data;
	gint data_length1;
	gint _data_size_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* escaped;
	gchar* path;
	gchar* _tmp18_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = string_to_utf8 (self->item_id, &_tmp0_);
	data = _tmp1_;
	data_length1 = _tmp0_;
	_data_size_ = _tmp0_;
	_tmp2_ = g_base64_encode ((guchar*) data, data_length1);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_uri_escape_string (_tmp3_, "", TRUE);
	escaped = (_tmp5_ = _tmp4_, _g_free0 (_tmp3_), _tmp5_);
	path = g_strconcat ("/i/", escaped, NULL);
	if (self->transcode_target != NULL) {
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = g_uri_escape_string (self->transcode_target, "", TRUE);
		_tmp7_ = _tmp6_;
		_g_free0 (escaped);
		escaped = _tmp7_;
		_tmp8_ = g_strconcat ("/tr/", escaped, NULL);
		_tmp9_ = g_strconcat (path, _tmp8_, NULL);
		_g_free0 (path);
		path = _tmp9_;
		_g_free0 (_tmp8_);
	} else {
		if (self->thumbnail_index >= 0) {
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp10_ = g_strdup_printf ("%i", self->thumbnail_index);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strconcat ("/th/", _tmp11_, NULL);
			_tmp13_ = g_strconcat (path, _tmp12_, NULL);
			_g_free0 (path);
			path = _tmp13_;
			_g_free0 (_tmp12_);
			_g_free0 (_tmp11_);
		} else {
			if (self->subtitle_index >= 0) {
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp14_ = g_strdup_printf ("%i", self->subtitle_index);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strconcat ("/sub/", _tmp15_, NULL);
				_tmp17_ = g_strconcat (path, _tmp16_, NULL);
				_g_free0 (path);
				path = _tmp17_;
				_g_free0 (_tmp16_);
				_g_free0 (_tmp15_);
			}
		}
	}
	_tmp18_ = rygel_http_item_uri_create_uri_for_path (self, path);
	result = _tmp18_;
	_g_free0 (path);
	_g_free0 (escaped);
	data = (g_free (data), NULL);
	return result;
}


static gchar* rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self, const gchar* path) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	guint _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = gssdp_client_get_host_ip ((GSSDPClient*) self->http_server->context);
	_tmp1_ = gupnp_context_get_port (self->http_server->context);
	_tmp2_ = rygel_http_server_get_path_root (self->http_server);
	_tmp3_ = g_strdup_printf ("http://%s:%u%s%s", _tmp0_, _tmp1_, _tmp2_, path);
	result = _tmp3_;
	return result;
}


static void rygel_http_item_uri_class_init (RygelHTTPItemURIClass * klass) {
	rygel_http_item_uri_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_http_item_uri_finalize;
}


static void rygel_http_item_uri_instance_init (RygelHTTPItemURI * self) {
}


static void rygel_http_item_uri_finalize (GObject* obj) {
	RygelHTTPItemURI * self;
	self = RYGEL_HTTP_ITEM_URI (obj);
	_g_free0 (self->item_id);
	_g_free0 (self->transcode_target);
	_g_object_unref0 (self->http_server);
	G_OBJECT_CLASS (rygel_http_item_uri_parent_class)->finalize (obj);
}


GType rygel_http_item_uri_get_type (void) {
	static volatile gsize rygel_http_item_uri_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_item_uri_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPItemURIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_item_uri_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPItemURI), 0, (GInstanceInitFunc) rygel_http_item_uri_instance_init, NULL };
		GType rygel_http_item_uri_type_id;
		rygel_http_item_uri_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPItemURI", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_item_uri_type_id__volatile, rygel_http_item_uri_type_id);
	}
	return rygel_http_item_uri_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



