/* MediaViewTracker.c generated by valac 0.32.0.15-114e9, the Vala compiler
 * generated from MediaViewTracker.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define CORE_TYPE_TRACKER (core_tracker_get_type ())
#define CORE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CORE_TYPE_TRACKER, CoreTracker))
#define CORE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CORE_TYPE_TRACKER, CoreTrackerClass))
#define CORE_IS_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CORE_TYPE_TRACKER))
#define CORE_IS_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CORE_TYPE_TRACKER))
#define CORE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CORE_TYPE_TRACKER, CoreTrackerClass))

typedef struct _CoreTracker CoreTracker;
typedef struct _CoreTrackerClass CoreTrackerClass;
typedef struct _CoreTrackerPrivate CoreTrackerPrivate;

#define CORE_TYPE_VIEW_TRACKER (core_view_tracker_get_type ())
#define CORE_VIEW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CORE_TYPE_VIEW_TRACKER, CoreViewTracker))
#define CORE_VIEW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CORE_TYPE_VIEW_TRACKER, CoreViewTrackerClass))
#define CORE_IS_VIEW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CORE_TYPE_VIEW_TRACKER))
#define CORE_IS_VIEW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CORE_TYPE_VIEW_TRACKER))
#define CORE_VIEW_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CORE_TYPE_VIEW_TRACKER, CoreViewTrackerClass))

typedef struct _CoreViewTracker CoreViewTracker;
typedef struct _CoreViewTrackerClass CoreViewTrackerClass;
typedef struct _CoreViewTrackerPrivate CoreViewTrackerPrivate;

#define TYPE_MEDIA_VIEW_TRACKER (media_view_tracker_get_type ())
#define MEDIA_VIEW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_VIEW_TRACKER, MediaViewTracker))
#define MEDIA_VIEW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_VIEW_TRACKER, MediaViewTrackerClass))
#define IS_MEDIA_VIEW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_VIEW_TRACKER))
#define IS_MEDIA_VIEW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_VIEW_TRACKER))
#define MEDIA_VIEW_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_VIEW_TRACKER, MediaViewTrackerClass))

typedef struct _MediaViewTracker MediaViewTracker;
typedef struct _MediaViewTrackerClass MediaViewTrackerClass;
typedef struct _MediaViewTrackerPrivate MediaViewTrackerPrivate;

#define TYPE_MEDIA_ACCUMULATOR (media_accumulator_get_type ())
#define MEDIA_ACCUMULATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_ACCUMULATOR, MediaAccumulator))
#define MEDIA_ACCUMULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_ACCUMULATOR, MediaAccumulatorClass))
#define IS_MEDIA_ACCUMULATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_ACCUMULATOR))
#define IS_MEDIA_ACCUMULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_ACCUMULATOR))
#define MEDIA_ACCUMULATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_ACCUMULATOR, MediaAccumulatorClass))

typedef struct _MediaAccumulator MediaAccumulator;
typedef struct _MediaAccumulatorClass MediaAccumulatorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_VIEW_COLLECTION (view_collection_get_type ())
#define VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW_COLLECTION, ViewCollection))
#define VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW_COLLECTION, ViewCollectionClass))
#define IS_VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW_COLLECTION))
#define IS_VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW_COLLECTION))
#define VIEW_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW_COLLECTION, ViewCollectionClass))

typedef struct _ViewCollection ViewCollection;
typedef struct _ViewCollectionClass ViewCollectionClass;

#define CORE_TYPE_TRACKER_ACCUMULATOR (core_tracker_accumulator_get_type ())
#define CORE_TRACKER_ACCUMULATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CORE_TYPE_TRACKER_ACCUMULATOR, CoreTrackerAccumulator))
#define CORE_IS_TRACKER_ACCUMULATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CORE_TYPE_TRACKER_ACCUMULATOR))
#define CORE_TRACKER_ACCUMULATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CORE_TYPE_TRACKER_ACCUMULATOR, CoreTrackerAccumulatorIface))

typedef struct _CoreTrackerAccumulator CoreTrackerAccumulator;
typedef struct _CoreTrackerAccumulatorIface CoreTrackerAccumulatorIface;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;
typedef struct _MediaAccumulatorPrivate MediaAccumulatorPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_FLAGGABLE (flaggable_get_type ())
#define FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAGGABLE, Flaggable))
#define IS_FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAGGABLE))
#define FLAGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FLAGGABLE, FlaggableIface))

typedef struct _Flaggable Flaggable;
typedef struct _FlaggableIface FlaggableIface;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CoreTracker {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CoreTrackerPrivate * priv;
};

struct _CoreTrackerClass {
	GTypeClass parent_class;
	void (*finalize) (CoreTracker *self);
	void (*updated) (CoreTracker* self);
};

struct _CoreViewTracker {
	CoreTracker parent_instance;
	CoreViewTrackerPrivate * priv;
};

struct _CoreViewTrackerClass {
	CoreTrackerClass parent_class;
};

struct _MediaViewTracker {
	CoreViewTracker parent_instance;
	MediaViewTrackerPrivate * priv;
	MediaAccumulator* all;
	MediaAccumulator* visible;
	MediaAccumulator* selected;
};

struct _MediaViewTrackerClass {
	CoreViewTrackerClass parent_class;
};

struct _CoreTrackerAccumulatorIface {
	GTypeInterface parent_iface;
	gboolean (*include) (CoreTrackerAccumulator* self, DataObject* object);
	gboolean (*uninclude) (CoreTrackerAccumulator* self, DataObject* object);
	gboolean (*altered) (CoreTrackerAccumulator* self, DataObject* object, Alteration* alteration);
};

struct _MediaAccumulator {
	GObject parent_instance;
	MediaAccumulatorPrivate * priv;
	gint total;
	gint photos;
	gint videos;
	gint raw;
	gint flagged;
};

struct _MediaAccumulatorClass {
	GObjectClass parent_class;
};

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

struct _FlaggableIface {
	GTypeInterface parent_iface;
	gboolean (*is_flagged) (Flaggable* self);
	void (*mark_flagged) (Flaggable* self);
	void (*mark_unflagged) (Flaggable* self);
};


static gpointer media_view_tracker_parent_class = NULL;
static gpointer media_accumulator_parent_class = NULL;
static CoreTrackerAccumulatorIface* media_accumulator_core_tracker_accumulator_parent_iface = NULL;

gpointer core_tracker_ref (gpointer instance);
void core_tracker_unref (gpointer instance);
GParamSpec* core_param_spec_tracker (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void core_value_set_tracker (GValue* value, gpointer v_object);
void core_value_take_tracker (GValue* value, gpointer v_object);
gpointer core_value_get_tracker (const GValue* value);
GType core_tracker_get_type (void) G_GNUC_CONST;
GType core_view_tracker_get_type (void) G_GNUC_CONST;
GType media_view_tracker_get_type (void) G_GNUC_CONST;
GType media_accumulator_get_type (void) G_GNUC_CONST;
enum  {
	MEDIA_VIEW_TRACKER_DUMMY_PROPERTY
};
MediaAccumulator* media_accumulator_new (void);
MediaAccumulator* media_accumulator_construct (GType object_type);
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType view_collection_get_type (void) G_GNUC_CONST;
MediaViewTracker* media_view_tracker_new (ViewCollection* collection);
MediaViewTracker* media_view_tracker_construct (GType object_type, ViewCollection* collection);
CoreViewTracker* core_view_tracker_new (ViewCollection* collection);
CoreViewTracker* core_view_tracker_construct (GType object_type, ViewCollection* collection);
GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
GType core_tracker_accumulator_get_type (void) G_GNUC_CONST;
void core_view_tracker_start (CoreViewTracker* self, CoreTrackerAccumulator* all, CoreTrackerAccumulator* visible, CoreTrackerAccumulator* selected);
static void media_view_tracker_finalize (CoreTracker* obj);
enum  {
	MEDIA_ACCUMULATOR_DUMMY_PROPERTY
};
static gboolean media_accumulator_real_include (CoreTrackerAccumulator* base, DataObject* object);
GType data_source_get_type (void) G_GNUC_CONST;
GType data_view_get_type (void) G_GNUC_CONST;
DataSource* data_view_get_source (DataView* self);
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
PhotoFileFormat photo_get_master_file_format (Photo* self);
GType raw_developer_get_type (void) G_GNUC_CONST;
gboolean photo_is_raw_developer_available (Photo* self, RawDeveloper d);
GType video_source_get_type (void) G_GNUC_CONST;
GType flaggable_get_type (void) G_GNUC_CONST;
gboolean flaggable_is_flagged (Flaggable* self);
static gboolean media_accumulator_real_uninclude (CoreTrackerAccumulator* base, DataObject* object);
gchar* data_object_to_string (DataObject* self);
gchar* media_accumulator_to_string (MediaAccumulator* self);
GType video_get_type (void) G_GNUC_CONST;
static gboolean media_accumulator_real_altered (CoreTrackerAccumulator* base, DataObject* object, Alteration* alteration);
gboolean alteration_has_detail (Alteration* self, const gchar* subject, const gchar* detail);
static void media_accumulator_finalize (GObject* obj);


MediaViewTracker* media_view_tracker_construct (GType object_type, ViewCollection* collection) {
	MediaViewTracker* self = NULL;
	ViewCollection* _tmp0_ = NULL;
	MediaAccumulator* _tmp1_ = NULL;
	MediaAccumulator* _tmp2_ = NULL;
	MediaAccumulator* _tmp3_ = NULL;
#line 12 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (collection), NULL);
#line 13 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp0_ = collection;
#line 13 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self = (MediaViewTracker*) core_view_tracker_construct (object_type, _tmp0_);
#line 15 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp1_ = self->all;
#line 15 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp2_ = self->visible;
#line 15 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp3_ = self->selected;
#line 15 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	core_view_tracker_start (G_TYPE_CHECK_INSTANCE_CAST (self, CORE_TYPE_VIEW_TRACKER, CoreViewTracker), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CORE_TYPE_TRACKER_ACCUMULATOR, CoreTrackerAccumulator), G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CORE_TYPE_TRACKER_ACCUMULATOR, CoreTrackerAccumulator), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CORE_TYPE_TRACKER_ACCUMULATOR, CoreTrackerAccumulator));
#line 12 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	return self;
#line 375 "MediaViewTracker.c"
}


MediaViewTracker* media_view_tracker_new (ViewCollection* collection) {
#line 12 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	return media_view_tracker_construct (TYPE_MEDIA_VIEW_TRACKER, collection);
#line 382 "MediaViewTracker.c"
}


static void media_view_tracker_class_init (MediaViewTrackerClass * klass) {
#line 7 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	media_view_tracker_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	((CoreTrackerClass *) klass)->finalize = media_view_tracker_finalize;
#line 391 "MediaViewTracker.c"
}


static void media_view_tracker_instance_init (MediaViewTracker * self) {
	MediaAccumulator* _tmp0_ = NULL;
	MediaAccumulator* _tmp1_ = NULL;
	MediaAccumulator* _tmp2_ = NULL;
#line 8 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp0_ = media_accumulator_new ();
#line 8 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self->all = _tmp0_;
#line 9 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp1_ = media_accumulator_new ();
#line 9 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self->visible = _tmp1_;
#line 10 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp2_ = media_accumulator_new ();
#line 10 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self->selected = _tmp2_;
#line 411 "MediaViewTracker.c"
}


static void media_view_tracker_finalize (CoreTracker* obj) {
	MediaViewTracker * self;
#line 7 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_VIEW_TRACKER, MediaViewTracker);
#line 8 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_g_object_unref0 (self->all);
#line 9 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_g_object_unref0 (self->visible);
#line 10 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_g_object_unref0 (self->selected);
#line 7 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	CORE_TRACKER_CLASS (media_view_tracker_parent_class)->finalize (obj);
#line 427 "MediaViewTracker.c"
}


GType media_view_tracker_get_type (void) {
	static volatile gsize media_view_tracker_type_id__volatile = 0;
	if (g_once_init_enter (&media_view_tracker_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaViewTrackerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_view_tracker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaViewTracker), 0, (GInstanceInitFunc) media_view_tracker_instance_init, NULL };
		GType media_view_tracker_type_id;
		media_view_tracker_type_id = g_type_register_static (CORE_TYPE_VIEW_TRACKER, "MediaViewTracker", &g_define_type_info, 0);
		g_once_init_leave (&media_view_tracker_type_id__volatile, media_view_tracker_type_id);
	}
	return media_view_tracker_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 31 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	return self ? g_object_ref (self) : NULL;
#line 446 "MediaViewTracker.c"
}


static gboolean media_accumulator_real_include (CoreTrackerAccumulator* base, DataObject* object) {
	MediaAccumulator * self;
	gboolean result = FALSE;
	DataSource* source = NULL;
	DataObject* _tmp0_ = NULL;
	DataSource* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Photo* photo = NULL;
	DataSource* _tmp3_ = NULL;
	Photo* _tmp4_ = NULL;
	Photo* _tmp5_ = NULL;
	Flaggable* flaggable = NULL;
	DataSource* _tmp17_ = NULL;
	Flaggable* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	Flaggable* _tmp20_ = NULL;
#line 26 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_ACCUMULATOR, MediaAccumulator);
#line 26 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 27 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp0_ = object;
#line 27 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp1_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_VIEW, DataView));
#line 27 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	source = _tmp1_;
#line 29 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp2_ = self->total;
#line 29 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self->total = _tmp2_ + 1;
#line 31 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp3_ = source;
#line 31 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_PHOTO) ? ((Photo*) _tmp3_) : NULL);
#line 31 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	photo = _tmp4_;
#line 32 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp5_ = photo;
#line 32 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	if (_tmp5_ != NULL) {
#line 490 "MediaViewTracker.c"
		Photo* _tmp6_ = NULL;
		PhotoFileFormat _tmp7_ = 0;
		gboolean _tmp9_ = FALSE;
		Photo* _tmp10_ = NULL;
		PhotoFileFormat _tmp11_ = 0;
#line 33 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp6_ = photo;
#line 33 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp7_ = photo_get_master_file_format (_tmp6_);
#line 33 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		if (_tmp7_ == PHOTO_FILE_FORMAT_RAW) {
#line 502 "MediaViewTracker.c"
			gint _tmp8_ = 0;
#line 34 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp8_ = self->raw;
#line 34 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			self->raw = _tmp8_ + 1;
#line 508 "MediaViewTracker.c"
		}
#line 37 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp10_ = photo;
#line 37 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp11_ = photo_get_master_file_format (_tmp10_);
#line 37 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		if (_tmp11_ != PHOTO_FILE_FORMAT_RAW) {
#line 37 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp9_ = TRUE;
#line 518 "MediaViewTracker.c"
		} else {
			Photo* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
#line 38 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp12_ = photo;
#line 38 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp13_ = photo_is_raw_developer_available (_tmp12_, RAW_DEVELOPER_CAMERA);
#line 38 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp9_ = _tmp13_;
#line 528 "MediaViewTracker.c"
		}
#line 37 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		if (_tmp9_) {
#line 532 "MediaViewTracker.c"
			gint _tmp14_ = 0;
#line 39 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp14_ = self->photos;
#line 39 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			self->photos = _tmp14_ + 1;
#line 538 "MediaViewTracker.c"
		}
	} else {
		DataSource* _tmp15_ = NULL;
#line 41 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp15_ = source;
#line 41 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, TYPE_VIDEO_SOURCE)) {
#line 546 "MediaViewTracker.c"
			gint _tmp16_ = 0;
#line 42 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp16_ = self->videos;
#line 42 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			self->videos = _tmp16_ + 1;
#line 552 "MediaViewTracker.c"
		}
	}
#line 45 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp17_ = source;
#line 45 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, TYPE_FLAGGABLE) ? ((Flaggable*) _tmp17_) : NULL);
#line 45 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	flaggable = _tmp18_;
#line 46 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp20_ = flaggable;
#line 46 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	if (_tmp20_ != NULL) {
#line 565 "MediaViewTracker.c"
		Flaggable* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
#line 46 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp21_ = flaggable;
#line 46 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp22_ = flaggable_is_flagged (_tmp21_);
#line 46 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp19_ = _tmp22_;
#line 574 "MediaViewTracker.c"
	} else {
#line 46 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp19_ = FALSE;
#line 578 "MediaViewTracker.c"
	}
#line 46 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	if (_tmp19_) {
#line 582 "MediaViewTracker.c"
		gint _tmp23_ = 0;
#line 47 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp23_ = self->flagged;
#line 47 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		self->flagged = _tmp23_ + 1;
#line 588 "MediaViewTracker.c"
	}
#line 50 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	result = TRUE;
#line 50 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_g_object_unref0 (flaggable);
#line 50 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_g_object_unref0 (photo);
#line 50 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_g_object_unref0 (source);
#line 50 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	return result;
#line 600 "MediaViewTracker.c"
}


static gboolean media_accumulator_real_uninclude (CoreTrackerAccumulator* base, DataObject* object) {
	MediaAccumulator * self;
	gboolean result = FALSE;
	DataSource* source = NULL;
	DataObject* _tmp0_ = NULL;
	DataSource* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp12_ = 0;
	Photo* photo = NULL;
	DataSource* _tmp13_ = NULL;
	Photo* _tmp14_ = NULL;
	Photo* _tmp15_ = NULL;
	Flaggable* flaggable = NULL;
	DataSource* _tmp30_ = NULL;
	Flaggable* _tmp31_ = NULL;
	gboolean _tmp32_ = FALSE;
	Flaggable* _tmp33_ = NULL;
#line 53 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_ACCUMULATOR, MediaAccumulator);
#line 53 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 54 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp0_ = object;
#line 54 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp1_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_VIEW, DataView));
#line 54 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	source = _tmp1_;
#line 56 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp2_ = self->total;
#line 56 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	if (_tmp2_ < 1) {
#line 635 "MediaViewTracker.c"
		DataObject* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GType _tmp6_ = 0UL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
#line 57 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp3_ = object;
#line 57 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp4_ = data_object_to_string (_tmp3_);
#line 57 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp5_ = _tmp4_;
#line 57 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp6_ = G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 57 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp7_ = g_type_name (_tmp6_);
#line 57 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp8_ = media_accumulator_to_string (self);
#line 57 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp9_ = _tmp8_;
#line 57 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp10_ = g_strdup_printf ("Tried to remove DataObject %s from empty %s (%s)", _tmp5_, _tmp7_, _tmp9_);
#line 57 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp11_ = _tmp10_;
#line 57 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		g_warning ("MediaViewTracker.vala:57: %s", _tmp11_);
#line 57 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_g_free0 (_tmp11_);
#line 57 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_g_free0 (_tmp9_);
#line 57 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_g_free0 (_tmp5_);
#line 59 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		result = FALSE;
#line 59 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_g_object_unref0 (source);
#line 59 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		return result;
#line 677 "MediaViewTracker.c"
	}
#line 61 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp12_ = self->total;
#line 61 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self->total = _tmp12_ - 1;
#line 63 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp13_ = source;
#line 63 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, TYPE_PHOTO) ? ((Photo*) _tmp13_) : NULL);
#line 63 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	photo = _tmp14_;
#line 64 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp15_ = photo;
#line 64 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	if (_tmp15_ != NULL) {
#line 693 "MediaViewTracker.c"
		Photo* _tmp16_ = NULL;
		PhotoFileFormat _tmp17_ = 0;
		gboolean _tmp20_ = FALSE;
		Photo* _tmp21_ = NULL;
		PhotoFileFormat _tmp22_ = 0;
#line 65 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp16_ = photo;
#line 65 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp17_ = photo_get_master_file_format (_tmp16_);
#line 65 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		if (_tmp17_ == PHOTO_FILE_FORMAT_RAW) {
#line 705 "MediaViewTracker.c"
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
#line 66 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp18_ = self->raw;
#line 66 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_vala_assert (_tmp18_ > 0, "raw > 0");
#line 67 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp19_ = self->raw;
#line 67 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			self->raw = _tmp19_ - 1;
#line 716 "MediaViewTracker.c"
		}
#line 70 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp21_ = photo;
#line 70 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp22_ = photo_get_master_file_format (_tmp21_);
#line 70 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		if (_tmp22_ != PHOTO_FILE_FORMAT_RAW) {
#line 70 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp20_ = TRUE;
#line 726 "MediaViewTracker.c"
		} else {
			Photo* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
#line 71 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp23_ = photo;
#line 71 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp24_ = photo_is_raw_developer_available (_tmp23_, RAW_DEVELOPER_CAMERA);
#line 71 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp20_ = _tmp24_;
#line 736 "MediaViewTracker.c"
		}
#line 70 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		if (_tmp20_) {
#line 740 "MediaViewTracker.c"
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
#line 72 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp25_ = self->photos;
#line 72 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_vala_assert (_tmp25_ > 0, "photos > 0");
#line 73 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp26_ = self->photos;
#line 73 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			self->photos = _tmp26_ - 1;
#line 751 "MediaViewTracker.c"
		}
	} else {
		DataSource* _tmp27_ = NULL;
#line 75 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp27_ = source;
#line 75 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, TYPE_VIDEO)) {
#line 759 "MediaViewTracker.c"
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
#line 76 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp28_ = self->videos;
#line 76 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_vala_assert (_tmp28_ > 0, "videos > 0");
#line 77 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			_tmp29_ = self->videos;
#line 77 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
			self->videos = _tmp29_ - 1;
#line 770 "MediaViewTracker.c"
		}
	}
#line 80 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp30_ = source;
#line 80 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, TYPE_FLAGGABLE) ? ((Flaggable*) _tmp30_) : NULL);
#line 80 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	flaggable = _tmp31_;
#line 81 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp33_ = flaggable;
#line 81 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	if (_tmp33_ != NULL) {
#line 783 "MediaViewTracker.c"
		Flaggable* _tmp34_ = NULL;
		gboolean _tmp35_ = FALSE;
#line 81 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp34_ = flaggable;
#line 81 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp35_ = flaggable_is_flagged (_tmp34_);
#line 81 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp32_ = _tmp35_;
#line 792 "MediaViewTracker.c"
	} else {
#line 81 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp32_ = FALSE;
#line 796 "MediaViewTracker.c"
	}
#line 81 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	if (_tmp32_) {
#line 800 "MediaViewTracker.c"
		gint _tmp36_ = 0;
		gint _tmp37_ = 0;
#line 82 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp36_ = self->flagged;
#line 82 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_vala_assert (_tmp36_ > 0, "flagged > 0");
#line 83 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp37_ = self->flagged;
#line 83 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		self->flagged = _tmp37_ - 1;
#line 811 "MediaViewTracker.c"
	}
#line 87 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	result = TRUE;
#line 87 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_g_object_unref0 (flaggable);
#line 87 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_g_object_unref0 (photo);
#line 87 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_g_object_unref0 (source);
#line 87 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	return result;
#line 823 "MediaViewTracker.c"
}


static gboolean media_accumulator_real_altered (CoreTrackerAccumulator* base, DataObject* object, Alteration* alteration) {
	MediaAccumulator * self;
	gboolean result = FALSE;
	Alteration* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	Flaggable* flaggable = NULL;
	DataObject* _tmp2_ = NULL;
	DataSource* _tmp3_ = NULL;
	Flaggable* _tmp4_ = NULL;
	Flaggable* _tmp5_ = NULL;
	Flaggable* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 90 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_ACCUMULATOR, MediaAccumulator);
#line 90 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 90 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
#line 93 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp0_ = alteration;
#line 93 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp1_ = alteration_has_detail (_tmp0_, "metadata", "flagged");
#line 93 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	if (!_tmp1_) {
#line 94 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		result = FALSE;
#line 94 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		return result;
#line 855 "MediaViewTracker.c"
	}
#line 96 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp2_ = object;
#line 96 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp3_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_VIEW, DataView));
#line 96 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_FLAGGABLE) ? ((Flaggable*) _tmp3_) : NULL;
#line 96 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	if (_tmp4_ == NULL) {
#line 96 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_g_object_unref0 (_tmp3_);
#line 867 "MediaViewTracker.c"
	}
#line 96 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	flaggable = _tmp4_;
#line 97 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp5_ = flaggable;
#line 97 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	if (_tmp5_ == NULL) {
#line 98 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		result = FALSE;
#line 98 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_g_object_unref0 (flaggable);
#line 98 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		return result;
#line 881 "MediaViewTracker.c"
	}
#line 100 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp6_ = flaggable;
#line 100 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp7_ = flaggable_is_flagged (_tmp6_);
#line 100 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	if (_tmp7_) {
#line 889 "MediaViewTracker.c"
		gint _tmp8_ = 0;
#line 101 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp8_ = self->flagged;
#line 101 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		self->flagged = _tmp8_ + 1;
#line 895 "MediaViewTracker.c"
	} else {
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 103 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp9_ = self->flagged;
#line 103 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_vala_assert (_tmp9_ > 0, "flagged > 0");
#line 104 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		_tmp10_ = self->flagged;
#line 104 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
		self->flagged = _tmp10_ - 1;
#line 907 "MediaViewTracker.c"
	}
#line 107 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	result = TRUE;
#line 107 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_g_object_unref0 (flaggable);
#line 107 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	return result;
#line 915 "MediaViewTracker.c"
}


gchar* media_accumulator_to_string (MediaAccumulator* self) {
	gchar* result = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
#line 110 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	g_return_val_if_fail (IS_MEDIA_ACCUMULATOR (self), NULL);
#line 111 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp0_ = self->photos;
#line 111 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp1_ = self->videos;
#line 111 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp2_ = self->raw;
#line 111 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp3_ = self->flagged;
#line 111 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	_tmp4_ = g_strdup_printf ("%d photos/%d videos/%d raw/%d flagged", _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 111 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	result = _tmp4_;
#line 111 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	return result;
#line 942 "MediaViewTracker.c"
}


MediaAccumulator* media_accumulator_construct (GType object_type) {
	MediaAccumulator * self = NULL;
#line 19 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self = (MediaAccumulator*) g_object_new (object_type, NULL);
#line 19 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	return self;
#line 952 "MediaViewTracker.c"
}


MediaAccumulator* media_accumulator_new (void) {
#line 19 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	return media_accumulator_construct (TYPE_MEDIA_ACCUMULATOR);
#line 959 "MediaViewTracker.c"
}


static void media_accumulator_class_init (MediaAccumulatorClass * klass) {
#line 19 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	media_accumulator_parent_class = g_type_class_peek_parent (klass);
#line 19 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	G_OBJECT_CLASS (klass)->finalize = media_accumulator_finalize;
#line 968 "MediaViewTracker.c"
}


static void media_accumulator_core_tracker_accumulator_interface_init (CoreTrackerAccumulatorIface * iface) {
#line 19 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	media_accumulator_core_tracker_accumulator_parent_iface = g_type_interface_peek_parent (iface);
#line 19 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	iface->include = (gboolean (*)(CoreTrackerAccumulator*, DataObject*)) media_accumulator_real_include;
#line 19 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	iface->uninclude = (gboolean (*)(CoreTrackerAccumulator*, DataObject*)) media_accumulator_real_uninclude;
#line 19 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	iface->altered = (gboolean (*)(CoreTrackerAccumulator*, DataObject*, Alteration*)) media_accumulator_real_altered;
#line 981 "MediaViewTracker.c"
}


static void media_accumulator_instance_init (MediaAccumulator * self) {
#line 20 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self->total = 0;
#line 21 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self->photos = 0;
#line 22 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self->videos = 0;
#line 23 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self->raw = 0;
#line 24 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self->flagged = 0;
#line 996 "MediaViewTracker.c"
}


static void media_accumulator_finalize (GObject* obj) {
	MediaAccumulator * self;
#line 19 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_ACCUMULATOR, MediaAccumulator);
#line 19 "/home/jens/Source/shotwell/src/MediaViewTracker.vala"
	G_OBJECT_CLASS (media_accumulator_parent_class)->finalize (obj);
#line 1006 "MediaViewTracker.c"
}


GType media_accumulator_get_type (void) {
	static volatile gsize media_accumulator_type_id__volatile = 0;
	if (g_once_init_enter (&media_accumulator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaAccumulatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_accumulator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaAccumulator), 0, (GInstanceInitFunc) media_accumulator_instance_init, NULL };
		static const GInterfaceInfo core_tracker_accumulator_info = { (GInterfaceInitFunc) media_accumulator_core_tracker_accumulator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType media_accumulator_type_id;
		media_accumulator_type_id = g_type_register_static (G_TYPE_OBJECT, "MediaAccumulator", &g_define_type_info, 0);
		g_type_add_interface_static (media_accumulator_type_id, CORE_TYPE_TRACKER_ACCUMULATOR, &core_tracker_accumulator_info);
		g_once_init_leave (&media_accumulator_type_id__volatile, media_accumulator_type_id);
	}
	return media_accumulator_type_id__volatile;
}



