/* PhotoMonitor.c generated by valac 0.32.0.15-114e9, the Vala compiler
 * generated from PhotoMonitor.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>


#define TYPE_MONITORABLE_UPDATES (monitorable_updates_get_type ())
#define MONITORABLE_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE_UPDATES, MonitorableUpdates))
#define MONITORABLE_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MONITORABLE_UPDATES, MonitorableUpdatesClass))
#define IS_MONITORABLE_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE_UPDATES))
#define IS_MONITORABLE_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MONITORABLE_UPDATES))
#define MONITORABLE_UPDATES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MONITORABLE_UPDATES, MonitorableUpdatesClass))

typedef struct _MonitorableUpdates MonitorableUpdates;
typedef struct _MonitorableUpdatesClass MonitorableUpdatesClass;
typedef struct _MonitorableUpdatesPrivate MonitorableUpdatesPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_MONITORABLE (monitorable_get_type ())
#define MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE, Monitorable))
#define IS_MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE))
#define MONITORABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MONITORABLE, MonitorableIface))

typedef struct _Monitorable Monitorable;
typedef struct _MonitorableIface MonitorableIface;

#define TYPE_PHOTO_UPDATES (photo_updates_get_type ())
#define PHOTO_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_UPDATES, PhotoUpdates))
#define PHOTO_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_UPDATES, PhotoUpdatesClass))
#define IS_PHOTO_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_UPDATES))
#define IS_PHOTO_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_UPDATES))
#define PHOTO_UPDATES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_UPDATES, PhotoUpdatesClass))

typedef struct _PhotoUpdates PhotoUpdates;
typedef struct _PhotoUpdatesClass PhotoUpdatesClass;
typedef struct _PhotoUpdatesPrivate PhotoUpdatesPrivate;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MEDIA_MONITOR (media_monitor_get_type ())
#define MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_MONITOR, MediaMonitor))
#define MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_MONITOR, MediaMonitorClass))
#define IS_MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_MONITOR))
#define IS_MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_MONITOR))
#define MEDIA_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_MONITOR, MediaMonitorClass))

typedef struct _MediaMonitor MediaMonitor;
typedef struct _MediaMonitorClass MediaMonitorClass;
typedef struct _MediaMonitorPrivate MediaMonitorPrivate;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;

#define MEDIA_MONITOR_TYPE_DISCOVERED_FILE (media_monitor_discovered_file_get_type ())

#define TYPE_TRANSACTION_CONTROLLER (transaction_controller_get_type ())
#define TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionController))
#define TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))
#define IS_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSACTION_CONTROLLER))
#define IS_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSACTION_CONTROLLER))
#define TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))

typedef struct _TransactionController TransactionController;
typedef struct _TransactionControllerClass TransactionControllerClass;

#define TYPE_PHOTO_MONITOR (photo_monitor_get_type ())
#define PHOTO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_MONITOR, PhotoMonitor))
#define PHOTO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_MONITOR, PhotoMonitorClass))
#define IS_PHOTO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_MONITOR))
#define IS_PHOTO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_MONITOR))
#define PHOTO_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_MONITOR, PhotoMonitorClass))

typedef struct _PhotoMonitor PhotoMonitor;
typedef struct _PhotoMonitorClass PhotoMonitorClass;
typedef struct _PhotoMonitorPrivate PhotoMonitorPrivate;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;

#define TYPE_BACKGROUND_JOB (background_job_get_type ())
#define BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_JOB, BackgroundJob))
#define BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_JOB, BackgroundJobClass))
#define IS_BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_JOB))
#define IS_BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_JOB))
#define BACKGROUND_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_JOB, BackgroundJobClass))

typedef struct _BackgroundJob BackgroundJob;
typedef struct _BackgroundJobClass BackgroundJobClass;

#define PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB (photo_monitor_reimport_master_job_get_type ())
#define PHOTO_MONITOR_REIMPORT_MASTER_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, PhotoMonitorReimportMasterJob))
#define PHOTO_MONITOR_REIMPORT_MASTER_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, PhotoMonitorReimportMasterJobClass))
#define PHOTO_MONITOR_IS_REIMPORT_MASTER_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB))
#define PHOTO_MONITOR_IS_REIMPORT_MASTER_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB))
#define PHOTO_MONITOR_REIMPORT_MASTER_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, PhotoMonitorReimportMasterJobClass))

typedef struct _PhotoMonitorReimportMasterJob PhotoMonitorReimportMasterJob;
typedef struct _PhotoMonitorReimportMasterJobClass PhotoMonitorReimportMasterJobClass;

#define PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB (photo_monitor_reimport_editable_job_get_type ())
#define PHOTO_MONITOR_REIMPORT_EDITABLE_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, PhotoMonitorReimportEditableJob))
#define PHOTO_MONITOR_REIMPORT_EDITABLE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, PhotoMonitorReimportEditableJobClass))
#define PHOTO_MONITOR_IS_REIMPORT_EDITABLE_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB))
#define PHOTO_MONITOR_IS_REIMPORT_EDITABLE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB))
#define PHOTO_MONITOR_REIMPORT_EDITABLE_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, PhotoMonitorReimportEditableJobClass))

typedef struct _PhotoMonitorReimportEditableJob PhotoMonitorReimportEditableJob;
typedef struct _PhotoMonitorReimportEditableJobClass PhotoMonitorReimportEditableJobClass;

#define PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB (photo_monitor_reimport_raw_development_job_get_type ())
#define PHOTO_MONITOR_REIMPORT_RAW_DEVELOPMENT_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, PhotoMonitorReimportRawDevelopmentJob))
#define PHOTO_MONITOR_REIMPORT_RAW_DEVELOPMENT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, PhotoMonitorReimportRawDevelopmentJobClass))
#define PHOTO_MONITOR_IS_REIMPORT_RAW_DEVELOPMENT_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB))
#define PHOTO_MONITOR_IS_REIMPORT_RAW_DEVELOPMENT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB))
#define PHOTO_MONITOR_REIMPORT_RAW_DEVELOPMENT_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, PhotoMonitorReimportRawDevelopmentJobClass))

typedef struct _PhotoMonitorReimportRawDevelopmentJob PhotoMonitorReimportRawDevelopmentJob;
typedef struct _PhotoMonitorReimportRawDevelopmentJobClass PhotoMonitorReimportRawDevelopmentJobClass;
#define _workers_unref0(var) ((var == NULL) ? NULL : (var = (workers_unref (var), NULL)))

#define TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION (library_photo_source_collection_get_type ())
#define LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))

typedef struct _LibraryPhotoSourceCollection LibraryPhotoSourceCollection;
typedef struct _LibraryPhotoSourceCollectionClass LibraryPhotoSourceCollectionClass;

#define LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE (library_photo_source_collection_state_get_type ())
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BACKING_PHOTO_ROW (backing_photo_row_get_type ())
#define BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRow))
#define BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))
#define IS_BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_ROW))
#define IS_BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_ROW))
#define BACKING_PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))

typedef struct _BackingPhotoRow BackingPhotoRow;
typedef struct _BackingPhotoRowClass BackingPhotoRowClass;
#define _backing_photo_row_unref0(var) ((var == NULL) ? NULL : (var = (backing_photo_row_unref (var), NULL)))

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())
typedef struct _BackingPhotoRowPrivate BackingPhotoRowPrivate;

#define TYPE_BACKING_PHOTO_ID (backing_photo_id_get_type ())
typedef struct _BackingPhotoID BackingPhotoID;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_ORIENTATION (orientation_get_type ())
#define _monitorable_updates_unref0(var) ((var == NULL) ? NULL : (var = (monitorable_updates_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BackgroundJobPrivate BackgroundJobPrivate;

#define BACKGROUND_JOB_TYPE_JOB_PRIORITY (background_job_job_priority_get_type ())
typedef struct _PhotoMonitorReimportMasterJobPrivate PhotoMonitorReimportMasterJobPrivate;

#define PHOTO_TYPE_REIMPORT_MASTER_STATE (photo_reimport_master_state_get_type ())
#define PHOTO_REIMPORT_MASTER_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterState))
#define PHOTO_REIMPORT_MASTER_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterStateClass))
#define PHOTO_IS_REIMPORT_MASTER_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE))
#define PHOTO_IS_REIMPORT_MASTER_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE))
#define PHOTO_REIMPORT_MASTER_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterStateClass))

typedef struct _PhotoReimportMasterState PhotoReimportMasterState;
typedef struct _PhotoReimportMasterStateClass PhotoReimportMasterStateClass;
typedef struct _PhotoMonitorReimportEditableJobPrivate PhotoMonitorReimportEditableJobPrivate;

#define PHOTO_TYPE_REIMPORT_EDITABLE_STATE (photo_reimport_editable_state_get_type ())
#define PHOTO_REIMPORT_EDITABLE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableState))
#define PHOTO_REIMPORT_EDITABLE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableStateClass))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE))
#define PHOTO_REIMPORT_EDITABLE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableStateClass))

typedef struct _PhotoReimportEditableState PhotoReimportEditableState;
typedef struct _PhotoReimportEditableStateClass PhotoReimportEditableStateClass;
typedef struct _PhotoMonitorReimportRawDevelopmentJobPrivate PhotoMonitorReimportRawDevelopmentJobPrivate;

#define PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE (photo_reimport_raw_development_state_get_type ())
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentState))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentStateClass))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentStateClass))

typedef struct _PhotoReimportRawDevelopmentState PhotoReimportRawDevelopmentState;
typedef struct _PhotoReimportRawDevelopmentStateClass PhotoReimportRawDevelopmentStateClass;
#define _photo_reimport_master_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_master_state_unref (var), NULL)))

#define TYPE_ABSTRACT_SEMAPHORE (abstract_semaphore_get_type ())
#define ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore))
#define ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))
#define IS_ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSTRACT_SEMAPHORE))
#define IS_ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSTRACT_SEMAPHORE))
#define ABSTRACT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))

typedef struct _AbstractSemaphore AbstractSemaphore;
typedef struct _AbstractSemaphoreClass AbstractSemaphoreClass;
#define _photo_reimport_editable_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_editable_state_unref (var), NULL)))
#define _photo_reimport_raw_development_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_raw_development_state_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MonitorableIface {
	GTypeInterface parent_iface;
	gboolean (*is_offline) (Monitorable* self);
	void (*mark_online) (Monitorable* self);
	void (*mark_offline) (Monitorable* self);
	void (*set_master_file) (Monitorable* self, GFile* file);
	void (*set_master_timestamp) (Monitorable* self, GFileInfo* info);
};

struct _MonitorableUpdates {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MonitorableUpdatesPrivate * priv;
	Monitorable* monitorable;
};

struct _MonitorableUpdatesClass {
	GTypeClass parent_class;
	void (*finalize) (MonitorableUpdates *self);
	gboolean (*is_in_alteration) (MonitorableUpdates* self);
	void (*set_master_file) (MonitorableUpdates* self, GFile* file);
	void (*set_master_file_info_altered) (MonitorableUpdates* self, gboolean altered);
	void (*set_master_file_info) (MonitorableUpdates* self, GFileInfo* info);
	void (*set_master_in_alteration) (MonitorableUpdates* self, gboolean in_alteration);
	void (*set_master_alterations_complete) (MonitorableUpdates* self, GFileInfo* info);
	void (*mark_offline) (MonitorableUpdates* self);
	void (*mark_online) (MonitorableUpdates* self);
	void (*reset_online_offline) (MonitorableUpdates* self);
	gboolean (*is_all_updated) (MonitorableUpdates* self);
};

struct _PhotoUpdates {
	MonitorableUpdates parent_instance;
	PhotoUpdatesPrivate * priv;
	LibraryPhoto* photo;
	gboolean reimport_master;
	gboolean reimport_editable;
	gboolean reimport_raw_developments;
	GFile* editable_file;
	gboolean editable_file_info_altered;
	gboolean raw_developer_file_info_altered;
	GFileInfo* editable_file_info;
	gboolean editable_in_alteration;
	gboolean raw_development_in_alteration;
	gboolean revert_to_master;
	GeeCollection* developer_files;
};

struct _PhotoUpdatesClass {
	MonitorableUpdatesClass parent_class;
	void (*set_editable_file) (PhotoUpdates* self, GFile* file);
	void (*set_editable_file_info) (PhotoUpdates* self, GFileInfo* info);
	void (*set_editable_file_info_altered) (PhotoUpdates* self, gboolean altered);
	void (*set_editable_in_alteration) (PhotoUpdates* self, gboolean in_alteration);
	void (*set_raw_development_in_alteration) (PhotoUpdates* self, gboolean in_alteration);
	void (*set_raw_developer_file_info_altered) (PhotoUpdates* self, gboolean altered);
	void (*set_revert_to_master) (PhotoUpdates* self, gboolean revert);
	void (*add_raw_developer_file) (PhotoUpdates* self, GFile* file);
	void (*clear_raw_developer_files) (PhotoUpdates* self);
	void (*set_reimport_master) (PhotoUpdates* self, gboolean reimport);
	void (*set_reimport_editable) (PhotoUpdates* self, gboolean reimport);
	void (*set_reimport_raw_developments) (PhotoUpdates* self, gboolean reimport);
};

typedef enum  {
	MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED,
	MEDIA_MONITOR_DISCOVERED_FILE_IGNORE,
	MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN
} MediaMonitorDiscoveredFile;

struct _MediaMonitor {
	GObject parent_instance;
	MediaMonitorPrivate * priv;
};

struct _MediaMonitorClass {
	GObjectClass parent_class;
	MediaSourceCollection* (*get_media_source_collection) (MediaMonitor* self);
	void (*close) (MediaMonitor* self);
	gchar* (*to_string) (MediaMonitor* self);
	MonitorableUpdates* (*create_updates) (MediaMonitor* self, Monitorable* monitorable);
	void (*on_media_source_destroyed) (MediaMonitor* self, DataSource* source);
	void (*notify_discovery_started) (MediaMonitor* self);
	MediaMonitorDiscoveredFile (*notify_file_discovered) (MediaMonitor* self, GFile* file, GFileInfo* info, Monitorable** monitorable);
	GeeCollection* (*candidates_for_unknown_file) (MediaMonitor* self, GFile* file, GFileInfo* info, MediaMonitorDiscoveredFile* _result_);
	GFile** (*get_auxilliary_backing_files) (MediaMonitor* self, Monitorable* monitorable, int* result_length1);
	void (*update_backing_file_info) (MediaMonitor* self, Monitorable* monitorable, GFile* file, GFileInfo* info);
	void (*notify_discovery_completing) (MediaMonitor* self);
	gboolean (*is_file_represented) (MediaMonitor* self, GFile* file);
	gboolean (*notify_file_created) (MediaMonitor* self, GFile* file, GFileInfo* info);
	gboolean (*notify_file_moved) (MediaMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
	gboolean (*notify_file_altered) (MediaMonitor* self, GFile* file);
	gboolean (*notify_file_attributes_altered) (MediaMonitor* self, GFile* file);
	gboolean (*notify_file_alteration_completed) (MediaMonitor* self, GFile* file, GFileInfo* info);
	gboolean (*notify_file_deleted) (MediaMonitor* self, GFile* file);
	void (*process_updates) (MediaMonitor* self, GeeCollection* all_updates, TransactionController* controller, gint* op_count, GError** error);
};

struct _PhotoMonitor {
	MediaMonitor parent_instance;
	PhotoMonitorPrivate * priv;
};

struct _PhotoMonitorClass {
	MediaMonitorClass parent_class;
};

struct _PhotoMonitorPrivate {
	Workers* workers;
	GeeArrayList* matched_editables;
	GeeArrayList* matched_developments;
	GeeHashMap* master_reimport_pending;
	GeeHashMap* editable_reimport_pending;
	GeeHashMap* raw_developments_reimport_pending;
};

typedef enum  {
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_UNKNOWN,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER
} LibraryPhotoSourceCollectionState;

typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

struct _BackingPhotoID {
	gint64 id;
};

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

struct _Dimensions {
	gint width;
	gint height;
};

typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

struct _BackingPhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackingPhotoRowPrivate * priv;
	BackingPhotoID id;
	time_t time_created;
	gchar* filepath;
	gint64 filesize;
	time_t timestamp;
	PhotoFileFormat file_format;
	Dimensions dim;
	Orientation original_orientation;
};

struct _BackingPhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (BackingPhotoRow *self);
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()
typedef enum  {
	BACKGROUND_JOB_JOB_PRIORITY_HIGHEST = 100,
	BACKGROUND_JOB_JOB_PRIORITY_HIGH = 75,
	BACKGROUND_JOB_JOB_PRIORITY_NORMAL = 50,
	BACKGROUND_JOB_JOB_PRIORITY_LOW = 25,
	BACKGROUND_JOB_JOB_PRIORITY_LOWEST = 0
} BackgroundJobJobPriority;

struct _BackgroundJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackgroundJobPrivate * priv;
};

struct _BackgroundJobClass {
	GTypeClass parent_class;
	void (*finalize) (BackgroundJob *self);
	void (*execute) (BackgroundJob* self);
	BackgroundJobJobPriority (*get_priority) (BackgroundJob* self);
};

struct _PhotoMonitorReimportMasterJob {
	BackgroundJob parent_instance;
	PhotoMonitorReimportMasterJobPrivate * priv;
	LibraryPhoto* photo;
	PhotoReimportMasterState* reimport_state;
	gboolean mark_online;
	GError* err;
};

struct _PhotoMonitorReimportMasterJobClass {
	BackgroundJobClass parent_class;
};

struct _PhotoMonitorReimportEditableJob {
	BackgroundJob parent_instance;
	PhotoMonitorReimportEditableJobPrivate * priv;
	LibraryPhoto* photo;
	PhotoReimportEditableState* state;
	gboolean success;
	GError* err;
};

struct _PhotoMonitorReimportEditableJobClass {
	BackgroundJobClass parent_class;
};

struct _PhotoMonitorReimportRawDevelopmentJob {
	BackgroundJob parent_instance;
	PhotoMonitorReimportRawDevelopmentJobPrivate * priv;
	LibraryPhoto* photo;
	PhotoReimportRawDevelopmentState* state;
	gboolean success;
	GError* err;
};

struct _PhotoMonitorReimportRawDevelopmentJobClass {
	BackgroundJobClass parent_class;
};

typedef void (*CompletionCallback) (BackgroundJob* job, void* user_data);
typedef void (*CancellationCallback) (BackgroundJob* job, void* user_data);

static gpointer photo_updates_parent_class = NULL;
static gpointer photo_monitor_parent_class = NULL;
extern LibraryPhotoSourceCollection* library_photo_global;
static gpointer photo_monitor_reimport_master_job_parent_class = NULL;
static gpointer photo_monitor_reimport_editable_job_parent_class = NULL;
static gpointer photo_monitor_reimport_raw_development_job_parent_class = NULL;

gpointer monitorable_updates_ref (gpointer instance);
void monitorable_updates_unref (gpointer instance);
GParamSpec* param_spec_monitorable_updates (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_monitorable_updates (GValue* value, gpointer v_object);
void value_take_monitorable_updates (GValue* value, gpointer v_object);
gpointer value_get_monitorable_updates (const GValue* value);
GType monitorable_updates_get_type (void) G_GNUC_CONST;
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType monitorable_get_type (void) G_GNUC_CONST;
GType photo_updates_get_type (void) G_GNUC_CONST;
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType library_photo_get_type (void) G_GNUC_CONST;
enum  {
	PHOTO_UPDATES_DUMMY_PROPERTY
};
PhotoUpdates* photo_updates_new (LibraryPhoto* photo);
PhotoUpdates* photo_updates_construct (GType object_type, LibraryPhoto* photo);
MonitorableUpdates* monitorable_updates_new (Monitorable* monitorable);
MonitorableUpdates* monitorable_updates_construct (GType object_type, Monitorable* monitorable);
static void photo_updates_real_mark_offline (MonitorableUpdates* base);
void monitorable_updates_mark_offline (MonitorableUpdates* self);
gboolean photo_updates_is_reimport_master (PhotoUpdates* self);
gboolean photo_updates_is_reimport_editable (PhotoUpdates* self);
GFile* photo_updates_get_editable_file (PhotoUpdates* self);
GFileInfo* photo_updates_get_editable_file_info (PhotoUpdates* self);
GeeCollection* photo_updates_get_raw_developer_files (PhotoUpdates* self);
static gboolean photo_updates_real_is_in_alteration (MonitorableUpdates* base);
gboolean monitorable_updates_is_in_alteration (MonitorableUpdates* self);
gboolean photo_updates_is_revert_to_master (PhotoUpdates* self);
void photo_updates_set_editable_file (PhotoUpdates* self, GFile* file);
static void photo_updates_real_set_editable_file (PhotoUpdates* self, GFile* file);
void photo_updates_set_editable_file_info (PhotoUpdates* self, GFileInfo* info);
static void photo_updates_real_set_editable_file_info (PhotoUpdates* self, GFileInfo* info);
void photo_updates_set_editable_file_info_altered (PhotoUpdates* self, gboolean altered);
static void photo_updates_real_set_editable_file_info_altered (PhotoUpdates* self, gboolean altered);
void photo_updates_set_editable_in_alteration (PhotoUpdates* self, gboolean in_alteration);
static void photo_updates_real_set_editable_in_alteration (PhotoUpdates* self, gboolean in_alteration);
void photo_updates_set_raw_development_in_alteration (PhotoUpdates* self, gboolean in_alteration);
static void photo_updates_real_set_raw_development_in_alteration (PhotoUpdates* self, gboolean in_alteration);
void photo_updates_set_raw_developer_file_info_altered (PhotoUpdates* self, gboolean altered);
static void photo_updates_real_set_raw_developer_file_info_altered (PhotoUpdates* self, gboolean altered);
void photo_updates_set_revert_to_master (PhotoUpdates* self, gboolean revert);
static void photo_updates_real_set_revert_to_master (PhotoUpdates* self, gboolean revert);
void photo_updates_add_raw_developer_file (PhotoUpdates* self, GFile* file);
static void photo_updates_real_add_raw_developer_file (PhotoUpdates* self, GFile* file);
void photo_updates_clear_raw_developer_files (PhotoUpdates* self);
static void photo_updates_real_clear_raw_developer_files (PhotoUpdates* self);
void photo_updates_set_reimport_master (PhotoUpdates* self, gboolean reimport);
static void photo_updates_real_set_reimport_master (PhotoUpdates* self, gboolean reimport);
void monitorable_updates_mark_online (MonitorableUpdates* self);
void photo_updates_set_reimport_editable (PhotoUpdates* self, gboolean reimport);
static void photo_updates_real_set_reimport_editable (PhotoUpdates* self, gboolean reimport);
gboolean monitorable_updates_is_set_offline (MonitorableUpdates* self);
void photo_updates_set_reimport_raw_developments (PhotoUpdates* self, gboolean reimport);
static void photo_updates_real_set_reimport_raw_developments (PhotoUpdates* self, gboolean reimport);
static gboolean photo_updates_real_is_all_updated (MonitorableUpdates* base);
gboolean monitorable_updates_is_all_updated (MonitorableUpdates* self);
static void photo_updates_finalize (MonitorableUpdates* obj);
GType media_monitor_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType media_source_collection_get_type (void) G_GNUC_CONST;
GType media_monitor_discovered_file_get_type (void) G_GNUC_CONST;
gpointer transaction_controller_ref (gpointer instance);
void transaction_controller_unref (gpointer instance);
GParamSpec* param_spec_transaction_controller (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_transaction_controller (GValue* value, gpointer v_object);
void value_take_transaction_controller (GValue* value, gpointer v_object);
gpointer value_get_transaction_controller (const GValue* value);
GType transaction_controller_get_type (void) G_GNUC_CONST;
GType photo_monitor_get_type (void) G_GNUC_CONST;
gpointer workers_ref (gpointer instance);
void workers_unref (gpointer instance);
GParamSpec* param_spec_workers (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_workers (GValue* value, gpointer v_object);
void value_take_workers (GValue* value, gpointer v_object);
gpointer value_get_workers (const GValue* value);
GType workers_get_type (void) G_GNUC_CONST;
gpointer background_job_ref (gpointer instance);
void background_job_unref (gpointer instance);
GParamSpec* param_spec_background_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_background_job (GValue* value, gpointer v_object);
void value_take_background_job (GValue* value, gpointer v_object);
gpointer value_get_background_job (const GValue* value);
GType background_job_get_type (void) G_GNUC_CONST;
static GType photo_monitor_reimport_master_job_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType photo_monitor_reimport_editable_job_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType photo_monitor_reimport_raw_development_job_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define PHOTO_MONITOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PHOTO_MONITOR, PhotoMonitorPrivate))
enum  {
	PHOTO_MONITOR_DUMMY_PROPERTY
};
#define PHOTO_MONITOR_MAX_REIMPORT_JOBS_PER_CYCLE 20
#define PHOTO_MONITOR_MAX_REVERTS_PER_CYCLE 5
PhotoMonitor* photo_monitor_new (Workers* workers, GCancellable* cancellable);
PhotoMonitor* photo_monitor_construct (GType object_type, Workers* workers, GCancellable* cancellable);
GType library_photo_source_collection_get_type (void) G_GNUC_CONST;
MediaMonitor* media_monitor_construct (GType object_type, MediaSourceCollection* sources, GCancellable* cancellable);
static MonitorableUpdates* photo_monitor_real_create_updates (MediaMonitor* base, Monitorable* monitorable);
static MediaSourceCollection* photo_monitor_real_get_media_source_collection (MediaMonitor* base);
static gboolean photo_monitor_real_is_file_represented (MediaMonitor* base, GFile* file);
GType library_photo_source_collection_state_get_type (void) G_GNUC_CONST;
static LibraryPhoto* photo_monitor_get_photo_state_by_file (PhotoMonitor* self, GFile* file, LibraryPhotoSourceCollectionState* state);
static void photo_monitor_real_close (MediaMonitor* base);
void background_job_cancel (BackgroundJob* self);
void media_monitor_close (MediaMonitor* self);
static void photo_monitor_cancel_reimports (PhotoMonitor* self, LibraryPhoto* photo);
static MediaMonitorDiscoveredFile photo_monitor_real_notify_file_discovered (MediaMonitor* base, GFile* file, GFileInfo* info, Monitorable** monitorable);
static GeeCollection* photo_monitor_real_candidates_for_unknown_file (MediaMonitor* base, GFile* file, GFileInfo* info, MediaMonitorDiscoveredFile* _result_);
void library_photo_source_collection_fetch_by_matching_backing (LibraryPhotoSourceCollection* self, GFileInfo* info, GeeCollection* matches_master, GeeCollection* matches_editable, GeeCollection* matched_development);
gchar* data_object_to_string (DataObject* self);
gboolean photo_does_editable_exist (Photo* self);
void photo_revert_to_master (Photo* self, gboolean notify);
void photo_monitor_update_editable_file (PhotoMonitor* self, LibraryPhoto* photo, GFile* file);
void photo_monitor_update_raw_development_file (PhotoMonitor* self, LibraryPhoto* photo, GFile* file);
static GFile** photo_monitor_real_get_auxilliary_backing_files (MediaMonitor* base, Monitorable* monitorable, int* result_length1);
gboolean photo_has_editable (Photo* self);
GFile* photo_get_editable_file (Photo* self);
static void _vala_array_add336 (GFile*** array, int* length, int* size, GFile* value);
GeeCollection* photo_get_raw_developer_files (Photo* self);
static void _vala_array_add337 (GFile*** array, int* length, int* size, GFile* value);
static GFile** _vala_array_dup32 (GFile** self, int length);
static void photo_monitor_real_update_backing_file_info (MediaMonitor* base, Monitorable* monitorable, GFile* file, GFileInfo* info);
GFile* media_monitor_get_master_file (MediaMonitor* self, Monitorable* monitorable);
static void photo_monitor_check_for_master_changes (PhotoMonitor* self, LibraryPhoto* photo, GFileInfo* info);
GFile* photo_monitor_get_editable_file (PhotoMonitor* self, LibraryPhoto* photo);
static void photo_monitor_check_for_editable_changes (PhotoMonitor* self, LibraryPhoto* photo, GFileInfo* info);
GeeCollection* photo_monitor_get_raw_development_files (PhotoMonitor* self, LibraryPhoto* photo);
static void photo_monitor_check_for_raw_development_changes (PhotoMonitor* self, LibraryPhoto* photo, GFileInfo* info);
static void photo_monitor_real_notify_discovery_completing (MediaMonitor* base);
gpointer backing_photo_row_ref (gpointer instance);
void backing_photo_row_unref (gpointer instance);
GParamSpec* param_spec_backing_photo_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_backing_photo_row (GValue* value, gpointer v_object);
void value_take_backing_photo_row (GValue* value, gpointer v_object);
gpointer value_get_backing_photo_row (const GValue* value);
GType backing_photo_row_get_type (void) G_GNUC_CONST;
BackingPhotoRow* photo_get_master_photo_row (Photo* self);
gboolean backing_photo_row_matches_file_info (BackingPhotoRow* self, GFileInfo* info);
gboolean backing_photo_row_is_touched (BackingPhotoRow* self, GFileInfo* info);
void media_monitor_update_master_file_info_altered (MediaMonitor* self, Monitorable* monitorable);
void media_monitor_update_master_file_alterations_completed (MediaMonitor* self, Monitorable* monitorable, GFileInfo* info);
void photo_monitor_update_reimport_master (PhotoMonitor* self, LibraryPhoto* photo);
void photo_monitor_update_revert_to_master (PhotoMonitor* self, LibraryPhoto* photo);
BackingPhotoRow* photo_get_editable_photo_row (Photo* self);
void photo_monitor_update_editable_file_info_altered (PhotoMonitor* self, LibraryPhoto* photo);
void photo_monitor_update_editable_file_alterations_completed (PhotoMonitor* self, LibraryPhoto* photo, GFileInfo* info);
void photo_monitor_update_reimport_editable (PhotoMonitor* self, LibraryPhoto* photo);
GType raw_developer_get_type (void) G_GNUC_CONST;
void photo_set_raw_developer (Photo* self, RawDeveloper d);
GeeCollection* photo_get_raw_development_photo_rows (Photo* self);
GType backing_photo_id_get_type (void) G_GNUC_CONST;
BackingPhotoID* backing_photo_id_dup (const BackingPhotoID* self);
void backing_photo_id_free (BackingPhotoID* self);
GType photo_file_format_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType orientation_get_type (void) G_GNUC_CONST;
void photo_monitor_update_raw_development_file_info_altered (PhotoMonitor* self, LibraryPhoto* photo);
void photo_monitor_update_raw_development_file_alterations_completed (PhotoMonitor* self, LibraryPhoto* photo);
void photo_monitor_update_reimport_raw_developments (PhotoMonitor* self, LibraryPhoto* photo);
static gboolean photo_monitor_real_notify_file_created (MediaMonitor* base, GFile* file, GFileInfo* info);
const gchar* library_photo_source_collection_state_to_string (LibraryPhotoSourceCollectionState self);
void media_monitor_mdbg (const gchar* msg);
void media_monitor_update_online (MediaMonitor* self, Monitorable* monitorable);
static gboolean photo_monitor_real_notify_file_moved (MediaMonitor* base, GFile* old_file, GFile* new_file, GFileInfo* info);
void media_monitor_update_master_file (MediaMonitor* self, Monitorable* monitorable, GFile* file);
void media_monitor_update_offline (MediaMonitor* self, Monitorable* monitorable);
static gboolean photo_monitor_real_notify_file_altered (MediaMonitor* base, GFile* file);
void media_monitor_update_master_file_in_alteration (MediaMonitor* self, Monitorable* monitorable, gboolean in_alteration);
void photo_monitor_update_editable_file_in_alteration (PhotoMonitor* self, LibraryPhoto* photo, gboolean in_alteration);
void photo_monitor_update_raw_development_file_in_alteration (PhotoMonitor* self, LibraryPhoto* photo, gboolean in_alteration);
static gboolean photo_monitor_real_notify_file_attributes_altered (MediaMonitor* base, GFile* file);
static gboolean photo_monitor_real_notify_file_alteration_completed (MediaMonitor* base, GFile* file, GFileInfo* info);
static gboolean photo_monitor_real_notify_file_deleted (MediaMonitor* base, GFile* file);
static void photo_monitor_real_on_media_source_destroyed (MediaMonitor* base, DataSource* source);
void media_monitor_on_media_source_destroyed (MediaMonitor* self, DataSource* source);
gboolean media_monitor_has_pending_updates (MediaMonitor* self);
GeeCollection* media_monitor_get_monitorables (MediaMonitor* self);
PhotoUpdates* photo_monitor_get_existing_photo_updates (PhotoMonitor* self, LibraryPhoto* photo);
GFile* monitorable_updates_get_master_file (MonitorableUpdates* self);
GFile* media_source_get_master_file (MediaSource* self);
LibraryPhoto* library_photo_source_collection_get_state_by_file (LibraryPhotoSourceCollection* self, GFile* file, LibraryPhotoSourceCollectionState* state);
PhotoUpdates* photo_monitor_fetch_photo_updates (PhotoMonitor* self, LibraryPhoto* photo);
MonitorableUpdates* media_monitor_fetch_updates (MediaMonitor* self, Monitorable* monitorable);
MonitorableUpdates* media_monitor_get_existing_updates (MediaMonitor* self, Monitorable* monitorable);
static void photo_monitor_real_process_updates (MediaMonitor* base, GeeCollection* all_updates, TransactionController* controller, gint* op_count, GError** error);
void media_monitor_process_updates (MediaMonitor* self, GeeCollection* all_updates, TransactionController* controller, gint* op_count, GError** error);
#define MEDIA_MONITOR_MAX_OPERATIONS_PER_CYCLE 100
GQuark database_error_quark (void);
void photo_set_many_editable_file (GeeMap* map, GError** error);
void app_window_database_error (GError* err);
void photo_update_many_editable_timestamps (GeeMap* map, GError** error);
static PhotoMonitorReimportMasterJob* photo_monitor_reimport_master_job_new (PhotoMonitor* owner, LibraryPhoto* photo);
static PhotoMonitorReimportMasterJob* photo_monitor_reimport_master_job_construct (GType object_type, PhotoMonitor* owner, LibraryPhoto* photo);
void workers_enqueue (Workers* self, BackgroundJob* job);
static PhotoMonitorReimportEditableJob* photo_monitor_reimport_editable_job_new (PhotoMonitor* owner, LibraryPhoto* photo);
static PhotoMonitorReimportEditableJob* photo_monitor_reimport_editable_job_construct (GType object_type, PhotoMonitor* owner, LibraryPhoto* photo);
static PhotoMonitorReimportRawDevelopmentJob* photo_monitor_reimport_raw_development_job_new (PhotoMonitor* owner, LibraryPhoto* photo);
static PhotoMonitorReimportRawDevelopmentJob* photo_monitor_reimport_raw_development_job_construct (GType object_type, PhotoMonitor* owner, LibraryPhoto* photo);
static void photo_monitor_on_master_reimported (PhotoMonitor* self, BackgroundJob* j);
GType background_job_job_priority_get_type (void) G_GNUC_CONST;
gpointer photo_reimport_master_state_ref (gpointer instance);
void photo_reimport_master_state_unref (gpointer instance);
GParamSpec* photo_param_spec_reimport_master_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void photo_value_set_reimport_master_state (GValue* value, gpointer v_object);
void photo_value_take_reimport_master_state (GValue* value, gpointer v_object);
gpointer photo_value_get_reimport_master_state (const GValue* value);
GType photo_reimport_master_state_get_type (void) G_GNUC_CONST;
void photo_finish_reimport_master (Photo* self, PhotoReimportMasterState* state, GError** error);
gboolean media_source_is_offline (MediaSource* self);
static void photo_monitor_on_master_reimport_cancelled (PhotoMonitor* self, BackgroundJob* j);
static void photo_monitor_on_editable_reimported (PhotoMonitor* self, BackgroundJob* j);
gpointer photo_reimport_editable_state_ref (gpointer instance);
void photo_reimport_editable_state_unref (gpointer instance);
GParamSpec* photo_param_spec_reimport_editable_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void photo_value_set_reimport_editable_state (GValue* value, gpointer v_object);
void photo_value_take_reimport_editable_state (GValue* value, gpointer v_object);
gpointer photo_value_get_reimport_editable_state (const GValue* value);
GType photo_reimport_editable_state_get_type (void) G_GNUC_CONST;
void photo_finish_reimport_editable (Photo* self, PhotoReimportEditableState* state, GError** error);
static void photo_monitor_on_editable_reimport_cancelled (PhotoMonitor* self, BackgroundJob* j);
static void photo_monitor_on_raw_development_reimported (PhotoMonitor* self, BackgroundJob* j);
gpointer photo_reimport_raw_development_state_ref (gpointer instance);
void photo_reimport_raw_development_state_unref (gpointer instance);
GParamSpec* photo_param_spec_reimport_raw_development_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void photo_value_set_reimport_raw_development_state (GValue* value, gpointer v_object);
void photo_value_take_reimport_raw_development_state (GValue* value, gpointer v_object);
gpointer photo_value_get_reimport_raw_development_state (const GValue* value);
GType photo_reimport_raw_development_state_get_type (void) G_GNUC_CONST;
void photo_finish_reimport_raw_development (Photo* self, PhotoReimportRawDevelopmentState* state, GError** error);
static void photo_monitor_on_raw_development_reimport_cancelled (PhotoMonitor* self, BackgroundJob* j);
enum  {
	PHOTO_MONITOR_REIMPORT_MASTER_JOB_DUMMY_PROPERTY
};
static void _photo_monitor_on_master_reimported_completion_callback (BackgroundJob* job, gpointer self);
static void _photo_monitor_on_master_reimport_cancelled_cancellation_callback (BackgroundJob* job, gpointer self);
gpointer abstract_semaphore_ref (gpointer instance);
void abstract_semaphore_unref (gpointer instance);
GParamSpec* param_spec_abstract_semaphore (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_abstract_semaphore (GValue* value, gpointer v_object);
void value_take_abstract_semaphore (GValue* value, gpointer v_object);
gpointer value_get_abstract_semaphore (const GValue* value);
GType abstract_semaphore_get_type (void) G_GNUC_CONST;
BackgroundJob* background_job_construct (GType object_type, GObject* owner, CompletionCallback callback, void* callback_target, GCancellable* cancellable, CancellationCallback cancellation, void* cancellation_target, AbstractSemaphore* completion_semaphore);
static void photo_monitor_reimport_master_job_real_execute (BackgroundJob* base);
gboolean photo_prepare_for_reimport_master (Photo* self, PhotoReimportMasterState** reimport_state, GError** error);
static void photo_monitor_reimport_master_job_finalize (BackgroundJob* obj);
enum  {
	PHOTO_MONITOR_REIMPORT_EDITABLE_JOB_DUMMY_PROPERTY
};
static void _photo_monitor_on_editable_reimported_completion_callback (BackgroundJob* job, gpointer self);
static void _photo_monitor_on_editable_reimport_cancelled_cancellation_callback (BackgroundJob* job, gpointer self);
static void photo_monitor_reimport_editable_job_real_execute (BackgroundJob* base);
gboolean photo_prepare_for_reimport_editable (Photo* self, PhotoReimportEditableState** state, GError** error);
static void photo_monitor_reimport_editable_job_finalize (BackgroundJob* obj);
enum  {
	PHOTO_MONITOR_REIMPORT_RAW_DEVELOPMENT_JOB_DUMMY_PROPERTY
};
static void _photo_monitor_on_raw_development_reimported_completion_callback (BackgroundJob* job, gpointer self);
static void _photo_monitor_on_raw_development_reimport_cancelled_cancellation_callback (BackgroundJob* job, gpointer self);
static void photo_monitor_reimport_raw_development_job_real_execute (BackgroundJob* base);
gboolean photo_prepare_for_reimport_raw_development (Photo* self, PhotoReimportRawDevelopmentState** state, GError** error);
static void photo_monitor_reimport_raw_development_job_finalize (BackgroundJob* obj);
static void photo_monitor_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
#line 25 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return self ? g_object_ref (self) : NULL;
#line 883 "PhotoMonitor.c"
}


PhotoUpdates* photo_updates_construct (GType object_type, LibraryPhoto* photo) {
	PhotoUpdates* self = NULL;
	LibraryPhoto* _tmp0_ = NULL;
	LibraryPhoto* _tmp1_ = NULL;
	LibraryPhoto* _tmp2_ = NULL;
#line 22 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
#line 23 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo;
#line 23 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = (PhotoUpdates*) monitorable_updates_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MONITORABLE, Monitorable));
#line 25 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo;
#line 25 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 25 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->photo);
#line 25 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->photo = _tmp2_;
#line 22 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return self;
#line 908 "PhotoMonitor.c"
}


PhotoUpdates* photo_updates_new (LibraryPhoto* photo) {
#line 22 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return photo_updates_construct (TYPE_PHOTO_UPDATES, photo);
#line 915 "PhotoMonitor.c"
}


static void photo_updates_real_mark_offline (MonitorableUpdates* base) {
	PhotoUpdates * self;
#line 28 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_UPDATES, PhotoUpdates);
#line 29 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	MONITORABLE_UPDATES_CLASS (photo_updates_parent_class)->mark_offline (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
#line 31 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->reimport_master = FALSE;
#line 32 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->reimport_editable = FALSE;
#line 33 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->reimport_raw_developments = FALSE;
#line 931 "PhotoMonitor.c"
}


gboolean photo_updates_is_reimport_master (PhotoUpdates* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 36 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_UPDATES (self), FALSE);
#line 37 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->reimport_master;
#line 37 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp0_;
#line 37 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 946 "PhotoMonitor.c"
}


gboolean photo_updates_is_reimport_editable (PhotoUpdates* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 40 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_UPDATES (self), FALSE);
#line 41 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->reimport_editable;
#line 41 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp0_;
#line 41 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 961 "PhotoMonitor.c"
}


GFile* photo_updates_get_editable_file (PhotoUpdates* self) {
	GFile* result = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
#line 44 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_UPDATES (self), NULL);
#line 45 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->editable_file;
#line 45 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 45 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp1_;
#line 45 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 979 "PhotoMonitor.c"
}


GFileInfo* photo_updates_get_editable_file_info (PhotoUpdates* self) {
	GFileInfo* result = NULL;
	GFileInfo* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
#line 48 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_UPDATES (self), NULL);
#line 49 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->editable_file_info;
#line 49 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 49 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp1_;
#line 49 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 997 "PhotoMonitor.c"
}


GeeCollection* photo_updates_get_raw_developer_files (PhotoUpdates* self) {
	GeeCollection* result = NULL;
	GeeCollection* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
#line 52 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_UPDATES (self), NULL);
#line 53 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->developer_files;
#line 53 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 53 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp1_;
#line 53 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 1015 "PhotoMonitor.c"
}


static gboolean photo_updates_real_is_in_alteration (MonitorableUpdates* base) {
	PhotoUpdates * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 56 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_UPDATES, PhotoUpdates);
#line 57 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = MONITORABLE_UPDATES_CLASS (photo_updates_parent_class)->is_in_alteration (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
#line 57 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp1_) {
#line 57 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = TRUE;
#line 1032 "PhotoMonitor.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 57 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp2_ = self->editable_in_alteration;
#line 57 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = _tmp2_;
#line 1039 "PhotoMonitor.c"
	}
#line 57 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp0_;
#line 57 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 1045 "PhotoMonitor.c"
}


gboolean photo_updates_is_revert_to_master (PhotoUpdates* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 60 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_UPDATES (self), FALSE);
#line 61 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->revert_to_master;
#line 61 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp0_;
#line 61 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 1060 "PhotoMonitor.c"
}


static void photo_updates_real_set_editable_file (PhotoUpdates* self, GFile* file) {
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
#line 64 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail ((file == NULL) || G_IS_FILE (file));
#line 66 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = file;
#line 66 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp1_ != NULL) {
#line 1075 "PhotoMonitor.c"
		gboolean _tmp2_ = FALSE;
#line 66 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp2_ = self->revert_to_master;
#line 66 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = _tmp2_;
#line 1081 "PhotoMonitor.c"
	} else {
#line 66 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = FALSE;
#line 1085 "PhotoMonitor.c"
	}
#line 66 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp0_) {
#line 67 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 1091 "PhotoMonitor.c"
	}
#line 69 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = file;
#line 69 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 69 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->editable_file);
#line 69 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->editable_file = _tmp4_;
#line 1101 "PhotoMonitor.c"
}


void photo_updates_set_editable_file (PhotoUpdates* self, GFile* file) {
#line 64 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 64 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->set_editable_file (self, file);
#line 1110 "PhotoMonitor.c"
}


static void photo_updates_real_set_editable_file_info (PhotoUpdates* self, GFileInfo* info) {
	gboolean _tmp0_ = FALSE;
	GFileInfo* _tmp1_ = NULL;
	GFileInfo* _tmp3_ = NULL;
	GFileInfo* _tmp4_ = NULL;
	GFileInfo* _tmp5_ = NULL;
#line 72 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail ((info == NULL) || G_IS_FILE_INFO (info));
#line 74 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = info;
#line 74 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp1_ != NULL) {
#line 1126 "PhotoMonitor.c"
		gboolean _tmp2_ = FALSE;
#line 74 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp2_ = self->revert_to_master;
#line 74 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = _tmp2_;
#line 1132 "PhotoMonitor.c"
	} else {
#line 74 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = FALSE;
#line 1136 "PhotoMonitor.c"
	}
#line 74 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp0_) {
#line 75 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 1142 "PhotoMonitor.c"
	}
#line 77 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = info;
#line 77 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 77 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->editable_file_info);
#line 77 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->editable_file_info = _tmp4_;
#line 78 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = info;
#line 78 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp5_ == NULL) {
#line 79 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->editable_file_info_altered = FALSE;
#line 1158 "PhotoMonitor.c"
	}
}


void photo_updates_set_editable_file_info (PhotoUpdates* self, GFileInfo* info) {
#line 72 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 72 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->set_editable_file_info (self, info);
#line 1168 "PhotoMonitor.c"
}


static void photo_updates_real_set_editable_file_info_altered (PhotoUpdates* self, gboolean altered) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 84 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = altered;
#line 84 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp1_) {
#line 1180 "PhotoMonitor.c"
		gboolean _tmp2_ = FALSE;
#line 84 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp2_ = self->revert_to_master;
#line 84 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = _tmp2_;
#line 1186 "PhotoMonitor.c"
	} else {
#line 84 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = FALSE;
#line 1190 "PhotoMonitor.c"
	}
#line 84 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp0_) {
#line 85 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 1196 "PhotoMonitor.c"
	}
#line 87 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = altered;
#line 87 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->editable_file_info_altered = _tmp3_;
#line 1202 "PhotoMonitor.c"
}


void photo_updates_set_editable_file_info_altered (PhotoUpdates* self, gboolean altered) {
#line 82 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 82 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->set_editable_file_info_altered (self, altered);
#line 1211 "PhotoMonitor.c"
}


static void photo_updates_real_set_editable_in_alteration (PhotoUpdates* self, gboolean in_alteration) {
	gboolean _tmp0_ = FALSE;
#line 91 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = in_alteration;
#line 91 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->editable_in_alteration = _tmp0_;
#line 1221 "PhotoMonitor.c"
}


void photo_updates_set_editable_in_alteration (PhotoUpdates* self, gboolean in_alteration) {
#line 90 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 90 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->set_editable_in_alteration (self, in_alteration);
#line 1230 "PhotoMonitor.c"
}


static void photo_updates_real_set_raw_development_in_alteration (PhotoUpdates* self, gboolean in_alteration) {
	gboolean _tmp0_ = FALSE;
#line 95 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = in_alteration;
#line 95 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->raw_development_in_alteration = _tmp0_;
#line 1240 "PhotoMonitor.c"
}


void photo_updates_set_raw_development_in_alteration (PhotoUpdates* self, gboolean in_alteration) {
#line 94 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 94 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->set_raw_development_in_alteration (self, in_alteration);
#line 1249 "PhotoMonitor.c"
}


static void photo_updates_real_set_raw_developer_file_info_altered (PhotoUpdates* self, gboolean altered) {
	gboolean _tmp0_ = FALSE;
#line 99 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = altered;
#line 99 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->raw_developer_file_info_altered = _tmp0_;
#line 1259 "PhotoMonitor.c"
}


void photo_updates_set_raw_developer_file_info_altered (PhotoUpdates* self, gboolean altered) {
#line 98 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 98 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->set_raw_developer_file_info_altered (self, altered);
#line 1268 "PhotoMonitor.c"
}


static void photo_updates_real_set_revert_to_master (PhotoUpdates* self, gboolean revert) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 103 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = revert;
#line 103 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp0_) {
#line 105 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->reimport_editable = FALSE;
#line 106 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (self->editable_file);
#line 106 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->editable_file = NULL;
#line 107 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (self->editable_file_info);
#line 107 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->editable_file_info = NULL;
#line 1289 "PhotoMonitor.c"
	}
#line 110 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = revert;
#line 110 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->revert_to_master = _tmp1_;
#line 1295 "PhotoMonitor.c"
}


void photo_updates_set_revert_to_master (PhotoUpdates* self, gboolean revert) {
#line 102 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 102 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->set_revert_to_master (self, revert);
#line 1304 "PhotoMonitor.c"
}


static void photo_updates_real_add_raw_developer_file (PhotoUpdates* self, GFile* file) {
	GeeCollection* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
#line 113 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 114 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->developer_files;
#line 114 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = file;
#line 114 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	gee_collection_add (_tmp0_, _tmp1_);
#line 1319 "PhotoMonitor.c"
}


void photo_updates_add_raw_developer_file (PhotoUpdates* self, GFile* file) {
#line 113 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 113 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->add_raw_developer_file (self, file);
#line 1328 "PhotoMonitor.c"
}


static void photo_updates_real_clear_raw_developer_files (PhotoUpdates* self) {
	GeeCollection* _tmp0_ = NULL;
#line 118 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->developer_files;
#line 118 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	gee_collection_clear (_tmp0_);
#line 1338 "PhotoMonitor.c"
}


void photo_updates_clear_raw_developer_files (PhotoUpdates* self) {
#line 117 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 117 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->clear_raw_developer_files (self);
#line 1347 "PhotoMonitor.c"
}


static void photo_updates_real_set_reimport_master (PhotoUpdates* self, gboolean reimport) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 122 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = reimport;
#line 122 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->reimport_master = _tmp0_;
#line 124 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = reimport;
#line 124 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp1_) {
#line 125 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		monitorable_updates_mark_online (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
#line 1364 "PhotoMonitor.c"
	}
}


void photo_updates_set_reimport_master (PhotoUpdates* self, gboolean reimport) {
#line 121 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 121 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->set_reimport_master (self, reimport);
#line 1374 "PhotoMonitor.c"
}


static void photo_updates_real_set_reimport_editable (PhotoUpdates* self, gboolean reimport) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp5_ = FALSE;
#line 130 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = reimport;
#line 130 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp1_) {
#line 1386 "PhotoMonitor.c"
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
#line 130 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = self->revert_to_master;
#line 130 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (_tmp3_) {
#line 130 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp2_ = TRUE;
#line 1395 "PhotoMonitor.c"
		} else {
			gboolean _tmp4_ = FALSE;
#line 130 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp4_ = monitorable_updates_is_set_offline (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
#line 130 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp2_ = _tmp4_;
#line 1402 "PhotoMonitor.c"
		}
#line 130 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = _tmp2_;
#line 1406 "PhotoMonitor.c"
	} else {
#line 130 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = FALSE;
#line 1410 "PhotoMonitor.c"
	}
#line 130 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp0_) {
#line 131 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 1416 "PhotoMonitor.c"
	}
#line 133 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = reimport;
#line 133 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->reimport_editable = _tmp5_;
#line 1422 "PhotoMonitor.c"
}


void photo_updates_set_reimport_editable (PhotoUpdates* self, gboolean reimport) {
#line 128 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 128 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->set_reimport_editable (self, reimport);
#line 1431 "PhotoMonitor.c"
}


static void photo_updates_real_set_reimport_raw_developments (PhotoUpdates* self, gboolean reimport) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 137 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = reimport;
#line 137 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->reimport_raw_developments = _tmp0_;
#line 139 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = reimport;
#line 139 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp1_) {
#line 140 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		monitorable_updates_mark_online (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
#line 1448 "PhotoMonitor.c"
	}
}


void photo_updates_set_reimport_raw_developments (PhotoUpdates* self, gboolean reimport) {
#line 136 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_UPDATES (self));
#line 136 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	PHOTO_UPDATES_GET_CLASS (self)->set_reimport_raw_developments (self, reimport);
#line 1458 "PhotoMonitor.c"
}


static gboolean photo_updates_real_is_all_updated (MonitorableUpdates* base) {
	PhotoUpdates * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
#line 143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_UPDATES, PhotoUpdates);
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp9_ = MONITORABLE_UPDATES_CLASS (photo_updates_parent_class)->is_all_updated (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp9_) {
#line 1481 "PhotoMonitor.c"
		gboolean _tmp10_ = FALSE;
#line 145 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp10_ = self->reimport_master;
#line 145 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp8_ = _tmp10_ == FALSE;
#line 1487 "PhotoMonitor.c"
	} else {
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp8_ = FALSE;
#line 1491 "PhotoMonitor.c"
	}
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp8_) {
#line 1495 "PhotoMonitor.c"
		gboolean _tmp11_ = FALSE;
#line 146 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp11_ = self->reimport_editable;
#line 146 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp7_ = _tmp11_ == FALSE;
#line 1501 "PhotoMonitor.c"
	} else {
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp7_ = FALSE;
#line 1505 "PhotoMonitor.c"
	}
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp7_) {
#line 1509 "PhotoMonitor.c"
		GFile* _tmp12_ = NULL;
#line 147 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp12_ = self->editable_file;
#line 147 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp6_ = _tmp12_ == NULL;
#line 1515 "PhotoMonitor.c"
	} else {
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp6_ = FALSE;
#line 1519 "PhotoMonitor.c"
	}
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp6_) {
#line 1523 "PhotoMonitor.c"
		gboolean _tmp13_ = FALSE;
#line 148 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp13_ = self->editable_file_info_altered;
#line 148 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5_ = _tmp13_ == FALSE;
#line 1529 "PhotoMonitor.c"
	} else {
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5_ = FALSE;
#line 1533 "PhotoMonitor.c"
	}
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp5_) {
#line 1537 "PhotoMonitor.c"
		GFileInfo* _tmp14_ = NULL;
#line 149 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp14_ = self->editable_file_info;
#line 149 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp4_ = _tmp14_ == NULL;
#line 1543 "PhotoMonitor.c"
	} else {
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp4_ = FALSE;
#line 1547 "PhotoMonitor.c"
	}
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp4_) {
#line 1551 "PhotoMonitor.c"
		gboolean _tmp15_ = FALSE;
#line 150 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp15_ = self->editable_in_alteration;
#line 150 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = _tmp15_ == FALSE;
#line 1557 "PhotoMonitor.c"
	} else {
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = FALSE;
#line 1561 "PhotoMonitor.c"
	}
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp3_) {
#line 1565 "PhotoMonitor.c"
		GeeCollection* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
#line 151 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp16_ = self->developer_files;
#line 151 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp17_ = gee_collection_get_size (_tmp16_);
#line 151 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp18_ = _tmp17_;
#line 151 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp2_ = _tmp18_ == 0;
#line 1577 "PhotoMonitor.c"
	} else {
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp2_ = FALSE;
#line 1581 "PhotoMonitor.c"
	}
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp2_) {
#line 1585 "PhotoMonitor.c"
		gboolean _tmp19_ = FALSE;
#line 152 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp19_ = self->raw_developer_file_info_altered;
#line 152 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = _tmp19_ == FALSE;
#line 1591 "PhotoMonitor.c"
	} else {
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = FALSE;
#line 1595 "PhotoMonitor.c"
	}
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp1_) {
#line 1599 "PhotoMonitor.c"
		gboolean _tmp20_ = FALSE;
#line 153 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp20_ = self->revert_to_master;
#line 153 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = _tmp20_ == FALSE;
#line 1605 "PhotoMonitor.c"
	} else {
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = FALSE;
#line 1609 "PhotoMonitor.c"
	}
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp0_;
#line 144 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 1615 "PhotoMonitor.c"
}


static void photo_updates_class_init (PhotoUpdatesClass * klass) {
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MonitorableUpdatesClass *) klass)->finalize = photo_updates_finalize;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MonitorableUpdatesClass *) klass)->mark_offline = photo_updates_real_mark_offline;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MonitorableUpdatesClass *) klass)->is_in_alteration = photo_updates_real_is_in_alteration;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->set_editable_file = photo_updates_real_set_editable_file;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->set_editable_file_info = photo_updates_real_set_editable_file_info;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->set_editable_file_info_altered = photo_updates_real_set_editable_file_info_altered;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->set_editable_in_alteration = photo_updates_real_set_editable_in_alteration;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->set_raw_development_in_alteration = photo_updates_real_set_raw_development_in_alteration;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->set_raw_developer_file_info_altered = photo_updates_real_set_raw_developer_file_info_altered;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->set_revert_to_master = photo_updates_real_set_revert_to_master;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->add_raw_developer_file = photo_updates_real_add_raw_developer_file;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->clear_raw_developer_files = photo_updates_real_clear_raw_developer_files;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->set_reimport_master = photo_updates_real_set_reimport_master;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->set_reimport_editable = photo_updates_real_set_reimport_editable;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((PhotoUpdatesClass *) klass)->set_reimport_raw_developments = photo_updates_real_set_reimport_raw_developments;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MonitorableUpdatesClass *) klass)->is_all_updated = photo_updates_real_is_all_updated;
#line 1654 "PhotoMonitor.c"
}


static void photo_updates_instance_init (PhotoUpdates * self) {
	GeeArrayList* _tmp0_ = NULL;
#line 10 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->reimport_master = FALSE;
#line 11 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->reimport_editable = FALSE;
#line 12 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->reimport_raw_developments = FALSE;
#line 13 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->editable_file = NULL;
#line 14 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->editable_file_info_altered = FALSE;
#line 15 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->raw_developer_file_info_altered = FALSE;
#line 16 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->editable_file_info = NULL;
#line 17 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->editable_in_alteration = FALSE;
#line 18 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->raw_development_in_alteration = FALSE;
#line 19 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->revert_to_master = FALSE;
#line 20 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 20 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->developer_files = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
#line 1684 "PhotoMonitor.c"
}


static void photo_updates_finalize (MonitorableUpdates* obj) {
	PhotoUpdates * self;
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_UPDATES, PhotoUpdates);
#line 8 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->photo);
#line 13 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->editable_file);
#line 16 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->editable_file_info);
#line 20 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->developer_files);
#line 7 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	MONITORABLE_UPDATES_CLASS (photo_updates_parent_class)->finalize (obj);
#line 1702 "PhotoMonitor.c"
}


GType photo_updates_get_type (void) {
	static volatile gsize photo_updates_type_id__volatile = 0;
	if (g_once_init_enter (&photo_updates_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoUpdatesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_updates_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoUpdates), 0, (GInstanceInitFunc) photo_updates_instance_init, NULL };
		GType photo_updates_type_id;
		photo_updates_type_id = g_type_register_static (TYPE_MONITORABLE_UPDATES, "PhotoUpdates", &g_define_type_info, 0);
		g_once_init_leave (&photo_updates_type_id__volatile, photo_updates_type_id);
	}
	return photo_updates_type_id__volatile;
}


static gpointer _workers_ref0 (gpointer self) {
#line 240 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return self ? workers_ref (self) : NULL;
#line 1721 "PhotoMonitor.c"
}


PhotoMonitor* photo_monitor_construct (GType object_type, Workers* workers, GCancellable* cancellable) {
	PhotoMonitor * self = NULL;
	LibraryPhotoSourceCollection* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	Workers* _tmp2_ = NULL;
	Workers* _tmp3_ = NULL;
#line 237 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_WORKERS (workers), NULL);
#line 237 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_CANCELLABLE (cancellable), NULL);
#line 238 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = library_photo_global;
#line 238 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = cancellable;
#line 238 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = (PhotoMonitor*) media_monitor_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), _tmp1_);
#line 240 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = workers;
#line 240 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = _workers_ref0 (_tmp2_);
#line 240 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_workers_unref0 (self->priv->workers);
#line 240 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->priv->workers = _tmp3_;
#line 237 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return self;
#line 1751 "PhotoMonitor.c"
}


PhotoMonitor* photo_monitor_new (Workers* workers, GCancellable* cancellable) {
#line 237 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return photo_monitor_construct (TYPE_PHOTO_MONITOR, workers, cancellable);
#line 1758 "PhotoMonitor.c"
}


static MonitorableUpdates* photo_monitor_real_create_updates (MediaMonitor* base, Monitorable* monitorable) {
	PhotoMonitor * self;
	MonitorableUpdates* result = NULL;
	Monitorable* _tmp0_ = NULL;
	Monitorable* _tmp1_ = NULL;
	PhotoUpdates* _tmp2_ = NULL;
#line 243 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 243 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_MONITORABLE (monitorable), NULL);
#line 244 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = monitorable;
#line 244 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_LIBRARY_PHOTO), "monitorable is LibraryPhoto");
#line 246 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = monitorable;
#line 246 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = photo_updates_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
#line 246 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_MONITORABLE_UPDATES, MonitorableUpdates);
#line 246 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 1784 "PhotoMonitor.c"
}


static gpointer _data_collection_ref0 (gpointer self) {
#line 250 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return self ? data_collection_ref (self) : NULL;
#line 1791 "PhotoMonitor.c"
}


static MediaSourceCollection* photo_monitor_real_get_media_source_collection (MediaMonitor* base) {
	PhotoMonitor * self;
	MediaSourceCollection* result = NULL;
	LibraryPhotoSourceCollection* _tmp0_ = NULL;
	MediaSourceCollection* _tmp1_ = NULL;
#line 249 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 250 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = library_photo_global;
#line 250 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _data_collection_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 250 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp1_;
#line 250 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 1810 "PhotoMonitor.c"
}


static gboolean photo_monitor_real_is_file_represented (MediaMonitor* base, GFile* file) {
	PhotoMonitor * self;
	gboolean result = FALSE;
	LibraryPhotoSourceCollectionState state = 0;
	GFile* _tmp0_ = NULL;
	LibraryPhotoSourceCollectionState _tmp1_ = 0;
	LibraryPhoto* _tmp2_ = NULL;
	LibraryPhoto* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 253 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 253 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 255 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = file;
#line 255 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = photo_monitor_get_photo_state_by_file (self, _tmp0_, &_tmp1_);
#line 255 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	state = _tmp1_;
#line 255 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = _tmp2_;
#line 255 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = _tmp3_ != NULL;
#line 255 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (_tmp3_);
#line 255 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp4_;
#line 255 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 1843 "PhotoMonitor.c"
}


static void photo_monitor_real_close (MediaMonitor* base) {
	PhotoMonitor * self;
#line 258 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 1851 "PhotoMonitor.c"
	{
		GeeIterator* _job_it = NULL;
		GeeHashMap* _tmp0_ = NULL;
		GeeCollection* _tmp1_ = NULL;
		GeeCollection* _tmp2_ = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = self->priv->master_reimport_pending;
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap));
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp2_ = _tmp1_;
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = _tmp2_;
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5_ = _tmp4_;
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_tmp3_);
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_job_it = _tmp5_;
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		while (TRUE) {
#line 1878 "PhotoMonitor.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			PhotoMonitorReimportMasterJob* job = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			PhotoMonitorReimportMasterJob* _tmp10_ = NULL;
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp6_ = _job_it;
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (!_tmp7_) {
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				break;
#line 1893 "PhotoMonitor.c"
			}
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp8_ = _job_it;
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			job = (PhotoMonitorReimportMasterJob*) _tmp9_;
#line 260 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp10_ = job;
#line 260 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_background_job_unref0 (job);
#line 1907 "PhotoMonitor.c"
		}
#line 259 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_job_it);
#line 1911 "PhotoMonitor.c"
	}
	{
		GeeIterator* _job_it = NULL;
		GeeHashMap* _tmp11_ = NULL;
		GeeCollection* _tmp12_ = NULL;
		GeeCollection* _tmp13_ = NULL;
		GeeCollection* _tmp14_ = NULL;
		GeeIterator* _tmp15_ = NULL;
		GeeIterator* _tmp16_ = NULL;
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp11_ = self->priv->editable_reimport_pending;
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp12_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_MAP, GeeMap));
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp13_ = _tmp12_;
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp14_ = _tmp13_;
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp15_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ITERABLE, GeeIterable));
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp16_ = _tmp15_;
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_tmp14_);
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_job_it = _tmp16_;
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		while (TRUE) {
#line 1939 "PhotoMonitor.c"
			GeeIterator* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
			PhotoMonitorReimportEditableJob* job = NULL;
			GeeIterator* _tmp19_ = NULL;
			gpointer _tmp20_ = NULL;
			PhotoMonitorReimportEditableJob* _tmp21_ = NULL;
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp17_ = _job_it;
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp18_ = gee_iterator_next (_tmp17_);
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (!_tmp18_) {
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				break;
#line 1954 "PhotoMonitor.c"
			}
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp19_ = _job_it;
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp20_ = gee_iterator_get (_tmp19_);
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			job = (PhotoMonitorReimportEditableJob*) _tmp20_;
#line 263 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp21_ = job;
#line 263 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_background_job_unref0 (job);
#line 1968 "PhotoMonitor.c"
		}
#line 262 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_job_it);
#line 1972 "PhotoMonitor.c"
	}
	{
		GeeIterator* _job_it = NULL;
		GeeHashMap* _tmp22_ = NULL;
		GeeCollection* _tmp23_ = NULL;
		GeeCollection* _tmp24_ = NULL;
		GeeCollection* _tmp25_ = NULL;
		GeeIterator* _tmp26_ = NULL;
		GeeIterator* _tmp27_ = NULL;
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp22_ = self->priv->raw_developments_reimport_pending;
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp23_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_MAP, GeeMap));
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp24_ = _tmp23_;
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp25_ = _tmp24_;
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp26_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_ITERABLE, GeeIterable));
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp27_ = _tmp26_;
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_tmp25_);
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_job_it = _tmp27_;
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		while (TRUE) {
#line 2000 "PhotoMonitor.c"
			GeeIterator* _tmp28_ = NULL;
			gboolean _tmp29_ = FALSE;
			PhotoMonitorReimportRawDevelopmentJob* job = NULL;
			GeeIterator* _tmp30_ = NULL;
			gpointer _tmp31_ = NULL;
			PhotoMonitorReimportRawDevelopmentJob* _tmp32_ = NULL;
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp28_ = _job_it;
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp29_ = gee_iterator_next (_tmp28_);
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (!_tmp29_) {
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				break;
#line 2015 "PhotoMonitor.c"
			}
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp30_ = _job_it;
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp31_ = gee_iterator_get (_tmp30_);
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			job = (PhotoMonitorReimportRawDevelopmentJob*) _tmp31_;
#line 266 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp32_ = job;
#line 266 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_background_job_unref0 (job);
#line 2029 "PhotoMonitor.c"
		}
#line 265 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_job_it);
#line 2033 "PhotoMonitor.c"
	}
#line 268 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	MEDIA_MONITOR_CLASS (photo_monitor_parent_class)->close (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor));
#line 2037 "PhotoMonitor.c"
}


static void photo_monitor_cancel_reimports (PhotoMonitor* self, LibraryPhoto* photo) {
	PhotoMonitorReimportMasterJob* master_job = NULL;
	GeeHashMap* _tmp0_ = NULL;
	LibraryPhoto* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	PhotoMonitorReimportMasterJob* _tmp3_ = NULL;
	PhotoMonitorReimportEditableJob* editable_job = NULL;
	GeeHashMap* _tmp5_ = NULL;
	LibraryPhoto* _tmp6_ = NULL;
	gpointer _tmp7_ = NULL;
	PhotoMonitorReimportEditableJob* _tmp8_ = NULL;
#line 271 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 271 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 272 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->priv->master_reimport_pending;
#line 272 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo;
#line 272 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 272 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	master_job = (PhotoMonitorReimportMasterJob*) _tmp2_;
#line 273 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = master_job;
#line 273 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp3_ != NULL) {
#line 2068 "PhotoMonitor.c"
		PhotoMonitorReimportMasterJob* _tmp4_ = NULL;
#line 274 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp4_ = master_job;
#line 274 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 2074 "PhotoMonitor.c"
	}
#line 276 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = self->priv->editable_reimport_pending;
#line 276 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp6_ = photo;
#line 276 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp7_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp6_);
#line 276 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	editable_job = (PhotoMonitorReimportEditableJob*) _tmp7_;
#line 277 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp8_ = editable_job;
#line 277 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp8_ != NULL) {
#line 2088 "PhotoMonitor.c"
		PhotoMonitorReimportEditableJob* _tmp9_ = NULL;
#line 278 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp9_ = editable_job;
#line 278 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 2094 "PhotoMonitor.c"
	}
#line 271 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_background_job_unref0 (editable_job);
#line 271 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_background_job_unref0 (master_job);
#line 2100 "PhotoMonitor.c"
}


static MediaMonitorDiscoveredFile photo_monitor_real_notify_file_discovered (MediaMonitor* base, GFile* file, GFileInfo* info, Monitorable** monitorable) {
	PhotoMonitor * self;
	Monitorable* _vala_monitorable = NULL;
	MediaMonitorDiscoveredFile result = 0;
	LibraryPhotoSourceCollectionState state = 0;
	LibraryPhoto* photo = NULL;
	GFile* _tmp0_ = NULL;
	LibraryPhotoSourceCollectionState _tmp1_ = 0;
	LibraryPhoto* _tmp2_ = NULL;
	LibraryPhoto* _tmp3_ = NULL;
	LibraryPhotoSourceCollectionState _tmp4_ = 0;
#line 281 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 281 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), 0);
#line 281 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), 0);
#line 284 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = file;
#line 284 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = photo_monitor_get_photo_state_by_file (self, _tmp0_, &_tmp1_);
#line 284 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	state = _tmp1_;
#line 284 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo = _tmp2_;
#line 285 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = photo;
#line 285 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp3_ == NULL) {
#line 286 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_vala_monitorable);
#line 286 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_vala_monitorable = NULL;
#line 288 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		result = MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN;
#line 288 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (photo);
#line 288 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (monitorable) {
#line 288 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			*monitorable = _vala_monitorable;
#line 2145 "PhotoMonitor.c"
		} else {
#line 288 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_vala_monitorable);
#line 2149 "PhotoMonitor.c"
		}
#line 288 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return result;
#line 2153 "PhotoMonitor.c"
	}
#line 291 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = state;
#line 291 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	switch (_tmp4_) {
#line 291 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
#line 291 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
#line 2163 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp5_ = NULL;
			Monitorable* _tmp6_ = NULL;
#line 294 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp5_ = photo;
#line 294 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_MONITORABLE, Monitorable));
#line 294 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_vala_monitorable);
#line 294 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_vala_monitorable = _tmp6_;
#line 296 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			result = MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED;
#line 296 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (photo);
#line 296 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (monitorable) {
#line 296 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				*monitorable = _vala_monitorable;
#line 2183 "PhotoMonitor.c"
			} else {
#line 296 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (_vala_monitorable);
#line 2187 "PhotoMonitor.c"
			}
#line 296 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			return result;
#line 2191 "PhotoMonitor.c"
		}
		default:
#line 291 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
#line 291 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
#line 291 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
#line 2200 "PhotoMonitor.c"
		{
#line 304 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_vala_monitorable);
#line 304 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_vala_monitorable = NULL;
#line 306 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			result = MEDIA_MONITOR_DISCOVERED_FILE_IGNORE;
#line 306 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (photo);
#line 306 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (monitorable) {
#line 306 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				*monitorable = _vala_monitorable;
#line 2214 "PhotoMonitor.c"
			} else {
#line 306 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (_vala_monitorable);
#line 2218 "PhotoMonitor.c"
			}
#line 306 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			return result;
#line 2222 "PhotoMonitor.c"
		}
	}
#line 281 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (photo);
#line 281 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (monitorable) {
#line 281 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		*monitorable = _vala_monitorable;
#line 2231 "PhotoMonitor.c"
	} else {
#line 281 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_vala_monitorable);
#line 2235 "PhotoMonitor.c"
	}
}


static GeeCollection* photo_monitor_real_candidates_for_unknown_file (MediaMonitor* base, GFile* file, GFileInfo* info, MediaMonitorDiscoveredFile* _result_) {
	PhotoMonitor * self;
	MediaMonitorDiscoveredFile _vala_result = 0;
	GeeCollection* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GeeCollection* matched_masters = NULL;
	GeeArrayList* _tmp2_ = NULL;
	LibraryPhotoSourceCollection* _tmp3_ = NULL;
	GFileInfo* _tmp4_ = NULL;
	GeeCollection* _tmp5_ = NULL;
	GeeArrayList* _tmp6_ = NULL;
	GeeArrayList* _tmp7_ = NULL;
	GeeCollection* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gboolean _tmp11_ = FALSE;
	GeeArrayList* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	GeeArrayList* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	GeeArrayList* _tmp53_ = NULL;
	gint _tmp54_ = 0;
	gint _tmp55_ = 0;
#line 310 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 310 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 310 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), NULL);
#line 313 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->priv->matched_editables;
#line 313 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 314 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = self->priv->matched_developments;
#line 314 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 316 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 316 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	matched_masters = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
#line 317 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = library_photo_global;
#line 317 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = info;
#line 317 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = matched_masters;
#line 317 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp6_ = self->priv->matched_editables;
#line 317 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp7_ = self->priv->matched_developments;
#line 317 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	library_photo_source_collection_fetch_by_matching_backing (_tmp3_, _tmp4_, _tmp5_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection));
#line 319 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp8_ = matched_masters;
#line 319 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp9_ = gee_collection_get_size (_tmp8_);
#line 319 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp10_ = _tmp9_;
#line 319 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp10_ > 0) {
#line 320 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_vala_result = MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN;
#line 322 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		result = matched_masters;
#line 322 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (_result_) {
#line 322 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			*_result_ = _vala_result;
#line 2312 "PhotoMonitor.c"
		}
#line 322 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return result;
#line 2316 "PhotoMonitor.c"
	}
#line 325 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp12_ = self->priv->matched_editables;
#line 325 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp13_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_COLLECTION, GeeCollection));
#line 325 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp14_ = _tmp13_;
#line 325 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp14_ == 0) {
#line 2326 "PhotoMonitor.c"
		GeeArrayList* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
#line 325 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp15_ = self->priv->matched_developments;
#line 325 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp16_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection));
#line 325 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp17_ = _tmp16_;
#line 325 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp11_ = _tmp17_ == 0;
#line 2338 "PhotoMonitor.c"
	} else {
#line 325 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp11_ = FALSE;
#line 2342 "PhotoMonitor.c"
	}
#line 325 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp11_) {
#line 326 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_vala_result = MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN;
#line 328 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		result = NULL;
#line 328 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (matched_masters);
#line 328 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (_result_) {
#line 328 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			*_result_ = _vala_result;
#line 2356 "PhotoMonitor.c"
		}
#line 328 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return result;
#line 2360 "PhotoMonitor.c"
	}
#line 332 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp18_ = self->priv->matched_editables;
#line 332 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp19_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection));
#line 332 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp20_ = _tmp19_;
#line 332 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp20_ > 0) {
#line 2370 "PhotoMonitor.c"
		LibraryPhoto* match = NULL;
		GeeArrayList* _tmp21_ = NULL;
		gpointer _tmp22_ = NULL;
		GeeArrayList* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		LibraryPhoto* _tmp51_ = NULL;
		GFile* _tmp52_ = NULL;
#line 333 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp21_ = self->priv->matched_editables;
#line 333 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp22_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
#line 333 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		match = (LibraryPhoto*) _tmp22_;
#line 334 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp23_ = self->priv->matched_editables;
#line 334 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp24_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_COLLECTION, GeeCollection));
#line 334 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp25_ = _tmp24_;
#line 334 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (_tmp25_ > 1) {
#line 2393 "PhotoMonitor.c"
			GFile* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			GeeArrayList* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			LibraryPhoto* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_ = NULL;
#line 335 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp26_ = file;
#line 335 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp27_ = g_file_get_path (_tmp26_);
#line 335 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp28_ = _tmp27_;
#line 335 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp29_ = self->priv->matched_editables;
#line 335 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp30_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_COLLECTION, GeeCollection));
#line 335 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp31_ = _tmp30_;
#line 335 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp32_ = match;
#line 335 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp33_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, TYPE_DATA_OBJECT, DataObject));
#line 335 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp34_ = _tmp33_;
#line 335 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_warning ("PhotoMonitor.vala:335: Unknown file %s could be matched with %d photos" \
"; giving to %s, dropping others", _tmp28_, _tmp31_, _tmp34_);
#line 335 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp34_);
#line 335 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp28_);
#line 2427 "PhotoMonitor.c"
			{
				gint ctr = 0;
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				ctr = 1;
#line 2432 "PhotoMonitor.c"
				{
					gboolean _tmp35_ = FALSE;
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp35_ = TRUE;
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					while (TRUE) {
#line 2439 "PhotoMonitor.c"
						gint _tmp37_ = 0;
						GeeArrayList* _tmp38_ = NULL;
						gint _tmp39_ = 0;
						gint _tmp40_ = 0;
						GeeArrayList* _tmp41_ = NULL;
						gint _tmp42_ = 0;
						gpointer _tmp43_ = NULL;
						LibraryPhoto* _tmp44_ = NULL;
						gboolean _tmp45_ = FALSE;
						gboolean _tmp46_ = FALSE;
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						if (!_tmp35_) {
#line 2452 "PhotoMonitor.c"
							gint _tmp36_ = 0;
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp36_ = ctr;
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							ctr = _tmp36_ + 1;
#line 2458 "PhotoMonitor.c"
						}
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp35_ = FALSE;
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp37_ = ctr;
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp38_ = self->priv->matched_editables;
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp39_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, GEE_TYPE_COLLECTION, GeeCollection));
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp40_ = _tmp39_;
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						if (!(_tmp37_ < _tmp40_)) {
#line 337 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							break;
#line 2474 "PhotoMonitor.c"
						}
#line 338 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp41_ = self->priv->matched_editables;
#line 338 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp42_ = ctr;
#line 338 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp43_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp42_);
#line 338 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp44_ = (LibraryPhoto*) _tmp43_;
#line 338 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp45_ = photo_does_editable_exist (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, TYPE_PHOTO, Photo));
#line 338 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp46_ = !_tmp45_;
#line 338 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_object_unref0 (_tmp44_);
#line 338 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						if (_tmp46_) {
#line 2492 "PhotoMonitor.c"
							GeeArrayList* _tmp47_ = NULL;
							gint _tmp48_ = 0;
							gpointer _tmp49_ = NULL;
							LibraryPhoto* _tmp50_ = NULL;
#line 339 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp47_ = self->priv->matched_editables;
#line 339 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp48_ = ctr;
#line 339 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp49_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp48_);
#line 339 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp50_ = (LibraryPhoto*) _tmp49_;
#line 339 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							photo_revert_to_master (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, TYPE_PHOTO, Photo), TRUE);
#line 339 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_g_object_unref0 (_tmp50_);
#line 2509 "PhotoMonitor.c"
						}
					}
				}
			}
		}
#line 343 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp51_ = match;
#line 343 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp52_ = file;
#line 343 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_monitor_update_editable_file (self, _tmp51_, _tmp52_);
#line 332 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (match);
#line 2523 "PhotoMonitor.c"
	}
#line 346 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp53_ = self->priv->matched_developments;
#line 346 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp54_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, GEE_TYPE_COLLECTION, GeeCollection));
#line 346 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp55_ = _tmp54_;
#line 346 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp55_ > 0) {
#line 2533 "PhotoMonitor.c"
		LibraryPhoto* match_raw = NULL;
		GeeArrayList* _tmp56_ = NULL;
		gpointer _tmp57_ = NULL;
		GeeArrayList* _tmp58_ = NULL;
		gint _tmp59_ = 0;
		gint _tmp60_ = 0;
		LibraryPhoto* _tmp70_ = NULL;
		GFile* _tmp71_ = NULL;
#line 347 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp56_ = self->priv->matched_developments;
#line 347 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp57_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
#line 347 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		match_raw = (LibraryPhoto*) _tmp57_;
#line 348 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp58_ = self->priv->matched_developments;
#line 348 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp59_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, GEE_TYPE_COLLECTION, GeeCollection));
#line 348 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp60_ = _tmp59_;
#line 348 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (_tmp60_ > 1) {
#line 2556 "PhotoMonitor.c"
			GFile* _tmp61_ = NULL;
			gchar* _tmp62_ = NULL;
			gchar* _tmp63_ = NULL;
			GeeArrayList* _tmp64_ = NULL;
			gint _tmp65_ = 0;
			gint _tmp66_ = 0;
			LibraryPhoto* _tmp67_ = NULL;
			gchar* _tmp68_ = NULL;
			gchar* _tmp69_ = NULL;
#line 349 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp61_ = file;
#line 349 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp62_ = g_file_get_path (_tmp61_);
#line 349 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp63_ = _tmp62_;
#line 349 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp64_ = self->priv->matched_developments;
#line 349 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp65_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, GEE_TYPE_COLLECTION, GeeCollection));
#line 349 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp66_ = _tmp65_;
#line 349 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp67_ = match_raw;
#line 349 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp68_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, TYPE_DATA_OBJECT, DataObject));
#line 349 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp69_ = _tmp68_;
#line 349 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_warning ("PhotoMonitor.vala:349: Unknown file %s could be matched with %d photos" \
"; giving to %s, dropping others", _tmp63_, _tmp66_, _tmp69_);
#line 349 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp69_);
#line 349 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp63_);
#line 2590 "PhotoMonitor.c"
		}
#line 353 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp70_ = match_raw;
#line 353 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp71_ = file;
#line 353 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_monitor_update_raw_development_file (self, _tmp70_, _tmp71_);
#line 346 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (match_raw);
#line 2600 "PhotoMonitor.c"
	}
#line 356 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_vala_result = MEDIA_MONITOR_DISCOVERED_FILE_IGNORE;
#line 358 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = NULL;
#line 358 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (matched_masters);
#line 358 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_result_) {
#line 358 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		*_result_ = _vala_result;
#line 2612 "PhotoMonitor.c"
	}
#line 358 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 2616 "PhotoMonitor.c"
}


static void _vala_array_add336 (GFile*** array, int* length, int* size, GFile* value) {
#line 367 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if ((*length) == (*size)) {
#line 367 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 367 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		*array = g_renew (GFile*, *array, (*size) + 1);
#line 2627 "PhotoMonitor.c"
	}
#line 367 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	(*array)[(*length)++] = value;
#line 367 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	(*array)[*length] = NULL;
#line 2633 "PhotoMonitor.c"
}


static void _vala_array_add337 (GFile*** array, int* length, int* size, GFile* value) {
#line 373 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if ((*length) == (*size)) {
#line 373 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 373 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		*array = g_renew (GFile*, *array, (*size) + 1);
#line 2644 "PhotoMonitor.c"
	}
#line 373 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	(*array)[(*length)++] = value;
#line 373 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	(*array)[*length] = NULL;
#line 2650 "PhotoMonitor.c"
}


static GFile** _vala_array_dup32 (GFile** self, int length) {
	GFile** result;
	int i;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = g_new0 (GFile*, length + 1);
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	for (i = 0; i < length; i++) {
#line 2661 "PhotoMonitor.c"
		GFile* _tmp0_ = NULL;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = _g_object_ref0 (self[i]);
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		result[i] = _tmp0_;
#line 2667 "PhotoMonitor.c"
	}
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 2671 "PhotoMonitor.c"
}


static GFile** photo_monitor_real_get_auxilliary_backing_files (MediaMonitor* base, Monitorable* monitorable, int* result_length1) {
	PhotoMonitor * self;
	GFile** result = NULL;
	LibraryPhoto* photo = NULL;
	Monitorable* _tmp0_ = NULL;
	LibraryPhoto* _tmp1_ = NULL;
	GFile** files = NULL;
	GFile** _tmp2_ = NULL;
	gint files_length1 = 0;
	gint _files_size_ = 0;
	LibraryPhoto* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GeeCollection* raw_files = NULL;
	LibraryPhoto* _tmp8_ = NULL;
	GeeCollection* _tmp9_ = NULL;
	GeeCollection* _tmp10_ = NULL;
	GFile** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gint __tmp20__size_ = 0;
	GFile** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	GFile** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	GFile** _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
#line 361 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 361 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_MONITORABLE (monitorable), NULL);
#line 362 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = monitorable;
#line 362 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
#line 362 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo = _tmp1_;
#line 363 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = g_new0 (GFile*, 0 + 1);
#line 363 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	files = _tmp2_;
#line 363 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	files_length1 = 0;
#line 363 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_files_size_ = files_length1;
#line 366 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = photo;
#line 366 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = photo_has_editable (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_PHOTO, Photo));
#line 366 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp4_) {
#line 2724 "PhotoMonitor.c"
		GFile** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		LibraryPhoto* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
#line 367 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5_ = files;
#line 367 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5__length1 = files_length1;
#line 367 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp6_ = photo;
#line 367 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp7_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_PHOTO, Photo));
#line 367 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_vala_array_add336 (&files, &files_length1, &_files_size_, _tmp7_);
#line 2739 "PhotoMonitor.c"
	}
#line 370 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp8_ = photo;
#line 370 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp9_ = photo_get_raw_developer_files (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_PHOTO, Photo));
#line 370 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	raw_files = _tmp9_;
#line 371 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp10_ = raw_files;
#line 371 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp10_ != NULL) {
#line 2751 "PhotoMonitor.c"
		{
			GeeIterator* _f_it = NULL;
			GeeCollection* _tmp11_ = NULL;
			GeeIterator* _tmp12_ = NULL;
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp11_ = raw_files;
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp12_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ITERABLE, GeeIterable));
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_f_it = _tmp12_;
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			while (TRUE) {
#line 2764 "PhotoMonitor.c"
				GeeIterator* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				GFile* f = NULL;
				GeeIterator* _tmp15_ = NULL;
				gpointer _tmp16_ = NULL;
				GFile** _tmp17_ = NULL;
				gint _tmp17__length1 = 0;
				GFile* _tmp18_ = NULL;
				GFile* _tmp19_ = NULL;
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp13_ = _f_it;
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp14_ = gee_iterator_next (_tmp13_);
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (!_tmp14_) {
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					break;
#line 2782 "PhotoMonitor.c"
				}
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp15_ = _f_it;
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp16_ = gee_iterator_get (_tmp15_);
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				f = (GFile*) _tmp16_;
#line 373 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp17_ = files;
#line 373 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp17__length1 = files_length1;
#line 373 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp18_ = f;
#line 373 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp19_ = _g_object_ref0 (_tmp18_);
#line 373 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_vala_array_add337 (&files, &files_length1, &_files_size_, _tmp19_);
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (f);
#line 2802 "PhotoMonitor.c"
			}
#line 372 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_f_it);
#line 2806 "PhotoMonitor.c"
		}
	}
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp21_ = files;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp21__length1 = files_length1;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp21__length1 > 0) {
#line 2815 "PhotoMonitor.c"
		GFile** _tmp22_ = NULL;
		gint _tmp22__length1 = 0;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp22_ = files;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp22__length1 = files_length1;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp20_ = _tmp22_;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp20__length1 = _tmp22__length1;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		__tmp20__size_ = _tmp20__length1;
#line 2828 "PhotoMonitor.c"
	} else {
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp20_ = NULL;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp20__length1 = 0;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		__tmp20__size_ = _tmp20__length1;
#line 2836 "PhotoMonitor.c"
	}
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp23_ = (_tmp20_ != NULL) ? _vala_array_dup32 (_tmp20_, _tmp20__length1) : ((gpointer) _tmp20_);
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp23__length1 = _tmp20__length1;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp24_ = _tmp23_;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp24__length1 = _tmp23__length1;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (result_length1) {
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		*result_length1 = _tmp24__length1;
#line 2850 "PhotoMonitor.c"
	}
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp24_;
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (raw_files);
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (photo);
#line 376 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 2862 "PhotoMonitor.c"
}


static void photo_monitor_real_update_backing_file_info (MediaMonitor* base, Monitorable* monitorable, GFile* file, GFileInfo* info) {
	PhotoMonitor * self;
	LibraryPhoto* photo = NULL;
	Monitorable* _tmp0_ = NULL;
	LibraryPhoto* _tmp1_ = NULL;
	LibraryPhoto* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
#line 379 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 379 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_MONITORABLE (monitorable));
#line 379 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 379 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail ((info == NULL) || G_IS_FILE_INFO (info));
#line 380 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = monitorable;
#line 380 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
#line 380 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo = _tmp1_;
#line 382 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = photo;
#line 382 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = media_monitor_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_MONITORABLE, Monitorable));
#line 382 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = _tmp3_;
#line 382 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = file;
#line 382 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp6_ = g_file_equal (_tmp4_, _tmp5_);
#line 382 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp7_ = _tmp6_;
#line 382 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (_tmp4_);
#line 382 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp7_) {
#line 2907 "PhotoMonitor.c"
		LibraryPhoto* _tmp8_ = NULL;
		GFileInfo* _tmp9_ = NULL;
#line 383 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp8_ = photo;
#line 383 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp9_ = info;
#line 383 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_monitor_check_for_master_changes (self, _tmp8_, _tmp9_);
#line 2916 "PhotoMonitor.c"
	} else {
		gboolean _tmp10_ = FALSE;
		LibraryPhoto* _tmp11_ = NULL;
		GFile* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp11_ = photo;
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp12_ = photo_monitor_get_editable_file (self, _tmp11_);
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp13_ = _tmp12_;
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp14_ = _tmp13_ != NULL;
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_tmp13_);
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (_tmp14_) {
#line 2935 "PhotoMonitor.c"
			LibraryPhoto* _tmp15_ = NULL;
			GFile* _tmp16_ = NULL;
			GFile* _tmp17_ = NULL;
			GFile* _tmp18_ = NULL;
			gboolean _tmp19_ = FALSE;
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp15_ = photo;
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp16_ = photo_monitor_get_editable_file (self, _tmp15_);
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp17_ = _tmp16_;
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp18_ = file;
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp19_ = g_file_equal (_tmp17_, _tmp18_);
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp10_ = _tmp19_;
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_tmp17_);
#line 2955 "PhotoMonitor.c"
		} else {
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp10_ = FALSE;
#line 2959 "PhotoMonitor.c"
		}
#line 384 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (_tmp10_) {
#line 2963 "PhotoMonitor.c"
			LibraryPhoto* _tmp20_ = NULL;
			GFileInfo* _tmp21_ = NULL;
#line 385 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp20_ = photo;
#line 385 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp21_ = info;
#line 385 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_check_for_editable_changes (self, _tmp20_, _tmp21_);
#line 2972 "PhotoMonitor.c"
		} else {
			LibraryPhoto* _tmp22_ = NULL;
			GeeCollection* _tmp23_ = NULL;
			GeeCollection* _tmp24_ = NULL;
			gboolean _tmp25_ = FALSE;
#line 386 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp22_ = photo;
#line 386 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp23_ = photo_monitor_get_raw_development_files (self, _tmp22_);
#line 386 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp24_ = _tmp23_;
#line 386 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp25_ = _tmp24_ != NULL;
#line 386 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_tmp24_);
#line 386 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_tmp25_) {
#line 2990 "PhotoMonitor.c"
				{
					GeeIterator* _f_it = NULL;
					LibraryPhoto* _tmp26_ = NULL;
					GeeCollection* _tmp27_ = NULL;
					GeeCollection* _tmp28_ = NULL;
					GeeIterator* _tmp29_ = NULL;
					GeeIterator* _tmp30_ = NULL;
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp26_ = photo;
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp27_ = photo_monitor_get_raw_development_files (self, _tmp26_);
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp28_ = _tmp27_;
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp29_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_ITERABLE, GeeIterable));
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp30_ = _tmp29_;
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (_tmp28_);
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_f_it = _tmp30_;
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					while (TRUE) {
#line 3014 "PhotoMonitor.c"
						GeeIterator* _tmp31_ = NULL;
						gboolean _tmp32_ = FALSE;
						GFile* f = NULL;
						GeeIterator* _tmp33_ = NULL;
						gpointer _tmp34_ = NULL;
						GFile* _tmp35_ = NULL;
						GFile* _tmp36_ = NULL;
						gboolean _tmp37_ = FALSE;
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp31_ = _f_it;
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp32_ = gee_iterator_next (_tmp31_);
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						if (!_tmp32_) {
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							break;
#line 3031 "PhotoMonitor.c"
						}
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp33_ = _f_it;
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp34_ = gee_iterator_get (_tmp33_);
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						f = (GFile*) _tmp34_;
#line 388 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp35_ = f;
#line 388 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp36_ = file;
#line 388 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp37_ = g_file_equal (_tmp35_, _tmp36_);
#line 388 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						if (_tmp37_) {
#line 3047 "PhotoMonitor.c"
							LibraryPhoto* _tmp38_ = NULL;
							GFileInfo* _tmp39_ = NULL;
#line 389 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp38_ = photo;
#line 389 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp39_ = info;
#line 389 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							photo_monitor_check_for_raw_development_changes (self, _tmp38_, _tmp39_);
#line 3056 "PhotoMonitor.c"
						}
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_object_unref0 (f);
#line 3060 "PhotoMonitor.c"
					}
#line 387 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (_f_it);
#line 3064 "PhotoMonitor.c"
				}
			}
		}
	}
#line 379 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (photo);
#line 3071 "PhotoMonitor.c"
}


static void photo_monitor_real_notify_discovery_completing (MediaMonitor* base) {
	PhotoMonitor * self;
	GeeArrayList* _tmp0_ = NULL;
#line 394 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 395 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->priv->matched_editables;
#line 395 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 3084 "PhotoMonitor.c"
}


static void photo_monitor_check_for_master_changes (PhotoMonitor* self, LibraryPhoto* photo, GFileInfo* info) {
	GFileInfo* _tmp0_ = NULL;
	BackingPhotoRow* state = NULL;
	LibraryPhoto* _tmp1_ = NULL;
	BackingPhotoRow* _tmp2_ = NULL;
	BackingPhotoRow* _tmp3_ = NULL;
	GFileInfo* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	BackingPhotoRow* _tmp6_ = NULL;
	GFileInfo* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
#line 402 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 402 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 402 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail ((info == NULL) || G_IS_FILE_INFO (info));
#line 404 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = info;
#line 404 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp0_ == NULL) {
#line 405 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 3111 "PhotoMonitor.c"
	}
#line 407 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo;
#line 407 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = photo_get_master_photo_row (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO, Photo));
#line 407 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	state = _tmp2_;
#line 408 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = state;
#line 408 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = info;
#line 408 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = backing_photo_row_matches_file_info (_tmp3_, _tmp4_);
#line 408 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp5_) {
#line 409 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_backing_photo_row_unref0 (state);
#line 409 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 3131 "PhotoMonitor.c"
	}
#line 411 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp6_ = state;
#line 411 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp7_ = info;
#line 411 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp8_ = backing_photo_row_is_touched (_tmp6_, _tmp7_);
#line 411 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp8_) {
#line 3141 "PhotoMonitor.c"
		LibraryPhoto* _tmp9_ = NULL;
		LibraryPhoto* _tmp10_ = NULL;
		GFileInfo* _tmp11_ = NULL;
#line 412 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp9_ = photo;
#line 412 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		media_monitor_update_master_file_info_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_MONITORABLE, Monitorable));
#line 413 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp10_ = photo;
#line 413 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp11_ = info;
#line 413 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		media_monitor_update_master_file_alterations_completed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_MONITORABLE, Monitorable), _tmp11_);
#line 3155 "PhotoMonitor.c"
	} else {
		LibraryPhoto* _tmp12_ = NULL;
#line 415 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp12_ = photo;
#line 415 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_monitor_update_reimport_master (self, _tmp12_);
#line 3162 "PhotoMonitor.c"
	}
#line 402 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_backing_photo_row_unref0 (state);
#line 3166 "PhotoMonitor.c"
}


static void photo_monitor_check_for_editable_changes (PhotoMonitor* self, LibraryPhoto* photo, GFileInfo* info) {
	GFileInfo* _tmp0_ = NULL;
	BackingPhotoRow* state = NULL;
	LibraryPhoto* _tmp2_ = NULL;
	BackingPhotoRow* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	BackingPhotoRow* _tmp5_ = NULL;
	BackingPhotoRow* _tmp9_ = NULL;
	GFileInfo* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
#line 419 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 419 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 419 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail ((info == NULL) || G_IS_FILE_INFO (info));
#line 420 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = info;
#line 420 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp0_ == NULL) {
#line 3190 "PhotoMonitor.c"
		LibraryPhoto* _tmp1_ = NULL;
#line 421 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = photo;
#line 421 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_monitor_update_revert_to_master (self, _tmp1_);
#line 423 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 3198 "PhotoMonitor.c"
	}
#line 427 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = photo;
#line 427 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = photo_get_editable_photo_row (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO, Photo));
#line 427 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	state = _tmp3_;
#line 428 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = state;
#line 428 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp5_ == NULL) {
#line 428 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp4_ = TRUE;
#line 3212 "PhotoMonitor.c"
	} else {
		BackingPhotoRow* _tmp6_ = NULL;
		GFileInfo* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 428 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp6_ = state;
#line 428 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp7_ = info;
#line 428 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp8_ = backing_photo_row_matches_file_info (_tmp6_, _tmp7_);
#line 428 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp4_ = _tmp8_;
#line 3225 "PhotoMonitor.c"
	}
#line 428 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp4_) {
#line 429 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_backing_photo_row_unref0 (state);
#line 429 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 3233 "PhotoMonitor.c"
	}
#line 431 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp9_ = state;
#line 431 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp10_ = info;
#line 431 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp11_ = backing_photo_row_is_touched (_tmp9_, _tmp10_);
#line 431 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp11_) {
#line 3243 "PhotoMonitor.c"
		LibraryPhoto* _tmp12_ = NULL;
		LibraryPhoto* _tmp13_ = NULL;
		GFileInfo* _tmp14_ = NULL;
#line 432 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp12_ = photo;
#line 432 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_monitor_update_editable_file_info_altered (self, _tmp12_);
#line 433 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp13_ = photo;
#line 433 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp14_ = info;
#line 433 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_monitor_update_editable_file_alterations_completed (self, _tmp13_, _tmp14_);
#line 3257 "PhotoMonitor.c"
	} else {
		LibraryPhoto* _tmp15_ = NULL;
#line 435 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp15_ = photo;
#line 435 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_monitor_update_reimport_editable (self, _tmp15_);
#line 3264 "PhotoMonitor.c"
	}
#line 419 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_backing_photo_row_unref0 (state);
#line 3268 "PhotoMonitor.c"
}


static void photo_monitor_check_for_raw_development_changes (PhotoMonitor* self, LibraryPhoto* photo, GFileInfo* info) {
	GFileInfo* _tmp0_ = NULL;
	GeeCollection* rows = NULL;
	LibraryPhoto* _tmp2_ = NULL;
	GeeCollection* _tmp3_ = NULL;
	GeeCollection* _tmp4_ = NULL;
#line 439 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 439 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 439 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail ((info == NULL) || G_IS_FILE_INFO (info));
#line 440 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = info;
#line 440 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp0_ == NULL) {
#line 3288 "PhotoMonitor.c"
		LibraryPhoto* _tmp1_ = NULL;
#line 442 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = photo;
#line 442 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_set_raw_developer (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO, Photo), RAW_DEVELOPER_SHOTWELL);
#line 444 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 3296 "PhotoMonitor.c"
	}
#line 447 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = photo;
#line 447 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = photo_get_raw_development_photo_rows (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO, Photo));
#line 447 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	rows = _tmp3_;
#line 448 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = rows;
#line 448 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp4_ == NULL) {
#line 449 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (rows);
#line 449 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 3312 "PhotoMonitor.c"
	}
	{
		GeeIterator* _row_it = NULL;
		GeeCollection* _tmp5_ = NULL;
		GeeIterator* _tmp6_ = NULL;
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5_ = rows;
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp6_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ITERABLE, GeeIterable));
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_row_it = _tmp6_;
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		while (TRUE) {
#line 3326 "PhotoMonitor.c"
			GeeIterator* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			BackingPhotoRow* row = NULL;
			GeeIterator* _tmp9_ = NULL;
			gpointer _tmp10_ = NULL;
			BackingPhotoRow* _tmp11_ = NULL;
			GFileInfo* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			GFileInfo* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			BackingPhotoRow* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp7_ = _row_it;
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp8_ = gee_iterator_next (_tmp7_);
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (!_tmp8_) {
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				break;
#line 3347 "PhotoMonitor.c"
			}
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp9_ = _row_it;
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp10_ = gee_iterator_get (_tmp9_);
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			row = (BackingPhotoRow*) _tmp10_;
#line 454 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp11_ = row;
#line 454 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp12_ = info;
#line 454 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp13_ = backing_photo_row_matches_file_info (_tmp11_, _tmp12_);
#line 454 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_tmp13_) {
#line 455 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_backing_photo_row_unref0 (row);
#line 455 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (_row_it);
#line 455 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (rows);
#line 455 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				return;
#line 3371 "PhotoMonitor.c"
			}
#line 456 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp14_ = info;
#line 456 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp15_ = g_file_info_get_name (_tmp14_);
#line 456 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp16_ = row;
#line 456 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp17_ = _tmp16_->filepath;
#line 456 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (g_strcmp0 (_tmp15_, _tmp17_) == 0) {
#line 3383 "PhotoMonitor.c"
				BackingPhotoRow* _tmp18_ = NULL;
				GFileInfo* _tmp19_ = NULL;
				gboolean _tmp20_ = FALSE;
#line 457 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp18_ = row;
#line 457 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp19_ = info;
#line 457 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp20_ = backing_photo_row_is_touched (_tmp18_, _tmp19_);
#line 457 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp20_) {
#line 3395 "PhotoMonitor.c"
					LibraryPhoto* _tmp21_ = NULL;
					LibraryPhoto* _tmp22_ = NULL;
#line 458 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp21_ = photo;
#line 458 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					photo_monitor_update_raw_development_file_info_altered (self, _tmp21_);
#line 459 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp22_ = photo;
#line 459 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					photo_monitor_update_raw_development_file_alterations_completed (self, _tmp22_);
#line 3406 "PhotoMonitor.c"
				} else {
					LibraryPhoto* _tmp23_ = NULL;
#line 461 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp23_ = photo;
#line 461 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					photo_monitor_update_reimport_raw_developments (self, _tmp23_);
#line 3413 "PhotoMonitor.c"
				}
#line 464 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_backing_photo_row_unref0 (row);
#line 464 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				break;
#line 3419 "PhotoMonitor.c"
			}
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_backing_photo_row_unref0 (row);
#line 3423 "PhotoMonitor.c"
		}
#line 453 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_row_it);
#line 3427 "PhotoMonitor.c"
	}
#line 439 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (rows);
#line 3431 "PhotoMonitor.c"
}


static gboolean photo_monitor_real_notify_file_created (MediaMonitor* base, GFile* file, GFileInfo* info) {
	PhotoMonitor * self;
	gboolean result = FALSE;
	LibraryPhotoSourceCollectionState state = 0;
	LibraryPhoto* photo = NULL;
	GFile* _tmp0_ = NULL;
	LibraryPhotoSourceCollectionState _tmp1_ = 0;
	LibraryPhoto* _tmp2_ = NULL;
	LibraryPhoto* _tmp3_ = NULL;
	LibraryPhotoSourceCollectionState _tmp4_ = 0;
#line 469 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 469 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 469 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), FALSE);
#line 471 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = file;
#line 471 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = photo_monitor_get_photo_state_by_file (self, _tmp0_, &_tmp1_);
#line 471 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	state = _tmp1_;
#line 471 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo = _tmp2_;
#line 472 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = photo;
#line 472 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp3_ == NULL) {
#line 473 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		result = FALSE;
#line 473 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (photo);
#line 473 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return result;
#line 3469 "PhotoMonitor.c"
	}
#line 475 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = state;
#line 475 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	switch (_tmp4_) {
#line 475 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
#line 475 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
#line 475 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
#line 475 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
#line 3483 "PhotoMonitor.c"
		{
			GFile* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			LibraryPhotoSourceCollectionState _tmp8_ = 0;
			GEnumValue* _tmp9_;
#line 481 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp5_ = file;
#line 481 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp6_ = g_file_get_path (_tmp5_);
#line 481 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp7_ = _tmp6_;
#line 481 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp8_ = state;
#line 481 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp9_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), _tmp8_);
#line 481 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_warning ("PhotoMonitor.vala:481: File %s created in %s state", _tmp7_, (_tmp9_ != NULL) ? _tmp9_->value_name : NULL);
#line 481 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp7_);
#line 482 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 3506 "PhotoMonitor.c"
		}
#line 475 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
#line 3510 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			LibraryPhoto* _tmp15_ = NULL;
#line 485 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp10_ = photo;
#line 485 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp11_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_OBJECT, DataObject));
#line 485 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp12_ = _tmp11_;
#line 485 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp13_ = g_strdup_printf ("Will mark %s online", _tmp12_);
#line 485 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp14_ = _tmp13_;
#line 485 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_mdbg (_tmp14_);
#line 485 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp14_);
#line 485 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp12_);
#line 486 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp15_ = photo;
#line 486 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_update_online (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_MONITORABLE, Monitorable));
#line 487 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 3540 "PhotoMonitor.c"
		}
		default:
		{
			LibraryPhotoSourceCollectionState _tmp16_ = 0;
			GEnumValue* _tmp17_;
#line 490 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp16_ = state;
#line 490 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp17_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), _tmp16_);
#line 490 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_error ("PhotoMonitor.vala:490: Unknown LibraryPhoto collection state %s", (_tmp17_ != NULL) ? _tmp17_->value_name : NULL);
#line 3552 "PhotoMonitor.c"
		}
	}
#line 493 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = TRUE;
#line 493 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (photo);
#line 493 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 3561 "PhotoMonitor.c"
}


static gboolean photo_monitor_real_notify_file_moved (MediaMonitor* base, GFile* old_file, GFile* new_file, GFileInfo* info) {
	PhotoMonitor * self;
	gboolean result = FALSE;
	LibraryPhotoSourceCollectionState old_state = 0;
	LibraryPhoto* old_photo = NULL;
	GFile* _tmp0_ = NULL;
	LibraryPhotoSourceCollectionState _tmp1_ = 0;
	LibraryPhoto* _tmp2_ = NULL;
	LibraryPhotoSourceCollectionState new_state = 0;
	LibraryPhoto* new_photo = NULL;
	GFile* _tmp3_ = NULL;
	LibraryPhotoSourceCollectionState _tmp4_ = 0;
	LibraryPhoto* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	LibraryPhoto* _tmp7_ = NULL;
#line 496 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 496 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (old_file), FALSE);
#line 496 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (new_file), FALSE);
#line 496 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), FALSE);
#line 498 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = old_file;
#line 498 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = photo_monitor_get_photo_state_by_file (self, _tmp0_, &_tmp1_);
#line 498 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	old_state = _tmp1_;
#line 498 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	old_photo = _tmp2_;
#line 501 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = new_file;
#line 501 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = photo_monitor_get_photo_state_by_file (self, _tmp3_, &_tmp4_);
#line 501 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	new_state = _tmp4_;
#line 501 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	new_photo = _tmp5_;
#line 515 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp7_ = old_photo;
#line 515 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp7_ != NULL) {
#line 3608 "PhotoMonitor.c"
		LibraryPhoto* _tmp8_ = NULL;
#line 515 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp8_ = new_photo;
#line 515 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp6_ = _tmp8_ == NULL;
#line 3614 "PhotoMonitor.c"
	} else {
#line 515 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp6_ = FALSE;
#line 3618 "PhotoMonitor.c"
	}
#line 515 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp6_) {
#line 3622 "PhotoMonitor.c"
		LibraryPhotoSourceCollectionState _tmp9_ = 0;
#line 517 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp9_ = old_state;
#line 517 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		switch (_tmp9_) {
#line 517 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
#line 517 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
#line 517 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
#line 3634 "PhotoMonitor.c"
			{
				LibraryPhoto* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				GFile* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				LibraryPhoto* _tmp18_ = NULL;
				GFile* _tmp19_ = NULL;
#line 521 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp10_ = old_photo;
#line 521 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp11_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_OBJECT, DataObject));
#line 521 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp12_ = _tmp11_;
#line 521 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp13_ = new_file;
#line 521 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp14_ = g_file_get_path (_tmp13_);
#line 521 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp15_ = _tmp14_;
#line 521 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp16_ = g_strdup_printf ("Will set new master file for %s to %s", _tmp12_, _tmp15_);
#line 521 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp17_ = _tmp16_;
#line 521 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				media_monitor_mdbg (_tmp17_);
#line 521 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_free0 (_tmp17_);
#line 521 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_free0 (_tmp15_);
#line 521 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_free0 (_tmp12_);
#line 523 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp18_ = old_photo;
#line 523 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp19_ = new_file;
#line 523 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				media_monitor_update_master_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_MONITORABLE, Monitorable), _tmp19_);
#line 524 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				break;
#line 3678 "PhotoMonitor.c"
			}
#line 517 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
#line 3682 "PhotoMonitor.c"
			{
				LibraryPhoto* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				GFile* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				LibraryPhoto* _tmp28_ = NULL;
				GFile* _tmp29_ = NULL;
#line 527 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp20_ = old_photo;
#line 527 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp21_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_DATA_OBJECT, DataObject));
#line 527 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp22_ = _tmp21_;
#line 527 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp23_ = new_file;
#line 527 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp24_ = g_file_get_path (_tmp23_);
#line 527 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp25_ = _tmp24_;
#line 527 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp26_ = g_strdup_printf ("Will set new editable file for %s to %s", _tmp22_, _tmp25_);
#line 527 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp27_ = _tmp26_;
#line 527 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				media_monitor_mdbg (_tmp27_);
#line 527 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_free0 (_tmp27_);
#line 527 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_free0 (_tmp25_);
#line 527 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_free0 (_tmp22_);
#line 529 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp28_ = old_photo;
#line 529 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp29_ = new_file;
#line 529 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo_monitor_update_editable_file (self, _tmp28_, _tmp29_);
#line 530 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				break;
#line 3726 "PhotoMonitor.c"
			}
#line 517 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
#line 3730 "PhotoMonitor.c"
			{
				LibraryPhoto* _tmp30_ = NULL;
				gchar* _tmp31_ = NULL;
				gchar* _tmp32_ = NULL;
				GFile* _tmp33_ = NULL;
				gchar* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
				gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				LibraryPhoto* _tmp38_ = NULL;
				GFile* _tmp39_ = NULL;
#line 533 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp30_ = old_photo;
#line 533 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp31_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, TYPE_DATA_OBJECT, DataObject));
#line 533 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp32_ = _tmp31_;
#line 533 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp33_ = new_file;
#line 533 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp34_ = g_file_get_path (_tmp33_);
#line 533 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp35_ = _tmp34_;
#line 533 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp36_ = g_strdup_printf ("Will set new raw development file for %s to %s", _tmp32_, _tmp35_);
#line 533 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp37_ = _tmp36_;
#line 533 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				media_monitor_mdbg (_tmp37_);
#line 533 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_free0 (_tmp37_);
#line 533 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_free0 (_tmp35_);
#line 533 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_free0 (_tmp32_);
#line 535 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp38_ = old_photo;
#line 535 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp39_ = new_file;
#line 535 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo_monitor_update_raw_development_file (self, _tmp38_, _tmp39_);
#line 536 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				break;
#line 3774 "PhotoMonitor.c"
			}
			default:
			{
				LibraryPhotoSourceCollectionState _tmp40_ = 0;
				GEnumValue* _tmp41_;
#line 539 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp40_ = old_state;
#line 539 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp41_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), _tmp40_);
#line 539 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				g_error ("PhotoMonitor.vala:539: Unknown LibraryPhoto collection state %s", (_tmp41_ != NULL) ? _tmp41_->value_name : NULL);
#line 3786 "PhotoMonitor.c"
			}
		}
	} else {
		gboolean _tmp42_ = FALSE;
		LibraryPhoto* _tmp43_ = NULL;
#line 541 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp43_ = old_photo;
#line 541 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (_tmp43_ == NULL) {
#line 3796 "PhotoMonitor.c"
			LibraryPhoto* _tmp44_ = NULL;
#line 541 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp44_ = new_photo;
#line 541 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp42_ = _tmp44_ != NULL;
#line 3802 "PhotoMonitor.c"
		} else {
#line 541 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp42_ = FALSE;
#line 3806 "PhotoMonitor.c"
		}
#line 541 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (_tmp42_) {
#line 3810 "PhotoMonitor.c"
			LibraryPhotoSourceCollectionState _tmp45_ = 0;
#line 543 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp45_ = new_state;
#line 543 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			switch (_tmp45_) {
#line 543 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
#line 543 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
#line 543 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
#line 3822 "PhotoMonitor.c"
				{
					LibraryPhoto* _tmp46_ = NULL;
					gchar* _tmp47_ = NULL;
					gchar* _tmp48_ = NULL;
					gchar* _tmp49_ = NULL;
					gchar* _tmp50_ = NULL;
					LibraryPhoto* _tmp51_ = NULL;
#line 547 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp46_ = new_photo;
#line 547 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp47_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, TYPE_DATA_OBJECT, DataObject));
#line 547 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp48_ = _tmp47_;
#line 547 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp49_ = g_strdup_printf ("Will reimport master file for %s", _tmp48_);
#line 547 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp50_ = _tmp49_;
#line 547 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					media_monitor_mdbg (_tmp50_);
#line 547 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_free0 (_tmp50_);
#line 547 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_free0 (_tmp48_);
#line 548 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp51_ = new_photo;
#line 548 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					photo_monitor_update_reimport_master (self, _tmp51_);
#line 549 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					break;
#line 3852 "PhotoMonitor.c"
				}
#line 543 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
#line 3856 "PhotoMonitor.c"
				{
					LibraryPhoto* _tmp52_ = NULL;
					gchar* _tmp53_ = NULL;
					gchar* _tmp54_ = NULL;
					gchar* _tmp55_ = NULL;
					gchar* _tmp56_ = NULL;
					LibraryPhoto* _tmp57_ = NULL;
#line 552 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp52_ = new_photo;
#line 552 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp53_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, TYPE_DATA_OBJECT, DataObject));
#line 552 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp54_ = _tmp53_;
#line 552 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp55_ = g_strdup_printf ("Will reimport editable file for %s", _tmp54_);
#line 552 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp56_ = _tmp55_;
#line 552 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					media_monitor_mdbg (_tmp56_);
#line 552 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_free0 (_tmp56_);
#line 552 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_free0 (_tmp54_);
#line 553 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp57_ = new_photo;
#line 553 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					photo_monitor_update_reimport_editable (self, _tmp57_);
#line 554 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					break;
#line 3886 "PhotoMonitor.c"
				}
#line 543 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
#line 3890 "PhotoMonitor.c"
				{
					LibraryPhoto* _tmp58_ = NULL;
					gchar* _tmp59_ = NULL;
					gchar* _tmp60_ = NULL;
					gchar* _tmp61_ = NULL;
					gchar* _tmp62_ = NULL;
					LibraryPhoto* _tmp63_ = NULL;
#line 557 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp58_ = new_photo;
#line 557 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp59_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, TYPE_DATA_OBJECT, DataObject));
#line 557 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp60_ = _tmp59_;
#line 557 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp61_ = g_strdup_printf ("Will reimport raw development file for %s", _tmp60_);
#line 557 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp62_ = _tmp61_;
#line 557 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					media_monitor_mdbg (_tmp62_);
#line 557 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_free0 (_tmp62_);
#line 557 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_free0 (_tmp60_);
#line 558 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp63_ = new_photo;
#line 558 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					photo_monitor_update_reimport_raw_developments (self, _tmp63_);
#line 559 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					break;
#line 3920 "PhotoMonitor.c"
				}
				default:
				{
					LibraryPhotoSourceCollectionState _tmp64_ = 0;
					GEnumValue* _tmp65_;
#line 562 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp64_ = new_state;
#line 562 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp65_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), _tmp64_);
#line 562 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					g_error ("PhotoMonitor.vala:562: Unknown LibraryPhoto collection state %s", (_tmp65_ != NULL) ? _tmp65_->value_name : NULL);
#line 3932 "PhotoMonitor.c"
				}
			}
		} else {
			gboolean _tmp66_ = FALSE;
			LibraryPhoto* _tmp67_ = NULL;
#line 564 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp67_ = old_photo;
#line 564 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_tmp67_ == NULL) {
#line 3942 "PhotoMonitor.c"
				LibraryPhoto* _tmp68_ = NULL;
#line 564 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp68_ = new_photo;
#line 564 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp66_ = _tmp68_ == NULL;
#line 3948 "PhotoMonitor.c"
			} else {
#line 564 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp66_ = FALSE;
#line 3952 "PhotoMonitor.c"
			}
#line 564 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_tmp66_) {
#line 566 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				result = FALSE;
#line 566 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (new_photo);
#line 566 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (old_photo);
#line 566 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				return result;
#line 3964 "PhotoMonitor.c"
			} else {
				gboolean _tmp69_ = FALSE;
				LibraryPhoto* _tmp70_ = NULL;
				LibraryPhotoSourceCollectionState _tmp72_ = 0;
				LibraryPhotoSourceCollectionState _tmp87_ = 0;
#line 568 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp70_ = old_photo;
#line 568 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp70_ != NULL) {
#line 3974 "PhotoMonitor.c"
					LibraryPhoto* _tmp71_ = NULL;
#line 568 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp71_ = new_photo;
#line 568 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp69_ = _tmp71_ != NULL;
#line 3980 "PhotoMonitor.c"
				} else {
#line 568 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp69_ = FALSE;
#line 3984 "PhotoMonitor.c"
				}
#line 568 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_vala_assert (_tmp69_, "old_photo != null && new_photo != null");
#line 570 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp72_ = old_state;
#line 570 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				switch (_tmp72_) {
#line 570 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
#line 3994 "PhotoMonitor.c"
					{
						LibraryPhoto* _tmp73_ = NULL;
						gchar* _tmp74_ = NULL;
						gchar* _tmp75_ = NULL;
						gchar* _tmp76_ = NULL;
						gchar* _tmp77_ = NULL;
						LibraryPhoto* _tmp78_ = NULL;
#line 572 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp73_ = old_photo;
#line 572 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp74_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, TYPE_DATA_OBJECT, DataObject));
#line 572 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp75_ = _tmp74_;
#line 572 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp76_ = g_strdup_printf ("Will mark offline %s", _tmp75_);
#line 572 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp77_ = _tmp76_;
#line 572 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						media_monitor_mdbg (_tmp77_);
#line 572 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_free0 (_tmp77_);
#line 572 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_free0 (_tmp75_);
#line 573 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp78_ = old_photo;
#line 573 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						media_monitor_update_offline (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, TYPE_MONITORABLE, Monitorable));
#line 574 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						break;
#line 4024 "PhotoMonitor.c"
					}
#line 570 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
#line 570 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
#line 4030 "PhotoMonitor.c"
					{
#line 579 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						break;
#line 4034 "PhotoMonitor.c"
					}
#line 570 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
#line 4038 "PhotoMonitor.c"
					{
						LibraryPhoto* _tmp79_ = NULL;
						gchar* _tmp80_ = NULL;
						gchar* _tmp81_ = NULL;
						gchar* _tmp82_ = NULL;
						gchar* _tmp83_ = NULL;
						LibraryPhoto* _tmp84_ = NULL;
#line 582 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp79_ = old_photo;
#line 582 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp80_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, TYPE_DATA_OBJECT, DataObject));
#line 582 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp81_ = _tmp80_;
#line 582 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp82_ = g_strdup_printf ("Will revert %s to master", _tmp81_);
#line 582 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp83_ = _tmp82_;
#line 582 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						media_monitor_mdbg (_tmp83_);
#line 582 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_free0 (_tmp83_);
#line 582 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_free0 (_tmp81_);
#line 583 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp84_ = old_photo;
#line 583 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						photo_monitor_update_revert_to_master (self, _tmp84_);
#line 584 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						break;
#line 4068 "PhotoMonitor.c"
					}
#line 570 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
#line 4072 "PhotoMonitor.c"
					{
#line 588 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						break;
#line 4076 "PhotoMonitor.c"
					}
					default:
					{
						LibraryPhotoSourceCollectionState _tmp85_ = 0;
						GEnumValue* _tmp86_;
#line 591 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp85_ = old_state;
#line 591 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp86_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), _tmp85_);
#line 591 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						g_error ("PhotoMonitor.vala:591: Unknown LibraryPhoto collection state %s", (_tmp86_ != NULL) ? _tmp86_->value_name : NULL);
#line 4088 "PhotoMonitor.c"
					}
				}
#line 594 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp87_ = new_state;
#line 594 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				switch (_tmp87_) {
#line 594 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
#line 594 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
#line 594 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
#line 4101 "PhotoMonitor.c"
					{
						LibraryPhoto* _tmp88_ = NULL;
						gchar* _tmp89_ = NULL;
						gchar* _tmp90_ = NULL;
						gchar* _tmp91_ = NULL;
						gchar* _tmp92_ = NULL;
						LibraryPhoto* _tmp93_ = NULL;
#line 598 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp88_ = new_photo;
#line 598 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp89_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, TYPE_DATA_OBJECT, DataObject));
#line 598 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp90_ = _tmp89_;
#line 598 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp91_ = g_strdup_printf ("Will reimport master file for %s", _tmp90_);
#line 598 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp92_ = _tmp91_;
#line 598 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						media_monitor_mdbg (_tmp92_);
#line 598 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_free0 (_tmp92_);
#line 598 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_free0 (_tmp90_);
#line 599 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp93_ = new_photo;
#line 599 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						photo_monitor_update_reimport_master (self, _tmp93_);
#line 600 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						break;
#line 4131 "PhotoMonitor.c"
					}
#line 594 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
#line 4135 "PhotoMonitor.c"
					{
						LibraryPhoto* _tmp94_ = NULL;
						gchar* _tmp95_ = NULL;
						gchar* _tmp96_ = NULL;
						gchar* _tmp97_ = NULL;
						gchar* _tmp98_ = NULL;
						LibraryPhoto* _tmp99_ = NULL;
#line 603 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp94_ = new_photo;
#line 603 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp95_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, TYPE_DATA_OBJECT, DataObject));
#line 603 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp96_ = _tmp95_;
#line 603 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp97_ = g_strdup_printf ("Will reimport editable file for %s", _tmp96_);
#line 603 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp98_ = _tmp97_;
#line 603 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						media_monitor_mdbg (_tmp98_);
#line 603 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_free0 (_tmp98_);
#line 603 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_free0 (_tmp96_);
#line 604 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp99_ = new_photo;
#line 604 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						photo_monitor_update_reimport_editable (self, _tmp99_);
#line 605 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						break;
#line 4165 "PhotoMonitor.c"
					}
#line 594 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
#line 4169 "PhotoMonitor.c"
					{
						LibraryPhoto* _tmp100_ = NULL;
						gchar* _tmp101_ = NULL;
						gchar* _tmp102_ = NULL;
						gchar* _tmp103_ = NULL;
						gchar* _tmp104_ = NULL;
						LibraryPhoto* _tmp105_ = NULL;
#line 608 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp100_ = new_photo;
#line 608 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp101_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, TYPE_DATA_OBJECT, DataObject));
#line 608 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp102_ = _tmp101_;
#line 608 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp103_ = g_strdup_printf ("Will reimport raw development file for %s", _tmp102_);
#line 608 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp104_ = _tmp103_;
#line 608 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						media_monitor_mdbg (_tmp104_);
#line 608 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_free0 (_tmp104_);
#line 608 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_free0 (_tmp102_);
#line 609 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp105_ = new_photo;
#line 609 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						photo_monitor_update_reimport_raw_developments (self, _tmp105_);
#line 610 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						break;
#line 4199 "PhotoMonitor.c"
					}
					default:
					{
						LibraryPhotoSourceCollectionState _tmp106_ = 0;
						GEnumValue* _tmp107_;
#line 613 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp106_ = new_state;
#line 613 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp107_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), _tmp106_);
#line 613 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						g_error ("PhotoMonitor.vala:613: Unknown LibraryPhoto collection state %s", (_tmp107_ != NULL) ? _tmp107_->value_name : NULL);
#line 4211 "PhotoMonitor.c"
					}
				}
			}
		}
	}
#line 617 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = TRUE;
#line 617 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (new_photo);
#line 617 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (old_photo);
#line 617 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 4225 "PhotoMonitor.c"
}


static gboolean photo_monitor_real_notify_file_altered (MediaMonitor* base, GFile* file) {
	PhotoMonitor * self;
	gboolean result = FALSE;
	LibraryPhotoSourceCollectionState state = 0;
	LibraryPhoto* photo = NULL;
	GFile* _tmp0_ = NULL;
	LibraryPhotoSourceCollectionState _tmp1_ = 0;
	LibraryPhoto* _tmp2_ = NULL;
	LibraryPhoto* _tmp3_ = NULL;
	LibraryPhotoSourceCollectionState _tmp4_ = 0;
#line 620 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 620 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 622 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = file;
#line 622 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = photo_monitor_get_photo_state_by_file (self, _tmp0_, &_tmp1_);
#line 622 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	state = _tmp1_;
#line 622 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo = _tmp2_;
#line 623 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = photo;
#line 623 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp3_ == NULL) {
#line 624 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		result = FALSE;
#line 624 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (photo);
#line 624 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return result;
#line 4261 "PhotoMonitor.c"
	}
#line 626 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = state;
#line 626 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	switch (_tmp4_) {
#line 626 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
#line 626 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
#line 626 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
#line 4273 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			LibraryPhoto* _tmp10_ = NULL;
			LibraryPhoto* _tmp11_ = NULL;
#line 630 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp5_ = photo;
#line 630 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp6_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DATA_OBJECT, DataObject));
#line 630 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp7_ = _tmp6_;
#line 630 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp8_ = g_strdup_printf ("Will reimport master for %s", _tmp7_);
#line 630 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp9_ = _tmp8_;
#line 630 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_mdbg (_tmp9_);
#line 630 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp9_);
#line 630 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp7_);
#line 631 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp10_ = photo;
#line 631 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_reimport_master (self, _tmp10_);
#line 632 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp11_ = photo;
#line 632 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_update_master_file_in_alteration (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_MONITORABLE, Monitorable), TRUE);
#line 633 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4308 "PhotoMonitor.c"
		}
#line 626 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
#line 4312 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			LibraryPhoto* _tmp17_ = NULL;
			LibraryPhoto* _tmp18_ = NULL;
#line 636 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp12_ = photo;
#line 636 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp13_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_DATA_OBJECT, DataObject));
#line 636 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp14_ = _tmp13_;
#line 636 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp15_ = g_strdup_printf ("Will reimport editable for %s", _tmp14_);
#line 636 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp16_ = _tmp15_;
#line 636 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_mdbg (_tmp16_);
#line 636 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp16_);
#line 636 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp14_);
#line 637 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp17_ = photo;
#line 637 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_reimport_editable (self, _tmp17_);
#line 638 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp18_ = photo;
#line 638 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_editable_file_in_alteration (self, _tmp18_, TRUE);
#line 639 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4347 "PhotoMonitor.c"
		}
#line 626 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
#line 4351 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			LibraryPhoto* _tmp24_ = NULL;
			LibraryPhoto* _tmp25_ = NULL;
#line 642 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp19_ = photo;
#line 642 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp20_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_DATA_OBJECT, DataObject));
#line 642 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp21_ = _tmp20_;
#line 642 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp22_ = g_strdup_printf ("Will reimport raw development for %s", _tmp21_);
#line 642 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp23_ = _tmp22_;
#line 642 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_mdbg (_tmp23_);
#line 642 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp23_);
#line 642 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp21_);
#line 643 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp24_ = photo;
#line 643 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_reimport_raw_developments (self, _tmp24_);
#line 644 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp25_ = photo;
#line 644 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_raw_development_file_in_alteration (self, _tmp25_, TRUE);
#line 645 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4386 "PhotoMonitor.c"
		}
		default:
		{
			LibraryPhotoSourceCollectionState _tmp26_ = 0;
			GEnumValue* _tmp27_;
#line 648 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp26_ = state;
#line 648 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp27_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), _tmp26_);
#line 648 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_error ("PhotoMonitor.vala:648: Unknown LibraryPhoto collection state %s", (_tmp27_ != NULL) ? _tmp27_->value_name : NULL);
#line 4398 "PhotoMonitor.c"
		}
	}
#line 651 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = TRUE;
#line 651 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (photo);
#line 651 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 4407 "PhotoMonitor.c"
}


static gboolean photo_monitor_real_notify_file_attributes_altered (MediaMonitor* base, GFile* file) {
	PhotoMonitor * self;
	gboolean result = FALSE;
	LibraryPhotoSourceCollectionState state = 0;
	LibraryPhoto* photo = NULL;
	GFile* _tmp0_ = NULL;
	LibraryPhotoSourceCollectionState _tmp1_ = 0;
	LibraryPhoto* _tmp2_ = NULL;
	LibraryPhoto* _tmp3_ = NULL;
	LibraryPhotoSourceCollectionState _tmp4_ = 0;
#line 654 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 654 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 656 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = file;
#line 656 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = photo_monitor_get_photo_state_by_file (self, _tmp0_, &_tmp1_);
#line 656 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	state = _tmp1_;
#line 656 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo = _tmp2_;
#line 657 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = photo;
#line 657 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp3_ == NULL) {
#line 658 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		result = FALSE;
#line 658 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (photo);
#line 658 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return result;
#line 4443 "PhotoMonitor.c"
	}
#line 660 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = state;
#line 660 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	switch (_tmp4_) {
#line 660 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
#line 660 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
#line 4453 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			LibraryPhoto* _tmp10_ = NULL;
			LibraryPhoto* _tmp11_ = NULL;
#line 663 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp5_ = photo;
#line 663 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp6_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DATA_OBJECT, DataObject));
#line 663 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp7_ = _tmp6_;
#line 663 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp8_ = g_strdup_printf ("Will update master file info for %s", _tmp7_);
#line 663 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp9_ = _tmp8_;
#line 663 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_mdbg (_tmp9_);
#line 663 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp9_);
#line 663 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp7_);
#line 664 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp10_ = photo;
#line 664 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_update_master_file_info_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_MONITORABLE, Monitorable));
#line 665 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp11_ = photo;
#line 665 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_update_master_file_in_alteration (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_MONITORABLE, Monitorable), TRUE);
#line 666 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4488 "PhotoMonitor.c"
		}
#line 660 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
#line 4492 "PhotoMonitor.c"
		{
			GFile* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			LibraryPhotoSourceCollectionState _tmp15_ = 0;
			GEnumValue* _tmp16_;
			LibraryPhoto* _tmp17_ = NULL;
#line 670 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp12_ = file;
#line 670 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp13_ = g_file_get_path (_tmp12_);
#line 670 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp14_ = _tmp13_;
#line 670 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp15_ = state;
#line 671 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp16_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), _tmp15_);
#line 670 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_warning ("PhotoMonitor.vala:670: File %s attributes altered in %s state", _tmp14_, (_tmp16_ != NULL) ? _tmp16_->value_name : NULL);
#line 670 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp14_);
#line 672 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp17_ = photo;
#line 672 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_update_master_file_in_alteration (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_MONITORABLE, Monitorable), TRUE);
#line 673 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4520 "PhotoMonitor.c"
		}
#line 660 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
#line 4524 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			LibraryPhoto* _tmp23_ = NULL;
			LibraryPhoto* _tmp24_ = NULL;
#line 676 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp18_ = photo;
#line 676 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp19_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_DATA_OBJECT, DataObject));
#line 676 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp20_ = _tmp19_;
#line 676 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp21_ = g_strdup_printf ("Will update editable file info for %s", _tmp20_);
#line 676 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp22_ = _tmp21_;
#line 676 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_mdbg (_tmp22_);
#line 676 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp22_);
#line 676 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp20_);
#line 677 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp23_ = photo;
#line 677 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_editable_file_info_altered (self, _tmp23_);
#line 678 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp24_ = photo;
#line 678 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_editable_file_in_alteration (self, _tmp24_, TRUE);
#line 679 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4559 "PhotoMonitor.c"
		}
#line 660 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
#line 4563 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
			LibraryPhoto* _tmp30_ = NULL;
			LibraryPhoto* _tmp31_ = NULL;
#line 682 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp25_ = photo;
#line 682 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp26_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, TYPE_DATA_OBJECT, DataObject));
#line 682 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp27_ = _tmp26_;
#line 682 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp28_ = g_strdup_printf ("Will update raw development file info for %s", _tmp27_);
#line 682 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp29_ = _tmp28_;
#line 682 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_mdbg (_tmp29_);
#line 682 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp29_);
#line 682 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp27_);
#line 683 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp30_ = photo;
#line 683 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_raw_development_file_info_altered (self, _tmp30_);
#line 684 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp31_ = photo;
#line 684 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_raw_development_file_in_alteration (self, _tmp31_, TRUE);
#line 685 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4598 "PhotoMonitor.c"
		}
		default:
		{
			LibraryPhotoSourceCollectionState _tmp32_ = 0;
			GEnumValue* _tmp33_;
#line 688 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp32_ = state;
#line 688 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp33_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), _tmp32_);
#line 688 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_error ("PhotoMonitor.vala:688: Unknown LibraryPhoto collection state %s", (_tmp33_ != NULL) ? _tmp33_->value_name : NULL);
#line 4610 "PhotoMonitor.c"
		}
	}
#line 691 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = TRUE;
#line 691 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (photo);
#line 691 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 4619 "PhotoMonitor.c"
}


static gboolean photo_monitor_real_notify_file_alteration_completed (MediaMonitor* base, GFile* file, GFileInfo* info) {
	PhotoMonitor * self;
	gboolean result = FALSE;
	LibraryPhotoSourceCollectionState state = 0;
	LibraryPhoto* photo = NULL;
	GFile* _tmp0_ = NULL;
	LibraryPhotoSourceCollectionState _tmp1_ = 0;
	LibraryPhoto* _tmp2_ = NULL;
	LibraryPhoto* _tmp3_ = NULL;
	LibraryPhotoSourceCollectionState _tmp4_ = 0;
#line 694 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 694 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 694 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), FALSE);
#line 696 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = file;
#line 696 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = photo_monitor_get_photo_state_by_file (self, _tmp0_, &_tmp1_);
#line 696 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	state = _tmp1_;
#line 696 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo = _tmp2_;
#line 697 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = photo;
#line 697 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp3_ == NULL) {
#line 698 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		result = FALSE;
#line 698 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (photo);
#line 698 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return result;
#line 4657 "PhotoMonitor.c"
	}
#line 700 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = state;
#line 700 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	switch (_tmp4_) {
#line 700 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
#line 700 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
#line 700 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
#line 4669 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp5_ = NULL;
			GFileInfo* _tmp6_ = NULL;
#line 704 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp5_ = photo;
#line 704 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp6_ = info;
#line 704 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_update_master_file_alterations_completed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_MONITORABLE, Monitorable), _tmp6_);
#line 705 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4681 "PhotoMonitor.c"
		}
#line 700 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
#line 4685 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp7_ = NULL;
			GFileInfo* _tmp8_ = NULL;
#line 708 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp7_ = photo;
#line 708 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp8_ = info;
#line 708 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_editable_file_alterations_completed (self, _tmp7_, _tmp8_);
#line 709 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4697 "PhotoMonitor.c"
		}
#line 700 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
#line 4701 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp9_ = NULL;
#line 712 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp9_ = photo;
#line 712 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_raw_development_file_alterations_completed (self, _tmp9_);
#line 713 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4710 "PhotoMonitor.c"
		}
		default:
		{
			LibraryPhotoSourceCollectionState _tmp10_ = 0;
			GEnumValue* _tmp11_;
#line 716 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp10_ = state;
#line 716 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp11_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), _tmp10_);
#line 716 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_error ("PhotoMonitor.vala:716: Unknown LibraryPhoto collection state %s", (_tmp11_ != NULL) ? _tmp11_->value_name : NULL);
#line 4722 "PhotoMonitor.c"
		}
	}
#line 719 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = TRUE;
#line 719 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (photo);
#line 719 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 4731 "PhotoMonitor.c"
}


static gboolean photo_monitor_real_notify_file_deleted (MediaMonitor* base, GFile* file) {
	PhotoMonitor * self;
	gboolean result = FALSE;
	LibraryPhotoSourceCollectionState state = 0;
	LibraryPhoto* photo = NULL;
	GFile* _tmp0_ = NULL;
	LibraryPhotoSourceCollectionState _tmp1_ = 0;
	LibraryPhoto* _tmp2_ = NULL;
	LibraryPhoto* _tmp3_ = NULL;
	LibraryPhotoSourceCollectionState _tmp4_ = 0;
#line 722 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 722 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 724 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = file;
#line 724 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = photo_monitor_get_photo_state_by_file (self, _tmp0_, &_tmp1_);
#line 724 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	state = _tmp1_;
#line 724 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo = _tmp2_;
#line 725 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = photo;
#line 725 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp3_ == NULL) {
#line 726 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		result = FALSE;
#line 726 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (photo);
#line 726 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return result;
#line 4767 "PhotoMonitor.c"
	}
#line 728 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = state;
#line 728 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	switch (_tmp4_) {
#line 728 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
#line 4775 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			LibraryPhoto* _tmp10_ = NULL;
			LibraryPhoto* _tmp11_ = NULL;
#line 730 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp5_ = photo;
#line 730 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp6_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DATA_OBJECT, DataObject));
#line 730 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp7_ = _tmp6_;
#line 730 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp8_ = g_strdup_printf ("Will mark %s offline", _tmp7_);
#line 730 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp9_ = _tmp8_;
#line 730 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_mdbg (_tmp9_);
#line 730 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp9_);
#line 730 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp7_);
#line 731 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp10_ = photo;
#line 731 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_update_offline (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_MONITORABLE, Monitorable));
#line 732 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp11_ = photo;
#line 732 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_update_master_file_in_alteration (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_MONITORABLE, Monitorable), FALSE);
#line 733 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4810 "PhotoMonitor.c"
		}
#line 728 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
#line 728 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
#line 4816 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp12_ = NULL;
#line 738 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp12_ = photo;
#line 738 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_update_master_file_in_alteration (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_MONITORABLE, Monitorable), FALSE);
#line 739 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4825 "PhotoMonitor.c"
		}
#line 728 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
#line 4829 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			LibraryPhoto* _tmp18_ = NULL;
			LibraryPhoto* _tmp19_ = NULL;
#line 742 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp13_ = photo;
#line 742 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp14_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_DATA_OBJECT, DataObject));
#line 742 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp15_ = _tmp14_;
#line 742 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp16_ = g_strdup_printf ("Will revert %s to master", _tmp15_);
#line 742 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp17_ = _tmp16_;
#line 742 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_mdbg (_tmp17_);
#line 742 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp17_);
#line 742 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp15_);
#line 743 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp18_ = photo;
#line 743 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_revert_to_master (self, _tmp18_);
#line 744 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp19_ = photo;
#line 744 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_editable_file_in_alteration (self, _tmp19_, FALSE);
#line 745 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4864 "PhotoMonitor.c"
		}
#line 728 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
#line 4868 "PhotoMonitor.c"
		{
			LibraryPhoto* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			LibraryPhoto* _tmp25_ = NULL;
			LibraryPhoto* _tmp26_ = NULL;
			LibraryPhoto* _tmp27_ = NULL;
#line 748 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp20_ = photo;
#line 748 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp21_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_DATA_OBJECT, DataObject));
#line 748 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp22_ = _tmp21_;
#line 748 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp23_ = g_strdup_printf ("Will revert %s to master", _tmp22_);
#line 748 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp24_ = _tmp23_;
#line 748 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			media_monitor_mdbg (_tmp24_);
#line 748 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp24_);
#line 748 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_free0 (_tmp22_);
#line 749 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp25_ = photo;
#line 749 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_revert_to_master (self, _tmp25_);
#line 750 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp26_ = photo;
#line 750 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_editable_file_in_alteration (self, _tmp26_, FALSE);
#line 751 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp27_ = photo;
#line 751 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_monitor_update_raw_development_file_in_alteration (self, _tmp27_, FALSE);
#line 752 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			break;
#line 4908 "PhotoMonitor.c"
		}
		default:
		{
			LibraryPhotoSourceCollectionState _tmp28_ = 0;
			GEnumValue* _tmp29_;
#line 755 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp28_ = state;
#line 755 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp29_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), _tmp28_);
#line 755 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_error ("PhotoMonitor.vala:755: Unknown LibraryPhoto collection state %s", (_tmp29_ != NULL) ? _tmp29_->value_name : NULL);
#line 4920 "PhotoMonitor.c"
		}
	}
#line 758 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = TRUE;
#line 758 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (photo);
#line 758 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 4929 "PhotoMonitor.c"
}


static void photo_monitor_real_on_media_source_destroyed (MediaMonitor* base, DataSource* source) {
	PhotoMonitor * self;
	DataSource* _tmp0_ = NULL;
	DataSource* _tmp1_ = NULL;
#line 761 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 761 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_DATA_SOURCE (source));
#line 762 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = source;
#line 762 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	MEDIA_MONITOR_CLASS (photo_monitor_parent_class)->on_media_source_destroyed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), _tmp0_);
#line 764 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = source;
#line 764 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_monitor_cancel_reimports (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
#line 4949 "PhotoMonitor.c"
}


static LibraryPhoto* photo_monitor_get_photo_state_by_file (PhotoMonitor* self, GFile* file, LibraryPhotoSourceCollectionState* state) {
	LibraryPhotoSourceCollectionState _vala_state = 0;
	LibraryPhoto* result = NULL;
	GFile* real_file = NULL;
	gboolean _tmp0_ = FALSE;
	GFile* _tmp70_ = NULL;
	GFile* _tmp71_ = NULL;
	LibraryPhotoSourceCollection* _tmp73_ = NULL;
	LibraryPhotoSourceCollectionState _tmp74_ = 0;
	LibraryPhoto* _tmp75_ = NULL;
#line 767 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_MONITOR (self), NULL);
#line 767 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 768 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	real_file = NULL;
#line 769 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = media_monitor_has_pending_updates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor));
#line 769 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp0_) {
#line 4973 "PhotoMonitor.c"
		{
			GeeIterator* _monitorable_it = NULL;
			GeeCollection* _tmp1_ = NULL;
			GeeCollection* _tmp2_ = NULL;
			GeeIterator* _tmp3_ = NULL;
			GeeIterator* _tmp4_ = NULL;
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp1_ = media_monitor_get_monitorables (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor));
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp2_ = _tmp1_;
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp4_ = _tmp3_;
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_tmp2_);
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_monitorable_it = _tmp4_;
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			while (TRUE) {
#line 4994 "PhotoMonitor.c"
				GeeIterator* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
				Monitorable* monitorable = NULL;
				GeeIterator* _tmp7_ = NULL;
				gpointer _tmp8_ = NULL;
				LibraryPhoto* photo = NULL;
				Monitorable* _tmp9_ = NULL;
				LibraryPhoto* _tmp10_ = NULL;
				PhotoUpdates* updates = NULL;
				LibraryPhoto* _tmp11_ = NULL;
				PhotoUpdates* _tmp12_ = NULL;
				PhotoUpdates* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				PhotoUpdates* _tmp15_ = NULL;
				GFile* _tmp16_ = NULL;
				GFile* _tmp17_ = NULL;
				gboolean _tmp18_ = FALSE;
				gboolean _tmp26_ = FALSE;
				PhotoUpdates* _tmp27_ = NULL;
				GFile* _tmp28_ = NULL;
				GFile* _tmp29_ = NULL;
				gboolean _tmp30_ = FALSE;
				PhotoUpdates* _tmp39_ = NULL;
				GeeCollection* _tmp40_ = NULL;
				GeeCollection* _tmp41_ = NULL;
				gboolean _tmp42_ = FALSE;
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp5_ = _monitorable_it;
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp6_ = gee_iterator_next (_tmp5_);
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (!_tmp6_) {
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					break;
#line 5029 "PhotoMonitor.c"
				}
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp7_ = _monitorable_it;
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp8_ = gee_iterator_get (_tmp7_);
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				monitorable = (Monitorable*) _tmp8_;
#line 771 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp9_ = monitorable;
#line 771 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
#line 771 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo = _tmp10_;
#line 773 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp11_ = photo;
#line 773 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp12_ = photo_monitor_get_existing_photo_updates (self, _tmp11_);
#line 773 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				updates = _tmp12_;
#line 774 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp13_ = updates;
#line 774 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp13_ == NULL) {
#line 775 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_monitorable_updates_unref0 (updates);
#line 775 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (photo);
#line 775 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (monitorable);
#line 775 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					continue;
#line 5061 "PhotoMonitor.c"
				}
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp15_ = updates;
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp16_ = monitorable_updates_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp17_ = _tmp16_;
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp18_ = _tmp17_ != NULL;
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (_tmp17_);
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp18_) {
#line 5075 "PhotoMonitor.c"
					PhotoUpdates* _tmp19_ = NULL;
					GFile* _tmp20_ = NULL;
					GFile* _tmp21_ = NULL;
					GFile* _tmp22_ = NULL;
					gboolean _tmp23_ = FALSE;
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp19_ = updates;
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp20_ = monitorable_updates_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp21_ = _tmp20_;
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp22_ = file;
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp23_ = g_file_equal (_tmp21_, _tmp22_);
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp14_ = _tmp23_;
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (_tmp21_);
#line 5095 "PhotoMonitor.c"
				} else {
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp14_ = FALSE;
#line 5099 "PhotoMonitor.c"
				}
#line 777 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp14_) {
#line 5103 "PhotoMonitor.c"
					LibraryPhoto* _tmp24_ = NULL;
					GFile* _tmp25_ = NULL;
#line 778 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp24_ = photo;
#line 778 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp25_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_MEDIA_SOURCE, MediaSource));
#line 778 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (real_file);
#line 778 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					real_file = _tmp25_;
#line 780 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_monitorable_updates_unref0 (updates);
#line 780 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (photo);
#line 780 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (monitorable);
#line 780 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					break;
#line 5122 "PhotoMonitor.c"
				}
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp27_ = updates;
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp28_ = photo_updates_get_editable_file (_tmp27_);
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp29_ = _tmp28_;
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp30_ = _tmp29_ != NULL;
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (_tmp29_);
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp30_) {
#line 5136 "PhotoMonitor.c"
					PhotoUpdates* _tmp31_ = NULL;
					GFile* _tmp32_ = NULL;
					GFile* _tmp33_ = NULL;
					GFile* _tmp34_ = NULL;
					gboolean _tmp35_ = FALSE;
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp31_ = updates;
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp32_ = photo_updates_get_editable_file (_tmp31_);
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp33_ = _tmp32_;
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp34_ = file;
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp35_ = g_file_equal (_tmp33_, _tmp34_);
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp26_ = _tmp35_;
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (_tmp33_);
#line 5156 "PhotoMonitor.c"
				} else {
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp26_ = FALSE;
#line 5160 "PhotoMonitor.c"
				}
#line 783 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp26_) {
#line 5164 "PhotoMonitor.c"
					LibraryPhoto* _tmp36_ = NULL;
					GFile* _tmp37_ = NULL;
					GFile* _tmp38_ = NULL;
#line 784 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp36_ = photo;
#line 784 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp37_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, TYPE_PHOTO, Photo));
#line 784 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (real_file);
#line 784 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					real_file = _tmp37_;
#line 788 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp38_ = real_file;
#line 788 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					if (_tmp38_ == NULL) {
#line 789 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_vala_state = LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE;
#line 791 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						result = photo;
#line 791 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_monitorable_updates_unref0 (updates);
#line 791 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_object_unref0 (monitorable);
#line 791 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_object_unref0 (_monitorable_it);
#line 791 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_object_unref0 (real_file);
#line 791 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						if (state) {
#line 791 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							*state = _vala_state;
#line 5196 "PhotoMonitor.c"
						}
#line 791 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						return result;
#line 5200 "PhotoMonitor.c"
					}
#line 794 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_monitorable_updates_unref0 (updates);
#line 794 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (photo);
#line 794 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (monitorable);
#line 794 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					break;
#line 5210 "PhotoMonitor.c"
				}
#line 797 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp39_ = updates;
#line 797 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp40_ = photo_updates_get_raw_developer_files (_tmp39_);
#line 797 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp41_ = _tmp40_;
#line 797 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp42_ = _tmp41_ != NULL;
#line 797 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (_tmp41_);
#line 797 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp42_) {
#line 5224 "PhotoMonitor.c"
					gboolean found = FALSE;
					gboolean _tmp55_ = FALSE;
#line 798 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					found = FALSE;
#line 5229 "PhotoMonitor.c"
					{
						GeeIterator* _raw_it = NULL;
						PhotoUpdates* _tmp43_ = NULL;
						GeeCollection* _tmp44_ = NULL;
						GeeCollection* _tmp45_ = NULL;
						GeeIterator* _tmp46_ = NULL;
						GeeIterator* _tmp47_ = NULL;
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp43_ = updates;
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp44_ = photo_updates_get_raw_developer_files (_tmp43_);
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp45_ = _tmp44_;
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp46_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, GEE_TYPE_ITERABLE, GeeIterable));
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp47_ = _tmp46_;
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_object_unref0 (_tmp45_);
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_raw_it = _tmp47_;
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						while (TRUE) {
#line 5253 "PhotoMonitor.c"
							GeeIterator* _tmp48_ = NULL;
							gboolean _tmp49_ = FALSE;
							GFile* raw = NULL;
							GeeIterator* _tmp50_ = NULL;
							gpointer _tmp51_ = NULL;
							GFile* _tmp52_ = NULL;
							GFile* _tmp53_ = NULL;
							gboolean _tmp54_ = FALSE;
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp48_ = _raw_it;
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp49_ = gee_iterator_next (_tmp48_);
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							if (!_tmp49_) {
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
								break;
#line 5270 "PhotoMonitor.c"
							}
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp50_ = _raw_it;
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp51_ = gee_iterator_get (_tmp50_);
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							raw = (GFile*) _tmp51_;
#line 800 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp52_ = raw;
#line 800 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp53_ = file;
#line 800 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_tmp54_ = g_file_equal (_tmp52_, _tmp53_);
#line 800 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							if (_tmp54_) {
#line 801 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
								found = TRUE;
#line 803 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
								_g_object_unref0 (raw);
#line 803 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
								break;
#line 5292 "PhotoMonitor.c"
							}
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
							_g_object_unref0 (raw);
#line 5296 "PhotoMonitor.c"
						}
#line 799 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_object_unref0 (_raw_it);
#line 5300 "PhotoMonitor.c"
					}
#line 807 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp55_ = found;
#line 807 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					if (_tmp55_) {
#line 5306 "PhotoMonitor.c"
						GeeCollection* developed = NULL;
						LibraryPhoto* _tmp56_ = NULL;
						GeeCollection* _tmp57_ = NULL;
						GeeCollection* _tmp58_ = NULL;
#line 808 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp56_ = photo;
#line 808 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp57_ = photo_get_raw_developer_files (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, TYPE_PHOTO, Photo));
#line 808 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						developed = _tmp57_;
#line 809 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_tmp58_ = developed;
#line 809 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						if (_tmp58_ != NULL) {
#line 5321 "PhotoMonitor.c"
							{
								GeeIterator* _f_it = NULL;
								GeeCollection* _tmp59_ = NULL;
								GeeIterator* _tmp60_ = NULL;
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
								_tmp59_ = developed;
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
								_tmp60_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, GEE_TYPE_ITERABLE, GeeIterable));
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
								_f_it = _tmp60_;
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
								while (TRUE) {
#line 5334 "PhotoMonitor.c"
									GeeIterator* _tmp61_ = NULL;
									gboolean _tmp62_ = FALSE;
									GFile* f = NULL;
									GeeIterator* _tmp63_ = NULL;
									gpointer _tmp64_ = NULL;
									GFile* _tmp65_ = NULL;
									GFile* _tmp66_ = NULL;
									gboolean _tmp67_ = FALSE;
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
									_tmp61_ = _f_it;
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
									_tmp62_ = gee_iterator_next (_tmp61_);
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
									if (!_tmp62_) {
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
										break;
#line 5351 "PhotoMonitor.c"
									}
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
									_tmp63_ = _f_it;
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
									_tmp64_ = gee_iterator_get (_tmp63_);
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
									f = (GFile*) _tmp64_;
#line 811 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
									_tmp65_ = f;
#line 811 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
									_tmp66_ = file;
#line 811 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
									_tmp67_ = g_file_equal (_tmp65_, _tmp66_);
#line 811 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
									if (_tmp67_) {
#line 5367 "PhotoMonitor.c"
										GFile* _tmp68_ = NULL;
										GFile* _tmp69_ = NULL;
#line 812 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
										_tmp68_ = f;
#line 812 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
										_tmp69_ = _g_object_ref0 (_tmp68_);
#line 812 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
										_g_object_unref0 (real_file);
#line 812 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
										real_file = _tmp69_;
#line 813 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
										_vala_state = LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER;
#line 815 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
										_g_object_unref0 (f);
#line 815 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
										break;
#line 5384 "PhotoMonitor.c"
									}
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
									_g_object_unref0 (f);
#line 5388 "PhotoMonitor.c"
								}
#line 810 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
								_g_object_unref0 (_f_it);
#line 5392 "PhotoMonitor.c"
							}
						}
#line 821 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_object_unref0 (developed);
#line 821 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_monitorable_updates_unref0 (updates);
#line 821 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_object_unref0 (photo);
#line 821 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						_g_object_unref0 (monitorable);
#line 821 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
						break;
#line 5405 "PhotoMonitor.c"
					}
				}
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_monitorable_updates_unref0 (updates);
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (photo);
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (monitorable);
#line 5414 "PhotoMonitor.c"
			}
#line 770 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_monitorable_it);
#line 5418 "PhotoMonitor.c"
		}
	}
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp71_ = real_file;
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp70_ = _tmp71_;
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp70_ == NULL) {
#line 5427 "PhotoMonitor.c"
		GFile* _tmp72_ = NULL;
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp72_ = file;
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp70_ = _tmp72_;
#line 5433 "PhotoMonitor.c"
	}
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp73_ = library_photo_global;
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp75_ = library_photo_source_collection_get_state_by_file (_tmp73_, _tmp70_, &_tmp74_);
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_vala_state = _tmp74_;
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp75_;
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (real_file);
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (state) {
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		*state = _vala_state;
#line 5449 "PhotoMonitor.c"
	}
#line 827 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 5453 "PhotoMonitor.c"
}


PhotoUpdates* photo_monitor_fetch_photo_updates (PhotoMonitor* self, LibraryPhoto* photo) {
	PhotoUpdates* result = NULL;
	LibraryPhoto* _tmp0_ = NULL;
	MonitorableUpdates* _tmp1_ = NULL;
#line 830 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_MONITOR (self), NULL);
#line 830 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
#line 831 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo;
#line 831 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = media_monitor_fetch_updates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MONITORABLE, Monitorable));
#line 831 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_UPDATES, PhotoUpdates);
#line 831 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 5473 "PhotoMonitor.c"
}


PhotoUpdates* photo_monitor_get_existing_photo_updates (PhotoMonitor* self, LibraryPhoto* photo) {
	PhotoUpdates* result = NULL;
	LibraryPhoto* _tmp0_ = NULL;
	MonitorableUpdates* _tmp1_ = NULL;
	PhotoUpdates* _tmp2_ = NULL;
#line 834 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_MONITOR (self), NULL);
#line 834 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
#line 835 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo;
#line 835 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = media_monitor_get_existing_updates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MONITORABLE, Monitorable));
#line 835 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, TYPE_PHOTO_UPDATES) ? ((PhotoUpdates*) _tmp1_) : NULL;
#line 835 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp2_ == NULL) {
#line 835 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_monitorable_updates_unref0 (_tmp1_);
#line 5496 "PhotoMonitor.c"
	}
#line 835 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp2_;
#line 835 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 5502 "PhotoMonitor.c"
}


void photo_monitor_update_reimport_master (PhotoMonitor* self, LibraryPhoto* photo) {
	LibraryPhoto* _tmp0_ = NULL;
	PhotoUpdates* _tmp1_ = NULL;
	PhotoUpdates* _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	LibraryPhoto* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 838 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 838 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 839 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo;
#line 839 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo_monitor_fetch_photo_updates (self, _tmp0_);
#line 839 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = _tmp1_;
#line 839 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_reimport_master (_tmp2_, TRUE);
#line 839 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp2_);
#line 842 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = self->priv->master_reimport_pending;
#line 842 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = photo;
#line 842 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_);
#line 842 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp5_) {
#line 5535 "PhotoMonitor.c"
		GeeHashMap* _tmp6_ = NULL;
		LibraryPhoto* _tmp7_ = NULL;
		gpointer _tmp8_ = NULL;
		PhotoMonitorReimportMasterJob* _tmp9_ = NULL;
#line 843 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp6_ = self->priv->master_reimport_pending;
#line 843 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp7_ = photo;
#line 843 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp8_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp7_);
#line 843 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp9_ = (PhotoMonitorReimportMasterJob*) _tmp8_;
#line 843 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 843 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_background_job_unref0 (_tmp9_);
#line 5552 "PhotoMonitor.c"
	}
}


void photo_monitor_update_reimport_editable (PhotoMonitor* self, LibraryPhoto* photo) {
	LibraryPhoto* _tmp0_ = NULL;
	PhotoUpdates* _tmp1_ = NULL;
	PhotoUpdates* _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	LibraryPhoto* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 846 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 846 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 847 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo;
#line 847 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo_monitor_fetch_photo_updates (self, _tmp0_);
#line 847 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = _tmp1_;
#line 847 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_reimport_editable (_tmp2_, TRUE);
#line 847 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp2_);
#line 850 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = self->priv->editable_reimport_pending;
#line 850 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = photo;
#line 850 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_);
#line 850 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp5_) {
#line 5586 "PhotoMonitor.c"
		GeeHashMap* _tmp6_ = NULL;
		LibraryPhoto* _tmp7_ = NULL;
		gpointer _tmp8_ = NULL;
		PhotoMonitorReimportEditableJob* _tmp9_ = NULL;
#line 851 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp6_ = self->priv->editable_reimport_pending;
#line 851 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp7_ = photo;
#line 851 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp8_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp7_);
#line 851 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp9_ = (PhotoMonitorReimportEditableJob*) _tmp8_;
#line 851 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 851 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_background_job_unref0 (_tmp9_);
#line 5603 "PhotoMonitor.c"
	}
}


void photo_monitor_update_reimport_raw_developments (PhotoMonitor* self, LibraryPhoto* photo) {
	LibraryPhoto* _tmp0_ = NULL;
	PhotoUpdates* _tmp1_ = NULL;
	PhotoUpdates* _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	LibraryPhoto* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 854 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 854 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 855 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo;
#line 855 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo_monitor_fetch_photo_updates (self, _tmp0_);
#line 855 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = _tmp1_;
#line 855 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_reimport_raw_developments (_tmp2_, TRUE);
#line 855 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp2_);
#line 858 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = self->priv->raw_developments_reimport_pending;
#line 858 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = photo;
#line 858 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_);
#line 858 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp5_) {
#line 5637 "PhotoMonitor.c"
		GeeHashMap* _tmp6_ = NULL;
		LibraryPhoto* _tmp7_ = NULL;
		gpointer _tmp8_ = NULL;
		PhotoMonitorReimportRawDevelopmentJob* _tmp9_ = NULL;
#line 859 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp6_ = self->priv->raw_developments_reimport_pending;
#line 859 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp7_ = photo;
#line 859 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp8_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp7_);
#line 859 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp9_ = (PhotoMonitorReimportRawDevelopmentJob*) _tmp8_;
#line 859 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 859 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_background_job_unref0 (_tmp9_);
#line 5654 "PhotoMonitor.c"
	}
}


GFile* photo_monitor_get_editable_file (PhotoMonitor* self, LibraryPhoto* photo) {
	GFile* result = NULL;
	PhotoUpdates* updates = NULL;
	LibraryPhoto* _tmp0_ = NULL;
	PhotoUpdates* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	PhotoUpdates* _tmp4_ = NULL;
#line 862 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_MONITOR (self), NULL);
#line 862 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
#line 863 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo;
#line 863 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo_monitor_get_existing_photo_updates (self, _tmp0_);
#line 863 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	updates = _tmp1_;
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = updates;
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp4_ != NULL) {
#line 5681 "PhotoMonitor.c"
		PhotoUpdates* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5_ = updates;
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp6_ = photo_updates_get_editable_file (_tmp5_);
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp7_ = _tmp6_;
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = _tmp7_ != NULL;
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_tmp7_);
#line 5695 "PhotoMonitor.c"
	} else {
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = FALSE;
#line 5699 "PhotoMonitor.c"
	}
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp3_) {
#line 5703 "PhotoMonitor.c"
		PhotoUpdates* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp8_ = updates;
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp9_ = photo_updates_get_editable_file (_tmp8_);
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_tmp2_);
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp2_ = _tmp9_;
#line 5714 "PhotoMonitor.c"
	} else {
		LibraryPhoto* _tmp10_ = NULL;
		GFile* _tmp11_ = NULL;
#line 866 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp10_ = photo;
#line 866 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp11_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_PHOTO, Photo));
#line 866 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_tmp2_);
#line 866 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp2_ = _tmp11_;
#line 5726 "PhotoMonitor.c"
	}
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp2_;
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (updates);
#line 865 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 5734 "PhotoMonitor.c"
}


GeeCollection* photo_monitor_get_raw_development_files (PhotoMonitor* self, LibraryPhoto* photo) {
	GeeCollection* result = NULL;
	PhotoUpdates* updates = NULL;
	LibraryPhoto* _tmp0_ = NULL;
	PhotoUpdates* _tmp1_ = NULL;
	GeeCollection* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	PhotoUpdates* _tmp4_ = NULL;
#line 869 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_MONITOR (self), NULL);
#line 869 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
#line 870 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo;
#line 870 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo_monitor_get_existing_photo_updates (self, _tmp0_);
#line 870 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	updates = _tmp1_;
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = updates;
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp4_ != NULL) {
#line 5760 "PhotoMonitor.c"
		PhotoUpdates* _tmp5_ = NULL;
		GeeCollection* _tmp6_ = NULL;
		GeeCollection* _tmp7_ = NULL;
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5_ = updates;
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp6_ = photo_updates_get_raw_developer_files (_tmp5_);
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp7_ = _tmp6_;
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = _tmp7_ != NULL;
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_tmp7_);
#line 5774 "PhotoMonitor.c"
	} else {
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = FALSE;
#line 5778 "PhotoMonitor.c"
	}
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp3_) {
#line 5782 "PhotoMonitor.c"
		PhotoUpdates* _tmp8_ = NULL;
		GeeCollection* _tmp9_ = NULL;
#line 873 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp8_ = updates;
#line 873 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp9_ = photo_updates_get_raw_developer_files (_tmp8_);
#line 873 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_tmp2_);
#line 873 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp2_ = _tmp9_;
#line 5793 "PhotoMonitor.c"
	} else {
		LibraryPhoto* _tmp10_ = NULL;
		GeeCollection* _tmp11_ = NULL;
#line 873 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp10_ = photo;
#line 873 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp11_ = photo_get_raw_developer_files (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_PHOTO, Photo));
#line 873 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_tmp2_);
#line 873 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp2_ = _tmp11_;
#line 5805 "PhotoMonitor.c"
	}
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	result = _tmp2_;
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (updates);
#line 872 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return result;
#line 5813 "PhotoMonitor.c"
}


void photo_monitor_update_editable_file (PhotoMonitor* self, LibraryPhoto* photo, GFile* file) {
	LibraryPhoto* _tmp0_ = NULL;
	PhotoUpdates* _tmp1_ = NULL;
	PhotoUpdates* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
#line 876 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 876 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 876 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 877 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo;
#line 877 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo_monitor_fetch_photo_updates (self, _tmp0_);
#line 877 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = _tmp1_;
#line 877 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = file;
#line 877 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_editable_file (_tmp2_, _tmp3_);
#line 877 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp2_);
#line 5840 "PhotoMonitor.c"
}


void photo_monitor_update_editable_file_info_altered (PhotoMonitor* self, LibraryPhoto* photo) {
	LibraryPhoto* _tmp0_ = NULL;
	PhotoUpdates* _tmp1_ = NULL;
	PhotoUpdates* _tmp2_ = NULL;
#line 880 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 880 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 881 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo;
#line 881 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo_monitor_fetch_photo_updates (self, _tmp0_);
#line 881 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = _tmp1_;
#line 881 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_editable_file_info_altered (_tmp2_, TRUE);
#line 881 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp2_);
#line 5862 "PhotoMonitor.c"
}


void photo_monitor_update_raw_development_file (PhotoMonitor* self, LibraryPhoto* photo, GFile* file) {
	LibraryPhoto* _tmp0_ = NULL;
	PhotoUpdates* _tmp1_ = NULL;
	PhotoUpdates* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
#line 884 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 884 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 884 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 885 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo;
#line 885 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo_monitor_fetch_photo_updates (self, _tmp0_);
#line 885 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = _tmp1_;
#line 885 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = file;
#line 885 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_add_raw_developer_file (_tmp2_, _tmp3_);
#line 885 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp2_);
#line 5889 "PhotoMonitor.c"
}


void photo_monitor_update_raw_development_file_info_altered (PhotoMonitor* self, LibraryPhoto* photo) {
	LibraryPhoto* _tmp0_ = NULL;
	PhotoUpdates* _tmp1_ = NULL;
	PhotoUpdates* _tmp2_ = NULL;
#line 888 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 888 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 889 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo;
#line 889 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo_monitor_fetch_photo_updates (self, _tmp0_);
#line 889 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = _tmp1_;
#line 889 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_raw_developer_file_info_altered (_tmp2_, TRUE);
#line 889 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp2_);
#line 5911 "PhotoMonitor.c"
}


void photo_monitor_update_editable_file_in_alteration (PhotoMonitor* self, LibraryPhoto* photo, gboolean in_alteration) {
	LibraryPhoto* _tmp0_ = NULL;
	PhotoUpdates* _tmp1_ = NULL;
	PhotoUpdates* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 892 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 892 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 893 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo;
#line 893 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo_monitor_fetch_photo_updates (self, _tmp0_);
#line 893 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = _tmp1_;
#line 893 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = in_alteration;
#line 893 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_editable_in_alteration (_tmp2_, _tmp3_);
#line 893 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp2_);
#line 5936 "PhotoMonitor.c"
}


void photo_monitor_update_editable_file_alterations_completed (PhotoMonitor* self, LibraryPhoto* photo, GFileInfo* info) {
	LibraryPhoto* _tmp0_ = NULL;
	PhotoUpdates* _tmp1_ = NULL;
	PhotoUpdates* _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
	LibraryPhoto* _tmp4_ = NULL;
	PhotoUpdates* _tmp5_ = NULL;
	PhotoUpdates* _tmp6_ = NULL;
#line 896 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 896 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 896 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 897 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo;
#line 897 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo_monitor_fetch_photo_updates (self, _tmp0_);
#line 897 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = _tmp1_;
#line 897 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = info;
#line 897 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_editable_file_info (_tmp2_, _tmp3_);
#line 897 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp2_);
#line 898 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = photo;
#line 898 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = photo_monitor_fetch_photo_updates (self, _tmp4_);
#line 898 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp6_ = _tmp5_;
#line 898 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_editable_in_alteration (_tmp6_, FALSE);
#line 898 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp6_);
#line 5976 "PhotoMonitor.c"
}


void photo_monitor_update_raw_development_file_in_alteration (PhotoMonitor* self, LibraryPhoto* photo, gboolean in_alteration) {
	LibraryPhoto* _tmp0_ = NULL;
	PhotoUpdates* _tmp1_ = NULL;
	PhotoUpdates* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 901 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 901 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 902 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo;
#line 902 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo_monitor_fetch_photo_updates (self, _tmp0_);
#line 902 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = _tmp1_;
#line 902 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = in_alteration;
#line 902 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_raw_development_in_alteration (_tmp2_, _tmp3_);
#line 902 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp2_);
#line 6001 "PhotoMonitor.c"
}


void photo_monitor_update_raw_development_file_alterations_completed (PhotoMonitor* self, LibraryPhoto* photo) {
	LibraryPhoto* _tmp0_ = NULL;
	PhotoUpdates* _tmp1_ = NULL;
	PhotoUpdates* _tmp2_ = NULL;
#line 905 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 905 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 906 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo;
#line 906 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo_monitor_fetch_photo_updates (self, _tmp0_);
#line 906 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = _tmp1_;
#line 906 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_raw_development_in_alteration (_tmp2_, FALSE);
#line 906 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp2_);
#line 6023 "PhotoMonitor.c"
}


void photo_monitor_update_revert_to_master (PhotoMonitor* self, LibraryPhoto* photo) {
	LibraryPhoto* _tmp0_ = NULL;
	PhotoUpdates* _tmp1_ = NULL;
	PhotoUpdates* _tmp2_ = NULL;
#line 909 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 909 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 910 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = photo;
#line 910 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = photo_monitor_fetch_photo_updates (self, _tmp0_);
#line 910 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = _tmp1_;
#line 910 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_updates_set_revert_to_master (_tmp2_, TRUE);
#line 910 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_monitorable_updates_unref0 (_tmp2_);
#line 6045 "PhotoMonitor.c"
}


static gpointer _monitorable_updates_ref0 (gpointer self) {
#line 930 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return self ? monitorable_updates_ref (self) : NULL;
#line 6052 "PhotoMonitor.c"
}


static void photo_monitor_real_process_updates (MediaMonitor* base, GeeCollection* all_updates, TransactionController* controller, gint* op_count, GError** error) {
	PhotoMonitor * self;
	GeeCollection* _tmp0_ = NULL;
	TransactionController* _tmp1_ = NULL;
	GeeMap* set_editable_file = NULL;
	GeeMap* set_editable_file_info = NULL;
	GeeMap* set_raw_developer_files = NULL;
	GeeArrayList* revert_to_master = NULL;
	GeeArrayList* reimport_master = NULL;
	GeeArrayList* reimport_editable = NULL;
	GeeArrayList* reimport_raw_developments = NULL;
	gint reimport_job_count = 0;
	GeeMap* _tmp90_ = NULL;
	GeeMap* _tmp98_ = NULL;
	GeeArrayList* _tmp106_ = NULL;
	GeeArrayList* _tmp124_ = NULL;
	GeeArrayList* _tmp151_ = NULL;
	GeeArrayList* _tmp178_ = NULL;
	GError * _inner_error_ = NULL;
#line 913 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 913 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (GEE_IS_COLLECTION (all_updates));
#line 913 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (controller));
#line 915 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = all_updates;
#line 915 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = controller;
#line 915 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	MEDIA_MONITOR_CLASS (photo_monitor_parent_class)->process_updates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), _tmp0_, _tmp1_, op_count, &_inner_error_);
#line 915 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 915 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_propagate_error (error, _inner_error_);
#line 915 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 6093 "PhotoMonitor.c"
	}
#line 917 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	set_editable_file = NULL;
#line 918 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	set_editable_file_info = NULL;
#line 919 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	set_raw_developer_files = NULL;
#line 920 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	revert_to_master = NULL;
#line 921 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	reimport_master = NULL;
#line 922 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	reimport_editable = NULL;
#line 923 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	reimport_raw_developments = NULL;
#line 924 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	reimport_job_count = 0;
#line 6111 "PhotoMonitor.c"
	{
		GeeIterator* _monitorable_updates_it = NULL;
		GeeCollection* _tmp2_ = NULL;
		GeeIterator* _tmp3_ = NULL;
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp2_ = all_updates;
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_monitorable_updates_it = _tmp3_;
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		while (TRUE) {
#line 6124 "PhotoMonitor.c"
			GeeIterator* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			MonitorableUpdates* monitorable_updates = NULL;
			GeeIterator* _tmp6_ = NULL;
			gpointer _tmp7_ = NULL;
			gint _tmp8_ = 0;
			PhotoUpdates* updates = NULL;
			MonitorableUpdates* _tmp9_ = NULL;
			PhotoUpdates* _tmp10_ = NULL;
			PhotoUpdates* _tmp11_ = NULL;
			PhotoUpdates* _tmp12_ = NULL;
			GFile* _tmp13_ = NULL;
			GFile* _tmp14_ = NULL;
			gboolean _tmp15_ = FALSE;
			PhotoUpdates* _tmp26_ = NULL;
			GFileInfo* _tmp27_ = NULL;
			GFileInfo* _tmp28_ = NULL;
			gboolean _tmp29_ = FALSE;
			PhotoUpdates* _tmp40_ = NULL;
			GeeCollection* _tmp41_ = NULL;
			GeeCollection* _tmp42_ = NULL;
			gboolean _tmp43_ = FALSE;
			PhotoUpdates* _tmp54_ = NULL;
			gboolean _tmp55_ = FALSE;
			gboolean _tmp66_ = FALSE;
			PhotoUpdates* _tmp67_ = NULL;
			gboolean _tmp68_ = FALSE;
			gboolean _tmp78_ = FALSE;
			PhotoUpdates* _tmp79_ = NULL;
			gboolean _tmp80_ = FALSE;
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp4_ = _monitorable_updates_it;
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp5_ = gee_iterator_next (_tmp4_);
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (!_tmp5_) {
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				break;
#line 6163 "PhotoMonitor.c"
			}
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp6_ = _monitorable_updates_it;
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			monitorable_updates = (MonitorableUpdates*) _tmp7_;
#line 927 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp8_ = *op_count;
#line 927 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_tmp8_ >= MEDIA_MONITOR_MAX_OPERATIONS_PER_CYCLE) {
#line 928 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_monitorable_updates_unref0 (monitorable_updates);
#line 928 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				break;
#line 6179 "PhotoMonitor.c"
			}
#line 930 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp9_ = monitorable_updates;
#line 930 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp10_ = _monitorable_updates_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, TYPE_PHOTO_UPDATES) ? ((PhotoUpdates*) _tmp9_) : NULL);
#line 930 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			updates = _tmp10_;
#line 931 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp11_ = updates;
#line 931 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_tmp11_ == NULL) {
#line 932 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_monitorable_updates_unref0 (updates);
#line 932 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_monitorable_updates_unref0 (monitorable_updates);
#line 932 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				continue;
#line 6197 "PhotoMonitor.c"
			}
#line 934 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp12_ = updates;
#line 934 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp13_ = photo_updates_get_editable_file (_tmp12_);
#line 934 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp14_ = _tmp13_;
#line 934 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp15_ = _tmp14_ != NULL;
#line 934 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_tmp14_);
#line 934 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_tmp15_) {
#line 6211 "PhotoMonitor.c"
				GeeMap* _tmp16_ = NULL;
				GeeMap* _tmp18_ = NULL;
				PhotoUpdates* _tmp19_ = NULL;
				LibraryPhoto* _tmp20_ = NULL;
				PhotoUpdates* _tmp21_ = NULL;
				GFile* _tmp22_ = NULL;
				GFile* _tmp23_ = NULL;
				PhotoUpdates* _tmp24_ = NULL;
				gint _tmp25_ = 0;
#line 935 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp16_ = set_editable_file;
#line 935 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp16_ == NULL) {
#line 6225 "PhotoMonitor.c"
					GeeHashMap* _tmp17_ = NULL;
#line 936 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp17_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, g_object_unref, G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 936 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (set_editable_file);
#line 936 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					set_editable_file = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_MAP, GeeMap);
#line 6233 "PhotoMonitor.c"
				}
#line 938 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp18_ = set_editable_file;
#line 938 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp19_ = updates;
#line 938 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp20_ = _tmp19_->photo;
#line 938 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp21_ = updates;
#line 938 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp22_ = photo_updates_get_editable_file (_tmp21_);
#line 938 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp23_ = _tmp22_;
#line 938 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				gee_map_set (_tmp18_, _tmp20_, _tmp23_);
#line 938 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (_tmp23_);
#line 939 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp24_ = updates;
#line 939 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo_updates_set_editable_file (_tmp24_, NULL);
#line 940 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp25_ = *op_count;
#line 940 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				*op_count = _tmp25_ + 1;
#line 6259 "PhotoMonitor.c"
			}
#line 943 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp26_ = updates;
#line 943 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp27_ = photo_updates_get_editable_file_info (_tmp26_);
#line 943 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp28_ = _tmp27_;
#line 943 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp29_ = _tmp28_ != NULL;
#line 943 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_tmp28_);
#line 943 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_tmp29_) {
#line 6273 "PhotoMonitor.c"
				GeeMap* _tmp30_ = NULL;
				GeeMap* _tmp32_ = NULL;
				PhotoUpdates* _tmp33_ = NULL;
				LibraryPhoto* _tmp34_ = NULL;
				PhotoUpdates* _tmp35_ = NULL;
				GFileInfo* _tmp36_ = NULL;
				GFileInfo* _tmp37_ = NULL;
				PhotoUpdates* _tmp38_ = NULL;
				gint _tmp39_ = 0;
#line 944 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp30_ = set_editable_file_info;
#line 944 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp30_ == NULL) {
#line 6287 "PhotoMonitor.c"
					GeeHashMap* _tmp31_ = NULL;
#line 945 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp31_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_file_info_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 945 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (set_editable_file_info);
#line 945 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					set_editable_file_info = G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_MAP, GeeMap);
#line 6295 "PhotoMonitor.c"
				}
#line 947 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp32_ = set_editable_file_info;
#line 947 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp33_ = updates;
#line 947 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp34_ = _tmp33_->photo;
#line 947 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp35_ = updates;
#line 947 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp36_ = photo_updates_get_editable_file_info (_tmp35_);
#line 947 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp37_ = _tmp36_;
#line 947 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				gee_map_set (_tmp32_, _tmp34_, _tmp37_);
#line 947 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (_tmp37_);
#line 948 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp38_ = updates;
#line 948 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo_updates_set_editable_file_info (_tmp38_, NULL);
#line 949 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp39_ = *op_count;
#line 949 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				*op_count = _tmp39_ + 1;
#line 6321 "PhotoMonitor.c"
			}
#line 952 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp40_ = updates;
#line 952 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp41_ = photo_updates_get_raw_developer_files (_tmp40_);
#line 952 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp42_ = _tmp41_;
#line 952 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp43_ = _tmp42_ != NULL;
#line 952 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_tmp42_);
#line 952 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_tmp43_) {
#line 6335 "PhotoMonitor.c"
				GeeMap* _tmp44_ = NULL;
				GeeMap* _tmp46_ = NULL;
				PhotoUpdates* _tmp47_ = NULL;
				LibraryPhoto* _tmp48_ = NULL;
				PhotoUpdates* _tmp49_ = NULL;
				GeeCollection* _tmp50_ = NULL;
				GeeCollection* _tmp51_ = NULL;
				PhotoUpdates* _tmp52_ = NULL;
				gint _tmp53_ = 0;
#line 953 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp44_ = set_raw_developer_files;
#line 953 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp44_ == NULL) {
#line 6349 "PhotoMonitor.c"
					GeeHashMap* _tmp45_ = NULL;
#line 954 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp45_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, g_object_unref, GEE_TYPE_COLLECTION, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 954 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (set_raw_developer_files);
#line 954 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					set_raw_developer_files = G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, GEE_TYPE_MAP, GeeMap);
#line 6357 "PhotoMonitor.c"
				}
#line 956 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp46_ = set_raw_developer_files;
#line 956 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp47_ = updates;
#line 956 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp48_ = _tmp47_->photo;
#line 956 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp49_ = updates;
#line 956 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp50_ = photo_updates_get_raw_developer_files (_tmp49_);
#line 956 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp51_ = _tmp50_;
#line 956 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				gee_map_set (_tmp46_, _tmp48_, _tmp51_);
#line 956 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (_tmp51_);
#line 957 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp52_ = updates;
#line 957 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo_updates_clear_raw_developer_files (_tmp52_);
#line 958 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp53_ = *op_count;
#line 958 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				*op_count = _tmp53_ + 1;
#line 6383 "PhotoMonitor.c"
			}
#line 961 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp54_ = updates;
#line 961 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp55_ = photo_updates_is_revert_to_master (_tmp54_);
#line 961 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_tmp55_) {
#line 6391 "PhotoMonitor.c"
				GeeArrayList* _tmp56_ = NULL;
				GeeArrayList* _tmp58_ = NULL;
				gint _tmp59_ = 0;
				gint _tmp60_ = 0;
				gint _tmp65_ = 0;
#line 962 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp56_ = revert_to_master;
#line 962 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp56_ == NULL) {
#line 6401 "PhotoMonitor.c"
					GeeArrayList* _tmp57_ = NULL;
#line 963 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp57_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 963 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (revert_to_master);
#line 963 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					revert_to_master = _tmp57_;
#line 6409 "PhotoMonitor.c"
				}
#line 965 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp58_ = revert_to_master;
#line 965 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp59_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, GEE_TYPE_COLLECTION, GeeCollection));
#line 965 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp60_ = _tmp59_;
#line 965 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp60_ < PHOTO_MONITOR_MAX_REVERTS_PER_CYCLE) {
#line 6419 "PhotoMonitor.c"
					GeeArrayList* _tmp61_ = NULL;
					PhotoUpdates* _tmp62_ = NULL;
					LibraryPhoto* _tmp63_ = NULL;
					PhotoUpdates* _tmp64_ = NULL;
#line 966 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp61_ = revert_to_master;
#line 966 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp62_ = updates;
#line 966 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp63_ = _tmp62_->photo;
#line 966 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp63_);
#line 967 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp64_ = updates;
#line 967 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					photo_updates_set_revert_to_master (_tmp64_, FALSE);
#line 6436 "PhotoMonitor.c"
				}
#line 969 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp65_ = *op_count;
#line 969 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				*op_count = _tmp65_ + 1;
#line 6442 "PhotoMonitor.c"
			}
#line 972 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp67_ = updates;
#line 972 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp68_ = photo_updates_is_reimport_master (_tmp67_);
#line 972 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_tmp68_) {
#line 6450 "PhotoMonitor.c"
				gint _tmp69_ = 0;
#line 972 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp69_ = reimport_job_count;
#line 972 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp66_ = _tmp69_ < PHOTO_MONITOR_MAX_REIMPORT_JOBS_PER_CYCLE;
#line 6456 "PhotoMonitor.c"
			} else {
#line 972 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp66_ = FALSE;
#line 6460 "PhotoMonitor.c"
			}
#line 972 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_tmp66_) {
#line 6464 "PhotoMonitor.c"
				GeeArrayList* _tmp70_ = NULL;
				GeeArrayList* _tmp72_ = NULL;
				PhotoUpdates* _tmp73_ = NULL;
				LibraryPhoto* _tmp74_ = NULL;
				PhotoUpdates* _tmp75_ = NULL;
				gint _tmp76_ = 0;
				gint _tmp77_ = 0;
#line 973 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp70_ = reimport_master;
#line 973 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp70_ == NULL) {
#line 6476 "PhotoMonitor.c"
					GeeArrayList* _tmp71_ = NULL;
#line 974 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp71_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 974 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (reimport_master);
#line 974 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					reimport_master = _tmp71_;
#line 6484 "PhotoMonitor.c"
				}
#line 976 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp72_ = reimport_master;
#line 976 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp73_ = updates;
#line 976 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp74_ = _tmp73_->photo;
#line 976 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp74_);
#line 977 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp75_ = updates;
#line 977 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo_updates_set_reimport_master (_tmp75_, FALSE);
#line 978 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp76_ = reimport_job_count;
#line 978 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				reimport_job_count = _tmp76_ + 1;
#line 979 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp77_ = *op_count;
#line 979 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				*op_count = _tmp77_ + 1;
#line 6506 "PhotoMonitor.c"
			}
#line 982 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp79_ = updates;
#line 982 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp80_ = photo_updates_is_reimport_editable (_tmp79_);
#line 982 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_tmp80_) {
#line 6514 "PhotoMonitor.c"
				gint _tmp81_ = 0;
#line 982 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp81_ = reimport_job_count;
#line 982 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp78_ = _tmp81_ < PHOTO_MONITOR_MAX_REIMPORT_JOBS_PER_CYCLE;
#line 6520 "PhotoMonitor.c"
			} else {
#line 982 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp78_ = FALSE;
#line 6524 "PhotoMonitor.c"
			}
#line 982 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_tmp78_) {
#line 6528 "PhotoMonitor.c"
				GeeArrayList* _tmp82_ = NULL;
				GeeArrayList* _tmp84_ = NULL;
				PhotoUpdates* _tmp85_ = NULL;
				LibraryPhoto* _tmp86_ = NULL;
				PhotoUpdates* _tmp87_ = NULL;
				gint _tmp88_ = 0;
				gint _tmp89_ = 0;
#line 983 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp82_ = reimport_editable;
#line 983 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_tmp82_ == NULL) {
#line 6540 "PhotoMonitor.c"
					GeeArrayList* _tmp83_ = NULL;
#line 984 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_tmp83_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 984 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					_g_object_unref0 (reimport_editable);
#line 984 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					reimport_editable = _tmp83_;
#line 6548 "PhotoMonitor.c"
				}
#line 986 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp84_ = reimport_editable;
#line 986 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp85_ = updates;
#line 986 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp86_ = _tmp85_->photo;
#line 986 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp86_);
#line 987 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp87_ = updates;
#line 987 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo_updates_set_reimport_editable (_tmp87_, FALSE);
#line 988 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp88_ = reimport_job_count;
#line 988 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				reimport_job_count = _tmp88_ + 1;
#line 989 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp89_ = *op_count;
#line 989 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				*op_count = _tmp89_ + 1;
#line 6570 "PhotoMonitor.c"
			}
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_monitorable_updates_unref0 (updates);
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_monitorable_updates_unref0 (monitorable_updates);
#line 6576 "PhotoMonitor.c"
		}
#line 926 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_object_unref0 (_monitorable_updates_it);
#line 6580 "PhotoMonitor.c"
	}
#line 993 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp90_ = set_editable_file;
#line 993 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp90_ != NULL) {
#line 6586 "PhotoMonitor.c"
		GeeMap* _tmp91_ = NULL;
		gint _tmp92_ = 0;
		gint _tmp93_ = 0;
		gchar* _tmp94_ = NULL;
		gchar* _tmp95_ = NULL;
#line 994 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp91_ = set_editable_file;
#line 994 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp92_ = gee_map_get_size (_tmp91_);
#line 994 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp93_ = _tmp92_;
#line 994 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp94_ = g_strdup_printf ("Changing editable file of %d photos", _tmp93_);
#line 994 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp95_ = _tmp94_;
#line 994 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		media_monitor_mdbg (_tmp95_);
#line 994 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_free0 (_tmp95_);
#line 6606 "PhotoMonitor.c"
		{
			GeeMap* _tmp96_ = NULL;
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp96_ = set_editable_file;
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_set_many_editable_file (_tmp96_, &_inner_error_);
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 6617 "PhotoMonitor.c"
					goto __catch570_database_error;
				}
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (reimport_raw_developments);
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (reimport_editable);
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (reimport_master);
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (revert_to_master);
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (set_raw_developer_files);
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (set_editable_file_info);
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (set_editable_file);
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				g_clear_error (&_inner_error_);
#line 997 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				return;
#line 6640 "PhotoMonitor.c"
			}
		}
		goto __finally570;
		__catch570_database_error:
		{
			GError* err = NULL;
			GError* _tmp97_ = NULL;
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			err = _inner_error_;
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_inner_error_ = NULL;
#line 999 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp97_ = err;
#line 999 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			app_window_database_error (_tmp97_);
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_error_free0 (err);
#line 6658 "PhotoMonitor.c"
		}
		__finally570:
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_propagate_error (error, _inner_error_);
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (reimport_raw_developments);
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (reimport_editable);
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (reimport_master);
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (revert_to_master);
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (set_raw_developer_files);
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (set_editable_file_info);
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (set_editable_file);
#line 996 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			return;
#line 6681 "PhotoMonitor.c"
		}
	}
#line 1003 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp98_ = set_editable_file_info;
#line 1003 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp98_ != NULL) {
#line 6688 "PhotoMonitor.c"
		GeeMap* _tmp99_ = NULL;
		gint _tmp100_ = 0;
		gint _tmp101_ = 0;
		gchar* _tmp102_ = NULL;
		gchar* _tmp103_ = NULL;
#line 1004 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp99_ = set_editable_file_info;
#line 1004 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp100_ = gee_map_get_size (_tmp99_);
#line 1004 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp101_ = _tmp100_;
#line 1004 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp102_ = g_strdup_printf ("Updating %d editable files timestamps", _tmp101_);
#line 1004 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp103_ = _tmp102_;
#line 1004 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		media_monitor_mdbg (_tmp103_);
#line 1004 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_free0 (_tmp103_);
#line 6708 "PhotoMonitor.c"
		{
			GeeMap* _tmp104_ = NULL;
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp104_ = set_editable_file_info;
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			photo_update_many_editable_timestamps (_tmp104_, &_inner_error_);
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 6719 "PhotoMonitor.c"
					goto __catch571_database_error;
				}
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (reimport_raw_developments);
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (reimport_editable);
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (reimport_master);
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (revert_to_master);
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (set_raw_developer_files);
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (set_editable_file_info);
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (set_editable_file);
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				g_clear_error (&_inner_error_);
#line 1007 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				return;
#line 6742 "PhotoMonitor.c"
			}
		}
		goto __finally571;
		__catch571_database_error:
		{
			GError* err = NULL;
			GError* _tmp105_ = NULL;
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			err = _inner_error_;
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_inner_error_ = NULL;
#line 1009 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp105_ = err;
#line 1009 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			app_window_database_error (_tmp105_);
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_error_free0 (err);
#line 6760 "PhotoMonitor.c"
		}
		__finally571:
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_propagate_error (error, _inner_error_);
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (reimport_raw_developments);
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (reimport_editable);
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (reimport_master);
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (revert_to_master);
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (set_raw_developer_files);
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (set_editable_file_info);
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (set_editable_file);
#line 1006 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			return;
#line 6783 "PhotoMonitor.c"
		}
	}
#line 1013 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp106_ = revert_to_master;
#line 1013 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp106_ != NULL) {
#line 6790 "PhotoMonitor.c"
		GeeArrayList* _tmp107_ = NULL;
		gint _tmp108_ = 0;
		gint _tmp109_ = 0;
		gchar* _tmp110_ = NULL;
		gchar* _tmp111_ = NULL;
#line 1014 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp107_ = revert_to_master;
#line 1014 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp108_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp107_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1014 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp109_ = _tmp108_;
#line 1014 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp110_ = g_strdup_printf ("Reverting %d photos to master", _tmp109_);
#line 1014 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp111_ = _tmp110_;
#line 1014 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		media_monitor_mdbg (_tmp111_);
#line 1014 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_free0 (_tmp111_);
#line 6810 "PhotoMonitor.c"
		{
			GeeArrayList* _photo_list = NULL;
			GeeArrayList* _tmp112_ = NULL;
			GeeArrayList* _tmp113_ = NULL;
			gint _photo_size = 0;
			GeeArrayList* _tmp114_ = NULL;
			gint _tmp115_ = 0;
			gint _tmp116_ = 0;
			gint _photo_index = 0;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp112_ = revert_to_master;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp113_ = _g_object_ref0 (_tmp112_);
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_list = _tmp113_;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp114_ = _photo_list;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp115_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp114_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp116_ = _tmp115_;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_size = _tmp116_;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_index = -1;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			while (TRUE) {
#line 6838 "PhotoMonitor.c"
				gint _tmp117_ = 0;
				gint _tmp118_ = 0;
				gint _tmp119_ = 0;
				LibraryPhoto* photo = NULL;
				GeeArrayList* _tmp120_ = NULL;
				gint _tmp121_ = 0;
				gpointer _tmp122_ = NULL;
				LibraryPhoto* _tmp123_ = NULL;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp117_ = _photo_index;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_photo_index = _tmp117_ + 1;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp118_ = _photo_index;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp119_ = _photo_size;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (!(_tmp118_ < _tmp119_)) {
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					break;
#line 6859 "PhotoMonitor.c"
				}
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp120_ = _photo_list;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp121_ = _photo_index;
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp122_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp120_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp121_);
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo = (LibraryPhoto*) _tmp122_;
#line 1017 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp123_ = photo;
#line 1017 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo_revert_to_master (G_TYPE_CHECK_INSTANCE_CAST (_tmp123_, TYPE_PHOTO, Photo), TRUE);
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (photo);
#line 6875 "PhotoMonitor.c"
			}
#line 1016 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_photo_list);
#line 6879 "PhotoMonitor.c"
		}
	}
#line 1024 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp124_ = reimport_master;
#line 1024 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp124_ != NULL) {
#line 6886 "PhotoMonitor.c"
		GeeArrayList* _tmp125_ = NULL;
		gint _tmp126_ = 0;
		gint _tmp127_ = 0;
		gchar* _tmp128_ = NULL;
		gchar* _tmp129_ = NULL;
#line 1025 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp125_ = reimport_master;
#line 1025 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp126_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp125_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1025 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp127_ = _tmp126_;
#line 1025 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp128_ = g_strdup_printf ("Reimporting %d masters", _tmp127_);
#line 1025 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp129_ = _tmp128_;
#line 1025 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		media_monitor_mdbg (_tmp129_);
#line 1025 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_free0 (_tmp129_);
#line 6906 "PhotoMonitor.c"
		{
			GeeArrayList* _photo_list = NULL;
			GeeArrayList* _tmp130_ = NULL;
			GeeArrayList* _tmp131_ = NULL;
			gint _photo_size = 0;
			GeeArrayList* _tmp132_ = NULL;
			gint _tmp133_ = 0;
			gint _tmp134_ = 0;
			gint _photo_index = 0;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp130_ = reimport_master;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp131_ = _g_object_ref0 (_tmp130_);
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_list = _tmp131_;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp132_ = _photo_list;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp133_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp134_ = _tmp133_;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_size = _tmp134_;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_index = -1;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			while (TRUE) {
#line 6934 "PhotoMonitor.c"
				gint _tmp135_ = 0;
				gint _tmp136_ = 0;
				gint _tmp137_ = 0;
				LibraryPhoto* photo = NULL;
				GeeArrayList* _tmp138_ = NULL;
				gint _tmp139_ = 0;
				gpointer _tmp140_ = NULL;
				GeeHashMap* _tmp141_ = NULL;
				LibraryPhoto* _tmp142_ = NULL;
				gboolean _tmp143_ = FALSE;
				PhotoMonitorReimportMasterJob* job = NULL;
				LibraryPhoto* _tmp144_ = NULL;
				PhotoMonitorReimportMasterJob* _tmp145_ = NULL;
				GeeHashMap* _tmp146_ = NULL;
				LibraryPhoto* _tmp147_ = NULL;
				PhotoMonitorReimportMasterJob* _tmp148_ = NULL;
				Workers* _tmp149_ = NULL;
				PhotoMonitorReimportMasterJob* _tmp150_ = NULL;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp135_ = _photo_index;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_photo_index = _tmp135_ + 1;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp136_ = _photo_index;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp137_ = _photo_size;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (!(_tmp136_ < _tmp137_)) {
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					break;
#line 6965 "PhotoMonitor.c"
				}
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp138_ = _photo_list;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp139_ = _photo_index;
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp140_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp138_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp139_);
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo = (LibraryPhoto*) _tmp140_;
#line 1028 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp141_ = self->priv->master_reimport_pending;
#line 1028 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp142_ = photo;
#line 1028 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp143_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp141_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp142_);
#line 1028 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_vala_assert (!_tmp143_, "!master_reimport_pending.has_key(photo)");
#line 1030 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp144_ = photo;
#line 1030 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp145_ = photo_monitor_reimport_master_job_new (self, _tmp144_);
#line 1030 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				job = _tmp145_;
#line 1031 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp146_ = self->priv->master_reimport_pending;
#line 1031 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp147_ = photo;
#line 1031 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp148_ = job;
#line 1031 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp146_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp147_, _tmp148_);
#line 1032 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp149_ = self->priv->workers;
#line 1032 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp150_ = job;
#line 1032 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				workers_enqueue (_tmp149_, G_TYPE_CHECK_INSTANCE_CAST (_tmp150_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_background_job_unref0 (job);
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (photo);
#line 7007 "PhotoMonitor.c"
			}
#line 1027 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_photo_list);
#line 7011 "PhotoMonitor.c"
		}
	}
#line 1036 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp151_ = reimport_editable;
#line 1036 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp151_ != NULL) {
#line 7018 "PhotoMonitor.c"
		GeeArrayList* _tmp152_ = NULL;
		gint _tmp153_ = 0;
		gint _tmp154_ = 0;
		gchar* _tmp155_ = NULL;
		gchar* _tmp156_ = NULL;
#line 1037 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp152_ = reimport_editable;
#line 1037 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp153_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp152_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1037 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp154_ = _tmp153_;
#line 1037 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp155_ = g_strdup_printf ("Reimporting %d editables", _tmp154_);
#line 1037 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp156_ = _tmp155_;
#line 1037 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		media_monitor_mdbg (_tmp156_);
#line 1037 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_free0 (_tmp156_);
#line 7038 "PhotoMonitor.c"
		{
			GeeArrayList* _photo_list = NULL;
			GeeArrayList* _tmp157_ = NULL;
			GeeArrayList* _tmp158_ = NULL;
			gint _photo_size = 0;
			GeeArrayList* _tmp159_ = NULL;
			gint _tmp160_ = 0;
			gint _tmp161_ = 0;
			gint _photo_index = 0;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp157_ = reimport_editable;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp158_ = _g_object_ref0 (_tmp157_);
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_list = _tmp158_;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp159_ = _photo_list;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp160_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp159_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp161_ = _tmp160_;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_size = _tmp161_;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_index = -1;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			while (TRUE) {
#line 7066 "PhotoMonitor.c"
				gint _tmp162_ = 0;
				gint _tmp163_ = 0;
				gint _tmp164_ = 0;
				LibraryPhoto* photo = NULL;
				GeeArrayList* _tmp165_ = NULL;
				gint _tmp166_ = 0;
				gpointer _tmp167_ = NULL;
				GeeHashMap* _tmp168_ = NULL;
				LibraryPhoto* _tmp169_ = NULL;
				gboolean _tmp170_ = FALSE;
				PhotoMonitorReimportEditableJob* job = NULL;
				LibraryPhoto* _tmp171_ = NULL;
				PhotoMonitorReimportEditableJob* _tmp172_ = NULL;
				GeeHashMap* _tmp173_ = NULL;
				LibraryPhoto* _tmp174_ = NULL;
				PhotoMonitorReimportEditableJob* _tmp175_ = NULL;
				Workers* _tmp176_ = NULL;
				PhotoMonitorReimportEditableJob* _tmp177_ = NULL;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp162_ = _photo_index;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_photo_index = _tmp162_ + 1;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp163_ = _photo_index;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp164_ = _photo_size;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (!(_tmp163_ < _tmp164_)) {
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					break;
#line 7097 "PhotoMonitor.c"
				}
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp165_ = _photo_list;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp166_ = _photo_index;
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp167_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp165_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp166_);
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo = (LibraryPhoto*) _tmp167_;
#line 1040 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp168_ = self->priv->editable_reimport_pending;
#line 1040 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp169_ = photo;
#line 1040 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp170_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp168_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp169_);
#line 1040 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_vala_assert (!_tmp170_, "!editable_reimport_pending.has_key(photo)");
#line 1042 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp171_ = photo;
#line 1042 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp172_ = photo_monitor_reimport_editable_job_new (self, _tmp171_);
#line 1042 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				job = _tmp172_;
#line 1043 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp173_ = self->priv->editable_reimport_pending;
#line 1043 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp174_ = photo;
#line 1043 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp175_ = job;
#line 1043 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp173_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp174_, _tmp175_);
#line 1044 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp176_ = self->priv->workers;
#line 1044 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp177_ = job;
#line 1044 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				workers_enqueue (_tmp176_, G_TYPE_CHECK_INSTANCE_CAST (_tmp177_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_background_job_unref0 (job);
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (photo);
#line 7139 "PhotoMonitor.c"
			}
#line 1039 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_photo_list);
#line 7143 "PhotoMonitor.c"
		}
	}
#line 1048 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp178_ = reimport_raw_developments;
#line 1048 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp178_ != NULL) {
#line 7150 "PhotoMonitor.c"
		GeeArrayList* _tmp179_ = NULL;
		gint _tmp180_ = 0;
		gint _tmp181_ = 0;
		gchar* _tmp182_ = NULL;
		gchar* _tmp183_ = NULL;
#line 1049 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp179_ = reimport_raw_developments;
#line 1049 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp180_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp179_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1049 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp181_ = _tmp180_;
#line 1049 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp182_ = g_strdup_printf ("Reimporting %d raw developments", _tmp181_);
#line 1049 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp183_ = _tmp182_;
#line 1049 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		media_monitor_mdbg (_tmp183_);
#line 1049 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_free0 (_tmp183_);
#line 7170 "PhotoMonitor.c"
		{
			GeeArrayList* _photo_list = NULL;
			GeeArrayList* _tmp184_ = NULL;
			GeeArrayList* _tmp185_ = NULL;
			gint _photo_size = 0;
			GeeArrayList* _tmp186_ = NULL;
			gint _tmp187_ = 0;
			gint _tmp188_ = 0;
			gint _photo_index = 0;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp184_ = reimport_raw_developments;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp185_ = _g_object_ref0 (_tmp184_);
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_list = _tmp185_;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp186_ = _photo_list;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp187_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp186_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_tmp188_ = _tmp187_;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_size = _tmp188_;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_photo_index = -1;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			while (TRUE) {
#line 7198 "PhotoMonitor.c"
				gint _tmp189_ = 0;
				gint _tmp190_ = 0;
				gint _tmp191_ = 0;
				LibraryPhoto* photo = NULL;
				GeeArrayList* _tmp192_ = NULL;
				gint _tmp193_ = 0;
				gpointer _tmp194_ = NULL;
				GeeHashMap* _tmp195_ = NULL;
				LibraryPhoto* _tmp196_ = NULL;
				gboolean _tmp197_ = FALSE;
				PhotoMonitorReimportRawDevelopmentJob* job = NULL;
				LibraryPhoto* _tmp198_ = NULL;
				PhotoMonitorReimportRawDevelopmentJob* _tmp199_ = NULL;
				GeeHashMap* _tmp200_ = NULL;
				LibraryPhoto* _tmp201_ = NULL;
				PhotoMonitorReimportRawDevelopmentJob* _tmp202_ = NULL;
				Workers* _tmp203_ = NULL;
				PhotoMonitorReimportRawDevelopmentJob* _tmp204_ = NULL;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp189_ = _photo_index;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_photo_index = _tmp189_ + 1;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp190_ = _photo_index;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp191_ = _photo_size;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				if (!(_tmp190_ < _tmp191_)) {
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
					break;
#line 7229 "PhotoMonitor.c"
				}
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp192_ = _photo_list;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp193_ = _photo_index;
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp194_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp192_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp193_);
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				photo = (LibraryPhoto*) _tmp194_;
#line 1052 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp195_ = self->priv->raw_developments_reimport_pending;
#line 1052 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp196_ = photo;
#line 1052 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp197_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp195_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp196_);
#line 1052 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_vala_assert (!_tmp197_, "!raw_developments_reimport_pending.has_key(photo)");
#line 1054 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp198_ = photo;
#line 1054 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp199_ = photo_monitor_reimport_raw_development_job_new (self, _tmp198_);
#line 1054 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				job = _tmp199_;
#line 1055 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp200_ = self->priv->raw_developments_reimport_pending;
#line 1055 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp201_ = photo;
#line 1055 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp202_ = job;
#line 1055 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp200_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp201_, _tmp202_);
#line 1056 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp203_ = self->priv->workers;
#line 1056 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_tmp204_ = job;
#line 1056 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				workers_enqueue (_tmp203_, G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_background_job_unref0 (job);
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
				_g_object_unref0 (photo);
#line 7271 "PhotoMonitor.c"
			}
#line 1051 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_g_object_unref0 (_photo_list);
#line 7275 "PhotoMonitor.c"
		}
	}
#line 913 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (reimport_raw_developments);
#line 913 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (reimport_editable);
#line 913 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (reimport_master);
#line 913 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (revert_to_master);
#line 913 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (set_raw_developer_files);
#line 913 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (set_editable_file_info);
#line 913 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (set_editable_file);
#line 7292 "PhotoMonitor.c"
}


static gpointer _background_job_ref0 (gpointer self) {
#line 1062 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return self ? background_job_ref (self) : NULL;
#line 7299 "PhotoMonitor.c"
}


static void photo_monitor_on_master_reimported (PhotoMonitor* self, BackgroundJob* j) {
	PhotoMonitorReimportMasterJob* job = NULL;
	BackgroundJob* _tmp0_ = NULL;
	PhotoMonitorReimportMasterJob* _tmp1_ = NULL;
	gboolean removed = FALSE;
	GeeHashMap* _tmp2_ = NULL;
	PhotoMonitorReimportMasterJob* _tmp3_ = NULL;
	LibraryPhoto* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	PhotoMonitorReimportMasterJob* _tmp7_ = NULL;
	GError* _tmp8_ = NULL;
	PhotoMonitorReimportMasterJob* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	PhotoMonitorReimportMasterJob* _tmp27_ = NULL;
	LibraryPhoto* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	PhotoMonitorReimportMasterJob* _tmp32_ = NULL;
	LibraryPhoto* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	GError * _inner_error_ = NULL;
#line 1061 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 1061 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (j));
#line 1062 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = j;
#line 1062 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, PhotoMonitorReimportMasterJob));
#line 1062 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	job = _tmp1_;
#line 1065 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = self->priv->master_reimport_pending;
#line 1065 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = job;
#line 1065 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = _tmp3_->photo;
#line 1065 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_, NULL);
#line 1065 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	removed = _tmp5_;
#line 1066 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp6_ = removed;
#line 1066 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_vala_assert (_tmp6_, "removed");
#line 1068 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp7_ = job;
#line 1068 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp8_ = _tmp7_->err;
#line 1068 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp8_ != NULL) {
#line 7357 "PhotoMonitor.c"
		PhotoMonitorReimportMasterJob* _tmp9_ = NULL;
		LibraryPhoto* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		PhotoMonitorReimportMasterJob* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		PhotoMonitorReimportMasterJob* _tmp16_ = NULL;
		LibraryPhoto* _tmp17_ = NULL;
#line 1069 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp9_ = job;
#line 1069 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp10_ = _tmp9_->photo;
#line 1069 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp11_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_OBJECT, DataObject));
#line 1069 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp12_ = _tmp11_;
#line 1069 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp13_ = job;
#line 1069 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp14_ = _tmp13_->err;
#line 1069 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp15_ = _tmp14_->message;
#line 1069 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_critical ("PhotoMonitor.vala:1069: Unable to reimport %s due to master file chang" \
"ing: %s", _tmp12_, _tmp15_);
#line 1069 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_free0 (_tmp12_);
#line 1072 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp16_ = job;
#line 1072 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp17_ = _tmp16_->photo;
#line 1072 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		media_monitor_update_offline (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_MONITORABLE, Monitorable));
#line 1074 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_background_job_unref0 (job);
#line 1074 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 7395 "PhotoMonitor.c"
	}
#line 1077 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp18_ = job;
#line 1077 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp19_ = _tmp18_->mark_online;
#line 1077 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (!_tmp19_) {
#line 7403 "PhotoMonitor.c"
		PhotoMonitorReimportMasterJob* _tmp20_ = NULL;
		LibraryPhoto* _tmp21_ = NULL;
#line 1079 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp20_ = job;
#line 1079 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp21_ = _tmp20_->photo;
#line 1079 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		media_monitor_update_offline (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_MONITORABLE, Monitorable));
#line 1081 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_background_job_unref0 (job);
#line 1081 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 7416 "PhotoMonitor.c"
	}
	{
		PhotoMonitorReimportMasterJob* _tmp22_ = NULL;
		LibraryPhoto* _tmp23_ = NULL;
		PhotoMonitorReimportMasterJob* _tmp24_ = NULL;
		PhotoReimportMasterState* _tmp25_ = NULL;
#line 1085 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp22_ = job;
#line 1085 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp23_ = _tmp22_->photo;
#line 1085 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp24_ = job;
#line 1085 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp25_ = _tmp24_->reimport_state;
#line 1085 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_finish_reimport_master (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_PHOTO, Photo), _tmp25_, &_inner_error_);
#line 1085 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1085 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 7437 "PhotoMonitor.c"
				goto __catch572_database_error;
			}
#line 1085 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_background_job_unref0 (job);
#line 1085 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1085 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_clear_error (&_inner_error_);
#line 1085 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			return;
#line 7448 "PhotoMonitor.c"
		}
	}
	goto __finally572;
	__catch572_database_error:
	{
		GError* err = NULL;
		GError* _tmp26_ = NULL;
#line 1084 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		err = _inner_error_;
#line 1084 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_inner_error_ = NULL;
#line 1087 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp26_ = err;
#line 1087 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		app_window_database_error (_tmp26_);
#line 1084 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_error_free0 (err);
#line 7466 "PhotoMonitor.c"
	}
	__finally572:
#line 1084 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1084 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_background_job_unref0 (job);
#line 1084 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1084 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_clear_error (&_inner_error_);
#line 1084 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 7479 "PhotoMonitor.c"
	}
#line 1091 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp27_ = job;
#line 1091 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp28_ = _tmp27_->photo;
#line 1091 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp29_ = media_source_is_offline (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, TYPE_MEDIA_SOURCE, MediaSource));
#line 1091 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp29_) {
#line 7489 "PhotoMonitor.c"
		PhotoMonitorReimportMasterJob* _tmp30_ = NULL;
		LibraryPhoto* _tmp31_ = NULL;
#line 1092 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp30_ = job;
#line 1092 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp31_ = _tmp30_->photo;
#line 1092 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		media_monitor_update_online (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, TYPE_MONITORABLE, Monitorable));
#line 7498 "PhotoMonitor.c"
	}
#line 1094 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp32_ = job;
#line 1094 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp33_ = _tmp32_->photo;
#line 1094 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp34_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, TYPE_DATA_OBJECT, DataObject));
#line 1094 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp35_ = _tmp34_;
#line 1094 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp36_ = g_strdup_printf ("Reimported master for %s", _tmp35_);
#line 1094 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp37_ = _tmp36_;
#line 1094 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	media_monitor_mdbg (_tmp37_);
#line 1094 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_free0 (_tmp37_);
#line 1094 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_free0 (_tmp35_);
#line 1061 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_background_job_unref0 (job);
#line 7520 "PhotoMonitor.c"
}


static void photo_monitor_on_master_reimport_cancelled (PhotoMonitor* self, BackgroundJob* j) {
	gboolean removed = FALSE;
	GeeHashMap* _tmp0_ = NULL;
	BackgroundJob* _tmp1_ = NULL;
	LibraryPhoto* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 1097 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 1097 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (j));
#line 1098 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->priv->master_reimport_pending;
#line 1098 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = j;
#line 1098 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, PhotoMonitorReimportMasterJob)->photo;
#line 1098 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp2_, NULL);
#line 1098 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	removed = _tmp3_;
#line 1099 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_vala_assert (removed, "removed");
#line 7546 "PhotoMonitor.c"
}


static void photo_monitor_on_editable_reimported (PhotoMonitor* self, BackgroundJob* j) {
	PhotoMonitorReimportEditableJob* job = NULL;
	BackgroundJob* _tmp0_ = NULL;
	PhotoMonitorReimportEditableJob* _tmp1_ = NULL;
	gboolean removed = FALSE;
	GeeHashMap* _tmp2_ = NULL;
	PhotoMonitorReimportEditableJob* _tmp3_ = NULL;
	LibraryPhoto* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	PhotoMonitorReimportEditableJob* _tmp7_ = NULL;
	GError* _tmp8_ = NULL;
	PhotoMonitorReimportEditableJob* _tmp21_ = NULL;
	LibraryPhoto* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	GError * _inner_error_ = NULL;
#line 1102 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 1102 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (j));
#line 1103 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = j;
#line 1103 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, PhotoMonitorReimportEditableJob));
#line 1103 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	job = _tmp1_;
#line 1106 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = self->priv->editable_reimport_pending;
#line 1106 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = job;
#line 1106 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = _tmp3_->photo;
#line 1106 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_, NULL);
#line 1106 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	removed = _tmp5_;
#line 1107 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp6_ = removed;
#line 1107 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_vala_assert (_tmp6_, "removed");
#line 1109 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp7_ = job;
#line 1109 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp8_ = _tmp7_->err;
#line 1109 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp8_ != NULL) {
#line 7599 "PhotoMonitor.c"
		PhotoMonitorReimportEditableJob* _tmp9_ = NULL;
		LibraryPhoto* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		PhotoMonitorReimportEditableJob* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
#line 1110 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp9_ = job;
#line 1110 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp10_ = _tmp9_->photo;
#line 1110 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp11_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_OBJECT, DataObject));
#line 1110 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp12_ = _tmp11_;
#line 1110 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp13_ = job;
#line 1110 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp14_ = _tmp13_->err;
#line 1110 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp15_ = _tmp14_->message;
#line 1110 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_critical ("PhotoMonitor.vala:1110: Unable to reimport editable %s: %s", _tmp12_, _tmp15_);
#line 1110 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_free0 (_tmp12_);
#line 1112 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_background_job_unref0 (job);
#line 1112 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 7629 "PhotoMonitor.c"
	}
	{
		PhotoMonitorReimportEditableJob* _tmp16_ = NULL;
		LibraryPhoto* _tmp17_ = NULL;
		PhotoMonitorReimportEditableJob* _tmp18_ = NULL;
		PhotoReimportEditableState* _tmp19_ = NULL;
#line 1116 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp16_ = job;
#line 1116 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp17_ = _tmp16_->photo;
#line 1116 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp18_ = job;
#line 1116 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp19_ = _tmp18_->state;
#line 1116 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_finish_reimport_editable (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_PHOTO, Photo), _tmp19_, &_inner_error_);
#line 1116 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1116 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 7650 "PhotoMonitor.c"
				goto __catch573_database_error;
			}
#line 1116 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_background_job_unref0 (job);
#line 1116 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1116 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_clear_error (&_inner_error_);
#line 1116 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			return;
#line 7661 "PhotoMonitor.c"
		}
	}
	goto __finally573;
	__catch573_database_error:
	{
		GError* err = NULL;
		GError* _tmp20_ = NULL;
#line 1115 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		err = _inner_error_;
#line 1115 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_inner_error_ = NULL;
#line 1118 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp20_ = err;
#line 1118 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		app_window_database_error (_tmp20_);
#line 1115 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_error_free0 (err);
#line 7679 "PhotoMonitor.c"
	}
	__finally573:
#line 1115 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1115 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_background_job_unref0 (job);
#line 1115 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1115 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_clear_error (&_inner_error_);
#line 1115 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 7692 "PhotoMonitor.c"
	}
#line 1121 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp21_ = job;
#line 1121 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp22_ = _tmp21_->photo;
#line 1121 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp23_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, TYPE_DATA_OBJECT, DataObject));
#line 1121 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp24_ = _tmp23_;
#line 1121 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp25_ = g_strdup_printf ("Reimported editable for %s", _tmp24_);
#line 1121 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp26_ = _tmp25_;
#line 1121 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	media_monitor_mdbg (_tmp26_);
#line 1121 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_free0 (_tmp26_);
#line 1121 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_free0 (_tmp24_);
#line 1102 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_background_job_unref0 (job);
#line 7714 "PhotoMonitor.c"
}


static void photo_monitor_on_editable_reimport_cancelled (PhotoMonitor* self, BackgroundJob* j) {
	gboolean removed = FALSE;
	GeeHashMap* _tmp0_ = NULL;
	BackgroundJob* _tmp1_ = NULL;
	LibraryPhoto* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 1124 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 1124 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (j));
#line 1125 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->priv->editable_reimport_pending;
#line 1125 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = j;
#line 1125 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, PhotoMonitorReimportEditableJob)->photo;
#line 1125 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp2_, NULL);
#line 1125 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	removed = _tmp3_;
#line 1126 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_vala_assert (removed, "removed");
#line 7740 "PhotoMonitor.c"
}


static void photo_monitor_on_raw_development_reimported (PhotoMonitor* self, BackgroundJob* j) {
	PhotoMonitorReimportRawDevelopmentJob* job = NULL;
	BackgroundJob* _tmp0_ = NULL;
	PhotoMonitorReimportRawDevelopmentJob* _tmp1_ = NULL;
	gboolean removed = FALSE;
	GeeHashMap* _tmp2_ = NULL;
	PhotoMonitorReimportRawDevelopmentJob* _tmp3_ = NULL;
	LibraryPhoto* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	PhotoMonitorReimportRawDevelopmentJob* _tmp7_ = NULL;
	GError* _tmp8_ = NULL;
	PhotoMonitorReimportRawDevelopmentJob* _tmp21_ = NULL;
	LibraryPhoto* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	GError * _inner_error_ = NULL;
#line 1129 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 1129 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (j));
#line 1130 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = j;
#line 1130 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, PhotoMonitorReimportRawDevelopmentJob));
#line 1130 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	job = _tmp1_;
#line 1133 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = self->priv->raw_developments_reimport_pending;
#line 1133 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = job;
#line 1133 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = _tmp3_->photo;
#line 1133 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_, NULL);
#line 1133 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	removed = _tmp5_;
#line 1134 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp6_ = removed;
#line 1134 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_vala_assert (_tmp6_, "removed");
#line 1136 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp7_ = job;
#line 1136 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp8_ = _tmp7_->err;
#line 1136 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (_tmp8_ != NULL) {
#line 7793 "PhotoMonitor.c"
		PhotoMonitorReimportRawDevelopmentJob* _tmp9_ = NULL;
		LibraryPhoto* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		PhotoMonitorReimportRawDevelopmentJob* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
#line 1137 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp9_ = job;
#line 1137 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp10_ = _tmp9_->photo;
#line 1137 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp11_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_OBJECT, DataObject));
#line 1137 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp12_ = _tmp11_;
#line 1137 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp13_ = job;
#line 1137 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp14_ = _tmp13_->err;
#line 1137 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp15_ = _tmp14_->message;
#line 1137 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_critical ("PhotoMonitor.vala:1137: Unable to reimport raw development %s: %s", _tmp12_, _tmp15_);
#line 1137 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_free0 (_tmp12_);
#line 1139 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_background_job_unref0 (job);
#line 1139 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 7823 "PhotoMonitor.c"
	}
	{
		PhotoMonitorReimportRawDevelopmentJob* _tmp16_ = NULL;
		LibraryPhoto* _tmp17_ = NULL;
		PhotoMonitorReimportRawDevelopmentJob* _tmp18_ = NULL;
		PhotoReimportRawDevelopmentState* _tmp19_ = NULL;
#line 1143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp16_ = job;
#line 1143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp17_ = _tmp16_->photo;
#line 1143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp18_ = job;
#line 1143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp19_ = _tmp18_->state;
#line 1143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		photo_finish_reimport_raw_development (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_PHOTO, Photo), _tmp19_, &_inner_error_);
#line 1143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 7844 "PhotoMonitor.c"
				goto __catch574_database_error;
			}
#line 1143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			_background_job_unref0 (job);
#line 1143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			g_clear_error (&_inner_error_);
#line 1143 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
			return;
#line 7855 "PhotoMonitor.c"
		}
	}
	goto __finally574;
	__catch574_database_error:
	{
		GError* err = NULL;
		GError* _tmp20_ = NULL;
#line 1142 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		err = _inner_error_;
#line 1142 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_inner_error_ = NULL;
#line 1145 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp20_ = err;
#line 1145 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		app_window_database_error (_tmp20_);
#line 1142 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_error_free0 (err);
#line 7873 "PhotoMonitor.c"
	}
	__finally574:
#line 1142 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1142 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_background_job_unref0 (job);
#line 1142 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1142 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_clear_error (&_inner_error_);
#line 1142 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 7886 "PhotoMonitor.c"
	}
#line 1148 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp21_ = job;
#line 1148 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp22_ = _tmp21_->photo;
#line 1148 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp23_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, TYPE_DATA_OBJECT, DataObject));
#line 1148 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp24_ = _tmp23_;
#line 1148 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp25_ = g_strdup_printf ("Reimported raw development for %s", _tmp24_);
#line 1148 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp26_ = _tmp25_;
#line 1148 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	media_monitor_mdbg (_tmp26_);
#line 1148 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_free0 (_tmp26_);
#line 1148 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_free0 (_tmp24_);
#line 1129 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_background_job_unref0 (job);
#line 7908 "PhotoMonitor.c"
}


static void photo_monitor_on_raw_development_reimport_cancelled (PhotoMonitor* self, BackgroundJob* j) {
	gboolean removed = FALSE;
	GeeHashMap* _tmp0_ = NULL;
	BackgroundJob* _tmp1_ = NULL;
	LibraryPhoto* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 1151 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_PHOTO_MONITOR (self));
#line 1151 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (j));
#line 1152 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = self->priv->raw_developments_reimport_pending;
#line 1152 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = j;
#line 1152 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, PhotoMonitorReimportRawDevelopmentJob)->photo;
#line 1152 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp2_, NULL);
#line 1152 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	removed = _tmp3_;
#line 1153 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_vala_assert (removed, "removed");
#line 7934 "PhotoMonitor.c"
}


static void _photo_monitor_on_master_reimported_completion_callback (BackgroundJob* job, gpointer self) {
#line 168 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_monitor_on_master_reimported ((PhotoMonitor*) self, job);
#line 7941 "PhotoMonitor.c"
}


static void _photo_monitor_on_master_reimport_cancelled_cancellation_callback (BackgroundJob* job, gpointer self) {
#line 168 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_monitor_on_master_reimport_cancelled ((PhotoMonitor*) self, job);
#line 7948 "PhotoMonitor.c"
}


static PhotoMonitorReimportMasterJob* photo_monitor_reimport_master_job_construct (GType object_type, PhotoMonitor* owner, LibraryPhoto* photo) {
	PhotoMonitorReimportMasterJob* self = NULL;
	PhotoMonitor* _tmp0_ = NULL;
	PhotoMonitor* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	PhotoMonitor* _tmp4_ = NULL;
	LibraryPhoto* _tmp5_ = NULL;
	LibraryPhoto* _tmp6_ = NULL;
#line 167 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_MONITOR (owner), NULL);
#line 167 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
#line 168 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = owner;
#line 168 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = owner;
#line 168 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = g_cancellable_new ();
#line 168 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = _tmp2_;
#line 168 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = owner;
#line 168 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = (PhotoMonitorReimportMasterJob*) background_job_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, G_TYPE_OBJECT, GObject), _photo_monitor_on_master_reimported_completion_callback, _tmp1_, _tmp3_, _photo_monitor_on_master_reimport_cancelled_cancellation_callback, _tmp4_, NULL);
#line 168 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (_tmp3_);
#line 171 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = photo;
#line 171 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 171 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->photo);
#line 171 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->photo = _tmp6_;
#line 167 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return self;
#line 7989 "PhotoMonitor.c"
}


static PhotoMonitorReimportMasterJob* photo_monitor_reimport_master_job_new (PhotoMonitor* owner, LibraryPhoto* photo) {
#line 167 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return photo_monitor_reimport_master_job_construct (PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, owner, photo);
#line 7996 "PhotoMonitor.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 178 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return self ? g_error_copy (self) : NULL;
#line 8003 "PhotoMonitor.c"
}


static void photo_monitor_reimport_master_job_real_execute (BackgroundJob* base) {
	PhotoMonitorReimportMasterJob * self;
	GError * _inner_error_ = NULL;
#line 174 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, PhotoMonitorReimportMasterJob);
#line 8012 "PhotoMonitor.c"
	{
		gboolean _tmp0_ = FALSE;
		LibraryPhoto* _tmp1_ = NULL;
		PhotoReimportMasterState* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 176 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = self->photo;
#line 176 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = photo_prepare_for_reimport_master (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO, Photo), &_tmp2_, &_inner_error_);
#line 176 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_photo_reimport_master_state_unref0 (self->reimport_state);
#line 176 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->reimport_state = _tmp2_;
#line 176 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = _tmp3_;
#line 176 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8030 "PhotoMonitor.c"
			goto __catch575_g_error;
		}
#line 176 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->mark_online = _tmp0_;
#line 8035 "PhotoMonitor.c"
	}
	goto __finally575;
	__catch575_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
#line 175 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		err = _inner_error_;
#line 175 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_inner_error_ = NULL;
#line 178 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp4_ = err;
#line 178 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5_ = _g_error_copy0 (_tmp4_);
#line 178 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_error_free0 (self->err);
#line 178 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->err = _tmp5_;
#line 175 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_error_free0 (err);
#line 8057 "PhotoMonitor.c"
	}
	__finally575:
#line 175 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 175 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 175 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_clear_error (&_inner_error_);
#line 175 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 8068 "PhotoMonitor.c"
	}
}


static void photo_monitor_reimport_master_job_class_init (PhotoMonitorReimportMasterJobClass * klass) {
#line 161 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_monitor_reimport_master_job_parent_class = g_type_class_peek_parent (klass);
#line 161 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((BackgroundJobClass *) klass)->finalize = photo_monitor_reimport_master_job_finalize;
#line 161 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((BackgroundJobClass *) klass)->execute = photo_monitor_reimport_master_job_real_execute;
#line 8080 "PhotoMonitor.c"
}


static void photo_monitor_reimport_master_job_instance_init (PhotoMonitorReimportMasterJob * self) {
#line 163 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->reimport_state = NULL;
#line 164 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->mark_online = FALSE;
#line 165 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->err = NULL;
#line 8091 "PhotoMonitor.c"
}


static void photo_monitor_reimport_master_job_finalize (BackgroundJob* obj) {
	PhotoMonitorReimportMasterJob * self;
#line 161 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, PhotoMonitorReimportMasterJob);
#line 162 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->photo);
#line 163 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_photo_reimport_master_state_unref0 (self->reimport_state);
#line 165 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_error_free0 (self->err);
#line 161 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	BACKGROUND_JOB_CLASS (photo_monitor_reimport_master_job_parent_class)->finalize (obj);
#line 8107 "PhotoMonitor.c"
}


static GType photo_monitor_reimport_master_job_get_type (void) {
	static volatile gsize photo_monitor_reimport_master_job_type_id__volatile = 0;
	if (g_once_init_enter (&photo_monitor_reimport_master_job_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoMonitorReimportMasterJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_monitor_reimport_master_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoMonitorReimportMasterJob), 0, (GInstanceInitFunc) photo_monitor_reimport_master_job_instance_init, NULL };
		GType photo_monitor_reimport_master_job_type_id;
		photo_monitor_reimport_master_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "PhotoMonitorReimportMasterJob", &g_define_type_info, 0);
		g_once_init_leave (&photo_monitor_reimport_master_job_type_id__volatile, photo_monitor_reimport_master_job_type_id);
	}
	return photo_monitor_reimport_master_job_type_id__volatile;
}


static void _photo_monitor_on_editable_reimported_completion_callback (BackgroundJob* job, gpointer self) {
#line 190 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_monitor_on_editable_reimported ((PhotoMonitor*) self, job);
#line 8126 "PhotoMonitor.c"
}


static void _photo_monitor_on_editable_reimport_cancelled_cancellation_callback (BackgroundJob* job, gpointer self) {
#line 190 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_monitor_on_editable_reimport_cancelled ((PhotoMonitor*) self, job);
#line 8133 "PhotoMonitor.c"
}


static PhotoMonitorReimportEditableJob* photo_monitor_reimport_editable_job_construct (GType object_type, PhotoMonitor* owner, LibraryPhoto* photo) {
	PhotoMonitorReimportEditableJob* self = NULL;
	PhotoMonitor* _tmp0_ = NULL;
	PhotoMonitor* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	PhotoMonitor* _tmp4_ = NULL;
	LibraryPhoto* _tmp5_ = NULL;
	LibraryPhoto* _tmp6_ = NULL;
#line 189 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_MONITOR (owner), NULL);
#line 189 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
#line 190 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = owner;
#line 190 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = owner;
#line 190 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = g_cancellable_new ();
#line 190 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = _tmp2_;
#line 190 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = owner;
#line 190 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = (PhotoMonitorReimportEditableJob*) background_job_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, G_TYPE_OBJECT, GObject), _photo_monitor_on_editable_reimported_completion_callback, _tmp1_, _tmp3_, _photo_monitor_on_editable_reimport_cancelled_cancellation_callback, _tmp4_, NULL);
#line 190 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (_tmp3_);
#line 193 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = photo;
#line 193 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 193 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->photo);
#line 193 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->photo = _tmp6_;
#line 189 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return self;
#line 8174 "PhotoMonitor.c"
}


static PhotoMonitorReimportEditableJob* photo_monitor_reimport_editable_job_new (PhotoMonitor* owner, LibraryPhoto* photo) {
#line 189 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return photo_monitor_reimport_editable_job_construct (PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, owner, photo);
#line 8181 "PhotoMonitor.c"
}


static void photo_monitor_reimport_editable_job_real_execute (BackgroundJob* base) {
	PhotoMonitorReimportEditableJob * self;
	GError * _inner_error_ = NULL;
#line 196 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, PhotoMonitorReimportEditableJob);
#line 8190 "PhotoMonitor.c"
	{
		gboolean _tmp0_ = FALSE;
		LibraryPhoto* _tmp1_ = NULL;
		PhotoReimportEditableState* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 198 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = self->photo;
#line 198 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = photo_prepare_for_reimport_editable (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO, Photo), &_tmp2_, &_inner_error_);
#line 198 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_photo_reimport_editable_state_unref0 (self->state);
#line 198 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->state = _tmp2_;
#line 198 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = _tmp3_;
#line 198 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8208 "PhotoMonitor.c"
			goto __catch576_g_error;
		}
#line 198 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->success = _tmp0_;
#line 8213 "PhotoMonitor.c"
	}
	goto __finally576;
	__catch576_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
#line 197 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		err = _inner_error_;
#line 197 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_inner_error_ = NULL;
#line 200 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp4_ = err;
#line 200 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5_ = _g_error_copy0 (_tmp4_);
#line 200 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_error_free0 (self->err);
#line 200 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->err = _tmp5_;
#line 197 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_error_free0 (err);
#line 8235 "PhotoMonitor.c"
	}
	__finally576:
#line 197 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 197 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 197 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_clear_error (&_inner_error_);
#line 197 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 8246 "PhotoMonitor.c"
	}
}


static void photo_monitor_reimport_editable_job_class_init (PhotoMonitorReimportEditableJobClass * klass) {
#line 183 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_monitor_reimport_editable_job_parent_class = g_type_class_peek_parent (klass);
#line 183 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((BackgroundJobClass *) klass)->finalize = photo_monitor_reimport_editable_job_finalize;
#line 183 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((BackgroundJobClass *) klass)->execute = photo_monitor_reimport_editable_job_real_execute;
#line 8258 "PhotoMonitor.c"
}


static void photo_monitor_reimport_editable_job_instance_init (PhotoMonitorReimportEditableJob * self) {
#line 185 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->state = NULL;
#line 186 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->success = FALSE;
#line 187 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->err = NULL;
#line 8269 "PhotoMonitor.c"
}


static void photo_monitor_reimport_editable_job_finalize (BackgroundJob* obj) {
	PhotoMonitorReimportEditableJob * self;
#line 183 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, PhotoMonitorReimportEditableJob);
#line 184 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->photo);
#line 185 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_photo_reimport_editable_state_unref0 (self->state);
#line 187 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_error_free0 (self->err);
#line 183 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	BACKGROUND_JOB_CLASS (photo_monitor_reimport_editable_job_parent_class)->finalize (obj);
#line 8285 "PhotoMonitor.c"
}


static GType photo_monitor_reimport_editable_job_get_type (void) {
	static volatile gsize photo_monitor_reimport_editable_job_type_id__volatile = 0;
	if (g_once_init_enter (&photo_monitor_reimport_editable_job_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoMonitorReimportEditableJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_monitor_reimport_editable_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoMonitorReimportEditableJob), 0, (GInstanceInitFunc) photo_monitor_reimport_editable_job_instance_init, NULL };
		GType photo_monitor_reimport_editable_job_type_id;
		photo_monitor_reimport_editable_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "PhotoMonitorReimportEditableJob", &g_define_type_info, 0);
		g_once_init_leave (&photo_monitor_reimport_editable_job_type_id__volatile, photo_monitor_reimport_editable_job_type_id);
	}
	return photo_monitor_reimport_editable_job_type_id__volatile;
}


static void _photo_monitor_on_raw_development_reimported_completion_callback (BackgroundJob* job, gpointer self) {
#line 212 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_monitor_on_raw_development_reimported ((PhotoMonitor*) self, job);
#line 8304 "PhotoMonitor.c"
}


static void _photo_monitor_on_raw_development_reimport_cancelled_cancellation_callback (BackgroundJob* job, gpointer self) {
#line 212 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_monitor_on_raw_development_reimport_cancelled ((PhotoMonitor*) self, job);
#line 8311 "PhotoMonitor.c"
}


static PhotoMonitorReimportRawDevelopmentJob* photo_monitor_reimport_raw_development_job_construct (GType object_type, PhotoMonitor* owner, LibraryPhoto* photo) {
	PhotoMonitorReimportRawDevelopmentJob* self = NULL;
	PhotoMonitor* _tmp0_ = NULL;
	PhotoMonitor* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	PhotoMonitor* _tmp4_ = NULL;
	LibraryPhoto* _tmp5_ = NULL;
	LibraryPhoto* _tmp6_ = NULL;
#line 211 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_PHOTO_MONITOR (owner), NULL);
#line 211 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
#line 212 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = owner;
#line 212 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = owner;
#line 212 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = g_cancellable_new ();
#line 212 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = _tmp2_;
#line 212 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = owner;
#line 212 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = (PhotoMonitorReimportRawDevelopmentJob*) background_job_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, G_TYPE_OBJECT, GObject), _photo_monitor_on_raw_development_reimported_completion_callback, _tmp1_, _tmp3_, _photo_monitor_on_raw_development_reimport_cancelled_cancellation_callback, _tmp4_, NULL);
#line 212 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (_tmp3_);
#line 215 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp5_ = photo;
#line 215 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 215 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->photo);
#line 215 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->photo = _tmp6_;
#line 211 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return self;
#line 8352 "PhotoMonitor.c"
}


static PhotoMonitorReimportRawDevelopmentJob* photo_monitor_reimport_raw_development_job_new (PhotoMonitor* owner, LibraryPhoto* photo) {
#line 211 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	return photo_monitor_reimport_raw_development_job_construct (PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, owner, photo);
#line 8359 "PhotoMonitor.c"
}


static void photo_monitor_reimport_raw_development_job_real_execute (BackgroundJob* base) {
	PhotoMonitorReimportRawDevelopmentJob * self;
	GError * _inner_error_ = NULL;
#line 218 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, PhotoMonitorReimportRawDevelopmentJob);
#line 8368 "PhotoMonitor.c"
	{
		gboolean _tmp0_ = FALSE;
		LibraryPhoto* _tmp1_ = NULL;
		PhotoReimportRawDevelopmentState* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 220 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp1_ = self->photo;
#line 220 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp3_ = photo_prepare_for_reimport_raw_development (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO, Photo), &_tmp2_, &_inner_error_);
#line 220 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_photo_reimport_raw_development_state_unref0 (self->state);
#line 220 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->state = _tmp2_;
#line 220 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp0_ = _tmp3_;
#line 220 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8386 "PhotoMonitor.c"
			goto __catch577_g_error;
		}
#line 220 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->success = _tmp0_;
#line 8391 "PhotoMonitor.c"
	}
	goto __finally577;
	__catch577_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
#line 219 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		err = _inner_error_;
#line 219 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_inner_error_ = NULL;
#line 222 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp4_ = err;
#line 222 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_tmp5_ = _g_error_copy0 (_tmp4_);
#line 222 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_error_free0 (self->err);
#line 222 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		self->err = _tmp5_;
#line 219 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		_g_error_free0 (err);
#line 8413 "PhotoMonitor.c"
	}
	__finally577:
#line 219 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 219 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 219 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		g_clear_error (&_inner_error_);
#line 219 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
		return;
#line 8424 "PhotoMonitor.c"
	}
}


static void photo_monitor_reimport_raw_development_job_class_init (PhotoMonitorReimportRawDevelopmentJobClass * klass) {
#line 205 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_monitor_reimport_raw_development_job_parent_class = g_type_class_peek_parent (klass);
#line 205 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((BackgroundJobClass *) klass)->finalize = photo_monitor_reimport_raw_development_job_finalize;
#line 205 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((BackgroundJobClass *) klass)->execute = photo_monitor_reimport_raw_development_job_real_execute;
#line 8436 "PhotoMonitor.c"
}


static void photo_monitor_reimport_raw_development_job_instance_init (PhotoMonitorReimportRawDevelopmentJob * self) {
#line 207 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->state = NULL;
#line 208 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->success = FALSE;
#line 209 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->err = NULL;
#line 8447 "PhotoMonitor.c"
}


static void photo_monitor_reimport_raw_development_job_finalize (BackgroundJob* obj) {
	PhotoMonitorReimportRawDevelopmentJob * self;
#line 205 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, PhotoMonitorReimportRawDevelopmentJob);
#line 206 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->photo);
#line 207 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_photo_reimport_raw_development_state_unref0 (self->state);
#line 209 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_error_free0 (self->err);
#line 205 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	BACKGROUND_JOB_CLASS (photo_monitor_reimport_raw_development_job_parent_class)->finalize (obj);
#line 8463 "PhotoMonitor.c"
}


static GType photo_monitor_reimport_raw_development_job_get_type (void) {
	static volatile gsize photo_monitor_reimport_raw_development_job_type_id__volatile = 0;
	if (g_once_init_enter (&photo_monitor_reimport_raw_development_job_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoMonitorReimportRawDevelopmentJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_monitor_reimport_raw_development_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoMonitorReimportRawDevelopmentJob), 0, (GInstanceInitFunc) photo_monitor_reimport_raw_development_job_instance_init, NULL };
		GType photo_monitor_reimport_raw_development_job_type_id;
		photo_monitor_reimport_raw_development_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "PhotoMonitorReimportRawDevelopmentJob", &g_define_type_info, 0);
		g_once_init_leave (&photo_monitor_reimport_raw_development_job_type_id__volatile, photo_monitor_reimport_raw_development_job_type_id);
	}
	return photo_monitor_reimport_raw_development_job_type_id__volatile;
}


static void photo_monitor_class_init (PhotoMonitorClass * klass) {
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	photo_monitor_parent_class = g_type_class_peek_parent (klass);
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	g_type_class_add_private (klass, sizeof (PhotoMonitorPrivate));
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->create_updates = photo_monitor_real_create_updates;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->get_media_source_collection = photo_monitor_real_get_media_source_collection;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->is_file_represented = photo_monitor_real_is_file_represented;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->close = photo_monitor_real_close;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_discovered = photo_monitor_real_notify_file_discovered;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->candidates_for_unknown_file = photo_monitor_real_candidates_for_unknown_file;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->get_auxilliary_backing_files = photo_monitor_real_get_auxilliary_backing_files;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->update_backing_file_info = photo_monitor_real_update_backing_file_info;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->notify_discovery_completing = photo_monitor_real_notify_discovery_completing;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_created = photo_monitor_real_notify_file_created;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_moved = photo_monitor_real_notify_file_moved;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_altered = photo_monitor_real_notify_file_altered;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_attributes_altered = photo_monitor_real_notify_file_attributes_altered;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_alteration_completed = photo_monitor_real_notify_file_alteration_completed;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->notify_file_deleted = photo_monitor_real_notify_file_deleted;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->on_media_source_destroyed = photo_monitor_real_on_media_source_destroyed;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	((MediaMonitorClass *) klass)->process_updates = photo_monitor_real_process_updates;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	G_OBJECT_CLASS (klass)->finalize = photo_monitor_finalize;
#line 8520 "PhotoMonitor.c"
}


static void photo_monitor_instance_init (PhotoMonitor * self) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	GeeHashMap* _tmp4_ = NULL;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->priv = PHOTO_MONITOR_GET_PRIVATE (self);
#line 228 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp0_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 228 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->priv->matched_editables = _tmp0_;
#line 229 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp1_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 229 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->priv->matched_developments = _tmp1_;
#line 230 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp2_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, g_object_unref, PHOTO_MONITOR_TYPE_REIMPORT_MASTER_JOB, (GBoxedCopyFunc) background_job_ref, background_job_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 230 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->priv->master_reimport_pending = _tmp2_;
#line 232 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp3_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, g_object_unref, PHOTO_MONITOR_TYPE_REIMPORT_EDITABLE_JOB, (GBoxedCopyFunc) background_job_ref, background_job_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 232 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->priv->editable_reimport_pending = _tmp3_;
#line 234 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_tmp4_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, g_object_unref, PHOTO_MONITOR_TYPE_REIMPORT_RAW_DEVELOPMENT_JOB, (GBoxedCopyFunc) background_job_ref, background_job_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 234 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self->priv->raw_developments_reimport_pending = _tmp4_;
#line 8552 "PhotoMonitor.c"
}


static void photo_monitor_finalize (GObject* obj) {
	PhotoMonitor * self;
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_MONITOR, PhotoMonitor);
#line 227 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_workers_unref0 (self->priv->workers);
#line 228 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->priv->matched_editables);
#line 229 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->priv->matched_developments);
#line 230 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->priv->master_reimport_pending);
#line 232 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->priv->editable_reimport_pending);
#line 234 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	_g_object_unref0 (self->priv->raw_developments_reimport_pending);
#line 157 "/home/jens/Source/shotwell/src/PhotoMonitor.vala"
	G_OBJECT_CLASS (photo_monitor_parent_class)->finalize (obj);
#line 8574 "PhotoMonitor.c"
}


GType photo_monitor_get_type (void) {
	static volatile gsize photo_monitor_type_id__volatile = 0;
	if (g_once_init_enter (&photo_monitor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoMonitor), 0, (GInstanceInitFunc) photo_monitor_instance_init, NULL };
		GType photo_monitor_type_id;
		photo_monitor_type_id = g_type_register_static (TYPE_MEDIA_MONITOR, "PhotoMonitor", &g_define_type_info, 0);
		g_once_init_leave (&photo_monitor_type_id__volatile, photo_monitor_type_id);
	}
	return photo_monitor_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



