/* DatabaseTable.c generated by valac 0.32.0.15-114e9, the Vala compiler
 * generated from DatabaseTable.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
typedef struct _ParamSpecDatabaseTable ParamSpecDatabaseTable;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()
struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _ParamSpecDatabaseTable {
	GParamSpec parent_instance;
};


static gpointer database_table_parent_class = NULL;
extern sqlite3* database_table_db;
sqlite3* database_table_db = NULL;
static gint database_table_in_transaction;
static gint database_table_in_transaction = 0;

GQuark database_error_quark (void);
gpointer database_table_ref (gpointer instance);
void database_table_unref (gpointer instance);
GParamSpec* param_spec_database_table (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_database_table (GValue* value, gpointer v_object);
void value_take_database_table (GValue* value, gpointer v_object);
gpointer value_get_database_table (const GValue* value);
GType database_table_get_type (void) G_GNUC_CONST;
enum  {
	DATABASE_TABLE_DUMMY_PROPERTY
};
#define DATABASE_TABLE_SCHEMA_VERSION 20
static void database_table_prepare_db (const gchar* filename);
void app_window_panic (const gchar* msg);
#define DB_IN_MEMORY_NAME ":memory:"
void database_table_on_trace (const gchar* message);
void database_table_init (const gchar* filename);
void database_table_warning (const gchar* op, gint res);
void database_table_terminate (void);
void database_table_fatal (const gchar* op, gint res);
void database_table_set_table_name (DatabaseTable* self, const gchar* table_name);
void database_table_throw_error (const gchar* method, gint res, GError** error);
gboolean database_table_exists_by_id (DatabaseTable* self, gint64 id);
gboolean database_table_select_by_id (DatabaseTable* self, gint64 id, const gchar* columns, sqlite3_stmt** stmt);
static void database_table_prepare_update_by_id (DatabaseTable* self, gint64 id, const gchar* column, sqlite3_stmt** stmt);
static gboolean database_table_execute_update_by_id (DatabaseTable* self, sqlite3_stmt* stmt);
gboolean database_table_update_text_by_id (DatabaseTable* self, gint64 id, const gchar* column, const gchar* text);
void database_table_update_text_by_id_2 (DatabaseTable* self, gint64 id, const gchar* column, const gchar* text, GError** error);
gboolean database_table_update_int_by_id (DatabaseTable* self, gint64 id, const gchar* column, gint value);
void database_table_update_int_by_id_2 (DatabaseTable* self, gint64 id, const gchar* column, gint value, GError** error);
gboolean database_table_update_int64_by_id (DatabaseTable* self, gint64 id, const gchar* column, gint64 value);
void database_table_update_int64_by_id_2 (DatabaseTable* self, gint64 id, const gchar* column, gint64 value, GError** error);
void database_table_delete_by_id (DatabaseTable* self, gint64 id, GError** error);
gboolean database_table_has_column (const gchar* table_name, const gchar* column_name);
gboolean database_table_has_table (const gchar* table_name);
gboolean database_table_add_column (const gchar* table_name, const gchar* column_name, const gchar* column_constraints);
gboolean database_table_ensure_column (const gchar* table_name, const gchar* column_name, const gchar* column_constraints, const gchar* upgrade_msg);
gint database_table_get_row_count (DatabaseTable* self);
void database_table_begin_transaction (void);
void database_table_commit_transaction (GError** error);
DatabaseTable* database_table_construct (GType object_type);
static void database_table_finalize (DatabaseTable* obj);


GQuark database_error_quark (void) {
	return g_quark_from_static_string ("database_error-quark");
}


static void database_table_prepare_db (const gchar* filename) {
	gint res = 0;
	const gchar* _tmp0_ = NULL;
	sqlite3* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	const gchar* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
#line 32 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (filename != NULL);
#line 34 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = filename;
#line 34 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = sqlite3_open_v2 (_tmp0_, &_tmp1_, SQLITE_OPEN_READWRITE | SQLITE_OPEN_CREATE, NULL);
#line 34 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_close0 (database_table_db);
#line 34 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_db = _tmp1_;
#line 34 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp2_;
#line 36 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = res;
#line 36 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp3_ != SQLITE_OK) {
#line 147 "DatabaseTable.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 37 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp4_ = _ ("Unable to open/create photo database %s: error code %d");
#line 37 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp5_ = filename;
#line 37 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp6_ = res;
#line 37 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp7_ = g_strdup_printf (_tmp4_, _tmp5_, _tmp6_);
#line 37 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp8_ = _tmp7_;
#line 37 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		app_window_panic (_tmp8_);
#line 37 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_g_free0 (_tmp8_);
#line 167 "DatabaseTable.c"
	}
#line 41 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = filename;
#line 41 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (g_strcmp0 (_tmp9_, DB_IN_MEMORY_NAME) != 0) {
#line 173 "DatabaseTable.c"
		{
			GFile* file_db = NULL;
			const gchar* _tmp10_ = NULL;
			GFile* _tmp11_ = NULL;
			GFileInfo* info = NULL;
			GFile* _tmp12_ = NULL;
			GFileInfo* _tmp13_ = NULL;
			GFileInfo* _tmp14_ = NULL;
			gboolean _tmp15_ = FALSE;
#line 43 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp10_ = filename;
#line 43 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp11_ = g_file_new_for_path (_tmp10_);
#line 43 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			file_db = _tmp11_;
#line 44 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp12_ = file_db;
#line 44 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp13_ = g_file_query_info (_tmp12_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 44 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			info = _tmp13_;
#line 44 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 44 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_object_unref0 (file_db);
#line 199 "DatabaseTable.c"
				goto __catch13_g_error;
			}
#line 45 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp14_ = info;
#line 45 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp15_ = g_file_info_get_attribute_boolean (_tmp14_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE);
#line 45 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (!_tmp15_) {
#line 208 "DatabaseTable.c"
				const gchar* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
#line 46 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_tmp16_ = _ ("Unable to write to photo database file:\n %s");
#line 46 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_tmp17_ = filename;
#line 46 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_tmp18_ = g_strdup_printf (_tmp16_, _tmp17_);
#line 46 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_tmp19_ = _tmp18_;
#line 46 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				app_window_panic (_tmp19_);
#line 46 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (_tmp19_);
#line 225 "DatabaseTable.c"
			}
#line 42 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_g_object_unref0 (info);
#line 42 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_g_object_unref0 (file_db);
#line 231 "DatabaseTable.c"
		}
		goto __finally13;
		__catch13_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			GError* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
#line 42 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			e = _inner_error_;
#line 42 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_inner_error_ = NULL;
#line 48 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp20_ = _ ("Error accessing database file:\n %s\n\nError was: \n%s");
#line 48 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp21_ = filename;
#line 48 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp22_ = e;
#line 48 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp23_ = _tmp22_->message;
#line 48 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp24_ = g_strdup_printf (_tmp20_, _tmp21_, _tmp23_);
#line 48 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp25_ = _tmp24_;
#line 48 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			app_window_panic (_tmp25_);
#line 48 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_g_free0 (_tmp25_);
#line 42 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_g_error_free0 (e);
#line 265 "DatabaseTable.c"
		}
		__finally13:
#line 42 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 42 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 42 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			g_clear_error (&_inner_error_);
#line 42 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			return;
#line 276 "DatabaseTable.c"
		}
	}
}


void database_table_on_trace (const gchar* message) {
	const gchar* _tmp0_ = NULL;
#line 57 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (message != NULL);
#line 58 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = message;
#line 58 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_debug ("DatabaseTable.vala:58: SQLITE: %s", _tmp0_);
#line 290 "DatabaseTable.c"
}


static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback callback, void* callback_target, gchar** errmsg) {
	gchar* _vala_errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	sqlite3_callback _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	const gchar* _tmp6_ = NULL;
#line 34 "/home/jens/jhbuild/install/share/vala-0.34/vapi/sqlite3.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 34 "/home/jens/jhbuild/install/share/vala-0.34/vapi/sqlite3.vapi"
	g_return_val_if_fail (sql != NULL, 0);
#line 36 "/home/jens/jhbuild/install/share/vala-0.34/vapi/sqlite3.vapi"
	_tmp0_ = sql;
#line 36 "/home/jens/jhbuild/install/share/vala-0.34/vapi/sqlite3.vapi"
	_tmp1_ = callback;
#line 36 "/home/jens/jhbuild/install/share/vala-0.34/vapi/sqlite3.vapi"
	_tmp1__target = callback_target;
#line 36 "/home/jens/jhbuild/install/share/vala-0.34/vapi/sqlite3.vapi"
	_tmp3_ = sqlite3_exec (self, _tmp0_, _tmp1_, _tmp1__target, (char**) (&_tmp2_));
#line 36 "/home/jens/jhbuild/install/share/vala-0.34/vapi/sqlite3.vapi"
	sqlite_errmsg = _tmp2_;
#line 36 "/home/jens/jhbuild/install/share/vala-0.34/vapi/sqlite3.vapi"
	ec = _tmp3_;
#line 37 "/home/jens/jhbuild/install/share/vala-0.34/vapi/sqlite3.vapi"
	if ((&_vala_errmsg) != NULL) {
#line 323 "DatabaseTable.c"
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 38 "/home/jens/jhbuild/install/share/vala-0.34/vapi/sqlite3.vapi"
		_tmp4_ = sqlite_errmsg;
#line 38 "/home/jens/jhbuild/install/share/vala-0.34/vapi/sqlite3.vapi"
		_tmp5_ = g_strdup (_tmp4_);
#line 38 "/home/jens/jhbuild/install/share/vala-0.34/vapi/sqlite3.vapi"
		_g_free0 (_vala_errmsg);
#line 38 "/home/jens/jhbuild/install/share/vala-0.34/vapi/sqlite3.vapi"
		_vala_errmsg = _tmp5_;
#line 334 "DatabaseTable.c"
	}
#line 40 "/home/jens/jhbuild/install/share/vala-0.34/vapi/sqlite3.vapi"
	_tmp6_ = sqlite_errmsg;
#line 40 "/home/jens/jhbuild/install/share/vala-0.34/vapi/sqlite3.vapi"
	sqlite3_free ((void*) _tmp6_);
#line 41 "/home/jens/jhbuild/install/share/vala-0.34/vapi/sqlite3.vapi"
	result = ec;
#line 41 "/home/jens/jhbuild/install/share/vala-0.34/vapi/sqlite3.vapi"
	if (errmsg) {
#line 41 "/home/jens/jhbuild/install/share/vala-0.34/vapi/sqlite3.vapi"
		*errmsg = _vala_errmsg;
#line 346 "DatabaseTable.c"
	} else {
#line 41 "/home/jens/jhbuild/install/share/vala-0.34/vapi/sqlite3.vapi"
		_g_free0 (_vala_errmsg);
#line 350 "DatabaseTable.c"
	}
#line 41 "/home/jens/jhbuild/install/share/vala-0.34/vapi/sqlite3.vapi"
	return result;
#line 354 "DatabaseTable.c"
}


void database_table_init (const gchar* filename) {
	const gchar* _tmp0_ = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp1_ = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	sqlite3* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	GError * _inner_error_ = NULL;
#line 61 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (filename != NULL);
#line 63 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = filename;
#line 63 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_prepare_db (_tmp0_);
#line 67 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = database_table_db;
#line 67 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = sqlite3_prepare_v2 (_tmp1_, "CREATE TABLE IF NOT EXISTS VersionTable (" "id INTEGER PRIMARY KEY, " "schema_version INTEGER, " "app_version TEXT, " "user_data TEXT NULL" ")", -1, &_tmp2_, NULL);
#line 67 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 67 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp2_;
#line 67 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp3_;
#line 75 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp4_ = res;
#line 75 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp4_ != SQLITE_OK) {
#line 390 "DatabaseTable.c"
		gchar* backup_path = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 76 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_sqlite3_close0 (database_table_db);
#line 76 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_db = NULL;
#line 78 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp5_ = filename;
#line 78 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp6_ = g_strconcat (_tmp5_, ".bak", NULL);
#line 78 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		backup_path = _tmp6_;
#line 404 "DatabaseTable.c"
		{
			GFile* src = NULL;
			const gchar* _tmp7_ = NULL;
			GFile* _tmp8_ = NULL;
			GFile* dest = NULL;
			const gchar* _tmp9_ = NULL;
			GFile* _tmp10_ = NULL;
			GFile* _tmp11_ = NULL;
			GFile* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
#line 81 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp7_ = backup_path;
#line 81 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp8_ = g_file_new_for_commandline_arg (_tmp7_);
#line 81 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			src = _tmp8_;
#line 82 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp9_ = filename;
#line 82 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp10_ = g_file_new_for_commandline_arg (_tmp9_);
#line 82 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			dest = _tmp10_;
#line 83 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp11_ = src;
#line 83 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp12_ = dest;
#line 83 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			g_file_copy (_tmp11_, _tmp12_, G_FILE_COPY_OVERWRITE | G_FILE_COPY_ALL_METADATA, NULL, NULL, NULL, &_inner_error_);
#line 83 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 83 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_object_unref0 (dest);
#line 83 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_object_unref0 (src);
#line 439 "DatabaseTable.c"
				goto __catch14_g_error;
			}
#line 86 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp13_ = filename;
#line 86 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			database_table_prepare_db (_tmp13_);
#line 80 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_g_object_unref0 (dest);
#line 80 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_g_object_unref0 (src);
#line 450 "DatabaseTable.c"
		}
		goto __finally14;
		__catch14_g_error:
		{
			GError* _error_ = NULL;
			const gchar* _tmp14_ = NULL;
			GError* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
#line 80 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_error_ = _inner_error_;
#line 80 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_inner_error_ = NULL;
#line 88 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp14_ = _ ("Unable to restore photo database %s");
#line 88 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp15_ = _error_;
#line 88 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp16_ = _tmp15_->message;
#line 88 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp17_ = g_strdup_printf (_tmp14_, _tmp16_);
#line 88 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp18_ = _tmp17_;
#line 88 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			app_window_panic (_tmp18_);
#line 88 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_g_free0 (_tmp18_);
#line 80 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_g_error_free0 (_error_);
#line 481 "DatabaseTable.c"
		}
		__finally14:
#line 80 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 80 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_g_free0 (backup_path);
#line 80 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_sqlite3_finalize0 (stmt);
#line 80 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 80 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			g_clear_error (&_inner_error_);
#line 80 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			return;
#line 496 "DatabaseTable.c"
		}
#line 75 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_g_free0 (backup_path);
#line 500 "DatabaseTable.c"
	}
#line 94 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp19_ = database_table_db;
#line 94 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp20_ = _sqlite3_exec (_tmp19_, "PRAGMA synchronous=OFF", NULL, NULL, NULL);
#line 94 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp20_;
#line 95 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp21_ = res;
#line 95 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp21_ != SQLITE_OK) {
#line 512 "DatabaseTable.c"
		gint _tmp22_ = 0;
#line 96 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp22_ = res;
#line 96 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_warning ("Unable to disable synchronous mode", _tmp22_);
#line 518 "DatabaseTable.c"
	}
#line 61 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 522 "DatabaseTable.c"
}


void database_table_terminate (void) {
#line 101 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_close0 (database_table_db);
#line 101 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_db = NULL;
#line 531 "DatabaseTable.c"
}


void database_table_fatal (const gchar* op, gint res) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	sqlite3* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 105 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (op != NULL);
#line 106 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = op;
#line 106 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = res;
#line 106 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = database_table_db;
#line 106 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = sqlite3_errmsg (_tmp2_);
#line 106 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_error ("DatabaseTable.vala:106: %s: [%d] %s", _tmp0_, _tmp1_, _tmp3_);
#line 552 "DatabaseTable.c"
}


void database_table_warning (const gchar* op, gint res) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	sqlite3* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 110 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (op != NULL);
#line 111 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = op;
#line 111 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = res;
#line 111 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = database_table_db;
#line 111 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = sqlite3_errmsg (_tmp2_);
#line 111 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_warning ("DatabaseTable.vala:111: %s: [%d] %s", _tmp0_, _tmp1_, _tmp3_);
#line 573 "DatabaseTable.c"
}


void database_table_set_table_name (DatabaseTable* self, const gchar* table_name) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 114 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (IS_DATABASE_TABLE (self));
#line 114 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (table_name != NULL);
#line 115 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = table_name;
#line 115 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 115 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_g_free0 (self->table_name);
#line 115 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	self->table_name = _tmp1_;
#line 592 "DatabaseTable.c"
}


void database_table_throw_error (const gchar* method, gint res, GError** error) {
	gchar* msg = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	sqlite3* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GError * _inner_error_ = NULL;
#line 120 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (method != NULL);
#line 121 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = method;
#line 121 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = res;
#line 121 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = database_table_db;
#line 121 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = sqlite3_errmsg (_tmp2_);
#line 121 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp4_ = g_strdup_printf ("(%s) [%d] - %s", _tmp0_, _tmp1_, _tmp3_);
#line 121 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	msg = _tmp4_;
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = res;
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	switch (_tmp5_) {
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_OK:
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_DONE:
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_ROW:
#line 629 "DatabaseTable.c"
		{
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_g_free0 (msg);
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			return;
#line 635 "DatabaseTable.c"
		}
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_PERM:
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_BUSY:
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_READONLY:
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_IOERR:
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_CORRUPT:
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_CANTOPEN:
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_NOLFS:
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_AUTH:
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_FORMAT:
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_NOTADB:
#line 657 "DatabaseTable.c"
		{
			const gchar* _tmp6_ = NULL;
			GError* _tmp7_ = NULL;
#line 139 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp6_ = msg;
#line 139 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp7_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_BACKING, _tmp6_);
#line 139 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_inner_error_ = _tmp7_;
#line 139 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 139 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_propagate_error (error, _inner_error_);
#line 139 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 139 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 675 "DatabaseTable.c"
			} else {
#line 139 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 139 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 139 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_clear_error (&_inner_error_);
#line 139 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 685 "DatabaseTable.c"
			}
		}
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_NOMEM:
#line 690 "DatabaseTable.c"
		{
			const gchar* _tmp8_ = NULL;
			GError* _tmp9_ = NULL;
#line 142 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp8_ = msg;
#line 142 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp9_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_MEMORY, _tmp8_);
#line 142 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_inner_error_ = _tmp9_;
#line 142 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 142 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_propagate_error (error, _inner_error_);
#line 142 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 142 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 708 "DatabaseTable.c"
			} else {
#line 142 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 142 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 142 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_clear_error (&_inner_error_);
#line 142 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 718 "DatabaseTable.c"
			}
		}
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_ABORT:
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_LOCKED:
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_INTERRUPT:
#line 727 "DatabaseTable.c"
		{
			const gchar* _tmp10_ = NULL;
			GError* _tmp11_ = NULL;
#line 147 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp10_ = msg;
#line 147 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp11_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_ABORT, _tmp10_);
#line 147 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_inner_error_ = _tmp11_;
#line 147 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 147 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_propagate_error (error, _inner_error_);
#line 147 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 147 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 745 "DatabaseTable.c"
			} else {
#line 147 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 147 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 147 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_clear_error (&_inner_error_);
#line 147 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 755 "DatabaseTable.c"
			}
		}
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_FULL:
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_EMPTY:
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_TOOBIG:
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_CONSTRAINT:
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_RANGE:
#line 768 "DatabaseTable.c"
		{
			const gchar* _tmp12_ = NULL;
			GError* _tmp13_ = NULL;
#line 154 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp12_ = msg;
#line 154 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp13_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_LIMITS, _tmp12_);
#line 154 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_inner_error_ = _tmp13_;
#line 154 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 154 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_propagate_error (error, _inner_error_);
#line 154 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 154 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 786 "DatabaseTable.c"
			} else {
#line 154 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 154 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 154 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_clear_error (&_inner_error_);
#line 154 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 796 "DatabaseTable.c"
			}
		}
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_SCHEMA:
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_MISMATCH:
#line 803 "DatabaseTable.c"
		{
			const gchar* _tmp14_ = NULL;
			GError* _tmp15_ = NULL;
#line 158 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp14_ = msg;
#line 158 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp15_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_TYPESPEC, _tmp14_);
#line 158 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_inner_error_ = _tmp15_;
#line 158 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 158 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_propagate_error (error, _inner_error_);
#line 158 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 158 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 821 "DatabaseTable.c"
			} else {
#line 158 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 158 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 158 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_clear_error (&_inner_error_);
#line 158 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 831 "DatabaseTable.c"
			}
		}
		default:
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_ERROR:
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_INTERNAL:
#line 123 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_MISUSE:
#line 841 "DatabaseTable.c"
		{
			const gchar* _tmp16_ = NULL;
			GError* _tmp17_ = NULL;
#line 164 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp16_ = msg;
#line 164 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp17_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_ERROR, _tmp16_);
#line 164 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_inner_error_ = _tmp17_;
#line 164 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 164 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_propagate_error (error, _inner_error_);
#line 164 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 164 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 859 "DatabaseTable.c"
			} else {
#line 164 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 164 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 164 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_clear_error (&_inner_error_);
#line 164 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 869 "DatabaseTable.c"
			}
		}
	}
#line 120 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_g_free0 (msg);
#line 875 "DatabaseTable.c"
}


gboolean database_table_exists_by_id (DatabaseTable* self, gint64 id) {
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	sqlite3_stmt* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	sqlite3_stmt* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	gint _tmp15_ = 0;
	gint _tmp24_ = 0;
#line 168 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (IS_DATABASE_TABLE (self), FALSE);
#line 170 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = database_table_db;
#line 170 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = self->table_name;
#line 170 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = g_strdup_printf ("SELECT id FROM %s WHERE id=?", _tmp1_);
#line 170 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = _tmp2_;
#line 170 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = sqlite3_prepare_v2 (_tmp0_, _tmp3_, -1, &_tmp4_, NULL);
#line 170 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 170 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp4_;
#line 170 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = _tmp5_;
#line 170 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_g_free0 (_tmp3_);
#line 170 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp6_;
#line 171 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = res;
#line 171 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 173 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp8_ = stmt;
#line 173 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = id;
#line 173 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp10_ = sqlite3_bind_int64 (_tmp8_, 1, _tmp9_);
#line 173 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp10_;
#line 174 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp11_ = res;
#line 174 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp11_ == SQLITE_OK, "res == Sqlite.OK");
#line 176 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp12_ = stmt;
#line 176 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp13_ = sqlite3_step (_tmp12_);
#line 176 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp13_;
#line 177 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp15_ = res;
#line 177 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp15_ != SQLITE_ROW) {
#line 948 "DatabaseTable.c"
		gint _tmp16_ = 0;
#line 177 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp16_ = res;
#line 177 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp14_ = _tmp16_ != SQLITE_DONE;
#line 954 "DatabaseTable.c"
	} else {
#line 177 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp14_ = FALSE;
#line 958 "DatabaseTable.c"
	}
#line 177 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp14_) {
#line 962 "DatabaseTable.c"
		gint64 _tmp17_ = 0LL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gint _tmp23_ = 0;
#line 178 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp17_ = id;
#line 178 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp18_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp17_);
#line 178 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp19_ = _tmp18_;
#line 178 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp20_ = self->table_name;
#line 178 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp21_ = g_strdup_printf ("exists_by_id [%s] %s", _tmp19_, _tmp20_);
#line 178 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp22_ = _tmp21_;
#line 178 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp23_ = res;
#line 178 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_fatal (_tmp22_, _tmp23_);
#line 178 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_g_free0 (_tmp22_);
#line 178 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_g_free0 (_tmp19_);
#line 990 "DatabaseTable.c"
	}
#line 180 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp24_ = res;
#line 180 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	result = _tmp24_ == SQLITE_ROW;
#line 180 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 180 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return result;
#line 1000 "DatabaseTable.c"
}


gboolean database_table_select_by_id (DatabaseTable* self, gint64 id, const gchar* columns, sqlite3_stmt** stmt) {
	sqlite3_stmt* _vala_stmt = NULL;
	gboolean result = FALSE;
	gchar* sql = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint res = 0;
	sqlite3* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	sqlite3_stmt* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	sqlite3_stmt* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	sqlite3_stmt* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	gint _tmp15_ = 0;
	gint _tmp25_ = 0;
#line 183 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (IS_DATABASE_TABLE (self), FALSE);
#line 183 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (columns != NULL, FALSE);
#line 184 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = columns;
#line 184 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = self->table_name;
#line 184 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = g_strdup_printf ("SELECT %s FROM %s WHERE id=?", _tmp0_, _tmp1_);
#line 184 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	sql = _tmp2_;
#line 186 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = database_table_db;
#line 186 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp4_ = sql;
#line 186 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = sqlite3_prepare_v2 (_tmp3_, _tmp4_, -1, &_tmp5_, NULL);
#line 186 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (_vala_stmt);
#line 186 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_stmt = _tmp5_;
#line 186 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp6_;
#line 187 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = res;
#line 187 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 189 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp8_ = _vala_stmt;
#line 189 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = id;
#line 189 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp10_ = sqlite3_bind_int64 (_tmp8_, 1, _tmp9_);
#line 189 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp10_;
#line 190 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp11_ = res;
#line 190 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp11_ == SQLITE_OK, "res == Sqlite.OK");
#line 192 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp12_ = _vala_stmt;
#line 192 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp13_ = sqlite3_step (_tmp12_);
#line 192 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp13_;
#line 193 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp15_ = res;
#line 193 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp15_ != SQLITE_ROW) {
#line 1076 "DatabaseTable.c"
		gint _tmp16_ = 0;
#line 193 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp16_ = res;
#line 193 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp14_ = _tmp16_ != SQLITE_DONE;
#line 1082 "DatabaseTable.c"
	} else {
#line 193 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp14_ = FALSE;
#line 1086 "DatabaseTable.c"
	}
#line 193 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp14_) {
#line 1090 "DatabaseTable.c"
		gint64 _tmp17_ = 0LL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gint _tmp24_ = 0;
#line 194 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp17_ = id;
#line 194 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp18_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp17_);
#line 194 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp19_ = _tmp18_;
#line 194 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp20_ = self->table_name;
#line 194 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp21_ = columns;
#line 194 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp22_ = g_strdup_printf ("select_by_id [%s] %s %s", _tmp19_, _tmp20_, _tmp21_);
#line 194 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp23_ = _tmp22_;
#line 194 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp24_ = res;
#line 194 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_fatal (_tmp23_, _tmp24_);
#line 194 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_g_free0 (_tmp23_);
#line 194 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_g_free0 (_tmp19_);
#line 1121 "DatabaseTable.c"
	}
#line 196 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp25_ = res;
#line 196 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	result = _tmp25_ == SQLITE_ROW;
#line 196 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_g_free0 (sql);
#line 196 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (stmt) {
#line 196 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		*stmt = _vala_stmt;
#line 1133 "DatabaseTable.c"
	} else {
#line 196 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_sqlite3_finalize0 (_vala_stmt);
#line 1137 "DatabaseTable.c"
	}
#line 196 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return result;
#line 1141 "DatabaseTable.c"
}


static void database_table_prepare_update_by_id (DatabaseTable* self, gint64 id, const gchar* column, sqlite3_stmt** stmt) {
	sqlite3_stmt* _vala_stmt = NULL;
	gchar* sql = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint res = 0;
	sqlite3* _tmp3_ = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint64 _tmp7_ = 0LL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
#line 200 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (IS_DATABASE_TABLE (self));
#line 200 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (column != NULL);
#line 201 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = self->table_name;
#line 201 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = column;
#line 201 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = g_strdup_printf ("UPDATE %s SET %s=? WHERE id=?", _tmp0_, _tmp1_);
#line 201 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	sql = _tmp2_;
#line 203 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = database_table_db;
#line 203 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = sqlite3_prepare_v2 (_tmp3_, sql, -1, &_tmp4_, NULL);
#line 203 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (_vala_stmt);
#line 203 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_stmt = _tmp4_;
#line 203 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp5_;
#line 204 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = res;
#line 204 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp6_ == SQLITE_OK, "res == Sqlite.OK");
#line 206 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = id;
#line 206 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp8_ = sqlite3_bind_int64 (_vala_stmt, 2, _tmp7_);
#line 206 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp8_;
#line 207 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = res;
#line 207 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp9_ == SQLITE_OK, "res == Sqlite.OK");
#line 200 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_g_free0 (sql);
#line 200 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (stmt) {
#line 200 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		*stmt = _vala_stmt;
#line 1201 "DatabaseTable.c"
	} else {
#line 200 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_sqlite3_finalize0 (_vala_stmt);
#line 1205 "DatabaseTable.c"
	}
}


static gboolean database_table_execute_update_by_id (DatabaseTable* self, sqlite3_stmt* stmt) {
	gboolean result = FALSE;
	gint res = 0;
	sqlite3_stmt* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 210 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (IS_DATABASE_TABLE (self), FALSE);
#line 210 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (stmt != NULL, FALSE);
#line 211 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = stmt;
#line 211 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = sqlite3_step (_tmp0_);
#line 211 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp1_;
#line 212 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = res;
#line 212 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp2_ != SQLITE_DONE) {
#line 1230 "DatabaseTable.c"
		gint _tmp3_ = 0;
#line 213 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp3_ = res;
#line 213 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_fatal ("execute_update_by_id", _tmp3_);
#line 215 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		result = FALSE;
#line 215 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		return result;
#line 1240 "DatabaseTable.c"
	}
#line 218 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	result = TRUE;
#line 218 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return result;
#line 1246 "DatabaseTable.c"
}


gboolean database_table_update_text_by_id (DatabaseTable* self, gint64 id, const gchar* column, const gchar* text) {
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint64 _tmp0_ = 0LL;
	const gchar* _tmp1_ = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	gint res = 0;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GDestroyNotify _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
#line 221 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (IS_DATABASE_TABLE (self), FALSE);
#line 221 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (column != NULL, FALSE);
#line 221 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (text != NULL, FALSE);
#line 223 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = id;
#line 223 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = column;
#line 223 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_prepare_update_by_id (self, _tmp0_, _tmp1_, &_tmp2_);
#line 223 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 223 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp2_;
#line 225 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = text;
#line 225 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 225 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = g_free;
#line 225 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = sqlite3_bind_text (stmt, 1, _tmp4_, -1, _tmp5_);
#line 225 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp6_;
#line 226 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
#line 228 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = database_table_execute_update_by_id (self, stmt);
#line 228 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	result = _tmp7_;
#line 228 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 228 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return result;
#line 1298 "DatabaseTable.c"
}


void database_table_update_text_by_id_2 (DatabaseTable* self, gint64 id, const gchar* column, const gchar* text, GError** error) {
	sqlite3_stmt* stmt = NULL;
	gint64 _tmp0_ = 0LL;
	const gchar* _tmp1_ = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	gint res = 0;
	sqlite3_stmt* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GDestroyNotify _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	sqlite3_stmt* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	GError * _inner_error_ = NULL;
#line 231 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (IS_DATABASE_TABLE (self));
#line 231 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (column != NULL);
#line 231 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (text != NULL);
#line 233 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = id;
#line 233 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = column;
#line 233 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_prepare_update_by_id (self, _tmp0_, _tmp1_, &_tmp2_);
#line 233 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 233 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp2_;
#line 235 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = stmt;
#line 235 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp4_ = text;
#line 235 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 235 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = g_free;
#line 235 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = sqlite3_bind_text (_tmp3_, 1, _tmp5_, -1, _tmp6_);
#line 235 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp7_;
#line 236 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp8_ = res;
#line 236 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp8_ == SQLITE_OK, "res == Sqlite.OK");
#line 238 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = stmt;
#line 238 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp10_ = sqlite3_step (_tmp9_);
#line 238 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp10_;
#line 239 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp11_ = res;
#line 239 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp11_ != SQLITE_DONE) {
#line 1360 "DatabaseTable.c"
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gint _tmp16_ = 0;
#line 240 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp12_ = self->table_name;
#line 240 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp13_ = column;
#line 240 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp14_ = g_strdup_printf ("DatabaseTable.update_text_by_id_2 %s.%s", _tmp12_, _tmp13_);
#line 240 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp15_ = _tmp14_;
#line 240 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp16_ = res;
#line 240 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_throw_error (_tmp15_, _tmp16_, &_inner_error_);
#line 240 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_g_free0 (_tmp15_);
#line 240 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 240 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 240 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_propagate_error (error, _inner_error_);
#line 240 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 240 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 1390 "DatabaseTable.c"
			} else {
#line 240 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 240 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 240 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_clear_error (&_inner_error_);
#line 240 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 1400 "DatabaseTable.c"
			}
		}
	}
#line 231 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1406 "DatabaseTable.c"
}


gboolean database_table_update_int_by_id (DatabaseTable* self, gint64 id, const gchar* column, gint value) {
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint64 _tmp0_ = 0LL;
	const gchar* _tmp1_ = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	gint res = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
#line 243 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (IS_DATABASE_TABLE (self), FALSE);
#line 243 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (column != NULL, FALSE);
#line 245 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = id;
#line 245 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = column;
#line 245 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_prepare_update_by_id (self, _tmp0_, _tmp1_, &_tmp2_);
#line 245 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 245 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp2_;
#line 247 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = value;
#line 247 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp4_ = sqlite3_bind_int (stmt, 1, _tmp3_);
#line 247 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp4_;
#line 248 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
#line 250 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = database_table_execute_update_by_id (self, stmt);
#line 250 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	result = _tmp5_;
#line 250 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 250 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return result;
#line 1450 "DatabaseTable.c"
}


void database_table_update_int_by_id_2 (DatabaseTable* self, gint64 id, const gchar* column, gint value, GError** error) {
	sqlite3_stmt* stmt = NULL;
	gint64 _tmp0_ = 0LL;
	const gchar* _tmp1_ = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	gint res = 0;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	sqlite3_stmt* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	GError * _inner_error_ = NULL;
#line 253 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (IS_DATABASE_TABLE (self));
#line 253 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (column != NULL);
#line 255 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = id;
#line 255 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = column;
#line 255 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_prepare_update_by_id (self, _tmp0_, _tmp1_, &_tmp2_);
#line 255 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 255 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp2_;
#line 257 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = stmt;
#line 257 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp4_ = value;
#line 257 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = sqlite3_bind_int (_tmp3_, 1, _tmp4_);
#line 257 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp5_;
#line 258 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = res;
#line 258 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp6_ == SQLITE_OK, "res == Sqlite.OK");
#line 260 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = stmt;
#line 260 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp8_ = sqlite3_step (_tmp7_);
#line 260 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp8_;
#line 261 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = res;
#line 261 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp9_ != SQLITE_DONE) {
#line 1504 "DatabaseTable.c"
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
#line 262 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp10_ = self->table_name;
#line 262 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp11_ = column;
#line 262 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp12_ = g_strdup_printf ("DatabaseTable.update_int_by_id_2 %s.%s", _tmp10_, _tmp11_);
#line 262 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp13_ = _tmp12_;
#line 262 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp14_ = res;
#line 262 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_throw_error (_tmp13_, _tmp14_, &_inner_error_);
#line 262 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_g_free0 (_tmp13_);
#line 262 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 262 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 262 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_propagate_error (error, _inner_error_);
#line 262 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 262 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 1534 "DatabaseTable.c"
			} else {
#line 262 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 262 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 262 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_clear_error (&_inner_error_);
#line 262 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 1544 "DatabaseTable.c"
			}
		}
	}
#line 253 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1550 "DatabaseTable.c"
}


gboolean database_table_update_int64_by_id (DatabaseTable* self, gint64 id, const gchar* column, gint64 value) {
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint64 _tmp0_ = 0LL;
	const gchar* _tmp1_ = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	gint res = 0;
	gint64 _tmp3_ = 0LL;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
#line 265 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (IS_DATABASE_TABLE (self), FALSE);
#line 265 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (column != NULL, FALSE);
#line 267 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = id;
#line 267 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = column;
#line 267 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_prepare_update_by_id (self, _tmp0_, _tmp1_, &_tmp2_);
#line 267 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 267 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp2_;
#line 269 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = value;
#line 269 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp4_ = sqlite3_bind_int64 (stmt, 1, _tmp3_);
#line 269 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp4_;
#line 270 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
#line 272 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = database_table_execute_update_by_id (self, stmt);
#line 272 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	result = _tmp5_;
#line 272 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 272 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return result;
#line 1594 "DatabaseTable.c"
}


void database_table_update_int64_by_id_2 (DatabaseTable* self, gint64 id, const gchar* column, gint64 value, GError** error) {
	sqlite3_stmt* stmt = NULL;
	gint64 _tmp0_ = 0LL;
	const gchar* _tmp1_ = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	gint res = 0;
	sqlite3_stmt* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	sqlite3_stmt* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	GError * _inner_error_ = NULL;
#line 275 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (IS_DATABASE_TABLE (self));
#line 275 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (column != NULL);
#line 277 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = id;
#line 277 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = column;
#line 277 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_prepare_update_by_id (self, _tmp0_, _tmp1_, &_tmp2_);
#line 277 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 277 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp2_;
#line 279 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = stmt;
#line 279 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp4_ = value;
#line 279 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = sqlite3_bind_int64 (_tmp3_, 1, _tmp4_);
#line 279 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp5_;
#line 280 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = res;
#line 280 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp6_ == SQLITE_OK, "res == Sqlite.OK");
#line 282 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = stmt;
#line 282 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp8_ = sqlite3_step (_tmp7_);
#line 282 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp8_;
#line 283 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = res;
#line 283 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp9_ != SQLITE_DONE) {
#line 1648 "DatabaseTable.c"
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
#line 284 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp10_ = self->table_name;
#line 284 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp11_ = column;
#line 284 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp12_ = g_strdup_printf ("DatabaseTable.update_int64_by_id_2 %s.%s", _tmp10_, _tmp11_);
#line 284 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp13_ = _tmp12_;
#line 284 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp14_ = res;
#line 284 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_throw_error (_tmp13_, _tmp14_, &_inner_error_);
#line 284 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_g_free0 (_tmp13_);
#line 284 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 284 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 284 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_propagate_error (error, _inner_error_);
#line 284 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 284 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 1678 "DatabaseTable.c"
			} else {
#line 284 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 284 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 284 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_clear_error (&_inner_error_);
#line 284 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 1688 "DatabaseTable.c"
			}
		}
	}
#line 275 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1694 "DatabaseTable.c"
}


void database_table_delete_by_id (DatabaseTable* self, gint64 id, GError** error) {
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	sqlite3_stmt* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	sqlite3_stmt* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	GError * _inner_error_ = NULL;
#line 287 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (IS_DATABASE_TABLE (self));
#line 289 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = database_table_db;
#line 289 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = self->table_name;
#line 289 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = g_strdup_printf ("DELETE FROM %s WHERE id=?", _tmp1_);
#line 289 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = _tmp2_;
#line 289 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = sqlite3_prepare_v2 (_tmp0_, _tmp3_, -1, &_tmp4_, NULL);
#line 289 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 289 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp4_;
#line 289 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = _tmp5_;
#line 289 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_g_free0 (_tmp3_);
#line 289 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp6_;
#line 290 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = res;
#line 290 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 292 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp8_ = stmt;
#line 292 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = id;
#line 292 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp10_ = sqlite3_bind_int64 (_tmp8_, 1, _tmp9_);
#line 292 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp10_;
#line 293 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp11_ = res;
#line 293 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp11_ == SQLITE_OK, "res == Sqlite.OK");
#line 295 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp12_ = stmt;
#line 295 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp13_ = sqlite3_step (_tmp12_);
#line 295 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp13_;
#line 296 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp14_ = res;
#line 296 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp14_ != SQLITE_DONE) {
#line 1765 "DatabaseTable.c"
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gint _tmp18_ = 0;
#line 297 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp15_ = self->table_name;
#line 297 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp16_ = g_strdup_printf ("%s.remove", _tmp15_);
#line 297 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp17_ = _tmp16_;
#line 297 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp18_ = res;
#line 297 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_throw_error (_tmp17_, _tmp18_, &_inner_error_);
#line 297 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_g_free0 (_tmp17_);
#line 297 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 297 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 297 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_propagate_error (error, _inner_error_);
#line 297 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 297 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 1792 "DatabaseTable.c"
			} else {
#line 297 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 297 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 297 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_clear_error (&_inner_error_);
#line 297 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 1802 "DatabaseTable.c"
			}
		}
	}
#line 287 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1808 "DatabaseTable.c"
}


gboolean database_table_has_column (const gchar* table_name, const gchar* column_name) {
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
#line 300 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (table_name != NULL, FALSE);
#line 300 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (column_name != NULL, FALSE);
#line 302 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = database_table_db;
#line 302 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = table_name;
#line 302 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = g_strdup_printf ("PRAGMA table_info(%s)", _tmp1_);
#line 302 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = _tmp2_;
#line 302 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = sqlite3_prepare_v2 (_tmp0_, _tmp3_, -1, &_tmp4_, NULL);
#line 302 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 302 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp4_;
#line 302 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = _tmp5_;
#line 302 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_g_free0 (_tmp3_);
#line 302 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp6_;
#line 303 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = res;
#line 303 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 1852 "DatabaseTable.c"
	{
		gboolean _tmp8_ = FALSE;
#line 305 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp8_ = TRUE;
#line 305 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		while (TRUE) {
#line 1859 "DatabaseTable.c"
			sqlite3_stmt* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
#line 305 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (!_tmp8_) {
#line 1865 "DatabaseTable.c"
			}
#line 305 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp8_ = FALSE;
#line 306 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp9_ = stmt;
#line 306 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp10_ = sqlite3_step (_tmp9_);
#line 306 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			res = _tmp10_;
#line 307 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp11_ = res;
#line 307 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_tmp11_ == SQLITE_DONE) {
#line 308 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				break;
#line 1881 "DatabaseTable.c"
			} else {
				gint _tmp12_ = 0;
#line 309 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_tmp12_ = res;
#line 309 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				if (_tmp12_ != SQLITE_ROW) {
#line 1888 "DatabaseTable.c"
					const gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					gint _tmp16_ = 0;
#line 310 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					_tmp13_ = table_name;
#line 310 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					_tmp14_ = g_strdup_printf ("has_column %s", _tmp13_);
#line 310 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					_tmp15_ = _tmp14_;
#line 310 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					_tmp16_ = res;
#line 310 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					database_table_fatal (_tmp15_, _tmp16_);
#line 310 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					_g_free0 (_tmp15_);
#line 312 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					break;
#line 1907 "DatabaseTable.c"
				} else {
					gchar* column = NULL;
					sqlite3_stmt* _tmp17_ = NULL;
					const gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					gboolean _tmp20_ = FALSE;
					const gchar* _tmp21_ = NULL;
#line 314 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					_tmp17_ = stmt;
#line 314 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					_tmp18_ = sqlite3_column_text (_tmp17_, 1);
#line 314 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					_tmp19_ = g_strdup (_tmp18_);
#line 314 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					column = _tmp19_;
#line 315 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					_tmp21_ = column;
#line 315 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					if (_tmp21_ != NULL) {
#line 1927 "DatabaseTable.c"
						const gchar* _tmp22_ = NULL;
						const gchar* _tmp23_ = NULL;
#line 315 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
						_tmp22_ = column;
#line 315 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
						_tmp23_ = column_name;
#line 315 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
						_tmp20_ = g_strcmp0 (_tmp22_, _tmp23_) == 0;
#line 1936 "DatabaseTable.c"
					} else {
#line 315 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
						_tmp20_ = FALSE;
#line 1940 "DatabaseTable.c"
					}
#line 315 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					if (_tmp20_) {
#line 316 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
						result = TRUE;
#line 316 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
						_g_free0 (column);
#line 316 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
						_sqlite3_finalize0 (stmt);
#line 316 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
						return result;
#line 1952 "DatabaseTable.c"
					}
#line 309 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					_g_free0 (column);
#line 1956 "DatabaseTable.c"
				}
			}
		}
	}
#line 320 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	result = FALSE;
#line 320 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 320 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return result;
#line 1967 "DatabaseTable.c"
}


gboolean database_table_has_table (const gchar* table_name) {
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
#line 323 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (table_name != NULL, FALSE);
#line 325 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = database_table_db;
#line 325 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = table_name;
#line 325 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = g_strdup_printf ("PRAGMA table_info(%s)", _tmp1_);
#line 325 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = _tmp2_;
#line 325 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = sqlite3_prepare_v2 (_tmp0_, _tmp3_, -1, &_tmp4_, NULL);
#line 325 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 325 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp4_;
#line 325 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = _tmp5_;
#line 325 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_g_free0 (_tmp3_);
#line 325 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp6_;
#line 326 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = res;
#line 326 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 328 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp8_ = sqlite3_step (stmt);
#line 328 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp8_;
#line 330 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = res;
#line 330 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	result = _tmp9_ != SQLITE_DONE;
#line 330 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 330 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return result;
#line 2023 "DatabaseTable.c"
}


gboolean database_table_add_column (const gchar* table_name, const gchar* column_name, const gchar* column_constraints) {
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	sqlite3_stmt* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	sqlite3_stmt* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
#line 333 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (table_name != NULL, FALSE);
#line 333 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (column_name != NULL, FALSE);
#line 333 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (column_constraints != NULL, FALSE);
#line 335 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = database_table_db;
#line 335 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = table_name;
#line 335 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = column_name;
#line 335 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = column_constraints;
#line 335 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp4_ = g_strdup_printf ("ALTER TABLE %s ADD COLUMN %s %s", _tmp1_, _tmp2_, _tmp3_);
#line 335 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = _tmp4_;
#line 335 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = sqlite3_prepare_v2 (_tmp0_, _tmp5_, -1, &_tmp6_, NULL);
#line 335 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 335 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp6_;
#line 335 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp8_ = _tmp7_;
#line 335 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_g_free0 (_tmp5_);
#line 335 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp8_;
#line 337 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = res;
#line 337 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp9_ == SQLITE_OK, "res == Sqlite.OK");
#line 339 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp10_ = stmt;
#line 339 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp11_ = sqlite3_step (_tmp10_);
#line 339 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp11_;
#line 340 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp12_ = res;
#line 340 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp12_ != SQLITE_DONE) {
#line 2088 "DatabaseTable.c"
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		sqlite3* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
#line 341 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp13_ = table_name;
#line 341 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp14_ = column_name;
#line 341 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp15_ = column_constraints;
#line 341 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp16_ = res;
#line 341 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp17_ = database_table_db;
#line 341 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp18_ = sqlite3_errmsg (_tmp17_);
#line 341 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		g_critical ("DatabaseTable.vala:341: Unable to add column %s %s %s: (%d) %s", _tmp13_, _tmp14_, _tmp15_, _tmp16_, _tmp18_);
#line 344 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		result = FALSE;
#line 344 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_sqlite3_finalize0 (stmt);
#line 344 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		return result;
#line 2115 "DatabaseTable.c"
	}
#line 347 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	result = TRUE;
#line 347 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 347 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return result;
#line 2123 "DatabaseTable.c"
}


gboolean database_table_ensure_column (const gchar* table_name, const gchar* column_name, const gchar* column_constraints, const gchar* upgrade_msg) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
#line 353 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (table_name != NULL, FALSE);
#line 353 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (column_name != NULL, FALSE);
#line 353 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (column_constraints != NULL, FALSE);
#line 353 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (upgrade_msg != NULL, FALSE);
#line 355 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = table_name;
#line 355 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = database_table_has_table (_tmp1_);
#line 355 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (!_tmp2_) {
#line 355 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp0_ = TRUE;
#line 2153 "DatabaseTable.c"
	} else {
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 355 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp3_ = table_name;
#line 355 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp4_ = column_name;
#line 355 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp5_ = database_table_has_column (_tmp3_, _tmp4_);
#line 355 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp0_ = _tmp5_;
#line 2166 "DatabaseTable.c"
	}
#line 355 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp0_) {
#line 356 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		result = TRUE;
#line 356 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		return result;
#line 2174 "DatabaseTable.c"
	}
#line 358 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = upgrade_msg;
#line 358 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_message ("DatabaseTable.vala:358: %s", _tmp6_);
#line 360 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = table_name;
#line 360 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp8_ = column_name;
#line 360 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = column_constraints;
#line 360 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp10_ = database_table_add_column (_tmp7_, _tmp8_, _tmp9_);
#line 360 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	result = _tmp10_;
#line 360 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return result;
#line 2192 "DatabaseTable.c"
}


gint database_table_get_row_count (DatabaseTable* self) {
	gint result = 0;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	sqlite3_stmt* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	sqlite3_stmt* _tmp15_ = NULL;
	gint _tmp16_ = 0;
#line 363 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (IS_DATABASE_TABLE (self), 0);
#line 365 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = database_table_db;
#line 365 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = self->table_name;
#line 365 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = g_strdup_printf ("SELECT COUNT(id) AS RowCount FROM %s", _tmp1_);
#line 365 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = _tmp2_;
#line 365 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = sqlite3_prepare_v2 (_tmp0_, _tmp3_, -1, &_tmp4_, NULL);
#line 365 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 365 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp4_;
#line 365 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = _tmp5_;
#line 365 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_g_free0 (_tmp3_);
#line 365 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp6_;
#line 366 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = res;
#line 366 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 368 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp8_ = stmt;
#line 368 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = sqlite3_step (_tmp8_);
#line 368 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp9_;
#line 369 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp10_ = res;
#line 369 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp10_ != SQLITE_ROW) {
#line 2249 "DatabaseTable.c"
		const gchar* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		sqlite3* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 370 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp11_ = self->table_name;
#line 370 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp12_ = res;
#line 370 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp13_ = database_table_db;
#line 370 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp14_ = sqlite3_errmsg (_tmp13_);
#line 370 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		g_critical ("DatabaseTable.vala:370: Unable to retrieve row count on %s: (%d) %s", _tmp11_, _tmp12_, _tmp14_);
#line 372 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		result = 0;
#line 372 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_sqlite3_finalize0 (stmt);
#line 372 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		return result;
#line 2270 "DatabaseTable.c"
	}
#line 375 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp15_ = stmt;
#line 375 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp16_ = sqlite3_column_int (_tmp15_, 0);
#line 375 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	result = _tmp16_;
#line 375 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 375 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return result;
#line 2282 "DatabaseTable.c"
}


void database_table_begin_transaction (void) {
	gint _tmp0_ = 0;
	gint res = 0;
	sqlite3* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 380 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = database_table_in_transaction;
#line 380 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_in_transaction = _tmp0_ + 1;
#line 380 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp0_ != 0) {
#line 381 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		return;
#line 2300 "DatabaseTable.c"
	}
#line 383 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = database_table_db;
#line 383 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = _sqlite3_exec (_tmp1_, "BEGIN TRANSACTION", NULL, NULL, NULL);
#line 383 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp2_;
#line 384 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = res;
#line 384 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 2312 "DatabaseTable.c"
}


void database_table_commit_transaction (GError** error) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint res = 0;
	sqlite3* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GError * _inner_error_ = NULL;
#line 389 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = database_table_in_transaction;
#line 389 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp0_ > 0, "in_transaction > 0");
#line 390 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = database_table_in_transaction;
#line 390 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_in_transaction = _tmp1_ - 1;
#line 390 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = database_table_in_transaction;
#line 390 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp2_ != 0) {
#line 391 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		return;
#line 2339 "DatabaseTable.c"
	}
#line 393 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = database_table_db;
#line 393 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp4_ = _sqlite3_exec (_tmp3_, "COMMIT TRANSACTION", NULL, NULL, NULL);
#line 393 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp4_;
#line 394 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = res;
#line 394 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp5_ != SQLITE_DONE) {
#line 2351 "DatabaseTable.c"
		gint _tmp6_ = 0;
#line 395 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp6_ = res;
#line 395 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_throw_error ("commit_transaction", _tmp6_, &_inner_error_);
#line 395 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 395 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 395 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_propagate_error (error, _inner_error_);
#line 395 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 2365 "DatabaseTable.c"
			} else {
#line 395 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 395 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_clear_error (&_inner_error_);
#line 395 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 2373 "DatabaseTable.c"
			}
		}
	}
}


DatabaseTable* database_table_construct (GType object_type) {
	DatabaseTable* self = NULL;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	self = (DatabaseTable*) g_type_create_instance (object_type);
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return self;
#line 2386 "DatabaseTable.c"
}


static void value_database_table_init (GValue* value) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	value->data[0].v_pointer = NULL;
#line 2393 "DatabaseTable.c"
}


static void value_database_table_free_value (GValue* value) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (value->data[0].v_pointer) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_unref (value->data[0].v_pointer);
#line 2402 "DatabaseTable.c"
	}
}


static void value_database_table_copy_value (const GValue* src_value, GValue* dest_value) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (src_value->data[0].v_pointer) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		dest_value->data[0].v_pointer = database_table_ref (src_value->data[0].v_pointer);
#line 2412 "DatabaseTable.c"
	} else {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2416 "DatabaseTable.c"
	}
}


static gpointer value_database_table_peek_pointer (const GValue* value) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return value->data[0].v_pointer;
#line 2424 "DatabaseTable.c"
}


static gchar* value_database_table_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (collect_values[0].v_pointer) {
#line 2431 "DatabaseTable.c"
		DatabaseTable* object;
		object = collect_values[0].v_pointer;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		if (object->parent_instance.g_class == NULL) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2438 "DatabaseTable.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2442 "DatabaseTable.c"
		}
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		value->data[0].v_pointer = database_table_ref (object);
#line 2446 "DatabaseTable.c"
	} else {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		value->data[0].v_pointer = NULL;
#line 2450 "DatabaseTable.c"
	}
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return NULL;
#line 2454 "DatabaseTable.c"
}


static gchar* value_database_table_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DatabaseTable** object_p;
	object_p = collect_values[0].v_pointer;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (!object_p) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2465 "DatabaseTable.c"
	}
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (!value->data[0].v_pointer) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		*object_p = NULL;
#line 2471 "DatabaseTable.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		*object_p = value->data[0].v_pointer;
#line 2475 "DatabaseTable.c"
	} else {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		*object_p = database_table_ref (value->data[0].v_pointer);
#line 2479 "DatabaseTable.c"
	}
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return NULL;
#line 2483 "DatabaseTable.c"
}


GParamSpec* param_spec_database_table (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecDatabaseTable* spec;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DATABASE_TABLE), NULL);
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return G_PARAM_SPEC (spec);
#line 2497 "DatabaseTable.c"
}


gpointer value_get_database_table (const GValue* value) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATABASE_TABLE), NULL);
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return value->data[0].v_pointer;
#line 2506 "DatabaseTable.c"
}


void value_set_database_table (GValue* value, gpointer v_object) {
	DatabaseTable* old;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATABASE_TABLE));
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	old = value->data[0].v_pointer;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (v_object) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DATABASE_TABLE));
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		value->data[0].v_pointer = v_object;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_ref (value->data[0].v_pointer);
#line 2526 "DatabaseTable.c"
	} else {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		value->data[0].v_pointer = NULL;
#line 2530 "DatabaseTable.c"
	}
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (old) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_unref (old);
#line 2536 "DatabaseTable.c"
	}
}


void value_take_database_table (GValue* value, gpointer v_object) {
	DatabaseTable* old;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATABASE_TABLE));
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	old = value->data[0].v_pointer;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (v_object) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DATABASE_TABLE));
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		value->data[0].v_pointer = v_object;
#line 2555 "DatabaseTable.c"
	} else {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		value->data[0].v_pointer = NULL;
#line 2559 "DatabaseTable.c"
	}
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (old) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_unref (old);
#line 2565 "DatabaseTable.c"
	}
}


static void database_table_class_init (DatabaseTableClass * klass) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_parent_class = g_type_class_peek_parent (klass);
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	((DatabaseTableClass *) klass)->finalize = database_table_finalize;
#line 2575 "DatabaseTable.c"
}


static void database_table_instance_init (DatabaseTable * self) {
#line 30 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	self->table_name = NULL;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	self->ref_count = 1;
#line 2584 "DatabaseTable.c"
}


static void database_table_finalize (DatabaseTable* obj) {
	DatabaseTable * self;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DATABASE_TABLE, DatabaseTable);
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_signal_handlers_destroy (self);
#line 30 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_g_free0 (self->table_name);
#line 2596 "DatabaseTable.c"
}


GType database_table_get_type (void) {
	static volatile gsize database_table_type_id__volatile = 0;
	if (g_once_init_enter (&database_table_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_database_table_init, value_database_table_free_value, value_database_table_copy_value, value_database_table_peek_pointer, "p", value_database_table_collect_value, "p", value_database_table_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DatabaseTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) database_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DatabaseTable), 0, (GInstanceInitFunc) database_table_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType database_table_type_id;
		database_table_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DatabaseTable", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&database_table_type_id__volatile, database_table_type_id);
	}
	return database_table_type_id__volatile;
}


gpointer database_table_ref (gpointer instance) {
	DatabaseTable* self;
	self = instance;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_atomic_int_inc (&self->ref_count);
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return instance;
#line 2621 "DatabaseTable.c"
}


void database_table_unref (gpointer instance) {
	DatabaseTable* self;
	self = instance;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		DATABASE_TABLE_GET_CLASS (self)->finalize (self);
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2634 "DatabaseTable.c"
	}
}



