/* CrumbleEffect.c generated by valac 0.32.1, the Vala compiler
 * generated from CrumbleEffect.vala, do not modify */

/* Copyright 2010 Maxim Kartashev
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <shotwell-plugin-dev-1.0.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>


#define TYPE_SHOTWELL_TRANSITION_DESCRIPTOR (shotwell_transition_descriptor_get_type ())
#define SHOTWELL_TRANSITION_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptor))
#define SHOTWELL_TRANSITION_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptorClass))
#define IS_SHOTWELL_TRANSITION_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR))
#define IS_SHOTWELL_TRANSITION_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR))
#define SHOTWELL_TRANSITION_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptorClass))

typedef struct _ShotwellTransitionDescriptor ShotwellTransitionDescriptor;
typedef struct _ShotwellTransitionDescriptorClass ShotwellTransitionDescriptorClass;
typedef struct _ShotwellTransitionDescriptorPrivate ShotwellTransitionDescriptorPrivate;

#define TYPE_CRUMBLE_EFFECT_DESCRIPTOR (crumble_effect_descriptor_get_type ())
#define CRUMBLE_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CRUMBLE_EFFECT_DESCRIPTOR, CrumbleEffectDescriptor))
#define CRUMBLE_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CRUMBLE_EFFECT_DESCRIPTOR, CrumbleEffectDescriptorClass))
#define IS_CRUMBLE_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CRUMBLE_EFFECT_DESCRIPTOR))
#define IS_CRUMBLE_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CRUMBLE_EFFECT_DESCRIPTOR))
#define CRUMBLE_EFFECT_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CRUMBLE_EFFECT_DESCRIPTOR, CrumbleEffectDescriptorClass))

typedef struct _CrumbleEffectDescriptor CrumbleEffectDescriptor;
typedef struct _CrumbleEffectDescriptorClass CrumbleEffectDescriptorClass;
typedef struct _CrumbleEffectDescriptorPrivate CrumbleEffectDescriptorPrivate;

#define TYPE_CRUMBLE_EFFECT (crumble_effect_get_type ())
#define CRUMBLE_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CRUMBLE_EFFECT, CrumbleEffect))
#define CRUMBLE_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CRUMBLE_EFFECT, CrumbleEffectClass))
#define IS_CRUMBLE_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CRUMBLE_EFFECT))
#define IS_CRUMBLE_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CRUMBLE_EFFECT))
#define CRUMBLE_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CRUMBLE_EFFECT, CrumbleEffectClass))

typedef struct _CrumbleEffect CrumbleEffect;
typedef struct _CrumbleEffectClass CrumbleEffectClass;
typedef struct _CrumbleEffectPrivate CrumbleEffectPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_rand_free0(var) ((var == NULL) ? NULL : (var = (g_rand_free (var), NULL)))

struct _ShotwellTransitionDescriptor {
	GObject parent_instance;
	ShotwellTransitionDescriptorPrivate * priv;
};

struct _ShotwellTransitionDescriptorClass {
	GObjectClass parent_class;
	const gchar* (*get_id) (ShotwellTransitionDescriptor* self);
	const gchar* (*get_pluggable_name) (ShotwellTransitionDescriptor* self);
	SpitTransitionsEffect* (*create) (ShotwellTransitionDescriptor* self, SpitHostInterface* host);
};

struct _CrumbleEffectDescriptor {
	ShotwellTransitionDescriptor parent_instance;
	CrumbleEffectDescriptorPrivate * priv;
};

struct _CrumbleEffectDescriptorClass {
	ShotwellTransitionDescriptorClass parent_class;
};

struct _CrumbleEffect {
	GObject parent_instance;
	CrumbleEffectPrivate * priv;
};

struct _CrumbleEffectClass {
	GObjectClass parent_class;
};

struct _CrumbleEffectPrivate {
	cairo_surface_t** from_stripes;
	gint from_stripes_length1;
	gint _from_stripes_size_;
	gdouble* accelerations;
	gint accelerations_length1;
	gint _accelerations_size_;
	gint stripes_count;
};


static gpointer crumble_effect_descriptor_parent_class = NULL;
static gpointer crumble_effect_parent_class = NULL;
static SpitTransitionsEffectIface* crumble_effect_spit_transitions_effect_parent_iface = NULL;

GType shotwell_transition_descriptor_get_type (void) G_GNUC_CONST;
GType crumble_effect_descriptor_get_type (void) G_GNUC_CONST;
enum  {
	CRUMBLE_EFFECT_DESCRIPTOR_DUMMY_PROPERTY
};
CrumbleEffectDescriptor* crumble_effect_descriptor_new (GFile* resource_directory);
CrumbleEffectDescriptor* crumble_effect_descriptor_construct (GType object_type, GFile* resource_directory);
ShotwellTransitionDescriptor* shotwell_transition_descriptor_construct (GType object_type, GFile* resource_directory);
static const gchar* crumble_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base);
static const gchar* crumble_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base);
static SpitTransitionsEffect* crumble_effect_descriptor_real_create (ShotwellTransitionDescriptor* base, SpitHostInterface* host);
CrumbleEffect* crumble_effect_new (void);
CrumbleEffect* crumble_effect_construct (GType object_type);
GType crumble_effect_get_type (void) G_GNUC_CONST;
#define CRUMBLE_EFFECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CRUMBLE_EFFECT, CrumbleEffectPrivate))
enum  {
	CRUMBLE_EFFECT_DUMMY_PROPERTY
};
#define CRUMBLE_EFFECT_DESIRED_FPS 25
#define CRUMBLE_EFFECT_MIN_FPS 15
#define CRUMBLE_EFFECT_STRIPE_WIDTH 10
static void crumble_effect_real_get_fps (SpitTransitionsEffect* base, gint* desired_fps, gint* min_fps);
static gboolean crumble_effect_real_needs_clear_background (SpitTransitionsEffect* base);
static void crumble_effect_real_start (SpitTransitionsEffect* base, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion);
static void crumble_effect_real_paint (SpitTransitionsEffect* base, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion, cairo_t* ctx, gint width, gint height, gint frame_number);
static void crumble_effect_real_advance (SpitTransitionsEffect* base, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion, gint frame_number);
static void crumble_effect_real_cancel (SpitTransitionsEffect* base);
static void crumble_effect_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


CrumbleEffectDescriptor* crumble_effect_descriptor_construct (GType object_type, GFile* resource_directory) {
	CrumbleEffectDescriptor * self = NULL;
	GFile* _tmp0_ = NULL;
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	g_return_val_if_fail (G_IS_FILE (resource_directory), NULL);
#line 12 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	_tmp0_ = resource_directory;
#line 12 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = (CrumbleEffectDescriptor*) shotwell_transition_descriptor_construct (object_type, _tmp0_);
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	return self;
#line 150 "CrumbleEffect.c"
}


CrumbleEffectDescriptor* crumble_effect_descriptor_new (GFile* resource_directory) {
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	return crumble_effect_descriptor_construct (TYPE_CRUMBLE_EFFECT_DESCRIPTOR, resource_directory);
#line 157 "CrumbleEffect.c"
}


static const gchar* crumble_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base) {
	CrumbleEffectDescriptor * self;
	const gchar* result = NULL;
#line 15 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT_DESCRIPTOR, CrumbleEffectDescriptor);
#line 16 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	result = "org.yorba.shotwell.transitions.crumble";
#line 16 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	return result;
#line 170 "CrumbleEffect.c"
}


static const gchar* crumble_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base) {
	CrumbleEffectDescriptor * self;
	const gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
#line 19 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT_DESCRIPTOR, CrumbleEffectDescriptor);
#line 20 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	_tmp0_ = _ ("Crumble");
#line 20 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	result = _tmp0_;
#line 20 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	return result;
#line 186 "CrumbleEffect.c"
}


static SpitTransitionsEffect* crumble_effect_descriptor_real_create (ShotwellTransitionDescriptor* base, SpitHostInterface* host) {
	CrumbleEffectDescriptor * self;
	SpitTransitionsEffect* result = NULL;
	CrumbleEffect* _tmp0_ = NULL;
#line 23 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT_DESCRIPTOR, CrumbleEffectDescriptor);
#line 23 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	g_return_val_if_fail (SPIT_IS_HOST_INTERFACE (host), NULL);
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	_tmp0_ = crumble_effect_new ();
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SPIT_TRANSITIONS_TYPE_EFFECT, SpitTransitionsEffect);
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	return result;
#line 204 "CrumbleEffect.c"
}


static void crumble_effect_descriptor_class_init (CrumbleEffectDescriptorClass * klass) {
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	crumble_effect_descriptor_parent_class = g_type_class_peek_parent (klass);
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->get_id = crumble_effect_descriptor_real_get_id;
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->get_pluggable_name = crumble_effect_descriptor_real_get_pluggable_name;
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->create = crumble_effect_descriptor_real_create;
#line 217 "CrumbleEffect.c"
}


static void crumble_effect_descriptor_instance_init (CrumbleEffectDescriptor * self) {
}


GType crumble_effect_descriptor_get_type (void) {
	static volatile gsize crumble_effect_descriptor_type_id__volatile = 0;
	if (g_once_init_enter (&crumble_effect_descriptor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CrumbleEffectDescriptorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) crumble_effect_descriptor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CrumbleEffectDescriptor), 0, (GInstanceInitFunc) crumble_effect_descriptor_instance_init, NULL };
		GType crumble_effect_descriptor_type_id;
		crumble_effect_descriptor_type_id = g_type_register_static (TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, "CrumbleEffectDescriptor", &g_define_type_info, 0);
		g_once_init_leave (&crumble_effect_descriptor_type_id__volatile, crumble_effect_descriptor_type_id);
	}
	return crumble_effect_descriptor_type_id__volatile;
}


CrumbleEffect* crumble_effect_construct (GType object_type) {
	CrumbleEffect * self = NULL;
#line 38 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = (CrumbleEffect*) g_object_new (object_type, NULL);
#line 38 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	return self;
#line 243 "CrumbleEffect.c"
}


CrumbleEffect* crumble_effect_new (void) {
#line 38 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	return crumble_effect_construct (TYPE_CRUMBLE_EFFECT);
#line 250 "CrumbleEffect.c"
}


static void crumble_effect_real_get_fps (SpitTransitionsEffect* base, gint* desired_fps, gint* min_fps) {
	CrumbleEffect * self;
	gint _vala_desired_fps = 0;
	gint _vala_min_fps = 0;
#line 41 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT, CrumbleEffect);
#line 42 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	_vala_desired_fps = CRUMBLE_EFFECT_DESIRED_FPS;
#line 43 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	_vala_min_fps = CRUMBLE_EFFECT_MIN_FPS;
#line 41 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	if (desired_fps) {
#line 41 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		*desired_fps = _vala_desired_fps;
#line 268 "CrumbleEffect.c"
	}
#line 41 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	if (min_fps) {
#line 41 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		*min_fps = _vala_min_fps;
#line 274 "CrumbleEffect.c"
	}
}


static gboolean crumble_effect_real_needs_clear_background (SpitTransitionsEffect* base) {
	CrumbleEffect * self;
	gboolean result = FALSE;
#line 46 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT, CrumbleEffect);
#line 47 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	result = TRUE;
#line 47 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	return result;
#line 288 "CrumbleEffect.c"
}


static void crumble_effect_real_start (SpitTransitionsEffect* base, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion) {
	CrumbleEffect * self;
	GRand* rand = NULL;
	GRand* _tmp0_ = NULL;
	SpitTransitionsVisuals* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
#line 50 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT, CrumbleEffect);
#line 50 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 50 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 51 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	_tmp0_ = g_rand_new ();
#line 51 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	rand = _tmp0_;
#line 55 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	_tmp1_ = visuals;
#line 55 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	_tmp2_ = spit_transitions_visuals_get_from_pixbuf (_tmp1_);
#line 55 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	_tmp3_ = _tmp2_;
#line 55 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	if (_tmp3_ != NULL) {
#line 317 "CrumbleEffect.c"
		SpitTransitionsVisuals* _tmp4_ = NULL;
		GdkPixbuf* _tmp5_ = NULL;
		GdkPixbuf* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		cairo_surface_t** _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gdouble* _tmp12_ = NULL;
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp4_ = visuals;
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp5_ = spit_transitions_visuals_get_from_pixbuf (_tmp4_);
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp6_ = _tmp5_;
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp7_ = gdk_pixbuf_get_width (_tmp6_);
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp8_ = _tmp7_;
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		self->priv->stripes_count = _tmp8_ / CRUMBLE_EFFECT_STRIPE_WIDTH;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp9_ = self->priv->stripes_count;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp10_ = g_new0 (cairo_surface_t*, _tmp9_ + 1);
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		self->priv->from_stripes = (_vala_array_free (self->priv->from_stripes, self->priv->from_stripes_length1, (GDestroyNotify) cairo_surface_destroy), NULL);
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		self->priv->from_stripes = _tmp10_;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		self->priv->from_stripes_length1 = _tmp9_;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		self->priv->_from_stripes_size_ = self->priv->from_stripes_length1;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp11_ = self->priv->stripes_count;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp12_ = g_new0 (gdouble, _tmp11_);
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		self->priv->accelerations = (g_free (self->priv->accelerations), NULL);
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		self->priv->accelerations = _tmp12_;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		self->priv->accelerations_length1 = _tmp11_;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		self->priv->_accelerations_size_ = self->priv->accelerations_length1;
#line 363 "CrumbleEffect.c"
		{
			gint i = 0;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			i = 0;
#line 368 "CrumbleEffect.c"
			{
				gboolean _tmp13_ = FALSE;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
				_tmp13_ = TRUE;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
				while (TRUE) {
#line 375 "CrumbleEffect.c"
					gint _tmp15_ = 0;
					gint _tmp16_ = 0;
					cairo_surface_t** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					gint _tmp18_ = 0;
					SpitTransitionsVisuals* _tmp19_ = NULL;
					GdkPixbuf* _tmp20_ = NULL;
					GdkPixbuf* _tmp21_ = NULL;
					gint _tmp22_ = 0;
					gint _tmp23_ = 0;
					cairo_surface_t* _tmp24_ = NULL;
					cairo_surface_t* _tmp25_ = NULL;
					cairo_t* ctx = NULL;
					cairo_surface_t** _tmp26_ = NULL;
					gint _tmp26__length1 = 0;
					gint _tmp27_ = 0;
					cairo_surface_t* _tmp28_ = NULL;
					cairo_t* _tmp29_ = NULL;
					cairo_t* _tmp30_ = NULL;
					SpitTransitionsVisuals* _tmp31_ = NULL;
					GdkPixbuf* _tmp32_ = NULL;
					GdkPixbuf* _tmp33_ = NULL;
					gint _tmp34_ = 0;
					cairo_t* _tmp35_ = NULL;
					gdouble* _tmp36_ = NULL;
					gint _tmp36__length1 = 0;
					gint _tmp37_ = 0;
					GRand* _tmp38_ = NULL;
					gdouble _tmp39_ = 0.0;
					gdouble _tmp40_ = 0.0;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					if (!_tmp13_) {
#line 408 "CrumbleEffect.c"
						gint _tmp14_ = 0;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
						_tmp14_ = i;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
						i = _tmp14_ + 1;
#line 414 "CrumbleEffect.c"
					}
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp13_ = FALSE;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp15_ = i;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp16_ = self->priv->stripes_count;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					if (!(_tmp15_ < _tmp16_)) {
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
						break;
#line 426 "CrumbleEffect.c"
					}
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp17_ = self->priv->from_stripes;
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp17__length1 = self->priv->from_stripes_length1;
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp18_ = i;
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp19_ = visuals;
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp20_ = spit_transitions_visuals_get_from_pixbuf (_tmp19_);
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp21_ = _tmp20_;
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp22_ = gdk_pixbuf_get_height (_tmp21_);
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp23_ = _tmp22_;
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp24_ = cairo_image_surface_create (CAIRO_FORMAT_RGB24, CRUMBLE_EFFECT_STRIPE_WIDTH, _tmp23_);
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_cairo_surface_destroy0 (_tmp17_[_tmp18_]);
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp17_[_tmp18_] = _tmp24_;
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp25_ = _tmp17_[_tmp18_];
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp26_ = self->priv->from_stripes;
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp26__length1 = self->priv->from_stripes_length1;
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp27_ = i;
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp28_ = _tmp26_[_tmp27_];
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp29_ = cairo_create (_tmp28_);
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					ctx = _tmp29_;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp30_ = ctx;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp31_ = visuals;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp32_ = spit_transitions_visuals_get_from_pixbuf (_tmp31_);
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp33_ = _tmp32_;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp34_ = i;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					gdk_cairo_set_source_pixbuf (_tmp30_, _tmp33_, (gdouble) ((-_tmp34_) * CRUMBLE_EFFECT_STRIPE_WIDTH), (gdouble) 0);
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp35_ = ctx;
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					cairo_paint (_tmp35_);
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp36_ = self->priv->accelerations;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp36__length1 = self->priv->accelerations_length1;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp37_ = i;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp38_ = rand;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp39_ = g_rand_double (_tmp38_);
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp36_[_tmp37_] = _tmp39_;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp40_ = _tmp36_[_tmp37_];
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_cairo_destroy0 (ctx);
#line 496 "CrumbleEffect.c"
				}
			}
		}
	}
#line 50 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	_g_rand_free0 (rand);
#line 503 "CrumbleEffect.c"
}


static void crumble_effect_real_paint (SpitTransitionsEffect* base, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion, cairo_t* ctx, gint width, gint height, gint frame_number) {
	CrumbleEffect * self;
	gdouble alpha = 0.0;
	SpitTransitionsMotion* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
#line 70 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT, CrumbleEffect);
#line 70 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 70 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 70 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	g_return_if_fail (ctx != NULL);
#line 72 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	_tmp0_ = motion;
#line 72 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	_tmp1_ = frame_number;
#line 72 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	_tmp2_ = spit_transitions_motion_get_alpha (_tmp0_, _tmp1_);
#line 72 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	alpha = _tmp2_;
#line 74 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	_tmp3_ = alpha;
#line 74 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	if (_tmp3_ < 0.5) {
#line 534 "CrumbleEffect.c"
		gdouble _tmp4_ = 0.0;
#line 76 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp4_ = alpha;
#line 76 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		alpha = _tmp4_ * 2;
#line 540 "CrumbleEffect.c"
		{
			gint i = 0;
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			i = 0;
#line 545 "CrumbleEffect.c"
			{
				gboolean _tmp5_ = FALSE;
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
				_tmp5_ = TRUE;
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
				while (TRUE) {
#line 552 "CrumbleEffect.c"
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
					gint x = 0;
					SpitTransitionsVisuals* _tmp9_ = NULL;
					GdkRectangle _tmp10_ = {0};
					GdkRectangle _tmp11_ = {0};
					gint _tmp12_ = 0;
					gint _tmp13_ = 0;
					gdouble a = 0.0;
					gdouble _tmp14_ = 0.0;
					gdouble _tmp15_ = 0.0;
					gdouble* _tmp16_ = NULL;
					gint _tmp16__length1 = 0;
					gint _tmp17_ = 0;
					gdouble _tmp18_ = 0.0;
					gint y = 0;
					SpitTransitionsVisuals* _tmp19_ = NULL;
					GdkRectangle _tmp20_ = {0};
					GdkRectangle _tmp21_ = {0};
					gint _tmp22_ = 0;
					SpitTransitionsVisuals* _tmp23_ = NULL;
					GdkPixbuf* _tmp24_ = NULL;
					GdkPixbuf* _tmp25_ = NULL;
					gint _tmp26_ = 0;
					gint _tmp27_ = 0;
					gdouble _tmp28_ = 0.0;
					gdouble _tmp29_ = 0.0;
					cairo_t* _tmp30_ = NULL;
					cairo_surface_t** _tmp31_ = NULL;
					gint _tmp31__length1 = 0;
					gint _tmp32_ = 0;
					cairo_surface_t* _tmp33_ = NULL;
					gint _tmp34_ = 0;
					gint _tmp35_ = 0;
					cairo_t* _tmp36_ = NULL;
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					if (!_tmp5_) {
#line 590 "CrumbleEffect.c"
						gint _tmp6_ = 0;
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
						_tmp6_ = i;
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
						i = _tmp6_ + 1;
#line 596 "CrumbleEffect.c"
					}
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp5_ = FALSE;
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp7_ = i;
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp8_ = self->priv->stripes_count;
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					if (!(_tmp7_ < _tmp8_)) {
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
						break;
#line 608 "CrumbleEffect.c"
					}
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp9_ = visuals;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					spit_transitions_visuals_get_from_pos (_tmp9_, &_tmp10_);
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp11_ = _tmp10_;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp12_ = _tmp11_.x;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp13_ = i;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					x = _tmp12_ + (_tmp13_ * CRUMBLE_EFFECT_STRIPE_WIDTH);
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp14_ = alpha;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp15_ = alpha;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp16_ = self->priv->accelerations;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp16__length1 = self->priv->accelerations_length1;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp17_ = i;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp18_ = _tmp16_[_tmp17_];
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					a = _tmp14_ + (_tmp15_ * _tmp18_);
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp19_ = visuals;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					spit_transitions_visuals_get_from_pos (_tmp19_, &_tmp20_);
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp21_ = _tmp20_;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp22_ = _tmp21_.y;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp23_ = visuals;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp24_ = spit_transitions_visuals_get_from_pixbuf (_tmp23_);
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp25_ = _tmp24_;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp26_ = gdk_pixbuf_get_height (_tmp25_);
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp27_ = _tmp26_;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp28_ = a;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp29_ = a;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					y = _tmp22_ + ((gint) ((_tmp27_ * _tmp28_) * _tmp29_));
#line 84 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp30_ = ctx;
#line 84 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp31_ = self->priv->from_stripes;
#line 84 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp31__length1 = self->priv->from_stripes_length1;
#line 84 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp32_ = i;
#line 84 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp33_ = _tmp31_[_tmp32_];
#line 84 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp34_ = x;
#line 84 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp35_ = y;
#line 84 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					cairo_set_source_surface (_tmp30_, _tmp33_, (gdouble) _tmp34_, (gdouble) _tmp35_);
#line 85 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp36_ = ctx;
#line 85 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					cairo_paint (_tmp36_);
#line 680 "CrumbleEffect.c"
				}
			}
		}
	} else {
		SpitTransitionsVisuals* _tmp37_ = NULL;
		GdkPixbuf* _tmp38_ = NULL;
		GdkPixbuf* _tmp39_ = NULL;
#line 87 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp37_ = visuals;
#line 87 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp38_ = spit_transitions_visuals_get_to_pixbuf (_tmp37_);
#line 87 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp39_ = _tmp38_;
#line 87 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		if (_tmp39_ != NULL) {
#line 696 "CrumbleEffect.c"
			gdouble _tmp40_ = 0.0;
			cairo_t* _tmp41_ = NULL;
			SpitTransitionsVisuals* _tmp42_ = NULL;
			GdkPixbuf* _tmp43_ = NULL;
			GdkPixbuf* _tmp44_ = NULL;
			SpitTransitionsVisuals* _tmp45_ = NULL;
			GdkRectangle _tmp46_ = {0};
			GdkRectangle _tmp47_ = {0};
			gint _tmp48_ = 0;
			SpitTransitionsVisuals* _tmp49_ = NULL;
			GdkRectangle _tmp50_ = {0};
			GdkRectangle _tmp51_ = {0};
			gint _tmp52_ = 0;
			cairo_t* _tmp53_ = NULL;
			gdouble _tmp54_ = 0.0;
#line 89 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			_tmp40_ = alpha;
#line 89 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			alpha = (_tmp40_ - 0.5) * 2;
#line 90 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			_tmp41_ = ctx;
#line 90 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			_tmp42_ = visuals;
#line 90 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			_tmp43_ = spit_transitions_visuals_get_to_pixbuf (_tmp42_);
#line 90 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			_tmp44_ = _tmp43_;
#line 90 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			_tmp45_ = visuals;
#line 90 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			spit_transitions_visuals_get_to_pos (_tmp45_, &_tmp46_);
#line 90 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			_tmp47_ = _tmp46_;
#line 90 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			_tmp48_ = _tmp47_.x;
#line 90 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			_tmp49_ = visuals;
#line 90 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			spit_transitions_visuals_get_to_pos (_tmp49_, &_tmp50_);
#line 90 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			_tmp51_ = _tmp50_;
#line 90 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			_tmp52_ = _tmp51_.y;
#line 90 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			gdk_cairo_set_source_pixbuf (_tmp41_, _tmp44_, (gdouble) _tmp48_, (gdouble) _tmp52_);
#line 91 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			_tmp53_ = ctx;
#line 91 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			_tmp54_ = alpha;
#line 91 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			cairo_paint_with_alpha (_tmp53_, _tmp54_);
#line 748 "CrumbleEffect.c"
		} else {
		}
	}
}


static void crumble_effect_real_advance (SpitTransitionsEffect* base, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion, gint frame_number) {
	CrumbleEffect * self;
#line 97 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT, CrumbleEffect);
#line 97 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 97 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 763 "CrumbleEffect.c"
}


static void crumble_effect_real_cancel (SpitTransitionsEffect* base) {
	CrumbleEffect * self;
#line 100 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT, CrumbleEffect);
#line 771 "CrumbleEffect.c"
}


static void crumble_effect_class_init (CrumbleEffectClass * klass) {
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	crumble_effect_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	g_type_class_add_private (klass, sizeof (CrumbleEffectPrivate));
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	G_OBJECT_CLASS (klass)->finalize = crumble_effect_finalize;
#line 782 "CrumbleEffect.c"
}


static void crumble_effect_spit_transitions_effect_interface_init (SpitTransitionsEffectIface * iface) {
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	crumble_effect_spit_transitions_effect_parent_iface = g_type_interface_peek_parent (iface);
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	iface->get_fps = (void (*)(SpitTransitionsEffect*, gint*, gint*)) crumble_effect_real_get_fps;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	iface->needs_clear_background = (gboolean (*)(SpitTransitionsEffect*)) crumble_effect_real_needs_clear_background;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	iface->start = (void (*)(SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*)) crumble_effect_real_start;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	iface->paint = (void (*)(SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, cairo_t*, gint, gint, gint)) crumble_effect_real_paint;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	iface->advance = (void (*)(SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, gint)) crumble_effect_real_advance;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	iface->cancel = (void (*)(SpitTransitionsEffect*)) crumble_effect_real_cancel;
#line 801 "CrumbleEffect.c"
}


static void crumble_effect_instance_init (CrumbleEffect * self) {
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self->priv = CRUMBLE_EFFECT_GET_PRIVATE (self);
#line 808 "CrumbleEffect.c"
}


static void crumble_effect_finalize (GObject* obj) {
	CrumbleEffect * self;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CRUMBLE_EFFECT, CrumbleEffect);
#line 34 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self->priv->from_stripes = (_vala_array_free (self->priv->from_stripes, self->priv->from_stripes_length1, (GDestroyNotify) cairo_surface_destroy), NULL);
#line 35 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self->priv->accelerations = (g_free (self->priv->accelerations), NULL);
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	G_OBJECT_CLASS (crumble_effect_parent_class)->finalize (obj);
#line 822 "CrumbleEffect.c"
}


GType crumble_effect_get_type (void) {
	static volatile gsize crumble_effect_type_id__volatile = 0;
	if (g_once_init_enter (&crumble_effect_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CrumbleEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) crumble_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CrumbleEffect), 0, (GInstanceInitFunc) crumble_effect_instance_init, NULL };
		static const GInterfaceInfo spit_transitions_effect_info = { (GInterfaceInitFunc) crumble_effect_spit_transitions_effect_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType crumble_effect_type_id;
		crumble_effect_type_id = g_type_register_static (G_TYPE_OBJECT, "CrumbleEffect", &g_define_type_info, 0);
		g_type_add_interface_static (crumble_effect_type_id, SPIT_TRANSITIONS_TYPE_EFFECT, &spit_transitions_effect_info);
		g_once_init_leave (&crumble_effect_type_id__volatile, crumble_effect_type_id);
	}
	return crumble_effect_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



