/* ConfigurationInterfaces.c generated by valac 0.32.1, the Vala compiler
 * generated from ConfigurationInterfaces.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <time.h>


#define TYPE_FUZZY_PROPERTY_STATE (fuzzy_property_state_get_type ())

#define TYPE_CONFIGURABLE_PROPERTY (configurable_property_get_type ())

#define TYPE_CONFIGURATION_ENGINE (configuration_engine_get_type ())
#define CONFIGURATION_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_ENGINE, ConfigurationEngine))
#define IS_CONFIGURATION_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_ENGINE))
#define CONFIGURATION_ENGINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_CONFIGURATION_ENGINE, ConfigurationEngineIface))

typedef struct _ConfigurationEngine ConfigurationEngine;
typedef struct _ConfigurationEngineIface ConfigurationEngineIface;

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;
typedef struct _ConfigurationFacadePrivate ConfigurationFacadePrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	CONFIGURATION_ERROR_PROPERTY_HAS_NO_VALUE,
	CONFIGURATION_ERROR_ENGINE_ERROR
} ConfigurationError;
#define CONFIGURATION_ERROR configuration_error_quark ()
typedef enum  {
	FUZZY_PROPERTY_STATE_ENABLED,
	FUZZY_PROPERTY_STATE_DISABLED,
	FUZZY_PROPERTY_STATE_UNKNOWN
} FuzzyPropertyState;

typedef enum  {
	CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY = 0,
	CONFIGURABLE_PROPERTY_BG_COLOR_NAME,
	CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS,
	CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE,
	CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE,
	CONFIGURABLE_PROPERTY_SCREENSAVER_FILE,
	CONFIGURABLE_PROPERTY_SCREENSAVER_MODE,
	CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN,
	CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM,
	CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT,
	CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE,
	CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH,
	CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES,
	CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS,
	CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES,
	CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR,
	CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS,
	CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING,
	CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY,
	CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING,
	CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP,
	CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP,
	CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED,
	CONFIGURABLE_PROPERTY_IMPORT_DIR,
	CONFIGURABLE_PROPERTY_KEEP_RELATIVITY,
	CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT,
	CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE,
	CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH,
	CONFIGURABLE_PROPERTY_LAST_USED_SERVICE,
	CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE,
	CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING,
	CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY,
	CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT,
	CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE,
	CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH,
	CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS,
	CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE,
	CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH,
	CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE,
	CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO,
	CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES,
	CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION,
	CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT,
	CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT,
	CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG,
	CONFIGURABLE_PROPERTY_SIDEBAR_POSITION,
	CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY,
	CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY,
	CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID,
	CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE,
	CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME,
	CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES,
	CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE,
	CONFIGURABLE_PROPERTY_NUM_PROPERTIES
} ConfigurableProperty;

struct _ConfigurationEngineIface {
	GTypeInterface parent_iface;
	gchar* (*get_name) (ConfigurationEngine* self);
	gint (*get_int_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_int_property) (ConfigurationEngine* self, ConfigurableProperty p, gint val, GError** error);
	gchar* (*get_string_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_string_property) (ConfigurationEngine* self, ConfigurableProperty p, const gchar* val, GError** error);
	gboolean (*get_bool_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_bool_property) (ConfigurationEngine* self, ConfigurableProperty p, gboolean val, GError** error);
	gdouble (*get_double_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_double_property) (ConfigurationEngine* self, ConfigurableProperty p, gdouble val, GError** error);
	gboolean (*get_plugin_bool) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
	void (*set_plugin_bool) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
	gdouble (*get_plugin_double) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
	void (*set_plugin_double) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
	gint (*get_plugin_int) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
	void (*set_plugin_int) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
	gchar* (*get_plugin_string) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
	void (*set_plugin_string) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
	void (*unset_plugin_key) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key);
	FuzzyPropertyState (*is_plugin_enabled) (ConfigurationEngine* self, const gchar* id);
	void (*set_plugin_enabled) (ConfigurationEngine* self, const gchar* id, gboolean enabled);
};

struct _Dimensions {
	gint width;
	gint height;
};

typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

struct _ConfigurationFacade {
	GObject parent_instance;
	ConfigurationFacadePrivate * priv;
};

struct _ConfigurationFacadeClass {
	GObjectClass parent_class;
	gboolean (*get_auto_import_from_library) (ConfigurationFacade* self);
	void (*set_auto_import_from_library) (ConfigurationFacade* self, gboolean auto_import);
	gchar* (*get_bg_color_name) (ConfigurationFacade* self);
	void (*set_bg_color_name) (ConfigurationFacade* self, const gchar* color_name);
	gboolean (*get_commit_metadata_to_masters) (ConfigurationFacade* self);
	void (*set_commit_metadata_to_masters) (ConfigurationFacade* self, gboolean commit_metadata);
	gchar* (*get_desktop_background) (ConfigurationFacade* self);
	void (*set_desktop_background) (ConfigurationFacade* self, const gchar* filename);
	gchar* (*get_screensaver) (ConfigurationFacade* self);
	void (*set_screensaver) (ConfigurationFacade* self, const gchar* filename);
	gchar* (*get_directory_pattern) (ConfigurationFacade* self);
	void (*set_directory_pattern) (ConfigurationFacade* self, const gchar* s);
	gchar* (*get_directory_pattern_custom) (ConfigurationFacade* self);
	void (*set_directory_pattern_custom) (ConfigurationFacade* self, const gchar* s);
	void (*get_direct_window_state) (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
	void (*set_direct_window_state) (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
	gboolean (*get_display_basic_properties) (ConfigurationFacade* self);
	void (*set_display_basic_properties) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_extended_properties) (ConfigurationFacade* self);
	void (*set_display_extended_properties) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_sidebar) (ConfigurationFacade* self);
	void (*set_display_sidebar) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_search_bar) (ConfigurationFacade* self);
	void (*set_display_search_bar) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_ratings) (ConfigurationFacade* self);
	void (*set_display_photo_ratings) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_tags) (ConfigurationFacade* self);
	void (*set_display_photo_tags) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_titles) (ConfigurationFacade* self);
	void (*set_display_photo_titles) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_comments) (ConfigurationFacade* self);
	void (*set_display_photo_comments) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_event_comments) (ConfigurationFacade* self);
	void (*set_display_event_comments) (ConfigurationFacade* self, gboolean display);
	void (*get_event_photos_sort) (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
	void (*set_event_photos_sort) (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
	gboolean (*get_events_sort_ascending) (ConfigurationFacade* self);
	void (*set_events_sort_ascending) (ConfigurationFacade* self, gboolean sort);
	gchar* (*get_external_photo_app) (ConfigurationFacade* self);
	void (*set_external_photo_app) (ConfigurationFacade* self, const gchar* external_photo_app);
	gchar* (*get_external_raw_app) (ConfigurationFacade* self);
	void (*set_external_raw_app) (ConfigurationFacade* self, const gchar* external_raw_app);
	RawDeveloper (*get_default_raw_developer) (ConfigurationFacade* self);
	void (*set_default_raw_developer) (ConfigurationFacade* self, RawDeveloper d);
	gboolean (*get_hide_photos_already_imported) (ConfigurationFacade* self);
	void (*set_hide_photos_already_imported) (ConfigurationFacade* self, gboolean hide_imported);
	gchar* (*get_import_dir) (ConfigurationFacade* self);
	void (*set_import_dir) (ConfigurationFacade* self, const gchar* import_dir);
	gboolean (*get_keep_relativity) (ConfigurationFacade* self);
	void (*set_keep_relativity) (ConfigurationFacade* self, gboolean keep_relativity);
	gboolean (*get_pin_toolbar_state) (ConfigurationFacade* self);
	void (*set_pin_toolbar_state) (ConfigurationFacade* self, gboolean state);
	gint (*get_last_crop_height) (ConfigurationFacade* self);
	void (*set_last_crop_height) (ConfigurationFacade* self, gint choice);
	gint (*get_last_crop_menu_choice) (ConfigurationFacade* self);
	void (*set_last_crop_menu_choice) (ConfigurationFacade* self, gint choice);
	gint (*get_last_crop_width) (ConfigurationFacade* self);
	void (*set_last_crop_width) (ConfigurationFacade* self, gint choice);
	gchar* (*get_last_used_service) (ConfigurationFacade* self);
	void (*set_last_used_service) (ConfigurationFacade* self, const gchar* service_name);
	gchar* (*get_last_used_dataimports_service) (ConfigurationFacade* self);
	void (*set_last_used_dataimports_service) (ConfigurationFacade* self, const gchar* service_name);
	void (*get_library_photos_sort) (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
	void (*set_library_photos_sort) (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
	void (*get_library_window_state) (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
	void (*set_library_window_state) (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
	gboolean (*get_modify_originals) (ConfigurationFacade* self);
	void (*set_modify_originals) (ConfigurationFacade* self, gboolean modify_originals);
	gint (*get_photo_thumbnail_scale) (ConfigurationFacade* self);
	void (*set_photo_thumbnail_scale) (ConfigurationFacade* self, gint scale);
	gdouble (*get_printing_content_height) (ConfigurationFacade* self);
	void (*set_printing_content_height) (ConfigurationFacade* self, gdouble content_height);
	gint (*get_printing_content_layout) (ConfigurationFacade* self);
	void (*set_printing_content_layout) (ConfigurationFacade* self, gint layout_code);
	gint (*get_printing_content_ppi) (ConfigurationFacade* self);
	void (*set_printing_content_ppi) (ConfigurationFacade* self, gint content_ppi);
	gint (*get_printing_content_units) (ConfigurationFacade* self);
	void (*set_printing_content_units) (ConfigurationFacade* self, gint units_code);
	gdouble (*get_printing_content_width) (ConfigurationFacade* self);
	void (*set_printing_content_width) (ConfigurationFacade* self, gdouble content_width);
	gint (*get_printing_images_per_page) (ConfigurationFacade* self);
	void (*set_printing_images_per_page) (ConfigurationFacade* self, gint images_per_page_code);
	gboolean (*get_printing_match_aspect_ratio) (ConfigurationFacade* self);
	void (*set_printing_match_aspect_ratio) (ConfigurationFacade* self, gboolean match_aspect_ratio);
	gboolean (*get_printing_print_titles) (ConfigurationFacade* self);
	void (*set_printing_print_titles) (ConfigurationFacade* self, gboolean print_titles);
	gint (*get_printing_size_selection) (ConfigurationFacade* self);
	void (*set_printing_size_selection) (ConfigurationFacade* self, gint size_code);
	gchar* (*get_printing_titles_font) (ConfigurationFacade* self);
	void (*set_printing_titles_font) (ConfigurationFacade* self, const gchar* font_name);
	gboolean (*get_show_welcome_dialog) (ConfigurationFacade* self);
	void (*set_show_welcome_dialog) (ConfigurationFacade* self, gboolean show);
	gint (*get_sidebar_position) (ConfigurationFacade* self);
	void (*set_sidebar_position) (ConfigurationFacade* self, gint position);
	gdouble (*get_slideshow_delay) (ConfigurationFacade* self);
	void (*set_slideshow_delay) (ConfigurationFacade* self, gdouble delay);
	gdouble (*get_slideshow_transition_delay) (ConfigurationFacade* self);
	void (*set_slideshow_transition_delay) (ConfigurationFacade* self, gdouble delay);
	gchar* (*get_slideshow_transition_effect_id) (ConfigurationFacade* self);
	void (*set_slideshow_transition_effect_id) (ConfigurationFacade* self, const gchar* id);
	gboolean (*get_slideshow_show_title) (ConfigurationFacade* self);
	void (*set_slideshow_show_title) (ConfigurationFacade* self, gboolean show_title);
	gboolean (*get_use_24_hour_time) (ConfigurationFacade* self);
	void (*set_use_24_hour_time) (ConfigurationFacade* self, gboolean use_24_hour_time);
	gboolean (*get_use_lowercase_filenames) (ConfigurationFacade* self);
	void (*set_use_lowercase_filenames) (ConfigurationFacade* self, gboolean b);
	gint (*get_video_interpreter_state_cookie) (ConfigurationFacade* self);
	void (*set_video_interpreter_state_cookie) (ConfigurationFacade* self, gint state_cookie);
	gboolean (*get_plugin_bool) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
	void (*set_plugin_bool) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
	gdouble (*get_plugin_double) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
	void (*set_plugin_double) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
	gint (*get_plugin_int) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
	void (*set_plugin_int) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
	gchar* (*get_plugin_string) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
	void (*set_plugin_string) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
	void (*unset_plugin_key) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key);
	FuzzyPropertyState (*is_plugin_enabled) (ConfigurationFacade* self, const gchar* id);
	void (*set_plugin_enabled) (ConfigurationFacade* self, const gchar* id, gboolean enabled);
};

struct _ConfigurationFacadePrivate {
	ConfigurationEngine* engine;
};


static gpointer configuration_facade_parent_class = NULL;

GQuark configuration_error_quark (void);
GType fuzzy_property_state_get_type (void) G_GNUC_CONST;
GType configurable_property_get_type (void) G_GNUC_CONST;
gchar* configurable_property_to_string (ConfigurableProperty self);
GType configuration_engine_get_type (void) G_GNUC_CONST;
gchar* configuration_engine_get_name (ConfigurationEngine* self);
gint configuration_engine_get_int_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
void configuration_engine_set_int_property (ConfigurationEngine* self, ConfigurableProperty p, gint val, GError** error);
gchar* configuration_engine_get_string_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
void configuration_engine_set_string_property (ConfigurationEngine* self, ConfigurableProperty p, const gchar* val, GError** error);
gboolean configuration_engine_get_bool_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
void configuration_engine_set_bool_property (ConfigurationEngine* self, ConfigurableProperty p, gboolean val, GError** error);
gdouble configuration_engine_get_double_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
void configuration_engine_set_double_property (ConfigurationEngine* self, ConfigurableProperty p, gdouble val, GError** error);
gboolean configuration_engine_get_plugin_bool (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
void configuration_engine_set_plugin_bool (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
gdouble configuration_engine_get_plugin_double (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
void configuration_engine_set_plugin_double (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
gint configuration_engine_get_plugin_int (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
void configuration_engine_set_plugin_int (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
gchar* configuration_engine_get_plugin_string (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
void configuration_engine_set_plugin_string (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
void configuration_engine_unset_plugin_key (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key);
FuzzyPropertyState configuration_engine_is_plugin_enabled (ConfigurationEngine* self, const gchar* id);
void configuration_engine_set_plugin_enabled (ConfigurationEngine* self, const gchar* id, gboolean enabled);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType raw_developer_get_type (void) G_GNUC_CONST;
#define CONFIGURATION_FACADE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CONFIGURATION_FACADE, ConfigurationFacadePrivate))
enum  {
	CONFIGURATION_FACADE_DUMMY_PROPERTY
};
ConfigurationFacade* configuration_facade_construct (GType object_type, ConfigurationEngine* engine);
static void configuration_facade_on_property_changed (ConfigurationFacade* self, ConfigurableProperty p);
static void _configuration_facade_on_property_changed_configuration_engine_property_changed (ConfigurationEngine* _sender, ConfigurableProperty p, gpointer self);
ConfigurationEngine* configuration_facade_get_engine (ConfigurationFacade* self);
void configuration_facade_on_configuration_error (ConfigurationFacade* self, GError* err);
gboolean configuration_facade_get_auto_import_from_library (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_auto_import_from_library (ConfigurationFacade* self);
void configuration_facade_set_auto_import_from_library (ConfigurationFacade* self, gboolean auto_import);
static void configuration_facade_real_set_auto_import_from_library (ConfigurationFacade* self, gboolean auto_import);
gchar* configuration_facade_get_bg_color_name (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_bg_color_name (ConfigurationFacade* self);
void configuration_facade_set_bg_color_name (ConfigurationFacade* self, const gchar* color_name);
static void configuration_facade_real_set_bg_color_name (ConfigurationFacade* self, const gchar* color_name);
gboolean configuration_facade_get_commit_metadata_to_masters (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_commit_metadata_to_masters (ConfigurationFacade* self);
void configuration_facade_set_commit_metadata_to_masters (ConfigurationFacade* self, gboolean commit_metadata);
static void configuration_facade_real_set_commit_metadata_to_masters (ConfigurationFacade* self, gboolean commit_metadata);
gchar* configuration_facade_get_desktop_background (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_desktop_background (ConfigurationFacade* self);
void configuration_facade_set_desktop_background (ConfigurationFacade* self, const gchar* filename);
static void configuration_facade_real_set_desktop_background (ConfigurationFacade* self, const gchar* filename);
gchar* configuration_facade_get_screensaver (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_screensaver (ConfigurationFacade* self);
void configuration_facade_set_screensaver (ConfigurationFacade* self, const gchar* filename);
static void configuration_facade_real_set_screensaver (ConfigurationFacade* self, const gchar* filename);
gchar* configuration_facade_get_directory_pattern (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_directory_pattern (ConfigurationFacade* self);
void configuration_facade_set_directory_pattern (ConfigurationFacade* self, const gchar* s);
static void configuration_facade_real_set_directory_pattern (ConfigurationFacade* self, const gchar* s);
gchar* configuration_facade_get_directory_pattern_custom (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_directory_pattern_custom (ConfigurationFacade* self);
void configuration_facade_set_directory_pattern_custom (ConfigurationFacade* self, const gchar* s);
static void configuration_facade_real_set_directory_pattern_custom (ConfigurationFacade* self, const gchar* s);
void configuration_facade_get_direct_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
static void configuration_facade_real_get_direct_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
void dimensions_init (Dimensions *self, gint width, gint height);
void configuration_facade_set_direct_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
static void configuration_facade_real_set_direct_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
gboolean configuration_facade_get_display_basic_properties (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_basic_properties (ConfigurationFacade* self);
void configuration_facade_set_display_basic_properties (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_basic_properties (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_extended_properties (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_extended_properties (ConfigurationFacade* self);
void configuration_facade_set_display_extended_properties (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_extended_properties (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_sidebar (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_sidebar (ConfigurationFacade* self);
void configuration_facade_set_display_sidebar (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_sidebar (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_search_bar (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_search_bar (ConfigurationFacade* self);
void configuration_facade_set_display_search_bar (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_search_bar (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_photo_ratings (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_photo_ratings (ConfigurationFacade* self);
void configuration_facade_set_display_photo_ratings (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_photo_ratings (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_photo_tags (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_photo_tags (ConfigurationFacade* self);
void configuration_facade_set_display_photo_tags (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_photo_tags (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_photo_titles (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_photo_titles (ConfigurationFacade* self);
void configuration_facade_set_display_photo_titles (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_photo_titles (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_photo_comments (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_photo_comments (ConfigurationFacade* self);
void configuration_facade_set_display_photo_comments (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_photo_comments (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_event_comments (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_event_comments (ConfigurationFacade* self);
void configuration_facade_set_display_event_comments (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_event_comments (ConfigurationFacade* self, gboolean display);
void configuration_facade_get_event_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
static void configuration_facade_real_get_event_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
void configuration_facade_set_event_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
static void configuration_facade_real_set_event_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
gboolean configuration_facade_get_events_sort_ascending (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_events_sort_ascending (ConfigurationFacade* self);
void configuration_facade_set_events_sort_ascending (ConfigurationFacade* self, gboolean sort);
static void configuration_facade_real_set_events_sort_ascending (ConfigurationFacade* self, gboolean sort);
gchar* configuration_facade_get_external_photo_app (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_external_photo_app (ConfigurationFacade* self);
void configuration_facade_set_external_photo_app (ConfigurationFacade* self, const gchar* external_photo_app);
static void configuration_facade_real_set_external_photo_app (ConfigurationFacade* self, const gchar* external_photo_app);
gchar* configuration_facade_get_external_raw_app (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_external_raw_app (ConfigurationFacade* self);
void configuration_facade_set_external_raw_app (ConfigurationFacade* self, const gchar* external_raw_app);
static void configuration_facade_real_set_external_raw_app (ConfigurationFacade* self, const gchar* external_raw_app);
RawDeveloper configuration_facade_get_default_raw_developer (ConfigurationFacade* self);
static RawDeveloper configuration_facade_real_get_default_raw_developer (ConfigurationFacade* self);
RawDeveloper raw_developer_from_string (const gchar* value);
void configuration_facade_set_default_raw_developer (ConfigurationFacade* self, RawDeveloper d);
static void configuration_facade_real_set_default_raw_developer (ConfigurationFacade* self, RawDeveloper d);
gchar* raw_developer_to_string (RawDeveloper self);
gboolean configuration_facade_get_hide_photos_already_imported (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_hide_photos_already_imported (ConfigurationFacade* self);
void configuration_facade_set_hide_photos_already_imported (ConfigurationFacade* self, gboolean hide_imported);
static void configuration_facade_real_set_hide_photos_already_imported (ConfigurationFacade* self, gboolean hide_imported);
gchar* configuration_facade_get_import_dir (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_import_dir (ConfigurationFacade* self);
void configuration_facade_set_import_dir (ConfigurationFacade* self, const gchar* import_dir);
static void configuration_facade_real_set_import_dir (ConfigurationFacade* self, const gchar* import_dir);
gboolean configuration_facade_get_keep_relativity (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_keep_relativity (ConfigurationFacade* self);
void configuration_facade_set_keep_relativity (ConfigurationFacade* self, gboolean keep_relativity);
static void configuration_facade_real_set_keep_relativity (ConfigurationFacade* self, gboolean keep_relativity);
gboolean configuration_facade_get_pin_toolbar_state (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_pin_toolbar_state (ConfigurationFacade* self);
void configuration_facade_set_pin_toolbar_state (ConfigurationFacade* self, gboolean state);
static void configuration_facade_real_set_pin_toolbar_state (ConfigurationFacade* self, gboolean state);
gint configuration_facade_get_last_crop_height (ConfigurationFacade* self);
static gint configuration_facade_real_get_last_crop_height (ConfigurationFacade* self);
void configuration_facade_set_last_crop_height (ConfigurationFacade* self, gint choice);
static void configuration_facade_real_set_last_crop_height (ConfigurationFacade* self, gint choice);
gint configuration_facade_get_last_crop_menu_choice (ConfigurationFacade* self);
static gint configuration_facade_real_get_last_crop_menu_choice (ConfigurationFacade* self);
void configuration_facade_set_last_crop_menu_choice (ConfigurationFacade* self, gint choice);
static void configuration_facade_real_set_last_crop_menu_choice (ConfigurationFacade* self, gint choice);
gint configuration_facade_get_last_crop_width (ConfigurationFacade* self);
static gint configuration_facade_real_get_last_crop_width (ConfigurationFacade* self);
void configuration_facade_set_last_crop_width (ConfigurationFacade* self, gint choice);
static void configuration_facade_real_set_last_crop_width (ConfigurationFacade* self, gint choice);
gchar* configuration_facade_get_last_used_service (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_last_used_service (ConfigurationFacade* self);
void configuration_facade_set_last_used_service (ConfigurationFacade* self, const gchar* service_name);
static void configuration_facade_real_set_last_used_service (ConfigurationFacade* self, const gchar* service_name);
gchar* configuration_facade_get_last_used_dataimports_service (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_last_used_dataimports_service (ConfigurationFacade* self);
void configuration_facade_set_last_used_dataimports_service (ConfigurationFacade* self, const gchar* service_name);
static void configuration_facade_real_set_last_used_dataimports_service (ConfigurationFacade* self, const gchar* service_name);
void configuration_facade_get_library_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
static void configuration_facade_real_get_library_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
void configuration_facade_set_library_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
static void configuration_facade_real_set_library_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
void configuration_facade_get_library_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
static void configuration_facade_real_get_library_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
void configuration_facade_set_library_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
static void configuration_facade_real_set_library_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
gboolean configuration_facade_get_modify_originals (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_modify_originals (ConfigurationFacade* self);
void configuration_facade_set_modify_originals (ConfigurationFacade* self, gboolean modify_originals);
static void configuration_facade_real_set_modify_originals (ConfigurationFacade* self, gboolean modify_originals);
gint configuration_facade_get_photo_thumbnail_scale (ConfigurationFacade* self);
static gint configuration_facade_real_get_photo_thumbnail_scale (ConfigurationFacade* self);
gint thumbnail_get_DEFAULT_SCALE (void);
void configuration_facade_set_photo_thumbnail_scale (ConfigurationFacade* self, gint scale);
static void configuration_facade_real_set_photo_thumbnail_scale (ConfigurationFacade* self, gint scale);
gdouble configuration_facade_get_printing_content_height (ConfigurationFacade* self);
static gdouble configuration_facade_real_get_printing_content_height (ConfigurationFacade* self);
void configuration_facade_set_printing_content_height (ConfigurationFacade* self, gdouble content_height);
static void configuration_facade_real_set_printing_content_height (ConfigurationFacade* self, gdouble content_height);
gint configuration_facade_get_printing_content_layout (ConfigurationFacade* self);
static gint configuration_facade_real_get_printing_content_layout (ConfigurationFacade* self);
void configuration_facade_set_printing_content_layout (ConfigurationFacade* self, gint layout_code);
static void configuration_facade_real_set_printing_content_layout (ConfigurationFacade* self, gint layout_code);
gint configuration_facade_get_printing_content_ppi (ConfigurationFacade* self);
static gint configuration_facade_real_get_printing_content_ppi (ConfigurationFacade* self);
void configuration_facade_set_printing_content_ppi (ConfigurationFacade* self, gint content_ppi);
static void configuration_facade_real_set_printing_content_ppi (ConfigurationFacade* self, gint content_ppi);
gint configuration_facade_get_printing_content_units (ConfigurationFacade* self);
static gint configuration_facade_real_get_printing_content_units (ConfigurationFacade* self);
void configuration_facade_set_printing_content_units (ConfigurationFacade* self, gint units_code);
static void configuration_facade_real_set_printing_content_units (ConfigurationFacade* self, gint units_code);
gdouble configuration_facade_get_printing_content_width (ConfigurationFacade* self);
static gdouble configuration_facade_real_get_printing_content_width (ConfigurationFacade* self);
void configuration_facade_set_printing_content_width (ConfigurationFacade* self, gdouble content_width);
static void configuration_facade_real_set_printing_content_width (ConfigurationFacade* self, gdouble content_width);
gint configuration_facade_get_printing_images_per_page (ConfigurationFacade* self);
static gint configuration_facade_real_get_printing_images_per_page (ConfigurationFacade* self);
void configuration_facade_set_printing_images_per_page (ConfigurationFacade* self, gint images_per_page_code);
static void configuration_facade_real_set_printing_images_per_page (ConfigurationFacade* self, gint images_per_page_code);
gboolean configuration_facade_get_printing_match_aspect_ratio (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_printing_match_aspect_ratio (ConfigurationFacade* self);
void configuration_facade_set_printing_match_aspect_ratio (ConfigurationFacade* self, gboolean match_aspect_ratio);
static void configuration_facade_real_set_printing_match_aspect_ratio (ConfigurationFacade* self, gboolean match_aspect_ratio);
gboolean configuration_facade_get_printing_print_titles (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_printing_print_titles (ConfigurationFacade* self);
void configuration_facade_set_printing_print_titles (ConfigurationFacade* self, gboolean print_titles);
static void configuration_facade_real_set_printing_print_titles (ConfigurationFacade* self, gboolean print_titles);
gint configuration_facade_get_printing_size_selection (ConfigurationFacade* self);
static gint configuration_facade_real_get_printing_size_selection (ConfigurationFacade* self);
void configuration_facade_set_printing_size_selection (ConfigurationFacade* self, gint size_code);
static void configuration_facade_real_set_printing_size_selection (ConfigurationFacade* self, gint size_code);
gchar* configuration_facade_get_printing_titles_font (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_printing_titles_font (ConfigurationFacade* self);
void configuration_facade_set_printing_titles_font (ConfigurationFacade* self, const gchar* font_name);
static void configuration_facade_real_set_printing_titles_font (ConfigurationFacade* self, const gchar* font_name);
gboolean configuration_facade_get_show_welcome_dialog (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_show_welcome_dialog (ConfigurationFacade* self);
void configuration_facade_set_show_welcome_dialog (ConfigurationFacade* self, gboolean show);
static void configuration_facade_real_set_show_welcome_dialog (ConfigurationFacade* self, gboolean show);
gint configuration_facade_get_sidebar_position (ConfigurationFacade* self);
static gint configuration_facade_real_get_sidebar_position (ConfigurationFacade* self);
void configuration_facade_set_sidebar_position (ConfigurationFacade* self, gint position);
static void configuration_facade_real_set_sidebar_position (ConfigurationFacade* self, gint position);
gdouble configuration_facade_get_slideshow_delay (ConfigurationFacade* self);
static gdouble configuration_facade_real_get_slideshow_delay (ConfigurationFacade* self);
void configuration_facade_set_slideshow_delay (ConfigurationFacade* self, gdouble delay);
static void configuration_facade_real_set_slideshow_delay (ConfigurationFacade* self, gdouble delay);
gdouble configuration_facade_get_slideshow_transition_delay (ConfigurationFacade* self);
static gdouble configuration_facade_real_get_slideshow_transition_delay (ConfigurationFacade* self);
void configuration_facade_set_slideshow_transition_delay (ConfigurationFacade* self, gdouble delay);
static void configuration_facade_real_set_slideshow_transition_delay (ConfigurationFacade* self, gdouble delay);
gchar* configuration_facade_get_slideshow_transition_effect_id (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_slideshow_transition_effect_id (ConfigurationFacade* self);
#define NULL_TRANSITION_DESCRIPTOR_EFFECT_ID "org.yorba.shotwell.transitions.null"
#define TRANSITION_EFFECTS_MANAGER_NULL_EFFECT_ID NULL_TRANSITION_DESCRIPTOR_EFFECT_ID
void configuration_facade_set_slideshow_transition_effect_id (ConfigurationFacade* self, const gchar* id);
static void configuration_facade_real_set_slideshow_transition_effect_id (ConfigurationFacade* self, const gchar* id);
gboolean configuration_facade_get_slideshow_show_title (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_slideshow_show_title (ConfigurationFacade* self);
void configuration_facade_set_slideshow_show_title (ConfigurationFacade* self, gboolean show_title);
static void configuration_facade_real_set_slideshow_show_title (ConfigurationFacade* self, gboolean show_title);
gboolean configuration_facade_get_use_24_hour_time (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_use_24_hour_time (ConfigurationFacade* self);
gboolean is_string_empty (const gchar* s);
void configuration_facade_set_use_24_hour_time (ConfigurationFacade* self, gboolean use_24_hour_time);
static void configuration_facade_real_set_use_24_hour_time (ConfigurationFacade* self, gboolean use_24_hour_time);
gboolean configuration_facade_get_use_lowercase_filenames (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_use_lowercase_filenames (ConfigurationFacade* self);
void configuration_facade_set_use_lowercase_filenames (ConfigurationFacade* self, gboolean b);
static void configuration_facade_real_set_use_lowercase_filenames (ConfigurationFacade* self, gboolean b);
gint configuration_facade_get_video_interpreter_state_cookie (ConfigurationFacade* self);
static gint configuration_facade_real_get_video_interpreter_state_cookie (ConfigurationFacade* self);
void configuration_facade_set_video_interpreter_state_cookie (ConfigurationFacade* self, gint state_cookie);
static void configuration_facade_real_set_video_interpreter_state_cookie (ConfigurationFacade* self, gint state_cookie);
gboolean configuration_facade_get_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
static gboolean configuration_facade_real_get_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
void configuration_facade_set_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
static void configuration_facade_real_set_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
gdouble configuration_facade_get_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
static gdouble configuration_facade_real_get_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
void configuration_facade_set_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
static void configuration_facade_real_set_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
gint configuration_facade_get_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
static gint configuration_facade_real_get_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
void configuration_facade_set_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
static void configuration_facade_real_set_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
gchar* configuration_facade_get_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
static gchar* configuration_facade_real_get_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
void configuration_facade_set_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
static void configuration_facade_real_set_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
void configuration_facade_unset_plugin_key (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key);
static void configuration_facade_real_unset_plugin_key (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key);
FuzzyPropertyState configuration_facade_is_plugin_enabled (ConfigurationFacade* self, const gchar* id);
static FuzzyPropertyState configuration_facade_real_is_plugin_enabled (ConfigurationFacade* self, const gchar* id);
void configuration_facade_set_plugin_enabled (ConfigurationFacade* self, const gchar* id, gboolean enabled);
static void configuration_facade_real_set_plugin_enabled (ConfigurationFacade* self, const gchar* id, gboolean enabled);
static void configuration_facade_finalize (GObject* obj);


GQuark configuration_error_quark (void) {
	return g_quark_from_static_string ("configuration_error-quark");
}


GType fuzzy_property_state_get_type (void) {
	static volatile gsize fuzzy_property_state_type_id__volatile = 0;
	if (g_once_init_enter (&fuzzy_property_state_type_id__volatile)) {
		static const GEnumValue values[] = {{FUZZY_PROPERTY_STATE_ENABLED, "FUZZY_PROPERTY_STATE_ENABLED", "enabled"}, {FUZZY_PROPERTY_STATE_DISABLED, "FUZZY_PROPERTY_STATE_DISABLED", "disabled"}, {FUZZY_PROPERTY_STATE_UNKNOWN, "FUZZY_PROPERTY_STATE_UNKNOWN", "unknown"}, {0, NULL, NULL}};
		GType fuzzy_property_state_type_id;
		fuzzy_property_state_type_id = g_enum_register_static ("FuzzyPropertyState", values);
		g_once_init_leave (&fuzzy_property_state_type_id__volatile, fuzzy_property_state_type_id);
	}
	return fuzzy_property_state_type_id__volatile;
}


gchar* configurable_property_to_string (ConfigurableProperty self) {
	gchar* result = NULL;
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	switch (self) {
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY:
#line 608 "ConfigurationInterfaces.c"
		{
			gchar* _tmp0_ = NULL;
#line 92 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp0_ = g_strdup ("AUTO_IMPORT_FROM_LIBRARY");
#line 92 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp0_;
#line 92 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 617 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_BG_COLOR_NAME:
#line 621 "ConfigurationInterfaces.c"
		{
			gchar* _tmp1_ = NULL;
#line 95 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp1_ = g_strdup ("BG_COLOR_NAME");
#line 95 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp1_;
#line 95 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 630 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS:
#line 634 "ConfigurationInterfaces.c"
		{
			gchar* _tmp2_ = NULL;
#line 98 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp2_ = g_strdup ("COMMIT_METADATA_TO_MASTERS");
#line 98 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp2_;
#line 98 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 643 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE:
#line 647 "ConfigurationInterfaces.c"
		{
			gchar* _tmp3_ = NULL;
#line 101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp3_ = g_strdup ("DESKTOP_BACKGROUND_FILE");
#line 101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp3_;
#line 101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 656 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE:
#line 660 "ConfigurationInterfaces.c"
		{
			gchar* _tmp4_ = NULL;
#line 104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp4_ = g_strdup ("DESKTOP_BACKGROUND_MODE");
#line 104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp4_;
#line 104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 669 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SCREENSAVER_FILE:
#line 673 "ConfigurationInterfaces.c"
		{
			gchar* _tmp5_ = NULL;
#line 107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp5_ = g_strdup ("SCREENSAVER_FILE");
#line 107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp5_;
#line 107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 682 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SCREENSAVER_MODE:
#line 686 "ConfigurationInterfaces.c"
		{
			gchar* _tmp6_ = NULL;
#line 110 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp6_ = g_strdup ("SCREENSAVER_MODE");
#line 110 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp6_;
#line 110 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 695 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN:
#line 699 "ConfigurationInterfaces.c"
		{
			gchar* _tmp7_ = NULL;
#line 113 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp7_ = g_strdup ("DIRECTORY_PATTERN");
#line 113 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp7_;
#line 113 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 708 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM:
#line 712 "ConfigurationInterfaces.c"
		{
			gchar* _tmp8_ = NULL;
#line 116 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp8_ = g_strdup ("DIRECTORY_PATTERN_CUSTOM");
#line 116 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp8_;
#line 116 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 721 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT:
#line 725 "ConfigurationInterfaces.c"
		{
			gchar* _tmp9_ = NULL;
#line 119 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp9_ = g_strdup ("DIRECT_WINDOW_HEIGHT");
#line 119 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp9_;
#line 119 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 734 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE:
#line 738 "ConfigurationInterfaces.c"
		{
			gchar* _tmp10_ = NULL;
#line 122 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp10_ = g_strdup ("DIRECT_WINDOW_MAXIMIZE");
#line 122 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp10_;
#line 122 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 747 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH:
#line 751 "ConfigurationInterfaces.c"
		{
			gchar* _tmp11_ = NULL;
#line 125 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp11_ = g_strdup ("DIRECT_WINDOW_WIDTH");
#line 125 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp11_;
#line 125 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 760 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES:
#line 764 "ConfigurationInterfaces.c"
		{
			gchar* _tmp12_ = NULL;
#line 128 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp12_ = g_strdup ("DISPLAY_BASIC_PROPERTIES");
#line 128 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp12_;
#line 128 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 773 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES:
#line 777 "ConfigurationInterfaces.c"
		{
			gchar* _tmp13_ = NULL;
#line 131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp13_ = g_strdup ("DISPLAY_EXTENDED_PROPERTIES");
#line 131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp13_;
#line 131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 786 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR:
#line 790 "ConfigurationInterfaces.c"
		{
			gchar* _tmp14_ = NULL;
#line 134 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp14_ = g_strdup ("DISPLAY_SIDEBAR");
#line 134 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp14_;
#line 134 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 799 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR:
#line 803 "ConfigurationInterfaces.c"
		{
			gchar* _tmp15_ = NULL;
#line 137 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp15_ = g_strdup ("DISPLAY_SEARCH_BAR");
#line 137 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp15_;
#line 137 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 812 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS:
#line 816 "ConfigurationInterfaces.c"
		{
			gchar* _tmp16_ = NULL;
#line 140 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp16_ = g_strdup ("DISPLAY_PHOTO_RATINGS");
#line 140 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp16_;
#line 140 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 825 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS:
#line 829 "ConfigurationInterfaces.c"
		{
			gchar* _tmp17_ = NULL;
#line 143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp17_ = g_strdup ("DISPLAY_PHOTO_TAGS");
#line 143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp17_;
#line 143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 838 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES:
#line 842 "ConfigurationInterfaces.c"
		{
			gchar* _tmp18_ = NULL;
#line 146 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp18_ = g_strdup ("DISPLAY_PHOTO_TITLES");
#line 146 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp18_;
#line 146 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 851 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS:
#line 855 "ConfigurationInterfaces.c"
		{
			gchar* _tmp19_ = NULL;
#line 149 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp19_ = g_strdup ("DISPLAY_PHOTO_COMMENTS");
#line 149 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp19_;
#line 149 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 864 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS:
#line 868 "ConfigurationInterfaces.c"
		{
			gchar* _tmp20_ = NULL;
#line 152 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp20_ = g_strdup ("DISPLAY_EVENT_COMMENTS");
#line 152 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp20_;
#line 152 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 877 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING:
#line 881 "ConfigurationInterfaces.c"
		{
			gchar* _tmp21_ = NULL;
#line 155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp21_ = g_strdup ("EVENT_PHOTOS_SORT_ASCENDING");
#line 155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp21_;
#line 155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 890 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY:
#line 894 "ConfigurationInterfaces.c"
		{
			gchar* _tmp22_ = NULL;
#line 158 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp22_ = g_strdup ("EVENT_PHOTOS_SORT_BY");
#line 158 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp22_;
#line 158 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 903 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING:
#line 907 "ConfigurationInterfaces.c"
		{
			gchar* _tmp23_ = NULL;
#line 161 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp23_ = g_strdup ("EVENTS_SORT_ASCENDING");
#line 161 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp23_;
#line 161 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 916 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP:
#line 920 "ConfigurationInterfaces.c"
		{
			gchar* _tmp24_ = NULL;
#line 164 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp24_ = g_strdup ("EXTERNAL_PHOTO_APP");
#line 164 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp24_;
#line 164 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 929 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP:
#line 933 "ConfigurationInterfaces.c"
		{
			gchar* _tmp25_ = NULL;
#line 167 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp25_ = g_strdup ("EXTERNAL_RAW_APP");
#line 167 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp25_;
#line 167 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 942 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED:
#line 946 "ConfigurationInterfaces.c"
		{
			gchar* _tmp26_ = NULL;
#line 170 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp26_ = g_strdup ("HIDE_PHOTOS_ALREADY_IMPORTED");
#line 170 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp26_;
#line 170 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 955 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_IMPORT_DIR:
#line 959 "ConfigurationInterfaces.c"
		{
			gchar* _tmp27_ = NULL;
#line 173 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp27_ = g_strdup ("IMPORT_DIR");
#line 173 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp27_;
#line 173 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 968 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_KEEP_RELATIVITY:
#line 972 "ConfigurationInterfaces.c"
		{
			gchar* _tmp28_ = NULL;
#line 176 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp28_ = g_strdup ("KEEP_RELATIVITY");
#line 176 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp28_;
#line 176 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 981 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT:
#line 985 "ConfigurationInterfaces.c"
		{
			gchar* _tmp29_ = NULL;
#line 179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp29_ = g_strdup ("LAST_CROP_HEIGHT");
#line 179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp29_;
#line 179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 994 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE:
#line 998 "ConfigurationInterfaces.c"
		{
			gchar* _tmp30_ = NULL;
#line 182 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp30_ = g_strdup ("LAST_CROP_MENU_CHOICE");
#line 182 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp30_;
#line 182 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1007 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH:
#line 1011 "ConfigurationInterfaces.c"
		{
			gchar* _tmp31_ = NULL;
#line 185 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp31_ = g_strdup ("LAST_CROP_WIDTH");
#line 185 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp31_;
#line 185 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1020 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LAST_USED_SERVICE:
#line 1024 "ConfigurationInterfaces.c"
		{
			gchar* _tmp32_ = NULL;
#line 188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp32_ = g_strdup ("LAST_USED_SERVICE");
#line 188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp32_;
#line 188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1033 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE:
#line 1037 "ConfigurationInterfaces.c"
		{
			gchar* _tmp33_ = NULL;
#line 191 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp33_ = g_strdup ("LAST_USED_DATAIMPORTS_SERVICE");
#line 191 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp33_;
#line 191 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1046 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING:
#line 1050 "ConfigurationInterfaces.c"
		{
			gchar* _tmp34_ = NULL;
#line 194 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp34_ = g_strdup ("LIBRARY_PHOTOS_SORT_ASCENDING");
#line 194 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp34_;
#line 194 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1059 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY:
#line 1063 "ConfigurationInterfaces.c"
		{
			gchar* _tmp35_ = NULL;
#line 197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp35_ = g_strdup ("LIBRARY_PHOTOS_SORT_BY");
#line 197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp35_;
#line 197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1072 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT:
#line 1076 "ConfigurationInterfaces.c"
		{
			gchar* _tmp36_ = NULL;
#line 200 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp36_ = g_strdup ("LIBRARY_WINDOW_HEIGHT");
#line 200 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp36_;
#line 200 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1085 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE:
#line 1089 "ConfigurationInterfaces.c"
		{
			gchar* _tmp37_ = NULL;
#line 203 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp37_ = g_strdup ("LIBRARY_WINDOW_MAXIMIZE");
#line 203 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp37_;
#line 203 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1098 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH:
#line 1102 "ConfigurationInterfaces.c"
		{
			gchar* _tmp38_ = NULL;
#line 206 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp38_ = g_strdup ("LIBRARY_WINDOW_WIDTH");
#line 206 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp38_;
#line 206 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1111 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS:
#line 1115 "ConfigurationInterfaces.c"
		{
			gchar* _tmp39_ = NULL;
#line 209 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp39_ = g_strdup ("MODIFY_ORIGINALS");
#line 209 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp39_;
#line 209 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1124 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE:
#line 1128 "ConfigurationInterfaces.c"
		{
			gchar* _tmp40_ = NULL;
#line 212 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp40_ = g_strdup ("PHOTO_THUMBNAIL_SCALE");
#line 212 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp40_;
#line 212 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1137 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE:
#line 1141 "ConfigurationInterfaces.c"
		{
			gchar* _tmp41_ = NULL;
#line 215 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp41_ = g_strdup ("PIN_TOOLBAR_STATE");
#line 215 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp41_;
#line 215 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1150 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT:
#line 1154 "ConfigurationInterfaces.c"
		{
			gchar* _tmp42_ = NULL;
#line 218 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp42_ = g_strdup ("PRINTING_CONTENT_HEIGHT");
#line 218 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp42_;
#line 218 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1163 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT:
#line 1167 "ConfigurationInterfaces.c"
		{
			gchar* _tmp43_ = NULL;
#line 221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp43_ = g_strdup ("PRINTING_CONTENT_LAYOUT");
#line 221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp43_;
#line 221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1176 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI:
#line 1180 "ConfigurationInterfaces.c"
		{
			gchar* _tmp44_ = NULL;
#line 224 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp44_ = g_strdup ("PRINTING_CONTENT_PPI");
#line 224 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp44_;
#line 224 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1189 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS:
#line 1193 "ConfigurationInterfaces.c"
		{
			gchar* _tmp45_ = NULL;
#line 227 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp45_ = g_strdup ("PRINTING_CONTENT_UNITS");
#line 227 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp45_;
#line 227 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1202 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH:
#line 1206 "ConfigurationInterfaces.c"
		{
			gchar* _tmp46_ = NULL;
#line 230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp46_ = g_strdup ("PRINTING_CONTENT_WIDTH");
#line 230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp46_;
#line 230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1215 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE:
#line 1219 "ConfigurationInterfaces.c"
		{
			gchar* _tmp47_ = NULL;
#line 233 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp47_ = g_strdup ("PRINTING_IMAGES_PER_PAGE");
#line 233 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp47_;
#line 233 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1228 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO:
#line 1232 "ConfigurationInterfaces.c"
		{
			gchar* _tmp48_ = NULL;
#line 236 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp48_ = g_strdup ("PRINTING_MATCH_ASPECT_RATIO");
#line 236 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp48_;
#line 236 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1241 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES:
#line 1245 "ConfigurationInterfaces.c"
		{
			gchar* _tmp49_ = NULL;
#line 239 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp49_ = g_strdup ("PRINTING_PRINT_TITLES");
#line 239 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp49_;
#line 239 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1254 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION:
#line 1258 "ConfigurationInterfaces.c"
		{
			gchar* _tmp50_ = NULL;
#line 242 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp50_ = g_strdup ("PRINTING_SIZE_SELECTION");
#line 242 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp50_;
#line 242 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1267 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT:
#line 1271 "ConfigurationInterfaces.c"
		{
			gchar* _tmp51_ = NULL;
#line 245 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp51_ = g_strdup ("PRINTING_TITLES_FONT");
#line 245 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp51_;
#line 245 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1280 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT:
#line 1284 "ConfigurationInterfaces.c"
		{
			gchar* _tmp52_ = NULL;
#line 248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp52_ = g_strdup ("RAW_DEVELOPER_DEFAULT");
#line 248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp52_;
#line 248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1293 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG:
#line 1297 "ConfigurationInterfaces.c"
		{
			gchar* _tmp53_ = NULL;
#line 251 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp53_ = g_strdup ("SHOW_WELCOME_DIALOG");
#line 251 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp53_;
#line 251 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1306 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SIDEBAR_POSITION:
#line 1310 "ConfigurationInterfaces.c"
		{
			gchar* _tmp54_ = NULL;
#line 254 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp54_ = g_strdup ("SIDEBAR_POSITION");
#line 254 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp54_;
#line 254 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1319 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY:
#line 1323 "ConfigurationInterfaces.c"
		{
			gchar* _tmp55_ = NULL;
#line 257 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp55_ = g_strdup ("SLIDESHOW_DELAY");
#line 257 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp55_;
#line 257 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1332 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY:
#line 1336 "ConfigurationInterfaces.c"
		{
			gchar* _tmp56_ = NULL;
#line 260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp56_ = g_strdup ("SLIDESHOW_TRANSITION_DELAY");
#line 260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp56_;
#line 260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1345 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID:
#line 1349 "ConfigurationInterfaces.c"
		{
			gchar* _tmp57_ = NULL;
#line 263 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp57_ = g_strdup ("SLIDESHOW_TRANSITION_EFFECT_ID");
#line 263 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp57_;
#line 263 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1358 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE:
#line 1362 "ConfigurationInterfaces.c"
		{
			gchar* _tmp58_ = NULL;
#line 266 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp58_ = g_strdup ("SLIDESHOW_SHOW_TITLE");
#line 266 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp58_;
#line 266 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1371 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME:
#line 1375 "ConfigurationInterfaces.c"
		{
			gchar* _tmp59_ = NULL;
#line 269 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp59_ = g_strdup ("USE_24_HOUR_TIME");
#line 269 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp59_;
#line 269 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1384 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES:
#line 1388 "ConfigurationInterfaces.c"
		{
			gchar* _tmp60_ = NULL;
#line 272 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp60_ = g_strdup ("USE_LOWERCASE_FILENAMES");
#line 272 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp60_;
#line 272 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1397 "ConfigurationInterfaces.c"
		}
#line 90 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE:
#line 1401 "ConfigurationInterfaces.c"
		{
			gchar* _tmp61_ = NULL;
#line 275 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp61_ = g_strdup ("VIDEO_INTERPRETER_STATE_COOKIE");
#line 275 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp61_;
#line 275 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1410 "ConfigurationInterfaces.c"
		}
		default:
		{
#line 278 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_error ("ConfigurationInterfaces.vala:278: unknown ConfigurableProperty enumera" \
"tion value");
#line 1416 "ConfigurationInterfaces.c"
		}
	}
}


GType configurable_property_get_type (void) {
	static volatile gsize configurable_property_type_id__volatile = 0;
	if (g_once_init_enter (&configurable_property_type_id__volatile)) {
		static const GEnumValue values[] = {{CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY, "CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY", "auto-import-from-library"}, {CONFIGURABLE_PROPERTY_BG_COLOR_NAME, "CONFIGURABLE_PROPERTY_BG_COLOR_NAME", "bg-color-name"}, {CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS, "CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS", "commit-metadata-to-masters"}, {CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE, "CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE", "desktop-background-file"}, {CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE, "CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE", "desktop-background-mode"}, {CONFIGURABLE_PROPERTY_SCREENSAVER_FILE, "CONFIGURABLE_PROPERTY_SCREENSAVER_FILE", "screensaver-file"}, {CONFIGURABLE_PROPERTY_SCREENSAVER_MODE, "CONFIGURABLE_PROPERTY_SCREENSAVER_MODE", "screensaver-mode"}, {CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN, "CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN", "directory-pattern"}, {CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM, "CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM", "directory-pattern-custom"}, {CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT, "CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT", "direct-window-height"}, {CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE, "CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE", "direct-window-maximize"}, {CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH, "CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH", "direct-window-width"}, {CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES, "CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES", "display-basic-properties"}, {CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS, "CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS", "display-event-comments"}, {CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES, "CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES", "display-extended-properties"}, {CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR, "CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR", "display-sidebar"}, {CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR, "CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR", "display-search-bar"}, {CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS, "CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS", "display-photo-ratings"}, {CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS, "CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS", "display-photo-tags"}, {CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES, "CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES", "display-photo-titles"}, {CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS, "CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS", "display-photo-comments"}, {CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING, "CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING", "event-photos-sort-ascending"}, {CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY, "CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY", "event-photos-sort-by"}, {CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING, "CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING", "events-sort-ascending"}, {CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP, "CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP", "external-photo-app"}, {CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP, "CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP", "external-raw-app"}, {CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED, "CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED", "hide-photos-already-imported"}, {CONFIGURABLE_PROPERTY_IMPORT_DIR, "CONFIGURABLE_PROPERTY_IMPORT_DIR", "import-dir"}, {CONFIGURABLE_PROPERTY_KEEP_RELATIVITY, "CONFIGURABLE_PROPERTY_KEEP_RELATIVITY", "keep-relativity"}, {CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT, "CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT", "last-crop-height"}, {CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE, "CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE", "last-crop-menu-choice"}, {CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH, "CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH", "last-crop-width"}, {CONFIGURABLE_PROPERTY_LAST_USED_SERVICE, "CONFIGURABLE_PROPERTY_LAST_USED_SERVICE", "last-used-service"}, {CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE, "CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE", "last-used-dataimports-service"}, {CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING, "CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING", "library-photos-sort-ascending"}, {CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY, "CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY", "library-photos-sort-by"}, {CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT, "CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT", "library-window-height"}, {CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE, "CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE", "library-window-maximize"}, {CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH, "CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH", "library-window-width"}, {CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS, "CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS", "modify-originals"}, {CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE, "CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE", "photo-thumbnail-scale"}, {CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE, "CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE", "pin-toolbar-state"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT", "printing-content-height"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT", "printing-content-layout"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI", "printing-content-ppi"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS", "printing-content-units"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH", "printing-content-width"}, {CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE, "CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE", "printing-images-per-page"}, {CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO, "CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO", "printing-match-aspect-ratio"}, {CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES, "CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES", "printing-print-titles"}, {CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION, "CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION", "printing-size-selection"}, {CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT, "CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT", "printing-titles-font"}, {CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT, "CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT", "raw-developer-default"}, {CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG, "CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG", "show-welcome-dialog"}, {CONFIGURABLE_PROPERTY_SIDEBAR_POSITION, "CONFIGURABLE_PROPERTY_SIDEBAR_POSITION", "sidebar-position"}, {CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY, "CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY", "slideshow-delay"}, {CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY, "CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY", "slideshow-transition-delay"}, {CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID, "CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID", "slideshow-transition-effect-id"}, {CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE, "CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE", "slideshow-show-title"}, {CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME, "CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME", "use-24-hour-time"}, {CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES, "CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES", "use-lowercase-filenames"}, {CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE, "CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE", "video-interpreter-state-cookie"}, {CONFIGURABLE_PROPERTY_NUM_PROPERTIES, "CONFIGURABLE_PROPERTY_NUM_PROPERTIES", "num-properties"}, {0, NULL, NULL}};
		GType configurable_property_type_id;
		configurable_property_type_id = g_enum_register_static ("ConfigurableProperty", values);
		g_once_init_leave (&configurable_property_type_id__volatile, configurable_property_type_id);
	}
	return configurable_property_type_id__volatile;
}


gchar* configuration_engine_get_name (ConfigurationEngine* self) {
#line 286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), NULL);
#line 286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_name (self);
#line 1439 "ConfigurationInterfaces.c"
}


gint configuration_engine_get_int_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error) {
#line 288 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0);
#line 288 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_int_property (self, p, error);
#line 1448 "ConfigurationInterfaces.c"
}


void configuration_engine_set_int_property (ConfigurationEngine* self, ConfigurableProperty p, gint val, GError** error) {
#line 289 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 289 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_int_property (self, p, val, error);
#line 1457 "ConfigurationInterfaces.c"
}


gchar* configuration_engine_get_string_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error) {
#line 291 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), NULL);
#line 291 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_string_property (self, p, error);
#line 1466 "ConfigurationInterfaces.c"
}


void configuration_engine_set_string_property (ConfigurationEngine* self, ConfigurableProperty p, const gchar* val, GError** error) {
#line 292 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 292 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_string_property (self, p, val, error);
#line 1475 "ConfigurationInterfaces.c"
}


gboolean configuration_engine_get_bool_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error) {
#line 294 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), FALSE);
#line 294 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_bool_property (self, p, error);
#line 1484 "ConfigurationInterfaces.c"
}


void configuration_engine_set_bool_property (ConfigurationEngine* self, ConfigurableProperty p, gboolean val, GError** error) {
#line 295 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 295 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_bool_property (self, p, val, error);
#line 1493 "ConfigurationInterfaces.c"
}


gdouble configuration_engine_get_double_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error) {
#line 297 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0.0);
#line 297 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_double_property (self, p, error);
#line 1502 "ConfigurationInterfaces.c"
}


void configuration_engine_set_double_property (ConfigurationEngine* self, ConfigurableProperty p, gdouble val, GError** error) {
#line 298 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 298 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_double_property (self, p, val, error);
#line 1511 "ConfigurationInterfaces.c"
}


gboolean configuration_engine_get_plugin_bool (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def) {
#line 300 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), FALSE);
#line 300 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_plugin_bool (self, domain, id, key, def);
#line 1520 "ConfigurationInterfaces.c"
}


void configuration_engine_set_plugin_bool (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val) {
#line 301 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 301 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_plugin_bool (self, domain, id, key, val);
#line 1529 "ConfigurationInterfaces.c"
}


gdouble configuration_engine_get_plugin_double (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def) {
#line 302 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0.0);
#line 302 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_plugin_double (self, domain, id, key, def);
#line 1538 "ConfigurationInterfaces.c"
}


void configuration_engine_set_plugin_double (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val) {
#line 303 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 303 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_plugin_double (self, domain, id, key, val);
#line 1547 "ConfigurationInterfaces.c"
}


gint configuration_engine_get_plugin_int (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint def) {
#line 304 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0);
#line 304 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_plugin_int (self, domain, id, key, def);
#line 1556 "ConfigurationInterfaces.c"
}


void configuration_engine_set_plugin_int (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint val) {
#line 305 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 305 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_plugin_int (self, domain, id, key, val);
#line 1565 "ConfigurationInterfaces.c"
}


gchar* configuration_engine_get_plugin_string (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def) {
#line 306 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), NULL);
#line 306 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_plugin_string (self, domain, id, key, def);
#line 1574 "ConfigurationInterfaces.c"
}


void configuration_engine_set_plugin_string (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val) {
#line 307 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 307 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_plugin_string (self, domain, id, key, val);
#line 1583 "ConfigurationInterfaces.c"
}


void configuration_engine_unset_plugin_key (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key) {
#line 308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->unset_plugin_key (self, domain, id, key);
#line 1592 "ConfigurationInterfaces.c"
}


FuzzyPropertyState configuration_engine_is_plugin_enabled (ConfigurationEngine* self, const gchar* id) {
#line 310 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0);
#line 310 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->is_plugin_enabled (self, id);
#line 1601 "ConfigurationInterfaces.c"
}


void configuration_engine_set_plugin_enabled (ConfigurationEngine* self, const gchar* id, gboolean enabled) {
#line 311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_plugin_enabled (self, id, enabled);
#line 1610 "ConfigurationInterfaces.c"
}


static void configuration_engine_base_init (ConfigurationEngineIface * iface) {
#line 283 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	static gboolean initialized = FALSE;
#line 283 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (!initialized) {
#line 283 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		initialized = TRUE;
#line 283 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_signal_new ("property_changed", TYPE_CONFIGURATION_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, TYPE_CONFIGURABLE_PROPERTY);
#line 1623 "ConfigurationInterfaces.c"
	}
}


GType configuration_engine_get_type (void) {
	static volatile gsize configuration_engine_type_id__volatile = 0;
	if (g_once_init_enter (&configuration_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ConfigurationEngineIface), (GBaseInitFunc) configuration_engine_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType configuration_engine_type_id;
		configuration_engine_type_id = g_type_register_static (G_TYPE_INTERFACE, "ConfigurationEngine", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (configuration_engine_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&configuration_engine_type_id__volatile, configuration_engine_type_id);
	}
	return configuration_engine_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 325 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return self ? g_object_ref (self) : NULL;
#line 1644 "ConfigurationInterfaces.c"
}


static void _configuration_facade_on_property_changed_configuration_engine_property_changed (ConfigurationEngine* _sender, ConfigurableProperty p, gpointer self) {
#line 327 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_facade_on_property_changed ((ConfigurationFacade*) self, p);
#line 1651 "ConfigurationInterfaces.c"
}


ConfigurationFacade* configuration_facade_construct (GType object_type, ConfigurationEngine* engine) {
	ConfigurationFacade * self = NULL;
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	ConfigurationEngine* _tmp2_ = NULL;
#line 324 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (engine), NULL);
#line 324 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	self = (ConfigurationFacade*) g_object_new (object_type, NULL);
#line 325 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = engine;
#line 325 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 325 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (self->priv->engine);
#line 325 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	self->priv->engine = _tmp1_;
#line 327 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = engine;
#line 327 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_signal_connect_object (_tmp2_, "property-changed", (GCallback) _configuration_facade_on_property_changed_configuration_engine_property_changed, self, 0);
#line 324 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return self;
#line 1678 "ConfigurationInterfaces.c"
}


static void configuration_facade_on_property_changed (ConfigurationFacade* self, ConfigurableProperty p) {
	ConfigurableProperty _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	ConfigurableProperty _tmp3_ = 0;
#line 330 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 331 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = p;
#line 331 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = configurable_property_to_string (_tmp0_);
#line 331 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = _tmp1_;
#line 331 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_debug ("ConfigurationInterfaces.vala:331: ConfigurationFacade: engine reports " \
"property '%s' changed.", _tmp2_);
#line 331 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_free0 (_tmp2_);
#line 333 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = p;
#line 333 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	switch (_tmp3_) {
#line 333 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY:
#line 1705 "ConfigurationInterfaces.c"
		{
#line 335 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit_by_name (self, "auto-import-from-library-changed");
#line 336 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 1711 "ConfigurationInterfaces.c"
		}
#line 333 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_BG_COLOR_NAME:
#line 1715 "ConfigurationInterfaces.c"
		{
#line 339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit_by_name (self, "bg-color-name-changed");
#line 340 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 1721 "ConfigurationInterfaces.c"
		}
#line 333 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS:
#line 1725 "ConfigurationInterfaces.c"
		{
#line 343 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit_by_name (self, "commit-metadata-to-masters-changed");
#line 344 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 1731 "ConfigurationInterfaces.c"
		}
#line 333 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING:
#line 1735 "ConfigurationInterfaces.c"
		{
#line 347 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit_by_name (self, "events-sort-ascending-changed");
#line 348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 1741 "ConfigurationInterfaces.c"
		}
#line 333 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP:
#line 333 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP:
#line 1747 "ConfigurationInterfaces.c"
		{
#line 352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit_by_name (self, "external-app-changed");
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 1753 "ConfigurationInterfaces.c"
		}
#line 333 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_IMPORT_DIR:
#line 1757 "ConfigurationInterfaces.c"
		{
#line 356 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit_by_name (self, "import-directory-changed");
#line 357 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 1763 "ConfigurationInterfaces.c"
		}
		default:
#line 333 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		break;
#line 1768 "ConfigurationInterfaces.c"
	}
}


ConfigurationEngine* configuration_facade_get_engine (ConfigurationFacade* self) {
	ConfigurationEngine* result = NULL;
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
#line 361 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = self->priv->engine;
#line 362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp1_;
#line 362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 1787 "ConfigurationInterfaces.c"
}


void configuration_facade_on_configuration_error (ConfigurationFacade* self, GError* err) {
	GError* _tmp0_ = NULL;
#line 365 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 366 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = err;
#line 366 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (g_error_matches (_tmp0_, CONFIGURATION_ERROR, CONFIGURATION_ERROR_PROPERTY_HAS_NO_VALUE)) {
#line 1799 "ConfigurationInterfaces.c"
		ConfigurationEngine* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 367 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = self->priv->engine;
#line 367 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = configuration_engine_get_name (_tmp1_);
#line 367 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = _tmp2_;
#line 367 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = err;
#line 367 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp4_->message;
#line 367 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_message ("ConfigurationInterfaces.vala:367: configuration engine '%s' reports PR" \
"OPERTY_HAS_NO_VALUE error: %s", _tmp3_, _tmp5_);
#line 367 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp3_);
#line 1819 "ConfigurationInterfaces.c"
	} else {
		GError* _tmp6_ = NULL;
#line 370 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 370 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (g_error_matches (_tmp6_, CONFIGURATION_ERROR, CONFIGURATION_ERROR_ENGINE_ERROR)) {
#line 1826 "ConfigurationInterfaces.c"
			ConfigurationEngine* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			GError* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
#line 371 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp7_ = self->priv->engine;
#line 371 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp8_ = configuration_engine_get_name (_tmp7_);
#line 371 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp9_ = _tmp8_;
#line 371 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp10_ = err;
#line 371 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp11_ = _tmp10_->message;
#line 371 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("ConfigurationInterfaces.vala:371: configuration engine '%s' reports EN" \
"GINE_ERROR: %s", _tmp9_, _tmp11_);
#line 371 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_g_free0 (_tmp9_);
#line 1846 "ConfigurationInterfaces.c"
		} else {
			ConfigurationEngine* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			GError* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
#line 374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp12_ = self->priv->engine;
#line 374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp13_ = configuration_engine_get_name (_tmp12_);
#line 374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp14_ = _tmp13_;
#line 374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp15_ = err;
#line 374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp16_ = _tmp15_->message;
#line 374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("ConfigurationInterfaces.vala:374: configuration engine '%s' reports un" \
"known error: %s", _tmp14_, _tmp16_);
#line 374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_g_free0 (_tmp14_);
#line 1867 "ConfigurationInterfaces.c"
		}
	}
}


static gboolean configuration_facade_real_get_auto_import_from_library (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY, &_inner_error_);
#line 384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 1898 "ConfigurationInterfaces.c"
				goto __catch79_configuration_error;
			}
#line 384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 1907 "ConfigurationInterfaces.c"
		}
#line 384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 1913 "ConfigurationInterfaces.c"
	}
	goto __finally79;
	__catch79_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 383 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 383 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 386 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 386 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 388 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 388 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 388 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 1934 "ConfigurationInterfaces.c"
	}
	__finally79:
#line 383 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 383 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 383 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 1943 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_auto_import_from_library (ConfigurationFacade* self) {
#line 382 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 382 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_auto_import_from_library (self);
#line 1952 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_auto_import_from_library (ConfigurationFacade* self, gboolean auto_import) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 394 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 394 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 394 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = auto_import;
#line 394 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY, _tmp2_, &_inner_error_);
#line 394 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 394 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 394 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 1976 "ConfigurationInterfaces.c"
				goto __catch80_configuration_error;
			}
#line 394 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 394 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 394 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 1985 "ConfigurationInterfaces.c"
		}
	}
	goto __finally80;
	__catch80_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 398 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 398 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2005 "ConfigurationInterfaces.c"
	}
	__finally80:
#line 393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2016 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_auto_import_from_library (ConfigurationFacade* self, gboolean auto_import) {
#line 392 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 392 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_auto_import_from_library (self, auto_import);
#line 2026 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_bg_color_name (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_BG_COLOR_NAME, &_inner_error_);
#line 407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2056 "ConfigurationInterfaces.c"
				goto __catch81_configuration_error;
			}
#line 407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 2065 "ConfigurationInterfaces.c"
		}
#line 407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2077 "ConfigurationInterfaces.c"
	}
	goto __finally81;
	__catch81_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 406 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 406 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 409 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 409 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2101 "ConfigurationInterfaces.c"
	}
	__finally81:
#line 406 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 406 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 406 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 2110 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_bg_color_name (ConfigurationFacade* self) {
#line 405 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 405 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_bg_color_name (self);
#line 2119 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_bg_color_name (ConfigurationFacade* self, const gchar* color_name) {
	GError * _inner_error_ = NULL;
#line 415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (color_name != NULL);
#line 2127 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 417 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 417 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 417 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = color_name;
#line 417 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_BG_COLOR_NAME, _tmp2_, &_inner_error_);
#line 417 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 417 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 417 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2146 "ConfigurationInterfaces.c"
				goto __catch82_configuration_error;
			}
#line 417 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 417 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 417 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2155 "ConfigurationInterfaces.c"
		}
	}
	goto __finally82;
	__catch82_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 416 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 416 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 420 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 420 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2175 "ConfigurationInterfaces.c"
	}
	__finally82:
#line 416 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 416 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 416 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 416 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2186 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_bg_color_name (ConfigurationFacade* self, const gchar* color_name) {
#line 415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_bg_color_name (self, color_name);
#line 2196 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_commit_metadata_to_masters (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS, &_inner_error_);
#line 429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2225 "ConfigurationInterfaces.c"
				goto __catch83_configuration_error;
			}
#line 429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 2234 "ConfigurationInterfaces.c"
		}
#line 429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2240 "ConfigurationInterfaces.c"
	}
	goto __finally83;
	__catch83_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 428 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 428 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 431 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 431 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2261 "ConfigurationInterfaces.c"
	}
	__finally83:
#line 428 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 428 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 428 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 2270 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_commit_metadata_to_masters (ConfigurationFacade* self) {
#line 427 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 427 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_commit_metadata_to_masters (self);
#line 2279 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_commit_metadata_to_masters (ConfigurationFacade* self, gboolean commit_metadata) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 439 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 439 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 439 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = commit_metadata;
#line 439 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS, _tmp2_, &_inner_error_);
#line 439 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 439 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 439 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2303 "ConfigurationInterfaces.c"
				goto __catch84_configuration_error;
			}
#line 439 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 439 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 439 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2312 "ConfigurationInterfaces.c"
		}
	}
	goto __finally84;
	__catch84_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 442 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 442 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2332 "ConfigurationInterfaces.c"
	}
	__finally84:
#line 438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2343 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_commit_metadata_to_masters (ConfigurationFacade* self, gboolean commit_metadata) {
#line 437 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 437 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_commit_metadata_to_masters (self, commit_metadata);
#line 2353 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_desktop_background (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE, &_inner_error_);
#line 452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2383 "ConfigurationInterfaces.c"
				goto __catch85_configuration_error;
			}
#line 452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 2392 "ConfigurationInterfaces.c"
		}
#line 452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 452 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2404 "ConfigurationInterfaces.c"
	}
	goto __finally85;
	__catch85_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 454 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 454 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2428 "ConfigurationInterfaces.c"
	}
	__finally85:
#line 451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 2437 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_desktop_background (ConfigurationFacade* self) {
#line 450 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 450 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_desktop_background (self);
#line 2446 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_desktop_background (ConfigurationFacade* self, const gchar* filename) {
	GError * _inner_error_ = NULL;
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (filename != NULL);
#line 2454 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		ConfigurationEngine* _tmp3_ = NULL;
		ConfigurationEngine* _tmp4_ = NULL;
#line 462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = filename;
#line 462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE, _tmp2_, &_inner_error_);
#line 462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2475 "ConfigurationInterfaces.c"
				goto __catch86_configuration_error;
			}
#line 462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2484 "ConfigurationInterfaces.c"
		}
#line 464 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 464 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 464 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp4_, CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE, "zoom", &_inner_error_);
#line 464 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 464 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 464 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2498 "ConfigurationInterfaces.c"
				goto __catch86_configuration_error;
			}
#line 464 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 464 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 464 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2507 "ConfigurationInterfaces.c"
		}
	}
	goto __finally86;
	__catch86_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 461 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 461 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 467 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 467 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 461 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 2525 "ConfigurationInterfaces.c"
	}
	__finally86:
#line 461 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 461 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 461 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 461 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2536 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_desktop_background (ConfigurationFacade* self, const gchar* filename) {
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_desktop_background (self, filename);
#line 2546 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_screensaver (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 476 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 476 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 476 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_SCREENSAVER_FILE, &_inner_error_);
#line 476 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 476 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 476 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 476 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 476 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2576 "ConfigurationInterfaces.c"
				goto __catch87_configuration_error;
			}
#line 476 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 476 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 476 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 2585 "ConfigurationInterfaces.c"
		}
#line 476 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 476 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 476 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 476 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 476 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2597 "ConfigurationInterfaces.c"
	}
	goto __finally87;
	__catch87_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 475 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 475 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2621 "ConfigurationInterfaces.c"
	}
	__finally87:
#line 475 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 475 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 475 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 2630 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_screensaver (ConfigurationFacade* self) {
#line 474 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 474 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_screensaver (self);
#line 2639 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_screensaver (ConfigurationFacade* self, const gchar* filename) {
	GError * _inner_error_ = NULL;
#line 484 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (filename != NULL);
#line 2647 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		ConfigurationEngine* _tmp3_ = NULL;
		ConfigurationEngine* _tmp4_ = NULL;
#line 486 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 486 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 486 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = filename;
#line 486 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_SCREENSAVER_FILE, _tmp2_, &_inner_error_);
#line 486 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 486 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 486 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2668 "ConfigurationInterfaces.c"
				goto __catch88_configuration_error;
			}
#line 486 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 486 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 486 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2677 "ConfigurationInterfaces.c"
		}
#line 488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp4_, CONFIGURABLE_PROPERTY_SCREENSAVER_MODE, "zoom", &_inner_error_);
#line 488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2691 "ConfigurationInterfaces.c"
				goto __catch88_configuration_error;
			}
#line 488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2700 "ConfigurationInterfaces.c"
		}
	}
	goto __finally88;
	__catch88_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 485 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 485 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 491 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 491 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 485 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 2718 "ConfigurationInterfaces.c"
	}
	__finally88:
#line 485 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 485 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 485 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 485 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2729 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_screensaver (ConfigurationFacade* self, const gchar* filename) {
#line 484 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 484 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_screensaver (self, filename);
#line 2739 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_directory_pattern (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* s = NULL;
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = configuration_engine_get_string_property (_tmp1_, CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN, &_inner_error_);
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = _tmp2_;
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		s = _tmp3_;
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2770 "ConfigurationInterfaces.c"
				goto __catch89_configuration_error;
			}
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 2779 "ConfigurationInterfaces.c"
		}
#line 501 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (g_strcmp0 (s, "") == 0) {
#line 501 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp4_ = NULL;
#line 2785 "ConfigurationInterfaces.c"
		} else {
#line 501 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp4_ = s;
#line 2789 "ConfigurationInterfaces.c"
		}
#line 501 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 501 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 501 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (s);
#line 501 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2799 "ConfigurationInterfaces.c"
	}
	goto __finally89;
	__catch89_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 499 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 499 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 503 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 503 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2823 "ConfigurationInterfaces.c"
	}
	__finally89:
#line 499 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 499 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 499 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 2832 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_directory_pattern (ConfigurationFacade* self) {
#line 498 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 498 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_directory_pattern (self);
#line 2841 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_directory_pattern (ConfigurationFacade* self, const gchar* s) {
	GError * _inner_error_ = NULL;
	{
		const gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 511 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = s;
#line 511 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (_tmp0_ == NULL) {
#line 512 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			s = "";
#line 2858 "ConfigurationInterfaces.c"
		}
#line 514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = s;
#line 514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp2_, CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN, _tmp3_, &_inner_error_);
#line 514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2874 "ConfigurationInterfaces.c"
				goto __catch90_configuration_error;
			}
#line 514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2883 "ConfigurationInterfaces.c"
		}
	}
	goto __finally90;
	__catch90_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp4_ = NULL;
#line 510 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 510 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 516 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = err;
#line 516 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp4_);
#line 510 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 2901 "ConfigurationInterfaces.c"
	}
	__finally90:
#line 510 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 510 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 510 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 510 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2912 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_directory_pattern (ConfigurationFacade* self, const gchar* s) {
#line 509 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 509 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_directory_pattern (self, s);
#line 2922 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_directory_pattern_custom (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 525 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 525 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 525 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM, &_inner_error_);
#line 525 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 525 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 525 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 525 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 525 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2952 "ConfigurationInterfaces.c"
				goto __catch91_configuration_error;
			}
#line 525 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 525 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 525 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 2961 "ConfigurationInterfaces.c"
		}
#line 525 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 525 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 525 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 525 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 525 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2973 "ConfigurationInterfaces.c"
	}
	goto __finally91;
	__catch91_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 524 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 524 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 527 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 527 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2997 "ConfigurationInterfaces.c"
	}
	__finally91:
#line 524 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 524 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 524 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 3006 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_directory_pattern_custom (ConfigurationFacade* self) {
#line 523 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 523 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_directory_pattern_custom (self);
#line 3015 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_directory_pattern_custom (ConfigurationFacade* self, const gchar* s) {
	GError * _inner_error_ = NULL;
#line 533 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (s != NULL);
#line 3023 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 535 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 535 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 535 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = s;
#line 535 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM, _tmp2_, &_inner_error_);
#line 535 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 535 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 535 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3042 "ConfigurationInterfaces.c"
				goto __catch92_configuration_error;
			}
#line 535 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 535 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 535 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3051 "ConfigurationInterfaces.c"
		}
	}
	goto __finally92;
	__catch92_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 534 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 534 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 537 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 537 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 534 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3069 "ConfigurationInterfaces.c"
	}
	__finally92:
#line 534 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 534 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 534 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 534 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 3080 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_directory_pattern_custom (ConfigurationFacade* self, const gchar* s) {
#line 533 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 533 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_directory_pattern_custom (self, s);
#line 3090 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_get_direct_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions) {
	gboolean _vala_maximize = FALSE;
	Dimensions _vala_dimensions = {0};
	GError * _inner_error_ = NULL;
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_maximize = FALSE;
#line 546 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	dimensions_init (&_vala_dimensions, 1024, 768);
#line 3102 "ConfigurationInterfaces.c"
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gint w = 0;
		ConfigurationEngine* _tmp5_ = NULL;
		ConfigurationEngine* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint h = 0;
		ConfigurationEngine* _tmp9_ = NULL;
		ConfigurationEngine* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
#line 548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE, &_inner_error_);
#line 548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3137 "ConfigurationInterfaces.c"
				goto __catch93_configuration_error;
			}
#line 548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3146 "ConfigurationInterfaces.c"
		}
#line 548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_maximize = _tmp0_;
#line 549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = configuration_facade_get_engine (self);
#line 549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = _tmp5_;
#line 549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = configuration_engine_get_int_property (_tmp6_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH, &_inner_error_);
#line 549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp7_;
#line 549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp6_);
#line 549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		w = _tmp8_;
#line 549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3166 "ConfigurationInterfaces.c"
				goto __catch93_configuration_error;
			}
#line 549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3175 "ConfigurationInterfaces.c"
		}
#line 550 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = configuration_facade_get_engine (self);
#line 550 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = _tmp9_;
#line 550 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp11_ = configuration_engine_get_int_property (_tmp10_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT, &_inner_error_);
#line 550 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp12_ = _tmp11_;
#line 550 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp10_);
#line 550 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		h = _tmp12_;
#line 550 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 550 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3193 "ConfigurationInterfaces.c"
				goto __catch93_configuration_error;
			}
#line 550 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 550 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 550 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3202 "ConfigurationInterfaces.c"
		}
#line 551 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp13_ = w;
#line 551 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp14_ = h;
#line 551 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		dimensions_init (&_vala_dimensions, _tmp13_, _tmp14_);
#line 3210 "ConfigurationInterfaces.c"
	}
	goto __finally93;
	__catch93_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp15_ = NULL;
#line 547 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 547 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 553 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp15_ = err;
#line 553 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp15_);
#line 547 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3227 "ConfigurationInterfaces.c"
	}
	__finally93:
#line 547 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 547 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 547 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 547 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 3238 "ConfigurationInterfaces.c"
	}
#line 544 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (maximize) {
#line 544 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*maximize = _vala_maximize;
#line 3244 "ConfigurationInterfaces.c"
	}
#line 544 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (dimensions) {
#line 544 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*dimensions = _vala_dimensions;
#line 3250 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_get_direct_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions) {
#line 544 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 544 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->get_direct_window_state (self, maximize, dimensions);
#line 3260 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_direct_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions) {
	GError * _inner_error_ = NULL;
#line 557 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (dimensions != NULL);
#line 3268 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		ConfigurationEngine* _tmp3_ = NULL;
		ConfigurationEngine* _tmp4_ = NULL;
		Dimensions _tmp5_ = {0};
		gint _tmp6_ = 0;
		ConfigurationEngine* _tmp7_ = NULL;
		ConfigurationEngine* _tmp8_ = NULL;
		Dimensions _tmp9_ = {0};
		gint _tmp10_ = 0;
#line 559 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 559 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 559 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = maximize;
#line 559 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE, _tmp2_, &_inner_error_);
#line 559 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 559 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 559 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3295 "ConfigurationInterfaces.c"
				goto __catch94_configuration_error;
			}
#line 559 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 559 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 559 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3304 "ConfigurationInterfaces.c"
		}
#line 560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = *dimensions;
#line 560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = _tmp5_.width;
#line 560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp4_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH, _tmp6_, &_inner_error_);
#line 560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3322 "ConfigurationInterfaces.c"
				goto __catch94_configuration_error;
			}
#line 560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3331 "ConfigurationInterfaces.c"
		}
#line 562 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = configuration_facade_get_engine (self);
#line 562 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp7_;
#line 562 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = *dimensions;
#line 562 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = _tmp9_.height;
#line 562 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp8_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT, _tmp10_, &_inner_error_);
#line 562 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp8_);
#line 562 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 562 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3349 "ConfigurationInterfaces.c"
				goto __catch94_configuration_error;
			}
#line 562 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 562 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 562 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3358 "ConfigurationInterfaces.c"
		}
	}
	goto __finally94;
	__catch94_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp11_ = NULL;
#line 558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 565 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp11_ = err;
#line 565 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp11_);
#line 558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3376 "ConfigurationInterfaces.c"
	}
	__finally94:
#line 558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 3387 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_direct_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions) {
#line 557 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 557 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_direct_window_state (self, maximize, dimensions);
#line 3397 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_basic_properties (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 574 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 574 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 574 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES, &_inner_error_);
#line 574 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 574 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 574 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 574 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 574 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3426 "ConfigurationInterfaces.c"
				goto __catch95_configuration_error;
			}
#line 574 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 574 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 574 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 3435 "ConfigurationInterfaces.c"
		}
#line 574 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 574 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3441 "ConfigurationInterfaces.c"
	}
	goto __finally95;
	__catch95_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 573 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 573 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 576 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 576 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3462 "ConfigurationInterfaces.c"
	}
	__finally95:
#line 573 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 573 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 573 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 3471 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_basic_properties (ConfigurationFacade* self) {
#line 572 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 572 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_basic_properties (self);
#line 3480 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_basic_properties (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 584 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 584 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 584 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 584 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES, _tmp2_, &_inner_error_);
#line 584 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 584 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 584 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3504 "ConfigurationInterfaces.c"
				goto __catch96_configuration_error;
			}
#line 584 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 584 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 584 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3513 "ConfigurationInterfaces.c"
		}
	}
	goto __finally96;
	__catch96_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 583 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 583 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 586 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 586 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 583 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3531 "ConfigurationInterfaces.c"
	}
	__finally96:
#line 583 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 583 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 583 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 583 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 3542 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_basic_properties (ConfigurationFacade* self, gboolean display) {
#line 582 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 582 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_basic_properties (self, display);
#line 3552 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_extended_properties (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 595 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 595 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 595 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES, &_inner_error_);
#line 595 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 595 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 595 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 595 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 595 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3581 "ConfigurationInterfaces.c"
				goto __catch97_configuration_error;
			}
#line 595 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 595 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 595 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 3590 "ConfigurationInterfaces.c"
		}
#line 595 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 595 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3596 "ConfigurationInterfaces.c"
	}
	goto __finally97;
	__catch97_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 597 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 597 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3617 "ConfigurationInterfaces.c"
	}
	__finally97:
#line 594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 3626 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_extended_properties (ConfigurationFacade* self) {
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_extended_properties (self);
#line 3635 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_extended_properties (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES, _tmp2_, &_inner_error_);
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3659 "ConfigurationInterfaces.c"
				goto __catch98_configuration_error;
			}
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3668 "ConfigurationInterfaces.c"
		}
	}
	goto __finally98;
	__catch98_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 608 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 608 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3686 "ConfigurationInterfaces.c"
	}
	__finally98:
#line 604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 3697 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_extended_properties (ConfigurationFacade* self, gboolean display) {
#line 603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_extended_properties (self, display);
#line 3707 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_sidebar (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR, &_inner_error_);
#line 617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3736 "ConfigurationInterfaces.c"
				goto __catch99_configuration_error;
			}
#line 617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 3745 "ConfigurationInterfaces.c"
		}
#line 617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3751 "ConfigurationInterfaces.c"
	}
	goto __finally99;
	__catch99_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 616 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 616 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 619 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 619 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3772 "ConfigurationInterfaces.c"
	}
	__finally99:
#line 616 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 616 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 616 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 3781 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_sidebar (ConfigurationFacade* self) {
#line 615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_sidebar (self);
#line 3790 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_sidebar (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR, _tmp2_, &_inner_error_);
#line 627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3814 "ConfigurationInterfaces.c"
				goto __catch100_configuration_error;
			}
#line 627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3823 "ConfigurationInterfaces.c"
		}
	}
	goto __finally100;
	__catch100_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 629 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 629 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3841 "ConfigurationInterfaces.c"
	}
	__finally100:
#line 626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 3852 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_sidebar (ConfigurationFacade* self, gboolean display) {
#line 625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_sidebar (self, display);
#line 3862 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_search_bar (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR, &_inner_error_);
#line 638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3891 "ConfigurationInterfaces.c"
				goto __catch101_configuration_error;
			}
#line 638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 3900 "ConfigurationInterfaces.c"
		}
#line 638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3906 "ConfigurationInterfaces.c"
	}
	goto __finally101;
	__catch101_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 637 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 637 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 640 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 640 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3927 "ConfigurationInterfaces.c"
	}
	__finally101:
#line 637 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 637 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 637 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 3936 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_search_bar (ConfigurationFacade* self) {
#line 636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_search_bar (self);
#line 3945 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_search_bar (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR, _tmp2_, &_inner_error_);
#line 648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3969 "ConfigurationInterfaces.c"
				goto __catch102_configuration_error;
			}
#line 648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3978 "ConfigurationInterfaces.c"
		}
	}
	goto __finally102;
	__catch102_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 650 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 650 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3996 "ConfigurationInterfaces.c"
	}
	__finally102:
#line 647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4007 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_search_bar (ConfigurationFacade* self, gboolean display) {
#line 646 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 646 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_search_bar (self, display);
#line 4017 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_photo_ratings (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS, &_inner_error_);
#line 659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4046 "ConfigurationInterfaces.c"
				goto __catch103_configuration_error;
			}
#line 659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 4055 "ConfigurationInterfaces.c"
		}
#line 659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 659 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4061 "ConfigurationInterfaces.c"
	}
	goto __finally103;
	__catch103_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 661 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 661 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 663 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 663 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 663 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4082 "ConfigurationInterfaces.c"
	}
	__finally103:
#line 658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 4091 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_photo_ratings (ConfigurationFacade* self) {
#line 657 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 657 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_photo_ratings (self);
#line 4100 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_photo_ratings (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 669 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 669 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 669 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 669 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS, _tmp2_, &_inner_error_);
#line 669 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 669 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 669 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4124 "ConfigurationInterfaces.c"
				goto __catch104_configuration_error;
			}
#line 669 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 669 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 669 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4133 "ConfigurationInterfaces.c"
		}
	}
	goto __finally104;
	__catch104_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 668 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 668 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 671 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 671 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 668 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4151 "ConfigurationInterfaces.c"
	}
	__finally104:
#line 668 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 668 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 668 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 668 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4162 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_photo_ratings (ConfigurationFacade* self, gboolean display) {
#line 667 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 667 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_photo_ratings (self, display);
#line 4172 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_photo_tags (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 680 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 680 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 680 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS, &_inner_error_);
#line 680 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 680 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 680 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 680 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 680 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4201 "ConfigurationInterfaces.c"
				goto __catch105_configuration_error;
			}
#line 680 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 680 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 680 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 4210 "ConfigurationInterfaces.c"
		}
#line 680 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 680 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4216 "ConfigurationInterfaces.c"
	}
	goto __finally105;
	__catch105_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 679 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 679 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 682 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 682 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 684 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 684 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 684 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4237 "ConfigurationInterfaces.c"
	}
	__finally105:
#line 679 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 679 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 679 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 4246 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_photo_tags (ConfigurationFacade* self) {
#line 678 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 678 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_photo_tags (self);
#line 4255 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_photo_tags (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 690 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 690 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 690 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 690 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS, _tmp2_, &_inner_error_);
#line 690 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 690 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 690 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4279 "ConfigurationInterfaces.c"
				goto __catch106_configuration_error;
			}
#line 690 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 690 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 690 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4288 "ConfigurationInterfaces.c"
		}
	}
	goto __finally106;
	__catch106_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 689 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 689 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 692 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 692 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 689 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4306 "ConfigurationInterfaces.c"
	}
	__finally106:
#line 689 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 689 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 689 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 689 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4317 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_photo_tags (ConfigurationFacade* self, gboolean display) {
#line 688 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 688 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_photo_tags (self, display);
#line 4327 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_photo_titles (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES, &_inner_error_);
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4356 "ConfigurationInterfaces.c"
				goto __catch107_configuration_error;
			}
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 4365 "ConfigurationInterfaces.c"
		}
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4371 "ConfigurationInterfaces.c"
	}
	goto __finally107;
	__catch107_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 700 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 700 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 703 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 703 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 705 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 705 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 705 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4392 "ConfigurationInterfaces.c"
	}
	__finally107:
#line 700 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 700 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 700 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 4401 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_photo_titles (ConfigurationFacade* self) {
#line 699 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 699 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_photo_titles (self);
#line 4410 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_photo_titles (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES, _tmp2_, &_inner_error_);
#line 711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4434 "ConfigurationInterfaces.c"
				goto __catch108_configuration_error;
			}
#line 711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 711 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4443 "ConfigurationInterfaces.c"
		}
	}
	goto __finally108;
	__catch108_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 713 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 713 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4461 "ConfigurationInterfaces.c"
	}
	__finally108:
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4472 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_photo_titles (ConfigurationFacade* self, gboolean display) {
#line 709 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 709 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_photo_titles (self, display);
#line 4482 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_photo_comments (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS, &_inner_error_);
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4511 "ConfigurationInterfaces.c"
				goto __catch109_configuration_error;
			}
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 4520 "ConfigurationInterfaces.c"
		}
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4526 "ConfigurationInterfaces.c"
	}
	goto __finally109;
	__catch109_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 724 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 724 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 726 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 726 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 726 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4547 "ConfigurationInterfaces.c"
	}
	__finally109:
#line 721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 4556 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_photo_comments (ConfigurationFacade* self) {
#line 720 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 720 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_photo_comments (self);
#line 4565 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_photo_comments (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS, _tmp2_, &_inner_error_);
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4589 "ConfigurationInterfaces.c"
				goto __catch110_configuration_error;
			}
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4598 "ConfigurationInterfaces.c"
		}
	}
	goto __finally110;
	__catch110_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 731 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 731 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 734 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 734 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 731 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4616 "ConfigurationInterfaces.c"
	}
	__finally110:
#line 731 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 731 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 731 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 731 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4627 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_photo_comments (ConfigurationFacade* self, gboolean display) {
#line 730 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 730 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_photo_comments (self, display);
#line 4637 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_event_comments (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 743 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 743 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 743 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS, &_inner_error_);
#line 743 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 743 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 743 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 743 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 743 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4666 "ConfigurationInterfaces.c"
				goto __catch111_configuration_error;
			}
#line 743 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 743 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 743 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 4675 "ConfigurationInterfaces.c"
		}
#line 743 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 743 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4681 "ConfigurationInterfaces.c"
	}
	goto __finally111;
	__catch111_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 742 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 742 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 745 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 745 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 747 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 747 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 747 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4702 "ConfigurationInterfaces.c"
	}
	__finally111:
#line 742 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 742 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 742 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 4711 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_event_comments (ConfigurationFacade* self) {
#line 741 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 741 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_event_comments (self);
#line 4720 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_event_comments (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS, _tmp2_, &_inner_error_);
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4744 "ConfigurationInterfaces.c"
				goto __catch112_configuration_error;
			}
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4753 "ConfigurationInterfaces.c"
		}
	}
	goto __finally112;
	__catch112_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 752 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 752 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 755 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 755 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 752 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4771 "ConfigurationInterfaces.c"
	}
	__finally112:
#line 752 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 752 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 752 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 752 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4782 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_event_comments (ConfigurationFacade* self, gboolean display) {
#line 751 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 751 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_event_comments (self, display);
#line 4792 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_get_event_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by) {
	gboolean _vala_sort_order = FALSE;
	gint _vala_sort_by = 0;
	GError * _inner_error_ = NULL;
#line 763 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_sort_order = FALSE;
#line 764 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_sort_by = 2;
#line 4804 "ConfigurationInterfaces.c"
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gint _tmp5_ = 0;
		ConfigurationEngine* _tmp6_ = NULL;
		ConfigurationEngine* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
#line 766 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 766 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 766 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING, &_inner_error_);
#line 766 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 766 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 766 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 766 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 766 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4832 "ConfigurationInterfaces.c"
				goto __catch113_configuration_error;
			}
#line 766 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 766 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 766 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4841 "ConfigurationInterfaces.c"
		}
#line 766 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_sort_order = _tmp0_;
#line 768 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = configuration_facade_get_engine (self);
#line 768 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = _tmp6_;
#line 768 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = configuration_engine_get_int_property (_tmp7_, CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY, &_inner_error_);
#line 768 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = _tmp8_;
#line 768 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp7_);
#line 768 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp9_;
#line 768 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 768 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4861 "ConfigurationInterfaces.c"
				goto __catch113_configuration_error;
			}
#line 768 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 768 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 768 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4870 "ConfigurationInterfaces.c"
		}
#line 768 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_sort_by = _tmp5_;
#line 4874 "ConfigurationInterfaces.c"
	}
	goto __finally113;
	__catch113_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp10_ = NULL;
#line 765 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 765 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 770 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = err;
#line 770 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp10_);
#line 765 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4891 "ConfigurationInterfaces.c"
	}
	__finally113:
#line 765 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 765 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 765 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 765 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4902 "ConfigurationInterfaces.c"
	}
#line 762 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (sort_order) {
#line 762 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*sort_order = _vala_sort_order;
#line 4908 "ConfigurationInterfaces.c"
	}
#line 762 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (sort_by) {
#line 762 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*sort_by = _vala_sort_by;
#line 4914 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_get_event_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by) {
#line 762 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 762 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->get_event_photos_sort (self, sort_order, sort_by);
#line 4924 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_event_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		ConfigurationEngine* _tmp3_ = NULL;
		ConfigurationEngine* _tmp4_ = NULL;
		gint _tmp5_ = 0;
#line 776 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 776 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 776 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = sort_order;
#line 776 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING, _tmp2_, &_inner_error_);
#line 776 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 776 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 776 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4951 "ConfigurationInterfaces.c"
				goto __catch114_configuration_error;
			}
#line 776 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 776 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 776 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4960 "ConfigurationInterfaces.c"
		}
#line 778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = sort_by;
#line 778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp4_, CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY, _tmp5_, &_inner_error_);
#line 778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4976 "ConfigurationInterfaces.c"
				goto __catch114_configuration_error;
			}
#line 778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4985 "ConfigurationInterfaces.c"
		}
	}
	goto __finally114;
	__catch114_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
#line 775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 781 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 781 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 5003 "ConfigurationInterfaces.c"
	}
	__finally114:
#line 775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 775 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5014 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_event_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by) {
#line 774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_event_photos_sort (self, sort_order, sort_by);
#line 5024 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_events_sort_ascending (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING, &_inner_error_);
#line 790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5053 "ConfigurationInterfaces.c"
				goto __catch115_configuration_error;
			}
#line 790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 5062 "ConfigurationInterfaces.c"
		}
#line 790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5068 "ConfigurationInterfaces.c"
	}
	goto __finally115;
	__catch115_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 789 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 789 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 792 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 792 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5089 "ConfigurationInterfaces.c"
	}
	__finally115:
#line 789 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 789 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 789 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 5098 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_events_sort_ascending (ConfigurationFacade* self) {
#line 788 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 788 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_events_sort_ascending (self);
#line 5107 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_events_sort_ascending (ConfigurationFacade* self, gboolean sort) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = sort;
#line 800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING, _tmp2_, &_inner_error_);
#line 800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5131 "ConfigurationInterfaces.c"
				goto __catch116_configuration_error;
			}
#line 800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5140 "ConfigurationInterfaces.c"
		}
	}
	goto __finally116;
	__catch116_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 799 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 799 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 802 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 802 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 803 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 803 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5160 "ConfigurationInterfaces.c"
	}
	__finally116:
#line 799 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 799 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 799 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 799 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5171 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_events_sort_ascending (ConfigurationFacade* self, gboolean sort) {
#line 798 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 798 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_events_sort_ascending (self, sort);
#line 5181 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_external_photo_app (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 812 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 812 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 812 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP, &_inner_error_);
#line 812 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 812 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 812 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 812 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 812 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5211 "ConfigurationInterfaces.c"
				goto __catch117_configuration_error;
			}
#line 812 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 812 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 812 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 5220 "ConfigurationInterfaces.c"
		}
#line 812 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 812 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 812 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 812 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 812 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5232 "ConfigurationInterfaces.c"
	}
	goto __finally117;
	__catch117_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 811 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 811 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 814 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 814 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5256 "ConfigurationInterfaces.c"
	}
	__finally117:
#line 811 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 811 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 811 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 5265 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_external_photo_app (ConfigurationFacade* self) {
#line 810 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 810 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_external_photo_app (self);
#line 5274 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_external_photo_app (ConfigurationFacade* self, const gchar* external_photo_app) {
	GError * _inner_error_ = NULL;
#line 820 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (external_photo_app != NULL);
#line 5282 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 822 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 822 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 822 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = external_photo_app;
#line 822 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP, _tmp2_, &_inner_error_);
#line 822 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 822 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 822 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5301 "ConfigurationInterfaces.c"
				goto __catch118_configuration_error;
			}
#line 822 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 822 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 822 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5310 "ConfigurationInterfaces.c"
		}
	}
	goto __finally118;
	__catch118_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 825 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 825 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 826 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 826 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5330 "ConfigurationInterfaces.c"
	}
	__finally118:
#line 821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5341 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_external_photo_app (ConfigurationFacade* self, const gchar* external_photo_app) {
#line 820 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 820 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_external_photo_app (self, external_photo_app);
#line 5351 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_external_raw_app (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 835 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 835 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 835 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP, &_inner_error_);
#line 835 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 835 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 835 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 835 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 835 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5381 "ConfigurationInterfaces.c"
				goto __catch119_configuration_error;
			}
#line 835 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 835 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 835 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 5390 "ConfigurationInterfaces.c"
		}
#line 835 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 835 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 835 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 835 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 835 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5402 "ConfigurationInterfaces.c"
	}
	goto __finally119;
	__catch119_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 834 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 834 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 839 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 839 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 839 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 839 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5426 "ConfigurationInterfaces.c"
	}
	__finally119:
#line 834 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 834 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 834 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 5435 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_external_raw_app (ConfigurationFacade* self) {
#line 833 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 833 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_external_raw_app (self);
#line 5444 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_external_raw_app (ConfigurationFacade* self, const gchar* external_raw_app) {
	GError * _inner_error_ = NULL;
#line 843 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (external_raw_app != NULL);
#line 5452 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 845 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 845 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 845 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = external_raw_app;
#line 845 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP, _tmp2_, &_inner_error_);
#line 845 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 845 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 845 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5471 "ConfigurationInterfaces.c"
				goto __catch120_configuration_error;
			}
#line 845 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 845 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 845 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5480 "ConfigurationInterfaces.c"
		}
	}
	goto __finally120;
	__catch120_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 844 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 844 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 848 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 848 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 849 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 849 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5500 "ConfigurationInterfaces.c"
	}
	__finally120:
#line 844 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 844 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 844 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 844 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5511 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_external_raw_app (ConfigurationFacade* self, const gchar* external_raw_app) {
#line 843 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 843 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_external_raw_app (self, external_raw_app);
#line 5521 "ConfigurationInterfaces.c"
}


static RawDeveloper configuration_facade_real_get_default_raw_developer (ConfigurationFacade* self) {
	RawDeveloper result = 0;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		RawDeveloper _tmp5_ = 0;
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT, &_inner_error_);
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5551 "ConfigurationInterfaces.c"
				goto __catch121_configuration_error;
			}
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 5560 "ConfigurationInterfaces.c"
		}
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = raw_developer_from_string (_tmp0_);
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5570 "ConfigurationInterfaces.c"
	}
	goto __finally121;
	__catch121_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
#line 857 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 857 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 861 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 861 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 863 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = RAW_DEVELOPER_CAMERA;
#line 863 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 863 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5591 "ConfigurationInterfaces.c"
	}
	__finally121:
#line 857 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 857 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 857 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 5600 "ConfigurationInterfaces.c"
}


RawDeveloper configuration_facade_get_default_raw_developer (ConfigurationFacade* self) {
#line 856 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 856 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_default_raw_developer (self);
#line 5609 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_default_raw_developer (ConfigurationFacade* self, RawDeveloper d) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		RawDeveloper _tmp2_ = 0;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = d;
#line 869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = raw_developer_to_string (_tmp2_);
#line 869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT, _tmp4_, &_inner_error_);
#line 869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp4_);
#line 869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5641 "ConfigurationInterfaces.c"
				goto __catch122_configuration_error;
			}
#line 869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5650 "ConfigurationInterfaces.c"
		}
	}
	goto __finally122;
	__catch122_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 868 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 868 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 872 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 872 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 873 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 873 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5670 "ConfigurationInterfaces.c"
	}
	__finally122:
#line 868 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 868 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 868 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 868 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5681 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_default_raw_developer (ConfigurationFacade* self, RawDeveloper d) {
#line 867 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 867 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_default_raw_developer (self, d);
#line 5691 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_hide_photos_already_imported (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 882 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 882 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 882 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED, &_inner_error_);
#line 882 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 882 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 882 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 882 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 882 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5720 "ConfigurationInterfaces.c"
				goto __catch123_configuration_error;
			}
#line 882 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 882 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 882 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 5729 "ConfigurationInterfaces.c"
		}
#line 882 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 882 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5735 "ConfigurationInterfaces.c"
	}
	goto __finally123;
	__catch123_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 881 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 881 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 884 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 884 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 886 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 886 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 886 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5756 "ConfigurationInterfaces.c"
	}
	__finally123:
#line 881 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 881 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 881 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 5765 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_hide_photos_already_imported (ConfigurationFacade* self) {
#line 880 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 880 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_hide_photos_already_imported (self);
#line 5774 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_hide_photos_already_imported (ConfigurationFacade* self, gboolean hide_imported) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 892 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 892 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 892 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = hide_imported;
#line 892 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED, _tmp2_, &_inner_error_);
#line 892 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 892 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 892 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5798 "ConfigurationInterfaces.c"
				goto __catch124_configuration_error;
			}
#line 892 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 892 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 892 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5807 "ConfigurationInterfaces.c"
		}
	}
	goto __finally124;
	__catch124_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 891 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 891 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 894 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 894 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 891 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 5825 "ConfigurationInterfaces.c"
	}
	__finally124:
#line 891 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 891 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 891 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 891 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5836 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_hide_photos_already_imported (ConfigurationFacade* self, gboolean hide_imported) {
#line 890 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 890 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_hide_photos_already_imported (self, hide_imported);
#line 5846 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_import_dir (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 903 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 903 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 903 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_IMPORT_DIR, &_inner_error_);
#line 903 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 903 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 903 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 903 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 903 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5876 "ConfigurationInterfaces.c"
				goto __catch125_configuration_error;
			}
#line 903 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 903 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 903 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 5885 "ConfigurationInterfaces.c"
		}
#line 903 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 903 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 903 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 903 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 903 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5897 "ConfigurationInterfaces.c"
	}
	goto __finally125;
	__catch125_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 902 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 902 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 905 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 905 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 907 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 907 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 907 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 907 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5921 "ConfigurationInterfaces.c"
	}
	__finally125:
#line 902 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 902 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 902 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 5930 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_import_dir (ConfigurationFacade* self) {
#line 901 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 901 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_import_dir (self);
#line 5939 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_import_dir (ConfigurationFacade* self, const gchar* import_dir) {
	GError * _inner_error_ = NULL;
#line 911 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (import_dir != NULL);
#line 5947 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 913 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 913 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 913 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = import_dir;
#line 913 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_IMPORT_DIR, _tmp2_, &_inner_error_);
#line 913 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 913 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 913 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5966 "ConfigurationInterfaces.c"
				goto __catch126_configuration_error;
			}
#line 913 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 913 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 913 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5975 "ConfigurationInterfaces.c"
		}
	}
	goto __finally126;
	__catch126_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 912 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 912 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 915 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 915 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 912 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 5993 "ConfigurationInterfaces.c"
	}
	__finally126:
#line 912 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 912 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 912 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 912 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6004 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_import_dir (ConfigurationFacade* self, const gchar* import_dir) {
#line 911 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 911 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_import_dir (self, import_dir);
#line 6014 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_keep_relativity (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 924 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 924 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 924 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_KEEP_RELATIVITY, &_inner_error_);
#line 924 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 924 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 924 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 924 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 924 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6043 "ConfigurationInterfaces.c"
				goto __catch127_configuration_error;
			}
#line 924 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 924 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 924 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 6052 "ConfigurationInterfaces.c"
		}
#line 924 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 924 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6058 "ConfigurationInterfaces.c"
	}
	goto __finally127;
	__catch127_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 923 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 923 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 926 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 926 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 928 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 928 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 928 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6079 "ConfigurationInterfaces.c"
	}
	__finally127:
#line 923 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 923 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 923 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 6088 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_keep_relativity (ConfigurationFacade* self) {
#line 922 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 922 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_keep_relativity (self);
#line 6097 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_keep_relativity (ConfigurationFacade* self, gboolean keep_relativity) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 934 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 934 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 934 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = keep_relativity;
#line 934 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_KEEP_RELATIVITY, _tmp2_, &_inner_error_);
#line 934 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 934 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 934 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6121 "ConfigurationInterfaces.c"
				goto __catch128_configuration_error;
			}
#line 934 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 934 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 934 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6130 "ConfigurationInterfaces.c"
		}
	}
	goto __finally128;
	__catch128_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 933 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 933 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 936 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 936 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 933 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 6148 "ConfigurationInterfaces.c"
	}
	__finally128:
#line 933 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 933 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 933 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 933 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6159 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_keep_relativity (ConfigurationFacade* self, gboolean keep_relativity) {
#line 932 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 932 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_keep_relativity (self, keep_relativity);
#line 6169 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_pin_toolbar_state (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 945 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 945 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 945 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE, &_inner_error_);
#line 945 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 945 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 945 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 945 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 945 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6198 "ConfigurationInterfaces.c"
				goto __catch129_configuration_error;
			}
#line 945 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 945 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 945 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 6207 "ConfigurationInterfaces.c"
		}
#line 945 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 945 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6213 "ConfigurationInterfaces.c"
	}
	goto __finally129;
	__catch129_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 944 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 944 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 947 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 947 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 948 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 948 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 948 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6234 "ConfigurationInterfaces.c"
	}
	__finally129:
#line 944 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 944 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 944 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 6243 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_pin_toolbar_state (ConfigurationFacade* self) {
#line 943 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 943 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_pin_toolbar_state (self);
#line 6252 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_pin_toolbar_state (ConfigurationFacade* self, gboolean state) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 954 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 954 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 954 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = state;
#line 954 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE, _tmp2_, &_inner_error_);
#line 954 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 954 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 954 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6276 "ConfigurationInterfaces.c"
				goto __catch130_configuration_error;
			}
#line 954 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 954 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 954 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6285 "ConfigurationInterfaces.c"
		}
	}
	goto __finally130;
	__catch130_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 953 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 953 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 956 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 956 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 953 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 6303 "ConfigurationInterfaces.c"
	}
	__finally130:
#line 953 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 953 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 953 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 953 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6314 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_pin_toolbar_state (ConfigurationFacade* self, gboolean state) {
#line 952 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 952 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_pin_toolbar_state (self, state);
#line 6324 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_last_crop_height (ConfigurationFacade* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 965 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 965 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 965 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT, &_inner_error_);
#line 965 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 965 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 965 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 965 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 965 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6353 "ConfigurationInterfaces.c"
				goto __catch131_configuration_error;
			}
#line 965 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 965 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 965 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 6362 "ConfigurationInterfaces.c"
		}
#line 965 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 965 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6368 "ConfigurationInterfaces.c"
	}
	goto __finally131;
	__catch131_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 964 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 964 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 967 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 967 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 968 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 1;
#line 968 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 968 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6389 "ConfigurationInterfaces.c"
	}
	__finally131:
#line 964 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 964 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 964 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 6398 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_last_crop_height (ConfigurationFacade* self) {
#line 963 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 963 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_last_crop_height (self);
#line 6407 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_last_crop_height (ConfigurationFacade* self, gint choice) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 974 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 974 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 974 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = choice;
#line 974 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT, _tmp2_, &_inner_error_);
#line 974 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 974 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 974 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6431 "ConfigurationInterfaces.c"
				goto __catch132_configuration_error;
			}
#line 974 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 974 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 974 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6440 "ConfigurationInterfaces.c"
		}
	}
	goto __finally132;
	__catch132_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 973 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 973 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 976 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 976 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 973 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 6458 "ConfigurationInterfaces.c"
	}
	__finally132:
#line 973 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 973 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 973 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 973 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6469 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_last_crop_height (ConfigurationFacade* self, gint choice) {
#line 972 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 972 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_last_crop_height (self, choice);
#line 6479 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_last_crop_menu_choice (ConfigurationFacade* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 985 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 985 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 985 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE, &_inner_error_);
#line 985 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 985 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 985 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 985 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 985 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6508 "ConfigurationInterfaces.c"
				goto __catch133_configuration_error;
			}
#line 985 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 985 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 985 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 6517 "ConfigurationInterfaces.c"
		}
#line 985 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 985 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6523 "ConfigurationInterfaces.c"
	}
	goto __finally133;
	__catch133_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 984 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 984 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 987 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 987 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 992 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 992 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 992 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6544 "ConfigurationInterfaces.c"
	}
	__finally133:
#line 984 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 984 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 984 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 6553 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_last_crop_menu_choice (ConfigurationFacade* self) {
#line 983 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 983 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_last_crop_menu_choice (self);
#line 6562 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_last_crop_menu_choice (ConfigurationFacade* self, gint choice) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 998 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 998 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 998 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = choice;
#line 998 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE, _tmp2_, &_inner_error_);
#line 998 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 998 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 998 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6586 "ConfigurationInterfaces.c"
				goto __catch134_configuration_error;
			}
#line 998 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 998 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 998 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6595 "ConfigurationInterfaces.c"
		}
	}
	goto __finally134;
	__catch134_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 997 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 997 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1000 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1000 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 997 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 6613 "ConfigurationInterfaces.c"
	}
	__finally134:
#line 997 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 997 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 997 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 997 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6624 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_last_crop_menu_choice (ConfigurationFacade* self, gint choice) {
#line 996 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 996 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_last_crop_menu_choice (self, choice);
#line 6634 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_last_crop_width (ConfigurationFacade* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 1009 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1009 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1009 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH, &_inner_error_);
#line 1009 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1009 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1009 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1009 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1009 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6663 "ConfigurationInterfaces.c"
				goto __catch135_configuration_error;
			}
#line 1009 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1009 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1009 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 6672 "ConfigurationInterfaces.c"
		}
#line 1009 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1009 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6678 "ConfigurationInterfaces.c"
	}
	goto __finally135;
	__catch135_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1008 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1008 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1012 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 1;
#line 1012 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1012 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6699 "ConfigurationInterfaces.c"
	}
	__finally135:
#line 1008 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1008 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1008 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 6708 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_last_crop_width (ConfigurationFacade* self) {
#line 1007 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1007 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_last_crop_width (self);
#line 6717 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_last_crop_width (ConfigurationFacade* self, gint choice) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 1018 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1018 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1018 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = choice;
#line 1018 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH, _tmp2_, &_inner_error_);
#line 1018 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1018 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1018 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6741 "ConfigurationInterfaces.c"
				goto __catch136_configuration_error;
			}
#line 1018 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1018 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1018 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6750 "ConfigurationInterfaces.c"
		}
	}
	goto __finally136;
	__catch136_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1017 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1017 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1020 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1020 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1017 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 6768 "ConfigurationInterfaces.c"
	}
	__finally136:
#line 1017 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1017 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1017 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1017 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6779 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_last_crop_width (ConfigurationFacade* self, gint choice) {
#line 1016 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1016 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_last_crop_width (self, choice);
#line 6789 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_last_used_service (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 1029 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1029 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1029 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_USED_SERVICE, &_inner_error_);
#line 1029 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1029 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1029 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1029 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1029 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6819 "ConfigurationInterfaces.c"
				goto __catch137_configuration_error;
			}
#line 1029 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1029 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1029 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 6828 "ConfigurationInterfaces.c"
		}
#line 1029 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 1029 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 1029 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 1029 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 1029 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6840 "ConfigurationInterfaces.c"
	}
	goto __finally137;
	__catch137_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 1028 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1028 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1031 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1031 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1036 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 1036 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 1036 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1036 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6864 "ConfigurationInterfaces.c"
	}
	__finally137:
#line 1028 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1028 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1028 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 6873 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_last_used_service (ConfigurationFacade* self) {
#line 1027 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 1027 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_last_used_service (self);
#line 6882 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_last_used_service (ConfigurationFacade* self, const gchar* service_name) {
	GError * _inner_error_ = NULL;
#line 1040 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (service_name != NULL);
#line 6890 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 1042 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1042 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1042 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = service_name;
#line 1042 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_USED_SERVICE, _tmp2_, &_inner_error_);
#line 1042 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1042 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1042 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6909 "ConfigurationInterfaces.c"
				goto __catch138_configuration_error;
			}
#line 1042 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1042 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1042 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6918 "ConfigurationInterfaces.c"
		}
	}
	goto __finally138;
	__catch138_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1041 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1041 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1044 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1044 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1041 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 6936 "ConfigurationInterfaces.c"
	}
	__finally138:
#line 1041 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1041 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1041 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1041 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6947 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_last_used_service (ConfigurationFacade* self, const gchar* service_name) {
#line 1040 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1040 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_last_used_service (self, service_name);
#line 6957 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_last_used_dataimports_service (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 1053 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1053 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1053 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE, &_inner_error_);
#line 1053 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1053 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1053 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1053 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1053 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6987 "ConfigurationInterfaces.c"
				goto __catch139_configuration_error;
			}
#line 1053 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1053 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1053 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 6996 "ConfigurationInterfaces.c"
		}
#line 1053 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 1053 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 1053 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 1053 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 1053 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7008 "ConfigurationInterfaces.c"
	}
	goto __finally139;
	__catch139_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 1052 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1052 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1055 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1055 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1060 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 1060 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 1060 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1060 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7032 "ConfigurationInterfaces.c"
	}
	__finally139:
#line 1052 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1052 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1052 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 7041 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_last_used_dataimports_service (ConfigurationFacade* self) {
#line 1051 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 1051 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_last_used_dataimports_service (self);
#line 7050 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_last_used_dataimports_service (ConfigurationFacade* self, const gchar* service_name) {
	GError * _inner_error_ = NULL;
#line 1064 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (service_name != NULL);
#line 7058 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 1066 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1066 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1066 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = service_name;
#line 1066 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE, _tmp2_, &_inner_error_);
#line 1066 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1066 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1066 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7077 "ConfigurationInterfaces.c"
				goto __catch140_configuration_error;
			}
#line 1066 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1066 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1066 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7086 "ConfigurationInterfaces.c"
		}
	}
	goto __finally140;
	__catch140_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1065 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1065 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1065 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 7104 "ConfigurationInterfaces.c"
	}
	__finally140:
#line 1065 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1065 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1065 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1065 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7115 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_last_used_dataimports_service (ConfigurationFacade* self, const gchar* service_name) {
#line 1064 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1064 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_last_used_dataimports_service (self, service_name);
#line 7125 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_get_library_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by) {
	gboolean _vala_sort_order = FALSE;
	gint _vala_sort_by = 0;
	GError * _inner_error_ = NULL;
#line 1076 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_sort_order = FALSE;
#line 1077 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_sort_by = 2;
#line 7137 "ConfigurationInterfaces.c"
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gint _tmp5_ = 0;
		ConfigurationEngine* _tmp6_ = NULL;
		ConfigurationEngine* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING, &_inner_error_);
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7165 "ConfigurationInterfaces.c"
				goto __catch141_configuration_error;
			}
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7174 "ConfigurationInterfaces.c"
		}
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_sort_order = _tmp0_;
#line 1081 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = configuration_facade_get_engine (self);
#line 1081 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = _tmp6_;
#line 1081 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = configuration_engine_get_int_property (_tmp7_, CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY, &_inner_error_);
#line 1081 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = _tmp8_;
#line 1081 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp7_);
#line 1081 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp9_;
#line 1081 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1081 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7194 "ConfigurationInterfaces.c"
				goto __catch141_configuration_error;
			}
#line 1081 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1081 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1081 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7203 "ConfigurationInterfaces.c"
		}
#line 1081 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_sort_by = _tmp5_;
#line 7207 "ConfigurationInterfaces.c"
	}
	goto __finally141;
	__catch141_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp10_ = NULL;
#line 1078 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1078 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1083 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = err;
#line 1083 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp10_);
#line 1078 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 7224 "ConfigurationInterfaces.c"
	}
	__finally141:
#line 1078 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1078 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1078 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1078 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7235 "ConfigurationInterfaces.c"
	}
#line 1075 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (sort_order) {
#line 1075 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*sort_order = _vala_sort_order;
#line 7241 "ConfigurationInterfaces.c"
	}
#line 1075 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (sort_by) {
#line 1075 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*sort_by = _vala_sort_by;
#line 7247 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_get_library_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by) {
#line 1075 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1075 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->get_library_photos_sort (self, sort_order, sort_by);
#line 7257 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_library_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		ConfigurationEngine* _tmp3_ = NULL;
		ConfigurationEngine* _tmp4_ = NULL;
		gint _tmp5_ = 0;
#line 1089 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1089 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1089 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = sort_order;
#line 1089 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING, _tmp2_, &_inner_error_);
#line 1089 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1089 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1089 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7284 "ConfigurationInterfaces.c"
				goto __catch142_configuration_error;
			}
#line 1089 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1089 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1089 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7293 "ConfigurationInterfaces.c"
		}
#line 1091 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 1091 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1091 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = sort_by;
#line 1091 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp4_, CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY, _tmp5_, &_inner_error_);
#line 1091 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 1091 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1091 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7309 "ConfigurationInterfaces.c"
				goto __catch142_configuration_error;
			}
#line 1091 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1091 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1091 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7318 "ConfigurationInterfaces.c"
		}
	}
	goto __finally142;
	__catch142_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
#line 1088 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1088 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1094 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1094 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1088 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 7336 "ConfigurationInterfaces.c"
	}
	__finally142:
#line 1088 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1088 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1088 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1088 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7347 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_library_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by) {
#line 1087 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1087 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_library_photos_sort (self, sort_order, sort_by);
#line 7357 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_get_library_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions) {
	gboolean _vala_maximize = FALSE;
	Dimensions _vala_dimensions = {0};
	GError * _inner_error_ = NULL;
#line 1102 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_maximize = FALSE;
#line 1103 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	dimensions_init (&_vala_dimensions, 1024, 768);
#line 7369 "ConfigurationInterfaces.c"
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gint w = 0;
		ConfigurationEngine* _tmp5_ = NULL;
		ConfigurationEngine* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint h = 0;
		ConfigurationEngine* _tmp9_ = NULL;
		ConfigurationEngine* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE, &_inner_error_);
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7404 "ConfigurationInterfaces.c"
				goto __catch143_configuration_error;
			}
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7413 "ConfigurationInterfaces.c"
		}
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_maximize = _tmp0_;
#line 1106 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = configuration_facade_get_engine (self);
#line 1106 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = _tmp5_;
#line 1106 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = configuration_engine_get_int_property (_tmp6_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH, &_inner_error_);
#line 1106 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp7_;
#line 1106 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp6_);
#line 1106 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		w = _tmp8_;
#line 1106 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1106 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7433 "ConfigurationInterfaces.c"
				goto __catch143_configuration_error;
			}
#line 1106 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1106 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1106 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7442 "ConfigurationInterfaces.c"
		}
#line 1107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = configuration_facade_get_engine (self);
#line 1107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = _tmp9_;
#line 1107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp11_ = configuration_engine_get_int_property (_tmp10_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT, &_inner_error_);
#line 1107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp12_ = _tmp11_;
#line 1107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp10_);
#line 1107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		h = _tmp12_;
#line 1107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7460 "ConfigurationInterfaces.c"
				goto __catch143_configuration_error;
			}
#line 1107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7469 "ConfigurationInterfaces.c"
		}
#line 1108 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp13_ = w;
#line 1108 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp14_ = h;
#line 1108 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		dimensions_init (&_vala_dimensions, _tmp13_, _tmp14_);
#line 7477 "ConfigurationInterfaces.c"
	}
	goto __finally143;
	__catch143_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp15_ = NULL;
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1110 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp15_ = err;
#line 1110 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp15_);
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 7494 "ConfigurationInterfaces.c"
	}
	__finally143:
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7505 "ConfigurationInterfaces.c"
	}
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (maximize) {
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*maximize = _vala_maximize;
#line 7511 "ConfigurationInterfaces.c"
	}
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (dimensions) {
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*dimensions = _vala_dimensions;
#line 7517 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_get_library_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions) {
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->get_library_window_state (self, maximize, dimensions);
#line 7527 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_library_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions) {
	GError * _inner_error_ = NULL;
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (dimensions != NULL);
#line 7535 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		ConfigurationEngine* _tmp3_ = NULL;
		ConfigurationEngine* _tmp4_ = NULL;
		Dimensions _tmp5_ = {0};
		gint _tmp6_ = 0;
		ConfigurationEngine* _tmp7_ = NULL;
		ConfigurationEngine* _tmp8_ = NULL;
		Dimensions _tmp9_ = {0};
		gint _tmp10_ = 0;
#line 1116 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1116 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1116 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = maximize;
#line 1116 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE, _tmp2_, &_inner_error_);
#line 1116 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1116 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1116 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7562 "ConfigurationInterfaces.c"
				goto __catch144_configuration_error;
			}
#line 1116 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1116 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1116 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7571 "ConfigurationInterfaces.c"
		}
#line 1117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 1117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = *dimensions;
#line 1117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = _tmp5_.width;
#line 1117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp4_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH, _tmp6_, &_inner_error_);
#line 1117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 1117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7589 "ConfigurationInterfaces.c"
				goto __catch144_configuration_error;
			}
#line 1117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7598 "ConfigurationInterfaces.c"
		}
#line 1119 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = configuration_facade_get_engine (self);
#line 1119 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp7_;
#line 1119 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = *dimensions;
#line 1119 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = _tmp9_.height;
#line 1119 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp8_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT, _tmp10_, &_inner_error_);
#line 1119 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp8_);
#line 1119 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1119 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7616 "ConfigurationInterfaces.c"
				goto __catch144_configuration_error;
			}
#line 1119 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1119 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1119 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7625 "ConfigurationInterfaces.c"
		}
	}
	goto __finally144;
	__catch144_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp11_ = NULL;
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1122 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp11_ = err;
#line 1122 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp11_);
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 7643 "ConfigurationInterfaces.c"
	}
	__finally144:
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7654 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_library_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions) {
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_library_window_state (self, maximize, dimensions);
#line 7664 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_modify_originals (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS, &_inner_error_);
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7693 "ConfigurationInterfaces.c"
				goto __catch145_configuration_error;
			}
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 7702 "ConfigurationInterfaces.c"
		}
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7708 "ConfigurationInterfaces.c"
	}
	goto __finally145;
	__catch145_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1130 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1130 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1133 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1133 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1136 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 1136 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1136 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7729 "ConfigurationInterfaces.c"
	}
	__finally145:
#line 1130 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1130 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1130 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 7738 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_modify_originals (ConfigurationFacade* self) {
#line 1129 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1129 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_modify_originals (self);
#line 7747 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_modify_originals (ConfigurationFacade* self, gboolean modify_originals) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 1142 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1142 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1142 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = modify_originals;
#line 1142 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS, _tmp2_, &_inner_error_);
#line 1142 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1142 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1142 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7771 "ConfigurationInterfaces.c"
				goto __catch146_configuration_error;
			}
#line 1142 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1142 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1142 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7780 "ConfigurationInterfaces.c"
		}
	}
	goto __finally146;
	__catch146_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1141 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1141 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1141 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 7798 "ConfigurationInterfaces.c"
	}
	__finally146:
#line 1141 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1141 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1141 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1141 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7809 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_modify_originals (ConfigurationFacade* self, gboolean modify_originals) {
#line 1140 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1140 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_modify_originals (self, modify_originals);
#line 7819 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_photo_thumbnail_scale (ConfigurationFacade* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 1153 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1153 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1153 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE, &_inner_error_);
#line 1153 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1153 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1153 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1153 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1153 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7848 "ConfigurationInterfaces.c"
				goto __catch147_configuration_error;
			}
#line 1153 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1153 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1153 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 7857 "ConfigurationInterfaces.c"
		}
#line 1153 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1153 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7863 "ConfigurationInterfaces.c"
	}
	goto __finally147;
	__catch147_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1152 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1152 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = thumbnail_get_DEFAULT_SCALE ();
#line 1156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = _tmp6_;
#line 1156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 1156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7890 "ConfigurationInterfaces.c"
	}
	__finally147:
#line 1152 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1152 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1152 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 7899 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_photo_thumbnail_scale (ConfigurationFacade* self) {
#line 1151 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1151 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_photo_thumbnail_scale (self);
#line 7908 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_photo_thumbnail_scale (ConfigurationFacade* self, gint scale) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 1162 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1162 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1162 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = scale;
#line 1162 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE, _tmp2_, &_inner_error_);
#line 1162 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1162 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1162 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7932 "ConfigurationInterfaces.c"
				goto __catch148_configuration_error;
			}
#line 1162 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1162 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1162 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7941 "ConfigurationInterfaces.c"
		}
	}
	goto __finally148;
	__catch148_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1161 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1161 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1164 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1164 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1161 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 7959 "ConfigurationInterfaces.c"
	}
	__finally148:
#line 1161 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1161 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1161 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1161 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7970 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_photo_thumbnail_scale (ConfigurationFacade* self, gint scale) {
#line 1160 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1160 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_photo_thumbnail_scale (self, scale);
#line 7980 "ConfigurationInterfaces.c"
}


static gdouble configuration_facade_real_get_printing_content_height (ConfigurationFacade* self) {
	gdouble result = 0.0;
	GError * _inner_error_ = NULL;
	{
		gdouble _tmp0_ = 0.0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
#line 1173 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1173 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1173 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_double_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT, &_inner_error_);
#line 1173 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1173 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1173 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1173 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1173 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8009 "ConfigurationInterfaces.c"
				goto __catch149_configuration_error;
			}
#line 1173 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1173 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1173 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0.0;
#line 8018 "ConfigurationInterfaces.c"
		}
#line 1173 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1173 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8024 "ConfigurationInterfaces.c"
	}
	goto __finally149;
	__catch149_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1172 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1172 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1175 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1175 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 5.0;
#line 1177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8045 "ConfigurationInterfaces.c"
	}
	__finally149:
#line 1172 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1172 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1172 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0.0;
#line 8054 "ConfigurationInterfaces.c"
}


gdouble configuration_facade_get_printing_content_height (ConfigurationFacade* self) {
#line 1171 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
#line 1171 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_content_height (self);
#line 8063 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_content_height (ConfigurationFacade* self, gdouble content_height) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gdouble _tmp2_ = 0.0;
#line 1183 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1183 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1183 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = content_height;
#line 1183 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_double_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT, _tmp2_, &_inner_error_);
#line 1183 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1183 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1183 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8087 "ConfigurationInterfaces.c"
				goto __catch150_configuration_error;
			}
#line 1183 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1183 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1183 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8096 "ConfigurationInterfaces.c"
		}
	}
	goto __finally150;
	__catch150_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1182 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1182 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1186 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1186 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1182 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8114 "ConfigurationInterfaces.c"
	}
	__finally150:
#line 1182 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1182 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1182 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1182 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8125 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_content_height (ConfigurationFacade* self, gdouble content_height) {
#line 1181 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1181 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_content_height (self, content_height);
#line 8135 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_printing_content_layout (ConfigurationFacade* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 1195 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1195 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1195 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT, &_inner_error_);
#line 1195 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1195 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1195 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1195 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1195 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8164 "ConfigurationInterfaces.c"
				goto __catch151_configuration_error;
			}
#line 1195 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1195 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1195 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 8173 "ConfigurationInterfaces.c"
		}
#line 1195 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_ - 1;
#line 1195 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8179 "ConfigurationInterfaces.c"
	}
	goto __finally151;
	__catch151_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1194 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1194 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8200 "ConfigurationInterfaces.c"
	}
	__finally151:
#line 1194 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1194 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1194 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 8209 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_printing_content_layout (ConfigurationFacade* self) {
#line 1193 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1193 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_content_layout (self);
#line 8218 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_content_layout (ConfigurationFacade* self, gint layout_code) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 1205 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1205 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1205 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = layout_code;
#line 1205 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT, _tmp2_ + 1, &_inner_error_);
#line 1205 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1205 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1205 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8242 "ConfigurationInterfaces.c"
				goto __catch152_configuration_error;
			}
#line 1205 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1205 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1205 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8251 "ConfigurationInterfaces.c"
		}
	}
	goto __finally152;
	__catch152_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1204 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1204 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1208 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1208 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1204 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8269 "ConfigurationInterfaces.c"
	}
	__finally152:
#line 1204 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1204 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1204 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1204 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8280 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_content_layout (ConfigurationFacade* self, gint layout_code) {
#line 1203 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1203 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_content_layout (self, layout_code);
#line 8290 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_printing_content_ppi (ConfigurationFacade* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI, &_inner_error_);
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8319 "ConfigurationInterfaces.c"
				goto __catch153_configuration_error;
			}
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 8328 "ConfigurationInterfaces.c"
		}
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8334 "ConfigurationInterfaces.c"
	}
	goto __finally153;
	__catch153_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1216 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1216 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1219 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1219 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 600;
#line 1221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8355 "ConfigurationInterfaces.c"
	}
	__finally153:
#line 1216 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1216 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1216 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 8364 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_printing_content_ppi (ConfigurationFacade* self) {
#line 1215 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1215 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_content_ppi (self);
#line 8373 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_content_ppi (ConfigurationFacade* self, gint content_ppi) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 1227 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1227 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1227 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = content_ppi;
#line 1227 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI, _tmp2_, &_inner_error_);
#line 1227 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1227 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1227 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8397 "ConfigurationInterfaces.c"
				goto __catch154_configuration_error;
			}
#line 1227 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1227 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1227 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8406 "ConfigurationInterfaces.c"
		}
	}
	goto __finally154;
	__catch154_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1226 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1226 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1229 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1229 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1226 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8424 "ConfigurationInterfaces.c"
	}
	__finally154:
#line 1226 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1226 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1226 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1226 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8435 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_content_ppi (ConfigurationFacade* self, gint content_ppi) {
#line 1225 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1225 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_content_ppi (self, content_ppi);
#line 8445 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_printing_content_units (ConfigurationFacade* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 1238 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1238 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1238 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS, &_inner_error_);
#line 1238 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1238 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1238 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1238 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1238 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8474 "ConfigurationInterfaces.c"
				goto __catch155_configuration_error;
			}
#line 1238 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1238 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1238 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 8483 "ConfigurationInterfaces.c"
		}
#line 1238 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_ - 1;
#line 1238 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8489 "ConfigurationInterfaces.c"
	}
	goto __finally155;
	__catch155_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1237 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1237 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1240 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1240 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1242 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 1242 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1242 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8510 "ConfigurationInterfaces.c"
	}
	__finally155:
#line 1237 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1237 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1237 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 8519 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_printing_content_units (ConfigurationFacade* self) {
#line 1236 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1236 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_content_units (self);
#line 8528 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_content_units (ConfigurationFacade* self, gint units_code) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 1248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = units_code;
#line 1248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS, _tmp2_ + 1, &_inner_error_);
#line 1248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8552 "ConfigurationInterfaces.c"
				goto __catch156_configuration_error;
			}
#line 1248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8561 "ConfigurationInterfaces.c"
		}
	}
	goto __finally156;
	__catch156_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1247 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1247 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1251 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1251 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1247 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8579 "ConfigurationInterfaces.c"
	}
	__finally156:
#line 1247 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1247 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1247 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1247 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8590 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_content_units (ConfigurationFacade* self, gint units_code) {
#line 1246 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1246 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_content_units (self, units_code);
#line 8600 "ConfigurationInterfaces.c"
}


static gdouble configuration_facade_real_get_printing_content_width (ConfigurationFacade* self) {
	gdouble result = 0.0;
	GError * _inner_error_ = NULL;
	{
		gdouble _tmp0_ = 0.0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
#line 1260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_double_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH, &_inner_error_);
#line 1260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8629 "ConfigurationInterfaces.c"
				goto __catch157_configuration_error;
			}
#line 1260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0.0;
#line 8638 "ConfigurationInterfaces.c"
		}
#line 1260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8644 "ConfigurationInterfaces.c"
	}
	goto __finally157;
	__catch157_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1259 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1259 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1262 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1262 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 7.0;
#line 1264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8665 "ConfigurationInterfaces.c"
	}
	__finally157:
#line 1259 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1259 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1259 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0.0;
#line 8674 "ConfigurationInterfaces.c"
}


gdouble configuration_facade_get_printing_content_width (ConfigurationFacade* self) {
#line 1258 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
#line 1258 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_content_width (self);
#line 8683 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_content_width (ConfigurationFacade* self, gdouble content_width) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gdouble _tmp2_ = 0.0;
#line 1270 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1270 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1270 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = content_width;
#line 1270 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_double_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH, _tmp2_, &_inner_error_);
#line 1270 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1270 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1270 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8707 "ConfigurationInterfaces.c"
				goto __catch158_configuration_error;
			}
#line 1270 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1270 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1270 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8716 "ConfigurationInterfaces.c"
		}
	}
	goto __finally158;
	__catch158_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1269 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1269 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1273 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1273 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1269 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8734 "ConfigurationInterfaces.c"
	}
	__finally158:
#line 1269 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1269 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1269 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1269 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8745 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_content_width (ConfigurationFacade* self, gdouble content_width) {
#line 1268 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1268 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_content_width (self, content_width);
#line 8755 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_printing_images_per_page (ConfigurationFacade* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 1282 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1282 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1282 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE, &_inner_error_);
#line 1282 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1282 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1282 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1282 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1282 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8784 "ConfigurationInterfaces.c"
				goto __catch159_configuration_error;
			}
#line 1282 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1282 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1282 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 8793 "ConfigurationInterfaces.c"
		}
#line 1282 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_ - 1;
#line 1282 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8799 "ConfigurationInterfaces.c"
	}
	goto __finally159;
	__catch159_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1281 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1281 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1284 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1284 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8820 "ConfigurationInterfaces.c"
	}
	__finally159:
#line 1281 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1281 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1281 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 8829 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_printing_images_per_page (ConfigurationFacade* self) {
#line 1280 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1280 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_images_per_page (self);
#line 8838 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_images_per_page (ConfigurationFacade* self, gint images_per_page_code) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 1292 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1292 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1292 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = images_per_page_code;
#line 1292 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE, _tmp2_ + 1, &_inner_error_);
#line 1292 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1292 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1292 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8862 "ConfigurationInterfaces.c"
				goto __catch160_configuration_error;
			}
#line 1292 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1292 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1292 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8871 "ConfigurationInterfaces.c"
		}
	}
	goto __finally160;
	__catch160_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1291 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1291 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1295 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1295 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1291 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8889 "ConfigurationInterfaces.c"
	}
	__finally160:
#line 1291 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1291 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1291 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1291 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8900 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_images_per_page (ConfigurationFacade* self, gint images_per_page_code) {
#line 1290 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1290 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_images_per_page (self, images_per_page_code);
#line 8910 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_printing_match_aspect_ratio (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 1304 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1304 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1304 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO, &_inner_error_);
#line 1304 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1304 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1304 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1304 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1304 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8939 "ConfigurationInterfaces.c"
				goto __catch161_configuration_error;
			}
#line 1304 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1304 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1304 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 8948 "ConfigurationInterfaces.c"
		}
#line 1304 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1304 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8954 "ConfigurationInterfaces.c"
	}
	goto __finally161;
	__catch161_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1303 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1303 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1306 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1306 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 1308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8975 "ConfigurationInterfaces.c"
	}
	__finally161:
#line 1303 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1303 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1303 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 8984 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_printing_match_aspect_ratio (ConfigurationFacade* self) {
#line 1302 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1302 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_match_aspect_ratio (self);
#line 8993 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_match_aspect_ratio (ConfigurationFacade* self, gboolean match_aspect_ratio) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 1314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = match_aspect_ratio;
#line 1314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO, _tmp2_, &_inner_error_);
#line 1314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9017 "ConfigurationInterfaces.c"
				goto __catch162_configuration_error;
			}
#line 1314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9026 "ConfigurationInterfaces.c"
		}
	}
	goto __finally162;
	__catch162_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1313 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1313 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1317 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1317 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1313 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9044 "ConfigurationInterfaces.c"
	}
	__finally162:
#line 1313 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1313 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1313 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1313 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9055 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_match_aspect_ratio (ConfigurationFacade* self, gboolean match_aspect_ratio) {
#line 1312 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1312 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_match_aspect_ratio (self, match_aspect_ratio);
#line 9065 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_printing_print_titles (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 1326 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1326 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1326 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES, &_inner_error_);
#line 1326 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1326 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1326 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1326 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1326 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9094 "ConfigurationInterfaces.c"
				goto __catch163_configuration_error;
			}
#line 1326 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1326 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1326 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 9103 "ConfigurationInterfaces.c"
		}
#line 1326 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1326 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9109 "ConfigurationInterfaces.c"
	}
	goto __finally163;
	__catch163_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1325 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1325 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1328 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1328 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1330 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 1330 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1330 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9130 "ConfigurationInterfaces.c"
	}
	__finally163:
#line 1325 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1325 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1325 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 9139 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_printing_print_titles (ConfigurationFacade* self) {
#line 1324 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1324 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_print_titles (self);
#line 9148 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_print_titles (ConfigurationFacade* self, gboolean print_titles) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 1336 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1336 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1336 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = print_titles;
#line 1336 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES, _tmp2_, &_inner_error_);
#line 1336 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1336 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1336 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9172 "ConfigurationInterfaces.c"
				goto __catch164_configuration_error;
			}
#line 1336 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1336 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1336 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9181 "ConfigurationInterfaces.c"
		}
	}
	goto __finally164;
	__catch164_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1335 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1335 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1335 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9199 "ConfigurationInterfaces.c"
	}
	__finally164:
#line 1335 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1335 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1335 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1335 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9210 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_print_titles (ConfigurationFacade* self, gboolean print_titles) {
#line 1334 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1334 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_print_titles (self, print_titles);
#line 9220 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_printing_size_selection (ConfigurationFacade* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 1348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION, &_inner_error_);
#line 1348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9249 "ConfigurationInterfaces.c"
				goto __catch165_configuration_error;
			}
#line 1348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 9258 "ConfigurationInterfaces.c"
		}
#line 1348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_ - 1;
#line 1348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9264 "ConfigurationInterfaces.c"
	}
	goto __finally165;
	__catch165_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1347 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1347 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1350 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1350 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 1352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9285 "ConfigurationInterfaces.c"
	}
	__finally165:
#line 1347 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1347 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1347 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 9294 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_printing_size_selection (ConfigurationFacade* self) {
#line 1346 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1346 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_size_selection (self);
#line 9303 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_size_selection (ConfigurationFacade* self, gint size_code) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 1358 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1358 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1358 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = size_code;
#line 1358 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION, _tmp2_ + 1, &_inner_error_);
#line 1358 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1358 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1358 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9327 "ConfigurationInterfaces.c"
				goto __catch166_configuration_error;
			}
#line 1358 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1358 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1358 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9336 "ConfigurationInterfaces.c"
		}
	}
	goto __finally166;
	__catch166_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1357 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1357 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1361 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1361 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1357 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9354 "ConfigurationInterfaces.c"
	}
	__finally166:
#line 1357 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1357 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1357 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1357 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9365 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_size_selection (ConfigurationFacade* self, gint size_code) {
#line 1356 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1356 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_size_selection (self, size_code);
#line 9375 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_printing_titles_font (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 1370 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1370 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1370 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT, &_inner_error_);
#line 1370 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1370 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1370 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1370 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1370 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9405 "ConfigurationInterfaces.c"
				goto __catch167_configuration_error;
			}
#line 1370 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1370 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1370 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 9414 "ConfigurationInterfaces.c"
		}
#line 1370 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 1370 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 1370 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 1370 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 1370 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9426 "ConfigurationInterfaces.c"
	}
	goto __finally167;
	__catch167_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 1369 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1369 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1372 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1372 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1376 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("Sans Bold 12");
#line 1376 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 1376 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1376 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9450 "ConfigurationInterfaces.c"
	}
	__finally167:
#line 1369 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1369 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1369 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 9459 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_printing_titles_font (ConfigurationFacade* self) {
#line 1368 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 1368 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_titles_font (self);
#line 9468 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_titles_font (ConfigurationFacade* self, const gchar* font_name) {
	GError * _inner_error_ = NULL;
#line 1380 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (font_name != NULL);
#line 9476 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 1382 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1382 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1382 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = font_name;
#line 1382 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT, _tmp2_, &_inner_error_);
#line 1382 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1382 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1382 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9495 "ConfigurationInterfaces.c"
				goto __catch168_configuration_error;
			}
#line 1382 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1382 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1382 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9504 "ConfigurationInterfaces.c"
		}
	}
	goto __finally168;
	__catch168_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1381 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1381 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1381 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9522 "ConfigurationInterfaces.c"
	}
	__finally168:
#line 1381 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1381 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1381 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1381 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9533 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_titles_font (ConfigurationFacade* self, const gchar* font_name) {
#line 1380 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1380 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_titles_font (self, font_name);
#line 9543 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_show_welcome_dialog (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 1393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG, &_inner_error_);
#line 1393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9572 "ConfigurationInterfaces.c"
				goto __catch169_configuration_error;
			}
#line 1393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 9581 "ConfigurationInterfaces.c"
		}
#line 1393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9587 "ConfigurationInterfaces.c"
	}
	goto __finally169;
	__catch169_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1392 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1392 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1395 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1395 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 1397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9608 "ConfigurationInterfaces.c"
	}
	__finally169:
#line 1392 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1392 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1392 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 9617 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_show_welcome_dialog (ConfigurationFacade* self) {
#line 1391 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1391 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_show_welcome_dialog (self);
#line 9626 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_show_welcome_dialog (ConfigurationFacade* self, gboolean show) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 1403 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1403 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1403 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = show;
#line 1403 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG, _tmp2_, &_inner_error_);
#line 1403 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1403 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1403 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9650 "ConfigurationInterfaces.c"
				goto __catch170_configuration_error;
			}
#line 1403 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1403 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1403 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9659 "ConfigurationInterfaces.c"
		}
	}
	goto __finally170;
	__catch170_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1402 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1402 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1406 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1406 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1402 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9677 "ConfigurationInterfaces.c"
	}
	__finally170:
#line 1402 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1402 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1402 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1402 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9688 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_show_welcome_dialog (ConfigurationFacade* self, gboolean show) {
#line 1401 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1401 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_show_welcome_dialog (self, show);
#line 9698 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_sidebar_position (ConfigurationFacade* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 1415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_SIDEBAR_POSITION, &_inner_error_);
#line 1415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9727 "ConfigurationInterfaces.c"
				goto __catch171_configuration_error;
			}
#line 1415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 9736 "ConfigurationInterfaces.c"
		}
#line 1415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9742 "ConfigurationInterfaces.c"
	}
	goto __finally171;
	__catch171_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1414 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1414 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1417 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1417 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 180;
#line 1419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9763 "ConfigurationInterfaces.c"
	}
	__finally171:
#line 1414 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1414 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1414 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 9772 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_sidebar_position (ConfigurationFacade* self) {
#line 1413 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1413 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_sidebar_position (self);
#line 9781 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_sidebar_position (ConfigurationFacade* self, gint position) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 1425 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1425 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1425 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = position;
#line 1425 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_SIDEBAR_POSITION, _tmp2_, &_inner_error_);
#line 1425 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1425 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1425 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9805 "ConfigurationInterfaces.c"
				goto __catch172_configuration_error;
			}
#line 1425 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1425 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1425 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9814 "ConfigurationInterfaces.c"
		}
	}
	goto __finally172;
	__catch172_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1424 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1424 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1427 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1427 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1424 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9832 "ConfigurationInterfaces.c"
	}
	__finally172:
#line 1424 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1424 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1424 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1424 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9843 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_sidebar_position (ConfigurationFacade* self, gint position) {
#line 1423 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1423 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_sidebar_position (self, position);
#line 9853 "ConfigurationInterfaces.c"
}


static gdouble configuration_facade_real_get_slideshow_delay (ConfigurationFacade* self) {
	gdouble result = 0.0;
	GError * _inner_error_ = NULL;
	{
		gdouble _tmp0_ = 0.0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
#line 1436 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1436 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1436 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_double_property (_tmp2_, CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY, &_inner_error_);
#line 1436 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1436 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1436 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1436 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1436 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9882 "ConfigurationInterfaces.c"
				goto __catch173_configuration_error;
			}
#line 1436 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1436 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1436 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0.0;
#line 9891 "ConfigurationInterfaces.c"
		}
#line 1436 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1436 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9897 "ConfigurationInterfaces.c"
	}
	goto __finally173;
	__catch173_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1435 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1435 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1438 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1440 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 3.0;
#line 1440 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1440 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9918 "ConfigurationInterfaces.c"
	}
	__finally173:
#line 1435 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1435 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1435 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0.0;
#line 9927 "ConfigurationInterfaces.c"
}


gdouble configuration_facade_get_slideshow_delay (ConfigurationFacade* self) {
#line 1434 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
#line 1434 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_slideshow_delay (self);
#line 9936 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_slideshow_delay (ConfigurationFacade* self, gdouble delay) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gdouble _tmp2_ = 0.0;
#line 1446 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1446 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1446 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = delay;
#line 1446 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_double_property (_tmp1_, CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY, _tmp2_, &_inner_error_);
#line 1446 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1446 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1446 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9960 "ConfigurationInterfaces.c"
				goto __catch174_configuration_error;
			}
#line 1446 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1446 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1446 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9969 "ConfigurationInterfaces.c"
		}
	}
	goto __finally174;
	__catch174_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1445 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1445 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1448 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1448 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1445 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9987 "ConfigurationInterfaces.c"
	}
	__finally174:
#line 1445 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1445 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1445 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1445 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9998 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_slideshow_delay (ConfigurationFacade* self, gdouble delay) {
#line 1444 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1444 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_slideshow_delay (self, delay);
#line 10008 "ConfigurationInterfaces.c"
}


static gdouble configuration_facade_real_get_slideshow_transition_delay (ConfigurationFacade* self) {
	gdouble result = 0.0;
	GError * _inner_error_ = NULL;
	{
		gdouble _tmp0_ = 0.0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
#line 1457 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1457 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1457 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_double_property (_tmp2_, CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY, &_inner_error_);
#line 1457 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1457 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1457 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1457 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1457 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10037 "ConfigurationInterfaces.c"
				goto __catch175_configuration_error;
			}
#line 1457 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1457 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1457 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0.0;
#line 10046 "ConfigurationInterfaces.c"
		}
#line 1457 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1457 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10052 "ConfigurationInterfaces.c"
	}
	goto __finally175;
	__catch175_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0.3;
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10073 "ConfigurationInterfaces.c"
	}
	__finally175:
#line 1456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0.0;
#line 10082 "ConfigurationInterfaces.c"
}


gdouble configuration_facade_get_slideshow_transition_delay (ConfigurationFacade* self) {
#line 1455 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
#line 1455 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_slideshow_transition_delay (self);
#line 10091 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_slideshow_transition_delay (ConfigurationFacade* self, gdouble delay) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gdouble _tmp2_ = 0.0;
#line 1468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = delay;
#line 1468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_double_property (_tmp1_, CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY, _tmp2_, &_inner_error_);
#line 1468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10115 "ConfigurationInterfaces.c"
				goto __catch176_configuration_error;
			}
#line 1468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 10124 "ConfigurationInterfaces.c"
		}
	}
	goto __finally176;
	__catch176_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1467 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1467 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1471 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1471 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1467 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 10142 "ConfigurationInterfaces.c"
	}
	__finally176:
#line 1467 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1467 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1467 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1467 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10153 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_slideshow_transition_delay (ConfigurationFacade* self, gdouble delay) {
#line 1466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_slideshow_transition_delay (self, delay);
#line 10163 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_slideshow_transition_effect_id (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID, &_inner_error_);
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10193 "ConfigurationInterfaces.c"
				goto __catch177_configuration_error;
			}
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 10202 "ConfigurationInterfaces.c"
		}
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10214 "ConfigurationInterfaces.c"
	}
	goto __finally177;
	__catch177_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 1479 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1479 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1487 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup (TRANSITION_EFFECTS_MANAGER_NULL_EFFECT_ID);
#line 1487 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 1487 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1487 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10238 "ConfigurationInterfaces.c"
	}
	__finally177:
#line 1479 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1479 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1479 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 10247 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_slideshow_transition_effect_id (ConfigurationFacade* self) {
#line 1478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 1478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_slideshow_transition_effect_id (self);
#line 10256 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_slideshow_transition_effect_id (ConfigurationFacade* self, const gchar* id) {
	GError * _inner_error_ = NULL;
#line 1491 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 10264 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 1493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = id;
#line 1493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID, _tmp2_, &_inner_error_);
#line 1493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10283 "ConfigurationInterfaces.c"
				goto __catch178_configuration_error;
			}
#line 1493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 10292 "ConfigurationInterfaces.c"
		}
	}
	goto __finally178;
	__catch178_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1496 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1496 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 10310 "ConfigurationInterfaces.c"
	}
	__finally178:
#line 1492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10321 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_slideshow_transition_effect_id (ConfigurationFacade* self, const gchar* id) {
#line 1491 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1491 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_slideshow_transition_effect_id (self, id);
#line 10331 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_slideshow_show_title (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE, &_inner_error_);
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10360 "ConfigurationInterfaces.c"
				goto __catch179_configuration_error;
			}
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 10369 "ConfigurationInterfaces.c"
		}
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10375 "ConfigurationInterfaces.c"
	}
	goto __finally179;
	__catch179_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1507 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1507 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1509 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 1509 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1509 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10396 "ConfigurationInterfaces.c"
	}
	__finally179:
#line 1504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 10405 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_slideshow_show_title (ConfigurationFacade* self) {
#line 1503 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1503 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_slideshow_show_title (self);
#line 10414 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_slideshow_show_title (ConfigurationFacade* self, gboolean show_title) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 1515 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1515 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1515 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = show_title;
#line 1515 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE, _tmp2_, &_inner_error_);
#line 1515 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1515 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1515 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10438 "ConfigurationInterfaces.c"
				goto __catch180_configuration_error;
			}
#line 1515 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1515 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1515 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 10447 "ConfigurationInterfaces.c"
		}
	}
	goto __finally180;
	__catch180_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1517 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1517 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 10465 "ConfigurationInterfaces.c"
	}
	__finally180:
#line 1514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10476 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_slideshow_show_title (ConfigurationFacade* self, gboolean show_title) {
#line 1513 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1513 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_slideshow_show_title (self, show_title);
#line 10486 "ConfigurationInterfaces.c"
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
#line 2701 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	localtime_r (&time, &_tmp0_);
#line 2701 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 2702 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	*result = _result_;
#line 2702 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	return;
#line 10501 "ConfigurationInterfaces.c"
}


static gchar* g_time_format (struct tm *self, const gchar* format) {
	gchar* result = NULL;
	gchar* buffer = NULL;
	gchar* _tmp0_ = NULL;
	gint buffer_length1 = 0;
	gint _buffer_size_ = 0;
	gchar* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar* _tmp4_ = NULL;
#line 2709 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (format != NULL, NULL);
#line 2710 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 64);
#line 2710 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	buffer = _tmp0_;
#line 2710 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	buffer_length1 = 64;
#line 2710 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_buffer_size_ = buffer_length1;
#line 2711 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1_ = buffer;
#line 2711 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp1__length1 = buffer_length1;
#line 2711 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp2_ = format;
#line 2711 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	strftime (_tmp1_, _tmp1__length1, _tmp2_, &(*self));
#line 2712 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp3_ = buffer;
#line 2712 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp3__length1 = buffer_length1;
#line 2712 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
#line 2712 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 2712 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	buffer = (g_free (buffer), NULL);
#line 2712 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	return result;
#line 10547 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_use_24_hour_time (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 1526 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1526 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1526 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME, &_inner_error_);
#line 1526 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1526 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1526 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1526 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1526 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10576 "ConfigurationInterfaces.c"
				goto __catch181_configuration_error;
			}
#line 1526 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1526 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1526 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 10585 "ConfigurationInterfaces.c"
		}
#line 1526 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1526 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10591 "ConfigurationInterfaces.c"
	}
	goto __finally181;
	__catch181_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
		struct tm _tmp6_ = {0};
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
#line 1525 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1525 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1528 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1528 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_time_local ((time_t) 0, &_tmp6_);
#line 1532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_time_format (&_tmp6_, "%p");
#line 1532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp7_;
#line 1532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = is_string_empty (_tmp8_);
#line 1532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = _tmp9_;
#line 1532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp8_);
#line 1532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp10_;
#line 1532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10629 "ConfigurationInterfaces.c"
	}
	__finally181:
#line 1525 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1525 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1525 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 10638 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_use_24_hour_time (ConfigurationFacade* self) {
#line 1524 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1524 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_use_24_hour_time (self);
#line 10647 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_use_24_hour_time (ConfigurationFacade* self, gboolean use_24_hour_time) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 1538 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1538 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1538 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = use_24_hour_time;
#line 1538 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME, _tmp2_, &_inner_error_);
#line 1538 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1538 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1538 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10671 "ConfigurationInterfaces.c"
				goto __catch182_configuration_error;
			}
#line 1538 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1538 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1538 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 10680 "ConfigurationInterfaces.c"
		}
	}
	goto __finally182;
	__catch182_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1537 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1537 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1540 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1540 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1537 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 10698 "ConfigurationInterfaces.c"
	}
	__finally182:
#line 1537 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1537 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1537 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1537 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10709 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_use_24_hour_time (ConfigurationFacade* self, gboolean use_24_hour_time) {
#line 1536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_use_24_hour_time (self, use_24_hour_time);
#line 10719 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_use_lowercase_filenames (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES, &_inner_error_);
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10748 "ConfigurationInterfaces.c"
				goto __catch183_configuration_error;
			}
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 10757 "ConfigurationInterfaces.c"
		}
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10763 "ConfigurationInterfaces.c"
	}
	goto __finally183;
	__catch183_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1551 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1551 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1553 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 1553 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1553 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10784 "ConfigurationInterfaces.c"
	}
	__finally183:
#line 1548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 10793 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_use_lowercase_filenames (ConfigurationFacade* self) {
#line 1547 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1547 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_use_lowercase_filenames (self);
#line 10802 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_use_lowercase_filenames (ConfigurationFacade* self, gboolean b) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 1559 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1559 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1559 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = b;
#line 1559 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES, _tmp2_, &_inner_error_);
#line 1559 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1559 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1559 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10826 "ConfigurationInterfaces.c"
				goto __catch184_configuration_error;
			}
#line 1559 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1559 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1559 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 10835 "ConfigurationInterfaces.c"
		}
	}
	goto __finally184;
	__catch184_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1561 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1561 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 10853 "ConfigurationInterfaces.c"
	}
	__finally184:
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10864 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_use_lowercase_filenames (ConfigurationFacade* self, gboolean b) {
#line 1557 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1557 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_use_lowercase_filenames (self, b);
#line 10874 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_video_interpreter_state_cookie (ConfigurationFacade* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 1570 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1570 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1570 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE, &_inner_error_);
#line 1570 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1570 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1570 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1570 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1570 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10903 "ConfigurationInterfaces.c"
				goto __catch185_configuration_error;
			}
#line 1570 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1570 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1570 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 10912 "ConfigurationInterfaces.c"
		}
#line 1570 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1570 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10918 "ConfigurationInterfaces.c"
	}
	goto __finally185;
	__catch185_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1569 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1569 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1573 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1573 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1575 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = -1;
#line 1575 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1575 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10939 "ConfigurationInterfaces.c"
	}
	__finally185:
#line 1569 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1569 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1569 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 10948 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_video_interpreter_state_cookie (ConfigurationFacade* self) {
#line 1568 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1568 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_video_interpreter_state_cookie (self);
#line 10957 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_video_interpreter_state_cookie (ConfigurationFacade* self, gint state_cookie) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 1581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = state_cookie;
#line 1581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE, _tmp2_, &_inner_error_);
#line 1581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10981 "ConfigurationInterfaces.c"
				goto __catch186_configuration_error;
			}
#line 1581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 10990 "ConfigurationInterfaces.c"
		}
	}
	goto __finally186;
	__catch186_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1584 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1584 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 11008 "ConfigurationInterfaces.c"
	}
	__finally186:
#line 1580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 11019 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_video_interpreter_state_cookie (ConfigurationFacade* self, gint state_cookie) {
#line 1579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_video_interpreter_state_cookie (self, state_cookie);
#line 11029 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def) {
	gboolean result = FALSE;
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
#line 1591 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (domain != NULL, FALSE);
#line 1591 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (id != NULL, FALSE);
#line 1591 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 1592 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1592 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1592 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1592 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1592 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1592 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = def;
#line 1592 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp6_ = configuration_engine_get_plugin_bool (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1592 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp7_ = _tmp6_;
#line 1592 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 1592 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp7_;
#line 1592 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 11071 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def) {
#line 1591 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1591 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_plugin_bool (self, domain, id, key, def);
#line 11080 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val) {
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 1595 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (domain != NULL);
#line 1595 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1595 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (key != NULL);
#line 1596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = val;
#line 1596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_set_plugin_bool (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 11113 "ConfigurationInterfaces.c"
}


void configuration_facade_set_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val) {
#line 1595 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1595 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_plugin_bool (self, domain, id, key, val);
#line 11122 "ConfigurationInterfaces.c"
}


static gdouble configuration_facade_real_get_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def) {
	gdouble result = 0.0;
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
#line 1599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (domain != NULL, 0.0);
#line 1599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (id != NULL, 0.0);
#line 1599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (key != NULL, 0.0);
#line 1600 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1600 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1600 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1600 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1600 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1600 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = def;
#line 1600 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp6_ = configuration_engine_get_plugin_double (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1600 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp7_ = _tmp6_;
#line 1600 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 1600 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp7_;
#line 1600 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 11164 "ConfigurationInterfaces.c"
}


gdouble configuration_facade_get_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def) {
#line 1599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
#line 1599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_plugin_double (self, domain, id, key, def);
#line 11173 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val) {
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
#line 1603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (domain != NULL);
#line 1603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (key != NULL);
#line 1604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = val;
#line 1604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_set_plugin_double (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 11206 "ConfigurationInterfaces.c"
}


void configuration_facade_set_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val) {
#line 1603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_plugin_double (self, domain, id, key, val);
#line 11215 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint def) {
	gint result = 0;
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
#line 1607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (domain != NULL, 0);
#line 1607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (id != NULL, 0);
#line 1607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (key != NULL, 0);
#line 1608 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1608 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1608 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1608 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1608 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1608 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = def;
#line 1608 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp6_ = configuration_engine_get_plugin_int (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1608 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp7_ = _tmp6_;
#line 1608 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 1608 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp7_;
#line 1608 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 11257 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint def) {
#line 1607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_plugin_int (self, domain, id, key, def);
#line 11266 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint val) {
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
#line 1611 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (domain != NULL);
#line 1611 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1611 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (key != NULL);
#line 1612 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1612 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1612 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1612 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1612 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1612 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = val;
#line 1612 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_set_plugin_int (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1612 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 11299 "ConfigurationInterfaces.c"
}


void configuration_facade_set_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint val) {
#line 1611 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1611 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_plugin_int (self, domain, id, key, val);
#line 11308 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp11_ = NULL;
#line 1615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (domain != NULL, NULL);
#line 1615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 1615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 1616 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1616 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1616 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1616 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1616 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1616 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = def;
#line 1616 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp6_ = configuration_engine_get_plugin_string (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1616 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp7_ = _tmp6_;
#line 1616 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 1616 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_result_ = _tmp7_;
#line 1617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp9_ = _result_;
#line 1617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (g_strcmp0 (_tmp9_, "") == 0) {
#line 1617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = NULL;
#line 11358 "ConfigurationInterfaces.c"
	} else {
		const gchar* _tmp10_ = NULL;
#line 1617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = _result_;
#line 1617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp10_;
#line 11365 "ConfigurationInterfaces.c"
	}
#line 1617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp11_ = g_strdup (_tmp8_);
#line 1617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp11_;
#line 1617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_free0 (_result_);
#line 1617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 11375 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def) {
#line 1615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 1615 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_plugin_string (self, domain, id, key, def);
#line 11384 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val) {
	const gchar* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	ConfigurationEngine* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
#line 1620 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (domain != NULL);
#line 1620 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1620 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (key != NULL);
#line 1621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = val;
#line 1621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (_tmp0_ == NULL) {
#line 1622 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		val = "";
#line 11408 "ConfigurationInterfaces.c"
	}
#line 1624 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = configuration_facade_get_engine (self);
#line 1624 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = _tmp1_;
#line 1624 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = domain;
#line 1624 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = id;
#line 1624 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = key;
#line 1624 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp6_ = val;
#line 1624 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_set_plugin_string (_tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_);
#line 1624 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp2_);
#line 11426 "ConfigurationInterfaces.c"
}


void configuration_facade_set_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val) {
#line 1620 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1620 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_plugin_string (self, domain, id, key, val);
#line 11435 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_unset_plugin_key (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key) {
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
#line 1627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (domain != NULL);
#line 1627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (key != NULL);
#line 1628 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1628 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1628 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1628 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1628 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1628 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_unset_plugin_key (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 1628 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 11465 "ConfigurationInterfaces.c"
}


void configuration_facade_unset_plugin_key (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key) {
#line 1627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->unset_plugin_key (self, domain, id, key);
#line 11474 "ConfigurationInterfaces.c"
}


static FuzzyPropertyState configuration_facade_real_is_plugin_enabled (ConfigurationFacade* self, const gchar* id) {
	FuzzyPropertyState result = 0;
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	FuzzyPropertyState _tmp3_ = 0;
	FuzzyPropertyState _tmp4_ = 0;
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (id != NULL, 0);
#line 1635 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1635 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1635 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = id;
#line 1635 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = configuration_engine_is_plugin_enabled (_tmp1_, _tmp2_);
#line 1635 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = _tmp3_;
#line 1635 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 1635 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp4_;
#line 1635 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 11503 "ConfigurationInterfaces.c"
}


FuzzyPropertyState configuration_facade_is_plugin_enabled (ConfigurationFacade* self, const gchar* id) {
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->is_plugin_enabled (self, id);
#line 11512 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_plugin_enabled (ConfigurationFacade* self, const gchar* id, gboolean enabled) {
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 1638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1639 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1639 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1639 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = id;
#line 1639 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = enabled;
#line 1639 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_set_plugin_enabled (_tmp1_, _tmp2_, _tmp3_);
#line 1639 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 11535 "ConfigurationInterfaces.c"
}


void configuration_facade_set_plugin_enabled (ConfigurationFacade* self, const gchar* id, gboolean enabled) {
#line 1638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_plugin_enabled (self, id, enabled);
#line 11544 "ConfigurationInterfaces.c"
}


static void configuration_facade_class_init (ConfigurationFacadeClass * klass) {
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_facade_parent_class = g_type_class_peek_parent (klass);
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_type_class_add_private (klass, sizeof (ConfigurationFacadePrivate));
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_auto_import_from_library = configuration_facade_real_get_auto_import_from_library;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_auto_import_from_library = configuration_facade_real_set_auto_import_from_library;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_bg_color_name = configuration_facade_real_get_bg_color_name;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_bg_color_name = configuration_facade_real_set_bg_color_name;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_commit_metadata_to_masters = configuration_facade_real_get_commit_metadata_to_masters;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_commit_metadata_to_masters = configuration_facade_real_set_commit_metadata_to_masters;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_desktop_background = configuration_facade_real_get_desktop_background;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_desktop_background = configuration_facade_real_set_desktop_background;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_screensaver = configuration_facade_real_get_screensaver;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_screensaver = configuration_facade_real_set_screensaver;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_directory_pattern = configuration_facade_real_get_directory_pattern;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_directory_pattern = configuration_facade_real_set_directory_pattern;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_directory_pattern_custom = configuration_facade_real_get_directory_pattern_custom;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_directory_pattern_custom = configuration_facade_real_set_directory_pattern_custom;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_direct_window_state = configuration_facade_real_get_direct_window_state;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_direct_window_state = configuration_facade_real_set_direct_window_state;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_basic_properties = configuration_facade_real_get_display_basic_properties;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_basic_properties = configuration_facade_real_set_display_basic_properties;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_extended_properties = configuration_facade_real_get_display_extended_properties;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_extended_properties = configuration_facade_real_set_display_extended_properties;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_sidebar = configuration_facade_real_get_display_sidebar;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_sidebar = configuration_facade_real_set_display_sidebar;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_search_bar = configuration_facade_real_get_display_search_bar;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_search_bar = configuration_facade_real_set_display_search_bar;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_photo_ratings = configuration_facade_real_get_display_photo_ratings;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_photo_ratings = configuration_facade_real_set_display_photo_ratings;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_photo_tags = configuration_facade_real_get_display_photo_tags;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_photo_tags = configuration_facade_real_set_display_photo_tags;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_photo_titles = configuration_facade_real_get_display_photo_titles;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_photo_titles = configuration_facade_real_set_display_photo_titles;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_photo_comments = configuration_facade_real_get_display_photo_comments;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_photo_comments = configuration_facade_real_set_display_photo_comments;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_event_comments = configuration_facade_real_get_display_event_comments;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_event_comments = configuration_facade_real_set_display_event_comments;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_event_photos_sort = configuration_facade_real_get_event_photos_sort;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_event_photos_sort = configuration_facade_real_set_event_photos_sort;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_events_sort_ascending = configuration_facade_real_get_events_sort_ascending;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_events_sort_ascending = configuration_facade_real_set_events_sort_ascending;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_external_photo_app = configuration_facade_real_get_external_photo_app;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_external_photo_app = configuration_facade_real_set_external_photo_app;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_external_raw_app = configuration_facade_real_get_external_raw_app;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_external_raw_app = configuration_facade_real_set_external_raw_app;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_default_raw_developer = configuration_facade_real_get_default_raw_developer;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_default_raw_developer = configuration_facade_real_set_default_raw_developer;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_hide_photos_already_imported = configuration_facade_real_get_hide_photos_already_imported;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_hide_photos_already_imported = configuration_facade_real_set_hide_photos_already_imported;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_import_dir = configuration_facade_real_get_import_dir;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_import_dir = configuration_facade_real_set_import_dir;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_keep_relativity = configuration_facade_real_get_keep_relativity;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_keep_relativity = configuration_facade_real_set_keep_relativity;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_pin_toolbar_state = configuration_facade_real_get_pin_toolbar_state;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_pin_toolbar_state = configuration_facade_real_set_pin_toolbar_state;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_last_crop_height = configuration_facade_real_get_last_crop_height;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_last_crop_height = configuration_facade_real_set_last_crop_height;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_last_crop_menu_choice = configuration_facade_real_get_last_crop_menu_choice;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_last_crop_menu_choice = configuration_facade_real_set_last_crop_menu_choice;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_last_crop_width = configuration_facade_real_get_last_crop_width;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_last_crop_width = configuration_facade_real_set_last_crop_width;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_last_used_service = configuration_facade_real_get_last_used_service;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_last_used_service = configuration_facade_real_set_last_used_service;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_last_used_dataimports_service = configuration_facade_real_get_last_used_dataimports_service;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_last_used_dataimports_service = configuration_facade_real_set_last_used_dataimports_service;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_library_photos_sort = configuration_facade_real_get_library_photos_sort;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_library_photos_sort = configuration_facade_real_set_library_photos_sort;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_library_window_state = configuration_facade_real_get_library_window_state;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_library_window_state = configuration_facade_real_set_library_window_state;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_modify_originals = configuration_facade_real_get_modify_originals;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_modify_originals = configuration_facade_real_set_modify_originals;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_photo_thumbnail_scale = configuration_facade_real_get_photo_thumbnail_scale;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_photo_thumbnail_scale = configuration_facade_real_set_photo_thumbnail_scale;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_content_height = configuration_facade_real_get_printing_content_height;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_content_height = configuration_facade_real_set_printing_content_height;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_content_layout = configuration_facade_real_get_printing_content_layout;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_content_layout = configuration_facade_real_set_printing_content_layout;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_content_ppi = configuration_facade_real_get_printing_content_ppi;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_content_ppi = configuration_facade_real_set_printing_content_ppi;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_content_units = configuration_facade_real_get_printing_content_units;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_content_units = configuration_facade_real_set_printing_content_units;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_content_width = configuration_facade_real_get_printing_content_width;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_content_width = configuration_facade_real_set_printing_content_width;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_images_per_page = configuration_facade_real_get_printing_images_per_page;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_images_per_page = configuration_facade_real_set_printing_images_per_page;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_match_aspect_ratio = configuration_facade_real_get_printing_match_aspect_ratio;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_match_aspect_ratio = configuration_facade_real_set_printing_match_aspect_ratio;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_print_titles = configuration_facade_real_get_printing_print_titles;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_print_titles = configuration_facade_real_set_printing_print_titles;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_size_selection = configuration_facade_real_get_printing_size_selection;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_size_selection = configuration_facade_real_set_printing_size_selection;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_titles_font = configuration_facade_real_get_printing_titles_font;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_titles_font = configuration_facade_real_set_printing_titles_font;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_show_welcome_dialog = configuration_facade_real_get_show_welcome_dialog;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_show_welcome_dialog = configuration_facade_real_set_show_welcome_dialog;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_sidebar_position = configuration_facade_real_get_sidebar_position;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_sidebar_position = configuration_facade_real_set_sidebar_position;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_slideshow_delay = configuration_facade_real_get_slideshow_delay;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_slideshow_delay = configuration_facade_real_set_slideshow_delay;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_slideshow_transition_delay = configuration_facade_real_get_slideshow_transition_delay;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_slideshow_transition_delay = configuration_facade_real_set_slideshow_transition_delay;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_slideshow_transition_effect_id = configuration_facade_real_get_slideshow_transition_effect_id;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_slideshow_transition_effect_id = configuration_facade_real_set_slideshow_transition_effect_id;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_slideshow_show_title = configuration_facade_real_get_slideshow_show_title;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_slideshow_show_title = configuration_facade_real_set_slideshow_show_title;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_use_24_hour_time = configuration_facade_real_get_use_24_hour_time;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_use_24_hour_time = configuration_facade_real_set_use_24_hour_time;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_use_lowercase_filenames = configuration_facade_real_get_use_lowercase_filenames;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_use_lowercase_filenames = configuration_facade_real_set_use_lowercase_filenames;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_video_interpreter_state_cookie = configuration_facade_real_get_video_interpreter_state_cookie;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_video_interpreter_state_cookie = configuration_facade_real_set_video_interpreter_state_cookie;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_plugin_bool = configuration_facade_real_get_plugin_bool;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_plugin_bool = configuration_facade_real_set_plugin_bool;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_plugin_double = configuration_facade_real_get_plugin_double;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_plugin_double = configuration_facade_real_set_plugin_double;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_plugin_int = configuration_facade_real_get_plugin_int;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_plugin_int = configuration_facade_real_set_plugin_int;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_plugin_string = configuration_facade_real_get_plugin_string;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_plugin_string = configuration_facade_real_set_plugin_string;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->unset_plugin_key = configuration_facade_real_unset_plugin_key;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->is_plugin_enabled = configuration_facade_real_is_plugin_enabled;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_plugin_enabled = configuration_facade_real_set_plugin_enabled;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	G_OBJECT_CLASS (klass)->finalize = configuration_facade_finalize;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_signal_new ("auto_import_from_library_changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_signal_new ("bg_color_name_changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_signal_new ("commit_metadata_to_masters_changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_signal_new ("events_sort_ascending_changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_signal_new ("external_app_changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_signal_new ("import_directory_changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 11805 "ConfigurationInterfaces.c"
}


static void configuration_facade_instance_init (ConfigurationFacade * self) {
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	self->priv = CONFIGURATION_FACADE_GET_PRIVATE (self);
#line 11812 "ConfigurationInterfaces.c"
}


static void configuration_facade_finalize (GObject* obj) {
	ConfigurationFacade * self;
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONFIGURATION_FACADE, ConfigurationFacade);
#line 315 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (self->priv->engine);
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	G_OBJECT_CLASS (configuration_facade_parent_class)->finalize (obj);
#line 11824 "ConfigurationInterfaces.c"
}


GType configuration_facade_get_type (void) {
	static volatile gsize configuration_facade_type_id__volatile = 0;
	if (g_once_init_enter (&configuration_facade_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ConfigurationFacadeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) configuration_facade_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConfigurationFacade), 0, (GInstanceInitFunc) configuration_facade_instance_init, NULL };
		GType configuration_facade_type_id;
		configuration_facade_type_id = g_type_register_static (G_TYPE_OBJECT, "ConfigurationFacade", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&configuration_facade_type_id__volatile, configuration_facade_type_id);
	}
	return configuration_facade_type_id__volatile;
}



