/* PhotoTable.c generated by valac 0.32.1, the Vala compiler
 * generated from PhotoTable.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <gee.h>
#include <sqlite3.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PHOTO_ID (photo_id_get_type ())
typedef struct _PhotoID PhotoID;

#define TYPE_IMPORT_ID (import_id_get_type ())
typedef struct _ImportID ImportID;

#define TYPE_PHOTO_ROW (photo_row_get_type ())
#define PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_ROW, PhotoRow))
#define PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_ROW, PhotoRowClass))
#define IS_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_ROW))
#define IS_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_ROW))
#define PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_ROW, PhotoRowClass))

typedef struct _PhotoRow PhotoRow;
typedef struct _PhotoRowClass PhotoRowClass;
typedef struct _PhotoRowPrivate PhotoRowPrivate;

#define TYPE_BACKING_PHOTO_ROW (backing_photo_row_get_type ())
#define BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRow))
#define BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))
#define IS_BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_ROW))
#define IS_BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_ROW))
#define BACKING_PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))

typedef struct _BackingPhotoRow BackingPhotoRow;
typedef struct _BackingPhotoRowClass BackingPhotoRowClass;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;

#define TYPE_ORIENTATION (orientation_get_type ())

#define TYPE_KEY_VALUE_MAP (key_value_map_get_type ())
#define KEY_VALUE_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY_VALUE_MAP, KeyValueMap))
#define KEY_VALUE_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY_VALUE_MAP, KeyValueMapClass))
#define IS_KEY_VALUE_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY_VALUE_MAP))
#define IS_KEY_VALUE_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY_VALUE_MAP))
#define KEY_VALUE_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY_VALUE_MAP, KeyValueMapClass))

typedef struct _KeyValueMap KeyValueMap;
typedef struct _KeyValueMapClass KeyValueMapClass;

#define TYPE_RATING (rating_get_type ())

#define TYPE_BACKING_PHOTO_ID (backing_photo_id_get_type ())
typedef struct _BackingPhotoID BackingPhotoID;

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())
#define _backing_photo_row_unref0(var) ((var == NULL) ? NULL : (var = (backing_photo_row_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecPhotoRow ParamSpecPhotoRow;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;

#define TYPE_PHOTO_TABLE (photo_table_get_type ())
#define PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_TABLE, PhotoTable))
#define PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_TABLE, PhotoTableClass))
#define IS_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_TABLE))
#define IS_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_TABLE))
#define PHOTO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_TABLE, PhotoTableClass))

typedef struct _PhotoTable PhotoTable;
typedef struct _PhotoTableClass PhotoTableClass;
typedef struct _PhotoTablePrivate PhotoTablePrivate;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
typedef struct _BackingPhotoRowPrivate BackingPhotoRowPrivate;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
#define _photo_row_unref0(var) ((var == NULL) ? NULL : (var = (photo_row_unref (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _key_value_map_unref0(var) ((var == NULL) ? NULL : (var = (key_value_map_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecBackingPhotoRow ParamSpecBackingPhotoRow;

#define TYPE_BACKING_PHOTO_TABLE (backing_photo_table_get_type ())
#define BACKING_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_TABLE, BackingPhotoTable))
#define BACKING_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_TABLE, BackingPhotoTableClass))
#define IS_BACKING_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_TABLE))
#define IS_BACKING_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_TABLE))
#define BACKING_PHOTO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_TABLE, BackingPhotoTableClass))

typedef struct _BackingPhotoTable BackingPhotoTable;
typedef struct _BackingPhotoTableClass BackingPhotoTableClass;
typedef struct _BackingPhotoTablePrivate BackingPhotoTablePrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PhotoID {
	gint64 id;
};

struct _ImportID {
	gint64 id;
};

struct _EventID {
	gint64 id;
};

typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

struct _BackingPhotoID {
	gint64 id;
};

typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

struct _PhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoRowPrivate * priv;
	PhotoID photo_id;
	BackingPhotoRow* master;
	time_t exposure_time;
	ImportID import_id;
	EventID event_id;
	Orientation orientation;
	GeeHashMap* transformations;
	gchar* md5;
	gchar* thumbnail_md5;
	gchar* exif_md5;
	time_t time_created;
	guint64 flags;
	Rating rating;
	gchar* title;
	gchar* comment;
	gchar* backlinks;
	time_t time_reimported;
	BackingPhotoID editable_id;
	gboolean metadata_dirty;
	RawDeveloper developer;
	BackingPhotoID* development_ids;
	gint development_ids_length1;
};

struct _PhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoRow *self);
};

struct _ParamSpecPhotoRow {
	GParamSpec parent_instance;
};

struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _PhotoTable {
	DatabaseTable parent_instance;
	PhotoTablePrivate * priv;
};

struct _PhotoTableClass {
	DatabaseTableClass parent_class;
};

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

struct _Dimensions {
	gint width;
	gint height;
};

struct _BackingPhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackingPhotoRowPrivate * priv;
	BackingPhotoID id;
	time_t time_created;
	gchar* filepath;
	gint64 filesize;
	time_t timestamp;
	PhotoFileFormat file_format;
	Dimensions dim;
	Orientation original_orientation;
};

struct _BackingPhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (BackingPhotoRow *self);
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()
struct _ParamSpecBackingPhotoRow {
	GParamSpec parent_instance;
};

struct _BackingPhotoTable {
	DatabaseTable parent_instance;
	BackingPhotoTablePrivate * priv;
};

struct _BackingPhotoTableClass {
	DatabaseTableClass parent_class;
};


static gpointer photo_row_parent_class = NULL;
static gpointer photo_table_parent_class = NULL;
static PhotoTable* photo_table_instance;
static PhotoTable* photo_table_instance = NULL;
extern sqlite3* database_table_db;
static gpointer backing_photo_row_parent_class = NULL;
static gpointer backing_photo_table_parent_class = NULL;
static BackingPhotoTable* backing_photo_table_instance;
static BackingPhotoTable* backing_photo_table_instance = NULL;

GType photo_id_get_type (void) G_GNUC_CONST;
PhotoID* photo_id_dup (const PhotoID* self);
void photo_id_free (PhotoID* self);
#define PHOTO_ID_INVALID ((gint64) -1)
void photo_id_init (PhotoID *self, gint64 id);
gboolean photo_id_is_invalid (PhotoID *self);
gboolean photo_id_is_valid (PhotoID *self);
guint photo_id_hash (PhotoID *self);
guint int64_hash (gint64* n);
gboolean photo_id_equal (void* a, void* b);
gchar* photo_id_upgrade_photo_id_to_source_id (PhotoID* photo_id);
#define PHOTO_TYPENAME "thumb"
GType import_id_get_type (void) G_GNUC_CONST;
ImportID* import_id_dup (const ImportID* self);
void import_id_free (ImportID* self);
#define IMPORT_ID_INVALID ((gint64) 0)
void import_id_init (ImportID *self, gint64 id);
void import_id_generate (ImportID* result);
gboolean import_id_is_invalid (ImportID *self);
gboolean import_id_is_valid (ImportID *self);
gint import_id_compare_func (ImportID* a, ImportID* b);
gint64 import_id_comparator (void* a, void* b);
gpointer photo_row_ref (gpointer instance);
void photo_row_unref (gpointer instance);
GParamSpec* param_spec_photo_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_row (GValue* value, gpointer v_object);
void value_take_photo_row (GValue* value, gpointer v_object);
gpointer value_get_photo_row (const GValue* value);
GType photo_row_get_type (void) G_GNUC_CONST;
gpointer backing_photo_row_ref (gpointer instance);
void backing_photo_row_unref (gpointer instance);
GParamSpec* param_spec_backing_photo_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_backing_photo_row (GValue* value, gpointer v_object);
void value_take_backing_photo_row (GValue* value, gpointer v_object);
gpointer value_get_backing_photo_row (const GValue* value);
GType backing_photo_row_get_type (void) G_GNUC_CONST;
GType event_id_get_type (void) G_GNUC_CONST;
EventID* event_id_dup (const EventID* self);
void event_id_free (EventID* self);
GType orientation_get_type (void) G_GNUC_CONST;
gpointer key_value_map_ref (gpointer instance);
void key_value_map_unref (gpointer instance);
GParamSpec* param_spec_key_value_map (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_key_value_map (GValue* value, gpointer v_object);
void value_take_key_value_map (GValue* value, gpointer v_object);
gpointer value_get_key_value_map (const GValue* value);
GType key_value_map_get_type (void) G_GNUC_CONST;
GType rating_get_type (void) G_GNUC_CONST;
GType backing_photo_id_get_type (void) G_GNUC_CONST;
BackingPhotoID* backing_photo_id_dup (const BackingPhotoID* self);
void backing_photo_id_free (BackingPhotoID* self);
GType raw_developer_get_type (void) G_GNUC_CONST;
enum  {
	PHOTO_ROW_DUMMY_PROPERTY
};
PhotoRow* photo_row_new (void);
PhotoRow* photo_row_construct (GType object_type);
BackingPhotoRow* backing_photo_row_new (void);
BackingPhotoRow* backing_photo_row_construct (GType object_type);
#define BACKING_PHOTO_ID_INVALID ((gint64) -1)
void backing_photo_id_init (BackingPhotoID *self, gint64 id);
RawDeveloper* raw_developer_as_array (int* result_length1);
static void photo_row_finalize (PhotoRow* obj);
gpointer database_table_ref (gpointer instance);
void database_table_unref (gpointer instance);
GParamSpec* param_spec_database_table (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_database_table (GValue* value, gpointer v_object);
void value_take_database_table (GValue* value, gpointer v_object);
gpointer value_get_database_table (const GValue* value);
GType database_table_get_type (void) G_GNUC_CONST;
GType photo_table_get_type (void) G_GNUC_CONST;
enum  {
	PHOTO_TABLE_DUMMY_PROPERTY
};
static PhotoTable* photo_table_new (void);
static PhotoTable* photo_table_construct (GType object_type);
DatabaseTable* database_table_construct (GType object_type);
void database_table_fatal (const gchar* op, gint res);
void database_table_warning (const gchar* op, gint res);
void database_table_set_table_name (DatabaseTable* self, const gchar* table_name);
PhotoTable* photo_table_get_instance (void);
void photo_table_add (PhotoTable* self, PhotoRow* photo_row, PhotoID* result);
gulong now_sec (void);
GType photo_file_format_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
#define EVENT_ID_INVALID ((gint64) -1)
gint photo_file_format_serialize (PhotoFileFormat self);
gint rating_serialize (Rating self);
gchar* raw_developer_to_string (RawDeveloper self);
void event_id_init (EventID *self, gint64 id);
GQuark database_error_quark (void);
void photo_table_reimport (PhotoTable* self, PhotoRow* row, GError** error);
void database_table_throw_error (const gchar* method, gint res, GError** error);
gboolean photo_table_master_exif_updated (PhotoTable* self, PhotoID* photoID, gint64 filesize, glong timestamp, const gchar* md5, const gchar* exif_md5, const gchar* thumbnail_md5, PhotoRow* row);
static void photo_table_validate_orientation (PhotoTable* self, PhotoRow* row);
gboolean photo_table_set_orientation (PhotoTable* self, PhotoID* photo_id, Orientation orientation);
PhotoRow* photo_table_get_row (PhotoTable* self, PhotoID* photo_id);
void dimensions_init (Dimensions *self, gint width, gint height);
GeeHashMap* photo_table_marshall_all_transformations (const gchar* trans);
Rating rating_unserialize (gint value);
PhotoFileFormat photo_file_format_unserialize (gint value);
RawDeveloper raw_developer_from_string (const gchar* value);
GeeArrayList* photo_table_get_all (PhotoTable* self);
void photo_table_duplicate (PhotoTable* self, PhotoID* photo_id, const gchar* new_filename, BackingPhotoID* editable_id, BackingPhotoID* develop_shotwell, BackingPhotoID* develop_camera_id, BackingPhotoID* develop_embedded_id, PhotoID* result);
gchar* photo_table_unmarshall_all_transformations (GeeHashMap* transformations);
gboolean photo_table_set_title (PhotoTable* self, PhotoID* photo_id, const gchar* new_title);
gboolean database_table_update_text_by_id (DatabaseTable* self, gint64 id, const gchar* column, const gchar* text);
gboolean photo_table_set_comment (PhotoTable* self, PhotoID* photo_id, const gchar* new_comment);
void photo_table_set_filepath (PhotoTable* self, PhotoID* photo_id, const gchar* filepath, GError** error);
void database_table_update_text_by_id_2 (DatabaseTable* self, gint64 id, const gchar* column, const gchar* text, GError** error);
void photo_table_update_timestamp (PhotoTable* self, PhotoID* photo_id, time_t timestamp, GError** error);
void database_table_update_int64_by_id_2 (DatabaseTable* self, gint64 id, const gchar* column, gint64 value, GError** error);
gboolean photo_table_set_exposure_time (PhotoTable* self, PhotoID* photo_id, time_t time);
gboolean database_table_update_int64_by_id (DatabaseTable* self, gint64 id, const gchar* column, gint64 value);
void photo_table_set_import_id (PhotoTable* self, PhotoID* photo_id, ImportID* import_id, GError** error);
gboolean photo_table_remove_by_file (PhotoTable* self, GFile* file);
void photo_table_remove (PhotoTable* self, PhotoID* photo_id, GError** error);
void database_table_delete_by_id (DatabaseTable* self, gint64 id, GError** error);
GeeArrayList* photo_table_get_photos (PhotoTable* self);
gboolean database_table_update_int_by_id (DatabaseTable* self, gint64 id, const gchar* column, gint value);
gboolean photo_table_replace_flags (PhotoTable* self, PhotoID* photo_id, guint64 flags);
gboolean photo_table_set_rating (PhotoTable* self, PhotoID* photo_id, Rating rating);
gint photo_table_get_event_photo_count (PhotoTable* self, EventID* event_id);
GeeArrayList* photo_table_get_event_source_ids (PhotoTable* self, EventID* event_id);
gboolean photo_table_event_has_photos (PhotoTable* self, EventID* event_id);
gboolean photo_table_drop_event (PhotoTable* self, EventID* event_id);
gboolean photo_table_set_event (PhotoTable* self, PhotoID* photo_id, EventID* event_id);
static gchar* photo_table_get_raw_transformations (PhotoTable* self, PhotoID* photo_id);
gboolean database_table_select_by_id (DatabaseTable* self, gint64 id, const gchar* columns, sqlite3_stmt** stmt);
static gboolean photo_table_set_raw_transformations (PhotoTable* self, PhotoID* photo_id, const gchar* trans);
gboolean photo_table_set_transformation_state (PhotoTable* self, PhotoID* photo_id, Orientation orientation, GeeHashMap* transformations);
KeyValueMap* key_value_map_new (const gchar* group);
KeyValueMap* key_value_map_construct (GType object_type, const gchar* group);
void key_value_map_set_string (KeyValueMap* self, const gchar* key, const gchar* value);
GeeSet* key_value_map_get_keys (KeyValueMap* self);
gchar* key_value_map_get_string (KeyValueMap* self, const gchar* key, const gchar* def);
gboolean photo_table_set_transformation (PhotoTable* self, PhotoID* photo_id, KeyValueMap* map);
gchar* key_value_map_get_group (KeyValueMap* self);
gboolean photo_table_remove_transformation (PhotoTable* self, PhotoID* photo_id, const gchar* object);
gboolean photo_table_remove_all_transformations (PhotoTable* self, PhotoID* photo_id);
static sqlite3_stmt* photo_table_get_duplicate_stmt (PhotoTable* self, GFile* file, const gchar* thumbnail_md5, const gchar* md5, PhotoFileFormat file_format);
gboolean photo_table_has_duplicate (PhotoTable* self, GFile* file, const gchar* thumbnail_md5, const gchar* md5, PhotoFileFormat file_format);
PhotoID* photo_table_get_duplicate_ids (PhotoTable* self, GFile* file, const gchar* thumbnail_md5, const gchar* md5, PhotoFileFormat file_format, int* result_length1);
static void _vala_array_add2 (PhotoID** array, int* length, int* size, const PhotoID* value);
void photo_table_update_backlinks (PhotoTable* self, PhotoID* photo_id, const gchar* backlinks, GError** error);
void photo_table_attach_editable (PhotoTable* self, PhotoRow* row, BackingPhotoID* editable_id, GError** error);
void photo_table_detach_editable (PhotoTable* self, PhotoRow* row, GError** error);
void photo_table_set_metadata_dirty (PhotoTable* self, PhotoID* photo_id, gboolean dirty, GError** error);
void database_table_update_int_by_id_2 (DatabaseTable* self, gint64 id, const gchar* column, gint value, GError** error);
void photo_table_update_raw_development (PhotoTable* self, PhotoRow* row, RawDeveloper rd, BackingPhotoID* backing_photo_id, GError** error);
void photo_table_remove_development (PhotoTable* self, PhotoRow* row, RawDeveloper rd, GError** error);
static void photo_table_finalize (DatabaseTable* obj);
gboolean backing_photo_id_is_invalid (BackingPhotoID *self);
gboolean backing_photo_id_is_valid (BackingPhotoID *self);
enum  {
	BACKING_PHOTO_ROW_DUMMY_PROPERTY
};
gboolean backing_photo_row_matches_file_info (BackingPhotoRow* self, GFileInfo* info);
gboolean backing_photo_row_is_touched (BackingPhotoRow* self, GFileInfo* info);
void backing_photo_row_copy_from (BackingPhotoRow* self, BackingPhotoRow* from);
static void backing_photo_row_finalize (BackingPhotoRow* obj);
GType backing_photo_table_get_type (void) G_GNUC_CONST;
enum  {
	BACKING_PHOTO_TABLE_DUMMY_PROPERTY
};
static BackingPhotoTable* backing_photo_table_new (void);
static BackingPhotoTable* backing_photo_table_construct (GType object_type);
BackingPhotoTable* backing_photo_table_get_instance (void);
void backing_photo_table_add (BackingPhotoTable* self, BackingPhotoRow* state, GError** error);
BackingPhotoRow* backing_photo_table_fetch (BackingPhotoTable* self, BackingPhotoID* id, GError** error);
void backing_photo_table_update (BackingPhotoTable* self, BackingPhotoRow* row, GError** error);
void backing_photo_table_update_attributes (BackingPhotoTable* self, BackingPhotoID* id, time_t timestamp, gint64 filesize, GError** error);
void backing_photo_table_remove (BackingPhotoTable* self, BackingPhotoID* backing_id, GError** error);
void backing_photo_table_set_filepath (BackingPhotoTable* self, BackingPhotoID* id, const gchar* filepath, GError** error);
void backing_photo_table_update_timestamp (BackingPhotoTable* self, BackingPhotoID* id, time_t timestamp, GError** error);
static void backing_photo_table_finalize (DatabaseTable* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


void photo_id_init (PhotoID *self, gint64 id) {
	gint64 _tmp0_ = 0LL;
#line 12 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	memset (self, 0, sizeof (PhotoID));
#line 13 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = id;
#line 13 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	(*self).id = _tmp0_;
#line 484 "PhotoTable.c"
}


gboolean photo_id_is_invalid (PhotoID *self) {
	gboolean result = FALSE;
	gint64 _tmp0_ = 0LL;
#line 17 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = (*self).id;
#line 17 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp0_ == PHOTO_ID_INVALID;
#line 17 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 497 "PhotoTable.c"
}


gboolean photo_id_is_valid (PhotoID *self) {
	gboolean result = FALSE;
	gint64 _tmp0_ = 0LL;
#line 21 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = (*self).id;
#line 21 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp0_ != PHOTO_ID_INVALID;
#line 21 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 510 "PhotoTable.c"
}


guint photo_id_hash (PhotoID *self) {
	guint result = 0U;
	gint64 _tmp0_ = 0LL;
	guint _tmp1_ = 0U;
#line 25 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = (*self).id;
#line 25 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = int64_hash (&_tmp0_);
#line 25 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp1_;
#line 25 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 526 "PhotoTable.c"
}


gboolean photo_id_equal (void* a, void* b) {
	gboolean result = FALSE;
	void* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	void* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
#line 29 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = a;
#line 29 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = (*((PhotoID*) _tmp0_)).id;
#line 29 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = b;
#line 29 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = (*((PhotoID*) _tmp2_)).id;
#line 29 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp1_ == _tmp3_;
#line 29 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 548 "PhotoTable.c"
}


gchar* photo_id_upgrade_photo_id_to_source_id (PhotoID* photo_id) {
	gchar* result = NULL;
	PhotoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	gchar* _tmp2_ = NULL;
#line 32 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, NULL);
#line 33 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 33 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 33 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = g_strdup_printf ("%s%016" G_GINT64_MODIFIER "x", PHOTO_TYPENAME, _tmp1_);
#line 33 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp2_;
#line 33 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 569 "PhotoTable.c"
}


PhotoID* photo_id_dup (const PhotoID* self) {
	PhotoID* dup;
#line 7 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	dup = g_new0 (PhotoID, 1);
#line 7 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	memcpy (dup, self, sizeof (PhotoID));
#line 7 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return dup;
#line 581 "PhotoTable.c"
}


void photo_id_free (PhotoID* self) {
#line 7 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_free (self);
#line 588 "PhotoTable.c"
}


GType photo_id_get_type (void) {
	static volatile gsize photo_id_type_id__volatile = 0;
	if (g_once_init_enter (&photo_id_type_id__volatile)) {
		GType photo_id_type_id;
		photo_id_type_id = g_boxed_type_register_static ("PhotoID", (GBoxedCopyFunc) photo_id_dup, (GBoxedFreeFunc) photo_id_free);
		g_once_init_leave (&photo_id_type_id__volatile, photo_id_type_id);
	}
	return photo_id_type_id__volatile;
}


void import_id_init (ImportID *self, gint64 id) {
	gint64 _tmp0_ = 0LL;
#line 42 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	memset (self, 0, sizeof (ImportID));
#line 43 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = id;
#line 43 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	(*self).id = _tmp0_;
#line 611 "PhotoTable.c"
}


void import_id_generate (ImportID* result) {
	GTimeVal timestamp = {0};
	gint64 id = 0LL;
	GTimeVal _tmp0_ = {0};
	glong _tmp1_ = 0L;
	ImportID _tmp2_ = {0};
#line 47 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_get_current_time (&timestamp);
#line 48 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_get_current_time (&timestamp);
#line 49 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = timestamp;
#line 49 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.tv_sec;
#line 49 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	id = (gint64) _tmp1_;
#line 51 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	import_id_init (&_tmp2_, id);
#line 51 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	*result = _tmp2_;
#line 51 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return;
#line 637 "PhotoTable.c"
}


gboolean import_id_is_invalid (ImportID *self) {
	gboolean result = FALSE;
	gint64 _tmp0_ = 0LL;
#line 55 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = (*self).id;
#line 55 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp0_ == IMPORT_ID_INVALID;
#line 55 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 650 "PhotoTable.c"
}


gboolean import_id_is_valid (ImportID *self) {
	gboolean result = FALSE;
	gint64 _tmp0_ = 0LL;
#line 59 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = (*self).id;
#line 59 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp0_ != IMPORT_ID_INVALID;
#line 59 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 663 "PhotoTable.c"
}


gint import_id_compare_func (ImportID* a, ImportID* b) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ImportID* _tmp1_ = NULL;
	ImportID* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	ImportID* _tmp5_ = NULL;
	gint64 _tmp6_ = 0LL;
#line 63 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = a;
#line 63 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp1_ != NULL) {
#line 679 "PhotoTable.c"
		ImportID* _tmp2_ = NULL;
#line 63 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp2_ = b;
#line 63 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 685 "PhotoTable.c"
	} else {
#line 63 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = FALSE;
#line 689 "PhotoTable.c"
	}
#line 63 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp0_, "a != null && b != null");
#line 64 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = a;
#line 64 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = (*_tmp3_).id;
#line 64 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = b;
#line 64 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = (*_tmp5_).id;
#line 64 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = (gint) (_tmp4_ - _tmp6_);
#line 64 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 705 "PhotoTable.c"
}


gint64 import_id_comparator (void* a, void* b) {
	gint64 result = 0LL;
	void* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	void* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
#line 68 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = a;
#line 68 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = (*((ImportID*) _tmp0_)).id;
#line 68 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = b;
#line 68 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = (*((ImportID*) _tmp2_)).id;
#line 68 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp1_ - _tmp3_;
#line 68 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 727 "PhotoTable.c"
}


ImportID* import_id_dup (const ImportID* self) {
	ImportID* dup;
#line 37 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	dup = g_new0 (ImportID, 1);
#line 37 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	memcpy (dup, self, sizeof (ImportID));
#line 37 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return dup;
#line 739 "PhotoTable.c"
}


void import_id_free (ImportID* self) {
#line 37 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_free (self);
#line 746 "PhotoTable.c"
}


GType import_id_get_type (void) {
	static volatile gsize import_id_type_id__volatile = 0;
	if (g_once_init_enter (&import_id_type_id__volatile)) {
		GType import_id_type_id;
		import_id_type_id = g_boxed_type_register_static ("ImportID", (GBoxedCopyFunc) import_id_dup, (GBoxedFreeFunc) import_id_free);
		g_once_init_leave (&import_id_type_id__volatile, import_id_type_id);
	}
	return import_id_type_id__volatile;
}


PhotoRow* photo_row_construct (GType object_type) {
	PhotoRow* self = NULL;
	BackingPhotoRow* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	RawDeveloper* _tmp2_ = NULL;
	RawDeveloper* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	BackingPhotoID* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	RawDeveloper* _tmp6_ = NULL;
#line 100 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self = (PhotoRow*) g_type_create_instance (object_type);
#line 101 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = backing_photo_row_new ();
#line 101 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_backing_photo_row_unref0 (self->master);
#line 101 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->master = _tmp0_;
#line 102 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	backing_photo_id_init (&self->editable_id, BACKING_PHOTO_ID_INVALID);
#line 103 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = raw_developer_as_array (&_tmp1_);
#line 103 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = _tmp2_;
#line 103 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3__length1 = _tmp1_;
#line 103 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = g_new0 (BackingPhotoID, _tmp1_);
#line 103 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->development_ids = (g_free (self->development_ids), NULL);
#line 103 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->development_ids = _tmp4_;
#line 103 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->development_ids_length1 = _tmp1_;
#line 103 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = (g_free (_tmp3_), NULL);
#line 104 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = raw_developer_as_array (&_tmp5_);
#line 799 "PhotoTable.c"
	{
		RawDeveloper* d_collection = NULL;
		gint d_collection_length1 = 0;
		gint _d_collection_size_ = 0;
		gint d_it = 0;
#line 104 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		d_collection = _tmp6_;
#line 104 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		d_collection_length1 = _tmp5_;
#line 104 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		for (d_it = 0; d_it < _tmp5_; d_it = d_it + 1) {
#line 811 "PhotoTable.c"
			RawDeveloper d = 0;
#line 104 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			d = d_collection[d_it];
#line 815 "PhotoTable.c"
			{
				BackingPhotoID* _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				RawDeveloper _tmp8_ = 0;
				BackingPhotoID _tmp9_ = {0};
				BackingPhotoID _tmp10_ = {0};
#line 105 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp7_ = self->development_ids;
#line 105 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp7__length1 = self->development_ids_length1;
#line 105 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp8_ = d;
#line 105 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				backing_photo_id_init (&_tmp9_, BACKING_PHOTO_ID_INVALID);
#line 105 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp7_[_tmp8_] = _tmp9_;
#line 105 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp10_ = _tmp7_[_tmp8_];
#line 834 "PhotoTable.c"
			}
		}
#line 104 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		d_collection = (g_free (d_collection), NULL);
#line 839 "PhotoTable.c"
	}
#line 100 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return self;
#line 843 "PhotoTable.c"
}


PhotoRow* photo_row_new (void) {
#line 100 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return photo_row_construct (TYPE_PHOTO_ROW);
#line 850 "PhotoTable.c"
}


static void value_photo_row_init (GValue* value) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	value->data[0].v_pointer = NULL;
#line 857 "PhotoTable.c"
}


static void value_photo_row_free_value (GValue* value) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (value->data[0].v_pointer) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		photo_row_unref (value->data[0].v_pointer);
#line 866 "PhotoTable.c"
	}
}


static void value_photo_row_copy_value (const GValue* src_value, GValue* dest_value) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (src_value->data[0].v_pointer) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		dest_value->data[0].v_pointer = photo_row_ref (src_value->data[0].v_pointer);
#line 876 "PhotoTable.c"
	} else {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		dest_value->data[0].v_pointer = NULL;
#line 880 "PhotoTable.c"
	}
}


static gpointer value_photo_row_peek_pointer (const GValue* value) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return value->data[0].v_pointer;
#line 888 "PhotoTable.c"
}


static gchar* value_photo_row_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (collect_values[0].v_pointer) {
#line 895 "PhotoTable.c"
		PhotoRow* object;
		object = collect_values[0].v_pointer;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (object->parent_instance.g_class == NULL) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 902 "PhotoTable.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 906 "PhotoTable.c"
		}
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = photo_row_ref (object);
#line 910 "PhotoTable.c"
	} else {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = NULL;
#line 914 "PhotoTable.c"
	}
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return NULL;
#line 918 "PhotoTable.c"
}


static gchar* value_photo_row_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PhotoRow** object_p;
	object_p = collect_values[0].v_pointer;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (!object_p) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 929 "PhotoTable.c"
	}
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (!value->data[0].v_pointer) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		*object_p = NULL;
#line 935 "PhotoTable.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		*object_p = value->data[0].v_pointer;
#line 939 "PhotoTable.c"
	} else {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		*object_p = photo_row_ref (value->data[0].v_pointer);
#line 943 "PhotoTable.c"
	}
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return NULL;
#line 947 "PhotoTable.c"
}


GParamSpec* param_spec_photo_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPhotoRow* spec;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_ROW), NULL);
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return G_PARAM_SPEC (spec);
#line 961 "PhotoTable.c"
}


gpointer value_get_photo_row (const GValue* value) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_ROW), NULL);
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return value->data[0].v_pointer;
#line 970 "PhotoTable.c"
}


void value_set_photo_row (GValue* value, gpointer v_object) {
	PhotoRow* old;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_ROW));
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	old = value->data[0].v_pointer;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (v_object) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_ROW));
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = v_object;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		photo_row_ref (value->data[0].v_pointer);
#line 990 "PhotoTable.c"
	} else {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = NULL;
#line 994 "PhotoTable.c"
	}
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (old) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		photo_row_unref (old);
#line 1000 "PhotoTable.c"
	}
}


void value_take_photo_row (GValue* value, gpointer v_object) {
	PhotoRow* old;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_ROW));
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	old = value->data[0].v_pointer;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (v_object) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_ROW));
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = v_object;
#line 1019 "PhotoTable.c"
	} else {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = NULL;
#line 1023 "PhotoTable.c"
	}
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (old) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		photo_row_unref (old);
#line 1029 "PhotoTable.c"
	}
}


static void photo_row_class_init (PhotoRowClass * klass) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	photo_row_parent_class = g_type_class_peek_parent (klass);
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	((PhotoRowClass *) klass)->finalize = photo_row_finalize;
#line 1039 "PhotoTable.c"
}


static void photo_row_instance_init (PhotoRow * self) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->ref_count = 1;
#line 1046 "PhotoTable.c"
}


static void photo_row_finalize (PhotoRow* obj) {
	PhotoRow * self;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_ROW, PhotoRow);
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_signal_handlers_destroy (self);
#line 74 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_backing_photo_row_unref0 (self->master);
#line 79 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_object_unref0 (self->transformations);
#line 80 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (self->md5);
#line 81 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (self->thumbnail_md5);
#line 82 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (self->exif_md5);
#line 86 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (self->title);
#line 87 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (self->comment);
#line 88 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (self->backlinks);
#line 97 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->development_ids = (g_free (self->development_ids), NULL);
#line 1074 "PhotoTable.c"
}


GType photo_row_get_type (void) {
	static volatile gsize photo_row_type_id__volatile = 0;
	if (g_once_init_enter (&photo_row_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_photo_row_init, value_photo_row_free_value, value_photo_row_copy_value, value_photo_row_peek_pointer, "p", value_photo_row_collect_value, "p", value_photo_row_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PhotoRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoRow), 0, (GInstanceInitFunc) photo_row_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType photo_row_type_id;
		photo_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&photo_row_type_id__volatile, photo_row_type_id);
	}
	return photo_row_type_id__volatile;
}


gpointer photo_row_ref (gpointer instance) {
	PhotoRow* self;
	self = instance;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_atomic_int_inc (&self->ref_count);
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return instance;
#line 1099 "PhotoTable.c"
}


void photo_row_unref (gpointer instance) {
	PhotoRow* self;
	self = instance;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		PHOTO_ROW_GET_CLASS (self)->finalize (self);
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1112 "PhotoTable.c"
	}
}


static PhotoTable* photo_table_construct (GType object_type) {
	PhotoTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	sqlite3_stmt* stmt2 = NULL;
	gint res2 = 0;
	sqlite3* _tmp8_ = NULL;
	sqlite3_stmt* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	sqlite3_stmt* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	sqlite3* _tmp16_ = NULL;
	sqlite3_stmt* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	sqlite3_stmt* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	sqlite3* _tmp24_ = NULL;
	sqlite3_stmt* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	sqlite3_stmt* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	sqlite3* _tmp32_ = NULL;
	sqlite3_stmt* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	sqlite3_stmt* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
#line 112 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self = (PhotoTable*) database_table_construct (object_type);
#line 114 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 114 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "CREATE TABLE IF NOT EXISTS PhotoTable (" "id INTEGER PRIMARY KEY, " "filename TEXT UNIQUE NOT NULL, " "width INTEGER, " "height INTEGER, " "filesize INTEGER, " "timestamp INTEGER, " "exposure_time INTEGER, " "orientation INTEGER, " "original_orientation INTEGER, " "import_id INTEGER, " "event_id INTEGER, " "transformations TEXT, " "md5 TEXT, " "thumbnail_md5 TEXT, " "exif_md5 TEXT, " "time_created INTEGER, " "flags INTEGER DEFAULT 0, " "rating INTEGER DEFAULT 0, " "file_format INTEGER DEFAULT 0, " "title TEXT, " "backlinks TEXT, " "time_reimported INTEGER, " "editable_id INTEGER DEFAULT -1, " "metadata_dirty INTEGER DEFAULT 0, " "developer TEXT, " "develop_shotwell_id INTEGER DEFAULT -1, " "develop_camera_id INTEGER DEFAULT -1, " "develop_embedded_id INTEGER DEFAULT -1, " "comment TEXT" ")", -1, &_tmp1_, NULL);
#line 114 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 114 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 114 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 145 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 145 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 147 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 147 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = sqlite3_step (_tmp4_);
#line 147 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp5_;
#line 148 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = res;
#line 148 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp6_ != SQLITE_DONE) {
#line 1184 "PhotoTable.c"
		gint _tmp7_ = 0;
#line 149 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp7_ = res;
#line 149 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_fatal ("create photo table", _tmp7_);
#line 1190 "PhotoTable.c"
	}
#line 153 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = database_table_db;
#line 153 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = sqlite3_prepare_v2 (_tmp8_, "CREATE INDEX IF NOT EXISTS PhotoEventIDIndex ON PhotoTable (event_id)", -1, &_tmp9_, NULL);
#line 153 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt2);
#line 153 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt2 = _tmp9_;
#line 153 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res2 = _tmp10_;
#line 155 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = res2;
#line 155 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp11_ == SQLITE_OK, "res2 == Sqlite.OK");
#line 157 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = stmt2;
#line 157 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_ = sqlite3_step (_tmp12_);
#line 157 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res2 = _tmp13_;
#line 158 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = res2;
#line 158 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp14_ != SQLITE_DONE) {
#line 1216 "PhotoTable.c"
		gint _tmp15_ = 0;
#line 159 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp15_ = res2;
#line 159 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_fatal ("create photo table", _tmp15_);
#line 1222 "PhotoTable.c"
	}
#line 165 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp16_ = database_table_db;
#line 165 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp18_ = sqlite3_prepare_v2 (_tmp16_, "CREATE UNIQUE INDEX IF NOT EXISTS PhotoTableMD5Format on PhotoTable(md" \
"5, file_format)", -1, &_tmp17_, NULL);
#line 165 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 165 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp17_;
#line 165 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp18_;
#line 166 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp19_ = res;
#line 166 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp19_ == SQLITE_OK, "res == Sqlite.OK");
#line 167 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp20_ = stmt;
#line 167 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp21_ = sqlite3_step (_tmp20_);
#line 167 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp21_;
#line 168 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp22_ = res;
#line 168 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp22_ != SQLITE_DONE) {
#line 1248 "PhotoTable.c"
		gint _tmp23_ = 0;
#line 169 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp23_ = res;
#line 169 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_warning ("Failed to create index on md5 and file_format", _tmp23_);
#line 1254 "PhotoTable.c"
	}
#line 173 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp24_ = database_table_db;
#line 173 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp26_ = sqlite3_prepare_v2 (_tmp24_, "CREATE INDEX IF NOT EXISTS PhotoTableThumbnailMD5Format on PhotoTable(" \
"thumbnail_md5, file_format)", -1, &_tmp25_, NULL);
#line 173 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 173 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp25_;
#line 173 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp26_;
#line 174 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp27_ = res;
#line 174 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp27_ == SQLITE_OK, "res == Sqlite.OK");
#line 175 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp28_ = stmt;
#line 175 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp29_ = sqlite3_step (_tmp28_);
#line 175 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp29_;
#line 176 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp30_ = res;
#line 176 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp30_ != SQLITE_DONE) {
#line 1280 "PhotoTable.c"
		gint _tmp31_ = 0;
#line 177 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp31_ = res;
#line 177 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_warning ("Failed to create index on md5 and file_format", _tmp31_);
#line 1286 "PhotoTable.c"
	}
#line 181 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp32_ = database_table_db;
#line 181 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp34_ = sqlite3_prepare_v2 (_tmp32_, "CREATE INDEX IF NOT EXISTS PhotoTableThumbnailMD5MD5 on PhotoTable(thu" \
"mbnail_md5, md5)", -1, &_tmp33_, NULL);
#line 181 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 181 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp33_;
#line 181 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp34_;
#line 182 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp35_ = res;
#line 182 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp35_ == SQLITE_OK, "res == Sqlite.OK");
#line 183 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp36_ = stmt;
#line 183 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp37_ = sqlite3_step (_tmp36_);
#line 183 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp37_;
#line 184 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp38_ = res;
#line 184 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp38_ != SQLITE_DONE) {
#line 1312 "PhotoTable.c"
		gint _tmp39_ = 0;
#line 185 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp39_ = res;
#line 185 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_warning ("Failed to create index on thumbnail_md5 and md5", _tmp39_);
#line 1318 "PhotoTable.c"
	}
#line 188 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_set_table_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), "PhotoTable");
#line 112 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt2);
#line 112 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 112 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return self;
#line 1328 "PhotoTable.c"
}


static PhotoTable* photo_table_new (void) {
#line 112 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return photo_table_construct (TYPE_PHOTO_TABLE);
#line 1335 "PhotoTable.c"
}


static gpointer _database_table_ref0 (gpointer self) {
#line 195 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return self ? database_table_ref (self) : NULL;
#line 1342 "PhotoTable.c"
}


PhotoTable* photo_table_get_instance (void) {
	PhotoTable* result = NULL;
	PhotoTable* _tmp0_ = NULL;
	PhotoTable* _tmp2_ = NULL;
	PhotoTable* _tmp3_ = NULL;
#line 192 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = photo_table_instance;
#line 192 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp0_ == NULL) {
#line 1355 "PhotoTable.c"
		PhotoTable* _tmp1_ = NULL;
#line 193 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp1_ = photo_table_new ();
#line 193 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_database_table_unref0 (photo_table_instance);
#line 193 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		photo_table_instance = _tmp1_;
#line 1363 "PhotoTable.c"
	}
#line 195 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = photo_table_instance;
#line 195 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = _database_table_ref0 (_tmp2_);
#line 195 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp3_;
#line 195 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 1373 "PhotoTable.c"
}


void photo_table_add (PhotoTable* self, PhotoRow* photo_row, PhotoID* result) {
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gulong time_created = 0UL;
	gulong _tmp4_ = 0UL;
	sqlite3_stmt* _tmp5_ = NULL;
	PhotoRow* _tmp6_ = NULL;
	BackingPhotoRow* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GDestroyNotify _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	sqlite3_stmt* _tmp13_ = NULL;
	PhotoRow* _tmp14_ = NULL;
	BackingPhotoRow* _tmp15_ = NULL;
	Dimensions _tmp16_ = {0};
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	sqlite3_stmt* _tmp20_ = NULL;
	PhotoRow* _tmp21_ = NULL;
	BackingPhotoRow* _tmp22_ = NULL;
	Dimensions _tmp23_ = {0};
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	sqlite3_stmt* _tmp27_ = NULL;
	PhotoRow* _tmp28_ = NULL;
	BackingPhotoRow* _tmp29_ = NULL;
	gint64 _tmp30_ = 0LL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	sqlite3_stmt* _tmp33_ = NULL;
	PhotoRow* _tmp34_ = NULL;
	BackingPhotoRow* _tmp35_ = NULL;
	time_t _tmp36_ = 0;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	sqlite3_stmt* _tmp39_ = NULL;
	PhotoRow* _tmp40_ = NULL;
	time_t _tmp41_ = 0;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	sqlite3_stmt* _tmp44_ = NULL;
	PhotoRow* _tmp45_ = NULL;
	BackingPhotoRow* _tmp46_ = NULL;
	Orientation _tmp47_ = 0;
	gint _tmp48_ = 0;
	gint _tmp49_ = 0;
	sqlite3_stmt* _tmp50_ = NULL;
	PhotoRow* _tmp51_ = NULL;
	BackingPhotoRow* _tmp52_ = NULL;
	Orientation _tmp53_ = 0;
	gint _tmp54_ = 0;
	gint _tmp55_ = 0;
	sqlite3_stmt* _tmp56_ = NULL;
	PhotoRow* _tmp57_ = NULL;
	ImportID _tmp58_ = {0};
	gint64 _tmp59_ = 0LL;
	gint _tmp60_ = 0;
	gint _tmp61_ = 0;
	sqlite3_stmt* _tmp62_ = NULL;
	gint _tmp63_ = 0;
	gint _tmp64_ = 0;
	sqlite3_stmt* _tmp65_ = NULL;
	PhotoRow* _tmp66_ = NULL;
	const gchar* _tmp67_ = NULL;
	gchar* _tmp68_ = NULL;
	GDestroyNotify _tmp69_ = NULL;
	gint _tmp70_ = 0;
	gint _tmp71_ = 0;
	sqlite3_stmt* _tmp72_ = NULL;
	PhotoRow* _tmp73_ = NULL;
	const gchar* _tmp74_ = NULL;
	gchar* _tmp75_ = NULL;
	GDestroyNotify _tmp76_ = NULL;
	gint _tmp77_ = 0;
	gint _tmp78_ = 0;
	sqlite3_stmt* _tmp79_ = NULL;
	PhotoRow* _tmp80_ = NULL;
	const gchar* _tmp81_ = NULL;
	gchar* _tmp82_ = NULL;
	GDestroyNotify _tmp83_ = NULL;
	gint _tmp84_ = 0;
	gint _tmp85_ = 0;
	sqlite3_stmt* _tmp86_ = NULL;
	gulong _tmp87_ = 0UL;
	gint _tmp88_ = 0;
	gint _tmp89_ = 0;
	sqlite3_stmt* _tmp90_ = NULL;
	PhotoRow* _tmp91_ = NULL;
	BackingPhotoRow* _tmp92_ = NULL;
	PhotoFileFormat _tmp93_ = 0;
	gint _tmp94_ = 0;
	gint _tmp95_ = 0;
	gint _tmp96_ = 0;
	sqlite3_stmt* _tmp97_ = NULL;
	PhotoRow* _tmp98_ = NULL;
	const gchar* _tmp99_ = NULL;
	gchar* _tmp100_ = NULL;
	GDestroyNotify _tmp101_ = NULL;
	gint _tmp102_ = 0;
	gint _tmp103_ = 0;
	sqlite3_stmt* _tmp104_ = NULL;
	PhotoRow* _tmp105_ = NULL;
	Rating _tmp106_ = 0;
	gint _tmp107_ = 0;
	gint _tmp108_ = 0;
	gint _tmp109_ = 0;
	sqlite3_stmt* _tmp110_ = NULL;
	gint _tmp111_ = 0;
	gint _tmp112_ = 0;
	sqlite3_stmt* _tmp113_ = NULL;
	PhotoRow* _tmp114_ = NULL;
	RawDeveloper _tmp115_ = 0;
	gchar* _tmp116_ = NULL;
	GDestroyNotify _tmp117_ = NULL;
	gint _tmp118_ = 0;
	gint _tmp119_ = 0;
	sqlite3_stmt* _tmp120_ = NULL;
	PhotoRow* _tmp121_ = NULL;
	const gchar* _tmp122_ = NULL;
	gchar* _tmp123_ = NULL;
	GDestroyNotify _tmp124_ = NULL;
	gint _tmp125_ = 0;
	gint _tmp126_ = 0;
	sqlite3_stmt* _tmp127_ = NULL;
	gint _tmp128_ = 0;
	gint _tmp129_ = 0;
	PhotoRow* _tmp133_ = NULL;
	sqlite3* _tmp134_ = NULL;
	gint64 _tmp135_ = 0LL;
	PhotoRow* _tmp136_ = NULL;
	PhotoRow* _tmp137_ = NULL;
	BackingPhotoRow* _tmp138_ = NULL;
	Orientation _tmp139_ = 0;
	PhotoRow* _tmp140_ = NULL;
	PhotoRow* _tmp141_ = NULL;
	gulong _tmp142_ = 0UL;
	PhotoRow* _tmp143_ = NULL;
	PhotoRow* _tmp144_ = NULL;
	PhotoID _tmp145_ = {0};
#line 200 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 200 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_ROW (photo_row));
#line 202 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 202 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "INSERT INTO PhotoTable (filename, width, height, filesize, timestamp, " \
"exposure_time, " "orientation, original_orientation, import_id, event_id, md5, thumbnail" \
"_md5, " "exif_md5, time_created, file_format, title, rating, editable_id, devel" \
"oper, comment) " "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", -1, &_tmp1_, NULL);
#line 202 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 202 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 202 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 208 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 208 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 210 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = now_sec ();
#line 210 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	time_created = _tmp4_;
#line 212 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = stmt;
#line 212 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = photo_row;
#line 212 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = _tmp6_->master;
#line 212 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = _tmp7_->filepath;
#line 212 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 212 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = g_free;
#line 212 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = sqlite3_bind_text (_tmp5_, 1, _tmp9_, -1, _tmp10_);
#line 212 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp11_;
#line 213 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = res;
#line 213 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp12_ == SQLITE_OK, "res == Sqlite.OK");
#line 214 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_ = stmt;
#line 214 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = photo_row;
#line 214 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_ = _tmp14_->master;
#line 214 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp16_ = _tmp15_->dim;
#line 214 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp17_ = _tmp16_.width;
#line 214 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp18_ = sqlite3_bind_int (_tmp13_, 2, _tmp17_);
#line 214 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp18_;
#line 215 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp19_ = res;
#line 215 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp19_ == SQLITE_OK, "res == Sqlite.OK");
#line 216 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp20_ = stmt;
#line 216 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp21_ = photo_row;
#line 216 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp22_ = _tmp21_->master;
#line 216 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp23_ = _tmp22_->dim;
#line 216 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp24_ = _tmp23_.height;
#line 216 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp25_ = sqlite3_bind_int (_tmp20_, 3, _tmp24_);
#line 216 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp25_;
#line 217 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp26_ = res;
#line 217 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp26_ == SQLITE_OK, "res == Sqlite.OK");
#line 218 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp27_ = stmt;
#line 218 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp28_ = photo_row;
#line 218 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp29_ = _tmp28_->master;
#line 218 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp30_ = _tmp29_->filesize;
#line 218 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp31_ = sqlite3_bind_int64 (_tmp27_, 4, _tmp30_);
#line 218 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp31_;
#line 219 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp32_ = res;
#line 219 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp32_ == SQLITE_OK, "res == Sqlite.OK");
#line 220 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp33_ = stmt;
#line 220 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp34_ = photo_row;
#line 220 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp35_ = _tmp34_->master;
#line 220 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp36_ = _tmp35_->timestamp;
#line 220 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp37_ = sqlite3_bind_int64 (_tmp33_, 5, (gint64) _tmp36_);
#line 220 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp37_;
#line 221 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp38_ = res;
#line 221 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp38_ == SQLITE_OK, "res == Sqlite.OK");
#line 222 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp39_ = stmt;
#line 222 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp40_ = photo_row;
#line 222 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp41_ = _tmp40_->exposure_time;
#line 222 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp42_ = sqlite3_bind_int64 (_tmp39_, 6, (gint64) _tmp41_);
#line 222 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp42_;
#line 223 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp43_ = res;
#line 223 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp43_ == SQLITE_OK, "res == Sqlite.OK");
#line 224 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp44_ = stmt;
#line 224 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp45_ = photo_row;
#line 224 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp46_ = _tmp45_->master;
#line 224 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp47_ = _tmp46_->original_orientation;
#line 224 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp48_ = sqlite3_bind_int (_tmp44_, 7, (gint) _tmp47_);
#line 224 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp48_;
#line 225 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp49_ = res;
#line 225 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp49_ == SQLITE_OK, "res == Sqlite.OK");
#line 226 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp50_ = stmt;
#line 226 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp51_ = photo_row;
#line 226 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp52_ = _tmp51_->master;
#line 226 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp53_ = _tmp52_->original_orientation;
#line 226 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp54_ = sqlite3_bind_int (_tmp50_, 8, (gint) _tmp53_);
#line 226 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp54_;
#line 227 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp55_ = res;
#line 227 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp55_ == SQLITE_OK, "res == Sqlite.OK");
#line 228 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp56_ = stmt;
#line 228 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp57_ = photo_row;
#line 228 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp58_ = _tmp57_->import_id;
#line 228 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp59_ = _tmp58_.id;
#line 228 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp60_ = sqlite3_bind_int64 (_tmp56_, 9, _tmp59_);
#line 228 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp60_;
#line 229 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp61_ = res;
#line 229 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp61_ == SQLITE_OK, "res == Sqlite.OK");
#line 230 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp62_ = stmt;
#line 230 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp63_ = sqlite3_bind_int64 (_tmp62_, 10, EVENT_ID_INVALID);
#line 230 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp63_;
#line 231 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp64_ = res;
#line 231 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp64_ == SQLITE_OK, "res == Sqlite.OK");
#line 232 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp65_ = stmt;
#line 232 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp66_ = photo_row;
#line 232 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp67_ = _tmp66_->md5;
#line 232 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp68_ = g_strdup (_tmp67_);
#line 232 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp69_ = g_free;
#line 232 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp70_ = sqlite3_bind_text (_tmp65_, 11, _tmp68_, -1, _tmp69_);
#line 232 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp70_;
#line 233 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp71_ = res;
#line 233 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp71_ == SQLITE_OK, "res == Sqlite.OK");
#line 234 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp72_ = stmt;
#line 234 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp73_ = photo_row;
#line 234 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp74_ = _tmp73_->thumbnail_md5;
#line 234 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp75_ = g_strdup (_tmp74_);
#line 234 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp76_ = g_free;
#line 234 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp77_ = sqlite3_bind_text (_tmp72_, 12, _tmp75_, -1, _tmp76_);
#line 234 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp77_;
#line 235 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp78_ = res;
#line 235 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp78_ == SQLITE_OK, "res == Sqlite.OK");
#line 236 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp79_ = stmt;
#line 236 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp80_ = photo_row;
#line 236 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp81_ = _tmp80_->exif_md5;
#line 236 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp82_ = g_strdup (_tmp81_);
#line 236 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp83_ = g_free;
#line 236 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp84_ = sqlite3_bind_text (_tmp79_, 13, _tmp82_, -1, _tmp83_);
#line 236 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp84_;
#line 237 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp85_ = res;
#line 237 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp85_ == SQLITE_OK, "res == Sqlite.OK");
#line 238 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp86_ = stmt;
#line 238 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp87_ = time_created;
#line 238 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp88_ = sqlite3_bind_int64 (_tmp86_, 14, (gint64) _tmp87_);
#line 238 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp88_;
#line 239 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp89_ = res;
#line 239 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp89_ == SQLITE_OK, "res == Sqlite.OK");
#line 240 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp90_ = stmt;
#line 240 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp91_ = photo_row;
#line 240 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp92_ = _tmp91_->master;
#line 240 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp93_ = _tmp92_->file_format;
#line 240 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp94_ = photo_file_format_serialize (_tmp93_);
#line 240 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp95_ = sqlite3_bind_int (_tmp90_, 15, _tmp94_);
#line 240 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp95_;
#line 241 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp96_ = res;
#line 241 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp96_ == SQLITE_OK, "res == Sqlite.OK");
#line 242 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp97_ = stmt;
#line 242 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp98_ = photo_row;
#line 242 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp99_ = _tmp98_->title;
#line 242 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp100_ = g_strdup (_tmp99_);
#line 242 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp101_ = g_free;
#line 242 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp102_ = sqlite3_bind_text (_tmp97_, 16, _tmp100_, -1, _tmp101_);
#line 242 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp102_;
#line 243 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp103_ = res;
#line 243 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp103_ == SQLITE_OK, "res == Sqlite.OK");
#line 244 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp104_ = stmt;
#line 244 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp105_ = photo_row;
#line 244 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp106_ = _tmp105_->rating;
#line 244 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp107_ = rating_serialize (_tmp106_);
#line 244 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp108_ = sqlite3_bind_int64 (_tmp104_, 17, (gint64) _tmp107_);
#line 244 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp108_;
#line 245 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp109_ = res;
#line 245 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp109_ == SQLITE_OK, "res == Sqlite.OK");
#line 246 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp110_ = stmt;
#line 246 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp111_ = sqlite3_bind_int64 (_tmp110_, 18, BACKING_PHOTO_ID_INVALID);
#line 246 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp111_;
#line 247 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp112_ = res;
#line 247 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp112_ == SQLITE_OK, "res == Sqlite.OK");
#line 248 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp113_ = stmt;
#line 248 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp114_ = photo_row;
#line 248 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp115_ = _tmp114_->developer;
#line 248 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp116_ = raw_developer_to_string (_tmp115_);
#line 248 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp117_ = g_free;
#line 248 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp118_ = sqlite3_bind_text (_tmp113_, 19, _tmp116_, -1, _tmp117_);
#line 248 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp118_;
#line 249 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp119_ = res;
#line 249 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp119_ == SQLITE_OK, "res == Sqlite.OK");
#line 250 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp120_ = stmt;
#line 250 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp121_ = photo_row;
#line 250 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp122_ = _tmp121_->comment;
#line 250 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp123_ = g_strdup (_tmp122_);
#line 250 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp124_ = g_free;
#line 250 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp125_ = sqlite3_bind_text (_tmp120_, 20, _tmp123_, -1, _tmp124_);
#line 250 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp125_;
#line 251 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp126_ = res;
#line 251 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp126_ == SQLITE_OK, "res == Sqlite.OK");
#line 253 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp127_ = stmt;
#line 253 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp128_ = sqlite3_step (_tmp127_);
#line 253 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp128_;
#line 254 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp129_ = res;
#line 254 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp129_ != SQLITE_DONE) {
#line 1880 "PhotoTable.c"
		gint _tmp130_ = 0;
		PhotoID _tmp132_ = {0};
#line 255 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp130_ = res;
#line 255 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_tmp130_ != SQLITE_CONSTRAINT) {
#line 1887 "PhotoTable.c"
			gint _tmp131_ = 0;
#line 256 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp131_ = res;
#line 256 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			database_table_fatal ("add_photo", _tmp131_);
#line 1893 "PhotoTable.c"
		}
#line 258 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		photo_id_init (&_tmp132_, PHOTO_ID_INVALID);
#line 258 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		*result = _tmp132_;
#line 258 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 258 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return;
#line 1903 "PhotoTable.c"
	}
#line 262 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp133_ = photo_row;
#line 262 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp134_ = database_table_db;
#line 262 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp135_ = sqlite3_last_insert_rowid (_tmp134_);
#line 262 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	photo_id_init (&_tmp133_->photo_id, _tmp135_);
#line 263 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp136_ = photo_row;
#line 263 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp137_ = photo_row;
#line 263 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp138_ = _tmp137_->master;
#line 263 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp139_ = _tmp138_->original_orientation;
#line 263 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp136_->orientation = _tmp139_;
#line 264 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp140_ = photo_row;
#line 264 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	event_id_init (&_tmp140_->event_id, EVENT_ID_INVALID);
#line 265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp141_ = photo_row;
#line 265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp142_ = time_created;
#line 265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp141_->time_created = (time_t) _tmp142_;
#line 266 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp143_ = photo_row;
#line 266 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp143_->flags = (guint64) 0;
#line 268 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp144_ = photo_row;
#line 268 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp145_ = _tmp144_->photo_id;
#line 268 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	*result = _tmp145_;
#line 268 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 268 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return;
#line 1947 "PhotoTable.c"
}


void photo_table_reimport (PhotoTable* self, PhotoRow* row, GError** error) {
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	time_t time_reimported = 0;
	gulong _tmp4_ = 0UL;
	sqlite3_stmt* _tmp5_ = NULL;
	PhotoRow* _tmp6_ = NULL;
	BackingPhotoRow* _tmp7_ = NULL;
	Dimensions _tmp8_ = {0};
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	sqlite3_stmt* _tmp12_ = NULL;
	PhotoRow* _tmp13_ = NULL;
	BackingPhotoRow* _tmp14_ = NULL;
	Dimensions _tmp15_ = {0};
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	sqlite3_stmt* _tmp19_ = NULL;
	PhotoRow* _tmp20_ = NULL;
	BackingPhotoRow* _tmp21_ = NULL;
	gint64 _tmp22_ = 0LL;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	sqlite3_stmt* _tmp25_ = NULL;
	PhotoRow* _tmp26_ = NULL;
	BackingPhotoRow* _tmp27_ = NULL;
	time_t _tmp28_ = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	sqlite3_stmt* _tmp31_ = NULL;
	PhotoRow* _tmp32_ = NULL;
	time_t _tmp33_ = 0;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	sqlite3_stmt* _tmp36_ = NULL;
	PhotoRow* _tmp37_ = NULL;
	BackingPhotoRow* _tmp38_ = NULL;
	Orientation _tmp39_ = 0;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	sqlite3_stmt* _tmp42_ = NULL;
	PhotoRow* _tmp43_ = NULL;
	BackingPhotoRow* _tmp44_ = NULL;
	Orientation _tmp45_ = 0;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	sqlite3_stmt* _tmp48_ = NULL;
	PhotoRow* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	GDestroyNotify _tmp52_ = NULL;
	gint _tmp53_ = 0;
	gint _tmp54_ = 0;
	sqlite3_stmt* _tmp55_ = NULL;
	PhotoRow* _tmp56_ = NULL;
	const gchar* _tmp57_ = NULL;
	gchar* _tmp58_ = NULL;
	GDestroyNotify _tmp59_ = NULL;
	gint _tmp60_ = 0;
	gint _tmp61_ = 0;
	sqlite3_stmt* _tmp62_ = NULL;
	PhotoRow* _tmp63_ = NULL;
	const gchar* _tmp64_ = NULL;
	gchar* _tmp65_ = NULL;
	GDestroyNotify _tmp66_ = NULL;
	gint _tmp67_ = 0;
	gint _tmp68_ = 0;
	sqlite3_stmt* _tmp69_ = NULL;
	PhotoRow* _tmp70_ = NULL;
	BackingPhotoRow* _tmp71_ = NULL;
	PhotoFileFormat _tmp72_ = 0;
	gint _tmp73_ = 0;
	gint _tmp74_ = 0;
	gint _tmp75_ = 0;
	sqlite3_stmt* _tmp76_ = NULL;
	PhotoRow* _tmp77_ = NULL;
	const gchar* _tmp78_ = NULL;
	gchar* _tmp79_ = NULL;
	GDestroyNotify _tmp80_ = NULL;
	gint _tmp81_ = 0;
	gint _tmp82_ = 0;
	sqlite3_stmt* _tmp83_ = NULL;
	time_t _tmp84_ = 0;
	gint _tmp85_ = 0;
	gint _tmp86_ = 0;
	sqlite3_stmt* _tmp87_ = NULL;
	PhotoRow* _tmp88_ = NULL;
	PhotoID _tmp89_ = {0};
	gint64 _tmp90_ = 0LL;
	gint _tmp91_ = 0;
	gint _tmp92_ = 0;
	sqlite3_stmt* _tmp93_ = NULL;
	gint _tmp94_ = 0;
	gint _tmp95_ = 0;
	PhotoRow* _tmp97_ = NULL;
	time_t _tmp98_ = 0;
	PhotoRow* _tmp99_ = NULL;
	PhotoRow* _tmp100_ = NULL;
	BackingPhotoRow* _tmp101_ = NULL;
	Orientation _tmp102_ = 0;
	GError * _inner_error_ = NULL;
#line 276 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 276 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_ROW (row));
#line 278 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 278 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE PhotoTable SET width = ?, height = ?, filesize = ?, timestamp =" \
" ?, " "exposure_time = ?, orientation = ?, original_orientation = ?, md5 = ?," \
" " "exif_md5 = ?, thumbnail_md5 = ?, file_format = ?, title = ?, time_reim" \
"ported = ? " "WHERE id = ?", -1, &_tmp1_, NULL);
#line 278 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 278 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 278 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 283 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 283 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 285 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = now_sec ();
#line 285 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	time_reimported = (time_t) _tmp4_;
#line 287 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = stmt;
#line 287 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = row;
#line 287 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = _tmp6_->master;
#line 287 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = _tmp7_->dim;
#line 287 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = _tmp8_.width;
#line 287 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = sqlite3_bind_int (_tmp5_, 1, _tmp9_);
#line 287 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp10_;
#line 288 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = res;
#line 288 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp11_ == SQLITE_OK, "res == Sqlite.OK");
#line 289 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = stmt;
#line 289 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_ = row;
#line 289 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = _tmp13_->master;
#line 289 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_ = _tmp14_->dim;
#line 289 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp16_ = _tmp15_.height;
#line 289 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp17_ = sqlite3_bind_int (_tmp12_, 2, _tmp16_);
#line 289 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp17_;
#line 290 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp18_ = res;
#line 290 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp18_ == SQLITE_OK, "res == Sqlite.OK");
#line 291 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp19_ = stmt;
#line 291 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp20_ = row;
#line 291 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp21_ = _tmp20_->master;
#line 291 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp22_ = _tmp21_->filesize;
#line 291 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp23_ = sqlite3_bind_int64 (_tmp19_, 3, _tmp22_);
#line 291 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp23_;
#line 292 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp24_ = res;
#line 292 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp24_ == SQLITE_OK, "res == Sqlite.OK");
#line 293 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp25_ = stmt;
#line 293 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp26_ = row;
#line 293 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp27_ = _tmp26_->master;
#line 293 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp28_ = _tmp27_->timestamp;
#line 293 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp29_ = sqlite3_bind_int64 (_tmp25_, 4, (gint64) _tmp28_);
#line 293 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp29_;
#line 294 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp30_ = res;
#line 294 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp30_ == SQLITE_OK, "res == Sqlite.OK");
#line 295 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp31_ = stmt;
#line 295 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp32_ = row;
#line 295 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp33_ = _tmp32_->exposure_time;
#line 295 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp34_ = sqlite3_bind_int64 (_tmp31_, 5, (gint64) _tmp33_);
#line 295 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp34_;
#line 296 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp35_ = res;
#line 296 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp35_ == SQLITE_OK, "res == Sqlite.OK");
#line 297 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp36_ = stmt;
#line 297 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp37_ = row;
#line 297 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp38_ = _tmp37_->master;
#line 297 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp39_ = _tmp38_->original_orientation;
#line 297 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp40_ = sqlite3_bind_int (_tmp36_, 6, (gint) _tmp39_);
#line 297 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp40_;
#line 298 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp41_ = res;
#line 298 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp41_ == SQLITE_OK, "res == Sqlite.OK");
#line 299 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp42_ = stmt;
#line 299 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp43_ = row;
#line 299 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp44_ = _tmp43_->master;
#line 299 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp45_ = _tmp44_->original_orientation;
#line 299 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp46_ = sqlite3_bind_int (_tmp42_, 7, (gint) _tmp45_);
#line 299 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp46_;
#line 300 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp47_ = res;
#line 300 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp47_ == SQLITE_OK, "res == Sqlite.OK");
#line 301 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp48_ = stmt;
#line 301 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp49_ = row;
#line 301 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp50_ = _tmp49_->md5;
#line 301 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp51_ = g_strdup (_tmp50_);
#line 301 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp52_ = g_free;
#line 301 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp53_ = sqlite3_bind_text (_tmp48_, 8, _tmp51_, -1, _tmp52_);
#line 301 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp53_;
#line 302 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp54_ = res;
#line 302 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp54_ == SQLITE_OK, "res == Sqlite.OK");
#line 303 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp55_ = stmt;
#line 303 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp56_ = row;
#line 303 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp57_ = _tmp56_->exif_md5;
#line 303 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp58_ = g_strdup (_tmp57_);
#line 303 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp59_ = g_free;
#line 303 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp60_ = sqlite3_bind_text (_tmp55_, 9, _tmp58_, -1, _tmp59_);
#line 303 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp60_;
#line 304 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp61_ = res;
#line 304 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp61_ == SQLITE_OK, "res == Sqlite.OK");
#line 305 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp62_ = stmt;
#line 305 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp63_ = row;
#line 305 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp64_ = _tmp63_->thumbnail_md5;
#line 305 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp65_ = g_strdup (_tmp64_);
#line 305 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp66_ = g_free;
#line 305 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp67_ = sqlite3_bind_text (_tmp62_, 10, _tmp65_, -1, _tmp66_);
#line 305 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp67_;
#line 306 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp68_ = res;
#line 306 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp68_ == SQLITE_OK, "res == Sqlite.OK");
#line 307 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp69_ = stmt;
#line 307 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp70_ = row;
#line 307 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp71_ = _tmp70_->master;
#line 307 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp72_ = _tmp71_->file_format;
#line 307 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp73_ = photo_file_format_serialize (_tmp72_);
#line 307 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp74_ = sqlite3_bind_int (_tmp69_, 11, _tmp73_);
#line 307 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp74_;
#line 308 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp75_ = res;
#line 308 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp75_ == SQLITE_OK, "res == Sqlite.OK");
#line 309 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp76_ = stmt;
#line 309 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp77_ = row;
#line 309 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp78_ = _tmp77_->title;
#line 309 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp79_ = g_strdup (_tmp78_);
#line 309 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp80_ = g_free;
#line 309 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp81_ = sqlite3_bind_text (_tmp76_, 12, _tmp79_, -1, _tmp80_);
#line 309 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp81_;
#line 310 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp82_ = res;
#line 310 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp82_ == SQLITE_OK, "res == Sqlite.OK");
#line 311 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp83_ = stmt;
#line 311 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp84_ = time_reimported;
#line 311 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp85_ = sqlite3_bind_int64 (_tmp83_, 13, (gint64) _tmp84_);
#line 311 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp85_;
#line 312 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp86_ = res;
#line 312 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp86_ == SQLITE_OK, "res == Sqlite.OK");
#line 313 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp87_ = stmt;
#line 313 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp88_ = row;
#line 313 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp89_ = _tmp88_->photo_id;
#line 313 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp90_ = _tmp89_.id;
#line 313 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp91_ = sqlite3_bind_int64 (_tmp87_, 14, _tmp90_);
#line 313 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp91_;
#line 314 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp92_ = res;
#line 314 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp92_ == SQLITE_OK, "res == Sqlite.OK");
#line 316 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp93_ = stmt;
#line 316 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp94_ = sqlite3_step (_tmp93_);
#line 316 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp94_;
#line 317 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp95_ = res;
#line 317 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp95_ != SQLITE_DONE) {
#line 2322 "PhotoTable.c"
		gint _tmp96_ = 0;
#line 318 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp96_ = res;
#line 318 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_throw_error ("PhotoTable.reimport_master", _tmp96_, &_inner_error_);
#line 318 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 318 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 318 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_propagate_error (error, _inner_error_);
#line 318 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 318 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				return;
#line 2338 "PhotoTable.c"
			} else {
#line 318 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 318 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 318 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_clear_error (&_inner_error_);
#line 318 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				return;
#line 2348 "PhotoTable.c"
			}
		}
	}
#line 320 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp97_ = row;
#line 320 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp98_ = time_reimported;
#line 320 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp97_->time_reimported = _tmp98_;
#line 321 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp99_ = row;
#line 321 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp100_ = row;
#line 321 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp101_ = _tmp100_->master;
#line 321 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp102_ = _tmp101_->original_orientation;
#line 321 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp99_->orientation = _tmp102_;
#line 276 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 2370 "PhotoTable.c"
}


gboolean photo_table_master_exif_updated (PhotoTable* self, PhotoID* photoID, gint64 filesize, glong timestamp, const gchar* md5, const gchar* exif_md5, const gchar* thumbnail_md5, PhotoRow* row) {
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	sqlite3_stmt* _tmp8_ = NULL;
	glong _tmp9_ = 0L;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	sqlite3_stmt* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GDestroyNotify _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	sqlite3_stmt* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	GDestroyNotify _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	sqlite3_stmt* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	GDestroyNotify _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	sqlite3_stmt* _tmp30_ = NULL;
	PhotoID _tmp31_ = {0};
	gint64 _tmp32_ = 0LL;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	sqlite3_stmt* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	PhotoRow* _tmp40_ = NULL;
	BackingPhotoRow* _tmp41_ = NULL;
	gint64 _tmp42_ = 0LL;
	PhotoRow* _tmp43_ = NULL;
	BackingPhotoRow* _tmp44_ = NULL;
	glong _tmp45_ = 0L;
	PhotoRow* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	PhotoRow* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	PhotoRow* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
#line 324 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 324 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photoID != NULL, FALSE);
#line 324 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (md5 != NULL, FALSE);
#line 324 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_ROW (row), FALSE);
#line 327 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 327 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE PhotoTable SET filesize = ?, timestamp = ?, md5 = ?, exif_md5 =" \
" ?," "thumbnail_md5 =? WHERE id = ?", -1, &_tmp1_, NULL);
#line 327 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 327 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 327 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 330 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 330 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 332 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 332 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = filesize;
#line 332 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = sqlite3_bind_int64 (_tmp4_, 1, _tmp5_);
#line 332 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp6_;
#line 333 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = res;
#line 333 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 334 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = stmt;
#line 334 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = timestamp;
#line 334 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = sqlite3_bind_int64 (_tmp8_, 2, (gint64) _tmp9_);
#line 334 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp10_;
#line 335 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = res;
#line 335 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp11_ == SQLITE_OK, "res == Sqlite.OK");
#line 336 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = stmt;
#line 336 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_ = md5;
#line 336 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = g_strdup (_tmp13_);
#line 336 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_ = g_free;
#line 336 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp16_ = sqlite3_bind_text (_tmp12_, 3, _tmp14_, -1, _tmp15_);
#line 336 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp16_;
#line 337 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp17_ = res;
#line 337 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp17_ == SQLITE_OK, "res == Sqlite.OK");
#line 338 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp18_ = stmt;
#line 338 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp19_ = exif_md5;
#line 338 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp20_ = g_strdup (_tmp19_);
#line 338 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp21_ = g_free;
#line 338 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp22_ = sqlite3_bind_text (_tmp18_, 4, _tmp20_, -1, _tmp21_);
#line 338 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp22_;
#line 339 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp23_ = res;
#line 339 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp23_ == SQLITE_OK, "res == Sqlite.OK");
#line 340 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp24_ = stmt;
#line 340 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp25_ = thumbnail_md5;
#line 340 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp26_ = g_strdup (_tmp25_);
#line 340 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp27_ = g_free;
#line 340 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp28_ = sqlite3_bind_text (_tmp24_, 5, _tmp26_, -1, _tmp27_);
#line 340 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp28_;
#line 341 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp29_ = res;
#line 341 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp29_ == SQLITE_OK, "res == Sqlite.OK");
#line 342 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp30_ = stmt;
#line 342 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp31_ = *photoID;
#line 342 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp32_ = _tmp31_.id;
#line 342 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp33_ = sqlite3_bind_int64 (_tmp30_, 6, _tmp32_);
#line 342 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp33_;
#line 343 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp34_ = res;
#line 343 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp34_ == SQLITE_OK, "res == Sqlite.OK");
#line 345 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp35_ = stmt;
#line 345 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp36_ = sqlite3_step (_tmp35_);
#line 345 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp36_;
#line 346 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp37_ = res;
#line 346 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp37_ != SQLITE_DONE) {
#line 2549 "PhotoTable.c"
		gint _tmp38_ = 0;
#line 347 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp38_ = res;
#line 347 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_tmp38_ != SQLITE_CONSTRAINT) {
#line 2555 "PhotoTable.c"
			gint _tmp39_ = 0;
#line 348 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp39_ = res;
#line 348 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			database_table_fatal ("write_update_photo", _tmp39_);
#line 2561 "PhotoTable.c"
		}
#line 350 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = FALSE;
#line 350 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 350 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 2569 "PhotoTable.c"
	}
#line 353 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp40_ = row;
#line 353 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp41_ = _tmp40_->master;
#line 353 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp42_ = filesize;
#line 353 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp41_->filesize = _tmp42_;
#line 354 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp43_ = row;
#line 354 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp44_ = _tmp43_->master;
#line 354 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp45_ = timestamp;
#line 354 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp44_->timestamp = (time_t) _tmp45_;
#line 355 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp46_ = row;
#line 355 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp47_ = md5;
#line 355 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp48_ = g_strdup (_tmp47_);
#line 355 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (_tmp46_->md5);
#line 355 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp46_->md5 = _tmp48_;
#line 356 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp49_ = row;
#line 356 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp50_ = exif_md5;
#line 356 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp51_ = g_strdup (_tmp50_);
#line 356 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (_tmp49_->exif_md5);
#line 356 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp49_->exif_md5 = _tmp51_;
#line 357 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp52_ = row;
#line 357 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp53_ = thumbnail_md5;
#line 357 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp54_ = g_strdup (_tmp53_);
#line 357 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (_tmp52_->thumbnail_md5);
#line 357 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp52_->thumbnail_md5 = _tmp54_;
#line 359 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = TRUE;
#line 359 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 359 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 2623 "PhotoTable.c"
}


static void photo_table_validate_orientation (PhotoTable* self, PhotoRow* row) {
	gboolean _tmp0_ = FALSE;
	PhotoRow* _tmp1_ = NULL;
	Orientation _tmp2_ = 0;
#line 370 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 370 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_ROW (row));
#line 371 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = row;
#line 371 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = _tmp1_->orientation;
#line 371 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp2_ < ORIENTATION_MIN) {
#line 371 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = TRUE;
#line 2643 "PhotoTable.c"
	} else {
		PhotoRow* _tmp3_ = NULL;
		Orientation _tmp4_ = 0;
#line 372 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp3_ = row;
#line 372 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp4_ = _tmp3_->orientation;
#line 372 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = _tmp4_ > ORIENTATION_MAX;
#line 2653 "PhotoTable.c"
	}
#line 371 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp0_) {
#line 2657 "PhotoTable.c"
		PhotoRow* _tmp5_ = NULL;
		PhotoID _tmp6_ = {0};
		PhotoRow* _tmp7_ = NULL;
#line 374 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp5_ = row;
#line 374 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp6_ = _tmp5_->photo_id;
#line 374 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		photo_table_set_orientation (self, &_tmp6_, ORIENTATION_MIN);
#line 375 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp7_ = row;
#line 375 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp7_->orientation = ORIENTATION_MIN;
#line 2671 "PhotoTable.c"
	}
}


PhotoRow* photo_table_get_row (PhotoTable* self, PhotoID* photo_id) {
	PhotoRow* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	PhotoID _tmp5_ = {0};
	gint64 _tmp6_ = 0LL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	sqlite3_stmt* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	PhotoRow* row = NULL;
	PhotoRow* _tmp11_ = NULL;
	PhotoRow* _tmp12_ = NULL;
	PhotoID _tmp13_ = {0};
	PhotoRow* _tmp14_ = NULL;
	BackingPhotoRow* _tmp15_ = NULL;
	sqlite3_stmt* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	PhotoRow* _tmp19_ = NULL;
	BackingPhotoRow* _tmp20_ = NULL;
	sqlite3_stmt* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	sqlite3_stmt* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	PhotoRow* _tmp25_ = NULL;
	BackingPhotoRow* _tmp26_ = NULL;
	sqlite3_stmt* _tmp27_ = NULL;
	gint64 _tmp28_ = 0LL;
	PhotoRow* _tmp29_ = NULL;
	BackingPhotoRow* _tmp30_ = NULL;
	sqlite3_stmt* _tmp31_ = NULL;
	gint64 _tmp32_ = 0LL;
	PhotoRow* _tmp33_ = NULL;
	sqlite3_stmt* _tmp34_ = NULL;
	gint64 _tmp35_ = 0LL;
	PhotoRow* _tmp36_ = NULL;
	sqlite3_stmt* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	PhotoRow* _tmp39_ = NULL;
	BackingPhotoRow* _tmp40_ = NULL;
	sqlite3_stmt* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	PhotoRow* _tmp43_ = NULL;
	sqlite3_stmt* _tmp44_ = NULL;
	gint64 _tmp45_ = 0LL;
	PhotoRow* _tmp46_ = NULL;
	sqlite3_stmt* _tmp47_ = NULL;
	gint64 _tmp48_ = 0LL;
	PhotoRow* _tmp49_ = NULL;
	sqlite3_stmt* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	GeeHashMap* _tmp52_ = NULL;
	PhotoRow* _tmp53_ = NULL;
	sqlite3_stmt* _tmp54_ = NULL;
	const gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	PhotoRow* _tmp57_ = NULL;
	sqlite3_stmt* _tmp58_ = NULL;
	const gchar* _tmp59_ = NULL;
	gchar* _tmp60_ = NULL;
	PhotoRow* _tmp61_ = NULL;
	sqlite3_stmt* _tmp62_ = NULL;
	const gchar* _tmp63_ = NULL;
	gchar* _tmp64_ = NULL;
	PhotoRow* _tmp65_ = NULL;
	sqlite3_stmt* _tmp66_ = NULL;
	gint64 _tmp67_ = 0LL;
	PhotoRow* _tmp68_ = NULL;
	sqlite3_stmt* _tmp69_ = NULL;
	gint64 _tmp70_ = 0LL;
	PhotoRow* _tmp71_ = NULL;
	sqlite3_stmt* _tmp72_ = NULL;
	gint _tmp73_ = 0;
	Rating _tmp74_ = 0;
	PhotoRow* _tmp75_ = NULL;
	BackingPhotoRow* _tmp76_ = NULL;
	sqlite3_stmt* _tmp77_ = NULL;
	gint _tmp78_ = 0;
	PhotoFileFormat _tmp79_ = 0;
	PhotoRow* _tmp80_ = NULL;
	sqlite3_stmt* _tmp81_ = NULL;
	const gchar* _tmp82_ = NULL;
	gchar* _tmp83_ = NULL;
	PhotoRow* _tmp84_ = NULL;
	sqlite3_stmt* _tmp85_ = NULL;
	const gchar* _tmp86_ = NULL;
	gchar* _tmp87_ = NULL;
	PhotoRow* _tmp88_ = NULL;
	sqlite3_stmt* _tmp89_ = NULL;
	gint64 _tmp90_ = 0LL;
	PhotoRow* _tmp91_ = NULL;
	sqlite3_stmt* _tmp92_ = NULL;
	gint64 _tmp93_ = 0LL;
	PhotoRow* _tmp94_ = NULL;
	sqlite3_stmt* _tmp95_ = NULL;
	gint _tmp96_ = 0;
	RawDeveloper _tmp97_ = 0;
	sqlite3_stmt* _tmp98_ = NULL;
	const gchar* _tmp99_ = NULL;
	PhotoRow* _tmp103_ = NULL;
	PhotoRow* _tmp104_ = NULL;
	BackingPhotoID* _tmp105_ = NULL;
	gint _tmp105__length1 = 0;
	sqlite3_stmt* _tmp106_ = NULL;
	gint64 _tmp107_ = 0LL;
	BackingPhotoID _tmp108_ = {0};
	BackingPhotoID _tmp109_ = {0};
	PhotoRow* _tmp110_ = NULL;
	BackingPhotoID* _tmp111_ = NULL;
	gint _tmp111__length1 = 0;
	sqlite3_stmt* _tmp112_ = NULL;
	gint64 _tmp113_ = 0LL;
	BackingPhotoID _tmp114_ = {0};
	BackingPhotoID _tmp115_ = {0};
	PhotoRow* _tmp116_ = NULL;
	BackingPhotoID* _tmp117_ = NULL;
	gint _tmp117__length1 = 0;
	sqlite3_stmt* _tmp118_ = NULL;
	gint64 _tmp119_ = 0LL;
	BackingPhotoID _tmp120_ = {0};
	BackingPhotoID _tmp121_ = {0};
	PhotoRow* _tmp122_ = NULL;
	sqlite3_stmt* _tmp123_ = NULL;
	const gchar* _tmp124_ = NULL;
	gchar* _tmp125_ = NULL;
#line 379 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), NULL);
#line 379 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, NULL);
#line 381 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 381 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT filename, width, height, filesize, timestamp, exposure_time, or" \
"ientation, " "original_orientation, import_id, event_id, transformations, md5, thumb" \
"nail_md5, " "exif_md5, time_created, flags, rating, file_format, title, backlinks, " "time_reimported, editable_id, metadata_dirty, developer, develop_shotw" \
"ell_id, " "develop_camera_id, develop_embedded_id, comment " "FROM PhotoTable WHERE id=?", -1, &_tmp1_, NULL);
#line 381 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 381 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 381 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 389 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 389 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 391 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 391 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = *photo_id;
#line 391 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = _tmp5_.id;
#line 391 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = sqlite3_bind_int64 (_tmp4_, 1, _tmp6_);
#line 391 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp7_;
#line 392 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = res;
#line 392 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp8_ == SQLITE_OK, "res == Sqlite.OK");
#line 394 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = stmt;
#line 394 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = sqlite3_step (_tmp9_);
#line 394 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp10_ != SQLITE_ROW) {
#line 395 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = NULL;
#line 395 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 395 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 2851 "PhotoTable.c"
	}
#line 397 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = photo_row_new ();
#line 397 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	row = _tmp11_;
#line 398 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = row;
#line 398 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_ = *photo_id;
#line 398 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_->photo_id = _tmp13_;
#line 399 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = row;
#line 399 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_ = _tmp14_->master;
#line 399 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp16_ = stmt;
#line 399 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp17_ = sqlite3_column_text (_tmp16_, 0);
#line 399 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp18_ = g_strdup (_tmp17_);
#line 399 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (_tmp15_->filepath);
#line 399 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_->filepath = _tmp18_;
#line 400 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp19_ = row;
#line 400 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp20_ = _tmp19_->master;
#line 400 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp21_ = stmt;
#line 400 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp22_ = sqlite3_column_int (_tmp21_, 1);
#line 400 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp23_ = stmt;
#line 400 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp24_ = sqlite3_column_int (_tmp23_, 2);
#line 400 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	dimensions_init (&_tmp20_->dim, _tmp22_, _tmp24_);
#line 401 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp25_ = row;
#line 401 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp26_ = _tmp25_->master;
#line 401 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp27_ = stmt;
#line 401 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp28_ = sqlite3_column_int64 (_tmp27_, 3);
#line 401 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp26_->filesize = _tmp28_;
#line 402 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp29_ = row;
#line 402 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp30_ = _tmp29_->master;
#line 402 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp31_ = stmt;
#line 402 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp32_ = sqlite3_column_int64 (_tmp31_, 4);
#line 402 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp30_->timestamp = (time_t) _tmp32_;
#line 403 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp33_ = row;
#line 403 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp34_ = stmt;
#line 403 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp35_ = sqlite3_column_int64 (_tmp34_, 5);
#line 403 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp33_->exposure_time = (time_t) _tmp35_;
#line 404 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp36_ = row;
#line 404 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp37_ = stmt;
#line 404 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp38_ = sqlite3_column_int (_tmp37_, 6);
#line 404 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp36_->orientation = (Orientation) _tmp38_;
#line 405 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp39_ = row;
#line 405 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp40_ = _tmp39_->master;
#line 405 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp41_ = stmt;
#line 405 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp42_ = sqlite3_column_int (_tmp41_, 7);
#line 405 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp40_->original_orientation = (Orientation) _tmp42_;
#line 406 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp43_ = row;
#line 406 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp44_ = stmt;
#line 406 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp45_ = sqlite3_column_int64 (_tmp44_, 8);
#line 406 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp43_->import_id.id = _tmp45_;
#line 407 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp46_ = row;
#line 407 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp47_ = stmt;
#line 407 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp48_ = sqlite3_column_int64 (_tmp47_, 9);
#line 407 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp46_->event_id.id = _tmp48_;
#line 408 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp49_ = row;
#line 408 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp50_ = stmt;
#line 408 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp51_ = sqlite3_column_text (_tmp50_, 10);
#line 408 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp52_ = photo_table_marshall_all_transformations (_tmp51_);
#line 408 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_object_unref0 (_tmp49_->transformations);
#line 408 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp49_->transformations = _tmp52_;
#line 409 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp53_ = row;
#line 409 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp54_ = stmt;
#line 409 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp55_ = sqlite3_column_text (_tmp54_, 11);
#line 409 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp56_ = g_strdup (_tmp55_);
#line 409 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (_tmp53_->md5);
#line 409 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp53_->md5 = _tmp56_;
#line 410 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp57_ = row;
#line 410 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp58_ = stmt;
#line 410 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp59_ = sqlite3_column_text (_tmp58_, 12);
#line 410 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp60_ = g_strdup (_tmp59_);
#line 410 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (_tmp57_->thumbnail_md5);
#line 410 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp57_->thumbnail_md5 = _tmp60_;
#line 411 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp61_ = row;
#line 411 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp62_ = stmt;
#line 411 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp63_ = sqlite3_column_text (_tmp62_, 13);
#line 411 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp64_ = g_strdup (_tmp63_);
#line 411 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (_tmp61_->exif_md5);
#line 411 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp61_->exif_md5 = _tmp64_;
#line 412 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp65_ = row;
#line 412 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp66_ = stmt;
#line 412 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp67_ = sqlite3_column_int64 (_tmp66_, 14);
#line 412 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp65_->time_created = (time_t) _tmp67_;
#line 413 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp68_ = row;
#line 413 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp69_ = stmt;
#line 413 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp70_ = sqlite3_column_int64 (_tmp69_, 15);
#line 413 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp68_->flags = (guint64) _tmp70_;
#line 414 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp71_ = row;
#line 414 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp72_ = stmt;
#line 414 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp73_ = sqlite3_column_int (_tmp72_, 16);
#line 414 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp74_ = rating_unserialize (_tmp73_);
#line 414 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp71_->rating = _tmp74_;
#line 415 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp75_ = row;
#line 415 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp76_ = _tmp75_->master;
#line 415 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp77_ = stmt;
#line 415 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp78_ = sqlite3_column_int (_tmp77_, 17);
#line 415 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp79_ = photo_file_format_unserialize (_tmp78_);
#line 415 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp76_->file_format = _tmp79_;
#line 416 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp80_ = row;
#line 416 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp81_ = stmt;
#line 416 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp82_ = sqlite3_column_text (_tmp81_, 18);
#line 416 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp83_ = g_strdup (_tmp82_);
#line 416 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (_tmp80_->title);
#line 416 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp80_->title = _tmp83_;
#line 417 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp84_ = row;
#line 417 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp85_ = stmt;
#line 417 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp86_ = sqlite3_column_text (_tmp85_, 19);
#line 417 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp87_ = g_strdup (_tmp86_);
#line 417 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (_tmp84_->backlinks);
#line 417 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp84_->backlinks = _tmp87_;
#line 418 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp88_ = row;
#line 418 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp89_ = stmt;
#line 418 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp90_ = sqlite3_column_int64 (_tmp89_, 20);
#line 418 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp88_->time_reimported = (time_t) _tmp90_;
#line 419 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp91_ = row;
#line 419 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp92_ = stmt;
#line 419 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp93_ = sqlite3_column_int64 (_tmp92_, 21);
#line 419 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	backing_photo_id_init (&_tmp91_->editable_id, _tmp93_);
#line 420 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp94_ = row;
#line 420 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp95_ = stmt;
#line 420 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp96_ = sqlite3_column_int (_tmp95_, 22);
#line 420 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp94_->metadata_dirty = _tmp96_ != 0;
#line 421 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp98_ = stmt;
#line 421 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp99_ = sqlite3_column_text (_tmp98_, 23);
#line 421 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp99_ != NULL) {
#line 3093 "PhotoTable.c"
		sqlite3_stmt* _tmp100_ = NULL;
		const gchar* _tmp101_ = NULL;
		RawDeveloper _tmp102_ = 0;
#line 421 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp100_ = stmt;
#line 421 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp101_ = sqlite3_column_text (_tmp100_, 23);
#line 421 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp102_ = raw_developer_from_string (_tmp101_);
#line 421 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp97_ = _tmp102_;
#line 3105 "PhotoTable.c"
	} else {
#line 422 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp97_ = RAW_DEVELOPER_CAMERA;
#line 3109 "PhotoTable.c"
	}
#line 421 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp103_ = row;
#line 421 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp103_->developer = _tmp97_;
#line 423 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp104_ = row;
#line 423 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp105_ = _tmp104_->development_ids;
#line 423 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp105__length1 = _tmp104_->development_ids_length1;
#line 423 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp106_ = stmt;
#line 423 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp107_ = sqlite3_column_int64 (_tmp106_, 24);
#line 423 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	backing_photo_id_init (&_tmp108_, _tmp107_);
#line 423 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp105_[RAW_DEVELOPER_SHOTWELL] = _tmp108_;
#line 423 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp109_ = _tmp105_[RAW_DEVELOPER_SHOTWELL];
#line 424 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp110_ = row;
#line 424 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp111_ = _tmp110_->development_ids;
#line 424 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp111__length1 = _tmp110_->development_ids_length1;
#line 424 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp112_ = stmt;
#line 424 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp113_ = sqlite3_column_int64 (_tmp112_, 25);
#line 424 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	backing_photo_id_init (&_tmp114_, _tmp113_);
#line 424 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp111_[RAW_DEVELOPER_CAMERA] = _tmp114_;
#line 424 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp115_ = _tmp111_[RAW_DEVELOPER_CAMERA];
#line 425 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp116_ = row;
#line 425 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp117_ = _tmp116_->development_ids;
#line 425 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp117__length1 = _tmp116_->development_ids_length1;
#line 425 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp118_ = stmt;
#line 425 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp119_ = sqlite3_column_int64 (_tmp118_, 26);
#line 425 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	backing_photo_id_init (&_tmp120_, _tmp119_);
#line 425 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp117_[RAW_DEVELOPER_EMBEDDED] = _tmp120_;
#line 425 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp121_ = _tmp117_[RAW_DEVELOPER_EMBEDDED];
#line 426 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp122_ = row;
#line 426 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp123_ = stmt;
#line 426 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp124_ = sqlite3_column_text (_tmp123_, 27);
#line 426 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp125_ = g_strdup (_tmp124_);
#line 426 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (_tmp122_->comment);
#line 426 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp122_->comment = _tmp125_;
#line 428 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = row;
#line 428 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 428 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 3181 "PhotoTable.c"
}


GeeArrayList* photo_table_get_all (PhotoTable* self) {
	GeeArrayList* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GeeArrayList* all = NULL;
	GeeArrayList* _tmp4_ = NULL;
#line 431 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), NULL);
#line 433 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 433 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id, filename, width, height, filesize, timestamp, exposure_time" \
", orientation, " "original_orientation, import_id, event_id, transformations, md5, thumb" \
"nail_md5, " "exif_md5, time_created, flags, rating, file_format, title, backlinks, " \
"time_reimported, " "editable_id, metadata_dirty, developer, develop_shotwell_id, develop_c" \
"amera_id, " "develop_embedded_id, comment FROM PhotoTable", -1, &_tmp1_, NULL);
#line 433 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 433 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 433 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 440 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 440 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 442 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = gee_array_list_new (TYPE_PHOTO_ROW, (GBoxedCopyFunc) photo_row_ref, photo_row_unref, NULL, NULL, NULL);
#line 442 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	all = _tmp4_;
#line 444 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	while (TRUE) {
#line 3217 "PhotoTable.c"
		sqlite3_stmt* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		PhotoRow* row = NULL;
		PhotoRow* _tmp8_ = NULL;
		PhotoRow* _tmp9_ = NULL;
		sqlite3_stmt* _tmp10_ = NULL;
		gint64 _tmp11_ = 0LL;
		PhotoRow* _tmp12_ = NULL;
		BackingPhotoRow* _tmp13_ = NULL;
		sqlite3_stmt* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		PhotoRow* _tmp17_ = NULL;
		BackingPhotoRow* _tmp18_ = NULL;
		sqlite3_stmt* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		sqlite3_stmt* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		PhotoRow* _tmp23_ = NULL;
		BackingPhotoRow* _tmp24_ = NULL;
		sqlite3_stmt* _tmp25_ = NULL;
		gint64 _tmp26_ = 0LL;
		PhotoRow* _tmp27_ = NULL;
		BackingPhotoRow* _tmp28_ = NULL;
		sqlite3_stmt* _tmp29_ = NULL;
		gint64 _tmp30_ = 0LL;
		PhotoRow* _tmp31_ = NULL;
		sqlite3_stmt* _tmp32_ = NULL;
		gint64 _tmp33_ = 0LL;
		PhotoRow* _tmp34_ = NULL;
		sqlite3_stmt* _tmp35_ = NULL;
		gint _tmp36_ = 0;
		PhotoRow* _tmp37_ = NULL;
		BackingPhotoRow* _tmp38_ = NULL;
		sqlite3_stmt* _tmp39_ = NULL;
		gint _tmp40_ = 0;
		PhotoRow* _tmp41_ = NULL;
		sqlite3_stmt* _tmp42_ = NULL;
		gint64 _tmp43_ = 0LL;
		PhotoRow* _tmp44_ = NULL;
		sqlite3_stmt* _tmp45_ = NULL;
		gint64 _tmp46_ = 0LL;
		PhotoRow* _tmp47_ = NULL;
		sqlite3_stmt* _tmp48_ = NULL;
		const gchar* _tmp49_ = NULL;
		GeeHashMap* _tmp50_ = NULL;
		PhotoRow* _tmp51_ = NULL;
		sqlite3_stmt* _tmp52_ = NULL;
		const gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
		PhotoRow* _tmp55_ = NULL;
		sqlite3_stmt* _tmp56_ = NULL;
		const gchar* _tmp57_ = NULL;
		gchar* _tmp58_ = NULL;
		PhotoRow* _tmp59_ = NULL;
		sqlite3_stmt* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		gchar* _tmp62_ = NULL;
		PhotoRow* _tmp63_ = NULL;
		sqlite3_stmt* _tmp64_ = NULL;
		gint64 _tmp65_ = 0LL;
		PhotoRow* _tmp66_ = NULL;
		sqlite3_stmt* _tmp67_ = NULL;
		gint64 _tmp68_ = 0LL;
		PhotoRow* _tmp69_ = NULL;
		sqlite3_stmt* _tmp70_ = NULL;
		gint _tmp71_ = 0;
		Rating _tmp72_ = 0;
		PhotoRow* _tmp73_ = NULL;
		BackingPhotoRow* _tmp74_ = NULL;
		sqlite3_stmt* _tmp75_ = NULL;
		gint _tmp76_ = 0;
		PhotoFileFormat _tmp77_ = 0;
		PhotoRow* _tmp78_ = NULL;
		sqlite3_stmt* _tmp79_ = NULL;
		const gchar* _tmp80_ = NULL;
		gchar* _tmp81_ = NULL;
		PhotoRow* _tmp82_ = NULL;
		sqlite3_stmt* _tmp83_ = NULL;
		const gchar* _tmp84_ = NULL;
		gchar* _tmp85_ = NULL;
		PhotoRow* _tmp86_ = NULL;
		sqlite3_stmt* _tmp87_ = NULL;
		gint64 _tmp88_ = 0LL;
		PhotoRow* _tmp89_ = NULL;
		sqlite3_stmt* _tmp90_ = NULL;
		gint64 _tmp91_ = 0LL;
		PhotoRow* _tmp92_ = NULL;
		sqlite3_stmt* _tmp93_ = NULL;
		gint _tmp94_ = 0;
		RawDeveloper _tmp95_ = 0;
		sqlite3_stmt* _tmp96_ = NULL;
		const gchar* _tmp97_ = NULL;
		PhotoRow* _tmp101_ = NULL;
		PhotoRow* _tmp102_ = NULL;
		BackingPhotoID* _tmp103_ = NULL;
		gint _tmp103__length1 = 0;
		sqlite3_stmt* _tmp104_ = NULL;
		gint64 _tmp105_ = 0LL;
		BackingPhotoID _tmp106_ = {0};
		BackingPhotoID _tmp107_ = {0};
		PhotoRow* _tmp108_ = NULL;
		BackingPhotoID* _tmp109_ = NULL;
		gint _tmp109__length1 = 0;
		sqlite3_stmt* _tmp110_ = NULL;
		gint64 _tmp111_ = 0LL;
		BackingPhotoID _tmp112_ = {0};
		BackingPhotoID _tmp113_ = {0};
		PhotoRow* _tmp114_ = NULL;
		BackingPhotoID* _tmp115_ = NULL;
		gint _tmp115__length1 = 0;
		sqlite3_stmt* _tmp116_ = NULL;
		gint64 _tmp117_ = 0LL;
		BackingPhotoID _tmp118_ = {0};
		BackingPhotoID _tmp119_ = {0};
		PhotoRow* _tmp120_ = NULL;
		sqlite3_stmt* _tmp121_ = NULL;
		const gchar* _tmp122_ = NULL;
		gchar* _tmp123_ = NULL;
		PhotoRow* _tmp124_ = NULL;
		GeeArrayList* _tmp125_ = NULL;
		PhotoRow* _tmp126_ = NULL;
#line 444 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp5_ = stmt;
#line 444 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp6_ = sqlite3_step (_tmp5_);
#line 444 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		res = _tmp6_;
#line 444 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp7_ = res;
#line 444 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (!(_tmp7_ == SQLITE_ROW)) {
#line 444 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			break;
#line 3353 "PhotoTable.c"
		}
#line 445 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp8_ = photo_row_new ();
#line 445 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		row = _tmp8_;
#line 446 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp9_ = row;
#line 446 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp10_ = stmt;
#line 446 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp11_ = sqlite3_column_int64 (_tmp10_, 0);
#line 446 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp9_->photo_id.id = _tmp11_;
#line 447 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp12_ = row;
#line 447 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp13_ = _tmp12_->master;
#line 447 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp14_ = stmt;
#line 447 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp15_ = sqlite3_column_text (_tmp14_, 1);
#line 447 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp16_ = g_strdup (_tmp15_);
#line 447 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (_tmp13_->filepath);
#line 447 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp13_->filepath = _tmp16_;
#line 448 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp17_ = row;
#line 448 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp18_ = _tmp17_->master;
#line 448 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp19_ = stmt;
#line 448 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp20_ = sqlite3_column_int (_tmp19_, 2);
#line 448 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp21_ = stmt;
#line 448 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp22_ = sqlite3_column_int (_tmp21_, 3);
#line 448 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		dimensions_init (&_tmp18_->dim, _tmp20_, _tmp22_);
#line 449 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp23_ = row;
#line 449 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp24_ = _tmp23_->master;
#line 449 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp25_ = stmt;
#line 449 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp26_ = sqlite3_column_int64 (_tmp25_, 4);
#line 449 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp24_->filesize = _tmp26_;
#line 450 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp27_ = row;
#line 450 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp28_ = _tmp27_->master;
#line 450 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp29_ = stmt;
#line 450 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp30_ = sqlite3_column_int64 (_tmp29_, 5);
#line 450 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp28_->timestamp = (time_t) _tmp30_;
#line 451 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp31_ = row;
#line 451 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp32_ = stmt;
#line 451 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp33_ = sqlite3_column_int64 (_tmp32_, 6);
#line 451 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp31_->exposure_time = (time_t) _tmp33_;
#line 452 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp34_ = row;
#line 452 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp35_ = stmt;
#line 452 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp36_ = sqlite3_column_int (_tmp35_, 7);
#line 452 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp34_->orientation = (Orientation) _tmp36_;
#line 453 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp37_ = row;
#line 453 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp38_ = _tmp37_->master;
#line 453 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp39_ = stmt;
#line 453 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp40_ = sqlite3_column_int (_tmp39_, 8);
#line 453 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp38_->original_orientation = (Orientation) _tmp40_;
#line 454 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp41_ = row;
#line 454 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp42_ = stmt;
#line 454 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp43_ = sqlite3_column_int64 (_tmp42_, 9);
#line 454 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp41_->import_id.id = _tmp43_;
#line 455 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp44_ = row;
#line 455 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp45_ = stmt;
#line 455 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp46_ = sqlite3_column_int64 (_tmp45_, 10);
#line 455 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp44_->event_id.id = _tmp46_;
#line 456 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp47_ = row;
#line 456 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp48_ = stmt;
#line 456 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp49_ = sqlite3_column_text (_tmp48_, 11);
#line 456 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp50_ = photo_table_marshall_all_transformations (_tmp49_);
#line 456 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_object_unref0 (_tmp47_->transformations);
#line 456 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp47_->transformations = _tmp50_;
#line 457 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp51_ = row;
#line 457 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp52_ = stmt;
#line 457 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp53_ = sqlite3_column_text (_tmp52_, 12);
#line 457 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp54_ = g_strdup (_tmp53_);
#line 457 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (_tmp51_->md5);
#line 457 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp51_->md5 = _tmp54_;
#line 458 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp55_ = row;
#line 458 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp56_ = stmt;
#line 458 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp57_ = sqlite3_column_text (_tmp56_, 13);
#line 458 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp58_ = g_strdup (_tmp57_);
#line 458 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (_tmp55_->thumbnail_md5);
#line 458 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp55_->thumbnail_md5 = _tmp58_;
#line 459 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp59_ = row;
#line 459 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp60_ = stmt;
#line 459 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp61_ = sqlite3_column_text (_tmp60_, 14);
#line 459 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp62_ = g_strdup (_tmp61_);
#line 459 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (_tmp59_->exif_md5);
#line 459 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp59_->exif_md5 = _tmp62_;
#line 460 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp63_ = row;
#line 460 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp64_ = stmt;
#line 460 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp65_ = sqlite3_column_int64 (_tmp64_, 15);
#line 460 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp63_->time_created = (time_t) _tmp65_;
#line 461 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp66_ = row;
#line 461 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp67_ = stmt;
#line 461 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp68_ = sqlite3_column_int64 (_tmp67_, 16);
#line 461 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp66_->flags = (guint64) _tmp68_;
#line 462 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp69_ = row;
#line 462 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp70_ = stmt;
#line 462 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp71_ = sqlite3_column_int (_tmp70_, 17);
#line 462 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp72_ = rating_unserialize (_tmp71_);
#line 462 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp69_->rating = _tmp72_;
#line 463 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp73_ = row;
#line 463 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp74_ = _tmp73_->master;
#line 463 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp75_ = stmt;
#line 463 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp76_ = sqlite3_column_int (_tmp75_, 18);
#line 463 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp77_ = photo_file_format_unserialize (_tmp76_);
#line 463 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp74_->file_format = _tmp77_;
#line 464 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp78_ = row;
#line 464 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp79_ = stmt;
#line 464 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp80_ = sqlite3_column_text (_tmp79_, 19);
#line 464 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp81_ = g_strdup (_tmp80_);
#line 464 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (_tmp78_->title);
#line 464 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp78_->title = _tmp81_;
#line 465 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp82_ = row;
#line 465 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp83_ = stmt;
#line 465 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp84_ = sqlite3_column_text (_tmp83_, 20);
#line 465 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp85_ = g_strdup (_tmp84_);
#line 465 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (_tmp82_->backlinks);
#line 465 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp82_->backlinks = _tmp85_;
#line 466 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp86_ = row;
#line 466 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp87_ = stmt;
#line 466 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp88_ = sqlite3_column_int64 (_tmp87_, 21);
#line 466 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp86_->time_reimported = (time_t) _tmp88_;
#line 467 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp89_ = row;
#line 467 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp90_ = stmt;
#line 467 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp91_ = sqlite3_column_int64 (_tmp90_, 22);
#line 467 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		backing_photo_id_init (&_tmp89_->editable_id, _tmp91_);
#line 468 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp92_ = row;
#line 468 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp93_ = stmt;
#line 468 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp94_ = sqlite3_column_int (_tmp93_, 23);
#line 468 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp92_->metadata_dirty = _tmp94_ != 0;
#line 469 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp96_ = stmt;
#line 469 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp97_ = sqlite3_column_text (_tmp96_, 24);
#line 469 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_tmp97_ != NULL) {
#line 3597 "PhotoTable.c"
			sqlite3_stmt* _tmp98_ = NULL;
			const gchar* _tmp99_ = NULL;
			RawDeveloper _tmp100_ = 0;
#line 469 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp98_ = stmt;
#line 469 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp99_ = sqlite3_column_text (_tmp98_, 24);
#line 469 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp100_ = raw_developer_from_string (_tmp99_);
#line 469 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp95_ = _tmp100_;
#line 3609 "PhotoTable.c"
		} else {
#line 470 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp95_ = RAW_DEVELOPER_CAMERA;
#line 3613 "PhotoTable.c"
		}
#line 469 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp101_ = row;
#line 469 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp101_->developer = _tmp95_;
#line 471 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp102_ = row;
#line 471 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp103_ = _tmp102_->development_ids;
#line 471 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp103__length1 = _tmp102_->development_ids_length1;
#line 471 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp104_ = stmt;
#line 471 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp105_ = sqlite3_column_int64 (_tmp104_, 25);
#line 471 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		backing_photo_id_init (&_tmp106_, _tmp105_);
#line 471 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp103_[RAW_DEVELOPER_SHOTWELL] = _tmp106_;
#line 471 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp107_ = _tmp103_[RAW_DEVELOPER_SHOTWELL];
#line 472 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp108_ = row;
#line 472 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp109_ = _tmp108_->development_ids;
#line 472 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp109__length1 = _tmp108_->development_ids_length1;
#line 472 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp110_ = stmt;
#line 472 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp111_ = sqlite3_column_int64 (_tmp110_, 26);
#line 472 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		backing_photo_id_init (&_tmp112_, _tmp111_);
#line 472 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp109_[RAW_DEVELOPER_CAMERA] = _tmp112_;
#line 472 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp113_ = _tmp109_[RAW_DEVELOPER_CAMERA];
#line 473 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp114_ = row;
#line 473 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp115_ = _tmp114_->development_ids;
#line 473 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp115__length1 = _tmp114_->development_ids_length1;
#line 473 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp116_ = stmt;
#line 473 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp117_ = sqlite3_column_int64 (_tmp116_, 27);
#line 473 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		backing_photo_id_init (&_tmp118_, _tmp117_);
#line 473 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp115_[RAW_DEVELOPER_EMBEDDED] = _tmp118_;
#line 473 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp119_ = _tmp115_[RAW_DEVELOPER_EMBEDDED];
#line 474 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp120_ = row;
#line 474 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp121_ = stmt;
#line 474 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp122_ = sqlite3_column_text (_tmp121_, 28);
#line 474 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp123_ = g_strdup (_tmp122_);
#line 474 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (_tmp120_->comment);
#line 474 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp120_->comment = _tmp123_;
#line 476 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp124_ = row;
#line 476 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		photo_table_validate_orientation (self, _tmp124_);
#line 478 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp125_ = all;
#line 478 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp126_ = row;
#line 478 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp125_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp126_);
#line 444 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_photo_row_unref0 (row);
#line 3691 "PhotoTable.c"
	}
#line 481 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = all;
#line 481 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 481 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 3699 "PhotoTable.c"
}


void photo_table_duplicate (PhotoTable* self, PhotoID* photo_id, const gchar* new_filename, BackingPhotoID* editable_id, BackingPhotoID* develop_shotwell, BackingPhotoID* develop_camera_id, BackingPhotoID* develop_embedded_id, PhotoID* result) {
	PhotoRow* original = NULL;
	PhotoID _tmp0_ = {0};
	PhotoRow* _tmp1_ = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp2_ = NULL;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	sqlite3_stmt* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GDestroyNotify _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	sqlite3_stmt* _tmp12_ = NULL;
	PhotoRow* _tmp13_ = NULL;
	BackingPhotoRow* _tmp14_ = NULL;
	Dimensions _tmp15_ = {0};
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	sqlite3_stmt* _tmp19_ = NULL;
	PhotoRow* _tmp20_ = NULL;
	BackingPhotoRow* _tmp21_ = NULL;
	Dimensions _tmp22_ = {0};
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	sqlite3_stmt* _tmp26_ = NULL;
	PhotoRow* _tmp27_ = NULL;
	BackingPhotoRow* _tmp28_ = NULL;
	gint64 _tmp29_ = 0LL;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	sqlite3_stmt* _tmp32_ = NULL;
	PhotoRow* _tmp33_ = NULL;
	BackingPhotoRow* _tmp34_ = NULL;
	time_t _tmp35_ = 0;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	sqlite3_stmt* _tmp38_ = NULL;
	PhotoRow* _tmp39_ = NULL;
	time_t _tmp40_ = 0;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	sqlite3_stmt* _tmp43_ = NULL;
	PhotoRow* _tmp44_ = NULL;
	Orientation _tmp45_ = 0;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	sqlite3_stmt* _tmp48_ = NULL;
	PhotoRow* _tmp49_ = NULL;
	BackingPhotoRow* _tmp50_ = NULL;
	Orientation _tmp51_ = 0;
	gint _tmp52_ = 0;
	gint _tmp53_ = 0;
	sqlite3_stmt* _tmp54_ = NULL;
	PhotoRow* _tmp55_ = NULL;
	ImportID _tmp56_ = {0};
	gint64 _tmp57_ = 0LL;
	gint _tmp58_ = 0;
	gint _tmp59_ = 0;
	sqlite3_stmt* _tmp60_ = NULL;
	PhotoRow* _tmp61_ = NULL;
	EventID _tmp62_ = {0};
	gint64 _tmp63_ = 0LL;
	gint _tmp64_ = 0;
	gint _tmp65_ = 0;
	sqlite3_stmt* _tmp66_ = NULL;
	PhotoRow* _tmp67_ = NULL;
	GeeHashMap* _tmp68_ = NULL;
	gchar* _tmp69_ = NULL;
	GDestroyNotify _tmp70_ = NULL;
	gint _tmp71_ = 0;
	gint _tmp72_ = 0;
	sqlite3_stmt* _tmp73_ = NULL;
	PhotoRow* _tmp74_ = NULL;
	const gchar* _tmp75_ = NULL;
	gchar* _tmp76_ = NULL;
	GDestroyNotify _tmp77_ = NULL;
	gint _tmp78_ = 0;
	gint _tmp79_ = 0;
	sqlite3_stmt* _tmp80_ = NULL;
	PhotoRow* _tmp81_ = NULL;
	const gchar* _tmp82_ = NULL;
	gchar* _tmp83_ = NULL;
	GDestroyNotify _tmp84_ = NULL;
	gint _tmp85_ = 0;
	gint _tmp86_ = 0;
	sqlite3_stmt* _tmp87_ = NULL;
	PhotoRow* _tmp88_ = NULL;
	const gchar* _tmp89_ = NULL;
	gchar* _tmp90_ = NULL;
	GDestroyNotify _tmp91_ = NULL;
	gint _tmp92_ = 0;
	gint _tmp93_ = 0;
	sqlite3_stmt* _tmp94_ = NULL;
	gulong _tmp95_ = 0UL;
	gint _tmp96_ = 0;
	gint _tmp97_ = 0;
	sqlite3_stmt* _tmp98_ = NULL;
	PhotoRow* _tmp99_ = NULL;
	guint64 _tmp100_ = 0ULL;
	gint _tmp101_ = 0;
	gint _tmp102_ = 0;
	sqlite3_stmt* _tmp103_ = NULL;
	PhotoRow* _tmp104_ = NULL;
	Rating _tmp105_ = 0;
	gint _tmp106_ = 0;
	gint _tmp107_ = 0;
	gint _tmp108_ = 0;
	sqlite3_stmt* _tmp109_ = NULL;
	PhotoRow* _tmp110_ = NULL;
	BackingPhotoRow* _tmp111_ = NULL;
	PhotoFileFormat _tmp112_ = 0;
	gint _tmp113_ = 0;
	gint _tmp114_ = 0;
	gint _tmp115_ = 0;
	sqlite3_stmt* _tmp116_ = NULL;
	PhotoRow* _tmp117_ = NULL;
	const gchar* _tmp118_ = NULL;
	gchar* _tmp119_ = NULL;
	GDestroyNotify _tmp120_ = NULL;
	gint _tmp121_ = 0;
	gint _tmp122_ = 0;
	sqlite3_stmt* _tmp123_ = NULL;
	BackingPhotoID _tmp124_ = {0};
	gint64 _tmp125_ = 0LL;
	gint _tmp126_ = 0;
	gint _tmp127_ = 0;
	sqlite3_stmt* _tmp128_ = NULL;
	PhotoRow* _tmp129_ = NULL;
	RawDeveloper _tmp130_ = 0;
	gchar* _tmp131_ = NULL;
	GDestroyNotify _tmp132_ = NULL;
	gint _tmp133_ = 0;
	gint _tmp134_ = 0;
	sqlite3_stmt* _tmp135_ = NULL;
	BackingPhotoID _tmp136_ = {0};
	gint64 _tmp137_ = 0LL;
	gint _tmp138_ = 0;
	gint _tmp139_ = 0;
	sqlite3_stmt* _tmp140_ = NULL;
	BackingPhotoID _tmp141_ = {0};
	gint64 _tmp142_ = 0LL;
	gint _tmp143_ = 0;
	gint _tmp144_ = 0;
	sqlite3_stmt* _tmp145_ = NULL;
	BackingPhotoID _tmp146_ = {0};
	gint64 _tmp147_ = 0LL;
	gint _tmp148_ = 0;
	gint _tmp149_ = 0;
	sqlite3_stmt* _tmp150_ = NULL;
	PhotoRow* _tmp151_ = NULL;
	const gchar* _tmp152_ = NULL;
	gchar* _tmp153_ = NULL;
	GDestroyNotify _tmp154_ = NULL;
	gint _tmp155_ = 0;
	gint _tmp156_ = 0;
	sqlite3_stmt* _tmp157_ = NULL;
	gint _tmp158_ = 0;
	gint _tmp159_ = 0;
	sqlite3* _tmp163_ = NULL;
	gint64 _tmp164_ = 0LL;
	PhotoID _tmp165_ = {0};
#line 486 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 486 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (photo_id != NULL);
#line 486 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (new_filename != NULL);
#line 486 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (editable_id != NULL);
#line 486 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (develop_shotwell != NULL);
#line 486 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (develop_camera_id != NULL);
#line 486 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (develop_embedded_id != NULL);
#line 490 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 490 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = photo_table_get_row (self, &_tmp0_);
#line 490 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	original = _tmp1_;
#line 493 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = database_table_db;
#line 493 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = sqlite3_prepare_v2 (_tmp2_, "INSERT INTO PhotoTable (filename, width, height, filesize, " "timestamp, exposure_time, orientation, original_orientation, import_id" \
", event_id, " "transformations, md5, thumbnail_md5, exif_md5, time_created, flags, ra" \
"ting, " "file_format, title, editable_id, developer, develop_shotwell_id, devel" \
"op_camera_id, " "develop_embedded_id, comment) " "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?," \
" ?, ?, ?, ?)", -1, &_tmp3_, NULL);
#line 493 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 493 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp3_;
#line 493 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp4_;
#line 500 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = res;
#line 500 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp5_ == SQLITE_OK, "res == Sqlite.OK");
#line 502 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = stmt;
#line 502 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = new_filename;
#line 502 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 502 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = g_free;
#line 502 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = sqlite3_bind_text (_tmp6_, 1, _tmp8_, -1, _tmp9_);
#line 502 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp10_;
#line 503 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = res;
#line 503 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp11_ == SQLITE_OK, "res == Sqlite.OK");
#line 504 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = stmt;
#line 504 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_ = original;
#line 504 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = _tmp13_->master;
#line 504 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_ = _tmp14_->dim;
#line 504 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp16_ = _tmp15_.width;
#line 504 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp17_ = sqlite3_bind_int (_tmp12_, 2, _tmp16_);
#line 504 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp17_;
#line 505 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp18_ = res;
#line 505 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp18_ == SQLITE_OK, "res == Sqlite.OK");
#line 506 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp19_ = stmt;
#line 506 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp20_ = original;
#line 506 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp21_ = _tmp20_->master;
#line 506 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp22_ = _tmp21_->dim;
#line 506 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp23_ = _tmp22_.height;
#line 506 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp24_ = sqlite3_bind_int (_tmp19_, 3, _tmp23_);
#line 506 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp24_;
#line 507 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp25_ = res;
#line 507 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp25_ == SQLITE_OK, "res == Sqlite.OK");
#line 508 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp26_ = stmt;
#line 508 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp27_ = original;
#line 508 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp28_ = _tmp27_->master;
#line 508 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp29_ = _tmp28_->filesize;
#line 508 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp30_ = sqlite3_bind_int64 (_tmp26_, 4, _tmp29_);
#line 508 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp30_;
#line 509 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp31_ = res;
#line 509 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp31_ == SQLITE_OK, "res == Sqlite.OK");
#line 510 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp32_ = stmt;
#line 510 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp33_ = original;
#line 510 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp34_ = _tmp33_->master;
#line 510 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp35_ = _tmp34_->timestamp;
#line 510 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp36_ = sqlite3_bind_int64 (_tmp32_, 5, (gint64) _tmp35_);
#line 510 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp36_;
#line 511 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp37_ = res;
#line 511 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp37_ == SQLITE_OK, "res == Sqlite.OK");
#line 512 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp38_ = stmt;
#line 512 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp39_ = original;
#line 512 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp40_ = _tmp39_->exposure_time;
#line 512 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp41_ = sqlite3_bind_int64 (_tmp38_, 6, (gint64) _tmp40_);
#line 512 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp41_;
#line 513 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp42_ = res;
#line 513 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp42_ == SQLITE_OK, "res == Sqlite.OK");
#line 514 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp43_ = stmt;
#line 514 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp44_ = original;
#line 514 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp45_ = _tmp44_->orientation;
#line 514 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp46_ = sqlite3_bind_int (_tmp43_, 7, (gint) _tmp45_);
#line 514 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp46_;
#line 515 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp47_ = res;
#line 515 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp47_ == SQLITE_OK, "res == Sqlite.OK");
#line 516 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp48_ = stmt;
#line 516 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp49_ = original;
#line 516 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp50_ = _tmp49_->master;
#line 516 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp51_ = _tmp50_->original_orientation;
#line 516 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp52_ = sqlite3_bind_int (_tmp48_, 8, (gint) _tmp51_);
#line 516 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp52_;
#line 517 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp53_ = res;
#line 517 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp53_ == SQLITE_OK, "res == Sqlite.OK");
#line 518 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp54_ = stmt;
#line 518 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp55_ = original;
#line 518 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp56_ = _tmp55_->import_id;
#line 518 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp57_ = _tmp56_.id;
#line 518 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp58_ = sqlite3_bind_int64 (_tmp54_, 9, _tmp57_);
#line 518 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp58_;
#line 519 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp59_ = res;
#line 519 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp59_ == SQLITE_OK, "res == Sqlite.OK");
#line 520 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp60_ = stmt;
#line 520 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp61_ = original;
#line 520 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp62_ = _tmp61_->event_id;
#line 520 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp63_ = _tmp62_.id;
#line 520 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp64_ = sqlite3_bind_int64 (_tmp60_, 10, _tmp63_);
#line 520 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp64_;
#line 521 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp65_ = res;
#line 521 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp65_ == SQLITE_OK, "res == Sqlite.OK");
#line 522 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp66_ = stmt;
#line 522 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp67_ = original;
#line 522 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp68_ = _tmp67_->transformations;
#line 522 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp69_ = photo_table_unmarshall_all_transformations (_tmp68_);
#line 522 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp70_ = g_free;
#line 522 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp71_ = sqlite3_bind_text (_tmp66_, 11, _tmp69_, -1, _tmp70_);
#line 522 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp71_;
#line 523 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp72_ = res;
#line 523 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp72_ == SQLITE_OK, "res == Sqlite.OK");
#line 524 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp73_ = stmt;
#line 524 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp74_ = original;
#line 524 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp75_ = _tmp74_->md5;
#line 524 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp76_ = g_strdup (_tmp75_);
#line 524 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp77_ = g_free;
#line 524 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp78_ = sqlite3_bind_text (_tmp73_, 12, _tmp76_, -1, _tmp77_);
#line 524 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp78_;
#line 525 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp79_ = res;
#line 525 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp79_ == SQLITE_OK, "res == Sqlite.OK");
#line 526 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp80_ = stmt;
#line 526 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp81_ = original;
#line 526 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp82_ = _tmp81_->thumbnail_md5;
#line 526 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp83_ = g_strdup (_tmp82_);
#line 526 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp84_ = g_free;
#line 526 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp85_ = sqlite3_bind_text (_tmp80_, 13, _tmp83_, -1, _tmp84_);
#line 526 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp85_;
#line 527 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp86_ = res;
#line 527 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp86_ == SQLITE_OK, "res == Sqlite.OK");
#line 528 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp87_ = stmt;
#line 528 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp88_ = original;
#line 528 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp89_ = _tmp88_->exif_md5;
#line 528 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp90_ = g_strdup (_tmp89_);
#line 528 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp91_ = g_free;
#line 528 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp92_ = sqlite3_bind_text (_tmp87_, 14, _tmp90_, -1, _tmp91_);
#line 528 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp92_;
#line 529 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp93_ = res;
#line 529 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp93_ == SQLITE_OK, "res == Sqlite.OK");
#line 530 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp94_ = stmt;
#line 530 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp95_ = now_sec ();
#line 530 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp96_ = sqlite3_bind_int64 (_tmp94_, 15, (gint64) _tmp95_);
#line 530 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp96_;
#line 531 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp97_ = res;
#line 531 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp97_ == SQLITE_OK, "res == Sqlite.OK");
#line 532 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp98_ = stmt;
#line 532 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp99_ = original;
#line 532 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp100_ = _tmp99_->flags;
#line 532 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp101_ = sqlite3_bind_int64 (_tmp98_, 16, (gint64) _tmp100_);
#line 532 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp101_;
#line 533 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp102_ = res;
#line 533 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp102_ == SQLITE_OK, "res == Sqlite.OK");
#line 534 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp103_ = stmt;
#line 534 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp104_ = original;
#line 534 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp105_ = _tmp104_->rating;
#line 534 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp106_ = rating_serialize (_tmp105_);
#line 534 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp107_ = sqlite3_bind_int64 (_tmp103_, 17, (gint64) _tmp106_);
#line 534 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp107_;
#line 535 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp108_ = res;
#line 535 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp108_ == SQLITE_OK, "res == Sqlite.OK");
#line 536 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp109_ = stmt;
#line 536 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp110_ = original;
#line 536 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp111_ = _tmp110_->master;
#line 536 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp112_ = _tmp111_->file_format;
#line 536 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp113_ = photo_file_format_serialize (_tmp112_);
#line 536 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp114_ = sqlite3_bind_int (_tmp109_, 18, _tmp113_);
#line 536 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp114_;
#line 537 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp115_ = res;
#line 537 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp115_ == SQLITE_OK, "res == Sqlite.OK");
#line 538 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp116_ = stmt;
#line 538 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp117_ = original;
#line 538 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp118_ = _tmp117_->title;
#line 538 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp119_ = g_strdup (_tmp118_);
#line 538 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp120_ = g_free;
#line 538 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp121_ = sqlite3_bind_text (_tmp116_, 19, _tmp119_, -1, _tmp120_);
#line 538 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp121_;
#line 539 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp122_ = res;
#line 539 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp122_ == SQLITE_OK, "res == Sqlite.OK");
#line 540 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp123_ = stmt;
#line 540 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp124_ = *editable_id;
#line 540 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp125_ = _tmp124_.id;
#line 540 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp126_ = sqlite3_bind_int64 (_tmp123_, 20, _tmp125_);
#line 540 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp126_;
#line 541 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp127_ = res;
#line 541 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp127_ == SQLITE_OK, "res == Sqlite.OK");
#line 543 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp128_ = stmt;
#line 543 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp129_ = original;
#line 543 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp130_ = _tmp129_->developer;
#line 543 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp131_ = raw_developer_to_string (_tmp130_);
#line 543 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp132_ = g_free;
#line 543 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp133_ = sqlite3_bind_text (_tmp128_, 21, _tmp131_, -1, _tmp132_);
#line 543 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp133_;
#line 544 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp134_ = res;
#line 544 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp134_ == SQLITE_OK, "res == Sqlite.OK");
#line 545 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp135_ = stmt;
#line 545 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp136_ = *develop_shotwell;
#line 545 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp137_ = _tmp136_.id;
#line 545 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp138_ = sqlite3_bind_int64 (_tmp135_, 22, _tmp137_);
#line 545 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp138_;
#line 546 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp139_ = res;
#line 546 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp139_ == SQLITE_OK, "res == Sqlite.OK");
#line 547 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp140_ = stmt;
#line 547 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp141_ = *develop_camera_id;
#line 547 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp142_ = _tmp141_.id;
#line 547 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp143_ = sqlite3_bind_int64 (_tmp140_, 23, _tmp142_);
#line 547 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp143_;
#line 548 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp144_ = res;
#line 548 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp144_ == SQLITE_OK, "res == Sqlite.OK");
#line 549 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp145_ = stmt;
#line 549 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp146_ = *develop_embedded_id;
#line 549 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp147_ = _tmp146_.id;
#line 549 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp148_ = sqlite3_bind_int64 (_tmp145_, 24, _tmp147_);
#line 549 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp148_;
#line 550 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp149_ = res;
#line 550 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp149_ == SQLITE_OK, "res == Sqlite.OK");
#line 551 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp150_ = stmt;
#line 551 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp151_ = original;
#line 551 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp152_ = _tmp151_->comment;
#line 551 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp153_ = g_strdup (_tmp152_);
#line 551 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp154_ = g_free;
#line 551 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp155_ = sqlite3_bind_text (_tmp150_, 25, _tmp153_, -1, _tmp154_);
#line 551 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp155_;
#line 552 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp156_ = res;
#line 552 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp156_ == SQLITE_OK, "res == Sqlite.OK");
#line 554 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp157_ = stmt;
#line 554 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp158_ = sqlite3_step (_tmp157_);
#line 554 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp158_;
#line 555 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp159_ = res;
#line 555 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp159_ != SQLITE_DONE) {
#line 4316 "PhotoTable.c"
		gint _tmp160_ = 0;
		PhotoID _tmp162_ = {0};
#line 556 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp160_ = res;
#line 556 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_tmp160_ != SQLITE_CONSTRAINT) {
#line 4323 "PhotoTable.c"
			gint _tmp161_ = 0;
#line 557 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp161_ = res;
#line 557 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			database_table_fatal ("duplicate", _tmp161_);
#line 4329 "PhotoTable.c"
		}
#line 559 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		photo_id_init (&_tmp162_, PHOTO_ID_INVALID);
#line 559 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		*result = _tmp162_;
#line 559 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 559 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_photo_row_unref0 (original);
#line 559 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return;
#line 4341 "PhotoTable.c"
	}
#line 562 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp163_ = database_table_db;
#line 562 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp164_ = sqlite3_last_insert_rowid (_tmp163_);
#line 562 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	photo_id_init (&_tmp165_, _tmp164_);
#line 562 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	*result = _tmp165_;
#line 562 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 562 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_photo_row_unref0 (original);
#line 562 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return;
#line 4357 "PhotoTable.c"
}


gboolean photo_table_set_title (PhotoTable* self, PhotoID* photo_id, const gchar* new_title) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	PhotoID _tmp3_ = {0};
	gint64 _tmp4_ = 0LL;
	gboolean _tmp5_ = FALSE;
#line 565 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 565 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 566 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = new_title;
#line 566 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp1_ != NULL) {
#line 4376 "PhotoTable.c"
		const gchar* _tmp2_ = NULL;
#line 566 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp2_ = new_title;
#line 566 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = _tmp2_;
#line 4382 "PhotoTable.c"
	} else {
#line 566 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = "";
#line 4386 "PhotoTable.c"
	}
#line 566 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = *photo_id;
#line 566 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = _tmp3_.id;
#line 566 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = database_table_update_text_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp4_, "title", _tmp0_);
#line 566 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp5_;
#line 566 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 4398 "PhotoTable.c"
}


gboolean photo_table_set_comment (PhotoTable* self, PhotoID* photo_id, const gchar* new_comment) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	PhotoID _tmp3_ = {0};
	gint64 _tmp4_ = 0LL;
	gboolean _tmp5_ = FALSE;
#line 569 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 569 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 570 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = new_comment;
#line 570 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp1_ != NULL) {
#line 4417 "PhotoTable.c"
		const gchar* _tmp2_ = NULL;
#line 570 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp2_ = new_comment;
#line 570 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = _tmp2_;
#line 4423 "PhotoTable.c"
	} else {
#line 570 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = "";
#line 4427 "PhotoTable.c"
	}
#line 570 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = *photo_id;
#line 570 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = _tmp3_.id;
#line 570 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = database_table_update_text_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp4_, "comment", _tmp0_);
#line 570 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp5_;
#line 570 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 4439 "PhotoTable.c"
}


void photo_table_set_filepath (PhotoTable* self, PhotoID* photo_id, const gchar* filepath, GError** error) {
	PhotoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	const gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 573 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 573 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (photo_id != NULL);
#line 573 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (filepath != NULL);
#line 574 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 574 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 574 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = filepath;
#line 574 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "filename", _tmp2_, &_inner_error_);
#line 574 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 574 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 574 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 574 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 4470 "PhotoTable.c"
		} else {
#line 574 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 574 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 574 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 4478 "PhotoTable.c"
		}
	}
}


void photo_table_update_timestamp (PhotoTable* self, PhotoID* photo_id, time_t timestamp, GError** error) {
	PhotoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	time_t _tmp2_ = 0;
	GError * _inner_error_ = NULL;
#line 577 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 577 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (photo_id != NULL);
#line 578 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 578 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 578 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = timestamp;
#line 578 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "timestamp", (gint64) _tmp2_, &_inner_error_);
#line 578 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 578 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 578 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 578 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 4509 "PhotoTable.c"
		} else {
#line 578 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 578 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 578 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 4517 "PhotoTable.c"
		}
	}
}


gboolean photo_table_set_exposure_time (PhotoTable* self, PhotoID* photo_id, time_t time) {
	gboolean result = FALSE;
	PhotoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	time_t _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
#line 581 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 581 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 582 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 582 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 582 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = time;
#line 582 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = database_table_update_int64_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "exposure_time", (gint64) _tmp2_);
#line 582 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp3_;
#line 582 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 4545 "PhotoTable.c"
}


void photo_table_set_import_id (PhotoTable* self, PhotoID* photo_id, ImportID* import_id, GError** error) {
	PhotoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	ImportID _tmp2_ = {0};
	gint64 _tmp3_ = 0LL;
	GError * _inner_error_ = NULL;
#line 585 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 585 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (photo_id != NULL);
#line 585 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (import_id != NULL);
#line 586 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 586 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 586 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = *import_id;
#line 586 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = _tmp2_.id;
#line 586 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "import_id", _tmp3_, &_inner_error_);
#line 586 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 586 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 586 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 586 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 4579 "PhotoTable.c"
		} else {
#line 586 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 586 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 586 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 4587 "PhotoTable.c"
		}
	}
}


gboolean photo_table_remove_by_file (PhotoTable* self, GFile* file) {
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GDestroyNotify _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	sqlite3_stmt* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
#line 589 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 589 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 591 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 591 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "DELETE FROM PhotoTable WHERE filename=?", -1, &_tmp1_, NULL);
#line 591 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 591 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 591 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 592 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 592 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 594 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 594 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = file;
#line 594 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = g_file_get_path (_tmp5_);
#line 594 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = g_free;
#line 594 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = sqlite3_bind_text (_tmp4_, 1, _tmp6_, -1, _tmp7_);
#line 594 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp8_;
#line 595 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = res;
#line 595 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp9_ == SQLITE_OK, "res == Sqlite.OK");
#line 597 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = stmt;
#line 597 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = sqlite3_step (_tmp10_);
#line 597 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp11_;
#line 598 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = res;
#line 598 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp12_ != SQLITE_DONE) {
#line 4654 "PhotoTable.c"
		gint _tmp13_ = 0;
#line 599 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp13_ = res;
#line 599 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_warning ("remove", _tmp13_);
#line 601 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = FALSE;
#line 601 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 601 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 4666 "PhotoTable.c"
	}
#line 604 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = TRUE;
#line 604 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 604 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 4674 "PhotoTable.c"
}


void photo_table_remove (PhotoTable* self, PhotoID* photo_id, GError** error) {
	PhotoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	GError * _inner_error_ = NULL;
#line 607 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 607 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (photo_id != NULL);
#line 608 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 608 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 608 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_delete_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, &_inner_error_);
#line 608 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 608 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 608 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 608 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 4700 "PhotoTable.c"
		} else {
#line 608 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 608 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 608 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 4708 "PhotoTable.c"
		}
	}
}


GeeArrayList* photo_table_get_photos (PhotoTable* self) {
	GeeArrayList* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GeeArrayList* photo_ids = NULL;
	GeeArrayList* _tmp4_ = NULL;
#line 611 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), NULL);
#line 613 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 613 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id FROM PhotoTable", -1, &_tmp1_, NULL);
#line 613 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 613 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 613 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 614 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 614 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 616 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = gee_array_list_new (TYPE_PHOTO_ID, (GBoxedCopyFunc) photo_id_dup, photo_id_free, NULL, NULL, NULL);
#line 616 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	photo_ids = _tmp4_;
#line 4744 "PhotoTable.c"
	{
		gboolean _tmp5_ = FALSE;
#line 617 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp5_ = TRUE;
#line 617 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		while (TRUE) {
#line 4751 "PhotoTable.c"
			sqlite3_stmt* _tmp6_ = NULL;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			GeeArrayList* _tmp11_ = NULL;
			sqlite3_stmt* _tmp12_ = NULL;
			gint64 _tmp13_ = 0LL;
			PhotoID _tmp14_ = {0};
#line 617 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (!_tmp5_) {
#line 4761 "PhotoTable.c"
			}
#line 617 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp5_ = FALSE;
#line 618 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp6_ = stmt;
#line 618 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp7_ = sqlite3_step (_tmp6_);
#line 618 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			res = _tmp7_;
#line 619 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp8_ = res;
#line 619 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (_tmp8_ == SQLITE_DONE) {
#line 620 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				break;
#line 4777 "PhotoTable.c"
			} else {
				gint _tmp9_ = 0;
#line 621 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp9_ = res;
#line 621 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				if (_tmp9_ != SQLITE_ROW) {
#line 4784 "PhotoTable.c"
					gint _tmp10_ = 0;
#line 622 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp10_ = res;
#line 622 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					database_table_fatal ("get_photos", _tmp10_);
#line 624 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					break;
#line 4792 "PhotoTable.c"
				}
			}
#line 627 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp11_ = photo_ids;
#line 627 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp12_ = stmt;
#line 627 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp13_ = sqlite3_column_int64 (_tmp12_, 0);
#line 627 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			photo_id_init (&_tmp14_, _tmp13_);
#line 627 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), &_tmp14_);
#line 4805 "PhotoTable.c"
		}
	}
#line 630 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = photo_ids;
#line 630 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 630 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 4814 "PhotoTable.c"
}


gboolean photo_table_set_orientation (PhotoTable* self, PhotoID* photo_id, Orientation orientation) {
	gboolean result = FALSE;
	PhotoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	Orientation _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
#line 633 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 633 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 634 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 634 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 634 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = orientation;
#line 634 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = database_table_update_int_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "orientation", (gint) _tmp2_);
#line 634 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp3_;
#line 634 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 4840 "PhotoTable.c"
}


gboolean photo_table_replace_flags (PhotoTable* self, PhotoID* photo_id, guint64 flags) {
	gboolean result = FALSE;
	PhotoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	guint64 _tmp2_ = 0ULL;
	gboolean _tmp3_ = FALSE;
#line 637 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 637 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 638 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 638 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 638 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = flags;
#line 638 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = database_table_update_int64_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "flags", (gint64) _tmp2_);
#line 638 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp3_;
#line 638 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 4866 "PhotoTable.c"
}


gboolean photo_table_set_rating (PhotoTable* self, PhotoID* photo_id, Rating rating) {
	gboolean result = FALSE;
	PhotoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	Rating _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
#line 641 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 641 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 642 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 642 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 642 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = rating;
#line 642 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = rating_serialize (_tmp2_);
#line 642 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = database_table_update_int_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "rating", _tmp3_);
#line 642 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp4_;
#line 642 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 4895 "PhotoTable.c"
}


gint photo_table_get_event_photo_count (PhotoTable* self, EventID* event_id) {
	gint result = 0;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	EventID _tmp5_ = {0};
	gint64 _tmp6_ = 0LL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint count = 0;
#line 645 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), 0);
#line 645 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (event_id != NULL, 0);
#line 647 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 647 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id FROM PhotoTable WHERE event_id = ?", -1, &_tmp1_, NULL);
#line 647 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 647 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 647 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 648 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 648 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 650 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 650 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = *event_id;
#line 650 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = _tmp5_.id;
#line 650 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = sqlite3_bind_int64 (_tmp4_, 1, _tmp6_);
#line 650 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp7_;
#line 651 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = res;
#line 651 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp8_ == SQLITE_OK, "res == Sqlite.OK");
#line 653 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	count = 0;
#line 4947 "PhotoTable.c"
	{
		gboolean _tmp9_ = FALSE;
#line 654 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp9_ = TRUE;
#line 654 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		while (TRUE) {
#line 4954 "PhotoTable.c"
			sqlite3_stmt* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			gint _tmp15_ = 0;
#line 654 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (!_tmp9_) {
#line 4961 "PhotoTable.c"
			}
#line 654 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp9_ = FALSE;
#line 655 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp10_ = stmt;
#line 655 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp11_ = sqlite3_step (_tmp10_);
#line 655 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			res = _tmp11_;
#line 656 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp12_ = res;
#line 656 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (_tmp12_ == SQLITE_DONE) {
#line 657 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				break;
#line 4977 "PhotoTable.c"
			} else {
				gint _tmp13_ = 0;
#line 658 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp13_ = res;
#line 658 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				if (_tmp13_ != SQLITE_ROW) {
#line 4984 "PhotoTable.c"
					gint _tmp14_ = 0;
#line 659 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp14_ = res;
#line 659 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					database_table_fatal ("get_event_photo_count", _tmp14_);
#line 661 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					break;
#line 4992 "PhotoTable.c"
				}
			}
#line 664 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp15_ = count;
#line 664 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			count = _tmp15_ + 1;
#line 4999 "PhotoTable.c"
		}
	}
#line 667 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = count;
#line 667 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 667 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 5008 "PhotoTable.c"
}


GeeArrayList* photo_table_get_event_source_ids (PhotoTable* self, EventID* event_id) {
	GeeArrayList* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	EventID _tmp5_ = {0};
	gint64 _tmp6_ = 0LL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp9_ = NULL;
#line 670 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), NULL);
#line 670 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (event_id != NULL, NULL);
#line 672 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 672 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id FROM PhotoTable WHERE event_id = ?", -1, &_tmp1_, NULL);
#line 672 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 672 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 672 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 673 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 673 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 675 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 675 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = *event_id;
#line 675 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = _tmp5_.id;
#line 675 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = sqlite3_bind_int64 (_tmp4_, 1, _tmp6_);
#line 675 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp7_;
#line 676 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = res;
#line 676 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp8_ == SQLITE_OK, "res == Sqlite.OK");
#line 678 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 678 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_result_ = _tmp9_;
#line 5063 "PhotoTable.c"
	{
		gboolean _tmp10_ = FALSE;
#line 679 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp10_ = TRUE;
#line 679 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		while (TRUE) {
#line 5070 "PhotoTable.c"
			sqlite3_stmt* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			GeeArrayList* _tmp16_ = NULL;
			sqlite3_stmt* _tmp17_ = NULL;
			gint64 _tmp18_ = 0LL;
			PhotoID _tmp19_ = {0};
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
#line 679 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (!_tmp10_) {
#line 5082 "PhotoTable.c"
			}
#line 679 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp10_ = FALSE;
#line 680 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp11_ = stmt;
#line 680 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp12_ = sqlite3_step (_tmp11_);
#line 680 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			res = _tmp12_;
#line 681 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp13_ = res;
#line 681 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (_tmp13_ == SQLITE_DONE) {
#line 682 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				break;
#line 5098 "PhotoTable.c"
			} else {
				gint _tmp14_ = 0;
#line 683 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp14_ = res;
#line 683 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				if (_tmp14_ != SQLITE_ROW) {
#line 5105 "PhotoTable.c"
					gint _tmp15_ = 0;
#line 684 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp15_ = res;
#line 684 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					database_table_fatal ("get_event_source_ids", _tmp15_);
#line 686 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					break;
#line 5113 "PhotoTable.c"
				}
			}
#line 689 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp16_ = _result_;
#line 689 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp17_ = stmt;
#line 689 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp18_ = sqlite3_column_int64 (_tmp17_, 0);
#line 689 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			photo_id_init (&_tmp19_, _tmp18_);
#line 689 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp20_ = photo_id_upgrade_photo_id_to_source_id (&_tmp19_);
#line 689 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp21_ = _tmp20_;
#line 689 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp21_);
#line 689 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (_tmp21_);
#line 5132 "PhotoTable.c"
		}
	}
#line 692 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _result_;
#line 692 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 692 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 5141 "PhotoTable.c"
}


gboolean photo_table_event_has_photos (PhotoTable* self, EventID* event_id) {
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	EventID _tmp5_ = {0};
	gint64 _tmp6_ = 0LL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	sqlite3_stmt* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
#line 695 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 695 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (event_id != NULL, FALSE);
#line 697 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 697 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id FROM PhotoTable WHERE event_id = ? LIMIT 1", -1, &_tmp1_, NULL);
#line 697 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 697 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 697 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 698 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 698 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 700 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 700 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = *event_id;
#line 700 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = _tmp5_.id;
#line 700 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = sqlite3_bind_int64 (_tmp4_, 1, _tmp6_);
#line 700 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp7_;
#line 701 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = res;
#line 701 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp8_ == SQLITE_OK, "res == Sqlite.OK");
#line 703 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = stmt;
#line 703 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = sqlite3_step (_tmp9_);
#line 703 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp10_;
#line 704 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = res;
#line 704 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp11_ == SQLITE_DONE) {
#line 705 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = FALSE;
#line 705 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 705 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 5209 "PhotoTable.c"
	} else {
		gint _tmp12_ = 0;
#line 706 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp12_ = res;
#line 706 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_tmp12_ != SQLITE_ROW) {
#line 5216 "PhotoTable.c"
			gint _tmp13_ = 0;
#line 707 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp13_ = res;
#line 707 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			database_table_fatal ("event_has_photos", _tmp13_);
#line 709 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			result = FALSE;
#line 709 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_sqlite3_finalize0 (stmt);
#line 709 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return result;
#line 5228 "PhotoTable.c"
		}
	}
#line 712 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = TRUE;
#line 712 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 712 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 5237 "PhotoTable.c"
}


gboolean photo_table_drop_event (PhotoTable* self, EventID* event_id) {
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	sqlite3_stmt* _tmp7_ = NULL;
	EventID _tmp8_ = {0};
	gint64 _tmp9_ = 0LL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	sqlite3_stmt* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
#line 715 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 715 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (event_id != NULL, FALSE);
#line 717 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 717 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE PhotoTable SET event_id = ? WHERE event_id = ?", -1, &_tmp1_, NULL);
#line 717 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 717 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 717 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 718 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 718 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 720 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 720 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = sqlite3_bind_int64 (_tmp4_, 1, EVENT_ID_INVALID);
#line 720 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp5_;
#line 721 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = res;
#line 721 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp6_ == SQLITE_OK, "res == Sqlite.OK");
#line 722 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = stmt;
#line 722 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = *event_id;
#line 722 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = _tmp8_.id;
#line 722 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = sqlite3_bind_int64 (_tmp7_, 2, _tmp9_);
#line 722 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp10_;
#line 723 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = res;
#line 723 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp11_ == SQLITE_OK, "res == Sqlite.OK");
#line 725 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = stmt;
#line 725 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_ = sqlite3_step (_tmp12_);
#line 725 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp13_;
#line 726 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = res;
#line 726 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp14_ != SQLITE_DONE) {
#line 5312 "PhotoTable.c"
		gint _tmp15_ = 0;
#line 727 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp15_ = res;
#line 727 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_fatal ("drop_event", _tmp15_);
#line 729 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = FALSE;
#line 729 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 729 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 5324 "PhotoTable.c"
	}
#line 732 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = TRUE;
#line 732 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 732 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 5332 "PhotoTable.c"
}


gboolean photo_table_set_event (PhotoTable* self, PhotoID* photo_id, EventID* event_id) {
	gboolean result = FALSE;
	PhotoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	EventID _tmp2_ = {0};
	gint64 _tmp3_ = 0LL;
	gboolean _tmp4_ = FALSE;
#line 735 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 735 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 735 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (event_id != NULL, FALSE);
#line 736 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 736 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 736 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = *event_id;
#line 736 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = _tmp2_.id;
#line 736 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = database_table_update_int64_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "event_id", _tmp3_);
#line 736 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp4_;
#line 736 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 5363 "PhotoTable.c"
}


static gchar* photo_table_get_raw_transformations (PhotoTable* self, PhotoID* photo_id) {
	gchar* result = NULL;
	sqlite3_stmt* stmt = NULL;
	PhotoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	sqlite3_stmt* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gchar* trans = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_ = NULL;
#line 739 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), NULL);
#line 739 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, NULL);
#line 741 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 741 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 741 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = database_table_select_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "transformations", &_tmp2_);
#line 741 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 741 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp2_;
#line 741 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (!_tmp3_) {
#line 742 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = NULL;
#line 742 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 742 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 5402 "PhotoTable.c"
	}
#line 744 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 744 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = sqlite3_column_text (_tmp4_, 0);
#line 744 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 744 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	trans = _tmp6_;
#line 745 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = trans;
#line 745 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp8_ == NULL) {
#line 745 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp7_ = TRUE;
#line 5418 "PhotoTable.c"
	} else {
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
#line 745 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp9_ = trans;
#line 745 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp10_ = strlen (_tmp9_);
#line 745 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp11_ = _tmp10_;
#line 745 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp7_ = _tmp11_ == 0;
#line 5431 "PhotoTable.c"
	}
#line 745 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp7_) {
#line 746 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = NULL;
#line 746 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (trans);
#line 746 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 746 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 5443 "PhotoTable.c"
	}
#line 748 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = trans;
#line 748 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 748 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 5451 "PhotoTable.c"
}


static gboolean photo_table_set_raw_transformations (PhotoTable* self, PhotoID* photo_id, const gchar* trans) {
	gboolean result = FALSE;
	PhotoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 751 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 751 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 751 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (trans != NULL, FALSE);
#line 752 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 752 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 752 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = trans;
#line 752 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = database_table_update_text_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "transformations", _tmp2_);
#line 752 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp3_;
#line 752 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 5479 "PhotoTable.c"
}


gboolean photo_table_set_transformation_state (PhotoTable* self, PhotoID* photo_id, Orientation orientation, GeeHashMap* transformations) {
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	Orientation _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	sqlite3_stmt* _tmp8_ = NULL;
	GeeHashMap* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GDestroyNotify _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	sqlite3_stmt* _tmp14_ = NULL;
	PhotoID _tmp15_ = {0};
	gint64 _tmp16_ = 0LL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	sqlite3_stmt* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
#line 755 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 755 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 755 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail ((transformations == NULL) || GEE_IS_HASH_MAP (transformations), FALSE);
#line 758 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 758 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE PhotoTable SET orientation = ?, transformations = ? WHERE id = " \
"?", -1, &_tmp1_, NULL);
#line 758 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 758 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 758 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 760 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 760 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 762 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 762 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = orientation;
#line 762 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = sqlite3_bind_int (_tmp4_, 1, (gint) _tmp5_);
#line 762 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp6_;
#line 763 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = res;
#line 763 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 764 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = stmt;
#line 764 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = transformations;
#line 764 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = photo_table_unmarshall_all_transformations (_tmp9_);
#line 764 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = g_free;
#line 764 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = sqlite3_bind_text (_tmp8_, 2, _tmp10_, -1, _tmp11_);
#line 764 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp12_;
#line 765 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_ = res;
#line 765 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp13_ == SQLITE_OK, "res == Sqlite.OK");
#line 766 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = stmt;
#line 766 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_ = *photo_id;
#line 766 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp16_ = _tmp15_.id;
#line 766 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp17_ = sqlite3_bind_int64 (_tmp14_, 3, _tmp16_);
#line 766 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp17_;
#line 767 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp18_ = res;
#line 767 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp18_ == SQLITE_OK, "res == Sqlite.OK");
#line 769 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp19_ = stmt;
#line 769 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp20_ = sqlite3_step (_tmp19_);
#line 769 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp20_;
#line 770 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp21_ = res;
#line 770 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp21_ != SQLITE_DONE) {
#line 5581 "PhotoTable.c"
		gint _tmp22_ = 0;
#line 771 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp22_ = res;
#line 771 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_fatal ("set_transformation_state", _tmp22_);
#line 773 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = FALSE;
#line 773 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 773 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 5593 "PhotoTable.c"
	}
#line 776 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = TRUE;
#line 776 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 776 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 5601 "PhotoTable.c"
}


GeeHashMap* photo_table_marshall_all_transformations (const gchar* trans) {
	GeeHashMap* result = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 780 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = trans;
#line 780 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp1_ == NULL) {
#line 780 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = TRUE;
#line 5616 "PhotoTable.c"
	} else {
		const gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 780 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp2_ = trans;
#line 780 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp3_ = strlen (_tmp2_);
#line 780 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp4_ = _tmp3_;
#line 780 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = _tmp4_ == 0;
#line 5629 "PhotoTable.c"
	}
#line 780 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp0_) {
#line 781 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = NULL;
#line 781 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 5637 "PhotoTable.c"
	}
	{
		GKeyFile* keyfile = NULL;
		GKeyFile* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		GKeyFile* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gboolean _tmp12_ = FALSE;
		GeeHashMap* map = NULL;
		GeeHashMap* _tmp13_ = NULL;
		gchar** objects = NULL;
		GKeyFile* _tmp14_ = NULL;
		gsize _tmp15_;
		gchar** _tmp16_ = NULL;
		gint objects_length1 = 0;
		gint _objects_size_ = 0;
		gchar** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
#line 784 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp5_ = g_key_file_new ();
#line 784 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		keyfile = _tmp5_;
#line 785 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp7_ = keyfile;
#line 785 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp8_ = trans;
#line 785 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp9_ = trans;
#line 785 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp10_ = strlen (_tmp9_);
#line 785 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp11_ = _tmp10_;
#line 785 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp12_ = g_key_file_load_from_data (_tmp7_, _tmp8_, (gsize) _tmp11_, G_KEY_FILE_NONE, &_inner_error_);
#line 785 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp6_ = _tmp12_;
#line 785 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 785 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_key_file_unref0 (keyfile);
#line 5681 "PhotoTable.c"
			goto __catch15_g_error;
		}
#line 785 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (!_tmp6_) {
#line 786 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			result = NULL;
#line 786 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_key_file_unref0 (keyfile);
#line 786 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return result;
#line 5692 "PhotoTable.c"
		}
#line 788 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp13_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TYPE_KEY_VALUE_MAP, (GBoxedCopyFunc) key_value_map_ref, key_value_map_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 788 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		map = _tmp13_;
#line 790 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp14_ = keyfile;
#line 790 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp16_ = g_key_file_get_groups (_tmp14_, &_tmp15_);
#line 790 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		objects = _tmp16_;
#line 790 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		objects_length1 = _tmp15_;
#line 790 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_objects_size_ = objects_length1;
#line 791 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp17_ = objects;
#line 791 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp17__length1 = objects_length1;
#line 5712 "PhotoTable.c"
		{
			gchar** object_collection = NULL;
			gint object_collection_length1 = 0;
			gint _object_collection_size_ = 0;
			gint object_it = 0;
#line 791 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			object_collection = _tmp17_;
#line 791 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			object_collection_length1 = _tmp17__length1;
#line 791 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			for (object_it = 0; object_it < _tmp17__length1; object_it = object_it + 1) {
#line 5724 "PhotoTable.c"
				gchar* _tmp18_ = NULL;
				gchar* object = NULL;
#line 791 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp18_ = g_strdup (object_collection[object_it]);
#line 791 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				object = _tmp18_;
#line 5731 "PhotoTable.c"
				{
					gchar** keys = NULL;
					GKeyFile* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					gsize _tmp21_;
					gchar** _tmp22_ = NULL;
					gint keys_length1 = 0;
					gint _keys_size_ = 0;
					gboolean _tmp23_ = FALSE;
					gchar** _tmp24_ = NULL;
					gint _tmp24__length1 = 0;
					KeyValueMap* key_map = NULL;
					const gchar* _tmp26_ = NULL;
					KeyValueMap* _tmp27_ = NULL;
					GeeHashMap* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
					KeyValueMap* _tmp45_ = NULL;
#line 792 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp19_ = keyfile;
#line 792 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp20_ = object;
#line 792 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp22_ = g_key_file_get_keys (_tmp19_, _tmp20_, &_tmp21_, &_inner_error_);
#line 792 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					keys = _tmp22_;
#line 792 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					keys_length1 = _tmp21_;
#line 792 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_keys_size_ = keys_length1;
#line 792 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 792 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						_g_free0 (object);
#line 792 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						objects = (_vala_array_free (objects, objects_length1, (GDestroyNotify) g_free), NULL);
#line 792 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						_g_object_unref0 (map);
#line 792 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						_g_key_file_unref0 (keyfile);
#line 5771 "PhotoTable.c"
						goto __catch15_g_error;
					}
#line 793 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp24_ = keys;
#line 793 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp24__length1 = keys_length1;
#line 793 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					if (_tmp24_ == NULL) {
#line 793 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						_tmp23_ = TRUE;
#line 5782 "PhotoTable.c"
					} else {
						gchar** _tmp25_ = NULL;
						gint _tmp25__length1 = 0;
#line 793 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						_tmp25_ = keys;
#line 793 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						_tmp25__length1 = keys_length1;
#line 793 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						_tmp23_ = _tmp25__length1 == 0;
#line 5792 "PhotoTable.c"
					}
#line 793 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					if (_tmp23_) {
#line 794 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 794 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						_g_free0 (object);
#line 794 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						continue;
#line 5802 "PhotoTable.c"
					}
#line 796 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp26_ = object;
#line 796 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp27_ = key_value_map_new (_tmp26_);
#line 796 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					key_map = _tmp27_;
#line 5810 "PhotoTable.c"
					{
						gint ctr = 0;
#line 797 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						ctr = 0;
#line 5815 "PhotoTable.c"
						{
							gboolean _tmp28_ = FALSE;
#line 797 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
							_tmp28_ = TRUE;
#line 797 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
							while (TRUE) {
#line 5822 "PhotoTable.c"
								gint _tmp30_ = 0;
								gchar** _tmp31_ = NULL;
								gint _tmp31__length1 = 0;
								gchar* _tmp32_ = NULL;
								GKeyFile* _tmp33_ = NULL;
								const gchar* _tmp34_ = NULL;
								gchar** _tmp35_ = NULL;
								gint _tmp35__length1 = 0;
								gint _tmp36_ = 0;
								const gchar* _tmp37_ = NULL;
								gchar* _tmp38_ = NULL;
								KeyValueMap* _tmp39_ = NULL;
								gchar** _tmp40_ = NULL;
								gint _tmp40__length1 = 0;
								gint _tmp41_ = 0;
								const gchar* _tmp42_ = NULL;
#line 797 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								if (!_tmp28_) {
#line 5841 "PhotoTable.c"
									gint _tmp29_ = 0;
#line 797 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
									_tmp29_ = ctr;
#line 797 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
									ctr = _tmp29_ + 1;
#line 5847 "PhotoTable.c"
								}
#line 797 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp28_ = FALSE;
#line 797 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp30_ = ctr;
#line 797 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp31_ = keys;
#line 797 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp31__length1 = keys_length1;
#line 797 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								if (!(_tmp30_ < _tmp31__length1)) {
#line 797 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
									break;
#line 5861 "PhotoTable.c"
								}
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp33_ = keyfile;
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp34_ = object;
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp35_ = keys;
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp35__length1 = keys_length1;
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp36_ = ctr;
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp37_ = _tmp35_[_tmp36_];
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp38_ = g_key_file_get_string (_tmp33_, _tmp34_, _tmp37_, &_inner_error_);
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp32_ = _tmp38_;
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
									_key_value_map_unref0 (key_map);
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
									keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
									_g_free0 (object);
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
									objects = (_vala_array_free (objects, objects_length1, (GDestroyNotify) g_free), NULL);
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
									_g_object_unref0 (map);
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
									_g_key_file_unref0 (keyfile);
#line 5893 "PhotoTable.c"
									goto __catch15_g_error;
								}
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp39_ = key_map;
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp40_ = keys;
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp40__length1 = keys_length1;
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp41_ = ctr;
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp42_ = _tmp40_[_tmp41_];
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								key_value_map_set_string (_tmp39_, _tmp42_, _tmp32_);
#line 797 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_g_free0 (_tmp32_);
#line 5910 "PhotoTable.c"
							}
						}
					}
#line 800 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp43_ = map;
#line 800 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp44_ = object;
#line 800 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp45_ = key_map;
#line 800 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp44_, _tmp45_);
#line 791 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_key_value_map_unref0 (key_map);
#line 791 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 791 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_g_free0 (object);
#line 5928 "PhotoTable.c"
				}
			}
		}
#line 803 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = map;
#line 803 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		objects = (_vala_array_free (objects, objects_length1, (GDestroyNotify) g_free), NULL);
#line 803 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_key_file_unref0 (keyfile);
#line 803 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 5940 "PhotoTable.c"
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp46_ = NULL;
#line 783 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		err = _inner_error_;
#line 783 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_inner_error_ = NULL;
#line 805 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp46_ = err->message;
#line 805 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_error ("PhotoTable.vala:805: %s", _tmp46_);
#line 783 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_error_free0 (err);
#line 5957 "PhotoTable.c"
	}
	__finally15:
#line 783 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 783 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_clear_error (&_inner_error_);
#line 783 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return NULL;
#line 5966 "PhotoTable.c"
}


gchar* photo_table_unmarshall_all_transformations (GeeHashMap* transformations) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_ = NULL;
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp8_ = NULL;
	gsize length = 0UL;
	gchar* unmarshalled = NULL;
	GKeyFile* _tmp39_ = NULL;
	gsize _tmp40_ = 0UL;
	gchar* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	gint _tmp44_ = 0;
	gint _tmp45_ = 0;
#line 809 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail ((transformations == NULL) || GEE_IS_HASH_MAP (transformations), NULL);
#line 810 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = transformations;
#line 810 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp1_ == NULL) {
#line 810 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = TRUE;
#line 5993 "PhotoTable.c"
	} else {
		GeeHashMap* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeSet* _tmp4_ = NULL;
		GeeSet* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 810 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp2_ = transformations;
#line 810 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp3_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_MAP, GeeMap));
#line 810 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp4_ = _tmp3_;
#line 810 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp5_ = _tmp4_;
#line 810 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp6_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
#line 810 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp7_ = _tmp6_;
#line 810 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = _tmp7_ == 0;
#line 810 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_object_unref0 (_tmp5_);
#line 6017 "PhotoTable.c"
	}
#line 810 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp0_) {
#line 811 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = NULL;
#line 811 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 6025 "PhotoTable.c"
	}
#line 813 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = g_key_file_new ();
#line 813 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	keyfile = _tmp8_;
#line 6031 "PhotoTable.c"
	{
		GeeIterator* _object_it = NULL;
		GeeHashMap* _tmp9_ = NULL;
		GeeSet* _tmp10_ = NULL;
		GeeSet* _tmp11_ = NULL;
		GeeSet* _tmp12_ = NULL;
		GeeIterator* _tmp13_ = NULL;
		GeeIterator* _tmp14_ = NULL;
#line 815 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp9_ = transformations;
#line 815 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp10_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_MAP, GeeMap));
#line 815 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp11_ = _tmp10_;
#line 815 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp12_ = _tmp11_;
#line 815 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp13_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ITERABLE, GeeIterable));
#line 815 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp14_ = _tmp13_;
#line 815 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_object_unref0 (_tmp12_);
#line 815 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_object_it = _tmp14_;
#line 815 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		while (TRUE) {
#line 6058 "PhotoTable.c"
			GeeIterator* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			gchar* object = NULL;
			GeeIterator* _tmp17_ = NULL;
			gpointer _tmp18_ = NULL;
			KeyValueMap* map = NULL;
			GeeHashMap* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			gpointer _tmp21_ = NULL;
#line 815 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp15_ = _object_it;
#line 815 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp16_ = gee_iterator_next (_tmp15_);
#line 815 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (!_tmp16_) {
#line 815 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				break;
#line 6076 "PhotoTable.c"
			}
#line 815 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp17_ = _object_it;
#line 815 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp18_ = gee_iterator_get (_tmp17_);
#line 815 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			object = (gchar*) _tmp18_;
#line 816 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp19_ = transformations;
#line 816 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp20_ = object;
#line 816 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp21_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp20_);
#line 816 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			map = (KeyValueMap*) _tmp21_;
#line 6092 "PhotoTable.c"
			{
				GeeIterator* _key_it = NULL;
				KeyValueMap* _tmp22_ = NULL;
				GeeSet* _tmp23_ = NULL;
				GeeSet* _tmp24_ = NULL;
				GeeIterator* _tmp25_ = NULL;
				GeeIterator* _tmp26_ = NULL;
#line 818 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp22_ = map;
#line 818 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp23_ = key_value_map_get_keys (_tmp22_);
#line 818 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp24_ = _tmp23_;
#line 818 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp25_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_ITERABLE, GeeIterable));
#line 818 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp26_ = _tmp25_;
#line 818 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_object_unref0 (_tmp24_);
#line 818 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_key_it = _tmp26_;
#line 818 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				while (TRUE) {
#line 6116 "PhotoTable.c"
					GeeIterator* _tmp27_ = NULL;
					gboolean _tmp28_ = FALSE;
					gchar* key = NULL;
					GeeIterator* _tmp29_ = NULL;
					gpointer _tmp30_ = NULL;
					gchar* value = NULL;
					KeyValueMap* _tmp31_ = NULL;
					const gchar* _tmp32_ = NULL;
					gchar* _tmp33_ = NULL;
					const gchar* _tmp34_ = NULL;
					GKeyFile* _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					const gchar* _tmp38_ = NULL;
#line 818 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp27_ = _key_it;
#line 818 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp28_ = gee_iterator_next (_tmp27_);
#line 818 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					if (!_tmp28_) {
#line 818 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						break;
#line 6139 "PhotoTable.c"
					}
#line 818 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp29_ = _key_it;
#line 818 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp30_ = gee_iterator_get (_tmp29_);
#line 818 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					key = (gchar*) _tmp30_;
#line 819 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp31_ = map;
#line 819 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp32_ = key;
#line 819 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp33_ = key_value_map_get_string (_tmp31_, _tmp32_, NULL);
#line 819 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					value = _tmp33_;
#line 820 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp34_ = value;
#line 820 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_vala_assert (_tmp34_ != NULL, "value != null");
#line 822 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp35_ = keyfile;
#line 822 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp36_ = object;
#line 822 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp37_ = key;
#line 822 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp38_ = value;
#line 822 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					g_key_file_set_string (_tmp35_, _tmp36_, _tmp37_, _tmp38_);
#line 818 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_g_free0 (value);
#line 818 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_g_free0 (key);
#line 6173 "PhotoTable.c"
				}
#line 818 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_object_unref0 (_key_it);
#line 6177 "PhotoTable.c"
			}
#line 815 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_key_value_map_unref0 (map);
#line 815 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (object);
#line 6183 "PhotoTable.c"
		}
#line 815 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_object_unref0 (_object_it);
#line 6187 "PhotoTable.c"
	}
#line 827 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp39_ = keyfile;
#line 827 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp41_ = g_key_file_to_data (_tmp39_, &_tmp40_, NULL);
#line 827 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	length = _tmp40_;
#line 827 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	unmarshalled = _tmp41_;
#line 828 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp42_ = unmarshalled;
#line 828 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp42_ != NULL, "unmarshalled != null");
#line 829 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp43_ = unmarshalled;
#line 829 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp44_ = strlen (_tmp43_);
#line 829 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp45_ = _tmp44_;
#line 829 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp45_ > 0, "unmarshalled.length > 0");
#line 831 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = unmarshalled;
#line 831 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_key_file_unref0 (keyfile);
#line 831 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 6215 "PhotoTable.c"
}


gboolean photo_table_set_transformation (PhotoTable* self, PhotoID* photo_id, KeyValueMap* map) {
	gboolean result = FALSE;
	gchar* trans = NULL;
	PhotoID _tmp0_ = {0};
	gchar* _tmp1_ = NULL;
	PhotoID _tmp37_ = {0};
	const gchar* _tmp38_ = NULL;
	gboolean _tmp39_ = FALSE;
	GError * _inner_error_ = NULL;
#line 834 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 834 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 834 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_KEY_VALUE_MAP (map), FALSE);
#line 835 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 835 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = photo_table_get_raw_transformations (self, &_tmp0_);
#line 835 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	trans = _tmp1_;
#line 6240 "PhotoTable.c"
	{
		GKeyFile* keyfile = NULL;
		GKeyFile* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GeeSet* keys = NULL;
		KeyValueMap* _tmp11_ = NULL;
		GeeSet* _tmp12_ = NULL;
		gsize length = 0UL;
		GKeyFile* _tmp29_ = NULL;
		gsize _tmp30_ = 0UL;
		gchar* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
#line 838 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp2_ = g_key_file_new ();
#line 838 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		keyfile = _tmp2_;
#line 839 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp3_ = trans;
#line 839 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_tmp3_ != NULL) {
#line 6264 "PhotoTable.c"
			gboolean _tmp4_ = FALSE;
			GKeyFile* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gboolean _tmp10_ = FALSE;
#line 840 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp5_ = keyfile;
#line 840 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp6_ = trans;
#line 840 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp7_ = trans;
#line 840 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp8_ = strlen (_tmp7_);
#line 840 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp9_ = _tmp8_;
#line 840 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp10_ = g_key_file_load_from_data (_tmp5_, _tmp6_, (gsize) _tmp9_, G_KEY_FILE_NONE, &_inner_error_);
#line 840 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp4_ = _tmp10_;
#line 840 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 840 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_key_file_unref0 (keyfile);
#line 6290 "PhotoTable.c"
				goto __catch16_g_error;
			}
#line 840 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (!_tmp4_) {
#line 841 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				result = FALSE;
#line 841 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_key_file_unref0 (keyfile);
#line 841 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_free0 (trans);
#line 841 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				return result;
#line 6303 "PhotoTable.c"
			}
		}
#line 844 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp11_ = map;
#line 844 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp12_ = key_value_map_get_keys (_tmp11_);
#line 844 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		keys = _tmp12_;
#line 6312 "PhotoTable.c"
		{
			GeeIterator* _key_it = NULL;
			GeeSet* _tmp13_ = NULL;
			GeeIterator* _tmp14_ = NULL;
#line 845 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp13_ = keys;
#line 845 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp14_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ITERABLE, GeeIterable));
#line 845 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_key_it = _tmp14_;
#line 845 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			while (TRUE) {
#line 6325 "PhotoTable.c"
				GeeIterator* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
				gchar* key = NULL;
				GeeIterator* _tmp17_ = NULL;
				gpointer _tmp18_ = NULL;
				gchar* value = NULL;
				KeyValueMap* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				GKeyFile* _tmp23_ = NULL;
				KeyValueMap* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
#line 845 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp15_ = _key_it;
#line 845 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp16_ = gee_iterator_next (_tmp15_);
#line 845 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				if (!_tmp16_) {
#line 845 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					break;
#line 6350 "PhotoTable.c"
				}
#line 845 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp17_ = _key_it;
#line 845 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp18_ = gee_iterator_get (_tmp17_);
#line 845 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				key = (gchar*) _tmp18_;
#line 846 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp19_ = map;
#line 846 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp20_ = key;
#line 846 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp21_ = key_value_map_get_string (_tmp19_, _tmp20_, NULL);
#line 846 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				value = _tmp21_;
#line 847 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp22_ = value;
#line 847 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_vala_assert (_tmp22_ != NULL, "value != null");
#line 849 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp23_ = keyfile;
#line 849 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp24_ = map;
#line 849 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp25_ = key_value_map_get_group (_tmp24_);
#line 849 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp26_ = _tmp25_;
#line 849 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp27_ = key;
#line 849 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp28_ = value;
#line 849 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_key_file_set_string (_tmp23_, _tmp26_, _tmp27_, _tmp28_);
#line 849 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_free0 (_tmp26_);
#line 845 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_free0 (value);
#line 845 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_free0 (key);
#line 6390 "PhotoTable.c"
			}
#line 845 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_object_unref0 (_key_it);
#line 6394 "PhotoTable.c"
		}
#line 853 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp29_ = keyfile;
#line 853 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp31_ = g_key_file_to_data (_tmp29_, &_tmp30_, NULL);
#line 853 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		length = _tmp30_;
#line 853 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (trans);
#line 853 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		trans = _tmp31_;
#line 854 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp32_ = trans;
#line 854 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_vala_assert (_tmp32_ != NULL, "trans != null");
#line 855 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp33_ = trans;
#line 855 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp34_ = strlen (_tmp33_);
#line 855 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp35_ = _tmp34_;
#line 855 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_vala_assert (_tmp35_ > 0, "trans.length > 0");
#line 837 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_object_unref0 (keys);
#line 837 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_key_file_unref0 (keyfile);
#line 6422 "PhotoTable.c"
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp36_ = NULL;
#line 837 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		err = _inner_error_;
#line 837 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_inner_error_ = NULL;
#line 857 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp36_ = err->message;
#line 857 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_error ("PhotoTable.vala:857: %s", _tmp36_);
#line 837 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_error_free0 (err);
#line 6439 "PhotoTable.c"
	}
	__finally16:
#line 837 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 837 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (trans);
#line 837 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 837 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_clear_error (&_inner_error_);
#line 837 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return FALSE;
#line 6452 "PhotoTable.c"
	}
#line 860 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp37_ = *photo_id;
#line 860 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp38_ = trans;
#line 860 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp39_ = photo_table_set_raw_transformations (self, &_tmp37_, _tmp38_);
#line 860 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp39_;
#line 860 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (trans);
#line 860 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 6466 "PhotoTable.c"
}


gboolean photo_table_remove_transformation (PhotoTable* self, PhotoID* photo_id, const gchar* object) {
	gboolean result = FALSE;
	gchar* trans = NULL;
	PhotoID _tmp0_ = {0};
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	PhotoID _tmp21_ = {0};
	const gchar* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	GError * _inner_error_ = NULL;
#line 863 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 863 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 863 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (object != NULL, FALSE);
#line 864 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 864 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = photo_table_get_raw_transformations (self, &_tmp0_);
#line 864 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	trans = _tmp1_;
#line 865 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = trans;
#line 865 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp2_ == NULL) {
#line 866 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = TRUE;
#line 866 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (trans);
#line 866 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 6502 "PhotoTable.c"
	}
	{
		GKeyFile* keyfile = NULL;
		GKeyFile* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		GKeyFile* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gboolean _tmp10_ = FALSE;
		GKeyFile* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		GKeyFile* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gsize length = 0UL;
		GKeyFile* _tmp16_ = NULL;
		gsize _tmp17_ = 0UL;
		gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 869 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp3_ = g_key_file_new ();
#line 869 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		keyfile = _tmp3_;
#line 870 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp5_ = keyfile;
#line 870 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp6_ = trans;
#line 870 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp7_ = trans;
#line 870 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp8_ = strlen (_tmp7_);
#line 870 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp9_ = _tmp8_;
#line 870 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp10_ = g_key_file_load_from_data (_tmp5_, _tmp6_, (gsize) _tmp9_, G_KEY_FILE_NONE, &_inner_error_);
#line 870 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp4_ = _tmp10_;
#line 870 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 870 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_key_file_unref0 (keyfile);
#line 6546 "PhotoTable.c"
			goto __catch17_g_error;
		}
#line 870 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (!_tmp4_) {
#line 871 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			result = FALSE;
#line 871 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_key_file_unref0 (keyfile);
#line 871 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (trans);
#line 871 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return result;
#line 6559 "PhotoTable.c"
		}
#line 873 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp11_ = keyfile;
#line 873 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp12_ = object;
#line 873 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp13_ = g_key_file_has_group (_tmp11_, _tmp12_);
#line 873 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (!_tmp13_) {
#line 874 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			result = TRUE;
#line 874 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_key_file_unref0 (keyfile);
#line 874 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (trans);
#line 874 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return result;
#line 6577 "PhotoTable.c"
		}
#line 876 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp14_ = keyfile;
#line 876 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp15_ = object;
#line 876 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_key_file_remove_group (_tmp14_, _tmp15_, &_inner_error_);
#line 876 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 876 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_key_file_unref0 (keyfile);
#line 6589 "PhotoTable.c"
			goto __catch17_g_error;
		}
#line 879 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp16_ = keyfile;
#line 879 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp18_ = g_key_file_to_data (_tmp16_, &_tmp17_, NULL);
#line 879 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		length = _tmp17_;
#line 879 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (trans);
#line 879 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		trans = _tmp18_;
#line 880 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp19_ = trans;
#line 880 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_vala_assert (_tmp19_ != NULL, "trans != null");
#line 868 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_key_file_unref0 (keyfile);
#line 6608 "PhotoTable.c"
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp20_ = NULL;
#line 868 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		err = _inner_error_;
#line 868 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_inner_error_ = NULL;
#line 882 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp20_ = err->message;
#line 882 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_error ("PhotoTable.vala:882: %s", _tmp20_);
#line 868 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_error_free0 (err);
#line 6625 "PhotoTable.c"
	}
	__finally17:
#line 868 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 868 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (trans);
#line 868 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 868 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_clear_error (&_inner_error_);
#line 868 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return FALSE;
#line 6638 "PhotoTable.c"
	}
#line 885 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp21_ = *photo_id;
#line 885 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp22_ = trans;
#line 885 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp23_ = photo_table_set_raw_transformations (self, &_tmp21_, _tmp22_);
#line 885 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp23_;
#line 885 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (trans);
#line 885 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 6652 "PhotoTable.c"
}


gboolean photo_table_remove_all_transformations (PhotoTable* self, PhotoID* photo_id) {
	gboolean result = FALSE;
	PhotoID _tmp0_ = {0};
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	PhotoID _tmp4_ = {0};
	gint64 _tmp5_ = 0LL;
	gboolean _tmp6_ = FALSE;
#line 888 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 888 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 889 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 889 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = photo_table_get_raw_transformations (self, &_tmp0_);
#line 889 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = _tmp1_;
#line 889 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = _tmp2_ == NULL;
#line 889 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (_tmp2_);
#line 889 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp3_) {
#line 890 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = FALSE;
#line 890 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 6685 "PhotoTable.c"
	}
#line 892 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = *photo_id;
#line 892 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = _tmp4_.id;
#line 892 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = database_table_update_text_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp5_, "transformations", "");
#line 892 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp6_;
#line 892 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 6697 "PhotoTable.c"
}


static sqlite3_stmt* photo_table_get_duplicate_stmt (PhotoTable* self, GFile* file, const gchar* thumbnail_md5, const gchar* md5, PhotoFileFormat file_format) {
	sqlite3_stmt* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GFile* _tmp2_ = NULL;
	gchar* sql = NULL;
	gchar* _tmp5_ = NULL;
	gboolean first = FALSE;
	GFile* _tmp6_ = NULL;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_ = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	sqlite3_stmt* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	gint col = 0;
	GFile* _tmp38_ = NULL;
	const gchar* _tmp46_ = NULL;
	const gchar* _tmp54_ = NULL;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	const gchar* _tmp64_ = NULL;
#line 897 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), NULL);
#line 897 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail ((file == NULL) || G_IS_FILE (file), NULL);
#line 899 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = file;
#line 899 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp2_ != NULL) {
#line 899 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp1_ = TRUE;
#line 6736 "PhotoTable.c"
	} else {
		const gchar* _tmp3_ = NULL;
#line 899 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp3_ = thumbnail_md5;
#line 899 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp1_ = _tmp3_ != NULL;
#line 6743 "PhotoTable.c"
	}
#line 899 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp1_) {
#line 899 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = TRUE;
#line 6749 "PhotoTable.c"
	} else {
		const gchar* _tmp4_ = NULL;
#line 899 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp4_ = md5;
#line 899 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = _tmp4_ != NULL;
#line 6756 "PhotoTable.c"
	}
#line 899 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp0_, "file != null || thumbnail_md5 != null || md5 != null");
#line 901 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = g_strdup ("SELECT id FROM PhotoTable WHERE");
#line 901 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	sql = _tmp5_;
#line 902 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	first = TRUE;
#line 904 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = file;
#line 904 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp6_ != NULL) {
#line 6770 "PhotoTable.c"
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 905 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp7_ = sql;
#line 905 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp8_ = g_strconcat (_tmp7_, " filename=?", NULL);
#line 905 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (sql);
#line 905 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		sql = _tmp8_;
#line 906 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		first = FALSE;
#line 6783 "PhotoTable.c"
	}
#line 909 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = thumbnail_md5;
#line 909 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp10_ != NULL) {
#line 909 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp9_ = TRUE;
#line 6791 "PhotoTable.c"
	} else {
		const gchar* _tmp11_ = NULL;
#line 909 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp11_ = md5;
#line 909 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp9_ = _tmp11_ != NULL;
#line 6798 "PhotoTable.c"
	}
#line 909 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp9_) {
#line 6802 "PhotoTable.c"
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		PhotoFileFormat _tmp28_ = 0;
		const gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
#line 910 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp12_ = first;
#line 910 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_tmp12_) {
#line 6815 "PhotoTable.c"
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
#line 911 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp13_ = sql;
#line 911 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp14_ = g_strconcat (_tmp13_, " ((", NULL);
#line 911 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (sql);
#line 911 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			sql = _tmp14_;
#line 6826 "PhotoTable.c"
		} else {
			const gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
#line 913 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp15_ = sql;
#line 913 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp16_ = g_strconcat (_tmp15_, " OR ((", NULL);
#line 913 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (sql);
#line 913 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			sql = _tmp16_;
#line 6838 "PhotoTable.c"
		}
#line 914 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		first = FALSE;
#line 916 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp17_ = thumbnail_md5;
#line 916 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_tmp17_ != NULL) {
#line 6846 "PhotoTable.c"
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
#line 917 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp18_ = sql;
#line 917 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp19_ = g_strconcat (_tmp18_, " thumbnail_md5=?", NULL);
#line 917 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (sql);
#line 917 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			sql = _tmp19_;
#line 6857 "PhotoTable.c"
		}
#line 919 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp20_ = md5;
#line 919 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_tmp20_ != NULL) {
#line 6863 "PhotoTable.c"
			const gchar* _tmp21_ = NULL;
#line 920 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp21_ = thumbnail_md5;
#line 920 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (_tmp21_ == NULL) {
#line 6869 "PhotoTable.c"
				const gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
#line 921 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp22_ = sql;
#line 921 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp23_ = g_strconcat (_tmp22_, " md5=?", NULL);
#line 921 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_free0 (sql);
#line 921 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				sql = _tmp23_;
#line 6880 "PhotoTable.c"
			} else {
				const gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
#line 923 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp24_ = sql;
#line 923 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp25_ = g_strconcat (_tmp24_, " OR md5=?", NULL);
#line 923 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_free0 (sql);
#line 923 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				sql = _tmp25_;
#line 6892 "PhotoTable.c"
			}
		}
#line 926 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp26_ = sql;
#line 926 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp27_ = g_strconcat (_tmp26_, ")", NULL);
#line 926 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (sql);
#line 926 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		sql = _tmp27_;
#line 928 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp28_ = file_format;
#line 928 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_tmp28_ != PHOTO_FILE_FORMAT_UNKNOWN) {
#line 6907 "PhotoTable.c"
			const gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
#line 929 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp29_ = sql;
#line 929 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp30_ = g_strconcat (_tmp29_, " AND file_format=?", NULL);
#line 929 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (sql);
#line 929 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			sql = _tmp30_;
#line 6918 "PhotoTable.c"
		}
#line 931 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp31_ = sql;
#line 931 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp32_ = g_strconcat (_tmp31_, ")", NULL);
#line 931 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (sql);
#line 931 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		sql = _tmp32_;
#line 6928 "PhotoTable.c"
	}
#line 935 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp33_ = database_table_db;
#line 935 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp34_ = sql;
#line 935 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp36_ = sqlite3_prepare_v2 (_tmp33_, _tmp34_, -1, &_tmp35_, NULL);
#line 935 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 935 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp35_;
#line 935 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp36_;
#line 936 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp37_ = res;
#line 936 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp37_ == SQLITE_OK, "res == Sqlite.OK");
#line 938 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	col = 1;
#line 940 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp38_ = file;
#line 940 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp38_ != NULL) {
#line 6952 "PhotoTable.c"
		sqlite3_stmt* _tmp39_ = NULL;
		gint _tmp40_ = 0;
		GFile* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		GDestroyNotify _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
#line 941 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp39_ = stmt;
#line 941 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp40_ = col;
#line 941 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		col = _tmp40_ + 1;
#line 941 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp41_ = file;
#line 941 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp42_ = g_file_get_path (_tmp41_);
#line 941 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp43_ = g_free;
#line 941 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp44_ = sqlite3_bind_text (_tmp39_, _tmp40_, _tmp42_, -1, _tmp43_);
#line 941 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		res = _tmp44_;
#line 942 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp45_ = res;
#line 942 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_vala_assert (_tmp45_ == SQLITE_OK, "res == Sqlite.OK");
#line 6980 "PhotoTable.c"
	}
#line 945 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp46_ = thumbnail_md5;
#line 945 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp46_ != NULL) {
#line 6986 "PhotoTable.c"
		sqlite3_stmt* _tmp47_ = NULL;
		gint _tmp48_ = 0;
		const gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		GDestroyNotify _tmp51_ = NULL;
		gint _tmp52_ = 0;
		gint _tmp53_ = 0;
#line 946 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp47_ = stmt;
#line 946 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp48_ = col;
#line 946 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		col = _tmp48_ + 1;
#line 946 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp49_ = thumbnail_md5;
#line 946 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp50_ = g_strdup (_tmp49_);
#line 946 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp51_ = g_free;
#line 946 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp52_ = sqlite3_bind_text (_tmp47_, _tmp48_, _tmp50_, -1, _tmp51_);
#line 946 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		res = _tmp52_;
#line 947 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp53_ = res;
#line 947 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_vala_assert (_tmp53_ == SQLITE_OK, "res == Sqlite.OK");
#line 7014 "PhotoTable.c"
	}
#line 950 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp54_ = md5;
#line 950 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp54_ != NULL) {
#line 7020 "PhotoTable.c"
		sqlite3_stmt* _tmp55_ = NULL;
		gint _tmp56_ = 0;
		const gchar* _tmp57_ = NULL;
		gchar* _tmp58_ = NULL;
		GDestroyNotify _tmp59_ = NULL;
		gint _tmp60_ = 0;
		gint _tmp61_ = 0;
#line 951 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp55_ = stmt;
#line 951 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp56_ = col;
#line 951 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		col = _tmp56_ + 1;
#line 951 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp57_ = md5;
#line 951 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp58_ = g_strdup (_tmp57_);
#line 951 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp59_ = g_free;
#line 951 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp60_ = sqlite3_bind_text (_tmp55_, _tmp56_, _tmp58_, -1, _tmp59_);
#line 951 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		res = _tmp60_;
#line 952 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp61_ = res;
#line 952 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_vala_assert (_tmp61_ == SQLITE_OK, "res == Sqlite.OK");
#line 7048 "PhotoTable.c"
	}
#line 955 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp64_ = thumbnail_md5;
#line 955 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp64_ != NULL) {
#line 955 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp63_ = TRUE;
#line 7056 "PhotoTable.c"
	} else {
		const gchar* _tmp65_ = NULL;
#line 955 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp65_ = md5;
#line 955 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp63_ = _tmp65_ != NULL;
#line 7063 "PhotoTable.c"
	}
#line 955 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp63_) {
#line 7067 "PhotoTable.c"
		PhotoFileFormat _tmp66_ = 0;
#line 955 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp66_ = file_format;
#line 955 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp62_ = _tmp66_ != PHOTO_FILE_FORMAT_UNKNOWN;
#line 7073 "PhotoTable.c"
	} else {
#line 955 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp62_ = FALSE;
#line 7077 "PhotoTable.c"
	}
#line 955 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp62_) {
#line 7081 "PhotoTable.c"
		sqlite3_stmt* _tmp67_ = NULL;
		gint _tmp68_ = 0;
		PhotoFileFormat _tmp69_ = 0;
		gint _tmp70_ = 0;
		gint _tmp71_ = 0;
		gint _tmp72_ = 0;
#line 956 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp67_ = stmt;
#line 956 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp68_ = col;
#line 956 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		col = _tmp68_ + 1;
#line 956 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp69_ = file_format;
#line 956 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp70_ = photo_file_format_serialize (_tmp69_);
#line 956 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp71_ = sqlite3_bind_int (_tmp67_, _tmp68_, _tmp70_);
#line 956 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		res = _tmp71_;
#line 957 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp72_ = res;
#line 957 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_vala_assert (_tmp72_ == SQLITE_OK, "res == Sqlite.OK");
#line 7106 "PhotoTable.c"
	}
#line 960 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = stmt;
#line 960 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (sql);
#line 960 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 7114 "PhotoTable.c"
}


gboolean photo_table_has_duplicate (PhotoTable* self, GFile* file, const gchar* thumbnail_md5, const gchar* md5, PhotoFileFormat file_format) {
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	GFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	PhotoFileFormat _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	gint res = 0;
	sqlite3_stmt* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
#line 963 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 963 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail ((file == NULL) || G_IS_FILE (file), FALSE);
#line 964 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = file;
#line 964 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = thumbnail_md5;
#line 964 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = md5;
#line 964 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = file_format;
#line 964 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = photo_table_get_duplicate_stmt (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 964 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp4_;
#line 965 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = stmt;
#line 965 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = sqlite3_step (_tmp5_);
#line 965 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp6_;
#line 967 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = res;
#line 967 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp7_ == SQLITE_DONE) {
#line 969 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = FALSE;
#line 969 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 969 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 7162 "PhotoTable.c"
	} else {
		gint _tmp8_ = 0;
#line 970 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp8_ = res;
#line 970 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_tmp8_ == SQLITE_ROW) {
#line 972 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			result = TRUE;
#line 972 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_sqlite3_finalize0 (stmt);
#line 972 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return result;
#line 7175 "PhotoTable.c"
		} else {
			gint _tmp9_ = 0;
#line 974 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp9_ = res;
#line 974 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			database_table_fatal ("has_duplicate", _tmp9_);
#line 976 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			result = FALSE;
#line 976 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_sqlite3_finalize0 (stmt);
#line 976 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return result;
#line 7188 "PhotoTable.c"
		}
	}
#line 963 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 7193 "PhotoTable.c"
}


static void _vala_array_add2 (PhotoID** array, int* length, int* size, const PhotoID* value) {
#line 988 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if ((*length) == (*size)) {
#line 988 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 988 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		*array = g_renew (PhotoID, *array, *size);
#line 7204 "PhotoTable.c"
	}
#line 988 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	(*array)[(*length)++] = *value;
#line 7208 "PhotoTable.c"
}


PhotoID* photo_table_get_duplicate_ids (PhotoTable* self, GFile* file, const gchar* thumbnail_md5, const gchar* md5, PhotoFileFormat file_format, int* result_length1) {
	PhotoID* result = NULL;
	sqlite3_stmt* stmt = NULL;
	GFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	PhotoFileFormat _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	PhotoID* ids = NULL;
	PhotoID* _tmp5_ = NULL;
	gint ids_length1 = 0;
	gint _ids_size_ = 0;
	gint res = 0;
	sqlite3_stmt* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	PhotoID* _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
#line 980 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), NULL);
#line 980 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail ((file == NULL) || G_IS_FILE (file), NULL);
#line 982 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = file;
#line 982 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = thumbnail_md5;
#line 982 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = md5;
#line 982 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = file_format;
#line 982 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = photo_table_get_duplicate_stmt (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 982 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp4_;
#line 984 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = g_new0 (PhotoID, 0);
#line 984 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	ids = _tmp5_;
#line 984 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	ids_length1 = 0;
#line 984 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_ids_size_ = ids_length1;
#line 986 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = stmt;
#line 986 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = sqlite3_step (_tmp6_);
#line 986 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp7_;
#line 987 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	while (TRUE) {
#line 7261 "PhotoTable.c"
		gint _tmp8_ = 0;
		PhotoID* _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		sqlite3_stmt* _tmp10_ = NULL;
		gint64 _tmp11_ = 0LL;
		PhotoID _tmp12_ = {0};
		sqlite3_stmt* _tmp13_ = NULL;
		gint _tmp14_ = 0;
#line 987 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp8_ = res;
#line 987 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (!(_tmp8_ == SQLITE_ROW)) {
#line 987 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			break;
#line 7276 "PhotoTable.c"
		}
#line 988 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp9_ = ids;
#line 988 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp9__length1 = ids_length1;
#line 988 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp10_ = stmt;
#line 988 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp11_ = sqlite3_column_int64 (_tmp10_, 0);
#line 988 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		photo_id_init (&_tmp12_, _tmp11_);
#line 988 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_vala_array_add2 (&ids, &ids_length1, &_ids_size_, &_tmp12_);
#line 989 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp13_ = stmt;
#line 989 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp14_ = sqlite3_step (_tmp13_);
#line 989 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		res = _tmp14_;
#line 7296 "PhotoTable.c"
	}
#line 992 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_ = ids;
#line 992 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15__length1 = ids_length1;
#line 992 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (result_length1) {
#line 992 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		*result_length1 = _tmp15__length1;
#line 7306 "PhotoTable.c"
	}
#line 992 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp15_;
#line 992 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 992 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 7314 "PhotoTable.c"
}


void photo_table_update_backlinks (PhotoTable* self, PhotoID* photo_id, const gchar* backlinks, GError** error) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	PhotoID _tmp3_ = {0};
	gint64 _tmp4_ = 0LL;
	GError * _inner_error_ = NULL;
#line 995 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 995 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (photo_id != NULL);
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = backlinks;
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp1_ != NULL) {
#line 7332 "PhotoTable.c"
		const gchar* _tmp2_ = NULL;
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp2_ = backlinks;
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = _tmp2_;
#line 7338 "PhotoTable.c"
	} else {
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = "";
#line 7342 "PhotoTable.c"
	}
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = *photo_id;
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = _tmp3_.id;
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp4_, "backlinks", _tmp0_, &_inner_error_);
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 7358 "PhotoTable.c"
		} else {
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 7366 "PhotoTable.c"
		}
	}
}


void photo_table_attach_editable (PhotoTable* self, PhotoRow* row, BackingPhotoID* editable_id, GError** error) {
	PhotoRow* _tmp0_ = NULL;
	PhotoID _tmp1_ = {0};
	gint64 _tmp2_ = 0LL;
	BackingPhotoID _tmp3_ = {0};
	gint64 _tmp4_ = 0LL;
	PhotoRow* _tmp5_ = NULL;
	BackingPhotoID _tmp6_ = {0};
	GError * _inner_error_ = NULL;
#line 999 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 999 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_ROW (row));
#line 999 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (editable_id != NULL);
#line 1000 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = row;
#line 1000 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_->photo_id;
#line 1000 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = _tmp1_.id;
#line 1000 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = *editable_id;
#line 1000 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = _tmp3_.id;
#line 1000 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp2_, "editable_id", _tmp4_, &_inner_error_);
#line 1000 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1000 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1000 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 1000 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 7407 "PhotoTable.c"
		} else {
#line 1000 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1000 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 1000 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 7415 "PhotoTable.c"
		}
	}
#line 1002 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = row;
#line 1002 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = *editable_id;
#line 1002 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_->editable_id = _tmp6_;
#line 7424 "PhotoTable.c"
}


void photo_table_detach_editable (PhotoTable* self, PhotoRow* row, GError** error) {
	PhotoRow* _tmp0_ = NULL;
	PhotoID _tmp1_ = {0};
	gint64 _tmp2_ = 0LL;
	PhotoRow* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 1005 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 1005 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_ROW (row));
#line 1006 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = row;
#line 1006 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_->photo_id;
#line 1006 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = _tmp1_.id;
#line 1006 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp2_, "editable_id", BACKING_PHOTO_ID_INVALID, &_inner_error_);
#line 1006 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1006 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1006 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 1006 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 7454 "PhotoTable.c"
		} else {
#line 1006 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1006 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 1006 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 7462 "PhotoTable.c"
		}
	}
#line 1008 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = row;
#line 1008 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	backing_photo_id_init (&_tmp3_->editable_id, BACKING_PHOTO_ID_INVALID);
#line 7469 "PhotoTable.c"
}


void photo_table_set_metadata_dirty (PhotoTable* self, PhotoID* photo_id, gboolean dirty, GError** error) {
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	PhotoID _tmp2_ = {0};
	gint64 _tmp3_ = 0LL;
	GError * _inner_error_ = NULL;
#line 1011 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 1011 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (photo_id != NULL);
#line 1012 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = dirty;
#line 1012 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp1_) {
#line 1012 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = 1;
#line 7489 "PhotoTable.c"
	} else {
#line 1012 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = 0;
#line 7493 "PhotoTable.c"
	}
#line 1012 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = *photo_id;
#line 1012 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = _tmp2_.id;
#line 1012 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_update_int_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp3_, "metadata_dirty", _tmp0_, &_inner_error_);
#line 1012 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1012 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1012 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 1012 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 7509 "PhotoTable.c"
		} else {
#line 1012 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1012 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 1012 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 7517 "PhotoTable.c"
		}
	}
}


void photo_table_update_raw_development (PhotoTable* self, PhotoRow* row, RawDeveloper rd, BackingPhotoID* backing_photo_id, GError** error) {
	gchar* col = NULL;
	RawDeveloper _tmp0_ = 0;
	PhotoRow* _tmp4_ = NULL;
	BackingPhotoID* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	RawDeveloper _tmp6_ = 0;
	BackingPhotoID _tmp7_ = {0};
	BackingPhotoID _tmp8_ = {0};
	PhotoRow* _tmp9_ = NULL;
	PhotoID _tmp10_ = {0};
	gint64 _tmp11_ = 0LL;
	const gchar* _tmp12_ = NULL;
	BackingPhotoID _tmp13_ = {0};
	gint64 _tmp14_ = 0LL;
	BackingPhotoID _tmp15_ = {0};
	gint64 _tmp16_ = 0LL;
	GError * _inner_error_ = NULL;
#line 1015 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 1015 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_ROW (row));
#line 1015 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (backing_photo_id != NULL);
#line 1019 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = rd;
#line 1019 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	switch (_tmp0_) {
#line 1019 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		case RAW_DEVELOPER_SHOTWELL:
#line 7553 "PhotoTable.c"
		{
			gchar* _tmp1_ = NULL;
#line 1021 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp1_ = g_strdup ("develop_shotwell_id");
#line 1021 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (col);
#line 1021 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			col = _tmp1_;
#line 1022 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			break;
#line 7564 "PhotoTable.c"
		}
#line 1019 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		case RAW_DEVELOPER_CAMERA:
#line 7568 "PhotoTable.c"
		{
			gchar* _tmp2_ = NULL;
#line 1025 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp2_ = g_strdup ("develop_camera_id");
#line 1025 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (col);
#line 1025 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			col = _tmp2_;
#line 1026 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			break;
#line 7579 "PhotoTable.c"
		}
#line 1019 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		case RAW_DEVELOPER_EMBEDDED:
#line 7583 "PhotoTable.c"
		{
			gchar* _tmp3_ = NULL;
#line 1029 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp3_ = g_strdup ("develop_embedded_id");
#line 1029 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (col);
#line 1029 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			col = _tmp3_;
#line 1030 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			break;
#line 7594 "PhotoTable.c"
		}
		default:
		{
#line 1033 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_assert_not_reached ();
#line 7600 "PhotoTable.c"
		}
	}
#line 1036 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = row;
#line 1036 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = _tmp4_->development_ids;
#line 1036 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5__length1 = _tmp4_->development_ids_length1;
#line 1036 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = rd;
#line 1036 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = *backing_photo_id;
#line 1036 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_[_tmp6_] = _tmp7_;
#line 1036 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = _tmp5_[_tmp6_];
#line 1037 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = row;
#line 1037 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = _tmp9_->photo_id;
#line 1037 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = _tmp10_.id;
#line 1037 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = col;
#line 1037 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_ = *backing_photo_id;
#line 1037 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = _tmp13_.id;
#line 1037 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp11_, _tmp12_, _tmp14_, &_inner_error_);
#line 1037 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1037 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1037 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 1037 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (col);
#line 1037 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 7641 "PhotoTable.c"
		} else {
#line 1037 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (col);
#line 1037 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1037 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 1037 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 7651 "PhotoTable.c"
		}
	}
#line 1039 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_ = *backing_photo_id;
#line 1039 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp16_ = _tmp15_.id;
#line 1039 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp16_ != BACKING_PHOTO_ID_INVALID) {
#line 7660 "PhotoTable.c"
		PhotoRow* _tmp17_ = NULL;
		PhotoID _tmp18_ = {0};
		gint64 _tmp19_ = 0LL;
		RawDeveloper _tmp20_ = 0;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
#line 1040 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp17_ = row;
#line 1040 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp18_ = _tmp17_->photo_id;
#line 1040 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp19_ = _tmp18_.id;
#line 1040 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp20_ = rd;
#line 1040 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp21_ = raw_developer_to_string (_tmp20_);
#line 1040 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp22_ = _tmp21_;
#line 1040 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp19_, "developer", _tmp22_, &_inner_error_);
#line 1040 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (_tmp22_);
#line 1040 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1040 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 1040 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_propagate_error (error, _inner_error_);
#line 1040 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_free0 (col);
#line 1040 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				return;
#line 7693 "PhotoTable.c"
			} else {
#line 1040 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_free0 (col);
#line 1040 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1040 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_clear_error (&_inner_error_);
#line 1040 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				return;
#line 7703 "PhotoTable.c"
			}
		}
	}
#line 1015 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (col);
#line 7709 "PhotoTable.c"
}


void photo_table_remove_development (PhotoTable* self, PhotoRow* row, RawDeveloper rd, GError** error) {
	PhotoRow* _tmp0_ = NULL;
	RawDeveloper _tmp1_ = 0;
	BackingPhotoID _tmp2_ = {0};
	GError * _inner_error_ = NULL;
#line 1043 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 1043 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_ROW (row));
#line 1044 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = row;
#line 1044 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = rd;
#line 1044 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	backing_photo_id_init (&_tmp2_, BACKING_PHOTO_ID_INVALID);
#line 1044 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	photo_table_update_raw_development (self, _tmp0_, _tmp1_, &_tmp2_, &_inner_error_);
#line 1044 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1044 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1044 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 1044 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 7738 "PhotoTable.c"
		} else {
#line 1044 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1044 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 1044 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 7746 "PhotoTable.c"
		}
	}
}


static void photo_table_class_init (PhotoTableClass * klass) {
#line 109 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	photo_table_parent_class = g_type_class_peek_parent (klass);
#line 109 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	((DatabaseTableClass *) klass)->finalize = photo_table_finalize;
#line 7757 "PhotoTable.c"
}


static void photo_table_instance_init (PhotoTable * self) {
}


static void photo_table_finalize (DatabaseTable* obj) {
	PhotoTable * self;
#line 109 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_TABLE, PhotoTable);
#line 109 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	DATABASE_TABLE_CLASS (photo_table_parent_class)->finalize (obj);
#line 7771 "PhotoTable.c"
}


GType photo_table_get_type (void) {
	static volatile gsize photo_table_type_id__volatile = 0;
	if (g_once_init_enter (&photo_table_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoTable), 0, (GInstanceInitFunc) photo_table_instance_init, NULL };
		GType photo_table_type_id;
		photo_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "PhotoTable", &g_define_type_info, 0);
		g_once_init_leave (&photo_table_type_id__volatile, photo_table_type_id);
	}
	return photo_table_type_id__volatile;
}


void backing_photo_id_init (BackingPhotoID *self, gint64 id) {
	gint64 _tmp0_ = 0LL;
#line 1064 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	memset (self, 0, sizeof (BackingPhotoID));
#line 1065 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = id;
#line 1065 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	(*self).id = _tmp0_;
#line 7795 "PhotoTable.c"
}


gboolean backing_photo_id_is_invalid (BackingPhotoID *self) {
	gboolean result = FALSE;
	gint64 _tmp0_ = 0LL;
#line 1069 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = (*self).id;
#line 1069 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp0_ == BACKING_PHOTO_ID_INVALID;
#line 1069 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 7808 "PhotoTable.c"
}


gboolean backing_photo_id_is_valid (BackingPhotoID *self) {
	gboolean result = FALSE;
	gint64 _tmp0_ = 0LL;
#line 1073 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = (*self).id;
#line 1073 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp0_ != BACKING_PHOTO_ID_INVALID;
#line 1073 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 7821 "PhotoTable.c"
}


BackingPhotoID* backing_photo_id_dup (const BackingPhotoID* self) {
	BackingPhotoID* dup;
#line 1059 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	dup = g_new0 (BackingPhotoID, 1);
#line 1059 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	memcpy (dup, self, sizeof (BackingPhotoID));
#line 1059 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return dup;
#line 7833 "PhotoTable.c"
}


void backing_photo_id_free (BackingPhotoID* self) {
#line 1059 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_free (self);
#line 7840 "PhotoTable.c"
}


GType backing_photo_id_get_type (void) {
	static volatile gsize backing_photo_id_type_id__volatile = 0;
	if (g_once_init_enter (&backing_photo_id_type_id__volatile)) {
		GType backing_photo_id_type_id;
		backing_photo_id_type_id = g_boxed_type_register_static ("BackingPhotoID", (GBoxedCopyFunc) backing_photo_id_dup, (GBoxedFreeFunc) backing_photo_id_free);
		g_once_init_leave (&backing_photo_id_type_id__volatile, backing_photo_id_type_id);
	}
	return backing_photo_id_type_id__volatile;
}


gboolean backing_photo_row_matches_file_info (BackingPhotoRow* self, GFileInfo* info) {
	gboolean result = FALSE;
	gint64 _tmp0_ = 0LL;
	GFileInfo* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	time_t _tmp3_ = 0;
	GFileInfo* _tmp4_ = NULL;
	GTimeVal _tmp5_ = {0};
	glong _tmp6_ = 0L;
#line 1087 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_BACKING_PHOTO_ROW (self), FALSE);
#line 1087 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), FALSE);
#line 1088 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = self->filesize;
#line 1088 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = info;
#line 1088 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = g_file_info_get_size (_tmp1_);
#line 1088 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp0_ != _tmp2_) {
#line 1089 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = FALSE;
#line 1089 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 7880 "PhotoTable.c"
	}
#line 1091 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = self->timestamp;
#line 1091 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = info;
#line 1091 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_file_info_get_modification_time (_tmp4_, &_tmp5_);
#line 1091 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = _tmp5_.tv_sec;
#line 1091 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp3_ == ((time_t) _tmp6_);
#line 1091 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 7894 "PhotoTable.c"
}


gboolean backing_photo_row_is_touched (BackingPhotoRow* self, GFileInfo* info) {
	gboolean result = FALSE;
	gint64 _tmp0_ = 0LL;
	GFileInfo* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	time_t _tmp3_ = 0;
	GFileInfo* _tmp4_ = NULL;
	GTimeVal _tmp5_ = {0};
	glong _tmp6_ = 0L;
#line 1094 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_BACKING_PHOTO_ROW (self), FALSE);
#line 1094 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), FALSE);
#line 1095 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = self->filesize;
#line 1095 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = info;
#line 1095 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = g_file_info_get_size (_tmp1_);
#line 1095 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp0_ != _tmp2_) {
#line 1096 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = FALSE;
#line 1096 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 7923 "PhotoTable.c"
	}
#line 1098 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = self->timestamp;
#line 1098 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = info;
#line 1098 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_file_info_get_modification_time (_tmp4_, &_tmp5_);
#line 1098 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = _tmp5_.tv_sec;
#line 1098 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp3_ != ((time_t) _tmp6_);
#line 1098 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 7937 "PhotoTable.c"
}


void backing_photo_row_copy_from (BackingPhotoRow* self, BackingPhotoRow* from) {
	BackingPhotoRow* _tmp0_ = NULL;
	BackingPhotoID _tmp1_ = {0};
	BackingPhotoRow* _tmp2_ = NULL;
	time_t _tmp3_ = 0;
	BackingPhotoRow* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	BackingPhotoRow* _tmp7_ = NULL;
	gint64 _tmp8_ = 0LL;
	BackingPhotoRow* _tmp9_ = NULL;
	time_t _tmp10_ = 0;
	BackingPhotoRow* _tmp11_ = NULL;
	PhotoFileFormat _tmp12_ = 0;
	BackingPhotoRow* _tmp13_ = NULL;
	Dimensions _tmp14_ = {0};
	BackingPhotoRow* _tmp15_ = NULL;
	Orientation _tmp16_ = 0;
#line 1102 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_BACKING_PHOTO_ROW (self));
#line 1102 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_BACKING_PHOTO_ROW (from));
#line 1103 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = from;
#line 1103 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_->id;
#line 1103 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->id = _tmp1_;
#line 1104 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = from;
#line 1104 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = _tmp2_->time_created;
#line 1104 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->time_created = _tmp3_;
#line 1105 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = from;
#line 1105 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = _tmp4_->filepath;
#line 1105 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 1105 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (self->filepath);
#line 1105 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->filepath = _tmp6_;
#line 1106 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = from;
#line 1106 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = _tmp7_->filesize;
#line 1106 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->filesize = _tmp8_;
#line 1107 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = from;
#line 1107 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = _tmp9_->timestamp;
#line 1107 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->timestamp = _tmp10_;
#line 1108 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = from;
#line 1108 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = _tmp11_->file_format;
#line 1108 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->file_format = _tmp12_;
#line 1109 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_ = from;
#line 1109 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = _tmp13_->dim;
#line 1109 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->dim = _tmp14_;
#line 1110 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_ = from;
#line 1110 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp16_ = _tmp15_->original_orientation;
#line 1110 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->original_orientation = _tmp16_;
#line 8015 "PhotoTable.c"
}


BackingPhotoRow* backing_photo_row_construct (GType object_type) {
	BackingPhotoRow* self = NULL;
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self = (BackingPhotoRow*) g_type_create_instance (object_type);
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return self;
#line 8025 "PhotoTable.c"
}


BackingPhotoRow* backing_photo_row_new (void) {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return backing_photo_row_construct (TYPE_BACKING_PHOTO_ROW);
#line 8032 "PhotoTable.c"
}


static void value_backing_photo_row_init (GValue* value) {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	value->data[0].v_pointer = NULL;
#line 8039 "PhotoTable.c"
}


static void value_backing_photo_row_free_value (GValue* value) {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (value->data[0].v_pointer) {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		backing_photo_row_unref (value->data[0].v_pointer);
#line 8048 "PhotoTable.c"
	}
}


static void value_backing_photo_row_copy_value (const GValue* src_value, GValue* dest_value) {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (src_value->data[0].v_pointer) {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		dest_value->data[0].v_pointer = backing_photo_row_ref (src_value->data[0].v_pointer);
#line 8058 "PhotoTable.c"
	} else {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		dest_value->data[0].v_pointer = NULL;
#line 8062 "PhotoTable.c"
	}
}


static gpointer value_backing_photo_row_peek_pointer (const GValue* value) {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return value->data[0].v_pointer;
#line 8070 "PhotoTable.c"
}


static gchar* value_backing_photo_row_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (collect_values[0].v_pointer) {
#line 8077 "PhotoTable.c"
		BackingPhotoRow* object;
		object = collect_values[0].v_pointer;
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (object->parent_instance.g_class == NULL) {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8084 "PhotoTable.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8088 "PhotoTable.c"
		}
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = backing_photo_row_ref (object);
#line 8092 "PhotoTable.c"
	} else {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = NULL;
#line 8096 "PhotoTable.c"
	}
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return NULL;
#line 8100 "PhotoTable.c"
}


static gchar* value_backing_photo_row_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BackingPhotoRow** object_p;
	object_p = collect_values[0].v_pointer;
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (!object_p) {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 8111 "PhotoTable.c"
	}
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (!value->data[0].v_pointer) {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		*object_p = NULL;
#line 8117 "PhotoTable.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		*object_p = value->data[0].v_pointer;
#line 8121 "PhotoTable.c"
	} else {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		*object_p = backing_photo_row_ref (value->data[0].v_pointer);
#line 8125 "PhotoTable.c"
	}
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return NULL;
#line 8129 "PhotoTable.c"
}


GParamSpec* param_spec_backing_photo_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecBackingPhotoRow* spec;
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BACKING_PHOTO_ROW), NULL);
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return G_PARAM_SPEC (spec);
#line 8143 "PhotoTable.c"
}


gpointer value_get_backing_photo_row (const GValue* value) {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKING_PHOTO_ROW), NULL);
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return value->data[0].v_pointer;
#line 8152 "PhotoTable.c"
}


void value_set_backing_photo_row (GValue* value, gpointer v_object) {
	BackingPhotoRow* old;
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKING_PHOTO_ROW));
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	old = value->data[0].v_pointer;
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (v_object) {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BACKING_PHOTO_ROW));
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = v_object;
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		backing_photo_row_ref (value->data[0].v_pointer);
#line 8172 "PhotoTable.c"
	} else {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = NULL;
#line 8176 "PhotoTable.c"
	}
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (old) {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		backing_photo_row_unref (old);
#line 8182 "PhotoTable.c"
	}
}


void value_take_backing_photo_row (GValue* value, gpointer v_object) {
	BackingPhotoRow* old;
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKING_PHOTO_ROW));
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	old = value->data[0].v_pointer;
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (v_object) {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BACKING_PHOTO_ROW));
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = v_object;
#line 8201 "PhotoTable.c"
	} else {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = NULL;
#line 8205 "PhotoTable.c"
	}
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (old) {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		backing_photo_row_unref (old);
#line 8211 "PhotoTable.c"
	}
}


static void backing_photo_row_class_init (BackingPhotoRowClass * klass) {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	backing_photo_row_parent_class = g_type_class_peek_parent (klass);
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	((BackingPhotoRowClass *) klass)->finalize = backing_photo_row_finalize;
#line 8221 "PhotoTable.c"
}


static void backing_photo_row_instance_init (BackingPhotoRow * self) {
#line 1080 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->filepath = NULL;
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->ref_count = 1;
#line 8230 "PhotoTable.c"
}


static void backing_photo_row_finalize (BackingPhotoRow* obj) {
	BackingPhotoRow * self;
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BACKING_PHOTO_ROW, BackingPhotoRow);
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_signal_handlers_destroy (self);
#line 1080 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (self->filepath);
#line 8242 "PhotoTable.c"
}


GType backing_photo_row_get_type (void) {
	static volatile gsize backing_photo_row_type_id__volatile = 0;
	if (g_once_init_enter (&backing_photo_row_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_backing_photo_row_init, value_backing_photo_row_free_value, value_backing_photo_row_copy_value, value_backing_photo_row_peek_pointer, "p", value_backing_photo_row_collect_value, "p", value_backing_photo_row_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BackingPhotoRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) backing_photo_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackingPhotoRow), 0, (GInstanceInitFunc) backing_photo_row_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType backing_photo_row_type_id;
		backing_photo_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BackingPhotoRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&backing_photo_row_type_id__volatile, backing_photo_row_type_id);
	}
	return backing_photo_row_type_id__volatile;
}


gpointer backing_photo_row_ref (gpointer instance) {
	BackingPhotoRow* self;
	self = instance;
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_atomic_int_inc (&self->ref_count);
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return instance;
#line 8267 "PhotoTable.c"
}


void backing_photo_row_unref (gpointer instance) {
	BackingPhotoRow* self;
	self = instance;
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		BACKING_PHOTO_ROW_GET_CLASS (self)->finalize (self);
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 8280 "PhotoTable.c"
	}
}


static BackingPhotoTable* backing_photo_table_construct (GType object_type) {
	BackingPhotoTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
#line 1117 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self = (BackingPhotoTable*) database_table_construct (object_type);
#line 1118 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_set_table_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), "BackingPhotoTable");
#line 1121 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 1121 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "CREATE TABLE IF NOT EXISTS " "BackingPhotoTable " "(" "id INTEGER PRIMARY KEY, " "filepath TEXT UNIQUE NOT NULL, " "timestamp INTEGER, " "filesize INTEGER, " "width INTEGER, " "height INTEGER, " "original_orientation INTEGER, " "file_format INTEGER, " "time_created INTEGER " ")", -1, &_tmp1_, NULL);
#line 1121 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1121 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 1121 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 1134 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 1134 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 1136 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 1136 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = sqlite3_step (_tmp4_);
#line 1136 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp5_;
#line 1137 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = res;
#line 1137 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp6_ != SQLITE_DONE) {
#line 8324 "PhotoTable.c"
		gint _tmp7_ = 0;
#line 1138 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp7_ = res;
#line 1138 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_fatal ("create PhotoBackingTable", _tmp7_);
#line 8330 "PhotoTable.c"
	}
#line 1117 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1117 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return self;
#line 8336 "PhotoTable.c"
}


static BackingPhotoTable* backing_photo_table_new (void) {
#line 1117 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return backing_photo_table_construct (TYPE_BACKING_PHOTO_TABLE);
#line 8343 "PhotoTable.c"
}


BackingPhotoTable* backing_photo_table_get_instance (void) {
	BackingPhotoTable* result = NULL;
	BackingPhotoTable* _tmp0_ = NULL;
	BackingPhotoTable* _tmp2_ = NULL;
	BackingPhotoTable* _tmp3_ = NULL;
#line 1142 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = backing_photo_table_instance;
#line 1142 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp0_ == NULL) {
#line 8356 "PhotoTable.c"
		BackingPhotoTable* _tmp1_ = NULL;
#line 1143 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp1_ = backing_photo_table_new ();
#line 1143 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_database_table_unref0 (backing_photo_table_instance);
#line 1143 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		backing_photo_table_instance = _tmp1_;
#line 8364 "PhotoTable.c"
	}
#line 1145 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = backing_photo_table_instance;
#line 1145 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = _database_table_ref0 (_tmp2_);
#line 1145 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp3_;
#line 1145 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 8374 "PhotoTable.c"
}


void backing_photo_table_add (BackingPhotoTable* self, BackingPhotoRow* state, GError** error) {
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	time_t time_created = 0;
	gulong _tmp4_ = 0UL;
	sqlite3_stmt* _tmp5_ = NULL;
	BackingPhotoRow* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GDestroyNotify _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	sqlite3_stmt* _tmp12_ = NULL;
	BackingPhotoRow* _tmp13_ = NULL;
	time_t _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	sqlite3_stmt* _tmp17_ = NULL;
	BackingPhotoRow* _tmp18_ = NULL;
	gint64 _tmp19_ = 0LL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	sqlite3_stmt* _tmp22_ = NULL;
	BackingPhotoRow* _tmp23_ = NULL;
	Dimensions _tmp24_ = {0};
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	sqlite3_stmt* _tmp28_ = NULL;
	BackingPhotoRow* _tmp29_ = NULL;
	Dimensions _tmp30_ = {0};
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	sqlite3_stmt* _tmp34_ = NULL;
	BackingPhotoRow* _tmp35_ = NULL;
	Orientation _tmp36_ = 0;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	sqlite3_stmt* _tmp39_ = NULL;
	BackingPhotoRow* _tmp40_ = NULL;
	PhotoFileFormat _tmp41_ = 0;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	gint _tmp44_ = 0;
	sqlite3_stmt* _tmp45_ = NULL;
	time_t _tmp46_ = 0;
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	sqlite3_stmt* _tmp49_ = NULL;
	gint _tmp50_ = 0;
	gint _tmp51_ = 0;
	BackingPhotoRow* _tmp53_ = NULL;
	sqlite3* _tmp54_ = NULL;
	gint64 _tmp55_ = 0LL;
	BackingPhotoRow* _tmp56_ = NULL;
	time_t _tmp57_ = 0;
	GError * _inner_error_ = NULL;
#line 1148 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_BACKING_PHOTO_TABLE (self));
#line 1148 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_BACKING_PHOTO_ROW (state));
#line 1150 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 1150 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "INSERT INTO BackingPhotoTable " "(filepath, timestamp, filesize, width, height, original_orientation, " "file_format, time_created) " "VALUES (?, ?, ?, ?, ?, ?, ?, ?)", -1, &_tmp1_, NULL);
#line 1150 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1150 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 1150 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 1155 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 1155 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 1157 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = now_sec ();
#line 1157 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	time_created = (time_t) _tmp4_;
#line 1159 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = stmt;
#line 1159 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = state;
#line 1159 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = _tmp6_->filepath;
#line 1159 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 1159 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = g_free;
#line 1159 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = sqlite3_bind_text (_tmp5_, 1, _tmp8_, -1, _tmp9_);
#line 1159 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp10_;
#line 1160 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = res;
#line 1160 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp11_ == SQLITE_OK, "res == Sqlite.OK");
#line 1161 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = stmt;
#line 1161 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_ = state;
#line 1161 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = _tmp13_->timestamp;
#line 1161 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_ = sqlite3_bind_int64 (_tmp12_, 2, (gint64) _tmp14_);
#line 1161 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp15_;
#line 1162 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp16_ = res;
#line 1162 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp16_ == SQLITE_OK, "res == Sqlite.OK");
#line 1163 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp17_ = stmt;
#line 1163 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp18_ = state;
#line 1163 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp19_ = _tmp18_->filesize;
#line 1163 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp20_ = sqlite3_bind_int64 (_tmp17_, 3, _tmp19_);
#line 1163 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp20_;
#line 1164 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp21_ = res;
#line 1164 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp21_ == SQLITE_OK, "res == Sqlite.OK");
#line 1165 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp22_ = stmt;
#line 1165 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp23_ = state;
#line 1165 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp24_ = _tmp23_->dim;
#line 1165 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp25_ = _tmp24_.width;
#line 1165 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp26_ = sqlite3_bind_int (_tmp22_, 4, _tmp25_);
#line 1165 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp26_;
#line 1166 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp27_ = res;
#line 1166 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp27_ == SQLITE_OK, "res == Sqlite.OK");
#line 1167 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp28_ = stmt;
#line 1167 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp29_ = state;
#line 1167 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp30_ = _tmp29_->dim;
#line 1167 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp31_ = _tmp30_.height;
#line 1167 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp32_ = sqlite3_bind_int (_tmp28_, 5, _tmp31_);
#line 1167 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp32_;
#line 1168 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp33_ = res;
#line 1168 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp33_ == SQLITE_OK, "res == Sqlite.OK");
#line 1169 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp34_ = stmt;
#line 1169 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp35_ = state;
#line 1169 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp36_ = _tmp35_->original_orientation;
#line 1169 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp37_ = sqlite3_bind_int (_tmp34_, 6, (gint) _tmp36_);
#line 1169 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp37_;
#line 1170 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp38_ = res;
#line 1170 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp38_ == SQLITE_OK, "res == Sqlite.OK");
#line 1171 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp39_ = stmt;
#line 1171 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp40_ = state;
#line 1171 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp41_ = _tmp40_->file_format;
#line 1171 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp42_ = photo_file_format_serialize (_tmp41_);
#line 1171 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp43_ = sqlite3_bind_int (_tmp39_, 7, _tmp42_);
#line 1171 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp43_;
#line 1172 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp44_ = res;
#line 1172 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp44_ == SQLITE_OK, "res == Sqlite.OK");
#line 1173 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp45_ = stmt;
#line 1173 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp46_ = time_created;
#line 1173 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp47_ = sqlite3_bind_int64 (_tmp45_, 8, (gint64) _tmp46_);
#line 1173 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp47_;
#line 1174 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp48_ = res;
#line 1174 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp48_ == SQLITE_OK, "res == Sqlite.OK");
#line 1176 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp49_ = stmt;
#line 1176 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp50_ = sqlite3_step (_tmp49_);
#line 1176 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp50_;
#line 1177 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp51_ = res;
#line 1177 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp51_ != SQLITE_DONE) {
#line 8592 "PhotoTable.c"
		gint _tmp52_ = 0;
#line 1178 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp52_ = res;
#line 1178 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_throw_error ("PhotoBackingTable.add", _tmp52_, &_inner_error_);
#line 1178 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1178 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 1178 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_propagate_error (error, _inner_error_);
#line 1178 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 1178 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				return;
#line 8608 "PhotoTable.c"
			} else {
#line 1178 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 1178 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1178 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_clear_error (&_inner_error_);
#line 1178 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				return;
#line 8618 "PhotoTable.c"
			}
		}
	}
#line 1180 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp53_ = state;
#line 1180 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp54_ = database_table_db;
#line 1180 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp55_ = sqlite3_last_insert_rowid (_tmp54_);
#line 1180 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	backing_photo_id_init (&_tmp53_->id, _tmp55_);
#line 1181 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp56_ = state;
#line 1181 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp57_ = time_created;
#line 1181 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp56_->time_created = _tmp57_;
#line 1148 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 8638 "PhotoTable.c"
}


BackingPhotoRow* backing_photo_table_fetch (BackingPhotoTable* self, BackingPhotoID* id, GError** error) {
	BackingPhotoRow* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	BackingPhotoID _tmp5_ = {0};
	gint64 _tmp6_ = 0LL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	sqlite3_stmt* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	BackingPhotoRow* row = NULL;
	BackingPhotoRow* _tmp14_ = NULL;
	BackingPhotoRow* _tmp15_ = NULL;
	BackingPhotoID _tmp16_ = {0};
	BackingPhotoRow* _tmp17_ = NULL;
	sqlite3_stmt* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	BackingPhotoRow* _tmp21_ = NULL;
	sqlite3_stmt* _tmp22_ = NULL;
	gint64 _tmp23_ = 0LL;
	BackingPhotoRow* _tmp24_ = NULL;
	sqlite3_stmt* _tmp25_ = NULL;
	gint64 _tmp26_ = 0LL;
	BackingPhotoRow* _tmp27_ = NULL;
	sqlite3_stmt* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	sqlite3_stmt* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	BackingPhotoRow* _tmp32_ = NULL;
	sqlite3_stmt* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	BackingPhotoRow* _tmp35_ = NULL;
	sqlite3_stmt* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	PhotoFileFormat _tmp38_ = 0;
	BackingPhotoRow* _tmp39_ = NULL;
	sqlite3_stmt* _tmp40_ = NULL;
	gint64 _tmp41_ = 0LL;
	GError * _inner_error_ = NULL;
#line 1184 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_BACKING_PHOTO_TABLE (self), NULL);
#line 1184 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 1186 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 1186 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT filepath, timestamp, filesize, width, height, " "original_orientation, file_format, time_created FROM BackingPhotoTable" \
" WHERE id=?", -1, &_tmp1_, NULL);
#line 1186 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1186 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 1186 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 1189 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 1189 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 1191 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 1191 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = *id;
#line 1191 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = _tmp5_.id;
#line 1191 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = sqlite3_bind_int64 (_tmp4_, 1, _tmp6_);
#line 1191 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp7_;
#line 1192 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = res;
#line 1192 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp8_ == SQLITE_OK, "res == Sqlite.OK");
#line 1194 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = stmt;
#line 1194 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = sqlite3_step (_tmp9_);
#line 1194 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp10_;
#line 1195 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = res;
#line 1195 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp11_ == SQLITE_DONE) {
#line 1196 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = NULL;
#line 1196 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 1196 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 8736 "PhotoTable.c"
	} else {
		gint _tmp12_ = 0;
#line 1197 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp12_ = res;
#line 1197 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_tmp12_ != SQLITE_ROW) {
#line 8743 "PhotoTable.c"
			gint _tmp13_ = 0;
#line 1198 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp13_ = res;
#line 1198 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			database_table_throw_error ("BackingPhotoTable.fetch_for_photo", _tmp13_, &_inner_error_);
#line 1198 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1198 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 1198 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					g_propagate_error (error, _inner_error_);
#line 1198 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_sqlite3_finalize0 (stmt);
#line 1198 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					return NULL;
#line 8759 "PhotoTable.c"
				} else {
#line 1198 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_sqlite3_finalize0 (stmt);
#line 1198 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1198 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					g_clear_error (&_inner_error_);
#line 1198 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					return NULL;
#line 8769 "PhotoTable.c"
				}
			}
		}
	}
#line 1200 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = backing_photo_row_new ();
#line 1200 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	row = _tmp14_;
#line 1201 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_ = row;
#line 1201 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp16_ = *id;
#line 1201 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_->id = _tmp16_;
#line 1202 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp17_ = row;
#line 1202 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp18_ = stmt;
#line 1202 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp19_ = sqlite3_column_text (_tmp18_, 0);
#line 1202 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp20_ = g_strdup (_tmp19_);
#line 1202 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (_tmp17_->filepath);
#line 1202 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp17_->filepath = _tmp20_;
#line 1203 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp21_ = row;
#line 1203 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp22_ = stmt;
#line 1203 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp23_ = sqlite3_column_int64 (_tmp22_, 1);
#line 1203 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp21_->timestamp = (time_t) _tmp23_;
#line 1204 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp24_ = row;
#line 1204 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp25_ = stmt;
#line 1204 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp26_ = sqlite3_column_int64 (_tmp25_, 2);
#line 1204 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp24_->filesize = _tmp26_;
#line 1205 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp27_ = row;
#line 1205 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp28_ = stmt;
#line 1205 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp29_ = sqlite3_column_int (_tmp28_, 3);
#line 1205 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp30_ = stmt;
#line 1205 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp31_ = sqlite3_column_int (_tmp30_, 4);
#line 1205 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	dimensions_init (&_tmp27_->dim, _tmp29_, _tmp31_);
#line 1206 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp32_ = row;
#line 1206 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp33_ = stmt;
#line 1206 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp34_ = sqlite3_column_int (_tmp33_, 5);
#line 1206 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp32_->original_orientation = (Orientation) _tmp34_;
#line 1207 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp35_ = row;
#line 1207 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp36_ = stmt;
#line 1207 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp37_ = sqlite3_column_int (_tmp36_, 6);
#line 1207 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp38_ = photo_file_format_unserialize (_tmp37_);
#line 1207 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp35_->file_format = _tmp38_;
#line 1208 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp39_ = row;
#line 1208 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp40_ = stmt;
#line 1208 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp41_ = sqlite3_column_int64 (_tmp40_, 7);
#line 1208 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp39_->time_created = (time_t) _tmp41_;
#line 1210 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = row;
#line 1210 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1210 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 8856 "PhotoTable.c"
}


void backing_photo_table_update (BackingPhotoTable* self, BackingPhotoRow* row, GError** error) {
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	BackingPhotoRow* _tmp5_ = NULL;
	time_t _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	sqlite3_stmt* _tmp9_ = NULL;
	BackingPhotoRow* _tmp10_ = NULL;
	gint64 _tmp11_ = 0LL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	sqlite3_stmt* _tmp14_ = NULL;
	BackingPhotoRow* _tmp15_ = NULL;
	Dimensions _tmp16_ = {0};
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	sqlite3_stmt* _tmp20_ = NULL;
	BackingPhotoRow* _tmp21_ = NULL;
	Dimensions _tmp22_ = {0};
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	sqlite3_stmt* _tmp26_ = NULL;
	BackingPhotoRow* _tmp27_ = NULL;
	Orientation _tmp28_ = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	sqlite3_stmt* _tmp31_ = NULL;
	BackingPhotoRow* _tmp32_ = NULL;
	PhotoFileFormat _tmp33_ = 0;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	sqlite3_stmt* _tmp37_ = NULL;
	BackingPhotoRow* _tmp38_ = NULL;
	BackingPhotoID _tmp39_ = {0};
	gint64 _tmp40_ = 0LL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	sqlite3_stmt* _tmp43_ = NULL;
	gint _tmp44_ = 0;
	gint _tmp45_ = 0;
	GError * _inner_error_ = NULL;
#line 1214 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_BACKING_PHOTO_TABLE (self));
#line 1214 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_BACKING_PHOTO_ROW (row));
#line 1216 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 1216 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE BackingPhotoTable SET timestamp=?, filesize=?, " "width=?, height=?, original_orientation=?, file_format=? " "WHERE id=?", -1, &_tmp1_, NULL);
#line 1216 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1216 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 1216 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 1220 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 1220 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 1222 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 1222 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = row;
#line 1222 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = _tmp5_->timestamp;
#line 1222 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = sqlite3_bind_int64 (_tmp4_, 1, (gint64) _tmp6_);
#line 1222 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp7_;
#line 1223 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = res;
#line 1223 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp8_ == SQLITE_OK, "res == Sqlite.OK");
#line 1224 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = stmt;
#line 1224 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = row;
#line 1224 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = _tmp10_->filesize;
#line 1224 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = sqlite3_bind_int64 (_tmp9_, 2, _tmp11_);
#line 1224 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp12_;
#line 1225 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_ = res;
#line 1225 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp13_ == SQLITE_OK, "res == Sqlite.OK");
#line 1226 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = stmt;
#line 1226 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_ = row;
#line 1226 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp16_ = _tmp15_->dim;
#line 1226 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp17_ = _tmp16_.width;
#line 1226 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp18_ = sqlite3_bind_int (_tmp14_, 3, _tmp17_);
#line 1226 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp18_;
#line 1227 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp19_ = res;
#line 1227 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp19_ == SQLITE_OK, "res == Sqlite.OK");
#line 1228 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp20_ = stmt;
#line 1228 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp21_ = row;
#line 1228 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp22_ = _tmp21_->dim;
#line 1228 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp23_ = _tmp22_.height;
#line 1228 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp24_ = sqlite3_bind_int (_tmp20_, 4, _tmp23_);
#line 1228 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp24_;
#line 1229 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp25_ = res;
#line 1229 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp25_ == SQLITE_OK, "res == Sqlite.OK");
#line 1230 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp26_ = stmt;
#line 1230 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp27_ = row;
#line 1230 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp28_ = _tmp27_->original_orientation;
#line 1230 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp29_ = sqlite3_bind_int (_tmp26_, 5, (gint) _tmp28_);
#line 1230 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp29_;
#line 1231 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp30_ = res;
#line 1231 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp30_ == SQLITE_OK, "res == Sqlite.OK");
#line 1232 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp31_ = stmt;
#line 1232 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp32_ = row;
#line 1232 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp33_ = _tmp32_->file_format;
#line 1232 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp34_ = photo_file_format_serialize (_tmp33_);
#line 1232 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp35_ = sqlite3_bind_int (_tmp31_, 6, _tmp34_);
#line 1232 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp35_;
#line 1233 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp36_ = res;
#line 1233 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp36_ == SQLITE_OK, "res == Sqlite.OK");
#line 1234 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp37_ = stmt;
#line 1234 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp38_ = row;
#line 1234 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp39_ = _tmp38_->id;
#line 1234 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp40_ = _tmp39_.id;
#line 1234 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp41_ = sqlite3_bind_int64 (_tmp37_, 7, _tmp40_);
#line 1234 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp41_;
#line 1235 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp42_ = res;
#line 1235 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp42_ == SQLITE_OK, "res == Sqlite.OK");
#line 1237 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp43_ = stmt;
#line 1237 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp44_ = sqlite3_step (_tmp43_);
#line 1237 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp44_;
#line 1238 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp45_ = res;
#line 1238 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp45_ != SQLITE_DONE) {
#line 9044 "PhotoTable.c"
		gint _tmp46_ = 0;
#line 1239 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp46_ = res;
#line 1239 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_throw_error ("BackingPhotoTable.update", _tmp46_, &_inner_error_);
#line 1239 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1239 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 1239 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_propagate_error (error, _inner_error_);
#line 1239 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 1239 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				return;
#line 9060 "PhotoTable.c"
			} else {
#line 1239 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 1239 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1239 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_clear_error (&_inner_error_);
#line 1239 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				return;
#line 9070 "PhotoTable.c"
			}
		}
	}
#line 1214 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 9076 "PhotoTable.c"
}


void backing_photo_table_update_attributes (BackingPhotoTable* self, BackingPhotoID* id, time_t timestamp, gint64 filesize, GError** error) {
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	time_t _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	sqlite3_stmt* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	sqlite3_stmt* _tmp12_ = NULL;
	BackingPhotoID _tmp13_ = {0};
	gint64 _tmp14_ = 0LL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	sqlite3_stmt* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	GError * _inner_error_ = NULL;
#line 1242 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_BACKING_PHOTO_TABLE (self));
#line 1242 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (id != NULL);
#line 1244 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 1244 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE BackingPhotoTable SET timestamp=?, filesize=? WHERE id=?", -1, &_tmp1_, NULL);
#line 1244 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1244 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 1244 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 1246 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 1246 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 1248 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 1248 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = timestamp;
#line 1248 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = sqlite3_bind_int64 (_tmp4_, 1, (gint64) _tmp5_);
#line 1248 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp6_;
#line 1249 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = res;
#line 1249 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 1250 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = stmt;
#line 1250 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = filesize;
#line 1250 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = sqlite3_bind_int64 (_tmp8_, 2, _tmp9_);
#line 1250 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp10_;
#line 1251 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = res;
#line 1251 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp11_ == SQLITE_OK, "res == Sqlite.OK");
#line 1252 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = stmt;
#line 1252 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_ = *id;
#line 1252 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = _tmp13_.id;
#line 1252 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_ = sqlite3_bind_int64 (_tmp12_, 3, _tmp14_);
#line 1252 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp15_;
#line 1253 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp16_ = res;
#line 1253 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp16_ == SQLITE_OK, "res == Sqlite.OK");
#line 1255 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp17_ = stmt;
#line 1255 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp18_ = sqlite3_step (_tmp17_);
#line 1255 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp18_;
#line 1256 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp19_ = res;
#line 1256 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp19_ != SQLITE_DONE) {
#line 9170 "PhotoTable.c"
		gint _tmp20_ = 0;
#line 1257 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp20_ = res;
#line 1257 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_throw_error ("BackingPhotoTable.update_attributes", _tmp20_, &_inner_error_);
#line 1257 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1257 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 1257 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_propagate_error (error, _inner_error_);
#line 1257 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 1257 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				return;
#line 9186 "PhotoTable.c"
			} else {
#line 1257 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 1257 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1257 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_clear_error (&_inner_error_);
#line 1257 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				return;
#line 9196 "PhotoTable.c"
			}
		}
	}
#line 1242 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 9202 "PhotoTable.c"
}


void backing_photo_table_remove (BackingPhotoTable* self, BackingPhotoID* backing_id, GError** error) {
	BackingPhotoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	GError * _inner_error_ = NULL;
#line 1260 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_BACKING_PHOTO_TABLE (self));
#line 1260 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (backing_id != NULL);
#line 1261 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *backing_id;
#line 1261 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 1261 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_delete_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, &_inner_error_);
#line 1261 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1261 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1261 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 1261 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 9228 "PhotoTable.c"
		} else {
#line 1261 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1261 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 1261 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 9236 "PhotoTable.c"
		}
	}
}


void backing_photo_table_set_filepath (BackingPhotoTable* self, BackingPhotoID* id, const gchar* filepath, GError** error) {
	BackingPhotoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	const gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 1264 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_BACKING_PHOTO_TABLE (self));
#line 1264 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (id != NULL);
#line 1264 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (filepath != NULL);
#line 1265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *id;
#line 1265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 1265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = filepath;
#line 1265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "filepath", _tmp2_, &_inner_error_);
#line 1265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 1265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 9269 "PhotoTable.c"
		} else {
#line 1265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 1265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 9277 "PhotoTable.c"
		}
	}
}


void backing_photo_table_update_timestamp (BackingPhotoTable* self, BackingPhotoID* id, time_t timestamp, GError** error) {
	BackingPhotoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	time_t _tmp2_ = 0;
	GError * _inner_error_ = NULL;
#line 1268 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_BACKING_PHOTO_TABLE (self));
#line 1268 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (id != NULL);
#line 1269 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *id;
#line 1269 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 1269 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = timestamp;
#line 1269 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "timestamp", (gint64) _tmp2_, &_inner_error_);
#line 1269 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1269 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1269 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 1269 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 9308 "PhotoTable.c"
		} else {
#line 1269 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1269 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 1269 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 9316 "PhotoTable.c"
		}
	}
}


static void backing_photo_table_class_init (BackingPhotoTableClass * klass) {
#line 1114 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	backing_photo_table_parent_class = g_type_class_peek_parent (klass);
#line 1114 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	((DatabaseTableClass *) klass)->finalize = backing_photo_table_finalize;
#line 9327 "PhotoTable.c"
}


static void backing_photo_table_instance_init (BackingPhotoTable * self) {
}


static void backing_photo_table_finalize (DatabaseTable* obj) {
	BackingPhotoTable * self;
#line 1114 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BACKING_PHOTO_TABLE, BackingPhotoTable);
#line 1114 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	DATABASE_TABLE_CLASS (backing_photo_table_parent_class)->finalize (obj);
#line 9341 "PhotoTable.c"
}


GType backing_photo_table_get_type (void) {
	static volatile gsize backing_photo_table_type_id__volatile = 0;
	if (g_once_init_enter (&backing_photo_table_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BackingPhotoTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) backing_photo_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackingPhotoTable), 0, (GInstanceInitFunc) backing_photo_table_instance_init, NULL };
		GType backing_photo_table_type_id;
		backing_photo_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "BackingPhotoTable", &g_define_type_info, 0);
		g_once_init_leave (&backing_photo_table_type_id__volatile, backing_photo_table_type_id);
	}
	return backing_photo_table_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



