/* TimedQueue.c generated by valac 0.34.2, the Vala compiler
 * generated from TimedQueue.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* TimedQueue is a specialized collection class.  It holds items in order, but rather than being*/
/* manually dequeued, they are dequeued automatically after a specified amount of time has elapsed*/
/* for that item.  As of today, it's possible the item will be dequeued a bit later than asked*/
/* for, but it will never be early.  Future implementations might tighten up the lateness.*/
/**/
/* The original design was to use a signal to notify when an item has been dequeued, but Vala has*/
/* a bug with passing an unnamed type as a signal parameter:*/
/* https://bugzilla.gnome.org/show_bug.cgi?id=628639*/
/**/
/* The rate the items come off the queue can be spaced out.  Note that this can cause items to back*/
/* up.  As of today, TimedQueue makes no effort to combat this.*/

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define TYPE_TIMED_QUEUE (timed_queue_get_type ())
#define TIMED_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TIMED_QUEUE, TimedQueue))
#define TIMED_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TIMED_QUEUE, TimedQueueClass))
#define IS_TIMED_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TIMED_QUEUE))
#define IS_TIMED_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TIMED_QUEUE))
#define TIMED_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TIMED_QUEUE, TimedQueueClass))

typedef struct _TimedQueue TimedQueue;
typedef struct _TimedQueueClass TimedQueueClass;
typedef struct _TimedQueuePrivate TimedQueuePrivate;

#define TYPE_SORTED_LIST (sorted_list_get_type ())
#define SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTED_LIST, SortedList))
#define SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTED_LIST, SortedListClass))
#define IS_SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTED_LIST))
#define IS_SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTED_LIST))
#define SORTED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTED_LIST, SortedListClass))

typedef struct _SortedList SortedList;
typedef struct _SortedListClass SortedListClass;

#define TIMED_QUEUE_TYPE_ELEMENT (timed_queue_element_get_type ())
#define TIMED_QUEUE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TIMED_QUEUE_TYPE_ELEMENT, TimedQueueElement))
#define TIMED_QUEUE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TIMED_QUEUE_TYPE_ELEMENT, TimedQueueElementClass))
#define TIMED_QUEUE_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TIMED_QUEUE_TYPE_ELEMENT))
#define TIMED_QUEUE_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TIMED_QUEUE_TYPE_ELEMENT))
#define TIMED_QUEUE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TIMED_QUEUE_TYPE_ELEMENT, TimedQueueElementClass))

typedef struct _TimedQueueElement TimedQueueElement;
typedef struct _TimedQueueElementClass TimedQueueElementClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _TimedQueueElementPrivate TimedQueueElementPrivate;
#define _timed_queue_element_unref0(var) ((var == NULL) ? NULL : (var = (timed_queue_element_unref (var), NULL)))
#define _g_destroy_func0(var) (((var == NULL) || (g_destroy_func == NULL)) ? NULL : (var = (g_destroy_func (var), NULL)))
typedef struct _TimedQueueParamSpecElement TimedQueueParamSpecElement;
typedef struct _ParamSpecTimedQueue ParamSpecTimedQueue;

#define TYPE_HASH_TIMED_QUEUE (hash_timed_queue_get_type ())
#define HASH_TIMED_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HASH_TIMED_QUEUE, HashTimedQueue))
#define HASH_TIMED_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HASH_TIMED_QUEUE, HashTimedQueueClass))
#define IS_HASH_TIMED_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HASH_TIMED_QUEUE))
#define IS_HASH_TIMED_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HASH_TIMED_QUEUE))
#define HASH_TIMED_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HASH_TIMED_QUEUE, HashTimedQueueClass))

typedef struct _HashTimedQueue HashTimedQueue;
typedef struct _HashTimedQueueClass HashTimedQueueClass;
typedef struct _HashTimedQueuePrivate HashTimedQueuePrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef void (*DequeuedCallback) (gconstpointer item, void* user_data);
struct _TimedQueue {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TimedQueuePrivate * priv;
};

struct _TimedQueueClass {
	GTypeClass parent_class;
	void (*finalize) (TimedQueue *self);
	void (*notify_dequeued) (TimedQueue* self, gconstpointer item);
	void (*clear) (TimedQueue* self);
	gboolean (*contains) (TimedQueue* self, gconstpointer item);
	gboolean (*enqueue) (TimedQueue* self, gconstpointer item);
	gboolean (*enqueue_many) (TimedQueue* self, GeeCollection* items);
	gboolean (*remove_first) (TimedQueue* self, gconstpointer item);
	void (*paused) (TimedQueue* self, gboolean is_paused);
	gint (*get_size) (TimedQueue* self);
};

struct _TimedQueuePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	guint hold_msec;
	DequeuedCallback callback;
	gpointer callback_target;
	GeeEqualDataFunc equal_func;
	gpointer equal_func_target;
	GDestroyNotify equal_func_target_destroy_notify;
	gint priority;
	guint timer_id;
	SortedList* queue;
	guint dequeue_spacing_msec;
	gulong last_dequeue;
	gboolean paused_state;
};

typedef gint64 (*Comparator) (void* a, void* b, void* user_data);
struct _TimedQueueElement {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TimedQueueElementPrivate * priv;
	gpointer item;
	gulong ready;
};

struct _TimedQueueElementClass {
	GTypeClass parent_class;
	void (*finalize) (TimedQueueElement *self);
};

struct _TimedQueueElementPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _TimedQueueParamSpecElement {
	GParamSpec parent_instance;
};

struct _ParamSpecTimedQueue {
	GParamSpec parent_instance;
};

struct _HashTimedQueue {
	TimedQueue parent_instance;
	HashTimedQueuePrivate * priv;
};

struct _HashTimedQueueClass {
	TimedQueueClass parent_class;
};

struct _HashTimedQueuePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeHashMap* item_count;
};


static gpointer timed_queue_parent_class = NULL;
static gpointer timed_queue_element_parent_class = NULL;
static gpointer hash_timed_queue_parent_class = NULL;

gpointer timed_queue_ref (gpointer instance);
void timed_queue_unref (gpointer instance);
GParamSpec* param_spec_timed_queue (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_timed_queue (GValue* value, gpointer v_object);
void value_take_timed_queue (GValue* value, gpointer v_object);
gpointer value_get_timed_queue (const GValue* value);
GType timed_queue_get_type (void) G_GNUC_CONST;
GType sorted_list_get_type (void) G_GNUC_CONST;
static gpointer timed_queue_element_ref (gpointer instance);
static void timed_queue_element_unref (gpointer instance);
static GParamSpec* timed_queue_param_spec_element (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void timed_queue_value_set_element (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void timed_queue_value_take_element (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer timed_queue_value_get_element (const GValue* value) G_GNUC_UNUSED;
static GType timed_queue_element_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define TIMED_QUEUE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TIMED_QUEUE, TimedQueuePrivate))
enum  {
	TIMED_QUEUE_DUMMY_PROPERTY
};
TimedQueue* timed_queue_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, guint hold_msec, DequeuedCallback callback, void* callback_target, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify, gint priority);
TimedQueue* timed_queue_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, guint hold_msec, DequeuedCallback callback, void* callback_target, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify, gint priority);
static gint64 timed_queue_element_comparator (void* a, void* b);
static gint64 _timed_queue_element_comparator_comparator (void* a, void* b, gpointer self);
SortedList* sorted_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, Comparator cmp, void* cmp_target);
SortedList* sorted_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, Comparator cmp, void* cmp_target);
static guint timed_queue_get_heartbeat_timeout (TimedQueue* self);
static gboolean timed_queue_on_heartbeat (TimedQueue* self);
static gboolean _timed_queue_on_heartbeat_gsource_func (gpointer self);
guint timed_queue_get_dequeue_spacing_msec (TimedQueue* self);
void timed_queue_set_dequeue_spacing_msec (TimedQueue* self, guint msec);
void timed_queue_notify_dequeued (TimedQueue* self, gconstpointer item);
static void timed_queue_real_notify_dequeued (TimedQueue* self, gconstpointer item);
gboolean timed_queue_is_paused (TimedQueue* self);
void timed_queue_pause (TimedQueue* self);
void timed_queue_unpause (TimedQueue* self);
void timed_queue_clear (TimedQueue* self);
static void timed_queue_real_clear (TimedQueue* self);
gboolean timed_queue_contains (TimedQueue* self, gconstpointer item);
static gboolean timed_queue_real_contains (TimedQueue* self, gconstpointer item);
gboolean timed_queue_enqueue (TimedQueue* self, gconstpointer item);
static gboolean timed_queue_real_enqueue (TimedQueue* self, gconstpointer item);
static gulong timed_queue_calc_ready_time (TimedQueue* self);
static TimedQueueElement* timed_queue_element_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer item, gulong ready);
static TimedQueueElement* timed_queue_element_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer item, gulong ready);
gboolean timed_queue_enqueue_many (TimedQueue* self, GeeCollection* items);
static gboolean timed_queue_real_enqueue_many (TimedQueue* self, GeeCollection* items);
gboolean sorted_list_add_list (SortedList* self, GeeList* items);
gboolean timed_queue_remove_first (TimedQueue* self, gconstpointer item);
static gboolean timed_queue_real_remove_first (TimedQueue* self, gconstpointer item);
gulong now_ms (void);
gpointer sorted_list_get_at (SortedList* self, gint index);
gpointer sorted_list_remove_at (SortedList* self, gint index);
gint timed_queue_get_size (TimedQueue* self);
static void timed_queue_real_paused (TimedQueue* self, gboolean is_paused);
#define TIMED_QUEUE_ELEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TIMED_QUEUE_TYPE_ELEMENT, TimedQueueElementPrivate))
enum  {
	TIMED_QUEUE_ELEMENT_DUMMY_PROPERTY
};
static void timed_queue_element_finalize (TimedQueueElement* obj);
static void timed_queue_finalize (TimedQueue* obj);
GType hash_timed_queue_get_type (void) G_GNUC_CONST;
#define HASH_TIMED_QUEUE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_HASH_TIMED_QUEUE, HashTimedQueuePrivate))
enum  {
	HASH_TIMED_QUEUE_DUMMY_PROPERTY
};
HashTimedQueue* hash_timed_queue_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, guint hold_msec, DequeuedCallback callback, void* callback_target, GeeHashDataFunc hash_func, void* hash_func_target, GDestroyNotify hash_func_target_destroy_notify, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify, gint priority);
HashTimedQueue* hash_timed_queue_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, guint hold_msec, DequeuedCallback callback, void* callback_target, GeeHashDataFunc hash_func, void* hash_func_target, GDestroyNotify hash_func_target_destroy_notify, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify, gint priority);
static void hash_timed_queue_real_notify_dequeued (TimedQueue* base, gconstpointer item);
static void hash_timed_queue_removed (HashTimedQueue* self, gconstpointer item);
static void hash_timed_queue_real_clear (TimedQueue* base);
static gboolean hash_timed_queue_real_contains (TimedQueue* base, gconstpointer item);
static gboolean hash_timed_queue_real_enqueue (TimedQueue* base, gconstpointer item);
static gboolean hash_timed_queue_real_enqueue_many (TimedQueue* base, GeeCollection* items);
static gboolean hash_timed_queue_real_remove_first (TimedQueue* base, gconstpointer item);
static void hash_timed_queue_finalize (TimedQueue* obj);


static gint64 _timed_queue_element_comparator_comparator (void* a, void* b, gpointer self) {
	gint64 result;
	result = timed_queue_element_comparator (a, b);
#line 64 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return result;
#line 249 "TimedQueue.c"
}


static gboolean _timed_queue_on_heartbeat_gsource_func (gpointer self) {
	gboolean result;
	result = timed_queue_on_heartbeat ((TimedQueue*) self);
#line 66 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return result;
#line 258 "TimedQueue.c"
}


TimedQueue* timed_queue_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, guint hold_msec, DequeuedCallback callback, void* callback_target, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify, gint priority) {
	TimedQueue* self = NULL;
	guint _tmp0_ = 0U;
	DequeuedCallback _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	GeeEqualDataFunc _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	gint _tmp7_ = 0;
	SortedList* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	gint _tmp10_ = 0;
	guint _tmp11_ = 0U;
#line 52 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self = (TimedQueue*) g_type_create_instance (object_type);
#line 52 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->g_type = g_type;
#line 52 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->g_dup_func = g_dup_func;
#line 52 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 54 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = hold_msec;
#line 54 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->hold_msec = _tmp0_;
#line 55 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp1_ = callback;
#line 55 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp1__target = callback_target;
#line 55 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->callback = _tmp1_;
#line 55 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->callback_target = _tmp1__target;
#line 57 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp2_ = equal_func;
#line 57 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp2__target = equal_func_target;
#line 57 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (_tmp2_ != NULL) {
#line 300 "TimedQueue.c"
		GeeEqualDataFunc _tmp3_ = NULL;
		void* _tmp3__target = NULL;
		GDestroyNotify _tmp3__target_destroy_notify = NULL;
#line 58 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp3_ = equal_func;
#line 58 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp3__target = equal_func_target;
#line 58 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp3__target_destroy_notify = equal_func_target_destroy_notify;
#line 58 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		equal_func_target_destroy_notify = NULL;
#line 58 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		(self->priv->equal_func_target_destroy_notify == NULL) ? NULL : (self->priv->equal_func_target_destroy_notify (self->priv->equal_func_target), NULL);
#line 58 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		self->priv->equal_func = NULL;
#line 58 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		self->priv->equal_func_target = NULL;
#line 58 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		self->priv->equal_func_target_destroy_notify = NULL;
#line 58 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		self->priv->equal_func = _tmp3_;
#line 58 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		self->priv->equal_func_target = _tmp3__target;
#line 58 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		self->priv->equal_func_target_destroy_notify = _tmp3__target_destroy_notify;
#line 326 "TimedQueue.c"
	} else {
		void* _tmp4_ = NULL;
		GDestroyNotify _tmp5_ = NULL;
		GeeEqualDataFunc _tmp6_ = NULL;
#line 60 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp6_ = gee_functions_get_equal_func_for (g_type, &_tmp4_, &_tmp5_);
#line 60 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		(self->priv->equal_func_target_destroy_notify == NULL) ? NULL : (self->priv->equal_func_target_destroy_notify (self->priv->equal_func_target), NULL);
#line 60 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		self->priv->equal_func = NULL;
#line 60 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		self->priv->equal_func_target = NULL;
#line 60 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		self->priv->equal_func_target_destroy_notify = NULL;
#line 60 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		self->priv->equal_func = (GeeEqualDataFunc) _tmp6_;
#line 60 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		self->priv->equal_func_target = _tmp4_;
#line 60 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		self->priv->equal_func_target_destroy_notify = _tmp5_;
#line 347 "TimedQueue.c"
	}
#line 62 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp7_ = priority;
#line 62 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->priority = _tmp7_;
#line 64 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp8_ = sorted_list_new (TIMED_QUEUE_TYPE_ELEMENT, (GBoxedCopyFunc) timed_queue_element_ref, timed_queue_element_unref, _timed_queue_element_comparator_comparator, NULL);
#line 64 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_g_object_unref0 (self->priv->queue);
#line 64 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->queue = _tmp8_;
#line 66 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp9_ = timed_queue_get_heartbeat_timeout (self);
#line 66 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp10_ = priority;
#line 66 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp11_ = g_timeout_add_full (_tmp10_, _tmp9_, _timed_queue_on_heartbeat_gsource_func, timed_queue_ref (self), timed_queue_unref);
#line 66 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->timer_id = _tmp11_;
#line 52 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
#line 52 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	equal_func = NULL;
#line 52 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	equal_func_target = NULL;
#line 52 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	equal_func_target_destroy_notify = NULL;
#line 52 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return self;
#line 377 "TimedQueue.c"
}


TimedQueue* timed_queue_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, guint hold_msec, DequeuedCallback callback, void* callback_target, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify, gint priority) {
#line 52 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return timed_queue_construct (TYPE_TIMED_QUEUE, g_type, g_dup_func, g_destroy_func, hold_msec, callback, callback_target, equal_func, equal_func_target, equal_func_target_destroy_notify, priority);
#line 384 "TimedQueue.c"
}


guint timed_queue_get_dequeue_spacing_msec (TimedQueue* self) {
	guint result = 0U;
	guint _tmp0_ = 0U;
#line 74 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_val_if_fail (IS_TIMED_QUEUE (self), 0U);
#line 75 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = self->priv->dequeue_spacing_msec;
#line 75 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	result = _tmp0_;
#line 75 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return result;
#line 399 "TimedQueue.c"
}


void timed_queue_set_dequeue_spacing_msec (TimedQueue* self, guint msec) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	gint _tmp6_ = 0;
	guint _tmp7_ = 0U;
#line 78 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_if_fail (IS_TIMED_QUEUE (self));
#line 79 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = msec;
#line 79 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp1_ = self->priv->dequeue_spacing_msec;
#line 79 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (_tmp0_ == _tmp1_) {
#line 80 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		return;
#line 421 "TimedQueue.c"
	}
#line 82 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp2_ = self->priv->timer_id;
#line 82 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (_tmp2_ != ((guint) 0)) {
#line 427 "TimedQueue.c"
		guint _tmp3_ = 0U;
#line 83 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp3_ = self->priv->timer_id;
#line 83 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		g_source_remove (_tmp3_);
#line 433 "TimedQueue.c"
	}
#line 85 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp4_ = msec;
#line 85 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->dequeue_spacing_msec = _tmp4_;
#line 87 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp5_ = timed_queue_get_heartbeat_timeout (self);
#line 87 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp6_ = self->priv->priority;
#line 87 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp7_ = g_timeout_add_full (_tmp6_, _tmp5_, _timed_queue_on_heartbeat_gsource_func, timed_queue_ref (self), timed_queue_unref);
#line 87 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->timer_id = _tmp7_;
#line 447 "TimedQueue.c"
}


static guint timed_queue_get_heartbeat_timeout (TimedQueue* self) {
	guint result = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp4_ = 0U;
#line 90 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_val_if_fail (IS_TIMED_QUEUE (self), 0U);
#line 91 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp1_ = self->priv->dequeue_spacing_msec;
#line 91 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (_tmp1_ == ((guint) 0)) {
#line 462 "TimedQueue.c"
		guint _tmp2_ = 0U;
#line 92 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp2_ = self->priv->hold_msec;
#line 92 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp0_ = _tmp2_ / 10;
#line 468 "TimedQueue.c"
	} else {
		guint _tmp3_ = 0U;
#line 93 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp3_ = self->priv->dequeue_spacing_msec;
#line 93 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp0_ = _tmp3_ / 2;
#line 475 "TimedQueue.c"
	}
#line 91 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp4_ = CLAMP (_tmp0_, (guint) 10, G_MAXUINT);
#line 91 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	result = _tmp4_;
#line 91 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return result;
#line 483 "TimedQueue.c"
}


static void timed_queue_real_notify_dequeued (TimedQueue* self, gconstpointer item) {
	DequeuedCallback _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	gconstpointer _tmp1_ = NULL;
#line 97 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = self->priv->callback;
#line 97 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0__target = self->priv->callback_target;
#line 97 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp1_ = item;
#line 97 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ (_tmp1_, _tmp0__target);
#line 499 "TimedQueue.c"
}


void timed_queue_notify_dequeued (TimedQueue* self, gconstpointer item) {
#line 96 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_if_fail (IS_TIMED_QUEUE (self));
#line 96 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	TIMED_QUEUE_GET_CLASS (self)->notify_dequeued (self, item);
#line 508 "TimedQueue.c"
}


gboolean timed_queue_is_paused (TimedQueue* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 100 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_val_if_fail (IS_TIMED_QUEUE (self), FALSE);
#line 101 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = self->priv->paused_state;
#line 101 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	result = _tmp0_;
#line 101 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return result;
#line 523 "TimedQueue.c"
}


void timed_queue_pause (TimedQueue* self) {
	gboolean _tmp0_ = FALSE;
#line 104 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_if_fail (IS_TIMED_QUEUE (self));
#line 105 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = self->priv->paused_state;
#line 105 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (_tmp0_) {
#line 106 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		return;
#line 537 "TimedQueue.c"
	}
#line 108 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->paused_state = TRUE;
#line 110 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_signal_emit_by_name (self, "paused", TRUE);
#line 543 "TimedQueue.c"
}


void timed_queue_unpause (TimedQueue* self) {
	gboolean _tmp0_ = FALSE;
#line 113 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_if_fail (IS_TIMED_QUEUE (self));
#line 114 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = self->priv->paused_state;
#line 114 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (!_tmp0_) {
#line 115 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		return;
#line 557 "TimedQueue.c"
	}
#line 117 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->paused_state = FALSE;
#line 119 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_signal_emit_by_name (self, "paused", FALSE);
#line 563 "TimedQueue.c"
}


static void timed_queue_real_clear (TimedQueue* self) {
	SortedList* _tmp0_ = NULL;
#line 123 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = self->priv->queue;
#line 123 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
#line 573 "TimedQueue.c"
}


void timed_queue_clear (TimedQueue* self) {
#line 122 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_if_fail (IS_TIMED_QUEUE (self));
#line 122 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	TIMED_QUEUE_GET_CLASS (self)->clear (self);
#line 582 "TimedQueue.c"
}


static gboolean timed_queue_real_contains (TimedQueue* self, gconstpointer item) {
	gboolean result = FALSE;
	{
		GeeIterator* _e_it = NULL;
		SortedList* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
#line 127 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp0_ = self->priv->queue;
#line 127 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
#line 127 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_e_it = _tmp1_;
#line 127 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		while (TRUE) {
#line 600 "TimedQueue.c"
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			TimedQueueElement* e = NULL;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			GeeEqualDataFunc _tmp6_ = NULL;
			void* _tmp6__target = NULL;
			gconstpointer _tmp7_ = NULL;
			TimedQueueElement* _tmp8_ = NULL;
			gconstpointer _tmp9_ = NULL;
			gboolean _tmp10_ = FALSE;
#line 127 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp2_ = _e_it;
#line 127 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 127 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			if (!_tmp3_) {
#line 127 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				break;
#line 620 "TimedQueue.c"
			}
#line 127 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp4_ = _e_it;
#line 127 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 127 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			e = (TimedQueueElement*) _tmp5_;
#line 128 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp6_ = self->priv->equal_func;
#line 128 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp6__target = self->priv->equal_func_target;
#line 128 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp7_ = item;
#line 128 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp8_ = e;
#line 128 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp9_ = _tmp8_->item;
#line 128 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp10_ = _tmp6_ (_tmp7_, _tmp9_, _tmp6__target);
#line 128 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			if (_tmp10_) {
#line 129 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				result = TRUE;
#line 129 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				_timed_queue_element_unref0 (e);
#line 129 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				_g_object_unref0 (_e_it);
#line 129 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				return result;
#line 650 "TimedQueue.c"
			}
#line 127 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_timed_queue_element_unref0 (e);
#line 654 "TimedQueue.c"
		}
#line 127 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_g_object_unref0 (_e_it);
#line 658 "TimedQueue.c"
	}
#line 132 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	result = FALSE;
#line 132 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return result;
#line 664 "TimedQueue.c"
}


gboolean timed_queue_contains (TimedQueue* self, gconstpointer item) {
#line 126 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_val_if_fail (IS_TIMED_QUEUE (self), FALSE);
#line 126 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return TIMED_QUEUE_GET_CLASS (self)->contains (self, item);
#line 673 "TimedQueue.c"
}


static gboolean timed_queue_real_enqueue (TimedQueue* self, gconstpointer item) {
	gboolean result = FALSE;
	SortedList* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	gulong _tmp2_ = 0UL;
	TimedQueueElement* _tmp3_ = NULL;
	TimedQueueElement* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
#line 136 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = self->priv->queue;
#line 136 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp1_ = item;
#line 136 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp2_ = timed_queue_calc_ready_time (self);
#line 136 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp3_ = timed_queue_element_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, _tmp1_, _tmp2_);
#line 136 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp4_ = _tmp3_;
#line 136 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp5_ = gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), _tmp4_);
#line 136 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp6_ = _tmp5_;
#line 136 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_timed_queue_element_unref0 (_tmp4_);
#line 136 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	result = _tmp6_;
#line 136 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return result;
#line 706 "TimedQueue.c"
}


gboolean timed_queue_enqueue (TimedQueue* self, gconstpointer item) {
#line 135 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_val_if_fail (IS_TIMED_QUEUE (self), FALSE);
#line 135 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return TIMED_QUEUE_GET_CLASS (self)->enqueue (self, item);
#line 715 "TimedQueue.c"
}


static gboolean timed_queue_real_enqueue_many (TimedQueue* self, GeeCollection* items) {
	gboolean result = FALSE;
	gulong ready_time = 0UL;
	gulong _tmp0_ = 0UL;
	GeeArrayList* elements = NULL;
	GeeArrayList* _tmp1_ = NULL;
	SortedList* _tmp13_ = NULL;
	GeeArrayList* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
#line 139 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (items), FALSE);
#line 140 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = timed_queue_calc_ready_time (self);
#line 140 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	ready_time = _tmp0_;
#line 142 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp1_ = gee_array_list_new (TIMED_QUEUE_TYPE_ELEMENT, (GBoxedCopyFunc) timed_queue_element_ref, timed_queue_element_unref, NULL, NULL, NULL);
#line 142 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	elements = _tmp1_;
#line 738 "TimedQueue.c"
	{
		GeeIterator* _item_it = NULL;
		GeeCollection* _tmp2_ = NULL;
		GeeIterator* _tmp3_ = NULL;
#line 143 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp2_ = items;
#line 143 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 143 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_item_it = _tmp3_;
#line 143 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		while (TRUE) {
#line 751 "TimedQueue.c"
			GeeIterator* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			gpointer item = NULL;
			GeeIterator* _tmp6_ = NULL;
			gpointer _tmp7_ = NULL;
			GeeArrayList* _tmp8_ = NULL;
			gconstpointer _tmp9_ = NULL;
			gulong _tmp10_ = 0UL;
			TimedQueueElement* _tmp11_ = NULL;
			TimedQueueElement* _tmp12_ = NULL;
#line 143 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp4_ = _item_it;
#line 143 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp5_ = gee_iterator_next (_tmp4_);
#line 143 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			if (!_tmp5_) {
#line 143 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				break;
#line 770 "TimedQueue.c"
			}
#line 143 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp6_ = _item_it;
#line 143 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 143 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			item = _tmp7_;
#line 144 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp8_ = elements;
#line 144 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp9_ = item;
#line 144 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp10_ = ready_time;
#line 144 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp11_ = timed_queue_element_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, _tmp9_, _tmp10_);
#line 144 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp12_ = _tmp11_;
#line 144 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp12_);
#line 144 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_timed_queue_element_unref0 (_tmp12_);
#line 143 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
#line 794 "TimedQueue.c"
		}
#line 143 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_g_object_unref0 (_item_it);
#line 798 "TimedQueue.c"
	}
#line 146 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp13_ = self->priv->queue;
#line 146 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp14_ = elements;
#line 146 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp15_ = sorted_list_add_list (_tmp13_, G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_LIST, GeeList));
#line 146 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	result = _tmp15_;
#line 146 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_g_object_unref0 (elements);
#line 146 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return result;
#line 812 "TimedQueue.c"
}


gboolean timed_queue_enqueue_many (TimedQueue* self, GeeCollection* items) {
#line 139 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_val_if_fail (IS_TIMED_QUEUE (self), FALSE);
#line 139 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return TIMED_QUEUE_GET_CLASS (self)->enqueue_many (self, items);
#line 821 "TimedQueue.c"
}


static gboolean timed_queue_real_remove_first (TimedQueue* self, gconstpointer item) {
	gboolean result = FALSE;
	GeeIterator* iter = NULL;
	SortedList* _tmp0_ = NULL;
	GeeIterator* _tmp1_ = NULL;
#line 150 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = self->priv->queue;
#line 150 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
#line 150 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	iter = _tmp1_;
#line 151 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	while (TRUE) {
#line 838 "TimedQueue.c"
		GeeIterator* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		TimedQueueElement* e = NULL;
		GeeIterator* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		GeeEqualDataFunc _tmp6_ = NULL;
		void* _tmp6__target = NULL;
		gconstpointer _tmp7_ = NULL;
		TimedQueueElement* _tmp8_ = NULL;
		gconstpointer _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
#line 151 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp2_ = iter;
#line 151 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp3_ = gee_iterator_next (_tmp2_);
#line 151 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		if (!_tmp3_) {
#line 151 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			break;
#line 858 "TimedQueue.c"
		}
#line 152 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp4_ = iter;
#line 152 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp5_ = gee_iterator_get (_tmp4_);
#line 152 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		e = (TimedQueueElement*) _tmp5_;
#line 153 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp6_ = self->priv->equal_func;
#line 153 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp6__target = self->priv->equal_func_target;
#line 153 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp7_ = item;
#line 153 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp8_ = e;
#line 153 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp9_ = _tmp8_->item;
#line 153 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp10_ = _tmp6_ (_tmp7_, _tmp9_, _tmp6__target);
#line 153 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		if (_tmp10_) {
#line 880 "TimedQueue.c"
			GeeIterator* _tmp11_ = NULL;
#line 154 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp11_ = iter;
#line 154 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			gee_iterator_remove (_tmp11_);
#line 156 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			result = TRUE;
#line 156 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_timed_queue_element_unref0 (e);
#line 156 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_g_object_unref0 (iter);
#line 156 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			return result;
#line 894 "TimedQueue.c"
		}
#line 151 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_timed_queue_element_unref0 (e);
#line 898 "TimedQueue.c"
	}
#line 160 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	result = FALSE;
#line 160 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_g_object_unref0 (iter);
#line 160 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return result;
#line 906 "TimedQueue.c"
}


gboolean timed_queue_remove_first (TimedQueue* self, gconstpointer item) {
#line 149 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_val_if_fail (IS_TIMED_QUEUE (self), FALSE);
#line 149 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return TIMED_QUEUE_GET_CLASS (self)->remove_first (self, item);
#line 915 "TimedQueue.c"
}


static gulong timed_queue_calc_ready_time (TimedQueue* self) {
	gulong result = 0UL;
	gulong _tmp0_ = 0UL;
	guint _tmp1_ = 0U;
#line 169 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_val_if_fail (IS_TIMED_QUEUE (self), 0UL);
#line 170 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = now_ms ();
#line 170 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp1_ = self->priv->hold_msec;
#line 170 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	result = _tmp0_ + ((gulong) _tmp1_);
#line 170 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return result;
#line 933 "TimedQueue.c"
}


static gboolean timed_queue_on_heartbeat (TimedQueue* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gulong now = 0UL;
#line 173 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_val_if_fail (IS_TIMED_QUEUE (self), FALSE);
#line 174 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = self->priv->paused_state;
#line 174 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (_tmp0_) {
#line 175 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		result = TRUE;
#line 175 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		return result;
#line 951 "TimedQueue.c"
	}
#line 177 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	now = (gulong) 0;
#line 955 "TimedQueue.c"
	{
		gboolean _tmp1_ = FALSE;
#line 179 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp1_ = TRUE;
#line 179 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		while (TRUE) {
#line 962 "TimedQueue.c"
			SortedList* _tmp2_ = NULL;
			gint _tmp3_ = 0;
			gint _tmp4_ = 0;
			TimedQueueElement* head = NULL;
			SortedList* _tmp5_ = NULL;
			gpointer _tmp6_ = NULL;
			TimedQueueElement* _tmp7_ = NULL;
			gulong _tmp8_ = 0UL;
			TimedQueueElement* _tmp10_ = NULL;
			gulong _tmp11_ = 0UL;
			gulong _tmp12_ = 0UL;
			gboolean _tmp13_ = FALSE;
			guint _tmp14_ = 0U;
			TimedQueueElement* h = NULL;
			SortedList* _tmp18_ = NULL;
			gpointer _tmp19_ = NULL;
			TimedQueueElement* _tmp20_ = NULL;
			TimedQueueElement* _tmp21_ = NULL;
			TimedQueueElement* _tmp22_ = NULL;
			gconstpointer _tmp23_ = NULL;
			gulong _tmp24_ = 0UL;
			guint _tmp25_ = 0U;
#line 179 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			if (!_tmp1_) {
#line 987 "TimedQueue.c"
			}
#line 179 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp1_ = FALSE;
#line 180 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp2_ = self->priv->queue;
#line 180 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
#line 180 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp4_ = _tmp3_;
#line 180 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			if (_tmp4_ == 0) {
#line 181 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				break;
#line 1001 "TimedQueue.c"
			}
#line 183 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp5_ = self->priv->queue;
#line 183 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp6_ = sorted_list_get_at (_tmp5_, 0);
#line 183 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			head = (TimedQueueElement*) _tmp6_;
#line 184 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp7_ = head;
#line 184 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_vala_assert (_tmp7_ != NULL, "head != null");
#line 186 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp8_ = now;
#line 186 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			if (_tmp8_ == ((gulong) 0)) {
#line 1017 "TimedQueue.c"
				gulong _tmp9_ = 0UL;
#line 187 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				_tmp9_ = now_ms ();
#line 187 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				now = _tmp9_;
#line 1023 "TimedQueue.c"
			}
#line 189 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp10_ = head;
#line 189 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp11_ = _tmp10_->ready;
#line 189 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp12_ = now;
#line 189 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			if (_tmp11_ > _tmp12_) {
#line 190 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				_timed_queue_element_unref0 (head);
#line 190 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				break;
#line 1037 "TimedQueue.c"
			}
#line 193 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp14_ = self->priv->dequeue_spacing_msec;
#line 193 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			if (_tmp14_ != ((guint) 0)) {
#line 1043 "TimedQueue.c"
				gulong _tmp15_ = 0UL;
				gulong _tmp16_ = 0UL;
				guint _tmp17_ = 0U;
#line 193 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				_tmp15_ = now;
#line 193 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				_tmp16_ = self->priv->last_dequeue;
#line 193 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				_tmp17_ = self->priv->dequeue_spacing_msec;
#line 193 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				_tmp13_ = (_tmp15_ - _tmp16_) < ((gulong) _tmp17_);
#line 1055 "TimedQueue.c"
			} else {
#line 193 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				_tmp13_ = FALSE;
#line 1059 "TimedQueue.c"
			}
#line 193 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			if (_tmp13_) {
#line 194 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				_timed_queue_element_unref0 (head);
#line 194 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				break;
#line 1067 "TimedQueue.c"
			}
#line 196 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp18_ = self->priv->queue;
#line 196 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp19_ = sorted_list_remove_at (_tmp18_, 0);
#line 196 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			h = (TimedQueueElement*) _tmp19_;
#line 197 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp20_ = head;
#line 197 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp21_ = h;
#line 197 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_vala_assert (_tmp20_ == _tmp21_, "head == h");
#line 199 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp22_ = head;
#line 199 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp23_ = _tmp22_->item;
#line 199 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			timed_queue_notify_dequeued (self, _tmp23_);
#line 200 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp24_ = now;
#line 200 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			self->priv->last_dequeue = _tmp24_;
#line 204 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp25_ = self->priv->dequeue_spacing_msec;
#line 204 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			if (_tmp25_ != ((guint) 0)) {
#line 205 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				_timed_queue_element_unref0 (h);
#line 205 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				_timed_queue_element_unref0 (head);
#line 205 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				break;
#line 1101 "TimedQueue.c"
			}
#line 179 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_timed_queue_element_unref0 (h);
#line 179 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_timed_queue_element_unref0 (head);
#line 1107 "TimedQueue.c"
		}
	}
#line 208 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	result = TRUE;
#line 208 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return result;
#line 1114 "TimedQueue.c"
}


gint timed_queue_get_size (TimedQueue* self) {
#line 164 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_val_if_fail (IS_TIMED_QUEUE (self), 0);
#line 164 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return TIMED_QUEUE_GET_CLASS (self)->get_size (self);
#line 1123 "TimedQueue.c"
}


static gint timed_queue_real_get_size (TimedQueue* base) {
	gint result;
	TimedQueue* self;
	SortedList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 164 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self = base;
#line 165 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = self->priv->queue;
#line 165 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
#line 165 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp2_ = _tmp1_;
#line 165 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	result = _tmp2_;
#line 165 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return result;
#line 1145 "TimedQueue.c"
}


static void timed_queue_real_paused (TimedQueue* self, gboolean is_paused) {
}


static TimedQueueElement* timed_queue_element_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer item, gulong ready) {
	TimedQueueElement* self = NULL;
	gconstpointer _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	gulong _tmp2_ = 0UL;
#line 26 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self = (TimedQueueElement*) g_type_create_instance (object_type);
#line 26 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->g_type = g_type;
#line 26 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->g_dup_func = g_dup_func;
#line 26 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 27 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = item;
#line 27 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp1_ = ((_tmp0_ != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) _tmp0_) : ((gpointer) _tmp0_);
#line 27 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_g_destroy_func0 (self->item);
#line 27 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->item = _tmp1_;
#line 28 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp2_ = ready;
#line 28 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->ready = _tmp2_;
#line 26 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return self;
#line 1180 "TimedQueue.c"
}


static TimedQueueElement* timed_queue_element_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer item, gulong ready) {
#line 26 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return timed_queue_element_construct (TIMED_QUEUE_TYPE_ELEMENT, g_type, g_dup_func, g_destroy_func, item, ready);
#line 1187 "TimedQueue.c"
}


static gint64 timed_queue_element_comparator (void* a, void* b) {
	gint64 result = 0LL;
	void* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	void* _tmp2_ = NULL;
	gulong _tmp3_ = 0UL;
#line 32 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = a;
#line 32 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST ((TimedQueueElement*) _tmp0_, TIMED_QUEUE_TYPE_ELEMENT, TimedQueueElement)->ready;
#line 32 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp2_ = b;
#line 32 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST ((TimedQueueElement*) _tmp2_, TIMED_QUEUE_TYPE_ELEMENT, TimedQueueElement)->ready;
#line 32 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	result = ((gint64) _tmp1_) - ((gint64) _tmp3_);
#line 32 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return result;
#line 1209 "TimedQueue.c"
}


static void timed_queue_value_element_init (GValue* value) {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	value->data[0].v_pointer = NULL;
#line 1216 "TimedQueue.c"
}


static void timed_queue_value_element_free_value (GValue* value) {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (value->data[0].v_pointer) {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		timed_queue_element_unref (value->data[0].v_pointer);
#line 1225 "TimedQueue.c"
	}
}


static void timed_queue_value_element_copy_value (const GValue* src_value, GValue* dest_value) {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (src_value->data[0].v_pointer) {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		dest_value->data[0].v_pointer = timed_queue_element_ref (src_value->data[0].v_pointer);
#line 1235 "TimedQueue.c"
	} else {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1239 "TimedQueue.c"
	}
}


static gpointer timed_queue_value_element_peek_pointer (const GValue* value) {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return value->data[0].v_pointer;
#line 1247 "TimedQueue.c"
}


static gchar* timed_queue_value_element_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (collect_values[0].v_pointer) {
#line 1254 "TimedQueue.c"
		TimedQueueElement* object;
		object = collect_values[0].v_pointer;
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		if (object->parent_instance.g_class == NULL) {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1261 "TimedQueue.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1265 "TimedQueue.c"
		}
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		value->data[0].v_pointer = timed_queue_element_ref (object);
#line 1269 "TimedQueue.c"
	} else {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		value->data[0].v_pointer = NULL;
#line 1273 "TimedQueue.c"
	}
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return NULL;
#line 1277 "TimedQueue.c"
}


static gchar* timed_queue_value_element_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TimedQueueElement** object_p;
	object_p = collect_values[0].v_pointer;
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (!object_p) {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1288 "TimedQueue.c"
	}
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (!value->data[0].v_pointer) {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		*object_p = NULL;
#line 1294 "TimedQueue.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		*object_p = value->data[0].v_pointer;
#line 1298 "TimedQueue.c"
	} else {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		*object_p = timed_queue_element_ref (value->data[0].v_pointer);
#line 1302 "TimedQueue.c"
	}
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return NULL;
#line 1306 "TimedQueue.c"
}


static GParamSpec* timed_queue_param_spec_element (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TimedQueueParamSpecElement* spec;
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TIMED_QUEUE_TYPE_ELEMENT), NULL);
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return G_PARAM_SPEC (spec);
#line 1320 "TimedQueue.c"
}


static gpointer timed_queue_value_get_element (const GValue* value) {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TIMED_QUEUE_TYPE_ELEMENT), NULL);
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return value->data[0].v_pointer;
#line 1329 "TimedQueue.c"
}


static void timed_queue_value_set_element (GValue* value, gpointer v_object) {
	TimedQueueElement* old;
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TIMED_QUEUE_TYPE_ELEMENT));
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	old = value->data[0].v_pointer;
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (v_object) {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TIMED_QUEUE_TYPE_ELEMENT));
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		value->data[0].v_pointer = v_object;
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		timed_queue_element_ref (value->data[0].v_pointer);
#line 1349 "TimedQueue.c"
	} else {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		value->data[0].v_pointer = NULL;
#line 1353 "TimedQueue.c"
	}
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (old) {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		timed_queue_element_unref (old);
#line 1359 "TimedQueue.c"
	}
}


static void timed_queue_value_take_element (GValue* value, gpointer v_object) {
	TimedQueueElement* old;
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TIMED_QUEUE_TYPE_ELEMENT));
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	old = value->data[0].v_pointer;
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (v_object) {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TIMED_QUEUE_TYPE_ELEMENT));
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		value->data[0].v_pointer = v_object;
#line 1378 "TimedQueue.c"
	} else {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		value->data[0].v_pointer = NULL;
#line 1382 "TimedQueue.c"
	}
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (old) {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		timed_queue_element_unref (old);
#line 1388 "TimedQueue.c"
	}
}


static void timed_queue_element_class_init (TimedQueueElementClass * klass) {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	timed_queue_element_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	((TimedQueueElementClass *) klass)->finalize = timed_queue_element_finalize;
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_type_class_add_private (klass, sizeof (TimedQueueElementPrivate));
#line 1400 "TimedQueue.c"
}


static void timed_queue_element_instance_init (TimedQueueElement * self) {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv = TIMED_QUEUE_ELEMENT_GET_PRIVATE (self);
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->ref_count = 1;
#line 1409 "TimedQueue.c"
}


static void timed_queue_element_finalize (TimedQueueElement* obj) {
	TimedQueueElement * self;
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TIMED_QUEUE_TYPE_ELEMENT, TimedQueueElement);
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_signal_handlers_destroy (self);
#line 23 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	((self->item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->item = (self->priv->g_destroy_func (self->item), NULL));
#line 1421 "TimedQueue.c"
}


static GType timed_queue_element_get_type (void) {
	static volatile gsize timed_queue_element_type_id__volatile = 0;
	if (g_once_init_enter (&timed_queue_element_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { timed_queue_value_element_init, timed_queue_value_element_free_value, timed_queue_value_element_copy_value, timed_queue_value_element_peek_pointer, "p", timed_queue_value_element_collect_value, "p", timed_queue_value_element_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TimedQueueElementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) timed_queue_element_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TimedQueueElement), 0, (GInstanceInitFunc) timed_queue_element_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType timed_queue_element_type_id;
		timed_queue_element_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TimedQueueElement", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&timed_queue_element_type_id__volatile, timed_queue_element_type_id);
	}
	return timed_queue_element_type_id__volatile;
}


static gpointer timed_queue_element_ref (gpointer instance) {
	TimedQueueElement* self;
	self = instance;
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_atomic_int_inc (&self->ref_count);
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return instance;
#line 1446 "TimedQueue.c"
}


static void timed_queue_element_unref (gpointer instance) {
	TimedQueueElement* self;
	self = instance;
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		TIMED_QUEUE_ELEMENT_GET_CLASS (self)->finalize (self);
#line 22 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1459 "TimedQueue.c"
	}
}


static void value_timed_queue_init (GValue* value) {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	value->data[0].v_pointer = NULL;
#line 1467 "TimedQueue.c"
}


static void value_timed_queue_free_value (GValue* value) {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (value->data[0].v_pointer) {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		timed_queue_unref (value->data[0].v_pointer);
#line 1476 "TimedQueue.c"
	}
}


static void value_timed_queue_copy_value (const GValue* src_value, GValue* dest_value) {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (src_value->data[0].v_pointer) {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		dest_value->data[0].v_pointer = timed_queue_ref (src_value->data[0].v_pointer);
#line 1486 "TimedQueue.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1490 "TimedQueue.c"
	}
}


static gpointer value_timed_queue_peek_pointer (const GValue* value) {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return value->data[0].v_pointer;
#line 1498 "TimedQueue.c"
}


static gchar* value_timed_queue_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (collect_values[0].v_pointer) {
#line 1505 "TimedQueue.c"
		TimedQueue* object;
		object = collect_values[0].v_pointer;
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		if (object->parent_instance.g_class == NULL) {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1512 "TimedQueue.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1516 "TimedQueue.c"
		}
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		value->data[0].v_pointer = timed_queue_ref (object);
#line 1520 "TimedQueue.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		value->data[0].v_pointer = NULL;
#line 1524 "TimedQueue.c"
	}
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return NULL;
#line 1528 "TimedQueue.c"
}


static gchar* value_timed_queue_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TimedQueue** object_p;
	object_p = collect_values[0].v_pointer;
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (!object_p) {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1539 "TimedQueue.c"
	}
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (!value->data[0].v_pointer) {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		*object_p = NULL;
#line 1545 "TimedQueue.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		*object_p = value->data[0].v_pointer;
#line 1549 "TimedQueue.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		*object_p = timed_queue_ref (value->data[0].v_pointer);
#line 1553 "TimedQueue.c"
	}
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return NULL;
#line 1557 "TimedQueue.c"
}


GParamSpec* param_spec_timed_queue (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTimedQueue* spec;
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TIMED_QUEUE), NULL);
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return G_PARAM_SPEC (spec);
#line 1571 "TimedQueue.c"
}


gpointer value_get_timed_queue (const GValue* value) {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TIMED_QUEUE), NULL);
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return value->data[0].v_pointer;
#line 1580 "TimedQueue.c"
}


void value_set_timed_queue (GValue* value, gpointer v_object) {
	TimedQueue* old;
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TIMED_QUEUE));
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	old = value->data[0].v_pointer;
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (v_object) {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TIMED_QUEUE));
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		value->data[0].v_pointer = v_object;
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		timed_queue_ref (value->data[0].v_pointer);
#line 1600 "TimedQueue.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		value->data[0].v_pointer = NULL;
#line 1604 "TimedQueue.c"
	}
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (old) {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		timed_queue_unref (old);
#line 1610 "TimedQueue.c"
	}
}


void value_take_timed_queue (GValue* value, gpointer v_object) {
	TimedQueue* old;
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TIMED_QUEUE));
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	old = value->data[0].v_pointer;
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (v_object) {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TIMED_QUEUE));
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		value->data[0].v_pointer = v_object;
#line 1629 "TimedQueue.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		value->data[0].v_pointer = NULL;
#line 1633 "TimedQueue.c"
	}
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (old) {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		timed_queue_unref (old);
#line 1639 "TimedQueue.c"
	}
}


static void timed_queue_class_init (TimedQueueClass * klass) {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	timed_queue_parent_class = g_type_class_peek_parent (klass);
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	((TimedQueueClass *) klass)->finalize = timed_queue_finalize;
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_type_class_add_private (klass, sizeof (TimedQueuePrivate));
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	((TimedQueueClass *) klass)->notify_dequeued = timed_queue_real_notify_dequeued;
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	((TimedQueueClass *) klass)->clear = timed_queue_real_clear;
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	((TimedQueueClass *) klass)->contains = timed_queue_real_contains;
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	((TimedQueueClass *) klass)->enqueue = timed_queue_real_enqueue;
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	((TimedQueueClass *) klass)->enqueue_many = timed_queue_real_enqueue_many;
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	((TimedQueueClass *) klass)->remove_first = timed_queue_real_remove_first;
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	((TimedQueueClass *) klass)->paused = timed_queue_real_paused;
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	TIMED_QUEUE_CLASS (klass)->get_size = timed_queue_real_get_size;
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_signal_new ("paused", TYPE_TIMED_QUEUE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (TimedQueueClass, paused), NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
#line 1669 "TimedQueue.c"
}


static void timed_queue_instance_init (TimedQueue * self) {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv = TIMED_QUEUE_GET_PRIVATE (self);
#line 40 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->timer_id = (guint) 0;
#line 42 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->dequeue_spacing_msec = (guint) 0;
#line 43 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->last_dequeue = (gulong) 0;
#line 44 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->paused_state = FALSE;
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->ref_count = 1;
#line 1686 "TimedQueue.c"
}


static void timed_queue_finalize (TimedQueue* obj) {
	TimedQueue * self;
	guint _tmp0_ = 0U;
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TIMED_QUEUE, TimedQueue);
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_signal_handlers_destroy (self);
#line 70 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = self->priv->timer_id;
#line 70 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 1701 "TimedQueue.c"
		guint _tmp1_ = 0U;
#line 71 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp1_ = self->priv->timer_id;
#line 71 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		g_source_remove (_tmp1_);
#line 1707 "TimedQueue.c"
	}
#line 38 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	(self->priv->equal_func_target_destroy_notify == NULL) ? NULL : (self->priv->equal_func_target_destroy_notify (self->priv->equal_func_target), NULL);
#line 38 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->equal_func = NULL;
#line 38 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->equal_func_target = NULL;
#line 38 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->equal_func_target_destroy_notify = NULL;
#line 41 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_g_object_unref0 (self->priv->queue);
#line 1719 "TimedQueue.c"
}


GType timed_queue_get_type (void) {
	static volatile gsize timed_queue_type_id__volatile = 0;
	if (g_once_init_enter (&timed_queue_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_timed_queue_init, value_timed_queue_free_value, value_timed_queue_copy_value, value_timed_queue_peek_pointer, "p", value_timed_queue_collect_value, "p", value_timed_queue_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TimedQueueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) timed_queue_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TimedQueue), 0, (GInstanceInitFunc) timed_queue_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType timed_queue_type_id;
		timed_queue_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TimedQueue", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&timed_queue_type_id__volatile, timed_queue_type_id);
	}
	return timed_queue_type_id__volatile;
}


gpointer timed_queue_ref (gpointer instance) {
	TimedQueue* self;
	self = instance;
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_atomic_int_inc (&self->ref_count);
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return instance;
#line 1744 "TimedQueue.c"
}


void timed_queue_unref (gpointer instance) {
	TimedQueue* self;
	self = instance;
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		TIMED_QUEUE_GET_CLASS (self)->finalize (self);
#line 21 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1757 "TimedQueue.c"
	}
}


HashTimedQueue* hash_timed_queue_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, guint hold_msec, DequeuedCallback callback, void* callback_target, GeeHashDataFunc hash_func, void* hash_func_target, GDestroyNotify hash_func_target_destroy_notify, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify, gint priority) {
	HashTimedQueue* self = NULL;
	guint _tmp0_ = 0U;
	DequeuedCallback _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	GeeEqualDataFunc _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	GDestroyNotify _tmp2__target_destroy_notify = NULL;
	gint _tmp3_ = 0;
	GeeHashDataFunc _tmp4_ = NULL;
	void* _tmp4__target = NULL;
	GDestroyNotify _tmp4__target_destroy_notify = NULL;
	GeeEqualDataFunc _tmp5_ = NULL;
	void* _tmp5__target = NULL;
	GDestroyNotify _tmp5__target_destroy_notify = NULL;
	GeeHashMap* _tmp6_ = NULL;
#line 220 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = hold_msec;
#line 220 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp1_ = callback;
#line 220 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp1__target = callback_target;
#line 220 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp2_ = equal_func;
#line 220 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp2__target = equal_func_target;
#line 220 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp2__target_destroy_notify = equal_func_target_destroy_notify;
#line 220 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	equal_func_target_destroy_notify = NULL;
#line 220 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp3_ = priority;
#line 220 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self = (HashTimedQueue*) timed_queue_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, _tmp0_, _tmp1_, _tmp1__target, _tmp2_, _tmp2__target, _tmp2__target_destroy_notify, _tmp3_);
#line 220 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->g_type = g_type;
#line 220 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->g_dup_func = g_dup_func;
#line 220 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 222 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp4_ = hash_func;
#line 222 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp4__target = hash_func_target;
#line 222 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp4__target_destroy_notify = hash_func_target_destroy_notify;
#line 222 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	hash_func_target_destroy_notify = NULL;
#line 222 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp5_ = equal_func;
#line 222 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp5__target = equal_func_target;
#line 222 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp5__target_destroy_notify = equal_func_target_destroy_notify;
#line 222 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	equal_func_target_destroy_notify = NULL;
#line 222 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp6_ = gee_hash_map_new (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, G_TYPE_INT, NULL, NULL, _tmp4_, _tmp4__target, _tmp4__target_destroy_notify, _tmp5_, _tmp5__target, _tmp5__target_destroy_notify, NULL, NULL, NULL);
#line 222 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_g_object_unref0 (self->priv->item_count);
#line 222 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv->item_count = _tmp6_;
#line 217 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	(hash_func_target_destroy_notify == NULL) ? NULL : (hash_func_target_destroy_notify (hash_func_target), NULL);
#line 217 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	hash_func = NULL;
#line 217 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	hash_func_target = NULL;
#line 217 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	hash_func_target_destroy_notify = NULL;
#line 217 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
#line 217 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	equal_func = NULL;
#line 217 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	equal_func_target = NULL;
#line 217 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	equal_func_target_destroy_notify = NULL;
#line 217 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return self;
#line 1842 "TimedQueue.c"
}


HashTimedQueue* hash_timed_queue_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, guint hold_msec, DequeuedCallback callback, void* callback_target, GeeHashDataFunc hash_func, void* hash_func_target, GDestroyNotify hash_func_target_destroy_notify, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify, gint priority) {
#line 217 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return hash_timed_queue_construct (TYPE_HASH_TIMED_QUEUE, g_type, g_dup_func, g_destroy_func, hold_msec, callback, callback_target, hash_func, hash_func_target, hash_func_target_destroy_notify, equal_func, equal_func_target, equal_func_target_destroy_notify, priority);
#line 1849 "TimedQueue.c"
}


static void hash_timed_queue_real_notify_dequeued (TimedQueue* base, gconstpointer item) {
	HashTimedQueue * self;
	gconstpointer _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
#line 225 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HASH_TIMED_QUEUE, HashTimedQueue);
#line 226 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = item;
#line 226 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	hash_timed_queue_removed (self, _tmp0_);
#line 228 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp1_ = item;
#line 228 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	TIMED_QUEUE_CLASS (hash_timed_queue_parent_class)->notify_dequeued (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_TIMED_QUEUE, TimedQueue), _tmp1_);
#line 1867 "TimedQueue.c"
}


static void hash_timed_queue_real_clear (TimedQueue* base) {
	HashTimedQueue * self;
	GeeHashMap* _tmp0_ = NULL;
#line 231 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HASH_TIMED_QUEUE, HashTimedQueue);
#line 232 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = self->priv->item_count;
#line 232 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	gee_abstract_map_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 234 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	TIMED_QUEUE_CLASS (hash_timed_queue_parent_class)->clear (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_TIMED_QUEUE, TimedQueue));
#line 1882 "TimedQueue.c"
}


static gboolean hash_timed_queue_real_contains (TimedQueue* base, gconstpointer item) {
	HashTimedQueue * self;
	gboolean result = FALSE;
	GeeHashMap* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 237 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HASH_TIMED_QUEUE, HashTimedQueue);
#line 238 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = self->priv->item_count;
#line 238 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp1_ = item;
#line 238 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp2_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 238 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	result = _tmp2_;
#line 238 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return result;
#line 1904 "TimedQueue.c"
}


static gboolean hash_timed_queue_real_enqueue (TimedQueue* base, gconstpointer item) {
	HashTimedQueue * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	GeeHashMap* _tmp3_ = NULL;
	gconstpointer _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GeeHashMap* _tmp9_ = NULL;
	gconstpointer _tmp10_ = NULL;
#line 241 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HASH_TIMED_QUEUE, HashTimedQueue);
#line 242 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = item;
#line 242 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp1_ = TIMED_QUEUE_CLASS (hash_timed_queue_parent_class)->enqueue (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_TIMED_QUEUE, TimedQueue), _tmp0_);
#line 242 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (!_tmp1_) {
#line 243 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		result = FALSE;
#line 243 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		return result;
#line 1931 "TimedQueue.c"
	}
#line 245 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp3_ = self->priv->item_count;
#line 245 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp4_ = item;
#line 245 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp5_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_);
#line 245 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (_tmp5_) {
#line 1941 "TimedQueue.c"
		GeeHashMap* _tmp6_ = NULL;
		gconstpointer _tmp7_ = NULL;
		gpointer _tmp8_ = NULL;
#line 245 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp6_ = self->priv->item_count;
#line 245 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp7_ = item;
#line 245 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp8_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp7_);
#line 245 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp2_ = ((gint) ((gintptr) _tmp8_)) + 1;
#line 1953 "TimedQueue.c"
	} else {
#line 245 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp2_ = 1;
#line 1957 "TimedQueue.c"
	}
#line 245 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp9_ = self->priv->item_count;
#line 245 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp10_ = item;
#line 245 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp10_, (gpointer) ((gintptr) _tmp2_));
#line 247 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	result = TRUE;
#line 247 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return result;
#line 1969 "TimedQueue.c"
}


static gboolean hash_timed_queue_real_enqueue_many (TimedQueue* base, GeeCollection* items) {
	HashTimedQueue * self;
	gboolean result = FALSE;
	GeeCollection* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 250 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HASH_TIMED_QUEUE, HashTimedQueue);
#line 250 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (items), FALSE);
#line 251 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = items;
#line 251 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp1_ = TIMED_QUEUE_CLASS (hash_timed_queue_parent_class)->enqueue_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_TIMED_QUEUE, TimedQueue), _tmp0_);
#line 251 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (!_tmp1_) {
#line 252 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		result = FALSE;
#line 252 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		return result;
#line 1992 "TimedQueue.c"
	}
	{
		GeeIterator* _item_it = NULL;
		GeeCollection* _tmp2_ = NULL;
		GeeIterator* _tmp3_ = NULL;
#line 254 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp2_ = items;
#line 254 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 254 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_item_it = _tmp3_;
#line 254 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		while (TRUE) {
#line 2006 "TimedQueue.c"
			GeeIterator* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			gpointer item = NULL;
			GeeIterator* _tmp6_ = NULL;
			gpointer _tmp7_ = NULL;
			gint _tmp8_ = 0;
			GeeHashMap* _tmp9_ = NULL;
			gconstpointer _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			GeeHashMap* _tmp15_ = NULL;
			gconstpointer _tmp16_ = NULL;
#line 254 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp4_ = _item_it;
#line 254 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp5_ = gee_iterator_next (_tmp4_);
#line 254 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			if (!_tmp5_) {
#line 254 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				break;
#line 2026 "TimedQueue.c"
			}
#line 254 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp6_ = _item_it;
#line 254 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 254 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			item = _tmp7_;
#line 255 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp9_ = self->priv->item_count;
#line 255 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp10_ = item;
#line 255 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp11_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp10_);
#line 255 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			if (_tmp11_) {
#line 2042 "TimedQueue.c"
				GeeHashMap* _tmp12_ = NULL;
				gconstpointer _tmp13_ = NULL;
				gpointer _tmp14_ = NULL;
#line 255 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				_tmp12_ = self->priv->item_count;
#line 255 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				_tmp13_ = item;
#line 255 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				_tmp14_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp13_);
#line 255 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				_tmp8_ = ((gint) ((gintptr) _tmp14_)) + 1;
#line 2054 "TimedQueue.c"
			} else {
#line 255 "/home/jens/Source/shotwell/src/TimedQueue.vala"
				_tmp8_ = 1;
#line 2058 "TimedQueue.c"
			}
#line 255 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp15_ = self->priv->item_count;
#line 255 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			_tmp16_ = item;
#line 255 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp16_, (gpointer) ((gintptr) _tmp8_));
#line 254 "/home/jens/Source/shotwell/src/TimedQueue.vala"
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
#line 2068 "TimedQueue.c"
		}
#line 254 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_g_object_unref0 (_item_it);
#line 2072 "TimedQueue.c"
	}
#line 257 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	result = TRUE;
#line 257 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return result;
#line 2078 "TimedQueue.c"
}


static gboolean hash_timed_queue_real_remove_first (TimedQueue* base, gconstpointer item) {
	HashTimedQueue * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gconstpointer _tmp2_ = NULL;
#line 260 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HASH_TIMED_QUEUE, HashTimedQueue);
#line 261 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = item;
#line 261 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp1_ = TIMED_QUEUE_CLASS (hash_timed_queue_parent_class)->remove_first (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_TIMED_QUEUE, TimedQueue), _tmp0_);
#line 261 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (!_tmp1_) {
#line 262 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		result = FALSE;
#line 262 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		return result;
#line 2100 "TimedQueue.c"
	}
#line 264 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp2_ = item;
#line 264 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	hash_timed_queue_removed (self, _tmp2_);
#line 266 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	result = TRUE;
#line 266 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	return result;
#line 2110 "TimedQueue.c"
}


static void hash_timed_queue_removed (HashTimedQueue* self, gconstpointer item) {
	GeeHashMap* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gint count = 0;
	GeeHashMap* _tmp3_ = NULL;
	gconstpointer _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 269 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_return_if_fail (IS_HASH_TIMED_QUEUE (self));
#line 272 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp0_ = self->priv->item_count;
#line 272 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp1_ = item;
#line 272 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp2_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 272 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (!_tmp2_) {
#line 273 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		return;
#line 2137 "TimedQueue.c"
	}
#line 275 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp3_ = self->priv->item_count;
#line 275 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp4_ = item;
#line 275 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp5_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_);
#line 275 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	count = (gint) ((gintptr) _tmp5_);
#line 276 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp6_ = count;
#line 276 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_vala_assert (_tmp6_ > 0, "count > 0");
#line 278 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp7_ = count;
#line 278 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	count = _tmp7_ - 1;
#line 278 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_tmp8_ = count;
#line 278 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	if (_tmp8_ == 0) {
#line 2159 "TimedQueue.c"
		GeeHashMap* _tmp9_ = NULL;
		gconstpointer _tmp10_ = NULL;
#line 279 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp9_ = self->priv->item_count;
#line 279 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp10_ = item;
#line 279 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp10_, NULL);
#line 2168 "TimedQueue.c"
	} else {
		GeeHashMap* _tmp11_ = NULL;
		gconstpointer _tmp12_ = NULL;
		gint _tmp13_ = 0;
#line 281 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp11_ = self->priv->item_count;
#line 281 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp12_ = item;
#line 281 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		_tmp13_ = count;
#line 281 "/home/jens/Source/shotwell/src/TimedQueue.vala"
		gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp12_, (gpointer) ((gintptr) _tmp13_));
#line 2181 "TimedQueue.c"
	}
}


static void hash_timed_queue_class_init (HashTimedQueueClass * klass) {
#line 214 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	hash_timed_queue_parent_class = g_type_class_peek_parent (klass);
#line 214 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	((TimedQueueClass *) klass)->finalize = hash_timed_queue_finalize;
#line 214 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	g_type_class_add_private (klass, sizeof (HashTimedQueuePrivate));
#line 214 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	((TimedQueueClass *) klass)->notify_dequeued = hash_timed_queue_real_notify_dequeued;
#line 214 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	((TimedQueueClass *) klass)->clear = hash_timed_queue_real_clear;
#line 214 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	((TimedQueueClass *) klass)->contains = hash_timed_queue_real_contains;
#line 214 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	((TimedQueueClass *) klass)->enqueue = hash_timed_queue_real_enqueue;
#line 214 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	((TimedQueueClass *) klass)->enqueue_many = hash_timed_queue_real_enqueue_many;
#line 214 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	((TimedQueueClass *) klass)->remove_first = hash_timed_queue_real_remove_first;
#line 2205 "TimedQueue.c"
}


static void hash_timed_queue_instance_init (HashTimedQueue * self) {
#line 214 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self->priv = HASH_TIMED_QUEUE_GET_PRIVATE (self);
#line 2212 "TimedQueue.c"
}


static void hash_timed_queue_finalize (TimedQueue* obj) {
	HashTimedQueue * self;
#line 214 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HASH_TIMED_QUEUE, HashTimedQueue);
#line 215 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	_g_object_unref0 (self->priv->item_count);
#line 214 "/home/jens/Source/shotwell/src/TimedQueue.vala"
	TIMED_QUEUE_CLASS (hash_timed_queue_parent_class)->finalize (obj);
#line 2224 "TimedQueue.c"
}


GType hash_timed_queue_get_type (void) {
	static volatile gsize hash_timed_queue_type_id__volatile = 0;
	if (g_once_init_enter (&hash_timed_queue_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (HashTimedQueueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) hash_timed_queue_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HashTimedQueue), 0, (GInstanceInitFunc) hash_timed_queue_instance_init, NULL };
		GType hash_timed_queue_type_id;
		hash_timed_queue_type_id = g_type_register_static (TYPE_TIMED_QUEUE, "HashTimedQueue", &g_define_type_info, 0);
		g_once_init_leave (&hash_timed_queue_type_id__volatile, hash_timed_queue_type_id);
	}
	return hash_timed_queue_type_id__volatile;
}



