/* DataSet.c generated by valac 0.32.1, the Vala compiler
 * generated from DataSet.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/**/
/* DataSet*/
/**/
/* A DataSet is a collection class used for internal implementations of DataCollection*/
/* and its children.  It may be of use to other classes, however.*/
/**/
/* The general purpose of DataSet is to provide low-cost implementations of various collection*/
/* operations at a cost of internally maintaining its objects in more than one simple collection.*/
/* contains(), for example, can return a result with hash-table performance while notions of*/
/* ordering are maintained by a SortedList.  The cost is in adding and removing objects (in general,*/
/* there are others).*/
/**/
/* Because this class has no signalling mechanisms and does not manipulate DataObjects in ways*/
/* they expect to be manipulated (these features are performed by DataCollection), it's probably*/
/* best not to use this class.  Even in cases of building a list of DataObjects for some quick*/
/* operation is probably best done by a Gee.ArrayList.*/
/**/
/* ComparatorPredicate is used to determine if a re-sort operation is necessary; it has no*/
/* effect on adding a DataObject to a DataSet in sorted order.*/

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_SET (data_set_get_type ())
#define DATA_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SET, DataSet))
#define DATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SET, DataSetClass))
#define IS_DATA_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SET))
#define IS_DATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SET))
#define DATA_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SET, DataSetClass))

typedef struct _DataSet DataSet;
typedef struct _DataSetClass DataSetClass;
typedef struct _DataSetPrivate DataSetPrivate;

#define TYPE_SORTED_LIST (sorted_list_get_type ())
#define SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTED_LIST, SortedList))
#define SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTED_LIST, SortedListClass))
#define IS_SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTED_LIST))
#define IS_SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTED_LIST))
#define SORTED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTED_LIST, SortedListClass))

typedef struct _SortedList SortedList;
typedef struct _SortedListClass SortedListClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _data_set_unref0(var) ((var == NULL) ? NULL : (var = (data_set_unref (var), NULL)))
typedef struct _ParamSpecDataSet ParamSpecDataSet;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, void* user_data);
struct _DataSet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataSetPrivate * priv;
};

struct _DataSetClass {
	GTypeClass parent_class;
	void (*finalize) (DataSet *self);
};

typedef gint64 (*Comparator) (void* a, void* b, void* user_data);
struct _DataSetPrivate {
	SortedList* list;
	GeeHashSet* hash_set;
	Comparator user_comparator;
	gpointer user_comparator_target;
	ComparatorPredicate comparator_predicate;
	gpointer comparator_predicate_target;
};

struct _ParamSpecDataSet {
	GParamSpec parent_instance;
};


static gpointer data_set_parent_class = NULL;

GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_set_ref (gpointer instance);
void data_set_unref (gpointer instance);
GParamSpec* param_spec_data_set (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_set (GValue* value, gpointer v_object);
void value_take_data_set (GValue* value, gpointer v_object);
gpointer value_get_data_set (const GValue* value);
GType data_set_get_type (void) G_GNUC_CONST;
GType sorted_list_get_type (void) G_GNUC_CONST;
#define DATA_SET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DATA_SET, DataSetPrivate))
enum  {
	DATA_SET_DUMMY_PROPERTY
};
SortedList* sorted_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, Comparator cmp, void* cmp_target);
SortedList* sorted_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, Comparator cmp, void* cmp_target);
DataSet* data_set_new (void);
DataSet* data_set_construct (GType object_type);
void data_set_reset_comparator (DataSet* self);
static gint64 data_set_order_added_comparator (DataSet* self, void* a, void* b);
gint64 data_object_internal_get_ordinal (DataObject* self);
static gboolean data_set_order_added_predicate (DataSet* self, DataObject* object, Alteration* alteration);
static gint64 data_set_comparator_wrapper (DataSet* self, void* a, void* b);
gboolean data_set_contains (DataSet* self, DataObject* object);
gint data_set_get_count (DataSet* self);
gint sorted_list_get_count (SortedList* self);
static gboolean _data_set_order_added_predicate_comparator_predicate (DataObject* object, Alteration* alteration, gpointer self);
void sorted_list_resort (SortedList* self, Comparator new_cmp, void* new_cmp_target);
static gint64 _data_set_order_added_comparator_comparator (void* a, void* b, gpointer self);
Comparator data_set_get_comparator (DataSet* self, void** result_target);
ComparatorPredicate data_set_get_comparator_predicate (DataSet* self, void** result_target);
void data_set_set_comparator (DataSet* self, Comparator user_comparator, void* user_comparator_target, ComparatorPredicate comparator_predicate, void* comparator_predicate_target);
static gint64 _data_set_comparator_wrapper_comparator (void* a, void* b, gpointer self);
GeeList* data_set_get_all (DataSet* self);
GeeList* sorted_list_get_read_only_view_as_list (SortedList* self);
DataSet* data_set_copy (DataSet* self);
SortedList* sorted_list_copy (SortedList* self);
DataObject* data_set_get_at (DataSet* self, gint index);
gpointer sorted_list_get_at (SortedList* self, gint index);
gint data_set_index_of (DataSet* self, DataObject* object);
gint sorted_list_locate (SortedList* self, gconstpointer search, gboolean altered, GEqualFunc equal_func);
gboolean data_set_add (DataSet* self, DataObject* object);
gboolean data_set_add_many (DataSet* self, GeeCollection* objects);
gboolean data_set_remove (DataSet* self, DataObject* object);
gboolean data_set_remove_many (DataSet* self, GeeCollection* objects);
gboolean data_set_resort_object (DataSet* self, DataObject* object, Alteration* alteration);
gboolean sorted_list_resort_item (SortedList* self, gconstpointer item);
static void data_set_finalize (DataSet* obj);


DataSet* data_set_construct (GType object_type) {
	DataSet* self = NULL;
#line 35 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	self = (DataSet*) g_type_create_instance (object_type);
#line 36 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	data_set_reset_comparator (self);
#line 35 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return self;
#line 177 "DataSet.c"
}


DataSet* data_set_new (void) {
#line 35 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return data_set_construct (TYPE_DATA_SET);
#line 184 "DataSet.c"
}


static gint64 data_set_order_added_comparator (DataSet* self, void* a, void* b) {
	gint64 result = 0LL;
	void* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	void* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
#line 39 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (IS_DATA_SET (self), 0LL);
#line 40 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp0_ = a;
#line 40 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp1_ = data_object_internal_get_ordinal (G_TYPE_CHECK_INSTANCE_CAST ((DataObject*) _tmp0_, TYPE_DATA_OBJECT, DataObject));
#line 40 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp2_ = b;
#line 40 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp3_ = data_object_internal_get_ordinal (G_TYPE_CHECK_INSTANCE_CAST ((DataObject*) _tmp2_, TYPE_DATA_OBJECT, DataObject));
#line 40 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	result = _tmp1_ - _tmp3_;
#line 40 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return result;
#line 208 "DataSet.c"
}


static gboolean data_set_order_added_predicate (DataSet* self, DataObject* object, Alteration* alteration) {
	gboolean result = FALSE;
#line 43 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (IS_DATA_SET (self), FALSE);
#line 43 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 43 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
#line 45 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	result = FALSE;
#line 45 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return result;
#line 224 "DataSet.c"
}


static gint64 data_set_comparator_wrapper (DataSet* self, void* a, void* b) {
	gint64 result = 0LL;
	void* _tmp0_ = NULL;
	void* _tmp1_ = NULL;
	gint64 _result_ = 0LL;
	Comparator _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	gint64 _tmp7_ = 0LL;
	gint64 _tmp11_ = 0LL;
#line 48 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (IS_DATA_SET (self), 0LL);
#line 49 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp0_ = a;
#line 49 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp1_ = b;
#line 49 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (_tmp0_ == _tmp1_) {
#line 50 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		result = (gint64) 0;
#line 50 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		return result;
#line 249 "DataSet.c"
	}
#line 54 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_result_ = (gint64) 0;
#line 56 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp2_ = self->priv->user_comparator;
#line 56 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp2__target = self->priv->user_comparator_target;
#line 56 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (_tmp2_ != NULL) {
#line 259 "DataSet.c"
		Comparator _tmp3_ = NULL;
		void* _tmp3__target = NULL;
		void* _tmp4_ = NULL;
		void* _tmp5_ = NULL;
		gint64 _tmp6_ = 0LL;
#line 57 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_tmp3_ = self->priv->user_comparator;
#line 57 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_tmp3__target = self->priv->user_comparator_target;
#line 57 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_tmp4_ = a;
#line 57 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_tmp5_ = b;
#line 57 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_tmp6_ = _tmp3_ (_tmp4_, _tmp5_, _tmp3__target);
#line 57 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_result_ = _tmp6_;
#line 277 "DataSet.c"
	}
#line 59 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp7_ = _result_;
#line 59 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (_tmp7_ == ((gint64) 0)) {
#line 283 "DataSet.c"
		void* _tmp8_ = NULL;
		void* _tmp9_ = NULL;
		gint64 _tmp10_ = 0LL;
#line 60 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_tmp8_ = a;
#line 60 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_tmp9_ = b;
#line 60 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_tmp10_ = data_set_order_added_comparator (self, _tmp8_, _tmp9_);
#line 60 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_result_ = _tmp10_;
#line 295 "DataSet.c"
	}
#line 62 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp11_ = _result_;
#line 62 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_vala_assert (_tmp11_ != ((gint64) 0), "result != 0");
#line 64 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	result = _result_;
#line 64 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return result;
#line 305 "DataSet.c"
}


gboolean data_set_contains (DataSet* self, DataObject* object) {
	gboolean result = FALSE;
	GeeHashSet* _tmp0_ = NULL;
	DataObject* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 67 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (IS_DATA_SET (self), FALSE);
#line 67 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 68 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp0_ = self->priv->hash_set;
#line 68 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp1_ = object;
#line 68 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp2_ = gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp1_);
#line 68 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	result = _tmp2_;
#line 68 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return result;
#line 328 "DataSet.c"
}


inline gint data_set_get_count (DataSet* self) {
	gint result = 0;
	SortedList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 71 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (IS_DATA_SET (self), 0);
#line 72 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp0_ = self->priv->list;
#line 72 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp1_ = sorted_list_get_count (_tmp0_);
#line 72 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	result = _tmp1_;
#line 72 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return result;
#line 346 "DataSet.c"
}


static gboolean _data_set_order_added_predicate_comparator_predicate (DataObject* object, Alteration* alteration, gpointer self) {
	gboolean result;
	result = data_set_order_added_predicate ((DataSet*) self, object, alteration);
#line 77 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return result;
#line 355 "DataSet.c"
}


static gint64 _data_set_order_added_comparator_comparator (void* a, void* b, gpointer self) {
	gint64 result;
	result = data_set_order_added_comparator ((DataSet*) self, a, b);
#line 78 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return result;
#line 364 "DataSet.c"
}


void data_set_reset_comparator (DataSet* self) {
	SortedList* _tmp0_ = NULL;
#line 75 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_if_fail (IS_DATA_SET (self));
#line 76 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	self->priv->user_comparator = NULL;
#line 76 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	self->priv->user_comparator_target = NULL;
#line 77 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	self->priv->comparator_predicate = _data_set_order_added_predicate_comparator_predicate;
#line 77 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	self->priv->comparator_predicate_target = self;
#line 78 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp0_ = self->priv->list;
#line 78 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	sorted_list_resort (_tmp0_, _data_set_order_added_comparator_comparator, self);
#line 384 "DataSet.c"
}


Comparator data_set_get_comparator (DataSet* self, void** result_target) {
	Comparator result = NULL;
	Comparator _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	Comparator _tmp1_ = NULL;
	void* _tmp1__target = NULL;
#line 81 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (IS_DATA_SET (self), NULL);
#line 82 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp0_ = self->priv->user_comparator;
#line 82 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp0__target = self->priv->user_comparator_target;
#line 82 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp1_ = _tmp0_;
#line 82 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp1__target = _tmp0__target;
#line 82 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	*result_target = _tmp1__target;
#line 82 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	result = _tmp1_;
#line 82 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return result;
#line 410 "DataSet.c"
}


ComparatorPredicate data_set_get_comparator_predicate (DataSet* self, void** result_target) {
	ComparatorPredicate result = NULL;
	ComparatorPredicate _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	ComparatorPredicate _tmp1_ = NULL;
	void* _tmp1__target = NULL;
#line 85 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (IS_DATA_SET (self), NULL);
#line 86 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp0_ = self->priv->comparator_predicate;
#line 86 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp0__target = self->priv->comparator_predicate_target;
#line 86 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp1_ = _tmp0_;
#line 86 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp1__target = _tmp0__target;
#line 86 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	*result_target = _tmp1__target;
#line 86 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	result = _tmp1_;
#line 86 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return result;
#line 436 "DataSet.c"
}


static gint64 _data_set_comparator_wrapper_comparator (void* a, void* b, gpointer self) {
	gint64 result;
	result = data_set_comparator_wrapper ((DataSet*) self, a, b);
#line 92 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return result;
#line 445 "DataSet.c"
}


void data_set_set_comparator (DataSet* self, Comparator user_comparator, void* user_comparator_target, ComparatorPredicate comparator_predicate, void* comparator_predicate_target) {
	Comparator _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	ComparatorPredicate _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	SortedList* _tmp2_ = NULL;
#line 89 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_if_fail (IS_DATA_SET (self));
#line 90 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp0_ = user_comparator;
#line 90 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp0__target = user_comparator_target;
#line 90 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	self->priv->user_comparator = _tmp0_;
#line 90 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	self->priv->user_comparator_target = _tmp0__target;
#line 91 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp1_ = comparator_predicate;
#line 91 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp1__target = comparator_predicate_target;
#line 91 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	self->priv->comparator_predicate = _tmp1_;
#line 91 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	self->priv->comparator_predicate_target = _tmp1__target;
#line 92 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp2_ = self->priv->list;
#line 92 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	sorted_list_resort (_tmp2_, _data_set_comparator_wrapper_comparator, self);
#line 477 "DataSet.c"
}


GeeList* data_set_get_all (DataSet* self) {
	GeeList* result = NULL;
	SortedList* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
#line 95 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (IS_DATA_SET (self), NULL);
#line 96 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp0_ = self->priv->list;
#line 96 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp1_ = sorted_list_get_read_only_view_as_list (_tmp0_);
#line 96 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp2_ = _tmp1_;
#line 96 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	result = _tmp2_;
#line 96 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return result;
#line 498 "DataSet.c"
}


DataSet* data_set_copy (DataSet* self) {
	DataSet* result = NULL;
	DataSet* clone = NULL;
	DataSet* _tmp0_ = NULL;
	SortedList* _tmp1_ = NULL;
	SortedList* _tmp2_ = NULL;
	GeeHashSet* _tmp3_ = NULL;
	GeeHashSet* _tmp4_ = NULL;
#line 99 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (IS_DATA_SET (self), NULL);
#line 100 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp0_ = data_set_new ();
#line 100 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	clone = _tmp0_;
#line 101 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp1_ = self->priv->list;
#line 101 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp2_ = sorted_list_copy (_tmp1_);
#line 101 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_g_object_unref0 (clone->priv->list);
#line 101 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	clone->priv->list = _tmp2_;
#line 102 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp3_ = clone->priv->hash_set;
#line 102 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp4_ = self->priv->hash_set;
#line 102 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
#line 104 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	result = clone;
#line 104 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return result;
#line 534 "DataSet.c"
}


DataObject* data_set_get_at (DataSet* self, gint index) {
	DataObject* result = NULL;
	SortedList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gpointer _tmp2_ = NULL;
#line 107 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (IS_DATA_SET (self), NULL);
#line 108 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp0_ = self->priv->list;
#line 108 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp1_ = index;
#line 108 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp2_ = sorted_list_get_at (_tmp0_, _tmp1_);
#line 108 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	result = (DataObject*) _tmp2_;
#line 108 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return result;
#line 555 "DataSet.c"
}


gint data_set_index_of (DataSet* self, DataObject* object) {
	gint result = 0;
	SortedList* _tmp0_ = NULL;
	DataObject* _tmp1_ = NULL;
	GEqualFunc _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 111 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (IS_DATA_SET (self), 0);
#line 111 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), 0);
#line 112 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp0_ = self->priv->list;
#line 112 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp1_ = object;
#line 112 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp2_ = g_direct_equal;
#line 112 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp3_ = sorted_list_locate (_tmp0_, _tmp1_, FALSE, _tmp2_);
#line 112 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	result = _tmp3_;
#line 112 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return result;
#line 581 "DataSet.c"
}


gboolean data_set_add (DataSet* self, DataObject* object) {
	gboolean result = FALSE;
	SortedList* _tmp0_ = NULL;
	DataObject* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GeeHashSet* _tmp3_ = NULL;
	DataObject* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 116 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (IS_DATA_SET (self), FALSE);
#line 116 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 117 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp0_ = self->priv->list;
#line 117 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp1_ = object;
#line 117 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp2_ = gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), _tmp1_);
#line 117 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (!_tmp2_) {
#line 118 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		result = FALSE;
#line 118 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		return result;
#line 609 "DataSet.c"
	}
#line 120 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp3_ = self->priv->hash_set;
#line 120 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp4_ = object;
#line 120 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp5_ = gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp4_);
#line 120 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (!_tmp5_) {
#line 619 "DataSet.c"
		SortedList* _tmp6_ = NULL;
		DataObject* _tmp7_ = NULL;
#line 122 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_tmp6_ = self->priv->list;
#line 122 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_tmp7_ = object;
#line 122 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection), _tmp7_);
#line 124 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		result = FALSE;
#line 124 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		return result;
#line 632 "DataSet.c"
	}
#line 127 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	result = TRUE;
#line 127 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return result;
#line 638 "DataSet.c"
}


gboolean data_set_add_many (DataSet* self, GeeCollection* objects) {
	gboolean result = FALSE;
	gint count = 0;
	GeeCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	SortedList* _tmp4_ = NULL;
	GeeCollection* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GeeHashSet* _tmp7_ = NULL;
	GeeCollection* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
#line 131 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (IS_DATA_SET (self), FALSE);
#line 131 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (objects), FALSE);
#line 132 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp0_ = objects;
#line 132 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 132 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp2_ = _tmp1_;
#line 132 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	count = _tmp2_;
#line 133 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp3_ = count;
#line 133 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (_tmp3_ == 0) {
#line 134 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		result = TRUE;
#line 134 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		return result;
#line 675 "DataSet.c"
	}
#line 136 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp4_ = self->priv->list;
#line 136 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp5_ = objects;
#line 136 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp6_ = gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection), _tmp5_);
#line 136 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (!_tmp6_) {
#line 137 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		result = FALSE;
#line 137 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		return result;
#line 689 "DataSet.c"
	}
#line 139 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp7_ = self->priv->hash_set;
#line 139 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp8_ = objects;
#line 139 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp9_ = gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection), _tmp8_);
#line 139 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (!_tmp9_) {
#line 699 "DataSet.c"
		SortedList* _tmp10_ = NULL;
		GeeCollection* _tmp11_ = NULL;
#line 141 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_tmp10_ = self->priv->list;
#line 141 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_tmp11_ = objects;
#line 141 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		gee_collection_remove_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection), _tmp11_);
#line 143 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		result = FALSE;
#line 143 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		return result;
#line 712 "DataSet.c"
	}
#line 146 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	result = TRUE;
#line 146 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return result;
#line 718 "DataSet.c"
}


gboolean data_set_remove (DataSet* self, DataObject* object) {
	gboolean result = FALSE;
	gboolean success = FALSE;
	SortedList* _tmp0_ = NULL;
	DataObject* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GeeHashSet* _tmp3_ = NULL;
	DataObject* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 149 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (IS_DATA_SET (self), FALSE);
#line 149 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 150 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	success = TRUE;
#line 152 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp0_ = self->priv->list;
#line 152 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp1_ = object;
#line 152 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp2_ = gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), _tmp1_);
#line 152 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (!_tmp2_) {
#line 153 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		success = FALSE;
#line 747 "DataSet.c"
	}
#line 155 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp3_ = self->priv->hash_set;
#line 155 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp4_ = object;
#line 155 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp5_ = gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp4_);
#line 155 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (!_tmp5_) {
#line 156 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		success = FALSE;
#line 759 "DataSet.c"
	}
#line 158 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	result = success;
#line 158 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return result;
#line 765 "DataSet.c"
}


gboolean data_set_remove_many (DataSet* self, GeeCollection* objects) {
	gboolean result = FALSE;
	gboolean success = FALSE;
	SortedList* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GeeHashSet* _tmp3_ = NULL;
	GeeCollection* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 161 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (IS_DATA_SET (self), FALSE);
#line 161 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (objects), FALSE);
#line 162 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	success = TRUE;
#line 164 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp0_ = self->priv->list;
#line 164 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp1_ = objects;
#line 164 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp2_ = gee_collection_remove_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), _tmp1_);
#line 164 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (!_tmp2_) {
#line 165 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		success = FALSE;
#line 794 "DataSet.c"
	}
#line 167 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp3_ = self->priv->hash_set;
#line 167 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp4_ = objects;
#line 167 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp5_ = gee_collection_remove_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), _tmp4_);
#line 167 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (!_tmp5_) {
#line 168 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		success = FALSE;
#line 806 "DataSet.c"
	}
#line 170 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	result = success;
#line 170 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return result;
#line 812 "DataSet.c"
}


gboolean data_set_resort_object (DataSet* self, DataObject* object, Alteration* alteration) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ComparatorPredicate _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	SortedList* _tmp8_ = NULL;
	DataObject* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
#line 174 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (IS_DATA_SET (self), FALSE);
#line 174 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 174 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail ((alteration == NULL) || IS_ALTERATION (alteration), FALSE);
#line 175 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp2_ = self->priv->comparator_predicate;
#line 175 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp2__target = self->priv->comparator_predicate_target;
#line 175 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (_tmp2_ != NULL) {
#line 837 "DataSet.c"
		Alteration* _tmp3_ = NULL;
#line 175 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_tmp3_ = alteration;
#line 175 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_tmp1_ = _tmp3_ != NULL;
#line 843 "DataSet.c"
	} else {
#line 175 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_tmp1_ = FALSE;
#line 847 "DataSet.c"
	}
#line 175 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (_tmp1_) {
#line 851 "DataSet.c"
		ComparatorPredicate _tmp4_ = NULL;
		void* _tmp4__target = NULL;
		DataObject* _tmp5_ = NULL;
		Alteration* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
#line 176 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_tmp4_ = self->priv->comparator_predicate;
#line 176 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_tmp4__target = self->priv->comparator_predicate_target;
#line 176 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_tmp5_ = object;
#line 176 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_tmp6_ = alteration;
#line 176 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_tmp7_ = _tmp4_ (_tmp5_, _tmp6_, _tmp4__target);
#line 176 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_tmp0_ = !_tmp7_;
#line 869 "DataSet.c"
	} else {
#line 175 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		_tmp0_ = FALSE;
#line 873 "DataSet.c"
	}
#line 175 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (_tmp0_) {
#line 177 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		result = FALSE;
#line 177 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		return result;
#line 881 "DataSet.c"
	}
#line 180 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp8_ = self->priv->list;
#line 180 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp9_ = object;
#line 180 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp10_ = sorted_list_resort_item (_tmp8_, _tmp9_);
#line 180 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	result = _tmp10_;
#line 180 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return result;
#line 893 "DataSet.c"
}


static void value_data_set_init (GValue* value) {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	value->data[0].v_pointer = NULL;
#line 900 "DataSet.c"
}


static void value_data_set_free_value (GValue* value) {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (value->data[0].v_pointer) {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		data_set_unref (value->data[0].v_pointer);
#line 909 "DataSet.c"
	}
}


static void value_data_set_copy_value (const GValue* src_value, GValue* dest_value) {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (src_value->data[0].v_pointer) {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		dest_value->data[0].v_pointer = data_set_ref (src_value->data[0].v_pointer);
#line 919 "DataSet.c"
	} else {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		dest_value->data[0].v_pointer = NULL;
#line 923 "DataSet.c"
	}
}


static gpointer value_data_set_peek_pointer (const GValue* value) {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return value->data[0].v_pointer;
#line 931 "DataSet.c"
}


static gchar* value_data_set_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (collect_values[0].v_pointer) {
#line 938 "DataSet.c"
		DataSet* object;
		object = collect_values[0].v_pointer;
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		if (object->parent_instance.g_class == NULL) {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 945 "DataSet.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 949 "DataSet.c"
		}
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		value->data[0].v_pointer = data_set_ref (object);
#line 953 "DataSet.c"
	} else {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		value->data[0].v_pointer = NULL;
#line 957 "DataSet.c"
	}
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return NULL;
#line 961 "DataSet.c"
}


static gchar* value_data_set_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DataSet** object_p;
	object_p = collect_values[0].v_pointer;
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (!object_p) {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 972 "DataSet.c"
	}
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (!value->data[0].v_pointer) {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		*object_p = NULL;
#line 978 "DataSet.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		*object_p = value->data[0].v_pointer;
#line 982 "DataSet.c"
	} else {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		*object_p = data_set_ref (value->data[0].v_pointer);
#line 986 "DataSet.c"
	}
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return NULL;
#line 990 "DataSet.c"
}


GParamSpec* param_spec_data_set (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecDataSet* spec;
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DATA_SET), NULL);
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return G_PARAM_SPEC (spec);
#line 1004 "DataSet.c"
}


gpointer value_get_data_set (const GValue* value) {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATA_SET), NULL);
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return value->data[0].v_pointer;
#line 1013 "DataSet.c"
}


void value_set_data_set (GValue* value, gpointer v_object) {
	DataSet* old;
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATA_SET));
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	old = value->data[0].v_pointer;
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (v_object) {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DATA_SET));
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		value->data[0].v_pointer = v_object;
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		data_set_ref (value->data[0].v_pointer);
#line 1033 "DataSet.c"
	} else {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		value->data[0].v_pointer = NULL;
#line 1037 "DataSet.c"
	}
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (old) {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		data_set_unref (old);
#line 1043 "DataSet.c"
	}
}


void value_take_data_set (GValue* value, gpointer v_object) {
	DataSet* old;
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATA_SET));
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	old = value->data[0].v_pointer;
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (v_object) {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DATA_SET));
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		value->data[0].v_pointer = v_object;
#line 1062 "DataSet.c"
	} else {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		value->data[0].v_pointer = NULL;
#line 1066 "DataSet.c"
	}
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (old) {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		data_set_unref (old);
#line 1072 "DataSet.c"
	}
}


static void data_set_class_init (DataSetClass * klass) {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	data_set_parent_class = g_type_class_peek_parent (klass);
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	((DataSetClass *) klass)->finalize = data_set_finalize;
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_type_class_add_private (klass, sizeof (DataSetPrivate));
#line 1084 "DataSet.c"
}


static void data_set_instance_init (DataSet * self) {
	SortedList* _tmp0_ = NULL;
	GeeHashSet* _tmp1_ = NULL;
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	self->priv = DATA_SET_GET_PRIVATE (self);
#line 30 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp0_ = sorted_list_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
#line 30 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	self->priv->list = _tmp0_;
#line 31 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_tmp1_ = gee_hash_set_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 31 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	self->priv->hash_set = _tmp1_;
#line 32 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	self->priv->user_comparator = NULL;
#line 33 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	self->priv->comparator_predicate = NULL;
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	self->ref_count = 1;
#line 1107 "DataSet.c"
}


static void data_set_finalize (DataSet* obj) {
	DataSet * self;
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DATA_SET, DataSet);
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_signal_handlers_destroy (self);
#line 30 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_g_object_unref0 (self->priv->list);
#line 31 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	_g_object_unref0 (self->priv->hash_set);
#line 1121 "DataSet.c"
}


GType data_set_get_type (void) {
	static volatile gsize data_set_type_id__volatile = 0;
	if (g_once_init_enter (&data_set_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_data_set_init, value_data_set_free_value, value_data_set_copy_value, value_data_set_peek_pointer, "p", value_data_set_collect_value, "p", value_data_set_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DataSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) data_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DataSet), 0, (GInstanceInitFunc) data_set_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType data_set_type_id;
		data_set_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DataSet", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&data_set_type_id__volatile, data_set_type_id);
	}
	return data_set_type_id__volatile;
}


gpointer data_set_ref (gpointer instance) {
	DataSet* self;
	self = instance;
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	g_atomic_int_inc (&self->ref_count);
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	return instance;
#line 1146 "DataSet.c"
}


void data_set_unref (gpointer instance) {
	DataSet* self;
	self = instance;
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		DATA_SET_GET_CLASS (self)->finalize (self);
#line 29 "/home/jens/Source/shotwell/src/core/DataSet.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1159 "DataSet.c"
	}
}



