/* PhotoMetadata.c generated by valac 0.34.4, the Vala compiler
 * generated from PhotoMetadata.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/**/
/* PhotoMetadata*/
/**/
/* PhotoMetadata is a wrapper class around gexiv2.  The reasoning for this is (a) to facilitate*/
/* interface changes to meet Shotwell's requirements without needing modifications of the library*/
/* itself, and (b) some requirements for this class (i.e. obtaining raw metadata) is not available*/
/* in gexiv2, and so must be done by hand.*/
/**/
/* Although it's perceived that Exiv2 will remain Shotwell's metadata library of choice, this*/
/* may change in the future, and so this wrapper helps with that as well.*/
/**/
/* There is no expectation of thread-safety in this class (yet).*/
/**/
/* Tags come from Exiv2's naming scheme:*/
/* http://www.exiv2.org/metadata.html*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <gexiv2/gexiv2.h>
#include <libexif/exif-data.h>
#include <libexif/exif-mem.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_METADATA_DOMAIN (metadata_domain_get_type ())

#define TYPE_KEYWORD_TRANSFORMER (keyword_transformer_get_type ())
#define KEYWORD_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEYWORD_TRANSFORMER, KeywordTransformer))
#define KEYWORD_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEYWORD_TRANSFORMER, KeywordTransformerClass))
#define IS_KEYWORD_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEYWORD_TRANSFORMER))
#define IS_KEYWORD_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEYWORD_TRANSFORMER))
#define KEYWORD_TRANSFORMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEYWORD_TRANSFORMER, KeywordTransformerClass))

typedef struct _KeywordTransformer KeywordTransformer;
typedef struct _KeywordTransformerClass KeywordTransformerClass;
typedef struct _KeywordTransformerPrivate KeywordTransformerPrivate;
typedef struct _ParamSpecKeywordTransformer ParamSpecKeywordTransformer;

#define TYPE_NULL_KEYWORD_TRANSFORMER (null_keyword_transformer_get_type ())
#define NULL_KEYWORD_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NULL_KEYWORD_TRANSFORMER, NullKeywordTransformer))
#define NULL_KEYWORD_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NULL_KEYWORD_TRANSFORMER, NullKeywordTransformerClass))
#define IS_NULL_KEYWORD_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NULL_KEYWORD_TRANSFORMER))
#define IS_NULL_KEYWORD_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NULL_KEYWORD_TRANSFORMER))
#define NULL_KEYWORD_TRANSFORMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NULL_KEYWORD_TRANSFORMER, NullKeywordTransformerClass))

typedef struct _NullKeywordTransformer NullKeywordTransformer;
typedef struct _NullKeywordTransformerClass NullKeywordTransformerClass;
typedef struct _NullKeywordTransformerPrivate NullKeywordTransformerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_ACD_SEE_KEYWORD_TRANSFORMER (acd_see_keyword_transformer_get_type ())
#define ACD_SEE_KEYWORD_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACD_SEE_KEYWORD_TRANSFORMER, ACDSeeKeywordTransformer))
#define ACD_SEE_KEYWORD_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACD_SEE_KEYWORD_TRANSFORMER, ACDSeeKeywordTransformerClass))
#define IS_ACD_SEE_KEYWORD_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACD_SEE_KEYWORD_TRANSFORMER))
#define IS_ACD_SEE_KEYWORD_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACD_SEE_KEYWORD_TRANSFORMER))
#define ACD_SEE_KEYWORD_TRANSFORMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACD_SEE_KEYWORD_TRANSFORMER, ACDSeeKeywordTransformerClass))

typedef struct _ACDSeeKeywordTransformer ACDSeeKeywordTransformer;
typedef struct _ACDSeeKeywordTransformerClass ACDSeeKeywordTransformerClass;
typedef struct _ACDSeeKeywordTransformerPrivate ACDSeeKeywordTransformerPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_markup_parse_context_unref0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TYPE_HIERARCHICAL_KEYWORD_FIELD (hierarchical_keyword_field_get_type ())
#define HIERARCHICAL_KEYWORD_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HIERARCHICAL_KEYWORD_FIELD, HierarchicalKeywordField))
#define HIERARCHICAL_KEYWORD_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HIERARCHICAL_KEYWORD_FIELD, HierarchicalKeywordFieldClass))
#define IS_HIERARCHICAL_KEYWORD_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HIERARCHICAL_KEYWORD_FIELD))
#define IS_HIERARCHICAL_KEYWORD_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HIERARCHICAL_KEYWORD_FIELD))
#define HIERARCHICAL_KEYWORD_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HIERARCHICAL_KEYWORD_FIELD, HierarchicalKeywordFieldClass))

typedef struct _HierarchicalKeywordField HierarchicalKeywordField;
typedef struct _HierarchicalKeywordFieldClass HierarchicalKeywordFieldClass;
typedef struct _HierarchicalKeywordFieldPrivate HierarchicalKeywordFieldPrivate;
#define _keyword_transformer_unref0(var) ((var == NULL) ? NULL : (var = (keyword_transformer_unref (var), NULL)))
typedef struct _ParamSpecHierarchicalKeywordField ParamSpecHierarchicalKeywordField;

#define TYPE_PHOTO_PREVIEW (photo_preview_get_type ())
#define PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_PREVIEW, PhotoPreview))
#define PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))
#define IS_PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_PREVIEW))
#define IS_PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_PREVIEW))
#define PHOTO_PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))

typedef struct _PhotoPreview PhotoPreview;
typedef struct _PhotoPreviewClass PhotoPreviewClass;
typedef struct _PhotoPreviewPrivate PhotoPreviewPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
typedef struct _ParamSpecPhotoPreview ParamSpecPhotoPreview;

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;
typedef struct _MediaMetadataPrivate MediaMetadataPrivate;

#define TYPE_METADATA_DATE_TIME (metadata_date_time_get_type ())
#define METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTime))
#define METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))
#define IS_METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_DATE_TIME))
#define IS_METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_DATE_TIME))
#define METADATA_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))

typedef struct _MetadataDateTime MetadataDateTime;
typedef struct _MetadataDateTimeClass MetadataDateTimeClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;
typedef struct _PhotoMetadataPrivate PhotoMetadataPrivate;

#define PHOTO_METADATA_TYPE_SET_OPTION (photo_metadata_set_option_get_type ())
#define _exif_data_unref0(var) ((var == NULL) ? NULL : (var = (exif_data_unref (var), NULL)))

#define TYPE_PREPARE_INPUT_TEXT_OPTIONS (prepare_input_text_options_get_type ())
typedef struct _Block1Data Block1Data;
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;

#define TYPE_METADATA_RATIONAL (metadata_rational_get_type ())
typedef struct _MetadataRational MetadataRational;
typedef struct _Block4Data Block4Data;
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _exif_mem_unref0(var) ((var == NULL) ? NULL : (var = (exif_mem_unref (var), NULL)))

#define PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW (photo_metadata_internal_photo_preview_get_type ())
#define PHOTO_METADATA_INTERNAL_PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW, PhotoMetadataInternalPhotoPreview))
#define PHOTO_METADATA_INTERNAL_PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW, PhotoMetadataInternalPhotoPreviewClass))
#define PHOTO_METADATA_IS_INTERNAL_PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW))
#define PHOTO_METADATA_IS_INTERNAL_PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW))
#define PHOTO_METADATA_INTERNAL_PHOTO_PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW, PhotoMetadataInternalPhotoPreviewClass))

typedef struct _PhotoMetadataInternalPhotoPreview PhotoMetadataInternalPhotoPreview;
typedef struct _PhotoMetadataInternalPhotoPreviewClass PhotoMetadataInternalPhotoPreviewClass;

#define TYPE_HIERARCHICAL_TAG_INDEX (hierarchical_tag_index_get_type ())
#define HIERARCHICAL_TAG_INDEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndex))
#define HIERARCHICAL_TAG_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndexClass))
#define IS_HIERARCHICAL_TAG_INDEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HIERARCHICAL_TAG_INDEX))
#define IS_HIERARCHICAL_TAG_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HIERARCHICAL_TAG_INDEX))
#define HIERARCHICAL_TAG_INDEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndexClass))

typedef struct _HierarchicalTagIndex HierarchicalTagIndex;
typedef struct _HierarchicalTagIndexClass HierarchicalTagIndexClass;
#define _hierarchical_keyword_field_unref0(var) ((var == NULL) ? NULL : (var = (hierarchical_keyword_field_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _hierarchical_tag_index_unref0(var) ((var == NULL) ? NULL : (var = (hierarchical_tag_index_unref (var), NULL)))

#define TYPE_ORIENTATION (orientation_get_type ())

#define TYPE_RATING (rating_get_type ())
typedef struct _PhotoMetadataInternalPhotoPreviewPrivate PhotoMetadataInternalPhotoPreviewPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	METADATA_DOMAIN_UNKNOWN,
	METADATA_DOMAIN_EXIF,
	METADATA_DOMAIN_XMP,
	METADATA_DOMAIN_IPTC
} MetadataDomain;

struct _KeywordTransformer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	KeywordTransformerPrivate * priv;
};

struct _KeywordTransformerClass {
	GTypeClass parent_class;
	void (*finalize) (KeywordTransformer *self);
	GeeList* (*transform) (KeywordTransformer* self, const gchar* input, GError** error);
};

struct _ParamSpecKeywordTransformer {
	GParamSpec parent_instance;
};

struct _NullKeywordTransformer {
	KeywordTransformer parent_instance;
	NullKeywordTransformerPrivate * priv;
};

struct _NullKeywordTransformerClass {
	KeywordTransformerClass parent_class;
};

struct _ACDSeeKeywordTransformer {
	KeywordTransformer parent_instance;
	ACDSeeKeywordTransformerPrivate * priv;
};

struct _ACDSeeKeywordTransformerClass {
	KeywordTransformerClass parent_class;
};

struct _ACDSeeKeywordTransformerPrivate {
	GMarkupParser parser;
	GError* error;
	GeeArrayQueue* stack;
	GeeArrayList* result;
	gboolean assigned;
};

struct _HierarchicalKeywordField {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HierarchicalKeywordFieldPrivate * priv;
	gchar* field_name;
	gchar* path_separator;
	gboolean wants_leading_separator;
	gboolean is_writeable;
	KeywordTransformer* transformer;
};

struct _HierarchicalKeywordFieldClass {
	GTypeClass parent_class;
	void (*finalize) (HierarchicalKeywordField *self);
};

struct _ParamSpecHierarchicalKeywordField {
	GParamSpec parent_instance;
};

struct _PhotoPreview {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoPreviewPrivate * priv;
};

struct _PhotoPreviewClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoPreview *self);
	guint8* (*flatten) (PhotoPreview* self, int* result_length1, GError** error);
	GdkPixbuf* (*get_pixbuf) (PhotoPreview* self, GError** error);
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _PhotoPreviewPrivate {
	gchar* name;
	Dimensions dimensions;
	guint32 size;
	gchar* mime_type;
	gchar* extension;
};

struct _ParamSpecPhotoPreview {
	GParamSpec parent_instance;
};

struct _MediaMetadata {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MediaMetadataPrivate * priv;
};

struct _MediaMetadataClass {
	GTypeClass parent_class;
	void (*finalize) (MediaMetadata *self);
	void (*read_from_file) (MediaMetadata* self, GFile* file, GError** error);
	MetadataDateTime* (*get_creation_date_time) (MediaMetadata* self);
	gchar* (*get_title) (MediaMetadata* self);
	gchar* (*get_comment) (MediaMetadata* self);
};

struct _PhotoMetadata {
	MediaMetadata parent_instance;
	PhotoMetadataPrivate * priv;
};

struct _PhotoMetadataClass {
	MediaMetadataClass parent_class;
};

struct _PhotoMetadataPrivate {
	GExiv2Metadata* exiv2;
	ExifData* exif;
	gchar* source_name;
};

typedef enum  {
	PHOTO_METADATA_SET_OPTION_ALL_DOMAINS,
	PHOTO_METADATA_SET_OPTION_ONLY_IF_DOMAIN_PRESENT,
	PHOTO_METADATA_SET_OPTION_AT_LEAST_DEFAULT_DOMAIN
} PhotoMetadataSetOption;

typedef enum  {
	PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL = 1 << 0,
	PREPARE_INPUT_TEXT_OPTIONS_VALIDATE = 1 << 1,
	PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL = 1 << 2,
	PREPARE_INPUT_TEXT_OPTIONS_STRIP = 1 << 3,
	PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF = 1 << 4,
	PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE = 1 << 5,
	PREPARE_INPUT_TEXT_OPTIONS_DEFAULT = ((((PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL | PREPARE_INPUT_TEXT_OPTIONS_VALIDATE) | PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL) | PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF) | PREPARE_INPUT_TEXT_OPTIONS_STRIP) | PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE
} PrepareInputTextOptions;

typedef void (*PhotoMetadataSetGenericValue) (const gchar* tag, void* user_data);
struct _Block1Data {
	int _ref_count_;
	PhotoMetadata* self;
	gchar* value;
};

struct _Block2Data {
	int _ref_count_;
	PhotoMetadata* self;
	GeeCollection* values;
};

struct _Block3Data {
	int _ref_count_;
	PhotoMetadata* self;
	glong value;
};

struct _MetadataRational {
	gint numerator;
	gint denominator;
};

struct _Block4Data {
	int _ref_count_;
	PhotoMetadata* self;
	MetadataRational rational;
};

typedef enum  {
	METADATA_DATE_TIME_ERROR_INVALID_FORMAT,
	METADATA_DATE_TIME_ERROR_UNSUPPORTED_FORMAT
} MetadataDateTimeError;
#define METADATA_DATE_TIME_ERROR metadata_date_time_error_quark ()
struct _Block5Data {
	int _ref_count_;
	PhotoMetadata* self;
	MetadataDateTime* date_time;
};

typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

struct _PhotoMetadataInternalPhotoPreview {
	PhotoPreview parent_instance;
	PhotoMetadataInternalPhotoPreviewPrivate * priv;
	PhotoMetadata* owner;
	guint number;
};

struct _PhotoMetadataInternalPhotoPreviewClass {
	PhotoPreviewClass parent_class;
};


static gpointer keyword_transformer_parent_class = NULL;
static gpointer null_keyword_transformer_parent_class = NULL;
static gpointer acd_see_keyword_transformer_parent_class = NULL;
static gpointer hierarchical_keyword_field_parent_class = NULL;
static gpointer photo_preview_parent_class = NULL;
static gpointer photo_metadata_parent_class = NULL;
static gchar** photo_metadata_DATE_TIME_TAGS;
static gint photo_metadata_DATE_TIME_TAGS_length1;
static gchar** photo_metadata_DATE_TIME_TAGS = NULL;
static gint photo_metadata_DATE_TIME_TAGS_length1 = 0;
static gint _photo_metadata_DATE_TIME_TAGS_size_ = 0;
static gchar** photo_metadata_EXPOSURE_DATE_TIME_TAGS;
static gint photo_metadata_EXPOSURE_DATE_TIME_TAGS_length1;
static gchar** photo_metadata_EXPOSURE_DATE_TIME_TAGS = NULL;
static gint photo_metadata_EXPOSURE_DATE_TIME_TAGS_length1 = 0;
static gint _photo_metadata_EXPOSURE_DATE_TIME_TAGS_size_ = 0;
static gchar** photo_metadata_DIGITIZED_DATE_TIME_TAGS;
static gint photo_metadata_DIGITIZED_DATE_TIME_TAGS_length1;
static gchar** photo_metadata_DIGITIZED_DATE_TIME_TAGS = NULL;
static gint photo_metadata_DIGITIZED_DATE_TIME_TAGS_length1 = 0;
static gint _photo_metadata_DIGITIZED_DATE_TIME_TAGS_size_ = 0;
static gchar** photo_metadata_WIDTH_TAGS;
static gint photo_metadata_WIDTH_TAGS_length1;
static gchar** photo_metadata_WIDTH_TAGS = NULL;
static gint photo_metadata_WIDTH_TAGS_length1 = 0;
static gint _photo_metadata_WIDTH_TAGS_size_ = 0;
extern gchar** photo_metadata_HEIGHT_TAGS;
extern gint photo_metadata_HEIGHT_TAGS_length1;
gchar** photo_metadata_HEIGHT_TAGS = NULL;
gint photo_metadata_HEIGHT_TAGS_length1 = 0;
static gchar** photo_metadata_STANDARD_TITLE_TAGS;
static gint photo_metadata_STANDARD_TITLE_TAGS_length1;
static gchar** photo_metadata_STANDARD_TITLE_TAGS = NULL;
static gint photo_metadata_STANDARD_TITLE_TAGS_length1 = 0;
static gint _photo_metadata_STANDARD_TITLE_TAGS_size_ = 0;
static gchar** photo_metadata_COMMENT_TAGS;
static gint photo_metadata_COMMENT_TAGS_length1;
static gchar** photo_metadata_COMMENT_TAGS = NULL;
static gint photo_metadata_COMMENT_TAGS_length1 = 0;
static gint _photo_metadata_COMMENT_TAGS_size_ = 0;
static gchar** photo_metadata_KEYWORD_TAGS;
static gint photo_metadata_KEYWORD_TAGS_length1;
static gchar** photo_metadata_KEYWORD_TAGS = NULL;
static gint photo_metadata_KEYWORD_TAGS_length1 = 0;
static gint _photo_metadata_KEYWORD_TAGS_size_ = 0;
static HierarchicalKeywordField** photo_metadata_HIERARCHICAL_KEYWORD_TAGS;
static gint photo_metadata_HIERARCHICAL_KEYWORD_TAGS_length1;
static HierarchicalKeywordField** photo_metadata_HIERARCHICAL_KEYWORD_TAGS = NULL;
static gint photo_metadata_HIERARCHICAL_KEYWORD_TAGS_length1 = 0;
static gint _photo_metadata_HIERARCHICAL_KEYWORD_TAGS_size_ = 0;
static gchar** photo_metadata_ARTIST_TAGS;
static gint photo_metadata_ARTIST_TAGS_length1;
static gchar** photo_metadata_ARTIST_TAGS = NULL;
static gint photo_metadata_ARTIST_TAGS_length1 = 0;
static gint _photo_metadata_ARTIST_TAGS_size_ = 0;
static gchar** photo_metadata_RATING_TAGS;
static gint photo_metadata_RATING_TAGS_length1;
static gchar** photo_metadata_RATING_TAGS = NULL;
static gint photo_metadata_RATING_TAGS_length1 = 0;
static gint _photo_metadata_RATING_TAGS_size_ = 0;
static gpointer photo_metadata_internal_photo_preview_parent_class = NULL;

GType metadata_domain_get_type (void) G_GNUC_CONST;
gpointer keyword_transformer_ref (gpointer instance);
void keyword_transformer_unref (gpointer instance);
GParamSpec* param_spec_keyword_transformer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_keyword_transformer (GValue* value, gpointer v_object);
void value_take_keyword_transformer (GValue* value, gpointer v_object);
gpointer value_get_keyword_transformer (const GValue* value);
GType keyword_transformer_get_type (void) G_GNUC_CONST;
enum  {
	KEYWORD_TRANSFORMER_DUMMY_PROPERTY
};
GeeList* keyword_transformer_transform (KeywordTransformer* self, const gchar* input, GError** error);
static GeeList* keyword_transformer_real_transform (KeywordTransformer* self, const gchar* input, GError** error);
KeywordTransformer* keyword_transformer_construct (GType object_type);
static void keyword_transformer_finalize (KeywordTransformer* obj);
GType null_keyword_transformer_get_type (void) G_GNUC_CONST;
enum  {
	NULL_KEYWORD_TRANSFORMER_DUMMY_PROPERTY
};
static GeeList* null_keyword_transformer_real_transform (KeywordTransformer* base, const gchar* input, GError** error);
NullKeywordTransformer* null_keyword_transformer_new (void);
NullKeywordTransformer* null_keyword_transformer_construct (GType object_type);
GType acd_see_keyword_transformer_get_type (void) G_GNUC_CONST;
#define ACD_SEE_KEYWORD_TRANSFORMER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ACD_SEE_KEYWORD_TRANSFORMER, ACDSeeKeywordTransformerPrivate))
enum  {
	ACD_SEE_KEYWORD_TRANSFORMER_DUMMY_PROPERTY
};
ACDSeeKeywordTransformer* acd_see_keyword_transformer_new (void);
ACDSeeKeywordTransformer* acd_see_keyword_transformer_construct (GType object_type);
static void acd_see_keyword_transformer_on_start (ACDSeeKeywordTransformer* self, GMarkupParseContext* ctx, const gchar* name, gchar** attribute_names, gchar** attribute_values, GError** error);
static void _acd_see_keyword_transformer_on_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error);
static void acd_see_keyword_transformer_on_end (ACDSeeKeywordTransformer* self, GMarkupParseContext* ctx, const gchar* name, GError** error);
static void _acd_see_keyword_transformer_on_end_gmarkup_parser_end_element_func (GMarkupParseContext* context, const gchar* element_name, gpointer self, GError** error);
static void acd_see_keyword_transformer_on_text (ACDSeeKeywordTransformer* self, GMarkupParseContext* ctx, const gchar* text, GError** error);
static void _acd_see_keyword_transformer_on_text_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error);
static void acd_see_keyword_transformer_on_error (ACDSeeKeywordTransformer* self, GMarkupParseContext* ctx, GError* _error_);
static void _acd_see_keyword_transformer_on_error_gmarkup_parser_error_func (GMarkupParseContext* context, GError* _error_, gpointer self);
static GeeList* acd_see_keyword_transformer_real_transform (KeywordTransformer* base, const gchar* input, GError** error);
static void acd_see_keyword_transformer_finalize (KeywordTransformer* obj);
gpointer hierarchical_keyword_field_ref (gpointer instance);
void hierarchical_keyword_field_unref (gpointer instance);
GParamSpec* param_spec_hierarchical_keyword_field (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_hierarchical_keyword_field (GValue* value, gpointer v_object);
void value_take_hierarchical_keyword_field (GValue* value, gpointer v_object);
gpointer value_get_hierarchical_keyword_field (const GValue* value);
GType hierarchical_keyword_field_get_type (void) G_GNUC_CONST;
enum  {
	HIERARCHICAL_KEYWORD_FIELD_DUMMY_PROPERTY
};
HierarchicalKeywordField* hierarchical_keyword_field_new (const gchar* field_name, const gchar* path_separator, gboolean wants_leading_separator, gboolean is_writeable, KeywordTransformer* transformer);
HierarchicalKeywordField* hierarchical_keyword_field_construct (GType object_type, const gchar* field_name, const gchar* path_separator, gboolean wants_leading_separator, gboolean is_writeable, KeywordTransformer* transformer);
static void hierarchical_keyword_field_finalize (HierarchicalKeywordField* obj);
gpointer photo_preview_ref (gpointer instance);
void photo_preview_unref (gpointer instance);
GParamSpec* param_spec_photo_preview (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_preview (GValue* value, gpointer v_object);
void value_take_photo_preview (GValue* value, gpointer v_object);
gpointer value_get_photo_preview (const GValue* value);
GType photo_preview_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
#define PHOTO_PREVIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PHOTO_PREVIEW, PhotoPreviewPrivate))
enum  {
	PHOTO_PREVIEW_DUMMY_PROPERTY
};
PhotoPreview* photo_preview_construct (GType object_type, const gchar* name, Dimensions* dimensions, guint32 size, const gchar* mime_type, const gchar* extension);
gchar* photo_preview_get_name (PhotoPreview* self);
void photo_preview_get_pixel_dimensions (PhotoPreview* self, Dimensions* result);
guint32 photo_preview_get_size (PhotoPreview* self);
gchar* photo_preview_get_mime_type (PhotoPreview* self);
gchar* photo_preview_get_extension (PhotoPreview* self);
guint8* photo_preview_flatten (PhotoPreview* self, int* result_length1, GError** error);
static guint8* photo_preview_real_flatten (PhotoPreview* self, int* result_length1, GError** error);
GdkPixbuf* photo_preview_get_pixbuf (PhotoPreview* self, GError** error);
static GdkPixbuf* photo_preview_real_get_pixbuf (PhotoPreview* self, GError** error);
static guint8* _vala_array_dup4 (guint8* self, int length);
static void photo_preview_finalize (PhotoPreview* obj);
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_metadata (GValue* value, gpointer v_object);
void value_take_media_metadata (GValue* value, gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
gpointer metadata_date_time_ref (gpointer instance);
void metadata_date_time_unref (gpointer instance);
GParamSpec* param_spec_metadata_date_time (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_metadata_date_time (GValue* value, gpointer v_object);
void value_take_metadata_date_time (GValue* value, gpointer v_object);
gpointer value_get_metadata_date_time (const GValue* value);
GType metadata_date_time_get_type (void) G_GNUC_CONST;
GType photo_metadata_get_type (void) G_GNUC_CONST;
#define PHOTO_METADATA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PHOTO_METADATA, PhotoMetadataPrivate))
enum  {
	PHOTO_METADATA_DUMMY_PROPERTY
};
GType photo_metadata_set_option_get_type (void) G_GNUC_CONST;
GType prepare_input_text_options_get_type (void) G_GNUC_CONST;
#define PHOTO_METADATA_PREPARE_STRING_OPTIONS (((((PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL | PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL) | PREPARE_INPUT_TEXT_OPTIONS_STRIP) | PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF) | PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE) | PREPARE_INPUT_TEXT_OPTIONS_VALIDATE)
#define PHOTO_METADATA_IPHOTO_TITLE_TAG "Iptc.Application2.ObjectName"
PhotoMetadata* photo_metadata_new (void);
PhotoMetadata* photo_metadata_construct (GType object_type);
MediaMetadata* media_metadata_construct (GType object_type);
static void photo_metadata_real_read_from_file (MediaMetadata* base, GFile* file, GError** error);
void photo_metadata_write_to_file (PhotoMetadata* self, GFile* file, GError** error);
void photo_metadata_read_from_buffer (PhotoMetadata* self, guint8* buffer, int buffer_length1, gint length, GError** error);
void photo_metadata_read_from_app1_segment (PhotoMetadata* self, guint8* buffer, int buffer_length1, gint length, GError** error);
MetadataDomain photo_metadata_get_tag_domain (const gchar* tag);
gboolean photo_metadata_has_domain (PhotoMetadata* self, MetadataDomain domain);
gboolean photo_metadata_has_exif (PhotoMetadata* self);
gboolean photo_metadata_has_xmp (PhotoMetadata* self);
gboolean photo_metadata_has_iptc (PhotoMetadata* self);
gboolean photo_metadata_can_write_to_domain (PhotoMetadata* self, MetadataDomain domain);
gboolean photo_metadata_can_write_exif (PhotoMetadata* self);
gboolean photo_metadata_can_write_xmp (PhotoMetadata* self);
gboolean photo_metadata_can_write_iptc (PhotoMetadata* self);
gboolean photo_metadata_has_tag (PhotoMetadata* self, const gchar* tag);
static GeeSet* photo_metadata_create_string_set (PhotoMetadata* self, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify);
GeeCollection* photo_metadata_get_tags (PhotoMetadata* self, MetadataDomain domain, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify);
GeeCollection* photo_metadata_get_all_tags (PhotoMetadata* self, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify);
gchar* photo_metadata_get_tag_label (PhotoMetadata* self, const gchar* tag);
gchar* photo_metadata_get_tag_description (PhotoMetadata* self, const gchar* tag);
gchar* photo_metadata_get_string (PhotoMetadata* self, const gchar* tag, PrepareInputTextOptions options);
gchar* prepare_input_text (const gchar* text, PrepareInputTextOptions options, gint dest_length);
#define DEFAULT_USER_TEXT_INPUT_LENGTH 1024
gchar* photo_metadata_get_string_interpreted (PhotoMetadata* self, const gchar* tag, PrepareInputTextOptions options);
gchar* photo_metadata_get_first_string (PhotoMetadata* self, gchar** tags, int tags_length1);
gchar* photo_metadata_get_first_string_interpreted (PhotoMetadata* self, gchar** tags, int tags_length1);
GeeList* photo_metadata_get_string_multiple (PhotoMetadata* self, const gchar* tag);
GeeList* photo_metadata_get_first_string_multiple (PhotoMetadata* self, gchar** tags, int tags_length1);
void photo_metadata_set_string (PhotoMetadata* self, const gchar* tag, const gchar* value, PrepareInputTextOptions options);
static void photo_metadata_set_all_generic (PhotoMetadata* self, gchar** tags, int tags_length1, PhotoMetadataSetOption option, PhotoMetadataSetGenericValue setter, void* setter_target);
void photo_metadata_set_all_string (PhotoMetadata* self, gchar** tags, int tags_length1, const gchar* value, PhotoMetadataSetOption option);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda5_ (Block1Data* _data1_, const gchar* tag);
static void ___lambda5__photo_metadata_set_generic_value (const gchar* tag, gpointer self);
void photo_metadata_set_string_multiple (PhotoMetadata* self, const gchar* tag, GeeCollection* collection);
static void _vala_array_add45 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add46 (gchar*** array, int* length, int* size, gchar* value);
void photo_metadata_set_all_string_multiple (PhotoMetadata* self, gchar** tags, int tags_length1, GeeCollection* values, PhotoMetadataSetOption option);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda6_ (Block2Data* _data2_, const gchar* tag);
static void ___lambda6__photo_metadata_set_generic_value (const gchar* tag, gpointer self);
gboolean photo_metadata_get_long (PhotoMetadata* self, const gchar* tag, glong* value);
gboolean photo_metadata_get_first_long (PhotoMetadata* self, gchar** tags, int tags_length1, glong* value);
void photo_metadata_set_long (PhotoMetadata* self, const gchar* tag, glong value);
void photo_metadata_set_all_long (PhotoMetadata* self, gchar** tags, int tags_length1, glong value, PhotoMetadataSetOption option);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda7_ (Block3Data* _data3_, const gchar* tag);
static void ___lambda7__photo_metadata_set_generic_value (const gchar* tag, gpointer self);
GType metadata_rational_get_type (void) G_GNUC_CONST;
MetadataRational* metadata_rational_dup (const MetadataRational* self);
void metadata_rational_free (MetadataRational* self);
gboolean photo_metadata_get_rational (PhotoMetadata* self, const gchar* tag, MetadataRational* rational);
void metadata_rational_init (MetadataRational *self, gint numerator, gint denominator);
gboolean photo_metadata_get_first_rational (PhotoMetadata* self, gchar** tags, int tags_length1, MetadataRational* rational);
void photo_metadata_set_rational (PhotoMetadata* self, const gchar* tag, MetadataRational* rational);
gchar* metadata_rational_to_string (MetadataRational *self);
void photo_metadata_set_all_rational (PhotoMetadata* self, gchar** tags, int tags_length1, MetadataRational* rational, PhotoMetadataSetOption option);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda8_ (Block4Data* _data4_, const gchar* tag);
static void ___lambda8__photo_metadata_set_generic_value (const gchar* tag, gpointer self);
MetadataDateTime* photo_metadata_get_date_time (PhotoMetadata* self, const gchar* tag);
GQuark metadata_date_time_error_quark (void);
MetadataDateTime* metadata_date_time_new_from_xmp (const gchar* label, GError** error);
MetadataDateTime* metadata_date_time_construct_from_xmp (GType object_type, const gchar* label, GError** error);
MetadataDateTime* metadata_date_time_new_from_exif (const gchar* label, GError** error);
MetadataDateTime* metadata_date_time_construct_from_exif (GType object_type, const gchar* label, GError** error);
MetadataDateTime* photo_metadata_get_first_date_time (PhotoMetadata* self, gchar** tags, int tags_length1);
void photo_metadata_set_date_time (PhotoMetadata* self, const gchar* tag, MetadataDateTime* date_time);
gchar* metadata_date_time_get_exif_label (MetadataDateTime* self);
gchar* metadata_date_time_get_xmp_label (MetadataDateTime* self);
const gchar* metadata_domain_to_string (MetadataDomain self);
void photo_metadata_set_all_date_time (PhotoMetadata* self, gchar** tags, int tags_length1, MetadataDateTime* date_time, PhotoMetadataSetOption option);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda9_ (Block5Data* _data5_, const gchar* tag);
static void ___lambda9__photo_metadata_set_generic_value (const gchar* tag, gpointer self);
guint8* photo_metadata_flatten_exif (PhotoMetadata* self, gboolean include_preview, int* result_length1);
guint8* photo_metadata_flatten_exif_preview (PhotoMetadata* self, int* result_length1);
static guint8* _vala_array_dup5 (guint8* self, int length);
guint photo_metadata_get_preview_count (PhotoMetadata* self);
PhotoPreview* photo_metadata_get_preview (PhotoMetadata* self, guint number);
static PhotoMetadataInternalPhotoPreview* photo_metadata_internal_photo_preview_new (PhotoMetadata* owner, const gchar* name, guint number, GExiv2PreviewProperties* props);
static PhotoMetadataInternalPhotoPreview* photo_metadata_internal_photo_preview_construct (GType object_type, PhotoMetadata* owner, const gchar* name, guint number, GExiv2PreviewProperties* props);
static GType photo_metadata_internal_photo_preview_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
void photo_metadata_remove_exif_thumbnail (PhotoMetadata* self);
void photo_metadata_remove_tag (PhotoMetadata* self, const gchar* tag);
void photo_metadata_remove_tags (PhotoMetadata* self, gchar** tags, int tags_length1);
void photo_metadata_clear_domain (PhotoMetadata* self, MetadataDomain domain);
void photo_metadata_clear (PhotoMetadata* self);
MetadataDateTime* photo_metadata_get_modification_date_time (PhotoMetadata* self);
void photo_metadata_set_modification_date_time (PhotoMetadata* self, MetadataDateTime* date_time, PhotoMetadataSetOption option);
MetadataDateTime* photo_metadata_get_exposure_date_time (PhotoMetadata* self);
void photo_metadata_set_exposure_date_time (PhotoMetadata* self, MetadataDateTime* date_time, PhotoMetadataSetOption option);
MetadataDateTime* photo_metadata_get_digitized_date_time (PhotoMetadata* self);
void photo_metadata_set_digitized_date_time (PhotoMetadata* self, MetadataDateTime* date_time, PhotoMetadataSetOption option);
static MetadataDateTime* photo_metadata_real_get_creation_date_time (MediaMetadata* base);
Dimensions* photo_metadata_get_pixel_dimensions (PhotoMetadata* self);
void dimensions_init (Dimensions *self, gint width, gint height);
void photo_metadata_set_pixel_dimensions (PhotoMetadata* self, Dimensions* dim, PhotoMetadataSetOption option);
static gchar* photo_metadata_real_get_title (MediaMetadata* base);
gboolean is_string_empty (const gchar* s);
void photo_metadata_set_title (PhotoMetadata* self, const gchar* title, PhotoMetadataSetOption option);
static gchar* photo_metadata_real_get_comment (MediaMetadata* base);
void photo_metadata_set_comment (PhotoMetadata* self, const gchar* comment, PhotoMetadataSetOption option);
GeeSet* photo_metadata_get_keywords (PhotoMetadata* self, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify);
gchar* hierarchical_tag_utilities_make_flat_tag_safe (const gchar* in_tag);
gpointer hierarchical_tag_index_ref (gpointer instance);
void hierarchical_tag_index_unref (gpointer instance);
GParamSpec* param_spec_hierarchical_tag_index (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_hierarchical_tag_index (GValue* value, gpointer v_object);
void value_take_hierarchical_tag_index (GValue* value, gpointer v_object);
gpointer value_get_hierarchical_tag_index (const GValue* value);
GType hierarchical_tag_index_get_type (void) G_GNUC_CONST;
static void photo_metadata_internal_set_hierarchical_keywords (PhotoMetadata* self, HierarchicalTagIndex* index);
GeeCollection* hierarchical_tag_index_get_all_paths (HierarchicalTagIndex* self);
#define TAG_PATH_SEPARATOR_STRING "/"
void photo_metadata_set_keywords (PhotoMetadata* self, GeeCollection* keywords, PhotoMetadataSetOption option);
HierarchicalTagIndex* hierarchical_tag_index_new (void);
HierarchicalTagIndex* hierarchical_tag_index_construct (GType object_type);
GeeList* hierarchical_tag_utilities_enumerate_path_components (const gchar* in_path);
void hierarchical_tag_index_add_path (HierarchicalTagIndex* self, const gchar* tag, const gchar* path);
GeeCollection* hierarchical_tag_index_get_all_tags (HierarchicalTagIndex* self);
gboolean photo_metadata_has_hierarchical_keywords (PhotoMetadata* self);
GeeSet* photo_metadata_get_hierarchical_keywords (PhotoMetadata* self);
gchar* hierarchical_tag_utilities_canonicalize (const gchar* in_tag, const gchar* foreign_separator);
gboolean photo_metadata_has_orientation (PhotoMetadata* self);
GType orientation_get_type (void) G_GNUC_CONST;
Orientation photo_metadata_get_orientation (PhotoMetadata* self);
void photo_metadata_set_orientation (PhotoMetadata* self, Orientation orientation);
gboolean photo_metadata_get_gps (PhotoMetadata* self, gdouble* longitude, gchar** long_ref, gdouble* latitude, gchar** lat_ref, gdouble* altitude);
gboolean photo_metadata_get_exposure (PhotoMetadata* self, MetadataRational* exposure);
gchar* photo_metadata_get_exposure_string (PhotoMetadata* self);
gboolean metadata_rational_is_valid (MetadataRational *self);
gboolean photo_metadata_get_iso (PhotoMetadata* self, glong* iso);
gchar* photo_metadata_get_iso_string (PhotoMetadata* self);
gboolean photo_metadata_get_aperture (PhotoMetadata* self, MetadataRational* aperture);
gchar* photo_metadata_get_aperture_string (PhotoMetadata* self, gboolean pango_formatted);
gchar* photo_metadata_get_camera_make (PhotoMetadata* self);
gchar* photo_metadata_get_camera_model (PhotoMetadata* self);
gboolean photo_metadata_get_flash (PhotoMetadata* self, glong* flash);
gchar* photo_metadata_get_flash_string (PhotoMetadata* self);
gboolean photo_metadata_get_focal_length (PhotoMetadata* self, MetadataRational* focal_length);
gchar* photo_metadata_get_focal_length_string (PhotoMetadata* self);
gchar* photo_metadata_get_artist (PhotoMetadata* self);
gchar* photo_metadata_get_copyright (PhotoMetadata* self);
gchar* photo_metadata_get_software (PhotoMetadata* self);
void photo_metadata_set_software (PhotoMetadata* self, const gchar* software, const gchar* version);
void photo_metadata_remove_software (PhotoMetadata* self);
gchar* photo_metadata_get_exposure_bias (PhotoMetadata* self);
GType rating_get_type (void) G_GNUC_CONST;
Rating photo_metadata_get_rating (PhotoMetadata* self);
Rating rating_unserialize (gint value);
void photo_metadata_set_rating (PhotoMetadata* self, Rating rating);
gint rating_serialize (Rating self);
enum  {
	PHOTO_METADATA_INTERNAL_PHOTO_PREVIEW_DUMMY_PROPERTY
};
static guint8* photo_metadata_internal_photo_preview_real_flatten (PhotoPreview* base, int* result_length1, GError** error);
static guint8* _vala_array_dup6 (guint8* self, int length);
static void photo_metadata_internal_photo_preview_finalize (PhotoPreview* obj);
static void photo_metadata_finalize (MediaMetadata* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

extern const gint RESOURCES_rating_thresholds[6];

GType metadata_domain_get_type (void) {
	static volatile gsize metadata_domain_type_id__volatile = 0;
	if (g_once_init_enter (&metadata_domain_type_id__volatile)) {
		static const GEnumValue values[] = {{METADATA_DOMAIN_UNKNOWN, "METADATA_DOMAIN_UNKNOWN", "unknown"}, {METADATA_DOMAIN_EXIF, "METADATA_DOMAIN_EXIF", "exif"}, {METADATA_DOMAIN_XMP, "METADATA_DOMAIN_XMP", "xmp"}, {METADATA_DOMAIN_IPTC, "METADATA_DOMAIN_IPTC", "iptc"}, {0, NULL, NULL}};
		GType metadata_domain_type_id;
		metadata_domain_type_id = g_enum_register_static ("MetadataDomain", values);
		g_once_init_leave (&metadata_domain_type_id__volatile, metadata_domain_type_id);
	}
	return metadata_domain_type_id__volatile;
}


static GeeList* keyword_transformer_real_transform (KeywordTransformer* self, const gchar* input, GError** error) {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_critical ("Type `%s' does not implement abstract method `keyword_transformer_transform'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 765 "PhotoMetadata.c"
}


GeeList* keyword_transformer_transform (KeywordTransformer* self, const gchar* input, GError** error) {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_KEYWORD_TRANSFORMER (self), NULL);
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return KEYWORD_TRANSFORMER_GET_CLASS (self)->transform (self, input, error);
#line 774 "PhotoMetadata.c"
}


KeywordTransformer* keyword_transformer_construct (GType object_type) {
	KeywordTransformer* self = NULL;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = (KeywordTransformer*) g_type_create_instance (object_type);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self;
#line 784 "PhotoMetadata.c"
}


static void value_keyword_transformer_init (GValue* value) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	value->data[0].v_pointer = NULL;
#line 791 "PhotoMetadata.c"
}


static void value_keyword_transformer_free_value (GValue* value) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (value->data[0].v_pointer) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		keyword_transformer_unref (value->data[0].v_pointer);
#line 800 "PhotoMetadata.c"
	}
}


static void value_keyword_transformer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (src_value->data[0].v_pointer) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		dest_value->data[0].v_pointer = keyword_transformer_ref (src_value->data[0].v_pointer);
#line 810 "PhotoMetadata.c"
	} else {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		dest_value->data[0].v_pointer = NULL;
#line 814 "PhotoMetadata.c"
	}
}


static gpointer value_keyword_transformer_peek_pointer (const GValue* value) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return value->data[0].v_pointer;
#line 822 "PhotoMetadata.c"
}


static gchar* value_keyword_transformer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (collect_values[0].v_pointer) {
#line 829 "PhotoMetadata.c"
		KeywordTransformer* object;
		object = collect_values[0].v_pointer;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (object->parent_instance.g_class == NULL) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 836 "PhotoMetadata.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 840 "PhotoMetadata.c"
		}
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = keyword_transformer_ref (object);
#line 844 "PhotoMetadata.c"
	} else {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 848 "PhotoMetadata.c"
	}
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 852 "PhotoMetadata.c"
}


static gchar* value_keyword_transformer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	KeywordTransformer** object_p;
	object_p = collect_values[0].v_pointer;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!object_p) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 863 "PhotoMetadata.c"
	}
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!value->data[0].v_pointer) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = NULL;
#line 869 "PhotoMetadata.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = value->data[0].v_pointer;
#line 873 "PhotoMetadata.c"
	} else {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = keyword_transformer_ref (value->data[0].v_pointer);
#line 877 "PhotoMetadata.c"
	}
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 881 "PhotoMetadata.c"
}


GParamSpec* param_spec_keyword_transformer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecKeywordTransformer* spec;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_KEYWORD_TRANSFORMER), NULL);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return G_PARAM_SPEC (spec);
#line 895 "PhotoMetadata.c"
}


gpointer value_get_keyword_transformer (const GValue* value) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_KEYWORD_TRANSFORMER), NULL);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return value->data[0].v_pointer;
#line 904 "PhotoMetadata.c"
}


void value_set_keyword_transformer (GValue* value, gpointer v_object) {
	KeywordTransformer* old;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_KEYWORD_TRANSFORMER));
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	old = value->data[0].v_pointer;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (v_object) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_KEYWORD_TRANSFORMER));
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		keyword_transformer_ref (value->data[0].v_pointer);
#line 924 "PhotoMetadata.c"
	} else {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 928 "PhotoMetadata.c"
	}
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (old) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		keyword_transformer_unref (old);
#line 934 "PhotoMetadata.c"
	}
}


void value_take_keyword_transformer (GValue* value, gpointer v_object) {
	KeywordTransformer* old;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_KEYWORD_TRANSFORMER));
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	old = value->data[0].v_pointer;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (v_object) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_KEYWORD_TRANSFORMER));
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 953 "PhotoMetadata.c"
	} else {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 957 "PhotoMetadata.c"
	}
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (old) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		keyword_transformer_unref (old);
#line 963 "PhotoMetadata.c"
	}
}


static void keyword_transformer_class_init (KeywordTransformerClass * klass) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	keyword_transformer_parent_class = g_type_class_peek_parent (klass);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((KeywordTransformerClass *) klass)->finalize = keyword_transformer_finalize;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((KeywordTransformerClass *) klass)->transform = keyword_transformer_real_transform;
#line 975 "PhotoMetadata.c"
}


static void keyword_transformer_instance_init (KeywordTransformer * self) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->ref_count = 1;
#line 982 "PhotoMetadata.c"
}


static void keyword_transformer_finalize (KeywordTransformer* obj) {
	KeywordTransformer * self;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KEYWORD_TRANSFORMER, KeywordTransformer);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_signal_handlers_destroy (self);
#line 992 "PhotoMetadata.c"
}


GType keyword_transformer_get_type (void) {
	static volatile gsize keyword_transformer_type_id__volatile = 0;
	if (g_once_init_enter (&keyword_transformer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_keyword_transformer_init, value_keyword_transformer_free_value, value_keyword_transformer_copy_value, value_keyword_transformer_peek_pointer, "p", value_keyword_transformer_collect_value, "p", value_keyword_transformer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (KeywordTransformerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keyword_transformer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeywordTransformer), 0, (GInstanceInitFunc) keyword_transformer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType keyword_transformer_type_id;
		keyword_transformer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "KeywordTransformer", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&keyword_transformer_type_id__volatile, keyword_transformer_type_id);
	}
	return keyword_transformer_type_id__volatile;
}


gpointer keyword_transformer_ref (gpointer instance) {
	KeywordTransformer* self;
	self = instance;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&self->ref_count);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return instance;
#line 1017 "PhotoMetadata.c"
}


void keyword_transformer_unref (gpointer instance) {
	KeywordTransformer* self;
	self = instance;
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		KEYWORD_TRANSFORMER_GET_CLASS (self)->finalize (self);
#line 31 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1030 "PhotoMetadata.c"
	}
}


static GeeList* null_keyword_transformer_real_transform (KeywordTransformer* base, const gchar* input, GError** error) {
	NullKeywordTransformer * self;
	GeeList* result = NULL;
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 36 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_NULL_KEYWORD_TRANSFORMER, NullKeywordTransformer);
#line 36 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (input != NULL, NULL);
#line 37 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 37 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_result_ = _tmp0_;
#line 38 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = input;
#line 38 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_result_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp1_);
#line 40 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_result_, GEE_TYPE_LIST, GeeList);
#line 40 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 1057 "PhotoMetadata.c"
}


NullKeywordTransformer* null_keyword_transformer_construct (GType object_type) {
	NullKeywordTransformer* self = NULL;
#line 35 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = (NullKeywordTransformer*) keyword_transformer_construct (object_type);
#line 35 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self;
#line 1067 "PhotoMetadata.c"
}


NullKeywordTransformer* null_keyword_transformer_new (void) {
#line 35 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return null_keyword_transformer_construct (TYPE_NULL_KEYWORD_TRANSFORMER);
#line 1074 "PhotoMetadata.c"
}


static void null_keyword_transformer_class_init (NullKeywordTransformerClass * klass) {
#line 35 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	null_keyword_transformer_parent_class = g_type_class_peek_parent (klass);
#line 35 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((KeywordTransformerClass *) klass)->transform = null_keyword_transformer_real_transform;
#line 1083 "PhotoMetadata.c"
}


static void null_keyword_transformer_instance_init (NullKeywordTransformer * self) {
}


GType null_keyword_transformer_get_type (void) {
	static volatile gsize null_keyword_transformer_type_id__volatile = 0;
	if (g_once_init_enter (&null_keyword_transformer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NullKeywordTransformerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) null_keyword_transformer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NullKeywordTransformer), 0, (GInstanceInitFunc) null_keyword_transformer_instance_init, NULL };
		GType null_keyword_transformer_type_id;
		null_keyword_transformer_type_id = g_type_register_static (TYPE_KEYWORD_TRANSFORMER, "NullKeywordTransformer", &g_define_type_info, 0);
		g_once_init_leave (&null_keyword_transformer_type_id__volatile, null_keyword_transformer_type_id);
	}
	return null_keyword_transformer_type_id__volatile;
}


static void _acd_see_keyword_transformer_on_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error) {
#line 64 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	acd_see_keyword_transformer_on_start ((ACDSeeKeywordTransformer*) self, context, element_name, attribute_names, attribute_values, error);
#line 1106 "PhotoMetadata.c"
}


static void _acd_see_keyword_transformer_on_end_gmarkup_parser_end_element_func (GMarkupParseContext* context, const gchar* element_name, gpointer self, GError** error) {
#line 65 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	acd_see_keyword_transformer_on_end ((ACDSeeKeywordTransformer*) self, context, element_name, error);
#line 1113 "PhotoMetadata.c"
}


static void _acd_see_keyword_transformer_on_text_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error) {
#line 66 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	acd_see_keyword_transformer_on_text ((ACDSeeKeywordTransformer*) self, context, text, error);
#line 1120 "PhotoMetadata.c"
}


static void _acd_see_keyword_transformer_on_error_gmarkup_parser_error_func (GMarkupParseContext* context, GError* _error_, gpointer self) {
#line 67 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	acd_see_keyword_transformer_on_error ((ACDSeeKeywordTransformer*) self, context, _error_);
#line 1127 "PhotoMetadata.c"
}


ACDSeeKeywordTransformer* acd_see_keyword_transformer_construct (GType object_type) {
	ACDSeeKeywordTransformer* self = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayQueue* _tmp1_ = NULL;
#line 62 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = (ACDSeeKeywordTransformer*) keyword_transformer_construct (object_type);
#line 63 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	memset (&self->priv->parser, 0, sizeof (GMarkupParser));
#line 64 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->parser.start_element = _acd_see_keyword_transformer_on_start_gmarkup_parser_start_element_func;
#line 65 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->parser.end_element = _acd_see_keyword_transformer_on_end_gmarkup_parser_end_element_func;
#line 66 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->parser.text = _acd_see_keyword_transformer_on_text_gmarkup_parser_text_func;
#line 67 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->parser.error = _acd_see_keyword_transformer_on_error_gmarkup_parser_error_func;
#line 68 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 68 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (self->priv->result);
#line 68 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->result = _tmp0_;
#line 69 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = gee_array_queue_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 69 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (self->priv->stack);
#line 69 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->stack = _tmp1_;
#line 62 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self;
#line 1161 "PhotoMetadata.c"
}


ACDSeeKeywordTransformer* acd_see_keyword_transformer_new (void) {
#line 62 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return acd_see_keyword_transformer_construct (TYPE_ACD_SEE_KEYWORD_TRANSFORMER);
#line 1168 "PhotoMetadata.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 77 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self ? g_object_ref (self) : NULL;
#line 1175 "PhotoMetadata.c"
}


static GeeList* acd_see_keyword_transformer_real_transform (KeywordTransformer* base, const gchar* input, GError** error) {
	ACDSeeKeywordTransformer * self;
	GeeList* result = NULL;
	GMarkupParseContext* ctx = NULL;
	GMarkupParser _tmp0_ = {0};
	GMarkupParseContext* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GeeArrayList* _tmp6_ = NULL;
	GeeList* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
#line 72 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ACD_SEE_KEYWORD_TRANSFORMER, ACDSeeKeywordTransformer);
#line 72 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (input != NULL, NULL);
#line 73 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->parser;
#line 73 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_markup_parse_context_new (&_tmp0_, 0, self, NULL);
#line 73 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	ctx = _tmp1_;
#line 75 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = input;
#line 75 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = input;
#line 75 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = strlen (_tmp3_);
#line 75 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = _tmp4_;
#line 75 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_markup_parse_context_parse (ctx, _tmp2_, (gssize) _tmp5_, &_inner_error_);
#line 75 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 75 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 75 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_markup_parse_context_unref0 (ctx);
#line 75 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return NULL;
#line 1220 "PhotoMetadata.c"
	}
#line 77 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = self->priv->result;
#line 77 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_LIST, GeeList));
#line 77 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp7_;
#line 77 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_markup_parse_context_unref0 (ctx);
#line 77 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 1232 "PhotoMetadata.c"
}


static void acd_see_keyword_transformer_on_start (ACDSeeKeywordTransformer* self, GMarkupParseContext* ctx, const gchar* name, gchar** attribute_names, gchar** attribute_values, GError** error) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	GError * _inner_error_ = NULL;
#line 80 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_ACD_SEE_KEYWORD_TRANSFORMER (self));
#line 80 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (ctx != NULL);
#line 80 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (name != NULL);
#line 88 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->assigned = FALSE;
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = name;
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_strcmp0 (_tmp0_, "Categories") == 0) {
#line 90 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 1259 "PhotoMetadata.c"
	}
#line 93 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = name;
#line 93 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_strcmp0 (_tmp1_, "Category") != 0) {
#line 94 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 1267 "PhotoMetadata.c"
	}
#line 97 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = name;
#line 97 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = attribute_names;
#line 97 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3__length1 = _vala_array_length (attribute_names);
#line 97 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = attribute_values;
#line 97 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4__length1 = _vala_array_length (attribute_values);
#line 97 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_markup_collect_attributes (_tmp2_, _tmp3_, _tmp4_, &_inner_error_, G_MARKUP_COLLECT_BOOLEAN, "Assigned", &self->priv->assigned, G_MARKUP_COLLECT_INVALID);
#line 97 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 97 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (_inner_error_->domain == G_MARKUP_ERROR) {
#line 97 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 97 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return;
#line 1289 "PhotoMetadata.c"
		} else {
#line 97 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 97 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			g_clear_error (&_inner_error_);
#line 97 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return;
#line 1297 "PhotoMetadata.c"
		}
	}
}


static void acd_see_keyword_transformer_on_end (ACDSeeKeywordTransformer* self, GMarkupParseContext* ctx, const gchar* name, GError** error) {
	const gchar* _tmp0_ = NULL;
#line 104 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_ACD_SEE_KEYWORD_TRANSFORMER (self));
#line 104 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (ctx != NULL);
#line 104 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (name != NULL);
#line 106 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = name;
#line 106 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_strcmp0 (_tmp0_, "Category") == 0) {
#line 1315 "PhotoMetadata.c"
		GeeArrayQueue* _tmp1_ = NULL;
		gpointer _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 107 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = self->priv->stack;
#line 107 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = gee_deque_poll_tail (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_DEQUE, GeeDeque));
#line 107 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = (gchar*) _tmp2_;
#line 107 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_tmp3_);
#line 1327 "PhotoMetadata.c"
	}
}


static void acd_see_keyword_transformer_on_text (ACDSeeKeywordTransformer* self, GMarkupParseContext* ctx, const gchar* text, GError** error) {
	const gchar* _tmp0_ = NULL;
	GeeArrayQueue* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 111 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_ACD_SEE_KEYWORD_TRANSFORMER (self));
#line 111 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (ctx != NULL);
#line 111 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (text != NULL);
#line 113 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = text;
#line 113 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_strcmp0 (_tmp0_, "") == 0) {
#line 114 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 1349 "PhotoMetadata.c"
	}
#line 117 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = self->priv->stack;
#line 117 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = text;
#line 117 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gee_deque_offer_tail (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_DEQUE, GeeDeque), _tmp2_);
#line 118 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = self->priv->assigned;
#line 118 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp3_) {
#line 1361 "PhotoMetadata.c"
		GString* builder = NULL;
		GString* _tmp4_ = NULL;
		GString* _tmp13_ = NULL;
		gssize _tmp14_ = 0L;
		GeeArrayList* _tmp18_ = NULL;
		GString* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
#line 119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = g_string_new ("");
#line 119 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		builder = _tmp4_;
#line 1373 "PhotoMetadata.c"
		{
			GeeIterator* _f_it = NULL;
			GeeArrayQueue* _tmp5_ = NULL;
			GeeIterator* _tmp6_ = NULL;
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp5_ = self->priv->stack;
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp6_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_f_it = _tmp6_;
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			while (TRUE) {
#line 1386 "PhotoMetadata.c"
				GeeIterator* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				gchar* f = NULL;
				GeeIterator* _tmp9_ = NULL;
				gpointer _tmp10_ = NULL;
				GString* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp7_ = _f_it;
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp8_ = gee_iterator_next (_tmp7_);
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!_tmp8_) {
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					break;
#line 1402 "PhotoMetadata.c"
				}
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp9_ = _f_it;
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp10_ = gee_iterator_get (_tmp9_);
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				f = (gchar*) _tmp10_;
#line 121 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp11_ = builder;
#line 121 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp12_ = f;
#line 121 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				g_string_append_printf (_tmp11_, "%s|", _tmp12_);
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (f);
#line 1418 "PhotoMetadata.c"
			}
#line 120 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_g_object_unref0 (_f_it);
#line 1422 "PhotoMetadata.c"
		}
#line 123 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp13_ = builder;
#line 123 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp14_ = _tmp13_->len;
#line 123 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (_tmp14_ > ((gssize) 0)) {
#line 1430 "PhotoMetadata.c"
			GString* _tmp15_ = NULL;
			GString* _tmp16_ = NULL;
			gssize _tmp17_ = 0L;
#line 124 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp15_ = builder;
#line 124 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp16_ = builder;
#line 124 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp17_ = _tmp16_->len;
#line 124 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			g_string_truncate (_tmp15_, (gsize) (_tmp17_ - 1));
#line 1442 "PhotoMetadata.c"
		}
#line 126 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp18_ = self->priv->result;
#line 126 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp19_ = builder;
#line 126 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp20_ = _tmp19_->str;
#line 126 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp20_);
#line 118 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_string_free0 (builder);
#line 1454 "PhotoMetadata.c"
	}
}


static gpointer _g_error_copy0 (gpointer self) {
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self ? g_error_copy (self) : NULL;
#line 1462 "PhotoMetadata.c"
}


static void acd_see_keyword_transformer_on_error (ACDSeeKeywordTransformer* self, GMarkupParseContext* ctx, GError* _error_) {
	GError* _tmp0_ = NULL;
	GError* _tmp1_ = NULL;
#line 130 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_ACD_SEE_KEYWORD_TRANSFORMER (self));
#line 130 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (ctx != NULL);
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = _error_;
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = _g_error_copy0 (_tmp0_);
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_error_free0 (self->priv->error);
#line 131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->error = _tmp1_;
#line 1481 "PhotoMetadata.c"
}


static void acd_see_keyword_transformer_class_init (ACDSeeKeywordTransformerClass * klass) {
#line 55 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	acd_see_keyword_transformer_parent_class = g_type_class_peek_parent (klass);
#line 55 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((KeywordTransformerClass *) klass)->finalize = acd_see_keyword_transformer_finalize;
#line 55 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_type_class_add_private (klass, sizeof (ACDSeeKeywordTransformerPrivate));
#line 55 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((KeywordTransformerClass *) klass)->transform = acd_see_keyword_transformer_real_transform;
#line 1494 "PhotoMetadata.c"
}


static void acd_see_keyword_transformer_instance_init (ACDSeeKeywordTransformer * self) {
#line 55 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv = ACD_SEE_KEYWORD_TRANSFORMER_GET_PRIVATE (self);
#line 1501 "PhotoMetadata.c"
}


static void acd_see_keyword_transformer_finalize (KeywordTransformer* obj) {
	ACDSeeKeywordTransformer * self;
#line 55 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ACD_SEE_KEYWORD_TRANSFORMER, ACDSeeKeywordTransformer);
#line 57 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_error_free0 (self->priv->error);
#line 58 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (self->priv->stack);
#line 59 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (self->priv->result);
#line 55 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	KEYWORD_TRANSFORMER_CLASS (acd_see_keyword_transformer_parent_class)->finalize (obj);
#line 1517 "PhotoMetadata.c"
}


GType acd_see_keyword_transformer_get_type (void) {
	static volatile gsize acd_see_keyword_transformer_type_id__volatile = 0;
	if (g_once_init_enter (&acd_see_keyword_transformer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ACDSeeKeywordTransformerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) acd_see_keyword_transformer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ACDSeeKeywordTransformer), 0, (GInstanceInitFunc) acd_see_keyword_transformer_instance_init, NULL };
		GType acd_see_keyword_transformer_type_id;
		acd_see_keyword_transformer_type_id = g_type_register_static (TYPE_KEYWORD_TRANSFORMER, "ACDSeeKeywordTransformer", &g_define_type_info, 0);
		g_once_init_leave (&acd_see_keyword_transformer_type_id__volatile, acd_see_keyword_transformer_type_id);
	}
	return acd_see_keyword_transformer_type_id__volatile;
}


static gpointer _keyword_transformer_ref0 (gpointer self) {
#line 154 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self ? keyword_transformer_ref (self) : NULL;
#line 1536 "PhotoMetadata.c"
}


HierarchicalKeywordField* hierarchical_keyword_field_construct (GType object_type, const gchar* field_name, const gchar* path_separator, gboolean wants_leading_separator, gboolean is_writeable, KeywordTransformer* transformer) {
	HierarchicalKeywordField* self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	KeywordTransformer* _tmp6_ = NULL;
	KeywordTransformer* _tmp7_ = NULL;
#line 144 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (field_name != NULL, NULL);
#line 144 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (path_separator != NULL, NULL);
#line 144 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_KEYWORD_TRANSFORMER (transformer), NULL);
#line 144 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = (HierarchicalKeywordField*) g_type_create_instance (object_type);
#line 150 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = field_name;
#line 150 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 150 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->field_name);
#line 150 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->field_name = _tmp1_;
#line 151 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = path_separator;
#line 151 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 151 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->path_separator);
#line 151 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->path_separator = _tmp3_;
#line 152 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = wants_leading_separator;
#line 152 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->wants_leading_separator = _tmp4_;
#line 153 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = is_writeable;
#line 153 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->is_writeable = _tmp5_;
#line 154 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = transformer;
#line 154 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = _keyword_transformer_ref0 (_tmp6_);
#line 154 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_keyword_transformer_unref0 (self->transformer);
#line 154 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->transformer = _tmp7_;
#line 144 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self;
#line 1592 "PhotoMetadata.c"
}


HierarchicalKeywordField* hierarchical_keyword_field_new (const gchar* field_name, const gchar* path_separator, gboolean wants_leading_separator, gboolean is_writeable, KeywordTransformer* transformer) {
#line 144 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return hierarchical_keyword_field_construct (TYPE_HIERARCHICAL_KEYWORD_FIELD, field_name, path_separator, wants_leading_separator, is_writeable, transformer);
#line 1599 "PhotoMetadata.c"
}


static void value_hierarchical_keyword_field_init (GValue* value) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	value->data[0].v_pointer = NULL;
#line 1606 "PhotoMetadata.c"
}


static void value_hierarchical_keyword_field_free_value (GValue* value) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (value->data[0].v_pointer) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		hierarchical_keyword_field_unref (value->data[0].v_pointer);
#line 1615 "PhotoMetadata.c"
	}
}


static void value_hierarchical_keyword_field_copy_value (const GValue* src_value, GValue* dest_value) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (src_value->data[0].v_pointer) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		dest_value->data[0].v_pointer = hierarchical_keyword_field_ref (src_value->data[0].v_pointer);
#line 1625 "PhotoMetadata.c"
	} else {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1629 "PhotoMetadata.c"
	}
}


static gpointer value_hierarchical_keyword_field_peek_pointer (const GValue* value) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return value->data[0].v_pointer;
#line 1637 "PhotoMetadata.c"
}


static gchar* value_hierarchical_keyword_field_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (collect_values[0].v_pointer) {
#line 1644 "PhotoMetadata.c"
		HierarchicalKeywordField* object;
		object = collect_values[0].v_pointer;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (object->parent_instance.g_class == NULL) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1651 "PhotoMetadata.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1655 "PhotoMetadata.c"
		}
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = hierarchical_keyword_field_ref (object);
#line 1659 "PhotoMetadata.c"
	} else {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 1663 "PhotoMetadata.c"
	}
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 1667 "PhotoMetadata.c"
}


static gchar* value_hierarchical_keyword_field_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	HierarchicalKeywordField** object_p;
	object_p = collect_values[0].v_pointer;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!object_p) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1678 "PhotoMetadata.c"
	}
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!value->data[0].v_pointer) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = NULL;
#line 1684 "PhotoMetadata.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = value->data[0].v_pointer;
#line 1688 "PhotoMetadata.c"
	} else {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = hierarchical_keyword_field_ref (value->data[0].v_pointer);
#line 1692 "PhotoMetadata.c"
	}
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 1696 "PhotoMetadata.c"
}


GParamSpec* param_spec_hierarchical_keyword_field (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecHierarchicalKeywordField* spec;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HIERARCHICAL_KEYWORD_FIELD), NULL);
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return G_PARAM_SPEC (spec);
#line 1710 "PhotoMetadata.c"
}


gpointer value_get_hierarchical_keyword_field (const GValue* value) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HIERARCHICAL_KEYWORD_FIELD), NULL);
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return value->data[0].v_pointer;
#line 1719 "PhotoMetadata.c"
}


void value_set_hierarchical_keyword_field (GValue* value, gpointer v_object) {
	HierarchicalKeywordField* old;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HIERARCHICAL_KEYWORD_FIELD));
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	old = value->data[0].v_pointer;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (v_object) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HIERARCHICAL_KEYWORD_FIELD));
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		hierarchical_keyword_field_ref (value->data[0].v_pointer);
#line 1739 "PhotoMetadata.c"
	} else {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 1743 "PhotoMetadata.c"
	}
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (old) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		hierarchical_keyword_field_unref (old);
#line 1749 "PhotoMetadata.c"
	}
}


void value_take_hierarchical_keyword_field (GValue* value, gpointer v_object) {
	HierarchicalKeywordField* old;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HIERARCHICAL_KEYWORD_FIELD));
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	old = value->data[0].v_pointer;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (v_object) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HIERARCHICAL_KEYWORD_FIELD));
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 1768 "PhotoMetadata.c"
	} else {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 1772 "PhotoMetadata.c"
	}
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (old) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		hierarchical_keyword_field_unref (old);
#line 1778 "PhotoMetadata.c"
	}
}


static void hierarchical_keyword_field_class_init (HierarchicalKeywordFieldClass * klass) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	hierarchical_keyword_field_parent_class = g_type_class_peek_parent (klass);
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((HierarchicalKeywordFieldClass *) klass)->finalize = hierarchical_keyword_field_finalize;
#line 1788 "PhotoMetadata.c"
}


static void hierarchical_keyword_field_instance_init (HierarchicalKeywordField * self) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->ref_count = 1;
#line 1795 "PhotoMetadata.c"
}


static void hierarchical_keyword_field_finalize (HierarchicalKeywordField* obj) {
	HierarchicalKeywordField * self;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HIERARCHICAL_KEYWORD_FIELD, HierarchicalKeywordField);
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_signal_handlers_destroy (self);
#line 138 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->field_name);
#line 139 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->path_separator);
#line 142 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_keyword_transformer_unref0 (self->transformer);
#line 1811 "PhotoMetadata.c"
}


GType hierarchical_keyword_field_get_type (void) {
	static volatile gsize hierarchical_keyword_field_type_id__volatile = 0;
	if (g_once_init_enter (&hierarchical_keyword_field_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_hierarchical_keyword_field_init, value_hierarchical_keyword_field_free_value, value_hierarchical_keyword_field_copy_value, value_hierarchical_keyword_field_peek_pointer, "p", value_hierarchical_keyword_field_collect_value, "p", value_hierarchical_keyword_field_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (HierarchicalKeywordFieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) hierarchical_keyword_field_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HierarchicalKeywordField), 0, (GInstanceInitFunc) hierarchical_keyword_field_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType hierarchical_keyword_field_type_id;
		hierarchical_keyword_field_type_id = g_type_register_fundamental (g_type_fundamental_next (), "HierarchicalKeywordField", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&hierarchical_keyword_field_type_id__volatile, hierarchical_keyword_field_type_id);
	}
	return hierarchical_keyword_field_type_id__volatile;
}


gpointer hierarchical_keyword_field_ref (gpointer instance) {
	HierarchicalKeywordField* self;
	self = instance;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&self->ref_count);
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return instance;
#line 1836 "PhotoMetadata.c"
}


void hierarchical_keyword_field_unref (gpointer instance) {
	HierarchicalKeywordField* self;
	self = instance;
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		HIERARCHICAL_KEYWORD_FIELD_GET_CLASS (self)->finalize (self);
#line 137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1849 "PhotoMetadata.c"
	}
}


PhotoPreview* photo_preview_construct (GType object_type, const gchar* name, Dimensions* dimensions, guint32 size, const gchar* mime_type, const gchar* extension) {
	PhotoPreview* self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	Dimensions _tmp2_ = {0};
	guint32 _tmp3_ = 0U;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (dimensions != NULL, NULL);
#line 165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (mime_type != NULL, NULL);
#line 165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (extension != NULL, NULL);
#line 165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = (PhotoPreview*) g_type_create_instance (object_type);
#line 166 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = name;
#line 166 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 166 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->name);
#line 166 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->name = _tmp1_;
#line 167 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = *dimensions;
#line 167 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->dimensions = _tmp2_;
#line 168 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = size;
#line 168 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->size = _tmp3_;
#line 169 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = mime_type;
#line 169 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 169 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->mime_type);
#line 169 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->mime_type = _tmp5_;
#line 170 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = extension;
#line 170 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 170 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->extension);
#line 170 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->extension = _tmp7_;
#line 165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self;
#line 1908 "PhotoMetadata.c"
}


gchar* photo_preview_get_name (PhotoPreview* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 173 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_PREVIEW (self), NULL);
#line 174 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->name;
#line 174 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 174 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 174 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 1926 "PhotoMetadata.c"
}


void photo_preview_get_pixel_dimensions (PhotoPreview* self, Dimensions* result) {
	Dimensions _tmp0_ = {0};
#line 177 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_PREVIEW (self));
#line 178 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->dimensions;
#line 178 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	*result = _tmp0_;
#line 178 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return;
#line 1940 "PhotoMetadata.c"
}


guint32 photo_preview_get_size (PhotoPreview* self) {
	guint32 result = 0U;
	guint32 _tmp0_ = 0U;
#line 181 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_PREVIEW (self), 0U);
#line 182 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->size;
#line 182 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 182 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 1955 "PhotoMetadata.c"
}


gchar* photo_preview_get_mime_type (PhotoPreview* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 185 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_PREVIEW (self), NULL);
#line 186 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->mime_type;
#line 186 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 186 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 186 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 1973 "PhotoMetadata.c"
}


gchar* photo_preview_get_extension (PhotoPreview* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 189 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_PREVIEW (self), NULL);
#line 190 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->extension;
#line 190 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 190 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 190 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 1991 "PhotoMetadata.c"
}


static guint8* photo_preview_real_flatten (PhotoPreview* self, int* result_length1, GError** error) {
#line 193 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_preview_flatten'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 193 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 2000 "PhotoMetadata.c"
}


guint8* photo_preview_flatten (PhotoPreview* self, int* result_length1, GError** error) {
#line 193 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_PREVIEW (self), NULL);
#line 193 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return PHOTO_PREVIEW_GET_CLASS (self)->flatten (self, result_length1, error);
#line 2009 "PhotoMetadata.c"
}


static guint8* _vala_array_dup4 (guint8* self, int length) {
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 2016 "PhotoMetadata.c"
}


static GdkPixbuf* photo_preview_real_get_pixbuf (PhotoPreview* self, GError** error) {
	GdkPixbuf* result = NULL;
	guint8* flattened = NULL;
	gint _tmp0_ = 0;
	guint8* _tmp1_ = NULL;
	gint flattened_length1 = 0;
	gint _flattened_size_ = 0;
	GError * _inner_error_ = NULL;
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_preview_flatten (self, &_tmp0_, &_inner_error_);
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	flattened = _tmp1_;
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	flattened_length1 = _tmp0_;
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_flattened_size_ = flattened_length1;
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 196 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return NULL;
#line 2042 "PhotoMetadata.c"
	}
	{
		GdkPixbuf* _tmp2_ = NULL;
		guint8* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		GMemoryInputStream* _tmp4_ = NULL;
		GMemoryInputStream* _tmp5_ = NULL;
		GdkPixbuf* _tmp6_ = NULL;
		GdkPixbuf* _tmp7_ = NULL;
		GdkPixbuf* _tmp8_ = NULL;
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = (flattened != NULL) ? _vala_array_dup4 (flattened, flattened_length1) : ((gpointer) flattened);
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3__length1 = flattened_length1;
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp3_, _tmp3__length1, NULL);
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = _tmp4_;
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = gdk_pixbuf_new_from_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_input_stream_get_type (), GInputStream), NULL, &_inner_error_);
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = _tmp6_;
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_object_unref0 (_tmp5_);
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = _tmp7_;
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2071 "PhotoMetadata.c"
			goto __catch25_g_error;
		}
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp8_ = _tmp2_;
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = NULL;
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = _tmp8_;
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_object_unref0 (_tmp2_);
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		flattened = (g_free (flattened), NULL);
#line 201 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 2086 "PhotoMetadata.c"
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
#line 200 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		err = _inner_error_;
#line 200 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_inner_error_ = NULL;
#line 204 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = self->priv->name;
#line 204 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = err;
#line 204 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp11_ = _tmp10_->message;
#line 204 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_warning ("PhotoMetadata.vala:204: Unable to decode thumbnail for %s: %s", _tmp9_, _tmp11_);
#line 206 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 206 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_error_free0 (err);
#line 206 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		flattened = (g_free (flattened), NULL);
#line 206 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 2115 "PhotoMetadata.c"
	}
	__finally25:
#line 200 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_propagate_error (error, _inner_error_);
#line 200 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	flattened = (g_free (flattened), NULL);
#line 200 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 2124 "PhotoMetadata.c"
}


GdkPixbuf* photo_preview_get_pixbuf (PhotoPreview* self, GError** error) {
#line 195 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_PREVIEW (self), NULL);
#line 195 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return PHOTO_PREVIEW_GET_CLASS (self)->get_pixbuf (self, error);
#line 2133 "PhotoMetadata.c"
}


static void value_photo_preview_init (GValue* value) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	value->data[0].v_pointer = NULL;
#line 2140 "PhotoMetadata.c"
}


static void value_photo_preview_free_value (GValue* value) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (value->data[0].v_pointer) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_preview_unref (value->data[0].v_pointer);
#line 2149 "PhotoMetadata.c"
	}
}


static void value_photo_preview_copy_value (const GValue* src_value, GValue* dest_value) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (src_value->data[0].v_pointer) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		dest_value->data[0].v_pointer = photo_preview_ref (src_value->data[0].v_pointer);
#line 2159 "PhotoMetadata.c"
	} else {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2163 "PhotoMetadata.c"
	}
}


static gpointer value_photo_preview_peek_pointer (const GValue* value) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return value->data[0].v_pointer;
#line 2171 "PhotoMetadata.c"
}


static gchar* value_photo_preview_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (collect_values[0].v_pointer) {
#line 2178 "PhotoMetadata.c"
		PhotoPreview* object;
		object = collect_values[0].v_pointer;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (object->parent_instance.g_class == NULL) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2185 "PhotoMetadata.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2189 "PhotoMetadata.c"
		}
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = photo_preview_ref (object);
#line 2193 "PhotoMetadata.c"
	} else {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 2197 "PhotoMetadata.c"
	}
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 2201 "PhotoMetadata.c"
}


static gchar* value_photo_preview_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PhotoPreview** object_p;
	object_p = collect_values[0].v_pointer;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!object_p) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2212 "PhotoMetadata.c"
	}
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!value->data[0].v_pointer) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = NULL;
#line 2218 "PhotoMetadata.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = value->data[0].v_pointer;
#line 2222 "PhotoMetadata.c"
	} else {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*object_p = photo_preview_ref (value->data[0].v_pointer);
#line 2226 "PhotoMetadata.c"
	}
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 2230 "PhotoMetadata.c"
}


GParamSpec* param_spec_photo_preview (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPhotoPreview* spec;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_PREVIEW), NULL);
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return G_PARAM_SPEC (spec);
#line 2244 "PhotoMetadata.c"
}


gpointer value_get_photo_preview (const GValue* value) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_PREVIEW), NULL);
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return value->data[0].v_pointer;
#line 2253 "PhotoMetadata.c"
}


void value_set_photo_preview (GValue* value, gpointer v_object) {
	PhotoPreview* old;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_PREVIEW));
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	old = value->data[0].v_pointer;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (v_object) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_PREVIEW));
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_preview_ref (value->data[0].v_pointer);
#line 2273 "PhotoMetadata.c"
	} else {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 2277 "PhotoMetadata.c"
	}
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (old) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_preview_unref (old);
#line 2283 "PhotoMetadata.c"
	}
}


void value_take_photo_preview (GValue* value, gpointer v_object) {
	PhotoPreview* old;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_PREVIEW));
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	old = value->data[0].v_pointer;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (v_object) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_PREVIEW));
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 2302 "PhotoMetadata.c"
	} else {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 2306 "PhotoMetadata.c"
	}
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (old) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_preview_unref (old);
#line 2312 "PhotoMetadata.c"
	}
}


static void photo_preview_class_init (PhotoPreviewClass * klass) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_preview_parent_class = g_type_class_peek_parent (klass);
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((PhotoPreviewClass *) klass)->finalize = photo_preview_finalize;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_type_class_add_private (klass, sizeof (PhotoPreviewPrivate));
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((PhotoPreviewClass *) klass)->flatten = photo_preview_real_flatten;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((PhotoPreviewClass *) klass)->get_pixbuf = photo_preview_real_get_pixbuf;
#line 2328 "PhotoMetadata.c"
}


static void photo_preview_instance_init (PhotoPreview * self) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv = PHOTO_PREVIEW_GET_PRIVATE (self);
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->ref_count = 1;
#line 2337 "PhotoMetadata.c"
}


static void photo_preview_finalize (PhotoPreview* obj) {
	PhotoPreview * self;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_PREVIEW, PhotoPreview);
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_signal_handlers_destroy (self);
#line 159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->name);
#line 162 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->mime_type);
#line 163 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->extension);
#line 2353 "PhotoMetadata.c"
}


GType photo_preview_get_type (void) {
	static volatile gsize photo_preview_type_id__volatile = 0;
	if (g_once_init_enter (&photo_preview_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_photo_preview_init, value_photo_preview_free_value, value_photo_preview_copy_value, value_photo_preview_peek_pointer, "p", value_photo_preview_collect_value, "p", value_photo_preview_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PhotoPreviewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_preview_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoPreview), 0, (GInstanceInitFunc) photo_preview_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType photo_preview_type_id;
		photo_preview_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoPreview", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&photo_preview_type_id__volatile, photo_preview_type_id);
	}
	return photo_preview_type_id__volatile;
}


gpointer photo_preview_ref (gpointer instance) {
	PhotoPreview* self;
	self = instance;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&self->ref_count);
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return instance;
#line 2378 "PhotoMetadata.c"
}


void photo_preview_unref (gpointer instance) {
	PhotoPreview* self;
	self = instance;
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		PHOTO_PREVIEW_GET_CLASS (self)->finalize (self);
#line 158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2391 "PhotoMetadata.c"
	}
}


GType photo_metadata_set_option_get_type (void) {
	static volatile gsize photo_metadata_set_option_type_id__volatile = 0;
	if (g_once_init_enter (&photo_metadata_set_option_type_id__volatile)) {
		static const GEnumValue values[] = {{PHOTO_METADATA_SET_OPTION_ALL_DOMAINS, "PHOTO_METADATA_SET_OPTION_ALL_DOMAINS", "all-domains"}, {PHOTO_METADATA_SET_OPTION_ONLY_IF_DOMAIN_PRESENT, "PHOTO_METADATA_SET_OPTION_ONLY_IF_DOMAIN_PRESENT", "only-if-domain-present"}, {PHOTO_METADATA_SET_OPTION_AT_LEAST_DEFAULT_DOMAIN, "PHOTO_METADATA_SET_OPTION_AT_LEAST_DEFAULT_DOMAIN", "at-least-default-domain"}, {0, NULL, NULL}};
		GType photo_metadata_set_option_type_id;
		photo_metadata_set_option_type_id = g_enum_register_static ("PhotoMetadataSetOption", values);
		g_once_init_leave (&photo_metadata_set_option_type_id__volatile, photo_metadata_set_option_type_id);
	}
	return photo_metadata_set_option_type_id__volatile;
}


PhotoMetadata* photo_metadata_construct (GType object_type) {
	PhotoMetadata* self = NULL;
#line 251 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = (PhotoMetadata*) media_metadata_construct (object_type);
#line 251 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self;
#line 2414 "PhotoMetadata.c"
}


PhotoMetadata* photo_metadata_new (void) {
#line 251 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return photo_metadata_construct (TYPE_PHOTO_METADATA);
#line 2421 "PhotoMetadata.c"
}


static void photo_metadata_real_read_from_file (MediaMetadata* base, GFile* file, GError** error) {
	PhotoMetadata * self;
	GExiv2Metadata* _tmp0_ = NULL;
	GExiv2Metadata* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	ExifData* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
#line 254 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_METADATA, PhotoMetadata);
#line 254 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 255 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = gexiv2_metadata_new ();
#line 255 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (self->priv->exiv2);
#line 255 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exiv2 = _tmp0_;
#line 256 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_exif_data_unref0 (self->priv->exif);
#line 256 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exif = NULL;
#line 258 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = self->priv->exiv2;
#line 258 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = file;
#line 258 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = g_file_get_path (_tmp2_);
#line 258 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = _tmp3_;
#line 258 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_open_path (_tmp1_, _tmp4_, &_inner_error_);
#line 258 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp4_);
#line 258 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 258 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 258 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 2471 "PhotoMetadata.c"
	}
#line 259 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = file;
#line 259 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = g_file_get_path (_tmp5_);
#line 259 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = _tmp6_;
#line 259 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = exif_data_new_from_file (_tmp7_);
#line 259 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_exif_data_unref0 (self->priv->exif);
#line 259 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exif = _tmp8_;
#line 259 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp7_);
#line 260 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = file;
#line 260 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = g_file_get_basename (_tmp9_);
#line 260 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->source_name);
#line 260 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->source_name = _tmp10_;
#line 2495 "PhotoMetadata.c"
}


void photo_metadata_write_to_file (PhotoMetadata* self, GFile* file, GError** error) {
	GExiv2Metadata* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 263 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 263 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 264 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 264 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = file;
#line 264 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = g_file_get_path (_tmp1_);
#line 264 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = _tmp2_;
#line 264 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_save_file (_tmp0_, _tmp3_, &_inner_error_);
#line 264 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp3_);
#line 264 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 264 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 264 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 2527 "PhotoMetadata.c"
	}
}


void photo_metadata_read_from_buffer (PhotoMetadata* self, guint8* buffer, int buffer_length1, gint length, GError** error) {
	gint _tmp0_ = 0;
	guint8* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	GExiv2Metadata* _tmp4_ = NULL;
	GExiv2Metadata* _tmp5_ = NULL;
	guint8* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint _tmp7_ = 0;
	guint8* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp9_ = 0;
	ExifData* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
#line 267 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 268 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = length;
#line 268 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp0_ <= 0) {
#line 2555 "PhotoMetadata.c"
		guint8* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
#line 269 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = buffer;
#line 269 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1__length1 = buffer_length1;
#line 269 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		length = _tmp1__length1;
#line 2564 "PhotoMetadata.c"
	}
#line 271 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = buffer;
#line 271 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2__length1 = buffer_length1;
#line 271 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = length;
#line 271 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_assert (_tmp2__length1 >= _tmp3_, "buffer.length >= length");
#line 273 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = gexiv2_metadata_new ();
#line 273 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (self->priv->exiv2);
#line 273 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exiv2 = _tmp4_;
#line 274 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_exif_data_unref0 (self->priv->exif);
#line 274 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exif = NULL;
#line 276 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = self->priv->exiv2;
#line 276 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = buffer;
#line 276 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6__length1 = buffer_length1;
#line 276 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = length;
#line 276 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_open_buf (_tmp5_, _tmp6_, (glong) _tmp7_, &_inner_error_);
#line 276 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 276 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 276 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 2600 "PhotoMetadata.c"
	}
#line 277 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = buffer;
#line 277 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8__length1 = buffer_length1;
#line 277 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = length;
#line 277 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = exif_data_new_from_data (_tmp8_, (gsize) _tmp9_);
#line 277 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_exif_data_unref0 (self->priv->exif);
#line 277 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exif = _tmp10_;
#line 278 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = length;
#line 278 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12_ = g_strdup_printf ("<memory buffer %d bytes>", _tmp11_);
#line 278 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->source_name);
#line 278 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->source_name = _tmp12_;
#line 2622 "PhotoMetadata.c"
}


void photo_metadata_read_from_app1_segment (PhotoMetadata* self, guint8* buffer, int buffer_length1, gint length, GError** error) {
	gint _tmp0_ = 0;
	guint8* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	GExiv2Metadata* _tmp4_ = NULL;
	GExiv2Metadata* _tmp5_ = NULL;
	guint8* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint _tmp7_ = 0;
	guint8* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp9_ = 0;
	ExifData* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
#line 281 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 282 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = length;
#line 282 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp0_ <= 0) {
#line 2649 "PhotoMetadata.c"
		guint8* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
#line 283 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = buffer;
#line 283 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1__length1 = buffer_length1;
#line 283 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		length = _tmp1__length1;
#line 2658 "PhotoMetadata.c"
	}
#line 285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = buffer;
#line 285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2__length1 = buffer_length1;
#line 285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = length;
#line 285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_assert (_tmp2__length1 >= _tmp3_, "buffer.length >= length");
#line 287 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = gexiv2_metadata_new ();
#line 287 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (self->priv->exiv2);
#line 287 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exiv2 = _tmp4_;
#line 288 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_exif_data_unref0 (self->priv->exif);
#line 288 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exif = NULL;
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = self->priv->exiv2;
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = buffer;
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6__length1 = buffer_length1;
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = length;
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_from_app1_segment (_tmp5_, _tmp6_, (glong) _tmp7_, &_inner_error_);
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 290 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 2694 "PhotoMetadata.c"
	}
#line 291 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = buffer;
#line 291 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8__length1 = buffer_length1;
#line 291 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = length;
#line 291 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = exif_data_new_from_data (_tmp8_, (gsize) _tmp9_);
#line 291 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_exif_data_unref0 (self->priv->exif);
#line 291 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exif = _tmp10_;
#line 292 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = length;
#line 292 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12_ = g_strdup_printf ("<app1 segment %d bytes>", _tmp11_);
#line 292 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->source_name);
#line 292 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->source_name = _tmp12_;
#line 2716 "PhotoMetadata.c"
}


MetadataDomain photo_metadata_get_tag_domain (const gchar* tag) {
	MetadataDomain result = 0;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 295 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, 0);
#line 296 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tag;
#line 296 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = gexiv2_metadata_is_exif_tag (_tmp0_);
#line 296 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp1_) {
#line 297 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = METADATA_DOMAIN_EXIF;
#line 297 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 2740 "PhotoMetadata.c"
	}
#line 299 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = tag;
#line 299 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = gexiv2_metadata_is_xmp_tag (_tmp2_);
#line 299 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp3_) {
#line 300 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = METADATA_DOMAIN_XMP;
#line 300 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 2752 "PhotoMetadata.c"
	}
#line 302 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = tag;
#line 302 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = gexiv2_metadata_is_iptc_tag (_tmp4_);
#line 302 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp5_) {
#line 303 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = METADATA_DOMAIN_IPTC;
#line 303 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 2764 "PhotoMetadata.c"
	}
#line 305 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = METADATA_DOMAIN_UNKNOWN;
#line 305 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 2770 "PhotoMetadata.c"
}


gboolean photo_metadata_has_domain (PhotoMetadata* self, MetadataDomain domain) {
	gboolean result = FALSE;
	MetadataDomain _tmp0_ = 0;
#line 308 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = domain;
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	switch (_tmp0_) {
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_EXIF:
#line 2785 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp1_ = NULL;
			gboolean _tmp2_ = FALSE;
#line 311 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = self->priv->exiv2;
#line 311 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp2_ = gexiv2_metadata_has_exif (_tmp1_);
#line 311 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = _tmp2_;
#line 311 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 2797 "PhotoMetadata.c"
		}
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_XMP:
#line 2801 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
#line 314 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp3_ = self->priv->exiv2;
#line 314 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp4_ = gexiv2_metadata_has_xmp (_tmp3_);
#line 314 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = _tmp4_;
#line 314 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 2813 "PhotoMetadata.c"
		}
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_IPTC:
#line 2817 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
#line 317 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp5_ = self->priv->exiv2;
#line 317 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp6_ = gexiv2_metadata_has_iptc (_tmp5_);
#line 317 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = _tmp6_;
#line 317 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 2829 "PhotoMetadata.c"
		}
		default:
#line 309 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_UNKNOWN:
#line 2834 "PhotoMetadata.c"
		{
#line 321 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = FALSE;
#line 321 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 2840 "PhotoMetadata.c"
		}
	}
}


gboolean photo_metadata_has_exif (PhotoMetadata* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 325 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 326 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_has_domain (self, METADATA_DOMAIN_EXIF);
#line 326 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 326 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 2857 "PhotoMetadata.c"
}


gboolean photo_metadata_has_xmp (PhotoMetadata* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 329 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 330 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_has_domain (self, METADATA_DOMAIN_XMP);
#line 330 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 330 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 2872 "PhotoMetadata.c"
}


gboolean photo_metadata_has_iptc (PhotoMetadata* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 333 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 334 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_has_domain (self, METADATA_DOMAIN_IPTC);
#line 334 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 334 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 2887 "PhotoMetadata.c"
}


gboolean photo_metadata_can_write_to_domain (PhotoMetadata* self, MetadataDomain domain) {
	gboolean result = FALSE;
	MetadataDomain _tmp0_ = 0;
#line 337 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 338 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = domain;
#line 338 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	switch (_tmp0_) {
#line 338 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_EXIF:
#line 2902 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp1_ = NULL;
			gboolean _tmp2_ = FALSE;
#line 340 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = self->priv->exiv2;
#line 340 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp2_ = gexiv2_metadata_get_supports_exif (_tmp1_);
#line 340 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = _tmp2_;
#line 340 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 2914 "PhotoMetadata.c"
		}
#line 338 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_XMP:
#line 2918 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
#line 343 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp3_ = self->priv->exiv2;
#line 343 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp4_ = gexiv2_metadata_get_supports_xmp (_tmp3_);
#line 343 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = _tmp4_;
#line 343 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 2930 "PhotoMetadata.c"
		}
#line 338 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_IPTC:
#line 2934 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
#line 346 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp5_ = self->priv->exiv2;
#line 346 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp6_ = gexiv2_metadata_get_supports_iptc (_tmp5_);
#line 346 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = _tmp6_;
#line 346 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 2946 "PhotoMetadata.c"
		}
		default:
#line 338 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_UNKNOWN:
#line 2951 "PhotoMetadata.c"
		{
#line 350 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			result = FALSE;
#line 350 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			return result;
#line 2957 "PhotoMetadata.c"
		}
	}
}


gboolean photo_metadata_can_write_exif (PhotoMetadata* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 354 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 355 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_can_write_to_domain (self, METADATA_DOMAIN_EXIF);
#line 355 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 355 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 2974 "PhotoMetadata.c"
}


gboolean photo_metadata_can_write_xmp (PhotoMetadata* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 358 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 359 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_can_write_to_domain (self, METADATA_DOMAIN_XMP);
#line 359 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 359 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 2989 "PhotoMetadata.c"
}


gboolean photo_metadata_can_write_iptc (PhotoMetadata* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 362 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 363 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_can_write_to_domain (self, METADATA_DOMAIN_IPTC);
#line 363 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 363 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3004 "PhotoMetadata.c"
}


gboolean photo_metadata_has_tag (PhotoMetadata* self, const gchar* tag) {
	gboolean result = FALSE;
	GExiv2Metadata* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 366 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 366 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, FALSE);
#line 367 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 367 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = tag;
#line 367 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = gexiv2_metadata_has_tag (_tmp0_, _tmp1_);
#line 367 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp2_;
#line 367 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3027 "PhotoMetadata.c"
}


static GeeSet* photo_metadata_create_string_set (PhotoMetadata* self, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify) {
	GeeSet* result = NULL;
	GCompareDataFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
#line 370 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 372 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = compare_func;
#line 372 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__target = compare_func_target;
#line 372 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp0_ == NULL) {
#line 3043 "PhotoMetadata.c"
		GeeHashSet* _tmp1_ = NULL;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_SET, GeeSet);
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func = NULL;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func_target = NULL;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func_target_destroy_notify = NULL;
#line 373 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 3059 "PhotoMetadata.c"
	} else {
		GCompareDataFunc _tmp2_ = NULL;
		void* _tmp2__target = NULL;
		GDestroyNotify _tmp2__target_destroy_notify = NULL;
		GeeTreeSet* _tmp3_ = NULL;
#line 375 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = compare_func;
#line 375 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2__target = compare_func_target;
#line 375 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2__target_destroy_notify = compare_func_target_destroy_notify;
#line 375 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func_target_destroy_notify = NULL;
#line 375 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp2_, _tmp2__target, _tmp2__target_destroy_notify);
#line 375 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_SET, GeeSet);
#line 375 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
#line 375 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func = NULL;
#line 375 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func_target = NULL;
#line 375 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func_target_destroy_notify = NULL;
#line 375 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 3087 "PhotoMetadata.c"
	}
#line 370 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
#line 370 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func = NULL;
#line 370 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target = NULL;
#line 370 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target_destroy_notify = NULL;
#line 3097 "PhotoMetadata.c"
}


GeeCollection* photo_metadata_get_tags (PhotoMetadata* self, MetadataDomain domain, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify) {
	GeeCollection* result = NULL;
	gchar** tags = NULL;
	gint tags_length1 = 0;
	gint _tags_size_ = 0;
	MetadataDomain _tmp0_ = 0;
	gboolean _tmp10_ = FALSE;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	GeeCollection* collection = NULL;
	GCompareDataFunc _tmp13_ = NULL;
	void* _tmp13__target = NULL;
	GDestroyNotify _tmp13__target_destroy_notify = NULL;
	GeeSet* _tmp14_ = NULL;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
#line 378 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 380 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	tags = NULL;
#line 380 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	tags_length1 = 0;
#line 380 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tags_size_ = tags_length1;
#line 381 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = domain;
#line 381 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	switch (_tmp0_) {
#line 381 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_EXIF:
#line 3131 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp1_ = NULL;
			gchar** _tmp2_ = NULL;
			gchar** _tmp3_ = NULL;
#line 383 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = self->priv->exiv2;
#line 383 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp3_ = _tmp2_ = gexiv2_metadata_get_exif_tags (_tmp1_);
#line 383 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
#line 383 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags = _tmp3_;
#line 383 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags_length1 = _vala_array_length (_tmp2_);
#line 383 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tags_size_ = tags_length1;
#line 384 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 3150 "PhotoMetadata.c"
		}
#line 381 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_XMP:
#line 3154 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp4_ = NULL;
			gchar** _tmp5_ = NULL;
			gchar** _tmp6_ = NULL;
#line 387 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp4_ = self->priv->exiv2;
#line 387 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp6_ = _tmp5_ = gexiv2_metadata_get_xmp_tags (_tmp4_);
#line 387 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
#line 387 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags = _tmp6_;
#line 387 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags_length1 = _vala_array_length (_tmp5_);
#line 387 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tags_size_ = tags_length1;
#line 388 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 3173 "PhotoMetadata.c"
		}
#line 381 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_IPTC:
#line 3177 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp7_ = NULL;
			gchar** _tmp8_ = NULL;
			gchar** _tmp9_ = NULL;
#line 391 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp7_ = self->priv->exiv2;
#line 391 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp9_ = _tmp8_ = gexiv2_metadata_get_iptc_tags (_tmp7_);
#line 391 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
#line 391 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags = _tmp9_;
#line 391 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tags_length1 = _vala_array_length (_tmp8_);
#line 391 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tags_size_ = tags_length1;
#line 392 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 3196 "PhotoMetadata.c"
		}
		default:
#line 381 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		break;
#line 3201 "PhotoMetadata.c"
	}
#line 395 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = tags;
#line 395 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11__length1 = tags_length1;
#line 395 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp11_ == NULL) {
#line 395 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = TRUE;
#line 3211 "PhotoMetadata.c"
	} else {
		gchar** _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
#line 395 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp12_ = tags;
#line 395 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp12__length1 = tags_length1;
#line 395 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = _tmp12__length1 == 0;
#line 3221 "PhotoMetadata.c"
	}
#line 395 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp10_) {
#line 396 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 396 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
#line 396 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
#line 396 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func = NULL;
#line 396 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func_target = NULL;
#line 396 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		compare_func_target_destroy_notify = NULL;
#line 396 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 3239 "PhotoMetadata.c"
	}
#line 398 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13_ = compare_func;
#line 398 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13__target = compare_func_target;
#line 398 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13__target_destroy_notify = compare_func_target_destroy_notify;
#line 398 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target_destroy_notify = NULL;
#line 398 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14_ = photo_metadata_create_string_set (self, _tmp13_, _tmp13__target, _tmp13__target_destroy_notify);
#line 398 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	collection = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_COLLECTION, GeeCollection);
#line 399 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp15_ = tags;
#line 399 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp15__length1 = tags_length1;
#line 3257 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 399 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = _tmp15_;
#line 399 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = _tmp15__length1;
#line 399 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < _tmp15__length1; tag_it = tag_it + 1) {
#line 3269 "PhotoMetadata.c"
			gchar* _tmp16_ = NULL;
			gchar* tag = NULL;
#line 399 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp16_ = g_strdup (tag_collection[tag_it]);
#line 399 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp16_;
#line 3276 "PhotoMetadata.c"
			{
				GeeCollection* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
#line 400 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp17_ = collection;
#line 400 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp18_ = tag;
#line 400 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				gee_collection_add (_tmp17_, _tmp18_);
#line 399 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 3288 "PhotoMetadata.c"
			}
		}
	}
#line 402 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = collection;
#line 402 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
#line 402 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
#line 402 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func = NULL;
#line 402 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target = NULL;
#line 402 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target_destroy_notify = NULL;
#line 402 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3306 "PhotoMetadata.c"
}


GeeCollection* photo_metadata_get_all_tags (PhotoMetadata* self, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify) {
	GeeCollection* result = NULL;
	GeeCollection* all_tags = NULL;
	GCompareDataFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GDestroyNotify _tmp0__target_destroy_notify = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeCollection* exif_tags = NULL;
	GeeCollection* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_ = NULL;
	GeeCollection* xmp_tags = NULL;
	GeeCollection* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GeeCollection* _tmp12_ = NULL;
	GeeCollection* iptc_tags = NULL;
	GeeCollection* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	GeeCollection* _tmp20_ = NULL;
	GeeCollection* _tmp26_ = NULL;
	GeeCollection* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	GeeCollection* _tmp31_ = NULL;
#line 405 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = compare_func;
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__target = compare_func_target;
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__target_destroy_notify = compare_func_target_destroy_notify;
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target_destroy_notify = NULL;
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_create_string_set (self, _tmp0_, _tmp0__target, _tmp0__target_destroy_notify);
#line 407 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	all_tags = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection);
#line 409 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = photo_metadata_get_tags (self, METADATA_DOMAIN_EXIF, NULL, NULL, NULL);
#line 409 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	exif_tags = _tmp2_;
#line 410 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = exif_tags;
#line 410 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_ != NULL) {
#line 3356 "PhotoMetadata.c"
		GeeCollection* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 410 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = exif_tags;
#line 410 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = gee_collection_get_size (_tmp5_);
#line 410 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = _tmp6_;
#line 410 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = _tmp7_ > 0;
#line 3368 "PhotoMetadata.c"
	} else {
#line 410 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = FALSE;
#line 3372 "PhotoMetadata.c"
	}
#line 410 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp3_) {
#line 3376 "PhotoMetadata.c"
		GeeCollection* _tmp8_ = NULL;
		GeeCollection* _tmp9_ = NULL;
#line 411 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp8_ = all_tags;
#line 411 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = exif_tags;
#line 411 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		gee_collection_add_all (_tmp8_, _tmp9_);
#line 3385 "PhotoMetadata.c"
	}
#line 413 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = photo_metadata_get_tags (self, METADATA_DOMAIN_XMP, NULL, NULL, NULL);
#line 413 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	xmp_tags = _tmp10_;
#line 414 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12_ = xmp_tags;
#line 414 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp12_ != NULL) {
#line 3395 "PhotoMetadata.c"
		GeeCollection* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
#line 414 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp13_ = xmp_tags;
#line 414 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp14_ = gee_collection_get_size (_tmp13_);
#line 414 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp15_ = _tmp14_;
#line 414 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp11_ = _tmp15_ > 0;
#line 3407 "PhotoMetadata.c"
	} else {
#line 414 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp11_ = FALSE;
#line 3411 "PhotoMetadata.c"
	}
#line 414 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp11_) {
#line 3415 "PhotoMetadata.c"
		GeeCollection* _tmp16_ = NULL;
		GeeCollection* _tmp17_ = NULL;
#line 415 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp16_ = all_tags;
#line 415 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp17_ = xmp_tags;
#line 415 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		gee_collection_add_all (_tmp16_, _tmp17_);
#line 3424 "PhotoMetadata.c"
	}
#line 417 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp18_ = photo_metadata_get_tags (self, METADATA_DOMAIN_IPTC, NULL, NULL, NULL);
#line 417 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	iptc_tags = _tmp18_;
#line 418 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp20_ = iptc_tags;
#line 418 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp20_ != NULL) {
#line 3434 "PhotoMetadata.c"
		GeeCollection* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
#line 418 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp21_ = iptc_tags;
#line 418 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp22_ = gee_collection_get_size (_tmp21_);
#line 418 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp23_ = _tmp22_;
#line 418 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp19_ = _tmp23_ > 0;
#line 3446 "PhotoMetadata.c"
	} else {
#line 418 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp19_ = FALSE;
#line 3450 "PhotoMetadata.c"
	}
#line 418 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp19_) {
#line 3454 "PhotoMetadata.c"
		GeeCollection* _tmp24_ = NULL;
		GeeCollection* _tmp25_ = NULL;
#line 419 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp24_ = all_tags;
#line 419 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp25_ = iptc_tags;
#line 419 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		gee_collection_add_all (_tmp24_, _tmp25_);
#line 3463 "PhotoMetadata.c"
	}
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp27_ = all_tags;
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp28_ = gee_collection_get_size (_tmp27_);
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp29_ = _tmp28_;
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp29_ > 0) {
#line 3473 "PhotoMetadata.c"
		GeeCollection* _tmp30_ = NULL;
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp30_ = all_tags;
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp26_ = _tmp30_;
#line 3479 "PhotoMetadata.c"
	} else {
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp26_ = NULL;
#line 3483 "PhotoMetadata.c"
	}
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp31_ = _g_object_ref0 (_tmp26_);
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp31_;
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (iptc_tags);
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (xmp_tags);
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (exif_tags);
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (all_tags);
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func = NULL;
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target = NULL;
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target_destroy_notify = NULL;
#line 421 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3507 "PhotoMetadata.c"
}


gchar* photo_metadata_get_tag_label (PhotoMetadata* self, const gchar* tag) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 424 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 424 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 425 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tag;
#line 425 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = gexiv2_metadata_get_tag_label (_tmp0_);
#line 425 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 425 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp2_;
#line 425 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3530 "PhotoMetadata.c"
}


gchar* photo_metadata_get_tag_description (PhotoMetadata* self, const gchar* tag) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 428 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 428 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 429 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tag;
#line 429 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = gexiv2_metadata_get_tag_description (_tmp0_);
#line 429 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 429 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp2_;
#line 429 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3553 "PhotoMetadata.c"
}


gchar* photo_metadata_get_string (PhotoMetadata* self, const gchar* tag, PrepareInputTextOptions options) {
	gchar* result = NULL;
	GExiv2Metadata* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	PrepareInputTextOptions _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 432 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 432 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 433 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 433 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = tag;
#line 433 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = gexiv2_metadata_get_tag_string (_tmp0_, _tmp1_);
#line 433 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = _tmp2_;
#line 433 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = options;
#line 433 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = prepare_input_text (_tmp3_, _tmp4_, DEFAULT_USER_TEXT_INPUT_LENGTH);
#line 433 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = _tmp5_;
#line 433 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp3_);
#line 433 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp6_;
#line 433 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3590 "PhotoMetadata.c"
}


gchar* photo_metadata_get_string_interpreted (PhotoMetadata* self, const gchar* tag, PrepareInputTextOptions options) {
	gchar* result = NULL;
	GExiv2Metadata* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	PrepareInputTextOptions _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 436 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 436 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 437 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 437 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = tag;
#line 437 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = gexiv2_metadata_get_tag_interpreted_string (_tmp0_, _tmp1_);
#line 437 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = _tmp2_;
#line 437 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = options;
#line 437 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = prepare_input_text (_tmp3_, _tmp4_, DEFAULT_USER_TEXT_INPUT_LENGTH);
#line 437 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = _tmp5_;
#line 437 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp3_);
#line 437 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp6_;
#line 437 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3627 "PhotoMetadata.c"
}


gchar* photo_metadata_get_first_string (PhotoMetadata* self, gchar** tags, int tags_length1) {
	gchar* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 440 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 441 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tags;
#line 441 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = tags_length1;
#line 3641 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 441 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = _tmp0_;
#line 441 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = _tmp0__length1;
#line 441 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < _tmp0__length1; tag_it = tag_it + 1) {
#line 3653 "PhotoMetadata.c"
			gchar* _tmp1_ = NULL;
			gchar* tag = NULL;
#line 441 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = g_strdup (tag_collection[tag_it]);
#line 441 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp1_;
#line 3660 "PhotoMetadata.c"
			{
				gchar* value = NULL;
				const gchar* _tmp2_ = NULL;
				gchar* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
#line 442 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = tag;
#line 442 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = photo_metadata_get_string (self, _tmp2_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 442 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				value = _tmp3_;
#line 443 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp4_ = value;
#line 443 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp4_ != NULL) {
#line 444 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = value;
#line 444 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_free0 (tag);
#line 444 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 3682 "PhotoMetadata.c"
				}
#line 441 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (value);
#line 441 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 3688 "PhotoMetadata.c"
			}
		}
	}
#line 447 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = NULL;
#line 447 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3696 "PhotoMetadata.c"
}


gchar* photo_metadata_get_first_string_interpreted (PhotoMetadata* self, gchar** tags, int tags_length1) {
	gchar* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 450 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 451 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tags;
#line 451 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = tags_length1;
#line 3710 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 451 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = _tmp0_;
#line 451 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = _tmp0__length1;
#line 451 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < _tmp0__length1; tag_it = tag_it + 1) {
#line 3722 "PhotoMetadata.c"
			gchar* _tmp1_ = NULL;
			gchar* tag = NULL;
#line 451 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = g_strdup (tag_collection[tag_it]);
#line 451 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp1_;
#line 3729 "PhotoMetadata.c"
			{
				gchar* value = NULL;
				const gchar* _tmp2_ = NULL;
				gchar* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
#line 452 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = tag;
#line 452 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = photo_metadata_get_string_interpreted (self, _tmp2_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 452 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				value = _tmp3_;
#line 453 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp4_ = value;
#line 453 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp4_ != NULL) {
#line 454 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = value;
#line 454 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_free0 (tag);
#line 454 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 3751 "PhotoMetadata.c"
				}
#line 451 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (value);
#line 451 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 3757 "PhotoMetadata.c"
			}
		}
	}
#line 457 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = NULL;
#line 457 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3765 "PhotoMetadata.c"
}


GeeList* photo_metadata_get_string_multiple (PhotoMetadata* self, const gchar* tag) {
	GeeList* result = NULL;
	gchar** values = NULL;
	GExiv2Metadata* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	gboolean _tmp4_ = FALSE;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	GeeList* list = NULL;
	GeeArrayList* _tmp7_ = NULL;
	GeeHashSet* collection = NULL;
	GeeHashSet* _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	GeeList* _tmp22_ = NULL;
	GeeList* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	GeeList* _tmp27_ = NULL;
#line 466 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 466 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 467 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 467 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = tag;
#line 467 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = _tmp2_ = gexiv2_metadata_get_tag_multiple (_tmp0_, _tmp1_);
#line 467 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	values = _tmp3_;
#line 467 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	values_length1 = _vala_array_length (_tmp2_);
#line 467 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_values_size_ = values_length1;
#line 468 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = values;
#line 468 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5__length1 = values_length1;
#line 468 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp5_ == NULL) {
#line 468 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = TRUE;
#line 3816 "PhotoMetadata.c"
	} else {
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
#line 468 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = values;
#line 468 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6__length1 = values_length1;
#line 468 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = _tmp6__length1 == 0;
#line 3826 "PhotoMetadata.c"
	}
#line 468 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_) {
#line 469 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 469 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 469 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 3836 "PhotoMetadata.c"
	}
#line 471 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 471 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	list = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_LIST, GeeList);
#line 473 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 473 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	collection = _tmp8_;
#line 474 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = values;
#line 474 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9__length1 = values_length1;
#line 3850 "PhotoMetadata.c"
	{
		gchar** value_collection = NULL;
		gint value_collection_length1 = 0;
		gint _value_collection_size_ = 0;
		gint value_it = 0;
#line 474 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value_collection = _tmp9_;
#line 474 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		value_collection_length1 = _tmp9__length1;
#line 474 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (value_it = 0; value_it < _tmp9__length1; value_it = value_it + 1) {
#line 3862 "PhotoMetadata.c"
			gchar* _tmp10_ = NULL;
			gchar* value = NULL;
#line 474 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp10_ = g_strdup (value_collection[value_it]);
#line 474 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			value = _tmp10_;
#line 3869 "PhotoMetadata.c"
			{
				gchar* prepped = NULL;
				const gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
				const gchar* _tmp14_ = NULL;
#line 475 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp11_ = value;
#line 475 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp12_ = prepare_input_text (_tmp11_, PHOTO_METADATA_PREPARE_STRING_OPTIONS, DEFAULT_USER_TEXT_INPUT_LENGTH);
#line 475 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				prepped = _tmp12_;
#line 478 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp14_ = prepped;
#line 478 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp14_ != NULL) {
#line 3886 "PhotoMetadata.c"
					GeeHashSet* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					gboolean _tmp17_ = FALSE;
#line 478 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp15_ = collection;
#line 478 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp16_ = prepped;
#line 478 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp17_ = gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp16_);
#line 478 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp13_ = !_tmp17_;
#line 3898 "PhotoMetadata.c"
				} else {
#line 478 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp13_ = FALSE;
#line 3902 "PhotoMetadata.c"
				}
#line 478 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp13_) {
#line 3906 "PhotoMetadata.c"
					GeeList* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					GeeHashSet* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
#line 479 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp18_ = list;
#line 479 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp19_ = prepped;
#line 479 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection), _tmp19_);
#line 480 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp20_ = collection;
#line 480 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp21_ = prepped;
#line 480 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp21_);
#line 3923 "PhotoMetadata.c"
				}
#line 474 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (prepped);
#line 474 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (value);
#line 3929 "PhotoMetadata.c"
			}
		}
	}
#line 484 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp23_ = list;
#line 484 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp24_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_COLLECTION, GeeCollection));
#line 484 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp25_ = _tmp24_;
#line 484 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp25_ > 0) {
#line 3941 "PhotoMetadata.c"
		GeeList* _tmp26_ = NULL;
#line 484 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp26_ = list;
#line 484 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp22_ = _tmp26_;
#line 3947 "PhotoMetadata.c"
	} else {
#line 484 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp22_ = NULL;
#line 3951 "PhotoMetadata.c"
	}
#line 484 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp27_ = _g_object_ref0 (_tmp22_);
#line 484 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp27_;
#line 484 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (collection);
#line 484 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (list);
#line 484 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 484 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 3965 "PhotoMetadata.c"
}


GeeList* photo_metadata_get_first_string_multiple (PhotoMetadata* self, gchar** tags, int tags_length1) {
	GeeList* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 493 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 494 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tags;
#line 494 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = tags_length1;
#line 3979 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 494 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = _tmp0_;
#line 494 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = _tmp0__length1;
#line 494 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < _tmp0__length1; tag_it = tag_it + 1) {
#line 3991 "PhotoMetadata.c"
			gchar* _tmp1_ = NULL;
			gchar* tag = NULL;
#line 494 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = g_strdup (tag_collection[tag_it]);
#line 494 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp1_;
#line 3998 "PhotoMetadata.c"
			{
				GeeList* values = NULL;
				const gchar* _tmp2_ = NULL;
				GeeList* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				GeeList* _tmp5_ = NULL;
#line 495 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = tag;
#line 495 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = photo_metadata_get_string_multiple (self, _tmp2_);
#line 495 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				values = _tmp3_;
#line 496 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp5_ = values;
#line 496 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp5_ != NULL) {
#line 4015 "PhotoMetadata.c"
					GeeList* _tmp6_ = NULL;
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
#line 496 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp6_ = values;
#line 496 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp7_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
#line 496 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp8_ = _tmp7_;
#line 496 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp4_ = _tmp8_ > 0;
#line 4027 "PhotoMetadata.c"
				} else {
#line 496 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp4_ = FALSE;
#line 4031 "PhotoMetadata.c"
				}
#line 496 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp4_) {
#line 497 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = values;
#line 497 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_free0 (tag);
#line 497 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 4041 "PhotoMetadata.c"
				}
#line 494 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_object_unref0 (values);
#line 494 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 4047 "PhotoMetadata.c"
			}
		}
	}
#line 500 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = NULL;
#line 500 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 4055 "PhotoMetadata.c"
}


void photo_metadata_set_string (PhotoMetadata* self, const gchar* tag, const gchar* value, PrepareInputTextOptions options) {
	gchar* prepped = NULL;
	const gchar* _tmp0_ = NULL;
	PrepareInputTextOptions _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GExiv2Metadata* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
#line 503 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 503 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 503 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (value != NULL);
#line 504 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = value;
#line 504 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = options;
#line 504 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = prepare_input_text (_tmp0_, _tmp1_, DEFAULT_USER_TEXT_INPUT_LENGTH);
#line 504 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	prepped = _tmp2_;
#line 505 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = prepped;
#line 505 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp3_ == NULL) {
#line 4087 "PhotoMetadata.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 506 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = tag;
#line 506 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = value;
#line 506 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_warning ("PhotoMetadata.vala:506: Not setting tag %s to string %s: invalid UTF-8", _tmp4_, _tmp5_);
#line 508 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (prepped);
#line 508 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 4100 "PhotoMetadata.c"
	}
#line 511 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = self->priv->exiv2;
#line 511 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = tag;
#line 511 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = prepped;
#line 511 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = gexiv2_metadata_set_tag_string (_tmp6_, _tmp7_, _tmp8_);
#line 511 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp9_) {
#line 4112 "PhotoMetadata.c"
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
#line 512 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = tag;
#line 512 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp11_ = value;
#line 512 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp12_ = self->priv->source_name;
#line 512 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_warning ("PhotoMetadata.vala:512: Unable to set tag %s to string %s from source " \
"%s", _tmp10_, _tmp11_, _tmp12_);
#line 4124 "PhotoMetadata.c"
	}
#line 503 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (prepped);
#line 4128 "PhotoMetadata.c"
}


static void photo_metadata_set_all_generic (PhotoMetadata* self, gchar** tags, int tags_length1, PhotoMetadataSetOption option, PhotoMetadataSetGenericValue setter, void* setter_target) {
	gboolean written = FALSE;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	PhotoMetadataSetOption _tmp11_ = 0;
#line 517 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 518 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	written = FALSE;
#line 519 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tags;
#line 519 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = tags_length1;
#line 4147 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 519 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = _tmp0_;
#line 519 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = _tmp0__length1;
#line 519 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < _tmp0__length1; tag_it = tag_it + 1) {
#line 4159 "PhotoMetadata.c"
			gchar* _tmp1_ = NULL;
			gchar* tag = NULL;
#line 519 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = g_strdup (tag_collection[tag_it]);
#line 519 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp1_;
#line 4166 "PhotoMetadata.c"
			{
				gboolean _tmp2_ = FALSE;
				PhotoMetadataSetOption _tmp3_ = 0;
#line 520 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = option;
#line 520 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp3_ == PHOTO_METADATA_SET_OPTION_ALL_DOMAINS) {
#line 520 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp2_ = TRUE;
#line 4176 "PhotoMetadata.c"
				} else {
					const gchar* _tmp4_ = NULL;
					MetadataDomain _tmp5_ = 0;
					gboolean _tmp6_ = FALSE;
#line 520 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp4_ = tag;
#line 520 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp5_ = photo_metadata_get_tag_domain (_tmp4_);
#line 520 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp6_ = photo_metadata_has_domain (self, _tmp5_);
#line 520 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp2_ = _tmp6_;
#line 4189 "PhotoMetadata.c"
				}
#line 520 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp2_) {
#line 4193 "PhotoMetadata.c"
					PhotoMetadataSetGenericValue _tmp7_ = NULL;
					void* _tmp7__target = NULL;
					const gchar* _tmp8_ = NULL;
#line 521 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp7_ = setter;
#line 521 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp7__target = setter_target;
#line 521 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp8_ = tag;
#line 521 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp7_ (_tmp8_, _tmp7__target);
#line 522 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					written = TRUE;
#line 4207 "PhotoMetadata.c"
				}
#line 519 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 4211 "PhotoMetadata.c"
			}
		}
	}
#line 526 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = option;
#line 526 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp11_ == PHOTO_METADATA_SET_OPTION_AT_LEAST_DEFAULT_DOMAIN) {
#line 4219 "PhotoMetadata.c"
		gboolean _tmp12_ = FALSE;
#line 526 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp12_ = written;
#line 526 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = !_tmp12_;
#line 4225 "PhotoMetadata.c"
	} else {
#line 526 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = FALSE;
#line 4229 "PhotoMetadata.c"
	}
#line 526 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp10_) {
#line 4233 "PhotoMetadata.c"
		gchar** _tmp13_ = NULL;
		gint _tmp13__length1 = 0;
#line 526 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp13_ = tags;
#line 526 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp13__length1 = tags_length1;
#line 526 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = _tmp13__length1 > 0;
#line 4242 "PhotoMetadata.c"
	} else {
#line 526 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = FALSE;
#line 4246 "PhotoMetadata.c"
	}
#line 526 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp9_) {
#line 4250 "PhotoMetadata.c"
		MetadataDomain default_domain = 0;
		gchar** _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		const gchar* _tmp15_ = NULL;
		MetadataDomain _tmp16_ = 0;
		PhotoMetadataSetGenericValue _tmp17_ = NULL;
		void* _tmp17__target = NULL;
		gchar** _tmp18_ = NULL;
		gint _tmp18__length1 = 0;
		const gchar* _tmp19_ = NULL;
#line 527 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp14_ = tags;
#line 527 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp14__length1 = tags_length1;
#line 527 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp15_ = _tmp14_[0];
#line 527 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp16_ = photo_metadata_get_tag_domain (_tmp15_);
#line 527 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		default_domain = _tmp16_;
#line 530 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp17_ = setter;
#line 530 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp17__target = setter_target;
#line 530 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp18_ = tags;
#line 530 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp18__length1 = tags_length1;
#line 530 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp19_ = _tmp18_[0];
#line 530 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp17_ (_tmp19_, _tmp17__target);
#line 4283 "PhotoMetadata.c"
		{
			gint ctr = 0;
#line 533 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			ctr = 1;
#line 4288 "PhotoMetadata.c"
			{
				gboolean _tmp20_ = FALSE;
#line 533 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp20_ = TRUE;
#line 533 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				while (TRUE) {
#line 4295 "PhotoMetadata.c"
					gint _tmp22_ = 0;
					gchar** _tmp23_ = NULL;
					gint _tmp23__length1 = 0;
					gchar** _tmp24_ = NULL;
					gint _tmp24__length1 = 0;
					gint _tmp25_ = 0;
					const gchar* _tmp26_ = NULL;
					MetadataDomain _tmp27_ = 0;
					MetadataDomain _tmp28_ = 0;
#line 533 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					if (!_tmp20_) {
#line 4307 "PhotoMetadata.c"
						gint _tmp21_ = 0;
#line 533 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp21_ = ctr;
#line 533 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						ctr = _tmp21_ + 1;
#line 4313 "PhotoMetadata.c"
					}
#line 533 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp20_ = FALSE;
#line 533 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp22_ = ctr;
#line 533 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp23_ = tags;
#line 533 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp23__length1 = tags_length1;
#line 533 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					if (!(_tmp22_ < _tmp23__length1)) {
#line 533 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						break;
#line 4327 "PhotoMetadata.c"
					}
#line 534 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp24_ = tags;
#line 534 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp24__length1 = tags_length1;
#line 534 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp25_ = ctr;
#line 534 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp26_ = _tmp24_[_tmp25_];
#line 534 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp27_ = photo_metadata_get_tag_domain (_tmp26_);
#line 534 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp28_ = default_domain;
#line 534 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					if (_tmp27_ == _tmp28_) {
#line 4343 "PhotoMetadata.c"
						PhotoMetadataSetGenericValue _tmp29_ = NULL;
						void* _tmp29__target = NULL;
						gchar** _tmp30_ = NULL;
						gint _tmp30__length1 = 0;
						gint _tmp31_ = 0;
						const gchar* _tmp32_ = NULL;
#line 535 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp29_ = setter;
#line 535 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp29__target = setter_target;
#line 535 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp30_ = tags;
#line 535 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp30__length1 = tags_length1;
#line 535 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp31_ = ctr;
#line 535 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp32_ = _tmp30_[_tmp31_];
#line 535 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp29_ (_tmp32_, _tmp29__target);
#line 4364 "PhotoMetadata.c"
					}
				}
			}
		}
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 540 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 540 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return _data1_;
#line 4378 "PhotoMetadata.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 540 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 4387 "PhotoMetadata.c"
		PhotoMetadata* self;
#line 540 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		self = _data1_->self;
#line 540 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_data1_->value);
#line 540 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_media_metadata_unref0 (self);
#line 540 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_slice_free (Block1Data, _data1_);
#line 4397 "PhotoMetadata.c"
	}
}


static void __lambda5_ (Block1Data* _data1_, const gchar* tag) {
	PhotoMetadata* self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 541 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = _data1_->self;
#line 541 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 541 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tag;
#line 541 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = _data1_->value;
#line 541 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_string (self, _tmp0_, _tmp1_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 4416 "PhotoMetadata.c"
}


static void ___lambda5__photo_metadata_set_generic_value (const gchar* tag, gpointer self) {
#line 541 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	__lambda5_ (self, tag);
#line 4423 "PhotoMetadata.c"
}


void photo_metadata_set_all_string (PhotoMetadata* self, gchar** tags, int tags_length1, const gchar* value, PhotoMetadataSetOption option) {
	Block1Data* _data1_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	PhotoMetadataSetOption _tmp3_ = 0;
#line 540 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 540 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (value != NULL);
#line 540 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 540 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data1_->_ref_count_ = 1;
#line 540 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data1_->self = media_metadata_ref (self);
#line 540 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = value;
#line 540 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 540 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_data1_->value);
#line 540 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data1_->value = _tmp1_;
#line 541 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = tags;
#line 541 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2__length1 = tags_length1;
#line 541 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = option;
#line 541 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_all_generic (self, _tmp2_, _tmp2__length1, _tmp3_, ___lambda5__photo_metadata_set_generic_value, _data1_);
#line 540 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	block1_data_unref (_data1_);
#line 540 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data1_ = NULL;
#line 4464 "PhotoMetadata.c"
}


static void _vala_array_add45 (gchar*** array, int* length, int* size, gchar* value) {
#line 549 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if ((*length) == (*size)) {
#line 549 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 549 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 4475 "PhotoMetadata.c"
	}
#line 549 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(*array)[(*length)++] = value;
#line 549 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(*array)[*length] = NULL;
#line 4481 "PhotoMetadata.c"
}


static void _vala_array_add46 (gchar*** array, int* length, int* size, gchar* value) {
#line 561 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if ((*length) == (*size)) {
#line 561 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 561 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 4492 "PhotoMetadata.c"
	}
#line 561 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(*array)[(*length)++] = value;
#line 561 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(*array)[*length] = NULL;
#line 4498 "PhotoMetadata.c"
}


void photo_metadata_set_string_multiple (PhotoMetadata* self, const gchar* tag, GeeCollection* collection) {
	gchar** values = NULL;
	gchar** _tmp0_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	GExiv2Metadata* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	gboolean _tmp20_ = FALSE;
#line 544 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 544 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 544 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (GEE_IS_COLLECTION (collection));
#line 545 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 545 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	values = _tmp0_;
#line 545 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	values_length1 = 0;
#line 545 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_values_size_ = values_length1;
#line 4530 "PhotoMetadata.c"
	{
		GeeIterator* _value_it = NULL;
		GeeCollection* _tmp1_ = NULL;
		GeeIterator* _tmp2_ = NULL;
#line 546 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = collection;
#line 546 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 546 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_value_it = _tmp2_;
#line 546 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		while (TRUE) {
#line 4543 "PhotoMetadata.c"
			GeeIterator* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
			gchar* value = NULL;
			GeeIterator* _tmp5_ = NULL;
			gpointer _tmp6_ = NULL;
			gchar* prepped = NULL;
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
#line 546 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp3_ = _value_it;
#line 546 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp4_ = gee_iterator_next (_tmp3_);
#line 546 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			if (!_tmp4_) {
#line 546 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				break;
#line 4561 "PhotoMetadata.c"
			}
#line 546 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp5_ = _value_it;
#line 546 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 546 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			value = (gchar*) _tmp6_;
#line 547 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp7_ = value;
#line 547 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp8_ = prepare_input_text (_tmp7_, PHOTO_METADATA_PREPARE_STRING_OPTIONS, -1);
#line 547 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			prepped = _tmp8_;
#line 548 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp9_ = prepped;
#line 548 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			if (_tmp9_ != NULL) {
#line 4579 "PhotoMetadata.c"
				gchar** _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				const gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
#line 549 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp10_ = values;
#line 549 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp10__length1 = values_length1;
#line 549 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp11_ = prepped;
#line 549 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp12_ = g_strdup (_tmp11_);
#line 549 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_vala_array_add45 (&values, &values_length1, &_values_size_, _tmp12_);
#line 4594 "PhotoMetadata.c"
			} else {
				const gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
#line 551 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp13_ = value;
#line 551 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp14_ = tag;
#line 551 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				g_warning ("PhotoMetadata.vala:551: Unable to set string %s to %s: invalid UTF-8", _tmp13_, _tmp14_);
#line 4604 "PhotoMetadata.c"
			}
#line 546 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_g_free0 (prepped);
#line 546 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_g_free0 (value);
#line 4610 "PhotoMetadata.c"
		}
#line 546 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_object_unref0 (_value_it);
#line 4614 "PhotoMetadata.c"
	}
#line 554 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp15_ = values;
#line 554 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp15__length1 = values_length1;
#line 554 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp15__length1 == 0) {
#line 555 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 555 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 4626 "PhotoMetadata.c"
	}
#line 561 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp16_ = values;
#line 561 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp16__length1 = values_length1;
#line 561 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_array_add46 (&values, &values_length1, &_values_size_, NULL);
#line 563 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp17_ = self->priv->exiv2;
#line 563 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp18_ = tag;
#line 563 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp19_ = values;
#line 563 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp19__length1 = values_length1;
#line 563 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp20_ = gexiv2_metadata_set_tag_multiple (_tmp17_, _tmp18_, _tmp19_);
#line 563 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp20_) {
#line 4646 "PhotoMetadata.c"
		gchar** _tmp21_ = NULL;
		gint _tmp21__length1 = 0;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
#line 564 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp21_ = values;
#line 564 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp21__length1 = values_length1;
#line 564 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp22_ = tag;
#line 564 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp23_ = self->priv->source_name;
#line 564 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_warning ("PhotoMetadata.vala:564: Unable to set %d strings to tag %s from source" \
" %s", _tmp21__length1, _tmp22_, _tmp23_);
#line 4661 "PhotoMetadata.c"
	}
#line 544 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 4665 "PhotoMetadata.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 567 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 567 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return _data2_;
#line 4674 "PhotoMetadata.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 567 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 4683 "PhotoMetadata.c"
		PhotoMetadata* self;
#line 567 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		self = _data2_->self;
#line 567 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_object_unref0 (_data2_->values);
#line 567 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_media_metadata_unref0 (self);
#line 567 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_slice_free (Block2Data, _data2_);
#line 4693 "PhotoMetadata.c"
	}
}


static void __lambda6_ (Block2Data* _data2_, const gchar* tag) {
	PhotoMetadata* self;
	const gchar* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
#line 568 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = _data2_->self;
#line 568 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 568 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tag;
#line 568 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = _data2_->values;
#line 568 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_string_multiple (self, _tmp0_, _tmp1_);
#line 4712 "PhotoMetadata.c"
}


static void ___lambda6__photo_metadata_set_generic_value (const gchar* tag, gpointer self) {
#line 568 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	__lambda6_ (self, tag);
#line 4719 "PhotoMetadata.c"
}


void photo_metadata_set_all_string_multiple (PhotoMetadata* self, gchar** tags, int tags_length1, GeeCollection* values, PhotoMetadataSetOption option) {
	Block2Data* _data2_;
	GeeCollection* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	PhotoMetadataSetOption _tmp3_ = 0;
#line 567 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 567 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (GEE_IS_COLLECTION (values));
#line 567 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 567 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data2_->_ref_count_ = 1;
#line 567 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data2_->self = media_metadata_ref (self);
#line 567 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = values;
#line 567 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 567 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (_data2_->values);
#line 567 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data2_->values = _tmp1_;
#line 568 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = tags;
#line 568 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2__length1 = tags_length1;
#line 568 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = option;
#line 568 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_all_generic (self, _tmp2_, _tmp2__length1, _tmp3_, ___lambda6__photo_metadata_set_generic_value, _data2_);
#line 567 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	block2_data_unref (_data2_);
#line 567 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data2_ = NULL;
#line 4760 "PhotoMetadata.c"
}


gboolean photo_metadata_get_long (PhotoMetadata* self, const gchar* tag, glong* value) {
	glong _vala_value = 0L;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GExiv2Metadata* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	glong _tmp4_ = 0L;
#line 571 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 571 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, FALSE);
#line 572 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tag;
#line 572 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_has_tag (self, _tmp0_);
#line 572 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp1_) {
#line 573 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_vala_value = (glong) 0;
#line 575 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = FALSE;
#line 575 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (value) {
#line 575 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*value = _vala_value;
#line 4790 "PhotoMetadata.c"
		}
#line 575 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 4794 "PhotoMetadata.c"
	}
#line 578 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = self->priv->exiv2;
#line 578 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = tag;
#line 578 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = gexiv2_metadata_get_tag_long (_tmp2_, _tmp3_);
#line 578 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_value = _tmp4_;
#line 580 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = TRUE;
#line 580 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (value) {
#line 580 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*value = _vala_value;
#line 4810 "PhotoMetadata.c"
	}
#line 580 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 4814 "PhotoMetadata.c"
}


gboolean photo_metadata_get_first_long (PhotoMetadata* self, gchar** tags, int tags_length1, glong* value) {
	glong _vala_value = 0L;
	gboolean result = FALSE;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 583 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 584 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tags;
#line 584 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = tags_length1;
#line 4829 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 584 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = _tmp0_;
#line 584 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = _tmp0__length1;
#line 584 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < _tmp0__length1; tag_it = tag_it + 1) {
#line 4841 "PhotoMetadata.c"
			gchar* _tmp1_ = NULL;
			gchar* tag = NULL;
#line 584 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = g_strdup (tag_collection[tag_it]);
#line 584 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp1_;
#line 4848 "PhotoMetadata.c"
			{
				const gchar* _tmp2_ = NULL;
				glong _tmp3_ = 0L;
				gboolean _tmp4_ = FALSE;
#line 585 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = tag;
#line 585 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp4_ = photo_metadata_get_long (self, _tmp2_, &_tmp3_);
#line 585 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_vala_value = _tmp3_;
#line 585 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp4_) {
#line 586 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = TRUE;
#line 586 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_free0 (tag);
#line 586 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					if (value) {
#line 586 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						*value = _vala_value;
#line 4869 "PhotoMetadata.c"
					}
#line 586 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 4873 "PhotoMetadata.c"
				}
#line 584 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 4877 "PhotoMetadata.c"
			}
		}
	}
#line 589 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_value = (glong) 0;
#line 591 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = FALSE;
#line 591 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (value) {
#line 591 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*value = _vala_value;
#line 4889 "PhotoMetadata.c"
	}
#line 591 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 4893 "PhotoMetadata.c"
}


void photo_metadata_set_long (PhotoMetadata* self, const gchar* tag, glong value) {
	GExiv2Metadata* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	glong _tmp2_ = 0L;
	gboolean _tmp3_ = FALSE;
#line 594 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 594 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 595 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 595 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = tag;
#line 595 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = value;
#line 595 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = gexiv2_metadata_set_tag_long (_tmp0_, _tmp1_, _tmp2_);
#line 595 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp3_) {
#line 4916 "PhotoMetadata.c"
		const gchar* _tmp4_ = NULL;
		glong _tmp5_ = 0L;
		const gchar* _tmp6_ = NULL;
#line 596 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = tag;
#line 596 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = value;
#line 596 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = self->priv->source_name;
#line 596 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_warning ("PhotoMetadata.vala:596: Unable to set tag %s to long %ld from source %" \
"s", _tmp4_, _tmp5_, _tmp6_);
#line 4928 "PhotoMetadata.c"
	}
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 599 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 599 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return _data3_;
#line 4938 "PhotoMetadata.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 599 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 4947 "PhotoMetadata.c"
		PhotoMetadata* self;
#line 599 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		self = _data3_->self;
#line 599 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_media_metadata_unref0 (self);
#line 599 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_slice_free (Block3Data, _data3_);
#line 4955 "PhotoMetadata.c"
	}
}


static void __lambda7_ (Block3Data* _data3_, const gchar* tag) {
	PhotoMetadata* self;
	const gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
#line 600 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = _data3_->self;
#line 600 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 600 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tag;
#line 600 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = _data3_->value;
#line 600 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_long (self, _tmp0_, _tmp1_);
#line 4974 "PhotoMetadata.c"
}


static void ___lambda7__photo_metadata_set_generic_value (const gchar* tag, gpointer self) {
#line 600 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	__lambda7_ (self, tag);
#line 4981 "PhotoMetadata.c"
}


void photo_metadata_set_all_long (PhotoMetadata* self, gchar** tags, int tags_length1, glong value, PhotoMetadataSetOption option) {
	Block3Data* _data3_;
	glong _tmp0_ = 0L;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	PhotoMetadataSetOption _tmp2_ = 0;
#line 599 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 599 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 599 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data3_->_ref_count_ = 1;
#line 599 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data3_->self = media_metadata_ref (self);
#line 599 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = value;
#line 599 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data3_->value = _tmp0_;
#line 600 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = tags;
#line 600 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1__length1 = tags_length1;
#line 600 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = option;
#line 600 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_all_generic (self, _tmp1_, _tmp1__length1, _tmp2_, ___lambda7__photo_metadata_set_generic_value, _data3_);
#line 599 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	block3_data_unref (_data3_);
#line 599 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data3_ = NULL;
#line 5015 "PhotoMetadata.c"
}


gboolean photo_metadata_get_rational (PhotoMetadata* self, const gchar* tag, MetadataRational* rational) {
	MetadataRational _vala_rational = {0};
	gboolean result = FALSE;
	gint numerator = 0;
	gint denominator = 0;
	gboolean _result_ = FALSE;
	GExiv2Metadata* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
#line 603 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 603 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, FALSE);
#line 605 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 605 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = tag;
#line 605 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = gexiv2_metadata_get_exif_tag_rational (_tmp0_, _tmp1_, &_tmp2_, &_tmp3_);
#line 605 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	numerator = _tmp2_;
#line 605 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	denominator = _tmp3_;
#line 605 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_result_ = _tmp4_;
#line 607 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	metadata_rational_init (&_vala_rational, numerator, denominator);
#line 609 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _result_;
#line 609 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (rational) {
#line 609 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*rational = _vala_rational;
#line 5054 "PhotoMetadata.c"
	}
#line 609 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 5058 "PhotoMetadata.c"
}


gboolean photo_metadata_get_first_rational (PhotoMetadata* self, gchar** tags, int tags_length1, MetadataRational* rational) {
	MetadataRational _vala_rational = {0};
	gboolean result = FALSE;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 612 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 613 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tags;
#line 613 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = tags_length1;
#line 5073 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 613 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = _tmp0_;
#line 613 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = _tmp0__length1;
#line 613 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < _tmp0__length1; tag_it = tag_it + 1) {
#line 5085 "PhotoMetadata.c"
			gchar* _tmp1_ = NULL;
			gchar* tag = NULL;
#line 613 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = g_strdup (tag_collection[tag_it]);
#line 613 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp1_;
#line 5092 "PhotoMetadata.c"
			{
				const gchar* _tmp2_ = NULL;
				MetadataRational _tmp3_ = {0};
				gboolean _tmp4_ = FALSE;
#line 614 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = tag;
#line 614 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp4_ = photo_metadata_get_rational (self, _tmp2_, &_tmp3_);
#line 614 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_vala_rational = _tmp3_;
#line 614 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp4_) {
#line 615 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = TRUE;
#line 615 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_free0 (tag);
#line 615 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					if (rational) {
#line 615 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						*rational = _vala_rational;
#line 5113 "PhotoMetadata.c"
					}
#line 615 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 5117 "PhotoMetadata.c"
				}
#line 613 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 5121 "PhotoMetadata.c"
			}
		}
	}
#line 618 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	metadata_rational_init (&_vala_rational, 0, 0);
#line 620 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = FALSE;
#line 620 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (rational) {
#line 620 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*rational = _vala_rational;
#line 5133 "PhotoMetadata.c"
	}
#line 620 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 5137 "PhotoMetadata.c"
}


void photo_metadata_set_rational (PhotoMetadata* self, const gchar* tag, MetadataRational* rational) {
	GExiv2Metadata* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	MetadataRational _tmp2_ = {0};
	gint _tmp3_ = 0;
	MetadataRational _tmp4_ = {0};
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
#line 623 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 623 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 623 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (rational != NULL);
#line 624 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 624 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = tag;
#line 624 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = *rational;
#line 624 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = _tmp2_.numerator;
#line 624 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = *rational;
#line 624 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = _tmp4_.denominator;
#line 624 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = gexiv2_metadata_set_exif_tag_rational (_tmp0_, _tmp1_, _tmp3_, _tmp5_);
#line 624 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp6_) {
#line 5171 "PhotoMetadata.c"
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 625 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = tag;
#line 625 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp8_ = metadata_rational_to_string (rational);
#line 625 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = _tmp8_;
#line 625 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = self->priv->source_name;
#line 625 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_warning ("PhotoMetadata.vala:625: Unable to set tag %s to rational %s from sourc" \
"e %s", _tmp7_, _tmp9_, _tmp10_);
#line 625 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_tmp9_);
#line 5188 "PhotoMetadata.c"
	}
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return _data4_;
#line 5198 "PhotoMetadata.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 5207 "PhotoMetadata.c"
		PhotoMetadata* self;
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		self = _data4_->self;
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_media_metadata_unref0 (self);
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_slice_free (Block4Data, _data4_);
#line 5215 "PhotoMetadata.c"
	}
}


static void __lambda8_ (Block4Data* _data4_, const gchar* tag) {
	PhotoMetadata* self;
	const gchar* _tmp0_ = NULL;
	MetadataRational _tmp1_ = {0};
#line 631 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = _data4_->self;
#line 631 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 631 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tag;
#line 631 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = _data4_->rational;
#line 631 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_rational (self, _tmp0_, &_tmp1_);
#line 5234 "PhotoMetadata.c"
}


static void ___lambda8__photo_metadata_set_generic_value (const gchar* tag, gpointer self) {
#line 631 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	__lambda8_ (self, tag);
#line 5241 "PhotoMetadata.c"
}


void photo_metadata_set_all_rational (PhotoMetadata* self, gchar** tags, int tags_length1, MetadataRational* rational, PhotoMetadataSetOption option) {
	Block4Data* _data4_;
	MetadataRational _tmp0_ = {0};
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	PhotoMetadataSetOption _tmp2_ = 0;
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (rational != NULL);
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data4_->_ref_count_ = 1;
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data4_->self = media_metadata_ref (self);
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = *rational;
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data4_->rational = _tmp0_;
#line 631 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = tags;
#line 631 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1__length1 = tags_length1;
#line 631 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = option;
#line 631 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_all_generic (self, _tmp1_, _tmp1__length1, _tmp2_, ___lambda8__photo_metadata_set_generic_value, _data4_);
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	block4_data_unref (_data4_);
#line 630 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data4_ = NULL;
#line 5277 "PhotoMetadata.c"
}


MetadataDateTime* photo_metadata_get_date_time (PhotoMetadata* self, const gchar* tag) {
	MetadataDateTime* result = NULL;
	gchar* value = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 634 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 634 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 635 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tag;
#line 635 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_string (self, _tmp0_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 635 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	value = _tmp1_;
#line 636 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = value;
#line 636 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp2_ == NULL) {
#line 637 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 637 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (value);
#line 637 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 5308 "PhotoMetadata.c"
	}
	{
		const gchar* _tmp3_ = NULL;
		MetadataDomain _tmp4_ = 0;
#line 640 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = tag;
#line 640 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = photo_metadata_get_tag_domain (_tmp3_);
#line 640 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		switch (_tmp4_) {
#line 640 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			case METADATA_DOMAIN_XMP:
#line 5321 "PhotoMetadata.c"
			{
				MetadataDateTime* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				MetadataDateTime* _tmp7_ = NULL;
				MetadataDateTime* _tmp8_ = NULL;
#line 642 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp6_ = value;
#line 642 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp7_ = metadata_date_time_new_from_xmp (_tmp6_, &_inner_error_);
#line 642 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp5_ = _tmp7_;
#line 642 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5335 "PhotoMetadata.c"
					goto __catch26_g_error;
				}
#line 642 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp8_ = _tmp5_;
#line 642 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp5_ = NULL;
#line 642 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				result = _tmp8_;
#line 642 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_metadata_date_time_unref0 (_tmp5_);
#line 642 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (value);
#line 642 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				return result;
#line 5350 "PhotoMetadata.c"
			}
#line 640 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			case METADATA_DOMAIN_IPTC:
#line 5354 "PhotoMetadata.c"
			{
#line 647 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				result = NULL;
#line 647 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (value);
#line 647 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				return result;
#line 5362 "PhotoMetadata.c"
			}
			default:
#line 640 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			case METADATA_DOMAIN_EXIF:
#line 5367 "PhotoMetadata.c"
			{
				MetadataDateTime* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				MetadataDateTime* _tmp11_ = NULL;
				MetadataDateTime* _tmp12_ = NULL;
#line 651 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp10_ = value;
#line 651 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp11_ = metadata_date_time_new_from_exif (_tmp10_, &_inner_error_);
#line 651 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp9_ = _tmp11_;
#line 651 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5381 "PhotoMetadata.c"
					goto __catch26_g_error;
				}
#line 651 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp12_ = _tmp9_;
#line 651 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp9_ = NULL;
#line 651 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				result = _tmp12_;
#line 651 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_metadata_date_time_unref0 (_tmp9_);
#line 651 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (value);
#line 651 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				return result;
#line 5396 "PhotoMetadata.c"
			}
		}
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
#line 639 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		err = _inner_error_;
#line 639 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_inner_error_ = NULL;
#line 654 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp13_ = tag;
#line 654 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp14_ = self->priv->source_name;
#line 654 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp15_ = err;
#line 654 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp16_ = _tmp15_->message;
#line 654 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_warning ("PhotoMetadata.vala:654: Unable to read date/time %s from source %s: %s", _tmp13_, _tmp14_, _tmp16_);
#line 656 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 656 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_error_free0 (err);
#line 656 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (value);
#line 656 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 5430 "PhotoMetadata.c"
	}
	__finally26:
#line 639 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (value);
#line 639 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 639 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_clear_error (&_inner_error_);
#line 639 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return NULL;
#line 5441 "PhotoMetadata.c"
}


MetadataDateTime* photo_metadata_get_first_date_time (PhotoMetadata* self, gchar** tags, int tags_length1) {
	MetadataDateTime* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 660 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 661 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tags;
#line 661 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = tags_length1;
#line 5455 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 661 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = _tmp0_;
#line 661 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = _tmp0__length1;
#line 661 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < _tmp0__length1; tag_it = tag_it + 1) {
#line 5467 "PhotoMetadata.c"
			gchar* _tmp1_ = NULL;
			gchar* tag = NULL;
#line 661 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = g_strdup (tag_collection[tag_it]);
#line 661 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp1_;
#line 5474 "PhotoMetadata.c"
			{
				MetadataDateTime* date_time = NULL;
				const gchar* _tmp2_ = NULL;
				MetadataDateTime* _tmp3_ = NULL;
				MetadataDateTime* _tmp4_ = NULL;
#line 662 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = tag;
#line 662 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = photo_metadata_get_date_time (self, _tmp2_);
#line 662 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				date_time = _tmp3_;
#line 663 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp4_ = date_time;
#line 663 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp4_ != NULL) {
#line 664 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = date_time;
#line 664 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_free0 (tag);
#line 664 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 5496 "PhotoMetadata.c"
				}
#line 661 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_metadata_date_time_unref0 (date_time);
#line 661 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 5502 "PhotoMetadata.c"
			}
		}
	}
#line 667 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = NULL;
#line 667 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 5510 "PhotoMetadata.c"
}


void photo_metadata_set_date_time (PhotoMetadata* self, const gchar* tag, MetadataDateTime* date_time) {
	const gchar* _tmp0_ = NULL;
	MetadataDomain _tmp1_ = 0;
#line 670 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 670 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 670 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_METADATA_DATE_TIME (date_time));
#line 671 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tag;
#line 671 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_tag_domain (_tmp0_);
#line 671 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	switch (_tmp1_) {
#line 671 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_EXIF:
#line 5531 "PhotoMetadata.c"
		{
			const gchar* _tmp2_ = NULL;
			MetadataDateTime* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
#line 673 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp2_ = tag;
#line 673 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp3_ = date_time;
#line 673 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp4_ = metadata_date_time_get_exif_label (_tmp3_);
#line 673 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp5_ = _tmp4_;
#line 673 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			photo_metadata_set_string (self, _tmp2_, _tmp5_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 673 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_g_free0 (_tmp5_);
#line 674 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 5551 "PhotoMetadata.c"
		}
#line 671 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_XMP:
#line 5555 "PhotoMetadata.c"
		{
			const gchar* _tmp6_ = NULL;
			MetadataDateTime* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
#line 677 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp6_ = tag;
#line 677 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp7_ = date_time;
#line 677 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp8_ = metadata_date_time_get_xmp_label (_tmp7_);
#line 677 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp9_ = _tmp8_;
#line 677 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			photo_metadata_set_string (self, _tmp6_, _tmp9_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 677 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_g_free0 (_tmp9_);
#line 678 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 5575 "PhotoMetadata.c"
		}
		default:
#line 671 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_IPTC:
#line 5580 "PhotoMetadata.c"
		{
			const gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			MetadataDomain _tmp13_ = 0;
			GEnumValue* _tmp14_;
#line 683 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp10_ = tag;
#line 683 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp11_ = self->priv->source_name;
#line 683 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp12_ = tag;
#line 683 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp13_ = photo_metadata_get_tag_domain (_tmp12_);
#line 684 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp14_ = g_enum_get_value (g_type_class_ref (TYPE_METADATA_DOMAIN), _tmp13_);
#line 683 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			g_warning ("PhotoMetadata.vala:683: Cannot set date/time for %s from source %s: un" \
"supported metadata domain %s", _tmp10_, _tmp11_, (_tmp14_ != NULL) ? _tmp14_->value_name : NULL);
#line 685 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 5601 "PhotoMetadata.c"
		}
	}
}


static gpointer _metadata_date_time_ref0 (gpointer self) {
#line 689 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self ? metadata_date_time_ref (self) : NULL;
#line 5610 "PhotoMetadata.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 689 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 689 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return _data5_;
#line 5619 "PhotoMetadata.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 689 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 5628 "PhotoMetadata.c"
		PhotoMetadata* self;
#line 689 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		self = _data5_->self;
#line 689 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_metadata_date_time_unref0 (_data5_->date_time);
#line 689 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_media_metadata_unref0 (self);
#line 689 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		g_slice_free (Block5Data, _data5_);
#line 5638 "PhotoMetadata.c"
	}
}


static void __lambda9_ (Block5Data* _data5_, const gchar* tag) {
	PhotoMetadata* self;
	const gchar* _tmp0_ = NULL;
	MetadataDateTime* _tmp1_ = NULL;
#line 690 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = _data5_->self;
#line 690 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 690 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tag;
#line 690 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = _data5_->date_time;
#line 690 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_date_time (self, _tmp0_, _tmp1_);
#line 5657 "PhotoMetadata.c"
}


static void ___lambda9__photo_metadata_set_generic_value (const gchar* tag, gpointer self) {
#line 690 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	__lambda9_ (self, tag);
#line 5664 "PhotoMetadata.c"
}


void photo_metadata_set_all_date_time (PhotoMetadata* self, gchar** tags, int tags_length1, MetadataDateTime* date_time, PhotoMetadataSetOption option) {
	Block5Data* _data5_;
	MetadataDateTime* _tmp0_ = NULL;
	MetadataDateTime* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	PhotoMetadataSetOption _tmp3_ = 0;
#line 689 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 689 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_METADATA_DATE_TIME (date_time));
#line 689 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 689 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data5_->_ref_count_ = 1;
#line 689 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data5_->self = media_metadata_ref (self);
#line 689 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = date_time;
#line 689 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = _metadata_date_time_ref0 (_tmp0_);
#line 689 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_metadata_date_time_unref0 (_data5_->date_time);
#line 689 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data5_->date_time = _tmp1_;
#line 690 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = tags;
#line 690 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2__length1 = tags_length1;
#line 690 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = option;
#line 690 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_all_generic (self, _tmp2_, _tmp2__length1, _tmp3_, ___lambda9__photo_metadata_set_generic_value, _data5_);
#line 689 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	block5_data_unref (_data5_);
#line 689 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_data5_ = NULL;
#line 5705 "PhotoMetadata.c"
}


guint8* photo_metadata_flatten_exif (PhotoMetadata* self, gboolean include_preview, int* result_length1) {
	guint8* result = NULL;
	ExifData* _tmp0_ = NULL;
	guchar* thumbnail = NULL;
	ExifData* _tmp2_ = NULL;
	guchar* _tmp3_ = NULL;
	guint thumbnail_size = 0U;
	ExifData* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	gboolean _tmp6_ = FALSE;
	guint8* flattened = NULL;
	gint flattened_length1 = 0;
	gint _flattened_size_ = 0;
	guchar* saved_data = NULL;
	guint saved_size = 0U;
	ExifData* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	guint _tmp11_ = 0U;
	ExifData* _tmp21_ = NULL;
	guchar* _tmp22_ = NULL;
	ExifData* _tmp23_ = NULL;
	guint _tmp24_ = 0U;
	guint8* _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
#line 694 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 695 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exif;
#line 695 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp0_ == NULL) {
#line 5739 "PhotoMetadata.c"
		guint8* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
#line 696 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = NULL;
#line 696 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1__length1 = 0;
#line 696 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (result_length1) {
#line 696 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*result_length1 = _tmp1__length1;
#line 5750 "PhotoMetadata.c"
		}
#line 696 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = _tmp1_;
#line 696 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 5756 "PhotoMetadata.c"
	}
#line 700 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = self->priv->exif;
#line 700 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = _tmp2_->data;
#line 700 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	thumbnail = _tmp3_;
#line 701 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = self->priv->exif;
#line 701 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = _tmp4_->size;
#line 701 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	thumbnail_size = _tmp5_;
#line 702 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = include_preview;
#line 702 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp6_) {
#line 5774 "PhotoMetadata.c"
		ExifData* _tmp7_ = NULL;
		ExifData* _tmp8_ = NULL;
#line 703 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = self->priv->exif;
#line 703 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_->data = NULL;
#line 704 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp8_ = self->priv->exif;
#line 704 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp8_->size = (guint) 0;
#line 5785 "PhotoMetadata.c"
	}
#line 707 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	flattened = NULL;
#line 707 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	flattened_length1 = 0;
#line 707 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_flattened_size_ = flattened_length1;
#line 710 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	saved_data = NULL;
#line 711 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	saved_size = (guint) 0;
#line 712 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = self->priv->exif;
#line 712 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	exif_data_save_data (_tmp9_, &saved_data, &saved_size);
#line 713 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = saved_size;
#line 713 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp11_ > ((guint) 0)) {
#line 5805 "PhotoMetadata.c"
		guchar* _tmp12_ = NULL;
#line 713 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp12_ = saved_data;
#line 713 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = _tmp12_ != NULL;
#line 5811 "PhotoMetadata.c"
	} else {
#line 713 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = FALSE;
#line 5815 "PhotoMetadata.c"
	}
#line 713 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp10_) {
#line 5819 "PhotoMetadata.c"
		guint _tmp13_ = 0U;
		guint8* _tmp14_ = NULL;
		guint8* _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		guchar* _tmp16_ = NULL;
		guint _tmp17_ = 0U;
		ExifMem* _tmp18_ = NULL;
		ExifMem* _tmp19_ = NULL;
		guchar* _tmp20_ = NULL;
#line 714 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp13_ = saved_size;
#line 714 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp14_ = g_new0 (guint8, _tmp13_);
#line 714 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		flattened = (g_free (flattened), NULL);
#line 714 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		flattened = _tmp14_;
#line 714 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		flattened_length1 = _tmp13_;
#line 714 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_flattened_size_ = flattened_length1;
#line 715 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp15_ = flattened;
#line 715 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp15__length1 = flattened_length1;
#line 715 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp16_ = saved_data;
#line 715 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp17_ = saved_size;
#line 715 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		memcpy (_tmp15_, _tmp16_, (gsize) _tmp17_);
#line 717 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp18_ = exif_mem_new_default ();
#line 717 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp19_ = _tmp18_;
#line 717 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp20_ = saved_data;
#line 717 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		exif_mem_free (_tmp19_, _tmp20_);
#line 717 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_exif_mem_unref0 (_tmp19_);
#line 5861 "PhotoMetadata.c"
	}
#line 721 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp21_ = self->priv->exif;
#line 721 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp22_ = thumbnail;
#line 721 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp21_->data = _tmp22_;
#line 722 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp23_ = self->priv->exif;
#line 722 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp24_ = thumbnail_size;
#line 722 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp23_->size = _tmp24_;
#line 724 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp25_ = flattened;
#line 724 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp25__length1 = flattened_length1;
#line 724 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (result_length1) {
#line 724 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*result_length1 = _tmp25__length1;
#line 5883 "PhotoMetadata.c"
	}
#line 724 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp25_;
#line 724 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 5889 "PhotoMetadata.c"
}


static guint8* _vala_array_dup5 (guint8* self, int length) {
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 5896 "PhotoMetadata.c"
}


guint8* photo_metadata_flatten_exif_preview (PhotoMetadata* self, int* result_length1) {
	guint8* result = NULL;
	guchar* buffer = NULL;
	gint buffer_length1 = 0;
	gint _buffer_size_ = 0;
	guchar* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint __tmp0__size_ = 0;
	GExiv2Metadata* _tmp1_ = NULL;
	guint8* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	guint8* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	guint8* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
#line 728 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = self->priv->exiv2;
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = gexiv2_metadata_get_exif_thumbnail (_tmp1_, &_tmp2_, &_tmp3_);
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	buffer = (g_free (buffer), NULL);
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	buffer = _tmp2_;
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	buffer_length1 = _tmp3_;
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_buffer_size_ = buffer_length1;
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_) {
#line 5932 "PhotoMetadata.c"
		guchar* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = buffer;
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5__length1 = buffer_length1;
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0_ = _tmp5_;
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0__length1 = _tmp5__length1;
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		__tmp0__size_ = _tmp0__length1;
#line 5945 "PhotoMetadata.c"
	} else {
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0_ = NULL;
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0__length1 = 0;
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		__tmp0__size_ = _tmp0__length1;
#line 5953 "PhotoMetadata.c"
	}
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = (_tmp0_ != NULL) ? _vala_array_dup5 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6__length1 = _tmp0__length1;
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = _tmp6_;
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7__length1 = _tmp6__length1;
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (result_length1) {
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*result_length1 = _tmp7__length1;
#line 5967 "PhotoMetadata.c"
	}
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp7_;
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	buffer = (g_free (buffer), NULL);
#line 730 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 5975 "PhotoMetadata.c"
}


guint photo_metadata_get_preview_count (PhotoMetadata* self) {
	guint result = 0U;
	GExiv2PreviewProperties** props = NULL;
	GExiv2Metadata* _tmp0_ = NULL;
	GExiv2PreviewProperties** _tmp1_ = NULL;
	GExiv2PreviewProperties** _tmp2_ = NULL;
	gint props_length1 = 0;
	gint _props_size_ = 0;
	gint _tmp3_ = 0;
	GExiv2PreviewProperties** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
#line 733 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), 0U);
#line 734 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 734 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = _tmp1_ = gexiv2_metadata_get_preview_properties (_tmp0_);
#line 734 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	props = _tmp2_;
#line 734 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	props_length1 = _vala_array_length (_tmp1_);
#line 734 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_props_size_ = props_length1;
#line 736 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = props;
#line 736 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4__length1 = props_length1;
#line 736 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_ != NULL) {
#line 6008 "PhotoMetadata.c"
		GExiv2PreviewProperties** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
#line 736 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = props;
#line 736 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5__length1 = props_length1;
#line 736 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = _tmp5__length1;
#line 6017 "PhotoMetadata.c"
	} else {
#line 736 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = 0;
#line 6021 "PhotoMetadata.c"
	}
#line 736 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = (guint) _tmp3_;
#line 736 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 6027 "PhotoMetadata.c"
}


PhotoPreview* photo_metadata_get_preview (PhotoMetadata* self, guint number) {
	PhotoPreview* result = NULL;
	GExiv2PreviewProperties** props = NULL;
	GExiv2Metadata* _tmp0_ = NULL;
	GExiv2PreviewProperties** _tmp1_ = NULL;
	GExiv2PreviewProperties** _tmp2_ = NULL;
	gint props_length1 = 0;
	gint _props_size_ = 0;
	gboolean _tmp3_ = FALSE;
	GExiv2PreviewProperties** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	const gchar* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	GExiv2PreviewProperties** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	guint _tmp10_ = 0U;
	GExiv2PreviewProperties* _tmp11_ = NULL;
	PhotoMetadataInternalPhotoPreview* _tmp12_ = NULL;
#line 740 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 741 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 741 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = _tmp1_ = gexiv2_metadata_get_preview_properties (_tmp0_);
#line 741 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	props = _tmp2_;
#line 741 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	props_length1 = _vala_array_length (_tmp1_);
#line 741 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_props_size_ = props_length1;
#line 742 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = props;
#line 742 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4__length1 = props_length1;
#line 742 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_ == NULL) {
#line 742 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = TRUE;
#line 6069 "PhotoMetadata.c"
	} else {
		GExiv2PreviewProperties** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		guint _tmp6_ = 0U;
#line 742 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = props;
#line 742 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5__length1 = props_length1;
#line 742 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = number;
#line 742 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = ((guint) _tmp5__length1) <= _tmp6_;
#line 6082 "PhotoMetadata.c"
	}
#line 742 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp3_) {
#line 743 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 743 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 6090 "PhotoMetadata.c"
	}
#line 745 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = self->priv->source_name;
#line 745 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = number;
#line 745 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = props;
#line 745 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9__length1 = props_length1;
#line 745 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = number;
#line 745 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = _tmp9_[_tmp10_];
#line 745 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12_ = photo_metadata_internal_photo_preview_new (self, _tmp7_, _tmp8_, _tmp11_);
#line 745 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_PHOTO_PREVIEW, PhotoPreview);
#line 745 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 6110 "PhotoMetadata.c"
}


void photo_metadata_remove_exif_thumbnail (PhotoMetadata* self) {
	GExiv2Metadata* _tmp0_ = NULL;
	ExifData* _tmp1_ = NULL;
#line 748 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 749 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 749 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_erase_exif_thumbnail (_tmp0_);
#line 750 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = self->priv->exif;
#line 750 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp1_ != NULL) {
#line 6127 "PhotoMetadata.c"
		ExifMem* _tmp2_ = NULL;
		ExifMem* _tmp3_ = NULL;
		ExifData* _tmp4_ = NULL;
		guchar* _tmp5_ = NULL;
		ExifData* _tmp6_ = NULL;
		ExifData* _tmp7_ = NULL;
#line 751 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = exif_mem_new_default ();
#line 751 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = _tmp2_;
#line 751 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = self->priv->exif;
#line 751 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = _tmp4_->data;
#line 751 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		exif_mem_free (_tmp3_, _tmp5_);
#line 751 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_exif_mem_unref0 (_tmp3_);
#line 752 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = self->priv->exif;
#line 752 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_->data = NULL;
#line 753 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = self->priv->exif;
#line 753 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_->size = (guint) 0;
#line 6154 "PhotoMetadata.c"
	}
}


void photo_metadata_remove_tag (PhotoMetadata* self, const gchar* tag) {
	GExiv2Metadata* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 757 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 757 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (tag != NULL);
#line 758 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 758 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = tag;
#line 758 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_clear_tag (_tmp0_, _tmp1_);
#line 6172 "PhotoMetadata.c"
}


void photo_metadata_remove_tags (PhotoMetadata* self, gchar** tags, int tags_length1) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 761 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 762 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = tags;
#line 762 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = tags_length1;
#line 6185 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 762 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = _tmp0_;
#line 762 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = _tmp0__length1;
#line 762 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < _tmp0__length1; tag_it = tag_it + 1) {
#line 6197 "PhotoMetadata.c"
			gchar* _tmp1_ = NULL;
			gchar* tag = NULL;
#line 762 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = g_strdup (tag_collection[tag_it]);
#line 762 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp1_;
#line 6204 "PhotoMetadata.c"
			{
				const gchar* _tmp2_ = NULL;
#line 763 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = tag;
#line 763 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				photo_metadata_remove_tag (self, _tmp2_);
#line 762 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 6213 "PhotoMetadata.c"
			}
		}
	}
}


void photo_metadata_clear_domain (PhotoMetadata* self, MetadataDomain domain) {
	MetadataDomain _tmp0_ = 0;
#line 766 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 767 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = domain;
#line 767 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	switch (_tmp0_) {
#line 767 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_EXIF:
#line 6230 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp1_ = NULL;
#line 769 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = self->priv->exiv2;
#line 769 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			gexiv2_metadata_clear_exif (_tmp1_);
#line 770 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 6239 "PhotoMetadata.c"
		}
#line 767 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_XMP:
#line 6243 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp2_ = NULL;
#line 773 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp2_ = self->priv->exiv2;
#line 773 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			gexiv2_metadata_clear_xmp (_tmp2_);
#line 774 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 6252 "PhotoMetadata.c"
		}
#line 767 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		case METADATA_DOMAIN_IPTC:
#line 6256 "PhotoMetadata.c"
		{
			GExiv2Metadata* _tmp3_ = NULL;
#line 777 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp3_ = self->priv->exiv2;
#line 777 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			gexiv2_metadata_clear_iptc (_tmp3_);
#line 778 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			break;
#line 6265 "PhotoMetadata.c"
		}
		default:
#line 767 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		break;
#line 6270 "PhotoMetadata.c"
	}
}


void photo_metadata_clear (PhotoMetadata* self) {
	GExiv2Metadata* _tmp0_ = NULL;
#line 782 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 783 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 783 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_clear (_tmp0_);
#line 6283 "PhotoMetadata.c"
}


MetadataDateTime* photo_metadata_get_modification_date_time (PhotoMetadata* self) {
	MetadataDateTime* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	MetadataDateTime* _tmp1_ = NULL;
#line 793 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 794 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_DATE_TIME_TAGS;
#line 794 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_DATE_TIME_TAGS_length1;
#line 794 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_first_date_time (self, _tmp0_, _tmp0__length1);
#line 794 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 794 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 6304 "PhotoMetadata.c"
}


void photo_metadata_set_modification_date_time (PhotoMetadata* self, MetadataDateTime* date_time, PhotoMetadataSetOption option) {
	MetadataDateTime* _tmp0_ = NULL;
#line 797 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 797 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail ((date_time == NULL) || IS_METADATA_DATE_TIME (date_time));
#line 799 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = date_time;
#line 799 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp0_ != NULL) {
#line 6318 "PhotoMetadata.c"
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		MetadataDateTime* _tmp2_ = NULL;
		PhotoMetadataSetOption _tmp3_ = 0;
#line 800 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = photo_metadata_DATE_TIME_TAGS;
#line 800 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1__length1 = photo_metadata_DATE_TIME_TAGS_length1;
#line 800 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = date_time;
#line 800 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = option;
#line 800 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_all_date_time (self, _tmp1_, _tmp1__length1, _tmp2_, _tmp3_);
#line 6333 "PhotoMetadata.c"
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
#line 802 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = photo_metadata_DATE_TIME_TAGS;
#line 802 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4__length1 = photo_metadata_DATE_TIME_TAGS_length1;
#line 802 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tags (self, _tmp4_, _tmp4__length1);
#line 6343 "PhotoMetadata.c"
	}
}


MetadataDateTime* photo_metadata_get_exposure_date_time (PhotoMetadata* self) {
	MetadataDateTime* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	MetadataDateTime* _tmp1_ = NULL;
#line 814 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 815 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_EXPOSURE_DATE_TIME_TAGS;
#line 815 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_EXPOSURE_DATE_TIME_TAGS_length1;
#line 815 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_first_date_time (self, _tmp0_, _tmp0__length1);
#line 815 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 815 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 6365 "PhotoMetadata.c"
}


void photo_metadata_set_exposure_date_time (PhotoMetadata* self, MetadataDateTime* date_time, PhotoMetadataSetOption option) {
	MetadataDateTime* _tmp0_ = NULL;
#line 818 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 818 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail ((date_time == NULL) || IS_METADATA_DATE_TIME (date_time));
#line 820 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = date_time;
#line 820 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp0_ != NULL) {
#line 6379 "PhotoMetadata.c"
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		MetadataDateTime* _tmp2_ = NULL;
		PhotoMetadataSetOption _tmp3_ = 0;
#line 821 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = photo_metadata_EXPOSURE_DATE_TIME_TAGS;
#line 821 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1__length1 = photo_metadata_EXPOSURE_DATE_TIME_TAGS_length1;
#line 821 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = date_time;
#line 821 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = option;
#line 821 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_all_date_time (self, _tmp1_, _tmp1__length1, _tmp2_, _tmp3_);
#line 6394 "PhotoMetadata.c"
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
#line 823 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = photo_metadata_EXPOSURE_DATE_TIME_TAGS;
#line 823 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4__length1 = photo_metadata_EXPOSURE_DATE_TIME_TAGS_length1;
#line 823 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tags (self, _tmp4_, _tmp4__length1);
#line 6404 "PhotoMetadata.c"
	}
}


MetadataDateTime* photo_metadata_get_digitized_date_time (PhotoMetadata* self) {
	MetadataDateTime* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	MetadataDateTime* _tmp1_ = NULL;
#line 831 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 832 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_DIGITIZED_DATE_TIME_TAGS;
#line 832 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_DIGITIZED_DATE_TIME_TAGS_length1;
#line 832 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_first_date_time (self, _tmp0_, _tmp0__length1);
#line 832 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 832 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 6426 "PhotoMetadata.c"
}


void photo_metadata_set_digitized_date_time (PhotoMetadata* self, MetadataDateTime* date_time, PhotoMetadataSetOption option) {
	MetadataDateTime* _tmp0_ = NULL;
#line 835 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 835 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail ((date_time == NULL) || IS_METADATA_DATE_TIME (date_time));
#line 837 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = date_time;
#line 837 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp0_ != NULL) {
#line 6440 "PhotoMetadata.c"
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		MetadataDateTime* _tmp2_ = NULL;
		PhotoMetadataSetOption _tmp3_ = 0;
#line 838 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = photo_metadata_DIGITIZED_DATE_TIME_TAGS;
#line 838 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1__length1 = photo_metadata_DIGITIZED_DATE_TIME_TAGS_length1;
#line 838 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = date_time;
#line 838 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = option;
#line 838 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_all_date_time (self, _tmp1_, _tmp1__length1, _tmp2_, _tmp3_);
#line 6455 "PhotoMetadata.c"
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
#line 840 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = photo_metadata_DIGITIZED_DATE_TIME_TAGS;
#line 840 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4__length1 = photo_metadata_DIGITIZED_DATE_TIME_TAGS_length1;
#line 840 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tags (self, _tmp4_, _tmp4__length1);
#line 6465 "PhotoMetadata.c"
	}
}


static MetadataDateTime* photo_metadata_real_get_creation_date_time (MediaMetadata* base) {
	PhotoMetadata * self;
	MetadataDateTime* result = NULL;
	MetadataDateTime* creation = NULL;
	MetadataDateTime* _tmp0_ = NULL;
	MetadataDateTime* _tmp1_ = NULL;
#line 843 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_METADATA, PhotoMetadata);
#line 844 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_exposure_date_time (self);
#line 844 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	creation = _tmp0_;
#line 845 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = creation;
#line 845 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp1_ == NULL) {
#line 6486 "PhotoMetadata.c"
		MetadataDateTime* _tmp2_ = NULL;
#line 846 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = photo_metadata_get_digitized_date_time (self);
#line 846 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_metadata_date_time_unref0 (creation);
#line 846 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		creation = _tmp2_;
#line 6494 "PhotoMetadata.c"
	}
#line 848 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = creation;
#line 848 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 6500 "PhotoMetadata.c"
}


static gpointer _dimensions_dup0 (gpointer self) {
#line 879 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self ? dimensions_dup (self) : NULL;
#line 6507 "PhotoMetadata.c"
}


Dimensions* photo_metadata_get_pixel_dimensions (PhotoMetadata* self) {
	Dimensions* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 865 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 867 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_WIDTH_TAGS;
#line 867 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_WIDTH_TAGS_length1;
#line 867 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_HEIGHT_TAGS;
#line 867 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1__length1 = photo_metadata_HEIGHT_TAGS_length1;
#line 867 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_assert (_tmp0__length1 == _tmp1__length1, "WIDTH_TAGS.length == HEIGHT_TAGS.length");
#line 6529 "PhotoMetadata.c"
	{
		gint ctr = 0;
#line 868 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		ctr = 0;
#line 6534 "PhotoMetadata.c"
		{
			gboolean _tmp2_ = FALSE;
#line 868 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp2_ = TRUE;
#line 868 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			while (TRUE) {
#line 6541 "PhotoMetadata.c"
				gint _tmp4_ = 0;
				gchar** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				glong width = 0L;
				gchar** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp7_ = 0;
				const gchar* _tmp8_ = NULL;
				glong _tmp9_ = 0L;
				gboolean _tmp10_ = FALSE;
				glong height = 0L;
				gchar** _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gint _tmp12_ = 0;
				const gchar* _tmp13_ = NULL;
				glong _tmp14_ = 0L;
				gboolean _tmp15_ = FALSE;
				glong _tmp16_ = 0L;
				glong _tmp17_ = 0L;
				Dimensions _tmp18_ = {0};
				Dimensions* _tmp19_ = NULL;
#line 868 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!_tmp2_) {
#line 6565 "PhotoMetadata.c"
					gint _tmp3_ = 0;
#line 868 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp3_ = ctr;
#line 868 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					ctr = _tmp3_ + 1;
#line 6571 "PhotoMetadata.c"
				}
#line 868 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = FALSE;
#line 868 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp4_ = ctr;
#line 868 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp5_ = photo_metadata_WIDTH_TAGS;
#line 868 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp5__length1 = photo_metadata_WIDTH_TAGS_length1;
#line 868 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!(_tmp4_ < _tmp5__length1)) {
#line 868 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					break;
#line 6585 "PhotoMetadata.c"
				}
#line 872 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp6_ = photo_metadata_WIDTH_TAGS;
#line 872 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp6__length1 = photo_metadata_WIDTH_TAGS_length1;
#line 872 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp7_ = ctr;
#line 872 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp8_ = _tmp6_[_tmp7_];
#line 872 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp10_ = photo_metadata_get_long (self, _tmp8_, &_tmp9_);
#line 872 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				width = _tmp9_;
#line 872 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!_tmp10_) {
#line 873 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					continue;
#line 6603 "PhotoMetadata.c"
				}
#line 876 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp11_ = photo_metadata_HEIGHT_TAGS;
#line 876 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp11__length1 = photo_metadata_HEIGHT_TAGS_length1;
#line 876 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp12_ = ctr;
#line 876 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp13_ = _tmp11_[_tmp12_];
#line 876 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp15_ = photo_metadata_get_long (self, _tmp13_, &_tmp14_);
#line 876 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				height = _tmp14_;
#line 876 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!_tmp15_) {
#line 877 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					continue;
#line 6621 "PhotoMetadata.c"
				}
#line 879 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp16_ = width;
#line 879 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp17_ = height;
#line 879 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				dimensions_init (&_tmp18_, (gint) _tmp16_, (gint) _tmp17_);
#line 879 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp19_ = _dimensions_dup0 (&_tmp18_);
#line 879 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				result = _tmp19_;
#line 879 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				return result;
#line 6635 "PhotoMetadata.c"
			}
		}
	}
#line 882 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = NULL;
#line 882 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 6643 "PhotoMetadata.c"
}


void photo_metadata_set_pixel_dimensions (PhotoMetadata* self, Dimensions* dim, PhotoMetadataSetOption option) {
	Dimensions* _tmp0_ = NULL;
#line 885 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 886 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = dim;
#line 886 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp0_ != NULL) {
#line 6655 "PhotoMetadata.c"
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		Dimensions* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		PhotoMetadataSetOption _tmp4_ = 0;
		gchar** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		Dimensions* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		PhotoMetadataSetOption _tmp8_ = 0;
#line 887 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1_ = photo_metadata_WIDTH_TAGS;
#line 887 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp1__length1 = photo_metadata_WIDTH_TAGS_length1;
#line 887 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = dim;
#line 887 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = (*_tmp2_).width;
#line 887 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = option;
#line 887 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_all_long (self, _tmp1_, _tmp1__length1, (glong) _tmp3_, _tmp4_);
#line 888 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = photo_metadata_HEIGHT_TAGS;
#line 888 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5__length1 = photo_metadata_HEIGHT_TAGS_length1;
#line 888 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = dim;
#line 888 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = (*_tmp6_).height;
#line 888 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp8_ = option;
#line 888 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_all_long (self, _tmp5_, _tmp5__length1, (glong) _tmp7_, _tmp8_);
#line 6690 "PhotoMetadata.c"
	} else {
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		gchar** _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
#line 890 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = photo_metadata_WIDTH_TAGS;
#line 890 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9__length1 = photo_metadata_WIDTH_TAGS_length1;
#line 890 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tags (self, _tmp9_, _tmp9__length1);
#line 891 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = photo_metadata_HEIGHT_TAGS;
#line 891 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10__length1 = photo_metadata_HEIGHT_TAGS_length1;
#line 891 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tags (self, _tmp10_, _tmp10__length1);
#line 6708 "PhotoMetadata.c"
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1207 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1208 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1208 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1209 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1209 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1210 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _result_;
#line 1210 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 6732 "PhotoMetadata.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1376 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1376 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 6752 "PhotoMetadata.c"
}


static gchar* photo_metadata_real_get_title (MediaMetadata* base) {
	PhotoMetadata * self;
	gchar* result = NULL;
	GeeList* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GeeList* titles = NULL;
	GeeList* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GeeList* _tmp8_ = NULL;
	gchar* title = NULL;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	const gchar* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	gchar* _tmp28_ = NULL;
#line 925 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_METADATA, PhotoMetadata);
#line 933 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_has_tag (self, PHOTO_METADATA_IPHOTO_TITLE_TAG);
#line 933 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp1_) {
#line 6781 "PhotoMetadata.c"
		GeeList* _tmp2_ = NULL;
#line 934 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = photo_metadata_get_string_multiple (self, PHOTO_METADATA_IPHOTO_TITLE_TAG);
#line 934 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_object_unref0 (_tmp0_);
#line 934 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0_ = _tmp2_;
#line 6789 "PhotoMetadata.c"
	} else {
		gchar** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		GeeList* _tmp4_ = NULL;
#line 935 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = photo_metadata_STANDARD_TITLE_TAGS;
#line 935 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3__length1 = photo_metadata_STANDARD_TITLE_TAGS_length1;
#line 935 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = photo_metadata_get_first_string_multiple (self, _tmp3_, _tmp3__length1);
#line 935 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_object_unref0 (_tmp0_);
#line 935 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp0_ = _tmp4_;
#line 6804 "PhotoMetadata.c"
	}
#line 933 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = _g_object_ref0 (_tmp0_);
#line 933 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	titles = _tmp5_;
#line 940 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = titles;
#line 940 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp8_ != NULL) {
#line 6814 "PhotoMetadata.c"
		GeeList* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
#line 940 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = titles;
#line 940 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_COLLECTION, GeeCollection));
#line 940 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp11_ = _tmp10_;
#line 940 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = _tmp11_ > 0;
#line 6826 "PhotoMetadata.c"
	} else {
#line 940 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = FALSE;
#line 6830 "PhotoMetadata.c"
	}
#line 940 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp7_) {
#line 6834 "PhotoMetadata.c"
		GeeList* _tmp12_ = NULL;
		gpointer _tmp13_ = NULL;
#line 940 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp12_ = titles;
#line 940 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp13_ = gee_list_get (_tmp12_, 0);
#line 940 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_tmp6_);
#line 940 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = (gchar*) _tmp13_;
#line 6845 "PhotoMetadata.c"
	} else {
#line 940 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_tmp6_);
#line 940 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = NULL;
#line 6851 "PhotoMetadata.c"
	}
#line 940 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14_ = g_strdup (_tmp6_);
#line 940 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	title = _tmp14_;
#line 943 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp15_ = title;
#line 943 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp15_ != NULL) {
#line 6861 "PhotoMetadata.c"
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
#line 944 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp16_ = title;
#line 944 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp17_ = string_strip (_tmp16_);
#line 944 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (title);
#line 944 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		title = _tmp17_;
#line 6872 "PhotoMetadata.c"
	}
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp21_ = title;
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp22_ = is_string_empty (_tmp21_);
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp22_) {
#line 6880 "PhotoMetadata.c"
		const gchar* _tmp23_ = NULL;
		gboolean _tmp24_ = FALSE;
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp23_ = title;
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp24_ = string_contains (_tmp23_, "\n");
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp20_ = !_tmp24_;
#line 6889 "PhotoMetadata.c"
	} else {
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp20_ = FALSE;
#line 6893 "PhotoMetadata.c"
	}
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp20_) {
#line 6897 "PhotoMetadata.c"
		const gchar* _tmp25_ = NULL;
		gboolean _tmp26_ = FALSE;
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp25_ = title;
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp26_ = string_contains (_tmp25_, "\r");
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp19_ = !_tmp26_;
#line 6906 "PhotoMetadata.c"
	} else {
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp19_ = FALSE;
#line 6910 "PhotoMetadata.c"
	}
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp19_) {
#line 6914 "PhotoMetadata.c"
		const gchar* _tmp27_ = NULL;
#line 948 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp27_ = title;
#line 948 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp18_ = _tmp27_;
#line 6920 "PhotoMetadata.c"
	} else {
#line 948 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp18_ = NULL;
#line 6924 "PhotoMetadata.c"
	}
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp28_ = g_strdup (_tmp18_);
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp28_;
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (title);
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp6_);
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (titles);
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (_tmp0_);
#line 947 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 6940 "PhotoMetadata.c"
}


void photo_metadata_set_title (PhotoMetadata* self, const gchar* title, PhotoMetadataSetOption option) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 951 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 952 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = title;
#line 952 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = is_string_empty (_tmp0_);
#line 952 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp1_) {
#line 6955 "PhotoMetadata.c"
		gboolean _tmp2_ = FALSE;
#line 953 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = photo_metadata_has_tag (self, PHOTO_METADATA_IPHOTO_TITLE_TAG);
#line 953 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (_tmp2_) {
#line 6961 "PhotoMetadata.c"
			const gchar* _tmp3_ = NULL;
#line 954 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp3_ = title;
#line 954 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			photo_metadata_set_string (self, PHOTO_METADATA_IPHOTO_TITLE_TAG, _tmp3_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 6967 "PhotoMetadata.c"
		} else {
			gchar** _tmp4_ = NULL;
			gint _tmp4__length1 = 0;
			const gchar* _tmp5_ = NULL;
			PhotoMetadataSetOption _tmp6_ = 0;
#line 956 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp4_ = photo_metadata_STANDARD_TITLE_TAGS;
#line 956 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp4__length1 = photo_metadata_STANDARD_TITLE_TAGS_length1;
#line 956 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp5_ = title;
#line 956 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp6_ = option;
#line 956 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			photo_metadata_set_all_string (self, _tmp4_, _tmp4__length1, _tmp5_, _tmp6_);
#line 6983 "PhotoMetadata.c"
		}
	} else {
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
#line 958 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = photo_metadata_STANDARD_TITLE_TAGS;
#line 958 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7__length1 = photo_metadata_STANDARD_TITLE_TAGS_length1;
#line 958 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tags (self, _tmp7_, _tmp7__length1);
#line 6994 "PhotoMetadata.c"
	}
}


static gchar* photo_metadata_real_get_comment (MediaMetadata* base) {
	PhotoMetadata * self;
	gchar* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar* _tmp1_ = NULL;
#line 967 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO_METADATA, PhotoMetadata);
#line 968 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_COMMENT_TAGS;
#line 968 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_COMMENT_TAGS_length1;
#line 968 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_first_string_interpreted (self, _tmp0_, _tmp0__length1);
#line 968 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 968 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 7017 "PhotoMetadata.c"
}


void photo_metadata_set_comment (PhotoMetadata* self, const gchar* comment, PhotoMetadataSetOption option) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 971 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 973 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = comment;
#line 973 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = is_string_empty (_tmp0_);
#line 973 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp1_) {
#line 7032 "PhotoMetadata.c"
		gchar** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		const gchar* _tmp3_ = NULL;
		PhotoMetadataSetOption _tmp4_ = 0;
#line 974 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = photo_metadata_COMMENT_TAGS;
#line 974 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2__length1 = photo_metadata_COMMENT_TAGS_length1;
#line 974 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = comment;
#line 974 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = option;
#line 974 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_all_string (self, _tmp2_, _tmp2__length1, _tmp3_, _tmp4_);
#line 7047 "PhotoMetadata.c"
	} else {
		gchar** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
#line 976 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = photo_metadata_COMMENT_TAGS;
#line 976 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5__length1 = photo_metadata_COMMENT_TAGS_length1;
#line 976 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tags (self, _tmp5_, _tmp5__length1);
#line 7057 "PhotoMetadata.c"
	}
}


GeeSet* photo_metadata_get_keywords (PhotoMetadata* self, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify) {
	GeeSet* result = NULL;
	GeeSet* keywords = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GeeSet* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	GeeSet* _tmp24_ = NULL;
	GeeSet* _tmp29_ = NULL;
#line 996 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 997 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	keywords = NULL;
#line 998 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_KEYWORD_TAGS;
#line 998 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_KEYWORD_TAGS_length1;
#line 7079 "PhotoMetadata.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 998 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection = _tmp0_;
#line 998 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		tag_collection_length1 = _tmp0__length1;
#line 998 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (tag_it = 0; tag_it < _tmp0__length1; tag_it = tag_it + 1) {
#line 7091 "PhotoMetadata.c"
			gchar* _tmp1_ = NULL;
			gchar* tag = NULL;
#line 998 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = g_strdup (tag_collection[tag_it]);
#line 998 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			tag = _tmp1_;
#line 7098 "PhotoMetadata.c"
			{
				GeeCollection* values = NULL;
				const gchar* _tmp2_ = NULL;
				GeeList* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				GeeCollection* _tmp5_ = NULL;
#line 999 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = tag;
#line 999 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = photo_metadata_get_string_multiple (self, _tmp2_);
#line 999 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				values = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection);
#line 1000 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp5_ = values;
#line 1000 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp5_ != NULL) {
#line 7115 "PhotoMetadata.c"
					GeeCollection* _tmp6_ = NULL;
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
#line 1000 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp6_ = values;
#line 1000 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp7_ = gee_collection_get_size (_tmp6_);
#line 1000 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp8_ = _tmp7_;
#line 1000 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp4_ = _tmp8_ > 0;
#line 7127 "PhotoMetadata.c"
				} else {
#line 1000 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp4_ = FALSE;
#line 7131 "PhotoMetadata.c"
				}
#line 1000 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp4_) {
#line 7135 "PhotoMetadata.c"
					GeeSet* _tmp9_ = NULL;
#line 1001 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp9_ = keywords;
#line 1001 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					if (_tmp9_ == NULL) {
#line 7141 "PhotoMetadata.c"
						GCompareDataFunc _tmp10_ = NULL;
						void* _tmp10__target = NULL;
						GDestroyNotify _tmp10__target_destroy_notify = NULL;
						GeeSet* _tmp11_ = NULL;
#line 1002 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp10_ = compare_func;
#line 1002 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp10__target = compare_func_target;
#line 1002 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp10__target_destroy_notify = compare_func_target_destroy_notify;
#line 1002 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						compare_func_target_destroy_notify = NULL;
#line 1002 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp11_ = photo_metadata_create_string_set (self, _tmp10_, _tmp10__target, _tmp10__target_destroy_notify);
#line 1002 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_g_object_unref0 (keywords);
#line 1002 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						keywords = _tmp11_;
#line 7160 "PhotoMetadata.c"
					}
					{
						GeeIterator* _current_value_it = NULL;
						GeeCollection* _tmp12_ = NULL;
						GeeIterator* _tmp13_ = NULL;
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp12_ = values;
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp13_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_current_value_it = _tmp13_;
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						while (TRUE) {
#line 7174 "PhotoMetadata.c"
							GeeIterator* _tmp14_ = NULL;
							gboolean _tmp15_ = FALSE;
							gchar* current_value = NULL;
							GeeIterator* _tmp16_ = NULL;
							gpointer _tmp17_ = NULL;
							GeeSet* _tmp18_ = NULL;
							const gchar* _tmp19_ = NULL;
							gchar* _tmp20_ = NULL;
							gchar* _tmp21_ = NULL;
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp14_ = _current_value_it;
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp15_ = gee_iterator_next (_tmp14_);
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							if (!_tmp15_) {
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
								break;
#line 7192 "PhotoMetadata.c"
							}
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp16_ = _current_value_it;
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp17_ = gee_iterator_get (_tmp16_);
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							current_value = (gchar*) _tmp17_;
#line 1005 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp18_ = keywords;
#line 1005 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp19_ = current_value;
#line 1005 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp20_ = hierarchical_tag_utilities_make_flat_tag_safe (_tmp19_);
#line 1005 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp21_ = _tmp20_;
#line 1005 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection), _tmp21_);
#line 1005 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_free0 (_tmp21_);
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_free0 (current_value);
#line 7214 "PhotoMetadata.c"
						}
#line 1004 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_g_object_unref0 (_current_value_it);
#line 7218 "PhotoMetadata.c"
					}
				}
#line 998 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_object_unref0 (values);
#line 998 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (tag);
#line 7225 "PhotoMetadata.c"
			}
		}
	}
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp24_ = keywords;
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp24_ != NULL) {
#line 7233 "PhotoMetadata.c"
		GeeSet* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp25_ = keywords;
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp26_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp27_ = _tmp26_;
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp23_ = _tmp27_ > 0;
#line 7245 "PhotoMetadata.c"
	} else {
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp23_ = FALSE;
#line 7249 "PhotoMetadata.c"
	}
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp23_) {
#line 7253 "PhotoMetadata.c"
		GeeSet* _tmp28_ = NULL;
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp28_ = keywords;
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp22_ = _tmp28_;
#line 7259 "PhotoMetadata.c"
	} else {
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp22_ = NULL;
#line 7263 "PhotoMetadata.c"
	}
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp29_ = _g_object_ref0 (_tmp22_);
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp29_;
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (keywords);
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func = NULL;
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target = NULL;
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	compare_func_target_destroy_notify = NULL;
#line 1009 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 7281 "PhotoMetadata.c"
}


static gpointer _hierarchical_keyword_field_ref0 (gpointer self) {
#line 1013 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self ? hierarchical_keyword_field_ref (self) : NULL;
#line 7288 "PhotoMetadata.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1380 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1380 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1380 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 7301 "PhotoMetadata.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 7332 "PhotoMetadata.c"
				goto __catch27_g_regex_error;
			}
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			return NULL;
#line 7341 "PhotoMetadata.c"
		}
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 7357 "PhotoMetadata.c"
				goto __catch27_g_regex_error;
			}
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			return NULL;
#line 7368 "PhotoMetadata.c"
		}
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 7382 "PhotoMetadata.c"
	}
	goto __finally27;
	__catch27_g_regex_error:
	{
		GError* e = NULL;
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1385 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 7396 "PhotoMetadata.c"
	}
	__finally27:
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return NULL;
#line 7407 "PhotoMetadata.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1295 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1295 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1295 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1295 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1296 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1296 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 7431 "PhotoMetadata.c"
		glong _tmp4_ = 0L;
#line 1297 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1297 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1297 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 7439 "PhotoMetadata.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1299 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1299 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1299 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1299 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 7451 "PhotoMetadata.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1306 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 7475 "PhotoMetadata.c"
		glong _tmp2_ = 0L;
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 7481 "PhotoMetadata.c"
	} else {
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 7485 "PhotoMetadata.c"
	}
#line 1308 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 7489 "PhotoMetadata.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1310 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1310 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1310 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1310 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 7501 "PhotoMetadata.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1312 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1312 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1312 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 7511 "PhotoMetadata.c"
	}
#line 1315 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1315 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 7517 "PhotoMetadata.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1316 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1316 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1316 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1317 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1317 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 7531 "PhotoMetadata.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1319 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1319 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1319 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 7541 "PhotoMetadata.c"
	}
#line 1321 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1321 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 7547 "PhotoMetadata.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1322 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1322 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1322 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 7556 "PhotoMetadata.c"
	}
#line 1324 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1324 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1324 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1324 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1325 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 7576 "PhotoMetadata.c"
}


static void photo_metadata_internal_set_hierarchical_keywords (PhotoMetadata* self, HierarchicalTagIndex* index) {
	HierarchicalKeywordField** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	HierarchicalTagIndex* _tmp4_ = NULL;
	HierarchicalKeywordField** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
#line 1012 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 1012 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail ((index == NULL) || IS_HIERARCHICAL_TAG_INDEX (index));
#line 1013 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_HIERARCHICAL_KEYWORD_TAGS;
#line 1013 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_HIERARCHICAL_KEYWORD_TAGS_length1;
#line 7594 "PhotoMetadata.c"
	{
		HierarchicalKeywordField** current_field_collection = NULL;
		gint current_field_collection_length1 = 0;
		gint _current_field_collection_size_ = 0;
		gint current_field_it = 0;
#line 1013 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		current_field_collection = _tmp0_;
#line 1013 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		current_field_collection_length1 = _tmp0__length1;
#line 1013 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (current_field_it = 0; current_field_it < _tmp0__length1; current_field_it = current_field_it + 1) {
#line 7606 "PhotoMetadata.c"
			HierarchicalKeywordField* _tmp1_ = NULL;
			HierarchicalKeywordField* current_field = NULL;
#line 1013 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = _hierarchical_keyword_field_ref0 (current_field_collection[current_field_it]);
#line 1013 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			current_field = _tmp1_;
#line 7613 "PhotoMetadata.c"
			{
				HierarchicalKeywordField* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
#line 1014 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = current_field;
#line 1014 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = _tmp2_->field_name;
#line 1014 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				photo_metadata_remove_tag (self, _tmp3_);
#line 1013 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_hierarchical_keyword_field_unref0 (current_field);
#line 7625 "PhotoMetadata.c"
			}
		}
	}
#line 1016 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = index;
#line 1016 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_ == NULL) {
#line 1017 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return;
#line 7635 "PhotoMetadata.c"
	}
#line 1019 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = photo_metadata_HIERARCHICAL_KEYWORD_TAGS;
#line 1019 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5__length1 = photo_metadata_HIERARCHICAL_KEYWORD_TAGS_length1;
#line 7641 "PhotoMetadata.c"
	{
		HierarchicalKeywordField** current_field_collection = NULL;
		gint current_field_collection_length1 = 0;
		gint _current_field_collection_size_ = 0;
		gint current_field_it = 0;
#line 1019 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		current_field_collection = _tmp5_;
#line 1019 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		current_field_collection_length1 = _tmp5__length1;
#line 1019 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (current_field_it = 0; current_field_it < _tmp5__length1; current_field_it = current_field_it + 1) {
#line 7653 "PhotoMetadata.c"
			HierarchicalKeywordField* _tmp6_ = NULL;
			HierarchicalKeywordField* current_field = NULL;
#line 1019 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp6_ = _hierarchical_keyword_field_ref0 (current_field_collection[current_field_it]);
#line 1019 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			current_field = _tmp6_;
#line 7660 "PhotoMetadata.c"
			{
				HierarchicalKeywordField* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				GeeSet* writeable_set = NULL;
				GeeTreeSet* _tmp9_ = NULL;
				HierarchicalKeywordField* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				GeeSet* _tmp31_ = NULL;
#line 1020 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp7_ = current_field;
#line 1020 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp8_ = _tmp7_->is_writeable;
#line 1020 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!_tmp8_) {
#line 1021 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_hierarchical_keyword_field_unref0 (current_field);
#line 1021 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					continue;
#line 7679 "PhotoMetadata.c"
				}
#line 1023 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp9_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 1023 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				writeable_set = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_SET, GeeSet);
#line 7685 "PhotoMetadata.c"
				{
					GeeIterator* _current_path_it = NULL;
					HierarchicalTagIndex* _tmp10_ = NULL;
					GeeCollection* _tmp11_ = NULL;
					GeeCollection* _tmp12_ = NULL;
					GeeIterator* _tmp13_ = NULL;
					GeeIterator* _tmp14_ = NULL;
#line 1025 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp10_ = index;
#line 1025 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp11_ = hierarchical_tag_index_get_all_paths (_tmp10_);
#line 1025 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp12_ = _tmp11_;
#line 1025 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp13_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1025 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp14_ = _tmp13_;
#line 1025 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_object_unref0 (_tmp12_);
#line 1025 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_current_path_it = _tmp14_;
#line 1025 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					while (TRUE) {
#line 7709 "PhotoMetadata.c"
						GeeIterator* _tmp15_ = NULL;
						gboolean _tmp16_ = FALSE;
						gchar* current_path = NULL;
						GeeIterator* _tmp17_ = NULL;
						gpointer _tmp18_ = NULL;
						gchar* writeable_path = NULL;
						const gchar* _tmp19_ = NULL;
						HierarchicalKeywordField* _tmp20_ = NULL;
						const gchar* _tmp21_ = NULL;
						gchar* _tmp22_ = NULL;
						HierarchicalKeywordField* _tmp23_ = NULL;
						gboolean _tmp24_ = FALSE;
						GeeSet* _tmp27_ = NULL;
						const gchar* _tmp28_ = NULL;
#line 1025 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp15_ = _current_path_it;
#line 1025 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp16_ = gee_iterator_next (_tmp15_);
#line 1025 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						if (!_tmp16_) {
#line 1025 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							break;
#line 7732 "PhotoMetadata.c"
						}
#line 1025 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp17_ = _current_path_it;
#line 1025 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp18_ = gee_iterator_get (_tmp17_);
#line 1025 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						current_path = (gchar*) _tmp18_;
#line 1026 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp19_ = current_path;
#line 1026 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp20_ = current_field;
#line 1026 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp21_ = _tmp20_->path_separator;
#line 1026 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp22_ = string_replace (_tmp19_, TAG_PATH_SEPARATOR_STRING, _tmp21_);
#line 1026 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						writeable_path = _tmp22_;
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp23_ = current_field;
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp24_ = _tmp23_->wants_leading_separator;
#line 1028 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						if (!_tmp24_) {
#line 7756 "PhotoMetadata.c"
							const gchar* _tmp25_ = NULL;
							gchar* _tmp26_ = NULL;
#line 1029 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp25_ = writeable_path;
#line 1029 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp26_ = string_substring (_tmp25_, (glong) 1, (glong) -1);
#line 1029 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_free0 (writeable_path);
#line 1029 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							writeable_path = _tmp26_;
#line 7767 "PhotoMetadata.c"
						}
#line 1031 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp27_ = writeable_set;
#line 1031 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp28_ = writeable_path;
#line 1031 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_COLLECTION, GeeCollection), _tmp28_);
#line 1025 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_g_free0 (writeable_path);
#line 1025 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_g_free0 (current_path);
#line 7779 "PhotoMetadata.c"
					}
#line 1025 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_object_unref0 (_current_path_it);
#line 7783 "PhotoMetadata.c"
				}
#line 1034 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp29_ = current_field;
#line 1034 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp30_ = _tmp29_->field_name;
#line 1034 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp31_ = writeable_set;
#line 1034 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				photo_metadata_set_string_multiple (self, _tmp30_, G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1019 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_object_unref0 (writeable_set);
#line 1019 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_hierarchical_keyword_field_unref0 (current_field);
#line 7797 "PhotoMetadata.c"
			}
		}
	}
}


void photo_metadata_set_keywords (PhotoMetadata* self, GeeCollection* keywords, PhotoMetadataSetOption option) {
	HierarchicalTagIndex* htag_index = NULL;
	HierarchicalTagIndex* _tmp0_ = NULL;
	GeeSet* flat_keywords = NULL;
	GeeTreeSet* _tmp1_ = NULL;
	GeeCollection* _tmp2_ = NULL;
	GeeCollection* _tmp28_ = NULL;
#line 1038 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 1038 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail ((keywords == NULL) || GEE_IS_COLLECTION (keywords));
#line 1039 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = hierarchical_tag_index_new ();
#line 1039 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	htag_index = _tmp0_;
#line 1040 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 1040 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	flat_keywords = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_SET, GeeSet);
#line 1042 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = keywords;
#line 1042 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp2_ != NULL) {
#line 7827 "PhotoMetadata.c"
		GeeSet* _tmp24_ = NULL;
		HierarchicalTagIndex* _tmp25_ = NULL;
		GeeCollection* _tmp26_ = NULL;
		GeeCollection* _tmp27_ = NULL;
		{
			GeeIterator* _keyword_it = NULL;
			GeeCollection* _tmp3_ = NULL;
			GeeIterator* _tmp4_ = NULL;
#line 1043 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp3_ = keywords;
#line 1043 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1043 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_keyword_it = _tmp4_;
#line 1043 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			while (TRUE) {
#line 7844 "PhotoMetadata.c"
				GeeIterator* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
				gchar* keyword = NULL;
				GeeIterator* _tmp7_ = NULL;
				gpointer _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
#line 1043 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp5_ = _keyword_it;
#line 1043 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp6_ = gee_iterator_next (_tmp5_);
#line 1043 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!_tmp6_) {
#line 1043 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					break;
#line 7860 "PhotoMetadata.c"
				}
#line 1043 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp7_ = _keyword_it;
#line 1043 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp8_ = gee_iterator_get (_tmp7_);
#line 1043 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				keyword = (gchar*) _tmp8_;
#line 1044 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp9_ = keyword;
#line 1044 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp10_ = g_str_has_prefix (_tmp9_, TAG_PATH_SEPARATOR_STRING);
#line 1044 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp10_) {
#line 7874 "PhotoMetadata.c"
					GeeCollection* path_components = NULL;
					const gchar* _tmp11_ = NULL;
					GeeList* _tmp12_ = NULL;
#line 1045 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp11_ = keyword;
#line 1045 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp12_ = hierarchical_tag_utilities_enumerate_path_components (_tmp11_);
#line 1045 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					path_components = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_COLLECTION, GeeCollection);
#line 7884 "PhotoMetadata.c"
					{
						GeeIterator* _component_it = NULL;
						GeeCollection* _tmp13_ = NULL;
						GeeIterator* _tmp14_ = NULL;
#line 1047 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp13_ = path_components;
#line 1047 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp14_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1047 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_component_it = _tmp14_;
#line 1047 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						while (TRUE) {
#line 7897 "PhotoMetadata.c"
							GeeIterator* _tmp15_ = NULL;
							gboolean _tmp16_ = FALSE;
							gchar* component = NULL;
							GeeIterator* _tmp17_ = NULL;
							gpointer _tmp18_ = NULL;
							HierarchicalTagIndex* _tmp19_ = NULL;
							const gchar* _tmp20_ = NULL;
							const gchar* _tmp21_ = NULL;
#line 1047 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp15_ = _component_it;
#line 1047 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp16_ = gee_iterator_next (_tmp15_);
#line 1047 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							if (!_tmp16_) {
#line 1047 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
								break;
#line 7914 "PhotoMetadata.c"
							}
#line 1047 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp17_ = _component_it;
#line 1047 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp18_ = gee_iterator_get (_tmp17_);
#line 1047 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							component = (gchar*) _tmp18_;
#line 1048 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp19_ = htag_index;
#line 1048 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp20_ = component;
#line 1048 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp21_ = keyword;
#line 1048 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							hierarchical_tag_index_add_path (_tmp19_, _tmp20_, _tmp21_);
#line 1047 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_free0 (component);
#line 7932 "PhotoMetadata.c"
						}
#line 1047 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_g_object_unref0 (_component_it);
#line 7936 "PhotoMetadata.c"
					}
#line 1044 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_object_unref0 (path_components);
#line 7940 "PhotoMetadata.c"
				} else {
					GeeSet* _tmp22_ = NULL;
					const gchar* _tmp23_ = NULL;
#line 1050 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp22_ = flat_keywords;
#line 1050 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp23_ = keyword;
#line 1050 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_COLLECTION, GeeCollection), _tmp23_);
#line 7950 "PhotoMetadata.c"
				}
#line 1043 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_free0 (keyword);
#line 7954 "PhotoMetadata.c"
			}
#line 1043 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_g_object_unref0 (_keyword_it);
#line 7958 "PhotoMetadata.c"
		}
#line 1054 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp24_ = flat_keywords;
#line 1054 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp25_ = htag_index;
#line 1054 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp26_ = hierarchical_tag_index_get_all_tags (_tmp25_);
#line 1054 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp27_ = _tmp26_;
#line 1054 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_COLLECTION, GeeCollection), _tmp27_);
#line 1054 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_object_unref0 (_tmp27_);
#line 7972 "PhotoMetadata.c"
	}
#line 1057 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp28_ = keywords;
#line 1057 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp28_ != NULL) {
#line 7978 "PhotoMetadata.c"
		gchar** _tmp29_ = NULL;
		gint _tmp29__length1 = 0;
		GeeSet* _tmp30_ = NULL;
		PhotoMetadataSetOption _tmp31_ = 0;
		HierarchicalTagIndex* _tmp32_ = NULL;
#line 1058 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp29_ = photo_metadata_KEYWORD_TAGS;
#line 1058 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp29__length1 = photo_metadata_KEYWORD_TAGS_length1;
#line 1058 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp30_ = flat_keywords;
#line 1058 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp31_ = option;
#line 1058 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_all_string_multiple (self, _tmp29_, _tmp29__length1, G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_COLLECTION, GeeCollection), _tmp31_);
#line 1059 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp32_ = htag_index;
#line 1059 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_internal_set_hierarchical_keywords (self, _tmp32_);
#line 7998 "PhotoMetadata.c"
	} else {
		gchar** _tmp33_ = NULL;
		gint _tmp33__length1 = 0;
#line 1061 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp33_ = photo_metadata_KEYWORD_TAGS;
#line 1061 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp33__length1 = photo_metadata_KEYWORD_TAGS_length1;
#line 1061 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_remove_tags (self, _tmp33_, _tmp33__length1);
#line 1062 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_internal_set_hierarchical_keywords (self, NULL);
#line 8010 "PhotoMetadata.c"
	}
#line 1038 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (flat_keywords);
#line 1038 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_hierarchical_tag_index_unref0 (htag_index);
#line 8016 "PhotoMetadata.c"
}


gboolean photo_metadata_has_hierarchical_keywords (PhotoMetadata* self) {
	gboolean result = FALSE;
	HierarchicalKeywordField** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 1066 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 1067 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_HIERARCHICAL_KEYWORD_TAGS;
#line 1067 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_HIERARCHICAL_KEYWORD_TAGS_length1;
#line 8030 "PhotoMetadata.c"
	{
		HierarchicalKeywordField** field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
#line 1067 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		field_collection = _tmp0_;
#line 1067 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		field_collection_length1 = _tmp0__length1;
#line 1067 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (field_it = 0; field_it < _tmp0__length1; field_it = field_it + 1) {
#line 8042 "PhotoMetadata.c"
			HierarchicalKeywordField* _tmp1_ = NULL;
			HierarchicalKeywordField* field = NULL;
#line 1067 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp1_ = _hierarchical_keyword_field_ref0 (field_collection[field_it]);
#line 1067 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			field = _tmp1_;
#line 8049 "PhotoMetadata.c"
			{
				GeeCollection* values = NULL;
				HierarchicalKeywordField* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
				GeeList* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				GeeCollection* _tmp6_ = NULL;
#line 1068 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp2_ = field;
#line 1068 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp3_ = _tmp2_->field_name;
#line 1068 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp4_ = photo_metadata_get_string_multiple (self, _tmp3_);
#line 1068 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				values = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection);
#line 1070 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp6_ = values;
#line 1070 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp6_ != NULL) {
#line 8069 "PhotoMetadata.c"
					GeeCollection* _tmp7_ = NULL;
					gint _tmp8_ = 0;
					gint _tmp9_ = 0;
#line 1070 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp7_ = values;
#line 1070 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp8_ = gee_collection_get_size (_tmp7_);
#line 1070 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp9_ = _tmp8_;
#line 1070 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp5_ = _tmp9_ > 0;
#line 8081 "PhotoMetadata.c"
				} else {
#line 1070 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp5_ = FALSE;
#line 8085 "PhotoMetadata.c"
				}
#line 1070 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp5_) {
#line 1071 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = TRUE;
#line 1071 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_object_unref0 (values);
#line 1071 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_hierarchical_keyword_field_unref0 (field);
#line 1071 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 8097 "PhotoMetadata.c"
				}
#line 1067 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_object_unref0 (values);
#line 1067 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_hierarchical_keyword_field_unref0 (field);
#line 8103 "PhotoMetadata.c"
			}
		}
	}
#line 1074 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = FALSE;
#line 1074 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8111 "PhotoMetadata.c"
}


GeeSet* photo_metadata_get_hierarchical_keywords (PhotoMetadata* self) {
	GeeSet* result = NULL;
	gboolean _tmp0_ = FALSE;
	GeeSet* h_keywords = NULL;
	GeeSet* _tmp1_ = NULL;
	HierarchicalKeywordField** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	GError * _inner_error_ = NULL;
#line 1077 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1078 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_has_hierarchical_keywords (self);
#line 1078 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_assert (_tmp0_, "has_hierarchical_keywords()");
#line 1080 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_create_string_set (self, NULL, NULL, NULL);
#line 1080 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	h_keywords = _tmp1_;
#line 1082 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = photo_metadata_HIERARCHICAL_KEYWORD_TAGS;
#line 1082 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2__length1 = photo_metadata_HIERARCHICAL_KEYWORD_TAGS_length1;
#line 8137 "PhotoMetadata.c"
	{
		HierarchicalKeywordField** field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
#line 1082 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		field_collection = _tmp2_;
#line 1082 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		field_collection_length1 = _tmp2__length1;
#line 1082 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		for (field_it = 0; field_it < _tmp2__length1; field_it = field_it + 1) {
#line 8149 "PhotoMetadata.c"
			HierarchicalKeywordField* _tmp3_ = NULL;
			HierarchicalKeywordField* field = NULL;
#line 1082 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp3_ = _hierarchical_keyword_field_ref0 (field_collection[field_it]);
#line 1082 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			field = _tmp3_;
#line 8156 "PhotoMetadata.c"
			{
				GeeCollection* values = NULL;
				HierarchicalKeywordField* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				GeeList* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				GeeCollection* _tmp8_ = NULL;
				GeeArrayList* transformed_values = NULL;
				GeeArrayList* _tmp12_ = NULL;
#line 1083 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp4_ = field;
#line 1083 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp5_ = _tmp4_->field_name;
#line 1083 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp6_ = photo_metadata_get_string_multiple (self, _tmp5_);
#line 1083 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				values = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection);
#line 1085 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp8_ = values;
#line 1085 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp8_ == NULL) {
#line 1085 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp7_ = TRUE;
#line 8180 "PhotoMetadata.c"
				} else {
					GeeCollection* _tmp9_ = NULL;
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
#line 1085 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp9_ = values;
#line 1085 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp10_ = gee_collection_get_size (_tmp9_);
#line 1085 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp11_ = _tmp10_;
#line 1085 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp7_ = _tmp11_ < 1;
#line 8193 "PhotoMetadata.c"
				}
#line 1085 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp7_) {
#line 1086 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_object_unref0 (values);
#line 1086 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_hierarchical_keyword_field_unref0 (field);
#line 1086 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					continue;
#line 8203 "PhotoMetadata.c"
				}
#line 1088 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp12_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 1088 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				transformed_values = _tmp12_;
#line 8209 "PhotoMetadata.c"
				{
					GeeIterator* _current_value_it = NULL;
					GeeCollection* _tmp13_ = NULL;
					GeeIterator* _tmp14_ = NULL;
#line 1089 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp13_ = values;
#line 1089 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp14_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1089 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_current_value_it = _tmp14_;
#line 1089 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					while (TRUE) {
#line 8222 "PhotoMetadata.c"
						GeeIterator* _tmp15_ = NULL;
						gboolean _tmp16_ = FALSE;
						gchar* current_value = NULL;
						GeeIterator* _tmp17_ = NULL;
						gpointer _tmp18_ = NULL;
#line 1089 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp15_ = _current_value_it;
#line 1089 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp16_ = gee_iterator_next (_tmp15_);
#line 1089 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						if (!_tmp16_) {
#line 1089 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							break;
#line 8236 "PhotoMetadata.c"
						}
#line 1089 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp17_ = _current_value_it;
#line 1089 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp18_ = gee_iterator_get (_tmp17_);
#line 1089 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						current_value = (gchar*) _tmp18_;
#line 8244 "PhotoMetadata.c"
						{
							GeeList* transformed = NULL;
							HierarchicalKeywordField* _tmp19_ = NULL;
							KeywordTransformer* _tmp20_ = NULL;
							const gchar* _tmp21_ = NULL;
							GeeList* _tmp22_ = NULL;
							GeeArrayList* _tmp23_ = NULL;
							GeeList* _tmp24_ = NULL;
#line 1091 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp19_ = field;
#line 1091 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp20_ = _tmp19_->transformer;
#line 1091 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp21_ = current_value;
#line 1091 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp22_ = keyword_transformer_transform (_tmp20_, _tmp21_, &_inner_error_);
#line 1091 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							transformed = _tmp22_;
#line 1091 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8265 "PhotoMetadata.c"
								goto __catch28_g_error;
							}
#line 1092 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp23_ = transformed_values;
#line 1092 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp24_ = transformed;
#line 1092 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							gee_array_list_add_all (_tmp23_, G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1090 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_object_unref0 (transformed);
#line 8276 "PhotoMetadata.c"
						}
						goto __finally28;
						__catch28_g_error:
						{
							GError* _error_ = NULL;
							const gchar* _tmp25_ = NULL;
							GError* _tmp26_ = NULL;
							const gchar* _tmp27_ = NULL;
#line 1090 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_error_ = _inner_error_;
#line 1090 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_inner_error_ = NULL;
#line 1094 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp25_ = current_value;
#line 1094 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp26_ = _error_;
#line 1094 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp27_ = _tmp26_->message;
#line 1094 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							g_critical ("PhotoMetadata.vala:1094: Failed to transform tag value %s: %s", _tmp25_, _tmp27_);
#line 1090 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_error_free0 (_error_);
#line 8299 "PhotoMetadata.c"
						}
						__finally28:
#line 1090 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1090 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_free0 (current_value);
#line 1090 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_object_unref0 (_current_value_it);
#line 1090 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_object_unref0 (transformed_values);
#line 1090 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_object_unref0 (values);
#line 1090 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_hierarchical_keyword_field_unref0 (field);
#line 1090 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_g_object_unref0 (h_keywords);
#line 1090 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1090 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							g_clear_error (&_inner_error_);
#line 1090 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							return NULL;
#line 8322 "PhotoMetadata.c"
						}
#line 1089 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_g_free0 (current_value);
#line 8326 "PhotoMetadata.c"
					}
#line 1089 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_object_unref0 (_current_value_it);
#line 8330 "PhotoMetadata.c"
				}
				{
					GeeArrayList* _current_value_list = NULL;
					GeeArrayList* _tmp28_ = NULL;
					GeeArrayList* _tmp29_ = NULL;
					gint _current_value_size = 0;
					GeeArrayList* _tmp30_ = NULL;
					gint _tmp31_ = 0;
					gint _tmp32_ = 0;
					gint _current_value_index = 0;
#line 1100 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp28_ = transformed_values;
#line 1100 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp29_ = _g_object_ref0 (_tmp28_);
#line 1100 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_current_value_list = _tmp29_;
#line 1100 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp30_ = _current_value_list;
#line 1100 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp31_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1100 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp32_ = _tmp31_;
#line 1100 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_current_value_size = _tmp32_;
#line 1100 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_current_value_index = -1;
#line 1100 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					while (TRUE) {
#line 8359 "PhotoMetadata.c"
						gint _tmp33_ = 0;
						gint _tmp34_ = 0;
						gint _tmp35_ = 0;
						gchar* current_value = NULL;
						GeeArrayList* _tmp36_ = NULL;
						gint _tmp37_ = 0;
						gpointer _tmp38_ = NULL;
						gchar* canonicalized = NULL;
						const gchar* _tmp39_ = NULL;
						HierarchicalKeywordField* _tmp40_ = NULL;
						const gchar* _tmp41_ = NULL;
						gchar* _tmp42_ = NULL;
						const gchar* _tmp43_ = NULL;
#line 1100 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp33_ = _current_value_index;
#line 1100 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_current_value_index = _tmp33_ + 1;
#line 1100 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp34_ = _current_value_index;
#line 1100 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp35_ = _current_value_size;
#line 1100 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						if (!(_tmp34_ < _tmp35_)) {
#line 1100 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							break;
#line 8385 "PhotoMetadata.c"
						}
#line 1100 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp36_ = _current_value_list;
#line 1100 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp37_ = _current_value_index;
#line 1100 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp38_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp37_);
#line 1100 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						current_value = (gchar*) _tmp38_;
#line 1101 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp39_ = current_value;
#line 1101 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp40_ = field;
#line 1101 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp41_ = _tmp40_->path_separator;
#line 1101 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp42_ = hierarchical_tag_utilities_canonicalize (_tmp39_, _tmp41_);
#line 1101 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						canonicalized = _tmp42_;
#line 1105 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_tmp43_ = canonicalized;
#line 1105 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						if (_tmp43_ != NULL) {
#line 8409 "PhotoMetadata.c"
							GeeSet* _tmp44_ = NULL;
							const gchar* _tmp45_ = NULL;
#line 1106 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp44_ = h_keywords;
#line 1106 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							_tmp45_ = canonicalized;
#line 1106 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
							gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, GEE_TYPE_COLLECTION, GeeCollection), _tmp45_);
#line 8418 "PhotoMetadata.c"
						}
#line 1100 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_g_free0 (canonicalized);
#line 1100 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
						_g_free0 (current_value);
#line 8424 "PhotoMetadata.c"
					}
#line 1100 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_object_unref0 (_current_value_list);
#line 8428 "PhotoMetadata.c"
				}
#line 1082 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_object_unref0 (transformed_values);
#line 1082 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_g_object_unref0 (values);
#line 1082 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_hierarchical_keyword_field_unref0 (field);
#line 8436 "PhotoMetadata.c"
			}
		}
	}
#line 1110 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = h_keywords;
#line 1110 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8444 "PhotoMetadata.c"
}


gboolean photo_metadata_has_orientation (PhotoMetadata* self) {
	gboolean result = FALSE;
	GExiv2Metadata* _tmp0_ = NULL;
	GExiv2Orientation _tmp1_ = 0;
#line 1113 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 1114 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 1114 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = gexiv2_metadata_get_orientation (_tmp0_);
#line 1114 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_ == GEXIV2_ORIENTATION_UNSPECIFIED;
#line 1114 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8462 "PhotoMetadata.c"
}


Orientation photo_metadata_get_orientation (PhotoMetadata* self) {
	Orientation result = 0;
	GExiv2Orientation orientation = 0;
	GExiv2Metadata* _tmp0_ = NULL;
	GExiv2Orientation _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GExiv2Orientation _tmp4_ = 0;
#line 1118 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), 0);
#line 1121 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 1121 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = gexiv2_metadata_get_orientation (_tmp0_);
#line 1121 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	orientation = _tmp1_;
#line 1122 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = orientation;
#line 1122 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_ == GEXIV2_ORIENTATION_UNSPECIFIED) {
#line 1122 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = TRUE;
#line 8488 "PhotoMetadata.c"
	} else {
		GExiv2Orientation _tmp5_ = 0;
#line 1122 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = orientation;
#line 1122 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = _tmp5_ < ORIENTATION_MIN;
#line 8495 "PhotoMetadata.c"
	}
#line 1122 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp3_) {
#line 1122 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = TRUE;
#line 8501 "PhotoMetadata.c"
	} else {
		GExiv2Orientation _tmp6_ = 0;
#line 1123 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = orientation;
#line 1123 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp2_ = _tmp6_ > ORIENTATION_MAX;
#line 8508 "PhotoMetadata.c"
	}
#line 1122 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp2_) {
#line 1124 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = ORIENTATION_TOP_LEFT;
#line 1124 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 8516 "PhotoMetadata.c"
	} else {
		GExiv2Orientation _tmp7_ = 0;
#line 1126 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = orientation;
#line 1126 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = (Orientation) _tmp7_;
#line 1126 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 8525 "PhotoMetadata.c"
	}
}


void photo_metadata_set_orientation (PhotoMetadata* self, Orientation orientation) {
	GExiv2Metadata* _tmp0_ = NULL;
	Orientation _tmp1_ = 0;
#line 1129 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 1131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 1131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = orientation;
#line 1131 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	gexiv2_metadata_set_orientation (_tmp0_, (GExiv2Orientation) _tmp1_);
#line 8541 "PhotoMetadata.c"
}


gboolean photo_metadata_get_gps (PhotoMetadata* self, gdouble* longitude, gchar** long_ref, gdouble* latitude, gchar** lat_ref, gdouble* altitude) {
	gdouble _vala_longitude = 0.0;
	gchar* _vala_long_ref = NULL;
	gdouble _vala_latitude = 0.0;
	gchar* _vala_lat_ref = NULL;
	gdouble _vala_altitude = 0.0;
	gboolean result = FALSE;
	GExiv2Metadata* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gboolean _tmp4_ = FALSE;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 1134 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 1136 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->priv->exiv2;
#line 1136 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = gexiv2_metadata_get_gps_info (_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
#line 1136 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_longitude = _tmp1_;
#line 1136 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_latitude = _tmp2_;
#line 1136 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_altitude = _tmp3_;
#line 1136 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp4_) {
#line 1137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_vala_long_ref);
#line 1137 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_vala_long_ref = NULL;
#line 1138 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_vala_lat_ref);
#line 1138 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_vala_lat_ref = NULL;
#line 1140 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = FALSE;
#line 1140 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (longitude) {
#line 1140 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*longitude = _vala_longitude;
#line 8587 "PhotoMetadata.c"
		}
#line 1140 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (long_ref) {
#line 1140 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*long_ref = _vala_long_ref;
#line 8593 "PhotoMetadata.c"
		} else {
#line 1140 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_g_free0 (_vala_long_ref);
#line 8597 "PhotoMetadata.c"
		}
#line 1140 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (latitude) {
#line 1140 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*latitude = _vala_latitude;
#line 8603 "PhotoMetadata.c"
		}
#line 1140 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (lat_ref) {
#line 1140 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*lat_ref = _vala_lat_ref;
#line 8609 "PhotoMetadata.c"
		} else {
#line 1140 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_g_free0 (_vala_lat_ref);
#line 8613 "PhotoMetadata.c"
		}
#line 1140 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (altitude) {
#line 1140 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*altitude = _vala_altitude;
#line 8619 "PhotoMetadata.c"
		}
#line 1140 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 8623 "PhotoMetadata.c"
	}
#line 1143 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = photo_metadata_get_string (self, "Exif.GPSInfo.GPSLongitudeRef", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1143 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_vala_long_ref);
#line 1143 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_long_ref = _tmp5_;
#line 1144 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = photo_metadata_get_string (self, "Exif.GPSInfo.GPSLatitudeRef", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1144 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_vala_lat_ref);
#line 1144 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_lat_ref = _tmp6_;
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = TRUE;
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (longitude) {
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*longitude = _vala_longitude;
#line 8643 "PhotoMetadata.c"
	}
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (long_ref) {
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*long_ref = _vala_long_ref;
#line 8649 "PhotoMetadata.c"
	} else {
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_vala_long_ref);
#line 8653 "PhotoMetadata.c"
	}
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (latitude) {
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*latitude = _vala_latitude;
#line 8659 "PhotoMetadata.c"
	}
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (lat_ref) {
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*lat_ref = _vala_lat_ref;
#line 8665 "PhotoMetadata.c"
	} else {
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_vala_lat_ref);
#line 8669 "PhotoMetadata.c"
	}
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (altitude) {
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*altitude = _vala_altitude;
#line 8675 "PhotoMetadata.c"
	}
#line 1146 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8679 "PhotoMetadata.c"
}


gboolean photo_metadata_get_exposure (PhotoMetadata* self, MetadataRational* exposure) {
	MetadataRational _vala_exposure = {0};
	gboolean result = FALSE;
	MetadataRational _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
#line 1149 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 1150 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_rational (self, "Exif.Photo.ExposureTime", &_tmp0_);
#line 1150 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_exposure = _tmp0_;
#line 1150 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 1150 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (exposure) {
#line 1150 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*exposure = _vala_exposure;
#line 8700 "PhotoMetadata.c"
	}
#line 1150 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8704 "PhotoMetadata.c"
}


gchar* photo_metadata_get_exposure_string (PhotoMetadata* self) {
	gchar* result = NULL;
	MetadataRational exposure_time = {0};
	MetadataRational _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
#line 1153 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1155 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_rational (self, "Exif.Photo.ExposureTime", &_tmp0_);
#line 1155 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	exposure_time = _tmp0_;
#line 1155 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp1_) {
#line 1156 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 1156 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 8727 "PhotoMetadata.c"
	}
#line 1158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = metadata_rational_is_valid (&exposure_time);
#line 1158 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp2_) {
#line 1159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 1159 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 8737 "PhotoMetadata.c"
	}
#line 1161 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = photo_metadata_get_string_interpreted (self, "Exif.Photo.ExposureTime", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1161 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp3_;
#line 1161 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8745 "PhotoMetadata.c"
}


gboolean photo_metadata_get_iso (PhotoMetadata* self, glong* iso) {
	glong _vala_iso = 0L;
	gboolean result = FALSE;
	gboolean fetched_ok = FALSE;
	glong _tmp0_ = 0L;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	glong _tmp4_ = 0L;
#line 1164 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 1165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_long (self, "Exif.Photo.ISOSpeedRatings", &_tmp0_);
#line 1165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_iso = _tmp0_;
#line 1165 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	fetched_ok = _tmp1_;
#line 1167 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = fetched_ok;
#line 1167 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp2_ == FALSE) {
#line 1168 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = FALSE;
#line 1168 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (iso) {
#line 1168 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*iso = _vala_iso;
#line 8776 "PhotoMetadata.c"
		}
#line 1168 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 8780 "PhotoMetadata.c"
	}
#line 1172 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = _vala_iso;
#line 1172 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_ < ((glong) 6)) {
#line 1172 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = TRUE;
#line 8788 "PhotoMetadata.c"
	} else {
		glong _tmp5_ = 0L;
#line 1172 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = _vala_iso;
#line 1172 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = _tmp5_ > ((glong) 409600);
#line 8795 "PhotoMetadata.c"
	}
#line 1172 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp3_) {
#line 1173 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = FALSE;
#line 1173 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		if (iso) {
#line 1173 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			*iso = _vala_iso;
#line 8805 "PhotoMetadata.c"
		}
#line 1173 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 8809 "PhotoMetadata.c"
	}
#line 1175 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = TRUE;
#line 1175 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (iso) {
#line 1175 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*iso = _vala_iso;
#line 8817 "PhotoMetadata.c"
	}
#line 1175 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8821 "PhotoMetadata.c"
}


gchar* photo_metadata_get_iso_string (PhotoMetadata* self) {
	gchar* result = NULL;
	glong iso = 0L;
	glong _tmp0_ = 0L;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp2_ = NULL;
#line 1178 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1180 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_iso (self, &_tmp0_);
#line 1180 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	iso = _tmp0_;
#line 1180 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp1_) {
#line 1181 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 1181 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 8843 "PhotoMetadata.c"
	}
#line 1183 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = photo_metadata_get_string_interpreted (self, "Exif.Photo.ISOSpeedRatings", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1183 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp2_;
#line 1183 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8851 "PhotoMetadata.c"
}


gboolean photo_metadata_get_aperture (PhotoMetadata* self, MetadataRational* aperture) {
	MetadataRational _vala_aperture = {0};
	gboolean result = FALSE;
	MetadataRational _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
#line 1186 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 1187 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_rational (self, "Exif.Photo.FNumber", &_tmp0_);
#line 1187 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_aperture = _tmp0_;
#line 1187 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 1187 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (aperture) {
#line 1187 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*aperture = _vala_aperture;
#line 8872 "PhotoMetadata.c"
	}
#line 1187 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8876 "PhotoMetadata.c"
}


gchar* photo_metadata_get_aperture_string (PhotoMetadata* self, gboolean pango_formatted) {
	gchar* result = NULL;
	MetadataRational aperture = {0};
	MetadataRational _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	gdouble aperture_value = 0.0;
	MetadataRational _tmp2_ = {0};
	gint _tmp3_ = 0;
	MetadataRational _tmp4_ = {0};
	gint _tmp5_ = 0;
	gdouble _tmp6_ = 0.0;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
#line 1190 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1192 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_aperture (self, &_tmp0_);
#line 1192 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	aperture = _tmp0_;
#line 1192 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (!_tmp1_) {
#line 1193 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = NULL;
#line 1193 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 8912 "PhotoMetadata.c"
	}
#line 1195 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = aperture;
#line 1195 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = _tmp2_.numerator;
#line 1195 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = aperture;
#line 1195 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = _tmp4_.denominator;
#line 1195 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	aperture_value = ((gdouble) _tmp3_) / ((gdouble) _tmp5_);
#line 1196 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = aperture_value;
#line 1196 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	aperture_value = ((gint) (_tmp6_ * 10.0)) / 10.0;
#line 1198 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = pango_formatted;
#line 1198 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp8_) {
#line 1198 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = "<i>f</i>/";
#line 8934 "PhotoMetadata.c"
	} else {
#line 1198 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = "f/";
#line 8938 "PhotoMetadata.c"
	}
#line 1199 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = aperture_value;
#line 1199 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (fmod (_tmp10_, 1) == ((gdouble) 0)) {
#line 1199 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = "%.0f";
#line 8946 "PhotoMetadata.c"
	} else {
#line 1199 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = "%.1f";
#line 8950 "PhotoMetadata.c"
	}
#line 1198 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = aperture_value;
#line 1198 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12_ = g_strdup_printf (_tmp9_, _tmp11_);
#line 1198 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13_ = _tmp12_;
#line 1198 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14_ = g_strconcat (_tmp7_, _tmp13_, NULL);
#line 1198 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp15_ = _tmp14_;
#line 1198 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp13_);
#line 1198 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp15_;
#line 1198 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8968 "PhotoMetadata.c"
}


gchar* photo_metadata_get_camera_make (PhotoMetadata* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 1202 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1203 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_string_interpreted (self, "Exif.Image.Make", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1203 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 1203 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8983 "PhotoMetadata.c"
}


gchar* photo_metadata_get_camera_model (PhotoMetadata* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 1206 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1207 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_string_interpreted (self, "Exif.Image.Model", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1207 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 1207 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 8998 "PhotoMetadata.c"
}


gboolean photo_metadata_get_flash (PhotoMetadata* self, glong* flash) {
	glong _vala_flash = 0L;
	gboolean result = FALSE;
	glong _tmp0_ = 0L;
	gboolean _tmp1_ = FALSE;
#line 1210 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 1212 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_long (self, "Exif.Photo.Flash", &_tmp0_);
#line 1212 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_flash = _tmp0_;
#line 1212 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 1212 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (flash) {
#line 1212 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*flash = _vala_flash;
#line 9019 "PhotoMetadata.c"
	}
#line 1212 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9023 "PhotoMetadata.c"
}


gchar* photo_metadata_get_flash_string (PhotoMetadata* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 1215 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1217 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_string_interpreted (self, "Exif.Photo.Flash", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1217 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 1217 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9038 "PhotoMetadata.c"
}


gboolean photo_metadata_get_focal_length (PhotoMetadata* self, MetadataRational* focal_length) {
	MetadataRational _vala_focal_length = {0};
	gboolean result = FALSE;
	MetadataRational _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
#line 1220 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), FALSE);
#line 1221 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_rational (self, "Exif.Photo.FocalLength", &_tmp0_);
#line 1221 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_focal_length = _tmp0_;
#line 1221 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 1221 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (focal_length) {
#line 1221 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*focal_length = _vala_focal_length;
#line 9059 "PhotoMetadata.c"
	}
#line 1221 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9063 "PhotoMetadata.c"
}


gchar* photo_metadata_get_focal_length_string (PhotoMetadata* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 1224 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1225 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_string_interpreted (self, "Exif.Photo.FocalLength", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1225 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 1225 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9078 "PhotoMetadata.c"
}


gchar* photo_metadata_get_artist (PhotoMetadata* self) {
	gchar* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar* _tmp1_ = NULL;
#line 1234 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1235 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_ARTIST_TAGS;
#line 1235 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_ARTIST_TAGS_length1;
#line 1235 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_first_string_interpreted (self, _tmp0_, _tmp0__length1);
#line 1235 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp1_;
#line 1235 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9099 "PhotoMetadata.c"
}


gchar* photo_metadata_get_copyright (PhotoMetadata* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 1238 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1239 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_string_interpreted (self, "Exif.Image.Copyright", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1239 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 1239 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9114 "PhotoMetadata.c"
}


gchar* photo_metadata_get_software (PhotoMetadata* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 1242 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_string_interpreted (self, "Exif.Image.Software", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 1243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9129 "PhotoMetadata.c"
}


void photo_metadata_set_software (PhotoMetadata* self, const gchar* software, const gchar* version) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 1246 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 1246 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (software != NULL);
#line 1246 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (version != NULL);
#line 1248 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = software;
#line 1248 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = version;
#line 1248 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = g_strdup_printf ("%s %s", _tmp0_, _tmp1_);
#line 1248 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = _tmp2_;
#line 1248 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_string (self, "Exif.Image.Software", _tmp3_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1248 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp3_);
#line 1250 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = photo_metadata_has_iptc (self);
#line 1250 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp4_) {
#line 9161 "PhotoMetadata.c"
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 1251 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = software;
#line 1251 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_string (self, "Iptc.Application2.Program", _tmp5_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1252 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = version;
#line 1252 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_string (self, "Iptc.Application2.ProgramVersion", _tmp6_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 9172 "PhotoMetadata.c"
	}
}


void photo_metadata_remove_software (PhotoMetadata* self) {
#line 1256 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 1257 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_remove_tag (self, "Exif.Image.Software");
#line 1258 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_remove_tag (self, "Iptc.Application2.Program");
#line 1259 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_remove_tag (self, "Iptc.Application2.ProgramVersion");
#line 9186 "PhotoMetadata.c"
}


gchar* photo_metadata_get_exposure_bias (PhotoMetadata* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 1262 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), NULL);
#line 1263 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_get_string_interpreted (self, "Exif.Photo.ExposureBiasValue", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1263 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp0_;
#line 1263 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9201 "PhotoMetadata.c"
}


Rating photo_metadata_get_rating (PhotoMetadata* self) {
	Rating result = 0;
	gchar* rating_string = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gint int_percent_rating = 0;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	Rating _tmp18_ = 0;
#line 1274 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (self), 0);
#line 1275 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = photo_metadata_RATING_TAGS;
#line 1275 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0__length1 = photo_metadata_RATING_TAGS_length1;
#line 1275 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = photo_metadata_get_first_string (self, _tmp0_, _tmp0__length1);
#line 1275 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	rating_string = _tmp1_;
#line 1276 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = rating_string;
#line 1276 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp2_ != NULL) {
#line 9232 "PhotoMetadata.c"
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		Rating _tmp5_ = 0;
#line 1277 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp3_ = rating_string;
#line 1277 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = atoi (_tmp3_);
#line 1277 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp5_ = rating_unserialize (_tmp4_);
#line 1277 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = _tmp5_;
#line 1277 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (rating_string);
#line 1277 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 9248 "PhotoMetadata.c"
	}
#line 1279 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = photo_metadata_get_string (self, "Exif.Image.RatingPercent", PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1279 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (rating_string);
#line 1279 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	rating_string = _tmp6_;
#line 1280 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = rating_string;
#line 1280 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp7_ == NULL) {
#line 1281 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		result = RATING_UNRATED;
#line 1281 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (rating_string);
#line 1281 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		return result;
#line 9266 "PhotoMetadata.c"
	}
#line 1284 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = rating_string;
#line 1284 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = atoi (_tmp8_);
#line 1284 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	int_percent_rating = _tmp9_;
#line 9274 "PhotoMetadata.c"
	{
		gint i = 0;
#line 1285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		i = 5;
#line 9279 "PhotoMetadata.c"
		{
			gboolean _tmp10_ = FALSE;
#line 1285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			_tmp10_ = TRUE;
#line 1285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
			while (TRUE) {
#line 9286 "PhotoMetadata.c"
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
#line 1285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!_tmp10_) {
#line 9293 "PhotoMetadata.c"
					gint _tmp11_ = 0;
#line 1285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp11_ = i;
#line 1285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					i = _tmp11_ - 1;
#line 9299 "PhotoMetadata.c"
				}
#line 1285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp10_ = FALSE;
#line 1285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp12_ = i;
#line 1285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (!(_tmp12_ >= 0)) {
#line 1285 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					break;
#line 9309 "PhotoMetadata.c"
				}
#line 1286 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp13_ = int_percent_rating;
#line 1286 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp14_ = i;
#line 1286 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				_tmp15_ = RESOURCES_rating_thresholds[_tmp14_];
#line 1286 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
				if (_tmp13_ >= _tmp15_) {
#line 9319 "PhotoMetadata.c"
					gint _tmp16_ = 0;
					Rating _tmp17_ = 0;
#line 1287 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp16_ = i;
#line 1287 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_tmp17_ = rating_unserialize (_tmp16_);
#line 1287 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					result = _tmp17_;
#line 1287 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					_g_free0 (rating_string);
#line 1287 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
					return result;
#line 9332 "PhotoMetadata.c"
				}
			}
		}
	}
#line 1289 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp18_ = rating_unserialize (-1);
#line 1289 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp18_;
#line 1289 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (rating_string);
#line 1289 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9345 "PhotoMetadata.c"
}


void photo_metadata_set_rating (PhotoMetadata* self, Rating rating) {
	gint int_rating = 0;
	Rating _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
#line 1297 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_if_fail (IS_PHOTO_METADATA (self));
#line 1298 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = rating;
#line 1298 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = rating_serialize (_tmp0_);
#line 1298 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	int_rating = _tmp1_;
#line 1299 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = int_rating;
#line 1299 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
#line 1299 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = _tmp3_;
#line 1299 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_string (self, "Xmp.xmp.Rating", _tmp4_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1299 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp4_);
#line 1300 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = int_rating;
#line 1300 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = g_strdup_printf ("%i", _tmp5_);
#line 1300 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = _tmp6_;
#line 1300 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_set_string (self, "Exif.Image.Rating", _tmp7_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1300 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (_tmp7_);
#line 1302 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = int_rating;
#line 1302 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (0 <= _tmp8_) {
#line 9392 "PhotoMetadata.c"
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 1303 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp9_ = int_rating;
#line 1303 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp10_ = RESOURCES_rating_thresholds[_tmp9_];
#line 1303 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp11_ = g_strdup_printf ("%i", _tmp10_);
#line 1303 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp12_ = _tmp11_;
#line 1303 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_string (self, "Exif.Image.RatingPercent", _tmp12_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1303 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_tmp12_);
#line 9409 "PhotoMetadata.c"
	} else {
		gint _tmp13_ = 0;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
#line 1305 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp13_ = int_rating;
#line 1305 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp14_ = g_strdup_printf ("%i", _tmp13_);
#line 1305 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp15_ = _tmp14_;
#line 1305 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		photo_metadata_set_string (self, "Exif.Image.RatingPercent", _tmp15_, PHOTO_METADATA_PREPARE_STRING_OPTIONS);
#line 1305 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_g_free0 (_tmp15_);
#line 9424 "PhotoMetadata.c"
	}
}


static gpointer _media_metadata_ref0 (gpointer self) {
#line 235 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self ? media_metadata_ref (self) : NULL;
#line 9432 "PhotoMetadata.c"
}


static PhotoMetadataInternalPhotoPreview* photo_metadata_internal_photo_preview_construct (GType object_type, PhotoMetadata* owner, const gchar* name, guint number, GExiv2PreviewProperties* props) {
	PhotoMetadataInternalPhotoPreview* self = NULL;
	const gchar* _tmp0_ = NULL;
	GExiv2PreviewProperties* _tmp1_ = NULL;
	guint32 _tmp2_ = 0U;
	GExiv2PreviewProperties* _tmp3_ = NULL;
	guint32 _tmp4_ = 0U;
	Dimensions _tmp5_ = {0};
	GExiv2PreviewProperties* _tmp6_ = NULL;
	guint32 _tmp7_ = 0U;
	GExiv2PreviewProperties* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GExiv2PreviewProperties* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	PhotoMetadata* _tmp12_ = NULL;
	PhotoMetadata* _tmp13_ = NULL;
	guint _tmp14_ = 0U;
#line 230 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (owner), NULL);
#line 230 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 230 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_return_val_if_fail (GEXIV2_IS_PREVIEW_PROPERTIES (props), NULL);
#line 232 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = name;
#line 232 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = props;
#line 232 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = gexiv2_preview_properties_get_width (_tmp1_);
#line 232 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = props;
#line 232 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = gexiv2_preview_properties_get_height (_tmp3_);
#line 232 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	dimensions_init (&_tmp5_, (gint) _tmp2_, (gint) _tmp4_);
#line 232 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = props;
#line 232 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = gexiv2_preview_properties_get_size (_tmp6_);
#line 232 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = props;
#line 232 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = gexiv2_preview_properties_get_mime_type (_tmp8_);
#line 232 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = props;
#line 232 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = gexiv2_preview_properties_get_extension (_tmp10_);
#line 232 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = (PhotoMetadataInternalPhotoPreview*) photo_preview_construct (object_type, _tmp0_, &_tmp5_, _tmp7_, _tmp9_, _tmp11_);
#line 235 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12_ = owner;
#line 235 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13_ = _media_metadata_ref0 (_tmp12_);
#line 235 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_media_metadata_unref0 (self->owner);
#line 235 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->owner = _tmp13_;
#line 236 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14_ = number;
#line 236 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->number = _tmp14_;
#line 230 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return self;
#line 9499 "PhotoMetadata.c"
}


static PhotoMetadataInternalPhotoPreview* photo_metadata_internal_photo_preview_new (PhotoMetadata* owner, const gchar* name, guint number, GExiv2PreviewProperties* props) {
#line 230 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return photo_metadata_internal_photo_preview_construct (PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW, owner, name, number, props);
#line 9506 "PhotoMetadata.c"
}


static guint8* _vala_array_dup6 (guint8* self, int length) {
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 9513 "PhotoMetadata.c"
}


static guint8* photo_metadata_internal_photo_preview_real_flatten (PhotoPreview* base, int* result_length1, GError** error) {
	PhotoMetadataInternalPhotoPreview * self;
	guint8* result = NULL;
	GExiv2PreviewProperties** props = NULL;
	PhotoMetadata* _tmp0_ = NULL;
	GExiv2Metadata* _tmp1_ = NULL;
	GExiv2PreviewProperties** _tmp2_ = NULL;
	GExiv2PreviewProperties** _tmp3_ = NULL;
	gint props_length1 = 0;
	gint _props_size_ = 0;
	gboolean _tmp4_ = FALSE;
	GExiv2PreviewProperties** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	PhotoMetadata* _tmp8_ = NULL;
	GExiv2Metadata* _tmp9_ = NULL;
	GExiv2PreviewProperties** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	guint _tmp11_ = 0U;
	GExiv2PreviewProperties* _tmp12_ = NULL;
	GExiv2PreviewImage* _tmp13_ = NULL;
	GExiv2PreviewImage* _tmp14_ = NULL;
	guint32 _tmp15_;
	guint8* _tmp16_ = NULL;
	guint8* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	guint8* _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	guint8* _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
#line 239 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW, PhotoMetadataInternalPhotoPreview);
#line 240 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = self->owner;
#line 240 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = _tmp0_->priv->exiv2;
#line 240 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = _tmp2_ = gexiv2_metadata_get_preview_properties (_tmp1_);
#line 240 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	props = _tmp3_;
#line 240 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	props_length1 = _vala_array_length (_tmp2_);
#line 240 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_props_size_ = props_length1;
#line 241 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = props;
#line 241 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5__length1 = props_length1;
#line 241 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (_tmp5_ != NULL) {
#line 9566 "PhotoMetadata.c"
		GExiv2PreviewProperties** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		guint _tmp7_ = 0U;
#line 241 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6_ = props;
#line 241 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp6__length1 = props_length1;
#line 241 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp7_ = self->number;
#line 241 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = ((guint) _tmp6__length1) > _tmp7_;
#line 9578 "PhotoMetadata.c"
	} else {
#line 241 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		_tmp4_ = FALSE;
#line 9582 "PhotoMetadata.c"
	}
#line 241 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_vala_assert (_tmp4_, "props != null && props.length > number");
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = self->owner;
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = _tmp8_->priv->exiv2;
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = props;
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10__length1 = props_length1;
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = self->number;
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12_ = _tmp10_[_tmp11_];
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13_ = gexiv2_metadata_get_preview_image (_tmp9_, _tmp12_);
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14_ = _tmp13_;
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp16_ = gexiv2_preview_image_get_data (_tmp14_, &_tmp15_);
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp17_ = (_tmp16_ != NULL) ? _vala_array_dup6 (_tmp16_, _tmp15_) : ((gpointer) _tmp16_);
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp17__length1 = _tmp15_;
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp18_ = _tmp17_;
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp18__length1 = _tmp17__length1;
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (_tmp14_);
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp19_ = _tmp18_;
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp19__length1 = _tmp18__length1;
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	if (result_length1) {
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
		*result_length1 = _tmp19__length1;
#line 9622 "PhotoMetadata.c"
	}
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	result = _tmp19_;
#line 243 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	return result;
#line 9628 "PhotoMetadata.c"
}


static void photo_metadata_internal_photo_preview_class_init (PhotoMetadataInternalPhotoPreviewClass * klass) {
#line 226 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_internal_photo_preview_parent_class = g_type_class_peek_parent (klass);
#line 226 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((PhotoPreviewClass *) klass)->finalize = photo_metadata_internal_photo_preview_finalize;
#line 226 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((PhotoPreviewClass *) klass)->flatten = photo_metadata_internal_photo_preview_real_flatten;
#line 9639 "PhotoMetadata.c"
}


static void photo_metadata_internal_photo_preview_instance_init (PhotoMetadataInternalPhotoPreview * self) {
}


static void photo_metadata_internal_photo_preview_finalize (PhotoPreview* obj) {
	PhotoMetadataInternalPhotoPreview * self;
#line 226 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_METADATA_TYPE_INTERNAL_PHOTO_PREVIEW, PhotoMetadataInternalPhotoPreview);
#line 227 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_media_metadata_unref0 (self->owner);
#line 226 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	PHOTO_PREVIEW_CLASS (photo_metadata_internal_photo_preview_parent_class)->finalize (obj);
#line 9655 "PhotoMetadata.c"
}


static GType photo_metadata_internal_photo_preview_get_type (void) {
	static volatile gsize photo_metadata_internal_photo_preview_type_id__volatile = 0;
	if (g_once_init_enter (&photo_metadata_internal_photo_preview_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoMetadataInternalPhotoPreviewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_metadata_internal_photo_preview_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoMetadataInternalPhotoPreview), 0, (GInstanceInitFunc) photo_metadata_internal_photo_preview_instance_init, NULL };
		GType photo_metadata_internal_photo_preview_type_id;
		photo_metadata_internal_photo_preview_type_id = g_type_register_static (TYPE_PHOTO_PREVIEW, "PhotoMetadataInternalPhotoPreview", &g_define_type_info, 0);
		g_once_init_leave (&photo_metadata_internal_photo_preview_type_id__volatile, photo_metadata_internal_photo_preview_type_id);
	}
	return photo_metadata_internal_photo_preview_type_id__volatile;
}


static void photo_metadata_class_init (PhotoMetadataClass * klass) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar** _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar** _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar** _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar** _tmp37_ = NULL;
	NullKeywordTransformer* _tmp38_ = NULL;
	NullKeywordTransformer* _tmp39_ = NULL;
	HierarchicalKeywordField* _tmp40_ = NULL;
	NullKeywordTransformer* _tmp41_ = NULL;
	NullKeywordTransformer* _tmp42_ = NULL;
	HierarchicalKeywordField* _tmp43_ = NULL;
	ACDSeeKeywordTransformer* _tmp44_ = NULL;
	ACDSeeKeywordTransformer* _tmp45_ = NULL;
	HierarchicalKeywordField* _tmp46_ = NULL;
	NullKeywordTransformer* _tmp47_ = NULL;
	NullKeywordTransformer* _tmp48_ = NULL;
	HierarchicalKeywordField* _tmp49_ = NULL;
	NullKeywordTransformer* _tmp50_ = NULL;
	NullKeywordTransformer* _tmp51_ = NULL;
	HierarchicalKeywordField* _tmp52_ = NULL;
	HierarchicalKeywordField** _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
	gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	gchar** _tmp57_ = NULL;
	gchar* _tmp58_ = NULL;
	gchar* _tmp59_ = NULL;
	gchar* _tmp60_ = NULL;
	gchar* _tmp61_ = NULL;
	gchar* _tmp62_ = NULL;
	gchar** _tmp63_ = NULL;
#line 211 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_parent_class = g_type_class_peek_parent (klass);
#line 211 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((MediaMetadataClass *) klass)->finalize = photo_metadata_finalize;
#line 211 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	g_type_class_add_private (klass, sizeof (PhotoMetadataPrivate));
#line 211 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((MediaMetadataClass *) klass)->read_from_file = photo_metadata_real_read_from_file;
#line 211 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((MediaMetadataClass *) klass)->get_creation_date_time = photo_metadata_real_get_creation_date_time;
#line 211 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((MediaMetadataClass *) klass)->get_title = photo_metadata_real_get_title;
#line 211 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	((MediaMetadataClass *) klass)->get_comment = photo_metadata_real_get_comment;
#line 786 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = g_strdup ("Exif.Image.DateTime");
#line 786 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup ("Xmp.tiff.DateTime");
#line 786 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp2_ = g_strdup ("Xmp.xmp.ModifyDate");
#line 786 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp3_ = g_strdup ("Xmp.acdsee.datetime");
#line 786 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_ = g_new0 (gchar*, 4 + 1);
#line 786 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_[0] = _tmp0_;
#line 786 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_[1] = _tmp1_;
#line 786 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_[2] = _tmp2_;
#line 786 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp4_[3] = _tmp3_;
#line 786 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_DATE_TIME_TAGS = _tmp4_;
#line 786 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_DATE_TIME_TAGS_length1 = 4;
#line 805 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp5_ = g_strdup ("Exif.Photo.DateTimeOriginal");
#line 805 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp6_ = g_strdup ("Xmp.exif.DateTimeOriginal");
#line 805 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp7_ = g_strdup ("Xmp.xmp.CreateDate");
#line 805 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp8_ = g_strdup ("Exif.Photo.DateTimeDigitized");
#line 805 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp9_ = g_strdup ("Xmp.exif.DateTimeDigitized");
#line 805 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp10_ = g_strdup ("Exif.Image.DateTime");
#line 805 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_ = g_new0 (gchar*, 6 + 1);
#line 805 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_[0] = _tmp5_;
#line 805 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_[1] = _tmp6_;
#line 805 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_[2] = _tmp7_;
#line 805 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_[3] = _tmp8_;
#line 805 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_[4] = _tmp9_;
#line 805 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp11_[5] = _tmp10_;
#line 805 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_EXPOSURE_DATE_TIME_TAGS = _tmp11_;
#line 805 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_EXPOSURE_DATE_TIME_TAGS_length1 = 6;
#line 826 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp12_ = g_strdup ("Exif.Photo.DateTimeDigitized");
#line 826 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp13_ = g_strdup ("Xmp.exif.DateTimeDigitized");
#line 826 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14_ = g_new0 (gchar*, 2 + 1);
#line 826 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14_[0] = _tmp12_;
#line 826 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp14_[1] = _tmp13_;
#line 826 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_DIGITIZED_DATE_TIME_TAGS = _tmp14_;
#line 826 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_DIGITIZED_DATE_TIME_TAGS_length1 = 2;
#line 851 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp15_ = g_strdup ("Exif.Photo.PixelXDimension");
#line 851 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp16_ = g_strdup ("Xmp.exif.PixelXDimension");
#line 851 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp17_ = g_strdup ("Xmp.tiff.ImageWidth");
#line 851 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp18_ = g_strdup ("Xmp.exif.PixelXDimension");
#line 851 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp19_ = g_new0 (gchar*, 4 + 1);
#line 851 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp19_[0] = _tmp15_;
#line 851 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp19_[1] = _tmp16_;
#line 851 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp19_[2] = _tmp17_;
#line 851 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp19_[3] = _tmp18_;
#line 851 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_WIDTH_TAGS = _tmp19_;
#line 851 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_WIDTH_TAGS_length1 = 4;
#line 858 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp20_ = g_strdup ("Exif.Photo.PixelYDimension");
#line 858 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp21_ = g_strdup ("Xmp.exif.PixelYDimension");
#line 858 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp22_ = g_strdup ("Xmp.tiff.ImageHeight");
#line 858 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp23_ = g_strdup ("Xmp.exif.PixelYDimension");
#line 858 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp24_ = g_new0 (gchar*, 4 + 1);
#line 858 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp24_[0] = _tmp20_;
#line 858 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp24_[1] = _tmp21_;
#line 858 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp24_[2] = _tmp22_;
#line 858 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp24_[3] = _tmp23_;
#line 858 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_HEIGHT_TAGS = _tmp24_;
#line 858 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_HEIGHT_TAGS_length1 = 4;
#line 917 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp25_ = g_strdup ("Iptc.Application2.Caption");
#line 917 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp26_ = g_strdup ("Xmp.dc.title");
#line 917 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp27_ = g_strdup ("Iptc.Application2.Headline");
#line 917 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp28_ = g_strdup ("Xmp.photoshop.Headline");
#line 917 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp29_ = g_strdup ("Xmp.acdsee.caption");
#line 917 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp30_ = g_new0 (gchar*, 5 + 1);
#line 917 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp30_[0] = _tmp25_;
#line 917 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp30_[1] = _tmp26_;
#line 917 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp30_[2] = _tmp27_;
#line 917 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp30_[3] = _tmp28_;
#line 917 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp30_[4] = _tmp29_;
#line 917 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_STANDARD_TITLE_TAGS = _tmp30_;
#line 917 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_STANDARD_TITLE_TAGS_length1 = 5;
#line 962 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp31_ = g_strdup ("Exif.Photo.UserComment");
#line 962 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp32_ = g_strdup ("Xmp.acdsee.notes");
#line 962 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp33_ = g_new0 (gchar*, 2 + 1);
#line 962 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp33_[0] = _tmp31_;
#line 962 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp33_[1] = _tmp32_;
#line 962 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_COMMENT_TAGS = _tmp33_;
#line 962 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_COMMENT_TAGS_length1 = 2;
#line 979 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp34_ = g_strdup ("Xmp.dc.subject");
#line 979 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp35_ = g_strdup ("Iptc.Application2.Keywords");
#line 979 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp36_ = g_strdup ("Xmp.xmp.Label");
#line 979 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp37_ = g_new0 (gchar*, 3 + 1);
#line 979 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp37_[0] = _tmp34_;
#line 979 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp37_[1] = _tmp35_;
#line 979 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp37_[2] = _tmp36_;
#line 979 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_KEYWORD_TAGS = _tmp37_;
#line 979 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_KEYWORD_TAGS_length1 = 3;
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp38_ = null_keyword_transformer_new ();
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp39_ = _tmp38_;
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp40_ = hierarchical_keyword_field_new ("Xmp.lr.hierarchicalSubject", "|", FALSE, FALSE, G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, TYPE_KEYWORD_TRANSFORMER, KeywordTransformer));
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp41_ = null_keyword_transformer_new ();
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp42_ = _tmp41_;
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp43_ = hierarchical_keyword_field_new ("Xmp.acdsee.keywords", "|", FALSE, FALSE, G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, TYPE_KEYWORD_TRANSFORMER, KeywordTransformer));
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp44_ = acd_see_keyword_transformer_new ();
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp45_ = _tmp44_;
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp46_ = hierarchical_keyword_field_new ("Xmp.acdsee.categories", "|", FALSE, FALSE, G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, TYPE_KEYWORD_TRANSFORMER, KeywordTransformer));
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp47_ = null_keyword_transformer_new ();
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp48_ = _tmp47_;
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp49_ = hierarchical_keyword_field_new ("Xmp.digiKam.TagsList", "/", FALSE, TRUE, G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, TYPE_KEYWORD_TRANSFORMER, KeywordTransformer));
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp50_ = null_keyword_transformer_new ();
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp51_ = _tmp50_;
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp52_ = hierarchical_keyword_field_new ("Xmp.MicrosoftPhoto.LastKeywordXMP", "/", FALSE, TRUE, G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, TYPE_KEYWORD_TRANSFORMER, KeywordTransformer));
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp53_ = g_new0 (HierarchicalKeywordField*, 5 + 1);
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp53_[0] = _tmp40_;
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp53_[1] = _tmp43_;
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp53_[2] = _tmp46_;
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp53_[3] = _tmp49_;
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp53_[4] = _tmp52_;
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_HIERARCHICAL_KEYWORD_TAGS = _tmp53_;
#line 985 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_HIERARCHICAL_KEYWORD_TAGS_length1 = 5;
#line 1228 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp54_ = g_strdup ("Exif.Image.Artist");
#line 1228 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp55_ = g_strdup ("Exif.Canon.OwnerName");
#line 1228 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp56_ = g_strdup ("Xmp.acdsee.author");
#line 1228 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp57_ = g_new0 (gchar*, 3 + 1);
#line 1228 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp57_[0] = _tmp54_;
#line 1228 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp57_[1] = _tmp55_;
#line 1228 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp57_[2] = _tmp56_;
#line 1228 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_ARTIST_TAGS = _tmp57_;
#line 1228 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_ARTIST_TAGS_length1 = 3;
#line 1266 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp58_ = g_strdup ("Xmp.xmp.Rating");
#line 1266 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp59_ = g_strdup ("Iptc.Application2.Urgency");
#line 1266 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp60_ = g_strdup ("Xmp.photoshop.Urgency");
#line 1266 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp61_ = g_strdup ("Exif.Image.Rating");
#line 1266 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp62_ = g_strdup ("Xmp.acdsee.rating");
#line 1266 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp63_ = g_new0 (gchar*, 5 + 1);
#line 1266 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp63_[0] = _tmp58_;
#line 1266 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp63_[1] = _tmp59_;
#line 1266 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp63_[2] = _tmp60_;
#line 1266 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp63_[3] = _tmp61_;
#line 1266 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp63_[4] = _tmp62_;
#line 1266 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_RATING_TAGS = _tmp63_;
#line 1266 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	photo_metadata_RATING_TAGS_length1 = 5;
#line 10008 "PhotoMetadata.c"
}


static void photo_metadata_instance_init (PhotoMetadata * self) {
	GExiv2Metadata* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 211 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv = PHOTO_METADATA_GET_PRIVATE (self);
#line 247 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp0_ = gexiv2_metadata_new ();
#line 247 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exiv2 = _tmp0_;
#line 248 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->exif = NULL;
#line 249 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_tmp1_ = g_strdup ("<uninitialized>");
#line 249 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self->priv->source_name = _tmp1_;
#line 10027 "PhotoMetadata.c"
}


static void photo_metadata_finalize (MediaMetadata* obj) {
	PhotoMetadata * self;
#line 211 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_METADATA, PhotoMetadata);
#line 247 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_object_unref0 (self->priv->exiv2);
#line 248 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_exif_data_unref0 (self->priv->exif);
#line 249 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	_g_free0 (self->priv->source_name);
#line 211 "/home/jens/Source/shotwell/src/photos/PhotoMetadata.vala"
	MEDIA_METADATA_CLASS (photo_metadata_parent_class)->finalize (obj);
#line 10043 "PhotoMetadata.c"
}


GType photo_metadata_get_type (void) {
	static volatile gsize photo_metadata_type_id__volatile = 0;
	if (g_once_init_enter (&photo_metadata_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoMetadataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_metadata_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoMetadata), 0, (GInstanceInitFunc) photo_metadata_instance_init, NULL };
		GType photo_metadata_type_id;
		photo_metadata_type_id = g_type_register_static (TYPE_MEDIA_METADATA, "PhotoMetadata", &g_define_type_info, 0);
		g_once_init_leave (&photo_metadata_type_id__volatile, photo_metadata_type_id);
	}
	return photo_metadata_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



