/* Photo.c generated by valac 0.34.7, the Vala compiler
 * generated from Photo.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* Specifies how pixel data is fetched from the backing file on disk.  MASTER is the original*/
/* backing photo of any supported photo file format; SOURCE is either the master or the editable*/
/* file, that is, the appropriate reference file for user display; BASELINE is an appropriate*/
/* file with the proviso that it may be a suitable substitute for the master and/or the editable.*/
/* UNMODIFIED represents the photo with no edits, i.e. the head of the pipeline.*/
/**/
/* In general, callers want to use the BASELINE unless requirements are specific.*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <time.h>
#include <glib/gstdio.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <gobject/gvaluecollector.h>


#define TYPE_BACKING_FETCH_MODE (backing_fetch_mode_get_type ())

#define TYPE_PHOTO_IMPORT_PARAMS (photo_import_params_get_type ())
#define PHOTO_IMPORT_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_IMPORT_PARAMS, PhotoImportParams))
#define PHOTO_IMPORT_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_IMPORT_PARAMS, PhotoImportParamsClass))
#define IS_PHOTO_IMPORT_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_IMPORT_PARAMS))
#define IS_PHOTO_IMPORT_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_IMPORT_PARAMS))
#define PHOTO_IMPORT_PARAMS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_IMPORT_PARAMS, PhotoImportParamsClass))

typedef struct _PhotoImportParams PhotoImportParams;
typedef struct _PhotoImportParamsClass PhotoImportParamsClass;
typedef struct _PhotoImportParamsPrivate PhotoImportParamsPrivate;

#define TYPE_IMPORT_ID (import_id_get_type ())
typedef struct _ImportID ImportID;

#define PHOTO_FILE_SNIFFER_TYPE_OPTIONS (photo_file_sniffer_options_get_type ())

#define TYPE_THUMBNAILS (thumbnails_get_type ())
#define THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAILS, Thumbnails))
#define THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAILS, ThumbnailsClass))
#define IS_THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAILS))
#define IS_THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAILS))
#define THUMBNAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAILS, ThumbnailsClass))

typedef struct _Thumbnails Thumbnails;
typedef struct _ThumbnailsClass ThumbnailsClass;

#define TYPE_PHOTO_ROW (photo_row_get_type ())
#define PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_ROW, PhotoRow))
#define PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_ROW, PhotoRowClass))
#define IS_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_ROW))
#define IS_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_ROW))
#define PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_ROW, PhotoRowClass))

typedef struct _PhotoRow PhotoRow;
typedef struct _PhotoRowClass PhotoRowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _thumbnails_unref0(var) ((var == NULL) ? NULL : (var = (thumbnails_unref (var), NULL)))
#define _photo_row_unref0(var) ((var == NULL) ? NULL : (var = (photo_row_unref (var), NULL)))
typedef struct _ParamSpecPhotoImportParams ParamSpecPhotoImportParams;

#define TYPE_PHOTO_TRANSFORMATION_STATE (photo_transformation_state_get_type ())
#define PHOTO_TRANSFORMATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationState))
#define PHOTO_TRANSFORMATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationStateClass))
#define IS_PHOTO_TRANSFORMATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_TRANSFORMATION_STATE))
#define IS_PHOTO_TRANSFORMATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_TRANSFORMATION_STATE))
#define PHOTO_TRANSFORMATION_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationStateClass))

typedef struct _PhotoTransformationState PhotoTransformationState;
typedef struct _PhotoTransformationStateClass PhotoTransformationStateClass;
typedef struct _PhotoTransformationStatePrivate PhotoTransformationStatePrivate;

#define TYPE_RATING (rating_get_type ())

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;
typedef struct _DataSourcePrivate DataSourcePrivate;

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_SOURCE_SNAPSHOT (source_snapshot_get_type ())
#define SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshot))
#define SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))
#define IS_SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_SNAPSHOT))
#define IS_SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_SNAPSHOT))
#define SOURCE_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))

typedef struct _SourceSnapshot SourceSnapshot;
typedef struct _SourceSnapshotClass SourceSnapshotClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;
typedef struct _ThumbnailSourcePrivate ThumbnailSourcePrivate;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_INDEXABLE (indexable_get_type ())
#define INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDEXABLE, Indexable))
#define IS_INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDEXABLE))
#define INDEXABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_INDEXABLE, IndexableIface))

typedef struct _Indexable Indexable;
typedef struct _IndexableIface IndexableIface;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
typedef struct _MediaSourcePrivate MediaSourcePrivate;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;

#define TYPE_BACKING_FILE_STATE (backing_file_state_get_type ())
#define BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_FILE_STATE, BackingFileState))
#define BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_FILE_STATE, BackingFileStateClass))
#define IS_BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_FILE_STATE))
#define IS_BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_FILE_STATE))
#define BACKING_FILE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_FILE_STATE, BackingFileStateClass))

typedef struct _BackingFileState BackingFileState;
typedef struct _BackingFileStateClass BackingFileStateClass;

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_SCALING (scaling_get_type ())

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())
typedef struct _Scaling Scaling;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;
typedef struct _PhotoSourcePrivate PhotoSourcePrivate;

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;

#define TYPE_DATEABLE (dateable_get_type ())
#define DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATEABLE, Dateable))
#define IS_DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATEABLE))
#define DATEABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_DATEABLE, DateableIface))

typedef struct _Dateable Dateable;
typedef struct _DateableIface DateableIface;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;
typedef struct _PhotoPrivate PhotoPrivate;

#define TYPE_ROTATION (rotation_get_type ())

#define TYPE_BACKING_PHOTO_ROW (backing_photo_row_get_type ())
#define BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRow))
#define BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))
#define IS_BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_ROW))
#define IS_BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_ROW))
#define BACKING_PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))

typedef struct _BackingPhotoRow BackingPhotoRow;
typedef struct _BackingPhotoRowClass BackingPhotoRowClass;

#define PHOTO_TYPE_BACKING_READERS (photo_backing_readers_get_type ())
#define PHOTO_BACKING_READERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_BACKING_READERS, PhotoBackingReaders))
#define PHOTO_BACKING_READERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_BACKING_READERS, PhotoBackingReadersClass))
#define PHOTO_IS_BACKING_READERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_BACKING_READERS))
#define PHOTO_IS_BACKING_READERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_BACKING_READERS))
#define PHOTO_BACKING_READERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_BACKING_READERS, PhotoBackingReadersClass))

typedef struct _PhotoBackingReaders PhotoBackingReaders;
typedef struct _PhotoBackingReadersClass PhotoBackingReadersClass;

#define TYPE_PIXEL_TRANSFORMER (pixel_transformer_get_type ())
#define PIXEL_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXEL_TRANSFORMER, PixelTransformer))
#define PIXEL_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXEL_TRANSFORMER, PixelTransformerClass))
#define IS_PIXEL_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXEL_TRANSFORMER))
#define IS_PIXEL_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXEL_TRANSFORMER))
#define PIXEL_TRANSFORMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXEL_TRANSFORMER, PixelTransformerClass))

typedef struct _PixelTransformer PixelTransformer;
typedef struct _PixelTransformerClass PixelTransformerClass;

#define TYPE_PIXEL_TRANSFORMATION_BUNDLE (pixel_transformation_bundle_get_type ())
#define PIXEL_TRANSFORMATION_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXEL_TRANSFORMATION_BUNDLE, PixelTransformationBundle))
#define PIXEL_TRANSFORMATION_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXEL_TRANSFORMATION_BUNDLE, PixelTransformationBundleClass))
#define IS_PIXEL_TRANSFORMATION_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXEL_TRANSFORMATION_BUNDLE))
#define IS_PIXEL_TRANSFORMATION_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXEL_TRANSFORMATION_BUNDLE))
#define PIXEL_TRANSFORMATION_BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXEL_TRANSFORMATION_BUNDLE, PixelTransformationBundleClass))

typedef struct _PixelTransformationBundle PixelTransformationBundle;
typedef struct _PixelTransformationBundleClass PixelTransformationBundleClass;

#define TYPE_ONE_SHOT_SCHEDULER (one_shot_scheduler_get_type ())
#define ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotScheduler))
#define ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))
#define IS_ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ONE_SHOT_SCHEDULER))
#define IS_ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ONE_SHOT_SCHEDULER))
#define ONE_SHOT_SCHEDULER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))

typedef struct _OneShotScheduler OneShotScheduler;
typedef struct _OneShotSchedulerClass OneShotSchedulerClass;

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())

#define PHOTO_TYPE_CACHED_PIXBUF (photo_cached_pixbuf_get_type ())
#define PHOTO_CACHED_PIXBUF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_CACHED_PIXBUF, PhotoCachedPixbuf))
#define PHOTO_CACHED_PIXBUF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_CACHED_PIXBUF, PhotoCachedPixbufClass))
#define PHOTO_IS_CACHED_PIXBUF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_CACHED_PIXBUF))
#define PHOTO_IS_CACHED_PIXBUF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_CACHED_PIXBUF))
#define PHOTO_CACHED_PIXBUF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_CACHED_PIXBUF, PhotoCachedPixbufClass))

typedef struct _PhotoCachedPixbuf PhotoCachedPixbuf;
typedef struct _PhotoCachedPixbufClass PhotoCachedPixbufClass;
#define _backing_photo_row_unref0(var) ((var == NULL) ? NULL : (var = (backing_photo_row_unref (var), NULL)))
#define _photo_backing_readers_unref0(var) ((var == NULL) ? NULL : (var = (photo_backing_readers_unref (var), NULL)))
#define _pixel_transformer_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformer_unref (var), NULL)))
#define _pixel_transformation_bundle_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformation_bundle_unref (var), NULL)))
#define _one_shot_scheduler_unref0(var) ((var == NULL) ? NULL : (var = (one_shot_scheduler_unref (var), NULL)))
typedef struct _PhotoRowPrivate PhotoRowPrivate;

#define TYPE_PHOTO_ID (photo_id_get_type ())
typedef struct _PhotoID PhotoID;

#define TYPE_ORIENTATION (orientation_get_type ())

#define TYPE_KEY_VALUE_MAP (key_value_map_get_type ())
#define KEY_VALUE_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY_VALUE_MAP, KeyValueMap))
#define KEY_VALUE_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY_VALUE_MAP, KeyValueMapClass))
#define IS_KEY_VALUE_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY_VALUE_MAP))
#define IS_KEY_VALUE_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY_VALUE_MAP))
#define KEY_VALUE_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY_VALUE_MAP, KeyValueMapClass))

typedef struct _KeyValueMap KeyValueMap;
typedef struct _KeyValueMapClass KeyValueMapClass;

#define TYPE_BACKING_PHOTO_ID (backing_photo_id_get_type ())
typedef struct _BackingPhotoID BackingPhotoID;
typedef struct _BackingPhotoRowPrivate BackingPhotoRowPrivate;

#define TYPE_PHOTO_FILE_ADAPTER (photo_file_adapter_get_type ())
#define PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter))
#define PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))
#define IS_PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_ADAPTER))
#define IS_PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_ADAPTER))
#define PHOTO_FILE_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))

typedef struct _PhotoFileAdapter PhotoFileAdapter;
typedef struct _PhotoFileAdapterClass PhotoFileAdapterClass;

#define TYPE_PHOTO_FILE_READER (photo_file_reader_get_type ())
#define PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReader))
#define PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))
#define IS_PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_READER))
#define IS_PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_READER))
#define PHOTO_FILE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))

typedef struct _PhotoFileReader PhotoFileReader;
typedef struct _PhotoFileReaderClass PhotoFileReaderClass;
typedef struct _PhotoBackingReadersPrivate PhotoBackingReadersPrivate;
#define _photo_file_adapter_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_adapter_unref (var), NULL)))

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define TYPE_PHOTO_TABLE (photo_table_get_type ())
#define PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_TABLE, PhotoTable))
#define PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_TABLE, PhotoTableClass))
#define IS_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_TABLE))
#define IS_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_TABLE))
#define PHOTO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_TABLE, PhotoTableClass))

typedef struct _PhotoTable PhotoTable;
typedef struct _PhotoTableClass PhotoTableClass;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_BACKING_PHOTO_TABLE (backing_photo_table_get_type ())
#define BACKING_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_TABLE, BackingPhotoTable))
#define BACKING_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_TABLE, BackingPhotoTableClass))
#define IS_BACKING_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_TABLE))
#define IS_BACKING_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_TABLE))
#define BACKING_PHOTO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_TABLE, BackingPhotoTableClass))

typedef struct _BackingPhotoTable BackingPhotoTable;
typedef struct _BackingPhotoTableClass BackingPhotoTableClass;

#define TYPE_PHOTO_PREVIEW (photo_preview_get_type ())
#define PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_PREVIEW, PhotoPreview))
#define PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))
#define IS_PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_PREVIEW))
#define IS_PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_PREVIEW))
#define PHOTO_PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))

typedef struct _PhotoPreview PhotoPreview;
typedef struct _PhotoPreviewClass PhotoPreviewClass;
#define _photo_preview_unref0(var) ((var == NULL) ? NULL : (var = (photo_preview_unref (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))

#define TYPE_PHOTO_FILE_INTERROGATOR (photo_file_interrogator_get_type ())
#define PHOTO_FILE_INTERROGATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_INTERROGATOR, PhotoFileInterrogator))
#define PHOTO_FILE_INTERROGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_INTERROGATOR, PhotoFileInterrogatorClass))
#define IS_PHOTO_FILE_INTERROGATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_INTERROGATOR))
#define IS_PHOTO_FILE_INTERROGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_INTERROGATOR))
#define PHOTO_FILE_INTERROGATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_INTERROGATOR, PhotoFileInterrogatorClass))

typedef struct _PhotoFileInterrogator PhotoFileInterrogator;
typedef struct _PhotoFileInterrogatorClass PhotoFileInterrogatorClass;
#define _photo_file_interrogator_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_interrogator_unref (var), NULL)))

#define TYPE_DETECTED_PHOTO_INFORMATION (detected_photo_information_get_type ())
#define DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformation))
#define DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))
#define IS_DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DETECTED_PHOTO_INFORMATION))
#define IS_DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DETECTED_PHOTO_INFORMATION))
#define DETECTED_PHOTO_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))

typedef struct _DetectedPhotoInformation DetectedPhotoInformation;
typedef struct _DetectedPhotoInformationClass DetectedPhotoInformationClass;
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
typedef struct _DetectedPhotoInformationPrivate DetectedPhotoInformationPrivate;

#define TYPE_PHOTO_FILE_WRITER (photo_file_writer_get_type ())
#define PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriter))
#define PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))
#define IS_PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_WRITER))
#define IS_PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_WRITER))
#define PHOTO_FILE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))

typedef struct _PhotoFileWriter PhotoFileWriter;
typedef struct _PhotoFileWriterClass PhotoFileWriterClass;

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())

#define TYPE_PHOTO_FILE_METADATA_WRITER (photo_file_metadata_writer_get_type ())
#define PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriter))
#define PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))
#define IS_PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_METADATA_WRITER))
#define IS_PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_METADATA_WRITER))
#define PHOTO_FILE_METADATA_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))

typedef struct _PhotoFileMetadataWriter PhotoFileMetadataWriter;
typedef struct _PhotoFileMetadataWriterClass PhotoFileMetadataWriterClass;

#define TYPE_EXPORT_FORMAT_PARAMETERS (export_format_parameters_get_type ())

#define TYPE_EXPORT_FORMAT_MODE (export_format_mode_get_type ())
typedef struct _ExportFormatParameters ExportFormatParameters;

#define TYPE_IMPORT_RESULT (import_result_get_type ())

#define TYPE_METADATA_DATE_TIME (metadata_date_time_get_type ())
#define METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTime))
#define METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))
#define IS_METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_DATE_TIME))
#define IS_METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_DATE_TIME))
#define METADATA_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))

typedef struct _MetadataDateTime MetadataDateTime;
typedef struct _MetadataDateTimeClass MetadataDateTimeClass;
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))

#define PHOTO_FILE_READER_TYPE_ROLE (photo_file_reader_role_get_type ())

#define PHOTO_TYPE_REIMPORT_MASTER_STATE (photo_reimport_master_state_get_type ())
#define PHOTO_REIMPORT_MASTER_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterState))
#define PHOTO_REIMPORT_MASTER_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterStateClass))
#define PHOTO_IS_REIMPORT_MASTER_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE))
#define PHOTO_IS_REIMPORT_MASTER_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE))
#define PHOTO_REIMPORT_MASTER_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterStateClass))

typedef struct _PhotoReimportMasterState PhotoReimportMasterState;
typedef struct _PhotoReimportMasterStateClass PhotoReimportMasterStateClass;
#define _photo_reimport_master_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_master_state_unref (var), NULL)))

#define PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL (photo_reimport_master_state_impl_get_type ())
#define PHOTO_REIMPORT_MASTER_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImpl))
#define PHOTO_REIMPORT_MASTER_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImplClass))
#define PHOTO_IS_REIMPORT_MASTER_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL))
#define PHOTO_IS_REIMPORT_MASTER_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL))
#define PHOTO_REIMPORT_MASTER_STATE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImplClass))

typedef struct _PhotoReimportMasterStateImpl PhotoReimportMasterStateImpl;
typedef struct _PhotoReimportMasterStateImplClass PhotoReimportMasterStateImplClass;
typedef struct _PhotoReimportMasterStatePrivate PhotoReimportMasterStatePrivate;
typedef struct _PhotoReimportMasterStateImplPrivate PhotoReimportMasterStateImplPrivate;

#define PHOTO_TYPE_REIMPORT_EDITABLE_STATE (photo_reimport_editable_state_get_type ())
#define PHOTO_REIMPORT_EDITABLE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableState))
#define PHOTO_REIMPORT_EDITABLE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableStateClass))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE))
#define PHOTO_REIMPORT_EDITABLE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableStateClass))

typedef struct _PhotoReimportEditableState PhotoReimportEditableState;
typedef struct _PhotoReimportEditableStateClass PhotoReimportEditableStateClass;
#define _photo_reimport_editable_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_editable_state_unref (var), NULL)))

#define PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL (photo_reimport_editable_state_impl_get_type ())
#define PHOTO_REIMPORT_EDITABLE_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImpl))
#define PHOTO_REIMPORT_EDITABLE_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImplClass))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL))
#define PHOTO_REIMPORT_EDITABLE_STATE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImplClass))

typedef struct _PhotoReimportEditableStateImpl PhotoReimportEditableStateImpl;
typedef struct _PhotoReimportEditableStateImplClass PhotoReimportEditableStateImplClass;
typedef struct _PhotoReimportEditableStatePrivate PhotoReimportEditableStatePrivate;
typedef struct _PhotoReimportEditableStateImplPrivate PhotoReimportEditableStateImplPrivate;

#define PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE (photo_reimport_raw_development_state_get_type ())
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentState))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentStateClass))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentStateClass))

typedef struct _PhotoReimportRawDevelopmentState PhotoReimportRawDevelopmentState;
typedef struct _PhotoReimportRawDevelopmentStateClass PhotoReimportRawDevelopmentStateClass;
#define _photo_reimport_raw_development_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_raw_development_state_unref (var), NULL)))

#define PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL (photo_reimport_raw_development_state_impl_get_type ())
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL, PhotoReimportRawDevelopmentStateImpl))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL, PhotoReimportRawDevelopmentStateImplClass))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL, PhotoReimportRawDevelopmentStateImplClass))

typedef struct _PhotoReimportRawDevelopmentStateImpl PhotoReimportRawDevelopmentStateImpl;
typedef struct _PhotoReimportRawDevelopmentStateImplClass PhotoReimportRawDevelopmentStateImplClass;

#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT (photo_reimport_raw_development_state_impl_dev_to_reimport_get_type ())
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_DEV_TO_REIMPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT, PhotoReimportRawDevelopmentStateImplDevToReimport))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_DEV_TO_REIMPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT, PhotoReimportRawDevelopmentStateImplDevToReimportClass))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_IS_DEV_TO_REIMPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_IS_DEV_TO_REIMPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_DEV_TO_REIMPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT, PhotoReimportRawDevelopmentStateImplDevToReimportClass))

typedef struct _PhotoReimportRawDevelopmentStateImplDevToReimport PhotoReimportRawDevelopmentStateImplDevToReimport;
typedef struct _PhotoReimportRawDevelopmentStateImplDevToReimportClass PhotoReimportRawDevelopmentStateImplDevToReimportClass;
typedef struct _PhotoReimportRawDevelopmentStatePrivate PhotoReimportRawDevelopmentStatePrivate;
typedef struct _PhotoReimportRawDevelopmentStateImplPrivate PhotoReimportRawDevelopmentStateImplPrivate;
typedef struct _PhotoReimportRawDevelopmentStateImplDevToReimportPrivate PhotoReimportRawDevelopmentStateImplDevToReimportPrivate;
#define _photo_reimport_raw_development_state_impl_dev_to_reimport_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_raw_development_state_impl_dev_to_reimport_unref (var), NULL)))

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;

#define PHOTO_METADATA_TYPE_SET_OPTION (photo_metadata_set_option_get_type ())

#define TYPE_BOX (box_get_type ())
typedef struct _Box Box;
#define _key_value_map_unref0(var) ((var == NULL) ? NULL : (var = (key_value_map_unref (var), NULL)))

#define TYPE_PIXEL_TRANSFORMATION_TYPE (pixel_transformation_type_get_type ())

#define TYPE_PIXEL_TRANSFORMATION (pixel_transformation_get_type ())
#define PIXEL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXEL_TRANSFORMATION, PixelTransformation))
#define PIXEL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXEL_TRANSFORMATION, PixelTransformationClass))
#define IS_PIXEL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXEL_TRANSFORMATION))
#define IS_PIXEL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXEL_TRANSFORMATION))
#define PIXEL_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXEL_TRANSFORMATION, PixelTransformationClass))

typedef struct _PixelTransformation PixelTransformation;
typedef struct _PixelTransformationClass PixelTransformationClass;
#define _pixel_transformation_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformation_unref (var), NULL)))

#define PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL (photo_photo_transformation_state_impl_get_type ())
#define PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL, PhotoPhotoTransformationStateImpl))
#define PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL, PhotoPhotoTransformationStateImplClass))
#define PHOTO_IS_PHOTO_TRANSFORMATION_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL))
#define PHOTO_IS_PHOTO_TRANSFORMATION_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL))
#define PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL, PhotoPhotoTransformationStateImplClass))

typedef struct _PhotoPhotoTransformationStateImpl PhotoPhotoTransformationStateImpl;
typedef struct _PhotoPhotoTransformationStateImplClass PhotoPhotoTransformationStateImplClass;

#define EDITING_TOOLS_TYPE_REDEYE_INSTANCE (editing_tools_redeye_instance_get_type ())
typedef struct _EditingToolsRedeyeInstance EditingToolsRedeyeInstance;
typedef struct _PhotoCachedPixbufPrivate PhotoCachedPixbufPrivate;
#define _photo_cached_pixbuf_unref0(var) ((var == NULL) ? NULL : (var = (photo_cached_pixbuf_unref (var), NULL)))

#define TYPE_PHOTO_FILE_FORMAT_PROPERTIES (photo_file_format_properties_get_type ())
#define PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatProperties))
#define PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))

typedef struct _PhotoFileFormatProperties PhotoFileFormatProperties;
typedef struct _PhotoFileFormatPropertiesClass PhotoFileFormatPropertiesClass;
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _PhotoPhotoTransformationStateImplPrivate PhotoPhotoTransformationStateImplPrivate;
typedef struct _PhotoParamSpecBackingReaders PhotoParamSpecBackingReaders;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _PhotoParamSpecCachedPixbuf PhotoParamSpecCachedPixbuf;
typedef struct _PhotoParamSpecReimportMasterState PhotoParamSpecReimportMasterState;
typedef struct _PhotoParamSpecReimportEditableState PhotoParamSpecReimportEditableState;
typedef struct _PhotoParamSpecReimportRawDevelopmentState PhotoParamSpecReimportRawDevelopmentState;
typedef struct _PhotoReimportRawDevelopmentStateImplParamSpecDevToReimport PhotoReimportRawDevelopmentStateImplParamSpecDevToReimport;
typedef struct _DataCollectionPrivate DataCollectionPrivate;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;
typedef struct _SourceCollectionPrivate SourceCollectionPrivate;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;
typedef struct _DatabaseSourceCollectionPrivate DatabaseSourceCollectionPrivate;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;
typedef struct _MediaSourceCollectionPrivate MediaSourceCollectionPrivate;

#define TYPE_DATABASE_SOURCE_HOLDING_TANK (database_source_holding_tank_get_type ())
#define DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTank))
#define DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))
#define IS_DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define IS_DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define DATABASE_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))

typedef struct _DatabaseSourceHoldingTank DatabaseSourceHoldingTank;
typedef struct _DatabaseSourceHoldingTankClass DatabaseSourceHoldingTankClass;

#define TYPE_MEDIA_SOURCE_HOLDING_TANK (media_source_holding_tank_get_type ())
#define MEDIA_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTank))
#define MEDIA_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTankClass))
#define IS_MEDIA_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK))
#define IS_MEDIA_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_HOLDING_TANK))
#define MEDIA_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTankClass))

typedef struct _MediaSourceHoldingTank MediaSourceHoldingTank;
typedef struct _MediaSourceHoldingTankClass MediaSourceHoldingTankClass;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;

#define TYPE_MEDIA_MONITOR (media_monitor_get_type ())
#define MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_MONITOR, MediaMonitor))
#define MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_MONITOR, MediaMonitorClass))
#define IS_MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_MONITOR))
#define IS_MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_MONITOR))
#define MEDIA_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_MONITOR, MediaMonitorClass))

typedef struct _MediaMonitor MediaMonitor;
typedef struct _MediaMonitorClass MediaMonitorClass;

#define TYPE_TRANSACTION_CONTROLLER (transaction_controller_get_type ())
#define TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionController))
#define TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))
#define IS_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSACTION_CONTROLLER))
#define IS_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSACTION_CONTROLLER))
#define TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))

typedef struct _TransactionController TransactionController;
typedef struct _TransactionControllerClass TransactionControllerClass;

#define TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION (library_photo_source_collection_get_type ())
#define LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))

typedef struct _LibraryPhotoSourceCollection LibraryPhotoSourceCollection;
typedef struct _LibraryPhotoSourceCollectionClass LibraryPhotoSourceCollectionClass;
typedef struct _LibraryPhotoSourceCollectionPrivate LibraryPhotoSourceCollectionPrivate;

#define LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE (library_photo_source_collection_state_get_type ())
#define _transaction_controller_unref0(var) ((var == NULL) ? NULL : (var = (transaction_controller_unref (var), NULL)))
#define _source_holding_tank_unref0(var) ((var == NULL) ? NULL : (var = (source_holding_tank_unref (var), NULL)))

#define TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK (library_photo_source_holding_tank_get_type ())
#define LIBRARY_PHOTO_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, LibraryPhotoSourceHoldingTank))
#define LIBRARY_PHOTO_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, LibraryPhotoSourceHoldingTankClass))
#define IS_LIBRARY_PHOTO_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK))
#define IS_LIBRARY_PHOTO_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK))
#define LIBRARY_PHOTO_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, LibraryPhotoSourceHoldingTankClass))

typedef struct _LibraryPhotoSourceHoldingTank LibraryPhotoSourceHoldingTank;
typedef struct _LibraryPhotoSourceHoldingTankClass LibraryPhotoSourceHoldingTankClass;

#define TYPE_PHOTO_MONITOR (photo_monitor_get_type ())
#define PHOTO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_MONITOR, PhotoMonitor))
#define PHOTO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_MONITOR, PhotoMonitorClass))
#define IS_PHOTO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_MONITOR))
#define IS_PHOTO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_MONITOR))
#define PHOTO_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_MONITOR, PhotoMonitorClass))

typedef struct _PhotoMonitor PhotoMonitor;
typedef struct _PhotoMonitorClass PhotoMonitorClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define TYPE_HIERARCHICAL_TAG_INDEX (hierarchical_tag_index_get_type ())
#define HIERARCHICAL_TAG_INDEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndex))
#define HIERARCHICAL_TAG_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndexClass))
#define IS_HIERARCHICAL_TAG_INDEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HIERARCHICAL_TAG_INDEX))
#define IS_HIERARCHICAL_TAG_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HIERARCHICAL_TAG_INDEX))
#define HIERARCHICAL_TAG_INDEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndexClass))

typedef struct _HierarchicalTagIndex HierarchicalTagIndex;
typedef struct _HierarchicalTagIndexClass HierarchicalTagIndexClass;
#define _hierarchical_tag_index_unref0(var) ((var == NULL) ? NULL : (var = (hierarchical_tag_index_unref (var), NULL)))

#define TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER (media_source_transaction_controller_get_type ())
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionController))
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionControllerClass))
#define IS_MEDIA_SOURCE_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER))
#define IS_MEDIA_SOURCE_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER))
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionControllerClass))

typedef struct _MediaSourceTransactionController MediaSourceTransactionController;
typedef struct _MediaSourceTransactionControllerClass MediaSourceTransactionControllerClass;

#define TYPE_FLAGGABLE (flaggable_get_type ())
#define FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAGGABLE, Flaggable))
#define IS_FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAGGABLE))
#define FLAGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FLAGGABLE, FlaggableIface))

typedef struct _Flaggable Flaggable;
typedef struct _FlaggableIface FlaggableIface;

#define TYPE_MONITORABLE (monitorable_get_type ())
#define MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE, Monitorable))
#define IS_MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE))
#define MONITORABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MONITORABLE, MonitorableIface))

typedef struct _Monitorable Monitorable;
typedef struct _MonitorableIface MonitorableIface;
typedef struct _LibraryPhotoPrivate LibraryPhotoPrivate;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))

#define THUMBNAIL_CACHE_TYPE_SIZE (thumbnail_cache_size_get_type ())

#define TYPE_EVENT_SOURCE (event_source_get_type ())
#define EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE, EventSource))
#define EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE, EventSourceClass))
#define IS_EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE))
#define IS_EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE))
#define EVENT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE, EventSourceClass))

typedef struct _EventSource EventSource;
typedef struct _EventSourceClass EventSourceClass;

#define TYPE_EVENT (event_get_type ())
#define EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT, Event))
#define EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT, EventClass))
#define IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT))
#define IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT))
#define EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT, EventClass))

typedef struct _Event Event;
typedef struct _EventClass EventClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_TAG_SOURCE_COLLECTION (tag_source_collection_get_type ())
#define TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection))
#define TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))
#define IS_TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_SOURCE_COLLECTION))
#define IS_TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_SOURCE_COLLECTION))
#define TAG_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))

typedef struct _TagSourceCollection TagSourceCollection;
typedef struct _TagSourceCollectionClass TagSourceCollectionClass;
typedef struct _SourceHoldingTankPrivate SourceHoldingTankPrivate;
typedef struct _DatabaseSourceHoldingTankPrivate DatabaseSourceHoldingTankPrivate;
typedef struct _MediaSourceHoldingTankPrivate MediaSourceHoldingTankPrivate;
typedef struct _LibraryPhotoSourceHoldingTankPrivate LibraryPhotoSourceHoldingTankPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	BACKING_FETCH_MODE_SOURCE,
	BACKING_FETCH_MODE_BASELINE,
	BACKING_FETCH_MODE_MASTER,
	BACKING_FETCH_MODE_UNMODIFIED
} BackingFetchMode;

struct _ImportID {
	gint64 id;
};

typedef enum  {
	PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL = 0x00000000,
	PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5 = 0x00000001
} PhotoFileSnifferOptions;

struct _PhotoImportParams {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoImportParamsPrivate * priv;
	GFile* file;
	GFile* final_associated_file;
	ImportID import_id;
	PhotoFileSnifferOptions sniffer_options;
	gchar* exif_md5;
	gchar* thumbnail_md5;
	gchar* full_md5;
	Thumbnails* thumbnails;
	PhotoRow* row;
	GeeCollection* keywords;
};

struct _PhotoImportParamsClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoImportParams *self);
};

struct _ParamSpecPhotoImportParams {
	GParamSpec parent_instance;
};

struct _PhotoTransformationState {
	GObject parent_instance;
	PhotoTransformationStatePrivate * priv;
};

struct _PhotoTransformationStateClass {
	GObjectClass parent_class;
	void (*broken) (PhotoTransformationState* self);
};

struct _PhotoTransformationStatePrivate {
	gboolean is_broke;
};

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataSource {
	DataObject parent_instance;
	DataSourcePrivate * priv;
};

struct _DataSourceClass {
	DataObjectClass parent_class;
	void (*notify_held_in_tank) (DataSource* self, SourceHoldingTank* holding_tank);
	void (*notify_unlinking) (DataSource* self, SourceCollection* collection);
	void (*notify_unlinked) (DataSource* self);
	void (*notify_relinking) (DataSource* self, SourceCollection* collection);
	void (*notify_relinked) (DataSource* self);
	gchar* (*get_typename) (DataSource* self);
	gint64 (*get_instance_id) (DataSource* self);
	gchar* (*get_source_id) (DataSource* self);
	void (*commit_backlinks) (DataSource* self, SourceCollection* sources, const gchar* dehydrated);
	SourceSnapshot* (*save_snapshot) (DataSource* self);
	gboolean (*internal_delete_backing) (DataSource* self, GError** error);
	gboolean (*equals) (DataSource* self, DataSource* source);
	void (*destroy) (DataSource* self);
	void (*unlinked) (DataSource* self, SourceCollection* sources);
	void (*relinked) (DataSource* self, SourceCollection* sources);
	void (*destroyed) (DataSource* self);
};

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

struct _ThumbnailSource {
	DataSource parent_instance;
	ThumbnailSourcePrivate * priv;
};

struct _ThumbnailSourceClass {
	DataSourceClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailSource* self);
	GdkPixbuf* (*get_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	GdkPixbuf* (*create_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	gchar* (*get_representative_id) (ThumbnailSource* self);
	PhotoFileFormat (*get_preferred_thumbnail_format) (ThumbnailSource* self);
	void (*thumbnail_altered) (ThumbnailSource* self);
};

struct _IndexableIface {
	GTypeInterface parent_iface;
	const gchar* (*get_indexable_keywords) (Indexable* self);
};

struct _EventID {
	gint64 id;
};

typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

struct _Dimensions {
	gint width;
	gint height;
};

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _MediaSource {
	ThumbnailSource parent_instance;
	MediaSourcePrivate * priv;
};

struct _MediaSourceClass {
	ThumbnailSourceClass parent_class;
	void (*notify_master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
	gboolean (*set_event_id) (MediaSource* self, EventID* id);
	gchar* (*get_basename) (MediaSource* self);
	GFile* (*get_file) (MediaSource* self);
	GFile* (*get_master_file) (MediaSource* self);
	guint64 (*get_master_filesize) (MediaSource* self);
	guint64 (*get_filesize) (MediaSource* self);
	time_t (*get_timestamp) (MediaSource* self);
	BackingFileState** (*get_backing_files_state) (MediaSource* self, int* result_length1);
	gchar* (*get_title) (MediaSource* self);
	gchar* (*get_comment) (MediaSource* self);
	void (*set_title) (MediaSource* self, const gchar* title);
	gboolean (*set_comment) (MediaSource* self, const gchar* comment);
	Rating (*get_rating) (MediaSource* self);
	void (*set_rating) (MediaSource* self, Rating rating);
	void (*increase_rating) (MediaSource* self);
	void (*decrease_rating) (MediaSource* self);
	void (*get_dimensions) (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
	GdkPixbuf* (*get_preview_pixbuf) (MediaSource* self, Scaling* scaling, GError** error);
	gboolean (*is_trashed) (MediaSource* self);
	void (*trash) (MediaSource* self);
	void (*untrash) (MediaSource* self);
	gboolean (*is_offline) (MediaSource* self);
	void (*mark_offline) (MediaSource* self);
	void (*mark_online) (MediaSource* self);
	gchar* (*get_master_md5) (MediaSource* self);
	void (*get_event_id) (MediaSource* self, EventID* result);
	time_t (*get_exposure_time) (MediaSource* self);
	void (*get_import_id) (MediaSource* self, ImportID* result);
	void (*master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
};

struct _PhotoSource {
	MediaSource parent_instance;
	PhotoSourcePrivate * priv;
};

struct _PhotoSourceClass {
	MediaSourceClass parent_class;
	PhotoMetadata* (*get_metadata) (PhotoSource* self);
	GdkPixbuf* (*get_pixbuf) (PhotoSource* self, Scaling* scaling, GError** error);
};

struct _DateableIface {
	GTypeInterface parent_iface;
	void (*set_exposure_time) (Dateable* self, time_t target_time);
	time_t (*get_exposure_time) (Dateable* self);
};

typedef enum  {
	ROTATION_CLOCKWISE,
	ROTATION_COUNTERCLOCKWISE,
	ROTATION_MIRROR,
	ROTATION_UPSIDE_DOWN
} Rotation;

struct _Photo {
	PhotoSource parent_instance;
	PhotoPrivate * priv;
	PhotoRow* row;
	gboolean can_rotate_now;
	BackingPhotoRow* backing_photo_row;
};

struct _PhotoClass {
	PhotoSourceClass parent_class;
	void (*notify_editable_replaced) (Photo* self, GFile* old_file, GFile* new_file);
	void (*notify_raw_development_modified) (Photo* self);
	void (*notify_baseline_replaced) (Photo* self);
	void (*notify_master_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*notify_editable_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*notify_source_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*notify_baseline_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*apply_user_metadata_for_reimport) (Photo* self, PhotoMetadata* metadata);
	void (*rotate) (Photo* self, Rotation rotation);
	gboolean (*has_user_generated_metadata) (Photo* self);
	void (*set_user_metadata_for_export) (Photo* self, PhotoMetadata* metadata);
	void (*editable_replaced) (Photo* self, GFile* old_file, GFile* new_file);
	void (*raw_development_modified) (Photo* self);
	void (*baseline_replaced) (Photo* self);
	void (*master_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*editable_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*baseline_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*source_reimported) (Photo* self, PhotoMetadata* metadata);
};

typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

struct _PhotoPrivate {
	time_t cached_exposure_time;
	GRecMutex __lock_row;
	BackingPhotoRow* editable;
	PhotoBackingReaders* readers;
	GRecMutex __lock_readers;
	PixelTransformer* transformer;
	PixelTransformationBundle* adjustments;
	gchar* file_title;
	GFileMonitor* editable_monitor;
	OneShotScheduler* reimport_editable_scheduler;
	OneShotScheduler* update_editable_attributes_scheduler;
	OneShotScheduler* remove_editable_scheduler;
	GeeHashMap* developments;
	GRecMutex __lock_developments;
};

struct _PhotoID {
	gint64 id;
};

typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

struct _BackingPhotoID {
	gint64 id;
};

struct _PhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoRowPrivate * priv;
	PhotoID photo_id;
	BackingPhotoRow* master;
	time_t exposure_time;
	ImportID import_id;
	EventID event_id;
	Orientation orientation;
	GeeHashMap* transformations;
	gchar* md5;
	gchar* thumbnail_md5;
	gchar* exif_md5;
	time_t time_created;
	guint64 flags;
	Rating rating;
	gchar* title;
	gchar* comment;
	gchar* backlinks;
	time_t time_reimported;
	BackingPhotoID editable_id;
	gboolean metadata_dirty;
	RawDeveloper developer;
	BackingPhotoID* development_ids;
	gint development_ids_length1;
};

struct _PhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoRow *self);
};

struct _BackingPhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackingPhotoRowPrivate * priv;
	BackingPhotoID id;
	time_t time_created;
	gchar* filepath;
	gint64 filesize;
	time_t timestamp;
	PhotoFileFormat file_format;
	Dimensions dim;
	Orientation original_orientation;
};

struct _BackingPhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (BackingPhotoRow *self);
};

struct _PhotoBackingReaders {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoBackingReadersPrivate * priv;
	PhotoFileReader* master;
	PhotoFileReader* developer;
	PhotoFileReader* editable;
};

struct _PhotoBackingReadersClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoBackingReaders *self);
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()
struct _DetectedPhotoInformation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DetectedPhotoInformationPrivate * priv;
	PhotoFileFormat file_format;
	PhotoMetadata* metadata;
	gchar* md5;
	gchar* exif_md5;
	gchar* thumbnail_md5;
	gchar* format_name;
	Dimensions image_dim;
	GdkColorspace colorspace;
	gint channels;
	gint bits_per_channel;
};

struct _DetectedPhotoInformationClass {
	GTypeClass parent_class;
	void (*finalize) (DetectedPhotoInformation *self);
};

typedef enum  {
	PHOTO_FORMAT_ERROR_READ_ONLY
} PhotoFormatError;
#define PHOTO_FORMAT_ERROR photo_format_error_quark ()
typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

typedef enum  {
	EXPORT_FORMAT_MODE_UNMODIFIED,
	EXPORT_FORMAT_MODE_CURRENT,
	EXPORT_FORMAT_MODE_SPECIFIED,
	EXPORT_FORMAT_MODE_LAST
} ExportFormatMode;

struct _ExportFormatParameters {
	ExportFormatMode mode;
	PhotoFileFormat specified_format;
	JpegQuality quality;
	gboolean export_metadata;
};

typedef enum  {
	IMPORT_RESULT_SUCCESS,
	IMPORT_RESULT_FILE_ERROR,
	IMPORT_RESULT_DECODE_ERROR,
	IMPORT_RESULT_DATABASE_ERROR,
	IMPORT_RESULT_USER_ABORT,
	IMPORT_RESULT_NOT_A_FILE,
	IMPORT_RESULT_PHOTO_EXISTS,
	IMPORT_RESULT_UNSUPPORTED_FORMAT,
	IMPORT_RESULT_NOT_AN_IMAGE,
	IMPORT_RESULT_DISK_FAILURE,
	IMPORT_RESULT_DISK_FULL,
	IMPORT_RESULT_CAMERA_ERROR,
	IMPORT_RESULT_FILE_WRITE_ERROR,
	IMPORT_RESULT_PIXBUF_CORRUPT_IMAGE
} ImportResult;

typedef enum  {
	PHOTO_FILE_READER_ROLE_DEFAULT,
	PHOTO_FILE_READER_ROLE_THUMBNAIL
} PhotoFileReaderRole;

struct _PhotoReimportMasterState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoReimportMasterStatePrivate * priv;
};

struct _PhotoReimportMasterStateClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoReimportMasterState *self);
};

struct _PhotoReimportMasterStateImpl {
	PhotoReimportMasterState parent_instance;
	PhotoReimportMasterStateImplPrivate * priv;
	PhotoRow* row;
	PhotoMetadata* metadata;
	gchar** alterations;
	gint alterations_length1;
	gint _alterations_size_;
	gboolean metadata_only;
};

struct _PhotoReimportMasterStateImplClass {
	PhotoReimportMasterStateClass parent_class;
};

struct _PhotoReimportEditableState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoReimportEditableStatePrivate * priv;
};

struct _PhotoReimportEditableStateClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoReimportEditableState *self);
};

struct _PhotoReimportEditableStateImpl {
	PhotoReimportEditableState parent_instance;
	PhotoReimportEditableStateImplPrivate * priv;
	BackingPhotoRow* backing_state;
	PhotoMetadata* metadata;
	gboolean metadata_only;
};

struct _PhotoReimportEditableStateImplClass {
	PhotoReimportEditableStateClass parent_class;
};

struct _PhotoReimportRawDevelopmentState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoReimportRawDevelopmentStatePrivate * priv;
};

struct _PhotoReimportRawDevelopmentStateClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoReimportRawDevelopmentState *self);
};

struct _PhotoReimportRawDevelopmentStateImpl {
	PhotoReimportRawDevelopmentState parent_instance;
	PhotoReimportRawDevelopmentStateImplPrivate * priv;
	GeeCollection* list;
	gboolean metadata_only;
};

struct _PhotoReimportRawDevelopmentStateImplClass {
	PhotoReimportRawDevelopmentStateClass parent_class;
};

struct _PhotoReimportRawDevelopmentStateImplDevToReimport {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoReimportRawDevelopmentStateImplDevToReimportPrivate * priv;
	BackingPhotoRow* backing;
	PhotoMetadata* metadata;
};

struct _PhotoReimportRawDevelopmentStateImplDevToReimportClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoReimportRawDevelopmentStateImplDevToReimport *self);
};

typedef enum  {
	PHOTO_METADATA_SET_OPTION_ALL_DOMAINS,
	PHOTO_METADATA_SET_OPTION_ONLY_IF_DOMAIN_PRESENT,
	PHOTO_METADATA_SET_OPTION_AT_LEAST_DEFAULT_DOMAIN
} PhotoMetadataSetOption;

struct _Box {
	gint left;
	gint top;
	gint right;
	gint bottom;
};

typedef enum  {
	PIXEL_TRANSFORMATION_TYPE_TONE_EXPANSION,
	PIXEL_TRANSFORMATION_TYPE_SHADOWS,
	PIXEL_TRANSFORMATION_TYPE_HIGHLIGHTS,
	PIXEL_TRANSFORMATION_TYPE_TEMPERATURE,
	PIXEL_TRANSFORMATION_TYPE_TINT,
	PIXEL_TRANSFORMATION_TYPE_SATURATION,
	PIXEL_TRANSFORMATION_TYPE_EXPOSURE,
	PIXEL_TRANSFORMATION_TYPE_CONTRAST
} PixelTransformationType;

struct _EditingToolsRedeyeInstance {
	GdkPoint center;
	gint radius;
};

struct _PhotoCachedPixbuf {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoCachedPixbufPrivate * priv;
	Photo* photo;
	GdkPixbuf* pixbuf;
	GTimer* last_touched;
};

struct _PhotoCachedPixbufClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoCachedPixbuf *self);
};

typedef void (*OneShotCallback) (void* user_data);
struct _PhotoPhotoTransformationStateImpl {
	PhotoTransformationState parent_instance;
	PhotoPhotoTransformationStateImplPrivate * priv;
};

struct _PhotoPhotoTransformationStateImplClass {
	PhotoTransformationStateClass parent_class;
};

struct _PhotoPhotoTransformationStateImplPrivate {
	Photo* photo;
	Orientation orientation;
	GeeHashMap* transformations;
	PixelTransformer* transformer;
	PixelTransformationBundle* adjustments;
};

struct _PhotoParamSpecBackingReaders {
	GParamSpec parent_instance;
};

struct _PhotoParamSpecCachedPixbuf {
	GParamSpec parent_instance;
};

struct _PhotoParamSpecReimportMasterState {
	GParamSpec parent_instance;
};

struct _PhotoParamSpecReimportEditableState {
	GParamSpec parent_instance;
};

struct _PhotoParamSpecReimportRawDevelopmentState {
	GParamSpec parent_instance;
};

struct _PhotoReimportRawDevelopmentStateImplParamSpecDevToReimport {
	GParamSpec parent_instance;
};

typedef gint64 (*Comparator) (void* a, void* b, void* user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, void* user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);
struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, void* comparator_target, ComparatorPredicate predicate, void* predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _SourceCollection {
	DataCollection parent_instance;
	SourceCollectionPrivate * priv;
};

struct _SourceCollectionClass {
	DataCollectionClass parent_class;
	gboolean (*holds_type_of_source) (SourceCollection* self, DataSource* source);
	void (*notify_items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*notify_items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*notify_item_destroyed) (SourceCollection* self, DataSource* source);
	void (*notify_items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*notify_unlinked_destroyed) (SourceCollection* self, DataSource* unlinked);
	void (*notify_backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
	gboolean (*has_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*remove_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*item_destroyed) (SourceCollection* self, DataSource* source);
	void (*items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*unlinked_destroyed) (SourceCollection* self, DataSource* source);
	void (*backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
};

struct _DatabaseSourceCollection {
	SourceCollection parent_instance;
	DatabaseSourceCollectionPrivate * priv;
};

struct _DatabaseSourceCollectionClass {
	SourceCollectionClass parent_class;
};

struct _MediaSourceCollection {
	DatabaseSourceCollection parent_instance;
	MediaSourceCollectionPrivate * priv;
};

struct _MediaSourceCollectionClass {
	DatabaseSourceCollectionClass parent_class;
	MediaSourceHoldingTank* (*create_trashcan) (MediaSourceCollection* self);
	MediaSourceHoldingTank* (*create_offline_bin) (MediaSourceCollection* self);
	MediaMonitor* (*create_media_monitor) (MediaSourceCollection* self, Workers* workers, GCancellable* cancellable);
	gchar* (*get_typename) (MediaSourceCollection* self);
	gboolean (*is_file_recognized) (MediaSourceCollection* self, GFile* file);
	MediaSource* (*fetch_by_numeric_id) (MediaSourceCollection* self, gint64 numeric_id);
	void (*notify_import_roll_altered) (MediaSourceCollection* self);
	void (*notify_flagged_contents_altered) (MediaSourceCollection* self);
	void (*notify_media_import_starting) (MediaSourceCollection* self, GeeCollection* media);
	void (*notify_media_import_completed) (MediaSourceCollection* self, GeeCollection* media);
	MediaSource* (*fetch_by_source_id) (MediaSourceCollection* self, const gchar* source_id);
	GeeCollection* (*get_event_source_ids) (MediaSourceCollection* self, EventID* event_id);
	void (*import_many) (MediaSourceCollection* self, GeeCollection* media);
	void (*postprocess_imported_media) (MediaSourceCollection* self, GeeCollection* media);
	void (*media_import_starting) (MediaSourceCollection* self, GeeCollection* media);
	void (*media_import_completed) (MediaSourceCollection* self, GeeCollection* media);
	void (*master_file_replaced) (MediaSourceCollection* self, MediaSource* media, GFile* old_file, GFile* new_file);
	void (*trashcan_contents_altered) (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed);
	void (*import_roll_altered) (MediaSourceCollection* self);
	void (*offline_contents_altered) (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed);
	void (*flagged_contents_altered) (MediaSourceCollection* self);
	TransactionController* (*get_transaction_controller) (MediaSourceCollection* self);
};

struct _LibraryPhotoSourceCollection {
	MediaSourceCollection parent_instance;
	LibraryPhotoSourceCollectionPrivate * priv;
};

struct _LibraryPhotoSourceCollectionClass {
	MediaSourceCollectionClass parent_class;
	void (*notify_master_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*notify_editable_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*notify_source_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*notify_baseline_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*master_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*editable_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*baseline_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*source_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
};

struct _LibraryPhotoSourceCollectionPrivate {
	TransactionController* _transaction_controller;
	GeeHashMap* by_editable_file;
	GeeHashMap* by_raw_development_file;
	GeeMultiMap* filesize_to_photo;
	GeeHashMap* photo_to_master_filesize;
	GeeHashMap* photo_to_editable_filesize;
	GeeMultiMap* photo_to_raw_development_filesize;
};

typedef enum  {
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_UNKNOWN,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER
} LibraryPhotoSourceCollectionState;

typedef gint64 (*GetSourceDatabaseKey) (DataSource* source, void* user_data);
typedef gboolean (*SourceHoldingTankCheckToKeep) (DataSource* source, Alteration* alteration, void* user_data);
struct _FlaggableIface {
	GTypeInterface parent_iface;
	gboolean (*is_flagged) (Flaggable* self);
	void (*mark_flagged) (Flaggable* self);
	void (*mark_unflagged) (Flaggable* self);
};

struct _MonitorableIface {
	GTypeInterface parent_iface;
	gboolean (*is_offline) (Monitorable* self);
	void (*mark_online) (Monitorable* self);
	void (*mark_offline) (Monitorable* self);
	void (*set_master_file) (Monitorable* self, GFile* file);
	void (*set_master_timestamp) (Monitorable* self, GFileInfo* info);
};

struct _LibraryPhoto {
	Photo parent_instance;
	LibraryPhotoPrivate * priv;
};

struct _LibraryPhotoClass {
	PhotoClass parent_class;
};

struct _LibraryPhotoPrivate {
	gboolean block_thumbnail_generation;
	OneShotScheduler* thumbnail_scheduler;
	GeeCollection* import_keywords;
};

typedef enum  {
	THUMBNAIL_CACHE_SIZE_LARGEST = 360,
	THUMBNAIL_CACHE_SIZE_BIG = 360,
	THUMBNAIL_CACHE_SIZE_MEDIUM = 128,
	THUMBNAIL_CACHE_SIZE_SMALLEST = 128
} ThumbnailCacheSize;

struct _SourceHoldingTank {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SourceHoldingTankPrivate * priv;
};

struct _SourceHoldingTankClass {
	GTypeClass parent_class;
	void (*finalize) (SourceHoldingTank *self);
	void (*notify_contents_altered) (SourceHoldingTank* self, GeeCollection* added, GeeCollection* removed);
	void (*contents_altered) (SourceHoldingTank* self, GeeCollection* added, GeeCollection* removed);
};

struct _DatabaseSourceHoldingTank {
	SourceHoldingTank parent_instance;
	DatabaseSourceHoldingTankPrivate * priv;
};

struct _DatabaseSourceHoldingTankClass {
	SourceHoldingTankClass parent_class;
};

struct _MediaSourceHoldingTank {
	DatabaseSourceHoldingTank parent_instance;
	MediaSourceHoldingTankPrivate * priv;
};

struct _MediaSourceHoldingTankClass {
	DatabaseSourceHoldingTankClass parent_class;
};

struct _LibraryPhotoSourceHoldingTank {
	MediaSourceHoldingTank parent_instance;
	LibraryPhotoSourceHoldingTankPrivate * priv;
};

struct _LibraryPhotoSourceHoldingTankClass {
	MediaSourceHoldingTankClass parent_class;
};

struct _LibraryPhotoSourceHoldingTankPrivate {
	GeeHashMap* editable_file_map;
	GeeHashMap* development_file_map;
	GeeMultiMap* reverse_editable_file_map;
	GeeMultiMap* reverse_development_file_map;
};


static gpointer photo_import_params_parent_class = NULL;
static gpointer photo_transformation_state_parent_class = NULL;
static gpointer photo_parent_class = NULL;
static GeeLinkedList* photo_source_pixbuf_cache;
static GRecMutex __lock_photo_source_pixbuf_cache = {0};
static GeeLinkedList* photo_source_pixbuf_cache = NULL;
static guint photo_discard_source_id;
static guint photo_discard_source_id = (guint) 0;
static gboolean photo__develop_raw_photos_to_files;
static gboolean photo__develop_raw_photos_to_files = FALSE;
static gpointer photo_photo_transformation_state_impl_parent_class = NULL;
static gpointer photo_backing_readers_parent_class = NULL;
static gpointer photo_cached_pixbuf_parent_class = NULL;
static gpointer photo_reimport_master_state_parent_class = NULL;
static gpointer photo_reimport_master_state_impl_parent_class = NULL;
static gpointer photo_reimport_editable_state_parent_class = NULL;
static gpointer photo_reimport_editable_state_impl_parent_class = NULL;
static gpointer photo_reimport_raw_development_state_parent_class = NULL;
static gpointer photo_reimport_raw_development_state_impl_parent_class = NULL;
static gpointer photo_reimport_raw_development_state_impl_dev_to_reimport_parent_class = NULL;
static DateableIface* photo_dateable_parent_iface = NULL;
static gpointer library_photo_source_collection_parent_class = NULL;
static gpointer library_photo_parent_class = NULL;
extern LibraryPhotoSourceCollection* library_photo_global;
LibraryPhotoSourceCollection* library_photo_global = NULL;
extern TagSourceCollection* tag_global;
static FlaggableIface* library_photo_flaggable_parent_iface = NULL;
static MonitorableIface* library_photo_monitorable_parent_iface = NULL;
static gpointer library_photo_source_holding_tank_parent_class = NULL;

GType backing_fetch_mode_get_type (void) G_GNUC_CONST;
gpointer photo_import_params_ref (gpointer instance);
void photo_import_params_unref (gpointer instance);
GParamSpec* param_spec_photo_import_params (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_import_params (GValue* value, gpointer v_object);
void value_take_photo_import_params (GValue* value, gpointer v_object);
gpointer value_get_photo_import_params (const GValue* value);
GType photo_import_params_get_type (void) G_GNUC_CONST;
GType import_id_get_type (void) G_GNUC_CONST;
ImportID* import_id_dup (const ImportID* self);
void import_id_free (ImportID* self);
GType photo_file_sniffer_options_get_type (void) G_GNUC_CONST;
gpointer thumbnails_ref (gpointer instance);
void thumbnails_unref (gpointer instance);
GParamSpec* param_spec_thumbnails (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_thumbnails (GValue* value, gpointer v_object);
void value_take_thumbnails (GValue* value, gpointer v_object);
gpointer value_get_thumbnails (const GValue* value);
GType thumbnails_get_type (void) G_GNUC_CONST;
gpointer photo_row_ref (gpointer instance);
void photo_row_unref (gpointer instance);
GParamSpec* param_spec_photo_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_row (GValue* value, gpointer v_object);
void value_take_photo_row (GValue* value, gpointer v_object);
gpointer value_get_photo_row (const GValue* value);
GType photo_row_get_type (void) G_GNUC_CONST;
enum  {
	PHOTO_IMPORT_PARAMS_DUMMY_PROPERTY
};
PhotoRow* photo_row_new (void);
PhotoRow* photo_row_construct (GType object_type);
PhotoImportParams* photo_import_params_new (GFile* file, GFile* final_associated_file, ImportID* import_id, PhotoFileSnifferOptions sniffer_options, const gchar* exif_md5, const gchar* thumbnail_md5, const gchar* full_md5, Thumbnails* thumbnails);
PhotoImportParams* photo_import_params_construct (GType object_type, GFile* file, GFile* final_associated_file, ImportID* import_id, PhotoFileSnifferOptions sniffer_options, const gchar* exif_md5, const gchar* thumbnail_md5, const gchar* full_md5, Thumbnails* thumbnails);
PhotoImportParams* photo_import_params_new_create_placeholder (GFile* file, ImportID* import_id);
PhotoImportParams* photo_import_params_construct_create_placeholder (GType object_type, GFile* file, ImportID* import_id);
static void photo_import_params_finalize (PhotoImportParams* obj);
GType photo_transformation_state_get_type (void) G_GNUC_CONST;
#define PHOTO_TRANSFORMATION_STATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationStatePrivate))
enum  {
	PHOTO_TRANSFORMATION_STATE_DUMMY_PROPERTY
};
PhotoTransformationState* photo_transformation_state_construct (GType object_type);
gboolean photo_transformation_state_is_broken (PhotoTransformationState* self);
static void photo_transformation_state_real_broken (PhotoTransformationState* self);
static void photo_transformation_state_finalize (GObject* obj);
GType rating_get_type (void) G_GNUC_CONST;
gboolean rating_can_increase (Rating self);
gboolean rating_can_decrease (Rating self);
gboolean rating_is_valid (Rating self);
Rating rating_increase (Rating self);
Rating rating_decrease (Rating self);
gint rating_serialize (Rating self);
Rating rating_unserialize (gint value);
GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
gpointer source_holding_tank_ref (gpointer instance);
void source_holding_tank_unref (gpointer instance);
GParamSpec* param_spec_source_holding_tank (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_holding_tank (GValue* value, gpointer v_object);
void value_take_source_holding_tank (GValue* value, gpointer v_object);
gpointer value_get_source_holding_tank (const GValue* value);
GType source_holding_tank_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
gpointer source_snapshot_ref (gpointer instance);
void source_snapshot_unref (gpointer instance);
GParamSpec* param_spec_source_snapshot (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_snapshot (GValue* value, gpointer v_object);
void value_take_source_snapshot (GValue* value, gpointer v_object);
gpointer value_get_source_snapshot (const GValue* value);
GType source_snapshot_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
GType indexable_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType event_id_get_type (void) G_GNUC_CONST;
EventID* event_id_dup (const EventID* self);
void event_id_free (EventID* self);
gpointer backing_file_state_ref (gpointer instance);
void backing_file_state_unref (gpointer instance);
GParamSpec* param_spec_backing_file_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_backing_file_state (GValue* value, gpointer v_object);
void value_take_backing_file_state (GValue* value, gpointer v_object);
gpointer value_get_backing_file_state (const GValue* value);
GType backing_file_state_get_type (void) G_GNUC_CONST;
GType photo_exception_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType scaling_get_type (void) G_GNUC_CONST;
GType scale_constraint_get_type (void) G_GNUC_CONST;
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
GType photo_source_get_type (void) G_GNUC_CONST;
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_metadata (GValue* value, gpointer v_object);
void value_take_media_metadata (GValue* value, gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GType photo_metadata_get_type (void) G_GNUC_CONST;
GType dateable_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType rotation_get_type (void) G_GNUC_CONST;
gpointer backing_photo_row_ref (gpointer instance);
void backing_photo_row_unref (gpointer instance);
GParamSpec* param_spec_backing_photo_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_backing_photo_row (GValue* value, gpointer v_object);
void value_take_backing_photo_row (GValue* value, gpointer v_object);
gpointer value_get_backing_photo_row (const GValue* value);
GType backing_photo_row_get_type (void) G_GNUC_CONST;
static gpointer photo_backing_readers_ref (gpointer instance);
static void photo_backing_readers_unref (gpointer instance);
static GParamSpec* photo_param_spec_backing_readers (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void photo_value_set_backing_readers (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void photo_value_take_backing_readers (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer photo_value_get_backing_readers (const GValue* value) G_GNUC_UNUSED;
static GType photo_backing_readers_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
gpointer pixel_transformer_ref (gpointer instance);
void pixel_transformer_unref (gpointer instance);
GParamSpec* param_spec_pixel_transformer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pixel_transformer (GValue* value, gpointer v_object);
void value_take_pixel_transformer (GValue* value, gpointer v_object);
gpointer value_get_pixel_transformer (const GValue* value);
GType pixel_transformer_get_type (void) G_GNUC_CONST;
gpointer pixel_transformation_bundle_ref (gpointer instance);
void pixel_transformation_bundle_unref (gpointer instance);
GParamSpec* param_spec_pixel_transformation_bundle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pixel_transformation_bundle (GValue* value, gpointer v_object);
void value_take_pixel_transformation_bundle (GValue* value, gpointer v_object);
gpointer value_get_pixel_transformation_bundle (const GValue* value);
GType pixel_transformation_bundle_get_type (void) G_GNUC_CONST;
gpointer one_shot_scheduler_ref (gpointer instance);
void one_shot_scheduler_unref (gpointer instance);
GParamSpec* param_spec_one_shot_scheduler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_one_shot_scheduler (GValue* value, gpointer v_object);
void value_take_one_shot_scheduler (GValue* value, gpointer v_object);
gpointer value_get_one_shot_scheduler (const GValue* value);
GType one_shot_scheduler_get_type (void) G_GNUC_CONST;
GType raw_developer_get_type (void) G_GNUC_CONST;
#define PHOTO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PHOTO, PhotoPrivate))
enum  {
	PHOTO_DUMMY_PROPERTY
};
gboolean photo_exception_prohibits (PhotoException self, PhotoException exception);
gboolean photo_exception_allows (PhotoException self, PhotoException exception);
static gpointer photo_cached_pixbuf_ref (gpointer instance);
static void photo_cached_pixbuf_unref (gpointer instance);
static GParamSpec* photo_param_spec_cached_pixbuf (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void photo_value_set_cached_pixbuf (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void photo_value_take_cached_pixbuf (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer photo_value_get_cached_pixbuf (const GValue* value) G_GNUC_UNUSED;
static GType photo_cached_pixbuf_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
BackingPhotoRow* backing_photo_row_new (void);
BackingPhotoRow* backing_photo_row_construct (GType object_type);
static PhotoBackingReaders* photo_backing_readers_new (void);
static PhotoBackingReaders* photo_backing_readers_construct (GType object_type);
#define PHOTO_TYPENAME "thumb"
#define PHOTO_SCALING_FUDGE 64
#define PHOTO_SOURCE_PIXBUF_TIME_TO_LIVE_SEC 10
#define PHOTO_SOURCE_PIXBUF_MIN_LRU_COUNT 1
#define PHOTO_SOURCE_PIXBUF_MAX_LRU_COUNT 3
#define PHOTO_MIN_EMBEDDED_SIZE 1024
Photo* photo_construct (GType object_type, PhotoRow* row);
#define DATA_OBJECT_INVALID_OBJECT_ID ((gint64) -1)
PhotoSource* photo_source_construct (GType object_type, gint64 object_id);
gchar* media_source_prep_title (const gchar* title);
GType photo_id_get_type (void) G_GNUC_CONST;
PhotoID* photo_id_dup (const PhotoID* self);
void photo_id_free (PhotoID* self);
GType orientation_get_type (void) G_GNUC_CONST;
gpointer key_value_map_ref (gpointer instance);
void key_value_map_unref (gpointer instance);
GParamSpec* param_spec_key_value_map (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_key_value_map (GValue* value, gpointer v_object);
void value_take_key_value_map (GValue* value, gpointer v_object);
gpointer value_get_key_value_map (const GValue* value);
GType key_value_map_get_type (void) G_GNUC_CONST;
GType backing_photo_id_get_type (void) G_GNUC_CONST;
BackingPhotoID* backing_photo_id_dup (const BackingPhotoID* self);
void backing_photo_id_free (BackingPhotoID* self);
gchar* media_source_prep_comment (const gchar* comment);
gpointer photo_file_adapter_ref (gpointer instance);
void photo_file_adapter_unref (gpointer instance);
GParamSpec* param_spec_photo_file_adapter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_adapter (GValue* value, gpointer v_object);
void value_take_photo_file_adapter (GValue* value, gpointer v_object);
gpointer value_get_photo_file_adapter (const GValue* value);
GType photo_file_adapter_get_type (void) G_GNUC_CONST;
GType photo_file_reader_get_type (void) G_GNUC_CONST;
PhotoFileReader* photo_file_format_create_reader (PhotoFileFormat self, const gchar* filepath);
gchar* string_sliced_at_last_char (const gchar* haystack, gunichar ch, gint start_index);
gchar* string_sliced_at (const gchar* str, gint index);
gboolean is_string_empty (const gchar* s);
#define BACKING_PHOTO_ID_INVALID ((gint64) -1)
static BackingPhotoRow* photo_get_backing_row (Photo* self, BackingPhotoID* id);
gpointer database_table_ref (gpointer instance);
void database_table_unref (gpointer instance);
GParamSpec* param_spec_database_table (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_database_table (GValue* value, gpointer v_object);
void value_take_database_table (GValue* value, gpointer v_object);
gpointer value_get_database_table (const GValue* value);
GType database_table_get_type (void) G_GNUC_CONST;
GType photo_table_get_type (void) G_GNUC_CONST;
PhotoTable* photo_table_get_instance (void);
GQuark database_error_quark (void);
void photo_table_detach_editable (PhotoTable* self, PhotoRow* row, GError** error);
static void photo_internal_remove_all_transformations (Photo* self, gboolean notify);
RawDeveloper* raw_developer_as_array (int* result_length1);
void photo_init_photo (void);
void photo_terminate_photo (void);
void photo_notify_editable_replaced (Photo* self, GFile* old_file, GFile* new_file);
static void photo_real_notify_editable_replaced (Photo* self, GFile* old_file, GFile* new_file);
void photo_notify_raw_development_modified (Photo* self);
static void photo_real_notify_raw_development_modified (Photo* self);
void photo_notify_baseline_replaced (Photo* self);
static void photo_real_notify_baseline_replaced (Photo* self);
void photo_notify_master_reimported (Photo* self, PhotoMetadata* metadata);
static void photo_real_notify_master_reimported (Photo* self, PhotoMetadata* metadata);
void photo_notify_editable_reimported (Photo* self, PhotoMetadata* metadata);
static void photo_real_notify_editable_reimported (Photo* self, PhotoMetadata* metadata);
void photo_notify_source_reimported (Photo* self, PhotoMetadata* metadata);
static void photo_real_notify_source_reimported (Photo* self, PhotoMetadata* metadata);
void photo_notify_baseline_reimported (Photo* self, PhotoMetadata* metadata);
static void photo_real_notify_baseline_reimported (Photo* self, PhotoMetadata* metadata);
static gboolean photo_real_internal_delete_backing (DataSource* base, GError** error);
GFile* photo_file_adapter_get_file (PhotoFileAdapter* self);
static void photo_detach_editable (Photo* self, gboolean delete_editable, gboolean remove_transformations, gboolean notify);
PhotoFileFormat photo_get_master_file_format (Photo* self);
static gboolean photo_delete_raw_development (Photo* self, RawDeveloper d);
gchar* data_object_to_string (DataObject* self);
gboolean data_source_internal_delete_backing (DataSource* self, GError** error);
GType backing_photo_table_get_type (void) G_GNUC_CONST;
BackingPhotoTable* backing_photo_table_get_instance (void);
BackingPhotoRow* backing_photo_table_fetch (BackingPhotoTable* self, BackingPhotoID* id, GError** error);
void backing_photo_table_remove (BackingPhotoTable* self, BackingPhotoID* backing_id, GError** error);
gboolean photo_is_raw_developer_complete (Photo* self, RawDeveloper d);
gboolean photo_is_raw_developer_available (Photo* self, RawDeveloper d);
PhotoMetadata* photo_get_master_metadata (Photo* self, GError** error);
guint photo_metadata_get_preview_count (PhotoMetadata* self);
gpointer photo_preview_ref (gpointer instance);
void photo_preview_unref (gpointer instance);
GParamSpec* param_spec_photo_preview (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_preview (GValue* value, gpointer v_object);
void value_take_photo_preview (GValue* value, gpointer v_object);
gpointer value_get_photo_preview (const GValue* value);
GType photo_preview_get_type (void) G_GNUC_CONST;
PhotoPreview* photo_metadata_get_preview (PhotoMetadata* self, guint number);
void photo_preview_get_pixel_dimensions (PhotoPreview* self, Dimensions* result);
void photo_add_backing_photo_for_development (Photo* self, RawDeveloper d, BackingPhotoRow* bpr, GError** error);
void photo_import_developed_backing_photo (PhotoRow* row, RawDeveloper d, BackingPhotoRow* bpr, GError** error);
void data_object_notify_altered (DataObject* self, Alteration* alteration);
Alteration* alteration_new (const gchar* subject, const gchar* detail);
Alteration* alteration_construct (GType object_type, const gchar* subject, const gchar* detail);
#define UTIL_FILE_ATTRIBUTES "standard::*,time::*,id::file,id::filesystem,etag::value"
#define DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES UTIL_FILE_ATTRIBUTES
gpointer photo_file_interrogator_ref (gpointer instance);
void photo_file_interrogator_unref (gpointer instance);
GParamSpec* param_spec_photo_file_interrogator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_interrogator (GValue* value, gpointer v_object);
void value_take_photo_file_interrogator (GValue* value, gpointer v_object);
gpointer value_get_photo_file_interrogator (const GValue* value);
GType photo_file_interrogator_get_type (void) G_GNUC_CONST;
PhotoFileInterrogator* photo_file_interrogator_new (GFile* file, PhotoFileSnifferOptions options);
PhotoFileInterrogator* photo_file_interrogator_construct (GType object_type, GFile* file, PhotoFileSnifferOptions options);
void photo_file_interrogator_interrogate (PhotoFileInterrogator* self, GError** error);
gpointer detected_photo_information_ref (gpointer instance);
void detected_photo_information_unref (gpointer instance);
GParamSpec* param_spec_detected_photo_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_detected_photo_information (GValue* value, gpointer v_object);
void value_take_detected_photo_information (GValue* value, gpointer v_object);
gpointer value_get_detected_photo_information (const GValue* value);
GType detected_photo_information_get_type (void) G_GNUC_CONST;
DetectedPhotoInformation* photo_file_interrogator_get_detected_photo_information (PhotoFileInterrogator* self);
gboolean photo_file_interrogator_get_is_photo_corrupted (PhotoFileInterrogator* self);
Orientation photo_metadata_get_orientation (PhotoMetadata* self);
void backing_photo_table_add (BackingPhotoTable* self, BackingPhotoRow* state, GError** error);
void photo_table_update_raw_development (PhotoTable* self, PhotoRow* row, RawDeveloper rd, BackingPhotoID* backing_photo_id, GError** error);
static void photo_develop_photo (Photo* self, RawDeveloper d);
BackingPhotoRow* raw_developer_create_backing_row_for_development (RawDeveloper self, const gchar* raw_filepath, const gchar* camera_development_filename, GError** error);
GdkPixbuf* photo_get_master_pixbuf (Photo* self, Scaling* scaling, gboolean rotate, GError** error);
void scaling_for_original (Scaling* result);
GType photo_file_writer_get_type (void) G_GNUC_CONST;
GQuark photo_format_error_quark (void);
PhotoFileWriter* photo_file_format_create_writer (PhotoFileFormat self, const gchar* filepath, GError** error);
GType jpeg_quality_get_type (void) G_GNUC_CONST;
void photo_file_writer_write (PhotoFileWriter* self, GdkPixbuf* pixbuf, JpegQuality quality, GError** error);
GType photo_file_metadata_writer_get_type (void) G_GNUC_CONST;
PhotoFileMetadataWriter* photo_file_format_create_metadata_writer (PhotoFileFormat self, const gchar* filepath, GError** error);
void photo_file_metadata_writer_write_metadata (PhotoFileMetadataWriter* self, PhotoMetadata* metadata, GError** error);
GdkPixbuf* photo_preview_get_pixbuf (PhotoPreview* self, GError** error);
void photo_set_default_raw_developer (Photo* self, RawDeveloper d);
void photo_set_raw_developer (Photo* self, RawDeveloper d);
void photo_revert_to_master (Photo* self, gboolean notify);
GdkPixbuf* photo_get_prefetched_copy (Photo* self, GError** error);
gboolean photo_set_orientation (Photo* self, Orientation orientation);
void photo_discard_prefetched (Photo* self);
RawDeveloper photo_get_raw_developer (Photo* self);
gchar* raw_developer_to_string (RawDeveloper self);
void photo_table_remove_development (PhotoTable* self, PhotoRow* row, RawDeveloper rd, GError** error);
void photo_redevelop_raw (Photo* self, RawDeveloper d);
static BackingFileState** photo_real_get_backing_files_state (MediaSource* base, int* result_length1);
BackingFileState* backing_file_state_new_from_photo_row (BackingPhotoRow* photo_row, const gchar* md5);
BackingFileState* backing_file_state_construct_from_photo_row (GType object_type, BackingPhotoRow* photo_row, const gchar* md5);
static void _vala_array_add85 (BackingFileState*** array, int* length, int* size, BackingFileState* value);
gboolean photo_has_editable (Photo* self);
static void _vala_array_add86 (BackingFileState*** array, int* length, int* size, BackingFileState* value);
gboolean photo_is_developed (Photo* self);
GeeCollection* photo_get_raw_development_photo_rows (Photo* self);
static void _vala_array_add87 (BackingFileState*** array, int* length, int* size, BackingFileState* value);
static PhotoFileReader* photo_get_backing_reader (Photo* self, BackingFetchMode mode);
static PhotoFileReader* photo_get_master_reader (Photo* self);
static PhotoFileReader* photo_get_baseline_reader (Photo* self);
static PhotoFileReader* photo_get_source_reader (Photo* self);
static PhotoFileReader* photo_get_raw_developer_reader (Photo* self);
const gchar* backing_fetch_mode_to_string (BackingFetchMode self);
PhotoFileReader* photo_get_editable_reader (Photo* self);
gboolean photo_does_master_exist (Photo* self);
gboolean photo_file_adapter_file_exists (PhotoFileAdapter* self);
gboolean photo_does_editable_exist (Photo* self);
gboolean photo_is_master_baseline (Photo* self);
gboolean photo_is_master_source (Photo* self);
gboolean photo_is_editable_baseline (Photo* self);
gboolean photo_is_editable_source (Photo* self);
BackingPhotoRow* photo_get_master_photo_row (Photo* self);
BackingPhotoRow* photo_get_editable_photo_row (Photo* self);
gboolean backing_photo_id_is_valid (BackingPhotoID *self);
BackingPhotoRow* photo_get_raw_development_photo_row (Photo* self, RawDeveloper d);
PhotoFileFormat* photo_get_editable_file_format (Photo* self);
PhotoFileFormat photo_file_adapter_get_file_format (PhotoFileAdapter* self);
static PhotoFileFormat* _photo_file_format_dup (PhotoFileFormat* self);
GType export_format_parameters_get_type (void) G_GNUC_CONST;
GType export_format_mode_get_type (void) G_GNUC_CONST;
ExportFormatParameters* export_format_parameters_dup (const ExportFormatParameters* self);
void export_format_parameters_free (ExportFormatParameters* self);
PhotoFileFormat photo_get_export_format_for_parameters (Photo* self, ExportFormatParameters* params);
PhotoFileFormat photo_file_format_get_system_default_format (void);
PhotoFileFormat photo_get_best_export_file_format (Photo* self);
gchar* photo_get_export_basename_for_parameters (Photo* self, ExportFormatParameters* params);
GFile* media_source_get_master_file (MediaSource* self);
gchar* photo_get_export_basename (Photo* self, PhotoFileFormat* file_format);
GType import_result_get_type (void) G_GNUC_CONST;
ImportResult photo_prepare_for_import (PhotoImportParams* params);
gboolean photo_is_file_image (GFile* file);
gboolean photo_file_format_is_file_supported (GFile* file);
gpointer metadata_date_time_ref (gpointer instance);
void metadata_date_time_unref (gpointer instance);
GParamSpec* param_spec_metadata_date_time (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_metadata_date_time (GValue* value, gpointer v_object);
void value_take_metadata_date_time (GValue* value, gpointer v_object);
gpointer value_get_metadata_date_time (const GValue* value);
GType metadata_date_time_get_type (void) G_GNUC_CONST;
MetadataDateTime* photo_metadata_get_exposure_date_time (PhotoMetadata* self);
time_t metadata_date_time_get_timestamp (MetadataDateTime* self);
gchar* media_metadata_get_title (MediaMetadata* self);
gchar* media_metadata_get_comment (MediaMetadata* self);
GeeSet* photo_metadata_get_keywords (PhotoMetadata* self, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify);
Rating photo_metadata_get_rating (PhotoMetadata* self);
#define PHOTO_ID_INVALID ((gint64) -1)
void photo_id_init (PhotoID *self, gint64 id);
#define EVENT_ID_INVALID ((gint64) -1)
void event_id_init (EventID *self, gint64 id);
GType photo_file_reader_role_get_type (void) G_GNUC_CONST;
void photo_file_reader_set_role (PhotoFileReader* self, PhotoFileReaderRole role);
void thumbnail_cache_generate_for_photo (Thumbnails* thumbnails, PhotoFileReader* reader, Orientation orientation, Dimensions* original_dim, GError** error);
ImportResult import_result_convert_error (GError* err, ImportResult default_result);
void photo_create_pre_import (PhotoImportParams* params);
void dimensions_init (Dimensions *self, gint width, gint height);
BackingPhotoRow* photo_query_backing_photo_row (Photo* self, GFile* file, PhotoFileSnifferOptions options, DetectedPhotoInformation** detected, GError** error);
gpointer photo_reimport_master_state_ref (gpointer instance);
void photo_reimport_master_state_unref (gpointer instance);
GParamSpec* photo_param_spec_reimport_master_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void photo_value_set_reimport_master_state (GValue* value, gpointer v_object);
void photo_value_take_reimport_master_state (GValue* value, gpointer v_object);
gpointer photo_value_get_reimport_master_state (const GValue* value);
GType photo_reimport_master_state_get_type (void) G_GNUC_CONST;
gboolean photo_prepare_for_reimport_master (Photo* self, PhotoReimportMasterState** reimport_state, GError** error);
static void _vala_array_add88 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add89 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add90 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add91 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add92 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add93 (gchar*** array, int* length, int* size, gchar* value);
static PhotoReimportMasterStateImpl* photo_reimport_master_state_impl_new (PhotoRow* row, PhotoMetadata* metadata, gchar** alterations, int alterations_length1);
static PhotoReimportMasterStateImpl* photo_reimport_master_state_impl_construct (GType object_type, PhotoRow* row, PhotoMetadata* metadata, gchar** alterations, int alterations_length1);
static GType photo_reimport_master_state_impl_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
void photo_apply_user_metadata_for_reimport (Photo* self, PhotoMetadata* metadata);
static void photo_real_apply_user_metadata_for_reimport (Photo* self, PhotoMetadata* metadata);
void photo_finish_reimport_master (Photo* self, PhotoReimportMasterState* state, GError** error);
void photo_table_reimport (PhotoTable* self, PhotoRow* row, GError** error);
void backing_photo_row_copy_from (BackingPhotoRow* self, BackingPhotoRow* from);
static void _vala_array_add94 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add95 (gchar*** array, int* length, int* size, gchar* value);
Alteration* alteration_new_from_array (gchar** array, int array_length1);
Alteration* alteration_construct_from_array (GType object_type, gchar** array, int array_length1);
static gboolean photo_verify_file_for_reimport (Photo* self, GFile* file, BackingPhotoRow** backing, DetectedPhotoInformation** detected, GError** error);
gpointer photo_reimport_editable_state_ref (gpointer instance);
void photo_reimport_editable_state_unref (gpointer instance);
GParamSpec* photo_param_spec_reimport_editable_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void photo_value_set_reimport_editable_state (GValue* value, gpointer v_object);
void photo_value_take_reimport_editable_state (GValue* value, gpointer v_object);
gpointer photo_value_get_reimport_editable_state (const GValue* value);
GType photo_reimport_editable_state_get_type (void) G_GNUC_CONST;
gboolean photo_prepare_for_reimport_editable (Photo* self, PhotoReimportEditableState** state, GError** error);
GFile* photo_get_editable_file (Photo* self);
static PhotoReimportEditableStateImpl* photo_reimport_editable_state_impl_new (BackingPhotoRow* backing_state, PhotoMetadata* metadata);
static PhotoReimportEditableStateImpl* photo_reimport_editable_state_impl_construct (GType object_type, BackingPhotoRow* backing_state, PhotoMetadata* metadata);
static GType photo_reimport_editable_state_impl_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
void photo_finish_reimport_editable (Photo* self, PhotoReimportEditableState* state, GError** error);
void photo_get_editable_id (Photo* self, BackingPhotoID* result);
gboolean backing_photo_id_is_invalid (BackingPhotoID *self);
void backing_photo_table_update (BackingPhotoTable* self, BackingPhotoRow* row, GError** error);
void media_source_set_title (MediaSource* self, const gchar* title);
gboolean media_source_set_comment (MediaSource* self, const gchar* comment);
void media_source_set_rating (MediaSource* self, Rating rating);
Alteration* alteration_new_from_list (const gchar* list);
Alteration* alteration_construct_from_list (GType object_type, const gchar* list);
gpointer photo_reimport_raw_development_state_ref (gpointer instance);
void photo_reimport_raw_development_state_unref (gpointer instance);
GParamSpec* photo_param_spec_reimport_raw_development_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void photo_value_set_reimport_raw_development_state (GValue* value, gpointer v_object);
void photo_value_take_reimport_raw_development_state (GValue* value, gpointer v_object);
gpointer photo_value_get_reimport_raw_development_state (const GValue* value);
GType photo_reimport_raw_development_state_get_type (void) G_GNUC_CONST;
gboolean photo_prepare_for_reimport_raw_development (Photo* self, PhotoReimportRawDevelopmentState** state, GError** error);
GeeCollection* photo_get_raw_developer_files (Photo* self);
static GType photo_reimport_raw_development_state_impl_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static PhotoReimportRawDevelopmentStateImpl* photo_reimport_raw_development_state_impl_new (void);
static PhotoReimportRawDevelopmentStateImpl* photo_reimport_raw_development_state_impl_construct (GType object_type);
static void photo_reimport_raw_development_state_impl_add (PhotoReimportRawDevelopmentStateImpl* self, BackingPhotoRow* backing, PhotoMetadata* metadata);
static gint photo_reimport_raw_development_state_impl_get_size (PhotoReimportRawDevelopmentStateImpl* self);
void photo_finish_reimport_raw_development (Photo* self, PhotoReimportRawDevelopmentState* state, GError** error);
static gpointer photo_reimport_raw_development_state_impl_dev_to_reimport_ref (gpointer instance);
static void photo_reimport_raw_development_state_impl_dev_to_reimport_unref (gpointer instance);
static GParamSpec* photo_reimport_raw_development_state_impl_param_spec_dev_to_reimport (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void photo_reimport_raw_development_state_impl_value_set_dev_to_reimport (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void photo_reimport_raw_development_state_impl_value_take_dev_to_reimport (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer photo_reimport_raw_development_state_impl_value_get_dev_to_reimport (const GValue* value) G_GNUC_UNUSED;
GType photo_reimport_raw_development_state_impl_dev_to_reimport_get_type (void) G_GNUC_CONST;
static gchar* photo_real_get_typename (DataSource* base);
static gint64 photo_real_get_instance_id (DataSource* base);
void photo_get_photo_id (Photo* self, PhotoID* result);
static gchar* photo_real_get_source_id (DataSource* base);
gchar* data_source_get_typename (DataSource* self);
gint64 data_source_get_instance_id (DataSource* self);
void photo_set_master_timestamp (Photo* self, GFileInfo* info);
void photo_table_update_timestamp (PhotoTable* self, PhotoID* photo_id, time_t timestamp, GError** error);
void app_window_database_error (GError* err);
void photo_update_editable_modification_time (Photo* self, GFileInfo* info, GError** error);
void backing_photo_table_update_timestamp (BackingPhotoTable* self, BackingPhotoID* id, time_t timestamp, GError** error);
void photo_update_many_editable_timestamps (GeeMap* map, GError** error);
void database_table_begin_transaction (void);
void database_table_commit_transaction (GError** error);
static PhotoFileFormat photo_real_get_preferred_thumbnail_format (ThumbnailSource* base);
PhotoFileFormat photo_get_file_format (Photo* self);
gboolean photo_file_format_can_write_image (PhotoFileFormat self);
static GdkPixbuf* photo_real_create_thumbnail (ThumbnailSource* base, gint scale, GError** error);
GdkPixbuf* photo_source_get_pixbuf (PhotoSource* self, Scaling* scaling, GError** error);
void scaling_for_best_fit (gint pixels, gboolean scale_up, Scaling* result);
static gboolean photo_is_extension_found (const gchar* basename, gchar** extensions, int extensions_length1);
void disassemble_filename (const gchar* basename, gchar** name, gchar** ext);
gboolean photo_is_duplicate (GFile* file, const gchar* thumbnail_md5, const gchar* full_md5, PhotoFileFormat file_format);
gboolean photo_table_has_duplicate (PhotoTable* self, GFile* file, const gchar* thumbnail_md5, const gchar* md5, PhotoFileFormat file_format);
PhotoID* photo_get_duplicate_ids (GFile* file, const gchar* thumbnail_md5, const gchar* full_md5, PhotoFileFormat file_format, int* result_length1);
PhotoID* photo_table_get_duplicate_ids (PhotoTable* self, GFile* file, const gchar* thumbnail_md5, const gchar* md5, PhotoFileFormat file_format, int* result_length1);
gint64 photo_get_photo_key (DataSource* source);
GType library_photo_get_type (void) G_GNUC_CONST;
static GFile* photo_real_get_file (MediaSource* base);
void photo_set_master_file (Photo* self, GFile* file);
void photo_table_set_filepath (PhotoTable* self, PhotoID* photo_id, const gchar* filepath, GError** error);
void media_source_notify_master_replaced (MediaSource* self, GFile* old_file, GFile* new_file);
static void _vala_array_add96 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add97 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add98 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add99 (gchar*** array, int* length, int* size, gchar* value);
void photo_set_editable_file (Photo* self, GFile* file);
void backing_photo_table_set_filepath (BackingPhotoTable* self, BackingPhotoID* id, const gchar* filepath, GError** error);
static void _vala_array_add100 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add101 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add102 (gchar*** array, int* length, int* size, gchar* value);
void photo_set_many_editable_file (GeeMap* map, GError** error);
GFile* photo_get_actual_file (Photo* self);
static GFile* photo_real_get_master_file (MediaSource* base);
GFile* photo_get_source_file (Photo* self);
gboolean photo_file_format_can_write (PhotoFileFormat self);
static time_t photo_real_get_timestamp (MediaSource* base);
static inline void photo_real_get_event_id (MediaSource* base, EventID* result);
gint64 photo_get_raw_event_id (Photo* self);
static void photo_real_get_import_id (MediaSource* base, ImportID* result);
static gchar* photo_real_get_master_md5 (MediaSource* base);
guint64 photo_get_flags (Photo* self);
static void photo_notify_flags_altered (Photo* self, Alteration* additional_alteration);
Alteration* alteration_compress (Alteration* self, Alteration* other);
guint64 photo_replace_flags (Photo* self, guint64 flags, Alteration* additional_alteration);
gboolean photo_table_replace_flags (PhotoTable* self, PhotoID* photo_id, guint64 flags);
gboolean photo_is_flag_set (Photo* self, guint64 mask);
gboolean media_source_internal_is_flag_set (guint64 flags, guint64 selector);
guint64 photo_add_flags (Photo* self, guint64 mask, Alteration* additional_alteration);
guint64 media_source_internal_add_flags (guint64 flags, guint64 selector);
guint64 photo_remove_flags (Photo* self, guint64 mask, Alteration* additional_alteration);
guint64 media_source_internal_remove_flags (guint64 flags, guint64 selector);
guint64 photo_add_remove_flags (Photo* self, guint64 add, guint64 remove, Alteration* additional_alteration);
void photo_add_remove_many_flags (GeeCollection* add, guint64 add_mask, Alteration* additional_add_alteration, GeeCollection* remove, guint64 remove_mask, Alteration* additional_remove_alteration, GError** error);
guint64 photo_toggle_flags (Photo* self, guint64 mask, Alteration* additional_alteration);
gboolean photo_is_master_metadata_dirty (Photo* self);
void photo_set_master_metadata_dirty (Photo* self, gboolean dirty, GError** error);
void photo_table_set_metadata_dirty (PhotoTable* self, PhotoID* photo_id, gboolean dirty, GError** error);
static Rating photo_real_get_rating (MediaSource* base);
static void photo_real_set_rating (MediaSource* base, Rating rating);
gboolean photo_table_set_rating (PhotoTable* self, PhotoID* photo_id, Rating rating);
static void photo_real_increase_rating (MediaSource* base);
static void photo_real_decrease_rating (MediaSource* base);
static void photo_real_commit_backlinks (DataSource* base, SourceCollection* sources, const gchar* backlinks);
void photo_table_update_backlinks (PhotoTable* self, PhotoID* photo_id, const gchar* backlinks, GError** error);
static gboolean photo_real_set_event_id (MediaSource* base, EventID* event_id);
gboolean photo_table_set_event (PhotoTable* self, PhotoID* photo_id, EventID* event_id);
static gchar* photo_real_to_string (DataObject* base);
gchar* photo_file_adapter_get_filepath (PhotoFileAdapter* self);
static gboolean photo_real_equals (DataSource* base, DataSource* source);
gboolean data_source_equals (DataSource* self, DataSource* source);
static void photo_file_exif_updated (Photo* self);
GFile* media_source_get_file (MediaSource* self);
gboolean photo_table_master_exif_updated (PhotoTable* self, PhotoID* photoID, gint64 filesize, glong timestamp, const gchar* md5, const gchar* exif_md5, const gchar* thumbnail_md5, PhotoRow* row);
static guint64 photo_real_get_filesize (MediaSource* base);
static guint64 photo_real_get_master_filesize (MediaSource* base);
guint64 photo_get_editable_filesize (Photo* self);
static time_t photo_real_get_exposure_time (Dateable* base);
static gchar* photo_real_get_basename (MediaSource* base);
static gchar* photo_real_get_title (MediaSource* base);
static gchar* photo_real_get_comment (MediaSource* base);
static void photo_real_set_title (MediaSource* base, const gchar* title);
gboolean photo_table_set_title (PhotoTable* self, PhotoID* photo_id, const gchar* new_title);
static gboolean photo_real_set_comment (MediaSource* base, const gchar* comment);
gboolean photo_table_set_comment (PhotoTable* self, PhotoID* photo_id, const gchar* new_comment);
void photo_set_import_id (Photo* self, ImportID* import_id);
void photo_table_set_import_id (PhotoTable* self, PhotoID* photo_id, ImportID* import_id, GError** error);
void photo_set_title_persistent (Photo* self, const gchar* title, GError** error);
gboolean photo_file_format_can_write_metadata (PhotoFileFormat self);
PhotoMetadata* photo_file_reader_read_metadata (PhotoFileReader* self, GError** error);
GType photo_metadata_set_option_get_type (void) G_GNUC_CONST;
void photo_metadata_set_title (PhotoMetadata* self, const gchar* title, PhotoMetadataSetOption option);
PhotoFileMetadataWriter* photo_file_reader_create_metadata_writer (PhotoFileReader* self, GError** error);
void library_monitor_blacklist_file (GFile* file, const gchar* reason);
void library_monitor_unblacklist_file (GFile* file);
void photo_set_comment_persistent (Photo* self, const gchar* comment, GError** error);
void photo_metadata_set_comment (PhotoMetadata* self, const gchar* comment, PhotoMetadataSetOption option);
static void photo_real_set_exposure_time (Dateable* base, time_t time);
gboolean photo_table_set_exposure_time (PhotoTable* self, PhotoID* photo_id, time_t time);
void photo_set_exposure_time_persistent (Photo* self, time_t time, GError** error);
void dateable_set_exposure_time (Dateable* self, time_t target_time);
void photo_metadata_set_exposure_date_time (PhotoMetadata* self, MetadataDateTime* date_time, PhotoMetadataSetOption option);
MetadataDateTime* metadata_date_time_new (time_t timestamp);
MetadataDateTime* metadata_date_time_construct (GType object_type, time_t timestamp);
static void photo_real_get_dimensions (MediaSource* base, PhotoException disallowed_steps, Dimensions* result);
void photo_get_raw_dimensions (Photo* self, Dimensions* result);
Orientation photo_get_orientation (Photo* self);
gboolean photo_get_straighten (Photo* self, gdouble* theta);
void compute_arb_rotated_size (gdouble src_width, gdouble src_height, gdouble angle, gdouble* dest_width, gdouble* dest_height);
GType box_get_type (void) G_GNUC_CONST;
Box* box_dup (const Box* self);
void box_free (Box* self);
gboolean photo_get_crop (Photo* self, Box* crop, PhotoException exceptions);
void box_get_dimensions (Box *self, Dimensions* result);
static void photo_locked_create_adjustments_from_data (Photo* self);
PixelTransformationBundle* pixel_transformation_bundle_new (void);
PixelTransformationBundle* pixel_transformation_bundle_construct (GType object_type);
static KeyValueMap* photo_get_transformation (Photo* self, const gchar* name);
void pixel_transformation_bundle_set_to_identity (PixelTransformationBundle* self);
void pixel_transformation_bundle_load (PixelTransformationBundle* self, KeyValueMap* store);
PixelTransformer* pixel_transformation_bundle_generate_transformer (PixelTransformationBundle* self);
PixelTransformationBundle* photo_get_color_adjustments (Photo* self);
PixelTransformationBundle* pixel_transformation_bundle_copy (PixelTransformationBundle* self);
PixelTransformer* photo_get_pixel_transformer (Photo* self);
PixelTransformer* pixel_transformer_copy (PixelTransformer* self);
gboolean photo_has_color_adjustments (Photo* self);
static gboolean photo_has_transformation (Photo* self, const gchar* name);
GType pixel_transformation_type_get_type (void) G_GNUC_CONST;
gpointer pixel_transformation_ref (gpointer instance);
void pixel_transformation_unref (gpointer instance);
GParamSpec* param_spec_pixel_transformation (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pixel_transformation (GValue* value, gpointer v_object);
void value_take_pixel_transformation (GValue* value, gpointer v_object);
gpointer value_get_pixel_transformation (const GValue* value);
GType pixel_transformation_get_type (void) G_GNUC_CONST;
PixelTransformation* photo_get_color_adjustment (Photo* self, PixelTransformationType type);
PixelTransformation* pixel_transformation_bundle_get_transformation (PixelTransformationBundle* self, PixelTransformationType type);
void photo_set_color_adjustments (Photo* self, PixelTransformationBundle* new_adjustments);
gboolean pixel_transformation_bundle_is_identity (PixelTransformationBundle* self);
static gboolean photo_remove_transformation (Photo* self, const gchar* name);
KeyValueMap* pixel_transformation_bundle_save (PixelTransformationBundle* self, const gchar* group);
GeeIterable* pixel_transformation_bundle_get_transformations (PixelTransformationBundle* self);
void pixel_transformer_replace_transformation (PixelTransformer* self, PixelTransformation* old_trans, PixelTransformation* new_trans);
PixelTransformationType pixel_transformation_get_transformation_type (PixelTransformation* self);
static gboolean photo_set_transformation (Photo* self, KeyValueMap* trans);
static PhotoMetadata* photo_real_get_metadata (PhotoSource* base);
PhotoMetadata* photo_get_editable_metadata (Photo* self, GError** error);
gboolean photo_persist_master_metadata (Photo* self, PhotoMetadata* metadata, PhotoReimportMasterState** state, GError** error);
void photo_finish_update_master_metadata (Photo* self, PhotoReimportMasterState* state, GError** error);
gboolean photo_persist_editable_metadata (Photo* self, PhotoMetadata* metadata, PhotoReimportEditableState** state, GError** error);
void photo_finish_update_editable_metadata (Photo* self, PhotoReimportEditableState* state, GError** error);
gboolean photo_has_transformations (Photo* self);
gboolean photo_only_metadata_changed (Photo* self);
PhotoMetadata* photo_source_get_metadata (PhotoSource* self);
gboolean photo_has_alterations (Photo* self);
gchar* media_source_get_comment (MediaSource* self);
gchar* media_source_get_title (MediaSource* self);
PhotoTransformationState* photo_save_transformation_state (Photo* self);
static PhotoPhotoTransformationStateImpl* photo_photo_transformation_state_impl_new (Photo* photo, Orientation orientation, GeeHashMap* transformations, PixelTransformer* transformer, PixelTransformationBundle* adjustments);
static PhotoPhotoTransformationStateImpl* photo_photo_transformation_state_impl_construct (GType object_type, Photo* photo, Orientation orientation, GeeHashMap* transformations, PixelTransformer* transformer, PixelTransformationBundle* adjustments);
static GType photo_photo_transformation_state_impl_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
gboolean photo_load_transformation_state (Photo* self, PhotoTransformationState* state);
static Orientation photo_photo_transformation_state_impl_get_orientation (PhotoPhotoTransformationStateImpl* self);
static GeeHashMap* photo_photo_transformation_state_impl_get_transformations (PhotoPhotoTransformationStateImpl* self);
static PixelTransformer* photo_photo_transformation_state_impl_get_transformer (PhotoPhotoTransformationStateImpl* self);
static PixelTransformationBundle* photo_photo_transformation_state_impl_get_color_adjustments (PhotoPhotoTransformationStateImpl* self);
gboolean photo_table_set_transformation_state (PhotoTable* self, PhotoID* photo_id, Orientation orientation, GeeHashMap* transformations);
void photo_remove_all_transformations (Photo* self);
gboolean photo_table_remove_all_transformations (PhotoTable* self, PhotoID* photo_id);
gboolean photo_table_set_orientation (PhotoTable* self, PhotoID* photo_id, Orientation orientation);
Orientation photo_get_original_orientation (Photo* self);
gboolean photo_check_can_rotate (Photo* self);
void photo_rotate (Photo* self, Rotation rotation);
static void photo_real_rotate (Photo* self, Rotation rotation);
Orientation orientation_perform (Orientation self, Rotation rotation);
KeyValueMap* key_value_map_copy (KeyValueMap* self);
gchar* key_value_map_get_group (KeyValueMap* self);
gboolean photo_table_set_transformation (PhotoTable* self, PhotoID* photo_id, KeyValueMap* map);
gboolean photo_table_remove_transformation (PhotoTable* self, PhotoID* photo_id, const gchar* object);
gboolean photo_has_crop (Photo* self);
gboolean photo_get_raw_crop (Photo* self, Box* crop);
void box_init (Box *self, gint left, gint top, gint right, gint bottom);
gint key_value_map_get_int (KeyValueMap* self, const gchar* key, gint def);
static void photo_set_raw_crop (Photo* self, Box* crop);
KeyValueMap* key_value_map_new (const gchar* group);
KeyValueMap* key_value_map_construct (GType object_type, const gchar* group);
void key_value_map_set_int (KeyValueMap* self, const gchar* key, gint value);
static gboolean photo_get_raw_straighten (Photo* self, gdouble* angle);
gdouble key_value_map_get_double (KeyValueMap* self, const gchar* key, gdouble def);
static void photo_set_raw_straighten (Photo* self, gdouble theta);
void key_value_map_set_double (KeyValueMap* self, const gchar* key, gdouble value);
GType editing_tools_redeye_instance_get_type (void) G_GNUC_CONST;
EditingToolsRedeyeInstance* editing_tools_redeye_instance_dup (const EditingToolsRedeyeInstance* self);
void editing_tools_redeye_instance_free (EditingToolsRedeyeInstance* self);
static EditingToolsRedeyeInstance* photo_get_raw_redeye_instances (Photo* self, int* result_length1);
void key_value_map_get_point (KeyValueMap* self, const gchar* key, GdkPoint* def, GdkPoint* result);
gboolean photo_has_redeye_transformations (Photo* self);
void photo_add_redeye_instance (Photo* self, EditingToolsRedeyeInstance* redeye);
void key_value_map_set_point (KeyValueMap* self, const gchar* key, GdkPoint* point);
static gboolean photo_calculate_pixbuf_dimensions (Photo* self, Scaling* scaling, PhotoException exceptions, Dimensions* scaled_image, Dimensions* scaled_to_viewport);
static gboolean photo_locked_calculate_pixbuf_dimensions (Photo* self, Scaling* scaling, PhotoException exceptions, Dimensions* scaled_image, Dimensions* scaled_to_viewport);
gboolean scaling_is_unscaled (Scaling *self);
void orientation_rotate_box (Orientation self, Dimensions* space, Box* box, Box* result);
void orientation_rotate_dimensions (Orientation self, Dimensions* dim, Dimensions* result);
void box_get_scaled (Box *self, Dimensions* scaled, Box* result);
void scaling_get_scaled_dimensions (Scaling *self, Dimensions* original, Dimensions* result);
gint box_get_width (Box *self);
gint box_get_height (Box *self);
void dimensions_get_scaled_similar (Dimensions *self, Dimensions* original, Dimensions* scaled, Dimensions* result);
void orientation_derotate_dimensions (Orientation self, Dimensions* dim, Dimensions* result);
gboolean dimensions_has_area (Dimensions *self);
static GdkPixbuf* photo_load_raw_pixbuf (Photo* self, Scaling* scaling, PhotoException exceptions, BackingFetchMode fetch_mode, GError** error);
GdkPixbuf* photo_file_reader_unscaled_read (PhotoFileReader* self, GError** error);
GdkPixbuf* photo_file_reader_scaled_read (PhotoFileReader* self, Dimensions* full, Dimensions* scaled, GError** error);
gboolean dimensions_approx_equals (Dimensions *self, Dimensions* dim, gint fudge);
void dimensions_for_pixbuf (GdkPixbuf* pixbuf, Dimensions* result);
static GdkPixbuf* photo_get_untransformed_pixbuf (Photo* self, Scaling* scaling, gboolean rotate, BackingFetchMode fetch_mode, GError** error);
GdkPixbuf* photo_get_unmodified_pixbuf (Photo* self, Scaling* scaling, gboolean rotate, GError** error);
GdkPixbuf* orientation_rotate_pixbuf (Orientation self, GdkPixbuf* pixbuf);
static GdkPixbuf* photo_real_get_pixbuf (PhotoSource* base, Scaling* scaling, GError** error);
GdkPixbuf* photo_get_pixbuf_with_options (Photo* self, Scaling* scaling, PhotoException exceptions, BackingFetchMode fetch_mode, GError** error);
static GdkPixbuf* photo_run_source_pixbuf_cache (Photo* locate, gboolean keep, GError** error);
static PhotoCachedPixbuf* photo_cached_pixbuf_new (Photo* photo, GdkPixbuf* pixbuf);
static PhotoCachedPixbuf* photo_cached_pixbuf_construct (GType object_type, Photo* photo, GdkPixbuf* pixbuf);
static gboolean photo_trim_source_pixbuf_cache (void);
static gboolean _photo_trim_source_pixbuf_cache_gsource_func (gpointer self);
gboolean photo_get_develop_raw_photos_to_files (void);
void media_source_get_dimensions (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
gboolean dimensions_equals (Dimensions *self, Dimensions* dim);
static GdkPixbuf* photo_do_redeye (Photo* self, GdkPixbuf* pixbuf, EditingToolsRedeyeInstance* inst);
GdkPixbuf* rotate_arb (GdkPixbuf* source_pixbuf, gdouble angle);
void pixel_transformer_transform_pixbuf (PixelTransformer* self, GdkPixbuf* pixbuf, GCancellable* cancellable);
gboolean photo_has_user_generated_metadata (Photo* self);
static gboolean photo_real_has_user_generated_metadata (Photo* self);
void photo_set_user_metadata_for_export (Photo* self, PhotoMetadata* metadata);
static void photo_real_set_user_metadata_for_export (Photo* self, PhotoMetadata* metadata);
gpointer photo_file_format_properties_ref (gpointer instance);
void photo_file_format_properties_unref (gpointer instance);
GParamSpec* param_spec_photo_file_format_properties (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_format_properties (GValue* value, gpointer v_object);
void value_take_photo_file_format_properties (GValue* value, gpointer v_object);
gpointer value_get_photo_file_format_properties (const GValue* value);
GType photo_file_format_properties_get_type (void) G_GNUC_CONST;
PhotoFileFormatProperties* photo_file_format_get_properties (PhotoFileFormat self);
GFile* photo_file_format_properties_convert_file_extension (PhotoFileFormatProperties* self, GFile* file);
static gboolean photo_export_fullsized_backing (Photo* self, GFile* file, gboolean export_metadata, GError** error);
PhotoMetadata* photo_file_format_create_metadata (PhotoFileFormat self);
time_t media_source_get_exposure_time (MediaSource* self);
void photo_metadata_set_pixel_dimensions (PhotoMetadata* self, Dimensions* dim, PhotoMetadataSetOption option);
void photo_metadata_set_orientation (PhotoMetadata* self, Orientation orientation);
void photo_metadata_set_software (PhotoMetadata* self, const gchar* software, const gchar* version);
#define RESOURCES_APP_TITLE "Shotwell"
#define RESOURCES_APP_VERSION _VERSION
void photo_metadata_remove_exif_thumbnail (PhotoMetadata* self);
void photo_metadata_clear (PhotoMetadata* self);
gboolean photo_is_export_required (Photo* self, Scaling* scaling, PhotoFileFormat export_format);
void photo_export (Photo* self, GFile* dest_file, Scaling* scaling, JpegQuality quality, PhotoFileFormat export_format, gboolean direct_copy_unmodified, gboolean export_metadata, GError** error);
const gchar* photo_file_format_to_string (PhotoFileFormat self);
void photo_metadata_remove_tag (PhotoMetadata* self, const gchar* tag);
static GFile* photo_generate_new_editable_file (Photo* self, PhotoFileFormat* file_format, GError** error);
gboolean photo_file_format_properties_is_recognized_extension (PhotoFileFormatProperties* self, const gchar* ext);
gchar* photo_file_format_properties_get_default_extension (PhotoFileFormatProperties* self);
GFile* generate_unique_file (GFile* dir, const gchar* basename, gboolean* collision, GError** error);
static gboolean photo_launch_editor (GFile* file, PhotoFileFormat file_format, GError** error);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
gchar* configuration_facade_get_external_raw_app (ConfigurationFacade* self);
gchar* configuration_facade_get_external_photo_app (ConfigurationFacade* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void photo_open_with_raw_external_editor (Photo* self, GError** error);
void photo_open_with_external_editor (Photo* self, GError** error);
static void photo_halt_monitoring_editable (Photo* self);
static void photo_attach_editable (Photo* self, PhotoFileFormat file_format, GFile* file, GError** error);
static void photo_start_monitoring_editable (Photo* self, GFile* file, GError** error);
static void photo_on_editable_file_changed (Photo* self, GFile* file, GFile* other_file, GFileMonitorEvent event);
static void _photo_on_editable_file_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static void photo_update_editable (Photo* self, gboolean only_attributes, PhotoFileReader* new_reader, GError** error);
static void photo_update_editable_attributes (Photo* self, GError** error);
void photo_reimport_editable (Photo* self, GError** error);
void photo_table_attach_editable (PhotoTable* self, PhotoRow* row, BackingPhotoID* editable_id, GError** error);
void backing_photo_table_update_attributes (BackingPhotoTable* self, BackingPhotoID* id, time_t timestamp, gint64 filesize, GError** error);
static void _vala_array_add103 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add104 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add105 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add106 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add107 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add108 (gchar*** array, int* length, int* size, gchar* value);
void backing_photo_id_init (BackingPhotoID *self, gint64 id);
const gchar* g_file_monitor_event_to_string (GFileMonitorEvent self);
static void photo_on_reimport_editable (Photo* self);
static void _photo_on_reimport_editable_one_shot_callback (gpointer self);
OneShotScheduler* one_shot_scheduler_new (const gchar* name, OneShotCallback callback, void* callback_target);
OneShotScheduler* one_shot_scheduler_construct (GType object_type, const gchar* name, OneShotCallback callback, void* callback_target);
void one_shot_scheduler_after_timeout (OneShotScheduler* self, guint msec, gboolean reschedule);
static void photo_on_update_editable_attributes (Photo* self);
static void _photo_on_update_editable_attributes_one_shot_callback (gpointer self);
static void photo_on_remove_editable (Photo* self);
static void _photo_on_remove_editable_one_shot_callback (gpointer self);
void photo_get_original_dimensions (Photo* self, Dimensions* result);
void photo_get_master_dimensions (Photo* self, Dimensions* result);
void photo_set_crop (Photo* self, Box* crop);
void orientation_derotate_box (Orientation self, Dimensions* space, Box* box, Box* result);
void photo_set_straighten (Photo* self, gdouble theta);
static GdkPixbuf* photo_red_reduce_pixel (Photo* self, GdkPixbuf* pixbuf, gint x, gint y);
void photo_unscaled_to_raw_point (Photo* self, GdkPoint* unscaled_point, GdkPoint* result);
void orientation_derotate_point (Orientation self, Dimensions* space, GdkPoint* point, GdkPoint* result);
void photo_unscaled_to_raw_rect (Photo* self, GdkRectangle* unscaled_rect, GdkRectangle* result);
PixelTransformationBundle* photo_get_enhance_transformations (Photo* self);
PixelTransformationBundle* auto_enhance_create_auto_enhance_adjustments (GdkPixbuf* pixbuf);
gboolean photo_enhance (Photo* self);
void photo_set_develop_raw_photos_to_files (gboolean value);
static void photo_real_editable_replaced (Photo* self, GFile* old_file, GFile* new_file);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void photo_real_raw_development_modified (Photo* self);
static void photo_real_baseline_replaced (Photo* self);
static void photo_real_master_reimported (Photo* self, PhotoMetadata* metadata);
static void g_cclosure_user_marshal_VOID__MEDIA_METADATA (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void photo_real_editable_reimported (Photo* self, PhotoMetadata* metadata);
static void photo_real_baseline_reimported (Photo* self, PhotoMetadata* metadata);
static void photo_real_source_reimported (Photo* self, PhotoMetadata* metadata);
#define PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL, PhotoPhotoTransformationStateImplPrivate))
enum  {
	PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_DUMMY_PROPERTY
};
static void photo_photo_transformation_state_impl_on_photo_baseline_replaced (PhotoPhotoTransformationStateImpl* self);
static void _photo_photo_transformation_state_impl_on_photo_baseline_replaced_photo_baseline_replaced (Photo* _sender, gpointer self);
static GeeHashMap* photo_photo_transformation_state_impl_copy_transformations (GeeHashMap* original);
static void photo_photo_transformation_state_impl_finalize (GObject* obj);
enum  {
	PHOTO_BACKING_READERS_DUMMY_PROPERTY
};
static void photo_backing_readers_finalize (PhotoBackingReaders* obj);
enum  {
	PHOTO_CACHED_PIXBUF_DUMMY_PROPERTY
};
static void photo_cached_pixbuf_finalize (PhotoCachedPixbuf* obj);
enum  {
	PHOTO_REIMPORT_MASTER_STATE_DUMMY_PROPERTY
};
PhotoReimportMasterState* photo_reimport_master_state_construct (GType object_type);
static void photo_reimport_master_state_finalize (PhotoReimportMasterState* obj);
enum  {
	PHOTO_REIMPORT_MASTER_STATE_IMPL_DUMMY_PROPERTY
};
static gchar** _vala_array_dup28 (gchar** self, int length);
static void photo_reimport_master_state_impl_finalize (PhotoReimportMasterState* obj);
enum  {
	PHOTO_REIMPORT_EDITABLE_STATE_DUMMY_PROPERTY
};
PhotoReimportEditableState* photo_reimport_editable_state_construct (GType object_type);
static void photo_reimport_editable_state_finalize (PhotoReimportEditableState* obj);
enum  {
	PHOTO_REIMPORT_EDITABLE_STATE_IMPL_DUMMY_PROPERTY
};
static void photo_reimport_editable_state_impl_finalize (PhotoReimportEditableState* obj);
enum  {
	PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_DUMMY_PROPERTY
};
PhotoReimportRawDevelopmentState* photo_reimport_raw_development_state_construct (GType object_type);
static void photo_reimport_raw_development_state_finalize (PhotoReimportRawDevelopmentState* obj);
enum  {
	PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_DUMMY_PROPERTY
};
static PhotoReimportRawDevelopmentStateImplDevToReimport* photo_reimport_raw_development_state_impl_dev_to_reimport_new (BackingPhotoRow* backing, PhotoMetadata* metadata);
static PhotoReimportRawDevelopmentStateImplDevToReimport* photo_reimport_raw_development_state_impl_dev_to_reimport_construct (GType object_type, BackingPhotoRow* backing, PhotoMetadata* metadata);
enum  {
	PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_DEV_TO_REIMPORT_DUMMY_PROPERTY
};
static void photo_reimport_raw_development_state_impl_dev_to_reimport_finalize (PhotoReimportRawDevelopmentStateImplDevToReimport* obj);
static void photo_reimport_raw_development_state_impl_finalize (PhotoReimportRawDevelopmentState* obj);
static void photo_finalize (GObject* obj);
static void _vala_photo_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_photo_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType marker_get_type (void) G_GNUC_CONST;
gpointer source_backlink_ref (gpointer instance);
void source_backlink_unref (gpointer instance);
GParamSpec* param_spec_source_backlink (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_backlink (GValue* value, gpointer v_object);
void value_take_source_backlink (GValue* value, gpointer v_object);
gpointer value_get_source_backlink (const GValue* value);
GType source_backlink_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType media_source_collection_get_type (void) G_GNUC_CONST;
GType database_source_holding_tank_get_type (void) G_GNUC_CONST;
GType media_source_holding_tank_get_type (void) G_GNUC_CONST;
gpointer workers_ref (gpointer instance);
void workers_unref (gpointer instance);
GParamSpec* param_spec_workers (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_workers (GValue* value, gpointer v_object);
void value_take_workers (GValue* value, gpointer v_object);
gpointer value_get_workers (const GValue* value);
GType workers_get_type (void) G_GNUC_CONST;
GType media_monitor_get_type (void) G_GNUC_CONST;
gpointer transaction_controller_ref (gpointer instance);
void transaction_controller_unref (gpointer instance);
GParamSpec* param_spec_transaction_controller (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_transaction_controller (GValue* value, gpointer v_object);
void value_take_transaction_controller (GValue* value, gpointer v_object);
gpointer value_get_transaction_controller (const GValue* value);
GType transaction_controller_get_type (void) G_GNUC_CONST;
GType library_photo_source_collection_get_type (void) G_GNUC_CONST;
#define LIBRARY_PHOTO_SOURCE_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionPrivate))
enum  {
	LIBRARY_PHOTO_SOURCE_COLLECTION_DUMMY_PROPERTY
};
GType library_photo_source_collection_state_get_type (void) G_GNUC_CONST;
guint file_hash (GFile* file);
static guint _file_hash_gee_hash_data_func (gconstpointer v, gpointer self);
gboolean file_equal (GFile* a, GFile* b);
static gboolean _file_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
gint int64_compare (gint64* a, gint64* b);
static gint _int64_compare_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gint64* _int64_dup (gint64* self);
gboolean int64_equal (gint64* a, gint64* b);
static gboolean _int64_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
LibraryPhotoSourceCollection* library_photo_source_collection_new (void);
LibraryPhotoSourceCollection* library_photo_source_collection_construct (GType object_type);
static gint64 _photo_get_photo_key_get_source_database_key (DataSource* source, gpointer self);
MediaSourceCollection* media_source_collection_construct (GType object_type, const gchar* name, GetSourceDatabaseKey source_key_func, void* source_key_func_target);
MediaSourceHoldingTank* media_source_collection_get_trashcan (MediaSourceCollection* self);
static void library_photo_source_collection_on_trashcan_contents_altered (LibraryPhotoSourceCollection* self, GeeCollection* added, GeeCollection* removed);
static void _library_photo_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender, GeeCollection* added, GeeCollection* removed, gpointer self);
MediaSourceHoldingTank* media_source_collection_get_offline_bin (MediaSourceCollection* self);
static void library_photo_source_collection_on_offline_contents_altered (LibraryPhotoSourceCollection* self, GeeCollection* added, GeeCollection* removed);
static void _library_photo_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender, GeeCollection* added, GeeCollection* removed, gpointer self);
static MediaSourceHoldingTank* library_photo_source_collection_real_create_trashcan (MediaSourceCollection* base);
static gboolean library_photo_source_collection_check_if_trashed_photo (LibraryPhotoSourceCollection* self, DataSource* source, Alteration* alteration);
static gboolean _library_photo_source_collection_check_if_trashed_photo_source_holding_tank_check_to_keep (DataSource* source, Alteration* alteration, gpointer self);
LibraryPhotoSourceHoldingTank* library_photo_source_holding_tank_new (LibraryPhotoSourceCollection* sources, SourceHoldingTankCheckToKeep check_to_keep, void* check_to_keep_target, GetSourceDatabaseKey get_key, void* get_key_target);
LibraryPhotoSourceHoldingTank* library_photo_source_holding_tank_construct (GType object_type, LibraryPhotoSourceCollection* sources, SourceHoldingTankCheckToKeep check_to_keep, void* check_to_keep_target, GetSourceDatabaseKey get_key, void* get_key_target);
GType library_photo_source_holding_tank_get_type (void) G_GNUC_CONST;
static MediaSourceHoldingTank* library_photo_source_collection_real_create_offline_bin (MediaSourceCollection* base);
static gboolean library_photo_source_collection_check_if_offline_photo (LibraryPhotoSourceCollection* self, DataSource* source, Alteration* alteration);
static gboolean _library_photo_source_collection_check_if_offline_photo_source_holding_tank_check_to_keep (DataSource* source, Alteration* alteration, gpointer self);
static MediaMonitor* library_photo_source_collection_real_create_media_monitor (MediaSourceCollection* base, Workers* workers, GCancellable* cancellable);
PhotoMonitor* photo_monitor_new (Workers* workers, GCancellable* cancellable);
PhotoMonitor* photo_monitor_construct (GType object_type, Workers* workers, GCancellable* cancellable);
GType photo_monitor_get_type (void) G_GNUC_CONST;
static gboolean library_photo_source_collection_real_holds_type_of_source (SourceCollection* base, DataSource* source);
static gchar* library_photo_source_collection_real_get_typename (MediaSourceCollection* base);
static gboolean library_photo_source_collection_real_is_file_recognized (MediaSourceCollection* base, GFile* file);
static void library_photo_source_collection_real_notify_contents_altered (DataCollection* base, GeeIterable* added, GeeIterable* removed);
static void library_photo_source_collection_on_editable_replaced (LibraryPhotoSourceCollection* self, Photo* photo, GFile* old_file, GFile* new_file);
static void _library_photo_source_collection_on_editable_replaced_photo_editable_replaced (Photo* _sender, GFile* old_file, GFile* new_file, gpointer self);
static void library_photo_source_collection_on_raw_development_modified (LibraryPhotoSourceCollection* self, Photo* _photo);
static void _library_photo_source_collection_on_raw_development_modified_photo_raw_development_modified (Photo* _sender, gpointer self);
void data_collection_notify_contents_altered (DataCollection* self, GeeIterable* added, GeeIterable* removed);
static void library_photo_source_collection_real_items_altered (DataCollection* base, GeeMap* items);
gboolean alteration_has_detail (Alteration* self, const gchar* subject, const gchar* detail);
static void library_photo_source_collection_real_postprocess_imported_media (MediaSourceCollection* base, GeeCollection* media_sources);
GType tag_get_type (void) G_GNUC_CONST;
gpointer hierarchical_tag_index_ref (gpointer instance);
void hierarchical_tag_index_unref (gpointer instance);
GParamSpec* param_spec_hierarchical_tag_index (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_hierarchical_tag_index (GValue* value, gpointer v_object);
void value_take_hierarchical_tag_index (GValue* value, gpointer v_object);
gpointer value_get_hierarchical_tag_index (const GValue* value);
GType hierarchical_tag_index_get_type (void) G_GNUC_CONST;
HierarchicalTagIndex* hierarchical_tag_index_get_global_index (void);
gboolean photo_metadata_has_hierarchical_keywords (PhotoMetadata* self);
HierarchicalTagIndex* hierarchical_tag_utilities_process_hierarchical_import_keywords (GeeCollection* h_keywords);
GeeSet* photo_metadata_get_hierarchical_keywords (PhotoMetadata* self);
GeeCollection* library_photo_get_import_keywords (LibraryPhoto* self);
gboolean hierarchical_tag_index_is_tag_in_index (HierarchicalTagIndex* self, const gchar* tag);
gchar* tag_prep_tag_name (const gchar* name);
gchar* hierarchical_tag_index_get_path_for_name (HierarchicalTagIndex* self, const gchar* name);
Tag* tag_for_path (const gchar* name);
GeeCollection* hierarchical_tag_index_get_all_paths (HierarchicalTagIndex* self);
void library_photo_clear_import_keywords (LibraryPhoto* self);
void tag_attach_many (Tag* self, GeeCollection* sources);
void media_source_collection_postprocess_imported_media (MediaSourceCollection* self, GeeCollection* media);
void library_photo_source_collection_notify_master_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
static void library_photo_source_collection_real_notify_master_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
void library_photo_source_collection_notify_editable_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
static void library_photo_source_collection_real_notify_editable_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
void library_photo_source_collection_notify_source_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
static void library_photo_source_collection_real_notify_source_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
void library_photo_source_collection_notify_baseline_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
static void library_photo_source_collection_real_notify_baseline_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
static MediaSource* library_photo_source_collection_real_fetch_by_numeric_id (MediaSourceCollection* base, gint64 numeric_id);
LibraryPhoto* library_photo_source_collection_fetch (LibraryPhotoSourceCollection* self, PhotoID* photo_id);
gboolean media_source_is_trashed (MediaSource* self);
gboolean media_source_is_offline (MediaSource* self);
static MediaSource* library_photo_source_collection_real_fetch_by_source_id (MediaSourceCollection* base, const gchar* source_id);
MediaSource* media_source_collection_fetch_by_numeric_id (MediaSourceCollection* self, gint64 numeric_id);
gint64 parse_int64 (const gchar* str, gint num_base);
static GeeCollection* library_photo_source_collection_real_get_event_source_ids (MediaSourceCollection* base, EventID* event_id);
GeeArrayList* photo_table_get_event_source_ids (PhotoTable* self, EventID* event_id);
DataSource* database_source_collection_fetch_by_key (DatabaseSourceCollection* self, gint64 key);
LibraryPhoto* library_photo_source_collection_fetch_by_editable_file (LibraryPhotoSourceCollection* self, GFile* file);
LibraryPhoto* library_photo_source_collection_fetch_by_raw_development_file (LibraryPhotoSourceCollection* self, GFile* file);
static void library_photo_source_collection_compare_backing (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, GFileInfo* info, GeeCollection* matches_master, GeeCollection* matches_editable, GeeCollection* matches_development);
gboolean backing_photo_row_matches_file_info (BackingPhotoRow* self, GFileInfo* info);
void library_photo_source_collection_fetch_by_matching_backing (LibraryPhotoSourceCollection* self, GFileInfo* info, GeeCollection* matches_master, GeeCollection* matches_editable, GeeCollection* matched_development);
GeeCollection* media_source_collection_get_offline_bin_contents (MediaSourceCollection* self);
void library_photo_source_collection_get_basename_filesize_duplicate (LibraryPhotoSourceCollection* self, const gchar* basename, gint64 filesize, PhotoID* result);
gint utf8_ci_compare (void* a, void* b);
gboolean library_photo_source_collection_has_basename_filesize_duplicate (LibraryPhotoSourceCollection* self, const gchar* basename, gint64 filesize);
gboolean photo_id_is_valid (PhotoID *self);
LibraryPhoto* library_photo_source_collection_get_trashed_by_file (LibraryPhotoSourceCollection* self, GFile* file);
MediaSource* media_source_holding_tank_fetch_by_master_file (MediaSourceHoldingTank* self, GFile* file);
LibraryPhoto* library_photo_source_holding_tank_fetch_by_backing_file (LibraryPhotoSourceHoldingTank* self, GFile* file);
LibraryPhoto* library_photo_source_collection_get_trashed_by_md5 (LibraryPhotoSourceCollection* self, const gchar* md5);
MediaSource* media_source_holding_tank_fetch_by_md5 (MediaSourceHoldingTank* self, const gchar* md5);
LibraryPhoto* library_photo_source_collection_get_offline_by_file (LibraryPhotoSourceCollection* self, GFile* file);
LibraryPhoto* library_photo_source_collection_get_offline_by_md5 (LibraryPhotoSourceCollection* self, const gchar* md5);
gint library_photo_source_collection_get_offline_count (LibraryPhotoSourceCollection* self);
gint source_holding_tank_get_count (SourceHoldingTank* self);
LibraryPhoto* library_photo_source_collection_get_state_by_file (LibraryPhotoSourceCollection* self, GFile* file, LibraryPhotoSourceCollectionState* state);
MediaSource* media_source_collection_fetch_by_master_file (MediaSourceCollection* self, GFile* file);
static gboolean library_photo_source_collection_real_has_backlink (SourceCollection* base, SourceBacklink* backlink);
gboolean source_collection_has_backlink (SourceCollection* self, SourceBacklink* backlink);
gboolean source_holding_tank_has_backlink (SourceHoldingTank* self, SourceBacklink* backlink);
static void library_photo_source_collection_real_remove_backlink (SourceCollection* base, SourceBacklink* backlink);
void source_holding_tank_remove_backlink (SourceHoldingTank* self, SourceBacklink* backlink);
void source_collection_remove_backlink (SourceCollection* self, SourceBacklink* backlink);
MediaSourceTransactionController* media_source_transaction_controller_new (MediaSourceCollection* sources);
MediaSourceTransactionController* media_source_transaction_controller_construct (GType object_type, MediaSourceCollection* sources);
GType media_source_transaction_controller_get_type (void) G_GNUC_CONST;
static void library_photo_source_collection_real_master_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
static void g_cclosure_user_marshal_VOID__OBJECT_MEDIA_METADATA (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void library_photo_source_collection_real_editable_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
static void library_photo_source_collection_real_baseline_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
static void library_photo_source_collection_real_source_reimported (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
static void library_photo_source_collection_finalize (DataCollection* obj);
GType flaggable_get_type (void) G_GNUC_CONST;
GType monitorable_get_type (void) G_GNUC_CONST;
#define LIBRARY_PHOTO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LIBRARY_PHOTO, LibraryPhotoPrivate))
enum  {
	LIBRARY_PHOTO_DUMMY_PROPERTY
};
#define LIBRARY_PHOTO_FLAG_HIDDEN ((guint64) 0x0000000000000001)
#define LIBRARY_PHOTO_FLAG_FAVORITE ((guint64) 0x0000000000000002)
#define LIBRARY_PHOTO_FLAG_TRASH ((guint64) 0x0000000000000004)
#define LIBRARY_PHOTO_FLAG_OFFLINE ((guint64) 0x0000000000000008)
#define LIBRARY_PHOTO_FLAG_FLAGGED ((guint64) 0x0000000000000010)
static LibraryPhoto* library_photo_new (PhotoRow* row);
static LibraryPhoto* library_photo_construct (GType object_type, PhotoRow* row);
static void library_photo_generate_thumbnails (LibraryPhoto* self);
static void _library_photo_generate_thumbnails_one_shot_callback (gpointer self);
void data_source_rehydrate_backlinks (DataSource* self, SourceCollection* unlinked_from, const gchar* dehydrated);
static void library_photo_upgrade_rating_flags (LibraryPhoto* self, guint64 flags);
static LibraryPhoto* library_photo_new_from_import_params (PhotoImportParams* import_params);
static LibraryPhoto* library_photo_construct_from_import_params (GType object_type, PhotoImportParams* import_params);
void library_photo_init (ProgressMonitor monitor, void* monitor_target);
GeeArrayList* photo_table_get_all (PhotoTable* self);
GeeCollection* data_collection_add_many (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
void media_source_collection_add_many_to_trash (MediaSourceCollection* self, GeeCollection* sources);
void media_source_collection_add_many_to_offline (MediaSourceCollection* self, GeeCollection* sources);
void library_photo_terminate (void);
ImportResult library_photo_import_create (PhotoImportParams* params, LibraryPhoto** photo);
void photo_table_add (PhotoTable* self, PhotoRow* photo_row, PhotoID* result);
gboolean photo_id_is_invalid (PhotoID *self);
void library_photo_import_failed (LibraryPhoto* photo);
void photo_table_remove (PhotoTable* self, PhotoID* photo_id, GError** error);
static void library_photo_real_notify_master_reimported (Photo* base, PhotoMetadata* metadata);
static void library_photo_real_notify_editable_reimported (Photo* base, PhotoMetadata* metadata);
static void library_photo_real_notify_source_reimported (Photo* base, PhotoMetadata* metadata);
static void library_photo_real_notify_baseline_reimported (Photo* base, PhotoMetadata* metadata);
void thumbnail_cache_import_from_source (ThumbnailSource* source, gboolean force, GError** error);
void thumbnail_source_notify_thumbnail_altered (ThumbnailSource* self);
static void library_photo_real_notify_altered (DataObject* base, Alteration* alteration);
gboolean alteration_has_subject (Alteration* self, const gchar* subject);
void one_shot_scheduler_at_priority_idle (OneShotScheduler* self, gint priority);
static GdkPixbuf* library_photo_real_get_preview_pixbuf (MediaSource* base, Scaling* scaling, GError** error);
GdkPixbuf* thumbnail_source_get_thumbnail (ThumbnailSource* self, gint scale, GError** error);
GType thumbnail_cache_size_get_type (void) G_GNUC_CONST;
GdkPixbuf* scaling_perform_on_pixbuf (Scaling *self, GdkPixbuf* pixbuf, GdkInterpType interp, gboolean scale_up);
static void library_photo_real_rotate (Photo* base, Rotation rotation);
void thumbnail_cache_rotate (ThumbnailSource* source, Rotation rotation, GError** error);
static GdkPixbuf* library_photo_real_get_thumbnail (ThumbnailSource* base, gint scale, GError** error);
GdkPixbuf* thumbnail_cache_fetch (ThumbnailSource* source, gint scale, GError** error);
static void library_photo_duplicate_backing_photo (LibraryPhoto* self, BackingPhotoRow* backing, BackingPhotoID* result, GError** error);
GFile* library_files_duplicate (GFile* src, GFileProgressCallback progress_callback, void* progress_callback_target, gboolean blacklist, GError** error);
static void library_photo_on_duplicate_progress (LibraryPhoto* self, gint64 current, gint64 total);
static void _library_photo_on_duplicate_progress_gfile_progress_callback (gint64 current_num_bytes, gint64 total_num_bytes, gpointer self);
LibraryPhoto* library_photo_duplicate (LibraryPhoto* self, GError** error);
void photo_table_duplicate (PhotoTable* self, PhotoID* photo_id, const gchar* new_filename, BackingPhotoID* editable_id, BackingPhotoID* develop_shotwell, BackingPhotoID* develop_camera_id, BackingPhotoID* develop_embedded_id, PhotoID* result);
PhotoRow* photo_table_get_row (PhotoTable* self, PhotoID* photo_id);
void thumbnail_cache_duplicate (ThumbnailSource* src_source, ThumbnailSource* dest_source);
gboolean data_collection_add (DataCollection* self, DataObject* object);
GType event_source_get_type (void) G_GNUC_CONST;
GType event_get_type (void) G_GNUC_CONST;
Event* media_source_get_event (MediaSource* self);
void event_attach (Event* self, MediaSource* source);
GType container_source_collection_get_type (void) G_GNUC_CONST;
GType tag_source_collection_get_type (void) G_GNUC_CONST;
GeeList* tag_source_collection_fetch_for_source (TagSourceCollection* self, MediaSource* source);
void tag_attach (Tag* self, MediaSource* source);
void spin_event_loop (void);
static gboolean library_photo_real_is_trashed (MediaSource* base);
static void library_photo_real_trash (MediaSource* base);
static void library_photo_real_untrash (MediaSource* base);
static gboolean library_photo_real_is_offline (Monitorable* base);
static void library_photo_real_mark_offline (Monitorable* base);
static void library_photo_real_mark_online (Monitorable* base);
static gboolean library_photo_real_is_flagged (Flaggable* base);
static void library_photo_real_mark_flagged (Flaggable* base);
static void library_photo_real_mark_unflagged (Flaggable* base);
static gboolean library_photo_real_internal_delete_backing (DataSource* base, GError** error);
gboolean media_source_delete_original_file (MediaSource* self);
static void library_photo_real_destroy (DataSource* base);
void thumbnail_cache_remove (ThumbnailSource* source);
void data_source_destroy (DataSource* self);
gboolean library_photo_has_nontrash_duplicate (GFile* file, const gchar* thumbnail_md5, const gchar* full_md5, PhotoFileFormat file_format);
void library_photo_get_nontrash_duplicate (GFile* file, const gchar* thumbnail_md5, const gchar* full_md5, PhotoFileFormat file_format, PhotoID* result);
static gboolean library_photo_real_has_user_generated_metadata (Photo* base);
Rating media_source_get_rating (MediaSource* self);
gchar* data_object_get_name (DataObject* self);
static void library_photo_real_set_user_metadata_for_export (Photo* base, PhotoMetadata* metadata);
void photo_metadata_set_keywords (PhotoMetadata* self, GeeCollection* keywords, PhotoMetadataSetOption option);
void photo_metadata_set_rating (PhotoMetadata* self, Rating rating);
static void library_photo_real_apply_user_metadata_for_reimport (Photo* base, PhotoMetadata* metadata);
gchar* hierarchical_tag_utilities_make_flat_tag_safe (const gchar* in_tag);
gchar* hierarchical_tag_utilities_flat_to_hierarchical (const gchar* name);
gboolean tag_source_collection_exists (TagSourceCollection* self, const gchar* name, gboolean treat_htags_as_root);
static void library_photo_finalize (GObject* obj);
#define LIBRARY_PHOTO_SOURCE_HOLDING_TANK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, LibraryPhotoSourceHoldingTankPrivate))
enum  {
	LIBRARY_PHOTO_SOURCE_HOLDING_TANK_DUMMY_PROPERTY
};
MediaSourceHoldingTank* media_source_holding_tank_new (MediaSourceCollection* sources, SourceHoldingTankCheckToKeep check_to_keep, void* check_to_keep_target, GetSourceDatabaseKey get_key, void* get_key_target);
MediaSourceHoldingTank* media_source_holding_tank_construct (GType object_type, MediaSourceCollection* sources, SourceHoldingTankCheckToKeep check_to_keep, void* check_to_keep_target, GetSourceDatabaseKey get_key, void* get_key_target);
static void library_photo_source_holding_tank_real_notify_contents_altered (SourceHoldingTank* base, GeeCollection* added, GeeCollection* removed);
static void library_photo_source_holding_tank_on_editable_replaced (LibraryPhotoSourceHoldingTank* self, Photo* _photo, GFile* old_file, GFile* new_file);
static void _library_photo_source_holding_tank_on_editable_replaced_photo_editable_replaced (Photo* _sender, GFile* old_file, GFile* new_file, gpointer self);
static void library_photo_source_holding_tank_on_raw_development_modified (LibraryPhotoSourceHoldingTank* self, Photo* _photo);
static void _library_photo_source_holding_tank_on_raw_development_modified_photo_raw_development_modified (Photo* _sender, gpointer self);
void source_holding_tank_notify_contents_altered (SourceHoldingTank* self, GeeCollection* added, GeeCollection* removed);
static void library_photo_source_holding_tank_finalize (SourceHoldingTank* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* PHOTO_IMAGE_EXTENSIONS[69] = {"jpg", "jpeg", "jpe", "tiff", "tif", "png", "gif", "bmp", "ppm", "pgm", "pbm", "pnm", "thm", "tga", "ilbm", "pcx", "ecw", "img", "sid", "cd5", "fits", "pgf", "cgm", "svg", "odg", "eps", "pdf", "swf", "wmf", "emf", "xps", "pns", "jps", "mpo", "3fr", "arw", "srf", "sr2", "bay", "crw", "cr2", "cap", "iiq", "eip", "dcs", "dcr", "drf", "k25", "kdc", "dng", "erf", "fff", "mef", "mos", "mrw", "nef", "nrw", "orf", "ptx", "pef", "pxn", "r3d", "raf", "raw", "rw2", "rwl", "rwz", "x3f", "srw"};

GType backing_fetch_mode_get_type (void) {
	static volatile gsize backing_fetch_mode_type_id__volatile = 0;
	if (g_once_init_enter (&backing_fetch_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{BACKING_FETCH_MODE_SOURCE, "BACKING_FETCH_MODE_SOURCE", "source"}, {BACKING_FETCH_MODE_BASELINE, "BACKING_FETCH_MODE_BASELINE", "baseline"}, {BACKING_FETCH_MODE_MASTER, "BACKING_FETCH_MODE_MASTER", "master"}, {BACKING_FETCH_MODE_UNMODIFIED, "BACKING_FETCH_MODE_UNMODIFIED", "unmodified"}, {0, NULL, NULL}};
		GType backing_fetch_mode_type_id;
		backing_fetch_mode_type_id = g_enum_register_static ("BackingFetchMode", values);
		g_once_init_leave (&backing_fetch_mode_type_id__volatile, backing_fetch_mode_type_id);
	}
	return backing_fetch_mode_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 41 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? g_object_ref (self) : NULL;
#line 2888 "Photo.c"
}


static gpointer _thumbnails_ref0 (gpointer self) {
#line 48 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? thumbnails_ref (self) : NULL;
#line 2895 "Photo.c"
}


PhotoImportParams* photo_import_params_construct (GType object_type, GFile* file, GFile* final_associated_file, ImportID* import_id, PhotoFileSnifferOptions sniffer_options, const gchar* exif_md5, const gchar* thumbnail_md5, const gchar* full_md5, Thumbnails* thumbnails) {
	PhotoImportParams* self = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	ImportID _tmp4_ = {0};
	PhotoFileSnifferOptions _tmp5_ = 0;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	Thumbnails* _tmp12_ = NULL;
	Thumbnails* _tmp13_ = NULL;
#line 38 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 38 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((final_associated_file == NULL) || G_IS_FILE (final_associated_file), NULL);
#line 38 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (import_id != NULL, NULL);
#line 38 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((thumbnails == NULL) || IS_THUMBNAILS (thumbnails), NULL);
#line 38 "/home/jens/Source/shotwell/src/Photo.vala"
	self = (PhotoImportParams*) g_type_create_instance (object_type);
#line 41 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = file;
#line 41 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 41 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (self->file);
#line 41 "/home/jens/Source/shotwell/src/Photo.vala"
	self->file = _tmp1_;
#line 42 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = final_associated_file;
#line 42 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 42 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (self->final_associated_file);
#line 42 "/home/jens/Source/shotwell/src/Photo.vala"
	self->final_associated_file = _tmp3_;
#line 43 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = *import_id;
#line 43 "/home/jens/Source/shotwell/src/Photo.vala"
	self->import_id = _tmp4_;
#line 44 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = sniffer_options;
#line 44 "/home/jens/Source/shotwell/src/Photo.vala"
	self->sniffer_options = _tmp5_;
#line 45 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = exif_md5;
#line 45 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 45 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->exif_md5);
#line 45 "/home/jens/Source/shotwell/src/Photo.vala"
	self->exif_md5 = _tmp7_;
#line 46 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = thumbnail_md5;
#line 46 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 46 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->thumbnail_md5);
#line 46 "/home/jens/Source/shotwell/src/Photo.vala"
	self->thumbnail_md5 = _tmp9_;
#line 47 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = full_md5;
#line 47 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 47 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->full_md5);
#line 47 "/home/jens/Source/shotwell/src/Photo.vala"
	self->full_md5 = _tmp11_;
#line 48 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = thumbnails;
#line 48 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = _thumbnails_ref0 (_tmp12_);
#line 48 "/home/jens/Source/shotwell/src/Photo.vala"
	_thumbnails_unref0 (self->thumbnails);
#line 48 "/home/jens/Source/shotwell/src/Photo.vala"
	self->thumbnails = _tmp13_;
#line 38 "/home/jens/Source/shotwell/src/Photo.vala"
	return self;
#line 2983 "Photo.c"
}


PhotoImportParams* photo_import_params_new (GFile* file, GFile* final_associated_file, ImportID* import_id, PhotoFileSnifferOptions sniffer_options, const gchar* exif_md5, const gchar* thumbnail_md5, const gchar* full_md5, Thumbnails* thumbnails) {
#line 38 "/home/jens/Source/shotwell/src/Photo.vala"
	return photo_import_params_construct (TYPE_PHOTO_IMPORT_PARAMS, file, final_associated_file, import_id, sniffer_options, exif_md5, thumbnail_md5, full_md5, thumbnails);
#line 2990 "Photo.c"
}


PhotoImportParams* photo_import_params_construct_create_placeholder (GType object_type, GFile* file, ImportID* import_id) {
	PhotoImportParams* self = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	ImportID _tmp2_ = {0};
#line 52 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 52 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (import_id != NULL, NULL);
#line 52 "/home/jens/Source/shotwell/src/Photo.vala"
	self = (PhotoImportParams*) g_type_create_instance (object_type);
#line 53 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = file;
#line 53 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 53 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (self->file);
#line 53 "/home/jens/Source/shotwell/src/Photo.vala"
	self->file = _tmp1_;
#line 54 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = *import_id;
#line 54 "/home/jens/Source/shotwell/src/Photo.vala"
	self->import_id = _tmp2_;
#line 55 "/home/jens/Source/shotwell/src/Photo.vala"
	self->sniffer_options = PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5;
#line 56 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->exif_md5);
#line 56 "/home/jens/Source/shotwell/src/Photo.vala"
	self->exif_md5 = NULL;
#line 57 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->thumbnail_md5);
#line 57 "/home/jens/Source/shotwell/src/Photo.vala"
	self->thumbnail_md5 = NULL;
#line 58 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->full_md5);
#line 58 "/home/jens/Source/shotwell/src/Photo.vala"
	self->full_md5 = NULL;
#line 59 "/home/jens/Source/shotwell/src/Photo.vala"
	_thumbnails_unref0 (self->thumbnails);
#line 59 "/home/jens/Source/shotwell/src/Photo.vala"
	self->thumbnails = NULL;
#line 52 "/home/jens/Source/shotwell/src/Photo.vala"
	return self;
#line 3037 "Photo.c"
}


PhotoImportParams* photo_import_params_new_create_placeholder (GFile* file, ImportID* import_id) {
#line 52 "/home/jens/Source/shotwell/src/Photo.vala"
	return photo_import_params_construct_create_placeholder (TYPE_PHOTO_IMPORT_PARAMS, file, import_id);
#line 3044 "Photo.c"
}


static void value_photo_import_params_init (GValue* value) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	value->data[0].v_pointer = NULL;
#line 3051 "Photo.c"
}


static void value_photo_import_params_free_value (GValue* value) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (value->data[0].v_pointer) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_import_params_unref (value->data[0].v_pointer);
#line 3060 "Photo.c"
	}
}


static void value_photo_import_params_copy_value (const GValue* src_value, GValue* dest_value) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (src_value->data[0].v_pointer) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		dest_value->data[0].v_pointer = photo_import_params_ref (src_value->data[0].v_pointer);
#line 3070 "Photo.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3074 "Photo.c"
	}
}


static gpointer value_photo_import_params_peek_pointer (const GValue* value) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	return value->data[0].v_pointer;
#line 3082 "Photo.c"
}


static gchar* value_photo_import_params_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (collect_values[0].v_pointer) {
#line 3089 "Photo.c"
		PhotoImportParams* object;
		object = collect_values[0].v_pointer;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		if (object->parent_instance.g_class == NULL) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3096 "Photo.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3100 "Photo.c"
		}
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		value->data[0].v_pointer = photo_import_params_ref (object);
#line 3104 "Photo.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		value->data[0].v_pointer = NULL;
#line 3108 "Photo.c"
	}
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	return NULL;
#line 3112 "Photo.c"
}


static gchar* value_photo_import_params_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PhotoImportParams** object_p;
	object_p = collect_values[0].v_pointer;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!object_p) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3123 "Photo.c"
	}
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!value->data[0].v_pointer) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		*object_p = NULL;
#line 3129 "Photo.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		*object_p = value->data[0].v_pointer;
#line 3133 "Photo.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		*object_p = photo_import_params_ref (value->data[0].v_pointer);
#line 3137 "Photo.c"
	}
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	return NULL;
#line 3141 "Photo.c"
}


GParamSpec* param_spec_photo_import_params (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPhotoImportParams* spec;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_IMPORT_PARAMS), NULL);
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	return G_PARAM_SPEC (spec);
#line 3155 "Photo.c"
}


gpointer value_get_photo_import_params (const GValue* value) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_IMPORT_PARAMS), NULL);
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	return value->data[0].v_pointer;
#line 3164 "Photo.c"
}


void value_set_photo_import_params (GValue* value, gpointer v_object) {
	PhotoImportParams* old;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_IMPORT_PARAMS));
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	old = value->data[0].v_pointer;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (v_object) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_IMPORT_PARAMS));
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		value->data[0].v_pointer = v_object;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_import_params_ref (value->data[0].v_pointer);
#line 3184 "Photo.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		value->data[0].v_pointer = NULL;
#line 3188 "Photo.c"
	}
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (old) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_import_params_unref (old);
#line 3194 "Photo.c"
	}
}


void value_take_photo_import_params (GValue* value, gpointer v_object) {
	PhotoImportParams* old;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_IMPORT_PARAMS));
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	old = value->data[0].v_pointer;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (v_object) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_IMPORT_PARAMS));
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		value->data[0].v_pointer = v_object;
#line 3213 "Photo.c"
	} else {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		value->data[0].v_pointer = NULL;
#line 3217 "Photo.c"
	}
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (old) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_import_params_unref (old);
#line 3223 "Photo.c"
	}
}


static void photo_import_params_class_init (PhotoImportParamsClass * klass) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_import_params_parent_class = g_type_class_peek_parent (klass);
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	((PhotoImportParamsClass *) klass)->finalize = photo_import_params_finalize;
#line 3233 "Photo.c"
}


static void photo_import_params_instance_init (PhotoImportParams * self) {
	PhotoRow* _tmp0_ = NULL;
#line 24 "/home/jens/Source/shotwell/src/Photo.vala"
	self->final_associated_file = NULL;
#line 35 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_row_new ();
#line 35 "/home/jens/Source/shotwell/src/Photo.vala"
	self->row = _tmp0_;
#line 36 "/home/jens/Source/shotwell/src/Photo.vala"
	self->keywords = NULL;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	self->ref_count = 1;
#line 3249 "Photo.c"
}


static void photo_import_params_finalize (PhotoImportParams* obj) {
	PhotoImportParams * self;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_IMPORT_PARAMS, PhotoImportParams);
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_handlers_destroy (self);
#line 23 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (self->file);
#line 24 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (self->final_associated_file);
#line 27 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->exif_md5);
#line 28 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->thumbnail_md5);
#line 29 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (self->full_md5);
#line 32 "/home/jens/Source/shotwell/src/Photo.vala"
	_thumbnails_unref0 (self->thumbnails);
#line 35 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_row_unref0 (self->row);
#line 36 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (self->keywords);
#line 3275 "Photo.c"
}


GType photo_import_params_get_type (void) {
	static volatile gsize photo_import_params_type_id__volatile = 0;
	if (g_once_init_enter (&photo_import_params_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_photo_import_params_init, value_photo_import_params_free_value, value_photo_import_params_copy_value, value_photo_import_params_peek_pointer, "p", value_photo_import_params_collect_value, "p", value_photo_import_params_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PhotoImportParamsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_import_params_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoImportParams), 0, (GInstanceInitFunc) photo_import_params_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType photo_import_params_type_id;
		photo_import_params_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoImportParams", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&photo_import_params_type_id__volatile, photo_import_params_type_id);
	}
	return photo_import_params_type_id__volatile;
}


gpointer photo_import_params_ref (gpointer instance) {
	PhotoImportParams* self;
	self = instance;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	g_atomic_int_inc (&self->ref_count);
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	return instance;
#line 3300 "Photo.c"
}


void photo_import_params_unref (gpointer instance) {
	PhotoImportParams* self;
	self = instance;
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		PHOTO_IMPORT_PARAMS_GET_CLASS (self)->finalize (self);
#line 21 "/home/jens/Source/shotwell/src/Photo.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3313 "Photo.c"
	}
}


PhotoTransformationState* photo_transformation_state_construct (GType object_type) {
	PhotoTransformationState * self = NULL;
#line 72 "/home/jens/Source/shotwell/src/Photo.vala"
	self = (PhotoTransformationState*) g_object_new (object_type, NULL);
#line 72 "/home/jens/Source/shotwell/src/Photo.vala"
	return self;
#line 3324 "Photo.c"
}


gboolean photo_transformation_state_is_broken (PhotoTransformationState* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 75 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO_TRANSFORMATION_STATE (self), FALSE);
#line 76 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = self->priv->is_broke;
#line 76 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 76 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 3339 "Photo.c"
}


static void photo_transformation_state_real_broken (PhotoTransformationState* self) {
#line 69 "/home/jens/Source/shotwell/src/Photo.vala"
	self->priv->is_broke = TRUE;
#line 3346 "Photo.c"
}


static void photo_transformation_state_class_init (PhotoTransformationStateClass * klass) {
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_transformation_state_parent_class = g_type_class_peek_parent (klass);
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	g_type_class_add_private (klass, sizeof (PhotoTransformationStatePrivate));
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	((PhotoTransformationStateClass *) klass)->broken = photo_transformation_state_real_broken;
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	G_OBJECT_CLASS (klass)->finalize = photo_transformation_state_finalize;
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_new ("broken", TYPE_PHOTO_TRANSFORMATION_STATE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PhotoTransformationStateClass, broken), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 3361 "Photo.c"
}


static void photo_transformation_state_instance_init (PhotoTransformationState * self) {
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	self->priv = PHOTO_TRANSFORMATION_STATE_GET_PRIVATE (self);
#line 64 "/home/jens/Source/shotwell/src/Photo.vala"
	self->priv->is_broke = FALSE;
#line 3370 "Photo.c"
}


static void photo_transformation_state_finalize (GObject* obj) {
	PhotoTransformationState * self;
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationState);
#line 63 "/home/jens/Source/shotwell/src/Photo.vala"
	G_OBJECT_CLASS (photo_transformation_state_parent_class)->finalize (obj);
#line 3380 "Photo.c"
}


GType photo_transformation_state_get_type (void) {
	static volatile gsize photo_transformation_state_type_id__volatile = 0;
	if (g_once_init_enter (&photo_transformation_state_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoTransformationStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_transformation_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoTransformationState), 0, (GInstanceInitFunc) photo_transformation_state_instance_init, NULL };
		GType photo_transformation_state_type_id;
		photo_transformation_state_type_id = g_type_register_static (G_TYPE_OBJECT, "PhotoTransformationState", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&photo_transformation_state_type_id__volatile, photo_transformation_state_type_id);
	}
	return photo_transformation_state_type_id__volatile;
}


gboolean rating_can_increase (Rating self) {
	gboolean result = FALSE;
#line 90 "/home/jens/Source/shotwell/src/Photo.vala"
	result = self < RATING_FIVE;
#line 90 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 3402 "Photo.c"
}


gboolean rating_can_decrease (Rating self) {
	gboolean result = FALSE;
#line 94 "/home/jens/Source/shotwell/src/Photo.vala"
	result = self > RATING_REJECTED;
#line 94 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 3412 "Photo.c"
}


gboolean rating_is_valid (Rating self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 98 "/home/jens/Source/shotwell/src/Photo.vala"
	if (self >= RATING_REJECTED) {
#line 98 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self <= RATING_FIVE;
#line 3423 "Photo.c"
	} else {
#line 98 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = FALSE;
#line 3427 "Photo.c"
	}
#line 98 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 98 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 3433 "Photo.c"
}


Rating rating_increase (Rating self) {
	Rating result = 0;
	Rating _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
#line 102 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = rating_can_increase (self);
#line 102 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_) {
#line 102 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self + 1;
#line 3447 "Photo.c"
	} else {
#line 102 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self;
#line 3451 "Photo.c"
	}
#line 102 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 102 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 3457 "Photo.c"
}


Rating rating_decrease (Rating self) {
	Rating result = 0;
	Rating _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
#line 106 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = rating_can_decrease (self);
#line 106 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_) {
#line 106 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self - 1;
#line 3471 "Photo.c"
	} else {
#line 106 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self;
#line 3475 "Photo.c"
	}
#line 106 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 106 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 3481 "Photo.c"
}


gint rating_serialize (Rating self) {
	gint result = 0;
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
	switch (self) {
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
		case RATING_REJECTED:
#line 3491 "Photo.c"
		{
#line 112 "/home/jens/Source/shotwell/src/Photo.vala"
			result = -1;
#line 112 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3497 "Photo.c"
		}
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
		case RATING_UNRATED:
#line 3501 "Photo.c"
		{
#line 114 "/home/jens/Source/shotwell/src/Photo.vala"
			result = 0;
#line 114 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3507 "Photo.c"
		}
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
		case RATING_ONE:
#line 3511 "Photo.c"
		{
#line 116 "/home/jens/Source/shotwell/src/Photo.vala"
			result = 1;
#line 116 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3517 "Photo.c"
		}
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
		case RATING_TWO:
#line 3521 "Photo.c"
		{
#line 118 "/home/jens/Source/shotwell/src/Photo.vala"
			result = 2;
#line 118 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3527 "Photo.c"
		}
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
		case RATING_THREE:
#line 3531 "Photo.c"
		{
#line 120 "/home/jens/Source/shotwell/src/Photo.vala"
			result = 3;
#line 120 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3537 "Photo.c"
		}
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
		case RATING_FOUR:
#line 3541 "Photo.c"
		{
#line 122 "/home/jens/Source/shotwell/src/Photo.vala"
			result = 4;
#line 122 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3547 "Photo.c"
		}
#line 110 "/home/jens/Source/shotwell/src/Photo.vala"
		case RATING_FIVE:
#line 3551 "Photo.c"
		{
#line 124 "/home/jens/Source/shotwell/src/Photo.vala"
			result = 5;
#line 124 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3557 "Photo.c"
		}
		default:
		{
#line 126 "/home/jens/Source/shotwell/src/Photo.vala"
			result = 0;
#line 126 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3565 "Photo.c"
		}
	}
}


Rating rating_unserialize (gint value) {
	Rating result = 0;
	gint _tmp0_ = 0;
	gint _tmp2_ = 0;
#line 131 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = value;
#line 131 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp0_ > ((gint) RATING_FIVE)) {
#line 132 "/home/jens/Source/shotwell/src/Photo.vala"
		result = RATING_FIVE;
#line 132 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 3583 "Photo.c"
	} else {
		gint _tmp1_ = 0;
#line 133 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = value;
#line 133 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp1_ < ((gint) RATING_REJECTED)) {
#line 134 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_REJECTED;
#line 134 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3594 "Photo.c"
		}
	}
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = value;
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
	switch (_tmp2_) {
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
		case -1:
#line 3603 "Photo.c"
		{
#line 138 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_REJECTED;
#line 138 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3609 "Photo.c"
		}
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
		case 0:
#line 3613 "Photo.c"
		{
#line 140 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_UNRATED;
#line 140 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3619 "Photo.c"
		}
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
		case 1:
#line 3623 "Photo.c"
		{
#line 142 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_ONE;
#line 142 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3629 "Photo.c"
		}
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
		case 2:
#line 3633 "Photo.c"
		{
#line 144 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_TWO;
#line 144 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3639 "Photo.c"
		}
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
		case 3:
#line 3643 "Photo.c"
		{
#line 146 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_THREE;
#line 146 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3649 "Photo.c"
		}
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
		case 4:
#line 3653 "Photo.c"
		{
#line 148 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_FOUR;
#line 148 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3659 "Photo.c"
		}
#line 136 "/home/jens/Source/shotwell/src/Photo.vala"
		case 5:
#line 3663 "Photo.c"
		{
#line 150 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_FIVE;
#line 150 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3669 "Photo.c"
		}
		default:
		{
#line 152 "/home/jens/Source/shotwell/src/Photo.vala"
			result = RATING_UNRATED;
#line 152 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 3677 "Photo.c"
		}
	}
}


GType rating_get_type (void) {
	static volatile gsize rating_type_id__volatile = 0;
	if (g_once_init_enter (&rating_type_id__volatile)) {
		static const GEnumValue values[] = {{RATING_REJECTED, "RATING_REJECTED", "rejected"}, {RATING_UNRATED, "RATING_UNRATED", "unrated"}, {RATING_ONE, "RATING_ONE", "one"}, {RATING_TWO, "RATING_TWO", "two"}, {RATING_THREE, "RATING_THREE", "three"}, {RATING_FOUR, "RATING_FOUR", "four"}, {RATING_FIVE, "RATING_FIVE", "five"}, {0, NULL, NULL}};
		GType rating_type_id;
		rating_type_id = g_enum_register_static ("Rating", values);
		g_once_init_leave (&rating_type_id__volatile, rating_type_id);
	}
	return rating_type_id__volatile;
}


gboolean photo_exception_prohibits (PhotoException self, PhotoException exception) {
	gboolean result = FALSE;
	PhotoException _tmp0_ = 0;
#line 228 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = exception;
#line 228 "/home/jens/Source/shotwell/src/Photo.vala"
	result = (self & _tmp0_) != 0;
#line 228 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 3704 "Photo.c"
}


gboolean photo_exception_allows (PhotoException self, PhotoException exception) {
	gboolean result = FALSE;
	PhotoException _tmp0_ = 0;
#line 232 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = exception;
#line 232 "/home/jens/Source/shotwell/src/Photo.vala"
	result = (self & _tmp0_) == 0;
#line 232 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 3717 "Photo.c"
}


GType photo_exception_get_type (void) {
	static volatile gsize photo_exception_type_id__volatile = 0;
	if (g_once_init_enter (&photo_exception_type_id__volatile)) {
		static const GEnumValue values[] = {{PHOTO_EXCEPTION_NONE, "PHOTO_EXCEPTION_NONE", "none"}, {PHOTO_EXCEPTION_ORIENTATION, "PHOTO_EXCEPTION_ORIENTATION", "orientation"}, {PHOTO_EXCEPTION_CROP, "PHOTO_EXCEPTION_CROP", "crop"}, {PHOTO_EXCEPTION_REDEYE, "PHOTO_EXCEPTION_REDEYE", "redeye"}, {PHOTO_EXCEPTION_ADJUST, "PHOTO_EXCEPTION_ADJUST", "adjust"}, {PHOTO_EXCEPTION_STRAIGHTEN, "PHOTO_EXCEPTION_STRAIGHTEN", "straighten"}, {PHOTO_EXCEPTION_ALL, "PHOTO_EXCEPTION_ALL", "all"}, {0, NULL, NULL}};
		GType photo_exception_type_id;
		photo_exception_type_id = g_enum_register_static ("PhotoException", values);
		g_once_init_leave (&photo_exception_type_id__volatile, photo_exception_type_id);
	}
	return photo_exception_type_id__volatile;
}


static gpointer _photo_row_ref0 (gpointer self) {
#line 400 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? photo_row_ref (self) : NULL;
#line 3736 "Photo.c"
}


static gpointer _backing_photo_row_ref0 (gpointer self) {
#line 421 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? backing_photo_row_ref (self) : NULL;
#line 3743 "Photo.c"
}


Photo* photo_construct (GType object_type, PhotoRow* row) {
	Photo * self = NULL;
	PhotoRow* _tmp0_ = NULL;
	PhotoRow* _tmp1_ = NULL;
	PhotoRow* _tmp2_ = NULL;
	PhotoRow* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	PhotoRow* _tmp6_ = NULL;
	PhotoRow* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	PhotoBackingReaders* _tmp10_ = NULL;
	PhotoRow* _tmp11_ = NULL;
	BackingPhotoRow* _tmp12_ = NULL;
	PhotoFileFormat _tmp13_ = 0;
	PhotoRow* _tmp14_ = NULL;
	BackingPhotoRow* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	PhotoFileReader* _tmp17_ = NULL;
	gchar* basename = NULL;
	PhotoRow* _tmp18_ = NULL;
	BackingPhotoRow* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	const gchar* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	PhotoRow* _tmp31_ = NULL;
	BackingPhotoID _tmp32_ = {0};
	gint64 _tmp33_ = 0LL;
	PhotoRow* _tmp49_ = NULL;
	BackingPhotoRow* _tmp50_ = NULL;
	PhotoFileFormat _tmp51_ = 0;
	gboolean _tmp67_ = FALSE;
	PhotoRow* _tmp68_ = NULL;
	BackingPhotoRow* _tmp69_ = NULL;
	PhotoFileFormat _tmp70_ = 0;
	PhotoBackingReaders* _tmp85_ = NULL;
	PhotoFileReader* _tmp86_ = NULL;
	PhotoRow* _tmp106_ = NULL;
	time_t _tmp107_ = 0;
	GError * _inner_error_ = NULL;
#line 399 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO_ROW (row), NULL);
#line 399 "/home/jens/Source/shotwell/src/Photo.vala"
	self = (Photo*) photo_source_construct (object_type, DATA_OBJECT_INVALID_OBJECT_ID);
#line 400 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = row;
#line 400 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _photo_row_ref0 (_tmp0_);
#line 400 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_row_unref0 (self->row);
#line 400 "/home/jens/Source/shotwell/src/Photo.vala"
	self->row = _tmp1_;
#line 403 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = self->row;
#line 403 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = self->row;
#line 403 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp3_->title;
#line 403 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = media_source_prep_title (_tmp4_);
#line 403 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp2_->title);
#line 403 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_->title = _tmp5_;
#line 404 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = self->row;
#line 404 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = self->row;
#line 404 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = _tmp7_->comment;
#line 404 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = media_source_prep_comment (_tmp8_);
#line 404 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp6_->comment);
#line 404 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_->comment = _tmp9_;
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = self->priv->readers;
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = row;
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = _tmp11_->master;
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = _tmp12_->file_format;
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = row;
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = _tmp14_->master;
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = _tmp15_->filepath;
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = photo_file_format_create_reader (_tmp13_, _tmp16_);
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp10_->master);
#line 408 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_->master = _tmp17_;
#line 411 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = row;
#line 411 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = _tmp18_->master;
#line 411 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = _tmp19_->filepath;
#line 411 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = string_sliced_at_last_char (_tmp20_, (gunichar) G_DIR_SEPARATOR, 0);
#line 411 "/home/jens/Source/shotwell/src/Photo.vala"
	basename = _tmp21_;
#line 412 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = basename;
#line 412 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp22_ != NULL) {
#line 3860 "Photo.c"
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
#line 413 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23_ = basename;
#line 413 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp24_ = string_sliced_at (_tmp23_, 1);
#line 413 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (self->priv->file_title);
#line 413 "/home/jens/Source/shotwell/src/Photo.vala"
		self->priv->file_title = _tmp24_;
#line 3871 "Photo.c"
	}
#line 415 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp25_ = self->priv->file_title;
#line 415 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp26_ = is_string_empty (_tmp25_);
#line 415 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp26_) {
#line 3879 "Photo.c"
		PhotoRow* _tmp27_ = NULL;
		BackingPhotoRow* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
#line 416 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp27_ = row;
#line 416 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp28_ = _tmp27_->master;
#line 416 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp29_ = _tmp28_->filepath;
#line 416 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp30_ = g_strdup (_tmp29_);
#line 416 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (self->priv->file_title);
#line 416 "/home/jens/Source/shotwell/src/Photo.vala"
		self->priv->file_title = _tmp30_;
#line 3896 "Photo.c"
	}
#line 418 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp31_ = row;
#line 418 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp32_ = _tmp31_->editable_id;
#line 418 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp33_ = _tmp32_.id;
#line 418 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp33_ != BACKING_PHOTO_ID_INVALID) {
#line 3906 "Photo.c"
		BackingPhotoRow* e = NULL;
		PhotoRow* _tmp34_ = NULL;
		BackingPhotoID _tmp35_ = {0};
		BackingPhotoRow* _tmp36_ = NULL;
		BackingPhotoRow* _tmp37_ = NULL;
#line 419 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp34_ = row;
#line 419 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp35_ = _tmp34_->editable_id;
#line 419 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp36_ = photo_get_backing_row (self, &_tmp35_);
#line 419 "/home/jens/Source/shotwell/src/Photo.vala"
		e = _tmp36_;
#line 420 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp37_ = e;
#line 420 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp37_ != NULL) {
#line 3924 "Photo.c"
			BackingPhotoRow* _tmp38_ = NULL;
			BackingPhotoRow* _tmp39_ = NULL;
			PhotoBackingReaders* _tmp40_ = NULL;
			BackingPhotoRow* _tmp41_ = NULL;
			PhotoFileFormat _tmp42_ = 0;
			BackingPhotoRow* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			PhotoFileReader* _tmp45_ = NULL;
#line 421 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp38_ = e;
#line 421 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp39_ = _backing_photo_row_ref0 (_tmp38_);
#line 421 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (self->priv->editable);
#line 421 "/home/jens/Source/shotwell/src/Photo.vala"
			self->priv->editable = _tmp39_;
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp40_ = self->priv->readers;
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp41_ = self->priv->editable;
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp42_ = _tmp41_->file_format;
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp43_ = self->priv->editable;
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp44_ = _tmp43_->filepath;
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp45_ = photo_file_format_create_reader (_tmp42_, _tmp44_);
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_adapter_unref0 (_tmp40_->editable);
#line 422 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp40_->editable = _tmp45_;
#line 3957 "Photo.c"
		} else {
			{
				PhotoTable* _tmp46_ = NULL;
				PhotoTable* _tmp47_ = NULL;
				PhotoRow* _tmp48_ = NULL;
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp46_ = photo_table_get_instance ();
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp47_ = _tmp46_;
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp48_ = self->row;
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_table_detach_editable (_tmp47_, _tmp48_, &_inner_error_);
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp47_);
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 3977 "Photo.c"
						goto __catch256_database_error;
					}
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (e);
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_free0 (basename);
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
					g_clear_error (&_inner_error_);
#line 425 "/home/jens/Source/shotwell/src/Photo.vala"
					return NULL;
#line 3990 "Photo.c"
				}
			}
			goto __finally256;
			__catch256_database_error:
			{
				GError* err = NULL;
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				err = _inner_error_;
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				_inner_error_ = NULL;
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (err);
#line 4003 "Photo.c"
			}
			__finally256:
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (e);
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (basename);
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 424 "/home/jens/Source/shotwell/src/Photo.vala"
				return NULL;
#line 4018 "Photo.c"
			}
#line 432 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_internal_remove_all_transformations (self, FALSE);
#line 4022 "Photo.c"
		}
#line 418 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (e);
#line 4026 "Photo.c"
	}
#line 436 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp49_ = row;
#line 436 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp50_ = _tmp49_->master;
#line 436 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp51_ = _tmp50_->file_format;
#line 436 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp51_ == PHOTO_FILE_FORMAT_RAW) {
#line 4036 "Photo.c"
		GeeHashMap* _tmp52_ = NULL;
		gint _tmp53_ = 0;
		RawDeveloper* _tmp54_ = NULL;
#line 438 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp52_ = gee_hash_map_new (TYPE_RAW_DEVELOPER, NULL, NULL, TYPE_BACKING_PHOTO_ROW, (GBoxedCopyFunc) backing_photo_row_ref, (GDestroyNotify) backing_photo_row_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 438 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (self->priv->developments);
#line 438 "/home/jens/Source/shotwell/src/Photo.vala"
		self->priv->developments = _tmp52_;
#line 439 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp54_ = raw_developer_as_array (&_tmp53_);
#line 4048 "Photo.c"
		{
			RawDeveloper* d_collection = NULL;
			gint d_collection_length1 = 0;
			gint _d_collection_size_ = 0;
			gint d_it = 0;
#line 439 "/home/jens/Source/shotwell/src/Photo.vala"
			d_collection = _tmp54_;
#line 439 "/home/jens/Source/shotwell/src/Photo.vala"
			d_collection_length1 = _tmp53_;
#line 439 "/home/jens/Source/shotwell/src/Photo.vala"
			for (d_it = 0; d_it < _tmp53_; d_it = d_it + 1) {
#line 4060 "Photo.c"
				RawDeveloper d = 0;
#line 439 "/home/jens/Source/shotwell/src/Photo.vala"
				d = d_collection[d_it];
#line 4064 "Photo.c"
				{
					BackingPhotoID id = {0};
					PhotoRow* _tmp55_ = NULL;
					BackingPhotoID* _tmp56_ = NULL;
					gint _tmp56__length1 = 0;
					RawDeveloper _tmp57_ = 0;
					BackingPhotoID _tmp58_ = {0};
					BackingPhotoID _tmp59_ = {0};
					gint64 _tmp60_ = 0LL;
#line 440 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp55_ = row;
#line 440 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp56_ = _tmp55_->development_ids;
#line 440 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp56__length1 = _tmp55_->development_ids_length1;
#line 440 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp57_ = d;
#line 440 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp58_ = _tmp56_[_tmp57_];
#line 440 "/home/jens/Source/shotwell/src/Photo.vala"
					id = _tmp58_;
#line 441 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp59_ = id;
#line 441 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp60_ = _tmp59_.id;
#line 441 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp60_ != BACKING_PHOTO_ID_INVALID) {
#line 4092 "Photo.c"
						BackingPhotoRow* bpr = NULL;
						BackingPhotoID _tmp61_ = {0};
						BackingPhotoRow* _tmp62_ = NULL;
						BackingPhotoRow* _tmp63_ = NULL;
#line 442 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp61_ = id;
#line 442 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp62_ = photo_get_backing_row (self, &_tmp61_);
#line 442 "/home/jens/Source/shotwell/src/Photo.vala"
						bpr = _tmp62_;
#line 443 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp63_ = bpr;
#line 443 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp63_ != NULL) {
#line 4107 "Photo.c"
							GeeHashMap* _tmp64_ = NULL;
							RawDeveloper _tmp65_ = 0;
							BackingPhotoRow* _tmp66_ = NULL;
#line 444 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp64_ = self->priv->developments;
#line 444 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp65_ = d;
#line 444 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp66_ = bpr;
#line 444 "/home/jens/Source/shotwell/src/Photo.vala"
							gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp65_), _tmp66_);
#line 4119 "Photo.c"
						}
#line 441 "/home/jens/Source/shotwell/src/Photo.vala"
						_backing_photo_row_unref0 (bpr);
#line 4123 "Photo.c"
					}
				}
			}
#line 439 "/home/jens/Source/shotwell/src/Photo.vala"
			d_collection = (g_free (d_collection), NULL);
#line 4129 "Photo.c"
		}
	}
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp68_ = row;
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp69_ = _tmp68_->master;
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp70_ = _tmp69_->file_format;
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp70_ == PHOTO_FILE_FORMAT_RAW) {
#line 4140 "Photo.c"
		GeeHashMap* _tmp71_ = NULL;
		PhotoRow* _tmp72_ = NULL;
		RawDeveloper _tmp73_ = 0;
		gboolean _tmp74_ = FALSE;
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp71_ = self->priv->developments;
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp72_ = row;
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp73_ = _tmp72_->developer;
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp74_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp73_));
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp67_ = _tmp74_;
#line 4155 "Photo.c"
	} else {
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp67_ = FALSE;
#line 4159 "Photo.c"
	}
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp67_) {
#line 4163 "Photo.c"
		BackingPhotoRow* r = NULL;
		GeeHashMap* _tmp75_ = NULL;
		PhotoRow* _tmp76_ = NULL;
		RawDeveloper _tmp77_ = 0;
		gpointer _tmp78_ = NULL;
		PhotoBackingReaders* _tmp79_ = NULL;
		BackingPhotoRow* _tmp80_ = NULL;
		PhotoFileFormat _tmp81_ = 0;
		BackingPhotoRow* _tmp82_ = NULL;
		const gchar* _tmp83_ = NULL;
		PhotoFileReader* _tmp84_ = NULL;
#line 451 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp75_ = self->priv->developments;
#line 451 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp76_ = row;
#line 451 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp77_ = _tmp76_->developer;
#line 451 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp78_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp77_));
#line 451 "/home/jens/Source/shotwell/src/Photo.vala"
		r = (BackingPhotoRow*) _tmp78_;
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp79_ = self->priv->readers;
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp80_ = r;
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp81_ = _tmp80_->file_format;
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp82_ = r;
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp83_ = _tmp82_->filepath;
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp84_ = photo_file_format_create_reader (_tmp81_, _tmp83_);
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp79_->developer);
#line 452 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp79_->developer = _tmp84_;
#line 450 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (r);
#line 4203 "Photo.c"
	}
#line 456 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp85_ = self->priv->readers;
#line 456 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp86_ = _tmp85_->editable;
#line 456 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp86_ != NULL) {
#line 4211 "Photo.c"
		BackingPhotoRow* _tmp87_ = NULL;
		BackingPhotoRow* _tmp88_ = NULL;
#line 457 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp87_ = self->priv->editable;
#line 457 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp88_ = _backing_photo_row_ref0 (_tmp87_);
#line 457 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (self->backing_photo_row);
#line 457 "/home/jens/Source/shotwell/src/Photo.vala"
		self->backing_photo_row = _tmp88_;
#line 4222 "Photo.c"
	} else {
		PhotoRow* _tmp89_ = NULL;
		BackingPhotoRow* _tmp90_ = NULL;
		PhotoFileFormat _tmp91_ = 0;
#line 458 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp89_ = row;
#line 458 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp90_ = _tmp89_->master;
#line 458 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp91_ = _tmp90_->file_format;
#line 458 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp91_ != PHOTO_FILE_FORMAT_RAW) {
#line 4235 "Photo.c"
			PhotoRow* _tmp92_ = NULL;
			BackingPhotoRow* _tmp93_ = NULL;
			BackingPhotoRow* _tmp94_ = NULL;
#line 459 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp92_ = self->row;
#line 459 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp93_ = _tmp92_->master;
#line 459 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp94_ = _backing_photo_row_ref0 (_tmp93_);
#line 459 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (self->backing_photo_row);
#line 459 "/home/jens/Source/shotwell/src/Photo.vala"
			self->backing_photo_row = _tmp94_;
#line 4249 "Photo.c"
		} else {
			GeeHashMap* _tmp95_ = NULL;
			PhotoRow* _tmp96_ = NULL;
			RawDeveloper _tmp97_ = 0;
			gboolean _tmp98_ = FALSE;
#line 463 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp95_ = self->priv->developments;
#line 463 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp96_ = row;
#line 463 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp97_ = _tmp96_->developer;
#line 463 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp98_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp97_));
#line 463 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp98_) {
#line 4265 "Photo.c"
				GeeHashMap* _tmp99_ = NULL;
				PhotoRow* _tmp100_ = NULL;
				RawDeveloper _tmp101_ = 0;
				gpointer _tmp102_ = NULL;
#line 464 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp99_ = self->priv->developments;
#line 464 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp100_ = row;
#line 464 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp101_ = _tmp100_->developer;
#line 464 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp102_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp101_));
#line 464 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (self->backing_photo_row);
#line 464 "/home/jens/Source/shotwell/src/Photo.vala"
				self->backing_photo_row = (BackingPhotoRow*) _tmp102_;
#line 4282 "Photo.c"
			} else {
				PhotoRow* _tmp103_ = NULL;
				BackingPhotoRow* _tmp104_ = NULL;
				BackingPhotoRow* _tmp105_ = NULL;
#line 467 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp103_ = self->row;
#line 467 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp104_ = _tmp103_->master;
#line 467 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp105_ = _backing_photo_row_ref0 (_tmp104_);
#line 467 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (self->backing_photo_row);
#line 467 "/home/jens/Source/shotwell/src/Photo.vala"
				self->backing_photo_row = _tmp105_;
#line 4297 "Photo.c"
			}
		}
	}
#line 471 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp106_ = self->row;
#line 471 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp107_ = _tmp106_->exposure_time;
#line 471 "/home/jens/Source/shotwell/src/Photo.vala"
	self->priv->cached_exposure_time = _tmp107_;
#line 399 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (basename);
#line 399 "/home/jens/Source/shotwell/src/Photo.vala"
	return self;
#line 4311 "Photo.c"
}


void photo_init_photo (void) {
	GeeLinkedList* _tmp0_ = NULL;
#line 475 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = gee_linked_list_new (PHOTO_TYPE_CACHED_PIXBUF, (GBoxedCopyFunc) photo_cached_pixbuf_ref, (GDestroyNotify) photo_cached_pixbuf_unref, NULL, NULL, NULL);
#line 475 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (photo_source_pixbuf_cache);
#line 475 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_source_pixbuf_cache = _tmp0_;
#line 4323 "Photo.c"
}


void photo_terminate_photo (void) {
	guint _tmp0_ = 0U;
#line 479 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (photo_source_pixbuf_cache);
#line 479 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_source_pixbuf_cache = NULL;
#line 481 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_discard_source_id;
#line 481 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 4337 "Photo.c"
		guint _tmp1_ = 0U;
#line 482 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = photo_discard_source_id;
#line 482 "/home/jens/Source/shotwell/src/Photo.vala"
		g_source_remove (_tmp1_);
#line 483 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_discard_source_id = (guint) 0;
#line 4345 "Photo.c"
	}
}


static void photo_real_notify_editable_replaced (Photo* self, GFile* old_file, GFile* new_file) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
#line 487 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((old_file == NULL) || G_IS_FILE (old_file));
#line 487 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((new_file == NULL) || G_IS_FILE (new_file));
#line 488 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = old_file;
#line 488 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = new_file;
#line 488 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_emit_by_name (self, "editable-replaced", _tmp0_, _tmp1_);
#line 4363 "Photo.c"
}


void photo_notify_editable_replaced (Photo* self, GFile* old_file, GFile* new_file) {
#line 487 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 487 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->notify_editable_replaced (self, old_file, new_file);
#line 4372 "Photo.c"
}


static void photo_real_notify_raw_development_modified (Photo* self) {
#line 492 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_emit_by_name (self, "raw-development-modified");
#line 4379 "Photo.c"
}


void photo_notify_raw_development_modified (Photo* self) {
#line 491 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 491 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->notify_raw_development_modified (self);
#line 4388 "Photo.c"
}


static void photo_real_notify_baseline_replaced (Photo* self) {
#line 496 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_emit_by_name (self, "baseline-replaced");
#line 4395 "Photo.c"
}


void photo_notify_baseline_replaced (Photo* self) {
#line 495 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 495 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->notify_baseline_replaced (self);
#line 4404 "Photo.c"
}


static void photo_real_notify_master_reimported (Photo* self, PhotoMetadata* metadata) {
	PhotoMetadata* _tmp0_ = NULL;
#line 499 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
#line 500 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = metadata;
#line 500 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_emit_by_name (self, "master-reimported", _tmp0_);
#line 4416 "Photo.c"
}


void photo_notify_master_reimported (Photo* self, PhotoMetadata* metadata) {
#line 499 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 499 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->notify_master_reimported (self, metadata);
#line 4425 "Photo.c"
}


static void photo_real_notify_editable_reimported (Photo* self, PhotoMetadata* metadata) {
	PhotoMetadata* _tmp0_ = NULL;
#line 503 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
#line 504 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = metadata;
#line 504 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_emit_by_name (self, "editable-reimported", _tmp0_);
#line 4437 "Photo.c"
}


void photo_notify_editable_reimported (Photo* self, PhotoMetadata* metadata) {
#line 503 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 503 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->notify_editable_reimported (self, metadata);
#line 4446 "Photo.c"
}


static void photo_real_notify_source_reimported (Photo* self, PhotoMetadata* metadata) {
	PhotoMetadata* _tmp0_ = NULL;
#line 507 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
#line 508 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = metadata;
#line 508 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_emit_by_name (self, "source-reimported", _tmp0_);
#line 4458 "Photo.c"
}


void photo_notify_source_reimported (Photo* self, PhotoMetadata* metadata) {
#line 507 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 507 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->notify_source_reimported (self, metadata);
#line 4467 "Photo.c"
}


static void photo_real_notify_baseline_reimported (Photo* self, PhotoMetadata* metadata) {
	PhotoMetadata* _tmp0_ = NULL;
#line 511 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
#line 512 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = metadata;
#line 512 "/home/jens/Source/shotwell/src/Photo.vala"
	g_signal_emit_by_name (self, "baseline-reimported", _tmp0_);
#line 4479 "Photo.c"
}


void photo_notify_baseline_reimported (Photo* self, PhotoMetadata* metadata) {
#line 511 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 511 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->notify_baseline_reimported (self, metadata);
#line 4488 "Photo.c"
}


static gboolean photo_real_internal_delete_backing (DataSource* base, GError** error) {
	Photo * self;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GFile* file = NULL;
	PhotoFileFormat _tmp8_ = 0;
	GFile* _tmp12_ = NULL;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	GError * _inner_error_ = NULL;
#line 515 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 516 "/home/jens/Source/shotwell/src/Photo.vala"
	ret = TRUE;
#line 517 "/home/jens/Source/shotwell/src/Photo.vala"
	file = NULL;
#line 4509 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 4516 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
#line 519 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 519 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable;
#line 519 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 4526 "Photo.c"
				PhotoBackingReaders* _tmp3_ = NULL;
				PhotoFileReader* _tmp4_ = NULL;
				GFile* _tmp5_ = NULL;
#line 520 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->readers;
#line 520 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_->editable;
#line 520 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 520 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (file);
#line 520 "/home/jens/Source/shotwell/src/Photo.vala"
				file = _tmp5_;
#line 4540 "Photo.c"
			}
		}
		__finally257:
		{
			PhotoBackingReaders* _tmp6_ = NULL;
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = self->priv->readers;
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 4550 "Photo.c"
		}
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4554 "Photo.c"
			gboolean _tmp7_ = FALSE;
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (file);
#line 518 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp7_;
#line 4562 "Photo.c"
		}
	}
#line 523 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_detach_editable (self, TRUE, FALSE, TRUE);
#line 525 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = photo_get_master_file_format (self);
#line 525 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp8_ == PHOTO_FILE_FORMAT_RAW) {
#line 4571 "Photo.c"
		gint _tmp9_ = 0;
		RawDeveloper* _tmp10_ = NULL;
#line 526 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = raw_developer_as_array (&_tmp9_);
#line 4576 "Photo.c"
		{
			RawDeveloper* d_collection = NULL;
			gint d_collection_length1 = 0;
			gint _d_collection_size_ = 0;
			gint d_it = 0;
#line 526 "/home/jens/Source/shotwell/src/Photo.vala"
			d_collection = _tmp10_;
#line 526 "/home/jens/Source/shotwell/src/Photo.vala"
			d_collection_length1 = _tmp9_;
#line 526 "/home/jens/Source/shotwell/src/Photo.vala"
			for (d_it = 0; d_it < _tmp9_; d_it = d_it + 1) {
#line 4588 "Photo.c"
				RawDeveloper d = 0;
#line 526 "/home/jens/Source/shotwell/src/Photo.vala"
				d = d_collection[d_it];
#line 4592 "Photo.c"
				{
					RawDeveloper _tmp11_ = 0;
#line 527 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = d;
#line 527 "/home/jens/Source/shotwell/src/Photo.vala"
					photo_delete_raw_development (self, _tmp11_);
#line 4599 "Photo.c"
				}
			}
#line 526 "/home/jens/Source/shotwell/src/Photo.vala"
			d_collection = (g_free (d_collection), NULL);
#line 4604 "Photo.c"
		}
	}
#line 531 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = file;
#line 531 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp12_ != NULL) {
#line 4611 "Photo.c"
		{
			gboolean _tmp13_ = FALSE;
			GFile* _tmp14_ = NULL;
			gboolean _tmp15_ = FALSE;
#line 533 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = file;
#line 533 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = g_file_trash (_tmp14_, NULL, &_inner_error_);
#line 533 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = _tmp15_;
#line 533 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4624 "Photo.c"
				goto __catch258_g_error;
			}
#line 533 "/home/jens/Source/shotwell/src/Photo.vala"
			ret = _tmp13_;
#line 4629 "Photo.c"
		}
		goto __finally258;
		__catch258_g_error:
		{
			GError* err = NULL;
			GFile* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			GError* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
#line 532 "/home/jens/Source/shotwell/src/Photo.vala"
			err = _inner_error_;
#line 532 "/home/jens/Source/shotwell/src/Photo.vala"
			_inner_error_ = NULL;
#line 535 "/home/jens/Source/shotwell/src/Photo.vala"
			ret = FALSE;
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = file;
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = g_file_get_path (_tmp16_);
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp18_ = _tmp17_;
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp19_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp20_ = _tmp19_;
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp21_ = err;
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp22_ = _tmp21_->message;
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			g_message ("Photo.vala:536: Unable to move editable %s for %s to trash: %s", _tmp18_, _tmp20_, _tmp22_);
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (_tmp20_);
#line 536 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (_tmp18_);
#line 532 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_error_free0 (err);
#line 4670 "Photo.c"
		}
		__finally258:
#line 532 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4675 "Photo.c"
			gboolean _tmp23_ = FALSE;
#line 532 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 532 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (file);
#line 532 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp23_;
#line 4683 "Photo.c"
		}
	}
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp26_ = DATA_SOURCE_CLASS (photo_parent_class)->internal_delete_backing (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource), TYPE_DATA_SOURCE, DataSource), &_inner_error_);
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp25_ = _tmp26_;
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4692 "Photo.c"
		gboolean _tmp27_ = FALSE;
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp27_;
#line 4700 "Photo.c"
	}
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp25_) {
#line 4704 "Photo.c"
		gboolean _tmp28_ = FALSE;
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp28_ = ret;
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp24_ = _tmp28_;
#line 4710 "Photo.c"
	} else {
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp24_ = FALSE;
#line 4714 "Photo.c"
	}
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp24_;
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (file);
#line 542 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 4722 "Photo.c"
}


static BackingPhotoRow* photo_get_backing_row (Photo* self, BackingPhotoID* id) {
	BackingPhotoRow* result = NULL;
	BackingPhotoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	BackingPhotoRow* backing_row = NULL;
	BackingPhotoRow* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
#line 547 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 547 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 548 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = *id;
#line 548 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_.id;
#line 548 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == BACKING_PHOTO_ID_INVALID) {
#line 549 "/home/jens/Source/shotwell/src/Photo.vala"
		result = NULL;
#line 549 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 4747 "Photo.c"
	}
#line 551 "/home/jens/Source/shotwell/src/Photo.vala"
	backing_row = NULL;
#line 4751 "Photo.c"
	{
		BackingPhotoRow* _tmp2_ = NULL;
		BackingPhotoTable* _tmp3_ = NULL;
		BackingPhotoTable* _tmp4_ = NULL;
		BackingPhotoID _tmp5_ = {0};
		BackingPhotoRow* _tmp6_ = NULL;
		BackingPhotoRow* _tmp7_ = NULL;
		BackingPhotoRow* _tmp8_ = NULL;
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = backing_photo_table_get_instance ();
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = _tmp3_;
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = *id;
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = backing_photo_table_fetch (_tmp4_, &_tmp5_, &_inner_error_);
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = _tmp6_;
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_database_table_unref0 (_tmp4_);
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = _tmp7_;
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 4778 "Photo.c"
				goto __catch259_database_error;
			}
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (backing_row);
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 4789 "Photo.c"
		}
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp8_ = _tmp2_;
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = NULL;
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing_row);
#line 553 "/home/jens/Source/shotwell/src/Photo.vala"
		backing_row = _tmp8_;
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (_tmp2_);
#line 4801 "Photo.c"
	}
	goto __finally259;
	__catch259_database_error:
	{
		GError* err = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 555 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 555 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = _tmp9_;
#line 555 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = err;
#line 555 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = _tmp11_->message;
#line 555 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:555: Unable to fetch backing state for %s: %s", _tmp10_, _tmp12_);
#line 555 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp10_);
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 4829 "Photo.c"
	}
	__finally259:
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing_row);
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 552 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 4842 "Photo.c"
	}
#line 558 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = backing_row;
#line 558 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp13_ == NULL) {
#line 4848 "Photo.c"
		{
			BackingPhotoTable* _tmp14_ = NULL;
			BackingPhotoTable* _tmp15_ = NULL;
			BackingPhotoID _tmp16_ = {0};
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = backing_photo_table_get_instance ();
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = _tmp14_;
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = *id;
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
			backing_photo_table_remove (_tmp15_, &_tmp16_, &_inner_error_);
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp15_);
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 4867 "Photo.c"
					goto __catch260_database_error;
				}
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (backing_row);
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 560 "/home/jens/Source/shotwell/src/Photo.vala"
				return NULL;
#line 4878 "Photo.c"
			}
		}
		goto __finally260;
		__catch260_database_error:
		{
			GError* err = NULL;
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
			err = _inner_error_;
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
			_inner_error_ = NULL;
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_error_free0 (err);
#line 4891 "Photo.c"
		}
		__finally260:
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (backing_row);
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 559 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 4904 "Photo.c"
		}
#line 564 "/home/jens/Source/shotwell/src/Photo.vala"
		result = NULL;
#line 564 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing_row);
#line 564 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 4912 "Photo.c"
	}
#line 567 "/home/jens/Source/shotwell/src/Photo.vala"
	result = backing_row;
#line 567 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 4918 "Photo.c"
}


gboolean photo_is_raw_developer_complete (Photo* self, RawDeveloper d) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 572 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 4927 "Photo.c"
	{
		GeeHashMap* _tmp0_ = NULL;
		gboolean _tmp13_ = FALSE;
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->developments;
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_developments);
#line 4935 "Photo.c"
		{
			gboolean _tmp1_ = FALSE;
			GeeHashMap* _tmp2_ = NULL;
			RawDeveloper _tmp3_ = 0;
			gboolean _tmp4_ = FALSE;
#line 574 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->priv->developments;
#line 574 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = d;
#line 574 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp3_));
#line 574 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp4_) {
#line 4949 "Photo.c"
				GeeHashMap* _tmp5_ = NULL;
				RawDeveloper _tmp6_ = 0;
				gpointer _tmp7_ = NULL;
				BackingPhotoRow* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
#line 575 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = self->priv->developments;
#line 575 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = d;
#line 575 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp6_));
#line 575 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = (BackingPhotoRow*) _tmp7_;
#line 575 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = _tmp8_->filepath;
#line 575 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = g_file_test (_tmp9_, G_FILE_TEST_EXISTS);
#line 575 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = _tmp10_;
#line 575 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (_tmp8_);
#line 4972 "Photo.c"
			} else {
#line 574 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = FALSE;
#line 4976 "Photo.c"
			}
#line 574 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp1_;
#line 4980 "Photo.c"
			{
				GeeHashMap* _tmp11_ = NULL;
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = self->priv->developments;
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 4987 "Photo.c"
			}
#line 574 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 4991 "Photo.c"
		}
		__finally261:
		{
			GeeHashMap* _tmp12_ = NULL;
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = self->priv->developments;
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 5000 "Photo.c"
		}
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 573 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp13_;
#line 5008 "Photo.c"
	}
}


gboolean photo_is_raw_developer_available (Photo* self, RawDeveloper d) {
	gboolean result = FALSE;
	RawDeveloper _tmp7_ = 0;
	GError * _inner_error_ = NULL;
#line 580 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 5019 "Photo.c"
	{
		GeeHashMap* _tmp0_ = NULL;
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->developments;
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_developments);
#line 5026 "Photo.c"
		{
			GeeHashMap* _tmp1_ = NULL;
			RawDeveloper _tmp2_ = 0;
			gboolean _tmp3_ = FALSE;
#line 582 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->developments;
#line 582 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = d;
#line 582 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp2_));
#line 582 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp3_) {
#line 583 "/home/jens/Source/shotwell/src/Photo.vala"
				result = TRUE;
#line 5041 "Photo.c"
				{
					GeeHashMap* _tmp4_ = NULL;
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp4_ = self->priv->developments;
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 5048 "Photo.c"
				}
#line 583 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 5052 "Photo.c"
			}
		}
		__finally262:
		{
			GeeHashMap* _tmp5_ = NULL;
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->priv->developments;
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 5062 "Photo.c"
		}
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5066 "Photo.c"
			gboolean _tmp6_ = FALSE;
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 581 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp6_;
#line 5074 "Photo.c"
		}
	}
#line 586 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = d;
#line 586 "/home/jens/Source/shotwell/src/Photo.vala"
	switch (_tmp7_) {
#line 586 "/home/jens/Source/shotwell/src/Photo.vala"
		case RAW_DEVELOPER_SHOTWELL:
#line 5083 "Photo.c"
		{
#line 588 "/home/jens/Source/shotwell/src/Photo.vala"
			result = TRUE;
#line 588 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 5089 "Photo.c"
		}
#line 586 "/home/jens/Source/shotwell/src/Photo.vala"
		case RAW_DEVELOPER_CAMERA:
#line 5093 "Photo.c"
		{
#line 591 "/home/jens/Source/shotwell/src/Photo.vala"
			result = FALSE;
#line 591 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 5099 "Photo.c"
		}
#line 586 "/home/jens/Source/shotwell/src/Photo.vala"
		case RAW_DEVELOPER_EMBEDDED:
#line 5103 "Photo.c"
		{
			{
				PhotoMetadata* meta = NULL;
				PhotoMetadata* _tmp8_ = NULL;
				guint num_previews = 0U;
				PhotoMetadata* _tmp9_ = NULL;
				guint _tmp10_ = 0U;
				guint _tmp11_ = 0U;
#line 595 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = photo_get_master_metadata (self, &_inner_error_);
#line 595 "/home/jens/Source/shotwell/src/Photo.vala"
				meta = _tmp8_;
#line 595 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5118 "Photo.c"
					goto __catch263_g_error;
				}
#line 596 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = meta;
#line 596 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = photo_metadata_get_preview_count (_tmp9_);
#line 596 "/home/jens/Source/shotwell/src/Photo.vala"
				num_previews = _tmp10_;
#line 598 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = num_previews;
#line 598 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp11_ > ((guint) 0)) {
#line 5131 "Photo.c"
					PhotoPreview* prev = NULL;
					PhotoMetadata* _tmp12_ = NULL;
					guint _tmp13_ = 0U;
					PhotoPreview* _tmp14_ = NULL;
					PhotoPreview* _tmp15_ = NULL;
					Dimensions dims = {0};
					PhotoPreview* _tmp16_ = NULL;
					Dimensions _tmp17_ = {0};
					gint _tmp18_ = 0;
					Dimensions _tmp19_ = {0};
					gint _tmp20_ = 0;
					Dimensions _tmp21_ = {0};
					gint _tmp22_ = 0;
					gint preview_major_axis = 0;
					gint _tmp27_ = 0;
#line 599 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp12_ = meta;
#line 599 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp13_ = num_previews;
#line 599 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_ = photo_metadata_get_preview (_tmp12_, _tmp13_ - 1);
#line 599 "/home/jens/Source/shotwell/src/Photo.vala"
					prev = _tmp14_;
#line 602 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp15_ = prev;
#line 602 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp15_ == NULL) {
#line 603 "/home/jens/Source/shotwell/src/Photo.vala"
						result = FALSE;
#line 603 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_preview_unref0 (prev);
#line 603 "/home/jens/Source/shotwell/src/Photo.vala"
						_media_metadata_unref0 (meta);
#line 603 "/home/jens/Source/shotwell/src/Photo.vala"
						return result;
#line 5167 "Photo.c"
					}
#line 605 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp16_ = prev;
#line 605 "/home/jens/Source/shotwell/src/Photo.vala"
					photo_preview_get_pixel_dimensions (_tmp16_, &_tmp17_);
#line 605 "/home/jens/Source/shotwell/src/Photo.vala"
					dims = _tmp17_;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp19_ = dims;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp20_ = _tmp19_.width;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp21_ = dims;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp22_ = _tmp21_.height;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp20_ > _tmp22_) {
#line 5185 "Photo.c"
						Dimensions _tmp23_ = {0};
						gint _tmp24_ = 0;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp23_ = dims;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp24_ = _tmp23_.width;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp18_ = _tmp24_;
#line 5194 "Photo.c"
					} else {
						Dimensions _tmp25_ = {0};
						gint _tmp26_ = 0;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp25_ = dims;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp26_ = _tmp25_.height;
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp18_ = _tmp26_;
#line 5204 "Photo.c"
					}
#line 608 "/home/jens/Source/shotwell/src/Photo.vala"
					preview_major_axis = _tmp18_;
#line 609 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp27_ = preview_major_axis;
#line 609 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp27_ < PHOTO_MIN_EMBEDDED_SIZE) {
#line 610 "/home/jens/Source/shotwell/src/Photo.vala"
						result = FALSE;
#line 610 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_preview_unref0 (prev);
#line 610 "/home/jens/Source/shotwell/src/Photo.vala"
						_media_metadata_unref0 (meta);
#line 610 "/home/jens/Source/shotwell/src/Photo.vala"
						return result;
#line 5220 "Photo.c"
					}
#line 613 "/home/jens/Source/shotwell/src/Photo.vala"
					result = TRUE;
#line 613 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 613 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 613 "/home/jens/Source/shotwell/src/Photo.vala"
					return result;
#line 5230 "Photo.c"
				}
#line 617 "/home/jens/Source/shotwell/src/Photo.vala"
				result = FALSE;
#line 617 "/home/jens/Source/shotwell/src/Photo.vala"
				_media_metadata_unref0 (meta);
#line 617 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 5238 "Photo.c"
			}
			goto __finally263;
			__catch263_g_error:
			{
				GError* e = NULL;
				GError* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
#line 594 "/home/jens/Source/shotwell/src/Photo.vala"
				e = _inner_error_;
#line 594 "/home/jens/Source/shotwell/src/Photo.vala"
				_inner_error_ = NULL;
#line 619 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp28_ = e;
#line 619 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp29_ = _tmp28_->message;
#line 619 "/home/jens/Source/shotwell/src/Photo.vala"
				g_debug ("Photo.vala:619: Error accessing embedded preview. Message: %s", _tmp29_);
#line 594 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (e);
#line 5258 "Photo.c"
			}
			__finally263:
#line 594 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5263 "Photo.c"
				gboolean _tmp30_ = FALSE;
#line 594 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 594 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 594 "/home/jens/Source/shotwell/src/Photo.vala"
				return _tmp30_;
#line 5271 "Photo.c"
			}
#line 621 "/home/jens/Source/shotwell/src/Photo.vala"
			result = FALSE;
#line 621 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 5277 "Photo.c"
		}
		default:
		{
#line 624 "/home/jens/Source/shotwell/src/Photo.vala"
			g_assert_not_reached ();
#line 5283 "Photo.c"
		}
	}
}


void photo_add_backing_photo_for_development (Photo* self, RawDeveloper d, BackingPhotoRow* bpr, GError** error) {
	PhotoRow* _tmp0_ = NULL;
	RawDeveloper _tmp1_ = 0;
	BackingPhotoRow* _tmp2_ = NULL;
	Alteration* _tmp8_ = NULL;
	Alteration* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
#line 631 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 631 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_BACKING_PHOTO_ROW (bpr));
#line 632 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = self->row;
#line 632 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = d;
#line 632 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = bpr;
#line 632 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_import_developed_backing_photo (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
#line 632 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 632 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 632 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 5314 "Photo.c"
	}
	{
		GeeHashMap* _tmp3_ = NULL;
#line 633 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = self->priv->developments;
#line 633 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_developments);
#line 5322 "Photo.c"
		{
			GeeHashMap* _tmp4_ = NULL;
			RawDeveloper _tmp5_ = 0;
			BackingPhotoRow* _tmp6_ = NULL;
#line 634 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->priv->developments;
#line 634 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = d;
#line 634 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = bpr;
#line 634 "/home/jens/Source/shotwell/src/Photo.vala"
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp5_), _tmp6_);
#line 5335 "Photo.c"
		}
		__finally264:
		{
			GeeHashMap* _tmp7_ = NULL;
#line 633 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->priv->developments;
#line 633 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 5344 "Photo.c"
		}
#line 633 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 633 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 633 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 5352 "Photo.c"
		}
	}
#line 636 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = alteration_new ("image", "developer");
#line 636 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = _tmp8_;
#line 636 "/home/jens/Source/shotwell/src/Photo.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp9_);
#line 636 "/home/jens/Source/shotwell/src/Photo.vala"
	_alteration_unref0 (_tmp9_);
#line 5363 "Photo.c"
}


void photo_import_developed_backing_photo (PhotoRow* row, RawDeveloper d, BackingPhotoRow* bpr, GError** error) {
	GFile* file = NULL;
	BackingPhotoRow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFileInfo* info = NULL;
	GFile* _tmp3_ = NULL;
	GFileInfo* _tmp4_ = NULL;
	GTimeVal timestamp = {0};
	GFileInfo* _tmp5_ = NULL;
	GTimeVal _tmp6_ = {0};
	PhotoFileInterrogator* interrogator = NULL;
	GFile* _tmp7_ = NULL;
	PhotoFileInterrogator* _tmp8_ = NULL;
	PhotoFileInterrogator* _tmp9_ = NULL;
	DetectedPhotoInformation* detected = NULL;
	PhotoFileInterrogator* _tmp10_ = NULL;
	DetectedPhotoInformation* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	DetectedPhotoInformation* _tmp13_ = NULL;
	BackingPhotoRow* _tmp16_ = NULL;
	DetectedPhotoInformation* _tmp17_ = NULL;
	Dimensions _tmp18_ = {0};
	BackingPhotoRow* _tmp19_ = NULL;
	GFileInfo* _tmp20_ = NULL;
	gint64 _tmp21_ = 0LL;
	BackingPhotoRow* _tmp22_ = NULL;
	GTimeVal _tmp23_ = {0};
	glong _tmp24_ = 0L;
	Orientation _tmp25_ = 0;
	DetectedPhotoInformation* _tmp26_ = NULL;
	PhotoMetadata* _tmp27_ = NULL;
	BackingPhotoRow* _tmp31_ = NULL;
	BackingPhotoTable* _tmp32_ = NULL;
	BackingPhotoTable* _tmp33_ = NULL;
	BackingPhotoRow* _tmp34_ = NULL;
	PhotoTable* _tmp35_ = NULL;
	PhotoTable* _tmp36_ = NULL;
	PhotoRow* _tmp37_ = NULL;
	RawDeveloper _tmp38_ = 0;
	BackingPhotoRow* _tmp39_ = NULL;
	BackingPhotoID _tmp40_ = {0};
	GError * _inner_error_ = NULL;
#line 639 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO_ROW (row));
#line 639 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_BACKING_PHOTO_ROW (bpr));
#line 641 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = bpr;
#line 641 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_->filepath;
#line 641 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = g_file_new_for_path (_tmp1_);
#line 641 "/home/jens/Source/shotwell/src/Photo.vala"
	file = _tmp2_;
#line 642 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = file;
#line 642 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = g_file_query_info (_tmp3_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
#line 642 "/home/jens/Source/shotwell/src/Photo.vala"
	info = _tmp4_;
#line 642 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 642 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 642 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 642 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 5436 "Photo.c"
	}
#line 644 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = info;
#line 644 "/home/jens/Source/shotwell/src/Photo.vala"
	g_file_info_get_modification_time (_tmp5_, &_tmp6_);
#line 644 "/home/jens/Source/shotwell/src/Photo.vala"
	timestamp = _tmp6_;
#line 646 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = file;
#line 646 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = photo_file_interrogator_new (_tmp7_, PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL);
#line 646 "/home/jens/Source/shotwell/src/Photo.vala"
	interrogator = _tmp8_;
#line 648 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = interrogator;
#line 648 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_file_interrogator_interrogate (_tmp9_, &_inner_error_);
#line 648 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 648 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 648 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 648 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 648 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 648 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 5466 "Photo.c"
	}
#line 650 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = interrogator;
#line 650 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = photo_file_interrogator_get_detected_photo_information (_tmp10_);
#line 650 "/home/jens/Source/shotwell/src/Photo.vala"
	detected = _tmp11_;
#line 651 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = detected;
#line 651 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp13_ == NULL) {
#line 651 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = TRUE;
#line 5480 "Photo.c"
	} else {
		PhotoFileInterrogator* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
#line 651 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp14_ = interrogator;
#line 651 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = photo_file_interrogator_get_is_photo_corrupted (_tmp14_);
#line 651 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = _tmp15_;
#line 5490 "Photo.c"
	}
#line 651 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp12_) {
#line 654 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 654 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 654 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 654 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 654 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 5504 "Photo.c"
	}
#line 657 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = bpr;
#line 657 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = detected;
#line 657 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = _tmp17_->image_dim;
#line 657 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_->dim = _tmp18_;
#line 658 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = bpr;
#line 658 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = info;
#line 658 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = g_file_info_get_size (_tmp20_);
#line 658 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_->filesize = _tmp21_;
#line 659 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = bpr;
#line 659 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp23_ = timestamp;
#line 659 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp24_ = _tmp23_.tv_sec;
#line 659 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_->timestamp = (time_t) _tmp24_;
#line 660 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp26_ = detected;
#line 660 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp27_ = _tmp26_->metadata;
#line 660 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp27_ != NULL) {
#line 5536 "Photo.c"
		DetectedPhotoInformation* _tmp28_ = NULL;
		PhotoMetadata* _tmp29_ = NULL;
		Orientation _tmp30_ = 0;
#line 660 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp28_ = detected;
#line 660 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp29_ = _tmp28_->metadata;
#line 660 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp30_ = photo_metadata_get_orientation (_tmp29_);
#line 660 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp25_ = _tmp30_;
#line 5548 "Photo.c"
	} else {
#line 661 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp25_ = ORIENTATION_TOP_LEFT;
#line 5552 "Photo.c"
	}
#line 660 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp31_ = bpr;
#line 660 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp31_->original_orientation = _tmp25_;
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp32_ = backing_photo_table_get_instance ();
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp33_ = _tmp32_;
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp34_ = bpr;
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
	backing_photo_table_add (_tmp33_, _tmp34_, &_inner_error_);
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
	_database_table_unref0 (_tmp33_);
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 664 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 5582 "Photo.c"
	}
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp35_ = photo_table_get_instance ();
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp36_ = _tmp35_;
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp37_ = row;
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp38_ = d;
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp39_ = bpr;
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp40_ = _tmp39_->id;
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_table_update_raw_development (_tmp36_, _tmp37_, _tmp38_, &_tmp40_, &_inner_error_);
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
	_database_table_unref0 (_tmp36_);
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 665 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 5614 "Photo.c"
	}
#line 639 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (detected);
#line 639 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_interrogator_unref0 (interrogator);
#line 639 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (info);
#line 639 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (file);
#line 5624 "Photo.c"
}


static void photo_develop_photo (Photo* self, RawDeveloper d) {
	gboolean wrote_img_to_disk = FALSE;
	BackingPhotoRow* bps = NULL;
	RawDeveloper _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 670 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 671 "/home/jens/Source/shotwell/src/Photo.vala"
	wrote_img_to_disk = FALSE;
#line 672 "/home/jens/Source/shotwell/src/Photo.vala"
	bps = NULL;
#line 674 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = d;
#line 674 "/home/jens/Source/shotwell/src/Photo.vala"
	switch (_tmp0_) {
#line 674 "/home/jens/Source/shotwell/src/Photo.vala"
		case RAW_DEVELOPER_SHOTWELL:
#line 5645 "Photo.c"
		{
			{
				BackingPhotoRow* _tmp1_ = NULL;
				RawDeveloper _tmp2_ = 0;
				PhotoRow* _tmp3_ = NULL;
				BackingPhotoRow* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				BackingPhotoRow* _tmp6_ = NULL;
				BackingPhotoRow* _tmp7_ = NULL;
				GdkPixbuf* pix = NULL;
				GdkPixbuf* _tmp14_ = NULL;
				PhotoFileWriter* writer = NULL;
				BackingPhotoRow* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				PhotoFileWriter* _tmp22_ = NULL;
				PhotoFileWriter* _tmp23_ = NULL;
				GdkPixbuf* _tmp24_ = NULL;
				PhotoMetadata* meta = NULL;
				PhotoMetadata* _tmp25_ = NULL;
				PhotoFileMetadataWriter* mwriter = NULL;
				BackingPhotoRow* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				PhotoFileMetadataWriter* _tmp28_ = NULL;
				PhotoFileMetadataWriter* _tmp29_ = NULL;
				PhotoMetadata* _tmp30_ = NULL;
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp2_ = d;
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_->master;
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp4_->filepath;
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = raw_developer_create_backing_row_for_development (_tmp2_, _tmp5_, NULL, &_inner_error_);
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = _tmp6_;
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5685 "Photo.c"
					goto __catch265_g_error;
				}
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = _tmp1_;
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = NULL;
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (bps);
#line 678 "/home/jens/Source/shotwell/src/Photo.vala"
				bps = _tmp7_;
#line 679 "/home/jens/Source/shotwell/src/Photo.vala"
				pix = NULL;
#line 5698 "Photo.c"
				{
					PhotoBackingReaders* _tmp8_ = NULL;
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp8_ = self->priv->readers;
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_lock (&self->priv->__lock_readers);
#line 5705 "Photo.c"
					{
						GdkPixbuf* _tmp9_ = NULL;
						Scaling _tmp10_ = {0};
						GdkPixbuf* _tmp11_ = NULL;
						GdkPixbuf* _tmp12_ = NULL;
#line 685 "/home/jens/Source/shotwell/src/Photo.vala"
						scaling_for_original (&_tmp10_);
#line 685 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp11_ = photo_get_master_pixbuf (self, &_tmp10_, FALSE, &_inner_error_);
#line 685 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp9_ = _tmp11_;
#line 685 "/home/jens/Source/shotwell/src/Photo.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5719 "Photo.c"
							goto __finally266;
						}
#line 685 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp12_ = _tmp9_;
#line 685 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp9_ = NULL;
#line 685 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (pix);
#line 685 "/home/jens/Source/shotwell/src/Photo.vala"
						pix = _tmp12_;
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (_tmp9_);
#line 5732 "Photo.c"
					}
					__finally266:
					{
						PhotoBackingReaders* _tmp13_ = NULL;
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp13_ = self->priv->readers;
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 5741 "Photo.c"
					}
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (pix);
#line 680 "/home/jens/Source/shotwell/src/Photo.vala"
						_backing_photo_row_unref0 (_tmp1_);
#line 5749 "Photo.c"
						goto __catch265_g_error;
					}
				}
#line 688 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = pix;
#line 688 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp14_ == NULL) {
#line 689 "/home/jens/Source/shotwell/src/Photo.vala"
					g_debug ("Photo.vala:689: Could not get preview pixbuf");
#line 690 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 690 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp1_);
#line 5763 "Photo.c"
					{
						gboolean _tmp15_ = FALSE;
#line 714 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp15_ = wrote_img_to_disk;
#line 714 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp15_) {
#line 5770 "Photo.c"
							{
								RawDeveloper _tmp16_ = 0;
								BackingPhotoRow* _tmp17_ = NULL;
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp16_ = d;
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp17_ = bps;
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_add_backing_photo_for_development (self, _tmp16_, _tmp17_, &_inner_error_);
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5782 "Photo.c"
									goto __catch267_g_error;
								}
#line 719 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_notify_raw_development_modified (self);
#line 5787 "Photo.c"
							}
							goto __finally267;
							__catch267_g_error:
							{
								GError* e = NULL;
								GError* _tmp18_ = NULL;
								const gchar* _tmp19_ = NULL;
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
								e = _inner_error_;
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
								_inner_error_ = NULL;
#line 721 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp18_ = e;
#line 721 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp19_ = _tmp18_->message;
#line 721 "/home/jens/Source/shotwell/src/Photo.vala"
								g_debug ("Photo.vala:721: Error adding backing photo as development. Message: %s", _tmp19_);
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
								_g_error_free0 (e);
#line 5807 "Photo.c"
							}
							__finally267:
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5812 "Photo.c"
								goto __catch265_g_error;
							}
						}
					}
#line 690 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (bps);
#line 690 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 5821 "Photo.c"
				}
#line 694 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp20_ = bps;
#line 694 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp21_ = _tmp20_->filepath;
#line 694 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp22_ = photo_file_format_create_writer (PHOTO_FILE_FORMAT_JFIF, _tmp21_, &_inner_error_);
#line 694 "/home/jens/Source/shotwell/src/Photo.vala"
				writer = _tmp22_;
#line 694 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 694 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 694 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp1_);
#line 5837 "Photo.c"
					goto __catch265_g_error;
				}
#line 695 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp23_ = writer;
#line 695 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp24_ = pix;
#line 695 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_file_writer_write (_tmp23_, _tmp24_, JPEG_QUALITY_HIGH, &_inner_error_);
#line 695 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 695 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (writer);
#line 695 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 695 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp1_);
#line 5854 "Photo.c"
					goto __catch265_g_error;
				}
#line 703 "/home/jens/Source/shotwell/src/Photo.vala"
				wrote_img_to_disk = TRUE;
#line 708 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp25_ = photo_get_master_metadata (self, &_inner_error_);
#line 708 "/home/jens/Source/shotwell/src/Photo.vala"
				meta = _tmp25_;
#line 708 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 708 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (writer);
#line 708 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 708 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp1_);
#line 5871 "Photo.c"
					goto __catch265_g_error;
				}
#line 709 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp26_ = bps;
#line 709 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp27_ = _tmp26_->filepath;
#line 709 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp28_ = photo_file_format_create_metadata_writer (PHOTO_FILE_FORMAT_JFIF, _tmp27_, &_inner_error_);
#line 709 "/home/jens/Source/shotwell/src/Photo.vala"
				mwriter = _tmp28_;
#line 709 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 709 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 709 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (writer);
#line 709 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 709 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp1_);
#line 5892 "Photo.c"
					goto __catch265_g_error;
				}
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp29_ = mwriter;
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp30_ = meta;
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_file_metadata_writer_write_metadata (_tmp29_, _tmp30_, &_inner_error_);
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (mwriter);
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (writer);
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 710 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp1_);
#line 5913 "Photo.c"
					goto __catch265_g_error;
				}
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_file_adapter_unref0 (mwriter);
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				_media_metadata_unref0 (meta);
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_file_adapter_unref0 (writer);
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (pix);
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (_tmp1_);
#line 5926 "Photo.c"
			}
			goto __finally265;
			__catch265_g_error:
			{
				GError* err = NULL;
				GError* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				err = _inner_error_;
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				_inner_error_ = NULL;
#line 712 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp31_ = err;
#line 712 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp32_ = _tmp31_->message;
#line 712 "/home/jens/Source/shotwell/src/Photo.vala"
				g_debug ("Photo.vala:712: Error developing photo: %s", _tmp32_);
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (err);
#line 5946 "Photo.c"
			}
			__finally265:
			{
				gboolean _tmp33_ = FALSE;
#line 714 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp33_ = wrote_img_to_disk;
#line 714 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp33_) {
#line 5955 "Photo.c"
					{
						RawDeveloper _tmp34_ = 0;
						BackingPhotoRow* _tmp35_ = NULL;
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp34_ = d;
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp35_ = bps;
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
						photo_add_backing_photo_for_development (self, _tmp34_, _tmp35_, &_inner_error_);
#line 717 "/home/jens/Source/shotwell/src/Photo.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5967 "Photo.c"
							goto __catch268_g_error;
						}
#line 719 "/home/jens/Source/shotwell/src/Photo.vala"
						photo_notify_raw_development_modified (self);
#line 5972 "Photo.c"
					}
					goto __finally268;
					__catch268_g_error:
					{
						GError* e = NULL;
						GError* _tmp36_ = NULL;
						const gchar* _tmp37_ = NULL;
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
						e = _inner_error_;
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
						_inner_error_ = NULL;
#line 721 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp36_ = e;
#line 721 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp37_ = _tmp36_->message;
#line 721 "/home/jens/Source/shotwell/src/Photo.vala"
						g_debug ("Photo.vala:721: Error adding backing photo as development. Message: %s", _tmp37_);
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_error_free0 (e);
#line 5992 "Photo.c"
					}
					__finally268:
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
						_backing_photo_row_unref0 (bps);
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
						g_clear_error (&_inner_error_);
#line 715 "/home/jens/Source/shotwell/src/Photo.vala"
						return;
#line 6005 "Photo.c"
					}
				}
			}
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (bps);
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 676 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 6019 "Photo.c"
			}
#line 727 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 6023 "Photo.c"
		}
#line 674 "/home/jens/Source/shotwell/src/Photo.vala"
		case RAW_DEVELOPER_CAMERA:
#line 6027 "Photo.c"
		{
#line 731 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 6031 "Photo.c"
		}
#line 674 "/home/jens/Source/shotwell/src/Photo.vala"
		case RAW_DEVELOPER_EMBEDDED:
#line 6035 "Photo.c"
		{
			{
				PhotoMetadata* meta = NULL;
				PhotoMetadata* _tmp38_ = NULL;
				guint c = 0U;
				PhotoMetadata* _tmp39_ = NULL;
				guint _tmp40_ = 0U;
				guint _tmp41_ = 0U;
				PhotoPreview* prev = NULL;
				PhotoMetadata* _tmp47_ = NULL;
				guint _tmp48_ = 0U;
				PhotoPreview* _tmp49_ = NULL;
				PhotoPreview* _tmp50_ = NULL;
				GdkPixbuf* pix = NULL;
				PhotoPreview* _tmp56_ = NULL;
				GdkPixbuf* _tmp57_ = NULL;
				GdkPixbuf* _tmp58_ = NULL;
				BackingPhotoRow* _tmp64_ = NULL;
				RawDeveloper _tmp65_ = 0;
				PhotoRow* _tmp66_ = NULL;
				BackingPhotoRow* _tmp67_ = NULL;
				const gchar* _tmp68_ = NULL;
				BackingPhotoRow* _tmp69_ = NULL;
				BackingPhotoRow* _tmp70_ = NULL;
				PhotoFileWriter* writer = NULL;
				BackingPhotoRow* _tmp71_ = NULL;
				const gchar* _tmp72_ = NULL;
				PhotoFileWriter* _tmp73_ = NULL;
				PhotoFileWriter* _tmp74_ = NULL;
				GdkPixbuf* _tmp75_ = NULL;
				PhotoFileMetadataWriter* mwriter = NULL;
				BackingPhotoRow* _tmp76_ = NULL;
				const gchar* _tmp77_ = NULL;
				PhotoFileMetadataWriter* _tmp78_ = NULL;
				PhotoFileMetadataWriter* _tmp79_ = NULL;
				PhotoMetadata* _tmp80_ = NULL;
#line 736 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp38_ = photo_get_master_metadata (self, &_inner_error_);
#line 736 "/home/jens/Source/shotwell/src/Photo.vala"
				meta = _tmp38_;
#line 736 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6078 "Photo.c"
					goto __catch269_g_error;
				}
#line 737 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp39_ = meta;
#line 737 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp40_ = photo_metadata_get_preview_count (_tmp39_);
#line 737 "/home/jens/Source/shotwell/src/Photo.vala"
				c = _tmp40_;
#line 738 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp41_ = c;
#line 738 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp41_ <= ((guint) 0)) {
#line 739 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 6093 "Photo.c"
					{
						gboolean _tmp42_ = FALSE;
#line 768 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp42_ = wrote_img_to_disk;
#line 768 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp42_) {
#line 6100 "Photo.c"
							{
								RawDeveloper _tmp43_ = 0;
								BackingPhotoRow* _tmp44_ = NULL;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp43_ = d;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp44_ = bps;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_add_backing_photo_for_development (self, _tmp43_, _tmp44_, &_inner_error_);
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6112 "Photo.c"
									goto __catch270_g_error;
								}
#line 773 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_notify_raw_development_modified (self);
#line 6117 "Photo.c"
							}
							goto __finally270;
							__catch270_g_error:
							{
								GError* e = NULL;
								GError* _tmp45_ = NULL;
								const gchar* _tmp46_ = NULL;
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
								e = _inner_error_;
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
								_inner_error_ = NULL;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp45_ = e;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp46_ = _tmp45_->message;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
								g_debug ("Photo.vala:775: Error adding backing photo as development. Message: %s", _tmp46_);
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
								_g_error_free0 (e);
#line 6137 "Photo.c"
							}
							__finally270:
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6142 "Photo.c"
								goto __catch269_g_error;
							}
						}
					}
#line 739 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (bps);
#line 739 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 6151 "Photo.c"
				}
#line 740 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp47_ = meta;
#line 740 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp48_ = c;
#line 740 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp49_ = photo_metadata_get_preview (_tmp47_, _tmp48_ - 1);
#line 740 "/home/jens/Source/shotwell/src/Photo.vala"
				prev = _tmp49_;
#line 741 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp50_ = prev;
#line 741 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp50_ == NULL) {
#line 742 "/home/jens/Source/shotwell/src/Photo.vala"
					g_debug ("Photo.vala:742: Could not get preview from metadata");
#line 743 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 743 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 6171 "Photo.c"
					{
						gboolean _tmp51_ = FALSE;
#line 768 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp51_ = wrote_img_to_disk;
#line 768 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp51_) {
#line 6178 "Photo.c"
							{
								RawDeveloper _tmp52_ = 0;
								BackingPhotoRow* _tmp53_ = NULL;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp52_ = d;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp53_ = bps;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_add_backing_photo_for_development (self, _tmp52_, _tmp53_, &_inner_error_);
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6190 "Photo.c"
									goto __catch271_g_error;
								}
#line 773 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_notify_raw_development_modified (self);
#line 6195 "Photo.c"
							}
							goto __finally271;
							__catch271_g_error:
							{
								GError* e = NULL;
								GError* _tmp54_ = NULL;
								const gchar* _tmp55_ = NULL;
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
								e = _inner_error_;
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
								_inner_error_ = NULL;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp54_ = e;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp55_ = _tmp54_->message;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
								g_debug ("Photo.vala:775: Error adding backing photo as development. Message: %s", _tmp55_);
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
								_g_error_free0 (e);
#line 6215 "Photo.c"
							}
							__finally271:
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6220 "Photo.c"
								goto __catch269_g_error;
							}
						}
					}
#line 743 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (bps);
#line 743 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 6229 "Photo.c"
				}
#line 746 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp56_ = prev;
#line 746 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp57_ = photo_preview_get_pixbuf (_tmp56_, &_inner_error_);
#line 746 "/home/jens/Source/shotwell/src/Photo.vala"
				pix = _tmp57_;
#line 746 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 746 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 746 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 6243 "Photo.c"
					goto __catch269_g_error;
				}
#line 747 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp58_ = pix;
#line 747 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp58_ == NULL) {
#line 748 "/home/jens/Source/shotwell/src/Photo.vala"
					g_debug ("Photo.vala:748: Could not get preview pixbuf");
#line 749 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 749 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 749 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 6258 "Photo.c"
					{
						gboolean _tmp59_ = FALSE;
#line 768 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp59_ = wrote_img_to_disk;
#line 768 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp59_) {
#line 6265 "Photo.c"
							{
								RawDeveloper _tmp60_ = 0;
								BackingPhotoRow* _tmp61_ = NULL;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp60_ = d;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp61_ = bps;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_add_backing_photo_for_development (self, _tmp60_, _tmp61_, &_inner_error_);
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6277 "Photo.c"
									goto __catch272_g_error;
								}
#line 773 "/home/jens/Source/shotwell/src/Photo.vala"
								photo_notify_raw_development_modified (self);
#line 6282 "Photo.c"
							}
							goto __finally272;
							__catch272_g_error:
							{
								GError* e = NULL;
								GError* _tmp62_ = NULL;
								const gchar* _tmp63_ = NULL;
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
								e = _inner_error_;
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
								_inner_error_ = NULL;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp62_ = e;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp63_ = _tmp62_->message;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
								g_debug ("Photo.vala:775: Error adding backing photo as development. Message: %s", _tmp63_);
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
								_g_error_free0 (e);
#line 6302 "Photo.c"
							}
							__finally272:
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6307 "Photo.c"
								goto __catch269_g_error;
							}
						}
					}
#line 749 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (bps);
#line 749 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 6316 "Photo.c"
				}
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp65_ = d;
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp66_ = self->row;
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp67_ = _tmp66_->master;
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp68_ = _tmp67_->filepath;
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp69_ = raw_developer_create_backing_row_for_development (_tmp65_, _tmp68_, NULL, &_inner_error_);
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp64_ = _tmp69_;
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 6338 "Photo.c"
					goto __catch269_g_error;
				}
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp70_ = _tmp64_;
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp64_ = NULL;
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (bps);
#line 753 "/home/jens/Source/shotwell/src/Photo.vala"
				bps = _tmp70_;
#line 754 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp71_ = bps;
#line 754 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp72_ = _tmp71_->filepath;
#line 754 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp73_ = photo_file_format_create_writer (PHOTO_FILE_FORMAT_JFIF, _tmp72_, &_inner_error_);
#line 754 "/home/jens/Source/shotwell/src/Photo.vala"
				writer = _tmp73_;
#line 754 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 754 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp64_);
#line 754 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 754 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 754 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 6367 "Photo.c"
					goto __catch269_g_error;
				}
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp74_ = writer;
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp75_ = pix;
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_file_writer_write (_tmp74_, _tmp75_, JPEG_QUALITY_HIGH, &_inner_error_);
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (writer);
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp64_);
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 755 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 6388 "Photo.c"
					goto __catch269_g_error;
				}
#line 759 "/home/jens/Source/shotwell/src/Photo.vala"
				wrote_img_to_disk = TRUE;
#line 762 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp76_ = bps;
#line 762 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp77_ = _tmp76_->filepath;
#line 762 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp78_ = photo_file_format_create_metadata_writer (PHOTO_FILE_FORMAT_JFIF, _tmp77_, &_inner_error_);
#line 762 "/home/jens/Source/shotwell/src/Photo.vala"
				mwriter = _tmp78_;
#line 762 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 762 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (writer);
#line 762 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp64_);
#line 762 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 762 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 762 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 6413 "Photo.c"
					goto __catch269_g_error;
				}
#line 763 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp79_ = mwriter;
#line 763 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp80_ = meta;
#line 763 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_file_metadata_writer_write_metadata (_tmp79_, _tmp80_, &_inner_error_);
#line 763 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 763 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (mwriter);
#line 763 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_file_adapter_unref0 (writer);
#line 763 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (_tmp64_);
#line 763 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (pix);
#line 763 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_preview_unref0 (prev);
#line 763 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (meta);
#line 6436 "Photo.c"
					goto __catch269_g_error;
				}
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_file_adapter_unref0 (mwriter);
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_file_adapter_unref0 (writer);
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (_tmp64_);
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (pix);
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_preview_unref0 (prev);
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				_media_metadata_unref0 (meta);
#line 6451 "Photo.c"
			}
			goto __finally269;
			__catch269_g_error:
			{
				GError* e = NULL;
				GError* _tmp81_ = NULL;
				const gchar* _tmp82_ = NULL;
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				e = _inner_error_;
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				_inner_error_ = NULL;
#line 765 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp81_ = e;
#line 765 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp82_ = _tmp81_->message;
#line 765 "/home/jens/Source/shotwell/src/Photo.vala"
				g_debug ("Photo.vala:765: Error accessing embedded preview. Message: %s", _tmp82_);
#line 766 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (e);
#line 6471 "Photo.c"
				{
					gboolean _tmp83_ = FALSE;
#line 768 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp83_ = wrote_img_to_disk;
#line 768 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp83_) {
#line 6478 "Photo.c"
						{
							RawDeveloper _tmp84_ = 0;
							BackingPhotoRow* _tmp85_ = NULL;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp84_ = d;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp85_ = bps;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
							photo_add_backing_photo_for_development (self, _tmp84_, _tmp85_, &_inner_error_);
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6490 "Photo.c"
								goto __catch273_g_error;
							}
#line 773 "/home/jens/Source/shotwell/src/Photo.vala"
							photo_notify_raw_development_modified (self);
#line 6495 "Photo.c"
						}
						goto __finally273;
						__catch273_g_error:
						{
							GError* e = NULL;
							GError* _tmp86_ = NULL;
							const gchar* _tmp87_ = NULL;
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
							e = _inner_error_;
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
							_inner_error_ = NULL;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp86_ = e;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp87_ = _tmp86_->message;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
							g_debug ("Photo.vala:775: Error adding backing photo as development. Message: %s", _tmp87_);
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_error_free0 (e);
#line 6515 "Photo.c"
						}
						__finally273:
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
							_backing_photo_row_unref0 (bps);
#line 6522 "Photo.c"
						}
					}
				}
#line 766 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (bps);
#line 766 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 6530 "Photo.c"
			}
			__finally269:
			{
				gboolean _tmp88_ = FALSE;
#line 768 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp88_ = wrote_img_to_disk;
#line 768 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp88_) {
#line 6539 "Photo.c"
					{
						RawDeveloper _tmp89_ = 0;
						BackingPhotoRow* _tmp90_ = NULL;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp89_ = d;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp90_ = bps;
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
						photo_add_backing_photo_for_development (self, _tmp89_, _tmp90_, &_inner_error_);
#line 771 "/home/jens/Source/shotwell/src/Photo.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6551 "Photo.c"
							goto __catch274_g_error;
						}
#line 773 "/home/jens/Source/shotwell/src/Photo.vala"
						photo_notify_raw_development_modified (self);
#line 6556 "Photo.c"
					}
					goto __finally274;
					__catch274_g_error:
					{
						GError* e = NULL;
						GError* _tmp91_ = NULL;
						const gchar* _tmp92_ = NULL;
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
						e = _inner_error_;
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
						_inner_error_ = NULL;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp91_ = e;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp92_ = _tmp91_->message;
#line 775 "/home/jens/Source/shotwell/src/Photo.vala"
						g_debug ("Photo.vala:775: Error adding backing photo as development. Message: %s", _tmp92_);
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_error_free0 (e);
#line 6576 "Photo.c"
					}
					__finally274:
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
						_backing_photo_row_unref0 (bps);
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
						g_clear_error (&_inner_error_);
#line 769 "/home/jens/Source/shotwell/src/Photo.vala"
						return;
#line 6589 "Photo.c"
					}
				}
			}
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (bps);
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 734 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 6603 "Photo.c"
			}
#line 780 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 6607 "Photo.c"
		}
		default:
		{
#line 783 "/home/jens/Source/shotwell/src/Photo.vala"
			g_assert_not_reached ();
#line 6613 "Photo.c"
		}
	}
#line 670 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_photo_row_unref0 (bps);
#line 6618 "Photo.c"
}


void photo_set_default_raw_developer (Photo* self, RawDeveloper d) {
	GError * _inner_error_ = NULL;
#line 788 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 6626 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 6633 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			RawDeveloper _tmp2_ = 0;
#line 790 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 790 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = d;
#line 790 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_->developer = _tmp2_;
#line 6643 "Photo.c"
		}
		__finally275:
		{
			PhotoRow* _tmp3_ = NULL;
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 6652 "Photo.c"
		}
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 789 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 6662 "Photo.c"
		}
	}
}


void photo_set_raw_developer (Photo* self, RawDeveloper d) {
	PhotoFileFormat _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_ = FALSE;
	Alteration* _tmp48_ = NULL;
	Alteration* _tmp49_ = NULL;
	GError * _inner_error_ = NULL;
#line 795 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 796 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_master_file_format (self);
#line 796 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp0_ != PHOTO_FILE_FORMAT_RAW) {
#line 797 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 6684 "Photo.c"
	}
#line 802 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_is_raw_developer_available (self, RAW_DEVELOPER_CAMERA);
#line 802 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_) {
#line 6690 "Photo.c"
		RawDeveloper _tmp3_ = 0;
#line 802 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = d;
#line 802 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp3_ == RAW_DEVELOPER_EMBEDDED;
#line 6696 "Photo.c"
	} else {
#line 802 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = FALSE;
#line 6700 "Photo.c"
	}
#line 802 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_) {
#line 803 "/home/jens/Source/shotwell/src/Photo.vala"
		d = RAW_DEVELOPER_CAMERA;
#line 6706 "Photo.c"
	}
#line 807 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = photo_is_raw_developer_available (self, RAW_DEVELOPER_EMBEDDED);
#line 807 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp4_) {
#line 808 "/home/jens/Source/shotwell/src/Photo.vala"
		d = RAW_DEVELOPER_SHOTWELL;
#line 6714 "Photo.c"
	}
	{
		GeeHashMap* _tmp5_ = NULL;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = self->priv->developments;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_developments);
#line 6722 "Photo.c"
		{
			RawDeveloper stale_raw_developer = 0;
			PhotoRow* _tmp6_ = NULL;
			RawDeveloper _tmp7_ = 0;
			RawDeveloper _tmp8_ = 0;
			gboolean _tmp9_ = FALSE;
			GeeHashMap* _tmp11_ = NULL;
			RawDeveloper _tmp12_ = 0;
			gboolean _tmp13_ = FALSE;
			PhotoRow* _tmp15_ = NULL;
			RawDeveloper _tmp16_ = 0;
			GeeHashMap* _tmp17_ = NULL;
			RawDeveloper _tmp18_ = 0;
			gpointer _tmp19_ = NULL;
			PhotoBackingReaders* _tmp20_ = NULL;
			BackingPhotoRow* _tmp21_ = NULL;
			PhotoFileFormat _tmp22_ = 0;
			BackingPhotoRow* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			PhotoFileReader* _tmp25_ = NULL;
			BackingPhotoRow* _tmp30_ = NULL;
			Orientation _tmp31_ = 0;
			gboolean _tmp41_ = FALSE;
			RawDeveloper _tmp42_ = 0;
#line 811 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = self->row;
#line 811 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = _tmp6_->developer;
#line 811 "/home/jens/Source/shotwell/src/Photo.vala"
			stale_raw_developer = _tmp7_;
#line 814 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = d;
#line 814 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = photo_is_raw_developer_complete (self, _tmp8_);
#line 814 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!_tmp9_) {
#line 6759 "Photo.c"
				RawDeveloper _tmp10_ = 0;
#line 815 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = d;
#line 815 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_develop_photo (self, _tmp10_);
#line 6765 "Photo.c"
			}
#line 817 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = self->priv->developments;
#line 817 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = d;
#line 817 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp12_));
#line 817 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!_tmp13_) {
#line 6775 "Photo.c"
				{
					GeeHashMap* _tmp14_ = NULL;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_ = self->priv->developments;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 6782 "Photo.c"
				}
#line 818 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 6786 "Photo.c"
			}
#line 821 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_revert_to_master (self, FALSE);
#line 824 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = self->row;
#line 824 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = d;
#line 824 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_->developer = _tmp16_;
#line 825 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = self->priv->developments;
#line 825 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp18_ = d;
#line 825 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp19_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp18_));
#line 825 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (self->backing_photo_row);
#line 825 "/home/jens/Source/shotwell/src/Photo.vala"
			self->backing_photo_row = (BackingPhotoRow*) _tmp19_;
#line 826 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp20_ = self->priv->readers;
#line 826 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp21_ = self->backing_photo_row;
#line 826 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp22_ = _tmp21_->file_format;
#line 826 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp23_ = self->backing_photo_row;
#line 826 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp24_ = _tmp23_->filepath;
#line 826 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp25_ = photo_file_format_create_reader (_tmp22_, _tmp24_);
#line 826 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_adapter_unref0 (_tmp20_->developer);
#line 826 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp20_->developer = _tmp25_;
#line 6822 "Photo.c"
			{
				GdkPixbuf* _tmp26_ = NULL;
				GdkPixbuf* _tmp27_ = NULL;
#line 829 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp26_ = photo_get_prefetched_copy (self, &_inner_error_);
#line 829 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp27_ = _tmp26_;
#line 829 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_tmp27_);
#line 829 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6834 "Photo.c"
					goto __catch277_g_error;
				}
			}
			goto __finally277;
			__catch277_g_error:
			{
				GError* e = NULL;
#line 828 "/home/jens/Source/shotwell/src/Photo.vala"
				e = _inner_error_;
#line 828 "/home/jens/Source/shotwell/src/Photo.vala"
				_inner_error_ = NULL;
#line 832 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (e);
#line 6848 "Photo.c"
				{
					GeeHashMap* _tmp28_ = NULL;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp28_ = self->priv->developments;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 6855 "Photo.c"
				}
#line 832 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 6859 "Photo.c"
			}
			__finally277:
#line 828 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6864 "Photo.c"
				{
					GeeHashMap* _tmp29_ = NULL;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp29_ = self->priv->developments;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 6871 "Photo.c"
				}
#line 828 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 828 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 828 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 6879 "Photo.c"
			}
#line 835 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp30_ = self->backing_photo_row;
#line 835 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp31_ = _tmp30_->original_orientation;
#line 835 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_set_orientation (self, _tmp31_);
#line 6887 "Photo.c"
			{
				PhotoTable* _tmp32_ = NULL;
				PhotoTable* _tmp33_ = NULL;
				PhotoRow* _tmp34_ = NULL;
				RawDeveloper _tmp35_ = 0;
				BackingPhotoRow* _tmp36_ = NULL;
				BackingPhotoID _tmp37_ = {0};
#line 838 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp32_ = photo_table_get_instance ();
#line 838 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp33_ = _tmp32_;
#line 838 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp34_ = self->row;
#line 838 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp35_ = d;
#line 838 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp36_ = self->backing_photo_row;
#line 838 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp37_ = _tmp36_->id;
#line 838 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_table_update_raw_development (_tmp33_, _tmp34_, _tmp35_, &_tmp37_, &_inner_error_);
#line 838 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp33_);
#line 838 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6913 "Photo.c"
					goto __catch278_g_error;
				}
			}
			goto __finally278;
			__catch278_g_error:
			{
				GError* e = NULL;
				GError* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
#line 837 "/home/jens/Source/shotwell/src/Photo.vala"
				e = _inner_error_;
#line 837 "/home/jens/Source/shotwell/src/Photo.vala"
				_inner_error_ = NULL;
#line 840 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp38_ = e;
#line 840 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp39_ = _tmp38_->message;
#line 840 "/home/jens/Source/shotwell/src/Photo.vala"
				g_warning ("Photo.vala:840: Error updating database: %s", _tmp39_);
#line 837 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (e);
#line 6935 "Photo.c"
			}
			__finally278:
#line 837 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6940 "Photo.c"
				{
					GeeHashMap* _tmp40_ = NULL;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp40_ = self->priv->developments;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 6947 "Photo.c"
				}
#line 837 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 837 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 837 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 6955 "Photo.c"
			}
#line 847 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp42_ = stale_raw_developer;
#line 847 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp42_ != RAW_DEVELOPER_CAMERA) {
#line 6961 "Photo.c"
				RawDeveloper _tmp43_ = 0;
				PhotoRow* _tmp44_ = NULL;
				RawDeveloper _tmp45_ = 0;
#line 848 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp43_ = stale_raw_developer;
#line 848 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp44_ = self->row;
#line 848 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp45_ = _tmp44_->developer;
#line 848 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp41_ = _tmp43_ != _tmp45_;
#line 6973 "Photo.c"
			} else {
#line 847 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp41_ = FALSE;
#line 6977 "Photo.c"
			}
#line 847 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp41_) {
#line 6981 "Photo.c"
				RawDeveloper _tmp46_ = 0;
#line 851 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp46_ = stale_raw_developer;
#line 851 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_delete_raw_development (self, _tmp46_);
#line 6987 "Photo.c"
			}
		}
		__finally276:
		{
			GeeHashMap* _tmp47_ = NULL;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp47_ = self->priv->developments;
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 6997 "Photo.c"
		}
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 810 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 7007 "Photo.c"
		}
	}
#line 858 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp48_ = alteration_new ("image", "developer");
#line 858 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp49_ = _tmp48_;
#line 858 "/home/jens/Source/shotwell/src/Photo.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp49_);
#line 858 "/home/jens/Source/shotwell/src/Photo.vala"
	_alteration_unref0 (_tmp49_);
#line 859 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_discard_prefetched (self);
#line 7020 "Photo.c"
}


RawDeveloper photo_get_raw_developer (Photo* self) {
	RawDeveloper result = 0;
	PhotoRow* _tmp0_ = NULL;
	RawDeveloper _tmp1_ = 0;
#line 862 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0);
#line 863 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = self->row;
#line 863 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_->developer;
#line 863 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp1_;
#line 863 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 7038 "Photo.c"
}


static gboolean photo_delete_raw_development (Photo* self, RawDeveloper d) {
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
#line 868 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 869 "/home/jens/Source/shotwell/src/Photo.vala"
	ret = FALSE;
#line 7050 "Photo.c"
	{
		GeeHashMap* _tmp0_ = NULL;
#line 871 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->developments;
#line 871 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_developments);
#line 7057 "Photo.c"
		{
			GeeHashMap* _tmp1_ = NULL;
			RawDeveloper _tmp2_ = 0;
			gboolean _tmp3_ = FALSE;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			RawDeveloper _tmp7_ = 0;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			BackingPhotoRow* bpr = NULL;
			GeeHashMap* _tmp10_ = NULL;
			RawDeveloper _tmp11_ = 0;
			gpointer _tmp12_ = NULL;
			BackingPhotoRow* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			GeeHashMap* _tmp39_ = NULL;
			RawDeveloper _tmp40_ = 0;
			gboolean _tmp41_ = FALSE;
#line 872 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->developments;
#line 872 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = d;
#line 872 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp2_));
#line 872 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!_tmp3_) {
#line 873 "/home/jens/Source/shotwell/src/Photo.vala"
				result = FALSE;
#line 7086 "Photo.c"
				{
					GeeHashMap* _tmp4_ = NULL;
#line 871 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp4_ = self->priv->developments;
#line 871 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 7093 "Photo.c"
				}
#line 873 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 7097 "Photo.c"
			}
#line 877 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 877 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _tmp5_;
#line 877 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = d;
#line 877 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = raw_developer_to_string (_tmp7_);
#line 877 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = _tmp8_;
#line 877 "/home/jens/Source/shotwell/src/Photo.vala"
			g_debug ("Photo.vala:877: Delete raw development: %s %s", _tmp6_, _tmp9_);
#line 877 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (_tmp9_);
#line 877 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (_tmp6_);
#line 878 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = self->priv->developments;
#line 878 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = d;
#line 878 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp11_));
#line 878 "/home/jens/Source/shotwell/src/Photo.vala"
			bpr = (BackingPhotoRow*) _tmp12_;
#line 879 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = bpr;
#line 879 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = _tmp13_->filepath;
#line 879 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp14_ != NULL) {
#line 7129 "Photo.c"
				GFile* f = NULL;
				BackingPhotoRow* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				GFile* _tmp17_ = NULL;
#line 880 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = bpr;
#line 880 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = _tmp15_->filepath;
#line 880 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = g_file_new_for_path (_tmp16_);
#line 880 "/home/jens/Source/shotwell/src/Photo.vala"
				f = _tmp17_;
#line 7142 "Photo.c"
				{
					RawDeveloper _tmp18_ = 0;
#line 882 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp18_ = d;
#line 882 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp18_ == RAW_DEVELOPER_CAMERA) {
#line 7149 "Photo.c"
						GFile* _tmp19_ = NULL;
#line 883 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp19_ = f;
#line 883 "/home/jens/Source/shotwell/src/Photo.vala"
						g_file_trash (_tmp19_, NULL, &_inner_error_);
#line 883 "/home/jens/Source/shotwell/src/Photo.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7157 "Photo.c"
							goto __catch280_g_error;
						}
					} else {
						GFile* _tmp20_ = NULL;
#line 885 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp20_ = f;
#line 885 "/home/jens/Source/shotwell/src/Photo.vala"
						g_file_delete (_tmp20_, NULL, &_inner_error_);
#line 885 "/home/jens/Source/shotwell/src/Photo.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7168 "Photo.c"
							goto __catch280_g_error;
						}
					}
				}
				goto __finally280;
				__catch280_g_error:
				{
					GError* e = NULL;
					BackingPhotoRow* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					GError* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
#line 881 "/home/jens/Source/shotwell/src/Photo.vala"
					e = _inner_error_;
#line 881 "/home/jens/Source/shotwell/src/Photo.vala"
					_inner_error_ = NULL;
#line 887 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp21_ = bpr;
#line 887 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp22_ = _tmp21_->filepath;
#line 887 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp23_ = e;
#line 887 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp24_ = _tmp23_->message;
#line 887 "/home/jens/Source/shotwell/src/Photo.vala"
					g_warning ("Photo.vala:887: Unable to delete RAW development: %s error: %s", _tmp22_, _tmp24_);
#line 881 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_error_free0 (e);
#line 7197 "Photo.c"
				}
				__finally280:
#line 881 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7202 "Photo.c"
					gboolean _tmp26_ = FALSE;
#line 881 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (f);
#line 881 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (bpr);
#line 881 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (f);
#line 881 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (bpr);
#line 7212 "Photo.c"
					{
						GeeHashMap* _tmp25_ = NULL;
#line 871 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp25_ = self->priv->developments;
#line 871 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 7219 "Photo.c"
					}
#line 881 "/home/jens/Source/shotwell/src/Photo.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 881 "/home/jens/Source/shotwell/src/Photo.vala"
					g_clear_error (&_inner_error_);
#line 881 "/home/jens/Source/shotwell/src/Photo.vala"
					return _tmp26_;
#line 7227 "Photo.c"
				}
#line 879 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (f);
#line 7231 "Photo.c"
			}
			{
				PhotoTable* _tmp27_ = NULL;
				PhotoTable* _tmp28_ = NULL;
				PhotoRow* _tmp29_ = NULL;
				RawDeveloper _tmp30_ = 0;
				BackingPhotoTable* _tmp31_ = NULL;
				BackingPhotoTable* _tmp32_ = NULL;
				BackingPhotoRow* _tmp33_ = NULL;
				BackingPhotoID _tmp34_ = {0};
#line 893 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp27_ = photo_table_get_instance ();
#line 893 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp28_ = _tmp27_;
#line 893 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp29_ = self->row;
#line 893 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp30_ = d;
#line 893 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_table_remove_development (_tmp28_, _tmp29_, _tmp30_, &_inner_error_);
#line 893 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp28_);
#line 893 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7256 "Photo.c"
					goto __catch281_g_error;
				}
#line 894 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp31_ = backing_photo_table_get_instance ();
#line 894 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp32_ = _tmp31_;
#line 894 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp33_ = bpr;
#line 894 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp34_ = _tmp33_->id;
#line 894 "/home/jens/Source/shotwell/src/Photo.vala"
				backing_photo_table_remove (_tmp32_, &_tmp34_, &_inner_error_);
#line 894 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp32_);
#line 894 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7273 "Photo.c"
					goto __catch281_g_error;
				}
			}
			goto __finally281;
			__catch281_g_error:
			{
				GError* e = NULL;
				GError* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
#line 892 "/home/jens/Source/shotwell/src/Photo.vala"
				e = _inner_error_;
#line 892 "/home/jens/Source/shotwell/src/Photo.vala"
				_inner_error_ = NULL;
#line 896 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp35_ = e;
#line 896 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp36_ = _tmp35_->message;
#line 896 "/home/jens/Source/shotwell/src/Photo.vala"
				g_warning ("Photo.vala:896: Database error while deleting RAW development: %s", _tmp36_);
#line 892 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (e);
#line 7295 "Photo.c"
			}
			__finally281:
#line 892 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7300 "Photo.c"
				gboolean _tmp38_ = FALSE;
#line 892 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (bpr);
#line 892 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (bpr);
#line 7306 "Photo.c"
				{
					GeeHashMap* _tmp37_ = NULL;
#line 871 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp37_ = self->priv->developments;
#line 871 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 7313 "Photo.c"
				}
#line 892 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 892 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 892 "/home/jens/Source/shotwell/src/Photo.vala"
				return _tmp38_;
#line 7321 "Photo.c"
			}
#line 899 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp39_ = self->priv->developments;
#line 899 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp40_ = d;
#line 899 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp41_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp40_), NULL);
#line 899 "/home/jens/Source/shotwell/src/Photo.vala"
			ret = _tmp41_;
#line 871 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (bpr);
#line 7333 "Photo.c"
		}
		__finally279:
		{
			GeeHashMap* _tmp42_ = NULL;
#line 871 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp42_ = self->priv->developments;
#line 871 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 7342 "Photo.c"
		}
#line 871 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7346 "Photo.c"
			gboolean _tmp43_ = FALSE;
#line 871 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 871 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 871 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp43_;
#line 7354 "Photo.c"
		}
	}
#line 902 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_notify_raw_development_modified (self);
#line 903 "/home/jens/Source/shotwell/src/Photo.vala"
	result = ret;
#line 903 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 7363 "Photo.c"
}


void photo_redevelop_raw (Photo* self, RawDeveloper d) {
	GError * _inner_error_ = NULL;
#line 907 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 7371 "Photo.c"
	{
		GeeHashMap* _tmp0_ = NULL;
#line 908 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->developments;
#line 908 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_developments);
#line 7378 "Photo.c"
		{
			RawDeveloper _tmp1_ = 0;
			RawDeveloper dev = 0;
			RawDeveloper _tmp2_ = 0;
			RawDeveloper _tmp3_ = 0;
			RawDeveloper _tmp4_ = 0;
#line 909 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = d;
#line 909 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_delete_raw_development (self, _tmp1_);
#line 910 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = d;
#line 910 "/home/jens/Source/shotwell/src/Photo.vala"
			dev = _tmp2_;
#line 911 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = dev;
#line 911 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp3_ == RAW_DEVELOPER_CAMERA) {
#line 912 "/home/jens/Source/shotwell/src/Photo.vala"
				dev = RAW_DEVELOPER_EMBEDDED;
#line 7399 "Photo.c"
			}
#line 914 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = dev;
#line 914 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_set_raw_developer (self, _tmp4_);
#line 7405 "Photo.c"
		}
		__finally282:
		{
			GeeHashMap* _tmp5_ = NULL;
#line 908 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->priv->developments;
#line 908 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_developments);
#line 7414 "Photo.c"
		}
#line 908 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 908 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 908 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 908 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 7424 "Photo.c"
		}
	}
}


static void _vala_array_add85 (BackingFileState*** array, int* length, int* size, BackingFileState* value) {
#line 921 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 921 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 921 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (BackingFileState*, *array, (*size) + 1);
#line 7437 "Photo.c"
	}
#line 921 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 921 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 7443 "Photo.c"
}


static void _vala_array_add86 (BackingFileState*** array, int* length, int* size, BackingFileState* value) {
#line 923 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 923 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 923 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (BackingFileState*, *array, (*size) + 1);
#line 7454 "Photo.c"
	}
#line 923 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 923 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 7460 "Photo.c"
}


static void _vala_array_add87 (BackingFileState*** array, int* length, int* size, BackingFileState* value) {
#line 930 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 930 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 930 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (BackingFileState*, *array, (*size) + 1);
#line 7471 "Photo.c"
	}
#line 930 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 930 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 7477 "Photo.c"
}


static BackingFileState** photo_real_get_backing_files_state (MediaSource* base, int* result_length1) {
	Photo * self;
	BackingFileState** result = NULL;
	BackingFileState** backing = NULL;
	BackingFileState** _tmp0_ = NULL;
	gint backing_length1 = 0;
	gint _backing_size_ = 0;
	BackingFileState** _tmp27_ = NULL;
	gint _tmp27__length1 = 0;
	GError * _inner_error_ = NULL;
#line 918 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 919 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = g_new0 (BackingFileState*, 0 + 1);
#line 919 "/home/jens/Source/shotwell/src/Photo.vala"
	backing = _tmp0_;
#line 919 "/home/jens/Source/shotwell/src/Photo.vala"
	backing_length1 = 0;
#line 919 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_size_ = backing_length1;
#line 7501 "Photo.c"
	{
		PhotoRow* _tmp1_ = NULL;
#line 920 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = self->row;
#line 920 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 7508 "Photo.c"
		{
			BackingFileState** _tmp2_ = NULL;
			gint _tmp2__length1 = 0;
			PhotoRow* _tmp3_ = NULL;
			BackingPhotoRow* _tmp4_ = NULL;
			PhotoRow* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			BackingFileState* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp12_ = FALSE;
#line 921 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = backing;
#line 921 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2__length1 = backing_length1;
#line 921 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 921 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _tmp3_->master;
#line 921 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 921 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _tmp5_->md5;
#line 921 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = backing_file_state_new_from_photo_row (_tmp4_, _tmp6_);
#line 921 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add85 (&backing, &backing_length1, &_backing_size_, _tmp7_);
#line 922 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = photo_has_editable (self);
#line 922 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp8_) {
#line 7539 "Photo.c"
				BackingFileState** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				BackingPhotoRow* _tmp10_ = NULL;
				BackingFileState* _tmp11_ = NULL;
#line 923 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = backing;
#line 923 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9__length1 = backing_length1;
#line 923 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = self->priv->editable;
#line 923 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = backing_file_state_new_from_photo_row (_tmp10_, NULL);
#line 923 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_array_add86 (&backing, &backing_length1, &_backing_size_, _tmp11_);
#line 7554 "Photo.c"
			}
#line 925 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = photo_is_developed (self);
#line 925 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp12_) {
#line 7560 "Photo.c"
				GeeCollection* dev_rows = NULL;
				GeeCollection* _tmp13_ = NULL;
				GeeCollection* _tmp14_ = NULL;
#line 926 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = photo_get_raw_development_photo_rows (self);
#line 926 "/home/jens/Source/shotwell/src/Photo.vala"
				dev_rows = _tmp13_;
#line 927 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = dev_rows;
#line 927 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp14_ != NULL) {
#line 7572 "Photo.c"
					{
						GeeIterator* _r_it = NULL;
						GeeCollection* _tmp15_ = NULL;
						GeeIterator* _tmp16_ = NULL;
#line 928 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp15_ = dev_rows;
#line 928 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp16_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ITERABLE, GeeIterable));
#line 928 "/home/jens/Source/shotwell/src/Photo.vala"
						_r_it = _tmp16_;
#line 928 "/home/jens/Source/shotwell/src/Photo.vala"
						while (TRUE) {
#line 7585 "Photo.c"
							GeeIterator* _tmp17_ = NULL;
							gboolean _tmp18_ = FALSE;
							BackingPhotoRow* r = NULL;
							GeeIterator* _tmp19_ = NULL;
							gpointer _tmp20_ = NULL;
							BackingPhotoRow* _tmp21_ = NULL;
							const gchar* _tmp22_ = NULL;
							BackingFileState** _tmp23_ = NULL;
							gint _tmp23__length1 = 0;
							BackingPhotoRow* _tmp24_ = NULL;
							BackingFileState* _tmp25_ = NULL;
#line 928 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp17_ = _r_it;
#line 928 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp18_ = gee_iterator_next (_tmp17_);
#line 928 "/home/jens/Source/shotwell/src/Photo.vala"
							if (!_tmp18_) {
#line 928 "/home/jens/Source/shotwell/src/Photo.vala"
								break;
#line 7605 "Photo.c"
							}
#line 928 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp19_ = _r_it;
#line 928 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp20_ = gee_iterator_get (_tmp19_);
#line 928 "/home/jens/Source/shotwell/src/Photo.vala"
							r = (BackingPhotoRow*) _tmp20_;
#line 929 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp21_ = r;
#line 929 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp22_ = _tmp21_->filepath;
#line 929 "/home/jens/Source/shotwell/src/Photo.vala"
							g_debug ("Photo.vala:929: adding: %s", _tmp22_);
#line 930 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp23_ = backing;
#line 930 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp23__length1 = backing_length1;
#line 930 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp24_ = r;
#line 930 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp25_ = backing_file_state_new_from_photo_row (_tmp24_, NULL);
#line 930 "/home/jens/Source/shotwell/src/Photo.vala"
							_vala_array_add87 (&backing, &backing_length1, &_backing_size_, _tmp25_);
#line 928 "/home/jens/Source/shotwell/src/Photo.vala"
							_backing_photo_row_unref0 (r);
#line 7631 "Photo.c"
						}
#line 928 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (_r_it);
#line 7635 "Photo.c"
					}
				}
#line 925 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (dev_rows);
#line 7640 "Photo.c"
			}
		}
		__finally283:
		{
			PhotoRow* _tmp26_ = NULL;
#line 920 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp26_ = self->row;
#line 920 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 7650 "Photo.c"
		}
#line 920 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 920 "/home/jens/Source/shotwell/src/Photo.vala"
			backing = (_vala_array_free (backing, backing_length1, (GDestroyNotify) backing_file_state_unref), NULL);
#line 920 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 920 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 920 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 7662 "Photo.c"
		}
	}
#line 936 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp27_ = backing;
#line 936 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp27__length1 = backing_length1;
#line 936 "/home/jens/Source/shotwell/src/Photo.vala"
	if (result_length1) {
#line 936 "/home/jens/Source/shotwell/src/Photo.vala"
		*result_length1 = _tmp27__length1;
#line 7673 "Photo.c"
	}
#line 936 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp27_;
#line 936 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 7679 "Photo.c"
}


static PhotoFileReader* photo_get_backing_reader (Photo* self, BackingFetchMode mode) {
	PhotoFileReader* result = NULL;
	BackingFetchMode _tmp0_ = 0;
#line 939 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 940 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = mode;
#line 940 "/home/jens/Source/shotwell/src/Photo.vala"
	switch (_tmp0_) {
#line 940 "/home/jens/Source/shotwell/src/Photo.vala"
		case BACKING_FETCH_MODE_MASTER:
#line 7694 "Photo.c"
		{
			PhotoFileReader* _tmp1_ = NULL;
#line 942 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = photo_get_master_reader (self);
#line 942 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp1_;
#line 942 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 7703 "Photo.c"
		}
#line 940 "/home/jens/Source/shotwell/src/Photo.vala"
		case BACKING_FETCH_MODE_BASELINE:
#line 7707 "Photo.c"
		{
			PhotoFileReader* _tmp2_ = NULL;
#line 945 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = photo_get_baseline_reader (self);
#line 945 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 945 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 7716 "Photo.c"
		}
#line 940 "/home/jens/Source/shotwell/src/Photo.vala"
		case BACKING_FETCH_MODE_SOURCE:
#line 7720 "Photo.c"
		{
			PhotoFileReader* _tmp3_ = NULL;
#line 948 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = photo_get_source_reader (self);
#line 948 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 948 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 7729 "Photo.c"
		}
#line 940 "/home/jens/Source/shotwell/src/Photo.vala"
		case BACKING_FETCH_MODE_UNMODIFIED:
#line 7733 "Photo.c"
		{
			PhotoFileFormat _tmp4_ = 0;
#line 951 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = photo_get_master_file_format (self);
#line 951 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp4_ == PHOTO_FILE_FORMAT_RAW) {
#line 7740 "Photo.c"
				PhotoFileReader* _tmp5_ = NULL;
#line 952 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = photo_get_raw_developer_reader (self);
#line 952 "/home/jens/Source/shotwell/src/Photo.vala"
				result = _tmp5_;
#line 952 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 7748 "Photo.c"
			} else {
				PhotoFileReader* _tmp6_ = NULL;
#line 954 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = photo_get_master_reader (self);
#line 954 "/home/jens/Source/shotwell/src/Photo.vala"
				result = _tmp6_;
#line 954 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 7757 "Photo.c"
			}
		}
		default:
		{
			BackingFetchMode _tmp7_ = 0;
			GEnumValue* _tmp8_;
#line 957 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = mode;
#line 957 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = g_enum_get_value (g_type_class_ref (TYPE_BACKING_FETCH_MODE), _tmp7_);
#line 957 "/home/jens/Source/shotwell/src/Photo.vala"
			g_error ("Photo.vala:957: Unknown backing fetch mode %s", (_tmp8_ != NULL) ? _tmp8_->value_name : NULL);
#line 7770 "Photo.c"
		}
	}
}


static gpointer _photo_file_adapter_ref0 (gpointer self) {
#line 963 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? photo_file_adapter_ref (self) : NULL;
#line 7779 "Photo.c"
}


static PhotoFileReader* photo_get_master_reader (Photo* self) {
	PhotoFileReader* result = NULL;
	GError * _inner_error_ = NULL;
#line 961 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 7788 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
#line 962 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 962 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 7795 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
			PhotoFileReader* _tmp3_ = NULL;
#line 963 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 963 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->master;
#line 963 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _photo_file_adapter_ref0 (_tmp2_);
#line 963 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 7808 "Photo.c"
			{
				PhotoBackingReaders* _tmp4_ = NULL;
#line 962 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->priv->readers;
#line 962 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 7815 "Photo.c"
			}
#line 963 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 7819 "Photo.c"
		}
		__finally284:
		{
			PhotoBackingReaders* _tmp5_ = NULL;
#line 962 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->priv->readers;
#line 962 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 7828 "Photo.c"
		}
#line 962 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 962 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 962 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 7836 "Photo.c"
	}
}


PhotoFileReader* photo_get_editable_reader (Photo* self) {
	PhotoFileReader* result = NULL;
	GError * _inner_error_ = NULL;
#line 967 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 7846 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
#line 968 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 968 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 7853 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
			PhotoFileReader* _tmp3_ = NULL;
#line 969 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 969 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable;
#line 969 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _photo_file_adapter_ref0 (_tmp2_);
#line 969 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 7866 "Photo.c"
			{
				PhotoBackingReaders* _tmp4_ = NULL;
#line 968 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->priv->readers;
#line 968 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 7873 "Photo.c"
			}
#line 969 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 7877 "Photo.c"
		}
		__finally285:
		{
			PhotoBackingReaders* _tmp5_ = NULL;
#line 968 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->priv->readers;
#line 968 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 7886 "Photo.c"
		}
#line 968 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 968 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 968 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 7894 "Photo.c"
	}
}


static PhotoFileReader* photo_get_baseline_reader (Photo* self) {
	PhotoFileReader* result = NULL;
	GError * _inner_error_ = NULL;
#line 974 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 7904 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
#line 975 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 975 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 7911 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
			PhotoBackingReaders* _tmp7_ = NULL;
			PhotoFileReader* _tmp8_ = NULL;
			PhotoBackingReaders* _tmp13_ = NULL;
			PhotoFileReader* _tmp14_ = NULL;
			PhotoFileReader* _tmp15_ = NULL;
#line 976 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 976 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable;
#line 976 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 7926 "Photo.c"
				PhotoBackingReaders* _tmp3_ = NULL;
				PhotoFileReader* _tmp4_ = NULL;
				PhotoFileReader* _tmp5_ = NULL;
#line 977 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->readers;
#line 977 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_->editable;
#line 977 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _photo_file_adapter_ref0 (_tmp4_);
#line 977 "/home/jens/Source/shotwell/src/Photo.vala"
				result = _tmp5_;
#line 7938 "Photo.c"
				{
					PhotoBackingReaders* _tmp6_ = NULL;
#line 975 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp6_ = self->priv->readers;
#line 975 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 7945 "Photo.c"
				}
#line 977 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 7949 "Photo.c"
			}
#line 979 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->priv->readers;
#line 979 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = _tmp7_->developer;
#line 979 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp8_ != NULL) {
#line 7957 "Photo.c"
				PhotoBackingReaders* _tmp9_ = NULL;
				PhotoFileReader* _tmp10_ = NULL;
				PhotoFileReader* _tmp11_ = NULL;
#line 980 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = self->priv->readers;
#line 980 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = _tmp9_->developer;
#line 980 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = _photo_file_adapter_ref0 (_tmp10_);
#line 980 "/home/jens/Source/shotwell/src/Photo.vala"
				result = _tmp11_;
#line 7969 "Photo.c"
				{
					PhotoBackingReaders* _tmp12_ = NULL;
#line 975 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp12_ = self->priv->readers;
#line 975 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 7976 "Photo.c"
				}
#line 980 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 7980 "Photo.c"
			}
#line 982 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = self->priv->readers;
#line 982 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = _tmp13_->master;
#line 982 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = _photo_file_adapter_ref0 (_tmp14_);
#line 982 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp15_;
#line 7990 "Photo.c"
			{
				PhotoBackingReaders* _tmp16_ = NULL;
#line 975 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = self->priv->readers;
#line 975 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 7997 "Photo.c"
			}
#line 982 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8001 "Photo.c"
		}
		__finally286:
		{
			PhotoBackingReaders* _tmp17_ = NULL;
#line 975 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = self->priv->readers;
#line 975 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8010 "Photo.c"
		}
#line 975 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 975 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 975 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 8018 "Photo.c"
	}
}


static PhotoFileReader* photo_get_source_reader (Photo* self) {
	PhotoFileReader* result = NULL;
	GError * _inner_error_ = NULL;
#line 987 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 8028 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
#line 988 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 988 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 8035 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
			PhotoBackingReaders* _tmp7_ = NULL;
			PhotoFileReader* _tmp8_ = NULL;
			PhotoBackingReaders* _tmp13_ = NULL;
			PhotoFileReader* _tmp14_ = NULL;
			PhotoFileReader* _tmp15_ = NULL;
#line 989 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 989 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable;
#line 989 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 8050 "Photo.c"
				PhotoBackingReaders* _tmp3_ = NULL;
				PhotoFileReader* _tmp4_ = NULL;
				PhotoFileReader* _tmp5_ = NULL;
#line 990 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->readers;
#line 990 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_->editable;
#line 990 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _photo_file_adapter_ref0 (_tmp4_);
#line 990 "/home/jens/Source/shotwell/src/Photo.vala"
				result = _tmp5_;
#line 8062 "Photo.c"
				{
					PhotoBackingReaders* _tmp6_ = NULL;
#line 988 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp6_ = self->priv->readers;
#line 988 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8069 "Photo.c"
				}
#line 990 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 8073 "Photo.c"
			}
#line 992 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->priv->readers;
#line 992 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = _tmp7_->developer;
#line 992 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp8_ != NULL) {
#line 8081 "Photo.c"
				PhotoBackingReaders* _tmp9_ = NULL;
				PhotoFileReader* _tmp10_ = NULL;
				PhotoFileReader* _tmp11_ = NULL;
#line 993 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = self->priv->readers;
#line 993 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = _tmp9_->developer;
#line 993 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = _photo_file_adapter_ref0 (_tmp10_);
#line 993 "/home/jens/Source/shotwell/src/Photo.vala"
				result = _tmp11_;
#line 8093 "Photo.c"
				{
					PhotoBackingReaders* _tmp12_ = NULL;
#line 988 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp12_ = self->priv->readers;
#line 988 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8100 "Photo.c"
				}
#line 993 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 8104 "Photo.c"
			}
#line 995 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = self->priv->readers;
#line 995 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = _tmp13_->master;
#line 995 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = _photo_file_adapter_ref0 (_tmp14_);
#line 995 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp15_;
#line 8114 "Photo.c"
			{
				PhotoBackingReaders* _tmp16_ = NULL;
#line 988 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = self->priv->readers;
#line 988 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8121 "Photo.c"
			}
#line 995 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8125 "Photo.c"
		}
		__finally287:
		{
			PhotoBackingReaders* _tmp17_ = NULL;
#line 988 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = self->priv->readers;
#line 988 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8134 "Photo.c"
		}
#line 988 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 988 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 988 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 8142 "Photo.c"
	}
}


static PhotoFileReader* photo_get_raw_developer_reader (Photo* self) {
	PhotoFileReader* result = NULL;
	GError * _inner_error_ = NULL;
#line 1000 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 8152 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
#line 1001 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 1001 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 8159 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
			PhotoFileReader* _tmp3_ = NULL;
#line 1002 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 1002 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->developer;
#line 1002 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _photo_file_adapter_ref0 (_tmp2_);
#line 1002 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 8172 "Photo.c"
			{
				PhotoBackingReaders* _tmp4_ = NULL;
#line 1001 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->priv->readers;
#line 1001 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8179 "Photo.c"
			}
#line 1002 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8183 "Photo.c"
		}
		__finally288:
		{
			PhotoBackingReaders* _tmp5_ = NULL;
#line 1001 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->priv->readers;
#line 1001 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8192 "Photo.c"
		}
#line 1001 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1001 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1001 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 8200 "Photo.c"
	}
}


gboolean photo_is_developed (Photo* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1006 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 8210 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 8218 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
#line 1008 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 1008 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->developer;
#line 1008 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_ != NULL;
#line 8228 "Photo.c"
			{
				PhotoBackingReaders* _tmp3_ = NULL;
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->readers;
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8235 "Photo.c"
			}
#line 1008 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8239 "Photo.c"
		}
		__finally289:
		{
			PhotoBackingReaders* _tmp4_ = NULL;
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->priv->readers;
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8248 "Photo.c"
		}
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1007 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp5_;
#line 8256 "Photo.c"
	}
}


gboolean photo_has_editable (Photo* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1012 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 8266 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 1013 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 1013 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 8274 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
#line 1014 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 1014 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable;
#line 1014 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_ != NULL;
#line 8284 "Photo.c"
			{
				PhotoBackingReaders* _tmp3_ = NULL;
#line 1013 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->readers;
#line 1013 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8291 "Photo.c"
			}
#line 1014 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8295 "Photo.c"
		}
		__finally290:
		{
			PhotoBackingReaders* _tmp4_ = NULL;
#line 1013 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->priv->readers;
#line 1013 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8304 "Photo.c"
		}
#line 1013 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1013 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1013 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp5_;
#line 8312 "Photo.c"
	}
}


gboolean photo_does_master_exist (Photo* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1018 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 8322 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 1019 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 1019 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 8330 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
#line 1020 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 1020 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->master;
#line 1020 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = photo_file_adapter_file_exists (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1020 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 8343 "Photo.c"
			{
				PhotoBackingReaders* _tmp4_ = NULL;
#line 1019 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->priv->readers;
#line 1019 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8350 "Photo.c"
			}
#line 1020 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8354 "Photo.c"
		}
		__finally291:
		{
			PhotoBackingReaders* _tmp5_ = NULL;
#line 1019 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->priv->readers;
#line 1019 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8363 "Photo.c"
		}
#line 1019 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1019 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1019 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp6_;
#line 8371 "Photo.c"
	}
}


gboolean photo_does_editable_exist (Photo* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1025 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 8381 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
		gboolean _tmp9_ = FALSE;
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 8389 "Photo.c"
		{
			gboolean _tmp1_ = FALSE;
			PhotoBackingReaders* _tmp2_ = NULL;
			PhotoFileReader* _tmp3_ = NULL;
#line 1027 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->priv->readers;
#line 1027 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _tmp2_->editable;
#line 1027 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp3_ != NULL) {
#line 8400 "Photo.c"
				PhotoBackingReaders* _tmp4_ = NULL;
				PhotoFileReader* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
#line 1027 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->priv->readers;
#line 1027 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp4_->editable;
#line 1027 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = photo_file_adapter_file_exists (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1027 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = _tmp6_;
#line 8412 "Photo.c"
			} else {
#line 1027 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = FALSE;
#line 8416 "Photo.c"
			}
#line 1027 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp1_;
#line 8420 "Photo.c"
			{
				PhotoBackingReaders* _tmp7_ = NULL;
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = self->priv->readers;
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8427 "Photo.c"
			}
#line 1027 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8431 "Photo.c"
		}
		__finally292:
		{
			PhotoBackingReaders* _tmp8_ = NULL;
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = self->priv->readers;
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8440 "Photo.c"
		}
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1026 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp9_;
#line 8448 "Photo.c"
	}
}


gboolean photo_is_master_baseline (Photo* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1031 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 8458 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 1032 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 1032 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 8466 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
#line 1033 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 1033 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable;
#line 1033 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_ == NULL;
#line 8476 "Photo.c"
			{
				PhotoBackingReaders* _tmp3_ = NULL;
#line 1032 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->readers;
#line 1032 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8483 "Photo.c"
			}
#line 1033 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8487 "Photo.c"
		}
		__finally293:
		{
			PhotoBackingReaders* _tmp4_ = NULL;
#line 1032 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->priv->readers;
#line 1032 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8496 "Photo.c"
		}
#line 1032 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1032 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1032 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp5_;
#line 8504 "Photo.c"
	}
}


gboolean photo_is_master_source (Photo* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 1037 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 1038 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_has_editable (self);
#line 1038 "/home/jens/Source/shotwell/src/Photo.vala"
	result = !_tmp0_;
#line 1038 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 8520 "Photo.c"
}


gboolean photo_is_editable_baseline (Photo* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1041 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 8529 "Photo.c"
	{
		PhotoBackingReaders* _tmp0_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 1042 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->priv->readers;
#line 1042 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_readers);
#line 8537 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
#line 1043 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 1043 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable;
#line 1043 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_ != NULL;
#line 8547 "Photo.c"
			{
				PhotoBackingReaders* _tmp3_ = NULL;
#line 1042 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->readers;
#line 1042 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8554 "Photo.c"
			}
#line 1043 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8558 "Photo.c"
		}
		__finally294:
		{
			PhotoBackingReaders* _tmp4_ = NULL;
#line 1042 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->priv->readers;
#line 1042 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 8567 "Photo.c"
		}
#line 1042 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1042 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1042 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp5_;
#line 8575 "Photo.c"
	}
}


gboolean photo_is_editable_source (Photo* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 1047 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 1048 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_has_editable (self);
#line 1048 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 1048 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 8591 "Photo.c"
}


BackingPhotoRow* photo_get_master_photo_row (Photo* self) {
	BackingPhotoRow* result = NULL;
	GError * _inner_error_ = NULL;
#line 1051 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 8600 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 1052 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 1052 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 8607 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			BackingPhotoRow* _tmp2_ = NULL;
			BackingPhotoRow* _tmp3_ = NULL;
#line 1053 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 1053 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->master;
#line 1053 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _backing_photo_row_ref0 (_tmp2_);
#line 1053 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 8620 "Photo.c"
			{
				PhotoRow* _tmp4_ = NULL;
#line 1052 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 1052 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 8627 "Photo.c"
			}
#line 1053 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8631 "Photo.c"
		}
		__finally295:
		{
			PhotoRow* _tmp5_ = NULL;
#line 1052 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 1052 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 8640 "Photo.c"
		}
#line 1052 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1052 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1052 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 8648 "Photo.c"
	}
}


BackingPhotoRow* photo_get_editable_photo_row (Photo* self) {
	BackingPhotoRow* result = NULL;
	GError * _inner_error_ = NULL;
#line 1057 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 8658 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 1058 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 1058 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 8665 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			gboolean _tmp2_ = FALSE;
#line 1060 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 1060 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = backing_photo_id_is_valid (&_tmp1_->editable_id);
#line 1060 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_) {
#line 8675 "Photo.c"
				BackingPhotoRow* _tmp3_ = NULL;
				BackingPhotoRow* _tmp4_ = NULL;
#line 1061 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->editable;
#line 1061 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _backing_photo_row_ref0 (_tmp3_);
#line 1061 "/home/jens/Source/shotwell/src/Photo.vala"
				result = _tmp4_;
#line 8684 "Photo.c"
				{
					PhotoRow* _tmp5_ = NULL;
#line 1058 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp5_ = self->row;
#line 1058 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_row);
#line 8691 "Photo.c"
				}
#line 1061 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 8695 "Photo.c"
			} else {
#line 1063 "/home/jens/Source/shotwell/src/Photo.vala"
				result = NULL;
#line 8699 "Photo.c"
				{
					PhotoRow* _tmp6_ = NULL;
#line 1058 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp6_ = self->row;
#line 1058 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_row);
#line 8706 "Photo.c"
				}
#line 1063 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 8710 "Photo.c"
			}
		}
		__finally296:
		{
			PhotoRow* _tmp7_ = NULL;
#line 1058 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->row;
#line 1058 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 8720 "Photo.c"
		}
#line 1058 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1058 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1058 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 8728 "Photo.c"
	}
}


GeeCollection* photo_get_raw_development_photo_rows (Photo* self) {
	GeeCollection* result = NULL;
	GError * _inner_error_ = NULL;
#line 1067 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 8738 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 1068 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 1068 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 8745 "Photo.c"
		{
			GeeCollection* _tmp1_ = NULL;
			GeeHashMap* _tmp2_ = NULL;
#line 1069 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->priv->developments;
#line 1069 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 8753 "Photo.c"
				GeeHashMap* _tmp3_ = NULL;
				GeeCollection* _tmp4_ = NULL;
				GeeCollection* _tmp5_ = NULL;
#line 1069 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->developments;
#line 1069 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 1069 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp4_;
#line 1069 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_tmp1_);
#line 1069 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = _tmp5_;
#line 8767 "Photo.c"
			} else {
#line 1069 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_tmp1_);
#line 1069 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = NULL;
#line 8773 "Photo.c"
			}
#line 1069 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp1_;
#line 8777 "Photo.c"
			{
				PhotoRow* _tmp6_ = NULL;
#line 1068 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = self->row;
#line 1068 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 8784 "Photo.c"
			}
#line 1069 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8788 "Photo.c"
		}
		__finally297:
		{
			PhotoRow* _tmp7_ = NULL;
#line 1068 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->row;
#line 1068 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 8797 "Photo.c"
		}
#line 1068 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1068 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1068 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 8805 "Photo.c"
	}
}


BackingPhotoRow* photo_get_raw_development_photo_row (Photo* self, RawDeveloper d) {
	BackingPhotoRow* result = NULL;
	GError * _inner_error_ = NULL;
#line 1073 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 8815 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 1074 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 1074 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 8822 "Photo.c"
		{
			BackingPhotoRow* _tmp1_ = NULL;
			GeeHashMap* _tmp2_ = NULL;
#line 1075 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->priv->developments;
#line 1075 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 8830 "Photo.c"
				GeeHashMap* _tmp3_ = NULL;
				RawDeveloper _tmp4_ = 0;
				gpointer _tmp5_ = NULL;
#line 1075 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->developments;
#line 1075 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = d;
#line 1075 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp4_));
#line 1075 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (_tmp1_);
#line 1075 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = (BackingPhotoRow*) _tmp5_;
#line 8844 "Photo.c"
			} else {
#line 1075 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (_tmp1_);
#line 1075 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = NULL;
#line 8850 "Photo.c"
			}
#line 1075 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp1_;
#line 8854 "Photo.c"
			{
				PhotoRow* _tmp6_ = NULL;
#line 1074 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = self->row;
#line 1074 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 8861 "Photo.c"
			}
#line 1075 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 8865 "Photo.c"
		}
		__finally298:
		{
			PhotoRow* _tmp7_ = NULL;
#line 1074 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->row;
#line 1074 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 8874 "Photo.c"
		}
#line 1074 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1074 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1074 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 8882 "Photo.c"
	}
}


static PhotoFileFormat* _photo_file_format_dup (PhotoFileFormat* self) {
	PhotoFileFormat* dup;
#line 1085 "/home/jens/Source/shotwell/src/Photo.vala"
	dup = g_new0 (PhotoFileFormat, 1);
#line 1085 "/home/jens/Source/shotwell/src/Photo.vala"
	memcpy (dup, self, sizeof (PhotoFileFormat));
#line 1085 "/home/jens/Source/shotwell/src/Photo.vala"
	return dup;
#line 8895 "Photo.c"
}


static gpointer __photo_file_format_dup0 (gpointer self) {
#line 1085 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? _photo_file_format_dup (self) : NULL;
#line 8902 "Photo.c"
}


PhotoFileFormat* photo_get_editable_file_format (Photo* self) {
	PhotoFileFormat* result = NULL;
	PhotoFileReader* reader = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	PhotoFileReader* _tmp2_ = NULL;
	PhotoFileFormat _tmp3_ = 0;
	PhotoFileFormat* _tmp4_ = NULL;
#line 1079 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 1080 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_editable_reader (self);
#line 1080 "/home/jens/Source/shotwell/src/Photo.vala"
	reader = _tmp0_;
#line 1081 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = reader;
#line 1081 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 1082 "/home/jens/Source/shotwell/src/Photo.vala"
		result = NULL;
#line 1082 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (reader);
#line 1082 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 8930 "Photo.c"
	}
#line 1085 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = reader;
#line 1085 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1085 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = __photo_file_format_dup0 (&_tmp3_);
#line 1085 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp4_;
#line 1085 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (reader);
#line 1085 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 8944 "Photo.c"
}


PhotoFileFormat photo_get_export_format_for_parameters (Photo* self, ExportFormatParameters* params) {
	PhotoFileFormat result = 0;
	PhotoFileFormat _result_ = 0;
	PhotoFileFormat _tmp0_ = 0;
	ExportFormatParameters _tmp1_ = {0};
	ExportFormatMode _tmp2_ = 0;
#line 1088 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0);
#line 1088 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (params != NULL, 0);
#line 1089 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_file_format_get_system_default_format ();
#line 1089 "/home/jens/Source/shotwell/src/Photo.vala"
	_result_ = _tmp0_;
#line 1091 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = *params;
#line 1091 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = _tmp1_.mode;
#line 1091 "/home/jens/Source/shotwell/src/Photo.vala"
	switch (_tmp2_) {
#line 1091 "/home/jens/Source/shotwell/src/Photo.vala"
		case EXPORT_FORMAT_MODE_UNMODIFIED:
#line 8970 "Photo.c"
		{
			PhotoFileFormat _tmp3_ = 0;
#line 1093 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = photo_get_master_file_format (self);
#line 1093 "/home/jens/Source/shotwell/src/Photo.vala"
			_result_ = _tmp3_;
#line 1094 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 8979 "Photo.c"
		}
#line 1091 "/home/jens/Source/shotwell/src/Photo.vala"
		case EXPORT_FORMAT_MODE_CURRENT:
#line 8983 "Photo.c"
		{
			PhotoFileFormat _tmp4_ = 0;
#line 1097 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = photo_get_best_export_file_format (self);
#line 1097 "/home/jens/Source/shotwell/src/Photo.vala"
			_result_ = _tmp4_;
#line 1098 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 8992 "Photo.c"
		}
#line 1091 "/home/jens/Source/shotwell/src/Photo.vala"
		case EXPORT_FORMAT_MODE_SPECIFIED:
#line 8996 "Photo.c"
		{
			ExportFormatParameters _tmp5_ = {0};
			PhotoFileFormat _tmp6_ = 0;
#line 1101 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = *params;
#line 1101 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _tmp5_.specified_format;
#line 1101 "/home/jens/Source/shotwell/src/Photo.vala"
			_result_ = _tmp6_;
#line 1102 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 9008 "Photo.c"
		}
		default:
		{
#line 1105 "/home/jens/Source/shotwell/src/Photo.vala"
			g_error ("Photo.vala:1105: get_export_format_for_parameters: unsupported export " \
"format mode");
#line 9014 "Photo.c"
		}
	}
#line 1108 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _result_;
#line 1108 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 9021 "Photo.c"
}


gchar* photo_get_export_basename_for_parameters (Photo* self, ExportFormatParameters* params) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	ExportFormatParameters _tmp0_ = {0};
	ExportFormatMode _tmp1_ = 0;
	const gchar* _tmp8_ = NULL;
#line 1111 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 1111 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (params != NULL, NULL);
#line 1112 "/home/jens/Source/shotwell/src/Photo.vala"
	_result_ = NULL;
#line 1114 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = *params;
#line 1114 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_.mode;
#line 1114 "/home/jens/Source/shotwell/src/Photo.vala"
	switch (_tmp1_) {
#line 1114 "/home/jens/Source/shotwell/src/Photo.vala"
		case EXPORT_FORMAT_MODE_UNMODIFIED:
#line 9045 "Photo.c"
		{
			GFile* _tmp2_ = NULL;
			GFile* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
#line 1116 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 1116 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _tmp2_;
#line 1116 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = g_file_get_basename (_tmp3_);
#line 1116 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (_result_);
#line 1116 "/home/jens/Source/shotwell/src/Photo.vala"
			_result_ = _tmp4_;
#line 1116 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (_tmp3_);
#line 1117 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 9064 "Photo.c"
		}
#line 1114 "/home/jens/Source/shotwell/src/Photo.vala"
		case EXPORT_FORMAT_MODE_CURRENT:
#line 1114 "/home/jens/Source/shotwell/src/Photo.vala"
		case EXPORT_FORMAT_MODE_SPECIFIED:
#line 9070 "Photo.c"
		{
			ExportFormatParameters _tmp5_ = {0};
			PhotoFileFormat _tmp6_ = 0;
			gchar* _tmp7_ = NULL;
#line 1121 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = *params;
#line 1121 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = photo_get_export_format_for_parameters (self, &_tmp5_);
#line 1121 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = photo_get_export_basename (self, &_tmp6_);
#line 1121 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp7_;
#line 1121 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (_result_);
#line 1121 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 9087 "Photo.c"
		}
		default:
		{
#line 1124 "/home/jens/Source/shotwell/src/Photo.vala"
			g_error ("Photo.vala:1124: get_export_basename_for_parameters: unsupported expor" \
"t format mode");
#line 9093 "Photo.c"
		}
	}
#line 1127 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = _result_;
#line 1127 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_assert (_tmp8_ != NULL, "result != null");
#line 1128 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _result_;
#line 1128 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 9104 "Photo.c"
}


ImportResult photo_prepare_for_import (PhotoImportParams* params) {
	ImportResult result = 0;
	GFile* file = NULL;
	PhotoImportParams* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFileInfo* info = NULL;
	GFileInfo* _tmp7_ = NULL;
	GFileType _tmp8_ = 0;
	GFile* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GFile* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	GTimeVal timestamp = {0};
	GFileInfo* _tmp19_ = NULL;
	GTimeVal _tmp20_ = {0};
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	PhotoImportParams* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	PhotoFileInterrogator* interrogator = NULL;
	GFile* _tmp32_ = NULL;
	PhotoImportParams* _tmp33_ = NULL;
	PhotoFileSnifferOptions _tmp34_ = 0;
	PhotoFileInterrogator* _tmp35_ = NULL;
	PhotoFileInterrogator* _tmp42_ = NULL;
	gboolean _tmp43_ = FALSE;
	DetectedPhotoInformation* detected = NULL;
	PhotoFileInterrogator* _tmp44_ = NULL;
	DetectedPhotoInformation* _tmp45_ = NULL;
	gboolean _tmp46_ = FALSE;
	DetectedPhotoInformation* _tmp47_ = NULL;
	PhotoImportParams* _tmp50_ = NULL;
	PhotoFileSnifferOptions _tmp51_ = 0;
	Orientation orientation = 0;
	time_t exposure_time = 0;
	gchar* title = NULL;
	gchar* _tmp64_ = NULL;
	gchar* comment = NULL;
	gchar* _tmp65_ = NULL;
	Rating rating = 0;
	DetectedPhotoInformation* _tmp66_ = NULL;
	PhotoMetadata* _tmp67_ = NULL;
	gboolean _tmp90_ = FALSE;
	gboolean _tmp91_ = FALSE;
	DetectedPhotoInformation* _tmp92_ = NULL;
	GdkColorspace _tmp93_ = 0;
	PhotoImportParams* _tmp101_ = NULL;
	PhotoRow* _tmp102_ = NULL;
	PhotoImportParams* _tmp103_ = NULL;
	PhotoRow* _tmp104_ = NULL;
	BackingPhotoRow* _tmp105_ = NULL;
	GFile* _tmp106_ = NULL;
	gchar* _tmp107_ = NULL;
	PhotoImportParams* _tmp108_ = NULL;
	PhotoRow* _tmp109_ = NULL;
	BackingPhotoRow* _tmp110_ = NULL;
	DetectedPhotoInformation* _tmp111_ = NULL;
	Dimensions _tmp112_ = {0};
	PhotoImportParams* _tmp113_ = NULL;
	PhotoRow* _tmp114_ = NULL;
	BackingPhotoRow* _tmp115_ = NULL;
	GFileInfo* _tmp116_ = NULL;
	gint64 _tmp117_ = 0LL;
	PhotoImportParams* _tmp118_ = NULL;
	PhotoRow* _tmp119_ = NULL;
	BackingPhotoRow* _tmp120_ = NULL;
	GTimeVal _tmp121_ = {0};
	glong _tmp122_ = 0L;
	PhotoImportParams* _tmp123_ = NULL;
	PhotoRow* _tmp124_ = NULL;
	time_t _tmp125_ = 0;
	PhotoImportParams* _tmp126_ = NULL;
	PhotoRow* _tmp127_ = NULL;
	Orientation _tmp128_ = 0;
	PhotoImportParams* _tmp129_ = NULL;
	PhotoRow* _tmp130_ = NULL;
	BackingPhotoRow* _tmp131_ = NULL;
	Orientation _tmp132_ = 0;
	PhotoImportParams* _tmp133_ = NULL;
	PhotoRow* _tmp134_ = NULL;
	PhotoImportParams* _tmp135_ = NULL;
	ImportID _tmp136_ = {0};
	PhotoImportParams* _tmp137_ = NULL;
	PhotoRow* _tmp138_ = NULL;
	PhotoImportParams* _tmp139_ = NULL;
	PhotoRow* _tmp140_ = NULL;
	PhotoImportParams* _tmp141_ = NULL;
	PhotoRow* _tmp142_ = NULL;
	DetectedPhotoInformation* _tmp143_ = NULL;
	const gchar* _tmp144_ = NULL;
	gchar* _tmp145_ = NULL;
	PhotoImportParams* _tmp146_ = NULL;
	PhotoRow* _tmp147_ = NULL;
	DetectedPhotoInformation* _tmp148_ = NULL;
	const gchar* _tmp149_ = NULL;
	gchar* _tmp150_ = NULL;
	PhotoImportParams* _tmp151_ = NULL;
	PhotoRow* _tmp152_ = NULL;
	DetectedPhotoInformation* _tmp153_ = NULL;
	const gchar* _tmp154_ = NULL;
	gchar* _tmp155_ = NULL;
	PhotoImportParams* _tmp156_ = NULL;
	PhotoRow* _tmp157_ = NULL;
	PhotoImportParams* _tmp158_ = NULL;
	PhotoRow* _tmp159_ = NULL;
	PhotoImportParams* _tmp160_ = NULL;
	PhotoRow* _tmp161_ = NULL;
	BackingPhotoRow* _tmp162_ = NULL;
	DetectedPhotoInformation* _tmp163_ = NULL;
	PhotoFileFormat _tmp164_ = 0;
	PhotoImportParams* _tmp165_ = NULL;
	PhotoRow* _tmp166_ = NULL;
	const gchar* _tmp167_ = NULL;
	gchar* _tmp168_ = NULL;
	PhotoImportParams* _tmp169_ = NULL;
	PhotoRow* _tmp170_ = NULL;
	const gchar* _tmp171_ = NULL;
	gchar* _tmp172_ = NULL;
	PhotoImportParams* _tmp173_ = NULL;
	PhotoRow* _tmp174_ = NULL;
	Rating _tmp175_ = 0;
	PhotoImportParams* _tmp176_ = NULL;
	Thumbnails* _tmp177_ = NULL;
	GError * _inner_error_ = NULL;
#line 1143 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO_IMPORT_PARAMS (params), 0);
#line 1147 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = params;
#line 1147 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_->file;
#line 1147 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 1147 "/home/jens/Source/shotwell/src/Photo.vala"
	file = _tmp2_;
#line 1149 "/home/jens/Source/shotwell/src/Photo.vala"
	info = NULL;
#line 9245 "Photo.c"
	{
		GFileInfo* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		GFileInfo* _tmp5_ = NULL;
		GFileInfo* _tmp6_ = NULL;
#line 1151 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = file;
#line 1151 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = g_file_query_info (_tmp4_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
#line 1151 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = _tmp5_;
#line 1151 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9259 "Photo.c"
			goto __catch299_g_error;
		}
#line 1151 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = _tmp3_;
#line 1151 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = NULL;
#line 1151 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1151 "/home/jens/Source/shotwell/src/Photo.vala"
		info = _tmp6_;
#line 1150 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp3_);
#line 9272 "Photo.c"
	}
	goto __finally299;
	__catch299_g_error:
	{
		GError* err = NULL;
#line 1150 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 1150 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 1154 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_FILE_ERROR;
#line 1154 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 1154 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1154 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1154 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 9292 "Photo.c"
	}
	__finally299:
#line 1150 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1150 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1150 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1150 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1150 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1150 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0;
#line 9307 "Photo.c"
	}
#line 1157 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = info;
#line 1157 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = g_file_info_get_file_type (_tmp7_);
#line 1157 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp8_ != G_FILE_TYPE_REGULAR) {
#line 1158 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_NOT_A_FILE;
#line 1158 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1158 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1158 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 9323 "Photo.c"
	}
#line 1160 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = file;
#line 1160 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = photo_is_file_image (_tmp9_);
#line 1160 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp10_) {
#line 9331 "Photo.c"
		GFile* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
#line 1161 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = file;
#line 1161 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = g_file_get_path (_tmp11_);
#line 1161 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = _tmp12_;
#line 1161 "/home/jens/Source/shotwell/src/Photo.vala"
		g_message ("Photo.vala:1161: Not importing %s: Not an image file", _tmp13_);
#line 1161 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp13_);
#line 1163 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_NOT_AN_IMAGE;
#line 1163 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1163 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1163 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 9353 "Photo.c"
	}
#line 1166 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = file;
#line 1166 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = photo_file_format_is_file_supported (_tmp14_);
#line 1166 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp15_) {
#line 9361 "Photo.c"
		GFile* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
#line 1167 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = file;
#line 1167 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = g_file_get_path (_tmp16_);
#line 1167 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = _tmp17_;
#line 1167 "/home/jens/Source/shotwell/src/Photo.vala"
		g_message ("Photo.vala:1167: Not importing %s: Unsupported extension", _tmp18_);
#line 1167 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp18_);
#line 1169 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_UNSUPPORTED_FORMAT;
#line 1169 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1169 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1169 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 9383 "Photo.c"
	}
#line 1172 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = info;
#line 1172 "/home/jens/Source/shotwell/src/Photo.vala"
	g_file_info_get_modification_time (_tmp19_, &_tmp20_);
#line 1172 "/home/jens/Source/shotwell/src/Photo.vala"
	timestamp = _tmp20_;
#line 1175 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp23_ = params;
#line 1175 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp24_ = _tmp23_->exif_md5;
#line 1175 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp24_ != NULL) {
#line 9397 "Photo.c"
		PhotoImportParams* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
#line 1175 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp25_ = params;
#line 1175 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp26_ = _tmp25_->thumbnail_md5;
#line 1175 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = _tmp26_ != NULL;
#line 9406 "Photo.c"
	} else {
#line 1175 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = FALSE;
#line 9410 "Photo.c"
	}
#line 1175 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp22_) {
#line 9414 "Photo.c"
		PhotoImportParams* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
#line 1175 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp27_ = params;
#line 1175 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp28_ = _tmp27_->full_md5;
#line 1175 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = _tmp28_ != NULL;
#line 9423 "Photo.c"
	} else {
#line 1175 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = FALSE;
#line 9427 "Photo.c"
	}
#line 1175 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp21_) {
#line 9431 "Photo.c"
		PhotoImportParams* _tmp29_ = NULL;
		PhotoImportParams* _tmp30_ = NULL;
		PhotoFileSnifferOptions _tmp31_ = 0;
#line 1176 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp29_ = params;
#line 1176 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp30_ = params;
#line 1176 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp31_ = _tmp30_->sniffer_options;
#line 1176 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp30_->sniffer_options = _tmp31_ | PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5;
#line 9443 "Photo.c"
	}
#line 1179 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp32_ = file;
#line 1179 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp33_ = params;
#line 1179 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp34_ = _tmp33_->sniffer_options;
#line 1179 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp35_ = photo_file_interrogator_new (_tmp32_, _tmp34_);
#line 1179 "/home/jens/Source/shotwell/src/Photo.vala"
	interrogator = _tmp35_;
#line 9455 "Photo.c"
	{
		PhotoFileInterrogator* _tmp36_ = NULL;
#line 1181 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp36_ = interrogator;
#line 1181 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_file_interrogator_interrogate (_tmp36_, &_inner_error_);
#line 1181 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9464 "Photo.c"
			goto __catch300_g_error;
		}
	}
	goto __finally300;
	__catch300_g_error:
	{
		GError* err = NULL;
		GFile* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		GError* _tmp40_ = NULL;
		const gchar* _tmp41_ = NULL;
#line 1180 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 1180 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 1183 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp37_ = file;
#line 1183 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp38_ = g_file_get_path (_tmp37_);
#line 1183 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp39_ = _tmp38_;
#line 1183 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp40_ = err;
#line 1183 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp41_ = _tmp40_->message;
#line 1183 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:1183: Unable to interrogate photo file %s: %s", _tmp39_, _tmp41_);
#line 1183 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp39_);
#line 1185 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_DECODE_ERROR;
#line 1185 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 1185 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1185 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1185 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1185 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 9507 "Photo.c"
	}
	__finally300:
#line 1180 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1180 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1180 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1180 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1180 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1180 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1180 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0;
#line 9524 "Photo.c"
	}
#line 1188 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp42_ = interrogator;
#line 1188 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp43_ = photo_file_interrogator_get_is_photo_corrupted (_tmp42_);
#line 1188 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp43_) {
#line 1189 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_NOT_AN_IMAGE;
#line 1189 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1189 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1189 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1189 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 9542 "Photo.c"
	}
#line 1192 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp44_ = interrogator;
#line 1192 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp45_ = photo_file_interrogator_get_detected_photo_information (_tmp44_);
#line 1192 "/home/jens/Source/shotwell/src/Photo.vala"
	detected = _tmp45_;
#line 1193 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp47_ = detected;
#line 1193 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp47_ == NULL) {
#line 1193 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp46_ = TRUE;
#line 9556 "Photo.c"
	} else {
		DetectedPhotoInformation* _tmp48_ = NULL;
		PhotoFileFormat _tmp49_ = 0;
#line 1193 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp48_ = detected;
#line 1193 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp49_ = _tmp48_->file_format;
#line 1193 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp46_ = _tmp49_ == PHOTO_FILE_FORMAT_UNKNOWN;
#line 9566 "Photo.c"
	}
#line 1193 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp46_) {
#line 1194 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_UNSUPPORTED_FORMAT;
#line 1194 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 1194 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1194 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1194 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1194 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 9582 "Photo.c"
	}
#line 1197 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp50_ = params;
#line 1197 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp51_ = _tmp50_->sniffer_options;
#line 1197 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((_tmp51_ & PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5) != 0) {
#line 9590 "Photo.c"
		DetectedPhotoInformation* _tmp52_ = NULL;
		PhotoImportParams* _tmp53_ = NULL;
		const gchar* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		DetectedPhotoInformation* _tmp56_ = NULL;
		PhotoImportParams* _tmp57_ = NULL;
		const gchar* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
		DetectedPhotoInformation* _tmp60_ = NULL;
		PhotoImportParams* _tmp61_ = NULL;
		const gchar* _tmp62_ = NULL;
		gchar* _tmp63_ = NULL;
#line 1198 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp52_ = detected;
#line 1198 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp53_ = params;
#line 1198 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp54_ = _tmp53_->exif_md5;
#line 1198 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp55_ = g_strdup (_tmp54_);
#line 1198 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp52_->exif_md5);
#line 1198 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp52_->exif_md5 = _tmp55_;
#line 1199 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp56_ = detected;
#line 1199 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp57_ = params;
#line 1199 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp58_ = _tmp57_->thumbnail_md5;
#line 1199 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp59_ = g_strdup (_tmp58_);
#line 1199 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp56_->thumbnail_md5);
#line 1199 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp56_->thumbnail_md5 = _tmp59_;
#line 1200 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp60_ = detected;
#line 1200 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp61_ = params;
#line 1200 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp62_ = _tmp61_->full_md5;
#line 1200 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp63_ = g_strdup (_tmp62_);
#line 1200 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp60_->md5);
#line 1200 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp60_->md5 = _tmp63_;
#line 9639 "Photo.c"
	}
#line 1203 "/home/jens/Source/shotwell/src/Photo.vala"
	orientation = ORIENTATION_TOP_LEFT;
#line 1204 "/home/jens/Source/shotwell/src/Photo.vala"
	exposure_time = (time_t) 0;
#line 1205 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp64_ = g_strdup ("");
#line 1205 "/home/jens/Source/shotwell/src/Photo.vala"
	title = _tmp64_;
#line 1206 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp65_ = g_strdup ("");
#line 1206 "/home/jens/Source/shotwell/src/Photo.vala"
	comment = _tmp65_;
#line 1207 "/home/jens/Source/shotwell/src/Photo.vala"
	rating = RATING_UNRATED;
#line 1214 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp66_ = detected;
#line 1214 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp67_ = _tmp66_->metadata;
#line 1214 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp67_ != NULL) {
#line 9661 "Photo.c"
		MetadataDateTime* date_time = NULL;
		DetectedPhotoInformation* _tmp68_ = NULL;
		PhotoMetadata* _tmp69_ = NULL;
		MetadataDateTime* _tmp70_ = NULL;
		MetadataDateTime* _tmp71_ = NULL;
		DetectedPhotoInformation* _tmp74_ = NULL;
		PhotoMetadata* _tmp75_ = NULL;
		Orientation _tmp76_ = 0;
		DetectedPhotoInformation* _tmp77_ = NULL;
		PhotoMetadata* _tmp78_ = NULL;
		gchar* _tmp79_ = NULL;
		DetectedPhotoInformation* _tmp80_ = NULL;
		PhotoMetadata* _tmp81_ = NULL;
		gchar* _tmp82_ = NULL;
		PhotoImportParams* _tmp83_ = NULL;
		DetectedPhotoInformation* _tmp84_ = NULL;
		PhotoMetadata* _tmp85_ = NULL;
		GeeSet* _tmp86_ = NULL;
		DetectedPhotoInformation* _tmp87_ = NULL;
		PhotoMetadata* _tmp88_ = NULL;
		Rating _tmp89_ = 0;
#line 1215 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp68_ = detected;
#line 1215 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp69_ = _tmp68_->metadata;
#line 1215 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp70_ = photo_metadata_get_exposure_date_time (_tmp69_);
#line 1215 "/home/jens/Source/shotwell/src/Photo.vala"
		date_time = _tmp70_;
#line 1216 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp71_ = date_time;
#line 1216 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp71_ != NULL) {
#line 9695 "Photo.c"
			MetadataDateTime* _tmp72_ = NULL;
			time_t _tmp73_ = 0;
#line 1217 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp72_ = date_time;
#line 1217 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp73_ = metadata_date_time_get_timestamp (_tmp72_);
#line 1217 "/home/jens/Source/shotwell/src/Photo.vala"
			exposure_time = _tmp73_;
#line 9704 "Photo.c"
		}
#line 1219 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp74_ = detected;
#line 1219 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp75_ = _tmp74_->metadata;
#line 1219 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp76_ = photo_metadata_get_orientation (_tmp75_);
#line 1219 "/home/jens/Source/shotwell/src/Photo.vala"
		orientation = _tmp76_;
#line 1220 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp77_ = detected;
#line 1220 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp78_ = _tmp77_->metadata;
#line 1220 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp79_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1220 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (title);
#line 1220 "/home/jens/Source/shotwell/src/Photo.vala"
		title = _tmp79_;
#line 1221 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp80_ = detected;
#line 1221 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp81_ = _tmp80_->metadata;
#line 1221 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp82_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1221 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (comment);
#line 1221 "/home/jens/Source/shotwell/src/Photo.vala"
		comment = _tmp82_;
#line 1222 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp83_ = params;
#line 1222 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp84_ = detected;
#line 1222 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp85_ = _tmp84_->metadata;
#line 1222 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp86_ = photo_metadata_get_keywords (_tmp85_, NULL, NULL, NULL);
#line 1222 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp83_->keywords);
#line 1222 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp83_->keywords = G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, GEE_TYPE_COLLECTION, GeeCollection);
#line 1223 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp87_ = detected;
#line 1223 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp88_ = _tmp87_->metadata;
#line 1223 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp89_ = photo_metadata_get_rating (_tmp88_);
#line 1223 "/home/jens/Source/shotwell/src/Photo.vala"
		rating = _tmp89_;
#line 1214 "/home/jens/Source/shotwell/src/Photo.vala"
		_metadata_date_time_unref0 (date_time);
#line 9756 "Photo.c"
	}
#line 1227 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp92_ = detected;
#line 1227 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp93_ = _tmp92_->colorspace;
#line 1227 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp93_ != GDK_COLORSPACE_RGB) {
#line 1227 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp91_ = TRUE;
#line 9766 "Photo.c"
	} else {
		DetectedPhotoInformation* _tmp94_ = NULL;
		gint _tmp95_ = 0;
#line 1228 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp94_ = detected;
#line 1228 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp95_ = _tmp94_->channels;
#line 1228 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp91_ = _tmp95_ < 3;
#line 9776 "Photo.c"
	}
#line 1227 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp91_) {
#line 1227 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp90_ = TRUE;
#line 9782 "Photo.c"
	} else {
		DetectedPhotoInformation* _tmp96_ = NULL;
		gint _tmp97_ = 0;
#line 1229 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp96_ = detected;
#line 1229 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp97_ = _tmp96_->bits_per_channel;
#line 1229 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp90_ = _tmp97_ != 8;
#line 9792 "Photo.c"
	}
#line 1227 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp90_) {
#line 9796 "Photo.c"
		GFile* _tmp98_ = NULL;
		gchar* _tmp99_ = NULL;
		gchar* _tmp100_ = NULL;
#line 1230 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp98_ = file;
#line 1230 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp99_ = g_file_get_path (_tmp98_);
#line 1230 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp100_ = _tmp99_;
#line 1230 "/home/jens/Source/shotwell/src/Photo.vala"
		g_message ("Photo.vala:1230: Not importing %s: Unsupported color format", _tmp100_);
#line 1230 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp100_);
#line 1232 "/home/jens/Source/shotwell/src/Photo.vala"
		result = IMPORT_RESULT_UNSUPPORTED_FORMAT;
#line 1232 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (comment);
#line 1232 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (title);
#line 1232 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 1232 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1232 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1232 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1232 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 9826 "Photo.c"
	}
#line 1238 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp101_ = params;
#line 1238 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp102_ = _tmp101_->row;
#line 1238 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_id_init (&_tmp102_->photo_id, PHOTO_ID_INVALID);
#line 1239 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp103_ = params;
#line 1239 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp104_ = _tmp103_->row;
#line 1239 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp105_ = _tmp104_->master;
#line 1239 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp106_ = file;
#line 1239 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp107_ = g_file_get_path (_tmp106_);
#line 1239 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp105_->filepath);
#line 1239 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp105_->filepath = _tmp107_;
#line 1240 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp108_ = params;
#line 1240 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp109_ = _tmp108_->row;
#line 1240 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp110_ = _tmp109_->master;
#line 1240 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp111_ = detected;
#line 1240 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp112_ = _tmp111_->image_dim;
#line 1240 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp110_->dim = _tmp112_;
#line 1241 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp113_ = params;
#line 1241 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp114_ = _tmp113_->row;
#line 1241 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp115_ = _tmp114_->master;
#line 1241 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp116_ = info;
#line 1241 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp117_ = g_file_info_get_size (_tmp116_);
#line 1241 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp115_->filesize = _tmp117_;
#line 1242 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp118_ = params;
#line 1242 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp119_ = _tmp118_->row;
#line 1242 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp120_ = _tmp119_->master;
#line 1242 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp121_ = timestamp;
#line 1242 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp122_ = _tmp121_.tv_sec;
#line 1242 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp120_->timestamp = (time_t) _tmp122_;
#line 1243 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp123_ = params;
#line 1243 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp124_ = _tmp123_->row;
#line 1243 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp125_ = exposure_time;
#line 1243 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp124_->exposure_time = _tmp125_;
#line 1244 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp126_ = params;
#line 1244 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp127_ = _tmp126_->row;
#line 1244 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp128_ = orientation;
#line 1244 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp127_->orientation = _tmp128_;
#line 1245 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp129_ = params;
#line 1245 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp130_ = _tmp129_->row;
#line 1245 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp131_ = _tmp130_->master;
#line 1245 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp132_ = orientation;
#line 1245 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp131_->original_orientation = _tmp132_;
#line 1246 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp133_ = params;
#line 1246 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp134_ = _tmp133_->row;
#line 1246 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp135_ = params;
#line 1246 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp136_ = _tmp135_->import_id;
#line 1246 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp134_->import_id = _tmp136_;
#line 1247 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp137_ = params;
#line 1247 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp138_ = _tmp137_->row;
#line 1247 "/home/jens/Source/shotwell/src/Photo.vala"
	event_id_init (&_tmp138_->event_id, EVENT_ID_INVALID);
#line 1248 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp139_ = params;
#line 1248 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp140_ = _tmp139_->row;
#line 1248 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp140_->transformations);
#line 1248 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp140_->transformations = NULL;
#line 1249 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp141_ = params;
#line 1249 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp142_ = _tmp141_->row;
#line 1249 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp143_ = detected;
#line 1249 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp144_ = _tmp143_->md5;
#line 1249 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp145_ = g_strdup (_tmp144_);
#line 1249 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp142_->md5);
#line 1249 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp142_->md5 = _tmp145_;
#line 1250 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp146_ = params;
#line 1250 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp147_ = _tmp146_->row;
#line 1250 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp148_ = detected;
#line 1250 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp149_ = _tmp148_->thumbnail_md5;
#line 1250 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp150_ = g_strdup (_tmp149_);
#line 1250 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp147_->thumbnail_md5);
#line 1250 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp147_->thumbnail_md5 = _tmp150_;
#line 1251 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp151_ = params;
#line 1251 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp152_ = _tmp151_->row;
#line 1251 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp153_ = detected;
#line 1251 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp154_ = _tmp153_->exif_md5;
#line 1251 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp155_ = g_strdup (_tmp154_);
#line 1251 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp152_->exif_md5);
#line 1251 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp152_->exif_md5 = _tmp155_;
#line 1252 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp156_ = params;
#line 1252 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp157_ = _tmp156_->row;
#line 1252 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp157_->time_created = (time_t) 0;
#line 1253 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp158_ = params;
#line 1253 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp159_ = _tmp158_->row;
#line 1253 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp159_->flags = (guint64) 0;
#line 1254 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp160_ = params;
#line 1254 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp161_ = _tmp160_->row;
#line 1254 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp162_ = _tmp161_->master;
#line 1254 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp163_ = detected;
#line 1254 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp164_ = _tmp163_->file_format;
#line 1254 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp162_->file_format = _tmp164_;
#line 1255 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp165_ = params;
#line 1255 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp166_ = _tmp165_->row;
#line 1255 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp167_ = title;
#line 1255 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp168_ = g_strdup (_tmp167_);
#line 1255 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp166_->title);
#line 1255 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp166_->title = _tmp168_;
#line 1256 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp169_ = params;
#line 1256 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp170_ = _tmp169_->row;
#line 1256 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp171_ = comment;
#line 1256 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp172_ = g_strdup (_tmp171_);
#line 1256 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp170_->comment);
#line 1256 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp170_->comment = _tmp172_;
#line 1257 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp173_ = params;
#line 1257 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp174_ = _tmp173_->row;
#line 1257 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp175_ = rating;
#line 1257 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp174_->rating = _tmp175_;
#line 1259 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp176_ = params;
#line 1259 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp177_ = _tmp176_->thumbnails;
#line 1259 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp177_ != NULL) {
#line 10038 "Photo.c"
		PhotoFileReader* reader = NULL;
		PhotoImportParams* _tmp178_ = NULL;
		PhotoRow* _tmp179_ = NULL;
		BackingPhotoRow* _tmp180_ = NULL;
		PhotoFileFormat _tmp181_ = 0;
		PhotoImportParams* _tmp182_ = NULL;
		PhotoRow* _tmp183_ = NULL;
		BackingPhotoRow* _tmp184_ = NULL;
		const gchar* _tmp185_ = NULL;
		PhotoFileReader* _tmp186_ = NULL;
		PhotoFileReader* _tmp187_ = NULL;
#line 1260 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp178_ = params;
#line 1260 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp179_ = _tmp178_->row;
#line 1260 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp180_ = _tmp179_->master;
#line 1260 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp181_ = _tmp180_->file_format;
#line 1260 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp182_ = params;
#line 1260 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp183_ = _tmp182_->row;
#line 1260 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp184_ = _tmp183_->master;
#line 1260 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp185_ = _tmp184_->filepath;
#line 1260 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp186_ = photo_file_format_create_reader (_tmp181_, _tmp185_);
#line 1260 "/home/jens/Source/shotwell/src/Photo.vala"
		reader = _tmp186_;
#line 1262 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp187_ = reader;
#line 1262 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_file_reader_set_role (_tmp187_, PHOTO_FILE_READER_ROLE_THUMBNAIL);
#line 10074 "Photo.c"
		{
			PhotoImportParams* _tmp188_ = NULL;
			Thumbnails* _tmp189_ = NULL;
			PhotoFileReader* _tmp190_ = NULL;
			PhotoImportParams* _tmp191_ = NULL;
			PhotoRow* _tmp192_ = NULL;
			Orientation _tmp193_ = 0;
			PhotoImportParams* _tmp194_ = NULL;
			PhotoRow* _tmp195_ = NULL;
			BackingPhotoRow* _tmp196_ = NULL;
			Dimensions _tmp197_ = {0};
#line 1264 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp188_ = params;
#line 1264 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp189_ = _tmp188_->thumbnails;
#line 1264 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp190_ = reader;
#line 1264 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp191_ = params;
#line 1264 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp192_ = _tmp191_->row;
#line 1264 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp193_ = _tmp192_->orientation;
#line 1264 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp194_ = params;
#line 1264 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp195_ = _tmp194_->row;
#line 1264 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp196_ = _tmp195_->master;
#line 1264 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp197_ = _tmp196_->dim;
#line 1264 "/home/jens/Source/shotwell/src/Photo.vala"
			thumbnail_cache_generate_for_photo (_tmp189_, _tmp190_, _tmp193_, &_tmp197_, &_inner_error_);
#line 1264 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 10110 "Photo.c"
				goto __catch301_g_error;
			}
		}
		goto __finally301;
		__catch301_g_error:
		{
			GError* err = NULL;
			GError* _tmp198_ = NULL;
			ImportResult _tmp199_ = 0;
#line 1263 "/home/jens/Source/shotwell/src/Photo.vala"
			err = _inner_error_;
#line 1263 "/home/jens/Source/shotwell/src/Photo.vala"
			_inner_error_ = NULL;
#line 1267 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp198_ = err;
#line 1267 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp199_ = import_result_convert_error (_tmp198_, IMPORT_RESULT_FILE_ERROR);
#line 1267 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp199_;
#line 1267 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_error_free0 (err);
#line 1267 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_adapter_unref0 (reader);
#line 1267 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (comment);
#line 1267 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (title);
#line 1267 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (detected);
#line 1267 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_interrogator_unref0 (interrogator);
#line 1267 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (info);
#line 1267 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (file);
#line 1267 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 10148 "Photo.c"
		}
		__finally301:
#line 1263 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1263 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_adapter_unref0 (reader);
#line 1263 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (comment);
#line 1263 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (title);
#line 1263 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (detected);
#line 1263 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_interrogator_unref0 (interrogator);
#line 1263 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (info);
#line 1263 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (file);
#line 1263 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1263 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 1263 "/home/jens/Source/shotwell/src/Photo.vala"
			return 0;
#line 10173 "Photo.c"
		}
#line 1259 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (reader);
#line 10177 "Photo.c"
	}
#line 1274 "/home/jens/Source/shotwell/src/Photo.vala"
	result = IMPORT_RESULT_SUCCESS;
#line 1274 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (comment);
#line 1274 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (title);
#line 1274 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (detected);
#line 1274 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_interrogator_unref0 (interrogator);
#line 1274 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (info);
#line 1274 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (file);
#line 1274 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 10195 "Photo.c"
}


void photo_create_pre_import (PhotoImportParams* params) {
	GFile* file = NULL;
	PhotoImportParams* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	PhotoImportParams* _tmp3_ = NULL;
	PhotoRow* _tmp4_ = NULL;
	PhotoImportParams* _tmp5_ = NULL;
	PhotoRow* _tmp6_ = NULL;
	BackingPhotoRow* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	PhotoImportParams* _tmp9_ = NULL;
	PhotoRow* _tmp10_ = NULL;
	BackingPhotoRow* _tmp11_ = NULL;
	PhotoImportParams* _tmp12_ = NULL;
	PhotoRow* _tmp13_ = NULL;
	BackingPhotoRow* _tmp14_ = NULL;
	PhotoImportParams* _tmp15_ = NULL;
	PhotoRow* _tmp16_ = NULL;
	BackingPhotoRow* _tmp17_ = NULL;
	PhotoImportParams* _tmp18_ = NULL;
	PhotoRow* _tmp19_ = NULL;
	PhotoImportParams* _tmp20_ = NULL;
	PhotoRow* _tmp21_ = NULL;
	PhotoImportParams* _tmp22_ = NULL;
	PhotoRow* _tmp23_ = NULL;
	BackingPhotoRow* _tmp24_ = NULL;
	PhotoImportParams* _tmp25_ = NULL;
	PhotoRow* _tmp26_ = NULL;
	PhotoImportParams* _tmp27_ = NULL;
	ImportID _tmp28_ = {0};
	PhotoImportParams* _tmp29_ = NULL;
	PhotoRow* _tmp30_ = NULL;
	PhotoImportParams* _tmp31_ = NULL;
	PhotoRow* _tmp32_ = NULL;
	PhotoImportParams* _tmp33_ = NULL;
	PhotoRow* _tmp34_ = NULL;
	PhotoImportParams* _tmp35_ = NULL;
	PhotoRow* _tmp36_ = NULL;
	PhotoImportParams* _tmp37_ = NULL;
	PhotoRow* _tmp38_ = NULL;
	PhotoImportParams* _tmp39_ = NULL;
	PhotoRow* _tmp40_ = NULL;
	PhotoImportParams* _tmp41_ = NULL;
	PhotoRow* _tmp42_ = NULL;
	PhotoImportParams* _tmp43_ = NULL;
	PhotoRow* _tmp44_ = NULL;
	BackingPhotoRow* _tmp45_ = NULL;
	PhotoImportParams* _tmp46_ = NULL;
	PhotoRow* _tmp47_ = NULL;
	PhotoImportParams* _tmp48_ = NULL;
	PhotoRow* _tmp49_ = NULL;
	PhotoImportParams* _tmp50_ = NULL;
	PhotoRow* _tmp51_ = NULL;
	PhotoFileInterrogator* interrogator = NULL;
	PhotoImportParams* _tmp52_ = NULL;
	GFile* _tmp53_ = NULL;
	PhotoImportParams* _tmp54_ = NULL;
	PhotoFileSnifferOptions _tmp55_ = 0;
	PhotoFileInterrogator* _tmp56_ = NULL;
	GError * _inner_error_ = NULL;
#line 1277 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO_IMPORT_PARAMS (params));
#line 1278 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = params;
#line 1278 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_->file;
#line 1278 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 1278 "/home/jens/Source/shotwell/src/Photo.vala"
	file = _tmp2_;
#line 1279 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = params;
#line 1279 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp3_->row;
#line 1279 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_id_init (&_tmp4_->photo_id, PHOTO_ID_INVALID);
#line 1280 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = params;
#line 1280 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = _tmp5_->row;
#line 1280 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = _tmp6_->master;
#line 1280 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = g_file_get_path (file);
#line 1280 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp7_->filepath);
#line 1280 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_->filepath = _tmp8_;
#line 1281 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = params;
#line 1281 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = _tmp9_->row;
#line 1281 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = _tmp10_->master;
#line 1281 "/home/jens/Source/shotwell/src/Photo.vala"
	dimensions_init (&_tmp11_->dim, 0, 0);
#line 1282 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = params;
#line 1282 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = _tmp12_->row;
#line 1282 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = _tmp13_->master;
#line 1282 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_->filesize = (gint64) 0;
#line 1283 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = params;
#line 1283 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = _tmp15_->row;
#line 1283 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = _tmp16_->master;
#line 1283 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_->timestamp = (time_t) 0;
#line 1284 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = params;
#line 1284 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = _tmp18_->row;
#line 1284 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_->exposure_time = (time_t) 0;
#line 1285 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = params;
#line 1285 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = _tmp20_->row;
#line 1285 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_->orientation = ORIENTATION_TOP_LEFT;
#line 1286 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = params;
#line 1286 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp23_ = _tmp22_->row;
#line 1286 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp24_ = _tmp23_->master;
#line 1286 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp24_->original_orientation = ORIENTATION_TOP_LEFT;
#line 1287 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp25_ = params;
#line 1287 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp26_ = _tmp25_->row;
#line 1287 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp27_ = params;
#line 1287 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp28_ = _tmp27_->import_id;
#line 1287 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp26_->import_id = _tmp28_;
#line 1288 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp29_ = params;
#line 1288 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp30_ = _tmp29_->row;
#line 1288 "/home/jens/Source/shotwell/src/Photo.vala"
	event_id_init (&_tmp30_->event_id, EVENT_ID_INVALID);
#line 1289 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp31_ = params;
#line 1289 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp32_ = _tmp31_->row;
#line 1289 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp32_->transformations);
#line 1289 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp32_->transformations = NULL;
#line 1290 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp33_ = params;
#line 1290 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp34_ = _tmp33_->row;
#line 1290 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp34_->md5);
#line 1290 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp34_->md5 = NULL;
#line 1291 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp35_ = params;
#line 1291 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp36_ = _tmp35_->row;
#line 1291 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp36_->thumbnail_md5);
#line 1291 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp36_->thumbnail_md5 = NULL;
#line 1292 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp37_ = params;
#line 1292 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp38_ = _tmp37_->row;
#line 1292 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp38_->exif_md5);
#line 1292 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp38_->exif_md5 = NULL;
#line 1293 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp39_ = params;
#line 1293 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp40_ = _tmp39_->row;
#line 1293 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp40_->time_created = (time_t) 0;
#line 1294 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp41_ = params;
#line 1294 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp42_ = _tmp41_->row;
#line 1294 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp42_->flags = (guint64) 0;
#line 1295 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp43_ = params;
#line 1295 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp44_ = _tmp43_->row;
#line 1295 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp45_ = _tmp44_->master;
#line 1295 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp45_->file_format = PHOTO_FILE_FORMAT_JFIF;
#line 1296 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp46_ = params;
#line 1296 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp47_ = _tmp46_->row;
#line 1296 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp47_->title);
#line 1296 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp47_->title = NULL;
#line 1297 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp48_ = params;
#line 1297 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp49_ = _tmp48_->row;
#line 1297 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp49_->comment);
#line 1297 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp49_->comment = NULL;
#line 1298 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp50_ = params;
#line 1298 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp51_ = _tmp50_->row;
#line 1298 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp51_->rating = RATING_UNRATED;
#line 1300 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp52_ = params;
#line 1300 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp53_ = _tmp52_->file;
#line 1300 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp54_ = params;
#line 1300 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp55_ = _tmp54_->sniffer_options;
#line 1300 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp56_ = photo_file_interrogator_new (_tmp53_, _tmp55_);
#line 1300 "/home/jens/Source/shotwell/src/Photo.vala"
	interrogator = _tmp56_;
#line 10434 "Photo.c"
	{
		DetectedPhotoInformation* detected = NULL;
		DetectedPhotoInformation* _tmp57_ = NULL;
		gboolean _tmp58_ = FALSE;
		gboolean _tmp59_ = FALSE;
		DetectedPhotoInformation* _tmp60_ = NULL;
#line 1302 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_file_interrogator_interrogate (interrogator, &_inner_error_);
#line 1302 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 10445 "Photo.c"
			goto __catch302_g_error;
		}
#line 1303 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp57_ = photo_file_interrogator_get_detected_photo_information (interrogator);
#line 1303 "/home/jens/Source/shotwell/src/Photo.vala"
		detected = _tmp57_;
#line 1304 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp60_ = detected;
#line 1304 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp60_ != NULL) {
#line 10456 "Photo.c"
			gboolean _tmp61_ = FALSE;
#line 1304 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp61_ = photo_file_interrogator_get_is_photo_corrupted (interrogator);
#line 1304 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp59_ = !_tmp61_;
#line 10462 "Photo.c"
		} else {
#line 1304 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp59_ = FALSE;
#line 10466 "Photo.c"
		}
#line 1304 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp59_) {
#line 10470 "Photo.c"
			DetectedPhotoInformation* _tmp62_ = NULL;
			PhotoFileFormat _tmp63_ = 0;
#line 1304 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp62_ = detected;
#line 1304 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp63_ = _tmp62_->file_format;
#line 1304 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp58_ = _tmp63_ != PHOTO_FILE_FORMAT_UNKNOWN;
#line 10479 "Photo.c"
		} else {
#line 1304 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp58_ = FALSE;
#line 10483 "Photo.c"
		}
#line 1304 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp58_) {
#line 10487 "Photo.c"
			PhotoImportParams* _tmp64_ = NULL;
			PhotoRow* _tmp65_ = NULL;
			BackingPhotoRow* _tmp66_ = NULL;
			DetectedPhotoInformation* _tmp67_ = NULL;
			PhotoFileFormat _tmp68_ = 0;
#line 1305 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp64_ = params;
#line 1305 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp65_ = _tmp64_->row;
#line 1305 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp66_ = _tmp65_->master;
#line 1305 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp67_ = detected;
#line 1305 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp68_ = _tmp67_->file_format;
#line 1305 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp66_->file_format = _tmp68_;
#line 10505 "Photo.c"
		}
#line 1301 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 10509 "Photo.c"
	}
	goto __finally302;
	__catch302_g_error:
	{
		GError* err = NULL;
		gchar* _tmp69_ = NULL;
		gchar* _tmp70_ = NULL;
		GError* _tmp71_ = NULL;
		const gchar* _tmp72_ = NULL;
#line 1301 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 1301 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 1307 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp69_ = g_file_get_path (file);
#line 1307 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp70_ = _tmp69_;
#line 1307 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp71_ = err;
#line 1307 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp72_ = _tmp71_->message;
#line 1307 "/home/jens/Source/shotwell/src/Photo.vala"
		g_debug ("Photo.vala:1307: Unable to interrogate photo file %s: %s", _tmp70_, _tmp72_);
#line 1307 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp70_);
#line 1301 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 10537 "Photo.c"
	}
	__finally302:
#line 1301 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1301 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1301 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1301 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1301 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1301 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 10552 "Photo.c"
	}
#line 1277 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_interrogator_unref0 (interrogator);
#line 1277 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (file);
#line 10558 "Photo.c"
}


BackingPhotoRow* photo_query_backing_photo_row (Photo* self, GFile* file, PhotoFileSnifferOptions options, DetectedPhotoInformation** detected, GError** error) {
	DetectedPhotoInformation* _vala_detected = NULL;
	BackingPhotoRow* result = NULL;
	BackingPhotoRow* backing = NULL;
	BackingPhotoRow* _tmp0_ = NULL;
	GFileInfo* info = NULL;
	PhotoFileInterrogator* interrogator = NULL;
	GFile* _tmp10_ = NULL;
	PhotoFileSnifferOptions _tmp11_ = 0;
	PhotoFileInterrogator* _tmp12_ = NULL;
	PhotoFileInterrogator* _tmp13_ = NULL;
	PhotoFileInterrogator* _tmp14_ = NULL;
	DetectedPhotoInformation* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	DetectedPhotoInformation* _tmp17_ = NULL;
	GTimeVal modification_time = {0};
	GFileInfo* _tmp22_ = NULL;
	GTimeVal _tmp23_ = {0};
	BackingPhotoRow* _tmp24_ = NULL;
	GFile* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	BackingPhotoRow* _tmp27_ = NULL;
	GTimeVal _tmp28_ = {0};
	glong _tmp29_ = 0L;
	BackingPhotoRow* _tmp30_ = NULL;
	GFileInfo* _tmp31_ = NULL;
	gint64 _tmp32_ = 0LL;
	BackingPhotoRow* _tmp33_ = NULL;
	DetectedPhotoInformation* _tmp34_ = NULL;
	PhotoFileFormat _tmp35_ = 0;
	BackingPhotoRow* _tmp36_ = NULL;
	DetectedPhotoInformation* _tmp37_ = NULL;
	Dimensions _tmp38_ = {0};
	Orientation _tmp39_ = 0;
	DetectedPhotoInformation* _tmp40_ = NULL;
	PhotoMetadata* _tmp41_ = NULL;
	BackingPhotoRow* _tmp45_ = NULL;
	GError * _inner_error_ = NULL;
#line 1311 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 1311 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 1313 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (_vala_detected);
#line 1313 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_detected = NULL;
#line 1315 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = backing_photo_row_new ();
#line 1315 "/home/jens/Source/shotwell/src/Photo.vala"
	backing = _tmp0_;
#line 1317 "/home/jens/Source/shotwell/src/Photo.vala"
	info = NULL;
#line 10614 "Photo.c"
	{
		GFileInfo* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		GFileInfo* _tmp3_ = NULL;
		GFileInfo* _tmp4_ = NULL;
#line 1319 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = file;
#line 1319 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = g_file_query_info (_tmp2_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
#line 1319 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp3_;
#line 1319 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 10628 "Photo.c"
			goto __catch303_g_error;
		}
#line 1319 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = _tmp1_;
#line 1319 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = NULL;
#line 1319 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1319 "/home/jens/Source/shotwell/src/Photo.vala"
		info = _tmp4_;
#line 1318 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp1_);
#line 10641 "Photo.c"
	}
	goto __finally303;
	__catch303_g_error:
	{
		GError* err = NULL;
		GFile* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 1318 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 1318 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 1322 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = file;
#line 1322 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = g_file_get_path (_tmp5_);
#line 1322 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = _tmp6_;
#line 1322 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp8_ = err;
#line 1322 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = _tmp8_->message;
#line 1322 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("Photo.vala:1322: Unable to read file information for %s: %s", _tmp7_, _tmp9_);
#line 1322 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp7_);
#line 1324 "/home/jens/Source/shotwell/src/Photo.vala"
		result = NULL;
#line 1324 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 1324 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1324 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1324 "/home/jens/Source/shotwell/src/Photo.vala"
		if (detected) {
#line 1324 "/home/jens/Source/shotwell/src/Photo.vala"
			*detected = _vala_detected;
#line 10682 "Photo.c"
		} else {
#line 1324 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (_vala_detected);
#line 10686 "Photo.c"
		}
#line 1324 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 10690 "Photo.c"
	}
	__finally303:
#line 1318 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1318 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 1318 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1318 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1318 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 10703 "Photo.c"
	}
#line 1328 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = file;
#line 1328 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = options;
#line 1328 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = photo_file_interrogator_new (_tmp10_, _tmp11_);
#line 1328 "/home/jens/Source/shotwell/src/Photo.vala"
	interrogator = _tmp12_;
#line 1329 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = interrogator;
#line 1329 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_file_interrogator_interrogate (_tmp13_, &_inner_error_);
#line 1329 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1329 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 1329 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1329 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1329 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1329 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 10729 "Photo.c"
	}
#line 1330 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = interrogator;
#line 1330 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = photo_file_interrogator_get_detected_photo_information (_tmp14_);
#line 1330 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (_vala_detected);
#line 1330 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_detected = _tmp15_;
#line 1331 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = _vala_detected;
#line 1331 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp17_ == NULL) {
#line 1331 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = TRUE;
#line 10745 "Photo.c"
	} else {
		PhotoFileInterrogator* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
#line 1331 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = interrogator;
#line 1331 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = photo_file_interrogator_get_is_photo_corrupted (_tmp18_);
#line 1331 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = _tmp19_;
#line 10755 "Photo.c"
	}
#line 1331 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp16_) {
#line 10759 "Photo.c"
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
#line 1332 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 1332 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = _tmp20_;
#line 1332 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("Photo.vala:1332: Photo update: %s no longer a recognized image", _tmp21_);
#line 1332 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp21_);
#line 1334 "/home/jens/Source/shotwell/src/Photo.vala"
		result = NULL;
#line 1334 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 1334 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 1334 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1334 "/home/jens/Source/shotwell/src/Photo.vala"
		if (detected) {
#line 1334 "/home/jens/Source/shotwell/src/Photo.vala"
			*detected = _vala_detected;
#line 10782 "Photo.c"
		} else {
#line 1334 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (_vala_detected);
#line 10786 "Photo.c"
		}
#line 1334 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 10790 "Photo.c"
	}
#line 1337 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = info;
#line 1337 "/home/jens/Source/shotwell/src/Photo.vala"
	g_file_info_get_modification_time (_tmp22_, &_tmp23_);
#line 1337 "/home/jens/Source/shotwell/src/Photo.vala"
	modification_time = _tmp23_;
#line 1339 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp24_ = backing;
#line 1339 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp25_ = file;
#line 1339 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp26_ = g_file_get_path (_tmp25_);
#line 1339 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp24_->filepath);
#line 1339 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp24_->filepath = _tmp26_;
#line 1340 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp27_ = backing;
#line 1340 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp28_ = modification_time;
#line 1340 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp29_ = _tmp28_.tv_sec;
#line 1340 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp27_->timestamp = (time_t) _tmp29_;
#line 1341 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp30_ = backing;
#line 1341 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp31_ = info;
#line 1341 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp32_ = g_file_info_get_size (_tmp31_);
#line 1341 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp30_->filesize = _tmp32_;
#line 1342 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp33_ = backing;
#line 1342 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp34_ = _vala_detected;
#line 1342 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp35_ = _tmp34_->file_format;
#line 1342 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp33_->file_format = _tmp35_;
#line 1343 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp36_ = backing;
#line 1343 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp37_ = _vala_detected;
#line 1343 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp38_ = _tmp37_->image_dim;
#line 1343 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp36_->dim = _tmp38_;
#line 1344 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp40_ = _vala_detected;
#line 1344 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp41_ = _tmp40_->metadata;
#line 1344 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp41_ != NULL) {
#line 10846 "Photo.c"
		DetectedPhotoInformation* _tmp42_ = NULL;
		PhotoMetadata* _tmp43_ = NULL;
		Orientation _tmp44_ = 0;
#line 1345 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp42_ = _vala_detected;
#line 1345 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp43_ = _tmp42_->metadata;
#line 1345 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp44_ = photo_metadata_get_orientation (_tmp43_);
#line 1345 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp39_ = _tmp44_;
#line 10858 "Photo.c"
	} else {
#line 1345 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp39_ = ORIENTATION_TOP_LEFT;
#line 10862 "Photo.c"
	}
#line 1344 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp45_ = backing;
#line 1344 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp45_->original_orientation = _tmp39_;
#line 1347 "/home/jens/Source/shotwell/src/Photo.vala"
	result = backing;
#line 1347 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_interrogator_unref0 (interrogator);
#line 1347 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (info);
#line 1347 "/home/jens/Source/shotwell/src/Photo.vala"
	if (detected) {
#line 1347 "/home/jens/Source/shotwell/src/Photo.vala"
		*detected = _vala_detected;
#line 10878 "Photo.c"
	} else {
#line 1347 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (_vala_detected);
#line 10882 "Photo.c"
	}
#line 1347 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 10886 "Photo.c"
}


static void _vala_array_add88 (gchar*** array, int* length, int* size, gchar* value) {
#line 1443 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1443 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1443 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 10897 "Photo.c"
	}
#line 1443 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1443 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 10903 "Photo.c"
}


static void _vala_array_add89 (gchar*** array, int* length, int* size, gchar* value) {
#line 1446 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1446 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1446 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 10914 "Photo.c"
	}
#line 1446 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1446 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 10920 "Photo.c"
}


static void _vala_array_add90 (gchar*** array, int* length, int* size, gchar* value) {
#line 1453 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1453 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1453 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 10931 "Photo.c"
	}
#line 1453 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1453 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 10937 "Photo.c"
}


static void _vala_array_add91 (gchar*** array, int* length, int* size, gchar* value) {
#line 1456 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1456 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1456 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 10948 "Photo.c"
	}
#line 1456 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1456 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 10954 "Photo.c"
}


static void _vala_array_add92 (gchar*** array, int* length, int* size, gchar* value) {
#line 1459 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1459 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1459 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 10965 "Photo.c"
	}
#line 1459 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1459 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 10971 "Photo.c"
}


static void _vala_array_add93 (gchar*** array, int* length, int* size, gchar* value) {
#line 1462 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1462 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1462 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 10982 "Photo.c"
	}
#line 1462 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1462 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 10988 "Photo.c"
}


static gpointer _media_metadata_ref0 (gpointer self) {
#line 1472 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? media_metadata_ref (self) : NULL;
#line 10995 "Photo.c"
}


gboolean photo_prepare_for_reimport_master (Photo* self, PhotoReimportMasterState** reimport_state, GError** error) {
	PhotoReimportMasterState* _vala_reimport_state = NULL;
	gboolean result = FALSE;
	GFile* file = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	DetectedPhotoInformation* detected = NULL;
	BackingPhotoRow* backing = NULL;
	GFile* _tmp4_ = NULL;
	DetectedPhotoInformation* _tmp5_ = NULL;
	BackingPhotoRow* _tmp6_ = NULL;
	BackingPhotoRow* _tmp8_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	DetectedPhotoInformation* _tmp14_ = NULL;
	GdkColorspace _tmp15_ = 0;
	PhotoRow* updated_row = NULL;
	PhotoRow* _tmp23_ = NULL;
	gchar** list = NULL;
	gchar** _tmp29_ = NULL;
	gint list_length1 = 0;
	gint _list_size_ = 0;
	PhotoRow* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	DetectedPhotoInformation* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	PhotoRow* _tmp36_ = NULL;
	BackingPhotoRow* _tmp37_ = NULL;
	Orientation _tmp38_ = 0;
	BackingPhotoRow* _tmp39_ = NULL;
	Orientation _tmp40_ = 0;
	DetectedPhotoInformation* _tmp47_ = NULL;
	PhotoMetadata* _tmp48_ = NULL;
	PhotoRow* _tmp85_ = NULL;
	BackingPhotoRow* _tmp86_ = NULL;
	BackingPhotoRow* _tmp87_ = NULL;
	PhotoRow* _tmp88_ = NULL;
	DetectedPhotoInformation* _tmp89_ = NULL;
	const gchar* _tmp90_ = NULL;
	gchar* _tmp91_ = NULL;
	PhotoRow* _tmp92_ = NULL;
	DetectedPhotoInformation* _tmp93_ = NULL;
	const gchar* _tmp94_ = NULL;
	gchar* _tmp95_ = NULL;
	PhotoRow* _tmp96_ = NULL;
	DetectedPhotoInformation* _tmp97_ = NULL;
	const gchar* _tmp98_ = NULL;
	gchar* _tmp99_ = NULL;
	PhotoMetadata* metadata = NULL;
	DetectedPhotoInformation* _tmp100_ = NULL;
	PhotoMetadata* _tmp101_ = NULL;
	PhotoRow* _tmp124_ = NULL;
	PhotoMetadata* _tmp125_ = NULL;
	gchar** _tmp126_ = NULL;
	gint _tmp126__length1 = 0;
	PhotoReimportMasterStateImpl* _tmp127_ = NULL;
	GError * _inner_error_ = NULL;
#line 1411 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 1412 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_master_state_unref0 (_vala_reimport_state);
#line 1412 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_reimport_state = NULL;
#line 1414 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_master_reader (self);
#line 1414 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1414 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1414 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_;
#line 1414 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp1_);
#line 1414 "/home/jens/Source/shotwell/src/Photo.vala"
	file = _tmp3_;
#line 1417 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = file;
#line 1417 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = photo_query_backing_photo_row (self, _tmp4_, PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL, &_tmp5_, &_inner_error_);
#line 1417 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (detected);
#line 1417 "/home/jens/Source/shotwell/src/Photo.vala"
	detected = _tmp5_;
#line 1417 "/home/jens/Source/shotwell/src/Photo.vala"
	backing = _tmp6_;
#line 1417 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 11088 "Photo.c"
		gboolean _tmp7_ = FALSE;
#line 1417 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 1417 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 1417 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1417 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp7_;
#line 11098 "Photo.c"
	}
#line 1419 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = backing;
#line 1419 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp8_ == NULL) {
#line 11104 "Photo.c"
		GFile* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
#line 1420 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = file;
#line 1420 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = g_file_get_path (_tmp9_);
#line 1420 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = _tmp10_;
#line 1420 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:1420: Unable to retrieve photo state from %s for reimport", _tmp11_);
#line 1420 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp11_);
#line 1421 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1421 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1421 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 1421 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1421 "/home/jens/Source/shotwell/src/Photo.vala"
		if (reimport_state) {
#line 1421 "/home/jens/Source/shotwell/src/Photo.vala"
			*reimport_state = _vala_reimport_state;
#line 11130 "Photo.c"
		} else {
#line 1421 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_master_state_unref0 (_vala_reimport_state);
#line 11134 "Photo.c"
		}
#line 1421 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 11138 "Photo.c"
	}
#line 1425 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = detected;
#line 1425 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = _tmp14_->colorspace;
#line 1425 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp15_ != GDK_COLORSPACE_RGB) {
#line 1425 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = TRUE;
#line 11148 "Photo.c"
	} else {
		DetectedPhotoInformation* _tmp16_ = NULL;
		gint _tmp17_ = 0;
#line 1426 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = detected;
#line 1426 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = _tmp16_->channels;
#line 1426 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = _tmp17_ < 3;
#line 11158 "Photo.c"
	}
#line 1425 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp13_) {
#line 1425 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = TRUE;
#line 11164 "Photo.c"
	} else {
		DetectedPhotoInformation* _tmp18_ = NULL;
		gint _tmp19_ = 0;
#line 1427 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = detected;
#line 1427 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = _tmp18_->bits_per_channel;
#line 1427 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = _tmp19_ != 8;
#line 11174 "Photo.c"
	}
#line 1425 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp12_) {
#line 11178 "Photo.c"
		GFile* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
#line 1428 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = file;
#line 1428 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = g_file_get_path (_tmp20_);
#line 1428 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = _tmp21_;
#line 1428 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:1428: Not re-importing %s: Unsupported color format", _tmp22_);
#line 1428 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp22_);
#line 1430 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1430 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1430 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 1430 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1430 "/home/jens/Source/shotwell/src/Photo.vala"
		if (reimport_state) {
#line 1430 "/home/jens/Source/shotwell/src/Photo.vala"
			*reimport_state = _vala_reimport_state;
#line 11204 "Photo.c"
		} else {
#line 1430 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_master_state_unref0 (_vala_reimport_state);
#line 11208 "Photo.c"
		}
#line 1430 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 11212 "Photo.c"
	}
#line 1434 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp23_ = photo_row_new ();
#line 1434 "/home/jens/Source/shotwell/src/Photo.vala"
	updated_row = _tmp23_;
#line 11218 "Photo.c"
	{
		PhotoRow* _tmp24_ = NULL;
#line 1435 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp24_ = self->row;
#line 1435 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 11225 "Photo.c"
		{
			PhotoRow* _tmp25_ = NULL;
			PhotoRow* _tmp26_ = NULL;
#line 1436 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp25_ = self->row;
#line 1436 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp26_ = _photo_row_ref0 (_tmp25_);
#line 1436 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_row_unref0 (updated_row);
#line 1436 "/home/jens/Source/shotwell/src/Photo.vala"
			updated_row = _tmp26_;
#line 11237 "Photo.c"
		}
		__finally304:
		{
			PhotoRow* _tmp27_ = NULL;
#line 1435 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp27_ = self->row;
#line 1435 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 11246 "Photo.c"
		}
#line 1435 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 11250 "Photo.c"
			gboolean _tmp28_ = FALSE;
#line 1435 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 1435 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_row_unref0 (updated_row);
#line 1435 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (backing);
#line 1435 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (detected);
#line 1435 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (file);
#line 1435 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp28_;
#line 11264 "Photo.c"
		}
	}
#line 1440 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp29_ = g_new0 (gchar*, 0 + 1);
#line 1440 "/home/jens/Source/shotwell/src/Photo.vala"
	list = _tmp29_;
#line 1440 "/home/jens/Source/shotwell/src/Photo.vala"
	list_length1 = 0;
#line 1440 "/home/jens/Source/shotwell/src/Photo.vala"
	_list_size_ = list_length1;
#line 1442 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp30_ = updated_row;
#line 1442 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp31_ = _tmp30_->md5;
#line 1442 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp32_ = detected;
#line 1442 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp33_ = _tmp32_->md5;
#line 1442 "/home/jens/Source/shotwell/src/Photo.vala"
	if (g_strcmp0 (_tmp31_, _tmp33_) != 0) {
#line 11285 "Photo.c"
		gchar** _tmp34_ = NULL;
		gint _tmp34__length1 = 0;
		gchar* _tmp35_ = NULL;
#line 1443 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp34_ = list;
#line 1443 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp34__length1 = list_length1;
#line 1443 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp35_ = g_strdup ("metadata:md5");
#line 1443 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_array_add88 (&list, &list_length1, &_list_size_, _tmp35_);
#line 11297 "Photo.c"
	}
#line 1445 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp36_ = updated_row;
#line 1445 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp37_ = _tmp36_->master;
#line 1445 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp38_ = _tmp37_->original_orientation;
#line 1445 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp39_ = backing;
#line 1445 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp40_ = _tmp39_->original_orientation;
#line 1445 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp38_ != _tmp40_) {
#line 11311 "Photo.c"
		gchar** _tmp41_ = NULL;
		gint _tmp41__length1 = 0;
		gchar* _tmp42_ = NULL;
		PhotoRow* _tmp43_ = NULL;
		BackingPhotoRow* _tmp44_ = NULL;
		BackingPhotoRow* _tmp45_ = NULL;
		Orientation _tmp46_ = 0;
#line 1446 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp41_ = list;
#line 1446 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp41__length1 = list_length1;
#line 1446 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp42_ = g_strdup ("image:orientation");
#line 1446 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_array_add89 (&list, &list_length1, &_list_size_, _tmp42_);
#line 1447 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp43_ = updated_row;
#line 1447 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp44_ = _tmp43_->master;
#line 1447 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp45_ = backing;
#line 1447 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp46_ = _tmp45_->original_orientation;
#line 1447 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp44_->original_orientation = _tmp46_;
#line 11337 "Photo.c"
	}
#line 1450 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp47_ = detected;
#line 1450 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp48_ = _tmp47_->metadata;
#line 1450 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp48_ != NULL) {
#line 11345 "Photo.c"
		MetadataDateTime* date_time = NULL;
		DetectedPhotoInformation* _tmp49_ = NULL;
		PhotoMetadata* _tmp50_ = NULL;
		MetadataDateTime* _tmp51_ = NULL;
		gboolean _tmp52_ = FALSE;
		MetadataDateTime* _tmp53_ = NULL;
		PhotoRow* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		DetectedPhotoInformation* _tmp62_ = NULL;
		PhotoMetadata* _tmp63_ = NULL;
		gchar* _tmp64_ = NULL;
		gchar* _tmp65_ = NULL;
		gboolean _tmp66_ = FALSE;
		PhotoRow* _tmp69_ = NULL;
		const gchar* _tmp70_ = NULL;
		DetectedPhotoInformation* _tmp71_ = NULL;
		PhotoMetadata* _tmp72_ = NULL;
		gchar* _tmp73_ = NULL;
		gchar* _tmp74_ = NULL;
		gboolean _tmp75_ = FALSE;
		PhotoRow* _tmp78_ = NULL;
		Rating _tmp79_ = 0;
		DetectedPhotoInformation* _tmp80_ = NULL;
		PhotoMetadata* _tmp81_ = NULL;
		Rating _tmp82_ = 0;
#line 1451 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp49_ = detected;
#line 1451 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp50_ = _tmp49_->metadata;
#line 1451 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp51_ = photo_metadata_get_exposure_date_time (_tmp50_);
#line 1451 "/home/jens/Source/shotwell/src/Photo.vala"
		date_time = _tmp51_;
#line 1452 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp53_ = date_time;
#line 1452 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp53_ != NULL) {
#line 11383 "Photo.c"
			PhotoRow* _tmp54_ = NULL;
			time_t _tmp55_ = 0;
			MetadataDateTime* _tmp56_ = NULL;
			time_t _tmp57_ = 0;
#line 1452 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp54_ = updated_row;
#line 1452 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp55_ = _tmp54_->exposure_time;
#line 1452 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp56_ = date_time;
#line 1452 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp57_ = metadata_date_time_get_timestamp (_tmp56_);
#line 1452 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp52_ = _tmp55_ != _tmp57_;
#line 11398 "Photo.c"
		} else {
#line 1452 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp52_ = FALSE;
#line 11402 "Photo.c"
		}
#line 1452 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp52_) {
#line 11406 "Photo.c"
			gchar** _tmp58_ = NULL;
			gint _tmp58__length1 = 0;
			gchar* _tmp59_ = NULL;
#line 1453 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp58_ = list;
#line 1453 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp58__length1 = list_length1;
#line 1453 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp59_ = g_strdup ("metadata:exposure-time");
#line 1453 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add90 (&list, &list_length1, &_list_size_, _tmp59_);
#line 11418 "Photo.c"
		}
#line 1455 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp60_ = updated_row;
#line 1455 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp61_ = _tmp60_->title;
#line 1455 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp62_ = detected;
#line 1455 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp63_ = _tmp62_->metadata;
#line 1455 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp64_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1455 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp65_ = _tmp64_;
#line 1455 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp66_ = g_strcmp0 (_tmp61_, _tmp65_) != 0;
#line 1455 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp65_);
#line 1455 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp66_) {
#line 11438 "Photo.c"
			gchar** _tmp67_ = NULL;
			gint _tmp67__length1 = 0;
			gchar* _tmp68_ = NULL;
#line 1456 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp67_ = list;
#line 1456 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp67__length1 = list_length1;
#line 1456 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp68_ = g_strdup ("metadata:name");
#line 1456 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add91 (&list, &list_length1, &_list_size_, _tmp68_);
#line 11450 "Photo.c"
		}
#line 1458 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp69_ = updated_row;
#line 1458 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp70_ = _tmp69_->comment;
#line 1458 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp71_ = detected;
#line 1458 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp72_ = _tmp71_->metadata;
#line 1458 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp73_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1458 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp74_ = _tmp73_;
#line 1458 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp75_ = g_strcmp0 (_tmp70_, _tmp74_) != 0;
#line 1458 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp74_);
#line 1458 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp75_) {
#line 11470 "Photo.c"
			gchar** _tmp76_ = NULL;
			gint _tmp76__length1 = 0;
			gchar* _tmp77_ = NULL;
#line 1459 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp76_ = list;
#line 1459 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp76__length1 = list_length1;
#line 1459 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp77_ = g_strdup ("metadata:comment");
#line 1459 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add92 (&list, &list_length1, &_list_size_, _tmp77_);
#line 11482 "Photo.c"
		}
#line 1461 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp78_ = updated_row;
#line 1461 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp79_ = _tmp78_->rating;
#line 1461 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp80_ = detected;
#line 1461 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp81_ = _tmp80_->metadata;
#line 1461 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp82_ = photo_metadata_get_rating (_tmp81_);
#line 1461 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp79_ != _tmp82_) {
#line 11496 "Photo.c"
			gchar** _tmp83_ = NULL;
			gint _tmp83__length1 = 0;
			gchar* _tmp84_ = NULL;
#line 1462 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp83_ = list;
#line 1462 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp83__length1 = list_length1;
#line 1462 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp84_ = g_strdup ("metadata:rating");
#line 1462 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add93 (&list, &list_length1, &_list_size_, _tmp84_);
#line 11508 "Photo.c"
		}
#line 1450 "/home/jens/Source/shotwell/src/Photo.vala"
		_metadata_date_time_unref0 (date_time);
#line 11512 "Photo.c"
	}
#line 1465 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp85_ = updated_row;
#line 1465 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp86_ = backing;
#line 1465 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp87_ = _backing_photo_row_ref0 (_tmp86_);
#line 1465 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_photo_row_unref0 (_tmp85_->master);
#line 1465 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp85_->master = _tmp87_;
#line 1466 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp88_ = updated_row;
#line 1466 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp89_ = detected;
#line 1466 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp90_ = _tmp89_->md5;
#line 1466 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp91_ = g_strdup (_tmp90_);
#line 1466 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp88_->md5);
#line 1466 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp88_->md5 = _tmp91_;
#line 1467 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp92_ = updated_row;
#line 1467 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp93_ = detected;
#line 1467 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp94_ = _tmp93_->exif_md5;
#line 1467 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp95_ = g_strdup (_tmp94_);
#line 1467 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp92_->exif_md5);
#line 1467 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp92_->exif_md5 = _tmp95_;
#line 1468 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp96_ = updated_row;
#line 1468 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp97_ = detected;
#line 1468 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp98_ = _tmp97_->thumbnail_md5;
#line 1468 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp99_ = g_strdup (_tmp98_);
#line 1468 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp96_->thumbnail_md5);
#line 1468 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp96_->thumbnail_md5 = _tmp99_;
#line 1470 "/home/jens/Source/shotwell/src/Photo.vala"
	metadata = NULL;
#line 1471 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp100_ = detected;
#line 1471 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp101_ = _tmp100_->metadata;
#line 1471 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp101_ != NULL) {
#line 11568 "Photo.c"
		DetectedPhotoInformation* _tmp102_ = NULL;
		PhotoMetadata* _tmp103_ = NULL;
		PhotoMetadata* _tmp104_ = NULL;
		MetadataDateTime* date_time = NULL;
		DetectedPhotoInformation* _tmp105_ = NULL;
		PhotoMetadata* _tmp106_ = NULL;
		MetadataDateTime* _tmp107_ = NULL;
		MetadataDateTime* _tmp108_ = NULL;
		PhotoRow* _tmp112_ = NULL;
		DetectedPhotoInformation* _tmp113_ = NULL;
		PhotoMetadata* _tmp114_ = NULL;
		gchar* _tmp115_ = NULL;
		PhotoRow* _tmp116_ = NULL;
		DetectedPhotoInformation* _tmp117_ = NULL;
		PhotoMetadata* _tmp118_ = NULL;
		gchar* _tmp119_ = NULL;
		PhotoRow* _tmp120_ = NULL;
		DetectedPhotoInformation* _tmp121_ = NULL;
		PhotoMetadata* _tmp122_ = NULL;
		Rating _tmp123_ = 0;
#line 1472 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp102_ = detected;
#line 1472 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp103_ = _tmp102_->metadata;
#line 1472 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp104_ = _media_metadata_ref0 (_tmp103_);
#line 1472 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 1472 "/home/jens/Source/shotwell/src/Photo.vala"
		metadata = _tmp104_;
#line 1474 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp105_ = detected;
#line 1474 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp106_ = _tmp105_->metadata;
#line 1474 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp107_ = photo_metadata_get_exposure_date_time (_tmp106_);
#line 1474 "/home/jens/Source/shotwell/src/Photo.vala"
		date_time = _tmp107_;
#line 1475 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp108_ = date_time;
#line 1475 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp108_ != NULL) {
#line 11611 "Photo.c"
			PhotoRow* _tmp109_ = NULL;
			MetadataDateTime* _tmp110_ = NULL;
			time_t _tmp111_ = 0;
#line 1476 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp109_ = updated_row;
#line 1476 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp110_ = date_time;
#line 1476 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp111_ = metadata_date_time_get_timestamp (_tmp110_);
#line 1476 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp109_->exposure_time = _tmp111_;
#line 11623 "Photo.c"
		}
#line 1478 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp112_ = updated_row;
#line 1478 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp113_ = detected;
#line 1478 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp114_ = _tmp113_->metadata;
#line 1478 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp115_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp114_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1478 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp112_->title);
#line 1478 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp112_->title = _tmp115_;
#line 1479 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp116_ = updated_row;
#line 1479 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp117_ = detected;
#line 1479 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp118_ = _tmp117_->metadata;
#line 1479 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp119_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp118_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1479 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp116_->comment);
#line 1479 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp116_->comment = _tmp119_;
#line 1480 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp120_ = updated_row;
#line 1480 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp121_ = detected;
#line 1480 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp122_ = _tmp121_->metadata;
#line 1480 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp123_ = photo_metadata_get_rating (_tmp122_);
#line 1480 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp120_->rating = _tmp123_;
#line 1471 "/home/jens/Source/shotwell/src/Photo.vala"
		_metadata_date_time_unref0 (date_time);
#line 11661 "Photo.c"
	}
#line 1483 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp124_ = updated_row;
#line 1483 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp125_ = metadata;
#line 1483 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp126_ = list;
#line 1483 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp126__length1 = list_length1;
#line 1483 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp127_ = photo_reimport_master_state_impl_new (_tmp124_, _tmp125_, _tmp126_, _tmp126__length1);
#line 1483 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_master_state_unref0 (_vala_reimport_state);
#line 1483 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_reimport_state = G_TYPE_CHECK_INSTANCE_CAST (_tmp127_, PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterState);
#line 1485 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 1485 "/home/jens/Source/shotwell/src/Photo.vala"
	_media_metadata_unref0 (metadata);
#line 1485 "/home/jens/Source/shotwell/src/Photo.vala"
	list = (_vala_array_free (list, list_length1, (GDestroyNotify) g_free), NULL);
#line 1485 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_row_unref0 (updated_row);
#line 1485 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_photo_row_unref0 (backing);
#line 1485 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (detected);
#line 1485 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (file);
#line 1485 "/home/jens/Source/shotwell/src/Photo.vala"
	if (reimport_state) {
#line 1485 "/home/jens/Source/shotwell/src/Photo.vala"
		*reimport_state = _vala_reimport_state;
#line 11695 "Photo.c"
	} else {
#line 1485 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_reimport_master_state_unref0 (_vala_reimport_state);
#line 11699 "Photo.c"
	}
#line 1485 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 11703 "Photo.c"
}


static void photo_real_apply_user_metadata_for_reimport (Photo* self, PhotoMetadata* metadata) {
#line 1488 "/home/jens/Source/shotwell/src/Photo.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_apply_user_metadata_for_reimport'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 1488 "/home/jens/Source/shotwell/src/Photo.vala"
	return;
#line 11712 "Photo.c"
}


void photo_apply_user_metadata_for_reimport (Photo* self, PhotoMetadata* metadata) {
#line 1488 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1488 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->apply_user_metadata_for_reimport (self, metadata);
#line 11721 "Photo.c"
}


static gpointer _photo_reimport_master_state_ref0 (gpointer self) {
#line 1492 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? photo_reimport_master_state_ref (self) : NULL;
#line 11728 "Photo.c"
}


static void _vala_array_add94 (gchar*** array, int* length, int* size, gchar* value) {
#line 1510 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1510 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1510 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 11739 "Photo.c"
	}
#line 1510 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1510 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 11745 "Photo.c"
}


static void _vala_array_add95 (gchar*** array, int* length, int* size, gchar* value) {
#line 1512 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1512 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1512 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 11756 "Photo.c"
	}
#line 1512 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1512 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 11762 "Photo.c"
}


void photo_finish_reimport_master (Photo* self, PhotoReimportMasterState* state, GError** error) {
	PhotoReimportMasterStateImpl* reimport_state = NULL;
	PhotoReimportMasterState* _tmp0_ = NULL;
	PhotoReimportMasterStateImpl* _tmp1_ = NULL;
	PhotoTable* _tmp2_ = NULL;
	PhotoTable* _tmp3_ = NULL;
	PhotoRow* _tmp4_ = NULL;
	PhotoMetadata* _tmp20_ = NULL;
	gboolean _tmp22_ = FALSE;
	gchar** _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	PhotoMetadata* _tmp32_ = NULL;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp35_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1491 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1491 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (PHOTO_IS_REIMPORT_MASTER_STATE (state));
#line 1492 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = state;
#line 1492 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _photo_reimport_master_state_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImpl));
#line 1492 "/home/jens/Source/shotwell/src/Photo.vala"
	reimport_state = _tmp1_;
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_table_get_instance ();
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_;
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = reimport_state->row;
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_table_reimport (_tmp3_, _tmp4_, &_inner_error_);
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
	_database_table_unref0 (_tmp3_);
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_master_state_unref0 (reimport_state);
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 11811 "Photo.c"
		} else {
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_master_state_unref0 (reimport_state);
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 1494 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 11821 "Photo.c"
		}
	}
	{
		PhotoRow* _tmp5_ = NULL;
#line 1496 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = self->row;
#line 1496 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 11830 "Photo.c"
		{
			BackingPhotoRow* original_master = NULL;
			PhotoRow* _tmp6_ = NULL;
			BackingPhotoRow* _tmp7_ = NULL;
			BackingPhotoRow* _tmp8_ = NULL;
			PhotoRow* _tmp9_ = NULL;
			PhotoRow* _tmp10_ = NULL;
			PhotoRow* _tmp11_ = NULL;
			BackingPhotoRow* _tmp12_ = NULL;
			BackingPhotoRow* _tmp13_ = NULL;
			PhotoRow* _tmp14_ = NULL;
			BackingPhotoRow* _tmp15_ = NULL;
			PhotoRow* _tmp16_ = NULL;
			BackingPhotoRow* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
#line 1498 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = self->row;
#line 1498 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = _tmp6_->master;
#line 1498 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = _backing_photo_row_ref0 (_tmp7_);
#line 1498 "/home/jens/Source/shotwell/src/Photo.vala"
			original_master = _tmp8_;
#line 1499 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = reimport_state->row;
#line 1499 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = _photo_row_ref0 (_tmp9_);
#line 1499 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_row_unref0 (self->row);
#line 1499 "/home/jens/Source/shotwell/src/Photo.vala"
			self->row = _tmp10_;
#line 1500 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = self->row;
#line 1500 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = original_master;
#line 1500 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = _backing_photo_row_ref0 (_tmp12_);
#line 1500 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (_tmp11_->master);
#line 1500 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_->master = _tmp13_;
#line 1501 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = self->row;
#line 1501 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = _tmp14_->master;
#line 1501 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = reimport_state->row;
#line 1501 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = _tmp16_->master;
#line 1501 "/home/jens/Source/shotwell/src/Photo.vala"
			backing_photo_row_copy_from (_tmp15_, _tmp17_);
#line 1502 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp18_ = reimport_state->metadata_only;
#line 1502 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!_tmp18_) {
#line 1503 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_internal_remove_all_transformations (self, FALSE);
#line 11888 "Photo.c"
			}
#line 1496 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (original_master);
#line 11892 "Photo.c"
		}
		__finally305:
		{
			PhotoRow* _tmp19_ = NULL;
#line 1496 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp19_ = self->row;
#line 1496 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 11901 "Photo.c"
		}
#line 1496 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1496 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 1496 "/home/jens/Source/shotwell/src/Photo.vala"
				g_propagate_error (error, _inner_error_);
#line 1496 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_reimport_master_state_unref0 (reimport_state);
#line 1496 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 11913 "Photo.c"
			} else {
#line 1496 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_reimport_master_state_unref0 (reimport_state);
#line 1496 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1496 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 1496 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 11923 "Photo.c"
			}
		}
	}
#line 1506 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = reimport_state->metadata;
#line 1506 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp20_ != NULL) {
#line 11931 "Photo.c"
		PhotoMetadata* _tmp21_ = NULL;
#line 1507 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = reimport_state->metadata;
#line 1507 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_apply_user_metadata_for_reimport (self, _tmp21_);
#line 11937 "Photo.c"
	}
#line 1509 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = reimport_state->metadata_only;
#line 1509 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp22_) {
#line 11943 "Photo.c"
		gchar** _tmp23_ = NULL;
		gint _tmp23__length1 = 0;
		gchar* _tmp24_ = NULL;
		gboolean _tmp25_ = FALSE;
#line 1510 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23_ = reimport_state->alterations;
#line 1510 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23__length1 = reimport_state->alterations_length1;
#line 1510 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp24_ = g_strdup ("image:master");
#line 1510 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_array_add94 (&reimport_state->alterations, &reimport_state->alterations_length1, &reimport_state->_alterations_size_, _tmp24_);
#line 1511 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp25_ = photo_is_master_baseline (self);
#line 1511 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp25_) {
#line 11960 "Photo.c"
			gchar** _tmp26_ = NULL;
			gint _tmp26__length1 = 0;
			gchar* _tmp27_ = NULL;
#line 1512 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp26_ = reimport_state->alterations;
#line 1512 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp26__length1 = reimport_state->alterations_length1;
#line 1512 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp27_ = g_strdup ("image:baseline");
#line 1512 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add95 (&reimport_state->alterations, &reimport_state->alterations_length1, &reimport_state->_alterations_size_, _tmp27_);
#line 11972 "Photo.c"
		}
	}
#line 1515 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp28_ = reimport_state->alterations;
#line 1515 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp28__length1 = reimport_state->alterations_length1;
#line 1515 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp28__length1 > 0) {
#line 11981 "Photo.c"
		gchar** _tmp29_ = NULL;
		gint _tmp29__length1 = 0;
		Alteration* _tmp30_ = NULL;
		Alteration* _tmp31_ = NULL;
#line 1516 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp29_ = reimport_state->alterations;
#line 1516 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp29__length1 = reimport_state->alterations_length1;
#line 1516 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp30_ = alteration_new_from_array (_tmp29_, _tmp29__length1);
#line 1516 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp31_ = _tmp30_;
#line 1516 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp31_);
#line 1516 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp31_);
#line 11998 "Photo.c"
	}
#line 1518 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp32_ = reimport_state->metadata;
#line 1518 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_notify_master_reimported (self, _tmp32_);
#line 1520 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp33_ = photo_is_master_baseline (self);
#line 1520 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp33_) {
#line 12008 "Photo.c"
		PhotoMetadata* _tmp34_ = NULL;
#line 1521 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp34_ = reimport_state->metadata;
#line 1521 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_baseline_reimported (self, _tmp34_);
#line 12014 "Photo.c"
	}
#line 1523 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp35_ = photo_is_master_source (self);
#line 1523 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp35_) {
#line 12020 "Photo.c"
		PhotoMetadata* _tmp36_ = NULL;
#line 1524 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp36_ = reimport_state->metadata;
#line 1524 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_source_reimported (self, _tmp36_);
#line 12026 "Photo.c"
	}
#line 1491 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_master_state_unref0 (reimport_state);
#line 12030 "Photo.c"
}


static gboolean photo_verify_file_for_reimport (Photo* self, GFile* file, BackingPhotoRow** backing, DetectedPhotoInformation** detected, GError** error) {
	BackingPhotoRow* _vala_backing = NULL;
	DetectedPhotoInformation* _vala_detected = NULL;
	gboolean result = FALSE;
	BackingPhotoRow* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	DetectedPhotoInformation* _tmp2_ = NULL;
	BackingPhotoRow* _tmp3_ = NULL;
	BackingPhotoRow* _tmp5_ = NULL;
	BackingPhotoRow* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	DetectedPhotoInformation* _tmp9_ = NULL;
	GdkColorspace _tmp10_ = 0;
	GError * _inner_error_ = NULL;
#line 1528 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 1528 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 1530 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = file;
#line 1530 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_query_backing_photo_row (self, _tmp1_, PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5, &_tmp2_, &_inner_error_);
#line 1530 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (_vala_detected);
#line 1530 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_detected = _tmp2_;
#line 1530 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _tmp3_;
#line 1530 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 12065 "Photo.c"
		gboolean _tmp4_ = FALSE;
#line 1530 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 1530 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp4_;
#line 12071 "Photo.c"
	}
#line 1530 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = _tmp0_;
#line 1530 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = NULL;
#line 1530 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_photo_row_unref0 (_vala_backing);
#line 1530 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_backing = _tmp5_;
#line 1532 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = _vala_backing;
#line 1532 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp6_ == NULL) {
#line 1533 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1533 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (_tmp0_);
#line 1533 "/home/jens/Source/shotwell/src/Photo.vala"
		if (backing) {
#line 1533 "/home/jens/Source/shotwell/src/Photo.vala"
			*backing = _vala_backing;
#line 12093 "Photo.c"
		} else {
#line 1533 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (_vala_backing);
#line 12097 "Photo.c"
		}
#line 1533 "/home/jens/Source/shotwell/src/Photo.vala"
		if (detected) {
#line 1533 "/home/jens/Source/shotwell/src/Photo.vala"
			*detected = _vala_detected;
#line 12103 "Photo.c"
		} else {
#line 1533 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (_vala_detected);
#line 12107 "Photo.c"
		}
#line 1533 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 12111 "Photo.c"
	}
#line 1537 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = _vala_detected;
#line 1537 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = _tmp9_->colorspace;
#line 1537 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp10_ != GDK_COLORSPACE_RGB) {
#line 1537 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp8_ = TRUE;
#line 12121 "Photo.c"
	} else {
		DetectedPhotoInformation* _tmp11_ = NULL;
		gint _tmp12_ = 0;
#line 1538 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = _vala_detected;
#line 1538 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = _tmp11_->channels;
#line 1538 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp8_ = _tmp12_ < 3;
#line 12131 "Photo.c"
	}
#line 1537 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp8_) {
#line 1537 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = TRUE;
#line 12137 "Photo.c"
	} else {
		DetectedPhotoInformation* _tmp13_ = NULL;
		gint _tmp14_ = 0;
#line 1539 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = _vala_detected;
#line 1539 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp14_ = _tmp13_->bits_per_channel;
#line 1539 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = _tmp14_ != 8;
#line 12147 "Photo.c"
	}
#line 1537 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp7_) {
#line 12151 "Photo.c"
		GFile* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
#line 1540 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = file;
#line 1540 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = g_file_get_path (_tmp15_);
#line 1540 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = _tmp16_;
#line 1540 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:1540: Not re-importing %s: Unsupported color format", _tmp17_);
#line 1540 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp17_);
#line 1542 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1542 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (_tmp0_);
#line 1542 "/home/jens/Source/shotwell/src/Photo.vala"
		if (backing) {
#line 1542 "/home/jens/Source/shotwell/src/Photo.vala"
			*backing = _vala_backing;
#line 12173 "Photo.c"
		} else {
#line 1542 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (_vala_backing);
#line 12177 "Photo.c"
		}
#line 1542 "/home/jens/Source/shotwell/src/Photo.vala"
		if (detected) {
#line 1542 "/home/jens/Source/shotwell/src/Photo.vala"
			*detected = _vala_detected;
#line 12183 "Photo.c"
		} else {
#line 1542 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (_vala_detected);
#line 12187 "Photo.c"
		}
#line 1542 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 12191 "Photo.c"
	}
#line 1545 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 1545 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_photo_row_unref0 (_tmp0_);
#line 1545 "/home/jens/Source/shotwell/src/Photo.vala"
	if (backing) {
#line 1545 "/home/jens/Source/shotwell/src/Photo.vala"
		*backing = _vala_backing;
#line 12201 "Photo.c"
	} else {
#line 1545 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (_vala_backing);
#line 12205 "Photo.c"
	}
#line 1545 "/home/jens/Source/shotwell/src/Photo.vala"
	if (detected) {
#line 1545 "/home/jens/Source/shotwell/src/Photo.vala"
		*detected = _vala_detected;
#line 12211 "Photo.c"
	} else {
#line 1545 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (_vala_detected);
#line 12215 "Photo.c"
	}
#line 1545 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 12219 "Photo.c"
}


gboolean photo_prepare_for_reimport_editable (Photo* self, PhotoReimportEditableState** state, GError** error) {
	PhotoReimportEditableState* _vala_state = NULL;
	gboolean result = FALSE;
	GFile* file = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	DetectedPhotoInformation* detected = NULL;
	BackingPhotoRow* backing = NULL;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp3_ = NULL;
	BackingPhotoRow* _tmp4_ = NULL;
	DetectedPhotoInformation* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	BackingPhotoRow* _tmp8_ = NULL;
	DetectedPhotoInformation* _tmp9_ = NULL;
	PhotoMetadata* _tmp10_ = NULL;
	PhotoReimportEditableStateImpl* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
#line 1549 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 1550 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_editable_state_unref0 (_vala_state);
#line 1550 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = NULL;
#line 1552 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_editable_file (self);
#line 1552 "/home/jens/Source/shotwell/src/Photo.vala"
	file = _tmp0_;
#line 1553 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = file;
#line 1553 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 1554 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1554 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1554 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 1554 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 12263 "Photo.c"
		} else {
#line 1554 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_editable_state_unref0 (_vala_state);
#line 12267 "Photo.c"
		}
#line 1554 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 12271 "Photo.c"
	}
#line 1558 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = file;
#line 1558 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = photo_verify_file_for_reimport (self, _tmp3_, &_tmp4_, &_tmp5_, &_inner_error_);
#line 1558 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_photo_row_unref0 (backing);
#line 1558 "/home/jens/Source/shotwell/src/Photo.vala"
	backing = _tmp4_;
#line 1558 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (detected);
#line 1558 "/home/jens/Source/shotwell/src/Photo.vala"
	detected = _tmp5_;
#line 1558 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = _tmp6_;
#line 1558 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 12289 "Photo.c"
		gboolean _tmp7_ = FALSE;
#line 1558 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 1558 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1558 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 1558 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1558 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp7_;
#line 12301 "Photo.c"
	}
#line 1558 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp2_) {
#line 1559 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1559 "/home/jens/Source/shotwell/src/Photo.vala"
		_backing_photo_row_unref0 (backing);
#line 1559 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 1559 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 1559 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 1559 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 12317 "Photo.c"
		} else {
#line 1559 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_editable_state_unref0 (_vala_state);
#line 12321 "Photo.c"
		}
#line 1559 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 12325 "Photo.c"
	}
#line 1561 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = backing;
#line 1561 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = detected;
#line 1561 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = _tmp9_->metadata;
#line 1561 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = photo_reimport_editable_state_impl_new (_tmp8_, _tmp10_);
#line 1561 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_editable_state_unref0 (_vala_state);
#line 1561 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableState);
#line 1563 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 1563 "/home/jens/Source/shotwell/src/Photo.vala"
	_backing_photo_row_unref0 (backing);
#line 1563 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (detected);
#line 1563 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (file);
#line 1563 "/home/jens/Source/shotwell/src/Photo.vala"
	if (state) {
#line 1563 "/home/jens/Source/shotwell/src/Photo.vala"
		*state = _vala_state;
#line 12351 "Photo.c"
	} else {
#line 1563 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_reimport_editable_state_unref0 (_vala_state);
#line 12355 "Photo.c"
	}
#line 1563 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 12359 "Photo.c"
}


static gpointer _photo_reimport_editable_state_ref0 (gpointer self) {
#line 1572 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? photo_reimport_editable_state_ref (self) : NULL;
#line 12366 "Photo.c"
}


void photo_finish_reimport_editable (Photo* self, PhotoReimportEditableState* state, GError** error) {
	BackingPhotoID editable_id = {0};
	BackingPhotoID _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	PhotoReimportEditableStateImpl* reimport_state = NULL;
	PhotoReimportEditableState* _tmp2_ = NULL;
	PhotoReimportEditableStateImpl* _tmp3_ = NULL;
	PhotoReimportEditableStateImpl* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	PhotoReimportEditableStateImpl* _tmp21_ = NULL;
	PhotoMetadata* _tmp22_ = NULL;
	gchar* list = NULL;
	gchar* _tmp36_ = NULL;
	PhotoReimportEditableStateImpl* _tmp37_ = NULL;
	gboolean _tmp38_ = FALSE;
	const gchar* _tmp41_ = NULL;
	Alteration* _tmp42_ = NULL;
	Alteration* _tmp43_ = NULL;
	PhotoReimportEditableStateImpl* _tmp44_ = NULL;
	PhotoMetadata* _tmp45_ = NULL;
	gboolean _tmp46_ = FALSE;
	gboolean _tmp49_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1567 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1567 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (PHOTO_IS_REIMPORT_EDITABLE_STATE (state));
#line 1568 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_get_editable_id (self, &_tmp0_);
#line 1568 "/home/jens/Source/shotwell/src/Photo.vala"
	editable_id = _tmp0_;
#line 1569 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = backing_photo_id_is_invalid (&editable_id);
#line 1569 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_) {
#line 1570 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 12407 "Photo.c"
	}
#line 1572 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = state;
#line 1572 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _photo_reimport_editable_state_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImpl));
#line 1572 "/home/jens/Source/shotwell/src/Photo.vala"
	reimport_state = _tmp3_;
#line 1574 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = reimport_state;
#line 1574 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = _tmp4_->metadata_only;
#line 1574 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp5_) {
#line 12421 "Photo.c"
		BackingPhotoTable* _tmp6_ = NULL;
		BackingPhotoTable* _tmp7_ = NULL;
		PhotoReimportEditableStateImpl* _tmp8_ = NULL;
		BackingPhotoRow* _tmp9_ = NULL;
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = backing_photo_table_get_instance ();
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = _tmp6_;
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp8_ = reimport_state;
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = _tmp8_->backing_state;
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
		backing_photo_table_update (_tmp7_, _tmp9_, &_inner_error_);
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
		_database_table_unref0 (_tmp7_);
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
				g_propagate_error (error, _inner_error_);
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_reimport_editable_state_unref0 (reimport_state);
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 12448 "Photo.c"
			} else {
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_reimport_editable_state_unref0 (reimport_state);
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 1575 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 12458 "Photo.c"
			}
		}
		{
			PhotoRow* _tmp10_ = NULL;
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = self->row;
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_lock (&self->priv->__lock_row);
#line 12467 "Photo.c"
			{
				PhotoReimportEditableStateImpl* _tmp11_ = NULL;
				BackingPhotoRow* _tmp12_ = NULL;
				BackingPhotoRow* _tmp13_ = NULL;
				PhotoReimportEditableStateImpl* _tmp14_ = NULL;
				BackingPhotoRow* _tmp15_ = NULL;
				Orientation _tmp16_ = 0;
#line 1578 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = reimport_state;
#line 1578 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = _tmp11_->backing_state;
#line 1578 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = _backing_photo_row_ref0 (_tmp12_);
#line 1578 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (self->priv->editable);
#line 1578 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->editable = _tmp13_;
#line 1579 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = reimport_state;
#line 1579 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = _tmp14_->backing_state;
#line 1579 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = _tmp15_->original_orientation;
#line 1579 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_set_orientation (self, _tmp16_);
#line 1580 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_internal_remove_all_transformations (self, FALSE);
#line 12495 "Photo.c"
			}
			__finally306:
			{
				PhotoRow* _tmp17_ = NULL;
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = self->row;
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 12504 "Photo.c"
			}
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
					g_propagate_error (error, _inner_error_);
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_reimport_editable_state_unref0 (reimport_state);
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 12516 "Photo.c"
				} else {
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_reimport_editable_state_unref0 (reimport_state);
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
					g_clear_error (&_inner_error_);
#line 1577 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 12526 "Photo.c"
				}
			}
		}
	} else {
		PhotoReimportEditableStateImpl* _tmp18_ = NULL;
		BackingPhotoRow* _tmp19_ = NULL;
		Orientation _tmp20_ = 0;
#line 1583 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = reimport_state;
#line 1583 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = _tmp18_->backing_state;
#line 1583 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = _tmp19_->original_orientation;
#line 1583 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_set_orientation (self, _tmp20_);
#line 12542 "Photo.c"
	}
#line 1586 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = reimport_state;
#line 1586 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = _tmp21_->metadata;
#line 1586 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp22_ != NULL) {
#line 12550 "Photo.c"
		PhotoReimportEditableStateImpl* _tmp23_ = NULL;
		PhotoMetadata* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		PhotoReimportEditableStateImpl* _tmp27_ = NULL;
		PhotoMetadata* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		PhotoReimportEditableStateImpl* _tmp31_ = NULL;
		PhotoMetadata* _tmp32_ = NULL;
		Rating _tmp33_ = 0;
		PhotoReimportEditableStateImpl* _tmp34_ = NULL;
		PhotoMetadata* _tmp35_ = NULL;
#line 1587 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23_ = reimport_state;
#line 1587 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp24_ = _tmp23_->metadata;
#line 1587 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp25_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1587 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp26_ = _tmp25_;
#line 1587 "/home/jens/Source/shotwell/src/Photo.vala"
		media_source_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp26_);
#line 1587 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp26_);
#line 1588 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp27_ = reimport_state;
#line 1588 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp28_ = _tmp27_->metadata;
#line 1588 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp29_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 1588 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp30_ = _tmp29_;
#line 1588 "/home/jens/Source/shotwell/src/Photo.vala"
		media_source_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp30_);
#line 1588 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp30_);
#line 1589 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp31_ = reimport_state;
#line 1589 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp32_ = _tmp31_->metadata;
#line 1589 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp33_ = photo_metadata_get_rating (_tmp32_);
#line 1589 "/home/jens/Source/shotwell/src/Photo.vala"
		media_source_set_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp33_);
#line 1590 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp34_ = reimport_state;
#line 1590 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp35_ = _tmp34_->metadata;
#line 1590 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_apply_user_metadata_for_reimport (self, _tmp35_);
#line 12602 "Photo.c"
	}
#line 1593 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp36_ = g_strdup ("metadata:name,image:orientation,metadata:rating,metadata:exposure-time");
#line 1593 "/home/jens/Source/shotwell/src/Photo.vala"
	list = _tmp36_;
#line 1594 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp37_ = reimport_state;
#line 1594 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp38_ = _tmp37_->metadata_only;
#line 1594 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp38_) {
#line 12614 "Photo.c"
		const gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
#line 1595 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp39_ = list;
#line 1595 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp40_ = g_strconcat (_tmp39_, "image:editable,image:baseline", NULL);
#line 1595 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (list);
#line 1595 "/home/jens/Source/shotwell/src/Photo.vala"
		list = _tmp40_;
#line 12625 "Photo.c"
	}
#line 1597 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp41_ = list;
#line 1597 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp42_ = alteration_new_from_list (_tmp41_);
#line 1597 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp43_ = _tmp42_;
#line 1597 "/home/jens/Source/shotwell/src/Photo.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp43_);
#line 1597 "/home/jens/Source/shotwell/src/Photo.vala"
	_alteration_unref0 (_tmp43_);
#line 1599 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp44_ = reimport_state;
#line 1599 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp45_ = _tmp44_->metadata;
#line 1599 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_notify_editable_reimported (self, _tmp45_);
#line 1601 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp46_ = photo_is_editable_baseline (self);
#line 1601 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp46_) {
#line 12647 "Photo.c"
		PhotoReimportEditableStateImpl* _tmp47_ = NULL;
		PhotoMetadata* _tmp48_ = NULL;
#line 1602 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp47_ = reimport_state;
#line 1602 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp48_ = _tmp47_->metadata;
#line 1602 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_baseline_reimported (self, _tmp48_);
#line 12656 "Photo.c"
	}
#line 1604 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp49_ = photo_is_editable_source (self);
#line 1604 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp49_) {
#line 12662 "Photo.c"
		PhotoReimportEditableStateImpl* _tmp50_ = NULL;
		PhotoMetadata* _tmp51_ = NULL;
#line 1605 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp50_ = reimport_state;
#line 1605 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp51_ = _tmp50_->metadata;
#line 1605 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_source_reimported (self, _tmp51_);
#line 12671 "Photo.c"
	}
#line 1567 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (list);
#line 1567 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_editable_state_unref0 (reimport_state);
#line 12677 "Photo.c"
}


static gpointer _photo_reimport_raw_development_state_ref0 (gpointer self) {
#line 1627 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? photo_reimport_raw_development_state_ref (self) : NULL;
#line 12684 "Photo.c"
}


gboolean photo_prepare_for_reimport_raw_development (Photo* self, PhotoReimportRawDevelopmentState** state, GError** error) {
	PhotoReimportRawDevelopmentState* _vala_state = NULL;
	gboolean result = FALSE;
	GeeCollection* files = NULL;
	GeeCollection* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	PhotoReimportRawDevelopmentStateImpl* reimport_state = NULL;
	PhotoReimportRawDevelopmentStateImpl* _tmp2_ = NULL;
	PhotoReimportRawDevelopmentStateImpl* _tmp19_ = NULL;
	PhotoReimportRawDevelopmentState* _tmp20_ = NULL;
	PhotoReimportRawDevelopmentStateImpl* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	GError * _inner_error_ = NULL;
#line 1609 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 1610 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_raw_development_state_unref0 (_vala_state);
#line 1610 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = NULL;
#line 1612 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_raw_developer_files (self);
#line 1612 "/home/jens/Source/shotwell/src/Photo.vala"
	files = _tmp0_;
#line 1613 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = files;
#line 1613 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 1614 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1614 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (files);
#line 1614 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 1614 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 12723 "Photo.c"
		} else {
#line 1614 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_raw_development_state_unref0 (_vala_state);
#line 12727 "Photo.c"
		}
#line 1614 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 12731 "Photo.c"
	}
#line 1616 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_reimport_raw_development_state_impl_new ();
#line 1616 "/home/jens/Source/shotwell/src/Photo.vala"
	reimport_state = _tmp2_;
#line 12737 "Photo.c"
	{
		GeeIterator* _file_it = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
#line 1618 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = files;
#line 1618 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1618 "/home/jens/Source/shotwell/src/Photo.vala"
		_file_it = _tmp4_;
#line 1618 "/home/jens/Source/shotwell/src/Photo.vala"
		while (TRUE) {
#line 12750 "Photo.c"
			GeeIterator* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			GFile* file = NULL;
			GeeIterator* _tmp7_ = NULL;
			gpointer _tmp8_ = NULL;
			DetectedPhotoInformation* detected = NULL;
			BackingPhotoRow* backing = NULL;
			gboolean _tmp9_ = FALSE;
			GFile* _tmp10_ = NULL;
			BackingPhotoRow* _tmp11_ = NULL;
			DetectedPhotoInformation* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			PhotoReimportRawDevelopmentStateImpl* _tmp15_ = NULL;
			BackingPhotoRow* _tmp16_ = NULL;
			DetectedPhotoInformation* _tmp17_ = NULL;
			PhotoMetadata* _tmp18_ = NULL;
#line 1618 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = _file_it;
#line 1618 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = gee_iterator_next (_tmp5_);
#line 1618 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!_tmp6_) {
#line 1618 "/home/jens/Source/shotwell/src/Photo.vala"
				break;
#line 12775 "Photo.c"
			}
#line 1618 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = _file_it;
#line 1618 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 1618 "/home/jens/Source/shotwell/src/Photo.vala"
			file = (GFile*) _tmp8_;
#line 1621 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = file;
#line 1621 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = photo_verify_file_for_reimport (self, _tmp10_, &_tmp11_, &_tmp12_, &_inner_error_);
#line 1621 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (backing);
#line 1621 "/home/jens/Source/shotwell/src/Photo.vala"
			backing = _tmp11_;
#line 1621 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (detected);
#line 1621 "/home/jens/Source/shotwell/src/Photo.vala"
			detected = _tmp12_;
#line 1621 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = _tmp13_;
#line 1621 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 12799 "Photo.c"
				gboolean _tmp14_ = FALSE;
#line 1621 "/home/jens/Source/shotwell/src/Photo.vala"
				g_propagate_error (error, _inner_error_);
#line 1621 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (backing);
#line 1621 "/home/jens/Source/shotwell/src/Photo.vala"
				_detected_photo_information_unref0 (detected);
#line 1621 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (file);
#line 1621 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_file_it);
#line 1621 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_reimport_raw_development_state_unref0 (reimport_state);
#line 1621 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (files);
#line 1621 "/home/jens/Source/shotwell/src/Photo.vala"
				return _tmp14_;
#line 12817 "Photo.c"
			}
#line 1621 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!_tmp9_) {
#line 1622 "/home/jens/Source/shotwell/src/Photo.vala"
				_backing_photo_row_unref0 (backing);
#line 1622 "/home/jens/Source/shotwell/src/Photo.vala"
				_detected_photo_information_unref0 (detected);
#line 1622 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (file);
#line 1622 "/home/jens/Source/shotwell/src/Photo.vala"
				continue;
#line 12829 "Photo.c"
			}
#line 1624 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = reimport_state;
#line 1624 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = backing;
#line 1624 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = detected;
#line 1624 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp18_ = _tmp17_->metadata;
#line 1624 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_reimport_raw_development_state_impl_add (_tmp15_, _tmp16_, _tmp18_);
#line 1618 "/home/jens/Source/shotwell/src/Photo.vala"
			_backing_photo_row_unref0 (backing);
#line 1618 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (detected);
#line 1618 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (file);
#line 12847 "Photo.c"
		}
#line 1618 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_file_it);
#line 12851 "Photo.c"
	}
#line 1627 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = reimport_state;
#line 1627 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = _photo_reimport_raw_development_state_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentState));
#line 1627 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_raw_development_state_unref0 (_vala_state);
#line 1627 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = _tmp20_;
#line 1628 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = reimport_state;
#line 1628 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = photo_reimport_raw_development_state_impl_get_size (_tmp21_);
#line 1628 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp22_ > 0;
#line 1628 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_raw_development_state_unref0 (reimport_state);
#line 1628 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (files);
#line 1628 "/home/jens/Source/shotwell/src/Photo.vala"
	if (state) {
#line 1628 "/home/jens/Source/shotwell/src/Photo.vala"
		*state = _vala_state;
#line 12875 "Photo.c"
	} else {
#line 1628 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_reimport_raw_development_state_unref0 (_vala_state);
#line 12879 "Photo.c"
	}
#line 1628 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 12883 "Photo.c"
}


void photo_finish_reimport_raw_development (Photo* self, PhotoReimportRawDevelopmentState* state, GError** error) {
	PhotoFileFormat _tmp0_ = 0;
	PhotoReimportRawDevelopmentStateImpl* reimport_state = NULL;
	PhotoReimportRawDevelopmentState* _tmp1_ = NULL;
	PhotoReimportRawDevelopmentStateImpl* _tmp2_ = NULL;
	gchar* list = NULL;
	gchar* _tmp32_ = NULL;
	PhotoReimportRawDevelopmentStateImpl* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	const gchar* _tmp37_ = NULL;
	Alteration* _tmp38_ = NULL;
	Alteration* _tmp39_ = NULL;
	GError * _inner_error_ = NULL;
#line 1632 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1632 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE (state));
#line 1633 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_master_file_format (self);
#line 1633 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp0_ != PHOTO_FILE_FORMAT_RAW) {
#line 1634 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 12910 "Photo.c"
	}
#line 1636 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = state;
#line 1636 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = _photo_reimport_raw_development_state_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL, PhotoReimportRawDevelopmentStateImpl));
#line 1636 "/home/jens/Source/shotwell/src/Photo.vala"
	reimport_state = _tmp2_;
#line 12918 "Photo.c"
	{
		GeeIterator* _dev_it = NULL;
		PhotoReimportRawDevelopmentStateImpl* _tmp3_ = NULL;
		GeeCollection* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = reimport_state;
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = _tmp3_->list;
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
		_dev_it = _tmp5_;
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
		while (TRUE) {
#line 12934 "Photo.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			PhotoReimportRawDevelopmentStateImplDevToReimport* dev = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			PhotoReimportRawDevelopmentStateImpl* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _dev_it;
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!_tmp7_) {
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
				break;
#line 12950 "Photo.c"
			}
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = _dev_it;
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
			dev = (PhotoReimportRawDevelopmentStateImplDevToReimport*) _tmp9_;
#line 1639 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = reimport_state;
#line 1639 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = _tmp10_->metadata_only;
#line 1639 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!_tmp11_) {
#line 12964 "Photo.c"
				BackingPhotoTable* _tmp12_ = NULL;
				BackingPhotoTable* _tmp13_ = NULL;
				PhotoReimportRawDevelopmentStateImplDevToReimport* _tmp14_ = NULL;
				BackingPhotoRow* _tmp15_ = NULL;
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = backing_photo_table_get_instance ();
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = _tmp12_;
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = dev;
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = _tmp14_->backing;
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
				backing_photo_table_update (_tmp13_, _tmp15_, &_inner_error_);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp13_);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
						g_propagate_error (error, _inner_error_);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (_dev_it);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_reimport_raw_development_state_unref0 (reimport_state);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
						return;
#line 12995 "Photo.c"
					} else {
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (_dev_it);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
						_photo_reimport_raw_development_state_unref0 (reimport_state);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
						g_clear_error (&_inner_error_);
#line 1640 "/home/jens/Source/shotwell/src/Photo.vala"
						return;
#line 13009 "Photo.c"
					}
				}
				{
					PhotoRow* _tmp16_ = NULL;
#line 1642 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp16_ = self->row;
#line 1642 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_lock (&self->priv->__lock_row);
#line 13018 "Photo.c"
					{
						gint _tmp17_ = 0;
						RawDeveloper* _tmp18_ = NULL;
#line 1644 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp18_ = raw_developer_as_array (&_tmp17_);
#line 13024 "Photo.c"
						{
							RawDeveloper* d_collection = NULL;
							gint d_collection_length1 = 0;
							gint _d_collection_size_ = 0;
							gint d_it = 0;
#line 1644 "/home/jens/Source/shotwell/src/Photo.vala"
							d_collection = _tmp18_;
#line 1644 "/home/jens/Source/shotwell/src/Photo.vala"
							d_collection_length1 = _tmp17_;
#line 1644 "/home/jens/Source/shotwell/src/Photo.vala"
							for (d_it = 0; d_it < _tmp17_; d_it = d_it + 1) {
#line 13036 "Photo.c"
								RawDeveloper d = 0;
#line 1644 "/home/jens/Source/shotwell/src/Photo.vala"
								d = d_collection[d_it];
#line 13040 "Photo.c"
								{
									BackingPhotoID id = {0};
									PhotoRow* _tmp19_ = NULL;
									BackingPhotoID* _tmp20_ = NULL;
									gint _tmp20__length1 = 0;
									RawDeveloper _tmp21_ = 0;
									BackingPhotoID _tmp22_ = {0};
									BackingPhotoID _tmp23_ = {0};
									gint64 _tmp24_ = 0LL;
#line 1645 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp19_ = self->row;
#line 1645 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp20_ = _tmp19_->development_ids;
#line 1645 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp20__length1 = _tmp19_->development_ids_length1;
#line 1645 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp21_ = d;
#line 1645 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp22_ = _tmp20_[_tmp21_];
#line 1645 "/home/jens/Source/shotwell/src/Photo.vala"
									id = _tmp22_;
#line 1646 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp23_ = id;
#line 1646 "/home/jens/Source/shotwell/src/Photo.vala"
									_tmp24_ = _tmp23_.id;
#line 1646 "/home/jens/Source/shotwell/src/Photo.vala"
									if (_tmp24_ != BACKING_PHOTO_ID_INVALID) {
#line 13068 "Photo.c"
										BackingPhotoRow* bpr = NULL;
										BackingPhotoID _tmp25_ = {0};
										BackingPhotoRow* _tmp26_ = NULL;
										BackingPhotoRow* _tmp27_ = NULL;
#line 1647 "/home/jens/Source/shotwell/src/Photo.vala"
										_tmp25_ = id;
#line 1647 "/home/jens/Source/shotwell/src/Photo.vala"
										_tmp26_ = photo_get_backing_row (self, &_tmp25_);
#line 1647 "/home/jens/Source/shotwell/src/Photo.vala"
										bpr = _tmp26_;
#line 1648 "/home/jens/Source/shotwell/src/Photo.vala"
										_tmp27_ = bpr;
#line 1648 "/home/jens/Source/shotwell/src/Photo.vala"
										if (_tmp27_ != NULL) {
#line 13083 "Photo.c"
											GeeHashMap* _tmp28_ = NULL;
											RawDeveloper _tmp29_ = 0;
											BackingPhotoRow* _tmp30_ = NULL;
#line 1649 "/home/jens/Source/shotwell/src/Photo.vala"
											_tmp28_ = self->priv->developments;
#line 1649 "/home/jens/Source/shotwell/src/Photo.vala"
											_tmp29_ = d;
#line 1649 "/home/jens/Source/shotwell/src/Photo.vala"
											_tmp30_ = bpr;
#line 1649 "/home/jens/Source/shotwell/src/Photo.vala"
											gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp29_), _tmp30_);
#line 13095 "Photo.c"
										}
#line 1646 "/home/jens/Source/shotwell/src/Photo.vala"
										_backing_photo_row_unref0 (bpr);
#line 13099 "Photo.c"
									}
								}
							}
#line 1644 "/home/jens/Source/shotwell/src/Photo.vala"
							d_collection = (g_free (d_collection), NULL);
#line 13105 "Photo.c"
						}
					}
					__finally307:
					{
						PhotoRow* _tmp31_ = NULL;
#line 1642 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp31_ = self->row;
#line 1642 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_row);
#line 13115 "Photo.c"
					}
#line 1642 "/home/jens/Source/shotwell/src/Photo.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1642 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_inner_error_->domain == DATABASE_ERROR) {
#line 1642 "/home/jens/Source/shotwell/src/Photo.vala"
							g_propagate_error (error, _inner_error_);
#line 1642 "/home/jens/Source/shotwell/src/Photo.vala"
							_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
#line 1642 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_object_unref0 (_dev_it);
#line 1642 "/home/jens/Source/shotwell/src/Photo.vala"
							_photo_reimport_raw_development_state_unref0 (reimport_state);
#line 1642 "/home/jens/Source/shotwell/src/Photo.vala"
							return;
#line 13131 "Photo.c"
						} else {
#line 1642 "/home/jens/Source/shotwell/src/Photo.vala"
							_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
#line 1642 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_object_unref0 (_dev_it);
#line 1642 "/home/jens/Source/shotwell/src/Photo.vala"
							_photo_reimport_raw_development_state_unref0 (reimport_state);
#line 1642 "/home/jens/Source/shotwell/src/Photo.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1642 "/home/jens/Source/shotwell/src/Photo.vala"
							g_clear_error (&_inner_error_);
#line 1642 "/home/jens/Source/shotwell/src/Photo.vala"
							return;
#line 13145 "Photo.c"
						}
					}
				}
			}
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
#line 13152 "Photo.c"
		}
#line 1638 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_dev_it);
#line 13156 "Photo.c"
	}
#line 1656 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp32_ = g_strdup ("metadata:name,image:orientation,metadata:rating,metadata:exposure-time");
#line 1656 "/home/jens/Source/shotwell/src/Photo.vala"
	list = _tmp32_;
#line 1657 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp33_ = reimport_state;
#line 1657 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp34_ = _tmp33_->metadata_only;
#line 1657 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp34_) {
#line 13168 "Photo.c"
		const gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
#line 1658 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp35_ = list;
#line 1658 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp36_ = g_strconcat (_tmp35_, "image:editable,image:baseline", NULL);
#line 1658 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (list);
#line 1658 "/home/jens/Source/shotwell/src/Photo.vala"
		list = _tmp36_;
#line 13179 "Photo.c"
	}
#line 1660 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp37_ = list;
#line 1660 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp38_ = alteration_new_from_list (_tmp37_);
#line 1660 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp39_ = _tmp38_;
#line 1660 "/home/jens/Source/shotwell/src/Photo.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp39_);
#line 1660 "/home/jens/Source/shotwell/src/Photo.vala"
	_alteration_unref0 (_tmp39_);
#line 1662 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_notify_raw_development_modified (self);
#line 1632 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (list);
#line 1632 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_raw_development_state_unref0 (reimport_state);
#line 13197 "Photo.c"
}


static gchar* photo_real_get_typename (DataSource* base) {
	Photo * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 1665 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 1666 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = g_strdup (PHOTO_TYPENAME);
#line 1666 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 1666 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 13213 "Photo.c"
}


static gint64 photo_real_get_instance_id (DataSource* base) {
	Photo * self;
	gint64 result = 0LL;
	PhotoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
#line 1669 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 1670 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_get_photo_id (self, &_tmp0_);
#line 1670 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_.id;
#line 1670 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp1_;
#line 1670 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 13232 "Photo.c"
}


static gchar* photo_real_get_source_id (DataSource* base) {
	Photo * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 1673 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 1677 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = data_source_get_typename (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource));
#line 1677 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1677 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = data_source_get_instance_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource));
#line 1677 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = g_strdup_printf ("%s%016" G_GINT64_MODIFIER "x", _tmp1_, _tmp2_);
#line 1677 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp3_;
#line 1677 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp1_);
#line 1677 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp4_;
#line 1677 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 13262 "Photo.c"
}


void photo_set_master_timestamp (Photo* self, GFileInfo* info) {
	GTimeVal modification = {0};
	GFileInfo* _tmp0_ = NULL;
	GTimeVal _tmp1_ = {0};
	gboolean _tmp21_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1681 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1681 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 1682 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = info;
#line 1682 "/home/jens/Source/shotwell/src/Photo.vala"
	g_file_info_get_modification_time (_tmp0_, &_tmp1_);
#line 1682 "/home/jens/Source/shotwell/src/Photo.vala"
	modification = _tmp1_;
#line 13282 "Photo.c"
	{
		{
			PhotoRow* _tmp2_ = NULL;
#line 1685 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->row;
#line 1685 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_lock (&self->priv->__lock_row);
#line 13290 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
				BackingPhotoRow* _tmp4_ = NULL;
				time_t _tmp5_ = 0;
				GTimeVal _tmp6_ = {0};
				glong _tmp7_ = 0L;
				PhotoTable* _tmp9_ = NULL;
				PhotoTable* _tmp10_ = NULL;
				PhotoRow* _tmp11_ = NULL;
				PhotoID _tmp12_ = {0};
				GTimeVal _tmp13_ = {0};
				glong _tmp14_ = 0L;
				PhotoRow* _tmp15_ = NULL;
				BackingPhotoRow* _tmp16_ = NULL;
				GTimeVal _tmp17_ = {0};
				glong _tmp18_ = 0L;
#line 1686 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 1686 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_->master;
#line 1686 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp4_->timestamp;
#line 1686 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = modification;
#line 1686 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = _tmp6_.tv_sec;
#line 1686 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp5_ == ((time_t) _tmp7_)) {
#line 13319 "Photo.c"
					{
						PhotoRow* _tmp8_ = NULL;
#line 1685 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp8_ = self->row;
#line 1685 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_row);
#line 13326 "Photo.c"
					}
#line 1687 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 13330 "Photo.c"
				}
#line 1689 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = photo_table_get_instance ();
#line 1689 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = _tmp9_;
#line 1689 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = self->row;
#line 1689 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = _tmp11_->photo_id;
#line 1689 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = modification;
#line 1689 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = _tmp13_.tv_sec;
#line 1689 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_table_update_timestamp (_tmp10_, &_tmp12_, (time_t) _tmp14_, &_inner_error_);
#line 1689 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp10_);
#line 1689 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 13350 "Photo.c"
					goto __finally309;
				}
#line 1690 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = self->row;
#line 1690 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = _tmp15_->master;
#line 1690 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = modification;
#line 1690 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = _tmp17_.tv_sec;
#line 1690 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_->timestamp = (time_t) _tmp18_;
#line 13363 "Photo.c"
			}
			__finally309:
			{
				PhotoRow* _tmp19_ = NULL;
#line 1685 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp19_ = self->row;
#line 1685 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 13372 "Photo.c"
			}
#line 1685 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1685 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 13378 "Photo.c"
					goto __catch308_database_error;
				}
#line 1685 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1685 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 1685 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 13387 "Photo.c"
			}
		}
	}
	goto __finally308;
	__catch308_database_error:
	{
		GError* err = NULL;
		GError* _tmp20_ = NULL;
#line 1684 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 1684 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 1693 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = err;
#line 1693 "/home/jens/Source/shotwell/src/Photo.vala"
		app_window_database_error (_tmp20_);
#line 1695 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 1695 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 13408 "Photo.c"
	}
	__finally308:
#line 1684 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1684 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1684 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1684 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 13419 "Photo.c"
	}
#line 1698 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = photo_is_master_baseline (self);
#line 1698 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp21_) {
#line 13425 "Photo.c"
		Alteration* _tmp22_ = NULL;
		Alteration* _tmp23_ = NULL;
#line 1699 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = alteration_new_from_list ("metadata:master-timestamp,metadata:baseline-timestamp");
#line 1699 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23_ = _tmp22_;
#line 1699 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp23_);
#line 1699 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp23_);
#line 13436 "Photo.c"
	} else {
		Alteration* _tmp24_ = NULL;
		Alteration* _tmp25_ = NULL;
#line 1701 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp24_ = alteration_new ("metadata", "master-timestamp");
#line 1701 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp25_ = _tmp24_;
#line 1701 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp25_);
#line 1701 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp25_);
#line 13448 "Photo.c"
	}
}


void photo_update_editable_modification_time (Photo* self, GFileInfo* info, GError** error) {
	GTimeVal modification = {0};
	GFileInfo* _tmp0_ = NULL;
	GTimeVal _tmp1_ = {0};
	gboolean altered = FALSE;
	gboolean _tmp20_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1705 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1705 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 1706 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = info;
#line 1706 "/home/jens/Source/shotwell/src/Photo.vala"
	g_file_info_get_modification_time (_tmp0_, &_tmp1_);
#line 1706 "/home/jens/Source/shotwell/src/Photo.vala"
	modification = _tmp1_;
#line 1708 "/home/jens/Source/shotwell/src/Photo.vala"
	altered = FALSE;
#line 13472 "Photo.c"
	{
		PhotoRow* _tmp2_ = NULL;
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = self->row;
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 13479 "Photo.c"
		{
			gboolean _tmp3_ = FALSE;
			PhotoRow* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
#line 1710 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 1710 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = backing_photo_id_is_valid (&_tmp4_->editable_id);
#line 1710 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp5_) {
#line 13490 "Photo.c"
				BackingPhotoRow* _tmp6_ = NULL;
				time_t _tmp7_ = 0;
				GTimeVal _tmp8_ = {0};
				glong _tmp9_ = 0L;
#line 1710 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = self->priv->editable;
#line 1710 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = _tmp6_->timestamp;
#line 1710 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = modification;
#line 1710 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = _tmp8_.tv_sec;
#line 1710 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = _tmp7_ != ((time_t) _tmp9_);
#line 13505 "Photo.c"
			} else {
#line 1710 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = FALSE;
#line 13509 "Photo.c"
			}
#line 1710 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp3_) {
#line 13513 "Photo.c"
				BackingPhotoTable* _tmp10_ = NULL;
				BackingPhotoTable* _tmp11_ = NULL;
				PhotoRow* _tmp12_ = NULL;
				BackingPhotoID _tmp13_ = {0};
				GTimeVal _tmp14_ = {0};
				glong _tmp15_ = 0L;
				BackingPhotoRow* _tmp16_ = NULL;
				GTimeVal _tmp17_ = {0};
				glong _tmp18_ = 0L;
#line 1711 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = backing_photo_table_get_instance ();
#line 1711 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = _tmp10_;
#line 1711 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = self->row;
#line 1711 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = _tmp12_->editable_id;
#line 1711 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = modification;
#line 1711 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = _tmp14_.tv_sec;
#line 1711 "/home/jens/Source/shotwell/src/Photo.vala"
				backing_photo_table_update_timestamp (_tmp11_, &_tmp13_, (time_t) _tmp15_, &_inner_error_);
#line 1711 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp11_);
#line 1711 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 13541 "Photo.c"
					goto __finally310;
				}
#line 1713 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = self->priv->editable;
#line 1713 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = modification;
#line 1713 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = _tmp17_.tv_sec;
#line 1713 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_->timestamp = (time_t) _tmp18_;
#line 1714 "/home/jens/Source/shotwell/src/Photo.vala"
				altered = TRUE;
#line 13554 "Photo.c"
			}
		}
		__finally310:
		{
			PhotoRow* _tmp19_ = NULL;
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp19_ = self->row;
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 13564 "Photo.c"
		}
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
				g_propagate_error (error, _inner_error_);
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 13574 "Photo.c"
			} else {
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 1709 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 13582 "Photo.c"
			}
		}
	}
#line 1718 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = altered;
#line 1718 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp20_) {
#line 13590 "Photo.c"
		Alteration* _tmp21_ = NULL;
		Alteration* _tmp22_ = NULL;
#line 1719 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = alteration_new_from_list ("metadata:editable-timestamp,metadata:baseline-timestamp");
#line 1719 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = _tmp21_;
#line 1719 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp22_);
#line 1719 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp22_);
#line 13601 "Photo.c"
	}
}


void photo_update_many_editable_timestamps (GeeMap* map, GError** error) {
	GError * _inner_error_ = NULL;
#line 1723 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (GEE_IS_MAP (map));
#line 1725 "/home/jens/Source/shotwell/src/Photo.vala"
	database_table_begin_transaction ();
#line 13612 "Photo.c"
	{
		GeeIterator* _photo_it = NULL;
		GeeMap* _tmp0_ = NULL;
		GeeSet* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = map;
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = gee_map_get_keys (_tmp0_);
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = _tmp1_;
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = _tmp2_;
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = _tmp4_;
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp3_);
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_it = _tmp5_;
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
		while (TRUE) {
#line 13639 "Photo.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			Photo* photo = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			Photo* _tmp10_ = NULL;
			GeeMap* _tmp11_ = NULL;
			Photo* _tmp12_ = NULL;
			gpointer _tmp13_ = NULL;
			GFileInfo* _tmp14_ = NULL;
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _photo_it;
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
			if (!_tmp7_) {
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
				break;
#line 13658 "Photo.c"
			}
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = _photo_it;
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
			photo = (Photo*) _tmp9_;
#line 1727 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = photo;
#line 1727 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = map;
#line 1727 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = photo;
#line 1727 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = gee_map_get (_tmp11_, _tmp12_);
#line 1727 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = (GFileInfo*) _tmp13_;
#line 1727 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_update_editable_modification_time (_tmp10_, _tmp14_, &_inner_error_);
#line 1727 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (_tmp14_);
#line 1727 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1727 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 1727 "/home/jens/Source/shotwell/src/Photo.vala"
					g_propagate_error (error, _inner_error_);
#line 1727 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (photo);
#line 1727 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (_photo_it);
#line 1727 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 13692 "Photo.c"
				} else {
#line 1727 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (photo);
#line 1727 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (_photo_it);
#line 1727 "/home/jens/Source/shotwell/src/Photo.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1727 "/home/jens/Source/shotwell/src/Photo.vala"
					g_clear_error (&_inner_error_);
#line 1727 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 13704 "Photo.c"
				}
			}
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (photo);
#line 13709 "Photo.c"
		}
#line 1726 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_photo_it);
#line 13713 "Photo.c"
	}
#line 1728 "/home/jens/Source/shotwell/src/Photo.vala"
	database_table_commit_transaction (&_inner_error_);
#line 1728 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1728 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1728 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 1728 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 13725 "Photo.c"
		} else {
#line 1728 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1728 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 1728 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 13733 "Photo.c"
		}
	}
}


static PhotoFileFormat photo_real_get_preferred_thumbnail_format (ThumbnailSource* base) {
	Photo * self;
	PhotoFileFormat result = 0;
	PhotoFileFormat _tmp0_ = 0;
	PhotoFileFormat _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
#line 1731 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 1732 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = photo_get_file_format (self);
#line 1732 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_format_can_write_image (_tmp1_);
#line 1732 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_) {
#line 13753 "Photo.c"
		PhotoFileFormat _tmp3_ = 0;
#line 1732 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = photo_get_file_format (self);
#line 1732 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = _tmp3_;
#line 13759 "Photo.c"
	} else {
		PhotoFileFormat _tmp4_ = 0;
#line 1733 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = photo_file_format_get_system_default_format ();
#line 1733 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = _tmp4_;
#line 13766 "Photo.c"
	}
#line 1732 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 1732 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 13772 "Photo.c"
}


static GdkPixbuf* photo_real_create_thumbnail (ThumbnailSource* base, gint scale, GError** error) {
	Photo * self;
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	Scaling _tmp2_ = {0};
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 1736 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 1737 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = scale;
#line 1737 "/home/jens/Source/shotwell/src/Photo.vala"
	scaling_for_best_fit (_tmp1_, TRUE, &_tmp2_);
#line 1737 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp2_, &_inner_error_);
#line 1737 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _tmp3_;
#line 1737 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1737 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 1737 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 13801 "Photo.c"
	}
#line 1737 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp0_;
#line 1737 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = NULL;
#line 1737 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp4_;
#line 1737 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp0_);
#line 1737 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 13813 "Photo.c"
}


gboolean photo_is_file_image (GFile* file) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 1740 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 1744 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = file;
#line 1744 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_format_is_file_supported (_tmp1_);
#line 1744 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_) {
#line 1745 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = TRUE;
#line 13832 "Photo.c"
	} else {
		GFile* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 1745 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = file;
#line 1745 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = g_file_get_basename (_tmp3_);
#line 1745 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = _tmp4_;
#line 1745 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = photo_is_extension_found (_tmp5_, PHOTO_IMAGE_EXTENSIONS, G_N_ELEMENTS (PHOTO_IMAGE_EXTENSIONS));
#line 1745 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = _tmp6_;
#line 1745 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp5_);
#line 13850 "Photo.c"
	}
#line 1744 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 1744 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 13856 "Photo.c"
}


static gboolean photo_is_extension_found (const gchar* basename, gchar** extensions, int extensions_length1) {
	gboolean result = FALSE;
	gchar* name = NULL;
	gchar* ext = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
#line 1748 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (basename != NULL, FALSE);
#line 1750 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = basename;
#line 1750 "/home/jens/Source/shotwell/src/Photo.vala"
	disassemble_filename (_tmp0_, &_tmp1_, &_tmp2_);
#line 1750 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (name);
#line 1750 "/home/jens/Source/shotwell/src/Photo.vala"
	name = _tmp1_;
#line 1750 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (ext);
#line 1750 "/home/jens/Source/shotwell/src/Photo.vala"
	ext = _tmp2_;
#line 1751 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = ext;
#line 1751 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp3_ == NULL) {
#line 1752 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 1752 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (ext);
#line 1752 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (name);
#line 1752 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 13898 "Photo.c"
	}
#line 1755 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = ext;
#line 1755 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
#line 1755 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (ext);
#line 1755 "/home/jens/Source/shotwell/src/Photo.vala"
	ext = _tmp5_;
#line 1758 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = extensions;
#line 1758 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6__length1 = extensions_length1;
#line 13912 "Photo.c"
	{
		gchar** extension_collection = NULL;
		gint extension_collection_length1 = 0;
		gint _extension_collection_size_ = 0;
		gint extension_it = 0;
#line 1758 "/home/jens/Source/shotwell/src/Photo.vala"
		extension_collection = _tmp6_;
#line 1758 "/home/jens/Source/shotwell/src/Photo.vala"
		extension_collection_length1 = _tmp6__length1;
#line 1758 "/home/jens/Source/shotwell/src/Photo.vala"
		for (extension_it = 0; extension_it < _tmp6__length1; extension_it = extension_it + 1) {
#line 13924 "Photo.c"
			gchar* _tmp7_ = NULL;
			gchar* extension = NULL;
#line 1758 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = g_strdup (extension_collection[extension_it]);
#line 1758 "/home/jens/Source/shotwell/src/Photo.vala"
			extension = _tmp7_;
#line 13931 "Photo.c"
			{
				const gchar* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
#line 1759 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = ext;
#line 1759 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = extension;
#line 1759 "/home/jens/Source/shotwell/src/Photo.vala"
				if (g_strcmp0 (_tmp8_, _tmp9_) == 0) {
#line 1760 "/home/jens/Source/shotwell/src/Photo.vala"
					result = TRUE;
#line 1760 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_free0 (extension);
#line 1760 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_free0 (ext);
#line 1760 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_free0 (name);
#line 1760 "/home/jens/Source/shotwell/src/Photo.vala"
					return result;
#line 13951 "Photo.c"
				}
#line 1758 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (extension);
#line 13955 "Photo.c"
			}
		}
	}
#line 1763 "/home/jens/Source/shotwell/src/Photo.vala"
	result = FALSE;
#line 1763 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (ext);
#line 1763 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (name);
#line 1763 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 13967 "Photo.c"
}


gboolean photo_is_duplicate (GFile* file, const gchar* thumbnail_md5, const gchar* full_md5, PhotoFileFormat file_format) {
	gboolean result = FALSE;
	PhotoTable* _tmp0_ = NULL;
	PhotoTable* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	PhotoFileFormat _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
#line 1769 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((file == NULL) || G_IS_FILE (file), FALSE);
#line 1772 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_table_get_instance ();
#line 1772 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1772 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = file;
#line 1772 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = thumbnail_md5;
#line 1772 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = full_md5;
#line 1772 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = file_format;
#line 1772 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = photo_table_has_duplicate (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1772 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = _tmp6_;
#line 1772 "/home/jens/Source/shotwell/src/Photo.vala"
	_database_table_unref0 (_tmp1_);
#line 1772 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp7_;
#line 1772 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 14005 "Photo.c"
}


PhotoID* photo_get_duplicate_ids (GFile* file, const gchar* thumbnail_md5, const gchar* full_md5, PhotoFileFormat file_format, int* result_length1) {
	PhotoID* result = NULL;
	PhotoTable* _tmp0_ = NULL;
	PhotoTable* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	PhotoFileFormat _tmp5_ = 0;
	gint _tmp6_ = 0;
	PhotoID* _tmp7_ = NULL;
	PhotoID* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	PhotoID* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
#line 1778 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((file == NULL) || G_IS_FILE (file), NULL);
#line 1781 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_table_get_instance ();
#line 1781 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1781 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = file;
#line 1781 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = thumbnail_md5;
#line 1781 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = full_md5;
#line 1781 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = file_format;
#line 1781 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = photo_table_get_duplicate_ids (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_, &_tmp6_);
#line 1781 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = _tmp7_;
#line 1781 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8__length1 = _tmp6_;
#line 1781 "/home/jens/Source/shotwell/src/Photo.vala"
	_database_table_unref0 (_tmp1_);
#line 1781 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = _tmp8_;
#line 1781 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9__length1 = _tmp8__length1;
#line 1781 "/home/jens/Source/shotwell/src/Photo.vala"
	if (result_length1) {
#line 1781 "/home/jens/Source/shotwell/src/Photo.vala"
		*result_length1 = _tmp9__length1;
#line 14053 "Photo.c"
	}
#line 1781 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp9_;
#line 1781 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 14059 "Photo.c"
}


gint64 photo_get_photo_key (DataSource* source) {
	gint64 result = 0LL;
	DataSource* _tmp0_ = NULL;
	PhotoID _tmp1_ = {0};
	gint64 _tmp2_ = 0LL;
#line 1788 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), 0LL);
#line 1789 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = source;
#line 1789 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_get_photo_id (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_LIBRARY_PHOTO, LibraryPhoto), TYPE_PHOTO, Photo), &_tmp1_);
#line 1789 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = _tmp1_.id;
#line 1789 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp2_;
#line 1789 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 14080 "Photo.c"
}


static GFile* photo_real_get_file (MediaSource* base) {
	Photo * self;
	GFile* result = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
#line 1807 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 1808 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_source_reader (self);
#line 1808 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1808 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1808 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_;
#line 1808 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp1_);
#line 1808 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp3_;
#line 1808 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 14107 "Photo.c"
}


static void _vala_array_add96 (gchar*** array, int* length, int* size, gchar* value) {
#line 1851 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1851 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1851 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 14118 "Photo.c"
	}
#line 1851 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1851 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 14124 "Photo.c"
}


static void _vala_array_add97 (gchar*** array, int* length, int* size, gchar* value) {
#line 1856 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1856 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1856 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 14135 "Photo.c"
	}
#line 1856 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1856 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 14141 "Photo.c"
}


static void _vala_array_add98 (gchar*** array, int* length, int* size, gchar* value) {
#line 1859 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1859 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1859 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 14152 "Photo.c"
	}
#line 1859 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1859 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 14158 "Photo.c"
}


static void _vala_array_add99 (gchar*** array, int* length, int* size, gchar* value) {
#line 1862 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1862 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1862 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 14169 "Photo.c"
	}
#line 1862 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1862 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 14175 "Photo.c"
}


void photo_set_master_file (Photo* self, GFile* file) {
	gchar* filepath = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean altered = FALSE;
	gboolean is_baseline = FALSE;
	gboolean is_source = FALSE;
	gboolean name_changed = FALSE;
	GFile* old_file = NULL;
	gboolean _tmp41_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1813 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1813 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 1814 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = file;
#line 1814 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 1814 "/home/jens/Source/shotwell/src/Photo.vala"
	filepath = _tmp1_;
#line 1816 "/home/jens/Source/shotwell/src/Photo.vala"
	altered = FALSE;
#line 1817 "/home/jens/Source/shotwell/src/Photo.vala"
	is_baseline = FALSE;
#line 1818 "/home/jens/Source/shotwell/src/Photo.vala"
	is_source = FALSE;
#line 1819 "/home/jens/Source/shotwell/src/Photo.vala"
	name_changed = FALSE;
#line 1820 "/home/jens/Source/shotwell/src/Photo.vala"
	old_file = NULL;
#line 14210 "Photo.c"
	{
		{
			PhotoRow* _tmp2_ = NULL;
#line 1822 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->row;
#line 1822 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_lock (&self->priv->__lock_row);
#line 14218 "Photo.c"
			{
				{
					PhotoBackingReaders* _tmp3_ = NULL;
#line 1823 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp3_ = self->priv->readers;
#line 1823 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_lock (&self->priv->__lock_readers);
#line 14226 "Photo.c"
					{
						PhotoBackingReaders* _tmp4_ = NULL;
						PhotoFileReader* _tmp5_ = NULL;
						GFile* _tmp6_ = NULL;
						GFile* _tmp7_ = NULL;
						GFile* _tmp8_ = NULL;
						gboolean _tmp9_ = FALSE;
#line 1824 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp4_ = self->priv->readers;
#line 1824 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp5_ = _tmp4_->master;
#line 1824 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp6_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1824 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (old_file);
#line 1824 "/home/jens/Source/shotwell/src/Photo.vala"
						old_file = _tmp6_;
#line 1825 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp7_ = file;
#line 1825 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp8_ = old_file;
#line 1825 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp9_ = g_file_equal (_tmp7_, _tmp8_);
#line 1825 "/home/jens/Source/shotwell/src/Photo.vala"
						if (!_tmp9_) {
#line 14252 "Photo.c"
							PhotoTable* _tmp10_ = NULL;
							PhotoTable* _tmp11_ = NULL;
							PhotoID _tmp12_ = {0};
							const gchar* _tmp13_ = NULL;
							PhotoRow* _tmp14_ = NULL;
							BackingPhotoRow* _tmp15_ = NULL;
							const gchar* _tmp16_ = NULL;
							gchar* _tmp17_ = NULL;
							GFile* _tmp18_ = NULL;
							gchar* _tmp19_ = NULL;
							PhotoBackingReaders* _tmp20_ = NULL;
							PhotoRow* _tmp21_ = NULL;
							BackingPhotoRow* _tmp22_ = NULL;
							PhotoFileFormat _tmp23_ = 0;
							const gchar* _tmp24_ = NULL;
							PhotoFileReader* _tmp25_ = NULL;
							gboolean _tmp26_ = FALSE;
							gboolean _tmp27_ = FALSE;
							gboolean _tmp28_ = FALSE;
							PhotoRow* _tmp29_ = NULL;
							const gchar* _tmp30_ = NULL;
							gboolean _tmp31_ = FALSE;
#line 1826 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp10_ = photo_table_get_instance ();
#line 1826 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp11_ = _tmp10_;
#line 1826 "/home/jens/Source/shotwell/src/Photo.vala"
							photo_get_photo_id (self, &_tmp12_);
#line 1826 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp13_ = filepath;
#line 1826 "/home/jens/Source/shotwell/src/Photo.vala"
							photo_table_set_filepath (_tmp11_, &_tmp12_, _tmp13_, &_inner_error_);
#line 1826 "/home/jens/Source/shotwell/src/Photo.vala"
							_database_table_unref0 (_tmp11_);
#line 1826 "/home/jens/Source/shotwell/src/Photo.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 14289 "Photo.c"
								goto __finally313;
							}
#line 1828 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp14_ = self->row;
#line 1828 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp15_ = _tmp14_->master;
#line 1828 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp16_ = filepath;
#line 1828 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp17_ = g_strdup (_tmp16_);
#line 1828 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_free0 (_tmp15_->filepath);
#line 1828 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp15_->filepath = _tmp17_;
#line 1829 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp18_ = file;
#line 1829 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp19_ = g_file_get_basename (_tmp18_);
#line 1829 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_free0 (self->priv->file_title);
#line 1829 "/home/jens/Source/shotwell/src/Photo.vala"
							self->priv->file_title = _tmp19_;
#line 1830 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp20_ = self->priv->readers;
#line 1830 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp21_ = self->row;
#line 1830 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp22_ = _tmp21_->master;
#line 1830 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp23_ = _tmp22_->file_format;
#line 1830 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp24_ = filepath;
#line 1830 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp25_ = photo_file_format_create_reader (_tmp23_, _tmp24_);
#line 1830 "/home/jens/Source/shotwell/src/Photo.vala"
							_photo_file_adapter_unref0 (_tmp20_->master);
#line 1830 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp20_->master = _tmp25_;
#line 1832 "/home/jens/Source/shotwell/src/Photo.vala"
							altered = TRUE;
#line 1833 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp26_ = photo_is_master_baseline (self);
#line 1833 "/home/jens/Source/shotwell/src/Photo.vala"
							is_baseline = _tmp26_;
#line 1834 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp27_ = photo_is_master_source (self);
#line 1834 "/home/jens/Source/shotwell/src/Photo.vala"
							is_source = _tmp27_;
#line 1835 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp29_ = self->row;
#line 1835 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp30_ = _tmp29_->title;
#line 1835 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp31_ = is_string_empty (_tmp30_);
#line 1835 "/home/jens/Source/shotwell/src/Photo.vala"
							if (_tmp31_) {
#line 14346 "Photo.c"
								GFile* _tmp32_ = NULL;
								gchar* _tmp33_ = NULL;
								gchar* _tmp34_ = NULL;
								GFile* _tmp35_ = NULL;
								gchar* _tmp36_ = NULL;
								gchar* _tmp37_ = NULL;
#line 1836 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp32_ = old_file;
#line 1836 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp33_ = g_file_get_basename (_tmp32_);
#line 1836 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp34_ = _tmp33_;
#line 1836 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp35_ = file;
#line 1836 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp36_ = g_file_get_basename (_tmp35_);
#line 1836 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp37_ = _tmp36_;
#line 1836 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp28_ = g_strcmp0 (_tmp34_, _tmp37_) != 0;
#line 1836 "/home/jens/Source/shotwell/src/Photo.vala"
								_g_free0 (_tmp37_);
#line 1836 "/home/jens/Source/shotwell/src/Photo.vala"
								_g_free0 (_tmp34_);
#line 14371 "Photo.c"
							} else {
#line 1835 "/home/jens/Source/shotwell/src/Photo.vala"
								_tmp28_ = FALSE;
#line 14375 "Photo.c"
							}
#line 1835 "/home/jens/Source/shotwell/src/Photo.vala"
							name_changed = _tmp28_;
#line 14379 "Photo.c"
						}
					}
					__finally313:
					{
						PhotoBackingReaders* _tmp38_ = NULL;
#line 1823 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp38_ = self->priv->readers;
#line 1823 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 14389 "Photo.c"
					}
#line 1823 "/home/jens/Source/shotwell/src/Photo.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 14393 "Photo.c"
						goto __finally312;
					}
				}
			}
			__finally312:
			{
				PhotoRow* _tmp39_ = NULL;
#line 1822 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp39_ = self->row;
#line 1822 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 14405 "Photo.c"
			}
#line 1822 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1822 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 14411 "Photo.c"
					goto __catch311_database_error;
				}
#line 1822 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (old_file);
#line 1822 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (filepath);
#line 1822 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1822 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 1822 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 14424 "Photo.c"
			}
		}
	}
	goto __finally311;
	__catch311_database_error:
	{
		GError* err = NULL;
		GError* _tmp40_ = NULL;
#line 1821 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 1821 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 1841 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp40_ = err;
#line 1841 "/home/jens/Source/shotwell/src/Photo.vala"
		app_window_database_error (_tmp40_);
#line 1821 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 14443 "Photo.c"
	}
	__finally311:
#line 1821 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1821 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (old_file);
#line 1821 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (filepath);
#line 1821 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1821 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1821 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 14458 "Photo.c"
	}
#line 1844 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp41_ = altered;
#line 1844 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp41_) {
#line 14464 "Photo.c"
		GFile* _tmp42_ = NULL;
		GFile* _tmp43_ = NULL;
		gboolean _tmp44_ = FALSE;
		gchar** alteration_list = NULL;
		gchar** _tmp45_ = NULL;
		gint alteration_list_length1 = 0;
		gint _alteration_list_size_ = 0;
		gchar** _tmp46_ = NULL;
		gint _tmp46__length1 = 0;
		gchar* _tmp47_ = NULL;
		gboolean _tmp48_ = FALSE;
		gboolean _tmp51_ = FALSE;
		gboolean _tmp54_ = FALSE;
		gchar** _tmp57_ = NULL;
		gint _tmp57__length1 = 0;
		Alteration* _tmp58_ = NULL;
		Alteration* _tmp59_ = NULL;
#line 1845 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp42_ = old_file;
#line 1845 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp43_ = file;
#line 1845 "/home/jens/Source/shotwell/src/Photo.vala"
		media_source_notify_master_replaced (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp42_, _tmp43_);
#line 1847 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp44_ = is_baseline;
#line 1847 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp44_) {
#line 1848 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_notify_baseline_replaced (self);
#line 14494 "Photo.c"
		}
#line 1850 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp45_ = g_new0 (gchar*, 0 + 1);
#line 1850 "/home/jens/Source/shotwell/src/Photo.vala"
		alteration_list = _tmp45_;
#line 1850 "/home/jens/Source/shotwell/src/Photo.vala"
		alteration_list_length1 = 0;
#line 1850 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_list_size_ = alteration_list_length1;
#line 1851 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp46_ = alteration_list;
#line 1851 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp46__length1 = alteration_list_length1;
#line 1851 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp47_ = g_strdup ("backing:master");
#line 1851 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_array_add96 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp47_);
#line 1855 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp48_ = name_changed;
#line 1855 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp48_) {
#line 14516 "Photo.c"
			gchar** _tmp49_ = NULL;
			gint _tmp49__length1 = 0;
			gchar* _tmp50_ = NULL;
#line 1856 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp49_ = alteration_list;
#line 1856 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp49__length1 = alteration_list_length1;
#line 1856 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp50_ = g_strdup ("metadata:name");
#line 1856 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add97 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp50_);
#line 14528 "Photo.c"
		}
#line 1858 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp51_ = is_source;
#line 1858 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp51_) {
#line 14534 "Photo.c"
			gchar** _tmp52_ = NULL;
			gint _tmp52__length1 = 0;
			gchar* _tmp53_ = NULL;
#line 1859 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp52_ = alteration_list;
#line 1859 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp52__length1 = alteration_list_length1;
#line 1859 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp53_ = g_strdup ("backing:source");
#line 1859 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add98 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp53_);
#line 14546 "Photo.c"
		}
#line 1861 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp54_ = is_baseline;
#line 1861 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp54_) {
#line 14552 "Photo.c"
			gchar** _tmp55_ = NULL;
			gint _tmp55__length1 = 0;
			gchar* _tmp56_ = NULL;
#line 1862 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp55_ = alteration_list;
#line 1862 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp55__length1 = alteration_list_length1;
#line 1862 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp56_ = g_strdup ("backing:baseline");
#line 1862 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add99 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp56_);
#line 14564 "Photo.c"
		}
#line 1864 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp57_ = alteration_list;
#line 1864 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp57__length1 = alteration_list_length1;
#line 1864 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp58_ = alteration_new_from_array (_tmp57_, _tmp57__length1);
#line 1864 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp59_ = _tmp58_;
#line 1864 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp59_);
#line 1864 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp59_);
#line 1844 "/home/jens/Source/shotwell/src/Photo.vala"
		alteration_list = (_vala_array_free (alteration_list, alteration_list_length1, (GDestroyNotify) g_free), NULL);
#line 14580 "Photo.c"
	}
#line 1813 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (old_file);
#line 1813 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (filepath);
#line 14586 "Photo.c"
}


static void _vala_array_add100 (gchar*** array, int* length, int* size, gchar* value) {
#line 1904 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1904 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1904 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 14597 "Photo.c"
	}
#line 1904 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1904 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 14603 "Photo.c"
}


static void _vala_array_add101 (gchar*** array, int* length, int* size, gchar* value) {
#line 1907 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1907 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1907 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 14614 "Photo.c"
	}
#line 1907 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1907 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 14620 "Photo.c"
}


static void _vala_array_add102 (gchar*** array, int* length, int* size, gchar* value) {
#line 1910 "/home/jens/Source/shotwell/src/Photo.vala"
	if ((*length) == (*size)) {
#line 1910 "/home/jens/Source/shotwell/src/Photo.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1910 "/home/jens/Source/shotwell/src/Photo.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 14631 "Photo.c"
	}
#line 1910 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[(*length)++] = value;
#line 1910 "/home/jens/Source/shotwell/src/Photo.vala"
	(*array)[*length] = NULL;
#line 14637 "Photo.c"
}


void photo_set_editable_file (Photo* self, GFile* file) {
	gchar* filepath = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean altered = FALSE;
	gboolean is_baseline = FALSE;
	gboolean is_source = FALSE;
	GFile* old_file = NULL;
	gboolean _tmp34_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1870 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 1870 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 1871 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = file;
#line 1871 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 1871 "/home/jens/Source/shotwell/src/Photo.vala"
	filepath = _tmp1_;
#line 1873 "/home/jens/Source/shotwell/src/Photo.vala"
	altered = FALSE;
#line 1874 "/home/jens/Source/shotwell/src/Photo.vala"
	is_baseline = FALSE;
#line 1875 "/home/jens/Source/shotwell/src/Photo.vala"
	is_source = FALSE;
#line 1876 "/home/jens/Source/shotwell/src/Photo.vala"
	old_file = NULL;
#line 14669 "Photo.c"
	{
		{
			PhotoRow* _tmp2_ = NULL;
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->row;
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_lock (&self->priv->__lock_row);
#line 14677 "Photo.c"
			{
				{
					PhotoBackingReaders* _tmp3_ = NULL;
#line 1879 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp3_ = self->priv->readers;
#line 1879 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_lock (&self->priv->__lock_readers);
#line 14685 "Photo.c"
					{
						GFile* _tmp4_ = NULL;
						PhotoBackingReaders* _tmp5_ = NULL;
						PhotoFileReader* _tmp6_ = NULL;
						GFile* _tmp10_ = NULL;
						gboolean _tmp11_ = FALSE;
						GFile* _tmp12_ = NULL;
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp5_ = self->priv->readers;
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp6_ = _tmp5_->editable;
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp6_ != NULL) {
#line 14699 "Photo.c"
							PhotoBackingReaders* _tmp7_ = NULL;
							PhotoFileReader* _tmp8_ = NULL;
							GFile* _tmp9_ = NULL;
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp7_ = self->priv->readers;
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp8_ = _tmp7_->editable;
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp9_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_object_unref0 (_tmp4_);
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp4_ = _tmp9_;
#line 14713 "Photo.c"
						} else {
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_object_unref0 (_tmp4_);
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp4_ = NULL;
#line 14719 "Photo.c"
						}
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp10_ = _g_object_ref0 (_tmp4_);
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (old_file);
#line 1880 "/home/jens/Source/shotwell/src/Photo.vala"
						old_file = _tmp10_;
#line 1881 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp12_ = old_file;
#line 1881 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp12_ != NULL) {
#line 14731 "Photo.c"
							GFile* _tmp13_ = NULL;
							GFile* _tmp14_ = NULL;
							gboolean _tmp15_ = FALSE;
#line 1881 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp13_ = old_file;
#line 1881 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp14_ = file;
#line 1881 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp15_ = g_file_equal (_tmp13_, _tmp14_);
#line 1881 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp11_ = !_tmp15_;
#line 14743 "Photo.c"
						} else {
#line 1881 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp11_ = FALSE;
#line 14747 "Photo.c"
						}
#line 1881 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp11_) {
#line 14751 "Photo.c"
							BackingPhotoTable* _tmp16_ = NULL;
							BackingPhotoTable* _tmp17_ = NULL;
							PhotoRow* _tmp18_ = NULL;
							BackingPhotoID _tmp19_ = {0};
							const gchar* _tmp20_ = NULL;
							BackingPhotoRow* _tmp21_ = NULL;
							const gchar* _tmp22_ = NULL;
							gchar* _tmp23_ = NULL;
							PhotoBackingReaders* _tmp24_ = NULL;
							BackingPhotoRow* _tmp25_ = NULL;
							PhotoFileFormat _tmp26_ = 0;
							const gchar* _tmp27_ = NULL;
							PhotoFileReader* _tmp28_ = NULL;
							gboolean _tmp29_ = FALSE;
							gboolean _tmp30_ = FALSE;
#line 1882 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp16_ = backing_photo_table_get_instance ();
#line 1882 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp17_ = _tmp16_;
#line 1882 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp18_ = self->row;
#line 1882 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp19_ = _tmp18_->editable_id;
#line 1882 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp20_ = filepath;
#line 1882 "/home/jens/Source/shotwell/src/Photo.vala"
							backing_photo_table_set_filepath (_tmp17_, &_tmp19_, _tmp20_, &_inner_error_);
#line 1882 "/home/jens/Source/shotwell/src/Photo.vala"
							_database_table_unref0 (_tmp17_);
#line 1882 "/home/jens/Source/shotwell/src/Photo.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1882 "/home/jens/Source/shotwell/src/Photo.vala"
								_g_object_unref0 (_tmp4_);
#line 14785 "Photo.c"
								goto __finally316;
							}
#line 1884 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp21_ = self->priv->editable;
#line 1884 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp22_ = filepath;
#line 1884 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp23_ = g_strdup (_tmp22_);
#line 1884 "/home/jens/Source/shotwell/src/Photo.vala"
							_g_free0 (_tmp21_->filepath);
#line 1884 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp21_->filepath = _tmp23_;
#line 1885 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp24_ = self->priv->readers;
#line 1885 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp25_ = self->priv->editable;
#line 1885 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp26_ = _tmp25_->file_format;
#line 1885 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp27_ = filepath;
#line 1885 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp28_ = photo_file_format_create_reader (_tmp26_, _tmp27_);
#line 1885 "/home/jens/Source/shotwell/src/Photo.vala"
							_photo_file_adapter_unref0 (_tmp24_->editable);
#line 1885 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp24_->editable = _tmp28_;
#line 1887 "/home/jens/Source/shotwell/src/Photo.vala"
							altered = TRUE;
#line 1888 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp29_ = photo_is_editable_baseline (self);
#line 1888 "/home/jens/Source/shotwell/src/Photo.vala"
							is_baseline = _tmp29_;
#line 1889 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp30_ = photo_is_editable_source (self);
#line 1889 "/home/jens/Source/shotwell/src/Photo.vala"
							is_source = _tmp30_;
#line 14822 "Photo.c"
						}
#line 1879 "/home/jens/Source/shotwell/src/Photo.vala"
						_g_object_unref0 (_tmp4_);
#line 14826 "Photo.c"
					}
					__finally316:
					{
						PhotoBackingReaders* _tmp31_ = NULL;
#line 1879 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp31_ = self->priv->readers;
#line 1879 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_readers);
#line 14835 "Photo.c"
					}
#line 1879 "/home/jens/Source/shotwell/src/Photo.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 14839 "Photo.c"
						goto __finally315;
					}
				}
			}
			__finally315:
			{
				PhotoRow* _tmp32_ = NULL;
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp32_ = self->row;
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 14851 "Photo.c"
			}
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 14857 "Photo.c"
					goto __catch314_database_error;
				}
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (old_file);
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (filepath);
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 1878 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 14870 "Photo.c"
			}
		}
	}
	goto __finally314;
	__catch314_database_error:
	{
		GError* err = NULL;
		GError* _tmp33_ = NULL;
#line 1877 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 1877 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 1894 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp33_ = err;
#line 1894 "/home/jens/Source/shotwell/src/Photo.vala"
		app_window_database_error (_tmp33_);
#line 1877 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 14889 "Photo.c"
	}
	__finally314:
#line 1877 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1877 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (old_file);
#line 1877 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (filepath);
#line 1877 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1877 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1877 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 14904 "Photo.c"
	}
#line 1897 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp34_ = altered;
#line 1897 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp34_) {
#line 14910 "Photo.c"
		GFile* _tmp35_ = NULL;
		GFile* _tmp36_ = NULL;
		gboolean _tmp37_ = FALSE;
		gchar** alteration_list = NULL;
		gchar** _tmp38_ = NULL;
		gint alteration_list_length1 = 0;
		gint _alteration_list_size_ = 0;
		gchar** _tmp39_ = NULL;
		gint _tmp39__length1 = 0;
		gchar* _tmp40_ = NULL;
		gboolean _tmp41_ = FALSE;
		gboolean _tmp44_ = FALSE;
		gchar** _tmp47_ = NULL;
		gint _tmp47__length1 = 0;
		Alteration* _tmp48_ = NULL;
		Alteration* _tmp49_ = NULL;
#line 1898 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp35_ = old_file;
#line 1898 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp36_ = file;
#line 1898 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_editable_replaced (self, _tmp35_, _tmp36_);
#line 1900 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp37_ = is_baseline;
#line 1900 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp37_) {
#line 1901 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_notify_baseline_replaced (self);
#line 14939 "Photo.c"
		}
#line 1903 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp38_ = g_new0 (gchar*, 0 + 1);
#line 1903 "/home/jens/Source/shotwell/src/Photo.vala"
		alteration_list = _tmp38_;
#line 1903 "/home/jens/Source/shotwell/src/Photo.vala"
		alteration_list_length1 = 0;
#line 1903 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_list_size_ = alteration_list_length1;
#line 1904 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp39_ = alteration_list;
#line 1904 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp39__length1 = alteration_list_length1;
#line 1904 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp40_ = g_strdup ("backing:editable");
#line 1904 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_array_add100 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp40_);
#line 1906 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp41_ = is_baseline;
#line 1906 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp41_) {
#line 14961 "Photo.c"
			gchar** _tmp42_ = NULL;
			gint _tmp42__length1 = 0;
			gchar* _tmp43_ = NULL;
#line 1907 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp42_ = alteration_list;
#line 1907 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp42__length1 = alteration_list_length1;
#line 1907 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp43_ = g_strdup ("backing:baseline");
#line 1907 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add101 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp43_);
#line 14973 "Photo.c"
		}
#line 1909 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp44_ = is_source;
#line 1909 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp44_) {
#line 14979 "Photo.c"
			gchar** _tmp45_ = NULL;
			gint _tmp45__length1 = 0;
			gchar* _tmp46_ = NULL;
#line 1910 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp45_ = alteration_list;
#line 1910 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp45__length1 = alteration_list_length1;
#line 1910 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp46_ = g_strdup ("backing:source");
#line 1910 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_array_add102 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp46_);
#line 14991 "Photo.c"
		}
#line 1912 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp47_ = alteration_list;
#line 1912 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp47__length1 = alteration_list_length1;
#line 1912 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp48_ = alteration_new_from_array (_tmp47_, _tmp47__length1);
#line 1912 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp49_ = _tmp48_;
#line 1912 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp49_);
#line 1912 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp49_);
#line 1897 "/home/jens/Source/shotwell/src/Photo.vala"
		alteration_list = (_vala_array_free (alteration_list, alteration_list_length1, (GDestroyNotify) g_free), NULL);
#line 15007 "Photo.c"
	}
#line 1870 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (old_file);
#line 1870 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (filepath);
#line 15013 "Photo.c"
}


void photo_set_many_editable_file (GeeMap* map, GError** error) {
	GeeMapIterator* map_iter = NULL;
	GeeMap* _tmp0_ = NULL;
	GeeMapIterator* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 1917 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (GEE_IS_MAP (map));
#line 1918 "/home/jens/Source/shotwell/src/Photo.vala"
	database_table_begin_transaction ();
#line 1920 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = map;
#line 1920 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = gee_map_map_iterator (_tmp0_);
#line 1920 "/home/jens/Source/shotwell/src/Photo.vala"
	map_iter = _tmp1_;
#line 1921 "/home/jens/Source/shotwell/src/Photo.vala"
	while (TRUE) {
#line 15034 "Photo.c"
		GeeMapIterator* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		GeeMapIterator* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		Photo* _tmp6_ = NULL;
		GeeMapIterator* _tmp7_ = NULL;
		gpointer _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
#line 1921 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = map_iter;
#line 1921 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = gee_map_iterator_next (_tmp2_);
#line 1921 "/home/jens/Source/shotwell/src/Photo.vala"
		if (!_tmp3_) {
#line 1921 "/home/jens/Source/shotwell/src/Photo.vala"
			break;
#line 15051 "Photo.c"
		}
#line 1922 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = map_iter;
#line 1922 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = gee_map_iterator_get_key (_tmp4_);
#line 1922 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = (Photo*) _tmp5_;
#line 1922 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = map_iter;
#line 1922 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp8_ = gee_map_iterator_get_value (_tmp7_);
#line 1922 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = (GFile*) _tmp8_;
#line 1922 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_set_editable_file (_tmp6_, _tmp9_);
#line 1922 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp9_);
#line 1922 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp6_);
#line 15071 "Photo.c"
	}
#line 1924 "/home/jens/Source/shotwell/src/Photo.vala"
	database_table_commit_transaction (&_inner_error_);
#line 1924 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1924 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1924 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 1924 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (map_iter);
#line 1924 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 15085 "Photo.c"
		} else {
#line 1924 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (map_iter);
#line 1924 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1924 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 1924 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 15095 "Photo.c"
		}
	}
#line 1917 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (map_iter);
#line 15100 "Photo.c"
}


GFile* photo_get_actual_file (Photo* self) {
	GFile* result = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
#line 1929 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 1930 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_baseline_reader (self);
#line 1930 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1930 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1930 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_;
#line 1930 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp1_);
#line 1930 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp3_;
#line 1930 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 15126 "Photo.c"
}


static GFile* photo_real_get_master_file (MediaSource* base) {
	Photo * self;
	GFile* result = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
#line 1933 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 1934 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_master_reader (self);
#line 1934 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1934 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1934 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_;
#line 1934 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp1_);
#line 1934 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp3_;
#line 1934 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 15153 "Photo.c"
}


GFile* photo_get_editable_file (Photo* self) {
	GFile* result = NULL;
	PhotoFileReader* reader = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	PhotoFileReader* _tmp2_ = NULL;
#line 1937 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 1938 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_editable_reader (self);
#line 1938 "/home/jens/Source/shotwell/src/Photo.vala"
	reader = _tmp0_;
#line 1940 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = reader;
#line 1940 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_ != NULL) {
#line 15173 "Photo.c"
		PhotoFileReader* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
#line 1940 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = reader;
#line 1940 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1940 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp1_);
#line 1940 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp4_;
#line 15184 "Photo.c"
	} else {
#line 1940 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp1_);
#line 1940 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = NULL;
#line 15190 "Photo.c"
	}
#line 1940 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp1_;
#line 1940 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (reader);
#line 1940 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 15198 "Photo.c"
}


GeeCollection* photo_get_raw_developer_files (Photo* self) {
	GeeCollection* result = NULL;
	PhotoFileFormat _tmp0_ = 0;
	GeeArrayList* ret = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 1943 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 1944 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_master_file_format (self);
#line 1944 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp0_ != PHOTO_FILE_FORMAT_RAW) {
#line 1945 "/home/jens/Source/shotwell/src/Photo.vala"
		result = NULL;
#line 1945 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 15218 "Photo.c"
	}
#line 1947 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 1947 "/home/jens/Source/shotwell/src/Photo.vala"
	ret = _tmp1_;
#line 15224 "Photo.c"
	{
		PhotoRow* _tmp2_ = NULL;
#line 1948 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = self->row;
#line 1948 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 15231 "Photo.c"
		{
			{
				GeeIterator* _row_it = NULL;
				GeeHashMap* _tmp3_ = NULL;
				GeeCollection* _tmp4_ = NULL;
				GeeCollection* _tmp5_ = NULL;
				GeeCollection* _tmp6_ = NULL;
				GeeIterator* _tmp7_ = NULL;
				GeeIterator* _tmp8_ = NULL;
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->developments;
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp4_;
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = _tmp5_;
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = _tmp7_;
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_tmp6_);
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
				_row_it = _tmp8_;
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
				while (TRUE) {
#line 15259 "Photo.c"
					GeeIterator* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
					BackingPhotoRow* row = NULL;
					GeeIterator* _tmp11_ = NULL;
					gpointer _tmp12_ = NULL;
					GeeArrayList* _tmp13_ = NULL;
					BackingPhotoRow* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
					GFile* _tmp16_ = NULL;
					GFile* _tmp17_ = NULL;
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp9_ = _row_it;
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp10_ = gee_iterator_next (_tmp9_);
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
					if (!_tmp10_) {
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
						break;
#line 15278 "Photo.c"
					}
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = _row_it;
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp12_ = gee_iterator_get (_tmp11_);
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
					row = (BackingPhotoRow*) _tmp12_;
#line 1950 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp13_ = ret;
#line 1950 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_ = row;
#line 1950 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp15_ = _tmp14_->filepath;
#line 1950 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp16_ = g_file_new_for_path (_tmp15_);
#line 1950 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp17_ = _tmp16_;
#line 1950 "/home/jens/Source/shotwell/src/Photo.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp17_);
#line 1950 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (_tmp17_);
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
					_backing_photo_row_unref0 (row);
#line 15302 "Photo.c"
				}
#line 1949 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_row_it);
#line 15306 "Photo.c"
			}
		}
		__finally317:
		{
			PhotoRow* _tmp18_ = NULL;
#line 1948 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp18_ = self->row;
#line 1948 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15316 "Photo.c"
		}
#line 1948 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1948 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (ret);
#line 1948 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1948 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 1948 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 15328 "Photo.c"
		}
	}
#line 1953 "/home/jens/Source/shotwell/src/Photo.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (ret, GEE_TYPE_COLLECTION, GeeCollection);
#line 1953 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 15335 "Photo.c"
}


GFile* photo_get_source_file (Photo* self) {
	GFile* result = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
#line 1956 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 1957 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_source_reader (self);
#line 1957 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 1957 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1957 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_;
#line 1957 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp1_);
#line 1957 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp3_;
#line 1957 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 15361 "Photo.c"
}


PhotoFileFormat photo_get_file_format (Photo* self) {
	PhotoFileFormat result = 0;
	GError * _inner_error_ = NULL;
#line 1960 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0);
#line 15370 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 1961 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 1961 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 15377 "Photo.c"
		{
			BackingPhotoRow* _tmp1_ = NULL;
			PhotoFileFormat _tmp2_ = 0;
#line 1962 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->backing_photo_row;
#line 1962 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->file_format;
#line 1962 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 15387 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 1961 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 1961 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15394 "Photo.c"
			}
#line 1962 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 15398 "Photo.c"
		}
		__finally318:
		{
			PhotoRow* _tmp4_ = NULL;
#line 1961 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 1961 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15407 "Photo.c"
		}
#line 1961 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1961 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1961 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0;
#line 15415 "Photo.c"
	}
}


PhotoFileFormat photo_get_best_export_file_format (Photo* self) {
	PhotoFileFormat result = 0;
	PhotoFileFormat file_format = 0;
	PhotoFileFormat _tmp0_ = 0;
	PhotoFileFormat _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
#line 1966 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0);
#line 1967 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_file_format (self);
#line 1967 "/home/jens/Source/shotwell/src/Photo.vala"
	file_format = _tmp0_;
#line 1968 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = file_format;
#line 1968 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_format_can_write (_tmp1_);
#line 1968 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp2_) {
#line 15438 "Photo.c"
		PhotoFileFormat _tmp3_ = 0;
#line 1969 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = photo_file_format_get_system_default_format ();
#line 1969 "/home/jens/Source/shotwell/src/Photo.vala"
		file_format = _tmp3_;
#line 15444 "Photo.c"
	}
#line 1971 "/home/jens/Source/shotwell/src/Photo.vala"
	result = file_format;
#line 1971 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 15450 "Photo.c"
}


PhotoFileFormat photo_get_master_file_format (Photo* self) {
	PhotoFileFormat result = 0;
	GError * _inner_error_ = NULL;
#line 1974 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0);
#line 15459 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 1975 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 1975 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 15466 "Photo.c"
		{
			PhotoBackingReaders* _tmp1_ = NULL;
			PhotoFileReader* _tmp2_ = NULL;
			PhotoFileFormat _tmp3_ = 0;
#line 1976 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->readers;
#line 1976 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->master;
#line 1976 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 1976 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 15479 "Photo.c"
			{
				PhotoRow* _tmp4_ = NULL;
#line 1975 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 1975 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15486 "Photo.c"
			}
#line 1976 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 15490 "Photo.c"
		}
		__finally319:
		{
			PhotoRow* _tmp5_ = NULL;
#line 1975 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 1975 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15499 "Photo.c"
		}
#line 1975 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1975 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1975 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0;
#line 15507 "Photo.c"
	}
}


static time_t photo_real_get_timestamp (MediaSource* base) {
	Photo * self;
	time_t result = 0;
	GError * _inner_error_ = NULL;
#line 1980 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 15518 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
		time_t _tmp5_ = 0;
#line 1981 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 1981 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 15526 "Photo.c"
		{
			BackingPhotoRow* _tmp1_ = NULL;
			time_t _tmp2_ = 0;
#line 1982 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->backing_photo_row;
#line 1982 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->timestamp;
#line 1982 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 15536 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 1981 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 1981 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15543 "Photo.c"
			}
#line 1982 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 15547 "Photo.c"
		}
		__finally320:
		{
			PhotoRow* _tmp4_ = NULL;
#line 1981 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 1981 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15556 "Photo.c"
		}
#line 1981 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1981 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1981 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp5_;
#line 15564 "Photo.c"
	}
}


void photo_get_photo_id (Photo* self, PhotoID* result) {
	GError * _inner_error_ = NULL;
#line 1986 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 15573 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 1987 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 1987 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 15580 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			PhotoID _tmp2_ = {0};
#line 1988 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 1988 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->photo_id;
#line 1988 "/home/jens/Source/shotwell/src/Photo.vala"
			*result = _tmp2_;
#line 15590 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 1987 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 1987 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15597 "Photo.c"
			}
#line 1988 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 15601 "Photo.c"
		}
		__finally321:
		{
			PhotoRow* _tmp4_ = NULL;
#line 1987 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 1987 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15610 "Photo.c"
		}
#line 1987 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1987 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 1987 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 15618 "Photo.c"
	}
}


static inline void photo_real_get_event_id (MediaSource* base, EventID* result) {
	Photo * self;
	PhotoRow* _tmp0_ = NULL;
	EventID _tmp1_ = {0};
#line 1993 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 1994 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = self->row;
#line 1994 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_->event_id;
#line 1994 "/home/jens/Source/shotwell/src/Photo.vala"
	*result = _tmp1_;
#line 1994 "/home/jens/Source/shotwell/src/Photo.vala"
	return;
#line 15637 "Photo.c"
}


inline gint64 photo_get_raw_event_id (Photo* self) {
	gint64 result = 0LL;
	PhotoRow* _tmp0_ = NULL;
	EventID _tmp1_ = {0};
	gint64 _tmp2_ = 0LL;
#line 1998 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0LL);
#line 1999 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = self->row;
#line 1999 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_->event_id;
#line 1999 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = _tmp1_.id;
#line 1999 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp2_;
#line 1999 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 15658 "Photo.c"
}


static void photo_real_get_import_id (MediaSource* base, ImportID* result) {
	Photo * self;
	GError * _inner_error_ = NULL;
#line 2002 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 15667 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2003 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2003 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 15674 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			ImportID _tmp2_ = {0};
#line 2004 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2004 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->import_id;
#line 2004 "/home/jens/Source/shotwell/src/Photo.vala"
			*result = _tmp2_;
#line 15684 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 2003 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2003 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15691 "Photo.c"
			}
#line 2004 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 15695 "Photo.c"
		}
		__finally322:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2003 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2003 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15704 "Photo.c"
		}
#line 2003 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2003 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2003 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 15712 "Photo.c"
	}
}


void photo_get_editable_id (Photo* self, BackingPhotoID* result) {
	GError * _inner_error_ = NULL;
#line 2008 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 15721 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2009 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2009 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 15728 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			BackingPhotoID _tmp2_ = {0};
#line 2010 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2010 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->editable_id;
#line 2010 "/home/jens/Source/shotwell/src/Photo.vala"
			*result = _tmp2_;
#line 15738 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 2009 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2009 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15745 "Photo.c"
			}
#line 2010 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 15749 "Photo.c"
		}
		__finally323:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2009 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2009 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15758 "Photo.c"
		}
#line 2009 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2009 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2009 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 15766 "Photo.c"
	}
}


static gchar* photo_real_get_master_md5 (MediaSource* base) {
	Photo * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 2014 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 15777 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2015 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2015 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 15784 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
#line 2016 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2016 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->md5;
#line 2016 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 2016 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 15797 "Photo.c"
			{
				PhotoRow* _tmp4_ = NULL;
#line 2015 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2015 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15804 "Photo.c"
			}
#line 2016 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 15808 "Photo.c"
		}
		__finally324:
		{
			PhotoRow* _tmp5_ = NULL;
#line 2015 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2015 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15817 "Photo.c"
		}
#line 2015 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2015 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2015 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 15825 "Photo.c"
	}
}


guint64 photo_get_flags (Photo* self) {
	guint64 result = 0ULL;
	GError * _inner_error_ = NULL;
#line 2022 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
#line 15835 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
		guint64 _tmp5_ = 0ULL;
#line 2023 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2023 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 15843 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			guint64 _tmp2_ = 0ULL;
#line 2024 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2024 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->flags;
#line 2024 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 15853 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 2023 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2023 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15860 "Photo.c"
			}
#line 2024 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 15864 "Photo.c"
		}
		__finally325:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2023 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2023 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15873 "Photo.c"
		}
#line 2023 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2023 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2023 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp5_;
#line 15881 "Photo.c"
	}
}


static void photo_notify_flags_altered (Photo* self, Alteration* additional_alteration) {
	Alteration* alteration = NULL;
	Alteration* _tmp0_ = NULL;
	Alteration* _tmp1_ = NULL;
	Alteration* _tmp5_ = NULL;
#line 2028 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2028 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration));
#line 2029 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = alteration_new ("metadata", "flags");
#line 2029 "/home/jens/Source/shotwell/src/Photo.vala"
	alteration = _tmp0_;
#line 2030 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = additional_alteration;
#line 2030 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ != NULL) {
#line 15903 "Photo.c"
		Alteration* _tmp2_ = NULL;
		Alteration* _tmp3_ = NULL;
		Alteration* _tmp4_ = NULL;
#line 2031 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = alteration;
#line 2031 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = additional_alteration;
#line 2031 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = alteration_compress (_tmp2_, _tmp3_);
#line 2031 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (alteration);
#line 2031 "/home/jens/Source/shotwell/src/Photo.vala"
		alteration = _tmp4_;
#line 15917 "Photo.c"
	}
#line 2033 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = alteration;
#line 2033 "/home/jens/Source/shotwell/src/Photo.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp5_);
#line 2028 "/home/jens/Source/shotwell/src/Photo.vala"
	_alteration_unref0 (alteration);
#line 15925 "Photo.c"
}


guint64 photo_replace_flags (Photo* self, guint64 flags, Alteration* additional_alteration) {
	guint64 result = 0ULL;
	gboolean committed = FALSE;
	gboolean _tmp11_ = FALSE;
	guint64 _tmp13_ = 0ULL;
	GError * _inner_error_ = NULL;
#line 2036 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
#line 2036 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
#line 15939 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2038 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2038 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 15946 "Photo.c"
		{
			PhotoTable* _tmp1_ = NULL;
			PhotoTable* _tmp2_ = NULL;
			PhotoID _tmp3_ = {0};
			guint64 _tmp4_ = 0ULL;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_ = FALSE;
#line 2039 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = photo_table_get_instance ();
#line 2039 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_;
#line 2039 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_get_photo_id (self, &_tmp3_);
#line 2039 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = flags;
#line 2039 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = photo_table_replace_flags (_tmp2_, &_tmp3_, _tmp4_);
#line 2039 "/home/jens/Source/shotwell/src/Photo.vala"
			committed = _tmp5_;
#line 2039 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp2_);
#line 2040 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = committed;
#line 2040 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp6_) {
#line 15972 "Photo.c"
				PhotoRow* _tmp7_ = NULL;
				guint64 _tmp8_ = 0ULL;
#line 2041 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = self->row;
#line 2041 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = flags;
#line 2041 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_->flags = _tmp8_;
#line 15981 "Photo.c"
			}
		}
		__finally326:
		{
			PhotoRow* _tmp9_ = NULL;
#line 2038 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = self->row;
#line 2038 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 15991 "Photo.c"
		}
#line 2038 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 15995 "Photo.c"
			guint64 _tmp10_ = 0ULL;
#line 2038 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2038 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2038 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp10_;
#line 16003 "Photo.c"
		}
	}
#line 2044 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = committed;
#line 2044 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp11_) {
#line 16010 "Photo.c"
		Alteration* _tmp12_ = NULL;
#line 2045 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = additional_alteration;
#line 2045 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_flags_altered (self, _tmp12_);
#line 16016 "Photo.c"
	}
#line 2047 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = flags;
#line 2047 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp13_;
#line 2047 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 16024 "Photo.c"
}


gboolean photo_is_flag_set (Photo* self, guint64 mask) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 2050 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 16033 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
		gboolean _tmp7_ = FALSE;
#line 2051 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2051 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16041 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			guint64 _tmp2_ = 0ULL;
			guint64 _tmp3_ = 0ULL;
			gboolean _tmp4_ = FALSE;
#line 2052 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2052 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->flags;
#line 2052 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = mask;
#line 2052 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = media_source_internal_is_flag_set (_tmp2_, _tmp3_);
#line 2052 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp4_;
#line 16057 "Photo.c"
			{
				PhotoRow* _tmp5_ = NULL;
#line 2051 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = self->row;
#line 2051 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16064 "Photo.c"
			}
#line 2052 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 16068 "Photo.c"
		}
		__finally327:
		{
			PhotoRow* _tmp6_ = NULL;
#line 2051 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = self->row;
#line 2051 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16077 "Photo.c"
		}
#line 2051 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2051 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2051 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp7_;
#line 16085 "Photo.c"
	}
}


guint64 photo_add_flags (Photo* self, guint64 mask, Alteration* additional_alteration) {
	guint64 result = 0ULL;
	guint64 flags = 0ULL;
	gboolean committed = FALSE;
	gboolean _tmp18_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2056 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
#line 2056 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
#line 2057 "/home/jens/Source/shotwell/src/Photo.vala"
	flags = (guint64) 0;
#line 2059 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 16104 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2060 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2060 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16111 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			guint64 _tmp2_ = 0ULL;
			guint64 _tmp3_ = 0ULL;
			guint64 _tmp4_ = 0ULL;
			PhotoRow* _tmp5_ = NULL;
			guint64 _tmp6_ = 0ULL;
			guint64 _tmp7_ = 0ULL;
#line 2061 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2061 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->flags;
#line 2061 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = mask;
#line 2061 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = media_source_internal_add_flags (_tmp2_, _tmp3_);
#line 2061 "/home/jens/Source/shotwell/src/Photo.vala"
			flags = _tmp4_;
#line 2062 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2062 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _tmp5_->flags;
#line 2062 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = flags;
#line 2062 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp6_ != _tmp7_) {
#line 16138 "Photo.c"
				PhotoTable* _tmp8_ = NULL;
				PhotoTable* _tmp9_ = NULL;
				PhotoID _tmp10_ = {0};
				guint64 _tmp11_ = 0ULL;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
#line 2063 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = photo_table_get_instance ();
#line 2063 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = _tmp8_;
#line 2063 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_get_photo_id (self, &_tmp10_);
#line 2063 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = flags;
#line 2063 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = photo_table_replace_flags (_tmp9_, &_tmp10_, _tmp11_);
#line 2063 "/home/jens/Source/shotwell/src/Photo.vala"
				committed = _tmp12_;
#line 2063 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp9_);
#line 2064 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = committed;
#line 2064 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp13_) {
#line 16163 "Photo.c"
					PhotoRow* _tmp14_ = NULL;
					guint64 _tmp15_ = 0ULL;
#line 2065 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_ = self->row;
#line 2065 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp15_ = flags;
#line 2065 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_->flags = _tmp15_;
#line 16172 "Photo.c"
				}
			}
		}
		__finally328:
		{
			PhotoRow* _tmp16_ = NULL;
#line 2060 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = self->row;
#line 2060 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16183 "Photo.c"
		}
#line 2060 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 16187 "Photo.c"
			guint64 _tmp17_ = 0ULL;
#line 2060 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2060 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2060 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp17_;
#line 16195 "Photo.c"
		}
	}
#line 2069 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = committed;
#line 2069 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp18_) {
#line 16202 "Photo.c"
		Alteration* _tmp19_ = NULL;
#line 2070 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = additional_alteration;
#line 2070 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_flags_altered (self, _tmp19_);
#line 16208 "Photo.c"
	}
#line 2072 "/home/jens/Source/shotwell/src/Photo.vala"
	result = flags;
#line 2072 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 16214 "Photo.c"
}


guint64 photo_remove_flags (Photo* self, guint64 mask, Alteration* additional_alteration) {
	guint64 result = 0ULL;
	guint64 flags = 0ULL;
	gboolean committed = FALSE;
	gboolean _tmp18_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2075 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
#line 2075 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
#line 2076 "/home/jens/Source/shotwell/src/Photo.vala"
	flags = (guint64) 0;
#line 2078 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 16232 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2079 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2079 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16239 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			guint64 _tmp2_ = 0ULL;
			guint64 _tmp3_ = 0ULL;
			guint64 _tmp4_ = 0ULL;
			PhotoRow* _tmp5_ = NULL;
			guint64 _tmp6_ = 0ULL;
			guint64 _tmp7_ = 0ULL;
#line 2080 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2080 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->flags;
#line 2080 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = mask;
#line 2080 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = media_source_internal_remove_flags (_tmp2_, _tmp3_);
#line 2080 "/home/jens/Source/shotwell/src/Photo.vala"
			flags = _tmp4_;
#line 2081 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2081 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _tmp5_->flags;
#line 2081 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = flags;
#line 2081 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp6_ != _tmp7_) {
#line 16266 "Photo.c"
				PhotoTable* _tmp8_ = NULL;
				PhotoTable* _tmp9_ = NULL;
				PhotoID _tmp10_ = {0};
				guint64 _tmp11_ = 0ULL;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
#line 2082 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = photo_table_get_instance ();
#line 2082 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = _tmp8_;
#line 2082 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_get_photo_id (self, &_tmp10_);
#line 2082 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = flags;
#line 2082 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = photo_table_replace_flags (_tmp9_, &_tmp10_, _tmp11_);
#line 2082 "/home/jens/Source/shotwell/src/Photo.vala"
				committed = _tmp12_;
#line 2082 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp9_);
#line 2083 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = committed;
#line 2083 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp13_) {
#line 16291 "Photo.c"
					PhotoRow* _tmp14_ = NULL;
					guint64 _tmp15_ = 0ULL;
#line 2084 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_ = self->row;
#line 2084 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp15_ = flags;
#line 2084 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_->flags = _tmp15_;
#line 16300 "Photo.c"
				}
			}
		}
		__finally329:
		{
			PhotoRow* _tmp16_ = NULL;
#line 2079 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = self->row;
#line 2079 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16311 "Photo.c"
		}
#line 2079 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 16315 "Photo.c"
			guint64 _tmp17_ = 0ULL;
#line 2079 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2079 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2079 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp17_;
#line 16323 "Photo.c"
		}
	}
#line 2088 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = committed;
#line 2088 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp18_) {
#line 16330 "Photo.c"
		Alteration* _tmp19_ = NULL;
#line 2089 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = additional_alteration;
#line 2089 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_flags_altered (self, _tmp19_);
#line 16336 "Photo.c"
	}
#line 2091 "/home/jens/Source/shotwell/src/Photo.vala"
	result = flags;
#line 2091 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 16342 "Photo.c"
}


guint64 photo_add_remove_flags (Photo* self, guint64 add, guint64 remove, Alteration* additional_alteration) {
	guint64 result = 0ULL;
	guint64 flags = 0ULL;
	gboolean committed = FALSE;
	gboolean _tmp18_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2094 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
#line 2094 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
#line 2095 "/home/jens/Source/shotwell/src/Photo.vala"
	flags = (guint64) 0;
#line 2097 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 16360 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2098 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2098 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16367 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			guint64 _tmp2_ = 0ULL;
			guint64 _tmp3_ = 0ULL;
			guint64 _tmp4_ = 0ULL;
			PhotoRow* _tmp5_ = NULL;
			guint64 _tmp6_ = 0ULL;
			guint64 _tmp7_ = 0ULL;
#line 2099 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2099 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->flags;
#line 2099 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = add;
#line 2099 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = remove;
#line 2099 "/home/jens/Source/shotwell/src/Photo.vala"
			flags = (_tmp2_ | _tmp3_) & (~_tmp4_);
#line 2100 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2100 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _tmp5_->flags;
#line 2100 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = flags;
#line 2100 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp6_ != _tmp7_) {
#line 16394 "Photo.c"
				PhotoTable* _tmp8_ = NULL;
				PhotoTable* _tmp9_ = NULL;
				PhotoID _tmp10_ = {0};
				guint64 _tmp11_ = 0ULL;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
#line 2101 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = photo_table_get_instance ();
#line 2101 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = _tmp8_;
#line 2101 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_get_photo_id (self, &_tmp10_);
#line 2101 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = flags;
#line 2101 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = photo_table_replace_flags (_tmp9_, &_tmp10_, _tmp11_);
#line 2101 "/home/jens/Source/shotwell/src/Photo.vala"
				committed = _tmp12_;
#line 2101 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp9_);
#line 2102 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = committed;
#line 2102 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp13_) {
#line 16419 "Photo.c"
					PhotoRow* _tmp14_ = NULL;
					guint64 _tmp15_ = 0ULL;
#line 2103 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_ = self->row;
#line 2103 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp15_ = flags;
#line 2103 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_->flags = _tmp15_;
#line 16428 "Photo.c"
				}
			}
		}
		__finally330:
		{
			PhotoRow* _tmp16_ = NULL;
#line 2098 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = self->row;
#line 2098 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16439 "Photo.c"
		}
#line 2098 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 16443 "Photo.c"
			guint64 _tmp17_ = 0ULL;
#line 2098 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2098 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2098 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp17_;
#line 16451 "Photo.c"
		}
	}
#line 2107 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = committed;
#line 2107 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp18_) {
#line 16458 "Photo.c"
		Alteration* _tmp19_ = NULL;
#line 2108 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = additional_alteration;
#line 2108 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_flags_altered (self, _tmp19_);
#line 16464 "Photo.c"
	}
#line 2110 "/home/jens/Source/shotwell/src/Photo.vala"
	result = flags;
#line 2110 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 16470 "Photo.c"
}


void photo_add_remove_many_flags (GeeCollection* add, guint64 add_mask, Alteration* additional_add_alteration, GeeCollection* remove, guint64 remove_mask, Alteration* additional_remove_alteration, GError** error) {
	GeeCollection* _tmp0_ = NULL;
	GeeCollection* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
#line 2113 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((add == NULL) || GEE_IS_COLLECTION (add));
#line 2113 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((additional_add_alteration == NULL) || IS_ALTERATION (additional_add_alteration));
#line 2113 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((remove == NULL) || GEE_IS_COLLECTION (remove));
#line 2113 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((additional_remove_alteration == NULL) || IS_ALTERATION (additional_remove_alteration));
#line 2116 "/home/jens/Source/shotwell/src/Photo.vala"
	database_table_begin_transaction ();
#line 2118 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = add;
#line 2118 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp0_ != NULL) {
#line 16492 "Photo.c"
		{
			GeeIterator* _photo_it = NULL;
			GeeCollection* _tmp1_ = NULL;
			GeeIterator* _tmp2_ = NULL;
#line 2119 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = add;
#line 2119 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 2119 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_it = _tmp2_;
#line 2119 "/home/jens/Source/shotwell/src/Photo.vala"
			while (TRUE) {
#line 16505 "Photo.c"
				GeeIterator* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				Photo* photo = NULL;
				GeeIterator* _tmp5_ = NULL;
				gpointer _tmp6_ = NULL;
				Photo* _tmp7_ = NULL;
				guint64 _tmp8_ = 0ULL;
				Alteration* _tmp9_ = NULL;
#line 2119 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = _photo_it;
#line 2119 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = gee_iterator_next (_tmp3_);
#line 2119 "/home/jens/Source/shotwell/src/Photo.vala"
				if (!_tmp4_) {
#line 2119 "/home/jens/Source/shotwell/src/Photo.vala"
					break;
#line 16522 "Photo.c"
				}
#line 2119 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _photo_it;
#line 2119 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = gee_iterator_get (_tmp5_);
#line 2119 "/home/jens/Source/shotwell/src/Photo.vala"
				photo = (Photo*) _tmp6_;
#line 2120 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = photo;
#line 2120 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = add_mask;
#line 2120 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = additional_add_alteration;
#line 2120 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_add_flags (_tmp7_, _tmp8_, _tmp9_);
#line 2119 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (photo);
#line 16540 "Photo.c"
			}
#line 2119 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (_photo_it);
#line 16544 "Photo.c"
		}
	}
#line 2123 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = remove;
#line 2123 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp10_ != NULL) {
#line 16551 "Photo.c"
		{
			GeeIterator* _photo_it = NULL;
			GeeCollection* _tmp11_ = NULL;
			GeeIterator* _tmp12_ = NULL;
#line 2124 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = remove;
#line 2124 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ITERABLE, GeeIterable));
#line 2124 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_it = _tmp12_;
#line 2124 "/home/jens/Source/shotwell/src/Photo.vala"
			while (TRUE) {
#line 16564 "Photo.c"
				GeeIterator* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				Photo* photo = NULL;
				GeeIterator* _tmp15_ = NULL;
				gpointer _tmp16_ = NULL;
				Photo* _tmp17_ = NULL;
				guint64 _tmp18_ = 0ULL;
				Alteration* _tmp19_ = NULL;
#line 2124 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = _photo_it;
#line 2124 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = gee_iterator_next (_tmp13_);
#line 2124 "/home/jens/Source/shotwell/src/Photo.vala"
				if (!_tmp14_) {
#line 2124 "/home/jens/Source/shotwell/src/Photo.vala"
					break;
#line 16581 "Photo.c"
				}
#line 2124 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = _photo_it;
#line 2124 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = gee_iterator_get (_tmp15_);
#line 2124 "/home/jens/Source/shotwell/src/Photo.vala"
				photo = (Photo*) _tmp16_;
#line 2125 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = photo;
#line 2125 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = remove_mask;
#line 2125 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp19_ = additional_remove_alteration;
#line 2125 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_remove_flags (_tmp17_, _tmp18_, _tmp19_);
#line 2124 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (photo);
#line 16599 "Photo.c"
			}
#line 2124 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (_photo_it);
#line 16603 "Photo.c"
		}
	}
#line 2128 "/home/jens/Source/shotwell/src/Photo.vala"
	database_table_commit_transaction (&_inner_error_);
#line 2128 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2128 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 2128 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 2128 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 16616 "Photo.c"
		} else {
#line 2128 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2128 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2128 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 16624 "Photo.c"
		}
	}
}


guint64 photo_toggle_flags (Photo* self, guint64 mask, Alteration* additional_alteration) {
	guint64 result = 0ULL;
	guint64 flags = 0ULL;
	gboolean committed = FALSE;
	gboolean _tmp17_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2131 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
#line 2131 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
#line 2132 "/home/jens/Source/shotwell/src/Photo.vala"
	flags = (guint64) 0;
#line 2134 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 16644 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2135 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2135 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16651 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			guint64 _tmp2_ = 0ULL;
			guint64 _tmp3_ = 0ULL;
			PhotoRow* _tmp4_ = NULL;
			guint64 _tmp5_ = 0ULL;
			guint64 _tmp6_ = 0ULL;
#line 2136 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2136 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->flags;
#line 2136 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = mask;
#line 2136 "/home/jens/Source/shotwell/src/Photo.vala"
			flags = _tmp2_ ^ _tmp3_;
#line 2137 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2137 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = _tmp4_->flags;
#line 2137 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = flags;
#line 2137 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp5_ != _tmp6_) {
#line 16675 "Photo.c"
				PhotoTable* _tmp7_ = NULL;
				PhotoTable* _tmp8_ = NULL;
				PhotoID _tmp9_ = {0};
				guint64 _tmp10_ = 0ULL;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
#line 2138 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = photo_table_get_instance ();
#line 2138 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = _tmp7_;
#line 2138 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_get_photo_id (self, &_tmp9_);
#line 2138 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = flags;
#line 2138 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = photo_table_replace_flags (_tmp8_, &_tmp9_, _tmp10_);
#line 2138 "/home/jens/Source/shotwell/src/Photo.vala"
				committed = _tmp11_;
#line 2138 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp8_);
#line 2139 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = committed;
#line 2139 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp12_) {
#line 16700 "Photo.c"
					PhotoRow* _tmp13_ = NULL;
					guint64 _tmp14_ = 0ULL;
#line 2140 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp13_ = self->row;
#line 2140 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_ = flags;
#line 2140 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp13_->flags = _tmp14_;
#line 16709 "Photo.c"
				}
			}
		}
		__finally331:
		{
			PhotoRow* _tmp15_ = NULL;
#line 2135 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = self->row;
#line 2135 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16720 "Photo.c"
		}
#line 2135 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 16724 "Photo.c"
			guint64 _tmp16_ = 0ULL;
#line 2135 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2135 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2135 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp16_;
#line 16732 "Photo.c"
		}
	}
#line 2144 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = committed;
#line 2144 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp17_) {
#line 16739 "Photo.c"
		Alteration* _tmp18_ = NULL;
#line 2145 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = additional_alteration;
#line 2145 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_notify_flags_altered (self, _tmp18_);
#line 16745 "Photo.c"
	}
#line 2147 "/home/jens/Source/shotwell/src/Photo.vala"
	result = flags;
#line 2147 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 16751 "Photo.c"
}


gboolean photo_is_master_metadata_dirty (Photo* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 2150 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 16760 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 2151 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2151 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16768 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			gboolean _tmp2_ = FALSE;
#line 2152 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2152 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->metadata_dirty;
#line 2152 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 16778 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 2151 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2151 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16785 "Photo.c"
			}
#line 2152 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 16789 "Photo.c"
		}
		__finally332:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2151 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2151 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16798 "Photo.c"
		}
#line 2151 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2151 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2151 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp5_;
#line 16806 "Photo.c"
	}
}


void photo_set_master_metadata_dirty (Photo* self, gboolean dirty, GError** error) {
	gboolean committed = FALSE;
	gboolean _tmp11_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2156 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2157 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 16819 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2158 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2158 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16826 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			gboolean _tmp2_ = FALSE;
			gboolean _tmp3_ = FALSE;
#line 2159 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2159 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->metadata_dirty;
#line 2159 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = dirty;
#line 2159 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != _tmp3_) {
#line 16839 "Photo.c"
				PhotoTable* _tmp4_ = NULL;
				PhotoTable* _tmp5_ = NULL;
				PhotoID _tmp6_ = {0};
				gboolean _tmp7_ = FALSE;
				PhotoRow* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
#line 2160 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = photo_table_get_instance ();
#line 2160 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp4_;
#line 2160 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_get_photo_id (self, &_tmp6_);
#line 2160 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = dirty;
#line 2160 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_table_set_metadata_dirty (_tmp5_, &_tmp6_, _tmp7_, &_inner_error_);
#line 2160 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp5_);
#line 2160 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 16860 "Photo.c"
					goto __finally333;
				}
#line 2161 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = self->row;
#line 2161 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = dirty;
#line 2161 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_->metadata_dirty = _tmp9_;
#line 2162 "/home/jens/Source/shotwell/src/Photo.vala"
				committed = TRUE;
#line 16871 "Photo.c"
			}
		}
		__finally333:
		{
			PhotoRow* _tmp10_ = NULL;
#line 2158 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = self->row;
#line 2158 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16881 "Photo.c"
		}
#line 2158 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2158 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 2158 "/home/jens/Source/shotwell/src/Photo.vala"
				g_propagate_error (error, _inner_error_);
#line 2158 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 16891 "Photo.c"
			} else {
#line 2158 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2158 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 2158 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 16899 "Photo.c"
			}
		}
	}
#line 2166 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = committed;
#line 2166 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp11_) {
#line 16907 "Photo.c"
		Alteration* _tmp12_ = NULL;
		Alteration* _tmp13_ = NULL;
#line 2167 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = alteration_new ("metadata", "master-dirty");
#line 2167 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = _tmp12_;
#line 2167 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp13_);
#line 2167 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp13_);
#line 16918 "Photo.c"
	}
}


static Rating photo_real_get_rating (MediaSource* base) {
	Photo * self;
	Rating result = 0;
	GError * _inner_error_ = NULL;
#line 2170 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 16929 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2171 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2171 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16936 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			Rating _tmp2_ = 0;
#line 2172 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2172 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->rating;
#line 2172 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 16946 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 2171 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2171 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16953 "Photo.c"
			}
#line 2172 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 16957 "Photo.c"
		}
		__finally334:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2171 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2171 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 16966 "Photo.c"
		}
#line 2171 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2171 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2171 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0;
#line 16974 "Photo.c"
	}
}


static void photo_real_set_rating (MediaSource* base, Rating rating) {
	Photo * self;
	gboolean committed = FALSE;
	gboolean _tmp16_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2176 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2177 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 16988 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2179 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2179 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 16995 "Photo.c"
		{
			gboolean _tmp1_ = FALSE;
			Rating _tmp2_ = 0;
			PhotoRow* _tmp3_ = NULL;
			Rating _tmp4_ = 0;
#line 2180 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = rating;
#line 2180 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 2180 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _tmp3_->rating;
#line 2180 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != _tmp4_) {
#line 17009 "Photo.c"
				Rating _tmp5_ = 0;
				gboolean _tmp6_ = FALSE;
#line 2180 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = rating;
#line 2180 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = rating_is_valid (_tmp5_);
#line 2180 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = _tmp6_;
#line 17018 "Photo.c"
			} else {
#line 2180 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = FALSE;
#line 17022 "Photo.c"
			}
#line 2180 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp1_) {
#line 17026 "Photo.c"
				PhotoTable* _tmp7_ = NULL;
				PhotoTable* _tmp8_ = NULL;
				PhotoID _tmp9_ = {0};
				Rating _tmp10_ = 0;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
#line 2181 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = photo_table_get_instance ();
#line 2181 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = _tmp7_;
#line 2181 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_get_photo_id (self, &_tmp9_);
#line 2181 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = rating;
#line 2181 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = photo_table_set_rating (_tmp8_, &_tmp9_, _tmp10_);
#line 2181 "/home/jens/Source/shotwell/src/Photo.vala"
				committed = _tmp11_;
#line 2181 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp8_);
#line 2182 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = committed;
#line 2182 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp12_) {
#line 17051 "Photo.c"
					PhotoRow* _tmp13_ = NULL;
					Rating _tmp14_ = 0;
#line 2183 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp13_ = self->row;
#line 2183 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_ = rating;
#line 2183 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp13_->rating = _tmp14_;
#line 17060 "Photo.c"
				}
			}
		}
		__finally335:
		{
			PhotoRow* _tmp15_ = NULL;
#line 2179 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = self->row;
#line 2179 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17071 "Photo.c"
		}
#line 2179 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2179 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2179 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2179 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 17081 "Photo.c"
		}
	}
#line 2187 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = committed;
#line 2187 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp16_) {
#line 17088 "Photo.c"
		Alteration* _tmp17_ = NULL;
		Alteration* _tmp18_ = NULL;
#line 2188 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = alteration_new ("metadata", "rating");
#line 2188 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = _tmp17_;
#line 2188 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp18_);
#line 2188 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp18_);
#line 17099 "Photo.c"
	}
}


static void photo_real_increase_rating (MediaSource* base) {
	Photo * self;
	GError * _inner_error_ = NULL;
#line 2191 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 17109 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2192 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2192 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 17116 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			Rating _tmp2_ = 0;
			Rating _tmp3_ = 0;
#line 2193 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2193 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->rating;
#line 2193 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = rating_increase (_tmp2_);
#line 2193 "/home/jens/Source/shotwell/src/Photo.vala"
			media_source_set_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp3_);
#line 17129 "Photo.c"
		}
		__finally336:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2192 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2192 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17138 "Photo.c"
		}
#line 2192 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2192 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2192 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2192 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 17148 "Photo.c"
		}
	}
}


static void photo_real_decrease_rating (MediaSource* base) {
	Photo * self;
	GError * _inner_error_ = NULL;
#line 2197 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 17159 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2198 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2198 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 17166 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			Rating _tmp2_ = 0;
			Rating _tmp3_ = 0;
#line 2199 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2199 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->rating;
#line 2199 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = rating_decrease (_tmp2_);
#line 2199 "/home/jens/Source/shotwell/src/Photo.vala"
			media_source_set_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp3_);
#line 17179 "Photo.c"
		}
		__finally337:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2198 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2198 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17188 "Photo.c"
		}
#line 2198 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2198 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2198 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2198 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 17198 "Photo.c"
		}
	}
}


static void photo_real_commit_backlinks (DataSource* base, SourceCollection* sources, const gchar* backlinks) {
	Photo * self;
	GError * _inner_error_ = NULL;
#line 2203 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2203 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail ((sources == NULL) || IS_SOURCE_COLLECTION (sources));
#line 17211 "Photo.c"
	{
		PhotoTable* _tmp0_ = NULL;
		PhotoTable* _tmp1_ = NULL;
		PhotoID _tmp2_ = {0};
		const gchar* _tmp3_ = NULL;
#line 2208 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = photo_table_get_instance ();
#line 2208 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp0_;
#line 2208 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_get_photo_id (self, &_tmp2_);
#line 2208 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = backlinks;
#line 2208 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_table_update_backlinks (_tmp1_, &_tmp2_, _tmp3_, &_inner_error_);
#line 2208 "/home/jens/Source/shotwell/src/Photo.vala"
		_database_table_unref0 (_tmp1_);
#line 2208 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2208 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 17233 "Photo.c"
				goto __catch338_database_error;
			}
#line 2208 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2208 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2208 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 17242 "Photo.c"
		}
		{
			PhotoRow* _tmp4_ = NULL;
#line 2209 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2209 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_lock (&self->priv->__lock_row);
#line 17250 "Photo.c"
			{
				PhotoRow* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
#line 2210 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = self->row;
#line 2210 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = backlinks;
#line 2210 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = g_strdup (_tmp6_);
#line 2210 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (_tmp5_->backlinks);
#line 2210 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_->backlinks = _tmp7_;
#line 17265 "Photo.c"
			}
			__finally339:
			{
				PhotoRow* _tmp8_ = NULL;
#line 2209 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = self->row;
#line 2209 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17274 "Photo.c"
			}
#line 2209 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2209 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 17280 "Photo.c"
					goto __catch338_database_error;
				}
#line 2209 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2209 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 2209 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 17289 "Photo.c"
			}
		}
	}
	goto __finally338;
	__catch338_database_error:
	{
		GError* err = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
#line 2207 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 2207 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 2213 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 2213 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = _tmp9_;
#line 2213 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = err;
#line 2213 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = _tmp11_->message;
#line 2213 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:2213: Unable to update link state for %s: %s", _tmp10_, _tmp12_);
#line 2213 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp10_);
#line 2207 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 17319 "Photo.c"
	}
	__finally338:
#line 2207 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2207 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2207 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2207 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 17330 "Photo.c"
	}
}


static gboolean photo_real_set_event_id (MediaSource* base, EventID* event_id) {
	Photo * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 2221 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2221 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (event_id != NULL, FALSE);
#line 17343 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
		gboolean _tmp13_ = FALSE;
#line 2222 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2222 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 17351 "Photo.c"
		{
			gboolean committed = FALSE;
			PhotoTable* _tmp1_ = NULL;
			PhotoTable* _tmp2_ = NULL;
			PhotoRow* _tmp3_ = NULL;
			PhotoID _tmp4_ = {0};
			EventID _tmp5_ = {0};
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
#line 2223 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = photo_table_get_instance ();
#line 2223 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_;
#line 2223 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 2223 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _tmp3_->photo_id;
#line 2223 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = *event_id;
#line 2223 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = photo_table_set_event (_tmp2_, &_tmp4_, &_tmp5_);
#line 2223 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = _tmp6_;
#line 2223 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp2_);
#line 2223 "/home/jens/Source/shotwell/src/Photo.vala"
			committed = _tmp7_;
#line 2225 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = committed;
#line 2225 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp8_) {
#line 17384 "Photo.c"
				PhotoRow* _tmp9_ = NULL;
				EventID _tmp10_ = {0};
#line 2226 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = self->row;
#line 2226 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = *event_id;
#line 2226 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_->event_id = _tmp10_;
#line 17393 "Photo.c"
			}
#line 2228 "/home/jens/Source/shotwell/src/Photo.vala"
			result = committed;
#line 17397 "Photo.c"
			{
				PhotoRow* _tmp11_ = NULL;
#line 2222 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = self->row;
#line 2222 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17404 "Photo.c"
			}
#line 2228 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 17408 "Photo.c"
		}
		__finally340:
		{
			PhotoRow* _tmp12_ = NULL;
#line 2222 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = self->row;
#line 2222 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17417 "Photo.c"
		}
#line 2222 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2222 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2222 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp13_;
#line 17425 "Photo.c"
	}
}


static gchar* photo_real_to_string (DataObject* base) {
	Photo * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	PhotoID _tmp10_ = {0};
	gint64 _tmp11_ = 0LL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	PhotoFileReader* _tmp14_ = NULL;
	PhotoFileReader* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
#line 2232 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2234 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = photo_is_master_baseline (self);
#line 2234 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp1_) {
#line 17451 "Photo.c"
		GFile* _tmp2_ = NULL;
		GFile* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 2234 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = photo_get_actual_file (self);
#line 2234 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = _tmp2_;
#line 2234 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = g_file_get_path (_tmp3_);
#line 2234 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = _tmp4_;
#line 2234 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = g_strconcat (" (", _tmp5_, NULL);
#line 2234 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = _tmp6_;
#line 2234 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp8_ = g_strconcat (_tmp7_, ")", NULL);
#line 2234 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp0_);
#line 2234 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = _tmp8_;
#line 2234 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp7_);
#line 2234 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp5_);
#line 2234 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp3_);
#line 17483 "Photo.c"
	} else {
		gchar* _tmp9_ = NULL;
#line 2234 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp9_ = g_strdup ("");
#line 2234 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp0_);
#line 2234 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = _tmp9_;
#line 17492 "Photo.c"
	}
#line 2233 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_get_photo_id (self, &_tmp10_);
#line 2233 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = _tmp10_.id;
#line 2233 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp11_);
#line 2233 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = _tmp12_;
#line 2233 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = photo_get_master_reader (self);
#line 2233 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = _tmp14_;
#line 2233 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2233 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = _tmp16_;
#line 2233 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = g_strdup_printf ("[%s] %s%s", _tmp13_, _tmp17_, _tmp0_);
#line 2233 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = _tmp18_;
#line 2233 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp17_);
#line 2233 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp15_);
#line 2233 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp13_);
#line 2233 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp19_;
#line 2233 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (_tmp0_);
#line 2233 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 17526 "Photo.c"
}


static gboolean photo_real_equals (DataSource* base, DataSource* source) {
	Photo * self;
	gboolean result = FALSE;
	Photo* photo = NULL;
	DataSource* _tmp0_ = NULL;
	Photo* _tmp1_ = NULL;
	Photo* _tmp2_ = NULL;
	DataSource* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
#line 2237 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2237 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((source == NULL) || IS_DATA_SOURCE (source), FALSE);
#line 2239 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = source;
#line 2239 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_PHOTO) ? ((Photo*) _tmp0_) : NULL);
#line 2239 "/home/jens/Source/shotwell/src/Photo.vala"
	photo = _tmp1_;
#line 2240 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo;
#line 2240 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_ != NULL) {
#line 17553 "Photo.c"
		PhotoID photo_id = {0};
		PhotoID _tmp3_ = {0};
		PhotoID other_photo_id = {0};
		Photo* _tmp4_ = NULL;
		PhotoID _tmp5_ = {0};
		gboolean _tmp6_ = FALSE;
		Photo* _tmp7_ = NULL;
#line 2241 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_get_photo_id (self, &_tmp3_);
#line 2241 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_id = _tmp3_;
#line 2242 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = photo;
#line 2242 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_get_photo_id (_tmp4_, &_tmp5_);
#line 2242 "/home/jens/Source/shotwell/src/Photo.vala"
		other_photo_id = _tmp5_;
#line 2244 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = photo;
#line 2244 "/home/jens/Source/shotwell/src/Photo.vala"
		if (self != _tmp7_) {
#line 17575 "Photo.c"
			PhotoID _tmp8_ = {0};
			gint64 _tmp9_ = 0LL;
#line 2244 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = photo_id;
#line 2244 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = _tmp8_.id;
#line 2244 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _tmp9_ != PHOTO_ID_INVALID;
#line 17584 "Photo.c"
		} else {
#line 2244 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = FALSE;
#line 17588 "Photo.c"
		}
#line 2244 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp6_) {
#line 17592 "Photo.c"
			PhotoID _tmp10_ = {0};
			gint64 _tmp11_ = 0LL;
			PhotoID _tmp12_ = {0};
			gint64 _tmp13_ = 0LL;
#line 2245 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = photo_id;
#line 2245 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = _tmp10_.id;
#line 2245 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = other_photo_id;
#line 2245 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = _tmp12_.id;
#line 2245 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_assert (_tmp11_ != _tmp13_, "photo_id.id != other_photo_id.id");
#line 17607 "Photo.c"
		}
	}
#line 2249 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = source;
#line 2249 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = DATA_SOURCE_CLASS (photo_parent_class)->equals (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource), TYPE_DATA_SOURCE, DataSource), _tmp14_);
#line 2249 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp15_;
#line 2249 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (photo);
#line 2249 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 17620 "Photo.c"
}


static void photo_file_exif_updated (Photo* self) {
	GFile* file = NULL;
	GFile* _tmp0_ = NULL;
	GFileInfo* info = NULL;
	GTimeVal timestamp = {0};
	GFileInfo* _tmp7_ = NULL;
	GTimeVal _tmp8_ = {0};
	PhotoFileInterrogator* interrogator = NULL;
	PhotoFileInterrogator* _tmp9_ = NULL;
	DetectedPhotoInformation* detected = NULL;
	DetectedPhotoInformation* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	DetectedPhotoInformation* _tmp16_ = NULL;
	gboolean success = FALSE;
	gboolean _tmp37_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2253 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2254 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 2254 "/home/jens/Source/shotwell/src/Photo.vala"
	file = _tmp0_;
#line 2256 "/home/jens/Source/shotwell/src/Photo.vala"
	info = NULL;
#line 17648 "Photo.c"
	{
		GFileInfo* _tmp1_ = NULL;
		GFileInfo* _tmp2_ = NULL;
		GFileInfo* _tmp3_ = NULL;
#line 2258 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = g_file_query_info (file, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
#line 2258 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp2_;
#line 2258 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 17659 "Photo.c"
			goto __catch341_g_error;
		}
#line 2258 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = _tmp1_;
#line 2258 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = NULL;
#line 2258 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 2258 "/home/jens/Source/shotwell/src/Photo.vala"
		info = _tmp3_;
#line 2257 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp1_);
#line 17672 "Photo.c"
	}
	goto __finally341;
	__catch341_g_error:
	{
		GError* err = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 2257 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 2257 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 2261 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 2261 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = _tmp4_;
#line 2261 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = err->message;
#line 2261 "/home/jens/Source/shotwell/src/Photo.vala"
		g_error ("Photo.vala:2261: Unable to read file information for %s: %s", _tmp5_, _tmp6_);
#line 2261 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp5_);
#line 2257 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 17697 "Photo.c"
	}
	__finally341:
#line 2257 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2257 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 2257 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 2257 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2257 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2257 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 17712 "Photo.c"
	}
#line 2264 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = info;
#line 2264 "/home/jens/Source/shotwell/src/Photo.vala"
	g_file_info_get_modification_time (_tmp7_, &_tmp8_);
#line 2264 "/home/jens/Source/shotwell/src/Photo.vala"
	timestamp = _tmp8_;
#line 2267 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = photo_file_interrogator_new (file, PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL);
#line 2267 "/home/jens/Source/shotwell/src/Photo.vala"
	interrogator = _tmp9_;
#line 17724 "Photo.c"
	{
#line 2269 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_file_interrogator_interrogate (interrogator, &_inner_error_);
#line 2269 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 17730 "Photo.c"
			goto __catch342_g_error;
		}
	}
	goto __finally342;
	__catch342_g_error:
	{
		GError* err = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
#line 2268 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 2268 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 2271 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = g_file_get_path (file);
#line 2271 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = _tmp10_;
#line 2271 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = err;
#line 2271 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = _tmp12_->message;
#line 2271 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:2271: Unable to interrogate photo file %s: %s", _tmp11_, _tmp13_);
#line 2271 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp11_);
#line 2268 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 17760 "Photo.c"
	}
	__finally342:
#line 2268 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2268 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 2268 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 2268 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 2268 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2268 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2268 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 17777 "Photo.c"
	}
#line 2274 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = photo_file_interrogator_get_detected_photo_information (interrogator);
#line 2274 "/home/jens/Source/shotwell/src/Photo.vala"
	detected = _tmp14_;
#line 2275 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = detected;
#line 2275 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp16_ == NULL) {
#line 2275 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = TRUE;
#line 17789 "Photo.c"
	} else {
		gboolean _tmp17_ = FALSE;
#line 2275 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = photo_file_interrogator_get_is_photo_corrupted (interrogator);
#line 2275 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = _tmp17_;
#line 17796 "Photo.c"
	}
#line 2275 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp15_) {
#line 17800 "Photo.c"
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
#line 2276 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 2276 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = _tmp18_;
#line 2276 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("Photo.vala:2276: file_exif_updated: %s no longer an image", _tmp19_);
#line 2276 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp19_);
#line 2278 "/home/jens/Source/shotwell/src/Photo.vala"
		_detected_photo_information_unref0 (detected);
#line 2278 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_interrogator_unref0 (interrogator);
#line 2278 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (info);
#line 2278 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (file);
#line 2278 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 17821 "Photo.c"
	}
	{
		PhotoRow* _tmp20_ = NULL;
#line 2282 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = self->row;
#line 2282 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 17829 "Photo.c"
		{
			PhotoTable* _tmp21_ = NULL;
			PhotoTable* _tmp22_ = NULL;
			PhotoID _tmp23_ = {0};
			GFileInfo* _tmp24_ = NULL;
			gint64 _tmp25_ = 0LL;
			GTimeVal _tmp26_ = {0};
			glong _tmp27_ = 0L;
			DetectedPhotoInformation* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			DetectedPhotoInformation* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			DetectedPhotoInformation* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			PhotoRow* _tmp34_ = NULL;
			gboolean _tmp35_ = FALSE;
#line 2283 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp21_ = photo_table_get_instance ();
#line 2283 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp22_ = _tmp21_;
#line 2283 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_get_photo_id (self, &_tmp23_);
#line 2283 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp24_ = info;
#line 2283 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp25_ = g_file_info_get_size (_tmp24_);
#line 2283 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp26_ = timestamp;
#line 2283 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp27_ = _tmp26_.tv_sec;
#line 2283 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp28_ = detected;
#line 2283 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp29_ = _tmp28_->md5;
#line 2283 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp30_ = detected;
#line 2283 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp31_ = _tmp30_->exif_md5;
#line 2283 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp32_ = detected;
#line 2283 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp33_ = _tmp32_->thumbnail_md5;
#line 2283 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp34_ = self->row;
#line 2283 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp35_ = photo_table_master_exif_updated (_tmp22_, &_tmp23_, _tmp25_, _tmp27_, _tmp29_, _tmp31_, _tmp33_, _tmp34_);
#line 2283 "/home/jens/Source/shotwell/src/Photo.vala"
			success = _tmp35_;
#line 2283 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp22_);
#line 17880 "Photo.c"
		}
		__finally343:
		{
			PhotoRow* _tmp36_ = NULL;
#line 2282 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp36_ = self->row;
#line 2282 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17889 "Photo.c"
		}
#line 2282 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2282 "/home/jens/Source/shotwell/src/Photo.vala"
			_detected_photo_information_unref0 (detected);
#line 2282 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_interrogator_unref0 (interrogator);
#line 2282 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (info);
#line 2282 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (file);
#line 2282 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2282 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2282 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 17907 "Photo.c"
		}
	}
#line 2287 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp37_ = success;
#line 2287 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp37_) {
#line 17914 "Photo.c"
		Alteration* _tmp38_ = NULL;
		Alteration* _tmp39_ = NULL;
#line 2288 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp38_ = alteration_new_from_list ("metadata:exif,metadata:md5");
#line 2288 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp39_ = _tmp38_;
#line 2288 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp39_);
#line 2288 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp39_);
#line 17925 "Photo.c"
	}
#line 2253 "/home/jens/Source/shotwell/src/Photo.vala"
	_detected_photo_information_unref0 (detected);
#line 2253 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_interrogator_unref0 (interrogator);
#line 2253 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (info);
#line 2253 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (file);
#line 17935 "Photo.c"
}


static guint64 photo_real_get_filesize (MediaSource* base) {
	Photo * self;
	guint64 result = 0ULL;
	GError * _inner_error_ = NULL;
#line 2293 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 17945 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
		guint64 _tmp5_ = 0ULL;
#line 2294 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2294 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 17953 "Photo.c"
		{
			BackingPhotoRow* _tmp1_ = NULL;
			gint64 _tmp2_ = 0LL;
#line 2295 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->backing_photo_row;
#line 2295 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->filesize;
#line 2295 "/home/jens/Source/shotwell/src/Photo.vala"
			result = (guint64) _tmp2_;
#line 17963 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 2294 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2294 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17970 "Photo.c"
			}
#line 2295 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 17974 "Photo.c"
		}
		__finally344:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2294 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2294 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 17983 "Photo.c"
		}
#line 2294 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2294 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2294 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp5_;
#line 17991 "Photo.c"
	}
}


static guint64 photo_real_get_master_filesize (MediaSource* base) {
	Photo * self;
	guint64 result = 0ULL;
	GError * _inner_error_ = NULL;
#line 2299 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 18002 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
		guint64 _tmp6_ = 0ULL;
#line 2300 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2300 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 18010 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			BackingPhotoRow* _tmp2_ = NULL;
			gint64 _tmp3_ = 0LL;
#line 2301 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2301 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->master;
#line 2301 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _tmp2_->filesize;
#line 2301 "/home/jens/Source/shotwell/src/Photo.vala"
			result = (guint64) _tmp3_;
#line 18023 "Photo.c"
			{
				PhotoRow* _tmp4_ = NULL;
#line 2300 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2300 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18030 "Photo.c"
			}
#line 2301 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 18034 "Photo.c"
		}
		__finally345:
		{
			PhotoRow* _tmp5_ = NULL;
#line 2300 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2300 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18043 "Photo.c"
		}
#line 2300 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2300 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2300 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp6_;
#line 18051 "Photo.c"
	}
}


guint64 photo_get_editable_filesize (Photo* self) {
	guint64 result = 0ULL;
	GError * _inner_error_ = NULL;
#line 2305 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
#line 18061 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
		guint64 _tmp5_ = 0ULL;
#line 2306 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2306 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 18069 "Photo.c"
		{
			BackingPhotoRow* _tmp1_ = NULL;
			gint64 _tmp2_ = 0LL;
#line 2307 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->editable;
#line 2307 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->filesize;
#line 2307 "/home/jens/Source/shotwell/src/Photo.vala"
			result = (guint64) _tmp2_;
#line 18079 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 2306 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2306 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18086 "Photo.c"
			}
#line 2307 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 18090 "Photo.c"
		}
		__finally346:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2306 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2306 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18099 "Photo.c"
		}
#line 2306 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2306 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2306 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp5_;
#line 18107 "Photo.c"
	}
}


static time_t photo_real_get_exposure_time (Dateable* base) {
	Photo * self;
	time_t result = 0;
	time_t _tmp0_ = 0;
#line 2311 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2312 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = self->priv->cached_exposure_time;
#line 2312 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 2312 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 18124 "Photo.c"
}


static gchar* photo_real_get_basename (MediaSource* base) {
	Photo * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 2315 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 18134 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2316 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2316 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 18141 "Photo.c"
		{
			const gchar* _tmp1_ = NULL;
			gchar* _tmp2_ = NULL;
#line 2317 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->file_title;
#line 2317 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = g_strdup (_tmp1_);
#line 2317 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 18151 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 2316 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2316 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18158 "Photo.c"
			}
#line 2317 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 18162 "Photo.c"
		}
		__finally347:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2316 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2316 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18171 "Photo.c"
		}
#line 2316 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2316 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2316 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 18179 "Photo.c"
	}
}


static gchar* photo_real_get_title (MediaSource* base) {
	Photo * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 2321 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 18190 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2322 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2322 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 18197 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
#line 2323 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2323 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->title;
#line 2323 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 2323 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 18210 "Photo.c"
			{
				PhotoRow* _tmp4_ = NULL;
#line 2322 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2322 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18217 "Photo.c"
			}
#line 2323 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 18221 "Photo.c"
		}
		__finally348:
		{
			PhotoRow* _tmp5_ = NULL;
#line 2322 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2322 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18230 "Photo.c"
		}
#line 2322 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2322 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2322 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 18238 "Photo.c"
	}
}


static gchar* photo_real_get_comment (MediaSource* base) {
	Photo * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 2327 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 18249 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2328 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2328 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 18256 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
#line 2329 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2329 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->comment;
#line 2329 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 2329 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 18269 "Photo.c"
			{
				PhotoRow* _tmp4_ = NULL;
#line 2328 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2328 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18276 "Photo.c"
			}
#line 2329 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 18280 "Photo.c"
		}
		__finally349:
		{
			PhotoRow* _tmp5_ = NULL;
#line 2328 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2328 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18289 "Photo.c"
		}
#line 2328 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2328 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2328 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 18297 "Photo.c"
	}
}


static void photo_real_set_title (MediaSource* base, const gchar* title) {
	Photo * self;
	gchar* new_title = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean committed = FALSE;
	gboolean _tmp18_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2333 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2334 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = title;
#line 2334 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = media_source_prep_title (_tmp0_);
#line 2334 "/home/jens/Source/shotwell/src/Photo.vala"
	new_title = _tmp1_;
#line 2336 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 18320 "Photo.c"
	{
		PhotoRow* _tmp2_ = NULL;
#line 2337 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = self->row;
#line 2337 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 18327 "Photo.c"
		{
			const gchar* _tmp3_ = NULL;
			PhotoRow* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			PhotoTable* _tmp7_ = NULL;
			PhotoTable* _tmp8_ = NULL;
			PhotoRow* _tmp9_ = NULL;
			PhotoID _tmp10_ = {0};
			const gchar* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
#line 2338 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = new_title;
#line 2338 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2338 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = _tmp4_->title;
#line 2338 "/home/jens/Source/shotwell/src/Photo.vala"
			if (g_strcmp0 (_tmp3_, _tmp5_) == 0) {
#line 18347 "Photo.c"
				{
					PhotoRow* _tmp6_ = NULL;
#line 2337 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp6_ = self->row;
#line 2337 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18354 "Photo.c"
				}
#line 2339 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (new_title);
#line 2339 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 18360 "Photo.c"
			}
#line 2341 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = photo_table_get_instance ();
#line 2341 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = _tmp7_;
#line 2341 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = self->row;
#line 2341 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = _tmp9_->photo_id;
#line 2341 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = new_title;
#line 2341 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = photo_table_set_title (_tmp8_, &_tmp10_, _tmp11_);
#line 2341 "/home/jens/Source/shotwell/src/Photo.vala"
			committed = _tmp12_;
#line 2341 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp8_);
#line 2342 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = committed;
#line 2342 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp13_) {
#line 18382 "Photo.c"
				PhotoRow* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
#line 2343 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = self->row;
#line 2343 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = new_title;
#line 2343 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = g_strdup (_tmp15_);
#line 2343 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (_tmp14_->title);
#line 2343 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_->title = _tmp16_;
#line 18396 "Photo.c"
			}
		}
		__finally350:
		{
			PhotoRow* _tmp17_ = NULL;
#line 2337 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = self->row;
#line 2337 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18406 "Photo.c"
		}
#line 2337 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2337 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (new_title);
#line 2337 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2337 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2337 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 18418 "Photo.c"
		}
	}
#line 2346 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = committed;
#line 2346 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp18_) {
#line 18425 "Photo.c"
		Alteration* _tmp19_ = NULL;
		Alteration* _tmp20_ = NULL;
#line 2347 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = alteration_new ("metadata", "name");
#line 2347 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = _tmp19_;
#line 2347 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp20_);
#line 2347 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp20_);
#line 18436 "Photo.c"
	}
#line 2333 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (new_title);
#line 18440 "Photo.c"
}


static gboolean photo_real_set_comment (MediaSource* base, const gchar* comment) {
	Photo * self;
	gboolean result = FALSE;
	gchar* new_comment = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean committed = FALSE;
	gboolean _tmp19_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2350 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2351 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = comment;
#line 2351 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = media_source_prep_comment (_tmp0_);
#line 2351 "/home/jens/Source/shotwell/src/Photo.vala"
	new_comment = _tmp1_;
#line 2353 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 18463 "Photo.c"
	{
		PhotoRow* _tmp2_ = NULL;
#line 2354 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = self->row;
#line 2354 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 18470 "Photo.c"
		{
			const gchar* _tmp3_ = NULL;
			PhotoRow* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			PhotoTable* _tmp7_ = NULL;
			PhotoTable* _tmp8_ = NULL;
			PhotoRow* _tmp9_ = NULL;
			PhotoID _tmp10_ = {0};
			const gchar* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
#line 2355 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = new_comment;
#line 2355 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2355 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = _tmp4_->comment;
#line 2355 "/home/jens/Source/shotwell/src/Photo.vala"
			if (g_strcmp0 (_tmp3_, _tmp5_) == 0) {
#line 2356 "/home/jens/Source/shotwell/src/Photo.vala"
				result = TRUE;
#line 18492 "Photo.c"
				{
					PhotoRow* _tmp6_ = NULL;
#line 2354 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp6_ = self->row;
#line 2354 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18499 "Photo.c"
				}
#line 2356 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (new_comment);
#line 2356 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 18505 "Photo.c"
			}
#line 2358 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = photo_table_get_instance ();
#line 2358 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = _tmp7_;
#line 2358 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = self->row;
#line 2358 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = _tmp9_->photo_id;
#line 2358 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = new_comment;
#line 2358 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = photo_table_set_comment (_tmp8_, &_tmp10_, _tmp11_);
#line 2358 "/home/jens/Source/shotwell/src/Photo.vala"
			committed = _tmp12_;
#line 2358 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp8_);
#line 2359 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = committed;
#line 2359 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp13_) {
#line 18527 "Photo.c"
				PhotoRow* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
#line 2360 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = self->row;
#line 2360 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = new_comment;
#line 2360 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = g_strdup (_tmp15_);
#line 2360 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (_tmp14_->comment);
#line 2360 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_->comment = _tmp16_;
#line 18541 "Photo.c"
			}
		}
		__finally351:
		{
			PhotoRow* _tmp17_ = NULL;
#line 2354 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = self->row;
#line 2354 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18551 "Photo.c"
		}
#line 2354 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 18555 "Photo.c"
			gboolean _tmp18_ = FALSE;
#line 2354 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (new_comment);
#line 2354 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2354 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2354 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp18_;
#line 18565 "Photo.c"
		}
	}
#line 2363 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = committed;
#line 2363 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp19_) {
#line 18572 "Photo.c"
		Alteration* _tmp20_ = NULL;
		Alteration* _tmp21_ = NULL;
#line 2364 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = alteration_new ("metadata", "comment");
#line 2364 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = _tmp20_;
#line 2364 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp21_);
#line 2364 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp21_);
#line 18583 "Photo.c"
	}
#line 2366 "/home/jens/Source/shotwell/src/Photo.vala"
	result = committed;
#line 2366 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (new_comment);
#line 2366 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 18591 "Photo.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 2376 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? g_error_copy (self) : NULL;
#line 18598 "Photo.c"
}


void photo_set_import_id (Photo* self, ImportID* import_id) {
	GError* dberr = NULL;
	GError* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
#line 2369 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2369 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (import_id != NULL);
#line 2370 "/home/jens/Source/shotwell/src/Photo.vala"
	dberr = NULL;
#line 18612 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 18619 "Photo.c"
		{
			{
				PhotoTable* _tmp1_ = NULL;
				PhotoTable* _tmp2_ = NULL;
				PhotoRow* _tmp3_ = NULL;
				PhotoID _tmp4_ = {0};
				ImportID _tmp5_ = {0};
				PhotoRow* _tmp7_ = NULL;
				ImportID _tmp8_ = {0};
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = photo_table_get_instance ();
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp2_ = _tmp1_;
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_->photo_id;
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = *import_id;
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_table_set_import_id (_tmp2_, &_tmp4_, &_tmp5_, &_inner_error_);
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp2_);
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 18647 "Photo.c"
						goto __catch353_database_error;
					}
					{
						PhotoRow* _tmp6_ = NULL;
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp6_ = self->row;
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18656 "Photo.c"
					}
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_error_free0 (dberr);
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
					g_clear_error (&_inner_error_);
#line 2373 "/home/jens/Source/shotwell/src/Photo.vala"
					return;
#line 18666 "Photo.c"
				}
#line 2374 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = self->row;
#line 2374 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = *import_id;
#line 2374 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_->import_id = _tmp8_;
#line 18674 "Photo.c"
			}
			goto __finally353;
			__catch353_database_error:
			{
				GError* err = NULL;
				GError* _tmp9_ = NULL;
				GError* _tmp10_ = NULL;
#line 2372 "/home/jens/Source/shotwell/src/Photo.vala"
				err = _inner_error_;
#line 2372 "/home/jens/Source/shotwell/src/Photo.vala"
				_inner_error_ = NULL;
#line 2376 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = err;
#line 2376 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = _g_error_copy0 (_tmp9_);
#line 2376 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (dberr);
#line 2376 "/home/jens/Source/shotwell/src/Photo.vala"
				dberr = _tmp10_;
#line 2372 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (err);
#line 18696 "Photo.c"
			}
			__finally353:
#line 2372 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 18701 "Photo.c"
				{
					PhotoRow* _tmp11_ = NULL;
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = self->row;
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
					g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18708 "Photo.c"
				}
#line 2372 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_error_free0 (dberr);
#line 2372 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2372 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 2372 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 18718 "Photo.c"
			}
		}
		__finally352:
		{
			PhotoRow* _tmp12_ = NULL;
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = self->row;
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 18728 "Photo.c"
		}
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_error_free0 (dberr);
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2371 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 18740 "Photo.c"
		}
	}
#line 2380 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = dberr;
#line 2380 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp13_ == NULL) {
#line 18747 "Photo.c"
		Alteration* _tmp14_ = NULL;
		Alteration* _tmp15_ = NULL;
#line 2381 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp14_ = alteration_new ("metadata", "import-id");
#line 2381 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = _tmp14_;
#line 2381 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp15_);
#line 2381 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp15_);
#line 18758 "Photo.c"
	} else {
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 2383 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 2383 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = _tmp16_;
#line 2383 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = dberr;
#line 2383 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = _tmp18_->message;
#line 2383 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:2383: Unable to write import ID for %s: %s", _tmp17_, _tmp19_);
#line 2383 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp17_);
#line 18776 "Photo.c"
	}
#line 2369 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_error_free0 (dberr);
#line 18780 "Photo.c"
}


void photo_set_title_persistent (Photo* self, const gchar* title, GError** error) {
	PhotoFileReader* source = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	PhotoFileFormat _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	PhotoMetadata* metadata = NULL;
	PhotoFileReader* _tmp8_ = NULL;
	PhotoMetadata* _tmp9_ = NULL;
	PhotoMetadata* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	PhotoFileMetadataWriter* writer = NULL;
	PhotoFileReader* _tmp12_ = NULL;
	PhotoFileMetadataWriter* _tmp13_ = NULL;
	PhotoFileReader* _tmp14_ = NULL;
	GFile* _tmp15_ = NULL;
	GFile* _tmp16_ = NULL;
	const gchar* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
#line 2386 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2387 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_source_reader (self);
#line 2387 "/home/jens/Source/shotwell/src/Photo.vala"
	source = _tmp0_;
#line 2390 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = source;
#line 2390 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2390 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_file_format_can_write_metadata (_tmp2_);
#line 2390 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp3_) {
#line 18817 "Photo.c"
		PhotoFileReader* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 2391 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = source;
#line 2391 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2391 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = _tmp5_;
#line 2391 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:2391: No photo file writer available for %s", _tmp6_);
#line 2391 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp6_);
#line 2393 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = title;
#line 2393 "/home/jens/Source/shotwell/src/Photo.vala"
		media_source_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp7_);
#line 2395 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2395 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 18840 "Photo.c"
	}
#line 2398 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = source;
#line 2398 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = photo_file_reader_read_metadata (_tmp8_, &_inner_error_);
#line 2398 "/home/jens/Source/shotwell/src/Photo.vala"
	metadata = _tmp9_;
#line 2398 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2398 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2398 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2398 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 18856 "Photo.c"
	}
#line 2399 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = metadata;
#line 2399 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = title;
#line 2399 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_metadata_set_title (_tmp10_, _tmp11_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
#line 2401 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = source;
#line 2401 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = photo_file_reader_create_metadata_writer (_tmp12_, &_inner_error_);
#line 2401 "/home/jens/Source/shotwell/src/Photo.vala"
	writer = _tmp13_;
#line 2401 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2401 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2401 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2401 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2401 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 18880 "Photo.c"
	}
#line 2402 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = source;
#line 2402 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2402 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = _tmp15_;
#line 2402 "/home/jens/Source/shotwell/src/Photo.vala"
	library_monitor_blacklist_file (_tmp16_, "Photo.set_persistent_title");
#line 2402 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp16_);
#line 18892 "Photo.c"
	{
		PhotoFileMetadataWriter* _tmp17_ = NULL;
		PhotoMetadata* _tmp18_ = NULL;
#line 2404 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = writer;
#line 2404 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = metadata;
#line 2404 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_file_metadata_writer_write_metadata (_tmp17_, _tmp18_, &_inner_error_);
#line 2404 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 18904 "Photo.c"
			goto __finally354;
		}
	}
	__finally354:
	{
		PhotoFileReader* _tmp19_ = NULL;
		GFile* _tmp20_ = NULL;
		GFile* _tmp21_ = NULL;
#line 2406 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = source;
#line 2406 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2406 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = _tmp20_;
#line 2406 "/home/jens/Source/shotwell/src/Photo.vala"
		library_monitor_unblacklist_file (_tmp21_);
#line 2406 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp21_);
#line 18923 "Photo.c"
	}
#line 2403 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2403 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2403 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (writer);
#line 2403 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2403 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2403 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 18937 "Photo.c"
	}
#line 2409 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = title;
#line 2409 "/home/jens/Source/shotwell/src/Photo.vala"
	media_source_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp22_);
#line 2411 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_file_exif_updated (self);
#line 2386 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (writer);
#line 2386 "/home/jens/Source/shotwell/src/Photo.vala"
	_media_metadata_unref0 (metadata);
#line 2386 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (source);
#line 18951 "Photo.c"
}


void photo_set_comment_persistent (Photo* self, const gchar* comment, GError** error) {
	PhotoFileReader* source = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	PhotoFileFormat _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	PhotoMetadata* metadata = NULL;
	PhotoFileReader* _tmp8_ = NULL;
	PhotoMetadata* _tmp9_ = NULL;
	PhotoMetadata* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	PhotoFileMetadataWriter* writer = NULL;
	PhotoFileReader* _tmp12_ = NULL;
	PhotoFileMetadataWriter* _tmp13_ = NULL;
	PhotoFileReader* _tmp14_ = NULL;
	GFile* _tmp15_ = NULL;
	GFile* _tmp16_ = NULL;
	const gchar* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
#line 2414 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2415 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_source_reader (self);
#line 2415 "/home/jens/Source/shotwell/src/Photo.vala"
	source = _tmp0_;
#line 2418 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = source;
#line 2418 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2418 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_file_format_can_write_metadata (_tmp2_);
#line 2418 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp3_) {
#line 18988 "Photo.c"
		PhotoFileReader* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 2419 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = source;
#line 2419 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2419 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = _tmp5_;
#line 2419 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:2419: No photo file writer available for %s", _tmp6_);
#line 2419 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp6_);
#line 2421 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = comment;
#line 2421 "/home/jens/Source/shotwell/src/Photo.vala"
		media_source_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp7_);
#line 2423 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2423 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19011 "Photo.c"
	}
#line 2426 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = source;
#line 2426 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = photo_file_reader_read_metadata (_tmp8_, &_inner_error_);
#line 2426 "/home/jens/Source/shotwell/src/Photo.vala"
	metadata = _tmp9_;
#line 2426 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2426 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2426 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2426 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19027 "Photo.c"
	}
#line 2427 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = metadata;
#line 2427 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = comment;
#line 2427 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_metadata_set_comment (_tmp10_, _tmp11_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
#line 2429 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = source;
#line 2429 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = photo_file_reader_create_metadata_writer (_tmp12_, &_inner_error_);
#line 2429 "/home/jens/Source/shotwell/src/Photo.vala"
	writer = _tmp13_;
#line 2429 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2429 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2429 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2429 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2429 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19051 "Photo.c"
	}
#line 2430 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = source;
#line 2430 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2430 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = _tmp15_;
#line 2430 "/home/jens/Source/shotwell/src/Photo.vala"
	library_monitor_blacklist_file (_tmp16_, "Photo.set_persistent_comment");
#line 2430 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp16_);
#line 19063 "Photo.c"
	{
		PhotoFileMetadataWriter* _tmp17_ = NULL;
		PhotoMetadata* _tmp18_ = NULL;
#line 2432 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = writer;
#line 2432 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp18_ = metadata;
#line 2432 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_file_metadata_writer_write_metadata (_tmp17_, _tmp18_, &_inner_error_);
#line 2432 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 19075 "Photo.c"
			goto __finally355;
		}
	}
	__finally355:
	{
		PhotoFileReader* _tmp19_ = NULL;
		GFile* _tmp20_ = NULL;
		GFile* _tmp21_ = NULL;
#line 2434 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = source;
#line 2434 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2434 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = _tmp20_;
#line 2434 "/home/jens/Source/shotwell/src/Photo.vala"
		library_monitor_unblacklist_file (_tmp21_);
#line 2434 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp21_);
#line 19094 "Photo.c"
	}
#line 2431 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2431 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2431 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (writer);
#line 2431 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2431 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2431 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19108 "Photo.c"
	}
#line 2437 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = comment;
#line 2437 "/home/jens/Source/shotwell/src/Photo.vala"
	media_source_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp22_);
#line 2439 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_file_exif_updated (self);
#line 2414 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (writer);
#line 2414 "/home/jens/Source/shotwell/src/Photo.vala"
	_media_metadata_unref0 (metadata);
#line 2414 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (source);
#line 19122 "Photo.c"
}


static void photo_real_set_exposure_time (Dateable* base, time_t time) {
	Photo * self;
	gboolean committed = FALSE;
	gboolean _tmp12_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2442 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 19133 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2444 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2444 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 19140 "Photo.c"
		{
			PhotoTable* _tmp1_ = NULL;
			PhotoTable* _tmp2_ = NULL;
			PhotoRow* _tmp3_ = NULL;
			PhotoID _tmp4_ = {0};
			time_t _tmp5_ = 0;
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
#line 2445 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = photo_table_get_instance ();
#line 2445 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_;
#line 2445 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 2445 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _tmp3_->photo_id;
#line 2445 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = time;
#line 2445 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = photo_table_set_exposure_time (_tmp2_, &_tmp4_, _tmp5_);
#line 2445 "/home/jens/Source/shotwell/src/Photo.vala"
			committed = _tmp6_;
#line 2445 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp2_);
#line 2446 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = committed;
#line 2446 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp7_) {
#line 19169 "Photo.c"
				PhotoRow* _tmp8_ = NULL;
				time_t _tmp9_ = 0;
				time_t _tmp10_ = 0;
#line 2447 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = self->row;
#line 2447 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = time;
#line 2447 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_->exposure_time = _tmp9_;
#line 2448 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = time;
#line 2448 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->cached_exposure_time = _tmp10_;
#line 19183 "Photo.c"
			}
		}
		__finally356:
		{
			PhotoRow* _tmp11_ = NULL;
#line 2444 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = self->row;
#line 2444 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 19193 "Photo.c"
		}
#line 2444 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2444 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2444 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2444 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 19203 "Photo.c"
		}
	}
#line 2452 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = committed;
#line 2452 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp12_) {
#line 19210 "Photo.c"
		Alteration* _tmp13_ = NULL;
		Alteration* _tmp14_ = NULL;
#line 2453 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = alteration_new ("metadata", "exposure-time");
#line 2453 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp14_ = _tmp13_;
#line 2453 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp14_);
#line 2453 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp14_);
#line 19221 "Photo.c"
	}
}


void photo_set_exposure_time_persistent (Photo* self, time_t time, GError** error) {
	PhotoFileReader* source = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	PhotoFileFormat _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	PhotoMetadata* metadata = NULL;
	PhotoFileReader* _tmp8_ = NULL;
	PhotoMetadata* _tmp9_ = NULL;
	PhotoMetadata* _tmp10_ = NULL;
	time_t _tmp11_ = 0;
	MetadataDateTime* _tmp12_ = NULL;
	MetadataDateTime* _tmp13_ = NULL;
	PhotoFileMetadataWriter* writer = NULL;
	PhotoFileReader* _tmp14_ = NULL;
	PhotoFileMetadataWriter* _tmp15_ = NULL;
	PhotoFileReader* _tmp16_ = NULL;
	GFile* _tmp17_ = NULL;
	GFile* _tmp18_ = NULL;
	time_t _tmp24_ = 0;
	GError * _inner_error_ = NULL;
#line 2456 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2457 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_source_reader (self);
#line 2457 "/home/jens/Source/shotwell/src/Photo.vala"
	source = _tmp0_;
#line 2460 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = source;
#line 2460 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2460 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_file_format_can_write_metadata (_tmp2_);
#line 2460 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp3_) {
#line 19261 "Photo.c"
		PhotoFileReader* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		time_t _tmp7_ = 0;
#line 2461 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = source;
#line 2461 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2461 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = _tmp5_;
#line 2461 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:2461: No photo file writer available for %s", _tmp6_);
#line 2461 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (_tmp6_);
#line 2463 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = time;
#line 2463 "/home/jens/Source/shotwell/src/Photo.vala"
		dateable_set_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATEABLE, Dateable), _tmp7_);
#line 2465 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2465 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19284 "Photo.c"
	}
#line 2468 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = source;
#line 2468 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = photo_file_reader_read_metadata (_tmp8_, &_inner_error_);
#line 2468 "/home/jens/Source/shotwell/src/Photo.vala"
	metadata = _tmp9_;
#line 2468 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2468 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2468 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2468 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19300 "Photo.c"
	}
#line 2469 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = metadata;
#line 2469 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = time;
#line 2469 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = metadata_date_time_new (_tmp11_);
#line 2469 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = _tmp12_;
#line 2469 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_metadata_set_exposure_date_time (_tmp10_, _tmp13_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
#line 2469 "/home/jens/Source/shotwell/src/Photo.vala"
	_metadata_date_time_unref0 (_tmp13_);
#line 2471 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = source;
#line 2471 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = photo_file_reader_create_metadata_writer (_tmp14_, &_inner_error_);
#line 2471 "/home/jens/Source/shotwell/src/Photo.vala"
	writer = _tmp15_;
#line 2471 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2471 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2471 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2471 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2471 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19330 "Photo.c"
	}
#line 2472 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = source;
#line 2472 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2472 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = _tmp17_;
#line 2472 "/home/jens/Source/shotwell/src/Photo.vala"
	library_monitor_blacklist_file (_tmp18_, "Photo.set_exposure_time_persistent");
#line 2472 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp18_);
#line 19342 "Photo.c"
	{
		PhotoFileMetadataWriter* _tmp19_ = NULL;
		PhotoMetadata* _tmp20_ = NULL;
#line 2474 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp19_ = writer;
#line 2474 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = metadata;
#line 2474 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_file_metadata_writer_write_metadata (_tmp19_, _tmp20_, &_inner_error_);
#line 2474 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 19354 "Photo.c"
			goto __finally357;
		}
	}
	__finally357:
	{
		PhotoFileReader* _tmp21_ = NULL;
		GFile* _tmp22_ = NULL;
		GFile* _tmp23_ = NULL;
#line 2476 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = source;
#line 2476 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp22_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2476 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23_ = _tmp22_;
#line 2476 "/home/jens/Source/shotwell/src/Photo.vala"
		library_monitor_unblacklist_file (_tmp23_);
#line 2476 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp23_);
#line 19373 "Photo.c"
	}
#line 2473 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2473 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2473 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (writer);
#line 2473 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2473 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (source);
#line 2473 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19387 "Photo.c"
	}
#line 2479 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp24_ = time;
#line 2479 "/home/jens/Source/shotwell/src/Photo.vala"
	dateable_set_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATEABLE, Dateable), _tmp24_);
#line 2481 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_file_exif_updated (self);
#line 2456 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (writer);
#line 2456 "/home/jens/Source/shotwell/src/Photo.vala"
	_media_metadata_unref0 (metadata);
#line 2456 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (source);
#line 19401 "Photo.c"
}


/**
     * @brief Returns the width and height of the Photo after various
     * arbitrary stages of the pipeline have been applied in
     * the same order they're applied in get_pixbuf_with_options.
     * With no argument passed, it works exactly like the
     * previous incarnation did.
     *
     * @param disallowed_steps Which pipeline steps should NOT
     *      be taken into account when computing image dimensions
     *      (matching the convention set by get_pixbuf_with_options()).
     *      Pipeline steps that do not affect the image geometry are
     *      ignored.
     */
static void photo_real_get_dimensions (MediaSource* base, PhotoException disallowed_steps, Dimensions* result) {
	Photo * self;
	Dimensions returned_dims = {0};
	Dimensions _tmp0_ = {0};
	PhotoException _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	PhotoException _tmp10_ = 0;
	gboolean _tmp11_ = FALSE;
	PhotoException _tmp22_ = 0;
	gboolean _tmp23_ = FALSE;
#line 2497 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 2499 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_get_raw_dimensions (self, &_tmp0_);
#line 2499 "/home/jens/Source/shotwell/src/Photo.vala"
	returned_dims = _tmp0_;
#line 2502 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = disallowed_steps;
#line 2502 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_exception_allows (_tmp1_, PHOTO_EXCEPTION_ORIENTATION);
#line 2502 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_) {
#line 19440 "Photo.c"
		Orientation ori_tmp = 0;
		Orientation _tmp3_ = 0;
		Orientation _tmp4_ = 0;
#line 2503 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = photo_get_orientation (self);
#line 2503 "/home/jens/Source/shotwell/src/Photo.vala"
		ori_tmp = _tmp3_;
#line 2506 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = ori_tmp;
#line 2506 "/home/jens/Source/shotwell/src/Photo.vala"
		switch (_tmp4_) {
#line 2506 "/home/jens/Source/shotwell/src/Photo.vala"
			case ORIENTATION_LEFT_TOP:
#line 2506 "/home/jens/Source/shotwell/src/Photo.vala"
			case ORIENTATION_RIGHT_TOP:
#line 2506 "/home/jens/Source/shotwell/src/Photo.vala"
			case ORIENTATION_LEFT_BOTTOM:
#line 2506 "/home/jens/Source/shotwell/src/Photo.vala"
			case ORIENTATION_RIGHT_BOTTOM:
#line 19460 "Photo.c"
			{
				gint width_tmp = 0;
				Dimensions _tmp5_ = {0};
				gint _tmp6_ = 0;
				Dimensions _tmp7_ = {0};
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
#line 2512 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = returned_dims;
#line 2512 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = _tmp5_.width;
#line 2512 "/home/jens/Source/shotwell/src/Photo.vala"
				width_tmp = _tmp6_;
#line 2514 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = returned_dims;
#line 2514 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = _tmp7_.height;
#line 2514 "/home/jens/Source/shotwell/src/Photo.vala"
				returned_dims.width = _tmp8_;
#line 2515 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = width_tmp;
#line 2515 "/home/jens/Source/shotwell/src/Photo.vala"
				returned_dims.height = _tmp9_;
#line 2516 "/home/jens/Source/shotwell/src/Photo.vala"
				break;
#line 19486 "Photo.c"
			}
			default:
			{
#line 2520 "/home/jens/Source/shotwell/src/Photo.vala"
				break;
#line 19492 "Photo.c"
			}
		}
	}
#line 2525 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = disallowed_steps;
#line 2525 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = photo_exception_allows (_tmp10_, PHOTO_EXCEPTION_STRAIGHTEN);
#line 2525 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp11_) {
#line 19502 "Photo.c"
		gdouble x_size = 0.0;
		gdouble y_size = 0.0;
		gdouble angle = 0.0;
		gdouble _tmp12_ = 0.0;
		Dimensions _tmp13_ = {0};
		gint _tmp14_ = 0;
		Dimensions _tmp15_ = {0};
		gint _tmp16_ = 0;
		gdouble _tmp17_ = 0.0;
		gdouble _tmp18_ = 0.0;
		gdouble _tmp19_ = 0.0;
		gdouble _tmp20_ = 0.0;
		gdouble _tmp21_ = 0.0;
#line 2527 "/home/jens/Source/shotwell/src/Photo.vala"
		angle = 0.0;
#line 2529 "/home/jens/Source/shotwell/src/Photo.vala"
		photo_get_straighten (self, &_tmp12_);
#line 2529 "/home/jens/Source/shotwell/src/Photo.vala"
		angle = _tmp12_;
#line 2531 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = returned_dims;
#line 2531 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp14_ = _tmp13_.width;
#line 2531 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = returned_dims;
#line 2531 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = _tmp15_.height;
#line 2531 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = angle;
#line 2531 "/home/jens/Source/shotwell/src/Photo.vala"
		compute_arb_rotated_size ((gdouble) _tmp14_, (gdouble) _tmp16_, _tmp17_, &_tmp18_, &_tmp19_);
#line 2531 "/home/jens/Source/shotwell/src/Photo.vala"
		x_size = _tmp18_;
#line 2531 "/home/jens/Source/shotwell/src/Photo.vala"
		y_size = _tmp19_;
#line 2533 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = x_size;
#line 2533 "/home/jens/Source/shotwell/src/Photo.vala"
		returned_dims.width = (gint) _tmp20_;
#line 2534 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = y_size;
#line 2534 "/home/jens/Source/shotwell/src/Photo.vala"
		returned_dims.height = (gint) _tmp21_;
#line 19546 "Photo.c"
	}
#line 2538 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = disallowed_steps;
#line 2538 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp23_ = photo_exception_allows (_tmp22_, PHOTO_EXCEPTION_CROP);
#line 2538 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp23_) {
#line 19554 "Photo.c"
		Box crop = {0};
		PhotoException _tmp24_ = 0;
		Box _tmp25_ = {0};
		gboolean _tmp26_ = FALSE;
#line 2540 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp24_ = disallowed_steps;
#line 2540 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp26_ = photo_get_crop (self, &_tmp25_, _tmp24_);
#line 2540 "/home/jens/Source/shotwell/src/Photo.vala"
		crop = _tmp25_;
#line 2540 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp26_) {
#line 19567 "Photo.c"
			Dimensions _tmp27_ = {0};
#line 2541 "/home/jens/Source/shotwell/src/Photo.vala"
			box_get_dimensions (&crop, &_tmp27_);
#line 2541 "/home/jens/Source/shotwell/src/Photo.vala"
			returned_dims = _tmp27_;
#line 19573 "Photo.c"
		}
	}
#line 2544 "/home/jens/Source/shotwell/src/Photo.vala"
	*result = returned_dims;
#line 2544 "/home/jens/Source/shotwell/src/Photo.vala"
	return;
#line 19580 "Photo.c"
}


static void photo_locked_create_adjustments_from_data (Photo* self) {
	PixelTransformationBundle* _tmp0_ = NULL;
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp1_ = NULL;
	KeyValueMap* _tmp2_ = NULL;
	PixelTransformationBundle* _tmp6_ = NULL;
	PixelTransformer* _tmp7_ = NULL;
#line 2548 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2549 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = pixel_transformation_bundle_new ();
#line 2549 "/home/jens/Source/shotwell/src/Photo.vala"
	_pixel_transformation_bundle_unref0 (self->priv->adjustments);
#line 2549 "/home/jens/Source/shotwell/src/Photo.vala"
	self->priv->adjustments = _tmp0_;
#line 2551 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = photo_get_transformation (self, "adjustments");
#line 2551 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp1_;
#line 2552 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = map;
#line 2552 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_ == NULL) {
#line 19607 "Photo.c"
		PixelTransformationBundle* _tmp3_ = NULL;
#line 2553 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = self->priv->adjustments;
#line 2553 "/home/jens/Source/shotwell/src/Photo.vala"
		pixel_transformation_bundle_set_to_identity (_tmp3_);
#line 19613 "Photo.c"
	} else {
		PixelTransformationBundle* _tmp4_ = NULL;
		KeyValueMap* _tmp5_ = NULL;
#line 2555 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = self->priv->adjustments;
#line 2555 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = map;
#line 2555 "/home/jens/Source/shotwell/src/Photo.vala"
		pixel_transformation_bundle_load (_tmp4_, _tmp5_);
#line 19623 "Photo.c"
	}
#line 2557 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = self->priv->adjustments;
#line 2557 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = pixel_transformation_bundle_generate_transformer (_tmp6_);
#line 2557 "/home/jens/Source/shotwell/src/Photo.vala"
	_pixel_transformer_unref0 (self->priv->transformer);
#line 2557 "/home/jens/Source/shotwell/src/Photo.vala"
	self->priv->transformer = _tmp7_;
#line 2548 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 19635 "Photo.c"
}


PixelTransformationBundle* photo_get_color_adjustments (Photo* self) {
	PixelTransformationBundle* result = NULL;
	GError * _inner_error_ = NULL;
#line 2561 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 19644 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2562 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2562 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 19651 "Photo.c"
		{
			PixelTransformationBundle* _tmp1_ = NULL;
			PixelTransformationBundle* _tmp2_ = NULL;
			PixelTransformationBundle* _tmp3_ = NULL;
#line 2563 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->adjustments;
#line 2563 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp1_ == NULL) {
#line 2564 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_locked_create_adjustments_from_data (self);
#line 19662 "Photo.c"
			}
#line 2566 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->priv->adjustments;
#line 2566 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = pixel_transformation_bundle_copy (_tmp2_);
#line 2566 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 19670 "Photo.c"
			{
				PhotoRow* _tmp4_ = NULL;
#line 2562 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2562 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 19677 "Photo.c"
			}
#line 2566 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 19681 "Photo.c"
		}
		__finally358:
		{
			PhotoRow* _tmp5_ = NULL;
#line 2562 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2562 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 19690 "Photo.c"
		}
#line 2562 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2562 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2562 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 19698 "Photo.c"
	}
}


PixelTransformer* photo_get_pixel_transformer (Photo* self) {
	PixelTransformer* result = NULL;
	GError * _inner_error_ = NULL;
#line 2570 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 19708 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2571 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2571 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 19715 "Photo.c"
		{
			PixelTransformer* _tmp1_ = NULL;
			PixelTransformer* _tmp2_ = NULL;
			PixelTransformer* _tmp3_ = NULL;
#line 2572 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->priv->transformer;
#line 2572 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp1_ == NULL) {
#line 2573 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_locked_create_adjustments_from_data (self);
#line 19726 "Photo.c"
			}
#line 2575 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->priv->transformer;
#line 2575 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = pixel_transformer_copy (_tmp2_);
#line 2575 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp3_;
#line 19734 "Photo.c"
			{
				PhotoRow* _tmp4_ = NULL;
#line 2571 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2571 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 19741 "Photo.c"
			}
#line 2575 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 19745 "Photo.c"
		}
		__finally359:
		{
			PhotoRow* _tmp5_ = NULL;
#line 2571 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2571 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 19754 "Photo.c"
		}
#line 2571 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2571 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2571 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 19762 "Photo.c"
	}
}


gboolean photo_has_color_adjustments (Photo* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 2579 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2580 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_has_transformation (self, "adjustments");
#line 2580 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 2580 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 19778 "Photo.c"
}


PixelTransformation* photo_get_color_adjustment (Photo* self, PixelTransformationType type) {
	PixelTransformation* result = NULL;
	PixelTransformationBundle* _tmp0_ = NULL;
	PixelTransformationBundle* _tmp1_ = NULL;
	PixelTransformationType _tmp2_ = 0;
	PixelTransformation* _tmp3_ = NULL;
	PixelTransformation* _tmp4_ = NULL;
#line 2583 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 2584 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_color_adjustments (self);
#line 2584 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _tmp0_;
#line 2584 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = type;
#line 2584 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = pixel_transformation_bundle_get_transformation (_tmp1_, _tmp2_);
#line 2584 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp3_;
#line 2584 "/home/jens/Source/shotwell/src/Photo.vala"
	_pixel_transformation_bundle_unref0 (_tmp1_);
#line 2584 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp4_;
#line 2584 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 19807 "Photo.c"
}


void photo_set_color_adjustments (Photo* self, PixelTransformationBundle* new_adjustments) {
	PixelTransformationBundle* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	KeyValueMap* map = NULL;
	PixelTransformationBundle* _tmp8_ = NULL;
	KeyValueMap* _tmp9_ = NULL;
	gboolean committed = FALSE;
	gboolean _tmp39_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2587 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2587 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PIXEL_TRANSFORMATION_BUNDLE (new_adjustments));
#line 2590 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = new_adjustments;
#line 2590 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = pixel_transformation_bundle_is_identity (_tmp0_);
#line 2590 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_) {
#line 19830 "Photo.c"
		gboolean _result_ = FALSE;
		gboolean _tmp5_ = FALSE;
		{
			PhotoRow* _tmp2_ = NULL;
#line 2592 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->row;
#line 2592 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_lock (&self->priv->__lock_row);
#line 19839 "Photo.c"
			{
				gboolean _tmp3_ = FALSE;
#line 2593 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = photo_remove_transformation (self, "adjustments");
#line 2593 "/home/jens/Source/shotwell/src/Photo.vala"
				_result_ = _tmp3_;
#line 2594 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformation_bundle_unref0 (self->priv->adjustments);
#line 2594 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->adjustments = NULL;
#line 2595 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformer_unref0 (self->priv->transformer);
#line 2595 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->transformer = NULL;
#line 19854 "Photo.c"
			}
			__finally360:
			{
				PhotoRow* _tmp4_ = NULL;
#line 2592 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2592 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 19863 "Photo.c"
			}
#line 2592 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2592 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2592 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 2592 "/home/jens/Source/shotwell/src/Photo.vala"
				return;
#line 19873 "Photo.c"
			}
		}
#line 2598 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = _result_;
#line 2598 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp5_) {
#line 19880 "Photo.c"
			Alteration* _tmp6_ = NULL;
			Alteration* _tmp7_ = NULL;
#line 2599 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = alteration_new ("image", "color-adjustments");
#line 2599 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = _tmp6_;
#line 2599 "/home/jens/Source/shotwell/src/Photo.vala"
			data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp7_);
#line 2599 "/home/jens/Source/shotwell/src/Photo.vala"
			_alteration_unref0 (_tmp7_);
#line 19891 "Photo.c"
		}
#line 2601 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 19895 "Photo.c"
	}
#line 2605 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = new_adjustments;
#line 2605 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = pixel_transformation_bundle_save (_tmp8_, "adjustments");
#line 2605 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp9_;
#line 19903 "Photo.c"
	{
		PhotoRow* _tmp10_ = NULL;
#line 2608 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = self->row;
#line 2608 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 19910 "Photo.c"
		{
			gboolean _tmp11_ = FALSE;
			PixelTransformer* _tmp12_ = NULL;
			KeyValueMap* _tmp36_ = NULL;
			gboolean _tmp37_ = FALSE;
#line 2609 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = self->priv->transformer;
#line 2609 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp12_ == NULL) {
#line 2609 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = TRUE;
#line 19922 "Photo.c"
			} else {
				PixelTransformationBundle* _tmp13_ = NULL;
#line 2609 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = self->priv->adjustments;
#line 2609 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = _tmp13_ == NULL;
#line 19929 "Photo.c"
			}
#line 2609 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp11_) {
#line 19933 "Photo.c"
				PixelTransformationBundle* _tmp14_ = NULL;
				PixelTransformationBundle* _tmp15_ = NULL;
				PixelTransformationBundle* _tmp16_ = NULL;
				PixelTransformer* _tmp17_ = NULL;
#line 2611 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = new_adjustments;
#line 2611 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = pixel_transformation_bundle_copy (_tmp14_);
#line 2611 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformation_bundle_unref0 (self->priv->adjustments);
#line 2611 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->adjustments = _tmp15_;
#line 2612 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = new_adjustments;
#line 2612 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = pixel_transformation_bundle_generate_transformer (_tmp16_);
#line 2612 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformer_unref0 (self->priv->transformer);
#line 2612 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->transformer = _tmp17_;
#line 19954 "Photo.c"
			} else {
				PixelTransformationBundle* _tmp34_ = NULL;
				PixelTransformationBundle* _tmp35_ = NULL;
				{
					GeeIterator* _transformation_it = NULL;
					PixelTransformationBundle* _tmp18_ = NULL;
					GeeIterable* _tmp19_ = NULL;
					GeeIterable* _tmp20_ = NULL;
					GeeIterator* _tmp21_ = NULL;
					GeeIterator* _tmp22_ = NULL;
#line 2615 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp18_ = new_adjustments;
#line 2615 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp19_ = pixel_transformation_bundle_get_transformations (_tmp18_);
#line 2615 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp20_ = _tmp19_;
#line 2615 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp21_ = gee_iterable_iterator (_tmp20_);
#line 2615 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp22_ = _tmp21_;
#line 2615 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (_tmp20_);
#line 2615 "/home/jens/Source/shotwell/src/Photo.vala"
					_transformation_it = _tmp22_;
#line 2615 "/home/jens/Source/shotwell/src/Photo.vala"
					while (TRUE) {
#line 19981 "Photo.c"
						GeeIterator* _tmp23_ = NULL;
						gboolean _tmp24_ = FALSE;
						PixelTransformation* transformation = NULL;
						GeeIterator* _tmp25_ = NULL;
						gpointer _tmp26_ = NULL;
						PixelTransformer* _tmp27_ = NULL;
						PixelTransformationBundle* _tmp28_ = NULL;
						PixelTransformation* _tmp29_ = NULL;
						PixelTransformationType _tmp30_ = 0;
						PixelTransformation* _tmp31_ = NULL;
						PixelTransformation* _tmp32_ = NULL;
						PixelTransformation* _tmp33_ = NULL;
#line 2615 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp23_ = _transformation_it;
#line 2615 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp24_ = gee_iterator_next (_tmp23_);
#line 2615 "/home/jens/Source/shotwell/src/Photo.vala"
						if (!_tmp24_) {
#line 2615 "/home/jens/Source/shotwell/src/Photo.vala"
							break;
#line 20002 "Photo.c"
						}
#line 2615 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp25_ = _transformation_it;
#line 2615 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp26_ = gee_iterator_get (_tmp25_);
#line 2615 "/home/jens/Source/shotwell/src/Photo.vala"
						transformation = (PixelTransformation*) _tmp26_;
#line 2616 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp27_ = self->priv->transformer;
#line 2616 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp28_ = self->priv->adjustments;
#line 2616 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp29_ = transformation;
#line 2616 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp30_ = pixel_transformation_get_transformation_type (_tmp29_);
#line 2616 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp31_ = pixel_transformation_bundle_get_transformation (_tmp28_, _tmp30_);
#line 2616 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp32_ = _tmp31_;
#line 2616 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp33_ = transformation;
#line 2616 "/home/jens/Source/shotwell/src/Photo.vala"
						pixel_transformer_replace_transformation (_tmp27_, _tmp32_, _tmp33_);
#line 2616 "/home/jens/Source/shotwell/src/Photo.vala"
						_pixel_transformation_unref0 (_tmp32_);
#line 2615 "/home/jens/Source/shotwell/src/Photo.vala"
						_pixel_transformation_unref0 (transformation);
#line 20030 "Photo.c"
					}
#line 2615 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (_transformation_it);
#line 20034 "Photo.c"
				}
#line 2621 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp34_ = new_adjustments;
#line 2621 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp35_ = pixel_transformation_bundle_copy (_tmp34_);
#line 2621 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformation_bundle_unref0 (self->priv->adjustments);
#line 2621 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->adjustments = _tmp35_;
#line 20044 "Photo.c"
			}
#line 2624 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp36_ = map;
#line 2624 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp37_ = photo_set_transformation (self, _tmp36_);
#line 2624 "/home/jens/Source/shotwell/src/Photo.vala"
			committed = _tmp37_;
#line 20052 "Photo.c"
		}
		__finally361:
		{
			PhotoRow* _tmp38_ = NULL;
#line 2608 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp38_ = self->row;
#line 2608 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 20061 "Photo.c"
		}
#line 2608 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2608 "/home/jens/Source/shotwell/src/Photo.vala"
			_key_value_map_unref0 (map);
#line 2608 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2608 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2608 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 20073 "Photo.c"
		}
	}
#line 2627 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp39_ = committed;
#line 2627 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp39_) {
#line 20080 "Photo.c"
		Alteration* _tmp40_ = NULL;
		Alteration* _tmp41_ = NULL;
#line 2628 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp40_ = alteration_new ("image", "color-adjustments");
#line 2628 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp41_ = _tmp40_;
#line 2628 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp41_);
#line 2628 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp41_);
#line 20091 "Photo.c"
	}
#line 2587 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 20095 "Photo.c"
}


static PhotoMetadata* photo_real_get_metadata (PhotoSource* base) {
	Photo * self;
	PhotoMetadata* result = NULL;
	GError * _inner_error_ = NULL;
#line 2632 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 20105 "Photo.c"
	{
		PhotoMetadata* _tmp0_ = NULL;
		PhotoFileReader* _tmp1_ = NULL;
		PhotoFileReader* _tmp2_ = NULL;
		PhotoMetadata* _tmp3_ = NULL;
		PhotoMetadata* _tmp4_ = NULL;
		PhotoMetadata* _tmp5_ = NULL;
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = photo_get_source_reader (self);
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = _tmp1_;
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = photo_file_reader_read_metadata (_tmp2_, &_inner_error_);
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = _tmp3_;
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp2_);
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = _tmp4_;
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 20127 "Photo.c"
			goto __catch362_g_error;
		}
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = _tmp0_;
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = NULL;
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
		result = _tmp5_;
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (_tmp0_);
#line 2634 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 20140 "Photo.c"
	}
	goto __finally362;
	__catch362_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 2633 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 2633 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 2636 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = err;
#line 2636 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = _tmp6_->message;
#line 2636 "/home/jens/Source/shotwell/src/Photo.vala"
		g_warning ("Photo.vala:2636: Unable to load metadata: %s", _tmp7_);
#line 2638 "/home/jens/Source/shotwell/src/Photo.vala"
		result = NULL;
#line 2638 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 2638 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 20164 "Photo.c"
	}
	__finally362:
#line 2633 "/home/jens/Source/shotwell/src/Photo.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2633 "/home/jens/Source/shotwell/src/Photo.vala"
	g_clear_error (&_inner_error_);
#line 2633 "/home/jens/Source/shotwell/src/Photo.vala"
	return NULL;
#line 20173 "Photo.c"
}


PhotoMetadata* photo_get_master_metadata (Photo* self, GError** error) {
	PhotoMetadata* result = NULL;
	PhotoMetadata* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	PhotoFileReader* _tmp2_ = NULL;
	PhotoMetadata* _tmp3_ = NULL;
	PhotoMetadata* _tmp4_ = NULL;
	PhotoMetadata* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 2642 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 2643 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = photo_get_master_reader (self);
#line 2643 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = _tmp1_;
#line 2643 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_file_reader_read_metadata (_tmp2_, &_inner_error_);
#line 2643 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp3_;
#line 2643 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp2_);
#line 2643 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _tmp4_;
#line 2643 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2643 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2643 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 20206 "Photo.c"
	}
#line 2643 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = _tmp0_;
#line 2643 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = NULL;
#line 2643 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp5_;
#line 2643 "/home/jens/Source/shotwell/src/Photo.vala"
	_media_metadata_unref0 (_tmp0_);
#line 2643 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 20218 "Photo.c"
}


PhotoMetadata* photo_get_editable_metadata (Photo* self, GError** error) {
	PhotoMetadata* result = NULL;
	PhotoFileReader* reader = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoMetadata* _tmp1_ = NULL;
	PhotoFileReader* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 2646 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 2647 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_editable_reader (self);
#line 2647 "/home/jens/Source/shotwell/src/Photo.vala"
	reader = _tmp0_;
#line 2649 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = reader;
#line 2649 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_ != NULL) {
#line 20239 "Photo.c"
		PhotoFileReader* _tmp3_ = NULL;
		PhotoMetadata* _tmp4_ = NULL;
#line 2649 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = reader;
#line 2649 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = photo_file_reader_read_metadata (_tmp3_, &_inner_error_);
#line 2649 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (_tmp1_);
#line 2649 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp4_;
#line 2649 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2649 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 2649 "/home/jens/Source/shotwell/src/Photo.vala"
			_media_metadata_unref0 (_tmp1_);
#line 2649 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_adapter_unref0 (reader);
#line 2649 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 20260 "Photo.c"
		}
	} else {
#line 2649 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (_tmp1_);
#line 2649 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = NULL;
#line 20267 "Photo.c"
	}
#line 2649 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp1_;
#line 2649 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (reader);
#line 2649 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 20275 "Photo.c"
}


gboolean photo_persist_master_metadata (Photo* self, PhotoMetadata* metadata, PhotoReimportMasterState** state, GError** error) {
	PhotoReimportMasterState* _vala_state = NULL;
	gboolean result = FALSE;
	PhotoFileReader* master_reader = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	PhotoFileFormat _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	PhotoFileMetadataWriter* _tmp4_ = NULL;
	PhotoFileReader* _tmp5_ = NULL;
	PhotoFileMetadataWriter* _tmp6_ = NULL;
	PhotoFileMetadataWriter* _tmp8_ = NULL;
	PhotoFileMetadataWriter* _tmp9_ = NULL;
	PhotoMetadata* _tmp10_ = NULL;
	gboolean _tmp12_ = FALSE;
	PhotoReimportMasterState* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	PhotoReimportMasterState* _tmp16_ = NULL;
	GError * _inner_error_ = NULL;
#line 2655 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2655 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (metadata), FALSE);
#line 2657 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_master_state_unref0 (_vala_state);
#line 2657 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = NULL;
#line 2659 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_master_reader (self);
#line 2659 "/home/jens/Source/shotwell/src/Photo.vala"
	master_reader = _tmp0_;
#line 2661 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = master_reader;
#line 2661 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2661 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_file_format_can_write_metadata (_tmp2_);
#line 2661 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp3_) {
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (master_reader);
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 20326 "Photo.c"
		} else {
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_master_state_unref0 (_vala_state);
#line 20330 "Photo.c"
		}
#line 2662 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 20334 "Photo.c"
	}
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = master_reader;
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = photo_file_reader_create_metadata_writer (_tmp5_, &_inner_error_);
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp6_;
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 20344 "Photo.c"
		gboolean _tmp7_ = FALSE;
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (master_reader);
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp7_;
#line 20352 "Photo.c"
	}
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = _tmp4_;
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = NULL;
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = _tmp8_;
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = metadata;
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_file_metadata_writer_write_metadata (_tmp9_, _tmp10_, &_inner_error_);
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp9_);
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 20368 "Photo.c"
		gboolean _tmp11_ = FALSE;
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp4_);
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (master_reader);
#line 2664 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp11_;
#line 20378 "Photo.c"
	}
#line 2666 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = photo_prepare_for_reimport_master (self, &_tmp13_, &_inner_error_);
#line 2666 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_master_state_unref0 (_vala_state);
#line 2666 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = _tmp13_;
#line 2666 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = _tmp14_;
#line 2666 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 20390 "Photo.c"
		gboolean _tmp15_ = FALSE;
#line 2666 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2666 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp4_);
#line 2666 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (master_reader);
#line 2666 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp15_;
#line 20400 "Photo.c"
	}
#line 2666 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp12_) {
#line 2667 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2667 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp4_);
#line 2667 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (master_reader);
#line 2667 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 2667 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 20414 "Photo.c"
		} else {
#line 2667 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_master_state_unref0 (_vala_state);
#line 20418 "Photo.c"
		}
#line 2667 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 20422 "Photo.c"
	}
#line 2669 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = _vala_state;
#line 2669 "/home/jens/Source/shotwell/src/Photo.vala"
	G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImpl)->metadata_only = TRUE;
#line 2671 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 2671 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp4_);
#line 2671 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (master_reader);
#line 2671 "/home/jens/Source/shotwell/src/Photo.vala"
	if (state) {
#line 2671 "/home/jens/Source/shotwell/src/Photo.vala"
		*state = _vala_state;
#line 20438 "Photo.c"
	} else {
#line 2671 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_reimport_master_state_unref0 (_vala_state);
#line 20442 "Photo.c"
	}
#line 2671 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 20446 "Photo.c"
}


void photo_finish_update_master_metadata (Photo* self, PhotoReimportMasterState* state, GError** error) {
	PhotoReimportMasterState* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 2674 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2674 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (PHOTO_IS_REIMPORT_MASTER_STATE (state));
#line 2675 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = state;
#line 2675 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_finish_reimport_master (self, _tmp0_, &_inner_error_);
#line 2675 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2675 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 2675 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 2675 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 20469 "Photo.c"
		} else {
#line 2675 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2675 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2675 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 20477 "Photo.c"
		}
	}
}


gboolean photo_persist_editable_metadata (Photo* self, PhotoMetadata* metadata, PhotoReimportEditableState** state, GError** error) {
	PhotoReimportEditableState* _vala_state = NULL;
	gboolean result = FALSE;
	PhotoFileReader* editable_reader = NULL;
	PhotoFileReader* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_ = NULL;
	PhotoFileReader* _tmp2_ = NULL;
	PhotoFileFormat _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	PhotoFileMetadataWriter* _tmp5_ = NULL;
	PhotoFileReader* _tmp6_ = NULL;
	PhotoFileMetadataWriter* _tmp7_ = NULL;
	PhotoFileMetadataWriter* _tmp9_ = NULL;
	PhotoFileMetadataWriter* _tmp10_ = NULL;
	PhotoMetadata* _tmp11_ = NULL;
	gboolean _tmp13_ = FALSE;
	PhotoReimportEditableState* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	PhotoReimportEditableState* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
#line 2678 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2678 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (metadata), FALSE);
#line 2680 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_editable_state_unref0 (_vala_state);
#line 2680 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = NULL;
#line 2682 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_editable_reader (self);
#line 2682 "/home/jens/Source/shotwell/src/Photo.vala"
	editable_reader = _tmp0_;
#line 2683 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = editable_reader;
#line 2683 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 2684 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2684 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (editable_reader);
#line 2684 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 2684 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 20527 "Photo.c"
		} else {
#line 2684 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_editable_state_unref0 (_vala_state);
#line 20531 "Photo.c"
		}
#line 2684 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 20535 "Photo.c"
	}
#line 2686 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = editable_reader;
#line 2686 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 2686 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = photo_file_format_can_write_metadata (_tmp3_);
#line 2686 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp4_) {
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (editable_reader);
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 20553 "Photo.c"
		} else {
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_editable_state_unref0 (_vala_state);
#line 20557 "Photo.c"
		}
#line 2687 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 20561 "Photo.c"
	}
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = editable_reader;
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = photo_file_reader_create_metadata_writer (_tmp6_, &_inner_error_);
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = _tmp7_;
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 20571 "Photo.c"
		gboolean _tmp8_ = FALSE;
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (editable_reader);
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp8_;
#line 20579 "Photo.c"
	}
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = _tmp5_;
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = NULL;
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = _tmp9_;
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = metadata;
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_file_metadata_writer_write_metadata (_tmp10_, _tmp11_, &_inner_error_);
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp10_);
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 20595 "Photo.c"
		gboolean _tmp12_ = FALSE;
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp5_);
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (editable_reader);
#line 2689 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp12_;
#line 20605 "Photo.c"
	}
#line 2691 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = photo_prepare_for_reimport_editable (self, &_tmp14_, &_inner_error_);
#line 2691 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_reimport_editable_state_unref0 (_vala_state);
#line 2691 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_state = _tmp14_;
#line 2691 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = _tmp15_;
#line 2691 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 20617 "Photo.c"
		gboolean _tmp16_ = FALSE;
#line 2691 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 2691 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp5_);
#line 2691 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (editable_reader);
#line 2691 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp16_;
#line 20627 "Photo.c"
	}
#line 2691 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp13_) {
#line 2692 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2692 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (_tmp5_);
#line 2692 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (editable_reader);
#line 2692 "/home/jens/Source/shotwell/src/Photo.vala"
		if (state) {
#line 2692 "/home/jens/Source/shotwell/src/Photo.vala"
			*state = _vala_state;
#line 20641 "Photo.c"
		} else {
#line 2692 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_reimport_editable_state_unref0 (_vala_state);
#line 20645 "Photo.c"
		}
#line 2692 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 20649 "Photo.c"
	}
#line 2694 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = _vala_state;
#line 2694 "/home/jens/Source/shotwell/src/Photo.vala"
	G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImpl)->metadata_only = TRUE;
#line 2696 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 2696 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (_tmp5_);
#line 2696 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (editable_reader);
#line 2696 "/home/jens/Source/shotwell/src/Photo.vala"
	if (state) {
#line 2696 "/home/jens/Source/shotwell/src/Photo.vala"
		*state = _vala_state;
#line 20665 "Photo.c"
	} else {
#line 2696 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_reimport_editable_state_unref0 (_vala_state);
#line 20669 "Photo.c"
	}
#line 2696 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 20673 "Photo.c"
}


void photo_finish_update_editable_metadata (Photo* self, PhotoReimportEditableState* state, GError** error) {
	PhotoReimportEditableState* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 2699 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2699 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (PHOTO_IS_REIMPORT_EDITABLE_STATE (state));
#line 2700 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = state;
#line 2700 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_finish_reimport_editable (self, _tmp0_, &_inner_error_);
#line 2700 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2700 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 2700 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 2700 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 20696 "Photo.c"
		} else {
#line 2700 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2700 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2700 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 20704 "Photo.c"
		}
	}
}


void photo_get_raw_dimensions (Photo* self, Dimensions* result) {
	GError * _inner_error_ = NULL;
#line 2705 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 20714 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2706 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2706 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 20721 "Photo.c"
		{
			BackingPhotoRow* _tmp1_ = NULL;
			Dimensions _tmp2_ = {0};
#line 2707 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->backing_photo_row;
#line 2707 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->dim;
#line 2707 "/home/jens/Source/shotwell/src/Photo.vala"
			*result = _tmp2_;
#line 20731 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 2706 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2706 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 20738 "Photo.c"
			}
#line 2707 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 20742 "Photo.c"
		}
		__finally363:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2706 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2706 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 20751 "Photo.c"
		}
#line 2706 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2706 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2706 "/home/jens/Source/shotwell/src/Photo.vala"
		return;
#line 20759 "Photo.c"
	}
}


gboolean photo_has_transformations (Photo* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 2711 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 20769 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
		gboolean _tmp10_ = FALSE;
#line 2712 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2712 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 20777 "Photo.c"
		{
			gboolean _tmp1_ = FALSE;
			PhotoRow* _tmp2_ = NULL;
			Orientation _tmp3_ = 0;
			BackingPhotoRow* _tmp4_ = NULL;
			Orientation _tmp5_ = 0;
#line 2713 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->row;
#line 2713 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _tmp2_->orientation;
#line 2713 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->backing_photo_row;
#line 2713 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = _tmp4_->original_orientation;
#line 2713 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp3_ != _tmp5_) {
#line 2714 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = TRUE;
#line 20796 "Photo.c"
			} else {
				PhotoRow* _tmp6_ = NULL;
				GeeHashMap* _tmp7_ = NULL;
#line 2715 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = self->row;
#line 2715 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = _tmp6_->transformations;
#line 2715 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = _tmp7_ != NULL;
#line 20806 "Photo.c"
			}
#line 2713 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp1_;
#line 20810 "Photo.c"
			{
				PhotoRow* _tmp8_ = NULL;
#line 2712 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = self->row;
#line 2712 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 20817 "Photo.c"
			}
#line 2713 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 20821 "Photo.c"
		}
		__finally364:
		{
			PhotoRow* _tmp9_ = NULL;
#line 2712 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = self->row;
#line 2712 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 20830 "Photo.c"
		}
#line 2712 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2712 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2712 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp10_;
#line 20838 "Photo.c"
	}
}


gboolean photo_only_metadata_changed (Photo* self) {
	gboolean result = FALSE;
	MetadataDateTime* date_time = NULL;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp0_ = NULL;
	PhotoMetadata* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 2719 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2720 "/home/jens/Source/shotwell/src/Photo.vala"
	date_time = NULL;
#line 2722 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource));
#line 2722 "/home/jens/Source/shotwell/src/Photo.vala"
	metadata = _tmp0_;
#line 2723 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = metadata;
#line 2723 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ != NULL) {
#line 20862 "Photo.c"
		PhotoMetadata* _tmp2_ = NULL;
		MetadataDateTime* _tmp3_ = NULL;
#line 2724 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = metadata;
#line 2724 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = photo_metadata_get_exposure_date_time (_tmp2_);
#line 2724 "/home/jens/Source/shotwell/src/Photo.vala"
		_metadata_date_time_unref0 (date_time);
#line 2724 "/home/jens/Source/shotwell/src/Photo.vala"
		date_time = _tmp3_;
#line 20873 "Photo.c"
	}
	{
		PhotoRow* _tmp4_ = NULL;
		gboolean _tmp21_ = FALSE;
#line 2726 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = self->row;
#line 2726 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 20882 "Photo.c"
		{
			gboolean _tmp5_ = FALSE;
			PhotoRow* _tmp6_ = NULL;
			GeeHashMap* _tmp7_ = NULL;
#line 2727 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = self->row;
#line 2727 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = _tmp6_->transformations;
#line 2727 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp7_ == NULL) {
#line 20893 "Photo.c"
				gboolean _tmp8_ = FALSE;
				PhotoRow* _tmp9_ = NULL;
				Orientation _tmp10_ = 0;
				BackingPhotoRow* _tmp11_ = NULL;
				Orientation _tmp12_ = 0;
#line 2728 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = self->row;
#line 2728 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = _tmp9_->orientation;
#line 2728 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = self->backing_photo_row;
#line 2728 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = _tmp11_->original_orientation;
#line 2728 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp10_ != _tmp12_) {
#line 2728 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp8_ = TRUE;
#line 20911 "Photo.c"
				} else {
					gboolean _tmp13_ = FALSE;
					MetadataDateTime* _tmp14_ = NULL;
#line 2729 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_ = date_time;
#line 2729 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp14_ != NULL) {
#line 20919 "Photo.c"
						PhotoRow* _tmp15_ = NULL;
						time_t _tmp16_ = 0;
						MetadataDateTime* _tmp17_ = NULL;
						time_t _tmp18_ = 0;
#line 2729 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp15_ = self->row;
#line 2729 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp16_ = _tmp15_->exposure_time;
#line 2729 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp17_ = date_time;
#line 2729 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp18_ = metadata_date_time_get_timestamp (_tmp17_);
#line 2729 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp13_ = _tmp16_ != _tmp18_;
#line 20934 "Photo.c"
					} else {
#line 2729 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp13_ = FALSE;
#line 20938 "Photo.c"
					}
#line 2729 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp8_ = _tmp13_;
#line 20942 "Photo.c"
				}
#line 2728 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp8_;
#line 20946 "Photo.c"
			} else {
#line 2727 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = FALSE;
#line 20950 "Photo.c"
			}
#line 2727 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp5_;
#line 20954 "Photo.c"
			{
				PhotoRow* _tmp19_ = NULL;
#line 2726 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp19_ = self->row;
#line 2726 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 20961 "Photo.c"
			}
#line 2727 "/home/jens/Source/shotwell/src/Photo.vala"
			_media_metadata_unref0 (metadata);
#line 2727 "/home/jens/Source/shotwell/src/Photo.vala"
			_metadata_date_time_unref0 (date_time);
#line 2727 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 20969 "Photo.c"
		}
		__finally365:
		{
			PhotoRow* _tmp20_ = NULL;
#line 2726 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp20_ = self->row;
#line 2726 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 20978 "Photo.c"
		}
#line 2726 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2726 "/home/jens/Source/shotwell/src/Photo.vala"
		_metadata_date_time_unref0 (date_time);
#line 2726 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2726 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2726 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp21_;
#line 20990 "Photo.c"
	}
#line 2719 "/home/jens/Source/shotwell/src/Photo.vala"
	_media_metadata_unref0 (metadata);
#line 2719 "/home/jens/Source/shotwell/src/Photo.vala"
	_metadata_date_time_unref0 (date_time);
#line 20996 "Photo.c"
}


gboolean photo_has_alterations (Photo* self) {
	gboolean result = FALSE;
	MetadataDateTime* date_time = NULL;
	gchar* title = NULL;
	gchar* comment = NULL;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp0_ = NULL;
	PhotoMetadata* _tmp1_ = NULL;
	MetadataDateTime* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
#line 2733 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2734 "/home/jens/Source/shotwell/src/Photo.vala"
	date_time = NULL;
#line 2735 "/home/jens/Source/shotwell/src/Photo.vala"
	title = NULL;
#line 2736 "/home/jens/Source/shotwell/src/Photo.vala"
	comment = NULL;
#line 2738 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource));
#line 2738 "/home/jens/Source/shotwell/src/Photo.vala"
	metadata = _tmp0_;
#line 2739 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = metadata;
#line 2739 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ != NULL) {
#line 21026 "Photo.c"
		PhotoMetadata* _tmp2_ = NULL;
		MetadataDateTime* _tmp3_ = NULL;
		PhotoMetadata* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		PhotoMetadata* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 2740 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = metadata;
#line 2740 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = photo_metadata_get_exposure_date_time (_tmp2_);
#line 2740 "/home/jens/Source/shotwell/src/Photo.vala"
		_metadata_date_time_unref0 (date_time);
#line 2740 "/home/jens/Source/shotwell/src/Photo.vala"
		date_time = _tmp3_;
#line 2741 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = metadata;
#line 2741 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 2741 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (title);
#line 2741 "/home/jens/Source/shotwell/src/Photo.vala"
		title = _tmp5_;
#line 2742 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = metadata;
#line 2742 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp7_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 2742 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (comment);
#line 2742 "/home/jens/Source/shotwell/src/Photo.vala"
		comment = _tmp7_;
#line 21057 "Photo.c"
	}
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = date_time;
#line 2746 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp8_ == NULL) {
#line 21063 "Photo.c"
		{
			PhotoRow* _tmp9_ = NULL;
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = self->row;
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_lock (&self->priv->__lock_row);
#line 21070 "Photo.c"
			{
				BackingPhotoRow* _tmp10_ = NULL;
				time_t _tmp11_ = 0;
				PhotoRow* _tmp12_ = NULL;
				time_t _tmp13_ = 0;
#line 2750 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = self->backing_photo_row;
#line 2750 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = _tmp10_->timestamp;
#line 2750 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = self->row;
#line 2750 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = _tmp12_->exposure_time;
#line 2750 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp11_ != _tmp13_) {
#line 2752 "/home/jens/Source/shotwell/src/Photo.vala"
					result = TRUE;
#line 21088 "Photo.c"
					{
						PhotoRow* _tmp14_ = NULL;
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp14_ = self->row;
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
						g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21095 "Photo.c"
					}
#line 2752 "/home/jens/Source/shotwell/src/Photo.vala"
					_media_metadata_unref0 (metadata);
#line 2752 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_free0 (comment);
#line 2752 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_free0 (title);
#line 2752 "/home/jens/Source/shotwell/src/Photo.vala"
					_metadata_date_time_unref0 (date_time);
#line 2752 "/home/jens/Source/shotwell/src/Photo.vala"
					return result;
#line 21107 "Photo.c"
				}
			}
			__finally366:
			{
				PhotoRow* _tmp15_ = NULL;
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = self->row;
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21117 "Photo.c"
			}
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 21121 "Photo.c"
				gboolean _tmp16_ = FALSE;
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
				_media_metadata_unref0 (metadata);
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (comment);
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (title);
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
				_metadata_date_time_unref0 (date_time);
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
				g_clear_error (&_inner_error_);
#line 2748 "/home/jens/Source/shotwell/src/Photo.vala"
				return _tmp16_;
#line 21137 "Photo.c"
			}
		}
	}
	{
		PhotoRow* _tmp17_ = NULL;
		gboolean _tmp42_ = FALSE;
#line 2757 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = self->row;
#line 2757 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 21148 "Photo.c"
		{
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_ = FALSE;
			PhotoRow* _tmp22_ = NULL;
			GeeHashMap* _tmp23_ = NULL;
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp22_ = self->row;
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp23_ = _tmp22_->transformations;
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp23_ != NULL) {
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp21_ = TRUE;
#line 21164 "Photo.c"
			} else {
				PhotoRow* _tmp24_ = NULL;
				Orientation _tmp25_ = 0;
				BackingPhotoRow* _tmp26_ = NULL;
				Orientation _tmp27_ = 0;
#line 2759 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp24_ = self->row;
#line 2759 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp25_ = _tmp24_->orientation;
#line 2759 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp26_ = self->backing_photo_row;
#line 2759 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp27_ = _tmp26_->original_orientation;
#line 2759 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp21_ = _tmp25_ != _tmp27_;
#line 21180 "Photo.c"
			}
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp21_) {
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp20_ = TRUE;
#line 21186 "Photo.c"
			} else {
				gboolean _tmp28_ = FALSE;
				MetadataDateTime* _tmp29_ = NULL;
#line 2760 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp29_ = date_time;
#line 2760 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp29_ != NULL) {
#line 21194 "Photo.c"
					PhotoRow* _tmp30_ = NULL;
					time_t _tmp31_ = 0;
					MetadataDateTime* _tmp32_ = NULL;
					time_t _tmp33_ = 0;
#line 2760 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp30_ = self->row;
#line 2760 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp31_ = _tmp30_->exposure_time;
#line 2760 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp32_ = date_time;
#line 2760 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp33_ = metadata_date_time_get_timestamp (_tmp32_);
#line 2760 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp28_ = _tmp31_ != _tmp33_;
#line 21209 "Photo.c"
				} else {
#line 2760 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp28_ = FALSE;
#line 21213 "Photo.c"
				}
#line 2760 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp20_ = _tmp28_;
#line 21217 "Photo.c"
			}
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp20_) {
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp19_ = TRUE;
#line 21223 "Photo.c"
			} else {
				gchar* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
#line 2761 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp34_ = media_source_get_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 2761 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp35_ = _tmp34_;
#line 2761 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp36_ = comment;
#line 2761 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp19_ = g_strcmp0 (_tmp35_, _tmp36_) != 0;
#line 2761 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (_tmp35_);
#line 21238 "Photo.c"
			}
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp19_) {
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = TRUE;
#line 21244 "Photo.c"
			} else {
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
#line 2762 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp37_ = media_source_get_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 2762 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp38_ = _tmp37_;
#line 2762 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp39_ = title;
#line 2762 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = g_strcmp0 (_tmp38_, _tmp39_) != 0;
#line 2762 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (_tmp38_);
#line 21259 "Photo.c"
			}
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp18_;
#line 21263 "Photo.c"
			{
				PhotoRow* _tmp40_ = NULL;
#line 2757 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp40_ = self->row;
#line 2757 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21270 "Photo.c"
			}
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
			_media_metadata_unref0 (metadata);
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (comment);
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (title);
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
			_metadata_date_time_unref0 (date_time);
#line 2758 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 21282 "Photo.c"
		}
		__finally367:
		{
			PhotoRow* _tmp41_ = NULL;
#line 2757 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp41_ = self->row;
#line 2757 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21291 "Photo.c"
		}
#line 2757 "/home/jens/Source/shotwell/src/Photo.vala"
		_media_metadata_unref0 (metadata);
#line 2757 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (comment);
#line 2757 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_free0 (title);
#line 2757 "/home/jens/Source/shotwell/src/Photo.vala"
		_metadata_date_time_unref0 (date_time);
#line 2757 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2757 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2757 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp42_;
#line 21307 "Photo.c"
	}
#line 2733 "/home/jens/Source/shotwell/src/Photo.vala"
	_media_metadata_unref0 (metadata);
#line 2733 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (comment);
#line 2733 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (title);
#line 2733 "/home/jens/Source/shotwell/src/Photo.vala"
	_metadata_date_time_unref0 (date_time);
#line 21317 "Photo.c"
}


PhotoTransformationState* photo_save_transformation_state (Photo* self) {
	PhotoTransformationState* result = NULL;
	GError * _inner_error_ = NULL;
#line 2767 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 21326 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2768 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2768 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 21333 "Photo.c"
		{
			PixelTransformer* _tmp1_ = NULL;
			PixelTransformer* _tmp2_ = NULL;
			PixelTransformationBundle* _tmp5_ = NULL;
			PixelTransformationBundle* _tmp6_ = NULL;
			PhotoRow* _tmp9_ = NULL;
			Orientation _tmp10_ = 0;
			PhotoRow* _tmp11_ = NULL;
			GeeHashMap* _tmp12_ = NULL;
			PhotoPhotoTransformationStateImpl* _tmp13_ = NULL;
#line 2771 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->priv->transformer;
#line 2771 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 21348 "Photo.c"
				PixelTransformer* _tmp3_ = NULL;
				PixelTransformer* _tmp4_ = NULL;
#line 2771 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->priv->transformer;
#line 2771 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = pixel_transformer_copy (_tmp3_);
#line 2771 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformer_unref0 (_tmp1_);
#line 2771 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = _tmp4_;
#line 21359 "Photo.c"
			} else {
#line 2771 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformer_unref0 (_tmp1_);
#line 2771 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = NULL;
#line 21365 "Photo.c"
			}
#line 2772 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = self->priv->adjustments;
#line 2772 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp6_ != NULL) {
#line 21371 "Photo.c"
				PixelTransformationBundle* _tmp7_ = NULL;
				PixelTransformationBundle* _tmp8_ = NULL;
#line 2772 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = self->priv->adjustments;
#line 2772 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = pixel_transformation_bundle_copy (_tmp7_);
#line 2772 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformation_bundle_unref0 (_tmp5_);
#line 2772 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp8_;
#line 21382 "Photo.c"
			} else {
#line 2772 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformation_bundle_unref0 (_tmp5_);
#line 2772 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = NULL;
#line 21388 "Photo.c"
			}
#line 2769 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = self->row;
#line 2769 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = _tmp9_->orientation;
#line 2769 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = self->row;
#line 2769 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = _tmp11_->transformations;
#line 2769 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = photo_photo_transformation_state_impl_new (self, _tmp10_, _tmp12_, _tmp1_, _tmp5_);
#line 2769 "/home/jens/Source/shotwell/src/Photo.vala"
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationState);
#line 2769 "/home/jens/Source/shotwell/src/Photo.vala"
			_pixel_transformation_bundle_unref0 (_tmp5_);
#line 2769 "/home/jens/Source/shotwell/src/Photo.vala"
			_pixel_transformer_unref0 (_tmp1_);
#line 21406 "Photo.c"
			{
				PhotoRow* _tmp14_ = NULL;
#line 2768 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = self->row;
#line 2768 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21413 "Photo.c"
			}
#line 2769 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 21417 "Photo.c"
		}
		__finally368:
		{
			PhotoRow* _tmp15_ = NULL;
#line 2768 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = self->row;
#line 2768 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21426 "Photo.c"
		}
#line 2768 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2768 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2768 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 21434 "Photo.c"
	}
}


static gpointer _pixel_transformer_ref0 (gpointer self) {
#line 2793 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? pixel_transformer_ref (self) : NULL;
#line 21442 "Photo.c"
}


static gpointer _pixel_transformation_bundle_ref0 (gpointer self) {
#line 2794 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? pixel_transformation_bundle_ref (self) : NULL;
#line 21449 "Photo.c"
}


gboolean photo_load_transformation_state (Photo* self, PhotoTransformationState* state) {
	gboolean result = FALSE;
	PhotoPhotoTransformationStateImpl* state_impl = NULL;
	PhotoTransformationState* _tmp0_ = NULL;
	PhotoPhotoTransformationStateImpl* _tmp1_ = NULL;
	PhotoPhotoTransformationStateImpl* _tmp2_ = NULL;
	Orientation saved_orientation = 0;
	PhotoPhotoTransformationStateImpl* _tmp3_ = NULL;
	Orientation _tmp4_ = 0;
	GeeHashMap* saved_transformations = NULL;
	PhotoPhotoTransformationStateImpl* _tmp5_ = NULL;
	GeeHashMap* _tmp6_ = NULL;
	PixelTransformer* saved_transformer = NULL;
	PhotoPhotoTransformationStateImpl* _tmp7_ = NULL;
	PixelTransformer* _tmp8_ = NULL;
	PixelTransformationBundle* saved_adjustments = NULL;
	PhotoPhotoTransformationStateImpl* _tmp9_ = NULL;
	PixelTransformationBundle* _tmp10_ = NULL;
	gboolean committed = FALSE;
	gboolean _tmp31_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2776 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2776 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO_TRANSFORMATION_STATE (state), FALSE);
#line 2777 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = state;
#line 2777 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL) ? ((PhotoPhotoTransformationStateImpl*) _tmp0_) : NULL);
#line 2777 "/home/jens/Source/shotwell/src/Photo.vala"
	state_impl = _tmp1_;
#line 2778 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = state_impl;
#line 2778 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_ == NULL) {
#line 2779 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2779 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (state_impl);
#line 2779 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 21494 "Photo.c"
	}
#line 2781 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = state_impl;
#line 2781 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = photo_photo_transformation_state_impl_get_orientation (_tmp3_);
#line 2781 "/home/jens/Source/shotwell/src/Photo.vala"
	saved_orientation = _tmp4_;
#line 2782 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = state_impl;
#line 2782 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = photo_photo_transformation_state_impl_get_transformations (_tmp5_);
#line 2782 "/home/jens/Source/shotwell/src/Photo.vala"
	saved_transformations = _tmp6_;
#line 2783 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = state_impl;
#line 2783 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = photo_photo_transformation_state_impl_get_transformer (_tmp7_);
#line 2783 "/home/jens/Source/shotwell/src/Photo.vala"
	saved_transformer = _tmp8_;
#line 2784 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = state_impl;
#line 2784 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = photo_photo_transformation_state_impl_get_color_adjustments (_tmp9_);
#line 2784 "/home/jens/Source/shotwell/src/Photo.vala"
	saved_adjustments = _tmp10_;
#line 21520 "Photo.c"
	{
		PhotoRow* _tmp11_ = NULL;
#line 2787 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = self->row;
#line 2787 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 21527 "Photo.c"
		{
			PhotoTable* _tmp12_ = NULL;
			PhotoTable* _tmp13_ = NULL;
			PhotoRow* _tmp14_ = NULL;
			PhotoID _tmp15_ = {0};
			Orientation _tmp16_ = 0;
			GeeHashMap* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_ = FALSE;
#line 2788 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = photo_table_get_instance ();
#line 2788 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = _tmp12_;
#line 2788 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = self->row;
#line 2788 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = _tmp14_->photo_id;
#line 2788 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = saved_orientation;
#line 2788 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = saved_transformations;
#line 2788 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp18_ = photo_table_set_transformation_state (_tmp13_, &_tmp15_, _tmp16_, _tmp17_);
#line 2788 "/home/jens/Source/shotwell/src/Photo.vala"
			committed = _tmp18_;
#line 2788 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp13_);
#line 2790 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp19_ = committed;
#line 2790 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp19_) {
#line 21559 "Photo.c"
				PhotoRow* _tmp20_ = NULL;
				Orientation _tmp21_ = 0;
				PhotoRow* _tmp22_ = NULL;
				GeeHashMap* _tmp23_ = NULL;
				GeeHashMap* _tmp24_ = NULL;
				PixelTransformer* _tmp25_ = NULL;
				PixelTransformer* _tmp26_ = NULL;
				PixelTransformationBundle* _tmp27_ = NULL;
				PixelTransformationBundle* _tmp28_ = NULL;
#line 2791 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp20_ = self->row;
#line 2791 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp21_ = saved_orientation;
#line 2791 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp20_->orientation = _tmp21_;
#line 2792 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp22_ = self->row;
#line 2792 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp23_ = saved_transformations;
#line 2792 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp24_ = _g_object_ref0 (_tmp23_);
#line 2792 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_tmp22_->transformations);
#line 2792 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp22_->transformations = _tmp24_;
#line 2793 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp25_ = saved_transformer;
#line 2793 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp26_ = _pixel_transformer_ref0 (_tmp25_);
#line 2793 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformer_unref0 (self->priv->transformer);
#line 2793 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->transformer = _tmp26_;
#line 2794 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp27_ = saved_adjustments;
#line 2794 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp28_ = _pixel_transformation_bundle_ref0 (_tmp27_);
#line 2794 "/home/jens/Source/shotwell/src/Photo.vala"
				_pixel_transformation_bundle_unref0 (self->priv->adjustments);
#line 2794 "/home/jens/Source/shotwell/src/Photo.vala"
				self->priv->adjustments = _tmp28_;
#line 21601 "Photo.c"
			}
		}
		__finally369:
		{
			PhotoRow* _tmp29_ = NULL;
#line 2787 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp29_ = self->row;
#line 2787 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21611 "Photo.c"
		}
#line 2787 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 21615 "Photo.c"
			gboolean _tmp30_ = FALSE;
#line 2787 "/home/jens/Source/shotwell/src/Photo.vala"
			_pixel_transformation_bundle_unref0 (saved_adjustments);
#line 2787 "/home/jens/Source/shotwell/src/Photo.vala"
			_pixel_transformer_unref0 (saved_transformer);
#line 2787 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (saved_transformations);
#line 2787 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (state_impl);
#line 2787 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2787 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2787 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp30_;
#line 21631 "Photo.c"
		}
	}
#line 2798 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp31_ = committed;
#line 2798 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp31_) {
#line 21638 "Photo.c"
		Alteration* _tmp32_ = NULL;
		Alteration* _tmp33_ = NULL;
#line 2799 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp32_ = alteration_new ("image", "transformation-state");
#line 2799 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp33_ = _tmp32_;
#line 2799 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp33_);
#line 2799 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp33_);
#line 21649 "Photo.c"
	}
#line 2801 "/home/jens/Source/shotwell/src/Photo.vala"
	result = committed;
#line 2801 "/home/jens/Source/shotwell/src/Photo.vala"
	_pixel_transformation_bundle_unref0 (saved_adjustments);
#line 2801 "/home/jens/Source/shotwell/src/Photo.vala"
	_pixel_transformer_unref0 (saved_transformer);
#line 2801 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (saved_transformations);
#line 2801 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (state_impl);
#line 2801 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 21663 "Photo.c"
}


void photo_remove_all_transformations (Photo* self) {
#line 2804 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2805 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_internal_remove_all_transformations (self, TRUE);
#line 21672 "Photo.c"
}


static void photo_internal_remove_all_transformations (Photo* self, gboolean notify) {
	gboolean is_altered = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2808 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2809 "/home/jens/Source/shotwell/src/Photo.vala"
	is_altered = FALSE;
#line 21685 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2810 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2810 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 21692 "Photo.c"
		{
			PhotoTable* _tmp1_ = NULL;
			PhotoTable* _tmp2_ = NULL;
			PhotoRow* _tmp3_ = NULL;
			PhotoID _tmp4_ = {0};
			gboolean _tmp5_ = FALSE;
			PhotoRow* _tmp6_ = NULL;
			PhotoRow* _tmp7_ = NULL;
			Orientation _tmp8_ = 0;
			BackingPhotoRow* _tmp9_ = NULL;
			Orientation _tmp10_ = 0;
#line 2811 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = photo_table_get_instance ();
#line 2811 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_;
#line 2811 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = self->row;
#line 2811 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = _tmp3_->photo_id;
#line 2811 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = photo_table_remove_all_transformations (_tmp2_, &_tmp4_);
#line 2811 "/home/jens/Source/shotwell/src/Photo.vala"
			is_altered = _tmp5_;
#line 2811 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp2_);
#line 2812 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = self->row;
#line 2812 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (_tmp6_->transformations);
#line 2812 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_->transformations = NULL;
#line 2814 "/home/jens/Source/shotwell/src/Photo.vala"
			_pixel_transformer_unref0 (self->priv->transformer);
#line 2814 "/home/jens/Source/shotwell/src/Photo.vala"
			self->priv->transformer = NULL;
#line 2815 "/home/jens/Source/shotwell/src/Photo.vala"
			_pixel_transformation_bundle_unref0 (self->priv->adjustments);
#line 2815 "/home/jens/Source/shotwell/src/Photo.vala"
			self->priv->adjustments = NULL;
#line 2817 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->row;
#line 2817 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = _tmp7_->orientation;
#line 2817 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = self->backing_photo_row;
#line 2817 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = _tmp9_->original_orientation;
#line 2817 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp8_ != _tmp10_) {
#line 21742 "Photo.c"
				PhotoTable* _tmp11_ = NULL;
				PhotoTable* _tmp12_ = NULL;
				PhotoRow* _tmp13_ = NULL;
				PhotoID _tmp14_ = {0};
				BackingPhotoRow* _tmp15_ = NULL;
				Orientation _tmp16_ = 0;
				PhotoRow* _tmp17_ = NULL;
				BackingPhotoRow* _tmp18_ = NULL;
				Orientation _tmp19_ = 0;
#line 2818 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp11_ = photo_table_get_instance ();
#line 2818 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = _tmp11_;
#line 2818 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = self->row;
#line 2818 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = _tmp13_->photo_id;
#line 2818 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = self->backing_photo_row;
#line 2818 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = _tmp15_->original_orientation;
#line 2818 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_table_set_orientation (_tmp12_, &_tmp14_, _tmp16_);
#line 2818 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp12_);
#line 2820 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = self->row;
#line 2820 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = self->backing_photo_row;
#line 2820 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp19_ = _tmp18_->original_orientation;
#line 2820 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_->orientation = _tmp19_;
#line 2821 "/home/jens/Source/shotwell/src/Photo.vala"
				is_altered = TRUE;
#line 21778 "Photo.c"
			}
		}
		__finally370:
		{
			PhotoRow* _tmp20_ = NULL;
#line 2810 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp20_ = self->row;
#line 2810 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21788 "Photo.c"
		}
#line 2810 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2810 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2810 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2810 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 21798 "Photo.c"
		}
	}
#line 2825 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = is_altered;
#line 2825 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp22_) {
#line 21805 "Photo.c"
		gboolean _tmp23_ = FALSE;
#line 2825 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp23_ = notify;
#line 2825 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = _tmp23_;
#line 21811 "Photo.c"
	} else {
#line 2825 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp21_ = FALSE;
#line 21815 "Photo.c"
	}
#line 2825 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp21_) {
#line 21819 "Photo.c"
		Alteration* _tmp24_ = NULL;
		Alteration* _tmp25_ = NULL;
#line 2826 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp24_ = alteration_new ("image", "revert");
#line 2826 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp25_ = _tmp24_;
#line 2826 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp25_);
#line 2826 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp25_);
#line 21830 "Photo.c"
	}
}


Orientation photo_get_original_orientation (Photo* self) {
	Orientation result = 0;
	GError * _inner_error_ = NULL;
#line 2829 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0);
#line 21840 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2830 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2830 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 21847 "Photo.c"
		{
			BackingPhotoRow* _tmp1_ = NULL;
			Orientation _tmp2_ = 0;
#line 2831 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->backing_photo_row;
#line 2831 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->original_orientation;
#line 2831 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 21857 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 2830 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2830 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21864 "Photo.c"
			}
#line 2831 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 21868 "Photo.c"
		}
		__finally371:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2830 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2830 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21877 "Photo.c"
		}
#line 2830 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2830 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2830 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0;
#line 21885 "Photo.c"
	}
}


Orientation photo_get_orientation (Photo* self) {
	Orientation result = 0;
	GError * _inner_error_ = NULL;
#line 2835 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), 0);
#line 21895 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2836 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2836 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 21902 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			Orientation _tmp2_ = 0;
#line 2837 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2837 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->orientation;
#line 2837 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp2_;
#line 21912 "Photo.c"
			{
				PhotoRow* _tmp3_ = NULL;
#line 2836 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2836 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21919 "Photo.c"
			}
#line 2837 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 21923 "Photo.c"
		}
		__finally372:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2836 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2836 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 21932 "Photo.c"
		}
#line 2836 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2836 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2836 "/home/jens/Source/shotwell/src/Photo.vala"
		return 0;
#line 21940 "Photo.c"
	}
}


gboolean photo_set_orientation (Photo* self, Orientation orientation) {
	gboolean result = FALSE;
	gboolean committed = FALSE;
	gboolean _tmp15_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2841 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2842 "/home/jens/Source/shotwell/src/Photo.vala"
	committed = FALSE;
#line 21954 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2843 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2843 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 21961 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			Orientation _tmp2_ = 0;
			Orientation _tmp3_ = 0;
#line 2844 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2844 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->orientation;
#line 2844 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = orientation;
#line 2844 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != _tmp3_) {
#line 21974 "Photo.c"
				PhotoTable* _tmp4_ = NULL;
				PhotoTable* _tmp5_ = NULL;
				PhotoRow* _tmp6_ = NULL;
				PhotoID _tmp7_ = {0};
				Orientation _tmp8_ = 0;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_ = FALSE;
#line 2845 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = photo_table_get_instance ();
#line 2845 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp4_;
#line 2845 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = self->row;
#line 2845 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = _tmp6_->photo_id;
#line 2845 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = orientation;
#line 2845 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = photo_table_set_orientation (_tmp5_, &_tmp7_, _tmp8_);
#line 2845 "/home/jens/Source/shotwell/src/Photo.vala"
				committed = _tmp9_;
#line 2845 "/home/jens/Source/shotwell/src/Photo.vala"
				_database_table_unref0 (_tmp5_);
#line 2846 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = committed;
#line 2846 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp10_) {
#line 22002 "Photo.c"
					PhotoRow* _tmp11_ = NULL;
					Orientation _tmp12_ = 0;
#line 2847 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = self->row;
#line 2847 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp12_ = orientation;
#line 2847 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_->orientation = _tmp12_;
#line 22011 "Photo.c"
				}
			}
		}
		__finally373:
		{
			PhotoRow* _tmp13_ = NULL;
#line 2843 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = self->row;
#line 2843 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22022 "Photo.c"
		}
#line 2843 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 22026 "Photo.c"
			gboolean _tmp14_ = FALSE;
#line 2843 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2843 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2843 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp14_;
#line 22034 "Photo.c"
		}
	}
#line 2851 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = committed;
#line 2851 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp15_) {
#line 22041 "Photo.c"
		Alteration* _tmp16_ = NULL;
		Alteration* _tmp17_ = NULL;
#line 2852 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = alteration_new ("image", "orientation");
#line 2852 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp17_ = _tmp16_;
#line 2852 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp17_);
#line 2852 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp17_);
#line 22052 "Photo.c"
	}
#line 2854 "/home/jens/Source/shotwell/src/Photo.vala"
	result = committed;
#line 2854 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 22058 "Photo.c"
}


gboolean photo_check_can_rotate (Photo* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 2857 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2858 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = self->can_rotate_now;
#line 2858 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 2858 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 22073 "Photo.c"
}


static void photo_real_rotate (Photo* self, Rotation rotation) {
	GError * _inner_error_ = NULL;
	{
		PhotoRow* _tmp0_ = NULL;
#line 2862 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2862 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 22085 "Photo.c"
		{
			Orientation _tmp1_ = 0;
			Rotation _tmp2_ = 0;
			Orientation _tmp3_ = 0;
#line 2863 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = photo_get_orientation (self);
#line 2863 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = rotation;
#line 2863 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = orientation_perform (_tmp1_, _tmp2_);
#line 2863 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_set_orientation (self, _tmp3_);
#line 22098 "Photo.c"
		}
		__finally374:
		{
			PhotoRow* _tmp4_ = NULL;
#line 2862 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = self->row;
#line 2862 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22107 "Photo.c"
		}
#line 2862 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2862 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2862 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2862 "/home/jens/Source/shotwell/src/Photo.vala"
			return;
#line 22117 "Photo.c"
		}
	}
}


void photo_rotate (Photo* self, Rotation rotation) {
#line 2861 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2861 "/home/jens/Source/shotwell/src/Photo.vala"
	PHOTO_GET_CLASS (self)->rotate (self, rotation);
#line 22128 "Photo.c"
}


static gboolean photo_has_transformation (Photo* self, const gchar* name) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 2867 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2867 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 22139 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
		gboolean _tmp10_ = FALSE;
#line 2868 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2868 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 22147 "Photo.c"
		{
			gboolean _tmp1_ = FALSE;
			PhotoRow* _tmp2_ = NULL;
			GeeHashMap* _tmp3_ = NULL;
#line 2869 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = self->row;
#line 2869 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp3_ = _tmp2_->transformations;
#line 2869 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp3_ != NULL) {
#line 22158 "Photo.c"
				PhotoRow* _tmp4_ = NULL;
				GeeHashMap* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
#line 2869 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = self->row;
#line 2869 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = _tmp4_->transformations;
#line 2869 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = name;
#line 2869 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp6_);
#line 2869 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = _tmp7_;
#line 22173 "Photo.c"
			} else {
#line 2869 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp1_ = FALSE;
#line 22177 "Photo.c"
			}
#line 2869 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp1_;
#line 22181 "Photo.c"
			{
				PhotoRow* _tmp8_ = NULL;
#line 2868 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = self->row;
#line 2868 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22188 "Photo.c"
			}
#line 2869 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 22192 "Photo.c"
		}
		__finally375:
		{
			PhotoRow* _tmp9_ = NULL;
#line 2868 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = self->row;
#line 2868 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22201 "Photo.c"
		}
#line 2868 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2868 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2868 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp10_;
#line 22209 "Photo.c"
	}
}


static KeyValueMap* photo_get_transformation (Photo* self, const gchar* name) {
	KeyValueMap* result = NULL;
	KeyValueMap* map = NULL;
	GError * _inner_error_ = NULL;
#line 2876 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 2876 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 2877 "/home/jens/Source/shotwell/src/Photo.vala"
	map = NULL;
#line 22224 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2878 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2878 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 22231 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			GeeHashMap* _tmp2_ = NULL;
#line 2879 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2879 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->transformations;
#line 2879 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 22241 "Photo.c"
				PhotoRow* _tmp3_ = NULL;
				GeeHashMap* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				gpointer _tmp6_ = NULL;
				KeyValueMap* _tmp7_ = NULL;
#line 2880 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2880 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_->transformations;
#line 2880 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = name;
#line 2880 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp5_);
#line 2880 "/home/jens/Source/shotwell/src/Photo.vala"
				_key_value_map_unref0 (map);
#line 2880 "/home/jens/Source/shotwell/src/Photo.vala"
				map = (KeyValueMap*) _tmp6_;
#line 2881 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = map;
#line 2881 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp7_ != NULL) {
#line 22263 "Photo.c"
					KeyValueMap* _tmp8_ = NULL;
					KeyValueMap* _tmp9_ = NULL;
#line 2882 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp8_ = map;
#line 2882 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp9_ = key_value_map_copy (_tmp8_);
#line 2882 "/home/jens/Source/shotwell/src/Photo.vala"
					_key_value_map_unref0 (map);
#line 2882 "/home/jens/Source/shotwell/src/Photo.vala"
					map = _tmp9_;
#line 22274 "Photo.c"
				}
			}
		}
		__finally376:
		{
			PhotoRow* _tmp10_ = NULL;
#line 2878 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = self->row;
#line 2878 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22285 "Photo.c"
		}
#line 2878 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2878 "/home/jens/Source/shotwell/src/Photo.vala"
			_key_value_map_unref0 (map);
#line 2878 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2878 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2878 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 22297 "Photo.c"
		}
	}
#line 2886 "/home/jens/Source/shotwell/src/Photo.vala"
	result = map;
#line 2886 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 22304 "Photo.c"
}


static gboolean photo_set_transformation (Photo* self, KeyValueMap* trans) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 2889 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2889 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_KEY_VALUE_MAP (trans), FALSE);
#line 22315 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
		gboolean _tmp20_ = FALSE;
#line 2890 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2890 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 22323 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			GeeHashMap* _tmp2_ = NULL;
			PhotoRow* _tmp5_ = NULL;
			GeeHashMap* _tmp6_ = NULL;
			KeyValueMap* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			KeyValueMap* _tmp10_ = NULL;
			PhotoTable* _tmp11_ = NULL;
			PhotoTable* _tmp12_ = NULL;
			PhotoRow* _tmp13_ = NULL;
			PhotoID _tmp14_ = {0};
			KeyValueMap* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			gboolean _tmp17_ = FALSE;
#line 2891 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2891 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->transformations;
#line 2891 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ == NULL) {
#line 22346 "Photo.c"
				PhotoRow* _tmp3_ = NULL;
				GeeHashMap* _tmp4_ = NULL;
#line 2892 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2892 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_KEY_VALUE_MAP, (GBoxedCopyFunc) key_value_map_ref, (GDestroyNotify) key_value_map_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 2892 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_tmp3_->transformations);
#line 2892 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_->transformations = _tmp4_;
#line 22357 "Photo.c"
			}
#line 2894 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 2894 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp6_ = _tmp5_->transformations;
#line 2894 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = trans;
#line 2894 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp8_ = key_value_map_get_group (_tmp7_);
#line 2894 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = _tmp8_;
#line 2894 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = trans;
#line 2894 "/home/jens/Source/shotwell/src/Photo.vala"
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp9_, _tmp10_);
#line 2894 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_free0 (_tmp9_);
#line 2896 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = photo_table_get_instance ();
#line 2896 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = _tmp11_;
#line 2896 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = self->row;
#line 2896 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = _tmp13_->photo_id;
#line 2896 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = trans;
#line 2896 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = photo_table_set_transformation (_tmp12_, &_tmp14_, _tmp15_);
#line 2896 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = _tmp16_;
#line 2896 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp12_);
#line 2896 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp17_;
#line 22393 "Photo.c"
			{
				PhotoRow* _tmp18_ = NULL;
#line 2890 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = self->row;
#line 2890 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22400 "Photo.c"
			}
#line 2896 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 22404 "Photo.c"
		}
		__finally377:
		{
			PhotoRow* _tmp19_ = NULL;
#line 2890 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp19_ = self->row;
#line 2890 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22413 "Photo.c"
		}
#line 2890 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2890 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 2890 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp20_;
#line 22421 "Photo.c"
	}
}


static gboolean photo_remove_transformation (Photo* self, const gchar* name) {
	gboolean result = FALSE;
	gboolean altered_cache = FALSE;
	gboolean altered_persistent = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	GError * _inner_error_ = NULL;
#line 2900 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2900 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 22437 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 2902 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 2902 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 22444 "Photo.c"
		{
			PhotoRow* _tmp1_ = NULL;
			GeeHashMap* _tmp2_ = NULL;
			PhotoTable* _tmp12_ = NULL;
			PhotoTable* _tmp13_ = NULL;
			PhotoRow* _tmp14_ = NULL;
			PhotoID _tmp15_ = {0};
			const gchar* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
#line 2903 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = self->row;
#line 2903 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = _tmp1_->transformations;
#line 2903 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp2_ != NULL) {
#line 22460 "Photo.c"
				PhotoRow* _tmp3_ = NULL;
				GeeHashMap* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
				PhotoRow* _tmp7_ = NULL;
				GeeHashMap* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
#line 2904 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = self->row;
#line 2904 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = _tmp3_->transformations;
#line 2904 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = name;
#line 2904 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp5_, NULL);
#line 2904 "/home/jens/Source/shotwell/src/Photo.vala"
				altered_cache = _tmp6_;
#line 2905 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = self->row;
#line 2905 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = _tmp7_->transformations;
#line 2905 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 2905 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = _tmp9_;
#line 2905 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp10_ == 0) {
#line 22489 "Photo.c"
					PhotoRow* _tmp11_ = NULL;
#line 2906 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = self->row;
#line 2906 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (_tmp11_->transformations);
#line 2906 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_->transformations = NULL;
#line 22497 "Photo.c"
				}
			} else {
#line 2908 "/home/jens/Source/shotwell/src/Photo.vala"
				altered_cache = FALSE;
#line 22502 "Photo.c"
			}
#line 2911 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp12_ = photo_table_get_instance ();
#line 2911 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp13_ = _tmp12_;
#line 2911 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp14_ = self->row;
#line 2911 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp15_ = _tmp14_->photo_id;
#line 2911 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp16_ = name;
#line 2911 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp17_ = photo_table_remove_transformation (_tmp13_, &_tmp15_, _tmp16_);
#line 2911 "/home/jens/Source/shotwell/src/Photo.vala"
			altered_persistent = _tmp17_;
#line 2911 "/home/jens/Source/shotwell/src/Photo.vala"
			_database_table_unref0 (_tmp13_);
#line 22520 "Photo.c"
		}
		__finally378:
		{
			PhotoRow* _tmp18_ = NULL;
#line 2902 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp18_ = self->row;
#line 2902 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 22529 "Photo.c"
		}
#line 2902 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 22533 "Photo.c"
			gboolean _tmp19_ = FALSE;
#line 2902 "/home/jens/Source/shotwell/src/Photo.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2902 "/home/jens/Source/shotwell/src/Photo.vala"
			g_clear_error (&_inner_error_);
#line 2902 "/home/jens/Source/shotwell/src/Photo.vala"
			return _tmp19_;
#line 22541 "Photo.c"
		}
	}
#line 2915 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = altered_cache;
#line 2915 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp21_) {
#line 2915 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = TRUE;
#line 22550 "Photo.c"
	} else {
#line 2915 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp20_ = altered_persistent;
#line 22554 "Photo.c"
	}
#line 2915 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp20_;
#line 2915 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 22560 "Photo.c"
}


gboolean photo_has_crop (Photo* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 2918 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2919 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_has_transformation (self, "crop");
#line 2919 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 2919 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 22575 "Photo.c"
}


gboolean photo_get_raw_crop (Photo* self, Box* crop) {
	Box _vala_crop = {0};
	gboolean result = FALSE;
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_ = NULL;
	KeyValueMap* _tmp1_ = NULL;
	gint left = 0;
	KeyValueMap* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint top = 0;
	KeyValueMap* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint right = 0;
	KeyValueMap* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint bottom = 0;
	KeyValueMap* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gint _tmp13_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
#line 2923 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2924 "/home/jens/Source/shotwell/src/Photo.vala"
	box_init (&_vala_crop, 0, 0, 0, 0);
#line 2926 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_transformation (self, "crop");
#line 2926 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp0_;
#line 2927 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = map;
#line 2927 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 2928 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2928 "/home/jens/Source/shotwell/src/Photo.vala"
		_key_value_map_unref0 (map);
#line 2928 "/home/jens/Source/shotwell/src/Photo.vala"
		if (crop) {
#line 2928 "/home/jens/Source/shotwell/src/Photo.vala"
			*crop = _vala_crop;
#line 22625 "Photo.c"
		}
#line 2928 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 22629 "Photo.c"
	}
#line 2930 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = map;
#line 2930 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = key_value_map_get_int (_tmp2_, "left", -1);
#line 2930 "/home/jens/Source/shotwell/src/Photo.vala"
	left = _tmp3_;
#line 2931 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = map;
#line 2931 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = key_value_map_get_int (_tmp4_, "top", -1);
#line 2931 "/home/jens/Source/shotwell/src/Photo.vala"
	top = _tmp5_;
#line 2932 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = map;
#line 2932 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = key_value_map_get_int (_tmp6_, "right", -1);
#line 2932 "/home/jens/Source/shotwell/src/Photo.vala"
	right = _tmp7_;
#line 2933 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = map;
#line 2933 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = key_value_map_get_int (_tmp8_, "bottom", -1);
#line 2933 "/home/jens/Source/shotwell/src/Photo.vala"
	bottom = _tmp9_;
#line 2935 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = left;
#line 2935 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp13_ == -1) {
#line 2935 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = TRUE;
#line 22661 "Photo.c"
	} else {
		gint _tmp14_ = 0;
#line 2935 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp14_ = top;
#line 2935 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp12_ = _tmp14_ == -1;
#line 22668 "Photo.c"
	}
#line 2935 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp12_) {
#line 2935 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = TRUE;
#line 22674 "Photo.c"
	} else {
		gint _tmp15_ = 0;
#line 2935 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = right;
#line 2935 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = _tmp15_ == -1;
#line 22681 "Photo.c"
	}
#line 2935 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp11_) {
#line 2935 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = TRUE;
#line 22687 "Photo.c"
	} else {
		gint _tmp16_ = 0;
#line 2935 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = bottom;
#line 2935 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = _tmp16_ == -1;
#line 22694 "Photo.c"
	}
#line 2935 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp10_) {
#line 2936 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2936 "/home/jens/Source/shotwell/src/Photo.vala"
		_key_value_map_unref0 (map);
#line 2936 "/home/jens/Source/shotwell/src/Photo.vala"
		if (crop) {
#line 2936 "/home/jens/Source/shotwell/src/Photo.vala"
			*crop = _vala_crop;
#line 22706 "Photo.c"
		}
#line 2936 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 22710 "Photo.c"
	}
#line 2938 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = left;
#line 2938 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = top;
#line 2938 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = right;
#line 2938 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = bottom;
#line 2938 "/home/jens/Source/shotwell/src/Photo.vala"
	box_init (&_vala_crop, _tmp17_, _tmp18_, _tmp19_, _tmp20_);
#line 2940 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 2940 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 2940 "/home/jens/Source/shotwell/src/Photo.vala"
	if (crop) {
#line 2940 "/home/jens/Source/shotwell/src/Photo.vala"
		*crop = _vala_crop;
#line 22730 "Photo.c"
	}
#line 2940 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 22734 "Photo.c"
}


static void photo_set_raw_crop (Photo* self, Box* crop) {
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_ = NULL;
	KeyValueMap* _tmp1_ = NULL;
	Box _tmp2_ = {0};
	gint _tmp3_ = 0;
	KeyValueMap* _tmp4_ = NULL;
	Box _tmp5_ = {0};
	gint _tmp6_ = 0;
	KeyValueMap* _tmp7_ = NULL;
	Box _tmp8_ = {0};
	gint _tmp9_ = 0;
	KeyValueMap* _tmp10_ = NULL;
	Box _tmp11_ = {0};
	gint _tmp12_ = 0;
	KeyValueMap* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
#line 2944 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2944 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (crop != NULL);
#line 2945 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = key_value_map_new ("crop");
#line 2945 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp0_;
#line 2946 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = map;
#line 2946 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = *crop;
#line 2946 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_.left;
#line 2946 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_int (_tmp1_, "left", _tmp3_);
#line 2947 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = map;
#line 2947 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = *crop;
#line 2947 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = _tmp5_.top;
#line 2947 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_int (_tmp4_, "top", _tmp6_);
#line 2948 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = map;
#line 2948 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = *crop;
#line 2948 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = _tmp8_.right;
#line 2948 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_int (_tmp7_, "right", _tmp9_);
#line 2949 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = map;
#line 2949 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = *crop;
#line 2949 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = _tmp11_.bottom;
#line 2949 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_int (_tmp10_, "bottom", _tmp12_);
#line 2951 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = map;
#line 2951 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = photo_set_transformation (self, _tmp13_);
#line 2951 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp14_) {
#line 22801 "Photo.c"
		Alteration* _tmp15_ = NULL;
		Alteration* _tmp16_ = NULL;
#line 2952 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = alteration_new ("image", "crop");
#line 2952 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = _tmp15_;
#line 2952 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp16_);
#line 2952 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp16_);
#line 22812 "Photo.c"
	}
#line 2944 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 22816 "Photo.c"
}


static gboolean photo_get_raw_straighten (Photo* self, gdouble* angle) {
	gdouble _vala_angle = 0.0;
	gboolean result = FALSE;
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_ = NULL;
	KeyValueMap* _tmp1_ = NULL;
	KeyValueMap* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
#line 2955 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 2956 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_transformation (self, "straighten");
#line 2956 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp0_;
#line 2957 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = map;
#line 2957 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 2958 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_angle = 0.0;
#line 2960 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 2960 "/home/jens/Source/shotwell/src/Photo.vala"
		_key_value_map_unref0 (map);
#line 2960 "/home/jens/Source/shotwell/src/Photo.vala"
		if (angle) {
#line 2960 "/home/jens/Source/shotwell/src/Photo.vala"
			*angle = _vala_angle;
#line 22848 "Photo.c"
		}
#line 2960 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 22852 "Photo.c"
	}
#line 2963 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = map;
#line 2963 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = key_value_map_get_double (_tmp2_, "angle", 0.0);
#line 2963 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_angle = _tmp3_;
#line 2965 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 2965 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 2965 "/home/jens/Source/shotwell/src/Photo.vala"
	if (angle) {
#line 2965 "/home/jens/Source/shotwell/src/Photo.vala"
		*angle = _vala_angle;
#line 22868 "Photo.c"
	}
#line 2965 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 22872 "Photo.c"
}


static void photo_set_raw_straighten (Photo* self, gdouble theta) {
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_ = NULL;
	KeyValueMap* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	KeyValueMap* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 2968 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 2969 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = key_value_map_new ("straighten");
#line 2969 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp0_;
#line 2970 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = map;
#line 2970 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = theta;
#line 2970 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_double (_tmp1_, "angle", _tmp2_);
#line 2972 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = map;
#line 2972 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = photo_set_transformation (self, _tmp3_);
#line 2972 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp4_) {
#line 22901 "Photo.c"
		Alteration* _tmp5_ = NULL;
		Alteration* _tmp6_ = NULL;
#line 2973 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = alteration_new ("image", "straighten");
#line 2973 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = _tmp5_;
#line 2973 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp6_);
#line 2973 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp6_);
#line 22912 "Photo.c"
	}
#line 2968 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 22916 "Photo.c"
}


static EditingToolsRedeyeInstance* photo_get_raw_redeye_instances (Photo* self, int* result_length1) {
	EditingToolsRedeyeInstance* result = NULL;
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_ = NULL;
	KeyValueMap* _tmp1_ = NULL;
	gint num_points = 0;
	KeyValueMap* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	EditingToolsRedeyeInstance* res = NULL;
	gint _tmp7_ = 0;
	EditingToolsRedeyeInstance* _tmp8_ = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	GdkPoint default_point = {0};
	GdkPoint _tmp9_ = {0};
	EditingToolsRedeyeInstance* _tmp47_ = NULL;
	gint _tmp47__length1 = 0;
#line 2978 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 2979 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_transformation (self, "redeye");
#line 2979 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp0_;
#line 2980 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = map;
#line 2980 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 22948 "Photo.c"
		EditingToolsRedeyeInstance* _tmp2_ = NULL;
		EditingToolsRedeyeInstance* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
#line 2981 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = g_new0 (EditingToolsRedeyeInstance, 0);
#line 2981 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = _tmp2_;
#line 2981 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3__length1 = 0;
#line 2981 "/home/jens/Source/shotwell/src/Photo.vala"
		if (result_length1) {
#line 2981 "/home/jens/Source/shotwell/src/Photo.vala"
			*result_length1 = _tmp3__length1;
#line 22962 "Photo.c"
		}
#line 2981 "/home/jens/Source/shotwell/src/Photo.vala"
		result = _tmp3_;
#line 2981 "/home/jens/Source/shotwell/src/Photo.vala"
		_key_value_map_unref0 (map);
#line 2981 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 22970 "Photo.c"
	}
#line 2983 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = map;
#line 2983 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = key_value_map_get_int (_tmp4_, "num_points", -1);
#line 2983 "/home/jens/Source/shotwell/src/Photo.vala"
	num_points = _tmp5_;
#line 2984 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = num_points;
#line 2984 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_assert (_tmp6_ > 0, "num_points > 0");
#line 2986 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = num_points;
#line 2986 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = g_new0 (EditingToolsRedeyeInstance, _tmp7_);
#line 2986 "/home/jens/Source/shotwell/src/Photo.vala"
	res = _tmp8_;
#line 2986 "/home/jens/Source/shotwell/src/Photo.vala"
	res_length1 = _tmp7_;
#line 2986 "/home/jens/Source/shotwell/src/Photo.vala"
	_res_size_ = res_length1;
#line 2988 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_.x = 0;
#line 2988 "/home/jens/Source/shotwell/src/Photo.vala"
	default_point = _tmp9_;
#line 2989 "/home/jens/Source/shotwell/src/Photo.vala"
	default_point.x = -1;
#line 2990 "/home/jens/Source/shotwell/src/Photo.vala"
	default_point.y = -1;
#line 23000 "Photo.c"
	{
		gint i = 0;
#line 2992 "/home/jens/Source/shotwell/src/Photo.vala"
		i = 0;
#line 23005 "Photo.c"
		{
			gboolean _tmp10_ = FALSE;
#line 2992 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = TRUE;
#line 2992 "/home/jens/Source/shotwell/src/Photo.vala"
			while (TRUE) {
#line 23012 "Photo.c"
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gchar* center_key = NULL;
				gint _tmp14_ = 0;
				gchar* _tmp15_ = NULL;
				gchar* radius_key = NULL;
				gint _tmp16_ = 0;
				gchar* _tmp17_ = NULL;
				EditingToolsRedeyeInstance* _tmp18_ = NULL;
				gint _tmp18__length1 = 0;
				gint _tmp19_ = 0;
				KeyValueMap* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				GdkPoint _tmp22_ = {0};
				GdkPoint _tmp23_ = {0};
				EditingToolsRedeyeInstance* _tmp24_ = NULL;
				gint _tmp24__length1 = 0;
				gint _tmp25_ = 0;
				EditingToolsRedeyeInstance _tmp26_ = {0};
				GdkPoint _tmp27_ = {0};
				gint _tmp28_ = 0;
				GdkPoint _tmp29_ = {0};
				gint _tmp30_ = 0;
				EditingToolsRedeyeInstance* _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				gint _tmp32_ = 0;
				EditingToolsRedeyeInstance _tmp33_ = {0};
				GdkPoint _tmp34_ = {0};
				gint _tmp35_ = 0;
				GdkPoint _tmp36_ = {0};
				gint _tmp37_ = 0;
				EditingToolsRedeyeInstance* _tmp38_ = NULL;
				gint _tmp38__length1 = 0;
				gint _tmp39_ = 0;
				KeyValueMap* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				gint _tmp42_ = 0;
				EditingToolsRedeyeInstance* _tmp43_ = NULL;
				gint _tmp43__length1 = 0;
				gint _tmp44_ = 0;
				EditingToolsRedeyeInstance _tmp45_ = {0};
				gint _tmp46_ = 0;
#line 2992 "/home/jens/Source/shotwell/src/Photo.vala"
				if (!_tmp10_) {
#line 23057 "Photo.c"
					gint _tmp11_ = 0;
#line 2992 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = i;
#line 2992 "/home/jens/Source/shotwell/src/Photo.vala"
					i = _tmp11_ + 1;
#line 23063 "Photo.c"
				}
#line 2992 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = FALSE;
#line 2992 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = i;
#line 2992 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = num_points;
#line 2992 "/home/jens/Source/shotwell/src/Photo.vala"
				if (!(_tmp12_ < _tmp13_)) {
#line 2992 "/home/jens/Source/shotwell/src/Photo.vala"
					break;
#line 23075 "Photo.c"
				}
#line 2993 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = i;
#line 2993 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp15_ = g_strdup_printf ("center%d", _tmp14_);
#line 2993 "/home/jens/Source/shotwell/src/Photo.vala"
				center_key = _tmp15_;
#line 2994 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = i;
#line 2994 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = g_strdup_printf ("radius%d", _tmp16_);
#line 2994 "/home/jens/Source/shotwell/src/Photo.vala"
				radius_key = _tmp17_;
#line 2996 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_ = res;
#line 2996 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18__length1 = res_length1;
#line 2996 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp19_ = i;
#line 2996 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp20_ = map;
#line 2996 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp21_ = center_key;
#line 2996 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp22_ = default_point;
#line 2996 "/home/jens/Source/shotwell/src/Photo.vala"
				key_value_map_get_point (_tmp20_, _tmp21_, &_tmp22_, &_tmp23_);
#line 2996 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp18_[_tmp19_].center = _tmp23_;
#line 2997 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp24_ = res;
#line 2997 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp24__length1 = res_length1;
#line 2997 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp25_ = i;
#line 2997 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp26_ = _tmp24_[_tmp25_];
#line 2997 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp27_ = _tmp26_.center;
#line 2997 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp28_ = _tmp27_.x;
#line 2997 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp29_ = default_point;
#line 2997 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp30_ = _tmp29_.x;
#line 2997 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_assert (_tmp28_ != _tmp30_, "res[i].center.x != default_point.x");
#line 2998 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp31_ = res;
#line 2998 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp31__length1 = res_length1;
#line 2998 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp32_ = i;
#line 2998 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp33_ = _tmp31_[_tmp32_];
#line 2998 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp34_ = _tmp33_.center;
#line 2998 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp35_ = _tmp34_.y;
#line 2998 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp36_ = default_point;
#line 2998 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp37_ = _tmp36_.y;
#line 2998 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_assert (_tmp35_ != _tmp37_, "res[i].center.y != default_point.y");
#line 3000 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp38_ = res;
#line 3000 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp38__length1 = res_length1;
#line 3000 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp39_ = i;
#line 3000 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp40_ = map;
#line 3000 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp41_ = radius_key;
#line 3000 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp42_ = key_value_map_get_int (_tmp40_, _tmp41_, -1);
#line 3000 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp38_[_tmp39_].radius = _tmp42_;
#line 3001 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp43_ = res;
#line 3001 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp43__length1 = res_length1;
#line 3001 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp44_ = i;
#line 3001 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp45_ = _tmp43_[_tmp44_];
#line 3001 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp46_ = _tmp45_.radius;
#line 3001 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_assert (_tmp46_ != -1, "res[i].radius != -1");
#line 2992 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (radius_key);
#line 2992 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_free0 (center_key);
#line 23171 "Photo.c"
			}
		}
	}
#line 3004 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp47_ = res;
#line 3004 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp47__length1 = res_length1;
#line 3004 "/home/jens/Source/shotwell/src/Photo.vala"
	if (result_length1) {
#line 3004 "/home/jens/Source/shotwell/src/Photo.vala"
		*result_length1 = _tmp47__length1;
#line 23183 "Photo.c"
	}
#line 3004 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp47_;
#line 3004 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 3004 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 23191 "Photo.c"
}


gboolean photo_has_redeye_transformations (Photo* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 3007 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 3008 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_has_transformation (self, "redeye");
#line 3008 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp0_;
#line 3008 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 23206 "Photo.c"
}


void photo_add_redeye_instance (Photo* self, EditingToolsRedeyeInstance* redeye) {
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_ = NULL;
	KeyValueMap* _tmp1_ = NULL;
	gint num_points = 0;
	KeyValueMap* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gchar* radius_key = NULL;
	gint _tmp8_ = 0;
	gchar* _tmp9_ = NULL;
	gchar* center_key = NULL;
	gint _tmp10_ = 0;
	gchar* _tmp11_ = NULL;
	KeyValueMap* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	EditingToolsRedeyeInstance _tmp14_ = {0};
	gint _tmp15_ = 0;
	KeyValueMap* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	EditingToolsRedeyeInstance _tmp18_ = {0};
	GdkPoint _tmp19_ = {0};
	KeyValueMap* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	KeyValueMap* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
#line 3012 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 3012 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (redeye != NULL);
#line 3013 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = photo_get_transformation (self, "redeye");
#line 3013 "/home/jens/Source/shotwell/src/Photo.vala"
	map = _tmp0_;
#line 3014 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = map;
#line 3014 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_ == NULL) {
#line 23249 "Photo.c"
		KeyValueMap* _tmp2_ = NULL;
		KeyValueMap* _tmp3_ = NULL;
#line 3015 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = key_value_map_new ("redeye");
#line 3015 "/home/jens/Source/shotwell/src/Photo.vala"
		_key_value_map_unref0 (map);
#line 3015 "/home/jens/Source/shotwell/src/Photo.vala"
		map = _tmp2_;
#line 3016 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = map;
#line 3016 "/home/jens/Source/shotwell/src/Photo.vala"
		key_value_map_set_int (_tmp3_, "num_points", 0);
#line 23262 "Photo.c"
	}
#line 3019 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = map;
#line 3019 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = key_value_map_get_int (_tmp4_, "num_points", -1);
#line 3019 "/home/jens/Source/shotwell/src/Photo.vala"
	num_points = _tmp5_;
#line 3020 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = num_points;
#line 3020 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_assert (_tmp6_ >= 0, "num_points >= 0");
#line 3022 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = num_points;
#line 3022 "/home/jens/Source/shotwell/src/Photo.vala"
	num_points = _tmp7_ + 1;
#line 3024 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = num_points;
#line 3024 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = g_strdup_printf ("radius%d", _tmp8_ - 1);
#line 3024 "/home/jens/Source/shotwell/src/Photo.vala"
	radius_key = _tmp9_;
#line 3025 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp10_ = num_points;
#line 3025 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = g_strdup_printf ("center%d", _tmp10_ - 1);
#line 3025 "/home/jens/Source/shotwell/src/Photo.vala"
	center_key = _tmp11_;
#line 3027 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = map;
#line 3027 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp13_ = radius_key;
#line 3027 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp14_ = *redeye;
#line 3027 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp15_ = _tmp14_.radius;
#line 3027 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_int (_tmp12_, _tmp13_, _tmp15_);
#line 3028 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp16_ = map;
#line 3028 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = center_key;
#line 3028 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp18_ = *redeye;
#line 3028 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = _tmp18_.center;
#line 3028 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_point (_tmp16_, _tmp17_, &_tmp19_);
#line 3030 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = map;
#line 3030 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = num_points;
#line 3030 "/home/jens/Source/shotwell/src/Photo.vala"
	key_value_map_set_int (_tmp20_, "num_points", _tmp21_);
#line 3032 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp22_ = map;
#line 3032 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp23_ = photo_set_transformation (self, _tmp22_);
#line 3032 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp23_) {
#line 23322 "Photo.c"
		Alteration* _tmp24_ = NULL;
		Alteration* _tmp25_ = NULL;
#line 3033 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp24_ = alteration_new ("image", "redeye");
#line 3033 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp25_ = _tmp24_;
#line 3033 "/home/jens/Source/shotwell/src/Photo.vala"
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp25_);
#line 3033 "/home/jens/Source/shotwell/src/Photo.vala"
		_alteration_unref0 (_tmp25_);
#line 23333 "Photo.c"
	}
#line 3012 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (center_key);
#line 3012 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_free0 (radius_key);
#line 3012 "/home/jens/Source/shotwell/src/Photo.vala"
	_key_value_map_unref0 (map);
#line 23341 "Photo.c"
}


static gboolean photo_calculate_pixbuf_dimensions (Photo* self, Scaling* scaling, PhotoException exceptions, Dimensions* scaled_image, Dimensions* scaled_to_viewport) {
	Dimensions _vala_scaled_image = {0};
	Dimensions _vala_scaled_to_viewport = {0};
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 3047 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 3047 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (scaling != NULL, FALSE);
#line 23354 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 3049 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 3049 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 23362 "Photo.c"
		{
			Scaling _tmp1_ = {0};
			PhotoException _tmp2_ = 0;
			Dimensions _tmp3_ = {0};
			Dimensions _tmp4_ = {0};
			gboolean _tmp5_ = FALSE;
#line 3051 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = *scaling;
#line 3051 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = exceptions;
#line 3051 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = photo_locked_calculate_pixbuf_dimensions (self, &_tmp1_, _tmp2_, &_tmp3_, &_tmp4_);
#line 3051 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_scaled_image = _tmp3_;
#line 3051 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_scaled_to_viewport = _tmp4_;
#line 3051 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp5_;
#line 23381 "Photo.c"
			{
				PhotoRow* _tmp6_ = NULL;
#line 3049 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = self->row;
#line 3049 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&self->priv->__lock_row);
#line 23388 "Photo.c"
			}
#line 3051 "/home/jens/Source/shotwell/src/Photo.vala"
			if (scaled_image) {
#line 3051 "/home/jens/Source/shotwell/src/Photo.vala"
				*scaled_image = _vala_scaled_image;
#line 23394 "Photo.c"
			}
#line 3051 "/home/jens/Source/shotwell/src/Photo.vala"
			if (scaled_to_viewport) {
#line 3051 "/home/jens/Source/shotwell/src/Photo.vala"
				*scaled_to_viewport = _vala_scaled_to_viewport;
#line 23400 "Photo.c"
			}
#line 3051 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 23404 "Photo.c"
		}
		__finally379:
		{
			PhotoRow* _tmp7_ = NULL;
#line 3049 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp7_ = self->row;
#line 3049 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 23413 "Photo.c"
		}
#line 3049 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 3049 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 3049 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp8_;
#line 23421 "Photo.c"
	}
#line 3047 "/home/jens/Source/shotwell/src/Photo.vala"
	if (scaled_image) {
#line 3047 "/home/jens/Source/shotwell/src/Photo.vala"
		*scaled_image = _vala_scaled_image;
#line 23427 "Photo.c"
	}
#line 3047 "/home/jens/Source/shotwell/src/Photo.vala"
	if (scaled_to_viewport) {
#line 3047 "/home/jens/Source/shotwell/src/Photo.vala"
		*scaled_to_viewport = _vala_scaled_to_viewport;
#line 23433 "Photo.c"
	}
}


static gboolean photo_locked_calculate_pixbuf_dimensions (Photo* self, Scaling* scaling, PhotoException exceptions, Dimensions* scaled_image, Dimensions* scaled_to_viewport) {
	Dimensions _vala_scaled_image = {0};
	Dimensions _vala_scaled_to_viewport = {0};
	gboolean result = FALSE;
	Dimensions raw = {0};
	Dimensions _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	Orientation orientation = 0;
	Orientation _tmp4_ = 0;
	PhotoException _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp53_ = FALSE;
	Dimensions _tmp54_ = {0};
	gint _tmp55_ = 0;
	Dimensions _tmp56_ = {0};
	gint _tmp57_ = 0;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
#line 3057 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
#line 3057 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (scaling != NULL, FALSE);
#line 3059 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_get_raw_dimensions (self, &_tmp0_);
#line 3059 "/home/jens/Source/shotwell/src/Photo.vala"
	raw = _tmp0_;
#line 3061 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = scaling_is_unscaled (scaling);
#line 3061 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp1_) {
#line 23469 "Photo.c"
		Dimensions _tmp2_ = {0};
		Dimensions _tmp3_ = {0};
#line 3062 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp2_ = raw;
#line 3062 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_scaled_image = _tmp2_;
#line 3063 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = raw;
#line 3063 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_scaled_to_viewport = _tmp3_;
#line 3065 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 3065 "/home/jens/Source/shotwell/src/Photo.vala"
		if (scaled_image) {
#line 3065 "/home/jens/Source/shotwell/src/Photo.vala"
			*scaled_image = _vala_scaled_image;
#line 23486 "Photo.c"
		}
#line 3065 "/home/jens/Source/shotwell/src/Photo.vala"
		if (scaled_to_viewport) {
#line 3065 "/home/jens/Source/shotwell/src/Photo.vala"
			*scaled_to_viewport = _vala_scaled_to_viewport;
#line 23492 "Photo.c"
		}
#line 3065 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 23496 "Photo.c"
	}
#line 3068 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = photo_get_orientation (self);
#line 3068 "/home/jens/Source/shotwell/src/Photo.vala"
	orientation = _tmp4_;
#line 3073 "/home/jens/Source/shotwell/src/Photo.vala"
	dimensions_init (&_vala_scaled_image, 0, 0);
#line 3074 "/home/jens/Source/shotwell/src/Photo.vala"
	dimensions_init (&_vala_scaled_to_viewport, 0, 0);
#line 3076 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = exceptions;
#line 3076 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = photo_exception_allows (_tmp5_, PHOTO_EXCEPTION_CROP);
#line 3076 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp6_) {
#line 23512 "Photo.c"
		Box crop = {0};
		Box _tmp7_ = {0};
		gboolean _tmp8_ = FALSE;
#line 3078 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp8_ = photo_get_raw_crop (self, &_tmp7_);
#line 3078 "/home/jens/Source/shotwell/src/Photo.vala"
		crop = _tmp7_;
#line 3078 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp8_) {
#line 23522 "Photo.c"
			Dimensions rotated_raw = {0};
			Dimensions _tmp9_ = {0};
			PhotoException _tmp10_ = 0;
			gboolean _tmp11_ = FALSE;
			Box scaled_crop = {0};
			Dimensions _tmp19_ = {0};
			Dimensions _tmp20_ = {0};
			Box _tmp21_ = {0};
			Dimensions _tmp22_ = {0};
			gboolean _tmp23_ = FALSE;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			Dimensions _tmp30_ = {0};
			Dimensions _tmp31_ = {0};
			Dimensions _tmp32_ = {0};
			PhotoException _tmp33_ = 0;
			gboolean _tmp34_ = FALSE;
#line 3081 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp9_ = raw;
#line 3081 "/home/jens/Source/shotwell/src/Photo.vala"
			rotated_raw = _tmp9_;
#line 3082 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp10_ = exceptions;
#line 3082 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp11_ = photo_exception_allows (_tmp10_, PHOTO_EXCEPTION_ORIENTATION);
#line 3082 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp11_) {
#line 23550 "Photo.c"
				Orientation _tmp12_ = 0;
				Dimensions _tmp13_ = {0};
				Box _tmp14_ = {0};
				Box _tmp15_ = {0};
				Orientation _tmp16_ = 0;
				Dimensions _tmp17_ = {0};
				Dimensions _tmp18_ = {0};
#line 3083 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = orientation;
#line 3083 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp13_ = raw;
#line 3083 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp14_ = crop;
#line 3083 "/home/jens/Source/shotwell/src/Photo.vala"
				orientation_rotate_box (_tmp12_, &_tmp13_, &_tmp14_, &_tmp15_);
#line 3083 "/home/jens/Source/shotwell/src/Photo.vala"
				crop = _tmp15_;
#line 3084 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp16_ = orientation;
#line 3084 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp17_ = raw;
#line 3084 "/home/jens/Source/shotwell/src/Photo.vala"
				orientation_rotate_dimensions (_tmp16_, &_tmp17_, &_tmp18_);
#line 3084 "/home/jens/Source/shotwell/src/Photo.vala"
				rotated_raw = _tmp18_;
#line 23576 "Photo.c"
			}
#line 3088 "/home/jens/Source/shotwell/src/Photo.vala"
			box_get_dimensions (&crop, &_tmp19_);
#line 3088 "/home/jens/Source/shotwell/src/Photo.vala"
			scaling_get_scaled_dimensions (scaling, &_tmp19_, &_tmp20_);
#line 3088 "/home/jens/Source/shotwell/src/Photo.vala"
			box_get_scaled (&crop, &_tmp20_, &_tmp21_);
#line 3088 "/home/jens/Source/shotwell/src/Photo.vala"
			scaled_crop = _tmp21_;
#line 3091 "/home/jens/Source/shotwell/src/Photo.vala"
			box_get_dimensions (&scaled_crop, &_tmp22_);
#line 3091 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_scaled_to_viewport = _tmp22_;
#line 3094 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp24_ = box_get_width (&crop);
#line 3094 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp25_ = box_get_width (&scaled_crop);
#line 3094 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp24_ <= _tmp25_) {
#line 23596 "Photo.c"
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
#line 3095 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp26_ = box_get_height (&crop);
#line 3095 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp27_ = box_get_height (&scaled_crop);
#line 3095 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp23_ = _tmp26_ <= _tmp27_;
#line 23605 "Photo.c"
			} else {
#line 3094 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp23_ = FALSE;
#line 23609 "Photo.c"
			}
#line 3094 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp23_) {
#line 23613 "Photo.c"
				Dimensions _tmp28_ = {0};
				Dimensions _tmp29_ = {0};
#line 3096 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp28_ = raw;
#line 3096 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_scaled_image = _tmp28_;
#line 3097 "/home/jens/Source/shotwell/src/Photo.vala"
				box_get_dimensions (&crop, &_tmp29_);
#line 3097 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_scaled_to_viewport = _tmp29_;
#line 3099 "/home/jens/Source/shotwell/src/Photo.vala"
				result = FALSE;
#line 3099 "/home/jens/Source/shotwell/src/Photo.vala"
				if (scaled_image) {
#line 3099 "/home/jens/Source/shotwell/src/Photo.vala"
					*scaled_image = _vala_scaled_image;
#line 23630 "Photo.c"
				}
#line 3099 "/home/jens/Source/shotwell/src/Photo.vala"
				if (scaled_to_viewport) {
#line 3099 "/home/jens/Source/shotwell/src/Photo.vala"
					*scaled_to_viewport = _vala_scaled_to_viewport;
#line 23636 "Photo.c"
				}
#line 3099 "/home/jens/Source/shotwell/src/Photo.vala"
				return result;
#line 23640 "Photo.c"
			}
#line 3104 "/home/jens/Source/shotwell/src/Photo.vala"
			box_get_dimensions (&crop, &_tmp30_);
#line 3104 "/home/jens/Source/shotwell/src/Photo.vala"
			box_get_dimensions (&scaled_crop, &_tmp31_);
#line 3104 "/home/jens/Source/shotwell/src/Photo.vala"
			dimensions_get_scaled_similar (&rotated_raw, &_tmp30_, &_tmp31_, &_tmp32_);
#line 3104 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_scaled_image = _tmp32_;
#line 3108 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp33_ = exceptions;
#line 3108 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp34_ = photo_exception_allows (_tmp33_, PHOTO_EXCEPTION_ORIENTATION);
#line 3108 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp34_) {
#line 23656 "Photo.c"
				Orientation _tmp35_ = 0;
				Dimensions _tmp36_ = {0};
				Dimensions _tmp37_ = {0};
#line 3109 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp35_ = orientation;
#line 3109 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp36_ = _vala_scaled_image;
#line 3109 "/home/jens/Source/shotwell/src/Photo.vala"
				orientation_derotate_dimensions (_tmp35_, &_tmp36_, &_tmp37_);
#line 3109 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_scaled_image = _tmp37_;
#line 23668 "Photo.c"
			}
		}
	}
#line 3114 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp38_ = dimensions_has_area (&_vala_scaled_image);
#line 3114 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp38_) {
#line 23676 "Photo.c"
		Dimensions rotated_raw = {0};
		Dimensions _tmp39_ = {0};
		PhotoException _tmp40_ = 0;
		gboolean _tmp41_ = FALSE;
		Dimensions _tmp45_ = {0};
		Dimensions _tmp46_ = {0};
		Dimensions _tmp47_ = {0};
		PhotoException _tmp48_ = 0;
		gboolean _tmp49_ = FALSE;
#line 3116 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp39_ = raw;
#line 3116 "/home/jens/Source/shotwell/src/Photo.vala"
		rotated_raw = _tmp39_;
#line 3117 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp40_ = exceptions;
#line 3117 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp41_ = photo_exception_allows (_tmp40_, PHOTO_EXCEPTION_ORIENTATION);
#line 3117 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp41_) {
#line 23696 "Photo.c"
			Orientation _tmp42_ = 0;
			Dimensions _tmp43_ = {0};
			Dimensions _tmp44_ = {0};
#line 3118 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp42_ = orientation;
#line 3118 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp43_ = raw;
#line 3118 "/home/jens/Source/shotwell/src/Photo.vala"
			orientation_rotate_dimensions (_tmp42_, &_tmp43_, &_tmp44_);
#line 3118 "/home/jens/Source/shotwell/src/Photo.vala"
			rotated_raw = _tmp44_;
#line 23708 "Photo.c"
		}
#line 3120 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp45_ = rotated_raw;
#line 3120 "/home/jens/Source/shotwell/src/Photo.vala"
		scaling_get_scaled_dimensions (scaling, &_tmp45_, &_tmp46_);
#line 3120 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_scaled_image = _tmp46_;
#line 3121 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp47_ = _vala_scaled_image;
#line 3121 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_scaled_to_viewport = _tmp47_;
#line 3124 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp48_ = exceptions;
#line 3124 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp49_ = photo_exception_allows (_tmp48_, PHOTO_EXCEPTION_ORIENTATION);
#line 3124 "/home/jens/Source/shotwell/src/Photo.vala"
		if (_tmp49_) {
#line 23726 "Photo.c"
			Orientation _tmp50_ = 0;
			Dimensions _tmp51_ = {0};
			Dimensions _tmp52_ = {0};
#line 3125 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp50_ = orientation;
#line 3125 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp51_ = _vala_scaled_image;
#line 3125 "/home/jens/Source/shotwell/src/Photo.vala"
			orientation_derotate_dimensions (_tmp50_, &_tmp51_, &_tmp52_);
#line 3125 "/home/jens/Source/shotwell/src/Photo.vala"
			_vala_scaled_image = _tmp52_;
#line 23738 "Photo.c"
		}
	}
#line 3129 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp54_ = _vala_scaled_image;
#line 3129 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp55_ = _tmp54_.width;
#line 3129 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp56_ = raw;
#line 3129 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp57_ = _tmp56_.width;
#line 3129 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp55_ >= _tmp57_) {
#line 23751 "Photo.c"
		Dimensions _tmp58_ = {0};
		gint _tmp59_ = 0;
		Dimensions _tmp60_ = {0};
		gint _tmp61_ = 0;
#line 3129 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp58_ = _vala_scaled_image;
#line 3129 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp59_ = _tmp58_.height;
#line 3129 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp60_ = raw;
#line 3129 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp61_ = _tmp60_.height;
#line 3129 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp53_ = _tmp59_ >= _tmp61_;
#line 23766 "Photo.c"
	} else {
#line 3129 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp53_ = FALSE;
#line 23770 "Photo.c"
	}
#line 3129 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp53_) {
#line 23774 "Photo.c"
		Dimensions _tmp62_ = {0};
#line 3130 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp62_ = raw;
#line 3130 "/home/jens/Source/shotwell/src/Photo.vala"
		_vala_scaled_image = _tmp62_;
#line 3132 "/home/jens/Source/shotwell/src/Photo.vala"
		result = FALSE;
#line 3132 "/home/jens/Source/shotwell/src/Photo.vala"
		if (scaled_image) {
#line 3132 "/home/jens/Source/shotwell/src/Photo.vala"
			*scaled_image = _vala_scaled_image;
#line 23786 "Photo.c"
		}
#line 3132 "/home/jens/Source/shotwell/src/Photo.vala"
		if (scaled_to_viewport) {
#line 3132 "/home/jens/Source/shotwell/src/Photo.vala"
			*scaled_to_viewport = _vala_scaled_to_viewport;
#line 23792 "Photo.c"
		}
#line 3132 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 23796 "Photo.c"
	}
#line 3135 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp63_ = dimensions_has_area (&_vala_scaled_image);
#line 3135 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_assert (_tmp63_, "scaled_image.has_area()");
#line 3136 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp64_ = dimensions_has_area (&_vala_scaled_to_viewport);
#line 3136 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_assert (_tmp64_, "scaled_to_viewport.has_area()");
#line 3138 "/home/jens/Source/shotwell/src/Photo.vala"
	result = TRUE;
#line 3138 "/home/jens/Source/shotwell/src/Photo.vala"
	if (scaled_image) {
#line 3138 "/home/jens/Source/shotwell/src/Photo.vala"
		*scaled_image = _vala_scaled_image;
#line 23812 "Photo.c"
	}
#line 3138 "/home/jens/Source/shotwell/src/Photo.vala"
	if (scaled_to_viewport) {
#line 3138 "/home/jens/Source/shotwell/src/Photo.vala"
		*scaled_to_viewport = _vala_scaled_to_viewport;
#line 23818 "Photo.c"
	}
#line 3138 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 23822 "Photo.c"
}


static GdkPixbuf* photo_load_raw_pixbuf (Photo* self, Scaling* scaling, PhotoException exceptions, BackingFetchMode fetch_mode, GError** error) {
	GdkPixbuf* result = NULL;
	PhotoFileReader* loader = NULL;
	BackingFetchMode _tmp0_ = 0;
	PhotoFileReader* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Dimensions scaled_image = {0};
	Dimensions scaled_to_viewport = {0};
	gboolean is_scaled = FALSE;
	Scaling _tmp7_ = {0};
	PhotoException _tmp8_ = 0;
	Dimensions _tmp9_ = {0};
	Dimensions _tmp10_ = {0};
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	GdkPixbuf* pixbuf = NULL;
	PhotoFileReader* _tmp17_ = NULL;
	Dimensions _tmp18_ = {0};
	Dimensions _tmp19_ = {0};
	GdkPixbuf* _tmp20_ = NULL;
	GdkPixbuf* _tmp21_ = NULL;
	Dimensions _tmp22_ = {0};
	gboolean _tmp23_ = FALSE;
	GError * _inner_error_ = NULL;
#line 3144 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 3144 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 3147 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = fetch_mode;
#line 3147 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = photo_get_backing_reader (self, _tmp0_);
#line 3147 "/home/jens/Source/shotwell/src/Photo.vala"
	loader = _tmp1_;
#line 3150 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = scaling_is_unscaled (scaling);
#line 3150 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp2_) {
#line 23864 "Photo.c"
		GdkPixbuf* _tmp3_ = NULL;
		PhotoFileReader* _tmp4_ = NULL;
		GdkPixbuf* _tmp5_ = NULL;
		GdkPixbuf* _tmp6_ = NULL;
#line 3155 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp4_ = loader;
#line 3155 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp5_ = photo_file_reader_unscaled_read (_tmp4_, &_inner_error_);
#line 3155 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = _tmp5_;
#line 3155 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3155 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 3155 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_adapter_unref0 (loader);
#line 3155 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 23883 "Photo.c"
		}
#line 3155 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp6_ = _tmp3_;
#line 3155 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp3_ = NULL;
#line 3155 "/home/jens/Source/shotwell/src/Photo.vala"
		result = _tmp6_;
#line 3155 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp3_);
#line 3155 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (loader);
#line 3155 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 23897 "Photo.c"
	}
#line 3160 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = *scaling;
#line 3160 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = exceptions;
#line 3160 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp11_ = photo_calculate_pixbuf_dimensions (self, &_tmp7_, _tmp8_, &_tmp9_, &_tmp10_);
#line 3160 "/home/jens/Source/shotwell/src/Photo.vala"
	scaled_image = _tmp9_;
#line 3160 "/home/jens/Source/shotwell/src/Photo.vala"
	scaled_to_viewport = _tmp10_;
#line 3160 "/home/jens/Source/shotwell/src/Photo.vala"
	is_scaled = _tmp11_;
#line 3162 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp12_ = is_scaled;
#line 3162 "/home/jens/Source/shotwell/src/Photo.vala"
	if (!_tmp12_) {
#line 23915 "Photo.c"
		GdkPixbuf* _tmp13_ = NULL;
		PhotoFileReader* _tmp14_ = NULL;
		GdkPixbuf* _tmp15_ = NULL;
		GdkPixbuf* _tmp16_ = NULL;
#line 3167 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp14_ = loader;
#line 3167 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp15_ = photo_file_reader_unscaled_read (_tmp14_, &_inner_error_);
#line 3167 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = _tmp15_;
#line 3167 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3167 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 3167 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_file_adapter_unref0 (loader);
#line 3167 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 23934 "Photo.c"
		}
#line 3167 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp16_ = _tmp13_;
#line 3167 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp13_ = NULL;
#line 3167 "/home/jens/Source/shotwell/src/Photo.vala"
		result = _tmp16_;
#line 3167 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp13_);
#line 3167 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (loader);
#line 3167 "/home/jens/Source/shotwell/src/Photo.vala"
		return result;
#line 23948 "Photo.c"
	}
#line 3170 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp17_ = loader;
#line 3170 "/home/jens/Source/shotwell/src/Photo.vala"
	photo_get_raw_dimensions (self, &_tmp18_);
#line 3170 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp19_ = scaled_image;
#line 3170 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp20_ = photo_file_reader_scaled_read (_tmp17_, &_tmp18_, &_tmp19_, &_inner_error_);
#line 3170 "/home/jens/Source/shotwell/src/Photo.vala"
	pixbuf = _tmp20_;
#line 3170 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3170 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 3170 "/home/jens/Source/shotwell/src/Photo.vala"
		_photo_file_adapter_unref0 (loader);
#line 3170 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 23968 "Photo.c"
	}
#line 3178 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp21_ = pixbuf;
#line 3178 "/home/jens/Source/shotwell/src/Photo.vala"
	dimensions_for_pixbuf (_tmp21_, &_tmp22_);
#line 3178 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp23_ = dimensions_approx_equals (&scaled_image, &_tmp22_, PHOTO_SCALING_FUDGE);
#line 3178 "/home/jens/Source/shotwell/src/Photo.vala"
	_vala_assert (_tmp23_, "scaled_image.approx_equals(Dimensions.for_pixbuf(pixbuf), SCALING_FUDGE)");
#line 3180 "/home/jens/Source/shotwell/src/Photo.vala"
	result = pixbuf;
#line 3180 "/home/jens/Source/shotwell/src/Photo.vala"
	_photo_file_adapter_unref0 (loader);
#line 3180 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 23984 "Photo.c"
}


GdkPixbuf* photo_get_master_pixbuf (Photo* self, Scaling* scaling, gboolean rotate, GError** error) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	Scaling _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 3185 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 3185 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = *scaling;
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = rotate;
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_get_untransformed_pixbuf (self, &_tmp1_, _tmp2_, BACKING_FETCH_MODE_MASTER, &_inner_error_);
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _tmp3_;
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 24014 "Photo.c"
	}
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp0_;
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = NULL;
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp4_;
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp0_);
#line 3186 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 24026 "Photo.c"
}


GdkPixbuf* photo_get_unmodified_pixbuf (Photo* self, Scaling* scaling, gboolean rotate, GError** error) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	Scaling _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 3190 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 3190 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 3191 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = *scaling;
#line 3191 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = rotate;
#line 3191 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = photo_get_untransformed_pixbuf (self, &_tmp1_, _tmp2_, BACKING_FETCH_MODE_UNMODIFIED, &_inner_error_);
#line 3191 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _tmp3_;
#line 3191 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3191 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 3191 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 24056 "Photo.c"
	}
#line 3191 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = _tmp0_;
#line 3191 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = NULL;
#line 3191 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp4_;
#line 3191 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp0_);
#line 3191 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 24068 "Photo.c"
}


static GdkPixbuf* photo_get_untransformed_pixbuf (Photo* self, Scaling* scaling, gboolean rotate, BackingFetchMode fetch_mode, GError** error) {
	GdkPixbuf* result = NULL;
	Dimensions scaled_image = {0};
	Dimensions scaled_to_viewport = {0};
	Orientation original_orientation = 0;
	GdkPixbuf* pixbuf = NULL;
	Scaling _tmp6_ = {0};
	BackingFetchMode _tmp7_ = 0;
	GdkPixbuf* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GError * _inner_error_ = NULL;
#line 3195 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 3195 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 24087 "Photo.c"
	{
		PhotoRow* _tmp0_ = NULL;
#line 3209 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = self->row;
#line 3209 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&self->priv->__lock_row);
#line 24094 "Photo.c"
		{
			Scaling _tmp1_ = {0};
			Dimensions _tmp2_ = {0};
			Dimensions _tmp3_ = {0};
			Orientation _tmp4_ = 0;
#line 3210 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = *scaling;
#line 3210 "/home/jens/Source/shotwell/src/Photo.vala"
			photo_calculate_pixbuf_dimensions (self, &_tmp1_, PHOTO_EXCEPTION_NONE, &_tmp2_, &_tmp3_);
#line 3210 "/home/jens/Source/shotwell/src/Photo.vala"
			scaled_image = _tmp2_;
#line 3210 "/home/jens/Source/shotwell/src/Photo.vala"
			scaled_to_viewport = _tmp3_;
#line 3212 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp4_ = photo_get_original_orientation (self);
#line 3212 "/home/jens/Source/shotwell/src/Photo.vala"
			original_orientation = _tmp4_;
#line 24112 "Photo.c"
		}
		__finally380:
		{
			PhotoRow* _tmp5_ = NULL;
#line 3209 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp5_ = self->row;
#line 3209 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&self->priv->__lock_row);
#line 24121 "Photo.c"
		}
#line 3209 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3209 "/home/jens/Source/shotwell/src/Photo.vala"
			g_propagate_error (error, _inner_error_);
#line 3209 "/home/jens/Source/shotwell/src/Photo.vala"
			return NULL;
#line 24129 "Photo.c"
		}
	}
#line 3216 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp6_ = *scaling;
#line 3216 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp7_ = fetch_mode;
#line 3216 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp8_ = photo_load_raw_pixbuf (self, &_tmp6_, PHOTO_EXCEPTION_NONE, _tmp7_, &_inner_error_);
#line 3216 "/home/jens/Source/shotwell/src/Photo.vala"
	pixbuf = _tmp8_;
#line 3216 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3216 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 3216 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 24146 "Photo.c"
	}
#line 3222 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp9_ = rotate;
#line 3222 "/home/jens/Source/shotwell/src/Photo.vala"
	if (_tmp9_) {
#line 24152 "Photo.c"
		GdkPixbuf* _tmp10_ = NULL;
		GdkPixbuf* _tmp11_ = NULL;
#line 3223 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp10_ = pixbuf;
#line 3223 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp11_ = orientation_rotate_pixbuf (original_orientation, _tmp10_);
#line 3223 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (pixbuf);
#line 3223 "/home/jens/Source/shotwell/src/Photo.vala"
		pixbuf = _tmp11_;
#line 24163 "Photo.c"
	}
#line 3232 "/home/jens/Source/shotwell/src/Photo.vala"
	result = pixbuf;
#line 3232 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 24169 "Photo.c"
}


static GdkPixbuf* photo_real_get_pixbuf (PhotoSource* base, Scaling* scaling, GError** error) {
	Photo * self;
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	Scaling _tmp1_ = {0};
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 3235 "/home/jens/Source/shotwell/src/Photo.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
#line 3235 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 3236 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = *scaling;
#line 3236 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = photo_get_pixbuf_with_options (self, &_tmp1_, PHOTO_EXCEPTION_NONE, BACKING_FETCH_MODE_BASELINE, &_inner_error_);
#line 3236 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _tmp2_;
#line 3236 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3236 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 3236 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 24197 "Photo.c"
	}
#line 3236 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp0_;
#line 3236 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = NULL;
#line 3236 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp3_;
#line 3236 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp0_);
#line 3236 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 24209 "Photo.c"
}


/**
     * One-stop shopping for the source pixbuf cache.
     *
     * The source pixbuf cache holds untransformed, unscaled (full-sized) pixbufs of Photo objects.
     * These can be rather large and shouldn't be held in memory for too long, nor should many be
     * allowed to stack up.
     *
     * If locate is non-null, a source pixbuf is returned for the Photo.  If keep is true, the
     * pixbuf is stored in the cache.  (Thus, passing a Photo w/ keep == false will drop the cached
     * pixbuf.)  If Photo is non-null but keep is false, null is returned.
     *
     * Whether locate is null or not, the cache is walked in its entirety, dropping expired pixbufs
     * and dropping excessive pixbufs from the LRU.  Locating a Photo "touches" the pixbuf, i.e.
     * it moves to the head of the LRU.
     */
static gpointer _photo_cached_pixbuf_ref0 (gpointer self) {
#line 3271 "/home/jens/Source/shotwell/src/Photo.vala"
	return self ? photo_cached_pixbuf_ref (self) : NULL;
#line 24231 "Photo.c"
}


static gboolean _photo_trim_source_pixbuf_cache_gsource_func (gpointer self) {
	gboolean result;
	result = photo_trim_source_pixbuf_cache ();
#line 3323 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 24240 "Photo.c"
}


static GdkPixbuf* photo_run_source_pixbuf_cache (Photo* locate, gboolean keep, GError** error) {
	GdkPixbuf* result = NULL;
	GError * _inner_error_ = NULL;
#line 3254 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail ((locate == NULL) || IS_PHOTO (locate), NULL);
#line 24249 "Photo.c"
	{
		GeeLinkedList* _tmp0_ = NULL;
#line 3255 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = photo_source_pixbuf_cache;
#line 3255 "/home/jens/Source/shotwell/src/Photo.vala"
		g_rec_mutex_lock (&__lock_photo_source_pixbuf_cache);
#line 24256 "Photo.c"
		{
			PhotoCachedPixbuf* found = NULL;
			gdouble min_elapsed = 0.0;
			gint count = 0;
			GeeIterator* iter = NULL;
			GeeLinkedList* _tmp1_ = NULL;
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp29_ = FALSE;
			gboolean _tmp30_ = FALSE;
			PhotoCachedPixbuf* _tmp31_ = NULL;
			gboolean _tmp43_ = FALSE;
			PhotoCachedPixbuf* _tmp44_ = NULL;
			guint _tmp59_ = 0U;
			GeeLinkedList* _tmp61_ = NULL;
			gint _tmp62_ = 0;
			gint _tmp63_ = 0;
			GdkPixbuf* _tmp69_ = NULL;
			PhotoCachedPixbuf* _tmp70_ = NULL;
			GdkPixbuf* _tmp73_ = NULL;
#line 3256 "/home/jens/Source/shotwell/src/Photo.vala"
			found = NULL;
#line 3260 "/home/jens/Source/shotwell/src/Photo.vala"
			min_elapsed = DBL_MAX;
#line 3261 "/home/jens/Source/shotwell/src/Photo.vala"
			count = 0;
#line 3262 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp1_ = photo_source_pixbuf_cache;
#line 3262 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp2_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 3262 "/home/jens/Source/shotwell/src/Photo.vala"
			iter = _tmp2_;
#line 3263 "/home/jens/Source/shotwell/src/Photo.vala"
			while (TRUE) {
#line 24290 "Photo.c"
				GeeIterator* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				PhotoCachedPixbuf* cached_pixbuf = NULL;
				GeeIterator* _tmp5_ = NULL;
				gpointer _tmp6_ = NULL;
				gdouble elapsed = 0.0;
				PhotoCachedPixbuf* _tmp7_ = NULL;
				GTimer* _tmp8_ = NULL;
				gdouble _tmp9_ = 0.0;
				gdouble _tmp10_ = 0.0;
				gboolean _tmp11_ = FALSE;
				Photo* _tmp12_ = NULL;
#line 3263 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp3_ = iter;
#line 3263 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp4_ = gee_iterator_next (_tmp3_);
#line 3263 "/home/jens/Source/shotwell/src/Photo.vala"
				if (!_tmp4_) {
#line 3263 "/home/jens/Source/shotwell/src/Photo.vala"
					break;
#line 24311 "Photo.c"
				}
#line 3264 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp5_ = iter;
#line 3264 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp6_ = gee_iterator_get (_tmp5_);
#line 3264 "/home/jens/Source/shotwell/src/Photo.vala"
				cached_pixbuf = (PhotoCachedPixbuf*) _tmp6_;
#line 3266 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp7_ = cached_pixbuf;
#line 3266 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp8_ = _tmp7_->last_touched;
#line 3266 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp9_ = g_timer_elapsed (_tmp8_, NULL);
#line 3266 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp10_ = trunc (_tmp9_);
#line 3266 "/home/jens/Source/shotwell/src/Photo.vala"
				elapsed = _tmp10_ + 1;
#line 3268 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp12_ = locate;
#line 3268 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp12_ != NULL) {
#line 24333 "Photo.c"
					PhotoCachedPixbuf* _tmp13_ = NULL;
					Photo* _tmp14_ = NULL;
					Photo* _tmp15_ = NULL;
					gboolean _tmp16_ = FALSE;
#line 3268 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp13_ = cached_pixbuf;
#line 3268 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp14_ = _tmp13_->photo;
#line 3268 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp15_ = locate;
#line 3268 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp16_ = data_source_equals (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_DATA_SOURCE, DataSource), G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_DATA_SOURCE, DataSource));
#line 3268 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = _tmp16_;
#line 24348 "Photo.c"
				} else {
#line 3268 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp11_ = FALSE;
#line 24352 "Photo.c"
				}
#line 3268 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp11_) {
#line 24356 "Photo.c"
					GeeIterator* _tmp17_ = NULL;
					PhotoCachedPixbuf* _tmp18_ = NULL;
					PhotoCachedPixbuf* _tmp19_ = NULL;
					gint _tmp20_ = 0;
#line 3270 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp17_ = iter;
#line 3270 "/home/jens/Source/shotwell/src/Photo.vala"
					gee_iterator_remove (_tmp17_);
#line 3271 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp18_ = cached_pixbuf;
#line 3271 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp19_ = _photo_cached_pixbuf_ref0 (_tmp18_);
#line 3271 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_cached_pixbuf_unref0 (found);
#line 3271 "/home/jens/Source/shotwell/src/Photo.vala"
					found = _tmp19_;
#line 3274 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp20_ = count;
#line 3274 "/home/jens/Source/shotwell/src/Photo.vala"
					count = _tmp20_ + 1;
#line 24377 "Photo.c"
				} else {
					gdouble _tmp21_ = 0.0;
#line 3275 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp21_ = elapsed;
#line 3275 "/home/jens/Source/shotwell/src/Photo.vala"
					if (_tmp21_ >= ((gdouble) PHOTO_SOURCE_PIXBUF_TIME_TO_LIVE_SEC)) {
#line 24384 "Photo.c"
						GeeIterator* _tmp22_ = NULL;
#line 3276 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp22_ = iter;
#line 3276 "/home/jens/Source/shotwell/src/Photo.vala"
						gee_iterator_remove (_tmp22_);
#line 24390 "Photo.c"
					} else {
						gint _tmp23_ = 0;
#line 3277 "/home/jens/Source/shotwell/src/Photo.vala"
						_tmp23_ = count;
#line 3277 "/home/jens/Source/shotwell/src/Photo.vala"
						if (_tmp23_ >= PHOTO_SOURCE_PIXBUF_MAX_LRU_COUNT) {
#line 24397 "Photo.c"
							GeeIterator* _tmp24_ = NULL;
#line 3278 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp24_ = iter;
#line 3278 "/home/jens/Source/shotwell/src/Photo.vala"
							gee_iterator_remove (_tmp24_);
#line 24403 "Photo.c"
						} else {
							gdouble _tmp25_ = 0.0;
							gdouble _tmp26_ = 0.0;
							gdouble _tmp27_ = 0.0;
							gint _tmp28_ = 0;
#line 3282 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp25_ = elapsed;
#line 3282 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp26_ = min_elapsed;
#line 3282 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp27_ = MIN (_tmp25_, _tmp26_);
#line 3282 "/home/jens/Source/shotwell/src/Photo.vala"
							min_elapsed = _tmp27_;
#line 3283 "/home/jens/Source/shotwell/src/Photo.vala"
							_tmp28_ = count;
#line 3283 "/home/jens/Source/shotwell/src/Photo.vala"
							count = _tmp28_ + 1;
#line 24421 "Photo.c"
						}
					}
				}
#line 3263 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_cached_pixbuf_unref0 (cached_pixbuf);
#line 24427 "Photo.c"
			}
#line 3288 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp31_ = found;
#line 3288 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp31_ == NULL) {
#line 24433 "Photo.c"
				Photo* _tmp32_ = NULL;
#line 3288 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp32_ = locate;
#line 3288 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp30_ = _tmp32_ != NULL;
#line 24439 "Photo.c"
			} else {
#line 3288 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp30_ = FALSE;
#line 24443 "Photo.c"
			}
#line 3288 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp30_) {
#line 24447 "Photo.c"
				gboolean _tmp33_ = FALSE;
#line 3288 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp33_ = keep;
#line 3288 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp29_ = _tmp33_;
#line 24453 "Photo.c"
			} else {
#line 3288 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp29_ = FALSE;
#line 24457 "Photo.c"
			}
#line 3288 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp29_) {
#line 24461 "Photo.c"
				GdkPixbuf* _tmp34_ = NULL;
				Photo* _tmp35_ = NULL;
				Scaling _tmp36_ = {0};
				GdkPixbuf* _tmp37_ = NULL;
				Photo* _tmp38_ = NULL;
				PhotoCachedPixbuf* _tmp39_ = NULL;
#line 3290 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp35_ = locate;
#line 3290 "/home/jens/Source/shotwell/src/Photo.vala"
				scaling_for_original (&_tmp36_);
#line 3290 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp37_ = photo_load_raw_pixbuf (_tmp35_, &_tmp36_, PHOTO_EXCEPTION_ALL, BACKING_FETCH_MODE_SOURCE, &_inner_error_);
#line 3290 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp34_ = _tmp37_;
#line 3290 "/home/jens/Source/shotwell/src/Photo.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3290 "/home/jens/Source/shotwell/src/Photo.vala"
					_g_object_unref0 (iter);
#line 3290 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_cached_pixbuf_unref0 (found);
#line 24482 "Photo.c"
					goto __finally381;
				}
#line 3289 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp38_ = locate;
#line 3289 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp39_ = photo_cached_pixbuf_new (_tmp38_, _tmp34_);
#line 3289 "/home/jens/Source/shotwell/src/Photo.vala"
				_photo_cached_pixbuf_unref0 (found);
#line 3289 "/home/jens/Source/shotwell/src/Photo.vala"
				found = _tmp39_;
#line 3288 "/home/jens/Source/shotwell/src/Photo.vala"
				_g_object_unref0 (_tmp34_);
#line 24495 "Photo.c"
			} else {
				PhotoCachedPixbuf* _tmp40_ = NULL;
#line 3291 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp40_ = found;
#line 3291 "/home/jens/Source/shotwell/src/Photo.vala"
				if (_tmp40_ != NULL) {
#line 24502 "Photo.c"
					PhotoCachedPixbuf* _tmp41_ = NULL;
					GTimer* _tmp42_ = NULL;
#line 3293 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp41_ = found;
#line 3293 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp42_ = _tmp41_->last_touched;
#line 3293 "/home/jens/Source/shotwell/src/Photo.vala"
					g_timer_start (_tmp42_);
#line 24511 "Photo.c"
				}
			}
#line 3297 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp44_ = found;
#line 3297 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp44_ != NULL) {
#line 24518 "Photo.c"
				gboolean _tmp45_ = FALSE;
#line 3297 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp45_ = keep;
#line 3297 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp43_ = _tmp45_;
#line 24524 "Photo.c"
			} else {
#line 3297 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp43_ = FALSE;
#line 24528 "Photo.c"
			}
#line 3297 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp43_) {
#line 24532 "Photo.c"
				GeeLinkedList* _tmp46_ = NULL;
				PhotoCachedPixbuf* _tmp47_ = NULL;
				PhotoCachedPixbuf* _tmp48_ = NULL;
				GTimer* _tmp49_ = NULL;
				gdouble _tmp50_ = 0.0;
				gdouble _tmp51_ = 0.0;
				gdouble _tmp52_ = 0.0;
#line 3298 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp46_ = photo_source_pixbuf_cache;
#line 3298 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp47_ = found;
#line 3298 "/home/jens/Source/shotwell/src/Photo.vala"
				gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0, _tmp47_);
#line 3303 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp48_ = found;
#line 3303 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp49_ = _tmp48_->last_touched;
#line 3303 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp50_ = g_timer_elapsed (_tmp49_, NULL);
#line 3303 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp51_ = min_elapsed;
#line 3303 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp52_ = MIN (_tmp50_, _tmp51_);
#line 3303 "/home/jens/Source/shotwell/src/Photo.vala"
				min_elapsed = _tmp52_;
#line 3307 "/home/jens/Source/shotwell/src/Photo.vala"
				while (TRUE) {
#line 24560 "Photo.c"
					GeeLinkedList* _tmp53_ = NULL;
					gint _tmp54_ = 0;
					gint _tmp55_ = 0;
					GeeLinkedList* _tmp56_ = NULL;
					gpointer _tmp57_ = NULL;
					PhotoCachedPixbuf* _tmp58_ = NULL;
#line 3307 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp53_ = photo_source_pixbuf_cache;
#line 3307 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp54_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 3307 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp55_ = _tmp54_;
#line 3307 "/home/jens/Source/shotwell/src/Photo.vala"
					if (!(_tmp55_ > PHOTO_SOURCE_PIXBUF_MAX_LRU_COUNT)) {
#line 3307 "/home/jens/Source/shotwell/src/Photo.vala"
						break;
#line 24577 "Photo.c"
					}
#line 3308 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp56_ = photo_source_pixbuf_cache;
#line 3308 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp57_ = gee_deque_poll_tail (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, GEE_TYPE_DEQUE, GeeDeque));
#line 3308 "/home/jens/Source/shotwell/src/Photo.vala"
					_tmp58_ = (PhotoCachedPixbuf*) _tmp57_;
#line 3308 "/home/jens/Source/shotwell/src/Photo.vala"
					_photo_cached_pixbuf_unref0 (_tmp58_);
#line 24587 "Photo.c"
				}
			}
#line 3312 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp59_ = photo_discard_source_id;
#line 3312 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp59_ != ((guint) 0)) {
#line 24594 "Photo.c"
				guint _tmp60_ = 0U;
#line 3313 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp60_ = photo_discard_source_id;
#line 3313 "/home/jens/Source/shotwell/src/Photo.vala"
				g_source_remove (_tmp60_);
#line 3314 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_discard_source_id = (guint) 0;
#line 24602 "Photo.c"
			}
#line 3318 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp61_ = photo_source_pixbuf_cache;
#line 3318 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp62_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 3318 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp63_ = _tmp62_;
#line 3318 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp63_ > PHOTO_SOURCE_PIXBUF_MIN_LRU_COUNT) {
#line 24612 "Photo.c"
				gdouble _tmp64_ = 0.0;
				guint retry_sec = 0U;
				gdouble _tmp65_ = 0.0;
				gdouble _tmp66_ = 0.0;
				guint _tmp67_ = 0U;
				guint _tmp68_ = 0U;
#line 3319 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp64_ = min_elapsed;
#line 3319 "/home/jens/Source/shotwell/src/Photo.vala"
				_vala_assert (_tmp64_ >= 0.0, "min_elapsed >= 0.0");
#line 3322 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp65_ = min_elapsed;
#line 3322 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp66_ = trunc (_tmp65_);
#line 3322 "/home/jens/Source/shotwell/src/Photo.vala"
				retry_sec = PHOTO_SOURCE_PIXBUF_TIME_TO_LIVE_SEC - ((guint) _tmp66_);
#line 3323 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp67_ = retry_sec;
#line 3323 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp68_ = g_timeout_add_seconds_full (G_PRIORITY_LOW, _tmp67_, _photo_trim_source_pixbuf_cache_gsource_func, NULL, NULL);
#line 3323 "/home/jens/Source/shotwell/src/Photo.vala"
				photo_discard_source_id = _tmp68_;
#line 24635 "Photo.c"
			}
#line 3326 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp70_ = found;
#line 3326 "/home/jens/Source/shotwell/src/Photo.vala"
			if (_tmp70_ != NULL) {
#line 24641 "Photo.c"
				PhotoCachedPixbuf* _tmp71_ = NULL;
				GdkPixbuf* _tmp72_ = NULL;
#line 3326 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp71_ = found;
#line 3326 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp72_ = _tmp71_->pixbuf;
#line 3326 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp69_ = _tmp72_;
#line 24650 "Photo.c"
			} else {
#line 3326 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp69_ = NULL;
#line 24654 "Photo.c"
			}
#line 3326 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp73_ = _g_object_ref0 (_tmp69_);
#line 3326 "/home/jens/Source/shotwell/src/Photo.vala"
			result = _tmp73_;
#line 3326 "/home/jens/Source/shotwell/src/Photo.vala"
			_g_object_unref0 (iter);
#line 3326 "/home/jens/Source/shotwell/src/Photo.vala"
			_photo_cached_pixbuf_unref0 (found);
#line 24664 "Photo.c"
			{
				GeeLinkedList* _tmp74_ = NULL;
#line 3255 "/home/jens/Source/shotwell/src/Photo.vala"
				_tmp74_ = photo_source_pixbuf_cache;
#line 3255 "/home/jens/Source/shotwell/src/Photo.vala"
				g_rec_mutex_unlock (&__lock_photo_source_pixbuf_cache);
#line 24671 "Photo.c"
			}
#line 3326 "/home/jens/Source/shotwell/src/Photo.vala"
			return result;
#line 24675 "Photo.c"
		}
		__finally381:
		{
			GeeLinkedList* _tmp75_ = NULL;
#line 3255 "/home/jens/Source/shotwell/src/Photo.vala"
			_tmp75_ = photo_source_pixbuf_cache;
#line 3255 "/home/jens/Source/shotwell/src/Photo.vala"
			g_rec_mutex_unlock (&__lock_photo_source_pixbuf_cache);
#line 24684 "Photo.c"
		}
#line 3255 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 3255 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 24690 "Photo.c"
	}
}


static gboolean photo_trim_source_pixbuf_cache (void) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		GdkPixbuf* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_ = NULL;
#line 3332 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = photo_run_source_pixbuf_cache (NULL, FALSE, &_inner_error_);
#line 3332 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp1_ = _tmp0_;
#line 3332 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_object_unref0 (_tmp1_);
#line 3332 "/home/jens/Source/shotwell/src/Photo.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 24709 "Photo.c"
			goto __catch382_g_error;
		}
	}
	goto __finally382;
	__catch382_g_error:
	{
		GError* err = NULL;
#line 3331 "/home/jens/Source/shotwell/src/Photo.vala"
		err = _inner_error_;
#line 3331 "/home/jens/Source/shotwell/src/Photo.vala"
		_inner_error_ = NULL;
#line 3331 "/home/jens/Source/shotwell/src/Photo.vala"
		_g_error_free0 (err);
#line 24723 "Photo.c"
	}
	__finally382:
#line 3331 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 24728 "Photo.c"
		gboolean _tmp2_ = FALSE;
#line 3331 "/home/jens/Source/shotwell/src/Photo.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 3331 "/home/jens/Source/shotwell/src/Photo.vala"
		g_clear_error (&_inner_error_);
#line 3331 "/home/jens/Source/shotwell/src/Photo.vala"
		return _tmp2_;
#line 24736 "Photo.c"
	}
#line 3336 "/home/jens/Source/shotwell/src/Photo.vala"
	result = FALSE;
#line 3336 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 24742 "Photo.c"
}


/**
     * @brief Get a copy of what's in the cache.
     *
     * @return A copy of the Pixbuf with the image data from unmodified_precached.
     */
GdkPixbuf* photo_get_prefetched_copy (Photo* self, GError** error) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	GdkPixbuf* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 3344 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_val_if_fail (IS_PHOTO (self), NULL);
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp1_ = photo_run_source_pixbuf_cache (self, TRUE, &_inner_error_);
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = _tmp1_;
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
		g_propagate_error (error, _inner_error_);
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
		return NULL;
#line 24772 "Photo.c"
	}
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp2_ = _tmp0_;
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp0_ = NULL;
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp3_ = _tmp2_;
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp4_ = gdk_pixbuf_copy (_tmp3_);
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
	_tmp5_ = _tmp4_;
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp3_);
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
	result = _tmp5_;
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
	_g_object_unref0 (_tmp0_);
#line 3345 "/home/jens/Source/shotwell/src/Photo.vala"
	return result;
#line 24792 "Photo.c"
}


/**
     * @brief Discards the cached version of the unmodified image.
     */
void photo_discard_prefetched (Photo* self) {
	GError * _inner_error_ = NULL;
#line 3351 "/home/jens/Source/shotwell/src/Photo.vala"
	g_return_if_fail (IS_PHOTO (self));
#line 24803 "Photo.c"
	{
		GdkPixbuf* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_ = NULL;
#line 3353 "/home/jens/Source/shotwell/src/Photo.vala"
		_tmp0_ = photo_run_source_pixbuf_cache (self, FALSE, &_inner_error_);
#line 3353 "/home/jens/Source/shotwell/src/Photo.vala"
		_t