/* CheckerboardLayout.c generated by valac 0.36.6, the Vala compiler
 * generated from CheckerboardLayout.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>
#include <pango/pangocairo.h>
#include <gobject/gvaluecollector.h>


#define TYPE_CHECKERBOARD_ITEM_TEXT (checkerboard_item_text_get_type ())
#define CHECKERBOARD_ITEM_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemText))
#define CHECKERBOARD_ITEM_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemTextClass))
#define IS_CHECKERBOARD_ITEM_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_ITEM_TEXT))
#define IS_CHECKERBOARD_ITEM_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_ITEM_TEXT))
#define CHECKERBOARD_ITEM_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemTextClass))

typedef struct _CheckerboardItemText CheckerboardItemText;
typedef struct _CheckerboardItemTextClass CheckerboardItemTextClass;
typedef struct _CheckerboardItemTextPrivate CheckerboardItemTextPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
typedef struct _ParamSpecCheckerboardItemText ParamSpecCheckerboardItemText;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;
typedef struct _DataViewPrivate DataViewPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_VIEW (thumbnail_view_get_type ())
#define THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailView))
#define THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))
#define IS_THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_VIEW))
#define IS_THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_VIEW))
#define THUMBNAIL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))

typedef struct _ThumbnailView ThumbnailView;
typedef struct _ThumbnailViewClass ThumbnailViewClass;
typedef struct _ThumbnailViewPrivate ThumbnailViewPrivate;

#define TYPE_CHECKERBOARD_ITEM (checkerboard_item_get_type ())
#define CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItem))
#define CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))
#define IS_CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_ITEM))
#define IS_CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_ITEM))
#define CHECKERBOARD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))

typedef struct _CheckerboardItem CheckerboardItem;
typedef struct _CheckerboardItemClass CheckerboardItemClass;
typedef struct _CheckerboardItemPrivate CheckerboardItemPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;
#define _checkerboard_item_text_unref0(var) ((var == NULL) ? NULL : (var = (checkerboard_item_text_unref (var), NULL)))

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))

#define TYPE_CHECKERBOARD_LAYOUT (checkerboard_layout_get_type ())
#define CHECKERBOARD_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout))
#define CHECKERBOARD_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayoutClass))
#define IS_CHECKERBOARD_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_LAYOUT))
#define IS_CHECKERBOARD_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_LAYOUT))
#define CHECKERBOARD_LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayoutClass))

typedef struct _CheckerboardLayout CheckerboardLayout;
typedef struct _CheckerboardLayoutClass CheckerboardLayoutClass;
typedef struct _CheckerboardLayoutPrivate CheckerboardLayoutPrivate;

#define TYPE_VIEW_COLLECTION (view_collection_get_type ())
#define VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW_COLLECTION, ViewCollection))
#define VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW_COLLECTION, ViewCollectionClass))
#define IS_VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW_COLLECTION))
#define IS_VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW_COLLECTION))
#define VIEW_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW_COLLECTION, ViewCollectionClass))

typedef struct _ViewCollection ViewCollection;
typedef struct _ViewCollectionClass ViewCollectionClass;

#define CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW (checkerboard_layout_layout_row_get_type ())
#define CHECKERBOARD_LAYOUT_LAYOUT_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRow))
#define CHECKERBOARD_LAYOUT_LAYOUT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRowClass))
#define CHECKERBOARD_LAYOUT_IS_LAYOUT_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW))
#define CHECKERBOARD_LAYOUT_IS_LAYOUT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW))
#define CHECKERBOARD_LAYOUT_LAYOUT_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRowClass))

typedef struct _CheckerboardLayoutLayoutRow CheckerboardLayoutLayoutRow;
typedef struct _CheckerboardLayoutLayoutRowClass CheckerboardLayoutLayoutRowClass;

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
typedef struct _CheckerboardLayoutLayoutRowPrivate CheckerboardLayoutLayoutRowPrivate;
#define _checkerboard_layout_layout_row_unref0(var) ((var == NULL) ? NULL : (var = (checkerboard_layout_layout_row_unref (var), NULL)))

#define TYPE_LIBRARY_WINDOW (library_window_get_type ())
#define LIBRARY_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_WINDOW, LibraryWindow))
#define LIBRARY_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_WINDOW, LibraryWindowClass))
#define IS_LIBRARY_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_WINDOW))
#define IS_LIBRARY_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_WINDOW))
#define LIBRARY_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_WINDOW, LibraryWindowClass))

typedef struct _LibraryWindow LibraryWindow;
typedef struct _LibraryWindowClass LibraryWindowClass;

#define TYPE_COMPASS_POINT (compass_point_get_type ())

#define TYPE_BOX (box_get_type ())
typedef struct _Box Box;
typedef struct _CheckerboardLayoutParamSpecLayoutRow CheckerboardLayoutParamSpecLayoutRow;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CheckerboardItemText {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CheckerboardItemTextPrivate * priv;
	GdkRectangle allocation;
};

struct _CheckerboardItemTextClass {
	GTypeClass parent_class;
	void (*finalize) (CheckerboardItemText *self);
};

struct _CheckerboardItemTextPrivate {
	gchar* text;
	gboolean marked_up;
	PangoAlignment alignment;
	PangoLayout* layout;
	gboolean single_line;
	gint height;
};

struct _ParamSpecCheckerboardItemText {
	GParamSpec parent_instance;
};

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataView {
	DataObject parent_instance;
	DataViewPrivate * priv;
};

struct _DataViewClass {
	DataObjectClass parent_class;
	void (*notify_view_altered) (DataView* self);
	void (*notify_geometry_altered) (DataView* self);
	void (*notify_unsubscribed) (DataView* self, DataSource* source);
	void (*state_changed) (DataView* self, gboolean selected);
	void (*visibility_changed) (DataView* self, gboolean visible);
	void (*view_altered) (DataView* self);
	void (*geometry_altered) (DataView* self);
	void (*unsubscribed) (DataView* self, DataSource* source);
};

struct _ThumbnailView {
	DataView parent_instance;
	ThumbnailViewPrivate * priv;
};

struct _ThumbnailViewClass {
	DataViewClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailView* self);
	void (*thumbnail_altered) (ThumbnailView* self);
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _CheckerboardItem {
	ThumbnailView parent_instance;
	CheckerboardItemPrivate * priv;
	Dimensions requisition;
	GdkRectangle allocation;
};

struct _CheckerboardItemClass {
	ThumbnailViewClass parent_class;
	void (*exposed) (CheckerboardItem* self);
	void (*unexposed) (CheckerboardItem* self);
	gboolean (*is_exposed) (CheckerboardItem* self);
	void (*paint_shadow) (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
	void (*paint_border) (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width);
	void (*paint_image) (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin);
	GdkPixbuf* (*get_top_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_top_right_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_right_trinket) (CheckerboardItem* self, gint scale);
};

struct _CheckerboardItemPrivate {
	gboolean exposure;
	CheckerboardItemText* title;
	gboolean title_visible;
	CheckerboardItemText* comment;
	gboolean comment_visible;
	CheckerboardItemText* subtitle;
	gboolean subtitle_visible;
	gboolean is_cursor;
	PangoAlignment tag_alignment;
	GeeList* user_visible_tag_list;
	GeeCollection* tags;
	GdkPixbuf* pixbuf;
	GdkPixbuf* display_pixbuf;
	GdkPixbuf* brightened;
	Dimensions pixbuf_dim;
	gint col;
	gint row;
	gint horizontal_trinket_offset;
	gboolean _has_tags;
};

struct _CheckerboardLayout {
	GtkDrawingArea parent_instance;
	CheckerboardLayoutPrivate * priv;
};

struct _CheckerboardLayoutClass {
	GtkDrawingAreaClass parent_class;
};

struct _CheckerboardLayoutPrivate {
	ViewCollection* view;
	gchar* page_name;
	CheckerboardLayoutLayoutRow** item_rows;
	gint item_rows_length1;
	gint _item_rows_size_;
	GeeHashSet* exposed_items;
	GtkAdjustment* hadjustment;
	GtkAdjustment* vadjustment;
	gchar* message;
	GdkRGBA selected_color;
	GdkRGBA unselected_color;
	GdkRGBA border_color;
	GdkRGBA bg_color;
	GdkRectangle visible_page;
	gint last_width;
	gint columns;
	gint rows;
	GdkPoint drag_origin;
	GdkPoint drag_endpoint;
	GdkRectangle selection_band;
	gint scale;
	gboolean flow_scheduled;
	gboolean exposure_dirty;
	CheckerboardItem* anchor;
	CheckerboardItem* cursor;
	gboolean in_center_on_anchor;
	gboolean size_allocate_due_to_reflow;
	gboolean is_in_view;
	gboolean reflow_needed;
};

struct _CheckerboardLayoutLayoutRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CheckerboardLayoutLayoutRowPrivate * priv;
	gint y;
	gint height;
	CheckerboardItem** items;
	gint items_length1;
	gint _items_size_;
};

struct _CheckerboardLayoutLayoutRowClass {
	GTypeClass parent_class;
	void (*finalize) (CheckerboardLayoutLayoutRow *self);
};

typedef enum  {
	COMPASS_POINT_NORTH,
	COMPASS_POINT_SOUTH,
	COMPASS_POINT_EAST,
	COMPASS_POINT_WEST
} CompassPoint;

struct _Box {
	gint left;
	gint top;
	gint right;
	gint bottom;
};

struct _CheckerboardLayoutParamSpecLayoutRow {
	GParamSpec parent_instance;
};


static gpointer checkerboard_item_text_parent_class = NULL;
static gint checkerboard_item_text_one_line_height;
static gint checkerboard_item_text_one_line_height = 0;
static gpointer checkerboard_item_parent_class = NULL;
static gpointer checkerboard_layout_parent_class = NULL;
static gpointer checkerboard_layout_layout_row_parent_class = NULL;

gpointer checkerboard_item_text_ref (gpointer instance);
void checkerboard_item_text_unref (gpointer instance);
GParamSpec* param_spec_checkerboard_item_text (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_checkerboard_item_text (GValue* value, gpointer v_object);
void value_take_checkerboard_item_text (GValue* value, gpointer v_object);
gpointer value_get_checkerboard_item_text (const GValue* value);
GType checkerboard_item_text_get_type (void) G_GNUC_CONST;
#define CHECKERBOARD_ITEM_TEXT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemTextPrivate))
enum  {
	CHECKERBOARD_ITEM_TEXT_DUMMY_PROPERTY
};
CheckerboardItemText* checkerboard_item_text_new (const gchar* text, PangoAlignment alignment, gboolean marked_up);
CheckerboardItemText* checkerboard_item_text_construct (GType object_type, const gchar* text, PangoAlignment alignment, gboolean marked_up);
static gboolean checkerboard_item_text_is_single_line (CheckerboardItemText* self);
gboolean string_contains_char (const gchar* haystack, gunichar needle);
gboolean checkerboard_item_text_is_marked_up (CheckerboardItemText* self);
gboolean checkerboard_item_text_is_set_to (CheckerboardItemText* self, const gchar* text, gboolean marked_up, PangoAlignment alignment);
gchar* checkerboard_item_text_get_text (CheckerboardItemText* self);
gint checkerboard_item_text_get_height (CheckerboardItemText* self);
static void checkerboard_item_text_update_height (CheckerboardItemText* self);
PangoLayout* checkerboard_item_text_get_pango_layout (CheckerboardItemText* self, gint max_width);
static void checkerboard_item_text_create_pango (CheckerboardItemText* self);
void checkerboard_item_text_clear_pango_layout (CheckerboardItemText* self);
GType page_window_get_type (void) G_GNUC_CONST;
GType app_window_get_type (void) G_GNUC_CONST;
AppWindow* app_window_get_instance (void);
static void checkerboard_item_text_finalize (CheckerboardItemText * obj);
GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_view_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_view_get_type (void) G_GNUC_CONST;
GType checkerboard_item_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType tag_get_type (void) G_GNUC_CONST;
#define CHECKERBOARD_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHECKERBOARD_ITEM, CheckerboardItemPrivate))
enum  {
	CHECKERBOARD_ITEM_DUMMY_PROPERTY,
	CHECKERBOARD_ITEM_HAS_TAGS_PROPERTY
};
void dimensions_init (Dimensions *self, gint width, gint height);
#define CHECKERBOARD_ITEM_PROP_SHOW_TITLES "show-titles"
#define CHECKERBOARD_ITEM_PROP_SHOW_COMMENTS "show-comments"
#define CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES "show-subtitles"
#define CHECKERBOARD_ITEM_FRAME_WIDTH 8
#define CHECKERBOARD_ITEM_LABEL_PADDING 4
#define CHECKERBOARD_ITEM_BORDER_WIDTH 1
#define CHECKERBOARD_ITEM_SHADOW_RADIUS 4
#define CHECKERBOARD_ITEM_SHADOW_INITIAL_ALPHA 0.5f
#define CHECKERBOARD_ITEM_TRINKET_SCALE 12
#define CHECKERBOARD_ITEM_TRINKET_PADDING 1
#define CHECKERBOARD_ITEM_BRIGHTEN_SHIFT 0x18
GType thumbnail_source_get_type (void) G_GNUC_CONST;
CheckerboardItem* checkerboard_item_construct (GType object_type, ThumbnailSource* source, Dimensions* initial_pixbuf_dim, const gchar* title, const gchar* comment, gboolean marked_up, PangoAlignment alignment);
ThumbnailView* thumbnail_view_new (ThumbnailSource* source);
ThumbnailView* thumbnail_view_construct (GType object_type, ThumbnailSource* source);
static gchar* checkerboard_item_real_get_name (DataObject* base);
gchar* data_object_get_name (DataObject* self);
gchar* checkerboard_item_get_title (CheckerboardItem* self);
gchar* checkerboard_item_get_comment (CheckerboardItem* self);
void checkerboard_item_set_title (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment);
static void checkerboard_item_recalc_size (CheckerboardItem* self, const gchar* reason);
void data_view_notify_view_altered (DataView* self);
void checkerboard_item_clear_title (CheckerboardItem* self);
static void checkerboard_item_set_title_visible (CheckerboardItem* self, gboolean visible);
void checkerboard_item_set_comment (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment);
void checkerboard_item_clear_comment (CheckerboardItem* self);
static void checkerboard_item_set_comment_visible (CheckerboardItem* self, gboolean visible);
void checkerboard_item_set_tags (CheckerboardItem* self, GeeCollection* tags, PangoAlignment alignment);
static void checkerboard_item_set_has_tags (CheckerboardItem* self, gboolean value);
gboolean checkerboard_item_get_has_tags (CheckerboardItem* self);
GeeList* tag_make_user_visible_tag_list (GeeCollection* tags);
gchar* tag_make_tag_markup_string (GeeList* tags, gint highlight_index);
void checkerboard_item_clear_tags (CheckerboardItem* self);
void checkerboard_item_clear_subtitle (CheckerboardItem* self);
void checkerboard_item_highlight_user_visible_tag (CheckerboardItem* self, gint index);
Tag* checkerboard_item_get_user_visible_tag (CheckerboardItem* self, gint index);
PangoLayout* checkerboard_item_get_tag_list_layout (CheckerboardItem* self);
void checkerboard_item_get_subtitle_allocation (CheckerboardItem* self, GdkRectangle* result);
gchar* checkerboard_item_get_subtitle (CheckerboardItem* self);
void checkerboard_item_set_subtitle (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment);
static void checkerboard_item_set_subtitle_visible (CheckerboardItem* self, gboolean visible);
void checkerboard_item_set_is_cursor (CheckerboardItem* self, gboolean is_cursor);
gboolean checkerboard_item_get_is_cursor (CheckerboardItem* self);
static void checkerboard_item_real_notify_membership_changed (DataObject* base, DataCollection* collection);
void data_object_get_collection_property (DataObject* self, const gchar* name, GValue* def, GValue* result);
static void _vala_GValue_free (GValue* self);
gboolean dimensions_has_area (Dimensions *self);
void data_object_notify_membership_changed (DataObject* self, DataCollection* collection);
static void checkerboard_item_real_notify_collection_property_set (DataObject* base, const gchar* name, GValue* old, GValue* val);
void data_object_notify_collection_property_set (DataObject* self, const gchar* name, GValue* old, GValue* val);
gint checkerboard_item_get_alignment_point (CheckerboardItem* self);
void checkerboard_item_exposed (CheckerboardItem* self);
static void checkerboard_item_real_exposed (CheckerboardItem* self);
void checkerboard_item_unexposed (CheckerboardItem* self);
static void checkerboard_item_real_unexposed (CheckerboardItem* self);
gboolean checkerboard_item_is_exposed (CheckerboardItem* self);
static gboolean checkerboard_item_real_is_exposed (CheckerboardItem* self);
gboolean checkerboard_item_has_image (CheckerboardItem* self);
GdkPixbuf* checkerboard_item_get_image (CheckerboardItem* self);
void checkerboard_item_set_image (CheckerboardItem* self, GdkPixbuf* pixbuf);
void dimensions_for_pixbuf (GdkPixbuf* pixbuf, Dimensions* result);
void checkerboard_item_clear_image (CheckerboardItem* self, Dimensions* dim);
gint checkerboard_item_get_max_width (gint scale);
gboolean dimensions_approx_equals (Dimensions *self, Dimensions* dim, gint fudge);
void data_view_notify_geometry_altered (DataView* self);
void checkerboard_item_get_border_dimensions (Dimensions* object_dim, gint border_width, Dimensions* result);
void checkerboard_item_get_border_origin (GdkPoint* object_origin, gint border_width, GdkPoint* result);
void checkerboard_item_paint_shadow (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
static void checkerboard_item_real_paint_shadow (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
void checkerboard_item_paint_shadow_in_corner (CheckerboardItem* self, cairo_t* ctx, gint x, gint y, gdouble rgb_all, gfloat radius, gfloat initial_alpha, gdouble arc1, gdouble arc2);
void checkerboard_item_paint_border (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width);
static void checkerboard_item_real_paint_border (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width);
void draw_rounded_corners_filled (cairo_t* ctx, Dimensions* dim, GdkPoint* origin, gdouble radius_proportion);
void checkerboard_item_paint_image (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin);
static void checkerboard_item_real_paint_image (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin);
void paint_pixmap_with_background (cairo_t* ctx, GdkPixbuf* pixbuf, gint x, gint y);
static gint checkerboard_item_get_selection_border_width (CheckerboardItem* self, gint scale);
gint thumbnail_get_MIN_SCALE (void);
gint thumbnail_get_MAX_SCALE (void);
GdkPixbuf* checkerboard_item_get_top_left_trinket (CheckerboardItem* self, gint scale);
static GdkPixbuf* checkerboard_item_real_get_top_left_trinket (CheckerboardItem* self, gint scale);
GdkPixbuf* checkerboard_item_get_top_right_trinket (CheckerboardItem* self, gint scale);
static GdkPixbuf* checkerboard_item_real_get_top_right_trinket (CheckerboardItem* self, gint scale);
GdkPixbuf* checkerboard_item_get_bottom_left_trinket (CheckerboardItem* self, gint scale);
static GdkPixbuf* checkerboard_item_real_get_bottom_left_trinket (CheckerboardItem* self, gint scale);
GdkPixbuf* checkerboard_item_get_bottom_right_trinket (CheckerboardItem* self, gint scale);
static GdkPixbuf* checkerboard_item_real_get_bottom_right_trinket (CheckerboardItem* self, gint scale);
void checkerboard_item_paint (CheckerboardItem* self, cairo_t* ctx, GdkRGBA* bg_color, GdkRGBA* selected_color, GdkRGBA* text_color, GdkRGBA* border_color);
gboolean data_view_is_selected (DataView* self);
gint checkerboard_item_get_horizontal_trinket_offset (CheckerboardItem* self);
void checkerboard_item_set_horizontal_trinket_offset (CheckerboardItem* self, gint horizontal_trinket_offset);
void checkerboard_item_set_grid_coordinates (CheckerboardItem* self, gint col, gint row);
gint checkerboard_item_get_column (CheckerboardItem* self);
gint checkerboard_item_get_row (CheckerboardItem* self);
void checkerboard_item_brighten (CheckerboardItem* self);
void shift_colors (GdkPixbuf* pixbuf, gint red, gint green, gint blue, gint alpha);
void checkerboard_item_unbrighten (CheckerboardItem* self);
static void checkerboard_item_real_visibility_changed (DataView* base, gboolean visible);
static gboolean checkerboard_item_query_tooltip_on_text (CheckerboardItem* self, CheckerboardItemText* text, GtkTooltip* tooltip);
gboolean checkerboard_item_query_tooltip (CheckerboardItem* self, gint x, gint y, GtkTooltip* tooltip);
gboolean coord_in_rectangle (gint x, gint y, GdkRectangle* rect);
static void checkerboard_item_finalize (GObject * obj);
static void _vala_checkerboard_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_checkerboard_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType checkerboard_layout_get_type (void) G_GNUC_CONST;
GType view_collection_get_type (void) G_GNUC_CONST;
static gpointer checkerboard_layout_layout_row_ref (gpointer instance);
static void checkerboard_layout_layout_row_unref (gpointer instance);
static GParamSpec* checkerboard_layout_param_spec_layout_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void checkerboard_layout_value_set_layout_row (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void checkerboard_layout_value_take_layout_row (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer checkerboard_layout_value_get_layout_row (const GValue* value) G_GNUC_UNUSED;
static GType checkerboard_layout_layout_row_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define CHECKERBOARD_LAYOUT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayoutPrivate))
enum  {
	CHECKERBOARD_LAYOUT_DUMMY_PROPERTY
};
static void checkerboard_layout_on_contents_altered (CheckerboardLayout* self, GeeIterable* added, GeeIterable* removed);
static void _checkerboard_layout_on_contents_altered_data_collection_contents_altered (DataCollection* _sender, GeeIterable* added, GeeIterable* removed, gpointer self);
static void checkerboard_layout_on_items_altered (CheckerboardLayout* self);
static void _checkerboard_layout_on_items_altered_data_collection_items_altered (DataCollection* _sender, GeeMap* items, gpointer self);
static void checkerboard_layout_on_items_state_changed (CheckerboardLayout* self, GeeIterable* changed);
static void _checkerboard_layout_on_items_state_changed_view_collection_items_state_changed (ViewCollection* _sender, GeeIterable* changed, gpointer self);
static void checkerboard_layout_on_items_visibility_changed (CheckerboardLayout* self, GeeIterable* changed);
static void _checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed (ViewCollection* _sender, GeeCollection* changed, gpointer self);
static void checkerboard_layout_on_ordering_changed (CheckerboardLayout* self);
static void _checkerboard_layout_on_ordering_changed_data_collection_ordering_changed (DataCollection* _sender, gpointer self);
static void checkerboard_layout_on_views_altered (CheckerboardLayout* self, GeeCollection* altered);
static void _checkerboard_layout_on_views_altered_view_collection_views_altered (ViewCollection* _sender, GeeCollection* views, gpointer self);
static void checkerboard_layout_on_geometries_altered (CheckerboardLayout* self);
static void _checkerboard_layout_on_geometries_altered_view_collection_geometries_altered (ViewCollection* _sender, GeeCollection* views, gpointer self);
static void checkerboard_layout_on_items_selection_changed (CheckerboardLayout* self);
static void _checkerboard_layout_on_items_selection_changed_view_collection_items_selected (ViewCollection* _sender, GeeIterable* selected, gpointer self);
static void _checkerboard_layout_on_items_selection_changed_view_collection_items_unselected (ViewCollection* _sender, GeeIterable* unselected, gpointer self);
static void checkerboard_layout_on_viewport_shifted (CheckerboardLayout* self);
static void _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
static void checkerboard_layout_on_viewport_resized (CheckerboardLayout* self);
static void _checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
static void checkerboard_layout_on_colors_changed (CheckerboardLayout* self);
static void _checkerboard_layout_on_colors_changed_config_facade_colors_changed (ConfigFacade* _sender, gpointer self);
#define CHECKERBOARD_LAYOUT_TOP_PADDING 16
#define CHECKERBOARD_LAYOUT_BOTTOM_PADDING 16
#define CHECKERBOARD_LAYOUT_ROW_GUTTER_PADDING 24
#define CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING 24
#define CHECKERBOARD_LAYOUT_SELECTION_ALPHA 0.40
#define CHECKERBOARD_LAYOUT_SCROLLBAR_PLACEHOLDER_WIDTH 1
CheckerboardLayout* checkerboard_layout_new (ViewCollection* view);
CheckerboardLayout* checkerboard_layout_construct (GType object_type, ViewCollection* view);
void checkerboard_layout_clear_drag_select (CheckerboardLayout* self);
void config_facade_get_bg_color (ConfigFacade* self, GdkRGBA* result);
void checkerboard_layout_set_adjustments (CheckerboardLayout* self, GtkAdjustment* hadjustment, GtkAdjustment* vadjustment);
void checkerboard_layout_set_scale (CheckerboardLayout* self, gint scale);
gint checkerboard_layout_get_scale (CheckerboardLayout* self);
void checkerboard_layout_set_name (CheckerboardLayout* self, const gchar* name);
static void checkerboard_layout_viewport_resized (CheckerboardLayout* self);
static void checkerboard_layout_clear_anchor (CheckerboardLayout* self);
static void checkerboard_layout_update_visible_page (CheckerboardLayout* self);
static void checkerboard_layout_need_exposure (CheckerboardLayout* self, const gchar* caller);
static void checkerboard_layout_update_anchor (CheckerboardLayout* self);
GeeList* checkerboard_layout_intersection (CheckerboardLayout* self, GdkRectangle* area);
static void checkerboard_layout_center_on_anchor (CheckerboardLayout* self, gdouble upper);
void checkerboard_layout_set_cursor (CheckerboardLayout* self, CheckerboardItem* item);
gboolean data_collection_contains (DataCollection* self, DataObject* object);
CheckerboardItem* checkerboard_layout_get_cursor (CheckerboardLayout* self);
static void checkerboard_layout_need_reflow (CheckerboardLayout* self, const gchar* caller);
static void checkerboard_layout_items_dirty (CheckerboardLayout* self, const gchar* reason, GeeIterable* items);
static gboolean checkerboard_layout_do_reflow (CheckerboardLayout* self);
static gboolean _checkerboard_layout_do_reflow_gsource_func (gpointer self);
static void checkerboard_layout_reflow (CheckerboardLayout* self, const gchar* caller);
void checkerboard_layout_set_message (CheckerboardLayout* self, const gchar* text);
void checkerboard_layout_unset_message (CheckerboardLayout* self);
void get_adjustment_page (GtkAdjustment* hadj, GtkAdjustment* vadj, GdkRectangle* result);
void checkerboard_layout_set_in_view (CheckerboardLayout* self, gboolean in_view);
static void checkerboard_layout_unexpose_items (CheckerboardLayout* self, const gchar* caller);
CheckerboardItem* checkerboard_layout_get_item_at_pixel (CheckerboardLayout* self, gdouble xd, gdouble yd);
gint checkerboard_layout_get_tag_index_at_pos (const gchar* tag_list, gint pos);
#define TAG_TAG_LIST_SEPARATOR_STRING ", "
static gint checkerboard_layout_internal_handle_tag_mouse_event (CheckerboardLayout* self, CheckerboardItem* item, gint x, gint y);
gboolean checkerboard_layout_handle_mouse_motion (CheckerboardLayout* self, CheckerboardItem* item, gint x, gint y, GdkModifierType mask);
gboolean checkerboard_layout_is_drag_select_active (CheckerboardLayout* self);
gboolean checkerboard_layout_handle_left_click (CheckerboardLayout* self, CheckerboardItem* item, gdouble xd, gdouble yd, GdkModifierType mask);
GType library_window_get_type (void) G_GNUC_CONST;
LibraryWindow* library_window_get_app (void);
void library_window_switch_to_tag (LibraryWindow* self, Tag* tag);
GeeList* checkerboard_layout_get_visible_items (CheckerboardLayout* self);
GType compass_point_get_type (void) G_GNUC_CONST;
CheckerboardItem* checkerboard_layout_get_item_relative_to (CheckerboardLayout* self, CheckerboardItem* item, CompassPoint point);
gint data_collection_get_count (DataCollection* self);
CheckerboardItem* checkerboard_layout_get_item_at_coordinate (CheckerboardLayout* self, gint col, gint row);
DataView* view_collection_get_last (ViewCollection* self);
void checkerboard_layout_set_drag_select_origin (CheckerboardLayout* self, gint x, gint y);
void checkerboard_layout_set_drag_select_endpoint (CheckerboardLayout* self, gint x, gint y);
GType box_get_type (void) G_GNUC_CONST;
Box* box_dup (const Box* self);
void box_free (Box* self);
void box_from_points (GdkPoint* corner1, GdkPoint* corner2, Box* result);
void box_get_rectangle (Box *self, GdkRectangle* result);
GeeList* checkerboard_layout_items_in_selection_band (CheckerboardLayout* self);
void dimensions_for_rectangle (GdkRectangle* rect, Dimensions* result);
static void checkerboard_layout_expose_items (CheckerboardLayout* self, const gchar* caller);
void data_collection_freeze_notifications (DataCollection* self);
void data_collection_thaw_notifications (DataCollection* self);
gboolean data_view_is_visible (DataView* self);
DataObject* data_collection_get_at (DataCollection* self, gint index);
static CheckerboardLayoutLayoutRow* checkerboard_layout_layout_row_new (gint y, gint height, gint num_in_row);
static CheckerboardLayoutLayoutRow* checkerboard_layout_layout_row_construct (GType object_type, gint y, gint height, gint num_in_row);
static void checkerboard_layout_real_map (GtkWidget* base);
static void checkerboard_layout_set_colors (CheckerboardLayout* self, gboolean in_focus);
void config_facade_get_selected_color (ConfigFacade* self, gboolean in_focus, GdkRGBA* result);
void config_facade_get_unselected_color (ConfigFacade* self, GdkRGBA* result);
void config_facade_get_border_color (ConfigFacade* self, GdkRGBA* result);
static void checkerboard_layout_real_size_allocate (GtkWidget* base, GtkAllocation* allocation);
static gboolean checkerboard_layout_real_draw (GtkWidget* base, cairo_t* ctx);
static void checkerboard_layout_draw_selection_band (CheckerboardLayout* self, cairo_t* ctx);
static gboolean checkerboard_layout_real_query_tooltip (GtkWidget* base, gint x, gint y, gboolean keyboard_mode, GtkTooltip* tooltip);
void invalidate_transparent_background (void);
static gboolean checkerboard_layout_real_focus_in_event (GtkWidget* base, GdkEventFocus* event);
GeeList* view_collection_get_selected (ViewCollection* self);
static gboolean checkerboard_layout_real_focus_out_event (GtkWidget* base, GdkEventFocus* event);
enum  {
	CHECKERBOARD_LAYOUT_LAYOUT_ROW_DUMMY_PROPERTY
};
static void checkerboard_layout_layout_row_finalize (CheckerboardLayoutLayoutRow * obj);
static void checkerboard_layout_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


CheckerboardItemText* checkerboard_item_text_construct (GType object_type, const gchar* text, PangoAlignment alignment, gboolean marked_up) {
	CheckerboardItemText* self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	PangoAlignment _tmp3_;
	gboolean _tmp4_;
#line 19 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 19 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = (CheckerboardItemText*) g_type_create_instance (object_type);
#line 21 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = text;
#line 21 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 21 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->text);
#line 21 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->text = _tmp1_;
#line 22 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = marked_up;
#line 22 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->marked_up = _tmp2_;
#line 23 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = alignment;
#line 23 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->alignment = _tmp3_;
#line 25 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = checkerboard_item_text_is_single_line (self);
#line 25 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->single_line = _tmp4_;
#line 19 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self;
#line 756 "CheckerboardLayout.c"
}


CheckerboardItemText* checkerboard_item_text_new (const gchar* text, PangoAlignment alignment, gboolean marked_up) {
#line 19 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return checkerboard_item_text_construct (TYPE_CHECKERBOARD_ITEM_TEXT, text, alignment, marked_up);
#line 763 "CheckerboardLayout.c"
}


static gboolean checkerboard_item_text_is_single_line (CheckerboardItemText* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_;
#line 28 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), FALSE);
#line 29 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->text;
#line 29 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = string_contains_char (_tmp0_, (gunichar) '\n');
#line 29 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = !_tmp1_;
#line 29 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 781 "CheckerboardLayout.c"
}


gboolean checkerboard_item_text_is_marked_up (CheckerboardItemText* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 32 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), FALSE);
#line 33 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->marked_up;
#line 33 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 33 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 796 "CheckerboardLayout.c"
}


gboolean checkerboard_item_text_is_set_to (CheckerboardItemText* self, const gchar* text, gboolean marked_up, PangoAlignment alignment) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
#line 36 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), FALSE);
#line 36 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (text != NULL, FALSE);
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->marked_up;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = marked_up;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ == _tmp3_) {
#line 816 "CheckerboardLayout.c"
		PangoAlignment _tmp4_;
		PangoAlignment _tmp5_;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->alignment;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = alignment;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = _tmp4_ == _tmp5_;
#line 825 "CheckerboardLayout.c"
	} else {
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = FALSE;
#line 829 "CheckerboardLayout.c"
	}
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 833 "CheckerboardLayout.c"
		const gchar* _tmp6_;
		const gchar* _tmp7_;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = self->priv->text;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = text;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = g_strcmp0 (_tmp6_, _tmp7_) == 0;
#line 842 "CheckerboardLayout.c"
	} else {
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 846 "CheckerboardLayout.c"
	}
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 852 "CheckerboardLayout.c"
}


gchar* checkerboard_item_text_get_text (CheckerboardItemText* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 40 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), NULL);
#line 41 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->text;
#line 41 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 41 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp1_;
#line 41 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 870 "CheckerboardLayout.c"
}


gint checkerboard_item_text_get_height (CheckerboardItemText* self) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
#line 44 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), 0);
#line 45 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->height;
#line 45 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == 0) {
#line 46 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_update_height (self);
#line 886 "CheckerboardLayout.c"
	}
#line 48 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->height;
#line 48 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp1_;
#line 48 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 894 "CheckerboardLayout.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 58 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self ? g_object_ref (self) : NULL;
#line 901 "CheckerboardLayout.c"
}


PangoLayout* checkerboard_item_text_get_pango_layout (CheckerboardItemText* self, gint max_width) {
	PangoLayout* result = NULL;
	PangoLayout* _tmp0_;
	gint _tmp1_;
	PangoLayout* _tmp4_;
	PangoLayout* _tmp5_;
#line 51 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), NULL);
#line 52 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->layout;
#line 52 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == NULL) {
#line 53 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_create_pango (self);
#line 919 "CheckerboardLayout.c"
	}
#line 55 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = max_width;
#line 55 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ > 0) {
#line 925 "CheckerboardLayout.c"
		PangoLayout* _tmp2_;
		gint _tmp3_;
#line 56 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->layout;
#line 56 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = max_width;
#line 56 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout_set_width (_tmp2_, _tmp3_ * PANGO_SCALE);
#line 934 "CheckerboardLayout.c"
	}
#line 58 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = self->priv->layout;
#line 58 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 58 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp5_;
#line 58 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 944 "CheckerboardLayout.c"
}


void checkerboard_item_text_clear_pango_layout (CheckerboardItemText* self) {
#line 61 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self));
#line 62 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->layout);
#line 62 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->layout = NULL;
#line 955 "CheckerboardLayout.c"
}


static void checkerboard_item_text_update_height (CheckerboardItemText* self) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
#line 65 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self));
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = checkerboard_item_text_one_line_height;
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != 0) {
#line 968 "CheckerboardLayout.c"
		gboolean _tmp2_;
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->single_line;
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp2_;
#line 974 "CheckerboardLayout.c"
	} else {
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 978 "CheckerboardLayout.c"
	}
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 982 "CheckerboardLayout.c"
		gint _tmp3_;
#line 67 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_one_line_height;
#line 67 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->height = _tmp3_;
#line 988 "CheckerboardLayout.c"
	} else {
#line 69 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_create_pango (self);
#line 992 "CheckerboardLayout.c"
	}
}


static void checkerboard_item_text_create_pango (CheckerboardItemText* self) {
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	PangoLayout* _tmp2_;
	gboolean _tmp3_;
	PangoLayout* _tmp8_;
	PangoLayout* _tmp9_;
	PangoAlignment _tmp10_;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_;
#line 72 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self));
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = app_window_get_instance ();
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_;
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = gtk_widget_create_pango_layout (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), NULL);
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->layout);
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->layout = _tmp2_;
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp1_);
#line 75 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->marked_up;
#line 75 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp3_) {
#line 1025 "CheckerboardLayout.c"
		PangoLayout* _tmp4_;
		const gchar* _tmp5_;
#line 76 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->layout;
#line 76 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = self->priv->text;
#line 76 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout_set_text (_tmp4_, _tmp5_, -1);
#line 1034 "CheckerboardLayout.c"
	} else {
		PangoLayout* _tmp6_;
		const gchar* _tmp7_;
#line 78 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = self->priv->layout;
#line 78 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = self->priv->text;
#line 78 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout_set_markup (_tmp6_, _tmp7_, -1);
#line 1044 "CheckerboardLayout.c"
	}
#line 80 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = self->priv->layout;
#line 80 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	pango_layout_set_ellipsize (_tmp8_, PANGO_ELLIPSIZE_END);
#line 81 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->layout;
#line 81 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = self->priv->alignment;
#line 81 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	pango_layout_set_alignment (_tmp9_, _tmp10_);
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = checkerboard_item_text_one_line_height;
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp12_ != 0) {
#line 1060 "CheckerboardLayout.c"
		gboolean _tmp13_;
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = self->priv->single_line;
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = _tmp13_;
#line 1066 "CheckerboardLayout.c"
	} else {
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = FALSE;
#line 1070 "CheckerboardLayout.c"
	}
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp11_) {
#line 1074 "CheckerboardLayout.c"
		gint _tmp14_;
#line 86 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = checkerboard_item_text_one_line_height;
#line 86 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->height = _tmp14_;
#line 1080 "CheckerboardLayout.c"
	} else {
		gint width = 0;
		PangoLayout* _tmp15_;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gboolean _tmp18_ = FALSE;
		gint _tmp19_;
#line 89 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = self->priv->layout;
#line 89 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout_get_pixel_size (_tmp15_, &_tmp16_, &_tmp17_);
#line 89 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		width = _tmp16_;
#line 89 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->height = _tmp17_;
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = checkerboard_item_text_one_line_height;
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp19_ == 0) {
#line 1100 "CheckerboardLayout.c"
			gboolean _tmp20_;
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp20_ = self->priv->single_line;
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp18_ = _tmp20_;
#line 1106 "CheckerboardLayout.c"
		} else {
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp18_ = FALSE;
#line 1110 "CheckerboardLayout.c"
		}
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp18_) {
#line 1114 "CheckerboardLayout.c"
			gint _tmp21_;
#line 93 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp21_ = self->priv->height;
#line 93 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_item_text_one_line_height = _tmp21_;
#line 1120 "CheckerboardLayout.c"
		}
	}
}


static void value_checkerboard_item_text_init (GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	value->data[0].v_pointer = NULL;
#line 1129 "CheckerboardLayout.c"
}


static void value_checkerboard_item_text_free_value (GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_unref (value->data[0].v_pointer);
#line 1138 "CheckerboardLayout.c"
	}
}


static void value_checkerboard_item_text_copy_value (const GValue* src_value, GValue* dest_value) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (src_value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dest_value->data[0].v_pointer = checkerboard_item_text_ref (src_value->data[0].v_pointer);
#line 1148 "CheckerboardLayout.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1152 "CheckerboardLayout.c"
	}
}


static gpointer value_checkerboard_item_text_peek_pointer (const GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return value->data[0].v_pointer;
#line 1160 "CheckerboardLayout.c"
}


static gchar* value_checkerboard_item_text_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (collect_values[0].v_pointer) {
#line 1167 "CheckerboardLayout.c"
		CheckerboardItemText * object;
		object = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (object->parent_instance.g_class == NULL) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1174 "CheckerboardLayout.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1178 "CheckerboardLayout.c"
		}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = checkerboard_item_text_ref (object);
#line 1182 "CheckerboardLayout.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 1186 "CheckerboardLayout.c"
	}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return NULL;
#line 1190 "CheckerboardLayout.c"
}


static gchar* value_checkerboard_item_text_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	CheckerboardItemText ** object_p;
	object_p = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!object_p) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1201 "CheckerboardLayout.c"
	}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = NULL;
#line 1207 "CheckerboardLayout.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = value->data[0].v_pointer;
#line 1211 "CheckerboardLayout.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = checkerboard_item_text_ref (value->data[0].v_pointer);
#line 1215 "CheckerboardLayout.c"
	}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return NULL;
#line 1219 "CheckerboardLayout.c"
}


GParamSpec* param_spec_checkerboard_item_text (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecCheckerboardItemText* spec;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CHECKERBOARD_ITEM_TEXT), NULL);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return G_PARAM_SPEC (spec);
#line 1233 "CheckerboardLayout.c"
}


gpointer value_get_checkerboard_item_text (const GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHECKERBOARD_ITEM_TEXT), NULL);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return value->data[0].v_pointer;
#line 1242 "CheckerboardLayout.c"
}


void value_set_checkerboard_item_text (GValue* value, gpointer v_object) {
	CheckerboardItemText * old;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHECKERBOARD_ITEM_TEXT));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHECKERBOARD_ITEM_TEXT));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = v_object;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_ref (value->data[0].v_pointer);
#line 1262 "CheckerboardLayout.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 1266 "CheckerboardLayout.c"
	}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_unref (old);
#line 1272 "CheckerboardLayout.c"
	}
}


void value_take_checkerboard_item_text (GValue* value, gpointer v_object) {
	CheckerboardItemText * old;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHECKERBOARD_ITEM_TEXT));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHECKERBOARD_ITEM_TEXT));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = v_object;
#line 1291 "CheckerboardLayout.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 1295 "CheckerboardLayout.c"
	}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_unref (old);
#line 1301 "CheckerboardLayout.c"
	}
}


static void checkerboard_item_text_class_init (CheckerboardItemTextClass * klass) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_text_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemTextClass *) klass)->finalize = checkerboard_item_text_finalize;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_type_class_add_private (klass, sizeof (CheckerboardItemTextPrivate));
#line 1313 "CheckerboardLayout.c"
}


static void checkerboard_item_text_instance_init (CheckerboardItemText * self) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv = CHECKERBOARD_ITEM_TEXT_GET_PRIVATE (self);
#line 13 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->layout = NULL;
#line 14 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->single_line = TRUE;
#line 15 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->height = 0;
#line 17 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->allocation, 0, sizeof (GdkRectangle));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->ref_count = 1;
#line 1330 "CheckerboardLayout.c"
}


static void checkerboard_item_text_finalize (CheckerboardItemText * obj) {
	CheckerboardItemText * self;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemText);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_destroy (self);
#line 10 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->text);
#line 13 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->layout);
#line 1344 "CheckerboardLayout.c"
}


GType checkerboard_item_text_get_type (void) {
	static volatile gsize checkerboard_item_text_type_id__volatile = 0;
	if (g_once_init_enter (&checkerboard_item_text_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_checkerboard_item_text_init, value_checkerboard_item_text_free_value, value_checkerboard_item_text_copy_value, value_checkerboard_item_text_peek_pointer, "p", value_checkerboard_item_text_collect_value, "p", value_checkerboard_item_text_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (CheckerboardItemTextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) checkerboard_item_text_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckerboardItemText), 0, (GInstanceInitFunc) checkerboard_item_text_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType checkerboard_item_text_type_id;
		checkerboard_item_text_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CheckerboardItemText", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&checkerboard_item_text_type_id__volatile, checkerboard_item_text_type_id);
	}
	return checkerboard_item_text_type_id__volatile;
}


gpointer checkerboard_item_text_ref (gpointer instance) {
	CheckerboardItemText * self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_atomic_int_inc (&self->ref_count);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return instance;
#line 1369 "CheckerboardLayout.c"
}


void checkerboard_item_text_unref (gpointer instance) {
	CheckerboardItemText * self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		CHECKERBOARD_ITEM_TEXT_GET_CLASS (self)->finalize (self);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1382 "CheckerboardLayout.c"
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1407 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1407 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1407 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1408 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1408 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 1402 "CheckerboardLayout.c"
	} else {
		const gchar* _tmp2_;
#line 1408 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp2_ = old;
#line 1408 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
#line 1409 "CheckerboardLayout.c"
	}
#line 1408 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 1408 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 1415 "CheckerboardLayout.c"
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
#line 1408 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp3_ = old;
#line 1408 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = replacement;
#line 1408 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
#line 1425 "CheckerboardLayout.c"
	}
#line 1408 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 1429 "CheckerboardLayout.c"
		gchar* _tmp5_;
#line 1409 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp5_ = g_strdup (self);
#line 1409 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = _tmp5_;
#line 1409 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 1437 "CheckerboardLayout.c"
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = old;
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp10_ = _tmp9_;
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_g_free0 (_tmp8_);
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		regex = _tmp10_;
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1469 "CheckerboardLayout.c"
				goto __catch249_g_regex_error;
			}
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1412 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			return NULL;
#line 1478 "CheckerboardLayout.c"
		}
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp12_ = regex;
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp13_ = replacement;
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp11_ = _tmp14_;
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1494 "CheckerboardLayout.c"
				goto __catch249_g_regex_error;
			}
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			return NULL;
#line 1505 "CheckerboardLayout.c"
		}
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp15_ = _tmp11_;
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp11_ = NULL;
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = _tmp15_;
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_g_free0 (_tmp11_);
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1413 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 1519 "CheckerboardLayout.c"
	}
	goto __finally249;
	__catch249_g_regex_error:
	{
		GError* e = NULL;
#line 1411 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1411 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1415 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1411 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 1533 "CheckerboardLayout.c"
	}
	__finally249:
#line 1411 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1411 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1411 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1411 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return NULL;
#line 1544 "CheckerboardLayout.c"
	}
}


CheckerboardItem* checkerboard_item_construct (GType object_type, ThumbnailSource* source, Dimensions* initial_pixbuf_dim, const gchar* title, const gchar* comment, gboolean marked_up, PangoAlignment alignment) {
	CheckerboardItem * self = NULL;
	ThumbnailSource* _tmp0_;
	Dimensions _tmp1_;
	const gchar* _tmp2_;
	PangoAlignment _tmp3_;
	gboolean _tmp4_;
	CheckerboardItemText* _tmp5_;
	const gchar* _tmp6_;
#line 141 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (source), NULL);
#line 141 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (initial_pixbuf_dim != NULL, NULL);
#line 141 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 143 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = source;
#line 143 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = (CheckerboardItem*) thumbnail_view_construct (object_type, _tmp0_);
#line 145 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = *initial_pixbuf_dim;
#line 145 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf_dim = _tmp1_;
#line 146 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = title;
#line 146 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = alignment;
#line 146 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = marked_up;
#line 146 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = checkerboard_item_text_new (_tmp2_, _tmp3_, _tmp4_);
#line 146 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->title);
#line 146 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title = _tmp5_;
#line 152 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = comment;
#line 152 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp6_ != NULL) {
#line 1588 "CheckerboardLayout.c"
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		PangoAlignment _tmp10_;
		gboolean _tmp11_;
		CheckerboardItemText* _tmp12_;
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = comment;
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = string_replace (_tmp7_, "\n", " ");
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = _tmp8_;
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = alignment;
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = marked_up;
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = checkerboard_item_text_new (_tmp9_, _tmp10_, _tmp11_);
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_checkerboard_item_text_unref0 (self->priv->comment);
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->comment = _tmp12_;
#line 153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp9_);
#line 1613 "CheckerboardLayout.c"
	}
#line 141 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self;
#line 1617 "CheckerboardLayout.c"
}


static gchar* checkerboard_item_real_get_name (DataObject* base) {
	CheckerboardItem * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_;
#line 163 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->title;
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1632 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_;
		gchar* _tmp3_;
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->title;
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp3_;
#line 1643 "CheckerboardLayout.c"
	} else {
		gchar* _tmp4_;
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = DATA_OBJECT_CLASS (checkerboard_item_parent_class)->get_name (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView), TYPE_DATA_OBJECT, DataObject));
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_;
#line 1652 "CheckerboardLayout.c"
	}
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 164 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 1658 "CheckerboardLayout.c"
}


gchar* checkerboard_item_get_title (CheckerboardItem* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_;
#line 167 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->title;
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1672 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_;
		gchar* _tmp3_;
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->title;
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp3_;
#line 1683 "CheckerboardLayout.c"
	} else {
		gchar* _tmp4_;
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = g_strdup ("");
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_;
#line 1692 "CheckerboardLayout.c"
	}
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 1698 "CheckerboardLayout.c"
}


gchar* checkerboard_item_get_comment (CheckerboardItem* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_;
#line 171 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->comment;
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1712 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_;
		gchar* _tmp3_;
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->comment;
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp3_;
#line 1723 "CheckerboardLayout.c"
	} else {
		gchar* _tmp4_;
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = g_strdup ("");
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_;
#line 1732 "CheckerboardLayout.c"
	}
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 1738 "CheckerboardLayout.c"
}


void checkerboard_item_set_title (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment) {
	gboolean _tmp0_ = FALSE;
	CheckerboardItemText* _tmp1_;
	const gchar* _tmp7_;
	PangoAlignment _tmp8_;
	gboolean _tmp9_;
	CheckerboardItemText* _tmp10_;
	gboolean _tmp11_;
#line 175 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 175 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (text != NULL);
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->title;
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1758 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_;
		const gchar* _tmp3_;
		gboolean _tmp4_;
		PangoAlignment _tmp5_;
		gboolean _tmp6_;
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->title;
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = text;
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = marked_up;
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = alignment;
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = checkerboard_item_text_is_set_to (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp6_;
#line 1776 "CheckerboardLayout.c"
	} else {
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 1780 "CheckerboardLayout.c"
	}
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 1786 "CheckerboardLayout.c"
	}
#line 180 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = text;
#line 180 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = alignment;
#line 180 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = marked_up;
#line 180 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = checkerboard_item_text_new (_tmp7_, _tmp8_, _tmp9_);
#line 180 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->title);
#line 180 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title = _tmp10_;
#line 182 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = self->priv->title_visible;
#line 182 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp11_) {
#line 183 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "set_title");
#line 184 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 1808 "CheckerboardLayout.c"
	}
}


void checkerboard_item_clear_title (CheckerboardItem* self) {
	CheckerboardItemText* _tmp0_;
	gboolean _tmp1_;
#line 188 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 189 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->title;
#line 189 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == NULL) {
#line 190 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 1824 "CheckerboardLayout.c"
	}
#line 192 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->title);
#line 192 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title = NULL;
#line 194 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->title_visible;
#line 194 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 195 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "clear_title");
#line 196 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 1838 "CheckerboardLayout.c"
	}
}


static void checkerboard_item_set_title_visible (CheckerboardItem* self, gboolean visible) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 200 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 201 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->title_visible;
#line 201 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = visible;
#line 201 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == _tmp1_) {
#line 202 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 1857 "CheckerboardLayout.c"
	}
#line 204 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = visible;
#line 204 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title_visible = _tmp2_;
#line 206 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_recalc_size (self, "set_title_visible");
#line 207 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 1867 "CheckerboardLayout.c"
}


void checkerboard_item_set_comment (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment) {
	gboolean _tmp0_ = FALSE;
	CheckerboardItemText* _tmp1_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	PangoAlignment _tmp10_;
	gboolean _tmp11_;
	CheckerboardItemText* _tmp12_;
	gboolean _tmp13_;
#line 210 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 210 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (text != NULL);
#line 212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->comment;
#line 212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1889 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_;
		const gchar* _tmp3_;
		gboolean _tmp4_;
		PangoAlignment _tmp5_;
		gboolean _tmp6_;
#line 212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->comment;
#line 212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = text;
#line 212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = marked_up;
#line 212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = alignment;
#line 212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = checkerboard_item_text_is_set_to (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp6_;
#line 1907 "CheckerboardLayout.c"
	} else {
#line 212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 1911 "CheckerboardLayout.c"
	}
#line 212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 213 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 1917 "CheckerboardLayout.c"
	}
#line 215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = text;
#line 215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = string_replace (_tmp7_, "\n", " ");
#line 215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = _tmp8_;
#line 215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = alignment;
#line 215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = marked_up;
#line 215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = checkerboard_item_text_new (_tmp9_, _tmp10_, _tmp11_);
#line 215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->comment);
#line 215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->comment = _tmp12_;
#line 215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (_tmp9_);
#line 217 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = self->priv->comment_visible;
#line 217 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp13_) {
#line 218 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "set_comment");
#line 219 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 1945 "CheckerboardLayout.c"
	}
}


void checkerboard_item_clear_comment (CheckerboardItem* self) {
	CheckerboardItemText* _tmp0_;
	gboolean _tmp1_;
#line 223 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 224 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->comment;
#line 224 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == NULL) {
#line 225 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 1961 "CheckerboardLayout.c"
	}
#line 227 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->comment);
#line 227 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->comment = NULL;
#line 229 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->comment_visible;
#line 229 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 230 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "clear_comment");
#line 231 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 1975 "CheckerboardLayout.c"
	}
}


static void checkerboard_item_set_comment_visible (CheckerboardItem* self, gboolean visible) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 235 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 236 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->comment_visible;
#line 236 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = visible;
#line 236 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == _tmp1_) {
#line 237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 1994 "CheckerboardLayout.c"
	}
#line 239 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = visible;
#line 239 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->comment_visible = _tmp2_;
#line 241 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_recalc_size (self, "set_comment_visible");
#line 242 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2004 "CheckerboardLayout.c"
}


void checkerboard_item_set_tags (CheckerboardItem* self, GeeCollection* tags, PangoAlignment alignment) {
	gboolean _tmp0_ = FALSE;
	GeeCollection* _tmp1_;
	PangoAlignment _tmp5_;
	gchar* text = NULL;
	gboolean _tmp6_;
	gboolean _tmp14_ = FALSE;
	CheckerboardItemText* _tmp15_;
	const gchar* _tmp20_;
	PangoAlignment _tmp21_;
	CheckerboardItemText* _tmp22_;
	gboolean _tmp23_;
#line 245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail ((tags == NULL) || GEE_IS_COLLECTION (tags));
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = tags;
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 2028 "CheckerboardLayout.c"
		GeeCollection* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = tags;
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = gee_collection_get_size (_tmp2_);
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = _tmp3_;
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_ > 0;
#line 2040 "CheckerboardLayout.c"
	} else {
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 2044 "CheckerboardLayout.c"
	}
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_set_has_tags (self, _tmp0_);
#line 248 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = alignment;
#line 248 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->tag_alignment = _tmp5_;
#line 250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = self->priv->_has_tags;
#line 250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp6_) {
#line 2056 "CheckerboardLayout.c"
		GeeCollection* _tmp7_;
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
		GeeList* _tmp10_;
		GeeList* _tmp11_;
		gchar* _tmp12_;
#line 251 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = tags;
#line 251 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 251 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (self->priv->tags);
#line 251 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->tags = _tmp8_;
#line 252 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = tags;
#line 252 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = tag_make_user_visible_tag_list (_tmp9_);
#line 252 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (self->priv->user_visible_tag_list);
#line 252 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->user_visible_tag_list = _tmp10_;
#line 253 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = self->priv->user_visible_tag_list;
#line 253 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = tag_make_tag_markup_string (_tmp11_, -1);
#line 253 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (text);
#line 253 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		text = _tmp12_;
#line 2087 "CheckerboardLayout.c"
	} else {
		gchar* _tmp13_;
#line 255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = g_strdup ("<small>.</small>");
#line 255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (text);
#line 255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		text = _tmp13_;
#line 2096 "CheckerboardLayout.c"
	}
#line 258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = self->priv->subtitle;
#line 258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp15_ != NULL) {
#line 2102 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp16_;
		const gchar* _tmp17_;
		PangoAlignment _tmp18_;
		gboolean _tmp19_;
#line 258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp16_ = self->priv->subtitle;
#line 258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = text;
#line 258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = alignment;
#line 258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = checkerboard_item_text_is_set_to (_tmp16_, _tmp17_, TRUE, _tmp18_);
#line 258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = _tmp19_;
#line 2117 "CheckerboardLayout.c"
	} else {
#line 258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = FALSE;
#line 2121 "CheckerboardLayout.c"
	}
#line 258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp14_) {
#line 259 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (text);
#line 259 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 2129 "CheckerboardLayout.c"
	}
#line 260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp20_ = text;
#line 260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = alignment;
#line 260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp22_ = checkerboard_item_text_new (_tmp20_, _tmp21_, TRUE);
#line 260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->subtitle);
#line 260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle = _tmp22_;
#line 262 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp23_ = self->priv->subtitle_visible;
#line 262 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp23_) {
#line 263 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "set_subtitle");
#line 264 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2149 "CheckerboardLayout.c"
	}
#line 245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (text);
#line 2153 "CheckerboardLayout.c"
}


void checkerboard_item_clear_tags (CheckerboardItem* self) {
#line 268 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 269 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_clear_subtitle (self);
#line 270 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_set_has_tags (self, FALSE);
#line 271 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->user_visible_tag_list);
#line 271 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->user_visible_tag_list = NULL;
#line 2168 "CheckerboardLayout.c"
}


void checkerboard_item_highlight_user_visible_tag (CheckerboardItem* self, gint index) {
	GeeList* _tmp0_;
	gchar* text = NULL;
	GeeList* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	PangoAlignment _tmp5_;
	CheckerboardItemText* _tmp6_;
	gboolean _tmp7_;
#line 274 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 274 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->user_visible_tag_list;
#line 274 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_return_if_fail (_tmp0_ != NULL, "user_visible_tag_list != null");
#line 276 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->user_visible_tag_list;
#line 276 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = index;
#line 276 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = tag_make_tag_markup_string (_tmp1_, _tmp2_);
#line 276 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	text = _tmp3_;
#line 277 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = text;
#line 277 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = self->priv->tag_alignment;
#line 277 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = checkerboard_item_text_new (_tmp4_, _tmp5_, TRUE);
#line 277 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->subtitle);
#line 277 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle = _tmp6_;
#line 279 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = self->priv->subtitle_visible;
#line 279 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp7_) {
#line 280 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2212 "CheckerboardLayout.c"
	}
#line 274 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (text);
#line 2216 "CheckerboardLayout.c"
}


Tag* checkerboard_item_get_user_visible_tag (CheckerboardItem* self, gint index) {
	Tag* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	GeeList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeList* _tmp5_;
	gint _tmp6_;
	gpointer _tmp7_;
#line 283 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 283 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = index;
#line 283 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = index;
#line 283 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->user_visible_tag_list;
#line 283 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
#line 283 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_;
#line 283 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_return_val_if_fail ((_tmp0_ >= 0) && (_tmp1_ < _tmp4_), "index >= 0 && index < user_visible_tag_list.size", NULL);
#line 285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = self->priv->user_visible_tag_list;
#line 285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = index;
#line 285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = gee_list_get (_tmp5_, _tmp6_);
#line 285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = (Tag*) _tmp7_;
#line 285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2254 "CheckerboardLayout.c"
}


PangoLayout* checkerboard_item_get_tag_list_layout (CheckerboardItem* self) {
	PangoLayout* result = NULL;
	PangoLayout* _tmp0_ = NULL;
	gboolean _tmp1_;
#line 288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->_has_tags;
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 2268 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_;
		PangoLayout* _tmp3_;
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->subtitle;
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_get_pango_layout (_tmp2_, 0);
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_tmp0_);
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp3_;
#line 2279 "CheckerboardLayout.c"
	} else {
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_tmp0_);
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = NULL;
#line 2285 "CheckerboardLayout.c"
	}
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2291 "CheckerboardLayout.c"
}


void checkerboard_item_get_subtitle_allocation (CheckerboardItem* self, GdkRectangle* result) {
	CheckerboardItemText* _tmp0_;
	GdkRectangle _tmp1_;
#line 292 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 293 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->subtitle;
#line 293 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_->allocation;
#line 293 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	*result = _tmp1_;
#line 293 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return;
#line 2308 "CheckerboardLayout.c"
}


gchar* checkerboard_item_get_subtitle (CheckerboardItem* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_;
#line 296 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->subtitle;
#line 297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 2322 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_;
		gchar* _tmp3_;
#line 297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->subtitle;
#line 297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
#line 297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp3_;
#line 2333 "CheckerboardLayout.c"
	} else {
		gchar* _tmp4_;
#line 297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = g_strdup ("");
#line 297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_;
#line 2342 "CheckerboardLayout.c"
	}
#line 297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2348 "CheckerboardLayout.c"
}


void checkerboard_item_set_subtitle (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment) {
	gboolean _tmp0_ = FALSE;
	CheckerboardItemText* _tmp1_;
	const gchar* _tmp7_;
	PangoAlignment _tmp8_;
	gboolean _tmp9_;
	CheckerboardItemText* _tmp10_;
	gboolean _tmp11_;
#line 300 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 300 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (text != NULL);
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->subtitle;
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 2368 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_;
		const gchar* _tmp3_;
		gboolean _tmp4_;
		PangoAlignment _tmp5_;
		gboolean _tmp6_;
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->subtitle;
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = text;
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = marked_up;
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = alignment;
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = checkerboard_item_text_is_set_to (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp6_;
#line 2386 "CheckerboardLayout.c"
	} else {
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 2390 "CheckerboardLayout.c"
	}
#line 302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 303 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 2396 "CheckerboardLayout.c"
	}
#line 305 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = text;
#line 305 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = alignment;
#line 305 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = marked_up;
#line 305 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = checkerboard_item_text_new (_tmp7_, _tmp8_, _tmp9_);
#line 305 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->subtitle);
#line 305 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle = _tmp10_;
#line 307 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = self->priv->subtitle_visible;
#line 307 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp11_) {
#line 308 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "set_subtitle");
#line 309 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2418 "CheckerboardLayout.c"
	}
}


void checkerboard_item_clear_subtitle (CheckerboardItem* self) {
	CheckerboardItemText* _tmp0_;
	gboolean _tmp1_;
#line 313 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 314 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->subtitle;
#line 314 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == NULL) {
#line 315 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 2434 "CheckerboardLayout.c"
	}
#line 317 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->subtitle);
#line 317 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle = NULL;
#line 319 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->subtitle_visible;
#line 319 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 320 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "clear_subtitle");
#line 321 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2448 "CheckerboardLayout.c"
	}
}


static void checkerboard_item_set_subtitle_visible (CheckerboardItem* self, gboolean visible) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 325 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 326 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->subtitle_visible;
#line 326 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = visible;
#line 326 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == _tmp1_) {
#line 327 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 2467 "CheckerboardLayout.c"
	}
#line 329 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = visible;
#line 329 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle_visible = _tmp2_;
#line 331 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_recalc_size (self, "set_subtitle_visible");
#line 332 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2477 "CheckerboardLayout.c"
}


void checkerboard_item_set_is_cursor (CheckerboardItem* self, gboolean is_cursor) {
	gboolean _tmp0_;
#line 335 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 336 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = is_cursor;
#line 336 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->is_cursor = _tmp0_;
#line 2489 "CheckerboardLayout.c"
}


gboolean checkerboard_item_get_is_cursor (CheckerboardItem* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 339 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
#line 340 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->is_cursor;
#line 340 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 340 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2504 "CheckerboardLayout.c"
}


static void _vala_GValue_free (GValue* self) {
#line 344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_unset (self);
#line 344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_free (self);
#line 2513 "CheckerboardLayout.c"
}


static void checkerboard_item_real_notify_membership_changed (DataObject* base, DataCollection* collection) {
	CheckerboardItem * self;
	gboolean title_visible = FALSE;
	GValue* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	gboolean _tmp2_;
	gboolean comment_visible = FALSE;
	GValue* _tmp3_ = NULL;
	GValue _tmp4_ = {0};
	gboolean _tmp5_;
	gboolean subtitle_visible = FALSE;
	GValue* _tmp6_ = NULL;
	GValue _tmp7_ = {0};
	gboolean _tmp8_;
	gboolean altered = FALSE;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_;
	DataCollection* _tmp21_;
#line 343 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 343 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail ((collection == NULL) || IS_DATA_COLLECTION (collection));
#line 344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = g_new0 (GValue, 1);
#line 344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_init (_tmp0_, G_TYPE_BOOLEAN);
#line 344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_set_boolean (_tmp0_, TRUE);
#line 344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_object_get_collection_property (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), CHECKERBOARD_ITEM_PROP_SHOW_TITLES, _tmp0_, &_tmp1_);
#line 344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = g_value_get_boolean (&_tmp1_);
#line 344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	__vala_GValue_free0 (_tmp0_);
#line 344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	title_visible = _tmp2_;
#line 345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = g_new0 (GValue, 1);
#line 345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_init (_tmp3_, G_TYPE_BOOLEAN);
#line 345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_set_boolean (_tmp3_, TRUE);
#line 345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_object_get_collection_property (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), CHECKERBOARD_ITEM_PROP_SHOW_COMMENTS, _tmp3_, &_tmp4_);
#line 345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = g_value_get_boolean (&_tmp4_);
#line 345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	__vala_GValue_free0 (_tmp3_);
#line 345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	comment_visible = _tmp5_;
#line 346 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = g_new0 (GValue, 1);
#line 346 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_init (_tmp6_, G_TYPE_BOOLEAN);
#line 346 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_set_boolean (_tmp6_, FALSE);
#line 346 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_object_get_collection_property (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES, _tmp6_, &_tmp7_);
#line 346 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = g_value_get_boolean (&_tmp7_);
#line 346 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	__vala_GValue_free0 (_tmp6_);
#line 346 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	subtitle_visible = _tmp8_;
#line 348 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	altered = FALSE;
#line 349 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->title_visible;
#line 349 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = title_visible;
#line 349 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp9_ != _tmp10_) {
#line 2595 "CheckerboardLayout.c"
		gboolean _tmp11_;
#line 350 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = title_visible;
#line 350 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->title_visible = _tmp11_;
#line 351 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		altered = TRUE;
#line 2603 "CheckerboardLayout.c"
	}
#line 354 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = self->priv->comment_visible;
#line 354 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = comment_visible;
#line 354 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp12_ != _tmp13_) {
#line 2611 "CheckerboardLayout.c"
		gboolean _tmp14_;
#line 355 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = comment_visible;
#line 355 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->comment_visible = _tmp14_;
#line 356 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		altered = TRUE;
#line 2619 "CheckerboardLayout.c"
	}
#line 359 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = self->priv->subtitle_visible;
#line 359 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = subtitle_visible;
#line 359 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp15_ != _tmp16_) {
#line 2627 "CheckerboardLayout.c"
		gboolean _tmp17_;
#line 360 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = subtitle_visible;
#line 360 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->subtitle_visible = _tmp17_;
#line 361 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		altered = TRUE;
#line 2635 "CheckerboardLayout.c"
	}
#line 364 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp19_ = altered;
#line 364 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp19_) {
#line 364 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = TRUE;
#line 2643 "CheckerboardLayout.c"
	} else {
		gboolean _tmp20_;
#line 364 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = dimensions_has_area (&self->requisition);
#line 364 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = !_tmp20_;
#line 2650 "CheckerboardLayout.c"
	}
#line 364 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp18_) {
#line 365 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "notify_membership_changed");
#line 366 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2658 "CheckerboardLayout.c"
	}
#line 369 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = collection;
#line 369 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	DATA_OBJECT_CLASS (checkerboard_item_parent_class)->notify_membership_changed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView), TYPE_DATA_OBJECT, DataObject), _tmp21_);
#line 2664 "CheckerboardLayout.c"
}


static void checkerboard_item_real_notify_collection_property_set (DataObject* base, const gchar* name, GValue* old, GValue* val) {
	CheckerboardItem * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	const gchar* _tmp7_;
	GValue* _tmp8_;
	GValue _tmp9_;
#line 372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (name != NULL);
#line 372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (val != NULL);
#line 373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = name;
#line 373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_;
#line 373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp3_ == g_quark_from_string (CHECKERBOARD_ITEM_PROP_SHOW_TITLES)) {
#line 373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		switch (0) {
#line 2692 "CheckerboardLayout.c"
			default:
			{
				GValue _tmp4_;
#line 375 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp4_ = *val;
#line 375 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_set_title_visible (self, g_value_get_boolean (&_tmp4_));
#line 376 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 2702 "CheckerboardLayout.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (CHECKERBOARD_ITEM_PROP_SHOW_COMMENTS)) {
#line 373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		switch (0) {
#line 2708 "CheckerboardLayout.c"
			default:
			{
				GValue _tmp5_;
#line 379 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp5_ = *val;
#line 379 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_set_comment_visible (self, g_value_get_boolean (&_tmp5_));
#line 380 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 2718 "CheckerboardLayout.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES)) {
#line 373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		switch (0) {
#line 2724 "CheckerboardLayout.c"
			default:
			{
				GValue _tmp6_;
#line 383 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp6_ = *val;
#line 383 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_set_subtitle_visible (self, g_value_get_boolean (&_tmp6_));
#line 384 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 2734 "CheckerboardLayout.c"
			}
		}
	}
#line 387 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = name;
#line 387 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = old;
#line 387 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = *val;
#line 387 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	DATA_OBJECT_CLASS (checkerboard_item_parent_class)->notify_collection_property_set (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView), TYPE_DATA_OBJECT, DataObject), _tmp7_, _tmp8_, &_tmp9_);
#line 2746 "CheckerboardLayout.c"
}


gint checkerboard_item_get_alignment_point (CheckerboardItem* self) {
	gint result = 0;
	Dimensions _tmp0_;
	gint _tmp1_;
#line 393 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
#line 394 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->pixbuf_dim;
#line 394 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_.height;
#line 394 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = (CHECKERBOARD_ITEM_FRAME_WIDTH + CHECKERBOARD_ITEM_BORDER_WIDTH) + _tmp1_;
#line 394 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2764 "CheckerboardLayout.c"
}


static void checkerboard_item_real_exposed (CheckerboardItem* self) {
#line 398 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure = TRUE;
#line 2771 "CheckerboardLayout.c"
}


void checkerboard_item_exposed (CheckerboardItem* self) {
#line 397 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 397 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	CHECKERBOARD_ITEM_GET_CLASS (self)->exposed (self);
#line 2780 "CheckerboardLayout.c"
}


static void checkerboard_item_real_unexposed (CheckerboardItem* self) {
	CheckerboardItemText* _tmp0_;
	CheckerboardItemText* _tmp2_;
	CheckerboardItemText* _tmp4_;
#line 402 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure = FALSE;
#line 404 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->title;
#line 404 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ != NULL) {
#line 2794 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp1_;
#line 405 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = self->priv->title;
#line 405 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_clear_pango_layout (_tmp1_);
#line 2800 "CheckerboardLayout.c"
	}
#line 407 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->comment;
#line 407 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ != NULL) {
#line 2806 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp3_;
#line 408 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->comment;
#line 408 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_clear_pango_layout (_tmp3_);
#line 2812 "CheckerboardLayout.c"
	}
#line 410 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = self->priv->subtitle;
#line 410 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_ != NULL) {
#line 2818 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp5_;
#line 411 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = self->priv->subtitle;
#line 411 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_clear_pango_layout (_tmp5_);
#line 2824 "CheckerboardLayout.c"
	}
}


void checkerboard_item_unexposed (CheckerboardItem* self) {
#line 401 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 401 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	CHECKERBOARD_ITEM_GET_CLASS (self)->unexposed (self);
#line 2834 "CheckerboardLayout.c"
}


static gboolean checkerboard_item_real_is_exposed (CheckerboardItem* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 415 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->exposure;
#line 415 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 415 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2847 "CheckerboardLayout.c"
}


gboolean checkerboard_item_is_exposed (CheckerboardItem* self) {
#line 414 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
#line 414 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return CHECKERBOARD_ITEM_GET_CLASS (self)->is_exposed (self);
#line 2856 "CheckerboardLayout.c"
}


gboolean checkerboard_item_has_image (CheckerboardItem* self) {
	gboolean result = FALSE;
	GdkPixbuf* _tmp0_;
#line 418 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
#line 419 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->pixbuf;
#line 419 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_ != NULL;
#line 419 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2871 "CheckerboardLayout.c"
}


GdkPixbuf* checkerboard_item_get_image (CheckerboardItem* self) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
#line 422 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 423 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->pixbuf;
#line 423 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 423 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp1_;
#line 423 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2889 "CheckerboardLayout.c"
}


void checkerboard_item_set_image (CheckerboardItem* self, GdkPixbuf* pixbuf) {
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	Dimensions _tmp5_ = {0};
#line 426 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 426 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 427 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = pixbuf;
#line 427 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 427 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->pixbuf);
#line 427 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf = _tmp1_;
#line 428 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = pixbuf;
#line 428 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 428 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->display_pixbuf);
#line 428 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->display_pixbuf = _tmp3_;
#line 429 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = pixbuf;
#line 429 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions_for_pixbuf (_tmp4_, &_tmp5_);
#line 429 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf_dim = _tmp5_;
#line 431 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_recalc_size (self, "set_image");
#line 432 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2930 "CheckerboardLayout.c"
}


void checkerboard_item_clear_image (CheckerboardItem* self, Dimensions* dim) {
	gboolean had_image = FALSE;
	GdkPixbuf* _tmp0_;
	Dimensions _tmp1_;
	gboolean _tmp2_;
#line 435 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 435 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (dim != NULL);
#line 436 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->pixbuf;
#line 436 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	had_image = _tmp0_ != NULL;
#line 438 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->pixbuf);
#line 438 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf = NULL;
#line 439 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->display_pixbuf);
#line 439 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->display_pixbuf = NULL;
#line 440 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = *dim;
#line 440 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf_dim = _tmp1_;
#line 442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_recalc_size (self, "clear_image");
#line 444 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = had_image;
#line 444 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_) {
#line 445 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2967 "CheckerboardLayout.c"
	}
}


gint checkerboard_item_get_max_width (gint scale) {
	gint result = 0;
	gint _tmp0_;
#line 451 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = scale;
#line 451 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = (CHECKERBOARD_ITEM_FRAME_WIDTH * 2) + _tmp0_;
#line 451 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2981 "CheckerboardLayout.c"
}


static void checkerboard_item_recalc_size (CheckerboardItem* self, const gchar* reason) {
	Dimensions old_requisition = {0};
	Dimensions _tmp0_;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	CheckerboardItemText* _tmp3_;
	gint title_height = 0;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	CheckerboardItemText* _tmp9_;
	gint comment_height = 0;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	CheckerboardItemText* _tmp15_;
	gint subtitle_height = 0;
	Dimensions _tmp19_;
	gint _tmp20_;
	Dimensions _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	Dimensions _tmp26_;
	gboolean _tmp27_;
#line 454 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 454 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (reason != NULL);
#line 455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->requisition;
#line 455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old_requisition = _tmp0_;
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->title;
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp3_ != NULL) {
#line 3021 "CheckerboardLayout.c"
		gboolean _tmp4_;
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->title_visible;
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = _tmp4_;
#line 3027 "CheckerboardLayout.c"
	} else {
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = FALSE;
#line 3031 "CheckerboardLayout.c"
	}
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_) {
#line 3035 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp5_;
		gint _tmp6_;
#line 459 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = self->priv->title;
#line 459 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = checkerboard_item_text_get_height (_tmp5_);
#line 459 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = _tmp6_ + CHECKERBOARD_ITEM_LABEL_PADDING;
#line 3044 "CheckerboardLayout.c"
	} else {
#line 459 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = 0;
#line 3048 "CheckerboardLayout.c"
	}
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	title_height = _tmp1_;
#line 460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->comment;
#line 460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp9_ != NULL) {
#line 3056 "CheckerboardLayout.c"
		gboolean _tmp10_;
#line 460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = self->priv->comment_visible;
#line 460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = _tmp10_;
#line 3062 "CheckerboardLayout.c"
	} else {
#line 460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = FALSE;
#line 3066 "CheckerboardLayout.c"
	}
#line 460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp8_) {
#line 3070 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp11_;
		gint _tmp12_;
#line 461 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = self->priv->comment;
#line 461 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = checkerboard_item_text_get_height (_tmp11_);
#line 461 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = _tmp12_ + CHECKERBOARD_ITEM_LABEL_PADDING;
#line 3079 "CheckerboardLayout.c"
	} else {
#line 461 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = 0;
#line 3083 "CheckerboardLayout.c"
	}
#line 460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	comment_height = _tmp7_;
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = self->priv->subtitle;
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp15_ != NULL) {
#line 3091 "CheckerboardLayout.c"
		gboolean _tmp16_;
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp16_ = self->priv->subtitle_visible;
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = _tmp16_;
#line 3097 "CheckerboardLayout.c"
	} else {
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = FALSE;
#line 3101 "CheckerboardLayout.c"
	}
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp14_) {
#line 3105 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp17_;
		gint _tmp18_;
#line 463 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = self->priv->subtitle;
#line 463 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = checkerboard_item_text_get_height (_tmp17_);
#line 463 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = _tmp18_ + CHECKERBOARD_ITEM_LABEL_PADDING;
#line 3114 "CheckerboardLayout.c"
	} else {
#line 463 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = 0;
#line 3118 "CheckerboardLayout.c"
	}
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	subtitle_height = _tmp13_;
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp19_ = self->priv->pixbuf_dim;
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp20_ = _tmp19_.width;
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->requisition.width = ((CHECKERBOARD_ITEM_FRAME_WIDTH * 2) + (CHECKERBOARD_ITEM_BORDER_WIDTH * 2)) + _tmp20_;
#line 471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = self->priv->pixbuf_dim;
#line 471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp22_ = _tmp21_.height;
#line 471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp23_ = title_height;
#line 471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp24_ = comment_height;
#line 471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp25_ = subtitle_height;
#line 471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->requisition.height = (((((CHECKERBOARD_ITEM_FRAME_WIDTH * 2) + (CHECKERBOARD_ITEM_BORDER_WIDTH * 2)) + _tmp22_) + _tmp23_) + _tmp24_) + _tmp25_;
#line 480 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp26_ = old_requisition;
#line 480 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp27_ = dimensions_approx_equals (&self->requisition, &_tmp26_, 1);
#line 480 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp27_) {
#line 484 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_geometry_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 3148 "CheckerboardLayout.c"
	}
}


void checkerboard_item_get_border_dimensions (Dimensions* object_dim, gint border_width, Dimensions* result) {
	Dimensions dimensions = {0};
	Dimensions _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	Dimensions _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
#line 488 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (object_dim != NULL);
#line 489 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions_init (&dimensions, 0, 0);
#line 490 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = *object_dim;
#line 490 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_.width;
#line 490 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = border_width;
#line 490 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions.width = _tmp1_ + (_tmp2_ * 2);
#line 491 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = *object_dim;
#line 491 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_.height;
#line 491 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = border_width;
#line 491 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions.height = _tmp4_ + (_tmp5_ * 2);
#line 492 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	*result = dimensions;
#line 492 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return;
#line 3185 "CheckerboardLayout.c"
}


void checkerboard_item_get_border_origin (GdkPoint* object_origin, gint border_width, GdkPoint* result) {
	GdkPoint origin = {0};
	GdkPoint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GdkPoint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
#line 495 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (object_origin != NULL);
#line 496 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&origin, 0, sizeof (GdkPoint));
#line 497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = *object_origin;
#line 497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_.x;
#line 497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = border_width;
#line 497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	origin.x = _tmp1_ - _tmp2_;
#line 498 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = *object_origin;
#line 498 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_.y;
#line 498 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = border_width;
#line 498 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	origin.y = _tmp4_ - _tmp5_;
#line 499 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	*result = origin;
#line 499 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return;
#line 3221 "CheckerboardLayout.c"
}


static void checkerboard_item_real_paint_shadow (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha) {
	gdouble rgb_all = 0.0;
	cairo_t* _tmp0_;
	GdkPoint _tmp1_;
	gint _tmp2_;
	Dimensions _tmp3_;
	gint _tmp4_;
	GdkPoint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gfloat _tmp9_;
	cairo_t* _tmp10_;
	GdkPoint _tmp11_;
	gint _tmp12_;
	Dimensions _tmp13_;
	gint _tmp14_;
	GdkPoint _tmp15_;
	gint _tmp16_;
	Dimensions _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gfloat _tmp20_;
	cairo_t* _tmp21_;
	GdkPoint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	GdkPoint _tmp25_;
	gint _tmp26_;
	Dimensions _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gfloat _tmp30_;
	cairo_pattern_t* lr = NULL;
	GdkPoint _tmp31_;
	gint _tmp32_;
	Dimensions _tmp33_;
	gint _tmp34_;
	GdkPoint _tmp35_;
	gint _tmp36_;
	Dimensions _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	cairo_pattern_t* _tmp40_;
	gfloat _tmp41_;
	cairo_t* _tmp42_;
	cairo_t* _tmp43_;
	GdkPoint _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	GdkPoint _tmp47_;
	gint _tmp48_;
	Dimensions _tmp49_;
	gint _tmp50_;
	Dimensions _tmp51_;
	gint _tmp52_;
	gint _tmp53_;
	gint _tmp54_;
	cairo_t* _tmp55_;
	cairo_pattern_t* td = NULL;
	GdkPoint _tmp56_;
	gint _tmp57_;
	Dimensions _tmp58_;
	gint _tmp59_;
	GdkPoint _tmp60_;
	gint _tmp61_;
	Dimensions _tmp62_;
	gint _tmp63_;
	gint _tmp64_;
	cairo_pattern_t* _tmp65_;
	gfloat _tmp66_;
	cairo_t* _tmp67_;
	cairo_t* _tmp68_;
	GdkPoint _tmp69_;
	gint _tmp70_;
	Dimensions _tmp71_;
	gint _tmp72_;
	GdkPoint _tmp73_;
	gint _tmp74_;
	gint _tmp75_;
	gint _tmp76_;
	Dimensions _tmp77_;
	gint _tmp78_;
	gint _tmp79_;
	cairo_t* _tmp80_;
#line 502 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 502 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (dimensions != NULL);
#line 502 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (origin != NULL);
#line 504 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	rgb_all = 0.0;
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = ctx;
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = *origin;
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_.x;
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = *dimensions;
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_.width;
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = *origin;
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = _tmp5_.y;
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = radius;
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = radius;
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = initial_alpha;
#line 507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_paint_shadow_in_corner (self, _tmp0_, _tmp2_ + _tmp4_, _tmp6_ + _tmp7_, rgb_all, (gfloat) _tmp8_, _tmp9_, (-0.5) * G_PI, (gdouble) 0);
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = ctx;
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = *origin;
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = _tmp11_.x;
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = *dimensions;
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = _tmp13_.width;
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = *origin;
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = _tmp15_.y;
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp17_ = *dimensions;
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp18_ = _tmp17_.height;
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp19_ = radius;
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp20_ = initial_alpha;
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_paint_shadow_in_corner (self, _tmp10_, _tmp12_ + _tmp14_, _tmp16_ + _tmp18_, rgb_all, (gfloat) _tmp19_, _tmp20_, (gdouble) 0, 0.5 * G_PI);
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = ctx;
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp22_ = *origin;
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp23_ = _tmp22_.x;
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp24_ = radius;
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp25_ = *origin;
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp26_ = _tmp25_.y;
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp27_ = *dimensions;
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp28_ = _tmp27_.height;
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp29_ = radius;
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp30_ = initial_alpha;
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_paint_shadow_in_corner (self, _tmp21_, _tmp23_ + _tmp24_, _tmp26_ + _tmp28_, rgb_all, (gfloat) _tmp29_, _tmp30_, 0.5 * G_PI, G_PI);
#line 517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp31_ = *origin;
#line 517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp32_ = _tmp31_.y;
#line 517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp33_ = *dimensions;
#line 517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp34_ = _tmp33_.height;
#line 517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp35_ = *origin;
#line 517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp36_ = _tmp35_.y;
#line 517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp37_ = *dimensions;
#line 517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp38_ = _tmp37_.height;
#line 517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp39_ = radius;
#line 517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp40_ = cairo_pattern_create_linear ((gdouble) 0, (gdouble) (_tmp32_ + _tmp34_), (gdouble) 0, (gdouble) ((_tmp36_ + _tmp38_) + _tmp39_));
#line 517 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	lr = _tmp40_;
#line 519 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp41_ = initial_alpha;
#line 519 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (lr, 0.0, rgb_all, rgb_all, rgb_all, (gdouble) _tmp41_);
#line 520 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (lr, 1.0, rgb_all, rgb_all, rgb_all, 0.0);
#line 521 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp42_ = ctx;
#line 521 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source (_tmp42_, lr);
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp43_ = ctx;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp44_ = *origin;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp45_ = _tmp44_.x;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp46_ = radius;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp47_ = *origin;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp48_ = _tmp47_.y;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp49_ = *dimensions;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp50_ = _tmp49_.height;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp51_ = *dimensions;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp52_ = _tmp51_.width;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp53_ = radius;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp54_ = radius;
#line 522 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_rectangle (_tmp43_, (gdouble) (_tmp45_ + _tmp46_), (gdouble) (_tmp48_ + _tmp50_), (gdouble) (_tmp52_ - _tmp53_), (gdouble) _tmp54_);
#line 523 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp55_ = ctx;
#line 523 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_fill (_tmp55_);
#line 526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp56_ = *origin;
#line 526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp57_ = _tmp56_.x;
#line 526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp58_ = *dimensions;
#line 526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp59_ = _tmp58_.width;
#line 526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp60_ = *origin;
#line 526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp61_ = _tmp60_.x;
#line 526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp62_ = *dimensions;
#line 526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp63_ = _tmp62_.width;
#line 526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp64_ = radius;
#line 526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp65_ = cairo_pattern_create_linear ((gdouble) (_tmp57_ + _tmp59_), (gdouble) 0, (gdouble) ((_tmp61_ + _tmp63_) + _tmp64_), (gdouble) 0);
#line 526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	td = _tmp65_;
#line 528 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp66_ = initial_alpha;
#line 528 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (td, 0.0, rgb_all, rgb_all, rgb_all, (gdouble) _tmp66_);
#line 529 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (td, 1.0, rgb_all, rgb_all, rgb_all, 0.0);
#line 530 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp67_ = ctx;
#line 530 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source (_tmp67_, td);
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp68_ = ctx;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp69_ = *origin;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp70_ = _tmp69_.x;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp71_ = *dimensions;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp72_ = _tmp71_.width;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp73_ = *origin;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp74_ = _tmp73_.y;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp75_ = radius;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp76_ = radius;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp77_ = *dimensions;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp78_ = _tmp77_.height;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp79_ = radius;
#line 531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_rectangle (_tmp68_, (gdouble) (_tmp70_ + _tmp72_), (gdouble) (_tmp74_ + _tmp75_), (gdouble) _tmp76_, (gdouble) (_tmp78_ - _tmp79_));
#line 533 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp80_ = ctx;
#line 533 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_fill (_tmp80_);
#line 502 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_cairo_pattern_destroy0 (td);
#line 502 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_cairo_pattern_destroy0 (lr);
#line 3514 "CheckerboardLayout.c"
}


void checkerboard_item_paint_shadow (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha) {
#line 502 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 502 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	CHECKERBOARD_ITEM_GET_CLASS (self)->paint_shadow (self, ctx, dimensions, origin, radius, initial_alpha);
#line 3523 "CheckerboardLayout.c"
}


void checkerboard_item_paint_shadow_in_corner (CheckerboardItem* self, cairo_t* ctx, gint x, gint y, gdouble rgb_all, gfloat radius, gfloat initial_alpha, gdouble arc1, gdouble arc2) {
	cairo_pattern_t* p = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gfloat _tmp4_;
	cairo_pattern_t* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gfloat _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	cairo_t* _tmp13_;
	cairo_t* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	cairo_t* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gfloat _tmp20_;
	gdouble _tmp21_;
	gdouble _tmp22_;
	cairo_t* _tmp23_;
	cairo_t* _tmp24_;
#line 536 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 536 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 538 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = x;
#line 538 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = y;
#line 538 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = x;
#line 538 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = y;
#line 538 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = radius;
#line 538 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = cairo_pattern_create_radial ((gdouble) _tmp0_, (gdouble) _tmp1_, (gdouble) 0, (gdouble) _tmp2_, (gdouble) _tmp3_, (gdouble) _tmp4_);
#line 538 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	p = _tmp5_;
#line 539 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = rgb_all;
#line 539 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = rgb_all;
#line 539 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = rgb_all;
#line 539 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = initial_alpha;
#line 539 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (p, 0.0, _tmp6_, _tmp7_, _tmp8_, (gdouble) _tmp9_);
#line 540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = rgb_all;
#line 540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = rgb_all;
#line 540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = rgb_all;
#line 540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (p, 1.0, _tmp10_, _tmp11_, _tmp12_, (gdouble) 0);
#line 541 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = ctx;
#line 541 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source (_tmp13_, p);
#line 542 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = ctx;
#line 542 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = x;
#line 542 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = y;
#line 542 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_move_to (_tmp14_, (gdouble) _tmp15_, (gdouble) _tmp16_);
#line 543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp17_ = ctx;
#line 543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp18_ = x;
#line 543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp19_ = y;
#line 543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp20_ = radius;
#line 543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = arc1;
#line 543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp22_ = arc2;
#line 543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_arc (_tmp17_, (gdouble) _tmp18_, (gdouble) _tmp19_, (gdouble) _tmp20_, _tmp21_, _tmp22_);
#line 544 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp23_ = ctx;
#line 544 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_close_path (_tmp23_);
#line 545 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp24_ = ctx;
#line 545 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_fill (_tmp24_);
#line 536 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_cairo_pattern_destroy0 (p);
#line 3626 "CheckerboardLayout.c"
}


static void checkerboard_item_real_paint_border (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width) {
	gint _tmp0_;
#line 548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (object_dimensions != NULL);
#line 548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (object_origin != NULL);
#line 550 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = border_width;
#line 550 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == 1) {
#line 3642 "CheckerboardLayout.c"
		cairo_t* _tmp1_;
		GdkPoint _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		GdkPoint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		Dimensions _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		Dimensions _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		cairo_t* _tmp14_;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = ctx;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = *object_origin;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = _tmp2_.x;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = border_width;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = *object_origin;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = _tmp5_.y;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = border_width;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = *object_dimensions;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = _tmp8_.width;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = border_width;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = *object_dimensions;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = _tmp11_.height;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = border_width;
#line 551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (_tmp1_, (gdouble) (_tmp3_ - _tmp4_), (gdouble) (_tmp6_ - _tmp7_), (gdouble) (_tmp9_ + (_tmp10_ * 2)), (gdouble) (_tmp12_ + (_tmp13_ * 2)));
#line 554 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = ctx;
#line 554 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (_tmp14_);
#line 3689 "CheckerboardLayout.c"
	} else {
		Dimensions dimensions = {0};
		Dimensions _tmp15_;
		gint _tmp16_;
		Dimensions _tmp17_ = {0};
		GdkPoint origin = {0};
		GdkPoint _tmp18_;
		gint _tmp19_;
		GdkPoint _tmp20_ = {0};
		gdouble scale = 0.0;
		Dimensions _tmp21_;
		gint _tmp22_;
		Dimensions _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		cairo_t* _tmp26_;
		Dimensions _tmp27_;
		GdkPoint _tmp28_;
		gdouble _tmp29_;
#line 556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = *object_dimensions;
#line 556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp16_ = border_width;
#line 556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_get_border_dimensions (&_tmp15_, _tmp16_, &_tmp17_);
#line 556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dimensions = _tmp17_;
#line 557 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = *object_origin;
#line 557 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = border_width;
#line 557 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_get_border_origin (&_tmp18_, _tmp19_, &_tmp20_);
#line 557 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		origin = _tmp20_;
#line 560 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = *object_dimensions;
#line 560 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = _tmp21_.width;
#line 560 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp23_ = *object_dimensions;
#line 560 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp24_ = _tmp23_.height;
#line 560 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp25_ = MAX (_tmp22_, _tmp24_);
#line 560 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		scale = (gdouble) _tmp25_;
#line 561 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp26_ = ctx;
#line 561 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp27_ = dimensions;
#line 561 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp28_ = origin;
#line 561 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp29_ = scale;
#line 561 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		draw_rounded_corners_filled (_tmp26_, &_tmp27_, &_tmp28_, 0.25 * _tmp29_);
#line 3747 "CheckerboardLayout.c"
	}
}


void checkerboard_item_paint_border (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width) {
#line 548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	CHECKERBOARD_ITEM_GET_CLASS (self)->paint_border (self, ctx, object_dimensions, object_origin, border_width);
#line 3757 "CheckerboardLayout.c"
}


static void checkerboard_item_real_paint_image (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin) {
	cairo_t* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPoint _tmp2_;
	gint _tmp3_;
	GdkPoint _tmp4_;
	gint _tmp5_;
#line 565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (origin != NULL);
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = ctx;
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = pixbuf;
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = *origin;
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_.x;
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = *origin;
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _tmp4_.y;
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	paint_pixmap_with_background (_tmp0_, _tmp1_, _tmp3_, _tmp5_);
#line 3788 "CheckerboardLayout.c"
}


void checkerboard_item_paint_image (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin) {
#line 565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	CHECKERBOARD_ITEM_GET_CLASS (self)->paint_image (self, ctx, pixbuf, origin);
#line 3797 "CheckerboardLayout.c"
}


static gint checkerboard_item_get_selection_border_width (CheckerboardItem* self, gint scale) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
#line 569 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
#line 570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = scale;
#line 570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = thumbnail_get_MIN_SCALE ();
#line 570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_;
#line 570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = thumbnail_get_MAX_SCALE ();
#line 570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _tmp4_;
#line 570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ <= ((_tmp3_ + _tmp5_) / 3)) {
#line 570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = 2;
#line 3825 "CheckerboardLayout.c"
	} else {
#line 570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = 3;
#line 3829 "CheckerboardLayout.c"
	}
#line 570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_ + CHECKERBOARD_ITEM_BORDER_WIDTH;
#line 570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3835 "CheckerboardLayout.c"
}


static GdkPixbuf* checkerboard_item_real_get_top_left_trinket (CheckerboardItem* self, gint scale) {
	GdkPixbuf* result = NULL;
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = NULL;
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3845 "CheckerboardLayout.c"
}


GdkPixbuf* checkerboard_item_get_top_left_trinket (CheckerboardItem* self, gint scale) {
#line 574 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 574 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return CHECKERBOARD_ITEM_GET_CLASS (self)->get_top_left_trinket (self, scale);
#line 3854 "CheckerboardLayout.c"
}


static GdkPixbuf* checkerboard_item_real_get_top_right_trinket (CheckerboardItem* self, gint scale) {
	GdkPixbuf* result = NULL;
#line 579 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = NULL;
#line 579 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3864 "CheckerboardLayout.c"
}


GdkPixbuf* checkerboard_item_get_top_right_trinket (CheckerboardItem* self, gint scale) {
#line 578 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 578 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return CHECKERBOARD_ITEM_GET_CLASS (self)->get_top_right_trinket (self, scale);
#line 3873 "CheckerboardLayout.c"
}


static GdkPixbuf* checkerboard_item_real_get_bottom_left_trinket (CheckerboardItem* self, gint scale) {
	GdkPixbuf* result = NULL;
#line 583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = NULL;
#line 583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3883 "CheckerboardLayout.c"
}


GdkPixbuf* checkerboard_item_get_bottom_left_trinket (CheckerboardItem* self, gint scale) {
#line 582 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 582 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return CHECKERBOARD_ITEM_GET_CLASS (self)->get_bottom_left_trinket (self, scale);
#line 3892 "CheckerboardLayout.c"
}


static GdkPixbuf* checkerboard_item_real_get_bottom_right_trinket (CheckerboardItem* self, gint scale) {
	GdkPixbuf* result = NULL;
#line 587 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = NULL;
#line 587 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3902 "CheckerboardLayout.c"
}


GdkPixbuf* checkerboard_item_get_bottom_right_trinket (CheckerboardItem* self, gint scale) {
#line 586 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 586 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return CHECKERBOARD_ITEM_GET_CLASS (self)->get_bottom_right_trinket (self, scale);
#line 3911 "CheckerboardLayout.c"
}


void checkerboard_item_paint (CheckerboardItem* self, cairo_t* ctx, GdkRGBA* bg_color, GdkRGBA* selected_color, GdkRGBA* text_color, GdkRGBA* border_color) {
	GdkPoint pixbuf_origin = {0};
	GdkRectangle _tmp0_;
	gint _tmp1_;
	GdkRectangle _tmp2_;
	gint _tmp3_;
	cairo_t* _tmp4_;
	cairo_t* _tmp5_;
	GdkRGBA _tmp6_;
	gdouble _tmp7_;
	GdkRGBA _tmp8_;
	gdouble _tmp9_;
	GdkRGBA _tmp10_;
	gdouble _tmp11_;
	GdkRGBA _tmp12_;
	gdouble _tmp13_;
	GdkRGBA* _tmp14_;
	gboolean _tmp24_;
	gboolean _tmp45_;
	GdkRGBA* _tmp57_;
	GdkPixbuf* _tmp72_;
	cairo_t* _tmp87_;
	GdkRGBA _tmp88_;
	gdouble _tmp89_;
	GdkRGBA _tmp90_;
	gdouble _tmp91_;
	GdkRGBA _tmp92_;
	gdouble _tmp93_;
	GdkRGBA _tmp94_;
	gdouble _tmp95_;
	gint text_y = 0;
	GdkRectangle _tmp96_;
	gint _tmp97_;
	Dimensions _tmp98_;
	gint _tmp99_;
	gboolean _tmp100_ = FALSE;
	CheckerboardItemText* _tmp101_;
	gboolean _tmp130_ = FALSE;
	CheckerboardItemText* _tmp131_;
	gboolean _tmp160_ = FALSE;
	CheckerboardItemText* _tmp161_;
	cairo_t* _tmp187_;
	GdkRGBA _tmp188_;
	gdouble _tmp189_;
	GdkRGBA _tmp190_;
	gdouble _tmp191_;
	GdkRGBA _tmp192_;
	gdouble _tmp193_;
	GdkRGBA _tmp194_;
	gdouble _tmp195_;
	GdkPixbuf* trinket = NULL;
	GdkPixbuf* _tmp196_;
	GdkPixbuf* _tmp197_;
	GdkPixbuf* _tmp219_;
	GdkPixbuf* _tmp220_;
	GdkPixbuf* _tmp238_;
	GdkPixbuf* _tmp239_;
	GdkPixbuf* _tmp262_;
	GdkPixbuf* _tmp263_;
#line 590 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 590 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 590 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (bg_color != NULL);
#line 590 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (selected_color != NULL);
#line 590 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (text_color != NULL);
#line 593 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&pixbuf_origin, 0, sizeof (GdkPoint));
#line 594 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->allocation;
#line 594 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_.x;
#line 594 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	pixbuf_origin.x = (_tmp1_ + CHECKERBOARD_ITEM_FRAME_WIDTH) + CHECKERBOARD_ITEM_BORDER_WIDTH;
#line 595 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->allocation;
#line 595 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_.y;
#line 595 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	pixbuf_origin.y = (_tmp3_ + CHECKERBOARD_ITEM_FRAME_WIDTH) + CHECKERBOARD_ITEM_BORDER_WIDTH;
#line 597 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = ctx;
#line 597 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_line_width (_tmp4_, (gdouble) CHECKERBOARD_ITEM_FRAME_WIDTH);
#line 598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = ctx;
#line 598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = *selected_color;
#line 598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = _tmp6_.red;
#line 598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = *selected_color;
#line 598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = _tmp8_.green;
#line 598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = *selected_color;
#line 598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = _tmp10_.blue;
#line 598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = *selected_color;
#line 598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = _tmp12_.alpha;
#line 598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source_rgba (_tmp5_, _tmp7_, _tmp9_, _tmp11_, _tmp13_);
#line 602 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = border_color;
#line 602 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp14_ != NULL) {
#line 4026 "CheckerboardLayout.c"
		cairo_t* _tmp15_;
		Dimensions shadow_dim = {0};
		Dimensions _tmp16_;
		gint _tmp17_;
		Dimensions _tmp18_;
		gint _tmp19_;
		cairo_t* _tmp20_;
		Dimensions _tmp21_;
		GdkPoint _tmp22_;
		cairo_t* _tmp23_;
#line 603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = ctx;
#line 603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_save (_tmp15_);
#line 604 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dimensions_init (&shadow_dim, 0, 0);
#line 605 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp16_ = self->priv->pixbuf_dim;
#line 605 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = _tmp16_.width;
#line 605 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		shadow_dim.width = _tmp17_ + CHECKERBOARD_ITEM_BORDER_WIDTH;
#line 606 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = self->priv->pixbuf_dim;
#line 606 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = _tmp18_.height;
#line 606 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		shadow_dim.height = _tmp19_ + CHECKERBOARD_ITEM_BORDER_WIDTH;
#line 607 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = ctx;
#line 607 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = shadow_dim;
#line 607 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = pixbuf_origin;
#line 607 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_paint_shadow (self, _tmp20_, &_tmp21_, &_tmp22_, CHECKERBOARD_ITEM_SHADOW_RADIUS, CHECKERBOARD_ITEM_SHADOW_INITIAL_ALPHA);
#line 608 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp23_ = ctx;
#line 608 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_restore (_tmp23_);
#line 4067 "CheckerboardLayout.c"
	}
#line 612 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp24_ = self->priv->is_cursor;
#line 612 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp24_) {
#line 4073 "CheckerboardLayout.c"
		cairo_t* _tmp25_;
		cairo_t* _tmp26_;
		GdkRGBA* _tmp27_;
		gdouble _tmp28_;
		GdkRGBA* _tmp29_;
		gdouble _tmp30_;
		GdkRGBA* _tmp31_;
		gdouble _tmp32_;
		GdkRGBA* _tmp33_;
		gdouble _tmp34_;
		cairo_t* _tmp35_;
		Dimensions _tmp36_;
		GdkPoint _tmp37_;
		Dimensions _tmp38_;
		gint _tmp39_;
		Dimensions _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		cairo_t* _tmp44_;
#line 613 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp25_ = ctx;
#line 613 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_save (_tmp25_);
#line 614 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp26_ = ctx;
#line 614 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp27_ = border_color;
#line 614 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp28_ = (*_tmp27_).red;
#line 614 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp29_ = border_color;
#line 614 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp30_ = (*_tmp29_).green;
#line 614 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp31_ = border_color;
#line 614 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp32_ = (*_tmp31_).blue;
#line 614 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp33_ = border_color;
#line 614 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp34_ = (*_tmp33_).alpha;
#line 614 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_set_source_rgba (_tmp26_, _tmp28_, _tmp30_, _tmp32_, _tmp34_);
#line 616 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp35_ = ctx;
#line 616 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp36_ = self->priv->pixbuf_dim;
#line 616 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp37_ = pixbuf_origin;
#line 616 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp38_ = self->priv->pixbuf_dim;
#line 616 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp39_ = _tmp38_.width;
#line 616 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp40_ = self->priv->pixbuf_dim;
#line 616 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp41_ = _tmp40_.height;
#line 616 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp42_ = MAX (_tmp39_, _tmp41_);
#line 616 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp43_ = checkerboard_item_get_selection_border_width (self, _tmp42_);
#line 616 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_paint_border (self, _tmp35_, &_tmp36_, &_tmp37_, _tmp43_);
#line 618 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp44_ = ctx;
#line 618 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_restore (_tmp44_);
#line 4142 "CheckerboardLayout.c"
	}
#line 622 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp45_ = data_view_is_selected (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 622 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp45_) {
#line 4148 "CheckerboardLayout.c"
		cairo_t* _tmp46_;
		cairo_t* _tmp47_;
		Dimensions _tmp48_;
		GdkPoint _tmp49_;
		Dimensions _tmp50_;
		gint _tmp51_;
		Dimensions _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		cairo_t* _tmp56_;
#line 624 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp46_ = ctx;
#line 624 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_save (_tmp46_);
#line 625 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp47_ = ctx;
#line 625 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp48_ = self->priv->pixbuf_dim;
#line 625 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp49_ = pixbuf_origin;
#line 625 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp50_ = self->priv->pixbuf_dim;
#line 625 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp51_ = _tmp50_.width;
#line 625 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp52_ = self->priv->pixbuf_dim;
#line 625 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp53_ = _tmp52_.height;
#line 625 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp54_ = MAX (_tmp51_, _tmp53_);
#line 625 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp55_ = checkerboard_item_get_selection_border_width (self, _tmp54_);
#line 625 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_paint_border (self, _tmp47_, &_tmp48_, &_tmp49_, _tmp55_);
#line 627 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp56_ = ctx;
#line 627 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_restore (_tmp56_);
#line 4188 "CheckerboardLayout.c"
	}
#line 631 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp57_ = border_color;
#line 631 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp57_ != NULL) {
#line 4194 "CheckerboardLayout.c"
		cairo_t* _tmp58_;
		cairo_t* _tmp59_;
		GdkRGBA* _tmp60_;
		gdouble _tmp61_;
		GdkRGBA* _tmp62_;
		gdouble _tmp63_;
		GdkRGBA* _tmp64_;
		gdouble _tmp65_;
		GdkRGBA* _tmp66_;
		gdouble _tmp67_;
		cairo_t* _tmp68_;
		Dimensions _tmp69_;
		GdkPoint _tmp70_;
		cairo_t* _tmp71_;
#line 632 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp58_ = ctx;
#line 632 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_save (_tmp58_);
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp59_ = ctx;
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp60_ = border_color;
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp61_ = (*_tmp60_).red;
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp62_ = border_color;
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp63_ = (*_tmp62_).green;
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp64_ = border_color;
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp65_ = (*_tmp64_).blue;
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp66_ = border_color;
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp67_ = (*_tmp66_).alpha;
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_set_source_rgba (_tmp59_, _tmp61_, _tmp63_, _tmp65_, _tmp67_);
#line 635 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp68_ = ctx;
#line 635 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp69_ = self->priv->pixbuf_dim;
#line 635 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp70_ = pixbuf_origin;
#line 635 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_paint_border (self, _tmp68_, &_tmp69_, &_tmp70_, CHECKERBOARD_ITEM_BORDER_WIDTH);
#line 636 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp71_ = ctx;
#line 636 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_restore (_tmp71_);
#line 4245 "CheckerboardLayout.c"
	}
#line 639 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp72_ = self->priv->display_pixbuf;
#line 639 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp72_ != NULL) {
#line 4251 "CheckerboardLayout.c"
		cairo_t* _tmp73_;
		cairo_t* _tmp74_;
		GdkRGBA _tmp75_;
		gdouble _tmp76_;
		GdkRGBA _tmp77_;
		gdouble _tmp78_;
		GdkRGBA _tmp79_;
		gdouble _tmp80_;
		GdkRGBA _tmp81_;
		gdouble _tmp82_;
		cairo_t* _tmp83_;
		GdkPixbuf* _tmp84_;
		GdkPoint _tmp85_;
		cairo_t* _tmp86_;
#line 640 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp73_ = ctx;
#line 640 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_save (_tmp73_);
#line 641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp74_ = ctx;
#line 641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp75_ = *bg_color;
#line 641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp76_ = _tmp75_.red;
#line 641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp77_ = *bg_color;
#line 641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp78_ = _tmp77_.green;
#line 641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp79_ = *bg_color;
#line 641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp80_ = _tmp79_.blue;
#line 641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp81_ = *bg_color;
#line 641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp82_ = _tmp81_.alpha;
#line 641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_set_source_rgba (_tmp74_, _tmp76_, _tmp78_, _tmp80_, _tmp82_);
#line 642 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp83_ = ctx;
#line 642 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp84_ = self->priv->display_pixbuf;
#line 642 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp85_ = pixbuf_origin;
#line 642 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_paint_image (self, _tmp83_, _tmp84_, &_tmp85_);
#line 643 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp86_ = ctx;
#line 643 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_restore (_tmp86_);
#line 4302 "CheckerboardLayout.c"
	}
#line 646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp87_ = ctx;
#line 646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp88_ = *text_color;
#line 646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp89_ = _tmp88_.red;
#line 646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp90_ = *text_color;
#line 646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp91_ = _tmp90_.green;
#line 646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp92_ = *text_color;
#line 646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp93_ = _tmp92_.blue;
#line 646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp94_ = *text_color;
#line 646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp95_ = _tmp94_.alpha;
#line 646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source_rgba (_tmp87_, _tmp89_, _tmp91_, _tmp93_, _tmp95_);
#line 649 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp96_ = self->allocation;
#line 649 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp97_ = _tmp96_.y;
#line 649 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp98_ = self->priv->pixbuf_dim;
#line 649 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp99_ = _tmp98_.height;
#line 649 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	text_y = (((_tmp97_ + CHECKERBOARD_ITEM_FRAME_WIDTH) + _tmp99_) + CHECKERBOARD_ITEM_FRAME_WIDTH) + CHECKERBOARD_ITEM_LABEL_PADDING;
#line 650 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp101_ = self->priv->title;
#line 650 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp101_ != NULL) {
#line 4338 "CheckerboardLayout.c"
		gboolean _tmp102_;
#line 650 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp102_ = self->priv->title_visible;
#line 650 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp100_ = _tmp102_;
#line 4344 "CheckerboardLayout.c"
	} else {
#line 650 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp100_ = FALSE;
#line 4348 "CheckerboardLayout.c"
	}
#line 650 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp100_) {
#line 4352 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp103_;
		GdkRectangle _tmp104_;
		gint _tmp105_;
		CheckerboardItemText* _tmp106_;
		gint _tmp107_;
		CheckerboardItemText* _tmp108_;
		Dimensions _tmp109_;
		gint _tmp110_;
		CheckerboardItemText* _tmp111_;
		CheckerboardItemText* _tmp112_;
		gint _tmp113_;
		cairo_t* _tmp114_;
		CheckerboardItemText* _tmp115_;
		GdkRectangle _tmp116_;
		gint _tmp117_;
		CheckerboardItemText* _tmp118_;
		GdkRectangle _tmp119_;
		gint _tmp120_;
		cairo_t* _tmp121_;
		CheckerboardItemText* _tmp122_;
		Dimensions _tmp123_;
		gint _tmp124_;
		PangoLayout* _tmp125_;
		PangoLayout* _tmp126_;
		gint _tmp127_;
		CheckerboardItemText* _tmp128_;
		gint _tmp129_;
#line 653 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp103_ = self->priv->title;
#line 653 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp104_ = self->allocation;
#line 653 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp105_ = _tmp104_.x;
#line 653 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp103_->allocation.x = _tmp105_ + CHECKERBOARD_ITEM_FRAME_WIDTH;
#line 654 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp106_ = self->priv->title;
#line 654 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp107_ = text_y;
#line 654 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp106_->allocation.y = _tmp107_;
#line 655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp108_ = self->priv->title;
#line 655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp109_ = self->priv->pixbuf_dim;
#line 655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp110_ = _tmp109_.width;
#line 655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp108_->allocation.width = _tmp110_;
#line 656 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp111_ = self->priv->title;
#line 656 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp112_ = self->priv->title;
#line 656 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp113_ = checkerboard_item_text_get_height (_tmp112_);
#line 656 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp111_->allocation.height = _tmp113_;
#line 658 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp114_ = ctx;
#line 658 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp115_ = self->priv->title;
#line 658 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp116_ = _tmp115_->allocation;
#line 658 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp117_ = _tmp116_.x;
#line 658 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp118_ = self->priv->title;
#line 658 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp119_ = _tmp118_->allocation;
#line 658 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp120_ = _tmp119_.y;
#line 658 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_move_to (_tmp114_, (gdouble) _tmp117_, (gdouble) _tmp120_);
#line 659 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp121_ = ctx;
#line 659 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp122_ = self->priv->title;
#line 659 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp123_ = self->priv->pixbuf_dim;
#line 659 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp124_ = _tmp123_.width;
#line 659 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp125_ = checkerboard_item_text_get_pango_layout (_tmp122_, _tmp124_);
#line 659 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp126_ = _tmp125_;
#line 659 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_cairo_show_layout (_tmp121_, _tmp126_);
#line 659 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_tmp126_);
#line 661 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp127_ = text_y;
#line 661 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp128_ = self->priv->title;
#line 661 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp129_ = checkerboard_item_text_get_height (_tmp128_);
#line 661 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		text_y = _tmp127_ + (_tmp129_ + CHECKERBOARD_ITEM_LABEL_PADDING);
#line 4450 "CheckerboardLayout.c"
	}
#line 664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp131_ = self->priv->comment;
#line 664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp131_ != NULL) {
#line 4456 "CheckerboardLayout.c"
		gboolean _tmp132_;
#line 664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp132_ = self->priv->comment_visible;
#line 664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp130_ = _tmp132_;
#line 4462 "CheckerboardLayout.c"
	} else {
#line 664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp130_ = FALSE;
#line 4466 "CheckerboardLayout.c"
	}
#line 664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp130_) {
#line 4470 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp133_;
		GdkRectangle _tmp134_;
		gint _tmp135_;
		CheckerboardItemText* _tmp136_;
		gint _tmp137_;
		CheckerboardItemText* _tmp138_;
		Dimensions _tmp139_;
		gint _tmp140_;
		CheckerboardItemText* _tmp141_;
		CheckerboardItemText* _tmp142_;
		gint _tmp143_;
		cairo_t* _tmp144_;
		CheckerboardItemText* _tmp145_;
		GdkRectangle _tmp146_;
		gint _tmp147_;
		CheckerboardItemText* _tmp148_;
		GdkRectangle _tmp149_;
		gint _tmp150_;
		cairo_t* _tmp151_;
		CheckerboardItemText* _tmp152_;
		Dimensions _tmp153_;
		gint _tmp154_;
		PangoLayout* _tmp155_;
		PangoLayout* _tmp156_;
		gint _tmp157_;
		CheckerboardItemText* _tmp158_;
		gint _tmp159_;
#line 665 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp133_ = self->priv->comment;
#line 665 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp134_ = self->allocation;
#line 665 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp135_ = _tmp134_.x;
#line 665 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp133_->allocation.x = _tmp135_ + CHECKERBOARD_ITEM_FRAME_WIDTH;
#line 666 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp136_ = self->priv->comment;
#line 666 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp137_ = text_y;
#line 666 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp136_->allocation.y = _tmp137_;
#line 667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp138_ = self->priv->comment;
#line 667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp139_ = self->priv->pixbuf_dim;
#line 667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp140_ = _tmp139_.width;
#line 667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp138_->allocation.width = _tmp140_;
#line 668 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp141_ = self->priv->comment;
#line 668 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp142_ = self->priv->comment;
#line 668 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp143_ = checkerboard_item_text_get_height (_tmp142_);
#line 668 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp141_->allocation.height = _tmp143_;
#line 670 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp144_ = ctx;
#line 670 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp145_ = self->priv->comment;
#line 670 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp146_ = _tmp145_->allocation;
#line 670 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp147_ = _tmp146_.x;
#line 670 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp148_ = self->priv->comment;
#line 670 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp149_ = _tmp148_->allocation;
#line 670 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp150_ = _tmp149_.y;
#line 670 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_move_to (_tmp144_, (gdouble) _tmp147_, (gdouble) _tmp150_);
#line 671 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp151_ = ctx;
#line 671 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp152_ = self->priv->comment;
#line 671 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp153_ = self->priv->pixbuf_dim;
#line 671 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp154_ = _tmp153_.width;
#line 671 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp155_ = checkerboard_item_text_get_pango_layout (_tmp152_, _tmp154_);
#line 671 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp156_ = _tmp155_;
#line 671 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_cairo_show_layout (_tmp151_, _tmp156_);
#line 671 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_tmp156_);
#line 673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp157_ = text_y;
#line 673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp158_ = self->priv->comment;
#line 673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp159_ = checkerboard_item_text_get_height (_tmp158_);
#line 673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		text_y = _tmp157_ + (_tmp159_ + CHECKERBOARD_ITEM_LABEL_PADDING);
#line 4568 "CheckerboardLayout.c"
	}
#line 676 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp161_ = self->priv->subtitle;
#line 676 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp161_ != NULL) {
#line 4574 "CheckerboardLayout.c"
		gboolean _tmp162_;
#line 676 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp162_ = self->priv->subtitle_visible;
#line 676 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp160_ = _tmp162_;
#line 4580 "CheckerboardLayout.c"
	} else {
#line 676 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp160_ = FALSE;
#line 4584 "CheckerboardLayout.c"
	}
#line 676 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp160_) {
#line 4588 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp163_;
		GdkRectangle _tmp164_;
		gint _tmp165_;
		CheckerboardItemText* _tmp166_;
		gint _tmp167_;
		CheckerboardItemText* _tmp168_;
		Dimensions _tmp169_;
		gint _tmp170_;
		CheckerboardItemText* _tmp171_;
		CheckerboardItemText* _tmp172_;
		gint _tmp173_;
		cairo_t* _tmp174_;
		CheckerboardItemText* _tmp175_;
		GdkRectangle _tmp176_;
		gint _tmp177_;
		CheckerboardItemText* _tmp178_;
		GdkRectangle _tmp179_;
		gint _tmp180_;
		cairo_t* _tmp181_;
		CheckerboardItemText* _tmp182_;
		Dimensions _tmp183_;
		gint _tmp184_;
		PangoLayout* _tmp185_;
		PangoLayout* _tmp186_;
#line 677 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp163_ = self->priv->subtitle;
#line 677 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp164_ = self->allocation;
#line 677 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp165_ = _tmp164_.x;
#line 677 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp163_->allocation.x = _tmp165_ + CHECKERBOARD_ITEM_FRAME_WIDTH;
#line 678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp166_ = self->priv->subtitle;
#line 678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp167_ = text_y;
#line 678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp166_->allocation.y = _tmp167_;
#line 679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp168_ = self->priv->subtitle;
#line 679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp169_ = self->priv->pixbuf_dim;
#line 679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp170_ = _tmp169_.width;
#line 679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp168_->allocation.width = _tmp170_;
#line 680 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp171_ = self->priv->subtitle;
#line 680 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp172_ = self->priv->subtitle;
#line 680 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp173_ = checkerboard_item_text_get_height (_tmp172_);
#line 680 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp171_->allocation.height = _tmp173_;
#line 682 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp174_ = ctx;
#line 682 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp175_ = self->priv->subtitle;
#line 682 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp176_ = _tmp175_->allocation;
#line 682 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp177_ = _tmp176_.x;
#line 682 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp178_ = self->priv->subtitle;
#line 682 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp179_ = _tmp178_->allocation;
#line 682 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp180_ = _tmp179_.y;
#line 682 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_move_to (_tmp174_, (gdouble) _tmp177_, (gdouble) _tmp180_);
#line 683 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp181_ = ctx;
#line 683 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp182_ = self->priv->subtitle;
#line 683 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp183_ = self->priv->pixbuf_dim;
#line 683 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp184_ = _tmp183_.width;
#line 683 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp185_ = checkerboard_item_text_get_pango_layout (_tmp182_, _tmp184_);
#line 683 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp186_ = _tmp185_;
#line 683 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_cairo_show_layout (_tmp181_, _tmp186_);
#line 683 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_tmp186_);
#line 4675 "CheckerboardLayout.c"
	}
#line 688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp187_ = ctx;
#line 688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp188_ = *selected_color;
#line 688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp189_ = _tmp188_.red;
#line 688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp190_ = *selected_color;
#line 688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp191_ = _tmp190_.green;
#line 688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp192_ = *selected_color;
#line 688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp193_ = _tmp192_.blue;
#line 688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp194_ = *selected_color;
#line 688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp195_ = _tmp194_.alpha;
#line 688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source_rgba (_tmp187_, _tmp189_, _tmp191_, _tmp193_, _tmp195_);
#line 692 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp196_ = checkerboard_item_get_bottom_left_trinket (self, CHECKERBOARD_ITEM_TRINKET_SCALE);
#line 692 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	trinket = _tmp196_;
#line 693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp197_ = trinket;
#line 693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp197_ != NULL) {
#line 4705 "CheckerboardLayout.c"
		gint x = 0;
		GdkPoint _tmp198_;
		gint _tmp199_;
		gint _tmp200_;
		gint y = 0;
		GdkPoint _tmp201_;
		gint _tmp202_;
		Dimensions _tmp203_;
		gint _tmp204_;
		GdkPixbuf* _tmp205_;
		gint _tmp206_;
		cairo_t* _tmp207_;
		GdkPixbuf* _tmp208_;
		gint _tmp209_;
		gint _tmp210_;
		cairo_t* _tmp211_;
		gint _tmp212_;
		gint _tmp213_;
		GdkPixbuf* _tmp214_;
		gint _tmp215_;
		GdkPixbuf* _tmp216_;
		gint _tmp217_;
		cairo_t* _tmp218_;
#line 694 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp198_ = pixbuf_origin;
#line 694 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp199_ = _tmp198_.x;
#line 694 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp200_ = checkerboard_item_get_horizontal_trinket_offset (self);
#line 694 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = (_tmp199_ + CHECKERBOARD_ITEM_TRINKET_PADDING) + _tmp200_;
#line 695 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp201_ = pixbuf_origin;
#line 695 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp202_ = _tmp201_.y;
#line 695 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp203_ = self->priv->pixbuf_dim;
#line 695 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp204_ = _tmp203_.height;
#line 695 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp205_ = trinket;
#line 695 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp206_ = gdk_pixbuf_get_height (_tmp205_);
#line 695 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = ((_tmp202_ + _tmp204_) - _tmp206_) - CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 697 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp207_ = ctx;
#line 697 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp208_ = trinket;
#line 697 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp209_ = x;
#line 697 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp210_ = y;
#line 697 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gdk_cairo_set_source_pixbuf (_tmp207_, _tmp208_, (gdouble) _tmp209_, (gdouble) _tmp210_);
#line 698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp211_ = ctx;
#line 698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp212_ = x;
#line 698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp213_ = y;
#line 698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp214_ = trinket;
#line 698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp215_ = gdk_pixbuf_get_width (_tmp214_);
#line 698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp216_ = trinket;
#line 698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp217_ = gdk_pixbuf_get_height (_tmp216_);
#line 698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (_tmp211_, (gdouble) _tmp212_, (gdouble) _tmp213_, (gdouble) _tmp215_, (gdouble) _tmp217_);
#line 699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp218_ = ctx;
#line 699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (_tmp218_);
#line 4781 "CheckerboardLayout.c"
	}
#line 702 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp219_ = checkerboard_item_get_top_left_trinket (self, CHECKERBOARD_ITEM_TRINKET_SCALE);
#line 702 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (trinket);
#line 702 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	trinket = _tmp219_;
#line 703 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp220_ = trinket;
#line 703 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp220_ != NULL) {
#line 4793 "CheckerboardLayout.c"
		gint x = 0;
		GdkPoint _tmp221_;
		gint _tmp222_;
		gint _tmp223_;
		gint y = 0;
		GdkPoint _tmp224_;
		gint _tmp225_;
		cairo_t* _tmp226_;
		GdkPixbuf* _tmp227_;
		gint _tmp228_;
		gint _tmp229_;
		cairo_t* _tmp230_;
		gint _tmp231_;
		gint _tmp232_;
		GdkPixbuf* _tmp233_;
		gint _tmp234_;
		GdkPixbuf* _tmp235_;
		gint _tmp236_;
		cairo_t* _tmp237_;
#line 704 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp221_ = pixbuf_origin;
#line 704 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp222_ = _tmp221_.x;
#line 704 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp223_ = checkerboard_item_get_horizontal_trinket_offset (self);
#line 704 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = (_tmp222_ + CHECKERBOARD_ITEM_TRINKET_PADDING) + _tmp223_;
#line 705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp224_ = pixbuf_origin;
#line 705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp225_ = _tmp224_.y;
#line 705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = _tmp225_ + CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 706 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp226_ = ctx;
#line 706 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp227_ = trinket;
#line 706 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp228_ = x;
#line 706 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp229_ = y;
#line 706 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gdk_cairo_set_source_pixbuf (_tmp226_, _tmp227_, (gdouble) _tmp228_, (gdouble) _tmp229_);
#line 707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp230_ = ctx;
#line 707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp231_ = x;
#line 707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp232_ = y;
#line 707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp233_ = trinket;
#line 707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp234_ = gdk_pixbuf_get_width (_tmp233_);
#line 707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp235_ = trinket;
#line 707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp236_ = gdk_pixbuf_get_height (_tmp235_);
#line 707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (_tmp230_, (gdouble) _tmp231_, (gdouble) _tmp232_, (gdouble) _tmp234_, (gdouble) _tmp236_);
#line 708 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp237_ = ctx;
#line 708 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (_tmp237_);
#line 4857 "CheckerboardLayout.c"
	}
#line 711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp238_ = checkerboard_item_get_top_right_trinket (self, CHECKERBOARD_ITEM_TRINKET_SCALE);
#line 711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (trinket);
#line 711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	trinket = _tmp238_;
#line 712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp239_ = trinket;
#line 712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp239_ != NULL) {
#line 4869 "CheckerboardLayout.c"
		gint x = 0;
		GdkPoint _tmp240_;
		gint _tmp241_;
		Dimensions _tmp242_;
		gint _tmp243_;
		GdkPixbuf* _tmp244_;
		gint _tmp245_;
		gint _tmp246_;
		gint _tmp247_;
		gint y = 0;
		GdkPoint _tmp248_;
		gint _tmp249_;
		cairo_t* _tmp250_;
		GdkPixbuf* _tmp251_;
		gint _tmp252_;
		gint _tmp253_;
		cairo_t* _tmp254_;
		gint _tmp255_;
		gint _tmp256_;
		GdkPixbuf* _tmp257_;
		gint _tmp258_;
		GdkPixbuf* _tmp259_;
		gint _tmp260_;
		cairo_t* _tmp261_;
#line 713 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp240_ = pixbuf_origin;
#line 713 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp241_ = _tmp240_.x;
#line 713 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp242_ = self->priv->pixbuf_dim;
#line 713 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp243_ = _tmp242_.width;
#line 713 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp244_ = trinket;
#line 713 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp245_ = gdk_pixbuf_get_width (_tmp244_);
#line 713 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp246_ = _tmp245_;
#line 713 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp247_ = checkerboard_item_get_horizontal_trinket_offset (self);
#line 713 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = (((_tmp241_ + _tmp243_) - _tmp246_) - _tmp247_) - CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 715 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp248_ = pixbuf_origin;
#line 715 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp249_ = _tmp248_.y;
#line 715 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = _tmp249_ + CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 716 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp250_ = ctx;
#line 716 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp251_ = trinket;
#line 716 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp252_ = x;
#line 716 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp253_ = y;
#line 716 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gdk_cairo_set_source_pixbuf (_tmp250_, _tmp251_, (gdouble) _tmp252_, (gdouble) _tmp253_);
#line 717 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp254_ = ctx;
#line 717 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp255_ = x;
#line 717 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp256_ = y;
#line 717 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp257_ = trinket;
#line 717 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp258_ = gdk_pixbuf_get_width (_tmp257_);
#line 717 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp259_ = trinket;
#line 717 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp260_ = gdk_pixbuf_get_height (_tmp259_);
#line 717 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (_tmp254_, (gdouble) _tmp255_, (gdouble) _tmp256_, (gdouble) _tmp258_, (gdouble) _tmp260_);
#line 718 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp261_ = ctx;
#line 718 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (_tmp261_);
#line 4948 "CheckerboardLayout.c"
	}
#line 721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp262_ = checkerboard_item_get_bottom_right_trinket (self, CHECKERBOARD_ITEM_TRINKET_SCALE);
#line 721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (trinket);
#line 721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	trinket = _tmp262_;
#line 722 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp263_ = trinket;
#line 722 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp263_ != NULL) {
#line 4960 "CheckerboardLayout.c"
		gint x = 0;
		GdkPoint _tmp264_;
		gint _tmp265_;
		Dimensions _tmp266_;
		gint _tmp267_;
		GdkPixbuf* _tmp268_;
		gint _tmp269_;
		gint _tmp270_;
		gint _tmp271_;
		gint y = 0;
		GdkPoint _tmp272_;
		gint _tmp273_;
		Dimensions _tmp274_;
		gint _tmp275_;
		GdkPixbuf* _tmp276_;
		gint _tmp277_;
		gint _tmp278_;
		cairo_t* _tmp279_;
		GdkPixbuf* _tmp280_;
		gint _tmp281_;
		gint _tmp282_;
		cairo_t* _tmp283_;
		gint _tmp284_;
		gint _tmp285_;
		GdkPixbuf* _tmp286_;
		gint _tmp287_;
		GdkPixbuf* _tmp288_;
		gint _tmp289_;
		cairo_t* _tmp290_;
#line 723 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp264_ = pixbuf_origin;
#line 723 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp265_ = _tmp264_.x;
#line 723 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp266_ = self->priv->pixbuf_dim;
#line 723 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp267_ = _tmp266_.width;
#line 723 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp268_ = trinket;
#line 723 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp269_ = gdk_pixbuf_get_width (_tmp268_);
#line 723 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp270_ = _tmp269_;
#line 723 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp271_ = checkerboard_item_get_horizontal_trinket_offset (self);
#line 723 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = (((_tmp265_ + _tmp267_) - _tmp270_) - _tmp271_) - CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 725 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp272_ = pixbuf_origin;
#line 725 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp273_ = _tmp272_.y;
#line 725 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp274_ = self->priv->pixbuf_dim;
#line 725 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp275_ = _tmp274_.height;
#line 725 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp276_ = trinket;
#line 725 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp277_ = gdk_pixbuf_get_height (_tmp276_);
#line 725 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp278_ = _tmp277_;
#line 725 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = ((_tmp273_ + _tmp275_) - _tmp278_) - CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 727 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp279_ = ctx;
#line 727 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp280_ = trinket;
#line 727 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp281_ = x;
#line 727 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp282_ = y;
#line 727 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gdk_cairo_set_source_pixbuf (_tmp279_, _tmp280_, (gdouble) _tmp281_, (gdouble) _tmp282_);
#line 728 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp283_ = ctx;
#line 728 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp284_ = x;
#line 728 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp285_ = y;
#line 728 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp286_ = trinket;
#line 728 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp287_ = gdk_pixbuf_get_width (_tmp286_);
#line 728 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp288_ = trinket;
#line 728 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp289_ = gdk_pixbuf_get_height (_tmp288_);
#line 728 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (_tmp283_, (gdouble) _tmp284_, (gdouble) _tmp285_, (gdouble) _tmp287_, (gdouble) _tmp289_);
#line 729 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp290_ = ctx;
#line 729 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (_tmp290_);
#line 5054 "CheckerboardLayout.c"
	}
#line 590 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (trinket);
#line 5058 "CheckerboardLayout.c"
}


void checkerboard_item_set_horizontal_trinket_offset (CheckerboardItem* self, gint horizontal_trinket_offset) {
	gint _tmp0_;
	gint _tmp1_;
#line 733 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 734 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = horizontal_trinket_offset;
#line 734 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (_tmp0_ >= 0, "horizontal_trinket_offset >= 0");
#line 735 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = horizontal_trinket_offset;
#line 735 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->horizontal_trinket_offset = _tmp1_;
#line 5075 "CheckerboardLayout.c"
}


gint checkerboard_item_get_horizontal_trinket_offset (CheckerboardItem* self) {
	gint result = 0;
	gint _tmp0_;
#line 738 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
#line 739 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->horizontal_trinket_offset;
#line 739 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 739 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 5090 "CheckerboardLayout.c"
}


void checkerboard_item_set_grid_coordinates (CheckerboardItem* self, gint col, gint row) {
	gint _tmp0_;
	gint _tmp1_;
#line 742 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 743 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = col;
#line 743 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->col = _tmp0_;
#line 744 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = row;
#line 744 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->row = _tmp1_;
#line 5107 "CheckerboardLayout.c"
}


gint checkerboard_item_get_column (CheckerboardItem* self) {
	gint result = 0;
	gint _tmp0_;
#line 747 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
#line 748 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->col;
#line 748 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 748 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 5122 "CheckerboardLayout.c"
}


gint checkerboard_item_get_row (CheckerboardItem* self) {
	gint result = 0;
	gint _tmp0_;
#line 751 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
#line 752 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->row;
#line 752 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 752 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 5137 "CheckerboardLayout.c"
}


void checkerboard_item_brighten (CheckerboardItem* self) {
	gboolean _tmp0_ = FALSE;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
#line 755 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 757 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->brightened;
#line 757 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 757 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = TRUE;
#line 5157 "CheckerboardLayout.c"
	} else {
		GdkPixbuf* _tmp2_;
#line 757 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->pixbuf;
#line 757 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 5164 "CheckerboardLayout.c"
	}
#line 757 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 758 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 5170 "CheckerboardLayout.c"
	}
#line 761 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->pixbuf;
#line 761 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = gdk_pixbuf_copy (_tmp3_);
#line 761 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->brightened);
#line 761 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->brightened = _tmp4_;
#line 762 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = self->priv->brightened;
#line 762 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	shift_colors (_tmp5_, CHECKERBOARD_ITEM_BRIGHTEN_SHIFT, CHECKERBOARD_ITEM_BRIGHTEN_SHIFT, CHECKERBOARD_ITEM_BRIGHTEN_SHIFT, 0);
#line 764 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = self->priv->brightened;
#line 764 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 764 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->display_pixbuf);
#line 764 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->display_pixbuf = _tmp7_;
#line 766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 5194 "CheckerboardLayout.c"
}


void checkerboard_item_unbrighten (CheckerboardItem* self) {
	gboolean _tmp0_ = FALSE;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
#line 769 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->brightened;
#line 771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ == NULL) {
#line 771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = TRUE;
#line 5211 "CheckerboardLayout.c"
	} else {
		GdkPixbuf* _tmp2_;
#line 771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->pixbuf;
#line 771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 5218 "CheckerboardLayout.c"
	}
#line 771 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 772 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 5224 "CheckerboardLayout.c"
	}
#line 774 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->brightened);
#line 774 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->brightened = NULL;
#line 777 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->pixbuf;
#line 777 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 777 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->display_pixbuf);
#line 777 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->display_pixbuf = _tmp4_;
#line 779 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 5240 "CheckerboardLayout.c"
}


static void checkerboard_item_real_visibility_changed (DataView* base, gboolean visible) {
	CheckerboardItem * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 782 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 784 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = visible;
#line 784 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp0_) {
#line 785 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_unbrighten (self);
#line 5256 "CheckerboardLayout.c"
	}
#line 787 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = visible;
#line 787 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	DATA_VIEW_CLASS (checkerboard_item_parent_class)->visibility_changed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView), TYPE_DATA_VIEW, DataView), _tmp1_);
#line 5262 "CheckerboardLayout.c"
}


static gboolean checkerboard_item_query_tooltip_on_text (CheckerboardItem* self, CheckerboardItemText* text, GtkTooltip* tooltip) {
	gboolean result = FALSE;
	CheckerboardItemText* _tmp0_;
	PangoLayout* _tmp1_;
	PangoLayout* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	CheckerboardItemText* _tmp5_;
	gboolean _tmp6_;
#line 790 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
#line 790 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (text), FALSE);
#line 790 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (GTK_IS_TOOLTIP (tooltip), FALSE);
#line 791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = text;
#line 791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = checkerboard_item_text_get_pango_layout (_tmp0_, 0);
#line 791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_;
#line 791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = pango_layout_is_ellipsized (_tmp2_);
#line 791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = !_tmp3_;
#line 791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp2_);
#line 791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_) {
#line 792 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = FALSE;
#line 792 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 5299 "CheckerboardLayout.c"
	}
#line 794 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = text;
#line 794 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = checkerboard_item_text_is_marked_up (_tmp5_);
#line 794 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp6_) {
#line 5307 "CheckerboardLayout.c"
		GtkTooltip* _tmp7_;
		CheckerboardItemText* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 795 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = tooltip;
#line 795 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = text;
#line 795 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = checkerboard_item_text_get_text (_tmp8_);
#line 795 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = _tmp9_;
#line 795 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_tooltip_set_markup (_tmp7_, _tmp10_);
#line 795 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp10_);
#line 5324 "CheckerboardLayout.c"
	} else {
		GtkTooltip* _tmp11_;
		CheckerboardItemText* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
#line 797 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = tooltip;
#line 797 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = text;
#line 797 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = checkerboard_item_text_get_text (_tmp12_);
#line 797 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = _tmp13_;
#line 797 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_tooltip_set_text (_tmp11_, _tmp14_);
#line 797 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp14_);
#line 5342 "CheckerboardLayout.c"
	}
#line 799 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = TRUE;
#line 799 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 5348 "CheckerboardLayout.c"
}


gboolean checkerboard_item_query_tooltip (CheckerboardItem* self, gint x, gint y, GtkTooltip* tooltip) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	CheckerboardItemText* _tmp2_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	CheckerboardItemText* _tmp14_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	CheckerboardItemText* _tmp26_;
#line 802 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
#line 802 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (GTK_IS_TOOLTIP (tooltip), FALSE);
#line 803 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->title;
#line 803 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ != NULL) {
#line 5371 "CheckerboardLayout.c"
		gboolean _tmp3_;
#line 803 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->title_visible;
#line 803 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = _tmp3_;
#line 5377 "CheckerboardLayout.c"
	} else {
#line 803 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = FALSE;
#line 5381 "CheckerboardLayout.c"
	}
#line 803 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 5385 "CheckerboardLayout.c"
		gint _tmp4_;
		gint _tmp5_;
		CheckerboardItemText* _tmp6_;
		GdkRectangle _tmp7_;
		gboolean _tmp8_;
#line 803 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = x;
#line 803 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = y;
#line 803 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = self->priv->title;
#line 803 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = _tmp6_->allocation;
#line 803 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = coord_in_rectangle (_tmp4_, _tmp5_, &_tmp7_);
#line 803 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp8_;
#line 5403 "CheckerboardLayout.c"
	} else {
#line 803 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 5407 "CheckerboardLayout.c"
	}
#line 803 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 5411 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp9_;
		GtkTooltip* _tmp10_;
		gboolean _tmp11_;
#line 804 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = self->priv->title;
#line 804 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = tooltip;
#line 804 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = checkerboard_item_query_tooltip_on_text (self, _tmp9_, _tmp10_);
#line 804 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = _tmp11_;
#line 804 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 5425 "CheckerboardLayout.c"
	}
#line 806 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = self->priv->comment;
#line 806 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp14_ != NULL) {
#line 5431 "CheckerboardLayout.c"
		gboolean _tmp15_;
#line 806 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = self->priv->comment_visible;
#line 806 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = _tmp15_;
#line 5437 "CheckerboardLayout.c"
	} else {
#line 806 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = FALSE;
#line 5441 "CheckerboardLayout.c"
	}
#line 806 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp13_) {
#line 5445 "CheckerboardLayout.c"
		gint _tmp16_;
		gint _tmp17_;
		CheckerboardItemText* _tmp18_;
		GdkRectangle _tmp19_;
		gboolean _tmp20_;
#line 806 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp16_ = x;
#line 806 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = y;
#line 806 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = self->priv->comment;
#line 806 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = _tmp18_->allocation;
#line 806 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = coord_in_rectangle (_tmp16_, _tmp17_, &_tmp19_);
#line 806 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = _tmp20_;
#line 5463 "CheckerboardLayout.c"
	} else {
#line 806 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = FALSE;
#line 5467 "CheckerboardLayout.c"
	}
#line 806 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp12_) {
#line 5471 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp21_;
		GtkTooltip* _tmp22_;
		gboolean _tmp23_;
#line 807 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = self->priv->comment;
#line 807 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = tooltip;
#line 807 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp23_ = checkerboard_item_query_tooltip_on_text (self, _tmp21_, _tmp22_);
#line 807 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = _tmp23_;
#line 807 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 5485 "CheckerboardLayout.c"
	}
#line 809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp26_ = self->priv->subtitle;
#line 809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp26_ != NULL) {
#line 5491 "CheckerboardLayout.c"
		gboolean _tmp27_;
#line 809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp27_ = self->priv->subtitle_visible;
#line 809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp25_ = _tmp27_;
#line 5497 "CheckerboardLayout.c"
	} else {
#line 809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp25_ = FALSE;
#line 5501 "CheckerboardLayout.c"
	}
#line 809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp25_) {
#line 5505 "CheckerboardLayout.c"
		gint _tmp28_;
		gint _tmp29_;
		CheckerboardItemText* _tmp30_;
		GdkRectangle _tmp31_;
		gboolean _tmp32_;
#line 809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp28_ = x;
#line 809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp29_ = y;
#line 809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp30_ = self->priv->subtitle;
#line 809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp31_ = _tmp30_->allocation;
#line 809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp32_ = coord_in_rectangle (_tmp28_, _tmp29_, &_tmp31_);
#line 809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp24_ = _tmp32_;
#line 5523 "CheckerboardLayout.c"
	} else {
#line 809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp24_ = FALSE;
#line 5527 "CheckerboardLayout.c"
	}
#line 809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp24_) {
#line 5531 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp33_;
		GtkTooltip* _tmp34_;
		gboolean _tmp35_;
#line 810 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp33_ = self->priv->subtitle;
#line 810 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp34_ = tooltip;
#line 810 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp35_ = checkerboard_item_query_tooltip_on_text (self, _tmp33_, _tmp34_);
#line 810 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = _tmp35_;
#line 810 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 5545 "CheckerboardLayout.c"
	}
#line 812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = FALSE;
#line 812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 5551 "CheckerboardLayout.c"
}


gboolean checkerboard_item_get_has_tags (CheckerboardItem* self) {
	gboolean result;
	gboolean _tmp0_;
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->_has_tags;
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 5566 "CheckerboardLayout.c"
}


static void checkerboard_item_set_has_tags (CheckerboardItem* self, gboolean value) {
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (checkerboard_item_get_has_tags (self) != value) {
#line 5575 "CheckerboardLayout.c"
		gboolean _tmp0_;
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = value;
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->_has_tags = _tmp0_;
#line 161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_object_notify ((GObject *) self, "has-tags");
#line 5583 "CheckerboardLayout.c"
	}
}


static void checkerboard_item_class_init (CheckerboardItemClass * klass) {
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_parent_class = g_type_class_peek_parent (klass);
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_type_class_add_private (klass, sizeof (CheckerboardItemPrivate));
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((DataObjectClass *) klass)->get_name = (gchar* (*) (DataObject *)) checkerboard_item_real_get_name;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((DataObjectClass *) klass)->notify_membership_changed = (void (*) (DataObject *, DataCollection*)) checkerboard_item_real_notify_membership_changed;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((DataObjectClass *) klass)->notify_collection_property_set = (void (*) (DataObject *, const gchar*, GValue*, GValue*)) checkerboard_item_real_notify_collection_property_set;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->exposed = (void (*) (CheckerboardItem *)) checkerboard_item_real_exposed;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->unexposed = (void (*) (CheckerboardItem *)) checkerboard_item_real_unexposed;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->is_exposed = (gboolean (*) (CheckerboardItem *)) checkerboard_item_real_is_exposed;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->paint_shadow = (void (*) (CheckerboardItem *, cairo_t*, Dimensions*, GdkPoint*, gint, gfloat)) checkerboard_item_real_paint_shadow;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->paint_border = (void (*) (CheckerboardItem *, cairo_t*, Dimensions*, GdkPoint*, gint)) checkerboard_item_real_paint_border;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->paint_image = (void (*) (CheckerboardItem *, cairo_t*, GdkPixbuf*, GdkPoint*)) checkerboard_item_real_paint_image;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->get_top_left_trinket = (GdkPixbuf* (*) (CheckerboardItem *, gint)) checkerboard_item_real_get_top_left_trinket;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->get_top_right_trinket = (GdkPixbuf* (*) (CheckerboardItem *, gint)) checkerboard_item_real_get_top_right_trinket;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->get_bottom_left_trinket = (GdkPixbuf* (*) (CheckerboardItem *, gint)) checkerboard_item_real_get_bottom_left_trinket;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->get_bottom_right_trinket = (GdkPixbuf* (*) (CheckerboardItem *, gint)) checkerboard_item_real_get_bottom_right_trinket;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((DataViewClass *) klass)->visibility_changed = (void (*) (DataView *, gboolean)) checkerboard_item_real_visibility_changed;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_checkerboard_item_get_property;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_checkerboard_item_set_property;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_OBJECT_CLASS (klass)->finalize = checkerboard_item_finalize;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHECKERBOARD_ITEM_HAS_TAGS_PROPERTY, g_param_spec_boolean ("has-tags", "has-tags", "has-tags", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 5629 "CheckerboardLayout.c"
}


static void checkerboard_item_instance_init (CheckerboardItem * self) {
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv = CHECKERBOARD_ITEM_GET_PRIVATE (self);
#line 119 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions_init (&self->requisition, 0, 0);
#line 120 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->allocation, 0, sizeof (GdkRectangle));
#line 122 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure = FALSE;
#line 123 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title = NULL;
#line 124 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title_visible = TRUE;
#line 125 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->comment = NULL;
#line 126 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->comment_visible = TRUE;
#line 127 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle = NULL;
#line 128 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle_visible = FALSE;
#line 129 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->is_cursor = FALSE;
#line 130 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->tag_alignment = PANGO_ALIGN_LEFT;
#line 131 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->user_visible_tag_list = NULL;
#line 133 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf = NULL;
#line 134 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->display_pixbuf = NULL;
#line 135 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->brightened = NULL;
#line 136 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions_init (&self->priv->pixbuf_dim, 0, 0);
#line 137 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->col = -1;
#line 138 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->row = -1;
#line 139 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->horizontal_trinket_offset = 0;
#line 5674 "CheckerboardLayout.c"
}


static void checkerboard_item_finalize (GObject * obj) {
	CheckerboardItem * self;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 123 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->title);
#line 125 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->comment);
#line 127 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->subtitle);
#line 131 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->user_visible_tag_list);
#line 132 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->tags);
#line 133 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->pixbuf);
#line 134 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->display_pixbuf);
#line 135 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->brightened);
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_OBJECT_CLASS (checkerboard_item_parent_class)->finalize (obj);
#line 5700 "CheckerboardLayout.c"
}


GType checkerboard_item_get_type (void) {
	static volatile gsize checkerboard_item_type_id__volatile = 0;
	if (g_once_init_enter (&checkerboard_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheckerboardItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) checkerboard_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckerboardItem), 0, (GInstanceInitFunc) checkerboard_item_instance_init, NULL };
		GType checkerboard_item_type_id;
		checkerboard_item_type_id = g_type_register_static (TYPE_THUMBNAIL_VIEW, "CheckerboardItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&checkerboard_item_type_id__volatile, checkerboard_item_type_id);
	}
	return checkerboard_item_type_id__volatile;
}


static void _vala_checkerboard_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CheckerboardItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	switch (property_id) {
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		case CHECKERBOARD_ITEM_HAS_TAGS_PROPERTY:
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_value_set_boolean (value, checkerboard_item_get_has_tags (self));
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		break;
#line 5727 "CheckerboardLayout.c"
		default:
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		break;
#line 5733 "CheckerboardLayout.c"
	}
}


static void _vala_checkerboard_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CheckerboardItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	switch (property_id) {
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		case CHECKERBOARD_ITEM_HAS_TAGS_PROPERTY:
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_set_has_tags (self, g_value_get_boolean (value));
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		break;
#line 5749 "CheckerboardLayout.c"
		default:
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		break;
#line 5755 "CheckerboardLayout.c"
	}
}


static void _checkerboard_layout_on_contents_altered_data_collection_contents_altered (DataCollection* _sender, GeeIterable* added, GeeIterable* removed, gpointer self) {
#line 902 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_contents_altered ((CheckerboardLayout*) self, added, removed);
#line 5763 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_items_altered_data_collection_items_altered (DataCollection* _sender, GeeMap* items, gpointer self) {
#line 903 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_altered ((CheckerboardLayout*) self);
#line 5770 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_items_state_changed_view_collection_items_state_changed (ViewCollection* _sender, GeeIterable* changed, gpointer self) {
#line 904 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_state_changed ((CheckerboardLayout*) self, changed);
#line 5777 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed (ViewCollection* _sender, GeeCollection* changed, gpointer self) {
#line 905 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_visibility_changed ((CheckerboardLayout*) self, changed);
#line 5784 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_ordering_changed_data_collection_ordering_changed (DataCollection* _sender, gpointer self) {
#line 906 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_ordering_changed ((CheckerboardLayout*) self);
#line 5791 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_views_altered_view_collection_views_altered (ViewCollection* _sender, GeeCollection* views, gpointer self) {
#line 907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_views_altered ((CheckerboardLayout*) self, views);
#line 5798 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_geometries_altered_view_collection_geometries_altered (ViewCollection* _sender, GeeCollection* views, gpointer self) {
#line 908 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_geometries_altered ((CheckerboardLayout*) self);
#line 5805 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_items_selection_changed_view_collection_items_selected (ViewCollection* _sender, GeeIterable* selected, gpointer self) {
#line 909 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_selection_changed ((CheckerboardLayout*) self);
#line 5812 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_items_selection_changed_view_collection_items_unselected (ViewCollection* _sender, GeeIterable* unselected, gpointer self) {
#line 910 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_selection_changed ((CheckerboardLayout*) self);
#line 5819 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
#line 913 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_viewport_shifted ((CheckerboardLayout*) self);
#line 5826 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
#line 919 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_viewport_resized ((CheckerboardLayout*) self);
#line 5833 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_colors_changed_config_facade_colors_changed (ConfigFacade* _sender, gpointer self) {
#line 921 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_colors_changed ((CheckerboardLayout*) self);
#line 5840 "CheckerboardLayout.c"
}


static gpointer _data_collection_ref0 (gpointer self) {
#line 874 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self ? data_collection_ref (self) : NULL;
#line 5847 "CheckerboardLayout.c"
}


CheckerboardLayout* checkerboard_layout_construct (GType object_type, ViewCollection* view) {
	CheckerboardLayout * self = NULL;
	ViewCollection* _tmp0_;
	ViewCollection* _tmp1_;
	ViewCollection* _tmp2_;
	ViewCollection* _tmp3_;
	ViewCollection* _tmp4_;
	ViewCollection* _tmp5_;
	ViewCollection* _tmp6_;
	ViewCollection* _tmp7_;
	ViewCollection* _tmp8_;
	ViewCollection* _tmp9_;
	ViewCollection* _tmp10_;
	ConfigFacade* _tmp11_;
	ConfigFacade* _tmp12_;
	GdkRGBA _tmp13_ = {0};
	ConfigFacade* _tmp14_;
	ConfigFacade* _tmp15_;
#line 873 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (view), NULL);
#line 873 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = (CheckerboardLayout*) g_object_new (object_type, NULL);
#line 874 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = view;
#line 874 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _data_collection_ref0 (_tmp0_);
#line 874 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_data_collection_unref0 (self->priv->view);
#line 874 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->view = _tmp1_;
#line 876 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_clear_drag_select (self);
#line 879 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = view;
#line 879 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_COLLECTION, DataCollection), "contents-altered", (GCallback) _checkerboard_layout_on_contents_altered_data_collection_contents_altered, self, 0);
#line 880 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = view;
#line 880 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_COLLECTION, DataCollection), "items-altered", (GCallback) _checkerboard_layout_on_items_altered_data_collection_items_altered, self, 0);
#line 881 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = view;
#line 881 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp4_, "items-state-changed", (GCallback) _checkerboard_layout_on_items_state_changed_view_collection_items_state_changed, self, 0);
#line 882 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = view;
#line 882 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp5_, "items-visibility-changed", (GCallback) _checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed, self, 0);
#line 883 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = view;
#line 883 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_COLLECTION, DataCollection), "ordering-changed", (GCallback) _checkerboard_layout_on_ordering_changed_data_collection_ordering_changed, self, 0);
#line 884 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = view;
#line 884 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp7_, "views-altered", (GCallback) _checkerboard_layout_on_views_altered_view_collection_views_altered, self, 0);
#line 885 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = view;
#line 885 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp8_, "geometries-altered", (GCallback) _checkerboard_layout_on_geometries_altered_view_collection_geometries_altered, self, 0);
#line 886 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = view;
#line 886 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp9_, "items-selected", (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_selected, self, 0);
#line 887 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = view;
#line 887 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp10_, "items-unselected", (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_unselected, self, 0);
#line 889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = config_facade_get_instance ();
#line 889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = _tmp11_;
#line 889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	config_facade_get_bg_color (_tmp12_, &_tmp13_);
#line 889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_override_background_color (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), GTK_STATE_FLAG_NORMAL, &_tmp13_);
#line 889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp12_);
#line 891 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = config_facade_get_instance ();
#line 891 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = _tmp14_;
#line 891 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp15_, "colors-changed", (GCallback) _checkerboard_layout_on_colors_changed_config_facade_colors_changed, self, 0);
#line 891 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp15_);
#line 894 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_set_has_tooltip (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), TRUE);
#line 873 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self;
#line 5941 "CheckerboardLayout.c"
}


CheckerboardLayout* checkerboard_layout_new (ViewCollection* view) {
#line 873 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return checkerboard_layout_construct (TYPE_CHECKERBOARD_LAYOUT, view);
#line 5948 "CheckerboardLayout.c"
}


void checkerboard_layout_set_adjustments (CheckerboardLayout* self, GtkAdjustment* hadjustment, GtkAdjustment* vadjustment) {
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	GtkAdjustment* _tmp2_;
	GtkAdjustment* _tmp3_;
	GtkAdjustment* _tmp4_;
	GtkAdjustment* _tmp5_;
	GtkContainer* _tmp6_;
	GtkContainer* _tmp7_;
#line 924 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 924 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GTK_IS_ADJUSTMENT (hadjustment));
#line 924 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GTK_IS_ADJUSTMENT (vadjustment));
#line 925 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = hadjustment;
#line 925 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 925 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->hadjustment);
#line 925 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->hadjustment = _tmp1_;
#line 926 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = vadjustment;
#line 926 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 926 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->vadjustment);
#line 926 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->vadjustment = _tmp3_;
#line 929 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = hadjustment;
#line 929 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp4_, "value-changed", (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self, 0);
#line 930 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = vadjustment;
#line 930 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp5_, "value-changed", (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self, 0);
#line 933 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 933 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = _tmp6_;
#line 933 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), "size-allocate", (GCallback) _checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate, self, 0);
#line 5997 "CheckerboardLayout.c"
}


void checkerboard_layout_set_scale (CheckerboardLayout* self, gint scale) {
	gint _tmp0_;
#line 938 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 939 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = scale;
#line 939 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->scale = _tmp0_;
#line 6009 "CheckerboardLayout.c"
}


gint checkerboard_layout_get_scale (CheckerboardLayout* self) {
	gint result = 0;
	gint _tmp0_;
#line 942 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), 0);
#line 943 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->scale;
#line 943 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 943 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 6024 "CheckerboardLayout.c"
}


void checkerboard_layout_set_name (CheckerboardLayout* self, const gchar* name) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (name != NULL);
#line 947 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = name;
#line 947 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 947 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->page_name);
#line 947 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->page_name = _tmp1_;
#line 6043 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_viewport_resized (CheckerboardLayout* self) {
	GtkRequisition req = {0};
	GtkRequisition _tmp0_ = {0};
	GtkAllocation parent_allocation = {0};
	GtkContainer* _tmp1_;
	GtkContainer* _tmp2_;
	GtkAllocation _tmp3_ = {0};
	const gchar* _tmp4_;
	gboolean _tmp15_;
#line 950 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 952 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_preferred_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), NULL, &_tmp0_);
#line 952 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	req = _tmp0_;
#line 955 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 955 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_;
#line 955 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), &_tmp3_);
#line 955 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	parent_allocation = _tmp3_;
#line 957 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = self->priv->message;
#line 957 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_ == NULL) {
#line 6074 "CheckerboardLayout.c"
		GtkRequisition _tmp5_;
		gint _tmp6_;
#line 966 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = req;
#line 966 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = _tmp5_.height;
#line 966 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp6_ != 0) {
#line 6083 "CheckerboardLayout.c"
			GtkAllocation _tmp7_;
			gint _tmp8_;
			GtkRequisition _tmp9_;
			gint _tmp10_;
#line 967 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp7_ = parent_allocation;
#line 967 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp8_ = _tmp7_.width;
#line 967 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp9_ = req;
#line 967 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = _tmp9_.height;
#line 967 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp8_ - CHECKERBOARD_LAYOUT_SCROLLBAR_PLACEHOLDER_WIDTH, _tmp10_);
#line 6098 "CheckerboardLayout.c"
		}
	} else {
		GtkAllocation _tmp11_;
		gint _tmp12_;
		GtkAllocation _tmp13_;
		gint _tmp14_;
#line 971 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = parent_allocation;
#line 971 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = _tmp11_.width;
#line 971 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = parent_allocation;
#line 971 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = _tmp13_.height;
#line 971 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp12_, _tmp14_);
#line 6115 "CheckerboardLayout.c"
	}
#line 976 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_viewport_resized (self);
#line 978 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = self->priv->size_allocate_due_to_reflow;
#line 978 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp15_) {
#line 979 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_clear_anchor (self);
#line 6125 "CheckerboardLayout.c"
	} else {
#line 981 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->size_allocate_due_to_reflow = FALSE;
#line 6129 "CheckerboardLayout.c"
	}
}


static void checkerboard_layout_on_viewport_shifted (CheckerboardLayout* self) {
#line 984 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 985 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_update_visible_page (self);
#line 986 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_exposure (self, "on_viewport_shift");
#line 988 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_clear_anchor (self);
#line 6143 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_items_selection_changed (CheckerboardLayout* self) {
#line 991 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 992 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_clear_anchor (self);
#line 6152 "CheckerboardLayout.c"
}


static void checkerboard_layout_clear_anchor (CheckerboardLayout* self) {
	gboolean _tmp0_;
#line 995 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 996 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->in_center_on_anchor;
#line 996 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 997 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6166 "CheckerboardLayout.c"
	}
#line 999 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->anchor);
#line 999 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->anchor = NULL;
#line 6172 "CheckerboardLayout.c"
}


static void checkerboard_layout_update_anchor (CheckerboardLayout* self) {
	gboolean _tmp0_;
	GeeList* items_on_page = NULL;
	GdkRectangle _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GtkAdjustment* _tmp21_;
	gdouble _tmp22_;
	GeeList* _tmp23_;
	GeeList* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gpointer _tmp27_;
#line 1002 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1003 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->in_center_on_anchor;
#line 1003 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (!_tmp0_, "!in_center_on_anchor");
#line 1005 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->visible_page;
#line 1005 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = checkerboard_layout_intersection (self, &_tmp1_);
#line 1005 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	items_on_page = _tmp2_;
#line 1006 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = items_on_page;
#line 1006 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1006 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _tmp4_;
#line 1006 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp5_ == 0) {
#line 1007 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (self->priv->anchor);
#line 1007 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->anchor = NULL;
#line 1008 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (items_on_page);
#line 1008 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6219 "CheckerboardLayout.c"
	}
	{
		GeeList* _item_list = NULL;
		GeeList* _tmp6_;
		GeeList* _tmp7_;
		gint _item_size = 0;
		GeeList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _item_index = 0;
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = items_on_page;
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = _g_object_ref0 (_tmp6_);
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_list = _tmp7_;
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = _item_list;
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = _tmp9_;
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_size = _tmp10_;
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_index = -1;
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 6248 "CheckerboardLayout.c"
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			CheckerboardItem* item = NULL;
			GeeList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_;
			CheckerboardItem* _tmp17_;
			gboolean _tmp18_;
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = _item_index;
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_item_index = _tmp11_ + 1;
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp12_ = _item_index;
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp13_ = _item_size;
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!(_tmp12_ < _tmp13_)) {
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 6270 "CheckerboardLayout.c"
			}
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp14_ = _item_list;
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp15_ = _item_index;
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp16_ = gee_list_get (_tmp14_, _tmp15_);
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = (CheckerboardItem*) _tmp16_;
#line 1012 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp17_ = item;
#line 1012 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp18_ = data_view_is_selected (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_DATA_VIEW, DataView));
#line 1012 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp18_) {
#line 6286 "CheckerboardLayout.c"
				CheckerboardItem* _tmp19_;
				CheckerboardItem* _tmp20_;
#line 1013 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = item;
#line 1013 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp20_ = _g_object_ref0 (_tmp19_);
#line 1013 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (self->priv->anchor);
#line 1013 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				self->priv->anchor = _tmp20_;
#line 1014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 1014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (_item_list);
#line 1014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (items_on_page);
#line 1014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				return;
#line 6305 "CheckerboardLayout.c"
			}
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (item);
#line 6309 "CheckerboardLayout.c"
		}
#line 1011 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_item_list);
#line 6313 "CheckerboardLayout.c"
	}
#line 1018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = self->priv->vadjustment;
#line 1018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp22_ = gtk_adjustment_get_value (_tmp21_);
#line 1018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp22_ == ((gdouble) 0)) {
#line 1019 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (self->priv->anchor);
#line 1019 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->anchor = NULL;
#line 1020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (items_on_page);
#line 1020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6329 "CheckerboardLayout.c"
	}
#line 1025 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp23_ = items_on_page;
#line 1025 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp24_ = items_on_page;
#line 1025 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp25_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1025 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp26_ = _tmp25_;
#line 1025 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp27_ = gee_list_get (_tmp23_, ((gint) _tmp26_) / 2);
#line 1025 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->anchor);
#line 1025 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->anchor = (CheckerboardItem*) _tmp27_;
#line 1002 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (items_on_page);
#line 6347 "CheckerboardLayout.c"
}


static void checkerboard_layout_center_on_anchor (CheckerboardLayout* self, gdouble upper) {
	CheckerboardItem* _tmp0_;
	gdouble anchor_pos = 0.0;
	CheckerboardItem* _tmp1_;
	GdkRectangle _tmp2_;
	gint _tmp3_;
	CheckerboardItem* _tmp4_;
	GdkRectangle _tmp5_;
	gint _tmp6_;
	GtkAdjustment* _tmp7_;
	gdouble _tmp8_;
	GtkAdjustment* _tmp9_;
	gdouble _tmp10_;
	GtkAdjustment* _tmp11_;
	gdouble _tmp12_;
	GtkAdjustment* _tmp13_;
	gdouble _tmp14_;
	GtkAdjustment* _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
#line 1028 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1029 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->anchor;
#line 1029 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == NULL) {
#line 1030 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6379 "CheckerboardLayout.c"
	}
#line 1032 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->in_center_on_anchor = TRUE;
#line 1034 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->anchor;
#line 1034 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_->allocation;
#line 1034 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_.y;
#line 1034 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = self->priv->anchor;
#line 1034 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _tmp4_->allocation;
#line 1034 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = _tmp5_.height;
#line 1034 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = self->priv->vadjustment;
#line 1034 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = gtk_adjustment_get_page_size (_tmp7_);
#line 1034 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	anchor_pos = (_tmp3_ + (_tmp6_ / 2)) - (_tmp8_ / 2);
#line 1036 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->vadjustment;
#line 1036 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = anchor_pos;
#line 1036 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = self->priv->vadjustment;
#line 1036 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = gtk_adjustment_get_lower (_tmp11_);
#line 1036 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = self->priv->vadjustment;
#line 1036 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = gtk_adjustment_get_upper (_tmp13_);
#line 1036 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = self->priv->vadjustment;
#line 1036 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = gtk_adjustment_get_page_size (_tmp15_);
#line 1036 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp17_ = CLAMP (_tmp10_, _tmp12_, _tmp14_ - _tmp16_);
#line 1036 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_adjustment_set_value (_tmp9_, _tmp17_);
#line 1039 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->in_center_on_anchor = FALSE;
#line 6423 "CheckerboardLayout.c"
}


void checkerboard_layout_set_cursor (CheckerboardLayout* self, CheckerboardItem* item) {
	GeeHashSet* collection = NULL;
	GeeHashSet* _tmp0_;
	CheckerboardItem* _tmp1_;
	CheckerboardItem* _tmp8_;
	CheckerboardItem* _tmp9_;
	CheckerboardItem* _tmp10_;
	GeeHashSet* _tmp11_;
	CheckerboardItem* _tmp12_;
	GeeHashSet* _tmp13_;
#line 1042 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1042 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (item));
#line 1043 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = gee_hash_set_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 1043 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	collection = _tmp0_;
#line 1044 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->cursor;
#line 1044 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 6449 "CheckerboardLayout.c"
		CheckerboardItem* _tmp2_;
		ViewCollection* _tmp3_;
		CheckerboardItem* _tmp4_;
		gboolean _tmp5_;
#line 1045 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->cursor;
#line 1045 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_set_is_cursor (_tmp2_, FALSE);
#line 1047 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->view;
#line 1047 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->cursor;
#line 1047 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = data_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_OBJECT, DataObject));
#line 1047 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp5_) {
#line 6466 "CheckerboardLayout.c"
			GeeHashSet* _tmp6_;
			CheckerboardItem* _tmp7_;
#line 1048 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp6_ = collection;
#line 1048 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp7_ = self->priv->cursor;
#line 1048 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_VIEW, DataView));
#line 6475 "CheckerboardLayout.c"
		}
	}
#line 1051 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = item;
#line 1051 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_set_is_cursor (_tmp8_, TRUE);
#line 1052 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = item;
#line 1052 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 1052 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->cursor);
#line 1052 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->cursor = _tmp10_;
#line 1053 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = collection;
#line 1053 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = item;
#line 1053 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_DATA_VIEW, DataView));
#line 1054 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = collection;
#line 1054 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_state_changed (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1042 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (collection);
#line 6502 "CheckerboardLayout.c"
}


CheckerboardItem* checkerboard_layout_get_cursor (CheckerboardLayout* self) {
	CheckerboardItem* result = NULL;
	CheckerboardItem* _tmp0_;
	CheckerboardItem* _tmp1_;
#line 1057 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1058 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->cursor;
#line 1058 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 1058 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp1_;
#line 1058 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 6520 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_contents_altered (CheckerboardLayout* self, GeeIterable* added, GeeIterable* removed) {
	GeeIterable* _tmp0_;
	GeeIterable* _tmp1_;
#line 1062 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1062 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_ITERABLE (added));
#line 1062 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_ITERABLE (removed));
#line 1064 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = added;
#line 1064 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ != NULL) {
#line 1065 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (self->priv->message);
#line 1065 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->message = NULL;
#line 6541 "CheckerboardLayout.c"
	}
#line 1067 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = removed;
#line 1067 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 6547 "CheckerboardLayout.c"
		{
			GeeIterator* _object_it = NULL;
			GeeIterable* _tmp2_;
			GeeIterator* _tmp3_;
#line 1068 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp2_ = removed;
#line 1068 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp3_ = gee_iterable_iterator (_tmp2_);
#line 1068 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_object_it = _tmp3_;
#line 1068 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			while (TRUE) {
#line 6560 "CheckerboardLayout.c"
				GeeIterator* _tmp4_;
				gboolean _tmp5_;
				DataObject* object = NULL;
				GeeIterator* _tmp6_;
				gpointer _tmp7_;
				GeeHashSet* _tmp8_;
				DataObject* _tmp9_;
#line 1068 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp4_ = _object_it;
#line 1068 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp5_ = gee_iterator_next (_tmp4_);
#line 1068 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!_tmp5_) {
#line 1068 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 6576 "CheckerboardLayout.c"
				}
#line 1068 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp6_ = _object_it;
#line 1068 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp7_ = gee_iterator_get (_tmp6_);
#line 1068 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				object = (DataObject*) _tmp7_;
#line 1069 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp8_ = self->priv->exposed_items;
#line 1069 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp9_ = object;
#line 1069 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 1068 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (object);
#line 6592 "CheckerboardLayout.c"
			}
#line 1068 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (_object_it);
#line 6596 "CheckerboardLayout.c"
		}
	}
#line 1074 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
#line 1074 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = NULL;
#line 1074 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows_length1 = 0;
#line 1074 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
#line 1076 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_reflow (self, "on_contents_altered");
#line 6609 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_items_altered (CheckerboardLayout* self) {
#line 1079 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1080 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_reflow (self, "on_items_altered");
#line 6618 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_items_state_changed (CheckerboardLayout* self, GeeIterable* changed) {
	GeeIterable* _tmp0_;
#line 1083 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1083 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GEE_IS_ITERABLE (changed));
#line 1084 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = changed;
#line 1084 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_items_dirty (self, "on_items_state_changed", _tmp0_);
#line 6632 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_items_visibility_changed (CheckerboardLayout* self, GeeIterable* changed) {
#line 1087 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1087 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GEE_IS_ITERABLE (changed));
#line 1088 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_reflow (self, "on_items_visibility_changed");
#line 6643 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_ordering_changed (CheckerboardLayout* self) {
#line 1091 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1092 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_reflow (self, "on_ordering_changed");
#line 6652 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_views_altered (CheckerboardLayout* self, GeeCollection* altered) {
	GeeCollection* _tmp0_;
#line 1095 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1095 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GEE_IS_COLLECTION (altered));
#line 1096 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = altered;
#line 1096 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_items_dirty (self, "on_views_altered", G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
#line 6666 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_geometries_altered (CheckerboardLayout* self) {
#line 1099 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1100 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_reflow (self, "on_geometries_altered");
#line 6675 "CheckerboardLayout.c"
}


static gboolean _checkerboard_layout_do_reflow_gsource_func (gpointer self) {
	gboolean result;
	result = checkerboard_layout_do_reflow ((CheckerboardLayout*) self);
#line 1116 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 6684 "CheckerboardLayout.c"
}


static void checkerboard_layout_need_reflow (CheckerboardLayout* self, const gchar* caller) {
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 1103 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1103 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (caller != NULL);
#line 1104 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->flow_scheduled;
#line 1104 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 1105 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6701 "CheckerboardLayout.c"
	}
#line 1107 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->is_in_view;
#line 1107 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp1_) {
#line 1108 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->reflow_needed = TRUE;
#line 1109 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6711 "CheckerboardLayout.c"
	}
#line 1115 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->flow_scheduled = TRUE;
#line 1116 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_idle_add_full (G_PRIORITY_HIGH, _checkerboard_layout_do_reflow_gsource_func, g_object_ref (self), g_object_unref);
#line 6717 "CheckerboardLayout.c"
}


static gboolean checkerboard_layout_do_reflow (CheckerboardLayout* self) {
	gboolean result = FALSE;
#line 1119 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), FALSE);
#line 1120 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_reflow (self, "do_reflow");
#line 1121 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_exposure (self, "do_reflow");
#line 1123 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->flow_scheduled = FALSE;
#line 1125 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = FALSE;
#line 1125 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 6735 "CheckerboardLayout.c"
}


static void checkerboard_layout_need_exposure (CheckerboardLayout* self, const gchar* caller) {
#line 1128 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1128 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (caller != NULL);
#line 1132 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure_dirty = TRUE;
#line 1133 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 6748 "CheckerboardLayout.c"
}


void checkerboard_layout_set_message (CheckerboardLayout* self, const gchar* text) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
#line 1136 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1137 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = text;
#line 1137 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->message;
#line 1137 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
#line 1138 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6768 "CheckerboardLayout.c"
	}
#line 1140 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = text;
#line 1140 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 1140 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->message);
#line 1140 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->message = _tmp3_;
#line 1142 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = text;
#line 1142 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_ != NULL) {
#line 6782 "CheckerboardLayout.c"
		GtkContainer* _tmp5_;
		GtkContainer* _tmp6_;
#line 1145 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 1145 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = _tmp5_;
#line 1145 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp6_ != NULL) {
#line 6791 "CheckerboardLayout.c"
			GtkAllocation parent_allocation = {0};
			GtkContainer* _tmp7_;
			GtkContainer* _tmp8_;
			GtkAllocation _tmp9_ = {0};
			GtkAllocation _tmp10_;
			gint _tmp11_;
			GtkAllocation _tmp12_;
			gint _tmp13_;
#line 1147 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp7_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 1147 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp8_ = _tmp7_;
#line 1147 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), &_tmp9_);
#line 1147 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			parent_allocation = _tmp9_;
#line 1149 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = parent_allocation;
#line 1149 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = _tmp10_.width;
#line 1149 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp12_ = parent_allocation;
#line 1149 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp13_ = _tmp12_.height;
#line 1149 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp11_, _tmp13_);
#line 6818 "CheckerboardLayout.c"
		}
	} else {
#line 1153 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_need_reflow (self, "set_message");
#line 6823 "CheckerboardLayout.c"
	}
}


void checkerboard_layout_unset_message (CheckerboardLayout* self) {
#line 1157 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1158 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_set_message (self, NULL);
#line 6833 "CheckerboardLayout.c"
}


static void checkerboard_layout_update_visible_page (CheckerboardLayout* self) {
	gboolean _tmp0_ = FALSE;
	GtkAdjustment* _tmp1_;
#line 1161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1162 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->hadjustment;
#line 1162 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 6846 "CheckerboardLayout.c"
		GtkAdjustment* _tmp2_;
#line 1162 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->vadjustment;
#line 1162 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 6852 "CheckerboardLayout.c"
	} else {
#line 1162 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 6856 "CheckerboardLayout.c"
	}
#line 1162 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 6860 "CheckerboardLayout.c"
		GtkAdjustment* _tmp3_;
		GtkAdjustment* _tmp4_;
		GdkRectangle _tmp5_ = {0};
#line 1163 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->hadjustment;
#line 1163 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->vadjustment;
#line 1163 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		get_adjustment_page (_tmp3_, _tmp4_, &_tmp5_);
#line 1163 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->visible_page = _tmp5_;
#line 6872 "CheckerboardLayout.c"
	}
}


void checkerboard_layout_set_in_view (CheckerboardLayout* self, gboolean in_view) {
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 1166 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1167 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = in_view;
#line 1167 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->is_in_view = _tmp0_;
#line 1169 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = in_view;
#line 1169 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 6890 "CheckerboardLayout.c"
		gboolean _tmp2_;
#line 1170 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->reflow_needed;
#line 1170 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp2_) {
#line 1171 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_layout_need_reflow (self, "set_in_view (true)");
#line 6898 "CheckerboardLayout.c"
		} else {
#line 1173 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_layout_need_exposure (self, "set_in_view (true)");
#line 6902 "CheckerboardLayout.c"
		}
	} else {
#line 1175 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_unexpose_items (self, "set_in_view (false)");
#line 6907 "CheckerboardLayout.c"
	}
}


static gpointer _checkerboard_layout_layout_row_ref0 (gpointer self) {
#line 1191 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self ? checkerboard_layout_layout_row_ref (self) : NULL;
#line 6915 "CheckerboardLayout.c"
}


CheckerboardItem* checkerboard_layout_get_item_at_pixel (CheckerboardLayout* self, gdouble xd, gdouble yd) {
	CheckerboardItem* result = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gint x = 0;
	gdouble _tmp3_;
	gint y = 0;
	gdouble _tmp4_;
	CheckerboardLayoutLayoutRow* in_range = NULL;
	gint min = 0;
	gint max = 0;
	CheckerboardLayoutLayoutRow** _tmp5_;
	gint _tmp5__length1;
	CheckerboardLayoutLayoutRow* _tmp30_;
	CheckerboardLayoutLayoutRow* _tmp31_;
	CheckerboardItem** _tmp32_;
	gint _tmp32__length1;
#line 1178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1179 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->message;
#line 1179 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1179 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = TRUE;
#line 6944 "CheckerboardLayout.c"
	} else {
		CheckerboardLayoutLayoutRow** _tmp2_;
		gint _tmp2__length1;
#line 1179 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->item_rows;
#line 1179 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2__length1 = self->priv->item_rows_length1;
#line 1179 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 6954 "CheckerboardLayout.c"
	}
#line 1179 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 1180 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1180 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 6962 "CheckerboardLayout.c"
	}
#line 1182 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = xd;
#line 1182 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	x = (gint) _tmp3_;
#line 1183 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = yd;
#line 1183 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	y = (gint) _tmp4_;
#line 1186 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	in_range = NULL;
#line 1187 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	min = 0;
#line 1188 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = self->priv->item_rows;
#line 1188 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5__length1 = self->priv->item_rows_length1;
#line 1188 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	max = _tmp5__length1;
#line 6982 "CheckerboardLayout.c"
	{
		gboolean _tmp6_ = FALSE;
#line 1189 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = TRUE;
#line 1189 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 6989 "CheckerboardLayout.c"
			gint mid = 0;
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			CheckerboardLayoutLayoutRow* row = NULL;
			CheckerboardLayoutLayoutRow** _tmp10_;
			gint _tmp10__length1;
			gint _tmp11_;
			CheckerboardLayoutLayoutRow* _tmp12_;
			CheckerboardLayoutLayoutRow* _tmp13_;
			gboolean _tmp14_ = FALSE;
			CheckerboardLayoutLayoutRow* _tmp15_;
			gint _tmp28_;
			gint _tmp29_;
#line 1189 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp6_) {
#line 7006 "CheckerboardLayout.c"
			}
#line 1189 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp6_ = FALSE;
#line 1190 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp7_ = min;
#line 1190 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp8_ = max;
#line 1190 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp9_ = min;
#line 1190 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			mid = _tmp7_ + ((_tmp8_ - _tmp9_) / 2);
#line 1191 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = self->priv->item_rows;
#line 1191 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10__length1 = self->priv->item_rows_length1;
#line 1191 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = mid;
#line 1191 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp12_ = _tmp10_[_tmp11_];
#line 1191 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp13_ = _checkerboard_layout_layout_row_ref0 (_tmp12_);
#line 1191 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			row = _tmp13_;
#line 1193 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp15_ = row;
#line 1193 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp15_ == NULL) {
#line 1193 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp14_ = TRUE;
#line 7036 "CheckerboardLayout.c"
			} else {
				gint _tmp16_;
				CheckerboardLayoutLayoutRow* _tmp17_;
				gint _tmp18_;
#line 1193 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp16_ = y;
#line 1193 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp17_ = row;
#line 1193 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp18_ = _tmp17_->y;
#line 1193 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp14_ = _tmp16_ < _tmp18_;
#line 7049 "CheckerboardLayout.c"
			}
#line 1193 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp14_) {
#line 7053 "CheckerboardLayout.c"
				gint _tmp19_;
#line 1196 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = mid;
#line 1196 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				max = _tmp19_ - 1;
#line 7059 "CheckerboardLayout.c"
			} else {
				gint _tmp20_;
				CheckerboardLayoutLayoutRow* _tmp21_;
				gint _tmp22_;
				CheckerboardLayoutLayoutRow* _tmp23_;
				gint _tmp24_;
#line 1197 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp20_ = y;
#line 1197 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp21_ = row;
#line 1197 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp22_ = _tmp21_->y;
#line 1197 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp23_ = row;
#line 1197 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp24_ = _tmp23_->height;
#line 1197 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp20_ > (_tmp22_ + _tmp24_)) {
#line 7078 "CheckerboardLayout.c"
					gint _tmp25_;
#line 1199 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp25_ = mid;
#line 1199 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					min = _tmp25_ + 1;
#line 7084 "CheckerboardLayout.c"
				} else {
					CheckerboardLayoutLayoutRow* _tmp26_;
					CheckerboardLayoutLayoutRow* _tmp27_;
#line 1202 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp26_ = row;
#line 1202 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp27_ = _checkerboard_layout_layout_row_ref0 (_tmp26_);
#line 1202 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (in_range);
#line 1202 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					in_range = _tmp27_;
#line 1204 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (row);
#line 1204 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 7100 "CheckerboardLayout.c"
				}
			}
#line 1207 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp28_ = min;
#line 1207 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp29_ = max;
#line 1207 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp28_ > _tmp29_) {
#line 1208 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_checkerboard_layout_layout_row_unref0 (row);
#line 1208 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 7113 "CheckerboardLayout.c"
			}
#line 1189 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_checkerboard_layout_layout_row_unref0 (row);
#line 7117 "CheckerboardLayout.c"
		}
	}
#line 1211 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp30_ = in_range;
#line 1211 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp30_ == NULL) {
#line 1212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_checkerboard_layout_layout_row_unref0 (in_range);
#line 1212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 7130 "CheckerboardLayout.c"
	}
#line 1215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp31_ = in_range;
#line 1215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp32_ = _tmp31_->items;
#line 1215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp32__length1 = _tmp31_->items_length1;
#line 7138 "CheckerboardLayout.c"
	{
		CheckerboardItem** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
#line 1215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		item_collection = _tmp32_;
#line 1215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		item_collection_length1 = _tmp32__length1;
#line 1215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		for (item_it = 0; item_it < _tmp32__length1; item_it = item_it + 1) {
#line 7150 "CheckerboardLayout.c"
			CheckerboardItem* _tmp33_;
			CheckerboardItem* item = NULL;
#line 1215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp33_ = _g_object_ref0 (item_collection[item_it]);
#line 1215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = _tmp33_;
#line 7157 "CheckerboardLayout.c"
			{
				CheckerboardItem* _tmp34_;
				gint _tmp35_;
				CheckerboardItem* _tmp36_;
				GdkRectangle _tmp37_;
				gint _tmp38_;
				gboolean _tmp39_ = FALSE;
				gboolean _tmp40_ = FALSE;
				gint _tmp41_;
				CheckerboardItem* _tmp42_;
				GdkRectangle _tmp43_;
				gint _tmp44_;
				CheckerboardItem* _tmp45_;
				GdkRectangle _tmp46_;
				gint _tmp47_;
#line 1218 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp34_ = item;
#line 1218 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp34_ == NULL) {
#line 1219 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_g_object_unref0 (item);
#line 1219 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					continue;
#line 7181 "CheckerboardLayout.c"
				}
#line 1221 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp35_ = x;
#line 1221 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp36_ = item;
#line 1221 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp37_ = _tmp36_->allocation;
#line 1221 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp38_ = _tmp37_.x;
#line 1221 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp35_ < _tmp38_) {
#line 1223 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_g_object_unref0 (item);
#line 1223 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 7197 "CheckerboardLayout.c"
				}
#line 1228 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp41_ = x;
#line 1228 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp42_ = item;
#line 1228 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp43_ = _tmp42_->allocation;
#line 1228 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp44_ = _tmp43_.x;
#line 1228 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp45_ = item;
#line 1228 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp46_ = _tmp45_->allocation;
#line 1228 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp47_ = _tmp46_.width;
#line 1228 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp41_ <= (_tmp44_ + _tmp47_)) {
#line 7215 "CheckerboardLayout.c"
					gint _tmp48_;
					CheckerboardItem* _tmp49_;
					GdkRectangle _tmp50_;
					gint _tmp51_;
#line 1228 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp48_ = y;
#line 1228 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp49_ = item;
#line 1228 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp50_ = _tmp49_->allocation;
#line 1228 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp51_ = _tmp50_.y;
#line 1228 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp40_ = _tmp48_ >= _tmp51_;
#line 7230 "CheckerboardLayout.c"
				} else {
#line 1228 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp40_ = FALSE;
#line 7234 "CheckerboardLayout.c"
				}
#line 1228 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp40_) {
#line 7238 "CheckerboardLayout.c"
					gint _tmp52_;
					CheckerboardItem* _tmp53_;
					GdkRectangle _tmp54_;
					gint _tmp55_;
					CheckerboardItem* _tmp56_;
					GdkRectangle _tmp57_;
					gint _tmp58_;
#line 1229 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp52_ = y;
#line 1229 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp53_ = item;
#line 1229 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp54_ = _tmp53_->allocation;
#line 1229 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp55_ = _tmp54_.y;
#line 1229 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp56_ = item;
#line 1229 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp57_ = _tmp56_->allocation;
#line 1229 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp58_ = _tmp57_.height;
#line 1229 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp39_ = _tmp52_ <= (_tmp55_ + _tmp58_);
#line 7262 "CheckerboardLayout.c"
				} else {
#line 1228 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp39_ = FALSE;
#line 7266 "CheckerboardLayout.c"
				}
#line 1228 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp39_) {
#line 1230 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					result = item;
#line 1230 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (in_range);
#line 1230 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					return result;
#line 7276 "CheckerboardLayout.c"
				}
#line 1215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 7280 "CheckerboardLayout.c"
			}
		}
	}
#line 1233 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = NULL;
#line 1233 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_layout_layout_row_unref0 (in_range);
#line 1233 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 7290 "CheckerboardLayout.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
#line 1110 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1111 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1111 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 1111 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1111 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 7308 "CheckerboardLayout.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1323 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1323 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 7331 "CheckerboardLayout.c"
		glong _tmp4_;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 7339 "CheckerboardLayout.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 7351 "CheckerboardLayout.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
#line 1333 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 7375 "CheckerboardLayout.c"
		glong _tmp2_;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 7381 "CheckerboardLayout.c"
	} else {
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 7385 "CheckerboardLayout.c"
	}
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 7389 "CheckerboardLayout.c"
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 7401 "CheckerboardLayout.c"
	} else {
		gint _tmp6_;
		gint _tmp7_;
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 7411 "CheckerboardLayout.c"
	}
#line 1342 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1342 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 7417 "CheckerboardLayout.c"
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1344 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1344 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 7431 "CheckerboardLayout.c"
	} else {
		glong _tmp12_;
		glong _tmp13_;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 7441 "CheckerboardLayout.c"
	}
#line 1348 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1348 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 7447 "CheckerboardLayout.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 7456 "CheckerboardLayout.c"
	}
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 7476 "CheckerboardLayout.c"
}


gint checkerboard_layout_get_tag_index_at_pos (const gchar* tag_list, gint pos) {
	gint result = 0;
	gint sep_len = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint len = 0;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_;
	gint index = 0;
#line 1236 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (tag_list != NULL, 0);
#line 1237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = strlen (TAG_TAG_LIST_SEPARATOR_STRING);
#line 1237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_;
#line 1237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	sep_len = _tmp1_;
#line 1238 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = sep_len;
#line 1238 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (_tmp2_ > 0, "sep_len > 0");
#line 1239 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = tag_list;
#line 1239 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = strlen (_tmp3_);
#line 1239 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _tmp4_;
#line 1239 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	len = _tmp5_;
#line 1240 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = pos;
#line 1240 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp7_ < 0) {
#line 1240 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = TRUE;
#line 7519 "CheckerboardLayout.c"
	} else {
		gint _tmp8_;
		gint _tmp9_;
#line 1240 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = pos;
#line 1240 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = len;
#line 1240 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = _tmp8_ >= _tmp9_;
#line 7529 "CheckerboardLayout.c"
	}
#line 1240 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp6_) {
#line 1241 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = -1;
#line 1241 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 7537 "CheckerboardLayout.c"
	}
	{
		gint i = 0;
#line 1244 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		i = 0;
#line 7543 "CheckerboardLayout.c"
		{
			gboolean _tmp10_ = FALSE;
#line 1244 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = TRUE;
#line 1244 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			while (TRUE) {
#line 7550 "CheckerboardLayout.c"
				gint _tmp12_;
				gint _tmp13_;
				gboolean _tmp14_ = FALSE;
				const gchar* _tmp15_;
				gint _tmp16_;
				gchar _tmp17_;
				gint _tmp18_;
				gchar _tmp19_;
#line 1244 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!_tmp10_) {
#line 7561 "CheckerboardLayout.c"
					gint _tmp11_;
#line 1244 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp11_ = i;
#line 1244 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					i = _tmp11_ + 1;
#line 7567 "CheckerboardLayout.c"
				}
#line 1244 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp10_ = FALSE;
#line 1244 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp12_ = i;
#line 1244 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp13_ = sep_len;
#line 1244 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!(_tmp12_ < _tmp13_)) {
#line 1244 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 7579 "CheckerboardLayout.c"
				}
#line 1245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp15_ = tag_list;
#line 1245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp16_ = pos;
#line 1245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp17_ = string_get (_tmp15_, (glong) _tmp16_);
#line 1245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp18_ = i;
#line 1245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = string_get (TAG_TAG_LIST_SEPARATOR_STRING, (glong) _tmp18_);
#line 1245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp17_ == _tmp19_) {
#line 7593 "CheckerboardLayout.c"
					gint _tmp20_;
					gint _tmp21_;
#line 1245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp20_ = pos;
#line 1245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp21_ = i;
#line 1245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp14_ = _tmp20_ >= _tmp21_;
#line 7602 "CheckerboardLayout.c"
				} else {
#line 1245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp14_ = FALSE;
#line 7606 "CheckerboardLayout.c"
				}
#line 1245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp14_) {
#line 7610 "CheckerboardLayout.c"
					const gchar* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					gint _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					gboolean _tmp28_;
#line 1246 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp22_ = tag_list;
#line 1246 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp23_ = pos;
#line 1246 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp24_ = i;
#line 1246 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp25_ = sep_len;
#line 1246 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp26_ = string_substring (_tmp22_, (glong) (_tmp23_ - _tmp24_), (glong) _tmp25_);
#line 1246 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp27_ = _tmp26_;
#line 1246 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp28_ = g_strcmp0 (_tmp27_, TAG_TAG_LIST_SEPARATOR_STRING) == 0;
#line 1246 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_g_free0 (_tmp27_);
#line 1246 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					if (_tmp28_) {
#line 1247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						result = -1;
#line 1247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						return result;
#line 7640 "CheckerboardLayout.c"
					}
				}
			}
		}
	}
#line 1254 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	index = 0;
#line 7648 "CheckerboardLayout.c"
	{
		gint i = 0;
#line 1255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		i = 0;
#line 7653 "CheckerboardLayout.c"
		{
			gboolean _tmp29_ = FALSE;
#line 1255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp29_ = TRUE;
#line 1255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			while (TRUE) {
#line 7660 "CheckerboardLayout.c"
				gint _tmp31_;
				gint _tmp32_;
				gboolean _tmp33_ = FALSE;
				gboolean _tmp34_ = FALSE;
				const gchar* _tmp35_;
				gint _tmp36_;
				gchar _tmp37_;
				gchar _tmp38_;
#line 1255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!_tmp29_) {
#line 7671 "CheckerboardLayout.c"
					gint _tmp30_;
#line 1255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp30_ = i;
#line 1255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					i = _tmp30_ + 1;
#line 7677 "CheckerboardLayout.c"
				}
#line 1255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp29_ = FALSE;
#line 1255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp31_ = i;
#line 1255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp32_ = pos;
#line 1255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!(_tmp31_ < _tmp32_)) {
#line 1255 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 7689 "CheckerboardLayout.c"
				}
#line 1256 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp35_ = tag_list;
#line 1256 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp36_ = i;
#line 1256 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp37_ = string_get (_tmp35_, (glong) _tmp36_);
#line 1256 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp38_ = string_get (TAG_TAG_LIST_SEPARATOR_STRING, (glong) 0);
#line 1256 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp37_ == _tmp38_) {
#line 7701 "CheckerboardLayout.c"
					gint _tmp39_;
					gint _tmp40_;
					gint _tmp41_;
#line 1257 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp39_ = i;
#line 1257 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp40_ = sep_len;
#line 1257 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp41_ = len;
#line 1257 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp34_ = (_tmp39_ + _tmp40_) <= _tmp41_;
#line 7713 "CheckerboardLayout.c"
				} else {
#line 1256 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp34_ = FALSE;
#line 7717 "CheckerboardLayout.c"
				}
#line 1256 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp34_) {
#line 7721 "CheckerboardLayout.c"
					const gchar* _tmp42_;
					gint _tmp43_;
					gint _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp46_;
#line 1258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp42_ = tag_list;
#line 1258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp43_ = i;
#line 1258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp44_ = sep_len;
#line 1258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp45_ = string_substring (_tmp42_, (glong) _tmp43_, (glong) _tmp44_);
#line 1258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp46_ = _tmp45_;
#line 1258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp33_ = g_strcmp0 (_tmp46_, TAG_TAG_LIST_SEPARATOR_STRING) == 0;
#line 1258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_g_free0 (_tmp46_);
#line 7741 "CheckerboardLayout.c"
				} else {
#line 1256 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp33_ = FALSE;
#line 7745 "CheckerboardLayout.c"
				}
#line 1256 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp33_) {
#line 7749 "CheckerboardLayout.c"
					gint _tmp47_;
					gint _tmp48_;
					gint _tmp49_;
#line 1259 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp47_ = index;
#line 1259 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					index = _tmp47_ + 1;
#line 1260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp48_ = i;
#line 1260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp49_ = sep_len;
#line 1260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					i = _tmp48_ + (_tmp49_ - 1);
#line 7763 "CheckerboardLayout.c"
				}
			}
		}
	}
#line 1263 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = index;
#line 1263 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 7772 "CheckerboardLayout.c"
}


static gint checkerboard_layout_internal_handle_tag_mouse_event (CheckerboardLayout* self, CheckerboardItem* item, gint x, gint y) {
	gint result = 0;
	PangoLayout* layout = NULL;
	CheckerboardItem* _tmp0_;
	PangoLayout* _tmp1_;
	PangoLayout* _tmp2_;
	GdkRectangle rect = {0};
	CheckerboardItem* _tmp3_;
	GdkRectangle _tmp4_ = {0};
	gint index = 0;
	gint trailing = 0;
	gint px = 0;
	gint _tmp5_;
	GdkRectangle _tmp6_;
	gint _tmp7_;
	gint py = 0;
	gint _tmp8_;
	GdkRectangle _tmp9_;
	gint _tmp10_;
	PangoLayout* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gboolean _tmp16_;
#line 1266 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), 0);
#line 1266 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (item), 0);
#line 1267 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = item;
#line 1267 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = checkerboard_item_get_tag_list_layout (_tmp0_);
#line 1267 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	layout = _tmp1_;
#line 1268 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = layout;
#line 1268 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ == NULL) {
#line 1269 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = -1;
#line 1269 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (layout);
#line 1269 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 7821 "CheckerboardLayout.c"
	}
#line 1270 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = item;
#line 1270 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_get_subtitle_allocation (_tmp3_, &_tmp4_);
#line 1270 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	rect = _tmp4_;
#line 1272 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = x;
#line 1272 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = rect;
#line 1272 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = _tmp6_.x;
#line 1272 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	px = (_tmp5_ - _tmp7_) * PANGO_SCALE;
#line 1273 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = y;
#line 1273 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = rect;
#line 1273 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = _tmp9_.y;
#line 1273 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	py = (_tmp8_ - _tmp10_) * PANGO_SCALE;
#line 1274 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = layout;
#line 1274 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = px;
#line 1274 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = py;
#line 1274 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = pango_layout_xy_to_index (_tmp11_, _tmp12_, _tmp13_, &_tmp14_, &_tmp15_);
#line 1274 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	index = _tmp14_;
#line 1274 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	trailing = _tmp15_;
#line 1274 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp16_) {
#line 7859 "CheckerboardLayout.c"
		PangoLayout* _tmp17_;
		const gchar* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
#line 1275 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = layout;
#line 1275 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = pango_layout_get_text (_tmp17_);
#line 1275 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = index;
#line 1275 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = checkerboard_layout_get_tag_index_at_pos (_tmp18_, _tmp19_);
#line 1275 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = _tmp20_;
#line 1275 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (layout);
#line 1275 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 7878 "CheckerboardLayout.c"
	}
#line 1276 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = -1;
#line 1276 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (layout);
#line 1276 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 7886 "CheckerboardLayout.c"
}


gboolean checkerboard_layout_handle_mouse_motion (CheckerboardLayout* self, CheckerboardItem* item, gint x, gint y, GdkModifierType mask) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	CheckerboardItem* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint tag_index = 0;
	CheckerboardItem* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	CheckerboardItem* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
#line 1279 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), FALSE);
#line 1279 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (item), FALSE);
#line 1280 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = item;
#line 1280 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = checkerboard_item_get_has_tags (_tmp1_);
#line 1280 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_;
#line 1280 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp3_) {
#line 1280 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = TRUE;
#line 7918 "CheckerboardLayout.c"
	} else {
		gboolean _tmp4_;
#line 1280 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = checkerboard_layout_is_drag_select_active (self);
#line 1280 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_;
#line 7925 "CheckerboardLayout.c"
	}
#line 1280 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 1281 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = FALSE;
#line 1281 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 7933 "CheckerboardLayout.c"
	}
#line 1282 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = item;
#line 1282 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = x;
#line 1282 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = y;
#line 1282 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = checkerboard_layout_internal_handle_tag_mouse_event (self, _tmp5_, _tmp6_, _tmp7_);
#line 1282 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	tag_index = _tmp8_;
#line 1283 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = item;
#line 1283 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = tag_index;
#line 1283 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_highlight_user_visible_tag (_tmp9_, _tmp10_);
#line 1284 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = tag_index;
#line 1284 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp11_ >= 0;
#line 1284 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 7957 "CheckerboardLayout.c"
}


gboolean checkerboard_layout_handle_left_click (CheckerboardLayout* self, CheckerboardItem* item, gdouble xd, gdouble yd, GdkModifierType mask) {
	gboolean result = FALSE;
	gint tag_index = 0;
	CheckerboardItem* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
#line 1287 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), FALSE);
#line 1287 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (item), FALSE);
#line 1288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = item;
#line 1288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = xd;
#line 1288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = round (_tmp1_);
#line 1288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = yd;
#line 1288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = round (_tmp3_);
#line 1288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = checkerboard_layout_internal_handle_tag_mouse_event (self, _tmp0_, (gint) _tmp2_, (gint) _tmp4_);
#line 1288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	tag_index = _tmp5_;
#line 1289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = tag_index;
#line 1289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp6_ >= 0) {
#line 7993 "CheckerboardLayout.c"
		Tag* tag = NULL;
		CheckerboardItem* _tmp7_;
		gint _tmp8_;
		Tag* _tmp9_;
		LibraryWindow* _tmp10_;
		LibraryWindow* _tmp11_;
		Tag* _tmp12_;
#line 1290 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = item;
#line 1290 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = tag_index;
#line 1290 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = checkerboard_item_get_user_visible_tag (_tmp7_, _tmp8_);
#line 1290 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		tag = _tmp9_;
#line 1291 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = library_window_get_app ();
#line 1291 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = _tmp10_;
#line 1291 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = tag;
#line 1291 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		library_window_switch_to_tag (_tmp11_, _tmp12_);
#line 1291 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_tmp11_);
#line 1292 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = TRUE;
#line 1292 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (tag);
#line 1292 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 8025 "CheckerboardLayout.c"
	}
#line 1294 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = FALSE;
#line 1294 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 8031 "CheckerboardLayout.c"
}


GeeList* checkerboard_layout_get_visible_items (CheckerboardLayout* self) {
	GeeList* result = NULL;
	GdkRectangle _tmp0_;
	GeeList* _tmp1_;
#line 1297 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1298 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->visible_page;
#line 1298 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = checkerboard_layout_intersection (self, &_tmp0_);
#line 1298 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp1_;
#line 1298 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 8049 "CheckerboardLayout.c"
}


GeeList* checkerboard_layout_intersection (CheckerboardLayout* self, GdkRectangle* area) {
	GeeList* result = NULL;
	GeeArrayList* intersects = NULL;
	GeeArrayList* _tmp0_;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp1_ = {0};
	GdkRectangle bitbucket = {0};
	CheckerboardLayoutLayoutRow** _tmp2_;
	gint _tmp2__length1;
#line 1301 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1301 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (area != NULL, NULL);
#line 1302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = gee_array_list_new (TYPE_CHECKERBOARD_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 1302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	intersects = _tmp0_;
#line 1305 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp1_);
#line 1305 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	allocation = _tmp1_;
#line 1307 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&bitbucket, 0, sizeof (GdkRectangle));
#line 1308 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->item_rows;
#line 1308 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2__length1 = self->priv->item_rows_length1;
#line 8080 "CheckerboardLayout.c"
	{
		CheckerboardLayoutLayoutRow** row_collection = NULL;
		gint row_collection_length1 = 0;
		gint _row_collection_size_ = 0;
		gint row_it = 0;
#line 1308 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		row_collection = _tmp2_;
#line 1308 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		row_collection_length1 = _tmp2__length1;
#line 1308 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		for (row_it = 0; row_it < _tmp2__length1; row_it = row_it + 1) {
#line 8092 "CheckerboardLayout.c"
			CheckerboardLayoutLayoutRow* _tmp3_;
			CheckerboardLayoutLayoutRow* row = NULL;
#line 1308 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp3_ = _checkerboard_layout_layout_row_ref0 (row_collection[row_it]);
#line 1308 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			row = _tmp3_;
#line 8099 "CheckerboardLayout.c"
			{
				CheckerboardLayoutLayoutRow* _tmp4_;
				GdkRectangle _tmp5_;
				gint _tmp6_;
				GdkRectangle _tmp7_;
				gint _tmp8_;
				CheckerboardLayoutLayoutRow* _tmp9_;
				gint _tmp10_;
				CheckerboardLayoutLayoutRow* _tmp11_;
				gint _tmp12_;
				CheckerboardLayoutLayoutRow* _tmp13_;
				gint _tmp14_;
				GdkRectangle _tmp15_;
				gint _tmp16_;
				GdkRectangle row_rect = {0};
				CheckerboardLayoutLayoutRow* _tmp17_;
				gint _tmp18_;
				GtkAllocation _tmp19_;
				gint _tmp20_;
				CheckerboardLayoutLayoutRow* _tmp21_;
				gint _tmp22_;
				GdkRectangle _tmp23_;
				GdkRectangle _tmp24_ = {0};
				gboolean _tmp25_;
#line 1309 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp4_ = row;
#line 1309 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp4_ == NULL) {
#line 1310 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (row);
#line 1310 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					continue;
#line 8132 "CheckerboardLayout.c"
				}
#line 1312 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp5_ = *area;
#line 1312 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp6_ = _tmp5_.y;
#line 1312 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp7_ = *area;
#line 1312 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp8_ = _tmp7_.height;
#line 1312 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp9_ = row;
#line 1312 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp10_ = _tmp9_->y;
#line 1312 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if ((_tmp6_ + _tmp8_) < _tmp10_) {
#line 1314 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (row);
#line 1314 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 8152 "CheckerboardLayout.c"
				}
#line 1317 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp11_ = row;
#line 1317 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp12_ = _tmp11_->y;
#line 1317 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp13_ = row;
#line 1317 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp14_ = _tmp13_->height;
#line 1317 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp15_ = *area;
#line 1317 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp16_ = _tmp15_.y;
#line 1317 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if ((_tmp12_ + _tmp14_) < _tmp16_) {
#line 1319 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (row);
#line 1319 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					continue;
#line 8172 "CheckerboardLayout.c"
				}
#line 1323 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				memset (&row_rect, 0, sizeof (GdkRectangle));
#line 1324 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_rect.x = 0;
#line 1325 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp17_ = row;
#line 1325 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp18_ = _tmp17_->y;
#line 1325 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_rect.y = _tmp18_;
#line 1326 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = allocation;
#line 1326 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp20_ = _tmp19_.width;
#line 1326 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_rect.width = _tmp20_;
#line 1327 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp21_ = row;
#line 1327 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp22_ = _tmp21_->height;
#line 1327 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_rect.height = _tmp22_;
#line 1329 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp23_ = row_rect;
#line 1329 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp25_ = gdk_rectangle_intersect (area, &_tmp23_, &_tmp24_);
#line 1329 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				bitbucket = _tmp24_;
#line 1329 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp25_) {
#line 8204 "CheckerboardLayout.c"
					CheckerboardLayoutLayoutRow* _tmp26_;
					CheckerboardItem** _tmp27_;
					gint _tmp27__length1;
#line 1331 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp26_ = row;
#line 1331 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp27_ = _tmp26_->items;
#line 1331 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp27__length1 = _tmp26_->items_length1;
#line 8214 "CheckerboardLayout.c"
					{
						CheckerboardItem** item_collection = NULL;
						gint item_collection_length1 = 0;
						gint _item_collection_size_ = 0;
						gint item_it = 0;
#line 1331 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						item_collection = _tmp27_;
#line 1331 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						item_collection_length1 = _tmp27__length1;
#line 1331 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						for (item_it = 0; item_it < _tmp27__length1; item_it = item_it + 1) {
#line 8226 "CheckerboardLayout.c"
							CheckerboardItem* _tmp28_;
							CheckerboardItem* item = NULL;
#line 1331 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp28_ = _g_object_ref0 (item_collection[item_it]);
#line 1331 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							item = _tmp28_;
#line 8233 "CheckerboardLayout.c"
							{
								CheckerboardItem* _tmp29_;
								CheckerboardItem* _tmp30_;
								GdkRectangle _tmp31_;
								GdkRectangle _tmp32_ = {0};
								gboolean _tmp33_;
#line 1332 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								_tmp29_ = item;
#line 1332 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								if (_tmp29_ == NULL) {
#line 1333 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
									_g_object_unref0 (item);
#line 1333 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
									continue;
#line 8248 "CheckerboardLayout.c"
								}
#line 1335 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								_tmp30_ = item;
#line 1335 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								_tmp31_ = _tmp30_->allocation;
#line 1335 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								_tmp33_ = gdk_rectangle_intersect (area, &_tmp31_, &_tmp32_);
#line 1335 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								bitbucket = _tmp32_;
#line 1335 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								if (_tmp33_) {
#line 8260 "CheckerboardLayout.c"
									GeeArrayList* _tmp34_;
									CheckerboardItem* _tmp35_;
#line 1336 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
									_tmp34_ = intersects;
#line 1336 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
									_tmp35_ = item;
#line 1336 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
									gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp35_);
#line 8269 "CheckerboardLayout.c"
								}
#line 1331 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								_g_object_unref0 (item);
#line 8273 "CheckerboardLayout.c"
							}
						}
					}
				}
#line 1308 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_checkerboard_layout_layout_row_unref0 (row);
#line 8280 "CheckerboardLayout.c"
			}
		}
	}
#line 1341 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (intersects, GEE_TYPE_LIST, GeeList);
#line 1341 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 8288 "CheckerboardLayout.c"
}


CheckerboardItem* checkerboard_layout_get_item_relative_to (CheckerboardLayout* self, CheckerboardItem* item, CompassPoint point) {
	CheckerboardItem* result = NULL;
	ViewCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint col = 0;
	CheckerboardItem* _tmp4_;
	gint _tmp5_;
	gint row = 0;
	CheckerboardItem* _tmp6_;
	gint _tmp7_;
	gboolean _tmp8_ = FALSE;
	gint _tmp9_;
	CompassPoint _tmp14_;
	CheckerboardItem* new_item = NULL;
	gint _tmp35_;
	gint _tmp36_;
	CheckerboardItem* _tmp37_;
	gboolean _tmp38_ = FALSE;
	CheckerboardItem* _tmp39_;
	CheckerboardItem* _tmp47_ = NULL;
	CheckerboardItem* _tmp48_;
	CheckerboardItem* _tmp51_;
#line 1344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (item), NULL);
#line 1345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->view;
#line 1345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection));
#line 1345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ == 0) {
#line 1346 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1346 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 8330 "CheckerboardLayout.c"
	}
#line 1348 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->columns;
#line 1348 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (_tmp2_ > 0, "columns > 0");
#line 1349 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->rows;
#line 1349 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (_tmp3_ > 0, "rows > 0");
#line 1351 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = item;
#line 1351 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = checkerboard_item_get_column (_tmp4_);
#line 1351 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	col = _tmp5_;
#line 1352 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = item;
#line 1352 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = checkerboard_item_get_row (_tmp6_);
#line 1352 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row = _tmp7_;
#line 1354 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = col;
#line 1354 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp9_ < 0) {
#line 1354 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = TRUE;
#line 8358 "CheckerboardLayout.c"
	} else {
		gint _tmp10_;
#line 1354 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = row;
#line 1354 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = _tmp10_ < 0;
#line 8365 "CheckerboardLayout.c"
	}
#line 1354 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp8_) {
#line 8369 "CheckerboardLayout.c"
		CheckerboardItem* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
#line 1355 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = item;
#line 1355 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = checkerboard_item_get_title (_tmp11_);
#line 1355 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = _tmp12_;
#line 1355 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_critical ("CheckerboardLayout.vala:1355: Attempting to locate item not placed in " \
"layout: %s", _tmp13_);
#line 1355 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp13_);
#line 1357 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1357 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 8387 "CheckerboardLayout.c"
	}
#line 1360 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = point;
#line 1360 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	switch (_tmp14_) {
#line 1360 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		case COMPASS_POINT_NORTH:
#line 8395 "CheckerboardLayout.c"
		{
			gint _tmp15_;
			gint _tmp16_;
#line 1362 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp15_ = row;
#line 1362 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			row = _tmp15_ - 1;
#line 1362 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp16_ = row;
#line 1362 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp16_ < 0) {
#line 1363 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row = 0;
#line 8409 "CheckerboardLayout.c"
			}
#line 1364 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			break;
#line 8413 "CheckerboardLayout.c"
		}
#line 1360 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		case COMPASS_POINT_SOUTH:
#line 8417 "CheckerboardLayout.c"
		{
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
#line 1367 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp17_ = row;
#line 1367 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			row = _tmp17_ + 1;
#line 1367 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp18_ = row;
#line 1367 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp19_ = self->priv->rows;
#line 1367 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp18_ >= _tmp19_) {
#line 8432 "CheckerboardLayout.c"
				gint _tmp20_;
#line 1368 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp20_ = self->priv->rows;
#line 1368 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row = _tmp20_ - 1;
#line 8438 "CheckerboardLayout.c"
			}
#line 1369 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			break;
#line 8442 "CheckerboardLayout.c"
		}
#line 1360 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		case COMPASS_POINT_EAST:
#line 8446 "CheckerboardLayout.c"
		{
			gint _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
#line 1372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp21_ = col;
#line 1372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			col = _tmp21_ + 1;
#line 1372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp22_ = col;
#line 1372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp23_ = self->priv->columns;
#line 1372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp22_ >= _tmp23_) {
#line 8461 "CheckerboardLayout.c"
				gint _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
#line 1373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp24_ = row;
#line 1373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row = _tmp24_ + 1;
#line 1373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp25_ = row;
#line 1373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp26_ = self->priv->rows;
#line 1373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp25_ >= _tmp26_) {
#line 8475 "CheckerboardLayout.c"
					gint _tmp27_;
					gint _tmp28_;
#line 1374 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp27_ = self->priv->rows;
#line 1374 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					row = _tmp27_ - 1;
#line 1375 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp28_ = self->priv->columns;
#line 1375 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = _tmp28_ - 1;
#line 8486 "CheckerboardLayout.c"
				} else {
#line 1377 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = 0;
#line 8490 "CheckerboardLayout.c"
				}
			}
#line 1380 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			break;
#line 8495 "CheckerboardLayout.c"
		}
#line 1360 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		case COMPASS_POINT_WEST:
#line 8499 "CheckerboardLayout.c"
		{
			gint _tmp29_;
			gint _tmp30_;
#line 1383 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp29_ = col;
#line 1383 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			col = _tmp29_ - 1;
#line 1383 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp30_ = col;
#line 1383 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp30_ < 0) {
#line 8511 "CheckerboardLayout.c"
				gint _tmp31_;
				gint _tmp32_;
#line 1384 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp31_ = row;
#line 1384 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row = _tmp31_ - 1;
#line 1384 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp32_ = row;
#line 1384 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp32_ < 0) {
#line 1385 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					row = 0;
#line 1386 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = 0;
#line 8526 "CheckerboardLayout.c"
				} else {
					gint _tmp33_;
#line 1388 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp33_ = self->priv->columns;
#line 1388 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = _tmp33_ - 1;
#line 8533 "CheckerboardLayout.c"
				}
			}
#line 1391 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			break;
#line 8538 "CheckerboardLayout.c"
		}
		default:
		{
			CompassPoint _tmp34_;
#line 1394 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp34_ = point;
#line 1394 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			g_error ("CheckerboardLayout.vala:1394: Bad compass point %d", (gint) _tmp34_);
#line 8547 "CheckerboardLayout.c"
		}
	}
#line 1397 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp35_ = col;
#line 1397 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp36_ = row;
#line 1397 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp37_ = checkerboard_layout_get_item_at_coordinate (self, _tmp35_, _tmp36_);
#line 1397 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	new_item = _tmp37_;
#line 1399 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp39_ = new_item;
#line 1399 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp39_ == NULL) {
#line 8562 "CheckerboardLayout.c"
		CompassPoint _tmp40_;
#line 1399 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp40_ = point;
#line 1399 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp38_ = _tmp40_ == COMPASS_POINT_SOUTH;
#line 8568 "CheckerboardLayout.c"
	} else {
#line 1399 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp38_ = FALSE;
#line 8572 "CheckerboardLayout.c"
	}
#line 1399 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp38_) {
#line 8576 "CheckerboardLayout.c"
		ViewCollection* _tmp41_;
		DataView* _tmp42_;
		CheckerboardItem* _tmp43_;
		gint _tmp44_;
		CheckerboardItem* _tmp45_;
		gint _tmp46_;
#line 1401 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp41_ = self->priv->view;
#line 1401 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp42_ = view_collection_get_last (_tmp41_);
#line 1401 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (new_item);
#line 1401 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		new_item = G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 1402 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp43_ = new_item;
#line 1402 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp44_ = checkerboard_item_get_row (_tmp43_);
#line 1402 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp45_ = item;
#line 1402 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp46_ = checkerboard_item_get_row (_tmp45_);
#line 1402 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp44_ <= _tmp46_) {
#line 1403 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (new_item);
#line 1403 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			new_item = NULL;
#line 8605 "CheckerboardLayout.c"
		}
	}
#line 1406 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp48_ = new_item;
#line 1406 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp48_ != NULL) {
#line 8612 "CheckerboardLayout.c"
		CheckerboardItem* _tmp49_;
#line 1406 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp49_ = new_item;
#line 1406 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp47_ = _tmp49_;
#line 8618 "CheckerboardLayout.c"
	} else {
		CheckerboardItem* _tmp50_;
#line 1406 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp50_ = item;
#line 1406 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp47_ = _tmp50_;
#line 8625 "CheckerboardLayout.c"
	}
#line 1406 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp51_ = _g_object_ref0 (_tmp47_);
#line 1406 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp51_;
#line 1406 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (new_item);
#line 1406 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 8635 "CheckerboardLayout.c"
}


CheckerboardItem* checkerboard_layout_get_item_at_coordinate (CheckerboardLayout* self, gint col, gint row) {
	CheckerboardItem* result = NULL;
	gint _tmp0_;
	CheckerboardLayoutLayoutRow** _tmp1_;
	gint _tmp1__length1;
	CheckerboardLayoutLayoutRow* item_row = NULL;
	CheckerboardLayoutLayoutRow** _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	CheckerboardLayoutLayoutRow* _tmp4_;
	CheckerboardLayoutLayoutRow* _tmp5_;
	CheckerboardLayoutLayoutRow* _tmp6_;
	gint _tmp7_;
	CheckerboardLayoutLayoutRow* _tmp8_;
	CheckerboardItem** _tmp9_;
	gint _tmp9__length1;
	CheckerboardLayoutLayoutRow* _tmp10_;
	CheckerboardItem** _tmp11_;
	gint _tmp11__length1;
	gint _tmp12_;
	CheckerboardItem* _tmp13_;
	CheckerboardItem* _tmp14_;
#line 1409 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1410 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = row;
#line 1410 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->item_rows;
#line 1410 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1__length1 = self->priv->item_rows_length1;
#line 1410 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ >= _tmp1__length1) {
#line 1411 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1411 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 8675 "CheckerboardLayout.c"
	}
#line 1413 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->item_rows;
#line 1413 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2__length1 = self->priv->item_rows_length1;
#line 1413 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = row;
#line 1413 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp2_[_tmp3_];
#line 1413 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _checkerboard_layout_layout_row_ref0 (_tmp4_);
#line 1413 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	item_row = _tmp5_;
#line 1414 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = item_row;
#line 1414 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp6_ == NULL) {
#line 1415 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1415 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_checkerboard_layout_layout_row_unref0 (item_row);
#line 1415 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 8699 "CheckerboardLayout.c"
	}
#line 1417 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = col;
#line 1417 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = item_row;
#line 1417 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = _tmp8_->items;
#line 1417 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9__length1 = _tmp8_->items_length1;
#line 1417 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp7_ >= _tmp9__length1) {
#line 1418 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1418 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_checkerboard_layout_layout_row_unref0 (item_row);
#line 1418 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 8717 "CheckerboardLayout.c"
	}
#line 1420 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = item_row;
#line 1420 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = _tmp10_->items;
#line 1420 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11__length1 = _tmp10_->items_length1;
#line 1420 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = col;
#line 1420 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = _tmp11_[_tmp12_];
#line 1420 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 1420 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp14_;
#line 1420 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_layout_layout_row_unref0 (item_row);
#line 1420 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 8737 "CheckerboardLayout.c"
}


void checkerboard_layout_set_drag_select_origin (CheckerboardLayout* self, gint x, gint y) {
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	gint _tmp1_;
	GtkAllocation _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GtkAllocation _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
#line 1423 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1424 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_clear_drag_select (self);
#line 1427 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp0_);
#line 1427 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	allocation = _tmp0_;
#line 1429 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = x;
#line 1429 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = allocation;
#line 1429 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_.width;
#line 1429 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = CLAMP (_tmp1_, 0, _tmp3_);
#line 1429 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_origin.x = _tmp4_;
#line 1430 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = y;
#line 1430 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = allocation;
#line 1430 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = _tmp6_.height;
#line 1430 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = CLAMP (_tmp5_, 0, _tmp7_);
#line 1430 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_origin.y = _tmp8_;
#line 8780 "CheckerboardLayout.c"
}


void checkerboard_layout_set_drag_select_endpoint (CheckerboardLayout* self, gint x, gint y) {
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	gint _tmp1_;
	GtkAllocation _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GtkAllocation _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GdkRectangle old_selection_band = {0};
	GdkRectangle _tmp9_;
	GdkPoint _tmp10_;
	GdkPoint _tmp11_;
	Box _tmp12_ = {0};
	GdkRectangle _tmp13_ = {0};
	GdkWindow* _tmp14_;
#line 1433 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1435 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp0_);
#line 1435 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	allocation = _tmp0_;
#line 1437 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = x;
#line 1437 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = allocation;
#line 1437 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_.width;
#line 1437 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = CLAMP (_tmp1_, 0, _tmp3_);
#line 1437 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_endpoint.x = _tmp4_;
#line 1438 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = y;
#line 1438 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = allocation;
#line 1438 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = _tmp6_.height;
#line 1438 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = CLAMP (_tmp5_, 0, _tmp7_);
#line 1438 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_endpoint.y = _tmp8_;
#line 1442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->selection_band;
#line 1442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old_selection_band = _tmp9_;
#line 1443 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = self->priv->drag_origin;
#line 1443 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = self->priv->drag_endpoint;
#line 1443 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	box_from_points (&_tmp10_, &_tmp11_, &_tmp12_);
#line 1443 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	box_get_rectangle (&_tmp12_, &_tmp13_);
#line 1443 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->selection_band = _tmp13_;
#line 1446 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 1446 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp14_ != NULL) {
#line 8846 "CheckerboardLayout.c"
		GdkRectangle _union_ = {0};
		GdkRectangle _tmp15_;
		GdkRectangle _tmp16_ = {0};
		GdkRectangle _tmp17_;
		gint _tmp18_;
		GdkRectangle _tmp19_;
		gint _tmp20_;
		GdkRectangle _tmp21_;
		gint _tmp22_;
		GdkRectangle _tmp23_;
		gint _tmp24_;
#line 1448 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = old_selection_band;
#line 1448 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gdk_rectangle_union (&self->priv->selection_band, &_tmp15_, &_tmp16_);
#line 1448 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_union_ = _tmp16_;
#line 1450 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = _union_;
#line 1450 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = _tmp17_.x;
#line 1450 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = _union_;
#line 1450 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = _tmp19_.y;
#line 1450 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = _union_;
#line 1450 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = _tmp21_.width;
#line 1450 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp23_ = _union_;
#line 1450 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp24_ = _tmp23_.height;
#line 1450 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_queue_draw_area (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp18_, _tmp20_, _tmp22_, _tmp24_);
#line 8882 "CheckerboardLayout.c"
	}
}


GeeList* checkerboard_layout_items_in_selection_band (CheckerboardLayout* self) {
	GeeList* result = NULL;
	GdkRectangle _tmp0_;
	Dimensions _tmp1_ = {0};
	gboolean _tmp2_;
	GdkRectangle _tmp3_;
	GeeList* _tmp4_;
#line 1454 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->selection_band;
#line 1455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions_for_rectangle (&_tmp0_, &_tmp1_);
#line 1455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = dimensions_has_area (&_tmp1_);
#line 1455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp2_) {
#line 1456 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1456 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 8908 "CheckerboardLayout.c"
	}
#line 1458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->selection_band;
#line 1458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = checkerboard_layout_intersection (self, &_tmp3_);
#line 1458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp4_;
#line 1458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 8918 "CheckerboardLayout.c"
}


gboolean checkerboard_layout_is_drag_select_active (CheckerboardLayout* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkPoint _tmp1_;
	gint _tmp2_;
#line 1461 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), FALSE);
#line 1462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->drag_origin;
#line 1462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_.x;
#line 1462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ >= 0) {
#line 8935 "CheckerboardLayout.c"
		GdkPoint _tmp3_;
		gint _tmp4_;
#line 1462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->drag_origin;
#line 1462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = _tmp3_.y;
#line 1462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_ >= 0;
#line 8944 "CheckerboardLayout.c"
	} else {
#line 1462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 8948 "CheckerboardLayout.c"
	}
#line 1462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 1462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 8954 "CheckerboardLayout.c"
}


void checkerboard_layout_clear_drag_select (CheckerboardLayout* self) {
#line 1465 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1466 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->priv->selection_band, 0, sizeof (GdkRectangle));
#line 1467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_origin.x = -1;
#line 1468 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_origin.y = -1;
#line 1469 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_endpoint.x = -1;
#line 1470 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_endpoint.y = -1;
#line 1473 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 8973 "CheckerboardLayout.c"
}


static void checkerboard_layout_viewport_resized (CheckerboardLayout* self) {
	GdkRectangle _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 1476 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1478 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_update_visible_page (self);
#line 1481 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->visible_page;
#line 1481 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_.width;
#line 1481 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->last_width;
#line 1481 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != _tmp2_) {
#line 8993 "CheckerboardLayout.c"
		gint old_width = 0;
		gint _tmp3_;
		GdkRectangle _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		GdkRectangle _tmp7_;
		gint _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1482 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->last_width;
#line 1482 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		old_width = _tmp3_;
#line 1483 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->visible_page;
#line 1483 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = _tmp4_.width;
#line 1483 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->last_width = _tmp5_;
#line 1485 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = old_width;
#line 1485 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = self->priv->visible_page;
#line 1485 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = _tmp7_.width;
#line 1485 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = g_strdup_printf ("viewport_resized (%d -> %d)", _tmp6_, _tmp8_);
#line 1485 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = _tmp9_;
#line 1485 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_need_reflow (self, _tmp10_);
#line 1485 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp10_);
#line 9027 "CheckerboardLayout.c"
	} else {
		gint _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
#line 1488 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = self->priv->last_width;
#line 1488 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = g_strdup_printf ("viewport_resized (same width=%d)", _tmp11_);
#line 1488 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = _tmp12_;
#line 1488 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_need_exposure (self, _tmp13_);
#line 1488 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp13_);
#line 9042 "CheckerboardLayout.c"
	}
}


static void checkerboard_layout_expose_items (CheckerboardLayout* self, const gchar* caller) {
	GeeHashSet* new_exposed_items = NULL;
	GeeHashSet* _tmp0_;
	ViewCollection* _tmp1_;
	GeeList* items = NULL;
	GeeList* _tmp2_;
	GeeHashSet* _tmp27_;
	GeeHashSet* _tmp28_;
	ViewCollection* _tmp29_;
#line 1492 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1492 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (caller != NULL);
#line 1495 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = gee_hash_set_new (TYPE_CHECKERBOARD_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 1495 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	new_exposed_items = _tmp0_;
#line 1497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->view;
#line 1497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_collection_freeze_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_COLLECTION, DataCollection));
#line 1499 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = checkerboard_layout_get_visible_items (self);
#line 1499 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	items = _tmp2_;
#line 9072 "CheckerboardLayout.c"
	{
		GeeList* _item_list = NULL;
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		gint _item_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _item_index = 0;
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = items;
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_list = _tmp4_;
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = _item_list;
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = _tmp6_;
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_size = _tmp7_;
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_index = -1;
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 9100 "CheckerboardLayout.c"
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			CheckerboardItem* item = NULL;
			GeeList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			GeeHashSet* _tmp14_;
			CheckerboardItem* _tmp15_;
			GeeHashSet* _tmp16_;
			CheckerboardItem* _tmp17_;
			gboolean _tmp18_;
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp8_ = _item_index;
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_item_index = _tmp8_ + 1;
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp9_ = _item_index;
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = _item_size;
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!(_tmp9_ < _tmp10_)) {
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 9125 "CheckerboardLayout.c"
			}
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = _item_list;
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp12_ = _item_index;
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp13_ = gee_list_get (_tmp11_, _tmp12_);
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = (CheckerboardItem*) _tmp13_;
#line 1501 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp14_ = new_exposed_items;
#line 1501 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp15_ = item;
#line 1501 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp15_);
#line 1504 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp16_ = self->priv->exposed_items;
#line 1504 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp17_ = item;
#line 1504 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp18_ = gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp17_);
#line 1504 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp18_) {
#line 9149 "CheckerboardLayout.c"
				CheckerboardItem* _tmp19_;
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = item;
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_exposed (_tmp19_);
#line 9155 "CheckerboardLayout.c"
			}
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (item);
#line 9159 "CheckerboardLayout.c"
		}
#line 1500 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_item_list);
#line 9163 "CheckerboardLayout.c"
	}
	{
		GeeIterator* _item_it = NULL;
		GeeHashSet* _tmp20_;
		GeeIterator* _tmp21_;
#line 1509 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = self->priv->exposed_items;
#line 1509 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1509 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_it = _tmp21_;
#line 1509 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 9177 "CheckerboardLayout.c"
			GeeIterator* _tmp22_;
			gboolean _tmp23_;
			CheckerboardItem* item = NULL;
			GeeIterator* _tmp24_;
			gpointer _tmp25_;
			CheckerboardItem* _tmp26_;
#line 1509 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp22_ = _item_it;
#line 1509 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp23_ = gee_iterator_next (_tmp22_);
#line 1509 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp23_) {
#line 1509 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 9192 "CheckerboardLayout.c"
			}
#line 1509 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp24_ = _item_it;
#line 1509 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp25_ = gee_iterator_get (_tmp24_);
#line 1509 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = (CheckerboardItem*) _tmp25_;
#line 1510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp26_ = item;
#line 1510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_item_unexposed (_tmp26_);
#line 1509 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (item);
#line 9206 "CheckerboardLayout.c"
		}
#line 1509 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_item_it);
#line 9210 "CheckerboardLayout.c"
	}
#line 1513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp27_ = new_exposed_items;
#line 1513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp28_ = _g_object_ref0 (_tmp27_);
#line 1513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->exposed_items);
#line 1513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposed_items = _tmp28_;
#line 1514 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure_dirty = FALSE;
#line 1519 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp29_ = self->priv->view;
#line 1519 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_collection_thaw_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_DATA_COLLECTION, DataCollection));
#line 1492 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (items);
#line 1492 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (new_exposed_items);
#line 9230 "CheckerboardLayout.c"
}


static void checkerboard_layout_unexpose_items (CheckerboardLayout* self, const gchar* caller) {
	ViewCollection* _tmp0_;
	GeeHashSet* _tmp8_;
	ViewCollection* _tmp9_;
#line 1525 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1525 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (caller != NULL);
#line 1526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->view;
#line 1526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_collection_freeze_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection));
#line 9246 "CheckerboardLayout.c"
	{
		GeeIterator* _item_it = NULL;
		GeeHashSet* _tmp1_;
		GeeIterator* _tmp2_;
#line 1528 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = self->priv->exposed_items;
#line 1528 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1528 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_it = _tmp2_;
#line 1528 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 9259 "CheckerboardLayout.c"
			GeeIterator* _tmp3_;
			gboolean _tmp4_;
			CheckerboardItem* item = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			CheckerboardItem* _tmp7_;
#line 1528 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp3_ = _item_it;
#line 1528 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp4_ = gee_iterator_next (_tmp3_);
#line 1528 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp4_) {
#line 1528 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 9274 "CheckerboardLayout.c"
			}
#line 1528 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp5_ = _item_it;
#line 1528 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 1528 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = (CheckerboardItem*) _tmp6_;
#line 1529 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp7_ = item;
#line 1529 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_item_unexposed (_tmp7_);
#line 1528 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (item);
#line 9288 "CheckerboardLayout.c"
		}
#line 1528 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_item_it);
#line 9292 "CheckerboardLayout.c"
	}
#line 1531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = self->priv->exposed_items;
#line 1531 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1532 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure_dirty = FALSE;
#line 1537 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->view;
#line 1537 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_collection_thaw_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_COLLECTION, DataCollection));
#line 9304 "CheckerboardLayout.c"
}


static void checkerboard_layout_reflow (CheckerboardLayout* self, const gchar* caller) {
	const gchar* _tmp0_;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp1_ = {0};
	gint _tmp2_ = 0;
	GdkRectangle _tmp3_;
	gint _tmp4_;
	gint visible_width = 0;
	gint _tmp9_;
	gint total_items = 0;
	ViewCollection* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gboolean _tmp15_ = FALSE;
	CheckerboardItem* _tmp16_;
	gint max_cols = 0;
	gint _tmp19_;
	gint _tmp64_;
	gint max_rows = 0;
	gint _tmp65_;
	gint _tmp66_;
	gint row = 0;
	gint tallest = 0;
	gint widest = 0;
	gint row_alignment_point = 0;
	gint total_width = 0;
	gint col = 0;
	gint* column_widths = NULL;
	gint _tmp67_;
	gint* _tmp68_;
	gint column_widths_length1;
	gint _column_widths_size_;
	gint* row_heights = NULL;
	gint _tmp69_;
	gint* _tmp70_;
	gint row_heights_length1;
	gint _row_heights_size_;
	gint* alignment_points = NULL;
	gint _tmp71_;
	gint* _tmp72_;
	gint alignment_points_length1;
	gint _alignment_points_size_;
	gint gutter = 0;
	gint _tmp183_;
	CheckerboardLayoutLayoutRow** _tmp184_;
	gint x = 0;
	gint _tmp185_;
	gint y = 0;
	CheckerboardLayoutLayoutRow* current_row = NULL;
	CheckerboardLayoutLayoutRow* _tmp255_;
	gint _tmp261_;
	gint _tmp262_;
	gint _tmp263_;
	gint _tmp264_;
	gint total_height = 0;
	gint _tmp265_;
	gint* _tmp266_;
	gint _tmp266__length1;
	gint _tmp267_;
	gint _tmp268_;
	gboolean _tmp269_ = FALSE;
	gint _tmp270_;
	GtkAllocation _tmp271_;
	gint _tmp272_;
#line 1543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (caller != NULL);
#line 1544 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->reflow_needed = FALSE;
#line 1547 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->message;
#line 1547 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ != NULL) {
#line 1548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 9384 "CheckerboardLayout.c"
	}
#line 1551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp1_);
#line 1551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	allocation = _tmp1_;
#line 1553 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->visible_page;
#line 1553 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_.width;
#line 1553 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_ > 0) {
#line 9396 "CheckerboardLayout.c"
		GdkRectangle _tmp5_;
		gint _tmp6_;
#line 1553 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = self->priv->visible_page;
#line 1553 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = _tmp5_.width;
#line 1553 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = _tmp6_;
#line 9405 "CheckerboardLayout.c"
	} else {
		GtkAllocation _tmp7_;
		gint _tmp8_;
#line 1553 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = allocation;
#line 1553 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = _tmp7_.width;
#line 1553 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = _tmp8_;
#line 9415 "CheckerboardLayout.c"
	}
#line 1553 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	visible_width = _tmp2_;
#line 1561 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = visible_width;
#line 1561 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp9_ <= 1) {
#line 1562 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 9425 "CheckerboardLayout.c"
	}
#line 1564 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = self->priv->view;
#line 1564 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_COLLECTION, DataCollection));
#line 1564 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	total_items = _tmp11_;
#line 1567 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = total_items;
#line 1567 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp12_ == 0) {
#line 9437 "CheckerboardLayout.c"
		gint _tmp13_;
		CheckerboardLayoutLayoutRow** _tmp14_;
#line 1568 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = visible_width;
#line 1568 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp13_, 0);
#line 1569 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = g_new0 (CheckerboardLayoutLayoutRow*, 0 + 1);
#line 1569 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
#line 1569 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->item_rows = _tmp14_;
#line 1569 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->item_rows_length1 = 0;
#line 1569 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->_item_rows_size_ = self->priv->item_rows_length1;
#line 1571 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 9456 "CheckerboardLayout.c"
	}
#line 1579 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = self->priv->anchor;
#line 1579 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp16_ == NULL) {
#line 1579 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = TRUE;
#line 9464 "CheckerboardLayout.c"
	} else {
		CheckerboardItem* _tmp17_;
		gboolean _tmp18_;
#line 1579 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = self->priv->anchor;
#line 1579 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = data_view_is_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_DATA_VIEW, DataView));
#line 1579 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = !_tmp18_;
#line 9474 "CheckerboardLayout.c"
	}
#line 1579 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp15_) {
#line 1580 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_update_anchor (self);
#line 9480 "CheckerboardLayout.c"
	}
#line 1583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
#line 1583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = NULL;
#line 1583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows_length1 = 0;
#line 1583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
#line 1588 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	max_cols = 0;
#line 1589 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp19_ = self->priv->scale;
#line 1589 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp19_ > 0) {
#line 9496 "CheckerboardLayout.c"
		gint remaining_width = 0;
		gint _tmp20_;
		gint max_item_width = 0;
		gint _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _tmp33_;
		gint _tmp34_;
#line 1591 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = visible_width;
#line 1591 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		remaining_width = _tmp20_ - (CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING * 2);
#line 1592 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = self->priv->scale;
#line 1592 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = checkerboard_item_get_max_width (_tmp21_);
#line 1592 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		max_item_width = _tmp22_;
#line 1593 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp23_ = remaining_width;
#line 1593 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp24_ = max_item_width;
#line 1593 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		max_cols = _tmp23_ / _tmp24_;
#line 1594 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp25_ = max_cols;
#line 1594 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp25_ <= 0) {
#line 1595 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			max_cols = 1;
#line 9529 "CheckerboardLayout.c"
		}
#line 1598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 9533 "CheckerboardLayout.c"
			gboolean _tmp26_ = FALSE;
			gint _tmp27_;
			gint _tmp32_;
#line 1598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp27_ = max_cols;
#line 1598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp27_ > 1) {
#line 9541 "CheckerboardLayout.c"
				gint _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
#line 1599 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp28_ = max_cols;
#line 1599 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp29_ = max_item_width;
#line 1599 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp30_ = max_cols;
#line 1599 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp31_ = remaining_width;
#line 1599 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp26_ = ((_tmp28_ * _tmp29_) + ((_tmp30_ - 1) * CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING)) > _tmp31_;
#line 9556 "CheckerboardLayout.c"
			} else {
#line 1598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp26_ = FALSE;
#line 9560 "CheckerboardLayout.c"
			}
#line 1598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp26_) {
#line 1598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 9566 "CheckerboardLayout.c"
			}
#line 1604 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp32_ = max_cols;
#line 1604 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			max_cols = _tmp32_ - 1;
#line 9572 "CheckerboardLayout.c"
		}
#line 1608 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp33_ = total_items;
#line 1608 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp34_ = max_cols;
#line 1608 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp33_ < _tmp34_) {
#line 9580 "CheckerboardLayout.c"
			gint _tmp35_;
#line 1609 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp35_ = total_items;
#line 1609 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			max_cols = _tmp35_;
#line 9586 "CheckerboardLayout.c"
		}
	} else {
		gint x = 0;
		gint col = 0;
		gint row_width = 0;
		gint widest_row = 0;
		gint _tmp61_;
		gint _tmp62_;
#line 1616 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING;
#line 1617 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		col = 0;
#line 1618 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		row_width = 0;
#line 1619 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		widest_row = 0;
#line 9603 "CheckerboardLayout.c"
		{
			gint ctr = 0;
#line 1621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			ctr = 0;
#line 9608 "CheckerboardLayout.c"
			{
				gboolean _tmp36_ = FALSE;
#line 1621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp36_ = TRUE;
#line 1621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				while (TRUE) {
#line 9615 "CheckerboardLayout.c"
					gint _tmp38_;
					gint _tmp39_;
					CheckerboardItem* item = NULL;
					ViewCollection* _tmp40_;
					gint _tmp41_;
					DataObject* _tmp42_;
					Dimensions req = {0};
					CheckerboardItem* _tmp43_;
					Dimensions _tmp44_;
					gboolean _tmp45_;
					gint _tmp46_;
					Dimensions _tmp47_;
					gint _tmp48_;
					gint _tmp49_;
					gint _tmp54_;
					Dimensions _tmp55_;
					gint _tmp56_;
					gint _tmp57_;
					Dimensions _tmp58_;
					gint _tmp59_;
					gint _tmp60_;
#line 1621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					if (!_tmp36_) {
#line 9639 "CheckerboardLayout.c"
						gint _tmp37_;
#line 1621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp37_ = ctr;
#line 1621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						ctr = _tmp37_ + 1;
#line 9645 "CheckerboardLayout.c"
					}
#line 1621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp36_ = FALSE;
#line 1621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp38_ = ctr;
#line 1621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp39_ = total_items;
#line 1621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					if (!(_tmp38_ < _tmp39_)) {
#line 1621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						break;
#line 9657 "CheckerboardLayout.c"
					}
#line 1622 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp40_ = self->priv->view;
#line 1622 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp41_ = ctr;
#line 1622 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp42_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, TYPE_DATA_COLLECTION, DataCollection), _tmp41_);
#line 1622 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					item = G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 1623 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp43_ = item;
#line 1623 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp44_ = _tmp43_->requisition;
#line 1623 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					req = _tmp44_;
#line 1626 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp45_ = dimensions_has_area (&req);
#line 1626 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_vala_assert (_tmp45_, "req.has_area()");
#line 1629 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp46_ = x;
#line 1629 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp47_ = req;
#line 1629 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp48_ = _tmp47_.width;
#line 1629 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp49_ = visible_width;
#line 1629 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					if (((_tmp46_ + _tmp48_) + CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING) > _tmp49_) {
#line 9687 "CheckerboardLayout.c"
						gint _tmp50_;
						gint _tmp51_;
#line 1630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp50_ = row_width;
#line 1630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp51_ = widest_row;
#line 1630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp50_ > _tmp51_) {
#line 9696 "CheckerboardLayout.c"
							gint _tmp52_;
							gint _tmp53_;
#line 1631 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp52_ = row_width;
#line 1631 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							widest_row = _tmp52_;
#line 1632 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp53_ = col;
#line 1632 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							max_cols = _tmp53_;
#line 9707 "CheckerboardLayout.c"
						}
#line 1635 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						col = 0;
#line 1636 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						x = CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING;
#line 1637 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						row_width = 0;
#line 9715 "CheckerboardLayout.c"
					}
#line 1640 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp54_ = x;
#line 1640 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp55_ = req;
#line 1640 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp56_ = _tmp55_.width;
#line 1640 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					x = _tmp54_ + (_tmp56_ + CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING);
#line 1641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp57_ = row_width;
#line 1641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp58_ = req;
#line 1641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp59_ = _tmp58_.width;
#line 1641 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					row_width = _tmp57_ + _tmp59_;
#line 1643 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp60_ = col;
#line 1643 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = _tmp60_ + 1;
#line 1621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_g_object_unref0 (item);
#line 9739 "CheckerboardLayout.c"
				}
			}
		}
#line 1647 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp61_ = row_width;
#line 1647 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp62_ = widest_row;
#line 1647 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp61_ > _tmp62_) {
#line 9749 "CheckerboardLayout.c"
			gint _tmp63_;
#line 1648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp63_ = col;
#line 1648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			max_cols = _tmp63_;
#line 9755 "CheckerboardLayout.c"
		}
	}
#line 1656 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp64_ = max_cols;
#line 1656 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (_tmp64_ > 0, "max_cols > 0");
#line 1657 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp65_ = total_items;
#line 1657 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp66_ = max_cols;
#line 1657 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	max_rows = (_tmp65_ / _tmp66_) + 1;
#line 1661 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row = 0;
#line 1662 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	tallest = 0;
#line 1663 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	widest = 0;
#line 1664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row_alignment_point = 0;
#line 1665 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	total_width = 0;
#line 1666 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	col = 0;
#line 1667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp67_ = max_cols;
#line 1667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp68_ = g_new0 (gint, _tmp67_);
#line 1667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	column_widths = _tmp68_;
#line 1667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	column_widths_length1 = _tmp67_;
#line 1667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_column_widths_size_ = column_widths_length1;
#line 1668 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp69_ = max_rows;
#line 1668 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp70_ = g_new0 (gint, _tmp69_);
#line 1668 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row_heights = _tmp70_;
#line 1668 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row_heights_length1 = _tmp69_;
#line 1668 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_row_heights_size_ = row_heights_length1;
#line 1669 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp71_ = max_rows;
#line 1669 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp72_ = g_new0 (gint, _tmp71_);
#line 1669 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	alignment_points = _tmp72_;
#line 1669 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	alignment_points_length1 = _tmp71_;
#line 1669 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_alignment_points_size_ = alignment_points_length1;
#line 1670 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gutter = 0;
#line 9812 "CheckerboardLayout.c"
	{
		gboolean _tmp73_ = FALSE;
#line 1672 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp73_ = TRUE;
#line 1672 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 9819 "CheckerboardLayout.c"
			gint _tmp129_;
			gint _tmp138_;
			gint _tmp139_;
			gint _tmp140_;
			gint _tmp141_;
			gint _tmp142_;
#line 1672 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp73_) {
#line 9828 "CheckerboardLayout.c"
			}
#line 1672 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp73_ = FALSE;
#line 9832 "CheckerboardLayout.c"
			{
				gint ctr = 0;
#line 1673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				ctr = 0;
#line 9837 "CheckerboardLayout.c"
				{
					gboolean _tmp74_ = FALSE;
#line 1673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp74_ = TRUE;
#line 1673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					while (TRUE) {
#line 9844 "CheckerboardLayout.c"
						gint _tmp76_;
						gint _tmp77_;
						CheckerboardItem* item = NULL;
						ViewCollection* _tmp78_;
						gint _tmp79_;
						DataObject* _tmp80_;
						Dimensions req = {0};
						CheckerboardItem* _tmp81_;
						Dimensions _tmp82_;
						gint alignment_point = 0;
						CheckerboardItem* _tmp83_;
						gint _tmp84_;
						gint _tmp85_;
						Dimensions _tmp86_;
						gint _tmp87_;
						Dimensions _tmp88_;
						gint _tmp89_;
						gint _tmp90_;
						Dimensions _tmp93_;
						gint _tmp94_;
						gint _tmp95_;
						gint _tmp98_;
						gint _tmp99_;
						gint* _tmp101_;
						gint _tmp101__length1;
						gint _tmp102_;
						gint _tmp103_;
						Dimensions _tmp104_;
						gint _tmp105_;
						gint _tmp118_;
						gint _tmp119_;
						gint _tmp120_;
#line 1673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (!_tmp74_) {
#line 9879 "CheckerboardLayout.c"
							gint _tmp75_;
#line 1673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp75_ = ctr;
#line 1673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							ctr = _tmp75_ + 1;
#line 9885 "CheckerboardLayout.c"
						}
#line 1673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp74_ = FALSE;
#line 1673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp76_ = ctr;
#line 1673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp77_ = total_items;
#line 1673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (!(_tmp76_ < _tmp77_)) {
#line 1673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							break;
#line 9897 "CheckerboardLayout.c"
						}
#line 1674 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp78_ = self->priv->view;
#line 1674 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp79_ = ctr;
#line 1674 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp80_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, TYPE_DATA_COLLECTION, DataCollection), _tmp79_);
#line 1674 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						item = G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 1675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp81_ = item;
#line 1675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp82_ = _tmp81_->requisition;
#line 1675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						req = _tmp82_;
#line 1676 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp83_ = item;
#line 1676 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp84_ = checkerboard_item_get_alignment_point (_tmp83_);
#line 1676 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						alignment_point = _tmp84_;
#line 1679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp85_ = alignment_point;
#line 1679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp86_ = req;
#line 1679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp87_ = _tmp86_.height;
#line 1679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_vala_assert (_tmp85_ < _tmp87_, "alignment_point < req.height");
#line 1681 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp88_ = req;
#line 1681 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp89_ = _tmp88_.height;
#line 1681 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp90_ = tallest;
#line 1681 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp89_ > _tmp90_) {
#line 9935 "CheckerboardLayout.c"
							Dimensions _tmp91_;
							gint _tmp92_;
#line 1682 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp91_ = req;
#line 1682 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp92_ = _tmp91_.height;
#line 1682 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							tallest = _tmp92_;
#line 9944 "CheckerboardLayout.c"
						}
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp93_ = req;
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp94_ = _tmp93_.width;
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp95_ = widest;
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp94_ > _tmp95_) {
#line 9954 "CheckerboardLayout.c"
							Dimensions _tmp96_;
							gint _tmp97_;
#line 1685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp96_ = req;
#line 1685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp97_ = _tmp96_.width;
#line 1685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							widest = _tmp97_;
#line 9963 "CheckerboardLayout.c"
						}
#line 1687 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp98_ = alignment_point;
#line 1687 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp99_ = row_alignment_point;
#line 1687 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp98_ > _tmp99_) {
#line 9971 "CheckerboardLayout.c"
							gint _tmp100_;
#line 1688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp100_ = alignment_point;
#line 1688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							row_alignment_point = _tmp100_;
#line 9977 "CheckerboardLayout.c"
						}
#line 1692 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp101_ = column_widths;
#line 1692 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp101__length1 = column_widths_length1;
#line 1692 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp102_ = col;
#line 1692 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp103_ = _tmp101_[_tmp102_];
#line 1692 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp104_ = req;
#line 1692 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp105_ = _tmp104_.width;
#line 1692 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp103_ < _tmp105_) {
#line 9993 "CheckerboardLayout.c"
							gint _tmp106_;
							gint* _tmp107_;
							gint _tmp107__length1;
							gint _tmp108_;
							gint _tmp109_;
							gint* _tmp110_;
							gint _tmp110__length1;
							gint _tmp111_;
							Dimensions _tmp112_;
							gint _tmp113_;
							gint _tmp114_;
							gint _tmp115_;
							Dimensions _tmp116_;
							gint _tmp117_;
#line 1693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp106_ = total_width;
#line 1693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp107_ = column_widths;
#line 1693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp107__length1 = column_widths_length1;
#line 1693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp108_ = col;
#line 1693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp109_ = _tmp107_[_tmp108_];
#line 1693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							total_width = _tmp106_ - _tmp109_;
#line 1694 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp110_ = column_widths;
#line 1694 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp110__length1 = column_widths_length1;
#line 1694 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp111_ = col;
#line 1694 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp112_ = req;
#line 1694 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp113_ = _tmp112_.width;
#line 1694 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp110_[_tmp111_] = _tmp113_;
#line 1694 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp114_ = _tmp110_[_tmp111_];
#line 1695 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp115_ = total_width;
#line 1695 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp116_ = req;
#line 1695 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp117_ = _tmp116_.width;
#line 1695 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							total_width = _tmp115_ + _tmp117_;
#line 10042 "CheckerboardLayout.c"
						}
#line 1698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp118_ = col;
#line 1698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						col = _tmp118_ + 1;
#line 1698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp119_ = col;
#line 1698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp120_ = max_cols;
#line 1698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp119_ >= _tmp120_) {
#line 10054 "CheckerboardLayout.c"
							gint* _tmp121_;
							gint _tmp121__length1;
							gint _tmp122_;
							gint _tmp123_;
							gint _tmp124_;
							gint* _tmp125_;
							gint _tmp125__length1;
							gint _tmp126_;
							gint _tmp127_;
							gint _tmp128_;
#line 1699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp121_ = alignment_points;
#line 1699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp121__length1 = alignment_points_length1;
#line 1699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp122_ = row;
#line 1699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp123_ = row_alignment_point;
#line 1699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp121_[_tmp122_] = _tmp123_;
#line 1699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp124_ = _tmp121_[_tmp122_];
#line 1700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp125_ = row_heights;
#line 1700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp125__length1 = row_heights_length1;
#line 1700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp126_ = row;
#line 1700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							row = _tmp126_ + 1;
#line 1700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp127_ = tallest;
#line 1700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp125_[_tmp126_] = _tmp127_;
#line 1700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp128_ = _tmp125_[_tmp126_];
#line 1702 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							col = 0;
#line 1703 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							row_alignment_point = 0;
#line 1704 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							tallest = 0;
#line 10097 "CheckerboardLayout.c"
						}
#line 1673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_g_object_unref0 (item);
#line 10101 "CheckerboardLayout.c"
					}
				}
			}
#line 1709 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp129_ = col;
#line 1709 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp129_ != 0) {
#line 10109 "CheckerboardLayout.c"
				gint* _tmp130_;
				gint _tmp130__length1;
				gint _tmp131_;
				gint _tmp132_;
				gint _tmp133_;
				gint* _tmp134_;
				gint _tmp134__length1;
				gint _tmp135_;
				gint _tmp136_;
				gint _tmp137_;
#line 1710 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp130_ = alignment_points;
#line 1710 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp130__length1 = alignment_points_length1;
#line 1710 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp131_ = row;
#line 1710 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp132_ = row_alignment_point;
#line 1710 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp130_[_tmp131_] = _tmp132_;
#line 1710 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp133_ = _tmp130_[_tmp131_];
#line 1711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp134_ = row_heights;
#line 1711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp134__length1 = row_heights_length1;
#line 1711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp135_ = row;
#line 1711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp136_ = tallest;
#line 1711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp134_[_tmp135_] = _tmp136_;
#line 1711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp137_ = _tmp134_[_tmp135_];
#line 10144 "CheckerboardLayout.c"
			}
#line 1716 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp138_ = visible_width;
#line 1716 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp139_ = total_width;
#line 1716 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp140_ = max_cols;
#line 1716 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gutter = (_tmp138_ - _tmp139_) / (_tmp140_ + 1);
#line 1719 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp141_ = max_cols;
#line 1719 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp141_ == 1) {
#line 1720 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 10160 "CheckerboardLayout.c"
			}
#line 1725 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp142_ = gutter;
#line 1725 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp142_ < CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING) {
#line 10166 "CheckerboardLayout.c"
				gint _tmp143_;
				gint _tmp144_;
				gint _tmp145_;
				gint _tmp146_;
				gint* _tmp147_;
				gint _tmp148_;
				gint* _tmp149_;
				gint _tmp150_;
				gint* _tmp151_;
#line 1726 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp143_ = max_cols;
#line 1726 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				max_cols = _tmp143_ - 1;
#line 1727 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp144_ = total_items;
#line 1727 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp145_ = max_cols;
#line 1727 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				max_rows = (_tmp144_ / _tmp145_) + 1;
#line 1734 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				col = 0;
#line 1735 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row = 0;
#line 1736 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				tallest = 0;
#line 1737 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				widest = 0;
#line 1738 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				total_width = 0;
#line 1739 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_alignment_point = 0;
#line 1740 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp146_ = max_cols;
#line 1740 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp147_ = g_new0 (gint, _tmp146_);
#line 1740 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				column_widths = (g_free (column_widths), NULL);
#line 1740 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				column_widths = _tmp147_;
#line 1740 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				column_widths_length1 = _tmp146_;
#line 1740 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_column_widths_size_ = column_widths_length1;
#line 1741 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp148_ = max_rows;
#line 1741 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp149_ = g_new0 (gint, _tmp148_);
#line 1741 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_heights = (g_free (row_heights), NULL);
#line 1741 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_heights = _tmp149_;
#line 1741 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_heights_length1 = _tmp148_;
#line 1741 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_row_heights_size_ = row_heights_length1;
#line 1742 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp150_ = max_rows;
#line 1742 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp151_ = g_new0 (gint, _tmp150_);
#line 1742 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				alignment_points = (g_free (alignment_points), NULL);
#line 1742 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				alignment_points = _tmp151_;
#line 1742 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				alignment_points_length1 = _tmp150_;
#line 1742 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_alignment_points_size_ = alignment_points_length1;
#line 10234 "CheckerboardLayout.c"
			} else {
#line 1744 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 10238 "CheckerboardLayout.c"
			}
		}
	}
#line 1756 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	col = 0;
#line 1757 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row = 0;
#line 10246 "CheckerboardLayout.c"
	{
		gint ctr = 0;
#line 1759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		ctr = 0;
#line 10251 "CheckerboardLayout.c"
		{
			gboolean _tmp152_ = FALSE;
#line 1759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp152_ = TRUE;
#line 1759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			while (TRUE) {
#line 10258 "CheckerboardLayout.c"
				gint _tmp154_;
				gint _tmp155_;
				CheckerboardItem* item = NULL;
				ViewCollection* _tmp156_;
				gint _tmp157_;
				DataObject* _tmp158_;
				Dimensions req = {0};
				CheckerboardItem* _tmp159_;
				Dimensions _tmp160_;
				gint true_height = 0;
				Dimensions _tmp161_;
				gint _tmp162_;
				gint* _tmp163_;
				gint _tmp163__length1;
				gint _tmp164_;
				gint _tmp165_;
				CheckerboardItem* _tmp166_;
				gint _tmp167_;
				gint _tmp168_;
				Dimensions _tmp169_;
				gint _tmp170_;
				gint _tmp171_;
				gint* _tmp172_;
				gint _tmp172__length1;
				gint _tmp173_;
				gint _tmp174_;
				gint _tmp179_;
				gint _tmp180_;
				gint _tmp181_;
#line 1759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!_tmp152_) {
#line 10290 "CheckerboardLayout.c"
					gint _tmp153_;
#line 1759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp153_ = ctr;
#line 1759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					ctr = _tmp153_ + 1;
#line 10296 "CheckerboardLayout.c"
				}
#line 1759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp152_ = FALSE;
#line 1759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp154_ = ctr;
#line 1759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp155_ = total_items;
#line 1759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!(_tmp154_ < _tmp155_)) {
#line 1759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 10308 "CheckerboardLayout.c"
				}
#line 1760 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp156_ = self->priv->view;
#line 1760 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp157_ = ctr;
#line 1760 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp158_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp156_, TYPE_DATA_COLLECTION, DataCollection), _tmp157_);
#line 1760 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp158_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 1761 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp159_ = item;
#line 1761 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp160_ = _tmp159_->requisition;
#line 1761 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				req = _tmp160_;
#line 1766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp161_ = req;
#line 1766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp162_ = _tmp161_.height;
#line 1766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp163_ = alignment_points;
#line 1766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp163__length1 = alignment_points_length1;
#line 1766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp164_ = row;
#line 1766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp165_ = _tmp163_[_tmp164_];
#line 1766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp166_ = item;
#line 1766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp167_ = checkerboard_item_get_alignment_point (_tmp166_);
#line 1766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				true_height = _tmp162_ + (_tmp165_ - _tmp167_);
#line 1767 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp168_ = true_height;
#line 1767 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp169_ = req;
#line 1767 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp170_ = _tmp169_.height;
#line 1767 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_vala_assert (_tmp168_ >= _tmp170_, "true_height >= req.height");
#line 1770 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp171_ = true_height;
#line 1770 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp172_ = row_heights;
#line 1770 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp172__length1 = row_heights_length1;
#line 1770 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp173_ = row;
#line 1770 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp174_ = _tmp172_[_tmp173_];
#line 1770 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp171_ > _tmp174_) {
#line 10362 "CheckerboardLayout.c"
					gint* _tmp175_;
					gint _tmp175__length1;
					gint _tmp176_;
					gint _tmp177_;
					gint _tmp178_;
#line 1775 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp175_ = row_heights;
#line 1775 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp175__length1 = row_heights_length1;
#line 1775 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp176_ = row;
#line 1775 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp177_ = true_height;
#line 1775 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp175_[_tmp176_] = _tmp177_;
#line 1775 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp178_ = _tmp175_[_tmp176_];
#line 10380 "CheckerboardLayout.c"
				}
#line 1779 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp179_ = col;
#line 1779 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				col = _tmp179_ + 1;
#line 1779 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp180_ = col;
#line 1779 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp181_ = max_cols;
#line 1779 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp180_ >= _tmp181_) {
#line 10392 "CheckerboardLayout.c"
					gint _tmp182_;
#line 1780 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = 0;
#line 1781 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp182_ = row;
#line 1781 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					row = _tmp182_ + 1;
#line 10400 "CheckerboardLayout.c"
				}
#line 1759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 10404 "CheckerboardLayout.c"
			}
		}
	}
#line 1786 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp183_ = max_rows;
#line 1786 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp184_ = g_new0 (CheckerboardLayoutLayoutRow*, _tmp183_ + 1);
#line 1786 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
#line 1786 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = _tmp184_;
#line 1786 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows_length1 = _tmp183_;
#line 1786 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
#line 1789 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp185_ = gutter;
#line 1789 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	x = _tmp185_;
#line 1790 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	y = CHECKERBOARD_LAYOUT_TOP_PADDING;
#line 1791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	col = 0;
#line 1792 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row = 0;
#line 1793 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	current_row = NULL;
#line 10432 "CheckerboardLayout.c"
	{
		gint ctr = 0;
#line 1795 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		ctr = 0;
#line 10437 "CheckerboardLayout.c"
		{
			gboolean _tmp186_ = FALSE;
#line 1795 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp186_ = TRUE;
#line 1795 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			while (TRUE) {
#line 10444 "CheckerboardLayout.c"
				gint _tmp188_;
				gint _tmp189_;
				CheckerboardItem* item = NULL;
				ViewCollection* _tmp190_;
				gint _tmp191_;
				DataObject* _tmp192_;
				Dimensions req = {0};
				CheckerboardItem* _tmp193_;
				Dimensions _tmp194_;
				gint xpadding = 0;
				gint* _tmp195_;
				gint _tmp195__length1;
				gint _tmp196_;
				gint _tmp197_;
				Dimensions _tmp198_;
				gint _tmp199_;
				gint _tmp200_;
				gint ypadding = 0;
				gint* _tmp201_;
				gint _tmp201__length1;
				gint _tmp202_;
				gint _tmp203_;
				CheckerboardItem* _tmp204_;
				gint _tmp205_;
				gint _tmp206_;
				CheckerboardItem* _tmp207_;
				gint _tmp208_;
				gint _tmp209_;
				CheckerboardItem* _tmp210_;
				gint _tmp211_;
				gint _tmp212_;
				CheckerboardItem* _tmp213_;
				Dimensions _tmp214_;
				gint _tmp215_;
				CheckerboardItem* _tmp216_;
				Dimensions _tmp217_;
				gint _tmp218_;
				CheckerboardItem* _tmp219_;
				gint _tmp220_;
				gint _tmp221_;
				CheckerboardLayoutLayoutRow* _tmp222_;
				CheckerboardLayoutLayoutRow* _tmp229_;
				CheckerboardItem** _tmp230_;
				gint _tmp230__length1;
				gint _tmp231_;
				CheckerboardItem* _tmp232_;
				CheckerboardItem* _tmp233_;
				CheckerboardItem* _tmp234_;
				gint _tmp235_;
				gint* _tmp236_;
				gint _tmp236__length1;
				gint _tmp237_;
				gint _tmp238_;
				gint _tmp239_;
				gint _tmp240_;
				gint _tmp241_;
				gint _tmp242_;
#line 1795 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!_tmp186_) {
#line 10504 "CheckerboardLayout.c"
					gint _tmp187_;
#line 1795 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp187_ = ctr;
#line 1795 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					ctr = _tmp187_ + 1;
#line 10510 "CheckerboardLayout.c"
				}
#line 1795 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp186_ = FALSE;
#line 1795 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp188_ = ctr;
#line 1795 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp189_ = total_items;
#line 1795 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!(_tmp188_ < _tmp189_)) {
#line 1795 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 10522 "CheckerboardLayout.c"
				}
#line 1796 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp190_ = self->priv->view;
#line 1796 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp191_ = ctr;
#line 1796 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp192_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp190_, TYPE_DATA_COLLECTION, DataCollection), _tmp191_);
#line 1796 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp192_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 1797 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp193_ = item;
#line 1797 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp194_ = _tmp193_->requisition;
#line 1797 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				req = _tmp194_;
#line 1800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp195_ = column_widths;
#line 1800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp195__length1 = column_widths_length1;
#line 1800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp196_ = col;
#line 1800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp197_ = _tmp195_[_tmp196_];
#line 1800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp198_ = req;
#line 1800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp199_ = _tmp198_.width;
#line 1800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				xpadding = (_tmp197_ - _tmp199_) / 2;
#line 1801 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp200_ = xpadding;
#line 1801 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_vala_assert (_tmp200_ >= 0, "xpadding >= 0");
#line 1804 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp201_ = alignment_points;
#line 1804 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp201__length1 = alignment_points_length1;
#line 1804 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp202_ = row;
#line 1804 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp203_ = _tmp201_[_tmp202_];
#line 1804 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp204_ = item;
#line 1804 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp205_ = checkerboard_item_get_alignment_point (_tmp204_);
#line 1804 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				ypadding = _tmp203_ - _tmp205_;
#line 1805 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp206_ = ypadding;
#line 1805 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_vala_assert (_tmp206_ >= 0, "ypadding >= 0");
#line 1808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp207_ = item;
#line 1808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp208_ = x;
#line 1808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp209_ = xpadding;
#line 1808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp207_->allocation.x = _tmp208_ + _tmp209_;
#line 1809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp210_ = item;
#line 1809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp211_ = y;
#line 1809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp212_ = ypadding;
#line 1809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp210_->allocation.y = _tmp211_ + _tmp212_;
#line 1810 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp213_ = item;
#line 1810 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp214_ = req;
#line 1810 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp215_ = _tmp214_.width;
#line 1810 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp213_->allocation.width = _tmp215_;
#line 1811 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp216_ = item;
#line 1811 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp217_ = req;
#line 1811 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp218_ = _tmp217_.height;
#line 1811 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp216_->allocation.height = _tmp218_;
#line 1812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp219_ = item;
#line 1812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp220_ = col;
#line 1812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp221_ = row;
#line 1812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_set_grid_coordinates (_tmp219_, _tmp220_, _tmp221_);
#line 1815 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp222_ = current_row;
#line 1815 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp222_ == NULL) {
#line 10618 "CheckerboardLayout.c"
					gint _tmp223_;
					gint* _tmp224_;
					gint _tmp224__length1;
					gint _tmp225_;
					gint _tmp226_;
					gint _tmp227_;
					CheckerboardLayoutLayoutRow* _tmp228_;
#line 1816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp223_ = y;
#line 1816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp224_ = row_heights;
#line 1816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp224__length1 = row_heights_length1;
#line 1816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp225_ = row;
#line 1816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp226_ = _tmp224_[_tmp225_];
#line 1816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp227_ = max_cols;
#line 1816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp228_ = checkerboard_layout_layout_row_new (_tmp223_, _tmp226_, _tmp227_);
#line 1816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (current_row);
#line 1816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					current_row = _tmp228_;
#line 10644 "CheckerboardLayout.c"
				}
#line 1818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp229_ = current_row;
#line 1818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp230_ = _tmp229_->items;
#line 1818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp230__length1 = _tmp229_->items_length1;
#line 1818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp231_ = col;
#line 1818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp232_ = item;
#line 1818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp233_ = _g_object_ref0 (_tmp232_);
#line 1818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (_tmp230_[_tmp231_]);
#line 1818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp230_[_tmp231_] = _tmp233_;
#line 1818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp234_ = _tmp230_[_tmp231_];
#line 1820 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp235_ = x;
#line 1820 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp236_ = column_widths;
#line 1820 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp236__length1 = column_widths_length1;
#line 1820 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp237_ = col;
#line 1820 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp238_ = _tmp236_[_tmp237_];
#line 1820 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp239_ = gutter;
#line 1820 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				x = _tmp235_ + (_tmp238_ + _tmp239_);
#line 1823 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp240_ = col;
#line 1823 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				col = _tmp240_ + 1;
#line 1823 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp241_ = col;
#line 1823 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp242_ = max_cols;
#line 1823 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp241_ >= _tmp242_) {
#line 10688 "CheckerboardLayout.c"
					CheckerboardLayoutLayoutRow* _tmp243_;
					CheckerboardLayoutLayoutRow** _tmp244_;
					gint _tmp244__length1;
					gint _tmp245_;
					CheckerboardLayoutLayoutRow* _tmp246_;
					CheckerboardLayoutLayoutRow* _tmp247_;
					CheckerboardLayoutLayoutRow* _tmp248_;
					gint _tmp249_;
					gint _tmp250_;
					gint* _tmp251_;
					gint _tmp251__length1;
					gint _tmp252_;
					gint _tmp253_;
					gint _tmp254_;
#line 1824 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp243_ = current_row;
#line 1824 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_vala_assert (_tmp243_ != NULL, "current_row != null");
#line 1825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp244_ = self->priv->item_rows;
#line 1825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp244__length1 = self->priv->item_rows_length1;
#line 1825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp245_ = row;
#line 1825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp246_ = current_row;
#line 1825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp247_ = _checkerboard_layout_layout_row_ref0 (_tmp246_);
#line 1825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (_tmp244_[_tmp245_]);
#line 1825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp244_[_tmp245_] = _tmp247_;
#line 1825 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp248_ = _tmp244_[_tmp245_];
#line 1826 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (current_row);
#line 1826 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					current_row = NULL;
#line 1828 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp249_ = gutter;
#line 1828 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					x = _tmp249_;
#line 1829 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp250_ = y;
#line 1829 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp251_ = row_heights;
#line 1829 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp251__length1 = row_heights_length1;
#line 1829 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp252_ = row;
#line 1829 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp253_ = _tmp251_[_tmp252_];
#line 1829 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					y = _tmp250_ + (_tmp253_ + CHECKERBOARD_LAYOUT_ROW_GUTTER_PADDING);
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = 0;
#line 1831 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp254_ = row;
#line 1831 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					row = _tmp254_ + 1;
#line 10749 "CheckerboardLayout.c"
				}
#line 1795 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 10753 "CheckerboardLayout.c"
			}
		}
	}
#line 1836 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp255_ = current_row;
#line 1836 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp255_ != NULL) {
#line 10761 "CheckerboardLayout.c"
		CheckerboardLayoutLayoutRow** _tmp256_;
		gint _tmp256__length1;
		gint _tmp257_;
		CheckerboardLayoutLayoutRow* _tmp258_;
		CheckerboardLayoutLayoutRow* _tmp259_;
		CheckerboardLayoutLayoutRow* _tmp260_;
#line 1837 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp256_ = self->priv->item_rows;
#line 1837 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp256__length1 = self->priv->item_rows_length1;
#line 1837 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp257_ = row;
#line 1837 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp258_ = current_row;
#line 1837 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp259_ = _checkerboard_layout_layout_row_ref0 (_tmp258_);
#line 1837 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_checkerboard_layout_layout_row_unref0 (_tmp256_[_tmp257_]);
#line 1837 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp256_[_tmp257_] = _tmp259_;
#line 1837 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp260_ = _tmp256_[_tmp257_];
#line 10784 "CheckerboardLayout.c"
	}
#line 1840 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp261_ = max_cols;
#line 1840 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->columns = _tmp261_;
#line 1841 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp262_ = row;
#line 1841 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->rows = _tmp262_ + 1;
#line 1842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp263_ = self->priv->rows;
#line 1842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp264_ = max_rows;
#line 1842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (_tmp263_ == _tmp264_, "rows == max_rows");
#line 1846 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp265_ = y;
#line 1846 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp266_ = row_heights;
#line 1846 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp266__length1 = row_heights_length1;
#line 1846 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp267_ = row;
#line 1846 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp268_ = _tmp266_[_tmp267_];
#line 1846 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	total_height = (_tmp265_ + _tmp268_) + CHECKERBOARD_LAYOUT_BOTTOM_PADDING;
#line 1847 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp270_ = visible_width;
#line 1847 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp271_ = allocation;
#line 1847 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp272_ = _tmp271_.width;
#line 1847 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp270_ != _tmp272_) {
#line 1847 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp269_ = TRUE;
#line 10822 "CheckerboardLayout.c"
	} else {
		gint _tmp273_;
		GtkAllocation _tmp274_;
		gint _tmp275_;
#line 1847 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp273_ = total_height;
#line 1847 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp274_ = allocation;
#line 1847 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp275_ = _tmp274_.height;
#line 1847 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp269_ = _tmp273_ != _tmp275_;
#line 10835 "CheckerboardLayout.c"
	}
#line 1847 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp269_) {
#line 10839 "CheckerboardLayout.c"
		gint _tmp276_;
		gint _tmp277_;
		gint _tmp278_;
#line 1852 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp276_ = visible_width;
#line 1852 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp277_ = total_height;
#line 1852 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp276_, _tmp277_);
#line 1853 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->size_allocate_due_to_reflow = TRUE;
#line 1856 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp278_ = total_height;
#line 1856 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_center_on_anchor (self, (gdouble) _tmp278_);
#line 10855 "CheckerboardLayout.c"
	}
#line 1543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_layout_layout_row_unref0 (current_row);
#line 1543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	alignment_points = (g_free (alignment_points), NULL);
#line 1543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row_heights = (g_free (row_heights), NULL);
#line 1543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	column_widths = (g_free (column_widths), NULL);
#line 10865 "CheckerboardLayout.c"
}


static void checkerboard_layout_items_dirty (CheckerboardLayout* self, const gchar* reason, GeeIterable* items) {
	GdkRectangle dirty = {0};
	gboolean _tmp35_ = FALSE;
	GdkRectangle _tmp36_;
	gint _tmp37_;
#line 1860 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1860 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (reason != NULL);
#line 1860 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GEE_IS_ITERABLE (items));
#line 1861 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&dirty, 0, sizeof (GdkRectangle));
#line 10882 "CheckerboardLayout.c"
	{
		GeeIterator* _data_view_it = NULL;
		GeeIterable* _tmp0_;
		GeeIterator* _tmp1_;
#line 1862 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = items;
#line 1862 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = gee_iterable_iterator (_tmp0_);
#line 1862 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_data_view_it = _tmp1_;
#line 1862 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 10895 "CheckerboardLayout.c"
			GeeIterator* _tmp2_;
			gboolean _tmp3_;
			DataView* data_view = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			CheckerboardItem* item = NULL;
			DataView* _tmp6_;
			CheckerboardItem* _tmp7_;
			CheckerboardItem* _tmp8_;
			gboolean _tmp9_;
			ViewCollection* _tmp10_;
			CheckerboardItem* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_ = FALSE;
			CheckerboardItem* _tmp14_;
			GdkRectangle _tmp15_;
			gint _tmp16_;
			GdkRectangle intersection = {0};
			CheckerboardItem* _tmp23_;
			GdkRectangle _tmp24_;
			GdkRectangle _tmp25_ = {0};
			gboolean _tmp26_;
			gboolean _tmp27_ = FALSE;
			GdkRectangle _tmp28_;
			gint _tmp29_;
#line 1862 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp2_ = _data_view_it;
#line 1862 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 1862 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp3_) {
#line 1862 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 10929 "CheckerboardLayout.c"
			}
#line 1862 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp4_ = _data_view_it;
#line 1862 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 1862 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			data_view = (DataView*) _tmp5_;
#line 1863 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp6_ = data_view;
#line 1863 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 1863 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = _tmp7_;
#line 1865 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp8_ = item;
#line 1865 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp9_ = data_view_is_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_VIEW, DataView));
#line 1865 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp9_) {
#line 1866 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 1866 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (data_view);
#line 1866 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				continue;
#line 10955 "CheckerboardLayout.c"
			}
#line 1868 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = self->priv->view;
#line 1868 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = item;
#line 1868 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp12_ = data_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_DATA_OBJECT, DataObject));
#line 1868 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_vala_assert (_tmp12_, "view.contains(item)");
#line 1872 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp14_ = item;
#line 1872 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp15_ = _tmp14_->allocation;
#line 1872 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp16_ = _tmp15_.width;
#line 1872 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp16_ <= 0) {
#line 1872 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp13_ = TRUE;
#line 10975 "CheckerboardLayout.c"
			} else {
				CheckerboardItem* _tmp17_;
				GdkRectangle _tmp18_;
				gint _tmp19_;
#line 1872 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp17_ = item;
#line 1872 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp18_ = _tmp17_->allocation;
#line 1872 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = _tmp18_.height;
#line 1872 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp13_ = _tmp19_ <= 0;
#line 10988 "CheckerboardLayout.c"
			}
#line 1872 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp13_) {
#line 10992 "CheckerboardLayout.c"
				const gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
#line 1873 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp20_ = reason;
#line 1873 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp21_ = g_strdup_printf ("items_dirty: %s", _tmp20_);
#line 1873 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp22_ = _tmp21_;
#line 1873 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_layout_need_reflow (self, _tmp22_);
#line 1873 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_free0 (_tmp22_);
#line 1875 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 1875 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (data_view);
#line 1875 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (_data_view_it);
#line 1875 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				return;
#line 11014 "CheckerboardLayout.c"
			}
#line 1879 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			memset (&intersection, 0, sizeof (GdkRectangle));
#line 1880 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp23_ = item;
#line 1880 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp24_ = _tmp23_->allocation;
#line 1880 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp26_ = gdk_rectangle_intersect (&self->priv->visible_page, &_tmp24_, &_tmp25_);
#line 1880 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			intersection = _tmp25_;
#line 1880 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp26_) {
#line 1881 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 1881 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (data_view);
#line 1881 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				continue;
#line 11034 "CheckerboardLayout.c"
			}
#line 1884 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp28_ = dirty;
#line 1884 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp29_ = _tmp28_.width;
#line 1884 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp29_ == 0) {
#line 1884 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp27_ = TRUE;
#line 11044 "CheckerboardLayout.c"
			} else {
				GdkRectangle _tmp30_;
				gint _tmp31_;
#line 1884 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp30_ = dirty;
#line 1884 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp31_ = _tmp30_.height;
#line 1884 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp27_ = _tmp31_ == 0;
#line 11054 "CheckerboardLayout.c"
			}
#line 1884 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp27_) {
#line 11058 "CheckerboardLayout.c"
				GdkRectangle _tmp32_;
#line 1885 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp32_ = intersection;
#line 1885 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				dirty = _tmp32_;
#line 11064 "CheckerboardLayout.c"
			} else {
				GdkRectangle _tmp33_;
				GdkRectangle _tmp34_ = {0};
#line 1887 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp33_ = intersection;
#line 1887 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				gdk_rectangle_union (&dirty, &_tmp33_, &_tmp34_);
#line 1887 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				dirty = _tmp34_;
#line 11074 "CheckerboardLayout.c"
			}
#line 1862 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (item);
#line 1862 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (data_view);
#line 11080 "CheckerboardLayout.c"
		}
#line 1862 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_data_view_it);
#line 11084 "CheckerboardLayout.c"
	}
#line 1890 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp36_ = dirty;
#line 1890 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp37_ = _tmp36_.width;
#line 1890 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp37_ > 0) {
#line 11092 "CheckerboardLayout.c"
		GdkRectangle _tmp38_;
		gint _tmp39_;
#line 1890 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp38_ = dirty;
#line 1890 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp39_ = _tmp38_.height;
#line 1890 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp35_ = _tmp39_ > 0;
#line 11101 "CheckerboardLayout.c"
	} else {
#line 1890 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp35_ = FALSE;
#line 11105 "CheckerboardLayout.c"
	}
#line 1890 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp35_) {
#line 11109 "CheckerboardLayout.c"
		GdkRectangle _tmp40_;
		gint _tmp41_;
		GdkRectangle _tmp42_;
		gint _tmp43_;
		GdkRectangle _tmp44_;
		gint _tmp45_;
		GdkRectangle _tmp46_;
		gint _tmp47_;
#line 1895 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp40_ = dirty;
#line 1895 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp41_ = _tmp40_.x;
#line 1895 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp42_ = dirty;
#line 1895 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp43_ = _tmp42_.y;
#line 1895 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp44_ = dirty;
#line 1895 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp45_ = _tmp44_.width;
#line 1895 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp46_ = dirty;
#line 1895 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp47_ = _tmp46_.height;
#line 1895 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_queue_draw_area (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp41_, _tmp43_, _tmp45_, _tmp47_);
#line 11136 "CheckerboardLayout.c"
	}
}


static void checkerboard_layout_real_map (GtkWidget* base) {
	CheckerboardLayout * self;
#line 1899 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 1900 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->map (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget));
#line 1902 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_set_colors (self, TRUE);
#line 11149 "CheckerboardLayout.c"
}


static void checkerboard_layout_set_colors (CheckerboardLayout* self, gboolean in_focus) {
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	gboolean _tmp2_;
	GdkRGBA _tmp3_ = {0};
	ConfigFacade* _tmp4_;
	ConfigFacade* _tmp5_;
	GdkRGBA _tmp6_ = {0};
	ConfigFacade* _tmp7_;
	ConfigFacade* _tmp8_;
	GdkRGBA _tmp9_ = {0};
	GtkStyleContext* _tmp10_;
	GdkRGBA _tmp11_ = {0};
#line 1905 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = config_facade_get_instance ();
#line 1907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_;
#line 1907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = in_focus;
#line 1907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	config_facade_get_selected_color (_tmp1_, _tmp2_, &_tmp3_);
#line 1907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->selected_color = _tmp3_;
#line 1907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp1_);
#line 1908 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = config_facade_get_instance ();
#line 1908 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _tmp4_;
#line 1908 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	config_facade_get_unselected_color (_tmp5_, &_tmp6_);
#line 1908 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->unselected_color = _tmp6_;
#line 1908 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp5_);
#line 1909 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = config_facade_get_instance ();
#line 1909 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = _tmp7_;
#line 1909 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	config_facade_get_border_color (_tmp8_, &_tmp9_);
#line 1909 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->border_color = _tmp9_;
#line 1909 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp8_);
#line 1910 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 1910 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_style_context_get_background_color (_tmp10_, GTK_STATE_FLAG_NORMAL, &_tmp11_);
#line 1910 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->bg_color = _tmp11_;
#line 11206 "CheckerboardLayout.c"
}


static void checkerboard_layout_real_size_allocate (GtkWidget* base, GtkAllocation* allocation) {
	CheckerboardLayout * self;
	GtkAllocation _tmp0_;
#line 1913 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 1913 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (allocation != NULL);
#line 1914 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = *allocation;
#line 1914 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->size_allocate (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget), &_tmp0_);
#line 1916 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_viewport_resized (self);
#line 11223 "CheckerboardLayout.c"
}


static gboolean checkerboard_layout_real_draw (GtkWidget* base, cairo_t* ctx) {
	CheckerboardLayout * self;
	gboolean result = FALSE;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GtkStyleContext* _tmp1_;
	cairo_t* _tmp2_;
	GtkAllocation _tmp3_;
	gint _tmp4_;
	GtkAllocation _tmp5_;
	gint _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp60_ = FALSE;
	gboolean _result_ = FALSE;
	cairo_t* _tmp63_;
#line 1919 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 1919 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (ctx != NULL, FALSE);
#line 1928 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp0_);
#line 1928 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	allocation = _tmp0_;
#line 1929 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 1929 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = ctx;
#line 1929 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = allocation;
#line 1929 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_.width;
#line 1929 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = allocation;
#line 1929 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = _tmp5_.height;
#line 1929 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_render_background (_tmp1_, _tmp2_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp4_, (gdouble) _tmp6_);
#line 1932 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = self->priv->message;
#line 1932 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp7_ == NULL) {
#line 11268 "CheckerboardLayout.c"
		gboolean _tmp8_;
#line 1937 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = self->priv->exposure_dirty;
#line 1937 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp8_) {
#line 1938 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_layout_expose_items (self, "draw");
#line 11276 "CheckerboardLayout.c"
		}
		{
			GeeList* _item_list = NULL;
			GdkRectangle _tmp9_;
			GeeList* _tmp10_;
			gint _item_size = 0;
			GeeList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gint _item_index = 0;
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp9_ = self->priv->visible_page;
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = checkerboard_layout_intersection (self, &_tmp9_);
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_item_list = _tmp10_;
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = _item_list;
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp12_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp13_ = _tmp12_;
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_item_size = _tmp13_;
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_item_index = -1;
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			while (TRUE) {
#line 11305 "CheckerboardLayout.c"
				gint _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				CheckerboardItem* item = NULL;
				GeeList* _tmp17_;
				gint _tmp18_;
				gpointer _tmp19_;
				GdkRGBA _tmp20_ = {0};
				CheckerboardItem* _tmp21_;
				gboolean _tmp22_;
				CheckerboardItem* _tmp25_;
				cairo_t* _tmp26_;
				GdkRGBA _tmp27_;
				GdkRGBA _tmp28_;
				GdkRGBA _tmp29_;
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp14_ = _item_index;
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_item_index = _tmp14_ + 1;
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp15_ = _item_index;
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp16_ = _item_size;
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!(_tmp15_ < _tmp16_)) {
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 11333 "CheckerboardLayout.c"
				}
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp17_ = _item_list;
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp18_ = _item_index;
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = gee_list_get (_tmp17_, _tmp18_);
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				item = (CheckerboardItem*) _tmp19_;
#line 1942 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp21_ = item;
#line 1942 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp22_ = data_view_is_selected (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_DATA_VIEW, DataView));
#line 1942 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp22_) {
#line 11349 "CheckerboardLayout.c"
					GdkRGBA _tmp23_;
#line 1942 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp23_ = self->priv->selected_color;
#line 1942 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp20_ = _tmp23_;
#line 11355 "CheckerboardLayout.c"
				} else {
					GdkRGBA _tmp24_;
#line 1942 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp24_ = self->priv->unselected_color;
#line 1942 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp20_ = _tmp24_;
#line 11362 "CheckerboardLayout.c"
				}
#line 1942 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp25_ = item;
#line 1942 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp26_ = ctx;
#line 1942 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp27_ = self->priv->bg_color;
#line 1942 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp28_ = self->priv->unselected_color;
#line 1942 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp29_ = self->priv->border_color;
#line 1942 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_paint (_tmp25_, _tmp26_, &_tmp27_, &_tmp20_, &_tmp28_, &_tmp29_);
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 11378 "CheckerboardLayout.c"
			}
#line 1941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (_item_list);
#line 11382 "CheckerboardLayout.c"
		}
	} else {
		PangoLayout* pango_layout = NULL;
		const gchar* _tmp30_;
		PangoLayout* _tmp31_;
		gint text_width = 0;
		gint text_height = 0;
		PangoLayout* _tmp32_;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		GtkAllocation _tmp35_ = {0};
		gint x = 0;
		GtkAllocation _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp39_ = 0;
		gint _tmp40_;
		gint y = 0;
		GtkAllocation _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		gint _tmp45_ = 0;
		gint _tmp46_;
		cairo_t* _tmp48_;
		GdkRGBA _tmp49_;
		gdouble _tmp50_;
		GdkRGBA _tmp51_;
		gdouble _tmp52_;
		GdkRGBA _tmp53_;
		gdouble _tmp54_;
		cairo_t* _tmp55_;
		gint _tmp56_;
		gint _tmp57_;
		cairo_t* _tmp58_;
		PangoLayout* _tmp59_;
#line 1947 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp30_ = self->priv->message;
#line 1947 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp31_ = gtk_widget_create_pango_layout (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp30_);
#line 1947 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout = _tmp31_;
#line 1949 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp32_ = pango_layout;
#line 1949 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout_get_pixel_size (_tmp32_, &_tmp33_, &_tmp34_);
#line 1949 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		text_width = _tmp33_;
#line 1949 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		text_height = _tmp34_;
#line 1951 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp35_);
#line 1951 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		allocation = _tmp35_;
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp36_ = allocation;
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp37_ = _tmp36_.width;
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp38_ = text_width;
#line 1953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = _tmp37_ - _tmp38_;
#line 1954 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp40_ = x;
#line 1954 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp40_ > 0) {
#line 11448 "CheckerboardLayout.c"
			gint _tmp41_;
#line 1954 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp41_ = x;
#line 1954 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp39_ = _tmp41_ / 2;
#line 11454 "CheckerboardLayout.c"
		} else {
#line 1954 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp39_ = 0;
#line 11458 "CheckerboardLayout.c"
		}
#line 1954 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = _tmp39_;
#line 1956 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp42_ = allocation;
#line 1956 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp43_ = _tmp42_.height;
#line 1956 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp44_ = text_height;
#line 1956 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = _tmp43_ - _tmp44_;
#line 1957 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp46_ = y;
#line 1957 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp46_ > 0) {
#line 11474 "CheckerboardLayout.c"
			gint _tmp47_;
#line 1957 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp47_ = y;
#line 1957 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp45_ = _tmp47_ / 2;
#line 11480 "CheckerboardLayout.c"
		} else {
#line 1957 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp45_ = 0;
#line 11484 "CheckerboardLayout.c"
		}
#line 1957 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = _tmp45_;
#line 1959 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp48_ = ctx;
#line 1959 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp49_ = self->priv->unselected_color;
#line 1959 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp50_ = _tmp49_.red;
#line 1959 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp51_ = self->priv->unselected_color;
#line 1959 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp52_ = _tmp51_.green;
#line 1959 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp53_ = self->priv->unselected_color;
#line 1959 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp54_ = _tmp53_.blue;
#line 1959 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_set_source_rgb (_tmp48_, _tmp50_, _tmp52_, _tmp54_);
#line 1960 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp55_ = ctx;
#line 1960 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp56_ = x;
#line 1960 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp57_ = y;
#line 1960 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_move_to (_tmp55_, (gdouble) _tmp56_, (gdouble) _tmp57_);
#line 1961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp58_ = ctx;
#line 1961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp59_ = pango_layout;
#line 1961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_cairo_show_layout (_tmp58_, _tmp59_);
#line 1932 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (pango_layout);
#line 11520 "CheckerboardLayout.c"
	}
#line 1964 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->draw != NULL) {
#line 11524 "CheckerboardLayout.c"
		cairo_t* _tmp61_;
		gboolean _tmp62_;
#line 1964 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp61_ = ctx;
#line 1964 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp62_ = GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->draw (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget), _tmp61_);
#line 1964 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp60_ = _tmp62_;
#line 11533 "CheckerboardLayout.c"
	} else {
#line 1964 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp60_ = TRUE;
#line 11537 "CheckerboardLayout.c"
	}
#line 1964 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_result_ = _tmp60_;
#line 1967 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp63_ = ctx;
#line 1967 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_draw_selection_band (self, _tmp63_);
#line 1969 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _result_;
#line 1969 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 11549 "CheckerboardLayout.c"
}


static void checkerboard_layout_draw_selection_band (CheckerboardLayout* self, cairo_t* ctx) {
	gboolean _tmp0_ = FALSE;
	GdkRectangle _tmp1_;
	gint _tmp2_;
	gboolean _tmp5_ = FALSE;
	GtkAdjustment* _tmp6_;
	GdkRectangle visible_page = {0};
	GtkAdjustment* _tmp8_;
	GtkAdjustment* _tmp9_;
	GdkRectangle _tmp10_ = {0};
	GdkRectangle visible_band = {0};
	GdkRectangle _tmp11_;
	GdkRectangle _tmp12_ = {0};
	gboolean _tmp13_ = FALSE;
	GdkRectangle _tmp14_;
	gint _tmp15_;
	cairo_t* _tmp35_;
	cairo_t* _tmp36_;
	cairo_t* _tmp37_;
	GdkRGBA _tmp38_;
	gdouble _tmp39_;
	GdkRGBA _tmp40_;
	gdouble _tmp41_;
	GdkRGBA _tmp42_;
	gdouble _tmp43_;
	cairo_t* _tmp44_;
	GdkRectangle _tmp45_;
	gint _tmp46_;
	GdkRectangle _tmp47_;
	gint _tmp48_;
	GdkRectangle _tmp49_;
	gint _tmp50_;
	GdkRectangle _tmp51_;
	gint _tmp52_;
	cairo_t* _tmp53_;
#line 1972 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1972 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 1974 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->selection_band;
#line 1974 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_.width;
#line 1974 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ <= 1) {
#line 1974 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = TRUE;
#line 11600 "CheckerboardLayout.c"
	} else {
		GdkRectangle _tmp3_;
		gint _tmp4_;
#line 1974 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->selection_band;
#line 1974 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = _tmp3_.height;
#line 1974 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_ <= 1;
#line 11610 "CheckerboardLayout.c"
	}
#line 1974 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 1975 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 11616 "CheckerboardLayout.c"
	}
#line 1978 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = self->priv->hadjustment;
#line 1978 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp6_ == NULL) {
#line 1978 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = TRUE;
#line 11624 "CheckerboardLayout.c"
	} else {
		GtkAdjustment* _tmp7_;
#line 1978 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = self->priv->vadjustment;
#line 1978 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = _tmp7_ == NULL;
#line 11631 "CheckerboardLayout.c"
	}
#line 1978 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp5_) {
#line 1979 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 11637 "CheckerboardLayout.c"
	}
#line 1982 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = self->priv->hadjustment;
#line 1982 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->vadjustment;
#line 1982 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	get_adjustment_page (_tmp8_, _tmp9_, &_tmp10_);
#line 1982 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	visible_page = _tmp10_;
#line 1983 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&visible_band, 0, sizeof (GdkRectangle));
#line 1984 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = self->priv->selection_band;
#line 1984 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gdk_rectangle_intersect (&visible_page, &_tmp11_, &_tmp12_);
#line 1984 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	visible_band = _tmp12_;
#line 1987 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = visible_band;
#line 1987 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = _tmp14_.width;
#line 1987 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp15_ > 1) {
#line 11661 "CheckerboardLayout.c"
		GdkRectangle _tmp16_;
		gint _tmp17_;
#line 1987 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp16_ = visible_band;
#line 1987 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = _tmp16_.height;
#line 1987 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = _tmp17_ > 1;
#line 11670 "CheckerboardLayout.c"
	} else {
#line 1987 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = FALSE;
#line 11674 "CheckerboardLayout.c"
	}
#line 1987 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp13_) {
#line 11678 "CheckerboardLayout.c"
		cairo_t* _tmp18_;
		GdkRGBA _tmp19_;
		gdouble _tmp20_;
		GdkRGBA _tmp21_;
		gdouble _tmp22_;
		GdkRGBA _tmp23_;
		gdouble _tmp24_;
		cairo_t* _tmp25_;
		GdkRectangle _tmp26_;
		gint _tmp27_;
		GdkRectangle _tmp28_;
		gint _tmp29_;
		GdkRectangle _tmp30_;
		gint _tmp31_;
		GdkRectangle _tmp32_;
		gint _tmp33_;
		cairo_t* _tmp34_;
#line 1988 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = ctx;
#line 1988 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = self->priv->selected_color;
#line 1988 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = _tmp19_.red;
#line 1988 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = self->priv->selected_color;
#line 1988 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = _tmp21_.green;
#line 1988 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp23_ = self->priv->selected_color;
#line 1988 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp24_ = _tmp23_.blue;
#line 1988 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_set_source_rgba (_tmp18_, _tmp20_, _tmp22_, _tmp24_, CHECKERBOARD_LAYOUT_SELECTION_ALPHA);
#line 1990 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp25_ = ctx;
#line 1990 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp26_ = visible_band;
#line 1990 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp27_ = _tmp26_.x;
#line 1990 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp28_ = visible_band;
#line 1990 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp29_ = _tmp28_.y;
#line 1990 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp30_ = visible_band;
#line 1990 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp31_ = _tmp30_.width;
#line 1990 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp32_ = visible_band;
#line 1990 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp33_ = _tmp32_.height;
#line 1990 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (_tmp25_, (gdouble) _tmp27_, (gdouble) _tmp29_, (gdouble) _tmp31_, (gdouble) _tmp33_);
#line 1992 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp34_ = ctx;
#line 1992 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (_tmp34_);
#line 11736 "CheckerboardLayout.c"
	}
#line 1998 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp35_ = ctx;
#line 1998 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_line_width (_tmp35_, 1.0);
#line 1999 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp36_ = ctx;
#line 1999 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_line_cap (_tmp36_, CAIRO_LINE_CAP_SQUARE);
#line 2000 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp37_ = ctx;
#line 2000 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp38_ = self->priv->selected_color;
#line 2000 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp39_ = _tmp38_.red;
#line 2000 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp40_ = self->priv->selected_color;
#line 2000 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp41_ = _tmp40_.green;
#line 2000 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp42_ = self->priv->selected_color;
#line 2000 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp43_ = _tmp42_.blue;
#line 2000 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source_rgb (_tmp37_, _tmp39_, _tmp41_, _tmp43_);
#line 2001 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp44_ = ctx;
#line 2001 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp45_ = self->priv->selection_band;
#line 2001 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp46_ = _tmp45_.x;
#line 2001 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp47_ = self->priv->selection_band;
#line 2001 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp48_ = _tmp47_.y;
#line 2001 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp49_ = self->priv->selection_band;
#line 2001 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp50_ = _tmp49_.width;
#line 2001 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp51_ = self->priv->selection_band;
#line 2001 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp52_ = _tmp51_.height;
#line 2001 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_rectangle (_tmp44_, ((gdouble) _tmp46_) + 0.5, ((gdouble) _tmp48_) + 0.5, ((gdouble) _tmp50_) - 1.0, ((gdouble) _tmp52_) - 1.0);
#line 2003 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp53_ = ctx;
#line 2003 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_stroke (_tmp53_);
#line 11786 "CheckerboardLayout.c"
}


static gboolean checkerboard_layout_real_query_tooltip (GtkWidget* base, gint x, gint y, gboolean keyboard_mode, GtkTooltip* tooltip) {
	CheckerboardLayout * self;
	gboolean result = FALSE;
	CheckerboardItem* item = NULL;
	gint _tmp0_;
	gint _tmp1_;
	CheckerboardItem* _tmp2_;
	gboolean _tmp3_ = FALSE;
	CheckerboardItem* _tmp4_;
#line 2006 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 2006 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (GTK_IS_TOOLTIP (tooltip), FALSE);
#line 2007 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = x;
#line 2007 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = y;
#line 2007 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = checkerboard_layout_get_item_at_pixel (self, (gdouble) _tmp0_, (gdouble) _tmp1_);
#line 2007 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	item = _tmp2_;
#line 2009 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = item;
#line 2009 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_ != NULL) {
#line 11815 "CheckerboardLayout.c"
		CheckerboardItem* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		GtkTooltip* _tmp8_;
		gboolean _tmp9_;
#line 2009 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = item;
#line 2009 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = x;
#line 2009 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = y;
#line 2009 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = tooltip;
#line 2009 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = checkerboard_item_query_tooltip (_tmp5_, _tmp6_, _tmp7_, _tmp8_);
#line 2009 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = _tmp9_;
#line 11833 "CheckerboardLayout.c"
	} else {
#line 2009 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = FALSE;
#line 11837 "CheckerboardLayout.c"
	}
#line 2009 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp3_;
#line 2009 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (item);
#line 2009 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 11845 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_colors_changed (CheckerboardLayout* self) {
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	GdkRGBA _tmp2_ = {0};
#line 2012 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 2013 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	invalidate_transparent_background ();
#line 2014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = config_facade_get_instance ();
#line 2014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_;
#line 2014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	config_facade_get_bg_color (_tmp1_, &_tmp2_);
#line 2014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_override_background_color (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), GTK_STATE_FLAG_NORMAL, &_tmp2_);
#line 2014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp1_);
#line 2015 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_set_colors (self, TRUE);
#line 11869 "CheckerboardLayout.c"
}


static gboolean checkerboard_layout_real_focus_in_event (GtkWidget* base, GdkEventFocus* event) {
	CheckerboardLayout * self;
	gboolean result = FALSE;
	ViewCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GdkEventFocus* _tmp3_;
	gboolean _tmp4_;
#line 2018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 2018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 2019 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_set_colors (self, TRUE);
#line 2020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->view;
#line 2020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = view_collection_get_selected (_tmp0_);
#line 2020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_;
#line 2020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_items_dirty (self, "focus_in_event", G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 2020 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp2_);
#line 2022 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = event;
#line 2022 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->focus_in_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget), _tmp3_);
#line 2022 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp4_;
#line 2022 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 11905 "CheckerboardLayout.c"
}


static gboolean checkerboard_layout_real_focus_out_event (GtkWidget* base, GdkEventFocus* event) {
	CheckerboardLayout * self;
	gboolean result = FALSE;
	ViewCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GdkEventFocus* _tmp3_;
	gboolean _tmp4_;
#line 2025 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 2025 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 2026 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_set_colors (self, FALSE);
#line 2027 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->view;
#line 2027 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = view_collection_get_selected (_tmp0_);
#line 2027 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_;
#line 2027 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_items_dirty (self, "focus_out_event", G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 2027 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp2_);
#line 2029 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = event;
#line 2029 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->focus_out_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget), _tmp3_);
#line 2029 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp4_;
#line 2029 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 11941 "CheckerboardLayout.c"
}


static CheckerboardLayoutLayoutRow* checkerboard_layout_layout_row_construct (GType object_type, gint y, gint height, gint num_in_row) {
	CheckerboardLayoutLayoutRow* self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	CheckerboardItem** _tmp3_;
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = (CheckerboardLayoutLayoutRow*) g_type_create_instance (object_type);
#line 839 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = y;
#line 839 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->y = _tmp0_;
#line 840 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = height;
#line 840 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->height = _tmp1_;
#line 841 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = num_in_row;
#line 841 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = g_new0 (CheckerboardItem*, _tmp2_ + 1);
#line 841 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->items = (_vala_array_free (self->items, self->items_length1, (GDestroyNotify) g_object_unref), NULL);
#line 841 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->items = _tmp3_;
#line 841 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->items_length1 = _tmp2_;
#line 841 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->_items_size_ = self->items_length1;
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self;
#line 11975 "CheckerboardLayout.c"
}


static CheckerboardLayoutLayoutRow* checkerboard_layout_layout_row_new (gint y, gint height, gint num_in_row) {
#line 838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return checkerboard_layout_layout_row_construct (CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, y, height, num_in_row);
#line 11982 "CheckerboardLayout.c"
}


static void checkerboard_layout_value_layout_row_init (GValue* value) {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	value->data[0].v_pointer = NULL;
#line 11989 "CheckerboardLayout.c"
}


static void checkerboard_layout_value_layout_row_free_value (GValue* value) {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (value->data[0].v_pointer) {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_layout_row_unref (value->data[0].v_pointer);
#line 11998 "CheckerboardLayout.c"
	}
}


static void checkerboard_layout_value_layout_row_copy_value (const GValue* src_value, GValue* dest_value) {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (src_value->data[0].v_pointer) {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dest_value->data[0].v_pointer = checkerboard_layout_layout_row_ref (src_value->data[0].v_pointer);
#line 12008 "CheckerboardLayout.c"
	} else {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dest_value->data[0].v_pointer = NULL;
#line 12012 "CheckerboardLayout.c"
	}
}


static gpointer checkerboard_layout_value_layout_row_peek_pointer (const GValue* value) {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return value->data[0].v_pointer;
#line 12020 "CheckerboardLayout.c"
}


static gchar* checkerboard_layout_value_layout_row_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (collect_values[0].v_pointer) {
#line 12027 "CheckerboardLayout.c"
		CheckerboardLayoutLayoutRow * object;
		object = collect_values[0].v_pointer;
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (object->parent_instance.g_class == NULL) {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 12034 "CheckerboardLayout.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 12038 "CheckerboardLayout.c"
		}
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = checkerboard_layout_layout_row_ref (object);
#line 12042 "CheckerboardLayout.c"
	} else {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 12046 "CheckerboardLayout.c"
	}
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return NULL;
#line 12050 "CheckerboardLayout.c"
}


static gchar* checkerboard_layout_value_layout_row_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	CheckerboardLayoutLayoutRow ** object_p;
	object_p = collect_values[0].v_pointer;
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!object_p) {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 12061 "CheckerboardLayout.c"
	}
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!value->data[0].v_pointer) {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = NULL;
#line 12067 "CheckerboardLayout.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = value->data[0].v_pointer;
#line 12071 "CheckerboardLayout.c"
	} else {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = checkerboard_layout_layout_row_ref (value->data[0].v_pointer);
#line 12075 "CheckerboardLayout.c"
	}
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return NULL;
#line 12079 "CheckerboardLayout.c"
}


static GParamSpec* checkerboard_layout_param_spec_layout_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	CheckerboardLayoutParamSpecLayoutRow* spec;
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (g_type_is_a (object_type, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW), NULL);
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return G_PARAM_SPEC (spec);
#line 12093 "CheckerboardLayout.c"
}


static gpointer checkerboard_layout_value_get_layout_row (const GValue* value) {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW), NULL);
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return value->data[0].v_pointer;
#line 12102 "CheckerboardLayout.c"
}


static void checkerboard_layout_value_set_layout_row (GValue* value, gpointer v_object) {
	CheckerboardLayoutLayoutRow * old;
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old = value->data[0].v_pointer;
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (v_object) {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = v_object;
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_layout_row_ref (value->data[0].v_pointer);
#line 12122 "CheckerboardLayout.c"
	} else {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 12126 "CheckerboardLayout.c"
	}
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (old) {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_layout_row_unref (old);
#line 12132 "CheckerboardLayout.c"
	}
}


static void checkerboard_layout_value_take_layout_row (GValue* value, gpointer v_object) {
	CheckerboardLayoutLayoutRow * old;
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old = value->data[0].v_pointer;
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (v_object) {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = v_object;
#line 12151 "CheckerboardLayout.c"
	} else {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 12155 "CheckerboardLayout.c"
	}
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (old) {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_layout_row_unref (old);
#line 12161 "CheckerboardLayout.c"
	}
}


static void checkerboard_layout_layout_row_class_init (CheckerboardLayoutLayoutRowClass * klass) {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_layout_row_parent_class = g_type_class_peek_parent (klass);
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardLayoutLayoutRowClass *) klass)->finalize = checkerboard_layout_layout_row_finalize;
#line 12171 "CheckerboardLayout.c"
}


static void checkerboard_layout_layout_row_instance_init (CheckerboardLayoutLayoutRow * self) {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->ref_count = 1;
#line 12178 "CheckerboardLayout.c"
}


static void checkerboard_layout_layout_row_finalize (CheckerboardLayoutLayoutRow * obj) {
	CheckerboardLayoutLayoutRow * self;
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRow);
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_destroy (self);
#line 836 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->items = (_vala_array_free (self->items, self->items_length1, (GDestroyNotify) g_object_unref), NULL);
#line 12190 "CheckerboardLayout.c"
}


static GType checkerboard_layout_layout_row_get_type (void) {
	static volatile gsize checkerboard_layout_layout_row_type_id__volatile = 0;
	if (g_once_init_enter (&checkerboard_layout_layout_row_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { checkerboard_layout_value_layout_row_init, checkerboard_layout_value_layout_row_free_value, checkerboard_layout_value_layout_row_copy_value, checkerboard_layout_value_layout_row_peek_pointer, "p", checkerboard_layout_value_layout_row_collect_value, "p", checkerboard_layout_value_layout_row_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (CheckerboardLayoutLayoutRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) checkerboard_layout_layout_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckerboardLayoutLayoutRow), 0, (GInstanceInitFunc) checkerboard_layout_layout_row_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType checkerboard_layout_layout_row_type_id;
		checkerboard_layout_layout_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CheckerboardLayoutLayoutRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&checkerboard_layout_layout_row_type_id__volatile, checkerboard_layout_layout_row_type_id);
	}
	return checkerboard_layout_layout_row_type_id__volatile;
}


static gpointer checkerboard_layout_layout_row_ref (gpointer instance) {
	CheckerboardLayoutLayoutRow * self;
	self = instance;
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_atomic_int_inc (&self->ref_count);
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return instance;
#line 12215 "CheckerboardLayout.c"
}


static void checkerboard_layout_layout_row_unref (gpointer instance) {
	CheckerboardLayoutLayoutRow * self;
	self = instance;
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		CHECKERBOARD_LAYOUT_LAYOUT_ROW_GET_CLASS (self)->finalize (self);
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 12228 "CheckerboardLayout.c"
	}
}


static void checkerboard_layout_class_init (CheckerboardLayoutClass * klass) {
#line 816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_parent_class = g_type_class_peek_parent (klass);
#line 816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_type_class_add_private (klass, sizeof (CheckerboardLayoutPrivate));
#line 816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->map = (void (*) (GtkWidget *)) checkerboard_layout_real_map;
#line 816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget *, GtkAllocation*)) checkerboard_layout_real_size_allocate;
#line 816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) checkerboard_layout_real_draw;
#line 816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->query_tooltip = (gboolean (*) (GtkWidget *, gint, gint, gboolean, GtkTooltip*)) checkerboard_layout_real_query_tooltip;
#line 816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->focus_in_event = (gboolean (*) (GtkWidget *, GdkEventFocus*)) checkerboard_layout_real_focus_in_event;
#line 816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->focus_out_event = (gboolean (*) (GtkWidget *, GdkEventFocus*)) checkerboard_layout_real_focus_out_event;
#line 816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_OBJECT_CLASS (klass)->finalize = checkerboard_layout_finalize;
#line 12252 "CheckerboardLayout.c"
}


static void checkerboard_layout_instance_init (CheckerboardLayout * self) {
	gchar* _tmp0_;
	GeeHashSet* _tmp1_;
#line 816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv = CHECKERBOARD_LAYOUT_GET_PRIVATE (self);
#line 846 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = g_strdup ("");
#line 846 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->page_name = _tmp0_;
#line 847 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = NULL;
#line 847 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows_length1 = 0;
#line 847 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
#line 848 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = gee_hash_set_new (TYPE_CHECKERBOARD_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 848 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposed_items = _tmp1_;
#line 849 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->hadjustment = NULL;
#line 850 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->vadjustment = NULL;
#line 851 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->message = NULL;
#line 856 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->priv->visible_page, 0, sizeof (GdkRectangle));
#line 857 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->last_width = 0;
#line 858 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->columns = 0;
#line 859 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->rows = 0;
#line 860 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->priv->drag_origin, 0, sizeof (GdkPoint));
#line 861 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->priv->drag_endpoint, 0, sizeof (GdkPoint));
#line 862 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->priv->selection_band, 0, sizeof (GdkRectangle));
#line 863 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->scale = 0;
#line 864 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->flow_scheduled = FALSE;
#line 865 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure_dirty = TRUE;
#line 866 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->anchor = NULL;
#line 867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->cursor = NULL;
#line 868 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->in_center_on_anchor = FALSE;
#line 869 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->size_allocate_due_to_reflow = FALSE;
#line 870 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->is_in_view = FALSE;
#line 871 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->reflow_needed = FALSE;
#line 12313 "CheckerboardLayout.c"
}


static void checkerboard_layout_finalize (GObject * obj) {
	CheckerboardLayout * self;
	ViewCollection* _tmp0_;
	guint _tmp1_;
	ViewCollection* _tmp2_;
	guint _tmp3_;
	ViewCollection* _tmp4_;
	guint _tmp5_;
	ViewCollection* _tmp6_;
	guint _tmp7_;
	ViewCollection* _tmp8_;
	guint _tmp9_;
	ViewCollection* _tmp10_;
	guint _tmp11_;
	ViewCollection* _tmp12_;
	guint _tmp13_;
	ViewCollection* _tmp14_;
	guint _tmp15_;
	ViewCollection* _tmp16_;
	guint _tmp17_;
	GtkAdjustment* _tmp18_;
	GtkAdjustment* _tmp21_;
	GtkContainer* _tmp24_;
	GtkContainer* _tmp25_;
	ConfigFacade* _tmp29_;
	ConfigFacade* _tmp30_;
	guint _tmp31_;
#line 816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 902 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->view;
#line 902 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("contents-altered", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
#line 902 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _checkerboard_layout_on_contents_altered_data_collection_contents_altered, self);
#line 903 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->view;
#line 903 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp3_, NULL, FALSE);
#line 903 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _checkerboard_layout_on_items_altered_data_collection_items_altered, self);
#line 904 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = self->priv->view;
#line 904 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("items-state-changed", TYPE_VIEW_COLLECTION, &_tmp5_, NULL, FALSE);
#line 904 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _checkerboard_layout_on_items_state_changed_view_collection_items_state_changed, self);
#line 905 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = self->priv->view;
#line 905 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("items-visibility-changed", TYPE_VIEW_COLLECTION, &_tmp7_, NULL, FALSE);
#line 905 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed, self);
#line 906 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = self->priv->view;
#line 906 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("ordering-changed", TYPE_DATA_COLLECTION, &_tmp9_, NULL, FALSE);
#line 906 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _checkerboard_layout_on_ordering_changed_data_collection_ordering_changed, self);
#line 907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = self->priv->view;
#line 907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("views-altered", TYPE_VIEW_COLLECTION, &_tmp11_, NULL, FALSE);
#line 907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _checkerboard_layout_on_views_altered_view_collection_views_altered, self);
#line 908 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = self->priv->view;
#line 908 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("geometries-altered", TYPE_VIEW_COLLECTION, &_tmp13_, NULL, FALSE);
#line 908 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _checkerboard_layout_on_geometries_altered_view_collection_geometries_altered, self);
#line 909 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = self->priv->view;
#line 909 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("items-selected", TYPE_VIEW_COLLECTION, &_tmp15_, NULL, FALSE);
#line 909 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, 0, NULL, (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_selected, self);
#line 910 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = self->priv->view;
#line 910 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("items-unselected", TYPE_VIEW_COLLECTION, &_tmp17_, NULL, FALSE);
#line 910 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp16_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, 0, NULL, (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_unselected, self);
#line 912 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp18_ = self->priv->hadjustment;
#line 912 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp18_ != NULL) {
#line 12404 "CheckerboardLayout.c"
		GtkAdjustment* _tmp19_;
		guint _tmp20_;
#line 913 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = self->priv->hadjustment;
#line 913 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_parse_name ("value-changed", gtk_adjustment_get_type (), &_tmp20_, NULL, FALSE);
#line 913 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_handlers_disconnect_matched (_tmp19_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp20_, 0, NULL, (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self);
#line 12413 "CheckerboardLayout.c"
	}
#line 915 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = self->priv->vadjustment;
#line 915 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp21_ != NULL) {
#line 12419 "CheckerboardLayout.c"
		GtkAdjustment* _tmp22_;
		guint _tmp23_;
#line 916 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = self->priv->vadjustment;
#line 916 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_parse_name ("value-changed", gtk_adjustment_get_type (), &_tmp23_, NULL, FALSE);
#line 916 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_handlers_disconnect_matched (_tmp22_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp23_, 0, NULL, (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self);
#line 12428 "CheckerboardLayout.c"
	}
#line 918 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp24_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 918 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp25_ = _tmp24_;
#line 918 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp25_ != NULL) {
#line 12436 "CheckerboardLayout.c"
		GtkContainer* _tmp26_;
		GtkContainer* _tmp27_;
		guint _tmp28_;
#line 919 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp26_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 919 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp27_ = _tmp26_;
#line 919 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_parse_name ("size-allocate", gtk_widget_get_type (), &_tmp28_, NULL, FALSE);
#line 919 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp28_, 0, NULL, (GCallback) _checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate, self);
#line 12448 "CheckerboardLayout.c"
	}
#line 921 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp29_ = config_facade_get_instance ();
#line 921 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp30_ = _tmp29_;
#line 921 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("colors-changed", CONFIG_TYPE_FACADE, &_tmp31_, NULL, FALSE);
#line 921 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp30_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp31_, 0, NULL, (GCallback) _checkerboard_layout_on_colors_changed_config_facade_colors_changed, self);
#line 921 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp30_);
#line 845 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_data_collection_unref0 (self->priv->view);
#line 846 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->page_name);
#line 847 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
#line 848 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->exposed_items);
#line 849 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->hadjustment);
#line 850 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->vadjustment);
#line 851 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->message);
#line 866 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->anchor);
#line 867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->cursor);
#line 816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_OBJECT_CLASS (checkerboard_layout_parent_class)->finalize (obj);
#line 12480 "CheckerboardLayout.c"
}


GType checkerboard_layout_get_type (void) {
	static volatile gsize checkerboard_layout_type_id__volatile = 0;
	if (g_once_init_enter (&checkerboard_layout_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheckerboardLayoutClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) checkerboard_layout_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckerboardLayout), 0, (GInstanceInitFunc) checkerboard_layout_instance_init, NULL };
		GType checkerboard_layout_type_id;
		checkerboard_layout_type_id = g_type_register_static (gtk_drawing_area_get_type (), "CheckerboardLayout", &g_define_type_info, 0);
		g_once_init_leave (&checkerboard_layout_type_id__volatile, checkerboard_layout_type_id);
	}
	return checkerboard_layout_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



