/* LibraryFiles.c generated by valac 0.36.6, the Vala compiler
 * generated from LibraryFiles.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <stdio.h>
#include <glib/gstdio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_METADATA_DATE_TIME (metadata_date_time_get_type ())
#define METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTime))
#define METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))
#define IS_METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_DATE_TIME))
#define IS_METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_DATE_TIME))
#define METADATA_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))

typedef struct _MetadataDateTime MetadataDateTime;
typedef struct _MetadataDateTimeClass MetadataDateTimeClass;
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;

#define TYPE_VIDEO_READER (video_reader_get_type ())
#define VIDEO_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_READER, VideoReader))
#define VIDEO_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_READER, VideoReaderClass))
#define IS_VIDEO_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_READER))
#define IS_VIDEO_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_READER))
#define VIDEO_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_READER, VideoReaderClass))

typedef struct _VideoReader VideoReader;
typedef struct _VideoReaderClass VideoReaderClass;

#define TYPE_VIDEO_METADATA (video_metadata_get_type ())
#define VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_METADATA, VideoMetadata))
#define VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_METADATA, VideoMetadataClass))
#define IS_VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_METADATA))
#define IS_VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_METADATA))
#define VIDEO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_METADATA, VideoMetadataClass))

typedef struct _VideoMetadata VideoMetadata;
typedef struct _VideoMetadataClass VideoMetadataClass;
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _video_reader_unref0(var) ((var == NULL) ? NULL : (var = (video_reader_unref (var), NULL)))

#define TYPE_PHOTO_FILE_ADAPTER (photo_file_adapter_get_type ())
#define PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter))
#define PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))
#define IS_PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_ADAPTER))
#define IS_PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_ADAPTER))
#define PHOTO_FILE_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))

typedef struct _PhotoFileAdapter PhotoFileAdapter;
typedef struct _PhotoFileAdapterClass PhotoFileAdapterClass;

#define TYPE_PHOTO_FILE_READER (photo_file_reader_get_type ())
#define PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReader))
#define PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))
#define IS_PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_READER))
#define IS_PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_READER))
#define PHOTO_FILE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))

typedef struct _PhotoFileReader PhotoFileReader;
typedef struct _PhotoFileReaderClass PhotoFileReaderClass;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;
#define _photo_file_adapter_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_adapter_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;


extern gboolean library_files_use_fallback_copy_func;
gboolean library_files_use_fallback_copy_func = FALSE;

void library_files_select_copy_function (void);
GFile* app_dirs_get_import_dir (void);
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_metadata (GValue* value, gpointer v_object);
void value_take_media_metadata (GValue* value, gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GFile* library_files_generate_unique_file (const gchar* basename, MediaMetadata* metadata, time_t ts, gboolean* collision, GError** error);
gpointer metadata_date_time_ref (gpointer instance);
void metadata_date_time_unref (gpointer instance);
GParamSpec* param_spec_metadata_date_time (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_metadata_date_time (GValue* value, gpointer v_object);
void value_take_metadata_date_time (GValue* value, gpointer v_object);
gpointer value_get_metadata_date_time (const GValue* value);
GType metadata_date_time_get_type (void) G_GNUC_CONST;
MetadataDateTime* media_metadata_get_creation_date_time (MediaMetadata* self);
time_t metadata_date_time_get_timestamp (MetadataDateTime* self);
GFile* app_dirs_get_baked_import_dir (time_t tm);
gchar* library_files_convert_basename (const gchar* basename);
GFile* generate_unique_file (GFile* dir, const gchar* basename, gboolean* collision, GError** error);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
gboolean configuration_facade_get_use_lowercase_filenames (ConfigurationFacade* self);
GFile* library_files_duplicate (GFile* src, GFileProgressCallback progress_callback, void* progress_callback_target, gboolean blacklist, GError** error);
time_t query_file_modified (GFile* file, GError** error);
gboolean video_reader_is_supported_video_file (GFile* file);
gpointer video_reader_ref (gpointer instance);
void video_reader_unref (gpointer instance);
GParamSpec* param_spec_video_reader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_video_reader (GValue* value, gpointer v_object);
void value_take_video_reader (GValue* value, gpointer v_object);
gpointer value_get_video_reader (const GValue* value);
GType video_reader_get_type (void) G_GNUC_CONST;
VideoReader* video_reader_new (GFile* file);
VideoReader* video_reader_construct (GType object_type, GFile* file);
GType video_metadata_get_type (void) G_GNUC_CONST;
VideoMetadata* video_reader_read_metadata (VideoReader* self, GError** error);
gpointer photo_file_adapter_ref (gpointer instance);
void photo_file_adapter_unref (gpointer instance);
GParamSpec* param_spec_photo_file_adapter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_adapter (GValue* value, gpointer v_object);
void value_take_photo_file_adapter (GValue* value, gpointer v_object);
gpointer value_get_photo_file_adapter (const GValue* value);
GType photo_file_adapter_get_type (void) G_GNUC_CONST;
GType photo_file_reader_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
PhotoFileFormat photo_file_format_get_by_file_extension (GFile* file);
PhotoFileReader* photo_file_format_create_reader (PhotoFileFormat self, const gchar* filepath);
GType photo_metadata_get_type (void) G_GNUC_CONST;
PhotoMetadata* photo_file_reader_read_metadata (PhotoFileReader* self, GError** error);
void library_monitor_blacklist_file (GFile* file, const gchar* reason);
void library_files_fallback_copy (GFile* src, GFile* dst, GFileProgressCallback callback, void* callback_target, GError** error);
void library_monitor_unblacklist_file (GFile* file);
gchar* md5_file (GFile* file, GError** error);


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
#line 37 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (self) {
#line 197 "LibraryFiles.c"
		gchar* _tmp0_;
#line 38 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = g_strdup ("true");
#line 38 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = _tmp0_;
#line 38 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 205 "LibraryFiles.c"
	} else {
		gchar* _tmp1_;
#line 40 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp1_ = g_strdup ("false");
#line 40 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = _tmp1_;
#line 40 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 214 "LibraryFiles.c"
	}
}


void library_files_select_copy_function (void) {
	GFile* import_dir = NULL;
	GFile* _tmp0_;
	gboolean _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError * _inner_error_ = NULL;
#line 12 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp0_ = app_dirs_get_import_dir ();
#line 12 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	import_dir = _tmp0_;
#line 230 "LibraryFiles.c"
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
#line 15 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp1_ = g_file_query_filesystem_info (import_dir, "filesystem::type", NULL, &_inner_error_);
#line 15 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		info = _tmp1_;
#line 15 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 242 "LibraryFiles.c"
			goto __catch470_g_error;
		}
#line 16 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp2_ = g_file_info_get_attribute_as_string (info, "filesystem::type");
#line 16 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp3_ = _tmp2_;
#line 16 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		library_files_use_fallback_copy_func = g_strcmp0 (_tmp3_, "nfs") == 0;
#line 16 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (_tmp3_);
#line 14 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_object_unref0 (info);
#line 255 "LibraryFiles.c"
	}
	goto __finally470;
	__catch470_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 14 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_error_ = _inner_error_;
#line 14 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_inner_error_ = NULL;
#line 18 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp4_ = _error_;
#line 18 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp5_ = _tmp4_->message;
#line 18 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_critical ("LibraryFiles.vala:18: Failed to query fs type: %s", _tmp5_);
#line 19 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		library_files_use_fallback_copy_func = TRUE;
#line 14 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_error_free0 (_error_);
#line 277 "LibraryFiles.c"
	}
	__finally470:
#line 14 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 14 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_object_unref0 (import_dir);
#line 14 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 14 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_clear_error (&_inner_error_);
#line 14 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return;
#line 290 "LibraryFiles.c"
	}
#line 22 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp6_ = library_files_use_fallback_copy_func;
#line 22 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp7_ = bool_to_string (_tmp6_);
#line 22 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp8_ = _tmp7_;
#line 22 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	g_info ("LibraryFiles.vala:22: Using fallback copy: %s", _tmp8_);
#line 22 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_g_free0 (_tmp8_);
#line 11 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_g_object_unref0 (import_dir);
#line 304 "LibraryFiles.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 49 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	return self ? g_error_copy (self) : NULL;
#line 311 "LibraryFiles.c"
}


GFile* library_files_generate_unique_file (const gchar* basename, MediaMetadata* metadata, time_t ts, gboolean* collision, GError** error) {
	gboolean _vala_collision = FALSE;
	GFile* result = NULL;
	time_t timestamp = 0;
	time_t _tmp0_;
	MediaMetadata* _tmp1_;
	GFile* dir = NULL;
	time_t _tmp9_;
	GFile* _tmp10_;
	gchar* newbasename = NULL;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	GFile* _tmp17_ = NULL;
	GFile* _tmp18_;
	gboolean _tmp19_ = FALSE;
	GFile* _tmp20_;
	GFile* _tmp21_;
	GError * _inner_error_ = NULL;
#line 29 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	g_return_val_if_fail (basename != NULL, NULL);
#line 29 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	g_return_val_if_fail ((metadata == NULL) || IS_MEDIA_METADATA (metadata), NULL);
#line 34 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp0_ = ts;
#line 34 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	timestamp = _tmp0_;
#line 35 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp1_ = metadata;
#line 35 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (_tmp1_ != NULL) {
#line 345 "LibraryFiles.c"
		MetadataDateTime* date_time = NULL;
		MediaMetadata* _tmp2_;
		MetadataDateTime* _tmp3_;
		MetadataDateTime* _tmp4_;
#line 36 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp2_ = metadata;
#line 36 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp3_ = media_metadata_get_creation_date_time (_tmp2_);
#line 36 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		date_time = _tmp3_;
#line 37 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp4_ = date_time;
#line 37 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (_tmp4_ != NULL) {
#line 360 "LibraryFiles.c"
			MetadataDateTime* _tmp5_;
			time_t _tmp6_;
#line 38 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp5_ = date_time;
#line 38 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp6_ = metadata_date_time_get_timestamp (_tmp5_);
#line 38 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			timestamp = _tmp6_;
#line 369 "LibraryFiles.c"
		} else {
			time_t _tmp7_;
#line 39 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp7_ = timestamp;
#line 39 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			if (_tmp7_ == ((time_t) 0)) {
#line 376 "LibraryFiles.c"
				time_t _tmp8_;
#line 40 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				_tmp8_ = time (NULL);
#line 40 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				timestamp = _tmp8_;
#line 382 "LibraryFiles.c"
			}
		}
#line 35 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_metadata_date_time_unref0 (date_time);
#line 387 "LibraryFiles.c"
	}
#line 44 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp9_ = timestamp;
#line 44 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp10_ = app_dirs_get_baked_import_dir (_tmp9_);
#line 44 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	dir = _tmp10_;
#line 395 "LibraryFiles.c"
	{
		GFile* _tmp11_;
#line 46 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp11_ = dir;
#line 46 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_file_make_directory_with_parents (_tmp11_, NULL, &_inner_error_);
#line 46 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 404 "LibraryFiles.c"
			goto __catch471_g_error;
		}
	}
	goto __finally471;
	__catch471_g_error:
	{
		GError* err = NULL;
		GError* _tmp12_;
#line 45 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		err = _inner_error_;
#line 45 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_inner_error_ = NULL;
#line 48 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp12_ = err;
#line 48 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (!g_error_matches (_tmp12_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
#line 421 "LibraryFiles.c"
			GError* _tmp13_;
			GError* _tmp14_;
#line 49 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp13_ = err;
#line 49 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp14_ = _g_error_copy0 (_tmp13_);
#line 49 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_inner_error_ = _tmp14_;
#line 49 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_error_free0 (err);
#line 432 "LibraryFiles.c"
			goto __finally471;
		}
#line 45 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_error_free0 (err);
#line 437 "LibraryFiles.c"
	}
	__finally471:
#line 45 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 45 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_propagate_error (error, _inner_error_);
#line 45 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_object_unref0 (dir);
#line 45 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return NULL;
#line 448 "LibraryFiles.c"
	}
#line 55 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp15_ = basename;
#line 55 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp16_ = library_files_convert_basename (_tmp15_);
#line 55 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	newbasename = _tmp16_;
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp18_ = dir;
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp20_ = generate_unique_file (_tmp18_, newbasename, &_tmp19_, &_inner_error_);
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_vala_collision = _tmp19_;
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp17_ = _tmp20_;
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_propagate_error (error, _inner_error_);
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (newbasename);
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_object_unref0 (dir);
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return NULL;
#line 474 "LibraryFiles.c"
	}
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp21_ = _tmp17_;
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp17_ = NULL;
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	result = _tmp21_;
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_g_object_unref0 (_tmp17_);
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_g_free0 (newbasename);
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_g_object_unref0 (dir);
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (collision) {
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		*collision = _vala_collision;
#line 492 "LibraryFiles.c"
	}
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	return result;
#line 496 "LibraryFiles.c"
}


gchar* library_files_convert_basename (const gchar* basename) {
	gchar* result = NULL;
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
#line 62 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	g_return_val_if_fail (basename != NULL, NULL);
#line 63 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp0_ = config_facade_get_instance ();
#line 63 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp1_ = _tmp0_;
#line 63 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp2_ = configuration_facade_get_use_lowercase_filenames (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 63 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp3_ = _tmp2_;
#line 63 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_g_object_unref0 (_tmp1_);
#line 63 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (_tmp3_) {
#line 520 "LibraryFiles.c"
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 64 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp4_ = basename;
#line 64 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
#line 64 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		result = _tmp5_;
#line 64 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return result;
#line 531 "LibraryFiles.c"
	} else {
		const gchar* _tmp6_;
		gchar* _tmp7_;
#line 66 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp6_ = basename;
#line 66 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 66 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		result = _tmp7_;
#line 66 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return result;
#line 543 "LibraryFiles.c"
	}
}


GFile* library_files_duplicate (GFile* src, GFileProgressCallback progress_callback, void* progress_callback_target, gboolean blacklist, GError** error) {
	GFile* result = NULL;
	time_t timestamp = 0;
	MediaMetadata* metadata = NULL;
	GFile* _tmp8_;
	gboolean _tmp9_;
	gboolean collision = FALSE;
	GFile* dest = NULL;
	GFile* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	MediaMetadata* _tmp30_;
	time_t _tmp31_;
	gboolean _tmp32_ = FALSE;
	GFile* _tmp33_;
	GFile* _tmp34_;
	GFile* _tmp35_;
	gboolean _tmp37_;
	GError * _inner_error_ = NULL;
#line 73 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	g_return_val_if_fail (G_IS_FILE (src), NULL);
#line 74 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	timestamp = (time_t) 0;
#line 571 "LibraryFiles.c"
	{
		time_t _tmp0_ = 0;
		GFile* _tmp1_;
		time_t _tmp2_;
#line 76 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp1_ = src;
#line 76 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp2_ = query_file_modified (_tmp1_, &_inner_error_);
#line 76 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp0_ = _tmp2_;
#line 76 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 584 "LibraryFiles.c"
			goto __catch472_g_error;
		}
#line 76 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		timestamp = _tmp0_;
#line 589 "LibraryFiles.c"
	}
	goto __finally472;
	__catch472_g_error:
	{
		GError* err = NULL;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 75 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		err = _inner_error_;
#line 75 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_inner_error_ = NULL;
#line 78 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp3_ = src;
#line 78 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp4_ = g_file_get_path (_tmp3_);
#line 78 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp5_ = _tmp4_;
#line 78 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp6_ = err;
#line 78 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp7_ = _tmp6_->message;
#line 78 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_critical ("LibraryFiles.vala:78: Unable to access file modification for %s: %s", _tmp5_, _tmp7_);
#line 78 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (_tmp5_);
#line 75 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_error_free0 (err);
#line 620 "LibraryFiles.c"
	}
	__finally472:
#line 75 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 75 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_propagate_error (error, _inner_error_);
#line 75 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return NULL;
#line 629 "LibraryFiles.c"
	}
#line 81 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	metadata = NULL;
#line 82 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp8_ = src;
#line 82 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp9_ = video_reader_is_supported_video_file (_tmp8_);
#line 82 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (_tmp9_) {
#line 639 "LibraryFiles.c"
		VideoReader* reader = NULL;
		GFile* _tmp10_;
		VideoReader* _tmp11_;
#line 83 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp10_ = src;
#line 83 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp11_ = video_reader_new (_tmp10_);
#line 83 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		reader = _tmp11_;
#line 649 "LibraryFiles.c"
		{
			VideoMetadata* _tmp12_ = NULL;
			VideoReader* _tmp13_;
			VideoMetadata* _tmp14_;
			VideoMetadata* _tmp15_;
#line 85 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp13_ = reader;
#line 85 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp14_ = video_reader_read_metadata (_tmp13_, &_inner_error_);
#line 85 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp12_ = _tmp14_;
#line 85 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 663 "LibraryFiles.c"
				goto __catch473_g_error;
			}
#line 85 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp15_ = _tmp12_;
#line 85 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp12_ = NULL;
#line 85 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_media_metadata_unref0 (metadata);
#line 85 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			metadata = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_MEDIA_METADATA, MediaMetadata);
#line 84 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_media_metadata_unref0 (_tmp12_);
#line 676 "LibraryFiles.c"
		}
		goto __finally473;
		__catch473_g_error:
		{
			GError* err = NULL;
#line 84 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			err = _inner_error_;
#line 84 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_inner_error_ = NULL;
#line 84 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_error_free0 (err);
#line 688 "LibraryFiles.c"
		}
		__finally473:
#line 84 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 84 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			g_propagate_error (error, _inner_error_);
#line 84 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_video_reader_unref0 (reader);
#line 84 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_media_metadata_unref0 (metadata);
#line 84 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			return NULL;
#line 701 "LibraryFiles.c"
		}
#line 82 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_video_reader_unref0 (reader);
#line 705 "LibraryFiles.c"
	} else {
		PhotoFileReader* reader = NULL;
		GFile* _tmp16_;
		PhotoFileFormat _tmp17_;
		GFile* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		PhotoFileReader* _tmp21_;
		PhotoFileReader* _tmp22_;
#line 90 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp16_ = src;
#line 90 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp17_ = photo_file_format_get_by_file_extension (_tmp16_);
#line 90 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp18_ = src;
#line 90 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp19_ = g_file_get_path (_tmp18_);
#line 90 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp20_ = _tmp19_;
#line 90 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp21_ = photo_file_format_create_reader (_tmp17_, _tmp20_);
#line 90 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp22_ = _tmp21_;
#line 90 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (_tmp20_);
#line 90 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		reader = _tmp22_;
#line 733 "LibraryFiles.c"
		{
			PhotoMetadata* _tmp23_ = NULL;
			PhotoFileReader* _tmp24_;
			PhotoMetadata* _tmp25_;
			PhotoMetadata* _tmp26_;
#line 93 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp24_ = reader;
#line 93 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp25_ = photo_file_reader_read_metadata (_tmp24_, &_inner_error_);
#line 93 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp23_ = _tmp25_;
#line 93 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 747 "LibraryFiles.c"
				goto __catch474_g_error;
			}
#line 93 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp26_ = _tmp23_;
#line 93 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp23_ = NULL;
#line 93 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_media_metadata_unref0 (metadata);
#line 93 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			metadata = G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, TYPE_MEDIA_METADATA, MediaMetadata);
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_media_metadata_unref0 (_tmp23_);
#line 760 "LibraryFiles.c"
		}
		goto __finally474;
		__catch474_g_error:
		{
			GError* err = NULL;
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			err = _inner_error_;
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_inner_error_ = NULL;
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_error_free0 (err);
#line 772 "LibraryFiles.c"
		}
		__finally474:
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			g_propagate_error (error, _inner_error_);
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_photo_file_adapter_unref0 (reader);
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_media_metadata_unref0 (metadata);
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			return NULL;
#line 785 "LibraryFiles.c"
		}
#line 82 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_photo_file_adapter_unref0 (reader);
#line 789 "LibraryFiles.c"
	}
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp27_ = src;
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp28_ = g_file_get_basename (_tmp27_);
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp29_ = _tmp28_;
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp30_ = metadata;
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp31_ = timestamp;
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp33_ = library_files_generate_unique_file (_tmp29_, _tmp30_, _tmp31_, &_tmp32_, &_inner_error_);
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	collision = _tmp32_;
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp34_ = _tmp33_;
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_g_free0 (_tmp29_);
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	dest = _tmp34_;
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_propagate_error (error, _inner_error_);
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_media_metadata_unref0 (metadata);
#line 100 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return NULL;
#line 819 "LibraryFiles.c"
	}
#line 101 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp35_ = dest;
#line 101 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (_tmp35_ == NULL) {
#line 825 "LibraryFiles.c"
		GError* _tmp36_;
#line 102 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp36_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_FAILED, "Unable to generate unique pathname for destination");
#line 102 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_inner_error_ = _tmp36_;
#line 102 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_propagate_error (error, _inner_error_);
#line 102 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_object_unref0 (dest);
#line 102 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_media_metadata_unref0 (metadata);
#line 102 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return NULL;
#line 839 "LibraryFiles.c"
	}
#line 104 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp37_ = blacklist;
#line 104 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (_tmp37_) {
#line 845 "LibraryFiles.c"
		GFile* _tmp38_;
#line 105 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp38_ = dest;
#line 105 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		library_monitor_blacklist_file (_tmp38_, "LibraryFiles.duplicate");
#line 851 "LibraryFiles.c"
	}
	{
		gboolean _tmp39_;
		gboolean _tmp46_;
#line 108 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp39_ = library_files_use_fallback_copy_func;
#line 108 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (_tmp39_) {
#line 860 "LibraryFiles.c"
			GFile* _tmp40_;
			GFile* _tmp41_;
			GFileProgressCallback _tmp42_;
			void* _tmp42__target;
#line 109 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp40_ = src;
#line 109 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp41_ = dest;
#line 109 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp42_ = progress_callback;
#line 109 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp42__target = progress_callback_target;
#line 109 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			library_files_fallback_copy (_tmp40_, _tmp41_, _tmp42_, _tmp42__target, &_inner_error_);
#line 109 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 877 "LibraryFiles.c"
				goto __catch475_g_error;
			}
		} else {
			GFile* _tmp43_;
			GFile* _tmp44_;
			GFileProgressCallback _tmp45_;
			void* _tmp45__target;
#line 111 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp43_ = src;
#line 111 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp44_ = dest;
#line 111 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp45_ = progress_callback;
#line 111 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp45__target = progress_callback_target;
#line 111 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			g_file_copy (_tmp43_, _tmp44_, G_FILE_COPY_ALL_METADATA | G_FILE_COPY_OVERWRITE, NULL, _tmp45_, _tmp45__target, &_inner_error_);
#line 111 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 897 "LibraryFiles.c"
				goto __catch475_g_error;
			}
		}
#line 113 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp46_ = blacklist;
#line 113 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (_tmp46_) {
#line 905 "LibraryFiles.c"
			GFile* _tmp47_;
#line 114 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp47_ = dest;
#line 114 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			library_monitor_unblacklist_file (_tmp47_);
#line 911 "LibraryFiles.c"
		}
	}
	goto __finally475;
	__catch475_g_error:
	{
		GError* err = NULL;
		GFile* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		GError* _tmp51_;
		const gchar* _tmp52_;
		gboolean _tmp53_ = FALSE;
		gboolean _tmp54_;
#line 107 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		err = _inner_error_;
#line 107 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_inner_error_ = NULL;
#line 116 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp48_ = src;
#line 116 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp49_ = g_file_get_path (_tmp48_);
#line 116 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp50_ = _tmp49_;
#line 116 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp51_ = err;
#line 116 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp52_ = _tmp51_->message;
#line 116 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_message ("LibraryFiles.vala:116: There was a problem copying %s: %s", _tmp50_, _tmp52_);
#line 116 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (_tmp50_);
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp54_ = blacklist;
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (_tmp54_) {
#line 947 "LibraryFiles.c"
			gchar* _tmp55_ = NULL;
			GFile* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_ = NULL;
			GFile* _tmp59_;
			gchar* _tmp60_;
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp56_ = src;
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp57_ = md5_file (_tmp56_, &_inner_error_);
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp55_ = _tmp57_;
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				_g_error_free0 (err);
#line 964 "LibraryFiles.c"
				goto __finally475;
			}
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp59_ = dest;
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp60_ = md5_file (_tmp59_, &_inner_error_);
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp58_ = _tmp60_;
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				_g_free0 (_tmp55_);
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				_g_error_free0 (err);
#line 979 "LibraryFiles.c"
				goto __finally475;
			}
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp53_ = g_strcmp0 (_tmp55_, _tmp58_) != 0;
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_free0 (_tmp58_);
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_free0 (_tmp55_);
#line 988 "LibraryFiles.c"
		} else {
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp53_ = FALSE;
#line 992 "LibraryFiles.c"
		}
#line 117 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (_tmp53_) {
#line 996 "LibraryFiles.c"
			GFile* _tmp61_;
#line 118 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp61_ = dest;
#line 118 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			library_monitor_unblacklist_file (_tmp61_);
#line 1002 "LibraryFiles.c"
		}
#line 107 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_error_free0 (err);
#line 1006 "LibraryFiles.c"
	}
	__finally475:
#line 107 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 107 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_propagate_error (error, _inner_error_);
#line 107 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_object_unref0 (dest);
#line 107 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_media_metadata_unref0 (metadata);
#line 107 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return NULL;
#line 1019 "LibraryFiles.c"
	}
	{
		GFileInfo* info = NULL;
		GFile* _tmp62_;
		GFileInfo* _tmp63_;
		guint32 mode = 0U;
		GFileInfo* _tmp64_;
		guint32 _tmp65_;
		gboolean _tmp66_ = FALSE;
		GFile* _tmp67_;
		guint32 _tmp68_;
		gboolean _tmp69_;
#line 123 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp62_ = dest;
#line 123 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp63_ = g_file_query_info (_tmp62_, G_FILE_ATTRIBUTE_UNIX_MODE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 123 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		info = _tmp63_;
#line 123 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1040 "LibraryFiles.c"
			goto __catch476_g_error;
		}
#line 124 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp64_ = info;
#line 124 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp65_ = g_file_info_get_attribute_uint32 (_tmp64_, G_FILE_ATTRIBUTE_UNIX_MODE);
#line 124 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		mode = _tmp65_ | 0600;
#line 125 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp67_ = dest;
#line 125 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp68_ = mode;
#line 125 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp69_ = g_file_set_attribute_uint32 (_tmp67_, G_FILE_ATTRIBUTE_UNIX_MODE, _tmp68_, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 125 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp66_ = _tmp69_;
#line 125 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 125 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_object_unref0 (info);
#line 1061 "LibraryFiles.c"
			goto __catch476_g_error;
		}
#line 125 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (!_tmp66_) {
#line 126 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			g_warning ("LibraryFiles.vala:126: Could not make file writable");
#line 1068 "LibraryFiles.c"
		}
#line 122 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_object_unref0 (info);
#line 1072 "LibraryFiles.c"
	}
	goto __finally476;
	__catch476_g_error:
	{
		GError* err = NULL;
		GError* _tmp70_;
		const gchar* _tmp71_;
#line 122 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		err = _inner_error_;
#line 122 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_inner_error_ = NULL;
#line 129 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp70_ = err;
#line 129 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp71_ = _tmp70_->message;
#line 129 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_warning ("LibraryFiles.vala:129: Could not make file writable: %s", _tmp71_);
#line 122 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_error_free0 (err);
#line 1092 "LibraryFiles.c"
	}
	__finally476:
#line 122 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 122 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_propagate_error (error, _inner_error_);
#line 122 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_object_unref0 (dest);
#line 122 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_media_metadata_unref0 (metadata);
#line 122 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return NULL;
#line 1105 "LibraryFiles.c"
	}
#line 132 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	result = dest;
#line 132 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_media_metadata_unref0 (metadata);
#line 132 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	return result;
#line 1113 "LibraryFiles.c"
}


void library_files_fallback_copy (GFile* src, GFile* dst, GFileProgressCallback callback, void* callback_target, GError** error) {
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	FILE* f = NULL;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	FILE* _tmp6_;
	FILE* _tmp7_;
	FILE* _tmp8_;
	GError * _inner_error_ = NULL;
#line 135 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	g_return_if_fail ((src == NULL) || G_IS_FILE (src));
#line 135 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	g_return_if_fail ((dst == NULL) || G_IS_FILE (dst));
#line 136 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp1_ = src;
#line 136 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (_tmp1_ == NULL) {
#line 136 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp0_ = TRUE;
#line 1138 "LibraryFiles.c"
	} else {
		GFile* _tmp2_;
#line 136 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp2_ = dst;
#line 136 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 1145 "LibraryFiles.c"
	}
#line 136 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (_tmp0_) {
#line 137 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return;
#line 1151 "LibraryFiles.c"
	}
#line 140 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp3_ = src;
#line 140 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp4_ = g_file_get_path (_tmp3_);
#line 140 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp5_ = _tmp4_;
#line 140 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp6_ = g_fopen (_tmp5_, "rb");
#line 140 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp7_ = _tmp6_;
#line 140 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_g_free0 (_tmp5_);
#line 140 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	f = _tmp7_;
#line 141 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp8_ = f;
#line 141 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (_tmp8_ != NULL) {
#line 1171 "LibraryFiles.c"
		FILE* _tmp9_;
		glong size = 0L;
		FILE* _tmp10_;
		glong _tmp11_;
		FILE* _tmp12_;
		GFile* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GFile* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		glong _tmp19_;
		FILE* g = NULL;
		GFile* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		FILE* _tmp23_;
		FILE* _tmp24_;
		FILE* _tmp25_;
#line 142 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp9_ = f;
#line 142 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		fseek (_tmp9_, (glong) 0, SEEK_END);
#line 143 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp10_ = f;
#line 143 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp11_ = ftell (_tmp10_);
#line 143 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		size = _tmp11_;
#line 144 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp12_ = f;
#line 144 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		fseek (_tmp12_, (glong) 0, SEEK_SET);
#line 145 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp13_ = src;
#line 145 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp14_ = g_file_get_path (_tmp13_);
#line 145 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp15_ = _tmp14_;
#line 145 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp16_ = dst;
#line 145 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp17_ = g_file_get_path (_tmp16_);
#line 145 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp18_ = _tmp17_;
#line 145 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp19_ = size;
#line 145 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_debug ("LibraryFiles.vala:145: Copying %s to %s, size is %ld", _tmp15_, _tmp18_, _tmp19_);
#line 145 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (_tmp18_);
#line 145 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (_tmp15_);
#line 147 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp20_ = dst;
#line 147 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp21_ = g_file_get_path (_tmp20_);
#line 147 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp22_ = _tmp21_;
#line 147 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp23_ = g_fopen (_tmp22_, "wb");
#line 147 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp24_ = _tmp23_;
#line 147 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (_tmp22_);
#line 147 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g = _tmp24_;
#line 148 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp25_ = g;
#line 148 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (_tmp25_ != NULL) {
#line 1243 "LibraryFiles.c"
			guint8 buffer[4096] = {0};
			gsize written = 0UL;
#line 150 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			written = (gsize) 0;
#line 152 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			while (TRUE) {
#line 1250 "LibraryFiles.c"
				FILE* _tmp26_;
				gboolean _tmp27_;
				gsize len = 0UL;
				FILE* _tmp28_;
				gsize _tmp29_;
				gsize _tmp30_;
#line 152 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				_tmp26_ = f;
#line 152 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				_tmp27_ = feof (_tmp26_);
#line 152 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				if (!(!_tmp27_)) {
#line 152 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					break;
#line 1265 "LibraryFiles.c"
				}
#line 153 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				_tmp28_ = f;
#line 153 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				_tmp29_ = fread (buffer, (gsize) 1, 4096, _tmp28_);
#line 153 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				len = _tmp29_;
#line 154 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				_tmp30_ = len;
#line 154 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				if (_tmp30_ > ((gsize) 0)) {
#line 1277 "LibraryFiles.c"
					gsize out_len = 0UL;
					FILE* _tmp31_;
					gsize _tmp32_;
					gsize _tmp33_;
					gsize _tmp34_;
					gsize _tmp43_;
					gsize _tmp44_;
					GFileProgressCallback _tmp45_;
					void* _tmp45__target;
#line 155 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					_tmp31_ = g;
#line 155 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					_tmp32_ = len;
#line 155 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					_tmp33_ = fwrite (buffer + 0, (gsize) 1, ((gint) _tmp32_) - 0, _tmp31_);
#line 155 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					out_len = _tmp33_;
#line 156 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					_tmp34_ = out_len;
#line 156 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					if (_tmp34_ < ((gsize) 0)) {
#line 1299 "LibraryFiles.c"
						GFile* _tmp35_;
						gchar* _tmp36_;
						gchar* _tmp37_;
						GFile* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						GError* _tmp41_;
						GError* _tmp42_;
#line 157 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp35_ = dst;
#line 157 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp36_ = g_file_get_path (_tmp35_);
#line 157 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp37_ = _tmp36_;
#line 157 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						g_critical ("LibraryFiles.vala:157: Failed to write to file %s: %m", _tmp37_);
#line 157 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_g_free0 (_tmp37_);
#line 158 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp38_ = dst;
#line 158 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp39_ = g_file_get_path (_tmp38_);
#line 158 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp40_ = _tmp39_;
#line 158 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp41_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to write to %s", _tmp40_);
#line 158 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp42_ = _tmp41_;
#line 158 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_g_free0 (_tmp40_);
#line 158 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_inner_error_ = _tmp42_;
#line 158 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						g_propagate_error (error, _inner_error_);
#line 158 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_fclose0 (g);
#line 158 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_fclose0 (f);
#line 158 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						return;
#line 1340 "LibraryFiles.c"
					}
#line 160 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					_tmp43_ = written;
#line 160 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					_tmp44_ = len;
#line 160 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					written = _tmp43_ + _tmp44_;
#line 162 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					_tmp45_ = callback;
#line 162 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					_tmp45__target = callback_target;
#line 162 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					if (_tmp45_ != NULL) {
#line 1354 "LibraryFiles.c"
						GFileProgressCallback _tmp46_;
						void* _tmp46__target;
						gsize _tmp47_;
						glong _tmp48_;
#line 163 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp46_ = callback;
#line 163 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp46__target = callback_target;
#line 163 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp47_ = written;
#line 163 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp48_ = size;
#line 163 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp46_ ((gint64) _tmp47_, (gint64) _tmp48_, _tmp46__target);
#line 1369 "LibraryFiles.c"
					}
				} else {
					gsize _tmp49_;
#line 164 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					_tmp49_ = len;
#line 164 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
					if (_tmp49_ < ((gsize) 0)) {
#line 1377 "LibraryFiles.c"
						GFile* _tmp50_;
						gchar* _tmp51_;
						gchar* _tmp52_;
						GFile* _tmp53_;
						gchar* _tmp54_;
						gchar* _tmp55_;
						GError* _tmp56_;
						GError* _tmp57_;
#line 165 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp50_ = src;
#line 165 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp51_ = g_file_get_path (_tmp50_);
#line 165 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp52_ = _tmp51_;
#line 165 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						g_critical ("LibraryFiles.vala:165: Failed to read from file %s: %m", _tmp52_);
#line 165 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_g_free0 (_tmp52_);
#line 166 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp53_ = src;
#line 166 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp54_ = g_file_get_path (_tmp53_);
#line 166 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp55_ = _tmp54_;
#line 166 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp56_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to read from %s", _tmp55_);
#line 166 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_tmp57_ = _tmp56_;
#line 166 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_g_free0 (_tmp55_);
#line 166 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_inner_error_ = _tmp57_;
#line 166 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						g_propagate_error (error, _inner_error_);
#line 166 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_fclose0 (g);
#line 166 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						_fclose0 (f);
#line 166 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
						return;
#line 1418 "LibraryFiles.c"
					}
				}
			}
		} else {
			GFile* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			GFile* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			GError* _tmp64_;
			GError* _tmp65_;
#line 170 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp58_ = dst;
#line 170 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp59_ = g_file_get_path (_tmp58_);
#line 170 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp60_ = _tmp59_;
#line 170 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			g_critical ("LibraryFiles.vala:170: Failed to open %s: %m", _tmp60_);
#line 170 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_free0 (_tmp60_);
#line 171 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp61_ = dst;
#line 171 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp62_ = g_file_get_path (_tmp61_);
#line 171 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp63_ = _tmp62_;
#line 171 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp64_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to open %s", _tmp63_);
#line 171 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp65_ = _tmp64_;
#line 171 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_free0 (_tmp63_);
#line 171 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_inner_error_ = _tmp65_;
#line 171 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			g_propagate_error (error, _inner_error_);
#line 171 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_fclose0 (g);
#line 171 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_fclose0 (f);
#line 171 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			return;
#line 1463 "LibraryFiles.c"
		}
#line 141 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_fclose0 (g);
#line 1467 "LibraryFiles.c"
	} else {
		GFile* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		GFile* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		GError* _tmp72_;
		GError* _tmp73_;
#line 174 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp66_ = src;
#line 174 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp67_ = g_file_get_path (_tmp66_);
#line 174 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp68_ = _tmp67_;
#line 174 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_critical ("LibraryFiles.vala:174: Failed to open %s: %m", _tmp68_);
#line 174 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (_tmp68_);
#line 175 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp69_ = src;
#line 175 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp70_ = g_file_get_path (_tmp69_);
#line 175 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp71_ = _tmp70_;
#line 175 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp72_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to open %s", _tmp71_);
#line 175 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp73_ = _tmp72_;
#line 175 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (_tmp71_);
#line 175 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_inner_error_ = _tmp73_;
#line 175 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_propagate_error (error, _inner_error_);
#line 175 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_fclose0 (f);
#line 175 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return;
#line 1507 "LibraryFiles.c"
	}
#line 135 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_fclose0 (f);
#line 1511 "LibraryFiles.c"
}



