/* ConfigurationInterfaces.c generated by valac 0.36.6, the Vala compiler
 * generated from ConfigurationInterfaces.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <time.h>


#define TYPE_FUZZY_PROPERTY_STATE (fuzzy_property_state_get_type ())

#define TYPE_CONFIGURABLE_PROPERTY (configurable_property_get_type ())

#define TYPE_CONFIGURATION_ENGINE (configuration_engine_get_type ())
#define CONFIGURATION_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_ENGINE, ConfigurationEngine))
#define IS_CONFIGURATION_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_ENGINE))
#define CONFIGURATION_ENGINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_CONFIGURATION_ENGINE, ConfigurationEngineIface))

typedef struct _ConfigurationEngine ConfigurationEngine;
typedef struct _ConfigurationEngineIface ConfigurationEngineIface;
enum  {
	CONFIGURATION_ENGINE_PROPERTY_CHANGED_SIGNAL,
	CONFIGURATION_ENGINE_LAST_SIGNAL
};
static guint configuration_engine_signals[CONFIGURATION_ENGINE_LAST_SIGNAL] = {0};

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;
typedef struct _ConfigurationFacadePrivate ConfigurationFacadePrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_EXPORT_FORMAT_MODE (export_format_mode_get_type ())

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RESOURCES_TYPE_UNIT_SYSTEM (resources_unit_system_get_type ())
enum  {
	CONFIGURATION_FACADE_AUTO_IMPORT_FROM_LIBRARY_CHANGED_SIGNAL,
	CONFIGURATION_FACADE_BG_COLOR_NAME_CHANGED_SIGNAL,
	CONFIGURATION_FACADE_TRANSPARENT_BACKGROUND_TYPE_CHANGED_SIGNAL,
	CONFIGURATION_FACADE_TRANSPARENT_BACKGROUND_COLOR_CHANGED_SIGNAL,
	CONFIGURATION_FACADE_COMMIT_METADATA_TO_MASTERS_CHANGED_SIGNAL,
	CONFIGURATION_FACADE_EVENTS_SORT_ASCENDING_CHANGED_SIGNAL,
	CONFIGURATION_FACADE_EXTERNAL_APP_CHANGED_SIGNAL,
	CONFIGURATION_FACADE_IMPORT_DIRECTORY_CHANGED_SIGNAL,
	CONFIGURATION_FACADE_LAST_SIGNAL
};
static guint configuration_facade_signals[CONFIGURATION_FACADE_LAST_SIGNAL] = {0};

typedef enum  {
	CONFIGURATION_ERROR_PROPERTY_HAS_NO_VALUE,
	CONFIGURATION_ERROR_ENGINE_ERROR
} ConfigurationError;
#define CONFIGURATION_ERROR configuration_error_quark ()
typedef enum  {
	FUZZY_PROPERTY_STATE_ENABLED,
	FUZZY_PROPERTY_STATE_DISABLED,
	FUZZY_PROPERTY_STATE_UNKNOWN
} FuzzyPropertyState;

typedef enum  {
	CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY = 0,
	CONFIGURABLE_PROPERTY_BG_COLOR_NAME,
	CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_TYPE,
	CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_COLOR,
	CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS,
	CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE,
	CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE,
	CONFIGURABLE_PROPERTY_SCREENSAVER_FILE,
	CONFIGURABLE_PROPERTY_SCREENSAVER_MODE,
	CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN,
	CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM,
	CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT,
	CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE,
	CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH,
	CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES,
	CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS,
	CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES,
	CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR,
	CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR,
	CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS,
	CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING,
	CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY,
	CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING,
	CONFIGURABLE_PROPERTY_EXPORT_CONSTRAINT,
	CONFIGURABLE_PROPERTY_EXPORT_EXPORT_FORMAT_MODE,
	CONFIGURABLE_PROPERTY_EXPORT_EXPORT_METADATA,
	CONFIGURABLE_PROPERTY_EXPORT_PHOTO_FILE_FORMAT,
	CONFIGURABLE_PROPERTY_EXPORT_QUALITY,
	CONFIGURABLE_PROPERTY_EXPORT_SCALE,
	CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP,
	CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP,
	CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED,
	CONFIGURABLE_PROPERTY_IMPORT_DIR,
	CONFIGURABLE_PROPERTY_KEEP_RELATIVITY,
	CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT,
	CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE,
	CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH,
	CONFIGURABLE_PROPERTY_LAST_USED_SERVICE,
	CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE,
	CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING,
	CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY,
	CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT,
	CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE,
	CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH,
	CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS,
	CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE,
	CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH,
	CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE,
	CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO,
	CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES,
	CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION,
	CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT,
	CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT,
	CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG,
	CONFIGURABLE_PROPERTY_SIDEBAR_POSITION,
	CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY,
	CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY,
	CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID,
	CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE,
	CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME,
	CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES,
	CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE,
	CONFIGURABLE_PROPERTY_NUM_PROPERTIES
} ConfigurableProperty;

struct _ConfigurationEngineIface {
	GTypeInterface parent_iface;
	gchar* (*get_name) (ConfigurationEngine* self);
	gint (*get_int_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_int_property) (ConfigurationEngine* self, ConfigurableProperty p, gint val, GError** error);
	gint (*get_enum_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_enum_property) (ConfigurationEngine* self, ConfigurableProperty p, gint val, GError** error);
	gchar* (*get_string_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_string_property) (ConfigurationEngine* self, ConfigurableProperty p, const gchar* val, GError** error);
	gboolean (*get_bool_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_bool_property) (ConfigurationEngine* self, ConfigurableProperty p, gboolean val, GError** error);
	gdouble (*get_double_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_double_property) (ConfigurationEngine* self, ConfigurableProperty p, gdouble val, GError** error);
	gboolean (*get_plugin_bool) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
	void (*set_plugin_bool) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
	gdouble (*get_plugin_double) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
	void (*set_plugin_double) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
	gint (*get_plugin_int) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
	void (*set_plugin_int) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
	gchar* (*get_plugin_string) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
	void (*set_plugin_string) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
	void (*unset_plugin_key) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key);
	FuzzyPropertyState (*is_plugin_enabled) (ConfigurationEngine* self, const gchar* id);
	void (*set_plugin_enabled) (ConfigurationEngine* self, const gchar* id, gboolean enabled);
};

struct _Dimensions {
	gint width;
	gint height;
};

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

typedef enum  {
	EXPORT_FORMAT_MODE_UNMODIFIED,
	EXPORT_FORMAT_MODE_CURRENT,
	EXPORT_FORMAT_MODE_SPECIFIED,
	EXPORT_FORMAT_MODE_LAST
} ExportFormatMode;

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

struct _ConfigurationFacade {
	GObject parent_instance;
	ConfigurationFacadePrivate * priv;
};

struct _ConfigurationFacadeClass {
	GObjectClass parent_class;
	gboolean (*get_auto_import_from_library) (ConfigurationFacade* self);
	void (*set_auto_import_from_library) (ConfigurationFacade* self, gboolean auto_import);
	gchar* (*get_bg_color_name) (ConfigurationFacade* self);
	void (*set_bg_color_name) (ConfigurationFacade* self, const gchar* color_name);
	gchar* (*get_transparent_background_type) (ConfigurationFacade* self);
	void (*set_transparent_background_type) (ConfigurationFacade* self, const gchar* type);
	gchar* (*get_transparent_background_color) (ConfigurationFacade* self);
	void (*set_transparent_background_color) (ConfigurationFacade* self, const gchar* color_name);
	gboolean (*get_commit_metadata_to_masters) (ConfigurationFacade* self);
	void (*set_commit_metadata_to_masters) (ConfigurationFacade* self, gboolean commit_metadata);
	gchar* (*get_desktop_background) (ConfigurationFacade* self);
	void (*set_desktop_background) (ConfigurationFacade* self, const gchar* filename);
	gchar* (*get_screensaver) (ConfigurationFacade* self);
	void (*set_screensaver) (ConfigurationFacade* self, const gchar* filename);
	gchar* (*get_directory_pattern) (ConfigurationFacade* self);
	void (*set_directory_pattern) (ConfigurationFacade* self, const gchar* s);
	gchar* (*get_directory_pattern_custom) (ConfigurationFacade* self);
	void (*set_directory_pattern_custom) (ConfigurationFacade* self, const gchar* s);
	void (*get_direct_window_state) (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
	void (*set_direct_window_state) (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
	gboolean (*get_display_basic_properties) (ConfigurationFacade* self);
	void (*set_display_basic_properties) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_extended_properties) (ConfigurationFacade* self);
	void (*set_display_extended_properties) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_sidebar) (ConfigurationFacade* self);
	void (*set_display_sidebar) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_toolbar) (ConfigurationFacade* self);
	void (*set_display_toolbar) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_search_bar) (ConfigurationFacade* self);
	void (*set_display_search_bar) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_ratings) (ConfigurationFacade* self);
	void (*set_display_photo_ratings) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_tags) (ConfigurationFacade* self);
	void (*set_display_photo_tags) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_titles) (ConfigurationFacade* self);
	void (*set_display_photo_titles) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_comments) (ConfigurationFacade* self);
	void (*set_display_photo_comments) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_event_comments) (ConfigurationFacade* self);
	void (*set_display_event_comments) (ConfigurationFacade* self, gboolean display);
	void (*get_event_photos_sort) (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
	void (*set_event_photos_sort) (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
	gboolean (*get_events_sort_ascending) (ConfigurationFacade* self);
	void (*set_events_sort_ascending) (ConfigurationFacade* self, gboolean sort);
	gchar* (*get_external_photo_app) (ConfigurationFacade* self);
	void (*set_external_photo_app) (ConfigurationFacade* self, const gchar* external_photo_app);
	gchar* (*get_external_raw_app) (ConfigurationFacade* self);
	void (*set_external_raw_app) (ConfigurationFacade* self, const gchar* external_raw_app);
	ScaleConstraint (*get_export_constraint) (ConfigurationFacade* self);
	void (*set_export_constraint) (ConfigurationFacade* self, ScaleConstraint constraint);
	ExportFormatMode (*get_export_export_format_mode) (ConfigurationFacade* self);
	void (*set_export_export_format_mode) (ConfigurationFacade* self, ExportFormatMode export_format_mode);
	gboolean (*get_export_export_metadata) (ConfigurationFacade* self);
	void (*set_export_export_metadata) (ConfigurationFacade* self, gboolean export_metadata);
	PhotoFileFormat (*get_export_photo_file_format) (ConfigurationFacade* self);
	void (*set_export_photo_file_format) (ConfigurationFacade* self, PhotoFileFormat photo_file_format);
	JpegQuality (*get_export_quality) (ConfigurationFacade* self);
	void (*set_export_quality) (ConfigurationFacade* self, JpegQuality quality);
	gint (*get_export_scale) (ConfigurationFacade* self);
	void (*set_export_scale) (ConfigurationFacade* self, gint scale);
	RawDeveloper (*get_default_raw_developer) (ConfigurationFacade* self);
	void (*set_default_raw_developer) (ConfigurationFacade* self, RawDeveloper d);
	gboolean (*get_hide_photos_already_imported) (ConfigurationFacade* self);
	void (*set_hide_photos_already_imported) (ConfigurationFacade* self, gboolean hide_imported);
	gchar* (*get_import_dir) (ConfigurationFacade* self);
	void (*set_import_dir) (ConfigurationFacade* self, const gchar* import_dir);
	gboolean (*get_keep_relativity) (ConfigurationFacade* self);
	void (*set_keep_relativity) (ConfigurationFacade* self, gboolean keep_relativity);
	gboolean (*get_pin_toolbar_state) (ConfigurationFacade* self);
	void (*set_pin_toolbar_state) (ConfigurationFacade* self, gboolean state);
	gint (*get_last_crop_height) (ConfigurationFacade* self);
	void (*set_last_crop_height) (ConfigurationFacade* self, gint choice);
	gint (*get_last_crop_menu_choice) (ConfigurationFacade* self);
	void (*set_last_crop_menu_choice) (ConfigurationFacade* self, gint choice);
	gint (*get_last_crop_width) (ConfigurationFacade* self);
	void (*set_last_crop_width) (ConfigurationFacade* self, gint choice);
	gchar* (*get_last_used_service) (ConfigurationFacade* self);
	void (*set_last_used_service) (ConfigurationFacade* self, const gchar* service_name);
	gchar* (*get_last_used_dataimports_service) (ConfigurationFacade* self);
	void (*set_last_used_dataimports_service) (ConfigurationFacade* self, const gchar* service_name);
	void (*get_library_photos_sort) (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
	void (*set_library_photos_sort) (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
	void (*get_library_window_state) (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
	void (*set_library_window_state) (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
	gboolean (*get_modify_originals) (ConfigurationFacade* self);
	void (*set_modify_originals) (ConfigurationFacade* self, gboolean modify_originals);
	gint (*get_photo_thumbnail_scale) (ConfigurationFacade* self);
	void (*set_photo_thumbnail_scale) (ConfigurationFacade* self, gint scale);
	gdouble (*get_printing_content_height) (ConfigurationFacade* self);
	void (*set_printing_content_height) (ConfigurationFacade* self, gdouble content_height);
	gint (*get_printing_content_layout) (ConfigurationFacade* self);
	void (*set_printing_content_layout) (ConfigurationFacade* self, gint layout_code);
	gint (*get_printing_content_ppi) (ConfigurationFacade* self);
	void (*set_printing_content_ppi) (ConfigurationFacade* self, gint content_ppi);
	gint (*get_printing_content_units) (ConfigurationFacade* self);
	void (*set_printing_content_units) (ConfigurationFacade* self, gint units_code);
	gdouble (*get_printing_content_width) (ConfigurationFacade* self);
	void (*set_printing_content_width) (ConfigurationFacade* self, gdouble content_width);
	gint (*get_printing_images_per_page) (ConfigurationFacade* self);
	void (*set_printing_images_per_page) (ConfigurationFacade* self, gint images_per_page_code);
	gboolean (*get_printing_match_aspect_ratio) (ConfigurationFacade* self);
	void (*set_printing_match_aspect_ratio) (ConfigurationFacade* self, gboolean match_aspect_ratio);
	gboolean (*get_printing_print_titles) (ConfigurationFacade* self);
	void (*set_printing_print_titles) (ConfigurationFacade* self, gboolean print_titles);
	gint (*get_printing_size_selection) (ConfigurationFacade* self);
	void (*set_printing_size_selection) (ConfigurationFacade* self, gint size_code);
	gchar* (*get_printing_titles_font) (ConfigurationFacade* self);
	void (*set_printing_titles_font) (ConfigurationFacade* self, const gchar* font_name);
	gboolean (*get_show_welcome_dialog) (ConfigurationFacade* self);
	void (*set_show_welcome_dialog) (ConfigurationFacade* self, gboolean show);
	gint (*get_sidebar_position) (ConfigurationFacade* self);
	void (*set_sidebar_position) (ConfigurationFacade* self, gint position);
	gdouble (*get_slideshow_delay) (ConfigurationFacade* self);
	void (*set_slideshow_delay) (ConfigurationFacade* self, gdouble delay);
	gdouble (*get_slideshow_transition_delay) (ConfigurationFacade* self);
	void (*set_slideshow_transition_delay) (ConfigurationFacade* self, gdouble delay);
	gchar* (*get_slideshow_transition_effect_id) (ConfigurationFacade* self);
	void (*set_slideshow_transition_effect_id) (ConfigurationFacade* self, const gchar* id);
	gboolean (*get_slideshow_show_title) (ConfigurationFacade* self);
	void (*set_slideshow_show_title) (ConfigurationFacade* self, gboolean show_title);
	gboolean (*get_use_24_hour_time) (ConfigurationFacade* self);
	void (*set_use_24_hour_time) (ConfigurationFacade* self, gboolean use_24_hour_time);
	gboolean (*get_use_lowercase_filenames) (ConfigurationFacade* self);
	void (*set_use_lowercase_filenames) (ConfigurationFacade* self, gboolean b);
	gint (*get_video_interpreter_state_cookie) (ConfigurationFacade* self);
	void (*set_video_interpreter_state_cookie) (ConfigurationFacade* self, gint state_cookie);
	gboolean (*get_plugin_bool) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
	void (*set_plugin_bool) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
	gdouble (*get_plugin_double) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
	void (*set_plugin_double) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
	gint (*get_plugin_int) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
	void (*set_plugin_int) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
	gchar* (*get_plugin_string) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
	void (*set_plugin_string) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
	void (*unset_plugin_key) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key);
	FuzzyPropertyState (*is_plugin_enabled) (ConfigurationFacade* self, const gchar* id);
	void (*set_plugin_enabled) (ConfigurationFacade* self, const gchar* id, gboolean enabled);
};

struct _ConfigurationFacadePrivate {
	ConfigurationEngine* engine;
};

typedef enum  {
	RESOURCES_UNIT_SYSTEM_IMPERIAL,
	RESOURCES_UNIT_SYSTEM_METRIC,
	RESOURCES_UNIT_SYSTEM_UNKNOWN
} ResourcesUnitSystem;


static gpointer configuration_facade_parent_class = NULL;

GQuark configuration_error_quark (void);
GType fuzzy_property_state_get_type (void) G_GNUC_CONST;
GType configurable_property_get_type (void) G_GNUC_CONST;
gchar* configurable_property_to_string (ConfigurableProperty self);
GType configuration_engine_get_type (void) G_GNUC_CONST;
gchar* configuration_engine_get_name (ConfigurationEngine* self);
gint configuration_engine_get_int_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
void configuration_engine_set_int_property (ConfigurationEngine* self, ConfigurableProperty p, gint val, GError** error);
gint configuration_engine_get_enum_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
void configuration_engine_set_enum_property (ConfigurationEngine* self, ConfigurableProperty p, gint val, GError** error);
gchar* configuration_engine_get_string_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
void configuration_engine_set_string_property (ConfigurationEngine* self, ConfigurableProperty p, const gchar* val, GError** error);
gboolean configuration_engine_get_bool_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
void configuration_engine_set_bool_property (ConfigurationEngine* self, ConfigurableProperty p, gboolean val, GError** error);
gdouble configuration_engine_get_double_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
void configuration_engine_set_double_property (ConfigurationEngine* self, ConfigurableProperty p, gdouble val, GError** error);
gboolean configuration_engine_get_plugin_bool (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
void configuration_engine_set_plugin_bool (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
gdouble configuration_engine_get_plugin_double (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
void configuration_engine_set_plugin_double (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
gint configuration_engine_get_plugin_int (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
void configuration_engine_set_plugin_int (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
gchar* configuration_engine_get_plugin_string (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
void configuration_engine_set_plugin_string (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
void configuration_engine_unset_plugin_key (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key);
FuzzyPropertyState configuration_engine_is_plugin_enabled (ConfigurationEngine* self, const gchar* id);
void configuration_engine_set_plugin_enabled (ConfigurationEngine* self, const gchar* id, gboolean enabled);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType scale_constraint_get_type (void) G_GNUC_CONST;
GType export_format_mode_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
GType jpeg_quality_get_type (void) G_GNUC_CONST;
GType raw_developer_get_type (void) G_GNUC_CONST;
#define CONFIGURATION_FACADE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CONFIGURATION_FACADE, ConfigurationFacadePrivate))
enum  {
	CONFIGURATION_FACADE_DUMMY_PROPERTY
};
ConfigurationFacade* configuration_facade_construct (GType object_type, ConfigurationEngine* engine);
static void configuration_facade_on_property_changed (ConfigurationFacade* self, ConfigurableProperty p);
static void _configuration_facade_on_property_changed_configuration_engine_property_changed (ConfigurationEngine* _sender, ConfigurableProperty p, gpointer self);
ConfigurationEngine* configuration_facade_get_engine (ConfigurationFacade* self);
void configuration_facade_on_configuration_error (ConfigurationFacade* self, GError* err);
gboolean configuration_facade_get_auto_import_from_library (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_auto_import_from_library (ConfigurationFacade* self);
void configuration_facade_set_auto_import_from_library (ConfigurationFacade* self, gboolean auto_import);
static void configuration_facade_real_set_auto_import_from_library (ConfigurationFacade* self, gboolean auto_import);
gchar* configuration_facade_get_bg_color_name (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_bg_color_name (ConfigurationFacade* self);
void configuration_facade_set_bg_color_name (ConfigurationFacade* self, const gchar* color_name);
static void configuration_facade_real_set_bg_color_name (ConfigurationFacade* self, const gchar* color_name);
gchar* configuration_facade_get_transparent_background_type (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_transparent_background_type (ConfigurationFacade* self);
void configuration_facade_set_transparent_background_type (ConfigurationFacade* self, const gchar* type);
static void configuration_facade_real_set_transparent_background_type (ConfigurationFacade* self, const gchar* type);
gchar* configuration_facade_get_transparent_background_color (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_transparent_background_color (ConfigurationFacade* self);
void configuration_facade_set_transparent_background_color (ConfigurationFacade* self, const gchar* color_name);
static void configuration_facade_real_set_transparent_background_color (ConfigurationFacade* self, const gchar* color_name);
gboolean configuration_facade_get_commit_metadata_to_masters (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_commit_metadata_to_masters (ConfigurationFacade* self);
void configuration_facade_set_commit_metadata_to_masters (ConfigurationFacade* self, gboolean commit_metadata);
static void configuration_facade_real_set_commit_metadata_to_masters (ConfigurationFacade* self, gboolean commit_metadata);
gchar* configuration_facade_get_desktop_background (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_desktop_background (ConfigurationFacade* self);
void configuration_facade_set_desktop_background (ConfigurationFacade* self, const gchar* filename);
static void configuration_facade_real_set_desktop_background (ConfigurationFacade* self, const gchar* filename);
gchar* configuration_facade_get_screensaver (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_screensaver (ConfigurationFacade* self);
void configuration_facade_set_screensaver (ConfigurationFacade* self, const gchar* filename);
static void configuration_facade_real_set_screensaver (ConfigurationFacade* self, const gchar* filename);
gchar* configuration_facade_get_directory_pattern (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_directory_pattern (ConfigurationFacade* self);
void configuration_facade_set_directory_pattern (ConfigurationFacade* self, const gchar* s);
static void configuration_facade_real_set_directory_pattern (ConfigurationFacade* self, const gchar* s);
gchar* configuration_facade_get_directory_pattern_custom (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_directory_pattern_custom (ConfigurationFacade* self);
void configuration_facade_set_directory_pattern_custom (ConfigurationFacade* self, const gchar* s);
static void configuration_facade_real_set_directory_pattern_custom (ConfigurationFacade* self, const gchar* s);
void configuration_facade_get_direct_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
static void configuration_facade_real_get_direct_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
void dimensions_init (Dimensions *self, gint width, gint height);
void configuration_facade_set_direct_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
static void configuration_facade_real_set_direct_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
gboolean configuration_facade_get_display_basic_properties (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_basic_properties (ConfigurationFacade* self);
void configuration_facade_set_display_basic_properties (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_basic_properties (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_extended_properties (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_extended_properties (ConfigurationFacade* self);
void configuration_facade_set_display_extended_properties (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_extended_properties (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_sidebar (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_sidebar (ConfigurationFacade* self);
void configuration_facade_set_display_sidebar (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_sidebar (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_toolbar (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_toolbar (ConfigurationFacade* self);
void configuration_facade_set_display_toolbar (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_toolbar (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_search_bar (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_search_bar (ConfigurationFacade* self);
void configuration_facade_set_display_search_bar (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_search_bar (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_photo_ratings (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_photo_ratings (ConfigurationFacade* self);
void configuration_facade_set_display_photo_ratings (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_photo_ratings (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_photo_tags (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_photo_tags (ConfigurationFacade* self);
void configuration_facade_set_display_photo_tags (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_photo_tags (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_photo_titles (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_photo_titles (ConfigurationFacade* self);
void configuration_facade_set_display_photo_titles (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_photo_titles (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_photo_comments (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_photo_comments (ConfigurationFacade* self);
void configuration_facade_set_display_photo_comments (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_photo_comments (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_event_comments (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_event_comments (ConfigurationFacade* self);
void configuration_facade_set_display_event_comments (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_event_comments (ConfigurationFacade* self, gboolean display);
void configuration_facade_get_event_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
static void configuration_facade_real_get_event_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
void configuration_facade_set_event_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
static void configuration_facade_real_set_event_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
gboolean configuration_facade_get_events_sort_ascending (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_events_sort_ascending (ConfigurationFacade* self);
void configuration_facade_set_events_sort_ascending (ConfigurationFacade* self, gboolean sort);
static void configuration_facade_real_set_events_sort_ascending (ConfigurationFacade* self, gboolean sort);
gchar* configuration_facade_get_external_photo_app (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_external_photo_app (ConfigurationFacade* self);
void configuration_facade_set_external_photo_app (ConfigurationFacade* self, const gchar* external_photo_app);
static void configuration_facade_real_set_external_photo_app (ConfigurationFacade* self, const gchar* external_photo_app);
gchar* configuration_facade_get_external_raw_app (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_external_raw_app (ConfigurationFacade* self);
void configuration_facade_set_external_raw_app (ConfigurationFacade* self, const gchar* external_raw_app);
static void configuration_facade_real_set_external_raw_app (ConfigurationFacade* self, const gchar* external_raw_app);
ScaleConstraint configuration_facade_get_export_constraint (ConfigurationFacade* self);
static ScaleConstraint configuration_facade_real_get_export_constraint (ConfigurationFacade* self);
void configuration_facade_set_export_constraint (ConfigurationFacade* self, ScaleConstraint constraint);
static void configuration_facade_real_set_export_constraint (ConfigurationFacade* self, ScaleConstraint constraint);
ExportFormatMode configuration_facade_get_export_export_format_mode (ConfigurationFacade* self);
static ExportFormatMode configuration_facade_real_get_export_export_format_mode (ConfigurationFacade* self);
void configuration_facade_set_export_export_format_mode (ConfigurationFacade* self, ExportFormatMode export_format_mode);
static void configuration_facade_real_set_export_export_format_mode (ConfigurationFacade* self, ExportFormatMode export_format_mode);
gboolean configuration_facade_get_export_export_metadata (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_export_export_metadata (ConfigurationFacade* self);
void configuration_facade_set_export_export_metadata (ConfigurationFacade* self, gboolean export_metadata);
static void configuration_facade_real_set_export_export_metadata (ConfigurationFacade* self, gboolean export_metadata);
PhotoFileFormat configuration_facade_get_export_photo_file_format (ConfigurationFacade* self);
static PhotoFileFormat configuration_facade_real_get_export_photo_file_format (ConfigurationFacade* self);
PhotoFileFormat photo_file_format_unserialize (gint value);
void configuration_facade_set_export_photo_file_format (ConfigurationFacade* self, PhotoFileFormat photo_file_format);
static void configuration_facade_real_set_export_photo_file_format (ConfigurationFacade* self, PhotoFileFormat photo_file_format);
gint photo_file_format_serialize (PhotoFileFormat self);
JpegQuality configuration_facade_get_export_quality (ConfigurationFacade* self);
static JpegQuality configuration_facade_real_get_export_quality (ConfigurationFacade* self);
void configuration_facade_set_export_quality (ConfigurationFacade* self, JpegQuality quality);
static void configuration_facade_real_set_export_quality (ConfigurationFacade* self, JpegQuality quality);
gint configuration_facade_get_export_scale (ConfigurationFacade* self);
static gint configuration_facade_real_get_export_scale (ConfigurationFacade* self);
void configuration_facade_set_export_scale (ConfigurationFacade* self, gint scale);
static void configuration_facade_real_set_export_scale (ConfigurationFacade* self, gint scale);
RawDeveloper configuration_facade_get_default_raw_developer (ConfigurationFacade* self);
static RawDeveloper configuration_facade_real_get_default_raw_developer (ConfigurationFacade* self);
RawDeveloper raw_developer_from_string (const gchar* value);
void configuration_facade_set_default_raw_developer (ConfigurationFacade* self, RawDeveloper d);
static void configuration_facade_real_set_default_raw_developer (ConfigurationFacade* self, RawDeveloper d);
gchar* raw_developer_to_string (RawDeveloper self);
gboolean configuration_facade_get_hide_photos_already_imported (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_hide_photos_already_imported (ConfigurationFacade* self);
void configuration_facade_set_hide_photos_already_imported (ConfigurationFacade* self, gboolean hide_imported);
static void configuration_facade_real_set_hide_photos_already_imported (ConfigurationFacade* self, gboolean hide_imported);
gchar* configuration_facade_get_import_dir (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_import_dir (ConfigurationFacade* self);
void configuration_facade_set_import_dir (ConfigurationFacade* self, const gchar* import_dir);
static void configuration_facade_real_set_import_dir (ConfigurationFacade* self, const gchar* import_dir);
gboolean configuration_facade_get_keep_relativity (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_keep_relativity (ConfigurationFacade* self);
void configuration_facade_set_keep_relativity (ConfigurationFacade* self, gboolean keep_relativity);
static void configuration_facade_real_set_keep_relativity (ConfigurationFacade* self, gboolean keep_relativity);
gboolean configuration_facade_get_pin_toolbar_state (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_pin_toolbar_state (ConfigurationFacade* self);
void configuration_facade_set_pin_toolbar_state (ConfigurationFacade* self, gboolean state);
static void configuration_facade_real_set_pin_toolbar_state (ConfigurationFacade* self, gboolean state);
gint configuration_facade_get_last_crop_height (ConfigurationFacade* self);
static gint configuration_facade_real_get_last_crop_height (ConfigurationFacade* self);
void configuration_facade_set_last_crop_height (ConfigurationFacade* self, gint choice);
static void configuration_facade_real_set_last_crop_height (ConfigurationFacade* self, gint choice);
gint configuration_facade_get_last_crop_menu_choice (ConfigurationFacade* self);
static gint configuration_facade_real_get_last_crop_menu_choice (ConfigurationFacade* self);
void configuration_facade_set_last_crop_menu_choice (ConfigurationFacade* self, gint choice);
static void configuration_facade_real_set_last_crop_menu_choice (ConfigurationFacade* self, gint choice);
gint configuration_facade_get_last_crop_width (ConfigurationFacade* self);
static gint configuration_facade_real_get_last_crop_width (ConfigurationFacade* self);
void configuration_facade_set_last_crop_width (ConfigurationFacade* self, gint choice);
static void configuration_facade_real_set_last_crop_width (ConfigurationFacade* self, gint choice);
gchar* configuration_facade_get_last_used_service (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_last_used_service (ConfigurationFacade* self);
void configuration_facade_set_last_used_service (ConfigurationFacade* self, const gchar* service_name);
static void configuration_facade_real_set_last_used_service (ConfigurationFacade* self, const gchar* service_name);
gchar* configuration_facade_get_last_used_dataimports_service (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_last_used_dataimports_service (ConfigurationFacade* self);
void configuration_facade_set_last_used_dataimports_service (ConfigurationFacade* self, const gchar* service_name);
static void configuration_facade_real_set_last_used_dataimports_service (ConfigurationFacade* self, const gchar* service_name);
void configuration_facade_get_library_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
static void configuration_facade_real_get_library_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
void configuration_facade_set_library_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
static void configuration_facade_real_set_library_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
void configuration_facade_get_library_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
static void configuration_facade_real_get_library_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
void configuration_facade_set_library_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
static void configuration_facade_real_set_library_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
gboolean configuration_facade_get_modify_originals (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_modify_originals (ConfigurationFacade* self);
void configuration_facade_set_modify_originals (ConfigurationFacade* self, gboolean modify_originals);
static void configuration_facade_real_set_modify_originals (ConfigurationFacade* self, gboolean modify_originals);
gint configuration_facade_get_photo_thumbnail_scale (ConfigurationFacade* self);
static gint configuration_facade_real_get_photo_thumbnail_scale (ConfigurationFacade* self);
gint thumbnail_get_DEFAULT_SCALE (void);
void configuration_facade_set_photo_thumbnail_scale (ConfigurationFacade* self, gint scale);
static void configuration_facade_real_set_photo_thumbnail_scale (ConfigurationFacade* self, gint scale);
gdouble configuration_facade_get_printing_content_height (ConfigurationFacade* self);
static gdouble configuration_facade_real_get_printing_content_height (ConfigurationFacade* self);
void configuration_facade_set_printing_content_height (ConfigurationFacade* self, gdouble content_height);
static void configuration_facade_real_set_printing_content_height (ConfigurationFacade* self, gdouble content_height);
gint configuration_facade_get_printing_content_layout (ConfigurationFacade* self);
static gint configuration_facade_real_get_printing_content_layout (ConfigurationFacade* self);
void configuration_facade_set_printing_content_layout (ConfigurationFacade* self, gint layout_code);
static void configuration_facade_real_set_printing_content_layout (ConfigurationFacade* self, gint layout_code);
gint configuration_facade_get_printing_content_ppi (ConfigurationFacade* self);
static gint configuration_facade_real_get_printing_content_ppi (ConfigurationFacade* self);
void configuration_facade_set_printing_content_ppi (ConfigurationFacade* self, gint content_ppi);
static void configuration_facade_real_set_printing_content_ppi (ConfigurationFacade* self, gint content_ppi);
gint configuration_facade_get_printing_content_units (ConfigurationFacade* self);
static gint configuration_facade_real_get_printing_content_units (ConfigurationFacade* self);
void configuration_facade_set_printing_content_units (ConfigurationFacade* self, gint units_code);
static void configuration_facade_real_set_printing_content_units (ConfigurationFacade* self, gint units_code);
gdouble configuration_facade_get_printing_content_width (ConfigurationFacade* self);
static gdouble configuration_facade_real_get_printing_content_width (ConfigurationFacade* self);
void configuration_facade_set_printing_content_width (ConfigurationFacade* self, gdouble content_width);
static void configuration_facade_real_set_printing_content_width (ConfigurationFacade* self, gdouble content_width);
gint configuration_facade_get_printing_images_per_page (ConfigurationFacade* self);
static gint configuration_facade_real_get_printing_images_per_page (ConfigurationFacade* self);
void configuration_facade_set_printing_images_per_page (ConfigurationFacade* self, gint images_per_page_code);
static void configuration_facade_real_set_printing_images_per_page (ConfigurationFacade* self, gint images_per_page_code);
gboolean configuration_facade_get_printing_match_aspect_ratio (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_printing_match_aspect_ratio (ConfigurationFacade* self);
void configuration_facade_set_printing_match_aspect_ratio (ConfigurationFacade* self, gboolean match_aspect_ratio);
static void configuration_facade_real_set_printing_match_aspect_ratio (ConfigurationFacade* self, gboolean match_aspect_ratio);
gboolean configuration_facade_get_printing_print_titles (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_printing_print_titles (ConfigurationFacade* self);
void configuration_facade_set_printing_print_titles (ConfigurationFacade* self, gboolean print_titles);
static void configuration_facade_real_set_printing_print_titles (ConfigurationFacade* self, gboolean print_titles);
gint configuration_facade_get_printing_size_selection (ConfigurationFacade* self);
static gint configuration_facade_real_get_printing_size_selection (ConfigurationFacade* self);
GType resources_unit_system_get_type (void) G_GNUC_CONST;
ResourcesUnitSystem resources_get_default_measurement_unit (void);
void configuration_facade_set_printing_size_selection (ConfigurationFacade* self, gint size_code);
static void configuration_facade_real_set_printing_size_selection (ConfigurationFacade* self, gint size_code);
gchar* configuration_facade_get_printing_titles_font (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_printing_titles_font (ConfigurationFacade* self);
void configuration_facade_set_printing_titles_font (ConfigurationFacade* self, const gchar* font_name);
static void configuration_facade_real_set_printing_titles_font (ConfigurationFacade* self, const gchar* font_name);
gboolean configuration_facade_get_show_welcome_dialog (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_show_welcome_dialog (ConfigurationFacade* self);
void configuration_facade_set_show_welcome_dialog (ConfigurationFacade* self, gboolean show);
static void configuration_facade_real_set_show_welcome_dialog (ConfigurationFacade* self, gboolean show);
gint configuration_facade_get_sidebar_position (ConfigurationFacade* self);
static gint configuration_facade_real_get_sidebar_position (ConfigurationFacade* self);
void configuration_facade_set_sidebar_position (ConfigurationFacade* self, gint position);
static void configuration_facade_real_set_sidebar_position (ConfigurationFacade* self, gint position);
gdouble configuration_facade_get_slideshow_delay (ConfigurationFacade* self);
static gdouble configuration_facade_real_get_slideshow_delay (ConfigurationFacade* self);
void configuration_facade_set_slideshow_delay (ConfigurationFacade* self, gdouble delay);
static void configuration_facade_real_set_slideshow_delay (ConfigurationFacade* self, gdouble delay);
gdouble configuration_facade_get_slideshow_transition_delay (ConfigurationFacade* self);
static gdouble configuration_facade_real_get_slideshow_transition_delay (ConfigurationFacade* self);
void configuration_facade_set_slideshow_transition_delay (ConfigurationFacade* self, gdouble delay);
static void configuration_facade_real_set_slideshow_transition_delay (ConfigurationFacade* self, gdouble delay);
gchar* configuration_facade_get_slideshow_transition_effect_id (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_slideshow_transition_effect_id (ConfigurationFacade* self);
#define NULL_TRANSITION_DESCRIPTOR_EFFECT_ID "org.yorba.shotwell.transitions.null"
#define TRANSITION_EFFECTS_MANAGER_NULL_EFFECT_ID NULL_TRANSITION_DESCRIPTOR_EFFECT_ID
void configuration_facade_set_slideshow_transition_effect_id (ConfigurationFacade* self, const gchar* id);
static void configuration_facade_real_set_slideshow_transition_effect_id (ConfigurationFacade* self, const gchar* id);
gboolean configuration_facade_get_slideshow_show_title (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_slideshow_show_title (ConfigurationFacade* self);
void configuration_facade_set_slideshow_show_title (ConfigurationFacade* self, gboolean show_title);
static void configuration_facade_real_set_slideshow_show_title (ConfigurationFacade* self, gboolean show_title);
gboolean configuration_facade_get_use_24_hour_time (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_use_24_hour_time (ConfigurationFacade* self);
gboolean is_string_empty (const gchar* s);
void configuration_facade_set_use_24_hour_time (ConfigurationFacade* self, gboolean use_24_hour_time);
static void configuration_facade_real_set_use_24_hour_time (ConfigurationFacade* self, gboolean use_24_hour_time);
gboolean configuration_facade_get_use_lowercase_filenames (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_use_lowercase_filenames (ConfigurationFacade* self);
void configuration_facade_set_use_lowercase_filenames (ConfigurationFacade* self, gboolean b);
static void configuration_facade_real_set_use_lowercase_filenames (ConfigurationFacade* self, gboolean b);
gint configuration_facade_get_video_interpreter_state_cookie (ConfigurationFacade* self);
static gint configuration_facade_real_get_video_interpreter_state_cookie (ConfigurationFacade* self);
void configuration_facade_set_video_interpreter_state_cookie (ConfigurationFacade* self, gint state_cookie);
static void configuration_facade_real_set_video_interpreter_state_cookie (ConfigurationFacade* self, gint state_cookie);
gboolean configuration_facade_get_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
static gboolean configuration_facade_real_get_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
void configuration_facade_set_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
static void configuration_facade_real_set_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
gdouble configuration_facade_get_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
static gdouble configuration_facade_real_get_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
void configuration_facade_set_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
static void configuration_facade_real_set_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
gint configuration_facade_get_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
static gint configuration_facade_real_get_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
void configuration_facade_set_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
static void configuration_facade_real_set_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
gchar* configuration_facade_get_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
static gchar* configuration_facade_real_get_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
void configuration_facade_set_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
static void configuration_facade_real_set_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
void configuration_facade_unset_plugin_key (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key);
static void configuration_facade_real_unset_plugin_key (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key);
FuzzyPropertyState configuration_facade_is_plugin_enabled (ConfigurationFacade* self, const gchar* id);
static FuzzyPropertyState configuration_facade_real_is_plugin_enabled (ConfigurationFacade* self, const gchar* id);
void configuration_facade_set_plugin_enabled (ConfigurationFacade* self, const gchar* id, gboolean enabled);
static void configuration_facade_real_set_plugin_enabled (ConfigurationFacade* self, const gchar* id, gboolean enabled);
static void configuration_facade_finalize (GObject * obj);


GQuark configuration_error_quark (void) {
	return g_quark_from_static_string ("configuration_error-quark");
}


GType fuzzy_property_state_get_type (void) {
	static volatile gsize fuzzy_property_state_type_id__volatile = 0;
	if (g_once_init_enter (&fuzzy_property_state_type_id__volatile)) {
		static const GEnumValue values[] = {{FUZZY_PROPERTY_STATE_ENABLED, "FUZZY_PROPERTY_STATE_ENABLED", "enabled"}, {FUZZY_PROPERTY_STATE_DISABLED, "FUZZY_PROPERTY_STATE_DISABLED", "disabled"}, {FUZZY_PROPERTY_STATE_UNKNOWN, "FUZZY_PROPERTY_STATE_UNKNOWN", "unknown"}, {0, NULL, NULL}};
		GType fuzzy_property_state_type_id;
		fuzzy_property_state_type_id = g_enum_register_static ("FuzzyPropertyState", values);
		g_once_init_leave (&fuzzy_property_state_type_id__volatile, fuzzy_property_state_type_id);
	}
	return fuzzy_property_state_type_id__volatile;
}


gchar* configurable_property_to_string (ConfigurableProperty self) {
	gchar* result = NULL;
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	switch (self) {
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY:
#line 747 "ConfigurationInterfaces.c"
		{
			gchar* _tmp0_;
#line 101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp0_ = g_strdup ("AUTO_IMPORT_FROM_LIBRARY");
#line 101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp0_;
#line 101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 756 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_BG_COLOR_NAME:
#line 760 "ConfigurationInterfaces.c"
		{
			gchar* _tmp1_;
#line 104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp1_ = g_strdup ("BG_COLOR_NAME");
#line 104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp1_;
#line 104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 769 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_TYPE:
#line 773 "ConfigurationInterfaces.c"
		{
			gchar* _tmp2_;
#line 107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp2_ = g_strdup ("TRANSPARENT_BACKGROUND_TYPE");
#line 107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp2_;
#line 107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 782 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_COLOR:
#line 786 "ConfigurationInterfaces.c"
		{
			gchar* _tmp3_;
#line 110 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp3_ = g_strdup ("TRANSPARENT_BACKGROUND_COLOR");
#line 110 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp3_;
#line 110 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 795 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS:
#line 799 "ConfigurationInterfaces.c"
		{
			gchar* _tmp4_;
#line 113 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp4_ = g_strdup ("COMMIT_METADATA_TO_MASTERS");
#line 113 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp4_;
#line 113 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 808 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE:
#line 812 "ConfigurationInterfaces.c"
		{
			gchar* _tmp5_;
#line 116 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp5_ = g_strdup ("DESKTOP_BACKGROUND_FILE");
#line 116 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp5_;
#line 116 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 821 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE:
#line 825 "ConfigurationInterfaces.c"
		{
			gchar* _tmp6_;
#line 119 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp6_ = g_strdup ("DESKTOP_BACKGROUND_MODE");
#line 119 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp6_;
#line 119 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 834 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SCREENSAVER_FILE:
#line 838 "ConfigurationInterfaces.c"
		{
			gchar* _tmp7_;
#line 122 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp7_ = g_strdup ("SCREENSAVER_FILE");
#line 122 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp7_;
#line 122 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 847 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SCREENSAVER_MODE:
#line 851 "ConfigurationInterfaces.c"
		{
			gchar* _tmp8_;
#line 125 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp8_ = g_strdup ("SCREENSAVER_MODE");
#line 125 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp8_;
#line 125 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 860 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN:
#line 864 "ConfigurationInterfaces.c"
		{
			gchar* _tmp9_;
#line 128 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp9_ = g_strdup ("DIRECTORY_PATTERN");
#line 128 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp9_;
#line 128 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 873 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM:
#line 877 "ConfigurationInterfaces.c"
		{
			gchar* _tmp10_;
#line 131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp10_ = g_strdup ("DIRECTORY_PATTERN_CUSTOM");
#line 131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp10_;
#line 131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 886 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT:
#line 890 "ConfigurationInterfaces.c"
		{
			gchar* _tmp11_;
#line 134 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp11_ = g_strdup ("DIRECT_WINDOW_HEIGHT");
#line 134 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp11_;
#line 134 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 899 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE:
#line 903 "ConfigurationInterfaces.c"
		{
			gchar* _tmp12_;
#line 137 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp12_ = g_strdup ("DIRECT_WINDOW_MAXIMIZE");
#line 137 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp12_;
#line 137 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 912 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH:
#line 916 "ConfigurationInterfaces.c"
		{
			gchar* _tmp13_;
#line 140 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp13_ = g_strdup ("DIRECT_WINDOW_WIDTH");
#line 140 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp13_;
#line 140 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 925 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES:
#line 929 "ConfigurationInterfaces.c"
		{
			gchar* _tmp14_;
#line 143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp14_ = g_strdup ("DISPLAY_BASIC_PROPERTIES");
#line 143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp14_;
#line 143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 938 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES:
#line 942 "ConfigurationInterfaces.c"
		{
			gchar* _tmp15_;
#line 146 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp15_ = g_strdup ("DISPLAY_EXTENDED_PROPERTIES");
#line 146 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp15_;
#line 146 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 951 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR:
#line 955 "ConfigurationInterfaces.c"
		{
			gchar* _tmp16_;
#line 149 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp16_ = g_strdup ("DISPLAY_SIDEBAR");
#line 149 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp16_;
#line 149 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 964 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR:
#line 968 "ConfigurationInterfaces.c"
		{
			gchar* _tmp17_;
#line 152 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp17_ = g_strdup ("DISPLAY_TOOLBAR");
#line 152 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp17_;
#line 152 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 977 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR:
#line 981 "ConfigurationInterfaces.c"
		{
			gchar* _tmp18_;
#line 155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp18_ = g_strdup ("DISPLAY_SEARCH_BAR");
#line 155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp18_;
#line 155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 990 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS:
#line 994 "ConfigurationInterfaces.c"
		{
			gchar* _tmp19_;
#line 158 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp19_ = g_strdup ("DISPLAY_PHOTO_RATINGS");
#line 158 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp19_;
#line 158 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1003 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS:
#line 1007 "ConfigurationInterfaces.c"
		{
			gchar* _tmp20_;
#line 161 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp20_ = g_strdup ("DISPLAY_PHOTO_TAGS");
#line 161 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp20_;
#line 161 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1016 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES:
#line 1020 "ConfigurationInterfaces.c"
		{
			gchar* _tmp21_;
#line 164 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp21_ = g_strdup ("DISPLAY_PHOTO_TITLES");
#line 164 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp21_;
#line 164 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1029 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS:
#line 1033 "ConfigurationInterfaces.c"
		{
			gchar* _tmp22_;
#line 167 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp22_ = g_strdup ("DISPLAY_PHOTO_COMMENTS");
#line 167 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp22_;
#line 167 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1042 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS:
#line 1046 "ConfigurationInterfaces.c"
		{
			gchar* _tmp23_;
#line 170 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp23_ = g_strdup ("DISPLAY_EVENT_COMMENTS");
#line 170 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp23_;
#line 170 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1055 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING:
#line 1059 "ConfigurationInterfaces.c"
		{
			gchar* _tmp24_;
#line 173 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp24_ = g_strdup ("EVENT_PHOTOS_SORT_ASCENDING");
#line 173 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp24_;
#line 173 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1068 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY:
#line 1072 "ConfigurationInterfaces.c"
		{
			gchar* _tmp25_;
#line 176 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp25_ = g_strdup ("EVENT_PHOTOS_SORT_BY");
#line 176 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp25_;
#line 176 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1081 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING:
#line 1085 "ConfigurationInterfaces.c"
		{
			gchar* _tmp26_;
#line 179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp26_ = g_strdup ("EVENTS_SORT_ASCENDING");
#line 179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp26_;
#line 179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1094 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXPORT_CONSTRAINT:
#line 1098 "ConfigurationInterfaces.c"
		{
			gchar* _tmp27_;
#line 182 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp27_ = g_strdup ("EXPORT_CONSTRAINT");
#line 182 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp27_;
#line 182 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1107 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXPORT_EXPORT_FORMAT_MODE:
#line 1111 "ConfigurationInterfaces.c"
		{
			gchar* _tmp28_;
#line 185 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp28_ = g_strdup ("EXPORT_EXPORT_FORMAT_MODE");
#line 185 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp28_;
#line 185 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1120 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXPORT_EXPORT_METADATA:
#line 1124 "ConfigurationInterfaces.c"
		{
			gchar* _tmp29_;
#line 188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp29_ = g_strdup ("EXPORT_EXPORT_METADATA");
#line 188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp29_;
#line 188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1133 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXPORT_PHOTO_FILE_FORMAT:
#line 1137 "ConfigurationInterfaces.c"
		{
			gchar* _tmp30_;
#line 191 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp30_ = g_strdup ("EXPORT_PHOTO_FILE_FORMAT");
#line 191 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp30_;
#line 191 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1146 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXPORT_QUALITY:
#line 1150 "ConfigurationInterfaces.c"
		{
			gchar* _tmp31_;
#line 194 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp31_ = g_strdup ("EXPORT_QUALITY");
#line 194 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp31_;
#line 194 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1159 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXPORT_SCALE:
#line 1163 "ConfigurationInterfaces.c"
		{
			gchar* _tmp32_;
#line 197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp32_ = g_strdup ("EXPORT_SCALE");
#line 197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp32_;
#line 197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1172 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP:
#line 1176 "ConfigurationInterfaces.c"
		{
			gchar* _tmp33_;
#line 200 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp33_ = g_strdup ("EXTERNAL_PHOTO_APP");
#line 200 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp33_;
#line 200 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1185 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP:
#line 1189 "ConfigurationInterfaces.c"
		{
			gchar* _tmp34_;
#line 203 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp34_ = g_strdup ("EXTERNAL_RAW_APP");
#line 203 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp34_;
#line 203 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1198 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED:
#line 1202 "ConfigurationInterfaces.c"
		{
			gchar* _tmp35_;
#line 206 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp35_ = g_strdup ("HIDE_PHOTOS_ALREADY_IMPORTED");
#line 206 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp35_;
#line 206 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1211 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_IMPORT_DIR:
#line 1215 "ConfigurationInterfaces.c"
		{
			gchar* _tmp36_;
#line 209 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp36_ = g_strdup ("IMPORT_DIR");
#line 209 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp36_;
#line 209 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1224 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_KEEP_RELATIVITY:
#line 1228 "ConfigurationInterfaces.c"
		{
			gchar* _tmp37_;
#line 212 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp37_ = g_strdup ("KEEP_RELATIVITY");
#line 212 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp37_;
#line 212 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1237 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT:
#line 1241 "ConfigurationInterfaces.c"
		{
			gchar* _tmp38_;
#line 215 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp38_ = g_strdup ("LAST_CROP_HEIGHT");
#line 215 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp38_;
#line 215 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1250 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE:
#line 1254 "ConfigurationInterfaces.c"
		{
			gchar* _tmp39_;
#line 218 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp39_ = g_strdup ("LAST_CROP_MENU_CHOICE");
#line 218 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp39_;
#line 218 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1263 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH:
#line 1267 "ConfigurationInterfaces.c"
		{
			gchar* _tmp40_;
#line 221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp40_ = g_strdup ("LAST_CROP_WIDTH");
#line 221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp40_;
#line 221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1276 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LAST_USED_SERVICE:
#line 1280 "ConfigurationInterfaces.c"
		{
			gchar* _tmp41_;
#line 224 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp41_ = g_strdup ("LAST_USED_SERVICE");
#line 224 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp41_;
#line 224 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1289 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE:
#line 1293 "ConfigurationInterfaces.c"
		{
			gchar* _tmp42_;
#line 227 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp42_ = g_strdup ("LAST_USED_DATAIMPORTS_SERVICE");
#line 227 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp42_;
#line 227 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1302 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING:
#line 1306 "ConfigurationInterfaces.c"
		{
			gchar* _tmp43_;
#line 230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp43_ = g_strdup ("LIBRARY_PHOTOS_SORT_ASCENDING");
#line 230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp43_;
#line 230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1315 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY:
#line 1319 "ConfigurationInterfaces.c"
		{
			gchar* _tmp44_;
#line 233 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp44_ = g_strdup ("LIBRARY_PHOTOS_SORT_BY");
#line 233 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp44_;
#line 233 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1328 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT:
#line 1332 "ConfigurationInterfaces.c"
		{
			gchar* _tmp45_;
#line 236 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp45_ = g_strdup ("LIBRARY_WINDOW_HEIGHT");
#line 236 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp45_;
#line 236 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1341 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE:
#line 1345 "ConfigurationInterfaces.c"
		{
			gchar* _tmp46_;
#line 239 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp46_ = g_strdup ("LIBRARY_WINDOW_MAXIMIZE");
#line 239 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp46_;
#line 239 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1354 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH:
#line 1358 "ConfigurationInterfaces.c"
		{
			gchar* _tmp47_;
#line 242 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp47_ = g_strdup ("LIBRARY_WINDOW_WIDTH");
#line 242 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp47_;
#line 242 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1367 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS:
#line 1371 "ConfigurationInterfaces.c"
		{
			gchar* _tmp48_;
#line 245 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp48_ = g_strdup ("MODIFY_ORIGINALS");
#line 245 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp48_;
#line 245 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1380 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE:
#line 1384 "ConfigurationInterfaces.c"
		{
			gchar* _tmp49_;
#line 248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp49_ = g_strdup ("PHOTO_THUMBNAIL_SCALE");
#line 248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp49_;
#line 248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1393 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE:
#line 1397 "ConfigurationInterfaces.c"
		{
			gchar* _tmp50_;
#line 251 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp50_ = g_strdup ("PIN_TOOLBAR_STATE");
#line 251 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp50_;
#line 251 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1406 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT:
#line 1410 "ConfigurationInterfaces.c"
		{
			gchar* _tmp51_;
#line 254 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp51_ = g_strdup ("PRINTING_CONTENT_HEIGHT");
#line 254 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp51_;
#line 254 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1419 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT:
#line 1423 "ConfigurationInterfaces.c"
		{
			gchar* _tmp52_;
#line 257 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp52_ = g_strdup ("PRINTING_CONTENT_LAYOUT");
#line 257 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp52_;
#line 257 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1432 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI:
#line 1436 "ConfigurationInterfaces.c"
		{
			gchar* _tmp53_;
#line 260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp53_ = g_strdup ("PRINTING_CONTENT_PPI");
#line 260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp53_;
#line 260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1445 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS:
#line 1449 "ConfigurationInterfaces.c"
		{
			gchar* _tmp54_;
#line 263 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp54_ = g_strdup ("PRINTING_CONTENT_UNITS");
#line 263 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp54_;
#line 263 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1458 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH:
#line 1462 "ConfigurationInterfaces.c"
		{
			gchar* _tmp55_;
#line 266 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp55_ = g_strdup ("PRINTING_CONTENT_WIDTH");
#line 266 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp55_;
#line 266 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1471 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE:
#line 1475 "ConfigurationInterfaces.c"
		{
			gchar* _tmp56_;
#line 269 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp56_ = g_strdup ("PRINTING_IMAGES_PER_PAGE");
#line 269 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp56_;
#line 269 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1484 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO:
#line 1488 "ConfigurationInterfaces.c"
		{
			gchar* _tmp57_;
#line 272 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp57_ = g_strdup ("PRINTING_MATCH_ASPECT_RATIO");
#line 272 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp57_;
#line 272 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1497 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES:
#line 1501 "ConfigurationInterfaces.c"
		{
			gchar* _tmp58_;
#line 275 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp58_ = g_strdup ("PRINTING_PRINT_TITLES");
#line 275 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp58_;
#line 275 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1510 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION:
#line 1514 "ConfigurationInterfaces.c"
		{
			gchar* _tmp59_;
#line 278 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp59_ = g_strdup ("PRINTING_SIZE_SELECTION");
#line 278 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp59_;
#line 278 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1523 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT:
#line 1527 "ConfigurationInterfaces.c"
		{
			gchar* _tmp60_;
#line 281 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp60_ = g_strdup ("PRINTING_TITLES_FONT");
#line 281 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp60_;
#line 281 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1536 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT:
#line 1540 "ConfigurationInterfaces.c"
		{
			gchar* _tmp61_;
#line 284 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp61_ = g_strdup ("RAW_DEVELOPER_DEFAULT");
#line 284 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp61_;
#line 284 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1549 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG:
#line 1553 "ConfigurationInterfaces.c"
		{
			gchar* _tmp62_;
#line 287 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp62_ = g_strdup ("SHOW_WELCOME_DIALOG");
#line 287 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp62_;
#line 287 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1562 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SIDEBAR_POSITION:
#line 1566 "ConfigurationInterfaces.c"
		{
			gchar* _tmp63_;
#line 290 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp63_ = g_strdup ("SIDEBAR_POSITION");
#line 290 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp63_;
#line 290 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1575 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY:
#line 1579 "ConfigurationInterfaces.c"
		{
			gchar* _tmp64_;
#line 293 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp64_ = g_strdup ("SLIDESHOW_DELAY");
#line 293 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp64_;
#line 293 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1588 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY:
#line 1592 "ConfigurationInterfaces.c"
		{
			gchar* _tmp65_;
#line 296 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp65_ = g_strdup ("SLIDESHOW_TRANSITION_DELAY");
#line 296 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp65_;
#line 296 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1601 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID:
#line 1605 "ConfigurationInterfaces.c"
		{
			gchar* _tmp66_;
#line 299 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp66_ = g_strdup ("SLIDESHOW_TRANSITION_EFFECT_ID");
#line 299 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp66_;
#line 299 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1614 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE:
#line 1618 "ConfigurationInterfaces.c"
		{
			gchar* _tmp67_;
#line 302 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp67_ = g_strdup ("SLIDESHOW_SHOW_TITLE");
#line 302 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp67_;
#line 302 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1627 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME:
#line 1631 "ConfigurationInterfaces.c"
		{
			gchar* _tmp68_;
#line 305 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp68_ = g_strdup ("USE_24_HOUR_TIME");
#line 305 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp68_;
#line 305 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1640 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES:
#line 1644 "ConfigurationInterfaces.c"
		{
			gchar* _tmp69_;
#line 308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp69_ = g_strdup ("USE_LOWERCASE_FILENAMES");
#line 308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp69_;
#line 308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1653 "ConfigurationInterfaces.c"
		}
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE:
#line 1657 "ConfigurationInterfaces.c"
		{
			gchar* _tmp70_;
#line 311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp70_ = g_strdup ("VIDEO_INTERPRETER_STATE_COOKIE");
#line 311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp70_;
#line 311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1666 "ConfigurationInterfaces.c"
		}
		default:
		{
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_error ("ConfigurationInterfaces.vala:314: unknown ConfigurableProperty enumera" \
"tion value");
#line 1672 "ConfigurationInterfaces.c"
		}
	}
}


GType configurable_property_get_type (void) {
	static volatile gsize configurable_property_type_id__volatile = 0;
	if (g_once_init_enter (&configurable_property_type_id__volatile)) {
		static const GEnumValue values[] = {{CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY, "CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY", "auto-import-from-library"}, {CONFIGURABLE_PROPERTY_BG_COLOR_NAME, "CONFIGURABLE_PROPERTY_BG_COLOR_NAME", "bg-color-name"}, {CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_TYPE, "CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_TYPE", "transparent-background-type"}, {CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_COLOR, "CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_COLOR", "transparent-background-color"}, {CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS, "CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS", "commit-metadata-to-masters"}, {CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE, "CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE", "desktop-background-file"}, {CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE, "CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE", "desktop-background-mode"}, {CONFIGURABLE_PROPERTY_SCREENSAVER_FILE, "CONFIGURABLE_PROPERTY_SCREENSAVER_FILE", "screensaver-file"}, {CONFIGURABLE_PROPERTY_SCREENSAVER_MODE, "CONFIGURABLE_PROPERTY_SCREENSAVER_MODE", "screensaver-mode"}, {CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN, "CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN", "directory-pattern"}, {CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM, "CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM", "directory-pattern-custom"}, {CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT, "CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT", "direct-window-height"}, {CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE, "CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE", "direct-window-maximize"}, {CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH, "CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH", "direct-window-width"}, {CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES, "CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES", "display-basic-properties"}, {CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS, "CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS", "display-event-comments"}, {CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES, "CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES", "display-extended-properties"}, {CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR, "CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR", "display-sidebar"}, {CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR, "CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR", "display-toolbar"}, {CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR, "CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR", "display-search-bar"}, {CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS, "CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS", "display-photo-ratings"}, {CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS, "CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS", "display-photo-tags"}, {CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES, "CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES", "display-photo-titles"}, {CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS, "CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS", "display-photo-comments"}, {CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING, "CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING", "event-photos-sort-ascending"}, {CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY, "CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY", "event-photos-sort-by"}, {CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING, "CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING", "events-sort-ascending"}, {CONFIGURABLE_PROPERTY_EXPORT_CONSTRAINT, "CONFIGURABLE_PROPERTY_EXPORT_CONSTRAINT", "export-constraint"}, {CONFIGURABLE_PROPERTY_EXPORT_EXPORT_FORMAT_MODE, "CONFIGURABLE_PROPERTY_EXPORT_EXPORT_FORMAT_MODE", "export-export-format-mode"}, {CONFIGURABLE_PROPERTY_EXPORT_EXPORT_METADATA, "CONFIGURABLE_PROPERTY_EXPORT_EXPORT_METADATA", "export-export-metadata"}, {CONFIGURABLE_PROPERTY_EXPORT_PHOTO_FILE_FORMAT, "CONFIGURABLE_PROPERTY_EXPORT_PHOTO_FILE_FORMAT", "export-photo-file-format"}, {CONFIGURABLE_PROPERTY_EXPORT_QUALITY, "CONFIGURABLE_PROPERTY_EXPORT_QUALITY", "export-quality"}, {CONFIGURABLE_PROPERTY_EXPORT_SCALE, "CONFIGURABLE_PROPERTY_EXPORT_SCALE", "export-scale"}, {CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP, "CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP", "external-photo-app"}, {CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP, "CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP", "external-raw-app"}, {CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED, "CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED", "hide-photos-already-imported"}, {CONFIGURABLE_PROPERTY_IMPORT_DIR, "CONFIGURABLE_PROPERTY_IMPORT_DIR", "import-dir"}, {CONFIGURABLE_PROPERTY_KEEP_RELATIVITY, "CONFIGURABLE_PROPERTY_KEEP_RELATIVITY", "keep-relativity"}, {CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT, "CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT", "last-crop-height"}, {CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE, "CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE", "last-crop-menu-choice"}, {CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH, "CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH", "last-crop-width"}, {CONFIGURABLE_PROPERTY_LAST_USED_SERVICE, "CONFIGURABLE_PROPERTY_LAST_USED_SERVICE", "last-used-service"}, {CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE, "CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE", "last-used-dataimports-service"}, {CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING, "CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING", "library-photos-sort-ascending"}, {CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY, "CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY", "library-photos-sort-by"}, {CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT, "CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT", "library-window-height"}, {CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE, "CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE", "library-window-maximize"}, {CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH, "CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH", "library-window-width"}, {CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS, "CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS", "modify-originals"}, {CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE, "CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE", "photo-thumbnail-scale"}, {CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE, "CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE", "pin-toolbar-state"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT", "printing-content-height"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT", "printing-content-layout"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI", "printing-content-ppi"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS", "printing-content-units"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH", "printing-content-width"}, {CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE, "CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE", "printing-images-per-page"}, {CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO, "CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO", "printing-match-aspect-ratio"}, {CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES, "CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES", "printing-print-titles"}, {CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION, "CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION", "printing-size-selection"}, {CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT, "CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT", "printing-titles-font"}, {CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT, "CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT", "raw-developer-default"}, {CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG, "CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG", "show-welcome-dialog"}, {CONFIGURABLE_PROPERTY_SIDEBAR_POSITION, "CONFIGURABLE_PROPERTY_SIDEBAR_POSITION", "sidebar-position"}, {CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY, "CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY", "slideshow-delay"}, {CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY, "CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY", "slideshow-transition-delay"}, {CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID, "CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID", "slideshow-transition-effect-id"}, {CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE, "CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE", "slideshow-show-title"}, {CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME, "CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME", "use-24-hour-time"}, {CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES, "CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES", "use-lowercase-filenames"}, {CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE, "CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE", "video-interpreter-state-cookie"}, {CONFIGURABLE_PROPERTY_NUM_PROPERTIES, "CONFIGURABLE_PROPERTY_NUM_PROPERTIES", "num-properties"}, {0, NULL, NULL}};
		GType configurable_property_type_id;
		configurable_property_type_id = g_enum_register_static ("ConfigurableProperty", values);
		g_once_init_leave (&configurable_property_type_id__volatile, configurable_property_type_id);
	}
	return configurable_property_type_id__volatile;
}


gchar* configuration_engine_get_name (ConfigurationEngine* self) {
#line 322 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), NULL);
#line 322 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_name (self);
#line 1695 "ConfigurationInterfaces.c"
}


gint configuration_engine_get_int_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error) {
#line 324 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0);
#line 324 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_int_property (self, p, error);
#line 1704 "ConfigurationInterfaces.c"
}


void configuration_engine_set_int_property (ConfigurationEngine* self, ConfigurableProperty p, gint val, GError** error) {
#line 325 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 325 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_int_property (self, p, val, error);
#line 1713 "ConfigurationInterfaces.c"
}


gint configuration_engine_get_enum_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error) {
#line 327 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0);
#line 327 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_enum_property (self, p, error);
#line 1722 "ConfigurationInterfaces.c"
}


void configuration_engine_set_enum_property (ConfigurationEngine* self, ConfigurableProperty p, gint val, GError** error) {
#line 328 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 328 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_enum_property (self, p, val, error);
#line 1731 "ConfigurationInterfaces.c"
}


gchar* configuration_engine_get_string_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error) {
#line 330 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), NULL);
#line 330 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_string_property (self, p, error);
#line 1740 "ConfigurationInterfaces.c"
}


void configuration_engine_set_string_property (ConfigurationEngine* self, ConfigurableProperty p, const gchar* val, GError** error) {
#line 331 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 331 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_string_property (self, p, val, error);
#line 1749 "ConfigurationInterfaces.c"
}


gboolean configuration_engine_get_bool_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error) {
#line 333 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), FALSE);
#line 333 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_bool_property (self, p, error);
#line 1758 "ConfigurationInterfaces.c"
}


void configuration_engine_set_bool_property (ConfigurationEngine* self, ConfigurableProperty p, gboolean val, GError** error) {
#line 334 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 334 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_bool_property (self, p, val, error);
#line 1767 "ConfigurationInterfaces.c"
}


gdouble configuration_engine_get_double_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error) {
#line 336 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0.0);
#line 336 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_double_property (self, p, error);
#line 1776 "ConfigurationInterfaces.c"
}


void configuration_engine_set_double_property (ConfigurationEngine* self, ConfigurableProperty p, gdouble val, GError** error) {
#line 337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_double_property (self, p, val, error);
#line 1785 "ConfigurationInterfaces.c"
}


gboolean configuration_engine_get_plugin_bool (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def) {
#line 339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), FALSE);
#line 339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_plugin_bool (self, domain, id, key, def);
#line 1794 "ConfigurationInterfaces.c"
}


void configuration_engine_set_plugin_bool (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val) {
#line 340 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 340 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_plugin_bool (self, domain, id, key, val);
#line 1803 "ConfigurationInterfaces.c"
}


gdouble configuration_engine_get_plugin_double (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def) {
#line 341 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0.0);
#line 341 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_plugin_double (self, domain, id, key, def);
#line 1812 "ConfigurationInterfaces.c"
}


void configuration_engine_set_plugin_double (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val) {
#line 342 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 342 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_plugin_double (self, domain, id, key, val);
#line 1821 "ConfigurationInterfaces.c"
}


gint configuration_engine_get_plugin_int (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint def) {
#line 343 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0);
#line 343 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_plugin_int (self, domain, id, key, def);
#line 1830 "ConfigurationInterfaces.c"
}


void configuration_engine_set_plugin_int (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint val) {
#line 344 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 344 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_plugin_int (self, domain, id, key, val);
#line 1839 "ConfigurationInterfaces.c"
}


gchar* configuration_engine_get_plugin_string (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def) {
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), NULL);
#line 345 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_plugin_string (self, domain, id, key, def);
#line 1848 "ConfigurationInterfaces.c"
}


void configuration_engine_set_plugin_string (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val) {
#line 346 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 346 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_plugin_string (self, domain, id, key, val);
#line 1857 "ConfigurationInterfaces.c"
}


void configuration_engine_unset_plugin_key (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key) {
#line 347 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 347 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->unset_plugin_key (self, domain, id, key);
#line 1866 "ConfigurationInterfaces.c"
}


FuzzyPropertyState configuration_engine_is_plugin_enabled (ConfigurationEngine* self, const gchar* id) {
#line 349 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0);
#line 349 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->is_plugin_enabled (self, id);
#line 1875 "ConfigurationInterfaces.c"
}


void configuration_engine_set_plugin_enabled (ConfigurationEngine* self, const gchar* id, gboolean enabled) {
#line 350 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 350 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_plugin_enabled (self, id, enabled);
#line 1884 "ConfigurationInterfaces.c"
}


static void configuration_engine_base_init (ConfigurationEngineIface * iface) {
#line 319 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	static gboolean initialized = FALSE;
#line 319 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (!initialized) {
#line 319 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		initialized = TRUE;
#line 319 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_signals[CONFIGURATION_ENGINE_PROPERTY_CHANGED_SIGNAL] = g_signal_new ("property-changed", TYPE_CONFIGURATION_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, TYPE_CONFIGURABLE_PROPERTY);
#line 1897 "ConfigurationInterfaces.c"
	}
}


GType configuration_engine_get_type (void) {
	static volatile gsize configuration_engine_type_id__volatile = 0;
	if (g_once_init_enter (&configuration_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ConfigurationEngineIface), (GBaseInitFunc) configuration_engine_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType configuration_engine_type_id;
		configuration_engine_type_id = g_type_register_static (G_TYPE_INTERFACE, "ConfigurationEngine", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (configuration_engine_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&configuration_engine_type_id__volatile, configuration_engine_type_id);
	}
	return configuration_engine_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 366 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return self ? g_object_ref (self) : NULL;
#line 1918 "ConfigurationInterfaces.c"
}


static void _configuration_facade_on_property_changed_configuration_engine_property_changed (ConfigurationEngine* _sender, ConfigurableProperty p, gpointer self) {
#line 368 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_facade_on_property_changed ((ConfigurationFacade*) self, p);
#line 1925 "ConfigurationInterfaces.c"
}


ConfigurationFacade* configuration_facade_construct (GType object_type, ConfigurationEngine* engine) {
	ConfigurationFacade * self = NULL;
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	ConfigurationEngine* _tmp2_;
#line 365 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (engine), NULL);
#line 365 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	self = (ConfigurationFacade*) g_object_new (object_type, NULL);
#line 366 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = engine;
#line 366 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 366 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (self->priv->engine);
#line 366 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	self->priv->engine = _tmp1_;
#line 368 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = engine;
#line 368 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_signal_connect_object (_tmp2_, "property-changed", (GCallback) _configuration_facade_on_property_changed_configuration_engine_property_changed, self, 0);
#line 365 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return self;
#line 1952 "ConfigurationInterfaces.c"
}


static void configuration_facade_on_property_changed (ConfigurationFacade* self, ConfigurableProperty p) {
	ConfigurableProperty _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ConfigurableProperty _tmp3_;
#line 371 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 372 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = p;
#line 372 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = configurable_property_to_string (_tmp0_);
#line 372 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = _tmp1_;
#line 372 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_debug ("ConfigurationInterfaces.vala:372: ConfigurationFacade: engine reports " \
"property '%s' changed.", _tmp2_);
#line 372 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_free0 (_tmp2_);
#line 374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = p;
#line 374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	switch (_tmp3_) {
#line 374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY:
#line 1979 "ConfigurationInterfaces.c"
		{
#line 376 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit (self, configuration_facade_signals[CONFIGURATION_FACADE_AUTO_IMPORT_FROM_LIBRARY_CHANGED_SIGNAL], 0);
#line 377 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 1985 "ConfigurationInterfaces.c"
		}
#line 374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_BG_COLOR_NAME:
#line 1989 "ConfigurationInterfaces.c"
		{
#line 380 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit (self, configuration_facade_signals[CONFIGURATION_FACADE_BG_COLOR_NAME_CHANGED_SIGNAL], 0);
#line 381 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 1995 "ConfigurationInterfaces.c"
		}
#line 374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_TYPE:
#line 1999 "ConfigurationInterfaces.c"
		{
#line 384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit (self, configuration_facade_signals[CONFIGURATION_FACADE_TRANSPARENT_BACKGROUND_TYPE_CHANGED_SIGNAL], 0);
#line 385 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 2005 "ConfigurationInterfaces.c"
		}
#line 374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_COLOR:
#line 2009 "ConfigurationInterfaces.c"
		{
#line 388 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit (self, configuration_facade_signals[CONFIGURATION_FACADE_TRANSPARENT_BACKGROUND_COLOR_CHANGED_SIGNAL], 0);
#line 389 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 2015 "ConfigurationInterfaces.c"
		}
#line 374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS:
#line 2019 "ConfigurationInterfaces.c"
		{
#line 392 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit (self, configuration_facade_signals[CONFIGURATION_FACADE_COMMIT_METADATA_TO_MASTERS_CHANGED_SIGNAL], 0);
#line 393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 2025 "ConfigurationInterfaces.c"
		}
#line 374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING:
#line 2029 "ConfigurationInterfaces.c"
		{
#line 396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit (self, configuration_facade_signals[CONFIGURATION_FACADE_EVENTS_SORT_ASCENDING_CHANGED_SIGNAL], 0);
#line 397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 2035 "ConfigurationInterfaces.c"
		}
#line 374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP:
#line 374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP:
#line 2041 "ConfigurationInterfaces.c"
		{
#line 401 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit (self, configuration_facade_signals[CONFIGURATION_FACADE_EXTERNAL_APP_CHANGED_SIGNAL], 0);
#line 402 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 2047 "ConfigurationInterfaces.c"
		}
#line 374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_IMPORT_DIR:
#line 2051 "ConfigurationInterfaces.c"
		{
#line 405 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit (self, configuration_facade_signals[CONFIGURATION_FACADE_IMPORT_DIRECTORY_CHANGED_SIGNAL], 0);
#line 406 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 2057 "ConfigurationInterfaces.c"
		}
		default:
#line 374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		break;
#line 2062 "ConfigurationInterfaces.c"
	}
}


ConfigurationEngine* configuration_facade_get_engine (ConfigurationFacade* self) {
	ConfigurationEngine* result = NULL;
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
#line 410 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = self->priv->engine;
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp1_;
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 2081 "ConfigurationInterfaces.c"
}


void configuration_facade_on_configuration_error (ConfigurationFacade* self, GError* err) {
	GError* _tmp0_;
#line 414 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = err;
#line 415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (g_error_matches (_tmp0_, CONFIGURATION_ERROR, CONFIGURATION_ERROR_PROPERTY_HAS_NO_VALUE)) {
#line 2093 "ConfigurationInterfaces.c"
		ConfigurationEngine* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 416 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = self->priv->engine;
#line 416 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = configuration_engine_get_name (_tmp1_);
#line 416 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = _tmp2_;
#line 416 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = err;
#line 416 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp4_->message;
#line 416 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_message ("ConfigurationInterfaces.vala:416: configuration engine '%s' reports PR" \
"OPERTY_HAS_NO_VALUE error: %s", _tmp3_, _tmp5_);
#line 416 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp3_);
#line 2113 "ConfigurationInterfaces.c"
	} else {
		GError* _tmp6_;
#line 419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (g_error_matches (_tmp6_, CONFIGURATION_ERROR, CONFIGURATION_ERROR_ENGINE_ERROR)) {
#line 2120 "ConfigurationInterfaces.c"
			ConfigurationEngine* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			GError* _tmp10_;
			const gchar* _tmp11_;
#line 420 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp7_ = self->priv->engine;
#line 420 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp8_ = configuration_engine_get_name (_tmp7_);
#line 420 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp9_ = _tmp8_;
#line 420 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp10_ = err;
#line 420 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp11_ = _tmp10_->message;
#line 420 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("ConfigurationInterfaces.vala:420: configuration engine '%s' reports EN" \
"GINE_ERROR: %s", _tmp9_, _tmp11_);
#line 420 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_g_free0 (_tmp9_);
#line 2140 "ConfigurationInterfaces.c"
		} else {
			ConfigurationEngine* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			GError* _tmp15_;
			const gchar* _tmp16_;
#line 423 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp12_ = self->priv->engine;
#line 423 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp13_ = configuration_engine_get_name (_tmp12_);
#line 423 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp14_ = _tmp13_;
#line 423 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp15_ = err;
#line 423 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp16_ = _tmp15_->message;
#line 423 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("ConfigurationInterfaces.vala:423: configuration engine '%s' reports un" \
"known error: %s", _tmp14_, _tmp16_);
#line 423 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_g_free0 (_tmp14_);
#line 2161 "ConfigurationInterfaces.c"
		}
	}
}


static gboolean configuration_facade_real_get_auto_import_from_library (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY, &_inner_error_);
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2191 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2195 "ConfigurationInterfaces.c"
				goto __catch87_configuration_error;
			}
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 2204 "ConfigurationInterfaces.c"
		}
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2210 "ConfigurationInterfaces.c"
	}
	goto __finally87;
	__catch87_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 432 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 432 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 435 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 435 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 437 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 437 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 437 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2231 "ConfigurationInterfaces.c"
	}
	__finally87:
#line 432 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 432 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 432 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 2240 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_auto_import_from_library (ConfigurationFacade* self) {
#line 431 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 431 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_auto_import_from_library (self);
#line 2249 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_auto_import_from_library (ConfigurationFacade* self, gboolean auto_import) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = auto_import;
#line 443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY, _tmp2_, &_inner_error_);
#line 443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2273 "ConfigurationInterfaces.c"
				goto __catch88_configuration_error;
			}
#line 443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2282 "ConfigurationInterfaces.c"
		}
	}
	goto __finally88;
	__catch88_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 442 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 442 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 446 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 446 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 447 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 447 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2302 "ConfigurationInterfaces.c"
	}
	__finally88:
#line 442 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 442 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 442 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 442 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2313 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_auto_import_from_library (ConfigurationFacade* self, gboolean auto_import) {
#line 441 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 441 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_auto_import_from_library (self, auto_import);
#line 2323 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_bg_color_name (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_BG_COLOR_NAME, &_inner_error_);
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2353 "ConfigurationInterfaces.c"
				goto __catch89_configuration_error;
			}
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 2362 "ConfigurationInterfaces.c"
		}
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2374 "ConfigurationInterfaces.c"
	}
	goto __finally89;
	__catch89_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 455 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 455 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 458 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 458 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2398 "ConfigurationInterfaces.c"
	}
	__finally89:
#line 455 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 455 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 455 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 2407 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_bg_color_name (ConfigurationFacade* self) {
#line 454 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 454 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_bg_color_name (self);
#line 2416 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_bg_color_name (ConfigurationFacade* self, const gchar* color_name) {
	GError * _inner_error_ = NULL;
#line 464 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (color_name != NULL);
#line 2424 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
#line 466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = color_name;
#line 466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_BG_COLOR_NAME, _tmp2_, &_inner_error_);
#line 466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2443 "ConfigurationInterfaces.c"
				goto __catch90_configuration_error;
			}
#line 466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2452 "ConfigurationInterfaces.c"
		}
	}
	goto __finally90;
	__catch90_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 465 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 465 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 469 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 469 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2472 "ConfigurationInterfaces.c"
	}
	__finally90:
#line 465 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 465 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 465 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 465 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2483 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_bg_color_name (ConfigurationFacade* self, const gchar* color_name) {
#line 464 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 464 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_bg_color_name (self, color_name);
#line 2493 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_transparent_background_type (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_TYPE, &_inner_error_);
#line 478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2523 "ConfigurationInterfaces.c"
				goto __catch91_configuration_error;
			}
#line 478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 2532 "ConfigurationInterfaces.c"
		}
#line 478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2544 "ConfigurationInterfaces.c"
	}
	goto __finally91;
	__catch91_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 477 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 477 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 482 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("checkered");
#line 482 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 482 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 482 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2568 "ConfigurationInterfaces.c"
	}
	__finally91:
#line 477 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 477 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 477 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 2577 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_transparent_background_type (ConfigurationFacade* self) {
#line 476 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 476 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_transparent_background_type (self);
#line 2586 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_transparent_background_type (ConfigurationFacade* self, const gchar* type) {
	GError * _inner_error_ = NULL;
#line 486 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (type != NULL);
#line 2594 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
#line 488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = type;
#line 488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_TYPE, _tmp2_, &_inner_error_);
#line 488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2613 "ConfigurationInterfaces.c"
				goto __catch92_configuration_error;
			}
#line 488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2622 "ConfigurationInterfaces.c"
		}
	}
	goto __finally92;
	__catch92_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 487 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 487 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 490 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 490 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 491 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 491 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2642 "ConfigurationInterfaces.c"
	}
	__finally92:
#line 487 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 487 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 487 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 487 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2653 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_transparent_background_type (ConfigurationFacade* self, const gchar* type) {
#line 486 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 486 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_transparent_background_type (self, type);
#line 2663 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_transparent_background_color (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_COLOR, &_inner_error_);
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2693 "ConfigurationInterfaces.c"
				goto __catch93_configuration_error;
			}
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 2702 "ConfigurationInterfaces.c"
		}
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2714 "ConfigurationInterfaces.c"
	}
	goto __finally93;
	__catch93_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 499 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 499 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 502 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 502 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("#444");
#line 504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2738 "ConfigurationInterfaces.c"
	}
	__finally93:
#line 499 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 499 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 499 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 2747 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_transparent_background_color (ConfigurationFacade* self) {
#line 498 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 498 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_transparent_background_color (self);
#line 2756 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_transparent_background_color (ConfigurationFacade* self, const gchar* color_name) {
	GError * _inner_error_ = NULL;
#line 508 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (color_name != NULL);
#line 2764 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
#line 510 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 510 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 510 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = color_name;
#line 510 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_TRANSPARENT_BACKGROUND_COLOR, _tmp2_, &_inner_error_);
#line 510 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 510 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 510 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2783 "ConfigurationInterfaces.c"
				goto __catch94_configuration_error;
			}
#line 510 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 510 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 510 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2792 "ConfigurationInterfaces.c"
		}
	}
	goto __finally94;
	__catch94_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 509 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 509 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 512 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 512 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 513 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 513 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2812 "ConfigurationInterfaces.c"
	}
	__finally94:
#line 509 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 509 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 509 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 509 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2823 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_transparent_background_color (ConfigurationFacade* self, const gchar* color_name) {
#line 508 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 508 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_transparent_background_color (self, color_name);
#line 2833 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_commit_metadata_to_masters (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 522 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 522 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 522 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS, &_inner_error_);
#line 522 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 522 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 522 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 522 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2861 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 522 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2865 "ConfigurationInterfaces.c"
				goto __catch95_configuration_error;
			}
#line 522 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 522 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 522 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 2874 "ConfigurationInterfaces.c"
		}
#line 522 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 522 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2880 "ConfigurationInterfaces.c"
	}
	goto __finally95;
	__catch95_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 521 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 521 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 524 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 524 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 526 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 526 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 526 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2901 "ConfigurationInterfaces.c"
	}
	__finally95:
#line 521 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 521 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 521 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 2910 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_commit_metadata_to_masters (ConfigurationFacade* self) {
#line 520 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 520 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_commit_metadata_to_masters (self);
#line 2919 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_commit_metadata_to_masters (ConfigurationFacade* self, gboolean commit_metadata) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = commit_metadata;
#line 532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS, _tmp2_, &_inner_error_);
#line 532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2943 "ConfigurationInterfaces.c"
				goto __catch96_configuration_error;
			}
#line 532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 532 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2952 "ConfigurationInterfaces.c"
		}
	}
	goto __finally96;
	__catch96_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 535 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 535 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2972 "ConfigurationInterfaces.c"
	}
	__finally96:
#line 531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2983 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_commit_metadata_to_masters (ConfigurationFacade* self, gboolean commit_metadata) {
#line 530 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 530 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_commit_metadata_to_masters (self, commit_metadata);
#line 2993 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_desktop_background (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE, &_inner_error_);
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3023 "ConfigurationInterfaces.c"
				goto __catch97_configuration_error;
			}
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 3032 "ConfigurationInterfaces.c"
		}
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3044 "ConfigurationInterfaces.c"
	}
	goto __finally97;
	__catch97_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 544 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 544 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 547 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 547 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3068 "ConfigurationInterfaces.c"
	}
	__finally97:
#line 544 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 544 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 544 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 3077 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_desktop_background (ConfigurationFacade* self) {
#line 543 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 543 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_desktop_background (self);
#line 3086 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_desktop_background (ConfigurationFacade* self, const gchar* filename) {
	GError * _inner_error_ = NULL;
#line 553 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (filename != NULL);
#line 3094 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
		ConfigurationEngine* _tmp3_;
		ConfigurationEngine* _tmp4_;
#line 555 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 555 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 555 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = filename;
#line 555 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE, _tmp2_, &_inner_error_);
#line 555 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 555 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 555 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3115 "ConfigurationInterfaces.c"
				goto __catch98_configuration_error;
			}
#line 555 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 555 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 555 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3124 "ConfigurationInterfaces.c"
		}
#line 557 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 557 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 557 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp4_, CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE, "zoom", &_inner_error_);
#line 557 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 557 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 557 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3138 "ConfigurationInterfaces.c"
				goto __catch98_configuration_error;
			}
#line 557 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 557 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 557 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3147 "ConfigurationInterfaces.c"
		}
	}
	goto __finally98;
	__catch98_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
#line 554 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 554 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 554 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3165 "ConfigurationInterfaces.c"
	}
	__finally98:
#line 554 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 554 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 554 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 554 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 3176 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_desktop_background (ConfigurationFacade* self, const gchar* filename) {
#line 553 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 553 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_desktop_background (self, filename);
#line 3186 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_screensaver (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 569 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 569 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 569 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_SCREENSAVER_FILE, &_inner_error_);
#line 569 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 569 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 569 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 569 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 569 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3216 "ConfigurationInterfaces.c"
				goto __catch99_configuration_error;
			}
#line 569 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 569 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 569 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 3225 "ConfigurationInterfaces.c"
		}
#line 569 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 569 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 569 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 569 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 569 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3237 "ConfigurationInterfaces.c"
	}
	goto __finally99;
	__catch99_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 568 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 568 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 571 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 571 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 573 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 573 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 573 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 573 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3261 "ConfigurationInterfaces.c"
	}
	__finally99:
#line 568 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 568 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 568 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 3270 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_screensaver (ConfigurationFacade* self) {
#line 567 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 567 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_screensaver (self);
#line 3279 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_screensaver (ConfigurationFacade* self, const gchar* filename) {
	GError * _inner_error_ = NULL;
#line 577 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (filename != NULL);
#line 3287 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
		ConfigurationEngine* _tmp3_;
		ConfigurationEngine* _tmp4_;
#line 579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = filename;
#line 579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_SCREENSAVER_FILE, _tmp2_, &_inner_error_);
#line 579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3308 "ConfigurationInterfaces.c"
				goto __catch100_configuration_error;
			}
#line 579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3317 "ConfigurationInterfaces.c"
		}
#line 581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp4_, CONFIGURABLE_PROPERTY_SCREENSAVER_MODE, "zoom", &_inner_error_);
#line 581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3331 "ConfigurationInterfaces.c"
				goto __catch100_configuration_error;
			}
#line 581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3340 "ConfigurationInterfaces.c"
		}
	}
	goto __finally100;
	__catch100_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 584 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 584 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3358 "ConfigurationInterfaces.c"
	}
	__finally100:
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 3369 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_screensaver (ConfigurationFacade* self, const gchar* filename) {
#line 577 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 577 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_screensaver (self, filename);
#line 3379 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_directory_pattern (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* s = NULL;
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = configuration_engine_get_string_property (_tmp1_, CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN, &_inner_error_);
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = _tmp2_;
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		s = _tmp3_;
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3410 "ConfigurationInterfaces.c"
				goto __catch101_configuration_error;
			}
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 3419 "ConfigurationInterfaces.c"
		}
#line 594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (g_strcmp0 (s, "") == 0) {
#line 594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp4_ = NULL;
#line 3425 "ConfigurationInterfaces.c"
		} else {
#line 594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp4_ = s;
#line 3429 "ConfigurationInterfaces.c"
		}
#line 594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (s);
#line 594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3439 "ConfigurationInterfaces.c"
	}
	goto __finally101;
	__catch101_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 592 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 592 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 598 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 598 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 598 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 598 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3463 "ConfigurationInterfaces.c"
	}
	__finally101:
#line 592 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 592 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 592 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 3472 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_directory_pattern (ConfigurationFacade* self) {
#line 591 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 591 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_directory_pattern (self);
#line 3481 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_directory_pattern (ConfigurationFacade* self, const gchar* s) {
	GError * _inner_error_ = NULL;
	{
		const gchar* _tmp0_;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		const gchar* _tmp3_;
#line 604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = s;
#line 604 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (_tmp0_ == NULL) {
#line 605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			s = "";
#line 3498 "ConfigurationInterfaces.c"
		}
#line 607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = s;
#line 607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp2_, CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN, _tmp3_, &_inner_error_);
#line 607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3514 "ConfigurationInterfaces.c"
				goto __catch102_configuration_error;
			}
#line 607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3523 "ConfigurationInterfaces.c"
		}
	}
	goto __finally102;
	__catch102_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
#line 603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 609 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = err;
#line 609 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp4_);
#line 603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3541 "ConfigurationInterfaces.c"
	}
	__finally102:
#line 603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 3552 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_directory_pattern (ConfigurationFacade* self, const gchar* s) {
#line 602 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 602 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_directory_pattern (self, s);
#line 3562 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_directory_pattern_custom (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM, &_inner_error_);
#line 618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3592 "ConfigurationInterfaces.c"
				goto __catch103_configuration_error;
			}
#line 618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 3601 "ConfigurationInterfaces.c"
		}
#line 618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3613 "ConfigurationInterfaces.c"
	}
	goto __finally103;
	__catch103_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 620 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 620 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 622 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 622 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 622 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 622 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3637 "ConfigurationInterfaces.c"
	}
	__finally103:
#line 617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 3646 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_directory_pattern_custom (ConfigurationFacade* self) {
#line 616 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 616 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_directory_pattern_custom (self);
#line 3655 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_directory_pattern_custom (ConfigurationFacade* self, const gchar* s) {
	GError * _inner_error_ = NULL;
#line 626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (s != NULL);
#line 3663 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
#line 628 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 628 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 628 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = s;
#line 628 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM, _tmp2_, &_inner_error_);
#line 628 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 628 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 628 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3682 "ConfigurationInterfaces.c"
				goto __catch104_configuration_error;
			}
#line 628 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 628 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 628 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3691 "ConfigurationInterfaces.c"
		}
	}
	goto __finally104;
	__catch104_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 630 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 630 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3709 "ConfigurationInterfaces.c"
	}
	__finally104:
#line 627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 627 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 3720 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_directory_pattern_custom (ConfigurationFacade* self, const gchar* s) {
#line 626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_directory_pattern_custom (self, s);
#line 3730 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_get_direct_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions) {
	gboolean _vala_maximize = FALSE;
	Dimensions _vala_dimensions = {0};
	GError * _inner_error_ = NULL;
#line 638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_maximize = FALSE;
#line 639 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	dimensions_init (&_vala_dimensions, 1024, 768);
#line 3742 "ConfigurationInterfaces.c"
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		gint w = 0;
		ConfigurationEngine* _tmp5_;
		ConfigurationEngine* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint h = 0;
		ConfigurationEngine* _tmp9_;
		ConfigurationEngine* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
#line 641 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 641 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 641 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE, &_inner_error_);
#line 641 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 641 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 641 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 641 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 641 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3777 "ConfigurationInterfaces.c"
				goto __catch105_configuration_error;
			}
#line 641 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 641 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 641 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3786 "ConfigurationInterfaces.c"
		}
#line 641 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_maximize = _tmp0_;
#line 642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = configuration_facade_get_engine (self);
#line 642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = _tmp5_;
#line 642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = configuration_engine_get_int_property (_tmp6_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH, &_inner_error_);
#line 642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp7_;
#line 642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp6_);
#line 642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		w = _tmp8_;
#line 642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3806 "ConfigurationInterfaces.c"
				goto __catch105_configuration_error;
			}
#line 642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3815 "ConfigurationInterfaces.c"
		}
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = configuration_facade_get_engine (self);
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = _tmp9_;
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp11_ = configuration_engine_get_int_property (_tmp10_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT, &_inner_error_);
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp12_ = _tmp11_;
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp10_);
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		h = _tmp12_;
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3833 "ConfigurationInterfaces.c"
				goto __catch105_configuration_error;
			}
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3842 "ConfigurationInterfaces.c"
		}
#line 644 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp13_ = w;
#line 644 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp14_ = h;
#line 644 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		dimensions_init (&_vala_dimensions, _tmp13_, _tmp14_);
#line 3850 "ConfigurationInterfaces.c"
	}
	goto __finally105;
	__catch105_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp15_;
#line 640 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 640 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 646 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp15_ = err;
#line 646 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp15_);
#line 640 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3867 "ConfigurationInterfaces.c"
	}
	__finally105:
#line 640 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 640 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 640 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 640 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 3878 "ConfigurationInterfaces.c"
	}
#line 637 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (maximize) {
#line 637 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*maximize = _vala_maximize;
#line 3884 "ConfigurationInterfaces.c"
	}
#line 637 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (dimensions) {
#line 637 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*dimensions = _vala_dimensions;
#line 3890 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_get_direct_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions) {
#line 637 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 637 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->get_direct_window_state (self, maximize, dimensions);
#line 3900 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_direct_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions) {
	GError * _inner_error_ = NULL;
#line 650 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (dimensions != NULL);
#line 3908 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
		ConfigurationEngine* _tmp3_;
		ConfigurationEngine* _tmp4_;
		Dimensions _tmp5_;
		gint _tmp6_;
		ConfigurationEngine* _tmp7_;
		ConfigurationEngine* _tmp8_;
		Dimensions _tmp9_;
		gint _tmp10_;
#line 652 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 652 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 652 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = maximize;
#line 652 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE, _tmp2_, &_inner_error_);
#line 652 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 652 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 652 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3935 "ConfigurationInterfaces.c"
				goto __catch106_configuration_error;
			}
#line 652 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 652 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 652 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3944 "ConfigurationInterfaces.c"
		}
#line 653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = *dimensions;
#line 653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = _tmp5_.width;
#line 653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp4_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH, _tmp6_, &_inner_error_);
#line 653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3962 "ConfigurationInterfaces.c"
				goto __catch106_configuration_error;
			}
#line 653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3971 "ConfigurationInterfaces.c"
		}
#line 655 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = configuration_facade_get_engine (self);
#line 655 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp7_;
#line 655 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = *dimensions;
#line 655 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = _tmp9_.height;
#line 655 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp8_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT, _tmp10_, &_inner_error_);
#line 655 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp8_);
#line 655 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 655 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3989 "ConfigurationInterfaces.c"
				goto __catch106_configuration_error;
			}
#line 655 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 655 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 655 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3998 "ConfigurationInterfaces.c"
		}
	}
	goto __finally106;
	__catch106_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp11_;
#line 651 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 651 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp11_ = err;
#line 658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp11_);
#line 651 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4016 "ConfigurationInterfaces.c"
	}
	__finally106:
#line 651 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 651 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 651 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 651 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4027 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_direct_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions) {
#line 650 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 650 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_direct_window_state (self, maximize, dimensions);
#line 4037 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_basic_properties (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 667 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 667 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 667 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES, &_inner_error_);
#line 667 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 667 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 667 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 667 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4065 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 667 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4069 "ConfigurationInterfaces.c"
				goto __catch107_configuration_error;
			}
#line 667 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 667 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 667 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 4078 "ConfigurationInterfaces.c"
		}
#line 667 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 667 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4084 "ConfigurationInterfaces.c"
	}
	goto __finally107;
	__catch107_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 666 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 666 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 669 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 669 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 671 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 671 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 671 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4105 "ConfigurationInterfaces.c"
	}
	__finally107:
#line 666 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 666 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 666 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 4114 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_basic_properties (ConfigurationFacade* self) {
#line 665 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 665 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_basic_properties (self);
#line 4123 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_basic_properties (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 677 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 677 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 677 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 677 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES, _tmp2_, &_inner_error_);
#line 677 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 677 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 677 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4147 "ConfigurationInterfaces.c"
				goto __catch108_configuration_error;
			}
#line 677 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 677 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 677 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4156 "ConfigurationInterfaces.c"
		}
	}
	goto __finally108;
	__catch108_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 676 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 676 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 679 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 679 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 676 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4174 "ConfigurationInterfaces.c"
	}
	__finally108:
#line 676 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 676 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 676 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 676 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4185 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_basic_properties (ConfigurationFacade* self, gboolean display) {
#line 675 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 675 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_basic_properties (self, display);
#line 4195 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_extended_properties (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 688 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 688 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 688 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES, &_inner_error_);
#line 688 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 688 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 688 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 688 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4223 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 688 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4227 "ConfigurationInterfaces.c"
				goto __catch109_configuration_error;
			}
#line 688 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 688 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 688 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 4236 "ConfigurationInterfaces.c"
		}
#line 688 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 688 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4242 "ConfigurationInterfaces.c"
	}
	goto __finally109;
	__catch109_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 687 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 687 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 690 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 690 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 692 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 692 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 692 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4263 "ConfigurationInterfaces.c"
	}
	__finally109:
#line 687 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 687 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 687 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 4272 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_extended_properties (ConfigurationFacade* self) {
#line 686 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 686 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_extended_properties (self);
#line 4281 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_extended_properties (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 698 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 698 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 698 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 698 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES, _tmp2_, &_inner_error_);
#line 698 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 698 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 698 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4305 "ConfigurationInterfaces.c"
				goto __catch110_configuration_error;
			}
#line 698 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 698 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 698 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4314 "ConfigurationInterfaces.c"
		}
	}
	goto __finally110;
	__catch110_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 697 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 697 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 697 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4332 "ConfigurationInterfaces.c"
	}
	__finally110:
#line 697 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 697 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 697 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 697 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4343 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_extended_properties (ConfigurationFacade* self, gboolean display) {
#line 696 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 696 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_extended_properties (self, display);
#line 4353 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_sidebar (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR, &_inner_error_);
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4381 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4385 "ConfigurationInterfaces.c"
				goto __catch111_configuration_error;
			}
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 4394 "ConfigurationInterfaces.c"
		}
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4400 "ConfigurationInterfaces.c"
	}
	goto __finally111;
	__catch111_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 709 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 709 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 712 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 712 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 714 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 714 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 714 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4421 "ConfigurationInterfaces.c"
	}
	__finally111:
#line 709 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 709 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 709 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 4430 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_sidebar (ConfigurationFacade* self) {
#line 708 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 708 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_sidebar (self);
#line 4439 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_sidebar (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 720 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 720 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 720 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 720 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR, _tmp2_, &_inner_error_);
#line 720 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 720 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 720 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4463 "ConfigurationInterfaces.c"
				goto __catch112_configuration_error;
			}
#line 720 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 720 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 720 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4472 "ConfigurationInterfaces.c"
		}
	}
	goto __finally112;
	__catch112_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 719 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 719 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 722 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 719 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4490 "ConfigurationInterfaces.c"
	}
	__finally112:
#line 719 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 719 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 719 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 719 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4501 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_sidebar (ConfigurationFacade* self, gboolean display) {
#line 718 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 718 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_sidebar (self, display);
#line 4511 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_toolbar (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR, &_inner_error_);
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4539 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4543 "ConfigurationInterfaces.c"
				goto __catch113_configuration_error;
			}
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 4552 "ConfigurationInterfaces.c"
		}
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4558 "ConfigurationInterfaces.c"
	}
	goto __finally113;
	__catch113_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 731 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 731 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 734 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 734 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 736 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 736 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 736 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4579 "ConfigurationInterfaces.c"
	}
	__finally113:
#line 731 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 731 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 731 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 4588 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_toolbar (ConfigurationFacade* self) {
#line 730 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 730 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_toolbar (self);
#line 4597 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_toolbar (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 742 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 742 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 742 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 742 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR, _tmp2_, &_inner_error_);
#line 742 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 742 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 742 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4621 "ConfigurationInterfaces.c"
				goto __catch114_configuration_error;
			}
#line 742 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 742 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 742 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4630 "ConfigurationInterfaces.c"
		}
	}
	goto __finally114;
	__catch114_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 741 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 741 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 744 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 744 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 741 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4648 "ConfigurationInterfaces.c"
	}
	__finally114:
#line 741 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 741 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 741 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 741 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4659 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_toolbar (ConfigurationFacade* self, gboolean display) {
#line 740 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 740 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_toolbar (self, display);
#line 4669 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_search_bar (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR, &_inner_error_);
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4697 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4701 "ConfigurationInterfaces.c"
				goto __catch115_configuration_error;
			}
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 4710 "ConfigurationInterfaces.c"
		}
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 753 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4716 "ConfigurationInterfaces.c"
	}
	goto __finally115;
	__catch115_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 752 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 752 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 755 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 755 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 757 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 757 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 757 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4737 "ConfigurationInterfaces.c"
	}
	__finally115:
#line 752 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 752 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 752 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 4746 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_search_bar (ConfigurationFacade* self) {
#line 751 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 751 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_search_bar (self);
#line 4755 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_search_bar (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 763 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 763 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 763 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 763 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR, _tmp2_, &_inner_error_);
#line 763 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 763 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 763 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4779 "ConfigurationInterfaces.c"
				goto __catch116_configuration_error;
			}
#line 763 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 763 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 763 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4788 "ConfigurationInterfaces.c"
		}
	}
	goto __finally116;
	__catch116_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 762 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 762 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 765 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 765 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 762 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4806 "ConfigurationInterfaces.c"
	}
	__finally116:
#line 762 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 762 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 762 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 762 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4817 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_search_bar (ConfigurationFacade* self, gboolean display) {
#line 761 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 761 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_search_bar (self, display);
#line 4827 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_photo_ratings (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS, &_inner_error_);
#line 774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4855 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4859 "ConfigurationInterfaces.c"
				goto __catch117_configuration_error;
			}
#line 774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 4868 "ConfigurationInterfaces.c"
		}
#line 774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 774 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4874 "ConfigurationInterfaces.c"
	}
	goto __finally117;
	__catch117_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 773 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 773 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 776 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 776 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4895 "ConfigurationInterfaces.c"
	}
	__finally117:
#line 773 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 773 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 773 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 4904 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_photo_ratings (ConfigurationFacade* self) {
#line 772 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 772 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_photo_ratings (self);
#line 4913 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_photo_ratings (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 784 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 784 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 784 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 784 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS, _tmp2_, &_inner_error_);
#line 784 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 784 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 784 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4937 "ConfigurationInterfaces.c"
				goto __catch118_configuration_error;
			}
#line 784 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 784 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 784 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4946 "ConfigurationInterfaces.c"
		}
	}
	goto __finally118;
	__catch118_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 783 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 783 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 786 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 786 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 783 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4964 "ConfigurationInterfaces.c"
	}
	__finally118:
#line 783 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 783 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 783 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 783 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4975 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_photo_ratings (ConfigurationFacade* self, gboolean display) {
#line 782 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 782 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_photo_ratings (self, display);
#line 4985 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_photo_tags (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS, &_inner_error_);
#line 795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5013 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5017 "ConfigurationInterfaces.c"
				goto __catch119_configuration_error;
			}
#line 795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 5026 "ConfigurationInterfaces.c"
		}
#line 795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 795 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5032 "ConfigurationInterfaces.c"
	}
	goto __finally119;
	__catch119_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 797 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 797 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 799 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 799 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 799 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5053 "ConfigurationInterfaces.c"
	}
	__finally119:
#line 794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 5062 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_photo_tags (ConfigurationFacade* self) {
#line 793 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 793 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_photo_tags (self);
#line 5071 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_photo_tags (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 805 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 805 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 805 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 805 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS, _tmp2_, &_inner_error_);
#line 805 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 805 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 805 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5095 "ConfigurationInterfaces.c"
				goto __catch120_configuration_error;
			}
#line 805 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 805 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 805 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5104 "ConfigurationInterfaces.c"
		}
	}
	goto __finally120;
	__catch120_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 804 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 804 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 807 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 807 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 804 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 5122 "ConfigurationInterfaces.c"
	}
	__finally120:
#line 804 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 804 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 804 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 804 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5133 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_photo_tags (ConfigurationFacade* self, gboolean display) {
#line 803 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 803 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_photo_tags (self, display);
#line 5143 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_photo_titles (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES, &_inner_error_);
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5171 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5175 "ConfigurationInterfaces.c"
				goto __catch121_configuration_error;
			}
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 5184 "ConfigurationInterfaces.c"
		}
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5190 "ConfigurationInterfaces.c"
	}
	goto __finally121;
	__catch121_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 815 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 815 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 818 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 818 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 820 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 820 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 820 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5211 "ConfigurationInterfaces.c"
	}
	__finally121:
#line 815 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 815 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 815 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 5220 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_photo_titles (ConfigurationFacade* self) {
#line 814 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 814 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_photo_titles (self);
#line 5229 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_photo_titles (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 826 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 826 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 826 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 826 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES, _tmp2_, &_inner_error_);
#line 826 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 826 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 826 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5253 "ConfigurationInterfaces.c"
				goto __catch122_configuration_error;
			}
#line 826 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 826 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 826 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5262 "ConfigurationInterfaces.c"
		}
	}
	goto __finally122;
	__catch122_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 825 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 825 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 828 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 828 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 825 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 5280 "ConfigurationInterfaces.c"
	}
	__finally122:
#line 825 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 825 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 825 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 825 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5291 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_photo_titles (ConfigurationFacade* self, gboolean display) {
#line 824 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 824 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_photo_titles (self, display);
#line 5301 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_photo_comments (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS, &_inner_error_);
#line 837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5329 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5333 "ConfigurationInterfaces.c"
				goto __catch123_configuration_error;
			}
#line 837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 5342 "ConfigurationInterfaces.c"
		}
#line 837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5348 "ConfigurationInterfaces.c"
	}
	goto __finally123;
	__catch123_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 836 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 836 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 839 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 839 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 841 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 841 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 841 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5369 "ConfigurationInterfaces.c"
	}
	__finally123:
#line 836 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 836 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 836 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 5378 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_photo_comments (ConfigurationFacade* self) {
#line 835 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 835 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_photo_comments (self);
#line 5387 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_photo_comments (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 847 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 847 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 847 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 847 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS, _tmp2_, &_inner_error_);
#line 847 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 847 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 847 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5411 "ConfigurationInterfaces.c"
				goto __catch124_configuration_error;
			}
#line 847 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 847 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 847 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5420 "ConfigurationInterfaces.c"
		}
	}
	goto __finally124;
	__catch124_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 846 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 846 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 849 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 849 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 846 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 5438 "ConfigurationInterfaces.c"
	}
	__finally124:
#line 846 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 846 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 846 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 846 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5449 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_photo_comments (ConfigurationFacade* self, gboolean display) {
#line 845 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 845 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_photo_comments (self, display);
#line 5459 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_event_comments (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS, &_inner_error_);
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5487 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5491 "ConfigurationInterfaces.c"
				goto __catch125_configuration_error;
			}
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 5500 "ConfigurationInterfaces.c"
		}
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5506 "ConfigurationInterfaces.c"
	}
	goto __finally125;
	__catch125_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 857 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 857 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 860 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 860 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 862 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 862 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 862 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5527 "ConfigurationInterfaces.c"
	}
	__finally125:
#line 857 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 857 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 857 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 5536 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_event_comments (ConfigurationFacade* self) {
#line 856 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 856 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_event_comments (self);
#line 5545 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_event_comments (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 868 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 868 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 868 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 868 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS, _tmp2_, &_inner_error_);
#line 868 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 868 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 868 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5569 "ConfigurationInterfaces.c"
				goto __catch126_configuration_error;
			}
#line 868 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 868 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 868 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5578 "ConfigurationInterfaces.c"
		}
	}
	goto __finally126;
	__catch126_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 867 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 867 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 870 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 870 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 867 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 5596 "ConfigurationInterfaces.c"
	}
	__finally126:
#line 867 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 867 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 867 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 867 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5607 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_event_comments (ConfigurationFacade* self, gboolean display) {
#line 866 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 866 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_event_comments (self, display);
#line 5617 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_get_event_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by) {
	gboolean _vala_sort_order = FALSE;
	gint _vala_sort_by = 0;
	GError * _inner_error_ = NULL;
#line 878 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_sort_order = FALSE;
#line 879 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_sort_by = 2;
#line 5629 "ConfigurationInterfaces.c"
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		gint _tmp5_ = 0;
		ConfigurationEngine* _tmp6_;
		ConfigurationEngine* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
#line 881 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 881 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 881 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING, &_inner_error_);
#line 881 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 881 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 881 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 881 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 881 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5657 "ConfigurationInterfaces.c"
				goto __catch127_configuration_error;
			}
#line 881 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 881 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 881 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5666 "ConfigurationInterfaces.c"
		}
#line 881 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_sort_order = _tmp0_;
#line 883 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = configuration_facade_get_engine (self);
#line 883 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = _tmp6_;
#line 883 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = configuration_engine_get_int_property (_tmp7_, CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY, &_inner_error_);
#line 883 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = _tmp8_;
#line 883 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp7_);
#line 883 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp9_;
#line 883 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 883 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5686 "ConfigurationInterfaces.c"
				goto __catch127_configuration_error;
			}
#line 883 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 883 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 883 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5695 "ConfigurationInterfaces.c"
		}
#line 883 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_sort_by = _tmp5_;
#line 5699 "ConfigurationInterfaces.c"
	}
	goto __finally127;
	__catch127_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp10_;
#line 880 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 880 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 885 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = err;
#line 885 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp10_);
#line 880 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 5716 "ConfigurationInterfaces.c"
	}
	__finally127:
#line 880 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 880 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 880 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 880 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5727 "ConfigurationInterfaces.c"
	}
#line 877 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (sort_order) {
#line 877 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*sort_order = _vala_sort_order;
#line 5733 "ConfigurationInterfaces.c"
	}
#line 877 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (sort_by) {
#line 877 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*sort_by = _vala_sort_by;
#line 5739 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_get_event_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by) {
#line 877 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 877 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->get_event_photos_sort (self, sort_order, sort_by);
#line 5749 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_event_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
		ConfigurationEngine* _tmp3_;
		ConfigurationEngine* _tmp4_;
		gint _tmp5_;
#line 891 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 891 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 891 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = sort_order;
#line 891 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING, _tmp2_, &_inner_error_);
#line 891 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 891 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 891 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5776 "ConfigurationInterfaces.c"
				goto __catch128_configuration_error;
			}
#line 891 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 891 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 891 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5785 "ConfigurationInterfaces.c"
		}
#line 893 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 893 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 893 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = sort_by;
#line 893 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp4_, CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY, _tmp5_, &_inner_error_);
#line 893 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 893 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 893 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5801 "ConfigurationInterfaces.c"
				goto __catch128_configuration_error;
			}
#line 893 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 893 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 893 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5810 "ConfigurationInterfaces.c"
		}
	}
	goto __finally128;
	__catch128_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 890 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 890 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 896 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 896 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 890 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 5828 "ConfigurationInterfaces.c"
	}
	__finally128:
#line 890 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 890 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 890 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 890 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5839 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_event_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by) {
#line 889 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 889 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_event_photos_sort (self, sort_order, sort_by);
#line 5849 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_events_sort_ascending (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 905 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 905 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 905 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING, &_inner_error_);
#line 905 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 905 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 905 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 905 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5877 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 905 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5881 "ConfigurationInterfaces.c"
				goto __catch129_configuration_error;
			}
#line 905 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 905 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 905 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 5890 "ConfigurationInterfaces.c"
		}
#line 905 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 905 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5896 "ConfigurationInterfaces.c"
	}
	goto __finally129;
	__catch129_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 904 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 904 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 907 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 907 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 909 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 909 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 909 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5917 "ConfigurationInterfaces.c"
	}
	__finally129:
#line 904 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 904 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 904 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 5926 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_events_sort_ascending (ConfigurationFacade* self) {
#line 903 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 903 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_events_sort_ascending (self);
#line 5935 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_events_sort_ascending (ConfigurationFacade* self, gboolean sort) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 915 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 915 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 915 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = sort;
#line 915 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING, _tmp2_, &_inner_error_);
#line 915 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 915 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 915 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5959 "ConfigurationInterfaces.c"
				goto __catch130_configuration_error;
			}
#line 915 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 915 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 915 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5968 "ConfigurationInterfaces.c"
		}
	}
	goto __finally130;
	__catch130_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 914 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 914 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 917 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 917 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 918 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 918 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5988 "ConfigurationInterfaces.c"
	}
	__finally130:
#line 914 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 914 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 914 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 914 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5999 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_events_sort_ascending (ConfigurationFacade* self, gboolean sort) {
#line 913 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 913 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_events_sort_ascending (self, sort);
#line 6009 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_external_photo_app (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 927 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 927 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 927 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP, &_inner_error_);
#line 927 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 927 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 927 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 927 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 927 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6039 "ConfigurationInterfaces.c"
				goto __catch131_configuration_error;
			}
#line 927 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 927 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 927 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 6048 "ConfigurationInterfaces.c"
		}
#line 927 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 927 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 927 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 927 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 927 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6060 "ConfigurationInterfaces.c"
	}
	goto __finally131;
	__catch131_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 926 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 926 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 929 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 929 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 931 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 931 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 931 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 931 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6084 "ConfigurationInterfaces.c"
	}
	__finally131:
#line 926 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 926 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 926 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 6093 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_external_photo_app (ConfigurationFacade* self) {
#line 925 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 925 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_external_photo_app (self);
#line 6102 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_external_photo_app (ConfigurationFacade* self, const gchar* external_photo_app) {
	GError * _inner_error_ = NULL;
#line 935 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (external_photo_app != NULL);
#line 6110 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
#line 937 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 937 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 937 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = external_photo_app;
#line 937 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP, _tmp2_, &_inner_error_);
#line 937 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 937 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 937 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6129 "ConfigurationInterfaces.c"
				goto __catch132_configuration_error;
			}
#line 937 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 937 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 937 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6138 "ConfigurationInterfaces.c"
		}
	}
	goto __finally132;
	__catch132_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 936 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 936 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 940 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 940 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 941 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 941 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6158 "ConfigurationInterfaces.c"
	}
	__finally132:
#line 936 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 936 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 936 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 936 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6169 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_external_photo_app (ConfigurationFacade* self, const gchar* external_photo_app) {
#line 935 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 935 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_external_photo_app (self, external_photo_app);
#line 6179 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_external_raw_app (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP, &_inner_error_);
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6209 "ConfigurationInterfaces.c"
				goto __catch133_configuration_error;
			}
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 6218 "ConfigurationInterfaces.c"
		}
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6230 "ConfigurationInterfaces.c"
	}
	goto __finally133;
	__catch133_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 949 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 949 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 952 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 952 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 954 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 954 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 954 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 954 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6254 "ConfigurationInterfaces.c"
	}
	__finally133:
#line 949 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 949 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 949 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 6263 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_external_raw_app (ConfigurationFacade* self) {
#line 948 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 948 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_external_raw_app (self);
#line 6272 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_external_raw_app (ConfigurationFacade* self, const gchar* external_raw_app) {
	GError * _inner_error_ = NULL;
#line 958 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (external_raw_app != NULL);
#line 6280 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
#line 960 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 960 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 960 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = external_raw_app;
#line 960 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP, _tmp2_, &_inner_error_);
#line 960 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 960 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 960 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6299 "ConfigurationInterfaces.c"
				goto __catch134_configuration_error;
			}
#line 960 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 960 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 960 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6308 "ConfigurationInterfaces.c"
		}
	}
	goto __finally134;
	__catch134_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 959 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 959 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 963 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 963 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 964 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 964 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6328 "ConfigurationInterfaces.c"
	}
	__finally134:
#line 959 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 959 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 959 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 959 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6339 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_external_raw_app (ConfigurationFacade* self, const gchar* external_raw_app) {
#line 958 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 958 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_external_raw_app (self, external_raw_app);
#line 6349 "ConfigurationInterfaces.c"
}


static ScaleConstraint configuration_facade_real_get_export_constraint (ConfigurationFacade* self) {
	ScaleConstraint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 973 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 973 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 973 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_enum_property (_tmp2_, CONFIGURABLE_PROPERTY_EXPORT_CONSTRAINT, &_inner_error_);
#line 973 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 973 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 973 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 973 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 973 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6378 "ConfigurationInterfaces.c"
				goto __catch135_configuration_error;
			}
#line 973 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 973 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 973 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 6387 "ConfigurationInterfaces.c"
		}
#line 973 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = (ScaleConstraint) _tmp0_;
#line 973 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6393 "ConfigurationInterfaces.c"
	}
	goto __finally135;
	__catch135_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
#line 972 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 972 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 975 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 975 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 977 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 977 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 977 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6414 "ConfigurationInterfaces.c"
	}
	__finally135:
#line 972 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 972 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 972 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 6423 "ConfigurationInterfaces.c"
}


ScaleConstraint configuration_facade_get_export_constraint (ConfigurationFacade* self) {
#line 971 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 971 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_export_constraint (self);
#line 6432 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_export_constraint (ConfigurationFacade* self, ScaleConstraint constraint) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		ScaleConstraint _tmp2_;
#line 983 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 983 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 983 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = constraint;
#line 983 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_enum_property (_tmp1_, CONFIGURABLE_PROPERTY_EXPORT_CONSTRAINT, (gint) _tmp2_, &_inner_error_);
#line 983 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 983 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 983 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6456 "ConfigurationInterfaces.c"
				goto __catch136_configuration_error;
			}
#line 983 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 983 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 983 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6465 "ConfigurationInterfaces.c"
		}
	}
	goto __finally136;
	__catch136_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 982 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 982 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 985 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 985 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 986 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 986 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6485 "ConfigurationInterfaces.c"
	}
	__finally136:
#line 982 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 982 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 982 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 982 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6496 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_export_constraint (ConfigurationFacade* self, ScaleConstraint constraint) {
#line 981 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 981 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_export_constraint (self, constraint);
#line 6506 "ConfigurationInterfaces.c"
}


static ExportFormatMode configuration_facade_real_get_export_export_format_mode (ConfigurationFacade* self) {
	ExportFormatMode result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 992 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 992 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 992 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_enum_property (_tmp2_, CONFIGURABLE_PROPERTY_EXPORT_EXPORT_FORMAT_MODE, &_inner_error_);
#line 992 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 992 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 992 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 992 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 992 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6535 "ConfigurationInterfaces.c"
				goto __catch137_configuration_error;
			}
#line 992 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 992 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 992 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 6544 "ConfigurationInterfaces.c"
		}
#line 992 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = (ExportFormatMode) _tmp0_;
#line 992 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6550 "ConfigurationInterfaces.c"
	}
	goto __finally137;
	__catch137_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
#line 991 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 991 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 994 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 994 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 996 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 996 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 996 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6571 "ConfigurationInterfaces.c"
	}
	__finally137:
#line 991 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 991 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 991 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 6580 "ConfigurationInterfaces.c"
}


ExportFormatMode configuration_facade_get_export_export_format_mode (ConfigurationFacade* self) {
#line 990 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 990 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_export_export_format_mode (self);
#line 6589 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_export_export_format_mode (ConfigurationFacade* self, ExportFormatMode export_format_mode) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		ExportFormatMode _tmp2_;
#line 1002 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1002 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1002 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = export_format_mode;
#line 1002 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_enum_property (_tmp1_, CONFIGURABLE_PROPERTY_EXPORT_EXPORT_FORMAT_MODE, (gint) _tmp2_, &_inner_error_);
#line 1002 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1002 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1002 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6613 "ConfigurationInterfaces.c"
				goto __catch138_configuration_error;
			}
#line 1002 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1002 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1002 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6622 "ConfigurationInterfaces.c"
		}
	}
	goto __finally138;
	__catch138_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1001 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1001 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1004 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1004 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1005 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1005 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6642 "ConfigurationInterfaces.c"
	}
	__finally138:
#line 1001 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1001 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1001 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1001 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6653 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_export_export_format_mode (ConfigurationFacade* self, ExportFormatMode export_format_mode) {
#line 1000 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1000 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_export_export_format_mode (self, export_format_mode);
#line 6663 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_export_export_metadata (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_EXPORT_EXPORT_METADATA, &_inner_error_);
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6691 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6695 "ConfigurationInterfaces.c"
				goto __catch139_configuration_error;
			}
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 6704 "ConfigurationInterfaces.c"
		}
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6710 "ConfigurationInterfaces.c"
	}
	goto __finally139;
	__catch139_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1010 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1010 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1013 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1013 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1015 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 1015 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1015 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6731 "ConfigurationInterfaces.c"
	}
	__finally139:
#line 1010 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1010 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1010 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 6740 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_export_export_metadata (ConfigurationFacade* self) {
#line 1009 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1009 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_export_export_metadata (self);
#line 6749 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_export_export_metadata (ConfigurationFacade* self, gboolean export_metadata) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 1021 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1021 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1021 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = export_metadata;
#line 1021 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_EXPORT_EXPORT_METADATA, _tmp2_, &_inner_error_);
#line 1021 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1021 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1021 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6773 "ConfigurationInterfaces.c"
				goto __catch140_configuration_error;
			}
#line 1021 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1021 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1021 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6782 "ConfigurationInterfaces.c"
		}
	}
	goto __finally140;
	__catch140_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1020 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1020 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1023 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1023 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1024 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1024 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6802 "ConfigurationInterfaces.c"
	}
	__finally140:
#line 1020 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1020 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1020 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1020 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6813 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_export_export_metadata (ConfigurationFacade* self, gboolean export_metadata) {
#line 1019 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1019 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_export_export_metadata (self, export_metadata);
#line 6823 "ConfigurationInterfaces.c"
}


static PhotoFileFormat configuration_facade_real_get_export_photo_file_format (ConfigurationFacade* self) {
	PhotoFileFormat result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		PhotoFileFormat _tmp5_;
#line 1030 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1030 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1030 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_enum_property (_tmp2_, CONFIGURABLE_PROPERTY_EXPORT_PHOTO_FILE_FORMAT, &_inner_error_);
#line 1030 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1030 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1030 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1030 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1030 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6853 "ConfigurationInterfaces.c"
				goto __catch141_configuration_error;
			}
#line 1030 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1030 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1030 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 6862 "ConfigurationInterfaces.c"
		}
#line 1030 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = photo_file_format_unserialize (_tmp0_);
#line 1030 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 1030 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6870 "ConfigurationInterfaces.c"
	}
	goto __finally141;
	__catch141_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1029 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1029 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1032 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1032 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1034 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 1034 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1034 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6891 "ConfigurationInterfaces.c"
	}
	__finally141:
#line 1029 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1029 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1029 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 6900 "ConfigurationInterfaces.c"
}


PhotoFileFormat configuration_facade_get_export_photo_file_format (ConfigurationFacade* self) {
#line 1028 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1028 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_export_photo_file_format (self);
#line 6909 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_export_photo_file_format (ConfigurationFacade* self, PhotoFileFormat photo_file_format) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		PhotoFileFormat _tmp2_;
		gint _tmp3_;
#line 1040 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1040 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1040 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = photo_file_format;
#line 1040 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = photo_file_format_serialize (_tmp2_);
#line 1040 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_enum_property (_tmp1_, CONFIGURABLE_PROPERTY_EXPORT_PHOTO_FILE_FORMAT, _tmp3_, &_inner_error_);
#line 1040 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1040 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1040 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6936 "ConfigurationInterfaces.c"
				goto __catch142_configuration_error;
			}
#line 1040 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1040 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1040 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6945 "ConfigurationInterfaces.c"
		}
	}
	goto __finally142;
	__catch142_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
#line 1039 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1039 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1042 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = err;
#line 1042 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp4_);
#line 1043 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1043 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6965 "ConfigurationInterfaces.c"
	}
	__finally142:
#line 1039 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1039 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1039 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1039 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6976 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_export_photo_file_format (ConfigurationFacade* self, PhotoFileFormat photo_file_format) {
#line 1038 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1038 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_export_photo_file_format (self, photo_file_format);
#line 6986 "ConfigurationInterfaces.c"
}


static JpegQuality configuration_facade_real_get_export_quality (ConfigurationFacade* self) {
	JpegQuality result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 1049 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1049 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1049 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_enum_property (_tmp2_, CONFIGURABLE_PROPERTY_EXPORT_QUALITY, &_inner_error_);
#line 1049 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1049 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1049 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1049 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1049 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7015 "ConfigurationInterfaces.c"
				goto __catch143_configuration_error;
			}
#line 1049 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1049 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1049 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 7024 "ConfigurationInterfaces.c"
		}
#line 1049 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = (JpegQuality) _tmp0_;
#line 1049 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7030 "ConfigurationInterfaces.c"
	}
	goto __finally143;
	__catch143_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
#line 1048 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1048 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1051 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1051 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1053 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 1053 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1053 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7051 "ConfigurationInterfaces.c"
	}
	__finally143:
#line 1048 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1048 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1048 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 7060 "ConfigurationInterfaces.c"
}


JpegQuality configuration_facade_get_export_quality (ConfigurationFacade* self) {
#line 1047 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1047 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_export_quality (self);
#line 7069 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_export_quality (ConfigurationFacade* self, JpegQuality quality) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		JpegQuality _tmp2_;
#line 1059 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1059 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1059 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = quality;
#line 1059 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_enum_property (_tmp1_, CONFIGURABLE_PROPERTY_EXPORT_QUALITY, (gint) _tmp2_, &_inner_error_);
#line 1059 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1059 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1059 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7093 "ConfigurationInterfaces.c"
				goto __catch144_configuration_error;
			}
#line 1059 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1059 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1059 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7102 "ConfigurationInterfaces.c"
		}
	}
	goto __finally144;
	__catch144_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1058 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1058 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1061 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1061 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1062 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1062 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7122 "ConfigurationInterfaces.c"
	}
	__finally144:
#line 1058 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1058 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1058 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1058 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7133 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_export_quality (ConfigurationFacade* self, JpegQuality quality) {
#line 1057 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1057 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_export_quality (self, quality);
#line 7143 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_export_scale (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_EXPORT_SCALE, &_inner_error_);
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7171 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7175 "ConfigurationInterfaces.c"
				goto __catch145_configuration_error;
			}
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 7184 "ConfigurationInterfaces.c"
		}
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7190 "ConfigurationInterfaces.c"
	}
	goto __finally145;
	__catch145_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1067 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1067 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1070 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1070 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1072 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 1072 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1072 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7211 "ConfigurationInterfaces.c"
	}
	__finally145:
#line 1067 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1067 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1067 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 7220 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_export_scale (ConfigurationFacade* self) {
#line 1066 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1066 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_export_scale (self);
#line 7229 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_export_scale (ConfigurationFacade* self, gint scale) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1078 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1078 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1078 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = scale;
#line 1078 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_EXPORT_SCALE, _tmp2_, &_inner_error_);
#line 1078 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1078 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1078 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7253 "ConfigurationInterfaces.c"
				goto __catch146_configuration_error;
			}
#line 1078 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1078 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1078 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7262 "ConfigurationInterfaces.c"
		}
	}
	goto __finally146;
	__catch146_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1077 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1077 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1080 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1080 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1081 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1081 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7282 "ConfigurationInterfaces.c"
	}
	__finally146:
#line 1077 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1077 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1077 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1077 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7293 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_export_scale (ConfigurationFacade* self, gint scale) {
#line 1076 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1076 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_export_scale (self, scale);
#line 7303 "ConfigurationInterfaces.c"
}


static RawDeveloper configuration_facade_real_get_default_raw_developer (ConfigurationFacade* self) {
	RawDeveloper result = 0;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		RawDeveloper _tmp5_;
#line 1090 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1090 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1090 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT, &_inner_error_);
#line 1090 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1090 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1090 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1090 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1090 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7333 "ConfigurationInterfaces.c"
				goto __catch147_configuration_error;
			}
#line 1090 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1090 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1090 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 7342 "ConfigurationInterfaces.c"
		}
#line 1090 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = raw_developer_from_string (_tmp0_);
#line 1090 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 1090 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 1090 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7352 "ConfigurationInterfaces.c"
	}
	goto __finally147;
	__catch147_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1089 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1089 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1093 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1093 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1095 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = RAW_DEVELOPER_CAMERA;
#line 1095 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1095 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7373 "ConfigurationInterfaces.c"
	}
	__finally147:
#line 1089 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1089 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1089 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 7382 "ConfigurationInterfaces.c"
}


RawDeveloper configuration_facade_get_default_raw_developer (ConfigurationFacade* self) {
#line 1088 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1088 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_default_raw_developer (self);
#line 7391 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_default_raw_developer (ConfigurationFacade* self, RawDeveloper d) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		RawDeveloper _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = d;
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = raw_developer_to_string (_tmp2_);
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT, _tmp4_, &_inner_error_);
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp4_);
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7423 "ConfigurationInterfaces.c"
				goto __catch148_configuration_error;
			}
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7432 "ConfigurationInterfaces.c"
		}
	}
	goto __finally148;
	__catch148_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
#line 1100 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1100 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7452 "ConfigurationInterfaces.c"
	}
	__finally148:
#line 1100 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1100 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1100 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1100 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7463 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_default_raw_developer (ConfigurationFacade* self, RawDeveloper d) {
#line 1099 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1099 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_default_raw_developer (self, d);
#line 7473 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_hide_photos_already_imported (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED, &_inner_error_);
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7501 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7505 "ConfigurationInterfaces.c"
				goto __catch149_configuration_error;
			}
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 7514 "ConfigurationInterfaces.c"
		}
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7520 "ConfigurationInterfaces.c"
	}
	goto __finally149;
	__catch149_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1113 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1113 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1116 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1116 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1118 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 1118 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1118 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7541 "ConfigurationInterfaces.c"
	}
	__finally149:
#line 1113 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1113 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1113 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 7550 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_hide_photos_already_imported (ConfigurationFacade* self) {
#line 1112 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1112 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_hide_photos_already_imported (self);
#line 7559 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_hide_photos_already_imported (ConfigurationFacade* self, gboolean hide_imported) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 1124 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1124 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1124 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = hide_imported;
#line 1124 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED, _tmp2_, &_inner_error_);
#line 1124 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1124 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1124 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7583 "ConfigurationInterfaces.c"
				goto __catch150_configuration_error;
			}
#line 1124 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1124 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1124 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7592 "ConfigurationInterfaces.c"
		}
	}
	goto __finally150;
	__catch150_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1123 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1123 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1126 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1126 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1123 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 7610 "ConfigurationInterfaces.c"
	}
	__finally150:
#line 1123 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1123 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1123 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1123 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7621 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_hide_photos_already_imported (ConfigurationFacade* self, gboolean hide_imported) {
#line 1122 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1122 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_hide_photos_already_imported (self, hide_imported);
#line 7631 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_import_dir (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_IMPORT_DIR, &_inner_error_);
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7661 "ConfigurationInterfaces.c"
				goto __catch151_configuration_error;
			}
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 7670 "ConfigurationInterfaces.c"
		}
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 1135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7682 "ConfigurationInterfaces.c"
	}
	goto __finally151;
	__catch151_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 1134 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1134 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1137 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1137 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1139 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 1139 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 1139 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1139 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7706 "ConfigurationInterfaces.c"
	}
	__finally151:
#line 1134 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1134 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1134 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 7715 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_import_dir (ConfigurationFacade* self) {
#line 1133 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 1133 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_import_dir (self);
#line 7724 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_import_dir (ConfigurationFacade* self, const gchar* import_dir) {
	GError * _inner_error_ = NULL;
#line 1143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (import_dir != NULL);
#line 7732 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
#line 1145 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1145 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1145 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = import_dir;
#line 1145 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_IMPORT_DIR, _tmp2_, &_inner_error_);
#line 1145 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1145 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1145 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7751 "ConfigurationInterfaces.c"
				goto __catch152_configuration_error;
			}
#line 1145 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1145 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1145 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7760 "ConfigurationInterfaces.c"
		}
	}
	goto __finally152;
	__catch152_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1147 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1147 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 7778 "ConfigurationInterfaces.c"
	}
	__finally152:
#line 1144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7789 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_import_dir (ConfigurationFacade* self, const gchar* import_dir) {
#line 1143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_import_dir (self, import_dir);
#line 7799 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_keep_relativity (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 1156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_KEEP_RELATIVITY, &_inner_error_);
#line 1156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7827 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 1156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7831 "ConfigurationInterfaces.c"
				goto __catch153_configuration_error;
			}
#line 1156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 7840 "ConfigurationInterfaces.c"
		}
#line 1156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7846 "ConfigurationInterfaces.c"
	}
	goto __finally153;
	__catch153_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1158 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1158 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1160 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 1160 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1160 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7867 "ConfigurationInterfaces.c"
	}
	__finally153:
#line 1155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 7876 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_keep_relativity (ConfigurationFacade* self) {
#line 1154 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1154 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_keep_relativity (self);
#line 7885 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_keep_relativity (ConfigurationFacade* self, gboolean keep_relativity) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 1166 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1166 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1166 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = keep_relativity;
#line 1166 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_KEEP_RELATIVITY, _tmp2_, &_inner_error_);
#line 1166 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1166 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1166 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7909 "ConfigurationInterfaces.c"
				goto __catch154_configuration_error;
			}
#line 1166 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1166 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1166 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7918 "ConfigurationInterfaces.c"
		}
	}
	goto __finally154;
	__catch154_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1165 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1165 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1165 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 7936 "ConfigurationInterfaces.c"
	}
	__finally154:
#line 1165 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1165 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1165 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1165 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7947 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_keep_relativity (ConfigurationFacade* self, gboolean keep_relativity) {
#line 1164 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1164 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_keep_relativity (self, keep_relativity);
#line 7957 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_pin_toolbar_state (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 1177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE, &_inner_error_);
#line 1177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7985 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 1177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7989 "ConfigurationInterfaces.c"
				goto __catch155_configuration_error;
			}
#line 1177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 7998 "ConfigurationInterfaces.c"
		}
#line 1177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8004 "ConfigurationInterfaces.c"
	}
	goto __finally155;
	__catch155_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1176 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1176 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1180 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 1180 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1180 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8025 "ConfigurationInterfaces.c"
	}
	__finally155:
#line 1176 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1176 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1176 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 8034 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_pin_toolbar_state (ConfigurationFacade* self) {
#line 1175 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1175 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_pin_toolbar_state (self);
#line 8043 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_pin_toolbar_state (ConfigurationFacade* self, gboolean state) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 1186 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1186 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1186 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = state;
#line 1186 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE, _tmp2_, &_inner_error_);
#line 1186 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1186 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1186 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8067 "ConfigurationInterfaces.c"
				goto __catch156_configuration_error;
			}
#line 1186 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1186 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1186 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8076 "ConfigurationInterfaces.c"
		}
	}
	goto __finally156;
	__catch156_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1185 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1185 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1185 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8094 "ConfigurationInterfaces.c"
	}
	__finally156:
#line 1185 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1185 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1185 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1185 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8105 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_pin_toolbar_state (ConfigurationFacade* self, gboolean state) {
#line 1184 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1184 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_pin_toolbar_state (self, state);
#line 8115 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_last_crop_height (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 1197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT, &_inner_error_);
#line 1197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8143 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8147 "ConfigurationInterfaces.c"
				goto __catch157_configuration_error;
			}
#line 1197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 8156 "ConfigurationInterfaces.c"
		}
#line 1197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8162 "ConfigurationInterfaces.c"
	}
	goto __finally157;
	__catch157_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1196 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1196 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1200 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 1;
#line 1200 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1200 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8183 "ConfigurationInterfaces.c"
	}
	__finally157:
#line 1196 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1196 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1196 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 8192 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_last_crop_height (ConfigurationFacade* self) {
#line 1195 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1195 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_last_crop_height (self);
#line 8201 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_last_crop_height (ConfigurationFacade* self, gint choice) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1206 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1206 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1206 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = choice;
#line 1206 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT, _tmp2_, &_inner_error_);
#line 1206 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1206 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1206 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8225 "ConfigurationInterfaces.c"
				goto __catch158_configuration_error;
			}
#line 1206 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1206 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1206 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8234 "ConfigurationInterfaces.c"
		}
	}
	goto __finally158;
	__catch158_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1205 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1205 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1208 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1208 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1205 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8252 "ConfigurationInterfaces.c"
	}
	__finally158:
#line 1205 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1205 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1205 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1205 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8263 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_last_crop_height (ConfigurationFacade* self, gint choice) {
#line 1204 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1204 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_last_crop_height (self, choice);
#line 8273 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_last_crop_menu_choice (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE, &_inner_error_);
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8301 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8305 "ConfigurationInterfaces.c"
				goto __catch159_configuration_error;
			}
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 8314 "ConfigurationInterfaces.c"
		}
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1217 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8320 "ConfigurationInterfaces.c"
	}
	goto __finally159;
	__catch159_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1216 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1216 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1219 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1219 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1224 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 1224 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1224 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8341 "ConfigurationInterfaces.c"
	}
	__finally159:
#line 1216 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1216 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1216 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 8350 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_last_crop_menu_choice (ConfigurationFacade* self) {
#line 1215 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1215 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_last_crop_menu_choice (self);
#line 8359 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_last_crop_menu_choice (ConfigurationFacade* self, gint choice) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = choice;
#line 1230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE, _tmp2_, &_inner_error_);
#line 1230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8383 "ConfigurationInterfaces.c"
				goto __catch160_configuration_error;
			}
#line 1230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8392 "ConfigurationInterfaces.c"
		}
	}
	goto __finally160;
	__catch160_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1229 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1229 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1232 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1232 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1229 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8410 "ConfigurationInterfaces.c"
	}
	__finally160:
#line 1229 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1229 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1229 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1229 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8421 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_last_crop_menu_choice (ConfigurationFacade* self, gint choice) {
#line 1228 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1228 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_last_crop_menu_choice (self, choice);
#line 8431 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_last_crop_width (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 1241 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1241 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1241 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH, &_inner_error_);
#line 1241 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1241 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1241 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1241 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8459 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1241 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8463 "ConfigurationInterfaces.c"
				goto __catch161_configuration_error;
			}
#line 1241 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1241 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1241 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 8472 "ConfigurationInterfaces.c"
		}
#line 1241 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1241 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8478 "ConfigurationInterfaces.c"
	}
	goto __finally161;
	__catch161_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1240 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1240 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1243 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1243 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1244 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 1;
#line 1244 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1244 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8499 "ConfigurationInterfaces.c"
	}
	__finally161:
#line 1240 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1240 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1240 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 8508 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_last_crop_width (ConfigurationFacade* self) {
#line 1239 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1239 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_last_crop_width (self);
#line 8517 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_last_crop_width (ConfigurationFacade* self, gint choice) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1250 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1250 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1250 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = choice;
#line 1250 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH, _tmp2_, &_inner_error_);
#line 1250 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1250 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1250 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8541 "ConfigurationInterfaces.c"
				goto __catch162_configuration_error;
			}
#line 1250 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1250 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1250 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8550 "ConfigurationInterfaces.c"
		}
	}
	goto __finally162;
	__catch162_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1252 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1252 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8568 "ConfigurationInterfaces.c"
	}
	__finally162:
#line 1249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8579 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_last_crop_width (ConfigurationFacade* self, gint choice) {
#line 1248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1248 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_last_crop_width (self, choice);
#line 8589 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_last_used_service (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_USED_SERVICE, &_inner_error_);
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8619 "ConfigurationInterfaces.c"
				goto __catch163_configuration_error;
			}
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 8628 "ConfigurationInterfaces.c"
		}
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 1261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8640 "ConfigurationInterfaces.c"
	}
	goto __finally163;
	__catch163_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 1260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1263 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1263 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1268 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 1268 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 1268 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1268 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8664 "ConfigurationInterfaces.c"
	}
	__finally163:
#line 1260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1260 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 8673 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_last_used_service (ConfigurationFacade* self) {
#line 1259 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 1259 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_last_used_service (self);
#line 8682 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_last_used_service (ConfigurationFacade* self, const gchar* service_name) {
	GError * _inner_error_ = NULL;
#line 1272 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (service_name != NULL);
#line 8690 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = service_name;
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_USED_SERVICE, _tmp2_, &_inner_error_);
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8709 "ConfigurationInterfaces.c"
				goto __catch164_configuration_error;
			}
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8718 "ConfigurationInterfaces.c"
		}
	}
	goto __finally164;
	__catch164_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1273 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1273 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1276 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1276 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1273 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8736 "ConfigurationInterfaces.c"
	}
	__finally164:
#line 1273 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1273 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1273 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1273 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8747 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_last_used_service (ConfigurationFacade* self, const gchar* service_name) {
#line 1272 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1272 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_last_used_service (self, service_name);
#line 8757 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_last_used_dataimports_service (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE, &_inner_error_);
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8787 "ConfigurationInterfaces.c"
				goto __catch165_configuration_error;
			}
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 8796 "ConfigurationInterfaces.c"
		}
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8808 "ConfigurationInterfaces.c"
	}
	goto __finally165;
	__catch165_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 1284 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1284 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1287 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1287 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1292 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 1292 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 1292 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1292 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8832 "ConfigurationInterfaces.c"
	}
	__finally165:
#line 1284 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1284 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 8841 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_last_used_dataimports_service (ConfigurationFacade* self) {
#line 1283 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 1283 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_last_used_dataimports_service (self);
#line 8850 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_last_used_dataimports_service (ConfigurationFacade* self, const gchar* service_name) {
	GError * _inner_error_ = NULL;
#line 1296 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (service_name != NULL);
#line 8858 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
#line 1298 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1298 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1298 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = service_name;
#line 1298 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE, _tmp2_, &_inner_error_);
#line 1298 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1298 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1298 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8877 "ConfigurationInterfaces.c"
				goto __catch166_configuration_error;
			}
#line 1298 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1298 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1298 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8886 "ConfigurationInterfaces.c"
		}
	}
	goto __finally166;
	__catch166_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1297 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1297 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1300 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1300 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1297 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8904 "ConfigurationInterfaces.c"
	}
	__finally166:
#line 1297 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1297 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1297 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1297 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8915 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_last_used_dataimports_service (ConfigurationFacade* self, const gchar* service_name) {
#line 1296 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1296 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_last_used_dataimports_service (self, service_name);
#line 8925 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_get_library_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by) {
	gboolean _vala_sort_order = FALSE;
	gint _vala_sort_by = 0;
	GError * _inner_error_ = NULL;
#line 1308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_sort_order = FALSE;
#line 1309 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_sort_by = 2;
#line 8937 "ConfigurationInterfaces.c"
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		gint _tmp5_ = 0;
		ConfigurationEngine* _tmp6_;
		ConfigurationEngine* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
#line 1311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING, &_inner_error_);
#line 1311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8965 "ConfigurationInterfaces.c"
				goto __catch167_configuration_error;
			}
#line 1311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8974 "ConfigurationInterfaces.c"
		}
#line 1311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_sort_order = _tmp0_;
#line 1313 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = configuration_facade_get_engine (self);
#line 1313 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = _tmp6_;
#line 1313 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = configuration_engine_get_int_property (_tmp7_, CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY, &_inner_error_);
#line 1313 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = _tmp8_;
#line 1313 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp7_);
#line 1313 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp9_;
#line 1313 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1313 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8994 "ConfigurationInterfaces.c"
				goto __catch167_configuration_error;
			}
#line 1313 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1313 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1313 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9003 "ConfigurationInterfaces.c"
		}
#line 1313 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_sort_by = _tmp5_;
#line 9007 "ConfigurationInterfaces.c"
	}
	goto __finally167;
	__catch167_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp10_;
#line 1310 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1310 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1315 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = err;
#line 1315 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp10_);
#line 1310 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9024 "ConfigurationInterfaces.c"
	}
	__finally167:
#line 1310 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1310 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1310 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1310 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9035 "ConfigurationInterfaces.c"
	}
#line 1307 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (sort_order) {
#line 1307 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*sort_order = _vala_sort_order;
#line 9041 "ConfigurationInterfaces.c"
	}
#line 1307 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (sort_by) {
#line 1307 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*sort_by = _vala_sort_by;
#line 9047 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_get_library_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by) {
#line 1307 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1307 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->get_library_photos_sort (self, sort_order, sort_by);
#line 9057 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_library_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
		ConfigurationEngine* _tmp3_;
		ConfigurationEngine* _tmp4_;
		gint _tmp5_;
#line 1321 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1321 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1321 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = sort_order;
#line 1321 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING, _tmp2_, &_inner_error_);
#line 1321 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1321 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1321 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9084 "ConfigurationInterfaces.c"
				goto __catch168_configuration_error;
			}
#line 1321 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1321 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1321 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9093 "ConfigurationInterfaces.c"
		}
#line 1323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 1323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = sort_by;
#line 1323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp4_, CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY, _tmp5_, &_inner_error_);
#line 1323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 1323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9109 "ConfigurationInterfaces.c"
				goto __catch168_configuration_error;
			}
#line 1323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1323 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9118 "ConfigurationInterfaces.c"
		}
	}
	goto __finally168;
	__catch168_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1320 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1320 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1326 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1326 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1320 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9136 "ConfigurationInterfaces.c"
	}
	__finally168:
#line 1320 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1320 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1320 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1320 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9147 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_library_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by) {
#line 1319 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1319 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_library_photos_sort (self, sort_order, sort_by);
#line 9157 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_get_library_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions) {
	gboolean _vala_maximize = FALSE;
	Dimensions _vala_dimensions = {0};
	GError * _inner_error_ = NULL;
#line 1334 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_maximize = FALSE;
#line 1335 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	dimensions_init (&_vala_dimensions, 1024, 768);
#line 9169 "ConfigurationInterfaces.c"
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		gint w = 0;
		ConfigurationEngine* _tmp5_;
		ConfigurationEngine* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint h = 0;
		ConfigurationEngine* _tmp9_;
		ConfigurationEngine* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
#line 1337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE, &_inner_error_);
#line 1337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9204 "ConfigurationInterfaces.c"
				goto __catch169_configuration_error;
			}
#line 1337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9213 "ConfigurationInterfaces.c"
		}
#line 1337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_maximize = _tmp0_;
#line 1338 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = configuration_facade_get_engine (self);
#line 1338 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = _tmp5_;
#line 1338 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = configuration_engine_get_int_property (_tmp6_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH, &_inner_error_);
#line 1338 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp7_;
#line 1338 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp6_);
#line 1338 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		w = _tmp8_;
#line 1338 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1338 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9233 "ConfigurationInterfaces.c"
				goto __catch169_configuration_error;
			}
#line 1338 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1338 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1338 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9242 "ConfigurationInterfaces.c"
		}
#line 1339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = configuration_facade_get_engine (self);
#line 1339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = _tmp9_;
#line 1339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp11_ = configuration_engine_get_int_property (_tmp10_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT, &_inner_error_);
#line 1339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp12_ = _tmp11_;
#line 1339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp10_);
#line 1339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		h = _tmp12_;
#line 1339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9260 "ConfigurationInterfaces.c"
				goto __catch169_configuration_error;
			}
#line 1339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9269 "ConfigurationInterfaces.c"
		}
#line 1340 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp13_ = w;
#line 1340 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp14_ = h;
#line 1340 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		dimensions_init (&_vala_dimensions, _tmp13_, _tmp14_);
#line 9277 "ConfigurationInterfaces.c"
	}
	goto __finally169;
	__catch169_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp15_;
#line 1336 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1336 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1342 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp15_ = err;
#line 1342 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp15_);
#line 1336 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9294 "ConfigurationInterfaces.c"
	}
	__finally169:
#line 1336 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1336 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1336 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1336 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9305 "ConfigurationInterfaces.c"
	}
#line 1333 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (maximize) {
#line 1333 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*maximize = _vala_maximize;
#line 9311 "ConfigurationInterfaces.c"
	}
#line 1333 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (dimensions) {
#line 1333 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*dimensions = _vala_dimensions;
#line 9317 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_get_library_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions) {
#line 1333 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1333 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->get_library_window_state (self, maximize, dimensions);
#line 9327 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_library_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions) {
	GError * _inner_error_ = NULL;
#line 1346 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (dimensions != NULL);
#line 9335 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
		ConfigurationEngine* _tmp3_;
		ConfigurationEngine* _tmp4_;
		Dimensions _tmp5_;
		gint _tmp6_;
		ConfigurationEngine* _tmp7_;
		ConfigurationEngine* _tmp8_;
		Dimensions _tmp9_;
		gint _tmp10_;
#line 1348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = maximize;
#line 1348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE, _tmp2_, &_inner_error_);
#line 1348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9362 "ConfigurationInterfaces.c"
				goto __catch170_configuration_error;
			}
#line 1348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9371 "ConfigurationInterfaces.c"
		}
#line 1349 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 1349 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1349 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = *dimensions;
#line 1349 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = _tmp5_.width;
#line 1349 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp4_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH, _tmp6_, &_inner_error_);
#line 1349 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 1349 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1349 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9389 "ConfigurationInterfaces.c"
				goto __catch170_configuration_error;
			}
#line 1349 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1349 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1349 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9398 "ConfigurationInterfaces.c"
		}
#line 1351 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = configuration_facade_get_engine (self);
#line 1351 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp7_;
#line 1351 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = *dimensions;
#line 1351 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = _tmp9_.height;
#line 1351 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp8_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT, _tmp10_, &_inner_error_);
#line 1351 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp8_);
#line 1351 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1351 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9416 "ConfigurationInterfaces.c"
				goto __catch170_configuration_error;
			}
#line 1351 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1351 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1351 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9425 "ConfigurationInterfaces.c"
		}
	}
	goto __finally170;
	__catch170_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp11_;
#line 1347 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1347 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1354 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp11_ = err;
#line 1354 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp11_);
#line 1347 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9443 "ConfigurationInterfaces.c"
	}
	__finally170:
#line 1347 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1347 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1347 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1347 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9454 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_library_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions) {
#line 1346 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1346 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_library_window_state (self, maximize, dimensions);
#line 9464 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_modify_originals (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 1363 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1363 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1363 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS, &_inner_error_);
#line 1363 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1363 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1363 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1363 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9492 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 1363 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9496 "ConfigurationInterfaces.c"
				goto __catch171_configuration_error;
			}
#line 1363 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1363 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1363 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 9505 "ConfigurationInterfaces.c"
		}
#line 1363 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1363 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9511 "ConfigurationInterfaces.c"
	}
	goto __finally171;
	__catch171_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1365 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1365 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1368 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 1368 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1368 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9532 "ConfigurationInterfaces.c"
	}
	__finally171:
#line 1362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 9541 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_modify_originals (ConfigurationFacade* self) {
#line 1361 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1361 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_modify_originals (self);
#line 9550 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_modify_originals (ConfigurationFacade* self, gboolean modify_originals) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = modify_originals;
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS, _tmp2_, &_inner_error_);
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9574 "ConfigurationInterfaces.c"
				goto __catch172_configuration_error;
			}
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9583 "ConfigurationInterfaces.c"
		}
	}
	goto __finally172;
	__catch172_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1373 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1373 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1376 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1376 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1373 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9601 "ConfigurationInterfaces.c"
	}
	__finally172:
#line 1373 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1373 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1373 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1373 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9612 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_modify_originals (ConfigurationFacade* self, gboolean modify_originals) {
#line 1372 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1372 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_modify_originals (self, modify_originals);
#line 9622 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_photo_thumbnail_scale (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp9_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 1385 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1385 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1385 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE, &_inner_error_);
#line 1385 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1385 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1385 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1385 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9650 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1385 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9654 "ConfigurationInterfaces.c"
				goto __catch173_configuration_error;
			}
#line 1385 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1385 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1385 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 9663 "ConfigurationInterfaces.c"
		}
#line 1385 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1385 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9669 "ConfigurationInterfaces.c"
	}
	goto __finally173;
	__catch173_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
#line 1384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1387 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1387 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1388 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = thumbnail_get_DEFAULT_SCALE ();
#line 1388 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp7_;
#line 1388 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp8_;
#line 1388 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1388 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9696 "ConfigurationInterfaces.c"
	}
	__finally173:
#line 1384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp9_;
#line 9705 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_photo_thumbnail_scale (ConfigurationFacade* self) {
#line 1383 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1383 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_photo_thumbnail_scale (self);
#line 9714 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_photo_thumbnail_scale (ConfigurationFacade* self, gint scale) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1394 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1394 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1394 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = scale;
#line 1394 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE, _tmp2_, &_inner_error_);
#line 1394 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1394 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1394 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9738 "ConfigurationInterfaces.c"
				goto __catch174_configuration_error;
			}
#line 1394 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1394 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1394 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9747 "ConfigurationInterfaces.c"
		}
	}
	goto __finally174;
	__catch174_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9765 "ConfigurationInterfaces.c"
	}
	__finally174:
#line 1393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1393 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9776 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_photo_thumbnail_scale (ConfigurationFacade* self, gint scale) {
#line 1392 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1392 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_photo_thumbnail_scale (self, scale);
#line 9786 "ConfigurationInterfaces.c"
}


static gdouble configuration_facade_real_get_printing_content_height (ConfigurationFacade* self) {
	gdouble result = 0.0;
	gdouble _tmp7_ = 0.0;
	GError * _inner_error_ = NULL;
	{
		gdouble _tmp0_ = 0.0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gdouble _tmp3_;
		gdouble _tmp4_;
#line 1405 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1405 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1405 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_double_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT, &_inner_error_);
#line 1405 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1405 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1405 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1405 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9814 "ConfigurationInterfaces.c"
			gdouble _tmp5_ = 0.0;
#line 1405 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9818 "ConfigurationInterfaces.c"
				goto __catch175_configuration_error;
			}
#line 1405 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1405 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1405 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 9827 "ConfigurationInterfaces.c"
		}
#line 1405 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1405 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9833 "ConfigurationInterfaces.c"
	}
	goto __finally175;
	__catch175_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1404 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1404 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1409 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 5.0;
#line 1409 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1409 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9854 "ConfigurationInterfaces.c"
	}
	__finally175:
#line 1404 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1404 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1404 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 9863 "ConfigurationInterfaces.c"
}


gdouble configuration_facade_get_printing_content_height (ConfigurationFacade* self) {
#line 1403 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
#line 1403 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_content_height (self);
#line 9872 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_content_height (ConfigurationFacade* self, gdouble content_height) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gdouble _tmp2_;
#line 1415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = content_height;
#line 1415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_double_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT, _tmp2_, &_inner_error_);
#line 1415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9896 "ConfigurationInterfaces.c"
				goto __catch176_configuration_error;
			}
#line 1415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9905 "ConfigurationInterfaces.c"
		}
	}
	goto __finally176;
	__catch176_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1414 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1414 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1418 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1418 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1414 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9923 "ConfigurationInterfaces.c"
	}
	__finally176:
#line 1414 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1414 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1414 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1414 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9934 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_content_height (ConfigurationFacade* self, gdouble content_height) {
#line 1413 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1413 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_content_height (self, content_height);
#line 9944 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_printing_content_layout (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 1427 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1427 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1427 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT, &_inner_error_);
#line 1427 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1427 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1427 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1427 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9972 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1427 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9976 "ConfigurationInterfaces.c"
				goto __catch177_configuration_error;
			}
#line 1427 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1427 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1427 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 9985 "ConfigurationInterfaces.c"
		}
#line 1427 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_ - 1;
#line 1427 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9991 "ConfigurationInterfaces.c"
	}
	goto __finally177;
	__catch177_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1426 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1426 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1431 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 1431 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1431 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10012 "ConfigurationInterfaces.c"
	}
	__finally177:
#line 1426 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1426 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1426 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 10021 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_printing_content_layout (ConfigurationFacade* self) {
#line 1425 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1425 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_content_layout (self);
#line 10030 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_content_layout (ConfigurationFacade* self, gint layout_code) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1437 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1437 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1437 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = layout_code;
#line 1437 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT, _tmp2_ + 1, &_inner_error_);
#line 1437 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1437 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1437 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10054 "ConfigurationInterfaces.c"
				goto __catch178_configuration_error;
			}
#line 1437 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1437 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1437 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 10063 "ConfigurationInterfaces.c"
		}
	}
	goto __finally178;
	__catch178_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1436 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1436 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1440 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1440 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1436 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 10081 "ConfigurationInterfaces.c"
	}
	__finally178:
#line 1436 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1436 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1436 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1436 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10092 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_content_layout (ConfigurationFacade* self, gint layout_code) {
#line 1435 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1435 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_content_layout (self, layout_code);
#line 10102 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_printing_content_ppi (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 1449 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1449 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1449 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI, &_inner_error_);
#line 1449 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1449 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1449 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1449 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 10130 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1449 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10134 "ConfigurationInterfaces.c"
				goto __catch179_configuration_error;
			}
#line 1449 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1449 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1449 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 10143 "ConfigurationInterfaces.c"
		}
#line 1449 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1449 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10149 "ConfigurationInterfaces.c"
	}
	goto __finally179;
	__catch179_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1448 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1448 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1453 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 600;
#line 1453 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1453 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10170 "ConfigurationInterfaces.c"
	}
	__finally179:
#line 1448 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1448 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1448 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 10179 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_printing_content_ppi (ConfigurationFacade* self) {
#line 1447 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1447 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_content_ppi (self);
#line 10188 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_content_ppi (ConfigurationFacade* self, gint content_ppi) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1459 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1459 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1459 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = content_ppi;
#line 1459 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI, _tmp2_, &_inner_error_);
#line 1459 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1459 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1459 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10212 "ConfigurationInterfaces.c"
				goto __catch180_configuration_error;
			}
#line 1459 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1459 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1459 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 10221 "ConfigurationInterfaces.c"
		}
	}
	goto __finally180;
	__catch180_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1458 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1458 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1461 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1461 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1458 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 10239 "ConfigurationInterfaces.c"
	}
	__finally180:
#line 1458 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1458 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1458 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1458 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10250 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_content_ppi (ConfigurationFacade* self, gint content_ppi) {
#line 1457 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1457 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_content_ppi (self, content_ppi);
#line 10260 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_printing_content_units (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 1470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS, &_inner_error_);
#line 1470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 10288 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10292 "ConfigurationInterfaces.c"
				goto __catch181_configuration_error;
			}
#line 1470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 10301 "ConfigurationInterfaces.c"
		}
#line 1470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_ - 1;
#line 1470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10307 "ConfigurationInterfaces.c"
	}
	goto __finally181;
	__catch181_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1469 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1469 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1472 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1472 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1474 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 1474 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1474 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10328 "ConfigurationInterfaces.c"
	}
	__finally181:
#line 1469 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1469 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1469 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 10337 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_printing_content_units (ConfigurationFacade* self) {
#line 1468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_content_units (self);
#line 10346 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_content_units (ConfigurationFacade* self, gint units_code) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = units_code;
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS, _tmp2_ + 1, &_inner_error_);
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10370 "ConfigurationInterfaces.c"
				goto __catch182_configuration_error;
			}
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 10379 "ConfigurationInterfaces.c"
		}
	}
	goto __finally182;
	__catch182_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1479 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1479 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1479 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 10397 "ConfigurationInterfaces.c"
	}
	__finally182:
#line 1479 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1479 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1479 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1479 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10408 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_content_units (ConfigurationFacade* self, gint units_code) {
#line 1478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_content_units (self, units_code);
#line 10418 "ConfigurationInterfaces.c"
}


static gdouble configuration_facade_real_get_printing_content_width (ConfigurationFacade* self) {
	gdouble result = 0.0;
	gdouble _tmp7_ = 0.0;
	GError * _inner_error_ = NULL;
	{
		gdouble _tmp0_ = 0.0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gdouble _tmp3_;
		gdouble _tmp4_;
#line 1492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_double_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH, &_inner_error_);
#line 1492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 10446 "ConfigurationInterfaces.c"
			gdouble _tmp5_ = 0.0;
#line 1492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10450 "ConfigurationInterfaces.c"
				goto __catch183_configuration_error;
			}
#line 1492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 10459 "ConfigurationInterfaces.c"
		}
#line 1492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10465 "ConfigurationInterfaces.c"
	}
	goto __finally183;
	__catch183_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1491 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1491 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1494 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1494 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1496 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 7.0;
#line 1496 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1496 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10486 "ConfigurationInterfaces.c"
	}
	__finally183:
#line 1491 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1491 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1491 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 10495 "ConfigurationInterfaces.c"
}


gdouble configuration_facade_get_printing_content_width (ConfigurationFacade* self) {
#line 1490 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
#line 1490 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_content_width (self);
#line 10504 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_content_width (ConfigurationFacade* self, gdouble content_width) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gdouble _tmp2_;
#line 1502 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1502 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1502 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = content_width;
#line 1502 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_double_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH, _tmp2_, &_inner_error_);
#line 1502 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1502 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1502 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10528 "ConfigurationInterfaces.c"
				goto __catch184_configuration_error;
			}
#line 1502 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1502 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1502 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 10537 "ConfigurationInterfaces.c"
		}
	}
	goto __finally184;
	__catch184_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1501 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1501 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1501 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 10555 "ConfigurationInterfaces.c"
	}
	__finally184:
#line 1501 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1501 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1501 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1501 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10566 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_content_width (ConfigurationFacade* self, gdouble content_width) {
#line 1500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1500 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_content_width (self, content_width);
#line 10576 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_printing_images_per_page (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 1514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE, &_inner_error_);
#line 1514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 10604 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10608 "ConfigurationInterfaces.c"
				goto __catch185_configuration_error;
			}
#line 1514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 10617 "ConfigurationInterfaces.c"
		}
#line 1514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_ - 1;
#line 1514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10623 "ConfigurationInterfaces.c"
	}
	goto __finally185;
	__catch185_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1513 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1513 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1516 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1516 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 1518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10644 "ConfigurationInterfaces.c"
	}
	__finally185:
#line 1513 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1513 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1513 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 10653 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_printing_images_per_page (ConfigurationFacade* self) {
#line 1512 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1512 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_images_per_page (self);
#line 10662 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_images_per_page (ConfigurationFacade* self, gint images_per_page_code) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1524 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1524 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1524 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = images_per_page_code;
#line 1524 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE, _tmp2_ + 1, &_inner_error_);
#line 1524 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1524 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1524 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10686 "ConfigurationInterfaces.c"
				goto __catch186_configuration_error;
			}
#line 1524 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1524 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1524 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 10695 "ConfigurationInterfaces.c"
		}
	}
	goto __finally186;
	__catch186_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1523 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1523 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1527 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1527 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1523 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 10713 "ConfigurationInterfaces.c"
	}
	__finally186:
#line 1523 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1523 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1523 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1523 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10724 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_images_per_page (ConfigurationFacade* self, gint images_per_page_code) {
#line 1522 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1522 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_images_per_page (self, images_per_page_code);
#line 10734 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_printing_match_aspect_ratio (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 1536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO, &_inner_error_);
#line 1536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 10762 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 1536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10766 "ConfigurationInterfaces.c"
				goto __catch187_configuration_error;
			}
#line 1536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 10775 "ConfigurationInterfaces.c"
		}
#line 1536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1536 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10781 "ConfigurationInterfaces.c"
	}
	goto __finally187;
	__catch187_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1535 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1535 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1538 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1538 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1540 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 1540 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1540 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10802 "ConfigurationInterfaces.c"
	}
	__finally187:
#line 1535 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1535 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1535 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 10811 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_printing_match_aspect_ratio (ConfigurationFacade* self) {
#line 1534 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1534 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_match_aspect_ratio (self);
#line 10820 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_match_aspect_ratio (ConfigurationFacade* self, gboolean match_aspect_ratio) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 1546 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1546 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1546 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = match_aspect_ratio;
#line 1546 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO, _tmp2_, &_inner_error_);
#line 1546 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1546 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1546 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10844 "ConfigurationInterfaces.c"
				goto __catch188_configuration_error;
			}
#line 1546 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1546 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1546 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 10853 "ConfigurationInterfaces.c"
		}
	}
	goto __finally188;
	__catch188_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 10871 "ConfigurationInterfaces.c"
	}
	__finally188:
#line 1545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1545 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10882 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_match_aspect_ratio (ConfigurationFacade* self, gboolean match_aspect_ratio) {
#line 1544 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1544 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_match_aspect_ratio (self, match_aspect_ratio);
#line 10892 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_printing_print_titles (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES, &_inner_error_);
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 10920 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10924 "ConfigurationInterfaces.c"
				goto __catch189_configuration_error;
			}
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 10933 "ConfigurationInterfaces.c"
		}
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10939 "ConfigurationInterfaces.c"
	}
	goto __finally189;
	__catch189_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1557 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1557 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1560 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1562 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 1562 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1562 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10960 "ConfigurationInterfaces.c"
	}
	__finally189:
#line 1557 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1557 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1557 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 10969 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_printing_print_titles (ConfigurationFacade* self) {
#line 1556 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1556 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_print_titles (self);
#line 10978 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_print_titles (ConfigurationFacade* self, gboolean print_titles) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 1568 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1568 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1568 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = print_titles;
#line 1568 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES, _tmp2_, &_inner_error_);
#line 1568 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1568 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1568 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11002 "ConfigurationInterfaces.c"
				goto __catch190_configuration_error;
			}
#line 1568 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1568 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1568 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 11011 "ConfigurationInterfaces.c"
		}
	}
	goto __finally190;
	__catch190_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1567 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1567 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1571 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1571 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1567 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 11029 "ConfigurationInterfaces.c"
	}
	__finally190:
#line 1567 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1567 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1567 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1567 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 11040 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_print_titles (ConfigurationFacade* self, gboolean print_titles) {
#line 1566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_print_titles (self, print_titles);
#line 11050 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_printing_size_selection (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp9_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint val = 0;
		gint _tmp6_;
#line 1580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION, &_inner_error_);
#line 1580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 11080 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11084 "ConfigurationInterfaces.c"
				goto __catch191_configuration_error;
			}
#line 1580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 11093 "ConfigurationInterfaces.c"
		}
#line 1580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		val = _tmp0_ - 1;
#line 1581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = val;
#line 1581 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (_tmp6_ == -2) {
#line 11101 "ConfigurationInterfaces.c"
			ResourcesUnitSystem _tmp7_;
#line 1582 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp7_ = resources_get_default_measurement_unit ();
#line 1582 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_tmp7_ == RESOURCES_UNIT_SYSTEM_IMPERIAL) {
#line 1583 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
				val = 2;
#line 11109 "ConfigurationInterfaces.c"
			} else {
#line 1585 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
				val = 10;
#line 11113 "ConfigurationInterfaces.c"
			}
		}
#line 1589 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = val;
#line 1589 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11120 "ConfigurationInterfaces.c"
	}
	goto __finally191;
	__catch191_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp8_;
#line 1579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1591 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = err;
#line 1591 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp8_);
#line 1593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 1593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1593 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11141 "ConfigurationInterfaces.c"
	}
	__finally191:
#line 1579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp9_;
#line 11150 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_printing_size_selection (ConfigurationFacade* self) {
#line 1578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_size_selection (self);
#line 11159 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_size_selection (ConfigurationFacade* self, gint size_code) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = size_code;
#line 1599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION, _tmp2_ + 1, &_inner_error_);
#line 1599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11183 "ConfigurationInterfaces.c"
				goto __catch192_configuration_error;
			}
#line 1599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 11192 "ConfigurationInterfaces.c"
		}
	}
	goto __finally192;
	__catch192_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1598 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1598 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1602 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1602 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1598 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 11210 "ConfigurationInterfaces.c"
	}
	__finally192:
#line 1598 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1598 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1598 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1598 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 11221 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_size_selection (ConfigurationFacade* self, gint size_code) {
#line 1597 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1597 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_size_selection (self, size_code);
#line 11231 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_printing_titles_font (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 1611 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1611 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1611 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT, &_inner_error_);
#line 1611 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1611 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1611 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1611 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1611 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11261 "ConfigurationInterfaces.c"
				goto __catch193_configuration_error;
			}
#line 1611 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1611 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1611 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 11270 "ConfigurationInterfaces.c"
		}
#line 1611 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 1611 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 1611 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 1611 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 1611 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11282 "ConfigurationInterfaces.c"
	}
	goto __finally193;
	__catch193_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 1610 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1610 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1613 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1613 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("Sans Bold 12");
#line 1617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 1617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11306 "ConfigurationInterfaces.c"
	}
	__finally193:
#line 1610 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1610 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1610 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 11315 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_printing_titles_font (ConfigurationFacade* self) {
#line 1609 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 1609 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_titles_font (self);
#line 11324 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_titles_font (ConfigurationFacade* self, const gchar* font_name) {
	GError * _inner_error_ = NULL;
#line 1621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (font_name != NULL);
#line 11332 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
#line 1623 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1623 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1623 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = font_name;
#line 1623 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT, _tmp2_, &_inner_error_);
#line 1623 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1623 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1623 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11351 "ConfigurationInterfaces.c"
				goto __catch194_configuration_error;
			}
#line 1623 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1623 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1623 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 11360 "ConfigurationInterfaces.c"
		}
	}
	goto __finally194;
	__catch194_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1622 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1622 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1622 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 11378 "ConfigurationInterfaces.c"
	}
	__finally194:
#line 1622 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1622 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1622 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1622 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 11389 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_titles_font (ConfigurationFacade* self, const gchar* font_name) {
#line 1621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_titles_font (self, font_name);
#line 11399 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_show_welcome_dialog (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG, &_inner_error_);
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 11427 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11431 "ConfigurationInterfaces.c"
				goto __catch195_configuration_error;
			}
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 11440 "ConfigurationInterfaces.c"
		}
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11446 "ConfigurationInterfaces.c"
	}
	goto __finally195;
	__catch195_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1633 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1633 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1636 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 1638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11467 "ConfigurationInterfaces.c"
	}
	__finally195:
#line 1633 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1633 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1633 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 11476 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_show_welcome_dialog (ConfigurationFacade* self) {
#line 1632 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1632 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_show_welcome_dialog (self);
#line 11485 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_show_welcome_dialog (ConfigurationFacade* self, gboolean show) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 1644 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1644 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1644 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = show;
#line 1644 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG, _tmp2_, &_inner_error_);
#line 1644 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1644 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1644 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11509 "ConfigurationInterfaces.c"
				goto __catch196_configuration_error;
			}
#line 1644 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1644 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1644 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 11518 "ConfigurationInterfaces.c"
		}
	}
	goto __finally196;
	__catch196_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 11536 "ConfigurationInterfaces.c"
	}
	__finally196:
#line 1643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 11547 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_show_welcome_dialog (ConfigurationFacade* self, gboolean show) {
#line 1642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_show_welcome_dialog (self, show);
#line 11557 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_sidebar_position (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 1656 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1656 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1656 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_SIDEBAR_POSITION, &_inner_error_);
#line 1656 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1656 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1656 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1656 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 11585 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1656 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11589 "ConfigurationInterfaces.c"
				goto __catch197_configuration_error;
			}
#line 1656 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1656 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1656 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 11598 "ConfigurationInterfaces.c"
		}
#line 1656 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1656 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11604 "ConfigurationInterfaces.c"
	}
	goto __finally197;
	__catch197_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1655 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1655 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1658 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1660 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 180;
#line 1660 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1660 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11625 "ConfigurationInterfaces.c"
	}
	__finally197:
#line 1655 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1655 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1655 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 11634 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_sidebar_position (ConfigurationFacade* self) {
#line 1654 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1654 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_sidebar_position (self);
#line 11643 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_sidebar_position (ConfigurationFacade* self, gint position) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1666 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1666 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1666 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = position;
#line 1666 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_SIDEBAR_POSITION, _tmp2_, &_inner_error_);
#line 1666 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1666 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1666 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11667 "ConfigurationInterfaces.c"
				goto __catch198_configuration_error;
			}
#line 1666 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1666 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1666 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 11676 "ConfigurationInterfaces.c"
		}
	}
	goto __finally198;
	__catch198_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1665 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1665 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1668 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1668 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1665 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 11694 "ConfigurationInterfaces.c"
	}
	__finally198:
#line 1665 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1665 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1665 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1665 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 11705 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_sidebar_position (ConfigurationFacade* self, gint position) {
#line 1664 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1664 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_sidebar_position (self, position);
#line 11715 "ConfigurationInterfaces.c"
}


static gdouble configuration_facade_real_get_slideshow_delay (ConfigurationFacade* self) {
	gdouble result = 0.0;
	gdouble _tmp7_ = 0.0;
	GError * _inner_error_ = NULL;
	{
		gdouble _tmp0_ = 0.0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gdouble _tmp3_;
		gdouble _tmp4_;
#line 1677 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1677 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1677 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_double_property (_tmp2_, CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY, &_inner_error_);
#line 1677 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1677 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1677 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1677 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 11743 "ConfigurationInterfaces.c"
			gdouble _tmp5_ = 0.0;
#line 1677 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11747 "ConfigurationInterfaces.c"
				goto __catch199_configuration_error;
			}
#line 1677 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1677 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1677 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 11756 "ConfigurationInterfaces.c"
		}
#line 1677 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1677 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11762 "ConfigurationInterfaces.c"
	}
	goto __finally199;
	__catch199_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1676 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1676 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1679 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1679 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1681 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 3.0;
#line 1681 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1681 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11783 "ConfigurationInterfaces.c"
	}
	__finally199:
#line 1676 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1676 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1676 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 11792 "ConfigurationInterfaces.c"
}


gdouble configuration_facade_get_slideshow_delay (ConfigurationFacade* self) {
#line 1675 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
#line 1675 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_slideshow_delay (self);
#line 11801 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_slideshow_delay (ConfigurationFacade* self, gdouble delay) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gdouble _tmp2_;
#line 1687 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1687 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1687 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = delay;
#line 1687 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_double_property (_tmp1_, CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY, _tmp2_, &_inner_error_);
#line 1687 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1687 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1687 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11825 "ConfigurationInterfaces.c"
				goto __catch200_configuration_error;
			}
#line 1687 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1687 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1687 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 11834 "ConfigurationInterfaces.c"
		}
	}
	goto __finally200;
	__catch200_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1686 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1686 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1689 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1689 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1686 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 11852 "ConfigurationInterfaces.c"
	}
	__finally200:
#line 1686 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1686 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1686 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1686 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 11863 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_slideshow_delay (ConfigurationFacade* self, gdouble delay) {
#line 1685 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1685 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_slideshow_delay (self, delay);
#line 11873 "ConfigurationInterfaces.c"
}


static gdouble configuration_facade_real_get_slideshow_transition_delay (ConfigurationFacade* self) {
	gdouble result = 0.0;
	gdouble _tmp7_ = 0.0;
	GError * _inner_error_ = NULL;
	{
		gdouble _tmp0_ = 0.0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gdouble _tmp3_;
		gdouble _tmp4_;
#line 1698 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1698 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1698 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_double_property (_tmp2_, CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY, &_inner_error_);
#line 1698 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1698 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1698 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1698 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 11901 "ConfigurationInterfaces.c"
			gdouble _tmp5_ = 0.0;
#line 1698 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11905 "ConfigurationInterfaces.c"
				goto __catch201_configuration_error;
			}
#line 1698 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1698 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1698 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 11914 "ConfigurationInterfaces.c"
		}
#line 1698 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1698 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11920 "ConfigurationInterfaces.c"
	}
	goto __finally201;
	__catch201_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1697 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1697 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1701 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1703 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0.3;
#line 1703 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1703 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11941 "ConfigurationInterfaces.c"
	}
	__finally201:
#line 1697 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1697 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1697 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 11950 "ConfigurationInterfaces.c"
}


gdouble configuration_facade_get_slideshow_transition_delay (ConfigurationFacade* self) {
#line 1696 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
#line 1696 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_slideshow_transition_delay (self);
#line 11959 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_slideshow_transition_delay (ConfigurationFacade* self, gdouble delay) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gdouble _tmp2_;
#line 1709 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1709 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1709 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = delay;
#line 1709 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_double_property (_tmp1_, CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY, _tmp2_, &_inner_error_);
#line 1709 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1709 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1709 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11983 "ConfigurationInterfaces.c"
				goto __catch202_configuration_error;
			}
#line 1709 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1709 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1709 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 11992 "ConfigurationInterfaces.c"
		}
	}
	goto __finally202;
	__catch202_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1708 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1708 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1712 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1712 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1708 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 12010 "ConfigurationInterfaces.c"
	}
	__finally202:
#line 1708 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1708 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1708 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1708 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 12021 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_slideshow_transition_delay (ConfigurationFacade* self, gdouble delay) {
#line 1707 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1707 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_slideshow_transition_delay (self, delay);
#line 12031 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_slideshow_transition_effect_id (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
#line 1721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID, &_inner_error_);
#line 1721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 12061 "ConfigurationInterfaces.c"
				goto __catch203_configuration_error;
			}
#line 1721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 12070 "ConfigurationInterfaces.c"
		}
#line 1721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 1721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 1721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 1721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 1721 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 12082 "ConfigurationInterfaces.c"
	}
	goto __finally203;
	__catch203_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		gchar* _tmp7_;
#line 1720 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1720 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1724 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1724 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1728 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup (TRANSITION_EFFECTS_MANAGER_NULL_EFFECT_ID);
#line 1728 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 1728 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1728 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 12106 "ConfigurationInterfaces.c"
	}
	__finally203:
#line 1720 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1720 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1720 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 12115 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_slideshow_transition_effect_id (ConfigurationFacade* self) {
#line 1719 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 1719 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_slideshow_transition_effect_id (self);
#line 12124 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_slideshow_transition_effect_id (ConfigurationFacade* self, const gchar* id) {
	GError * _inner_error_ = NULL;
#line 1732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 12132 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		const gchar* _tmp2_;
#line 1734 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1734 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1734 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = id;
#line 1734 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID, _tmp2_, &_inner_error_);
#line 1734 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1734 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1734 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 12151 "ConfigurationInterfaces.c"
				goto __catch204_configuration_error;
			}
#line 1734 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1734 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1734 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 12160 "ConfigurationInterfaces.c"
		}
	}
	goto __finally204;
	__catch204_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1733 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1733 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1737 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1737 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1733 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 12178 "ConfigurationInterfaces.c"
	}
	__finally204:
#line 1733 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1733 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1733 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1733 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 12189 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_slideshow_transition_effect_id (ConfigurationFacade* self, const gchar* id) {
#line 1732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1732 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_slideshow_transition_effect_id (self, id);
#line 12199 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_slideshow_show_title (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 1746 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1746 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1746 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE, &_inner_error_);
#line 1746 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1746 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1746 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1746 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 12227 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 1746 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 12231 "ConfigurationInterfaces.c"
				goto __catch205_configuration_error;
			}
#line 1746 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1746 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1746 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 12240 "ConfigurationInterfaces.c"
		}
#line 1746 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1746 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 12246 "ConfigurationInterfaces.c"
	}
	goto __finally205;
	__catch205_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1745 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1745 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1748 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1748 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1750 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 1750 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1750 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 12267 "ConfigurationInterfaces.c"
	}
	__finally205:
#line 1745 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1745 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1745 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 12276 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_slideshow_show_title (ConfigurationFacade* self) {
#line 1744 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1744 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_slideshow_show_title (self);
#line 12285 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_slideshow_show_title (ConfigurationFacade* self, gboolean show_title) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 1756 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1756 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1756 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = show_title;
#line 1756 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE, _tmp2_, &_inner_error_);
#line 1756 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1756 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1756 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 12309 "ConfigurationInterfaces.c"
				goto __catch206_configuration_error;
			}
#line 1756 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1756 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1756 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 12318 "ConfigurationInterfaces.c"
		}
	}
	goto __finally206;
	__catch206_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1755 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1755 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1758 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1758 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1755 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 12336 "ConfigurationInterfaces.c"
	}
	__finally206:
#line 1755 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1755 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1755 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1755 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 12347 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_slideshow_show_title (ConfigurationFacade* self, gboolean show_title) {
#line 1754 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1754 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_slideshow_show_title (self, show_title);
#line 12357 "ConfigurationInterfaces.c"
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
#line 2846 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	localtime_r (&time, &_tmp0_);
#line 2846 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 2847 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	*result = _result_;
#line 2847 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return;
#line 12372 "ConfigurationInterfaces.c"
}


static gchar* g_time_format (struct tm *self, const gchar* format) {
	gchar* result = NULL;
	gchar* buffer = NULL;
	gchar* _tmp0_;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
#line 2854 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (format != NULL, NULL);
#line 2855 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 64);
#line 2855 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	buffer = _tmp0_;
#line 2855 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	buffer_length1 = 64;
#line 2855 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_buffer_size_ = buffer_length1;
#line 2856 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = buffer;
#line 2856 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1__length1 = buffer_length1;
#line 2856 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp2_ = format;
#line 2856 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	strftime (_tmp1_, _tmp1__length1, _tmp2_, &(*self));
#line 2857 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = buffer;
#line 2857 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3__length1 = buffer_length1;
#line 2857 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
#line 2857 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 2857 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	buffer = (g_free (buffer), NULL);
#line 2857 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 12418 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_use_24_hour_time (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp12_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 1767 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1767 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1767 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME, &_inner_error_);
#line 1767 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1767 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1767 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1767 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 12446 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 1767 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 12450 "ConfigurationInterfaces.c"
				goto __catch207_configuration_error;
			}
#line 1767 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1767 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1767 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 12459 "ConfigurationInterfaces.c"
		}
#line 1767 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1767 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 12465 "ConfigurationInterfaces.c"
	}
	goto __finally207;
	__catch207_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		struct tm _tmp7_ = {0};
		gchar* _tmp8_;
		gchar* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
#line 1766 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1766 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1769 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1769 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1773 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_time_local ((time_t) 0, &_tmp7_);
#line 1773 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = g_time_format (&_tmp7_, "%p");
#line 1773 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = _tmp8_;
#line 1773 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = is_string_empty (_tmp9_);
#line 1773 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp11_ = _tmp10_;
#line 1773 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp9_);
#line 1773 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp11_;
#line 1773 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1773 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 12503 "ConfigurationInterfaces.c"
	}
	__finally207:
#line 1766 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1766 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1766 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp12_;
#line 12512 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_use_24_hour_time (ConfigurationFacade* self) {
#line 1765 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1765 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_use_24_hour_time (self);
#line 12521 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_use_24_hour_time (ConfigurationFacade* self, gboolean use_24_hour_time) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 1779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = use_24_hour_time;
#line 1779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME, _tmp2_, &_inner_error_);
#line 1779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 12545 "ConfigurationInterfaces.c"
				goto __catch208_configuration_error;
			}
#line 1779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 12554 "ConfigurationInterfaces.c"
		}
	}
	goto __finally208;
	__catch208_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1781 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1781 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 12572 "ConfigurationInterfaces.c"
	}
	__finally208:
#line 1778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 12583 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_use_24_hour_time (ConfigurationFacade* self, gboolean use_24_hour_time) {
#line 1777 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1777 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_use_24_hour_time (self, use_24_hour_time);
#line 12593 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_use_lowercase_filenames (ConfigurationFacade* self) {
	gboolean result = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 1790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES, &_inner_error_);
#line 1790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 12621 "ConfigurationInterfaces.c"
			gboolean _tmp5_ = FALSE;
#line 1790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 12625 "ConfigurationInterfaces.c"
				goto __catch209_configuration_error;
			}
#line 1790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 12634 "ConfigurationInterfaces.c"
		}
#line 1790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 12640 "ConfigurationInterfaces.c"
	}
	goto __finally209;
	__catch209_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1789 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1789 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1792 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1792 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 1794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 12661 "ConfigurationInterfaces.c"
	}
	__finally209:
#line 1789 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1789 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1789 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 12670 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_use_lowercase_filenames (ConfigurationFacade* self) {
#line 1788 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1788 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_use_lowercase_filenames (self);
#line 12679 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_use_lowercase_filenames (ConfigurationFacade* self, gboolean b) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gboolean _tmp2_;
#line 1800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = b;
#line 1800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES, _tmp2_, &_inner_error_);
#line 1800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 12703 "ConfigurationInterfaces.c"
				goto __catch210_configuration_error;
			}
#line 1800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 12712 "ConfigurationInterfaces.c"
		}
	}
	goto __finally210;
	__catch210_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1799 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1799 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1802 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1802 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1799 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 12730 "ConfigurationInterfaces.c"
	}
	__finally210:
#line 1799 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1799 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1799 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1799 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 12741 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_use_lowercase_filenames (ConfigurationFacade* self, gboolean b) {
#line 1798 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1798 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_use_lowercase_filenames (self, b);
#line 12751 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_video_interpreter_state_cookie (ConfigurationFacade* self) {
	gint result = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_;
		ConfigurationEngine* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 1811 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1811 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1811 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE, &_inner_error_);
#line 1811 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1811 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1811 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1811 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 12779 "ConfigurationInterfaces.c"
			gint _tmp5_ = 0;
#line 1811 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 12783 "ConfigurationInterfaces.c"
				goto __catch211_configuration_error;
			}
#line 1811 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1811 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1811 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return _tmp5_;
#line 12792 "ConfigurationInterfaces.c"
		}
#line 1811 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1811 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 12798 "ConfigurationInterfaces.c"
	}
	goto __finally211;
	__catch211_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
#line 1810 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1810 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1814 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1814 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = -1;
#line 1816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 12819 "ConfigurationInterfaces.c"
	}
	__finally211:
#line 1810 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1810 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1810 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return _tmp7_;
#line 12828 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_video_interpreter_state_cookie (ConfigurationFacade* self) {
#line 1809 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1809 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_video_interpreter_state_cookie (self);
#line 12837 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_video_interpreter_state_cookie (ConfigurationFacade* self, gint state_cookie) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_;
		ConfigurationEngine* _tmp1_;
		gint _tmp2_;
#line 1822 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1822 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1822 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = state_cookie;
#line 1822 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE, _tmp2_, &_inner_error_);
#line 1822 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1822 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1822 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 12861 "ConfigurationInterfaces.c"
				goto __catch212_configuration_error;
			}
#line 1822 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1822 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1822 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 12870 "ConfigurationInterfaces.c"
		}
	}
	goto __finally212;
	__catch212_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
#line 1821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1825 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1825 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 12888 "ConfigurationInterfaces.c"
	}
	__finally212:
#line 1821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1821 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 12899 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_video_interpreter_state_cookie (ConfigurationFacade* self, gint state_cookie) {
#line 1820 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1820 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_video_interpreter_state_cookie (self, state_cookie);
#line 12909 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def) {
	gboolean result = FALSE;
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
#line 1832 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (domain != NULL, FALSE);
#line 1832 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (id != NULL, FALSE);
#line 1832 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 1833 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1833 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1833 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1833 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1833 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1833 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = def;
#line 1833 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp6_ = configuration_engine_get_plugin_bool (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1833 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp7_ = _tmp6_;
#line 1833 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 1833 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp7_;
#line 1833 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 12951 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def) {
#line 1832 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1832 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_plugin_bool (self, domain, id, key, def);
#line 12960 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val) {
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
#line 1836 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (domain != NULL);
#line 1836 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1836 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (key != NULL);
#line 1837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = val;
#line 1837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_set_plugin_bool (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 12993 "ConfigurationInterfaces.c"
}


void configuration_facade_set_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val) {
#line 1836 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1836 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_plugin_bool (self, domain, id, key, val);
#line 13002 "ConfigurationInterfaces.c"
}


static gdouble configuration_facade_real_get_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def) {
	gdouble result = 0.0;
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
#line 1840 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (domain != NULL, 0.0);
#line 1840 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (id != NULL, 0.0);
#line 1840 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (key != NULL, 0.0);
#line 1841 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1841 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1841 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1841 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1841 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1841 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = def;
#line 1841 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp6_ = configuration_engine_get_plugin_double (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1841 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp7_ = _tmp6_;
#line 1841 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 1841 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp7_;
#line 1841 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 13044 "ConfigurationInterfaces.c"
}


gdouble configuration_facade_get_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def) {
#line 1840 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
#line 1840 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_plugin_double (self, domain, id, key, def);
#line 13053 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val) {
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gdouble _tmp5_;
#line 1844 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (domain != NULL);
#line 1844 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1844 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (key != NULL);
#line 1845 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1845 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1845 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1845 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1845 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1845 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = val;
#line 1845 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_set_plugin_double (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1845 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 13086 "ConfigurationInterfaces.c"
}


void configuration_facade_set_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val) {
#line 1844 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1844 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_plugin_double (self, domain, id, key, val);
#line 13095 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint def) {
	gint result = 0;
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
#line 1848 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (domain != NULL, 0);
#line 1848 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (id != NULL, 0);
#line 1848 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (key != NULL, 0);
#line 1849 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1849 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1849 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1849 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1849 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1849 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = def;
#line 1849 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp6_ = configuration_engine_get_plugin_int (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1849 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp7_ = _tmp6_;
#line 1849 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 1849 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp7_;
#line 1849 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 13137 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint def) {
#line 1848 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1848 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_plugin_int (self, domain, id, key, def);
#line 13146 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint val) {
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_;
#line 1852 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (domain != NULL);
#line 1852 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1852 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (key != NULL);
#line 1853 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1853 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1853 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1853 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1853 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1853 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = val;
#line 1853 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_set_plugin_int (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1853 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 13179 "ConfigurationInterfaces.c"
}


void configuration_facade_set_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint val) {
#line 1852 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1852 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_plugin_int (self, domain, id, key, val);
#line 13188 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_;
	gchar* _tmp11_;
#line 1856 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (domain != NULL, NULL);
#line 1856 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 1856 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 1857 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1857 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1857 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1857 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1857 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1857 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = def;
#line 1857 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp6_ = configuration_engine_get_plugin_string (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1857 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp7_ = _tmp6_;
#line 1857 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 1857 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_result_ = _tmp7_;
#line 1858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp9_ = _result_;
#line 1858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (g_strcmp0 (_tmp9_, "") == 0) {
#line 1858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = NULL;
#line 13238 "ConfigurationInterfaces.c"
	} else {
		const gchar* _tmp10_;
#line 1858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = _result_;
#line 1858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp10_;
#line 13245 "ConfigurationInterfaces.c"
	}
#line 1858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp11_ = g_strdup (_tmp8_);
#line 1858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp11_;
#line 1858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_free0 (_result_);
#line 1858 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 13255 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def) {
#line 1856 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 1856 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_plugin_string (self, domain, id, key, def);
#line 13264 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val) {
	const gchar* _tmp0_;
	ConfigurationEngine* _tmp1_;
	ConfigurationEngine* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
#line 1861 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (domain != NULL);
#line 1861 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1861 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (key != NULL);
#line 1862 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = val;
#line 1862 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (_tmp0_ == NULL) {
#line 1863 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		val = "";
#line 13288 "ConfigurationInterfaces.c"
	}
#line 1865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = configuration_facade_get_engine (self);
#line 1865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = _tmp1_;
#line 1865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = domain;
#line 1865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = id;
#line 1865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = key;
#line 1865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp6_ = val;
#line 1865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_set_plugin_string (_tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_);
#line 1865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp2_);
#line 13306 "ConfigurationInterfaces.c"
}


void configuration_facade_set_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val) {
#line 1861 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1861 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_plugin_string (self, domain, id, key, val);
#line 13315 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_unset_plugin_key (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key) {
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
#line 1868 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (domain != NULL);
#line 1868 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1868 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (key != NULL);
#line 1869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_unset_plugin_key (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 1869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 13345 "ConfigurationInterfaces.c"
}


void configuration_facade_unset_plugin_key (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key) {
#line 1868 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1868 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->unset_plugin_key (self, domain, id, key);
#line 13354 "ConfigurationInterfaces.c"
}


static FuzzyPropertyState configuration_facade_real_is_plugin_enabled (ConfigurationFacade* self, const gchar* id) {
	FuzzyPropertyState result = 0;
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	const gchar* _tmp2_;
	FuzzyPropertyState _tmp3_;
	FuzzyPropertyState _tmp4_;
#line 1875 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (id != NULL, 0);
#line 1876 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1876 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1876 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = id;
#line 1876 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = configuration_engine_is_plugin_enabled (_tmp1_, _tmp2_);
#line 1876 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = _tmp3_;
#line 1876 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 1876 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp4_;
#line 1876 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 13383 "ConfigurationInterfaces.c"
}


FuzzyPropertyState configuration_facade_is_plugin_enabled (ConfigurationFacade* self, const gchar* id) {
#line 1875 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1875 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->is_plugin_enabled (self, id);
#line 13392 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_plugin_enabled (ConfigurationFacade* self, const gchar* id, gboolean enabled) {
	ConfigurationEngine* _tmp0_;
	ConfigurationEngine* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
#line 1879 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1880 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1880 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1880 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = id;
#line 1880 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = enabled;
#line 1880 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_set_plugin_enabled (_tmp1_, _tmp2_, _tmp3_);
#line 1880 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 13415 "ConfigurationInterfaces.c"
}


void configuration_facade_set_plugin_enabled (ConfigurationFacade* self, const gchar* id, gboolean enabled) {
#line 1879 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1879 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_plugin_enabled (self, id, enabled);
#line 13424 "ConfigurationInterfaces.c"
}


static void configuration_facade_class_init (ConfigurationFacadeClass * klass) {
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_facade_parent_class = g_type_class_peek_parent (klass);
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_type_class_add_private (klass, sizeof (ConfigurationFacadePrivate));
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_auto_import_from_library = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_auto_import_from_library;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_auto_import_from_library = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_auto_import_from_library;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_bg_color_name = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_bg_color_name;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_bg_color_name = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_bg_color_name;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_transparent_background_type = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_transparent_background_type;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_transparent_background_type = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_transparent_background_type;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_transparent_background_color = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_transparent_background_color;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_transparent_background_color = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_transparent_background_color;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_commit_metadata_to_masters = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_commit_metadata_to_masters;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_commit_metadata_to_masters = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_commit_metadata_to_masters;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_desktop_background = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_desktop_background;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_desktop_background = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_desktop_background;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_screensaver = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_screensaver;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_screensaver = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_screensaver;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_directory_pattern = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_directory_pattern;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_directory_pattern = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_directory_pattern;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_directory_pattern_custom = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_directory_pattern_custom;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_directory_pattern_custom = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_directory_pattern_custom;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_direct_window_state = (void (*) (ConfigurationFacade *, gboolean*, Dimensions*)) configuration_facade_real_get_direct_window_state;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_direct_window_state = (void (*) (ConfigurationFacade *, gboolean, Dimensions*)) configuration_facade_real_set_direct_window_state;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_basic_properties = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_display_basic_properties;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_basic_properties = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_display_basic_properties;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_extended_properties = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_display_extended_properties;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_extended_properties = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_display_extended_properties;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_sidebar = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_display_sidebar;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_sidebar = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_display_sidebar;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_toolbar = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_display_toolbar;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_toolbar = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_display_toolbar;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_search_bar = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_display_search_bar;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_search_bar = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_display_search_bar;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_photo_ratings = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_display_photo_ratings;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_photo_ratings = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_display_photo_ratings;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_photo_tags = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_display_photo_tags;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_photo_tags = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_display_photo_tags;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_photo_titles = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_display_photo_titles;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_photo_titles = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_display_photo_titles;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_photo_comments = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_display_photo_comments;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_photo_comments = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_display_photo_comments;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_event_comments = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_display_event_comments;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_event_comments = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_display_event_comments;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_event_photos_sort = (void (*) (ConfigurationFacade *, gboolean*, gint*)) configuration_facade_real_get_event_photos_sort;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_event_photos_sort = (void (*) (ConfigurationFacade *, gboolean, gint)) configuration_facade_real_set_event_photos_sort;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_events_sort_ascending = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_events_sort_ascending;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_events_sort_ascending = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_events_sort_ascending;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_external_photo_app = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_external_photo_app;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_external_photo_app = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_external_photo_app;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_external_raw_app = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_external_raw_app;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_external_raw_app = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_external_raw_app;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_export_constraint = (ScaleConstraint (*) (ConfigurationFacade *)) configuration_facade_real_get_export_constraint;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_export_constraint = (void (*) (ConfigurationFacade *, ScaleConstraint)) configuration_facade_real_set_export_constraint;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_export_export_format_mode = (ExportFormatMode (*) (ConfigurationFacade *)) configuration_facade_real_get_export_export_format_mode;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_export_export_format_mode = (void (*) (ConfigurationFacade *, ExportFormatMode)) configuration_facade_real_set_export_export_format_mode;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_export_export_metadata = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_export_export_metadata;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_export_export_metadata = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_export_export_metadata;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_export_photo_file_format = (PhotoFileFormat (*) (ConfigurationFacade *)) configuration_facade_real_get_export_photo_file_format;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_export_photo_file_format = (void (*) (ConfigurationFacade *, PhotoFileFormat)) configuration_facade_real_set_export_photo_file_format;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_export_quality = (JpegQuality (*) (ConfigurationFacade *)) configuration_facade_real_get_export_quality;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_export_quality = (void (*) (ConfigurationFacade *, JpegQuality)) configuration_facade_real_set_export_quality;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_export_scale = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_export_scale;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_export_scale = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_export_scale;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_default_raw_developer = (RawDeveloper (*) (ConfigurationFacade *)) configuration_facade_real_get_default_raw_developer;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_default_raw_developer = (void (*) (ConfigurationFacade *, RawDeveloper)) configuration_facade_real_set_default_raw_developer;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_hide_photos_already_imported = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_hide_photos_already_imported;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_hide_photos_already_imported = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_hide_photos_already_imported;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_import_dir = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_import_dir;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_import_dir = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_import_dir;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_keep_relativity = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_keep_relativity;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_keep_relativity = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_keep_relativity;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_pin_toolbar_state = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_pin_toolbar_state;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_pin_toolbar_state = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_pin_toolbar_state;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_last_crop_height = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_last_crop_height;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_last_crop_height = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_last_crop_height;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_last_crop_menu_choice = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_last_crop_menu_choice;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_last_crop_menu_choice = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_last_crop_menu_choice;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_last_crop_width = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_last_crop_width;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_last_crop_width = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_last_crop_width;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_last_used_service = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_last_used_service;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_last_used_service = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_last_used_service;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_last_used_dataimports_service = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_last_used_dataimports_service;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_last_used_dataimports_service = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_last_used_dataimports_service;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_library_photos_sort = (void (*) (ConfigurationFacade *, gboolean*, gint*)) configuration_facade_real_get_library_photos_sort;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_library_photos_sort = (void (*) (ConfigurationFacade *, gboolean, gint)) configuration_facade_real_set_library_photos_sort;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_library_window_state = (void (*) (ConfigurationFacade *, gboolean*, Dimensions*)) configuration_facade_real_get_library_window_state;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_library_window_state = (void (*) (ConfigurationFacade *, gboolean, Dimensions*)) configuration_facade_real_set_library_window_state;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_modify_originals = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_modify_originals;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_modify_originals = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_modify_originals;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_photo_thumbnail_scale = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_photo_thumbnail_scale;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_photo_thumbnail_scale = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_photo_thumbnail_scale;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_content_height = (gdouble (*) (ConfigurationFacade *)) configuration_facade_real_get_printing_content_height;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_content_height = (void (*) (ConfigurationFacade *, gdouble)) configuration_facade_real_set_printing_content_height;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_content_layout = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_printing_content_layout;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_content_layout = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_printing_content_layout;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_content_ppi = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_printing_content_ppi;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_content_ppi = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_printing_content_ppi;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_content_units = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_printing_content_units;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_content_units = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_printing_content_units;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_content_width = (gdouble (*) (ConfigurationFacade *)) configuration_facade_real_get_printing_content_width;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_content_width = (void (*) (ConfigurationFacade *, gdouble)) configuration_facade_real_set_printing_content_width;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_images_per_page = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_printing_images_per_page;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_images_per_page = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_printing_images_per_page;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_match_aspect_ratio = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_printing_match_aspect_ratio;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_match_aspect_ratio = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_printing_match_aspect_ratio;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_print_titles = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_printing_print_titles;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_print_titles = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_printing_print_titles;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_size_selection = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_printing_size_selection;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_size_selection = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_printing_size_selection;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_titles_font = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_printing_titles_font;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_titles_font = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_printing_titles_font;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_show_welcome_dialog = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_show_welcome_dialog;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_show_welcome_dialog = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_show_welcome_dialog;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_sidebar_position = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_sidebar_position;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_sidebar_position = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_sidebar_position;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_slideshow_delay = (gdouble (*) (ConfigurationFacade *)) configuration_facade_real_get_slideshow_delay;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_slideshow_delay = (void (*) (ConfigurationFacade *, gdouble)) configuration_facade_real_set_slideshow_delay;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_slideshow_transition_delay = (gdouble (*) (ConfigurationFacade *)) configuration_facade_real_get_slideshow_transition_delay;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_slideshow_transition_delay = (void (*) (ConfigurationFacade *, gdouble)) configuration_facade_real_set_slideshow_transition_delay;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_slideshow_transition_effect_id = (gchar* (*) (ConfigurationFacade *)) configuration_facade_real_get_slideshow_transition_effect_id;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_slideshow_transition_effect_id = (void (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_set_slideshow_transition_effect_id;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_slideshow_show_title = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_slideshow_show_title;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_slideshow_show_title = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_slideshow_show_title;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_use_24_hour_time = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_use_24_hour_time;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_use_24_hour_time = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_use_24_hour_time;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_use_lowercase_filenames = (gboolean (*) (ConfigurationFacade *)) configuration_facade_real_get_use_lowercase_filenames;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_use_lowercase_filenames = (void (*) (ConfigurationFacade *, gboolean)) configuration_facade_real_set_use_lowercase_filenames;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_video_interpreter_state_cookie = (gint (*) (ConfigurationFacade *)) configuration_facade_real_get_video_interpreter_state_cookie;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_video_interpreter_state_cookie = (void (*) (ConfigurationFacade *, gint)) configuration_facade_real_set_video_interpreter_state_cookie;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_plugin_bool = (gboolean (*) (ConfigurationFacade *, const gchar*, const gchar*, const gchar*, gboolean)) configuration_facade_real_get_plugin_bool;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_plugin_bool = (void (*) (ConfigurationFacade *, const gchar*, const gchar*, const gchar*, gboolean)) configuration_facade_real_set_plugin_bool;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_plugin_double = (gdouble (*) (ConfigurationFacade *, const gchar*, const gchar*, const gchar*, gdouble)) configuration_facade_real_get_plugin_double;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_plugin_double = (void (*) (ConfigurationFacade *, const gchar*, const gchar*, const gchar*, gdouble)) configuration_facade_real_set_plugin_double;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_plugin_int = (gint (*) (ConfigurationFacade *, const gchar*, const gchar*, const gchar*, gint)) configuration_facade_real_get_plugin_int;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_plugin_int = (void (*) (ConfigurationFacade *, const gchar*, const gchar*, const gchar*, gint)) configuration_facade_real_set_plugin_int;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_plugin_string = (gchar* (*) (ConfigurationFacade *, const gchar*, const gchar*, const gchar*, const gchar*)) configuration_facade_real_get_plugin_string;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_plugin_string = (void (*) (ConfigurationFacade *, const gchar*, const gchar*, const gchar*, const gchar*)) configuration_facade_real_set_plugin_string;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->unset_plugin_key = (void (*) (ConfigurationFacade *, const gchar*, const gchar*, const gchar*)) configuration_facade_real_unset_plugin_key;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->is_plugin_enabled = (FuzzyPropertyState (*) (ConfigurationFacade *, const gchar*)) configuration_facade_real_is_plugin_enabled;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_plugin_enabled = (void (*) (ConfigurationFacade *, const gchar*, gboolean)) configuration_facade_real_set_plugin_enabled;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	G_OBJECT_CLASS (klass)->finalize = configuration_facade_finalize;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_facade_signals[CONFIGURATION_FACADE_AUTO_IMPORT_FROM_LIBRARY_CHANGED_SIGNAL] = g_signal_new ("auto-import-from-library-changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_facade_signals[CONFIGURATION_FACADE_BG_COLOR_NAME_CHANGED_SIGNAL] = g_signal_new ("bg-color-name-changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_facade_signals[CONFIGURATION_FACADE_TRANSPARENT_BACKGROUND_TYPE_CHANGED_SIGNAL] = g_signal_new ("transparent-background-type-changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_facade_signals[CONFIGURATION_FACADE_TRANSPARENT_BACKGROUND_COLOR_CHANGED_SIGNAL] = g_signal_new ("transparent-background-color-changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_facade_signals[CONFIGURATION_FACADE_COMMIT_METADATA_TO_MASTERS_CHANGED_SIGNAL] = g_signal_new ("commit-metadata-to-masters-changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_facade_signals[CONFIGURATION_FACADE_EVENTS_SORT_ASCENDING_CHANGED_SIGNAL] = g_signal_new ("events-sort-ascending-changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_facade_signals[CONFIGURATION_FACADE_EXTERNAL_APP_CHANGED_SIGNAL] = g_signal_new ("external-app-changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_facade_signals[CONFIGURATION_FACADE_IMPORT_DIRECTORY_CHANGED_SIGNAL] = g_signal_new ("import-directory-changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 13725 "ConfigurationInterfaces.c"
}


static void configuration_facade_instance_init (ConfigurationFacade * self) {
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	self->priv = CONFIGURATION_FACADE_GET_PRIVATE (self);
#line 13732 "ConfigurationInterfaces.c"
}


static void configuration_facade_finalize (GObject * obj) {
	ConfigurationFacade * self;
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONFIGURATION_FACADE, ConfigurationFacade);
#line 354 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (self->priv->engine);
#line 353 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	G_OBJECT_CLASS (configuration_facade_parent_class)->finalize (obj);
#line 13744 "ConfigurationInterfaces.c"
}


GType configuration_facade_get_type (void) {
	static volatile gsize configuration_facade_type_id__volatile = 0;
	if (g_once_init_enter (&configuration_facade_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ConfigurationFacadeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) configuration_facade_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConfigurationFacade), 0, (GInstanceInitFunc) configuration_facade_instance_init, NULL };
		GType configuration_facade_type_id;
		configuration_facade_type_id = g_type_register_static (G_TYPE_OBJECT, "ConfigurationFacade", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&configuration_facade_type_id__volatile, configuration_facade_type_id);
	}
	return configuration_facade_type_id__volatile;
}



