/* RGBHistogramManipulator.c generated by valac 0.36.6, the Vala compiler
 * generated from RGBHistogramManipulator.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "shotwell-graphics-processor.h"
#include <cairo.h>
#include <gdk/gdk.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>


#define TYPE_RGB_HISTOGRAM_MANIPULATOR (rgb_histogram_manipulator_get_type ())
#define RGB_HISTOGRAM_MANIPULATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RGB_HISTOGRAM_MANIPULATOR, RGBHistogramManipulator))
#define RGB_HISTOGRAM_MANIPULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RGB_HISTOGRAM_MANIPULATOR, RGBHistogramManipulatorClass))
#define IS_RGB_HISTOGRAM_MANIPULATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RGB_HISTOGRAM_MANIPULATOR))
#define IS_RGB_HISTOGRAM_MANIPULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RGB_HISTOGRAM_MANIPULATOR))
#define RGB_HISTOGRAM_MANIPULATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RGB_HISTOGRAM_MANIPULATOR, RGBHistogramManipulatorClass))

typedef struct _RGBHistogramManipulator RGBHistogramManipulator;
typedef struct _RGBHistogramManipulatorClass RGBHistogramManipulatorClass;
typedef struct _RGBHistogramManipulatorPrivate RGBHistogramManipulatorPrivate;

#define RGB_HISTOGRAM_MANIPULATOR_TYPE_LOCATION_CODE (rgb_histogram_manipulator_location_code_get_type ())
#define _rgb_histogram_unref0(var) ((var == NULL) ? NULL : (var = (rgb_histogram_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	RGB_HISTOGRAM_MANIPULATOR_NUB_POSITION_CHANGED_SIGNAL,
	RGB_HISTOGRAM_MANIPULATOR_LAST_SIGNAL
};
static guint rgb_histogram_manipulator_signals[RGB_HISTOGRAM_MANIPULATOR_LAST_SIGNAL] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RGBHistogramManipulator {
	GtkDrawingArea parent_instance;
	RGBHistogramManipulatorPrivate * priv;
};

struct _RGBHistogramManipulatorClass {
	GtkDrawingAreaClass parent_class;
};

struct _RGBHistogramManipulatorPrivate {
	gint left_nub_max;
	gint right_nub_min;
	RGBHistogram* histogram;
	gint left_nub_position;
	gint right_nub_position;
	gboolean is_left_nub_tracking;
	gboolean is_right_nub_tracking;
	gint track_start_x;
	gint track_nub_start_position;
};

typedef enum  {
	RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_NUB,
	RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_NUB,
	RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_TROUGH,
	RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_TROUGH,
	RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_INSENSITIVE_AREA
} RGBHistogramManipulatorLocationCode;


static gpointer rgb_histogram_manipulator_parent_class = NULL;
static GtkWidgetPath* rgb_histogram_manipulator_slider_draw_path;
static GtkWidgetPath* rgb_histogram_manipulator_slider_draw_path = NULL;
static GtkWidgetPath* rgb_histogram_manipulator_frame_draw_path;
static GtkWidgetPath* rgb_histogram_manipulator_frame_draw_path = NULL;
static gboolean rgb_histogram_manipulator_paths_setup;
static gboolean rgb_histogram_manipulator_paths_setup = FALSE;

GType rgb_histogram_manipulator_get_type (void) G_GNUC_CONST;
#define RGB_HISTOGRAM_MANIPULATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_RGB_HISTOGRAM_MANIPULATOR, RGBHistogramManipulatorPrivate))
enum  {
	RGB_HISTOGRAM_MANIPULATOR_DUMMY_PROPERTY
};
static GType rgb_histogram_manipulator_location_code_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE 13
#define RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH (RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE / 2)
#define RGB_HISTOGRAM_MANIPULATOR_NUB_V_NUDGE 4
#define RGB_HISTOGRAM_MANIPULATOR_TROUGH_WIDTH (256 + (2 * RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH))
#define RGB_HISTOGRAM_MANIPULATOR_TROUGH_HEIGHT 4
#define RGB_HISTOGRAM_MANIPULATOR_TROUGH_BOTTOM_OFFSET 1
#define RGB_HISTOGRAM_MANIPULATOR_CONTROL_WIDTH (RGB_HISTOGRAM_MANIPULATOR_TROUGH_WIDTH + 2)
#define RGB_HISTOGRAM_MANIPULATOR_CONTROL_HEIGHT 118
#define RGB_HISTOGRAM_MANIPULATOR_NUB_V_POSITION (((((RGB_HISTOGRAM_MANIPULATOR_CONTROL_HEIGHT - RGB_HISTOGRAM_MANIPULATOR_TROUGH_HEIGHT) - RGB_HISTOGRAM_MANIPULATOR_TROUGH_BOTTOM_OFFSET) - ((RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE - RGB_HISTOGRAM_MANIPULATOR_TROUGH_HEIGHT) / 2)) - RGB_HISTOGRAM_MANIPULATOR_NUB_V_NUDGE) - 2)
RGBHistogramManipulator* rgb_histogram_manipulator_new (void);
RGBHistogramManipulator* rgb_histogram_manipulator_construct (GType object_type);
static gboolean rgb_histogram_manipulator_on_button_press (RGBHistogramManipulator* self, GdkEventButton* event_record);
static gboolean _rgb_histogram_manipulator_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean rgb_histogram_manipulator_on_button_release (RGBHistogramManipulator* self, GdkEventButton* event_record);
static gboolean _rgb_histogram_manipulator_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean rgb_histogram_manipulator_on_button_motion (RGBHistogramManipulator* self, GdkEventMotion* event_record);
static gboolean _rgb_histogram_manipulator_on_button_motion_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
static RGBHistogramManipulatorLocationCode rgb_histogram_manipulator_hit_test_point (RGBHistogramManipulator* self, gint x, gint y);
static void rgb_histogram_manipulator_force_update (RGBHistogramManipulator* self);
static void rgb_histogram_manipulator_update_nub_extrema (RGBHistogramManipulator* self);
static gboolean rgb_histogram_manipulator_real_draw (GtkWidget* base, cairo_t* ctx);
static void rgb_histogram_manipulator_draw_histogram (RGBHistogramManipulator* self, cairo_t* ctx, GdkRectangle* area);
static void rgb_histogram_manipulator_draw_nub (RGBHistogramManipulator* self, cairo_t* ctx, GdkRectangle* area, gint position);
void rgb_histogram_manipulator_update_histogram (RGBHistogramManipulator* self, GdkPixbuf* source_pixbuf);
gint rgb_histogram_manipulator_get_left_nub_position (RGBHistogramManipulator* self);
gint rgb_histogram_manipulator_get_right_nub_position (RGBHistogramManipulator* self);
void rgb_histogram_manipulator_set_left_nub_position (RGBHistogramManipulator* self, gint user_nub_pos);
void rgb_histogram_manipulator_set_right_nub_position (RGBHistogramManipulator* self, gint user_nub_pos);
static void rgb_histogram_manipulator_finalize (GObject * obj);


static GType rgb_histogram_manipulator_location_code_get_type (void) {
	static volatile gsize rgb_histogram_manipulator_location_code_type_id__volatile = 0;
	if (g_once_init_enter (&rgb_histogram_manipulator_location_code_type_id__volatile)) {
		static const GEnumValue values[] = {{RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_NUB, "RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_NUB", "left-nub"}, {RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_NUB, "RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_NUB", "right-nub"}, {RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_TROUGH, "RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_TROUGH", "left-trough"}, {RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_TROUGH, "RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_TROUGH", "right-trough"}, {RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_INSENSITIVE_AREA, "RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_INSENSITIVE_AREA", "insensitive-area"}, {0, NULL, NULL}};
		GType rgb_histogram_manipulator_location_code_type_id;
		rgb_histogram_manipulator_location_code_type_id = g_enum_register_static ("RGBHistogramManipulatorLocationCode", values);
		g_once_init_leave (&rgb_histogram_manipulator_location_code_type_id__volatile, rgb_histogram_manipulator_location_code_type_id);
	}
	return rgb_histogram_manipulator_location_code_type_id__volatile;
}


static gboolean _rgb_histogram_manipulator_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = rgb_histogram_manipulator_on_button_press ((RGBHistogramManipulator*) self, event);
#line 53 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	return result;
#line 139 "RGBHistogramManipulator.c"
}


static gboolean _rgb_histogram_manipulator_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = rgb_histogram_manipulator_on_button_release ((RGBHistogramManipulator*) self, event);
#line 54 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	return result;
#line 148 "RGBHistogramManipulator.c"
}


static gboolean _rgb_histogram_manipulator_on_button_motion_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = rgb_histogram_manipulator_on_button_motion ((RGBHistogramManipulator*) self, event);
#line 55 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	return result;
#line 157 "RGBHistogramManipulator.c"
}


RGBHistogramManipulator* rgb_histogram_manipulator_construct (GType object_type) {
	RGBHistogramManipulator * self = NULL;
	gboolean _tmp0_;
#line 35 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self = (RGBHistogramManipulator*) g_object_new (object_type, NULL);
#line 36 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), RGB_HISTOGRAM_MANIPULATOR_CONTROL_WIDTH, RGB_HISTOGRAM_MANIPULATOR_CONTROL_HEIGHT);
#line 38 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = rgb_histogram_manipulator_paths_setup;
#line 38 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (!_tmp0_) {
#line 172 "RGBHistogramManipulator.c"
		GtkWidgetPath* _tmp1_;
		GtkWidgetPath* _tmp2_;
		GtkWidgetPath* _tmp3_;
		GtkWidgetPath* _tmp4_;
		GtkWidgetPath* _tmp5_;
#line 39 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp1_ = rgb_histogram_manipulator_slider_draw_path;
#line 39 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		gtk_widget_path_append_type (_tmp1_, gtk_scale_get_type ());
#line 40 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp2_ = rgb_histogram_manipulator_slider_draw_path;
#line 40 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		gtk_widget_path_iter_add_class (_tmp2_, 0, "scale");
#line 41 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp3_ = rgb_histogram_manipulator_slider_draw_path;
#line 41 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		gtk_widget_path_iter_add_class (_tmp3_, 0, "range");
#line 43 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp4_ = rgb_histogram_manipulator_frame_draw_path;
#line 43 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		gtk_widget_path_append_type (_tmp4_, gtk_frame_get_type ());
#line 44 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp5_ = rgb_histogram_manipulator_frame_draw_path;
#line 44 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		gtk_widget_path_iter_add_class (_tmp5_, 0, "default");
#line 46 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		rgb_histogram_manipulator_paths_setup = TRUE;
#line 200 "RGBHistogramManipulator.c"
	}
#line 49 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	gtk_widget_add_events (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), (gint) GDK_BUTTON_PRESS_MASK);
#line 50 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	gtk_widget_add_events (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), (gint) GDK_BUTTON_RELEASE_MASK);
#line 51 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	gtk_widget_add_events (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), (gint) GDK_BUTTON_MOTION_MASK);
#line 53 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "button-press-event", (GCallback) _rgb_histogram_manipulator_on_button_press_gtk_widget_button_press_event, self, 0);
#line 54 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "button-release-event", (GCallback) _rgb_histogram_manipulator_on_button_release_gtk_widget_button_release_event, self, 0);
#line 55 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "motion-notify-event", (GCallback) _rgb_histogram_manipulator_on_button_motion_gtk_widget_motion_notify_event, self, 0);
#line 35 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	return self;
#line 216 "RGBHistogramManipulator.c"
}


RGBHistogramManipulator* rgb_histogram_manipulator_new (void) {
#line 35 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	return rgb_histogram_manipulator_construct (TYPE_RGB_HISTOGRAM_MANIPULATOR);
#line 223 "RGBHistogramManipulator.c"
}


static RGBHistogramManipulatorLocationCode rgb_histogram_manipulator_hit_test_point (RGBHistogramManipulator* self, gint x, gint y) {
	RGBHistogramManipulatorLocationCode result = 0;
	gint _tmp0_;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
#line 58 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_val_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self), 0);
#line 59 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = y;
#line 59 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp0_ < RGB_HISTOGRAM_MANIPULATOR_NUB_V_POSITION) {
#line 60 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_INSENSITIVE_AREA;
#line 60 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		return result;
#line 255 "RGBHistogramManipulator.c"
	}
#line 62 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp2_ = x;
#line 62 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp3_ = self->priv->left_nub_position;
#line 62 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp2_ > _tmp3_) {
#line 263 "RGBHistogramManipulator.c"
		gint _tmp4_;
		gint _tmp5_;
#line 62 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp4_ = x;
#line 62 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp5_ = self->priv->left_nub_position;
#line 62 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp1_ = _tmp4_ < (_tmp5_ + RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE);
#line 272 "RGBHistogramManipulator.c"
	} else {
#line 62 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp1_ = FALSE;
#line 276 "RGBHistogramManipulator.c"
	}
#line 62 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp1_) {
#line 63 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_NUB;
#line 63 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		return result;
#line 284 "RGBHistogramManipulator.c"
	}
#line 65 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp7_ = x;
#line 65 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp8_ = self->priv->right_nub_position;
#line 65 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp7_ > _tmp8_) {
#line 292 "RGBHistogramManipulator.c"
		gint _tmp9_;
		gint _tmp10_;
#line 65 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp9_ = x;
#line 65 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp10_ = self->priv->right_nub_position;
#line 65 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp6_ = _tmp9_ < (_tmp10_ + RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE);
#line 301 "RGBHistogramManipulator.c"
	} else {
#line 65 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp6_ = FALSE;
#line 305 "RGBHistogramManipulator.c"
	}
#line 65 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp6_) {
#line 66 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_NUB;
#line 66 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		return result;
#line 313 "RGBHistogramManipulator.c"
	}
#line 68 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp11_ = y;
#line 68 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp11_ < ((RGB_HISTOGRAM_MANIPULATOR_NUB_V_POSITION + RGB_HISTOGRAM_MANIPULATOR_NUB_V_NUDGE) + 1)) {
#line 69 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_INSENSITIVE_AREA;
#line 69 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		return result;
#line 323 "RGBHistogramManipulator.c"
	}
#line 71 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp12_ = x;
#line 71 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp13_ = self->priv->left_nub_position;
#line 71 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp14_ = x;
#line 71 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp15_ = self->priv->left_nub_position;
#line 71 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp16_ = x;
#line 71 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp17_ = self->priv->right_nub_position;
#line 71 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp18_ = x;
#line 71 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp19_ = self->priv->right_nub_position;
#line 71 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (((_tmp12_ - _tmp13_) * (_tmp14_ - _tmp15_)) < ((_tmp16_ - _tmp17_) * (_tmp18_ - _tmp19_))) {
#line 73 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_TROUGH;
#line 73 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		return result;
#line 347 "RGBHistogramManipulator.c"
	} else {
#line 75 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_TROUGH;
#line 75 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		return result;
#line 353 "RGBHistogramManipulator.c"
	}
}


static gboolean rgb_histogram_manipulator_on_button_press (RGBHistogramManipulator* self, GdkEventButton* event_record) {
	gboolean result = FALSE;
	RGBHistogramManipulatorLocationCode loc = 0;
	GdkEventButton* _tmp0_;
	gdouble _tmp1_;
	GdkEventButton* _tmp2_;
	gdouble _tmp3_;
	RGBHistogramManipulatorLocationCode _tmp4_;
	RGBHistogramManipulatorLocationCode _tmp5_;
#line 78 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_val_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self), FALSE);
#line 78 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_val_if_fail (event_record != NULL, FALSE);
#line 79 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = event_record;
#line 79 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp1_ = _tmp0_->x;
#line 79 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp2_ = event_record;
#line 79 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp3_ = _tmp2_->y;
#line 79 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp4_ = rgb_histogram_manipulator_hit_test_point (self, (gint) _tmp1_, (gint) _tmp3_);
#line 79 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	loc = _tmp4_;
#line 81 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp5_ = loc;
#line 81 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	switch (_tmp5_) {
#line 81 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		case RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_NUB:
#line 389 "RGBHistogramManipulator.c"
		{
			GdkEventButton* _tmp6_;
			gdouble _tmp7_;
			gint _tmp8_;
#line 83 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp6_ = event_record;
#line 83 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp7_ = _tmp6_->x;
#line 83 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			self->priv->track_start_x = (gint) _tmp7_;
#line 84 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp8_ = self->priv->left_nub_position;
#line 84 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			self->priv->track_nub_start_position = _tmp8_;
#line 85 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			self->priv->is_left_nub_tracking = TRUE;
#line 86 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			result = TRUE;
#line 86 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			return result;
#line 410 "RGBHistogramManipulator.c"
		}
#line 81 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		case RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_NUB:
#line 414 "RGBHistogramManipulator.c"
		{
			GdkEventButton* _tmp9_;
			gdouble _tmp10_;
			gint _tmp11_;
#line 89 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp9_ = event_record;
#line 89 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp10_ = _tmp9_->x;
#line 89 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			self->priv->track_start_x = (gint) _tmp10_;
#line 90 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp11_ = self->priv->right_nub_position;
#line 90 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			self->priv->track_nub_start_position = _tmp11_;
#line 91 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			self->priv->is_right_nub_tracking = TRUE;
#line 92 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			result = TRUE;
#line 92 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			return result;
#line 435 "RGBHistogramManipulator.c"
		}
#line 81 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		case RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_TROUGH:
#line 439 "RGBHistogramManipulator.c"
		{
			GdkEventButton* _tmp12_;
			gdouble _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
#line 95 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp12_ = event_record;
#line 95 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp13_ = _tmp12_->x;
#line 95 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			self->priv->left_nub_position = ((gint) _tmp13_) - RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH;
#line 96 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp14_ = self->priv->left_nub_position;
#line 96 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp15_ = self->priv->left_nub_max;
#line 96 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp16_ = CLAMP (_tmp14_, 0, _tmp15_);
#line 96 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			self->priv->left_nub_position = _tmp16_;
#line 97 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			rgb_histogram_manipulator_force_update (self);
#line 98 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			g_signal_emit (self, rgb_histogram_manipulator_signals[RGB_HISTOGRAM_MANIPULATOR_NUB_POSITION_CHANGED_SIGNAL], 0);
#line 99 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			rgb_histogram_manipulator_update_nub_extrema (self);
#line 100 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			result = TRUE;
#line 100 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			return result;
#line 470 "RGBHistogramManipulator.c"
		}
#line 81 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		case RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_TROUGH:
#line 474 "RGBHistogramManipulator.c"
		{
			GdkEventButton* _tmp17_;
			gdouble _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
#line 103 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp17_ = event_record;
#line 103 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp18_ = _tmp17_->x;
#line 103 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			self->priv->right_nub_position = ((gint) _tmp18_) - RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH;
#line 104 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp19_ = self->priv->right_nub_position;
#line 104 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp20_ = self->priv->right_nub_min;
#line 104 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp21_ = CLAMP (_tmp19_, _tmp20_, 255);
#line 104 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			self->priv->right_nub_position = _tmp21_;
#line 105 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			rgb_histogram_manipulator_force_update (self);
#line 106 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			g_signal_emit (self, rgb_histogram_manipulator_signals[RGB_HISTOGRAM_MANIPULATOR_NUB_POSITION_CHANGED_SIGNAL], 0);
#line 107 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			rgb_histogram_manipulator_update_nub_extrema (self);
#line 108 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			result = TRUE;
#line 108 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			return result;
#line 505 "RGBHistogramManipulator.c"
		}
		default:
		{
#line 111 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			result = FALSE;
#line 111 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			return result;
#line 513 "RGBHistogramManipulator.c"
		}
	}
}


static gboolean rgb_histogram_manipulator_on_button_release (RGBHistogramManipulator* self, GdkEventButton* event_record) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
#line 115 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_val_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self), FALSE);
#line 115 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_val_if_fail (event_record != NULL, FALSE);
#line 116 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp1_ = self->priv->is_left_nub_tracking;
#line 116 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp1_) {
#line 116 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp0_ = TRUE;
#line 533 "RGBHistogramManipulator.c"
	} else {
		gboolean _tmp2_;
#line 116 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp2_ = self->priv->is_right_nub_tracking;
#line 116 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp0_ = _tmp2_;
#line 540 "RGBHistogramManipulator.c"
	}
#line 116 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp0_) {
#line 117 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		g_signal_emit (self, rgb_histogram_manipulator_signals[RGB_HISTOGRAM_MANIPULATOR_NUB_POSITION_CHANGED_SIGNAL], 0);
#line 118 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		rgb_histogram_manipulator_update_nub_extrema (self);
#line 548 "RGBHistogramManipulator.c"
	}
#line 121 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->is_left_nub_tracking = FALSE;
#line 122 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->is_right_nub_tracking = FALSE;
#line 124 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	result = FALSE;
#line 124 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	return result;
#line 558 "RGBHistogramManipulator.c"
}


static gboolean rgb_histogram_manipulator_on_button_motion (RGBHistogramManipulator* self, GdkEventMotion* event_record) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp3_;
#line 127 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_val_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self), FALSE);
#line 127 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_val_if_fail (event_record != NULL, FALSE);
#line 128 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp1_ = self->priv->is_left_nub_tracking;
#line 128 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (!_tmp1_) {
#line 575 "RGBHistogramManipulator.c"
		gboolean _tmp2_;
#line 128 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp2_ = self->priv->is_right_nub_tracking;
#line 128 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp0_ = !_tmp2_;
#line 581 "RGBHistogramManipulator.c"
	} else {
#line 128 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp0_ = FALSE;
#line 585 "RGBHistogramManipulator.c"
	}
#line 128 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp0_) {
#line 129 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		result = FALSE;
#line 129 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		return result;
#line 593 "RGBHistogramManipulator.c"
	}
#line 131 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp3_ = self->priv->is_left_nub_tracking;
#line 131 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp3_) {
#line 599 "RGBHistogramManipulator.c"
		gint track_x_delta = 0;
		GdkEventMotion* _tmp4_;
		gdouble _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
#line 132 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp4_ = event_record;
#line 132 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp5_ = _tmp4_->x;
#line 132 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp6_ = self->priv->track_start_x;
#line 132 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		track_x_delta = ((gint) _tmp5_) - _tmp6_;
#line 133 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp7_ = self->priv->track_nub_start_position;
#line 133 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp8_ = track_x_delta;
#line 133 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		self->priv->left_nub_position = _tmp7_ + _tmp8_;
#line 134 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp9_ = self->priv->left_nub_position;
#line 134 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp10_ = self->priv->left_nub_max;
#line 134 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp11_ = CLAMP (_tmp9_, 0, _tmp10_);
#line 134 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		self->priv->left_nub_position = _tmp11_;
#line 631 "RGBHistogramManipulator.c"
	} else {
		gint track_x_delta = 0;
		GdkEventMotion* _tmp12_;
		gdouble _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
#line 136 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp12_ = event_record;
#line 136 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp13_ = _tmp12_->x;
#line 136 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp14_ = self->priv->track_start_x;
#line 136 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		track_x_delta = ((gint) _tmp13_) - _tmp14_;
#line 137 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp15_ = self->priv->track_nub_start_position;
#line 137 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp16_ = track_x_delta;
#line 137 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		self->priv->right_nub_position = _tmp15_ + _tmp16_;
#line 138 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp17_ = self->priv->right_nub_position;
#line 138 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp18_ = self->priv->right_nub_min;
#line 138 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp19_ = CLAMP (_tmp17_, _tmp18_, 255);
#line 138 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		self->priv->right_nub_position = _tmp19_;
#line 664 "RGBHistogramManipulator.c"
	}
#line 141 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_force_update (self);
#line 142 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	result = TRUE;
#line 142 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	return result;
#line 672 "RGBHistogramManipulator.c"
}


static gboolean rgb_histogram_manipulator_real_draw (GtkWidget* base, cairo_t* ctx) {
	RGBHistogramManipulator * self;
	gboolean result = FALSE;
	GtkBorder padding = {0};
	GtkStyleContext* _tmp0_;
	GtkBorder _tmp1_ = {0};
	GdkRectangle area = {0};
	GtkBorder _tmp2_;
	gint16 _tmp3_;
	GtkBorder _tmp4_;
	gint16 _tmp5_;
	GtkBorder _tmp6_;
	gint16 _tmp7_;
	GtkBorder _tmp8_;
	gint16 _tmp9_;
	cairo_t* _tmp10_;
	GdkRectangle _tmp11_;
	cairo_t* _tmp12_;
	GdkRectangle _tmp13_;
	gint _tmp14_;
	cairo_t* _tmp15_;
	GdkRectangle _tmp16_;
	gint _tmp17_;
#line 145 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RGB_HISTOGRAM_MANIPULATOR, RGBHistogramManipulator);
#line 145 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_val_if_fail (ctx != NULL, FALSE);
#line 146 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 146 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	gtk_style_context_get_padding (_tmp0_, GTK_STATE_FLAG_NORMAL, &_tmp1_);
#line 146 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	padding = _tmp1_;
#line 148 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	memset (&area, 0, sizeof (GdkRectangle));
#line 149 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp2_ = padding;
#line 149 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp3_ = _tmp2_.left;
#line 149 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	area.x = (gint) _tmp3_;
#line 150 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp4_ = padding;
#line 150 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp5_ = _tmp4_.top;
#line 150 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	area.y = (gint) _tmp5_;
#line 151 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp6_ = padding;
#line 151 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp7_ = _tmp6_.right;
#line 151 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	area.width = RGB_HISTOGRAM_GRAPHIC_WIDTH + _tmp7_;
#line 152 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp8_ = padding;
#line 152 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp9_ = _tmp8_.bottom;
#line 152 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	area.height = RGB_HISTOGRAM_GRAPHIC_HEIGHT + _tmp9_;
#line 154 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp10_ = ctx;
#line 154 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp11_ = area;
#line 154 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_draw_histogram (self, _tmp10_, &_tmp11_);
#line 155 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp12_ = ctx;
#line 155 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp13_ = area;
#line 155 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp14_ = self->priv->left_nub_position;
#line 155 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_draw_nub (self, _tmp12_, &_tmp13_, _tmp14_);
#line 156 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp15_ = ctx;
#line 156 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp16_ = area;
#line 156 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp17_ = self->priv->right_nub_position;
#line 156 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_draw_nub (self, _tmp15_, &_tmp16_, _tmp17_);
#line 158 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	result = TRUE;
#line 158 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	return result;
#line 761 "RGBHistogramManipulator.c"
}


static void rgb_histogram_manipulator_draw_histogram (RGBHistogramManipulator* self, cairo_t* ctx, GdkRectangle* area) {
	RGBHistogram* _tmp0_;
	GdkPixbuf* histogram_graphic = NULL;
	RGBHistogram* _tmp1_;
	GdkPixbuf* _tmp2_;
	cairo_t* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkRectangle _tmp5_;
	gint _tmp6_;
	GdkRectangle _tmp7_;
	gint _tmp8_;
	cairo_t* _tmp9_;
	gint _tmp10_;
	gint _tmp22_;
#line 161 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 161 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (ctx != NULL);
#line 161 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (area != NULL);
#line 162 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = self->priv->histogram;
#line 162 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp0_ == NULL) {
#line 163 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		return;
#line 791 "RGBHistogramManipulator.c"
	}
#line 165 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp1_ = self->priv->histogram;
#line 165 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp2_ = rgb_histogram_get_graphic (_tmp1_);
#line 165 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	histogram_graphic = _tmp2_;
#line 167 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp3_ = ctx;
#line 167 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp4_ = histogram_graphic;
#line 167 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp5_ = *area;
#line 167 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp6_ = _tmp5_.x;
#line 167 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp7_ = *area;
#line 167 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp8_ = _tmp7_.y;
#line 167 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	gdk_cairo_set_source_pixbuf (_tmp3_, _tmp4_, (gdouble) (_tmp6_ + RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH), (gdouble) (_tmp8_ + 2));
#line 168 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp9_ = ctx;
#line 168 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	cairo_paint (_tmp9_);
#line 170 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp10_ = self->priv->left_nub_position;
#line 170 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp10_ > 0) {
#line 821 "RGBHistogramManipulator.c"
		cairo_t* _tmp11_;
		GdkRectangle _tmp12_;
		gint _tmp13_;
		GdkRectangle _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		GdkPixbuf* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		cairo_t* _tmp20_;
		cairo_t* _tmp21_;
#line 171 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp11_ = ctx;
#line 171 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp12_ = *area;
#line 171 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp13_ = _tmp12_.x;
#line 171 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp14_ = *area;
#line 171 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp15_ = _tmp14_.y;
#line 171 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp16_ = self->priv->left_nub_position;
#line 171 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp17_ = histogram_graphic;
#line 171 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp18_ = gdk_pixbuf_get_height (_tmp17_);
#line 171 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp19_ = _tmp18_;
#line 171 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		cairo_rectangle (_tmp11_, (gdouble) (_tmp13_ + RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH), (gdouble) (_tmp15_ + 2), (gdouble) _tmp16_, (gdouble) _tmp19_);
#line 174 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp20_ = ctx;
#line 174 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		cairo_set_source_rgba (_tmp20_, 0.0, 0.0, 0.0, 0.45);
#line 175 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp21_ = ctx;
#line 175 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		cairo_fill (_tmp21_);
#line 861 "RGBHistogramManipulator.c"
	}
#line 178 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp22_ = self->priv->right_nub_position;
#line 178 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp22_ < 255) {
#line 867 "RGBHistogramManipulator.c"
		cairo_t* _tmp23_;
		GdkRectangle _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		GdkRectangle _tmp27_;
		gint _tmp28_;
		GdkPixbuf* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		GdkPixbuf* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		cairo_t* _tmp36_;
		cairo_t* _tmp37_;
#line 179 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp23_ = ctx;
#line 179 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp24_ = *area;
#line 179 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp25_ = _tmp24_.x;
#line 179 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp26_ = self->priv->right_nub_position;
#line 179 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp27_ = *area;
#line 179 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp28_ = _tmp27_.y;
#line 179 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp29_ = histogram_graphic;
#line 179 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp30_ = gdk_pixbuf_get_width (_tmp29_);
#line 179 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp31_ = _tmp30_;
#line 179 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp32_ = self->priv->right_nub_position;
#line 179 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp33_ = histogram_graphic;
#line 179 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp34_ = gdk_pixbuf_get_height (_tmp33_);
#line 179 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp35_ = _tmp34_;
#line 179 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		cairo_rectangle (_tmp23_, (gdouble) ((_tmp25_ + _tmp26_) + RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH), (gdouble) (_tmp28_ + 2), (gdouble) (_tmp31_ - _tmp32_), (gdouble) _tmp35_);
#line 183 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp36_ = ctx;
#line 183 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		cairo_set_source_rgba (_tmp36_, 1.0, 1.0, 1.0, 0.45);
#line 184 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp37_ = ctx;
#line 184 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		cairo_fill (_tmp37_);
#line 919 "RGBHistogramManipulator.c"
	}
#line 161 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_g_object_unref0 (histogram_graphic);
#line 923 "RGBHistogramManipulator.c"
}


static void rgb_histogram_manipulator_draw_nub (RGBHistogramManipulator* self, cairo_t* ctx, GdkRectangle* area, gint position) {
	cairo_t* _tmp0_;
	GdkRectangle _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GdkRectangle _tmp4_;
	gint _tmp5_;
	cairo_t* _tmp6_;
	GdkRectangle _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GdkRectangle _tmp10_;
	gint _tmp11_;
	cairo_t* _tmp12_;
	GdkRectangle _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GdkRectangle _tmp16_;
	gint _tmp17_;
	cairo_t* _tmp18_;
	cairo_t* _tmp19_;
	cairo_t* _tmp20_;
#line 188 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 188 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (ctx != NULL);
#line 188 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (area != NULL);
#line 189 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = ctx;
#line 189 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp1_ = *area;
#line 189 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp2_ = _tmp1_.x;
#line 189 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp3_ = position;
#line 189 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp4_ = *area;
#line 189 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp5_ = _tmp4_.y;
#line 189 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	cairo_move_to (_tmp0_, (gdouble) (_tmp2_ + _tmp3_), (gdouble) ((_tmp5_ + RGB_HISTOGRAM_MANIPULATOR_NUB_V_POSITION) + RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE));
#line 190 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp6_ = ctx;
#line 190 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp7_ = *area;
#line 190 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp8_ = _tmp7_.x;
#line 190 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp9_ = position;
#line 190 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp10_ = *area;
#line 190 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp11_ = _tmp10_.y;
#line 190 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	cairo_line_to (_tmp6_, (gdouble) ((_tmp8_ + _tmp9_) + RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH), (gdouble) (_tmp11_ + RGB_HISTOGRAM_MANIPULATOR_NUB_V_POSITION));
#line 191 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp12_ = ctx;
#line 191 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp13_ = *area;
#line 191 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp14_ = _tmp13_.x;
#line 191 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp15_ = position;
#line 191 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp16_ = *area;
#line 191 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp17_ = _tmp16_.y;
#line 191 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	cairo_line_to (_tmp12_, (gdouble) ((_tmp14_ + _tmp15_) + RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE), (gdouble) ((_tmp17_ + RGB_HISTOGRAM_MANIPULATOR_NUB_V_POSITION) + RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE));
#line 192 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp18_ = ctx;
#line 192 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	cairo_close_path (_tmp18_);
#line 193 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp19_ = ctx;
#line 193 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	cairo_set_source_rgb (_tmp19_, 0.333, 0.333, 0.333);
#line 194 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp20_ = ctx;
#line 194 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	cairo_fill (_tmp20_);
#line 1009 "RGBHistogramManipulator.c"
}


static void rgb_histogram_manipulator_force_update (RGBHistogramManipulator* self) {
	GdkWindow* _tmp0_;
#line 197 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 198 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 198 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	gdk_window_invalidate_rect (_tmp0_, NULL, TRUE);
#line 1021 "RGBHistogramManipulator.c"
}


static void rgb_histogram_manipulator_update_nub_extrema (RGBHistogramManipulator* self) {
	gint _tmp0_;
	gint _tmp1_;
#line 201 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 202 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = self->priv->left_nub_position;
#line 202 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->right_nub_min = (_tmp0_ + RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE) + 1;
#line 203 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp1_ = self->priv->right_nub_position;
#line 203 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->left_nub_max = (_tmp1_ - RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE) - 1;
#line 1038 "RGBHistogramManipulator.c"
}


void rgb_histogram_manipulator_update_histogram (RGBHistogramManipulator* self, GdkPixbuf* source_pixbuf) {
	GdkPixbuf* _tmp0_;
	RGBHistogram* _tmp1_;
#line 208 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 208 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (GDK_IS_PIXBUF (source_pixbuf));
#line 209 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = source_pixbuf;
#line 209 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp1_ = rgb_histogram_new (_tmp0_);
#line 209 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_rgb_histogram_unref0 (self->priv->histogram);
#line 209 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->histogram = _tmp1_;
#line 210 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_force_update (self);
#line 1059 "RGBHistogramManipulator.c"
}


gint rgb_histogram_manipulator_get_left_nub_position (RGBHistogramManipulator* self) {
	gint result = 0;
	gint _tmp0_;
#line 213 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_val_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self), 0);
#line 214 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = self->priv->left_nub_position;
#line 214 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	result = _tmp0_;
#line 214 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	return result;
#line 1074 "RGBHistogramManipulator.c"
}


gint rgb_histogram_manipulator_get_right_nub_position (RGBHistogramManipulator* self) {
	gint result = 0;
	gint _tmp0_;
#line 217 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_val_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self), 0);
#line 218 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = self->priv->right_nub_position;
#line 218 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	result = _tmp0_;
#line 218 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	return result;
#line 1089 "RGBHistogramManipulator.c"
}


void rgb_histogram_manipulator_set_left_nub_position (RGBHistogramManipulator* self, gint user_nub_pos) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
#line 221 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 222 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp1_ = user_nub_pos;
#line 222 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp1_ >= 0) {
#line 1105 "RGBHistogramManipulator.c"
		gint _tmp2_;
#line 222 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp2_ = user_nub_pos;
#line 222 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp0_ = _tmp2_ <= 255;
#line 1111 "RGBHistogramManipulator.c"
	} else {
#line 222 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp0_ = FALSE;
#line 1115 "RGBHistogramManipulator.c"
	}
#line 222 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_vala_assert (_tmp0_, "(user_nub_pos >= 0) && (user_nub_pos <= 255)");
#line 223 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp3_ = user_nub_pos;
#line 223 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp4_ = self->priv->left_nub_max;
#line 223 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp5_ = CLAMP (_tmp3_, 0, _tmp4_);
#line 223 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->left_nub_position = _tmp5_;
#line 224 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_update_nub_extrema (self);
#line 1129 "RGBHistogramManipulator.c"
}


void rgb_histogram_manipulator_set_right_nub_position (RGBHistogramManipulator* self, gint user_nub_pos) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
#line 227 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 228 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp1_ = user_nub_pos;
#line 228 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp1_ >= 0) {
#line 1145 "RGBHistogramManipulator.c"
		gint _tmp2_;
#line 228 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp2_ = user_nub_pos;
#line 228 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp0_ = _tmp2_ <= 255;
#line 1151 "RGBHistogramManipulator.c"
	} else {
#line 228 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp0_ = FALSE;
#line 1155 "RGBHistogramManipulator.c"
	}
#line 228 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_vala_assert (_tmp0_, "(user_nub_pos >= 0) && (user_nub_pos <= 255)");
#line 229 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp3_ = user_nub_pos;
#line 229 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp4_ = self->priv->right_nub_min;
#line 229 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp5_ = CLAMP (_tmp3_, _tmp4_, 255);
#line 229 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->right_nub_position = _tmp5_;
#line 230 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_update_nub_extrema (self);
#line 1169 "RGBHistogramManipulator.c"
}


static void rgb_histogram_manipulator_class_init (RGBHistogramManipulatorClass * klass) {
	GtkWidgetPath* _tmp0_;
	GtkWidgetPath* _tmp1_;
#line 7 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_type_class_add_private (klass, sizeof (RGBHistogramManipulatorPrivate));
#line 7 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) rgb_histogram_manipulator_real_draw;
#line 7 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	G_OBJECT_CLASS (klass)->finalize = rgb_histogram_manipulator_finalize;
#line 7 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_signals[RGB_HISTOGRAM_MANIPULATOR_NUB_POSITION_CHANGED_SIGNAL] = g_signal_new ("nub-position-changed", TYPE_RGB_HISTOGRAM_MANIPULATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 23 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = gtk_widget_path_new ();
#line 23 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_slider_draw_path = _tmp0_;
#line 24 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp1_ = gtk_widget_path_new ();
#line 24 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_frame_draw_path = _tmp1_;
#line 1194 "RGBHistogramManipulator.c"
}


static void rgb_histogram_manipulator_instance_init (RGBHistogramManipulator * self) {
#line 7 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv = RGB_HISTOGRAM_MANIPULATOR_GET_PRIVATE (self);
#line 20 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->left_nub_max = (255 - RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE) - 1;
#line 21 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->right_nub_min = RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE + 1;
#line 27 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->histogram = NULL;
#line 28 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->left_nub_position = 0;
#line 29 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->right_nub_position = 255;
#line 30 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->is_left_nub_tracking = FALSE;
#line 31 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->is_right_nub_tracking = FALSE;
#line 32 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->track_start_x = 0;
#line 33 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->track_nub_start_position = 0;
#line 1219 "RGBHistogramManipulator.c"
}


static void rgb_histogram_manipulator_finalize (GObject * obj) {
	RGBHistogramManipulator * self;
#line 7 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RGB_HISTOGRAM_MANIPULATOR, RGBHistogramManipulator);
#line 27 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_rgb_histogram_unref0 (self->priv->histogram);
#line 7 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	G_OBJECT_CLASS (rgb_histogram_manipulator_parent_class)->finalize (obj);
#line 1231 "RGBHistogramManipulator.c"
}


GType rgb_histogram_manipulator_get_type (void) {
	static volatile gsize rgb_histogram_manipulator_type_id__volatile = 0;
	if (g_once_init_enter (&rgb_histogram_manipulator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RGBHistogramManipulatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rgb_histogram_manipulator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RGBHistogramManipulator), 0, (GInstanceInitFunc) rgb_histogram_manipulator_instance_init, NULL };
		GType rgb_histogram_manipulator_type_id;
		rgb_histogram_manipulator_type_id = g_type_register_static (gtk_drawing_area_get_type (), "RGBHistogramManipulator", &g_define_type_info, 0);
		g_once_init_leave (&rgb_histogram_manipulator_type_id__volatile, rgb_histogram_manipulator_type_id);
	}
	return rgb_histogram_manipulator_type_id__volatile;
}



