/* misc.c generated by valac 0.40.4, the Vala compiler
 * generated from misc.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <time.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>

#define _g_checksum_free0(var) ((var == NULL) ? NULL : (var = (g_checksum_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_PHOTO_ID (photo_id_get_type ())
typedef struct _PhotoID PhotoID;

#define TYPE_MEDIA_COLLECTION_REGISTRY (media_collection_registry_get_type ())
#define MEDIA_COLLECTION_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistry))
#define MEDIA_COLLECTION_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistryClass))
#define IS_MEDIA_COLLECTION_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_COLLECTION_REGISTRY))
#define IS_MEDIA_COLLECTION_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_COLLECTION_REGISTRY))
#define MEDIA_COLLECTION_REGISTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistryClass))

typedef struct _MediaCollectionRegistry MediaCollectionRegistry;
typedef struct _MediaCollectionRegistryClass MediaCollectionRegistryClass;
#define _media_collection_registry_unref0(var) ((var == NULL) ? NULL : (var = (media_collection_registry_unref (var), NULL)))

#define TYPE_ONE_SHOT_SCHEDULER (one_shot_scheduler_get_type ())
#define ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotScheduler))
#define ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))
#define IS_ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ONE_SHOT_SCHEDULER))
#define IS_ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ONE_SHOT_SCHEDULER))
#define ONE_SHOT_SCHEDULER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))

typedef struct _OneShotScheduler OneShotScheduler;
typedef struct _OneShotSchedulerClass OneShotSchedulerClass;
typedef struct _OneShotSchedulerPrivate OneShotSchedulerPrivate;
typedef struct _ParamSpecOneShotScheduler ParamSpecOneShotScheduler;

#define TYPE_OP_TIMER (op_timer_get_type ())
#define OP_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OP_TIMER, OpTimer))
#define OP_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OP_TIMER, OpTimerClass))
#define IS_OP_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OP_TIMER))
#define IS_OP_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OP_TIMER))
#define OP_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OP_TIMER, OpTimerClass))

typedef struct _OpTimer OpTimer;
typedef struct _OpTimerClass OpTimerClass;
typedef struct _OpTimerPrivate OpTimerPrivate;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _ParamSpecOpTimer ParamSpecOpTimer;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef gboolean (*ValueEqualFunc) (GValue* a, GValue* b, void* user_data);
struct _PhotoID {
	gint64 id;
};

typedef void (*OneShotCallback) (void* user_data);
struct _OneShotScheduler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	OneShotSchedulerPrivate * priv;
};

struct _OneShotSchedulerClass {
	GTypeClass parent_class;
	void (*finalize) (OneShotScheduler *self);
};

struct _OneShotSchedulerPrivate {
	gchar* name;
	OneShotCallback callback;
	gpointer callback_target;
	guint scheduled;
};

struct _ParamSpecOneShotScheduler {
	GParamSpec parent_instance;
};

struct _OpTimer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	OpTimerPrivate * priv;
};

struct _OpTimerClass {
	GTypeClass parent_class;
	void (*finalize) (OpTimer *self);
};

struct _OpTimerPrivate {
	gchar* name;
	GTimer* timer;
	glong count;
	gdouble elapsed;
	gdouble shortest;
	gdouble longest;
};

struct _ParamSpecOpTimer {
	GParamSpec parent_instance;
};


static gpointer one_shot_scheduler_parent_class = NULL;
static gpointer op_timer_parent_class = NULL;

guint int64_hash (gint64* n);
gboolean int64_equal (gint64* a,
                      gint64* b);
gint int64_compare (gint64* a,
                    gint64* b);
gint uint64_compare (guint64* a,
                     guint64* b);
gboolean bool_value_equals (GValue* a,
                            GValue* b);
gboolean int_value_equals (GValue* a,
                           GValue* b);
gulong timeval_to_ms (GTimeVal* time_val);
gulong now_ms (void);
gulong now_sec (void);
time_t now_time_t (void);
gchar* md5_file (GFile* file,
                 GError** error);
gboolean equal_sets (GeeSet* a,
                     GeeSet* b);
GeeSet* intersection_of_sets (GeeSet* a,
                              GeeSet* b,
                              GeeSet* excluded);
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
guchar* serialize_photo_ids (GeeCollection* photos,
                             int* result_length1);
GType photo_id_get_type (void) G_GNUC_CONST;
PhotoID* photo_id_dup (const PhotoID* self);
void photo_id_free (PhotoID* self);
void photo_get_photo_id (Photo* self,
                         PhotoID* result);
GeeList* unserialize_photo_ids (guchar* serialized,
                                gint size);
void photo_id_init (PhotoID *self,
                    gint64 id);
guchar* serialize_media_sources (GeeCollection* media,
                                 int* result_length1);
gchar* data_source_get_source_id (DataSource* self);
GeeList* unserialize_media_sources (guchar* serialized,
                                    gint size);
gpointer media_collection_registry_ref (gpointer instance);
void media_collection_registry_unref (gpointer instance);
GParamSpec* param_spec_media_collection_registry (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags);
void value_set_media_collection_registry (GValue* value,
                                          gpointer v_object);
void value_take_media_collection_registry (GValue* value,
                                           gpointer v_object);
gpointer value_get_media_collection_registry (const GValue* value);
GType media_collection_registry_get_type (void) G_GNUC_CONST;
MediaCollectionRegistry* media_collection_registry_get_instance (void);
MediaSource* media_collection_registry_fetch_media (MediaCollectionRegistry* self,
                                                    const gchar* source_id);
gchar* format_local_datespan (struct tm* from_date,
                              struct tm* to_date);
gchar* resources_get_start_multiday_span_format_string (void);
gchar* resources_get_end_multiday_span_format_string (void);
gchar* resources_get_start_multimonth_span_format_string (void);
gchar* resources_get_end_multimonth_span_format_string (void);
gchar* resources_get_long_date_format_string (void);
gchar* string_strip_leading_zeroes (const gchar* str);
gchar* format_local_date (struct tm* date);
gpointer one_shot_scheduler_ref (gpointer instance);
void one_shot_scheduler_unref (gpointer instance);
GParamSpec* param_spec_one_shot_scheduler (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void value_set_one_shot_scheduler (GValue* value,
                                   gpointer v_object);
void value_take_one_shot_scheduler (GValue* value,
                                    gpointer v_object);
gpointer value_get_one_shot_scheduler (const GValue* value);
GType one_shot_scheduler_get_type (void) G_GNUC_CONST;
#define ONE_SHOT_SCHEDULER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerPrivate))
void one_shot_scheduler_cancel (OneShotScheduler* self);
OneShotScheduler* one_shot_scheduler_new (const gchar* name,
                                          OneShotCallback callback,
                                          void* callback_target);
OneShotScheduler* one_shot_scheduler_construct (GType object_type,
                                                const gchar* name,
                                                OneShotCallback callback,
                                                void* callback_target);
gboolean one_shot_scheduler_is_scheduled (OneShotScheduler* self);
void one_shot_scheduler_at_idle (OneShotScheduler* self);
void one_shot_scheduler_at_priority_idle (OneShotScheduler* self,
                                          gint priority);
static gboolean one_shot_scheduler_callback_wrapper (OneShotScheduler* self);
static gboolean _one_shot_scheduler_callback_wrapper_gsource_func (gpointer self);
void one_shot_scheduler_after_timeout (OneShotScheduler* self,
                                       guint msec,
                                       gboolean reschedule);
void one_shot_scheduler_priority_after_timeout (OneShotScheduler* self,
                                                gint priority,
                                                guint msec,
                                                gboolean reschedule);
static void one_shot_scheduler_finalize (OneShotScheduler * obj);
gpointer op_timer_ref (gpointer instance);
void op_timer_unref (gpointer instance);
GParamSpec* param_spec_op_timer (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
void value_set_op_timer (GValue* value,
                         gpointer v_object);
void value_take_op_timer (GValue* value,
                          gpointer v_object);
gpointer value_get_op_timer (const GValue* value);
GType op_timer_get_type (void) G_GNUC_CONST;
#define OP_TIMER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_OP_TIMER, OpTimerPrivate))
OpTimer* op_timer_new (const gchar* name);
OpTimer* op_timer_construct (GType object_type,
                             const gchar* name);
void op_timer_start (OpTimer* self);
void op_timer_stop (OpTimer* self);
gchar* op_timer_to_string (OpTimer* self);
static void op_timer_finalize (OpTimer * obj);


guint
int64_hash (gint64* n)
{
	guint result = 0U;
	guint8* u8 = NULL;
	guint hash = 0U;
#line 9 "/home/jens/Source/shotwell/src/util/misc.vala"
	u8 = (guint8*) n;
#line 10 "/home/jens/Source/shotwell/src/util/misc.vala"
	hash = (guint) 0;
#line 326 "misc.c"
	{
		gint ctr = 0;
#line 11 "/home/jens/Source/shotwell/src/util/misc.vala"
		ctr = 0;
#line 331 "misc.c"
		{
			gboolean _tmp0_ = FALSE;
#line 11 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp0_ = TRUE;
#line 11 "/home/jens/Source/shotwell/src/util/misc.vala"
			while (TRUE) {
#line 338 "misc.c"
				gint _tmp2_;
				guint _tmp3_;
				guint _tmp4_;
				guint8* _tmp5_;
#line 11 "/home/jens/Source/shotwell/src/util/misc.vala"
				if (!_tmp0_) {
#line 345 "misc.c"
					gint _tmp1_;
#line 11 "/home/jens/Source/shotwell/src/util/misc.vala"
					_tmp1_ = ctr;
#line 11 "/home/jens/Source/shotwell/src/util/misc.vala"
					ctr = _tmp1_ + 1;
#line 351 "misc.c"
				}
#line 11 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp0_ = FALSE;
#line 11 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp2_ = ctr;
#line 11 "/home/jens/Source/shotwell/src/util/misc.vala"
				if (!(((gulong) _tmp2_) < (sizeof (gint64) / sizeof (guint8)))) {
#line 11 "/home/jens/Source/shotwell/src/util/misc.vala"
					break;
#line 361 "misc.c"
				}
#line 12 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp3_ = hash;
#line 12 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp4_ = hash;
#line 12 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp5_ = u8;
#line 12 "/home/jens/Source/shotwell/src/util/misc.vala"
				u8 = _tmp5_ + 1;
#line 12 "/home/jens/Source/shotwell/src/util/misc.vala"
				hash = ((_tmp3_ << 4) ^ (_tmp4_ >> 28)) ^ (*_tmp5_);
#line 373 "misc.c"
			}
		}
	}
#line 15 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = hash;
#line 15 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 381 "misc.c"
}


gboolean
int64_equal (gint64* a,
             gint64* b)
{
	gboolean result = FALSE;
	gint64* bia = NULL;
	gint64* bib = NULL;
#line 19 "/home/jens/Source/shotwell/src/util/misc.vala"
	bia = (gint64*) a;
#line 20 "/home/jens/Source/shotwell/src/util/misc.vala"
	bib = (gint64*) b;
#line 22 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = (*bia) == (*bib);
#line 22 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 400 "misc.c"
}


gint
int64_compare (gint64* a,
               gint64* b)
{
	gint result = 0;
	gint64 diff = 0LL;
	gint64 _tmp0_;
#line 26 "/home/jens/Source/shotwell/src/util/misc.vala"
	diff = (*((gint64*) a)) - (*((gint64*) b));
#line 27 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = diff;
#line 27 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp0_ < ((gint64) 0)) {
#line 28 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = -1;
#line 28 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 421 "misc.c"
	} else {
		gint64 _tmp1_;
#line 29 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp1_ = diff;
#line 29 "/home/jens/Source/shotwell/src/util/misc.vala"
		if (_tmp1_ > ((gint64) 0)) {
#line 30 "/home/jens/Source/shotwell/src/util/misc.vala"
			result = 1;
#line 30 "/home/jens/Source/shotwell/src/util/misc.vala"
			return result;
#line 432 "misc.c"
		} else {
#line 32 "/home/jens/Source/shotwell/src/util/misc.vala"
			result = 0;
#line 32 "/home/jens/Source/shotwell/src/util/misc.vala"
			return result;
#line 438 "misc.c"
		}
	}
}


gint
uint64_compare (guint64* a,
                guint64* b)
{
	gint result = 0;
	guint64 a64 = 0ULL;
	guint64 b64 = 0ULL;
	guint64 _tmp0_;
	guint64 _tmp1_;
#line 36 "/home/jens/Source/shotwell/src/util/misc.vala"
	a64 = *((guint64*) a);
#line 37 "/home/jens/Source/shotwell/src/util/misc.vala"
	b64 = *((guint64*) b);
#line 39 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = a64;
#line 39 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = b64;
#line 39 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp0_ < _tmp1_) {
#line 40 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = -1;
#line 40 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 467 "misc.c"
	} else {
		guint64 _tmp2_;
		guint64 _tmp3_;
#line 41 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp2_ = a64;
#line 41 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp3_ = b64;
#line 41 "/home/jens/Source/shotwell/src/util/misc.vala"
		if (_tmp2_ > _tmp3_) {
#line 42 "/home/jens/Source/shotwell/src/util/misc.vala"
			result = 1;
#line 42 "/home/jens/Source/shotwell/src/util/misc.vala"
			return result;
#line 481 "misc.c"
		} else {
#line 44 "/home/jens/Source/shotwell/src/util/misc.vala"
			result = 0;
#line 44 "/home/jens/Source/shotwell/src/util/misc.vala"
			return result;
#line 487 "misc.c"
		}
	}
}


gboolean
bool_value_equals (GValue* a,
                   GValue* b)
{
	gboolean result = FALSE;
	GValue _tmp0_;
	GValue _tmp1_;
#line 49 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (a != NULL, FALSE);
#line 49 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (b != NULL, FALSE);
#line 50 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = *a;
#line 50 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = *b;
#line 50 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = g_value_get_boolean (&_tmp0_) == g_value_get_boolean (&_tmp1_);
#line 50 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 512 "misc.c"
}


gboolean
int_value_equals (GValue* a,
                  GValue* b)
{
	gboolean result = FALSE;
	GValue _tmp0_;
	GValue _tmp1_;
#line 53 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (a != NULL, FALSE);
#line 53 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (b != NULL, FALSE);
#line 54 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = *a;
#line 54 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = *b;
#line 54 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = g_value_get_int (&_tmp0_) == g_value_get_int (&_tmp1_);
#line 54 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 535 "misc.c"
}


gulong
timeval_to_ms (GTimeVal* time_val)
{
	gulong result = 0UL;
	GTimeVal _tmp0_;
	glong _tmp1_;
	GTimeVal _tmp2_;
	glong _tmp3_;
#line 57 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (time_val != NULL, 0UL);
#line 58 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = *time_val;
#line 58 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = _tmp0_.tv_sec;
#line 58 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = *time_val;
#line 58 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp3_ = _tmp2_.tv_usec;
#line 58 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = (((gulong) _tmp1_) * 1000) + (((gulong) _tmp3_) / 1000);
#line 58 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 561 "misc.c"
}


gulong
now_ms (void)
{
	gulong result = 0UL;
	GTimeVal _tmp0_ = {0};
#line 62 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_get_current_time (&_tmp0_);
#line 62 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = timeval_to_ms (&_tmp0_);
#line 62 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 576 "misc.c"
}


gulong
now_sec (void)
{
	gulong result = 0UL;
	GTimeVal time_val = {0};
	GTimeVal _tmp0_;
	glong _tmp1_;
#line 66 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_get_current_time (&time_val);
#line 68 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = time_val;
#line 68 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = _tmp0_.tv_sec;
#line 68 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = (gulong) _tmp1_;
#line 68 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 597 "misc.c"
}


inline time_t
now_time_t (void)
{
	time_t result = 0;
#line 72 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = (time_t) now_sec ();
#line 72 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 609 "misc.c"
}


gchar*
md5_file (GFile* file,
          GError** error)
{
	gchar* result = NULL;
	GChecksum* md5 = NULL;
	GChecksum* _tmp0_;
	guint8* buffer = NULL;
	guint8* _tmp1_;
	gint buffer_length1;
	gint _buffer_size_;
	GFileInputStream* fins = NULL;
	GFileInputStream* _tmp2_;
	GChecksum* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	GError * _inner_error_ = NULL;
#line 75 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 76 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = g_checksum_new (G_CHECKSUM_MD5);
#line 76 "/home/jens/Source/shotwell/src/util/misc.vala"
	md5 = _tmp0_;
#line 77 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = g_new0 (guint8, 64 * 1024);
#line 77 "/home/jens/Source/shotwell/src/util/misc.vala"
	buffer = _tmp1_;
#line 77 "/home/jens/Source/shotwell/src/util/misc.vala"
	buffer_length1 = 64 * 1024;
#line 77 "/home/jens/Source/shotwell/src/util/misc.vala"
	_buffer_size_ = buffer_length1;
#line 79 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = g_file_read (file, NULL, &_inner_error_);
#line 79 "/home/jens/Source/shotwell/src/util/misc.vala"
	fins = _tmp2_;
#line 79 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 79 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_propagate_error (error, _inner_error_);
#line 79 "/home/jens/Source/shotwell/src/util/misc.vala"
		buffer = (g_free (buffer), NULL);
#line 79 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_checksum_free0 (md5);
#line 79 "/home/jens/Source/shotwell/src/util/misc.vala"
		return NULL;
#line 658 "misc.c"
	}
	{
		gboolean _tmp3_ = FALSE;
#line 80 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp3_ = TRUE;
#line 80 "/home/jens/Source/shotwell/src/util/misc.vala"
		while (TRUE) {
#line 666 "misc.c"
			gsize bytes_read = 0UL;
			GFileInputStream* _tmp4_;
			guint8* _tmp5_;
			gint _tmp5__length1;
			gsize _tmp6_;
			GChecksum* _tmp7_;
			guint8* _tmp8_;
			gint _tmp8__length1;
			gsize _tmp9_;
#line 80 "/home/jens/Source/shotwell/src/util/misc.vala"
			if (!_tmp3_) {
#line 678 "misc.c"
			}
#line 80 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp3_ = FALSE;
#line 81 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp4_ = fins;
#line 81 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp5_ = buffer;
#line 81 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp5__length1 = buffer_length1;
#line 81 "/home/jens/Source/shotwell/src/util/misc.vala"
			bytes_read = (gsize) g_input_stream_read (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_input_stream_get_type (), GInputStream), _tmp5_, (gsize) _tmp5__length1, NULL, &_inner_error_);
#line 81 "/home/jens/Source/shotwell/src/util/misc.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 81 "/home/jens/Source/shotwell/src/util/misc.vala"
				g_propagate_error (error, _inner_error_);
#line 81 "/home/jens/Source/shotwell/src/util/misc.vala"
				_g_object_unref0 (fins);
#line 81 "/home/jens/Source/shotwell/src/util/misc.vala"
				buffer = (g_free (buffer), NULL);
#line 81 "/home/jens/Source/shotwell/src/util/misc.vala"
				_g_checksum_free0 (md5);
#line 81 "/home/jens/Source/shotwell/src/util/misc.vala"
				return NULL;
#line 702 "misc.c"
			}
#line 82 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp6_ = bytes_read;
#line 82 "/home/jens/Source/shotwell/src/util/misc.vala"
			if (_tmp6_ <= ((gsize) 0)) {
#line 83 "/home/jens/Source/shotwell/src/util/misc.vala"
				break;
#line 710 "misc.c"
			}
#line 85 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp7_ = md5;
#line 85 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp8_ = buffer;
#line 85 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp8__length1 = buffer_length1;
#line 85 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp9_ = bytes_read;
#line 85 "/home/jens/Source/shotwell/src/util/misc.vala"
			g_checksum_update (_tmp7_, (guchar*) _tmp8_, _tmp9_);
#line 722 "misc.c"
		}
	}
	{
		GFileInputStream* _tmp10_;
#line 89 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp10_ = fins;
#line 89 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_input_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_input_stream_get_type (), GInputStream), NULL, &_inner_error_);
#line 89 "/home/jens/Source/shotwell/src/util/misc.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 733 "misc.c"
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* err = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
#line 88 "/home/jens/Source/shotwell/src/util/misc.vala"
		err = _inner_error_;
#line 88 "/home/jens/Source/shotwell/src/util/misc.vala"
		_inner_error_ = NULL;
#line 91 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp11_ = g_file_get_path (file);
#line 91 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp12_ = _tmp11_;
#line 91 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp13_ = err;
#line 91 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp14_ = _tmp13_->message;
#line 91 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_warning ("misc.vala:91: Unable to close MD5 input stream for %s: %s", _tmp12_, _tmp14_);
#line 91 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_free0 (_tmp12_);
#line 88 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_error_free0 (err);
#line 763 "misc.c"
	}
	__finally5:
#line 88 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 88 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_propagate_error (error, _inner_error_);
#line 88 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_object_unref0 (fins);
#line 88 "/home/jens/Source/shotwell/src/util/misc.vala"
		buffer = (g_free (buffer), NULL);
#line 88 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_checksum_free0 (md5);
#line 88 "/home/jens/Source/shotwell/src/util/misc.vala"
		return NULL;
#line 778 "misc.c"
	}
#line 94 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp15_ = md5;
#line 94 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp16_ = g_checksum_get_string (_tmp15_);
#line 94 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp17_ = g_strdup (_tmp16_);
#line 94 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = _tmp17_;
#line 94 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_object_unref0 (fins);
#line 94 "/home/jens/Source/shotwell/src/util/misc.vala"
	buffer = (g_free (buffer), NULL);
#line 94 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_checksum_free0 (md5);
#line 94 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 796 "misc.c"
}


gboolean
equal_sets (GeeSet* a,
            GeeSet* b)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
#line 98 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail ((a == NULL) || GEE_IS_SET (a), FALSE);
#line 98 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail ((b == NULL) || GEE_IS_SET (b), FALSE);
#line 99 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (a != NULL) {
#line 821 "misc.c"
		gint _tmp2_;
		gint _tmp3_;
#line 99 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (a, GEE_TYPE_COLLECTION, GeeCollection));
#line 99 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp3_ = _tmp2_;
#line 99 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp1_ = _tmp3_ == 0;
#line 830 "misc.c"
	} else {
#line 99 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp1_ = FALSE;
#line 834 "misc.c"
	}
#line 99 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp1_) {
#line 99 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp0_ = b == NULL;
#line 840 "misc.c"
	} else {
#line 99 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp0_ = FALSE;
#line 844 "misc.c"
	}
#line 99 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp0_) {
#line 100 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = TRUE;
#line 100 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 852 "misc.c"
	}
#line 102 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (a == NULL) {
#line 856 "misc.c"
		gboolean _tmp5_ = FALSE;
#line 102 "/home/jens/Source/shotwell/src/util/misc.vala"
		if (b != NULL) {
#line 860 "misc.c"
			gint _tmp6_;
			gint _tmp7_;
#line 102 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp6_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (b, GEE_TYPE_COLLECTION, GeeCollection));
#line 102 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp7_ = _tmp6_;
#line 102 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp5_ = _tmp7_ == 0;
#line 869 "misc.c"
		} else {
#line 102 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp5_ = FALSE;
#line 873 "misc.c"
		}
#line 102 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp4_ = _tmp5_;
#line 877 "misc.c"
	} else {
#line 102 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp4_ = FALSE;
#line 881 "misc.c"
	}
#line 102 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp4_) {
#line 103 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = TRUE;
#line 103 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 889 "misc.c"
	}
#line 105 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (a == NULL) {
#line 105 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp9_ = b != NULL;
#line 895 "misc.c"
	} else {
#line 105 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp9_ = FALSE;
#line 899 "misc.c"
	}
#line 105 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp9_) {
#line 105 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp8_ = TRUE;
#line 905 "misc.c"
	} else {
		gboolean _tmp10_ = FALSE;
#line 105 "/home/jens/Source/shotwell/src/util/misc.vala"
		if (a != NULL) {
#line 105 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp10_ = b == NULL;
#line 912 "misc.c"
		} else {
#line 105 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp10_ = FALSE;
#line 916 "misc.c"
		}
#line 105 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp8_ = _tmp10_;
#line 920 "misc.c"
	}
#line 105 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp8_) {
#line 106 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = FALSE;
#line 106 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 928 "misc.c"
	}
#line 108 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (a == NULL) {
#line 108 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp11_ = b == NULL;
#line 934 "misc.c"
	} else {
#line 108 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp11_ = FALSE;
#line 938 "misc.c"
	}
#line 108 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp11_) {
#line 109 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = TRUE;
#line 109 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 946 "misc.c"
	}
#line 111 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp12_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (a, GEE_TYPE_COLLECTION, GeeCollection));
#line 111 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp13_ = _tmp12_;
#line 111 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp14_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (b, GEE_TYPE_COLLECTION, GeeCollection));
#line 111 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp15_ = _tmp14_;
#line 111 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp13_ != _tmp15_) {
#line 112 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = FALSE;
#line 112 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 962 "misc.c"
	}
	{
		GeeIterator* _element_it = NULL;
		GeeIterator* _tmp16_;
#line 116 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp16_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (a, GEE_TYPE_ITERABLE, GeeIterable));
#line 116 "/home/jens/Source/shotwell/src/util/misc.vala"
		_element_it = _tmp16_;
#line 116 "/home/jens/Source/shotwell/src/util/misc.vala"
		while (TRUE) {
#line 973 "misc.c"
			GeeIterator* _tmp17_;
			gchar* element = NULL;
			GeeIterator* _tmp18_;
			gpointer _tmp19_;
			const gchar* _tmp20_;
#line 116 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp17_ = _element_it;
#line 116 "/home/jens/Source/shotwell/src/util/misc.vala"
			if (!gee_iterator_next (_tmp17_)) {
#line 116 "/home/jens/Source/shotwell/src/util/misc.vala"
				break;
#line 985 "misc.c"
			}
#line 116 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp18_ = _element_it;
#line 116 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp19_ = gee_iterator_get (_tmp18_);
#line 116 "/home/jens/Source/shotwell/src/util/misc.vala"
			element = (gchar*) _tmp19_;
#line 117 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp20_ = element;
#line 117 "/home/jens/Source/shotwell/src/util/misc.vala"
			if (!gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (b, GEE_TYPE_COLLECTION, GeeCollection), _tmp20_)) {
#line 118 "/home/jens/Source/shotwell/src/util/misc.vala"
				result = FALSE;
#line 118 "/home/jens/Source/shotwell/src/util/misc.vala"
				_g_free0 (element);
#line 118 "/home/jens/Source/shotwell/src/util/misc.vala"
				_g_object_unref0 (_element_it);
#line 118 "/home/jens/Source/shotwell/src/util/misc.vala"
				return result;
#line 1005 "misc.c"
			}
#line 116 "/home/jens/Source/shotwell/src/util/misc.vala"
			_g_free0 (element);
#line 1009 "misc.c"
		}
#line 116 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_object_unref0 (_element_it);
#line 1013 "misc.c"
	}
#line 121 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = TRUE;
#line 121 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 1019 "misc.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 157 "/home/jens/Source/shotwell/src/util/misc.vala"
	return self ? g_object_ref (self) : NULL;
#line 1028 "misc.c"
}


GeeSet*
intersection_of_sets (GeeSet* a,
                      GeeSet* b,
                      GeeSet* excluded)
{
	GeeSet* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GeeSet* intersection = NULL;
	GeeHashSet* _tmp2_;
	GeeSet* _tmp19_ = NULL;
	GeeSet* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GeeSet* _tmp24_;
#line 125 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail ((a == NULL) || GEE_IS_SET (a), NULL);
#line 125 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail ((b == NULL) || GEE_IS_SET (b), NULL);
#line 125 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail ((excluded == NULL) || GEE_IS_SET (excluded), NULL);
#line 127 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (a != NULL) {
#line 127 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp0_ = b == NULL;
#line 1057 "misc.c"
	} else {
#line 127 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp0_ = FALSE;
#line 1061 "misc.c"
	}
#line 127 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp0_) {
#line 128 "/home/jens/Source/shotwell/src/util/misc.vala"
		if (excluded != NULL) {
#line 129 "/home/jens/Source/shotwell/src/util/misc.vala"
			gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (excluded, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (a, GEE_TYPE_COLLECTION, GeeCollection));
#line 1069 "misc.c"
		}
#line 131 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = NULL;
#line 131 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 1075 "misc.c"
	}
#line 134 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (a == NULL) {
#line 134 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp1_ = b != NULL;
#line 1081 "misc.c"
	} else {
#line 134 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp1_ = FALSE;
#line 1085 "misc.c"
	}
#line 134 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp1_) {
#line 135 "/home/jens/Source/shotwell/src/util/misc.vala"
		if (excluded != NULL) {
#line 136 "/home/jens/Source/shotwell/src/util/misc.vala"
			gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (excluded, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (b, GEE_TYPE_COLLECTION, GeeCollection));
#line 1093 "misc.c"
		}
#line 138 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = NULL;
#line 138 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 1099 "misc.c"
	}
#line 141 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 141 "/home/jens/Source/shotwell/src/util/misc.vala"
	intersection = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_SET, GeeSet);
#line 1105 "misc.c"
	{
		GeeIterator* _element_it = NULL;
		GeeIterator* _tmp3_;
#line 143 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (a, GEE_TYPE_ITERABLE, GeeIterable));
#line 143 "/home/jens/Source/shotwell/src/util/misc.vala"
		_element_it = _tmp3_;
#line 143 "/home/jens/Source/shotwell/src/util/misc.vala"
		while (TRUE) {
#line 1115 "misc.c"
			GeeIterator* _tmp4_;
			gchar* element = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			const gchar* _tmp7_;
#line 143 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp4_ = _element_it;
#line 143 "/home/jens/Source/shotwell/src/util/misc.vala"
			if (!gee_iterator_next (_tmp4_)) {
#line 143 "/home/jens/Source/shotwell/src/util/misc.vala"
				break;
#line 1127 "misc.c"
			}
#line 143 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp5_ = _element_it;
#line 143 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 143 "/home/jens/Source/shotwell/src/util/misc.vala"
			element = (gchar*) _tmp6_;
#line 144 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp7_ = element;
#line 144 "/home/jens/Source/shotwell/src/util/misc.vala"
			if (gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (b, GEE_TYPE_COLLECTION, GeeCollection), _tmp7_)) {
#line 1139 "misc.c"
				GeeSet* _tmp8_;
				const gchar* _tmp9_;
#line 145 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp8_ = intersection;
#line 145 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp9_ = element;
#line 145 "/home/jens/Source/shotwell/src/util/misc.vala"
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection), _tmp9_);
#line 1148 "misc.c"
			} else {
#line 146 "/home/jens/Source/shotwell/src/util/misc.vala"
				if (excluded != NULL) {
#line 1152 "misc.c"
					const gchar* _tmp10_;
#line 147 "/home/jens/Source/shotwell/src/util/misc.vala"
					_tmp10_ = element;
#line 147 "/home/jens/Source/shotwell/src/util/misc.vala"
					gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (excluded, GEE_TYPE_COLLECTION, GeeCollection), _tmp10_);
#line 1158 "misc.c"
				}
			}
#line 143 "/home/jens/Source/shotwell/src/util/misc.vala"
			_g_free0 (element);
#line 1163 "misc.c"
		}
#line 143 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_object_unref0 (_element_it);
#line 1167 "misc.c"
	}
	{
		GeeIterator* _element_it = NULL;
		GeeIterator* _tmp11_;
#line 150 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp11_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (b, GEE_TYPE_ITERABLE, GeeIterable));
#line 150 "/home/jens/Source/shotwell/src/util/misc.vala"
		_element_it = _tmp11_;
#line 150 "/home/jens/Source/shotwell/src/util/misc.vala"
		while (TRUE) {
#line 1178 "misc.c"
			GeeIterator* _tmp12_;
			gchar* element = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			const gchar* _tmp15_;
#line 150 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp12_ = _element_it;
#line 150 "/home/jens/Source/shotwell/src/util/misc.vala"
			if (!gee_iterator_next (_tmp12_)) {
#line 150 "/home/jens/Source/shotwell/src/util/misc.vala"
				break;
#line 1190 "misc.c"
			}
#line 150 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp13_ = _element_it;
#line 150 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp14_ = gee_iterator_get (_tmp13_);
#line 150 "/home/jens/Source/shotwell/src/util/misc.vala"
			element = (gchar*) _tmp14_;
#line 151 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp15_ = element;
#line 151 "/home/jens/Source/shotwell/src/util/misc.vala"
			if (gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (a, GEE_TYPE_COLLECTION, GeeCollection), _tmp15_)) {
#line 1202 "misc.c"
				GeeSet* _tmp16_;
				const gchar* _tmp17_;
#line 152 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp16_ = intersection;
#line 152 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp17_ = element;
#line 152 "/home/jens/Source/shotwell/src/util/misc.vala"
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_COLLECTION, GeeCollection), _tmp17_);
#line 1211 "misc.c"
			} else {
#line 153 "/home/jens/Source/shotwell/src/util/misc.vala"
				if (excluded != NULL) {
#line 1215 "misc.c"
					const gchar* _tmp18_;
#line 154 "/home/jens/Source/shotwell/src/util/misc.vala"
					_tmp18_ = element;
#line 154 "/home/jens/Source/shotwell/src/util/misc.vala"
					gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (excluded, GEE_TYPE_COLLECTION, GeeCollection), _tmp18_);
#line 1221 "misc.c"
				}
			}
#line 150 "/home/jens/Source/shotwell/src/util/misc.vala"
			_g_free0 (element);
#line 1226 "misc.c"
		}
#line 150 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_object_unref0 (_element_it);
#line 1230 "misc.c"
	}
#line 157 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp20_ = intersection;
#line 157 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp21_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_COLLECTION, GeeCollection));
#line 157 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp22_ = _tmp21_;
#line 157 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp22_ > 0) {
#line 1240 "misc.c"
		GeeSet* _tmp23_;
#line 157 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp23_ = intersection;
#line 157 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp19_ = _tmp23_;
#line 1246 "misc.c"
	} else {
#line 157 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp19_ = NULL;
#line 1250 "misc.c"
	}
#line 157 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp24_ = _g_object_ref0 (_tmp19_);
#line 157 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = _tmp24_;
#line 157 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_object_unref0 (intersection);
#line 157 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 1260 "misc.c"
}


guchar*
serialize_photo_ids (GeeCollection* photos,
                     int* result_length1)
{
	guchar* result = NULL;
	gint64* ids = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint64* _tmp2_;
	gint ids_length1;
	gint _ids_size_;
	gint ctr = 0;
	gsize bytes = 0UL;
	gint _tmp13_;
	gint _tmp14_;
	guchar* serialized = NULL;
	guchar* _tmp15_;
	gint serialized_length1;
	gint _serialized_size_;
	gint64* _tmp16_;
	gint _tmp16__length1;
	guchar* _tmp17_;
	gint _tmp17__length1;
#line 160 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (photos), NULL);
#line 161 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = gee_collection_get_size (photos);
#line 161 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = _tmp0_;
#line 161 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = g_new0 (gint64, _tmp1_);
#line 161 "/home/jens/Source/shotwell/src/util/misc.vala"
	ids = _tmp2_;
#line 161 "/home/jens/Source/shotwell/src/util/misc.vala"
	ids_length1 = _tmp1_;
#line 161 "/home/jens/Source/shotwell/src/util/misc.vala"
	_ids_size_ = ids_length1;
#line 162 "/home/jens/Source/shotwell/src/util/misc.vala"
	ctr = 0;
#line 1303 "misc.c"
	{
		GeeIterator* _photo_it = NULL;
		GeeIterator* _tmp3_;
#line 163 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (photos, GEE_TYPE_ITERABLE, GeeIterable));
#line 163 "/home/jens/Source/shotwell/src/util/misc.vala"
		_photo_it = _tmp3_;
#line 163 "/home/jens/Source/shotwell/src/util/misc.vala"
		while (TRUE) {
#line 1313 "misc.c"
			GeeIterator* _tmp4_;
			Photo* photo = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			gint64* _tmp7_;
			gint _tmp7__length1;
			gint _tmp8_;
			Photo* _tmp9_;
			PhotoID _tmp10_ = {0};
			gint64 _tmp11_;
			gint64 _tmp12_;
#line 163 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp4_ = _photo_it;
#line 163 "/home/jens/Source/shotwell/src/util/misc.vala"
			if (!gee_iterator_next (_tmp4_)) {
#line 163 "/home/jens/Source/shotwell/src/util/misc.vala"
				break;
#line 1331 "misc.c"
			}
#line 163 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp5_ = _photo_it;
#line 163 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 163 "/home/jens/Source/shotwell/src/util/misc.vala"
			photo = (Photo*) _tmp6_;
#line 164 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp7_ = ids;
#line 164 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp7__length1 = ids_length1;
#line 164 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp8_ = ctr;
#line 164 "/home/jens/Source/shotwell/src/util/misc.vala"
			ctr = _tmp8_ + 1;
#line 164 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp9_ = photo;
#line 164 "/home/jens/Source/shotwell/src/util/misc.vala"
			photo_get_photo_id (_tmp9_, &_tmp10_);
#line 164 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp11_ = _tmp10_.id;
#line 164 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp7_[_tmp8_] = _tmp11_;
#line 164 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp12_ = _tmp7_[_tmp8_];
#line 163 "/home/jens/Source/shotwell/src/util/misc.vala"
			_g_object_unref0 (photo);
#line 1359 "misc.c"
		}
#line 163 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_object_unref0 (_photo_it);
#line 1363 "misc.c"
	}
#line 166 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp13_ = gee_collection_get_size (photos);
#line 166 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp14_ = _tmp13_;
#line 166 "/home/jens/Source/shotwell/src/util/misc.vala"
	bytes = (gsize) (_tmp14_ * sizeof (gint64));
#line 167 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp15_ = g_new0 (guchar, bytes);
#line 167 "/home/jens/Source/shotwell/src/util/misc.vala"
	serialized = _tmp15_;
#line 167 "/home/jens/Source/shotwell/src/util/misc.vala"
	serialized_length1 = bytes;
#line 167 "/home/jens/Source/shotwell/src/util/misc.vala"
	_serialized_size_ = serialized_length1;
#line 168 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp16_ = ids;
#line 168 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp16__length1 = ids_length1;
#line 168 "/home/jens/Source/shotwell/src/util/misc.vala"
	memcpy (serialized, _tmp16_, bytes);
#line 170 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp17_ = serialized;
#line 170 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp17__length1 = serialized_length1;
#line 170 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (result_length1) {
#line 170 "/home/jens/Source/shotwell/src/util/misc.vala"
		*result_length1 = _tmp17__length1;
#line 1393 "misc.c"
	}
#line 170 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = _tmp17_;
#line 170 "/home/jens/Source/shotwell/src/util/misc.vala"
	ids = (g_free (ids), NULL);
#line 170 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 1401 "misc.c"
}


GeeList*
unserialize_photo_ids (guchar* serialized,
                       gint size)
{
	GeeList* result = NULL;
	gsize count = 0UL;
	gboolean _tmp0_ = FALSE;
	gsize _tmp1_;
	gint64* ids = NULL;
	gsize _tmp2_;
	gint64* _tmp3_;
	gint ids_length1;
	gint _ids_size_;
	gint64* _tmp4_;
	gint _tmp4__length1;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp5_;
	gint64* _tmp6_;
	gint _tmp6__length1;
#line 174 "/home/jens/Source/shotwell/src/util/misc.vala"
	count = (gsize) (size / sizeof (gint64));
#line 175 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = count;
#line 175 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp1_ <= ((gsize) 0)) {
#line 175 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp0_ = TRUE;
#line 1432 "misc.c"
	} else {
#line 175 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp0_ = serialized == NULL;
#line 1436 "misc.c"
	}
#line 175 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp0_) {
#line 176 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = NULL;
#line 176 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 1444 "misc.c"
	}
#line 178 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = count;
#line 178 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp3_ = g_new0 (gint64, _tmp2_);
#line 178 "/home/jens/Source/shotwell/src/util/misc.vala"
	ids = _tmp3_;
#line 178 "/home/jens/Source/shotwell/src/util/misc.vala"
	ids_length1 = _tmp2_;
#line 178 "/home/jens/Source/shotwell/src/util/misc.vala"
	_ids_size_ = ids_length1;
#line 179 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp4_ = ids;
#line 179 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp4__length1 = ids_length1;
#line 179 "/home/jens/Source/shotwell/src/util/misc.vala"
	memcpy (_tmp4_, serialized, (gsize) size);
#line 181 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp5_ = gee_array_list_new (TYPE_PHOTO_ID, (GBoxedCopyFunc) photo_id_dup, (GDestroyNotify) photo_id_free, NULL, NULL, NULL);
#line 181 "/home/jens/Source/shotwell/src/util/misc.vala"
	list = _tmp5_;
#line 182 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp6_ = ids;
#line 182 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp6__length1 = ids_length1;
#line 1470 "misc.c"
	{
		gint64* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
#line 182 "/home/jens/Source/shotwell/src/util/misc.vala"
		id_collection = _tmp6_;
#line 182 "/home/jens/Source/shotwell/src/util/misc.vala"
		id_collection_length1 = _tmp6__length1;
#line 182 "/home/jens/Source/shotwell/src/util/misc.vala"
		for (id_it = 0; id_it < _tmp6__length1; id_it = id_it + 1) {
#line 1482 "misc.c"
			gint64 id = 0LL;
#line 182 "/home/jens/Source/shotwell/src/util/misc.vala"
			id = id_collection[id_it];
#line 1486 "misc.c"
			{
				GeeArrayList* _tmp7_;
				gint64 _tmp8_;
				PhotoID _tmp9_ = {0};
#line 183 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp7_ = list;
#line 183 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp8_ = id;
#line 183 "/home/jens/Source/shotwell/src/util/misc.vala"
				photo_id_init (&_tmp9_, _tmp8_);
#line 183 "/home/jens/Source/shotwell/src/util/misc.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), &_tmp9_);
#line 1499 "misc.c"
			}
		}
	}
#line 185 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (list, GEE_TYPE_LIST, GeeList);
#line 185 "/home/jens/Source/shotwell/src/util/misc.vala"
	ids = (g_free (ids), NULL);
#line 185 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 1509 "misc.c"
}


guchar*
serialize_media_sources (GeeCollection* media,
                         int* result_length1)
{
	guchar* result = NULL;
	GdkAtom* atoms = NULL;
	gint _tmp0_;
	gint _tmp1_;
	GdkAtom* _tmp2_;
	gint atoms_length1;
	gint _atoms_size_;
	gint ctr = 0;
	gsize bytes = 0UL;
	gint _tmp13_;
	gint _tmp14_;
	guchar* serialized = NULL;
	guchar* _tmp15_;
	gint serialized_length1;
	gint _serialized_size_;
	GdkAtom* _tmp16_;
	gint _tmp16__length1;
	guchar* _tmp17_;
	gint _tmp17__length1;
#line 188 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (media), NULL);
#line 189 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = gee_collection_get_size (media);
#line 189 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = _tmp0_;
#line 189 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = g_new0 (GdkAtom, _tmp1_);
#line 189 "/home/jens/Source/shotwell/src/util/misc.vala"
	atoms = _tmp2_;
#line 189 "/home/jens/Source/shotwell/src/util/misc.vala"
	atoms_length1 = _tmp1_;
#line 189 "/home/jens/Source/shotwell/src/util/misc.vala"
	_atoms_size_ = atoms_length1;
#line 190 "/home/jens/Source/shotwell/src/util/misc.vala"
	ctr = 0;
#line 1552 "misc.c"
	{
		GeeIterator* _current_media_it = NULL;
		GeeIterator* _tmp3_;
#line 191 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (media, GEE_TYPE_ITERABLE, GeeIterable));
#line 191 "/home/jens/Source/shotwell/src/util/misc.vala"
		_current_media_it = _tmp3_;
#line 191 "/home/jens/Source/shotwell/src/util/misc.vala"
		while (TRUE) {
#line 1562 "misc.c"
			GeeIterator* _tmp4_;
			MediaSource* current_media = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			GdkAtom* _tmp7_;
			gint _tmp7__length1;
			gint _tmp8_;
			MediaSource* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			GdkAtom _tmp12_;
#line 191 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp4_ = _current_media_it;
#line 191 "/home/jens/Source/shotwell/src/util/misc.vala"
			if (!gee_iterator_next (_tmp4_)) {
#line 191 "/home/jens/Source/shotwell/src/util/misc.vala"
				break;
#line 1580 "misc.c"
			}
#line 191 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp5_ = _current_media_it;
#line 191 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 191 "/home/jens/Source/shotwell/src/util/misc.vala"
			current_media = (MediaSource*) _tmp6_;
#line 192 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp7_ = atoms;
#line 192 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp7__length1 = atoms_length1;
#line 192 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp8_ = ctr;
#line 192 "/home/jens/Source/shotwell/src/util/misc.vala"
			ctr = _tmp8_ + 1;
#line 192 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp9_ = current_media;
#line 192 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp10_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_SOURCE, DataSource));
#line 192 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp11_ = _tmp10_;
#line 192 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp7_[_tmp8_] = gdk_atom_intern (_tmp11_, FALSE);
#line 192 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp12_ = _tmp7_[_tmp8_];
#line 192 "/home/jens/Source/shotwell/src/util/misc.vala"
			_g_free0 (_tmp11_);
#line 191 "/home/jens/Source/shotwell/src/util/misc.vala"
			_g_object_unref0 (current_media);
#line 1610 "misc.c"
		}
#line 191 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_object_unref0 (_current_media_it);
#line 1614 "misc.c"
	}
#line 194 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp13_ = gee_collection_get_size (media);
#line 194 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp14_ = _tmp13_;
#line 194 "/home/jens/Source/shotwell/src/util/misc.vala"
	bytes = (gsize) (_tmp14_ * sizeof (GdkAtom));
#line 195 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp15_ = g_new0 (guchar, bytes);
#line 195 "/home/jens/Source/shotwell/src/util/misc.vala"
	serialized = _tmp15_;
#line 195 "/home/jens/Source/shotwell/src/util/misc.vala"
	serialized_length1 = bytes;
#line 195 "/home/jens/Source/shotwell/src/util/misc.vala"
	_serialized_size_ = serialized_length1;
#line 196 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp16_ = atoms;
#line 196 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp16__length1 = atoms_length1;
#line 196 "/home/jens/Source/shotwell/src/util/misc.vala"
	memcpy (serialized, _tmp16_, bytes);
#line 198 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp17_ = serialized;
#line 198 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp17__length1 = serialized_length1;
#line 198 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (result_length1) {
#line 198 "/home/jens/Source/shotwell/src/util/misc.vala"
		*result_length1 = _tmp17__length1;
#line 1644 "misc.c"
	}
#line 198 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = _tmp17_;
#line 198 "/home/jens/Source/shotwell/src/util/misc.vala"
	atoms = (g_free (atoms), NULL);
#line 198 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 1652 "misc.c"
}


GeeList*
unserialize_media_sources (guchar* serialized,
                           gint size)
{
	GeeList* result = NULL;
	gsize count = 0UL;
	gboolean _tmp0_ = FALSE;
	gsize _tmp1_;
	GdkAtom* atoms = NULL;
	gsize _tmp2_;
	GdkAtom* _tmp3_;
	gint atoms_length1;
	gint _atoms_size_;
	GdkAtom* _tmp4_;
	gint _tmp4__length1;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp5_;
	GdkAtom* _tmp6_;
	gint _tmp6__length1;
#line 202 "/home/jens/Source/shotwell/src/util/misc.vala"
	count = (gsize) (size / sizeof (GdkAtom));
#line 203 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = count;
#line 203 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp1_ <= ((gsize) 0)) {
#line 203 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp0_ = TRUE;
#line 1683 "misc.c"
	} else {
#line 203 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp0_ = serialized == NULL;
#line 1687 "misc.c"
	}
#line 203 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp0_) {
#line 204 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = NULL;
#line 204 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 1695 "misc.c"
	}
#line 206 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = count;
#line 206 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp3_ = g_new0 (GdkAtom, _tmp2_);
#line 206 "/home/jens/Source/shotwell/src/util/misc.vala"
	atoms = _tmp3_;
#line 206 "/home/jens/Source/shotwell/src/util/misc.vala"
	atoms_length1 = _tmp2_;
#line 206 "/home/jens/Source/shotwell/src/util/misc.vala"
	_atoms_size_ = atoms_length1;
#line 207 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp4_ = atoms;
#line 207 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp4__length1 = atoms_length1;
#line 207 "/home/jens/Source/shotwell/src/util/misc.vala"
	memcpy (_tmp4_, serialized, (gsize) size);
#line 209 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp5_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 209 "/home/jens/Source/shotwell/src/util/misc.vala"
	list = _tmp5_;
#line 210 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp6_ = atoms;
#line 210 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp6__length1 = atoms_length1;
#line 1721 "misc.c"
	{
		GdkAtom* current_atom_collection = NULL;
		gint current_atom_collection_length1 = 0;
		gint _current_atom_collection_size_ = 0;
		gint current_atom_it = 0;
#line 210 "/home/jens/Source/shotwell/src/util/misc.vala"
		current_atom_collection = _tmp6_;
#line 210 "/home/jens/Source/shotwell/src/util/misc.vala"
		current_atom_collection_length1 = _tmp6__length1;
#line 210 "/home/jens/Source/shotwell/src/util/misc.vala"
		for (current_atom_it = 0; current_atom_it < _tmp6__length1; current_atom_it = current_atom_it + 1) {
#line 1733 "misc.c"
			GdkAtom current_atom = 0U;
#line 210 "/home/jens/Source/shotwell/src/util/misc.vala"
			current_atom = current_atom_collection[current_atom_it];
#line 1737 "misc.c"
			{
				MediaSource* media = NULL;
				MediaCollectionRegistry* _tmp7_;
				MediaCollectionRegistry* _tmp8_;
				GdkAtom _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				MediaSource* _tmp12_;
				MediaSource* _tmp13_;
				MediaSource* _tmp14_;
				GeeArrayList* _tmp15_;
				MediaSource* _tmp16_;
#line 211 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp7_ = media_collection_registry_get_instance ();
#line 211 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp8_ = _tmp7_;
#line 211 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp9_ = current_atom;
#line 211 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp10_ = gdk_atom_name (_tmp9_);
#line 211 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp11_ = _tmp10_;
#line 211 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp12_ = media_collection_registry_fetch_media (_tmp8_, _tmp11_);
#line 211 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp13_ = _tmp12_;
#line 211 "/home/jens/Source/shotwell/src/util/misc.vala"
				_g_free0 (_tmp11_);
#line 211 "/home/jens/Source/shotwell/src/util/misc.vala"
				_media_collection_registry_unref0 (_tmp8_);
#line 211 "/home/jens/Source/shotwell/src/util/misc.vala"
				media = _tmp13_;
#line 212 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp14_ = media;
#line 212 "/home/jens/Source/shotwell/src/util/misc.vala"
				_vala_assert (_tmp14_ != NULL, "media != null");
#line 213 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp15_ = list;
#line 213 "/home/jens/Source/shotwell/src/util/misc.vala"
				_tmp16_ = media;
#line 213 "/home/jens/Source/shotwell/src/util/misc.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp16_);
#line 210 "/home/jens/Source/shotwell/src/util/misc.vala"
				_g_object_unref0 (media);
#line 1782 "misc.c"
			}
		}
	}
#line 216 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (list, GEE_TYPE_LIST, GeeList);
#line 216 "/home/jens/Source/shotwell/src/util/misc.vala"
	atoms = (g_free (atoms), NULL);
#line 216 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 1792 "misc.c"
}


static gchar*
g_time_format (struct tm *self,
               const gchar* format)
{
	gchar* result = NULL;
	gchar* buffer = NULL;
	gchar* _tmp0_;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	gchar* _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
#line 2874 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (format != NULL, NULL);
#line 2875 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 64);
#line 2875 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	buffer = _tmp0_;
#line 2875 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	buffer_length1 = 64;
#line 2875 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_buffer_size_ = buffer_length1;
#line 2876 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = buffer;
#line 2876 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1__length1 = buffer_length1;
#line 2876 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	strftime (_tmp1_, _tmp1__length1, format, &(*self));
#line 2877 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp2_ = buffer;
#line 2877 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp2__length1 = buffer_length1;
#line 2877 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
#line 2877 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp3_;
#line 2877 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	buffer = (g_free (buffer), NULL);
#line 2877 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 1838 "misc.c"
}


gchar*
format_local_datespan (struct tm* from_date,
                       struct tm* to_date)
{
	gchar* result = NULL;
	gchar* from_format = NULL;
	gchar* to_format = NULL;
	struct tm _tmp0_;
	gint _tmp1_;
	struct tm _tmp2_;
	gint _tmp3_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
#line 219 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (from_date != NULL, NULL);
#line 219 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (to_date != NULL, NULL);
#line 224 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = *from_date;
#line 224 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = _tmp0_.tm_year;
#line 224 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = *to_date;
#line 224 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp3_ = _tmp2_.tm_year;
#line 224 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp1_ == _tmp3_) {
#line 1877 "misc.c"
		gboolean _tmp4_ = FALSE;
		struct tm _tmp5_;
		gint _tmp6_;
		struct tm _tmp7_;
		gint _tmp8_;
#line 226 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp5_ = *from_date;
#line 226 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp6_ = _tmp5_.tm_mon;
#line 226 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp7_ = *to_date;
#line 226 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp8_ = _tmp7_.tm_mon;
#line 226 "/home/jens/Source/shotwell/src/util/misc.vala"
		if (_tmp6_ == _tmp8_) {
#line 1893 "misc.c"
			struct tm _tmp9_;
			gint _tmp10_;
			struct tm _tmp11_;
			gint _tmp12_;
#line 226 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp9_ = *from_date;
#line 226 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp10_ = _tmp9_.tm_mday;
#line 226 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp11_ = *to_date;
#line 226 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp12_ = _tmp11_.tm_mday;
#line 226 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp4_ = _tmp10_ == (_tmp12_ - 1);
#line 1908 "misc.c"
		} else {
#line 226 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp4_ = FALSE;
#line 1912 "misc.c"
		}
#line 226 "/home/jens/Source/shotwell/src/util/misc.vala"
		if (_tmp4_) {
#line 1916 "misc.c"
			gchar* _tmp13_;
			gchar* _tmp14_;
#line 228 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp13_ = resources_get_start_multiday_span_format_string ();
#line 228 "/home/jens/Source/shotwell/src/util/misc.vala"
			_g_free0 (from_format);
#line 228 "/home/jens/Source/shotwell/src/util/misc.vala"
			from_format = _tmp13_;
#line 229 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp14_ = resources_get_end_multiday_span_format_string ();
#line 229 "/home/jens/Source/shotwell/src/util/misc.vala"
			_g_free0 (to_format);
#line 229 "/home/jens/Source/shotwell/src/util/misc.vala"
			to_format = _tmp14_;
#line 1931 "misc.c"
		} else {
			gchar* _tmp15_;
			gchar* _tmp16_;
#line 233 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp15_ = resources_get_start_multimonth_span_format_string ();
#line 233 "/home/jens/Source/shotwell/src/util/misc.vala"
			_g_free0 (from_format);
#line 233 "/home/jens/Source/shotwell/src/util/misc.vala"
			from_format = _tmp15_;
#line 234 "/home/jens/Source/shotwell/src/util/misc.vala"
			_tmp16_ = resources_get_end_multimonth_span_format_string ();
#line 234 "/home/jens/Source/shotwell/src/util/misc.vala"
			_g_free0 (to_format);
#line 234 "/home/jens/Source/shotwell/src/util/misc.vala"
			to_format = _tmp16_;
#line 1947 "misc.c"
		}
	} else {
		gchar* _tmp17_;
		gchar* _tmp18_;
#line 239 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp17_ = resources_get_long_date_format_string ();
#line 239 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_free0 (from_format);
#line 239 "/home/jens/Source/shotwell/src/util/misc.vala"
		from_format = _tmp17_;
#line 240 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp18_ = resources_get_long_date_format_string ();
#line 240 "/home/jens/Source/shotwell/src/util/misc.vala"
		_g_free0 (to_format);
#line 240 "/home/jens/Source/shotwell/src/util/misc.vala"
		to_format = _tmp18_;
#line 1964 "misc.c"
	}
#line 243 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp19_ = from_format;
#line 243 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp20_ = g_time_format (from_date, _tmp19_);
#line 243 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp21_ = _tmp20_;
#line 243 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp22_ = to_format;
#line 243 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp23_ = g_time_format (to_date, _tmp22_);
#line 243 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp24_ = _tmp23_;
#line 243 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp25_ = g_strdup_printf ("%s - %s", _tmp21_, _tmp24_);
#line 243 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp26_ = _tmp25_;
#line 243 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp27_ = string_strip_leading_zeroes (_tmp26_);
#line 243 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp28_ = _tmp27_;
#line 243 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_free0 (_tmp26_);
#line 243 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_free0 (_tmp24_);
#line 243 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_free0 (_tmp21_);
#line 243 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = _tmp28_;
#line 243 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_free0 (to_format);
#line 243 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_free0 (from_format);
#line 243 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 2000 "misc.c"
}


gchar*
format_local_date (struct tm* date)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
#line 247 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (date != NULL, NULL);
#line 248 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = resources_get_long_date_format_string ();
#line 248 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = _tmp0_;
#line 248 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = g_time_format (date, _tmp1_);
#line 248 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp3_ = _tmp2_;
#line 248 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp4_ = string_strip_leading_zeroes (_tmp3_);
#line 248 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp5_ = _tmp4_;
#line 248 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_free0 (_tmp3_);
#line 248 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_free0 (_tmp1_);
#line 248 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = _tmp5_;
#line 248 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 2036 "misc.c"
}


OneShotScheduler*
one_shot_scheduler_construct (GType object_type,
                              const gchar* name,
                              OneShotCallback callback,
                              void* callback_target)
{
	OneShotScheduler* self = NULL;
	gchar* _tmp0_;
#line 258 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 258 "/home/jens/Source/shotwell/src/util/misc.vala"
	self = (OneShotScheduler*) g_type_create_instance (object_type);
#line 259 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = g_strdup (name);
#line 259 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_free0 (self->priv->name);
#line 259 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->name = _tmp0_;
#line 260 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->callback = callback;
#line 260 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->callback_target = callback_target;
#line 258 "/home/jens/Source/shotwell/src/util/misc.vala"
	return self;
#line 2064 "misc.c"
}


OneShotScheduler*
one_shot_scheduler_new (const gchar* name,
                        OneShotCallback callback,
                        void* callback_target)
{
#line 258 "/home/jens/Source/shotwell/src/util/misc.vala"
	return one_shot_scheduler_construct (TYPE_ONE_SHOT_SCHEDULER, name, callback, callback_target);
#line 2075 "misc.c"
}


gboolean
one_shot_scheduler_is_scheduled (OneShotScheduler* self)
{
	gboolean result = FALSE;
	guint _tmp0_;
#line 271 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (IS_ONE_SHOT_SCHEDULER (self), FALSE);
#line 272 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = self->priv->scheduled;
#line 272 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = _tmp0_ != ((guint) 0);
#line 272 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 2092 "misc.c"
}


void
one_shot_scheduler_at_idle (OneShotScheduler* self)
{
#line 275 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_if_fail (IS_ONE_SHOT_SCHEDULER (self));
#line 276 "/home/jens/Source/shotwell/src/util/misc.vala"
	one_shot_scheduler_at_priority_idle (self, G_PRIORITY_DEFAULT_IDLE);
#line 2103 "misc.c"
}


static gboolean
_one_shot_scheduler_callback_wrapper_gsource_func (gpointer self)
{
	gboolean result;
	result = one_shot_scheduler_callback_wrapper ((OneShotScheduler*) self);
#line 281 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 2114 "misc.c"
}


void
one_shot_scheduler_at_priority_idle (OneShotScheduler* self,
                                     gint priority)
{
	guint _tmp0_;
#line 279 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_if_fail (IS_ONE_SHOT_SCHEDULER (self));
#line 280 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = self->priv->scheduled;
#line 280 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp0_ == ((guint) 0)) {
#line 281 "/home/jens/Source/shotwell/src/util/misc.vala"
		self->priv->scheduled = g_idle_add_full (priority, _one_shot_scheduler_callback_wrapper_gsource_func, one_shot_scheduler_ref (self), one_shot_scheduler_unref);
#line 2131 "misc.c"
	}
}


void
one_shot_scheduler_after_timeout (OneShotScheduler* self,
                                  guint msec,
                                  gboolean reschedule)
{
#line 284 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_if_fail (IS_ONE_SHOT_SCHEDULER (self));
#line 285 "/home/jens/Source/shotwell/src/util/misc.vala"
	one_shot_scheduler_priority_after_timeout (self, G_PRIORITY_DEFAULT, msec, reschedule);
#line 2145 "misc.c"
}


void
one_shot_scheduler_priority_after_timeout (OneShotScheduler* self,
                                           gint priority,
                                           guint msec,
                                           gboolean reschedule)
{
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
	guint _tmp2_;
#line 288 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_if_fail (IS_ONE_SHOT_SCHEDULER (self));
#line 289 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = self->priv->scheduled;
#line 289 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 289 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp0_ = !reschedule;
#line 2166 "misc.c"
	} else {
#line 289 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp0_ = FALSE;
#line 2170 "misc.c"
	}
#line 289 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp0_) {
#line 290 "/home/jens/Source/shotwell/src/util/misc.vala"
		return;
#line 2176 "misc.c"
	}
#line 292 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = self->priv->scheduled;
#line 292 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp2_ != ((guint) 0)) {
#line 2182 "misc.c"
		guint _tmp3_;
#line 293 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp3_ = self->priv->scheduled;
#line 293 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_source_remove (_tmp3_);
#line 2188 "misc.c"
	}
#line 295 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->scheduled = g_timeout_add_full (priority, msec, _one_shot_scheduler_callback_wrapper_gsource_func, one_shot_scheduler_ref (self), one_shot_scheduler_unref);
#line 2192 "misc.c"
}


void
one_shot_scheduler_cancel (OneShotScheduler* self)
{
	guint _tmp0_;
	guint _tmp1_;
#line 298 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_if_fail (IS_ONE_SHOT_SCHEDULER (self));
#line 299 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = self->priv->scheduled;
#line 299 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp0_ == ((guint) 0)) {
#line 300 "/home/jens/Source/shotwell/src/util/misc.vala"
		return;
#line 2209 "misc.c"
	}
#line 302 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = self->priv->scheduled;
#line 302 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_source_remove (_tmp1_);
#line 303 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->scheduled = (guint) 0;
#line 2217 "misc.c"
}


static gboolean
one_shot_scheduler_callback_wrapper (OneShotScheduler* self)
{
	gboolean result = FALSE;
	OneShotCallback _tmp0_;
	void* _tmp0__target;
#line 306 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (IS_ONE_SHOT_SCHEDULER (self), FALSE);
#line 307 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->scheduled = (guint) 0;
#line 308 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = self->priv->callback;
#line 308 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0__target = self->priv->callback_target;
#line 308 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ (_tmp0__target);
#line 310 "/home/jens/Source/shotwell/src/util/misc.vala"
	result = FALSE;
#line 310 "/home/jens/Source/shotwell/src/util/misc.vala"
	return result;
#line 2241 "misc.c"
}


static void
value_one_shot_scheduler_init (GValue* value)
{
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	value->data[0].v_pointer = NULL;
#line 2250 "misc.c"
}


static void
value_one_shot_scheduler_free_value (GValue* value)
{
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (value->data[0].v_pointer) {
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
		one_shot_scheduler_unref (value->data[0].v_pointer);
#line 2261 "misc.c"
	}
}


static void
value_one_shot_scheduler_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (src_value->data[0].v_pointer) {
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
		dest_value->data[0].v_pointer = one_shot_scheduler_ref (src_value->data[0].v_pointer);
#line 2274 "misc.c"
	} else {
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2278 "misc.c"
	}
}


static gpointer
value_one_shot_scheduler_peek_pointer (const GValue* value)
{
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	return value->data[0].v_pointer;
#line 2288 "misc.c"
}


static gchar*
value_one_shot_scheduler_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (collect_values[0].v_pointer) {
#line 2300 "misc.c"
		OneShotScheduler * object;
		object = collect_values[0].v_pointer;
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
		if (object->parent_instance.g_class == NULL) {
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2307 "misc.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2311 "misc.c"
		}
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = one_shot_scheduler_ref (object);
#line 2315 "misc.c"
	} else {
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = NULL;
#line 2319 "misc.c"
	}
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	return NULL;
#line 2323 "misc.c"
}


static gchar*
value_one_shot_scheduler_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	OneShotScheduler ** object_p;
	object_p = collect_values[0].v_pointer;
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (!object_p) {
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2339 "misc.c"
	}
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (!value->data[0].v_pointer) {
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
		*object_p = NULL;
#line 2345 "misc.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
		*object_p = value->data[0].v_pointer;
#line 2349 "misc.c"
	} else {
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
		*object_p = one_shot_scheduler_ref (value->data[0].v_pointer);
#line 2353 "misc.c"
	}
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	return NULL;
#line 2357 "misc.c"
}


GParamSpec*
param_spec_one_shot_scheduler (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	ParamSpecOneShotScheduler* spec;
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ONE_SHOT_SCHEDULER), NULL);
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	return G_PARAM_SPEC (spec);
#line 2377 "misc.c"
}


gpointer
value_get_one_shot_scheduler (const GValue* value)
{
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ONE_SHOT_SCHEDULER), NULL);
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	return value->data[0].v_pointer;
#line 2388 "misc.c"
}


void
value_set_one_shot_scheduler (GValue* value,
                              gpointer v_object)
{
	OneShotScheduler * old;
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ONE_SHOT_SCHEDULER));
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	old = value->data[0].v_pointer;
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (v_object) {
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ONE_SHOT_SCHEDULER));
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = v_object;
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
		one_shot_scheduler_ref (value->data[0].v_pointer);
#line 2411 "misc.c"
	} else {
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = NULL;
#line 2415 "misc.c"
	}
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (old) {
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
		one_shot_scheduler_unref (old);
#line 2421 "misc.c"
	}
}


void
value_take_one_shot_scheduler (GValue* value,
                               gpointer v_object)
{
	OneShotScheduler * old;
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ONE_SHOT_SCHEDULER));
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	old = value->data[0].v_pointer;
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (v_object) {
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ONE_SHOT_SCHEDULER));
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = v_object;
#line 2443 "misc.c"
	} else {
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = NULL;
#line 2447 "misc.c"
	}
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (old) {
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
		one_shot_scheduler_unref (old);
#line 2453 "misc.c"
	}
}


static void
one_shot_scheduler_class_init (OneShotSchedulerClass * klass)
{
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	one_shot_scheduler_parent_class = g_type_class_peek_parent (klass);
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	((OneShotSchedulerClass *) klass)->finalize = one_shot_scheduler_finalize;
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_type_class_add_private (klass, sizeof (OneShotSchedulerPrivate));
#line 2467 "misc.c"
}


static void
one_shot_scheduler_instance_init (OneShotScheduler * self)
{
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv = ONE_SHOT_SCHEDULER_GET_PRIVATE (self);
#line 256 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->scheduled = (guint) 0;
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->ref_count = 1;
#line 2480 "misc.c"
}


static void
one_shot_scheduler_finalize (OneShotScheduler * obj)
{
	OneShotScheduler * self;
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ONE_SHOT_SCHEDULER, OneShotScheduler);
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_signal_handlers_destroy (self);
#line 268 "/home/jens/Source/shotwell/src/util/misc.vala"
	one_shot_scheduler_cancel (self);
#line 254 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_free0 (self->priv->name);
#line 2496 "misc.c"
}


GType
one_shot_scheduler_get_type (void)
{
	static volatile gsize one_shot_scheduler_type_id__volatile = 0;
	if (g_once_init_enter (&one_shot_scheduler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_one_shot_scheduler_init, value_one_shot_scheduler_free_value, value_one_shot_scheduler_copy_value, value_one_shot_scheduler_peek_pointer, "p", value_one_shot_scheduler_collect_value, "p", value_one_shot_scheduler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (OneShotSchedulerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) one_shot_scheduler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OneShotScheduler), 0, (GInstanceInitFunc) one_shot_scheduler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType one_shot_scheduler_type_id;
		one_shot_scheduler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "OneShotScheduler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&one_shot_scheduler_type_id__volatile, one_shot_scheduler_type_id);
	}
	return one_shot_scheduler_type_id__volatile;
}


gpointer
one_shot_scheduler_ref (gpointer instance)
{
	OneShotScheduler * self;
	self = instance;
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_atomic_int_inc (&self->ref_count);
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	return instance;
#line 2525 "misc.c"
}


void
one_shot_scheduler_unref (gpointer instance)
{
	OneShotScheduler * self;
	self = instance;
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
		ONE_SHOT_SCHEDULER_GET_CLASS (self)->finalize (self);
#line 253 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2540 "misc.c"
	}
}


OpTimer*
op_timer_construct (GType object_type,
                    const gchar* name)
{
	OpTimer* self = NULL;
	gchar* _tmp0_;
#line 322 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 322 "/home/jens/Source/shotwell/src/util/misc.vala"
	self = (OpTimer*) g_type_create_instance (object_type);
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = g_strdup (name);
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_free0 (self->priv->name);
#line 323 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->name = _tmp0_;
#line 322 "/home/jens/Source/shotwell/src/util/misc.vala"
	return self;
#line 2563 "misc.c"
}


OpTimer*
op_timer_new (const gchar* name)
{
#line 322 "/home/jens/Source/shotwell/src/util/misc.vala"
	return op_timer_construct (TYPE_OP_TIMER, name);
#line 2572 "misc.c"
}


void
op_timer_start (OpTimer* self)
{
	GTimer* _tmp0_;
#line 326 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_if_fail (IS_OP_TIMER (self));
#line 327 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = self->priv->timer;
#line 327 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_timer_start (_tmp0_);
#line 2586 "misc.c"
}


void
op_timer_stop (OpTimer* self)
{
	gdouble time = 0.0;
	GTimer* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	glong _tmp10_;
#line 330 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_if_fail (IS_OP_TIMER (self));
#line 331 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = self->priv->timer;
#line 331 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp1_ = g_timer_elapsed (_tmp0_, NULL);
#line 331 "/home/jens/Source/shotwell/src/util/misc.vala"
	time = _tmp1_;
#line 333 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp2_ = self->priv->elapsed;
#line 333 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp3_ = time;
#line 333 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->elapsed = _tmp2_ + _tmp3_;
#line 335 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp4_ = time;
#line 335 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp5_ = self->priv->shortest;
#line 335 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp4_ < _tmp5_) {
#line 2623 "misc.c"
		gdouble _tmp6_;
#line 336 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp6_ = time;
#line 336 "/home/jens/Source/shotwell/src/util/misc.vala"
		self->priv->shortest = _tmp6_;
#line 2629 "misc.c"
	}
#line 338 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp7_ = time;
#line 338 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp8_ = self->priv->longest;
#line 338 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp7_ > _tmp8_) {
#line 2637 "misc.c"
		gdouble _tmp9_;
#line 339 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp9_ = time;
#line 339 "/home/jens/Source/shotwell/src/util/misc.vala"
		self->priv->longest = _tmp9_;
#line 2643 "misc.c"
	}
#line 341 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp10_ = self->priv->count;
#line 341 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->count = _tmp10_ + 1;
#line 2649 "misc.c"
}


gchar*
op_timer_to_string (OpTimer* self)
{
	gchar* result = NULL;
	glong _tmp0_;
#line 344 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (IS_OP_TIMER (self), NULL);
#line 345 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = self->priv->count;
#line 345 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (_tmp0_ > ((glong) 0)) {
#line 2664 "misc.c"
		const gchar* _tmp1_;
		glong _tmp2_;
		gdouble _tmp3_;
		gdouble _tmp4_;
		gdouble _tmp5_;
		glong _tmp6_;
		gdouble _tmp7_;
		gchar* _tmp8_;
#line 346 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp1_ = self->priv->name;
#line 346 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp2_ = self->priv->count;
#line 346 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp3_ = self->priv->elapsed;
#line 346 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp4_ = self->priv->shortest;
#line 346 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp5_ = self->priv->elapsed;
#line 346 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp6_ = self->priv->count;
#line 346 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp7_ = self->priv->longest;
#line 346 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp8_ = g_strdup_printf ("%s: count=%ld elapsed=%.03lfs min/avg/max=%.03lf/%.03lf/%.03lf", _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_ / ((gdouble) _tmp6_), _tmp7_);
#line 346 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = _tmp8_;
#line 346 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 2693 "misc.c"
	} else {
		const gchar* _tmp9_;
		gchar* _tmp10_;
#line 349 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp9_ = self->priv->name;
#line 349 "/home/jens/Source/shotwell/src/util/misc.vala"
		_tmp10_ = g_strdup_printf ("%s: no operations", _tmp9_);
#line 349 "/home/jens/Source/shotwell/src/util/misc.vala"
		result = _tmp10_;
#line 349 "/home/jens/Source/shotwell/src/util/misc.vala"
		return result;
#line 2705 "misc.c"
	}
}


static void
value_op_timer_init (GValue* value)
{
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	value->data[0].v_pointer = NULL;
#line 2715 "misc.c"
}


static void
value_op_timer_free_value (GValue* value)
{
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (value->data[0].v_pointer) {
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
		op_timer_unref (value->data[0].v_pointer);
#line 2726 "misc.c"
	}
}


static void
value_op_timer_copy_value (const GValue* src_value,
                           GValue* dest_value)
{
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (src_value->data[0].v_pointer) {
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
		dest_value->data[0].v_pointer = op_timer_ref (src_value->data[0].v_pointer);
#line 2739 "misc.c"
	} else {
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2743 "misc.c"
	}
}


static gpointer
value_op_timer_peek_pointer (const GValue* value)
{
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	return value->data[0].v_pointer;
#line 2753 "misc.c"
}


static gchar*
value_op_timer_collect_value (GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (collect_values[0].v_pointer) {
#line 2765 "misc.c"
		OpTimer * object;
		object = collect_values[0].v_pointer;
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
		if (object->parent_instance.g_class == NULL) {
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2772 "misc.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2776 "misc.c"
		}
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = op_timer_ref (object);
#line 2780 "misc.c"
	} else {
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = NULL;
#line 2784 "misc.c"
	}
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	return NULL;
#line 2788 "misc.c"
}


static gchar*
value_op_timer_lcopy_value (const GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
	OpTimer ** object_p;
	object_p = collect_values[0].v_pointer;
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (!object_p) {
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2804 "misc.c"
	}
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (!value->data[0].v_pointer) {
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
		*object_p = NULL;
#line 2810 "misc.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
		*object_p = value->data[0].v_pointer;
#line 2814 "misc.c"
	} else {
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
		*object_p = op_timer_ref (value->data[0].v_pointer);
#line 2818 "misc.c"
	}
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	return NULL;
#line 2822 "misc.c"
}


GParamSpec*
param_spec_op_timer (const gchar* name,
                     const gchar* nick,
                     const gchar* blurb,
                     GType object_type,
                     GParamFlags flags)
{
	ParamSpecOpTimer* spec;
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_OP_TIMER), NULL);
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	return G_PARAM_SPEC (spec);
#line 2842 "misc.c"
}


gpointer
value_get_op_timer (const GValue* value)
{
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_OP_TIMER), NULL);
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	return value->data[0].v_pointer;
#line 2853 "misc.c"
}


void
value_set_op_timer (GValue* value,
                    gpointer v_object)
{
	OpTimer * old;
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_OP_TIMER));
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	old = value->data[0].v_pointer;
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (v_object) {
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_OP_TIMER));
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = v_object;
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
		op_timer_ref (value->data[0].v_pointer);
#line 2876 "misc.c"
	} else {
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = NULL;
#line 2880 "misc.c"
	}
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (old) {
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
		op_timer_unref (old);
#line 2886 "misc.c"
	}
}


void
value_take_op_timer (GValue* value,
                     gpointer v_object)
{
	OpTimer * old;
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_OP_TIMER));
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	old = value->data[0].v_pointer;
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (v_object) {
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_OP_TIMER));
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = v_object;
#line 2908 "misc.c"
	} else {
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
		value->data[0].v_pointer = NULL;
#line 2912 "misc.c"
	}
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (old) {
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
		op_timer_unref (old);
#line 2918 "misc.c"
	}
}


static void
op_timer_class_init (OpTimerClass * klass)
{
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	op_timer_parent_class = g_type_class_peek_parent (klass);
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	((OpTimerClass *) klass)->finalize = op_timer_finalize;
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_type_class_add_private (klass, sizeof (OpTimerPrivate));
#line 2932 "misc.c"
}


static void
op_timer_instance_init (OpTimer * self)
{
	GTimer* _tmp0_;
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv = OP_TIMER_GET_PRIVATE (self);
#line 316 "/home/jens/Source/shotwell/src/util/misc.vala"
	_tmp0_ = g_timer_new ();
#line 316 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->timer = _tmp0_;
#line 317 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->count = (glong) 0;
#line 318 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->elapsed = (gdouble) 0;
#line 319 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->shortest = DBL_MAX;
#line 320 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->priv->longest = DBL_MIN;
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	self->ref_count = 1;
#line 2956 "misc.c"
}


static void
op_timer_finalize (OpTimer * obj)
{
	OpTimer * self;
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_OP_TIMER, OpTimer);
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_signal_handlers_destroy (self);
#line 315 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_free0 (self->priv->name);
#line 316 "/home/jens/Source/shotwell/src/util/misc.vala"
	_g_timer_destroy0 (self->priv->timer);
#line 2972 "misc.c"
}


GType
op_timer_get_type (void)
{
	static volatile gsize op_timer_type_id__volatile = 0;
	if (g_once_init_enter (&op_timer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_op_timer_init, value_op_timer_free_value, value_op_timer_copy_value, value_op_timer_peek_pointer, "p", value_op_timer_collect_value, "p", value_op_timer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (OpTimerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) op_timer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OpTimer), 0, (GInstanceInitFunc) op_timer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType op_timer_type_id;
		op_timer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "OpTimer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&op_timer_type_id__volatile, op_timer_type_id);
	}
	return op_timer_type_id__volatile;
}


gpointer
op_timer_ref (gpointer instance)
{
	OpTimer * self;
	self = instance;
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	g_atomic_int_inc (&self->ref_count);
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	return instance;
#line 3001 "misc.c"
}


void
op_timer_unref (gpointer instance)
{
	OpTimer * self;
	self = instance;
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
		OP_TIMER_GET_CLASS (self)->finalize (self);
#line 314 "/home/jens/Source/shotwell/src/util/misc.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3016 "misc.c"
	}
}



