/* book.c generated by valac 0.22.1, the Vala compiler
 * generated from book.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <cairo-ps.h>
#include <zlib.h>
#include <gobject/gvaluecollector.h>


#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
typedef struct _BookPrivate BookPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define __g_list_free__page_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__page_unref0_ (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define TYPE_PS_WRITER (ps_writer_get_type ())
#define PS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PS_WRITER, PsWriter))
#define PS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PS_WRITER, PsWriterClass))
#define IS_PS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PS_WRITER))
#define IS_PS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PS_WRITER))
#define PS_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PS_WRITER, PsWriterClass))

typedef struct _PsWriter PsWriter;
typedef struct _PsWriterClass PsWriterClass;
typedef struct _PsWriterPrivate PsWriterPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _ps_writer_unref0(var) ((var == NULL) ? NULL : (var = (ps_writer_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_PDF_WRITER (pdf_writer_get_type ())
#define PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PDF_WRITER, PDFWriter))
#define PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PDF_WRITER, PDFWriterClass))
#define IS_PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PDF_WRITER))
#define IS_PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PDF_WRITER))
#define PDF_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PDF_WRITER, PDFWriterClass))

typedef struct _PDFWriter PDFWriter;
typedef struct _PDFWriterClass PDFWriterClass;
typedef struct _PDFWriterPrivate PDFWriterPrivate;
#define _pdf_writer_unref0(var) ((var == NULL) ? NULL : (var = (pdf_writer_unref (var), NULL)))
typedef struct _ParamSpecBook ParamSpecBook;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _ParamSpecPDFWriter ParamSpecPDFWriter;
typedef struct _ParamSpecPsWriter ParamSpecPsWriter;

struct _Book {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookPrivate * priv;
};

struct _BookClass {
	GTypeClass parent_class;
	void (*finalize) (Book *self);
};

struct _BookPrivate {
	GList* pages;
	gboolean needs_saving;
	GByteArray* jpeg_data;
};

struct _PsWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PsWriterPrivate * priv;
	cairo_surface_t* surface;
	GFileOutputStream* stream;
};

struct _PsWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PsWriter *self);
};

struct _PDFWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PDFWriterPrivate * priv;
	gsize offset;
	GList* object_offsets;
};

struct _PDFWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PDFWriter *self);
};

struct _ParamSpecBook {
	GParamSpec parent_instance;
};

struct _PDFWriterPrivate {
	GFileOutputStream* stream;
};

struct _ParamSpecPDFWriter {
	GParamSpec parent_instance;
};

struct _ParamSpecPsWriter {
	GParamSpec parent_instance;
};


static gpointer book_parent_class = NULL;
static gpointer pdf_writer_parent_class = NULL;
static gpointer ps_writer_parent_class = NULL;

gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
#define BOOK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BOOK, BookPrivate))
enum  {
	BOOK_DUMMY_PROPERTY
};
static void book_page_changed_cb (Book* self, Page* page);
static void _book_page_changed_cb_page_pixels_changed (Page* _sender, gpointer self);
static void _book_page_changed_cb_page_crop_changed (Page* _sender, gpointer self);
static void _page_unref0_ (gpointer var);
static void _g_list_free__page_unref0_ (GList* self);
Book* book_new (void);
Book* book_construct (GType object_type);
void book_clear (Book* self);
void book_set_needs_saving (Book* self, gboolean needs_saving);
void book_append_page (Book* self, Page* page);
void book_move_page (Book* self, Page* page, guint location);
void book_delete_page (Book* self, Page* page);
guint book_get_n_pages (Book* self);
Page* book_get_page (Book* self, gint page_number);
guint book_get_page_index (Book* self, Page* page);
static GFile* book_make_indexed_file (Book* self, const gchar* uri, gint i);
static void book_save_multi_file (Book* self, const gchar* type, gint quality, GFile* file, GError** error);
void page_save (Page* self, const gchar* type, gint quality, GFile* file, GError** error);
static void book_save_ps_pdf_surface (Book* self, cairo_surface_t* surface, GdkPixbuf* image, gdouble dpi);
static void book_save_ps (Book* self, GFile* file, GError** error);
gpointer ps_writer_ref (gpointer instance);
void ps_writer_unref (gpointer instance);
GParamSpec* param_spec_ps_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_ps_writer (GValue* value, gpointer v_object);
void value_take_ps_writer (GValue* value, gpointer v_object);
gpointer value_get_ps_writer (const GValue* value);
GType ps_writer_get_type (void) G_GNUC_CONST;
PsWriter* ps_writer_new (GFileOutputStream* stream);
PsWriter* ps_writer_construct (GType object_type, GFileOutputStream* stream);
GdkPixbuf* page_get_image (Page* self, gboolean apply_crop);
gint page_get_dpi (Page* self);
static guint8* book_compress_zlib (Book* self, guint8* data, int data_length1, int* result_length1);
static guint8* book_compress_jpeg (Book* self, GdkPixbuf* image, gint quality, gint dpi, int* result_length1);
static gboolean book_write_pixbuf_data (Book* self, guint8* buf, int buf_length1, GError** error);
static gboolean _book_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf, gsize buf_length1, GError** error, gpointer self);
static void book_save_pdf (Book* self, GFile* file, gint quality, GError** error);
gpointer pdf_writer_ref (gpointer instance);
void pdf_writer_unref (gpointer instance);
GParamSpec* param_spec_pdf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pdf_writer (GValue* value, gpointer v_object);
void value_take_pdf_writer (GValue* value, gpointer v_object);
gpointer value_get_pdf_writer (const GValue* value);
GType pdf_writer_get_type (void) G_GNUC_CONST;
PDFWriter* pdf_writer_new (GFileOutputStream* stream);
PDFWriter* pdf_writer_construct (GType object_type, GFileOutputStream* stream);
void pdf_writer_write_string (PDFWriter* self, const gchar* text);
guint pdf_writer_start_object (PDFWriter* self);
gboolean page_is_color (Page* self);
gint page_get_depth (Page* self);
static guint8* _vala_array_dup1 (guint8* self, int length);
static guint8* _vala_array_dup2 (guint8* self, int length);
void pdf_writer_write (PDFWriter* self, guint8* data, int data_length1);
void book_save (Book* self, const gchar* type, gint quality, GFile* file, GError** error);
gboolean book_get_needs_saving (Book* self);
static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void book_finalize (Book* obj);
#define PDF_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PDF_WRITER, PDFWriterPrivate))
enum  {
	PDF_WRITER_DUMMY_PROPERTY
};
static void pdf_writer_finalize (PDFWriter* obj);
enum  {
	PS_WRITER_DUMMY_PROPERTY
};
static cairo_status_t ps_writer_write_cairo_data (PsWriter* self, guint8* data, int data_length1);
static cairo_status_t _ps_writer_write_cairo_data_cairo_write_func_t (gpointer self, guchar* data, int data_length1);
static void ps_writer_finalize (PsWriter* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _page_ref0 (gpointer self) {
#line 32 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return self ? page_ref (self) : NULL;
#line 244 "book.c"
}


static void _book_page_changed_cb_page_pixels_changed (Page* _sender, gpointer self) {
#line 34 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	book_page_changed_cb (self, _sender);
#line 251 "book.c"
}


static void _book_page_changed_cb_page_crop_changed (Page* _sender, gpointer self) {
#line 35 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	book_page_changed_cb (self, _sender);
#line 258 "book.c"
}


static void _page_unref0_ (gpointer var) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	(var == NULL) ? NULL : (var = (page_unref (var), NULL));
#line 265 "book.c"
}


static void _g_list_free__page_unref0_ (GList* self) {
#line 14 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_list_foreach (self, (GFunc) _page_unref0_, NULL);
#line 14 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_list_free (self);
#line 274 "book.c"
}


Book* book_construct (GType object_type) {
	Book* self = NULL;
#line 25 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self = (Book*) g_type_create_instance (object_type);
#line 27 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 27 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv->pages = NULL;
#line 25 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return self;
#line 288 "book.c"
}


Book* book_new (void) {
#line 25 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return book_construct (TYPE_BOOK);
#line 295 "book.c"
}


void book_clear (Book* self) {
	GList* _tmp0_ = NULL;
#line 39 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 41 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 305 "book.c"
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
#line 41 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		page_collection = _tmp0_;
#line 41 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
#line 313 "book.c"
			Page* _tmp1_ = NULL;
			Page* page = NULL;
#line 41 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
#line 41 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			page = _tmp1_;
#line 320 "book.c"
			{
				Page* _tmp2_ = NULL;
				guint _tmp3_ = 0U;
				Page* _tmp4_ = NULL;
				guint _tmp5_ = 0U;
#line 43 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp2_ = page;
#line 43 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 43 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 44 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp4_ = page;
#line 44 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
#line 44 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 41 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_page_unref0 (page);
#line 340 "book.c"
			}
		}
	}
#line 46 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 46 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv->pages = NULL;
#line 47 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_emit_by_name (self, "cleared");
#line 350 "book.c"
}


static void book_page_changed_cb (Book* self, Page* page) {
#line 50 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 50 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (page != NULL);
#line 52 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 361 "book.c"
}


void book_append_page (Book* self, Page* page) {
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
#line 55 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 55 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (page != NULL);
#line 57 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = page;
#line 57 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_connect (_tmp0_, "pixels-changed", (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 58 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = page;
#line 58 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_connect (_tmp1_, "crop-changed", (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 60 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = page;
#line 60 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3_ = _page_ref0 (_tmp2_);
#line 60 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv->pages = g_list_append (self->priv->pages, _tmp3_);
#line 61 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp4_ = page;
#line 61 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_emit_by_name (self, "page-added", _tmp4_);
#line 62 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 395 "book.c"
}


void book_move_page (Book* self, Page* page, guint location) {
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
#line 65 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 65 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (page != NULL);
#line 67 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = page;
#line 67 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv->pages = g_list_remove (self->priv->pages, _tmp0_);
#line 68 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = page;
#line 68 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = _page_ref0 (_tmp1_);
#line 68 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3_ = location;
#line 68 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv->pages = g_list_insert (self->priv->pages, _tmp2_, (gint) _tmp3_);
#line 69 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_emit_by_name (self, "reordered");
#line 70 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 424 "book.c"
}


void book_delete_page (Book* self, Page* page) {
	Page* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	Page* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
#line 73 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 73 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (page != NULL);
#line 75 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = page;
#line 75 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
#line 75 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 76 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = page;
#line 76 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 76 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 77 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp4_ = page;
#line 77 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_emit_by_name (self, "page-removed", _tmp4_);
#line 78 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_ = page;
#line 78 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv->pages = g_list_remove (self->priv->pages, _tmp5_);
#line 79 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 461 "book.c"
}


guint book_get_n_pages (Book* self) {
	guint result = 0U;
	GList* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 82 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 84 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 84 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = g_list_length (_tmp0_);
#line 84 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	result = _tmp1_;
#line 84 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 479 "book.c"
}


Page* book_get_page (Book* self, gint page_number) {
	Page* result = NULL;
	gint _tmp0_ = 0;
	GList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gconstpointer _tmp6_ = NULL;
	Page* _tmp7_ = NULL;
#line 87 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 89 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = page_number;
#line 89 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (_tmp0_ < 0) {
#line 496 "book.c"
		GList* _tmp1_ = NULL;
		guint _tmp2_ = 0U;
		gint _tmp3_ = 0;
#line 90 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp1_ = self->priv->pages;
#line 90 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp2_ = g_list_length (_tmp1_);
#line 90 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp3_ = page_number;
#line 90 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		page_number = ((gint) _tmp2_) + _tmp3_;
#line 508 "book.c"
	}
#line 91 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp4_ = self->priv->pages;
#line 91 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_ = page_number;
#line 91 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp6_ = g_list_nth_data (_tmp4_, (guint) _tmp5_);
#line 91 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp7_ = _page_ref0 ((Page*) _tmp6_);
#line 91 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	result = _tmp7_;
#line 91 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 522 "book.c"
}


guint book_get_page_index (Book* self, Page* page) {
	guint result = 0U;
	GList* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 94 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 94 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (page != NULL, 0U);
#line 96 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 96 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = page;
#line 96 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = g_list_index (_tmp0_, _tmp1_);
#line 96 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	result = (guint) _tmp2_;
#line 96 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 545 "book.c"
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 928 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 929 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 929 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 929 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 929 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 931 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 931 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 570 "book.c"
		gchar* _tmp4_ = NULL;
#line 932 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 932 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 932 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 578 "book.c"
	} else {
#line 934 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = -1;
#line 934 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 584 "book.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_ = 0L;
	gboolean _tmp17_ = FALSE;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
#line 1189 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1190 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1190 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1190 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1191 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1191 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 620 "book.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1192 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1192 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1192 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 629 "book.c"
	}
#line 1194 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1194 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 635 "book.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1195 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1195 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1195 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 644 "book.c"
	}
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 650 "book.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 659 "book.c"
	} else {
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 663 "book.c"
	}
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp12_ = _tmp8_;
#line 1197 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp14_ = end;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp14_ >= ((glong) 0)) {
#line 673 "book.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp15_ = end;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp13_ = _tmp15_ <= _tmp16_;
#line 682 "book.c"
	} else {
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp13_ = FALSE;
#line 686 "book.c"
	}
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp17_ = _tmp13_;
#line 1198 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp17_, NULL);
#line 1199 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1199 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1199 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp21_ = end;
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp22_ = start;
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1200 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 710 "book.c"
}


static GFile* book_make_indexed_file (Book* self, const gchar* uri, gint i) {
	GFile* result = NULL;
	guint _tmp0_ = 0U;
	gchar* basename = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* prefix = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* suffix = NULL;
	gchar* _tmp7_ = NULL;
	gint extension_index = 0;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint width = 0;
	guint _tmp25_ = 0U;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gchar* number_format = NULL;
	gint _tmp31_ = 0;
	gchar* _tmp32_ = NULL;
	gchar* filename = NULL;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	GFile* _tmp46_ = NULL;
#line 99 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 99 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 101 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = book_get_n_pages (self);
#line 101 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (_tmp0_ == ((guint) 1)) {
#line 762 "book.c"
		const gchar* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
#line 102 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp1_ = uri;
#line 102 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp2_ = g_file_new_for_uri (_tmp1_);
#line 102 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		result = _tmp2_;
#line 102 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		return result;
#line 773 "book.c"
	}
#line 105 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3_ = uri;
#line 105 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp4_ = g_path_get_basename (_tmp3_);
#line 105 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	basename = _tmp4_;
#line 106 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_ = uri;
#line 106 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 106 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	prefix = _tmp6_;
#line 106 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp7_ = g_strdup ("");
#line 106 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	suffix = _tmp7_;
#line 107 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp8_ = basename;
#line 107 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp9_ = string_last_index_of_char (_tmp8_, (gunichar) '.', 0);
#line 107 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	extension_index = _tmp9_;
#line 108 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp10_ = extension_index;
#line 108 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (_tmp10_ >= 0) {
#line 801 "book.c"
		const gchar* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		const gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		const gchar* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		gchar* _tmp24_ = NULL;
#line 110 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp11_ = basename;
#line 110 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp12_ = extension_index;
#line 110 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp13_ = basename;
#line 110 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp14_ = strlen (_tmp13_);
#line 110 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp15_ = _tmp14_;
#line 110 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp16_ = string_slice (_tmp11_, (glong) _tmp12_, (glong) _tmp15_);
#line 110 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_g_free0 (suffix);
#line 110 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		suffix = _tmp16_;
#line 111 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp17_ = uri;
#line 111 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp18_ = uri;
#line 111 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp19_ = strlen (_tmp18_);
#line 111 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp20_ = _tmp19_;
#line 111 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp21_ = suffix;
#line 111 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp22_ = strlen (_tmp21_);
#line 111 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp23_ = _tmp22_;
#line 111 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp24_ = string_slice (_tmp17_, (glong) 0, (glong) (_tmp20_ - _tmp23_));
#line 111 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_g_free0 (prefix);
#line 111 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		prefix = _tmp24_;
#line 852 "book.c"
	}
#line 113 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp25_ = book_get_n_pages (self);
#line 113 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp26_ = g_strdup_printf ("%u", _tmp25_);
#line 113 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp27_ = _tmp26_;
#line 113 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp28_ = strlen (_tmp27_);
#line 113 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp29_ = _tmp28_;
#line 113 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp30_ = _tmp29_;
#line 113 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp27_);
#line 113 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	width = _tmp30_;
#line 114 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp31_ = width;
#line 114 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp32_ = g_strdup_printf ("%%0%dd", _tmp31_);
#line 114 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	number_format = _tmp32_;
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp33_ = prefix;
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp34_ = g_strconcat (_tmp33_, "-", NULL);
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp35_ = _tmp34_;
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp36_ = number_format;
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp37_ = i;
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp38_ = g_strdup_printf (_tmp36_, _tmp37_ + 1);
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp39_ = _tmp38_;
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp40_ = g_strconcat (_tmp35_, _tmp39_, NULL);
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp41_ = _tmp40_;
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp42_ = suffix;
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp43_ = g_strconcat (_tmp41_, _tmp42_, NULL);
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp44_ = _tmp43_;
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp41_);
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp39_);
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp35_);
#line 115 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	filename = _tmp44_;
#line 116 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp45_ = filename;
#line 116 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp46_ = g_file_new_for_uri (_tmp45_);
#line 116 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	result = _tmp46_;
#line 116 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (filename);
#line 116 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (number_format);
#line 116 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (suffix);
#line 116 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (prefix);
#line 116 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (basename);
#line 116 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 926 "book.c"
}


static void book_save_multi_file (Book* self, const gchar* type, gint quality, GFile* file, GError** error) {
	GError * _inner_error_ = NULL;
#line 119 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 119 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (type != NULL);
#line 119 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (file != NULL);
#line 938 "book.c"
	{
		gint i = 0;
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		i = 0;
#line 943 "book.c"
		{
			gboolean _tmp0_ = FALSE;
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			_tmp0_ = TRUE;
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			while (TRUE) {
#line 950 "book.c"
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				guint _tmp4_ = 0U;
				Page* page = NULL;
				gint _tmp5_ = 0;
				Page* _tmp6_ = NULL;
				Page* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				GFile* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				GFile* _tmp14_ = NULL;
				GFile* _tmp15_ = NULL;
				gint _tmp16_ = 0;
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp1_ = _tmp0_;
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (!_tmp1_) {
#line 971 "book.c"
					gint _tmp2_ = 0;
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp2_ = i;
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					i = _tmp2_ + 1;
#line 977 "book.c"
				}
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp0_ = FALSE;
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp3_ = i;
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp4_ = book_get_n_pages (self);
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (!(((guint) _tmp3_) < _tmp4_)) {
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					break;
#line 989 "book.c"
				}
#line 123 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp5_ = i;
#line 123 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp6_ = book_get_page (self, _tmp5_);
#line 123 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				page = _tmp6_;
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp7_ = page;
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp8_ = type;
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp9_ = quality;
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp10_ = file;
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp11_ = g_file_get_uri (_tmp10_);
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp12_ = _tmp11_;
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp13_ = i;
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp14_ = book_make_indexed_file (self, _tmp12_, _tmp13_);
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp15_ = _tmp14_;
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				page_save (_tmp7_, _tmp8_, _tmp9_, _tmp15_, &_inner_error_);
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_object_unref0 (_tmp15_);
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp12_);
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (_inner_error_ != NULL) {
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_page_unref0 (page);
#line 124 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					return;
#line 1029 "book.c"
				}
#line 125 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp16_ = i;
#line 125 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				g_signal_emit_by_name (self, "saving", _tmp16_);
#line 121 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_page_unref0 (page);
#line 1037 "book.c"
			}
		}
	}
}


static void book_save_ps_pdf_surface (Book* self, cairo_surface_t* surface, GdkPixbuf* image, gdouble dpi) {
	cairo_t* context = NULL;
	cairo_surface_t* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	GdkPixbuf* _tmp4_ = NULL;
	cairo_pattern_t* _tmp5_ = NULL;
#line 129 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 129 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (surface != NULL);
#line 129 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (image != NULL);
#line 131 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = surface;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = cairo_create (_tmp0_);
#line 131 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	context = _tmp1_;
#line 132 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = dpi;
#line 132 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3_ = dpi;
#line 132 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	cairo_scale (context, 72.0 / _tmp2_, 72.0 / _tmp3_);
#line 133 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp4_ = image;
#line 133 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	gdk_cairo_set_source_pixbuf (context, _tmp4_, (gdouble) 0, (gdouble) 0);
#line 134 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_ = cairo_get_source (context);
#line 134 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	cairo_pattern_set_filter (_tmp5_, CAIRO_FILTER_BEST);
#line 135 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	cairo_paint (context);
#line 129 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_cairo_destroy0 (context);
#line 1082 "book.c"
}


static gpointer _cairo_surface_reference0 (gpointer self) {
#line 142 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return self ? cairo_surface_reference (self) : NULL;
#line 1089 "book.c"
}


static void book_save_ps (Book* self, GFile* file, GError** error) {
	GFileOutputStream* stream = NULL;
	GFile* _tmp0_ = NULL;
	GFileOutputStream* _tmp1_ = NULL;
	PsWriter* writer = NULL;
	PsWriter* _tmp2_ = NULL;
	cairo_surface_t* surface = NULL;
	PsWriter* _tmp3_ = NULL;
	cairo_surface_t* _tmp4_ = NULL;
	cairo_surface_t* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 138 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 138 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (file != NULL);
#line 140 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = file;
#line 140 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = g_file_replace (_tmp0_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 140 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	stream = _tmp1_;
#line 140 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (_inner_error_ != NULL) {
#line 140 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_propagate_error (error, _inner_error_);
#line 140 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		return;
#line 1120 "book.c"
	}
#line 141 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = ps_writer_new (stream);
#line 141 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	writer = _tmp2_;
#line 142 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3_ = writer;
#line 142 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp4_ = _tmp3_->surface;
#line 142 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_ = _cairo_surface_reference0 (_tmp4_);
#line 142 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	surface = _tmp5_;
#line 1134 "book.c"
	{
		gint i = 0;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		i = 0;
#line 1139 "book.c"
		{
			gboolean _tmp6_ = FALSE;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			_tmp6_ = TRUE;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			while (TRUE) {
#line 1146 "book.c"
				gboolean _tmp7_ = FALSE;
				gint _tmp9_ = 0;
				guint _tmp10_ = 0U;
				Page* page = NULL;
				gint _tmp11_ = 0;
				Page* _tmp12_ = NULL;
				GdkPixbuf* image = NULL;
				Page* _tmp13_ = NULL;
				GdkPixbuf* _tmp14_ = NULL;
				gdouble width = 0.0;
				GdkPixbuf* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				Page* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				gdouble height = 0.0;
				GdkPixbuf* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				Page* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				cairo_surface_t* _tmp23_ = NULL;
				gdouble _tmp24_ = 0.0;
				gdouble _tmp25_ = 0.0;
				cairo_surface_t* _tmp26_ = NULL;
				GdkPixbuf* _tmp27_ = NULL;
				Page* _tmp28_ = NULL;
				gint _tmp29_ = 0;
				cairo_surface_t* _tmp30_ = NULL;
				gint _tmp31_ = 0;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp7_ = _tmp6_;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (!_tmp7_) {
#line 1179 "book.c"
					gint _tmp8_ = 0;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp8_ = i;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					i = _tmp8_ + 1;
#line 1185 "book.c"
				}
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp6_ = FALSE;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp9_ = i;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp10_ = book_get_n_pages (self);
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (!(((guint) _tmp9_) < _tmp10_)) {
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					break;
#line 1197 "book.c"
				}
#line 146 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp11_ = i;
#line 146 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp12_ = book_get_page (self, _tmp11_);
#line 146 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				page = _tmp12_;
#line 147 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp13_ = page;
#line 147 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp14_ = page_get_image (_tmp13_, TRUE);
#line 147 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				image = _tmp14_;
#line 148 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp15_ = image;
#line 148 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp16_ = gdk_pixbuf_get_width (_tmp15_);
#line 148 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp17_ = page;
#line 148 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp18_ = page_get_dpi (_tmp17_);
#line 148 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				width = (_tmp16_ * 72.0) / _tmp18_;
#line 149 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp19_ = image;
#line 149 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp20_ = gdk_pixbuf_get_height (_tmp19_);
#line 149 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp21_ = page;
#line 149 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp22_ = page_get_dpi (_tmp21_);
#line 149 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				height = (_tmp20_ * 72.0) / _tmp22_;
#line 150 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp23_ = surface;
#line 150 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp24_ = width;
#line 150 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp25_ = height;
#line 150 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				cairo_ps_surface_set_size (_tmp23_, _tmp24_, _tmp25_);
#line 151 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp26_ = surface;
#line 151 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp27_ = image;
#line 151 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp28_ = page;
#line 151 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp29_ = page_get_dpi (_tmp28_);
#line 151 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				book_save_ps_pdf_surface (self, _tmp26_, _tmp27_, (gdouble) _tmp29_);
#line 152 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp30_ = surface;
#line 152 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				cairo_surface_show_page (_tmp30_);
#line 153 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp31_ = i;
#line 153 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				g_signal_emit_by_name (self, "saving", _tmp31_);
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_object_unref0 (image);
#line 144 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_page_unref0 (page);
#line 1261 "book.c"
			}
		}
	}
#line 138 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_cairo_surface_destroy0 (surface);
#line 138 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_ps_writer_unref0 (writer);
#line 138 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_object_unref0 (stream);
#line 1271 "book.c"
}


static guint8* book_compress_zlib (Book* self, guint8* data, int data_length1, int* result_length1) {
	guint8* result = NULL;
	z_stream stream = {0};
	guint8* out_data = NULL;
	guint8* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	guint8* _tmp1_ = NULL;
	gint out_data_length1 = 0;
	gint _out_data_size_ = 0;
	guint8* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	z_stream _tmp7_ = {0};
	guint _tmp8_ = 0U;
	guint n_written = 0U;
	guint8* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	z_stream _tmp11_ = {0};
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	gint _tmp14_ = 0;
	guint8* _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
#line 157 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 159 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	deflateInit (&stream, (gint) Z_BEST_COMPRESSION);
#line 160 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = data;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0__length1 = data_length1;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = g_new0 (guint8, _tmp0__length1);
#line 160 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	out_data = _tmp1_;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	out_data_length1 = _tmp0__length1;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_out_data_size_ = out_data_length1;
#line 162 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = data;
#line 162 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2__length1 = data_length1;
#line 162 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	stream.next_in = _tmp2_;
#line 162 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	stream.avail_in = _tmp2__length1;
#line 163 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3_ = out_data;
#line 163 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3__length1 = out_data_length1;
#line 163 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	stream.next_out = _tmp3_;
#line 163 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	stream.avail_out = _tmp3__length1;
#line 164 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	while (TRUE) {
#line 1333 "book.c"
		z_stream _tmp4_ = {0};
		guint _tmp5_ = 0U;
		gint _tmp6_ = 0;
#line 164 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp4_ = stream;
#line 164 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp5_ = _tmp4_.avail_in;
#line 164 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		if (!(_tmp5_ > ((guint) 0))) {
#line 164 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			break;
#line 1345 "book.c"
		}
#line 166 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp6_ = deflate (&stream, (gint) Z_FINISH);
#line 166 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		if (_tmp6_ == ((gint) Z_STREAM_ERROR)) {
#line 167 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			break;
#line 1353 "book.c"
		}
	}
#line 170 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp7_ = stream;
#line 170 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp8_ = _tmp7_.avail_in;
#line 170 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (_tmp8_ > ((guint) 0)) {
#line 1362 "book.c"
		guint8* _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
#line 171 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp9_ = NULL;
#line 171 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp9__length1 = 0;
#line 171 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		if (result_length1) {
#line 171 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			*result_length1 = _tmp9__length1;
#line 1373 "book.c"
		}
#line 171 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		result = _tmp9_;
#line 171 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		out_data = (g_free (out_data), NULL);
#line 171 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		deflateEnd (&stream);
#line 171 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		return result;
#line 1383 "book.c"
	}
#line 173 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp10_ = data;
#line 173 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp10__length1 = data_length1;
#line 173 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp11_ = stream;
#line 173 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp12_ = _tmp11_.avail_out;
#line 173 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	n_written = _tmp10__length1 - _tmp12_;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp13_ = n_written;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp14_ = (gint) _tmp13_;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	out_data = g_renew (guint8, out_data, (gint) _tmp13_);
#line 174 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	(_tmp14_ > out_data_length1) ? memset (out_data + out_data_length1, 0, sizeof (guint8) * (_tmp14_ - out_data_length1)) : NULL;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	out_data_length1 = _tmp14_;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_out_data_size_ = _tmp14_;
#line 176 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp15_ = out_data;
#line 176 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp15__length1 = out_data_length1;
#line 176 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (result_length1) {
#line 176 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		*result_length1 = _tmp15__length1;
#line 1415 "book.c"
	}
#line 176 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	result = _tmp15_;
#line 176 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	deflateEnd (&stream);
#line 176 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 1423 "book.c"
}


static gboolean _book_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf, gsize buf_length1, GError** error, gpointer self) {
	gboolean result;
	result = book_write_pixbuf_data (self, buf, buf_length1, error);
#line 188 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 1432 "book.c"
}


static guint8* book_compress_jpeg (Book* self, GdkPixbuf* image, gint quality, gint dpi, int* result_length1) {
	guint8* result = NULL;
	GByteArray* _tmp0_ = NULL;
	gchar** keys = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint keys_length1 = 0;
	gint _keys_size_ = 0;
	gchar** values = NULL;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gint values_length1 = 0;
	gint _values_size_ = 0;
	guint8* data = NULL;
	GByteArray* _tmp15_ = NULL;
	guint8* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	guint8* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	GError * _inner_error_ = NULL;
#line 181 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 181 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (image != NULL, NULL);
#line 183 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = g_byte_array_new ();
#line 183 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_byte_array_unref0 (self->priv->jpeg_data);
#line 183 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv->jpeg_data = _tmp0_;
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = g_strdup ("quality");
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = g_strdup ("density-unit");
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3_ = g_strdup ("x-density");
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp4_ = g_strdup ("y-density");
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_ = g_new0 (gchar*, 5 + 1);
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_[0] = _tmp1_;
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_[1] = _tmp2_;
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_[2] = _tmp3_;
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_[3] = _tmp4_;
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_[4] = NULL;
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	keys = _tmp5_;
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	keys_length1 = 5;
#line 184 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_keys_size_ = keys_length1;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp6_ = quality;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp7_ = g_strdup_printf ("%d", _tmp6_);
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp8_ = g_strdup ("dots-per-inch");
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp9_ = dpi;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp10_ = g_strdup_printf ("%d", _tmp9_);
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp11_ = dpi;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp12_ = g_strdup_printf ("%d", _tmp11_);
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp13_ = g_new0 (gchar*, 5 + 1);
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp13_[0] = _tmp7_;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp13_[1] = _tmp8_;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp13_[2] = _tmp10_;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp13_[3] = _tmp12_;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp13_[4] = NULL;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	values = _tmp13_;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	values_length1 = 5;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_values_size_ = values_length1;
#line 1535 "book.c"
	{
		GdkPixbuf* _tmp14_ = NULL;
#line 188 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp14_ = image;
#line 188 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		gdk_pixbuf_save_to_callbackv (_tmp14_, _book_write_pixbuf_data_gdk_pixbuf_save_func, self, "jpeg", keys, values, &_inner_error_);
#line 188 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		if (_inner_error_ != NULL) {
#line 1544 "book.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
#line 186 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		e = _inner_error_;
#line 186 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_inner_error_ = NULL;
#line 186 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_g_error_free0 (e);
#line 1558 "book.c"
	}
	__finally0:
#line 186 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (_inner_error_ != NULL) {
#line 186 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 186 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 186 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 186 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_clear_error (&_inner_error_);
#line 186 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		return NULL;
#line 1573 "book.c"
	}
#line 193 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp15_ = self->priv->jpeg_data;
#line 193 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp16_ = _tmp15_->data;
#line 193 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp16__length1 = _tmp15_->len;
#line 193 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp15_->data = NULL;
#line 193 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	data = _tmp16_;
#line 193 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	data_length1 = _tmp16__length1;
#line 193 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_data_size_ = data_length1;
#line 194 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_byte_array_unref0 (self->priv->jpeg_data);
#line 194 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv->jpeg_data = NULL;
#line 196 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp17_ = data;
#line 196 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp17__length1 = data_length1;
#line 196 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (result_length1) {
#line 196 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		*result_length1 = _tmp17__length1;
#line 1601 "book.c"
	}
#line 196 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	result = _tmp17_;
#line 196 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 196 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 196 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 1611 "book.c"
}


static gboolean book_write_pixbuf_data (Book* self, guint8* buf, int buf_length1, GError** error) {
	gboolean result = FALSE;
	GByteArray* _tmp0_ = NULL;
	guint8* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 199 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 201 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = self->priv->jpeg_data;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = buf;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1__length1 = buf_length1;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_byte_array_append (_tmp0_, _tmp1_, _tmp1__length1);
#line 202 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	result = TRUE;
#line 202 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 1634 "book.c"
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
#line 407 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 1641 "book.c"
}


static guint8* _vala_array_dup2 (guint8* self, int length) {
#line 414 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 1648 "book.c"
}


static void book_save_pdf (Book* self, GFile* file, gint quality, GError** error) {
	gchar* id = NULL;
	gchar* _tmp0_ = NULL;
	GFileOutputStream* stream = NULL;
	GFile* _tmp10_ = NULL;
	GFileOutputStream* _tmp11_ = NULL;
	PDFWriter* writer = NULL;
	PDFWriter* _tmp12_ = NULL;
	PDFWriter* _tmp13_ = NULL;
	PDFWriter* _tmp14_ = NULL;
	guint catalog_number = 0U;
	PDFWriter* _tmp15_ = NULL;
	guint _tmp16_ = 0U;
	PDFWriter* _tmp17_ = NULL;
	guint _tmp18_ = 0U;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	PDFWriter* _tmp21_ = NULL;
	PDFWriter* _tmp22_ = NULL;
	PDFWriter* _tmp23_ = NULL;
	guint _tmp24_ = 0U;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	PDFWriter* _tmp27_ = NULL;
	PDFWriter* _tmp28_ = NULL;
	PDFWriter* _tmp29_ = NULL;
	guint pages_number = 0U;
	PDFWriter* _tmp30_ = NULL;
	guint _tmp31_ = 0U;
	PDFWriter* _tmp32_ = NULL;
	guint _tmp33_ = 0U;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	PDFWriter* _tmp36_ = NULL;
	PDFWriter* _tmp37_ = NULL;
	PDFWriter* _tmp38_ = NULL;
	PDFWriter* _tmp49_ = NULL;
	PDFWriter* _tmp50_ = NULL;
	guint _tmp51_ = 0U;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	PDFWriter* _tmp54_ = NULL;
	PDFWriter* _tmp55_ = NULL;
	PDFWriter* _tmp362_ = NULL;
	guint info_number = 0U;
	PDFWriter* _tmp363_ = NULL;
	guint _tmp364_ = 0U;
	PDFWriter* _tmp365_ = NULL;
	guint _tmp366_ = 0U;
	gchar* _tmp367_ = NULL;
	gchar* _tmp368_ = NULL;
	PDFWriter* _tmp369_ = NULL;
	PDFWriter* _tmp370_ = NULL;
	gchar* _tmp371_ = NULL;
	gchar* _tmp372_ = NULL;
	PDFWriter* _tmp373_ = NULL;
	PDFWriter* _tmp374_ = NULL;
	PDFWriter* _tmp375_ = NULL;
	gsize xref_offset = 0UL;
	PDFWriter* _tmp376_ = NULL;
	gsize _tmp377_ = 0UL;
	PDFWriter* _tmp378_ = NULL;
	PDFWriter* _tmp379_ = NULL;
	PDFWriter* _tmp380_ = NULL;
	GList* _tmp381_ = NULL;
	guint _tmp382_ = 0U;
	gchar* _tmp383_ = NULL;
	gchar* _tmp384_ = NULL;
	PDFWriter* _tmp385_ = NULL;
	PDFWriter* _tmp386_ = NULL;
	GList* _tmp387_ = NULL;
	PDFWriter* _tmp392_ = NULL;
	PDFWriter* _tmp393_ = NULL;
	PDFWriter* _tmp394_ = NULL;
	PDFWriter* _tmp395_ = NULL;
	PDFWriter* _tmp396_ = NULL;
	GList* _tmp397_ = NULL;
	guint _tmp398_ = 0U;
	gchar* _tmp399_ = NULL;
	gchar* _tmp400_ = NULL;
	PDFWriter* _tmp401_ = NULL;
	guint _tmp402_ = 0U;
	gchar* _tmp403_ = NULL;
	gchar* _tmp404_ = NULL;
	PDFWriter* _tmp405_ = NULL;
	guint _tmp406_ = 0U;
	gchar* _tmp407_ = NULL;
	gchar* _tmp408_ = NULL;
	PDFWriter* _tmp409_ = NULL;
	const gchar* _tmp410_ = NULL;
	const gchar* _tmp411_ = NULL;
	gchar* _tmp412_ = NULL;
	gchar* _tmp413_ = NULL;
	PDFWriter* _tmp414_ = NULL;
	PDFWriter* _tmp415_ = NULL;
	PDFWriter* _tmp416_ = NULL;
	gsize _tmp417_ = 0UL;
	gchar* _tmp418_ = NULL;
	gchar* _tmp419_ = NULL;
	PDFWriter* _tmp420_ = NULL;
	GError * _inner_error_ = NULL;
#line 205 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 205 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (file != NULL);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = g_strdup ("");
#line 208 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	id = _tmp0_;
#line 1761 "book.c"
	{
		gint i = 0;
#line 209 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		i = 0;
#line 1766 "book.c"
		{
			gboolean _tmp1_ = FALSE;
#line 209 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			_tmp1_ = TRUE;
#line 209 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			while (TRUE) {
#line 1773 "book.c"
				gboolean _tmp2_ = FALSE;
				gint _tmp4_ = 0;
				const gchar* _tmp5_ = NULL;
				guint32 _tmp6_ = 0U;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
#line 209 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp2_ = _tmp1_;
#line 209 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (!_tmp2_) {
#line 1785 "book.c"
					gint _tmp3_ = 0;
#line 209 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp3_ = i;
#line 209 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					i = _tmp3_ + 1;
#line 1791 "book.c"
				}
#line 209 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp1_ = FALSE;
#line 209 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp4_ = i;
#line 209 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (!(_tmp4_ < 4)) {
#line 209 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					break;
#line 1801 "book.c"
				}
#line 210 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp5_ = id;
#line 210 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp6_ = g_random_int ();
#line 210 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp7_ = g_strdup_printf ("%08x", (guint) _tmp6_);
#line 210 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp8_ = _tmp7_;
#line 210 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp9_ = g_strconcat (_tmp5_, _tmp8_, NULL);
#line 210 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (id);
#line 210 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				id = _tmp9_;
#line 210 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp8_);
#line 1819 "book.c"
			}
		}
	}
#line 212 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp10_ = file;
#line 212 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp11_ = g_file_replace (_tmp10_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 212 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	stream = _tmp11_;
#line 212 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (_inner_error_ != NULL) {
#line 212 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_propagate_error (error, _inner_error_);
#line 212 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_g_free0 (id);
#line 212 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		return;
#line 1837 "book.c"
	}
#line 213 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp12_ = pdf_writer_new (stream);
#line 213 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	writer = _tmp12_;
#line 216 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp13_ = writer;
#line 216 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp13_, "%PDF-1.3\n");
#line 219 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp14_ = writer;
#line 219 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp14_, "%\xe2\xe3\xcf\xd3\n");
#line 222 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp15_ = writer;
#line 222 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp16_ = pdf_writer_start_object (_tmp15_);
#line 222 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	catalog_number = _tmp16_;
#line 223 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp17_ = writer;
#line 223 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp18_ = catalog_number;
#line 223 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp19_ = g_strdup_printf ("%u 0 obj\n", _tmp18_);
#line 223 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp20_ = _tmp19_;
#line 223 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp17_, _tmp20_);
#line 223 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp20_);
#line 224 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp21_ = writer;
#line 224 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp21_, "<<\n");
#line 225 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp22_ = writer;
#line 225 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp22_, "/Type /Catalog\n");
#line 228 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp23_ = writer;
#line 228 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp24_ = catalog_number;
#line 228 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp25_ = g_strdup_printf ("/Pages %u 0 R\n", _tmp24_ + 1);
#line 228 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp26_ = _tmp25_;
#line 228 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp23_, _tmp26_);
#line 228 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp26_);
#line 229 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp27_ = writer;
#line 229 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp27_, ">>\n");
#line 230 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp28_ = writer;
#line 230 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp28_, "endobj\n");
#line 248 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp29_ = writer;
#line 248 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp29_, "\n");
#line 249 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp30_ = writer;
#line 249 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp31_ = pdf_writer_start_object (_tmp30_);
#line 249 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pages_number = _tmp31_;
#line 250 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp32_ = writer;
#line 250 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp33_ = pages_number;
#line 250 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp34_ = g_strdup_printf ("%u 0 obj\n", _tmp33_);
#line 250 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp35_ = _tmp34_;
#line 250 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp32_, _tmp35_);
#line 250 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp35_);
#line 251 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp36_ = writer;
#line 251 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp36_, "<<\n");
#line 252 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp37_ = writer;
#line 252 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp37_, "/Type /Pages\n");
#line 253 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp38_ = writer;
#line 253 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp38_, "/Kids [");
#line 1931 "book.c"
	{
		gint i = 0;
#line 254 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		i = 0;
#line 1936 "book.c"
		{
			gboolean _tmp39_ = FALSE;
#line 254 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			_tmp39_ = TRUE;
#line 254 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			while (TRUE) {
#line 1943 "book.c"
				gboolean _tmp40_ = FALSE;
				gint _tmp42_ = 0;
				guint _tmp43_ = 0U;
				PDFWriter* _tmp44_ = NULL;
				guint _tmp45_ = 0U;
				gint _tmp46_ = 0;
				gchar* _tmp47_ = NULL;
				gchar* _tmp48_ = NULL;
#line 254 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp40_ = _tmp39_;
#line 254 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (!_tmp40_) {
#line 1956 "book.c"
					gint _tmp41_ = 0;
#line 254 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp41_ = i;
#line 254 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					i = _tmp41_ + 1;
#line 1962 "book.c"
				}
#line 254 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp39_ = FALSE;
#line 254 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp42_ = i;
#line 254 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp43_ = book_get_n_pages (self);
#line 254 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (!(((guint) _tmp42_) < _tmp43_)) {
#line 254 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					break;
#line 1974 "book.c"
				}
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp44_ = writer;
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp45_ = pages_number;
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp46_ = i;
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp47_ = g_strdup_printf (" %u 0 R", (_tmp45_ + 1) + (_tmp46_ * 3));
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp48_ = _tmp47_;
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp44_, _tmp48_);
#line 255 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp48_);
#line 1990 "book.c"
			}
		}
	}
#line 256 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp49_ = writer;
#line 256 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp49_, " ]\n");
#line 257 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp50_ = writer;
#line 257 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp51_ = book_get_n_pages (self);
#line 257 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp52_ = g_strdup_printf ("/Count %u\n", _tmp51_);
#line 257 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp53_ = _tmp52_;
#line 257 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp50_, _tmp53_);
#line 257 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp53_);
#line 258 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp54_ = writer;
#line 258 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp54_, ">>\n");
#line 259 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp55_ = writer;
#line 259 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp55_, "endobj\n");
#line 2018 "book.c"
	{
		gint i = 0;
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		i = 0;
#line 2023 "book.c"
		{
			gboolean _tmp56_ = FALSE;
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			_tmp56_ = TRUE;
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			while (TRUE) {
#line 2030 "book.c"
				gboolean _tmp57_ = FALSE;
				gint _tmp59_ = 0;
				guint _tmp60_ = 0U;
				Page* page = NULL;
				gint _tmp61_ = 0;
				Page* _tmp62_ = NULL;
				GdkPixbuf* image = NULL;
				Page* _tmp63_ = NULL;
				GdkPixbuf* _tmp64_ = NULL;
				gint width = 0;
				GdkPixbuf* _tmp65_ = NULL;
				gint _tmp66_ = 0;
				gint height = 0;
				GdkPixbuf* _tmp67_ = NULL;
				gint _tmp68_ = 0;
				guint8* pixels = NULL;
				GdkPixbuf* _tmp69_ = NULL;
				guint8* _tmp70_ = NULL;
				gint pixels_length1 = 0;
				gint _pixels_size_ = 0;
				gdouble page_width = 0.0;
				gint _tmp71_ = 0;
				Page* _tmp72_ = NULL;
				gint _tmp73_ = 0;
				gdouble page_height = 0.0;
				gint _tmp74_ = 0;
				Page* _tmp75_ = NULL;
				gint _tmp76_ = 0;
				gint depth = 0;
				gchar* color_space = NULL;
				gchar* _tmp77_ = NULL;
				gchar* filter = NULL;
				gchar* width_buffer = NULL;
				gchar* _tmp78_ = NULL;
				gint width_buffer_length1 = 0;
				gint _width_buffer_size_ = 0;
				gchar* height_buffer = NULL;
				gchar* _tmp79_ = NULL;
				gint height_buffer_length1 = 0;
				gint _height_buffer_size_ = 0;
				guint8* data = NULL;
				gint data_length1 = 0;
				gint _data_size_ = 0;
				Page* _tmp80_ = NULL;
				gboolean _tmp81_ = FALSE;
				guint8* compressed_data = NULL;
				guint8* _tmp237_ = NULL;
				gint _tmp237__length1 = 0;
				gint _tmp238_ = 0;
				guint8* _tmp239_ = NULL;
				gint compressed_data_length1 = 0;
				gint _compressed_data_size_ = 0;
				guint8* _tmp240_ = NULL;
				gint _tmp240__length1 = 0;
				PDFWriter* _tmp257_ = NULL;
				guint number = 0U;
				PDFWriter* _tmp258_ = NULL;
				guint _tmp259_ = 0U;
				PDFWriter* _tmp260_ = NULL;
				guint _tmp261_ = 0U;
				gchar* _tmp262_ = NULL;
				gchar* _tmp263_ = NULL;
				PDFWriter* _tmp264_ = NULL;
				PDFWriter* _tmp265_ = NULL;
				PDFWriter* _tmp266_ = NULL;
				guint _tmp267_ = 0U;
				gchar* _tmp268_ = NULL;
				gchar* _tmp269_ = NULL;
				PDFWriter* _tmp270_ = NULL;
				gint _tmp271_ = 0;
				guint _tmp272_ = 0U;
				gchar* _tmp273_ = NULL;
				gchar* _tmp274_ = NULL;
				PDFWriter* _tmp275_ = NULL;
				gdouble _tmp276_ = 0.0;
				gchar* _tmp277_ = NULL;
				gint _tmp277__length1 = 0;
				const gchar* _tmp278_ = NULL;
				gdouble _tmp279_ = 0.0;
				gchar* _tmp280_ = NULL;
				gint _tmp280__length1 = 0;
				const gchar* _tmp281_ = NULL;
				gchar* _tmp282_ = NULL;
				gchar* _tmp283_ = NULL;
				PDFWriter* _tmp284_ = NULL;
				guint _tmp285_ = 0U;
				gchar* _tmp286_ = NULL;
				gchar* _tmp287_ = NULL;
				PDFWriter* _tmp288_ = NULL;
				PDFWriter* _tmp289_ = NULL;
				PDFWriter* _tmp290_ = NULL;
				PDFWriter* _tmp291_ = NULL;
				guint _tmp292_ = 0U;
				PDFWriter* _tmp293_ = NULL;
				guint _tmp294_ = 0U;
				gchar* _tmp295_ = NULL;
				gchar* _tmp296_ = NULL;
				PDFWriter* _tmp297_ = NULL;
				PDFWriter* _tmp298_ = NULL;
				PDFWriter* _tmp299_ = NULL;
				PDFWriter* _tmp300_ = NULL;
				gint _tmp301_ = 0;
				gchar* _tmp302_ = NULL;
				gchar* _tmp303_ = NULL;
				PDFWriter* _tmp304_ = NULL;
				gint _tmp305_ = 0;
				gchar* _tmp306_ = NULL;
				gchar* _tmp307_ = NULL;
				PDFWriter* _tmp308_ = NULL;
				const gchar* _tmp309_ = NULL;
				gchar* _tmp310_ = NULL;
				gchar* _tmp311_ = NULL;
				PDFWriter* _tmp312_ = NULL;
				gint _tmp313_ = 0;
				gchar* _tmp314_ = NULL;
				gchar* _tmp315_ = NULL;
				PDFWriter* _tmp316_ = NULL;
				guint8* _tmp317_ = NULL;
				gint _tmp317__length1 = 0;
				gchar* _tmp318_ = NULL;
				gchar* _tmp319_ = NULL;
				const gchar* _tmp320_ = NULL;
				PDFWriter* _tmp325_ = NULL;
				PDFWriter* _tmp326_ = NULL;
				PDFWriter* _tmp327_ = NULL;
				guint8* _tmp328_ = NULL;
				gint _tmp328__length1 = 0;
				PDFWriter* _tmp329_ = NULL;
				PDFWriter* _tmp330_ = NULL;
				PDFWriter* _tmp331_ = NULL;
				gchar* command = NULL;
				gdouble _tmp332_ = 0.0;
				gchar* _tmp333_ = NULL;
				gint _tmp333__length1 = 0;
				const gchar* _tmp334_ = NULL;
				gdouble _tmp335_ = 0.0;
				gchar* _tmp336_ = NULL;
				gint _tmp336__length1 = 0;
				const gchar* _tmp337_ = NULL;
				gint _tmp338_ = 0;
				gchar* _tmp339_ = NULL;
				PDFWriter* _tmp340_ = NULL;
				PDFWriter* _tmp341_ = NULL;
				guint _tmp342_ = 0U;
				PDFWriter* _tmp343_ = NULL;
				guint _tmp344_ = 0U;
				gchar* _tmp345_ = NULL;
				gchar* _tmp346_ = NULL;
				PDFWriter* _tmp347_ = NULL;
				PDFWriter* _tmp348_ = NULL;
				const gchar* _tmp349_ = NULL;
				gint _tmp350_ = 0;
				gint _tmp351_ = 0;
				gchar* _tmp352_ = NULL;
				gchar* _tmp353_ = NULL;
				PDFWriter* _tmp354_ = NULL;
				PDFWriter* _tmp355_ = NULL;
				PDFWriter* _tmp356_ = NULL;
				const gchar* _tmp357_ = NULL;
				PDFWriter* _tmp358_ = NULL;
				PDFWriter* _tmp359_ = NULL;
				PDFWriter* _tmp360_ = NULL;
				gint _tmp361_ = 0;
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp57_ = _tmp56_;
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (!_tmp57_) {
#line 2198 "book.c"
					gint _tmp58_ = 0;
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp58_ = i;
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					i = _tmp58_ + 1;
#line 2204 "book.c"
				}
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp56_ = FALSE;
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp59_ = i;
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp60_ = book_get_n_pages (self);
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (!(((guint) _tmp59_) < _tmp60_)) {
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					break;
#line 2216 "book.c"
				}
#line 263 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp61_ = i;
#line 263 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp62_ = book_get_page (self, _tmp61_);
#line 263 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				page = _tmp62_;
#line 264 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp63_ = page;
#line 264 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp64_ = page_get_image (_tmp63_, TRUE);
#line 264 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				image = _tmp64_;
#line 265 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp65_ = image;
#line 265 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp66_ = gdk_pixbuf_get_width (_tmp65_);
#line 265 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				width = _tmp66_;
#line 266 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp67_ = image;
#line 266 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp68_ = gdk_pixbuf_get_height (_tmp67_);
#line 266 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				height = _tmp68_;
#line 267 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp69_ = image;
#line 267 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp70_ = gdk_pixbuf_get_pixels (_tmp69_);
#line 267 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pixels = _tmp70_;
#line 267 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pixels_length1 = -1;
#line 267 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_pixels_size_ = pixels_length1;
#line 268 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp71_ = width;
#line 268 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp72_ = page;
#line 268 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp73_ = page_get_dpi (_tmp72_);
#line 268 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				page_width = (_tmp71_ * 72.0) / _tmp73_;
#line 269 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp74_ = height;
#line 269 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp75_ = page;
#line 269 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp76_ = page_get_dpi (_tmp75_);
#line 269 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				page_height = (_tmp74_ * 72.0) / _tmp76_;
#line 271 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				depth = 8;
#line 272 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp77_ = g_strdup ("DeviceRGB");
#line 272 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				color_space = _tmp77_;
#line 273 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				filter = NULL;
#line 274 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp78_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 274 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				width_buffer = _tmp78_;
#line 274 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				width_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 274 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_width_buffer_size_ = width_buffer_length1;
#line 275 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp79_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 275 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				height_buffer = _tmp79_;
#line 275 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				height_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 275 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_height_buffer_size_ = height_buffer_length1;
#line 277 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp80_ = page;
#line 277 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp81_ = page_is_color (_tmp80_);
#line 277 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (_tmp81_) {
#line 2298 "book.c"
					gchar* _tmp82_ = NULL;
					gint data_length = 0;
					gint _tmp83_ = 0;
					gint _tmp84_ = 0;
					gint _tmp85_ = 0;
					guint8* _tmp86_ = NULL;
#line 279 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					depth = 8;
#line 280 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp82_ = g_strdup ("DeviceRGB");
#line 280 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_g_free0 (color_space);
#line 280 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					color_space = _tmp82_;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp83_ = height;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp84_ = width;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					data_length = (_tmp83_ * _tmp84_) * 3;
#line 282 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp85_ = data_length;
#line 282 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp86_ = g_new0 (guint8, _tmp85_);
#line 282 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					data = (g_free (data), NULL);
#line 282 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					data = _tmp86_;
#line 282 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					data_length1 = _tmp85_;
#line 282 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_data_size_ = data_length1;
#line 2331 "book.c"
					{
						gint row = 0;
#line 283 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						row = 0;
#line 2336 "book.c"
						{
							gboolean _tmp87_ = FALSE;
#line 283 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp87_ = TRUE;
#line 283 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							while (TRUE) {
#line 2343 "book.c"
								gboolean _tmp88_ = FALSE;
								gint _tmp90_ = 0;
								gint _tmp91_ = 0;
								gint in_offset = 0;
								gint _tmp92_ = 0;
								GdkPixbuf* _tmp93_ = NULL;
								gint _tmp94_ = 0;
								gint out_offset = 0;
								gint _tmp95_ = 0;
								gint _tmp96_ = 0;
#line 283 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								_tmp88_ = _tmp87_;
#line 283 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								if (!_tmp88_) {
#line 2358 "book.c"
									gint _tmp89_ = 0;
#line 283 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									_tmp89_ = row;
#line 283 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									row = _tmp89_ + 1;
#line 2364 "book.c"
								}
#line 283 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								_tmp87_ = FALSE;
#line 283 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								_tmp90_ = row;
#line 283 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								_tmp91_ = height;
#line 283 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								if (!(_tmp90_ < _tmp91_)) {
#line 283 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									break;
#line 2376 "book.c"
								}
#line 285 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								_tmp92_ = row;
#line 285 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								_tmp93_ = image;
#line 285 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								_tmp94_ = gdk_pixbuf_get_rowstride (_tmp93_);
#line 285 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								in_offset = _tmp92_ * _tmp94_;
#line 286 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								_tmp95_ = row;
#line 286 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								_tmp96_ = width;
#line 286 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								out_offset = (_tmp95_ * _tmp96_) * 3;
#line 2392 "book.c"
								{
									gint x = 0;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									x = 0;
#line 2397 "book.c"
									{
										gboolean _tmp97_ = FALSE;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp97_ = TRUE;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										while (TRUE) {
#line 2404 "book.c"
											gboolean _tmp98_ = FALSE;
											gint _tmp100_ = 0;
											gint _tmp101_ = 0;
											gint in_o = 0;
											gint _tmp102_ = 0;
											gint _tmp103_ = 0;
											gint out_o = 0;
											gint _tmp104_ = 0;
											gint _tmp105_ = 0;
											guint8* _tmp106_ = NULL;
											gint _tmp106__length1 = 0;
											gint _tmp107_ = 0;
											guint8* _tmp108_ = NULL;
											gint _tmp108__length1 = 0;
											gint _tmp109_ = 0;
											guint8 _tmp110_ = 0U;
											guint8 _tmp111_ = 0U;
											guint8* _tmp112_ = NULL;
											gint _tmp112__length1 = 0;
											gint _tmp113_ = 0;
											guint8* _tmp114_ = NULL;
											gint _tmp114__length1 = 0;
											gint _tmp115_ = 0;
											guint8 _tmp116_ = 0U;
											guint8 _tmp117_ = 0U;
											guint8* _tmp118_ = NULL;
											gint _tmp118__length1 = 0;
											gint _tmp119_ = 0;
											guint8* _tmp120_ = NULL;
											gint _tmp120__length1 = 0;
											gint _tmp121_ = 0;
											guint8 _tmp122_ = 0U;
											guint8 _tmp123_ = 0U;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp98_ = _tmp97_;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											if (!_tmp98_) {
#line 2442 "book.c"
												gint _tmp99_ = 0;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp99_ = x;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												x = _tmp99_ + 1;
#line 2448 "book.c"
											}
#line 287 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp97_ = FALSE;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp100_ = x;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp101_ = width;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											if (!(_tmp100_ < _tmp101_)) {
#line 287 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												break;
#line 2460 "book.c"
											}
#line 289 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp102_ = in_offset;
#line 289 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp103_ = x;
#line 289 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											in_o = _tmp102_ + (_tmp103_ * 3);
#line 290 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp104_ = out_offset;
#line 290 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp105_ = x;
#line 290 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											out_o = _tmp104_ + (_tmp105_ * 3);
#line 292 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp106_ = data;
#line 292 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp106__length1 = data_length1;
#line 292 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp107_ = out_o;
#line 292 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp108_ = pixels;
#line 292 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp108__length1 = pixels_length1;
#line 292 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp109_ = in_o;
#line 292 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp110_ = _tmp108_[_tmp109_];
#line 292 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp106_[_tmp107_] = _tmp110_;
#line 292 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp111_ = _tmp106_[_tmp107_];
#line 293 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp112_ = data;
#line 293 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp112__length1 = data_length1;
#line 293 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp113_ = out_o;
#line 293 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp114_ = pixels;
#line 293 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp114__length1 = pixels_length1;
#line 293 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp115_ = in_o;
#line 293 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp116_ = _tmp114_[_tmp115_ + 1];
#line 293 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp112_[_tmp113_ + 1] = _tmp116_;
#line 293 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp117_ = _tmp112_[_tmp113_ + 1];
#line 294 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp118_ = data;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp118__length1 = data_length1;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp119_ = out_o;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp120_ = pixels;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp120__length1 = pixels_length1;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp121_ = in_o;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp122_ = _tmp120_[_tmp121_ + 2];
#line 294 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp118_[_tmp119_ + 2] = _tmp122_;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp123_ = _tmp118_[_tmp119_ + 2];
#line 2528 "book.c"
										}
									}
								}
							}
						}
					}
				} else {
					Page* _tmp124_ = NULL;
					gint _tmp125_ = 0;
#line 298 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp124_ = page;
#line 298 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp125_ = page_get_depth (_tmp124_);
#line 298 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					if (_tmp125_ == 2) {
#line 2544 "book.c"
						gint shift_count = 0;
						gchar* _tmp126_ = NULL;
						gint data_length = 0;
						gint _tmp127_ = 0;
						gint _tmp128_ = 0;
						gint _tmp129_ = 0;
						guint8* _tmp130_ = NULL;
						gint offset = 0;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						shift_count = 6;
#line 301 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						depth = 2;
#line 302 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp126_ = g_strdup ("DeviceGray");
#line 302 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_g_free0 (color_space);
#line 302 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						color_space = _tmp126_;
#line 303 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp127_ = height;
#line 303 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp128_ = width;
#line 303 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						data_length = _tmp127_ * (((_tmp128_ * 2) + 7) / 8);
#line 304 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp129_ = data_length;
#line 304 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp130_ = g_new0 (guint8, _tmp129_);
#line 304 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						data = (g_free (data), NULL);
#line 304 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						data = _tmp130_;
#line 304 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						data_length1 = _tmp129_;
#line 304 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_data_size_ = data_length1;
#line 305 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						offset = 0;
#line 2583 "book.c"
						{
							gint row = 0;
#line 306 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							row = 0;
#line 2588 "book.c"
							{
								gboolean _tmp131_ = FALSE;
#line 306 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								_tmp131_ = TRUE;
#line 306 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								while (TRUE) {
#line 2595 "book.c"
									gboolean _tmp132_ = FALSE;
									gint _tmp134_ = 0;
									gint _tmp135_ = 0;
									gint _tmp136_ = 0;
									gint in_offset = 0;
									gint _tmp138_ = 0;
									GdkPixbuf* _tmp139_ = NULL;
									gint _tmp140_ = 0;
#line 306 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									_tmp132_ = _tmp131_;
#line 306 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									if (!_tmp132_) {
#line 2608 "book.c"
										gint _tmp133_ = 0;
#line 306 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp133_ = row;
#line 306 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										row = _tmp133_ + 1;
#line 2614 "book.c"
									}
#line 306 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									_tmp131_ = FALSE;
#line 306 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									_tmp134_ = row;
#line 306 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									_tmp135_ = height;
#line 306 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									if (!(_tmp134_ < _tmp135_)) {
#line 306 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										break;
#line 2626 "book.c"
									}
#line 309 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									_tmp136_ = shift_count;
#line 309 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									if (_tmp136_ != 6) {
#line 2632 "book.c"
										gint _tmp137_ = 0;
#line 311 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp137_ = offset;
#line 311 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										offset = _tmp137_ + 1;
#line 312 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										shift_count = 6;
#line 2640 "book.c"
									}
#line 315 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									_tmp138_ = row;
#line 315 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									_tmp139_ = image;
#line 315 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									_tmp140_ = gdk_pixbuf_get_rowstride (_tmp139_);
#line 315 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									in_offset = _tmp138_ * _tmp140_;
#line 2650 "book.c"
									{
										gint x = 0;
#line 316 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										x = 0;
#line 2655 "book.c"
										{
											gboolean _tmp141_ = FALSE;
#line 316 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp141_ = TRUE;
#line 316 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											while (TRUE) {
#line 2662 "book.c"
												gboolean _tmp142_ = FALSE;
												gint _tmp144_ = 0;
												gint _tmp145_ = 0;
												gint _tmp146_ = 0;
												guint8 p = 0U;
												guint8* _tmp150_ = NULL;
												gint _tmp150__length1 = 0;
												gint _tmp151_ = 0;
												gint _tmp152_ = 0;
												guint8 _tmp153_ = 0U;
												guint8 _tmp154_ = 0U;
												gint _tmp169_ = 0;
#line 316 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp142_ = _tmp141_;
#line 316 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												if (!_tmp142_) {
#line 2679 "book.c"
													gint _tmp143_ = 0;
#line 316 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp143_ = x;
#line 316 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													x = _tmp143_ + 1;
#line 2685 "book.c"
												}
#line 316 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp141_ = FALSE;
#line 316 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp144_ = x;
#line 316 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp145_ = width;
#line 316 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												if (!(_tmp144_ < _tmp145_)) {
#line 316 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													break;
#line 2697 "book.c"
												}
#line 319 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp146_ = shift_count;
#line 319 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												if (_tmp146_ == 6) {
#line 2703 "book.c"
													guint8* _tmp147_ = NULL;
													gint _tmp147__length1 = 0;
													gint _tmp148_ = 0;
													guint8 _tmp149_ = 0U;
#line 320 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp147_ = data;
#line 320 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp147__length1 = data_length1;
#line 320 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp148_ = offset;
#line 320 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp147_[_tmp148_] = (guint8) 0;
#line 320 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp149_ = _tmp147_[_tmp148_];
#line 2718 "book.c"
												}
#line 323 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp150_ = pixels;
#line 323 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp150__length1 = pixels_length1;
#line 323 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp151_ = in_offset;
#line 323 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp152_ = x;
#line 323 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp153_ = _tmp150_[_tmp151_ + (_tmp152_ * 3)];
#line 323 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												p = _tmp153_;
#line 324 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp154_ = p;
#line 324 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												if (((gint) _tmp154_) >= 192) {
#line 2736 "book.c"
													guint8* _tmp155_ = NULL;
													gint _tmp155__length1 = 0;
													gint _tmp156_ = 0;
													gint _tmp157_ = 0;
													guint8 _tmp158_ = 0U;
#line 325 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp155_ = data;
#line 325 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp155__length1 = data_length1;
#line 325 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp156_ = offset;
#line 325 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp157_ = shift_count;
#line 325 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp155_[_tmp156_] |= (guint8) (3 << _tmp157_);
#line 325 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp158_ = _tmp155_[_tmp156_];
#line 2754 "book.c"
												} else {
													guint8 _tmp159_ = 0U;
#line 326 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp159_ = p;
#line 326 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													if (((gint) _tmp159_) >= 128) {
#line 2761 "book.c"
														guint8* _tmp160_ = NULL;
														gint _tmp160__length1 = 0;
														gint _tmp161_ = 0;
														gint _tmp162_ = 0;
														guint8 _tmp163_ = 0U;
#line 327 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp160_ = data;
#line 327 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp160__length1 = data_length1;
#line 327 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp161_ = offset;
#line 327 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp162_ = shift_count;
#line 327 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp160_[_tmp161_] |= (guint8) (2 << _tmp162_);
#line 327 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp163_ = _tmp160_[_tmp161_];
#line 2779 "book.c"
													} else {
														guint8 _tmp164_ = 0U;
#line 328 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp164_ = p;
#line 328 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														if (((gint) _tmp164_) >= 64) {
#line 2786 "book.c"
															guint8* _tmp165_ = NULL;
															gint _tmp165__length1 = 0;
															gint _tmp166_ = 0;
															gint _tmp167_ = 0;
															guint8 _tmp168_ = 0U;
#line 329 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
															_tmp165_ = data;
#line 329 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
															_tmp165__length1 = data_length1;
#line 329 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
															_tmp166_ = offset;
#line 329 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
															_tmp167_ = shift_count;
#line 329 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
															_tmp165_[_tmp166_] |= (guint8) (1 << _tmp167_);
#line 329 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
															_tmp168_ = _tmp165_[_tmp166_];
#line 2804 "book.c"
														}
													}
												}
#line 332 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp169_ = shift_count;
#line 332 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												if (_tmp169_ == 0) {
#line 2812 "book.c"
													gint _tmp170_ = 0;
#line 334 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp170_ = offset;
#line 334 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													offset = _tmp170_ + 1;
#line 335 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													shift_count = 6;
#line 2820 "book.c"
												} else {
													gint _tmp171_ = 0;
#line 338 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp171_ = shift_count;
#line 338 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													shift_count = _tmp171_ - 2;
#line 2827 "book.c"
												}
											}
										}
									}
								}
							}
						}
					} else {
						Page* _tmp172_ = NULL;
						gint _tmp173_ = 0;
#line 342 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp172_ = page;
#line 342 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp173_ = page_get_depth (_tmp172_);
#line 342 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						if (_tmp173_ == 1) {
#line 2844 "book.c"
							gint mask = 0;
							gchar* _tmp174_ = NULL;
							gint data_length = 0;
							gint _tmp175_ = 0;
							gint _tmp176_ = 0;
							gint _tmp177_ = 0;
							guint8* _tmp178_ = NULL;
							gint offset = 0;
#line 344 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							mask = 0x80;
#line 346 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							depth = 1;
#line 347 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp174_ = g_strdup ("DeviceGray");
#line 347 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_g_free0 (color_space);
#line 347 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							color_space = _tmp174_;
#line 348 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp175_ = height;
#line 348 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp176_ = width;
#line 348 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							data_length = _tmp175_ * ((_tmp176_ + 7) / 8);
#line 349 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp177_ = data_length;
#line 349 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp178_ = g_new0 (guint8, _tmp177_);
#line 349 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							data = (g_free (data), NULL);
#line 349 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							data = _tmp178_;
#line 349 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							data_length1 = _tmp177_;
#line 349 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_data_size_ = data_length1;
#line 350 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							offset = 0;
#line 2883 "book.c"
							{
								gint row = 0;
#line 351 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								row = 0;
#line 2888 "book.c"
								{
									gboolean _tmp179_ = FALSE;
#line 351 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									_tmp179_ = TRUE;
#line 351 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									while (TRUE) {
#line 2895 "book.c"
										gboolean _tmp180_ = FALSE;
										gint _tmp182_ = 0;
										gint _tmp183_ = 0;
										gint _tmp184_ = 0;
										gint in_offset = 0;
										gint _tmp186_ = 0;
										GdkPixbuf* _tmp187_ = NULL;
										gint _tmp188_ = 0;
#line 351 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp180_ = _tmp179_;
#line 351 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										if (!_tmp180_) {
#line 2908 "book.c"
											gint _tmp181_ = 0;
#line 351 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp181_ = row;
#line 351 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											row = _tmp181_ + 1;
#line 2914 "book.c"
										}
#line 351 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp179_ = FALSE;
#line 351 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp182_ = row;
#line 351 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp183_ = height;
#line 351 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										if (!(_tmp182_ < _tmp183_)) {
#line 351 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											break;
#line 2926 "book.c"
										}
#line 354 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp184_ = mask;
#line 354 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										if (_tmp184_ != 0x80) {
#line 2932 "book.c"
											gint _tmp185_ = 0;
#line 356 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp185_ = offset;
#line 356 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											offset = _tmp185_ + 1;
#line 357 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											mask = 0x80;
#line 2940 "book.c"
										}
#line 360 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp186_ = row;
#line 360 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp187_ = image;
#line 360 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp188_ = gdk_pixbuf_get_rowstride (_tmp187_);
#line 360 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										in_offset = _tmp186_ * _tmp188_;
#line 2950 "book.c"
										{
											gint x = 0;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											x = 0;
#line 2955 "book.c"
											{
												gboolean _tmp189_ = FALSE;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp189_ = TRUE;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												while (TRUE) {
#line 2962 "book.c"
													gboolean _tmp190_ = FALSE;
													gint _tmp192_ = 0;
													gint _tmp193_ = 0;
													gint _tmp194_ = 0;
													guint8* _tmp198_ = NULL;
													gint _tmp198__length1 = 0;
													gint _tmp199_ = 0;
													gint _tmp200_ = 0;
													guint8 _tmp201_ = 0U;
													gint _tmp206_ = 0;
													gint _tmp207_ = 0;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp190_ = _tmp189_;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													if (!_tmp190_) {
#line 2978 "book.c"
														gint _tmp191_ = 0;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp191_ = x;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														x = _tmp191_ + 1;
#line 2984 "book.c"
													}
#line 361 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp189_ = FALSE;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp192_ = x;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp193_ = width;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													if (!(_tmp192_ < _tmp193_)) {
#line 361 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														break;
#line 2996 "book.c"
													}
#line 364 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp194_ = mask;
#line 364 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													if (_tmp194_ == 0x80) {
#line 3002 "book.c"
														guint8* _tmp195_ = NULL;
														gint _tmp195__length1 = 0;
														gint _tmp196_ = 0;
														guint8 _tmp197_ = 0U;
#line 365 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp195_ = data;
#line 365 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp195__length1 = data_length1;
#line 365 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp196_ = offset;
#line 365 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp195_[_tmp196_] = (guint8) 0;
#line 365 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp197_ = _tmp195_[_tmp196_];
#line 3017 "book.c"
													}
#line 368 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp198_ = pixels;
#line 368 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp198__length1 = pixels_length1;
#line 368 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp199_ = in_offset;
#line 368 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp200_ = x;
#line 368 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp201_ = _tmp198_[_tmp199_ + (_tmp200_ * 3)];
#line 368 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													if (((gint) _tmp201_) != 0) {
#line 3031 "book.c"
														guint8* _tmp202_ = NULL;
														gint _tmp202__length1 = 0;
														gint _tmp203_ = 0;
														gint _tmp204_ = 0;
														guint8 _tmp205_ = 0U;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp202_ = data;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp202__length1 = data_length1;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp203_ = offset;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp204_ = mask;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp202_[_tmp203_] |= (guint8) _tmp204_;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp205_ = _tmp202_[_tmp203_];
#line 3049 "book.c"
													}
#line 372 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp206_ = mask;
#line 372 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													mask = _tmp206_ >> 1;
#line 373 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp207_ = mask;
#line 373 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													if (_tmp207_ == 0) {
#line 3059 "book.c"
														gint _tmp208_ = 0;
#line 375 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp208_ = offset;
#line 375 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														offset = _tmp208_ + 1;
#line 376 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														mask = 0x80;
#line 3067 "book.c"
													}
												}
											}
										}
									}
								}
							}
						} else {
							gchar* _tmp209_ = NULL;
							gint data_length = 0;
							gint _tmp210_ = 0;
							gint _tmp211_ = 0;
							gint _tmp212_ = 0;
							guint8* _tmp213_ = NULL;
#line 383 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							depth = 8;
#line 384 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp209_ = g_strdup ("DeviceGray");
#line 384 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_g_free0 (color_space);
#line 384 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							color_space = _tmp209_;
#line 385 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp210_ = height;
#line 385 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp211_ = width;
#line 385 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							data_length = _tmp210_ * _tmp211_;
#line 386 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp212_ = data_length;
#line 386 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp213_ = g_new0 (guint8, _tmp212_);
#line 386 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							data = (g_free (data), NULL);
#line 386 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							data = _tmp213_;
#line 386 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							data_length1 = _tmp212_;
#line 386 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_data_size_ = data_length1;
#line 3108 "book.c"
							{
								gint row = 0;
#line 387 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
								row = 0;
#line 3113 "book.c"
								{
									gboolean _tmp214_ = FALSE;
#line 387 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									_tmp214_ = TRUE;
#line 387 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
									while (TRUE) {
#line 3120 "book.c"
										gboolean _tmp215_ = FALSE;
										gint _tmp217_ = 0;
										gint _tmp218_ = 0;
										gint in_offset = 0;
										gint _tmp219_ = 0;
										GdkPixbuf* _tmp220_ = NULL;
										gint _tmp221_ = 0;
										gint out_offset = 0;
										gint _tmp222_ = 0;
										gint _tmp223_ = 0;
#line 387 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp215_ = _tmp214_;
#line 387 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										if (!_tmp215_) {
#line 3135 "book.c"
											gint _tmp216_ = 0;
#line 387 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											_tmp216_ = row;
#line 387 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											row = _tmp216_ + 1;
#line 3141 "book.c"
										}
#line 387 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp214_ = FALSE;
#line 387 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp217_ = row;
#line 387 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp218_ = height;
#line 387 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										if (!(_tmp217_ < _tmp218_)) {
#line 387 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											break;
#line 3153 "book.c"
										}
#line 389 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp219_ = row;
#line 389 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp220_ = image;
#line 389 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp221_ = gdk_pixbuf_get_rowstride (_tmp220_);
#line 389 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										in_offset = _tmp219_ * _tmp221_;
#line 390 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp222_ = row;
#line 390 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										_tmp223_ = width;
#line 390 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
										out_offset = _tmp222_ * _tmp223_;
#line 3169 "book.c"
										{
											gint x = 0;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
											x = 0;
#line 3174 "book.c"
											{
												gboolean _tmp224_ = FALSE;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												_tmp224_ = TRUE;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
												while (TRUE) {
#line 3181 "book.c"
													gboolean _tmp225_ = FALSE;
													gint _tmp227_ = 0;
													gint _tmp228_ = 0;
													guint8* _tmp229_ = NULL;
													gint _tmp229__length1 = 0;
													gint _tmp230_ = 0;
													gint _tmp231_ = 0;
													guint8* _tmp232_ = NULL;
													gint _tmp232__length1 = 0;
													gint _tmp233_ = 0;
													gint _tmp234_ = 0;
													guint8 _tmp235_ = 0U;
													guint8 _tmp236_ = 0U;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp225_ = _tmp224_;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													if (!_tmp225_) {
#line 3199 "book.c"
														gint _tmp226_ = 0;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														_tmp226_ = x;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														x = _tmp226_ + 1;
#line 3205 "book.c"
													}
#line 391 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp224_ = FALSE;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp227_ = x;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp228_ = width;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													if (!(_tmp227_ < _tmp228_)) {
#line 391 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
														break;
#line 3217 "book.c"
													}
#line 392 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp229_ = data;
#line 392 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp229__length1 = data_length1;
#line 392 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp230_ = out_offset;
#line 392 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp231_ = x;
#line 392 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp232_ = pixels;
#line 392 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp232__length1 = pixels_length1;
#line 392 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp233_ = in_offset;
#line 392 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp234_ = x;
#line 392 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp235_ = _tmp232_[_tmp233_ + (_tmp234_ * 3)];
#line 392 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp229_[_tmp230_ + _tmp231_] = _tmp235_;
#line 392 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
													_tmp236_ = _tmp229_[_tmp230_ + _tmp231_];
#line 3241 "book.c"
												}
											}
										}
									}
								}
							}
						}
					}
				}
#line 397 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp237_ = data;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp237__length1 = data_length1;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp239_ = book_compress_zlib (self, _tmp237_, _tmp237__length1, &_tmp238_);
#line 397 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				compressed_data = _tmp239_;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				compressed_data_length1 = _tmp238_;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_compressed_data_size_ = compressed_data_length1;
#line 398 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp240_ = compressed_data;
#line 398 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp240__length1 = compressed_data_length1;
#line 398 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (_tmp240_ != NULL) {
#line 3269 "book.c"
					gint _tmp241_ = 0;
					const gchar* _tmp253_ = NULL;
#line 401 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp241_ = depth;
#line 401 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					if (_tmp241_ > 1) {
#line 3276 "book.c"
						guint8* jpeg_data = NULL;
						GdkPixbuf* _tmp242_ = NULL;
						gint _tmp243_ = 0;
						Page* _tmp244_ = NULL;
						gint _tmp245_ = 0;
						gint _tmp246_ = 0;
						guint8* _tmp247_ = NULL;
						gint jpeg_data_length1 = 0;
						gint _jpeg_data_size_ = 0;
						guint8* _tmp248_ = NULL;
						gint _tmp248__length1 = 0;
						guint8* _tmp249_ = NULL;
						gint _tmp249__length1 = 0;
#line 403 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp242_ = image;
#line 403 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp243_ = quality;
#line 403 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp244_ = page;
#line 403 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp245_ = page_get_dpi (_tmp244_);
#line 403 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp247_ = book_compress_jpeg (self, _tmp242_, _tmp243_, _tmp245_, &_tmp246_);
#line 403 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						jpeg_data = _tmp247_;
#line 403 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						jpeg_data_length1 = _tmp246_;
#line 403 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_jpeg_data_size_ = jpeg_data_length1;
#line 404 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp248_ = jpeg_data;
#line 404 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp248__length1 = jpeg_data_length1;
#line 404 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp249_ = compressed_data;
#line 404 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp249__length1 = compressed_data_length1;
#line 404 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						if (_tmp248__length1 < _tmp249__length1) {
#line 3316 "book.c"
							gchar* _tmp250_ = NULL;
							guint8* _tmp251_ = NULL;
							gint _tmp251__length1 = 0;
							guint8* _tmp252_ = NULL;
							gint _tmp252__length1 = 0;
#line 406 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp250_ = g_strdup ("DCTDecode");
#line 406 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_g_free0 (filter);
#line 406 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							filter = _tmp250_;
#line 407 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp251_ = jpeg_data;
#line 407 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp251__length1 = jpeg_data_length1;
#line 407 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp252_ = (_tmp251_ != NULL) ? _vala_array_dup1 (_tmp251_, _tmp251__length1) : ((gpointer) _tmp251_);
#line 407 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_tmp252__length1 = _tmp251__length1;
#line 407 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							data = (g_free (data), NULL);
#line 407 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							data = _tmp252_;
#line 407 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							data_length1 = _tmp252__length1;
#line 407 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
							_data_size_ = data_length1;
#line 3344 "book.c"
						}
#line 401 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						jpeg_data = (g_free (jpeg_data), NULL);
#line 3348 "book.c"
					}
#line 411 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp253_ = filter;
#line 411 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					if (_tmp253_ == NULL) {
#line 3354 "book.c"
						gchar* _tmp254_ = NULL;
						guint8* _tmp255_ = NULL;
						gint _tmp255__length1 = 0;
						guint8* _tmp256_ = NULL;
						gint _tmp256__length1 = 0;
#line 413 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp254_ = g_strdup ("FlateDecode");
#line 413 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_g_free0 (filter);
#line 413 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						filter = _tmp254_;
#line 414 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp255_ = compressed_data;
#line 414 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp255__length1 = compressed_data_length1;
#line 414 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp256_ = (_tmp255_ != NULL) ? _vala_array_dup2 (_tmp255_, _tmp255__length1) : ((gpointer) _tmp255_);
#line 414 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_tmp256__length1 = _tmp255__length1;
#line 414 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						data = (g_free (data), NULL);
#line 414 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						data = _tmp256_;
#line 414 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						data_length1 = _tmp256__length1;
#line 414 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
						_data_size_ = data_length1;
#line 3382 "book.c"
					}
				}
#line 419 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp257_ = writer;
#line 419 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp257_, "\n");
#line 420 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp258_ = writer;
#line 420 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp259_ = pdf_writer_start_object (_tmp258_);
#line 420 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				number = _tmp259_;
#line 421 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp260_ = writer;
#line 421 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp261_ = number;
#line 421 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp262_ = g_strdup_printf ("%u 0 obj\n", _tmp261_);
#line 421 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp263_ = _tmp262_;
#line 421 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp260_, _tmp263_);
#line 421 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp263_);
#line 422 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp264_ = writer;
#line 422 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp264_, "<<\n");
#line 423 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp265_ = writer;
#line 423 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp265_, "/Type /Page\n");
#line 424 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp266_ = writer;
#line 424 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp267_ = pages_number;
#line 424 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp268_ = g_strdup_printf ("/Parent %u 0 R\n", _tmp267_);
#line 424 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp269_ = _tmp268_;
#line 424 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp266_, _tmp269_);
#line 424 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp269_);
#line 425 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp270_ = writer;
#line 425 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp271_ = i;
#line 425 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp272_ = number;
#line 425 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp273_ = g_strdup_printf ("/Resources << /XObject << /Im%d %u 0 R >> >>\n", _tmp271_, _tmp272_ + 1);
#line 425 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp274_ = _tmp273_;
#line 425 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp270_, _tmp274_);
#line 425 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp274_);
#line 426 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp275_ = writer;
#line 426 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp276_ = page_width;
#line 426 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp277_ = width_buffer;
#line 426 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp277__length1 = width_buffer_length1;
#line 426 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp278_ = g_ascii_formatd (_tmp277_, _tmp277__length1, "%.2f", _tmp276_);
#line 426 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp279_ = page_height;
#line 426 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp280_ = height_buffer;
#line 426 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp280__length1 = height_buffer_length1;
#line 426 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp281_ = g_ascii_formatd (_tmp280_, _tmp280__length1, "%.2f", _tmp279_);
#line 426 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp282_ = g_strdup_printf ("/MediaBox [ 0 0 %s %s ]\n", _tmp278_, _tmp281_);
#line 426 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp283_ = _tmp282_;
#line 426 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp275_, _tmp283_);
#line 426 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp283_);
#line 427 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp284_ = writer;
#line 427 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp285_ = number;
#line 427 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp286_ = g_strdup_printf ("/Contents %u 0 R\n", _tmp285_ + 2);
#line 427 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp287_ = _tmp286_;
#line 427 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp284_, _tmp287_);
#line 427 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp287_);
#line 428 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp288_ = writer;
#line 428 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp288_, ">>\n");
#line 429 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp289_ = writer;
#line 429 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp289_, "endobj\n");
#line 432 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp290_ = writer;
#line 432 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp290_, "\n");
#line 433 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp291_ = writer;
#line 433 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp292_ = pdf_writer_start_object (_tmp291_);
#line 433 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				number = _tmp292_;
#line 434 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp293_ = writer;
#line 434 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp294_ = number;
#line 434 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp295_ = g_strdup_printf ("%u 0 obj\n", _tmp294_);
#line 434 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp296_ = _tmp295_;
#line 434 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp293_, _tmp296_);
#line 434 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp296_);
#line 435 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp297_ = writer;
#line 435 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp297_, "<<\n");
#line 436 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp298_ = writer;
#line 436 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp298_, "/Type /XObject\n");
#line 437 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp299_ = writer;
#line 437 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp299_, "/Subtype /Image\n");
#line 438 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp300_ = writer;
#line 438 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp301_ = width;
#line 438 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp302_ = g_strdup_printf ("/Width %d\n", _tmp301_);
#line 438 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp303_ = _tmp302_;
#line 438 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp300_, _tmp303_);
#line 438 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp303_);
#line 439 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp304_ = writer;
#line 439 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp305_ = height;
#line 439 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp306_ = g_strdup_printf ("/Height %d\n", _tmp305_);
#line 439 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp307_ = _tmp306_;
#line 439 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp304_, _tmp307_);
#line 439 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp307_);
#line 440 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp308_ = writer;
#line 440 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp309_ = color_space;
#line 440 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp310_ = g_strdup_printf ("/ColorSpace /%s\n", _tmp309_);
#line 440 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp311_ = _tmp310_;
#line 440 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp308_, _tmp311_);
#line 440 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp311_);
#line 441 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp312_ = writer;
#line 441 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp313_ = depth;
#line 441 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp314_ = g_strdup_printf ("/BitsPerComponent %d\n", _tmp313_);
#line 441 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp315_ = _tmp314_;
#line 441 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp312_, _tmp315_);
#line 441 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp315_);
#line 442 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp316_ = writer;
#line 442 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp317_ = data;
#line 442 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp317__length1 = data_length1;
#line 442 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp318_ = g_strdup_printf ("/Length %d\n", _tmp317__length1);
#line 442 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp319_ = _tmp318_;
#line 442 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp316_, _tmp319_);
#line 442 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp319_);
#line 443 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp320_ = filter;
#line 443 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (_tmp320_ != NULL) {
#line 3587 "book.c"
					PDFWriter* _tmp321_ = NULL;
					const gchar* _tmp322_ = NULL;
					gchar* _tmp323_ = NULL;
					gchar* _tmp324_ = NULL;
#line 444 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp321_ = writer;
#line 444 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp322_ = filter;
#line 444 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp323_ = g_strdup_printf ("/Filter /%s\n", _tmp322_);
#line 444 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_tmp324_ = _tmp323_;
#line 444 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					pdf_writer_write_string (_tmp321_, _tmp324_);
#line 444 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					_g_free0 (_tmp324_);
#line 3604 "book.c"
				}
#line 445 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp325_ = writer;
#line 445 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp325_, ">>\n");
#line 446 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp326_ = writer;
#line 446 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp326_, "stream\n");
#line 447 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp327_ = writer;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp328_ = data;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp328__length1 = data_length1;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write (_tmp327_, _tmp328_, _tmp328__length1);
#line 448 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp329_ = writer;
#line 448 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp329_, "\n");
#line 449 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp330_ = writer;
#line 449 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp330_, "endstream\n");
#line 450 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp331_ = writer;
#line 450 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp331_, "endobj\n");
#line 453 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp332_ = page_width;
#line 453 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp333_ = width_buffer;
#line 453 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp333__length1 = width_buffer_length1;
#line 453 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp334_ = g_ascii_formatd (_tmp333_, _tmp333__length1, "%f", _tmp332_);
#line 453 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp335_ = page_height;
#line 453 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp336_ = height_buffer;
#line 453 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp336__length1 = height_buffer_length1;
#line 453 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp337_ = g_ascii_formatd (_tmp336_, _tmp336__length1, "%f", _tmp335_);
#line 453 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp338_ = i;
#line 453 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp339_ = g_strdup_printf ("q\n%s 0 0 %s 0 0 cm\n/Im%d Do\nQ", _tmp334_, _tmp337_, _tmp338_);
#line 453 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				command = _tmp339_;
#line 454 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp340_ = writer;
#line 454 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp340_, "\n");
#line 455 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp341_ = writer;
#line 455 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp342_ = pdf_writer_start_object (_tmp341_);
#line 455 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				number = _tmp342_;
#line 456 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp343_ = writer;
#line 456 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp344_ = number;
#line 456 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp345_ = g_strdup_printf ("%u 0 obj\n", _tmp344_);
#line 456 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp346_ = _tmp345_;
#line 456 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp343_, _tmp346_);
#line 456 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp346_);
#line 457 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp347_ = writer;
#line 457 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp347_, "<<\n");
#line 458 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp348_ = writer;
#line 458 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp349_ = command;
#line 458 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp350_ = strlen (_tmp349_);
#line 458 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp351_ = _tmp350_;
#line 458 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp352_ = g_strdup_printf ("/Length %d\n", _tmp351_);
#line 458 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp353_ = _tmp352_;
#line 458 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp348_, _tmp353_);
#line 458 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp353_);
#line 459 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp354_ = writer;
#line 459 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp354_, ">>\n");
#line 460 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp355_ = writer;
#line 460 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp355_, "stream\n");
#line 461 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp356_ = writer;
#line 461 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp357_ = command;
#line 461 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp356_, _tmp357_);
#line 462 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp358_ = writer;
#line 462 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp358_, "\n");
#line 463 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp359_ = writer;
#line 463 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp359_, "endstream\n");
#line 464 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp360_ = writer;
#line 464 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp360_, "endobj\n");
#line 466 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp361_ = i;
#line 466 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				g_signal_emit_by_name (self, "saving", _tmp361_);
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (command);
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				compressed_data = (g_free (compressed_data), NULL);
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				data = (g_free (data), NULL);
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				height_buffer = (g_free (height_buffer), NULL);
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				width_buffer = (g_free (width_buffer), NULL);
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (filter);
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (color_space);
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_object_unref0 (image);
#line 261 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_page_unref0 (page);
#line 3746 "book.c"
			}
		}
	}
#line 470 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp362_ = writer;
#line 470 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp362_, "\n");
#line 471 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp363_ = writer;
#line 471 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp364_ = pdf_writer_start_object (_tmp363_);
#line 471 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	info_number = _tmp364_;
#line 472 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp365_ = writer;
#line 472 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp366_ = info_number;
#line 472 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp367_ = g_strdup_printf ("%u 0 obj\n", _tmp366_);
#line 472 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp368_ = _tmp367_;
#line 472 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp365_, _tmp368_);
#line 472 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp368_);
#line 473 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp369_ = writer;
#line 473 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp369_, "<<\n");
#line 474 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp370_ = writer;
#line 474 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp371_ = g_strdup_printf ("/Creator (Simple Scan %s)\n", VERSION);
#line 474 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp372_ = _tmp371_;
#line 474 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp370_, _tmp372_);
#line 474 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp372_);
#line 475 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp373_ = writer;
#line 475 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp373_, ">>\n");
#line 476 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp374_ = writer;
#line 476 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp374_, "endobj\n");
#line 479 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp375_ = writer;
#line 479 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp375_, "\n");
#line 480 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp376_ = writer;
#line 480 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp377_ = _tmp376_->offset;
#line 480 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	xref_offset = _tmp377_;
#line 481 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp378_ = writer;
#line 481 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp378_, "xref\n");
#line 482 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp379_ = writer;
#line 482 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp380_ = writer;
#line 482 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp381_ = _tmp380_->object_offsets;
#line 482 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp382_ = g_list_length (_tmp381_);
#line 482 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp383_ = g_strdup_printf ("0 %zu\n", (gsize) (_tmp382_ + 1));
#line 482 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp384_ = _tmp383_;
#line 482 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp379_, _tmp384_);
#line 482 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp384_);
#line 483 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp385_ = writer;
#line 483 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp385_, "0000000000 65535 f \n");
#line 484 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp386_ = writer;
#line 484 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp387_ = _tmp386_->object_offsets;
#line 3832 "book.c"
	{
		GList* offset_collection = NULL;
		GList* offset_it = NULL;
#line 484 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		offset_collection = _tmp387_;
#line 484 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		for (offset_it = offset_collection; offset_it != NULL; offset_it = offset_it->next) {
#line 3840 "book.c"
			guint offset = 0U;
#line 484 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			offset = (guint) ((guintptr) offset_it->data);
#line 3844 "book.c"
			{
				PDFWriter* _tmp388_ = NULL;
				guint _tmp389_ = 0U;
				gchar* _tmp390_ = NULL;
				gchar* _tmp391_ = NULL;
#line 485 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp388_ = writer;
#line 485 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp389_ = offset;
#line 485 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp390_ = g_strdup_printf ("%010zu 00000 n \n", (gsize) _tmp389_);
#line 485 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp391_ = _tmp390_;
#line 485 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				pdf_writer_write_string (_tmp388_, _tmp391_);
#line 485 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_g_free0 (_tmp391_);
#line 3862 "book.c"
			}
		}
	}
#line 488 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp392_ = writer;
#line 488 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp392_, "\n");
#line 489 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp393_ = writer;
#line 489 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp393_, "trailer\n");
#line 490 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp394_ = writer;
#line 490 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp394_, "<<\n");
#line 491 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp395_ = writer;
#line 491 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp396_ = writer;
#line 491 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp397_ = _tmp396_->object_offsets;
#line 491 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp398_ = g_list_length (_tmp397_);
#line 491 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp399_ = g_strdup_printf ("/Size %zu\n", (gsize) (_tmp398_ + 1));
#line 491 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp400_ = _tmp399_;
#line 491 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp395_, _tmp400_);
#line 491 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp400_);
#line 492 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp401_ = writer;
#line 492 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp402_ = info_number;
#line 492 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp403_ = g_strdup_printf ("/Info %u 0 R\n", _tmp402_);
#line 492 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp404_ = _tmp403_;
#line 492 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp401_, _tmp404_);
#line 492 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp404_);
#line 493 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp405_ = writer;
#line 493 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp406_ = catalog_number;
#line 493 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp407_ = g_strdup_printf ("/Root %u 0 R\n", _tmp406_);
#line 493 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp408_ = _tmp407_;
#line 493 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp405_, _tmp408_);
#line 493 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp408_);
#line 494 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp409_ = writer;
#line 494 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp410_ = id;
#line 494 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp411_ = id;
#line 494 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp412_ = g_strdup_printf ("/ID [<%s> <%s>]\n", _tmp410_, _tmp411_);
#line 494 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp413_ = _tmp412_;
#line 494 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp409_, _tmp413_);
#line 494 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp413_);
#line 495 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp414_ = writer;
#line 495 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp414_, ">>\n");
#line 496 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp415_ = writer;
#line 496 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp415_, "startxref\n");
#line 497 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp416_ = writer;
#line 497 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp417_ = xref_offset;
#line 497 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp418_ = g_strdup_printf ("%zu\n", _tmp417_);
#line 497 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp419_ = _tmp418_;
#line 497 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp416_, _tmp419_);
#line 497 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (_tmp419_);
#line 498 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp420_ = writer;
#line 498 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write_string (_tmp420_, "%%EOF\n");
#line 205 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_pdf_writer_unref0 (writer);
#line 205 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_object_unref0 (stream);
#line 205 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_free0 (id);
#line 3962 "book.c"
}


void book_save (Book* self, const gchar* type, gint quality, GFile* file, GError** error) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 503 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	static GQuark _tmp2_label0 = 0;
#line 503 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	static GQuark _tmp2_label1 = 0;
#line 503 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	static GQuark _tmp2_label2 = 0;
#line 503 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	static GQuark _tmp2_label3 = 0;
#line 503 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	static GQuark _tmp2_label4 = 0;
#line 3980 "book.c"
	GError * _inner_error_ = NULL;
#line 501 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 501 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (type != NULL);
#line 501 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (file != NULL);
#line 503 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = type;
#line 503 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = _tmp0_;
#line 503 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 503 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("jpeg")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("png"))))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("tiff"))))) {
#line 503 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		switch (0) {
#line 3998 "book.c"
			default:
			{
				const gchar* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				GFile* _tmp6_ = NULL;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp4_ = type;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp5_ = quality;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp6_ = file;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				book_save_multi_file (self, _tmp4_, _tmp5_, _tmp6_, &_inner_error_);
#line 508 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (_inner_error_ != NULL) {
#line 508 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 508 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					return;
#line 4018 "book.c"
				}
#line 509 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				break;
#line 4022 "book.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("ps")))) {
#line 503 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		switch (0) {
#line 4028 "book.c"
			default:
			{
				GFile* _tmp7_ = NULL;
#line 511 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp7_ = file;
#line 511 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				book_save_ps (self, _tmp7_, &_inner_error_);
#line 511 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (_inner_error_ != NULL) {
#line 511 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 511 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					return;
#line 4042 "book.c"
				}
#line 512 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				break;
#line 4046 "book.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("pdf")))) {
#line 503 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		switch (0) {
#line 4052 "book.c"
			default:
			{
				GFile* _tmp8_ = NULL;
				gint _tmp9_ = 0;
#line 514 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp8_ = file;
#line 514 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp9_ = quality;
#line 514 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				book_save_pdf (self, _tmp8_, _tmp9_, &_inner_error_);
#line 514 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				if (_inner_error_ != NULL) {
#line 514 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 514 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
					return;
#line 4069 "book.c"
				}
#line 515 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				break;
#line 4073 "book.c"
			}
		}
	}
}


void book_set_needs_saving (Book* self, gboolean needs_saving) {
	gboolean needed_saving = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 519 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 521 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = self->priv->needs_saving;
#line 521 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	needed_saving = _tmp0_;
#line 522 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = needs_saving;
#line 522 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv->needs_saving = _tmp1_;
#line 523 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = needed_saving;
#line 523 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3_ = needs_saving;
#line 523 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (_tmp2_ != _tmp3_) {
#line 524 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_signal_emit_by_name (self, "needs-saving-changed");
#line 4104 "book.c"
	}
}


gboolean book_get_needs_saving (Book* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 527 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 529 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = self->priv->needs_saving;
#line 529 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	result = _tmp0_;
#line 529 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 4120 "book.c"
}


static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__PAGE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__PAGE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (n_param_values == 2);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		data1 = closure->data;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		data2 = param_values->data[0].v_pointer;
#line 4139 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		data1 = param_values->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		data2 = closure->data;
#line 4145 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	callback = (GMarshalFunc_VOID__PAGE) (marshal_data ? marshal_data : cc->callback);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	callback (data1, value_get_page (param_values + 1), data2);
#line 4151 "book.c"
}


static void value_book_init (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 4158 "book.c"
}


static void value_book_free_value (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		book_unref (value->data[0].v_pointer);
#line 4167 "book.c"
	}
}


static void value_book_copy_value (const GValue* src_value, GValue* dest_value) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		dest_value->data[0].v_pointer = book_ref (src_value->data[0].v_pointer);
#line 4177 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4181 "book.c"
	}
}


static gpointer value_book_peek_pointer (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return value->data[0].v_pointer;
#line 4189 "book.c"
}


static gchar* value_book_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 4196 "book.c"
		Book* object;
		object = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4203 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4207 "book.c"
		}
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = book_ref (object);
#line 4211 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4215 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return NULL;
#line 4219 "book.c"
}


static gchar* value_book_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Book** object_p;
	object_p = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (!object_p) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4230 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		*object_p = NULL;
#line 4236 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 4240 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		*object_p = book_ref (value->data[0].v_pointer);
#line 4244 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return NULL;
#line 4248 "book.c"
}


GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecBook* spec;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BOOK), NULL);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 4262 "book.c"
}


gpointer value_get_book (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK), NULL);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return value->data[0].v_pointer;
#line 4271 "book.c"
}


void value_set_book (GValue* value, gpointer v_object) {
	Book* old;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		book_ref (value->data[0].v_pointer);
#line 4291 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4295 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		book_unref (old);
#line 4301 "book.c"
	}
}


void value_take_book (GValue* value, gpointer v_object) {
	Book* old;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 4320 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4324 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		book_unref (old);
#line 4330 "book.c"
	}
}


static void book_class_init (BookClass * klass) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	book_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	BOOK_CLASS (klass)->finalize = book_finalize;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_type_class_add_private (klass, sizeof (BookPrivate));
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_new ("page_added", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_new ("page_removed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_new ("reordered", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_new ("cleared", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_new ("needs_saving_changed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_signal_new ("saving", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
#line 4354 "book.c"
}


static void book_instance_init (Book * self) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv = BOOK_GET_PRIVATE (self);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->ref_count = 1;
#line 4363 "book.c"
}


static void book_finalize (Book* obj) {
	Book * self;
	GList* _tmp0_ = NULL;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOK, Book);
#line 32 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 4374 "book.c"
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
#line 32 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		page_collection = _tmp0_;
#line 32 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
#line 4382 "book.c"
			Page* _tmp1_ = NULL;
			Page* page = NULL;
#line 32 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
#line 32 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			page = _tmp1_;
#line 4389 "book.c"
			{
				Page* _tmp2_ = NULL;
				guint _tmp3_ = 0U;
				Page* _tmp4_ = NULL;
				guint _tmp5_ = 0U;
#line 34 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp2_ = page;
#line 34 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 34 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 35 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_tmp4_ = page;
#line 35 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
#line 35 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 32 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
				_page_unref0 (page);
#line 4409 "book.c"
			}
		}
	}
#line 14 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 179 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_byte_array_unref0 (self->priv->jpeg_data);
#line 4417 "book.c"
}


GType book_get_type (void) {
	static volatile gsize book_type_id__volatile = 0;
	if (g_once_init_enter (&book_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_book_init, value_book_free_value, value_book_copy_value, value_book_peek_pointer, "p", value_book_collect_value, "p", value_book_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BookClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) book_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Book), 0, (GInstanceInitFunc) book_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType book_type_id;
		book_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Book", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&book_type_id__volatile, book_type_id);
	}
	return book_type_id__volatile;
}


gpointer book_ref (gpointer instance) {
	Book* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return instance;
#line 4442 "book.c"
}


void book_unref (gpointer instance) {
	Book* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		BOOK_GET_CLASS (self)->finalize (self);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4455 "book.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 541 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return self ? g_object_ref (self) : NULL;
#line 4463 "book.c"
}


PDFWriter* pdf_writer_construct (GType object_type, GFileOutputStream* stream) {
	PDFWriter* self = NULL;
	GFileOutputStream* _tmp0_ = NULL;
	GFileOutputStream* _tmp1_ = NULL;
#line 539 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (stream != NULL, NULL);
#line 539 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self = (PDFWriter*) g_type_create_instance (object_type);
#line 541 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = stream;
#line 541 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 541 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_object_unref0 (self->priv->stream);
#line 541 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv->stream = _tmp1_;
#line 539 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return self;
#line 4485 "book.c"
}


PDFWriter* pdf_writer_new (GFileOutputStream* stream) {
#line 539 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return pdf_writer_construct (TYPE_PDF_WRITER, stream);
#line 4492 "book.c"
}


void pdf_writer_write (PDFWriter* self, guint8* data, int data_length1) {
	gsize _tmp4_ = 0UL;
	guint8* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	GError * _inner_error_ = NULL;
#line 544 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 4503 "book.c"
	{
		GFileOutputStream* _tmp0_ = NULL;
		guint8* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
#line 548 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp0_ = self->priv->stream;
#line 548 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp1_ = data;
#line 548 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp1__length1 = data_length1;
#line 548 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
#line 548 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		if (_inner_error_ != NULL) {
#line 4518 "book.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 546 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		e = _inner_error_;
#line 546 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_inner_error_ = NULL;
#line 552 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp2_ = e;
#line 552 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp3_ = _tmp2_->message;
#line 552 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_warning ("book.vala:552: Error writing PDF: %s", _tmp3_);
#line 546 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_g_error_free0 (e);
#line 4540 "book.c"
	}
	__finally1:
#line 546 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (_inner_error_ != NULL) {
#line 546 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 546 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_clear_error (&_inner_error_);
#line 546 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		return;
#line 4551 "book.c"
	}
#line 554 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp4_ = self->offset;
#line 554 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5_ = data;
#line 554 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp5__length1 = data_length1;
#line 554 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->offset = _tmp4_ + _tmp5__length1;
#line 4561 "book.c"
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
#line 1266 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1267 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1267 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1267 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
#line 1267 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1267 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_result__length1 = _tmp1_ + 1;
#line 1267 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	__result__size_ = _result__length1;
#line 1268 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = _result__length1;
#line 1268 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_result__length1 = _tmp3_ - 1;
#line 1269 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp4_ = _result_;
#line 1269 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp4__length1 = _result__length1;
#line 1269 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp5_ = strlen (self);
#line 1269 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp6_ = _tmp5_;
#line 1269 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	memcpy (_tmp4_, self, (gsize) _tmp6_);
#line 1270 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp7_ = _result_;
#line 1270 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp7__length1 = _result__length1;
#line 1270 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1270 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		*result_length1 = _tmp7__length1;
#line 4616 "book.c"
	}
#line 1270 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1270 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 4622 "book.c"
}


void pdf_writer_write_string (PDFWriter* self, const gchar* text) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
#line 557 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (self != NULL);
#line 557 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (text != NULL);
#line 559 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = text;
#line 559 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = string_to_utf8 (_tmp0_, &_tmp1_);
#line 559 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3_ = (guint8*) _tmp2_;
#line 559 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3__length1 = (_tmp1_ * sizeof (gchar)) / sizeof (guint8);
#line 559 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_write (self, _tmp3_, (_tmp1_ * sizeof (gchar)) / sizeof (guint8));
#line 559 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp3_ = (g_free (_tmp3_), NULL);
#line 4648 "book.c"
}


guint pdf_writer_start_object (PDFWriter* self) {
	guint result = 0U;
	gsize _tmp0_ = 0UL;
	GList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
#line 562 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 564 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = self->offset;
#line 564 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->object_offsets = g_list_append (self->object_offsets, (gpointer) ((guintptr) ((guint) _tmp0_)));
#line 565 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = self->object_offsets;
#line 565 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = g_list_length (_tmp1_);
#line 565 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	result = _tmp2_;
#line 565 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 4671 "book.c"
}


static void value_pdf_writer_init (GValue* value) {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 4678 "book.c"
}


static void value_pdf_writer_free_value (GValue* value) {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (value->data[0].v_pointer) {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		pdf_writer_unref (value->data[0].v_pointer);
#line 4687 "book.c"
	}
}


static void value_pdf_writer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		dest_value->data[0].v_pointer = pdf_writer_ref (src_value->data[0].v_pointer);
#line 4697 "book.c"
	} else {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4701 "book.c"
	}
}


static gpointer value_pdf_writer_peek_pointer (const GValue* value) {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return value->data[0].v_pointer;
#line 4709 "book.c"
}


static gchar* value_pdf_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 4716 "book.c"
		PDFWriter* object;
		object = collect_values[0].v_pointer;
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4723 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4727 "book.c"
		}
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = pdf_writer_ref (object);
#line 4731 "book.c"
	} else {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4735 "book.c"
	}
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return NULL;
#line 4739 "book.c"
}


static gchar* value_pdf_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PDFWriter** object_p;
	object_p = collect_values[0].v_pointer;
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (!object_p) {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4750 "book.c"
	}
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		*object_p = NULL;
#line 4756 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 4760 "book.c"
	} else {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		*object_p = pdf_writer_ref (value->data[0].v_pointer);
#line 4764 "book.c"
	}
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return NULL;
#line 4768 "book.c"
}


GParamSpec* param_spec_pdf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPDFWriter* spec;
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PDF_WRITER), NULL);
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 4782 "book.c"
}


gpointer value_get_pdf_writer (const GValue* value) {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER), NULL);
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return value->data[0].v_pointer;
#line 4791 "book.c"
}


void value_set_pdf_writer (GValue* value, gpointer v_object) {
	PDFWriter* old;
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	old = value->data[0].v_pointer;
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (v_object) {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		pdf_writer_ref (value->data[0].v_pointer);
#line 4811 "book.c"
	} else {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4815 "book.c"
	}
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (old) {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		pdf_writer_unref (old);
#line 4821 "book.c"
	}
}


void value_take_pdf_writer (GValue* value, gpointer v_object) {
	PDFWriter* old;
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	old = value->data[0].v_pointer;
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (v_object) {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 4840 "book.c"
	} else {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4844 "book.c"
	}
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (old) {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		pdf_writer_unref (old);
#line 4850 "book.c"
	}
}


static void pdf_writer_class_init (PDFWriterClass * klass) {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	pdf_writer_parent_class = g_type_class_peek_parent (klass);
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	PDF_WRITER_CLASS (klass)->finalize = pdf_writer_finalize;
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_type_class_add_private (klass, sizeof (PDFWriterPrivate));
#line 4862 "book.c"
}


static void pdf_writer_instance_init (PDFWriter * self) {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->priv = PDF_WRITER_GET_PRIVATE (self);
#line 535 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->offset = (gsize) 0;
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->ref_count = 1;
#line 4873 "book.c"
}


static void pdf_writer_finalize (PDFWriter* obj) {
	PDFWriter * self;
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PDF_WRITER, PDFWriter);
#line 536 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_list_free0 (self->object_offsets);
#line 537 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_object_unref0 (self->priv->stream);
#line 4885 "book.c"
}


GType pdf_writer_get_type (void) {
	static volatile gsize pdf_writer_type_id__volatile = 0;
	if (g_once_init_enter (&pdf_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pdf_writer_init, value_pdf_writer_free_value, value_pdf_writer_copy_value, value_pdf_writer_peek_pointer, "p", value_pdf_writer_collect_value, "p", value_pdf_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PDFWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdf_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PDFWriter), 0, (GInstanceInitFunc) pdf_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pdf_writer_type_id;
		pdf_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PDFWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pdf_writer_type_id__volatile, pdf_writer_type_id);
	}
	return pdf_writer_type_id__volatile;
}


gpointer pdf_writer_ref (gpointer instance) {
	PDFWriter* self;
	self = instance;
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return instance;
#line 4910 "book.c"
}


void pdf_writer_unref (gpointer instance) {
	PDFWriter* self;
	self = instance;
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		PDF_WRITER_GET_CLASS (self)->finalize (self);
#line 533 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4923 "book.c"
	}
}


static cairo_status_t _ps_writer_write_cairo_data_cairo_write_func_t (gpointer self, guchar* data, int data_length1) {
	cairo_status_t result;
	result = ps_writer_write_cairo_data (self, data, data_length1);
#line 577 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 4933 "book.c"
}


PsWriter* ps_writer_construct (GType object_type, GFileOutputStream* stream) {
	PsWriter* self = NULL;
	GFileOutputStream* _tmp0_ = NULL;
	GFileOutputStream* _tmp1_ = NULL;
	cairo_surface_t* _tmp2_ = NULL;
#line 574 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (stream != NULL, NULL);
#line 574 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self = (PsWriter*) g_type_create_instance (object_type);
#line 576 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp0_ = stream;
#line 576 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 576 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_object_unref0 (self->stream);
#line 576 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->stream = _tmp1_;
#line 577 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_tmp2_ = cairo_ps_surface_create_for_stream (_ps_writer_write_cairo_data_cairo_write_func_t, self, (gdouble) 0, (gdouble) 0);
#line 577 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_cairo_surface_destroy0 (self->surface);
#line 577 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->surface = _tmp2_;
#line 574 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return self;
#line 4962 "book.c"
}


PsWriter* ps_writer_new (GFileOutputStream* stream) {
#line 574 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return ps_writer_construct (TYPE_PS_WRITER, stream);
#line 4969 "book.c"
}


static cairo_status_t ps_writer_write_cairo_data (PsWriter* self, guint8* data, int data_length1) {
	cairo_status_t result = 0;
	GError * _inner_error_ = NULL;
#line 580 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 4978 "book.c"
	{
		GFileOutputStream* _tmp0_ = NULL;
		guint8* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
#line 584 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp0_ = self->stream;
#line 584 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp1_ = data;
#line 584 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp1__length1 = data_length1;
#line 584 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
#line 584 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		if (_inner_error_ != NULL) {
#line 4993 "book.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 582 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		e = _inner_error_;
#line 582 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_inner_error_ = NULL;
#line 588 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp2_ = e;
#line 588 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_tmp3_ = _tmp2_->message;
#line 588 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_warning ("book.vala:588: Error writing data: %s", _tmp3_);
#line 589 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		result = CAIRO_STATUS_WRITE_ERROR;
#line 589 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		_g_error_free0 (e);
#line 589 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		return result;
#line 5019 "book.c"
	}
	__finally2:
#line 582 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (_inner_error_ != NULL) {
#line 582 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 582 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_clear_error (&_inner_error_);
#line 582 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		return 0;
#line 5030 "book.c"
	}
#line 592 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	result = CAIRO_STATUS_SUCCESS;
#line 592 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return result;
#line 5036 "book.c"
}


static void value_ps_writer_init (GValue* value) {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 5043 "book.c"
}


static void value_ps_writer_free_value (GValue* value) {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (value->data[0].v_pointer) {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		ps_writer_unref (value->data[0].v_pointer);
#line 5052 "book.c"
	}
}


static void value_ps_writer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		dest_value->data[0].v_pointer = ps_writer_ref (src_value->data[0].v_pointer);
#line 5062 "book.c"
	} else {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5066 "book.c"
	}
}


static gpointer value_ps_writer_peek_pointer (const GValue* value) {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return value->data[0].v_pointer;
#line 5074 "book.c"
}


static gchar* value_ps_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 5081 "book.c"
		PsWriter* object;
		object = collect_values[0].v_pointer;
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5088 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5092 "book.c"
		}
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = ps_writer_ref (object);
#line 5096 "book.c"
	} else {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5100 "book.c"
	}
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return NULL;
#line 5104 "book.c"
}


static gchar* value_ps_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PsWriter** object_p;
	object_p = collect_values[0].v_pointer;
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (!object_p) {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5115 "book.c"
	}
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		*object_p = NULL;
#line 5121 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 5125 "book.c"
	} else {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		*object_p = ps_writer_ref (value->data[0].v_pointer);
#line 5129 "book.c"
	}
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return NULL;
#line 5133 "book.c"
}


GParamSpec* param_spec_ps_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPsWriter* spec;
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PS_WRITER), NULL);
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 5147 "book.c"
}


gpointer value_get_ps_writer (const GValue* value) {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER), NULL);
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return value->data[0].v_pointer;
#line 5156 "book.c"
}


void value_set_ps_writer (GValue* value, gpointer v_object) {
	PsWriter* old;
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER));
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	old = value->data[0].v_pointer;
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (v_object) {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PS_WRITER));
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		ps_writer_ref (value->data[0].v_pointer);
#line 5176 "book.c"
	} else {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5180 "book.c"
	}
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (old) {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		ps_writer_unref (old);
#line 5186 "book.c"
	}
}


void value_take_ps_writer (GValue* value, gpointer v_object) {
	PsWriter* old;
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER));
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	old = value->data[0].v_pointer;
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (v_object) {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PS_WRITER));
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 5205 "book.c"
	} else {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5209 "book.c"
	}
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (old) {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		ps_writer_unref (old);
#line 5215 "book.c"
	}
}


static void ps_writer_class_init (PsWriterClass * klass) {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	ps_writer_parent_class = g_type_class_peek_parent (klass);
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	PS_WRITER_CLASS (klass)->finalize = ps_writer_finalize;
#line 5225 "book.c"
}


static void ps_writer_instance_init (PsWriter * self) {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self->ref_count = 1;
#line 5232 "book.c"
}


static void ps_writer_finalize (PsWriter* obj) {
	PsWriter * self;
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PS_WRITER, PsWriter);
#line 571 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_cairo_surface_destroy0 (self->surface);
#line 572 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	_g_object_unref0 (self->stream);
#line 5244 "book.c"
}


GType ps_writer_get_type (void) {
	static volatile gsize ps_writer_type_id__volatile = 0;
	if (g_once_init_enter (&ps_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_ps_writer_init, value_ps_writer_free_value, value_ps_writer_copy_value, value_ps_writer_peek_pointer, "p", value_ps_writer_collect_value, "p", value_ps_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PsWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ps_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PsWriter), 0, (GInstanceInitFunc) ps_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType ps_writer_type_id;
		ps_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PsWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&ps_writer_type_id__volatile, ps_writer_type_id);
	}
	return ps_writer_type_id__volatile;
}


gpointer ps_writer_ref (gpointer instance) {
	PsWriter* self;
	self = instance;
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	return instance;
#line 5269 "book.c"
}


void ps_writer_unref (gpointer instance) {
	PsWriter* self;
	self = instance;
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		PS_WRITER_GET_CLASS (self)->finalize (self);
#line 569 "/home/bob/bzr/simple-scan/3.10/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5282 "book.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



