/* simple-scan.c generated by valac 0.22.1, the Vala compiler
 * generated from simple-scan.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gudev/gudev.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gio/gio.h>
#include "colord.h"
#include <float.h>
#include <math.h>
#include "sane/sane.h"
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>


#define TYPE_SIMPLE_SCAN (simple_scan_get_type ())
#define SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIMPLE_SCAN, SimpleScan))
#define SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIMPLE_SCAN, SimpleScanClass))
#define IS_SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIMPLE_SCAN))
#define IS_SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIMPLE_SCAN))
#define SIMPLE_SCAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIMPLE_SCAN, SimpleScanClass))

typedef struct _SimpleScan SimpleScan;
typedef struct _SimpleScanClass SimpleScanClass;
typedef struct _SimpleScanPrivate SimpleScanPrivate;

#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;

#define TYPE_USER_INTERFACE (user_interface_get_type ())
#define USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_INTERFACE, UserInterface))
#define USER_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_INTERFACE, UserInterfaceClass))
#define IS_USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_INTERFACE))
#define IS_USER_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_INTERFACE))
#define USER_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_INTERFACE, UserInterfaceClass))

typedef struct _UserInterface UserInterface;
typedef struct _UserInterfaceClass UserInterfaceClass;

#define TYPE_SCANNER (scanner_get_type ())
#define SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCANNER, Scanner))
#define SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCANNER, ScannerClass))
#define IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCANNER))
#define IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCANNER))
#define SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCANNER, ScannerClass))

typedef struct _Scanner Scanner;
typedef struct _ScannerClass ScannerClass;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _user_interface_unref0(var) ((var == NULL) ? NULL : (var = (user_interface_unref (var), NULL)))
#define _scanner_unref0(var) ((var == NULL) ? NULL : (var = (scanner_unref (var), NULL)))
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;

#define TYPE_SCAN_LINE (scan_line_get_type ())
#define SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_LINE, ScanLine))
#define SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_LINE, ScanLineClass))
#define IS_SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_LINE))
#define IS_SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_LINE))
#define SCAN_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_LINE, ScanLineClass))

typedef struct _ScanLine ScanLine;
typedef struct _ScanLineClass ScanLineClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define __g_list_free__scan_device_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__scan_device_unref0_ (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;

#define TYPE_SCAN_MODE (scan_mode_get_type ())

#define TYPE_SCAN_TYPE (scan_type_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

struct _SimpleScan {
	GtkApplication parent_instance;
	SimpleScanPrivate * priv;
};

struct _SimpleScanClass {
	GtkApplicationClass parent_class;
};

struct _SimpleScanPrivate {
	ScanDevice* default_device;
	gboolean have_devices;
	GUdevClient* udev_client;
	UserInterface* ui;
	Scanner* scanner;
	Book* book;
};

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _ScanPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ScanPageInfo *self);
};

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
	gint brightness;
	gint contrast;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};


static gpointer simple_scan_parent_class = NULL;
static gboolean simple_scan_show_version;
static gboolean simple_scan_show_version = FALSE;
static gboolean simple_scan_debug_enabled;
static gboolean simple_scan_debug_enabled = FALSE;
static gchar* simple_scan_fix_pdf_filename;
static gchar* simple_scan_fix_pdf_filename = NULL;
static GTimer* simple_scan_log_timer;
static GTimer* simple_scan_log_timer = NULL;
static FILE* simple_scan_log_file;
static FILE* simple_scan_log_file = NULL;

GType simple_scan_get_type (void) G_GNUC_CONST;
gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_device (GValue* value, gpointer v_object);
void value_take_scan_device (GValue* value, gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
gpointer user_interface_ref (gpointer instance);
void user_interface_unref (gpointer instance);
GParamSpec* param_spec_user_interface (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_user_interface (GValue* value, gpointer v_object);
void value_take_user_interface (GValue* value, gpointer v_object);
gpointer value_get_user_interface (const GValue* value);
GType user_interface_get_type (void) G_GNUC_CONST;
gpointer scanner_ref (gpointer instance);
void scanner_unref (gpointer instance);
GParamSpec* param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scanner (GValue* value, gpointer v_object);
void value_take_scanner (GValue* value, gpointer v_object);
gpointer value_get_scanner (const GValue* value);
GType scanner_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
#define SIMPLE_SCAN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SIMPLE_SCAN, SimpleScanPrivate))
enum  {
	SIMPLE_SCAN_DUMMY_PROPERTY
};
SimpleScan* simple_scan_new (ScanDevice* device);
SimpleScan* simple_scan_construct (GType object_type, ScanDevice* device);
static void simple_scan_real_startup (GApplication* base);
UserInterface* user_interface_new (void);
UserInterface* user_interface_construct (GType object_type);
Book* user_interface_get_book (UserInterface* self);
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_options (GValue* value, gpointer v_object);
void value_take_scan_options (GValue* value, gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
static void simple_scan_scan_cb (SimpleScan* self, UserInterface* ui, const gchar* device, ScanOptions* options);
static void _simple_scan_scan_cb_user_interface_start_scan (UserInterface* _sender, const gchar* device, ScanOptions* options, gpointer self);
static void simple_scan_cancel_cb (SimpleScan* self, UserInterface* ui);
static void _simple_scan_cancel_cb_user_interface_stop_scan (UserInterface* _sender, gpointer self);
static void simple_scan_email_cb (SimpleScan* self, UserInterface* ui, const gchar* profile, gint quality);
static void _simple_scan_email_cb_user_interface_email (UserInterface* _sender, const gchar* profile, gint quality, gpointer self);
Scanner* scanner_get_instance (void);
static void simple_scan_update_scan_devices_cb (SimpleScan* self, Scanner* scanner, GList* devices);
static void _simple_scan_update_scan_devices_cb_scanner_update_devices (Scanner* _sender, GList* devices, gpointer self);
static void simple_scan_authorize_cb (SimpleScan* self, Scanner* scanner, const gchar* resource);
static void _simple_scan_authorize_cb_scanner_request_authorization (Scanner* _sender, const gchar* resource, gpointer self);
static void simple_scan_scanner_new_page_cb (SimpleScan* self, Scanner* scanner);
static void _simple_scan_scanner_new_page_cb_scanner_expect_page (Scanner* _sender, gpointer self);
gpointer scan_page_info_ref (gpointer instance);
void scan_page_info_unref (gpointer instance);
GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_page_info (GValue* value, gpointer v_object);
void value_take_scan_page_info (GValue* value, gpointer v_object);
gpointer value_get_scan_page_info (const GValue* value);
GType scan_page_info_get_type (void) G_GNUC_CONST;
static void simple_scan_scanner_page_info_cb (SimpleScan* self, Scanner* scanner, ScanPageInfo* info);
static void _simple_scan_scanner_page_info_cb_scanner_got_page_info (Scanner* _sender, ScanPageInfo* info, gpointer self);
gpointer scan_line_ref (gpointer instance);
void scan_line_unref (gpointer instance);
GParamSpec* param_spec_scan_line (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_line (GValue* value, gpointer v_object);
void value_take_scan_line (GValue* value, gpointer v_object);
gpointer value_get_scan_line (const GValue* value);
GType scan_line_get_type (void) G_GNUC_CONST;
static void simple_scan_scanner_line_cb (SimpleScan* self, Scanner* scanner, ScanLine* line);
static void _simple_scan_scanner_line_cb_scanner_got_line (Scanner* _sender, ScanLine* line, gpointer self);
static void simple_scan_scanner_page_done_cb (SimpleScan* self, Scanner* scanner);
static void _simple_scan_scanner_page_done_cb_scanner_page_done (Scanner* _sender, gpointer self);
static void simple_scan_scanner_document_done_cb (SimpleScan* self, Scanner* scanner);
static void _simple_scan_scanner_document_done_cb_scanner_document_done (Scanner* _sender, gpointer self);
static void simple_scan_scanner_failed_cb (SimpleScan* self, Scanner* scanner, gint error_code, const gchar* error_string);
static void _simple_scan_scanner_failed_cb_scanner_scan_failed (Scanner* _sender, gint error_code, const gchar* error_string, gpointer self);
static void simple_scan_scanner_scanning_changed_cb (SimpleScan* self, Scanner* scanner);
static void _simple_scan_scanner_scanning_changed_cb_scanner_scanning_changed (Scanner* _sender, gpointer self);
static void simple_scan_on_uevent (SimpleScan* self, GUdevClient* client, const gchar* action, GUdevDevice* device);
static void _simple_scan_on_uevent_g_udev_client_uevent (GUdevClient* _sender, const gchar* action, GUdevDevice* device, gpointer self);
void user_interface_set_scan_devices (UserInterface* self, GList* devices);
void user_interface_set_selected_device (UserInterface* self, const gchar* device);
static void _scan_device_unref0_ (gpointer var);
static void _g_list_free__scan_device_unref0_ (GList* self);
static void simple_scan_real_activate (GApplication* base);
void user_interface_start (UserInterface* self);
void scanner_start (Scanner* self);
static void simple_scan_real_shutdown (GApplication* base);
void scanner_free (Scanner* self);
void user_interface_authorize (UserInterface* self, const gchar* resource, gchar** username, gchar** password);
void scanner_authorize (Scanner* self, const gchar* username, const gchar* password);
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
static Page* simple_scan_append_page (SimpleScan* self);
Page* book_get_page (Book* self, gint page_number);
gboolean page_has_data (Page* self);
void user_interface_set_selected_page (UserInterface* self, Page* page);
void page_start (Page* self);
GType scan_direction_get_type (void) G_GNUC_CONST;
ScanDirection page_get_scan_direction (Page* self);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
gint page_get_dpi (Page* self);
gboolean page_has_crop (Page* self);
gchar* page_get_named_crop (Page* self);
void page_get_crop (Page* self, gint* x, gint* y, gint* width, gint* height);
Page* page_new (gint width, gint height, gint dpi, ScanDirection scan_direction);
Page* page_construct (GType object_type, gint width, gint height, gint dpi, ScanDirection scan_direction);
void book_append_page (Book* self, Page* page);
void page_set_named_crop (Page* self, const gchar* name);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_move_crop (Page* self, gint x, gint y);
static gchar* simple_scan_get_profile_for_device (SimpleScan* self, const gchar* device_name);
void page_set_page_info (Page* self, ScanPageInfo* info);
void page_set_color_profile (Page* self, const gchar* color_profile);
guint book_get_n_pages (Book* self);
void page_parse_scan_line (Page* self, ScanLine* line);
void page_finish (Page* self);
static void simple_scan_remove_empty_page (SimpleScan* self);
void book_delete_page (Book* self, Page* page);
void user_interface_show_error (UserInterface* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint);
void user_interface_set_scanning (UserInterface* self, gboolean scanning);
gboolean scanner_is_scanning (Scanner* self);
GType scan_mode_get_type (void) G_GNUC_CONST;
GType scan_type_get_type (void) G_GNUC_CONST;
void user_interface_set_default_file_name (UserInterface* self, const gchar* default_file_name);
void scanner_scan (Scanner* self, const gchar* device, ScanOptions* options);
void scanner_cancel (Scanner* self);
static gchar* simple_scan_get_temporary_filename (SimpleScan* self, const gchar* prefix, const gchar* extension);
void user_interface_show_progress_dialog (UserInterface* self);
void book_save (Book* self, const gchar* type, gint quality, GFile* file, GError** error);
void user_interface_hide_progress_dialog (UserInterface* self);
void page_save (Page* self, const gchar* type, gint quality, GFile* file, GError** error);
static void simple_scan_log_cb (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message);
void scanner_redetect (Scanner* self);
static void simple_scan_fix_pdf (const gchar* filename, GError** error);
gint simple_scan_main (gchar** args, int args_length1);
ScanDevice* scan_device_new (void);
ScanDevice* scan_device_construct (GType object_type);
static void _simple_scan_log_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static void simple_scan_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const GOptionEntry SIMPLE_SCAN_options[4] = {{"version", 'v', 0, G_OPTION_ARG_NONE, &simple_scan_show_version, "Show release version", NULL}, {"debug", 'd', 0, G_OPTION_ARG_NONE, &simple_scan_debug_enabled, "Print debugging messages", NULL}, {"fix-pdf", (gchar) 0, 0, G_OPTION_ARG_STRING, &simple_scan_fix_pdf_filename, "Fix PDF files generated with older versions of Simple Scan", "FILENAME..."}, {NULL}};

static gpointer _scan_device_ref0 (gpointer self) {
#line 41 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	return self ? scan_device_ref (self) : NULL;
#line 410 "simple-scan.c"
}


SimpleScan* simple_scan_construct (GType object_type, ScanDevice* device) {
	SimpleScan * self = NULL;
	ScanDevice* _tmp0_ = NULL;
	ScanDevice* _tmp1_ = NULL;
#line 39 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	self = (SimpleScan*) g_object_new (object_type, NULL);
#line 41 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp0_ = device;
#line 41 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp1_ = _scan_device_ref0 (_tmp0_);
#line 41 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_scan_device_unref0 (self->priv->default_device);
#line 41 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	self->priv->default_device = _tmp1_;
#line 39 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	return self;
#line 430 "simple-scan.c"
}


SimpleScan* simple_scan_new (ScanDevice* device) {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	return simple_scan_construct (TYPE_SIMPLE_SCAN, device);
#line 437 "simple-scan.c"
}


static void _simple_scan_scan_cb_user_interface_start_scan (UserInterface* _sender, const gchar* device, ScanOptions* options, gpointer self) {
#line 50 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	simple_scan_scan_cb (self, _sender, device, options);
#line 444 "simple-scan.c"
}


static void _simple_scan_cancel_cb_user_interface_stop_scan (UserInterface* _sender, gpointer self) {
#line 51 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	simple_scan_cancel_cb (self, _sender);
#line 451 "simple-scan.c"
}


static void _simple_scan_email_cb_user_interface_email (UserInterface* _sender, const gchar* profile, gint quality, gpointer self) {
#line 52 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	simple_scan_email_cb (self, _sender, profile, quality);
#line 458 "simple-scan.c"
}


static void _simple_scan_update_scan_devices_cb_scanner_update_devices (Scanner* _sender, GList* devices, gpointer self) {
#line 55 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	simple_scan_update_scan_devices_cb (self, _sender, devices);
#line 465 "simple-scan.c"
}


static void _simple_scan_authorize_cb_scanner_request_authorization (Scanner* _sender, const gchar* resource, gpointer self) {
#line 56 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	simple_scan_authorize_cb (self, _sender, resource);
#line 472 "simple-scan.c"
}


static void _simple_scan_scanner_new_page_cb_scanner_expect_page (Scanner* _sender, gpointer self) {
#line 57 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	simple_scan_scanner_new_page_cb (self, _sender);
#line 479 "simple-scan.c"
}


static void _simple_scan_scanner_page_info_cb_scanner_got_page_info (Scanner* _sender, ScanPageInfo* info, gpointer self) {
#line 58 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	simple_scan_scanner_page_info_cb (self, _sender, info);
#line 486 "simple-scan.c"
}


static void _simple_scan_scanner_line_cb_scanner_got_line (Scanner* _sender, ScanLine* line, gpointer self) {
#line 59 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	simple_scan_scanner_line_cb (self, _sender, line);
#line 493 "simple-scan.c"
}


static void _simple_scan_scanner_page_done_cb_scanner_page_done (Scanner* _sender, gpointer self) {
#line 60 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	simple_scan_scanner_page_done_cb (self, _sender);
#line 500 "simple-scan.c"
}


static void _simple_scan_scanner_document_done_cb_scanner_document_done (Scanner* _sender, gpointer self) {
#line 61 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	simple_scan_scanner_document_done_cb (self, _sender);
#line 507 "simple-scan.c"
}


static void _simple_scan_scanner_failed_cb_scanner_scan_failed (Scanner* _sender, gint error_code, const gchar* error_string, gpointer self) {
#line 62 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	simple_scan_scanner_failed_cb (self, _sender, error_code, error_string);
#line 514 "simple-scan.c"
}


static void _simple_scan_scanner_scanning_changed_cb_scanner_scanning_changed (Scanner* _sender, gpointer self) {
#line 63 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	simple_scan_scanner_scanning_changed_cb (self, _sender);
#line 521 "simple-scan.c"
}


static void _simple_scan_on_uevent_g_udev_client_uevent (GUdevClient* _sender, const gchar* action, GUdevDevice* device, gpointer self) {
#line 67 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	simple_scan_on_uevent (self, _sender, action, device);
#line 528 "simple-scan.c"
}


static void _scan_device_unref0_ (gpointer var) {
#line 69 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	(var == NULL) ? NULL : (var = (scan_device_unref (var), NULL));
#line 535 "simple-scan.c"
}


static void _g_list_free__scan_device_unref0_ (GList* self) {
#line 69 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_list_foreach (self, (GFunc) _scan_device_unref0_, NULL);
#line 69 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_list_free (self);
#line 544 "simple-scan.c"
}


static void simple_scan_real_startup (GApplication* base) {
	SimpleScan * self;
	UserInterface* _tmp0_ = NULL;
	UserInterface* _tmp1_ = NULL;
	Book* _tmp2_ = NULL;
	UserInterface* _tmp3_ = NULL;
	UserInterface* _tmp4_ = NULL;
	UserInterface* _tmp5_ = NULL;
	Scanner* _tmp6_ = NULL;
	Scanner* _tmp7_ = NULL;
	Scanner* _tmp8_ = NULL;
	Scanner* _tmp9_ = NULL;
	Scanner* _tmp10_ = NULL;
	Scanner* _tmp11_ = NULL;
	Scanner* _tmp12_ = NULL;
	Scanner* _tmp13_ = NULL;
	Scanner* _tmp14_ = NULL;
	Scanner* _tmp15_ = NULL;
	gchar** subsystems = NULL;
	gchar* _tmp16_ = NULL;
	gchar** _tmp17_ = NULL;
	gint subsystems_length1 = 0;
	gint _subsystems_size_ = 0;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	GUdevClient* _tmp19_ = NULL;
	GUdevClient* _tmp20_ = NULL;
	ScanDevice* _tmp21_ = NULL;
#line 44 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	self = (SimpleScan*) base;
#line 46 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	G_APPLICATION_CLASS (simple_scan_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
#line 48 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp0_ = user_interface_new ();
#line 48 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_user_interface_unref0 (self->priv->ui);
#line 48 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	self->priv->ui = _tmp0_;
#line 49 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp1_ = self->priv->ui;
#line 49 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp2_ = user_interface_get_book (_tmp1_);
#line 49 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_book_unref0 (self->priv->book);
#line 49 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	self->priv->book = _tmp2_;
#line 50 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp3_ = self->priv->ui;
#line 50 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_signal_connect_object (_tmp3_, "start-scan", (GCallback) _simple_scan_scan_cb_user_interface_start_scan, self, 0);
#line 51 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp4_ = self->priv->ui;
#line 51 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_signal_connect_object (_tmp4_, "stop-scan", (GCallback) _simple_scan_cancel_cb_user_interface_stop_scan, self, 0);
#line 52 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp5_ = self->priv->ui;
#line 52 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_signal_connect_object (_tmp5_, "email", (GCallback) _simple_scan_email_cb_user_interface_email, self, 0);
#line 54 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp6_ = scanner_get_instance ();
#line 54 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_scanner_unref0 (self->priv->scanner);
#line 54 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	self->priv->scanner = _tmp6_;
#line 55 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp7_ = self->priv->scanner;
#line 55 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_signal_connect_object (_tmp7_, "update-devices", (GCallback) _simple_scan_update_scan_devices_cb_scanner_update_devices, self, 0);
#line 56 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp8_ = self->priv->scanner;
#line 56 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_signal_connect_object (_tmp8_, "request-authorization", (GCallback) _simple_scan_authorize_cb_scanner_request_authorization, self, 0);
#line 57 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp9_ = self->priv->scanner;
#line 57 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_signal_connect_object (_tmp9_, "expect-page", (GCallback) _simple_scan_scanner_new_page_cb_scanner_expect_page, self, 0);
#line 58 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp10_ = self->priv->scanner;
#line 58 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_signal_connect_object (_tmp10_, "got-page-info", (GCallback) _simple_scan_scanner_page_info_cb_scanner_got_page_info, self, 0);
#line 59 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp11_ = self->priv->scanner;
#line 59 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_signal_connect_object (_tmp11_, "got-line", (GCallback) _simple_scan_scanner_line_cb_scanner_got_line, self, 0);
#line 60 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp12_ = self->priv->scanner;
#line 60 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_signal_connect_object (_tmp12_, "page-done", (GCallback) _simple_scan_scanner_page_done_cb_scanner_page_done, self, 0);
#line 61 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp13_ = self->priv->scanner;
#line 61 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_signal_connect_object (_tmp13_, "document-done", (GCallback) _simple_scan_scanner_document_done_cb_scanner_document_done, self, 0);
#line 62 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp14_ = self->priv->scanner;
#line 62 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_signal_connect_object (_tmp14_, "scan-failed", (GCallback) _simple_scan_scanner_failed_cb_scanner_scan_failed, self, 0);
#line 63 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp15_ = self->priv->scanner;
#line 63 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_signal_connect_object (_tmp15_, "scanning-changed", (GCallback) _simple_scan_scanner_scanning_changed_cb_scanner_scanning_changed, self, 0);
#line 65 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp16_ = g_strdup ("usb");
#line 65 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp17_ = g_new0 (gchar*, 2 + 1);
#line 65 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp17_[0] = _tmp16_;
#line 65 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp17_[1] = NULL;
#line 65 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	subsystems = _tmp17_;
#line 65 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	subsystems_length1 = 2;
#line 65 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_subsystems_size_ = subsystems_length1;
#line 66 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp18_ = subsystems;
#line 66 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp18__length1 = subsystems_length1;
#line 66 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp19_ = g_udev_client_new (_tmp18_);
#line 66 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_object_unref0 (self->priv->udev_client);
#line 66 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	self->priv->udev_client = _tmp19_;
#line 67 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp20_ = self->priv->udev_client;
#line 67 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_signal_connect_object (_tmp20_, "uevent", (GCallback) _simple_scan_on_uevent_g_udev_client_uevent, self, 0);
#line 69 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp21_ = self->priv->default_device;
#line 69 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (_tmp21_ != NULL) {
#line 680 "simple-scan.c"
		GList* device_list = NULL;
		ScanDevice* _tmp22_ = NULL;
		ScanDevice* _tmp23_ = NULL;
		UserInterface* _tmp24_ = NULL;
		GList* _tmp25_ = NULL;
		UserInterface* _tmp26_ = NULL;
		ScanDevice* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
#line 71 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		device_list = NULL;
#line 73 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp22_ = self->priv->default_device;
#line 73 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp23_ = _scan_device_ref0 (_tmp22_);
#line 73 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		device_list = g_list_append (device_list, _tmp23_);
#line 74 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp24_ = self->priv->ui;
#line 74 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp25_ = device_list;
#line 74 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		user_interface_set_scan_devices (_tmp24_, _tmp25_);
#line 75 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp26_ = self->priv->ui;
#line 75 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp27_ = self->priv->default_device;
#line 75 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp28_ = _tmp27_->name;
#line 75 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		user_interface_set_selected_device (_tmp26_, _tmp28_);
#line 69 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		__g_list_free__scan_device_unref0_0 (device_list);
#line 713 "simple-scan.c"
	}
#line 44 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	subsystems = (_vala_array_free (subsystems, subsystems_length1, (GDestroyNotify) g_free), NULL);
#line 717 "simple-scan.c"
}


static void simple_scan_real_activate (GApplication* base) {
	SimpleScan * self;
	UserInterface* _tmp0_ = NULL;
	Scanner* _tmp1_ = NULL;
#line 79 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	self = (SimpleScan*) base;
#line 81 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	G_APPLICATION_CLASS (simple_scan_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
#line 82 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp0_ = self->priv->ui;
#line 82 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	user_interface_start (_tmp0_);
#line 83 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp1_ = self->priv->scanner;
#line 83 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	scanner_start (_tmp1_);
#line 737 "simple-scan.c"
}


static void simple_scan_real_shutdown (GApplication* base) {
	SimpleScan * self;
	Scanner* _tmp0_ = NULL;
#line 86 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	self = (SimpleScan*) base;
#line 88 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	G_APPLICATION_CLASS (simple_scan_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
#line 89 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_book_unref0 (self->priv->book);
#line 89 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	self->priv->book = NULL;
#line 90 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_user_interface_unref0 (self->priv->ui);
#line 90 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	self->priv->ui = NULL;
#line 91 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_object_unref0 (self->priv->udev_client);
#line 91 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	self->priv->udev_client = NULL;
#line 92 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp0_ = self->priv->scanner;
#line 92 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	scanner_free (_tmp0_);
#line 764 "simple-scan.c"
}


static void simple_scan_update_scan_devices_cb (SimpleScan* self, Scanner* scanner, GList* devices) {
	GList* devices_copy = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	ScanDevice* _tmp2_ = NULL;
	GList* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	UserInterface* _tmp12_ = NULL;
	GList* _tmp13_ = NULL;
#line 95 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 95 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 97 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp0_ = devices;
#line 97 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp1_ = g_list_copy (_tmp0_);
#line 97 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	devices_copy = _tmp1_;
#line 100 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp2_ = self->priv->default_device;
#line 100 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (_tmp2_ != NULL) {
#line 791 "simple-scan.c"
		gboolean default_in_list = FALSE;
		GList* _tmp3_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 102 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		default_in_list = FALSE;
#line 103 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp3_ = devices_copy;
#line 799 "simple-scan.c"
		{
			GList* device_collection = NULL;
			GList* device_it = NULL;
#line 103 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			device_collection = _tmp3_;
#line 103 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
#line 807 "simple-scan.c"
				ScanDevice* device = NULL;
#line 103 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				device = (ScanDevice*) device_it->data;
#line 811 "simple-scan.c"
				{
					ScanDevice* _tmp4_ = NULL;
					const gchar* _tmp5_ = NULL;
					ScanDevice* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
#line 105 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp4_ = device;
#line 105 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp5_ = _tmp4_->name;
#line 105 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp6_ = self->priv->default_device;
#line 105 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp7_ = _tmp6_->name;
#line 105 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					if (g_strcmp0 (_tmp5_, _tmp7_) == 0) {
#line 107 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						default_in_list = TRUE;
#line 108 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						break;
#line 831 "simple-scan.c"
					}
				}
			}
		}
#line 112 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp8_ = default_in_list;
#line 112 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		if (!_tmp8_) {
#line 840 "simple-scan.c"
			ScanDevice* _tmp9_ = NULL;
#line 113 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp9_ = self->priv->default_device;
#line 113 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			devices_copy = g_list_prepend (devices_copy, _tmp9_);
#line 846 "simple-scan.c"
		}
	}
#line 116 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp10_ = devices_copy;
#line 116 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp11_ = g_list_length (_tmp10_);
#line 116 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	self->priv->have_devices = _tmp11_ > ((guint) 0);
#line 117 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp12_ = self->priv->ui;
#line 117 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp13_ = devices_copy;
#line 117 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	user_interface_set_scan_devices (_tmp12_, _tmp13_);
#line 95 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_list_free0 (devices_copy);
#line 863 "simple-scan.c"
}


static void simple_scan_authorize_cb (SimpleScan* self, Scanner* scanner, const gchar* resource) {
	gchar* username = NULL;
	gchar* password = NULL;
	UserInterface* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	Scanner* _tmp4_ = NULL;
#line 120 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 120 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 120 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (resource != NULL);
#line 123 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp0_ = self->priv->ui;
#line 123 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp1_ = resource;
#line 123 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	user_interface_authorize (_tmp0_, _tmp1_, &_tmp2_, &_tmp3_);
#line 123 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_free0 (username);
#line 123 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	username = _tmp2_;
#line 123 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_free0 (password);
#line 123 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	password = _tmp3_;
#line 124 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp4_ = scanner;
#line 124 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	scanner_authorize (_tmp4_, username, password);
#line 120 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_free0 (password);
#line 120 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_free0 (username);
#line 903 "simple-scan.c"
}


static Page* simple_scan_append_page (SimpleScan* self) {
	Page* result = NULL;
	Page* page = NULL;
	Book* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Page* _tmp3_ = NULL;
	gboolean _tmp6_ = FALSE;
	ScanDirection scan_direction = 0;
	gboolean do_crop = FALSE;
	gchar* named_crop = NULL;
	gint width = 0;
	gint height = 0;
	gint dpi = 0;
	gint cx = 0;
	gint cy = 0;
	gint cw = 0;
	gint ch = 0;
	Page* _tmp10_ = NULL;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	ScanDirection _tmp32_ = 0;
	Page* _tmp33_ = NULL;
	Book* _tmp34_ = NULL;
	Page* _tmp35_ = NULL;
	gboolean _tmp36_ = FALSE;
	UserInterface* _tmp46_ = NULL;
	Page* _tmp47_ = NULL;
	Page* _tmp48_ = NULL;
#line 127 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 130 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp0_ = self->priv->book;
#line 130 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp1_ = book_get_page (_tmp0_, -1);
#line 130 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	page = _tmp1_;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp3_ = page;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (_tmp3_ != NULL) {
#line 949 "simple-scan.c"
		Page* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp4_ = page;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp5_ = page_has_data (_tmp4_);
#line 131 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp2_ = !_tmp5_;
#line 958 "simple-scan.c"
	} else {
#line 131 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp2_ = FALSE;
#line 962 "simple-scan.c"
	}
#line 131 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp6_ = _tmp2_;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (_tmp6_) {
#line 968 "simple-scan.c"
		UserInterface* _tmp7_ = NULL;
		Page* _tmp8_ = NULL;
		Page* _tmp9_ = NULL;
#line 133 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp7_ = self->priv->ui;
#line 133 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp8_ = page;
#line 133 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		user_interface_set_selected_page (_tmp7_, _tmp8_);
#line 134 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp9_ = page;
#line 134 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		page_start (_tmp9_);
#line 135 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		result = page;
#line 135 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		return result;
#line 986 "simple-scan.c"
	}
#line 139 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
#line 140 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	do_crop = FALSE;
#line 141 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	named_crop = NULL;
#line 142 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	width = 100;
#line 142 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	height = 100;
#line 142 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	dpi = 100;
#line 142 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	cx = 0;
#line 142 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	cy = 0;
#line 142 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	cw = 0;
#line 142 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	ch = 0;
#line 143 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp10_ = page;
#line 143 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (_tmp10_ != NULL) {
#line 1012 "simple-scan.c"
		Page* _tmp11_ = NULL;
		ScanDirection _tmp12_ = 0;
		Page* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		Page* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		Page* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		Page* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
#line 145 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp11_ = page;
#line 145 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp12_ = page_get_scan_direction (_tmp11_);
#line 145 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		scan_direction = _tmp12_;
#line 146 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp13_ = page;
#line 146 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp14_ = page_get_width (_tmp13_);
#line 146 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		width = _tmp14_;
#line 147 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp15_ = page;
#line 147 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp16_ = page_get_height (_tmp15_);
#line 147 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		height = _tmp16_;
#line 148 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp17_ = page;
#line 148 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp18_ = page_get_dpi (_tmp17_);
#line 148 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		dpi = _tmp18_;
#line 150 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp19_ = page;
#line 150 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp20_ = page_has_crop (_tmp19_);
#line 150 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		do_crop = _tmp20_;
#line 151 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp21_ = do_crop;
#line 151 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		if (_tmp21_) {
#line 1058 "simple-scan.c"
			Page* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			Page* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
#line 153 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp22_ = page;
#line 153 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp23_ = page_get_named_crop (_tmp22_);
#line 153 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_g_free0 (named_crop);
#line 153 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			named_crop = _tmp23_;
#line 154 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp24_ = page;
#line 154 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			page_get_crop (_tmp24_, &_tmp25_, &_tmp26_, &_tmp27_, &_tmp28_);
#line 154 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			cx = _tmp25_;
#line 154 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			cy = _tmp26_;
#line 154 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			cw = _tmp27_;
#line 154 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			ch = _tmp28_;
#line 1086 "simple-scan.c"
		}
	}
#line 158 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp29_ = width;
#line 158 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp30_ = height;
#line 158 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp31_ = dpi;
#line 158 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp32_ = scan_direction;
#line 158 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp33_ = page_new (_tmp29_, _tmp30_, _tmp31_, _tmp32_);
#line 158 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_page_unref0 (page);
#line 158 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	page = _tmp33_;
#line 159 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp34_ = self->priv->book;
#line 159 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp35_ = page;
#line 159 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	book_append_page (_tmp34_, _tmp35_);
#line 160 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp36_ = do_crop;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (_tmp36_) {
#line 1113 "simple-scan.c"
		const gchar* _tmp37_ = NULL;
		Page* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
#line 162 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp37_ = named_crop;
#line 162 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		if (_tmp37_ != NULL) {
#line 1122 "simple-scan.c"
			Page* _tmp38_ = NULL;
			const gchar* _tmp39_ = NULL;
#line 164 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp38_ = page;
#line 164 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp39_ = named_crop;
#line 164 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			page_set_named_crop (_tmp38_, _tmp39_);
#line 1131 "simple-scan.c"
		} else {
			Page* _tmp40_ = NULL;
			gint _tmp41_ = 0;
			gint _tmp42_ = 0;
#line 167 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp40_ = page;
#line 167 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp41_ = cw;
#line 167 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp42_ = ch;
#line 167 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			page_set_custom_crop (_tmp40_, _tmp41_, _tmp42_);
#line 1144 "simple-scan.c"
		}
#line 168 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp43_ = page;
#line 168 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp44_ = cx;
#line 168 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp45_ = cy;
#line 168 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		page_move_crop (_tmp43_, _tmp44_, _tmp45_);
#line 1154 "simple-scan.c"
	}
#line 170 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp46_ = self->priv->ui;
#line 170 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp47_ = page;
#line 170 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	user_interface_set_selected_page (_tmp46_, _tmp47_);
#line 171 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp48_ = page;
#line 171 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	page_start (_tmp48_);
#line 173 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	result = page;
#line 173 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_free0 (named_crop);
#line 173 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	return result;
#line 1172 "simple-scan.c"
}


static void simple_scan_scanner_new_page_cb (SimpleScan* self, Scanner* scanner) {
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
#line 176 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 176 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 178 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp0_ = simple_scan_append_page (self);
#line 178 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp1_ = _tmp0_;
#line 178 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_page_unref0 (_tmp1_);
#line 1189 "simple-scan.c"
}


static gchar* simple_scan_get_profile_for_device (SimpleScan* self, const gchar* device_name) {
	gchar* result = NULL;
	gchar* device_id = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	CdClient* client = NULL;
	CdClient* _tmp3_ = NULL;
	CdDevice* device = NULL;
	CdProfile* profile = NULL;
	CdDevice* _tmp18_ = NULL;
	CdProfile* _tmp19_ = NULL;
	CdProfile* _tmp20_ = NULL;
	CdProfile* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	CdProfile* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	CdProfile* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	GError * _inner_error_ = NULL;
#line 181 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 181 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_val_if_fail (device_name != NULL, NULL);
#line 184 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp0_ = device_name;
#line 184 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp1_ = g_strdup_printf ("sane:%s", _tmp0_);
#line 184 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	device_id = _tmp1_;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp2_ = device_name;
#line 185 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_debug ("simple-scan.vala:185: Getting color profile for device %s", _tmp2_);
#line 187 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp3_ = cd_client_new ();
#line 187 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	client = _tmp3_;
#line 1236 "simple-scan.c"
	{
		CdClient* _tmp4_ = NULL;
#line 190 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp4_ = client;
#line 190 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		cd_client_connect_sync (_tmp4_, NULL, &_inner_error_);
#line 190 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 1245 "simple-scan.c"
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 188 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		e = _inner_error_;
#line 188 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 194 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp5_ = e;
#line 194 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp6_ = _tmp5_->message;
#line 194 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_debug ("simple-scan.vala:194: Failed to connect to colord: %s", _tmp6_);
#line 195 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		result = NULL;
#line 195 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_error_free0 (e);
#line 195 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 195 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_free0 (device_id);
#line 195 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		return result;
#line 1275 "simple-scan.c"
	}
	__finally4:
#line 188 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 188 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 188 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_free0 (device_id);
#line 188 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 188 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 188 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		return NULL;
#line 1290 "simple-scan.c"
	}
	{
		CdDevice* _tmp7_ = NULL;
		CdClient* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		CdDevice* _tmp10_ = NULL;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp8_ = client;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp9_ = device_id;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp10_ = cd_client_find_device_by_property_sync (_tmp8_, CD_DEVICE_PROPERTY_SERIAL, _tmp9_, NULL, &_inner_error_);
#line 201 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp7_ = _tmp10_;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 1307 "simple-scan.c"
			goto __catch5_g_error;
		}
#line 201 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 201 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		device = _tmp7_;
#line 1314 "simple-scan.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp11_ = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
#line 199 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		e = _inner_error_;
#line 199 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 205 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp11_ = device_name;
#line 205 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp12_ = e;
#line 205 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp13_ = _tmp12_->message;
#line 205 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_debug ("simple-scan.vala:205: Unable to find colord device %s: %s", _tmp11_, _tmp13_);
#line 206 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		result = NULL;
#line 206 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_error_free0 (e);
#line 206 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 206 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 206 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_free0 (device_id);
#line 206 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		return result;
#line 1347 "simple-scan.c"
	}
	__finally5:
#line 199 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 199 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 199 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 199 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_free0 (device_id);
#line 199 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 199 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 199 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		return NULL;
#line 1364 "simple-scan.c"
	}
	{
		CdDevice* _tmp14_ = NULL;
#line 211 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp14_ = device;
#line 211 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		cd_device_connect_sync (_tmp14_, NULL, &_inner_error_);
#line 211 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 1374 "simple-scan.c"
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
#line 209 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		e = _inner_error_;
#line 209 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 215 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp15_ = device_name;
#line 215 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp16_ = e;
#line 215 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp17_ = _tmp16_->message;
#line 215 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_debug ("simple-scan.vala:215: Failed to get properties from the device %s: %s", _tmp15_, _tmp17_);
#line 216 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		result = NULL;
#line 216 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_error_free0 (e);
#line 216 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 216 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 216 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_free0 (device_id);
#line 216 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		return result;
#line 1409 "simple-scan.c"
	}
	__finally6:
#line 209 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 209 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 209 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 209 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_free0 (device_id);
#line 209 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 209 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 209 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		return NULL;
#line 1426 "simple-scan.c"
	}
#line 219 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp18_ = device;
#line 219 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp19_ = cd_device_get_default_profile (_tmp18_);
#line 219 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	profile = _tmp19_;
#line 220 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp20_ = profile;
#line 220 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (_tmp20_ == NULL) {
#line 1438 "simple-scan.c"
		const gchar* _tmp21_ = NULL;
#line 222 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp21_ = device_name;
#line 222 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_debug ("simple-scan.vala:222: No default color profile for device: %s", _tmp21_);
#line 223 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		result = NULL;
#line 223 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_object_unref0 (profile);
#line 223 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 223 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 223 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_free0 (device_id);
#line 223 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		return result;
#line 1456 "simple-scan.c"
	}
	{
		CdProfile* _tmp22_ = NULL;
#line 228 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp22_ = profile;
#line 228 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		cd_profile_connect_sync (_tmp22_, NULL, &_inner_error_);
#line 228 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 1466 "simple-scan.c"
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp23_ = NULL;
		GError* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
#line 226 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		e = _inner_error_;
#line 226 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 232 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp23_ = device_name;
#line 232 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp24_ = e;
#line 232 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp25_ = _tmp24_->message;
#line 232 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_debug ("simple-scan.vala:232: Failed to get properties from the profile %s: %s", _tmp23_, _tmp25_);
#line 233 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		result = NULL;
#line 233 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_error_free0 (e);
#line 233 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_object_unref0 (profile);
#line 233 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 233 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 233 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_free0 (device_id);
#line 233 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		return result;
#line 1503 "simple-scan.c"
	}
	__finally7:
#line 226 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 226 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_object_unref0 (profile);
#line 226 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 226 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 226 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_free0 (device_id);
#line 226 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 226 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 226 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		return NULL;
#line 1522 "simple-scan.c"
	}
#line 236 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp26_ = profile;
#line 236 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp27_ = cd_profile_get_filename (_tmp26_);
#line 236 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp28_ = _tmp27_;
#line 236 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (_tmp28_ == NULL) {
#line 1532 "simple-scan.c"
		const gchar* _tmp29_ = NULL;
#line 238 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp29_ = device_name;
#line 238 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_debug ("simple-scan.vala:238: No icc color profile for the device %s", _tmp29_);
#line 239 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		result = NULL;
#line 239 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_object_unref0 (profile);
#line 239 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 239 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 239 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_free0 (device_id);
#line 239 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		return result;
#line 1550 "simple-scan.c"
	}
#line 242 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp30_ = profile;
#line 242 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp31_ = cd_profile_get_filename (_tmp30_);
#line 242 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp32_ = _tmp31_;
#line 242 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp33_ = device_name;
#line 242 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_debug ("simple-scan.vala:242: Using color profile %s for device %s", _tmp32_, _tmp33_);
#line 243 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp34_ = profile;
#line 243 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp35_ = cd_profile_get_filename (_tmp34_);
#line 243 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp36_ = _tmp35_;
#line 243 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp37_ = g_strdup (_tmp36_);
#line 243 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	result = _tmp37_;
#line 243 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_object_unref0 (profile);
#line 243 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_object_unref0 (device);
#line 243 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_object_unref0 (client);
#line 243 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_free0 (device_id);
#line 243 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	return result;
#line 1582 "simple-scan.c"
}


static void simple_scan_scanner_page_info_cb (SimpleScan* self, Scanner* scanner, ScanPageInfo* info) {
	ScanPageInfo* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	ScanPageInfo* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	ScanPageInfo* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	Page* page = NULL;
	Page* _tmp6_ = NULL;
	ScanPageInfo* _tmp7_ = NULL;
	ScanPageInfo* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
#line 249 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 249 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 249 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (info != NULL);
#line 251 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp0_ = info;
#line 251 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp1_ = _tmp0_->width;
#line 251 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp2_ = info;
#line 251 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp3_ = _tmp2_->height;
#line 251 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp4_ = info;
#line 251 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp5_ = _tmp4_->depth;
#line 251 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_debug ("simple-scan.vala:251: Page is %d pixels wide, %d pixels high, %d bits " \
"per pixel", _tmp1_, _tmp3_, _tmp5_);
#line 255 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp6_ = simple_scan_append_page (self);
#line 255 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	page = _tmp6_;
#line 256 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp7_ = info;
#line 256 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	page_set_page_info (page, _tmp7_);
#line 261 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp8_ = info;
#line 261 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp9_ = _tmp8_->device;
#line 261 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp10_ = simple_scan_get_profile_for_device (self, _tmp9_);
#line 261 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp11_ = _tmp10_;
#line 261 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	page_set_color_profile (page, _tmp11_);
#line 261 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_free0 (_tmp11_);
#line 249 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_page_unref0 (page);
#line 1642 "simple-scan.c"
}


static void simple_scan_scanner_line_cb (SimpleScan* self, Scanner* scanner, ScanLine* line) {
	Page* page = NULL;
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Page* _tmp3_ = NULL;
	ScanLine* _tmp4_ = NULL;
#line 264 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 264 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 264 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (line != NULL);
#line 266 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp0_ = self->priv->book;
#line 266 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp1_ = self->priv->book;
#line 266 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 266 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp3_ = book_get_page (_tmp0_, ((gint) _tmp2_) - 1);
#line 266 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	page = _tmp3_;
#line 267 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp4_ = line;
#line 267 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	page_parse_scan_line (page, _tmp4_);
#line 264 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_page_unref0 (page);
#line 1675 "simple-scan.c"
}


static void simple_scan_scanner_page_done_cb (SimpleScan* self, Scanner* scanner) {
	Page* page = NULL;
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Page* _tmp3_ = NULL;
#line 270 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 270 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 272 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp0_ = self->priv->book;
#line 272 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp1_ = self->priv->book;
#line 272 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 272 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp3_ = book_get_page (_tmp0_, ((gint) _tmp2_) - 1);
#line 272 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	page = _tmp3_;
#line 273 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	page_finish (page);
#line 270 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_page_unref0 (page);
#line 1703 "simple-scan.c"
}


static void simple_scan_remove_empty_page (SimpleScan* self) {
	Page* page = NULL;
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	Page* _tmp3_ = NULL;
	Page* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 276 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 278 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp0_ = self->priv->book;
#line 278 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp1_ = self->priv->book;
#line 278 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 278 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp3_ = book_get_page (_tmp0_, ((gint) _tmp2_) - 1);
#line 278 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	page = _tmp3_;
#line 279 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp4_ = page;
#line 279 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp5_ = page_has_data (_tmp4_);
#line 279 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (!_tmp5_) {
#line 1733 "simple-scan.c"
		Book* _tmp6_ = NULL;
		Page* _tmp7_ = NULL;
#line 280 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp6_ = self->priv->book;
#line 280 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp7_ = page;
#line 280 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		book_delete_page (_tmp6_, _tmp7_);
#line 1742 "simple-scan.c"
	}
#line 276 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_page_unref0 (page);
#line 1746 "simple-scan.c"
}


static void simple_scan_scanner_document_done_cb (SimpleScan* self, Scanner* scanner) {
#line 283 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 283 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 285 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	simple_scan_remove_empty_page (self);
#line 1757 "simple-scan.c"
}


static void simple_scan_scanner_failed_cb (SimpleScan* self, Scanner* scanner, gint error_code, const gchar* error_string) {
	gint _tmp0_ = 0;
#line 288 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 288 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 288 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (error_string != NULL);
#line 290 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	simple_scan_remove_empty_page (self);
#line 291 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp0_ = error_code;
#line 291 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (_tmp0_ != ((gint) SANE_STATUS_CANCELLED)) {
#line 1775 "simple-scan.c"
		UserInterface* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
#line 293 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp1_ = self->priv->ui;
#line 293 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp2_ = _ ("Failed to scan");
#line 293 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp3_ = error_string;
#line 293 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp4_ = self->priv->have_devices;
#line 293 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		user_interface_show_error (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 1790 "simple-scan.c"
	}
}


static void simple_scan_scanner_scanning_changed_cb (SimpleScan* self, Scanner* scanner) {
	UserInterface* _tmp0_ = NULL;
	Scanner* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 300 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 302 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp0_ = self->priv->ui;
#line 302 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp1_ = scanner;
#line 302 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp2_ = scanner_is_scanning (_tmp1_);
#line 302 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	user_interface_set_scanning (_tmp0_, _tmp2_);
#line 1811 "simple-scan.c"
}


static void simple_scan_scan_cb (SimpleScan* self, UserInterface* ui, const gchar* device, ScanOptions* options) {
	ScanOptions* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
	Scanner* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gchar* filename_prefix = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* extension = NULL;
	ScanOptions* _tmp9_ = NULL;
	ScanMode _tmp10_ = 0;
	gchar* filename = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	UserInterface* _tmp16_ = NULL;
	Scanner* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	ScanOptions* _tmp19_ = NULL;
#line 305 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 305 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (ui != NULL);
#line 305 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (options != NULL);
#line 307 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp0_ = options;
#line 307 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp1_ = _tmp0_->dpi;
#line 307 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp2_ = device;
#line 307 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_debug ("simple-scan.vala:307: Requesting scan at %d dpi from device '%s'", _tmp1_, _tmp2_);
#line 309 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp3_ = self->priv->scanner;
#line 309 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp4_ = scanner_is_scanning (_tmp3_);
#line 309 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (!_tmp4_) {
#line 1855 "simple-scan.c"
		Page* _tmp5_ = NULL;
		Page* _tmp6_ = NULL;
#line 310 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp5_ = simple_scan_append_page (self);
#line 310 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp6_ = _tmp5_;
#line 310 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_page_unref0 (_tmp6_);
#line 1864 "simple-scan.c"
	}
#line 313 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp7_ = _ ("Scanned Document");
#line 313 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 313 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	filename_prefix = _tmp8_;
#line 315 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp9_ = options;
#line 315 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp10_ = _tmp9_->scan_mode;
#line 315 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (_tmp10_ == SCAN_MODE_COLOR) {
#line 1878 "simple-scan.c"
		gchar* _tmp11_ = NULL;
#line 316 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp11_ = g_strdup ("jpg");
#line 316 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_free0 (extension);
#line 316 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		extension = _tmp11_;
#line 1886 "simple-scan.c"
	} else {
		gchar* _tmp12_ = NULL;
#line 318 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp12_ = g_strdup ("pdf");
#line 318 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_free0 (extension);
#line 318 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		extension = _tmp12_;
#line 1895 "simple-scan.c"
	}
#line 319 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp13_ = filename_prefix;
#line 319 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp14_ = extension;
#line 319 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp15_ = g_strdup_printf ("%s.%s", _tmp13_, _tmp14_);
#line 319 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	filename = _tmp15_;
#line 320 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp16_ = ui;
#line 320 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	user_interface_set_default_file_name (_tmp16_, filename);
#line 321 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp17_ = self->priv->scanner;
#line 321 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp18_ = device;
#line 321 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp19_ = options;
#line 321 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	scanner_scan (_tmp17_, _tmp18_, _tmp19_);
#line 305 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_free0 (filename);
#line 305 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_free0 (extension);
#line 305 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_free0 (filename_prefix);
#line 1923 "simple-scan.c"
}


static void simple_scan_cancel_cb (SimpleScan* self, UserInterface* ui) {
	Scanner* _tmp0_ = NULL;
#line 324 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 324 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (ui != NULL);
#line 326 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp0_ = self->priv->scanner;
#line 326 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	scanner_cancel (_tmp0_);
#line 1937 "simple-scan.c"
}


static gchar* simple_scan_get_temporary_filename (SimpleScan* self, const gchar* prefix, const gchar* extension) {
	gchar* result = NULL;
	gchar* filename = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* path = NULL;
	GError * _inner_error_ = NULL;
#line 329 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 329 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 329 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_val_if_fail (extension != NULL, NULL);
#line 334 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp0_ = prefix;
#line 334 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp1_ = extension;
#line 334 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp2_ = g_strdup_printf ("%sXXXXXX.%s", _tmp0_, _tmp1_);
#line 334 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	filename = _tmp2_;
#line 1963 "simple-scan.c"
	{
		gint fd = 0;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 338 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp3_ = filename;
#line 338 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp5_ = g_file_open_tmp (_tmp3_, &_tmp4_, &_inner_error_);
#line 338 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_free0 (path);
#line 338 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		path = _tmp4_;
#line 338 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		fd = _tmp5_;
#line 338 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 1982 "simple-scan.c"
			goto __catch8_g_error;
		}
#line 339 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp6_ = fd;
#line 339 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		close (_tmp6_);
#line 1989 "simple-scan.c"
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 336 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		e = _inner_error_;
#line 336 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 343 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp7_ = e;
#line 343 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp8_ = _tmp7_->message;
#line 343 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_warning ("simple-scan.vala:343: Error saving email attachment: %s", _tmp8_);
#line 344 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		result = NULL;
#line 344 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_error_free0 (e);
#line 344 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_free0 (path);
#line 344 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_free0 (filename);
#line 344 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		return result;
#line 2017 "simple-scan.c"
	}
	__finally8:
#line 336 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 336 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_free0 (path);
#line 336 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_free0 (filename);
#line 336 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 336 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 336 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		return NULL;
#line 2032 "simple-scan.c"
	}
#line 347 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	result = path;
#line 347 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_free0 (filename);
#line 347 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	return result;
#line 2040 "simple-scan.c"
}


static void simple_scan_email_cb (SimpleScan* self, UserInterface* ui, const gchar* profile, gint quality) {
	gboolean saved = FALSE;
	gchar* command_line = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp42_ = NULL;
	GError * _inner_error_ = NULL;
#line 350 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 350 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (ui != NULL);
#line 350 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (profile != NULL);
#line 352 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	saved = FALSE;
#line 353 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp0_ = g_strdup ("xdg-email");
#line 353 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	command_line = _tmp0_;
#line 356 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp1_ = profile;
#line 356 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (g_strcmp0 (_tmp1_, "text") == 0) {
#line 2067 "simple-scan.c"
		gchar* path = NULL;
		gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 359 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp2_ = simple_scan_get_temporary_filename (self, "scan", "pdf");
#line 359 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		path = _tmp2_;
#line 360 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp3_ = path;
#line 360 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		if (_tmp3_ != NULL) {
#line 2079 "simple-scan.c"
			GFile* file = NULL;
			const gchar* _tmp4_ = NULL;
			GFile* _tmp5_ = NULL;
			UserInterface* _tmp6_ = NULL;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
#line 362 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp4_ = path;
#line 362 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp5_ = g_file_new_for_path (_tmp4_);
#line 362 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			file = _tmp5_;
#line 363 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp6_ = ui;
#line 363 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			user_interface_show_progress_dialog (_tmp6_);
#line 2099 "simple-scan.c"
			{
				Book* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				GFile* _tmp9_ = NULL;
#line 366 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_tmp7_ = self->priv->book;
#line 366 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_tmp8_ = quality;
#line 366 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_tmp9_ = file;
#line 366 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				book_save (_tmp7_, "pdf", _tmp8_, _tmp9_, &_inner_error_);
#line 366 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				if (_inner_error_ != NULL) {
#line 2114 "simple-scan.c"
					goto __catch9_g_error;
				}
			}
			goto __finally9;
			__catch9_g_error:
			{
				GError* e = NULL;
				UserInterface* _tmp10_ = NULL;
				GError* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
#line 364 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				e = _inner_error_;
#line 364 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_inner_error_ = NULL;
#line 370 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_tmp10_ = ui;
#line 370 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				user_interface_hide_progress_dialog (_tmp10_);
#line 371 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_tmp11_ = e;
#line 371 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_tmp12_ = _tmp11_->message;
#line 371 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				g_warning ("simple-scan.vala:371: Unable to save email file: %s", _tmp12_);
#line 372 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_g_error_free0 (e);
#line 372 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_g_object_unref0 (file);
#line 372 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_g_free0 (path);
#line 372 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_g_free0 (command_line);
#line 372 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				return;
#line 2149 "simple-scan.c"
			}
			__finally9:
#line 364 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			if (_inner_error_ != NULL) {
#line 364 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_g_object_unref0 (file);
#line 364 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_g_free0 (path);
#line 364 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_g_free0 (command_line);
#line 364 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 364 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				g_clear_error (&_inner_error_);
#line 364 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				return;
#line 2166 "simple-scan.c"
			}
#line 374 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp13_ = command_line;
#line 374 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp14_ = path;
#line 374 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp15_ = g_strdup_printf (" --attach %s", _tmp14_);
#line 374 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp16_ = _tmp15_;
#line 374 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp17_ = g_strconcat (_tmp13_, _tmp16_, NULL);
#line 374 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_g_free0 (command_line);
#line 374 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			command_line = _tmp17_;
#line 374 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_g_free0 (_tmp16_);
#line 360 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_g_object_unref0 (file);
#line 2186 "simple-scan.c"
		}
#line 356 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_free0 (path);
#line 2190 "simple-scan.c"
	} else {
		{
			gint i = 0;
#line 379 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			i = 0;
#line 2196 "simple-scan.c"
			{
				gboolean _tmp18_ = FALSE;
#line 379 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_tmp18_ = TRUE;
#line 379 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				while (TRUE) {
#line 2203 "simple-scan.c"
					gboolean _tmp19_ = FALSE;
					gint _tmp21_ = 0;
					Book* _tmp22_ = NULL;
					guint _tmp23_ = 0U;
					gchar* path = NULL;
					gchar* _tmp24_ = NULL;
					const gchar* _tmp25_ = NULL;
					GFile* file = NULL;
					const gchar* _tmp26_ = NULL;
					GFile* _tmp27_ = NULL;
					const gchar* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					gchar* _tmp38_ = NULL;
					gchar* _tmp39_ = NULL;
					gchar* _tmp40_ = NULL;
					gboolean _tmp41_ = FALSE;
#line 379 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp19_ = _tmp18_;
#line 379 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					if (!_tmp19_) {
#line 2224 "simple-scan.c"
						gint _tmp20_ = 0;
#line 379 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp20_ = i;
#line 379 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						i = _tmp20_ + 1;
#line 2230 "simple-scan.c"
					}
#line 379 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp18_ = FALSE;
#line 379 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp21_ = i;
#line 379 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp22_ = self->priv->book;
#line 379 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp23_ = book_get_n_pages (_tmp22_);
#line 379 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					if (!(((guint) _tmp21_) < _tmp23_)) {
#line 379 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						break;
#line 2244 "simple-scan.c"
					}
#line 381 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp24_ = simple_scan_get_temporary_filename (self, "scan", "jpg");
#line 381 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					path = _tmp24_;
#line 382 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp25_ = path;
#line 382 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					if (_tmp25_ == NULL) {
#line 384 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						saved = FALSE;
#line 385 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_g_free0 (path);
#line 385 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						break;
#line 2260 "simple-scan.c"
					}
#line 388 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp26_ = path;
#line 388 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp27_ = g_file_new_for_path (_tmp26_);
#line 388 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					file = _tmp27_;
#line 2268 "simple-scan.c"
					{
						Book* _tmp28_ = NULL;
						gint _tmp29_ = 0;
						Page* _tmp30_ = NULL;
						Page* _tmp31_ = NULL;
						gint _tmp32_ = 0;
						GFile* _tmp33_ = NULL;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp28_ = self->priv->book;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp29_ = i;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp30_ = book_get_page (_tmp28_, _tmp29_);
#line 391 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp31_ = _tmp30_;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp32_ = quality;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp33_ = file;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						page_save (_tmp31_, "jpeg", _tmp32_, _tmp33_, &_inner_error_);
#line 391 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_page_unref0 (_tmp31_);
#line 391 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						if (_inner_error_ != NULL) {
#line 2294 "simple-scan.c"
							goto __catch10_g_error;
						}
					}
					goto __finally10;
					__catch10_g_error:
					{
						GError* e = NULL;
						GError* _tmp34_ = NULL;
						const gchar* _tmp35_ = NULL;
#line 389 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						e = _inner_error_;
#line 389 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_inner_error_ = NULL;
#line 395 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp34_ = e;
#line 395 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp35_ = _tmp34_->message;
#line 395 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						g_warning ("simple-scan.vala:395: Unable to save email file: %s", _tmp35_);
#line 396 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_g_error_free0 (e);
#line 396 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_g_object_unref0 (file);
#line 396 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_g_free0 (path);
#line 396 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_g_free0 (command_line);
#line 396 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						return;
#line 2324 "simple-scan.c"
					}
					__finally10:
#line 389 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					if (_inner_error_ != NULL) {
#line 389 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_g_object_unref0 (file);
#line 389 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_g_free0 (path);
#line 389 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_g_free0 (command_line);
#line 389 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 389 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						g_clear_error (&_inner_error_);
#line 389 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						return;
#line 2341 "simple-scan.c"
					}
#line 398 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp36_ = command_line;
#line 398 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp37_ = path;
#line 398 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp38_ = g_strdup_printf (" --attach %s", _tmp37_);
#line 398 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp39_ = _tmp38_;
#line 398 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp40_ = g_strconcat (_tmp36_, _tmp39_, NULL);
#line 398 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_g_free0 (command_line);
#line 398 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					command_line = _tmp40_;
#line 398 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_g_free0 (_tmp39_);
#line 400 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp41_ = saved;
#line 400 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					if (!_tmp41_) {
#line 401 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_g_object_unref0 (file);
#line 401 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_g_free0 (path);
#line 401 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						break;
#line 2369 "simple-scan.c"
					}
#line 379 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_g_object_unref0 (file);
#line 379 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_g_free0 (path);
#line 2375 "simple-scan.c"
				}
			}
		}
	}
#line 405 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp42_ = command_line;
#line 405 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_debug ("simple-scan.vala:405: Launching email client: %s", _tmp42_);
#line 2384 "simple-scan.c"
	{
		const gchar* _tmp43_ = NULL;
#line 408 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp43_ = command_line;
#line 408 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_spawn_command_line_async (_tmp43_, &_inner_error_);
#line 408 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 2393 "simple-scan.c"
			goto __catch11_g_error;
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		GError* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
#line 406 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		e = _inner_error_;
#line 406 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 412 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp44_ = e;
#line 412 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp45_ = _tmp44_->message;
#line 412 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_warning ("simple-scan.vala:412: Unable to start email: %s", _tmp45_);
#line 406 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_error_free0 (e);
#line 2415 "simple-scan.c"
	}
	__finally11:
#line 406 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 406 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_free0 (command_line);
#line 406 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 406 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 406 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		return;
#line 2428 "simple-scan.c"
	}
#line 350 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_free0 (command_line);
#line 2432 "simple-scan.c"
}


static void simple_scan_log_cb (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message) {
	gchar* prefix = NULL;
	GLogLevelFlags _tmp0_ = 0;
	FILE* _tmp8_ = NULL;
	GTimer* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
#line 416 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (message != NULL);
#line 420 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp0_ = log_level;
#line 420 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	switch (_tmp0_ & G_LOG_LEVEL_MASK) {
#line 420 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		case G_LOG_LEVEL_ERROR:
#line 2453 "simple-scan.c"
		{
			gchar* _tmp1_ = NULL;
#line 423 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp1_ = g_strdup ("ERROR:");
#line 423 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_g_free0 (prefix);
#line 423 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			prefix = _tmp1_;
#line 424 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			break;
#line 2464 "simple-scan.c"
		}
#line 420 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		case G_LOG_LEVEL_CRITICAL:
#line 2468 "simple-scan.c"
		{
			gchar* _tmp2_ = NULL;
#line 426 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp2_ = g_strdup ("CRITICAL:");
#line 426 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_g_free0 (prefix);
#line 426 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			prefix = _tmp2_;
#line 427 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			break;
#line 2479 "simple-scan.c"
		}
#line 420 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		case G_LOG_LEVEL_WARNING:
#line 2483 "simple-scan.c"
		{
			gchar* _tmp3_ = NULL;
#line 429 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp3_ = g_strdup ("WARNING:");
#line 429 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_g_free0 (prefix);
#line 429 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			prefix = _tmp3_;
#line 430 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			break;
#line 2494 "simple-scan.c"
		}
#line 420 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		case G_LOG_LEVEL_MESSAGE:
#line 2498 "simple-scan.c"
		{
			gchar* _tmp4_ = NULL;
#line 432 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp4_ = g_strdup ("MESSAGE:");
#line 432 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_g_free0 (prefix);
#line 432 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			prefix = _tmp4_;
#line 433 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			break;
#line 2509 "simple-scan.c"
		}
#line 420 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		case G_LOG_LEVEL_INFO:
#line 2513 "simple-scan.c"
		{
			gchar* _tmp5_ = NULL;
#line 435 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp5_ = g_strdup ("INFO:");
#line 435 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_g_free0 (prefix);
#line 435 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			prefix = _tmp5_;
#line 436 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			break;
#line 2524 "simple-scan.c"
		}
#line 420 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		case G_LOG_LEVEL_DEBUG:
#line 2528 "simple-scan.c"
		{
			gchar* _tmp6_ = NULL;
#line 438 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp6_ = g_strdup ("DEBUG:");
#line 438 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_g_free0 (prefix);
#line 438 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			prefix = _tmp6_;
#line 439 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			break;
#line 2539 "simple-scan.c"
		}
		default:
		{
			gchar* _tmp7_ = NULL;
#line 441 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp7_ = g_strdup ("LOG:");
#line 441 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_g_free0 (prefix);
#line 441 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			prefix = _tmp7_;
#line 442 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			break;
#line 2552 "simple-scan.c"
		}
	}
#line 445 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp8_ = simple_scan_log_file;
#line 445 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp9_ = simple_scan_log_timer;
#line 445 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp10_ = g_timer_elapsed (_tmp9_, NULL);
#line 445 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp11_ = prefix;
#line 445 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp12_ = message;
#line 445 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	fprintf (_tmp8_, "[%+.2fs] %s %s\n", _tmp10_, _tmp11_, _tmp12_);
#line 446 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp13_ = simple_scan_debug_enabled;
#line 446 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (_tmp13_) {
#line 2571 "simple-scan.c"
		FILE* _tmp14_ = NULL;
		GTimer* _tmp15_ = NULL;
		gdouble _tmp16_ = 0.0;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp14_ = stderr;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp15_ = simple_scan_log_timer;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp16_ = g_timer_elapsed (_tmp15_, NULL);
#line 447 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp17_ = prefix;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp18_ = message;
#line 447 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		fprintf (_tmp14_, "[%+.2fs] %s %s\n", _tmp16_, _tmp17_, _tmp18_);
#line 2589 "simple-scan.c"
	}
#line 416 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_free0 (prefix);
#line 2593 "simple-scan.c"
}


static void simple_scan_on_uevent (SimpleScan* self, GUdevClient* client, const gchar* action, GUdevDevice* device) {
	Scanner* _tmp0_ = NULL;
#line 450 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 450 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (client != NULL);
#line 450 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (action != NULL);
#line 450 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (device != NULL);
#line 452 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp0_ = self->priv->scanner;
#line 452 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	scanner_redetect (_tmp0_);
#line 2611 "simple-scan.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1156 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1157 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1157 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 2634 "simple-scan.c"
		glong _tmp4_ = 0L;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1158 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 2642 "simple-scan.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1160 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 2654 "simple-scan.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
#line 1167 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 2679 "simple-scan.c"
		glong _tmp2_ = 0L;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 2685 "simple-scan.c"
	} else {
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 2689 "simple-scan.c"
	}
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1169 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 2695 "simple-scan.c"
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1171 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 2707 "simple-scan.c"
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1173 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 2717 "simple-scan.c"
	}
#line 1176 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1176 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 2723 "simple-scan.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1177 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1178 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1178 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 2737 "simple-scan.c"
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1180 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 2747 "simple-scan.c"
	}
#line 1182 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1182 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 2753 "simple-scan.c"
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1183 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 2762 "simple-scan.c"
	}
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1185 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1186 "/usr/share/vala-0.22/vapi/glib-2.0.vapi"
	return result;
#line 2782 "simple-scan.c"
}


static void simple_scan_fix_pdf (const gchar* filename, GError** error) {
	guint8* data = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	const gchar* _tmp0_ = NULL;
	guint8* _tmp1_ = NULL;
	size_t _tmp2_;
	FILE* fixed_file = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	FILE* _tmp6_ = NULL;
	FILE* _tmp7_ = NULL;
	gint offset = 0;
	gint line_number = 0;
	gint xref_offset = 0;
	gint xref_line = 0;
	gint startxref_line = 0;
	gint fixed_size = 0;
	GString* line = NULL;
	GString* _tmp8_ = NULL;
	const gchar* _tmp109_ = NULL;
	const gchar* _tmp110_ = NULL;
	gchar* _tmp111_ = NULL;
	gchar* _tmp112_ = NULL;
	gint _tmp113_ = 0;
	gboolean _tmp114_ = FALSE;
	GError * _inner_error_ = NULL;
#line 455 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_return_if_fail (filename != NULL);
#line 458 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp0_ = filename;
#line 458 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_file_get_contents (_tmp0_, (gchar**) (&_tmp1_), &_tmp2_, &_inner_error_);
#line 458 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	data = (g_free (data), NULL);
#line 458 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	data = _tmp1_;
#line 458 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	data_length1 = _tmp2_;
#line 458 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_data_size_ = data_length1;
#line 458 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 458 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_propagate_error (error, _inner_error_);
#line 458 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		data = (g_free (data), NULL);
#line 458 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		return;
#line 2836 "simple-scan.c"
	}
#line 460 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp3_ = filename;
#line 460 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp4_ = g_strconcat (_tmp3_, ".fixed", NULL);
#line 460 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp5_ = _tmp4_;
#line 460 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp6_ = g_fopen (_tmp5_, "w");
#line 460 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp7_ = _tmp6_;
#line 460 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_free0 (_tmp5_);
#line 460 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	fixed_file = _tmp7_;
#line 462 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	offset = 0;
#line 463 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	line_number = 0;
#line 464 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	xref_offset = 0;
#line 465 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	xref_line = -1;
#line 466 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	startxref_line = -1;
#line 467 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	fixed_size = -1;
#line 468 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp8_ = g_string_new ("");
#line 468 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	line = _tmp8_;
#line 469 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	while (TRUE) {
#line 2870 "simple-scan.c"
		gint _tmp9_ = 0;
		gint end_offset = 0;
		gint _tmp10_ = 0;
		GString* _tmp11_ = NULL;
		GString* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		GString* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gboolean _tmp25_ = FALSE;
		gint _tmp26_ = 0;
		gboolean _tmp30_ = FALSE;
		gint _tmp107_ = 0;
		gint _tmp108_ = 0;
#line 469 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp9_ = offset;
#line 469 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		if (!(_tmp9_ < data_length1)) {
#line 469 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			break;
#line 2890 "simple-scan.c"
		}
#line 471 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp10_ = offset;
#line 471 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		end_offset = _tmp10_;
#line 472 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp11_ = line;
#line 472 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_string_assign (_tmp11_, "");
#line 473 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		while (TRUE) {
#line 2902 "simple-scan.c"
			gint _tmp12_ = 0;
			guint8 c = 0U;
			gint _tmp13_ = 0;
			guint8 _tmp14_ = 0U;
			GString* _tmp15_ = NULL;
			guint8 _tmp16_ = 0U;
			gint _tmp17_ = 0;
			guint8 _tmp18_ = 0U;
#line 473 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp12_ = end_offset;
#line 473 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			if (!(_tmp12_ < data_length1)) {
#line 473 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				break;
#line 2917 "simple-scan.c"
			}
#line 475 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp13_ = end_offset;
#line 475 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp14_ = data[_tmp13_];
#line 475 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			c = _tmp14_;
#line 476 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp15_ = line;
#line 476 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp16_ = c;
#line 476 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			g_string_append_c (_tmp15_, (gchar) _tmp16_);
#line 477 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp17_ = end_offset;
#line 477 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			end_offset = _tmp17_ + 1;
#line 478 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp18_ = c;
#line 478 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			if (_tmp18_ == ((guint8) '\n')) {
#line 479 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				break;
#line 2941 "simple-scan.c"
			}
		}
#line 482 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp19_ = line;
#line 482 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp20_ = _tmp19_->str;
#line 482 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		if (g_strcmp0 (_tmp20_, "startxref\n") == 0) {
#line 2950 "simple-scan.c"
			gint _tmp21_ = 0;
#line 483 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp21_ = line_number;
#line 483 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			startxref_line = _tmp21_;
#line 2956 "simple-scan.c"
		}
#line 485 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp22_ = line;
#line 485 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp23_ = _tmp22_->str;
#line 485 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		if (g_strcmp0 (_tmp23_, "xref\n") == 0) {
#line 2964 "simple-scan.c"
			gint _tmp24_ = 0;
#line 486 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp24_ = line_number;
#line 486 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			xref_line = _tmp24_;
#line 2970 "simple-scan.c"
		}
#line 489 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp26_ = line_number;
#line 489 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		if (_tmp26_ < 2) {
#line 2976 "simple-scan.c"
			GString* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			gboolean _tmp29_ = FALSE;
#line 489 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp27_ = line;
#line 489 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp28_ = _tmp27_->str;
#line 489 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp29_ = g_str_has_prefix (_tmp28_, "%%");
#line 489 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp25_ = _tmp29_;
#line 2988 "simple-scan.c"
		} else {
#line 489 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp25_ = FALSE;
#line 2992 "simple-scan.c"
		}
#line 489 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp30_ = _tmp25_;
#line 489 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		if (_tmp30_) {
#line 2998 "simple-scan.c"
			gint _tmp31_ = 0;
			FILE* _tmp32_ = NULL;
			GString* _tmp33_ = NULL;
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
#line 491 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp31_ = xref_offset;
#line 491 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			xref_offset = _tmp31_ - 1;
#line 492 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp32_ = fixed_file;
#line 492 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp33_ = line;
#line 492 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp34_ = _tmp33_->str;
#line 492 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp35_ = string_substring (_tmp34_, (glong) 1, (glong) (-1));
#line 492 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp36_ = _tmp35_;
#line 492 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			fprintf (_tmp32_, "%s", _tmp36_);
#line 492 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_g_free0 (_tmp36_);
#line 3023 "simple-scan.c"
		} else {
			gboolean _tmp37_ = FALSE;
			gint _tmp38_ = 0;
			gint _tmp39_ = 0;
			gboolean _tmp43_ = FALSE;
#line 496 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp38_ = line_number;
#line 496 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp39_ = xref_line;
#line 496 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			if (_tmp38_ == (_tmp39_ + 1)) {
#line 3035 "simple-scan.c"
				GString* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				gboolean _tmp42_ = FALSE;
#line 496 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_tmp40_ = line;
#line 496 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_tmp41_ = _tmp40_->str;
#line 496 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_tmp42_ = g_str_has_prefix (_tmp41_, "1 ");
#line 496 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_tmp37_ = _tmp42_;
#line 3047 "simple-scan.c"
			} else {
#line 496 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_tmp37_ = FALSE;
#line 3051 "simple-scan.c"
			}
#line 496 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp43_ = _tmp37_;
#line 496 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			if (_tmp43_) {
#line 3057 "simple-scan.c"
				GString* _tmp44_ = NULL;
				const gchar* _tmp45_ = NULL;
				gchar* _tmp46_ = NULL;
				gchar* _tmp47_ = NULL;
				gint _tmp48_ = 0;
				FILE* _tmp49_ = NULL;
				gint _tmp50_ = 0;
				FILE* _tmp51_ = NULL;
#line 498 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_tmp44_ = line;
#line 498 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_tmp45_ = _tmp44_->str;
#line 498 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_tmp46_ = string_substring (_tmp45_, (glong) 2, (glong) (-1));
#line 498 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_tmp47_ = _tmp46_;
#line 498 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_tmp48_ = atoi (_tmp47_);
#line 498 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				fixed_size = _tmp48_ + 1;
#line 498 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_g_free0 (_tmp47_);
#line 499 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_tmp49_ = fixed_file;
#line 499 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_tmp50_ = fixed_size;
#line 499 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				fprintf (_tmp49_, "0 %d\n", _tmp50_);
#line 500 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_tmp51_ = fixed_file;
#line 500 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				fprintf (_tmp51_, "0000000000 65535 f \n");
#line 3090 "simple-scan.c"
			} else {
				gboolean _tmp52_ = FALSE;
				gint _tmp53_ = 0;
				gint _tmp54_ = 0;
				gboolean _tmp58_ = FALSE;
#line 504 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_tmp53_ = line_number;
#line 504 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_tmp54_ = xref_line;
#line 504 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				if (_tmp53_ > _tmp54_) {
#line 3102 "simple-scan.c"
					GString* _tmp55_ = NULL;
					const gchar* _tmp56_ = NULL;
					gboolean _tmp57_ = FALSE;
#line 504 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp55_ = line;
#line 504 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp56_ = _tmp55_->str;
#line 504 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp57_ = g_str_has_suffix (_tmp56_, " 0000 n\n");
#line 504 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp52_ = _tmp57_;
#line 3114 "simple-scan.c"
				} else {
#line 504 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp52_ = FALSE;
#line 3118 "simple-scan.c"
				}
#line 504 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				_tmp58_ = _tmp52_;
#line 504 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				if (_tmp58_) {
#line 3124 "simple-scan.c"
					FILE* _tmp59_ = NULL;
					GString* _tmp60_ = NULL;
					const gchar* _tmp61_ = NULL;
					gint _tmp62_ = 0;
					gint _tmp63_ = 0;
#line 505 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp59_ = fixed_file;
#line 505 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp60_ = line;
#line 505 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp61_ = _tmp60_->str;
#line 505 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp62_ = atoi (_tmp61_);
#line 505 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp63_ = xref_offset;
#line 505 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					fprintf (_tmp59_, "%010d 00000 n \n", _tmp62_ + _tmp63_);
#line 3142 "simple-scan.c"
				} else {
					gboolean _tmp64_ = FALSE;
					gint _tmp65_ = 0;
					gboolean _tmp68_ = FALSE;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp65_ = startxref_line;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					if (_tmp65_ > 0) {
#line 3151 "simple-scan.c"
						gint _tmp66_ = 0;
						gint _tmp67_ = 0;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp66_ = line_number;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp67_ = startxref_line;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp64_ = _tmp66_ == (_tmp67_ + 1);
#line 3160 "simple-scan.c"
					} else {
#line 508 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp64_ = FALSE;
#line 3164 "simple-scan.c"
					}
#line 508 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp68_ = _tmp64_;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					if (_tmp68_) {
#line 3170 "simple-scan.c"
						FILE* _tmp69_ = NULL;
						GString* _tmp70_ = NULL;
						const gchar* _tmp71_ = NULL;
						gint _tmp72_ = 0;
						gint _tmp73_ = 0;
						gchar* _tmp74_ = NULL;
						gchar* _tmp75_ = NULL;
#line 509 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp69_ = fixed_file;
#line 509 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp70_ = line;
#line 509 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp71_ = _tmp70_->str;
#line 509 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp72_ = atoi (_tmp71_);
#line 509 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp73_ = xref_offset;
#line 509 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp74_ = g_strdup_printf ("%d\n", _tmp72_ + _tmp73_);
#line 509 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp75_ = _tmp74_;
#line 509 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						fprintf (_tmp69_, "%s", _tmp75_);
#line 509 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_g_free0 (_tmp75_);
#line 3196 "simple-scan.c"
					} else {
						gboolean _tmp76_ = FALSE;
						gint _tmp77_ = 0;
						gboolean _tmp81_ = FALSE;
#line 511 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp77_ = fixed_size;
#line 511 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						if (_tmp77_ > 0) {
#line 3205 "simple-scan.c"
							GString* _tmp78_ = NULL;
							const gchar* _tmp79_ = NULL;
							gboolean _tmp80_ = FALSE;
#line 511 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
							_tmp78_ = line;
#line 511 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
							_tmp79_ = _tmp78_->str;
#line 511 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
							_tmp80_ = g_str_has_prefix (_tmp79_, "/Size ");
#line 511 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
							_tmp76_ = _tmp80_;
#line 3217 "simple-scan.c"
						} else {
#line 511 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
							_tmp76_ = FALSE;
#line 3221 "simple-scan.c"
						}
#line 511 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp81_ = _tmp76_;
#line 511 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						if (_tmp81_) {
#line 3227 "simple-scan.c"
							FILE* _tmp82_ = NULL;
							gint _tmp83_ = 0;
							gchar* _tmp84_ = NULL;
							gchar* _tmp85_ = NULL;
#line 512 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
							_tmp82_ = fixed_file;
#line 512 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
							_tmp83_ = fixed_size;
#line 512 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
							_tmp84_ = g_strdup_printf ("/Size %d\n", _tmp83_);
#line 512 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
							_tmp85_ = _tmp84_;
#line 512 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
							fprintf (_tmp82_, "%s", _tmp85_);
#line 512 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
							_g_free0 (_tmp85_);
#line 3244 "simple-scan.c"
						} else {
							gboolean _tmp86_ = FALSE;
							gint _tmp87_ = 0;
							gint _tmp88_ = 0;
							gboolean _tmp92_ = FALSE;
#line 515 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
							_tmp87_ = line_number;
#line 515 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
							_tmp88_ = startxref_line;
#line 515 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
							if (_tmp87_ == (_tmp88_ + 2)) {
#line 3256 "simple-scan.c"
								GString* _tmp89_ = NULL;
								const gchar* _tmp90_ = NULL;
								gboolean _tmp91_ = FALSE;
#line 515 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
								_tmp89_ = line;
#line 515 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
								_tmp90_ = _tmp89_->str;
#line 515 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
								_tmp91_ = g_str_has_prefix (_tmp90_, "%%%%");
#line 515 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
								_tmp86_ = _tmp91_;
#line 3268 "simple-scan.c"
							} else {
#line 515 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
								_tmp86_ = FALSE;
#line 3272 "simple-scan.c"
							}
#line 515 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
							_tmp92_ = _tmp86_;
#line 515 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
							if (_tmp92_) {
#line 3278 "simple-scan.c"
								FILE* _tmp93_ = NULL;
								GString* _tmp94_ = NULL;
								const gchar* _tmp95_ = NULL;
								gchar* _tmp96_ = NULL;
								gchar* _tmp97_ = NULL;
#line 516 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
								_tmp93_ = fixed_file;
#line 516 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
								_tmp94_ = line;
#line 516 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
								_tmp95_ = _tmp94_->str;
#line 516 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
								_tmp96_ = string_substring (_tmp95_, (glong) 2, (glong) (-1));
#line 516 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
								_tmp97_ = _tmp96_;
#line 516 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
								fprintf (_tmp93_, "%s", _tmp97_);
#line 516 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
								_g_free0 (_tmp97_);
#line 3298 "simple-scan.c"
							} else {
								{
									gint i = 0;
									gint _tmp98_ = 0;
#line 519 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
									_tmp98_ = offset;
#line 519 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
									i = _tmp98_;
#line 3307 "simple-scan.c"
									{
										gboolean _tmp99_ = FALSE;
#line 519 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
										_tmp99_ = TRUE;
#line 519 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
										while (TRUE) {
#line 3314 "simple-scan.c"
											gboolean _tmp100_ = FALSE;
											gint _tmp102_ = 0;
											gint _tmp103_ = 0;
											FILE* _tmp104_ = NULL;
											gint _tmp105_ = 0;
											guint8 _tmp106_ = 0U;
#line 519 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
											_tmp100_ = _tmp99_;
#line 519 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
											if (!_tmp100_) {
#line 3325 "simple-scan.c"
												gint _tmp101_ = 0;
#line 519 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
												_tmp101_ = i;
#line 519 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
												i = _tmp101_ + 1;
#line 3331 "simple-scan.c"
											}
#line 519 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
											_tmp99_ = FALSE;
#line 519 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
											_tmp102_ = i;
#line 519 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
											_tmp103_ = end_offset;
#line 519 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
											if (!(_tmp102_ < _tmp103_)) {
#line 519 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
												break;
#line 3343 "simple-scan.c"
											}
#line 520 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
											_tmp104_ = fixed_file;
#line 520 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
											_tmp105_ = i;
#line 520 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
											_tmp106_ = data[_tmp105_];
#line 520 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
											fputc ((gchar) _tmp106_, _tmp104_);
#line 3353 "simple-scan.c"
										}
									}
								}
							}
						}
					}
				}
			}
		}
#line 522 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp107_ = line_number;
#line 522 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		line_number = _tmp107_ + 1;
#line 523 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp108_ = end_offset;
#line 523 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		offset = _tmp108_;
#line 3371 "simple-scan.c"
	}
#line 526 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp109_ = filename;
#line 526 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp110_ = filename;
#line 526 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp111_ = g_strconcat (_tmp110_, "~", NULL);
#line 526 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp112_ = _tmp111_;
#line 526 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp113_ = g_rename (_tmp109_, _tmp112_);
#line 526 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp114_ = _tmp113_ >= 0;
#line 526 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_free0 (_tmp112_);
#line 526 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (_tmp114_) {
#line 3389 "simple-scan.c"
		const gchar* _tmp115_ = NULL;
		gchar* _tmp116_ = NULL;
		gchar* _tmp117_ = NULL;
		const gchar* _tmp118_ = NULL;
#line 527 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp115_ = filename;
#line 527 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp116_ = g_strconcat (_tmp115_, ".fixed", NULL);
#line 527 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp117_ = _tmp116_;
#line 527 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp118_ = filename;
#line 527 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_rename (_tmp117_, _tmp118_);
#line 527 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_free0 (_tmp117_);
#line 3406 "simple-scan.c"
	}
#line 455 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_string_free0 (line);
#line 455 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_fclose0 (fixed_file);
#line 455 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	data = (g_free (data), NULL);
#line 3414 "simple-scan.c"
}


static void _simple_scan_log_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
#line 591 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	simple_scan_log_cb (log_domain, log_levels, message);
#line 3421 "simple-scan.c"
}


gint simple_scan_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* c = NULL;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* _tmp2_ = NULL;
	GOptionContext* _tmp3_ = NULL;
	GOptionGroup* _tmp4_ = NULL;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp16_ = NULL;
	ScanDevice* device = NULL;
	gchar** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	GTimer* _tmp39_ = NULL;
	gchar* path = NULL;
	const gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	FILE* _tmp46_ = NULL;
	pid_t _tmp47_ = 0;
	SimpleScan* app = NULL;
	ScanDevice* _tmp48_ = NULL;
	SimpleScan* _tmp49_ = NULL;
	SimpleScan* _tmp50_ = NULL;
	gint _tmp51_ = 0;
	GError * _inner_error_ = NULL;
#line 532 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	setlocale (LC_ALL, "");
#line 533 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
#line 534 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 535 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	textdomain (GETTEXT_PACKAGE);
#line 537 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	gtk_init (&args_length1, &args);
#line 539 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp0_ = _ ("[DEVICE...] - Scanning utility");
#line 539 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp1_ = g_option_context_new (_tmp0_);
#line 539 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	c = _tmp1_;
#line 541 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp2_ = c;
#line 541 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_option_context_add_main_entries (_tmp2_, SIMPLE_SCAN_options, GETTEXT_PACKAGE);
#line 542 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp3_ = c;
#line 542 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp4_ = gtk_get_option_group (TRUE);
#line 542 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_option_context_add_group (_tmp3_, _tmp4_);
#line 3480 "simple-scan.c"
	{
		GOptionContext* _tmp5_ = NULL;
#line 545 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp5_ = c;
#line 545 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_option_context_parse (_tmp5_, &args_length1, &args, &_inner_error_);
#line 545 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 3489 "simple-scan.c"
			goto __catch12_g_error;
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		FILE* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		const gchar* _tmp12_ = NULL;
		FILE* _tmp13_ = NULL;
#line 543 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		e = _inner_error_;
#line 543 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 549 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp6_ = stderr;
#line 549 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp7_ = e;
#line 549 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp8_ = _tmp7_->message;
#line 549 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		fprintf (_tmp6_, "%s\n", _tmp8_);
#line 550 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp9_ = stderr;
#line 550 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp10_ = _ ("Run '%s --help' to see a full list of available command line options.");
#line 550 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp11_ = args;
#line 550 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp11__length1 = args_length1;
#line 550 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp12_ = _tmp11_[0];
#line 550 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		fprintf (_tmp9_, _tmp10_, _tmp12_);
#line 552 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp13_ = stderr;
#line 552 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		fprintf (_tmp13_, "\n");
#line 553 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		result = EXIT_FAILURE;
#line 553 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_error_free0 (e);
#line 553 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_option_context_free0 (c);
#line 553 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		return result;
#line 3542 "simple-scan.c"
	}
	__finally12:
#line 543 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 543 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_option_context_free0 (c);
#line 543 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 543 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 543 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		return 0;
#line 3555 "simple-scan.c"
	}
#line 555 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp14_ = simple_scan_show_version;
#line 555 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (_tmp14_) {
#line 3561 "simple-scan.c"
		FILE* _tmp15_ = NULL;
#line 558 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp15_ = stderr;
#line 558 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		fprintf (_tmp15_, "simple-scan %s\n", VERSION);
#line 559 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		result = EXIT_SUCCESS;
#line 559 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_option_context_free0 (c);
#line 559 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		return result;
#line 3573 "simple-scan.c"
	}
#line 561 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp16_ = simple_scan_fix_pdf_filename;
#line 561 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (_tmp16_ != NULL) {
#line 3579 "simple-scan.c"
		{
			const gchar* _tmp17_ = NULL;
#line 565 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp17_ = simple_scan_fix_pdf_filename;
#line 565 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			simple_scan_fix_pdf (_tmp17_, &_inner_error_);
#line 565 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			if (_inner_error_ != NULL) {
#line 3588 "simple-scan.c"
				goto __catch13_g_error;
			}
			{
				gint i = 0;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
				i = 1;
#line 3595 "simple-scan.c"
				{
					gboolean _tmp18_ = FALSE;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					_tmp18_ = TRUE;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
					while (TRUE) {
#line 3602 "simple-scan.c"
						gboolean _tmp19_ = FALSE;
						gint _tmp21_ = 0;
						gchar** _tmp22_ = NULL;
						gint _tmp22__length1 = 0;
						gchar** _tmp23_ = NULL;
						gint _tmp23__length1 = 0;
						gint _tmp24_ = 0;
						const gchar* _tmp25_ = NULL;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp19_ = _tmp18_;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						if (!_tmp19_) {
#line 3615 "simple-scan.c"
							gint _tmp20_ = 0;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
							_tmp20_ = i;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
							i = _tmp20_ + 1;
#line 3621 "simple-scan.c"
						}
#line 566 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp18_ = FALSE;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp21_ = i;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp22_ = args;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp22__length1 = args_length1;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						if (!(_tmp21_ < _tmp22__length1)) {
#line 566 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
							break;
#line 3635 "simple-scan.c"
						}
#line 567 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp23_ = args;
#line 567 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp23__length1 = args_length1;
#line 567 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp24_ = i;
#line 567 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						_tmp25_ = _tmp23_[_tmp24_];
#line 567 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						simple_scan_fix_pdf (_tmp25_, &_inner_error_);
#line 567 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
						if (_inner_error_ != NULL) {
#line 3649 "simple-scan.c"
							goto __catch13_g_error;
						}
					}
				}
			}
		}
		goto __finally13;
		__catch13_g_error:
		{
			GError* e = NULL;
			FILE* _tmp26_ = NULL;
			GError* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
#line 563 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			e = _inner_error_;
#line 563 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_inner_error_ = NULL;
#line 571 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp26_ = stderr;
#line 571 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp27_ = e;
#line 571 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_tmp28_ = _tmp27_->message;
#line 571 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			fprintf (_tmp26_, "Error fixing PDF file: %s", _tmp28_);
#line 572 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			result = EXIT_FAILURE;
#line 572 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_g_error_free0 (e);
#line 572 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_g_option_context_free0 (c);
#line 572 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			return result;
#line 3683 "simple-scan.c"
		}
		__finally13:
#line 563 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 563 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			_g_option_context_free0 (c);
#line 563 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 563 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			g_clear_error (&_inner_error_);
#line 563 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
			return 0;
#line 3696 "simple-scan.c"
		}
#line 574 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		result = EXIT_SUCCESS;
#line 574 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_option_context_free0 (c);
#line 574 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		return result;
#line 3704 "simple-scan.c"
	}
#line 577 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	device = NULL;
#line 578 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp29_ = args;
#line 578 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp29__length1 = args_length1;
#line 578 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	if (_tmp29__length1 > 1) {
#line 3714 "simple-scan.c"
		ScanDevice* _tmp30_ = NULL;
		ScanDevice* _tmp31_ = NULL;
		gchar** _tmp32_ = NULL;
		gint _tmp32__length1 = 0;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		ScanDevice* _tmp35_ = NULL;
		gchar** _tmp36_ = NULL;
		gint _tmp36__length1 = 0;
		const gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
#line 580 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp30_ = scan_device_new ();
#line 580 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_scan_device_unref0 (device);
#line 580 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		device = _tmp30_;
#line 581 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp31_ = device;
#line 581 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp32_ = args;
#line 581 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp32__length1 = args_length1;
#line 581 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp33_ = _tmp32_[1];
#line 581 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp34_ = g_strdup (_tmp33_);
#line 581 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_free0 (_tmp31_->name);
#line 581 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp31_->name = _tmp34_;
#line 582 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp35_ = device;
#line 582 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp36_ = args;
#line 582 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp36__length1 = args_length1;
#line 582 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp37_ = _tmp36_[1];
#line 582 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp38_ = g_strdup (_tmp37_);
#line 582 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_g_free0 (_tmp35_->label);
#line 582 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
		_tmp35_->label = _tmp38_;
#line 3760 "simple-scan.c"
	}
#line 586 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp39_ = g_timer_new ();
#line 586 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_timer_destroy0 (simple_scan_log_timer);
#line 586 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	simple_scan_log_timer = _tmp39_;
#line 587 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp40_ = g_get_user_cache_dir ();
#line 587 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp41_ = g_build_filename (_tmp40_, "simple-scan", NULL, NULL);
#line 587 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	path = _tmp41_;
#line 588 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp42_ = path;
#line 588 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_mkdir_with_parents (_tmp42_, 0700);
#line 589 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp43_ = g_get_user_cache_dir ();
#line 589 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp44_ = g_build_filename (_tmp43_, "simple-scan", "simple-scan.log", NULL, NULL);
#line 589 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_free0 (path);
#line 589 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	path = _tmp44_;
#line 590 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp45_ = path;
#line 590 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp46_ = g_fopen (_tmp45_, "w");
#line 590 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_fclose0 (simple_scan_log_file);
#line 590 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	simple_scan_log_file = _tmp46_;
#line 591 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_log_set_default_handler (_simple_scan_log_cb_glog_func, NULL);
#line 593 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp47_ = getpid ();
#line 593 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_debug ("simple-scan.vala:593: Starting Simple Scan %s, PID=%i", VERSION, (gint) _tmp47_);
#line 595 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp48_ = device;
#line 595 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp49_ = simple_scan_new (_tmp48_);
#line 595 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	app = _tmp49_;
#line 596 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp50_ = app;
#line 596 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_tmp51_ = g_application_run ((GApplication*) _tmp50_, 0, NULL);
#line 596 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	result = _tmp51_;
#line 596 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_object_unref0 (app);
#line 596 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_free0 (path);
#line 596 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_scan_device_unref0 (device);
#line 596 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_option_context_free0 (c);
#line 596 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	return result;
#line 3822 "simple-scan.c"
}


int main (int argc, char ** argv) {
#line 530 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_type_init ();
#line 530 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	return simple_scan_main (argv, argc);
#line 3831 "simple-scan.c"
}


static void simple_scan_class_init (SimpleScanClass * klass) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	simple_scan_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	g_type_class_add_private (klass, sizeof (SimpleScanPrivate));
#line 12 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	G_APPLICATION_CLASS (klass)->startup = simple_scan_real_startup;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	G_APPLICATION_CLASS (klass)->activate = simple_scan_real_activate;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	G_APPLICATION_CLASS (klass)->shutdown = simple_scan_real_shutdown;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	G_OBJECT_CLASS (klass)->finalize = simple_scan_finalize;
#line 3848 "simple-scan.c"
}


static void simple_scan_instance_init (SimpleScan * self) {
#line 12 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	self->priv = SIMPLE_SCAN_GET_PRIVATE (self);
#line 32 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	self->priv->default_device = NULL;
#line 33 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	self->priv->have_devices = FALSE;
#line 3859 "simple-scan.c"
}


static void simple_scan_finalize (GObject* obj) {
	SimpleScan * self;
#line 12 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SIMPLE_SCAN, SimpleScan);
#line 32 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_scan_device_unref0 (self->priv->default_device);
#line 34 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_g_object_unref0 (self->priv->udev_client);
#line 35 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_user_interface_unref0 (self->priv->ui);
#line 36 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_scanner_unref0 (self->priv->scanner);
#line 37 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	_book_unref0 (self->priv->book);
#line 12 "/home/bob/bzr/simple-scan/3.10/src/simple-scan.vala"
	G_OBJECT_CLASS (simple_scan_parent_class)->finalize (obj);
#line 3879 "simple-scan.c"
}


GType simple_scan_get_type (void) {
	static volatile gsize simple_scan_type_id__volatile = 0;
	if (g_once_init_enter (&simple_scan_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SimpleScanClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) simple_scan_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SimpleScan), 0, (GInstanceInitFunc) simple_scan_instance_init, NULL };
		GType simple_scan_type_id;
		simple_scan_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "SimpleScan", &g_define_type_info, 0);
		g_once_init_leave (&simple_scan_type_id__volatile, simple_scan_type_id);
	}
	return simple_scan_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



