/* tracker-main.c generated by valac 0.14.0, the Vala compiler
 * generated from tracker-main.vala, do not modify */

/*
 * Copyright (C) 2006, Jamie McCracken <jamiemcc@gnome.org>
 * Copyright (C) 2008-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <tracker-store/tracker-config.h>
#include <signal.h>
#include <sys/select.h>
#include <libtracker-common/tracker-common.h>
#include <libtracker-data/tracker-data-query.h>
#include <libtracker-data/tracker-data-update.h>
#include <libtracker-data/tracker-data-backup.h>
#include <libtracker-data/tracker-db-interface.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <libtracker-data/tracker-db-config.h>
#include <libtracker-data/tracker-db-manager.h>
#include <gio/gio.h>
#include <libtracker-data/tracker-data-manager.h>
#include <tracker-store/tracker-locale-change.h>
#include <tracker-store/tracker-events.h>
#include <tracker-store/tracker-writeback.h>
#include <gobject/gvaluecollector.h>


#define TRACKER_TYPE_MAIN (tracker_main_get_type ())
#define TRACKER_MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_MAIN, TrackerMain))
#define TRACKER_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_MAIN, TrackerMainClass))
#define TRACKER_IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_MAIN))
#define TRACKER_IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_MAIN))
#define TRACKER_MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_MAIN, TrackerMainClass))

typedef struct _TrackerMain TrackerMain;
typedef struct _TrackerMainClass TrackerMainClass;
typedef struct _TrackerMainPrivate TrackerMainPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TRACKER_TYPE_STATUS (tracker_status_get_type ())
#define TRACKER_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STATUS, TrackerStatus))
#define TRACKER_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STATUS, TrackerStatusClass))
#define TRACKER_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STATUS))
#define TRACKER_IS_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STATUS))
#define TRACKER_STATUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STATUS, TrackerStatusClass))

typedef struct _TrackerStatus TrackerStatus;
typedef struct _TrackerStatusClass TrackerStatusClass;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _TrackerParamSpecMain TrackerParamSpecMain;

struct _TrackerMain {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerMainPrivate * priv;
};

struct _TrackerMainClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerMain *self);
};

struct _TrackerParamSpecMain {
	GParamSpec parent_instance;
};


static gpointer tracker_main_parent_class = NULL;
static GMainLoop* tracker_main_main_loop;
static GMainLoop* tracker_main_main_loop = NULL;
static gchar* tracker_main_log_filename;
static gchar* tracker_main_log_filename = NULL;
static gboolean tracker_main_shutdown;
static gboolean tracker_main_shutdown = FALSE;
static gboolean tracker_main_version;
static gboolean tracker_main_version = FALSE;
static gint tracker_main_verbosity;
static gint tracker_main_verbosity = 0;
static gboolean tracker_main_force_reindex;
static gboolean tracker_main_force_reindex = FALSE;
static gboolean tracker_main_readonly_mode;
static gboolean tracker_main_readonly_mode = FALSE;
static gboolean tracker_main_in_loop;
static gboolean tracker_main_in_loop = FALSE;

gpointer tracker_main_ref (gpointer instance);
void tracker_main_unref (gpointer instance);
GParamSpec* tracker_param_spec_main (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_value_set_main (GValue* value, gpointer v_object);
void tracker_value_take_main (GValue* value, gpointer v_object);
gpointer tracker_value_get_main (const GValue* value);
GType tracker_main_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_MAIN_DUMMY_PROPERTY
};
#define TRACKER_MAIN_LICENSE "This program is free software and comes without any warranty.\n" \
"It is licensed under version 2 or later of the General Public\n" \
"License which can be viewed at:\n" \
"  http://www.gnu.org/licenses/gpl.txt\n"
#define TRACKER_MAIN_SELECT_CACHE_SIZE 100
#define TRACKER_MAIN_UPDATE_CACHE_SIZE 100
static void tracker_main_sanity_check_option_values (TrackerConfig* config);
static void tracker_main_do_shutdown (void);
static gboolean tracker_main_shutdown_timeout_cb (void);
static void tracker_main_signal_handler (gint signo);
static void tracker_main_initialize_signal_handler (void);
static void _tracker_main_signal_handler_sighandler_t (gint signal);
static void tracker_main_initialize_priority (void);
static gchar** tracker_main_get_writeback_predicates (void);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void tracker_main_config_verbosity_changed_cb (GObject* object, GParamSpec* spec);
static gint tracker_main_main (gchar** args, int args_length1);
void tzset (void);
gboolean tracker_dbus_init (void);
static void _tracker_main_config_verbosity_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GType tracker_status_get_type (void) G_GNUC_CONST;
guint tracker_status_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
TrackerStatus* tracker_dbus_register_notifier (void);
TrackerBusyCallback tracker_status_get_callback (TrackerStatus* self, void** result_target, GDestroyNotify* result_target_destroy_notify);
void tracker_store_init (void);
gboolean tracker_dbus_register_objects (void);
gboolean tracker_dbus_register_names (void);
gboolean tracker_dbus_register_prepare_class_signal (void);
static gchar** _tracker_main_get_writeback_predicates_tracker_writeback_get_predicates_func (int* result_length1);
void tracker_store_resume (void);
void tracker_store_shutdown (void);
static gboolean _tracker_main_shutdown_timeout_cb_gsource_func (gpointer self);
void tracker_dbus_shutdown (void);
TrackerMain* tracker_main_new (void);
TrackerMain* tracker_main_construct (GType object_type);
static void tracker_main_finalize (TrackerMain* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry TRACKER_MAIN_entries[5] = {{"version", 'V', 0, G_OPTION_ARG_NONE, &tracker_main_version, "Displays version information", NULL}, {"verbosity", 'v', 0, G_OPTION_ARG_INT, &tracker_main_verbosity, "Logging, 0 = errors only, 1 = minimal, 2 = detailed and 3 = debug (def" \
"ault = 0)", NULL}, {"force-reindex", 'r', 0, G_OPTION_ARG_NONE, &tracker_main_force_reindex, "Force a re-index of all content", NULL}, {"readonly-mode", 'n', 0, G_OPTION_ARG_NONE, &tracker_main_readonly_mode, "Only allow read based actions on the database", NULL}, {NULL}};

static void tracker_main_sanity_check_option_values (TrackerConfig* config) {
	TrackerConfig* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_;
	const gchar* _tmp5_;
#line 56 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	g_return_if_fail (config != NULL);
#line 57 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	g_message ("General options:");
#line 58 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp0_ = config;
#line 58 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp1_ = tracker_config_get_verbosity (_tmp0_);
#line 58 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp2_ = _tmp1_;
#line 58 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	g_message ("  Verbosity  ............................  %d", _tmp2_);
#line 60 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	g_message ("Store options:");
#line 61 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp4_ = tracker_main_readonly_mode;
#line 61 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp4_) {
#line 61 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp3_ = "yes";
#line 186 "tracker-main.c"
	} else {
#line 61 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp3_ = "no";
#line 190 "tracker-main.c"
	}
#line 61 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp5_ = _tmp3_;
#line 61 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	g_message ("  Readonly mode  ........................  %s", _tmp5_);
#line 196 "tracker-main.c"
}


static void tracker_main_do_shutdown (void) {
	GMainLoop* _tmp0_;
#line 65 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp0_ = tracker_main_main_loop;
#line 65 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp0_ != NULL) {
#line 206 "tracker-main.c"
		GMainLoop* _tmp1_;
#line 66 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp1_ = tracker_main_main_loop;
#line 66 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		g_main_loop_quit (_tmp1_);
#line 212 "tracker-main.c"
	}
#line 69 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_shutdown = TRUE;
#line 216 "tracker-main.c"
}


static gboolean tracker_main_shutdown_timeout_cb (void) {
	gboolean result = FALSE;
#line 73 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	g_critical ("Could not exit in a timely fashion - terminating...");
#line 74 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	exit (1);
#line 72 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	return result;
#line 228 "tracker-main.c"
}


static void tracker_main_signal_handler (gint signo) {
	gboolean _tmp0_;
	gint _tmp1_;
#line 81 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp0_ = tracker_main_in_loop;
#line 81 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp0_) {
#line 82 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		exit (1);
#line 241 "tracker-main.c"
	}
#line 85 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp1_ = signo;
#line 85 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	switch (_tmp1_) {
#line 85 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		case SIGTERM:
#line 85 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		case SIGINT:
#line 251 "tracker-main.c"
		{
			gint _tmp2_;
			const gchar* _tmp3_ = NULL;
#line 88 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			tracker_main_in_loop = TRUE;
#line 89 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			tracker_main_do_shutdown ();
#line 91 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			_tmp2_ = signo;
#line 91 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			_tmp3_ = g_strsignal (_tmp2_);
#line 91 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			if (_tmp3_ != NULL) {
#line 265 "tracker-main.c"
				gint _tmp4_;
				gint _tmp5_;
				const gchar* _tmp6_ = NULL;
#line 92 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
				g_print ("\n");
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
				_tmp4_ = signo;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
				_tmp5_ = signo;
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
				_tmp6_ = g_strsignal (_tmp5_);
#line 93 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
				g_print ("Received signal:%d->'%s'", _tmp4_, _tmp6_);
#line 279 "tracker-main.c"
			}
#line 95 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			break;
#line 283 "tracker-main.c"
		}
		default:
		{
			gint _tmp7_;
			const gchar* _tmp8_ = NULL;
#line 97 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			_tmp7_ = signo;
#line 97 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			_tmp8_ = g_strsignal (_tmp7_);
#line 97 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			if (_tmp8_ != NULL) {
#line 295 "tracker-main.c"
				gint _tmp9_;
				gint _tmp10_;
				const gchar* _tmp11_ = NULL;
#line 98 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
				g_print ("\n");
#line 99 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
				_tmp9_ = signo;
#line 99 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
				_tmp10_ = signo;
#line 99 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
				_tmp11_ = g_strsignal (_tmp10_);
#line 99 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
				g_print ("Received signal:%d->'%s'", _tmp9_, _tmp11_);
#line 309 "tracker-main.c"
			}
#line 101 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			break;
#line 313 "tracker-main.c"
		}
	}
}


static void _tracker_main_signal_handler_sighandler_t (gint signal) {
#line 110 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_signal_handler (signal);
#line 322 "tracker-main.c"
}


static void tracker_main_initialize_signal_handler (void) {
	sigset_t empty_mask = {0};
	sigset_t _tmp0_;
	struct sigaction act = {0};
	sigset_t _tmp1_;
	struct sigaction _tmp2_;
	struct sigaction _tmp3_;
	struct sigaction _tmp4_;
#line 106 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	memset (&empty_mask, 0, sizeof (sigset_t));
#line 107 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp0_ = empty_mask;
#line 107 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	sigemptyset (&_tmp0_);
#line 109 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	memset (&act, 0, sizeof (struct sigaction));
#line 110 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	act.sa_handler = _tracker_main_signal_handler_sighandler_t;
#line 111 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp1_ = empty_mask;
#line 111 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	act.sa_mask = _tmp1_;
#line 112 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	act.sa_flags = 0;
#line 114 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp2_ = act;
#line 114 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	sigaction (SIGTERM, &_tmp2_, NULL);
#line 115 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp3_ = act;
#line 115 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	sigaction (SIGINT, &_tmp3_, NULL);
#line 116 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp4_ = act;
#line 116 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	sigaction (SIGHUP, &_tmp4_, NULL);
#line 362 "tracker-main.c"
}


static void tracker_main_initialize_priority (void) {
#line 121 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_ioprio_init ();
#line 369 "tracker-main.c"
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
#line 137 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if ((*length) == (*size)) {
#line 137 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 137 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 380 "tracker-main.c"
	}
#line 137 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	(*array)[(*length)++] = value;
#line 137 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	(*array)[*length] = NULL;
#line 386 "tracker-main.c"
}


static gchar** tracker_main_get_writeback_predicates (void) {
	gchar** result = NULL;
	gchar** predicates_to_signal;
	gint predicates_to_signal_length1;
	gint _predicates_to_signal_size_;
	GError * _inner_error_ = NULL;
#line 131 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	predicates_to_signal = NULL;
#line 131 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	predicates_to_signal_length1 = 0;
#line 131 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_predicates_to_signal_size_ = predicates_to_signal_length1;
#line 402 "tracker-main.c"
	{
		TrackerDBCursor* _tmp0_ = NULL;
		TrackerDBCursor* cursor;
#line 134 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp0_ = tracker_data_query_sparql_cursor ("SELECT ?predicate WHERE { ?predicate tracker:writeback true }", &_inner_error_);
#line 134 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		cursor = _tmp0_;
#line 134 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		if (_inner_error_ != NULL) {
#line 412 "tracker-main.c"
			goto __catch5_g_error;
		}
#line 136 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		while (TRUE) {
#line 417 "tracker-main.c"
			TrackerDBCursor* _tmp1_;
			gboolean _tmp2_ = FALSE;
			gboolean _tmp3_;
			gchar** _tmp4_;
			gint _tmp4__length1;
			TrackerDBCursor* _tmp5_;
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
#line 136 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			_tmp1_ = cursor;
#line 136 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			_tmp2_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) _tmp1_, NULL, &_inner_error_);
#line 136 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			_tmp3_ = _tmp2_;
#line 136 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			if (_inner_error_ != NULL) {
#line 136 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
				_g_object_unref0 (cursor);
#line 436 "tracker-main.c"
				goto __catch5_g_error;
			}
#line 136 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			if (!_tmp3_) {
#line 136 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
				break;
#line 443 "tracker-main.c"
			}
#line 137 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			_tmp4_ = predicates_to_signal;
#line 137 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			_tmp4__length1 = predicates_to_signal_length1;
#line 137 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			_tmp5_ = cursor;
#line 137 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			_tmp6_ = tracker_sparql_cursor_get_string ((TrackerSparqlCursor*) _tmp5_, 0, NULL);
#line 137 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			_tmp7_ = g_strdup (_tmp6_);
#line 137 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			_vala_array_add1 (&predicates_to_signal, &predicates_to_signal_length1, &_predicates_to_signal_size_, _tmp7_);
#line 457 "tracker-main.c"
		}
#line 133 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (cursor);
#line 461 "tracker-main.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
#line 133 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		e = _inner_error_;
#line 133 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_inner_error_ = NULL;
#line 140 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp8_ = e;
#line 140 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp9_ = _tmp8_->message;
#line 140 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		g_critical ("Unable to retrieve tracker:writeback properties: %s", _tmp9_);
#line 133 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_error_free0 (e);
#line 481 "tracker-main.c"
	}
	__finally5:
#line 133 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (_inner_error_ != NULL) {
#line 133 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		predicates_to_signal = (_vala_array_free (predicates_to_signal, predicates_to_signal_length1, (GDestroyNotify) g_free), NULL);
#line 133 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 133 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		g_clear_error (&_inner_error_);
#line 133 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		return NULL;
#line 494 "tracker-main.c"
	}
#line 143 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	result = predicates_to_signal;
#line 143 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	return result;
#line 500 "tracker-main.c"
}


static void tracker_main_config_verbosity_changed_cb (GObject* object, GParamSpec* spec) {
	GObject* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint verbosity;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_;
	gint _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
#line 146 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	g_return_if_fail (object != NULL);
#line 147 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp0_ = object;
#line 147 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp1_ = tracker_config_get_verbosity (TRACKER_CONFIG (_tmp0_));
#line 147 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp2_ = _tmp1_;
#line 147 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	verbosity = _tmp2_;
#line 151 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp4_ = verbosity;
#line 151 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp4_ > 0) {
#line 151 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp3_ = "enabling";
#line 530 "tracker-main.c"
	} else {
#line 151 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp3_ = "disabling";
#line 534 "tracker-main.c"
	}
#line 149 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp5_ = verbosity;
#line 149 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp6_ = _tmp3_;
#line 149 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	g_message ("Log verbosity is set to %d, %s D-Bus client lookup", _tmp5_, _tmp6_);
#line 153 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp7_ = verbosity;
#line 153 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_dbus_enable_client_lookup (_tmp7_ > 0);
#line 546 "tracker-main.c"
}


static void _tracker_main_config_verbosity_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 214 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_config_verbosity_changed_cb (_sender, pspec);
#line 553 "tracker-main.c"
}


static gchar** _tracker_main_get_writeback_predicates_tracker_writeback_get_predicates_func (int* result_length1) {
	gchar** result;
	result = tracker_main_get_writeback_predicates ();
#line 295 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	return result;
#line 562 "tracker-main.c"
}


static gboolean _tracker_main_shutdown_timeout_cb_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_main_shutdown_timeout_cb ();
#line 316 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	return result;
#line 571 "tracker-main.c"
}


static gint tracker_main_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp6_;
	TrackerConfig* _tmp7_;
	TrackerConfig* config;
	TrackerDBConfig* _tmp8_;
	TrackerDBConfig* db_config;
	gint _tmp9_;
	TrackerConfig* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_;
	TrackerConfig* _tmp17_;
	gboolean _tmp18_ = FALSE;
	TrackerConfig* _tmp19_;
	TrackerConfig* _tmp20_;
	gulong _tmp21_ = 0UL;
	gulong config_verbosity_id;
	TrackerDBManagerFlags flags;
	gboolean _tmp22_;
	TrackerStatus* _tmp24_ = NULL;
	TrackerStatus* notifier;
	TrackerStatus* _tmp25_;
	void* _tmp26_ = NULL;
	GDestroyNotify _tmp27_ = NULL;
	TrackerBusyCallback _tmp28_ = NULL;
	TrackerBusyCallback busy_callback;
	void* busy_callback_target;
	GDestroyNotify busy_callback_target_destroy_notify;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	TrackerDBConfig* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gint chunk_size_mb;
	gint _tmp34_;
	gsize chunk_size;
	TrackerDBConfig* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* rotate_to;
	const gchar* _tmp39_;
	gint _tmp40_;
	gboolean do_rotating;
	gboolean _tmp41_;
	gsize _tmp42_;
	const gchar* _tmp43_;
	gint select_cache_size = 0;
	gint update_cache_size = 0;
	gchar* cache_size_s = NULL;
	const gchar* _tmp44_ = NULL;
	gchar* _tmp45_;
	gboolean _tmp46_ = FALSE;
	const gchar* _tmp47_;
	gboolean _tmp49_;
	const gchar* _tmp52_ = NULL;
	gchar* _tmp53_;
	gboolean _tmp54_ = FALSE;
	const gchar* _tmp55_;
	gboolean _tmp57_;
	gboolean is_first_time_index = FALSE;
	gboolean _tmp67_;
	gboolean _tmp68_;
	TrackerConfig* _tmp71_;
	gulong _tmp72_;
	gint _tmp73_;
	gsize _tmp74_;
	GError * _inner_error_ = NULL;
#line 157 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	setlocale (LC_ALL, "");
#line 159 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 160 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 161 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	textdomain (GETTEXT_PACKAGE);
#line 164 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tzset ();
#line 166 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_verbosity = -1;
#line 657 "tracker-main.c"
	{
		const gchar* _tmp0_ = NULL;
		GOptionContext* _tmp1_;
		GOptionContext* context;
		GOptionContext* _tmp2_;
		GOptionContext* _tmp3_;
#line 172 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp0_ = _ ("- start the tracker daemon");
#line 172 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp1_ = g_option_context_new (_tmp0_);
#line 172 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		context = _tmp1_;
#line 173 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp2_ = context;
#line 173 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		g_option_context_add_main_entries (_tmp2_, TRACKER_MAIN_entries, NULL);
#line 174 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp3_ = context;
#line 174 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		g_option_context_parse (_tmp3_, &args_length1, &args, &_inner_error_);
#line 174 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		if (_inner_error_ != NULL) {
#line 174 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			_g_option_context_free0 (context);
#line 682 "tracker-main.c"
			goto __catch6_g_error;
		}
#line 168 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_option_context_free0 (context);
#line 687 "tracker-main.c"
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 168 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		e = _inner_error_;
#line 168 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_inner_error_ = NULL;
#line 176 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp4_ = e;
#line 176 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp5_ = _tmp4_->message;
#line 176 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		g_printerr ("Invalid arguments, %s\n", _tmp5_);
#line 177 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		result = 1;
#line 177 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_error_free0 (e);
#line 177 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		return result;
#line 711 "tracker-main.c"
	}
	__finally6:
#line 168 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (_inner_error_ != NULL) {
#line 168 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 168 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		g_clear_error (&_inner_error_);
#line 168 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		return 0;
#line 722 "tracker-main.c"
	}
#line 180 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp6_ = tracker_main_version;
#line 180 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp6_) {
#line 182 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		g_print ("%s", "\nTracker " PACKAGE_VERSION "\n\n" TRACKER_MAIN_LICENSE "\n");
#line 183 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		result = 0;
#line 183 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		return result;
#line 734 "tracker-main.c"
	}
#line 186 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	g_print ("Initializing tracker-store...\n");
#line 188 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_initialize_signal_handler ();
#line 191 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_initialize_priority ();
#line 194 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp7_ = tracker_config_new ();
#line 194 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	config = _tmp7_;
#line 195 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp8_ = tracker_db_config_new ();
#line 195 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	db_config = _tmp8_;
#line 198 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp9_ = tracker_main_verbosity;
#line 198 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp9_ > (-1)) {
#line 754 "tracker-main.c"
		TrackerConfig* _tmp10_;
		gint _tmp11_;
#line 199 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp10_ = config;
#line 199 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp11_ = tracker_main_verbosity;
#line 199 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		tracker_config_set_verbosity (_tmp10_, _tmp11_);
#line 763 "tracker-main.c"
	}
#line 203 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp12_ = config;
#line 203 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp13_ = tracker_config_get_verbosity (_tmp12_);
#line 203 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp14_ = _tmp13_;
#line 203 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_log_init (_tmp14_, &_tmp15_);
#line 203 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_g_free0 (tracker_main_log_filename);
#line 203 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_log_filename = _tmp15_;
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp16_ = tracker_main_log_filename;
#line 204 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	g_print ("Starting log:\n  File:'%s'\n", _tmp16_);
#line 206 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp17_ = config;
#line 206 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_sanity_check_option_values (_tmp17_);
#line 208 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp18_ = tracker_dbus_init ();
#line 208 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (!_tmp18_) {
#line 209 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		result = 1;
#line 209 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (db_config);
#line 209 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (config);
#line 209 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		return result;
#line 797 "tracker-main.c"
	}
#line 213 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp19_ = config;
#line 213 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_config_verbosity_changed_cb ((GObject*) _tmp19_, NULL);
#line 214 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp20_ = config;
#line 214 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp21_ = g_signal_connect ((GObject*) _tmp20_, "notify::verbosity", (GCallback) _tracker_main_config_verbosity_changed_cb_g_object_notify, NULL);
#line 214 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	config_verbosity_id = _tmp21_;
#line 216 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	flags = TRACKER_DB_MANAGER_REMOVE_CACHE;
#line 218 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp22_ = tracker_main_force_reindex;
#line 218 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp22_) {
#line 815 "tracker-main.c"
		TrackerDBManagerFlags _tmp23_;
#line 222 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp23_ = flags;
#line 222 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		flags = _tmp23_ | TRACKER_DB_MANAGER_FORCE_REINDEX;
#line 821 "tracker-main.c"
	}
#line 225 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp24_ = tracker_dbus_register_notifier ();
#line 225 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	notifier = _tmp24_;
#line 226 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp25_ = notifier;
#line 226 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp28_ = tracker_status_get_callback (_tmp25_, &_tmp26_, &_tmp27_);
#line 226 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	busy_callback = _tmp28_;
#line 226 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	busy_callback_target = _tmp26_;
#line 226 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	busy_callback_target_destroy_notify = _tmp27_;
#line 228 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_store_init ();
#line 231 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp29_ = tracker_dbus_register_objects ();
#line 231 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (!_tmp29_) {
#line 232 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		result = 1;
#line 232 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		(busy_callback_target_destroy_notify == NULL) ? NULL : (busy_callback_target_destroy_notify (busy_callback_target), NULL);
#line 232 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		busy_callback = NULL;
#line 232 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		busy_callback_target = NULL;
#line 232 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		busy_callback_target_destroy_notify = NULL;
#line 232 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (notifier);
#line 232 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (db_config);
#line 232 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (config);
#line 232 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		return result;
#line 861 "tracker-main.c"
	}
#line 235 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp30_ = tracker_dbus_register_names ();
#line 235 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (!_tmp30_) {
#line 236 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		result = 1;
#line 236 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		(busy_callback_target_destroy_notify == NULL) ? NULL : (busy_callback_target_destroy_notify (busy_callback_target), NULL);
#line 236 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		busy_callback = NULL;
#line 236 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		busy_callback_target = NULL;
#line 236 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		busy_callback_target_destroy_notify = NULL;
#line 236 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (notifier);
#line 236 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (db_config);
#line 236 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (config);
#line 236 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		return result;
#line 885 "tracker-main.c"
	}
#line 239 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp31_ = db_config;
#line 239 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp32_ = tracker_db_config_get_journal_chunk_size (_tmp31_);
#line 239 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp33_ = _tmp32_;
#line 239 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	chunk_size_mb = _tmp33_;
#line 240 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp34_ = chunk_size_mb;
#line 240 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	chunk_size = (gsize) ((((gsize) _tmp34_) * ((gsize) 1024)) * ((gsize) 1024));
#line 241 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp35_ = db_config;
#line 241 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp36_ = tracker_db_config_get_journal_rotate_destination (_tmp35_);
#line 241 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp37_ = _tmp36_;
#line 241 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp38_ = g_strdup (_tmp37_);
#line 241 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	rotate_to = _tmp38_;
#line 243 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp39_ = rotate_to;
#line 243 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (g_strcmp0 (_tmp39_, "") == 0) {
#line 244 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_free0 (rotate_to);
#line 244 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		rotate_to = NULL;
#line 917 "tracker-main.c"
	}
#line 247 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp40_ = chunk_size_mb;
#line 247 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	do_rotating = _tmp40_ != (-1);
#line 249 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp41_ = do_rotating;
#line 249 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp42_ = chunk_size;
#line 249 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp43_ = rotate_to;
#line 249 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_db_journal_set_rotating (_tmp41_, _tmp42_, _tmp43_);
#line 254 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp44_ = g_getenv ("TRACKER_STORE_SELECT_CACHE_SIZE");
#line 254 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp45_ = g_strdup (_tmp44_);
#line 254 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_g_free0 (cache_size_s);
#line 254 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	cache_size_s = _tmp45_;
#line 255 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp47_ = cache_size_s;
#line 255 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp47_ != NULL) {
#line 943 "tracker-main.c"
		const gchar* _tmp48_;
#line 255 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp48_ = cache_size_s;
#line 255 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp46_ = g_strcmp0 (_tmp48_, "") != 0;
#line 949 "tracker-main.c"
	} else {
#line 255 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp46_ = FALSE;
#line 953 "tracker-main.c"
	}
#line 255 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp49_ = _tmp46_;
#line 255 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp49_) {
#line 959 "tracker-main.c"
		const gchar* _tmp50_;
		gint _tmp51_ = 0;
#line 256 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp50_ = cache_size_s;
#line 256 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp51_ = atoi (_tmp50_);
#line 256 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		select_cache_size = _tmp51_;
#line 968 "tracker-main.c"
	} else {
#line 258 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		select_cache_size = TRACKER_MAIN_SELECT_CACHE_SIZE;
#line 972 "tracker-main.c"
	}
#line 261 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp52_ = g_getenv ("TRACKER_STORE_UPDATE_CACHE_SIZE");
#line 261 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp53_ = g_strdup (_tmp52_);
#line 261 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_g_free0 (cache_size_s);
#line 261 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	cache_size_s = _tmp53_;
#line 262 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp55_ = cache_size_s;
#line 262 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp55_ != NULL) {
#line 986 "tracker-main.c"
		const gchar* _tmp56_;
#line 262 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp56_ = cache_size_s;
#line 262 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp54_ = g_strcmp0 (_tmp56_, "") != 0;
#line 992 "tracker-main.c"
	} else {
#line 262 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp54_ = FALSE;
#line 996 "tracker-main.c"
	}
#line 262 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp57_ = _tmp54_;
#line 262 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (_tmp57_) {
#line 1002 "tracker-main.c"
		const gchar* _tmp58_;
		gint _tmp59_ = 0;
#line 263 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp58_ = cache_size_s;
#line 263 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp59_ = atoi (_tmp58_);
#line 263 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		update_cache_size = _tmp59_;
#line 1011 "tracker-main.c"
	} else {
#line 265 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		update_cache_size = TRACKER_MAIN_UPDATE_CACHE_SIZE;
#line 1015 "tracker-main.c"
	}
	{
		TrackerDBManagerFlags _tmp60_;
		gint _tmp61_;
		gint _tmp62_;
		TrackerBusyCallback _tmp63_;
		void* _tmp63__target;
		gboolean _tmp64_ = FALSE;
#line 271 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp60_ = flags;
#line 271 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp61_ = select_cache_size;
#line 271 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp62_ = update_cache_size;
#line 271 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp63_ = busy_callback;
#line 271 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp63__target = busy_callback_target;
#line 271 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		tracker_data_manager_init (_tmp60_, NULL, &_tmp64_, TRUE, FALSE, (guint) _tmp61_, (guint) _tmp62_, _tmp63_, _tmp63__target, "Initializing", &_inner_error_);
#line 271 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		is_first_time_index = _tmp64_;
#line 271 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		if (_inner_error_ != NULL) {
#line 1040 "tracker-main.c"
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp65_;
		const gchar* _tmp66_;
#line 270 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		e = _inner_error_;
#line 270 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_inner_error_ = NULL;
#line 281 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp65_ = e;
#line 281 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp66_ = _tmp65_->message;
#line 281 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		g_critical ("Cannot initialize database: %s", _tmp66_);
#line 282 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		result = 1;
#line 282 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_error_free0 (e);
#line 282 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_free0 (cache_size_s);
#line 282 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_free0 (rotate_to);
#line 282 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		(busy_callback_target_destroy_notify == NULL) ? NULL : (busy_callback_target_destroy_notify (busy_callback_target), NULL);
#line 282 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		busy_callback = NULL;
#line 282 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		busy_callback_target = NULL;
#line 282 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		busy_callback_target_destroy_notify = NULL;
#line 282 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (notifier);
#line 282 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (db_config);
#line 282 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (config);
#line 282 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		return result;
#line 1084 "tracker-main.c"
	}
	__finally7:
#line 270 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (_inner_error_ != NULL) {
#line 270 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_free0 (cache_size_s);
#line 270 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_free0 (rotate_to);
#line 270 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		(busy_callback_target_destroy_notify == NULL) ? NULL : (busy_callback_target_destroy_notify (busy_callback_target), NULL);
#line 270 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		busy_callback = NULL;
#line 270 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		busy_callback_target = NULL;
#line 270 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		busy_callback_target_destroy_notify = NULL;
#line 270 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (notifier);
#line 270 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (db_config);
#line 270 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_object_unref0 (config);
#line 270 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 270 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		g_clear_error (&_inner_error_);
#line 270 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		return 0;
#line 1113 "tracker-main.c"
	}
#line 285 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_g_object_unref0 (db_config);
#line 285 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	db_config = NULL;
#line 286 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_g_object_unref0 (notifier);
#line 286 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	notifier = NULL;
#line 288 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp67_ = tracker_main_shutdown;
#line 288 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (!_tmp67_) {
#line 290 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		tracker_locale_change_initialize_subscription ();
#line 292 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		tracker_dbus_register_prepare_class_signal ();
#line 294 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		tracker_events_init ();
#line 295 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		tracker_writeback_init (_tracker_main_get_writeback_predicates_tracker_writeback_get_predicates_func);
#line 296 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		tracker_store_resume ();
#line 298 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		g_message ("Waiting for D-Bus requests...");
#line 1139 "tracker-main.c"
	}
#line 304 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp68_ = tracker_main_shutdown;
#line 304 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (!_tmp68_) {
#line 1145 "tracker-main.c"
		GMainLoop* _tmp69_;
		GMainLoop* _tmp70_;
#line 305 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp69_ = g_main_loop_new (NULL, FALSE);
#line 305 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_g_main_loop_unref0 (tracker_main_main_loop);
#line 305 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		tracker_main_main_loop = _tmp69_;
#line 306 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		_tmp70_ = tracker_main_main_loop;
#line 306 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		g_main_loop_run (_tmp70_);
#line 1158 "tracker-main.c"
	}
#line 312 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	g_message ("Shutdown started");
#line 314 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_store_shutdown ();
#line 316 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	g_timeout_add_full (G_PRIORITY_LOW, (guint) 5000, _tracker_main_shutdown_timeout_cb_gsource_func, NULL, NULL);
#line 318 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	g_message ("Cleaning up");
#line 321 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_writeback_shutdown ();
#line 322 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_events_shutdown ();
#line 324 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_locale_change_shutdown_subscription ();
#line 326 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_dbus_shutdown ();
#line 327 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_data_manager_shutdown ();
#line 328 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_log_shutdown ();
#line 330 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp71_ = config;
#line 330 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp72_ = config_verbosity_id;
#line 330 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	g_signal_handler_disconnect ((GObject*) _tmp71_, _tmp72_);
#line 331 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_g_object_unref0 (config);
#line 331 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	config = NULL;
#line 334 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp73_ = chunk_size_mb;
#line 334 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_tmp74_ = chunk_size;
#line 334 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_db_journal_set_rotating (_tmp73_ != (-1), _tmp74_, NULL);
#line 336 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	g_print ("\nOK\n\n");
#line 338 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_g_free0 (tracker_main_log_filename);
#line 338 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_log_filename = NULL;
#line 340 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_g_main_loop_unref0 (tracker_main_main_loop);
#line 340 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_main_loop = NULL;
#line 342 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	result = 0;
#line 342 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_g_free0 (cache_size_s);
#line 342 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_g_free0 (rotate_to);
#line 342 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	(busy_callback_target_destroy_notify == NULL) ? NULL : (busy_callback_target_destroy_notify (busy_callback_target), NULL);
#line 342 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	busy_callback = NULL;
#line 342 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	busy_callback_target = NULL;
#line 342 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	busy_callback_target_destroy_notify = NULL;
#line 342 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_g_object_unref0 (notifier);
#line 342 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_g_object_unref0 (db_config);
#line 342 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	_g_object_unref0 (config);
#line 342 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	return result;
#line 1228 "tracker-main.c"
}


int main (int argc, char ** argv) {
#line 156 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	g_type_init ();
#line 156 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	return tracker_main_main (argv, argc);
#line 1237 "tracker-main.c"
}


TrackerMain* tracker_main_construct (GType object_type) {
	TrackerMain* self = NULL;
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	self = (TrackerMain*) g_type_create_instance (object_type);
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	return self;
#line 1247 "tracker-main.c"
}


TrackerMain* tracker_main_new (void) {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	return tracker_main_construct (TRACKER_TYPE_MAIN);
#line 1254 "tracker-main.c"
}


static void tracker_value_main_init (GValue* value) {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	value->data[0].v_pointer = NULL;
#line 1261 "tracker-main.c"
}


static void tracker_value_main_free_value (GValue* value) {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (value->data[0].v_pointer) {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		tracker_main_unref (value->data[0].v_pointer);
#line 1270 "tracker-main.c"
	}
}


static void tracker_value_main_copy_value (const GValue* src_value, GValue* dest_value) {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (src_value->data[0].v_pointer) {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		dest_value->data[0].v_pointer = tracker_main_ref (src_value->data[0].v_pointer);
#line 1280 "tracker-main.c"
	} else {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1284 "tracker-main.c"
	}
}


static gpointer tracker_value_main_peek_pointer (const GValue* value) {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	return value->data[0].v_pointer;
#line 1292 "tracker-main.c"
}


static gchar* tracker_value_main_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (collect_values[0].v_pointer) {
#line 1299 "tracker-main.c"
		TrackerMain* object;
		object = collect_values[0].v_pointer;
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		if (object->parent_instance.g_class == NULL) {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1306 "tracker-main.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1310 "tracker-main.c"
		}
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		value->data[0].v_pointer = tracker_main_ref (object);
#line 1314 "tracker-main.c"
	} else {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		value->data[0].v_pointer = NULL;
#line 1318 "tracker-main.c"
	}
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	return NULL;
#line 1322 "tracker-main.c"
}


static gchar* tracker_value_main_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerMain** object_p;
	object_p = collect_values[0].v_pointer;
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (!object_p) {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1333 "tracker-main.c"
	}
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (!value->data[0].v_pointer) {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		*object_p = NULL;
#line 1339 "tracker-main.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		*object_p = value->data[0].v_pointer;
#line 1343 "tracker-main.c"
	} else {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		*object_p = tracker_main_ref (value->data[0].v_pointer);
#line 1347 "tracker-main.c"
	}
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	return NULL;
#line 1351 "tracker-main.c"
}


GParamSpec* tracker_param_spec_main (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerParamSpecMain* spec;
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_MAIN), NULL);
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	return G_PARAM_SPEC (spec);
#line 1365 "tracker-main.c"
}


gpointer tracker_value_get_main (const GValue* value) {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_MAIN), NULL);
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	return value->data[0].v_pointer;
#line 1374 "tracker-main.c"
}


void tracker_value_set_main (GValue* value, gpointer v_object) {
	TrackerMain* old;
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_MAIN));
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	old = value->data[0].v_pointer;
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (v_object) {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_MAIN));
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		value->data[0].v_pointer = v_object;
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		tracker_main_ref (value->data[0].v_pointer);
#line 1394 "tracker-main.c"
	} else {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		value->data[0].v_pointer = NULL;
#line 1398 "tracker-main.c"
	}
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (old) {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		tracker_main_unref (old);
#line 1404 "tracker-main.c"
	}
}


void tracker_value_take_main (GValue* value, gpointer v_object) {
	TrackerMain* old;
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_MAIN));
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	old = value->data[0].v_pointer;
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (v_object) {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_MAIN));
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		value->data[0].v_pointer = v_object;
#line 1423 "tracker-main.c"
	} else {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		value->data[0].v_pointer = NULL;
#line 1427 "tracker-main.c"
	}
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (old) {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		tracker_main_unref (old);
#line 1433 "tracker-main.c"
	}
}


static void tracker_main_class_init (TrackerMainClass * klass) {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	tracker_main_parent_class = g_type_class_peek_parent (klass);
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	TRACKER_MAIN_CLASS (klass)->finalize = tracker_main_finalize;
#line 1443 "tracker-main.c"
}


static void tracker_main_instance_init (TrackerMain * self) {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	self->ref_count = 1;
#line 1450 "tracker-main.c"
}


static void tracker_main_finalize (TrackerMain* obj) {
	TrackerMain * self;
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	self = TRACKER_MAIN (obj);
#line 1458 "tracker-main.c"
}


GType tracker_main_get_type (void) {
	static volatile gsize tracker_main_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_main_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_value_main_init, tracker_value_main_free_value, tracker_value_main_copy_value, tracker_value_main_peek_pointer, "p", tracker_value_main_collect_value, "p", tracker_value_main_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerMain), 0, (GInstanceInitFunc) tracker_main_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_main_type_id;
		tracker_main_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerMain", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_main_type_id__volatile, tracker_main_type_id);
	}
	return tracker_main_type_id__volatile;
}


gpointer tracker_main_ref (gpointer instance) {
	TrackerMain* self;
	self = instance;
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	g_atomic_int_inc (&self->ref_count);
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	return instance;
#line 1483 "tracker-main.c"
}


void tracker_main_unref (gpointer instance) {
	TrackerMain* self;
	self = instance;
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		TRACKER_MAIN_GET_CLASS (self)->finalize (self);
#line 21 "/home/juerg/Code/tracker/tracker/src/tracker-store/tracker-main.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1496 "tracker-main.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



