/* tracker-result-store.c generated by valac 0.12.0, the Vala compiler
 * generated from tracker-result-store.vala, do not modify */

/**/
/* Copyright 2010, Carlos Garnacho <carlos@lanedo.com>*/
/**/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <gdk/gdk.h>
#include <stdarg.h>
#include <gobject/gvaluecollector.h>


#define TRACKER_TYPE_RESULT_STORE (tracker_result_store_get_type ())
#define TRACKER_RESULT_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_RESULT_STORE, TrackerResultStore))
#define TRACKER_RESULT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_RESULT_STORE, TrackerResultStoreClass))
#define TRACKER_IS_RESULT_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_RESULT_STORE))
#define TRACKER_IS_RESULT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_RESULT_STORE))
#define TRACKER_RESULT_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_RESULT_STORE, TrackerResultStoreClass))

typedef struct _TrackerResultStore TrackerResultStore;
typedef struct _TrackerResultStoreClass TrackerResultStoreClass;
typedef struct _TrackerResultStorePrivate TrackerResultStorePrivate;

#define TRACKER_RESULT_STORE_TYPE_QUERY_DATA (tracker_result_store_query_data_get_type ())

#define TRACKER_QUERY_TYPE_TYPE (tracker_query_type_get_type ())

#define TRACKER_QUERY_TYPE_MATCH (tracker_query_match_get_type ())
typedef struct _TrackerResultStoreQueryData TrackerResultStoreQueryData;

#define TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE (tracker_result_store_category_node_get_type ())
#define TRACKER_RESULT_STORE_CATEGORY_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE, TrackerResultStoreCategoryNode))
#define TRACKER_RESULT_STORE_CATEGORY_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE, TrackerResultStoreCategoryNodeClass))
#define TRACKER_RESULT_STORE_IS_CATEGORY_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE))
#define TRACKER_RESULT_STORE_IS_CATEGORY_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE))
#define TRACKER_RESULT_STORE_CATEGORY_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE, TrackerResultStoreCategoryNodeClass))

typedef struct _TrackerResultStoreCategoryNode TrackerResultStoreCategoryNode;
typedef struct _TrackerResultStoreCategoryNodeClass TrackerResultStoreCategoryNodeClass;

#define TRACKER_RESULT_STORE_TYPE_OPERATION (tracker_result_store_operation_get_type ())
#define TRACKER_RESULT_STORE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_RESULT_STORE_TYPE_OPERATION, TrackerResultStoreOperation))
#define TRACKER_RESULT_STORE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_RESULT_STORE_TYPE_OPERATION, TrackerResultStoreOperationClass))
#define TRACKER_RESULT_STORE_IS_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_RESULT_STORE_TYPE_OPERATION))
#define TRACKER_RESULT_STORE_IS_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_RESULT_STORE_TYPE_OPERATION))
#define TRACKER_RESULT_STORE_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_RESULT_STORE_TYPE_OPERATION, TrackerResultStoreOperationClass))

typedef struct _TrackerResultStoreOperation TrackerResultStoreOperation;
typedef struct _TrackerResultStoreOperationClass TrackerResultStoreOperationClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerResultStoreOperationPrivate TrackerResultStoreOperationPrivate;

#define TRACKER_TYPE_QUERY (tracker_query_get_type ())
#define TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_QUERY, TrackerQuery))
#define TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_QUERY, TrackerQueryClass))
#define TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_QUERY))
#define TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_QUERY))
#define TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_QUERY, TrackerQueryClass))

typedef struct _TrackerQuery TrackerQuery;
typedef struct _TrackerQueryClass TrackerQueryClass;
#define _tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (tracker_query_unref (var), NULL)))
typedef struct _TrackerResultStoreCategoryNodePrivate TrackerResultStoreCategoryNodePrivate;

#define TRACKER_RESULT_STORE_TYPE_RESULT_NODE (tracker_result_store_result_node_get_type ())
typedef struct _TrackerResultStoreResultNode TrackerResultStoreResultNode;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
typedef struct _TrackerResultStoreLoadOperationData TrackerResultStoreLoadOperationData;
#define _tracker_result_store_category_node_unref0(var) ((var == NULL) ? NULL : (var = (tracker_result_store_category_node_unref (var), NULL)))
typedef struct _TrackerResultStoreLoadCategoryData TrackerResultStoreLoadCategoryData;
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))
typedef struct _TrackerResultStoreFetchThumbnailData TrackerResultStoreFetchThumbnailData;
typedef struct _TrackerResultStoreParamSpecCategoryNode TrackerResultStoreParamSpecCategoryNode;

struct _TrackerResultStore {
	GObject parent_instance;
	TrackerResultStorePrivate * priv;
};

struct _TrackerResultStoreClass {
	GObjectClass parent_class;
};

typedef enum  {
	TRACKER_QUERY_TYPE_ALL,
	TRACKER_QUERY_TYPE_CONTACTS,
	TRACKER_QUERY_TYPE_APPLICATIONS,
	TRACKER_QUERY_TYPE_MUSIC,
	TRACKER_QUERY_TYPE_IMAGES,
	TRACKER_QUERY_TYPE_VIDEOS,
	TRACKER_QUERY_TYPE_DOCUMENTS,
	TRACKER_QUERY_TYPE_MAIL,
	TRACKER_QUERY_TYPE_CALENDAR,
	TRACKER_QUERY_TYPE_FOLDERS,
	TRACKER_QUERY_TYPE_BOOKMARKS
} TrackerQueryType;

typedef enum  {
	TRACKER_QUERY_MATCH_NONE,
	TRACKER_QUERY_MATCH_FTS,
	TRACKER_QUERY_MATCH_FTS_INDIRECT,
	TRACKER_QUERY_MATCH_TITLES,
	TRACKER_QUERY_MATCH_TITLES_INDIRECT
} TrackerQueryMatch;

struct _TrackerResultStoreQueryData {
	TrackerQueryType type;
	TrackerQueryMatch match;
	gchar** args;
	gint args_length1;
	gint _args_size_;
};

struct _TrackerResultStorePrivate {
	GCancellable* cancellable;
	TrackerResultStoreQueryData* queries;
	gint queries_length1;
	gint _queries_size_;
	GPtrArray* categories;
	GPtrArray* running_operations;
	GPtrArray* delayed_operations;
	gint n_extra_columns;
	gint n_columns;
	gint timestamp;
	gint _icon_size;
	gchar* _search_term;
	gboolean _active;
};

struct _TrackerResultStoreOperation {
	GObject parent_instance;
	TrackerResultStoreOperationPrivate * priv;
	TrackerResultStoreCategoryNode* node;
	gint offset;
};

struct _TrackerResultStoreOperationClass {
	GObjectClass parent_class;
};

struct _TrackerResultStoreResultNode {
	gchar** values;
	gint values_length1;
	gint _values_size_;
	GdkPixbuf* pixbuf;
};

struct _TrackerResultStoreCategoryNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerResultStoreCategoryNodePrivate * priv;
	TrackerQueryType type;
	TrackerResultStoreQueryData* query;
	TrackerResultStoreResultNode* results;
	gint results_length1;
	gint _results_size_;
	GdkPixbuf* pixbuf;
	gint count;
};

struct _TrackerResultStoreCategoryNodeClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerResultStoreCategoryNode *self);
};

struct _TrackerResultStoreLoadOperationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerResultStore* self;
	TrackerResultStoreOperation* op;
	GCancellable* cancellable;
	TrackerQuery* query;
	TrackerSparqlCursor* cursor;
	gint i;
	TrackerQuery* _tmp0_;
	TrackerSparqlCursor* _tmp1_;
	TrackerSparqlCursor* _tmp2_;
	gboolean _tmp3_;
	TrackerResultStoreResultNode* _result_;
	GtkTreeIter iter;
	GtkTreePath* path;
	gboolean b;
	gint j;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GError * ge;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GtkTreeIter _tmp13_;
	GtkTreeIter _tmp14_;
	void* _tmp15_;
	GtkTreePath* _tmp16_;
	GError * ie;
	gboolean _tmp17_;
	gint _tmp18_;
	TrackerResultStoreOperation* next_to_start;
	gint _tmp19_;
	gconstpointer _tmp20_;
	TrackerResultStoreOperation* _tmp21_;
	TrackerResultStoreOperation* _tmp22_;
	gint _tmp23_;
	GError * _inner_error_;
};

struct _TrackerResultStoreLoadCategoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerResultStore* self;
	TrackerResultStoreQueryData* query_data;
	GCancellable* cancellable;
	guint count;
	TrackerQuery* _tmp0_;
	TrackerQuery* query;
	guint _tmp1_;
	guint _tmp2_;
	GError * ie;
	gboolean _tmp3_;
	TrackerResultStoreCategoryNode* cat;
	TrackerResultStoreResultNode* res;
	gint i;
	GtkTreeIter iter;
	GtkTreePath* path;
	TrackerResultStoreCategoryNode* _tmp4_;
	gint _tmp5_;
	TrackerResultStoreCategoryNode* _tmp6_;
	GtkTreeIter _tmp7_;
	GtkTreeIter _tmp8_;
	GtkTreePath* _tmp9_;
	gboolean _tmp10_;
	gchar** _tmp11_;
	void* _tmp12_;
	GtkTreePath* _tmp13_;
	GtkTreePath* _tmp14_;
	gint _tmp15_;
	GError * _inner_error_;
};

struct _TrackerResultStoreFetchThumbnailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerResultStore* self;
	GtkTreeIter iter;
	GFile* file;
	GFileInfo* info;
	TrackerResultStoreResultNode* _result_;
	gchar* thumb_path;
	GdkPixbuf* pixbuf;
	GFile* _tmp0_;
	GFileInfo* _tmp1_;
	GFileInfo* _tmp2_;
	GError * ie;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* _tmp6_;
	GIcon* icon;
	GtkIconInfo* icon_info;
	GObject* _tmp7_;
	GIcon* _tmp8_;
	GdkScreen* _tmp9_;
	GtkIconTheme* _tmp10_;
	GtkIconTheme* _tmp11_;
	GtkIconTheme* theme;
	GtkIconInfo* _tmp12_;
	GdkPixbuf* _tmp13_;
	GdkPixbuf* _tmp14_;
	GError * e;
	GtkTreePath* path;
	GdkPixbuf* _tmp15_;
	GtkTreePath* _tmp16_;
	GError * _inner_error_;
};

struct _TrackerResultStoreParamSpecCategoryNode {
	GParamSpec parent_instance;
};


static gpointer tracker_result_store_parent_class = NULL;
static gpointer tracker_result_store_category_node_parent_class = NULL;
static gpointer tracker_result_store_operation_parent_class = NULL;
static GtkTreeModelIface* tracker_result_store_gtk_tree_model_parent_iface = NULL;

GType tracker_result_store_get_type (void) G_GNUC_CONST;
static GType tracker_result_store_query_data_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType tracker_query_type_get_type (void) G_GNUC_CONST;
GType tracker_query_match_get_type (void) G_GNUC_CONST;
static TrackerResultStoreQueryData* tracker_result_store_query_data_dup (const TrackerResultStoreQueryData* self);
static void tracker_result_store_query_data_free (TrackerResultStoreQueryData* self);
static void tracker_result_store_query_data_copy (const TrackerResultStoreQueryData* self, TrackerResultStoreQueryData* dest);
static void tracker_result_store_query_data_destroy (TrackerResultStoreQueryData* self);
static gpointer tracker_result_store_category_node_ref (gpointer instance);
static void tracker_result_store_category_node_unref (gpointer instance);
static GParamSpec* tracker_result_store_param_spec_category_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void tracker_result_store_value_set_category_node (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void tracker_result_store_value_take_category_node (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer tracker_result_store_value_get_category_node (const GValue* value) G_GNUC_UNUSED;
static GType tracker_result_store_category_node_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType tracker_result_store_operation_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define TRACKER_RESULT_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_RESULT_STORE, TrackerResultStorePrivate))
enum  {
	TRACKER_RESULT_STORE_DUMMY_PROPERTY,
	TRACKER_RESULT_STORE_ICON_SIZE,
	TRACKER_RESULT_STORE_SEARCH_TERM,
	TRACKER_RESULT_STORE_ACTIVE
};
static void _vala_TrackerResultStoreQueryData_array_free (TrackerResultStoreQueryData* array, gint array_length);
static TrackerResultStoreOperation* tracker_result_store_find_operation (TrackerResultStore* self, GPtrArray* array, TrackerResultStoreCategoryNode* node, gint offset);
static void tracker_result_store_load_operation_data_free (gpointer _data);
static void tracker_result_store_load_operation (TrackerResultStore* self, TrackerResultStoreOperation* op, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_result_store_load_operation_finish (TrackerResultStore* self, GAsyncResult* _res_);
static gboolean tracker_result_store_load_operation_co (TrackerResultStoreLoadOperationData* data);
gpointer tracker_query_ref (gpointer instance);
void tracker_query_unref (gpointer instance);
GParamSpec* tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_value_set_query (GValue* value, gpointer v_object);
void tracker_value_take_query (GValue* value, gpointer v_object);
gpointer tracker_value_get_query (const GValue* value);
GType tracker_query_get_type (void) G_GNUC_CONST;
TrackerQuery* tracker_query_new (void);
TrackerQuery* tracker_query_construct (GType object_type);
void tracker_query_set_criteria (TrackerQuery* self, const gchar* value);
void tracker_query_set_limit (TrackerQuery* self, guint value);
void tracker_query_set_offset (TrackerQuery* self, guint value);
void tracker_query_perform_async (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type, gchar** args, int args_length1, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlCursor* tracker_query_perform_finish (TrackerQuery* self, GAsyncResult* _res_, GError** error);
static GType tracker_result_store_result_node_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static TrackerResultStoreResultNode* tracker_result_store_result_node_dup (const TrackerResultStoreResultNode* self);
static void tracker_result_store_result_node_free (TrackerResultStoreResultNode* self);
static void tracker_result_store_result_node_copy (const TrackerResultStoreResultNode* self, TrackerResultStoreResultNode* dest);
static void tracker_result_store_result_node_destroy (TrackerResultStoreResultNode* self);
static void tracker_result_store_load_operation_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_result_store_set_active (TrackerResultStore* self, gboolean value);
static void tracker_result_store_add_operation (TrackerResultStore* self, TrackerResultStoreCategoryNode* cat, gint offset);
static TrackerResultStoreOperation* tracker_result_store_operation_new (void);
static TrackerResultStoreOperation* tracker_result_store_operation_construct (GType object_type);
static void tracker_result_store_load_category_data_free (gpointer _data);
static void tracker_result_store_load_category (TrackerResultStore* self, TrackerResultStoreQueryData* query_data, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_result_store_load_category_finish (TrackerResultStore* self, GAsyncResult* _res_);
static gboolean tracker_result_store_load_category_co (TrackerResultStoreLoadCategoryData* data);
void tracker_query_get_count_async (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
guint tracker_query_get_count_finish (TrackerQuery* self, GAsyncResult* _res_, GError** error);
static void tracker_result_store_load_category_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static TrackerResultStoreCategoryNode* tracker_result_store_category_node_new (void);
static TrackerResultStoreCategoryNode* tracker_result_store_category_node_construct (GType object_type);
static void tracker_result_store_clear_results (TrackerResultStore* self);
static gint tracker_result_store_find_nth_category_index (TrackerResultStore* self, TrackerResultStoreCategoryNode* node, gint n);
static gint tracker_result_store_filled_categories_count (TrackerResultStore* self);
static GType tracker_result_store_real_get_column_type (GtkTreeModel* base, gint index_);
static GtkTreeModelFlags tracker_result_store_real_get_flags (GtkTreeModel* base);
static gboolean tracker_result_store_real_get_iter (GtkTreeModel* base, GtkTreeIter* iter, GtkTreePath* path);
static gint tracker_result_store_real_get_n_columns (GtkTreeModel* base);
static GtkTreePath* tracker_result_store_real_get_path (GtkTreeModel* base, GtkTreeIter* iter);
static void tracker_result_store_fetch_thumbnail_data_free (gpointer _data);
static void tracker_result_store_fetch_thumbnail (TrackerResultStore* self, GtkTreeIter* iter, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_result_store_fetch_thumbnail_finish (TrackerResultStore* self, GAsyncResult* _res_);
static gboolean tracker_result_store_fetch_thumbnail_co (TrackerResultStoreFetchThumbnailData* data);
static void tracker_result_store_fetch_thumbnail_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gint tracker_result_store_get_icon_size (TrackerResultStore* self);
static void tracker_result_store_real_get_value (GtkTreeModel* base, GtkTreeIter* iter, gint column, GValue* value);
GdkPixbuf* tracker_pixbuf_new_from_name (GtkIconTheme* theme, const gchar* name, gint size);
static gboolean tracker_result_store_real_iter_children (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent);
static gboolean tracker_result_store_real_iter_has_child (GtkTreeModel* base, GtkTreeIter* iter);
static gint tracker_result_store_real_iter_n_children (GtkTreeModel* base, GtkTreeIter* iter);
static gboolean tracker_result_store_real_iter_next (GtkTreeModel* base, GtkTreeIter* iter);
static gboolean tracker_result_store_real_iter_nth_child (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent, gint n);
static gboolean tracker_result_store_real_iter_parent (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* child);
static void tracker_result_store_real_ref_node (GtkTreeModel* base, GtkTreeIter* iter);
static void tracker_result_store_real_unref_node (GtkTreeModel* base, GtkTreeIter* iter);
static void tracker_result_store_theme_changed (TrackerResultStore* self, GtkIconTheme* theme);
TrackerResultStore* tracker_result_store_new (gint _n_columns);
TrackerResultStore* tracker_result_store_construct (GType object_type, gint _n_columns);
static void _tracker_result_store_category_node_unref0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
void tracker_result_store_set_icon_size (TrackerResultStore* self, gint value);
static void _tracker_result_store_theme_changed_gtk_icon_theme_changed (GtkIconTheme* _sender, gpointer self);
void tracker_result_store_add_query (TrackerResultStore* self, TrackerQueryType type, TrackerQueryMatch match, ...);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static gchar** _vala_array_dup3 (gchar** self, int length);
static void _vala_array_add3 (TrackerResultStoreQueryData** array, int* length, int* size, const TrackerResultStoreQueryData* value);
gboolean tracker_result_store_has_results (TrackerResultStore* self);
void tracker_result_store_cancel_search (TrackerResultStore* self);
const gchar* tracker_result_store_get_search_term (TrackerResultStore* self);
void tracker_result_store_set_search_term (TrackerResultStore* self, const gchar* value);
gboolean tracker_result_store_get_active (TrackerResultStore* self);
enum  {
	TRACKER_RESULT_STORE_CATEGORY_NODE_DUMMY_PROPERTY
};
static void _vala_TrackerResultStoreResultNode_array_free (TrackerResultStoreResultNode* array, gint array_length);
static void tracker_result_store_category_node_finalize (TrackerResultStoreCategoryNode* obj);
enum  {
	TRACKER_RESULT_STORE_OPERATION_DUMMY_PROPERTY
};
static void tracker_result_store_operation_finalize (GObject* obj);
static gchar** _vala_array_dup4 (gchar** self, int length);
static gchar** _vala_array_dup5 (gchar** self, int length);
static void tracker_result_store_finalize (GObject* obj);
static void _vala_tracker_result_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_result_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _vala_TrackerResultStoreQueryData_array_free (TrackerResultStoreQueryData* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			tracker_result_store_query_data_destroy (&array[i]);
		}
	}
	g_free (array);
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	g_return_if_fail (self != NULL);
	g_ptr_array_set_size (self, value);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static TrackerResultStoreOperation* tracker_result_store_find_operation (TrackerResultStore* self, GPtrArray* array, TrackerResultStoreCategoryNode* node, gint offset) {
	TrackerResultStoreOperation* result = NULL;
	TrackerResultStoreOperation* op = NULL;
	gint i = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (array != NULL, NULL);
	{
		gboolean _tmp0_;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gint _tmp1_;
			gconstpointer _tmp2_ = NULL;
			TrackerResultStoreOperation* _tmp3_;
			gboolean _tmp4_ = FALSE;
			if (!_tmp0_) {
				i++;
			}
			_tmp0_ = FALSE;
			_tmp1_ = g_ptr_array_get_length (array);
			if (!(i < _tmp1_)) {
				break;
			}
			_tmp2_ = g_ptr_array_index (array, (guint) i);
			_tmp3_ = _g_object_ref0 ((TrackerResultStoreOperation*) _tmp2_);
			_g_object_unref0 (op);
			op = _tmp3_;
			if (op->node == node) {
				_tmp4_ = op->offset == offset;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				result = op;
				return result;
			}
		}
	}
	result = NULL;
	_g_object_unref0 (op);
	return result;
}


static void tracker_result_store_load_operation_data_free (gpointer _data) {
	TrackerResultStoreLoadOperationData* data;
	data = _data;
	_g_object_unref0 (data->op);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerResultStoreLoadOperationData, data);
}


static void tracker_result_store_load_operation (TrackerResultStore* self, TrackerResultStoreOperation* op, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResultStoreLoadOperationData* _data_;
	_data_ = g_slice_new0 (TrackerResultStoreLoadOperationData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_result_store_load_operation);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_result_store_load_operation_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->op = _g_object_ref0 (op);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_result_store_load_operation_co (_data_);
}


static void tracker_result_store_load_operation_finish (TrackerResultStore* self, GAsyncResult* _res_) {
	TrackerResultStoreLoadOperationData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_result_store_load_operation_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResultStoreLoadOperationData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_result_store_load_operation_co (data);
}


static gboolean tracker_result_store_load_operation_co (TrackerResultStoreLoadOperationData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->cursor = NULL;
	g_cancellable_set_error_if_cancelled (data->cancellable, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			goto __catch6_g_io_error;
		}
		_g_object_unref0 (data->cursor);
		_tracker_query_unref0 (data->query);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_query_new ();
	_tracker_query_unref0 (data->query);
	data->query = data->_tmp0_;
	tracker_query_set_criteria (data->query, data->self->priv->_search_term);
	tracker_query_set_limit (data->query, (guint) 100);
	tracker_query_set_offset (data->query, (guint) data->op->offset);
	data->_state_ = 1;
	tracker_query_perform_async (data->query, (*data->op->node->query).type, (*data->op->node->query).match, (*data->op->node->query).args, (*data->op->node->query).args_length1, data->cancellable, tracker_result_store_load_operation_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = tracker_query_perform_finish (data->query, data->_res_, &data->_inner_error_);
	data->_tmp2_ = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			goto __catch6_g_io_error;
		}
		_g_object_unref0 (data->cursor);
		_tracker_query_unref0 (data->query);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->cursor);
	data->cursor = data->_tmp2_;
	g_cancellable_set_error_if_cancelled (data->cancellable, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			goto __catch6_g_io_error;
		}
		_g_object_unref0 (data->cursor);
		_tracker_query_unref0 (data->query);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->cursor != NULL) {
		{
			data->i = data->op->offset;
			data->_tmp3_ = TRUE;
			while (TRUE) {
				if (!data->_tmp3_) {
					data->i++;
				}
				data->_tmp3_ = FALSE;
				if (!(data->i < (data->op->offset + 100))) {
					break;
				}
				data->b = FALSE;
				data->_state_ = 2;
				tracker_sparql_cursor_next_async (data->cursor, data->cancellable, tracker_result_store_load_operation_ready, data);
				return FALSE;
				_state_2:
				data->_tmp4_ = tracker_sparql_cursor_next_finish (data->cursor, data->_res_, &data->_inner_error_);
				data->_tmp5_ = data->_tmp4_;
				if (data->_inner_error_ != NULL) {
					goto __catch7_g_error;
				}
				data->b = data->_tmp5_;
				goto __finally7;
				__catch7_g_error:
				{
					data->ge = data->_inner_error_;
					data->_inner_error_ = NULL;
					g_warning ("tracker-result-store.vala:108: Could not fetch row: %s\n", data->ge->message);
					_g_error_free0 (data->ge);
				}
				__finally7:
				if (data->_inner_error_ != NULL) {
					_gtk_tree_path_free0 (data->path);
					if (data->_inner_error_->domain == G_IO_ERROR) {
						goto __catch6_g_io_error;
					}
					_gtk_tree_path_free0 (data->path);
					_g_object_unref0 (data->cursor);
					_tracker_query_unref0 (data->query);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
				if (!data->b) {
					_gtk_tree_path_free0 (data->path);
					break;
				}
				data->_result_ = &data->op->node->results[data->i];
				{
					data->j = 0;
					data->_tmp6_ = TRUE;
					while (TRUE) {
						if (!data->_tmp6_) {
							data->j++;
						}
						data->_tmp6_ = FALSE;
						if (!(data->j < data->self->priv->n_columns)) {
							break;
						}
						if (data->j == (data->self->priv->n_columns - 1)) {
							data->_tmp7_ = NULL;
							data->_tmp7_ = tracker_sparql_cursor_get_string (data->cursor, data->j, NULL);
							data->_tmp8_ = NULL;
							data->_tmp8_ = g_markup_escape_text (data->_tmp7_, (gssize) (-1));
							data->_tmp9_ = data->_tmp8_;
							_g_free0 ((*data->_result_).values[data->j]);
							(*data->_result_).values[data->j] = data->_tmp9_;
						} else {
							data->_tmp10_ = NULL;
							data->_tmp10_ = tracker_sparql_cursor_get_string (data->cursor, data->j, NULL);
							data->_tmp11_ = g_strdup (data->_tmp10_);
							data->_tmp12_ = data->_tmp11_;
							_g_free0 ((*data->_result_).values[data->j]);
							(*data->_result_).values[data->j] = data->_tmp12_;
						}
					}
				}
				memset (&data->_tmp13_, 0, sizeof (GtkTreeIter));
				memset (&data->_tmp13_, 0, sizeof (GtkTreeIter));
				memset (&data->_tmp14_, 0, sizeof (GtkTreeIter));
				data->_tmp14_ = data->_tmp13_;
				data->iter = data->_tmp14_;
				data->iter.stamp = data->self->priv->timestamp;
				data->iter.user_data = data->op->node;
				data->iter.user_data2 = data->_result_;
				data->_tmp15_ = NULL;
				data->_tmp15_ = GINT_TO_POINTER (data->i);
				data->iter.user_data3 = data->_tmp15_;
				data->_tmp16_ = NULL;
				data->_tmp16_ = gtk_tree_model_get_path ((GtkTreeModel*) data->self, &data->iter);
				_gtk_tree_path_free0 (data->path);
				data->path = data->_tmp16_;
				gtk_tree_model_row_changed ((GtkTreeModel*) data->self, data->path, &data->iter);
				_gtk_tree_path_free0 (data->path);
			}
		}
	}
	g_ptr_array_remove (data->self->priv->running_operations, data->op);
	goto __finally6;
	__catch6_g_io_error:
	{
		data->ie = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp17_ = g_cancellable_is_cancelled (data->cancellable);
		if (!data->_tmp17_) {
			g_warning ("tracker-result-store.vala:141: Could not load items: %s\n", data->ie->message);
		}
		_g_error_free0 (data->ie);
		_g_object_unref0 (data->cursor);
		_tracker_query_unref0 (data->query);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally6:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->cursor);
		_tracker_query_unref0 (data->query);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp18_ = g_ptr_array_get_length (data->self->priv->delayed_operations);
	if (data->_tmp18_ > 0) {
		data->_tmp19_ = g_ptr_array_get_length (data->self->priv->delayed_operations);
		data->_tmp20_ = NULL;
		data->_tmp20_ = g_ptr_array_index (data->self->priv->delayed_operations, (guint) (data->_tmp19_ - 1));
		data->_tmp21_ = _g_object_ref0 ((TrackerResultStoreOperation*) data->_tmp20_);
		_g_object_unref0 (data->next_to_start);
		data->next_to_start = data->_tmp21_;
		g_ptr_array_remove (data->self->priv->delayed_operations, data->next_to_start);
		data->_tmp22_ = _g_object_ref0 (data->next_to_start);
		g_ptr_array_add (data->self->priv->running_operations, data->_tmp22_);
		tracker_result_store_load_operation (data->self, data->next_to_start, data->cancellable, NULL, NULL);
		_g_object_unref0 (data->next_to_start);
	} else {
		data->_tmp23_ = g_ptr_array_get_length (data->self->priv->running_operations);
		if (data->_tmp23_ == 0) {
			tracker_result_store_set_active (data->self, FALSE);
		}
	}
	_g_object_unref0 (data->cursor);
	_tracker_query_unref0 (data->query);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gpointer _tracker_result_store_category_node_ref0 (gpointer self) {
	return self ? tracker_result_store_category_node_ref (self) : NULL;
}


static void tracker_result_store_add_operation (TrackerResultStore* self, TrackerResultStoreCategoryNode* cat, gint offset) {
	TrackerResultStoreOperation* _tmp0_ = NULL;
	TrackerResultStoreOperation* op;
	TrackerResultStoreOperation* old = NULL;
	TrackerResultStoreCategoryNode* _tmp1_;
	TrackerResultStoreOperation* _tmp2_ = NULL;
	TrackerResultStoreOperation* _tmp3_ = NULL;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cat != NULL);
	_tmp0_ = tracker_result_store_operation_new ();
	op = _tmp0_;
	_tmp1_ = _tracker_result_store_category_node_ref0 (cat);
	_tracker_result_store_category_node_unref0 (op->node);
	op->node = _tmp1_;
	op->offset = offset;
	_tmp2_ = tracker_result_store_find_operation (self, self->priv->running_operations, cat, offset);
	if (_tmp2_ != NULL) {
		_g_object_unref0 (old);
		_g_object_unref0 (op);
		return;
	}
	_tmp3_ = tracker_result_store_find_operation (self, self->priv->delayed_operations, cat, offset);
	_g_object_unref0 (old);
	old = _tmp3_;
	if (old != NULL) {
		g_ptr_array_remove (self->priv->delayed_operations, old);
	}
	tracker_result_store_set_active (self, TRUE);
	_tmp4_ = g_ptr_array_get_length (self->priv->running_operations);
	if (_tmp4_ < 2) {
		TrackerResultStoreOperation* _tmp5_;
		_tmp5_ = _g_object_ref0 (op);
		g_ptr_array_add (self->priv->running_operations, _tmp5_);
		tracker_result_store_load_operation (self, op, self->priv->cancellable, NULL, NULL);
	} else {
		TrackerResultStoreOperation* _tmp6_;
		_tmp6_ = _g_object_ref0 (op);
		g_ptr_array_add (self->priv->delayed_operations, _tmp6_);
	}
	_g_object_unref0 (old);
	_g_object_unref0 (op);
}


static void tracker_result_store_load_category_data_free (gpointer _data) {
	TrackerResultStoreLoadCategoryData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->self);
	g_slice_free (TrackerResultStoreLoadCategoryData, data);
}


static void tracker_result_store_load_category (TrackerResultStore* self, TrackerResultStoreQueryData* query_data, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResultStoreLoadCategoryData* _data_;
	_data_ = g_slice_new0 (TrackerResultStoreLoadCategoryData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_result_store_load_category);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_result_store_load_category_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->query_data = query_data;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_result_store_load_category_co (_data_);
}


static void tracker_result_store_load_category_finish (TrackerResultStore* self, GAsyncResult* _res_) {
	TrackerResultStoreLoadCategoryData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_result_store_load_category_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResultStoreLoadCategoryData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_result_store_load_category_co (data);
}


static gboolean tracker_result_store_load_category_co (TrackerResultStoreLoadCategoryData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->count = (guint) 0;
	g_cancellable_set_error_if_cancelled (data->cancellable, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			goto __catch8_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp0_ = NULL;
	data->_tmp0_ = tracker_query_new ();
	data->query = data->_tmp0_;
	tracker_query_set_criteria (data->query, data->self->priv->_search_term);
	data->_state_ = 1;
	tracker_query_get_count_async (data->query, (*data->query_data).type, (*data->query_data).match, data->cancellable, tracker_result_store_load_category_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = tracker_query_get_count_finish (data->query, data->_res_, &data->_inner_error_);
	data->_tmp2_ = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		_tracker_query_unref0 (data->query);
		if (data->_inner_error_->domain == G_IO_ERROR) {
			goto __catch8_g_io_error;
		}
		_tracker_query_unref0 (data->query);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->count = data->_tmp2_;
	g_cancellable_set_error_if_cancelled (data->cancellable, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		_tracker_query_unref0 (data->query);
		if (data->_inner_error_->domain == G_IO_ERROR) {
			goto __catch8_g_io_error;
		}
		_tracker_query_unref0 (data->query);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_tracker_query_unref0 (data->query);
	goto __finally8;
	__catch8_g_io_error:
	{
		data->ie = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp3_ = g_cancellable_is_cancelled (data->cancellable);
		if (!data->_tmp3_) {
			g_warning ("tracker-result-store.vala:210: Could not get count: %s\n", data->ie->message);
		}
		_g_error_free0 (data->ie);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally8:
	if (data->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->count != 0) {
		data->_tmp4_ = NULL;
		data->_tmp4_ = tracker_result_store_category_node_new ();
		_tracker_result_store_category_node_unref0 (data->cat);
		data->cat = data->_tmp4_;
		data->cat->type = (*data->query_data).type;
		data->cat->query = data->query_data;
		data->_tmp5_ = (gint) data->count;
		data->cat->results = g_renew (TrackerResultStoreResultNode, data->cat->results, (gint) data->count);
		(data->_tmp5_ > data->cat->results_length1) ? memset (data->cat->results + data->cat->results_length1, 0, sizeof (TrackerResultStoreResultNode) * (data->_tmp5_ - data->cat->results_length1)) : NULL;
		data->cat->results_length1 = data->_tmp5_;
		data->cat->_results_size_ = data->_tmp5_;
		data->_tmp6_ = _tracker_result_store_category_node_ref0 (data->cat);
		g_ptr_array_add (data->self->priv->categories, data->_tmp6_);
		memset (&data->_tmp7_, 0, sizeof (GtkTreeIter));
		memset (&data->_tmp7_, 0, sizeof (GtkTreeIter));
		memset (&data->_tmp8_, 0, sizeof (GtkTreeIter));
		data->_tmp8_ = data->_tmp7_;
		data->iter = data->_tmp8_;
		data->iter.stamp = data->self->priv->timestamp;
		data->iter.user_data = data->cat;
		if (data->self->priv->queries_length1 > 1) {
			data->_tmp9_ = NULL;
			data->_tmp9_ = gtk_tree_model_get_path ((GtkTreeModel*) data->self, &data->iter);
			_gtk_tree_path_free0 (data->path);
			data->path = data->_tmp9_;
			gtk_tree_model_row_inserted ((GtkTreeModel*) data->self, data->path, &data->iter);
		}
		{
			data->i = 0;
			data->_tmp10_ = TRUE;
			while (TRUE) {
				if (!data->_tmp10_) {
					data->i++;
				}
				data->_tmp10_ = FALSE;
				if (!(data->i < data->count)) {
					break;
				}
				data->res = &data->cat->results[data->i];
				data->_tmp11_ = NULL;
				data->_tmp11_ = g_new0 (gchar*, data->self->priv->n_columns + 1);
				(*data->res).values = (_vala_array_free ((*data->res).values, (*data->res).values_length1, (GDestroyNotify) g_free), NULL);
				(*data->res).values = data->_tmp11_;
				(*data->res).values_length1 = data->self->priv->n_columns;
				(*data->res)._values_size_ = data->self->priv->n_columns;
				data->iter.user_data2 = data->res;
				data->_tmp12_ = NULL;
				data->_tmp12_ = GINT_TO_POINTER (data->i);
				data->iter.user_data3 = data->_tmp12_;
				data->_tmp13_ = NULL;
				data->_tmp13_ = gtk_tree_model_get_path ((GtkTreeModel*) data->self, &data->iter);
				_gtk_tree_path_free0 (data->path);
				data->path = data->_tmp13_;
				data->cat->count++;
				gtk_tree_model_row_inserted ((GtkTreeModel*) data->self, data->path, &data->iter);
			}
		}
		if (data->self->priv->queries_length1 > 1) {
			data->iter.user_data2 = NULL;
			data->iter.user_data3 = NULL;
			data->_tmp14_ = NULL;
			data->_tmp14_ = gtk_tree_model_get_path ((GtkTreeModel*) data->self, &data->iter);
			_gtk_tree_path_free0 (data->path);
			data->path = data->_tmp14_;
			gtk_tree_model_row_changed ((GtkTreeModel*) data->self, data->path, &data->iter);
		}
		_gtk_tree_path_free0 (data->path);
		_tracker_result_store_category_node_unref0 (data->cat);
	}
	data->_tmp15_ = g_ptr_array_get_length (data->self->priv->running_operations);
	if (data->_tmp15_ == 0) {
		tracker_result_store_set_active (data->self, FALSE);
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_result_store_clear_results (TrackerResultStore* self) {
	gint j = 0;
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gint _tmp0_;
		gconstpointer _tmp1_ = NULL;
		TrackerResultStoreCategoryNode* _tmp2_;
		TrackerResultStoreCategoryNode* cat;
		GtkTreeIter iter = {0};
		GtkTreePath* path = NULL;
		GtkTreeIter _tmp3_ = {0};
		GtkTreeIter _tmp4_ = {0};
		_tmp0_ = g_ptr_array_get_length (self->priv->categories);
		if (!(_tmp0_ > 0)) {
			break;
		}
		_tmp1_ = g_ptr_array_index (self->priv->categories, (guint) 0);
		_tmp2_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp1_);
		cat = _tmp2_;
		if (cat->results_length1 == 0) {
			_gtk_tree_path_free0 (path);
			_tracker_result_store_category_node_unref0 (cat);
			continue;
		}
		memset (&_tmp3_, 0, sizeof (GtkTreeIter));
		_tmp4_ = _tmp3_;
		iter = _tmp4_;
		iter.stamp = self->priv->timestamp;
		iter.user_data = cat;
		{
			gboolean _tmp5_;
			j = cat->count - 1;
			_tmp5_ = TRUE;
			while (TRUE) {
				void* _tmp6_ = NULL;
				GtkTreePath* _tmp7_ = NULL;
				if (!_tmp5_) {
					j--;
				}
				_tmp5_ = FALSE;
				if (!(j >= 0)) {
					break;
				}
				iter.user_data2 = &cat->results[j];
				_tmp6_ = GINT_TO_POINTER (j);
				iter.user_data3 = _tmp6_;
				_tmp7_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &iter);
				_gtk_tree_path_free0 (path);
				path = _tmp7_;
				gtk_tree_model_row_deleted ((GtkTreeModel*) self, path);
				cat->count--;
			}
		}
		if (self->priv->queries_length1 > 1) {
			GtkTreePath* _tmp8_ = NULL;
			iter.user_data2 = NULL;
			iter.user_data3 = NULL;
			_tmp8_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &iter);
			_gtk_tree_path_free0 (path);
			path = _tmp8_;
			gtk_tree_model_row_deleted ((GtkTreeModel*) self, path);
		}
		g_ptr_array_remove (self->priv->categories, cat);
		_gtk_tree_path_free0 (path);
		_tracker_result_store_category_node_unref0 (cat);
	}
}


static gint tracker_result_store_find_nth_category_index (TrackerResultStore* self, TrackerResultStoreCategoryNode* node, gint n) {
	gint result = 0;
	gint i = 0;
	g_return_val_if_fail (self != NULL, 0);
	if (node == NULL) {
		result = n;
		return result;
	}
	{
		gboolean _tmp0_;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gint _tmp1_;
			TrackerResultStoreCategoryNode* cat = NULL;
			gconstpointer _tmp2_ = NULL;
			TrackerResultStoreCategoryNode* _tmp3_;
			if (!_tmp0_) {
				i++;
			}
			_tmp0_ = FALSE;
			_tmp1_ = g_ptr_array_get_length (self->priv->categories);
			if (!(i < _tmp1_)) {
				break;
			}
			_tmp2_ = g_ptr_array_index (self->priv->categories, (guint) i);
			_tmp3_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp2_);
			_tracker_result_store_category_node_unref0 (cat);
			cat = _tmp3_;
			if (cat == node) {
				result = i + n;
				_tracker_result_store_category_node_unref0 (cat);
				return result;
			}
			_tracker_result_store_category_node_unref0 (cat);
		}
	}
	result = -1;
	return result;
}


static gint tracker_result_store_filled_categories_count (TrackerResultStore* self) {
	gint result = 0;
	gint i = 0;
	gint n;
	g_return_val_if_fail (self != NULL, 0);
	n = 0;
	{
		gboolean _tmp0_;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gint _tmp1_;
			TrackerResultStoreCategoryNode* cat = NULL;
			gconstpointer _tmp2_ = NULL;
			TrackerResultStoreCategoryNode* _tmp3_;
			if (!_tmp0_) {
				i++;
			}
			_tmp0_ = FALSE;
			_tmp1_ = g_ptr_array_get_length (self->priv->categories);
			if (!(i < _tmp1_)) {
				break;
			}
			_tmp2_ = g_ptr_array_index (self->priv->categories, (guint) i);
			_tmp3_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp2_);
			_tracker_result_store_category_node_unref0 (cat);
			cat = _tmp3_;
			if (cat->count > 0) {
				n++;
			}
			_tracker_result_store_category_node_unref0 (cat);
		}
	}
	result = n;
	return result;
}


static GType tracker_result_store_real_get_column_type (GtkTreeModel* base, gint index_) {
	TrackerResultStore * self;
	GType result = 0UL;
	self = (TrackerResultStore*) base;
	if (index_ == self->priv->n_columns) {
		result = GDK_TYPE_PIXBUF;
		return result;
	} else {
		if (index_ == (self->priv->n_columns + 1)) {
			result = TRACKER_QUERY_TYPE_TYPE;
			return result;
		} else {
			result = G_TYPE_STRING;
			return result;
		}
	}
}


static GtkTreeModelFlags tracker_result_store_real_get_flags (GtkTreeModel* base) {
	TrackerResultStore * self;
	GtkTreeModelFlags result = 0;
	GtkTreeModelFlags flags = 0;
	self = (TrackerResultStore*) base;
	flags = GTK_TREE_MODEL_ITERS_PERSIST;
	if (self->priv->queries_length1 == 1) {
		flags = flags | GTK_TREE_MODEL_LIST_ONLY;
	}
	result = flags;
	return result;
}


static gboolean tracker_result_store_real_get_iter (GtkTreeModel* base, GtkTreeIter* iter, GtkTreePath* path) {
	TrackerResultStore * self;
	GtkTreeIter _iter = {0};
	gboolean result = FALSE;
	gint _tmp0_;
	gint* _tmp1_ = NULL;
	gint* indices;
	gint indices_length1;
	gint _indices_size_;
	TrackerResultStoreCategoryNode* cat = NULL;
	gint i;
	gint _tmp8_;
	self = (TrackerResultStore*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp1_ = gtk_tree_path_get_indices_with_depth (path, &_tmp0_);
	indices = _tmp1_;
	indices_length1 = _tmp0_;
	_indices_size_ = _tmp0_;
	i = 0;
	if (self->priv->queries_length1 > 1) {
		gint _tmp2_;
		gconstpointer _tmp3_ = NULL;
		TrackerResultStoreCategoryNode* _tmp4_;
		_tmp2_ = g_ptr_array_get_length (self->priv->categories);
		if (indices[i] >= _tmp2_) {
			_iter.stamp = 0;
			result = FALSE;
			_tracker_result_store_category_node_unref0 (cat);
			if (iter) {
				*iter = _iter;
			}
			return result;
		}
		_tmp3_ = g_ptr_array_index (self->priv->categories, (guint) indices[i]);
		_tmp4_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp3_);
		_tracker_result_store_category_node_unref0 (cat);
		cat = _tmp4_;
		i++;
	} else {
		gint _tmp5_;
		gconstpointer _tmp6_ = NULL;
		TrackerResultStoreCategoryNode* _tmp7_;
		_tmp5_ = g_ptr_array_get_length (self->priv->categories);
		if (_tmp5_ == 0) {
			_iter.stamp = 0;
			result = FALSE;
			_tracker_result_store_category_node_unref0 (cat);
			if (iter) {
				*iter = _iter;
			}
			return result;
		}
		_tmp6_ = g_ptr_array_index (self->priv->categories, (guint) 0);
		_tmp7_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp6_);
		_tracker_result_store_category_node_unref0 (cat);
		cat = _tmp7_;
	}
	_iter.stamp = self->priv->timestamp;
	_iter.user_data = cat;
	_tmp8_ = gtk_tree_path_get_depth (path);
	if (_tmp8_ == (i + 1)) {
		void* _tmp9_ = NULL;
		if (indices[i] >= cat->count) {
			_iter.stamp = 0;
			result = FALSE;
			_tracker_result_store_category_node_unref0 (cat);
			if (iter) {
				*iter = _iter;
			}
			return result;
		}
		_iter.user_data2 = &cat->results[indices[i]];
		_tmp9_ = GINT_TO_POINTER (indices[i]);
		_iter.user_data3 = _tmp9_;
	}
	result = TRUE;
	_tracker_result_store_category_node_unref0 (cat);
	if (iter) {
		*iter = _iter;
	}
	return result;
}


static gint tracker_result_store_real_get_n_columns (GtkTreeModel* base) {
	TrackerResultStore * self;
	gint result = 0;
	self = (TrackerResultStore*) base;
	result = self->priv->n_columns + self->priv->n_extra_columns;
	return result;
}


static GtkTreePath* tracker_result_store_real_get_path (GtkTreeModel* base, GtkTreeIter* iter) {
	TrackerResultStore * self;
	GtkTreePath* result = NULL;
	GtkTreePath* _tmp0_ = NULL;
	GtkTreePath* path;
	TrackerResultStoreCategoryNode* cat = NULL;
	gint i = 0;
	self = (TrackerResultStore*) base;
	_tmp0_ = gtk_tree_path_new ();
	path = _tmp0_;
	if (self->priv->queries_length1 > 1) {
		{
			gboolean _tmp1_;
			i = 0;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gconstpointer _tmp3_ = NULL;
				TrackerResultStoreCategoryNode* _tmp4_;
				if (!_tmp1_) {
					i++;
				}
				_tmp1_ = FALSE;
				_tmp2_ = g_ptr_array_get_length (self->priv->categories);
				if (!(i < _tmp2_)) {
					break;
				}
				_tmp3_ = g_ptr_array_index (self->priv->categories, (guint) i);
				_tmp4_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp3_);
				_tracker_result_store_category_node_unref0 (cat);
				cat = _tmp4_;
				if (cat == (*iter).user_data) {
					gtk_tree_path_append_index (path, i);
					break;
				}
			}
		}
	}
	if ((*iter).user_data2 != NULL) {
		gtk_tree_path_append_index (path, (gint) ((glong) (*iter).user_data3));
	}
	result = path;
	_tracker_result_store_category_node_unref0 (cat);
	return result;
}


static void tracker_result_store_fetch_thumbnail_data_free (gpointer _data) {
	TrackerResultStoreFetchThumbnailData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (TrackerResultStoreFetchThumbnailData, data);
}


static void tracker_result_store_fetch_thumbnail (TrackerResultStore* self, GtkTreeIter* iter, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResultStoreFetchThumbnailData* _data_;
	_data_ = g_slice_new0 (TrackerResultStoreFetchThumbnailData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_result_store_fetch_thumbnail);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_result_store_fetch_thumbnail_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->iter = *iter;
	tracker_result_store_fetch_thumbnail_co (_data_);
}


static void tracker_result_store_fetch_thumbnail_finish (TrackerResultStore* self, GAsyncResult* _res_) {
	TrackerResultStoreFetchThumbnailData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_result_store_fetch_thumbnail_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResultStoreFetchThumbnailData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	tracker_result_store_fetch_thumbnail_co (data);
}


static gboolean tracker_result_store_fetch_thumbnail_co (TrackerResultStoreFetchThumbnailData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->pixbuf = NULL;
	data->_result_ = data->iter.user_data2;
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_file_new_for_uri ((*data->_result_).values[1]);
	_g_object_unref0 (data->file);
	data->file = data->_tmp0_;
	data->_state_ = 1;
	g_file_query_info_async (data->file, "thumbnail::path,standard::icon", G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, data->self->priv->cancellable, tracker_result_store_fetch_thumbnail_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_file_query_info_finish (data->file, data->_res_, &data->_inner_error_);
	data->_tmp2_ = data->_tmp1_;
	if (data->_inner_error_ != NULL) {
		goto __catch9_g_error;
	}
	_g_object_unref0 (data->info);
	data->info = data->_tmp2_;
	goto __finally9;
	__catch9_g_error:
	{
		data->ie = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("tracker-result-store.vala:475: Could not get thumbnail: %s", data->ie->message);
		_g_error_free0 (data->ie);
		_g_object_unref0 (data->pixbuf);
		_g_free0 (data->thumb_path);
		_g_object_unref0 (data->info);
		_g_object_unref0 (data->file);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally9:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->pixbuf);
		_g_free0 (data->thumb_path);
		_g_object_unref0 (data->info);
		_g_object_unref0 (data->file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_file_info_get_attribute_byte_string (data->info, "thumbnail::path");
	data->_tmp4_ = g_strdup (data->_tmp3_);
	_g_free0 (data->thumb_path);
	data->thumb_path = data->_tmp4_;
	if (data->thumb_path != NULL) {
		data->_tmp5_ = NULL;
		data->_tmp5_ = gdk_pixbuf_new_from_file_at_size (data->thumb_path, data->self->priv->_icon_size, data->self->priv->_icon_size, &data->_inner_error_);
		data->_tmp6_ = data->_tmp5_;
		if (data->_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
		_g_object_unref0 (data->pixbuf);
		data->pixbuf = data->_tmp6_;
	} else {
		data->_tmp7_ = NULL;
		data->_tmp7_ = g_file_info_get_attribute_object (data->info, "standard::icon");
		data->_tmp8_ = _g_object_ref0 (G_ICON (data->_tmp7_));
		_g_object_unref0 (data->icon);
		data->icon = data->_tmp8_;
		if (data->icon == NULL) {
			_gtk_icon_info_free0 (data->icon_info);
			_g_object_unref0 (data->icon);
			_g_object_unref0 (data->pixbuf);
			_g_free0 (data->thumb_path);
			_g_object_unref0 (data->info);
			_g_object_unref0 (data->file);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		data->_tmp9_ = NULL;
		data->_tmp9_ = gdk_screen_get_default ();
		data->_tmp10_ = NULL;
		data->_tmp10_ = gtk_icon_theme_get_for_screen (data->_tmp9_);
		data->_tmp11_ = _g_object_ref0 (data->_tmp10_);
		data->theme = data->_tmp11_;
		data->_tmp12_ = NULL;
		data->_tmp12_ = gtk_icon_theme_lookup_by_gicon (data->theme, data->icon, data->self->priv->_icon_size, 0);
		_gtk_icon_info_free0 (data->icon_info);
		data->icon_info = data->_tmp12_;
		if (data->icon_info == NULL) {
			_g_object_unref0 (data->theme);
			_gtk_icon_info_free0 (data->icon_info);
			_g_object_unref0 (data->icon);
			_g_object_unref0 (data->pixbuf);
			_g_free0 (data->thumb_path);
			_g_object_unref0 (data->info);
			_g_object_unref0 (data->file);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		data->_tmp13_ = NULL;
		data->_tmp13_ = gtk_icon_info_load_icon (data->icon_info, &data->_inner_error_);
		data->_tmp14_ = data->_tmp13_;
		if (data->_inner_error_ != NULL) {
			_g_object_unref0 (data->theme);
			_gtk_icon_info_free0 (data->icon_info);
			_g_object_unref0 (data->icon);
			goto __catch10_g_error;
		}
		_g_object_unref0 (data->pixbuf);
		data->pixbuf = data->_tmp14_;
		_g_object_unref0 (data->theme);
		_gtk_icon_info_free0 (data->icon_info);
		_g_object_unref0 (data->icon);
	}
	goto __finally10;
	__catch10_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("tracker-result-store.vala:504: Could not get icon pixbuf: %s\n", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally10:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->pixbuf);
		_g_free0 (data->thumb_path);
		_g_object_unref0 (data->info);
		_g_object_unref0 (data->file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->pixbuf != NULL) {
		data->_tmp15_ = _g_object_ref0 (data->pixbuf);
		_g_object_unref0 ((*data->_result_).pixbuf);
		(*data->_result_).pixbuf = data->_tmp15_;
		data->_tmp16_ = NULL;
		data->_tmp16_ = gtk_tree_model_get_path ((GtkTreeModel*) data->self, &data->iter);
		_gtk_tree_path_free0 (data->path);
		data->path = data->_tmp16_;
		gtk_tree_model_row_changed ((GtkTreeModel*) data->self, data->path, &data->iter);
		_gtk_tree_path_free0 (data->path);
	}
	_g_object_unref0 (data->pixbuf);
	_g_free0 (data->thumb_path);
	_g_object_unref0 (data->info);
	_g_object_unref0 (data->file);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void tracker_result_store_real_get_value (GtkTreeModel* base, GtkTreeIter* iter, gint column, GValue* value) {
	TrackerResultStore * self;
	GValue _value = {0};
	TrackerResultStoreCategoryNode* cat = NULL;
	TrackerResultStoreCategoryNode* _tmp0_;
	GType _tmp1_;
	self = (TrackerResultStore*) base;
	if (column >= (self->priv->n_columns + self->priv->n_extra_columns)) {
		_tracker_result_store_category_node_unref0 (cat);
		if (value) {
			*value = _value;
		} else {
			G_IS_VALUE (&_value) ? (g_value_unset (&_value), NULL) : NULL;
		}
		return;
	}
	_tmp0_ = _tracker_result_store_category_node_ref0 (TRACKER_RESULT_STORE_CATEGORY_NODE ((*iter).user_data));
	_tracker_result_store_category_node_unref0 (cat);
	cat = _tmp0_;
	_tmp1_ = gtk_tree_model_get_column_type ((GtkTreeModel*) self, column);
	g_value_init (&_value, _tmp1_);
	if (column == (self->priv->n_columns + 1)) {
		g_value_set_enum (&_value, (gint) cat->type);
		_tracker_result_store_category_node_unref0 (cat);
		if (value) {
			*value = _value;
		} else {
			G_IS_VALUE (&_value) ? (g_value_unset (&_value), NULL) : NULL;
		}
		return;
	}
	if ((*iter).user_data2 == NULL) {
		if (column == self->priv->n_columns) {
			GdkPixbuf* pixbuf = NULL;
			GdkPixbuf* _tmp2_;
			_tmp2_ = _g_object_ref0 (cat->pixbuf);
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp2_;
			if (pixbuf == NULL) {
				GdkScreen* _tmp3_ = NULL;
				GtkIconTheme* _tmp4_ = NULL;
				GtkIconTheme* _tmp5_;
				GtkIconTheme* theme;
				gint size;
				_tmp3_ = gdk_screen_get_default ();
				_tmp4_ = gtk_icon_theme_get_for_screen (_tmp3_);
				_tmp5_ = _g_object_ref0 (_tmp4_);
				theme = _tmp5_;
				size = self->priv->_icon_size;
				switch (cat->type) {
					case TRACKER_QUERY_TYPE_APPLICATIONS:
					{
						GdkPixbuf* _tmp6_ = NULL;
						_tmp6_ = tracker_pixbuf_new_from_name (theme, "package-x-generic", size);
						_g_object_unref0 (pixbuf);
						pixbuf = _tmp6_;
						break;
					}
					case TRACKER_QUERY_TYPE_MUSIC:
					{
						GdkPixbuf* _tmp7_ = NULL;
						_tmp7_ = tracker_pixbuf_new_from_name (theme, "audio-x-generic", size);
						_g_object_unref0 (pixbuf);
						pixbuf = _tmp7_;
						break;
					}
					case TRACKER_QUERY_TYPE_IMAGES:
					{
						GdkPixbuf* _tmp8_ = NULL;
						_tmp8_ = tracker_pixbuf_new_from_name (theme, "image-x-generic", size);
						_g_object_unref0 (pixbuf);
						pixbuf = _tmp8_;
						break;
					}
					case TRACKER_QUERY_TYPE_VIDEOS:
					{
						GdkPixbuf* _tmp9_ = NULL;
						_tmp9_ = tracker_pixbuf_new_from_name (theme, "video-x-generic", size);
						_g_object_unref0 (pixbuf);
						pixbuf = _tmp9_;
						break;
					}
					case TRACKER_QUERY_TYPE_DOCUMENTS:
					{
						GdkPixbuf* _tmp10_ = NULL;
						_tmp10_ = tracker_pixbuf_new_from_name (theme, "x-office-presentation", size);
						_g_object_unref0 (pixbuf);
						pixbuf = _tmp10_;
						break;
					}
					case TRACKER_QUERY_TYPE_MAIL:
					{
						GdkPixbuf* _tmp11_ = NULL;
						_tmp11_ = tracker_pixbuf_new_from_name (theme, "emblem-mail", size);
						_g_object_unref0 (pixbuf);
						pixbuf = _tmp11_;
						break;
					}
					case TRACKER_QUERY_TYPE_FOLDERS:
					{
						GdkPixbuf* _tmp12_ = NULL;
						_tmp12_ = tracker_pixbuf_new_from_name (theme, "folder", size);
						_g_object_unref0 (pixbuf);
						pixbuf = _tmp12_;
						break;
					}
					case TRACKER_QUERY_TYPE_BOOKMARKS:
					{
						GdkPixbuf* _tmp13_ = NULL;
						_tmp13_ = tracker_pixbuf_new_from_name (theme, "web-browser", size);
						_g_object_unref0 (pixbuf);
						pixbuf = _tmp13_;
						break;
					}
					default:
					break;
				}
				_g_object_unref0 (theme);
			}
			g_value_set_object (&_value, (GObject*) pixbuf);
			_g_object_unref0 (pixbuf);
		}
	} else {
		TrackerResultStoreResultNode* _result_ = NULL;
		gint n_node = 0;
		_result_ = (*iter).user_data2;
		n_node = (gint) ((glong) (*iter).user_data3);
		if ((*_result_).values[0] != NULL) {
			if (column == self->priv->n_columns) {
				if ((*_result_).pixbuf != NULL) {
					g_value_set_object (&_value, (GObject*) (*_result_).pixbuf);
				} else {
					if (self->priv->queries_length1 == 1) {
						tracker_result_store_fetch_thumbnail (self, iter, NULL, NULL);
					}
				}
			} else {
				g_value_set_string (&_value, (*_result_).values[column]);
			}
		} else {
			n_node = n_node / 100;
			n_node = n_node * 100;
			tracker_result_store_add_operation (self, cat, n_node);
		}
	}
	_tracker_result_store_category_node_unref0 (cat);
	if (value) {
		*value = _value;
	} else {
		G_IS_VALUE (&_value) ? (g_value_unset (&_value), NULL) : NULL;
	}
}


static gboolean tracker_result_store_real_iter_children (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent) {
	TrackerResultStore * self;
	GtkTreeIter _iter = {0};
	gboolean result = FALSE;
	TrackerResultStoreCategoryNode* cat = NULL;
	TrackerResultStoreCategoryNode* _tmp6_;
	void* _tmp7_ = NULL;
	self = (TrackerResultStore*) base;
	if (parent == NULL) {
		gint _tmp0_;
		_tmp0_ = g_ptr_array_get_length (self->priv->categories);
		if (_tmp0_ == 0) {
			_iter.stamp = 0;
			result = FALSE;
			_tracker_result_store_category_node_unref0 (cat);
			if (iter) {
				*iter = _iter;
			}
			return result;
		}
		if (self->priv->queries_length1 > 1) {
			gint i = 0;
			gint _tmp1_;
			gconstpointer _tmp2_ = NULL;
			TrackerResultStoreCategoryNode* _tmp3_;
			_tmp1_ = tracker_result_store_find_nth_category_index (self, NULL, 0);
			i = _tmp1_;
			_tmp2_ = g_ptr_array_index (self->priv->categories, (guint) i);
			_tmp3_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp2_);
			_tracker_result_store_category_node_unref0 (cat);
			cat = _tmp3_;
			_iter.stamp = self->priv->timestamp;
			_iter.user_data = cat;
			result = TRUE;
			_tracker_result_store_category_node_unref0 (cat);
			if (iter) {
				*iter = _iter;
			}
			return result;
		} else {
			gconstpointer _tmp4_ = NULL;
			void* _tmp5_ = NULL;
			_iter.stamp = self->priv->timestamp;
			_tmp4_ = g_ptr_array_index (self->priv->categories, (guint) 0);
			_iter.user_data = (TrackerResultStoreCategoryNode*) _tmp4_;
			_iter.user_data2 = &cat->results[0];
			_tmp5_ = GINT_TO_POINTER (0);
			_iter.user_data3 = _tmp5_;
			result = TRUE;
			_tracker_result_store_category_node_unref0 (cat);
			if (iter) {
				*iter = _iter;
			}
			return result;
		}
	}
	if ((*parent).user_data2 != NULL) {
		_iter.stamp = 0;
		result = FALSE;
		_tracker_result_store_category_node_unref0 (cat);
		if (iter) {
			*iter = _iter;
		}
		return result;
	}
	_tmp6_ = _tracker_result_store_category_node_ref0 (TRACKER_RESULT_STORE_CATEGORY_NODE ((*parent).user_data));
	_tracker_result_store_category_node_unref0 (cat);
	cat = _tmp6_;
	if (cat->results_length1 <= 0) {
		_iter.stamp = 0;
		result = FALSE;
		_tracker_result_store_category_node_unref0 (cat);
		if (iter) {
			*iter = _iter;
		}
		return result;
	}
	_iter.stamp = self->priv->timestamp;
	_iter.user_data = cat;
	_iter.user_data2 = &cat->results[0];
	_tmp7_ = GINT_TO_POINTER (0);
	_iter.user_data3 = _tmp7_;
	result = TRUE;
	_tracker_result_store_category_node_unref0 (cat);
	if (iter) {
		*iter = _iter;
	}
	return result;
}


static gboolean tracker_result_store_real_iter_has_child (GtkTreeModel* base, GtkTreeIter* iter) {
	TrackerResultStore * self;
	gboolean result = FALSE;
	self = (TrackerResultStore*) base;
	if ((*iter).user_data2 == NULL) {
		TrackerResultStoreCategoryNode* cat = NULL;
		TrackerResultStoreCategoryNode* _tmp0_;
		_tmp0_ = _tracker_result_store_category_node_ref0 (TRACKER_RESULT_STORE_CATEGORY_NODE ((*iter).user_data));
		_tracker_result_store_category_node_unref0 (cat);
		cat = _tmp0_;
		result = cat->count > 0;
		_tracker_result_store_category_node_unref0 (cat);
		return result;
	}
	result = FALSE;
	return result;
}


static gint tracker_result_store_real_iter_n_children (GtkTreeModel* base, GtkTreeIter* iter) {
	TrackerResultStore * self;
	gint result = 0;
	TrackerResultStoreCategoryNode* _tmp2_;
	TrackerResultStoreCategoryNode* cat;
	self = (TrackerResultStore*) base;
	if (iter == NULL) {
		if (self->priv->queries_length1 > 1) {
			gint _tmp0_;
			_tmp0_ = g_ptr_array_get_length (self->priv->categories);
			result = _tmp0_ - 1;
			return result;
		} else {
			gconstpointer _tmp1_ = NULL;
			_tmp1_ = g_ptr_array_index (self->priv->categories, (guint) 0);
			result = ((TrackerResultStoreCategoryNode*) _tmp1_)->count;
			return result;
		}
	}
	if ((*iter).user_data2 != NULL) {
		result = -1;
		return result;
	}
	_tmp2_ = _tracker_result_store_category_node_ref0 (TRACKER_RESULT_STORE_CATEGORY_NODE ((*iter).user_data));
	cat = _tmp2_;
	result = cat->count;
	_tracker_result_store_category_node_unref0 (cat);
	return result;
}


static gboolean tracker_result_store_real_iter_next (GtkTreeModel* base, GtkTreeIter* iter) {
	TrackerResultStore * self;
	gboolean result = FALSE;
	TrackerResultStoreCategoryNode* cat = NULL;
	gint i = 0;
	TrackerResultStoreCategoryNode* _tmp0_;
	self = (TrackerResultStore*) base;
	_tmp0_ = _tracker_result_store_category_node_ref0 (TRACKER_RESULT_STORE_CATEGORY_NODE ((*iter).user_data));
	_tracker_result_store_category_node_unref0 (cat);
	cat = _tmp0_;
	if ((*iter).user_data2 == NULL) {
		gint _tmp1_;
		gboolean _tmp2_ = FALSE;
		gconstpointer _tmp4_ = NULL;
		_tmp1_ = tracker_result_store_find_nth_category_index (self, cat, 1);
		i = _tmp1_;
		if (i < 0) {
			_tmp2_ = TRUE;
		} else {
			gint _tmp3_;
			_tmp3_ = g_ptr_array_get_length (self->priv->categories);
			_tmp2_ = i >= _tmp3_;
		}
		if (_tmp2_) {
			(*iter).stamp = 0;
			result = FALSE;
			_tracker_result_store_category_node_unref0 (cat);
			return result;
		}
		(*iter).stamp = self->priv->timestamp;
		_tmp4_ = g_ptr_array_index (self->priv->categories, (guint) i);
		(*iter).user_data = (TrackerResultStoreCategoryNode*) _tmp4_;
		result = TRUE;
		_tracker_result_store_category_node_unref0 (cat);
		return result;
	} else {
		void* _tmp5_ = NULL;
		i = (gint) ((glong) (*iter).user_data3);
		i++;
		if (i >= cat->count) {
			(*iter).stamp = 0;
			result = FALSE;
			_tracker_result_store_category_node_unref0 (cat);
			return result;
		}
		(*iter).user_data2 = &cat->results[i];
		_tmp5_ = GINT_TO_POINTER (i);
		(*iter).user_data3 = _tmp5_;
		result = TRUE;
		_tracker_result_store_category_node_unref0 (cat);
		return result;
	}
	_tracker_result_store_category_node_unref0 (cat);
}


static gboolean tracker_result_store_real_iter_nth_child (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent, gint n) {
	TrackerResultStore * self;
	GtkTreeIter _iter = {0};
	gboolean result = FALSE;
	TrackerResultStoreCategoryNode* cat = NULL;
	self = (TrackerResultStore*) base;
	if (parent != NULL) {
		TrackerResultStoreCategoryNode* _tmp0_;
		void* _tmp1_ = NULL;
		_tmp0_ = _tracker_result_store_category_node_ref0 (TRACKER_RESULT_STORE_CATEGORY_NODE ((*parent).user_data));
		_tracker_result_store_category_node_unref0 (cat);
		cat = _tmp0_;
		if (n >= cat->count) {
			_iter.stamp = 0;
			result = FALSE;
			_tracker_result_store_category_node_unref0 (cat);
			if (iter) {
				*iter = _iter;
			}
			return result;
		}
		_iter.stamp = self->priv->timestamp;
		_iter.user_data = cat;
		_iter.user_data2 = &cat->results[n];
		_tmp1_ = GINT_TO_POINTER (n);
		_iter.user_data3 = _tmp1_;
		result = TRUE;
		_tracker_result_store_category_node_unref0 (cat);
		if (iter) {
			*iter = _iter;
		}
		return result;
	} else {
		gint index = 0;
		gconstpointer _tmp5_ = NULL;
		TrackerResultStoreCategoryNode* _tmp6_;
		if (self->priv->queries_length1 > 1) {
			gint _tmp2_;
			gboolean _tmp3_ = FALSE;
			_tmp2_ = tracker_result_store_find_nth_category_index (self, NULL, n);
			index = _tmp2_;
			if (index < 0) {
				_tmp3_ = TRUE;
			} else {
				gint _tmp4_;
				_tmp4_ = g_ptr_array_get_length (self->priv->categories);
				_tmp3_ = index >= _tmp4_;
			}
			if (_tmp3_) {
				_iter.stamp = 0;
				result = FALSE;
				_tracker_result_store_category_node_unref0 (cat);
				if (iter) {
					*iter = _iter;
				}
				return result;
			}
		} else {
			index = 0;
		}
		_tmp5_ = g_ptr_array_index (self->priv->categories, (guint) index);
		_tmp6_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp5_);
		_tracker_result_store_category_node_unref0 (cat);
		cat = _tmp6_;
		_iter.stamp = self->priv->timestamp;
		_iter.user_data = cat;
		if (self->priv->queries_length1 > 1) {
			void* _tmp7_ = NULL;
			_iter.user_data2 = &cat->results[0];
			_tmp7_ = GINT_TO_POINTER (0);
			_iter.user_data3 = _tmp7_;
		}
		result = TRUE;
		_tracker_result_store_category_node_unref0 (cat);
		if (iter) {
			*iter = _iter;
		}
		return result;
	}
	_tracker_result_store_category_node_unref0 (cat);
	if (iter) {
		*iter = _iter;
	}
}


static gboolean tracker_result_store_real_iter_parent (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* child) {
	TrackerResultStore * self;
	GtkTreeIter _iter = {0};
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	self = (TrackerResultStore*) base;
	if (self->priv->queries_length1 > 1) {
		_tmp0_ = (*child).user_data2 != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_iter.stamp = self->priv->timestamp;
		_iter.user_data = (*child).user_data;
		_iter.user_data2 = NULL;
		_iter.user_data3 = NULL;
		result = TRUE;
		if (iter) {
			*iter = _iter;
		}
		return result;
	}
	_iter.stamp = 0;
	result = FALSE;
	if (iter) {
		*iter = _iter;
	}
	return result;
}


static void tracker_result_store_real_ref_node (GtkTreeModel* base, GtkTreeIter* iter) {
	TrackerResultStore * self;
	self = (TrackerResultStore*) base;
}


static void tracker_result_store_real_unref_node (GtkTreeModel* base, GtkTreeIter* iter) {
	TrackerResultStore * self;
	self = (TrackerResultStore*) base;
}


static void tracker_result_store_theme_changed (TrackerResultStore* self, GtkIconTheme* theme) {
	GtkTreeIter iter = {0};
	gint i = 0;
	gint j = 0;
	GtkTreeIter _tmp0_ = {0};
	GtkTreeIter _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (theme != NULL);
	memset (&_tmp0_, 0, sizeof (GtkTreeIter));
	_tmp1_ = _tmp0_;
	iter = _tmp1_;
	iter.stamp = self->priv->timestamp;
	{
		gboolean _tmp2_;
		i = 0;
		_tmp2_ = TRUE;
		while (TRUE) {
			gint _tmp3_;
			gconstpointer _tmp4_ = NULL;
			TrackerResultStoreCategoryNode* _tmp5_;
			TrackerResultStoreCategoryNode* cat;
			if (!_tmp2_) {
				i++;
			}
			_tmp2_ = FALSE;
			_tmp3_ = g_ptr_array_get_length (self->priv->categories);
			if (!(i < _tmp3_)) {
				break;
			}
			_tmp4_ = g_ptr_array_index (self->priv->categories, (guint) i);
			_tmp5_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp4_);
			cat = _tmp5_;
			iter.user_data = cat;
			{
				gboolean _tmp6_;
				j = cat->count - 1;
				_tmp6_ = TRUE;
				while (TRUE) {
					TrackerResultStoreResultNode _tmp7_;
					TrackerResultStoreResultNode _tmp8_ = {0};
					TrackerResultStoreResultNode _result_;
					void* _tmp9_ = NULL;
					if (!_tmp6_) {
						j--;
					}
					_tmp6_ = FALSE;
					if (!(j >= 0)) {
						break;
					}
					tracker_result_store_result_node_copy (&cat->results[j], &_tmp8_);
					_tmp7_ = _tmp8_;
					_result_ = _tmp7_;
					iter.user_data2 = &cat->results[j];
					_tmp9_ = GINT_TO_POINTER (j);
					iter.user_data3 = _tmp9_;
					if (_result_.pixbuf != NULL) {
						tracker_result_store_fetch_thumbnail (self, &iter, NULL, NULL);
					}
					tracker_result_store_result_node_destroy (&_result_);
				}
			}
			_tracker_result_store_category_node_unref0 (cat);
		}
	}
}


static void _tracker_result_store_category_node_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (tracker_result_store_category_node_unref (var), NULL));
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _tracker_result_store_theme_changed_gtk_icon_theme_changed (GtkIconTheme* _sender, gpointer self) {
	tracker_result_store_theme_changed (self, _sender);
}


TrackerResultStore* tracker_result_store_construct (GType object_type, gint _n_columns) {
	TrackerResultStore * self = NULL;
	GPtrArray* _tmp0_ = NULL;
	GPtrArray* _tmp1_ = NULL;
	GPtrArray* _tmp2_ = NULL;
	GdkScreen* _tmp3_ = NULL;
	GtkIconTheme* _tmp4_ = NULL;
	GtkIconTheme* _tmp5_;
	GtkIconTheme* theme;
	self = (TrackerResultStore*) g_object_new (object_type, NULL);
	_tmp0_ = g_ptr_array_new_with_free_func (_tracker_result_store_category_node_unref0_);
	_g_ptr_array_unref0 (self->priv->categories);
	self->priv->categories = _tmp0_;
	_tmp1_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->running_operations);
	self->priv->running_operations = _tmp1_;
	_tmp2_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->delayed_operations);
	self->priv->delayed_operations = _tmp2_;
	self->priv->n_columns = _n_columns;
	self->priv->timestamp = 1;
	tracker_result_store_set_icon_size (self, 24);
	_tmp3_ = gdk_screen_get_default ();
	_tmp4_ = gtk_icon_theme_get_for_screen (_tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	theme = _tmp5_;
	g_signal_connect_object (theme, "changed", (GCallback) _tracker_result_store_theme_changed_gtk_icon_theme_changed, self, 0);
	_g_object_unref0 (theme);
	return self;
}


TrackerResultStore* tracker_result_store_new (gint _n_columns) {
	return tracker_result_store_construct (TRACKER_TYPE_RESULT_STORE, _n_columns);
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void _vala_array_add3 (TrackerResultStoreQueryData** array, int* length, int* size, const TrackerResultStoreQueryData* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerResultStoreQueryData, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


void tracker_result_store_add_query (TrackerResultStore* self, TrackerQueryType type, TrackerQueryMatch match, ...) {
	va_list l;
	gchar* str;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	TrackerResultStoreQueryData query_data = {0};
	TrackerResultStoreQueryData _tmp4_ = {0};
	TrackerResultStoreQueryData _tmp5_ = {0};
	gchar** _tmp6_;
	gchar** _tmp7_;
	TrackerResultStoreQueryData _tmp8_;
	TrackerResultStoreQueryData _tmp9_ = {0};
	g_return_if_fail (self != NULL);
	va_start (l, match);
	str = NULL;
	args = NULL;
	args_length1 = 0;
	_args_size_ = 0;
	{
		gboolean _tmp0_;
		_tmp0_ = TRUE;
		while (TRUE) {
			const gchar* _tmp1_ = NULL;
			gchar* _tmp2_;
			if (!_tmp0_) {
				if (!(str != NULL)) {
					break;
				}
			}
			_tmp0_ = FALSE;
			_tmp1_ = va_arg (l, gchar*);
			_tmp2_ = g_strdup (_tmp1_);
			_g_free0 (str);
			str = _tmp2_;
			if (str != NULL) {
				gchar* _tmp3_;
				_tmp3_ = g_strdup (str);
				_vala_array_add2 (&args, &args_length1, &_args_size_, _tmp3_);
			}
		}
	}
	if (args_length1 != self->priv->n_columns) {
		g_warning ("tracker-result-store.vala:826: Arguments and number of columns doesn't" \
" match");
		tracker_result_store_query_data_destroy (&query_data);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (str);
		va_end (l);
		return;
	}
	memset (&_tmp4_, 0, sizeof (TrackerResultStoreQueryData));
	_tmp5_ = _tmp4_;
	tracker_result_store_query_data_destroy (&query_data);
	query_data = _tmp5_;
	query_data.type = type;
	query_data.match = match;
	_tmp6_ = (_tmp7_ = args, (_tmp7_ == NULL) ? ((gpointer) _tmp7_) : _vala_array_dup3 (_tmp7_, args_length1));
	query_data.args = (_vala_array_free (query_data.args, query_data.args_length1, (GDestroyNotify) g_free), NULL);
	query_data.args = _tmp6_;
	query_data.args_length1 = args_length1;
	query_data._args_size_ = args_length1;
	tracker_result_store_query_data_copy (&query_data, &_tmp9_);
	_tmp8_ = _tmp9_;
	_vala_array_add3 (&self->priv->queries, &self->priv->queries_length1, &self->priv->_queries_size_, &_tmp8_);
	tracker_result_store_query_data_destroy (&query_data);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (str);
	va_end (l);
}


gboolean tracker_result_store_has_results (TrackerResultStore* self) {
	gboolean result = FALSE;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tracker_result_store_filled_categories_count (self);
	result = _tmp0_ > 0;
	return result;
}


void tracker_result_store_cancel_search (TrackerResultStore* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->cancellable != NULL) {
		g_cancellable_cancel (self->priv->cancellable);
		_g_object_unref0 (self->priv->cancellable);
		self->priv->cancellable = NULL;
	}
	tracker_result_store_clear_results (self);
}


gint tracker_result_store_get_icon_size (TrackerResultStore* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_icon_size;
	return result;
}


void tracker_result_store_set_icon_size (TrackerResultStore* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_icon_size = value;
	g_object_notify ((GObject *) self, "icon-size");
}


const gchar* tracker_result_store_get_search_term (TrackerResultStore* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_search_term;
	return result;
}


void tracker_result_store_set_search_term (TrackerResultStore* self, const gchar* value) {
	gint i = 0;
	gchar* _tmp0_;
	GCancellable* _tmp1_ = NULL;
	GPtrArray* _tmp2_ = NULL;
	GPtrArray* _tmp3_ = NULL;
	GPtrArray* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	tracker_result_store_cancel_search (self);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_search_term);
	self->priv->_search_term = _tmp0_;
	_tmp1_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp1_;
	tracker_result_store_set_active (self, TRUE);
	_tmp2_ = g_ptr_array_new_with_free_func (_tracker_result_store_category_node_unref0_);
	_g_ptr_array_unref0 (self->priv->categories);
	self->priv->categories = _tmp2_;
	_tmp3_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->running_operations);
	self->priv->running_operations = _tmp3_;
	_tmp4_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->delayed_operations);
	self->priv->delayed_operations = _tmp4_;
	self->priv->timestamp++;
	{
		gboolean _tmp5_;
		i = 0;
		_tmp5_ = TRUE;
		while (TRUE) {
			if (!_tmp5_) {
				i++;
			}
			_tmp5_ = FALSE;
			if (!(i < self->priv->queries_length1)) {
				break;
			}
			tracker_result_store_load_category (self, &self->priv->queries[i], self->priv->cancellable, NULL, NULL);
		}
	}
	g_object_notify ((GObject *) self, "search-term");
}


gboolean tracker_result_store_get_active (TrackerResultStore* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}


static void tracker_result_store_set_active (TrackerResultStore* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_active = value;
	g_object_notify ((GObject *) self, "active");
}


static void _vala_TrackerResultStoreResultNode_array_free (TrackerResultStoreResultNode* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			tracker_result_store_result_node_destroy (&array[i]);
		}
	}
	g_free (array);
}


static TrackerResultStoreCategoryNode* tracker_result_store_category_node_construct (GType object_type) {
	TrackerResultStoreCategoryNode* self = NULL;
	self = (TrackerResultStoreCategoryNode*) g_type_create_instance (object_type);
	return self;
}


static TrackerResultStoreCategoryNode* tracker_result_store_category_node_new (void) {
	return tracker_result_store_category_node_construct (TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE);
}


static void tracker_result_store_value_category_node_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void tracker_result_store_value_category_node_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		tracker_result_store_category_node_unref (value->data[0].v_pointer);
	}
}


static void tracker_result_store_value_category_node_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tracker_result_store_category_node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer tracker_result_store_value_category_node_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* tracker_result_store_value_category_node_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TrackerResultStoreCategoryNode* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tracker_result_store_category_node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* tracker_result_store_value_category_node_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerResultStoreCategoryNode** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tracker_result_store_category_node_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* tracker_result_store_param_spec_category_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerResultStoreParamSpecCategoryNode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer tracker_result_store_value_get_category_node (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE), NULL);
	return value->data[0].v_pointer;
}


static void tracker_result_store_value_set_category_node (GValue* value, gpointer v_object) {
	TrackerResultStoreCategoryNode* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tracker_result_store_category_node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_result_store_category_node_unref (old);
	}
}


static void tracker_result_store_value_take_category_node (GValue* value, gpointer v_object) {
	TrackerResultStoreCategoryNode* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_result_store_category_node_unref (old);
	}
}


static void tracker_result_store_category_node_class_init (TrackerResultStoreCategoryNodeClass * klass) {
	tracker_result_store_category_node_parent_class = g_type_class_peek_parent (klass);
	TRACKER_RESULT_STORE_CATEGORY_NODE_CLASS (klass)->finalize = tracker_result_store_category_node_finalize;
}


static void tracker_result_store_category_node_instance_init (TrackerResultStoreCategoryNode * self) {
	self->ref_count = 1;
}


static void tracker_result_store_category_node_finalize (TrackerResultStoreCategoryNode* obj) {
	TrackerResultStoreCategoryNode * self;
	self = TRACKER_RESULT_STORE_CATEGORY_NODE (obj);
	self->results = (_vala_TrackerResultStoreResultNode_array_free (self->results, self->results_length1), NULL);
	_g_object_unref0 (self->pixbuf);
}


static GType tracker_result_store_category_node_get_type (void) {
	static volatile gsize tracker_result_store_category_node_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_result_store_category_node_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_result_store_value_category_node_init, tracker_result_store_value_category_node_free_value, tracker_result_store_value_category_node_copy_value, tracker_result_store_value_category_node_peek_pointer, "p", tracker_result_store_value_category_node_collect_value, "p", tracker_result_store_value_category_node_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerResultStoreCategoryNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_result_store_category_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerResultStoreCategoryNode), 0, (GInstanceInitFunc) tracker_result_store_category_node_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_result_store_category_node_type_id;
		tracker_result_store_category_node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerResultStoreCategoryNode", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_result_store_category_node_type_id__volatile, tracker_result_store_category_node_type_id);
	}
	return tracker_result_store_category_node_type_id__volatile;
}


static gpointer tracker_result_store_category_node_ref (gpointer instance) {
	TrackerResultStoreCategoryNode* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void tracker_result_store_category_node_unref (gpointer instance) {
	TrackerResultStoreCategoryNode* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TRACKER_RESULT_STORE_CATEGORY_NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static TrackerResultStoreOperation* tracker_result_store_operation_construct (GType object_type) {
	TrackerResultStoreOperation * self = NULL;
	self = (TrackerResultStoreOperation*) g_object_new (object_type, NULL);
	return self;
}


static TrackerResultStoreOperation* tracker_result_store_operation_new (void) {
	return tracker_result_store_operation_construct (TRACKER_RESULT_STORE_TYPE_OPERATION);
}


static void tracker_result_store_operation_class_init (TrackerResultStoreOperationClass * klass) {
	tracker_result_store_operation_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tracker_result_store_operation_finalize;
}


static void tracker_result_store_operation_instance_init (TrackerResultStoreOperation * self) {
}


static void tracker_result_store_operation_finalize (GObject* obj) {
	TrackerResultStoreOperation * self;
	self = TRACKER_RESULT_STORE_OPERATION (obj);
	_tracker_result_store_category_node_unref0 (self->node);
	G_OBJECT_CLASS (tracker_result_store_operation_parent_class)->finalize (obj);
}


static GType tracker_result_store_operation_get_type (void) {
	static volatile gsize tracker_result_store_operation_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_result_store_operation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerResultStoreOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_result_store_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerResultStoreOperation), 0, (GInstanceInitFunc) tracker_result_store_operation_instance_init, NULL };
		GType tracker_result_store_operation_type_id;
		tracker_result_store_operation_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerResultStoreOperation", &g_define_type_info, 0);
		g_once_init_leave (&tracker_result_store_operation_type_id__volatile, tracker_result_store_operation_type_id);
	}
	return tracker_result_store_operation_type_id__volatile;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void tracker_result_store_result_node_copy (const TrackerResultStoreResultNode* self, TrackerResultStoreResultNode* dest) {
	gchar** _tmp0_;
	dest->values = (_tmp0_ = self->values, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup4 (_tmp0_, (*self).values_length1));
	dest->values_length1 = self->values_length1;
	dest->pixbuf = _g_object_ref0 (self->pixbuf);
}


static void tracker_result_store_result_node_destroy (TrackerResultStoreResultNode* self) {
	(*self).values = (_vala_array_free ((*self).values, (*self).values_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 ((*self).pixbuf);
}


static TrackerResultStoreResultNode* tracker_result_store_result_node_dup (const TrackerResultStoreResultNode* self) {
	TrackerResultStoreResultNode* dup;
	dup = g_new0 (TrackerResultStoreResultNode, 1);
	tracker_result_store_result_node_copy (self, dup);
	return dup;
}


static void tracker_result_store_result_node_free (TrackerResultStoreResultNode* self) {
	tracker_result_store_result_node_destroy (self);
	g_free (self);
}


static GType tracker_result_store_result_node_get_type (void) {
	static volatile gsize tracker_result_store_result_node_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_result_store_result_node_type_id__volatile)) {
		GType tracker_result_store_result_node_type_id;
		tracker_result_store_result_node_type_id = g_boxed_type_register_static ("TrackerResultStoreResultNode", (GBoxedCopyFunc) tracker_result_store_result_node_dup, (GBoxedFreeFunc) tracker_result_store_result_node_free);
		g_once_init_leave (&tracker_result_store_result_node_type_id__volatile, tracker_result_store_result_node_type_id);
	}
	return tracker_result_store_result_node_type_id__volatile;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void tracker_result_store_query_data_copy (const TrackerResultStoreQueryData* self, TrackerResultStoreQueryData* dest) {
	gchar** _tmp0_;
	dest->type = self->type;
	dest->match = self->match;
	dest->args = (_tmp0_ = self->args, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup5 (_tmp0_, (*self).args_length1));
	dest->args_length1 = self->args_length1;
}


static void tracker_result_store_query_data_destroy (TrackerResultStoreQueryData* self) {
	(*self).args = (_vala_array_free ((*self).args, (*self).args_length1, (GDestroyNotify) g_free), NULL);
}


static TrackerResultStoreQueryData* tracker_result_store_query_data_dup (const TrackerResultStoreQueryData* self) {
	TrackerResultStoreQueryData* dup;
	dup = g_new0 (TrackerResultStoreQueryData, 1);
	tracker_result_store_query_data_copy (self, dup);
	return dup;
}


static void tracker_result_store_query_data_free (TrackerResultStoreQueryData* self) {
	tracker_result_store_query_data_destroy (self);
	g_free (self);
}


static GType tracker_result_store_query_data_get_type (void) {
	static volatile gsize tracker_result_store_query_data_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_result_store_query_data_type_id__volatile)) {
		GType tracker_result_store_query_data_type_id;
		tracker_result_store_query_data_type_id = g_boxed_type_register_static ("TrackerResultStoreQueryData", (GBoxedCopyFunc) tracker_result_store_query_data_dup, (GBoxedFreeFunc) tracker_result_store_query_data_free);
		g_once_init_leave (&tracker_result_store_query_data_type_id__volatile, tracker_result_store_query_data_type_id);
	}
	return tracker_result_store_query_data_type_id__volatile;
}


static void tracker_result_store_class_init (TrackerResultStoreClass * klass) {
	tracker_result_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerResultStorePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_result_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_result_store_set_property;
	G_OBJECT_CLASS (klass)->finalize = tracker_result_store_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_RESULT_STORE_ICON_SIZE, g_param_spec_int ("icon-size", "icon-size", "icon-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_RESULT_STORE_SEARCH_TERM, g_param_spec_string ("search-term", "search-term", "search-term", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_RESULT_STORE_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void tracker_result_store_gtk_tree_model_interface_init (GtkTreeModelIface * iface) {
	tracker_result_store_gtk_tree_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_column_type = (GType (*)(GtkTreeModel* ,gint)) tracker_result_store_real_get_column_type;
	iface->get_flags = (GtkTreeModelFlags (*)(GtkTreeModel*)) tracker_result_store_real_get_flags;
	iface->get_iter = (gboolean (*)(GtkTreeModel* ,GtkTreeIter* ,GtkTreePath*)) tracker_result_store_real_get_iter;
	iface->get_n_columns = (gint (*)(GtkTreeModel*)) tracker_result_store_real_get_n_columns;
	iface->get_path = (GtkTreePath* (*)(GtkTreeModel* ,GtkTreeIter*)) tracker_result_store_real_get_path;
	iface->get_value = (void (*)(GtkTreeModel* ,GtkTreeIter* ,gint ,GValue*)) tracker_result_store_real_get_value;
	iface->iter_children = (gboolean (*)(GtkTreeModel* ,GtkTreeIter* ,GtkTreeIter*)) tracker_result_store_real_iter_children;
	iface->iter_has_child = (gboolean (*)(GtkTreeModel* ,GtkTreeIter*)) tracker_result_store_real_iter_has_child;
	iface->iter_n_children = (gint (*)(GtkTreeModel* ,GtkTreeIter*)) tracker_result_store_real_iter_n_children;
	iface->iter_next = (gboolean (*)(GtkTreeModel* ,GtkTreeIter*)) tracker_result_store_real_iter_next;
	iface->iter_nth_child = (gboolean (*)(GtkTreeModel* ,GtkTreeIter* ,GtkTreeIter* ,gint)) tracker_result_store_real_iter_nth_child;
	iface->iter_parent = (gboolean (*)(GtkTreeModel* ,GtkTreeIter* ,GtkTreeIter*)) tracker_result_store_real_iter_parent;
	iface->ref_node = (void (*)(GtkTreeModel* ,GtkTreeIter*)) tracker_result_store_real_ref_node;
	iface->unref_node = (void (*)(GtkTreeModel* ,GtkTreeIter*)) tracker_result_store_real_unref_node;
}


static void tracker_result_store_instance_init (TrackerResultStore * self) {
	self->priv = TRACKER_RESULT_STORE_GET_PRIVATE (self);
	self->priv->n_extra_columns = 2;
}


static void tracker_result_store_finalize (GObject* obj) {
	TrackerResultStore * self;
	self = TRACKER_RESULT_STORE (obj);
	_g_object_unref0 (self->priv->cancellable);
	self->priv->queries = (_vala_TrackerResultStoreQueryData_array_free (self->priv->queries, self->priv->queries_length1), NULL);
	_g_ptr_array_unref0 (self->priv->categories);
	_g_ptr_array_unref0 (self->priv->running_operations);
	_g_ptr_array_unref0 (self->priv->delayed_operations);
	_g_free0 (self->priv->_search_term);
	G_OBJECT_CLASS (tracker_result_store_parent_class)->finalize (obj);
}


GType tracker_result_store_get_type (void) {
	static volatile gsize tracker_result_store_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_result_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerResultStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_result_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerResultStore), 0, (GInstanceInitFunc) tracker_result_store_instance_init, NULL };
		static const GInterfaceInfo gtk_tree_model_info = { (GInterfaceInitFunc) tracker_result_store_gtk_tree_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType tracker_result_store_type_id;
		tracker_result_store_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerResultStore", &g_define_type_info, 0);
		g_type_add_interface_static (tracker_result_store_type_id, GTK_TYPE_TREE_MODEL, &gtk_tree_model_info);
		g_once_init_leave (&tracker_result_store_type_id__volatile, tracker_result_store_type_id);
	}
	return tracker_result_store_type_id__volatile;
}


static void _vala_tracker_result_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerResultStore * self;
	self = TRACKER_RESULT_STORE (object);
	switch (property_id) {
		case TRACKER_RESULT_STORE_ICON_SIZE:
		g_value_set_int (value, tracker_result_store_get_icon_size (self));
		break;
		case TRACKER_RESULT_STORE_SEARCH_TERM:
		g_value_set_string (value, tracker_result_store_get_search_term (self));
		break;
		case TRACKER_RESULT_STORE_ACTIVE:
		g_value_set_boolean (value, tracker_result_store_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tracker_result_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerResultStore * self;
	self = TRACKER_RESULT_STORE (object);
	switch (property_id) {
		case TRACKER_RESULT_STORE_ICON_SIZE:
		tracker_result_store_set_icon_size (self, g_value_get_int (value));
		break;
		case TRACKER_RESULT_STORE_SEARCH_TERM:
		tracker_result_store_set_search_term (self, g_value_get_string (value));
		break;
		case TRACKER_RESULT_STORE_ACTIVE:
		tracker_result_store_set_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



