/* tracker-sparql-expression.c generated by valac 0.19.0.3-f335, the Vala compiler
 * generated from tracker-sparql-expression.vala, do not modify */

/*
 * Copyright (C) 2008-2010, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "libtracker-sparql/tracker-sparql.h"
#include "libtracker-data/tracker-property.h"
#include "libtracker-data/tracker-db-interface-sqlite.h"
#include "libtracker-data/tracker-class.h"
#include "libtracker-data/tracker-collation.h"
#include "libtracker-data/tracker-ontologies.h"


#define TRACKER_SPARQL_TYPE_EXPRESSION (tracker_sparql_expression_get_type ())
#define TRACKER_SPARQL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression))
#define TRACKER_SPARQL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))
#define TRACKER_SPARQL_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))

typedef struct _TrackerSparqlExpression TrackerSparqlExpression;
typedef struct _TrackerSparqlExpressionClass TrackerSparqlExpressionClass;
typedef struct _TrackerSparqlExpressionPrivate TrackerSparqlExpressionPrivate;

#define TRACKER_SPARQL_TYPE_QUERY (tracker_sparql_query_get_type ())
#define TRACKER_SPARQL_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery))
#define TRACKER_SPARQL_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))
#define TRACKER_SPARQL_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))

typedef struct _TrackerSparqlQuery TrackerSparqlQuery;
typedef struct _TrackerSparqlQueryClass TrackerSparqlQueryClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

#define TRACKER_SPARQL_TYPE_VARIABLE (tracker_sparql_variable_get_type ())
#define TRACKER_SPARQL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable))
#define TRACKER_SPARQL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))
#define TRACKER_SPARQL_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))

typedef struct _TrackerSparqlVariable TrackerSparqlVariable;
typedef struct _TrackerSparqlVariableClass TrackerSparqlVariableClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TRACKER_SPARQL_TYPE_CONTEXT (tracker_sparql_context_get_type ())
#define TRACKER_SPARQL_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContext))
#define TRACKER_SPARQL_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))
#define TRACKER_SPARQL_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))

typedef struct _TrackerSparqlContext TrackerSparqlContext;
typedef struct _TrackerSparqlContextClass TrackerSparqlContextClass;
typedef struct _TrackerSparqlVariablePrivate TrackerSparqlVariablePrivate;

#define TRACKER_SPARQL_TYPE_DATA_BINDING (tracker_sparql_data_binding_get_type ())
#define TRACKER_SPARQL_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding))
#define TRACKER_SPARQL_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))
#define TRACKER_SPARQL_IS_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_IS_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_DATA_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))

typedef struct _TrackerSparqlDataBinding TrackerSparqlDataBinding;
typedef struct _TrackerSparqlDataBindingClass TrackerSparqlDataBindingClass;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING (tracker_sparql_variable_binding_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBinding))
#define TRACKER_SPARQL_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_VARIABLE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))

typedef struct _TrackerSparqlVariableBinding TrackerSparqlVariableBinding;
typedef struct _TrackerSparqlVariableBindingClass TrackerSparqlVariableBindingClass;

#define TRACKER_SPARQL_TYPE_PATTERN (tracker_sparql_pattern_get_type ())
#define TRACKER_SPARQL_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern))
#define TRACKER_SPARQL_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))
#define TRACKER_SPARQL_IS_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_IS_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))

typedef struct _TrackerSparqlPattern TrackerSparqlPattern;
typedef struct _TrackerSparqlPatternClass TrackerSparqlPatternClass;

#define TRACKER_SPARQL_TYPE_SELECT_CONTEXT (tracker_sparql_select_context_get_type ())
#define TRACKER_SPARQL_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext))
#define TRACKER_SPARQL_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_SELECT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))

typedef struct _TrackerSparqlSelectContext TrackerSparqlSelectContext;
typedef struct _TrackerSparqlSelectContextClass TrackerSparqlSelectContextClass;
#define _tracker_sparql_context_unref0(var) ((var == NULL) ? NULL : (var = (tracker_sparql_context_unref (var), NULL)))
typedef struct _TrackerSparqlContextPrivate TrackerSparqlContextPrivate;

#define TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE (tracker_sparql_predicate_variable_get_type ())
#define TRACKER_SPARQL_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariable))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))

typedef struct _TrackerSparqlPredicateVariable TrackerSparqlPredicateVariable;
typedef struct _TrackerSparqlPredicateVariableClass TrackerSparqlPredicateVariableClass;
typedef struct _TrackerSparqlSelectContextPrivate TrackerSparqlSelectContextPrivate;
typedef struct _TrackerSparqlDataBindingPrivate TrackerSparqlDataBindingPrivate;

#define TRACKER_SPARQL_TYPE_DATA_TABLE (tracker_sparql_data_table_get_type ())
#define TRACKER_SPARQL_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTable))
#define TRACKER_SPARQL_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))
#define TRACKER_SPARQL_IS_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_IS_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_DATA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))

typedef struct _TrackerSparqlDataTable TrackerSparqlDataTable;
typedef struct _TrackerSparqlDataTableClass TrackerSparqlDataTableClass;
typedef struct _TrackerSparqlVariableBindingPrivate TrackerSparqlVariableBindingPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE_STATE (tracker_sparql_variable_state_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _TrackerSparqlPatternPrivate TrackerSparqlPatternPrivate;

#define TRACKER_SPARQL_TYPE_LITERAL_BINDING (tracker_sparql_literal_binding_get_type ())
#define TRACKER_SPARQL_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBinding))
#define TRACKER_SPARQL_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))
#define TRACKER_SPARQL_IS_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_IS_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_LITERAL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))

typedef struct _TrackerSparqlLiteralBinding TrackerSparqlLiteralBinding;
typedef struct _TrackerSparqlLiteralBindingClass TrackerSparqlLiteralBindingClass;
typedef struct _TrackerSparqlLiteralBindingPrivate TrackerSparqlLiteralBindingPrivate;
typedef struct _TrackerSparqlQueryPrivate TrackerSparqlQueryPrivate;

struct _TrackerSparqlExpression {
	GObject parent_instance;
	TrackerSparqlExpressionPrivate * priv;
};

struct _TrackerSparqlExpressionClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlExpressionPrivate {
	TrackerSparqlQuery* query;
	gchar* fts_sql;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COALESCE,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATA,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_HAVING,
	TRACKER_SPARQL_TOKEN_TYPE_IF,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_NULL,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_OR,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_REPLACE,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH
} TrackerSparqlTokenType;

struct _TrackerSparqlVariable {
	GObject parent_instance;
	TrackerSparqlVariablePrivate * priv;
	TrackerSparqlVariableBinding* binding;
};

struct _TrackerSparqlVariableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerSparqlContextPrivate * priv;
	TrackerSparqlQuery* query;
	TrackerSparqlContext* parent_context;
	GHashTable* var_set;
	GHashTable* var_map;
	GHashTable* select_var_set;
	GHashTable* predicate_variable_map;
	gboolean scalar_subquery;
};

struct _TrackerSparqlContextClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerSparqlContext *self);
};

struct _TrackerSparqlSelectContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlSelectContextPrivate * priv;
	TrackerPropertyType type;
	TrackerPropertyType* types;
	gint types_length1;
	gint _types_size_;
	gchar** variable_names;
	gint variable_names_length1;
	gint _variable_names_size_;
};

struct _TrackerSparqlSelectContextClass {
	TrackerSparqlContextClass parent_class;
};

struct _TrackerSparqlDataBinding {
	GObject parent_instance;
	TrackerSparqlDataBindingPrivate * priv;
	TrackerPropertyType data_type;
	TrackerSparqlDataTable* table;
	gchar* sql_db_column_name;
};

struct _TrackerSparqlDataBindingClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariableBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlVariableBindingPrivate * priv;
	TrackerSparqlVariable* variable;
	gboolean maybe_null;
	gboolean in_simple_optional;
	TrackerClass* type;
};

struct _TrackerSparqlVariableBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

typedef enum  {
	TRACKER_SPARQL_VARIABLE_STATE_NONE,
	TRACKER_SPARQL_VARIABLE_STATE_BOUND,
	TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL
} TrackerSparqlVariableState;

struct _TrackerSparqlPattern {
	GObject parent_instance;
	TrackerSparqlPatternPrivate * priv;
	gchar* current_graph;
	TrackerSparqlVariable* fts_subject;
	gchar** fts_variables;
	gint fts_variables_length1;
	gint _fts_variables_size_;
	GString* match_str;
	gboolean queries_fts_data;
};

struct _TrackerSparqlPatternClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlLiteralBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlLiteralBindingPrivate * priv;
	gboolean is_fts_match;
	gchar* literal;
};

struct _TrackerSparqlLiteralBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

struct _TrackerSparqlQuery {
	GObject parent_instance;
	TrackerSparqlQueryPrivate * priv;
	TrackerSparqlExpression* expression;
	TrackerSparqlPattern* pattern;
	GList* bindings;
	TrackerSparqlContext* context;
	gint last_var_index;
};

struct _TrackerSparqlQueryClass {
	GObjectClass parent_class;
};


static gpointer tracker_sparql_expression_parent_class = NULL;

GType tracker_sparql_expression_get_type (void) G_GNUC_CONST;
GType tracker_sparql_query_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionPrivate))
enum  {
	TRACKER_SPARQL_EXPRESSION_DUMMY_PROPERTY
};
#define TRACKER_SPARQL_EXPRESSION_MAX_VARIABLES_FOR_IN 20
#define TRACKER_SPARQL_EXPRESSION_XSD_NS "http://www.w3.org/2001/XMLSchema#"
#define TRACKER_SPARQL_EXPRESSION_FN_NS "http://www.w3.org/2005/xpath-functions#"
#define TRACKER_SPARQL_EXPRESSION_FTS_NS "http://www.tracker-project.org/ontologies/fts#"
#define TRACKER_SPARQL_EXPRESSION_TRACKER_NS "http://www.tracker-project.org/ontologies/tracker#"
TrackerSparqlExpression* tracker_sparql_expression_new (TrackerSparqlQuery* query);
TrackerSparqlExpression* tracker_sparql_expression_construct (GType object_type, TrackerSparqlQuery* query);
static inline gboolean tracker_sparql_expression_next (TrackerSparqlExpression* self, GError** error);
gboolean tracker_sparql_query_next (TrackerSparqlQuery* self, GError** error);
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
static inline TrackerSparqlTokenType tracker_sparql_expression_current (TrackerSparqlExpression* self);
TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self);
static inline TrackerSparqlTokenType tracker_sparql_expression_last (TrackerSparqlExpression* self);
TrackerSparqlTokenType tracker_sparql_query_last (TrackerSparqlQuery* self);
static inline gboolean tracker_sparql_expression_accept (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error);
gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
static GError* tracker_sparql_expression_get_error (TrackerSparqlExpression* self, const gchar* msg);
GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self, const gchar* msg);
static gboolean tracker_sparql_expression_expect (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error);
gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
static gchar* tracker_sparql_expression_get_last_string (TrackerSparqlExpression* self, gint strip);
gchar* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self, gint strip);
static gchar* tracker_sparql_expression_escape_sql_string_literal (TrackerSparqlExpression* self, const gchar* literal);
static gboolean tracker_sparql_expression_maybe_numeric (TrackerSparqlExpression* self, TrackerPropertyType type);
static void tracker_sparql_expression_append_collate (TrackerSparqlExpression* self, GString* sql);
static void tracker_sparql_expression_skip_bracketted_expression (TrackerSparqlExpression* self, GError** error);
void tracker_sparql_expression_skip_select_variables (TrackerSparqlExpression* self, GError** error);
TrackerPropertyType tracker_sparql_expression_translate_select_expression (TrackerSparqlExpression* self, GString* sql, gboolean subquery, gint variable_index, GError** error);
GType tracker_sparql_variable_get_type (void) G_GNUC_CONST;
TrackerPropertyType tracker_sparql_expression_translate_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
gpointer tracker_sparql_context_ref (gpointer instance);
void tracker_sparql_context_unref (gpointer instance);
GParamSpec* tracker_sparql_param_spec_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_sparql_value_set_context (GValue* value, gpointer v_object);
void tracker_sparql_value_take_context (GValue* value, gpointer v_object);
gpointer tracker_sparql_value_get_context (const GValue* value);
GType tracker_sparql_context_get_type (void) G_GNUC_CONST;
static TrackerSparqlContext* tracker_sparql_expression_get_context (TrackerSparqlExpression* self);
TrackerSparqlVariable* tracker_sparql_context_get_variable (TrackerSparqlContext* self, const gchar* name);
GType tracker_sparql_data_binding_get_type (void) G_GNUC_CONST;
GType tracker_sparql_variable_binding_get_type (void) G_GNUC_CONST;
const gchar* tracker_sparql_variable_get_name (TrackerSparqlVariable* self);
GType tracker_sparql_pattern_get_type (void) G_GNUC_CONST;
static TrackerSparqlPattern* tracker_sparql_expression_get_pattern (TrackerSparqlExpression* self);
GType tracker_sparql_select_context_get_type (void) G_GNUC_CONST;
TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self, GString* sql, gboolean subquery, gboolean scalar_subquery, GError** error);
GType tracker_sparql_predicate_variable_get_type (void) G_GNUC_CONST;
static void tracker_sparql_expression_convert_expression_to_string (GString* sql, TrackerPropertyType type, glong begin);
const gchar* tracker_sparql_variable_get_sql_expression (TrackerSparqlVariable* self);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_new (void);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_construct (GType object_type);
GType tracker_sparql_data_table_get_type (void) G_GNUC_CONST;
void tracker_sparql_data_binding_set_sql_expression (TrackerSparqlDataBinding* self, const gchar* value);
GType tracker_sparql_variable_state_get_type (void) G_GNUC_CONST;
void tracker_sparql_pattern_add_variable_binding (TrackerSparqlPattern* self, GString* sql, TrackerSparqlVariableBinding* binding, TrackerSparqlVariableState variable_state);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static void tracker_sparql_expression_translate_expression_as_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_expression_translate_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_bound_call (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_if_call (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_regex (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_expression_as_string (TrackerSparqlExpression* self, GString* sql, GError** error);
gchar* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error);
static void tracker_sparql_expression_translate_exists (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_pattern_translate_exists (TrackerSparqlPattern* self, GString* sql, GError** error);
void tracker_sparql_expression_append_expression_as_string (GString* sql, const gchar* expression, TrackerPropertyType type);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_new (void);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_construct (GType object_type);
GType tracker_sparql_literal_binding_get_type (void) G_GNUC_CONST;
gchar* tracker_sparql_pattern_parse_var_or_term (TrackerSparqlPattern* self, GString* sql, gboolean* is_var, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_function (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error);
static void tracker_sparql_expression_translate_str (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_isuri (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_datatype (TrackerSparqlExpression* self, GString* sql, GError** error);
gchar* tracker_sparql_variable_get_extra_sql_expression (TrackerSparqlVariable* self, const gchar* suffix);
static TrackerPropertyType tracker_sparql_expression_parse_type_uri (TrackerSparqlExpression* self, GError** error);
gchar* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self, const gchar* prefix, const gchar* local_name, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_uri_expression (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_primary_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_bracketted_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
gboolean tracker_sparql_query_get_no_cache (TrackerSparqlQuery* self);
void tracker_sparql_query_set_no_cache (TrackerSparqlQuery* self, gboolean value);
static TrackerPropertyType tracker_sparql_expression_translate_aggregate_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_unary_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_multiplicative_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_additive_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_numeric_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_process_relational_expression (TrackerSparqlExpression* self, GString* sql, glong begin, guint n_bindings, TrackerPropertyType op1type, const gchar* operator, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_in (TrackerSparqlExpression* self, GString* sql, gboolean not, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_relational_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_value_logical (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_conditional_and_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_conditional_or_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
TrackerPropertyType tracker_sparql_expression_translate_constraint (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_finalize (GObject* obj);
static void _vala_tracker_sparql_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


TrackerSparqlExpression* tracker_sparql_expression_construct (GType object_type, TrackerSparqlQuery* query) {
	TrackerSparqlExpression * self = NULL;
	TrackerSparqlQuery* _tmp0_;
#line 31 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 31 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	self = (TrackerSparqlExpression*) g_object_new (object_type, NULL);
#line 32 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = query;
#line 32 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	self->priv->query = _tmp0_;
#line 31 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return self;
#line 520 "tracker-sparql-expression.c"
}


TrackerSparqlExpression* tracker_sparql_expression_new (TrackerSparqlQuery* query) {
#line 31 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return tracker_sparql_expression_construct (TRACKER_SPARQL_TYPE_EXPRESSION, query);
#line 527 "tracker-sparql-expression.c"
}


static inline gboolean tracker_sparql_expression_next (TrackerSparqlExpression* self, GError** error) {
	gboolean result = FALSE;
	TrackerSparqlQuery* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
#line 43 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 44 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 44 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_query_next (_tmp0_, &_inner_error_);
#line 44 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_;
#line 44 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 44 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 44 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 44 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 553 "tracker-sparql-expression.c"
		} else {
#line 44 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 44 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 44 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 561 "tracker-sparql-expression.c"
		}
	}
#line 44 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 44 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 568 "tracker-sparql-expression.c"
}


static inline TrackerSparqlTokenType tracker_sparql_expression_current (TrackerSparqlExpression* self) {
	TrackerSparqlTokenType result = 0;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlTokenType _tmp1_ = 0;
#line 47 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 48 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 48 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_query_current (_tmp0_);
#line 48 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp1_;
#line 48 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 586 "tracker-sparql-expression.c"
}


static inline TrackerSparqlTokenType tracker_sparql_expression_last (TrackerSparqlExpression* self) {
	TrackerSparqlTokenType result = 0;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlTokenType _tmp1_ = 0;
#line 51 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 52 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 52 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_query_last (_tmp0_);
#line 52 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp1_;
#line 52 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 604 "tracker-sparql-expression.c"
}


static inline gboolean tracker_sparql_expression_accept (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlTokenType _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
#line 55 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 56 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 56 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = type;
#line 56 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = tracker_sparql_query_accept (_tmp0_, _tmp1_, &_inner_error_);
#line 56 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = _tmp2_;
#line 56 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 56 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 56 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 56 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 633 "tracker-sparql-expression.c"
		} else {
#line 56 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 56 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 56 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 641 "tracker-sparql-expression.c"
		}
	}
#line 56 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp3_;
#line 56 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 648 "tracker-sparql-expression.c"
}


static GError* tracker_sparql_expression_get_error (TrackerSparqlExpression* self, const gchar* msg) {
	GError* result = NULL;
	TrackerSparqlQuery* _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_ = NULL;
#line 59 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 59 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 60 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 60 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = msg;
#line 60 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = tracker_sparql_query_get_error (_tmp0_, _tmp1_);
#line 60 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 60 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 671 "tracker-sparql-expression.c"
}


static gboolean tracker_sparql_expression_expect (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlTokenType _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
#line 63 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 64 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 64 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = type;
#line 64 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = tracker_sparql_query_expect (_tmp0_, _tmp1_, &_inner_error_);
#line 64 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = _tmp2_;
#line 64 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 64 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 64 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 64 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 700 "tracker-sparql-expression.c"
		} else {
#line 64 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 64 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 64 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return FALSE;
#line 708 "tracker-sparql-expression.c"
		}
	}
#line 64 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp3_;
#line 64 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 715 "tracker-sparql-expression.c"
}


static gchar* tracker_sparql_expression_get_last_string (TrackerSparqlExpression* self, gint strip) {
	gchar* result = NULL;
	TrackerSparqlQuery* _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
#line 67 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 68 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 68 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = strip;
#line 68 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = tracker_sparql_query_get_last_string (_tmp0_, _tmp1_);
#line 68 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 68 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 736 "tracker-sparql-expression.c"
}


static gchar* tracker_sparql_expression_escape_sql_string_literal (TrackerSparqlExpression* self, const gchar* literal) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
#line 71 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 71 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (literal != NULL, NULL);
#line 72 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = literal;
#line 72 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "'", 0);
#line 72 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = _tmp2_;
#line 72 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3__length1 = _vala_array_length (_tmp1_);
#line 72 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = g_strjoinv ("''", _tmp3_);
#line 72 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = _tmp4_;
#line 72 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = g_strdup_printf ("'%s'", _tmp5_);
#line 72 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp7_ = _tmp6_;
#line 72 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_free0 (_tmp5_);
#line 72 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
#line 72 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp7_;
#line 72 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 779 "tracker-sparql-expression.c"
}


static gboolean tracker_sparql_expression_maybe_numeric (TrackerSparqlExpression* self, TrackerPropertyType type) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	TrackerPropertyType _tmp4_;
	gboolean _tmp6_;
	gboolean _tmp8_;
	gboolean _tmp10_;
	gboolean _tmp12_;
#line 75 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = type;
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp4_ == TRACKER_PROPERTY_TYPE_INTEGER) {
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = TRUE;
#line 802 "tracker-sparql-expression.c"
	} else {
		TrackerPropertyType _tmp5_;
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = type;
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = _tmp5_ == TRACKER_PROPERTY_TYPE_DOUBLE;
#line 809 "tracker-sparql-expression.c"
	}
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = _tmp3_;
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp6_) {
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = TRUE;
#line 817 "tracker-sparql-expression.c"
	} else {
		TrackerPropertyType _tmp7_;
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = type;
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = _tmp7_ == TRACKER_PROPERTY_TYPE_DATE;
#line 824 "tracker-sparql-expression.c"
	}
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp8_ = _tmp2_;
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp8_) {
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp1_ = TRUE;
#line 832 "tracker-sparql-expression.c"
	} else {
		TrackerPropertyType _tmp9_;
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = type;
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp1_ = _tmp9_ == TRACKER_PROPERTY_TYPE_DATETIME;
#line 839 "tracker-sparql-expression.c"
	}
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp10_ = _tmp1_;
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp10_) {
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp0_ = TRUE;
#line 847 "tracker-sparql-expression.c"
	} else {
		TrackerPropertyType _tmp11_;
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = type;
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp0_ = _tmp11_ == TRACKER_PROPERTY_TYPE_UNKNOWN;
#line 854 "tracker-sparql-expression.c"
	}
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp12_ = _tmp0_;
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp12_;
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 862 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_append_collate (TrackerSparqlExpression* self, GString* sql) {
	GString* _tmp0_;
#line 79 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 79 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 80 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 80 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append_printf (_tmp0_, " COLLATE %s", TRACKER_COLLATION_NAME);
#line 876 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_skip_bracketted_expression (TrackerSparqlExpression* self, GError** error) {
	GError * _inner_error_ = NULL;
#line 83 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 84 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 84 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 84 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 84 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 84 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 894 "tracker-sparql-expression.c"
		} else {
#line 84 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 84 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 84 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 902 "tracker-sparql-expression.c"
		}
	}
#line 85 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 907 "tracker-sparql-expression.c"
		TrackerSparqlTokenType _tmp0_ = 0;
#line 86 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp0_ = tracker_sparql_expression_current (self);
#line 86 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		switch (_tmp0_) {
#line 86 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
#line 915 "tracker-sparql-expression.c"
			{
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_skip_bracketted_expression (self, &_inner_error_);
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 927 "tracker-sparql-expression.c"
					} else {
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 935 "tracker-sparql-expression.c"
					}
				}
#line 90 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				continue;
#line 940 "tracker-sparql-expression.c"
			}
#line 86 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS:
#line 86 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_EOF:
#line 946 "tracker-sparql-expression.c"
			{
#line 93 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				break;
#line 950 "tracker-sparql-expression.c"
			}
			default:
			{
#line 95 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_next (self, &_inner_error_);
#line 95 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 95 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 95 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 95 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 964 "tracker-sparql-expression.c"
					} else {
#line 95 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 95 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 95 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 972 "tracker-sparql-expression.c"
					}
				}
#line 96 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				continue;
#line 977 "tracker-sparql-expression.c"
			}
		}
#line 98 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		break;
#line 982 "tracker-sparql-expression.c"
	}
#line 100 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 100 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 100 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 100 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 100 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 994 "tracker-sparql-expression.c"
		} else {
#line 100 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 100 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 100 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 1002 "tracker-sparql-expression.c"
		}
	}
}


void tracker_sparql_expression_skip_select_variables (TrackerSparqlExpression* self, GError** error) {
	GError * _inner_error_ = NULL;
#line 103 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 104 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 1014 "tracker-sparql-expression.c"
		TrackerSparqlTokenType _tmp0_ = 0;
#line 105 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp0_ = tracker_sparql_expression_current (self);
#line 105 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		switch (_tmp0_) {
#line 105 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
#line 1022 "tracker-sparql-expression.c"
			{
#line 107 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_skip_bracketted_expression (self, &_inner_error_);
#line 107 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 107 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 107 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 107 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 1034 "tracker-sparql-expression.c"
					} else {
#line 107 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 107 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 107 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 1042 "tracker-sparql-expression.c"
					}
				}
#line 108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				continue;
#line 1047 "tracker-sparql-expression.c"
			}
#line 105 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_FROM:
#line 105 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_WHERE:
#line 105 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE:
#line 105 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_GROUP:
#line 105 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_ORDER:
#line 105 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_LIMIT:
#line 105 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_OFFSET:
#line 105 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			case TRACKER_SPARQL_TOKEN_TYPE_EOF:
#line 1065 "tracker-sparql-expression.c"
			{
#line 117 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				break;
#line 1069 "tracker-sparql-expression.c"
			}
			default:
			{
#line 119 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_next (self, &_inner_error_);
#line 119 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 119 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 119 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 119 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 1083 "tracker-sparql-expression.c"
					} else {
#line 119 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 119 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 119 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 1091 "tracker-sparql-expression.c"
					}
				}
#line 120 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				continue;
#line 1096 "tracker-sparql-expression.c"
			}
		}
#line 122 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		break;
#line 1101 "tracker-sparql-expression.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
#line 1147 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1147 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1147 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1147 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1148 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1148 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 1125 "tracker-sparql-expression.c"
		glong _tmp4_;
#line 1149 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1149 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1149 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 1133 "tracker-sparql-expression.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1151 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1151 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1151 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1151 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 1145 "tracker-sparql-expression.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1158 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1160 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1160 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 1170 "tracker-sparql-expression.c"
		glong _tmp2_;
#line 1160 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1160 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 1176 "tracker-sparql-expression.c"
	} else {
#line 1160 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1180 "tracker-sparql-expression.c"
	}
#line 1160 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1160 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 1186 "tracker-sparql-expression.c"
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
#line 1162 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1162 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1162 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1162 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 1198 "tracker-sparql-expression.c"
	} else {
		gint _tmp7_;
		gint _tmp8_;
#line 1164 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1164 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1164 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 1208 "tracker-sparql-expression.c"
	}
#line 1167 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1167 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 1214 "tracker-sparql-expression.c"
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
#line 1168 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1168 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1168 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1169 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1169 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 1228 "tracker-sparql-expression.c"
	} else {
		glong _tmp13_;
		glong _tmp14_;
#line 1171 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1171 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1171 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 1238 "tracker-sparql-expression.c"
	}
#line 1173 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1173 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 1244 "tracker-sparql-expression.c"
		glong _tmp16_;
		glong _tmp17_;
#line 1174 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1174 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1174 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 1253 "tracker-sparql-expression.c"
	}
#line 1176 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1176 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1176 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1176 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1177 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1177 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1177 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1177 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1177 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 1273 "tracker-sparql-expression.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 135 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return self ? g_object_ref (self) : NULL;
#line 1280 "tracker-sparql-expression.c"
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
#line 201 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if ((*length) == (*size)) {
#line 201 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 201 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1291 "tracker-sparql-expression.c"
	}
#line 201 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[(*length)++] = value;
#line 201 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[*length] = NULL;
#line 1297 "tracker-sparql-expression.c"
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if ((*length) == (*size)) {
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1308 "tracker-sparql-expression.c"
	}
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[(*length)++] = value;
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[*length] = NULL;
#line 1314 "tracker-sparql-expression.c"
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
#line 220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if ((*length) == (*size)) {
#line 220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1325 "tracker-sparql-expression.c"
	}
#line 220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[(*length)++] = value;
#line 220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[*length] = NULL;
#line 1331 "tracker-sparql-expression.c"
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if ((*length) == (*size)) {
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1342 "tracker-sparql-expression.c"
	}
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[(*length)++] = value;
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	(*array)[*length] = NULL;
#line 1348 "tracker-sparql-expression.c"
}


TrackerPropertyType tracker_sparql_expression_translate_select_expression (TrackerSparqlExpression* self, GString* sql, gboolean subquery, gint variable_index, GError** error) {
	TrackerPropertyType result = 0;
	TrackerSparqlVariable* variable;
	gboolean expect_close_parens;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	TrackerPropertyType type;
	TrackerSparqlTokenType _tmp2_ = 0;
	gboolean _tmp42_;
	gboolean _tmp46_ = FALSE;
	gboolean _tmp47_;
	TrackerSparqlPattern* _tmp83_;
	TrackerSparqlPattern* _tmp84_;
	TrackerSparqlVariable* _tmp85_;
	gboolean _tmp117_;
	TrackerSparqlVariable* _tmp118_;
	GError * _inner_error_ = NULL;
#line 126 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 126 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 127 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	variable = NULL;
#line 128 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	expect_close_parens = FALSE;
#line 130 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 130 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 130 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	type = TRACKER_PROPERTY_TYPE_UNKNOWN;
#line 132 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = tracker_sparql_expression_current (self);
#line 132 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp2_ == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
#line 1390 "tracker-sparql-expression.c"
		GString* _tmp3_;
		TrackerPropertyType _tmp4_ = 0;
		TrackerPropertyType _tmp5_;
		TrackerSparqlContext* _tmp6_;
		TrackerSparqlContext* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		TrackerSparqlVariable* _tmp12_ = NULL;
		TrackerSparqlVariable* _tmp13_;
		TrackerSparqlVariable* _tmp14_;
		TrackerSparqlVariableBinding* _tmp15_;
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = sql;
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_translate_expression (self, _tmp3_, &_inner_error_);
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1420 "tracker-sparql-expression.c"
			} else {
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1430 "tracker-sparql-expression.c"
			}
		}
#line 133 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		type = _tmp5_;
#line 135 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = tracker_sparql_expression_get_context (self);
#line 135 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = _tmp6_;
#line 135 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = tracker_sparql_expression_get_last_string (self, 0);
#line 135 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = _tmp8_;
#line 135 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = string_substring (_tmp9_, (glong) 1, (glong) (-1));
#line 135 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = _tmp10_;
#line 135 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = tracker_sparql_context_get_variable (_tmp7_, _tmp11_);
#line 135 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = _g_object_ref0 (_tmp12_);
#line 135 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_object_unref0 (variable);
#line 135 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		variable = _tmp13_;
#line 135 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp11_);
#line 135 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp9_);
#line 137 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp14_ = variable;
#line 137 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = _tmp14_->binding;
#line 137 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp15_ == NULL) {
#line 1465 "tracker-sparql-expression.c"
			TrackerSparqlVariable* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			GError* _tmp21_ = NULL;
			GError* _tmp22_;
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = variable;
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = tracker_sparql_variable_get_name (_tmp16_);
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = _tmp17_;
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = g_strdup_printf ("use of undefined variable `%s'", _tmp18_);
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = _tmp19_;
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp21_ = tracker_sparql_expression_get_error (self, _tmp20_);
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp22_ = _tmp21_;
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp20_);
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp22_;
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1499 "tracker-sparql-expression.c"
			} else {
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1509 "tracker-sparql-expression.c"
			}
		}
	} else {
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp23_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp24_ = _tmp23_;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1529 "tracker-sparql-expression.c"
			} else {
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1539 "tracker-sparql-expression.c"
			}
		}
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp24_) {
#line 1544 "tracker-sparql-expression.c"
			TrackerSparqlTokenType _tmp25_ = 0;
#line 141 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp25_ = tracker_sparql_expression_current (self);
#line 141 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp25_ == TRACKER_SPARQL_TOKEN_TYPE_SELECT) {
#line 1550 "tracker-sparql-expression.c"
				GString* _tmp26_;
				TrackerSparqlPattern* _tmp27_;
				TrackerSparqlPattern* _tmp28_;
				GString* _tmp29_;
				TrackerSparqlSelectContext* _tmp30_ = NULL;
				TrackerSparqlSelectContext* select_context;
				GString* _tmp31_;
				TrackerSparqlSelectContext* _tmp32_;
				TrackerPropertyType _tmp33_;
#line 144 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp26_ = sql;
#line 144 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp26_, "(");
#line 145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = tracker_sparql_expression_get_pattern (self);
#line 145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp28_ = _tmp27_;
#line 145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp29_ = sql;
#line 145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp30_ = tracker_sparql_pattern_translate_select (_tmp28_, _tmp29_, TRUE, TRUE, &_inner_error_);
#line 145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				select_context = _tmp30_;
#line 145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1584 "tracker-sparql-expression.c"
					} else {
#line 145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1594 "tracker-sparql-expression.c"
					}
				}
#line 146 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp31_ = sql;
#line 146 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp31_, ")");
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tracker_sparql_context_unref0 (select_context);
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1615 "tracker-sparql-expression.c"
					} else {
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tracker_sparql_context_unref0 (select_context);
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1627 "tracker-sparql-expression.c"
					}
				}
#line 149 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp32_ = select_context;
#line 149 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp33_ = _tmp32_->type;
#line 149 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				type = _tmp33_;
#line 141 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tracker_sparql_context_unref0 (select_context);
#line 1638 "tracker-sparql-expression.c"
			} else {
				GString* _tmp34_;
				TrackerPropertyType _tmp35_ = 0;
				TrackerPropertyType _tmp36_;
				gboolean _tmp37_ = FALSE;
				gboolean _tmp38_;
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp34_ = sql;
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp35_ = tracker_sparql_expression_translate_expression (self, _tmp34_, &_inner_error_);
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp36_ = _tmp35_;
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1661 "tracker-sparql-expression.c"
					} else {
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1671 "tracker-sparql-expression.c"
					}
				}
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				type = _tmp36_;
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp37_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp38_ = _tmp37_;
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1690 "tracker-sparql-expression.c"
					} else {
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (variable);
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 1700 "tracker-sparql-expression.c"
					}
				}
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_tmp38_) {
#line 1705 "tracker-sparql-expression.c"
				} else {
#line 158 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					expect_close_parens = TRUE;
#line 1709 "tracker-sparql-expression.c"
				}
			}
		} else {
			GString* _tmp39_;
			TrackerPropertyType _tmp40_ = 0;
			TrackerPropertyType _tmp41_;
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp39_ = sql;
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp40_ = tracker_sparql_expression_translate_expression (self, _tmp39_, &_inner_error_);
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp41_ = _tmp40_;
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (variable);
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 1732 "tracker-sparql-expression.c"
				} else {
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (variable);
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 1742 "tracker-sparql-expression.c"
				}
			}
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp41_;
#line 1747 "tracker-sparql-expression.c"
		}
	}
#line 167 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp42_ = subquery;
#line 167 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (!_tmp42_) {
#line 1754 "tracker-sparql-expression.c"
		GString* _tmp43_;
		TrackerPropertyType _tmp44_;
		glong _tmp45_;
#line 168 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp43_ = sql;
#line 168 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp44_ = type;
#line 168 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp45_ = begin;
#line 168 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_convert_expression_to_string (_tmp43_, _tmp44_, _tmp45_);
#line 1766 "tracker-sparql-expression.c"
	}
#line 171 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp46_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_AS, &_inner_error_);
#line 171 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp47_ = _tmp46_;
#line 171 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 171 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 171 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 171 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 171 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 1782 "tracker-sparql-expression.c"
		} else {
#line 171 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 171 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 171 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 171 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 1792 "tracker-sparql-expression.c"
		}
	}
#line 171 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp47_) {
#line 1797 "tracker-sparql-expression.c"
		gboolean _tmp48_ = FALSE;
		gboolean _tmp49_;
		GString* _tmp64_;
		TrackerSparqlVariable* _tmp65_;
		const gchar* _tmp66_;
		const gchar* _tmp67_;
		gboolean _tmp68_;
#line 172 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp48_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 172 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp49_ = _tmp48_;
#line 172 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 172 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 172 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 172 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 172 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1819 "tracker-sparql-expression.c"
			} else {
#line 172 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 172 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 172 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 172 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 1829 "tracker-sparql-expression.c"
			}
		}
#line 172 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp49_) {
#line 1834 "tracker-sparql-expression.c"
			TrackerSparqlContext* _tmp50_;
			TrackerSparqlContext* _tmp51_;
			gchar* _tmp52_ = NULL;
			gchar* _tmp53_;
			TrackerSparqlVariable* _tmp54_ = NULL;
			TrackerSparqlVariable* _tmp55_;
#line 175 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp50_ = tracker_sparql_expression_get_context (self);
#line 175 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp51_ = _tmp50_;
#line 175 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp52_ = tracker_sparql_expression_get_last_string (self, 0);
#line 175 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp53_ = _tmp52_;
#line 175 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp54_ = tracker_sparql_context_get_variable (_tmp51_, _tmp53_);
#line 175 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp55_ = _g_object_ref0 (_tmp54_);
#line 175 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 175 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			variable = _tmp55_;
#line 175 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp53_);
#line 1859 "tracker-sparql-expression.c"
		} else {
			TrackerSparqlContext* _tmp56_;
			TrackerSparqlContext* _tmp57_;
			gchar* _tmp58_ = NULL;
			gchar* _tmp59_;
			gchar* _tmp60_ = NULL;
			gchar* _tmp61_;
			TrackerSparqlVariable* _tmp62_ = NULL;
			TrackerSparqlVariable* _tmp63_;
#line 179 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 179 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 179 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 179 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 179 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (variable);
#line 179 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 1881 "tracker-sparql-expression.c"
				} else {
#line 179 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (variable);
#line 179 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 179 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 179 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 1891 "tracker-sparql-expression.c"
				}
			}
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp56_ = tracker_sparql_expression_get_context (self);
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp57_ = _tmp56_;
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp58_ = tracker_sparql_expression_get_last_string (self, 0);
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp59_ = _tmp58_;
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp60_ = string_substring (_tmp59_, (glong) 1, (glong) (-1));
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp61_ = _tmp60_;
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp62_ = tracker_sparql_context_get_variable (_tmp57_, _tmp61_);
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp63_ = _g_object_ref0 (_tmp62_);
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			variable = _tmp63_;
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp61_);
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp59_);
#line 1918 "tracker-sparql-expression.c"
		}
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp64_ = sql;
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp65_ = variable;
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp66_ = tracker_sparql_variable_get_sql_expression (_tmp65_);
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp67_ = _tmp66_;
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append_printf (_tmp64_, " AS %s", _tmp67_);
#line 184 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp68_ = subquery;
#line 184 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp68_) {
#line 1934 "tracker-sparql-expression.c"
			TrackerSparqlVariableBinding* _tmp69_;
			TrackerSparqlVariableBinding* binding;
			TrackerSparqlVariableBinding* _tmp70_;
			TrackerPropertyType _tmp71_;
			TrackerSparqlVariableBinding* _tmp72_;
			TrackerSparqlVariable* _tmp73_;
			TrackerSparqlVariableBinding* _tmp74_;
			TrackerSparqlVariable* _tmp75_;
			const gchar* _tmp76_;
			const gchar* _tmp77_;
			TrackerSparqlPattern* _tmp78_;
			TrackerSparqlPattern* _tmp79_;
			GString* _tmp80_;
			GString* _tmp81_;
			TrackerSparqlVariableBinding* _tmp82_;
#line 185 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp69_ = tracker_sparql_variable_binding_new ();
#line 185 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			binding = _tmp69_;
#line 186 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp70_ = binding;
#line 186 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp71_ = type;
#line 186 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			((TrackerSparqlDataBinding*) _tmp70_)->data_type = _tmp71_;
#line 187 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp72_ = binding;
#line 187 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp73_ = variable;
#line 187 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp72_->variable = _tmp73_;
#line 188 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp74_ = binding;
#line 188 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp75_ = variable;
#line 188 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp76_ = tracker_sparql_variable_get_sql_expression (_tmp75_);
#line 188 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp77_ = _tmp76_;
#line 188 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_data_binding_set_sql_expression ((TrackerSparqlDataBinding*) _tmp74_, _tmp77_);
#line 189 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp78_ = tracker_sparql_expression_get_pattern (self);
#line 189 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp79_ = _tmp78_;
#line 189 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp80_ = g_string_new ("");
#line 189 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp81_ = _tmp80_;
#line 189 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp82_ = binding;
#line 189 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_pattern_add_variable_binding (_tmp79_, _tmp81_, _tmp82_, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
#line 189 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_string_free0 (_tmp81_);
#line 184 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (binding);
#line 1992 "tracker-sparql-expression.c"
		}
	}
#line 193 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp83_ = tracker_sparql_expression_get_pattern (self);
#line 193 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp84_ = _tmp83_;
#line 193 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp85_ = _tmp84_->fts_subject;
#line 193 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp85_ != NULL) {
#line 2003 "tracker-sparql-expression.c"
		TrackerSparqlVariable* _tmp86_;
		const gchar* _tmp94_;
#line 194 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp86_ = variable;
#line 194 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp86_ == NULL) {
#line 2010 "tracker-sparql-expression.c"
			TrackerSparqlContext* _tmp87_;
			TrackerSparqlContext* _tmp88_;
			gint _tmp89_;
			gchar* _tmp90_ = NULL;
			gchar* _tmp91_;
			TrackerSparqlVariable* _tmp92_ = NULL;
			TrackerSparqlVariable* _tmp93_;
#line 197 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp87_ = tracker_sparql_expression_get_context (self);
#line 197 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp88_ = _tmp87_;
#line 197 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp89_ = variable_index;
#line 197 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp90_ = g_strdup_printf ("var%d", _tmp89_ + 1);
#line 197 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp91_ = _tmp90_;
#line 197 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp92_ = tracker_sparql_context_get_variable (_tmp88_, _tmp91_);
#line 197 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp93_ = _g_object_ref0 (_tmp92_);
#line 197 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 197 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			variable = _tmp93_;
#line 197 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp91_);
#line 2038 "tracker-sparql-expression.c"
		}
#line 200 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp94_ = self->priv->fts_sql;
#line 200 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp94_ == NULL) {
#line 2044 "tracker-sparql-expression.c"
			TrackerSparqlPattern* _tmp95_;
			TrackerSparqlPattern* _tmp96_;
			TrackerSparqlPattern* _tmp97_;
			TrackerSparqlPattern* _tmp98_;
			gchar** _tmp99_;
			gint _tmp99__length1;
			TrackerSparqlVariable* _tmp100_;
			const gchar* _tmp101_;
			const gchar* _tmp102_;
			gchar* _tmp103_;
			GString* _tmp104_;
			TrackerSparqlVariable* _tmp105_;
			const gchar* _tmp106_;
			const gchar* _tmp107_;
#line 201 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp95_ = tracker_sparql_expression_get_pattern (self);
#line 201 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp96_ = _tmp95_;
#line 201 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp97_ = tracker_sparql_expression_get_pattern (self);
#line 201 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp98_ = _tmp97_;
#line 201 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp99_ = _tmp98_->fts_variables;
#line 201 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp99__length1 = _tmp98_->fts_variables_length1;
#line 201 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp100_ = variable;
#line 201 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp101_ = tracker_sparql_variable_get_sql_expression (_tmp100_);
#line 201 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp102_ = _tmp101_;
#line 201 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp103_ = g_strdup (_tmp102_);
#line 201 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_vala_array_add1 (&_tmp96_->fts_variables, &_tmp96_->fts_variables_length1, &_tmp96_->_fts_variables_size_, _tmp103_);
#line 202 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp104_ = sql;
#line 202 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp105_ = variable;
#line 202 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp106_ = tracker_sparql_variable_get_sql_expression (_tmp105_);
#line 202 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp107_ = _tmp106_;
#line 202 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append_printf (_tmp104_, " AS %s", _tmp107_);
#line 2091 "tracker-sparql-expression.c"
		} else {
			TrackerSparqlPattern* _tmp108_;
			TrackerSparqlPattern* _tmp109_;
			TrackerSparqlPattern* _tmp110_;
			TrackerSparqlPattern* _tmp111_;
			gchar** _tmp112_;
			gint _tmp112__length1;
			const gchar* _tmp113_;
			gchar* _tmp114_;
			TrackerSparqlPattern* _tmp115_;
			TrackerSparqlPattern* _tmp116_;
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp108_ = tracker_sparql_expression_get_pattern (self);
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp109_ = _tmp108_;
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp110_ = tracker_sparql_expression_get_pattern (self);
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp111_ = _tmp110_;
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp112_ = _tmp111_->fts_variables;
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp112__length1 = _tmp111_->fts_variables_length1;
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp113_ = self->priv->fts_sql;
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp114_ = g_strdup (_tmp113_);
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_vala_array_add2 (&_tmp109_->fts_variables, &_tmp109_->fts_variables_length1, &_tmp109_->_fts_variables_size_, _tmp114_);
#line 205 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp115_ = tracker_sparql_expression_get_pattern (self);
#line 205 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp116_ = _tmp115_;
#line 205 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp116_->queries_fts_data = TRUE;
#line 2127 "tracker-sparql-expression.c"
		}
	}
#line 209 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp117_ = expect_close_parens;
#line 209 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp117_) {
#line 210 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 210 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 210 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 210 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 210 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 210 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 2146 "tracker-sparql-expression.c"
			} else {
#line 210 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 210 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 210 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 210 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 2156 "tracker-sparql-expression.c"
			}
		}
	}
#line 213 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp118_ = variable;
#line 213 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp118_ != NULL) {
#line 2164 "tracker-sparql-expression.c"
		TrackerSparqlContext* _tmp119_;
		TrackerSparqlContext* _tmp120_;
		GHashTable* _tmp121_;
		TrackerSparqlVariable* _tmp122_;
		gconstpointer _tmp123_ = NULL;
		gint state;
		gint _tmp124_;
		TrackerSparqlContext* _tmp125_;
		TrackerSparqlContext* _tmp126_;
		GHashTable* _tmp127_;
		TrackerSparqlVariable* _tmp128_;
		TrackerSparqlVariable* _tmp129_;
		gint _tmp130_;
		TrackerSparqlContext* _tmp131_;
		TrackerSparqlContext* _tmp132_;
		TrackerSparqlContext* _tmp133_;
		TrackerSparqlContext* _tmp134_;
		gchar** _tmp135_;
		gint _tmp135__length1;
		TrackerSparqlVariable* _tmp136_;
		const gchar* _tmp137_;
		const gchar* _tmp138_;
		gchar* _tmp139_;
#line 214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp119_ = tracker_sparql_expression_get_context (self);
#line 214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp120_ = _tmp119_;
#line 214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp121_ = _tmp120_->var_set;
#line 214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp122_ = variable;
#line 214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp123_ = g_hash_table_lookup (_tmp121_, _tmp122_);
#line 214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		state = (gint) ((gintptr) _tmp123_);
#line 215 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp124_ = state;
#line 215 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp124_ == 0) {
#line 216 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			state = (gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND;
#line 2206 "tracker-sparql-expression.c"
		}
#line 218 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp125_ = tracker_sparql_expression_get_context (self);
#line 218 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp126_ = _tmp125_;
#line 218 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp127_ = _tmp126_->select_var_set;
#line 218 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp128_ = variable;
#line 218 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp129_ = _g_object_ref0 (_tmp128_);
#line 218 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp130_ = state;
#line 218 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_hash_table_insert (_tmp127_, _tmp129_, (gpointer) ((gintptr) _tmp130_));
#line 220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp131_ = tracker_sparql_expression_get_context (self);
#line 220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp132_ = _tmp131_;
#line 220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp133_ = tracker_sparql_expression_get_context (self);
#line 220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp134_ = _tmp133_;
#line 220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp135_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp134_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names;
#line 220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp135__length1 = G_TYPE_CHECK_INSTANCE_CAST (_tmp134_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names_length1;
#line 220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp136_ = variable;
#line 220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp137_ = tracker_sparql_variable_get_name (_tmp136_);
#line 220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp138_ = _tmp137_;
#line 220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp139_ = g_strdup (_tmp138_);
#line 220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_vala_array_add3 (&G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names, &G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names_length1, &G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->_variable_names_size_, _tmp139_);
#line 2244 "tracker-sparql-expression.c"
	} else {
		TrackerSparqlContext* _tmp140_;
		TrackerSparqlContext* _tmp141_;
		TrackerSparqlContext* _tmp142_;
		TrackerSparqlContext* _tmp143_;
		gchar** _tmp144_;
		gint _tmp144__length1;
		gint _tmp145_;
		gchar* _tmp146_ = NULL;
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp140_ = tracker_sparql_expression_get_context (self);
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp141_ = _tmp140_;
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp142_ = tracker_sparql_expression_get_context (self);
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp143_ = _tmp142_;
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp144_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp143_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names;
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp144__length1 = G_TYPE_CHECK_INSTANCE_CAST (_tmp143_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names_length1;
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp145_ = variable_index;
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp146_ = g_strdup_printf ("var%d", _tmp145_ + 1);
#line 222 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_vala_array_add4 (&G_TYPE_CHECK_INSTANCE_CAST (_tmp141_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names, &G_TYPE_CHECK_INSTANCE_CAST (_tmp141_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->variable_names_length1, &G_TYPE_CHECK_INSTANCE_CAST (_tmp141_, TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext)->_variable_names_size_, _tmp146_);
#line 2272 "tracker-sparql-expression.c"
	}
#line 225 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_free0 (self->priv->fts_sql);
#line 225 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	self->priv->fts_sql = NULL;
#line 227 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = type;
#line 227 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_object_unref0 (variable);
#line 227 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 2284 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_translate_expression_as_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	TrackerPropertyType _tmp3_ = 0;
	TrackerPropertyType _tmp4_;
	GError * _inner_error_ = NULL;
#line 230 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 230 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 231 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 231 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 231 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 232 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 232 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_translate_expression (self, _tmp2_, &_inner_error_);
#line 232 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = _tmp3_;
#line 232 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 232 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 232 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 232 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2320 "tracker-sparql-expression.c"
		} else {
#line 232 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 232 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 232 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2328 "tracker-sparql-expression.c"
		}
	}
#line 232 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp4_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 2333 "tracker-sparql-expression.c"
		GString* _tmp5_;
		GString* _tmp6_;
#line 234 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = sql;
#line 234 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_insert (_tmp5_, (gssize) begin, "(SELECT Uri FROM Resource WHERE ID = ");
#line 235 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = sql;
#line 235 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp6_, ")");
#line 2344 "tracker-sparql-expression.c"
	}
}


void tracker_sparql_expression_translate_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 239 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 239 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 240 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ASC, &_inner_error_);
#line 240 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 240 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 240 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 240 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 240 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2369 "tracker-sparql-expression.c"
		} else {
#line 240 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 240 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 240 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2377 "tracker-sparql-expression.c"
		}
	}
#line 240 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 2382 "tracker-sparql-expression.c"
		GString* _tmp2_;
		GString* _tmp3_;
#line 241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = sql;
#line 241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_translate_expression_as_order_condition (self, _tmp2_, &_inner_error_);
#line 241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 2397 "tracker-sparql-expression.c"
			} else {
#line 241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 2405 "tracker-sparql-expression.c"
			}
		}
#line 242 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = sql;
#line 242 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp3_, " ASC");
#line 2412 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
#line 243 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DESC, &_inner_error_);
#line 243 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 243 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 243 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 243 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 243 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 2428 "tracker-sparql-expression.c"
			} else {
#line 243 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 243 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 243 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 2436 "tracker-sparql-expression.c"
			}
		}
#line 243 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp5_) {
#line 2441 "tracker-sparql-expression.c"
			GString* _tmp6_;
			GString* _tmp7_;
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = sql;
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_order_condition (self, _tmp6_, &_inner_error_);
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 2456 "tracker-sparql-expression.c"
				} else {
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 2464 "tracker-sparql-expression.c"
				}
			}
#line 245 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = sql;
#line 245 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp7_, " DESC");
#line 2471 "tracker-sparql-expression.c"
		} else {
			GString* _tmp8_;
#line 247 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = sql;
#line 247 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_order_condition (self, _tmp8_, &_inner_error_);
#line 247 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 247 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 247 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 247 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 2486 "tracker-sparql-expression.c"
				} else {
#line 247 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 247 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 247 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 2494 "tracker-sparql-expression.c"
				}
			}
		}
	}
}


static void tracker_sparql_expression_translate_bound_call (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GString* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	GError * _inner_error_ = NULL;
#line 251 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 251 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 252 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_BOUND, &_inner_error_);
#line 252 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 252 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 252 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 252 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2521 "tracker-sparql-expression.c"
		} else {
#line 252 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 252 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 252 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2529 "tracker-sparql-expression.c"
		}
	}
#line 253 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 253 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 253 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 253 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 253 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2542 "tracker-sparql-expression.c"
		} else {
#line 253 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 253 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 253 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2550 "tracker-sparql-expression.c"
		}
	}
#line 254 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 254 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp0_, "(");
#line 255 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = sql;
#line 255 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression (self, _tmp1_, &_inner_error_);
#line 255 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 255 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 255 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 255 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2569 "tracker-sparql-expression.c"
		} else {
#line 255 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 255 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 255 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2577 "tracker-sparql-expression.c"
		}
	}
#line 256 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 256 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, " IS NOT NULL)");
#line 257 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 257 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 257 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 257 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 257 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2594 "tracker-sparql-expression.c"
		} else {
#line 257 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 257 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 257 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2602 "tracker-sparql-expression.c"
		}
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_if_call (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	GString* _tmp3_;
	TrackerPropertyType _tmp4_ = 0;
	TrackerPropertyType type;
	GString* _tmp5_;
	GString* _tmp6_;
	GString* _tmp7_;
	GError * _inner_error_ = NULL;
#line 260 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 260 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 261 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IF, &_inner_error_);
#line 261 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 261 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 261 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 261 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2634 "tracker-sparql-expression.c"
		} else {
#line 261 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 261 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 261 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2642 "tracker-sparql-expression.c"
		}
	}
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2655 "tracker-sparql-expression.c"
		} else {
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2663 "tracker-sparql-expression.c"
		}
	}
#line 265 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 265 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp0_, "(CASE ");
#line 266 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = sql;
#line 266 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression (self, _tmp1_, &_inner_error_);
#line 266 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 266 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 266 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 266 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2682 "tracker-sparql-expression.c"
		} else {
#line 266 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 266 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 266 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2690 "tracker-sparql-expression.c"
		}
	}
#line 269 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 269 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, " WHEN 1 THEN ");
#line 270 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 270 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 270 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 270 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 270 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2707 "tracker-sparql-expression.c"
		} else {
#line 270 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 270 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 270 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2715 "tracker-sparql-expression.c"
		}
	}
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = sql;
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = tracker_sparql_expression_translate_expression (self, _tmp3_, &_inner_error_);
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	type = _tmp4_;
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2732 "tracker-sparql-expression.c"
		} else {
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2740 "tracker-sparql-expression.c"
		}
	}
#line 274 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = sql;
#line 274 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp5_, " WHEN 0 THEN ");
#line 275 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 275 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 275 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 275 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 275 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2757 "tracker-sparql-expression.c"
		} else {
#line 275 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 275 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 275 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2765 "tracker-sparql-expression.c"
		}
	}
#line 276 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = sql;
#line 276 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression (self, _tmp6_, &_inner_error_);
#line 276 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 276 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 276 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 276 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2780 "tracker-sparql-expression.c"
		} else {
#line 276 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 276 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 276 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2788 "tracker-sparql-expression.c"
		}
	}
#line 278 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp7_ = sql;
#line 278 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp7_, " ELSE NULL END)");
#line 280 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 280 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 280 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 280 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 280 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2805 "tracker-sparql-expression.c"
		} else {
#line 280 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 280 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 280 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 2813 "tracker-sparql-expression.c"
		}
	}
#line 282 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = type;
#line 282 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 2820 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_translate_regex (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GString* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GString* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_;
	GString* _tmp19_;
	GError * _inner_error_ = NULL;
#line 285 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 285 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 286 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_REGEX, &_inner_error_);
#line 286 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 286 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 286 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 286 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2853 "tracker-sparql-expression.c"
		} else {
#line 286 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 286 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 286 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2861 "tracker-sparql-expression.c"
		}
	}
#line 287 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 287 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 287 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 287 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 287 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2874 "tracker-sparql-expression.c"
		} else {
#line 287 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 287 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 287 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2882 "tracker-sparql-expression.c"
		}
	}
#line 288 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 288 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp0_, "SparqlRegex(");
#line 289 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = sql;
#line 289 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression_as_string (self, _tmp1_, &_inner_error_);
#line 289 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 289 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 289 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 289 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2901 "tracker-sparql-expression.c"
		} else {
#line 289 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 289 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 289 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2909 "tracker-sparql-expression.c"
		}
	}
#line 290 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 290 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, ", ");
#line 291 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 291 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 291 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 291 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 291 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2926 "tracker-sparql-expression.c"
		} else {
#line 291 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 291 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 291 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2934 "tracker-sparql-expression.c"
		}
	}
#line 295 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 295 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = _tmp3_;
#line 295 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 295 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 295 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 295 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2949 "tracker-sparql-expression.c"
		} else {
#line 295 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 295 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 295 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2957 "tracker-sparql-expression.c"
		}
	}
#line 295 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = sql;
#line 295 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = _tmp4_;
#line 295 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp7_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp6_);
#line 295 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp8_ = _tmp7_;
#line 295 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp5_, _tmp8_);
#line 295 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_free0 (_tmp8_);
#line 295 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_free0 (_tmp6_);
#line 296 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp9_ = sql;
#line 296 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp9_, ", ");
#line 297 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp10_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 297 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp11_ = _tmp10_;
#line 297 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 297 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 297 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 297 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2990 "tracker-sparql-expression.c"
		} else {
#line 297 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 297 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 297 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 2998 "tracker-sparql-expression.c"
		}
	}
#line 297 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp11_) {
#line 3003 "tracker-sparql-expression.c"
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		GString* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
#line 300 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 300 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = _tmp12_;
#line 300 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 300 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 300 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 300 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3022 "tracker-sparql-expression.c"
			} else {
#line 300 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 300 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 300 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3030 "tracker-sparql-expression.c"
			}
		}
#line 300 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp14_ = sql;
#line 300 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = _tmp13_;
#line 300 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp16_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp15_);
#line 300 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp17_ = _tmp16_;
#line 300 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp14_, _tmp17_);
#line 300 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp17_);
#line 300 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp15_);
#line 3047 "tracker-sparql-expression.c"
	} else {
		GString* _tmp18_;
#line 302 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp18_ = sql;
#line 302 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp18_, "''");
#line 3054 "tracker-sparql-expression.c"
	}
#line 304 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp19_ = sql;
#line 304 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp19_, ")");
#line 305 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 305 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 305 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 305 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 305 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3070 "tracker-sparql-expression.c"
		} else {
#line 305 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 305 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 305 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3078 "tracker-sparql-expression.c"
		}
	}
}


static void tracker_sparql_expression_translate_exists (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GString* _tmp0_;
	TrackerSparqlPattern* _tmp1_;
	TrackerSparqlPattern* _tmp2_;
	GString* _tmp3_;
	GString* _tmp4_;
	GError * _inner_error_ = NULL;
#line 308 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 308 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 309 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 309 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp0_, "(");
#line 310 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_expression_get_pattern (self);
#line 310 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_;
#line 310 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = sql;
#line 310 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_pattern_translate_exists (_tmp2_, _tmp3_, &_inner_error_);
#line 310 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 310 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 310 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 310 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3115 "tracker-sparql-expression.c"
		} else {
#line 310 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 310 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 310 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3123 "tracker-sparql-expression.c"
		}
	}
#line 311 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = sql;
#line 311 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp4_, ")");
#line 3130 "tracker-sparql-expression.c"
}


void tracker_sparql_expression_append_expression_as_string (GString* sql, const gchar* expression, TrackerPropertyType type) {
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	const gchar* _tmp3_;
	GString* _tmp4_;
	TrackerPropertyType _tmp5_;
#line 314 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 314 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (expression != NULL);
#line 315 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 315 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 315 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 316 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 316 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = expression;
#line 316 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, _tmp3_);
#line 317 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = sql;
#line 317 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = type;
#line 317 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_convert_expression_to_string (_tmp4_, _tmp5_, begin);
#line 3164 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_convert_expression_to_string (GString* sql, TrackerPropertyType type, glong begin) {
	TrackerPropertyType _tmp0_;
#line 320 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 321 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = type;
#line 321 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (_tmp0_) {
#line 321 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_STRING:
#line 321 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_INTEGER:
#line 3180 "tracker-sparql-expression.c"
		{
#line 327 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3184 "tracker-sparql-expression.c"
		}
#line 321 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_RESOURCE:
#line 3188 "tracker-sparql-expression.c"
		{
			GString* _tmp1_;
			glong _tmp2_;
			GString* _tmp3_;
#line 330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp1_ = sql;
#line 330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp2_ = begin;
#line 330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp1_, (gssize) _tmp2_, "(SELECT Uri FROM Resource WHERE ID = ");
#line 331 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = sql;
#line 331 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp3_, ")");
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3205 "tracker-sparql-expression.c"
		}
#line 321 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_BOOLEAN:
#line 3209 "tracker-sparql-expression.c"
		{
			GString* _tmp4_;
			glong _tmp5_;
			GString* _tmp6_;
#line 335 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp4_ = sql;
#line 335 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = begin;
#line 335 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp4_, (gssize) _tmp5_, "CASE ");
#line 336 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = sql;
#line 336 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp6_, " WHEN 1 THEN 'true' WHEN 0 THEN 'false' ELSE NULL END");
#line 337 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3226 "tracker-sparql-expression.c"
		}
#line 321 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_DATE:
#line 3230 "tracker-sparql-expression.c"
		{
			GString* _tmp7_;
			glong _tmp8_;
			GString* _tmp9_;
#line 340 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = sql;
#line 340 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = begin;
#line 340 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp7_, (gssize) _tmp8_, "strftime (\"%Y-%m-%d\", ");
#line 341 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = sql;
#line 341 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp9_, ", \"unixepoch\")");
#line 342 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3247 "tracker-sparql-expression.c"
		}
#line 321 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_PROPERTY_TYPE_DATETIME:
#line 3251 "tracker-sparql-expression.c"
		{
			GString* _tmp10_;
			glong _tmp11_;
			GString* _tmp12_;
#line 345 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = sql;
#line 345 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = begin;
#line 345 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp10_, (gssize) _tmp11_, "SparqlFormatTime (");
#line 346 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = sql;
#line 346 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp12_, ")");
#line 347 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3268 "tracker-sparql-expression.c"
		}
		default:
		{
			GString* _tmp13_;
			glong _tmp14_;
			GString* _tmp15_;
#line 350 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = sql;
#line 350 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = begin;
#line 350 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp13_, (gssize) _tmp14_, "CAST (");
#line 351 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = sql;
#line 351 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp15_, " AS TEXT)");
#line 352 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3287 "tracker-sparql-expression.c"
		}
	}
}


static void tracker_sparql_expression_translate_expression_as_string (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerSparqlTokenType _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 356 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 356 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 357 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_current (self);
#line 357 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (_tmp0_) {
#line 357 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
#line 357 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
#line 357 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
#line 3310 "tracker-sparql-expression.c"
		{
			TrackerSparqlLiteralBinding* _tmp1_;
			TrackerSparqlLiteralBinding* binding;
			gboolean is_var = FALSE;
			TrackerSparqlPattern* _tmp2_;
			TrackerSparqlPattern* _tmp3_;
			gboolean _tmp4_ = FALSE;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			TrackerSparqlLiteralBinding* _tmp7_;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_;
#line 362 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp1_ = tracker_sparql_literal_binding_new ();
#line 362 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			binding = _tmp1_;
#line 364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp2_ = tracker_sparql_expression_get_pattern (self);
#line 364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = _tmp2_;
#line 364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = tracker_sparql_pattern_parse_var_or_term (_tmp3_, NULL, &_tmp4_, &_inner_error_);
#line 364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			is_var = _tmp4_;
#line 364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = _tmp5_;
#line 364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (binding);
#line 364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 3347 "tracker-sparql-expression.c"
				} else {
#line 364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (binding);
#line 364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 3357 "tracker-sparql-expression.c"
				}
			}
#line 364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = binding;
#line 364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp7_->literal);
#line 364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_->literal = _tmp6_;
#line 365 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 365 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = _tmp8_;
#line 365 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 365 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 365 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 365 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (binding);
#line 365 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 3380 "tracker-sparql-expression.c"
				} else {
#line 365 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_object_unref0 (binding);
#line 365 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 365 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 365 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 3390 "tracker-sparql-expression.c"
				}
			}
#line 365 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp9_) {
#line 3395 "tracker-sparql-expression.c"
				GString* _tmp10_;
				gssize _tmp11_;
				glong begin;
				GString* _tmp12_;
				TrackerSparqlLiteralBinding* _tmp13_;
				const gchar* _tmp14_;
				TrackerPropertyType _tmp15_ = 0;
				TrackerPropertyType type;
				GString* _tmp16_;
				TrackerPropertyType _tmp17_;
				glong _tmp18_;
#line 367 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp10_ = sql;
#line 367 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp11_ = _tmp10_->len;
#line 367 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				begin = (glong) _tmp11_;
#line 368 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp12_ = sql;
#line 368 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp13_ = binding;
#line 368 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp14_ = _tmp13_->literal;
#line 368 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp15_ = tracker_sparql_expression_translate_function (self, _tmp12_, _tmp14_, &_inner_error_);
#line 368 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				type = _tmp15_;
#line 368 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 368 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 368 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 368 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 368 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 3433 "tracker-sparql-expression.c"
					} else {
#line 368 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 368 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 368 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 368 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 3443 "tracker-sparql-expression.c"
					}
				}
#line 369 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 369 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 369 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 369 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 369 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 369 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 3458 "tracker-sparql-expression.c"
					} else {
#line 369 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 369 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 369 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 369 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return;
#line 3468 "tracker-sparql-expression.c"
					}
				}
#line 370 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp16_ = sql;
#line 370 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp17_ = type;
#line 370 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp18_ = begin;
#line 370 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_convert_expression_to_string (_tmp16_, _tmp17_, _tmp18_);
#line 3479 "tracker-sparql-expression.c"
			} else {
				GString* _tmp19_;
				TrackerSparqlQuery* _tmp20_;
				TrackerSparqlLiteralBinding* _tmp21_;
				TrackerSparqlLiteralBinding* _tmp22_;
#line 372 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp19_ = sql;
#line 372 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp19_, "?");
#line 373 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_ = self->priv->query;
#line 373 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp21_ = binding;
#line 373 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp22_ = _g_object_ref0 (_tmp21_);
#line 373 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_->bindings = g_list_append (_tmp20_->bindings, _tmp22_);
#line 3497 "tracker-sparql-expression.c"
			}
#line 375 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (binding);
#line 375 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3503 "tracker-sparql-expression.c"
		}
		default:
		{
			GString* _tmp23_;
			gssize _tmp24_;
			glong begin;
			GString* _tmp25_;
			TrackerPropertyType _tmp26_ = 0;
			TrackerPropertyType type;
			GString* _tmp27_;
			TrackerPropertyType _tmp28_;
			glong _tmp29_;
#line 377 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp23_ = sql;
#line 377 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = _tmp23_->len;
#line 377 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			begin = (glong) _tmp24_;
#line 378 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp25_ = sql;
#line 378 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp26_ = tracker_sparql_expression_translate_expression (self, _tmp25_, &_inner_error_);
#line 378 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp26_;
#line 378 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 378 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 378 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 378 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 3536 "tracker-sparql-expression.c"
				} else {
#line 378 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 378 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 378 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return;
#line 3544 "tracker-sparql-expression.c"
				}
			}
#line 379 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp27_ = sql;
#line 379 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp28_ = type;
#line 379 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp29_ = begin;
#line 379 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_convert_expression_to_string (_tmp27_, _tmp28_, _tmp29_);
#line 380 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 3557 "tracker-sparql-expression.c"
		}
	}
}


static void tracker_sparql_expression_translate_str (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GString* _tmp0_;
	GError * _inner_error_ = NULL;
#line 384 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 384 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 385 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_STR, &_inner_error_);
#line 385 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 385 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 385 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 385 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3580 "tracker-sparql-expression.c"
		} else {
#line 385 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 385 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 385 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3588 "tracker-sparql-expression.c"
		}
	}
#line 386 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 386 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 386 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 386 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 386 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3601 "tracker-sparql-expression.c"
		} else {
#line 386 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 386 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 386 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3609 "tracker-sparql-expression.c"
		}
	}
#line 388 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 388 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_translate_expression_as_string (self, _tmp0_, &_inner_error_);
#line 388 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 388 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 388 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 388 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3624 "tracker-sparql-expression.c"
		} else {
#line 388 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 388 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 388 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3632 "tracker-sparql-expression.c"
		}
	}
#line 390 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 390 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 390 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 390 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 390 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3645 "tracker-sparql-expression.c"
		} else {
#line 390 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 390 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 390 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3653 "tracker-sparql-expression.c"
		}
	}
}


static void tracker_sparql_expression_translate_isuri (TrackerSparqlExpression* self, GString* sql, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GString* _tmp2_;
	TrackerSparqlLiteralBinding* _tmp3_;
	TrackerSparqlLiteralBinding* new_binding;
	TrackerSparqlLiteralBinding* _tmp4_;
	TrackerSparqlTokenType _tmp5_ = 0;
	TrackerSparqlQuery* _tmp17_;
	TrackerSparqlLiteralBinding* _tmp18_;
	TrackerSparqlLiteralBinding* _tmp19_;
	GError * _inner_error_ = NULL;
#line 393 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 393 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 394 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ISURI, &_inner_error_);
#line 394 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 394 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 394 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 394 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 394 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3687 "tracker-sparql-expression.c"
		} else {
#line 394 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 394 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 394 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3695 "tracker-sparql-expression.c"
		}
	}
#line 394 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (!_tmp1_) {
#line 395 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_ISIRI, &_inner_error_);
#line 395 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 395 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 395 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 395 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3710 "tracker-sparql-expression.c"
			} else {
#line 395 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 395 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 395 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3718 "tracker-sparql-expression.c"
			}
		}
	}
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3732 "tracker-sparql-expression.c"
		} else {
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3740 "tracker-sparql-expression.c"
		}
	}
#line 400 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 400 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, "?");
#line 401 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_literal_binding_new ();
#line 401 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	new_binding = _tmp3_;
#line 402 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = new_binding;
#line 402 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	((TrackerSparqlDataBinding*) _tmp4_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 404 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = tracker_sparql_expression_current (self);
#line 404 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp5_ == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
#line 3759 "tracker-sparql-expression.c"
		TrackerSparqlLiteralBinding* _tmp6_;
		gchar* _tmp7_;
#line 405 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = new_binding;
#line 405 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = g_strdup ("1");
#line 405 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp6_->literal);
#line 405 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_->literal = _tmp7_;
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_next (self, &_inner_error_);
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (new_binding);
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3782 "tracker-sparql-expression.c"
			} else {
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (new_binding);
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3792 "tracker-sparql-expression.c"
			}
		}
	} else {
		GString* _tmp8_;
		GString* _tmp9_;
		TrackerPropertyType _tmp10_ = 0;
		TrackerPropertyType _tmp11_;
		TrackerPropertyType _tmp12_;
#line 407 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = g_string_new ("");
#line 407 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = _tmp8_;
#line 407 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = tracker_sparql_expression_translate_expression (self, _tmp9_, &_inner_error_);
#line 407 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = _tmp10_;
#line 407 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_string_free0 (_tmp9_);
#line 407 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = _tmp11_;
#line 407 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 407 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 407 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 407 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (new_binding);
#line 407 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3823 "tracker-sparql-expression.c"
			} else {
#line 407 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (new_binding);
#line 407 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 407 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 407 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 3833 "tracker-sparql-expression.c"
			}
		}
#line 407 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp12_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 3838 "tracker-sparql-expression.c"
			TrackerSparqlLiteralBinding* _tmp13_;
			gchar* _tmp14_;
#line 408 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = new_binding;
#line 408 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = g_strdup ("1");
#line 408 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp13_->literal);
#line 408 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_->literal = _tmp14_;
#line 3849 "tracker-sparql-expression.c"
		} else {
			TrackerSparqlLiteralBinding* _tmp15_;
			gchar* _tmp16_;
#line 410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = new_binding;
#line 410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = g_strdup ("0");
#line 410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp15_->literal);
#line 410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_->literal = _tmp16_;
#line 3861 "tracker-sparql-expression.c"
		}
	}
#line 413 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp17_ = self->priv->query;
#line 413 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp18_ = new_binding;
#line 413 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp19_ = _g_object_ref0 (_tmp18_);
#line 413 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp17_->bindings = g_list_append (_tmp17_->bindings, _tmp19_);
#line 415 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 415 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 415 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 415 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 415 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (new_binding);
#line 415 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3884 "tracker-sparql-expression.c"
		} else {
#line 415 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (new_binding);
#line 415 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 415 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 415 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3894 "tracker-sparql-expression.c"
		}
	}
#line 393 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_object_unref0 (new_binding);
#line 3899 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_translate_datatype (TrackerSparqlExpression* self, GString* sql, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 418 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (self != NULL);
#line 418 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_if_fail (sql != NULL);
#line 419 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DATATYPE, &_inner_error_);
#line 419 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 419 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 419 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 419 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3921 "tracker-sparql-expression.c"
		} else {
#line 419 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 419 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 419 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3929 "tracker-sparql-expression.c"
		}
	}
#line 420 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 420 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 420 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 420 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 420 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3942 "tracker-sparql-expression.c"
		} else {
#line 420 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 420 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 420 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3950 "tracker-sparql-expression.c"
		}
	}
#line 422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3965 "tracker-sparql-expression.c"
		} else {
#line 422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 3973 "tracker-sparql-expression.c"
		}
	}
#line 422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 3978 "tracker-sparql-expression.c"
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* variable_name;
		TrackerSparqlContext* _tmp6_;
		TrackerSparqlContext* _tmp7_;
		const gchar* _tmp8_;
		TrackerSparqlVariable* _tmp9_ = NULL;
		TrackerSparqlVariable* _tmp10_;
		TrackerSparqlVariable* variable;
		TrackerSparqlVariable* _tmp11_;
		TrackerSparqlVariableBinding* _tmp12_;
		gboolean _tmp20_ = FALSE;
		TrackerSparqlVariable* _tmp21_;
		TrackerSparqlVariableBinding* _tmp22_;
		TrackerPropertyType _tmp23_;
		gboolean _tmp27_;
		GString* _tmp29_;
		TrackerSparqlLiteralBinding* _tmp30_;
		TrackerSparqlLiteralBinding* new_binding;
		TrackerSparqlLiteralBinding* _tmp31_;
		TrackerSparqlVariable* _tmp32_;
		TrackerSparqlVariableBinding* _tmp33_;
		TrackerClass* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		TrackerSparqlQuery* _tmp38_;
		TrackerSparqlLiteralBinding* _tmp39_;
		TrackerSparqlLiteralBinding* _tmp40_;
#line 423 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = tracker_sparql_expression_get_last_string (self, 0);
#line 423 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = _tmp2_;
#line 423 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = string_substring (_tmp3_, (glong) 1, (glong) (-1));
#line 423 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 423 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp3_);
#line 423 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		variable_name = _tmp5_;
#line 424 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = tracker_sparql_expression_get_context (self);
#line 424 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = _tmp6_;
#line 424 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = variable_name;
#line 424 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = tracker_sparql_context_get_variable (_tmp7_, _tmp8_);
#line 424 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 424 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		variable = _tmp10_;
#line 426 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = variable;
#line 426 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = _tmp11_->binding;
#line 426 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp12_ == NULL) {
#line 4040 "tracker-sparql-expression.c"
			TrackerSparqlVariable* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			GError* _tmp18_ = NULL;
			GError* _tmp19_;
#line 427 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = variable;
#line 427 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = tracker_sparql_variable_get_name (_tmp13_);
#line 427 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = _tmp14_;
#line 427 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = g_strdup_printf ("`%s' is not a valid variable", _tmp15_);
#line 427 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = _tmp16_;
#line 427 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = tracker_sparql_expression_get_error (self, _tmp17_);
#line 427 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = _tmp18_;
#line 427 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp17_);
#line 427 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp19_;
#line 427 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 427 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 427 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 427 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 427 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 4076 "tracker-sparql-expression.c"
			} else {
#line 427 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 427 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 427 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 427 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 427 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 4088 "tracker-sparql-expression.c"
			}
		}
#line 430 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp21_ = variable;
#line 430 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp22_ = _tmp21_->binding;
#line 430 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp23_ = ((TrackerSparqlDataBinding*) _tmp22_)->data_type;
#line 430 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp23_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 430 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = TRUE;
#line 4101 "tracker-sparql-expression.c"
		} else {
			TrackerSparqlVariable* _tmp24_;
			TrackerSparqlVariableBinding* _tmp25_;
			TrackerClass* _tmp26_;
#line 430 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = variable;
#line 430 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp25_ = _tmp24_->binding;
#line 430 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp26_ = _tmp25_->type;
#line 430 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = _tmp26_ == NULL;
#line 4114 "tracker-sparql-expression.c"
		}
#line 430 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp27_ = _tmp20_;
#line 430 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp27_) {
#line 4120 "tracker-sparql-expression.c"
			GError* _tmp28_ = NULL;
#line 431 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp28_ = tracker_sparql_expression_get_error (self, "Invalid FILTER");
#line 431 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp28_;
#line 431 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 431 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 431 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 431 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 431 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 4136 "tracker-sparql-expression.c"
			} else {
#line 431 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 431 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 431 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 431 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 431 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return;
#line 4148 "tracker-sparql-expression.c"
			}
		}
#line 434 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp29_ = sql;
#line 434 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp29_, "(SELECT ID FROM Resource WHERE Uri = ?)");
#line 436 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp30_ = tracker_sparql_literal_binding_new ();
#line 436 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		new_binding = _tmp30_;
#line 437 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp31_ = new_binding;
#line 437 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp32_ = variable;
#line 437 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp33_ = _tmp32_->binding;
#line 437 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp34_ = _tmp33_->type;
#line 437 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp35_ = tracker_class_get_uri (_tmp34_);
#line 437 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp36_ = _tmp35_;
#line 437 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp37_ = g_strdup (_tmp36_);
#line 437 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp31_->literal);
#line 437 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp31_->literal = _tmp37_;
#line 438 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp38_ = self->priv->query;
#line 438 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp39_ = new_binding;
#line 438 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp40_ = _g_object_ref0 (_tmp39_);
#line 438 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp38_->bindings = g_list_append (_tmp38_->bindings, _tmp40_);
#line 422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_object_unref0 (new_binding);
#line 422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_object_unref0 (variable);
#line 422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (variable_name);
#line 4191 "tracker-sparql-expression.c"
	} else {
		GError* _tmp41_ = NULL;
#line 441 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp41_ = tracker_sparql_expression_get_error (self, "Invalid FILTER");
#line 441 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_inner_error_ = _tmp41_;
#line 441 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 441 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 441 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 4204 "tracker-sparql-expression.c"
		} else {
#line 441 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 441 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 441 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 4212 "tracker-sparql-expression.c"
		}
	}
#line 444 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 444 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 444 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 444 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 444 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 4225 "tracker-sparql-expression.c"
		} else {
#line 444 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 444 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 444 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return;
#line 4233 "tracker-sparql-expression.c"
		}
	}
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	const gchar* _tmp1_;
#line 845 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 7);
#line 845 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	str = (gchar*) _tmp0_;
#line 846 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = str;
#line 846 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	g_unichar_to_utf8 (self, _tmp1_);
#line 847 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	result = str;
#line 847 "/opt/gnome/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 4256 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_function (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error) {
	TrackerPropertyType result = 0;
	const gchar* _tmp0_;
	GError * _inner_error_ = NULL;
#line 447 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 447 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 447 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (uri != NULL, 0);
#line 448 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = uri;
#line 448 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (g_strcmp0 (_tmp0_, TRACKER_SPARQL_EXPRESSION_XSD_NS "string") == 0) {
#line 4274 "tracker-sparql-expression.c"
		GString* _tmp1_;
#line 450 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp1_ = sql;
#line 450 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_translate_expression_as_string (self, _tmp1_, &_inner_error_);
#line 450 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 450 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 450 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 450 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 4288 "tracker-sparql-expression.c"
			} else {
#line 450 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 450 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 450 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 4296 "tracker-sparql-expression.c"
			}
		}
#line 452 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = TRACKER_PROPERTY_TYPE_STRING;
#line 452 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 4303 "tracker-sparql-expression.c"
	} else {
		const gchar* _tmp2_;
#line 453 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = uri;
#line 453 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (g_strcmp0 (_tmp2_, TRACKER_SPARQL_EXPRESSION_XSD_NS "integer") == 0) {
#line 4310 "tracker-sparql-expression.c"
			GString* _tmp3_;
			GString* _tmp4_;
			GString* _tmp5_;
#line 455 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = sql;
#line 455 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp3_, "CAST (");
#line 456 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp4_ = sql;
#line 456 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_string (self, _tmp4_, &_inner_error_);
#line 456 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 456 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 456 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 456 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 4330 "tracker-sparql-expression.c"
				} else {
#line 456 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 456 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 456 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 4338 "tracker-sparql-expression.c"
				}
			}
#line 457 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = sql;
#line 457 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp5_, " AS INTEGER)");
#line 459 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 459 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 4349 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp6_;
#line 460 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = uri;
#line 460 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (g_strcmp0 (_tmp6_, TRACKER_SPARQL_EXPRESSION_XSD_NS "double") == 0) {
#line 4356 "tracker-sparql-expression.c"
				GString* _tmp7_;
				GString* _tmp8_;
				GString* _tmp9_;
#line 462 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp7_ = sql;
#line 462 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp7_, "CAST (");
#line 463 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp8_ = sql;
#line 463 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_expression_translate_expression_as_string (self, _tmp8_, &_inner_error_);
#line 463 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 463 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 463 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 463 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 4376 "tracker-sparql-expression.c"
					} else {
#line 463 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 463 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 463 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 4384 "tracker-sparql-expression.c"
					}
				}
#line 464 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp9_ = sql;
#line 464 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp9_, " AS REAL)");
#line 466 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 466 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return result;
#line 4395 "tracker-sparql-expression.c"
			} else {
				const gchar* _tmp10_;
#line 467 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp10_ = uri;
#line 467 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (g_strcmp0 (_tmp10_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "case-fold") == 0) {
#line 4402 "tracker-sparql-expression.c"
					GString* _tmp11_;
					GString* _tmp12_;
					GString* _tmp13_;
#line 469 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp11_ = sql;
#line 469 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_string_append (_tmp11_, "SparqlCaseFold (");
#line 470 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp12_ = sql;
#line 470 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					tracker_sparql_expression_translate_expression_as_string (self, _tmp12_, &_inner_error_);
#line 470 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_ != NULL) {
#line 470 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 470 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_propagate_error (error, _inner_error_);
#line 470 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 4422 "tracker-sparql-expression.c"
						} else {
#line 470 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 470 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_clear_error (&_inner_error_);
#line 470 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 4430 "tracker-sparql-expression.c"
						}
					}
#line 471 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp13_ = sql;
#line 471 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_string_append (_tmp13_, ")");
#line 472 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					result = TRACKER_PROPERTY_TYPE_STRING;
#line 472 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return result;
#line 4441 "tracker-sparql-expression.c"
				} else {
					const gchar* _tmp14_;
#line 473 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp14_ = uri;
#line 473 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (g_strcmp0 (_tmp14_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "ascii-lower-case") == 0) {
#line 4448 "tracker-sparql-expression.c"
						GString* _tmp15_;
						GString* _tmp16_;
						GString* _tmp17_;
#line 475 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp15_ = sql;
#line 475 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp15_, "lower (");
#line 476 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp16_ = sql;
#line 476 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						tracker_sparql_expression_translate_expression_as_string (self, _tmp16_, &_inner_error_);
#line 476 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_ != NULL) {
#line 476 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 476 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_propagate_error (error, _inner_error_);
#line 476 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 4468 "tracker-sparql-expression.c"
							} else {
#line 476 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 476 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_clear_error (&_inner_error_);
#line 476 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 4476 "tracker-sparql-expression.c"
							}
						}
#line 477 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp17_ = sql;
#line 477 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp17_, ")");
#line 478 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						result = TRACKER_PROPERTY_TYPE_STRING;
#line 478 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return result;
#line 4487 "tracker-sparql-expression.c"
					} else {
						const gchar* _tmp18_;
#line 479 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp18_ = uri;
#line 479 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (g_strcmp0 (_tmp18_, TRACKER_SPARQL_EXPRESSION_FN_NS "lower-case") == 0) {
#line 4494 "tracker-sparql-expression.c"
							GString* _tmp19_;
							GString* _tmp20_;
							GString* _tmp21_;
#line 481 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp19_ = sql;
#line 481 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append (_tmp19_, "SparqlLowerCase (");
#line 482 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp20_ = sql;
#line 482 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							tracker_sparql_expression_translate_expression_as_string (self, _tmp20_, &_inner_error_);
#line 482 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_ != NULL) {
#line 482 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 482 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_propagate_error (error, _inner_error_);
#line 482 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 4514 "tracker-sparql-expression.c"
								} else {
#line 482 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 482 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_clear_error (&_inner_error_);
#line 482 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 4522 "tracker-sparql-expression.c"
								}
							}
#line 483 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp21_ = sql;
#line 483 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append (_tmp21_, ")");
#line 484 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							result = TRACKER_PROPERTY_TYPE_STRING;
#line 484 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return result;
#line 4533 "tracker-sparql-expression.c"
						} else {
							const gchar* _tmp22_;
#line 485 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp22_ = uri;
#line 485 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (g_strcmp0 (_tmp22_, TRACKER_SPARQL_EXPRESSION_FN_NS "contains") == 0) {
#line 4540 "tracker-sparql-expression.c"
								GString* _tmp23_;
								GString* _tmp24_;
								GString* _tmp25_;
								GString* _tmp26_;
								TrackerSparqlLiteralBinding* _tmp27_;
								TrackerSparqlLiteralBinding* binding;
								gchar* _tmp28_ = NULL;
								gchar* _tmp29_;
								TrackerSparqlLiteralBinding* _tmp30_;
								gchar* _tmp31_;
								gchar* _tmp32_ = NULL;
								TrackerSparqlQuery* _tmp33_;
								TrackerSparqlLiteralBinding* _tmp34_;
								TrackerSparqlLiteralBinding* _tmp35_;
								GString* _tmp36_;
#line 487 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp23_ = sql;
#line 487 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_string_append (_tmp23_, "(");
#line 488 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp24_ = sql;
#line 488 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								tracker_sparql_expression_translate_expression_as_string (self, _tmp24_, &_inner_error_);
#line 488 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_ != NULL) {
#line 488 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 488 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_propagate_error (error, _inner_error_);
#line 488 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4572 "tracker-sparql-expression.c"
									} else {
#line 488 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 488 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_clear_error (&_inner_error_);
#line 488 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4580 "tracker-sparql-expression.c"
									}
								}
#line 489 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp25_ = sql;
#line 489 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_string_append (_tmp25_, " GLOB ");
#line 490 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 490 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_ != NULL) {
#line 490 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 490 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_propagate_error (error, _inner_error_);
#line 490 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4597 "tracker-sparql-expression.c"
									} else {
#line 490 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 490 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_clear_error (&_inner_error_);
#line 490 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4605 "tracker-sparql-expression.c"
									}
								}
#line 492 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp26_ = sql;
#line 492 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_string_append (_tmp26_, "?");
#line 493 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp27_ = tracker_sparql_literal_binding_new ();
#line 493 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								binding = _tmp27_;
#line 494 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp28_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 494 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp29_ = _tmp28_;
#line 494 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_ != NULL) {
#line 494 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 494 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_propagate_error (error, _inner_error_);
#line 494 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_g_object_unref0 (binding);
#line 494 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4630 "tracker-sparql-expression.c"
									} else {
#line 494 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_g_object_unref0 (binding);
#line 494 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 494 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_clear_error (&_inner_error_);
#line 494 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 4640 "tracker-sparql-expression.c"
									}
								}
#line 494 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp30_ = binding;
#line 494 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp31_ = _tmp29_;
#line 494 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp32_ = g_strdup_printf ("*%s*", _tmp31_);
#line 494 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_g_free0 (_tmp30_->literal);
#line 494 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp30_->literal = _tmp32_;
#line 494 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_g_free0 (_tmp31_);
#line 495 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp33_ = self->priv->query;
#line 495 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp34_ = binding;
#line 495 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp35_ = _g_object_ref0 (_tmp34_);
#line 495 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp33_->bindings = g_list_append (_tmp33_->bindings, _tmp35_);
#line 497 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp36_ = sql;
#line 497 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_string_append (_tmp36_, ")");
#line 499 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 499 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_g_object_unref0 (binding);
#line 499 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return result;
#line 4673 "tracker-sparql-expression.c"
							} else {
								const gchar* _tmp37_;
#line 500 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp37_ = uri;
#line 500 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (g_strcmp0 (_tmp37_, TRACKER_SPARQL_EXPRESSION_FN_NS "starts-with") == 0) {
#line 4680 "tracker-sparql-expression.c"
									GString* _tmp38_;
									GString* _tmp39_;
									gchar* _tmp40_ = NULL;
									gchar* prefix;
									GString* _tmp41_;
									TrackerSparqlLiteralBinding* _tmp42_;
									TrackerSparqlLiteralBinding* binding;
									TrackerSparqlLiteralBinding* _tmp43_;
									const gchar* _tmp44_;
									gchar* _tmp45_;
									TrackerSparqlQuery* _tmp46_;
									TrackerSparqlLiteralBinding* _tmp47_;
									TrackerSparqlLiteralBinding* _tmp48_;
									GString* _tmp49_;
									GString* _tmp50_;
									TrackerSparqlLiteralBinding* _tmp51_;
									TrackerSparqlLiteralBinding* _tmp52_;
									const gchar* _tmp53_;
									gchar* _tmp54_ = NULL;
									gchar* _tmp55_;
									gchar* _tmp56_;
									TrackerSparqlQuery* _tmp57_;
									TrackerSparqlLiteralBinding* _tmp58_;
									TrackerSparqlLiteralBinding* _tmp59_;
#line 504 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp38_ = sql;
#line 504 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									tracker_sparql_expression_translate_expression_as_string (self, _tmp38_, &_inner_error_);
#line 504 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_ != NULL) {
#line 504 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 504 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_propagate_error (error, _inner_error_);
#line 504 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 4717 "tracker-sparql-expression.c"
										} else {
#line 504 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 504 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_clear_error (&_inner_error_);
#line 504 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 4725 "tracker-sparql-expression.c"
										}
									}
#line 505 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp39_ = sql;
#line 505 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_string_append (_tmp39_, " BETWEEN ");
#line 507 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 507 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_ != NULL) {
#line 507 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 507 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_propagate_error (error, _inner_error_);
#line 507 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 4742 "tracker-sparql-expression.c"
										} else {
#line 507 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 507 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_clear_error (&_inner_error_);
#line 507 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 4750 "tracker-sparql-expression.c"
										}
									}
#line 508 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp40_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 508 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									prefix = _tmp40_;
#line 508 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_ != NULL) {
#line 508 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 508 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_propagate_error (error, _inner_error_);
#line 508 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 4765 "tracker-sparql-expression.c"
										} else {
#line 508 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 508 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_clear_error (&_inner_error_);
#line 508 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 4773 "tracker-sparql-expression.c"
										}
									}
#line 510 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp41_ = sql;
#line 510 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_string_append (_tmp41_, "?");
#line 511 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp42_ = tracker_sparql_literal_binding_new ();
#line 511 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									binding = _tmp42_;
#line 512 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp43_ = binding;
#line 512 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp44_ = prefix;
#line 512 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp45_ = g_strdup (_tmp44_);
#line 512 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_g_free0 (_tmp43_->literal);
#line 512 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp43_->literal = _tmp45_;
#line 513 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp46_ = self->priv->query;
#line 513 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp47_ = binding;
#line 513 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp48_ = _g_object_ref0 (_tmp47_);
#line 513 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp46_->bindings = g_list_append (_tmp46_->bindings, _tmp48_);
#line 515 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp49_ = sql;
#line 515 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_string_append (_tmp49_, " AND ");
#line 517 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp50_ = sql;
#line 517 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_string_append (_tmp50_, "?");
#line 518 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp51_ = tracker_sparql_literal_binding_new ();
#line 518 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_g_object_unref0 (binding);
#line 518 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									binding = _tmp51_;
#line 519 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp52_ = binding;
#line 519 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp53_ = prefix;
#line 519 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp54_ = g_unichar_to_string (TRACKER_COLLATION_LAST_CHAR);
#line 519 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp55_ = _tmp54_;
#line 519 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp56_ = g_strconcat (_tmp53_, _tmp55_, NULL);
#line 519 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_g_free0 (_tmp52_->literal);
#line 519 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp52_->literal = _tmp56_;
#line 519 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_g_free0 (_tmp55_);
#line 520 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp57_ = self->priv->query;
#line 520 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp58_ = binding;
#line 520 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp59_ = _g_object_ref0 (_tmp58_);
#line 520 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp57_->bindings = g_list_append (_tmp57_->bindings, _tmp59_);
#line 522 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 522 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_g_object_unref0 (binding);
#line 522 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_g_free0 (prefix);
#line 522 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return result;
#line 4848 "tracker-sparql-expression.c"
								} else {
									const gchar* _tmp60_;
#line 523 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp60_ = uri;
#line 523 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (g_strcmp0 (_tmp60_, TRACKER_SPARQL_EXPRESSION_FN_NS "ends-with") == 0) {
#line 4855 "tracker-sparql-expression.c"
										GString* _tmp61_;
										GString* _tmp62_;
										GString* _tmp63_;
										GString* _tmp64_;
										TrackerSparqlLiteralBinding* _tmp65_;
										TrackerSparqlLiteralBinding* binding;
										gchar* _tmp66_ = NULL;
										gchar* _tmp67_;
										TrackerSparqlLiteralBinding* _tmp68_;
										gchar* _tmp69_;
										gchar* _tmp70_ = NULL;
										TrackerSparqlQuery* _tmp71_;
										TrackerSparqlLiteralBinding* _tmp72_;
										TrackerSparqlLiteralBinding* _tmp73_;
										GString* _tmp74_;
#line 525 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp61_ = sql;
#line 525 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_string_append (_tmp61_, "(");
#line 526 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp62_ = sql;
#line 526 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										tracker_sparql_expression_translate_expression_as_string (self, _tmp62_, &_inner_error_);
#line 526 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_ != NULL) {
#line 526 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 526 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_propagate_error (error, _inner_error_);
#line 526 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4887 "tracker-sparql-expression.c"
											} else {
#line 526 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 526 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_clear_error (&_inner_error_);
#line 526 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4895 "tracker-sparql-expression.c"
											}
										}
#line 527 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp63_ = sql;
#line 527 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_string_append (_tmp63_, " GLOB ");
#line 528 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 528 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_ != NULL) {
#line 528 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 528 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_propagate_error (error, _inner_error_);
#line 528 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4912 "tracker-sparql-expression.c"
											} else {
#line 528 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 528 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_clear_error (&_inner_error_);
#line 528 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4920 "tracker-sparql-expression.c"
											}
										}
#line 530 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp64_ = sql;
#line 530 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_string_append (_tmp64_, "?");
#line 531 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp65_ = tracker_sparql_literal_binding_new ();
#line 531 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										binding = _tmp65_;
#line 532 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp66_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 532 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp67_ = _tmp66_;
#line 532 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_ != NULL) {
#line 532 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 532 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_propagate_error (error, _inner_error_);
#line 532 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_g_object_unref0 (binding);
#line 532 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4945 "tracker-sparql-expression.c"
											} else {
#line 532 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_g_object_unref0 (binding);
#line 532 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 532 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_clear_error (&_inner_error_);
#line 532 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return 0;
#line 4955 "tracker-sparql-expression.c"
											}
										}
#line 532 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp68_ = binding;
#line 532 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp69_ = _tmp67_;
#line 532 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp70_ = g_strdup_printf ("*%s", _tmp69_);
#line 532 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_g_free0 (_tmp68_->literal);
#line 532 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp68_->literal = _tmp70_;
#line 532 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_g_free0 (_tmp69_);
#line 533 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp71_ = self->priv->query;
#line 533 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp72_ = binding;
#line 533 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp73_ = _g_object_ref0 (_tmp72_);
#line 533 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp71_->bindings = g_list_append (_tmp71_->bindings, _tmp73_);
#line 535 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp74_ = sql;
#line 535 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_string_append (_tmp74_, ")");
#line 537 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 537 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_g_object_unref0 (binding);
#line 537 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return result;
#line 4988 "tracker-sparql-expression.c"
									} else {
										const gchar* _tmp75_;
#line 538 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										_tmp75_ = uri;
#line 538 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (g_strcmp0 (_tmp75_, TRACKER_SPARQL_EXPRESSION_FN_NS "substring") == 0) {
#line 4995 "tracker-sparql-expression.c"
											GString* _tmp76_;
											GString* _tmp77_;
											GString* _tmp78_;
											GString* _tmp79_;
											gboolean _tmp80_ = FALSE;
											gboolean _tmp81_;
											GString* _tmp84_;
#line 539 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp76_ = sql;
#line 539 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_string_append (_tmp76_, "substr(");
#line 540 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp77_ = sql;
#line 540 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											tracker_sparql_expression_translate_expression_as_string (self, _tmp77_, &_inner_error_);
#line 540 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_ != NULL) {
#line 540 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 540 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_propagate_error (error, _inner_error_);
#line 540 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 5019 "tracker-sparql-expression.c"
												} else {
#line 540 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 540 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_clear_error (&_inner_error_);
#line 540 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 5027 "tracker-sparql-expression.c"
												}
											}
#line 542 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp78_ = sql;
#line 542 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_string_append (_tmp78_, ", ");
#line 543 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 543 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_ != NULL) {
#line 543 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 543 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_propagate_error (error, _inner_error_);
#line 543 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 5044 "tracker-sparql-expression.c"
												} else {
#line 543 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 543 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_clear_error (&_inner_error_);
#line 543 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 5052 "tracker-sparql-expression.c"
												}
											}
#line 544 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp79_ = sql;
#line 544 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											tracker_sparql_expression_translate_expression_as_string (self, _tmp79_, &_inner_error_);
#line 544 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_ != NULL) {
#line 544 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 544 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_propagate_error (error, _inner_error_);
#line 544 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 5067 "tracker-sparql-expression.c"
												} else {
#line 544 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 544 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_clear_error (&_inner_error_);
#line 544 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 5075 "tracker-sparql-expression.c"
												}
											}
#line 546 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp80_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 546 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp81_ = _tmp80_;
#line 546 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_inner_error_ != NULL) {
#line 546 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 546 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_propagate_error (error, _inner_error_);
#line 546 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 5090 "tracker-sparql-expression.c"
												} else {
#line 546 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 546 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_clear_error (&_inner_error_);
#line 546 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return 0;
#line 5098 "tracker-sparql-expression.c"
												}
											}
#line 546 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (_tmp81_) {
#line 5103 "tracker-sparql-expression.c"
												GString* _tmp82_;
												GString* _tmp83_;
#line 547 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp82_ = sql;
#line 547 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_string_append (_tmp82_, ", ");
#line 548 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp83_ = sql;
#line 548 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												tracker_sparql_expression_translate_expression_as_string (self, _tmp83_, &_inner_error_);
#line 548 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_ != NULL) {
#line 548 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 548 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_propagate_error (error, _inner_error_);
#line 548 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 5122 "tracker-sparql-expression.c"
													} else {
#line 548 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 548 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_clear_error (&_inner_error_);
#line 548 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 5130 "tracker-sparql-expression.c"
													}
												}
											}
#line 551 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp84_ = sql;
#line 551 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_string_append (_tmp84_, ")");
#line 553 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											result = TRACKER_PROPERTY_TYPE_STRING;
#line 553 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return result;
#line 5142 "tracker-sparql-expression.c"
										} else {
											const gchar* _tmp85_;
#line 554 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											_tmp85_ = uri;
#line 554 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											if (g_strcmp0 (_tmp85_, TRACKER_SPARQL_EXPRESSION_FN_NS "concat") == 0) {
#line 5149 "tracker-sparql-expression.c"
												GString* _tmp86_;
												GString* _tmp87_;
												GString* _tmp88_;
#line 555 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp86_ = sql;
#line 555 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												tracker_sparql_expression_translate_expression_as_string (self, _tmp86_, &_inner_error_);
#line 555 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_ != NULL) {
#line 555 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 555 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_propagate_error (error, _inner_error_);
#line 555 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 5165 "tracker-sparql-expression.c"
													} else {
#line 555 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 555 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_clear_error (&_inner_error_);
#line 555 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 5173 "tracker-sparql-expression.c"
													}
												}
#line 556 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp87_ = sql;
#line 556 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												g_string_append (_tmp87_, "||");
#line 557 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 557 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_ != NULL) {
#line 557 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 557 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_propagate_error (error, _inner_error_);
#line 557 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 5190 "tracker-sparql-expression.c"
													} else {
#line 557 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 557 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_clear_error (&_inner_error_);
#line 557 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 5198 "tracker-sparql-expression.c"
													}
												}
#line 558 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp88_ = sql;
#line 558 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												tracker_sparql_expression_translate_expression_as_string (self, _tmp88_, &_inner_error_);
#line 558 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (_inner_error_ != NULL) {
#line 558 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 558 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_propagate_error (error, _inner_error_);
#line 558 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 5213 "tracker-sparql-expression.c"
													} else {
#line 558 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 558 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_clear_error (&_inner_error_);
#line 558 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return 0;
#line 5221 "tracker-sparql-expression.c"
													}
												}
#line 559 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												while (TRUE) {
#line 5226 "tracker-sparql-expression.c"
													gboolean _tmp89_ = FALSE;
													gboolean _tmp90_;
													GString* _tmp91_;
													GString* _tmp92_;
#line 559 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp89_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 559 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp90_ = _tmp89_;
#line 559 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 559 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 559 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 559 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5243 "tracker-sparql-expression.c"
														} else {
#line 559 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 559 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 559 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5251 "tracker-sparql-expression.c"
														}
													}
#line 559 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (!_tmp90_) {
#line 559 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														break;
#line 5258 "tracker-sparql-expression.c"
													}
#line 560 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp91_ = sql;
#line 560 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_string_append (_tmp91_, "||");
#line 561 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp92_ = sql;
#line 561 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_translate_expression_as_string (self, _tmp92_, &_inner_error_);
#line 561 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 561 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 561 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 561 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5276 "tracker-sparql-expression.c"
														} else {
#line 561 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 561 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 561 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5284 "tracker-sparql-expression.c"
														}
													}
												}
#line 564 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												result = TRACKER_PROPERTY_TYPE_STRING;
#line 564 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												return result;
#line 5292 "tracker-sparql-expression.c"
											} else {
												const gchar* _tmp93_;
#line 565 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												_tmp93_ = uri;
#line 565 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
												if (g_strcmp0 (_tmp93_, TRACKER_SPARQL_EXPRESSION_FN_NS "string-join") == 0) {
#line 5299 "tracker-sparql-expression.c"
													GString* _tmp94_;
													GString* _tmp95_;
													GString* _tmp96_;
													GString* _tmp97_;
													GString* _tmp102_;
													GString* _tmp103_;
													GString* _tmp104_;
#line 566 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp94_ = sql;
#line 566 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_string_append (_tmp94_, "SparqlStringJoin(");
#line 567 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 567 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 567 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 567 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 567 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5321 "tracker-sparql-expression.c"
														} else {
#line 567 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 567 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 567 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5329 "tracker-sparql-expression.c"
														}
													}
#line 569 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp95_ = sql;
#line 569 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_translate_expression_as_string (self, _tmp95_, &_inner_error_);
#line 569 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 569 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 569 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 569 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5344 "tracker-sparql-expression.c"
														} else {
#line 569 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 569 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 569 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5352 "tracker-sparql-expression.c"
														}
													}
#line 570 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp96_ = sql;
#line 570 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_string_append (_tmp96_, ", ");
#line 571 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 571 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 571 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 571 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 571 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5369 "tracker-sparql-expression.c"
														} else {
#line 571 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 571 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 571 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5377 "tracker-sparql-expression.c"
														}
													}
#line 572 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp97_ = sql;
#line 572 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_translate_expression_as_string (self, _tmp97_, &_inner_error_);
#line 572 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 572 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 572 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 572 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5392 "tracker-sparql-expression.c"
														} else {
#line 572 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 572 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 572 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5400 "tracker-sparql-expression.c"
														}
													}
#line 573 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													while (TRUE) {
#line 5405 "tracker-sparql-expression.c"
														gboolean _tmp98_ = FALSE;
														gboolean _tmp99_;
														GString* _tmp100_;
														GString* _tmp101_;
#line 573 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp98_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 573 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp99_ = _tmp98_;
#line 573 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_ != NULL) {
#line 573 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 573 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_propagate_error (error, _inner_error_);
#line 573 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5422 "tracker-sparql-expression.c"
															} else {
#line 573 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 573 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_clear_error (&_inner_error_);
#line 573 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5430 "tracker-sparql-expression.c"
															}
														}
#line 573 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (!_tmp99_) {
#line 573 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															break;
#line 5437 "tracker-sparql-expression.c"
														}
#line 574 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp100_ = sql;
#line 574 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_string_append (_tmp100_, ", ");
#line 575 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp101_ = sql;
#line 575 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														tracker_sparql_expression_translate_expression_as_string (self, _tmp101_, &_inner_error_);
#line 575 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_ != NULL) {
#line 575 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 575 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_propagate_error (error, _inner_error_);
#line 575 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5455 "tracker-sparql-expression.c"
															} else {
#line 575 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 575 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_clear_error (&_inner_error_);
#line 575 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5463 "tracker-sparql-expression.c"
															}
														}
													}
#line 578 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 578 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 578 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 578 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 578 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5477 "tracker-sparql-expression.c"
														} else {
#line 578 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 578 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 578 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5485 "tracker-sparql-expression.c"
														}
													}
#line 579 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp102_ = sql;
#line 579 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_string_append (_tmp102_, ",");
#line 580 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 580 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 580 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 580 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 580 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5502 "tracker-sparql-expression.c"
														} else {
#line 580 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 580 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 580 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5510 "tracker-sparql-expression.c"
														}
													}
#line 581 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp103_ = sql;
#line 581 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													tracker_sparql_expression_translate_expression (self, _tmp103_, &_inner_error_);
#line 581 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (_inner_error_ != NULL) {
#line 581 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 581 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_propagate_error (error, _inner_error_);
#line 581 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5525 "tracker-sparql-expression.c"
														} else {
#line 581 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 581 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_clear_error (&_inner_error_);
#line 581 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return 0;
#line 5533 "tracker-sparql-expression.c"
														}
													}
#line 582 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp104_ = sql;
#line 582 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													g_string_append (_tmp104_, ")");
#line 584 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													result = TRACKER_PROPERTY_TYPE_STRING;
#line 584 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													return result;
#line 5544 "tracker-sparql-expression.c"
												} else {
													const gchar* _tmp105_;
#line 585 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													_tmp105_ = uri;
#line 585 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
													if (g_strcmp0 (_tmp105_, TRACKER_SPARQL_EXPRESSION_FN_NS "year-from-dateTime") == 0) {
#line 5551 "tracker-sparql-expression.c"
														gchar* _tmp106_ = NULL;
														gchar* _tmp107_;
														gchar* _tmp108_ = NULL;
														gchar* _tmp109_;
														gchar* variable_name;
														TrackerSparqlContext* _tmp110_;
														TrackerSparqlContext* _tmp111_;
														const gchar* _tmp112_;
														TrackerSparqlVariable* _tmp113_ = NULL;
														TrackerSparqlVariable* _tmp114_;
														TrackerSparqlVariable* variable;
														GString* _tmp115_;
														GString* _tmp116_;
														TrackerSparqlVariable* _tmp117_;
														gchar* _tmp118_ = NULL;
														gchar* _tmp119_;
														GString* _tmp120_;
#line 586 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 586 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (_inner_error_ != NULL) {
#line 586 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 586 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_propagate_error (error, _inner_error_);
#line 586 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5579 "tracker-sparql-expression.c"
															} else {
#line 586 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 586 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_clear_error (&_inner_error_);
#line 586 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return 0;
#line 5587 "tracker-sparql-expression.c"
															}
														}
#line 587 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp106_ = tracker_sparql_expression_get_last_string (self, 0);
#line 587 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp107_ = _tmp106_;
#line 587 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp108_ = string_substring (_tmp107_, (glong) 1, (glong) (-1));
#line 587 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp109_ = _tmp108_;
#line 587 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_g_free0 (_tmp107_);
#line 587 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														variable_name = _tmp109_;
#line 588 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp110_ = tracker_sparql_expression_get_context (self);
#line 588 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp111_ = _tmp110_;
#line 588 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp112_ = variable_name;
#line 588 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp113_ = tracker_sparql_context_get_variable (_tmp111_, _tmp112_);
#line 588 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp114_ = _g_object_ref0 (_tmp113_);
#line 588 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														variable = _tmp114_;
#line 590 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp115_ = sql;
#line 590 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_string_append (_tmp115_, "strftime (\"%Y\", ");
#line 591 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp116_ = sql;
#line 591 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp117_ = variable;
#line 591 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp118_ = tracker_sparql_variable_get_extra_sql_expression (_tmp117_, "localDate");
#line 591 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp119_ = _tmp118_;
#line 591 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_string_append (_tmp116_, _tmp119_);
#line 591 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_g_free0 (_tmp119_);
#line 592 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp120_ = sql;
#line 592 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														g_string_append (_tmp120_, " * 24 * 3600, \"unixepoch\")");
#line 594 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 594 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_g_object_unref0 (variable);
#line 594 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_g_free0 (variable_name);
#line 594 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														return result;
#line 5642 "tracker-sparql-expression.c"
													} else {
														const gchar* _tmp121_;
#line 595 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														_tmp121_ = uri;
#line 595 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
														if (g_strcmp0 (_tmp121_, TRACKER_SPARQL_EXPRESSION_FN_NS "month-from-dateTime") == 0) {
#line 5649 "tracker-sparql-expression.c"
															gchar* _tmp122_ = NULL;
															gchar* _tmp123_;
															gchar* _tmp124_ = NULL;
															gchar* _tmp125_;
															gchar* variable_name;
															TrackerSparqlContext* _tmp126_;
															TrackerSparqlContext* _tmp127_;
															const gchar* _tmp128_;
															TrackerSparqlVariable* _tmp129_ = NULL;
															TrackerSparqlVariable* _tmp130_;
															TrackerSparqlVariable* variable;
															GString* _tmp131_;
															GString* _tmp132_;
															TrackerSparqlVariable* _tmp133_;
															gchar* _tmp134_ = NULL;
															gchar* _tmp135_;
															GString* _tmp136_;
#line 596 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 596 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (_inner_error_ != NULL) {
#line 596 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 596 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_propagate_error (error, _inner_error_);
#line 596 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5677 "tracker-sparql-expression.c"
																} else {
#line 596 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 596 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_clear_error (&_inner_error_);
#line 596 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return 0;
#line 5685 "tracker-sparql-expression.c"
																}
															}
#line 597 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp122_ = tracker_sparql_expression_get_last_string (self, 0);
#line 597 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp123_ = _tmp122_;
#line 597 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp124_ = string_substring (_tmp123_, (glong) 1, (glong) (-1));
#line 597 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp125_ = _tmp124_;
#line 597 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_g_free0 (_tmp123_);
#line 597 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															variable_name = _tmp125_;
#line 598 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp126_ = tracker_sparql_expression_get_context (self);
#line 598 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp127_ = _tmp126_;
#line 598 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp128_ = variable_name;
#line 598 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp129_ = tracker_sparql_context_get_variable (_tmp127_, _tmp128_);
#line 598 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp130_ = _g_object_ref0 (_tmp129_);
#line 598 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															variable = _tmp130_;
#line 600 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp131_ = sql;
#line 600 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_string_append (_tmp131_, "strftime (\"%m\", ");
#line 601 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp132_ = sql;
#line 601 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp133_ = variable;
#line 601 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp134_ = tracker_sparql_variable_get_extra_sql_expression (_tmp133_, "localDate");
#line 601 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp135_ = _tmp134_;
#line 601 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_string_append (_tmp132_, _tmp135_);
#line 601 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_g_free0 (_tmp135_);
#line 602 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp136_ = sql;
#line 602 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															g_string_append (_tmp136_, " * 24 * 3600, \"unixepoch\")");
#line 604 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 604 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_g_object_unref0 (variable);
#line 604 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_g_free0 (variable_name);
#line 604 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															return result;
#line 5740 "tracker-sparql-expression.c"
														} else {
															const gchar* _tmp137_;
#line 605 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															_tmp137_ = uri;
#line 605 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
															if (g_strcmp0 (_tmp137_, TRACKER_SPARQL_EXPRESSION_FN_NS "day-from-dateTime") == 0) {
#line 5747 "tracker-sparql-expression.c"
																gchar* _tmp138_ = NULL;
																gchar* _tmp139_;
																gchar* _tmp140_ = NULL;
																gchar* _tmp141_;
																gchar* variable_name;
																TrackerSparqlContext* _tmp142_;
																TrackerSparqlContext* _tmp143_;
																const gchar* _tmp144_;
																TrackerSparqlVariable* _tmp145_ = NULL;
																TrackerSparqlVariable* _tmp146_;
																TrackerSparqlVariable* variable;
																GString* _tmp147_;
																GString* _tmp148_;
																TrackerSparqlVariable* _tmp149_;
																gchar* _tmp150_ = NULL;
																gchar* _tmp151_;
																GString* _tmp152_;
#line 606 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 606 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																if (_inner_error_ != NULL) {
#line 606 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 606 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_propagate_error (error, _inner_error_);
#line 606 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		return 0;
#line 5775 "tracker-sparql-expression.c"
																	} else {
#line 606 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 606 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_clear_error (&_inner_error_);
#line 606 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		return 0;
#line 5783 "tracker-sparql-expression.c"
																	}
																}
#line 607 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp138_ = tracker_sparql_expression_get_last_string (self, 0);
#line 607 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp139_ = _tmp138_;
#line 607 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp140_ = string_substring (_tmp139_, (glong) 1, (glong) (-1));
#line 607 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp141_ = _tmp140_;
#line 607 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_g_free0 (_tmp139_);
#line 607 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																variable_name = _tmp141_;
#line 608 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp142_ = tracker_sparql_expression_get_context (self);
#line 608 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp143_ = _tmp142_;
#line 608 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp144_ = variable_name;
#line 608 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp145_ = tracker_sparql_context_get_variable (_tmp143_, _tmp144_);
#line 608 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp146_ = _g_object_ref0 (_tmp145_);
#line 608 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																variable = _tmp146_;
#line 610 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp147_ = sql;
#line 610 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_string_append (_tmp147_, "strftime (\"%d\", ");
#line 611 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp148_ = sql;
#line 611 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp149_ = variable;
#line 611 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp150_ = tracker_sparql_variable_get_extra_sql_expression (_tmp149_, "localDate");
#line 611 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp151_ = _tmp150_;
#line 611 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_string_append (_tmp148_, _tmp151_);
#line 611 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_g_free0 (_tmp151_);
#line 612 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp152_ = sql;
#line 612 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																g_string_append (_tmp152_, " * 24 * 3600, \"unixepoch\")");
#line 614 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 614 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_g_object_unref0 (variable);
#line 614 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_g_free0 (variable_name);
#line 614 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																return result;
#line 5838 "tracker-sparql-expression.c"
															} else {
																const gchar* _tmp153_;
#line 615 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																_tmp153_ = uri;
#line 615 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																if (g_strcmp0 (_tmp153_, TRACKER_SPARQL_EXPRESSION_FN_NS "hours-from-dateTime") == 0) {
#line 5845 "tracker-sparql-expression.c"
																	gchar* _tmp154_ = NULL;
																	gchar* _tmp155_;
																	gchar* _tmp156_ = NULL;
																	gchar* _tmp157_;
																	gchar* variable_name;
																	TrackerSparqlContext* _tmp158_;
																	TrackerSparqlContext* _tmp159_;
																	const gchar* _tmp160_;
																	TrackerSparqlVariable* _tmp161_ = NULL;
																	TrackerSparqlVariable* _tmp162_;
																	TrackerSparqlVariable* variable;
																	GString* _tmp163_;
																	GString* _tmp164_;
																	TrackerSparqlVariable* _tmp165_;
																	gchar* _tmp166_ = NULL;
																	gchar* _tmp167_;
																	GString* _tmp168_;
#line 616 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 616 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	if (_inner_error_ != NULL) {
#line 616 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 616 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_propagate_error (error, _inner_error_);
#line 616 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			return 0;
#line 5873 "tracker-sparql-expression.c"
																		} else {
#line 616 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 616 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_clear_error (&_inner_error_);
#line 616 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			return 0;
#line 5881 "tracker-sparql-expression.c"
																		}
																	}
#line 617 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp154_ = tracker_sparql_expression_get_last_string (self, 0);
#line 617 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp155_ = _tmp154_;
#line 617 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp156_ = string_substring (_tmp155_, (glong) 1, (glong) (-1));
#line 617 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp157_ = _tmp156_;
#line 617 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_g_free0 (_tmp155_);
#line 617 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	variable_name = _tmp157_;
#line 618 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp158_ = tracker_sparql_expression_get_context (self);
#line 618 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp159_ = _tmp158_;
#line 618 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp160_ = variable_name;
#line 618 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp161_ = tracker_sparql_context_get_variable (_tmp159_, _tmp160_);
#line 618 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp162_ = _g_object_ref0 (_tmp161_);
#line 618 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	variable = _tmp162_;
#line 620 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp163_ = sql;
#line 620 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_string_append (_tmp163_, "(");
#line 621 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp164_ = sql;
#line 621 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp165_ = variable;
#line 621 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp166_ = tracker_sparql_variable_get_extra_sql_expression (_tmp165_, "localTime");
#line 621 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp167_ = _tmp166_;
#line 621 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_string_append (_tmp164_, _tmp167_);
#line 621 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_g_free0 (_tmp167_);
#line 622 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp168_ = sql;
#line 622 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	g_string_append (_tmp168_, " / 3600)");
#line 624 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 624 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_g_object_unref0 (variable);
#line 624 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_g_free0 (variable_name);
#line 624 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	return result;
#line 5936 "tracker-sparql-expression.c"
																} else {
																	const gchar* _tmp169_;
#line 625 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	_tmp169_ = uri;
#line 625 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																	if (g_strcmp0 (_tmp169_, TRACKER_SPARQL_EXPRESSION_FN_NS "minutes-from-dateTime") == 0) {
#line 5943 "tracker-sparql-expression.c"
																		gchar* _tmp170_ = NULL;
																		gchar* _tmp171_;
																		gchar* _tmp172_ = NULL;
																		gchar* _tmp173_;
																		gchar* variable_name;
																		TrackerSparqlContext* _tmp174_;
																		TrackerSparqlContext* _tmp175_;
																		const gchar* _tmp176_;
																		TrackerSparqlVariable* _tmp177_ = NULL;
																		TrackerSparqlVariable* _tmp178_;
																		TrackerSparqlVariable* variable;
																		GString* _tmp179_;
																		GString* _tmp180_;
																		TrackerSparqlVariable* _tmp181_;
																		gchar* _tmp182_ = NULL;
																		gchar* _tmp183_;
																		GString* _tmp184_;
#line 626 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 626 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		if (_inner_error_ != NULL) {
#line 626 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 626 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_propagate_error (error, _inner_error_);
#line 626 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				return 0;
#line 5971 "tracker-sparql-expression.c"
																			} else {
#line 626 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 626 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_clear_error (&_inner_error_);
#line 626 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				return 0;
#line 5979 "tracker-sparql-expression.c"
																			}
																		}
#line 627 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp170_ = tracker_sparql_expression_get_last_string (self, 0);
#line 627 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp171_ = _tmp170_;
#line 627 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp172_ = string_substring (_tmp171_, (glong) 1, (glong) (-1));
#line 627 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp173_ = _tmp172_;
#line 627 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_g_free0 (_tmp171_);
#line 627 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		variable_name = _tmp173_;
#line 628 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp174_ = tracker_sparql_expression_get_context (self);
#line 628 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp175_ = _tmp174_;
#line 628 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp176_ = variable_name;
#line 628 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp177_ = tracker_sparql_context_get_variable (_tmp175_, _tmp176_);
#line 628 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp178_ = _g_object_ref0 (_tmp177_);
#line 628 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		variable = _tmp178_;
#line 630 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp179_ = sql;
#line 630 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_string_append (_tmp179_, "(");
#line 631 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp180_ = sql;
#line 631 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp181_ = variable;
#line 631 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp182_ = tracker_sparql_variable_get_extra_sql_expression (_tmp181_, "localTime");
#line 631 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp183_ = _tmp182_;
#line 631 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_string_append (_tmp180_, _tmp183_);
#line 631 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_g_free0 (_tmp183_);
#line 632 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp184_ = sql;
#line 632 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		g_string_append (_tmp184_, " / 60 % 60)");
#line 634 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 634 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_g_object_unref0 (variable);
#line 634 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_g_free0 (variable_name);
#line 634 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		return result;
#line 6034 "tracker-sparql-expression.c"
																	} else {
																		const gchar* _tmp185_;
#line 635 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		_tmp185_ = uri;
#line 635 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																		if (g_strcmp0 (_tmp185_, TRACKER_SPARQL_EXPRESSION_FN_NS "seconds-from-dateTime") == 0) {
#line 6041 "tracker-sparql-expression.c"
																			gchar* _tmp186_ = NULL;
																			gchar* _tmp187_;
																			gchar* _tmp188_ = NULL;
																			gchar* _tmp189_;
																			gchar* variable_name;
																			TrackerSparqlContext* _tmp190_;
																			TrackerSparqlContext* _tmp191_;
																			const gchar* _tmp192_;
																			TrackerSparqlVariable* _tmp193_ = NULL;
																			TrackerSparqlVariable* _tmp194_;
																			TrackerSparqlVariable* variable;
																			GString* _tmp195_;
																			GString* _tmp196_;
																			TrackerSparqlVariable* _tmp197_;
																			gchar* _tmp198_ = NULL;
																			gchar* _tmp199_;
																			GString* _tmp200_;
#line 636 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 636 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			if (_inner_error_ != NULL) {
#line 636 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 636 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					g_propagate_error (error, _inner_error_);
#line 636 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					return 0;
#line 6069 "tracker-sparql-expression.c"
																				} else {
#line 636 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 636 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					g_clear_error (&_inner_error_);
#line 636 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					return 0;
#line 6077 "tracker-sparql-expression.c"
																				}
																			}
#line 637 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp186_ = tracker_sparql_expression_get_last_string (self, 0);
#line 637 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp187_ = _tmp186_;
#line 637 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp188_ = string_substring (_tmp187_, (glong) 1, (glong) (-1));
#line 637 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp189_ = _tmp188_;
#line 637 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_g_free0 (_tmp187_);
#line 637 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			variable_name = _tmp189_;
#line 638 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp190_ = tracker_sparql_expression_get_context (self);
#line 638 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp191_ = _tmp190_;
#line 638 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp192_ = variable_name;
#line 638 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp193_ = tracker_sparql_context_get_variable (_tmp191_, _tmp192_);
#line 638 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp194_ = _g_object_ref0 (_tmp193_);
#line 638 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			variable = _tmp194_;
#line 640 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp195_ = sql;
#line 640 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_string_append (_tmp195_, "(");
#line 641 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp196_ = sql;
#line 641 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp197_ = variable;
#line 641 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp198_ = tracker_sparql_variable_get_extra_sql_expression (_tmp197_, "localTime");
#line 641 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp199_ = _tmp198_;
#line 641 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_string_append (_tmp196_, _tmp199_);
#line 641 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_g_free0 (_tmp199_);
#line 642 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp200_ = sql;
#line 642 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			g_string_append (_tmp200_, "% 60)");
#line 644 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 644 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_g_object_unref0 (variable);
#line 644 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_g_free0 (variable_name);
#line 644 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			return result;
#line 6132 "tracker-sparql-expression.c"
																		} else {
																			const gchar* _tmp201_;
#line 645 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			_tmp201_ = uri;
#line 645 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																			if (g_strcmp0 (_tmp201_, TRACKER_SPARQL_EXPRESSION_FN_NS "timezone-from-dateTime") == 0) {
#line 6139 "tracker-sparql-expression.c"
																				gchar* _tmp202_ = NULL;
																				gchar* _tmp203_;
																				gchar* _tmp204_ = NULL;
																				gchar* _tmp205_;
																				gchar* variable_name;
																				TrackerSparqlContext* _tmp206_;
																				TrackerSparqlContext* _tmp207_;
																				const gchar* _tmp208_;
																				TrackerSparqlVariable* _tmp209_ = NULL;
																				TrackerSparqlVariable* _tmp210_;
																				TrackerSparqlVariable* variable;
																				GString* _tmp211_;
																				GString* _tmp212_;
																				TrackerSparqlVariable* _tmp213_;
																				gchar* _tmp214_ = NULL;
																				gchar* _tmp215_;
																				GString* _tmp216_;
																				GString* _tmp217_;
																				TrackerSparqlVariable* _tmp218_;
																				gchar* _tmp219_ = NULL;
																				gchar* _tmp220_;
																				GString* _tmp221_;
																				GString* _tmp222_;
																				GString* _tmp223_;
																				TrackerSparqlVariable* _tmp224_;
																				const gchar* _tmp225_;
																				const gchar* _tmp226_;
																				GString* _tmp227_;
																				GString* _tmp228_;
#line 646 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 646 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				if (_inner_error_ != NULL) {
#line 646 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 646 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_propagate_error (error, _inner_error_);
#line 646 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						return 0;
#line 6179 "tracker-sparql-expression.c"
																					} else {
#line 646 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 646 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_clear_error (&_inner_error_);
#line 646 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						return 0;
#line 6187 "tracker-sparql-expression.c"
																					}
																				}
#line 647 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp202_ = tracker_sparql_expression_get_last_string (self, 0);
#line 647 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp203_ = _tmp202_;
#line 647 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp204_ = string_substring (_tmp203_, (glong) 1, (glong) (-1));
#line 647 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp205_ = _tmp204_;
#line 647 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_g_free0 (_tmp203_);
#line 647 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				variable_name = _tmp205_;
#line 648 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp206_ = tracker_sparql_expression_get_context (self);
#line 648 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp207_ = _tmp206_;
#line 648 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp208_ = variable_name;
#line 648 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp209_ = tracker_sparql_context_get_variable (_tmp207_, _tmp208_);
#line 648 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp210_ = _g_object_ref0 (_tmp209_);
#line 648 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				variable = _tmp210_;
#line 650 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp211_ = sql;
#line 650 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp211_, "(");
#line 651 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp212_ = sql;
#line 651 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp213_ = variable;
#line 651 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp214_ = tracker_sparql_variable_get_extra_sql_expression (_tmp213_, "localDate");
#line 651 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp215_ = _tmp214_;
#line 651 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp212_, _tmp215_);
#line 651 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_g_free0 (_tmp215_);
#line 652 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp216_ = sql;
#line 652 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp216_, " * 24 * 3600 + ");
#line 653 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp217_ = sql;
#line 653 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp218_ = variable;
#line 653 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp219_ = tracker_sparql_variable_get_extra_sql_expression (_tmp218_, "localTime");
#line 653 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp220_ = _tmp219_;
#line 653 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp217_, _tmp220_);
#line 653 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_g_free0 (_tmp220_);
#line 654 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp221_ = sql;
#line 654 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp221_, "- ");
#line 655 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp222_ = sql;
#line 655 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp222_, "CAST (");
#line 656 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp223_ = sql;
#line 656 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp224_ = variable;
#line 656 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp225_ = tracker_sparql_variable_get_sql_expression (_tmp224_);
#line 656 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp226_ = _tmp225_;
#line 656 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp223_, _tmp226_);
#line 657 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp227_ = sql;
#line 657 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp227_, " AS INTEGER)");
#line 658 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp228_ = sql;
#line 658 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				g_string_append (_tmp228_, ")");
#line 660 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 660 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_g_object_unref0 (variable);
#line 660 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_g_free0 (variable_name);
#line 660 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				return result;
#line 6280 "tracker-sparql-expression.c"
																			} else {
																				const gchar* _tmp229_;
#line 661 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				_tmp229_ = uri;
#line 661 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																				if (g_strcmp0 (_tmp229_, TRACKER_SPARQL_EXPRESSION_FTS_NS "rank") == 0) {
#line 6287 "tracker-sparql-expression.c"
																					gboolean is_var = FALSE;
																					TrackerSparqlPattern* _tmp230_;
																					TrackerSparqlPattern* _tmp231_;
																					gboolean _tmp232_ = FALSE;
																					gchar* _tmp233_ = NULL;
																					gchar* v;
																					GString* _tmp234_;
																					const gchar* _tmp235_;
#line 663 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp230_ = tracker_sparql_expression_get_pattern (self);
#line 663 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp231_ = _tmp230_;
#line 663 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp233_ = tracker_sparql_pattern_parse_var_or_term (_tmp231_, NULL, &_tmp232_, &_inner_error_);
#line 663 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					is_var = _tmp232_;
#line 663 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					v = _tmp233_;
#line 663 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					if (_inner_error_ != NULL) {
#line 663 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 663 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							g_propagate_error (error, _inner_error_);
#line 663 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							return 0;
#line 6314 "tracker-sparql-expression.c"
																						} else {
#line 663 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 663 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							g_clear_error (&_inner_error_);
#line 663 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							return 0;
#line 6322 "tracker-sparql-expression.c"
																						}
																					}
#line 664 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp234_ = sql;
#line 664 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp235_ = v;
#line 664 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					g_string_append_printf (_tmp234_, "\"%s_u_rank\"", _tmp235_);
#line 666 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 666 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_g_free0 (v);
#line 666 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					return result;
#line 6337 "tracker-sparql-expression.c"
																				} else {
																					const gchar* _tmp236_;
#line 667 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					_tmp236_ = uri;
#line 667 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																					if (g_strcmp0 (_tmp236_, TRACKER_SPARQL_EXPRESSION_FTS_NS "offsets") == 0) {
#line 6344 "tracker-sparql-expression.c"
																						gboolean is_var = FALSE;
																						TrackerSparqlPattern* _tmp237_;
																						TrackerSparqlPattern* _tmp238_;
																						gboolean _tmp239_ = FALSE;
																						gchar* _tmp240_ = NULL;
																						gchar* v;
																						TrackerSparqlContext* _tmp241_;
																						TrackerSparqlContext* _tmp242_;
																						const gchar* _tmp243_;
																						TrackerSparqlVariable* _tmp244_ = NULL;
																						TrackerSparqlVariable* _tmp245_;
																						TrackerSparqlVariable* variable;
																						GString* _tmp246_;
																						TrackerSparqlVariable* _tmp247_;
																						const gchar* _tmp248_;
																						const gchar* _tmp249_;
																						gchar* _tmp250_;
#line 669 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp237_ = tracker_sparql_expression_get_pattern (self);
#line 669 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp238_ = _tmp237_;
#line 669 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp240_ = tracker_sparql_pattern_parse_var_or_term (_tmp238_, NULL, &_tmp239_, &_inner_error_);
#line 669 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						is_var = _tmp239_;
#line 669 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						v = _tmp240_;
#line 669 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						if (_inner_error_ != NULL) {
#line 669 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 669 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								g_propagate_error (error, _inner_error_);
#line 669 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								return 0;
#line 6380 "tracker-sparql-expression.c"
																							} else {
#line 669 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 669 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								g_clear_error (&_inner_error_);
#line 669 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								return 0;
#line 6388 "tracker-sparql-expression.c"
																							}
																						}
#line 670 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp241_ = tracker_sparql_expression_get_context (self);
#line 670 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp242_ = _tmp241_;
#line 670 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp243_ = v;
#line 670 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp244_ = tracker_sparql_context_get_variable (_tmp242_, _tmp243_);
#line 670 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp245_ = _g_object_ref0 (_tmp244_);
#line 670 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						variable = _tmp245_;
#line 672 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp246_ = sql;
#line 672 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp247_ = variable;
#line 672 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp248_ = tracker_sparql_variable_get_sql_expression (_tmp247_);
#line 672 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp249_ = _tmp248_;
#line 672 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						g_string_append (_tmp246_, _tmp249_);
#line 673 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp250_ = g_strdup ("tracker_offsets(offsets(\"fts\"),fts_property_names())");
#line 673 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_g_free0 (self->priv->fts_sql);
#line 673 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						self->priv->fts_sql = _tmp250_;
#line 674 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						result = TRACKER_PROPERTY_TYPE_STRING;
#line 674 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_g_object_unref0 (variable);
#line 674 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_g_free0 (v);
#line 674 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						return result;
#line 6427 "tracker-sparql-expression.c"
																					} else {
																						const gchar* _tmp251_;
#line 675 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						_tmp251_ = uri;
#line 675 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																						if (g_strcmp0 (_tmp251_, TRACKER_SPARQL_EXPRESSION_FTS_NS "snippet") == 0) {
#line 6434 "tracker-sparql-expression.c"
																							gboolean is_var = FALSE;
																							TrackerSparqlPattern* _tmp252_;
																							TrackerSparqlPattern* _tmp253_;
																							gboolean _tmp254_ = FALSE;
																							gchar* _tmp255_ = NULL;
																							gchar* v;
																							TrackerSparqlContext* _tmp256_;
																							TrackerSparqlContext* _tmp257_;
																							const gchar* _tmp258_;
																							TrackerSparqlVariable* _tmp259_ = NULL;
																							TrackerSparqlVariable* _tmp260_;
																							TrackerSparqlVariable* variable;
																							GString* _tmp261_;
																							GString* fts;
																							GString* _tmp262_;
																							gboolean _tmp263_ = FALSE;
																							gboolean _tmp264_;
																							gboolean _tmp270_ = FALSE;
																							gboolean _tmp271_;
																							GString* _tmp275_;
																							gboolean _tmp276_ = FALSE;
																							gboolean _tmp277_;
																							GString* _tmp281_;
																							GString* _tmp282_;
																							const gchar* _tmp283_;
																							gchar* _tmp284_;
																							GString* _tmp285_;
																							TrackerSparqlVariable* _tmp286_;
																							const gchar* _tmp287_;
																							const gchar* _tmp288_;
#line 678 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp252_ = tracker_sparql_expression_get_pattern (self);
#line 678 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp253_ = _tmp252_;
#line 678 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp255_ = tracker_sparql_pattern_parse_var_or_term (_tmp253_, NULL, &_tmp254_, &_inner_error_);
#line 678 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							is_var = _tmp254_;
#line 678 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							v = _tmp255_;
#line 678 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							if (_inner_error_ != NULL) {
#line 678 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 678 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_propagate_error (error, _inner_error_);
#line 678 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									return 0;
#line 6483 "tracker-sparql-expression.c"
																								} else {
#line 678 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 678 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_clear_error (&_inner_error_);
#line 678 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									return 0;
#line 6491 "tracker-sparql-expression.c"
																								}
																							}
#line 679 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp256_ = tracker_sparql_expression_get_context (self);
#line 679 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp257_ = _tmp256_;
#line 679 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp258_ = v;
#line 679 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp259_ = tracker_sparql_context_get_variable (_tmp257_, _tmp258_);
#line 679 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp260_ = _g_object_ref0 (_tmp259_);
#line 679 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							variable = _tmp260_;
#line 680 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp261_ = g_string_new ("");
#line 680 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							fts = _tmp261_;
#line 682 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp262_ = fts;
#line 682 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							g_string_append_printf (_tmp262_, "snippet(\"fts\"");
#line 685 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp263_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 685 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp264_ = _tmp263_;
#line 685 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							if (_inner_error_ != NULL) {
#line 685 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 685 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_propagate_error (error, _inner_error_);
#line 685 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_g_string_free0 (fts);
#line 685 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_g_object_unref0 (variable);
#line 685 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_g_free0 (v);
#line 685 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									return 0;
#line 6532 "tracker-sparql-expression.c"
																								} else {
#line 685 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_g_string_free0 (fts);
#line 685 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_g_object_unref0 (variable);
#line 685 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_g_free0 (v);
#line 685 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 685 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_clear_error (&_inner_error_);
#line 685 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									return 0;
#line 6546 "tracker-sparql-expression.c"
																								}
																							}
#line 685 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							if (_tmp264_) {
#line 6551 "tracker-sparql-expression.c"
																								GString* _tmp265_;
																								GString* _tmp266_;
																								GString* _tmp267_;
																								GString* _tmp268_;
#line 686 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp265_ = fts;
#line 686 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								g_string_append (_tmp265_, ", ");
#line 687 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp266_ = fts;
#line 687 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								tracker_sparql_expression_translate_expression_as_string (self, _tmp266_, &_inner_error_);
#line 687 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (_inner_error_ != NULL) {
#line 687 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 687 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_propagate_error (error, _inner_error_);
#line 687 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_string_free0 (fts);
#line 687 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_object_unref0 (variable);
#line 687 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_free0 (v);
#line 687 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6578 "tracker-sparql-expression.c"
																									} else {
#line 687 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_string_free0 (fts);
#line 687 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_object_unref0 (variable);
#line 687 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_free0 (v);
#line 687 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 687 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_clear_error (&_inner_error_);
#line 687 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6592 "tracker-sparql-expression.c"
																									}
																								}
#line 690 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 690 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (_inner_error_ != NULL) {
#line 690 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 690 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_propagate_error (error, _inner_error_);
#line 690 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_string_free0 (fts);
#line 690 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_object_unref0 (variable);
#line 690 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_free0 (v);
#line 690 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6611 "tracker-sparql-expression.c"
																									} else {
#line 690 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_string_free0 (fts);
#line 690 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_object_unref0 (variable);
#line 690 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_free0 (v);
#line 690 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 690 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_clear_error (&_inner_error_);
#line 690 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6625 "tracker-sparql-expression.c"
																									}
																								}
#line 691 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp267_ = fts;
#line 691 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								g_string_append (_tmp267_, ", ");
#line 692 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp268_ = fts;
#line 692 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								tracker_sparql_expression_translate_expression_as_string (self, _tmp268_, &_inner_error_);
#line 692 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (_inner_error_ != NULL) {
#line 692 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 692 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_propagate_error (error, _inner_error_);
#line 692 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_string_free0 (fts);
#line 692 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_object_unref0 (variable);
#line 692 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_free0 (v);
#line 692 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6650 "tracker-sparql-expression.c"
																									} else {
#line 692 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_string_free0 (fts);
#line 692 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_object_unref0 (variable);
#line 692 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_free0 (v);
#line 692 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 692 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_clear_error (&_inner_error_);
#line 692 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6664 "tracker-sparql-expression.c"
																									}
																								}
																							} else {
																								GString* _tmp269_;
#line 694 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp269_ = fts;
#line 694 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								g_string_append (_tmp269_, ",'',''");
#line 6673 "tracker-sparql-expression.c"
																							}
#line 698 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp270_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 698 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp271_ = _tmp270_;
#line 698 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							if (_inner_error_ != NULL) {
#line 698 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 698 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_propagate_error (error, _inner_error_);
#line 698 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_g_string_free0 (fts);
#line 698 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_g_object_unref0 (variable);
#line 698 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_g_free0 (v);
#line 698 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									return 0;
#line 6693 "tracker-sparql-expression.c"
																								} else {
#line 698 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_g_string_free0 (fts);
#line 698 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_g_object_unref0 (variable);
#line 698 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_g_free0 (v);
#line 698 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 698 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_clear_error (&_inner_error_);
#line 698 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									return 0;
#line 6707 "tracker-sparql-expression.c"
																								}
																							}
#line 698 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							if (_tmp271_) {
#line 6712 "tracker-sparql-expression.c"
																								GString* _tmp272_;
																								GString* _tmp273_;
#line 699 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp272_ = fts;
#line 699 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								g_string_append (_tmp272_, ", ");
#line 700 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp273_ = fts;
#line 700 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								tracker_sparql_expression_translate_expression_as_string (self, _tmp273_, &_inner_error_);
#line 700 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (_inner_error_ != NULL) {
#line 700 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 700 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_propagate_error (error, _inner_error_);
#line 700 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_string_free0 (fts);
#line 700 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_object_unref0 (variable);
#line 700 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_free0 (v);
#line 700 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6737 "tracker-sparql-expression.c"
																									} else {
#line 700 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_string_free0 (fts);
#line 700 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_object_unref0 (variable);
#line 700 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_free0 (v);
#line 700 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 700 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_clear_error (&_inner_error_);
#line 700 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6751 "tracker-sparql-expression.c"
																									}
																								}
																							} else {
																								GString* _tmp274_;
#line 702 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp274_ = fts;
#line 702 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								g_string_append (_tmp274_, ", '...'");
#line 6760 "tracker-sparql-expression.c"
																							}
#line 706 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp275_ = fts;
#line 706 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							g_string_append (_tmp275_, ", -1");
#line 709 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp276_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 709 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp277_ = _tmp276_;
#line 709 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							if (_inner_error_ != NULL) {
#line 709 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 709 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_propagate_error (error, _inner_error_);
#line 709 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_g_string_free0 (fts);
#line 709 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_g_object_unref0 (variable);
#line 709 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_g_free0 (v);
#line 709 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									return 0;
#line 6784 "tracker-sparql-expression.c"
																								} else {
#line 709 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_g_string_free0 (fts);
#line 709 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_g_object_unref0 (variable);
#line 709 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_g_free0 (v);
#line 709 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 709 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									g_clear_error (&_inner_error_);
#line 709 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									return 0;
#line 6798 "tracker-sparql-expression.c"
																								}
																							}
#line 709 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							if (_tmp277_) {
#line 6803 "tracker-sparql-expression.c"
																								GString* _tmp278_;
																								GString* _tmp279_;
#line 710 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp278_ = fts;
#line 710 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								g_string_append (_tmp278_, ", ");
#line 711 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp279_ = fts;
#line 711 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								tracker_sparql_expression_translate_expression_as_string (self, _tmp279_, &_inner_error_);
#line 711 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (_inner_error_ != NULL) {
#line 711 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 711 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_propagate_error (error, _inner_error_);
#line 711 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_string_free0 (fts);
#line 711 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_object_unref0 (variable);
#line 711 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_free0 (v);
#line 711 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6828 "tracker-sparql-expression.c"
																									} else {
#line 711 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_string_free0 (fts);
#line 711 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_object_unref0 (variable);
#line 711 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_g_free0 (v);
#line 711 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 711 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_clear_error (&_inner_error_);
#line 711 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6842 "tracker-sparql-expression.c"
																									}
																								}
																							} else {
																								GString* _tmp280_;
#line 713 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp280_ = fts;
#line 713 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								g_string_append (_tmp280_, ", 5");
#line 6851 "tracker-sparql-expression.c"
																							}
#line 716 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp281_ = fts;
#line 716 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							g_string_append (_tmp281_, ")");
#line 718 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp282_ = fts;
#line 718 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp283_ = _tmp282_->str;
#line 718 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp284_ = g_strdup (_tmp283_);
#line 718 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_g_free0 (self->priv->fts_sql);
#line 718 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							self->priv->fts_sql = _tmp284_;
#line 719 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp285_ = sql;
#line 719 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp286_ = variable;
#line 719 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp287_ = tracker_sparql_variable_get_sql_expression (_tmp286_);
#line 719 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp288_ = _tmp287_;
#line 719 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							g_string_append (_tmp285_, _tmp288_);
#line 720 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							result = TRACKER_PROPERTY_TYPE_STRING;
#line 720 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_g_string_free0 (fts);
#line 720 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_g_object_unref0 (variable);
#line 720 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_g_free0 (v);
#line 720 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							return result;
#line 6887 "tracker-sparql-expression.c"
																						} else {
																							const gchar* _tmp289_;
#line 721 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							_tmp289_ = uri;
#line 721 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																							if (g_strcmp0 (_tmp289_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "id") == 0) {
#line 6894 "tracker-sparql-expression.c"
																								GString* _tmp290_;
																								TrackerPropertyType _tmp291_ = 0;
																								TrackerPropertyType type;
																								TrackerPropertyType _tmp292_;
#line 722 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp290_ = sql;
#line 722 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp291_ = tracker_sparql_expression_translate_expression (self, _tmp290_, &_inner_error_);
#line 722 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								type = _tmp291_;
#line 722 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (_inner_error_ != NULL) {
#line 722 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 722 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_propagate_error (error, _inner_error_);
#line 722 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6913 "tracker-sparql-expression.c"
																									} else {
#line 722 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 722 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_clear_error (&_inner_error_);
#line 722 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6921 "tracker-sparql-expression.c"
																									}
																								}
#line 723 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp292_ = type;
#line 723 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (_tmp292_ != TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 6928 "tracker-sparql-expression.c"
																									GError* _tmp293_ = NULL;
#line 724 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp293_ = tracker_sparql_expression_get_error (self, "expected resource");
#line 724 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_inner_error_ = _tmp293_;
#line 724 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 724 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_propagate_error (error, _inner_error_);
#line 724 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6940 "tracker-sparql-expression.c"
																									} else {
#line 724 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 724 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_clear_error (&_inner_error_);
#line 724 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return 0;
#line 6948 "tracker-sparql-expression.c"
																									}
																								}
#line 727 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 727 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								return result;
#line 6955 "tracker-sparql-expression.c"
																							} else {
																								const gchar* _tmp294_;
#line 728 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								_tmp294_ = uri;
#line 728 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																								if (g_strcmp0 (_tmp294_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "uri") == 0) {
#line 6962 "tracker-sparql-expression.c"
																									GString* _tmp295_;
																									TrackerPropertyType _tmp296_ = 0;
																									TrackerPropertyType type;
																									TrackerPropertyType _tmp297_;
#line 729 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp295_ = sql;
#line 729 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp296_ = tracker_sparql_expression_translate_expression (self, _tmp295_, &_inner_error_);
#line 729 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									type = _tmp296_;
#line 729 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_inner_error_ != NULL) {
#line 729 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 729 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error_);
#line 729 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6981 "tracker-sparql-expression.c"
																										} else {
#line 729 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 729 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error_);
#line 729 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 6989 "tracker-sparql-expression.c"
																										}
																									}
#line 730 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp297_ = type;
#line 730 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (_tmp297_ != TRACKER_PROPERTY_TYPE_INTEGER) {
#line 6996 "tracker-sparql-expression.c"
																										GError* _tmp298_ = NULL;
#line 731 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp298_ = tracker_sparql_expression_get_error (self, "expected integer ID");
#line 731 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_inner_error_ = _tmp298_;
#line 731 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 731 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_propagate_error (error, _inner_error_);
#line 731 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 7008 "tracker-sparql-expression.c"
																										} else {
#line 731 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 731 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_clear_error (&_inner_error_);
#line 731 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return 0;
#line 7016 "tracker-sparql-expression.c"
																										}
																									}
#line 734 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									result = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 734 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									return result;
#line 7023 "tracker-sparql-expression.c"
																								} else {
																									const gchar* _tmp299_;
#line 735 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									_tmp299_ = uri;
#line 735 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																									if (g_strcmp0 (_tmp299_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "cartesian-distance") == 0) {
#line 7030 "tracker-sparql-expression.c"
																										GString* _tmp300_;
																										GString* _tmp301_;
																										GString* _tmp302_;
																										GString* _tmp303_;
																										GString* _tmp304_;
																										GString* _tmp305_;
																										GString* _tmp306_;
																										GString* _tmp307_;
																										GString* _tmp308_;
#line 736 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp300_ = sql;
#line 736 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_string_append (_tmp300_, "SparqlCartesianDistance(");
#line 737 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp301_ = sql;
#line 737 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_translate_expression (self, _tmp301_, &_inner_error_);
#line 737 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 737 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 737 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 737 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 7056 "tracker-sparql-expression.c"
																											} else {
#line 737 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 737 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 737 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 7064 "tracker-sparql-expression.c"
																											}
																										}
#line 738 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp302_ = sql;
#line 738 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_string_append (_tmp302_, ", ");
#line 739 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 739 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 739 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 739 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 739 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 7081 "tracker-sparql-expression.c"
																											} else {
#line 739 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 739 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 739 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 7089 "tracker-sparql-expression.c"
																											}
																										}
#line 740 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp303_ = sql;
#line 740 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_translate_expression (self, _tmp303_, &_inner_error_);
#line 740 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 740 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 740 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 740 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 7104 "tracker-sparql-expression.c"
																											} else {
#line 740 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 740 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 740 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 7112 "tracker-sparql-expression.c"
																											}
																										}
#line 741 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp304_ = sql;
#line 741 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_string_append (_tmp304_, ", ");
#line 742 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 742 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 742 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 742 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 742 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 7129 "tracker-sparql-expression.c"
																											} else {
#line 742 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 742 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 742 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 7137 "tracker-sparql-expression.c"
																											}
																										}
#line 743 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp305_ = sql;
#line 743 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_translate_expression (self, _tmp305_, &_inner_error_);
#line 743 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 743 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 743 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 743 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 7152 "tracker-sparql-expression.c"
																											} else {
#line 743 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 743 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 743 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 7160 "tracker-sparql-expression.c"
																											}
																										}
#line 744 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp306_ = sql;
#line 744 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_string_append (_tmp306_, ", ");
#line 745 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 745 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 745 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 745 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 745 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 7177 "tracker-sparql-expression.c"
																											} else {
#line 745 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 745 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 745 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 7185 "tracker-sparql-expression.c"
																											}
																										}
#line 746 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp307_ = sql;
#line 746 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										tracker_sparql_expression_translate_expression (self, _tmp307_, &_inner_error_);
#line 746 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (_inner_error_ != NULL) {
#line 746 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 746 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_propagate_error (error, _inner_error_);
#line 746 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 7200 "tracker-sparql-expression.c"
																											} else {
#line 746 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 746 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_clear_error (&_inner_error_);
#line 746 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return 0;
#line 7208 "tracker-sparql-expression.c"
																											}
																										}
#line 747 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp308_ = sql;
#line 747 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										g_string_append (_tmp308_, ")");
#line 749 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 749 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										return result;
#line 7219 "tracker-sparql-expression.c"
																									} else {
																										const gchar* _tmp309_;
#line 750 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										_tmp309_ = uri;
#line 750 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																										if (g_strcmp0 (_tmp309_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "haversine-distance") == 0) {
#line 7226 "tracker-sparql-expression.c"
																											GString* _tmp310_;
																											GString* _tmp311_;
																											GString* _tmp312_;
																											GString* _tmp313_;
																											GString* _tmp314_;
																											GString* _tmp315_;
																											GString* _tmp316_;
																											GString* _tmp317_;
																											GString* _tmp318_;
#line 751 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp310_ = sql;
#line 751 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_string_append (_tmp310_, "SparqlHaversineDistance(");
#line 752 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp311_ = sql;
#line 752 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											tracker_sparql_expression_translate_expression (self, _tmp311_, &_inner_error_);
#line 752 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_ != NULL) {
#line 752 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 752 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_propagate_error (error, _inner_error_);
#line 752 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 7252 "tracker-sparql-expression.c"
																												} else {
#line 752 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 752 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_clear_error (&_inner_error_);
#line 752 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 7260 "tracker-sparql-expression.c"
																												}
																											}
#line 753 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp312_ = sql;
#line 753 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_string_append (_tmp312_, ", ");
#line 754 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 754 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_ != NULL) {
#line 754 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 754 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_propagate_error (error, _inner_error_);
#line 754 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 7277 "tracker-sparql-expression.c"
																												} else {
#line 754 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 754 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_clear_error (&_inner_error_);
#line 754 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 7285 "tracker-sparql-expression.c"
																												}
																											}
#line 755 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp313_ = sql;
#line 755 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											tracker_sparql_expression_translate_expression (self, _tmp313_, &_inner_error_);
#line 755 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_ != NULL) {
#line 755 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 755 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_propagate_error (error, _inner_error_);
#line 755 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 7300 "tracker-sparql-expression.c"
																												} else {
#line 755 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 755 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_clear_error (&_inner_error_);
#line 755 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 7308 "tracker-sparql-expression.c"
																												}
																											}
#line 756 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp314_ = sql;
#line 756 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_string_append (_tmp314_, ", ");
#line 757 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 757 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_ != NULL) {
#line 757 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 757 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_propagate_error (error, _inner_error_);
#line 757 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 7325 "tracker-sparql-expression.c"
																												} else {
#line 757 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 757 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_clear_error (&_inner_error_);
#line 757 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 7333 "tracker-sparql-expression.c"
																												}
																											}
#line 758 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp315_ = sql;
#line 758 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											tracker_sparql_expression_translate_expression (self, _tmp315_, &_inner_error_);
#line 758 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_ != NULL) {
#line 758 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 758 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_propagate_error (error, _inner_error_);
#line 758 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 7348 "tracker-sparql-expression.c"
																												} else {
#line 758 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 758 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_clear_error (&_inner_error_);
#line 758 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 7356 "tracker-sparql-expression.c"
																												}
																											}
#line 759 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp316_ = sql;
#line 759 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_string_append (_tmp316_, ", ");
#line 760 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 760 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_ != NULL) {
#line 760 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 760 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_propagate_error (error, _inner_error_);
#line 760 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 7373 "tracker-sparql-expression.c"
																												} else {
#line 760 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 760 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_clear_error (&_inner_error_);
#line 760 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 7381 "tracker-sparql-expression.c"
																												}
																											}
#line 761 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp317_ = sql;
#line 761 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											tracker_sparql_expression_translate_expression (self, _tmp317_, &_inner_error_);
#line 761 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (_inner_error_ != NULL) {
#line 761 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 761 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_propagate_error (error, _inner_error_);
#line 761 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 7396 "tracker-sparql-expression.c"
																												} else {
#line 761 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 761 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_clear_error (&_inner_error_);
#line 761 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return 0;
#line 7404 "tracker-sparql-expression.c"
																												}
																											}
#line 762 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp318_ = sql;
#line 762 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											g_string_append (_tmp318_, ")");
#line 764 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 764 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											return result;
#line 7415 "tracker-sparql-expression.c"
																										} else {
																											const gchar* _tmp319_;
#line 765 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											_tmp319_ = uri;
#line 765 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																											if (g_strcmp0 (_tmp319_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "coalesce") == 0) {
#line 7422 "tracker-sparql-expression.c"
																												GString* _tmp320_;
																												GString* _tmp321_;
																												GString* _tmp322_;
																												GString* _tmp323_;
																												GString* _tmp328_;
#line 766 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp320_ = sql;
#line 766 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_string_append (_tmp320_, "COALESCE(");
#line 767 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp321_ = sql;
#line 767 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												tracker_sparql_expression_translate_expression_as_string (self, _tmp321_, &_inner_error_);
#line 767 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_ != NULL) {
#line 767 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 767 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error_);
#line 767 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 7444 "tracker-sparql-expression.c"
																													} else {
#line 767 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 767 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error_);
#line 767 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 7452 "tracker-sparql-expression.c"
																													}
																												}
#line 768 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp322_ = sql;
#line 768 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_string_append (_tmp322_, ", ");
#line 769 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 769 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_ != NULL) {
#line 769 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 769 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error_);
#line 769 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 7469 "tracker-sparql-expression.c"
																													} else {
#line 769 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 769 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error_);
#line 769 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 7477 "tracker-sparql-expression.c"
																													}
																												}
#line 770 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp323_ = sql;
#line 770 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												tracker_sparql_expression_translate_expression_as_string (self, _tmp323_, &_inner_error_);
#line 770 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (_inner_error_ != NULL) {
#line 770 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 770 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_propagate_error (error, _inner_error_);
#line 770 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 7492 "tracker-sparql-expression.c"
																													} else {
#line 770 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 770 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_clear_error (&_inner_error_);
#line 770 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return 0;
#line 7500 "tracker-sparql-expression.c"
																													}
																												}
#line 771 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												while (TRUE) {
#line 7505 "tracker-sparql-expression.c"
																													gboolean _tmp324_ = FALSE;
																													gboolean _tmp325_;
																													GString* _tmp326_;
																													GString* _tmp327_;
#line 771 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp324_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 771 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp325_ = _tmp324_;
#line 771 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_ != NULL) {
#line 771 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 771 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error_);
#line 771 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7522 "tracker-sparql-expression.c"
																														} else {
#line 771 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 771 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error_);
#line 771 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7530 "tracker-sparql-expression.c"
																														}
																													}
#line 771 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (!_tmp325_) {
#line 771 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														break;
#line 7537 "tracker-sparql-expression.c"
																													}
#line 772 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp326_ = sql;
#line 772 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_string_append (_tmp326_, ", ");
#line 773 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp327_ = sql;
#line 773 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													tracker_sparql_expression_translate_expression_as_string (self, _tmp327_, &_inner_error_);
#line 773 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_ != NULL) {
#line 773 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 773 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error_);
#line 773 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7555 "tracker-sparql-expression.c"
																														} else {
#line 773 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 773 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error_);
#line 773 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7563 "tracker-sparql-expression.c"
																														}
																													}
																												}
#line 775 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp328_ = sql;
#line 775 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												g_string_append (_tmp328_, ")");
#line 777 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												result = TRACKER_PROPERTY_TYPE_STRING;
#line 777 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												return result;
#line 7575 "tracker-sparql-expression.c"
																											} else {
																												const gchar* _tmp329_;
#line 778 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												_tmp329_ = uri;
#line 778 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																												if (g_strcmp0 (_tmp329_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "uri-is-parent") == 0) {
#line 7582 "tracker-sparql-expression.c"
																													GString* _tmp330_;
																													GString* _tmp331_;
																													GString* _tmp332_;
																													GString* _tmp333_;
																													GString* _tmp334_;
#line 779 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp330_ = sql;
#line 779 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_string_append (_tmp330_, "SparqlUriIsParent(");
#line 780 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp331_ = sql;
#line 780 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													tracker_sparql_expression_translate_expression_as_string (self, _tmp331_, &_inner_error_);
#line 780 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_ != NULL) {
#line 780 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 780 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error_);
#line 780 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7604 "tracker-sparql-expression.c"
																														} else {
#line 780 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 780 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error_);
#line 780 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7612 "tracker-sparql-expression.c"
																														}
																													}
#line 781 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp332_ = sql;
#line 781 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_string_append (_tmp332_, ", ");
#line 782 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 782 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_ != NULL) {
#line 782 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 782 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error_);
#line 782 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7629 "tracker-sparql-expression.c"
																														} else {
#line 782 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 782 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error_);
#line 782 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7637 "tracker-sparql-expression.c"
																														}
																													}
#line 784 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp333_ = sql;
#line 784 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													tracker_sparql_expression_translate_expression_as_string (self, _tmp333_, &_inner_error_);
#line 784 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (_inner_error_ != NULL) {
#line 784 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 784 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_propagate_error (error, _inner_error_);
#line 784 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7652 "tracker-sparql-expression.c"
																														} else {
#line 784 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 784 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_clear_error (&_inner_error_);
#line 784 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return 0;
#line 7660 "tracker-sparql-expression.c"
																														}
																													}
#line 785 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp334_ = sql;
#line 785 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													g_string_append (_tmp334_, ")");
#line 787 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 787 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													return result;
#line 7671 "tracker-sparql-expression.c"
																												} else {
																													const gchar* _tmp335_;
#line 788 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													_tmp335_ = uri;
#line 788 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																													if (g_strcmp0 (_tmp335_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "uri-is-descendant") == 0) {
#line 7678 "tracker-sparql-expression.c"
																														GString* _tmp336_;
																														GString* _tmp337_;
																														GString* _tmp338_;
																														GString* _tmp339_;
																														GString* _tmp344_;
#line 789 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp336_ = sql;
#line 789 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_string_append (_tmp336_, "SparqlUriIsDescendant(");
#line 790 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp337_ = sql;
#line 790 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														tracker_sparql_expression_translate_expression_as_string (self, _tmp337_, &_inner_error_);
#line 790 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_ != NULL) {
#line 790 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 790 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_propagate_error (error, _inner_error_);
#line 790 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7700 "tracker-sparql-expression.c"
																															} else {
#line 790 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 790 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_clear_error (&_inner_error_);
#line 790 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7708 "tracker-sparql-expression.c"
																															}
																														}
#line 791 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp338_ = sql;
#line 791 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_string_append (_tmp338_, ", ");
#line 792 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 792 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_ != NULL) {
#line 792 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 792 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_propagate_error (error, _inner_error_);
#line 792 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7725 "tracker-sparql-expression.c"
																															} else {
#line 792 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 792 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_clear_error (&_inner_error_);
#line 792 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7733 "tracker-sparql-expression.c"
																															}
																														}
#line 794 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp339_ = sql;
#line 794 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														tracker_sparql_expression_translate_expression_as_string (self, _tmp339_, &_inner_error_);
#line 794 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (_inner_error_ != NULL) {
#line 794 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 794 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_propagate_error (error, _inner_error_);
#line 794 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7748 "tracker-sparql-expression.c"
																															} else {
#line 794 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 794 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_clear_error (&_inner_error_);
#line 794 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return 0;
#line 7756 "tracker-sparql-expression.c"
																															}
																														}
#line 795 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														while (TRUE) {
#line 7761 "tracker-sparql-expression.c"
																															gboolean _tmp340_ = FALSE;
																															gboolean _tmp341_;
																															GString* _tmp342_;
																															GString* _tmp343_;
#line 795 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp340_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 795 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp341_ = _tmp340_;
#line 795 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_ != NULL) {
#line 795 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 795 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_propagate_error (error, _inner_error_);
#line 795 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7778 "tracker-sparql-expression.c"
																																} else {
#line 795 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 795 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_clear_error (&_inner_error_);
#line 795 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7786 "tracker-sparql-expression.c"
																																}
																															}
#line 795 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (!_tmp341_) {
#line 795 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																break;
#line 7793 "tracker-sparql-expression.c"
																															}
#line 796 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp342_ = sql;
#line 796 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_string_append (_tmp342_, ", ");
#line 797 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp343_ = sql;
#line 797 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															tracker_sparql_expression_translate_expression_as_string (self, _tmp343_, &_inner_error_);
#line 797 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_ != NULL) {
#line 797 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 797 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_propagate_error (error, _inner_error_);
#line 797 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7811 "tracker-sparql-expression.c"
																																} else {
#line 797 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 797 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_clear_error (&_inner_error_);
#line 797 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7819 "tracker-sparql-expression.c"
																																}
																															}
																														}
#line 799 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp344_ = sql;
#line 799 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														g_string_append (_tmp344_, ")");
#line 801 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 801 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														return result;
#line 7831 "tracker-sparql-expression.c"
																													} else {
																														const gchar* _tmp345_;
#line 802 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														_tmp345_ = uri;
#line 802 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																														if (g_strcmp0 (_tmp345_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "string-from-filename") == 0) {
#line 7838 "tracker-sparql-expression.c"
																															GString* _tmp346_;
																															GString* _tmp347_;
																															GString* _tmp348_;
#line 803 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp346_ = sql;
#line 803 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_string_append (_tmp346_, "SparqlStringFromFilename(");
#line 804 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp347_ = sql;
#line 804 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															tracker_sparql_expression_translate_expression_as_string (self, _tmp347_, &_inner_error_);
#line 804 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_ != NULL) {
#line 804 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 804 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_propagate_error (error, _inner_error_);
#line 804 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7858 "tracker-sparql-expression.c"
																																} else {
#line 804 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 804 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_clear_error (&_inner_error_);
#line 804 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7866 "tracker-sparql-expression.c"
																																}
																															}
#line 805 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp348_ = sql;
#line 805 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															g_string_append (_tmp348_, ")");
#line 807 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															result = TRACKER_PROPERTY_TYPE_STRING;
#line 807 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															return result;
#line 7877 "tracker-sparql-expression.c"
																														} else {
																															const gchar* _tmp349_;
																															TrackerProperty* _tmp350_ = NULL;
																															TrackerProperty* _tmp351_;
																															TrackerProperty* prop;
																															TrackerProperty* _tmp352_;
																															GString* _tmp354_;
																															GString* expr;
																															GString* _tmp355_;
																															gchar* _tmp356_;
																															gchar* value_separator;
																															gchar* graph_separator;
																															gboolean _tmp357_ = FALSE;
																															gboolean _tmp358_;
																															TrackerProperty* _tmp365_;
																															gboolean _tmp366_;
																															gboolean _tmp367_;
#line 810 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp349_ = uri;
#line 810 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp350_ = tracker_ontologies_get_property_by_uri (_tmp349_);
#line 810 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp351_ = _g_object_ref0 (_tmp350_);
#line 810 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															prop = _tmp351_;
#line 811 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp352_ = prop;
#line 811 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_tmp352_ == NULL) {
#line 7907 "tracker-sparql-expression.c"
																																GError* _tmp353_ = NULL;
#line 812 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp353_ = tracker_sparql_expression_get_error (self, "Unknown function");
#line 812 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_inner_error_ = _tmp353_;
#line 812 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 812 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_propagate_error (error, _inner_error_);
#line 812 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_object_unref0 (prop);
#line 812 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7921 "tracker-sparql-expression.c"
																																} else {
#line 812 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_object_unref0 (prop);
#line 812 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 812 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_clear_error (&_inner_error_);
#line 812 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7931 "tracker-sparql-expression.c"
																																}
																															}
#line 815 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp354_ = g_string_new ("");
#line 815 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															expr = _tmp354_;
#line 816 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp355_ = expr;
#line 816 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															tracker_sparql_expression_translate_expression (self, _tmp355_, &_inner_error_);
#line 816 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_ != NULL) {
#line 816 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 816 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_propagate_error (error, _inner_error_);
#line 816 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_string_free0 (expr);
#line 816 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_object_unref0 (prop);
#line 816 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7954 "tracker-sparql-expression.c"
																																} else {
#line 816 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_string_free0 (expr);
#line 816 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_object_unref0 (prop);
#line 816 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 816 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_clear_error (&_inner_error_);
#line 816 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7966 "tracker-sparql-expression.c"
																																}
																															}
#line 818 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp356_ = g_strdup (",");
#line 818 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															value_separator = _tmp356_;
#line 819 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															graph_separator = NULL;
#line 821 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp357_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 821 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp358_ = _tmp357_;
#line 821 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_inner_error_ != NULL) {
#line 821 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 821 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_propagate_error (error, _inner_error_);
#line 821 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (graph_separator);
#line 821 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (value_separator);
#line 821 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_string_free0 (expr);
#line 821 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_object_unref0 (prop);
#line 821 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 7995 "tracker-sparql-expression.c"
																																} else {
#line 821 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (graph_separator);
#line 821 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (value_separator);
#line 821 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_string_free0 (expr);
#line 821 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_object_unref0 (prop);
#line 821 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 821 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_clear_error (&_inner_error_);
#line 821 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return 0;
#line 8011 "tracker-sparql-expression.c"
																																}
																															}
#line 821 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_tmp358_) {
#line 8016 "tracker-sparql-expression.c"
																																gchar* _tmp359_ = NULL;
																																gchar* _tmp360_;
																																gboolean _tmp361_ = FALSE;
																																gboolean _tmp362_;
#line 822 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp359_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 822 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp360_ = _tmp359_;
#line 822 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_inner_error_ != NULL) {
#line 822 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 822 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_propagate_error (error, _inner_error_);
#line 822 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_free0 (graph_separator);
#line 822 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_free0 (value_separator);
#line 822 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_string_free0 (expr);
#line 822 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_object_unref0 (prop);
#line 822 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		return 0;
#line 8041 "tracker-sparql-expression.c"
																																	} else {
#line 822 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_free0 (graph_separator);
#line 822 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_free0 (value_separator);
#line 822 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_string_free0 (expr);
#line 822 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_object_unref0 (prop);
#line 822 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 822 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_clear_error (&_inner_error_);
#line 822 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		return 0;
#line 8057 "tracker-sparql-expression.c"
																																	}
																																}
#line 822 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (value_separator);
#line 822 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																value_separator = _tmp360_;
#line 824 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp361_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 824 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp362_ = _tmp361_;
#line 824 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_inner_error_ != NULL) {
#line 824 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 824 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_propagate_error (error, _inner_error_);
#line 824 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_free0 (graph_separator);
#line 824 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_free0 (value_separator);
#line 824 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_string_free0 (expr);
#line 824 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_object_unref0 (prop);
#line 824 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		return 0;
#line 8084 "tracker-sparql-expression.c"
																																	} else {
#line 824 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_free0 (graph_separator);
#line 824 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_free0 (value_separator);
#line 824 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_string_free0 (expr);
#line 824 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_g_object_unref0 (prop);
#line 824 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 824 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		g_clear_error (&_inner_error_);
#line 824 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		return 0;
#line 8100 "tracker-sparql-expression.c"
																																	}
																																}
#line 824 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_tmp362_) {
#line 8105 "tracker-sparql-expression.c"
																																	gchar* _tmp363_ = NULL;
																																	gchar* _tmp364_;
#line 825 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp363_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 825 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp364_ = _tmp363_;
#line 825 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	if (_inner_error_ != NULL) {
#line 825 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 825 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_propagate_error (error, _inner_error_);
#line 825 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_free0 (graph_separator);
#line 825 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_free0 (value_separator);
#line 825 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_string_free0 (expr);
#line 825 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_object_unref0 (prop);
#line 825 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			return 0;
#line 8128 "tracker-sparql-expression.c"
																																		} else {
#line 825 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_free0 (graph_separator);
#line 825 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_free0 (value_separator);
#line 825 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_string_free0 (expr);
#line 825 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			_g_object_unref0 (prop);
#line 825 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 825 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			g_clear_error (&_inner_error_);
#line 825 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																			return 0;
#line 8144 "tracker-sparql-expression.c"
																																		}
																																	}
#line 825 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (graph_separator);
#line 825 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	graph_separator = _tmp364_;
#line 8151 "tracker-sparql-expression.c"
																																}
																															}
#line 829 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp365_ = prop;
#line 829 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp366_ = tracker_property_get_multiple_values (_tmp365_);
#line 829 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_tmp367_ = _tmp366_;
#line 829 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															if (_tmp367_) {
#line 8162 "tracker-sparql-expression.c"
																																GString* _tmp368_;
																																GString* _tmp369_;
																																gssize _tmp370_;
																																glong begin;
																																GString* _tmp371_;
																																TrackerProperty* _tmp372_;
																																const gchar* _tmp373_;
																																const gchar* _tmp374_;
																																GString* _tmp375_;
																																TrackerProperty* _tmp376_;
																																TrackerPropertyType _tmp377_;
																																TrackerPropertyType _tmp378_;
																																glong _tmp379_;
																																const gchar* _tmp380_;
																																GString* _tmp388_;
																																const gchar* _tmp389_;
																																gchar* _tmp390_ = NULL;
																																gchar* _tmp391_;
																																GString* _tmp392_;
																																TrackerProperty* _tmp393_;
																																const gchar* _tmp394_;
																																const gchar* _tmp395_;
																																GString* _tmp396_;
																																const gchar* _tmp397_;
#line 831 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp368_ = sql;
#line 831 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_string_append (_tmp368_, "(SELECT GROUP_CONCAT(");
#line 832 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp369_ = sql;
#line 832 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp370_ = _tmp369_->len;
#line 832 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																begin = (glong) _tmp370_;
#line 833 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp371_ = sql;
#line 833 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp372_ = prop;
#line 833 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp373_ = tracker_property_get_name (_tmp372_);
#line 833 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp374_ = _tmp373_;
#line 833 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_string_append_printf (_tmp371_, "\"%s\"", _tmp374_);
#line 834 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp375_ = sql;
#line 834 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp376_ = prop;
#line 834 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp377_ = tracker_property_get_data_type (_tmp376_);
#line 834 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp378_ = _tmp377_;
#line 834 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp379_ = begin;
#line 834 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																tracker_sparql_expression_convert_expression_to_string (_tmp375_, _tmp378_, _tmp379_);
#line 835 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp380_ = graph_separator;
#line 835 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_tmp380_ != NULL) {
#line 8223 "tracker-sparql-expression.c"
																																	GString* _tmp381_;
																																	const gchar* _tmp382_;
																																	gchar* _tmp383_ = NULL;
																																	gchar* _tmp384_;
																																	TrackerProperty* _tmp385_;
																																	const gchar* _tmp386_;
																																	const gchar* _tmp387_;
#line 836 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp381_ = sql;
#line 836 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp382_ = graph_separator;
#line 836 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp383_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp382_);
#line 836 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp384_ = _tmp383_;
#line 836 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp385_ = prop;
#line 836 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp386_ = tracker_property_get_name (_tmp385_);
#line 836 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp387_ = _tmp386_;
#line 836 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_string_append_printf (_tmp381_, " || %s || COALESCE((SELECT Uri FROM Resource WHERE ID = \"%s:graph\")," \
" '')", _tmp384_, _tmp387_);
#line 836 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (_tmp384_);
#line 8249 "tracker-sparql-expression.c"
																																}
#line 838 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp388_ = sql;
#line 838 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp389_ = value_separator;
#line 838 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp390_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp389_);
#line 838 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp391_ = _tmp390_;
#line 838 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_string_append_printf (_tmp388_, ",%s)", _tmp391_);
#line 838 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (_tmp391_);
#line 839 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp392_ = sql;
#line 839 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp393_ = prop;
#line 839 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp394_ = tracker_property_get_table_name (_tmp393_);
#line 839 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp395_ = _tmp394_;
#line 839 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp396_ = expr;
#line 839 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp397_ = _tmp396_->str;
#line 839 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																g_string_append_printf (_tmp392_, " FROM \"%s\" WHERE ID = %s)", _tmp395_, _tmp397_);
#line 841 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																result = TRACKER_PROPERTY_TYPE_STRING;
#line 841 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (graph_separator);
#line 841 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_free0 (value_separator);
#line 841 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_string_free0 (expr);
#line 841 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_g_object_unref0 (prop);
#line 841 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																return result;
#line 8289 "tracker-sparql-expression.c"
																															} else {
																																const gchar* _tmp398_;
#line 844 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																_tmp398_ = graph_separator;
#line 844 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																if (_tmp398_ == NULL) {
#line 8296 "tracker-sparql-expression.c"
																																	GString* _tmp399_;
																																	TrackerProperty* _tmp400_;
																																	const gchar* _tmp401_;
																																	const gchar* _tmp402_;
																																	TrackerProperty* _tmp403_;
																																	const gchar* _tmp404_;
																																	const gchar* _tmp405_;
																																	GString* _tmp406_;
																																	const gchar* _tmp407_;
																																	TrackerProperty* _tmp408_;
																																	TrackerPropertyType _tmp409_;
																																	TrackerPropertyType _tmp410_;
																																	TrackerProperty* _tmp412_;
																																	TrackerPropertyType _tmp413_;
																																	TrackerPropertyType _tmp414_;
#line 845 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp399_ = sql;
#line 845 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp400_ = prop;
#line 845 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp401_ = tracker_property_get_name (_tmp400_);
#line 845 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp402_ = _tmp401_;
#line 845 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp403_ = prop;
#line 845 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp404_ = tracker_property_get_table_name (_tmp403_);
#line 845 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp405_ = _tmp404_;
#line 845 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp406_ = expr;
#line 845 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp407_ = _tmp406_->str;
#line 845 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_string_append_printf (_tmp399_, "(SELECT \"%s\" FROM \"%s\" WHERE ID = %s)", _tmp402_, _tmp405_, _tmp407_);
#line 847 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp408_ = prop;
#line 847 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp409_ = tracker_property_get_data_type (_tmp408_);
#line 847 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp410_ = _tmp409_;
#line 847 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	if (_tmp410_ == TRACKER_PROPERTY_TYPE_STRING) {
#line 8340 "tracker-sparql-expression.c"
																																		GString* _tmp411_;
#line 848 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		_tmp411_ = sql;
#line 848 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																		tracker_sparql_expression_append_collate (self, _tmp411_);
#line 8346 "tracker-sparql-expression.c"
																																	}
#line 851 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp412_ = prop;
#line 851 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp413_ = tracker_property_get_data_type (_tmp412_);
#line 851 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp414_ = _tmp413_;
#line 851 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	result = _tmp414_;
#line 851 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (graph_separator);
#line 851 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (value_separator);
#line 851 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_string_free0 (expr);
#line 851 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_object_unref0 (prop);
#line 851 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return result;
#line 8366 "tracker-sparql-expression.c"
																																} else {
																																	GString* _tmp415_;
																																	GString* _tmp416_;
																																	gssize _tmp417_;
																																	glong begin;
																																	GString* _tmp418_;
																																	TrackerProperty* _tmp419_;
																																	const gchar* _tmp420_;
																																	const gchar* _tmp421_;
																																	GString* _tmp422_;
																																	TrackerProperty* _tmp423_;
																																	TrackerPropertyType _tmp424_;
																																	TrackerPropertyType _tmp425_;
																																	glong _tmp426_;
																																	GString* _tmp427_;
																																	const gchar* _tmp428_;
																																	gchar* _tmp429_ = NULL;
																																	gchar* _tmp430_;
																																	TrackerProperty* _tmp431_;
																																	const gchar* _tmp432_;
																																	const gchar* _tmp433_;
																																	GString* _tmp434_;
																																	TrackerProperty* _tmp435_;
																																	const gchar* _tmp436_;
																																	const gchar* _tmp437_;
																																	GString* _tmp438_;
																																	const gchar* _tmp439_;
#line 853 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp415_ = sql;
#line 853 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_string_append (_tmp415_, "(SELECT ");
#line 854 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp416_ = sql;
#line 854 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp417_ = _tmp416_->len;
#line 854 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	begin = (glong) _tmp417_;
#line 855 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp418_ = sql;
#line 855 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp419_ = prop;
#line 855 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp420_ = tracker_property_get_name (_tmp419_);
#line 855 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp421_ = _tmp420_;
#line 855 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_string_append_printf (_tmp418_, "\"%s\"", _tmp421_);
#line 856 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp422_ = sql;
#line 856 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp423_ = prop;
#line 856 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp424_ = tracker_property_get_data_type (_tmp423_);
#line 856 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp425_ = _tmp424_;
#line 856 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp426_ = begin;
#line 856 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	tracker_sparql_expression_convert_expression_to_string (_tmp422_, _tmp425_, _tmp426_);
#line 857 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp427_ = sql;
#line 857 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp428_ = graph_separator;
#line 857 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp429_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp428_);
#line 857 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp430_ = _tmp429_;
#line 857 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp431_ = prop;
#line 857 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp432_ = tracker_property_get_name (_tmp431_);
#line 857 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp433_ = _tmp432_;
#line 857 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_string_append_printf (_tmp427_, " || %s || COALESCE((SELECT Uri FROM Resource WHERE ID = \"%s:graph\")," \
" '')", _tmp430_, _tmp433_);
#line 857 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (_tmp430_);
#line 858 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp434_ = sql;
#line 858 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp435_ = prop;
#line 858 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp436_ = tracker_property_get_table_name (_tmp435_);
#line 858 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp437_ = _tmp436_;
#line 858 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp438_ = expr;
#line 858 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_tmp439_ = _tmp438_->str;
#line 858 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	g_string_append_printf (_tmp434_, " FROM \"%s\" WHERE ID = %s)", _tmp437_, _tmp439_);
#line 860 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	result = TRACKER_PROPERTY_TYPE_STRING;
#line 860 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (graph_separator);
#line 860 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_free0 (value_separator);
#line 860 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_string_free0 (expr);
#line 860 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	_g_object_unref0 (prop);
#line 860 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																																	return result;
#line 8470 "tracker-sparql-expression.c"
																																}
																															}
#line 802 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_g_free0 (graph_separator);
#line 802 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_g_free0 (value_separator);
#line 802 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_g_string_free0 (expr);
#line 802 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
																															_g_object_unref0 (prop);
#line 8481 "tracker-sparql-expression.c"
																														}
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static TrackerPropertyType tracker_sparql_expression_parse_type_uri (TrackerSparqlExpression* self, GError** error) {
	TrackerPropertyType result = 0;
	gchar* type_iri = NULL;
	TrackerPropertyType type = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	const gchar* _tmp23_;
	GError * _inner_error_ = NULL;
#line 866 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 870 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 870 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 870 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 870 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 870 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 870 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (type_iri);
#line 870 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 8539 "tracker-sparql-expression.c"
		} else {
#line 870 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (type_iri);
#line 870 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 870 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 870 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 8549 "tracker-sparql-expression.c"
		}
	}
#line 870 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 8554 "tracker-sparql-expression.c"
		gchar* _tmp2_ = NULL;
#line 871 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = tracker_sparql_expression_get_last_string (self, 1);
#line 871 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (type_iri);
#line 871 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		type_iri = _tmp2_;
#line 8562 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
#line 872 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 872 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = _tmp3_;
#line 872 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 872 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 872 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 872 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (type_iri);
#line 872 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 8580 "tracker-sparql-expression.c"
			} else {
#line 872 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (type_iri);
#line 872 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 872 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 872 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 8590 "tracker-sparql-expression.c"
			}
		}
#line 872 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp4_) {
#line 8595 "tracker-sparql-expression.c"
			gchar* _tmp5_ = NULL;
			gchar* ns;
			TrackerSparqlQuery* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			gchar* _tmp14_;
#line 873 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = tracker_sparql_expression_get_last_string (self, 0);
#line 873 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			ns = _tmp5_;
#line 874 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 874 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 874 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 874 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 874 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 874 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 874 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8625 "tracker-sparql-expression.c"
				} else {
#line 874 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 874 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 874 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 874 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 874 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8637 "tracker-sparql-expression.c"
				}
			}
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = self->priv->query;
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = ns;
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = tracker_sparql_expression_get_last_string (self, 0);
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = _tmp8_;
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = string_substring (_tmp9_, (glong) 1, (glong) (-1));
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = _tmp10_;
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = tracker_sparql_query_resolve_prefixed_name (_tmp6_, _tmp7_, _tmp11_, &_inner_error_);
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = _tmp12_;
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp11_);
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp9_);
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = _tmp13_;
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8674 "tracker-sparql-expression.c"
				} else {
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8686 "tracker-sparql-expression.c"
				}
			}
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (type_iri);
#line 875 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type_iri = _tmp14_;
#line 872 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (ns);
#line 8695 "tracker-sparql-expression.c"
		} else {
			TrackerSparqlQuery* _tmp15_;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_;
			gchar* _tmp22_;
#line 877 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 877 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 877 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 877 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 877 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 877 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8717 "tracker-sparql-expression.c"
				} else {
#line 877 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 877 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 877 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 877 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8727 "tracker-sparql-expression.c"
				}
			}
#line 878 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = self->priv->query;
#line 878 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = tracker_sparql_expression_get_last_string (self, 0);
#line 878 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = _tmp16_;
#line 878 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = string_substring (_tmp17_, (glong) 1, (glong) (-1));
#line 878 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = _tmp18_;
#line 878 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = tracker_sparql_query_resolve_prefixed_name (_tmp15_, "", _tmp19_, &_inner_error_);
#line 878 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp21_ = _tmp20_;
#line 878 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp19_);
#line 878 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp17_);
#line 878 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp22_ = _tmp21_;
#line 878 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 878 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 878 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 878 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 878 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8760 "tracker-sparql-expression.c"
				} else {
#line 878 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (type_iri);
#line 878 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 878 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 878 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 8770 "tracker-sparql-expression.c"
				}
			}
#line 878 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (type_iri);
#line 878 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type_iri = _tmp22_;
#line 8777 "tracker-sparql-expression.c"
		}
	}
#line 881 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp23_ = type_iri;
#line 881 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (g_strcmp0 (_tmp23_, TRACKER_SPARQL_EXPRESSION_XSD_NS "boolean") == 0) {
#line 882 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		type = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 8786 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		const gchar* _tmp36_;
		gboolean _tmp38_;
		gboolean _tmp40_;
		gboolean _tmp42_;
		gboolean _tmp44_;
		gboolean _tmp46_;
		gboolean _tmp48_;
		gboolean _tmp50_;
		gboolean _tmp52_;
		gboolean _tmp54_;
		gboolean _tmp56_;
		gboolean _tmp58_;
		gboolean _tmp60_;
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp36_ = type_iri;
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (g_strcmp0 (_tmp36_, TRACKER_SPARQL_EXPRESSION_XSD_NS "integer") == 0) {
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp35_ = TRUE;
#line 8819 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp37_;
#line 884 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp37_ = type_iri;
#line 884 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp35_ = g_strcmp0 (_tmp37_, TRACKER_SPARQL_EXPRESSION_XSD_NS "nonPositiveInteger") == 0;
#line 8826 "tracker-sparql-expression.c"
		}
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp38_ = _tmp35_;
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp38_) {
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp34_ = TRUE;
#line 8834 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp39_;
#line 885 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp39_ = type_iri;
#line 885 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp34_ = g_strcmp0 (_tmp39_, TRACKER_SPARQL_EXPRESSION_XSD_NS "negativeInteger") == 0;
#line 8841 "tracker-sparql-expression.c"
		}
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp40_ = _tmp34_;
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp40_) {
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp33_ = TRUE;
#line 8849 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp41_;
#line 886 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp41_ = type_iri;
#line 886 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp33_ = g_strcmp0 (_tmp41_, TRACKER_SPARQL_EXPRESSION_XSD_NS "long") == 0;
#line 8856 "tracker-sparql-expression.c"
		}
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp42_ = _tmp33_;
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp42_) {
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp32_ = TRUE;
#line 8864 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp43_;
#line 887 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp43_ = type_iri;
#line 887 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp32_ = g_strcmp0 (_tmp43_, TRACKER_SPARQL_EXPRESSION_XSD_NS "int") == 0;
#line 8871 "tracker-sparql-expression.c"
		}
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp44_ = _tmp32_;
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp44_) {
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp31_ = TRUE;
#line 8879 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp45_;
#line 888 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp45_ = type_iri;
#line 888 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp31_ = g_strcmp0 (_tmp45_, TRACKER_SPARQL_EXPRESSION_XSD_NS "short") == 0;
#line 8886 "tracker-sparql-expression.c"
		}
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp46_ = _tmp31_;
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp46_) {
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp30_ = TRUE;
#line 8894 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp47_;
#line 889 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp47_ = type_iri;
#line 889 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp30_ = g_strcmp0 (_tmp47_, TRACKER_SPARQL_EXPRESSION_XSD_NS "byte") == 0;
#line 8901 "tracker-sparql-expression.c"
		}
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp48_ = _tmp30_;
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp48_) {
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp29_ = TRUE;
#line 8909 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp49_;
#line 890 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp49_ = type_iri;
#line 890 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp29_ = g_strcmp0 (_tmp49_, TRACKER_SPARQL_EXPRESSION_XSD_NS "nonNegativeInteger") == 0;
#line 8916 "tracker-sparql-expression.c"
		}
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp50_ = _tmp29_;
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp50_) {
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp28_ = TRUE;
#line 8924 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp51_;
#line 891 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp51_ = type_iri;
#line 891 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp28_ = g_strcmp0 (_tmp51_, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedLong") == 0;
#line 8931 "tracker-sparql-expression.c"
		}
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp52_ = _tmp28_;
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp52_) {
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp27_ = TRUE;
#line 8939 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp53_;
#line 892 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp53_ = type_iri;
#line 892 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp27_ = g_strcmp0 (_tmp53_, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedInt") == 0;
#line 8946 "tracker-sparql-expression.c"
		}
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp54_ = _tmp27_;
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp54_) {
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp26_ = TRUE;
#line 8954 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp55_;
#line 893 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp55_ = type_iri;
#line 893 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp26_ = g_strcmp0 (_tmp55_, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedShort") == 0;
#line 8961 "tracker-sparql-expression.c"
		}
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp56_ = _tmp26_;
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp56_) {
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp25_ = TRUE;
#line 8969 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp57_;
#line 894 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp57_ = type_iri;
#line 894 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp25_ = g_strcmp0 (_tmp57_, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedByte") == 0;
#line 8976 "tracker-sparql-expression.c"
		}
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp58_ = _tmp25_;
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp58_) {
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = TRUE;
#line 8984 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp59_;
#line 895 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp59_ = type_iri;
#line 895 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = g_strcmp0 (_tmp59_, TRACKER_SPARQL_EXPRESSION_XSD_NS "positiveInteger") == 0;
#line 8991 "tracker-sparql-expression.c"
		}
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp60_ = _tmp24_;
#line 883 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp60_) {
#line 896 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 8999 "tracker-sparql-expression.c"
		} else {
			const gchar* _tmp61_;
#line 897 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp61_ = type_iri;
#line 897 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (g_strcmp0 (_tmp61_, TRACKER_SPARQL_EXPRESSION_XSD_NS "double") == 0) {
#line 898 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				type = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 9008 "tracker-sparql-expression.c"
			} else {
				const gchar* _tmp62_;
#line 899 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp62_ = type_iri;
#line 899 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (g_strcmp0 (_tmp62_, TRACKER_SPARQL_EXPRESSION_XSD_NS "date") == 0) {
#line 900 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					type = TRACKER_PROPERTY_TYPE_DATE;
#line 9017 "tracker-sparql-expression.c"
				} else {
					const gchar* _tmp63_;
#line 901 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp63_ = type_iri;
#line 901 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (g_strcmp0 (_tmp63_, TRACKER_SPARQL_EXPRESSION_XSD_NS "dateTime") == 0) {
#line 902 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						type = TRACKER_PROPERTY_TYPE_DATETIME;
#line 9026 "tracker-sparql-expression.c"
					} else {
#line 904 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						type = TRACKER_PROPERTY_TYPE_STRING;
#line 9030 "tracker-sparql-expression.c"
					}
				}
			}
		}
	}
#line 907 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = type;
#line 907 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_free0 (type_iri);
#line 907 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 9042 "tracker-sparql-expression.c"
}


gchar* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error) {
	TrackerPropertyType _vala_type = 0;
	gchar* result = NULL;
	TrackerSparqlTokenType _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 910 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 911 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_vala_type = TRACKER_PROPERTY_TYPE_STRING;
#line 913 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_next (self, &_inner_error_);
#line 913 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 913 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 913 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 913 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return NULL;
#line 9065 "tracker-sparql-expression.c"
		} else {
#line 913 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 913 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 913 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return NULL;
#line 9073 "tracker-sparql-expression.c"
		}
	}
#line 914 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_last (self);
#line 914 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (_tmp0_) {
#line 914 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
#line 914 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
#line 9084 "tracker-sparql-expression.c"
		{
			GString* _tmp1_;
			GString* sb;
			gchar* _tmp2_ = NULL;
			gchar* s;
			const gchar* _tmp3_;
			const gchar* p;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			const gchar* end;
			gboolean _tmp50_ = FALSE;
			gboolean _tmp51_;
			GString* _tmp54_;
			const gchar* _tmp55_;
			gchar* _tmp56_;
#line 917 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp1_ = g_string_new ("");
#line 917 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			sb = _tmp1_;
#line 919 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp2_ = tracker_sparql_expression_get_last_string (self, 1);
#line 919 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			s = _tmp2_;
#line 920 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = s;
#line 920 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			p = _tmp3_;
#line 921 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp4_ = p;
#line 921 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = s;
#line 921 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = strlen (_tmp5_);
#line 921 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = _tmp6_;
#line 921 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			end = _tmp4_ + _tmp7_;
#line 922 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			while (TRUE) {
#line 9126 "tracker-sparql-expression.c"
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_ = NULL;
				const gchar* q;
				const gchar* _tmp12_;
#line 922 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp8_ = p;
#line 922 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp9_ = end;
#line 922 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (!(((glong) _tmp8_) < ((glong) _tmp9_))) {
#line 922 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					break;
#line 9141 "tracker-sparql-expression.c"
				}
#line 923 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp10_ = p;
#line 923 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp11_ = strchr (_tmp10_, (gint) '\\');
#line 923 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				q = _tmp11_;
#line 924 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp12_ = q;
#line 924 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_tmp12_ == NULL) {
#line 9153 "tracker-sparql-expression.c"
					GString* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
#line 925 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp13_ = sb;
#line 925 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp14_ = p;
#line 925 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp15_ = end;
#line 925 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp16_ = p;
#line 925 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_string_append_len (_tmp13_, _tmp14_, (gssize) ((glong) (_tmp15_ - _tmp16_)));
#line 926 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp17_ = end;
#line 926 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					p = _tmp17_;
#line 9173 "tracker-sparql-expression.c"
				} else {
					GString* _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					gchar _tmp24_;
					const gchar* _tmp49_;
#line 928 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp18_ = sb;
#line 928 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp19_ = p;
#line 928 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp20_ = q;
#line 928 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp21_ = p;
#line 928 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_string_append_len (_tmp18_, _tmp19_, (gssize) ((glong) (_tmp20_ - _tmp21_)));
#line 929 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp22_ = q;
#line 929 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					p = _tmp22_ + 1;
#line 930 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp23_ = p;
#line 930 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp24_ = ((gchar*) _tmp23_)[0];
#line 930 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					switch (_tmp24_) {
#line 930 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case '\'':
#line 930 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case '"':
#line 930 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case '\\':
#line 9209 "tracker-sparql-expression.c"
						{
							GString* _tmp25_;
							const gchar* _tmp26_;
							gchar _tmp27_;
#line 934 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp25_ = sb;
#line 934 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp26_ = p;
#line 934 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp27_ = ((gchar*) _tmp26_)[0];
#line 934 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp25_, _tmp27_);
#line 935 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 9224 "tracker-sparql-expression.c"
						}
#line 930 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 'b':
#line 9228 "tracker-sparql-expression.c"
						{
							GString* _tmp28_;
#line 937 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp28_ = sb;
#line 937 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp28_, '\b');
#line 938 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 9237 "tracker-sparql-expression.c"
						}
#line 930 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 'f':
#line 9241 "tracker-sparql-expression.c"
						{
							GString* _tmp29_;
#line 940 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp29_ = sb;
#line 940 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp29_, '\f');
#line 941 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 9250 "tracker-sparql-expression.c"
						}
#line 930 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 'n':
#line 9254 "tracker-sparql-expression.c"
						{
							GString* _tmp30_;
#line 943 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp30_ = sb;
#line 943 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp30_, '\n');
#line 944 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 9263 "tracker-sparql-expression.c"
						}
#line 930 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 'r':
#line 9267 "tracker-sparql-expression.c"
						{
							GString* _tmp31_;
#line 946 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp31_ = sb;
#line 946 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp31_, '\r');
#line 947 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 9276 "tracker-sparql-expression.c"
						}
#line 930 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 't':
#line 9280 "tracker-sparql-expression.c"
						{
							GString* _tmp32_;
#line 949 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp32_ = sb;
#line 949 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_c (_tmp32_, '\t');
#line 950 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 9289 "tracker-sparql-expression.c"
						}
#line 930 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						case 'u':
#line 9293 "tracker-sparql-expression.c"
						{
							const gchar* _tmp33_;
							gchar* ptr;
							gchar* _tmp34_;
							gchar _tmp35_;
							gint _tmp36_ = 0;
							gchar* _tmp37_;
							gchar _tmp38_;
							gint _tmp39_ = 0;
							gchar* _tmp40_;
							gchar _tmp41_;
							gint _tmp42_ = 0;
							gchar* _tmp43_;
							gchar _tmp44_;
							gint _tmp45_ = 0;
							gunichar c;
							GString* _tmp46_;
							gunichar _tmp47_;
							const gchar* _tmp48_;
#line 952 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp33_ = p;
#line 952 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							ptr = ((gchar*) _tmp33_) + 1;
#line 953 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp34_ = ptr;
#line 953 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp35_ = _tmp34_[0];
#line 953 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp36_ = g_ascii_xdigit_value (_tmp35_);
#line 953 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp37_ = ptr;
#line 953 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp38_ = _tmp37_[1];
#line 953 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp39_ = g_ascii_xdigit_value (_tmp38_);
#line 953 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp40_ = ptr;
#line 953 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp41_ = _tmp40_[2];
#line 953 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp42_ = g_ascii_xdigit_value (_tmp41_);
#line 953 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp43_ = ptr;
#line 953 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp44_ = _tmp43_[3];
#line 953 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp45_ = g_ascii_xdigit_value (_tmp44_);
#line 953 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							c = (((((((gunichar) _tmp36_) * 16) + _tmp39_) * 16) + _tmp42_) * 16) + _tmp45_;
#line 954 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp46_ = sb;
#line 954 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp47_ = c;
#line 954 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_string_append_unichar (_tmp46_, _tmp47_);
#line 955 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp48_ = p;
#line 955 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							p = _tmp48_ + 4;
#line 956 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							break;
#line 9355 "tracker-sparql-expression.c"
						}
						default:
#line 930 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						break;
#line 9360 "tracker-sparql-expression.c"
					}
#line 958 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp49_ = p;
#line 958 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					p = _tmp49_ + 1;
#line 9366 "tracker-sparql-expression.c"
				}
			}
#line 962 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp50_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
#line 962 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp51_ = _tmp50_;
#line 962 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 962 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 962 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 962 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (s);
#line 962 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_string_free0 (sb);
#line 962 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return NULL;
#line 9385 "tracker-sparql-expression.c"
				} else {
#line 962 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (s);
#line 962 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_string_free0 (sb);
#line 962 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 962 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 962 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return NULL;
#line 9397 "tracker-sparql-expression.c"
				}
			}
#line 962 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp51_) {
#line 9402 "tracker-sparql-expression.c"
				TrackerPropertyType _tmp52_ = 0;
				TrackerPropertyType _tmp53_;
#line 964 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp52_ = tracker_sparql_expression_parse_type_uri (self, &_inner_error_);
#line 964 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp53_ = _tmp52_;
#line 964 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 964 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 964 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 964 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (s);
#line 964 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_string_free0 (sb);
#line 964 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return NULL;
#line 9421 "tracker-sparql-expression.c"
					} else {
#line 964 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (s);
#line 964 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_string_free0 (sb);
#line 964 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 964 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 964 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return NULL;
#line 9433 "tracker-sparql-expression.c"
					}
				}
#line 964 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_vala_type = _tmp53_;
#line 9438 "tracker-sparql-expression.c"
			}
#line 967 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp54_ = sb;
#line 967 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp55_ = _tmp54_->str;
#line 967 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp56_ = g_strdup (_tmp55_);
#line 967 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp56_;
#line 967 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (s);
#line 967 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_string_free0 (sb);
#line 967 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (type) {
#line 967 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				*type = _vala_type;
#line 9456 "tracker-sparql-expression.c"
			}
#line 967 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9460 "tracker-sparql-expression.c"
		}
#line 914 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
#line 914 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
#line 9466 "tracker-sparql-expression.c"
		{
			gchar* _tmp57_ = NULL;
			gchar* _result_;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_;
#line 970 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp57_ = tracker_sparql_expression_get_last_string (self, 3);
#line 970 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_result_ = _tmp57_;
#line 972 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp58_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
#line 972 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp59_ = _tmp58_;
#line 972 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 972 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 972 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 972 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (_result_);
#line 972 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return NULL;
#line 9490 "tracker-sparql-expression.c"
				} else {
#line 972 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (_result_);
#line 972 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 972 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 972 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return NULL;
#line 9500 "tracker-sparql-expression.c"
				}
			}
#line 972 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp59_) {
#line 9505 "tracker-sparql-expression.c"
				TrackerPropertyType _tmp60_ = 0;
				TrackerPropertyType _tmp61_;
#line 974 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp60_ = tracker_sparql_expression_parse_type_uri (self, &_inner_error_);
#line 974 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp61_ = _tmp60_;
#line 974 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 974 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 974 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 974 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_result_);
#line 974 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return NULL;
#line 9522 "tracker-sparql-expression.c"
					} else {
#line 974 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_result_);
#line 974 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 974 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 974 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return NULL;
#line 9532 "tracker-sparql-expression.c"
					}
				}
#line 974 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_vala_type = _tmp61_;
#line 9537 "tracker-sparql-expression.c"
			}
#line 977 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _result_;
#line 977 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (type) {
#line 977 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				*type = _vala_type;
#line 9545 "tracker-sparql-expression.c"
			}
#line 977 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9549 "tracker-sparql-expression.c"
		}
		default:
		{
			GError* _tmp62_ = NULL;
#line 979 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp62_ = tracker_sparql_expression_get_error (self, "expected string literal");
#line 979 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp62_;
#line 979 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 979 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 979 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return NULL;
#line 9564 "tracker-sparql-expression.c"
			} else {
#line 979 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 979 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 979 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return NULL;
#line 9572 "tracker-sparql-expression.c"
			}
		}
	}
#line 910 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (type) {
#line 910 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		*type = _vala_type;
#line 9580 "tracker-sparql-expression.c"
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_uri_expression (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error) {
	TrackerPropertyType result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
#line 983 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 983 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 983 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (uri != NULL, 0);
#line 984 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 984 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 984 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 984 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 984 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 984 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 9608 "tracker-sparql-expression.c"
		} else {
#line 984 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 984 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 984 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 9616 "tracker-sparql-expression.c"
		}
	}
#line 984 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 9621 "tracker-sparql-expression.c"
		GString* _tmp2_;
		const gchar* _tmp3_;
		TrackerPropertyType _tmp4_ = 0;
		TrackerPropertyType _result_;
#line 986 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = sql;
#line 986 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = uri;
#line 986 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_translate_function (self, _tmp2_, _tmp3_, &_inner_error_);
#line 986 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_result_ = _tmp4_;
#line 986 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 986 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 986 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 986 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 9642 "tracker-sparql-expression.c"
			} else {
#line 986 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 986 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 986 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 9650 "tracker-sparql-expression.c"
			}
		}
#line 987 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 987 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 987 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 987 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 987 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 9663 "tracker-sparql-expression.c"
			} else {
#line 987 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 987 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 987 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 9671 "tracker-sparql-expression.c"
			}
		}
#line 988 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = _result_;
#line 988 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 9678 "tracker-sparql-expression.c"
	} else {
		GString* _tmp5_;
		TrackerSparqlLiteralBinding* _tmp6_;
		TrackerSparqlLiteralBinding* binding;
		TrackerSparqlLiteralBinding* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		TrackerSparqlQuery* _tmp10_;
		TrackerSparqlLiteralBinding* _tmp11_;
		TrackerSparqlLiteralBinding* _tmp12_;
#line 991 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = sql;
#line 991 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp5_, "COALESCE((SELECT ID FROM Resource WHERE Uri = ?), 0)");
#line 992 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = tracker_sparql_literal_binding_new ();
#line 992 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		binding = _tmp6_;
#line 993 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = binding;
#line 993 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = uri;
#line 993 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 993 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_free0 (_tmp7_->literal);
#line 993 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_->literal = _tmp9_;
#line 994 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = self->priv->query;
#line 994 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = binding;
#line 994 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = _g_object_ref0 (_tmp11_);
#line 994 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_->bindings = g_list_append (_tmp10_->bindings, _tmp12_);
#line 995 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 995 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_g_object_unref0 (binding);
#line 995 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 9721 "tracker-sparql-expression.c"
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_primary_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerPropertyType type = 0;
	TrackerSparqlTokenType _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 999 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 999 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_current (self);
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (_tmp0_) {
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
#line 9741 "tracker-sparql-expression.c"
		{
			GString* _tmp1_;
			TrackerPropertyType _tmp2_ = 0;
			TrackerPropertyType _tmp3_;
#line 1004 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp1_ = sql;
#line 1004 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp2_ = tracker_sparql_expression_translate_bracketted_expression (self, _tmp1_, &_inner_error_);
#line 1004 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = _tmp2_;
#line 1004 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1004 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1004 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1004 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9760 "tracker-sparql-expression.c"
				} else {
#line 1004 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1004 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1004 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9768 "tracker-sparql-expression.c"
				}
			}
#line 1004 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp3_;
#line 1004 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9775 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
#line 9779 "tracker-sparql-expression.c"
		{
			GString* _tmp4_;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			TrackerPropertyType _tmp7_ = 0;
			TrackerPropertyType _tmp8_;
			TrackerPropertyType _tmp9_;
#line 1006 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1006 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1006 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1006 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1006 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9797 "tracker-sparql-expression.c"
				} else {
#line 1006 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1006 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1006 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9805 "tracker-sparql-expression.c"
				}
			}
#line 1007 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp4_ = sql;
#line 1007 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = tracker_sparql_expression_get_last_string (self, 1);
#line 1007 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = _tmp5_;
#line 1007 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_translate_uri_expression (self, _tmp4_, _tmp6_, &_inner_error_);
#line 1007 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = _tmp7_;
#line 1007 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp6_);
#line 1007 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = _tmp8_;
#line 1007 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1007 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1007 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1007 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9830 "tracker-sparql-expression.c"
				} else {
#line 1007 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1007 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1007 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9838 "tracker-sparql-expression.c"
				}
			}
#line 1007 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp9_;
#line 1007 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9845 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DECIMAL:
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DOUBLE:
#line 9851 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
#line 1010 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1010 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1010 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1010 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1010 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9866 "tracker-sparql-expression.c"
				} else {
#line 1010 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1010 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1010 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9874 "tracker-sparql-expression.c"
				}
			}
#line 1012 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = self->priv->query;
#line 1012 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = tracker_sparql_query_get_no_cache (_tmp10_);
#line 1012 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = _tmp11_;
#line 1012 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp12_) {
#line 9885 "tracker-sparql-expression.c"
				GString* _tmp13_;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
#line 1013 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp13_ = sql;
#line 1013 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp14_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1013 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp15_ = _tmp14_;
#line 1013 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp13_, _tmp15_);
#line 1013 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp15_);
#line 9899 "tracker-sparql-expression.c"
			} else {
				GString* _tmp16_;
				TrackerSparqlLiteralBinding* _tmp17_;
				TrackerSparqlLiteralBinding* binding;
				TrackerSparqlLiteralBinding* _tmp18_;
				gchar* _tmp19_ = NULL;
				TrackerSparqlQuery* _tmp20_;
				TrackerSparqlLiteralBinding* _tmp21_;
				TrackerSparqlLiteralBinding* _tmp22_;
#line 1015 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp16_ = sql;
#line 1015 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp16_, "?");
#line 1017 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp17_ = tracker_sparql_literal_binding_new ();
#line 1017 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				binding = _tmp17_;
#line 1018 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp18_ = binding;
#line 1018 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp19_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1018 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp18_->literal);
#line 1018 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp18_->literal = _tmp19_;
#line 1019 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_ = self->priv->query;
#line 1019 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp21_ = binding;
#line 1019 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp22_ = _g_object_ref0 (_tmp21_);
#line 1019 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_->bindings = g_list_append (_tmp20_->bindings, _tmp22_);
#line 1012 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (binding);
#line 9935 "tracker-sparql-expression.c"
			}
#line 1022 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_DOUBLE;
#line 1022 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 9941 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_TRUE:
#line 9945 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp23_;
			gboolean _tmp24_;
			gboolean _tmp25_;
#line 1024 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1024 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1024 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1024 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1024 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9960 "tracker-sparql-expression.c"
				} else {
#line 1024 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1024 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1024 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 9968 "tracker-sparql-expression.c"
				}
			}
#line 1026 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp23_ = self->priv->query;
#line 1026 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = tracker_sparql_query_get_no_cache (_tmp23_);
#line 1026 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp25_ = _tmp24_;
#line 1026 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp25_) {
#line 9979 "tracker-sparql-expression.c"
				GString* _tmp26_;
#line 1027 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp26_ = sql;
#line 1027 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp26_, "1");
#line 9985 "tracker-sparql-expression.c"
			} else {
				GString* _tmp27_;
				TrackerSparqlLiteralBinding* _tmp28_;
				TrackerSparqlLiteralBinding* binding;
				TrackerSparqlLiteralBinding* _tmp29_;
				gchar* _tmp30_;
				TrackerSparqlLiteralBinding* _tmp31_;
				TrackerSparqlQuery* _tmp32_;
				TrackerSparqlLiteralBinding* _tmp33_;
				TrackerSparqlLiteralBinding* _tmp34_;
#line 1029 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = sql;
#line 1029 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp27_, "?");
#line 1031 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp28_ = tracker_sparql_literal_binding_new ();
#line 1031 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				binding = _tmp28_;
#line 1032 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp29_ = binding;
#line 1032 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp30_ = g_strdup ("1");
#line 1032 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp29_->literal);
#line 1032 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp29_->literal = _tmp30_;
#line 1033 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp31_ = binding;
#line 1033 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				((TrackerSparqlDataBinding*) _tmp31_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 1034 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp32_ = self->priv->query;
#line 1034 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp33_ = binding;
#line 1034 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp34_ = _g_object_ref0 (_tmp33_);
#line 1034 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp32_->bindings = g_list_append (_tmp32_->bindings, _tmp34_);
#line 1026 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (binding);
#line 10026 "tracker-sparql-expression.c"
			}
#line 1037 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1037 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10032 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FALSE:
#line 10036 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp35_;
			gboolean _tmp36_;
			gboolean _tmp37_;
#line 1039 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1039 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1039 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1039 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1039 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10051 "tracker-sparql-expression.c"
				} else {
#line 1039 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1039 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1039 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10059 "tracker-sparql-expression.c"
				}
			}
#line 1041 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp35_ = self->priv->query;
#line 1041 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp36_ = tracker_sparql_query_get_no_cache (_tmp35_);
#line 1041 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp37_ = _tmp36_;
#line 1041 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp37_) {
#line 10070 "tracker-sparql-expression.c"
				GString* _tmp38_;
#line 1042 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp38_ = sql;
#line 1042 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp38_, "0");
#line 10076 "tracker-sparql-expression.c"
			} else {
				GString* _tmp39_;
				TrackerSparqlLiteralBinding* _tmp40_;
				TrackerSparqlLiteralBinding* binding;
				TrackerSparqlLiteralBinding* _tmp41_;
				gchar* _tmp42_;
				TrackerSparqlLiteralBinding* _tmp43_;
				TrackerSparqlQuery* _tmp44_;
				TrackerSparqlLiteralBinding* _tmp45_;
				TrackerSparqlLiteralBinding* _tmp46_;
#line 1044 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp39_ = sql;
#line 1044 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp39_, "?");
#line 1046 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp40_ = tracker_sparql_literal_binding_new ();
#line 1046 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				binding = _tmp40_;
#line 1047 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp41_ = binding;
#line 1047 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp42_ = g_strdup ("0");
#line 1047 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp41_->literal);
#line 1047 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp41_->literal = _tmp42_;
#line 1048 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp43_ = binding;
#line 1048 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				((TrackerSparqlDataBinding*) _tmp43_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 1049 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp44_ = self->priv->query;
#line 1049 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp45_ = binding;
#line 1049 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp46_ = _g_object_ref0 (_tmp45_);
#line 1049 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp44_->bindings = g_list_append (_tmp44_->bindings, _tmp46_);
#line 1041 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (binding);
#line 10117 "tracker-sparql-expression.c"
			}
#line 1052 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1052 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10123 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
#line 10133 "tracker-sparql-expression.c"
		{
			TrackerPropertyType _tmp47_ = 0;
			gchar* _tmp48_ = NULL;
			gchar* literal;
			TrackerPropertyType _tmp49_;
#line 1057 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp48_ = tracker_sparql_expression_parse_string_literal (self, &_tmp47_, &_inner_error_);
#line 1057 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp47_;
#line 1057 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			literal = _tmp48_;
#line 1057 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1057 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1057 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1057 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10153 "tracker-sparql-expression.c"
				} else {
#line 1057 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1057 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1057 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10161 "tracker-sparql-expression.c"
				}
			}
#line 1059 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp49_ = type;
#line 1059 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			switch (_tmp49_) {
#line 1059 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_INTEGER:
#line 1059 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_BOOLEAN:
#line 1059 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_DOUBLE:
#line 1059 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_DATE:
#line 1059 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				case TRACKER_PROPERTY_TYPE_DATETIME:
#line 10178 "tracker-sparql-expression.c"
				{
					TrackerSparqlQuery* _tmp50_;
					gboolean _tmp51_;
					gboolean _tmp52_;
#line 1065 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp50_ = self->priv->query;
#line 1065 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp51_ = tracker_sparql_query_get_no_cache (_tmp50_);
#line 1065 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp52_ = _tmp51_;
#line 1065 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_tmp52_) {
#line 10191 "tracker-sparql-expression.c"
						GString* _tmp53_;
						const gchar* _tmp54_;
						gchar* _tmp55_ = NULL;
						gchar* _tmp56_;
#line 1066 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp53_ = sql;
#line 1066 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp54_ = literal;
#line 1066 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp55_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp54_);
#line 1066 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp56_ = _tmp55_;
#line 1066 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp53_, _tmp56_);
#line 1066 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_tmp56_);
#line 10208 "tracker-sparql-expression.c"
					} else {
						TrackerSparqlLiteralBinding* _tmp57_;
						TrackerSparqlLiteralBinding* binding;
						TrackerSparqlLiteralBinding* _tmp58_;
						const gchar* _tmp59_;
						gchar* _tmp60_;
						TrackerSparqlLiteralBinding* _tmp61_;
						TrackerPropertyType _tmp62_;
						TrackerSparqlQuery* _tmp63_;
						TrackerSparqlLiteralBinding* _tmp64_;
						TrackerSparqlLiteralBinding* _tmp65_;
						GString* _tmp66_;
#line 1068 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp57_ = tracker_sparql_literal_binding_new ();
#line 1068 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						binding = _tmp57_;
#line 1069 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp58_ = binding;
#line 1069 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp59_ = literal;
#line 1069 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp60_ = g_strdup (_tmp59_);
#line 1069 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_tmp58_->literal);
#line 1069 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp58_->literal = _tmp60_;
#line 1070 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp61_ = binding;
#line 1070 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp62_ = type;
#line 1070 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						((TrackerSparqlDataBinding*) _tmp61_)->data_type = _tmp62_;
#line 1071 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp63_ = self->priv->query;
#line 1071 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp64_ = binding;
#line 1071 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp65_ = _g_object_ref0 (_tmp64_);
#line 1071 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp63_->bindings = g_list_append (_tmp63_->bindings, _tmp65_);
#line 1072 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp66_ = sql;
#line 1072 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp66_, "?");
#line 1065 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 10255 "tracker-sparql-expression.c"
					}
#line 1074 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					result = type;
#line 1074 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (literal);
#line 1074 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return result;
#line 10263 "tracker-sparql-expression.c"
				}
				default:
				{
					TrackerSparqlQuery* _tmp67_;
					gboolean _tmp68_;
					gboolean _tmp69_;
					GString* _tmp82_;
#line 1076 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp67_ = self->priv->query;
#line 1076 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp68_ = tracker_sparql_query_get_no_cache (_tmp67_);
#line 1076 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp69_ = _tmp68_;
#line 1076 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_tmp69_) {
#line 10279 "tracker-sparql-expression.c"
						GString* _tmp70_;
						const gchar* _tmp71_;
						gchar* _tmp72_ = NULL;
						gchar* _tmp73_;
#line 1077 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp70_ = sql;
#line 1077 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp71_ = literal;
#line 1077 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp72_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp71_);
#line 1077 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp73_ = _tmp72_;
#line 1077 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp70_, _tmp73_);
#line 1077 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_tmp73_);
#line 10296 "tracker-sparql-expression.c"
					} else {
						TrackerSparqlLiteralBinding* _tmp74_;
						TrackerSparqlLiteralBinding* binding;
						TrackerSparqlLiteralBinding* _tmp75_;
						const gchar* _tmp76_;
						gchar* _tmp77_;
						TrackerSparqlQuery* _tmp78_;
						TrackerSparqlLiteralBinding* _tmp79_;
						TrackerSparqlLiteralBinding* _tmp80_;
						GString* _tmp81_;
#line 1079 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp74_ = tracker_sparql_literal_binding_new ();
#line 1079 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						binding = _tmp74_;
#line 1080 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp75_ = binding;
#line 1080 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp76_ = literal;
#line 1080 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp77_ = g_strdup (_tmp76_);
#line 1080 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_free0 (_tmp75_->literal);
#line 1080 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp75_->literal = _tmp77_;
#line 1081 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp78_ = self->priv->query;
#line 1081 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp79_ = binding;
#line 1081 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp80_ = _g_object_ref0 (_tmp79_);
#line 1081 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp78_->bindings = g_list_append (_tmp78_->bindings, _tmp80_);
#line 1082 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp81_ = sql;
#line 1082 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_string_append (_tmp81_, "?");
#line 1076 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_g_object_unref0 (binding);
#line 10335 "tracker-sparql-expression.c"
					}
#line 1084 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp82_ = sql;
#line 1084 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					tracker_sparql_expression_append_collate (self, _tmp82_);
#line 1085 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					result = TRACKER_PROPERTY_TYPE_STRING;
#line 1085 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (literal);
#line 1085 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return result;
#line 10347 "tracker-sparql-expression.c"
				}
			}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (literal);
#line 10352 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_INTEGER:
#line 10356 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp83_;
			gboolean _tmp84_;
			gboolean _tmp85_;
#line 1088 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1088 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1088 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1088 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1088 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10371 "tracker-sparql-expression.c"
				} else {
#line 1088 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1088 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1088 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10379 "tracker-sparql-expression.c"
				}
			}
#line 1090 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp83_ = self->priv->query;
#line 1090 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp84_ = tracker_sparql_query_get_no_cache (_tmp83_);
#line 1090 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp85_ = _tmp84_;
#line 1090 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp85_) {
#line 10390 "tracker-sparql-expression.c"
				GString* _tmp86_;
				gchar* _tmp87_ = NULL;
				gchar* _tmp88_;
#line 1091 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp86_ = sql;
#line 1091 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp87_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1091 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp88_ = _tmp87_;
#line 1091 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp86_, _tmp88_);
#line 1091 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp88_);
#line 10404 "tracker-sparql-expression.c"
			} else {
				GString* _tmp89_;
				TrackerSparqlLiteralBinding* _tmp90_;
				TrackerSparqlLiteralBinding* binding;
				TrackerSparqlLiteralBinding* _tmp91_;
				gchar* _tmp92_ = NULL;
				TrackerSparqlLiteralBinding* _tmp93_;
				TrackerSparqlQuery* _tmp94_;
				TrackerSparqlLiteralBinding* _tmp95_;
				TrackerSparqlLiteralBinding* _tmp96_;
#line 1093 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp89_ = sql;
#line 1093 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp89_, "?");
#line 1095 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp90_ = tracker_sparql_literal_binding_new ();
#line 1095 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				binding = _tmp90_;
#line 1096 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp91_ = binding;
#line 1096 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp92_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1096 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (_tmp91_->literal);
#line 1096 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp91_->literal = _tmp92_;
#line 1097 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp93_ = binding;
#line 1097 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				((TrackerSparqlDataBinding*) _tmp93_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 1098 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp94_ = self->priv->query;
#line 1098 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp95_ = binding;
#line 1098 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp96_ = _g_object_ref0 (_tmp95_);
#line 1098 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp94_->bindings = g_list_append (_tmp94_->bindings, _tmp96_);
#line 1090 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (binding);
#line 10445 "tracker-sparql-expression.c"
			}
#line 1101 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 1101 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10451 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_VAR:
#line 10455 "tracker-sparql-expression.c"
		{
			gchar* _tmp97_ = NULL;
			gchar* _tmp98_;
			gchar* _tmp99_ = NULL;
			gchar* _tmp100_;
			gchar* variable_name;
			TrackerSparqlContext* _tmp101_;
			TrackerSparqlContext* _tmp102_;
			const gchar* _tmp103_;
			TrackerSparqlVariable* _tmp104_ = NULL;
			TrackerSparqlVariable* _tmp105_;
			TrackerSparqlVariable* variable;
			GString* _tmp106_;
			TrackerSparqlVariable* _tmp107_;
			const gchar* _tmp108_;
			const gchar* _tmp109_;
			TrackerSparqlVariable* _tmp110_;
			TrackerSparqlVariableBinding* _tmp111_;
#line 1103 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1103 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1103 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1103 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1103 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10484 "tracker-sparql-expression.c"
				} else {
#line 1103 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1103 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1103 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10492 "tracker-sparql-expression.c"
				}
			}
#line 1104 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp97_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1104 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp98_ = _tmp97_;
#line 1104 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp99_ = string_substring (_tmp98_, (glong) 1, (glong) (-1));
#line 1104 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp100_ = _tmp99_;
#line 1104 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp98_);
#line 1104 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			variable_name = _tmp100_;
#line 1105 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp101_ = tracker_sparql_expression_get_context (self);
#line 1105 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp102_ = _tmp101_;
#line 1105 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp103_ = variable_name;
#line 1105 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp104_ = tracker_sparql_context_get_variable (_tmp102_, _tmp103_);
#line 1105 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp105_ = _g_object_ref0 (_tmp104_);
#line 1105 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			variable = _tmp105_;
#line 1106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp106_ = sql;
#line 1106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp107_ = variable;
#line 1106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp108_ = tracker_sparql_variable_get_sql_expression (_tmp107_);
#line 1106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp109_ = _tmp108_;
#line 1106 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp106_, _tmp109_);
#line 1108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp110_ = variable;
#line 1108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp111_ = _tmp110_->binding;
#line 1108 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp111_ == NULL) {
#line 1109 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				result = TRACKER_PROPERTY_TYPE_UNKNOWN;
#line 1109 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 1109 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 1109 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return result;
#line 10543 "tracker-sparql-expression.c"
			} else {
				TrackerSparqlVariable* _tmp112_;
				TrackerSparqlVariableBinding* _tmp113_;
				TrackerPropertyType _tmp114_;
				TrackerSparqlVariable* _tmp116_;
				TrackerSparqlVariableBinding* _tmp117_;
				TrackerPropertyType _tmp118_;
#line 1111 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp112_ = variable;
#line 1111 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp113_ = _tmp112_->binding;
#line 1111 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp114_ = ((TrackerSparqlDataBinding*) _tmp113_)->data_type;
#line 1111 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_tmp114_ == TRACKER_PROPERTY_TYPE_STRING) {
#line 10559 "tracker-sparql-expression.c"
					GString* _tmp115_;
#line 1112 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp115_ = sql;
#line 1112 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					tracker_sparql_expression_append_collate (self, _tmp115_);
#line 10565 "tracker-sparql-expression.c"
				}
#line 1114 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp116_ = variable;
#line 1114 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp117_ = _tmp116_->binding;
#line 1114 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp118_ = ((TrackerSparqlDataBinding*) _tmp117_)->data_type;
#line 1114 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				result = _tmp118_;
#line 1114 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_object_unref0 (variable);
#line 1114 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_g_free0 (variable_name);
#line 1114 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return result;
#line 10581 "tracker-sparql-expression.c"
			}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_object_unref0 (variable);
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (variable_name);
#line 10587 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
#line 10591 "tracker-sparql-expression.c"
		{
			GString* _tmp119_;
#line 1117 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp119_ = sql;
#line 1117 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_str (self, _tmp119_, &_inner_error_);
#line 1117 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1117 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1117 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1117 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10606 "tracker-sparql-expression.c"
				} else {
#line 1117 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1117 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1117 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10614 "tracker-sparql-expression.c"
				}
			}
#line 1118 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_STRING;
#line 1118 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10621 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
#line 10625 "tracker-sparql-expression.c"
		{
			GString* _tmp120_;
#line 1120 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1120 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1120 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1120 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1120 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10638 "tracker-sparql-expression.c"
				} else {
#line 1120 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1120 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1120 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10646 "tracker-sparql-expression.c"
				}
			}
#line 1121 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp120_ = sql;
#line 1121 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp120_, "''");
#line 1122 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_STRING;
#line 1122 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10657 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
#line 10661 "tracker-sparql-expression.c"
		{
			GString* _tmp121_;
#line 1124 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1124 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1124 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1124 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1124 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10674 "tracker-sparql-expression.c"
				} else {
#line 1124 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1124 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1124 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10682 "tracker-sparql-expression.c"
				}
			}
#line 1125 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp121_ = sql;
#line 1125 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp121_, "0");
#line 1126 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1126 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10693 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
#line 10697 "tracker-sparql-expression.c"
		{
			GString* _tmp122_;
#line 1128 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp122_ = sql;
#line 1128 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_datatype (self, _tmp122_, &_inner_error_);
#line 1128 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1128 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1128 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1128 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10712 "tracker-sparql-expression.c"
				} else {
#line 1128 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1128 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1128 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10720 "tracker-sparql-expression.c"
				}
			}
#line 1129 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1129 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10727 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
#line 10731 "tracker-sparql-expression.c"
		{
			GString* _tmp123_;
#line 1131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp123_ = sql;
#line 1131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_bound_call (self, _tmp123_, &_inner_error_);
#line 1131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10746 "tracker-sparql-expression.c"
				} else {
#line 1131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1131 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10754 "tracker-sparql-expression.c"
				}
			}
#line 1132 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1132 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10761 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COALESCE:
#line 10765 "tracker-sparql-expression.c"
		{
			GString* _tmp124_;
			TrackerPropertyType _tmp125_ = 0;
			TrackerPropertyType _result_;
#line 1134 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1134 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1134 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1134 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1134 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10780 "tracker-sparql-expression.c"
				} else {
#line 1134 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1134 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1134 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10788 "tracker-sparql-expression.c"
				}
			}
#line 1135 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1135 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1135 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1135 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1135 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10801 "tracker-sparql-expression.c"
				} else {
#line 1135 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1135 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1135 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10809 "tracker-sparql-expression.c"
				}
			}
#line 1136 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp124_ = sql;
#line 1136 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp125_ = tracker_sparql_expression_translate_function (self, _tmp124_, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "coalesce", &_inner_error_);
#line 1136 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_result_ = _tmp125_;
#line 1136 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1136 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1136 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1136 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10826 "tracker-sparql-expression.c"
				} else {
#line 1136 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1136 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1136 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10834 "tracker-sparql-expression.c"
				}
			}
#line 1137 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1137 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1137 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1137 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1137 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10847 "tracker-sparql-expression.c"
				} else {
#line 1137 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1137 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1137 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10855 "tracker-sparql-expression.c"
				}
			}
#line 1138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _result_;
#line 1138 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10862 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IF:
#line 10866 "tracker-sparql-expression.c"
		{
			GString* _tmp126_;
			TrackerPropertyType _tmp127_ = 0;
			TrackerPropertyType _tmp128_;
#line 1140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp126_ = sql;
#line 1140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp127_ = tracker_sparql_expression_translate_if_call (self, _tmp126_, &_inner_error_);
#line 1140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp128_ = _tmp127_;
#line 1140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10885 "tracker-sparql-expression.c"
				} else {
#line 1140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10893 "tracker-sparql-expression.c"
				}
			}
#line 1140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp128_;
#line 1140 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 10900 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
#line 10904 "tracker-sparql-expression.c"
		{
			GString* _tmp129_;
			GString* _tmp130_;
			GString* _tmp131_;
			GString* _tmp132_;
			GString* _tmp133_;
#line 1142 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1142 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1142 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1142 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1142 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10921 "tracker-sparql-expression.c"
				} else {
#line 1142 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1142 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1142 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10929 "tracker-sparql-expression.c"
				}
			}
#line 1143 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1143 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1143 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1143 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1143 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10942 "tracker-sparql-expression.c"
				} else {
#line 1143 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1143 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1143 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10950 "tracker-sparql-expression.c"
				}
			}
#line 1144 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp129_ = sql;
#line 1144 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp129_, "(");
#line 1145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp130_ = sql;
#line 1145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression (self, _tmp130_, &_inner_error_);
#line 1145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10969 "tracker-sparql-expression.c"
				} else {
#line 1145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1145 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10977 "tracker-sparql-expression.c"
				}
			}
#line 1146 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp131_ = sql;
#line 1146 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp131_, " = ");
#line 1147 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 1147 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1147 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1147 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1147 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 10994 "tracker-sparql-expression.c"
				} else {
#line 1147 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1147 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1147 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11002 "tracker-sparql-expression.c"
				}
			}
#line 1148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp132_ = sql;
#line 1148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression (self, _tmp132_, &_inner_error_);
#line 1148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11017 "tracker-sparql-expression.c"
				} else {
#line 1148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1148 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11025 "tracker-sparql-expression.c"
				}
			}
#line 1149 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp133_ = sql;
#line 1149 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp133_, ")");
#line 1150 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1150 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1150 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1150 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1150 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11042 "tracker-sparql-expression.c"
				} else {
#line 1150 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1150 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1150 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11050 "tracker-sparql-expression.c"
				}
			}
#line 1151 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1151 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11057 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
#line 11063 "tracker-sparql-expression.c"
		{
			GString* _tmp134_;
#line 1154 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp134_ = sql;
#line 1154 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_isuri (self, _tmp134_, &_inner_error_);
#line 1154 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1154 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1154 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1154 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11078 "tracker-sparql-expression.c"
				} else {
#line 1154 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1154 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1154 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11086 "tracker-sparql-expression.c"
				}
			}
#line 1155 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1155 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11093 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
#line 11097 "tracker-sparql-expression.c"
		{
			GString* _tmp135_;
#line 1157 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1157 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1157 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1157 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1157 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11110 "tracker-sparql-expression.c"
				} else {
#line 1157 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1157 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1157 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11118 "tracker-sparql-expression.c"
				}
			}
#line 1158 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1158 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1158 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1158 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1158 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11131 "tracker-sparql-expression.c"
				} else {
#line 1158 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1158 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1158 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11139 "tracker-sparql-expression.c"
				}
			}
#line 1159 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1159 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1159 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1159 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1159 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11152 "tracker-sparql-expression.c"
				} else {
#line 1159 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1159 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1159 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11160 "tracker-sparql-expression.c"
				}
			}
#line 1161 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp135_ = sql;
#line 1161 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp135_, "0");
#line 1162 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1162 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1162 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1162 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1162 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11177 "tracker-sparql-expression.c"
				} else {
#line 1162 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1162 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1162 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11185 "tracker-sparql-expression.c"
				}
			}
#line 1163 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1163 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11192 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
#line 11196 "tracker-sparql-expression.c"
		{
#line 1165 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1165 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1165 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1165 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1165 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11208 "tracker-sparql-expression.c"
				} else {
#line 1165 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1165 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1165 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11216 "tracker-sparql-expression.c"
				}
			}
#line 1166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1166 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11223 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
#line 11227 "tracker-sparql-expression.c"
		{
			GString* _tmp136_;
			TrackerSparqlQuery* _tmp137_;
#line 1168 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp136_ = sql;
#line 1168 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_regex (self, _tmp136_, &_inner_error_);
#line 1168 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1168 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1168 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1168 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11243 "tracker-sparql-expression.c"
				} else {
#line 1168 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1168 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1168 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11251 "tracker-sparql-expression.c"
				}
			}
#line 1169 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp137_ = self->priv->query;
#line 1169 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_query_set_no_cache (_tmp137_, TRUE);
#line 1170 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1170 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11262 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_EXISTS:
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NOT:
#line 11268 "tracker-sparql-expression.c"
		{
			GString* _tmp138_;
#line 1173 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp138_ = sql;
#line 1173 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_exists (self, _tmp138_, &_inner_error_);
#line 1173 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1173 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1173 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1173 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11283 "tracker-sparql-expression.c"
				} else {
#line 1173 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1173 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1173 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11291 "tracker-sparql-expression.c"
				}
			}
#line 1174 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1174 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11298 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COUNT:
#line 11302 "tracker-sparql-expression.c"
		{
			GString* _tmp139_;
			GString* _tmp140_;
			GString* _tmp141_;
#line 1176 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1176 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1176 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1176 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1176 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11317 "tracker-sparql-expression.c"
				} else {
#line 1176 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1176 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1176 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11325 "tracker-sparql-expression.c"
				}
			}
#line 1177 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp139_ = sql;
#line 1177 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp139_, "COUNT(");
#line 1178 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp140_ = sql;
#line 1178 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_aggregate_expression (self, _tmp140_, &_inner_error_);
#line 1178 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1178 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1178 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1178 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11344 "tracker-sparql-expression.c"
				} else {
#line 1178 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1178 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1178 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11352 "tracker-sparql-expression.c"
				}
			}
#line 1179 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp141_ = sql;
#line 1179 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp141_, ")");
#line 1180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_INTEGER;
#line 1180 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11363 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SUM:
#line 11367 "tracker-sparql-expression.c"
		{
			GString* _tmp142_;
			GString* _tmp143_;
			TrackerPropertyType _tmp144_ = 0;
			TrackerPropertyType _tmp145_;
			GString* _tmp146_;
#line 1182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11384 "tracker-sparql-expression.c"
				} else {
#line 1182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1182 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11392 "tracker-sparql-expression.c"
				}
			}
#line 1183 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp142_ = sql;
#line 1183 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp142_, "SUM(");
#line 1184 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp143_ = sql;
#line 1184 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp144_ = tracker_sparql_expression_translate_aggregate_expression (self, _tmp143_, &_inner_error_);
#line 1184 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp145_ = _tmp144_;
#line 1184 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1184 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1184 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1184 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11413 "tracker-sparql-expression.c"
				} else {
#line 1184 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1184 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1184 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11421 "tracker-sparql-expression.c"
				}
			}
#line 1184 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp145_;
#line 1185 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp146_ = sql;
#line 1185 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp146_, ")");
#line 1186 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = type;
#line 1186 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11434 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_AVG:
#line 11438 "tracker-sparql-expression.c"
		{
			GString* _tmp147_;
			GString* _tmp148_;
			TrackerPropertyType _tmp149_ = 0;
			TrackerPropertyType _tmp150_;
			GString* _tmp151_;
#line 1188 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1188 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1188 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1188 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1188 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11455 "tracker-sparql-expression.c"
				} else {
#line 1188 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1188 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1188 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11463 "tracker-sparql-expression.c"
				}
			}
#line 1189 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp147_ = sql;
#line 1189 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp147_, "AVG(");
#line 1190 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp148_ = sql;
#line 1190 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp149_ = tracker_sparql_expression_translate_aggregate_expression (self, _tmp148_, &_inner_error_);
#line 1190 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp150_ = _tmp149_;
#line 1190 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1190 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1190 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1190 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11484 "tracker-sparql-expression.c"
				} else {
#line 1190 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1190 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1190 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11492 "tracker-sparql-expression.c"
				}
			}
#line 1190 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp150_;
#line 1191 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp151_ = sql;
#line 1191 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp151_, ")");
#line 1192 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = type;
#line 1192 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11505 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MIN:
#line 11509 "tracker-sparql-expression.c"
		{
			GString* _tmp152_;
			GString* _tmp153_;
			TrackerPropertyType _tmp154_ = 0;
			TrackerPropertyType _tmp155_;
			GString* _tmp156_;
#line 1194 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1194 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1194 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1194 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1194 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11526 "tracker-sparql-expression.c"
				} else {
#line 1194 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1194 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1194 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11534 "tracker-sparql-expression.c"
				}
			}
#line 1195 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp152_ = sql;
#line 1195 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp152_, "MIN(");
#line 1196 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp153_ = sql;
#line 1196 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp154_ = tracker_sparql_expression_translate_aggregate_expression (self, _tmp153_, &_inner_error_);
#line 1196 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp155_ = _tmp154_;
#line 1196 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1196 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1196 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1196 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11555 "tracker-sparql-expression.c"
				} else {
#line 1196 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1196 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1196 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11563 "tracker-sparql-expression.c"
				}
			}
#line 1196 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp155_;
#line 1197 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp156_ = sql;
#line 1197 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp156_, ")");
#line 1198 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = type;
#line 1198 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11576 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MAX:
#line 11580 "tracker-sparql-expression.c"
		{
			GString* _tmp157_;
			GString* _tmp158_;
			TrackerPropertyType _tmp159_ = 0;
			TrackerPropertyType _tmp160_;
			GString* _tmp161_;
#line 1200 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1200 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1200 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1200 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1200 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11597 "tracker-sparql-expression.c"
				} else {
#line 1200 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1200 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1200 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11605 "tracker-sparql-expression.c"
				}
			}
#line 1201 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp157_ = sql;
#line 1201 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp157_, "MAX(");
#line 1202 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp158_ = sql;
#line 1202 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp159_ = tracker_sparql_expression_translate_aggregate_expression (self, _tmp158_, &_inner_error_);
#line 1202 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp160_ = _tmp159_;
#line 1202 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1202 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1202 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1202 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11626 "tracker-sparql-expression.c"
				} else {
#line 1202 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1202 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1202 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11634 "tracker-sparql-expression.c"
				}
			}
#line 1202 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			type = _tmp160_;
#line 1203 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp161_ = sql;
#line 1203 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp161_, ")");
#line 1204 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = type;
#line 1204 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11647 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT:
#line 11651 "tracker-sparql-expression.c"
		{
			GString* _tmp162_;
			GString* _tmp163_;
			GString* _tmp164_;
			gchar* _tmp165_ = NULL;
			gchar* _tmp166_;
			GString* _tmp167_;
			gchar* _tmp168_;
			gchar* _tmp169_ = NULL;
			gchar* _tmp170_;
			GString* _tmp171_;
#line 1206 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1206 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1206 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1206 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1206 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11673 "tracker-sparql-expression.c"
				} else {
#line 1206 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1206 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1206 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11681 "tracker-sparql-expression.c"
				}
			}
#line 1207 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp162_ = sql;
#line 1207 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp162_, "GROUP_CONCAT(");
#line 1208 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1208 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1208 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1208 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1208 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11698 "tracker-sparql-expression.c"
				} else {
#line 1208 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1208 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1208 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11706 "tracker-sparql-expression.c"
				}
			}
#line 1209 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp163_ = sql;
#line 1209 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression_as_string (self, _tmp163_, &_inner_error_);
#line 1209 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1209 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1209 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1209 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11721 "tracker-sparql-expression.c"
				} else {
#line 1209 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1209 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1209 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11729 "tracker-sparql-expression.c"
				}
			}
#line 1210 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp164_ = sql;
#line 1210 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp164_, ", ");
#line 1211 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 1211 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1211 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1211 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1211 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11746 "tracker-sparql-expression.c"
				} else {
#line 1211 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1211 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1211 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11754 "tracker-sparql-expression.c"
				}
			}
#line 1212 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp165_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
#line 1212 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp166_ = _tmp165_;
#line 1212 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1212 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1212 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1212 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11769 "tracker-sparql-expression.c"
				} else {
#line 1212 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1212 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1212 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11777 "tracker-sparql-expression.c"
				}
			}
#line 1212 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp167_ = sql;
#line 1212 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp168_ = _tmp166_;
#line 1212 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp169_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp168_);
#line 1212 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp170_ = _tmp169_;
#line 1212 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp167_, _tmp170_);
#line 1212 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp170_);
#line 1212 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp168_);
#line 1213 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp171_ = sql;
#line 1213 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp171_, ")");
#line 1214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11808 "tracker-sparql-expression.c"
				} else {
#line 1214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1214 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11816 "tracker-sparql-expression.c"
				}
			}
#line 1215 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = TRACKER_PROPERTY_TYPE_STRING;
#line 1215 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11823 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
#line 11827 "tracker-sparql-expression.c"
		{
			gchar* _tmp172_ = NULL;
			gchar* ns;
			TrackerSparqlQuery* _tmp173_;
			const gchar* _tmp174_;
			gchar* _tmp175_ = NULL;
			gchar* _tmp176_;
			gchar* _tmp177_ = NULL;
			gchar* _tmp178_;
			gchar* _tmp179_ = NULL;
			gchar* _tmp180_;
			gchar* uri;
			GString* _tmp181_;
			const gchar* _tmp182_;
			TrackerPropertyType _tmp183_ = 0;
			TrackerPropertyType _tmp184_;
#line 1217 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1217 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1217 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1217 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1217 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11854 "tracker-sparql-expression.c"
				} else {
#line 1217 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1217 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1217 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11862 "tracker-sparql-expression.c"
				}
			}
#line 1218 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp172_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1218 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			ns = _tmp172_;
#line 1219 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 1219 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1219 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1219 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1219 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1219 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11881 "tracker-sparql-expression.c"
				} else {
#line 1219 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1219 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1219 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1219 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11891 "tracker-sparql-expression.c"
				}
			}
#line 1220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp173_ = self->priv->query;
#line 1220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp174_ = ns;
#line 1220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp175_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp176_ = _tmp175_;
#line 1220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp177_ = string_substring (_tmp176_, (glong) 1, (glong) (-1));
#line 1220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp178_ = _tmp177_;
#line 1220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp179_ = tracker_sparql_query_resolve_prefixed_name (_tmp173_, _tmp174_, _tmp178_, &_inner_error_);
#line 1220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp180_ = _tmp179_;
#line 1220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp178_);
#line 1220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp176_);
#line 1220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			uri = _tmp180_;
#line 1220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11926 "tracker-sparql-expression.c"
				} else {
#line 1220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1220 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11936 "tracker-sparql-expression.c"
				}
			}
#line 1221 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp181_ = sql;
#line 1221 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp182_ = uri;
#line 1221 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp183_ = tracker_sparql_expression_translate_uri_expression (self, _tmp181_, _tmp182_, &_inner_error_);
#line 1221 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp184_ = _tmp183_;
#line 1221 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1221 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1221 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1221 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (uri);
#line 1221 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1221 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11959 "tracker-sparql-expression.c"
				} else {
#line 1221 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (uri);
#line 1221 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (ns);
#line 1221 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1221 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1221 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 11971 "tracker-sparql-expression.c"
				}
			}
#line 1221 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp184_;
#line 1221 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (uri);
#line 1221 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (ns);
#line 1221 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 11982 "tracker-sparql-expression.c"
		}
#line 1002 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
#line 11986 "tracker-sparql-expression.c"
		{
			TrackerSparqlQuery* _tmp185_;
			gchar* _tmp186_ = NULL;
			gchar* _tmp187_;
			gchar* _tmp188_ = NULL;
			gchar* _tmp189_;
			gchar* _tmp190_ = NULL;
			gchar* _tmp191_;
			gchar* uri;
			GString* _tmp192_;
			const gchar* _tmp193_;
			TrackerPropertyType _tmp194_ = 0;
			TrackerPropertyType _tmp195_;
#line 1223 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_next (self, &_inner_error_);
#line 1223 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1223 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1223 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1223 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12010 "tracker-sparql-expression.c"
				} else {
#line 1223 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1223 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1223 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12018 "tracker-sparql-expression.c"
				}
			}
#line 1224 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp185_ = self->priv->query;
#line 1224 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp186_ = tracker_sparql_expression_get_last_string (self, 0);
#line 1224 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp187_ = _tmp186_;
#line 1224 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp188_ = string_substring (_tmp187_, (glong) 1, (glong) (-1));
#line 1224 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp189_ = _tmp188_;
#line 1224 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp190_ = tracker_sparql_query_resolve_prefixed_name (_tmp185_, "", _tmp189_, &_inner_error_);
#line 1224 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp191_ = _tmp190_;
#line 1224 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp189_);
#line 1224 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (_tmp187_);
#line 1224 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			uri = _tmp191_;
#line 1224 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1224 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1224 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1224 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12049 "tracker-sparql-expression.c"
				} else {
#line 1224 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1224 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1224 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12057 "tracker-sparql-expression.c"
				}
			}
#line 1225 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp192_ = sql;
#line 1225 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp193_ = uri;
#line 1225 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp194_ = tracker_sparql_expression_translate_uri_expression (self, _tmp192_, _tmp193_, &_inner_error_);
#line 1225 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp195_ = _tmp194_;
#line 1225 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1225 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1225 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1225 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (uri);
#line 1225 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12078 "tracker-sparql-expression.c"
				} else {
#line 1225 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_g_free0 (uri);
#line 1225 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1225 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1225 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12088 "tracker-sparql-expression.c"
				}
			}
#line 1225 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp195_;
#line 1225 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_g_free0 (uri);
#line 1225 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 12097 "tracker-sparql-expression.c"
		}
		default:
		{
			GError* _tmp196_ = NULL;
#line 1227 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp196_ = tracker_sparql_expression_get_error (self, "expected primary expression");
#line 1227 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp196_;
#line 1227 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1227 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1227 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12112 "tracker-sparql-expression.c"
			} else {
#line 1227 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1227 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1227 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12120 "tracker-sparql-expression.c"
			}
		}
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_unary_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GString* _tmp19_;
	TrackerPropertyType _tmp20_ = 0;
	TrackerPropertyType _tmp21_;
	GError * _inner_error_ = NULL;
#line 1231 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1231 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1232 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_NEG, &_inner_error_);
#line 1232 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 1232 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1232 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1232 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1232 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12151 "tracker-sparql-expression.c"
		} else {
#line 1232 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1232 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1232 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12159 "tracker-sparql-expression.c"
		}
	}
#line 1232 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 12164 "tracker-sparql-expression.c"
		GString* _tmp2_;
		GString* _tmp3_;
		TrackerPropertyType _tmp4_ = 0;
		TrackerPropertyType optype;
		GString* _tmp5_;
		TrackerPropertyType _tmp6_;
#line 1233 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = sql;
#line 1233 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp2_, "NOT (");
#line 1234 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = sql;
#line 1234 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_translate_primary_expression (self, _tmp3_, &_inner_error_);
#line 1234 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		optype = _tmp4_;
#line 1234 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1234 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1234 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1234 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12189 "tracker-sparql-expression.c"
			} else {
#line 1234 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1234 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1234 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12197 "tracker-sparql-expression.c"
			}
		}
#line 1235 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = sql;
#line 1235 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp5_, ")");
#line 1236 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = optype;
#line 1236 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp6_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 12208 "tracker-sparql-expression.c"
			GError* _tmp7_ = NULL;
#line 1237 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1237 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp7_;
#line 1237 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1237 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1237 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12220 "tracker-sparql-expression.c"
			} else {
#line 1237 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1237 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1237 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12228 "tracker-sparql-expression.c"
			}
		}
#line 1239 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1239 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 12235 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_;
#line 1240 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PLUS, &_inner_error_);
#line 1240 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = _tmp8_;
#line 1240 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1240 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1240 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1240 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12251 "tracker-sparql-expression.c"
			} else {
#line 1240 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1240 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1240 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12259 "tracker-sparql-expression.c"
			}
		}
#line 1240 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp9_) {
#line 12264 "tracker-sparql-expression.c"
			GString* _tmp10_;
			TrackerPropertyType _tmp11_ = 0;
			TrackerPropertyType _tmp12_;
#line 1241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = sql;
#line 1241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = tracker_sparql_expression_translate_primary_expression (self, _tmp10_, &_inner_error_);
#line 1241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = _tmp11_;
#line 1241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12282 "tracker-sparql-expression.c"
				} else {
#line 1241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12290 "tracker-sparql-expression.c"
				}
			}
#line 1241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp12_;
#line 1241 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 12297 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_;
#line 1242 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_MINUS, &_inner_error_);
#line 1242 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = _tmp13_;
#line 1242 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1242 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1242 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1242 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12313 "tracker-sparql-expression.c"
				} else {
#line 1242 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1242 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1242 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12321 "tracker-sparql-expression.c"
				}
			}
#line 1242 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp14_) {
#line 12326 "tracker-sparql-expression.c"
				GString* _tmp15_;
				GString* _tmp16_;
				TrackerPropertyType _tmp17_ = 0;
				TrackerPropertyType optype;
				GString* _tmp18_;
#line 1243 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp15_ = sql;
#line 1243 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp15_, "-(");
#line 1244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp16_ = sql;
#line 1244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp17_ = tracker_sparql_expression_translate_primary_expression (self, _tmp16_, &_inner_error_);
#line 1244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				optype = _tmp17_;
#line 1244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 1244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12350 "tracker-sparql-expression.c"
					} else {
#line 1244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1244 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12358 "tracker-sparql-expression.c"
					}
				}
#line 1245 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp18_ = sql;
#line 1245 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp18_, ")");
#line 1246 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				result = optype;
#line 1246 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return result;
#line 12369 "tracker-sparql-expression.c"
			}
		}
	}
#line 1248 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp19_ = sql;
#line 1248 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp20_ = tracker_sparql_expression_translate_primary_expression (self, _tmp19_, &_inner_error_);
#line 1248 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp21_ = _tmp20_;
#line 1248 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1248 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1248 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1248 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12387 "tracker-sparql-expression.c"
		} else {
#line 1248 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1248 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1248 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12395 "tracker-sparql-expression.c"
		}
	}
#line 1248 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp21_;
#line 1248 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 12402 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_multiplicative_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	TrackerPropertyType _tmp3_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1251 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1251 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1252 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1252 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 1252 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 1253 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1253 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_translate_unary_expression (self, _tmp2_, &_inner_error_);
#line 1253 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp3_;
#line 1253 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1253 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1253 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1253 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12439 "tracker-sparql-expression.c"
		} else {
#line 1253 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1253 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1253 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12447 "tracker-sparql-expression.c"
		}
	}
#line 1254 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 12452 "tracker-sparql-expression.c"
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
#line 1255 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STAR, &_inner_error_);
#line 1255 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 1255 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1255 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1255 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1255 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12467 "tracker-sparql-expression.c"
			} else {
#line 1255 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1255 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1255 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12475 "tracker-sparql-expression.c"
			}
		}
#line 1255 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp5_) {
#line 12480 "tracker-sparql-expression.c"
			TrackerPropertyType _tmp6_;
			gboolean _tmp7_ = FALSE;
			GString* _tmp9_;
			glong _tmp10_;
			GString* _tmp11_;
			GString* _tmp12_;
			TrackerPropertyType _tmp13_ = 0;
			TrackerPropertyType _tmp14_;
			gboolean _tmp15_ = FALSE;
			GString* _tmp17_;
#line 1256 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = optype;
#line 1256 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_maybe_numeric (self, _tmp6_);
#line 1256 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (!_tmp7_) {
#line 12497 "tracker-sparql-expression.c"
				GError* _tmp8_ = NULL;
#line 1257 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp8_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1257 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_inner_error_ = _tmp8_;
#line 1257 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1257 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1257 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12509 "tracker-sparql-expression.c"
				} else {
#line 1257 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1257 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1257 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12517 "tracker-sparql-expression.c"
				}
			}
#line 1259 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = sql;
#line 1259 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = begin;
#line 1259 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp9_, (gssize) _tmp10_, "(");
#line 1260 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = sql;
#line 1260 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp11_, " * ");
#line 1261 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = sql;
#line 1261 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = tracker_sparql_expression_translate_unary_expression (self, _tmp12_, &_inner_error_);
#line 1261 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = _tmp13_;
#line 1261 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1261 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1261 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1261 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12544 "tracker-sparql-expression.c"
				} else {
#line 1261 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1261 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1261 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12552 "tracker-sparql-expression.c"
				}
			}
#line 1261 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = tracker_sparql_expression_maybe_numeric (self, _tmp14_);
#line 1261 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (!_tmp15_) {
#line 12559 "tracker-sparql-expression.c"
				GError* _tmp16_ = NULL;
#line 1262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp16_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_inner_error_ = _tmp16_;
#line 1262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12571 "tracker-sparql-expression.c"
				} else {
#line 1262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1262 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12579 "tracker-sparql-expression.c"
				}
			}
#line 1264 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = sql;
#line 1264 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp17_, ")");
#line 12586 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_;
#line 1265 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DIV, &_inner_error_);
#line 1265 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = _tmp18_;
#line 1265 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1265 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1265 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1265 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12602 "tracker-sparql-expression.c"
				} else {
#line 1265 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1265 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1265 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12610 "tracker-sparql-expression.c"
				}
			}
#line 1265 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp19_) {
#line 12615 "tracker-sparql-expression.c"
				TrackerPropertyType _tmp20_;
				gboolean _tmp21_ = FALSE;
				GString* _tmp23_;
				glong _tmp24_;
				GString* _tmp25_;
				GString* _tmp26_;
				TrackerPropertyType _tmp27_ = 0;
				TrackerPropertyType _tmp28_;
				gboolean _tmp29_ = FALSE;
				GString* _tmp31_;
#line 1266 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_ = optype;
#line 1266 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp21_ = tracker_sparql_expression_maybe_numeric (self, _tmp20_);
#line 1266 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (!_tmp21_) {
#line 12632 "tracker-sparql-expression.c"
					GError* _tmp22_ = NULL;
#line 1267 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp22_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1267 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_inner_error_ = _tmp22_;
#line 1267 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1267 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1267 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12644 "tracker-sparql-expression.c"
					} else {
#line 1267 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1267 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1267 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12652 "tracker-sparql-expression.c"
					}
				}
#line 1269 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp23_ = sql;
#line 1269 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp24_ = begin;
#line 1269 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_insert (_tmp23_, (gssize) _tmp24_, "(");
#line 1270 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp25_ = sql;
#line 1270 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp25_, " / ");
#line 1271 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp26_ = sql;
#line 1271 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = tracker_sparql_expression_translate_unary_expression (self, _tmp26_, &_inner_error_);
#line 1271 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp28_ = _tmp27_;
#line 1271 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 1271 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1271 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1271 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12679 "tracker-sparql-expression.c"
					} else {
#line 1271 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1271 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1271 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12687 "tracker-sparql-expression.c"
					}
				}
#line 1271 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp29_ = tracker_sparql_expression_maybe_numeric (self, _tmp28_);
#line 1271 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (!_tmp29_) {
#line 12694 "tracker-sparql-expression.c"
					GError* _tmp30_ = NULL;
#line 1272 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp30_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1272 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_inner_error_ = _tmp30_;
#line 1272 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1272 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1272 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12706 "tracker-sparql-expression.c"
					} else {
#line 1272 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1272 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1272 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12714 "tracker-sparql-expression.c"
					}
				}
#line 1274 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp31_ = sql;
#line 1274 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp31_, ")");
#line 12721 "tracker-sparql-expression.c"
			} else {
#line 1276 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				break;
#line 12725 "tracker-sparql-expression.c"
			}
		}
	}
#line 1279 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1279 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 12733 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_additive_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	TrackerPropertyType _tmp3_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1282 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1282 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1283 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1283 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 1283 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 1284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_translate_multiplicative_expression (self, _tmp2_, &_inner_error_);
#line 1284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp3_;
#line 1284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12770 "tracker-sparql-expression.c"
		} else {
#line 1284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1284 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 12778 "tracker-sparql-expression.c"
		}
	}
#line 1285 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 12783 "tracker-sparql-expression.c"
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
#line 1286 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PLUS, &_inner_error_);
#line 1286 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 1286 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1286 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1286 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1286 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12798 "tracker-sparql-expression.c"
			} else {
#line 1286 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1286 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1286 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 12806 "tracker-sparql-expression.c"
			}
		}
#line 1286 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp5_) {
#line 12811 "tracker-sparql-expression.c"
			TrackerPropertyType _tmp6_;
			gboolean _tmp7_ = FALSE;
			GString* _tmp9_;
			glong _tmp10_;
			GString* _tmp11_;
			GString* _tmp12_;
			TrackerPropertyType _tmp13_ = 0;
			TrackerPropertyType _tmp14_;
			gboolean _tmp15_ = FALSE;
			GString* _tmp17_;
#line 1287 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = optype;
#line 1287 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_maybe_numeric (self, _tmp6_);
#line 1287 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (!_tmp7_) {
#line 12828 "tracker-sparql-expression.c"
				GError* _tmp8_ = NULL;
#line 1288 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp8_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1288 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_inner_error_ = _tmp8_;
#line 1288 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1288 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1288 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12840 "tracker-sparql-expression.c"
				} else {
#line 1288 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1288 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1288 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12848 "tracker-sparql-expression.c"
				}
			}
#line 1290 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = sql;
#line 1290 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = begin;
#line 1290 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_insert (_tmp9_, (gssize) _tmp10_, "(");
#line 1291 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = sql;
#line 1291 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp11_, " + ");
#line 1292 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = sql;
#line 1292 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp13_ = tracker_sparql_expression_translate_multiplicative_expression (self, _tmp12_, &_inner_error_);
#line 1292 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp14_ = _tmp13_;
#line 1292 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1292 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1292 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1292 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12875 "tracker-sparql-expression.c"
				} else {
#line 1292 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1292 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1292 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12883 "tracker-sparql-expression.c"
				}
			}
#line 1292 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp15_ = tracker_sparql_expression_maybe_numeric (self, _tmp14_);
#line 1292 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (!_tmp15_) {
#line 12890 "tracker-sparql-expression.c"
				GError* _tmp16_ = NULL;
#line 1293 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp16_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1293 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_inner_error_ = _tmp16_;
#line 1293 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1293 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1293 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12902 "tracker-sparql-expression.c"
				} else {
#line 1293 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1293 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1293 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12910 "tracker-sparql-expression.c"
				}
			}
#line 1295 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = sql;
#line 1295 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp17_, ")");
#line 12917 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_;
#line 1296 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_MINUS, &_inner_error_);
#line 1296 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = _tmp18_;
#line 1296 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1296 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1296 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1296 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12933 "tracker-sparql-expression.c"
				} else {
#line 1296 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1296 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1296 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 12941 "tracker-sparql-expression.c"
				}
			}
#line 1296 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp19_) {
#line 12946 "tracker-sparql-expression.c"
				TrackerPropertyType _tmp20_;
				gboolean _tmp21_ = FALSE;
				GString* _tmp23_;
				glong _tmp24_;
				GString* _tmp25_;
				GString* _tmp26_;
				TrackerPropertyType _tmp27_ = 0;
				TrackerPropertyType _tmp28_;
				gboolean _tmp29_ = FALSE;
				GString* _tmp31_;
#line 1297 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp20_ = optype;
#line 1297 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp21_ = tracker_sparql_expression_maybe_numeric (self, _tmp20_);
#line 1297 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (!_tmp21_) {
#line 12963 "tracker-sparql-expression.c"
					GError* _tmp22_ = NULL;
#line 1298 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp22_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1298 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_inner_error_ = _tmp22_;
#line 1298 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1298 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1298 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12975 "tracker-sparql-expression.c"
					} else {
#line 1298 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1298 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1298 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 12983 "tracker-sparql-expression.c"
					}
				}
#line 1300 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp23_ = sql;
#line 1300 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp24_ = begin;
#line 1300 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_insert (_tmp23_, (gssize) _tmp24_, "(");
#line 1301 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp25_ = sql;
#line 1301 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp25_, " - ");
#line 1302 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp26_ = sql;
#line 1302 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = tracker_sparql_expression_translate_multiplicative_expression (self, _tmp26_, &_inner_error_);
#line 1302 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp28_ = _tmp27_;
#line 1302 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 1302 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1302 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1302 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 13010 "tracker-sparql-expression.c"
					} else {
#line 1302 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1302 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1302 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 13018 "tracker-sparql-expression.c"
					}
				}
#line 1302 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp29_ = tracker_sparql_expression_maybe_numeric (self, _tmp28_);
#line 1302 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (!_tmp29_) {
#line 13025 "tracker-sparql-expression.c"
					GError* _tmp30_ = NULL;
#line 1303 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp30_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
#line 1303 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_inner_error_ = _tmp30_;
#line 1303 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1303 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1303 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 13037 "tracker-sparql-expression.c"
					} else {
#line 1303 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1303 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1303 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 13045 "tracker-sparql-expression.c"
					}
				}
#line 1305 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp31_ = sql;
#line 1305 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_string_append (_tmp31_, ")");
#line 13052 "tracker-sparql-expression.c"
			} else {
#line 1307 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				break;
#line 13056 "tracker-sparql-expression.c"
			}
		}
	}
#line 1310 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1310 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 13064 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_numeric_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	TrackerPropertyType _tmp1_ = 0;
	TrackerPropertyType _tmp2_;
	GError * _inner_error_ = NULL;
#line 1313 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1313 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1314 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1314 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_expression_translate_additive_expression (self, _tmp0_, &_inner_error_);
#line 1314 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_;
#line 1314 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1314 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1314 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1314 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13092 "tracker-sparql-expression.c"
		} else {
#line 1314 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1314 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1314 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13100 "tracker-sparql-expression.c"
		}
	}
#line 1314 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 1314 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 13107 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_process_relational_expression (TrackerSparqlExpression* self, GString* sql, glong begin, guint n_bindings, TrackerPropertyType op1type, const gchar* operator, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	glong _tmp1_;
	GString* _tmp2_;
	const gchar* _tmp3_;
	GString* _tmp4_;
	TrackerPropertyType _tmp5_ = 0;
	TrackerPropertyType op2type;
	GString* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	TrackerPropertyType _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp14_;
	GError * _inner_error_ = NULL;
#line 1317 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1317 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1317 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (operator != NULL, 0);
#line 1318 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1318 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = begin;
#line 1318 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_insert (_tmp0_, (gssize) _tmp1_, "(");
#line 1319 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1319 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = operator;
#line 1319 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, _tmp3_);
#line 1320 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = sql;
#line 1320 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = tracker_sparql_expression_translate_numeric_expression (self, _tmp4_, &_inner_error_);
#line 1320 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	op2type = _tmp5_;
#line 1320 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1320 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1320 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1320 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13159 "tracker-sparql-expression.c"
		} else {
#line 1320 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1320 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1320 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13167 "tracker-sparql-expression.c"
		}
	}
#line 1321 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = sql;
#line 1321 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp6_, ")");
#line 1322 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp9_ = op1type;
#line 1322 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp9_ == TRACKER_PROPERTY_TYPE_DATETIME) {
#line 1322 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = op2type == TRACKER_PROPERTY_TYPE_STRING;
#line 13180 "tracker-sparql-expression.c"
	} else {
#line 1322 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = FALSE;
#line 13184 "tracker-sparql-expression.c"
	}
#line 1322 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp10_ = _tmp8_;
#line 1322 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp10_) {
#line 1322 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = TRUE;
#line 13192 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp11_ = FALSE;
		TrackerPropertyType _tmp12_;
		gboolean _tmp13_;
#line 1323 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = op1type;
#line 1323 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp12_ == TRACKER_PROPERTY_TYPE_STRING) {
#line 1323 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = op2type == TRACKER_PROPERTY_TYPE_DATETIME;
#line 13203 "tracker-sparql-expression.c"
		} else {
#line 1323 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp11_ = FALSE;
#line 13207 "tracker-sparql-expression.c"
		}
#line 1323 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = _tmp11_;
#line 1323 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = _tmp13_;
#line 13213 "tracker-sparql-expression.c"
	}
#line 1322 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp14_ = _tmp7_;
#line 1322 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp14_) {
#line 13219 "tracker-sparql-expression.c"
		TrackerSparqlQuery* _tmp15_;
		GList* _tmp16_;
		guint _tmp17_ = 0U;
		guint _tmp18_;
#line 1325 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = self->priv->query;
#line 1325 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp16_ = _tmp15_->bindings;
#line 1325 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp17_ = g_list_length (_tmp16_);
#line 1325 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp18_ = n_bindings;
#line 1325 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp17_ == (_tmp18_ + 1)) {
#line 13234 "tracker-sparql-expression.c"
			TrackerSparqlQuery* _tmp19_;
			GList* _tmp20_;
			GList* _tmp21_ = NULL;
			gconstpointer _tmp22_;
#line 1327 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = self->priv->query;
#line 1327 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = _tmp19_->bindings;
#line 1327 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp21_ = g_list_last (_tmp20_);
#line 1327 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp22_ = _tmp21_->data;
#line 1327 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			((TrackerSparqlDataBinding*) ((TrackerSparqlLiteralBinding*) _tmp22_))->data_type = TRACKER_PROPERTY_TYPE_DATETIME;
#line 13249 "tracker-sparql-expression.c"
		}
	} else {
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_ = FALSE;
		TrackerPropertyType _tmp25_;
		gboolean _tmp26_;
		gboolean _tmp30_;
#line 1329 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp25_ = op1type;
#line 1329 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp25_ == TRACKER_PROPERTY_TYPE_DATE) {
#line 1329 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = op2type == TRACKER_PROPERTY_TYPE_STRING;
#line 13263 "tracker-sparql-expression.c"
		} else {
#line 1329 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = FALSE;
#line 13267 "tracker-sparql-expression.c"
		}
#line 1329 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp26_ = _tmp24_;
#line 1329 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp26_) {
#line 1329 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp23_ = TRUE;
#line 13275 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp27_ = FALSE;
			TrackerPropertyType _tmp28_;
			gboolean _tmp29_;
#line 1330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp28_ = op1type;
#line 1330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp28_ == TRACKER_PROPERTY_TYPE_STRING) {
#line 1330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = op2type == TRACKER_PROPERTY_TYPE_DATE;
#line 13286 "tracker-sparql-expression.c"
			} else {
#line 1330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = FALSE;
#line 13290 "tracker-sparql-expression.c"
			}
#line 1330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp29_ = _tmp27_;
#line 1330 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp23_ = _tmp29_;
#line 13296 "tracker-sparql-expression.c"
		}
#line 1329 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp30_ = _tmp23_;
#line 1329 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp30_) {
#line 13302 "tracker-sparql-expression.c"
			TrackerSparqlQuery* _tmp31_;
			GList* _tmp32_;
			guint _tmp33_ = 0U;
			guint _tmp34_;
#line 1332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp31_ = self->priv->query;
#line 1332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp32_ = _tmp31_->bindings;
#line 1332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp33_ = g_list_length (_tmp32_);
#line 1332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp34_ = n_bindings;
#line 1332 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp33_ == (_tmp34_ + 1)) {
#line 13317 "tracker-sparql-expression.c"
				TrackerSparqlQuery* _tmp35_;
				GList* _tmp36_;
				GList* _tmp37_ = NULL;
				gconstpointer _tmp38_;
#line 1334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp35_ = self->priv->query;
#line 1334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp36_ = _tmp35_->bindings;
#line 1334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp37_ = g_list_last (_tmp36_);
#line 1334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp38_ = _tmp37_->data;
#line 1334 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				((TrackerSparqlDataBinding*) ((TrackerSparqlLiteralBinding*) _tmp38_))->data_type = TRACKER_PROPERTY_TYPE_DATE;
#line 13332 "tracker-sparql-expression.c"
			}
		}
	}
#line 1337 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1337 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 13340 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_in (TrackerSparqlExpression* self, GString* sql, gboolean not, GError** error) {
	TrackerPropertyType result = 0;
	gint in_variable_count;
	gboolean _tmp0_;
	GString* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	GString* _tmp19_;
	GError * _inner_error_ = NULL;
#line 1340 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1340 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1342 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	in_variable_count = 0;
#line 1344 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = not;
#line 1344 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp0_) {
#line 13363 "tracker-sparql-expression.c"
		GString* _tmp1_;
#line 1345 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp1_ = sql;
#line 1345 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp1_, " NOT");
#line 13369 "tracker-sparql-expression.c"
	}
#line 1348 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1348 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1348 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1348 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1348 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13381 "tracker-sparql-expression.c"
		} else {
#line 1348 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1348 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1348 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13389 "tracker-sparql-expression.c"
		}
	}
#line 1349 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1349 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp2_, " IN (");
#line 1350 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1350 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = _tmp3_;
#line 1350 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1350 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1350 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1350 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13408 "tracker-sparql-expression.c"
		} else {
#line 1350 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1350 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1350 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13416 "tracker-sparql-expression.c"
		}
	}
#line 1350 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (!_tmp4_) {
#line 13421 "tracker-sparql-expression.c"
		gint _tmp5_;
		GString* _tmp6_;
#line 1351 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = in_variable_count;
#line 1351 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		in_variable_count = _tmp5_ + 1;
#line 1352 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = sql;
#line 1352 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_translate_expression (self, _tmp6_, &_inner_error_);
#line 1352 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1352 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1352 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1352 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13440 "tracker-sparql-expression.c"
			} else {
#line 1352 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1352 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1352 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13448 "tracker-sparql-expression.c"
			}
		}
#line 1353 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		while (TRUE) {
#line 13453 "tracker-sparql-expression.c"
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_;
			GString* _tmp9_;
			gint _tmp10_;
			gboolean _tmp11_ = FALSE;
			gint _tmp12_;
			gboolean _tmp16_;
			GString* _tmp18_;
#line 1353 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 1353 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp8_ = _tmp7_;
#line 1353 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1353 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1353 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1353 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13474 "tracker-sparql-expression.c"
				} else {
#line 1353 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1353 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1353 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13482 "tracker-sparql-expression.c"
				}
			}
#line 1353 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (!_tmp8_) {
#line 1353 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				break;
#line 13489 "tracker-sparql-expression.c"
			}
#line 1354 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp9_ = sql;
#line 1354 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_string_append (_tmp9_, ", ");
#line 1356 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp10_ = in_variable_count;
#line 1356 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			in_variable_count = _tmp10_ + 1;
#line 1358 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp12_ = in_variable_count;
#line 1358 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp12_ > TRACKER_SPARQL_EXPRESSION_MAX_VARIABLES_FOR_IN) {
#line 13503 "tracker-sparql-expression.c"
				TrackerSparqlQuery* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp15_;
#line 1358 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp13_ = self->priv->query;
#line 1358 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp14_ = tracker_sparql_query_get_no_cache (_tmp13_);
#line 1358 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp15_ = _tmp14_;
#line 1358 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp11_ = !_tmp15_;
#line 13515 "tracker-sparql-expression.c"
			} else {
#line 1358 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp11_ = FALSE;
#line 13519 "tracker-sparql-expression.c"
			}
#line 1358 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = _tmp11_;
#line 1358 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp16_) {
#line 13525 "tracker-sparql-expression.c"
				TrackerSparqlQuery* _tmp17_;
#line 1359 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp17_ = self->priv->query;
#line 1359 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				tracker_sparql_query_set_no_cache (_tmp17_, TRUE);
#line 13531 "tracker-sparql-expression.c"
			}
#line 1362 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = sql;
#line 1362 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			tracker_sparql_expression_translate_expression (self, _tmp18_, &_inner_error_);
#line 1362 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1362 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1362 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1362 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13545 "tracker-sparql-expression.c"
				} else {
#line 1362 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1362 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1362 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13553 "tracker-sparql-expression.c"
				}
			}
		}
#line 1364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13567 "tracker-sparql-expression.c"
			} else {
#line 1364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1364 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13575 "tracker-sparql-expression.c"
			}
		}
	}
#line 1366 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp19_ = sql;
#line 1366 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_string_append (_tmp19_, ")");
#line 1368 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = TRACKER_PROPERTY_TYPE_BOOLEAN;
#line 1368 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 13587 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_relational_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	TrackerSparqlQuery* _tmp2_;
	GList* _tmp3_;
	guint _tmp4_ = 0U;
	guint n_bindings;
	GString* _tmp5_;
	TrackerPropertyType _tmp6_ = 0;
	TrackerPropertyType optype;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_;
	GError * _inner_error_ = NULL;
#line 1371 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1371 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1372 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1372 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 1372 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 1374 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = self->priv->query;
#line 1374 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = _tmp2_->bindings;
#line 1374 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = g_list_length (_tmp3_);
#line 1374 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	n_bindings = _tmp4_;
#line 1375 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp5_ = sql;
#line 1375 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp6_ = tracker_sparql_expression_translate_numeric_expression (self, _tmp5_, &_inner_error_);
#line 1375 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp6_;
#line 1375 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1375 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1375 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1375 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13638 "tracker-sparql-expression.c"
		} else {
#line 1375 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1375 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1375 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13646 "tracker-sparql-expression.c"
		}
	}
#line 1376 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp7_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_GE, &_inner_error_);
#line 1376 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp8_ = _tmp7_;
#line 1376 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1376 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1376 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1376 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13661 "tracker-sparql-expression.c"
		} else {
#line 1376 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1376 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1376 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 13669 "tracker-sparql-expression.c"
		}
	}
#line 1376 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp8_) {
#line 13674 "tracker-sparql-expression.c"
		GString* _tmp9_;
		glong _tmp10_;
		guint _tmp11_;
		TrackerPropertyType _tmp12_;
		TrackerPropertyType _tmp13_ = 0;
		TrackerPropertyType _tmp14_;
#line 1377 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = sql;
#line 1377 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = begin;
#line 1377 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = n_bindings;
#line 1377 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = optype;
#line 1377 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = tracker_sparql_expression_process_relational_expression (self, _tmp9_, _tmp10_, _tmp11_, _tmp12_, " >= ", &_inner_error_);
#line 1377 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp14_ = _tmp13_;
#line 1377 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1377 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1377 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1377 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13701 "tracker-sparql-expression.c"
			} else {
#line 1377 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1377 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1377 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13709 "tracker-sparql-expression.c"
			}
		}
#line 1377 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = _tmp14_;
#line 1377 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 13716 "tracker-sparql-expression.c"
	} else {
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_;
#line 1378 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_EQ, &_inner_error_);
#line 1378 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp16_ = _tmp15_;
#line 1378 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1378 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1378 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1378 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13732 "tracker-sparql-expression.c"
			} else {
#line 1378 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1378 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1378 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 13740 "tracker-sparql-expression.c"
			}
		}
#line 1378 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp16_) {
#line 13745 "tracker-sparql-expression.c"
			GString* _tmp17_;
			glong _tmp18_;
			guint _tmp19_;
			TrackerPropertyType _tmp20_;
			TrackerPropertyType _tmp21_ = 0;
			TrackerPropertyType _tmp22_;
#line 1379 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp17_ = sql;
#line 1379 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp18_ = begin;
#line 1379 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp19_ = n_bindings;
#line 1379 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp20_ = optype;
#line 1379 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp21_ = tracker_sparql_expression_process_relational_expression (self, _tmp17_, _tmp18_, _tmp19_, _tmp20_, " = ", &_inner_error_);
#line 1379 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp22_ = _tmp21_;
#line 1379 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1379 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1379 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1379 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13772 "tracker-sparql-expression.c"
				} else {
#line 1379 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1379 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1379 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13780 "tracker-sparql-expression.c"
				}
			}
#line 1379 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp22_;
#line 1379 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 13787 "tracker-sparql-expression.c"
		} else {
			gboolean _tmp23_ = FALSE;
			gboolean _tmp24_;
#line 1380 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp23_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_NE, &_inner_error_);
#line 1380 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp24_ = _tmp23_;
#line 1380 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1380 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1380 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1380 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13803 "tracker-sparql-expression.c"
				} else {
#line 1380 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1380 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1380 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 13811 "tracker-sparql-expression.c"
				}
			}
#line 1380 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_tmp24_) {
#line 13816 "tracker-sparql-expression.c"
				GString* _tmp25_;
				glong _tmp26_;
				guint _tmp27_;
				TrackerPropertyType _tmp28_;
				TrackerPropertyType _tmp29_ = 0;
				TrackerPropertyType _tmp30_;
#line 1381 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp25_ = sql;
#line 1381 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp26_ = begin;
#line 1381 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp27_ = n_bindings;
#line 1381 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp28_ = optype;
#line 1381 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp29_ = tracker_sparql_expression_process_relational_expression (self, _tmp25_, _tmp26_, _tmp27_, _tmp28_, " <> ", &_inner_error_);
#line 1381 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp30_ = _tmp29_;
#line 1381 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 1381 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1381 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1381 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 13843 "tracker-sparql-expression.c"
					} else {
#line 1381 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1381 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1381 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 13851 "tracker-sparql-expression.c"
					}
				}
#line 1381 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				result = _tmp30_;
#line 1381 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return result;
#line 13858 "tracker-sparql-expression.c"
			} else {
				gboolean _tmp31_ = FALSE;
				gboolean _tmp32_;
#line 1382 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp31_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_LT, &_inner_error_);
#line 1382 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tmp32_ = _tmp31_;
#line 1382 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_ != NULL) {
#line 1382 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1382 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_propagate_error (error, _inner_error_);
#line 1382 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 13874 "tracker-sparql-expression.c"
					} else {
#line 1382 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1382 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						g_clear_error (&_inner_error_);
#line 1382 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return 0;
#line 13882 "tracker-sparql-expression.c"
					}
				}
#line 1382 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_tmp32_) {
#line 13887 "tracker-sparql-expression.c"
					GString* _tmp33_;
					glong _tmp34_;
					guint _tmp35_;
					TrackerPropertyType _tmp36_;
					TrackerPropertyType _tmp37_ = 0;
					TrackerPropertyType _tmp38_;
#line 1383 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp33_ = sql;
#line 1383 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp34_ = begin;
#line 1383 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp35_ = n_bindings;
#line 1383 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp36_ = optype;
#line 1383 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp37_ = tracker_sparql_expression_process_relational_expression (self, _tmp33_, _tmp34_, _tmp35_, _tmp36_, " < ", &_inner_error_);
#line 1383 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp38_ = _tmp37_;
#line 1383 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_ != NULL) {
#line 1383 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1383 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_propagate_error (error, _inner_error_);
#line 1383 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 13914 "tracker-sparql-expression.c"
						} else {
#line 1383 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1383 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_clear_error (&_inner_error_);
#line 1383 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 13922 "tracker-sparql-expression.c"
						}
					}
#line 1383 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					result = _tmp38_;
#line 1383 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return result;
#line 13929 "tracker-sparql-expression.c"
				} else {
					gboolean _tmp39_ = FALSE;
					gboolean _tmp40_;
#line 1384 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp39_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_LE, &_inner_error_);
#line 1384 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					_tmp40_ = _tmp39_;
#line 1384 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_inner_error_ != NULL) {
#line 1384 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1384 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_propagate_error (error, _inner_error_);
#line 1384 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 13945 "tracker-sparql-expression.c"
						} else {
#line 1384 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1384 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							g_clear_error (&_inner_error_);
#line 1384 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return 0;
#line 13953 "tracker-sparql-expression.c"
						}
					}
#line 1384 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					if (_tmp40_) {
#line 13958 "tracker-sparql-expression.c"
						GString* _tmp41_;
						glong _tmp42_;
						guint _tmp43_;
						TrackerPropertyType _tmp44_;
						TrackerPropertyType _tmp45_ = 0;
						TrackerPropertyType _tmp46_;
#line 1385 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp41_ = sql;
#line 1385 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp42_ = begin;
#line 1385 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp43_ = n_bindings;
#line 1385 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp44_ = optype;
#line 1385 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp45_ = tracker_sparql_expression_process_relational_expression (self, _tmp41_, _tmp42_, _tmp43_, _tmp44_, " <= ", &_inner_error_);
#line 1385 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp46_ = _tmp45_;
#line 1385 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_ != NULL) {
#line 1385 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1385 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_propagate_error (error, _inner_error_);
#line 1385 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 13985 "tracker-sparql-expression.c"
							} else {
#line 1385 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1385 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_clear_error (&_inner_error_);
#line 1385 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 13993 "tracker-sparql-expression.c"
							}
						}
#line 1385 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						result = _tmp46_;
#line 1385 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						return result;
#line 14000 "tracker-sparql-expression.c"
					} else {
						gboolean _tmp47_ = FALSE;
						gboolean _tmp48_;
#line 1386 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp47_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_GT, &_inner_error_);
#line 1386 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						_tmp48_ = _tmp47_;
#line 1386 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_inner_error_ != NULL) {
#line 1386 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1386 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_propagate_error (error, _inner_error_);
#line 1386 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 14016 "tracker-sparql-expression.c"
							} else {
#line 1386 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1386 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								g_clear_error (&_inner_error_);
#line 1386 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return 0;
#line 14024 "tracker-sparql-expression.c"
							}
						}
#line 1386 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
						if (_tmp48_) {
#line 14029 "tracker-sparql-expression.c"
							GString* _tmp49_;
							glong _tmp50_;
							guint _tmp51_;
							TrackerPropertyType _tmp52_;
							TrackerPropertyType _tmp53_ = 0;
							TrackerPropertyType _tmp54_;
#line 1387 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp49_ = sql;
#line 1387 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp50_ = begin;
#line 1387 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp51_ = n_bindings;
#line 1387 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp52_ = optype;
#line 1387 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp53_ = tracker_sparql_expression_process_relational_expression (self, _tmp49_, _tmp50_, _tmp51_, _tmp52_, " > ", &_inner_error_);
#line 1387 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp54_ = _tmp53_;
#line 1387 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_ != NULL) {
#line 1387 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1387 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_propagate_error (error, _inner_error_);
#line 1387 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 14056 "tracker-sparql-expression.c"
								} else {
#line 1387 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1387 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_clear_error (&_inner_error_);
#line 1387 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 14064 "tracker-sparql-expression.c"
								}
							}
#line 1387 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							result = _tmp54_;
#line 1387 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							return result;
#line 14071 "tracker-sparql-expression.c"
						} else {
							gboolean _tmp55_ = FALSE;
							gboolean _tmp56_;
#line 1388 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp55_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_IN, &_inner_error_);
#line 1388 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							_tmp56_ = _tmp55_;
#line 1388 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_inner_error_ != NULL) {
#line 1388 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1388 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_propagate_error (error, _inner_error_);
#line 1388 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 14087 "tracker-sparql-expression.c"
								} else {
#line 1388 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1388 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									g_clear_error (&_inner_error_);
#line 1388 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return 0;
#line 14095 "tracker-sparql-expression.c"
								}
							}
#line 1388 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
							if (_tmp56_) {
#line 14100 "tracker-sparql-expression.c"
								GString* _tmp57_;
								TrackerPropertyType _tmp58_ = 0;
								TrackerPropertyType _tmp59_;
#line 1389 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp57_ = sql;
#line 1389 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp58_ = tracker_sparql_expression_translate_in (self, _tmp57_, FALSE, &_inner_error_);
#line 1389 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp59_ = _tmp58_;
#line 1389 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_ != NULL) {
#line 1389 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1389 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_propagate_error (error, _inner_error_);
#line 1389 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 14118 "tracker-sparql-expression.c"
									} else {
#line 1389 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1389 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_clear_error (&_inner_error_);
#line 1389 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 14126 "tracker-sparql-expression.c"
									}
								}
#line 1389 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								result = _tmp59_;
#line 1389 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								return result;
#line 14133 "tracker-sparql-expression.c"
							} else {
								gboolean _tmp60_ = FALSE;
								gboolean _tmp61_;
#line 1390 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp60_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_NOT, &_inner_error_);
#line 1390 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								_tmp61_ = _tmp60_;
#line 1390 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_inner_error_ != NULL) {
#line 1390 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1390 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_propagate_error (error, _inner_error_);
#line 1390 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 14149 "tracker-sparql-expression.c"
									} else {
#line 1390 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1390 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										g_clear_error (&_inner_error_);
#line 1390 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										return 0;
#line 14157 "tracker-sparql-expression.c"
									}
								}
#line 1390 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
								if (_tmp61_) {
#line 14162 "tracker-sparql-expression.c"
									GString* _tmp62_;
									TrackerPropertyType _tmp63_ = 0;
									TrackerPropertyType _tmp64_;
#line 1391 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OP_IN, &_inner_error_);
#line 1391 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_ != NULL) {
#line 1391 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1391 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_propagate_error (error, _inner_error_);
#line 1391 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 14176 "tracker-sparql-expression.c"
										} else {
#line 1391 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1391 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_clear_error (&_inner_error_);
#line 1391 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 14184 "tracker-sparql-expression.c"
										}
									}
#line 1392 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp62_ = sql;
#line 1392 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp63_ = tracker_sparql_expression_translate_in (self, _tmp62_, TRUE, &_inner_error_);
#line 1392 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									_tmp64_ = _tmp63_;
#line 1392 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									if (_inner_error_ != NULL) {
#line 1392 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1392 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_propagate_error (error, _inner_error_);
#line 1392 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 14201 "tracker-sparql-expression.c"
										} else {
#line 1392 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1392 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											g_clear_error (&_inner_error_);
#line 1392 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
											return 0;
#line 14209 "tracker-sparql-expression.c"
										}
									}
#line 1392 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									result = _tmp64_;
#line 1392 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
									return result;
#line 14216 "tracker-sparql-expression.c"
								}
							}
						}
					}
				}
			}
		}
	}
#line 1394 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1394 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 14229 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_value_logical (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	TrackerPropertyType _tmp1_ = 0;
	TrackerPropertyType _tmp2_;
	GError * _inner_error_ = NULL;
#line 1397 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1397 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_expression_translate_relational_expression (self, _tmp0_, &_inner_error_);
#line 1398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_;
#line 1398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14257 "tracker-sparql-expression.c"
		} else {
#line 1398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14265 "tracker-sparql-expression.c"
		}
	}
#line 1398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 1398 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 14272 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_conditional_and_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	TrackerPropertyType _tmp3_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1401 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1401 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1402 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1402 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 1402 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 1403 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1403 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_translate_value_logical (self, _tmp2_, &_inner_error_);
#line 1403 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp3_;
#line 1403 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1403 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1403 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1403 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14309 "tracker-sparql-expression.c"
		} else {
#line 1403 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1403 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1403 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14317 "tracker-sparql-expression.c"
		}
	}
#line 1404 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 14322 "tracker-sparql-expression.c"
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
		TrackerPropertyType _tmp6_;
		GString* _tmp8_;
		glong _tmp9_;
		GString* _tmp10_;
		GString* _tmp11_;
		TrackerPropertyType _tmp12_ = 0;
		TrackerPropertyType _tmp13_;
		GString* _tmp14_;
		TrackerPropertyType _tmp15_;
#line 1404 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_AND, &_inner_error_);
#line 1404 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 1404 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1404 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1404 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1404 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14346 "tracker-sparql-expression.c"
			} else {
#line 1404 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1404 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1404 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14354 "tracker-sparql-expression.c"
			}
		}
#line 1404 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (!_tmp5_) {
#line 1404 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 14361 "tracker-sparql-expression.c"
		}
#line 1405 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = optype;
#line 1405 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp6_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 14367 "tracker-sparql-expression.c"
			GError* _tmp7_ = NULL;
#line 1406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp7_;
#line 1406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14379 "tracker-sparql-expression.c"
			} else {
#line 1406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1406 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14387 "tracker-sparql-expression.c"
			}
		}
#line 1408 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = sql;
#line 1408 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = begin;
#line 1408 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_insert (_tmp8_, (gssize) _tmp9_, "(");
#line 1409 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = sql;
#line 1409 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp10_, " AND ");
#line 1410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = sql;
#line 1410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = tracker_sparql_expression_translate_value_logical (self, _tmp11_, &_inner_error_);
#line 1410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = _tmp12_;
#line 1410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14414 "tracker-sparql-expression.c"
			} else {
#line 1410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14422 "tracker-sparql-expression.c"
			}
		}
#line 1410 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		optype = _tmp13_;
#line 1411 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp14_ = sql;
#line 1411 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp14_, ")");
#line 1412 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = optype;
#line 1412 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp15_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 14435 "tracker-sparql-expression.c"
			GError* _tmp16_ = NULL;
#line 1413 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1413 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp16_;
#line 1413 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1413 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1413 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14447 "tracker-sparql-expression.c"
			} else {
#line 1413 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1413 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1413 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14455 "tracker-sparql-expression.c"
			}
		}
	}
#line 1416 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1416 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 14463 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_conditional_or_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	gssize _tmp1_;
	glong begin;
	GString* _tmp2_;
	TrackerPropertyType _tmp3_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1419 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1419 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1420 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1420 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->len;
#line 1420 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	begin = (glong) _tmp1_;
#line 1421 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = sql;
#line 1421 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = tracker_sparql_expression_translate_conditional_and_expression (self, _tmp2_, &_inner_error_);
#line 1421 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp3_;
#line 1421 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1421 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1421 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1421 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14500 "tracker-sparql-expression.c"
		} else {
#line 1421 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1421 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1421 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14508 "tracker-sparql-expression.c"
		}
	}
#line 1422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	while (TRUE) {
#line 14513 "tracker-sparql-expression.c"
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
		TrackerPropertyType _tmp6_;
		GString* _tmp8_;
		glong _tmp9_;
		GString* _tmp10_;
		GString* _tmp11_;
		TrackerPropertyType _tmp12_ = 0;
		TrackerPropertyType _tmp13_;
		GString* _tmp14_;
		TrackerPropertyType _tmp15_;
#line 1422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_OR, &_inner_error_);
#line 1422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = _tmp4_;
#line 1422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14537 "tracker-sparql-expression.c"
			} else {
#line 1422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14545 "tracker-sparql-expression.c"
			}
		}
#line 1422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (!_tmp5_) {
#line 1422 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			break;
#line 14552 "tracker-sparql-expression.c"
		}
#line 1423 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = optype;
#line 1423 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp6_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 14558 "tracker-sparql-expression.c"
			GError* _tmp7_ = NULL;
#line 1424 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp7_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1424 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp7_;
#line 1424 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1424 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1424 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14570 "tracker-sparql-expression.c"
			} else {
#line 1424 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1424 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1424 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14578 "tracker-sparql-expression.c"
			}
		}
#line 1426 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = sql;
#line 1426 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp9_ = begin;
#line 1426 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_insert (_tmp8_, (gssize) _tmp9_, "(");
#line 1427 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp10_ = sql;
#line 1427 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp10_, " OR ");
#line 1428 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp11_ = sql;
#line 1428 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp12_ = tracker_sparql_expression_translate_conditional_and_expression (self, _tmp11_, &_inner_error_);
#line 1428 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp13_ = _tmp12_;
#line 1428 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1428 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1428 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1428 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14605 "tracker-sparql-expression.c"
			} else {
#line 1428 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1428 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1428 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14613 "tracker-sparql-expression.c"
			}
		}
#line 1428 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		optype = _tmp13_;
#line 1429 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp14_ = sql;
#line 1429 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp14_, ")");
#line 1430 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp15_ = optype;
#line 1430 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_tmp15_ != TRACKER_PROPERTY_TYPE_BOOLEAN) {
#line 14626 "tracker-sparql-expression.c"
			GError* _tmp16_ = NULL;
#line 1431 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp16_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
#line 1431 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_inner_error_ = _tmp16_;
#line 1431 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1431 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1431 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14638 "tracker-sparql-expression.c"
			} else {
#line 1431 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1431 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1431 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14646 "tracker-sparql-expression.c"
			}
		}
	}
#line 1434 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1434 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 14654 "tracker-sparql-expression.c"
}


TrackerPropertyType tracker_sparql_expression_translate_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	GString* _tmp0_;
	TrackerPropertyType _tmp1_ = 0;
	TrackerPropertyType _tmp2_;
	GError * _inner_error_ = NULL;
#line 1437 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1437 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1438 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = sql;
#line 1438 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = tracker_sparql_expression_translate_conditional_or_expression (self, _tmp0_, &_inner_error_);
#line 1438 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp2_ = _tmp1_;
#line 1438 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1438 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1438 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1438 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14682 "tracker-sparql-expression.c"
		} else {
#line 1438 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1438 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1438 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14690 "tracker-sparql-expression.c"
		}
	}
#line 1438 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp2_;
#line 1438 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 14697 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_bracketted_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerSparqlTokenType _tmp0_ = 0;
	GString* _tmp9_;
	TrackerPropertyType _tmp10_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1441 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1441 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1442 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1442 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1442 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1442 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1442 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14722 "tracker-sparql-expression.c"
		} else {
#line 1442 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1442 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1442 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14730 "tracker-sparql-expression.c"
		}
	}
#line 1444 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_current (self);
#line 1444 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp0_ == TRACKER_SPARQL_TOKEN_TYPE_SELECT) {
#line 14737 "tracker-sparql-expression.c"
		GString* _tmp1_;
		TrackerSparqlPattern* _tmp2_;
		TrackerSparqlPattern* _tmp3_;
		GString* _tmp4_;
		TrackerSparqlSelectContext* _tmp5_ = NULL;
		TrackerSparqlSelectContext* select_context;
		GString* _tmp6_;
		TrackerSparqlSelectContext* _tmp7_;
		TrackerPropertyType _tmp8_;
#line 1447 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp1_ = sql;
#line 1447 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp1_, "(");
#line 1448 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = tracker_sparql_expression_get_pattern (self);
#line 1448 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp3_ = _tmp2_;
#line 1448 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp4_ = sql;
#line 1448 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp5_ = tracker_sparql_pattern_translate_select (_tmp3_, _tmp4_, TRUE, TRUE, &_inner_error_);
#line 1448 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		select_context = _tmp5_;
#line 1448 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1448 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1448 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1448 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14769 "tracker-sparql-expression.c"
			} else {
#line 1448 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1448 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1448 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14777 "tracker-sparql-expression.c"
			}
		}
#line 1449 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp6_ = sql;
#line 1449 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp6_, ")");
#line 1451 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1451 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_ != NULL) {
#line 1451 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1451 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_propagate_error (error, _inner_error_);
#line 1451 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tracker_sparql_context_unref0 (select_context);
#line 1451 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14796 "tracker-sparql-expression.c"
			} else {
#line 1451 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				_tracker_sparql_context_unref0 (select_context);
#line 1451 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1451 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				g_clear_error (&_inner_error_);
#line 1451 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				return 0;
#line 14806 "tracker-sparql-expression.c"
			}
		}
#line 1452 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp7_ = select_context;
#line 1452 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp8_ = _tmp7_->type;
#line 1452 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		result = _tmp8_;
#line 1452 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tracker_sparql_context_unref0 (select_context);
#line 1452 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		return result;
#line 14819 "tracker-sparql-expression.c"
	}
#line 1455 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp9_ = sql;
#line 1455 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp10_ = tracker_sparql_expression_translate_expression (self, _tmp9_, &_inner_error_);
#line 1455 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp10_;
#line 1455 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1455 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1455 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1455 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14835 "tracker-sparql-expression.c"
		} else {
#line 1455 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1455 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1455 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14843 "tracker-sparql-expression.c"
		}
	}
#line 1456 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1456 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1456 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1456 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1456 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14856 "tracker-sparql-expression.c"
		} else {
#line 1456 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1456 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1456 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14864 "tracker-sparql-expression.c"
		}
	}
#line 1457 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1457 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 14871 "tracker-sparql-expression.c"
}


static TrackerPropertyType tracker_sparql_expression_translate_aggregate_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GString* _tmp3_;
	TrackerPropertyType _tmp4_ = 0;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
#line 1460 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1460 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1461 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1461 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1461 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1461 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1461 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14897 "tracker-sparql-expression.c"
		} else {
#line 1461 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1461 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1461 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14905 "tracker-sparql-expression.c"
		}
	}
#line 1462 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DISTINCT, &_inner_error_);
#line 1462 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_;
#line 1462 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1462 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1462 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1462 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14920 "tracker-sparql-expression.c"
		} else {
#line 1462 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1462 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1462 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14928 "tracker-sparql-expression.c"
		}
	}
#line 1462 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_tmp1_) {
#line 14933 "tracker-sparql-expression.c"
		GString* _tmp2_;
#line 1463 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		_tmp2_ = sql;
#line 1463 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		g_string_append (_tmp2_, "DISTINCT ");
#line 14939 "tracker-sparql-expression.c"
	}
#line 1465 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp3_ = sql;
#line 1465 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp4_ = tracker_sparql_expression_translate_expression (self, _tmp3_, &_inner_error_);
#line 1465 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	optype = _tmp4_;
#line 1465 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1465 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1465 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1465 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14955 "tracker-sparql-expression.c"
		} else {
#line 1465 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1465 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1465 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14963 "tracker-sparql-expression.c"
		}
	}
#line 1466 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1466 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	if (_inner_error_ != NULL) {
#line 1466 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1466 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_propagate_error (error, _inner_error_);
#line 1466 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14976 "tracker-sparql-expression.c"
		} else {
#line 1466 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1466 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			g_clear_error (&_inner_error_);
#line 1466 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return 0;
#line 14984 "tracker-sparql-expression.c"
		}
	}
#line 1467 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = optype;
#line 1467 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 14991 "tracker-sparql-expression.c"
}


TrackerPropertyType tracker_sparql_expression_translate_constraint (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerSparqlTokenType _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 1470 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1470 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 1471 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = tracker_sparql_expression_current (self);
#line 1471 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (_tmp0_) {
#line 1471 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
#line 1471 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
#line 1471 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
#line 1471 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
#line 1471 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
#line 1471 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IF:
#line 1471 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
#line 1471 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
#line 1471 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
#line 1471 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
#line 1471 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
#line 1471 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
#line 1471 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_EXISTS:
#line 1471 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NOT:
#line 15035 "tracker-sparql-expression.c"
		{
			GString* _tmp1_;
			TrackerPropertyType _tmp2_ = 0;
			TrackerPropertyType _tmp3_;
#line 1486 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp1_ = sql;
#line 1486 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp2_ = tracker_sparql_expression_translate_primary_expression (self, _tmp1_, &_inner_error_);
#line 1486 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp3_ = _tmp2_;
#line 1486 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1486 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1486 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1486 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 15054 "tracker-sparql-expression.c"
				} else {
#line 1486 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1486 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1486 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 15062 "tracker-sparql-expression.c"
				}
			}
#line 1486 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp3_;
#line 1486 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 15069 "tracker-sparql-expression.c"
		}
		default:
		{
			GString* _tmp4_;
			TrackerPropertyType _tmp5_ = 0;
			TrackerPropertyType _tmp6_;
#line 1488 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp4_ = sql;
#line 1488 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp5_ = tracker_sparql_expression_translate_bracketted_expression (self, _tmp4_, &_inner_error_);
#line 1488 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			_tmp6_ = _tmp5_;
#line 1488 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			if (_inner_error_ != NULL) {
#line 1488 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1488 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_propagate_error (error, _inner_error_);
#line 1488 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 15090 "tracker-sparql-expression.c"
				} else {
#line 1488 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1488 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					g_clear_error (&_inner_error_);
#line 1488 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
					return 0;
#line 15098 "tracker-sparql-expression.c"
				}
			}
#line 1488 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			result = _tmp6_;
#line 1488 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
			return result;
#line 15105 "tracker-sparql-expression.c"
		}
	}
}


static TrackerSparqlContext* tracker_sparql_expression_get_context (TrackerSparqlExpression* self) {
	TrackerSparqlContext* result;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlContext* _tmp1_;
#line 36 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 36 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 36 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->context;
#line 36 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp1_;
#line 36 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 15125 "tracker-sparql-expression.c"
}


static TrackerSparqlPattern* tracker_sparql_expression_get_pattern (TrackerSparqlExpression* self) {
	TrackerSparqlPattern* result;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlPattern* _tmp1_;
#line 40 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 40 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp0_ = self->priv->query;
#line 40 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_tmp1_ = _tmp0_->pattern;
#line 40 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	result = _tmp1_;
#line 40 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	return result;
#line 15143 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_class_init (TrackerSparqlExpressionClass * klass) {
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	tracker_sparql_expression_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlExpressionPrivate));
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_expression_get_property;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_expression_finalize;
#line 15156 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_instance_init (TrackerSparqlExpression * self) {
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	self->priv = TRACKER_SPARQL_EXPRESSION_GET_PRIVATE (self);
#line 15163 "tracker-sparql-expression.c"
}


static void tracker_sparql_expression_finalize (GObject* obj) {
	TrackerSparqlExpression * self;
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression);
#line 29 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	_g_free0 (self->priv->fts_sql);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	G_OBJECT_CLASS (tracker_sparql_expression_parent_class)->finalize (obj);
#line 15175 "tracker-sparql-expression.c"
}


GType tracker_sparql_expression_get_type (void) {
	static volatile gsize tracker_sparql_expression_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlExpression), 0, (GInstanceInitFunc) tracker_sparql_expression_instance_init, NULL };
		GType tracker_sparql_expression_type_id;
		tracker_sparql_expression_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlExpression", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_expression_type_id__volatile, tracker_sparql_expression_type_id);
	}
	return tracker_sparql_expression_type_id__volatile;
}


static void _vala_tracker_sparql_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
	switch (property_id) {
#line 15196 "tracker-sparql-expression.c"
		default:
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "/home/martyn/Source/checkout/gnome/tracker/src/libtracker-data/tracker-sparql-expression.vala"
		break;
#line 15202 "tracker-sparql-expression.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



