
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixdata.h>


#define TYPE_TRACKER_METADATA_TILE (tracker_metadata_tile_get_type ())
#define TRACKER_METADATA_TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_METADATA_TILE, TrackerMetadataTile))
#define TRACKER_METADATA_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_METADATA_TILE, TrackerMetadataTileClass))
#define IS_TRACKER_METADATA_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_METADATA_TILE))
#define IS_TRACKER_METADATA_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_METADATA_TILE))
#define TRACKER_METADATA_TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_METADATA_TILE, TrackerMetadataTileClass))

typedef struct _TrackerMetadataTile TrackerMetadataTile;
typedef struct _TrackerMetadataTileClass TrackerMetadataTileClass;
typedef struct _TrackerMetadataTilePrivate TrackerMetadataTilePrivate;

#define TYPE_CATEGORIES (categories_get_type ())

#define TYPE_TRACKER_RESULT_GRID (tracker_result_grid_get_type ())
#define TRACKER_RESULT_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_RESULT_GRID, TrackerResultGrid))
#define TRACKER_RESULT_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_RESULT_GRID, TrackerResultGridClass))
#define IS_TRACKER_RESULT_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_RESULT_GRID))
#define IS_TRACKER_RESULT_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_RESULT_GRID))
#define TRACKER_RESULT_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_RESULT_GRID, TrackerResultGridClass))

typedef struct _TrackerResultGrid TrackerResultGrid;
typedef struct _TrackerResultGridClass TrackerResultGridClass;

#define TYPE_TRACKER_QUERY (tracker_query_get_type ())
#define TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_QUERY, TrackerQuery))
#define TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_QUERY, TrackerQueryClass))
#define IS_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_QUERY))
#define IS_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_QUERY))
#define TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_QUERY, TrackerQueryClass))

typedef struct _TrackerQuery TrackerQuery;
typedef struct _TrackerQueryClass TrackerQueryClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TrackerResultGridPrivate TrackerResultGridPrivate;

#define TYPE_RESULT_COLUMNS (result_columns_get_type ())

typedef enum  {
	CATEGORIES_Application,
	CATEGORIES_Contact,
	CATEGORIES_Email,
	CATEGORIES_EmailAttachment,
	CATEGORIES_File,
	CATEGORIES_Folder,
	CATEGORIES_Music,
	CATEGORIES_Video,
	CATEGORIES_Image,
	CATEGORIES_Document,
	CATEGORIES_Text,
	CATEGORIES_Development,
	CATEGORIES_Web,
	CATEGORIES_WebHistory
} Categories;

struct _TrackerMetadataTile {
	GtkEventBox parent_instance;
	TrackerMetadataTilePrivate * priv;
	char* uri;
	Categories category;
	GtkImage* image;
	GtkLinkButton* name_link;
	GtkLinkButton* path_link;
	GtkTable* table;
	char* sparql;
	GtkLabel* name_label;
	GtkLabel* path_label;
	GtkLabel* info_label1;
	GtkLabel* info_value1;
	GtkLabel* info_label2;
	GtkLabel* info_value2;
	GtkLabel* info_label3;
	GtkLabel* info_value3;
	GtkLabel* info_label4;
	GtkLabel* info_value4;
	GtkLabel* info_label5;
	GtkLabel* info_value5;
	GtkLabel* info_label6;
	GtkLabel* info_value6;
	GtkLabel* info_label7;
	GtkLabel* info_value7;
	GtkLabel* info_label8;
	GtkLabel* info_value8;
};

struct _TrackerMetadataTileClass {
	GtkEventBoxClass parent_class;
};

struct _TrackerMetadataTilePrivate {
	TrackerResultGrid* _result_grid;
	TrackerQuery* _Query;
};

struct _TrackerResultGrid {
	GtkScrolledWindow parent_instance;
	TrackerResultGridPrivate * priv;
	GtkListStore* store;
	GtkIconView* iconview;
};

struct _TrackerResultGridClass {
	GtkScrolledWindowClass parent_class;
};

typedef enum  {
	RESULT_COLUMNS_Id,
	RESULT_COLUMNS_Uri,
	RESULT_COLUMNS_Icon,
	RESULT_COLUMNS_DisplayName,
	RESULT_COLUMNS_Mime,
	RESULT_COLUMNS_Category,
	RESULT_COLUMNS_Snippet,
	RESULT_COLUMNS_IsDirectory,
	RESULT_COLUMNS_Path,
	RESULT_COLUMNS_NumOfCols
} ResultColumns;


static gpointer tracker_metadata_tile_parent_class = NULL;

GType tracker_metadata_tile_get_type (void);
GType categories_get_type (void);
GType tracker_result_grid_get_type (void);
GType tracker_query_get_type (void);
#define TRACKER_METADATA_TILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TRACKER_METADATA_TILE, TrackerMetadataTilePrivate))
enum  {
	TRACKER_METADATA_TILE_DUMMY_PROPERTY,
	TRACKER_METADATA_TILE_QUERY,
	TRACKER_METADATA_TILE_RESULT_GRID
};
static gboolean tracker_metadata_tile_expose (TrackerMetadataTile* self, const GdkEventExpose* e);
static void tracker_metadata_tile_AttachToTable (TrackerMetadataTile* self, GtkLabel* lab, gint l, gint r, gint t, gint b, gboolean e);
static GtkLabel* tracker_metadata_tile_CreateLabel (TrackerMetadataTile* self, const char* s, gboolean e);
void tracker_metadata_tile_ClearLabels (TrackerMetadataTile* self);
void tracker_metadata_tile_SetLabelValue (TrackerMetadataTile* self, GtkLabel* label, const char* val);
char* tracker_utils_FormatFileSize (gint64 size);
void tracker_metadata_tile_SetLabelSizeValue (TrackerMetadataTile* self, GtkLabel* label, gint64 size);
void tracker_metadata_tile_SetLabelUrnValue (TrackerMetadataTile* self, GtkLabel* label, const char* val);
TrackerQuery* tracker_metadata_tile_get_Query (TrackerMetadataTile* self);
char** tracker_query_Query (TrackerQuery* self, const char* sparql, int* result_length1, int* result_length2);
static Categories tracker_metadata_tile_GetCategory (TrackerMetadataTile* self, const char* uri);
static void tracker_metadata_tile_DisplayFileDetails (TrackerMetadataTile* self, const char* uri, const char* mime);
static void tracker_metadata_tile_DisplayImageDetails (TrackerMetadataTile* self, const char* uri);
static void tracker_metadata_tile_DisplayMusicDetails (TrackerMetadataTile* self, const char* uri);
static void tracker_metadata_tile_DisplayVideoDetails (TrackerMetadataTile* self, const char* uri);
static void tracker_metadata_tile_DisplayDocumentDetails (TrackerMetadataTile* self, const char* uri);
static void tracker_metadata_tile_DisplayApplicationDetails (TrackerMetadataTile* self, const char* uri);
GType result_columns_get_type (void);
void tracker_metadata_tile_LoadUri (TrackerMetadataTile* self, const GtkTreePath* path);
TrackerMetadataTile* tracker_metadata_tile_new (void);
TrackerMetadataTile* tracker_metadata_tile_construct (GType object_type);
void tracker_metadata_tile_set_Query (TrackerMetadataTile* self, TrackerQuery* value);
TrackerResultGrid* tracker_metadata_tile_get_ResultGrid (TrackerMetadataTile* self);
static void _lambda6_ (const GtkTreePath* path, TrackerMetadataTile* self);
static void __lambda6__tracker_result_grid_selection_changed (TrackerResultGrid* _sender, const GtkTreePath* path, gpointer self);
void tracker_metadata_tile_set_ResultGrid (TrackerMetadataTile* self, TrackerResultGrid* value);
static gboolean _tracker_metadata_tile_expose_gtk_widget_expose_event (TrackerMetadataTile* _sender, const GdkEventExpose* event, gpointer self);
static GObject * tracker_metadata_tile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void tracker_metadata_tile_finalize (GObject* obj);
static void tracker_metadata_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void tracker_metadata_tile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 154 "tracker-metadata-tile.gs"
static gboolean tracker_metadata_tile_expose (TrackerMetadataTile* self, const GdkEventExpose* e) {
#line 196 "tracker-metadata-tile.c"
	gboolean result;
	cairo_t* cr;
	GtkStyle* style;
	GdkColor step1;
	GdkColor step2;
	double w;
	double h;
	cairo_pattern_t* pat;
#line 154 "tracker-metadata-tile.gs"
	g_return_val_if_fail (self != NULL, FALSE);
#line 207 "tracker-metadata-tile.c"
	cr = gdk_cairo_create ((GdkDrawable*) ((GtkWidget*) self)->window);
	style = _g_object_ref0 (gtk_widget_get_style ((GtkWidget*) self));
	step1 = style->base[GTK_STATE_NORMAL];
	step2 = style->bg[GTK_STATE_SELECTED];
	w = 0.0;
	h = 0.0;
#line 163 "tracker-metadata-tile.gs"
	w = (double) ((GtkWidget*) self)->allocation.width;
#line 164 "tracker-metadata-tile.gs"
	h = (double) ((GtkWidget*) self)->allocation.height;
#line 167 "tracker-metadata-tile.gs"
	cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);
#line 168 "tracker-metadata-tile.gs"
	gdk_cairo_set_source_color (cr, &step1);
#line 169 "tracker-metadata-tile.gs"
	cairo_paint (cr);
#line 170 "tracker-metadata-tile.gs"
	cairo_move_to (cr, (double) 0, (double) 0);
#line 171 "tracker-metadata-tile.gs"
	cairo_set_line_width (cr, 1.0);
#line 172 "tracker-metadata-tile.gs"
	cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
#line 230 "tracker-metadata-tile.c"
	pat = cairo_pattern_create_linear (0.0, 0.0, 0.0, h);
#line 177 "tracker-metadata-tile.gs"
	cairo_pattern_add_color_stop_rgba (pat, 0.0, step2.red / 65535.0, step2.green / 65535.0, step2.blue / 65535.0, 0.05);
#line 179 "tracker-metadata-tile.gs"
	cairo_pattern_add_color_stop_rgba (pat, 1.0, step2.red / 65535.0, step2.green / 65535.0, step2.blue / 65535.0, 0.5);
#line 181 "tracker-metadata-tile.gs"
	cairo_rectangle (cr, (double) 0, (double) 0, w, h);
#line 182 "tracker-metadata-tile.gs"
	cairo_set_source (cr, pat);
#line 183 "tracker-metadata-tile.gs"
	cairo_fill (cr);
#line 186 "tracker-metadata-tile.gs"
	cairo_set_source_rgba (cr, step2.red / 65535.0, step2.green / 65535.0, step2.blue / 65535.0, 0.7);
#line 187 "tracker-metadata-tile.gs"
	cairo_move_to (cr, (double) 0, (double) 0);
#line 188 "tracker-metadata-tile.gs"
	cairo_line_to (cr, w, (double) 0);
#line 189 "tracker-metadata-tile.gs"
	cairo_stroke (cr);
#line 192 "tracker-metadata-tile.gs"
	cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, 0.5);
#line 193 "tracker-metadata-tile.gs"
	cairo_move_to (cr, (double) 0, (double) 1);
#line 194 "tracker-metadata-tile.gs"
	cairo_line_to (cr, w, (double) 1);
#line 195 "tracker-metadata-tile.gs"
	cairo_stroke (cr);
#line 258 "tracker-metadata-tile.c"
	result = GTK_WIDGET_CLASS (tracker_metadata_tile_parent_class)->expose_event ((GtkWidget*) GTK_EVENT_BOX (self), &(*e));
	_cairo_destroy0 (cr);
	_g_object_unref0 (style);
	_cairo_pattern_destroy0 (pat);
	return result;
}


#line 200 "tracker-metadata-tile.gs"
static void tracker_metadata_tile_AttachToTable (TrackerMetadataTile* self, GtkLabel* lab, gint l, gint r, gint t, gint b, gboolean e) {
#line 200 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 200 "tracker-metadata-tile.gs"
	g_return_if_fail (lab != NULL);
#line 201 "tracker-metadata-tile.gs"
	if (e == TRUE) {
#line 202 "tracker-metadata-tile.gs"
		gtk_table_attach (self->table, (GtkWidget*) lab, (guint) l, (guint) r, (guint) t, (guint) b, GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
#line 277 "tracker-metadata-tile.c"
	} else {
#line 204 "tracker-metadata-tile.gs"
		gtk_table_attach (self->table, (GtkWidget*) lab, (guint) l, (guint) r, (guint) t, (guint) b, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 281 "tracker-metadata-tile.c"
	}
}


#line 206 "tracker-metadata-tile.gs"
static GtkLabel* tracker_metadata_tile_CreateLabel (TrackerMetadataTile* self, const char* s, gboolean e) {
#line 288 "tracker-metadata-tile.c"
	GtkLabel* result;
	GtkLabel* l;
#line 206 "tracker-metadata-tile.gs"
	g_return_val_if_fail (self != NULL, NULL);
#line 206 "tracker-metadata-tile.gs"
	g_return_val_if_fail (s != NULL, NULL);
#line 295 "tracker-metadata-tile.c"
	l = g_object_ref_sink ((GtkLabel*) gtk_label_new (s));
#line 208 "tracker-metadata-tile.gs"
	g_object_set ((GtkMisc*) l, "xalign", (float) 0, NULL);
#line 209 "tracker-metadata-tile.gs"
	gtk_label_set_use_markup (l, TRUE);
#line 211 "tracker-metadata-tile.gs"
	if (e == TRUE) {
#line 212 "tracker-metadata-tile.gs"
		gtk_label_set_ellipsize (l, PANGO_ELLIPSIZE_END);
#line 305 "tracker-metadata-tile.c"
	}
	result = l;
	return result;
}


#line 217 "tracker-metadata-tile.gs"
void tracker_metadata_tile_ClearLabels (TrackerMetadataTile* self) {
#line 217 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 218 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value1, "");
#line 219 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value2, "");
#line 220 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value3, "");
#line 221 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value4, "");
#line 222 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value5, "");
#line 223 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value6, "");
#line 224 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label4, "");
#line 225 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label5, "");
#line 226 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label6, "");
#line 228 "tracker-metadata-tile.gs"
	gtk_link_button_set_uri (self->name_link, "");
#line 229 "tracker-metadata-tile.gs"
	gtk_button_set_label ((GtkButton*) self->name_link, "");
#line 230 "tracker-metadata-tile.gs"
	gtk_link_button_set_uri (self->path_link, "");
#line 231 "tracker-metadata-tile.gs"
	gtk_button_set_label ((GtkButton*) self->path_link, "");
#line 342 "tracker-metadata-tile.c"
}


#line 234 "tracker-metadata-tile.gs"
void tracker_metadata_tile_SetLabelValue (TrackerMetadataTile* self, GtkLabel* label, const char* val) {
#line 348 "tracker-metadata-tile.c"
	char* val1;
#line 234 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 234 "tracker-metadata-tile.gs"
	g_return_if_fail (label != NULL);
#line 234 "tracker-metadata-tile.gs"
	g_return_if_fail (val != NULL);
#line 356 "tracker-metadata-tile.c"
	val1 = g_strdup_printf ("<b>%s</b>", val);
#line 236 "tracker-metadata-tile.gs"
	gtk_label_set_markup (label, val1);
#line 237 "tracker-metadata-tile.gs"
	g_object_set ((GtkMisc*) label, "xalign", (float) 0, NULL);
#line 362 "tracker-metadata-tile.c"
	_g_free0 (val1);
}


#line 239 "tracker-metadata-tile.gs"
void tracker_metadata_tile_SetLabelSizeValue (TrackerMetadataTile* self, GtkLabel* label, gint64 size) {
#line 369 "tracker-metadata-tile.c"
	char* _tmp0_;
	char* _tmp1_;
	char* val1;
#line 239 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 239 "tracker-metadata-tile.gs"
	g_return_if_fail (label != NULL);
#line 377 "tracker-metadata-tile.c"
	val1 = (_tmp1_ = g_strdup_printf ("<b>%s</b>", _tmp0_ = tracker_utils_FormatFileSize (size)), _g_free0 (_tmp0_), _tmp1_);
#line 241 "tracker-metadata-tile.gs"
	gtk_label_set_markup (label, val1);
#line 242 "tracker-metadata-tile.gs"
	g_object_set ((GtkMisc*) label, "xalign", (float) 0, NULL);
#line 383 "tracker-metadata-tile.c"
	_g_free0 (val1);
}


#line 245 "tracker-metadata-tile.gs"
void tracker_metadata_tile_SetLabelUrnValue (TrackerMetadataTile* self, GtkLabel* label, const char* val) {
#line 390 "tracker-metadata-tile.c"
	char* value;
	char** _tmp1_;
	gint values_size;
	gint values_length1;
	char** _tmp0_;
	char** values;
	char** _tmp4_;
	gint escapes_size;
	gint escapes_length1;
	char** _tmp3_;
	char** escapes;
	char* _tmp5_;
	char* val1;
#line 245 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 245 "tracker-metadata-tile.gs"
	g_return_if_fail (label != NULL);
#line 245 "tracker-metadata-tile.gs"
	g_return_if_fail (val != NULL);
#line 410 "tracker-metadata-tile.c"
	value = g_strdup (val);
	values = (_tmp1_ = _tmp0_ = g_strsplit (val, ":", 0), values_length1 = _vala_array_length (_tmp0_), values_size = values_length1, _tmp1_);
	{
		char** s_collection;
		int s_collection_length1;
		int s_it;
#line 250 "tracker-metadata-tile.gs"
		s_collection = values;
#line 419 "tracker-metadata-tile.c"
		s_collection_length1 = values_length1;
		for (s_it = 0; s_it < values_length1; s_it = s_it + 1) {
			char* s;
			s = g_strdup (s_collection[s_it]);
			{
				char* _tmp2_;
#line 251 "tracker-metadata-tile.gs"
				value = (_tmp2_ = g_strdup (s), _g_free0 (value), _tmp2_);
#line 428 "tracker-metadata-tile.c"
				_g_free0 (s);
			}
		}
	}
	escapes = (_tmp4_ = _tmp3_ = g_strsplit (value, "%20", 0), escapes_length1 = _vala_array_length (_tmp3_), escapes_size = escapes_length1, _tmp4_);
#line 254 "tracker-metadata-tile.gs"
	value = (_tmp5_ = g_strdup (""), _g_free0 (value), _tmp5_);
#line 436 "tracker-metadata-tile.c"
	{
		char** s_collection;
		int s_collection_length1;
		int s_it;
#line 255 "tracker-metadata-tile.gs"
		s_collection = escapes;
#line 443 "tracker-metadata-tile.c"
		s_collection_length1 = escapes_length1;
		for (s_it = 0; s_it < escapes_length1; s_it = s_it + 1) {
			char* s;
			s = g_strdup (s_collection[s_it]);
			{
				char* _tmp7_;
				char* _tmp6_;
#line 256 "tracker-metadata-tile.gs"
				value = (_tmp7_ = g_strconcat (value, _tmp6_ = g_strconcat (s, " ", NULL), NULL), _g_free0 (value), _tmp7_);
#line 453 "tracker-metadata-tile.c"
				_g_free0 (_tmp6_);
				_g_free0 (s);
			}
		}
	}
	val1 = g_strdup_printf ("<b>%s</b>", value);
#line 259 "tracker-metadata-tile.gs"
	gtk_label_set_markup (label, val1);
#line 260 "tracker-metadata-tile.gs"
	g_object_set ((GtkMisc*) label, "xalign", (float) 0, NULL);
#line 464 "tracker-metadata-tile.c"
	_g_free0 (value);
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
	escapes = (_vala_array_free (escapes, escapes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (val1);
}


#line 964 "glib-2.0.vapi"
static gboolean string_contains (const char* self, const char* needle) {
#line 474 "tracker-metadata-tile.c"
	gboolean result;
#line 964 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 964 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 480 "tracker-metadata-tile.c"
	result = strstr (self, needle) != NULL;
	return result;
}


#line 265 "tracker-metadata-tile.gs"
static Categories tracker_metadata_tile_GetCategory (TrackerMetadataTile* self, const char* uri) {
#line 488 "tracker-metadata-tile.c"
	Categories result;
	char* query;
	char** _tmp2_;
	gint results_length2;
	gint results_length1;
	gint _tmp1_;
	gint _tmp0_;
	char** results;
	char* res;
#line 265 "tracker-metadata-tile.gs"
	g_return_val_if_fail (self != NULL, 0);
#line 265 "tracker-metadata-tile.gs"
	g_return_val_if_fail (uri != NULL, 0);
#line 502 "tracker-metadata-tile.c"
	query = g_strdup_printf ("select rdf:type(?s) where { ?s nie:url \"%s\" }", uri);
	results = (_tmp2_ = tracker_query_Query (self->priv->_Query, query, &_tmp0_, &_tmp1_), results_length1 = _tmp0_, results_length2 = _tmp1_, _tmp2_);
	res = g_strdup ("");
	{
		char** s_collection;
		int s_collection_length1;
		int s_it;
#line 269 "tracker-metadata-tile.gs"
		s_collection = results;
#line 512 "tracker-metadata-tile.c"
		s_collection_length1 = results_length1 * results_length2;
		for (s_it = 0; s_it < (results_length1 * results_length2); s_it = s_it + 1) {
			char* s;
			s = g_strdup (s_collection[s_it]);
			{
				char* _tmp3_;
#line 270 "tracker-metadata-tile.gs"
				res = (_tmp3_ = g_strconcat (res, s, NULL), _g_free0 (res), _tmp3_);
#line 521 "tracker-metadata-tile.c"
				_g_free0 (s);
			}
		}
	}
#line 272 "tracker-metadata-tile.gs"
	if (string_contains (res, "nfo#Video")) {
#line 528 "tracker-metadata-tile.c"
		result = CATEGORIES_Video;
		_g_free0 (query);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (res);
		return result;
	}
#line 273 "tracker-metadata-tile.gs"
	if (string_contains (res, "nfo#Image")) {
#line 537 "tracker-metadata-tile.c"
		result = CATEGORIES_Image;
		_g_free0 (query);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (res);
		return result;
	}
#line 274 "tracker-metadata-tile.gs"
	if (string_contains (res, "nfo#Audio")) {
#line 546 "tracker-metadata-tile.c"
		result = CATEGORIES_Music;
		_g_free0 (query);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (res);
		return result;
	}
#line 275 "tracker-metadata-tile.gs"
	if (string_contains (res, "nfo#Document")) {
#line 555 "tracker-metadata-tile.c"
		result = CATEGORIES_Document;
		_g_free0 (query);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (res);
		return result;
	}
#line 276 "tracker-metadata-tile.gs"
	if (string_contains (res, "nfo#Software")) {
#line 564 "tracker-metadata-tile.c"
		result = CATEGORIES_Application;
		_g_free0 (query);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (res);
		return result;
	}
#line 277 "tracker-metadata-tile.gs"
	if (string_contains (res, "nfo#Folder")) {
#line 573 "tracker-metadata-tile.c"
		result = CATEGORIES_Folder;
		_g_free0 (query);
		results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
		_g_free0 (res);
		return result;
	}
	result = CATEGORIES_File;
	_g_free0 (query);
	results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
	_g_free0 (res);
	return result;
}


#line 282 "tracker-metadata-tile.gs"
static void tracker_metadata_tile_DisplayFileDetails (TrackerMetadataTile* self, const char* uri, const char* mime) {
#line 590 "tracker-metadata-tile.c"
	GError * _inner_error_;
	GFile* file;
	char* filepath;
	GFile* displaypath;
	char* _tmp0_;
	char* _tmp1_;
#line 282 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 282 "tracker-metadata-tile.gs"
	g_return_if_fail (uri != NULL);
#line 282 "tracker-metadata-tile.gs"
	g_return_if_fail (mime != NULL);
#line 603 "tracker-metadata-tile.c"
	_inner_error_ = NULL;
	file = g_file_new_for_uri (uri);
	filepath = g_file_get_basename (file);
	displaypath = g_file_get_parent (file);
#line 287 "tracker-metadata-tile.gs"
	gtk_link_button_set_uri (self->name_link, uri);
#line 288 "tracker-metadata-tile.gs"
	gtk_button_set_label ((GtkButton*) self->name_link, filepath);
#line 289 "tracker-metadata-tile.gs"
	gtk_link_button_set_uri (self->path_link, _tmp0_ = g_file_get_uri (displaypath));
#line 614 "tracker-metadata-tile.c"
	_g_free0 (_tmp0_);
#line 290 "tracker-metadata-tile.gs"
	gtk_button_set_label ((GtkButton*) self->path_link, _tmp1_ = g_file_get_path (displaypath));
#line 618 "tracker-metadata-tile.c"
	_g_free0 (_tmp1_);
#line 293 "tracker-metadata-tile.gs"
	tracker_metadata_tile_SetLabelValue (self, self->info_value1, mime);
#line 622 "tracker-metadata-tile.c"
	{
		GFileInfo* info;
		GTimeVal tm = {0};
		char* _tmp2_;
		char* _tmp3_;
		char* val3;
		info = g_file_query_info (file, "standard::size,time::modified", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
			goto __finally8;
		}
#line 299 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelSizeValue (self, self->info_value2, g_file_info_get_size (info));
#line 302 "tracker-metadata-tile.gs"
		g_file_info_get_modification_time (info, &tm);
#line 638 "tracker-metadata-tile.c"
		val3 = (_tmp3_ = g_strdup_printf ("<b>%s</b>", _tmp2_ = g_time_val_to_iso8601 (&tm)), _g_free0 (_tmp2_), _tmp3_);
#line 306 "tracker-metadata-tile.gs"
		gtk_label_set_markup (self->info_value3, val3);
#line 642 "tracker-metadata-tile.c"
		_g_object_unref0 (info);
		_g_free0 (val3);
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 309 "tracker-metadata-tile.gs"
			g_print ("Could not get file info for %s\n", uri);
#line 655 "tracker-metadata-tile.c"
			_g_error_free0 (e);
		}
	}
	__finally8:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		_g_free0 (filepath);
		_g_object_unref0 (displaypath);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (file);
	_g_free0 (filepath);
	_g_object_unref0 (displaypath);
}


#line 312 "tracker-metadata-tile.gs"
static void tracker_metadata_tile_DisplayImageDetails (TrackerMetadataTile* self, const char* uri) {
#line 676 "tracker-metadata-tile.c"
	char* query;
	char** _tmp2_;
	gint _result__length2;
	gint _result__length1;
	gint _tmp1_;
	gint _tmp0_;
	char** _result_;
#line 312 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 312 "tracker-metadata-tile.gs"
	g_return_if_fail (uri != NULL);
#line 688 "tracker-metadata-tile.c"
	query = g_strdup_printf ("select nfo:height(?s) nfo:width(?s) Where { ?s nie:url \"%s\" }", uri);
	_result_ = (_tmp2_ = tracker_query_Query (self->priv->_Query, query, &_tmp0_, &_tmp1_), _result__length1 = _tmp0_, _result__length2 = _tmp1_, _tmp2_);
#line 316 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label4, N_ ("Height:"));
#line 317 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label5, N_ ("Width:"));
#line 319 "tracker-metadata-tile.gs"
	if (_result_ != NULL) {
#line 320 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelValue (self, self->info_value4, _result_[0]);
#line 321 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelValue (self, self->info_value5, _result_[1]);
#line 701 "tracker-metadata-tile.c"
	}
	_g_free0 (query);
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
}


#line 325 "tracker-metadata-tile.gs"
static void tracker_metadata_tile_DisplayMusicDetails (TrackerMetadataTile* self, const char* uri) {
#line 710 "tracker-metadata-tile.c"
	char* query;
	char** _tmp2_;
	gint _result__length2;
	gint _result__length1;
	gint _tmp1_;
	gint _tmp0_;
	char** _result_;
#line 325 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 325 "tracker-metadata-tile.gs"
	g_return_if_fail (uri != NULL);
#line 722 "tracker-metadata-tile.c"
	query = g_strdup_printf ("select nie:title(?s) nmm:performer(?s) nmm:musicAlbum(?s) Where { ?s nie:url \"%s\" }", uri);
	_result_ = (_tmp2_ = tracker_query_Query (self->priv->_Query, query, &_tmp0_, &_tmp1_), _result__length1 = _tmp0_, _result__length2 = _tmp1_, _tmp2_);
#line 329 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label4, N_ ("Title:"));
#line 330 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label5, N_ ("Artist:"));
#line 331 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label6, N_ ("Album:"));
#line 333 "tracker-metadata-tile.gs"
	if (_result_ != NULL) {
#line 334 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelValue (self, self->info_value4, _result_[0]);
#line 335 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelUrnValue (self, self->info_value5, _result_[1]);
#line 336 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelUrnValue (self, self->info_value6, _result_[2]);
#line 739 "tracker-metadata-tile.c"
	}
	_g_free0 (query);
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
}


#line 338 "tracker-metadata-tile.gs"
static void tracker_metadata_tile_DisplayVideoDetails (TrackerMetadataTile* self, const char* uri) {
#line 748 "tracker-metadata-tile.c"
	char* query;
	char** _tmp2_;
	gint _result__length2;
	gint _result__length1;
	gint _tmp1_;
	gint _tmp0_;
	char** _result_;
#line 338 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 338 "tracker-metadata-tile.gs"
	g_return_if_fail (uri != NULL);
#line 760 "tracker-metadata-tile.c"
	query = g_strdup_printf ("select nfo:height(?s) nfo:width(?s) nfo:duration (?s) Where { ?s nie:url \"%s\" }", uri);
	_result_ = (_tmp2_ = tracker_query_Query (self->priv->_Query, query, &_tmp0_, &_tmp1_), _result__length1 = _tmp0_, _result__length2 = _tmp1_, _tmp2_);
#line 342 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label4, N_ ("Height:"));
#line 343 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label5, N_ ("Width:"));
#line 344 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label6, N_ ("Duration:"));
#line 346 "tracker-metadata-tile.gs"
	if (_result_ != NULL) {
#line 347 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelValue (self, self->info_value4, _result_[0]);
#line 348 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelValue (self, self->info_value5, _result_[1]);
#line 349 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelValue (self, self->info_value6, _result_[2]);
#line 777 "tracker-metadata-tile.c"
	}
	_g_free0 (query);
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
}


#line 351 "tracker-metadata-tile.gs"
static void tracker_metadata_tile_DisplayDocumentDetails (TrackerMetadataTile* self, const char* uri) {
#line 786 "tracker-metadata-tile.c"
	char* query;
	char** _tmp2_;
	gint _result__length2;
	gint _result__length1;
	gint _tmp1_;
	gint _tmp0_;
	char** _result_;
#line 351 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 351 "tracker-metadata-tile.gs"
	g_return_if_fail (uri != NULL);
#line 798 "tracker-metadata-tile.c"
	query = g_strdup_printf ("select nie:title(?s) nco:creator(?s) nfo:pageCount (?s) Where { ?s nie:url \"%s\" }", uri);
	_result_ = (_tmp2_ = tracker_query_Query (self->priv->_Query, query, &_tmp0_, &_tmp1_), _result__length1 = _tmp0_, _result__length2 = _tmp1_, _tmp2_);
#line 355 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label4, N_ ("Title:"));
#line 356 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label5, N_ ("Author:"));
#line 357 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_label6, N_ ("Page count:"));
#line 359 "tracker-metadata-tile.gs"
	if (_result_ != NULL) {
#line 360 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelValue (self, self->info_value4, _result_[0]);
#line 361 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelValue (self, self->info_value5, _result_[1]);
#line 362 "tracker-metadata-tile.gs"
		tracker_metadata_tile_SetLabelValue (self, self->info_value6, _result_[2]);
#line 815 "tracker-metadata-tile.c"
	}
	_g_free0 (query);
	_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
}


#line 364 "tracker-metadata-tile.gs"
static void tracker_metadata_tile_DisplayApplicationDetails (TrackerMetadataTile* self, const char* uri) {
#line 364 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 364 "tracker-metadata-tile.gs"
	g_return_if_fail (uri != NULL);
#line 828 "tracker-metadata-tile.c"
	return;
}


#line 367 "tracker-metadata-tile.gs"
void tracker_metadata_tile_LoadUri (TrackerMetadataTile* self, const GtkTreePath* path) {
#line 835 "tracker-metadata-tile.c"
	GtkTreeIter iter = {0};
	const char* id;
	const char* uri;
	const char* mime;
	GdkPixbuf* icon;
	Categories cat;
#line 367 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 368 "tracker-metadata-tile.gs"
	tracker_metadata_tile_ClearLabels (self);
#line 370 "tracker-metadata-tile.gs"
	if (path == NULL) {
#line 371 "tracker-metadata-tile.gs"
		gtk_image_set_from_icon_name (self->image, "text-x-generic", GTK_ICON_SIZE_DIALOG);
#line 850 "tracker-metadata-tile.c"
		return;
	}
	id = NULL;
	uri = NULL;
	mime = NULL;
	icon = NULL;
#line 378 "tracker-metadata-tile.gs"
	gtk_tree_model_get_iter ((GtkTreeModel*) self->priv->_result_grid->store, &iter, path);
#line 379 "tracker-metadata-tile.gs"
	gtk_tree_model_get ((GtkTreeModel*) self->priv->_result_grid->store, &iter, RESULT_COLUMNS_Id, &id, RESULT_COLUMNS_Uri, &uri, RESULT_COLUMNS_Mime, &mime, RESULT_COLUMNS_Icon, &icon, -1);
#line 861 "tracker-metadata-tile.c"
	cat = tracker_metadata_tile_GetCategory (self, uri);
#line 385 "tracker-metadata-tile.gs"
	if (cat != CATEGORIES_Application) {
#line 386 "tracker-metadata-tile.gs"
		tracker_metadata_tile_DisplayFileDetails (self, uri, mime);
#line 387 "tracker-metadata-tile.gs"
		gtk_image_set_from_pixbuf (self->image, icon);
#line 869 "tracker-metadata-tile.c"
	}
#line 389 "tracker-metadata-tile.gs"
	switch (cat) {
#line 873 "tracker-metadata-tile.c"
		case CATEGORIES_Application:
		{
#line 390 "tracker-metadata-tile.gs"
			tracker_metadata_tile_DisplayApplicationDetails (self, uri);
#line 389 "tracker-metadata-tile.gs"
			break;
#line 880 "tracker-metadata-tile.c"
		}
		case CATEGORIES_Music:
		{
#line 391 "tracker-metadata-tile.gs"
			tracker_metadata_tile_DisplayMusicDetails (self, uri);
#line 389 "tracker-metadata-tile.gs"
			break;
#line 888 "tracker-metadata-tile.c"
		}
		case CATEGORIES_Video:
		{
#line 392 "tracker-metadata-tile.gs"
			tracker_metadata_tile_DisplayVideoDetails (self, uri);
#line 389 "tracker-metadata-tile.gs"
			break;
#line 896 "tracker-metadata-tile.c"
		}
		case CATEGORIES_Image:
		{
#line 393 "tracker-metadata-tile.gs"
			tracker_metadata_tile_DisplayImageDetails (self, uri);
#line 389 "tracker-metadata-tile.gs"
			break;
#line 904 "tracker-metadata-tile.c"
		}
		case CATEGORIES_Document:
		{
#line 394 "tracker-metadata-tile.gs"
			tracker_metadata_tile_DisplayDocumentDetails (self, uri);
#line 389 "tracker-metadata-tile.gs"
			break;
#line 912 "tracker-metadata-tile.c"
		}
		default:
		{
			_g_object_unref0 (icon);
			return;
#line 389 "tracker-metadata-tile.gs"
			break;
#line 920 "tracker-metadata-tile.c"
		}
	}
	_g_object_unref0 (icon);
}


#line 29 "tracker-metadata-tile.gs"
TrackerMetadataTile* tracker_metadata_tile_construct (GType object_type) {
#line 929 "tracker-metadata-tile.c"
	TrackerMetadataTile * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


#line 29 "tracker-metadata-tile.gs"
TrackerMetadataTile* tracker_metadata_tile_new (void) {
#line 29 "tracker-metadata-tile.gs"
	return tracker_metadata_tile_construct (TYPE_TRACKER_METADATA_TILE);
#line 940 "tracker-metadata-tile.c"
}


TrackerQuery* tracker_metadata_tile_get_Query (TrackerMetadataTile* self) {
	TrackerQuery* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Query;
	return result;
}


void tracker_metadata_tile_set_Query (TrackerMetadataTile* self, TrackerQuery* value) {
	g_return_if_fail (self != NULL);
	self->priv->_Query = value;
	g_object_notify ((GObject *) self, "Query");
}


TrackerResultGrid* tracker_metadata_tile_get_ResultGrid (TrackerMetadataTile* self) {
	TrackerResultGrid* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_result_grid;
	return result;
}


static void _lambda6_ (const GtkTreePath* path, TrackerMetadataTile* self) {
#line 80 "tracker-metadata-tile.gs"
	tracker_metadata_tile_LoadUri (self, path);
#line 970 "tracker-metadata-tile.c"
}


static void __lambda6__tracker_result_grid_selection_changed (TrackerResultGrid* _sender, const GtkTreePath* path, gpointer self) {
	_lambda6_ (path, self);
}


void tracker_metadata_tile_set_ResultGrid (TrackerMetadataTile* self, TrackerResultGrid* value) {
	g_return_if_fail (self != NULL);
#line 76 "tracker-metadata-tile.gs"
	if (value != NULL) {
#line 983 "tracker-metadata-tile.c"
		TrackerResultGrid* _tmp0_;
#line 77 "tracker-metadata-tile.gs"
		self->priv->_result_grid = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_result_grid), _tmp0_);
#line 79 "tracker-metadata-tile.gs"
		g_signal_connect_object (self->priv->_result_grid, "selection-changed", (GCallback) __lambda6__tracker_result_grid_selection_changed, self, 0);
#line 989 "tracker-metadata-tile.c"
	}
	g_object_notify ((GObject *) self, "ResultGrid");
}


#line 154 "tracker-metadata-tile.gs"
static gboolean _tracker_metadata_tile_expose_gtk_widget_expose_event (TrackerMetadataTile* _sender, const GdkEventExpose* event, gpointer self) {
#line 997 "tracker-metadata-tile.c"
	return tracker_metadata_tile_expose (self, event);
}


static GObject * tracker_metadata_tile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	TrackerMetadataTileClass * klass;
	GObjectClass * parent_class;
	TrackerMetadataTile * self;
	klass = TRACKER_METADATA_TILE_CLASS (g_type_class_peek (TYPE_TRACKER_METADATA_TILE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = TRACKER_METADATA_TILE (obj);
	{
		GtkTable* _tmp0_;
		GtkImage* _tmp1_;
		GtkLinkButton* _tmp2_;
		GtkLabel* _tmp3_;
		GtkLinkButton* _tmp4_;
		GtkLabel* _tmp5_;
		GtkLabel* _tmp6_;
		GtkLabel* _tmp7_;
		GtkLabel* _tmp8_;
		GtkLabel* _tmp9_;
		GtkLabel* _tmp10_;
		GtkLabel* _tmp11_;
		GtkLabel* _tmp12_;
		GtkLabel* _tmp13_;
		GtkLabel* _tmp14_;
		GtkLabel* _tmp15_;
		GtkLabel* _tmp16_;
		GtkLabel* _tmp17_;
		char* _tmp18_;
#line 85 "tracker-metadata-tile.gs"
		gtk_widget_set_app_paintable ((GtkWidget*) self, TRUE);
#line 87 "tracker-metadata-tile.gs"
		g_signal_connect_object ((GtkWidget*) self, "expose-event", (GCallback) _tracker_metadata_tile_expose_gtk_widget_expose_event, self, 0);
#line 89 "tracker-metadata-tile.gs"
		gtk_container_set_border_width ((GtkContainer*) self, (guint) 0);
#line 91 "tracker-metadata-tile.gs"
		self->table = (_tmp0_ = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) 5, (guint) 7, FALSE)), _g_object_unref0 (self->table), _tmp0_);
#line 92 "tracker-metadata-tile.gs"
		gtk_table_set_col_spacings (self->table, (guint) 3);
#line 93 "tracker-metadata-tile.gs"
		gtk_table_set_row_spacings (self->table, (guint) 3);
#line 97 "tracker-metadata-tile.gs"
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->table);
#line 99 "tracker-metadata-tile.gs"
		self->image = (_tmp1_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("text-x-generic", GTK_ICON_SIZE_DIALOG)), _g_object_unref0 (self->image), _tmp1_);
#line 100 "tracker-metadata-tile.gs"
		gtk_image_set_pixel_size (self->image, 75);
#line 101 "tracker-metadata-tile.gs"
		gtk_table_attach (self->table, (GtkWidget*) self->image, (guint) 0, (guint) 1, (guint) 0, (guint) 5, GTK_FILL, GTK_FILL, (guint) 12, (guint) 0);
#line 103 "tracker-metadata-tile.gs"
		self->name_link = (_tmp2_ = g_object_ref_sink ((GtkLinkButton*) gtk_link_button_new ("")), _g_object_unref0 (self->name_link), _tmp2_);
#line 104 "tracker-metadata-tile.gs"
		g_object_set ((GtkButton*) self->name_link, "xalign", (float) 0, NULL);
#line 105 "tracker-metadata-tile.gs"
		self->name_label = (_tmp3_ = tracker_metadata_tile_CreateLabel (self, N_ ("Name:"), FALSE), _g_object_unref0 (self->name_label), _tmp3_);
#line 106 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->name_label, 1, 2, 0, 1, FALSE);
#line 107 "tracker-metadata-tile.gs"
		gtk_table_attach (self->table, (GtkWidget*) self->name_link, (guint) 2, (guint) 3, (guint) 0, (guint) 1, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 109 "tracker-metadata-tile.gs"
		self->path_link = (_tmp4_ = g_object_ref_sink ((GtkLinkButton*) gtk_link_button_new ("")), _g_object_unref0 (self->path_link), _tmp4_);
#line 110 "tracker-metadata-tile.gs"
		g_object_set ((GtkButton*) self->path_link, "xalign", (float) 0, NULL);
#line 111 "tracker-metadata-tile.gs"
		self->path_label = (_tmp5_ = tracker_metadata_tile_CreateLabel (self, N_ ("Folder:"), FALSE), _g_object_unref0 (self->path_label), _tmp5_);
#line 112 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->path_label, 3, 4, 0, 1, FALSE);
#line 113 "tracker-metadata-tile.gs"
		gtk_table_attach (self->table, (GtkWidget*) self->path_link, (guint) 4, (guint) 7, (guint) 0, (guint) 1, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 115 "tracker-metadata-tile.gs"
		self->info_label1 = (_tmp6_ = tracker_metadata_tile_CreateLabel (self, N_ ("Type:"), FALSE), _g_object_unref0 (self->info_label1), _tmp6_);
#line 116 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label1, 1, 2, 1, 2, FALSE);
#line 118 "tracker-metadata-tile.gs"
		self->info_value1 = (_tmp7_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value1), _tmp7_);
#line 119 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value1, 2, 3, 1, 2, TRUE);
#line 121 "tracker-metadata-tile.gs"
		self->info_label2 = (_tmp8_ = tracker_metadata_tile_CreateLabel (self, N_ ("Size:"), FALSE), _g_object_unref0 (self->info_label2), _tmp8_);
#line 122 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label2, 3, 4, 1, 2, FALSE);
#line 124 "tracker-metadata-tile.gs"
		self->info_value2 = (_tmp9_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value2), _tmp9_);
#line 125 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value2, 4, 5, 1, 2, TRUE);
#line 127 "tracker-metadata-tile.gs"
		self->info_label3 = (_tmp10_ = tracker_metadata_tile_CreateLabel (self, N_ ("Modified:"), FALSE), _g_object_unref0 (self->info_label3), _tmp10_);
#line 128 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label3, 5, 6, 1, 2, FALSE);
#line 130 "tracker-metadata-tile.gs"
		self->info_value3 = (_tmp11_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value3), _tmp11_);
#line 131 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value3, 6, 7, 1, 2, TRUE);
#line 133 "tracker-metadata-tile.gs"
		self->info_label4 = (_tmp12_ = tracker_metadata_tile_CreateLabel (self, "", FALSE), _g_object_unref0 (self->info_label4), _tmp12_);
#line 134 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label4, 1, 2, 2, 3, FALSE);
#line 136 "tracker-metadata-tile.gs"
		self->info_value4 = (_tmp13_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value4), _tmp13_);
#line 137 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value4, 2, 3, 2, 3, TRUE);
#line 139 "tracker-metadata-tile.gs"
		self->info_label5 = (_tmp14_ = tracker_metadata_tile_CreateLabel (self, "", FALSE), _g_object_unref0 (self->info_label5), _tmp14_);
#line 140 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label5, 3, 4, 2, 3, FALSE);
#line 142 "tracker-metadata-tile.gs"
		self->info_value5 = (_tmp15_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value5), _tmp15_);
#line 143 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value5, 4, 5, 2, 3, TRUE);
#line 145 "tracker-metadata-tile.gs"
		self->info_label6 = (_tmp16_ = tracker_metadata_tile_CreateLabel (self, "", FALSE), _g_object_unref0 (self->info_label6), _tmp16_);
#line 146 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label6, 5, 6, 2, 3, FALSE);
#line 148 "tracker-metadata-tile.gs"
		self->info_value6 = (_tmp17_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value6), _tmp17_);
#line 149 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value6, 6, 7, 2, 3, TRUE);
#line 151 "tracker-metadata-tile.gs"
		self->sparql = (_tmp18_ = g_strdup ("SELECT ?mimetype WHERE {<%s> nie:mimeType ?mimetype.}"), _g_free0 (self->sparql), _tmp18_);
#line 1121 "tracker-metadata-tile.c"
	}
	return obj;
}


static void tracker_metadata_tile_class_init (TrackerMetadataTileClass * klass) {
	tracker_metadata_tile_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerMetadataTilePrivate));
	G_OBJECT_CLASS (klass)->get_property = tracker_metadata_tile_get_property;
	G_OBJECT_CLASS (klass)->set_property = tracker_metadata_tile_set_property;
	G_OBJECT_CLASS (klass)->constructor = tracker_metadata_tile_constructor;
	G_OBJECT_CLASS (klass)->finalize = tracker_metadata_tile_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_METADATA_TILE_QUERY, g_param_spec_object ("Query", "Query", "Query", TYPE_TRACKER_QUERY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_METADATA_TILE_RESULT_GRID, g_param_spec_object ("ResultGrid", "ResultGrid", "ResultGrid", TYPE_TRACKER_RESULT_GRID, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void tracker_metadata_tile_instance_init (TrackerMetadataTile * self) {
	self->priv = TRACKER_METADATA_TILE_GET_PRIVATE (self);
}


static void tracker_metadata_tile_finalize (GObject* obj) {
	TrackerMetadataTile * self;
	self = TRACKER_METADATA_TILE (obj);
	_g_free0 (self->uri);
	_g_object_unref0 (self->image);
	_g_object_unref0 (self->name_link);
	_g_object_unref0 (self->path_link);
	_g_object_unref0 (self->table);
	_g_free0 (self->sparql);
	_g_object_unref0 (self->name_label);
	_g_object_unref0 (self->path_label);
	_g_object_unref0 (self->info_label1);
	_g_object_unref0 (self->info_value1);
	_g_object_unref0 (self->info_label2);
	_g_object_unref0 (self->info_value2);
	_g_object_unref0 (self->info_label3);
	_g_object_unref0 (self->info_value3);
	_g_object_unref0 (self->info_label4);
	_g_object_unref0 (self->info_value4);
	_g_object_unref0 (self->info_label5);
	_g_object_unref0 (self->info_value5);
	_g_object_unref0 (self->info_label6);
	_g_object_unref0 (self->info_value6);
	_g_object_unref0 (self->info_label7);
	_g_object_unref0 (self->info_value7);
	_g_object_unref0 (self->info_label8);
	_g_object_unref0 (self->info_value8);
	_g_object_unref0 (self->priv->_result_grid);
	G_OBJECT_CLASS (tracker_metadata_tile_parent_class)->finalize (obj);
}


GType tracker_metadata_tile_get_type (void) {
	static GType tracker_metadata_tile_type_id = 0;
	if (tracker_metadata_tile_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerMetadataTileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_metadata_tile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerMetadataTile), 0, (GInstanceInitFunc) tracker_metadata_tile_instance_init, NULL };
		tracker_metadata_tile_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "TrackerMetadataTile", &g_define_type_info, 0);
	}
	return tracker_metadata_tile_type_id;
}


static void tracker_metadata_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerMetadataTile * self;
	self = TRACKER_METADATA_TILE (object);
	switch (property_id) {
		case TRACKER_METADATA_TILE_QUERY:
		g_value_set_object (value, tracker_metadata_tile_get_Query (self));
		break;
		case TRACKER_METADATA_TILE_RESULT_GRID:
		g_value_set_object (value, tracker_metadata_tile_get_ResultGrid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void tracker_metadata_tile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerMetadataTile * self;
	self = TRACKER_METADATA_TILE (object);
	switch (property_id) {
		case TRACKER_METADATA_TILE_QUERY:
		tracker_metadata_tile_set_Query (self, g_value_get_object (value));
		break;
		case TRACKER_METADATA_TILE_RESULT_GRID:
		tracker_metadata_tile_set_ResultGrid (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




