
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define TYPE_TRACKER_METADATA_TILE (tracker_metadata_tile_get_type ())
#define TRACKER_METADATA_TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_METADATA_TILE, TrackerMetadataTile))
#define TRACKER_METADATA_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_METADATA_TILE, TrackerMetadataTileClass))
#define IS_TRACKER_METADATA_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_METADATA_TILE))
#define IS_TRACKER_METADATA_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_METADATA_TILE))
#define TRACKER_METADATA_TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_METADATA_TILE, TrackerMetadataTileClass))

typedef struct _TrackerMetadataTile TrackerMetadataTile;
typedef struct _TrackerMetadataTileClass TrackerMetadataTileClass;
typedef struct _TrackerMetadataTilePrivate TrackerMetadataTilePrivate;

#define TYPE_CATEGORIES (categories_get_type ())

#define TYPE_TRACKER_RESULT_GRID (tracker_result_grid_get_type ())
#define TRACKER_RESULT_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_RESULT_GRID, TrackerResultGrid))
#define TRACKER_RESULT_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_RESULT_GRID, TrackerResultGridClass))
#define IS_TRACKER_RESULT_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_RESULT_GRID))
#define IS_TRACKER_RESULT_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_RESULT_GRID))
#define TRACKER_RESULT_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_RESULT_GRID, TrackerResultGridClass))

typedef struct _TrackerResultGrid TrackerResultGrid;
typedef struct _TrackerResultGridClass TrackerResultGridClass;

#define TYPE_TRACKER_QUERY (tracker_query_get_type ())
#define TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_QUERY, TrackerQuery))
#define TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_QUERY, TrackerQueryClass))
#define IS_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_QUERY))
#define IS_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_QUERY))
#define TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_QUERY, TrackerQueryClass))

typedef struct _TrackerQuery TrackerQuery;
typedef struct _TrackerQueryClass TrackerQueryClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _TrackerResultGridPrivate TrackerResultGridPrivate;

#define TYPE_RESULT_COLUMNS (result_columns_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	CATEGORIES_Application,
	CATEGORIES_Contact,
	CATEGORIES_Email,
	CATEGORIES_EmailAttachment,
	CATEGORIES_File,
	CATEGORIES_Folder,
	CATEGORIES_Music,
	CATEGORIES_Video,
	CATEGORIES_Image,
	CATEGORIES_Document,
	CATEGORIES_Text,
	CATEGORIES_Development,
	CATEGORIES_Web,
	CATEGORIES_WebHistory
} Categories;

struct _TrackerMetadataTile {
	GtkHBox parent_instance;
	TrackerMetadataTilePrivate * priv;
	char* uri;
	Categories category;
	GtkImage* image;
	GtkLinkButton* name_link;
	GtkTable* table;
	GtkLabel* info_label1;
	GtkLabel* info_value1;
	GtkLabel* info_label2;
	GtkLabel* info_value2;
	GtkLabel* info_label3;
	GtkLabel* info_value3;
	GtkLabel* info_label4;
	GtkLabel* info_value4;
	GtkLabel* info_label5;
	GtkLabel* info_value5;
	GtkLabel* info_label6;
	GtkLabel* info_value6;
	GtkLabel* info_label7;
	GtkLabel* info_value7;
	GtkLabel* info_label8;
	GtkLabel* info_value8;
};

struct _TrackerMetadataTileClass {
	GtkHBoxClass parent_class;
};

struct _TrackerMetadataTilePrivate {
	TrackerResultGrid* _result_grid;
	TrackerQuery* _Query;
};

struct _TrackerResultGrid {
	GtkScrolledWindow parent_instance;
	TrackerResultGridPrivate * priv;
	GtkListStore* store;
	GtkIconView* iconview;
};

struct _TrackerResultGridClass {
	GtkScrolledWindowClass parent_class;
};

typedef enum  {
	RESULT_COLUMNS_Uri,
	RESULT_COLUMNS_Icon,
	RESULT_COLUMNS_DisplayName,
	RESULT_COLUMNS_Mime,
	RESULT_COLUMNS_Category,
	RESULT_COLUMNS_Snippet,
	RESULT_COLUMNS_IsDirectory,
	RESULT_COLUMNS_Path,
	RESULT_COLUMNS_NumOfCols
} ResultColumns;


static gpointer tracker_metadata_tile_parent_class = NULL;

GType tracker_metadata_tile_get_type (void);
GType categories_get_type (void);
GType tracker_result_grid_get_type (void);
GType tracker_query_get_type (void);
#define TRACKER_METADATA_TILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TRACKER_METADATA_TILE, TrackerMetadataTilePrivate))
enum  {
	TRACKER_METADATA_TILE_DUMMY_PROPERTY,
	TRACKER_METADATA_TILE_QUERY,
	TRACKER_METADATA_TILE_RESULT_GRID
};
static void tracker_metadata_tile_AttachToTable (TrackerMetadataTile* self, GtkLabel* lab, gint l, gint r, gint t, gint b, gboolean e);
static GtkLabel* tracker_metadata_tile_CreateLabel (TrackerMetadataTile* self, const char* s, gboolean e);
void tracker_metadata_tile_ClearLabels (TrackerMetadataTile* self);
GType result_columns_get_type (void);
TrackerQuery* tracker_metadata_tile_get_Query (TrackerMetadataTile* self);
char** tracker_query_Query (TrackerQuery* self, const char* sparql, int* result_length1, int* result_length2);
void tracker_metadata_tile_LoadUri (TrackerMetadataTile* self, const GtkTreePath* path);
TrackerMetadataTile* tracker_metadata_tile_new (void);
TrackerMetadataTile* tracker_metadata_tile_construct (GType object_type);
void tracker_metadata_tile_set_Query (TrackerMetadataTile* self, TrackerQuery* value);
TrackerResultGrid* tracker_metadata_tile_get_ResultGrid (TrackerMetadataTile* self);
static void _lambda6_ (const GtkTreePath* path, TrackerMetadataTile* self);
static void __lambda6__tracker_result_grid_selection_changed (TrackerResultGrid* _sender, const GtkTreePath* path, gpointer self);
void tracker_metadata_tile_set_ResultGrid (TrackerMetadataTile* self, TrackerResultGrid* value);
static GObject * tracker_metadata_tile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void tracker_metadata_tile_finalize (GObject* obj);
static void tracker_metadata_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void tracker_metadata_tile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



#line 133 "tracker-metadata-tile.gs"
static void tracker_metadata_tile_AttachToTable (TrackerMetadataTile* self, GtkLabel* lab, gint l, gint r, gint t, gint b, gboolean e) {
#line 133 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 133 "tracker-metadata-tile.gs"
	g_return_if_fail (lab != NULL);
#line 134 "tracker-metadata-tile.gs"
	if (e == TRUE) {
#line 135 "tracker-metadata-tile.gs"
		gtk_table_attach (self->table, (GtkWidget*) lab, (guint) l, (guint) r, (guint) t, (guint) b, GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
#line 176 "tracker-metadata-tile.c"
	} else {
#line 137 "tracker-metadata-tile.gs"
		gtk_table_attach (self->table, (GtkWidget*) lab, (guint) l, (guint) r, (guint) t, (guint) b, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 180 "tracker-metadata-tile.c"
	}
}


#line 139 "tracker-metadata-tile.gs"
static GtkLabel* tracker_metadata_tile_CreateLabel (TrackerMetadataTile* self, const char* s, gboolean e) {
#line 187 "tracker-metadata-tile.c"
	GtkLabel* result;
	GtkLabel* l;
#line 139 "tracker-metadata-tile.gs"
	g_return_val_if_fail (self != NULL, NULL);
#line 139 "tracker-metadata-tile.gs"
	g_return_val_if_fail (s != NULL, NULL);
#line 194 "tracker-metadata-tile.c"
	l = g_object_ref_sink ((GtkLabel*) gtk_label_new (s));
#line 141 "tracker-metadata-tile.gs"
	g_object_set ((GtkMisc*) l, "xalign", (float) 0, NULL);
#line 142 "tracker-metadata-tile.gs"
	gtk_label_set_use_markup (l, TRUE);
#line 144 "tracker-metadata-tile.gs"
	if (e == TRUE) {
#line 145 "tracker-metadata-tile.gs"
		gtk_label_set_ellipsize (l, PANGO_ELLIPSIZE_END);
#line 204 "tracker-metadata-tile.c"
	}
	result = l;
	return result;
}


#line 150 "tracker-metadata-tile.gs"
void tracker_metadata_tile_ClearLabels (TrackerMetadataTile* self) {
#line 150 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 151 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value1, "");
#line 152 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value2, "");
#line 153 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value3, "");
#line 154 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value4, "");
#line 155 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value5, "");
#line 156 "tracker-metadata-tile.gs"
	gtk_label_set_text (self->info_value6, "");
#line 157 "tracker-metadata-tile.gs"
	gtk_link_button_set_uri (self->name_link, "");
#line 158 "tracker-metadata-tile.gs"
	gtk_button_set_label ((GtkButton*) self->name_link, "");
#line 231 "tracker-metadata-tile.c"
}


#line 163 "tracker-metadata-tile.gs"
void tracker_metadata_tile_LoadUri (TrackerMetadataTile* self, const GtkTreePath* path) {
#line 237 "tracker-metadata-tile.c"
	GError * _inner_error_;
	GtkTreeIter iter = {0};
	const char* uri;
	const char* display_name;
	GdkPixbuf* icon;
	GFile* file;
	char* filepath;
	char* query;
#line 163 "tracker-metadata-tile.gs"
	g_return_if_fail (self != NULL);
#line 248 "tracker-metadata-tile.c"
	_inner_error_ = NULL;
#line 164 "tracker-metadata-tile.gs"
	tracker_metadata_tile_ClearLabels (self);
#line 166 "tracker-metadata-tile.gs"
	if (path == NULL) {
#line 167 "tracker-metadata-tile.gs"
		gtk_image_set_from_icon_name (self->image, "text-x-generic", GTK_ICON_SIZE_DIALOG);
#line 256 "tracker-metadata-tile.c"
		return;
	}
	uri = NULL;
	display_name = NULL;
	icon = NULL;
#line 175 "tracker-metadata-tile.gs"
	gtk_tree_model_get_iter ((GtkTreeModel*) self->priv->_result_grid->store, &iter, path);
#line 176 "tracker-metadata-tile.gs"
	gtk_tree_model_get ((GtkTreeModel*) self->priv->_result_grid->store, &iter, RESULT_COLUMNS_Uri, &uri, RESULT_COLUMNS_Icon, &icon, RESULT_COLUMNS_DisplayName, &display_name, -1);
#line 178 "tracker-metadata-tile.gs"
	gtk_image_set_from_pixbuf (self->image, icon);
#line 268 "tracker-metadata-tile.c"
	file = g_file_new_for_uri (uri);
	filepath = g_file_get_basename (file);
#line 182 "tracker-metadata-tile.gs"
	gtk_link_button_set_uri (self->name_link, uri);
#line 183 "tracker-metadata-tile.gs"
	gtk_button_set_label ((GtkButton*) self->name_link, filepath);
#line 275 "tracker-metadata-tile.c"
	query = g_strdup_printf ("SELECT ?mimetype WHERE {<%s> nie:mimeType ?mimeType.}", uri);
#line 188 "tracker-metadata-tile.gs"
	if (self->priv->_Query != NULL) {
#line 279 "tracker-metadata-tile.c"
		char** _tmp2_;
		gint _result__length2;
		gint _result__length1;
		gint _tmp1_;
		gint _tmp0_;
		char** _result_;
		gboolean _tmp3_;
		_result_ = (_tmp2_ = tracker_query_Query (self->priv->_Query, query, &_tmp0_, &_tmp1_), _result__length1 = _tmp0_, _result__length2 = _tmp1_, _tmp2_);
		_tmp3_ = FALSE;
#line 191 "tracker-metadata-tile.gs"
		if (_result_ != NULL) {
#line 191 "tracker-metadata-tile.gs"
			_tmp3_ = _result_[(0 * _result__length2) + 0] != NULL;
#line 293 "tracker-metadata-tile.c"
		} else {
#line 191 "tracker-metadata-tile.gs"
			_tmp3_ = FALSE;
#line 297 "tracker-metadata-tile.c"
		}
#line 191 "tracker-metadata-tile.gs"
		if (_tmp3_) {
#line 301 "tracker-metadata-tile.c"
			char* val1;
			val1 = g_strdup_printf ("<b>%s</b>", _result_[(0 * _result__length2) + 0]);
#line 194 "tracker-metadata-tile.gs"
			gtk_label_set_markup (self->info_value1, val1);
#line 195 "tracker-metadata-tile.gs"
			g_object_set ((GtkMisc*) self->info_value1, "xalign", (float) 0, NULL);
#line 308 "tracker-metadata-tile.c"
			_g_free0 (val1);
		}
		{
			GFileInfo* info;
			char* _tmp4_;
			char* _tmp5_;
			char* val2;
			GTimeVal tm = {0};
			char* _tmp6_;
			char* _tmp7_;
			char* val3;
			info = g_file_query_info (file, "standard::size,time::modified", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch6_g_error;
				goto __finally6;
			}
			val2 = (_tmp5_ = g_strdup_printf ("<b>%s</b>", _tmp4_ = g_strdup_printf ("%lli", g_file_info_get_size (info))), _g_free0 (_tmp4_), _tmp5_);
#line 203 "tracker-metadata-tile.gs"
			gtk_label_set_markup (self->info_value2, val2);
#line 206 "tracker-metadata-tile.gs"
			g_file_info_get_modification_time (info, &tm);
#line 330 "tracker-metadata-tile.c"
			val3 = (_tmp7_ = g_strdup_printf ("<b>%s</b>", _tmp6_ = g_time_val_to_iso8601 (&tm)), _g_free0 (_tmp6_), _tmp7_);
#line 210 "tracker-metadata-tile.gs"
			gtk_label_set_markup (self->info_value3, val3);
#line 334 "tracker-metadata-tile.c"
			_g_object_unref0 (info);
			_g_free0 (val2);
			_g_free0 (val3);
		}
		goto __finally6;
		__catch6_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
#line 213 "tracker-metadata-tile.gs"
				g_print ("Could not get file info for %s\n", uri);
#line 348 "tracker-metadata-tile.c"
				_g_error_free0 (e);
			}
		}
		__finally6:
		if (_inner_error_ != NULL) {
			_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (icon);
			_g_object_unref0 (file);
			_g_free0 (filepath);
			_g_free0 (query);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
		_result_ = (_vala_array_free (_result_, _result__length1 * _result__length2, (GDestroyNotify) g_free), NULL);
	}
	_g_object_unref0 (icon);
	_g_object_unref0 (file);
	_g_free0 (filepath);
	_g_free0 (query);
}


#line 28 "tracker-metadata-tile.gs"
TrackerMetadataTile* tracker_metadata_tile_construct (GType object_type) {
#line 374 "tracker-metadata-tile.c"
	TrackerMetadataTile * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


#line 28 "tracker-metadata-tile.gs"
TrackerMetadataTile* tracker_metadata_tile_new (void) {
#line 28 "tracker-metadata-tile.gs"
	return tracker_metadata_tile_construct (TYPE_TRACKER_METADATA_TILE);
#line 385 "tracker-metadata-tile.c"
}


TrackerQuery* tracker_metadata_tile_get_Query (TrackerMetadataTile* self) {
	TrackerQuery* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Query;
	return result;
}


void tracker_metadata_tile_set_Query (TrackerMetadataTile* self, TrackerQuery* value) {
	g_return_if_fail (self != NULL);
	self->priv->_Query = value;
	g_object_notify ((GObject *) self, "Query");
}


TrackerResultGrid* tracker_metadata_tile_get_ResultGrid (TrackerMetadataTile* self) {
	TrackerResultGrid* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_result_grid;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda6_ (const GtkTreePath* path, TrackerMetadataTile* self) {
#line 74 "tracker-metadata-tile.gs"
	tracker_metadata_tile_LoadUri (self, path);
#line 420 "tracker-metadata-tile.c"
}


static void __lambda6__tracker_result_grid_selection_changed (TrackerResultGrid* _sender, const GtkTreePath* path, gpointer self) {
	_lambda6_ (path, self);
}


void tracker_metadata_tile_set_ResultGrid (TrackerMetadataTile* self, TrackerResultGrid* value) {
	g_return_if_fail (self != NULL);
#line 70 "tracker-metadata-tile.gs"
	if (value != NULL) {
#line 433 "tracker-metadata-tile.c"
		TrackerResultGrid* _tmp0_;
#line 71 "tracker-metadata-tile.gs"
		self->priv->_result_grid = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_result_grid), _tmp0_);
#line 73 "tracker-metadata-tile.gs"
		g_signal_connect_object (self->priv->_result_grid, "selection-changed", (GCallback) __lambda6__tracker_result_grid_selection_changed, self, 0);
#line 439 "tracker-metadata-tile.c"
	}
	g_object_notify ((GObject *) self, "ResultGrid");
}


static GObject * tracker_metadata_tile_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	TrackerMetadataTileClass * klass;
	GObjectClass * parent_class;
	TrackerMetadataTile * self;
	klass = TRACKER_METADATA_TILE_CLASS (g_type_class_peek (TYPE_TRACKER_METADATA_TILE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = TRACKER_METADATA_TILE (obj);
	{
		GtkTable* _tmp0_;
		GtkImage* _tmp1_;
		GtkLinkButton* _tmp2_;
		GtkLabel* _tmp3_;
		GtkLabel* _tmp4_;
		GtkLabel* _tmp5_;
		GtkLabel* _tmp6_;
		GtkLabel* _tmp7_;
		GtkLabel* _tmp8_;
		GtkLabel* _tmp9_;
		GtkLabel* _tmp10_;
		GtkLabel* _tmp11_;
		GtkLabel* _tmp12_;
		GtkLabel* _tmp13_;
		GtkLabel* _tmp14_;
#line 78 "tracker-metadata-tile.gs"
		gtk_container_set_border_width ((GtkContainer*) self, (guint) 8);
#line 80 "tracker-metadata-tile.gs"
		self->table = (_tmp0_ = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) 3, (guint) 7, FALSE)), _g_object_unref0 (self->table), _tmp0_);
#line 81 "tracker-metadata-tile.gs"
		gtk_table_set_col_spacings (self->table, (guint) 6);
#line 82 "tracker-metadata-tile.gs"
		gtk_table_set_row_spacings (self->table, (guint) 6);
#line 84 "tracker-metadata-tile.gs"
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->table);
#line 86 "tracker-metadata-tile.gs"
		self->image = (_tmp1_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_icon_name ("text-x-generic", GTK_ICON_SIZE_DIALOG)), _g_object_unref0 (self->image), _tmp1_);
#line 87 "tracker-metadata-tile.gs"
		gtk_table_attach (self->table, (GtkWidget*) self->image, (guint) 0, (guint) 1, (guint) 0, (guint) 3, GTK_FILL, GTK_FILL, (guint) 12, (guint) 0);
#line 89 "tracker-metadata-tile.gs"
		self->name_link = (_tmp2_ = g_object_ref_sink ((GtkLinkButton*) gtk_link_button_new ("")), _g_object_unref0 (self->name_link), _tmp2_);
#line 90 "tracker-metadata-tile.gs"
		g_object_set ((GtkButton*) self->name_link, "xalign", (float) 0, NULL);
#line 91 "tracker-metadata-tile.gs"
		gtk_table_attach (self->table, (GtkWidget*) self->name_link, (guint) 1, (guint) 7, (guint) 0, (guint) 1, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 93 "tracker-metadata-tile.gs"
		self->info_label1 = (_tmp3_ = tracker_metadata_tile_CreateLabel (self, N_ ("Type:"), FALSE), _g_object_unref0 (self->info_label1), _tmp3_);
#line 94 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label1, 1, 2, 1, 2, FALSE);
#line 96 "tracker-metadata-tile.gs"
		self->info_value1 = (_tmp4_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value1), _tmp4_);
#line 97 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value1, 2, 3, 1, 2, TRUE);
#line 99 "tracker-metadata-tile.gs"
		self->info_label2 = (_tmp5_ = tracker_metadata_tile_CreateLabel (self, N_ ("Size:"), FALSE), _g_object_unref0 (self->info_label2), _tmp5_);
#line 100 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label2, 3, 4, 1, 2, FALSE);
#line 102 "tracker-metadata-tile.gs"
		self->info_value2 = (_tmp6_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value2), _tmp6_);
#line 103 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value2, 4, 5, 1, 2, TRUE);
#line 105 "tracker-metadata-tile.gs"
		self->info_label3 = (_tmp7_ = tracker_metadata_tile_CreateLabel (self, N_ ("Modified:"), FALSE), _g_object_unref0 (self->info_label3), _tmp7_);
#line 106 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label3, 5, 6, 1, 2, FALSE);
#line 108 "tracker-metadata-tile.gs"
		self->info_value3 = (_tmp8_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value3), _tmp8_);
#line 109 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value3, 6, 7, 1, 2, TRUE);
#line 111 "tracker-metadata-tile.gs"
		self->info_label4 = (_tmp9_ = tracker_metadata_tile_CreateLabel (self, N_ ("Title:"), FALSE), _g_object_unref0 (self->info_label4), _tmp9_);
#line 112 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label4, 1, 2, 2, 3, FALSE);
#line 114 "tracker-metadata-tile.gs"
		self->info_value4 = (_tmp10_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value4), _tmp10_);
#line 115 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value4, 2, 3, 2, 3, TRUE);
#line 117 "tracker-metadata-tile.gs"
		self->info_label5 = (_tmp11_ = tracker_metadata_tile_CreateLabel (self, N_ ("Author/Artist:"), FALSE), _g_object_unref0 (self->info_label5), _tmp11_);
#line 118 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label5, 3, 4, 2, 3, FALSE);
#line 120 "tracker-metadata-tile.gs"
		self->info_value5 = (_tmp12_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value5), _tmp12_);
#line 121 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value5, 4, 5, 2, 3, TRUE);
#line 123 "tracker-metadata-tile.gs"
		self->info_label6 = (_tmp13_ = tracker_metadata_tile_CreateLabel (self, "Comments:", FALSE), _g_object_unref0 (self->info_label6), _tmp13_);
#line 124 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_label6, 5, 6, 2, 3, FALSE);
#line 126 "tracker-metadata-tile.gs"
		self->info_value6 = (_tmp14_ = tracker_metadata_tile_CreateLabel (self, "-", TRUE), _g_object_unref0 (self->info_value6), _tmp14_);
#line 127 "tracker-metadata-tile.gs"
		tracker_metadata_tile_AttachToTable (self, self->info_value6, 6, 7, 2, 3, TRUE);
#line 129 "tracker-metadata-tile.gs"
		gtk_widget_show_all ((GtkWidget*) self);
#line 540 "tracker-metadata-tile.c"
	}
	return obj;
}


static void tracker_metadata_tile_class_init (TrackerMetadataTileClass * klass) {
	tracker_metadata_tile_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerMetadataTilePrivate));
	G_OBJECT_CLASS (klass)->get_property = tracker_metadata_tile_get_property;
	G_OBJECT_CLASS (klass)->set_property = tracker_metadata_tile_set_property;
	G_OBJECT_CLASS (klass)->constructor = tracker_metadata_tile_constructor;
	G_OBJECT_CLASS (klass)->finalize = tracker_metadata_tile_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_METADATA_TILE_QUERY, g_param_spec_object ("Query", "Query", "Query", TYPE_TRACKER_QUERY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_METADATA_TILE_RESULT_GRID, g_param_spec_object ("ResultGrid", "ResultGrid", "ResultGrid", TYPE_TRACKER_RESULT_GRID, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void tracker_metadata_tile_instance_init (TrackerMetadataTile * self) {
	self->priv = TRACKER_METADATA_TILE_GET_PRIVATE (self);
}


static void tracker_metadata_tile_finalize (GObject* obj) {
	TrackerMetadataTile * self;
	self = TRACKER_METADATA_TILE (obj);
	_g_free0 (self->uri);
	_g_object_unref0 (self->image);
	_g_object_unref0 (self->name_link);
	_g_object_unref0 (self->table);
	_g_object_unref0 (self->info_label1);
	_g_object_unref0 (self->info_value1);
	_g_object_unref0 (self->info_label2);
	_g_object_unref0 (self->info_value2);
	_g_object_unref0 (self->info_label3);
	_g_object_unref0 (self->info_value3);
	_g_object_unref0 (self->info_label4);
	_g_object_unref0 (self->info_value4);
	_g_object_unref0 (self->info_label5);
	_g_object_unref0 (self->info_value5);
	_g_object_unref0 (self->info_label6);
	_g_object_unref0 (self->info_value6);
	_g_object_unref0 (self->info_label7);
	_g_object_unref0 (self->info_value7);
	_g_object_unref0 (self->info_label8);
	_g_object_unref0 (self->info_value8);
	_g_object_unref0 (self->priv->_result_grid);
	G_OBJECT_CLASS (tracker_metadata_tile_parent_class)->finalize (obj);
}


GType tracker_metadata_tile_get_type (void) {
	static GType tracker_metadata_tile_type_id = 0;
	if (tracker_metadata_tile_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerMetadataTileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_metadata_tile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerMetadataTile), 0, (GInstanceInitFunc) tracker_metadata_tile_instance_init, NULL };
		tracker_metadata_tile_type_id = g_type_register_static (GTK_TYPE_HBOX, "TrackerMetadataTile", &g_define_type_info, 0);
	}
	return tracker_metadata_tile_type_id;
}


static void tracker_metadata_tile_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerMetadataTile * self;
	self = TRACKER_METADATA_TILE (object);
	switch (property_id) {
		case TRACKER_METADATA_TILE_QUERY:
		g_value_set_object (value, tracker_metadata_tile_get_Query (self));
		break;
		case TRACKER_METADATA_TILE_RESULT_GRID:
		g_value_set_object (value, tracker_metadata_tile_get_ResultGrid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void tracker_metadata_tile_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerMetadataTile * self;
	self = TRACKER_METADATA_TILE (object);
	switch (property_id) {
		case TRACKER_METADATA_TILE_QUERY:
		tracker_metadata_tile_set_Query (self, g_value_get_object (value));
		break;
		case TRACKER_METADATA_TILE_RESULT_GRID:
		tracker_metadata_tile_set_ResultGrid (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




