/* tracker-sparql-query.c generated by valac, the Vala compiler
 * generated from tracker-sparql-query.vala, do not modify */

/*
 * Copyright (C) 2008-2010, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-data/tracker-property.h>
#include <libtracker-data/tracker-class.h>
#include <libtracker-data/tracker-data-query.h>
#include <libtracker-data/tracker-data-update.h>
#include <libtracker-data/tracker-ontologies.h>
#include <libtracker-data/tracker-namespace.h>
#include <libtracker-db/tracker-db-interface.h>
#include <libtracker-common/tracker-date-time.h>
#include <libtracker-db/tracker-db-manager.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TRACKER_SPARQL_TYPE_VARIABLE_STATE (tracker_sparql_variable_state_get_type ())

#define TRACKER_SPARQL_TYPE_DATA_TABLE (tracker_sparql_data_table_get_type ())
#define TRACKER_SPARQL_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTable))
#define TRACKER_SPARQL_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))
#define TRACKER_SPARQL_IS_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_IS_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_DATA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))

typedef struct _TrackerSparqlDataTable TrackerSparqlDataTable;
typedef struct _TrackerSparqlDataTableClass TrackerSparqlDataTableClass;
typedef struct _TrackerSparqlDataTablePrivate TrackerSparqlDataTablePrivate;

#define TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE (tracker_sparql_predicate_variable_get_type ())
#define TRACKER_SPARQL_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariable))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))

typedef struct _TrackerSparqlPredicateVariable TrackerSparqlPredicateVariable;
typedef struct _TrackerSparqlPredicateVariableClass TrackerSparqlPredicateVariableClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TRACKER_SPARQL_TYPE_DATA_BINDING (tracker_sparql_data_binding_get_type ())
#define TRACKER_SPARQL_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding))
#define TRACKER_SPARQL_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))
#define TRACKER_SPARQL_IS_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_IS_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_DATA_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))

typedef struct _TrackerSparqlDataBinding TrackerSparqlDataBinding;
typedef struct _TrackerSparqlDataBindingClass TrackerSparqlDataBindingClass;
typedef struct _TrackerSparqlDataBindingPrivate TrackerSparqlDataBindingPrivate;

#define TRACKER_SPARQL_TYPE_LITERAL_BINDING (tracker_sparql_literal_binding_get_type ())
#define TRACKER_SPARQL_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBinding))
#define TRACKER_SPARQL_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))
#define TRACKER_SPARQL_IS_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_IS_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_LITERAL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))

typedef struct _TrackerSparqlLiteralBinding TrackerSparqlLiteralBinding;
typedef struct _TrackerSparqlLiteralBindingClass TrackerSparqlLiteralBindingClass;
typedef struct _TrackerSparqlLiteralBindingPrivate TrackerSparqlLiteralBindingPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING (tracker_sparql_variable_binding_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBinding))
#define TRACKER_SPARQL_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_VARIABLE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))

typedef struct _TrackerSparqlVariableBinding TrackerSparqlVariableBinding;
typedef struct _TrackerSparqlVariableBindingClass TrackerSparqlVariableBindingClass;
typedef struct _TrackerSparqlVariableBindingPrivate TrackerSparqlVariableBindingPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE (tracker_sparql_variable_get_type ())
#define TRACKER_SPARQL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable))
#define TRACKER_SPARQL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))
#define TRACKER_SPARQL_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))

typedef struct _TrackerSparqlVariable TrackerSparqlVariable;
typedef struct _TrackerSparqlVariableClass TrackerSparqlVariableClass;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST (tracker_sparql_variable_binding_list_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingList))
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingListClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST))
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingListClass))

typedef struct _TrackerSparqlVariableBindingList TrackerSparqlVariableBindingList;
typedef struct _TrackerSparqlVariableBindingListClass TrackerSparqlVariableBindingListClass;
typedef struct _TrackerSparqlVariableBindingListPrivate TrackerSparqlVariableBindingListPrivate;
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
typedef struct _TrackerSparqlVariablePrivate TrackerSparqlVariablePrivate;

#define TRACKER_SPARQL_TYPE_CONTEXT (tracker_sparql_context_get_type ())
#define TRACKER_SPARQL_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContext))
#define TRACKER_SPARQL_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))
#define TRACKER_SPARQL_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))

typedef struct _TrackerSparqlContext TrackerSparqlContext;
typedef struct _TrackerSparqlContextClass TrackerSparqlContextClass;
typedef struct _TrackerSparqlContextPrivate TrackerSparqlContextPrivate;
#define _tracker_sparql_context_unref0(var) ((var == NULL) ? NULL : (var = (tracker_sparql_context_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _TrackerSparqlParamSpecContext TrackerSparqlParamSpecContext;

#define TRACKER_SPARQL_TYPE_SELECT_CONTEXT (tracker_sparql_select_context_get_type ())
#define TRACKER_SPARQL_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext))
#define TRACKER_SPARQL_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_SELECT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))

typedef struct _TrackerSparqlSelectContext TrackerSparqlSelectContext;
typedef struct _TrackerSparqlSelectContextClass TrackerSparqlSelectContextClass;
typedef struct _TrackerSparqlSelectContextPrivate TrackerSparqlSelectContextPrivate;

#define TRACKER_SPARQL_TYPE_QUERY (tracker_sparql_query_get_type ())
#define TRACKER_SPARQL_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery))
#define TRACKER_SPARQL_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))
#define TRACKER_SPARQL_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))

typedef struct _TrackerSparqlQuery TrackerSparqlQuery;
typedef struct _TrackerSparqlQueryClass TrackerSparqlQueryClass;
typedef struct _TrackerSparqlQueryPrivate TrackerSparqlQueryPrivate;

#define TRACKER_SPARQL_TYPE_EXPRESSION (tracker_sparql_expression_get_type ())
#define TRACKER_SPARQL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression))
#define TRACKER_SPARQL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))
#define TRACKER_SPARQL_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))

typedef struct _TrackerSparqlExpression TrackerSparqlExpression;
typedef struct _TrackerSparqlExpressionClass TrackerSparqlExpressionClass;

#define TRACKER_SPARQL_TYPE_PATTERN (tracker_sparql_pattern_get_type ())
#define TRACKER_SPARQL_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern))
#define TRACKER_SPARQL_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))
#define TRACKER_SPARQL_IS_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_IS_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))

typedef struct _TrackerSparqlPattern TrackerSparqlPattern;
typedef struct _TrackerSparqlPatternClass TrackerSparqlPatternClass;

#define TRACKER_TYPE_SPARQL_SCANNER (tracker_sparql_scanner_get_type ())
#define TRACKER_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScanner))
#define TRACKER_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))
#define TRACKER_IS_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_IS_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_SPARQL_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))

typedef struct _TrackerSparqlScanner TrackerSparqlScanner;
typedef struct _TrackerSparqlScannerClass TrackerSparqlScannerClass;

#define TRACKER_SPARQL_QUERY_TYPE_TOKEN_INFO (tracker_sparql_query_token_info_get_type ())

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

#define TRACKER_TYPE_SOURCE_LOCATION (tracker_source_location_get_type ())
typedef struct _TrackerSourceLocation TrackerSourceLocation;
typedef struct _TrackerSparqlQueryTokenInfo TrackerSparqlQueryTokenInfo;
#define _g_checksum_free0(var) ((var == NULL) ? NULL : (var = (g_checksum_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_ptr_array_free0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_free (var, TRUE), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

typedef enum  {
	TRACKER_SPARQL_ERROR_PARSE,
	TRACKER_SPARQL_ERROR_UNKNOWN_CLASS,
	TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY,
	TRACKER_SPARQL_ERROR_TYPE,
	TRACKER_SPARQL_ERROR_INTERNAL,
	TRACKER_SPARQL_ERROR_UNSUPPORTED
} TrackerSparqlError;
#define TRACKER_SPARQL_ERROR tracker_sparql_error_quark ()
typedef enum  {
	TRACKER_SPARQL_VARIABLE_STATE_NONE,
	TRACKER_SPARQL_VARIABLE_STATE_BOUND,
	TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL
} TrackerSparqlVariableState;

struct _TrackerSparqlDataTable {
	GObject parent_instance;
	TrackerSparqlDataTablePrivate * priv;
	char* sql_db_tablename;
	char* sql_query_tablename;
	TrackerSparqlPredicateVariable* predicate_variable;
};

struct _TrackerSparqlDataTableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlDataBinding {
	GObject parent_instance;
	TrackerSparqlDataBindingPrivate * priv;
	TrackerPropertyType data_type;
	TrackerSparqlDataTable* table;
	char* sql_db_column_name;
};

struct _TrackerSparqlDataBindingClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlDataBindingPrivate {
	char* _sql_expression;
};

struct _TrackerSparqlLiteralBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlLiteralBindingPrivate * priv;
	gboolean is_fts_match;
	char* literal;
};

struct _TrackerSparqlLiteralBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

struct _TrackerSparqlVariableBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlVariableBindingPrivate * priv;
	TrackerSparqlVariable* variable;
	gboolean maybe_null;
	gboolean in_simple_optional;
	TrackerClass* type;
};

struct _TrackerSparqlVariableBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

struct _TrackerSparqlVariableBindingList {
	GObject parent_instance;
	TrackerSparqlVariableBindingListPrivate * priv;
	GList* list;
};

struct _TrackerSparqlVariableBindingListClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariable {
	GObject parent_instance;
	TrackerSparqlVariablePrivate * priv;
	TrackerSparqlVariableBinding* binding;
};

struct _TrackerSparqlVariableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariablePrivate {
	char* _name;
	char* _sql_expression;
	char* sql_identifier;
};

struct _TrackerSparqlContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerSparqlContextPrivate * priv;
	TrackerSparqlContext* parent_context;
	GHashTable* var_set;
	GHashTable* var_map;
	GHashTable* select_var_set;
	GHashTable* predicate_variable_map;
	GHashTable* used_sql_identifiers;
	gboolean scalar_subquery;
};

struct _TrackerSparqlContextClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerSparqlContext *self);
};

struct _TrackerSparqlParamSpecContext {
	GParamSpec parent_instance;
};

struct _TrackerSparqlSelectContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlSelectContextPrivate * priv;
	TrackerPropertyType type;
};

struct _TrackerSparqlSelectContextClass {
	TrackerSparqlContextClass parent_class;
};

struct _TrackerSparqlQuery {
	GObject parent_instance;
	TrackerSparqlQueryPrivate * priv;
	TrackerSparqlExpression* expression;
	TrackerSparqlPattern* pattern;
	GList* bindings;
	TrackerSparqlContext* context;
};

struct _TrackerSparqlQueryClass {
	GObjectClass parent_class;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH
} TrackerSparqlTokenType;

struct _TrackerSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

struct _TrackerSparqlQueryTokenInfo {
	TrackerSparqlTokenType type;
	TrackerSourceLocation begin;
	TrackerSourceLocation end;
};

struct _TrackerSparqlQueryPrivate {
	TrackerSparqlScanner* scanner;
	TrackerSparqlQueryTokenInfo* tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gint index;
	gint size;
	char* query_string;
	gboolean update_extensions;
	char* current_graph;
	char* current_subject;
	gboolean current_subject_is_var;
	char* current_predicate;
	gboolean current_predicate_is_var;
	GHashTable* prefix_map;
	gboolean delete_statements;
	gint bnodeid;
	guchar* base_uuid;
	gint base_uuid_length1;
	gint _base_uuid_size_;
	GHashTable* blank_nodes;
	gboolean anon_blank_node_open;
};


static gpointer tracker_sparql_data_table_parent_class = NULL;
static gpointer tracker_sparql_data_binding_parent_class = NULL;
static gpointer tracker_sparql_literal_binding_parent_class = NULL;
static gpointer tracker_sparql_variable_binding_parent_class = NULL;
static gpointer tracker_sparql_variable_binding_list_parent_class = NULL;
static gpointer tracker_sparql_variable_parent_class = NULL;
static gpointer tracker_sparql_context_parent_class = NULL;
static gpointer tracker_sparql_select_context_parent_class = NULL;
static gpointer tracker_sparql_query_parent_class = NULL;

GQuark tracker_sparql_error_quark (void);
GType tracker_sparql_variable_state_get_type (void);
GType tracker_sparql_data_table_get_type (void);
GType tracker_sparql_predicate_variable_get_type (void);
enum  {
	TRACKER_SPARQL_DATA_TABLE_DUMMY_PROPERTY
};
TrackerSparqlDataTable* tracker_sparql_data_table_new (void);
TrackerSparqlDataTable* tracker_sparql_data_table_construct (GType object_type);
static void tracker_sparql_data_table_finalize (GObject* obj);
GType tracker_sparql_data_binding_get_type (void);
#define TRACKER_SPARQL_DATA_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingPrivate))
enum  {
	TRACKER_SPARQL_DATA_BINDING_DUMMY_PROPERTY,
	TRACKER_SPARQL_DATA_BINDING_SQL_EXPRESSION
};
char* tracker_sparql_data_binding_get_extra_sql_expression (TrackerSparqlDataBinding* self, const char* suffix);
TrackerSparqlDataBinding* tracker_sparql_data_binding_construct (GType object_type);
const char* tracker_sparql_data_binding_get_sql_expression (TrackerSparqlDataBinding* self);
void tracker_sparql_data_binding_set_sql_expression (TrackerSparqlDataBinding* self, const char* value);
static void tracker_sparql_data_binding_finalize (GObject* obj);
static void tracker_sparql_data_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void tracker_sparql_data_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType tracker_sparql_literal_binding_get_type (void);
enum  {
	TRACKER_SPARQL_LITERAL_BINDING_DUMMY_PROPERTY
};
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_new (void);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_construct (GType object_type);
static void tracker_sparql_literal_binding_finalize (GObject* obj);
GType tracker_sparql_variable_binding_get_type (void);
GType tracker_sparql_variable_get_type (void);
enum  {
	TRACKER_SPARQL_VARIABLE_BINDING_DUMMY_PROPERTY
};
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_new (void);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_construct (GType object_type);
static void tracker_sparql_variable_binding_finalize (GObject* obj);
GType tracker_sparql_variable_binding_list_get_type (void);
enum  {
	TRACKER_SPARQL_VARIABLE_BINDING_LIST_DUMMY_PROPERTY
};
static void _g_list_free_g_object_unref (GList* self);
TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_new (void);
TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_construct (GType object_type);
static void tracker_sparql_variable_binding_list_finalize (GObject* obj);
#define TRACKER_SPARQL_VARIABLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariablePrivate))
enum  {
	TRACKER_SPARQL_VARIABLE_DUMMY_PROPERTY,
	TRACKER_SPARQL_VARIABLE_NAME,
	TRACKER_SPARQL_VARIABLE_SQL_EXPRESSION
};
static void tracker_sparql_variable_set_name (TrackerSparqlVariable* self, const char* value);
static void tracker_sparql_variable_set_sql_expression (TrackerSparqlVariable* self, const char* value);
TrackerSparqlVariable* tracker_sparql_variable_new (const char* name, const char* sql_identifier);
TrackerSparqlVariable* tracker_sparql_variable_construct (GType object_type, const char* name, const char* sql_identifier);
char* tracker_sparql_variable_get_extra_sql_expression (TrackerSparqlVariable* self, const char* suffix);
const char* tracker_sparql_variable_get_name (TrackerSparqlVariable* self);
const char* tracker_sparql_variable_get_sql_expression (TrackerSparqlVariable* self);
static void tracker_sparql_variable_finalize (GObject* obj);
static void tracker_sparql_variable_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void tracker_sparql_variable_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
gpointer tracker_sparql_context_ref (gpointer instance);
void tracker_sparql_context_unref (gpointer instance);
GParamSpec* tracker_sparql_param_spec_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_sparql_value_set_context (GValue* value, gpointer v_object);
void tracker_sparql_value_take_context (GValue* value, gpointer v_object);
gpointer tracker_sparql_value_get_context (const GValue* value);
GType tracker_sparql_context_get_type (void);
enum  {
	TRACKER_SPARQL_CONTEXT_DUMMY_PROPERTY
};
TrackerSparqlContext* tracker_sparql_context_new (TrackerSparqlContext* parent_context);
TrackerSparqlContext* tracker_sparql_context_construct (GType object_type, TrackerSparqlContext* parent_context);
TrackerSparqlContext* tracker_sparql_context_new_subquery (TrackerSparqlContext* parent_context);
TrackerSparqlContext* tracker_sparql_context_construct_subquery (GType object_type, TrackerSparqlContext* parent_context);
TrackerSparqlVariable* tracker_sparql_context_get_variable (TrackerSparqlContext* self, const char* name);
static void tracker_sparql_context_finalize (TrackerSparqlContext* obj);
GType tracker_sparql_select_context_get_type (void);
enum  {
	TRACKER_SPARQL_SELECT_CONTEXT_DUMMY_PROPERTY
};
TrackerSparqlSelectContext* tracker_sparql_select_context_new (TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_construct (GType object_type, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_new_subquery (TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_construct_subquery (GType object_type, TrackerSparqlContext* parent_context);
static void tracker_sparql_select_context_finalize (TrackerSparqlContext* obj);
GType tracker_sparql_query_get_type (void);
GType tracker_sparql_expression_get_type (void);
GType tracker_sparql_pattern_get_type (void);
GType tracker_sparql_scanner_get_type (void);
static GType tracker_sparql_query_token_info_get_type (void) G_GNUC_UNUSED;
GType tracker_sparql_token_type_get_type (void);
GType tracker_source_location_get_type (void);
TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self);
void tracker_source_location_free (TrackerSourceLocation* self);
static TrackerSparqlQueryTokenInfo* tracker_sparql_query_token_info_dup (const TrackerSparqlQueryTokenInfo* self);
static void tracker_sparql_query_token_info_free (TrackerSparqlQueryTokenInfo* self);
#define TRACKER_SPARQL_QUERY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryPrivate))
enum  {
	TRACKER_SPARQL_QUERY_DUMMY_PROPERTY
};
#define TRACKER_SPARQL_QUERY_BUFFER_SIZE 32
#define TRACKER_SPARQL_QUERY_FN_NS "http://www.w3.org/2005/xpath-functions#"
void uuid_generate (guchar* uuid);
TrackerSparqlExpression* tracker_sparql_expression_new (TrackerSparqlQuery* query);
TrackerSparqlExpression* tracker_sparql_expression_construct (GType object_type, TrackerSparqlQuery* query);
TrackerSparqlPattern* tracker_sparql_pattern_new (TrackerSparqlQuery* query);
TrackerSparqlPattern* tracker_sparql_pattern_construct (GType object_type, TrackerSparqlQuery* query);
TrackerSparqlQuery* tracker_sparql_query_new (const char* query);
TrackerSparqlQuery* tracker_sparql_query_construct (GType object_type, const char* query);
TrackerSparqlQuery* tracker_sparql_query_new_update (const char* query);
TrackerSparqlQuery* tracker_sparql_query_construct_update (GType object_type, const char* query);
static char* tracker_sparql_query_get_uuid_for_name (TrackerSparqlQuery* self, guchar* base_uuid, int base_uuid_length1, const char* name);
char* tracker_sparql_query_generate_bnodeid (TrackerSparqlQuery* self, const char* user_bnodeid);
TrackerSparqlTokenType tracker_sparql_scanner_read_token (TrackerSparqlScanner* self, TrackerSourceLocation* token_begin, TrackerSourceLocation* token_end, GError** error);
gboolean tracker_sparql_query_next (TrackerSparqlQuery* self, GError** error);
TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self);
TrackerSparqlTokenType tracker_sparql_query_last (TrackerSparqlQuery* self);
gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self, const char* msg);
GError* tracker_sparql_query_get_internal_error (TrackerSparqlQuery* self, const char* msg);
const char* tracker_sparql_token_type_to_string (TrackerSparqlTokenType self);
gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
void tracker_sparql_query_get_location (TrackerSparqlQuery* self, TrackerSourceLocation* result);
void tracker_sparql_scanner_seek (TrackerSparqlScanner* self, TrackerSourceLocation* location);
void tracker_sparql_query_set_location (TrackerSparqlQuery* self, TrackerSourceLocation* location);
char* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self, gint strip);
static void tracker_sparql_query_parse_prologue (TrackerSparqlQuery* self, GError** error);
TrackerSparqlScanner* tracker_sparql_scanner_new (gchar* input, gsize len);
TrackerSparqlScanner* tracker_sparql_scanner_construct (GType object_type, gchar* input, gsize len);
static TrackerDBResultSet* tracker_sparql_query_execute_select (TrackerSparqlQuery* self, GError** error);
static TrackerDBResultSet* tracker_sparql_query_execute_ask (TrackerSparqlQuery* self, GError** error);
TrackerDBResultSet* tracker_sparql_query_execute (TrackerSparqlQuery* self, GError** error);
static GPtrArray* tracker_sparql_query_execute_insert_or_delete (TrackerSparqlQuery* self, gboolean blank, GError** error);
static void tracker_sparql_query_execute_drop_graph (TrackerSparqlQuery* self, GError** error);
GPtrArray* tracker_sparql_query_execute_update (TrackerSparqlQuery* self, gboolean blank, GError** error);
static TrackerDBResultSet* tracker_sparql_query_exec_sql (TrackerSparqlQuery* self, const char* sql, GError** error);
TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self, GString* sql, gboolean subquery, gboolean scalar_subquery, GError** error);
TrackerSparqlContext* tracker_sparql_pattern_translate_group_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error);
char* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self, const char* prefix, const char* local_name, GError** error);
static void tracker_sparql_query_parse_from_or_into_param (TrackerSparqlQuery* self, GError** error);
static void tracker_sparql_query_skip_braces (TrackerSparqlQuery* self, GError** error);
void tracker_sparql_expression_append_expression_as_string (GString* sql, const char* expression, TrackerPropertyType type);
static char* tracker_sparql_query_get_string_for_value (GValue* value);
static void tracker_sparql_query_parse_construct_triples_block (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error);
char* tracker_sparql_pattern_parse_var_or_term (TrackerSparqlPattern* self, GString* sql, gboolean* is_var, GError** error);
static char* tracker_sparql_query_parse_construct_var_or_term (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error);
static void tracker_sparql_query_parse_construct_property_list_not_empty (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error);
char* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error);
static void tracker_sparql_query_parse_construct_object_list (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error);
static void tracker_sparql_query_parse_construct_object (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error);
static void tracker_sparql_query_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark tracker_sparql_error_quark (void) {
	return g_quark_from_static_string ("tracker_sparql_error-quark");
}


GType tracker_sparql_variable_state_get_type (void) {
	static volatile gsize tracker_sparql_variable_state_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_variable_state_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_VARIABLE_STATE_NONE, "TRACKER_SPARQL_VARIABLE_STATE_NONE", "none"}, {TRACKER_SPARQL_VARIABLE_STATE_BOUND, "TRACKER_SPARQL_VARIABLE_STATE_BOUND", "bound"}, {TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL, "TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL", "optional"}, {0, NULL, NULL}};
		GType tracker_sparql_variable_state_type_id;
		tracker_sparql_variable_state_type_id = g_enum_register_static ("TrackerSparqlVariableState", values);
		g_once_init_leave (&tracker_sparql_variable_state_type_id__volatile, tracker_sparql_variable_state_type_id);
	}
	return tracker_sparql_variable_state_type_id__volatile;
}


TrackerSparqlDataTable* tracker_sparql_data_table_construct (GType object_type) {
	TrackerSparqlDataTable * self;
	self = (TrackerSparqlDataTable*) g_object_new (object_type, NULL);
	return self;
}


TrackerSparqlDataTable* tracker_sparql_data_table_new (void) {
	return tracker_sparql_data_table_construct (TRACKER_SPARQL_TYPE_DATA_TABLE);
}


static void tracker_sparql_data_table_class_init (TrackerSparqlDataTableClass * klass) {
	tracker_sparql_data_table_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_data_table_finalize;
}


static void tracker_sparql_data_table_instance_init (TrackerSparqlDataTable * self) {
}


static void tracker_sparql_data_table_finalize (GObject* obj) {
	TrackerSparqlDataTable * self;
	self = TRACKER_SPARQL_DATA_TABLE (obj);
	_g_free0 (self->sql_db_tablename);
	_g_free0 (self->sql_query_tablename);
	_g_object_unref0 (self->predicate_variable);
	G_OBJECT_CLASS (tracker_sparql_data_table_parent_class)->finalize (obj);
}


GType tracker_sparql_data_table_get_type (void) {
	static volatile gsize tracker_sparql_data_table_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_data_table_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlDataTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_data_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlDataTable), 0, (GInstanceInitFunc) tracker_sparql_data_table_instance_init, NULL };
		GType tracker_sparql_data_table_type_id;
		tracker_sparql_data_table_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlDataTable", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_data_table_type_id__volatile, tracker_sparql_data_table_type_id);
	}
	return tracker_sparql_data_table_type_id__volatile;
}


char* tracker_sparql_data_binding_get_extra_sql_expression (TrackerSparqlDataBinding* self, const char* suffix) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (suffix != NULL, NULL);
	result = g_strdup_printf ("\"%s\".\"%s:%s\"", self->table->sql_query_tablename, self->sql_db_column_name, suffix);
	return result;
}


TrackerSparqlDataBinding* tracker_sparql_data_binding_construct (GType object_type) {
	TrackerSparqlDataBinding * self;
	self = (TrackerSparqlDataBinding*) g_object_new (object_type, NULL);
	return self;
}


const char* tracker_sparql_data_binding_get_sql_expression (TrackerSparqlDataBinding* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_sql_expression == NULL) {
		char* _tmp0_;
		self->priv->_sql_expression = (_tmp0_ = g_strdup_printf ("\"%s\".\"%s\"", self->table->sql_query_tablename, self->sql_db_column_name), _g_free0 (self->priv->_sql_expression), _tmp0_);
	}
	result = self->priv->_sql_expression;
	return result;
}


void tracker_sparql_data_binding_set_sql_expression (TrackerSparqlDataBinding* self, const char* value) {
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_sql_expression = (_tmp1_ = g_strdup (value), _g_free0 (self->priv->_sql_expression), _tmp1_);
	g_object_notify ((GObject *) self, "sql-expression");
}


static void tracker_sparql_data_binding_class_init (TrackerSparqlDataBindingClass * klass) {
	tracker_sparql_data_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerSparqlDataBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = tracker_sparql_data_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = tracker_sparql_data_binding_set_property;
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_data_binding_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_DATA_BINDING_SQL_EXPRESSION, g_param_spec_string ("sql-expression", "sql-expression", "sql-expression", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void tracker_sparql_data_binding_instance_init (TrackerSparqlDataBinding * self) {
	self->priv = TRACKER_SPARQL_DATA_BINDING_GET_PRIVATE (self);
}


static void tracker_sparql_data_binding_finalize (GObject* obj) {
	TrackerSparqlDataBinding * self;
	self = TRACKER_SPARQL_DATA_BINDING (obj);
	_g_object_unref0 (self->table);
	_g_free0 (self->sql_db_column_name);
	_g_free0 (self->priv->_sql_expression);
	G_OBJECT_CLASS (tracker_sparql_data_binding_parent_class)->finalize (obj);
}


GType tracker_sparql_data_binding_get_type (void) {
	static volatile gsize tracker_sparql_data_binding_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_data_binding_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlDataBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_data_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlDataBinding), 0, (GInstanceInitFunc) tracker_sparql_data_binding_instance_init, NULL };
		GType tracker_sparql_data_binding_type_id;
		tracker_sparql_data_binding_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlDataBinding", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&tracker_sparql_data_binding_type_id__volatile, tracker_sparql_data_binding_type_id);
	}
	return tracker_sparql_data_binding_type_id__volatile;
}


static void tracker_sparql_data_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlDataBinding * self;
	self = TRACKER_SPARQL_DATA_BINDING (object);
	switch (property_id) {
		case TRACKER_SPARQL_DATA_BINDING_SQL_EXPRESSION:
		g_value_set_string (value, tracker_sparql_data_binding_get_sql_expression (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void tracker_sparql_data_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSparqlDataBinding * self;
	self = TRACKER_SPARQL_DATA_BINDING (object);
	switch (property_id) {
		case TRACKER_SPARQL_DATA_BINDING_SQL_EXPRESSION:
		tracker_sparql_data_binding_set_sql_expression (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_construct (GType object_type) {
	TrackerSparqlLiteralBinding * self;
	self = (TrackerSparqlLiteralBinding*) tracker_sparql_data_binding_construct (object_type);
	return self;
}


TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_new (void) {
	return tracker_sparql_literal_binding_construct (TRACKER_SPARQL_TYPE_LITERAL_BINDING);
}


static void tracker_sparql_literal_binding_class_init (TrackerSparqlLiteralBindingClass * klass) {
	tracker_sparql_literal_binding_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_literal_binding_finalize;
}


static void tracker_sparql_literal_binding_instance_init (TrackerSparqlLiteralBinding * self) {
}


static void tracker_sparql_literal_binding_finalize (GObject* obj) {
	TrackerSparqlLiteralBinding * self;
	self = TRACKER_SPARQL_LITERAL_BINDING (obj);
	_g_free0 (self->literal);
	G_OBJECT_CLASS (tracker_sparql_literal_binding_parent_class)->finalize (obj);
}


GType tracker_sparql_literal_binding_get_type (void) {
	static volatile gsize tracker_sparql_literal_binding_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_literal_binding_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlLiteralBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_literal_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlLiteralBinding), 0, (GInstanceInitFunc) tracker_sparql_literal_binding_instance_init, NULL };
		GType tracker_sparql_literal_binding_type_id;
		tracker_sparql_literal_binding_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_DATA_BINDING, "TrackerSparqlLiteralBinding", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_literal_binding_type_id__volatile, tracker_sparql_literal_binding_type_id);
	}
	return tracker_sparql_literal_binding_type_id__volatile;
}


TrackerSparqlVariableBinding* tracker_sparql_variable_binding_construct (GType object_type) {
	TrackerSparqlVariableBinding * self;
	self = (TrackerSparqlVariableBinding*) tracker_sparql_data_binding_construct (object_type);
	return self;
}


TrackerSparqlVariableBinding* tracker_sparql_variable_binding_new (void) {
	return tracker_sparql_variable_binding_construct (TRACKER_SPARQL_TYPE_VARIABLE_BINDING);
}


static void tracker_sparql_variable_binding_class_init (TrackerSparqlVariableBindingClass * klass) {
	tracker_sparql_variable_binding_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_variable_binding_finalize;
}


static void tracker_sparql_variable_binding_instance_init (TrackerSparqlVariableBinding * self) {
}


static void tracker_sparql_variable_binding_finalize (GObject* obj) {
	TrackerSparqlVariableBinding * self;
	self = TRACKER_SPARQL_VARIABLE_BINDING (obj);
	_g_object_unref0 (self->type);
	G_OBJECT_CLASS (tracker_sparql_variable_binding_parent_class)->finalize (obj);
}


GType tracker_sparql_variable_binding_get_type (void) {
	static volatile gsize tracker_sparql_variable_binding_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_variable_binding_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlVariableBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_variable_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlVariableBinding), 0, (GInstanceInitFunc) tracker_sparql_variable_binding_instance_init, NULL };
		GType tracker_sparql_variable_binding_type_id;
		tracker_sparql_variable_binding_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_DATA_BINDING, "TrackerSparqlVariableBinding", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_variable_binding_type_id__volatile, tracker_sparql_variable_binding_type_id);
	}
	return tracker_sparql_variable_binding_type_id__volatile;
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_construct (GType object_type) {
	TrackerSparqlVariableBindingList * self;
	self = (TrackerSparqlVariableBindingList*) g_object_new (object_type, NULL);
	return self;
}


TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_new (void) {
	return tracker_sparql_variable_binding_list_construct (TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST);
}


static void tracker_sparql_variable_binding_list_class_init (TrackerSparqlVariableBindingListClass * klass) {
	tracker_sparql_variable_binding_list_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_variable_binding_list_finalize;
}


static void tracker_sparql_variable_binding_list_instance_init (TrackerSparqlVariableBindingList * self) {
}


static void tracker_sparql_variable_binding_list_finalize (GObject* obj) {
	TrackerSparqlVariableBindingList * self;
	self = TRACKER_SPARQL_VARIABLE_BINDING_LIST (obj);
	__g_list_free_g_object_unref0 (self->list);
	G_OBJECT_CLASS (tracker_sparql_variable_binding_list_parent_class)->finalize (obj);
}


GType tracker_sparql_variable_binding_list_get_type (void) {
	static volatile gsize tracker_sparql_variable_binding_list_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_variable_binding_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlVariableBindingListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_variable_binding_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlVariableBindingList), 0, (GInstanceInitFunc) tracker_sparql_variable_binding_list_instance_init, NULL };
		GType tracker_sparql_variable_binding_list_type_id;
		tracker_sparql_variable_binding_list_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlVariableBindingList", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_variable_binding_list_type_id__volatile, tracker_sparql_variable_binding_list_type_id);
	}
	return tracker_sparql_variable_binding_list_type_id__volatile;
}


TrackerSparqlVariable* tracker_sparql_variable_construct (GType object_type, const char* name, const char* sql_identifier) {
	TrackerSparqlVariable * self;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (sql_identifier != NULL, NULL);
	self = (TrackerSparqlVariable*) g_object_new (object_type, NULL);
	tracker_sparql_variable_set_name (self, name);
	self->priv->sql_identifier = (_tmp0_ = g_strdup (sql_identifier), _g_free0 (self->priv->sql_identifier), _tmp0_);
	tracker_sparql_variable_set_sql_expression (self, _tmp1_ = g_strdup_printf ("\"%s\"", sql_identifier));
	_g_free0 (_tmp1_);
	return self;
}


TrackerSparqlVariable* tracker_sparql_variable_new (const char* name, const char* sql_identifier) {
	return tracker_sparql_variable_construct (TRACKER_SPARQL_TYPE_VARIABLE, name, sql_identifier);
}


char* tracker_sparql_variable_get_extra_sql_expression (TrackerSparqlVariable* self, const char* suffix) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (suffix != NULL, NULL);
	result = g_strdup_printf ("\"%s:%s\"", self->priv->sql_identifier, suffix);
	return result;
}


const char* tracker_sparql_variable_get_name (TrackerSparqlVariable* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_name;
	return result;
}


static void tracker_sparql_variable_set_name (TrackerSparqlVariable* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_name), _tmp0_);
	g_object_notify ((GObject *) self, "name");
}


const char* tracker_sparql_variable_get_sql_expression (TrackerSparqlVariable* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_sql_expression;
	return result;
}


static void tracker_sparql_variable_set_sql_expression (TrackerSparqlVariable* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_sql_expression = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_sql_expression), _tmp0_);
	g_object_notify ((GObject *) self, "sql-expression");
}


static void tracker_sparql_variable_class_init (TrackerSparqlVariableClass * klass) {
	tracker_sparql_variable_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerSparqlVariablePrivate));
	G_OBJECT_CLASS (klass)->get_property = tracker_sparql_variable_get_property;
	G_OBJECT_CLASS (klass)->set_property = tracker_sparql_variable_set_property;
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_variable_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_VARIABLE_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_SPARQL_VARIABLE_SQL_EXPRESSION, g_param_spec_string ("sql-expression", "sql-expression", "sql-expression", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void tracker_sparql_variable_instance_init (TrackerSparqlVariable * self) {
	self->priv = TRACKER_SPARQL_VARIABLE_GET_PRIVATE (self);
}


static void tracker_sparql_variable_finalize (GObject* obj) {
	TrackerSparqlVariable * self;
	self = TRACKER_SPARQL_VARIABLE (obj);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_sql_expression);
	_g_object_unref0 (self->binding);
	_g_free0 (self->priv->sql_identifier);
	G_OBJECT_CLASS (tracker_sparql_variable_parent_class)->finalize (obj);
}


GType tracker_sparql_variable_get_type (void) {
	static volatile gsize tracker_sparql_variable_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlVariable), 0, (GInstanceInitFunc) tracker_sparql_variable_instance_init, NULL };
		GType tracker_sparql_variable_type_id;
		tracker_sparql_variable_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlVariable", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_variable_type_id__volatile, tracker_sparql_variable_type_id);
	}
	return tracker_sparql_variable_type_id__volatile;
}


static void tracker_sparql_variable_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlVariable * self;
	self = TRACKER_SPARQL_VARIABLE (object);
	switch (property_id) {
		case TRACKER_SPARQL_VARIABLE_NAME:
		g_value_set_string (value, tracker_sparql_variable_get_name (self));
		break;
		case TRACKER_SPARQL_VARIABLE_SQL_EXPRESSION:
		g_value_set_string (value, tracker_sparql_variable_get_sql_expression (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void tracker_sparql_variable_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSparqlVariable * self;
	self = TRACKER_SPARQL_VARIABLE (object);
	switch (property_id) {
		case TRACKER_SPARQL_VARIABLE_NAME:
		tracker_sparql_variable_set_name (self, g_value_get_string (value));
		break;
		case TRACKER_SPARQL_VARIABLE_SQL_EXPRESSION:
		tracker_sparql_variable_set_sql_expression (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gpointer _tracker_sparql_context_ref0 (gpointer self) {
	return self ? tracker_sparql_context_ref (self) : NULL;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


TrackerSparqlContext* tracker_sparql_context_construct (GType object_type, TrackerSparqlContext* parent_context) {
	TrackerSparqlContext* self;
	TrackerSparqlContext* _tmp0_;
	GHashTable* _tmp1_;
	self = (TrackerSparqlContext*) g_type_create_instance (object_type);
	self->parent_context = (_tmp0_ = _tracker_sparql_context_ref0 (parent_context), _tracker_sparql_context_unref0 (self->parent_context), _tmp0_);
	self->var_set = (_tmp1_ = g_hash_table_new_full (g_direct_hash, g_direct_equal, g_object_unref, NULL), _g_hash_table_unref0 (self->var_set), _tmp1_);
	if (parent_context == NULL) {
		GHashTable* _tmp2_;
		GHashTable* _tmp3_;
		GHashTable* _tmp4_;
		GHashTable* _tmp5_;
		self->select_var_set = (_tmp2_ = g_hash_table_new_full (g_direct_hash, g_direct_equal, g_object_unref, NULL), _g_hash_table_unref0 (self->select_var_set), _tmp2_);
		self->var_map = (_tmp3_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref), _g_hash_table_unref0 (self->var_map), _tmp3_);
		self->predicate_variable_map = (_tmp4_ = g_hash_table_new_full (g_direct_hash, g_direct_equal, g_object_unref, g_object_unref), _g_hash_table_unref0 (self->predicate_variable_map), _tmp4_);
		self->used_sql_identifiers = (_tmp5_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL), _g_hash_table_unref0 (self->used_sql_identifiers), _tmp5_);
	} else {
		GHashTable* _tmp6_;
		GHashTable* _tmp7_;
		GHashTable* _tmp8_;
		GHashTable* _tmp9_;
		self->select_var_set = (_tmp6_ = _g_hash_table_ref0 (parent_context->select_var_set), _g_hash_table_unref0 (self->select_var_set), _tmp6_);
		self->var_map = (_tmp7_ = _g_hash_table_ref0 (parent_context->var_map), _g_hash_table_unref0 (self->var_map), _tmp7_);
		self->predicate_variable_map = (_tmp8_ = _g_hash_table_ref0 (parent_context->predicate_variable_map), _g_hash_table_unref0 (self->predicate_variable_map), _tmp8_);
		self->used_sql_identifiers = (_tmp9_ = _g_hash_table_ref0 (parent_context->used_sql_identifiers), _g_hash_table_unref0 (self->used_sql_identifiers), _tmp9_);
	}
	return self;
}


TrackerSparqlContext* tracker_sparql_context_new (TrackerSparqlContext* parent_context) {
	return tracker_sparql_context_construct (TRACKER_SPARQL_TYPE_CONTEXT, parent_context);
}


TrackerSparqlContext* tracker_sparql_context_construct_subquery (GType object_type, TrackerSparqlContext* parent_context) {
	TrackerSparqlContext* self;
	TrackerSparqlContext* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	g_return_val_if_fail (parent_context != NULL, NULL);
	self = (TrackerSparqlContext*) g_type_create_instance (object_type);
	self->parent_context = (_tmp0_ = _tracker_sparql_context_ref0 (parent_context), _tracker_sparql_context_unref0 (self->parent_context), _tmp0_);
	self->var_set = (_tmp1_ = g_hash_table_new_full (g_direct_hash, g_direct_equal, g_object_unref, NULL), _g_hash_table_unref0 (self->var_set), _tmp1_);
	self->select_var_set = (_tmp2_ = g_hash_table_new_full (g_direct_hash, g_direct_equal, g_object_unref, NULL), _g_hash_table_unref0 (self->select_var_set), _tmp2_);
	self->var_map = (_tmp3_ = _g_hash_table_ref0 (parent_context->var_map), _g_hash_table_unref0 (self->var_map), _tmp3_);
	self->predicate_variable_map = (_tmp4_ = g_hash_table_new_full (g_direct_hash, g_direct_equal, g_object_unref, g_object_unref), _g_hash_table_unref0 (self->predicate_variable_map), _tmp4_);
	self->used_sql_identifiers = (_tmp5_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL), _g_hash_table_unref0 (self->used_sql_identifiers), _tmp5_);
	self->scalar_subquery = TRUE;
	return self;
}


TrackerSparqlContext* tracker_sparql_context_new_subquery (TrackerSparqlContext* parent_context) {
	return tracker_sparql_context_construct_subquery (TRACKER_SPARQL_TYPE_CONTEXT, parent_context);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


TrackerSparqlVariable* tracker_sparql_context_get_variable (TrackerSparqlContext* self, const char* name) {
	TrackerSparqlVariable* result = NULL;
	TrackerSparqlVariable* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_result_ = (TrackerSparqlVariable*) g_hash_table_lookup (self->var_map, name);
	if (_result_ == NULL) {
		char* _tmp0_;
		char* _tmp1_;
		char* sql_identifier;
		TrackerSparqlVariable* variable;
		sql_identifier = (_tmp1_ = g_utf8_strdown (_tmp0_ = g_strdup_printf ("%s_u", name), -1), _g_free0 (_tmp0_), _tmp1_);
		{
			gint i;
			i = 1;
			{
				gboolean _tmp2_;
				_tmp2_ = TRUE;
				while (TRUE) {
					char* _tmp4_;
					char* _tmp3_;
					if (!_tmp2_) {
						i++;
					}
					_tmp2_ = FALSE;
					if (!GPOINTER_TO_INT (g_hash_table_lookup (self->used_sql_identifiers, sql_identifier))) {
						break;
					}
					sql_identifier = (_tmp4_ = g_utf8_strdown (_tmp3_ = g_strdup_printf ("%s_%d_u", name, i), -1), _g_free0 (sql_identifier), _tmp4_);
					_g_free0 (_tmp3_);
				}
			}
		}
		g_hash_table_insert (self->used_sql_identifiers, g_strdup (sql_identifier), GINT_TO_POINTER (TRUE));
		variable = tracker_sparql_variable_new (name, sql_identifier);
		g_hash_table_insert (self->var_map, g_strdup (name), _g_object_ref0 (variable));
		_result_ = variable;
		_g_free0 (sql_identifier);
		_g_object_unref0 (variable);
	}
	result = _result_;
	return result;
}


static void tracker_sparql_value_context_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void tracker_sparql_value_context_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		tracker_sparql_context_unref (value->data[0].v_pointer);
	}
}


static void tracker_sparql_value_context_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tracker_sparql_context_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer tracker_sparql_value_context_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* tracker_sparql_value_context_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TrackerSparqlContext* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tracker_sparql_context_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* tracker_sparql_value_context_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerSparqlContext** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tracker_sparql_context_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* tracker_sparql_param_spec_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerSparqlParamSpecContext* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_SPARQL_TYPE_CONTEXT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer tracker_sparql_value_get_context (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_SPARQL_TYPE_CONTEXT), NULL);
	return value->data[0].v_pointer;
}


void tracker_sparql_value_set_context (GValue* value, gpointer v_object) {
	TrackerSparqlContext* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_SPARQL_TYPE_CONTEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_SPARQL_TYPE_CONTEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tracker_sparql_context_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_sparql_context_unref (old);
	}
}


void tracker_sparql_value_take_context (GValue* value, gpointer v_object) {
	TrackerSparqlContext* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_SPARQL_TYPE_CONTEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_SPARQL_TYPE_CONTEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_sparql_context_unref (old);
	}
}


static void tracker_sparql_context_class_init (TrackerSparqlContextClass * klass) {
	tracker_sparql_context_parent_class = g_type_class_peek_parent (klass);
	TRACKER_SPARQL_CONTEXT_CLASS (klass)->finalize = tracker_sparql_context_finalize;
}


static void tracker_sparql_context_instance_init (TrackerSparqlContext * self) {
	self->ref_count = 1;
}


static void tracker_sparql_context_finalize (TrackerSparqlContext* obj) {
	TrackerSparqlContext * self;
	self = TRACKER_SPARQL_CONTEXT (obj);
	_tracker_sparql_context_unref0 (self->parent_context);
	_g_hash_table_unref0 (self->var_set);
	_g_hash_table_unref0 (self->var_map);
	_g_hash_table_unref0 (self->select_var_set);
	_g_hash_table_unref0 (self->predicate_variable_map);
	_g_hash_table_unref0 (self->used_sql_identifiers);
}


GType tracker_sparql_context_get_type (void) {
	static volatile gsize tracker_sparql_context_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_context_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_sparql_value_context_init, tracker_sparql_value_context_free_value, tracker_sparql_value_context_copy_value, tracker_sparql_value_context_peek_pointer, "p", tracker_sparql_value_context_collect_value, "p", tracker_sparql_value_context_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlContext), 0, (GInstanceInitFunc) tracker_sparql_context_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_sparql_context_type_id;
		tracker_sparql_context_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerSparqlContext", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_sparql_context_type_id__volatile, tracker_sparql_context_type_id);
	}
	return tracker_sparql_context_type_id__volatile;
}


gpointer tracker_sparql_context_ref (gpointer instance) {
	TrackerSparqlContext* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void tracker_sparql_context_unref (gpointer instance) {
	TrackerSparqlContext* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TRACKER_SPARQL_CONTEXT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


TrackerSparqlSelectContext* tracker_sparql_select_context_construct (GType object_type, TrackerSparqlContext* parent_context) {
	TrackerSparqlSelectContext* self;
	self = (TrackerSparqlSelectContext*) tracker_sparql_context_construct (object_type, parent_context);
	return self;
}


TrackerSparqlSelectContext* tracker_sparql_select_context_new (TrackerSparqlContext* parent_context) {
	return tracker_sparql_select_context_construct (TRACKER_SPARQL_TYPE_SELECT_CONTEXT, parent_context);
}


TrackerSparqlSelectContext* tracker_sparql_select_context_construct_subquery (GType object_type, TrackerSparqlContext* parent_context) {
	TrackerSparqlSelectContext* self;
	g_return_val_if_fail (parent_context != NULL, NULL);
	self = (TrackerSparqlSelectContext*) tracker_sparql_context_construct_subquery (object_type, parent_context);
	return self;
}


TrackerSparqlSelectContext* tracker_sparql_select_context_new_subquery (TrackerSparqlContext* parent_context) {
	return tracker_sparql_select_context_construct_subquery (TRACKER_SPARQL_TYPE_SELECT_CONTEXT, parent_context);
}


static void tracker_sparql_select_context_class_init (TrackerSparqlSelectContextClass * klass) {
	tracker_sparql_select_context_parent_class = g_type_class_peek_parent (klass);
	TRACKER_SPARQL_CONTEXT_CLASS (klass)->finalize = tracker_sparql_select_context_finalize;
}


static void tracker_sparql_select_context_instance_init (TrackerSparqlSelectContext * self) {
}


static void tracker_sparql_select_context_finalize (TrackerSparqlContext* obj) {
	TrackerSparqlSelectContext * self;
	self = TRACKER_SPARQL_SELECT_CONTEXT (obj);
	TRACKER_SPARQL_CONTEXT_CLASS (tracker_sparql_select_context_parent_class)->finalize (obj);
}


GType tracker_sparql_select_context_get_type (void) {
	static volatile gsize tracker_sparql_select_context_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_select_context_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlSelectContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_select_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlSelectContext), 0, (GInstanceInitFunc) tracker_sparql_select_context_instance_init, NULL };
		GType tracker_sparql_select_context_type_id;
		tracker_sparql_select_context_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONTEXT, "TrackerSparqlSelectContext", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_select_context_type_id__volatile, tracker_sparql_select_context_type_id);
	}
	return tracker_sparql_select_context_type_id__volatile;
}


TrackerSparqlQuery* tracker_sparql_query_construct (GType object_type, const char* query) {
	TrackerSparqlQuery * self;
	TrackerSparqlQueryTokenInfo* _tmp0_;
	GHashTable* _tmp1_;
	guchar* _tmp2_;
	char* _tmp3_;
	TrackerSparqlExpression* _tmp4_;
	TrackerSparqlPattern* _tmp5_;
	g_return_val_if_fail (query != NULL, NULL);
	self = (TrackerSparqlQuery*) g_object_new (object_type, NULL);
	self->priv->tokens = (_tmp0_ = g_new0 (TrackerSparqlQueryTokenInfo, TRACKER_SPARQL_QUERY_BUFFER_SIZE), self->priv->tokens = (g_free (self->priv->tokens), NULL), self->priv->tokens_length1 = TRACKER_SPARQL_QUERY_BUFFER_SIZE, self->priv->_tokens_size_ = self->priv->tokens_length1, _tmp0_);
	self->priv->prefix_map = (_tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free), _g_hash_table_unref0 (self->priv->prefix_map), _tmp1_);
	self->priv->base_uuid = (_tmp2_ = g_new0 (guchar, 16), self->priv->base_uuid = (g_free (self->priv->base_uuid), NULL), self->priv->base_uuid_length1 = 16, self->priv->_base_uuid_size_ = self->priv->base_uuid_length1, _tmp2_);
	uuid_generate (self->priv->base_uuid);
	self->priv->query_string = (_tmp3_ = g_strdup (query), _g_free0 (self->priv->query_string), _tmp3_);
	self->expression = (_tmp4_ = tracker_sparql_expression_new (self), _g_object_unref0 (self->expression), _tmp4_);
	self->pattern = (_tmp5_ = tracker_sparql_pattern_new (self), _g_object_unref0 (self->pattern), _tmp5_);
	return self;
}


TrackerSparqlQuery* tracker_sparql_query_new (const char* query) {
	return tracker_sparql_query_construct (TRACKER_SPARQL_TYPE_QUERY, query);
}


TrackerSparqlQuery* tracker_sparql_query_construct_update (GType object_type, const char* query) {
	TrackerSparqlQuery * self;
	g_return_val_if_fail (query != NULL, NULL);
	self = (TrackerSparqlQuery*) tracker_sparql_query_construct (object_type, query);
	self->priv->update_extensions = TRUE;
	return self;
}


TrackerSparqlQuery* tracker_sparql_query_new_update (const char* query) {
	return tracker_sparql_query_construct_update (TRACKER_SPARQL_TYPE_QUERY, query);
}


static char* tracker_sparql_query_get_uuid_for_name (TrackerSparqlQuery* self, guchar* base_uuid, int base_uuid_length1, const char* name) {
	char* result = NULL;
	GChecksum* checksum;
	char* sha1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	checksum = g_checksum_new (G_CHECKSUM_SHA1);
	g_checksum_update (checksum, base_uuid, (gsize) 16);
	g_checksum_update (checksum, (guchar*) name, (gsize) (-1));
	sha1 = g_strdup (g_checksum_get_string (checksum));
	result = g_strdup_printf ("urn:uuid:%.8s-%.4s-%.4s-%.4s-%.12s", sha1, g_utf8_offset_to_pointer (sha1, (glong) 8), g_utf8_offset_to_pointer (sha1, (glong) 12), g_utf8_offset_to_pointer (sha1, (glong) 16), g_utf8_offset_to_pointer (sha1, (glong) 20));
	_g_checksum_free0 (checksum);
	_g_free0 (sha1);
	return result;
}


char* tracker_sparql_query_generate_bnodeid (TrackerSparqlQuery* self, const char* user_bnodeid) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (user_bnodeid == NULL) {
		result = g_strdup_printf (":%d", self->priv->bnodeid = self->priv->bnodeid + 1);
		return result;
	} else {
		char* uri;
		char* _tmp1_;
		uri = NULL;
		if (self->priv->blank_nodes != NULL) {
			char* _tmp0_;
			uri = (_tmp0_ = g_strdup ((const char*) g_hash_table_lookup (self->priv->blank_nodes, user_bnodeid)), _g_free0 (uri), _tmp0_);
			if (uri != NULL) {
				result = uri;
				return result;
			}
		}
		uri = (_tmp1_ = tracker_sparql_query_get_uuid_for_name (self, self->priv->base_uuid, self->priv->base_uuid_length1, user_bnodeid), _g_free0 (uri), _tmp1_);
		if (self->priv->blank_nodes != NULL) {
			while (TRUE) {
				guchar* _tmp2_;
				gint _new_base_uuid_size_;
				gint new_base_uuid_length1;
				guchar* new_base_uuid;
				char* _tmp3_;
				if (!(tracker_data_query_resource_id (uri) > 0)) {
					break;
				}
				new_base_uuid = (_tmp2_ = g_new0 (guchar, 16), new_base_uuid_length1 = 16, _new_base_uuid_size_ = new_base_uuid_length1, _tmp2_);
				uuid_generate (new_base_uuid);
				uri = (_tmp3_ = tracker_sparql_query_get_uuid_for_name (self, new_base_uuid, new_base_uuid_length1, user_bnodeid), _g_free0 (uri), _tmp3_);
				new_base_uuid = (g_free (new_base_uuid), NULL);
			}
			g_hash_table_insert (self->priv->blank_nodes, g_strdup (user_bnodeid), g_strdup (uri));
		}
		result = uri;
		return result;
	}
}


gboolean tracker_sparql_query_next (TrackerSparqlQuery* self, GError** error) {
	gboolean result = FALSE;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	self->priv->index = (self->priv->index + 1) % TRACKER_SPARQL_QUERY_BUFFER_SIZE;
	self->priv->size--;
	if (self->priv->size <= 0) {
		TrackerSourceLocation begin = {0};
		TrackerSourceLocation end = {0};
		TrackerSparqlTokenType type;
		type = tracker_sparql_scanner_read_token (self->priv->scanner, &begin, &end, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		self->priv->tokens[self->priv->index].type = type;
		self->priv->tokens[self->priv->index].begin = begin;
		self->priv->tokens[self->priv->index].end = end;
		self->priv->size = 1;
	}
	result = self->priv->tokens[self->priv->index].type != TRACKER_SPARQL_TOKEN_TYPE_EOF;
	return result;
}


TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self) {
	TrackerSparqlTokenType result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->tokens[self->priv->index].type;
	return result;
}


TrackerSparqlTokenType tracker_sparql_query_last (TrackerSparqlQuery* self) {
	TrackerSparqlTokenType result = 0;
	gint last_index;
	g_return_val_if_fail (self != NULL, 0);
	last_index = ((self->priv->index + TRACKER_SPARQL_QUERY_BUFFER_SIZE) - 1) % TRACKER_SPARQL_QUERY_BUFFER_SIZE;
	result = self->priv->tokens[last_index].type;
	return result;
}


gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	if (tracker_sparql_query_current (self) == type) {
		tracker_sparql_query_next (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self, const char* msg) {
	GError* result = NULL;
	char* _tmp0_;
	GError* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	result = (_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, _tmp0_ = g_strdup_printf ("%d.%d: syntax error, %s", self->priv->tokens[self->priv->index].begin.line, self->priv->tokens[self->priv->index].begin.column, msg)), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


GError* tracker_sparql_query_get_internal_error (TrackerSparqlQuery* self, const char* msg) {
	GError* result = NULL;
	char* _tmp0_;
	GError* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	result = (_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _tmp0_ = g_strdup_printf ("%d.%d: %s", self->priv->tokens[self->priv->index].begin.line, self->priv->tokens[self->priv->index].begin.column, msg)), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean _tmp0_;
	char* _tmp1_;
	GError* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_query_accept (self, type, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_inner_error_ = (_tmp2_ = tracker_sparql_query_get_error (self, _tmp1_ = g_strdup_printf ("expected %s", tracker_sparql_token_type_to_string (type))), _g_free0 (_tmp1_), _tmp2_);
	{
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
}


void tracker_sparql_query_get_location (TrackerSparqlQuery* self, TrackerSourceLocation* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->tokens[self->priv->index].begin;
	return;
}


void tracker_sparql_query_set_location (TrackerSparqlQuery* self, TrackerSourceLocation* location) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	tracker_sparql_scanner_seek (self->priv->scanner, location);
	self->priv->size = 0;
	self->priv->index = 0;
	{
		tracker_sparql_query_next (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				goto __catch2_tracker_sparql_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally2;
	__catch2_tracker_sparql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("tracker-sparql-query.vala:350: internal error: next in set_location fa" \
"iled");
			_g_error_free0 (e);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


char* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self, gint strip) {
	char* result = NULL;
	gint last_index;
	g_return_val_if_fail (self != NULL, NULL);
	last_index = ((self->priv->index + TRACKER_SPARQL_QUERY_BUFFER_SIZE) - 1) % TRACKER_SPARQL_QUERY_BUFFER_SIZE;
	result = g_strndup ((const char*) (self->priv->tokens[last_index].begin.pos + strip), (self->priv->tokens[last_index].end.pos - self->priv->tokens[last_index].begin.pos) - (2 * strip));
	return result;
}


static void tracker_sparql_query_parse_prologue (TrackerSparqlQuery* self, GError** error) {
	GError * _inner_error_;
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BASE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp0_) {
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	while (TRUE) {
		gboolean _tmp1_;
		char* ns;
		gboolean _tmp2_;
		char* uri;
		_tmp1_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PREFIX, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (!_tmp1_) {
			break;
		}
		ns = g_strdup ("");
		_tmp2_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (ns);
				return;
			} else {
				_g_free0 (ns);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp2_) {
			char* _tmp3_;
			ns = (_tmp3_ = tracker_sparql_query_get_last_string (self, 0), _g_free0 (ns), _tmp3_);
		}
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (ns);
				return;
			} else {
				_g_free0 (ns);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (ns);
				return;
			} else {
				_g_free0 (ns);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		uri = tracker_sparql_query_get_last_string (self, 1);
		g_hash_table_insert (self->priv->prefix_map, g_strdup (ns), g_strdup (uri));
		_g_free0 (ns);
		_g_free0 (uri);
	}
}


TrackerDBResultSet* tracker_sparql_query_execute (TrackerSparqlQuery* self, GError** error) {
	TrackerDBResultSet* result = NULL;
	GError * _inner_error_;
	TrackerSparqlScanner* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	g_assert (!self->priv->update_extensions);
	self->priv->scanner = (_tmp0_ = tracker_sparql_scanner_new ((gchar*) self->priv->query_string, (gsize) ((glong) strlen (self->priv->query_string))), _g_object_unref0 (self->priv->scanner), _tmp0_);
	tracker_sparql_query_next (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	g_hash_table_insert (self->priv->prefix_map, g_strdup ("fn"), g_strdup (TRACKER_SPARQL_QUERY_FN_NS));
	{
		gint _tmp1_;
		TrackerNamespace** ns_collection;
		int ns_collection_length1;
		int ns_it;
		ns_collection = tracker_ontologies_get_namespaces (&_tmp1_);
		ns_collection_length1 = _tmp1_;
		for (ns_it = 0; ns_it < _tmp1_; ns_it = ns_it + 1) {
			TrackerNamespace* ns;
			ns = _g_object_ref0 (ns_collection[ns_it]);
			{
				g_hash_table_insert (self->priv->prefix_map, g_strdup (tracker_namespace_get_prefix (ns)), g_strdup (tracker_namespace_get_uri (ns)));
				_g_object_unref0 (ns);
			}
		}
	}
	tracker_sparql_query_parse_prologue (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	switch (tracker_sparql_query_current (self)) {
		case TRACKER_SPARQL_TOKEN_TYPE_SELECT:
		{
			TrackerDBResultSet* _tmp2_;
			_tmp2_ = tracker_sparql_query_execute_select (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			result = _tmp2_;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT:
		{
			_inner_error_ = tracker_sparql_query_get_internal_error (self, "CONSTRUCT is not supported");
			{
				if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
		case TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE:
		{
			_inner_error_ = tracker_sparql_query_get_internal_error (self, "DESCRIBE is not supported");
			{
				if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
		case TRACKER_SPARQL_TOKEN_TYPE_ASK:
		{
			TrackerDBResultSet* _tmp3_;
			_tmp3_ = tracker_sparql_query_execute_ask (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			result = _tmp3_;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_INSERT:
		case TRACKER_SPARQL_TOKEN_TYPE_DELETE:
		case TRACKER_SPARQL_TOKEN_TYPE_DROP:
		{
			_inner_error_ = tracker_sparql_query_get_error (self, "INSERT and DELETE are not supported in query mode");
			{
				if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
		default:
		{
			_inner_error_ = tracker_sparql_query_get_error (self, "expected SELECT or ASK");
			{
				if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	}
}


GPtrArray* tracker_sparql_query_execute_update (TrackerSparqlQuery* self, gboolean blank, GError** error) {
	GPtrArray* result = NULL;
	GError * _inner_error_;
	TrackerSparqlScanner* _tmp0_;
	GPtrArray* blank_nodes;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	g_assert (self->priv->update_extensions);
	self->priv->scanner = (_tmp0_ = tracker_sparql_scanner_new ((gchar*) self->priv->query_string, (gsize) ((glong) strlen (self->priv->query_string))), _g_object_unref0 (self->priv->scanner), _tmp0_);
	tracker_sparql_query_next (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((((_inner_error_->domain == TRACKER_DATA_ERROR) || (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	g_hash_table_insert (self->priv->prefix_map, g_strdup ("fn"), g_strdup (TRACKER_SPARQL_QUERY_FN_NS));
	{
		gint _tmp1_;
		TrackerNamespace** ns_collection;
		int ns_collection_length1;
		int ns_it;
		ns_collection = tracker_ontologies_get_namespaces (&_tmp1_);
		ns_collection_length1 = _tmp1_;
		for (ns_it = 0; ns_it < _tmp1_; ns_it = ns_it + 1) {
			TrackerNamespace* ns;
			ns = _g_object_ref0 (ns_collection[ns_it]);
			{
				g_hash_table_insert (self->priv->prefix_map, g_strdup (tracker_namespace_get_prefix (ns)), g_strdup (tracker_namespace_get_uri (ns)));
				_g_object_unref0 (ns);
			}
		}
	}
	tracker_sparql_query_parse_prologue (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((((_inner_error_->domain == TRACKER_DATA_ERROR) || (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	blank_nodes = NULL;
	if (blank) {
		GPtrArray* _tmp2_;
		blank_nodes = (_tmp2_ = g_ptr_array_new (), _g_ptr_array_free0 (blank_nodes), _tmp2_);
	}
	while (TRUE) {
		if (!(tracker_sparql_query_current (self) != TRACKER_SPARQL_TOKEN_TYPE_EOF)) {
			break;
		}
		switch (tracker_sparql_query_current (self)) {
			case TRACKER_SPARQL_TOKEN_TYPE_WITH:
			case TRACKER_SPARQL_TOKEN_TYPE_INSERT:
			case TRACKER_SPARQL_TOKEN_TYPE_DELETE:
			{
				GPtrArray* ptr;
				ptr = tracker_sparql_query_execute_insert_or_delete (self, blank, &_inner_error_);
				if (_inner_error_ != NULL) {
					if ((((_inner_error_->domain == TRACKER_DATA_ERROR) || (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_ptr_array_free0 (blank_nodes);
						return NULL;
					} else {
						_g_ptr_array_free0 (blank_nodes);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				if (ptr != NULL) {
					g_ptr_array_add (blank_nodes, ptr);
				}
				break;
			}
			case TRACKER_SPARQL_TOKEN_TYPE_DROP:
			{
				tracker_sparql_query_execute_drop_graph (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if ((((_inner_error_->domain == TRACKER_DATA_ERROR) || (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_ptr_array_free0 (blank_nodes);
						return NULL;
					} else {
						_g_ptr_array_free0 (blank_nodes);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				break;
			}
			case TRACKER_SPARQL_TOKEN_TYPE_SELECT:
			case TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT:
			case TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE:
			case TRACKER_SPARQL_TOKEN_TYPE_ASK:
			{
				_inner_error_ = tracker_sparql_query_get_error (self, "SELECT, CONSTRUCT, DESCRIBE, and ASK are not supported in update mode");
				{
					if ((((_inner_error_->domain == TRACKER_DATA_ERROR) || (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_ptr_array_free0 (blank_nodes);
						return NULL;
					} else {
						_g_ptr_array_free0 (blank_nodes);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			}
			default:
			{
				_inner_error_ = tracker_sparql_query_get_error (self, "expected INSERT or DELETE");
				{
					if ((((_inner_error_->domain == TRACKER_DATA_ERROR) || (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_ptr_array_free0 (blank_nodes);
						return NULL;
					} else {
						_g_ptr_array_free0 (blank_nodes);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			}
		}
	}
	result = blank_nodes;
	return result;
}


static TrackerDBResultSet* tracker_sparql_query_exec_sql (TrackerSparqlQuery* self, const char* sql, GError** error) {
	TrackerDBResultSet* result = NULL;
	GError * _inner_error_;
	TrackerDBInterface* iface;
	TrackerDBStatement* stmt;
	gint i;
	TrackerDBResultSet* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	_inner_error_ = NULL;
	iface = _g_object_ref0 (tracker_db_manager_get_db_interface ());
	stmt = tracker_db_interface_create_statement (iface, "%s", sql);
	i = 0;
	{
		GList* binding_collection;
		GList* binding_it;
		binding_collection = self->bindings;
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
			TrackerSparqlLiteralBinding* binding;
			binding = _g_object_ref0 ((TrackerSparqlLiteralBinding*) binding_it->data);
			{
				if (((TrackerSparqlDataBinding*) binding)->data_type == TRACKER_PROPERTY_TYPE_BOOLEAN) {
					gboolean _tmp0_ = FALSE;
					if (_vala_strcmp0 (binding->literal, "true") == 0) {
						_tmp0_ = TRUE;
					} else {
						_tmp0_ = _vala_strcmp0 (binding->literal, "1") == 0;
					}
					if (_tmp0_) {
						tracker_db_statement_bind_int (stmt, i, 1);
					} else {
						gboolean _tmp1_ = FALSE;
						if (_vala_strcmp0 (binding->literal, "false") == 0) {
							_tmp1_ = TRUE;
						} else {
							_tmp1_ = _vala_strcmp0 (binding->literal, "0") == 0;
						}
						if (_tmp1_) {
							tracker_db_statement_bind_int (stmt, i, 0);
						} else {
							char* _tmp2_;
							GError* _tmp3_;
							_inner_error_ = (_tmp3_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_TYPE, _tmp2_ = g_strdup_printf ("`%s' is not a valid boolean", binding->literal)), _g_free0 (_tmp2_), _tmp3_);
							{
								if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (binding);
									_g_object_unref0 (iface);
									_g_object_unref0 (stmt);
									return NULL;
								} else {
									_g_object_unref0 (binding);
									_g_object_unref0 (iface);
									_g_object_unref0 (stmt);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
							}
						}
					}
				} else {
					if (((TrackerSparqlDataBinding*) binding)->data_type == TRACKER_PROPERTY_TYPE_DATETIME) {
						gint _tmp4_;
						_tmp4_ = tracker_string_to_date (binding->literal, NULL, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (binding);
								_g_object_unref0 (iface);
								_g_object_unref0 (stmt);
								return NULL;
							} else {
								_g_object_unref0 (binding);
								_g_object_unref0 (iface);
								_g_object_unref0 (stmt);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						tracker_db_statement_bind_int (stmt, i, _tmp4_);
					} else {
						if (((TrackerSparqlDataBinding*) binding)->data_type == TRACKER_PROPERTY_TYPE_INTEGER) {
							tracker_db_statement_bind_int (stmt, i, atoi (binding->literal));
						} else {
							tracker_db_statement_bind_text (stmt, i, binding->literal);
						}
					}
				}
				i++;
				_g_object_unref0 (binding);
			}
		}
	}
	_tmp5_ = tracker_db_statement_execute (stmt, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iface);
			_g_object_unref0 (stmt);
			return NULL;
		} else {
			_g_object_unref0 (iface);
			_g_object_unref0 (stmt);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp5_;
	_g_object_unref0 (iface);
	_g_object_unref0 (stmt);
	return result;
}


static TrackerDBResultSet* tracker_sparql_query_execute_select (TrackerSparqlQuery* self, GError** error) {
	TrackerDBResultSet* result = NULL;
	GError * _inner_error_;
	GString* sql;
	TrackerSparqlSelectContext* _tmp0_;
	TrackerDBResultSet* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	sql = g_string_new ("");
	_tmp0_ = tracker_sparql_pattern_translate_select (self->pattern, sql, FALSE, FALSE, &_inner_error_);
	_tracker_sparql_context_unref0 (_tmp0_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (sql);
			return NULL;
		} else {
			_g_string_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_EOF, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (sql);
			return NULL;
		} else {
			_g_string_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = tracker_sparql_query_exec_sql (self, sql->str, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (sql);
			return NULL;
		} else {
			_g_string_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp1_;
	_g_string_free0 (sql);
	return result;
}


static TrackerDBResultSet* tracker_sparql_query_execute_ask (TrackerSparqlQuery* self, GError** error) {
	TrackerDBResultSet* result = NULL;
	GError * _inner_error_;
	GString* pattern_sql;
	GString* sql;
	TrackerSparqlContext* _tmp0_;
	TrackerSparqlContext* _tmp1_;
	TrackerSparqlContext* _tmp2_;
	TrackerDBResultSet* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	pattern_sql = g_string_new ("");
	sql = g_string_new ("");
	g_string_append (sql, "SELECT ");
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_ASK, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			return NULL;
		} else {
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	g_string_append (sql, "COUNT(1) > 0");
	tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_WHERE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			return NULL;
		} else {
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = tracker_sparql_pattern_translate_group_graph_pattern (self->pattern, pattern_sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			return NULL;
		} else {
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	self->context = (_tmp1_ = _tmp0_, _tracker_sparql_context_unref0 (self->context), _tmp1_);
	g_string_append (sql, " FROM (");
	g_string_append (sql, pattern_sql->str);
	g_string_append (sql, ")");
	self->context = (_tmp2_ = _tracker_sparql_context_ref0 (self->context->parent_context), _tracker_sparql_context_unref0 (self->context), _tmp2_);
	_tmp3_ = tracker_sparql_query_exec_sql (self, sql->str, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			return NULL;
		} else {
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp3_;
	_g_string_free0 (pattern_sql);
	_g_string_free0 (sql);
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static void tracker_sparql_query_parse_from_or_into_param (TrackerSparqlQuery* self, GError** error) {
	GError * _inner_error_;
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp0_) {
		char* _tmp1_;
		self->priv->current_graph = (_tmp1_ = tracker_sparql_query_get_last_string (self, 1), _g_free0 (self->priv->current_graph), _tmp1_);
	} else {
		gboolean _tmp2_;
		_tmp2_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp2_) {
			char* ns;
			char* _tmp4_;
			char* _tmp3_;
			char* _tmp5_;
			char* _tmp6_;
			char* _tmp7_;
			ns = tracker_sparql_query_get_last_string (self, 0);
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ns);
					return;
				} else {
					_g_free0 (ns);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp6_ = (_tmp5_ = tracker_sparql_query_resolve_prefixed_name (self, ns, _tmp4_ = string_substring (_tmp3_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp4_), _g_free0 (_tmp3_), _tmp5_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ns);
					return;
				} else {
					_g_free0 (ns);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			self->priv->current_graph = (_tmp7_ = _tmp6_, _g_free0 (self->priv->current_graph), _tmp7_);
			_g_free0 (ns);
		} else {
			char* _tmp9_;
			char* _tmp8_;
			char* _tmp10_;
			char* _tmp11_;
			char* _tmp12_;
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp11_ = (_tmp10_ = tracker_sparql_query_resolve_prefixed_name (self, "", _tmp9_ = string_substring (_tmp8_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp9_), _g_free0 (_tmp8_), _tmp10_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			self->priv->current_graph = (_tmp12_ = _tmp11_, _g_free0 (self->priv->current_graph), _tmp12_);
		}
	}
}


static GPtrArray* tracker_sparql_query_execute_insert_or_delete (TrackerSparqlQuery* self, gboolean blank, GError** error) {
	GPtrArray* result = NULL;
	GError * _inner_error_;
	gboolean _tmp0_;
	gboolean delete_statements = FALSE;
	gboolean _tmp2_;
	GString* pattern_sql;
	GString* sql;
	TrackerSourceLocation _tmp7_ = {0};
	TrackerSourceLocation template_location;
	gboolean _tmp8_;
	TrackerSourceLocation _tmp14_ = {0};
	TrackerSourceLocation after_where;
	gboolean first;
	TrackerDBResultSet* result_set;
	GPtrArray* update_blank_nodes;
	GList* _tmp23_;
	TrackerSparqlContext* _tmp24_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_WITH, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_tmp0_) {
		tracker_sparql_query_parse_from_or_into_param (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if ((((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	} else {
		char* _tmp1_;
		self->priv->current_graph = (_tmp1_ = NULL, _g_free0 (self->priv->current_graph), _tmp1_);
	}
	_tmp2_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_INSERT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		delete_statements = FALSE;
		if (self->priv->current_graph == NULL) {
			gboolean _tmp4_;
			_tmp4_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_INTO, &_inner_error_);
			if (_inner_error_ != NULL) {
				if ((((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp3_ = _tmp4_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			tracker_sparql_query_parse_from_or_into_param (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if ((((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	} else {
		gboolean _tmp5_ = FALSE;
		tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DELETE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if ((((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		delete_statements = TRUE;
		blank = FALSE;
		if (self->priv->current_graph == NULL) {
			gboolean _tmp6_;
			_tmp6_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_FROM, &_inner_error_);
			if (_inner_error_ != NULL) {
				if ((((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp5_ = _tmp6_;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			tracker_sparql_query_parse_from_or_into_param (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if ((((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	}
	pattern_sql = g_string_new ("");
	sql = g_string_new ("");
	template_location = (tracker_sparql_query_get_location (self, &_tmp7_), _tmp7_);
	tracker_sparql_query_skip_braces (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			return NULL;
		} else {
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_WHERE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			return NULL;
		} else {
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (_tmp8_) {
		char* old_graph;
		char* _tmp9_;
		TrackerSparqlContext* _tmp10_;
		TrackerSparqlContext* _tmp11_;
		char* _tmp12_;
		old_graph = g_strdup (self->priv->current_graph);
		self->priv->current_graph = (_tmp9_ = NULL, _g_free0 (self->priv->current_graph), _tmp9_);
		_tmp10_ = tracker_sparql_pattern_translate_group_graph_pattern (self->pattern, pattern_sql, &_inner_error_);
		if (_inner_error_ != NULL) {
			if ((((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (old_graph);
				_g_string_free0 (pattern_sql);
				_g_string_free0 (sql);
				return NULL;
			} else {
				_g_free0 (old_graph);
				_g_string_free0 (pattern_sql);
				_g_string_free0 (sql);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		self->context = (_tmp11_ = _tmp10_, _tracker_sparql_context_unref0 (self->context), _tmp11_);
		self->priv->current_graph = (_tmp12_ = g_strdup (old_graph), _g_free0 (self->priv->current_graph), _tmp12_);
		_g_free0 (old_graph);
	} else {
		TrackerSparqlContext* _tmp13_;
		self->context = (_tmp13_ = tracker_sparql_context_new (NULL), _tracker_sparql_context_unref0 (self->context), _tmp13_);
	}
	after_where = (tracker_sparql_query_get_location (self, &_tmp14_), _tmp14_);
	g_string_append (sql, "SELECT ");
	first = TRUE;
	{
		GList* variable_collection;
		GList* variable_it;
		variable_collection = g_hash_table_get_keys (self->context->var_set);
		for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
			TrackerSparqlVariable* variable;
			variable = (TrackerSparqlVariable*) variable_it->data;
			{
				if (!first) {
					g_string_append (sql, ", ");
				} else {
					first = FALSE;
				}
				if (variable->binding == NULL) {
					char* _tmp15_;
					GError* _tmp16_;
					_inner_error_ = (_tmp16_ = tracker_sparql_query_get_error (self, _tmp15_ = g_strdup_printf ("use of undefined variable `%s'", tracker_sparql_variable_get_name (variable))), _g_free0 (_tmp15_), _tmp16_);
					{
						if ((((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
							g_propagate_error (error, _inner_error_);
							_g_list_free0 (variable_collection);
							_g_string_free0 (pattern_sql);
							_g_string_free0 (sql);
							return NULL;
						} else {
							_g_list_free0 (variable_collection);
							_g_string_free0 (pattern_sql);
							_g_string_free0 (sql);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
				}
				tracker_sparql_expression_append_expression_as_string (sql, tracker_sparql_variable_get_sql_expression (variable), ((TrackerSparqlDataBinding*) variable->binding)->data_type);
			}
		}
		_g_list_free0 (variable_collection);
	}
	if (first) {
		g_string_append (sql, "1");
	} else {
		g_string_append (sql, " FROM (");
		g_string_append (sql, pattern_sql->str);
		g_string_append (sql, ")");
	}
	result_set = tracker_sparql_query_exec_sql (self, sql->str, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			return NULL;
		} else {
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	self->priv->delete_statements = delete_statements;
	update_blank_nodes = NULL;
	if (blank) {
		GPtrArray* _tmp17_;
		update_blank_nodes = (_tmp17_ = g_ptr_array_new (), _g_ptr_array_free0 (update_blank_nodes), _tmp17_);
	}
	if (result_set != NULL) {
		{
			gboolean _tmp18_;
			_tmp18_ = TRUE;
			while (TRUE) {
				GHashTable* _tmp19_;
				GHashTable* var_value_map;
				gint var_idx;
				if (!_tmp18_) {
					if (!tracker_db_result_set_iter_next (result_set)) {
						break;
					}
				}
				_tmp18_ = FALSE;
				uuid_generate (self->priv->base_uuid);
				self->priv->blank_nodes = (_tmp19_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free), _g_hash_table_unref0 (self->priv->blank_nodes), _tmp19_);
				var_value_map = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
				var_idx = 0;
				{
					GList* variable_collection;
					GList* variable_it;
					variable_collection = g_hash_table_get_keys (self->context->var_set);
					for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
						TrackerSparqlVariable* variable;
						variable = (TrackerSparqlVariable*) variable_it->data;
						{
							GValue value = {0};
							GValue _tmp21_;
							GValue _tmp20_ = {0};
							_tracker_db_result_set_get_value (result_set, (guint) (var_idx++), &_tmp20_);
							value = (_tmp21_ = _tmp20_, G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp21_);
							g_hash_table_insert (var_value_map, g_strdup (tracker_sparql_variable_get_name (variable)), tracker_sparql_query_get_string_for_value (&value));
							G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
						}
					}
					_g_list_free0 (variable_collection);
				}
				tracker_sparql_query_set_location (self, &template_location);
				tracker_sparql_query_parse_construct_triples_block (self, var_value_map, &_inner_error_);
				if (_inner_error_ != NULL) {
					if ((((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_hash_table_unref0 (var_value_map);
						_g_string_free0 (pattern_sql);
						_g_string_free0 (sql);
						_g_object_unref0 (result_set);
						_g_ptr_array_free0 (update_blank_nodes);
						return NULL;
					} else {
						_g_hash_table_unref0 (var_value_map);
						_g_string_free0 (pattern_sql);
						_g_string_free0 (sql);
						_g_object_unref0 (result_set);
						_g_ptr_array_free0 (update_blank_nodes);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				if (blank) {
					GHashTable* _tmp22_;
					GHashTable* ptr;
					ptr = (_tmp22_ = self->priv->blank_nodes, self->priv->blank_nodes = NULL, _tmp22_);
					g_ptr_array_add (update_blank_nodes, ptr);
				}
				tracker_data_update_buffer_might_flush (&_inner_error_);
				if (_inner_error_ != NULL) {
					if ((((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_hash_table_unref0 (var_value_map);
						_g_string_free0 (pattern_sql);
						_g_string_free0 (sql);
						_g_object_unref0 (result_set);
						_g_ptr_array_free0 (update_blank_nodes);
						return NULL;
					} else {
						_g_hash_table_unref0 (var_value_map);
						_g_string_free0 (pattern_sql);
						_g_string_free0 (sql);
						_g_object_unref0 (result_set);
						_g_ptr_array_free0 (update_blank_nodes);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_g_hash_table_unref0 (var_value_map);
			}
		}
	}
	tracker_sparql_query_set_location (self, &after_where);
	tracker_data_update_buffer_flush (&_inner_error_);
	if (_inner_error_ != NULL) {
		if ((((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			_g_object_unref0 (result_set);
			_g_ptr_array_free0 (update_blank_nodes);
			return NULL;
		} else {
			_g_string_free0 (pattern_sql);
			_g_string_free0 (sql);
			_g_object_unref0 (result_set);
			_g_ptr_array_free0 (update_blank_nodes);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	self->bindings = (_tmp23_ = NULL, __g_list_free_g_object_unref0 (self->bindings), _tmp23_);
	self->context = (_tmp24_ = _tracker_sparql_context_ref0 (self->context->parent_context), _tracker_sparql_context_unref0 (self->context), _tmp24_);
	result = update_blank_nodes;
	_g_string_free0 (pattern_sql);
	_g_string_free0 (sql);
	_g_object_unref0 (result_set);
	return result;
}


static void tracker_sparql_query_execute_drop_graph (TrackerSparqlQuery* self, GError** error) {
	GError * _inner_error_;
	gboolean is_var = FALSE;
	char* url;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DROP, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_GRAPH, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	url = tracker_sparql_pattern_parse_var_or_term (self->pattern, NULL, &is_var, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_data_delete_resource_description (url, url, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (url);
			return;
		} else {
			_g_free0 (url);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_data_update_buffer_flush (&_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_SPARQL_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (url);
			return;
		} else {
			_g_free0 (url);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_free0 (url);
}


char* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self, const char* prefix, const char* local_name, GError** error) {
	char* result = NULL;
	GError * _inner_error_;
	char* ns;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	g_return_val_if_fail (local_name != NULL, NULL);
	_inner_error_ = NULL;
	ns = g_strdup ((const char*) g_hash_table_lookup (self->priv->prefix_map, prefix));
	if (ns == NULL) {
		char* _tmp0_;
		GError* _tmp1_;
		_inner_error_ = (_tmp1_ = tracker_sparql_query_get_error (self, _tmp0_ = g_strdup_printf ("use of undefined prefix `%s'", prefix)), _g_free0 (_tmp0_), _tmp1_);
		{
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (ns);
				return NULL;
			} else {
				_g_free0 (ns);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	result = g_strconcat (ns, local_name, NULL);
	_g_free0 (ns);
	return result;
}


static void tracker_sparql_query_skip_braces (TrackerSparqlQuery* self, GError** error) {
	GError * _inner_error_;
	gint n_braces;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	n_braces = 1;
	while (TRUE) {
		gboolean _tmp0_;
		if (!(n_braces > 0)) {
			break;
		}
		_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp0_) {
			n_braces++;
		} else {
			gboolean _tmp1_;
			_tmp1_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			if (_tmp1_) {
				n_braces--;
			} else {
				if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_EOF) {
					_inner_error_ = tracker_sparql_query_get_error (self, "unexpected end of query, expected }");
					{
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				} else {
					tracker_sparql_query_next (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
			}
		}
	}
}


static void tracker_sparql_query_parse_construct_triples_block (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (var_value_map != NULL);
	_inner_error_ = NULL;
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	while (TRUE) {
		gboolean _tmp0_;
		if (!(tracker_sparql_query_current (self) != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE)) {
			break;
		}
		_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_GRAPH, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp0_) {
			char* old_graph;
			char* _tmp1_;
			char* _tmp2_;
			char* _tmp6_;
			old_graph = g_strdup (self->priv->current_graph);
			_tmp1_ = tracker_sparql_query_parse_construct_var_or_term (self, var_value_map, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (old_graph);
					return;
				} else {
					_g_free0 (old_graph);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			self->priv->current_graph = (_tmp2_ = _tmp1_, _g_free0 (self->priv->current_graph), _tmp2_);
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (old_graph);
					return;
				} else {
					_g_free0 (old_graph);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			while (TRUE) {
				char* _tmp3_;
				char* _tmp4_;
				gboolean _tmp5_;
				if (!(tracker_sparql_query_current (self) != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE)) {
					break;
				}
				_tmp3_ = tracker_sparql_query_parse_construct_var_or_term (self, var_value_map, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (old_graph);
						return;
					} else {
						_g_free0 (old_graph);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				self->priv->current_subject = (_tmp4_ = _tmp3_, _g_free0 (self->priv->current_subject), _tmp4_);
				tracker_sparql_query_parse_construct_property_list_not_empty (self, var_value_map, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (old_graph);
						return;
					} else {
						_g_free0 (old_graph);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp5_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (old_graph);
						return;
					} else {
						_g_free0 (old_graph);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				if (!_tmp5_) {
					break;
				}
			}
			tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (old_graph);
					return;
				} else {
					_g_free0 (old_graph);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			self->priv->current_graph = (_tmp6_ = g_strdup (old_graph), _g_free0 (self->priv->current_graph), _tmp6_);
			_g_free0 (old_graph);
		} else {
			char* _tmp7_;
			char* _tmp8_;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_;
			_tmp7_ = tracker_sparql_query_parse_construct_var_or_term (self, var_value_map, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			self->priv->current_subject = (_tmp8_ = _tmp7_, _g_free0 (self->priv->current_subject), _tmp8_);
			tracker_sparql_query_parse_construct_property_list_not_empty (self, var_value_map, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp10_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			if (!_tmp10_) {
				_tmp9_ = tracker_sparql_query_current (self) != TRACKER_SPARQL_TOKEN_TYPE_GRAPH;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				break;
			}
		}
	}
	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static char* tracker_sparql_query_parse_construct_var_or_term (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error) {
	char* result = NULL;
	GError * _inner_error_;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (var_value_map != NULL, NULL);
	_inner_error_ = NULL;
	_result_ = g_strdup ("");
	if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
		char* _tmp2_;
		char* _tmp1_;
		char* _tmp0_;
		tracker_sparql_query_next (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (_result_);
				return NULL;
			} else {
				_g_free0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_result_ = (_tmp2_ = g_strdup ((const char*) g_hash_table_lookup (var_value_map, _tmp1_ = string_substring (_tmp0_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1))), _g_free0 (_result_), _tmp2_);
		_g_free0 (_tmp1_);
		_g_free0 (_tmp0_);
		if (_result_ == NULL) {
			char* _tmp5_;
			char* _tmp4_;
			char* _tmp3_;
			GError* _tmp6_;
			_inner_error_ = (_tmp6_ = tracker_sparql_query_get_error (self, _tmp5_ = g_strdup_printf ("use of undefined variable `%s'", _tmp4_ = string_substring (_tmp3_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1))), _g_free0 (_tmp5_), _g_free0 (_tmp4_), _g_free0 (_tmp3_), _tmp6_);
			{
				if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (_result_);
					return NULL;
				} else {
					_g_free0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	} else {
		if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
			char* _tmp7_;
			tracker_sparql_query_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (_result_);
					return NULL;
				} else {
					_g_free0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_result_ = (_tmp7_ = tracker_sparql_query_get_last_string (self, 1), _g_free0 (_result_), _tmp7_);
		} else {
			if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
				char* ns;
				char* _tmp9_;
				char* _tmp8_;
				char* _tmp10_;
				char* _tmp11_;
				char* _tmp12_;
				tracker_sparql_query_next (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				ns = tracker_sparql_query_get_last_string (self, 0);
				tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (ns);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (ns);
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp11_ = (_tmp10_ = tracker_sparql_query_resolve_prefixed_name (self, ns, _tmp9_ = string_substring (_tmp8_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp9_), _g_free0 (_tmp8_), _tmp10_);
				if (_inner_error_ != NULL) {
					if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (ns);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (ns);
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_result_ = (_tmp12_ = _tmp11_, _g_free0 (_result_), _tmp12_);
				_g_free0 (ns);
			} else {
				if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
					char* _tmp14_;
					char* _tmp13_;
					char* _tmp15_;
					char* _tmp16_;
					char* _tmp17_;
					tracker_sparql_query_next (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						} else {
							_g_free0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp16_ = (_tmp15_ = tracker_sparql_query_resolve_prefixed_name (self, "", _tmp14_ = string_substring (_tmp13_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp14_), _g_free0 (_tmp13_), _tmp15_);
					if (_inner_error_ != NULL) {
						if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						} else {
							_g_free0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_result_ = (_tmp17_ = _tmp16_, _g_free0 (_result_), _tmp17_);
				} else {
					gboolean _tmp18_;
					_tmp18_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (_result_);
							return NULL;
						} else {
							_g_free0 (_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					if (_tmp18_) {
						char* _tmp21_;
						char* _tmp20_;
						char* _tmp19_;
						tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (_result_);
								return NULL;
							} else {
								_g_free0 (_result_);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						_result_ = (_tmp21_ = tracker_sparql_query_generate_bnodeid (self, _tmp20_ = string_substring (_tmp19_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1)), _g_free0 (_result_), _tmp21_);
						_g_free0 (_tmp20_);
						_g_free0 (_tmp19_);
					} else {
						if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_MINUS) {
							gboolean _tmp22_ = FALSE;
							gboolean _tmp23_ = FALSE;
							tracker_sparql_query_next (self, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (_result_);
									return NULL;
								} else {
									_g_free0 (_result_);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
							}
							if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
								_tmp23_ = TRUE;
							} else {
								_tmp23_ = tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_DECIMAL;
							}
							if (_tmp23_) {
								_tmp22_ = TRUE;
							} else {
								_tmp22_ = tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_DOUBLE;
							}
							if (_tmp22_) {
								char* _tmp25_;
								char* _tmp24_;
								tracker_sparql_query_next (self, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
										g_propagate_error (error, _inner_error_);
										_g_free0 (_result_);
										return NULL;
									} else {
										_g_free0 (_result_);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return NULL;
									}
								}
								_result_ = (_tmp25_ = g_strconcat ("-", _tmp24_ = tracker_sparql_query_get_last_string (self, 0), NULL), _g_free0 (_result_), _tmp25_);
								_g_free0 (_tmp24_);
							} else {
								_inner_error_ = tracker_sparql_query_get_error (self, "expected variable or term");
								{
									if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
										g_propagate_error (error, _inner_error_);
										_g_free0 (_result_);
										return NULL;
									} else {
										_g_free0 (_result_);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return NULL;
									}
								}
							}
						} else {
							if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
								char* _tmp26_;
								tracker_sparql_query_next (self, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
										g_propagate_error (error, _inner_error_);
										_g_free0 (_result_);
										return NULL;
									} else {
										_g_free0 (_result_);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return NULL;
									}
								}
								_result_ = (_tmp26_ = tracker_sparql_query_get_last_string (self, 0), _g_free0 (_result_), _tmp26_);
							} else {
								if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_DECIMAL) {
									char* _tmp27_;
									tracker_sparql_query_next (self, &_inner_error_);
									if (_inner_error_ != NULL) {
										if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
											g_propagate_error (error, _inner_error_);
											_g_free0 (_result_);
											return NULL;
										} else {
											_g_free0 (_result_);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return NULL;
										}
									}
									_result_ = (_tmp27_ = tracker_sparql_query_get_last_string (self, 0), _g_free0 (_result_), _tmp27_);
								} else {
									if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_DOUBLE) {
										char* _tmp28_;
										tracker_sparql_query_next (self, &_inner_error_);
										if (_inner_error_ != NULL) {
											if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
												g_propagate_error (error, _inner_error_);
												_g_free0 (_result_);
												return NULL;
											} else {
												_g_free0 (_result_);
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return NULL;
											}
										}
										_result_ = (_tmp28_ = tracker_sparql_query_get_last_string (self, 0), _g_free0 (_result_), _tmp28_);
									} else {
										if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_TRUE) {
											char* _tmp29_;
											tracker_sparql_query_next (self, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
													g_propagate_error (error, _inner_error_);
													_g_free0 (_result_);
													return NULL;
												} else {
													_g_free0 (_result_);
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return NULL;
												}
											}
											_result_ = (_tmp29_ = g_strdup ("true"), _g_free0 (_result_), _tmp29_);
										} else {
											if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_FALSE) {
												char* _tmp30_;
												tracker_sparql_query_next (self, &_inner_error_);
												if (_inner_error_ != NULL) {
													if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
														g_propagate_error (error, _inner_error_);
														_g_free0 (_result_);
														return NULL;
													} else {
														_g_free0 (_result_);
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return NULL;
													}
												}
												_result_ = (_tmp30_ = g_strdup ("false"), _g_free0 (_result_), _tmp30_);
											} else {
												if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1) {
													char* _tmp31_;
													char* _tmp32_;
													_tmp31_ = tracker_sparql_expression_parse_string_literal (self->expression, NULL, &_inner_error_);
													if (_inner_error_ != NULL) {
														if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
															g_propagate_error (error, _inner_error_);
															_g_free0 (_result_);
															return NULL;
														} else {
															_g_free0 (_result_);
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return NULL;
														}
													}
													_result_ = (_tmp32_ = _tmp31_, _g_free0 (_result_), _tmp32_);
												} else {
													if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2) {
														char* _tmp33_;
														char* _tmp34_;
														_tmp33_ = tracker_sparql_expression_parse_string_literal (self->expression, NULL, &_inner_error_);
														if (_inner_error_ != NULL) {
															if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
																g_propagate_error (error, _inner_error_);
																_g_free0 (_result_);
																return NULL;
															} else {
																_g_free0 (_result_);
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																g_clear_error (&_inner_error_);
																return NULL;
															}
														}
														_result_ = (_tmp34_ = _tmp33_, _g_free0 (_result_), _tmp34_);
													} else {
														if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1) {
															char* _tmp35_;
															char* _tmp36_;
															_tmp35_ = tracker_sparql_expression_parse_string_literal (self->expression, NULL, &_inner_error_);
															if (_inner_error_ != NULL) {
																if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
																	g_propagate_error (error, _inner_error_);
																	_g_free0 (_result_);
																	return NULL;
																} else {
																	_g_free0 (_result_);
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																	g_clear_error (&_inner_error_);
																	return NULL;
																}
															}
															_result_ = (_tmp36_ = _tmp35_, _g_free0 (_result_), _tmp36_);
														} else {
															if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2) {
																char* _tmp37_;
																char* _tmp38_;
																_tmp37_ = tracker_sparql_expression_parse_string_literal (self->expression, NULL, &_inner_error_);
																if (_inner_error_ != NULL) {
																	if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
																		g_propagate_error (error, _inner_error_);
																		_g_free0 (_result_);
																		return NULL;
																	} else {
																		_g_free0 (_result_);
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																		g_clear_error (&_inner_error_);
																		return NULL;
																	}
																}
																_result_ = (_tmp38_ = _tmp37_, _g_free0 (_result_), _tmp38_);
															} else {
																if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET) {
																	char* _tmp39_;
																	char* old_subject;
																	gboolean old_subject_is_var;
																	char* _tmp40_;
																	char* _tmp41_;
																	if (self->priv->anon_blank_node_open) {
																		_inner_error_ = tracker_sparql_query_get_error (self, "no support for nested anonymous blank nodes");
																		{
																			if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
																				g_propagate_error (error, _inner_error_);
																				_g_free0 (_result_);
																				return NULL;
																			} else {
																				_g_free0 (_result_);
																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																				g_clear_error (&_inner_error_);
																				return NULL;
																			}
																		}
																	}
																	self->priv->anon_blank_node_open = TRUE;
																	tracker_sparql_query_next (self, &_inner_error_);
																	if (_inner_error_ != NULL) {
																		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
																			g_propagate_error (error, _inner_error_);
																			_g_free0 (_result_);
																			return NULL;
																		} else {
																			_g_free0 (_result_);
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																			g_clear_error (&_inner_error_);
																			return NULL;
																		}
																	}
																	_result_ = (_tmp39_ = tracker_sparql_query_generate_bnodeid (self, NULL), _g_free0 (_result_), _tmp39_);
																	old_subject = g_strdup (self->priv->current_subject);
																	old_subject_is_var = self->priv->current_subject_is_var;
																	self->priv->current_subject = (_tmp40_ = g_strdup (_result_), _g_free0 (self->priv->current_subject), _tmp40_);
																	tracker_sparql_query_parse_construct_property_list_not_empty (self, var_value_map, &_inner_error_);
																	if (_inner_error_ != NULL) {
																		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
																			g_propagate_error (error, _inner_error_);
																			_g_free0 (old_subject);
																			_g_free0 (_result_);
																			return NULL;
																		} else {
																			_g_free0 (old_subject);
																			_g_free0 (_result_);
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																			g_clear_error (&_inner_error_);
																			return NULL;
																		}
																	}
																	tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
																	if (_inner_error_ != NULL) {
																		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
																			g_propagate_error (error, _inner_error_);
																			_g_free0 (old_subject);
																			_g_free0 (_result_);
																			return NULL;
																		} else {
																			_g_free0 (old_subject);
																			_g_free0 (_result_);
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																			g_clear_error (&_inner_error_);
																			return NULL;
																		}
																	}
																	self->priv->anon_blank_node_open = FALSE;
																	self->priv->current_subject = (_tmp41_ = g_strdup (old_subject), _g_free0 (self->priv->current_subject), _tmp41_);
																	self->priv->current_subject_is_var = old_subject_is_var;
																	_g_free0 (old_subject);
																} else {
																	_inner_error_ = tracker_sparql_query_get_error (self, "expected variable or term");
																	{
																		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
																			g_propagate_error (error, _inner_error_);
																			_g_free0 (_result_);
																			return NULL;
																		} else {
																			_g_free0 (_result_);
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																			g_clear_error (&_inner_error_);
																			return NULL;
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = _result_;
	return result;
}


static void tracker_sparql_query_parse_construct_property_list_not_empty (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (var_value_map != NULL);
	_inner_error_ = NULL;
	while (TRUE) {
		char* old_predicate;
		char* _tmp0_;
		char* _tmp16_;
		gboolean _tmp17_;
		old_predicate = g_strdup (self->priv->current_predicate);
		self->priv->current_predicate = (_tmp0_ = NULL, _g_free0 (self->priv->current_predicate), _tmp0_);
		if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
			char* _tmp3_;
			char* _tmp2_;
			char* _tmp1_;
			self->priv->current_predicate_is_var = TRUE;
			tracker_sparql_query_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (old_predicate);
					return;
				} else {
					_g_free0 (old_predicate);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			self->priv->current_predicate = (_tmp3_ = g_strdup ((const char*) g_hash_table_lookup (var_value_map, _tmp2_ = string_substring (_tmp1_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1))), _g_free0 (self->priv->current_predicate), _tmp3_);
			_g_free0 (_tmp2_);
			_g_free0 (_tmp1_);
		} else {
			if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
				char* _tmp4_;
				tracker_sparql_query_next (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (old_predicate);
						return;
					} else {
						_g_free0 (old_predicate);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				self->priv->current_predicate = (_tmp4_ = tracker_sparql_query_get_last_string (self, 1), _g_free0 (self->priv->current_predicate), _tmp4_);
			} else {
				if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
					char* ns;
					char* _tmp6_;
					char* _tmp5_;
					char* _tmp7_;
					char* _tmp8_;
					char* _tmp9_;
					tracker_sparql_query_next (self, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (old_predicate);
							return;
						} else {
							_g_free0 (old_predicate);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					ns = tracker_sparql_query_get_last_string (self, 0);
					tracker_sparql_query_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (ns);
							_g_free0 (old_predicate);
							return;
						} else {
							_g_free0 (ns);
							_g_free0 (old_predicate);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp8_ = (_tmp7_ = tracker_sparql_query_resolve_prefixed_name (self, ns, _tmp6_ = string_substring (_tmp5_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp6_), _g_free0 (_tmp5_), _tmp7_);
					if (_inner_error_ != NULL) {
						if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (ns);
							_g_free0 (old_predicate);
							return;
						} else {
							_g_free0 (ns);
							_g_free0 (old_predicate);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					self->priv->current_predicate = (_tmp9_ = _tmp8_, _g_free0 (self->priv->current_predicate), _tmp9_);
					_g_free0 (ns);
				} else {
					if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
						char* _tmp11_;
						char* _tmp10_;
						char* _tmp12_;
						char* _tmp13_;
						char* _tmp14_;
						tracker_sparql_query_next (self, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (old_predicate);
								return;
							} else {
								_g_free0 (old_predicate);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						_tmp13_ = (_tmp12_ = tracker_sparql_query_resolve_prefixed_name (self, "", _tmp11_ = string_substring (_tmp10_ = tracker_sparql_query_get_last_string (self, 0), (glong) 1, -1), &_inner_error_), _g_free0 (_tmp11_), _g_free0 (_tmp10_), _tmp12_);
						if (_inner_error_ != NULL) {
							if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (old_predicate);
								return;
							} else {
								_g_free0 (old_predicate);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						self->priv->current_predicate = (_tmp14_ = _tmp13_, _g_free0 (self->priv->current_predicate), _tmp14_);
					} else {
						if (tracker_sparql_query_current (self) == TRACKER_SPARQL_TOKEN_TYPE_A) {
							char* _tmp15_;
							tracker_sparql_query_next (self, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (old_predicate);
									return;
								} else {
									_g_free0 (old_predicate);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							self->priv->current_predicate = (_tmp15_ = g_strdup ("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), _g_free0 (self->priv->current_predicate), _tmp15_);
						} else {
							_inner_error_ = tracker_sparql_query_get_error (self, "expected non-empty property list");
							{
								if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (old_predicate);
									return;
								} else {
									_g_free0 (old_predicate);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
						}
					}
				}
			}
		}
		tracker_sparql_query_parse_construct_object_list (self, var_value_map, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (old_predicate);
				return;
			} else {
				_g_free0 (old_predicate);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		self->priv->current_predicate = (_tmp16_ = g_strdup (old_predicate), _g_free0 (self->priv->current_predicate), _tmp16_);
		_tmp17_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (old_predicate);
				return;
			} else {
				_g_free0 (old_predicate);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp17_) {
			_g_free0 (old_predicate);
			continue;
		}
		_g_free0 (old_predicate);
		break;
	}
}


static void tracker_sparql_query_parse_construct_object_list (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (var_value_map != NULL);
	_inner_error_ = NULL;
	while (TRUE) {
		gboolean _tmp0_;
		tracker_sparql_query_parse_construct_object (self, var_value_map, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp0_ = tracker_sparql_query_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp0_) {
			continue;
		}
		break;
	}
}


static void tracker_sparql_query_parse_construct_object (TrackerSparqlQuery* self, GHashTable* var_value_map, GError** error) {
	GError * _inner_error_;
	char* object;
	g_return_if_fail (self != NULL);
	g_return_if_fail (var_value_map != NULL);
	_inner_error_ = NULL;
	object = tracker_sparql_query_parse_construct_var_or_term (self, var_value_map, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (self->priv->delete_statements) {
		tracker_data_delete_statement (self->priv->current_graph, self->priv->current_subject, self->priv->current_predicate, object, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (object);
				return;
			} else {
				_g_free0 (object);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
		tracker_data_insert_statement (self->priv->current_graph, self->priv->current_subject, self->priv->current_predicate, object, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == TRACKER_DATA_ERROR)) || (_inner_error_->domain == TRACKER_DATE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (object);
				return;
			} else {
				_g_free0 (object);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_g_free0 (object);
}


static char* double_to_string (double self) {
	char* result = NULL;
	gint _tmp0__length1;
	gchar* _tmp0_;
	char* _tmp1_;
	result = (_tmp1_ = g_strdup (g_ascii_dtostr ((_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE), _tmp0__length1 = G_ASCII_DTOSTR_BUF_SIZE, _tmp0_), G_ASCII_DTOSTR_BUF_SIZE, self)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	return result;
}


static char* tracker_sparql_query_get_string_for_value (GValue* value) {
	char* result = NULL;
	if (G_VALUE_TYPE (value) == G_TYPE_INT) {
		result = g_strdup_printf ("%i", g_value_get_int (value));
		return result;
	} else {
		if (G_VALUE_TYPE (value) == G_TYPE_DOUBLE) {
			result = double_to_string (g_value_get_double (value));
			return result;
		} else {
			if (G_VALUE_TYPE (value) == G_TYPE_STRING) {
				result = g_strdup (g_value_get_string (value));
				return result;
			} else {
				result = NULL;
				return result;
			}
		}
	}
}


static TrackerSparqlQueryTokenInfo* tracker_sparql_query_token_info_dup (const TrackerSparqlQueryTokenInfo* self) {
	TrackerSparqlQueryTokenInfo* dup;
	dup = g_new0 (TrackerSparqlQueryTokenInfo, 1);
	memcpy (dup, self, sizeof (TrackerSparqlQueryTokenInfo));
	return dup;
}


static void tracker_sparql_query_token_info_free (TrackerSparqlQueryTokenInfo* self) {
	g_free (self);
}


static GType tracker_sparql_query_token_info_get_type (void) {
	static volatile gsize tracker_sparql_query_token_info_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_query_token_info_type_id__volatile)) {
		GType tracker_sparql_query_token_info_type_id;
		tracker_sparql_query_token_info_type_id = g_boxed_type_register_static ("TrackerSparqlQueryTokenInfo", (GBoxedCopyFunc) tracker_sparql_query_token_info_dup, (GBoxedFreeFunc) tracker_sparql_query_token_info_free);
		g_once_init_leave (&tracker_sparql_query_token_info_type_id__volatile, tracker_sparql_query_token_info_type_id);
	}
	return tracker_sparql_query_token_info_type_id__volatile;
}


static void tracker_sparql_query_class_init (TrackerSparqlQueryClass * klass) {
	tracker_sparql_query_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerSparqlQueryPrivate));
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_query_finalize;
}


static void tracker_sparql_query_instance_init (TrackerSparqlQuery * self) {
	self->priv = TRACKER_SPARQL_QUERY_GET_PRIVATE (self);
	self->priv->bnodeid = 0;
	self->priv->anon_blank_node_open = FALSE;
}


static void tracker_sparql_query_finalize (GObject* obj) {
	TrackerSparqlQuery * self;
	self = TRACKER_SPARQL_QUERY (obj);
	_g_object_unref0 (self->priv->scanner);
	self->priv->tokens = (g_free (self->priv->tokens), NULL);
	_g_free0 (self->priv->query_string);
	_g_object_unref0 (self->expression);
	_g_object_unref0 (self->pattern);
	_g_free0 (self->priv->current_graph);
	_g_free0 (self->priv->current_subject);
	_g_free0 (self->priv->current_predicate);
	_g_hash_table_unref0 (self->priv->prefix_map);
	__g_list_free_g_object_unref0 (self->bindings);
	_tracker_sparql_context_unref0 (self->context);
	self->priv->base_uuid = (g_free (self->priv->base_uuid), NULL);
	_g_hash_table_unref0 (self->priv->blank_nodes);
	G_OBJECT_CLASS (tracker_sparql_query_parent_class)->finalize (obj);
}


GType tracker_sparql_query_get_type (void) {
	static volatile gsize tracker_sparql_query_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_query_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlQuery), 0, (GInstanceInitFunc) tracker_sparql_query_instance_init, NULL };
		GType tracker_sparql_query_type_id;
		tracker_sparql_query_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlQuery", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_query_type_id__volatile, tracker_sparql_query_type_id);
	}
	return tracker_sparql_query_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




