/* tracker-connection.c generated by valac 0.9.5.4-19a5, the Vala compiler
 * generated from tracker-connection.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */
/**
 * TRACKER_SPARQL_ERROR:
 *
 * Error domain for Tracker Sparql. Errors in this domain will be from the
 * #TrackerSparqlError enumeration. See #GError for more information on error
 * domains.
 */
/**
 * tracker_sparql_connection_query_async:
 * @self: a #TrackerSparqlConnection
 * @sparql: string containing the SPARQL query
 * @_callback_: user-defined #GAsyncReadyCallback to be called when
 *              asynchronous operation is finished.
 * @_user_data_: user-defined data to be passed to @_callback_
 * @cancellable: a #GCancellable used to cancel the operation
 *
 * Executes asynchronously a SPARQL query on the store.
 */
/**
 * tracker_sparql_connection_update_async:
 * @self: a #TrackerSparqlConnection
 * @sparql: string containing the SPARQL update query
 * @priority: the priority for the asynchronous operation
 * @_callback_: user-defined #GAsyncReadyCallback to be called when
 *              asynchronous operation is finished.
 * @_user_data_: user-defined data to be passed to @_callback_
 * @cancellable: a #GCancellable used to cancel the operation
 *
 * Executes asynchronously a SPARQL update on the store.
 */
/**
 * tracker_sparql_connection_update_blank_async:
 * @self: a #TrackerSparqlConnection
 * @sparql: string containing the SPARQL update query
 * @priority: the priority for the asynchronous operation
 * @_callback_: user-defined #GAsyncReadyCallback to be called when
 *              asynchronous operation is finished.
 * @_user_data_: user-defined data to be passed to @_callback_
 * @cancellable: a #GCancellable used to cancel the operation
 *
 * Executes asynchronously a SPARQL update on the store.
 */
/**
 * tracker_sparql_connection_load_async:
 * @self: a #TrackerSparqlConnection
 * @file: a #GFile
 * @_callback_: user-defined #GAsyncReadyCallback to be called when
 *              asynchronous operation is finished.
 * @_user_data_: user-defined data to be passed to @_callback_
 * @cancellable: a #GCancellable used to cancel the operation
 *
 * Loads, asynchronously, a Turtle file (TTL) into the store.
 */
/**
 * tracker_sparql_connection_statistics_async:
 * @self: a #TrackerSparqlConnection
 * @_callback_: user-defined #GAsyncReadyCallback to be called when
 *              asynchronous operation is finished.
 * @_user_data_: user-defined data to be passed to @_callback_
 * @cancellable: a #GCancellable used to cancel the operation
 *
 * Retrieves, asynchronously, the statistics from the Store.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define TRACKER_SPARQL_TYPE_CONNECTION (tracker_sparql_connection_get_type ())
#define TRACKER_SPARQL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnection))
#define TRACKER_SPARQL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnectionClass))
#define TRACKER_SPARQL_IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONNECTION))
#define TRACKER_SPARQL_IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONNECTION))
#define TRACKER_SPARQL_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnectionClass))

typedef struct _TrackerSparqlConnection TrackerSparqlConnection;
typedef struct _TrackerSparqlConnectionClass TrackerSparqlConnectionClass;
typedef struct _TrackerSparqlConnectionPrivate TrackerSparqlConnectionPrivate;

#define TRACKER_SPARQL_TYPE_CURSOR (tracker_sparql_cursor_get_type ())
#define TRACKER_SPARQL_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursor))
#define TRACKER_SPARQL_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursorClass))
#define TRACKER_SPARQL_IS_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CURSOR))
#define TRACKER_SPARQL_IS_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CURSOR))
#define TRACKER_SPARQL_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CURSOR, TrackerSparqlCursorClass))

typedef struct _TrackerSparqlCursor TrackerSparqlCursor;
typedef struct _TrackerSparqlCursorClass TrackerSparqlCursorClass;

#define TRACKER_SPARQL_TYPE_PLUGIN_LOADER (tracker_sparql_plugin_loader_get_type ())
#define TRACKER_SPARQL_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PLUGIN_LOADER, TrackerSparqlPluginLoader))
#define TRACKER_SPARQL_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PLUGIN_LOADER, TrackerSparqlPluginLoaderClass))
#define TRACKER_SPARQL_IS_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PLUGIN_LOADER))
#define TRACKER_SPARQL_IS_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PLUGIN_LOADER))
#define TRACKER_SPARQL_PLUGIN_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PLUGIN_LOADER, TrackerSparqlPluginLoaderClass))

typedef struct _TrackerSparqlPluginLoader TrackerSparqlPluginLoader;
typedef struct _TrackerSparqlPluginLoaderClass TrackerSparqlPluginLoaderClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerSparqlConnectionUpdateAsyncData TrackerSparqlConnectionUpdateAsyncData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _TrackerSparqlConnectionUpdateBlankAsyncData TrackerSparqlConnectionUpdateBlankAsyncData;
typedef struct _TrackerSparqlConnectionLoadAsyncData TrackerSparqlConnectionLoadAsyncData;
typedef struct _TrackerSparqlConnectionStatisticsAsyncData TrackerSparqlConnectionStatisticsAsyncData;

typedef enum  {
	TRACKER_SPARQL_ERROR_PARSE,
	TRACKER_SPARQL_ERROR_UNKNOWN_CLASS,
	TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY,
	TRACKER_SPARQL_ERROR_TYPE,
	TRACKER_SPARQL_ERROR_CONSTRAINT,
	TRACKER_SPARQL_ERROR_NO_SPACE,
	TRACKER_SPARQL_ERROR_INTERNAL,
	TRACKER_SPARQL_ERROR_UNSUPPORTED
} TrackerSparqlError;
#define TRACKER_SPARQL_ERROR tracker_sparql_error_quark ()
struct _TrackerSparqlConnection {
	GObject parent_instance;
	TrackerSparqlConnectionPrivate * priv;
};

struct _TrackerSparqlConnectionClass {
	GObjectClass parent_class;
	TrackerSparqlCursor* (*query) (TrackerSparqlConnection* self, const char* sparql, GCancellable* cancellable, GError** error);
	void (*query_async) (TrackerSparqlConnection* self, const char* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	TrackerSparqlCursor* (*query_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	void (*update) (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GError** error);
	void (*update_async) (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*update_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	GVariant* (*update_blank) (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GError** error);
	void (*update_blank_async) (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GVariant* (*update_blank_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	void (*load) (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GError** error);
	void (*load_async) (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*load_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
	TrackerSparqlCursor* (*statistics) (TrackerSparqlConnection* self, GCancellable* cancellable, GError** error);
	void (*statistics_async) (TrackerSparqlConnection* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	TrackerSparqlCursor* (*statistics_finish) (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
};

struct _TrackerSparqlConnectionUpdateAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlConnection* self;
	char* sparql;
	gint priority;
	GCancellable* cancellable;
};

struct _TrackerSparqlConnectionUpdateBlankAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlConnection* self;
	char* sparql;
	gint priority;
	GCancellable* cancellable;
	GVariant* result;
};

struct _TrackerSparqlConnectionLoadAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlConnection* self;
	GFile* file;
	GCancellable* cancellable;
};

struct _TrackerSparqlConnectionStatisticsAsyncData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerSparqlConnection* self;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
};


static gboolean tracker_sparql_connection_direct_only;
static gboolean tracker_sparql_connection_direct_only = FALSE;
static TrackerSparqlConnection* tracker_sparql_connection_singleton;
static TrackerSparqlConnection* tracker_sparql_connection_singleton = NULL;
static gboolean tracker_sparql_connection_log_initialized;
static gboolean tracker_sparql_connection_log_initialized = FALSE;
static gpointer tracker_sparql_connection_parent_class = NULL;

#define TRACKER_DBUS_SERVICE "org.freedesktop.Tracker1"
#define TRACKER_DBUS_INTERFACE_RESOURCES TRACKER_DBUS_SERVICE ".Resources"
#define TRACKER_DBUS_OBJECT_RESOURCES "/org/freedesktop/Tracker1/Resources"
#define TRACKER_DBUS_INTERFACE_STATISTICS TRACKER_DBUS_SERVICE ".Statistics"
#define TRACKER_DBUS_OBJECT_STATISTICS "/org/freedesktop/Tracker1/Statistics"
#define TRACKER_DBUS_INTERFACE_STEROIDS TRACKER_DBUS_SERVICE ".Steroids"
#define TRACKER_DBUS_OBJECT_STEROIDS "/org/freedesktop/Tracker1/Steroids"
GQuark tracker_sparql_error_quark (void);
GType tracker_sparql_connection_get_type (void) G_GNUC_CONST;
GType tracker_sparql_cursor_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_SPARQL_CONNECTION_DUMMY_PROPERTY
};
static void tracker_sparql_connection_log_init (void);
TrackerSparqlPluginLoader* tracker_sparql_plugin_loader_new (gboolean direct_only, GError** error);
TrackerSparqlPluginLoader* tracker_sparql_plugin_loader_construct (GType object_type, gboolean direct_only, GError** error);
GType tracker_sparql_plugin_loader_get_type (void) G_GNUC_CONST;
TrackerSparqlConnection* tracker_sparql_connection_get (GError** error);
TrackerSparqlConnection* tracker_sparql_connection_get_direct (GError** error);
static void tracker_sparql_connection_remove_log_handler (const char* log_domain, GLogLevelFlags log_level, const char* message);
static void _tracker_sparql_connection_remove_log_handler_glog_func (const char* log_domain, GLogLevelFlags log_levels, const char* message, gpointer self);
TrackerSparqlCursor* tracker_sparql_connection_query (TrackerSparqlConnection* self, const char* sparql, GCancellable* cancellable, GError** error);
static TrackerSparqlCursor* tracker_sparql_connection_real_query (TrackerSparqlConnection* self, const char* sparql, GCancellable* cancellable, GError** error);
void tracker_sparql_connection_query_async (TrackerSparqlConnection* self, const char* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlCursor* tracker_sparql_connection_query_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
void tracker_sparql_connection_update (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GError** error);
static void tracker_sparql_connection_real_update (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GError** error);
static void tracker_sparql_connection_real_update_async_data_free (gpointer _data);
static void tracker_sparql_connection_real_update_async (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_sparql_connection_update_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tracker_sparql_connection_update_async (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_sparql_connection_update_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_connection_real_update_async_co (TrackerSparqlConnectionUpdateAsyncData* data);
GVariant* tracker_sparql_connection_update_blank (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GError** error);
static GVariant* tracker_sparql_connection_real_update_blank (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GError** error);
static void tracker_sparql_connection_real_update_blank_async_data_free (gpointer _data);
static void tracker_sparql_connection_real_update_blank_async (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_sparql_connection_update_blank_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tracker_sparql_connection_update_blank_async (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* tracker_sparql_connection_update_blank_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_connection_real_update_blank_async_co (TrackerSparqlConnectionUpdateBlankAsyncData* data);
void tracker_sparql_connection_load (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GError** error);
static void tracker_sparql_connection_real_load (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GError** error);
static void tracker_sparql_connection_real_load_async_data_free (gpointer _data);
static void tracker_sparql_connection_real_load_async (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_sparql_connection_load_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tracker_sparql_connection_load_async (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_sparql_connection_load_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_connection_real_load_async_co (TrackerSparqlConnectionLoadAsyncData* data);
TrackerSparqlCursor* tracker_sparql_connection_statistics (TrackerSparqlConnection* self, GCancellable* cancellable, GError** error);
static TrackerSparqlCursor* tracker_sparql_connection_real_statistics (TrackerSparqlConnection* self, GCancellable* cancellable, GError** error);
static void tracker_sparql_connection_real_statistics_async_data_free (gpointer _data);
static void tracker_sparql_connection_real_statistics_async (TrackerSparqlConnection* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_sparql_connection_statistics_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tracker_sparql_connection_statistics_async (TrackerSparqlConnection* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlCursor* tracker_sparql_connection_statistics_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_sparql_connection_real_statistics_async_co (TrackerSparqlConnectionStatisticsAsyncData* data);
TrackerSparqlConnection* tracker_sparql_connection_construct (GType object_type);
static void tracker_sparql_connection_finalize (GObject* obj);



GQuark tracker_sparql_error_quark (void) {
	return g_quark_from_static_string ("tracker_sparql_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


/**
 * tracker_sparql_connection_get:
 * @error: #GError for error reporting.
 *
 * Returns a new #TrackerSparqlConnection, which will use the best method
 * available to connect to the Tracker Store (direct-access for Read-Only
 * queries, and D-Bus otherwise).
 *
 * Returns: a new #TrackerSparqlConnection. Call g_object_unref() on the
 * object when no longer used.
 */
TrackerSparqlConnection* tracker_sparql_connection_get (GError** error) {
	TrackerSparqlConnection* result = NULL;
	GError * _inner_error_;
	_inner_error_ = NULL;
	if (tracker_sparql_connection_singleton != NULL) {
		g_assert (!tracker_sparql_connection_direct_only);
		result = _g_object_ref0 (tracker_sparql_connection_singleton);
		return result;
	} else {
		TrackerSparqlPluginLoader* _result_;
		tracker_sparql_connection_log_init ();
		_result_ = tracker_sparql_plugin_loader_new (FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		tracker_sparql_connection_singleton = (TrackerSparqlConnection*) _result_;
		g_object_add_weak_pointer ((GObject*) _result_, (void**) (&tracker_sparql_connection_singleton));
		result = (TrackerSparqlConnection*) _result_;
		return result;
	}
}


/**
 * tracker_sparql_connection_get_direct:
 * @error: #GError for error reporting.
 *
 * Returns a new #TrackerSparqlConnection, which uses direct-access method
 * to connect to the Tracker Store. Note that this connection will only be
 * able to perform Read-Only queries in the store.
 *
 * Returns: a new #TrackerSparqlConnection. Call g_object_unref() on the
 * object when no longer used.
 */
TrackerSparqlConnection* tracker_sparql_connection_get_direct (GError** error) {
	TrackerSparqlConnection* result = NULL;
	GError * _inner_error_;
	_inner_error_ = NULL;
	if (tracker_sparql_connection_singleton != NULL) {
		g_assert (tracker_sparql_connection_direct_only);
		result = _g_object_ref0 (tracker_sparql_connection_singleton);
		return result;
	} else {
		TrackerSparqlPluginLoader* _result_;
		tracker_sparql_connection_log_init ();
		_result_ = tracker_sparql_plugin_loader_new (TRUE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		tracker_sparql_connection_direct_only = TRUE;
		tracker_sparql_connection_singleton = (TrackerSparqlConnection*) _result_;
		g_object_add_weak_pointer ((GObject*) _result_, (void**) (&tracker_sparql_connection_singleton));
		result = (TrackerSparqlConnection*) _result_;
		return result;
	}
}


static void _tracker_sparql_connection_remove_log_handler_glog_func (const char* log_domain, GLogLevelFlags log_levels, const char* message, gpointer self) {
	tracker_sparql_connection_remove_log_handler (log_domain, log_levels, message);
}


static void tracker_sparql_connection_log_init (void) {
	gint verbosity;
	char* env_verbosity;
	GLogLevelFlags remove_levels;
	if (tracker_sparql_connection_log_initialized) {
		return;
	}
	tracker_sparql_connection_log_initialized = TRUE;
	verbosity = 0;
	env_verbosity = g_strdup (g_getenv ("TRACKER_VERBOSITY"));
	if (env_verbosity != NULL) {
		verbosity = atoi (env_verbosity);
	}
	remove_levels = 0;
	switch (verbosity) {
		case 3:
		{
			break;
		}
		case 2:
		{
			remove_levels = G_LOG_LEVEL_DEBUG;
			break;
		}
		case 1:
		{
			remove_levels = G_LOG_LEVEL_DEBUG | G_LOG_LEVEL_MESSAGE;
			break;
		}
		default:
		{
			remove_levels = (G_LOG_LEVEL_DEBUG | G_LOG_LEVEL_MESSAGE) | G_LOG_LEVEL_INFO;
			break;
		}
	}
	if (remove_levels != 0) {
		g_log_set_handler ("Tracker", remove_levels, _tracker_sparql_connection_remove_log_handler_glog_func, NULL);
	}
	_g_free0 (env_verbosity);
}


static void tracker_sparql_connection_remove_log_handler (const char* log_domain, GLogLevelFlags log_level, const char* message) {
	g_return_if_fail (message != NULL);
}


/**
 * tracker_sparql_connection_query:
 * @self: a #TrackerSparqlConnection
 * @sparql: string containing the SPARQL query
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * Executes a SPARQL query on the store. The API call is completely
 * synchronous, so it may block.
 *
 * Returns: a #TrackerSparqlCursor if results were found, #NULL otherwise.
 * On error, #NULL is returned and the @error is set accordingly.
 * Call g_object_unref() on the returned cursor when no longer needed.
 */
static TrackerSparqlCursor* tracker_sparql_connection_real_query (TrackerSparqlConnection* self, const char* sparql, GCancellable* cancellable, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `tracker_sparql_connection_query'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


TrackerSparqlCursor* tracker_sparql_connection_query (TrackerSparqlConnection* self, const char* sparql, GCancellable* cancellable, GError** error) {
	return TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->query (self, sparql, cancellable, error);
}


void tracker_sparql_connection_query_async (TrackerSparqlConnection* self, const char* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->query_async (self, sparql, cancellable, _callback_, _user_data_);
}


TrackerSparqlCursor* tracker_sparql_connection_query_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	return TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->query_finish (self, _res_, error);
}


/**
 * tracker_sparql_connection_update:
 * @self: a #TrackerSparqlConnection
 * @sparql: string containing the SPARQL update query
 * @priority: the priority for the operation
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * Executes a SPARQL update on the store. The API call is completely
 * synchronous, so it may block.
 */
static void tracker_sparql_connection_real_update (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sparql != NULL);
	g_warning ("tracker-connection.vala:239: Interface 'update' not implemented");
}


void tracker_sparql_connection_update (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GError** error) {
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->update (self, sparql, priority, cancellable, error);
}


static void tracker_sparql_connection_real_update_async_data_free (gpointer _data) {
	TrackerSparqlConnectionUpdateAsyncData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_object_unref0 (data->cancellable);
	g_object_unref (data->self);
	g_slice_free (TrackerSparqlConnectionUpdateAsyncData, data);
}


static void tracker_sparql_connection_real_update_async (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlConnectionUpdateAsyncData* _data_;
	_data_ = g_slice_new0 (TrackerSparqlConnectionUpdateAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_connection_real_update_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_connection_real_update_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->sparql = g_strdup (sparql);
	_data_->priority = priority;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_connection_real_update_async_co (_data_);
}


static void tracker_sparql_connection_real_update_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	TrackerSparqlConnectionUpdateAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_sparql_connection_update_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlConnectionUpdateAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tracker_sparql_connection_real_update_async_co (data);
}


/**
 * tracker_sparql_connection_update_finish:
 * @self: a #TrackerSparqlConnection
 * @_res_: a #GAsyncResult with the result of the operation
 * @error: #GError for error reporting.
 *
 * Finishes the asynchronous SPARQL update operation.
 */
static gboolean tracker_sparql_connection_real_update_async_co (TrackerSparqlConnectionUpdateAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_warning ("tracker-connection.vala:264: Interface 'update_async' not implemented");
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


void tracker_sparql_connection_update_async (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->update_async (self, sparql, priority, cancellable, _callback_, _user_data_);
}


void tracker_sparql_connection_update_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->update_finish (self, _res_, error);
}


/**
 * tracker_sparql_connection_update_blank:
 * @self: a #TrackerSparqlConnection
 * @sparql: string containing the SPARQL update query
 * @priority: the priority for the operation
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * Executes a SPARQL update on the store, and returns the URNs of the
 * generated nodes, if any. The API call is completely synchronous, so it
 * may block.
 *
 * Returns: a #GVariant with the generated URNs, which should be freed with
 * g_variant_unref() when no longer used.
 */
static GVariant* tracker_sparql_connection_real_update_blank (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GError** error) {
	GVariant* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sparql != NULL, NULL);
	g_warning ("tracker-connection.vala:283: Interface 'update_blank' not implemented");
	result = NULL;
	return result;
}


GVariant* tracker_sparql_connection_update_blank (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GError** error) {
	return TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->update_blank (self, sparql, priority, cancellable, error);
}


static void tracker_sparql_connection_real_update_blank_async_data_free (gpointer _data) {
	TrackerSparqlConnectionUpdateBlankAsyncData* data;
	data = _data;
	_g_free0 (data->sparql);
	_g_object_unref0 (data->cancellable);
	_g_variant_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (TrackerSparqlConnectionUpdateBlankAsyncData, data);
}


static void tracker_sparql_connection_real_update_blank_async (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlConnectionUpdateBlankAsyncData* _data_;
	_data_ = g_slice_new0 (TrackerSparqlConnectionUpdateBlankAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_connection_real_update_blank_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_connection_real_update_blank_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->sparql = g_strdup (sparql);
	_data_->priority = priority;
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_connection_real_update_blank_async_co (_data_);
}


static GVariant* tracker_sparql_connection_real_update_blank_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerSparqlConnectionUpdateBlankAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_connection_update_blank_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlConnectionUpdateBlankAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tracker_sparql_connection_real_update_blank_async_co (data);
}


/**
 * tracker_sparql_connection_update_blank_finish:
 * @self: a #TrackerSparqlConnection
 * @_res_: a #GAsyncResult with the result of the operation
 * @error: #GError for error reporting.
 *
 * Finishes the asynchronous SPARQL update operation, and returns
 * the URNs of the generated nodes, if any.
 *
 * Returns: a #GVariant with the generated URNs, which should be freed with
 * g_variant_unref() when no longer used.
 */
static gboolean tracker_sparql_connection_real_update_blank_async_co (TrackerSparqlConnectionUpdateBlankAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_warning ("tracker-connection.vala:313: Interface 'update_blank_async' not implem" \
"ented");
		data->result = NULL;
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


void tracker_sparql_connection_update_blank_async (TrackerSparqlConnection* self, const char* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->update_blank_async (self, sparql, priority, cancellable, _callback_, _user_data_);
}


GVariant* tracker_sparql_connection_update_blank_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	return TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->update_blank_finish (self, _res_, error);
}


/**
 * tracker_sparql_connection_load:
 * @self: a #TrackerSparqlConnection
 * @file: a #GFile
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * Loads a Turtle file (TTL) into the store. The API call is completely
 * synchronous, so it may block.
 */
static void tracker_sparql_connection_real_load (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GError** error) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_warning ("tracker-connection.vala:328: Interface 'load' not implemented");
}


void tracker_sparql_connection_load (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GError** error) {
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->load (self, file, cancellable, error);
}


static void tracker_sparql_connection_real_load_async_data_free (gpointer _data) {
	TrackerSparqlConnectionLoadAsyncData* data;
	data = _data;
	_g_object_unref0 (data->file);
	_g_object_unref0 (data->cancellable);
	g_object_unref (data->self);
	g_slice_free (TrackerSparqlConnectionLoadAsyncData, data);
}


static void tracker_sparql_connection_real_load_async (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlConnectionLoadAsyncData* _data_;
	_data_ = g_slice_new0 (TrackerSparqlConnectionLoadAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_connection_real_load_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_connection_real_load_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->file = _g_object_ref0 (file);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_connection_real_load_async_co (_data_);
}


static void tracker_sparql_connection_real_load_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	TrackerSparqlConnectionLoadAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_sparql_connection_load_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlConnectionLoadAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tracker_sparql_connection_real_load_async_co (data);
}


/**
 * tracker_sparql_connection_load_finish:
 * @self: a #TrackerSparqlConnection
 * @_res_: a #GAsyncResult with the result of the operation
 * @error: #GError for error reporting.
 *
 * Finishes the asynchronous load of the Turtle file.
 */
static gboolean tracker_sparql_connection_real_load_async_co (TrackerSparqlConnectionLoadAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_warning ("tracker-connection.vala:352: Interface 'load_async' not implemented");
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


void tracker_sparql_connection_load_async (TrackerSparqlConnection* self, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->load_async (self, file, cancellable, _callback_, _user_data_);
}


void tracker_sparql_connection_load_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->load_finish (self, _res_, error);
}


/**
 * tracker_sparql_connection_statistics:
 * @self: a #TrackerSparqlConnection
 * @cancellable: a #GCancellable used to cancel the operation
 * @error: #GError for error reporting.
 *
 * Retrieves the statistics from the Store. The API call is completely
 * synchronous, so it may block.
 *
 * Returns: a #TrackerSparqlCursor to iterate the reply if successful, #NULL
 * on error. Call g_object_unref() on the returned cursor when no longer
 * needed.
 */
static TrackerSparqlCursor* tracker_sparql_connection_real_statistics (TrackerSparqlConnection* self, GCancellable* cancellable, GError** error) {
	TrackerSparqlCursor* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_warning ("tracker-connection.vala:369: Interface 'statistics' not implemented");
	result = NULL;
	return result;
}


TrackerSparqlCursor* tracker_sparql_connection_statistics (TrackerSparqlConnection* self, GCancellable* cancellable, GError** error) {
	return TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->statistics (self, cancellable, error);
}


static void tracker_sparql_connection_real_statistics_async_data_free (gpointer _data) {
	TrackerSparqlConnectionStatisticsAsyncData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (TrackerSparqlConnectionStatisticsAsyncData, data);
}


static void tracker_sparql_connection_real_statistics_async (TrackerSparqlConnection* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerSparqlConnectionStatisticsAsyncData* _data_;
	_data_ = g_slice_new0 (TrackerSparqlConnectionStatisticsAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_sparql_connection_real_statistics_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_sparql_connection_real_statistics_async_data_free);
	_data_->self = g_object_ref (self);
	_data_->cancellable = _g_object_ref0 (cancellable);
	tracker_sparql_connection_real_statistics_async_co (_data_);
}


static TrackerSparqlCursor* tracker_sparql_connection_real_statistics_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerSparqlConnectionStatisticsAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_sparql_connection_statistics_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerSparqlConnectionStatisticsAsyncData* data;
	data = _user_data_;
	data->_res_ = _res_;
	tracker_sparql_connection_real_statistics_async_co (data);
}


/**
 * tracker_sparql_connection_statistics_finish:
 * @self: a #TrackerSparqlConnection
 * @_res_: a #GAsyncResult with the result of the operation
 * @error: #GError for error reporting.
 *
 * Finishes the asynchronous retrieval of statistics from the Store.
 *
 * Returns: a #TrackerSparqlCursor to iterate the reply if successful, #NULL
 * on error. Call g_object_unref() on the returned cursor when no longer
 * needed.
 */
static gboolean tracker_sparql_connection_real_statistics_async_co (TrackerSparqlConnectionStatisticsAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_warning ("tracker-connection.vala:397: Interface 'statistics_async' not implemen" \
"ted");
		data->result = NULL;
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


void tracker_sparql_connection_statistics_async (TrackerSparqlConnection* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->statistics_async (self, cancellable, _callback_, _user_data_);
}


TrackerSparqlCursor* tracker_sparql_connection_statistics_finish (TrackerSparqlConnection* self, GAsyncResult* _res_, GError** error) {
	return TRACKER_SPARQL_CONNECTION_GET_CLASS (self)->statistics_finish (self, _res_, error);
}


TrackerSparqlConnection* tracker_sparql_connection_construct (GType object_type) {
	TrackerSparqlConnection * self;
	self = (TrackerSparqlConnection*) g_object_new (object_type, NULL);
	return self;
}


static void tracker_sparql_connection_class_init (TrackerSparqlConnectionClass * klass) {
	tracker_sparql_connection_parent_class = g_type_class_peek_parent (klass);
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query = tracker_sparql_connection_real_query;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update = tracker_sparql_connection_real_update;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_async = tracker_sparql_connection_real_update_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_finish = tracker_sparql_connection_real_update_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank = tracker_sparql_connection_real_update_blank;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank_async = tracker_sparql_connection_real_update_blank_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->update_blank_finish = tracker_sparql_connection_real_update_blank_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load = tracker_sparql_connection_real_load;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load_async = tracker_sparql_connection_real_load_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->load_finish = tracker_sparql_connection_real_load_finish;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics = tracker_sparql_connection_real_statistics;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics_async = tracker_sparql_connection_real_statistics_async;
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->statistics_finish = tracker_sparql_connection_real_statistics_finish;
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_connection_finalize;
}


static void tracker_sparql_connection_instance_init (TrackerSparqlConnection * self) {
}


static void tracker_sparql_connection_finalize (GObject* obj) {
	TrackerSparqlConnection * self;
	self = TRACKER_SPARQL_CONNECTION (obj);
	G_OBJECT_CLASS (tracker_sparql_connection_parent_class)->finalize (obj);
}


/**
 * TrackerSparqlConnection:
 *
 * The <structname>TrackerSparqlConnection</structname> object represents a
 * connection with the Tracker Store.
 */
GType tracker_sparql_connection_get_type (void) {
	static volatile gsize tracker_sparql_connection_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_connection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlConnection), 0, (GInstanceInitFunc) tracker_sparql_connection_instance_init, NULL };
		GType tracker_sparql_connection_type_id;
		tracker_sparql_connection_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlConnection", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&tracker_sparql_connection_type_id__volatile, tracker_sparql_connection_type_id);
	}
	return tracker_sparql_connection_type_id__volatile;
}




