/* tracker-sparql-expression.c generated by valac 0.11.2, the Vala compiler
 * generated from tracker-sparql-expression.vala, do not modify */

/*
 * Copyright (C) 2008-2010, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <libtracker-data/tracker-property.h>
#include <libtracker-data/tracker-db-interface-sqlite.h>
#include <libtracker-data/tracker-class.h>
#include <libtracker-data/tracker-ontologies.h>


#define TRACKER_SPARQL_TYPE_EXPRESSION (tracker_sparql_expression_get_type ())
#define TRACKER_SPARQL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression))
#define TRACKER_SPARQL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))
#define TRACKER_SPARQL_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))

typedef struct _TrackerSparqlExpression TrackerSparqlExpression;
typedef struct _TrackerSparqlExpressionClass TrackerSparqlExpressionClass;
typedef struct _TrackerSparqlExpressionPrivate TrackerSparqlExpressionPrivate;

#define TRACKER_SPARQL_TYPE_QUERY (tracker_sparql_query_get_type ())
#define TRACKER_SPARQL_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery))
#define TRACKER_SPARQL_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))
#define TRACKER_SPARQL_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))

typedef struct _TrackerSparqlQuery TrackerSparqlQuery;
typedef struct _TrackerSparqlQueryClass TrackerSparqlQueryClass;

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TRACKER_SPARQL_TYPE_VARIABLE (tracker_sparql_variable_get_type ())
#define TRACKER_SPARQL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable))
#define TRACKER_SPARQL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))
#define TRACKER_SPARQL_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))

typedef struct _TrackerSparqlVariable TrackerSparqlVariable;
typedef struct _TrackerSparqlVariableClass TrackerSparqlVariableClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TRACKER_SPARQL_TYPE_CONTEXT (tracker_sparql_context_get_type ())
#define TRACKER_SPARQL_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContext))
#define TRACKER_SPARQL_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))
#define TRACKER_SPARQL_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))

typedef struct _TrackerSparqlContext TrackerSparqlContext;
typedef struct _TrackerSparqlContextClass TrackerSparqlContextClass;
typedef struct _TrackerSparqlVariablePrivate TrackerSparqlVariablePrivate;

#define TRACKER_SPARQL_TYPE_DATA_BINDING (tracker_sparql_data_binding_get_type ())
#define TRACKER_SPARQL_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding))
#define TRACKER_SPARQL_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))
#define TRACKER_SPARQL_IS_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_IS_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_DATA_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))

typedef struct _TrackerSparqlDataBinding TrackerSparqlDataBinding;
typedef struct _TrackerSparqlDataBindingClass TrackerSparqlDataBindingClass;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING (tracker_sparql_variable_binding_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBinding))
#define TRACKER_SPARQL_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_VARIABLE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))

typedef struct _TrackerSparqlVariableBinding TrackerSparqlVariableBinding;
typedef struct _TrackerSparqlVariableBindingClass TrackerSparqlVariableBindingClass;
typedef struct _TrackerSparqlDataBindingPrivate TrackerSparqlDataBindingPrivate;

#define TRACKER_SPARQL_TYPE_DATA_TABLE (tracker_sparql_data_table_get_type ())
#define TRACKER_SPARQL_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTable))
#define TRACKER_SPARQL_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))
#define TRACKER_SPARQL_IS_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_IS_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_DATA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))

typedef struct _TrackerSparqlDataTable TrackerSparqlDataTable;
typedef struct _TrackerSparqlDataTableClass TrackerSparqlDataTableClass;
typedef struct _TrackerSparqlVariableBindingPrivate TrackerSparqlVariableBindingPrivate;

#define TRACKER_SPARQL_TYPE_PATTERN (tracker_sparql_pattern_get_type ())
#define TRACKER_SPARQL_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern))
#define TRACKER_SPARQL_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))
#define TRACKER_SPARQL_IS_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_IS_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))

typedef struct _TrackerSparqlPattern TrackerSparqlPattern;
typedef struct _TrackerSparqlPatternClass TrackerSparqlPatternClass;

#define TRACKER_SPARQL_TYPE_VARIABLE_STATE (tracker_sparql_variable_state_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _TrackerSparqlContextPrivate TrackerSparqlContextPrivate;

#define TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE (tracker_sparql_predicate_variable_get_type ())
#define TRACKER_SPARQL_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariable))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))

typedef struct _TrackerSparqlPredicateVariable TrackerSparqlPredicateVariable;
typedef struct _TrackerSparqlPredicateVariableClass TrackerSparqlPredicateVariableClass;

#define TRACKER_SPARQL_TYPE_SELECT_CONTEXT (tracker_sparql_select_context_get_type ())
#define TRACKER_SPARQL_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext))
#define TRACKER_SPARQL_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_SELECT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))

typedef struct _TrackerSparqlSelectContext TrackerSparqlSelectContext;
typedef struct _TrackerSparqlSelectContextClass TrackerSparqlSelectContextClass;
typedef struct _TrackerSparqlSelectContextPrivate TrackerSparqlSelectContextPrivate;

#define TRACKER_SPARQL_TYPE_LITERAL_BINDING (tracker_sparql_literal_binding_get_type ())
#define TRACKER_SPARQL_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBinding))
#define TRACKER_SPARQL_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))
#define TRACKER_SPARQL_IS_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_IS_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_LITERAL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))

typedef struct _TrackerSparqlLiteralBinding TrackerSparqlLiteralBinding;
typedef struct _TrackerSparqlLiteralBindingClass TrackerSparqlLiteralBindingClass;
typedef struct _TrackerSparqlLiteralBindingPrivate TrackerSparqlLiteralBindingPrivate;
typedef struct _TrackerSparqlQueryPrivate TrackerSparqlQueryPrivate;
#define _tracker_sparql_context_unref0(var) ((var == NULL) ? NULL : (var = (tracker_sparql_context_unref (var), NULL)))

struct _TrackerSparqlExpression {
	GObject parent_instance;
	TrackerSparqlExpressionPrivate * priv;
};

struct _TrackerSparqlExpressionClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlExpressionPrivate {
	TrackerSparqlQuery* query;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH
} TrackerSparqlTokenType;

struct _TrackerSparqlVariable {
	GObject parent_instance;
	TrackerSparqlVariablePrivate * priv;
	TrackerSparqlVariableBinding* binding;
};

struct _TrackerSparqlVariableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlDataBinding {
	GObject parent_instance;
	TrackerSparqlDataBindingPrivate * priv;
	TrackerPropertyType data_type;
	TrackerSparqlDataTable* table;
	gchar* sql_db_column_name;
};

struct _TrackerSparqlDataBindingClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariableBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlVariableBindingPrivate * priv;
	TrackerSparqlVariable* variable;
	gboolean maybe_null;
	gboolean in_simple_optional;
	TrackerClass* type;
};

struct _TrackerSparqlVariableBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

typedef enum  {
	TRACKER_SPARQL_VARIABLE_STATE_NONE,
	TRACKER_SPARQL_VARIABLE_STATE_BOUND,
	TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL
} TrackerSparqlVariableState;

struct _TrackerSparqlContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerSparqlContextPrivate * priv;
	TrackerSparqlQuery* query;
	TrackerSparqlContext* parent_context;
	GHashTable* var_set;
	GHashTable* var_map;
	GHashTable* select_var_set;
	GHashTable* predicate_variable_map;
	gboolean scalar_subquery;
};

struct _TrackerSparqlContextClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerSparqlContext *self);
};

struct _TrackerSparqlSelectContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlSelectContextPrivate * priv;
	TrackerPropertyType type;
	TrackerPropertyType* types;
	gint types_length1;
	gint _types_size_;
	gchar** variable_names;
	gint variable_names_length1;
	gint _variable_names_size_;
};

struct _TrackerSparqlSelectContextClass {
	TrackerSparqlContextClass parent_class;
};

struct _TrackerSparqlLiteralBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlLiteralBindingPrivate * priv;
	gboolean is_fts_match;
	gchar* literal;
};

struct _TrackerSparqlLiteralBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

struct _TrackerSparqlQuery {
	GObject parent_instance;
	TrackerSparqlQueryPrivate * priv;
	TrackerSparqlExpression* expression;
	TrackerSparqlPattern* pattern;
	GList* bindings;
	TrackerSparqlContext* context;
	gint last_var_index;
};

struct _TrackerSparqlQueryClass {
	GObjectClass parent_class;
};


static gpointer tracker_sparql_expression_parent_class = NULL;

GType tracker_sparql_expression_get_type (void) G_GNUC_CONST;
GType tracker_sparql_query_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionPrivate))
enum  {
	TRACKER_SPARQL_EXPRESSION_DUMMY_PROPERTY
};
#define TRACKER_SPARQL_EXPRESSION_XSD_NS "http://www.w3.org/2001/XMLSchema#"
#define TRACKER_SPARQL_EXPRESSION_FN_NS "http://www.w3.org/2005/xpath-functions#"
#define TRACKER_SPARQL_EXPRESSION_FTS_NS "http://www.tracker-project.org/ontologies/fts#"
#define TRACKER_SPARQL_EXPRESSION_TRACKER_NS "http://www.tracker-project.org/ontologies/tracker#"
TrackerSparqlExpression* tracker_sparql_expression_new (TrackerSparqlQuery* query);
TrackerSparqlExpression* tracker_sparql_expression_construct (GType object_type, TrackerSparqlQuery* query);
static inline gboolean tracker_sparql_expression_next (TrackerSparqlExpression* self, GError** error);
gboolean tracker_sparql_query_next (TrackerSparqlQuery* self, GError** error);
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
static inline TrackerSparqlTokenType tracker_sparql_expression_current (TrackerSparqlExpression* self);
TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self);
static inline TrackerSparqlTokenType tracker_sparql_expression_last (TrackerSparqlExpression* self);
TrackerSparqlTokenType tracker_sparql_query_last (TrackerSparqlQuery* self);
static inline gboolean tracker_sparql_expression_accept (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error);
gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
static GError* tracker_sparql_expression_get_error (TrackerSparqlExpression* self, const gchar* msg);
GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self, const gchar* msg);
static gboolean tracker_sparql_expression_expect (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error);
gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
static gchar* tracker_sparql_expression_get_last_string (TrackerSparqlExpression* self, gint strip);
gchar* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self, gint strip);
static gchar* tracker_sparql_expression_escape_sql_string_literal (TrackerSparqlExpression* self, const gchar* literal);
static gboolean tracker_sparql_expression_maybe_numeric (TrackerSparqlExpression* self, TrackerPropertyType type);
static void tracker_sparql_expression_append_collate (TrackerSparqlExpression* self, GString* sql);
static void tracker_sparql_expression_skip_bracketted_expression (TrackerSparqlExpression* self, GError** error);
void tracker_sparql_expression_skip_select_variables (TrackerSparqlExpression* self, GError** error);
TrackerPropertyType tracker_sparql_expression_translate_select_expression (TrackerSparqlExpression* self, GString* sql, gboolean subquery, gint variable_index, GError** error);
GType tracker_sparql_variable_get_type (void) G_GNUC_CONST;
TrackerPropertyType tracker_sparql_expression_translate_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
gpointer tracker_sparql_context_ref (gpointer instance);
void tracker_sparql_context_unref (gpointer instance);
GParamSpec* tracker_sparql_param_spec_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_sparql_value_set_context (GValue* value, gpointer v_object);
void tracker_sparql_value_take_context (GValue* value, gpointer v_object);
gpointer tracker_sparql_value_get_context (const GValue* value);
GType tracker_sparql_context_get_type (void) G_GNUC_CONST;
static TrackerSparqlContext* tracker_sparql_expression_get_context (TrackerSparqlExpression* self);
TrackerSparqlVariable* tracker_sparql_context_get_variable (TrackerSparqlContext* self, const gchar* name);
GType tracker_sparql_data_binding_get_type (void) G_GNUC_CONST;
GType tracker_sparql_variable_binding_get_type (void) G_GNUC_CONST;
const gchar* tracker_sparql_variable_get_name (TrackerSparqlVariable* self);
static void tracker_sparql_expression_convert_expression_to_string (GString* sql, TrackerPropertyType type, glong begin);
const gchar* tracker_sparql_variable_get_sql_expression (TrackerSparqlVariable* self);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_new (void);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_construct (GType object_type);
GType tracker_sparql_data_table_get_type (void) G_GNUC_CONST;
void tracker_sparql_data_binding_set_sql_expression (TrackerSparqlDataBinding* self, const gchar* value);
GType tracker_sparql_pattern_get_type (void) G_GNUC_CONST;
static TrackerSparqlPattern* tracker_sparql_expression_get_pattern (TrackerSparqlExpression* self);
GType tracker_sparql_variable_state_get_type (void) G_GNUC_CONST;
void tracker_sparql_pattern_add_variable_binding (TrackerSparqlPattern* self, GString* sql, TrackerSparqlVariableBinding* binding, TrackerSparqlVariableState variable_state);
GType tracker_sparql_predicate_variable_get_type (void) G_GNUC_CONST;
GType tracker_sparql_select_context_get_type (void) G_GNUC_CONST;
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void tracker_sparql_expression_translate_expression_as_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_expression_translate_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_bound_call (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_regex (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_expression_as_string (TrackerSparqlExpression* self, GString* sql, GError** error);
gchar* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error);
static void tracker_sparql_expression_translate_exists (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_pattern_translate_exists (TrackerSparqlPattern* self, GString* sql, GError** error);
void tracker_sparql_expression_append_expression_as_string (GString* sql, const gchar* expression, TrackerPropertyType type);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_new (void);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_construct (GType object_type);
GType tracker_sparql_literal_binding_get_type (void) G_GNUC_CONST;
gchar* tracker_sparql_pattern_parse_var_or_term (TrackerSparqlPattern* self, GString* sql, gboolean* is_var, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_function (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error);
static void tracker_sparql_expression_translate_str (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_isuri (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_translate_datatype (TrackerSparqlExpression* self, GString* sql, GError** error);
gchar* tracker_sparql_variable_get_extra_sql_expression (TrackerSparqlVariable* self, const gchar* suffix);
static TrackerPropertyType tracker_sparql_expression_parse_type_uri (TrackerSparqlExpression* self, GError** error);
gchar* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self, const gchar* prefix, const gchar* local_name, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_uri_expression (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_primary_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_bracketted_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_query_set_has_regex (TrackerSparqlQuery* self, gboolean value);
static TrackerPropertyType tracker_sparql_expression_translate_aggregate_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_unary_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_multiplicative_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_additive_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_numeric_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_process_relational_expression (TrackerSparqlExpression* self, GString* sql, glong begin, guint n_bindings, TrackerPropertyType op1type, const gchar* operator, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_in (TrackerSparqlExpression* self, GString* sql, gboolean not, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_relational_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_value_logical (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_conditional_and_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
static TrackerPropertyType tracker_sparql_expression_translate_conditional_or_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self, GString* sql, gboolean subquery, gboolean scalar_subquery, GError** error);
TrackerPropertyType tracker_sparql_expression_translate_constraint (TrackerSparqlExpression* self, GString* sql, GError** error);
static void tracker_sparql_expression_finalize (GObject* obj);
static void _vala_tracker_sparql_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


TrackerSparqlExpression* tracker_sparql_expression_construct (GType object_type, TrackerSparqlQuery* query) {
	TrackerSparqlExpression * self = NULL;
	g_return_val_if_fail (query != NULL, NULL);
	self = (TrackerSparqlExpression*) g_object_new (object_type, NULL);
	self->priv->query = query;
	return self;
}


TrackerSparqlExpression* tracker_sparql_expression_new (TrackerSparqlQuery* query) {
	return tracker_sparql_expression_construct (TRACKER_SPARQL_TYPE_EXPRESSION, query);
}


static inline gboolean tracker_sparql_expression_next (TrackerSparqlExpression* self, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tracker_sparql_query_next (self->priv->query, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp1_;
	return result;
}


static inline TrackerSparqlTokenType tracker_sparql_expression_current (TrackerSparqlExpression* self) {
	TrackerSparqlTokenType result = 0;
	TrackerSparqlTokenType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = tracker_sparql_query_current (self->priv->query);
	result = _tmp0_;
	return result;
}


static inline TrackerSparqlTokenType tracker_sparql_expression_last (TrackerSparqlExpression* self) {
	TrackerSparqlTokenType result = 0;
	TrackerSparqlTokenType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = tracker_sparql_query_last (self->priv->query);
	result = _tmp0_;
	return result;
}


static inline gboolean tracker_sparql_expression_accept (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tracker_sparql_query_accept (self->priv->query, type, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp1_;
	return result;
}


static GError* tracker_sparql_expression_get_error (TrackerSparqlExpression* self, const gchar* msg) {
	GError* result = NULL;
	GError* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = tracker_sparql_query_get_error (self->priv->query, msg);
	result = _tmp0_;
	return result;
}


static gboolean tracker_sparql_expression_expect (TrackerSparqlExpression* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tracker_sparql_query_expect (self->priv->query, type, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp1_;
	return result;
}


static gchar* tracker_sparql_expression_get_last_string (TrackerSparqlExpression* self, gint strip) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tracker_sparql_query_get_last_string (self->priv->query, strip);
	result = _tmp0_;
	return result;
}


static gchar* tracker_sparql_expression_escape_sql_string_literal (TrackerSparqlExpression* self, const gchar* literal) {
	gchar* result = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (literal != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (literal, "'", 0);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	_tmp3_ = g_strjoinv ("''", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("'%s'", _tmp4_);
	result = (_tmp6_ = _tmp5_, _g_free0 (_tmp4_), _tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL), _tmp6_);
	return result;
}


static gboolean tracker_sparql_expression_maybe_numeric (TrackerSparqlExpression* self, TrackerPropertyType type) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (type == TRACKER_PROPERTY_TYPE_INTEGER) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = type == TRACKER_PROPERTY_TYPE_DOUBLE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = type == TRACKER_PROPERTY_TYPE_DATETIME;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = type == TRACKER_PROPERTY_TYPE_UNKNOWN;
	}
	result = _tmp0_;
	return result;
}


static void tracker_sparql_expression_append_collate (TrackerSparqlExpression* self, GString* sql) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	g_string_append_printf (sql, " COLLATE %s", TRACKER_COLLATION_NAME);
}


static void tracker_sparql_expression_skip_bracketted_expression (TrackerSparqlExpression* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	while (TRUE) {
		TrackerSparqlTokenType _tmp0_;
		_tmp0_ = tracker_sparql_expression_current (self);
		switch (_tmp0_) {
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
			{
				tracker_sparql_expression_skip_bracketted_expression (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				continue;
			}
			case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS:
			case TRACKER_SPARQL_TOKEN_TYPE_EOF:
			{
				break;
			}
			default:
			{
				tracker_sparql_expression_next (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				continue;
			}
		}
		break;
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void tracker_sparql_expression_skip_select_variables (TrackerSparqlExpression* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	while (TRUE) {
		TrackerSparqlTokenType _tmp0_;
		_tmp0_ = tracker_sparql_expression_current (self);
		switch (_tmp0_) {
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
			{
				tracker_sparql_expression_skip_bracketted_expression (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				continue;
			}
			case TRACKER_SPARQL_TOKEN_TYPE_FROM:
			case TRACKER_SPARQL_TOKEN_TYPE_WHERE:
			case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE:
			case TRACKER_SPARQL_TOKEN_TYPE_GROUP:
			case TRACKER_SPARQL_TOKEN_TYPE_ORDER:
			case TRACKER_SPARQL_TOKEN_TYPE_LIMIT:
			case TRACKER_SPARQL_TOKEN_TYPE_OFFSET:
			case TRACKER_SPARQL_TOKEN_TYPE_EOF:
			{
				break;
			}
			default:
			{
				tracker_sparql_expression_next (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				continue;
			}
		}
		break;
	}
}


static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong _tmp0_;
	glong string_length;
	const gchar* _tmp1_ = NULL;
	const gchar* start;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = _tmp0_;
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp1_ = string_offset (self, offset);
	start = _tmp1_;
	_tmp2_ = string_offset (start, len);
	_tmp3_ = g_strndup (start, ((gchar*) _tmp2_) - ((gchar*) start));
	result = _tmp3_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


TrackerPropertyType tracker_sparql_expression_translate_select_expression (TrackerSparqlExpression* self, GString* sql, gboolean subquery, gint variable_index, GError** error) {
	TrackerPropertyType result = 0;
	TrackerSparqlVariable* variable;
	glong begin;
	TrackerPropertyType type;
	TrackerSparqlTokenType _tmp0_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	variable = NULL;
	begin = (glong) sql->len;
	type = TRACKER_PROPERTY_TYPE_UNKNOWN;
	_tmp0_ = tracker_sparql_expression_current (self);
	if (_tmp0_ == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
		TrackerPropertyType _tmp1_;
		TrackerPropertyType _tmp2_;
		TrackerSparqlContext* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		TrackerSparqlVariable* _tmp8_ = NULL;
		TrackerSparqlVariable* _tmp9_;
		TrackerSparqlVariable* _tmp10_;
		_tmp1_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (variable);
				return 0;
			} else {
				_g_object_unref0 (variable);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		type = _tmp2_;
		_tmp3_ = tracker_sparql_expression_get_context (self);
		_tmp4_ = tracker_sparql_expression_get_last_string (self, 0);
		_tmp5_ = _tmp4_;
		_tmp6_ = string_substring (_tmp5_, (glong) 1, (glong) (-1));
		_tmp7_ = _tmp6_;
		_tmp8_ = tracker_sparql_context_get_variable (_tmp3_, _tmp7_);
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (variable);
		variable = _tmp10_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		if (variable->binding == NULL) {
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			GError* _tmp14_ = NULL;
			GError* _tmp15_;
			_tmp11_ = tracker_sparql_variable_get_name (variable);
			_tmp12_ = g_strdup_printf ("use of undefined variable `%s'", _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = tracker_sparql_expression_get_error (self, _tmp13_);
			_inner_error_ = (_tmp15_ = _tmp14_, _g_free0 (_tmp13_), _tmp15_);
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (variable);
				return 0;
			} else {
				_g_object_unref0 (variable);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	} else {
		TrackerPropertyType _tmp16_;
		TrackerPropertyType _tmp17_;
		_tmp16_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
		_tmp17_ = _tmp16_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (variable);
				return 0;
			} else {
				_g_object_unref0 (variable);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		type = _tmp17_;
	}
	if (!subquery) {
		tracker_sparql_expression_convert_expression_to_string (sql, type, begin);
	}
	_tmp18_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_AS, &_inner_error_);
	_tmp19_ = _tmp18_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (variable);
			return 0;
		} else {
			_g_object_unref0 (variable);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (_tmp19_) {
		gboolean _tmp20_;
		gboolean _tmp21_;
		const gchar* _tmp36_ = NULL;
		_tmp20_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
		_tmp21_ = _tmp20_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (variable);
				return 0;
			} else {
				_g_object_unref0 (variable);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (_tmp21_) {
			TrackerSparqlContext* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_;
			TrackerSparqlVariable* _tmp25_ = NULL;
			TrackerSparqlVariable* _tmp26_;
			TrackerSparqlVariable* _tmp27_;
			_tmp22_ = tracker_sparql_expression_get_context (self);
			_tmp23_ = tracker_sparql_expression_get_last_string (self, 0);
			_tmp24_ = _tmp23_;
			_tmp25_ = tracker_sparql_context_get_variable (_tmp22_, _tmp24_);
			_tmp26_ = _g_object_ref0 (_tmp25_);
			_tmp27_ = _tmp26_;
			_g_object_unref0 (variable);
			variable = _tmp27_;
			_g_free0 (_tmp24_);
		} else {
			TrackerSparqlContext* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_;
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_;
			TrackerSparqlVariable* _tmp33_ = NULL;
			TrackerSparqlVariable* _tmp34_;
			TrackerSparqlVariable* _tmp35_;
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (variable);
					return 0;
				} else {
					_g_object_unref0 (variable);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp28_ = tracker_sparql_expression_get_context (self);
			_tmp29_ = tracker_sparql_expression_get_last_string (self, 0);
			_tmp30_ = _tmp29_;
			_tmp31_ = string_substring (_tmp30_, (glong) 1, (glong) (-1));
			_tmp32_ = _tmp31_;
			_tmp33_ = tracker_sparql_context_get_variable (_tmp28_, _tmp32_);
			_tmp34_ = _g_object_ref0 (_tmp33_);
			_tmp35_ = _tmp34_;
			_g_object_unref0 (variable);
			variable = _tmp35_;
			_g_free0 (_tmp32_);
			_g_free0 (_tmp30_);
		}
		_tmp36_ = tracker_sparql_variable_get_sql_expression (variable);
		g_string_append_printf (sql, " AS %s", _tmp36_);
		if (subquery) {
			TrackerSparqlVariableBinding* _tmp37_ = NULL;
			TrackerSparqlVariableBinding* binding;
			const gchar* _tmp38_ = NULL;
			TrackerSparqlPattern* _tmp39_ = NULL;
			GString* _tmp40_ = NULL;
			GString* _tmp41_;
			_tmp37_ = tracker_sparql_variable_binding_new ();
			binding = _tmp37_;
			((TrackerSparqlDataBinding*) binding)->data_type = type;
			binding->variable = variable;
			_tmp38_ = tracker_sparql_variable_get_sql_expression (variable);
			tracker_sparql_data_binding_set_sql_expression ((TrackerSparqlDataBinding*) binding, _tmp38_);
			_tmp39_ = tracker_sparql_expression_get_pattern (self);
			_tmp40_ = g_string_new ("");
			_tmp41_ = _tmp40_;
			tracker_sparql_pattern_add_variable_binding (_tmp39_, _tmp41_, binding, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
			_g_string_free0 (_tmp41_);
			_g_object_unref0 (binding);
		}
	}
	if (variable != NULL) {
		TrackerSparqlContext* _tmp42_ = NULL;
		gconstpointer _tmp43_ = NULL;
		gint state;
		TrackerSparqlContext* _tmp44_ = NULL;
		TrackerSparqlVariable* _tmp45_;
		TrackerSparqlContext* _tmp46_ = NULL;
		TrackerSparqlContext* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
		gchar* _tmp49_;
		_tmp42_ = tracker_sparql_expression_get_context (self);
		_tmp43_ = g_hash_table_lookup (_tmp42_->var_set, variable);
		state = GPOINTER_TO_INT (_tmp43_);
		if (state == 0) {
			state = (gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND;
		}
		_tmp44_ = tracker_sparql_expression_get_context (self);
		_tmp45_ = _g_object_ref0 (variable);
		g_hash_table_insert (_tmp44_->select_var_set, _tmp45_, GINT_TO_POINTER (state));
		_tmp46_ = tracker_sparql_expression_get_context (self);
		_tmp47_ = tracker_sparql_expression_get_context (self);
		_tmp48_ = tracker_sparql_variable_get_name (variable);
		_tmp49_ = g_strdup (_tmp48_);
		_vala_array_add1 (&TRACKER_SPARQL_SELECT_CONTEXT (_tmp47_)->variable_names, &TRACKER_SPARQL_SELECT_CONTEXT (_tmp47_)->variable_names_length1, &TRACKER_SPARQL_SELECT_CONTEXT (_tmp47_)->_variable_names_size_, _tmp49_);
	} else {
		TrackerSparqlContext* _tmp50_ = NULL;
		TrackerSparqlContext* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
		_tmp50_ = tracker_sparql_expression_get_context (self);
		_tmp51_ = tracker_sparql_expression_get_context (self);
		_tmp52_ = g_strdup_printf ("var%d", variable_index + 1);
		_vala_array_add2 (&TRACKER_SPARQL_SELECT_CONTEXT (_tmp51_)->variable_names, &TRACKER_SPARQL_SELECT_CONTEXT (_tmp51_)->variable_names_length1, &TRACKER_SPARQL_SELECT_CONTEXT (_tmp51_)->_variable_names_size_, _tmp52_);
	}
	result = type;
	_g_object_unref0 (variable);
	return result;
}


static void tracker_sparql_expression_translate_expression_as_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error) {
	glong begin;
	TrackerPropertyType _tmp0_;
	TrackerPropertyType _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	begin = (glong) sql->len;
	_tmp0_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp1_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
		g_string_insert (sql, (gssize) begin, "(SELECT Uri FROM Resource WHERE ID = ");
		g_string_append (sql, ")");
	}
}


void tracker_sparql_expression_translate_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ASC, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp1_) {
		tracker_sparql_expression_translate_expression_as_order_condition (self, sql, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		g_string_append (sql, " ASC");
	} else {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DESC, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp3_) {
			tracker_sparql_expression_translate_expression_as_order_condition (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			g_string_append (sql, " DESC");
		} else {
			tracker_sparql_expression_translate_expression_as_order_condition (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static void tracker_sparql_expression_translate_bound_call (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_BOUND, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, "(");
	tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, " IS NOT NULL)");
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void tracker_sparql_expression_translate_regex (TrackerSparqlExpression* self, GString* sql, GError** error) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_REGEX, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, "SparqlRegex(");
	tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, ", ");
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp0_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = _tmp1_;
	_tmp3_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp2_);
	_tmp4_ = _tmp3_;
	g_string_append (sql, _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	g_string_append (sql, ", ");
	_tmp5_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp6_) {
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp7_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp9_ = _tmp8_;
		_tmp10_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp9_);
		_tmp11_ = _tmp10_;
		g_string_append (sql, _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	} else {
		g_string_append (sql, "''");
	}
	g_string_append (sql, ")");
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void tracker_sparql_expression_translate_exists (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerSparqlPattern* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	g_string_append (sql, "(");
	_tmp0_ = tracker_sparql_expression_get_pattern (self);
	tracker_sparql_pattern_translate_exists (_tmp0_, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, ")");
}


void tracker_sparql_expression_append_expression_as_string (GString* sql, const gchar* expression, TrackerPropertyType type) {
	glong begin;
	g_return_if_fail (sql != NULL);
	g_return_if_fail (expression != NULL);
	begin = (glong) sql->len;
	g_string_append (sql, expression);
	tracker_sparql_expression_convert_expression_to_string (sql, type, begin);
}


static void tracker_sparql_expression_convert_expression_to_string (GString* sql, TrackerPropertyType type, glong begin) {
	g_return_if_fail (sql != NULL);
	switch (type) {
		case TRACKER_PROPERTY_TYPE_STRING:
		case TRACKER_PROPERTY_TYPE_INTEGER:
		{
			break;
		}
		case TRACKER_PROPERTY_TYPE_RESOURCE:
		{
			g_string_insert (sql, (gssize) begin, "(SELECT Uri FROM Resource WHERE ID = ");
			g_string_append (sql, ")");
			break;
		}
		case TRACKER_PROPERTY_TYPE_BOOLEAN:
		{
			g_string_insert (sql, (gssize) begin, "CASE ");
			g_string_append (sql, " WHEN 1 THEN 'true' WHEN 0 THEN 'false' ELSE NULL END");
			break;
		}
		case TRACKER_PROPERTY_TYPE_DATETIME:
		{
			g_string_insert (sql, (gssize) begin, "strftime (\"%Y-%m-%dT%H:%M:%SZ\", ");
			g_string_append (sql, ", \"unixepoch\")");
			break;
		}
		default:
		{
			g_string_insert (sql, (gssize) begin, "CAST (");
			g_string_append (sql, " AS TEXT)");
			break;
		}
	}
}


static void tracker_sparql_expression_translate_expression_as_string (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerSparqlTokenType _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_tmp0_ = tracker_sparql_expression_current (self);
	switch (_tmp0_) {
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
		{
			TrackerSparqlLiteralBinding* _tmp1_ = NULL;
			TrackerSparqlLiteralBinding* binding;
			gboolean is_var = FALSE;
			TrackerSparqlPattern* _tmp2_ = NULL;
			gboolean _tmp3_;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp1_ = tracker_sparql_literal_binding_new ();
			binding = _tmp1_;
			_tmp2_ = tracker_sparql_expression_get_pattern (self);
			_tmp4_ = tracker_sparql_pattern_parse_var_or_term (_tmp2_, NULL, &_tmp3_, &_inner_error_);
			is_var = _tmp3_;
			_tmp5_ = _tmp4_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (binding);
					return;
				} else {
					_g_object_unref0 (binding);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp6_ = _tmp5_;
			_g_free0 (binding->literal);
			binding->literal = _tmp6_;
			_tmp7_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
			_tmp8_ = _tmp7_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (binding);
					return;
				} else {
					_g_object_unref0 (binding);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			if (_tmp8_) {
				glong begin;
				TrackerPropertyType _tmp9_;
				TrackerPropertyType type;
				begin = (glong) sql->len;
				_tmp9_ = tracker_sparql_expression_translate_function (self, sql, binding->literal, &_inner_error_);
				type = _tmp9_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (binding);
						return;
					} else {
						_g_object_unref0 (binding);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (binding);
						return;
					} else {
						_g_object_unref0 (binding);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				tracker_sparql_expression_convert_expression_to_string (sql, type, begin);
			} else {
				TrackerSparqlLiteralBinding* _tmp10_;
				g_string_append (sql, "?");
				_tmp10_ = _g_object_ref0 (binding);
				self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp10_);
			}
			_g_object_unref0 (binding);
			break;
		}
		default:
		{
			glong begin;
			TrackerPropertyType _tmp11_;
			TrackerPropertyType type;
			begin = (glong) sql->len;
			_tmp11_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
			type = _tmp11_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			tracker_sparql_expression_convert_expression_to_string (sql, type, begin);
			break;
		}
	}
}


static void tracker_sparql_expression_translate_str (TrackerSparqlExpression* self, GString* sql, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_STR, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void tracker_sparql_expression_translate_isuri (TrackerSparqlExpression* self, GString* sql, GError** error) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	TrackerSparqlLiteralBinding* _tmp2_ = NULL;
	TrackerSparqlLiteralBinding* new_binding;
	TrackerSparqlTokenType _tmp3_;
	TrackerSparqlLiteralBinding* _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ISURI, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (!_tmp1_) {
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_ISIRI, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_string_append (sql, "?");
	_tmp2_ = tracker_sparql_literal_binding_new ();
	new_binding = _tmp2_;
	((TrackerSparqlDataBinding*) new_binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
	_tmp3_ = tracker_sparql_expression_current (self);
	if (_tmp3_ == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = g_strdup ("1");
		_tmp5_ = _tmp4_;
		_g_free0 (new_binding->literal);
		new_binding->literal = _tmp5_;
		tracker_sparql_expression_next (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (new_binding);
				return;
			} else {
				_g_object_unref0 (new_binding);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
		GString* _tmp6_ = NULL;
		GString* _tmp7_;
		TrackerPropertyType _tmp8_;
		TrackerPropertyType _tmp9_;
		TrackerPropertyType _tmp10_;
		_tmp6_ = g_string_new ("");
		_tmp7_ = _tmp6_;
		_tmp8_ = tracker_sparql_expression_translate_expression (self, _tmp7_, &_inner_error_);
		_tmp10_ = (_tmp9_ = _tmp8_, _g_string_free0 (_tmp7_), _tmp9_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (new_binding);
				return;
			} else {
				_g_object_unref0 (new_binding);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp10_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp11_ = g_strdup ("1");
			_tmp12_ = _tmp11_;
			_g_free0 (new_binding->literal);
			new_binding->literal = _tmp12_;
		} else {
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp13_ = g_strdup ("0");
			_tmp14_ = _tmp13_;
			_g_free0 (new_binding->literal);
			new_binding->literal = _tmp14_;
		}
	}
	_tmp15_ = _g_object_ref0 (new_binding);
	self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp15_);
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (new_binding);
			return;
		} else {
			_g_object_unref0 (new_binding);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (new_binding);
}


static void tracker_sparql_expression_translate_datatype (TrackerSparqlExpression* self, GString* sql, GError** error) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_DATATYPE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp1_) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* variable_name;
		TrackerSparqlContext* _tmp6_ = NULL;
		TrackerSparqlVariable* _tmp7_ = NULL;
		TrackerSparqlVariable* _tmp8_;
		TrackerSparqlVariable* variable;
		gboolean _tmp14_ = FALSE;
		TrackerSparqlLiteralBinding* _tmp16_ = NULL;
		TrackerSparqlLiteralBinding* new_binding;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		gchar* _tmp19_;
		TrackerSparqlLiteralBinding* _tmp20_;
		_tmp2_ = tracker_sparql_expression_get_last_string (self, 0);
		_tmp3_ = _tmp2_;
		_tmp4_ = string_substring (_tmp3_, (glong) 1, (glong) (-1));
		variable_name = (_tmp5_ = _tmp4_, _g_free0 (_tmp3_), _tmp5_);
		_tmp6_ = tracker_sparql_expression_get_context (self);
		_tmp7_ = tracker_sparql_context_get_variable (_tmp6_, variable_name);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		variable = _tmp8_;
		if (variable->binding == NULL) {
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			GError* _tmp12_ = NULL;
			GError* _tmp13_;
			_tmp9_ = tracker_sparql_variable_get_name (variable);
			_tmp10_ = g_strdup_printf ("`%s' is not a valid variable", _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = tracker_sparql_expression_get_error (self, _tmp11_);
			_inner_error_ = (_tmp13_ = _tmp12_, _g_free0 (_tmp11_), _tmp13_);
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (variable);
				_g_free0 (variable_name);
				return;
			} else {
				_g_object_unref0 (variable);
				_g_free0 (variable_name);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (((TrackerSparqlDataBinding*) variable->binding)->data_type == TRACKER_PROPERTY_TYPE_RESOURCE) {
			_tmp14_ = TRUE;
		} else {
			_tmp14_ = variable->binding->type == NULL;
		}
		if (_tmp14_) {
			GError* _tmp15_ = NULL;
			_tmp15_ = tracker_sparql_expression_get_error (self, "Invalid FILTER");
			_inner_error_ = _tmp15_;
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (variable);
				_g_free0 (variable_name);
				return;
			} else {
				_g_object_unref0 (variable);
				_g_free0 (variable_name);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		g_string_append (sql, "(SELECT ID FROM Resource WHERE Uri = ?)");
		_tmp16_ = tracker_sparql_literal_binding_new ();
		new_binding = _tmp16_;
		_tmp17_ = tracker_class_get_uri (variable->binding->type);
		_tmp18_ = g_strdup (_tmp17_);
		_tmp19_ = _tmp18_;
		_g_free0 (new_binding->literal);
		new_binding->literal = _tmp19_;
		_tmp20_ = _g_object_ref0 (new_binding);
		self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp20_);
		_g_object_unref0 (new_binding);
		_g_object_unref0 (variable);
		_g_free0 (variable_name);
	} else {
		GError* _tmp21_ = NULL;
		_tmp21_ = tracker_sparql_expression_get_error (self, "Invalid FILTER");
		_inner_error_ = _tmp21_;
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_function (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error) {
	TrackerPropertyType result = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	g_return_val_if_fail (uri != NULL, 0);
	if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_XSD_NS "string") == 0) {
		tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		result = TRACKER_PROPERTY_TYPE_STRING;
		return result;
	} else {
		if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_XSD_NS "integer") == 0) {
			g_string_append (sql, "CAST (");
			tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, " AS INTEGER)");
			result = TRACKER_PROPERTY_TYPE_INTEGER;
			return result;
		} else {
			if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_XSD_NS "double") == 0) {
				g_string_append (sql, "CAST (");
				tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				g_string_append (sql, " AS REAL)");
				result = TRACKER_PROPERTY_TYPE_DOUBLE;
				return result;
			} else {
				if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "lower-case") == 0) {
					g_string_append (sql, "lower (");
					tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return 0;
						}
					}
					g_string_append (sql, ")");
					result = TRACKER_PROPERTY_TYPE_STRING;
					return result;
				} else {
					if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "contains") == 0) {
						TrackerSparqlLiteralBinding* _tmp0_ = NULL;
						TrackerSparqlLiteralBinding* binding;
						gchar* _tmp1_ = NULL;
						gchar* _tmp2_;
						gchar* _tmp3_;
						gchar* _tmp4_ = NULL;
						gchar* _tmp5_;
						TrackerSparqlLiteralBinding* _tmp6_;
						g_string_append (sql, "(");
						tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return 0;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0;
							}
						}
						g_string_append (sql, " GLOB ");
						tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return 0;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0;
							}
						}
						g_string_append (sql, "?");
						_tmp0_ = tracker_sparql_literal_binding_new ();
						binding = _tmp0_;
						_tmp1_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
						_tmp2_ = _tmp1_;
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (binding);
								return 0;
							} else {
								_g_object_unref0 (binding);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0;
							}
						}
						_tmp3_ = _tmp2_;
						_tmp4_ = g_strdup_printf ("*%s*", _tmp3_);
						_tmp5_ = _tmp4_;
						_g_free0 (binding->literal);
						binding->literal = _tmp5_;
						_g_free0 (_tmp3_);
						_tmp6_ = _g_object_ref0 (binding);
						self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp6_);
						g_string_append (sql, ")");
						result = TRACKER_PROPERTY_TYPE_BOOLEAN;
						_g_object_unref0 (binding);
						return result;
					} else {
						if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "starts-with") == 0) {
							gchar* _tmp7_ = NULL;
							gchar* prefix;
							TrackerSparqlLiteralBinding* _tmp8_ = NULL;
							TrackerSparqlLiteralBinding* binding;
							gchar* _tmp9_;
							gchar* _tmp10_;
							TrackerSparqlLiteralBinding* _tmp11_;
							TrackerSparqlLiteralBinding* _tmp12_ = NULL;
							TrackerSparqlLiteralBinding* _tmp13_;
							gchar* _tmp14_ = NULL;
							gchar* _tmp15_;
							gchar* _tmp16_;
							TrackerSparqlLiteralBinding* _tmp17_;
							tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return 0;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return 0;
								}
							}
							g_string_append (sql, " BETWEEN ");
							tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return 0;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return 0;
								}
							}
							_tmp7_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
							prefix = _tmp7_;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return 0;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return 0;
								}
							}
							g_string_append (sql, "?");
							_tmp8_ = tracker_sparql_literal_binding_new ();
							binding = _tmp8_;
							_tmp9_ = g_strdup (prefix);
							_tmp10_ = _tmp9_;
							_g_free0 (binding->literal);
							binding->literal = _tmp10_;
							_tmp11_ = _g_object_ref0 (binding);
							self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp11_);
							g_string_append (sql, " AND ");
							g_string_append (sql, "?");
							_tmp12_ = tracker_sparql_literal_binding_new ();
							_tmp13_ = _tmp12_;
							_g_object_unref0 (binding);
							binding = _tmp13_;
							_tmp14_ = g_unichar_to_string ((gunichar) 0x10fffd);
							_tmp15_ = _tmp14_;
							_tmp16_ = g_strconcat (prefix, _tmp15_, NULL);
							_g_free0 (binding->literal);
							binding->literal = _tmp16_;
							_g_free0 (_tmp15_);
							_tmp17_ = _g_object_ref0 (binding);
							self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp17_);
							result = TRACKER_PROPERTY_TYPE_BOOLEAN;
							_g_object_unref0 (binding);
							_g_free0 (prefix);
							return result;
						} else {
							if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "ends-with") == 0) {
								TrackerSparqlLiteralBinding* _tmp18_ = NULL;
								TrackerSparqlLiteralBinding* binding;
								gchar* _tmp19_ = NULL;
								gchar* _tmp20_;
								gchar* _tmp21_;
								gchar* _tmp22_ = NULL;
								gchar* _tmp23_;
								TrackerSparqlLiteralBinding* _tmp24_;
								g_string_append (sql, "(");
								tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										return 0;
									} else {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return 0;
									}
								}
								g_string_append (sql, " GLOB ");
								tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										return 0;
									} else {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return 0;
									}
								}
								g_string_append (sql, "?");
								_tmp18_ = tracker_sparql_literal_binding_new ();
								binding = _tmp18_;
								_tmp19_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
								_tmp20_ = _tmp19_;
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_object_unref0 (binding);
										return 0;
									} else {
										_g_object_unref0 (binding);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return 0;
									}
								}
								_tmp21_ = _tmp20_;
								_tmp22_ = g_strdup_printf ("*%s", _tmp21_);
								_tmp23_ = _tmp22_;
								_g_free0 (binding->literal);
								binding->literal = _tmp23_;
								_g_free0 (_tmp21_);
								_tmp24_ = _g_object_ref0 (binding);
								self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp24_);
								g_string_append (sql, ")");
								result = TRACKER_PROPERTY_TYPE_BOOLEAN;
								_g_object_unref0 (binding);
								return result;
							} else {
								if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "substring") == 0) {
									gboolean _tmp25_;
									gboolean _tmp26_;
									g_string_append (sql, "substr(");
									tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
											g_propagate_error (error, _inner_error_);
											return 0;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return 0;
										}
									}
									g_string_append (sql, ", ");
									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
											g_propagate_error (error, _inner_error_);
											return 0;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return 0;
										}
									}
									tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
											g_propagate_error (error, _inner_error_);
											return 0;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return 0;
										}
									}
									_tmp25_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
									_tmp26_ = _tmp25_;
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
											g_propagate_error (error, _inner_error_);
											return 0;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return 0;
										}
									}
									if (_tmp26_) {
										g_string_append (sql, ", ");
										tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
										if (_inner_error_ != NULL) {
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
												g_propagate_error (error, _inner_error_);
												return 0;
											} else {
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return 0;
											}
										}
									}
									g_string_append (sql, ")");
									result = TRACKER_PROPERTY_TYPE_STRING;
									return result;
								} else {
									if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "concat") == 0) {
										tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
										if (_inner_error_ != NULL) {
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
												g_propagate_error (error, _inner_error_);
												return 0;
											} else {
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return 0;
											}
										}
										g_string_append (sql, "||");
										tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
										if (_inner_error_ != NULL) {
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
												g_propagate_error (error, _inner_error_);
												return 0;
											} else {
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return 0;
											}
										}
										tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
										if (_inner_error_ != NULL) {
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
												g_propagate_error (error, _inner_error_);
												return 0;
											} else {
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return 0;
											}
										}
										while (TRUE) {
											gboolean _tmp27_;
											gboolean _tmp28_;
											_tmp27_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
											_tmp28_ = _tmp27_;
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return 0;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return 0;
												}
											}
											if (!_tmp28_) {
												break;
											}
											g_string_append (sql, "||");
											tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return 0;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return 0;
												}
											}
										}
										result = TRACKER_PROPERTY_TYPE_STRING;
										return result;
									} else {
										if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "string-join") == 0) {
											g_string_append (sql, "SparqlStringJoin(");
											tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return 0;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return 0;
												}
											}
											tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return 0;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return 0;
												}
											}
											g_string_append (sql, ", ");
											tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return 0;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return 0;
												}
											}
											tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return 0;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return 0;
												}
											}
											while (TRUE) {
												gboolean _tmp29_;
												gboolean _tmp30_;
												_tmp29_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
												_tmp30_ = _tmp29_;
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														return 0;
													} else {
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return 0;
													}
												}
												if (!_tmp30_) {
													break;
												}
												g_string_append (sql, ", ");
												tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														return 0;
													} else {
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return 0;
													}
												}
											}
											tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return 0;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return 0;
												}
											}
											g_string_append (sql, ",");
											tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return 0;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return 0;
												}
											}
											tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
											if (_inner_error_ != NULL) {
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
													g_propagate_error (error, _inner_error_);
													return 0;
												} else {
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return 0;
												}
											}
											g_string_append (sql, ")");
											result = TRACKER_PROPERTY_TYPE_STRING;
											return result;
										} else {
											if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "year-from-dateTime") == 0) {
												gchar* _tmp31_ = NULL;
												gchar* _tmp32_;
												gchar* _tmp33_ = NULL;
												gchar* _tmp34_;
												gchar* variable_name;
												TrackerSparqlContext* _tmp35_ = NULL;
												TrackerSparqlVariable* _tmp36_ = NULL;
												TrackerSparqlVariable* _tmp37_;
												TrackerSparqlVariable* variable;
												gchar* _tmp38_ = NULL;
												gchar* _tmp39_;
												tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
														g_propagate_error (error, _inner_error_);
														return 0;
													} else {
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return 0;
													}
												}
												_tmp31_ = tracker_sparql_expression_get_last_string (self, 0);
												_tmp32_ = _tmp31_;
												_tmp33_ = string_substring (_tmp32_, (glong) 1, (glong) (-1));
												variable_name = (_tmp34_ = _tmp33_, _g_free0 (_tmp32_), _tmp34_);
												_tmp35_ = tracker_sparql_expression_get_context (self);
												_tmp36_ = tracker_sparql_context_get_variable (_tmp35_, variable_name);
												_tmp37_ = _g_object_ref0 (_tmp36_);
												variable = _tmp37_;
												g_string_append (sql, "strftime (\"%Y\", ");
												_tmp38_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localDate");
												_tmp39_ = _tmp38_;
												g_string_append (sql, _tmp39_);
												_g_free0 (_tmp39_);
												g_string_append (sql, " * 24 * 3600, \"unixepoch\")");
												result = TRACKER_PROPERTY_TYPE_INTEGER;
												_g_object_unref0 (variable);
												_g_free0 (variable_name);
												return result;
											} else {
												if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "month-from-dateTime") == 0) {
													gchar* _tmp40_ = NULL;
													gchar* _tmp41_;
													gchar* _tmp42_ = NULL;
													gchar* _tmp43_;
													gchar* variable_name;
													TrackerSparqlContext* _tmp44_ = NULL;
													TrackerSparqlVariable* _tmp45_ = NULL;
													TrackerSparqlVariable* _tmp46_;
													TrackerSparqlVariable* variable;
													gchar* _tmp47_ = NULL;
													gchar* _tmp48_;
													tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
													if (_inner_error_ != NULL) {
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
															g_propagate_error (error, _inner_error_);
															return 0;
														} else {
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
															g_clear_error (&_inner_error_);
															return 0;
														}
													}
													_tmp40_ = tracker_sparql_expression_get_last_string (self, 0);
													_tmp41_ = _tmp40_;
													_tmp42_ = string_substring (_tmp41_, (glong) 1, (glong) (-1));
													variable_name = (_tmp43_ = _tmp42_, _g_free0 (_tmp41_), _tmp43_);
													_tmp44_ = tracker_sparql_expression_get_context (self);
													_tmp45_ = tracker_sparql_context_get_variable (_tmp44_, variable_name);
													_tmp46_ = _g_object_ref0 (_tmp45_);
													variable = _tmp46_;
													g_string_append (sql, "strftime (\"%m\", ");
													_tmp47_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localDate");
													_tmp48_ = _tmp47_;
													g_string_append (sql, _tmp48_);
													_g_free0 (_tmp48_);
													g_string_append (sql, " * 24 * 3600, \"unixepoch\")");
													result = TRACKER_PROPERTY_TYPE_INTEGER;
													_g_object_unref0 (variable);
													_g_free0 (variable_name);
													return result;
												} else {
													if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "day-from-dateTime") == 0) {
														gchar* _tmp49_ = NULL;
														gchar* _tmp50_;
														gchar* _tmp51_ = NULL;
														gchar* _tmp52_;
														gchar* variable_name;
														TrackerSparqlContext* _tmp53_ = NULL;
														TrackerSparqlVariable* _tmp54_ = NULL;
														TrackerSparqlVariable* _tmp55_;
														TrackerSparqlVariable* variable;
														gchar* _tmp56_ = NULL;
														gchar* _tmp57_;
														tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
														if (_inner_error_ != NULL) {
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																g_propagate_error (error, _inner_error_);
																return 0;
															} else {
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																g_clear_error (&_inner_error_);
																return 0;
															}
														}
														_tmp49_ = tracker_sparql_expression_get_last_string (self, 0);
														_tmp50_ = _tmp49_;
														_tmp51_ = string_substring (_tmp50_, (glong) 1, (glong) (-1));
														variable_name = (_tmp52_ = _tmp51_, _g_free0 (_tmp50_), _tmp52_);
														_tmp53_ = tracker_sparql_expression_get_context (self);
														_tmp54_ = tracker_sparql_context_get_variable (_tmp53_, variable_name);
														_tmp55_ = _g_object_ref0 (_tmp54_);
														variable = _tmp55_;
														g_string_append (sql, "strftime (\"%d\", ");
														_tmp56_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localDate");
														_tmp57_ = _tmp56_;
														g_string_append (sql, _tmp57_);
														_g_free0 (_tmp57_);
														g_string_append (sql, " * 24 * 3600, \"unixepoch\")");
														result = TRACKER_PROPERTY_TYPE_INTEGER;
														_g_object_unref0 (variable);
														_g_free0 (variable_name);
														return result;
													} else {
														if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "hours-from-dateTime") == 0) {
															gchar* _tmp58_ = NULL;
															gchar* _tmp59_;
															gchar* _tmp60_ = NULL;
															gchar* _tmp61_;
															gchar* variable_name;
															TrackerSparqlContext* _tmp62_ = NULL;
															TrackerSparqlVariable* _tmp63_ = NULL;
															TrackerSparqlVariable* _tmp64_;
															TrackerSparqlVariable* variable;
															gchar* _tmp65_ = NULL;
															gchar* _tmp66_;
															tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
															if (_inner_error_ != NULL) {
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																	g_propagate_error (error, _inner_error_);
																	return 0;
																} else {
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																	g_clear_error (&_inner_error_);
																	return 0;
																}
															}
															_tmp58_ = tracker_sparql_expression_get_last_string (self, 0);
															_tmp59_ = _tmp58_;
															_tmp60_ = string_substring (_tmp59_, (glong) 1, (glong) (-1));
															variable_name = (_tmp61_ = _tmp60_, _g_free0 (_tmp59_), _tmp61_);
															_tmp62_ = tracker_sparql_expression_get_context (self);
															_tmp63_ = tracker_sparql_context_get_variable (_tmp62_, variable_name);
															_tmp64_ = _g_object_ref0 (_tmp63_);
															variable = _tmp64_;
															g_string_append (sql, "(");
															_tmp65_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localTime");
															_tmp66_ = _tmp65_;
															g_string_append (sql, _tmp66_);
															_g_free0 (_tmp66_);
															g_string_append (sql, " / 3600)");
															result = TRACKER_PROPERTY_TYPE_INTEGER;
															_g_object_unref0 (variable);
															_g_free0 (variable_name);
															return result;
														} else {
															if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "minutes-from-dateTime") == 0) {
																gchar* _tmp67_ = NULL;
																gchar* _tmp68_;
																gchar* _tmp69_ = NULL;
																gchar* _tmp70_;
																gchar* variable_name;
																TrackerSparqlContext* _tmp71_ = NULL;
																TrackerSparqlVariable* _tmp72_ = NULL;
																TrackerSparqlVariable* _tmp73_;
																TrackerSparqlVariable* variable;
																gchar* _tmp74_ = NULL;
																gchar* _tmp75_;
																tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
																if (_inner_error_ != NULL) {
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																		g_propagate_error (error, _inner_error_);
																		return 0;
																	} else {
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																		g_clear_error (&_inner_error_);
																		return 0;
																	}
																}
																_tmp67_ = tracker_sparql_expression_get_last_string (self, 0);
																_tmp68_ = _tmp67_;
																_tmp69_ = string_substring (_tmp68_, (glong) 1, (glong) (-1));
																variable_name = (_tmp70_ = _tmp69_, _g_free0 (_tmp68_), _tmp70_);
																_tmp71_ = tracker_sparql_expression_get_context (self);
																_tmp72_ = tracker_sparql_context_get_variable (_tmp71_, variable_name);
																_tmp73_ = _g_object_ref0 (_tmp72_);
																variable = _tmp73_;
																g_string_append (sql, "(");
																_tmp74_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localTime");
																_tmp75_ = _tmp74_;
																g_string_append (sql, _tmp75_);
																_g_free0 (_tmp75_);
																g_string_append (sql, " / 60 % 60)");
																result = TRACKER_PROPERTY_TYPE_INTEGER;
																_g_object_unref0 (variable);
																_g_free0 (variable_name);
																return result;
															} else {
																if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "seconds-from-dateTime") == 0) {
																	gchar* _tmp76_ = NULL;
																	gchar* _tmp77_;
																	gchar* _tmp78_ = NULL;
																	gchar* _tmp79_;
																	gchar* variable_name;
																	TrackerSparqlContext* _tmp80_ = NULL;
																	TrackerSparqlVariable* _tmp81_ = NULL;
																	TrackerSparqlVariable* _tmp82_;
																	TrackerSparqlVariable* variable;
																	gchar* _tmp83_ = NULL;
																	gchar* _tmp84_;
																	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
																	if (_inner_error_ != NULL) {
																		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																			g_propagate_error (error, _inner_error_);
																			return 0;
																		} else {
																			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																			g_clear_error (&_inner_error_);
																			return 0;
																		}
																	}
																	_tmp76_ = tracker_sparql_expression_get_last_string (self, 0);
																	_tmp77_ = _tmp76_;
																	_tmp78_ = string_substring (_tmp77_, (glong) 1, (glong) (-1));
																	variable_name = (_tmp79_ = _tmp78_, _g_free0 (_tmp77_), _tmp79_);
																	_tmp80_ = tracker_sparql_expression_get_context (self);
																	_tmp81_ = tracker_sparql_context_get_variable (_tmp80_, variable_name);
																	_tmp82_ = _g_object_ref0 (_tmp81_);
																	variable = _tmp82_;
																	g_string_append (sql, "(");
																	_tmp83_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localTime");
																	_tmp84_ = _tmp83_;
																	g_string_append (sql, _tmp84_);
																	_g_free0 (_tmp84_);
																	g_string_append (sql, "% 60)");
																	result = TRACKER_PROPERTY_TYPE_INTEGER;
																	_g_object_unref0 (variable);
																	_g_free0 (variable_name);
																	return result;
																} else {
																	if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FN_NS "timezone-from-dateTime") == 0) {
																		gchar* _tmp85_ = NULL;
																		gchar* _tmp86_;
																		gchar* _tmp87_ = NULL;
																		gchar* _tmp88_;
																		gchar* variable_name;
																		TrackerSparqlContext* _tmp89_ = NULL;
																		TrackerSparqlVariable* _tmp90_ = NULL;
																		TrackerSparqlVariable* _tmp91_;
																		TrackerSparqlVariable* variable;
																		gchar* _tmp92_ = NULL;
																		gchar* _tmp93_;
																		gchar* _tmp94_ = NULL;
																		gchar* _tmp95_;
																		const gchar* _tmp96_ = NULL;
																		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
																		if (_inner_error_ != NULL) {
																			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																				g_propagate_error (error, _inner_error_);
																				return 0;
																			} else {
																				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																				g_clear_error (&_inner_error_);
																				return 0;
																			}
																		}
																		_tmp85_ = tracker_sparql_expression_get_last_string (self, 0);
																		_tmp86_ = _tmp85_;
																		_tmp87_ = string_substring (_tmp86_, (glong) 1, (glong) (-1));
																		variable_name = (_tmp88_ = _tmp87_, _g_free0 (_tmp86_), _tmp88_);
																		_tmp89_ = tracker_sparql_expression_get_context (self);
																		_tmp90_ = tracker_sparql_context_get_variable (_tmp89_, variable_name);
																		_tmp91_ = _g_object_ref0 (_tmp90_);
																		variable = _tmp91_;
																		g_string_append (sql, "(");
																		_tmp92_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localDate");
																		_tmp93_ = _tmp92_;
																		g_string_append (sql, _tmp93_);
																		_g_free0 (_tmp93_);
																		g_string_append (sql, " * 24 * 3600 + ");
																		_tmp94_ = tracker_sparql_variable_get_extra_sql_expression (variable, "localTime");
																		_tmp95_ = _tmp94_;
																		g_string_append (sql, _tmp95_);
																		_g_free0 (_tmp95_);
																		g_string_append (sql, "- ");
																		_tmp96_ = tracker_sparql_variable_get_sql_expression (variable);
																		g_string_append (sql, _tmp96_);
																		g_string_append (sql, ")");
																		result = TRACKER_PROPERTY_TYPE_INTEGER;
																		_g_object_unref0 (variable);
																		_g_free0 (variable_name);
																		return result;
																	} else {
																		if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FTS_NS "rank") == 0) {
																			gboolean is_var = FALSE;
																			TrackerSparqlPattern* _tmp97_ = NULL;
																			gboolean _tmp98_;
																			gchar* _tmp99_ = NULL;
																			gchar* v;
																			_tmp97_ = tracker_sparql_expression_get_pattern (self);
																			_tmp99_ = tracker_sparql_pattern_parse_var_or_term (_tmp97_, NULL, &_tmp98_, &_inner_error_);
																			is_var = _tmp98_;
																			v = _tmp99_;
																			if (_inner_error_ != NULL) {
																				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																					g_propagate_error (error, _inner_error_);
																					return 0;
																				} else {
																					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																					g_clear_error (&_inner_error_);
																					return 0;
																				}
																			}
																			g_string_append_printf (sql, "\"%s_u_rank\"", v);
																			result = TRACKER_PROPERTY_TYPE_DOUBLE;
																			_g_free0 (v);
																			return result;
																		} else {
																			if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_FTS_NS "offsets") == 0) {
																				gboolean is_var = FALSE;
																				TrackerSparqlPattern* _tmp100_ = NULL;
																				gboolean _tmp101_;
																				gchar* _tmp102_ = NULL;
																				gchar* v;
																				_tmp100_ = tracker_sparql_expression_get_pattern (self);
																				_tmp102_ = tracker_sparql_pattern_parse_var_or_term (_tmp100_, NULL, &_tmp101_, &_inner_error_);
																				is_var = _tmp101_;
																				v = _tmp102_;
																				if (_inner_error_ != NULL) {
																					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																						g_propagate_error (error, _inner_error_);
																						return 0;
																					} else {
																						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																						g_clear_error (&_inner_error_);
																						return 0;
																					}
																				}
																				g_string_append_printf (sql, "\"%s_u_offsets\"", v);
																				result = TRACKER_PROPERTY_TYPE_STRING;
																				_g_free0 (v);
																				return result;
																			} else {
																				if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "id") == 0) {
																					TrackerPropertyType _tmp103_;
																					TrackerPropertyType type;
																					_tmp103_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																					type = _tmp103_;
																					if (_inner_error_ != NULL) {
																						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																							g_propagate_error (error, _inner_error_);
																							return 0;
																						} else {
																							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																							g_clear_error (&_inner_error_);
																							return 0;
																						}
																					}
																					if (type != TRACKER_PROPERTY_TYPE_RESOURCE) {
																						GError* _tmp104_ = NULL;
																						_tmp104_ = tracker_sparql_expression_get_error (self, "expected resource");
																						_inner_error_ = _tmp104_;
																						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																							g_propagate_error (error, _inner_error_);
																							return 0;
																						} else {
																							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																							g_clear_error (&_inner_error_);
																							return 0;
																						}
																					}
																					result = TRACKER_PROPERTY_TYPE_INTEGER;
																					return result;
																				} else {
																					if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "uri") == 0) {
																						TrackerPropertyType _tmp105_;
																						TrackerPropertyType type;
																						_tmp105_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																						type = _tmp105_;
																						if (_inner_error_ != NULL) {
																							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																								g_propagate_error (error, _inner_error_);
																								return 0;
																							} else {
																								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																								g_clear_error (&_inner_error_);
																								return 0;
																							}
																						}
																						if (type != TRACKER_PROPERTY_TYPE_INTEGER) {
																							GError* _tmp106_ = NULL;
																							_tmp106_ = tracker_sparql_expression_get_error (self, "expected integer ID");
																							_inner_error_ = _tmp106_;
																							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																								g_propagate_error (error, _inner_error_);
																								return 0;
																							} else {
																								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																								g_clear_error (&_inner_error_);
																								return 0;
																							}
																						}
																						result = TRACKER_PROPERTY_TYPE_RESOURCE;
																						return result;
																					} else {
																						if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "cartesian-distance") == 0) {
																							g_string_append (sql, "SparqlCartesianDistance(");
																							tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																							if (_inner_error_ != NULL) {
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																									g_propagate_error (error, _inner_error_);
																									return 0;
																								} else {
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																									g_clear_error (&_inner_error_);
																									return 0;
																								}
																							}
																							g_string_append (sql, ", ");
																							tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																							if (_inner_error_ != NULL) {
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																									g_propagate_error (error, _inner_error_);
																									return 0;
																								} else {
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																									g_clear_error (&_inner_error_);
																									return 0;
																								}
																							}
																							tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																							if (_inner_error_ != NULL) {
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																									g_propagate_error (error, _inner_error_);
																									return 0;
																								} else {
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																									g_clear_error (&_inner_error_);
																									return 0;
																								}
																							}
																							g_string_append (sql, ", ");
																							tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																							if (_inner_error_ != NULL) {
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																									g_propagate_error (error, _inner_error_);
																									return 0;
																								} else {
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																									g_clear_error (&_inner_error_);
																									return 0;
																								}
																							}
																							tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																							if (_inner_error_ != NULL) {
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																									g_propagate_error (error, _inner_error_);
																									return 0;
																								} else {
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																									g_clear_error (&_inner_error_);
																									return 0;
																								}
																							}
																							g_string_append (sql, ", ");
																							tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																							if (_inner_error_ != NULL) {
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																									g_propagate_error (error, _inner_error_);
																									return 0;
																								} else {
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																									g_clear_error (&_inner_error_);
																									return 0;
																								}
																							}
																							tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																							if (_inner_error_ != NULL) {
																								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																									g_propagate_error (error, _inner_error_);
																									return 0;
																								} else {
																									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																									g_clear_error (&_inner_error_);
																									return 0;
																								}
																							}
																							g_string_append (sql, ")");
																							result = TRACKER_PROPERTY_TYPE_DOUBLE;
																							return result;
																						} else {
																							if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "haversine-distance") == 0) {
																								g_string_append (sql, "SparqlHaversineDistance(");
																								tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																								if (_inner_error_ != NULL) {
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																										g_propagate_error (error, _inner_error_);
																										return 0;
																									} else {
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																										g_clear_error (&_inner_error_);
																										return 0;
																									}
																								}
																								g_string_append (sql, ", ");
																								tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																								if (_inner_error_ != NULL) {
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																										g_propagate_error (error, _inner_error_);
																										return 0;
																									} else {
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																										g_clear_error (&_inner_error_);
																										return 0;
																									}
																								}
																								tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																								if (_inner_error_ != NULL) {
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																										g_propagate_error (error, _inner_error_);
																										return 0;
																									} else {
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																										g_clear_error (&_inner_error_);
																										return 0;
																									}
																								}
																								g_string_append (sql, ", ");
																								tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																								if (_inner_error_ != NULL) {
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																										g_propagate_error (error, _inner_error_);
																										return 0;
																									} else {
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																										g_clear_error (&_inner_error_);
																										return 0;
																									}
																								}
																								tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																								if (_inner_error_ != NULL) {
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																										g_propagate_error (error, _inner_error_);
																										return 0;
																									} else {
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																										g_clear_error (&_inner_error_);
																										return 0;
																									}
																								}
																								g_string_append (sql, ", ");
																								tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																								if (_inner_error_ != NULL) {
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																										g_propagate_error (error, _inner_error_);
																										return 0;
																									} else {
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																										g_clear_error (&_inner_error_);
																										return 0;
																									}
																								}
																								tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																								if (_inner_error_ != NULL) {
																									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																										g_propagate_error (error, _inner_error_);
																										return 0;
																									} else {
																										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																										g_clear_error (&_inner_error_);
																										return 0;
																									}
																								}
																								g_string_append (sql, ")");
																								result = TRACKER_PROPERTY_TYPE_DOUBLE;
																								return result;
																							} else {
																								if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "coalesce") == 0) {
																									g_string_append (sql, "COALESCE(");
																									tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																									if (_inner_error_ != NULL) {
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																											g_propagate_error (error, _inner_error_);
																											return 0;
																										} else {
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																											g_clear_error (&_inner_error_);
																											return 0;
																										}
																									}
																									g_string_append (sql, ", ");
																									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																									if (_inner_error_ != NULL) {
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																											g_propagate_error (error, _inner_error_);
																											return 0;
																										} else {
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																											g_clear_error (&_inner_error_);
																											return 0;
																										}
																									}
																									tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																									if (_inner_error_ != NULL) {
																										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																											g_propagate_error (error, _inner_error_);
																											return 0;
																										} else {
																											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																											g_clear_error (&_inner_error_);
																											return 0;
																										}
																									}
																									while (TRUE) {
																										gboolean _tmp107_;
																										gboolean _tmp108_;
																										_tmp107_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																										_tmp108_ = _tmp107_;
																										if (_inner_error_ != NULL) {
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																												g_propagate_error (error, _inner_error_);
																												return 0;
																											} else {
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																												g_clear_error (&_inner_error_);
																												return 0;
																											}
																										}
																										if (!_tmp108_) {
																											break;
																										}
																										g_string_append (sql, ", ");
																										tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																										if (_inner_error_ != NULL) {
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																												g_propagate_error (error, _inner_error_);
																												return 0;
																											} else {
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																												g_clear_error (&_inner_error_);
																												return 0;
																											}
																										}
																									}
																									g_string_append (sql, ")");
																									result = TRACKER_PROPERTY_TYPE_STRING;
																									return result;
																								} else {
																									if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "uri-is-parent") == 0) {
																										g_string_append (sql, "SparqlUriIsParent(");
																										tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																										if (_inner_error_ != NULL) {
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																												g_propagate_error (error, _inner_error_);
																												return 0;
																											} else {
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																												g_clear_error (&_inner_error_);
																												return 0;
																											}
																										}
																										g_string_append (sql, ", ");
																										tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																										if (_inner_error_ != NULL) {
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																												g_propagate_error (error, _inner_error_);
																												return 0;
																											} else {
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																												g_clear_error (&_inner_error_);
																												return 0;
																											}
																										}
																										tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																										if (_inner_error_ != NULL) {
																											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																												g_propagate_error (error, _inner_error_);
																												return 0;
																											} else {
																												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																												g_clear_error (&_inner_error_);
																												return 0;
																											}
																										}
																										g_string_append (sql, ")");
																										result = TRACKER_PROPERTY_TYPE_BOOLEAN;
																										return result;
																									} else {
																										if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "uri-is-descendant") == 0) {
																											g_string_append (sql, "SparqlUriIsDescendant(");
																											tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																											if (_inner_error_ != NULL) {
																												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																													g_propagate_error (error, _inner_error_);
																													return 0;
																												} else {
																													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																													g_clear_error (&_inner_error_);
																													return 0;
																												}
																											}
																											g_string_append (sql, ", ");
																											tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
																											if (_inner_error_ != NULL) {
																												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																													g_propagate_error (error, _inner_error_);
																													return 0;
																												} else {
																													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																													g_clear_error (&_inner_error_);
																													return 0;
																												}
																											}
																											tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																											if (_inner_error_ != NULL) {
																												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																													g_propagate_error (error, _inner_error_);
																													return 0;
																												} else {
																													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																													g_clear_error (&_inner_error_);
																													return 0;
																												}
																											}
																											g_string_append (sql, ")");
																											result = TRACKER_PROPERTY_TYPE_BOOLEAN;
																											return result;
																										} else {
																											if (g_strcmp0 (uri, TRACKER_SPARQL_EXPRESSION_TRACKER_NS "string-from-filename") == 0) {
																												g_string_append (sql, "SparqlStringFromFilename(");
																												tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
																												if (_inner_error_ != NULL) {
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																														g_propagate_error (error, _inner_error_);
																														return 0;
																													} else {
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																														g_clear_error (&_inner_error_);
																														return 0;
																													}
																												}
																												g_string_append (sql, ")");
																												result = TRACKER_PROPERTY_TYPE_STRING;
																												return result;
																											} else {
																												TrackerProperty* _tmp109_ = NULL;
																												TrackerProperty* _tmp110_;
																												TrackerProperty* prop;
																												gboolean _tmp112_;
																												_tmp109_ = tracker_ontologies_get_property_by_uri (uri);
																												_tmp110_ = _g_object_ref0 (_tmp109_);
																												prop = _tmp110_;
																												if (prop == NULL) {
																													GError* _tmp111_ = NULL;
																													_tmp111_ = tracker_sparql_expression_get_error (self, "Unknown function");
																													_inner_error_ = _tmp111_;
																													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																														g_propagate_error (error, _inner_error_);
																														_g_object_unref0 (prop);
																														return 0;
																													} else {
																														_g_object_unref0 (prop);
																														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																														g_clear_error (&_inner_error_);
																														return 0;
																													}
																												}
																												_tmp112_ = tracker_property_get_multiple_values (prop);
																												if (_tmp112_) {
																													glong begin;
																													const gchar* _tmp113_ = NULL;
																													TrackerPropertyType _tmp114_;
																													const gchar* _tmp115_ = NULL;
																													g_string_append (sql, "(SELECT GROUP_CONCAT(");
																													begin = (glong) sql->len;
																													_tmp113_ = tracker_property_get_name (prop);
																													g_string_append_printf (sql, "\"%s\"", _tmp113_);
																													_tmp114_ = tracker_property_get_data_type (prop);
																													tracker_sparql_expression_convert_expression_to_string (sql, _tmp114_, begin);
																													_tmp115_ = tracker_property_get_table_name (prop);
																													g_string_append_printf (sql, ",',') FROM \"%s\" WHERE ID = ", _tmp115_);
																													tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																													if (_inner_error_ != NULL) {
																														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																															g_propagate_error (error, _inner_error_);
																															_g_object_unref0 (prop);
																															return 0;
																														} else {
																															_g_object_unref0 (prop);
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																															g_clear_error (&_inner_error_);
																															return 0;
																														}
																													}
																													g_string_append (sql, ")");
																													result = TRACKER_PROPERTY_TYPE_STRING;
																													_g_object_unref0 (prop);
																													return result;
																												} else {
																													const gchar* _tmp116_ = NULL;
																													const gchar* _tmp117_ = NULL;
																													TrackerPropertyType _tmp118_;
																													TrackerPropertyType _tmp119_;
																													_tmp116_ = tracker_property_get_name (prop);
																													_tmp117_ = tracker_property_get_table_name (prop);
																													g_string_append_printf (sql, "(SELECT \"%s\" FROM \"%s\" WHERE ID = ", _tmp116_, _tmp117_);
																													tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
																													if (_inner_error_ != NULL) {
																														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
																															g_propagate_error (error, _inner_error_);
																															_g_object_unref0 (prop);
																															return 0;
																														} else {
																															_g_object_unref0 (prop);
																															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
																															g_clear_error (&_inner_error_);
																															return 0;
																														}
																													}
																													g_string_append (sql, ")");
																													_tmp118_ = tracker_property_get_data_type (prop);
																													if (_tmp118_ == TRACKER_PROPERTY_TYPE_STRING) {
																														tracker_sparql_expression_append_collate (self, sql);
																													}
																													_tmp119_ = tracker_property_get_data_type (prop);
																													result = _tmp119_;
																													_g_object_unref0 (prop);
																													return result;
																												}
																												_g_object_unref0 (prop);
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static TrackerPropertyType tracker_sparql_expression_parse_type_uri (TrackerSparqlExpression* self, GError** error) {
	TrackerPropertyType result = 0;
	gchar* type_iri;
	TrackerPropertyType type = 0;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	type_iri = NULL;
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (type_iri);
			return 0;
		} else {
			_g_free0 (type_iri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (_tmp1_) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp2_ = tracker_sparql_expression_get_last_string (self, 1);
		_tmp3_ = _tmp2_;
		_g_free0 (type_iri);
		type_iri = _tmp3_;
	} else {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (type_iri);
				return 0;
			} else {
				_g_free0 (type_iri);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (_tmp5_) {
			gchar* _tmp6_ = NULL;
			gchar* ns;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp6_ = tracker_sparql_expression_get_last_string (self, 0);
			ns = _tmp6_;
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ns);
					_g_free0 (type_iri);
					return 0;
				} else {
					_g_free0 (ns);
					_g_free0 (type_iri);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp7_ = tracker_sparql_expression_get_last_string (self, 0);
			_tmp8_ = _tmp7_;
			_tmp9_ = string_substring (_tmp8_, (glong) 1, (glong) (-1));
			_tmp10_ = _tmp9_;
			_tmp11_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, ns, _tmp10_, &_inner_error_);
			_tmp13_ = (_tmp12_ = _tmp11_, _g_free0 (_tmp10_), _g_free0 (_tmp8_), _tmp12_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ns);
					_g_free0 (type_iri);
					return 0;
				} else {
					_g_free0 (ns);
					_g_free0 (type_iri);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp14_ = _tmp13_;
			_g_free0 (type_iri);
			type_iri = _tmp14_;
			_g_free0 (ns);
		} else {
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (type_iri);
					return 0;
				} else {
					_g_free0 (type_iri);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp15_ = tracker_sparql_expression_get_last_string (self, 0);
			_tmp16_ = _tmp15_;
			_tmp17_ = string_substring (_tmp16_, (glong) 1, (glong) (-1));
			_tmp18_ = _tmp17_;
			_tmp19_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, "", _tmp18_, &_inner_error_);
			_tmp21_ = (_tmp20_ = _tmp19_, _g_free0 (_tmp18_), _g_free0 (_tmp16_), _tmp20_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (type_iri);
					return 0;
				} else {
					_g_free0 (type_iri);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp22_ = _tmp21_;
			_g_free0 (type_iri);
			type_iri = _tmp22_;
		}
	}
	if (g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "boolean") == 0) {
		type = TRACKER_PROPERTY_TYPE_BOOLEAN;
	} else {
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		if (g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "integer") == 0) {
			_tmp34_ = TRUE;
		} else {
			_tmp34_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "nonPositiveInteger") == 0;
		}
		if (_tmp34_) {
			_tmp33_ = TRUE;
		} else {
			_tmp33_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "negativeInteger") == 0;
		}
		if (_tmp33_) {
			_tmp32_ = TRUE;
		} else {
			_tmp32_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "long") == 0;
		}
		if (_tmp32_) {
			_tmp31_ = TRUE;
		} else {
			_tmp31_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "int") == 0;
		}
		if (_tmp31_) {
			_tmp30_ = TRUE;
		} else {
			_tmp30_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "short") == 0;
		}
		if (_tmp30_) {
			_tmp29_ = TRUE;
		} else {
			_tmp29_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "byte") == 0;
		}
		if (_tmp29_) {
			_tmp28_ = TRUE;
		} else {
			_tmp28_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "nonNegativeInteger") == 0;
		}
		if (_tmp28_) {
			_tmp27_ = TRUE;
		} else {
			_tmp27_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedLong") == 0;
		}
		if (_tmp27_) {
			_tmp26_ = TRUE;
		} else {
			_tmp26_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedInt") == 0;
		}
		if (_tmp26_) {
			_tmp25_ = TRUE;
		} else {
			_tmp25_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedShort") == 0;
		}
		if (_tmp25_) {
			_tmp24_ = TRUE;
		} else {
			_tmp24_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "unsignedByte") == 0;
		}
		if (_tmp24_) {
			_tmp23_ = TRUE;
		} else {
			_tmp23_ = g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "positiveInteger") == 0;
		}
		if (_tmp23_) {
			type = TRACKER_PROPERTY_TYPE_INTEGER;
		} else {
			if (g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "double") == 0) {
				type = TRACKER_PROPERTY_TYPE_DOUBLE;
			} else {
				if (g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "date") == 0) {
					type = TRACKER_PROPERTY_TYPE_DATE;
				} else {
					if (g_strcmp0 (type_iri, TRACKER_SPARQL_EXPRESSION_XSD_NS "dateTime") == 0) {
						type = TRACKER_PROPERTY_TYPE_DATETIME;
					} else {
						type = TRACKER_PROPERTY_TYPE_STRING;
					}
				}
			}
		}
	}
	result = type;
	_g_free0 (type_iri);
	return result;
}


gchar* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error) {
	TrackerPropertyType _type = 0;
	gchar* result = NULL;
	TrackerSparqlTokenType _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	tracker_sparql_expression_next (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = tracker_sparql_expression_last (self);
	switch (_tmp0_) {
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
		{
			GString* _tmp1_ = NULL;
			GString* sb;
			gchar* _tmp2_ = NULL;
			gchar* s;
			const gchar* p;
			glong _tmp3_;
			const gchar* end;
			gboolean _tmp9_;
			gboolean _tmp10_;
			gchar* _tmp12_;
			_tmp1_ = g_string_new ("");
			sb = _tmp1_;
			_tmp2_ = tracker_sparql_expression_get_last_string (self, 1);
			s = _tmp2_;
			p = s;
			_tmp3_ = strlen (s);
			end = p + _tmp3_;
			while (TRUE) {
				const gchar* _tmp4_ = NULL;
				const gchar* q;
				if (!(((glong) p) < ((glong) end))) {
					break;
				}
				_tmp4_ = strchr (p, (gint) '\\');
				q = _tmp4_;
				if (q == NULL) {
					g_string_append_len (sb, p, (gssize) ((glong) (end - p)));
					p = end;
				} else {
					g_string_append_len (sb, p, (gssize) ((glong) (q - p)));
					p = q + 1;
					switch (((gchar*) p)[0]) {
						case '\'':
						case '"':
						case '\\':
						{
							g_string_append_c (sb, ((gchar*) p)[0]);
							break;
						}
						case 'b':
						{
							g_string_append_c (sb, '\b');
							break;
						}
						case 'f':
						{
							g_string_append_c (sb, '\f');
							break;
						}
						case 'n':
						{
							g_string_append_c (sb, '\n');
							break;
						}
						case 'r':
						{
							g_string_append_c (sb, '\r');
							break;
						}
						case 't':
						{
							g_string_append_c (sb, '\t');
							break;
						}
						case 'u':
						{
							gchar* ptr;
							gint _tmp5_;
							gint _tmp6_;
							gint _tmp7_;
							gint _tmp8_;
							gunichar c;
							ptr = ((gchar*) p) + 1;
							_tmp5_ = g_ascii_xdigit_value (ptr[0]);
							_tmp6_ = g_ascii_xdigit_value (ptr[1]);
							_tmp7_ = g_ascii_xdigit_value (ptr[2]);
							_tmp8_ = g_ascii_xdigit_value (ptr[3]);
							c = (((((((gunichar) _tmp5_) * 16) + _tmp6_) * 16) + _tmp7_) * 16) + _tmp8_;
							g_string_append_unichar (sb, c);
							p = p + 4;
							break;
						}
					}
					p++;
				}
			}
			_tmp9_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
			_tmp10_ = _tmp9_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (s);
					_g_string_free0 (sb);
					return NULL;
				} else {
					_g_free0 (s);
					_g_string_free0 (sb);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			if (_tmp10_) {
				TrackerPropertyType _tmp11_;
				TrackerPropertyType parsed_type;
				_tmp11_ = tracker_sparql_expression_parse_type_uri (self, &_inner_error_);
				parsed_type = _tmp11_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (s);
						_g_string_free0 (sb);
						return NULL;
					} else {
						_g_free0 (s);
						_g_string_free0 (sb);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				if ((&_type) == NULL) {
				} else {
					_type = parsed_type;
				}
			}
			_tmp12_ = g_strdup (sb->str);
			result = _tmp12_;
			_g_free0 (s);
			_g_string_free0 (sb);
			if (type) {
				*type = _type;
			}
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
		{
			gchar* _tmp13_ = NULL;
			gchar* _result_;
			gboolean _tmp14_;
			gboolean _tmp15_;
			_tmp13_ = tracker_sparql_expression_get_last_string (self, 3);
			_result_ = _tmp13_;
			_tmp14_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, &_inner_error_);
			_tmp15_ = _tmp14_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (_result_);
					return NULL;
				} else {
					_g_free0 (_result_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			if (_tmp15_) {
				TrackerPropertyType _tmp16_;
				TrackerPropertyType parsed_type;
				_tmp16_ = tracker_sparql_expression_parse_type_uri (self, &_inner_error_);
				parsed_type = _tmp16_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (_result_);
						return NULL;
					} else {
						_g_free0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				if ((&_type) == NULL) {
				} else {
					_type = parsed_type;
				}
			}
			result = _result_;
			if (type) {
				*type = _type;
			}
			return result;
		}
		default:
		{
			GError* _tmp17_ = NULL;
			_tmp17_ = tracker_sparql_expression_get_error (self, "expected string literal");
			_inner_error_ = _tmp17_;
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	if (type) {
		*type = _type;
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_uri_expression (TrackerSparqlExpression* self, GString* sql, const gchar* uri, GError** error) {
	TrackerPropertyType result = 0;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	g_return_val_if_fail (uri != NULL, 0);
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (_tmp1_) {
		TrackerPropertyType _tmp2_;
		TrackerPropertyType _result_;
		_tmp2_ = tracker_sparql_expression_translate_function (self, sql, uri, &_inner_error_);
		_result_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		result = _result_;
		return result;
	} else {
		TrackerSparqlLiteralBinding* _tmp3_ = NULL;
		TrackerSparqlLiteralBinding* binding;
		gchar* _tmp4_;
		gchar* _tmp5_;
		TrackerSparqlLiteralBinding* _tmp6_;
		g_string_append (sql, "COALESCE((SELECT ID FROM Resource WHERE Uri = ?), 0)");
		_tmp3_ = tracker_sparql_literal_binding_new ();
		binding = _tmp3_;
		_tmp4_ = g_strdup (uri);
		_tmp5_ = _tmp4_;
		_g_free0 (binding->literal);
		binding->literal = _tmp5_;
		_tmp6_ = _g_object_ref0 (binding);
		self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp6_);
		result = TRACKER_PROPERTY_TYPE_RESOURCE;
		_g_object_unref0 (binding);
		return result;
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_primary_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerPropertyType type = 0;
	TrackerSparqlTokenType _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = tracker_sparql_expression_current (self);
	switch (_tmp0_) {
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
		{
			TrackerPropertyType _tmp1_;
			TrackerPropertyType _tmp2_;
			_tmp1_ = tracker_sparql_expression_translate_bracketted_expression (self, sql, &_inner_error_);
			_tmp2_ = _tmp1_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp2_;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
		{
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			TrackerPropertyType _tmp5_;
			TrackerPropertyType _tmp6_;
			TrackerPropertyType _tmp7_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp3_ = tracker_sparql_expression_get_last_string (self, 1);
			_tmp4_ = _tmp3_;
			_tmp5_ = tracker_sparql_expression_translate_uri_expression (self, sql, _tmp4_, &_inner_error_);
			_tmp7_ = (_tmp6_ = _tmp5_, _g_free0 (_tmp4_), _tmp6_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp7_;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_DECIMAL:
		case TRACKER_SPARQL_TOKEN_TYPE_DOUBLE:
		{
			TrackerSparqlLiteralBinding* _tmp8_ = NULL;
			TrackerSparqlLiteralBinding* binding;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			TrackerSparqlLiteralBinding* _tmp11_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "?");
			_tmp8_ = tracker_sparql_literal_binding_new ();
			binding = _tmp8_;
			_tmp9_ = tracker_sparql_expression_get_last_string (self, 0);
			_tmp10_ = _tmp9_;
			_g_free0 (binding->literal);
			binding->literal = _tmp10_;
			_tmp11_ = _g_object_ref0 (binding);
			self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp11_);
			result = TRACKER_PROPERTY_TYPE_DOUBLE;
			_g_object_unref0 (binding);
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_TRUE:
		{
			TrackerSparqlLiteralBinding* _tmp12_ = NULL;
			TrackerSparqlLiteralBinding* binding;
			gchar* _tmp13_;
			gchar* _tmp14_;
			TrackerSparqlLiteralBinding* _tmp15_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "?");
			_tmp12_ = tracker_sparql_literal_binding_new ();
			binding = _tmp12_;
			_tmp13_ = g_strdup ("1");
			_tmp14_ = _tmp13_;
			_g_free0 (binding->literal);
			binding->literal = _tmp14_;
			((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
			_tmp15_ = _g_object_ref0 (binding);
			self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp15_);
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			_g_object_unref0 (binding);
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_FALSE:
		{
			TrackerSparqlLiteralBinding* _tmp16_ = NULL;
			TrackerSparqlLiteralBinding* binding;
			gchar* _tmp17_;
			gchar* _tmp18_;
			TrackerSparqlLiteralBinding* _tmp19_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "?");
			_tmp16_ = tracker_sparql_literal_binding_new ();
			binding = _tmp16_;
			_tmp17_ = g_strdup ("0");
			_tmp18_ = _tmp17_;
			_g_free0 (binding->literal);
			binding->literal = _tmp18_;
			((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
			_tmp19_ = _g_object_ref0 (binding);
			self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp19_);
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			_g_object_unref0 (binding);
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
		{
			TrackerSparqlLiteralBinding* _tmp20_ = NULL;
			TrackerSparqlLiteralBinding* binding;
			TrackerPropertyType _tmp21_;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_;
			gchar* _tmp24_;
			TrackerSparqlLiteralBinding* _tmp25_;
			_tmp20_ = tracker_sparql_literal_binding_new ();
			binding = _tmp20_;
			_tmp22_ = tracker_sparql_expression_parse_string_literal (self, &_tmp21_, &_inner_error_);
			type = _tmp21_;
			_tmp23_ = _tmp22_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (binding);
					return 0;
				} else {
					_g_object_unref0 (binding);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp24_ = _tmp23_;
			_g_free0 (binding->literal);
			binding->literal = _tmp24_;
			_tmp25_ = _g_object_ref0 (binding);
			self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp25_);
			switch (type) {
				case TRACKER_PROPERTY_TYPE_INTEGER:
				case TRACKER_PROPERTY_TYPE_BOOLEAN:
				{
					g_string_append (sql, "?");
					((TrackerSparqlDataBinding*) binding)->data_type = type;
					result = type;
					_g_object_unref0 (binding);
					return result;
				}
				default:
				{
					g_string_append (sql, "?");
					tracker_sparql_expression_append_collate (self, sql);
					result = TRACKER_PROPERTY_TYPE_STRING;
					_g_object_unref0 (binding);
					return result;
				}
			}
			_g_object_unref0 (binding);
		}
		case TRACKER_SPARQL_TOKEN_TYPE_INTEGER:
		{
			TrackerSparqlLiteralBinding* _tmp26_ = NULL;
			TrackerSparqlLiteralBinding* binding;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_;
			TrackerSparqlLiteralBinding* _tmp29_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "?");
			_tmp26_ = tracker_sparql_literal_binding_new ();
			binding = _tmp26_;
			_tmp27_ = tracker_sparql_expression_get_last_string (self, 0);
			_tmp28_ = _tmp27_;
			_g_free0 (binding->literal);
			binding->literal = _tmp28_;
			((TrackerSparqlDataBinding*) binding)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
			_tmp29_ = _g_object_ref0 (binding);
			self->priv->query->bindings = g_list_append (self->priv->query->bindings, _tmp29_);
			result = TRACKER_PROPERTY_TYPE_INTEGER;
			_g_object_unref0 (binding);
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_VAR:
		{
			gchar* _tmp30_ = NULL;
			gchar* _tmp31_;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_;
			gchar* variable_name;
			TrackerSparqlContext* _tmp34_ = NULL;
			TrackerSparqlVariable* _tmp35_ = NULL;
			TrackerSparqlVariable* _tmp36_;
			TrackerSparqlVariable* variable;
			const gchar* _tmp37_ = NULL;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp30_ = tracker_sparql_expression_get_last_string (self, 0);
			_tmp31_ = _tmp30_;
			_tmp32_ = string_substring (_tmp31_, (glong) 1, (glong) (-1));
			variable_name = (_tmp33_ = _tmp32_, _g_free0 (_tmp31_), _tmp33_);
			_tmp34_ = tracker_sparql_expression_get_context (self);
			_tmp35_ = tracker_sparql_context_get_variable (_tmp34_, variable_name);
			_tmp36_ = _g_object_ref0 (_tmp35_);
			variable = _tmp36_;
			_tmp37_ = tracker_sparql_variable_get_sql_expression (variable);
			g_string_append (sql, _tmp37_);
			if (variable->binding == NULL) {
				result = TRACKER_PROPERTY_TYPE_UNKNOWN;
				_g_object_unref0 (variable);
				_g_free0 (variable_name);
				return result;
			} else {
				if (((TrackerSparqlDataBinding*) variable->binding)->data_type == TRACKER_PROPERTY_TYPE_STRING) {
					tracker_sparql_expression_append_collate (self, sql);
				}
				result = ((TrackerSparqlDataBinding*) variable->binding)->data_type;
				_g_object_unref0 (variable);
				_g_free0 (variable_name);
				return result;
			}
			_g_object_unref0 (variable);
			_g_free0 (variable_name);
		}
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
		{
			tracker_sparql_expression_translate_str (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_STRING;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
		{
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "''");
			result = TRACKER_PROPERTY_TYPE_STRING;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
		{
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "0");
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
		{
			tracker_sparql_expression_translate_datatype (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_RESOURCE;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
		{
			tracker_sparql_expression_translate_bound_call (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
		{
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "(");
			tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, " = ");
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, ")");
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
		{
			tracker_sparql_expression_translate_isuri (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
		{
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "0");
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
		{
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
		{
			tracker_sparql_expression_translate_regex (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			tracker_sparql_query_set_has_regex (self->priv->query, TRUE);
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_EXISTS:
		case TRACKER_SPARQL_TOKEN_TYPE_NOT:
		{
			tracker_sparql_expression_translate_exists (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_BOOLEAN;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_COUNT:
		{
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "COUNT(");
			tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, ")");
			result = TRACKER_PROPERTY_TYPE_INTEGER;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_SUM:
		{
			TrackerPropertyType _tmp38_;
			TrackerPropertyType _tmp39_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "SUM(");
			_tmp38_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error_);
			_tmp39_ = _tmp38_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			type = _tmp39_;
			g_string_append (sql, ")");
			result = type;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_AVG:
		{
			TrackerPropertyType _tmp40_;
			TrackerPropertyType _tmp41_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "AVG(");
			_tmp40_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error_);
			_tmp41_ = _tmp40_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			type = _tmp41_;
			g_string_append (sql, ")");
			result = type;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_MIN:
		{
			TrackerPropertyType _tmp42_;
			TrackerPropertyType _tmp43_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "MIN(");
			_tmp42_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error_);
			_tmp43_ = _tmp42_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			type = _tmp43_;
			g_string_append (sql, ")");
			result = type;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_MAX:
		{
			TrackerPropertyType _tmp44_;
			TrackerPropertyType _tmp45_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "MAX(");
			_tmp44_ = tracker_sparql_expression_translate_aggregate_expression (self, sql, &_inner_error_);
			_tmp45_ = _tmp44_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			type = _tmp45_;
			g_string_append (sql, ")");
			result = type;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT:
		{
			gchar* _tmp46_ = NULL;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_ = NULL;
			gchar* _tmp50_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, "GROUP_CONCAT(");
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			tracker_sparql_expression_translate_expression_as_string (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, ", ");
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp46_ = tracker_sparql_expression_parse_string_literal (self, NULL, &_inner_error_);
			_tmp47_ = _tmp46_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp48_ = _tmp47_;
			_tmp49_ = tracker_sparql_expression_escape_sql_string_literal (self, _tmp48_);
			_tmp50_ = _tmp49_;
			g_string_append (sql, _tmp50_);
			_g_free0 (_tmp50_);
			_g_free0 (_tmp48_);
			g_string_append (sql, ")");
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = TRACKER_PROPERTY_TYPE_STRING;
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
		{
			gchar* _tmp51_ = NULL;
			gchar* ns;
			gchar* _tmp52_ = NULL;
			gchar* _tmp53_;
			gchar* _tmp54_ = NULL;
			gchar* _tmp55_;
			gchar* _tmp56_ = NULL;
			gchar* _tmp57_;
			gchar* uri;
			TrackerPropertyType _tmp58_;
			TrackerPropertyType _tmp59_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp51_ = tracker_sparql_expression_get_last_string (self, 0);
			ns = _tmp51_;
			tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ns);
					return 0;
				} else {
					_g_free0 (ns);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp52_ = tracker_sparql_expression_get_last_string (self, 0);
			_tmp53_ = _tmp52_;
			_tmp54_ = string_substring (_tmp53_, (glong) 1, (glong) (-1));
			_tmp55_ = _tmp54_;
			_tmp56_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, ns, _tmp55_, &_inner_error_);
			uri = (_tmp57_ = _tmp56_, _g_free0 (_tmp55_), _g_free0 (_tmp53_), _tmp57_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ns);
					return 0;
				} else {
					_g_free0 (ns);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp58_ = tracker_sparql_expression_translate_uri_expression (self, sql, uri, &_inner_error_);
			_tmp59_ = _tmp58_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (uri);
					_g_free0 (ns);
					return 0;
				} else {
					_g_free0 (uri);
					_g_free0 (ns);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp59_;
			_g_free0 (uri);
			_g_free0 (ns);
			return result;
		}
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
		{
			gchar* _tmp60_ = NULL;
			gchar* _tmp61_;
			gchar* _tmp62_ = NULL;
			gchar* _tmp63_;
			gchar* _tmp64_ = NULL;
			gchar* _tmp65_;
			gchar* uri;
			TrackerPropertyType _tmp66_;
			TrackerPropertyType _tmp67_;
			tracker_sparql_expression_next (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp60_ = tracker_sparql_expression_get_last_string (self, 0);
			_tmp61_ = _tmp60_;
			_tmp62_ = string_substring (_tmp61_, (glong) 1, (glong) (-1));
			_tmp63_ = _tmp62_;
			_tmp64_ = tracker_sparql_query_resolve_prefixed_name (self->priv->query, "", _tmp63_, &_inner_error_);
			uri = (_tmp65_ = _tmp64_, _g_free0 (_tmp63_), _g_free0 (_tmp61_), _tmp65_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp66_ = tracker_sparql_expression_translate_uri_expression (self, sql, uri, &_inner_error_);
			_tmp67_ = _tmp66_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (uri);
					return 0;
				} else {
					_g_free0 (uri);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp67_;
			_g_free0 (uri);
			return result;
		}
		default:
		{
			GError* _tmp68_ = NULL;
			_tmp68_ = tracker_sparql_expression_get_error (self, "expected primary expression");
			_inner_error_ = _tmp68_;
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	}
}


static TrackerPropertyType tracker_sparql_expression_translate_unary_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	gboolean _tmp0_;
	gboolean _tmp1_;
	TrackerPropertyType _tmp11_;
	TrackerPropertyType _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_NEG, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (_tmp1_) {
		TrackerPropertyType _tmp2_;
		TrackerPropertyType optype;
		g_string_append (sql, "NOT (");
		_tmp2_ = tracker_sparql_expression_translate_primary_expression (self, sql, &_inner_error_);
		optype = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		g_string_append (sql, ")");
		if (optype != TRACKER_PROPERTY_TYPE_BOOLEAN) {
			GError* _tmp3_ = NULL;
			_tmp3_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
			_inner_error_ = _tmp3_;
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		result = TRACKER_PROPERTY_TYPE_BOOLEAN;
		return result;
	} else {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PLUS, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (_tmp5_) {
			TrackerPropertyType _tmp6_;
			TrackerPropertyType _tmp7_;
			_tmp6_ = tracker_sparql_expression_translate_primary_expression (self, sql, &_inner_error_);
			_tmp7_ = _tmp6_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp7_;
			return result;
		} else {
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp8_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_MINUS, &_inner_error_);
			_tmp9_ = _tmp8_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			if (_tmp9_) {
				TrackerPropertyType _tmp10_;
				TrackerPropertyType optype;
				g_string_append (sql, "-(");
				_tmp10_ = tracker_sparql_expression_translate_primary_expression (self, sql, &_inner_error_);
				optype = _tmp10_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				g_string_append (sql, ")");
				result = optype;
				return result;
			}
		}
	}
	_tmp11_ = tracker_sparql_expression_translate_primary_expression (self, sql, &_inner_error_);
	_tmp12_ = _tmp11_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp12_;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_multiplicative_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	glong begin;
	TrackerPropertyType _tmp0_;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	begin = (glong) sql->len;
	_tmp0_ = tracker_sparql_expression_translate_unary_expression (self, sql, &_inner_error_);
	optype = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	while (TRUE) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STAR, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (_tmp2_) {
			gboolean _tmp3_;
			TrackerPropertyType _tmp5_;
			TrackerPropertyType _tmp6_;
			gboolean _tmp7_;
			_tmp3_ = tracker_sparql_expression_maybe_numeric (self, optype);
			if (!_tmp3_) {
				GError* _tmp4_ = NULL;
				_tmp4_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
				_inner_error_ = _tmp4_;
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_insert (sql, (gssize) begin, "(");
			g_string_append (sql, " * ");
			_tmp5_ = tracker_sparql_expression_translate_unary_expression (self, sql, &_inner_error_);
			_tmp6_ = _tmp5_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp7_ = tracker_sparql_expression_maybe_numeric (self, _tmp6_);
			if (!_tmp7_) {
				GError* _tmp8_ = NULL;
				_tmp8_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
				_inner_error_ = _tmp8_;
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, ")");
		} else {
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp9_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DIV, &_inner_error_);
			_tmp10_ = _tmp9_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			if (_tmp10_) {
				gboolean _tmp11_;
				TrackerPropertyType _tmp13_;
				TrackerPropertyType _tmp14_;
				gboolean _tmp15_;
				_tmp11_ = tracker_sparql_expression_maybe_numeric (self, optype);
				if (!_tmp11_) {
					GError* _tmp12_ = NULL;
					_tmp12_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
					_inner_error_ = _tmp12_;
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				g_string_insert (sql, (gssize) begin, "(");
				g_string_append (sql, " / ");
				_tmp13_ = tracker_sparql_expression_translate_unary_expression (self, sql, &_inner_error_);
				_tmp14_ = _tmp13_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				_tmp15_ = tracker_sparql_expression_maybe_numeric (self, _tmp14_);
				if (!_tmp15_) {
					GError* _tmp16_ = NULL;
					_tmp16_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
					_inner_error_ = _tmp16_;
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				g_string_append (sql, ")");
			} else {
				break;
			}
		}
	}
	result = optype;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_additive_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	glong begin;
	TrackerPropertyType _tmp0_;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	begin = (glong) sql->len;
	_tmp0_ = tracker_sparql_expression_translate_multiplicative_expression (self, sql, &_inner_error_);
	optype = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	while (TRUE) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PLUS, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (_tmp2_) {
			gboolean _tmp3_;
			TrackerPropertyType _tmp5_;
			TrackerPropertyType _tmp6_;
			gboolean _tmp7_;
			_tmp3_ = tracker_sparql_expression_maybe_numeric (self, optype);
			if (!_tmp3_) {
				GError* _tmp4_ = NULL;
				_tmp4_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
				_inner_error_ = _tmp4_;
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_insert (sql, (gssize) begin, "(");
			g_string_append (sql, " + ");
			_tmp5_ = tracker_sparql_expression_translate_multiplicative_expression (self, sql, &_inner_error_);
			_tmp6_ = _tmp5_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			_tmp7_ = tracker_sparql_expression_maybe_numeric (self, _tmp6_);
			if (!_tmp7_) {
				GError* _tmp8_ = NULL;
				_tmp8_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
				_inner_error_ = _tmp8_;
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			g_string_append (sql, ")");
		} else {
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp9_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_MINUS, &_inner_error_);
			_tmp10_ = _tmp9_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			if (_tmp10_) {
				gboolean _tmp11_;
				TrackerPropertyType _tmp13_;
				TrackerPropertyType _tmp14_;
				gboolean _tmp15_;
				_tmp11_ = tracker_sparql_expression_maybe_numeric (self, optype);
				if (!_tmp11_) {
					GError* _tmp12_ = NULL;
					_tmp12_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
					_inner_error_ = _tmp12_;
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				g_string_insert (sql, (gssize) begin, "(");
				g_string_append (sql, " - ");
				_tmp13_ = tracker_sparql_expression_translate_multiplicative_expression (self, sql, &_inner_error_);
				_tmp14_ = _tmp13_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				_tmp15_ = tracker_sparql_expression_maybe_numeric (self, _tmp14_);
				if (!_tmp15_) {
					GError* _tmp16_ = NULL;
					_tmp16_ = tracker_sparql_expression_get_error (self, "expected numeric operand");
					_inner_error_ = _tmp16_;
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				g_string_append (sql, ")");
			} else {
				break;
			}
		}
	}
	result = optype;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_numeric_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerPropertyType _tmp0_;
	TrackerPropertyType _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = tracker_sparql_expression_translate_additive_expression (self, sql, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp1_;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_process_relational_expression (TrackerSparqlExpression* self, GString* sql, glong begin, guint n_bindings, TrackerPropertyType op1type, const gchar* operator, GError** error) {
	TrackerPropertyType result = 0;
	TrackerPropertyType _tmp0_;
	TrackerPropertyType op2type;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	g_return_val_if_fail (operator != NULL, 0);
	g_string_insert (sql, (gssize) begin, "(");
	g_string_append (sql, operator);
	_tmp0_ = tracker_sparql_expression_translate_numeric_expression (self, sql, &_inner_error_);
	op2type = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	g_string_append (sql, ")");
	if (op1type == TRACKER_PROPERTY_TYPE_DATETIME) {
		_tmp2_ = op2type == TRACKER_PROPERTY_TYPE_STRING;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		if (op1type == TRACKER_PROPERTY_TYPE_STRING) {
			_tmp3_ = op2type == TRACKER_PROPERTY_TYPE_DATETIME;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		guint _tmp4_;
		_tmp4_ = g_list_length (self->priv->query->bindings);
		if (_tmp4_ == (n_bindings + 1)) {
			GList* _tmp5_ = NULL;
			_tmp5_ = g_list_last (self->priv->query->bindings);
			((TrackerSparqlDataBinding*) ((TrackerSparqlLiteralBinding*) _tmp5_->data))->data_type = TRACKER_PROPERTY_TYPE_DATETIME;
		}
	}
	result = TRACKER_PROPERTY_TYPE_BOOLEAN;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_in (TrackerSparqlExpression* self, GString* sql, gboolean not, GError** error) {
	TrackerPropertyType result = 0;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	if (not) {
		g_string_append (sql, " NOT");
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	g_string_append (sql, " IN (");
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (!_tmp1_) {
		tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		while (TRUE) {
			gboolean _tmp2_;
			gboolean _tmp3_;
			_tmp2_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
			_tmp3_ = _tmp2_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			if (!_tmp3_) {
				break;
			}
			g_string_append (sql, ", ");
			tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
		}
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	}
	g_string_append (sql, ")");
	result = TRACKER_PROPERTY_TYPE_BOOLEAN;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_relational_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	glong begin;
	guint _tmp0_;
	guint n_bindings;
	TrackerPropertyType _tmp1_;
	TrackerPropertyType optype;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	begin = (glong) sql->len;
	_tmp0_ = g_list_length (self->priv->query->bindings);
	n_bindings = _tmp0_;
	_tmp1_ = tracker_sparql_expression_translate_numeric_expression (self, sql, &_inner_error_);
	optype = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp2_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_GE, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (_tmp3_) {
		TrackerPropertyType _tmp4_;
		TrackerPropertyType _tmp5_;
		_tmp4_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, optype, " >= ", &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		result = _tmp5_;
		return result;
	} else {
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_EQ, &_inner_error_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (_tmp7_) {
			TrackerPropertyType _tmp8_;
			TrackerPropertyType _tmp9_;
			_tmp8_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, optype, " = ", &_inner_error_);
			_tmp9_ = _tmp8_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp9_;
			return result;
		} else {
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp10_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_NE, &_inner_error_);
			_tmp11_ = _tmp10_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			if (_tmp11_) {
				TrackerPropertyType _tmp12_;
				TrackerPropertyType _tmp13_;
				_tmp12_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, optype, " <> ", &_inner_error_);
				_tmp13_ = _tmp12_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				result = _tmp13_;
				return result;
			} else {
				gboolean _tmp14_;
				gboolean _tmp15_;
				_tmp14_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_LT, &_inner_error_);
				_tmp15_ = _tmp14_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
						g_propagate_error (error, _inner_error_);
						return 0;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				if (_tmp15_) {
					TrackerPropertyType _tmp16_;
					TrackerPropertyType _tmp17_;
					_tmp16_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, optype, " < ", &_inner_error_);
					_tmp17_ = _tmp16_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return 0;
						}
					}
					result = _tmp17_;
					return result;
				} else {
					gboolean _tmp18_;
					gboolean _tmp19_;
					_tmp18_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_LE, &_inner_error_);
					_tmp19_ = _tmp18_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return 0;
						}
					}
					if (_tmp19_) {
						TrackerPropertyType _tmp20_;
						TrackerPropertyType _tmp21_;
						_tmp20_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, optype, " <= ", &_inner_error_);
						_tmp21_ = _tmp20_;
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return 0;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0;
							}
						}
						result = _tmp21_;
						return result;
					} else {
						gboolean _tmp22_;
						gboolean _tmp23_;
						_tmp22_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_GT, &_inner_error_);
						_tmp23_ = _tmp22_;
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
								g_propagate_error (error, _inner_error_);
								return 0;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0;
							}
						}
						if (_tmp23_) {
							TrackerPropertyType _tmp24_;
							TrackerPropertyType _tmp25_;
							_tmp24_ = tracker_sparql_expression_process_relational_expression (self, sql, begin, n_bindings, optype, " > ", &_inner_error_);
							_tmp25_ = _tmp24_;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return 0;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return 0;
								}
							}
							result = _tmp25_;
							return result;
						} else {
							gboolean _tmp26_;
							gboolean _tmp27_;
							_tmp26_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_IN, &_inner_error_);
							_tmp27_ = _tmp26_;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
									g_propagate_error (error, _inner_error_);
									return 0;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return 0;
								}
							}
							if (_tmp27_) {
								TrackerPropertyType _tmp28_;
								TrackerPropertyType _tmp29_;
								_tmp28_ = tracker_sparql_expression_translate_in (self, sql, FALSE, &_inner_error_);
								_tmp29_ = _tmp28_;
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										return 0;
									} else {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return 0;
									}
								}
								result = _tmp29_;
								return result;
							} else {
								gboolean _tmp30_;
								gboolean _tmp31_;
								_tmp30_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_NOT, &_inner_error_);
								_tmp31_ = _tmp30_;
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
										g_propagate_error (error, _inner_error_);
										return 0;
									} else {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return 0;
									}
								}
								if (_tmp31_) {
									TrackerPropertyType _tmp32_;
									TrackerPropertyType _tmp33_;
									tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OP_IN, &_inner_error_);
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
											g_propagate_error (error, _inner_error_);
											return 0;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return 0;
										}
									}
									_tmp32_ = tracker_sparql_expression_translate_in (self, sql, TRUE, &_inner_error_);
									_tmp33_ = _tmp32_;
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
											g_propagate_error (error, _inner_error_);
											return 0;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return 0;
										}
									}
									result = _tmp33_;
									return result;
								}
							}
						}
					}
				}
			}
		}
	}
	result = optype;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_value_logical (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerPropertyType _tmp0_;
	TrackerPropertyType _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = tracker_sparql_expression_translate_relational_expression (self, sql, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp1_;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_conditional_and_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	glong begin;
	TrackerPropertyType _tmp0_;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	begin = (glong) sql->len;
	_tmp0_ = tracker_sparql_expression_translate_value_logical (self, sql, &_inner_error_);
	optype = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	while (TRUE) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		TrackerPropertyType _tmp4_;
		TrackerPropertyType _tmp5_;
		_tmp1_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_AND, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (!_tmp2_) {
			break;
		}
		if (optype != TRACKER_PROPERTY_TYPE_BOOLEAN) {
			GError* _tmp3_ = NULL;
			_tmp3_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
			_inner_error_ = _tmp3_;
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		g_string_insert (sql, (gssize) begin, "(");
		g_string_append (sql, " AND ");
		_tmp4_ = tracker_sparql_expression_translate_value_logical (self, sql, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		optype = _tmp5_;
		g_string_append (sql, ")");
		if (optype != TRACKER_PROPERTY_TYPE_BOOLEAN) {
			GError* _tmp6_ = NULL;
			_tmp6_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
			_inner_error_ = _tmp6_;
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	}
	result = optype;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_conditional_or_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	glong begin;
	TrackerPropertyType _tmp0_;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	begin = (glong) sql->len;
	_tmp0_ = tracker_sparql_expression_translate_conditional_and_expression (self, sql, &_inner_error_);
	optype = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	while (TRUE) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		TrackerPropertyType _tmp4_;
		TrackerPropertyType _tmp5_;
		_tmp1_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OP_OR, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		if (!_tmp2_) {
			break;
		}
		if (optype != TRACKER_PROPERTY_TYPE_BOOLEAN) {
			GError* _tmp3_ = NULL;
			_tmp3_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
			_inner_error_ = _tmp3_;
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		g_string_insert (sql, (gssize) begin, "(");
		g_string_append (sql, " OR ");
		_tmp4_ = tracker_sparql_expression_translate_conditional_and_expression (self, sql, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		optype = _tmp5_;
		g_string_append (sql, ")");
		if (optype != TRACKER_PROPERTY_TYPE_BOOLEAN) {
			GError* _tmp6_ = NULL;
			_tmp6_ = tracker_sparql_expression_get_error (self, "expected boolean expression");
			_inner_error_ = _tmp6_;
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	}
	result = optype;
	return result;
}


TrackerPropertyType tracker_sparql_expression_translate_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerPropertyType _tmp0_;
	TrackerPropertyType _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = tracker_sparql_expression_translate_conditional_or_expression (self, sql, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp1_;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_bracketted_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerSparqlTokenType _tmp0_;
	TrackerPropertyType _tmp3_;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp0_ = tracker_sparql_expression_current (self);
	if (_tmp0_ == TRACKER_SPARQL_TOKEN_TYPE_SELECT) {
		TrackerSparqlPattern* _tmp1_ = NULL;
		TrackerSparqlSelectContext* _tmp2_ = NULL;
		TrackerSparqlSelectContext* select_context;
		g_string_append (sql, "(");
		_tmp1_ = tracker_sparql_expression_get_pattern (self);
		_tmp2_ = tracker_sparql_pattern_translate_select (_tmp1_, sql, TRUE, TRUE, &_inner_error_);
		select_context = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		g_string_append (sql, ")");
		tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_tracker_sparql_context_unref0 (select_context);
				return 0;
			} else {
				_tracker_sparql_context_unref0 (select_context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
		result = select_context->type;
		_tracker_sparql_context_unref0 (select_context);
		return result;
	}
	_tmp3_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
	optype = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = optype;
	return result;
}


static TrackerPropertyType tracker_sparql_expression_translate_aggregate_expression (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	gboolean _tmp0_;
	gboolean _tmp1_;
	TrackerPropertyType _tmp2_;
	TrackerPropertyType optype;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp0_ = tracker_sparql_expression_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DISTINCT, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	if (_tmp1_) {
		g_string_append (sql, "DISTINCT ");
	}
	_tmp2_ = tracker_sparql_expression_translate_expression (self, sql, &_inner_error_);
	optype = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	tracker_sparql_expression_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = optype;
	return result;
}


TrackerPropertyType tracker_sparql_expression_translate_constraint (TrackerSparqlExpression* self, GString* sql, GError** error) {
	TrackerPropertyType result = 0;
	TrackerSparqlTokenType _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = tracker_sparql_expression_current (self);
	switch (_tmp0_) {
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
		case TRACKER_SPARQL_TOKEN_TYPE_EXISTS:
		case TRACKER_SPARQL_TOKEN_TYPE_NOT:
		{
			TrackerPropertyType _tmp1_;
			TrackerPropertyType _tmp2_;
			_tmp1_ = tracker_sparql_expression_translate_primary_expression (self, sql, &_inner_error_);
			_tmp2_ = _tmp1_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp2_;
			return result;
		}
		default:
		{
			TrackerPropertyType _tmp3_;
			TrackerPropertyType _tmp4_;
			_tmp3_ = tracker_sparql_expression_translate_bracketted_expression (self, sql, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			result = _tmp4_;
			return result;
		}
	}
}


static TrackerSparqlContext* tracker_sparql_expression_get_context (TrackerSparqlExpression* self) {
	TrackerSparqlContext* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->query->context;
	return result;
}


static TrackerSparqlPattern* tracker_sparql_expression_get_pattern (TrackerSparqlExpression* self) {
	TrackerSparqlPattern* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->query->pattern;
	return result;
}


static void tracker_sparql_expression_class_init (TrackerSparqlExpressionClass * klass) {
	tracker_sparql_expression_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerSparqlExpressionPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_expression_get_property;
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_expression_finalize;
}


static void tracker_sparql_expression_instance_init (TrackerSparqlExpression * self) {
	self->priv = TRACKER_SPARQL_EXPRESSION_GET_PRIVATE (self);
}


static void tracker_sparql_expression_finalize (GObject* obj) {
	TrackerSparqlExpression * self;
	self = TRACKER_SPARQL_EXPRESSION (obj);
	G_OBJECT_CLASS (tracker_sparql_expression_parent_class)->finalize (obj);
}


GType tracker_sparql_expression_get_type (void) {
	static volatile gsize tracker_sparql_expression_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlExpression), 0, (GInstanceInitFunc) tracker_sparql_expression_instance_init, NULL };
		GType tracker_sparql_expression_type_id;
		tracker_sparql_expression_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlExpression", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_expression_type_id__volatile, tracker_sparql_expression_type_id);
	}
	return tracker_sparql_expression_type_id__volatile;
}


static void _vala_tracker_sparql_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlExpression * self;
	self = TRACKER_SPARQL_EXPRESSION (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



