/* tracker-needle.c generated by valac 0.36.3, the Vala compiler
 * generated from tracker-needle.vala, do not modify */

/**/
/* Copyright 2010, Martyn Russell <martyn@lanedo.com>*/
/**/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <atk/atk.h>
#include "config.h"
#include <gobject/gvaluecollector.h>


#define TRACKER_TYPE_NEEDLE (tracker_needle_get_type ())
#define TRACKER_NEEDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_NEEDLE, TrackerNeedle))
#define TRACKER_NEEDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_NEEDLE, TrackerNeedleClass))
#define TRACKER_IS_NEEDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_NEEDLE))
#define TRACKER_IS_NEEDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_NEEDLE))
#define TRACKER_NEEDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_NEEDLE, TrackerNeedleClass))

typedef struct _TrackerNeedle TrackerNeedle;
typedef struct _TrackerNeedleClass TrackerNeedleClass;
typedef struct _TrackerNeedlePrivate TrackerNeedlePrivate;

#define TRACKER_TYPE_HISTORY (tracker_history_get_type ())
#define TRACKER_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_HISTORY, TrackerHistory))
#define TRACKER_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_HISTORY, TrackerHistoryClass))
#define TRACKER_IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_HISTORY))
#define TRACKER_IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_HISTORY))
#define TRACKER_HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_HISTORY, TrackerHistoryClass))

typedef struct _TrackerHistory TrackerHistory;
typedef struct _TrackerHistoryClass TrackerHistoryClass;

#define TRACKER_TYPE_VIEW (tracker_view_get_type ())
#define TRACKER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_VIEW, TrackerView))
#define TRACKER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_VIEW, TrackerViewClass))
#define TRACKER_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_VIEW))
#define TRACKER_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_VIEW))
#define TRACKER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_VIEW, TrackerViewClass))

typedef struct _TrackerView TrackerView;
typedef struct _TrackerViewClass TrackerViewClass;

#define TYPE_TRACKER_TAGS_VIEW (tracker_tags_view_get_type ())
#define TRACKER_TAGS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_TAGS_VIEW, TrackerTagsView))
#define TRACKER_TAGS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_TAGS_VIEW, TrackerTagsViewClass))
#define IS_TRACKER_TAGS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_TAGS_VIEW))
#define IS_TRACKER_TAGS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_TAGS_VIEW))
#define TRACKER_TAGS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_TAGS_VIEW, TrackerTagsViewClass))

typedef struct _TrackerTagsView TrackerTagsView;
typedef struct _TrackerTagsViewClass TrackerTagsViewClass;

#define TRACKER_TYPE_RESULT_STORE (tracker_result_store_get_type ())
#define TRACKER_RESULT_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_RESULT_STORE, TrackerResultStore))
#define TRACKER_RESULT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_RESULT_STORE, TrackerResultStoreClass))
#define TRACKER_IS_RESULT_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_RESULT_STORE))
#define TRACKER_IS_RESULT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_RESULT_STORE))
#define TRACKER_RESULT_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_RESULT_STORE, TrackerResultStoreClass))

typedef struct _TrackerResultStore TrackerResultStore;
typedef struct _TrackerResultStoreClass TrackerResultStoreClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _tracker_history_unref0(var) ((var == NULL) ? NULL : (var = (tracker_history_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TRACKER_QUERY_TYPE_TYPE (tracker_query_type_get_type ())

#define TRACKER_QUERY_TYPE_MATCH (tracker_query_match_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TRACKER_VIEW_TYPE_DISPLAY (tracker_view_display_get_type ())
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _tracker_needle_unref0(var) ((var == NULL) ? NULL : (var = (tracker_needle_unref (var), NULL)))

#define TRACKER_TYPE_STATS (tracker_stats_get_type ())
#define TRACKER_STATS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STATS, TrackerStats))
#define TRACKER_STATS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STATS, TrackerStatsClass))
#define TRACKER_IS_STATS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STATS))
#define TRACKER_IS_STATS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STATS))
#define TRACKER_STATS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STATS, TrackerStatsClass))

typedef struct _TrackerStats TrackerStats;
typedef struct _TrackerStatsClass TrackerStatsClass;
typedef struct _TrackerParamSpecNeedle TrackerParamSpecNeedle;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _TrackerNeedle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerNeedlePrivate * priv;
};

struct _TrackerNeedleClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerNeedle *self);
};

struct _TrackerNeedlePrivate {
	GSettings* settings_needle;
	TrackerHistory* history;
	GtkWindow* window;
	GtkToggleToolButton* view_categories;
	GtkToggleToolButton* view_filelist;
	GtkToggleToolButton* view_icons;
	GtkSeparatorToolItem* separator_secondary;
	GtkToggleToolButton* find_in_contents;
	GtkToggleToolButton* find_in_titles;
	GtkToggleToolButton* find_in_tags;
	GtkToggleToolButton* find_in_all;
	GtkToolItem* search_entry;
	GtkComboBox* search_list;
	GtkEntry* search;
	GtkSpinner* spinner;
	GtkToolItem* spinner_shell;
	GtkToggleToolButton* show_tags;
	GtkToolButton* show_stats;
	GtkBox* view;
	TrackerView* sw_noresults;
	TrackerView* sw_categories;
	TrackerView* sw_filelist;
	TrackerView* sw_icons;
	GtkInfoBar* info_bar;
	GtkLabel* info_bar_label;
	TrackerTagsView* tags_view;
	guint last_search_id;
	gint size_small;
	gint size_medium;
	gint size_big;
	guint limit;
	gint default_view;
	GtkWidget* current_view;
	TrackerResultStore* categories_model;
	TrackerResultStore* files_model;
	TrackerResultStore* files_in_tags_model;
	TrackerResultStore* files_in_title_model;
	TrackerResultStore* images_model;
	TrackerResultStore* images_in_title_model;
};

typedef enum  {
	TRACKER_QUERY_TYPE_ALL,
	TRACKER_QUERY_TYPE_CONTACTS,
	TRACKER_QUERY_TYPE_APPLICATIONS,
	TRACKER_QUERY_TYPE_MUSIC,
	TRACKER_QUERY_TYPE_IMAGES,
	TRACKER_QUERY_TYPE_VIDEOS,
	TRACKER_QUERY_TYPE_DOCUMENTS,
	TRACKER_QUERY_TYPE_MAIL,
	TRACKER_QUERY_TYPE_CALENDAR,
	TRACKER_QUERY_TYPE_FOLDERS,
	TRACKER_QUERY_TYPE_BOOKMARKS
} TrackerQueryType;

typedef enum  {
	TRACKER_QUERY_MATCH_NONE,
	TRACKER_QUERY_MATCH_FTS,
	TRACKER_QUERY_MATCH_FTS_INDIRECT,
	TRACKER_QUERY_MATCH_TITLES,
	TRACKER_QUERY_MATCH_TITLES_INDIRECT,
	TRACKER_QUERY_MATCH_TAGS_ONLY,
	TRACKER_QUERY_MATCH_TAGS_ONLY_INDIRECT
} TrackerQueryMatch;

typedef enum  {
	TRACKER_VIEW_DISPLAY_NO_RESULTS,
	TRACKER_VIEW_DISPLAY_CATEGORIES,
	TRACKER_VIEW_DISPLAY_FILE_LIST,
	TRACKER_VIEW_DISPLAY_FILE_ICONS
} TrackerViewDisplay;

struct _Block4Data {
	int _ref_count_;
	TrackerNeedle* self;
	GtkTreeModel* model;
	GList* uris;
};

struct _TrackerParamSpecNeedle {
	GParamSpec parent_instance;
};


static gpointer tracker_needle_parent_class = NULL;
static gboolean tracker_needle_current_find_in_filelist;
static gboolean tracker_needle_current_find_in_filelist = TRUE;
static gboolean tracker_needle_current_find_in_icons;
static gboolean tracker_needle_current_find_in_icons = TRUE;
extern gboolean print_version;
gboolean print_version = FALSE;
extern gchar** search_criteria;
gchar** search_criteria = NULL;

gpointer tracker_needle_ref (gpointer instance);
void tracker_needle_unref (gpointer instance);
GParamSpec* tracker_param_spec_needle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_value_set_needle (GValue* value, gpointer v_object);
void tracker_value_take_needle (GValue* value, gpointer v_object);
gpointer tracker_value_get_needle (const GValue* value);
GType tracker_needle_get_type (void) G_GNUC_CONST;
gpointer tracker_history_ref (gpointer instance);
void tracker_history_unref (gpointer instance);
GParamSpec* tracker_param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_value_set_history (GValue* value, gpointer v_object);
void tracker_value_take_history (GValue* value, gpointer v_object);
gpointer tracker_value_get_history (const GValue* value);
GType tracker_history_get_type (void) G_GNUC_CONST;
GType tracker_view_get_type (void) G_GNUC_CONST;
GType tracker_tags_view_get_type (void) G_GNUC_CONST;
GType tracker_result_store_get_type (void) G_GNUC_CONST;
#define TRACKER_NEEDLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_NEEDLE, TrackerNeedlePrivate))
enum  {
	TRACKER_NEEDLE_DUMMY_PROPERTY
};
#define TRACKER_NEEDLE_UI_FILE "tracker-needle.ui"
static void tracker_needle_result_overflow (TrackerNeedle* self);
void tracker_needle_show_info_message (TrackerNeedle* self, const gchar* message, GtkMessageType type);
static void tracker_needle_create_models (TrackerNeedle* self);
TrackerResultStore* tracker_result_store_new (gint _n_columns);
TrackerResultStore* tracker_result_store_construct (GType object_type, gint _n_columns);
void tracker_result_store_set_limit (TrackerResultStore* self, guint value);
static void _tracker_needle_result_overflow_tracker_result_store_result_overflow (TrackerResultStore* _sender, gpointer self);
GType tracker_query_type_get_type (void) G_GNUC_CONST;
GType tracker_query_match_get_type (void) G_GNUC_CONST;
void tracker_result_store_add_query (TrackerResultStore* self, TrackerQueryType type, TrackerQueryMatch match, ...);
void tracker_result_store_set_icon_size (TrackerResultStore* self, gint value);
TrackerNeedle* tracker_needle_new (void);
TrackerNeedle* tracker_needle_construct (GType object_type);
TrackerHistory* tracker_history_new (void);
TrackerHistory* tracker_history_construct (GType object_type);
static void __lambda8_ (TrackerNeedle* self, const gchar* key);
static void ___lambda8__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
void tracker_needle_show (TrackerNeedle* self);
static void tracker_needle_setup_ui (TrackerNeedle* self);
void tracker_needle_set_search (TrackerNeedle* self, gchar** args, int args_length1);
static void tracker_needle_store_state_changed (TrackerNeedle* self, GObject* object, GParamSpec* p);
gboolean tracker_result_store_get_active (TrackerResultStore* self);
static void tracker_needle_window_closed (TrackerNeedle* self);
static void _tracker_needle_window_closed_gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static gboolean tracker_needle_window_key_press_event (TrackerNeedle* self, GtkWidget* widget, GdkEventKey* event);
static gboolean _tracker_needle_window_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void tracker_needle_info_bar_closed (TrackerNeedle* self, GtkButton* source);
static void _tracker_needle_info_bar_closed_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void tracker_needle_view_toggled (TrackerNeedle* self);
static void _tracker_needle_view_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self);
static void tracker_needle_find_in_toggled (TrackerNeedle* self);
static void _tracker_needle_find_in_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self);
static void tracker_needle_search_changed (TrackerNeedle* self, GtkEditable* editable);
static void _tracker_needle_search_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void tracker_needle_search_activated (TrackerNeedle* self, GtkEntry* entry);
static void _tracker_needle_search_activated_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static gboolean tracker_needle_search_key_press_event (TrackerNeedle* self, GtkWidget* widget, GdkEventKey* event);
static gboolean _tracker_needle_search_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void tracker_needle_search_history_insert (TrackerNeedle* self, gchar** history, int history_length1);
gchar** tracker_history_get (TrackerHistory* self, int* result_length1);
static void tracker_needle_show_tags_clicked (TrackerNeedle* self);
static void _tracker_needle_show_tags_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void tracker_needle_show_stats_clicked (TrackerNeedle* self);
static void _tracker_needle_show_stats_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
GType tracker_view_display_get_type (void) G_GNUC_CONST;
TrackerView* tracker_view_new (TrackerViewDisplay* _display, TrackerResultStore* store);
TrackerView* tracker_view_construct (GType object_type, TrackerViewDisplay* _display, TrackerResultStore* store);
TrackerResultStore* tracker_view_get_store (TrackerView* self);
static void _tracker_needle_store_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void tracker_needle_view_row_activated (TrackerNeedle* self, GtkTreeView* view, GtkTreePath* path, GtkTreeViewColumn* column);
static void _tracker_needle_view_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static void tracker_needle_view_row_selected (TrackerNeedle* self, GtkTreeSelection* selection);
static void _tracker_needle_view_row_selected_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void tracker_needle_icon_item_activated (TrackerNeedle* self, GtkIconView* view, GtkTreePath* path);
static void _tracker_needle_icon_item_activated_gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self);
static void tracker_needle_icon_view_selection_changed (TrackerNeedle* self);
static void _tracker_needle_icon_view_selection_changed_gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self);
TrackerTagsView* tracker_tags_view_new (GList* _files);
TrackerTagsView* tracker_tags_view_construct (GType object_type, GList* _files);
void tracker_tags_view_hide_label (TrackerTagsView* self);
static gboolean tracker_needle_search_run (TrackerNeedle* self);
static gboolean _tracker_needle_search_run_gsource_func (gpointer self);
static void tracker_needle_search_finished (TrackerNeedle* self, TrackerResultStore* store);
gboolean tracker_result_store_has_results (TrackerResultStore* self);
static GtkTreeIter* tracker_needle_search_history_find_or_insert (TrackerNeedle* self, const gchar* criteria, gboolean* add_to_model);
static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self);
void tracker_history_add (TrackerHistory* self, const gchar* criteria);
void tracker_view_set_store (TrackerView* self, TrackerResultStore* value);
static GPtrArray* tracker_needle_search_tags (TrackerNeedle* self);
void tracker_result_store_set_search_tags (TrackerResultStore* self, GPtrArray* value);
GPtrArray* tracker_result_store_get_search_tags (TrackerResultStore* self);
void tracker_result_store_set_search_term (TrackerResultStore* self, const gchar* value);
void tracker_model_launch_selected (GtkTreeModel* model, GtkTreePath* path, gint col);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
void tracker_tags_view_set_files (TrackerTagsView* self, GList* _files);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda9_ (Block4Data* _data4_, GtkIconView* iconview, GtkTreePath* path);
static void ___lambda9__gtk_icon_view_foreach_func (GtkIconView* icon_view, GtkTreePath* path, gpointer self);
GType tracker_stats_get_type (void) G_GNUC_CONST;
TrackerStats* tracker_stats_new (void);
TrackerStats* tracker_stats_construct (GType object_type);
static void tracker_needle_finalize (TrackerNeedle * obj);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry options[3] = {{"version", 'V', 0, G_OPTION_ARG_NONE, &print_version, N_ ("Print version"), NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &search_criteria, N_ ("[SEARCH-CRITERIA]"), N_ ("[SEARCH-CRITERIA]")}, {NULL}};

static void tracker_needle_result_overflow (TrackerNeedle* self) {
	gchar* str = NULL;
	gchar* _tmp0_;
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 72 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = g_strdup_printf ("%s\n<small>%s</small>", _ ("Search criteria was too generic"), _ ("Only the first 500 items will be displayed"));
#line 72 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	str = _tmp0_;
#line 74 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_show_info_message (self, str, GTK_MESSAGE_INFO);
#line 71 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_free0 (str);
#line 350 "tracker-needle.c"
}


static void _tracker_needle_result_overflow_tracker_result_store_result_overflow (TrackerResultStore* _sender, gpointer self) {
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_result_overflow ((TrackerNeedle*) self);
#line 357 "tracker-needle.c"
}


static void tracker_needle_create_models (TrackerNeedle* self) {
	TrackerResultStore* _tmp0_;
	TrackerResultStore* _tmp1_;
	guint _tmp2_;
	TrackerResultStore* _tmp3_;
	TrackerResultStore* _tmp4_;
	TrackerResultStore* _tmp5_;
	TrackerResultStore* _tmp6_;
	TrackerResultStore* _tmp7_;
	TrackerResultStore* _tmp8_;
	TrackerResultStore* _tmp9_;
	TrackerResultStore* _tmp10_;
	TrackerResultStore* _tmp11_;
	TrackerResultStore* _tmp12_;
	TrackerResultStore* _tmp13_;
	guint _tmp14_;
	TrackerResultStore* _tmp15_;
	TrackerResultStore* _tmp16_;
	TrackerResultStore* _tmp17_;
	TrackerResultStore* _tmp18_;
	guint _tmp19_;
	TrackerResultStore* _tmp20_;
	TrackerResultStore* _tmp21_;
	TrackerResultStore* _tmp22_;
	TrackerResultStore* _tmp23_;
	guint _tmp24_;
	TrackerResultStore* _tmp25_;
	TrackerResultStore* _tmp26_;
	TrackerResultStore* _tmp27_;
	TrackerResultStore* _tmp28_;
	guint _tmp29_;
	TrackerResultStore* _tmp30_;
	TrackerResultStore* _tmp31_;
	TrackerResultStore* _tmp32_;
	TrackerResultStore* _tmp33_;
	TrackerResultStore* _tmp34_;
	guint _tmp35_;
	TrackerResultStore* _tmp36_;
	TrackerResultStore* _tmp37_;
	TrackerResultStore* _tmp38_;
#line 77 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 79 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = tracker_result_store_new (6);
#line 79 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->categories_model);
#line 79 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->categories_model = _tmp0_;
#line 80 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = self->priv->categories_model;
#line 80 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = self->priv->limit;
#line 80 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_set_limit (_tmp1_, _tmp2_);
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = self->priv->categories_model;
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp3_, "result-overflow", (GCallback) _tracker_needle_result_overflow_tracker_result_store_result_overflow, self);
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp4_ = self->priv->categories_model;
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp4_, TRACKER_QUERY_TYPE_APPLICATIONS, TRACKER_QUERY_MATCH_FTS, "?urn", "tracker:coalesce(nfo:softwareCmdLine(?urn), ?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "nie:comment(?urn)", "\"\"", "\"\"", NULL);
#line 91 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp5_ = self->priv->categories_model;
#line 91 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp5_, TRACKER_QUERY_TYPE_IMAGES, TRACKER_QUERY_MATCH_FTS, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "fn:string-join((nfo:height(?urn), nfo:width(?urn)), \" x \")", "nfo:fileSize(?urn)", "nie:url(?urn)", NULL);
#line 99 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp6_ = self->priv->categories_model;
#line 99 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp6_, TRACKER_QUERY_TYPE_MUSIC, TRACKER_QUERY_MATCH_FTS_INDIRECT, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "fn:string-join((?performer, ?album), \" - \")", "nfo:duration(?urn)", "nie:url(?urn)", NULL);
#line 107 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp7_ = self->priv->categories_model;
#line 107 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp7_, TRACKER_QUERY_TYPE_VIDEOS, TRACKER_QUERY_MATCH_FTS, "?urn", "nie:url(?urn)", "tracker:coalesce(fts:snippet(?urn),nie:title(?urn), nfo:fileName(?urn)" \
")", "\"\"", "nfo:duration(?urn)", "nie:url(?urn)", NULL);
#line 115 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp8_ = self->priv->categories_model;
#line 115 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp8_, TRACKER_QUERY_TYPE_DOCUMENTS, TRACKER_QUERY_MATCH_FTS_INDIRECT, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "tracker:coalesce(fts:snippet(?urn),nco:fullname(?creator), nco:fullnam" \
"e(?publisher))", "nfo:pageCount(?urn)", "nie:url(?urn)", NULL);
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp9_ = self->priv->categories_model;
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp9_, TRACKER_QUERY_TYPE_MAIL, TRACKER_QUERY_MATCH_FTS, "?urn", "nie:url(?urn)", "nmo:messageSubject(?urn)", "tracker:coalesce(fts:snippet(?urn),nco:fullname(?sender), nco:nickname" \
"(?sender), nco:emailAddress(?sender))", "nmo:receivedDate(?urn)", "fn:concat(\"To: \", tracker:coalesce(nco:fullname(?to), nco:nickname(?" \
"to), nco:emailAddress(?to)))", NULL);
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp10_ = self->priv->categories_model;
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp10_, TRACKER_QUERY_TYPE_FOLDERS, TRACKER_QUERY_MATCH_FTS, "?urn", "nie:url(?urn)", "tracker:coalesce(fts:snippet(?urn),nie:title(?urn), nfo:fileName(?urn)" \
")", "nie:url(?parent)", "nfo:fileLastModified(?urn)", "?tooltip", NULL);
#line 139 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp11_ = self->priv->categories_model;
#line 139 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp11_, TRACKER_QUERY_TYPE_BOOKMARKS, TRACKER_QUERY_MATCH_FTS, "?urn", "nie:url(?bookmark)", "nie:title(?urn)", "nie:url(?bookmark)", "nie:contentLastModified(?urn)", "nie:url(?bookmark)", NULL);
#line 149 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp12_ = tracker_result_store_new (7);
#line 149 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->files_model);
#line 149 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->files_model = _tmp12_;
#line 150 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp13_ = self->priv->files_model;
#line 150 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp14_ = self->priv->limit;
#line 150 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_set_limit (_tmp13_, _tmp14_);
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp15_ = self->priv->files_model;
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp15_, "result-overflow", (GCallback) _tracker_needle_result_overflow_tracker_result_store_result_overflow, self);
#line 152 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp16_ = self->priv->files_model;
#line 152 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp16_, TRACKER_QUERY_TYPE_ALL, TRACKER_QUERY_MATCH_FTS, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "nie:url(?urn)", "nfo:fileSize(?urn)", "nfo:fileLastModified(?urn)", "nie:url(?urn)", NULL);
#line 162 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp17_ = tracker_result_store_new (7);
#line 162 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->files_in_title_model);
#line 162 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->files_in_title_model = _tmp17_;
#line 163 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp18_ = self->priv->files_in_title_model;
#line 163 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp19_ = self->priv->limit;
#line 163 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_set_limit (_tmp18_, _tmp19_);
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp20_ = self->priv->files_in_title_model;
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp20_, "result-overflow", (GCallback) _tracker_needle_result_overflow_tracker_result_store_result_overflow, self);
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp21_ = self->priv->files_in_title_model;
#line 165 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp21_, TRACKER_QUERY_TYPE_ALL, TRACKER_QUERY_MATCH_TITLES, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "nie:url(?urn)", "nfo:fileSize(?urn)", "nfo:fileLastModified(?urn)", "nie:url(?urn)", NULL);
#line 175 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp22_ = tracker_result_store_new (7);
#line 175 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->files_in_tags_model);
#line 175 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->files_in_tags_model = _tmp22_;
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp23_ = self->priv->files_in_tags_model;
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp24_ = self->priv->limit;
#line 176 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_set_limit (_tmp23_, _tmp24_);
#line 177 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp25_ = self->priv->files_in_tags_model;
#line 177 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp25_, "result-overflow", (GCallback) _tracker_needle_result_overflow_tracker_result_store_result_overflow, self);
#line 178 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp26_ = self->priv->files_in_tags_model;
#line 178 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp26_, TRACKER_QUERY_TYPE_ALL, TRACKER_QUERY_MATCH_TAGS_ONLY, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "nie:url(?urn)", "nfo:fileSize(?urn)", "nfo:fileLastModified(?urn)", "nie:url(?urn)", NULL);
#line 189 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp27_ = tracker_result_store_new (6);
#line 189 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->images_model);
#line 189 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->images_model = _tmp27_;
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp28_ = self->priv->images_model;
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp29_ = self->priv->limit;
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_set_limit (_tmp28_, _tmp29_);
#line 191 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp30_ = self->priv->images_model;
#line 191 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp30_, "result-overflow", (GCallback) _tracker_needle_result_overflow_tracker_result_store_result_overflow, self);
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp31_ = self->priv->images_model;
#line 192 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_set_icon_size (_tmp31_, 128);
#line 193 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp32_ = self->priv->images_model;
#line 193 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp32_, TRACKER_QUERY_TYPE_IMAGES, TRACKER_QUERY_MATCH_NONE, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "nfo:fileSize(?urn)", "nfo:fileLastModified(?urn)", "nie:url(?urn)", NULL);
#line 203 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp33_ = tracker_result_store_new (6);
#line 203 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->images_in_title_model);
#line 203 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->images_in_title_model = _tmp33_;
#line 204 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp34_ = self->priv->images_in_title_model;
#line 204 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp35_ = self->priv->limit;
#line 204 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_set_limit (_tmp34_, _tmp35_);
#line 205 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp36_ = self->priv->images_in_title_model;
#line 205 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp36_, "result-overflow", (GCallback) _tracker_needle_result_overflow_tracker_result_store_result_overflow, self);
#line 206 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp37_ = self->priv->images_in_title_model;
#line 206 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_set_icon_size (_tmp37_, 128);
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp38_ = self->priv->images_in_title_model;
#line 207 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_result_store_add_query (_tmp38_, TRACKER_QUERY_TYPE_IMAGES, TRACKER_QUERY_MATCH_TITLES, "?urn", "nie:url(?urn)", "tracker:coalesce(nie:title(?urn), nfo:fileName(?urn))", "nfo:fileSize(?urn)", "nfo:fileLastModified(?urn)", "nie:url(?urn)", NULL);
#line 559 "tracker-needle.c"
}


static void __lambda8_ (TrackerNeedle* self, const gchar* key) {
	const gchar* _tmp0_;
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (key != NULL);
#line 225 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = key;
#line 225 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_debug ("tracker-needle.vala:225: tracker-needle: Key %s changed\n", _tmp0_);
#line 571 "tracker-needle.c"
}


static void ___lambda8__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	__lambda8_ ((TrackerNeedle*) self, key);
#line 578 "tracker-needle.c"
}


TrackerNeedle* tracker_needle_construct (GType object_type) {
	TrackerNeedle* self = NULL;
	TrackerHistory* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self = (TrackerNeedle*) g_type_create_instance (object_type);
#line 218 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_create_models (self);
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = tracker_history_new ();
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tracker_history_unref0 (self->priv->history);
#line 219 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->history = _tmp0_;
#line 222 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = g_settings_new ("org.freedesktop.Tracker.Needle");
#line 222 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->settings_needle);
#line 222 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->settings_needle = _tmp1_;
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = self->priv->settings_needle;
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp2_, "changed", (GCallback) ___lambda8__g_settings_changed, self);
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return self;
#line 609 "tracker-needle.c"
}


TrackerNeedle* tracker_needle_new (void) {
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return tracker_needle_construct (TRACKER_TYPE_NEEDLE);
#line 616 "tracker-needle.c"
}


void tracker_needle_show (TrackerNeedle* self) {
	GtkWindow* _tmp0_;
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 230 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_setup_ui (self);
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = self->priv->window;
#line 232 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 630 "tracker-needle.c"
}


void tracker_needle_set_search (TrackerNeedle* self, gchar** args, int args_length1) {
	gchar** _tmp0_;
	gint _tmp0__length1;
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 236 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = args;
#line 236 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0__length1 = args_length1;
#line 236 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp0_ != NULL) {
#line 645 "tracker-needle.c"
		gchar* text = NULL;
		gchar* _tmp1_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		const gchar* _tmp12_;
		GtkEntry* _tmp13_;
		const gchar* _tmp14_;
#line 237 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp1_ = g_strdup ("");
#line 237 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		text = _tmp1_;
#line 239 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp2_ = args;
#line 239 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp2__length1 = args_length1;
#line 661 "tracker-needle.c"
		{
			gchar** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
#line 239 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			s_collection = _tmp2_;
#line 239 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			s_collection_length1 = _tmp2__length1;
#line 239 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			for (s_it = 0; s_it < _tmp2__length1; s_it = s_it + 1) {
#line 673 "tracker-needle.c"
				gchar* _tmp3_;
				gchar* s = NULL;
#line 239 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp3_ = g_strdup (s_collection[s_it]);
#line 239 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				s = _tmp3_;
#line 680 "tracker-needle.c"
				{
					const gchar* _tmp4_;
					gint _tmp5_;
					gint _tmp6_;
					const gchar* _tmp9_;
					const gchar* _tmp10_;
					gchar* _tmp11_;
#line 240 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp4_ = text;
#line 240 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp5_ = strlen (_tmp4_);
#line 240 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp6_ = _tmp5_;
#line 240 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					if (_tmp6_ > 1) {
#line 696 "tracker-needle.c"
						const gchar* _tmp7_;
						gchar* _tmp8_;
#line 241 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
						_tmp7_ = text;
#line 241 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
						_tmp8_ = g_strconcat (_tmp7_, " ", NULL);
#line 241 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
						_g_free0 (text);
#line 241 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
						text = _tmp8_;
#line 707 "tracker-needle.c"
					}
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp9_ = text;
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp10_ = s;
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp11_ = g_strconcat (_tmp9_, _tmp10_, NULL);
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_g_free0 (text);
#line 243 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					text = _tmp11_;
#line 239 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_g_free0 (s);
#line 721 "tracker-needle.c"
				}
			}
		}
#line 246 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp12_ = text;
#line 246 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_debug ("tracker-needle.vala:246: Setting search criteria to: '%s'\n", _tmp12_);
#line 247 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp13_ = self->priv->search;
#line 247 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp14_ = text;
#line 247 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_entry_set_text (_tmp13_, _tmp14_);
#line 236 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (text);
#line 737 "tracker-needle.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 253 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return self ? g_object_ref (self) : NULL;
#line 745 "tracker-needle.c"
}


static void tracker_needle_store_state_changed (TrackerNeedle* self, GObject* object, GParamSpec* p) {
	TrackerResultStore* store = NULL;
	GObject* _tmp0_;
	TrackerResultStore* _tmp1_;
	TrackerResultStore* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
#line 251 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 251 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (object != NULL);
#line 251 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (p != NULL);
#line 253 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = object;
#line 253 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TRACKER_TYPE_RESULT_STORE, TrackerResultStore));
#line 253 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	store = _tmp1_;
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = store;
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = tracker_result_store_get_active (_tmp2_);
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp4_ = _tmp3_;
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp4_) {
#line 776 "tracker-needle.c"
		GtkToolItem* _tmp5_;
		GtkSpinner* _tmp6_;
#line 256 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp5_ = self->priv->spinner_shell;
#line 256 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp5_);
#line 257 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp6_ = self->priv->spinner;
#line 257 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_spinner_start (_tmp6_);
#line 787 "tracker-needle.c"
	} else {
		GtkToolItem* _tmp7_;
		GtkSpinner* _tmp8_;
#line 259 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp7_ = self->priv->spinner_shell;
#line 259 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_hide ((GtkWidget*) _tmp7_);
#line 260 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp8_ = self->priv->spinner;
#line 260 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_spinner_stop (_tmp8_);
#line 799 "tracker-needle.c"
	}
#line 251 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (store);
#line 803 "tracker-needle.c"
}


static void _tracker_needle_window_closed_gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
#line 288 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_window_closed ((TrackerNeedle*) self);
#line 810 "tracker-needle.c"
}


static gboolean _tracker_needle_window_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = tracker_needle_window_key_press_event ((TrackerNeedle*) self, _sender, event);
#line 289 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return result;
#line 819 "tracker-needle.c"
}


static void _tracker_needle_info_bar_closed_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 297 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_info_bar_closed ((TrackerNeedle*) self, _sender);
#line 826 "tracker-needle.c"
}


static void _tracker_needle_view_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self) {
#line 300 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_view_toggled ((TrackerNeedle*) self);
#line 833 "tracker-needle.c"
}


static void _tracker_needle_find_in_toggled_gtk_toggle_tool_button_toggled (GtkToggleToolButton* _sender, gpointer self) {
#line 317 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_find_in_toggled ((TrackerNeedle*) self);
#line 840 "tracker-needle.c"
}


static void _tracker_needle_search_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_search_changed ((TrackerNeedle*) self, _sender);
#line 847 "tracker-needle.c"
}


static void _tracker_needle_search_activated_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
#line 344 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_search_activated ((TrackerNeedle*) self, _sender);
#line 854 "tracker-needle.c"
}


static gboolean _tracker_needle_search_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = tracker_needle_search_key_press_event ((TrackerNeedle*) self, _sender, event);
#line 345 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return result;
#line 863 "tracker-needle.c"
}


static void _tracker_needle_show_tags_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
#line 353 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_show_tags_clicked ((TrackerNeedle*) self);
#line 870 "tracker-needle.c"
}


static void _tracker_needle_show_stats_clicked_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_show_stats_clicked ((TrackerNeedle*) self);
#line 877 "tracker-needle.c"
}


static void _tracker_needle_store_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 373 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_store_state_changed ((TrackerNeedle*) self, _sender, pspec);
#line 884 "tracker-needle.c"
}


static void _tracker_needle_view_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
#line 375 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_view_row_activated ((TrackerNeedle*) self, _sender, path, column);
#line 891 "tracker-needle.c"
}


static void _tracker_needle_view_row_selected_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
#line 377 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_view_row_selected ((TrackerNeedle*) self, _sender);
#line 898 "tracker-needle.c"
}


static void _tracker_needle_icon_item_activated_gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self) {
#line 389 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_icon_item_activated ((TrackerNeedle*) self, _sender, path);
#line 905 "tracker-needle.c"
}


static void _tracker_needle_icon_view_selection_changed_gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self) {
#line 390 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_icon_view_selection_changed ((TrackerNeedle*) self);
#line 912 "tracker-needle.c"
}


static void tracker_needle_setup_ui (TrackerNeedle* self) {
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	GtkButton* info_bar_button = NULL;
	GtkToolbar* toolbar = NULL;
	GtkPaned* paned = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GObject* _tmp8_;
	GtkWindow* _tmp9_;
	GtkWindow* _tmp10_;
	GtkWindow* _tmp11_;
	GObject* _tmp12_;
	GtkToolbar* _tmp13_;
	GtkToolbar* _tmp14_;
	GtkStyleContext* _tmp15_;
	GObject* _tmp16_;
	GtkInfoBar* _tmp17_;
	GObject* _tmp18_;
	GtkLabel* _tmp19_;
	GObject* _tmp20_;
	GtkButton* _tmp21_;
	GtkButton* _tmp22_;
	GObject* _tmp23_;
	GtkToggleToolButton* _tmp24_;
	GtkToggleToolButton* _tmp25_;
	GtkToggleToolButton* _tmp26_;
	AtkObject* _tmp27_;
	GtkToggleToolButton* _tmp28_;
	GtkWidget* _tmp29_;
	AtkObject* _tmp30_;
	GObject* _tmp31_;
	GtkToggleToolButton* _tmp32_;
	GtkToggleToolButton* _tmp33_;
	GtkToggleToolButton* _tmp34_;
	AtkObject* _tmp35_;
	GtkToggleToolButton* _tmp36_;
	GtkWidget* _tmp37_;
	AtkObject* _tmp38_;
	GObject* _tmp39_;
	GtkToggleToolButton* _tmp40_;
	GtkToggleToolButton* _tmp41_;
	GtkToggleToolButton* _tmp42_;
	AtkObject* _tmp43_;
	GtkToggleToolButton* _tmp44_;
	GtkWidget* _tmp45_;
	AtkObject* _tmp46_;
	GObject* _tmp47_;
	GtkSeparatorToolItem* _tmp48_;
	GObject* _tmp49_;
	GtkToggleToolButton* _tmp50_;
	GtkToggleToolButton* _tmp51_;
	GtkToggleToolButton* _tmp52_;
	AtkObject* _tmp53_;
	GtkToggleToolButton* _tmp54_;
	GtkWidget* _tmp55_;
	AtkObject* _tmp56_;
	GObject* _tmp57_;
	GtkToggleToolButton* _tmp58_;
	GtkToggleToolButton* _tmp59_;
	GtkToggleToolButton* _tmp60_;
	AtkObject* _tmp61_;
	GtkToggleToolButton* _tmp62_;
	GtkWidget* _tmp63_;
	AtkObject* _tmp64_;
	GObject* _tmp65_;
	GtkToggleToolButton* _tmp66_;
	GtkToggleToolButton* _tmp67_;
	GtkToggleToolButton* _tmp68_;
	AtkObject* _tmp69_;
	GtkToggleToolButton* _tmp70_;
	GtkWidget* _tmp71_;
	AtkObject* _tmp72_;
	GObject* _tmp73_;
	GtkToggleToolButton* _tmp74_;
	GtkToggleToolButton* _tmp75_;
	GtkToggleToolButton* _tmp76_;
	AtkObject* _tmp77_;
	GtkToggleToolButton* _tmp78_;
	GtkWidget* _tmp79_;
	AtkObject* _tmp80_;
	GObject* _tmp81_;
	GtkToolItem* _tmp82_;
	GtkToolItem* _tmp83_;
	AtkObject* _tmp84_;
	GObject* _tmp85_;
	GtkComboBox* _tmp86_;
	GtkComboBox* _tmp87_;
	AtkObject* _tmp88_;
	GtkComboBox* _tmp89_;
	GtkWidget* _tmp90_;
	GtkEntry* _tmp91_;
	GtkEntry* _tmp92_;
	GtkEntry* _tmp93_;
	GtkEntry* _tmp94_;
	TrackerHistory* _tmp95_;
	gint _tmp96_;
	gchar** _tmp97_;
	gchar** _tmp98_;
	gint _tmp98__length1;
	GtkSpinner* _tmp99_;
	GObject* _tmp100_;
	GtkToolItem* _tmp101_;
	GtkToolItem* _tmp102_;
	GtkSpinner* _tmp103_;
	GObject* _tmp104_;
	GtkToggleToolButton* _tmp105_;
	GtkToggleToolButton* _tmp106_;
	GtkToggleToolButton* _tmp107_;
	AtkObject* _tmp108_;
	GtkToggleToolButton* _tmp109_;
	GtkWidget* _tmp110_;
	AtkObject* _tmp111_;
	GObject* _tmp112_;
	GtkToolButton* _tmp113_;
	GtkToolButton* _tmp114_;
	GtkToolButton* _tmp115_;
	AtkObject* _tmp116_;
	GtkToolButton* _tmp117_;
	GtkWidget* _tmp118_;
	AtkObject* _tmp119_;
	GObject* _tmp120_;
	GtkBox* _tmp121_;
	GtkTreeView* treeview = NULL;
	GtkIconView* iconview = NULL;
	GtkTreeSelection* treeselection = NULL;
	TrackerViewDisplay _tmp122_;
	TrackerView* _tmp123_;
	GtkBox* _tmp124_;
	TrackerView* _tmp125_;
	TrackerViewDisplay _tmp126_;
	TrackerResultStore* _tmp127_;
	TrackerView* _tmp128_;
	TrackerView* _tmp129_;
	TrackerResultStore* _tmp130_;
	TrackerResultStore* _tmp131_;
	TrackerView* _tmp132_;
	GtkWidget* _tmp133_;
	GtkTreeView* _tmp134_;
	GtkTreeView* _tmp135_;
	GtkTreeView* _tmp136_;
	GtkTreeSelection* _tmp137_;
	GtkTreeSelection* _tmp138_;
	GtkTreeSelection* _tmp139_;
	GtkBox* _tmp140_;
	TrackerView* _tmp141_;
	TrackerViewDisplay _tmp142_;
	TrackerView* _tmp143_;
	TrackerView* _tmp144_;
	GtkWidget* _tmp145_;
	GtkTreeView* _tmp146_;
	GtkTreeView* _tmp147_;
	GtkTreeView* _tmp148_;
	GtkTreeSelection* _tmp149_;
	GtkTreeSelection* _tmp150_;
	GtkTreeSelection* _tmp151_;
	GtkBox* _tmp152_;
	TrackerView* _tmp153_;
	TrackerViewDisplay _tmp154_;
	TrackerView* _tmp155_;
	TrackerView* _tmp156_;
	GtkWidget* _tmp157_;
	GtkIconView* _tmp158_;
	GtkIconView* _tmp159_;
	GtkIconView* _tmp160_;
	GtkBox* _tmp161_;
	TrackerView* _tmp162_;
	GObject* _tmp163_;
	GtkPaned* _tmp164_;
	TrackerTagsView* _tmp165_;
	TrackerTagsView* _tmp166_;
	TrackerTagsView* _tmp167_;
	GtkPaned* _tmp168_;
	TrackerTagsView* _tmp169_;
	GtkToggleToolButton* _tmp170_;
	GtkToggleToolButton* _tmp171_;
	GtkToggleToolButton* _tmp172_;
	GSettings* _tmp173_;
	gint _tmp174_;
	gint _tmp175_;
	GError * _inner_error_ = NULL;
#line 264 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 265 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = gtk_builder_new ();
#line 265 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	builder = _tmp0_;
#line 1104 "tracker-needle.c"
	{
#line 271 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_builder_add_from_file (builder, TRACKER_UI_DIR TRACKER_NEEDLE_UI_FILE, &_inner_error_);
#line 271 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1110 "tracker-needle.c"
			goto __catch27_g_error;
		}
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* e = NULL;
		GtkMessageDialog* msg = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		GtkMessageDialog* _tmp3_;
		GtkMessageDialog* _tmp4_;
#line 270 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		e = _inner_error_;
#line 270 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_inner_error_ = NULL;
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp1_ = e;
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp2_ = _tmp1_->message;
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CANCEL, "Failed to load UI file, %s\n", _tmp2_);
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_object_ref_sink (_tmp3_);
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		msg = _tmp3_;
#line 279 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp4_ = msg;
#line 279 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_dialog_run ((GtkDialog*) _tmp4_);
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_main_quit ();
#line 270 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (msg);
#line 270 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_error_free0 (e);
#line 1147 "tracker-needle.c"
	}
	__finally27:
#line 270 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 270 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (paned);
#line 270 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (toolbar);
#line 270 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (info_bar_button);
#line 270 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (builder);
#line 270 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 270 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_clear_error (&_inner_error_);
#line 270 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		return;
#line 1166 "tracker-needle.c"
	}
#line 283 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_icon_size_lookup (GTK_ICON_SIZE_MENU, &_tmp5_, NULL);
#line 283 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->size_small = _tmp5_;
#line 284 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_icon_size_lookup (GTK_ICON_SIZE_DND, &_tmp6_, NULL);
#line 284 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->size_medium = _tmp6_;
#line 285 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_icon_size_lookup (GTK_ICON_SIZE_DIALOG, &_tmp7_, NULL);
#line 285 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->size_big = _tmp7_;
#line 287 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp8_ = gtk_builder_get_object (builder, "window_needle");
#line 287 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp8_) : NULL);
#line 287 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->window);
#line 287 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->window = _tmp9_;
#line 288 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp10_ = self->priv->window;
#line 288 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect ((GtkWidget*) _tmp10_, "destroy", (GCallback) _tracker_needle_window_closed_gtk_widget_destroy, self);
#line 289 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp11_ = self->priv->window;
#line 289 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect ((GtkWidget*) _tmp11_, "key-press-event", (GCallback) _tracker_needle_window_key_press_event_gtk_widget_key_press_event, self);
#line 291 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp12_ = gtk_builder_get_object (builder, "toolbar_main");
#line 291 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, gtk_toolbar_get_type ()) ? ((GtkToolbar*) _tmp12_) : NULL);
#line 291 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (toolbar);
#line 291 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	toolbar = _tmp13_;
#line 292 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp14_ = toolbar;
#line 292 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) _tmp14_);
#line 292 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_style_context_add_class (_tmp15_, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
#line 294 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp16_ = gtk_builder_get_object (builder, "info_bar");
#line 294 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, gtk_info_bar_get_type ()) ? ((GtkInfoBar*) _tmp16_) : NULL);
#line 294 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->info_bar);
#line 294 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->info_bar = _tmp17_;
#line 295 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp18_ = gtk_builder_get_object (builder, "info_bar_label");
#line 295 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp18_) : NULL);
#line 295 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->info_bar_label);
#line 295 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->info_bar_label = _tmp19_;
#line 296 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp20_ = gtk_builder_get_object (builder, "info_bar_button");
#line 296 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, gtk_button_get_type ()) ? ((GtkButton*) _tmp20_) : NULL);
#line 296 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (info_bar_button);
#line 296 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	info_bar_button = _tmp21_;
#line 297 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp22_ = info_bar_button;
#line 297 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp22_, "clicked", (GCallback) _tracker_needle_info_bar_closed_gtk_button_clicked, self);
#line 299 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp23_ = gtk_builder_get_object (builder, "toolbutton_view_filelist");
#line 299 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, gtk_toggle_tool_button_get_type ()) ? ((GtkToggleToolButton*) _tmp23_) : NULL);
#line 299 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->view_filelist);
#line 299 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->view_filelist = _tmp24_;
#line 300 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp25_ = self->priv->view_filelist;
#line 300 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp25_, "toggled", (GCallback) _tracker_needle_view_toggled_gtk_toggle_tool_button_toggled, self);
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp26_ = self->priv->view_filelist;
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp27_ = gtk_widget_get_accessible ((GtkWidget*) _tmp26_);
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp27_, "View File List");
#line 302 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp28_ = self->priv->view_filelist;
#line 302 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp29_ = gtk_bin_get_child ((GtkBin*) _tmp28_);
#line 302 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp30_ = gtk_widget_get_accessible (_tmp29_);
#line 302 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp30_, "View File List RadioButton");
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp31_ = gtk_builder_get_object (builder, "toolbutton_view_icons");
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, gtk_toggle_tool_button_get_type ()) ? ((GtkToggleToolButton*) _tmp31_) : NULL);
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->view_icons);
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->view_icons = _tmp32_;
#line 305 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp33_ = self->priv->view_icons;
#line 305 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp33_, "toggled", (GCallback) _tracker_needle_view_toggled_gtk_toggle_tool_button_toggled, self);
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp34_ = self->priv->view_icons;
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp35_ = gtk_widget_get_accessible ((GtkWidget*) _tmp34_);
#line 306 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp35_, "View Icons");
#line 307 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp36_ = self->priv->view_icons;
#line 307 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp37_ = gtk_bin_get_child ((GtkBin*) _tmp36_);
#line 307 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp38_ = gtk_widget_get_accessible (_tmp37_);
#line 307 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp38_, "View Icons RadioButton");
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp39_ = gtk_builder_get_object (builder, "toolbutton_view_categories");
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, gtk_toggle_tool_button_get_type ()) ? ((GtkToggleToolButton*) _tmp39_) : NULL);
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->view_categories);
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->view_categories = _tmp40_;
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp41_ = self->priv->view_categories;
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp41_, "toggled", (GCallback) _tracker_needle_view_toggled_gtk_toggle_tool_button_toggled, self);
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp42_ = self->priv->view_categories;
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp43_ = gtk_widget_get_accessible ((GtkWidget*) _tmp42_);
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp43_, "View Categories");
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp44_ = self->priv->view_categories;
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp45_ = gtk_bin_get_child ((GtkBin*) _tmp44_);
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp46_ = gtk_widget_get_accessible (_tmp45_);
#line 312 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp46_, "View Categories RadioButton");
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp47_ = gtk_builder_get_object (builder, "separator_secondary");
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp48_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, gtk_separator_tool_item_get_type ()) ? ((GtkSeparatorToolItem*) _tmp47_) : NULL);
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->separator_secondary);
#line 314 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->separator_secondary = _tmp48_;
#line 316 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp49_ = gtk_builder_get_object (builder, "toolbutton_find_in_contents");
#line 316 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp50_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp49_, gtk_toggle_tool_button_get_type ()) ? ((GtkToggleToolButton*) _tmp49_) : NULL);
#line 316 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->find_in_contents);
#line 316 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->find_in_contents = _tmp50_;
#line 317 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp51_ = self->priv->find_in_contents;
#line 317 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp51_, "toggled", (GCallback) _tracker_needle_find_in_toggled_gtk_toggle_tool_button_toggled, self);
#line 318 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp52_ = self->priv->find_in_contents;
#line 318 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp53_ = gtk_widget_get_accessible ((GtkWidget*) _tmp52_);
#line 318 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp53_, "Find in Contents");
#line 319 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp54_ = self->priv->find_in_contents;
#line 319 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp55_ = gtk_bin_get_child ((GtkBin*) _tmp54_);
#line 319 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp56_ = gtk_widget_get_accessible (_tmp55_);
#line 319 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp56_, "Find in Contents");
#line 321 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp57_ = gtk_builder_get_object (builder, "toolbutton_find_in_titles");
#line 321 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp58_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp57_, gtk_toggle_tool_button_get_type ()) ? ((GtkToggleToolButton*) _tmp57_) : NULL);
#line 321 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->find_in_titles);
#line 321 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->find_in_titles = _tmp58_;
#line 322 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp59_ = self->priv->find_in_titles;
#line 322 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp59_, "toggled", (GCallback) _tracker_needle_find_in_toggled_gtk_toggle_tool_button_toggled, self);
#line 323 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp60_ = self->priv->find_in_titles;
#line 323 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp61_ = gtk_widget_get_accessible ((GtkWidget*) _tmp60_);
#line 323 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp61_, "Find in Titles");
#line 324 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp62_ = self->priv->find_in_titles;
#line 324 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp63_ = gtk_bin_get_child ((GtkBin*) _tmp62_);
#line 324 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp64_ = gtk_widget_get_accessible (_tmp63_);
#line 324 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp64_, "Find in Titles");
#line 326 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp65_ = gtk_builder_get_object (builder, "toolbutton_find_in_tags");
#line 326 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp65_, gtk_toggle_tool_button_get_type ()) ? ((GtkToggleToolButton*) _tmp65_) : NULL);
#line 326 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->find_in_tags);
#line 326 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->find_in_tags = _tmp66_;
#line 327 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp67_ = self->priv->find_in_tags;
#line 327 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp67_, "toggled", (GCallback) _tracker_needle_find_in_toggled_gtk_toggle_tool_button_toggled, self);
#line 328 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp68_ = self->priv->find_in_tags;
#line 328 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp69_ = gtk_widget_get_accessible ((GtkWidget*) _tmp68_);
#line 328 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp69_, "Find in Tags");
#line 329 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp70_ = self->priv->find_in_tags;
#line 329 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp71_ = gtk_bin_get_child ((GtkBin*) _tmp70_);
#line 329 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp72_ = gtk_widget_get_accessible (_tmp71_);
#line 329 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp72_, "Find in Tags");
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp73_ = gtk_builder_get_object (builder, "toolbutton_find_in_all");
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp74_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp73_, gtk_toggle_tool_button_get_type ()) ? ((GtkToggleToolButton*) _tmp73_) : NULL);
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->find_in_all);
#line 331 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->find_in_all = _tmp74_;
#line 332 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp75_ = self->priv->find_in_all;
#line 332 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp75_, "toggled", (GCallback) _tracker_needle_find_in_toggled_gtk_toggle_tool_button_toggled, self);
#line 333 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp76_ = self->priv->find_in_all;
#line 333 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp77_ = gtk_widget_get_accessible ((GtkWidget*) _tmp76_);
#line 333 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp77_, "Find in All");
#line 334 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp78_ = self->priv->find_in_all;
#line 334 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp79_ = gtk_bin_get_child ((GtkBin*) _tmp78_);
#line 334 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp80_ = gtk_widget_get_accessible (_tmp79_);
#line 334 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp80_, "Find in All");
#line 336 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp81_ = gtk_builder_get_object (builder, "toolitem_search_entry");
#line 336 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp82_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp81_, gtk_tool_item_get_type ()) ? ((GtkToolItem*) _tmp81_) : NULL);
#line 336 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->search_entry);
#line 336 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->search_entry = _tmp82_;
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp83_ = self->priv->search_entry;
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp84_ = gtk_widget_get_accessible ((GtkWidget*) _tmp83_);
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp84_, "Search Entry");
#line 339 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp85_ = gtk_builder_get_object (builder, "combobox_search");
#line 339 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp86_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp85_, gtk_combo_box_get_type ()) ? ((GtkComboBox*) _tmp85_) : NULL);
#line 339 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->search_list);
#line 339 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->search_list = _tmp86_;
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp87_ = self->priv->search_list;
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp88_ = gtk_widget_get_accessible ((GtkWidget*) _tmp87_);
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp88_, "Search List");
#line 342 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp89_ = self->priv->search_list;
#line 342 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp90_ = gtk_bin_get_child ((GtkBin*) _tmp89_);
#line 342 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp91_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp90_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp90_) : NULL);
#line 342 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->search);
#line 342 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->search = _tmp91_;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp92_ = self->priv->search;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect ((GtkEditable*) _tmp92_, "changed", (GCallback) _tracker_needle_search_changed_gtk_editable_changed, self);
#line 344 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp93_ = self->priv->search;
#line 344 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp93_, "activate", (GCallback) _tracker_needle_search_activated_gtk_entry_activate, self);
#line 345 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp94_ = self->priv->search;
#line 345 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect ((GtkWidget*) _tmp94_, "key-press-event", (GCallback) _tracker_needle_search_key_press_event_gtk_widget_key_press_event, self);
#line 346 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp95_ = self->priv->history;
#line 346 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp97_ = tracker_history_get (_tmp95_, &_tmp96_);
#line 346 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp98_ = _tmp97_;
#line 346 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp98__length1 = _tmp96_;
#line 346 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_search_history_insert (self, _tmp98_, _tmp96_);
#line 346 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp98_ = (_vala_array_free (_tmp98_, _tmp98__length1, (GDestroyNotify) g_free), NULL);
#line 348 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp99_ = (GtkSpinner*) gtk_spinner_new ();
#line 348 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_object_ref_sink (_tmp99_);
#line 348 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->spinner);
#line 348 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->spinner = _tmp99_;
#line 349 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp100_ = gtk_builder_get_object (builder, "toolcustom_spinner");
#line 349 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp101_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp100_, gtk_tool_item_get_type ()) ? ((GtkToolItem*) _tmp100_) : NULL);
#line 349 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->spinner_shell);
#line 349 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->spinner_shell = _tmp101_;
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp102_ = self->priv->spinner_shell;
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp103_ = self->priv->spinner;
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_container_add ((GtkContainer*) _tmp102_, (GtkWidget*) _tmp103_);
#line 352 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp104_ = gtk_builder_get_object (builder, "toolbutton_show_tags");
#line 352 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp105_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp104_, gtk_toggle_tool_button_get_type ()) ? ((GtkToggleToolButton*) _tmp104_) : NULL);
#line 352 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->show_tags);
#line 352 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->show_tags = _tmp105_;
#line 353 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp106_ = self->priv->show_tags;
#line 353 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect ((GtkToolButton*) _tmp106_, "clicked", (GCallback) _tracker_needle_show_tags_clicked_gtk_tool_button_clicked, self);
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp107_ = self->priv->show_tags;
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp108_ = gtk_widget_get_accessible ((GtkWidget*) _tmp107_);
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp108_, "Show Tags");
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp109_ = self->priv->show_tags;
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp110_ = gtk_bin_get_child ((GtkBin*) _tmp109_);
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp111_ = gtk_widget_get_accessible (_tmp110_);
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp111_, "Show Tags");
#line 357 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp112_ = gtk_builder_get_object (builder, "toolbutton_show_stats");
#line 357 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp113_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp112_, gtk_tool_button_get_type ()) ? ((GtkToolButton*) _tmp112_) : NULL);
#line 357 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->show_stats);
#line 357 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->show_stats = _tmp113_;
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp114_ = self->priv->show_stats;
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp114_, "clicked", (GCallback) _tracker_needle_show_stats_clicked_gtk_tool_button_clicked, self);
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp115_ = self->priv->show_stats;
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp116_ = gtk_widget_get_accessible ((GtkWidget*) _tmp115_);
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp116_, "Show Stats");
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp117_ = self->priv->show_stats;
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp118_ = gtk_bin_get_child ((GtkBin*) _tmp117_);
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp119_ = gtk_widget_get_accessible (_tmp118_);
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	atk_object_set_name (_tmp119_, "Show Stats");
#line 362 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp120_ = gtk_builder_get_object (builder, "hbox_view");
#line 362 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp121_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp120_, gtk_box_get_type ()) ? ((GtkBox*) _tmp120_) : NULL);
#line 362 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->view);
#line 362 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->view = _tmp121_;
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp122_ = TRACKER_VIEW_DISPLAY_NO_RESULTS;
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp123_ = tracker_view_new (&_tmp122_, NULL);
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_object_ref_sink (_tmp123_);
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->sw_noresults);
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->sw_noresults = _tmp123_;
#line 370 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp124_ = self->priv->view;
#line 370 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp125_ = self->priv->sw_noresults;
#line 370 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_box_pack_start (_tmp124_, (GtkWidget*) _tmp125_, TRUE, TRUE, (guint) 0);
#line 372 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp126_ = TRACKER_VIEW_DISPLAY_CATEGORIES;
#line 372 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp127_ = self->priv->categories_model;
#line 372 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp128_ = tracker_view_new (&_tmp126_, _tmp127_);
#line 372 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_object_ref_sink (_tmp128_);
#line 372 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->sw_categories);
#line 372 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->sw_categories = _tmp128_;
#line 373 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp129_ = self->priv->sw_categories;
#line 373 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp130_ = tracker_view_get_store (_tmp129_);
#line 373 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp131_ = _tmp130_;
#line 373 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect ((GObject*) _tmp131_, "notify::active", (GCallback) _tracker_needle_store_state_changed_g_object_notify, self);
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp132_ = self->priv->sw_categories;
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp133_ = gtk_bin_get_child ((GtkBin*) _tmp132_);
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp134_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp133_, gtk_tree_view_get_type (), GtkTreeView));
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (treeview);
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	treeview = _tmp134_;
#line 375 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp135_ = treeview;
#line 375 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp135_, "row-activated", (GCallback) _tracker_needle_view_row_activated_gtk_tree_view_row_activated, self);
#line 376 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp136_ = treeview;
#line 376 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp137_ = gtk_tree_view_get_selection (_tmp136_);
#line 376 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp138_ = _g_object_ref0 (_tmp137_);
#line 376 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (treeselection);
#line 376 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	treeselection = _tmp138_;
#line 377 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp139_ = treeselection;
#line 377 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp139_, "changed", (GCallback) _tracker_needle_view_row_selected_gtk_tree_selection_changed, self);
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp140_ = self->priv->view;
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp141_ = self->priv->sw_categories;
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_box_pack_start (_tmp140_, (GtkWidget*) _tmp141_, TRUE, TRUE, (guint) 0);
#line 380 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp142_ = TRACKER_VIEW_DISPLAY_FILE_LIST;
#line 380 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp143_ = tracker_view_new (&_tmp142_, NULL);
#line 380 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_object_ref_sink (_tmp143_);
#line 380 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->sw_filelist);
#line 380 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->sw_filelist = _tmp143_;
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp144_ = self->priv->sw_filelist;
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp145_ = gtk_bin_get_child ((GtkBin*) _tmp144_);
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp146_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, gtk_tree_view_get_type (), GtkTreeView));
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (treeview);
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	treeview = _tmp146_;
#line 382 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp147_ = treeview;
#line 382 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp147_, "row-activated", (GCallback) _tracker_needle_view_row_activated_gtk_tree_view_row_activated, self);
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp148_ = treeview;
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp149_ = gtk_tree_view_get_selection (_tmp148_);
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp150_ = _g_object_ref0 (_tmp149_);
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (treeselection);
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	treeselection = _tmp150_;
#line 384 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp151_ = treeselection;
#line 384 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp151_, "changed", (GCallback) _tracker_needle_view_row_selected_gtk_tree_selection_changed, self);
#line 385 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp152_ = self->priv->view;
#line 385 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp153_ = self->priv->sw_filelist;
#line 385 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_box_pack_start (_tmp152_, (GtkWidget*) _tmp153_, TRUE, TRUE, (guint) 0);
#line 387 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp154_ = TRACKER_VIEW_DISPLAY_FILE_ICONS;
#line 387 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp155_ = tracker_view_new (&_tmp154_, NULL);
#line 387 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_object_ref_sink (_tmp155_);
#line 387 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->sw_icons);
#line 387 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->sw_icons = _tmp155_;
#line 388 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp156_ = self->priv->sw_icons;
#line 388 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp157_ = gtk_bin_get_child ((GtkBin*) _tmp156_);
#line 388 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp158_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp157_, gtk_icon_view_get_type (), GtkIconView));
#line 388 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (iconview);
#line 388 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	iconview = _tmp158_;
#line 389 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp159_ = iconview;
#line 389 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp159_, "item-activated", (GCallback) _tracker_needle_icon_item_activated_gtk_icon_view_item_activated, self);
#line 390 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp160_ = iconview;
#line 390 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_connect (_tmp160_, "selection-changed", (GCallback) _tracker_needle_icon_view_selection_changed_gtk_icon_view_selection_changed, self);
#line 391 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp161_ = self->priv->view;
#line 391 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp162_ = self->priv->sw_icons;
#line 391 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_box_pack_start (_tmp161_, (GtkWidget*) _tmp162_, TRUE, TRUE, (guint) 0);
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp163_ = gtk_builder_get_object (builder, "hpaned");
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp164_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp163_, gtk_paned_get_type ()) ? ((GtkPaned*) _tmp163_) : NULL);
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (paned);
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	paned = _tmp164_;
#line 395 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp165_ = tracker_tags_view_new (NULL);
#line 395 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_object_ref_sink (_tmp165_);
#line 395 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->tags_view);
#line 395 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->tags_view = _tmp165_;
#line 396 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp166_ = self->priv->tags_view;
#line 396 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_hide ((GtkWidget*) _tmp166_);
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp167_ = self->priv->tags_view;
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_tags_view_hide_label (_tmp167_);
#line 398 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp168_ = paned;
#line 398 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp169_ = self->priv->tags_view;
#line 398 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_paned_pack2 (_tmp168_, (GtkWidget*) _tmp169_, FALSE, FALSE);
#line 401 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp170_ = self->priv->view_categories;
#line 401 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_toggle_tool_button_set_active (_tmp170_, FALSE);
#line 402 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp171_ = self->priv->view_icons;
#line 402 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_toggle_tool_button_set_active (_tmp171_, FALSE);
#line 403 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp172_ = self->priv->view_filelist;
#line 403 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_toggle_tool_button_set_active (_tmp172_, FALSE);
#line 406 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp173_ = self->priv->settings_needle;
#line 406 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp174_ = g_settings_get_int (_tmp173_, "default-view");
#line 406 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->default_view = _tmp174_;
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp175_ = self->priv->default_view;
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp175_ == 0) {
#line 1772 "tracker-needle.c"
		GtkToggleToolButton* _tmp176_;
#line 409 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp176_ = self->priv->view_icons;
#line 409 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_toggle_tool_button_set_active (_tmp176_, TRUE);
#line 1778 "tracker-needle.c"
	} else {
		gint _tmp177_;
#line 410 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp177_ = self->priv->default_view;
#line 410 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp177_ == 2) {
#line 1785 "tracker-needle.c"
			GtkToggleToolButton* _tmp178_;
#line 411 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp178_ = self->priv->view_filelist;
#line 411 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			gtk_toggle_tool_button_set_active (_tmp178_, TRUE);
#line 1791 "tracker-needle.c"
		} else {
			GtkToggleToolButton* _tmp179_;
#line 413 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp179_ = self->priv->view_categories;
#line 413 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			gtk_toggle_tool_button_set_active (_tmp179_, TRUE);
#line 1798 "tracker-needle.c"
		}
	}
#line 264 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (treeselection);
#line 264 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (iconview);
#line 264 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (treeview);
#line 264 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (paned);
#line 264 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (toolbar);
#line 264 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (info_bar_button);
#line 264 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (builder);
#line 1815 "tracker-needle.c"
}


static gboolean tracker_needle_window_key_press_event (TrackerNeedle* self, GtkWidget* widget, GdkEventKey* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey* _tmp1_;
	GdkModifierType _tmp2_;
#line 417 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 417 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 417 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 419 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = event;
#line 419 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = _tmp1_->state;
#line 419 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if ((_tmp2_ & GDK_CONTROL_MASK) == GDK_CONTROL_MASK) {
#line 1836 "tracker-needle.c"
		GdkEventKey* _tmp3_;
		guint _tmp4_;
		const gchar* _tmp5_;
#line 419 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp3_ = event;
#line 419 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp4_ = _tmp3_->keyval;
#line 419 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp5_ = gdk_keyval_name (_tmp4_);
#line 419 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp0_ = g_strcmp0 (_tmp5_, "w") == 0;
#line 1848 "tracker-needle.c"
	} else {
#line 419 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp0_ = FALSE;
#line 1852 "tracker-needle.c"
	}
#line 419 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp0_) {
#line 1856 "tracker-needle.c"
		GtkWidget* _tmp6_;
#line 420 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp6_ = widget;
#line 420 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_destroy (_tmp6_);
#line 1862 "tracker-needle.c"
	}
#line 423 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	result = FALSE;
#line 423 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return result;
#line 1868 "tracker-needle.c"
}


static gboolean tracker_needle_search_key_press_event (TrackerNeedle* self, GtkWidget* widget, GdkEventKey* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey* _tmp1_;
	guint _tmp2_;
	const gchar* _tmp3_;
#line 426 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 426 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 426 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = event;
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = _tmp1_->keyval;
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = gdk_keyval_name (_tmp2_);
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (g_strcmp0 (_tmp3_, "Down") == 0) {
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp0_ = TRUE;
#line 1894 "tracker-needle.c"
	} else {
		GdkEventKey* _tmp4_;
		guint _tmp5_;
		const gchar* _tmp6_;
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp4_ = event;
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp5_ = _tmp4_->keyval;
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp6_ = gdk_keyval_name (_tmp5_);
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp0_ = g_strcmp0 (_tmp6_, "KP_Down") == 0;
#line 1907 "tracker-needle.c"
	}
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp0_) {
#line 1911 "tracker-needle.c"
		GtkWidget* child = NULL;
		GtkWidget* _tmp7_;
		GtkWidget* _tmp8_;
		GtkWidget* _tmp9_;
		GtkWidget* _tmp10_;
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp7_ = self->priv->current_view;
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp8_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_scrolled_window_get_type (), GtkScrolledWindow));
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		child = _tmp9_;
#line 431 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp10_ = child;
#line 431 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp10_ != NULL) {
#line 1929 "tracker-needle.c"
			GtkWidget* _tmp11_;
#line 432 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp11_ = child;
#line 432 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			gtk_widget_grab_focus (_tmp11_);
#line 1935 "tracker-needle.c"
		}
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (child);
#line 1939 "tracker-needle.c"
	}
#line 436 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	result = FALSE;
#line 436 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return result;
#line 1945 "tracker-needle.c"
}


static gboolean _tracker_needle_search_run_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_needle_search_run ((TrackerNeedle*) self);
#line 444 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return result;
#line 1954 "tracker-needle.c"
}


static void tracker_needle_search_changed (TrackerNeedle* self, GtkEditable* editable) {
	guint _tmp0_;
	guint _tmp2_;
#line 439 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 439 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (editable != NULL);
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = self->priv->last_search_id;
#line 440 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 1969 "tracker-needle.c"
		guint _tmp1_;
#line 441 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp1_ = self->priv->last_search_id;
#line 441 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_source_remove (_tmp1_);
#line 1975 "tracker-needle.c"
	}
#line 444 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _tracker_needle_search_run_gsource_func, tracker_needle_ref (self), tracker_needle_unref);
#line 444 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->last_search_id = _tmp2_;
#line 1981 "tracker-needle.c"
}


static void tracker_needle_search_activated (TrackerNeedle* self, GtkEntry* entry) {
	guint _tmp0_;
#line 447 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 447 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (entry != NULL);
#line 448 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = self->priv->last_search_id;
#line 448 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 1995 "tracker-needle.c"
		guint _tmp1_;
#line 449 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp1_ = self->priv->last_search_id;
#line 449 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_source_remove (_tmp1_);
#line 450 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		self->priv->last_search_id = (guint) 0;
#line 2003 "tracker-needle.c"
	}
#line 453 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_search_run (self);
#line 2007 "tracker-needle.c"
}


static void tracker_needle_search_finished (TrackerNeedle* self, TrackerResultStore* store) {
	gboolean _tmp0_ = FALSE;
	TrackerResultStore* _tmp1_;
#line 456 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 458 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = store;
#line 458 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp1_ == NULL) {
#line 458 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp0_ = TRUE;
#line 2022 "tracker-needle.c"
	} else {
		TrackerResultStore* _tmp2_;
		gboolean _tmp3_;
#line 458 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp2_ = store;
#line 458 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp3_ = tracker_result_store_has_results (_tmp2_);
#line 458 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp0_ = !_tmp3_;
#line 2032 "tracker-needle.c"
	}
#line 458 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp0_) {
#line 2036 "tracker-needle.c"
		TrackerView* _tmp4_;
		TrackerView* _tmp5_;
		TrackerView* _tmp6_;
		TrackerView* _tmp7_;
#line 459 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp4_ = self->priv->sw_noresults;
#line 459 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_show ((GtkWidget*) _tmp4_);
#line 460 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp5_ = self->priv->sw_icons;
#line 460 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_hide ((GtkWidget*) _tmp5_);
#line 461 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp6_ = self->priv->sw_categories;
#line 461 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_hide ((GtkWidget*) _tmp6_);
#line 462 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp7_ = self->priv->sw_filelist;
#line 462 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_hide ((GtkWidget*) _tmp7_);
#line 2057 "tracker-needle.c"
	}
}


static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self) {
	GtkTreeIter* dup;
#line 486 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	dup = g_new0 (GtkTreeIter, 1);
#line 486 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	memcpy (dup, self, sizeof (GtkTreeIter));
#line 486 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return dup;
#line 2070 "tracker-needle.c"
}


static gpointer __gtk_tree_iter_dup0 (gpointer self) {
#line 486 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return self ? _gtk_tree_iter_dup (self) : NULL;
#line 2077 "tracker-needle.c"
}


static GtkTreeIter* tracker_needle_search_history_find_or_insert (TrackerNeedle* self, const gchar* criteria, gboolean* add_to_model) {
	GtkTreeIter* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GtkComboBox* combo = NULL;
	GtkComboBox* _tmp3_;
	GtkComboBox* _tmp4_;
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp5_;
	GtkTreeModel* _tmp6_;
	GtkTreeModel* _tmp7_;
	gchar* criteria_folded = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GtkTreeIter iter = {0};
	gboolean valid = FALSE;
	GtkTreeModel* _tmp10_;
	GtkTreeIter _tmp11_ = {0};
	gboolean _tmp12_;
	gboolean* _tmp23_;
#line 466 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 466 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (criteria != NULL, NULL);
#line 467 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = criteria;
#line 467 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = strlen (_tmp0_);
#line 467 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = _tmp1_;
#line 467 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp2_ < 1) {
#line 468 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		result = NULL;
#line 468 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		return result;
#line 2118 "tracker-needle.c"
	}
#line 471 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = self->priv->search_list;
#line 471 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_combo_box_get_type ()) ? ((GtkComboBox*) _tmp3_) : NULL);
#line 471 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	combo = _tmp4_;
#line 472 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp5_ = combo;
#line 472 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp6_ = gtk_combo_box_get_model (_tmp5_);
#line 472 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 472 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	model = _tmp7_;
#line 473 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp8_ = criteria;
#line 473 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp9_ = g_utf8_casefold (_tmp8_, (gssize) -1);
#line 473 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	criteria_folded = _tmp9_;
#line 476 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp10_ = model;
#line 476 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp12_ = gtk_tree_model_iter_children (_tmp10_, &_tmp11_, NULL);
#line 476 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	iter = _tmp11_;
#line 476 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	valid = _tmp12_;
#line 478 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	while (TRUE) {
#line 2150 "tracker-needle.c"
		gboolean _tmp13_;
		gchar* text = NULL;
		GtkTreeModel* _tmp14_;
		GtkTreeIter _tmp15_;
		gchar* text_folded = NULL;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		GtkTreeModel* _tmp21_;
		gboolean _tmp22_;
#line 478 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp13_ = valid;
#line 478 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (!_tmp13_) {
#line 478 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			break;
#line 2168 "tracker-needle.c"
		}
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp14_ = model;
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp15_ = iter;
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_tree_model_get (_tmp14_, &_tmp15_, 0, &text, -1, -1);
#line 483 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp16_ = text;
#line 483 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp17_ = g_utf8_casefold (_tmp16_, (gssize) -1);
#line 483 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		text_folded = _tmp17_;
#line 485 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp18_ = text_folded;
#line 485 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp19_ = criteria_folded;
#line 485 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (g_strcmp0 (_tmp18_, _tmp19_) == 0) {
#line 2188 "tracker-needle.c"
			GtkTreeIter* _tmp20_;
#line 486 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp20_ = __gtk_tree_iter_dup0 (&iter);
#line 486 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			result = _tmp20_;
#line 486 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_free0 (text_folded);
#line 486 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_free0 (text);
#line 486 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_free0 (criteria_folded);
#line 486 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_object_unref0 (model);
#line 486 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_object_unref0 (combo);
#line 486 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			return result;
#line 2206 "tracker-needle.c"
		}
#line 489 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp21_ = model;
#line 489 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp22_ = gtk_tree_model_iter_next (_tmp21_, &iter);
#line 489 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		valid = _tmp22_;
#line 478 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (text_folded);
#line 478 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (text);
#line 2218 "tracker-needle.c"
	}
#line 492 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp23_ = add_to_model;
#line 492 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (*_tmp23_) {
#line 2224 "tracker-needle.c"
		GtkTreeIter new_iter = {0};
		GtkListStore* store = NULL;
		GtkTreeModel* _tmp24_;
		GtkListStore* _tmp25_;
		GtkListStore* _tmp26_;
		GtkTreeIter _tmp27_ = {0};
		GtkListStore* _tmp28_;
		GtkTreeIter _tmp29_;
		const gchar* _tmp30_;
		TrackerHistory* _tmp31_;
		const gchar* _tmp32_;
#line 495 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp24_ = model;
#line 495 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_list_store_get_type (), GtkListStore));
#line 495 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		store = _tmp25_;
#line 496 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp26_ = store;
#line 496 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_list_store_prepend (_tmp26_, &_tmp27_);
#line 496 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		new_iter = _tmp27_;
#line 497 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp28_ = store;
#line 497 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp29_ = new_iter;
#line 497 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp30_ = criteria;
#line 497 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_list_store_set (_tmp28_, &_tmp29_, 0, _tmp30_, -1, -1);
#line 499 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp31_ = self->priv->history;
#line 499 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp32_ = criteria;
#line 499 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tracker_history_add (_tmp31_, _tmp32_);
#line 492 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (store);
#line 2264 "tracker-needle.c"
	}
#line 502 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	result = NULL;
#line 502 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_free0 (criteria_folded);
#line 502 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (model);
#line 502 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (combo);
#line 502 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return result;
#line 2276 "tracker-needle.c"
}


static void tracker_needle_search_history_insert (TrackerNeedle* self, gchar** history, int history_length1) {
	gchar** _tmp0_;
	gint _tmp0__length1;
#line 505 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 506 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = history;
#line 506 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0__length1 = history_length1;
#line 2289 "tracker-needle.c"
	{
		gchar** criteria_collection = NULL;
		gint criteria_collection_length1 = 0;
		gint _criteria_collection_size_ = 0;
		gint criteria_it = 0;
#line 506 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		criteria_collection = _tmp0_;
#line 506 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		criteria_collection_length1 = _tmp0__length1;
#line 506 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		for (criteria_it = 0; criteria_it < _tmp0__length1; criteria_it = criteria_it + 1) {
#line 2301 "tracker-needle.c"
			gchar* _tmp1_;
			gchar* criteria = NULL;
#line 506 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp1_ = g_strdup (criteria_collection[criteria_it]);
#line 506 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			criteria = _tmp1_;
#line 2308 "tracker-needle.c"
			{
				const gchar* _tmp2_;
				gboolean _tmp3_;
				GtkTreeIter* _tmp4_;
				GtkTreeIter* _tmp5_;
#line 507 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp2_ = criteria;
#line 507 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp3_ = TRUE;
#line 507 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp4_ = tracker_needle_search_history_find_or_insert (self, _tmp2_, &_tmp3_);
#line 507 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp5_ = _tmp4_;
#line 507 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_g_free0 (_tmp5_);
#line 506 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_g_free0 (criteria);
#line 2326 "tracker-needle.c"
			}
		}
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
#line 1234 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1235 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1235 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1236 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1236 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1237 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _result_;
#line 1237 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 2352 "tracker-needle.c"
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_;
	gint _tmp3__length1;
#line 1078 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = separator;
#line 1078 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp0_ == NULL) {
#line 1079 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		separator = "";
#line 2369 "tracker-needle.c"
	}
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = str_array;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3__length1 = str_array_length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp2_ = TRUE;
#line 2379 "tracker-needle.c"
	} else {
		gchar** _tmp4_;
		gint _tmp4__length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = str_array;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4__length1 = str_array_length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp4__length1 > 0;
#line 2389 "tracker-needle.c"
	}
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp2_) {
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 2395 "tracker-needle.c"
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_;
		gint _tmp6__length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = str_array;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6__length1 = str_array_length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		if (_tmp6__length1 == -1) {
#line 2406 "tracker-needle.c"
			gchar** _tmp7_;
			gint _tmp7__length1;
			const gchar* _tmp8_;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp7_ = str_array;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp7__length1 = str_array_length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp8_ = _tmp7_[0];
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp5_ = _tmp8_ != NULL;
#line 2418 "tracker-needle.c"
		} else {
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp5_ = FALSE;
#line 2422 "tracker-needle.c"
		}
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp1_ = _tmp5_;
#line 2426 "tracker-needle.c"
	}
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 2430 "tracker-needle.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_;
		gint _tmp33_;
		gint _tmp34_;
		gsize _tmp35_;
		const gchar* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		const gchar* res = NULL;
		gsize _tmp40_;
		void* _tmp41_;
		void* ptr = NULL;
		const gchar* _tmp42_;
		gchar** _tmp43_;
		gint _tmp43__length1;
		const gchar* _tmp44_;
		void* _tmp45_;
		const gchar* _tmp62_;
#line 1083 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		len = (gsize) 1;
#line 2453 "tracker-needle.c"
		{
			gboolean _tmp9_ = FALSE;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			i = 0;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp9_ = TRUE;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 2462 "tracker-needle.c"
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gint _tmp21_ = 0;
				gchar** _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				const gchar* _tmp24_;
				gsize _tmp30_;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (!_tmp9_) {
#line 2475 "tracker-needle.c"
					gint _tmp10_;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp10_ = i;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					i = _tmp10_ + 1;
#line 2481 "tracker-needle.c"
				}
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp9_ = FALSE;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp13_ = str_array;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp13__length1 = str_array_length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (_tmp13__length1 != -1) {
#line 2491 "tracker-needle.c"
					gint _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp14_ = i;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp15_ = str_array;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp15__length1 = str_array_length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp12_ = _tmp14_ < _tmp15__length1;
#line 2503 "tracker-needle.c"
				} else {
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp12_ = FALSE;
#line 2507 "tracker-needle.c"
				}
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (_tmp12_) {
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp11_ = TRUE;
#line 2513 "tracker-needle.c"
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_;
					gint _tmp17__length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp17_ = str_array;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp17__length1 = str_array_length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					if (_tmp17__length1 == -1) {
#line 2524 "tracker-needle.c"
						gchar** _tmp18_;
						gint _tmp18__length1;
						gint _tmp19_;
						const gchar* _tmp20_;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp18_ = str_array;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp18__length1 = str_array_length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp19_ = i;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp20_ = _tmp18_[_tmp19_];
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp16_ = _tmp20_ != NULL;
#line 2539 "tracker-needle.c"
					} else {
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp16_ = FALSE;
#line 2543 "tracker-needle.c"
					}
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp11_ = _tmp16_;
#line 2547 "tracker-needle.c"
				}
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (!_tmp11_) {
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					break;
#line 2553 "tracker-needle.c"
				}
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp22_ = str_array;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp22__length1 = str_array_length1;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp23_ = i;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp24_ = _tmp22_[_tmp23_];
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (_tmp24_ != NULL) {
#line 2565 "tracker-needle.c"
					gchar** _tmp25_;
					gint _tmp25__length1;
					gint _tmp26_;
					const gchar* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp25_ = str_array;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp25__length1 = str_array_length1;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp26_ = i;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp27_ = _tmp25_[_tmp26_];
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp28_ = strlen ((const gchar*) _tmp27_);
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp29_ = _tmp28_;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp21_ = _tmp29_;
#line 2586 "tracker-needle.c"
				} else {
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp21_ = 0;
#line 2590 "tracker-needle.c"
				}
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp30_ = len;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				len = _tmp30_ + _tmp21_;
#line 2596 "tracker-needle.c"
			}
		}
#line 1087 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp31_ = i;
#line 1087 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		if (_tmp31_ == 0) {
#line 2603 "tracker-needle.c"
			gchar* _tmp32_;
#line 1088 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp32_ = g_strdup ("");
#line 1088 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			result = _tmp32_;
#line 1088 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			return result;
#line 2611 "tracker-needle.c"
		}
#line 1090 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp33_ = i;
#line 1090 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		str_array_length1 = _tmp33_;
#line 1090 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp34_ = str_array_length1;
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp35_ = len;
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp36_ = separator;
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp37_ = strlen ((const gchar*) _tmp36_);
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp38_ = _tmp37_;
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp39_ = i;
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
#line 1093 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp40_ = len;
#line 1093 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp41_ = g_malloc (_tmp40_);
#line 1093 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		res = _tmp41_;
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp42_ = res;
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp43_ = str_array;
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp43__length1 = str_array_length1;
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp44_ = _tmp43_[0];
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		ptr = _tmp45_;
#line 2649 "tracker-needle.c"
		{
			gboolean _tmp46_ = FALSE;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			i = 1;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp46_ = TRUE;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 2658 "tracker-needle.c"
				gint _tmp48_;
				gchar** _tmp49_;
				gint _tmp49__length1;
				void* _tmp50_;
				const gchar* _tmp51_;
				void* _tmp52_;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_;
				gint _tmp54__length1;
				gint _tmp55_;
				const gchar* _tmp56_;
				void* _tmp60_;
				void* _tmp61_;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (!_tmp46_) {
#line 2674 "tracker-needle.c"
					gint _tmp47_;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp47_ = i;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					i = _tmp47_ + 1;
#line 2680 "tracker-needle.c"
				}
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp46_ = FALSE;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp48_ = i;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp49_ = str_array;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp49__length1 = str_array_length1;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (!(_tmp48_ < _tmp49__length1)) {
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					break;
#line 2694 "tracker-needle.c"
				}
#line 1096 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp50_ = ptr;
#line 1096 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp51_ = separator;
#line 1096 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
#line 1096 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				ptr = _tmp52_;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp54_ = str_array;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp54__length1 = str_array_length1;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp55_ = i;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp56_ = _tmp54_[_tmp55_];
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (_tmp56_ != NULL) {
#line 2714 "tracker-needle.c"
					gchar** _tmp57_;
					gint _tmp57__length1;
					gint _tmp58_;
					const gchar* _tmp59_;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp57_ = str_array;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp57__length1 = str_array_length1;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp58_ = i;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp59_ = _tmp57_[_tmp58_];
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp53_ = (const gchar*) _tmp59_;
#line 2729 "tracker-needle.c"
				} else {
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp53_ = "";
#line 2733 "tracker-needle.c"
				}
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp60_ = ptr;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				ptr = _tmp61_;
#line 2741 "tracker-needle.c"
			}
		}
#line 1100 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp62_ = res;
#line 1100 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		res = NULL;
#line 1100 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = (gchar*) _tmp62_;
#line 1100 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 2752 "tracker-needle.c"
	} else {
		gchar* _tmp63_;
#line 1102 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp63_ = g_strdup ("");
#line 1102 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = _tmp63_;
#line 1102 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 2761 "tracker-needle.c"
	}
}


static gboolean tracker_needle_search_run (TrackerNeedle* self) {
	gboolean result = FALSE;
	gchar* str = NULL;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* criteria = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	TrackerResultStore* store = NULL;
	GtkToggleToolButton* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	TrackerView* _tmp23_;
	TrackerView* _tmp24_;
	GtkWidget* _tmp25_;
	GtkToggleToolButton* _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	GtkToggleToolButton* _tmp42_;
	gboolean _tmp43_;
	gboolean _tmp44_;
	GtkToggleToolButton* _tmp51_;
	gboolean _tmp52_;
	gboolean _tmp53_;
	TrackerResultStore* _tmp81_;
#line 511 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 512 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->last_search_id = (guint) 0;
#line 514 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = self->priv->search;
#line 514 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 514 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 514 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	str = _tmp2_;
#line 515 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = str;
#line 515 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp4_ = string_strip (_tmp3_);
#line 515 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	criteria = _tmp4_;
#line 516 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	store = NULL;
#line 518 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp5_ = self->priv->show_tags;
#line 518 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp6_ = gtk_toggle_tool_button_get_active (_tmp5_);
#line 518 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp7_ = _tmp6_;
#line 518 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (!_tmp7_) {
#line 2820 "tracker-needle.c"
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		const gchar* _tmp19_;
		gboolean _tmp20_;
		GtkTreeIter* _tmp21_;
		GtkTreeIter* _tmp22_;
#line 519 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp8_ = criteria;
#line 519 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp9_ = strlen (_tmp8_);
#line 519 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp10_ = _tmp9_;
#line 519 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp10_ < 3) {
#line 2836 "tracker-needle.c"
			gboolean _tmp11_ = FALSE;
			GtkToggleToolButton* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_;
#line 521 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp12_ = self->priv->view_icons;
#line 521 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp13_ = gtk_toggle_tool_button_get_active (_tmp12_);
#line 521 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp14_ = _tmp13_;
#line 521 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			if (!_tmp14_) {
#line 521 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp11_ = TRUE;
#line 2851 "tracker-needle.c"
			} else {
				GtkToggleToolButton* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
#line 521 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp15_ = self->priv->find_in_all;
#line 521 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp16_ = gtk_toggle_tool_button_get_active (_tmp15_);
#line 521 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp17_ = _tmp16_;
#line 521 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp11_ = !_tmp17_;
#line 2864 "tracker-needle.c"
			}
#line 521 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			if (_tmp11_) {
#line 2868 "tracker-needle.c"
				TrackerResultStore* _tmp18_;
#line 522 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp18_ = store;
#line 522 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				tracker_needle_search_finished (self, _tmp18_);
#line 523 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				result = FALSE;
#line 523 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_g_object_unref0 (store);
#line 523 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_g_free0 (criteria);
#line 523 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_g_free0 (str);
#line 523 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				return result;
#line 2884 "tracker-needle.c"
			}
		}
#line 527 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp19_ = criteria;
#line 527 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp20_ = TRUE;
#line 527 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp21_ = tracker_needle_search_history_find_or_insert (self, _tmp19_, &_tmp20_);
#line 527 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp22_ = _tmp21_;
#line 527 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (_tmp22_);
#line 2897 "tracker-needle.c"
	}
#line 531 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp23_ = self->priv->sw_noresults;
#line 531 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_hide ((GtkWidget*) _tmp23_);
#line 532 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp24_ = self->priv->sw_noresults;
#line 532 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp25_ = _g_object_ref0 ((GtkWidget*) _tmp24_);
#line 532 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->current_view);
#line 532 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->current_view = _tmp25_;
#line 534 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp26_ = self->priv->view_icons;
#line 534 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp27_ = gtk_toggle_tool_button_get_active (_tmp26_);
#line 534 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp28_ = _tmp27_;
#line 534 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp28_) {
#line 2919 "tracker-needle.c"
		TrackerView* _tmp29_;
		TrackerView* _tmp30_;
		GtkWidget* _tmp31_;
		GtkToggleToolButton* _tmp32_;
		gboolean _tmp33_;
		gboolean _tmp34_;
		TrackerView* _tmp39_;
		TrackerResultStore* _tmp40_;
#line 535 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp29_ = self->priv->sw_icons;
#line 535 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_show ((GtkWidget*) _tmp29_);
#line 536 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp30_ = self->priv->sw_icons;
#line 536 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp31_ = _g_object_ref0 ((GtkWidget*) _tmp30_);
#line 536 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (self->priv->current_view);
#line 536 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		self->priv->current_view = _tmp31_;
#line 538 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp32_ = self->priv->find_in_all;
#line 538 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp33_ = gtk_toggle_tool_button_get_active (_tmp32_);
#line 538 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp34_ = _tmp33_;
#line 538 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp34_) {
#line 2948 "tracker-needle.c"
			TrackerResultStore* _tmp35_;
			TrackerResultStore* _tmp36_;
#line 539 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp35_ = self->priv->images_model;
#line 539 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp36_ = _g_object_ref0 (_tmp35_);
#line 539 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_object_unref0 (store);
#line 539 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			store = _tmp36_;
#line 2959 "tracker-needle.c"
		} else {
			TrackerResultStore* _tmp37_;
			TrackerResultStore* _tmp38_;
#line 541 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp37_ = self->priv->images_in_title_model;
#line 541 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp38_ = _g_object_ref0 (_tmp37_);
#line 541 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_object_unref0 (store);
#line 541 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			store = _tmp38_;
#line 2971 "tracker-needle.c"
		}
#line 544 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp39_ = self->priv->sw_icons;
#line 544 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp40_ = store;
#line 544 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tracker_view_set_store (_tmp39_, _tmp40_);
#line 2979 "tracker-needle.c"
	} else {
		TrackerView* _tmp41_;
#line 546 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp41_ = self->priv->sw_icons;
#line 546 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_hide ((GtkWidget*) _tmp41_);
#line 2986 "tracker-needle.c"
	}
#line 549 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp42_ = self->priv->view_categories;
#line 549 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp43_ = gtk_toggle_tool_button_get_active (_tmp42_);
#line 549 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp44_ = _tmp43_;
#line 549 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp44_) {
#line 2996 "tracker-needle.c"
		TrackerView* _tmp45_;
		TrackerView* _tmp46_;
		GtkWidget* _tmp47_;
		TrackerResultStore* _tmp48_;
		TrackerResultStore* _tmp49_;
#line 550 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp45_ = self->priv->sw_categories;
#line 550 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_show ((GtkWidget*) _tmp45_);
#line 551 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp46_ = self->priv->sw_categories;
#line 551 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp47_ = _g_object_ref0 ((GtkWidget*) _tmp46_);
#line 551 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (self->priv->current_view);
#line 551 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		self->priv->current_view = _tmp47_;
#line 552 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp48_ = self->priv->categories_model;
#line 552 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp49_ = _g_object_ref0 (_tmp48_);
#line 552 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (store);
#line 552 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		store = _tmp49_;
#line 3022 "tracker-needle.c"
	} else {
		TrackerView* _tmp50_;
#line 554 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp50_ = self->priv->sw_categories;
#line 554 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_hide ((GtkWidget*) _tmp50_);
#line 3029 "tracker-needle.c"
	}
#line 557 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp51_ = self->priv->view_filelist;
#line 557 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp52_ = gtk_toggle_tool_button_get_active (_tmp51_);
#line 557 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp53_ = _tmp52_;
#line 557 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp53_) {
#line 3039 "tracker-needle.c"
		TrackerView* _tmp54_;
		TrackerView* _tmp55_;
		GtkWidget* _tmp56_;
		GtkToggleToolButton* _tmp57_;
		gboolean _tmp58_;
		gboolean _tmp59_;
		TrackerView* _tmp78_;
		TrackerResultStore* _tmp79_;
#line 558 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp54_ = self->priv->sw_filelist;
#line 558 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_show ((GtkWidget*) _tmp54_);
#line 559 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp55_ = self->priv->sw_filelist;
#line 559 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp56_ = _g_object_ref0 ((GtkWidget*) _tmp55_);
#line 559 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (self->priv->current_view);
#line 559 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		self->priv->current_view = _tmp56_;
#line 561 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp57_ = self->priv->find_in_tags;
#line 561 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp58_ = gtk_toggle_tool_button_get_active (_tmp57_);
#line 561 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp59_ = _tmp58_;
#line 561 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp59_) {
#line 3068 "tracker-needle.c"
			TrackerResultStore* _tmp60_;
			TrackerResultStore* _tmp61_;
			TrackerResultStore* _tmp62_;
			GPtrArray* _tmp63_;
			GPtrArray* _tmp64_;
			TrackerResultStore* _tmp65_;
			GPtrArray* _tmp66_;
			GPtrArray* _tmp67_;
			gpointer* _tmp68_;
			gint _tmp68__length1;
			gchar* _tmp69_;
			gchar* _tmp70_;
#line 562 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp60_ = self->priv->files_in_tags_model;
#line 562 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp61_ = _g_object_ref0 (_tmp60_);
#line 562 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_object_unref0 (store);
#line 562 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			store = _tmp61_;
#line 563 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp62_ = store;
#line 563 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp63_ = tracker_needle_search_tags (self);
#line 563 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp64_ = _tmp63_;
#line 563 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			tracker_result_store_set_search_tags (_tmp62_, _tmp64_);
#line 563 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_ptr_array_unref0 (_tmp64_);
#line 564 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp65_ = store;
#line 564 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp66_ = tracker_result_store_get_search_tags (_tmp65_);
#line 564 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp67_ = _tmp66_;
#line 564 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp68_ = _tmp67_->pdata;
#line 564 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp68__length1 = (gint) _tmp67_->len;
#line 564 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp69_ = _vala_g_strjoinv ("; ", _tmp68_, _tmp68__length1);
#line 564 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp70_ = _tmp69_;
#line 564 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			g_debug ("tracker-needle.vala:564: Tags to look for: %s", _tmp70_);
#line 564 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_g_free0 (_tmp70_);
#line 3117 "tracker-needle.c"
		} else {
			GtkToggleToolButton* _tmp71_;
			gboolean _tmp72_;
			gboolean _tmp73_;
#line 565 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp71_ = self->priv->find_in_contents;
#line 565 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp72_ = gtk_toggle_tool_button_get_active (_tmp71_);
#line 565 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp73_ = _tmp72_;
#line 565 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			if (_tmp73_) {
#line 3130 "tracker-needle.c"
				TrackerResultStore* _tmp74_;
				TrackerResultStore* _tmp75_;
#line 566 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp74_ = self->priv->files_model;
#line 566 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp75_ = _g_object_ref0 (_tmp74_);
#line 566 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_g_object_unref0 (store);
#line 566 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				store = _tmp75_;
#line 3141 "tracker-needle.c"
			} else {
				TrackerResultStore* _tmp76_;
				TrackerResultStore* _tmp77_;
#line 568 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp76_ = self->priv->files_in_title_model;
#line 568 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp77_ = _g_object_ref0 (_tmp76_);
#line 568 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_g_object_unref0 (store);
#line 568 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				store = _tmp77_;
#line 3153 "tracker-needle.c"
			}
		}
#line 571 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp78_ = self->priv->sw_filelist;
#line 571 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp79_ = store;
#line 571 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tracker_view_set_store (_tmp78_, _tmp79_);
#line 3162 "tracker-needle.c"
	} else {
		TrackerView* _tmp80_;
#line 573 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp80_ = self->priv->sw_filelist;
#line 573 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_hide ((GtkWidget*) _tmp80_);
#line 3169 "tracker-needle.c"
	}
#line 576 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp81_ = store;
#line 576 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp81_ != NULL) {
#line 3175 "tracker-needle.c"
		GtkToggleToolButton* _tmp82_;
		gboolean _tmp83_;
		gboolean _tmp84_;
		TrackerResultStore* _tmp86_;
		GtkEntry* _tmp87_;
		const gchar* _tmp88_;
#line 579 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp82_ = self->priv->find_in_tags;
#line 579 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp83_ = gtk_toggle_tool_button_get_active (_tmp82_);
#line 579 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp84_ = _tmp83_;
#line 579 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (!_tmp84_) {
#line 3190 "tracker-needle.c"
			TrackerResultStore* _tmp85_;
#line 580 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp85_ = store;
#line 580 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			tracker_result_store_set_search_tags (_tmp85_, NULL);
#line 3196 "tracker-needle.c"
		}
#line 582 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp86_ = store;
#line 582 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp87_ = self->priv->search;
#line 582 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp88_ = gtk_entry_get_text (_tmp87_);
#line 582 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tracker_result_store_set_search_term (_tmp86_, _tmp88_);
#line 3206 "tracker-needle.c"
	}
#line 585 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	result = FALSE;
#line 585 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (store);
#line 585 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_free0 (criteria);
#line 585 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_free0 (str);
#line 585 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return result;
#line 3218 "tracker-needle.c"
}


static void tracker_needle_window_closed (TrackerNeedle* self) {
	GtkToggleToolButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 588 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 591 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = self->priv->view_icons;
#line 591 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = gtk_toggle_tool_button_get_active (_tmp0_);
#line 591 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = _tmp1_;
#line 591 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp2_) {
#line 3236 "tracker-needle.c"
		GSettings* _tmp3_;
#line 592 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp3_ = self->priv->settings_needle;
#line 592 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_settings_set_int (_tmp3_, "default-view", 0);
#line 3242 "tracker-needle.c"
	} else {
		GtkToggleToolButton* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
#line 593 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp4_ = self->priv->view_filelist;
#line 593 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp5_ = gtk_toggle_tool_button_get_active (_tmp4_);
#line 593 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp6_ = _tmp5_;
#line 593 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp6_) {
#line 3255 "tracker-needle.c"
			GSettings* _tmp7_;
#line 594 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp7_ = self->priv->settings_needle;
#line 594 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			g_settings_set_int (_tmp7_, "default-view", 2);
#line 3261 "tracker-needle.c"
		} else {
			GSettings* _tmp8_;
#line 596 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp8_ = self->priv->settings_needle;
#line 596 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			g_settings_set_int (_tmp8_, "default-view", 1);
#line 3268 "tracker-needle.c"
		}
	}
#line 598 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_main_quit ();
#line 3273 "tracker-needle.c"
}


static void tracker_needle_view_toggled (TrackerNeedle* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkToggleToolButton* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp11_ = FALSE;
	GtkToggleToolButton* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	TrackerView* _tmp27_;
	TrackerView* _tmp28_;
	TrackerView* _tmp29_;
	TrackerView* _tmp30_;
	gboolean _tmp31_ = FALSE;
	GtkToggleToolButton* _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	GtkSeparatorToolItem* _tmp38_;
	GtkToggleToolButton* _tmp39_;
	GtkToggleToolButton* _tmp40_;
	gboolean _tmp41_;
	gboolean _tmp42_;
	gboolean _tmp43_ = FALSE;
	GtkToggleToolButton* _tmp44_;
	gboolean _tmp45_;
	gboolean _tmp46_;
	GtkToggleToolButton* _tmp50_;
	GtkToggleToolButton* _tmp51_;
	GtkToggleToolButton* _tmp52_;
	gboolean _tmp53_;
	gboolean _tmp54_;
	GtkToggleToolButton* _tmp55_;
	GtkToggleToolButton* _tmp56_;
	gboolean _tmp57_;
	gboolean _tmp58_;
#line 601 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 602 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = self->priv->view_icons;
#line 602 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = gtk_toggle_tool_button_get_active (_tmp2_);
#line 602 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp4_ = _tmp3_;
#line 602 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (!_tmp4_) {
#line 3323 "tracker-needle.c"
		GtkToggleToolButton* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
#line 603 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp5_ = self->priv->view_filelist;
#line 603 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp6_ = gtk_toggle_tool_button_get_active (_tmp5_);
#line 603 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp7_ = _tmp6_;
#line 603 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp1_ = !_tmp7_;
#line 3335 "tracker-needle.c"
	} else {
#line 602 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp1_ = FALSE;
#line 3339 "tracker-needle.c"
	}
#line 602 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp1_) {
#line 3343 "tracker-needle.c"
		GtkToggleToolButton* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
#line 604 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp8_ = self->priv->view_categories;
#line 604 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp9_ = gtk_toggle_tool_button_get_active (_tmp8_);
#line 604 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp10_ = _tmp9_;
#line 604 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp0_ = !_tmp10_;
#line 3355 "tracker-needle.c"
	} else {
#line 602 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp0_ = FALSE;
#line 3359 "tracker-needle.c"
	}
#line 602 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp0_) {
#line 605 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		return;
#line 3365 "tracker-needle.c"
	}
#line 608 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp12_ = self->priv->view_categories;
#line 608 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp13_ = gtk_toggle_tool_button_get_active (_tmp12_);
#line 608 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp14_ = _tmp13_;
#line 608 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp14_) {
#line 608 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp11_ = TRUE;
#line 3377 "tracker-needle.c"
	} else {
		GtkToggleToolButton* _tmp15_;
		gboolean _tmp16_;
		gboolean _tmp17_;
#line 608 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp15_ = self->priv->view_filelist;
#line 608 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp16_ = gtk_toggle_tool_button_get_active (_tmp15_);
#line 608 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp17_ = _tmp16_;
#line 608 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp11_ = _tmp17_;
#line 3390 "tracker-needle.c"
	}
#line 608 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp11_) {
#line 3394 "tracker-needle.c"
		gboolean _tmp18_;
#line 609 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp18_ = tracker_needle_current_find_in_filelist;
#line 609 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp18_) {
#line 3400 "tracker-needle.c"
			GtkToggleToolButton* _tmp19_;
#line 610 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp19_ = self->priv->find_in_contents;
#line 610 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			gtk_toggle_tool_button_set_active (_tmp19_, TRUE);
#line 3406 "tracker-needle.c"
		} else {
			GtkToggleToolButton* _tmp20_;
#line 612 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp20_ = self->priv->find_in_titles;
#line 612 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			gtk_toggle_tool_button_set_active (_tmp20_, TRUE);
#line 3413 "tracker-needle.c"
		}
	} else {
		GtkToggleToolButton* _tmp21_;
		gboolean _tmp22_;
		gboolean _tmp23_;
#line 614 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp21_ = self->priv->view_icons;
#line 614 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp22_ = gtk_toggle_tool_button_get_active (_tmp21_);
#line 614 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp23_ = _tmp22_;
#line 614 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp23_) {
#line 3427 "tracker-needle.c"
			gboolean _tmp24_;
#line 615 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp24_ = tracker_needle_current_find_in_icons;
#line 615 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			if (_tmp24_) {
#line 3433 "tracker-needle.c"
				GtkToggleToolButton* _tmp25_;
#line 616 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp25_ = self->priv->find_in_titles;
#line 616 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				gtk_toggle_tool_button_set_active (_tmp25_, TRUE);
#line 3439 "tracker-needle.c"
			} else {
				GtkToggleToolButton* _tmp26_;
#line 618 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp26_ = self->priv->find_in_all;
#line 618 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				gtk_toggle_tool_button_set_active (_tmp26_, TRUE);
#line 3446 "tracker-needle.c"
			}
		}
	}
#line 623 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp27_ = self->priv->sw_noresults;
#line 623 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_show ((GtkWidget*) _tmp27_);
#line 624 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp28_ = self->priv->sw_icons;
#line 624 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_hide ((GtkWidget*) _tmp28_);
#line 625 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp29_ = self->priv->sw_filelist;
#line 625 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_hide ((GtkWidget*) _tmp29_);
#line 626 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp30_ = self->priv->sw_categories;
#line 626 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_hide ((GtkWidget*) _tmp30_);
#line 629 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp32_ = self->priv->view_filelist;
#line 629 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp33_ = gtk_toggle_tool_button_get_active (_tmp32_);
#line 629 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp34_ = _tmp33_;
#line 629 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp34_) {
#line 629 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp31_ = TRUE;
#line 3476 "tracker-needle.c"
	} else {
		GtkToggleToolButton* _tmp35_;
		gboolean _tmp36_;
		gboolean _tmp37_;
#line 629 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp35_ = self->priv->view_icons;
#line 629 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp36_ = gtk_toggle_tool_button_get_active (_tmp35_);
#line 629 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp37_ = _tmp36_;
#line 629 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp31_ = _tmp37_;
#line 3489 "tracker-needle.c"
	}
#line 629 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp38_ = self->priv->separator_secondary;
#line 629 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp38_, _tmp31_);
#line 630 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp39_ = self->priv->find_in_contents;
#line 630 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp40_ = self->priv->view_filelist;
#line 630 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp41_ = gtk_toggle_tool_button_get_active (_tmp40_);
#line 630 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp42_ = _tmp41_;
#line 630 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp39_, _tmp42_);
#line 631 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp44_ = self->priv->view_filelist;
#line 631 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp45_ = gtk_toggle_tool_button_get_active (_tmp44_);
#line 631 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp46_ = _tmp45_;
#line 631 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp46_) {
#line 631 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp43_ = TRUE;
#line 3515 "tracker-needle.c"
	} else {
		GtkToggleToolButton* _tmp47_;
		gboolean _tmp48_;
		gboolean _tmp49_;
#line 631 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp47_ = self->priv->view_icons;
#line 631 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp48_ = gtk_toggle_tool_button_get_active (_tmp47_);
#line 631 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp49_ = _tmp48_;
#line 631 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp43_ = _tmp49_;
#line 3528 "tracker-needle.c"
	}
#line 631 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp50_ = self->priv->find_in_titles;
#line 631 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp50_, _tmp43_);
#line 632 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp51_ = self->priv->find_in_tags;
#line 632 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp52_ = self->priv->view_filelist;
#line 632 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp53_ = gtk_toggle_tool_button_get_active (_tmp52_);
#line 632 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp54_ = _tmp53_;
#line 632 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp51_, _tmp54_);
#line 633 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp55_ = self->priv->find_in_all;
#line 633 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp56_ = self->priv->view_icons;
#line 633 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp57_ = gtk_toggle_tool_button_get_active (_tmp56_);
#line 633 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp58_ = _tmp57_;
#line 633 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp55_, _tmp58_);
#line 635 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_search_run (self);
#line 3556 "tracker-needle.c"
}


static void tracker_needle_find_in_toggled (TrackerNeedle* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkToggleToolButton* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GtkToggleToolButton* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	GtkToggleToolButton* _tmp37_;
	gboolean _tmp38_;
	gboolean _tmp39_;
#line 639 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 640 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = self->priv->find_in_contents;
#line 640 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp4_ = gtk_toggle_tool_button_get_active (_tmp3_);
#line 640 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp5_ = _tmp4_;
#line 640 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (!_tmp5_) {
#line 3583 "tracker-needle.c"
		GtkToggleToolButton* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
#line 641 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp6_ = self->priv->find_in_titles;
#line 641 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp7_ = gtk_toggle_tool_button_get_active (_tmp6_);
#line 641 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp8_ = _tmp7_;
#line 641 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp2_ = !_tmp8_;
#line 3595 "tracker-needle.c"
	} else {
#line 640 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp2_ = FALSE;
#line 3599 "tracker-needle.c"
	}
#line 640 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp2_) {
#line 3603 "tracker-needle.c"
		GtkToggleToolButton* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
#line 642 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp9_ = self->priv->find_in_tags;
#line 642 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp10_ = gtk_toggle_tool_button_get_active (_tmp9_);
#line 642 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp11_ = _tmp10_;
#line 642 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp1_ = !_tmp11_;
#line 3615 "tracker-needle.c"
	} else {
#line 640 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp1_ = FALSE;
#line 3619 "tracker-needle.c"
	}
#line 640 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp1_) {
#line 3623 "tracker-needle.c"
		GtkToggleToolButton* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
#line 643 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp12_ = self->priv->find_in_all;
#line 643 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp13_ = gtk_toggle_tool_button_get_active (_tmp12_);
#line 643 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp14_ = _tmp13_;
#line 643 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp0_ = !_tmp14_;
#line 3635 "tracker-needle.c"
	} else {
#line 640 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp0_ = FALSE;
#line 3639 "tracker-needle.c"
	}
#line 640 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp0_) {
#line 644 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		return;
#line 3645 "tracker-needle.c"
	}
#line 647 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp15_ = self->priv->find_in_contents;
#line 647 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp16_ = gtk_toggle_tool_button_get_active (_tmp15_);
#line 647 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp17_ = _tmp16_;
#line 647 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp17_) {
#line 3655 "tracker-needle.c"
		GtkToggleToolButton* _tmp18_;
		gboolean _tmp19_;
		gboolean _tmp20_;
#line 648 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_debug ("tracker-needle.vala:648: Find in toggled to 'contents'");
#line 650 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp18_ = self->priv->show_tags;
#line 650 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp19_ = gtk_toggle_tool_button_get_active (_tmp18_);
#line 650 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp20_ = _tmp19_;
#line 650 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp20_ != TRUE) {
#line 3669 "tracker-needle.c"
			GtkToolItem* _tmp21_;
#line 651 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp21_ = self->priv->search_entry;
#line 651 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			gtk_widget_set_sensitive ((GtkWidget*) _tmp21_, TRUE);
#line 3675 "tracker-needle.c"
		}
#line 654 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tracker_needle_search_run (self);
#line 3679 "tracker-needle.c"
	} else {
		GtkToggleToolButton* _tmp22_;
		gboolean _tmp23_;
		gboolean _tmp24_;
#line 655 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp22_ = self->priv->find_in_tags;
#line 655 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp23_ = gtk_toggle_tool_button_get_active (_tmp22_);
#line 655 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp24_ = _tmp23_;
#line 655 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp24_) {
#line 3692 "tracker-needle.c"
			GtkToolItem* _tmp25_;
#line 656 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			g_debug ("tracker-needle.vala:656: Find in toggled to 'tags'");
#line 658 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp25_ = self->priv->search_entry;
#line 658 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			gtk_widget_set_sensitive ((GtkWidget*) _tmp25_, TRUE);
#line 659 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			tracker_needle_search_run (self);
#line 3702 "tracker-needle.c"
		} else {
			GtkToggleToolButton* _tmp26_;
			gboolean _tmp27_;
			gboolean _tmp28_;
#line 660 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp26_ = self->priv->find_in_titles;
#line 660 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp27_ = gtk_toggle_tool_button_get_active (_tmp26_);
#line 660 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp28_ = _tmp27_;
#line 660 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			if (_tmp28_) {
#line 3715 "tracker-needle.c"
				GtkToggleToolButton* _tmp29_;
				gboolean _tmp30_;
				gboolean _tmp31_;
#line 661 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				g_debug ("tracker-needle.vala:661: Find in toggled to 'titles'");
#line 663 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp29_ = self->priv->show_tags;
#line 663 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp30_ = gtk_toggle_tool_button_get_active (_tmp29_);
#line 663 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp31_ = _tmp30_;
#line 663 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				if (_tmp31_ != TRUE) {
#line 3729 "tracker-needle.c"
					GtkToolItem* _tmp32_;
#line 664 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp32_ = self->priv->search_entry;
#line 664 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					gtk_widget_set_sensitive ((GtkWidget*) _tmp32_, TRUE);
#line 3735 "tracker-needle.c"
				}
#line 667 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				tracker_needle_search_run (self);
#line 3739 "tracker-needle.c"
			} else {
				GtkToggleToolButton* _tmp33_;
				gboolean _tmp34_;
				gboolean _tmp35_;
#line 668 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp33_ = self->priv->find_in_all;
#line 668 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp34_ = gtk_toggle_tool_button_get_active (_tmp33_);
#line 668 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp35_ = _tmp34_;
#line 668 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				if (_tmp35_) {
#line 3752 "tracker-needle.c"
					GtkToolItem* _tmp36_;
#line 669 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					g_debug ("tracker-needle.vala:669: Find in toggled to 'all'");
#line 672 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp36_ = self->priv->search_entry;
#line 672 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					gtk_widget_set_sensitive ((GtkWidget*) _tmp36_, FALSE);
#line 674 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					tracker_needle_search_run (self);
#line 3762 "tracker-needle.c"
				}
			}
		}
	}
#line 677 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp37_ = self->priv->view_filelist;
#line 677 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp38_ = gtk_toggle_tool_button_get_active (_tmp37_);
#line 677 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp39_ = _tmp38_;
#line 677 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp39_) {
#line 3775 "tracker-needle.c"
		GtkToggleToolButton* _tmp40_;
		gboolean _tmp41_;
		gboolean _tmp42_;
#line 678 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp40_ = self->priv->find_in_contents;
#line 678 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp41_ = gtk_toggle_tool_button_get_active (_tmp40_);
#line 678 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp42_ = _tmp41_;
#line 678 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tracker_needle_current_find_in_filelist = _tmp42_;
#line 3787 "tracker-needle.c"
	} else {
		GtkToggleToolButton* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
#line 679 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp43_ = self->priv->view_icons;
#line 679 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp44_ = gtk_toggle_tool_button_get_active (_tmp43_);
#line 679 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp45_ = _tmp44_;
#line 679 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp45_) {
#line 3800 "tracker-needle.c"
			GtkToggleToolButton* _tmp46_;
			gboolean _tmp47_;
			gboolean _tmp48_;
#line 680 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp46_ = self->priv->find_in_titles;
#line 680 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp47_ = gtk_toggle_tool_button_get_active (_tmp46_);
#line 680 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp48_ = _tmp47_;
#line 680 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			tracker_needle_current_find_in_icons = _tmp48_;
#line 3812 "tracker-needle.c"
		}
	}
}


static void tracker_needle_view_row_activated (TrackerNeedle* self, GtkTreeView* view, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkTreeModel* model = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreePath* _tmp3_;
#line 684 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 684 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (view != NULL);
#line 684 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (path != NULL);
#line 684 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (column != NULL);
#line 685 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = view;
#line 685 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = gtk_tree_view_get_model (_tmp0_);
#line 685 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 685 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	model = _tmp2_;
#line 686 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = path;
#line 686 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_model_launch_selected (model, _tmp3_, 1);
#line 684 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (model);
#line 3846 "tracker-needle.c"
}


static void tracker_needle_icon_item_activated (TrackerNeedle* self, GtkIconView* view, GtkTreePath* path) {
	GtkTreeModel* model = NULL;
	GtkIconView* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreePath* _tmp3_;
#line 689 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 689 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (view != NULL);
#line 689 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (path != NULL);
#line 690 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = view;
#line 690 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = gtk_icon_view_get_model (_tmp0_);
#line 690 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 690 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	model = _tmp2_;
#line 691 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = path;
#line 691 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_model_launch_selected (model, _tmp3_, 1);
#line 689 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (model);
#line 3876 "tracker-needle.c"
}


static void _g_free0_ (gpointer var) {
#line 703 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	var = (g_free (var), NULL);
#line 3883 "tracker-needle.c"
}


static void _g_list_free__g_free0_ (GList* self) {
#line 703 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
#line 703 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_list_free (self);
#line 3892 "tracker-needle.c"
}


static void _gtk_tree_path_free0_ (gpointer var) {
#line 703 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
#line 3899 "tracker-needle.c"
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
#line 703 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
#line 703 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_list_free (self);
#line 3908 "tracker-needle.c"
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
#line 706 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return self ? gtk_tree_path_copy (self) : NULL;
#line 3915 "tracker-needle.c"
}


static void tracker_needle_view_row_selected (TrackerNeedle* self, GtkTreeSelection* selection) {
	GtkTreeIter iter = {0};
	GtkTreeModel* model = NULL;
	GList* rows = NULL;
	GtkTreeSelection* _tmp0_;
	GtkTreeModel* _tmp1_ = NULL;
	GList* _tmp2_;
	GtkTreeModel* _tmp3_;
	GList* uris = NULL;
	GList* _tmp4_;
	GList* _tmp5_;
	TrackerTagsView* _tmp17_;
	GList* _tmp18_;
#line 694 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 694 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (selection != NULL);
#line 696 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	model = NULL;
#line 697 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_debug ("tracker-needle.vala:697: Row selection changed");
#line 699 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = selection;
#line 699 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = gtk_tree_selection_get_selected_rows (_tmp0_, &_tmp1_);
#line 699 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (model);
#line 699 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = _g_object_ref0 (_tmp1_);
#line 699 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	model = _tmp3_;
#line 699 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	rows = _tmp2_;
#line 700 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	uris = NULL;
#line 702 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp4_ = rows;
#line 702 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp4_ == NULL) {
#line 703 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		__g_list_free__g_free0_0 (uris);
#line 703 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		__g_list_free__gtk_tree_path_free0_0 (rows);
#line 703 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (model);
#line 703 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		return;
#line 3966 "tracker-needle.c"
	}
#line 706 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp5_ = rows;
#line 3970 "tracker-needle.c"
	{
		GList* path_collection = NULL;
		GList* path_it = NULL;
#line 706 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		path_collection = _tmp5_;
#line 706 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
#line 3978 "tracker-needle.c"
			GtkTreePath* _tmp6_;
			GtkTreePath* path = NULL;
#line 706 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp6_ = _gtk_tree_path_copy0 ((GtkTreePath*) path_it->data);
#line 706 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			path = _tmp6_;
#line 3985 "tracker-needle.c"
			{
				GtkTreeModel* _tmp7_;
				GtkTreePath* _tmp8_;
				GtkTreeIter _tmp9_ = {0};
				gboolean _tmp10_;
#line 707 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp7_ = model;
#line 707 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp8_ = path;
#line 707 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp10_ = gtk_tree_model_get_iter (_tmp7_, &_tmp9_, _tmp8_);
#line 707 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				iter = _tmp9_;
#line 707 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				if (_tmp10_) {
#line 4001 "tracker-needle.c"
					gchar* uri = NULL;
					GtkTreeModel* _tmp11_;
					GtkTreeIter _tmp12_;
					const gchar* _tmp13_;
					const gchar* _tmp14_;
#line 710 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp11_ = model;
#line 710 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp12_ = iter;
#line 710 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					gtk_tree_model_get (_tmp11_, &_tmp12_, 1, &uri, -1, -1);
#line 711 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp13_ = uri;
#line 711 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					g_debug ("tracker-needle.vala:711: --> %s", _tmp13_);
#line 713 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_tmp14_ = uri;
#line 713 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					if (_tmp14_ != NULL) {
#line 4021 "tracker-needle.c"
						const gchar* _tmp15_;
						gchar* _tmp16_;
#line 714 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
						_tmp15_ = uri;
#line 714 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
						_tmp16_ = g_strdup (_tmp15_);
#line 714 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
						uris = g_list_prepend (uris, _tmp16_);
#line 4030 "tracker-needle.c"
					}
#line 707 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
					_g_free0 (uri);
#line 4034 "tracker-needle.c"
				}
#line 706 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_gtk_tree_path_free0 (path);
#line 4038 "tracker-needle.c"
			}
		}
	}
#line 719 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp17_ = self->priv->tags_view;
#line 719 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp18_ = uris;
#line 719 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_tags_view_set_files (_tmp17_, _tmp18_);
#line 694 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	__g_list_free__g_free0_0 (uris);
#line 694 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	__g_list_free__gtk_tree_path_free0_0 (rows);
#line 694 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (model);
#line 4054 "tracker-needle.c"
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 722 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 722 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return _data4_;
#line 4063 "tracker-needle.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 722 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 4072 "tracker-needle.c"
		TrackerNeedle* self;
#line 722 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		self = _data4_->self;
#line 722 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		__g_list_free__g_free0_0 (_data4_->uris);
#line 722 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_object_unref0 (_data4_->model);
#line 722 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tracker_needle_unref0 (self);
#line 722 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_slice_free (Block4Data, _data4_);
#line 4084 "tracker-needle.c"
	}
}


static void __lambda9_ (Block4Data* _data4_, GtkIconView* iconview, GtkTreePath* path) {
	TrackerNeedle* self;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
#line 731 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self = _data4_->self;
#line 731 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (iconview != NULL);
#line 731 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (path != NULL);
#line 734 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = _data4_->model;
#line 734 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = path;
#line 734 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = gtk_tree_model_get_iter (_tmp0_, &_tmp2_, _tmp1_);
#line 734 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	iter = _tmp2_;
#line 734 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp3_) {
#line 4112 "tracker-needle.c"
		gchar* uri = NULL;
		GtkTreeModel* _tmp4_;
		GtkTreeIter _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
#line 737 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp4_ = _data4_->model;
#line 737 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp5_ = iter;
#line 737 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &uri, -1, -1);
#line 738 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp6_ = uri;
#line 738 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_debug ("tracker-needle.vala:738: --> %s", _tmp6_);
#line 740 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp7_ = uri;
#line 740 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (_tmp7_ != NULL) {
#line 4132 "tracker-needle.c"
			const gchar* _tmp8_;
			gchar* _tmp9_;
#line 741 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp8_ = uri;
#line 741 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp9_ = g_strdup (_tmp8_);
#line 741 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_data4_->uris = g_list_prepend (_data4_->uris, _tmp9_);
#line 4141 "tracker-needle.c"
		}
#line 734 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (uri);
#line 4145 "tracker-needle.c"
	}
}


static void ___lambda9__gtk_icon_view_foreach_func (GtkIconView* icon_view, GtkTreePath* path, gpointer self) {
#line 731 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	__lambda9_ (self, icon_view, path);
#line 4153 "tracker-needle.c"
}


static void tracker_needle_icon_view_selection_changed (TrackerNeedle* self) {
	Block4Data* _data4_;
	GtkIconView* iconview = NULL;
	TrackerView* _tmp0_;
	GtkWidget* _tmp1_;
	GtkIconView* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	TrackerTagsView* _tmp5_;
#line 722 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 722 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 722 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_data4_->_ref_count_ = 1;
#line 722 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_data4_->self = tracker_needle_ref (self);
#line 724 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_data4_->model = NULL;
#line 725 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_debug ("tracker-needle.vala:725: Icon selection changed");
#line 727 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = self->priv->sw_icons;
#line 727 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = gtk_bin_get_child ((GtkBin*) _tmp0_);
#line 727 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_icon_view_get_type (), GtkIconView));
#line 727 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (iconview);
#line 727 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	iconview = _tmp2_;
#line 728 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = gtk_icon_view_get_model (iconview);
#line 728 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 728 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (_data4_->model);
#line 728 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_data4_->model = _tmp4_;
#line 729 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_data4_->uris = NULL;
#line 731 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_icon_view_selected_foreach (iconview, ___lambda9__gtk_icon_view_foreach_func, _data4_);
#line 746 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp5_ = self->priv->tags_view;
#line 746 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_tags_view_set_files (_tmp5_, _data4_->uris);
#line 722 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (iconview);
#line 722 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	block4_data_unref (_data4_);
#line 722 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_data4_ = NULL;
#line 4210 "tracker-needle.c"
}


static void tracker_needle_show_tags_clicked (TrackerNeedle* self) {
	GtkToggleToolButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 749 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 750 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = self->priv->show_tags;
#line 750 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = gtk_toggle_tool_button_get_active (_tmp0_);
#line 750 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = _tmp1_;
#line 750 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp2_) {
#line 4228 "tracker-needle.c"
		TrackerTagsView* _tmp3_;
#line 751 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_debug ("tracker-needle.vala:751: Showing tags");
#line 752 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp3_ = self->priv->tags_view;
#line 752 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_show ((GtkWidget*) _tmp3_);
#line 4236 "tracker-needle.c"
	} else {
		TrackerTagsView* _tmp4_;
#line 755 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_debug ("tracker-needle.vala:755: Hiding tags");
#line 756 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp4_ = self->priv->tags_view;
#line 756 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		gtk_widget_hide ((GtkWidget*) _tmp4_);
#line 4245 "tracker-needle.c"
	}
}


static void tracker_needle_show_stats_clicked (TrackerNeedle* self) {
	TrackerStats* s = NULL;
	TrackerStats* _tmp0_;
#line 764 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 765 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_debug ("tracker-needle.vala:765: Showing stats dialog");
#line 766 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = tracker_stats_new ();
#line 766 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_object_ref_sink (_tmp0_);
#line 766 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	s = _tmp0_;
#line 767 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_show ((GtkWidget*) s);
#line 764 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (s);
#line 4267 "tracker-needle.c"
}


void tracker_needle_show_info_message (TrackerNeedle* self, const gchar* message, GtkMessageType type) {
	GtkInfoBar* _tmp0_;
	GtkMessageType _tmp1_;
	GtkLabel* _tmp2_;
	const gchar* _tmp3_;
	GtkInfoBar* _tmp4_;
#line 770 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 770 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (message != NULL);
#line 772 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = self->priv->info_bar;
#line 772 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = type;
#line 772 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_info_bar_set_message_type (_tmp0_, _tmp1_);
#line 773 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = self->priv->info_bar_label;
#line 773 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp3_ = message;
#line 773 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_label_set_markup (_tmp2_, _tmp3_);
#line 774 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp4_ = self->priv->info_bar;
#line 774 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_show ((GtkWidget*) _tmp4_);
#line 4297 "tracker-needle.c"
}


static void tracker_needle_info_bar_closed (TrackerNeedle* self, GtkButton* source) {
	GtkInfoBar* _tmp0_;
#line 777 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (self != NULL);
#line 777 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (source != NULL);
#line 778 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = self->priv->info_bar;
#line 778 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 4311 "tracker-needle.c"
}


static GPtrArray* tracker_needle_search_tags (TrackerNeedle* self) {
	GPtrArray* result = NULL;
	GPtrArray* tagArray = NULL;
	GPtrArray* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
#line 781 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 782 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
#line 782 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tagArray = _tmp0_;
#line 784 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp1_ = self->priv->search;
#line 784 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp2_ = gtk_entry_get_text (_tmp1_);
#line 784 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ",", 0);
#line 4335 "tracker-needle.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 784 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tag_collection = _tmp4_;
#line 784 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tag_collection_length1 = _vala_array_length (_tmp3_);
#line 784 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		for (tag_it = 0; tag_it < _vala_array_length (_tmp3_); tag_it = tag_it + 1) {
#line 4347 "tracker-needle.c"
			gchar* _tmp5_;
			gchar* tag = NULL;
#line 784 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			_tmp5_ = g_strdup (tag_collection[tag_it]);
#line 784 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			tag = _tmp5_;
#line 4354 "tracker-needle.c"
			{
				GPtrArray* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
#line 785 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp6_ = tagArray;
#line 785 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp7_ = tag;
#line 785 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_tmp8_ = g_strdup (_tmp7_);
#line 785 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				g_ptr_array_add (_tmp6_, _tmp8_);
#line 784 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
				_g_free0 (tag);
#line 4369 "tracker-needle.c"
			}
		}
#line 784 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tag_collection = (_vala_array_free (tag_collection, tag_collection_length1, (GDestroyNotify) g_free), NULL);
#line 4374 "tracker-needle.c"
	}
#line 788 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	result = tagArray;
#line 788 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return result;
#line 4380 "tracker-needle.c"
}


static void tracker_value_needle_init (GValue* value) {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	value->data[0].v_pointer = NULL;
#line 4387 "tracker-needle.c"
}


static void tracker_value_needle_free_value (GValue* value) {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (value->data[0].v_pointer) {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tracker_needle_unref (value->data[0].v_pointer);
#line 4396 "tracker-needle.c"
	}
}


static void tracker_value_needle_copy_value (const GValue* src_value, GValue* dest_value) {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (src_value->data[0].v_pointer) {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		dest_value->data[0].v_pointer = tracker_needle_ref (src_value->data[0].v_pointer);
#line 4406 "tracker-needle.c"
	} else {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4410 "tracker-needle.c"
	}
}


static gpointer tracker_value_needle_peek_pointer (const GValue* value) {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return value->data[0].v_pointer;
#line 4418 "tracker-needle.c"
}


static gchar* tracker_value_needle_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (collect_values[0].v_pointer) {
#line 4425 "tracker-needle.c"
		TrackerNeedle * object;
		object = collect_values[0].v_pointer;
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (object->parent_instance.g_class == NULL) {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4432 "tracker-needle.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4436 "tracker-needle.c"
		}
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		value->data[0].v_pointer = tracker_needle_ref (object);
#line 4440 "tracker-needle.c"
	} else {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		value->data[0].v_pointer = NULL;
#line 4444 "tracker-needle.c"
	}
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return NULL;
#line 4448 "tracker-needle.c"
}


static gchar* tracker_value_needle_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerNeedle ** object_p;
	object_p = collect_values[0].v_pointer;
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (!object_p) {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4459 "tracker-needle.c"
	}
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (!value->data[0].v_pointer) {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		*object_p = NULL;
#line 4465 "tracker-needle.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		*object_p = value->data[0].v_pointer;
#line 4469 "tracker-needle.c"
	} else {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		*object_p = tracker_needle_ref (value->data[0].v_pointer);
#line 4473 "tracker-needle.c"
	}
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return NULL;
#line 4477 "tracker-needle.c"
}


GParamSpec* tracker_param_spec_needle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerParamSpecNeedle* spec;
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_NEEDLE), NULL);
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return G_PARAM_SPEC (spec);
#line 4491 "tracker-needle.c"
}


gpointer tracker_value_get_needle (const GValue* value) {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_NEEDLE), NULL);
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return value->data[0].v_pointer;
#line 4500 "tracker-needle.c"
}


void tracker_value_set_needle (GValue* value, gpointer v_object) {
	TrackerNeedle * old;
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_NEEDLE));
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	old = value->data[0].v_pointer;
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (v_object) {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_NEEDLE));
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		value->data[0].v_pointer = v_object;
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tracker_needle_ref (value->data[0].v_pointer);
#line 4520 "tracker-needle.c"
	} else {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		value->data[0].v_pointer = NULL;
#line 4524 "tracker-needle.c"
	}
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (old) {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tracker_needle_unref (old);
#line 4530 "tracker-needle.c"
	}
}


void tracker_value_take_needle (GValue* value, gpointer v_object) {
	TrackerNeedle * old;
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_NEEDLE));
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	old = value->data[0].v_pointer;
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (v_object) {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_NEEDLE));
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		value->data[0].v_pointer = v_object;
#line 4549 "tracker-needle.c"
	} else {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		value->data[0].v_pointer = NULL;
#line 4553 "tracker-needle.c"
	}
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (old) {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		tracker_needle_unref (old);
#line 4559 "tracker-needle.c"
	}
}


static void tracker_needle_class_init (TrackerNeedleClass * klass) {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	((TrackerNeedleClass *) klass)->finalize = tracker_needle_finalize;
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_type_class_add_private (klass, sizeof (TrackerNeedlePrivate));
#line 4571 "tracker-needle.c"
}


static void tracker_needle_instance_init (TrackerNeedle * self) {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv = TRACKER_NEEDLE_GET_PRIVATE (self);
#line 27 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->settings_needle = NULL;
#line 54 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->last_search_id = (guint) 0;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->size_small = 0;
#line 56 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->size_medium = 0;
#line 57 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->size_big = 0;
#line 58 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->limit = (guint) 500;
#line 59 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->priv->default_view = 1;
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self->ref_count = 1;
#line 4594 "tracker-needle.c"
}


static void tracker_needle_finalize (TrackerNeedle * obj) {
	TrackerNeedle * self;
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_NEEDLE, TrackerNeedle);
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_signal_handlers_destroy (self);
#line 27 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->settings_needle);
#line 29 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tracker_history_unref0 (self->priv->history);
#line 30 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->window);
#line 31 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->view_categories);
#line 32 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->view_filelist);
#line 33 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->view_icons);
#line 34 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->separator_secondary);
#line 35 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->find_in_contents);
#line 36 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->find_in_titles);
#line 37 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->find_in_tags);
#line 38 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->find_in_all);
#line 39 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->search_entry);
#line 40 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->search_list);
#line 41 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->search);
#line 42 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->spinner);
#line 43 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->spinner_shell);
#line 44 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->show_tags);
#line 45 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->show_stats);
#line 46 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->view);
#line 47 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->sw_noresults);
#line 48 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->sw_categories);
#line 49 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->sw_filelist);
#line 50 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->sw_icons);
#line 51 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->info_bar);
#line 52 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->info_bar_label);
#line 53 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->tags_view);
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->current_view);
#line 64 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->categories_model);
#line 65 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->files_model);
#line 66 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->files_in_tags_model);
#line 67 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->files_in_title_model);
#line 68 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->images_model);
#line 69 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_object_unref0 (self->priv->images_in_title_model);
#line 4670 "tracker-needle.c"
}


GType tracker_needle_get_type (void) {
	static volatile gsize tracker_needle_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_needle_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_value_needle_init, tracker_value_needle_free_value, tracker_value_needle_copy_value, tracker_value_needle_peek_pointer, "p", tracker_value_needle_collect_value, "p", tracker_value_needle_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerNeedleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_needle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerNeedle), 0, (GInstanceInitFunc) tracker_needle_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_needle_type_id;
		tracker_needle_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerNeedle", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_needle_type_id__volatile, tracker_needle_type_id);
	}
	return tracker_needle_type_id__volatile;
}


gpointer tracker_needle_ref (gpointer instance) {
	TrackerNeedle * self;
	self = instance;
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	g_atomic_int_inc (&self->ref_count);
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return instance;
#line 4695 "tracker-needle.c"
}


void tracker_needle_unref (gpointer instance) {
	TrackerNeedle * self;
	self = instance;
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		TRACKER_NEEDLE_GET_CLASS (self)->finalize (self);
#line 26 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4708 "tracker-needle.c"
	}
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_;
	gboolean _tmp14_;
	TrackerNeedle* n = NULL;
	TrackerNeedle* _tmp39_;
	TrackerNeedle* _tmp40_;
	TrackerNeedle* _tmp41_;
	gchar** _tmp42_;
	gint _tmp42__length1;
	GError * _inner_error_ = NULL;
#line 815 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp0_ = g_option_context_new (_ ("Desktop Search user interface using Tracker"));
#line 815 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	context = _tmp0_;
#line 4729 "tracker-needle.c"
	{
		GOptionContext* _tmp1_;
		GOptionContext* _tmp2_;
		GOptionContext* _tmp3_;
		GOptionGroup* _tmp4_;
		GOptionContext* _tmp5_;
#line 818 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp1_ = context;
#line 818 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_option_context_set_help_enabled (_tmp1_, TRUE);
#line 819 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp2_ = context;
#line 819 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_option_context_add_main_entries (_tmp2_, options, NULL);
#line 820 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp3_ = context;
#line 820 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp4_ = gtk_get_option_group (TRUE);
#line 820 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_option_context_add_group (_tmp3_, _tmp4_);
#line 821 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp5_ = context;
#line 821 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_option_context_parse (_tmp5_, &args_length1, &args, &_inner_error_);
#line 821 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4756 "tracker-needle.c"
			goto __catch28_g_error;
		}
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GOptionContext* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
#line 817 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		e = _inner_error_;
#line 817 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_inner_error_ = NULL;
#line 823 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp6_ = e;
#line 823 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp7_ = _tmp6_->message;
#line 823 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp8_ = g_strconcat (_tmp7_, "\n\n", NULL);
#line 823 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp9_ = _tmp8_;
#line 823 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_printerr ("%s", _tmp9_);
#line 823 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (_tmp9_);
#line 824 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp10_ = context;
#line 824 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp11_ = g_option_context_get_help (_tmp10_, TRUE, NULL);
#line 824 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp12_ = _tmp11_;
#line 824 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_printerr ("%s", _tmp12_);
#line 824 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (_tmp12_);
#line 825 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		result = 1;
#line 825 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_error_free0 (e);
#line 825 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_option_context_free0 (context);
#line 825 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		return result;
#line 4805 "tracker-needle.c"
	}
	__finally28:
#line 817 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4810 "tracker-needle.c"
		gint _tmp13_ = 0;
#line 817 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_option_context_free0 (context);
#line 817 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 817 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_clear_error (&_inner_error_);
#line 817 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		return _tmp13_;
#line 4820 "tracker-needle.c"
	}
#line 828 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp14_ = print_version;
#line 828 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	if (_tmp14_) {
#line 4826 "tracker-needle.c"
		gchar* about = NULL;
		gchar* _tmp15_;
		gchar* license = NULL;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
#line 829 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp15_ = g_strdup ("");
#line 829 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		about = _tmp15_;
#line 830 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp16_ = g_strdup ("");
#line 830 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		license = _tmp16_;
#line 832 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp17_ = about;
#line 832 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp18_ = g_strconcat (_tmp17_, "Tracker " PACKAGE_VERSION "\n", NULL);
#line 832 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (about);
#line 832 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		about = _tmp18_;
#line 834 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp19_ = license;
#line 834 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp20_ = g_strconcat (_tmp19_, "This program is free software and comes without any warranty.\n", NULL);
#line 834 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (license);
#line 834 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		license = _tmp20_;
#line 835 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp21_ = license;
#line 835 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp22_ = g_strconcat (_tmp21_, "It is licensed under version 2 or later of the General Public ", NULL);
#line 835 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (license);
#line 835 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		license = _tmp22_;
#line 836 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp23_ = license;
#line 836 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp24_ = g_strconcat (_tmp23_, "License which can be viewed at:\n", NULL);
#line 836 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (license);
#line 836 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		license = _tmp24_;
#line 837 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp25_ = license;
#line 837 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp26_ = g_strconcat (_tmp25_, "\n", NULL);
#line 837 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (license);
#line 837 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		license = _tmp26_;
#line 838 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp27_ = license;
#line 838 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp28_ = g_strconcat (_tmp27_, "  http://www.gnu.org/licenses/gpl.txt\n", NULL);
#line 838 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (license);
#line 838 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		license = _tmp28_;
#line 840 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp29_ = about;
#line 840 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp30_ = g_strconcat ("\n", _tmp29_, NULL);
#line 840 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp31_ = _tmp30_;
#line 840 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp32_ = g_strconcat (_tmp31_, "\n", NULL);
#line 840 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp33_ = _tmp32_;
#line 840 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp34_ = license;
#line 840 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp35_ = g_strconcat (_tmp33_, _tmp34_, NULL);
#line 840 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp36_ = _tmp35_;
#line 840 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp37_ = g_strconcat (_tmp36_, "\n", NULL);
#line 840 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_tmp38_ = _tmp37_;
#line 840 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		g_print ("%s", _tmp38_);
#line 840 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (_tmp38_);
#line 840 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (_tmp36_);
#line 840 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (_tmp33_);
#line 840 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (_tmp31_);
#line 841 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		result = 0;
#line 841 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (license);
#line 841 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_free0 (about);
#line 841 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		_g_option_context_free0 (context);
#line 841 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
		return result;
#line 4949 "tracker-needle.c"
	}
#line 844 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_init (&args_length1, &args);
#line 846 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 847 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 848 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	textdomain (GETTEXT_PACKAGE);
#line 850 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp39_ = tracker_needle_new ();
#line 850 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	n = _tmp39_;
#line 851 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp40_ = n;
#line 851 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_show (_tmp40_);
#line 853 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp41_ = n;
#line 853 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp42_ = search_criteria;
#line 853 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tmp42__length1 = _vala_array_length (search_criteria);
#line 853 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	tracker_needle_set_search (_tmp41_, _tmp42_, _tmp42__length1);
#line 855 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	gtk_main ();
#line 857 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	result = 0;
#line 857 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_tracker_needle_unref0 (n);
#line 857 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	_g_option_context_free0 (context);
#line 857 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return result;
#line 4985 "tracker-needle.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 814 "/home/carlos/Source/gnome/tracker/src/tracker-needle/tracker-needle.vala"
	return _vala_main (argv, argc);
#line 4995 "tracker-needle.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



