/* tracker-sparql-pattern.c generated by valac 0.36.3, the Vala compiler
 * generated from tracker-sparql-pattern.vala, do not modify */

/*
 * Copyright (C) 2008-2010, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "libtracker-data/tracker-class.h"
#include "libtracker-data/tracker-data-manager.h"
#include "libtracker-sparql/tracker-sparql.h"
#include "libtracker-data/tracker-ontologies.h"
#include "libtracker-data/tracker-data-backup.h"
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-data/tracker-db-interface.h"
#include "libtracker-data/tracker-property.h"


#define TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE (tracker_sparql_predicate_variable_get_type ())
#define TRACKER_SPARQL_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariable))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_IS_PREDICATE_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE))
#define TRACKER_SPARQL_PREDICATE_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariableClass))

typedef struct _TrackerSparqlPredicateVariable TrackerSparqlPredicateVariable;
typedef struct _TrackerSparqlPredicateVariableClass TrackerSparqlPredicateVariableClass;
typedef struct _TrackerSparqlPredicateVariablePrivate TrackerSparqlPredicateVariablePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TRACKER_SPARQL_TYPE_QUERY (tracker_sparql_query_get_type ())
#define TRACKER_SPARQL_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQuery))
#define TRACKER_SPARQL_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))
#define TRACKER_SPARQL_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_QUERY))
#define TRACKER_SPARQL_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_QUERY, TrackerSparqlQueryClass))

typedef struct _TrackerSparqlQuery TrackerSparqlQuery;
typedef struct _TrackerSparqlQueryClass TrackerSparqlQueryClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TRACKER_SPARQL_TYPE_DATA_BINDING (tracker_sparql_data_binding_get_type ())
#define TRACKER_SPARQL_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBinding))
#define TRACKER_SPARQL_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))
#define TRACKER_SPARQL_IS_DATA_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_IS_DATA_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_BINDING))
#define TRACKER_SPARQL_DATA_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_BINDING, TrackerSparqlDataBindingClass))

typedef struct _TrackerSparqlDataBinding TrackerSparqlDataBinding;
typedef struct _TrackerSparqlDataBindingClass TrackerSparqlDataBindingClass;

#define TRACKER_SPARQL_TYPE_LITERAL_BINDING (tracker_sparql_literal_binding_get_type ())
#define TRACKER_SPARQL_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBinding))
#define TRACKER_SPARQL_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))
#define TRACKER_SPARQL_IS_LITERAL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_IS_LITERAL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_LITERAL_BINDING))
#define TRACKER_SPARQL_LITERAL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_LITERAL_BINDING, TrackerSparqlLiteralBindingClass))

typedef struct _TrackerSparqlLiteralBinding TrackerSparqlLiteralBinding;
typedef struct _TrackerSparqlLiteralBindingClass TrackerSparqlLiteralBindingClass;
typedef struct _TrackerSparqlDataBindingPrivate TrackerSparqlDataBindingPrivate;

#define TRACKER_SPARQL_TYPE_DATA_TABLE (tracker_sparql_data_table_get_type ())
#define TRACKER_SPARQL_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTable))
#define TRACKER_SPARQL_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))
#define TRACKER_SPARQL_IS_DATA_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_IS_DATA_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_DATA_TABLE))
#define TRACKER_SPARQL_DATA_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_DATA_TABLE, TrackerSparqlDataTableClass))

typedef struct _TrackerSparqlDataTable TrackerSparqlDataTable;
typedef struct _TrackerSparqlDataTableClass TrackerSparqlDataTableClass;
typedef struct _TrackerSparqlLiteralBindingPrivate TrackerSparqlLiteralBindingPrivate;
typedef struct _TrackerSparqlQueryPrivate TrackerSparqlQueryPrivate;

#define TRACKER_SPARQL_TYPE_EXPRESSION (tracker_sparql_expression_get_type ())
#define TRACKER_SPARQL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpression))
#define TRACKER_SPARQL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))
#define TRACKER_SPARQL_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_EXPRESSION))
#define TRACKER_SPARQL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_EXPRESSION, TrackerSparqlExpressionClass))

typedef struct _TrackerSparqlExpression TrackerSparqlExpression;
typedef struct _TrackerSparqlExpressionClass TrackerSparqlExpressionClass;

#define TRACKER_SPARQL_TYPE_PATTERN (tracker_sparql_pattern_get_type ())
#define TRACKER_SPARQL_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern))
#define TRACKER_SPARQL_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))
#define TRACKER_SPARQL_IS_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_IS_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_PATTERN))
#define TRACKER_SPARQL_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternClass))

typedef struct _TrackerSparqlPattern TrackerSparqlPattern;
typedef struct _TrackerSparqlPatternClass TrackerSparqlPatternClass;

#define TRACKER_SPARQL_TYPE_CONTEXT (tracker_sparql_context_get_type ())
#define TRACKER_SPARQL_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContext))
#define TRACKER_SPARQL_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))
#define TRACKER_SPARQL_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_CONTEXT))
#define TRACKER_SPARQL_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_CONTEXT, TrackerSparqlContextClass))

typedef struct _TrackerSparqlContext TrackerSparqlContext;
typedef struct _TrackerSparqlContextClass TrackerSparqlContextClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TrackerSparqlPatternPrivate TrackerSparqlPatternPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE (tracker_sparql_variable_get_type ())
#define TRACKER_SPARQL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariable))
#define TRACKER_SPARQL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))
#define TRACKER_SPARQL_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE))
#define TRACKER_SPARQL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE, TrackerSparqlVariableClass))

typedef struct _TrackerSparqlVariable TrackerSparqlVariable;
typedef struct _TrackerSparqlVariableClass TrackerSparqlVariableClass;

#define TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT (tracker_sparql_pattern_triple_context_get_type ())
#define TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, TrackerSparqlPatternTripleContext))
#define TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, TrackerSparqlPatternTripleContextClass))
#define TRACKER_SPARQL_PATTERN_IS_TRIPLE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT))
#define TRACKER_SPARQL_PATTERN_IS_TRIPLE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT))
#define TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, TrackerSparqlPatternTripleContextClass))

typedef struct _TrackerSparqlPatternTripleContext TrackerSparqlPatternTripleContext;
typedef struct _TrackerSparqlPatternTripleContextClass TrackerSparqlPatternTripleContextClass;
#define _tracker_sparql_context_unref0(var) ((var == NULL) ? NULL : (var = (tracker_sparql_context_unref (var), NULL)))

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

#define TRACKER_TYPE_SOURCE_LOCATION (tracker_source_location_get_type ())
typedef struct _TrackerSourceLocation TrackerSourceLocation;

#define TRACKER_SPARQL_TYPE_SELECT_CONTEXT (tracker_sparql_select_context_get_type ())
#define TRACKER_SPARQL_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContext))
#define TRACKER_SPARQL_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_IS_SELECT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_SELECT_CONTEXT))
#define TRACKER_SPARQL_SELECT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_SELECT_CONTEXT, TrackerSparqlSelectContextClass))

typedef struct _TrackerSparqlSelectContext TrackerSparqlSelectContext;
typedef struct _TrackerSparqlSelectContextClass TrackerSparqlSelectContextClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _TrackerSparqlContextPrivate TrackerSparqlContextPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE_STATE (tracker_sparql_variable_state_get_type ())
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _TrackerSparqlVariablePrivate TrackerSparqlVariablePrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING (tracker_sparql_variable_binding_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBinding))
#define TRACKER_SPARQL_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING))
#define TRACKER_SPARQL_VARIABLE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING, TrackerSparqlVariableBindingClass))

typedef struct _TrackerSparqlVariableBinding TrackerSparqlVariableBinding;
typedef struct _TrackerSparqlVariableBindingClass TrackerSparqlVariableBindingClass;
typedef struct _TrackerSparqlSelectContextPrivate TrackerSparqlSelectContextPrivate;
typedef struct _TrackerSparqlPatternTripleContextPrivate TrackerSparqlPatternTripleContextPrivate;

#define TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST (tracker_sparql_variable_binding_list_get_type ())
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingList))
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingListClass))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST))
#define TRACKER_SPARQL_IS_VARIABLE_BINDING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST))
#define TRACKER_SPARQL_VARIABLE_BINDING_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_SPARQL_TYPE_VARIABLE_BINDING_LIST, TrackerSparqlVariableBindingListClass))

typedef struct _TrackerSparqlVariableBindingList TrackerSparqlVariableBindingList;
typedef struct _TrackerSparqlVariableBindingListClass TrackerSparqlVariableBindingListClass;
typedef struct _TrackerSparqlDataTablePrivate TrackerSparqlDataTablePrivate;
typedef struct _TrackerSparqlVariableBindingListPrivate TrackerSparqlVariableBindingListPrivate;
typedef struct _TrackerSparqlVariableBindingPrivate TrackerSparqlVariableBindingPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TrackerSparqlPredicateVariable {
	GObject parent_instance;
	TrackerSparqlPredicateVariablePrivate * priv;
	gchar* subject;
	gchar* object;
	gboolean return_graph;
	TrackerClass* domain;
};

struct _TrackerSparqlPredicateVariableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlPredicateVariablePrivate {
	TrackerDataManager* manager;
};

struct _TrackerSparqlDataBinding {
	GObject parent_instance;
	TrackerSparqlDataBindingPrivate * priv;
	TrackerPropertyType data_type;
	TrackerSparqlDataTable* table;
	gchar* sql_db_column_name;
};

struct _TrackerSparqlDataBindingClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlLiteralBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlLiteralBindingPrivate * priv;
	gboolean is_fts_match;
	gchar* literal;
};

struct _TrackerSparqlLiteralBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};

struct _TrackerSparqlQuery {
	GObject parent_instance;
	TrackerSparqlQueryPrivate * priv;
	TrackerSparqlExpression* expression;
	TrackerSparqlPattern* pattern;
	GList* bindings;
	TrackerSparqlContext* context;
	TrackerDataManager* manager;
	gint last_var_index;
};

struct _TrackerSparqlQueryClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlPattern {
	GObject parent_instance;
	TrackerSparqlPatternPrivate * priv;
	gchar* current_graph;
	TrackerSparqlVariable* fts_subject;
	gchar** fts_variables;
	gint fts_variables_length1;
	gint _fts_variables_size_;
	GString* match_str;
	gboolean queries_fts_data;
};

struct _TrackerSparqlPatternClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlPatternPrivate {
	TrackerSparqlQuery* query;
	TrackerSparqlExpression* expression;
	gint counter;
	gint next_table_index;
	gboolean current_graph_is_var;
	gchar* current_subject;
	gboolean current_subject_is_var;
	gchar* current_predicate;
	gboolean current_predicate_is_var;
	TrackerDataManager* manager;
	TrackerSparqlPatternTripleContext* triple_context;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_ABS,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BIND,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CEIL,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COALESCE,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_CONTAINS,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATA,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DAY,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FLOOR,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_HAVING,
	TRACKER_SPARQL_TOKEN_TYPE_HOURS,
	TRACKER_SPARQL_TOKEN_TYPE_IF,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LCASE,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MD5,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_MINUTES,
	TRACKER_SPARQL_TOKEN_TYPE_MONTH,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_NOW,
	TRACKER_SPARQL_TOKEN_TYPE_NULL,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_OR,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_RAND,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_REPLACE,
	TRACKER_SPARQL_TOKEN_TYPE_ROUND,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SECONDS,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SHA1,
	TRACKER_SPARQL_TOKEN_TYPE_SHA256,
	TRACKER_SPARQL_TOKEN_TYPE_SHA512,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRAFTER,
	TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE,
	TRACKER_SPARQL_TOKEN_TYPE_STRENDS,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_STRLEN,
	TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS,
	TRACKER_SPARQL_TOKEN_TYPE_SUBSTR,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UCASE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH,
	TRACKER_SPARQL_TOKEN_TYPE_YEAR
} TrackerSparqlTokenType;

struct _TrackerSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

struct _TrackerSparqlContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerSparqlContextPrivate * priv;
	TrackerSparqlQuery* query;
	TrackerSparqlContext* parent_context;
	GHashTable* var_set;
	GHashTable* var_map;
	GHashTable* select_var_set;
	GHashTable* predicate_variable_map;
	gboolean scalar_subquery;
	gboolean need_binding_expression;
};

struct _TrackerSparqlContextClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerSparqlContext *self);
};

typedef enum  {
	TRACKER_SPARQL_VARIABLE_STATE_NONE,
	TRACKER_SPARQL_VARIABLE_STATE_BOUND,
	TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL
} TrackerSparqlVariableState;

struct _TrackerSparqlVariable {
	GObject parent_instance;
	TrackerSparqlVariablePrivate * priv;
	TrackerSparqlVariableBinding* binding;
};

struct _TrackerSparqlVariableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlSelectContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlSelectContextPrivate * priv;
	TrackerPropertyType type;
	TrackerPropertyType* types;
	gint types_length1;
	gint _types_size_;
	gchar** variable_names;
	gint variable_names_length1;
	gint _variable_names_size_;
};

struct _TrackerSparqlSelectContextClass {
	TrackerSparqlContextClass parent_class;
};

struct _TrackerSparqlPatternTripleContext {
	TrackerSparqlContext parent_instance;
	TrackerSparqlPatternTripleContextPrivate * priv;
	GList* tables;
	GHashTable* table_map;
	GList* bindings;
	GList* variables;
	GHashTable* var_bindings;
};

struct _TrackerSparqlPatternTripleContextClass {
	TrackerSparqlContextClass parent_class;
};

struct _TrackerSparqlDataTable {
	GObject parent_instance;
	TrackerSparqlDataTablePrivate * priv;
	gchar* sql_db_tablename;
	gchar* sql_query_tablename;
	TrackerSparqlPredicateVariable* predicate_variable;
};

struct _TrackerSparqlDataTableClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariableBindingList {
	GObject parent_instance;
	TrackerSparqlVariableBindingListPrivate * priv;
	GList* list;
};

struct _TrackerSparqlVariableBindingListClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlVariableBinding {
	TrackerSparqlDataBinding parent_instance;
	TrackerSparqlVariableBindingPrivate * priv;
	TrackerSparqlVariable* variable;
	gboolean maybe_null;
	gboolean in_simple_optional;
	TrackerClass* type;
};

struct _TrackerSparqlVariableBindingClass {
	TrackerSparqlDataBindingClass parent_class;
};


static gpointer tracker_sparql_predicate_variable_parent_class = NULL;
static gpointer tracker_sparql_pattern_parent_class = NULL;
static gpointer tracker_sparql_pattern_triple_context_parent_class = NULL;

GType tracker_sparql_predicate_variable_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_PREDICATE_VARIABLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariablePrivate))
enum  {
	TRACKER_SPARQL_PREDICATE_VARIABLE_DUMMY_PROPERTY
};
TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_new (TrackerDataManager* manager);
TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_construct (GType object_type, TrackerDataManager* manager);
GType tracker_sparql_query_get_type (void) G_GNUC_CONST;
gchar* tracker_sparql_predicate_variable_get_sql_query (TrackerSparqlPredicateVariable* self, TrackerSparqlQuery* query, GError** error);
void tracker_sparql_expression_append_expression_as_string (GString* sql, const gchar* expression, TrackerPropertyType type);
GType tracker_sparql_data_binding_get_type (void) G_GNUC_CONST;
GType tracker_sparql_literal_binding_get_type (void) G_GNUC_CONST;
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_new (void);
TrackerSparqlLiteralBinding* tracker_sparql_literal_binding_construct (GType object_type);
GType tracker_sparql_data_table_get_type (void) G_GNUC_CONST;
GType tracker_sparql_expression_get_type (void) G_GNUC_CONST;
GType tracker_sparql_pattern_get_type (void) G_GNUC_CONST;
gpointer tracker_sparql_context_ref (gpointer instance);
void tracker_sparql_context_unref (gpointer instance);
GParamSpec* tracker_sparql_param_spec_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_sparql_value_set_context (GValue* value, gpointer v_object);
void tracker_sparql_value_take_context (GValue* value, gpointer v_object);
gpointer tracker_sparql_value_get_context (const GValue* value);
GType tracker_sparql_context_get_type (void) G_GNUC_CONST;
GError* tracker_sparql_query_get_internal_error (TrackerSparqlQuery* self, const gchar* msg);
static void tracker_sparql_predicate_variable_finalize (GObject * obj);
GType tracker_sparql_variable_get_type (void) G_GNUC_CONST;
static GType tracker_sparql_pattern_triple_context_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define TRACKER_SPARQL_PATTERN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPatternPrivate))
enum  {
	TRACKER_SPARQL_PATTERN_DUMMY_PROPERTY
};
TrackerSparqlPattern* tracker_sparql_pattern_new (TrackerSparqlQuery* query);
TrackerSparqlPattern* tracker_sparql_pattern_construct (GType object_type, TrackerSparqlQuery* query);
static inline gboolean tracker_sparql_pattern_next (TrackerSparqlPattern* self, GError** error);
gboolean tracker_sparql_query_next (TrackerSparqlQuery* self, GError** error);
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
static inline TrackerSparqlTokenType tracker_sparql_pattern_current (TrackerSparqlPattern* self);
TrackerSparqlTokenType tracker_sparql_query_current (TrackerSparqlQuery* self);
static inline gboolean tracker_sparql_pattern_accept (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error);
gboolean tracker_sparql_query_accept (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
static GError* tracker_sparql_pattern_get_error (TrackerSparqlPattern* self, const gchar* msg);
GError* tracker_sparql_query_get_error (TrackerSparqlQuery* self, const gchar* msg);
static gboolean tracker_sparql_pattern_expect (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error);
gboolean tracker_sparql_query_expect (TrackerSparqlQuery* self, TrackerSparqlTokenType type, GError** error);
GType tracker_source_location_get_type (void) G_GNUC_CONST;
TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self);
void tracker_source_location_free (TrackerSourceLocation* self);
static void tracker_sparql_pattern_get_location (TrackerSparqlPattern* self, TrackerSourceLocation* result);
void tracker_sparql_query_get_location (TrackerSparqlQuery* self, TrackerSourceLocation* result);
static void tracker_sparql_pattern_set_location (TrackerSparqlPattern* self, TrackerSourceLocation* location);
void tracker_sparql_query_set_location (TrackerSparqlQuery* self, TrackerSourceLocation* location);
static gchar* tracker_sparql_pattern_get_last_string (TrackerSparqlPattern* self, gint strip);
gchar* tracker_sparql_query_get_last_string (TrackerSparqlQuery* self, gint strip);
GType tracker_sparql_select_context_get_type (void) G_GNUC_CONST;
TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self, GString* sql, gboolean subquery, gboolean scalar_subquery, GError** error);
static TrackerSparqlContext* tracker_sparql_pattern_get_context (TrackerSparqlPattern* self);
TrackerSparqlSelectContext* tracker_sparql_select_context_new_subquery (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_construct_subquery (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlSelectContext* tracker_sparql_select_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
static void tracker_sparql_pattern_set_context (TrackerSparqlPattern* self, TrackerSparqlContext* value);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void tracker_sparql_expression_skip_select_variables (TrackerSparqlExpression* self, GError** error);
TrackerSparqlContext* tracker_sparql_pattern_translate_group_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error);
GType tracker_sparql_variable_state_get_type (void) G_GNUC_CONST;
GType tracker_sparql_variable_binding_get_type (void) G_GNUC_CONST;
const gchar* tracker_sparql_variable_get_name (TrackerSparqlVariable* self);
const gchar* tracker_sparql_variable_get_sql_expression (TrackerSparqlVariable* self);
static void _vala_array_add5 (TrackerPropertyType* * array, int* length, int* size, TrackerPropertyType value);
static void _vala_array_add6 (gchar** * array, int* length, int* size, gchar* value);
TrackerPropertyType tracker_sparql_expression_translate_select_expression (TrackerSparqlExpression* self, GString* sql, gboolean subquery, gint variable_index, GError** error);
static void _vala_array_add7 (TrackerPropertyType* * array, int* length, int* size, TrackerPropertyType value);
TrackerPropertyType tracker_sparql_expression_translate_expression (TrackerSparqlExpression* self, GString* sql, GError** error);
TrackerPropertyType tracker_sparql_expression_translate_constraint (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_expression_translate_order_condition (TrackerSparqlExpression* self, GString* sql, GError** error);
void tracker_sparql_pattern_translate_exists (TrackerSparqlPattern* self, GString* sql, GError** error);
gchar* tracker_sparql_pattern_parse_var_or_term (TrackerSparqlPattern* self, GString* sql, gboolean* is_var, GError** error);
gchar* tracker_sparql_query_resolve_prefixed_name (TrackerSparqlQuery* self, const gchar* prefix, const gchar* local_name, GError** error);
gchar* tracker_sparql_query_generate_bnodeid (TrackerSparqlQuery* self, const gchar* user_bnodeid);
gchar* tracker_sparql_expression_parse_string_literal (TrackerSparqlExpression* self, TrackerPropertyType* type, GError** error);
static void tracker_sparql_pattern_parse_property_list_not_empty (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error);
static void tracker_sparql_pattern_parse_object_list (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error);
static void tracker_sparql_pattern_parse_object (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error);
static void tracker_sparql_pattern_translate_filter (TrackerSparqlPattern* self, GString* sql, GError** error);
static void tracker_sparql_pattern_skip_filter (TrackerSparqlPattern* self, GError** error);
static void tracker_sparql_pattern_start_triples_block (TrackerSparqlPattern* self, GString* sql, GError** error);
static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
static void tracker_sparql_pattern_end_triples_block (TrackerSparqlPattern* self, GString* sql, gboolean* first_where, gboolean in_group_graph_pattern, GError** error);
GType tracker_sparql_variable_binding_list_get_type (void) G_GNUC_CONST;
const gchar* tracker_sparql_data_binding_get_sql_expression (TrackerSparqlDataBinding* self);
static void tracker_sparql_pattern_parse_triples (TrackerSparqlPattern* self, GString* sql, glong group_graph_pattern_start, gboolean* in_triples_block, gboolean* first_where, gboolean* in_group_graph_pattern, gboolean found_simple_optional, GError** error);
static gboolean tracker_sparql_pattern_is_subclass (TrackerSparqlPattern* self, TrackerClass* class1, TrackerClass* class2);
static gboolean tracker_sparql_pattern_is_simple_optional (TrackerSparqlPattern* self);
TrackerSparqlVariable* tracker_sparql_context_get_variable (TrackerSparqlContext* self, const gchar* name);
guint tracker_sparql_variable_hash (TrackerSparqlVariable* variable);
static guint _tracker_sparql_variable_hash_ghash_func (gconstpointer key);
gboolean tracker_sparql_variable_equal (TrackerSparqlVariable* a, TrackerSparqlVariable* b);
static gboolean _tracker_sparql_variable_equal_gequal_func (gconstpointer a, gconstpointer b);
TrackerSparqlContext* tracker_sparql_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
TrackerSparqlContext* tracker_sparql_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context);
gchar* tracker_sparql_variable_get_extra_sql_expression (TrackerSparqlVariable* self, const gchar* suffix);
static void tracker_sparql_pattern_translate_group_or_union_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_new (void);
TrackerSparqlVariableBinding* tracker_sparql_variable_binding_construct (GType object_type);
void tracker_sparql_data_binding_set_sql_expression (TrackerSparqlDataBinding* self, const gchar* value);
void tracker_sparql_pattern_add_variable_binding (TrackerSparqlPattern* self, GString* sql, TrackerSparqlVariableBinding* binding, TrackerSparqlVariableState variable_state);
static void _vala_array_add8 (TrackerSourceLocation* * array, int* length, int* size, const TrackerSourceLocation* value);
static void _vala_array_add9 (glong* * array, int* length, int* size, glong value);
static void _vala_array_add10 (TrackerSparqlContext** * array, int* length, int* size, TrackerSparqlContext* value);
static void _vala_array_add11 (TrackerSparqlVariable** * array, int* length, int* size, TrackerSparqlVariable* value);
static TrackerSparqlVariableBindingList* tracker_sparql_pattern_get_variable_binding_list (TrackerSparqlPattern* self, TrackerSparqlVariable* variable);
TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_new (void);
TrackerSparqlVariableBindingList* tracker_sparql_variable_binding_list_construct (GType object_type);
gchar* tracker_sparql_data_binding_get_extra_sql_expression (TrackerSparqlDataBinding* self, const gchar* suffix);
static TrackerSparqlDataTable* tracker_sparql_pattern_get_table (TrackerSparqlPattern* self, const gchar* subject, const gchar* db_table, gboolean share_table, gboolean* newtable);
TrackerSparqlDataTable* tracker_sparql_data_table_new (void);
TrackerSparqlDataTable* tracker_sparql_data_table_construct (GType object_type);
enum  {
	TRACKER_SPARQL_PATTERN_TRIPLE_CONTEXT_DUMMY_PROPERTY
};
static void tracker_sparql_pattern_triple_context_finalize (TrackerSparqlContext * obj);
static void tracker_sparql_pattern_finalize (GObject * obj);
static void _vala_tracker_sparql_pattern_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_sparql_pattern_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
#line 32 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return self ? g_object_ref (self) : NULL;
#line 659 "tracker-sparql-pattern.c"
}


TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_construct (GType object_type, TrackerDataManager* manager) {
	TrackerSparqlPredicateVariable * self = NULL;
	TrackerDataManager* _tmp0_;
	TrackerDataManager* _tmp1_;
#line 31 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (manager != NULL, NULL);
#line 31 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self = (TrackerSparqlPredicateVariable*) g_object_new (object_type, NULL);
#line 32 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = manager;
#line 32 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 32 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (self->priv->manager);
#line 32 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->priv->manager = _tmp1_;
#line 31 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return self;
#line 681 "tracker-sparql-pattern.c"
}


TrackerSparqlPredicateVariable* tracker_sparql_predicate_variable_new (TrackerDataManager* manager) {
#line 31 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return tracker_sparql_predicate_variable_construct (TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, manager);
#line 688 "tracker-sparql-pattern.c"
}


gchar* tracker_sparql_predicate_variable_get_sql_query (TrackerSparqlPredicateVariable* self, TrackerSparqlQuery* query, GError** error) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 35 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 35 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 699 "tracker-sparql-pattern.c"
	{
		GString* sql = NULL;
		GString* _tmp0_;
		TrackerOntologies* ontologies = NULL;
		TrackerDataManager* _tmp1_;
		TrackerOntologies* _tmp2_;
		TrackerOntologies* _tmp3_;
		const gchar* _tmp4_;
		GString* _tmp166_;
		const gchar* _tmp167_;
		gchar* _tmp168_;
#line 37 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp0_ = g_string_new ("");
#line 37 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		sql = _tmp0_;
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp1_ = self->priv->manager;
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = tracker_data_manager_get_ontologies (_tmp1_);
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		ontologies = _tmp3_;
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = self->subject;
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp4_ != NULL) {
#line 727 "tracker-sparql-pattern.c"
			gint subject_id = 0;
			TrackerDataManager* _tmp5_;
			const gchar* _tmp6_;
			gint _tmp7_;
			TrackerDBCursor* cursor = NULL;
			gint _tmp8_;
			gboolean first = FALSE;
			TrackerDBCursor* _tmp20_;
			gboolean _tmp71_;
#line 42 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp5_ = self->priv->manager;
#line 42 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp6_ = self->subject;
#line 42 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp7_ = tracker_data_query_resource_id (_tmp5_, _tmp6_);
#line 42 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			subject_id = _tmp7_;
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			cursor = NULL;
#line 45 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp8_ = subject_id;
#line 45 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp8_ > 0) {
#line 751 "tracker-sparql-pattern.c"
				TrackerDBInterface* iface = NULL;
				TrackerDataManager* _tmp9_;
				TrackerDBInterface* _tmp10_;
				TrackerDBInterface* _tmp11_;
				TrackerDBStatement* stmt = NULL;
				TrackerDBInterface* _tmp12_;
				TrackerDBStatement* _tmp13_;
				TrackerDBStatement* _tmp14_;
				gint _tmp15_;
				TrackerDBCursor* _tmp16_ = NULL;
				TrackerDBStatement* _tmp17_;
				TrackerDBCursor* _tmp18_;
				TrackerDBCursor* _tmp19_;
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp9_ = self->priv->manager;
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp10_ = tracker_data_manager_get_db_interface (_tmp9_);
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp11_ = _g_object_ref0 (_tmp10_);
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				iface = _tmp11_;
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp12_ = iface;
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp13_ = tracker_db_interface_create_statement (_tmp12_, TRACKER_DB_STATEMENT_CACHE_TYPE_SELECT, &_inner_error_, "SELECT (SELECT Uri FROM Resource WHERE ID = \"rdf:type\") " "FROM \"rdfs:Resource_rdf:type\" WHERE ID = ?");
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				stmt = _tmp13_;
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (iface);
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (cursor);
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (ontologies);
#line 47 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (sql);
#line 789 "tracker-sparql-pattern.c"
					goto __catch0_g_error;
				}
#line 50 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp14_ = stmt;
#line 50 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp15_ = subject_id;
#line 50 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_db_statement_bind_int (_tmp14_, 0, _tmp15_);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp17_ = stmt;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp18_ = tracker_db_statement_start_cursor (_tmp17_, &_inner_error_);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp16_ = _tmp18_;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (stmt);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (iface);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (cursor);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (ontologies);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (sql);
#line 816 "tracker-sparql-pattern.c"
					goto __catch0_g_error;
				}
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp19_ = _tmp16_;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp16_ = NULL;
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (cursor);
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				cursor = _tmp19_;
#line 45 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (_tmp16_);
#line 45 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (stmt);
#line 45 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (iface);
#line 833 "tracker-sparql-pattern.c"
			}
#line 54 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			first = TRUE;
#line 55 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp20_ = cursor;
#line 55 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp20_ != NULL) {
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				while (TRUE) {
#line 843 "tracker-sparql-pattern.c"
					gboolean _tmp21_ = FALSE;
					TrackerDBCursor* _tmp22_;
					gboolean _tmp23_;
					TrackerClass* domain = NULL;
					TrackerOntologies* _tmp24_;
					TrackerDBCursor* _tmp25_;
					const gchar* _tmp26_;
					TrackerClass* _tmp27_;
					TrackerClass* _tmp28_;
					TrackerOntologies* _tmp29_;
					gint _tmp30_;
					TrackerProperty** _tmp31_;
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp22_ = cursor;
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp23_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) _tmp22_, NULL, &_inner_error_);
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp21_ = _tmp23_;
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (cursor);
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (ontologies);
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (sql);
#line 870 "tracker-sparql-pattern.c"
						goto __catch0_g_error;
					}
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp21_) {
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						break;
#line 877 "tracker-sparql-pattern.c"
					}
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp24_ = ontologies;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp25_ = cursor;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp26_ = tracker_sparql_cursor_get_string ((TrackerSparqlCursor*) _tmp25_, 0, NULL);
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp27_ = tracker_ontologies_get_class_by_uri (_tmp24_, _tmp26_);
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp28_ = _g_object_ref0 (_tmp27_);
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					domain = _tmp28_;
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp29_ = ontologies;
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp31_ = tracker_ontologies_get_properties (_tmp29_, &_tmp30_);
#line 895 "tracker-sparql-pattern.c"
					{
						TrackerProperty** prop_collection = NULL;
						gint prop_collection_length1 = 0;
						gint _prop_collection_size_ = 0;
						gint prop_it = 0;
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						prop_collection = _tmp31_;
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						prop_collection_length1 = _tmp30_;
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						for (prop_it = 0; prop_it < _tmp30_; prop_it = prop_it + 1) {
#line 907 "tracker-sparql-pattern.c"
							TrackerProperty* _tmp32_;
							TrackerProperty* prop = NULL;
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp32_ = _g_object_ref0 (prop_collection[prop_it]);
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							prop = _tmp32_;
#line 914 "tracker-sparql-pattern.c"
							{
								TrackerProperty* _tmp33_;
								TrackerClass* _tmp34_;
								TrackerClass* _tmp35_;
								TrackerClass* _tmp36_;
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp33_ = prop;
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp34_ = tracker_property_get_domain (_tmp33_);
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp35_ = _tmp34_;
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp36_ = domain;
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp35_ == _tmp36_) {
#line 930 "tracker-sparql-pattern.c"
									gboolean _tmp37_;
									GString* _tmp39_;
									TrackerProperty* _tmp40_;
									const gchar* _tmp41_;
									const gchar* _tmp42_;
									GString* _tmp43_;
									TrackerProperty* _tmp44_;
									const gchar* _tmp45_;
									const gchar* _tmp46_;
									gchar* _tmp47_;
									gchar* _tmp48_;
									TrackerProperty* _tmp49_;
									TrackerPropertyType _tmp50_;
									TrackerPropertyType _tmp51_;
									GString* _tmp52_;
									gboolean _tmp53_;
									GString* _tmp58_;
									TrackerProperty* _tmp59_;
									const gchar* _tmp60_;
									const gchar* _tmp61_;
									GString* _tmp62_;
									TrackerSparqlLiteralBinding* binding = NULL;
									TrackerSparqlLiteralBinding* _tmp63_;
									TrackerSparqlLiteralBinding* _tmp64_;
									gint _tmp65_;
									gchar* _tmp66_;
									TrackerSparqlLiteralBinding* _tmp67_;
									TrackerSparqlQuery* _tmp68_;
									TrackerSparqlLiteralBinding* _tmp69_;
									TrackerSparqlLiteralBinding* _tmp70_;
#line 61 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp37_ = first;
#line 61 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp37_) {
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										first = FALSE;
#line 967 "tracker-sparql-pattern.c"
									} else {
										GString* _tmp38_;
#line 64 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp38_ = sql;
#line 64 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append (_tmp38_, " UNION ALL ");
#line 974 "tracker-sparql-pattern.c"
									}
#line 66 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp39_ = sql;
#line 66 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp40_ = prop;
#line 66 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp41_ = tracker_property_get_uri (_tmp40_);
#line 66 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp42_ = _tmp41_;
#line 66 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp39_, "SELECT ID, (SELECT ID FROM Resource WHERE Uri = '%s') AS \"predicate\"" \
", ", _tmp42_);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp43_ = sql;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp44_ = prop;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp45_ = tracker_property_get_name (_tmp44_);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp46_ = _tmp45_;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp47_ = g_strdup_printf ("\"%s\"", _tmp46_);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp48_ = _tmp47_;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp49_ = prop;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp50_ = tracker_property_get_data_type (_tmp49_);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp51_ = _tmp50_;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									tracker_sparql_expression_append_expression_as_string (_tmp43_, _tmp48_, _tmp51_);
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_tmp48_);
#line 70 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp52_ = sql;
#line 70 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp52_, " AS \"object\"");
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp53_ = self->return_graph;
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp53_) {
#line 1016 "tracker-sparql-pattern.c"
										GString* _tmp54_;
										TrackerProperty* _tmp55_;
										const gchar* _tmp56_;
										const gchar* _tmp57_;
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp54_ = sql;
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp55_ = prop;
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp56_ = tracker_property_get_name (_tmp55_);
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp57_ = _tmp56_;
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp54_, ", \"%s:graph\" AS \"graph\"", _tmp57_);
#line 1031 "tracker-sparql-pattern.c"
									}
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp58_ = sql;
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp59_ = prop;
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp60_ = tracker_property_get_table_name (_tmp59_);
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp61_ = _tmp60_;
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp58_, " FROM \"%s\"", _tmp61_);
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp62_ = sql;
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp62_, " WHERE ID = ?");
#line 78 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp63_ = tracker_sparql_literal_binding_new ();
#line 78 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									binding = _tmp63_;
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp64_ = binding;
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp65_ = subject_id;
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp66_ = g_strdup_printf ("%i", _tmp65_);
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_tmp64_->literal);
#line 79 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp64_->literal = _tmp66_;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp67_ = binding;
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									((TrackerSparqlDataBinding*) _tmp67_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp68_ = query;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp69_ = binding;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp70_ = _g_object_ref0 (_tmp69_);
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp68_->bindings = g_list_append (_tmp68_->bindings, _tmp70_);
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_object_unref0 (binding);
#line 1075 "tracker-sparql-pattern.c"
								}
#line 59 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_object_unref0 (prop);
#line 1079 "tracker-sparql-pattern.c"
							}
						}
					}
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (domain);
#line 1085 "tracker-sparql-pattern.c"
				}
			}
#line 87 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp71_ = first;
#line 87 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp71_) {
#line 1092 "tracker-sparql-pattern.c"
				GString* _tmp72_;
#line 89 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp72_ = sql;
#line 89 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append (_tmp72_, "SELECT NULL AS ID, NULL AS \"predicate\", NULL AS \"object\", NULL AS " \
"\"graph\"");
#line 1098 "tracker-sparql-pattern.c"
			}
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (cursor);
#line 1102 "tracker-sparql-pattern.c"
		} else {
			const gchar* _tmp73_;
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp73_ = self->object;
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp73_ != NULL) {
#line 1109 "tracker-sparql-pattern.c"
				gint object_id = 0;
				TrackerDataManager* _tmp74_;
				const gchar* _tmp75_;
				gint _tmp76_;
				TrackerDBInterface* iface = NULL;
				TrackerDataManager* _tmp77_;
				TrackerDBInterface* _tmp78_;
				TrackerDBInterface* _tmp79_;
				TrackerDBStatement* stmt = NULL;
				TrackerDBInterface* _tmp80_;
				TrackerDBStatement* _tmp81_;
				TrackerDBStatement* _tmp82_;
				gint _tmp83_;
				TrackerDBCursor* cursor = NULL;
				TrackerDBStatement* _tmp84_;
				TrackerDBCursor* _tmp85_;
				gboolean first = FALSE;
				TrackerDBCursor* _tmp86_;
				gboolean _tmp128_;
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp74_ = self->priv->manager;
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp75_ = self->object;
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp76_ = tracker_data_query_resource_id (_tmp74_, _tmp75_);
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				object_id = _tmp76_;
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp77_ = self->priv->manager;
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp78_ = tracker_data_manager_get_db_interface (_tmp77_);
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp79_ = _g_object_ref0 (_tmp78_);
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				iface = _tmp79_;
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp80_ = iface;
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp81_ = tracker_db_interface_create_statement (_tmp80_, TRACKER_DB_STATEMENT_CACHE_TYPE_SELECT, &_inner_error_, "SELECT (SELECT Uri FROM Resource WHERE ID = \"rdf:type\") " "FROM \"rdfs:Resource_rdf:type\" WHERE ID = ?");
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				stmt = _tmp81_;
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (iface);
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (ontologies);
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (sql);
#line 1159 "tracker-sparql-pattern.c"
					goto __catch0_g_error;
				}
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp82_ = stmt;
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp83_ = object_id;
#line 99 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_db_statement_bind_int (_tmp82_, 0, _tmp83_);
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp84_ = stmt;
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp85_ = tracker_db_statement_start_cursor (_tmp84_, &_inner_error_);
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				cursor = _tmp85_;
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (stmt);
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (iface);
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (ontologies);
#line 100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (sql);
#line 1184 "tracker-sparql-pattern.c"
					goto __catch0_g_error;
				}
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				first = TRUE;
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp86_ = cursor;
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp86_ != NULL) {
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					while (TRUE) {
#line 1195 "tracker-sparql-pattern.c"
						gboolean _tmp87_ = FALSE;
						TrackerDBCursor* _tmp88_;
						gboolean _tmp89_;
						TrackerClass* range = NULL;
						TrackerOntologies* _tmp90_;
						TrackerDBCursor* _tmp91_;
						const gchar* _tmp92_;
						TrackerClass* _tmp93_;
						TrackerClass* _tmp94_;
						TrackerOntologies* _tmp95_;
						gint _tmp96_;
						TrackerProperty** _tmp97_;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp88_ = cursor;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp89_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) _tmp88_, NULL, &_inner_error_);
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp87_ = _tmp89_;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (cursor);
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (stmt);
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (iface);
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (ontologies);
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (sql);
#line 1226 "tracker-sparql-pattern.c"
							goto __catch0_g_error;
						}
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (!_tmp87_) {
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							break;
#line 1233 "tracker-sparql-pattern.c"
						}
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp90_ = ontologies;
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp91_ = cursor;
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp92_ = tracker_sparql_cursor_get_string ((TrackerSparqlCursor*) _tmp91_, 0, NULL);
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp93_ = tracker_ontologies_get_class_by_uri (_tmp90_, _tmp92_);
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp94_ = _g_object_ref0 (_tmp93_);
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						range = _tmp94_;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp95_ = ontologies;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp97_ = tracker_ontologies_get_properties (_tmp95_, &_tmp96_);
#line 1251 "tracker-sparql-pattern.c"
						{
							TrackerProperty** prop_collection = NULL;
							gint prop_collection_length1 = 0;
							gint _prop_collection_size_ = 0;
							gint prop_it = 0;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							prop_collection = _tmp97_;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							prop_collection_length1 = _tmp96_;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							for (prop_it = 0; prop_it < _tmp96_; prop_it = prop_it + 1) {
#line 1263 "tracker-sparql-pattern.c"
								TrackerProperty* _tmp98_;
								TrackerProperty* prop = NULL;
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp98_ = _g_object_ref0 (prop_collection[prop_it]);
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								prop = _tmp98_;
#line 1270 "tracker-sparql-pattern.c"
								{
									TrackerProperty* _tmp99_;
									TrackerClass* _tmp100_;
									TrackerClass* _tmp101_;
									TrackerClass* _tmp102_;
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp99_ = prop;
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp100_ = tracker_property_get_range (_tmp99_);
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp101_ = _tmp100_;
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp102_ = range;
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp101_ == _tmp102_) {
#line 1286 "tracker-sparql-pattern.c"
										gboolean _tmp103_;
										GString* _tmp105_;
										TrackerProperty* _tmp106_;
										const gchar* _tmp107_;
										const gchar* _tmp108_;
										GString* _tmp109_;
										TrackerProperty* _tmp110_;
										const gchar* _tmp111_;
										const gchar* _tmp112_;
										gchar* _tmp113_;
										gchar* _tmp114_;
										TrackerProperty* _tmp115_;
										TrackerPropertyType _tmp116_;
										TrackerPropertyType _tmp117_;
										GString* _tmp118_;
										gboolean _tmp119_;
										GString* _tmp124_;
										TrackerProperty* _tmp125_;
										const gchar* _tmp126_;
										const gchar* _tmp127_;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp103_ = first;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										if (_tmp103_) {
#line 110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											first = FALSE;
#line 1313 "tracker-sparql-pattern.c"
										} else {
											GString* _tmp104_;
#line 112 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp104_ = sql;
#line 112 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											g_string_append (_tmp104_, " UNION ALL ");
#line 1320 "tracker-sparql-pattern.c"
										}
#line 114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp105_ = sql;
#line 114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp106_ = prop;
#line 114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp107_ = tracker_property_get_uri (_tmp106_);
#line 114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp108_ = _tmp107_;
#line 114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp105_, "SELECT ID, (SELECT ID FROM Resource WHERE Uri = '%s') AS \"predicate\"" \
", ", _tmp108_);
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp109_ = sql;
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp110_ = prop;
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp111_ = tracker_property_get_name (_tmp110_);
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp112_ = _tmp111_;
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp113_ = g_strdup_printf ("\"%s\"", _tmp112_);
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp114_ = _tmp113_;
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp115_ = prop;
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp116_ = tracker_property_get_data_type (_tmp115_);
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp117_ = _tmp116_;
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										tracker_sparql_expression_append_expression_as_string (_tmp109_, _tmp114_, _tmp117_);
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_g_free0 (_tmp114_);
#line 118 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp118_ = sql;
#line 118 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append (_tmp118_, " AS \"object\"");
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp119_ = self->return_graph;
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										if (_tmp119_) {
#line 1362 "tracker-sparql-pattern.c"
											GString* _tmp120_;
											TrackerProperty* _tmp121_;
											const gchar* _tmp122_;
											const gchar* _tmp123_;
#line 120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp120_ = sql;
#line 120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp121_ = prop;
#line 120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp122_ = tracker_property_get_name (_tmp121_);
#line 120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp123_ = _tmp122_;
#line 120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											g_string_append_printf (_tmp120_, ", \"%s:graph\" AS \"graph\"", _tmp123_);
#line 1377 "tracker-sparql-pattern.c"
										}
#line 122 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp124_ = sql;
#line 122 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp125_ = prop;
#line 122 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp126_ = tracker_property_get_table_name (_tmp125_);
#line 122 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp127_ = _tmp126_;
#line 122 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp124_, " FROM \"%s\"", _tmp127_);
#line 1389 "tracker-sparql-pattern.c"
									}
#line 107 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_object_unref0 (prop);
#line 1393 "tracker-sparql-pattern.c"
								}
							}
						}
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (range);
#line 1399 "tracker-sparql-pattern.c"
					}
				}
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp128_ = first;
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp128_) {
#line 1406 "tracker-sparql-pattern.c"
					GString* _tmp129_;
#line 130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp129_ = sql;
#line 130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp129_, "SELECT NULL AS ID, NULL AS \"predicate\", NULL AS \"object\", NULL AS " \
"\"graph\"");
#line 1412 "tracker-sparql-pattern.c"
				}
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (cursor);
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (stmt);
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (iface);
#line 1420 "tracker-sparql-pattern.c"
			} else {
				TrackerClass* _tmp130_;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp130_ = self->domain;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp130_ != NULL) {
#line 1427 "tracker-sparql-pattern.c"
					gboolean first = FALSE;
					TrackerOntologies* _tmp131_;
					gint _tmp132_;
					TrackerProperty** _tmp133_;
#line 134 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					first = TRUE;
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp131_ = ontologies;
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp133_ = tracker_ontologies_get_properties (_tmp131_, &_tmp132_);
#line 1438 "tracker-sparql-pattern.c"
					{
						TrackerProperty** prop_collection = NULL;
						gint prop_collection_length1 = 0;
						gint _prop_collection_size_ = 0;
						gint prop_it = 0;
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						prop_collection = _tmp133_;
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						prop_collection_length1 = _tmp132_;
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						for (prop_it = 0; prop_it < _tmp132_; prop_it = prop_it + 1) {
#line 1450 "tracker-sparql-pattern.c"
							TrackerProperty* _tmp134_;
							TrackerProperty* prop = NULL;
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp134_ = _g_object_ref0 (prop_collection[prop_it]);
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							prop = _tmp134_;
#line 1457 "tracker-sparql-pattern.c"
							{
								TrackerProperty* _tmp135_;
								TrackerClass* _tmp136_;
								TrackerClass* _tmp137_;
								TrackerClass* _tmp138_;
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp135_ = prop;
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp136_ = tracker_property_get_domain (_tmp135_);
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp137_ = _tmp136_;
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp138_ = self->domain;
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp137_ == _tmp138_) {
#line 1473 "tracker-sparql-pattern.c"
									gboolean _tmp139_;
									GString* _tmp141_;
									TrackerProperty* _tmp142_;
									const gchar* _tmp143_;
									const gchar* _tmp144_;
									GString* _tmp145_;
									TrackerProperty* _tmp146_;
									const gchar* _tmp147_;
									const gchar* _tmp148_;
									gchar* _tmp149_;
									gchar* _tmp150_;
									TrackerProperty* _tmp151_;
									TrackerPropertyType _tmp152_;
									TrackerPropertyType _tmp153_;
									GString* _tmp154_;
									gboolean _tmp155_;
									GString* _tmp160_;
									TrackerProperty* _tmp161_;
									const gchar* _tmp162_;
									const gchar* _tmp163_;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp139_ = first;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp139_) {
#line 138 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										first = FALSE;
#line 1500 "tracker-sparql-pattern.c"
									} else {
										GString* _tmp140_;
#line 140 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp140_ = sql;
#line 140 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append (_tmp140_, " UNION ALL ");
#line 1507 "tracker-sparql-pattern.c"
									}
#line 142 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp141_ = sql;
#line 142 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp142_ = prop;
#line 142 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp143_ = tracker_property_get_uri (_tmp142_);
#line 142 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp144_ = _tmp143_;
#line 142 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp141_, "SELECT ID, (SELECT ID FROM Resource WHERE Uri = '%s') AS \"predicate\"" \
", ", _tmp144_);
#line 144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp145_ = sql;
#line 144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp146_ = prop;
#line 144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp147_ = tracker_property_get_name (_tmp146_);
#line 144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp148_ = _tmp147_;
#line 144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp149_ = g_strdup_printf ("\"%s\"", _tmp148_);
#line 144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp150_ = _tmp149_;
#line 144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp151_ = prop;
#line 144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp152_ = tracker_property_get_data_type (_tmp151_);
#line 144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp153_ = _tmp152_;
#line 144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									tracker_sparql_expression_append_expression_as_string (_tmp145_, _tmp150_, _tmp153_);
#line 144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_tmp150_);
#line 146 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp154_ = sql;
#line 146 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp154_, " AS \"object\"");
#line 147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp155_ = self->return_graph;
#line 147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp155_) {
#line 1549 "tracker-sparql-pattern.c"
										GString* _tmp156_;
										TrackerProperty* _tmp157_;
										const gchar* _tmp158_;
										const gchar* _tmp159_;
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp156_ = sql;
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp157_ = prop;
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp158_ = tracker_property_get_name (_tmp157_);
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp159_ = _tmp158_;
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp156_, ", \"%s:graph\" AS \"graph\"", _tmp159_);
#line 1564 "tracker-sparql-pattern.c"
									}
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp160_ = sql;
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp161_ = prop;
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp162_ = tracker_property_get_table_name (_tmp161_);
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp163_ = _tmp162_;
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp160_, " FROM \"%s\"", _tmp163_);
#line 1576 "tracker-sparql-pattern.c"
								}
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_object_unref0 (prop);
#line 1580 "tracker-sparql-pattern.c"
							}
						}
					}
				} else {
					TrackerSparqlQuery* _tmp164_;
					GError* _tmp165_;
#line 155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp164_ = query;
#line 155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp165_ = tracker_sparql_query_get_internal_error (_tmp164_, "Unrestricted predicate variables not supported");
#line 155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_inner_error_ = _tmp165_;
#line 155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (ontologies);
#line 155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (sql);
#line 1597 "tracker-sparql-pattern.c"
					goto __catch0_g_error;
				}
			}
		}
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp166_ = sql;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp167_ = _tmp166_->str;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp168_ = g_strdup (_tmp167_);
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		result = _tmp168_;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (ontologies);
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_string_free0 (sql);
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		return result;
#line 1616 "tracker-sparql-pattern.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp169_;
		const gchar* _tmp170_;
		GError* _tmp171_;
#line 36 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		e = _inner_error_;
#line 36 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_inner_error_ = NULL;
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp169_ = e;
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp170_ = _tmp169_->message;
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp171_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _tmp170_);
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_inner_error_ = _tmp171_;
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_error_free0 (e);
#line 1639 "tracker-sparql-pattern.c"
		goto __finally0;
	}
	__finally0:
#line 36 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 36 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_propagate_error (error, _inner_error_);
#line 36 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		return NULL;
#line 1649 "tracker-sparql-pattern.c"
	} else {
#line 36 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 36 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_clear_error (&_inner_error_);
#line 36 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		return NULL;
#line 1657 "tracker-sparql-pattern.c"
	}
}


static void tracker_sparql_predicate_variable_class_init (TrackerSparqlPredicateVariableClass * klass) {
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_predicate_variable_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlPredicateVariablePrivate));
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_predicate_variable_finalize;
#line 1669 "tracker-sparql-pattern.c"
}


static void tracker_sparql_predicate_variable_instance_init (TrackerSparqlPredicateVariable * self) {
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->priv = TRACKER_SPARQL_PREDICATE_VARIABLE_GET_PRIVATE (self);
#line 1676 "tracker-sparql-pattern.c"
}


static void tracker_sparql_predicate_variable_finalize (GObject * obj) {
	TrackerSparqlPredicateVariable * self;
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_PREDICATE_VARIABLE, TrackerSparqlPredicateVariable);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (self->subject);
#line 24 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (self->object);
#line 27 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (self->domain);
#line 29 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (self->priv->manager);
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	G_OBJECT_CLASS (tracker_sparql_predicate_variable_parent_class)->finalize (obj);
#line 1694 "tracker-sparql-pattern.c"
}


GType tracker_sparql_predicate_variable_get_type (void) {
	static volatile gsize tracker_sparql_predicate_variable_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_predicate_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlPredicateVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_predicate_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlPredicateVariable), 0, (GInstanceInitFunc) tracker_sparql_predicate_variable_instance_init, NULL };
		GType tracker_sparql_predicate_variable_type_id;
		tracker_sparql_predicate_variable_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlPredicateVariable", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_predicate_variable_type_id__volatile, tracker_sparql_predicate_variable_type_id);
	}
	return tracker_sparql_predicate_variable_type_id__volatile;
}


TrackerSparqlPattern* tracker_sparql_pattern_construct (GType object_type, TrackerSparqlQuery* query) {
	TrackerSparqlPattern * self = NULL;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlQuery* _tmp1_;
	TrackerDataManager* _tmp2_;
	TrackerDataManager* _tmp3_;
	TrackerSparqlQuery* _tmp4_;
	TrackerSparqlExpression* _tmp5_;
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self = (TrackerSparqlPattern*) g_object_new (object_type, NULL);
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = query;
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->priv->query = _tmp0_;
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = query;
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = _tmp1_->manager;
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (self->priv->manager);
#line 188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->priv->manager = _tmp3_;
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp4_ = query;
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp5_ = _tmp4_->expression;
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->priv->expression = _tmp5_;
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return self;
#line 1744 "tracker-sparql-pattern.c"
}


TrackerSparqlPattern* tracker_sparql_pattern_new (TrackerSparqlQuery* query) {
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return tracker_sparql_pattern_construct (TRACKER_SPARQL_TYPE_PATTERN, query);
#line 1751 "tracker-sparql-pattern.c"
}


static inline gboolean tracker_sparql_pattern_next (TrackerSparqlPattern* self, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TrackerSparqlQuery* _tmp1_;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = self->priv->query;
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = tracker_sparql_query_next (_tmp1_, &_inner_error_);
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = _tmp2_;
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1773 "tracker-sparql-pattern.c"
			gboolean _tmp3_ = FALSE;
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp3_;
#line 1779 "tracker-sparql-pattern.c"
		} else {
			gboolean _tmp4_ = FALSE;
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp4_;
#line 1788 "tracker-sparql-pattern.c"
		}
	}
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _tmp0_;
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 1795 "tracker-sparql-pattern.c"
}


static inline TrackerSparqlTokenType tracker_sparql_pattern_current (TrackerSparqlPattern* self) {
	TrackerSparqlTokenType result = 0;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlTokenType _tmp1_;
#line 201 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 202 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 202 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = tracker_sparql_query_current (_tmp0_);
#line 202 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _tmp1_;
#line 202 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 1813 "tracker-sparql-pattern.c"
}


static inline gboolean tracker_sparql_pattern_accept (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TrackerSparqlQuery* _tmp1_;
	TrackerSparqlTokenType _tmp2_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = self->priv->query;
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = type;
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = tracker_sparql_query_accept (_tmp1_, _tmp2_, &_inner_error_);
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = _tmp3_;
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1838 "tracker-sparql-pattern.c"
			gboolean _tmp4_ = FALSE;
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp4_;
#line 1844 "tracker-sparql-pattern.c"
		} else {
			gboolean _tmp5_ = FALSE;
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp5_;
#line 1853 "tracker-sparql-pattern.c"
		}
	}
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _tmp0_;
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 1860 "tracker-sparql-pattern.c"
}


static GError* tracker_sparql_pattern_get_error (TrackerSparqlPattern* self, const gchar* msg) {
	GError* result = NULL;
	TrackerSparqlQuery* _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_;
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = msg;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = tracker_sparql_query_get_error (_tmp0_, _tmp1_);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _tmp2_;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 1883 "tracker-sparql-pattern.c"
}


static gboolean tracker_sparql_pattern_expect (TrackerSparqlPattern* self, TrackerSparqlTokenType type, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TrackerSparqlQuery* _tmp1_;
	TrackerSparqlTokenType _tmp2_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = self->priv->query;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = type;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = tracker_sparql_query_expect (_tmp1_, _tmp2_, &_inner_error_);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = _tmp3_;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1908 "tracker-sparql-pattern.c"
			gboolean _tmp4_ = FALSE;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp4_;
#line 1914 "tracker-sparql-pattern.c"
		} else {
			gboolean _tmp5_ = FALSE;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp5_;
#line 1923 "tracker-sparql-pattern.c"
		}
	}
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _tmp0_;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 1930 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_get_location (TrackerSparqlPattern* self, TrackerSourceLocation* result) {
	TrackerSparqlQuery* _tmp0_;
	TrackerSourceLocation _tmp1_ = {0};
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_query_get_location (_tmp0_, &_tmp1_);
#line 218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	*result = _tmp1_;
#line 218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return;
#line 1947 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_set_location (TrackerSparqlPattern* self, TrackerSourceLocation* location) {
	TrackerSparqlQuery* _tmp0_;
	TrackerSourceLocation _tmp1_;
#line 221 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 221 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (location != NULL);
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = *location;
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_query_set_location (_tmp0_, &_tmp1_);
#line 1964 "tracker-sparql-pattern.c"
}


static gchar* tracker_sparql_pattern_get_last_string (TrackerSparqlPattern* self, gint strip) {
	gchar* result = NULL;
	TrackerSparqlQuery* _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
#line 225 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = strip;
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = tracker_sparql_query_get_last_string (_tmp0_, _tmp1_);
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _tmp2_;
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 1985 "tracker-sparql-pattern.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1992 "tracker-sparql-pattern.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_list_free (self);
#line 2001 "tracker-sparql-pattern.c"
}


static void _vala_array_add5 (TrackerPropertyType* * array, int* length, int* size, TrackerPropertyType value) {
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if ((*length) == (*size)) {
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*array = g_renew (TrackerPropertyType, *array, *size);
#line 2012 "tracker-sparql-pattern.c"
	}
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[(*length)++] = value;
#line 2016 "tracker-sparql-pattern.c"
}


static void _vala_array_add6 (gchar** * array, int* length, int* size, gchar* value) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if ((*length) == (*size)) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 2027 "tracker-sparql-pattern.c"
	}
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[(*length)++] = value;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[*length] = NULL;
#line 2033 "tracker-sparql-pattern.c"
}


static void _vala_array_add7 (TrackerPropertyType* * array, int* length, int* size, TrackerPropertyType value) {
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if ((*length) == (*size)) {
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*array = g_renew (TrackerPropertyType, *array, *size);
#line 2044 "tracker-sparql-pattern.c"
	}
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[(*length)++] = value;
#line 2048 "tracker-sparql-pattern.c"
}


TrackerSparqlSelectContext* tracker_sparql_pattern_translate_select (TrackerSparqlPattern* self, GString* sql, gboolean subquery, gboolean scalar_subquery, GError** error) {
	TrackerSparqlSelectContext* result = NULL;
	TrackerSparqlSelectContext* _result_ = NULL;
	gboolean _tmp0_;
	TrackerSparqlSelectContext* _tmp9_;
	TrackerPropertyType type = 0;
	GString* pattern_sql = NULL;
	GString* _tmp10_;
	GList* old_bindings = NULL;
	TrackerSparqlQuery* _tmp11_;
	GList* _tmp12_;
	GString* _tmp13_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_;
	TrackerSourceLocation select_variables_location = {0};
	TrackerSourceLocation _tmp19_ = {0};
	TrackerSparqlExpression* _tmp20_;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_;
	TrackerSparqlContext* pattern = NULL;
	GString* _tmp23_;
	TrackerSparqlContext* _tmp24_;
	TrackerSparqlContext* _tmp25_;
	GHashTable* _tmp26_;
	GList* _tmp27_;
	TrackerSourceLocation after_where = {0};
	TrackerSourceLocation _tmp33_ = {0};
	TrackerSourceLocation _tmp34_;
	TrackerSparqlContext* _tmp35_;
	TrackerSparqlContext* _tmp36_;
	GHashTable* _tmp37_;
	GList* _tmp38_;
	GList* where_bindings = NULL;
	TrackerSparqlQuery* _tmp48_;
	GList* _tmp49_;
	TrackerSparqlQuery* _tmp50_;
	GList* _tmp51_;
	gboolean first = FALSE;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_;
	gboolean _tmp104_ = FALSE;
	gboolean _tmp105_;
	GList* _tmp115_;
	gboolean _tmp120_;
	GString* _tmp122_;
	GString* _tmp123_;
	GString* _tmp124_;
	const gchar* _tmp125_;
	GString* _tmp126_;
	TrackerSourceLocation _tmp127_;
	gboolean _tmp128_ = FALSE;
	gboolean _tmp129_;
	gboolean _tmp154_ = FALSE;
	gboolean _tmp155_;
	gint limit = 0;
	gint offset = 0;
	gboolean _tmp171_ = FALSE;
	gboolean _tmp172_;
	gint _tmp191_;
	gboolean _tmp221_ = FALSE;
	gboolean _tmp222_ = FALSE;
	gboolean _tmp223_;
	TrackerSparqlContext* _tmp242_;
	TrackerSparqlContext* _tmp243_;
	TrackerSparqlContext* _tmp244_;
	TrackerSparqlSelectContext* _tmp245_;
	TrackerPropertyType _tmp246_;
	GError * _inner_error_ = NULL;
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (sql != NULL, NULL);
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = scalar_subquery;
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp0_) {
#line 2128 "tracker-sparql-pattern.c"
		TrackerSparqlQuery* _tmp1_;
		TrackerSparqlContext* _tmp2_;
		TrackerSparqlContext* _tmp3_;
		TrackerSparqlSelectContext* _tmp4_;
#line 258 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp1_ = self->priv->query;
#line 258 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = tracker_sparql_pattern_get_context (self);
#line 258 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = _tmp2_;
#line 258 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = tracker_sparql_select_context_new_subquery (_tmp1_, _tmp3_);
#line 258 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tracker_sparql_context_unref0 (_result_);
#line 258 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_result_ = _tmp4_;
#line 2145 "tracker-sparql-pattern.c"
	} else {
		TrackerSparqlQuery* _tmp5_;
		TrackerSparqlContext* _tmp6_;
		TrackerSparqlContext* _tmp7_;
		TrackerSparqlSelectContext* _tmp8_;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_ = self->priv->query;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp6_ = tracker_sparql_pattern_get_context (self);
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp7_ = _tmp6_;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp8_ = tracker_sparql_select_context_new (_tmp5_, _tmp7_);
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tracker_sparql_context_unref0 (_result_);
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_result_ = _tmp8_;
#line 2163 "tracker-sparql-pattern.c"
	}
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp9_ = _result_;
#line 262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, (TrackerSparqlContext*) _tmp9_);
#line 263 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	type = TRACKER_PROPERTY_TYPE_UNKNOWN;
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp10_ = g_string_new ("");
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	pattern_sql = _tmp10_;
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp11_ = self->priv->query;
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp12_ = _tmp11_->bindings;
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp11_->bindings = NULL;
#line 266 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	old_bindings = _tmp12_;
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp13_ = sql;
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_append (_tmp13_, "SELECT ");
#line 270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_SELECT, &_inner_error_);
#line 270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2203 "tracker-sparql-pattern.c"
		} else {
#line 270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2217 "tracker-sparql-pattern.c"
		}
	}
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp15_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DISTINCT, &_inner_error_);
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp14_ = _tmp15_;
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2238 "tracker-sparql-pattern.c"
		} else {
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2252 "tracker-sparql-pattern.c"
		}
	}
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp14_) {
#line 2257 "tracker-sparql-pattern.c"
		GString* _tmp16_;
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp16_ = sql;
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp16_, "DISTINCT ");
#line 2263 "tracker-sparql-pattern.c"
	} else {
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_;
#line 274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp18_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_REDUCED, &_inner_error_);
#line 274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp17_ = _tmp18_;
#line 274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 2285 "tracker-sparql-pattern.c"
			} else {
#line 274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 2299 "tracker-sparql-pattern.c"
			}
		}
#line 274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp17_) {
#line 2304 "tracker-sparql-pattern.c"
		}
	}
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_get_location (self, &_tmp19_);
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	select_variables_location = _tmp19_;
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp20_ = self->priv->expression;
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_expression_skip_select_variables (_tmp20_, &_inner_error_);
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2329 "tracker-sparql-pattern.c"
		} else {
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2343 "tracker-sparql-pattern.c"
		}
	}
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp22_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_FROM, &_inner_error_);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp21_ = _tmp22_;
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2364 "tracker-sparql-pattern.c"
		} else {
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2378 "tracker-sparql-pattern.c"
		}
	}
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp21_) {
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_NAMED, &_inner_error_);
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 2399 "tracker-sparql-pattern.c"
			} else {
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 2413 "tracker-sparql-pattern.c"
			}
		}
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 2432 "tracker-sparql-pattern.c"
			} else {
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 2446 "tracker-sparql-pattern.c"
			}
		}
	}
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_WHERE, &_inner_error_);
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2466 "tracker-sparql-pattern.c"
		} else {
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2480 "tracker-sparql-pattern.c"
		}
	}
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp23_ = pattern_sql;
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp24_ = tracker_sparql_pattern_translate_group_graph_pattern (self, _tmp23_, &_inner_error_);
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	pattern = _tmp24_;
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2503 "tracker-sparql-pattern.c"
		} else {
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2517 "tracker-sparql-pattern.c"
		}
	}
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp25_ = pattern;
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp26_ = _tmp25_->var_set;
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp27_ = g_hash_table_get_keys (_tmp26_);
#line 2526 "tracker-sparql-pattern.c"
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		key_collection = _tmp27_;
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
#line 2534 "tracker-sparql-pattern.c"
			TrackerSparqlVariable* key = NULL;
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			key = (TrackerSparqlVariable*) key_it->data;
#line 2538 "tracker-sparql-pattern.c"
			{
				TrackerSparqlContext* _tmp28_;
				TrackerSparqlContext* _tmp29_;
				GHashTable* _tmp30_;
				TrackerSparqlVariable* _tmp31_;
				TrackerSparqlVariable* _tmp32_;
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp28_ = tracker_sparql_pattern_get_context (self);
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp29_ = _tmp28_;
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp30_ = _tmp29_->var_set;
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp31_ = key;
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp32_ = _g_object_ref0 (_tmp31_);
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_hash_table_insert (_tmp30_, _tmp32_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)));
#line 2557 "tracker-sparql-pattern.c"
			}
		}
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_list_free0 (key_collection);
#line 2562 "tracker-sparql-pattern.c"
	}
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_get_location (self, &_tmp33_);
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	after_where = _tmp33_;
#line 295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp34_ = select_variables_location;
#line 295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_location (self, &_tmp34_);
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp35_ = tracker_sparql_pattern_get_context (self);
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp36_ = _tmp35_;
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp37_ = _tmp36_->var_set;
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp38_ = g_hash_table_get_keys (_tmp37_);
#line 2580 "tracker-sparql-pattern.c"
	{
		GList* variable_collection = NULL;
		GList* variable_it = NULL;
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		variable_collection = _tmp38_;
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
#line 2588 "tracker-sparql-pattern.c"
			TrackerSparqlVariable* variable = NULL;
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			variable = (TrackerSparqlVariable*) variable_it->data;
#line 2592 "tracker-sparql-pattern.c"
			{
				TrackerSparqlVariable* _tmp39_;
				TrackerSparqlVariableBinding* _tmp40_;
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp39_ = variable;
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp40_ = _tmp39_->binding;
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp40_ == NULL) {
#line 2602 "tracker-sparql-pattern.c"
					TrackerSparqlVariable* _tmp41_;
					const gchar* _tmp42_;
					const gchar* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
					GError* _tmp46_;
					GError* _tmp47_;
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp41_ = variable;
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp42_ = tracker_sparql_variable_get_name (_tmp41_);
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp43_ = _tmp42_;
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp44_ = g_strdup_printf ("use of undefined variable `%s'", _tmp43_);
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp45_ = _tmp44_;
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp46_ = tracker_sparql_pattern_get_error (self, _tmp45_);
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp47_ = _tmp46_;
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp45_);
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_inner_error_ = _tmp47_;
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_list_free0 (variable_collection);
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 2644 "tracker-sparql-pattern.c"
					} else {
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_list_free0 (variable_collection);
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 2662 "tracker-sparql-pattern.c"
					}
				}
			}
		}
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_list_free0 (variable_collection);
#line 2669 "tracker-sparql-pattern.c"
	}
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp48_ = self->priv->query;
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp49_ = _tmp48_->bindings;
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp48_->bindings = NULL;
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	where_bindings = _tmp49_;
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp50_ = self->priv->query;
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp51_ = old_bindings;
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	old_bindings = NULL;
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (_tmp50_->bindings);
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp50_->bindings = _tmp51_;
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	first = TRUE;
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp53_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_STAR, &_inner_error_);
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp52_ = _tmp53_;
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2713 "tracker-sparql-pattern.c"
		} else {
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 2731 "tracker-sparql-pattern.c"
		}
	}
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp52_) {
#line 2736 "tracker-sparql-pattern.c"
		TrackerSparqlContext* _tmp54_;
		TrackerSparqlContext* _tmp55_;
		GHashTable* _tmp56_;
		GList* _tmp57_;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp54_ = tracker_sparql_pattern_get_context (self);
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp55_ = _tmp54_;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp56_ = _tmp55_->var_set;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp57_ = g_hash_table_get_keys (_tmp56_);
#line 2749 "tracker-sparql-pattern.c"
		{
			GList* variable_collection = NULL;
			GList* variable_it = NULL;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			variable_collection = _tmp57_;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
#line 2757 "tracker-sparql-pattern.c"
				TrackerSparqlVariable* variable = NULL;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				variable = (TrackerSparqlVariable*) variable_it->data;
#line 2761 "tracker-sparql-pattern.c"
				{
					gboolean _tmp58_;
					gboolean _tmp60_;
					TrackerSparqlSelectContext* _tmp76_;
					TrackerSparqlSelectContext* _tmp77_;
					TrackerPropertyType* _tmp78_;
					gint _tmp78__length1;
					TrackerSparqlVariable* _tmp79_;
					TrackerSparqlVariableBinding* _tmp80_;
					TrackerPropertyType _tmp81_;
					TrackerSparqlSelectContext* _tmp82_;
					TrackerSparqlSelectContext* _tmp83_;
					gchar** _tmp84_;
					gint _tmp84__length1;
					TrackerSparqlVariable* _tmp85_;
					const gchar* _tmp86_;
					const gchar* _tmp87_;
					gchar* _tmp88_;
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp58_ = first;
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp58_) {
#line 2784 "tracker-sparql-pattern.c"
						GString* _tmp59_;
#line 311 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp59_ = sql;
#line 311 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp59_, ", ");
#line 2790 "tracker-sparql-pattern.c"
					} else {
#line 313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						first = FALSE;
#line 2794 "tracker-sparql-pattern.c"
					}
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp60_ = subquery;
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp60_) {
#line 2800 "tracker-sparql-pattern.c"
						GString* _tmp61_;
						TrackerSparqlVariable* _tmp62_;
						const gchar* _tmp63_;
						const gchar* _tmp64_;
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp61_ = sql;
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp62_ = variable;
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp63_ = tracker_sparql_variable_get_sql_expression (_tmp62_);
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp64_ = _tmp63_;
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp61_, _tmp64_);
#line 2815 "tracker-sparql-pattern.c"
					} else {
						GString* _tmp65_;
						TrackerSparqlVariable* _tmp66_;
						const gchar* _tmp67_;
						const gchar* _tmp68_;
						TrackerSparqlVariable* _tmp69_;
						TrackerSparqlVariableBinding* _tmp70_;
						TrackerPropertyType _tmp71_;
						GString* _tmp72_;
						TrackerSparqlVariable* _tmp73_;
						const gchar* _tmp74_;
						const gchar* _tmp75_;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp65_ = sql;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp66_ = variable;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp67_ = tracker_sparql_variable_get_sql_expression (_tmp66_);
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp68_ = _tmp67_;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp69_ = variable;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp70_ = _tmp69_->binding;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp71_ = ((TrackerSparqlDataBinding*) _tmp70_)->data_type;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_expression_append_expression_as_string (_tmp65_, _tmp68_, _tmp71_);
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp72_ = sql;
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp73_ = variable;
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp74_ = tracker_sparql_variable_get_name (_tmp73_);
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp75_ = _tmp74_;
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append_printf (_tmp72_, " AS \"%s\"", _tmp75_);
#line 2854 "tracker-sparql-pattern.c"
					}
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp76_ = _result_;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp77_ = _result_;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp78_ = _tmp77_->types;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp78__length1 = _tmp77_->types_length1;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp79_ = variable;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp80_ = _tmp79_->binding;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp81_ = ((TrackerSparqlDataBinding*) _tmp80_)->data_type;
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_vala_array_add5 (&_tmp76_->types, &_tmp76_->types_length1, &_tmp76_->_types_size_, _tmp81_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp82_ = _result_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp83_ = _result_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp84_ = _tmp83_->variable_names;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp84__length1 = _tmp83_->variable_names_length1;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp85_ = variable;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp86_ = tracker_sparql_variable_get_name (_tmp85_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp87_ = _tmp86_;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp88_ = g_strdup (_tmp87_);
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_vala_array_add6 (&_tmp82_->variable_names, &_tmp82_->variable_names_length1, &_tmp82_->_variable_names_size_, _tmp88_);
#line 2890 "tracker-sparql-pattern.c"
				}
			}
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_list_free0 (variable_collection);
#line 2895 "tracker-sparql-pattern.c"
		}
	} else {
		{
			gint i = 0;
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			i = 0;
#line 2902 "tracker-sparql-pattern.c"
			{
				gboolean _tmp89_ = FALSE;
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp89_ = TRUE;
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				while (TRUE) {
#line 2909 "tracker-sparql-pattern.c"
					gint _tmp91_;
					TrackerPropertyType _tmp93_ = 0;
					TrackerSparqlExpression* _tmp94_;
					GString* _tmp95_;
					gboolean _tmp96_;
					gint _tmp97_;
					TrackerPropertyType _tmp98_;
					TrackerSparqlSelectContext* _tmp99_;
					TrackerSparqlSelectContext* _tmp100_;
					TrackerPropertyType* _tmp101_;
					gint _tmp101__length1;
					TrackerPropertyType _tmp102_;
					TrackerSparqlTokenType _tmp103_;
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp89_) {
#line 2925 "tracker-sparql-pattern.c"
						gint _tmp90_;
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp90_ = i;
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						i = _tmp90_ + 1;
#line 2931 "tracker-sparql-pattern.c"
					}
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp89_ = FALSE;
#line 327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					first = FALSE;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp91_ = i;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp91_ > 0) {
#line 2941 "tracker-sparql-pattern.c"
						GString* _tmp92_;
#line 330 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp92_ = sql;
#line 330 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp92_, ", ");
#line 2947 "tracker-sparql-pattern.c"
					}
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp94_ = self->priv->expression;
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp95_ = sql;
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp96_ = subquery;
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp97_ = i;
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp98_ = tracker_sparql_expression_translate_select_expression (_tmp94_, _tmp95_, _tmp96_, _tmp97_, &_inner_error_);
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp93_ = _tmp98_;
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							__g_list_free__g_object_unref0_0 (where_bindings);
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (pattern);
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							__g_list_free__g_object_unref0_0 (old_bindings);
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (pattern_sql);
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 2979 "tracker-sparql-pattern.c"
						} else {
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							__g_list_free__g_object_unref0_0 (where_bindings);
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (pattern);
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							__g_list_free__g_object_unref0_0 (old_bindings);
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (pattern_sql);
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 2997 "tracker-sparql-pattern.c"
						}
					}
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					type = _tmp93_;
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp99_ = _result_;
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp100_ = _result_;
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp101_ = _tmp100_->types;
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp101__length1 = _tmp100_->types_length1;
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp102_ = type;
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_vala_array_add7 (&_tmp99_->types, &_tmp99_->types_length1, &_tmp99_->_types_size_, _tmp102_);
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp103_ = tracker_sparql_pattern_current (self);
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					switch (_tmp103_) {
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_FROM:
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_WHERE:
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE:
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_GROUP:
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_ORDER:
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_LIMIT:
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_OFFSET:
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						case TRACKER_SPARQL_TOKEN_TYPE_EOF:
#line 3034 "tracker-sparql-pattern.c"
						{
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							break;
#line 3038 "tracker-sparql-pattern.c"
						}
						default:
						{
#line 347 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							continue;
#line 3044 "tracker-sparql-pattern.c"
						}
					}
#line 349 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					break;
#line 3049 "tracker-sparql-pattern.c"
				}
			}
		}
	}
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp105_ = self->queries_fts_data;
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp105_) {
#line 3058 "tracker-sparql-pattern.c"
		TrackerSparqlVariable* _tmp106_;
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp106_ = self->fts_subject;
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp104_ = _tmp106_ != NULL;
#line 3064 "tracker-sparql-pattern.c"
	} else {
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp104_ = FALSE;
#line 3068 "tracker-sparql-pattern.c"
	}
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp104_) {
#line 3072 "tracker-sparql-pattern.c"
		gboolean _tmp107_;
		GString* _tmp109_;
		TrackerSparqlVariable* _tmp110_;
		const gchar* _tmp111_;
		const gchar* _tmp112_;
		gchar* _tmp113_;
		gchar* _tmp114_;
#line 355 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp107_ = first;
#line 355 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp107_) {
#line 3084 "tracker-sparql-pattern.c"
			GString* _tmp108_;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp108_ = sql;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_string_append (_tmp108_, ", ");
#line 3090 "tracker-sparql-pattern.c"
		} else {
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			first = FALSE;
#line 3094 "tracker-sparql-pattern.c"
		}
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp109_ = sql;
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp110_ = self->fts_subject;
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp111_ = tracker_sparql_variable_get_sql_expression (_tmp110_);
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp112_ = _tmp111_;
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp113_ = g_strdup_printf ("%s AS rowid ", _tmp112_);
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp114_ = _tmp113_;
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp109_, _tmp114_);
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp114_);
#line 3112 "tracker-sparql-pattern.c"
	}
#line 365 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp115_ = where_bindings;
#line 3116 "tracker-sparql-pattern.c"
	{
		GList* binding_collection = NULL;
		GList* binding_it = NULL;
#line 365 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		binding_collection = _tmp115_;
#line 365 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
#line 3124 "tracker-sparql-pattern.c"
			TrackerSparqlLiteralBinding* _tmp116_;
			TrackerSparqlLiteralBinding* binding = NULL;
#line 365 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp116_ = _g_object_ref0 ((TrackerSparqlLiteralBinding*) binding_it->data);
#line 365 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			binding = _tmp116_;
#line 3131 "tracker-sparql-pattern.c"
			{
				TrackerSparqlQuery* _tmp117_;
				TrackerSparqlLiteralBinding* _tmp118_;
				TrackerSparqlLiteralBinding* _tmp119_;
#line 366 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp117_ = self->priv->query;
#line 366 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp118_ = binding;
#line 366 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp119_ = _g_object_ref0 (_tmp118_);
#line 366 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp117_->bindings = g_list_append (_tmp117_->bindings, _tmp119_);
#line 365 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding);
#line 3146 "tracker-sparql-pattern.c"
			}
		}
	}
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp120_ = first;
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp120_) {
#line 3154 "tracker-sparql-pattern.c"
		GString* _tmp121_;
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp121_ = sql;
#line 370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp121_, "NULL");
#line 3160 "tracker-sparql-pattern.c"
	}
#line 374 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp122_ = sql;
#line 374 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_append (_tmp122_, " FROM (");
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp123_ = sql;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp124_ = pattern_sql;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp125_ = _tmp124_->str;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_append (_tmp123_, _tmp125_);
#line 376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp126_ = sql;
#line 376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_append (_tmp126_, ")");
#line 378 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp127_ = after_where;
#line 378 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_location (self, &_tmp127_);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp129_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_GROUP, &_inner_error_);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp128_ = _tmp129_;
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 3204 "tracker-sparql-pattern.c"
		} else {
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 3222 "tracker-sparql-pattern.c"
		}
	}
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp128_) {
#line 3227 "tracker-sparql-pattern.c"
		GString* _tmp130_;
		gboolean first_group = FALSE;
		gboolean _tmp149_ = FALSE;
		gboolean _tmp150_;
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_BY, &_inner_error_);
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3252 "tracker-sparql-pattern.c"
			} else {
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3270 "tracker-sparql-pattern.c"
			}
		}
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp130_ = sql;
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp130_, " GROUP BY ");
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		first_group = TRUE;
#line 3279 "tracker-sparql-pattern.c"
		{
			gboolean _tmp131_ = FALSE;
#line 384 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp131_ = TRUE;
#line 384 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			while (TRUE) {
#line 3286 "tracker-sparql-pattern.c"
				gboolean _tmp145_;
				TrackerSparqlExpression* _tmp147_;
				GString* _tmp148_;
#line 384 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp131_) {
#line 3292 "tracker-sparql-pattern.c"
					gboolean _tmp132_ = FALSE;
					gboolean _tmp133_ = FALSE;
					gboolean _tmp134_ = FALSE;
					gboolean _tmp135_ = FALSE;
					gboolean _tmp136_ = FALSE;
					gboolean _tmp137_ = FALSE;
					TrackerSparqlTokenType _tmp138_;
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp138_ = tracker_sparql_pattern_current (self);
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp138_ != TRACKER_SPARQL_TOKEN_TYPE_HAVING) {
#line 3304 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp139_;
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp139_ = tracker_sparql_pattern_current (self);
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp137_ = _tmp139_ != TRACKER_SPARQL_TOKEN_TYPE_ORDER;
#line 3310 "tracker-sparql-pattern.c"
					} else {
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp137_ = FALSE;
#line 3314 "tracker-sparql-pattern.c"
					}
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp137_) {
#line 3318 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp140_;
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp140_ = tracker_sparql_pattern_current (self);
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp136_ = _tmp140_ != TRACKER_SPARQL_TOKEN_TYPE_LIMIT;
#line 3324 "tracker-sparql-pattern.c"
					} else {
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp136_ = FALSE;
#line 3328 "tracker-sparql-pattern.c"
					}
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp136_) {
#line 3332 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp141_;
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp141_ = tracker_sparql_pattern_current (self);
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp135_ = _tmp141_ != TRACKER_SPARQL_TOKEN_TYPE_OFFSET;
#line 3338 "tracker-sparql-pattern.c"
					} else {
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp135_ = FALSE;
#line 3342 "tracker-sparql-pattern.c"
					}
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp135_) {
#line 3346 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp142_;
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp142_ = tracker_sparql_pattern_current (self);
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp134_ = _tmp142_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE;
#line 3352 "tracker-sparql-pattern.c"
					} else {
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp134_ = FALSE;
#line 3356 "tracker-sparql-pattern.c"
					}
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp134_) {
#line 3360 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp143_;
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp143_ = tracker_sparql_pattern_current (self);
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp133_ = _tmp143_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS;
#line 3366 "tracker-sparql-pattern.c"
					} else {
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp133_ = FALSE;
#line 3370 "tracker-sparql-pattern.c"
					}
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp133_) {
#line 3374 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp144_;
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp144_ = tracker_sparql_pattern_current (self);
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp132_ = _tmp144_ != TRACKER_SPARQL_TOKEN_TYPE_EOF;
#line 3380 "tracker-sparql-pattern.c"
					} else {
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp132_ = FALSE;
#line 3384 "tracker-sparql-pattern.c"
					}
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp132_) {
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						break;
#line 3390 "tracker-sparql-pattern.c"
					}
				}
#line 384 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp131_ = FALSE;
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp145_ = first_group;
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp145_) {
#line 386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					first_group = FALSE;
#line 3401 "tracker-sparql-pattern.c"
				} else {
					GString* _tmp146_;
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp146_ = sql;
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp146_, ", ");
#line 3408 "tracker-sparql-pattern.c"
				}
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp147_ = self->priv->expression;
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp148_ = sql;
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_expression_translate_expression (_tmp147_, _tmp148_, &_inner_error_);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (where_bindings);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 3434 "tracker-sparql-pattern.c"
					} else {
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (where_bindings);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 3452 "tracker-sparql-pattern.c"
					}
				}
			}
		}
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp150_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_HAVING, &_inner_error_);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp149_ = _tmp150_;
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3479 "tracker-sparql-pattern.c"
			} else {
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3497 "tracker-sparql-pattern.c"
			}
		}
#line 393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp149_) {
#line 3502 "tracker-sparql-pattern.c"
			GString* _tmp151_;
			TrackerSparqlExpression* _tmp152_;
			GString* _tmp153_;
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp151_ = sql;
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_string_append (_tmp151_, " HAVING ");
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp152_ = self->priv->expression;
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp153_ = sql;
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_expression_translate_constraint (_tmp152_, _tmp153_, &_inner_error_);
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 3534 "tracker-sparql-pattern.c"
				} else {
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 3552 "tracker-sparql-pattern.c"
				}
			}
		}
	}
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp155_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_ORDER, &_inner_error_);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp154_ = _tmp155_;
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 3579 "tracker-sparql-pattern.c"
		} else {
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 3597 "tracker-sparql-pattern.c"
		}
	}
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp154_) {
#line 3602 "tracker-sparql-pattern.c"
		GString* _tmp156_;
		gboolean first_order = FALSE;
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_BY, &_inner_error_);
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3625 "tracker-sparql-pattern.c"
			} else {
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3643 "tracker-sparql-pattern.c"
			}
		}
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp156_ = sql;
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp156_, " ORDER BY ");
#line 402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		first_order = TRUE;
#line 3652 "tracker-sparql-pattern.c"
		{
			gboolean _tmp157_ = FALSE;
#line 403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp157_ = TRUE;
#line 403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			while (TRUE) {
#line 3659 "tracker-sparql-pattern.c"
				gboolean _tmp167_;
				TrackerSparqlExpression* _tmp169_;
				GString* _tmp170_;
#line 403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp157_) {
#line 3665 "tracker-sparql-pattern.c"
					gboolean _tmp158_ = FALSE;
					gboolean _tmp159_ = FALSE;
					gboolean _tmp160_ = FALSE;
					gboolean _tmp161_ = FALSE;
					TrackerSparqlTokenType _tmp162_;
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp162_ = tracker_sparql_pattern_current (self);
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp162_ != TRACKER_SPARQL_TOKEN_TYPE_LIMIT) {
#line 3675 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp163_;
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp163_ = tracker_sparql_pattern_current (self);
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp161_ = _tmp163_ != TRACKER_SPARQL_TOKEN_TYPE_OFFSET;
#line 3681 "tracker-sparql-pattern.c"
					} else {
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp161_ = FALSE;
#line 3685 "tracker-sparql-pattern.c"
					}
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp161_) {
#line 3689 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp164_;
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp164_ = tracker_sparql_pattern_current (self);
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp160_ = _tmp164_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE;
#line 3695 "tracker-sparql-pattern.c"
					} else {
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp160_ = FALSE;
#line 3699 "tracker-sparql-pattern.c"
					}
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp160_) {
#line 3703 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp165_;
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp165_ = tracker_sparql_pattern_current (self);
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp159_ = _tmp165_ != TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS;
#line 3709 "tracker-sparql-pattern.c"
					} else {
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp159_ = FALSE;
#line 3713 "tracker-sparql-pattern.c"
					}
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp159_) {
#line 3717 "tracker-sparql-pattern.c"
						TrackerSparqlTokenType _tmp166_;
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp166_ = tracker_sparql_pattern_current (self);
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp158_ = _tmp166_ != TRACKER_SPARQL_TOKEN_TYPE_EOF;
#line 3723 "tracker-sparql-pattern.c"
					} else {
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp158_ = FALSE;
#line 3727 "tracker-sparql-pattern.c"
					}
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp158_) {
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						break;
#line 3733 "tracker-sparql-pattern.c"
					}
				}
#line 403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp157_ = FALSE;
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp167_ = first_order;
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp167_) {
#line 405 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					first_order = FALSE;
#line 3744 "tracker-sparql-pattern.c"
				} else {
					GString* _tmp168_;
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp168_ = sql;
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp168_, ", ");
#line 3751 "tracker-sparql-pattern.c"
				}
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp169_ = self->priv->expression;
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp170_ = sql;
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_expression_translate_order_condition (_tmp169_, _tmp170_, &_inner_error_);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (where_bindings);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 3777 "tracker-sparql-pattern.c"
					} else {
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (where_bindings);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 3795 "tracker-sparql-pattern.c"
					}
				}
			}
		}
	}
#line 413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	limit = -1;
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	offset = -1;
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp172_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_LIMIT, &_inner_error_);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp171_ = _tmp172_;
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 3827 "tracker-sparql-pattern.c"
		} else {
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (where_bindings);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (pattern);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			__g_list_free__g_object_unref0_0 (old_bindings);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_string_free0 (pattern_sql);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 3845 "tracker-sparql-pattern.c"
		}
	}
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp171_) {
#line 3850 "tracker-sparql-pattern.c"
		gchar* _tmp173_;
		gchar* _tmp174_;
		gint _tmp175_;
		gboolean _tmp176_ = FALSE;
		gboolean _tmp177_;
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3876 "tracker-sparql-pattern.c"
			} else {
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3894 "tracker-sparql-pattern.c"
			}
		}
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp173_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp174_ = _tmp173_;
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp175_ = atoi (_tmp174_);
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		limit = _tmp175_;
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp174_);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp177_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OFFSET, &_inner_error_);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp176_ = _tmp177_;
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3929 "tracker-sparql-pattern.c"
			} else {
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 3947 "tracker-sparql-pattern.c"
			}
		}
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp176_) {
#line 3952 "tracker-sparql-pattern.c"
			gchar* _tmp178_;
			gchar* _tmp179_;
			gint _tmp180_;
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 3976 "tracker-sparql-pattern.c"
				} else {
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 3994 "tracker-sparql-pattern.c"
				}
			}
#line 421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp178_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp179_ = _tmp178_;
#line 421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp180_ = atoi (_tmp179_);
#line 421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			offset = _tmp180_;
#line 421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp179_);
#line 4007 "tracker-sparql-pattern.c"
		}
	} else {
		gboolean _tmp181_ = FALSE;
		gboolean _tmp182_;
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp182_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OFFSET, &_inner_error_);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp181_ = _tmp182_;
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 4034 "tracker-sparql-pattern.c"
			} else {
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (where_bindings);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (pattern);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				__g_list_free__g_object_unref0_0 (old_bindings);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (pattern_sql);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 4052 "tracker-sparql-pattern.c"
			}
		}
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp181_) {
#line 4057 "tracker-sparql-pattern.c"
			gchar* _tmp183_;
			gchar* _tmp184_;
			gint _tmp185_;
			gboolean _tmp186_ = FALSE;
			gboolean _tmp187_;
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 4083 "tracker-sparql-pattern.c"
				} else {
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 4101 "tracker-sparql-pattern.c"
				}
			}
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp183_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp184_ = _tmp183_;
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp185_ = atoi (_tmp184_);
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			offset = _tmp185_;
#line 425 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp184_);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp187_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_LIMIT, &_inner_error_);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp186_ = _tmp187_;
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 4136 "tracker-sparql-pattern.c"
				} else {
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (where_bindings);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (pattern);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					__g_list_free__g_object_unref0_0 (old_bindings);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (pattern_sql);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 4154 "tracker-sparql-pattern.c"
				}
			}
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp186_) {
#line 4159 "tracker-sparql-pattern.c"
				gchar* _tmp188_;
				gchar* _tmp189_;
				gint _tmp190_;
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_INTEGER, &_inner_error_);
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (where_bindings);
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 4183 "tracker-sparql-pattern.c"
					} else {
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (where_bindings);
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						__g_list_free__g_object_unref0_0 (old_bindings);
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (pattern_sql);
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 4201 "tracker-sparql-pattern.c"
					}
				}
#line 428 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp188_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 428 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp189_ = _tmp188_;
#line 428 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp190_ = atoi (_tmp189_);
#line 428 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				limit = _tmp190_;
#line 428 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp189_);
#line 4214 "tracker-sparql-pattern.c"
			}
		}
	}
#line 433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp191_ = limit;
#line 433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp191_ >= 0) {
#line 4222 "tracker-sparql-pattern.c"
		GString* _tmp192_;
		TrackerSparqlLiteralBinding* binding = NULL;
		TrackerSparqlLiteralBinding* _tmp193_;
		TrackerSparqlLiteralBinding* _tmp194_;
		gint _tmp195_;
		gchar* _tmp196_;
		TrackerSparqlLiteralBinding* _tmp197_;
		TrackerSparqlQuery* _tmp198_;
		TrackerSparqlLiteralBinding* _tmp199_;
		TrackerSparqlLiteralBinding* _tmp200_;
		gint _tmp201_;
#line 434 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp192_ = sql;
#line 434 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp192_, " LIMIT ?");
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp193_ = tracker_sparql_literal_binding_new ();
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		binding = _tmp193_;
#line 437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp194_ = binding;
#line 437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp195_ = limit;
#line 437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp196_ = g_strdup_printf ("%i", _tmp195_);
#line 437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp194_->literal);
#line 437 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp194_->literal = _tmp196_;
#line 438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp197_ = binding;
#line 438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		((TrackerSparqlDataBinding*) _tmp197_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp198_ = self->priv->query;
#line 439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp199_ = binding;
#line 439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp200_ = _g_object_ref0 (_tmp199_);
#line 439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp198_->bindings = g_list_append (_tmp198_->bindings, _tmp200_);
#line 441 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp201_ = offset;
#line 441 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp201_ >= 0) {
#line 4268 "tracker-sparql-pattern.c"
			GString* _tmp202_;
			TrackerSparqlLiteralBinding* _tmp203_;
			TrackerSparqlLiteralBinding* _tmp204_;
			gint _tmp205_;
			gchar* _tmp206_;
			TrackerSparqlLiteralBinding* _tmp207_;
			TrackerSparqlQuery* _tmp208_;
			TrackerSparqlLiteralBinding* _tmp209_;
			TrackerSparqlLiteralBinding* _tmp210_;
#line 442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp202_ = sql;
#line 442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_string_append (_tmp202_, " OFFSET ?");
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp203_ = tracker_sparql_literal_binding_new ();
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (binding);
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			binding = _tmp203_;
#line 445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp204_ = binding;
#line 445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp205_ = offset;
#line 445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp206_ = g_strdup_printf ("%i", _tmp205_);
#line 445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp204_->literal);
#line 445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp204_->literal = _tmp206_;
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp207_ = binding;
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp207_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 447 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp208_ = self->priv->query;
#line 447 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp209_ = binding;
#line 447 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp210_ = _g_object_ref0 (_tmp209_);
#line 447 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp208_->bindings = g_list_append (_tmp208_->bindings, _tmp210_);
#line 4310 "tracker-sparql-pattern.c"
		}
#line 433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (binding);
#line 4314 "tracker-sparql-pattern.c"
	} else {
		gint _tmp211_;
#line 449 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp211_ = offset;
#line 449 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp211_ >= 0) {
#line 4321 "tracker-sparql-pattern.c"
			GString* _tmp212_;
			TrackerSparqlLiteralBinding* binding = NULL;
			TrackerSparqlLiteralBinding* _tmp213_;
			TrackerSparqlLiteralBinding* _tmp214_;
			gint _tmp215_;
			gchar* _tmp216_;
			TrackerSparqlLiteralBinding* _tmp217_;
			TrackerSparqlQuery* _tmp218_;
			TrackerSparqlLiteralBinding* _tmp219_;
			TrackerSparqlLiteralBinding* _tmp220_;
#line 450 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp212_ = sql;
#line 450 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_string_append (_tmp212_, " LIMIT -1 OFFSET ?");
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp213_ = tracker_sparql_literal_binding_new ();
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			binding = _tmp213_;
#line 453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp214_ = binding;
#line 453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp215_ = offset;
#line 453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp216_ = g_strdup_printf ("%i", _tmp215_);
#line 453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp214_->literal);
#line 453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp214_->literal = _tmp216_;
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp217_ = binding;
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp217_)->data_type = TRACKER_PROPERTY_TYPE_INTEGER;
#line 455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp218_ = self->priv->query;
#line 455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp219_ = binding;
#line 455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp220_ = _g_object_ref0 (_tmp219_);
#line 455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp218_->bindings = g_list_append (_tmp218_->bindings, _tmp220_);
#line 449 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (binding);
#line 4364 "tracker-sparql-pattern.c"
		}
	}
#line 458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp223_ = self->queries_fts_data;
#line 458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp223_) {
#line 4371 "tracker-sparql-pattern.c"
		GString* _tmp224_;
#line 458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp224_ = self->match_str;
#line 458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp222_ = _tmp224_ != NULL;
#line 4377 "tracker-sparql-pattern.c"
	} else {
#line 458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp222_ = FALSE;
#line 4381 "tracker-sparql-pattern.c"
	}
#line 458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp222_) {
#line 4385 "tracker-sparql-pattern.c"
		TrackerSparqlVariable* _tmp225_;
#line 458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp225_ = self->fts_subject;
#line 458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp221_ = _tmp225_ != NULL;
#line 4391 "tracker-sparql-pattern.c"
	} else {
#line 458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp221_ = FALSE;
#line 4395 "tracker-sparql-pattern.c"
	}
#line 458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp221_) {
#line 4399 "tracker-sparql-pattern.c"
		GString* str = NULL;
		GString* _tmp226_;
		gchar** _tmp227_;
		gint _tmp227__length1;
		GString* _tmp233_;
		GString* _tmp234_;
		GString* _tmp235_;
		const gchar* _tmp236_;
		GString* _tmp237_;
		GString* _tmp238_;
		const gchar* _tmp239_;
		gchar* _tmp240_;
		gchar* _tmp241_;
#line 459 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp226_ = g_string_new ("SELECT ");
#line 459 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		str = _tmp226_;
#line 460 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		first = TRUE;
#line 462 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp227_ = self->fts_variables;
#line 462 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp227__length1 = self->fts_variables_length1;
#line 4423 "tracker-sparql-pattern.c"
		{
			gchar** fts_var_collection = NULL;
			gint fts_var_collection_length1 = 0;
			gint _fts_var_collection_size_ = 0;
			gint fts_var_it = 0;
#line 462 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			fts_var_collection = _tmp227_;
#line 462 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			fts_var_collection_length1 = _tmp227__length1;
#line 462 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			for (fts_var_it = 0; fts_var_it < _tmp227__length1; fts_var_it = fts_var_it + 1) {
#line 4435 "tracker-sparql-pattern.c"
				gchar* _tmp228_;
				gchar* fts_var = NULL;
#line 462 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp228_ = g_strdup (fts_var_collection[fts_var_it]);
#line 462 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				fts_var = _tmp228_;
#line 4442 "tracker-sparql-pattern.c"
				{
					gboolean _tmp229_;
					GString* _tmp231_;
					const gchar* _tmp232_;
#line 463 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp229_ = first;
#line 463 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp229_) {
#line 4451 "tracker-sparql-pattern.c"
						GString* _tmp230_;
#line 464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp230_ = str;
#line 464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp230_, ", ");
#line 4457 "tracker-sparql-pattern.c"
					} else {
#line 466 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						first = FALSE;
#line 4461 "tracker-sparql-pattern.c"
					}
#line 469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp231_ = str;
#line 469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp232_ = fts_var;
#line 469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp231_, _tmp232_);
#line 462 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (fts_var);
#line 4471 "tracker-sparql-pattern.c"
				}
			}
		}
#line 472 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp233_ = str;
#line 472 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp233_, " FROM fts5 JOIN (");
#line 473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp234_ = sql;
#line 473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp235_ = str;
#line 473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp236_ = _tmp235_->str;
#line 473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_prepend (_tmp234_, _tmp236_);
#line 474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp237_ = sql;
#line 474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp238_ = self->match_str;
#line 474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp239_ = _tmp238_->str;
#line 474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp240_ = g_strdup_printf (") AS ranks ON fts5.rowid=rowid WHERE fts5 %s", _tmp239_);
#line 474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp241_ = _tmp240_;
#line 474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append_printf (_tmp237_, "%s", _tmp241_);
#line 474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp241_);
#line 458 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_string_free0 (str);
#line 4503 "tracker-sparql-pattern.c"
	}
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp242_ = tracker_sparql_pattern_get_context (self);
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp243_ = _tmp242_;
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp244_ = _tmp243_->parent_context;
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, _tmp244_);
#line 479 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp245_ = _result_;
#line 479 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp246_ = type;
#line 479 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp245_->type = _tmp246_;
#line 480 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_string_free0 (self->match_str);
#line 480 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->match_str = NULL;
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (self->fts_subject);
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->fts_subject = NULL;
#line 483 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _result_;
#line 483 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (where_bindings);
#line 483 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (pattern);
#line 483 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (old_bindings);
#line 483 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_string_free0 (pattern_sql);
#line 483 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 4539 "tracker-sparql-pattern.c"
}


void tracker_sparql_pattern_translate_exists (TrackerSparqlPattern* self, GString* sql, GError** error) {
	gboolean not = FALSE;
	gboolean _tmp0_;
	TrackerSparqlSelectContext* _result_ = NULL;
	TrackerSparqlQuery* _tmp1_;
	TrackerSparqlContext* _tmp2_;
	TrackerSparqlContext* _tmp3_;
	TrackerSparqlSelectContext* _tmp4_;
	TrackerSparqlSelectContext* _tmp5_;
	gboolean _tmp6_;
	TrackerSparqlContext* pattern = NULL;
	GString* _tmp9_;
	TrackerSparqlContext* _tmp10_;
	TrackerSparqlContext* _tmp11_;
	GHashTable* _tmp12_;
	GList* _tmp13_;
	TrackerSparqlContext* _tmp19_;
	TrackerSparqlContext* _tmp20_;
	GHashTable* _tmp21_;
	GList* _tmp22_;
	GString* _tmp32_;
	TrackerSparqlContext* _tmp33_;
	TrackerSparqlContext* _tmp34_;
	TrackerSparqlContext* _tmp35_;
	GError * _inner_error_ = NULL;
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_NOT, &_inner_error_);
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	not = _tmp0_;
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 4584 "tracker-sparql-pattern.c"
		} else {
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 4592 "tracker-sparql-pattern.c"
		}
	}
#line 488 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_EXISTS, &_inner_error_);
#line 488 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 488 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 488 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 488 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 4605 "tracker-sparql-pattern.c"
		} else {
#line 488 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 488 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 488 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 4613 "tracker-sparql-pattern.c"
		}
	}
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = self->priv->query;
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = tracker_sparql_pattern_get_context (self);
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = _tmp2_;
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp4_ = tracker_sparql_select_context_new_subquery (_tmp1_, _tmp3_);
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (_result_);
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_result_ = _tmp4_;
#line 492 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp5_ = _result_;
#line 492 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, (TrackerSparqlContext*) _tmp5_);
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp6_ = not;
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp6_) {
#line 4636 "tracker-sparql-pattern.c"
		GString* _tmp7_;
#line 496 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp7_ = sql;
#line 496 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp7_, "NOT EXISTS (");
#line 4642 "tracker-sparql-pattern.c"
	} else {
		GString* _tmp8_;
#line 499 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp8_ = sql;
#line 499 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp8_, "EXISTS (");
#line 4649 "tracker-sparql-pattern.c"
	}
#line 502 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp9_ = sql;
#line 502 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp10_ = tracker_sparql_pattern_translate_group_graph_pattern (self, _tmp9_, &_inner_error_);
#line 502 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	pattern = _tmp10_;
#line 502 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 502 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 502 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 502 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 502 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 4667 "tracker-sparql-pattern.c"
		} else {
#line 502 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 502 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 502 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 502 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 4677 "tracker-sparql-pattern.c"
		}
	}
#line 503 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp11_ = pattern;
#line 503 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp12_ = _tmp11_->var_set;
#line 503 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp13_ = g_hash_table_get_keys (_tmp12_);
#line 4686 "tracker-sparql-pattern.c"
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
#line 503 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		key_collection = _tmp13_;
#line 503 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
#line 4694 "tracker-sparql-pattern.c"
			TrackerSparqlVariable* key = NULL;
#line 503 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			key = (TrackerSparqlVariable*) key_it->data;
#line 4698 "tracker-sparql-pattern.c"
			{
				TrackerSparqlContext* _tmp14_;
				TrackerSparqlContext* _tmp15_;
				GHashTable* _tmp16_;
				TrackerSparqlVariable* _tmp17_;
				TrackerSparqlVariable* _tmp18_;
#line 504 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp14_ = tracker_sparql_pattern_get_context (self);
#line 504 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp15_ = _tmp14_;
#line 504 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp16_ = _tmp15_->var_set;
#line 504 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp17_ = key;
#line 504 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp18_ = _g_object_ref0 (_tmp17_);
#line 504 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_hash_table_insert (_tmp16_, _tmp18_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)));
#line 4717 "tracker-sparql-pattern.c"
			}
		}
#line 503 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_list_free0 (key_collection);
#line 4722 "tracker-sparql-pattern.c"
	}
#line 508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp19_ = tracker_sparql_pattern_get_context (self);
#line 508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp20_ = _tmp19_;
#line 508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp21_ = _tmp20_->var_set;
#line 508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp22_ = g_hash_table_get_keys (_tmp21_);
#line 4732 "tracker-sparql-pattern.c"
	{
		GList* variable_collection = NULL;
		GList* variable_it = NULL;
#line 508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		variable_collection = _tmp22_;
#line 508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
#line 4740 "tracker-sparql-pattern.c"
			TrackerSparqlVariable* variable = NULL;
#line 508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			variable = (TrackerSparqlVariable*) variable_it->data;
#line 4744 "tracker-sparql-pattern.c"
			{
				TrackerSparqlVariable* _tmp23_;
				TrackerSparqlVariableBinding* _tmp24_;
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp23_ = variable;
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp24_ = _tmp23_->binding;
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp24_ == NULL) {
#line 4754 "tracker-sparql-pattern.c"
					TrackerSparqlVariable* _tmp25_;
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					GError* _tmp30_;
					GError* _tmp31_;
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp25_ = variable;
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp26_ = tracker_sparql_variable_get_name (_tmp25_);
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp27_ = _tmp26_;
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp28_ = g_strdup_printf ("use of undefined variable `%s'", _tmp27_);
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp29_ = _tmp28_;
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp30_ = tracker_sparql_pattern_get_error (self, _tmp29_);
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp31_ = _tmp30_;
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp29_);
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_inner_error_ = _tmp31_;
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_list_free0 (variable_collection);
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 4792 "tracker-sparql-pattern.c"
					} else {
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_list_free0 (variable_collection);
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (pattern);
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 4806 "tracker-sparql-pattern.c"
					}
				}
			}
		}
#line 508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_list_free0 (variable_collection);
#line 4813 "tracker-sparql-pattern.c"
	}
#line 514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp32_ = sql;
#line 514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_append (_tmp32_, ")");
#line 516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp33_ = tracker_sparql_pattern_get_context (self);
#line 516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp34_ = _tmp33_;
#line 516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp35_ = _tmp34_->parent_context;
#line 516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, _tmp35_);
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (pattern);
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (_result_);
#line 4831 "tracker-sparql-pattern.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1323 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1323 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 4854 "tracker-sparql-pattern.c"
		glong _tmp4_;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 4862 "tracker-sparql-pattern.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 4874 "tracker-sparql-pattern.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
#line 1333 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 4898 "tracker-sparql-pattern.c"
		glong _tmp2_;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 4904 "tracker-sparql-pattern.c"
	} else {
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 4908 "tracker-sparql-pattern.c"
	}
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 4912 "tracker-sparql-pattern.c"
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 4924 "tracker-sparql-pattern.c"
	} else {
		gint _tmp6_;
		gint _tmp7_;
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 4934 "tracker-sparql-pattern.c"
	}
#line 1342 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1342 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 4940 "tracker-sparql-pattern.c"
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1344 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1344 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 4954 "tracker-sparql-pattern.c"
	} else {
		glong _tmp12_;
		glong _tmp13_;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 4964 "tracker-sparql-pattern.c"
	}
#line 1348 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1348 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 4970 "tracker-sparql-pattern.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 4979 "tracker-sparql-pattern.c"
	}
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 4999 "tracker-sparql-pattern.c"
}


gchar* tracker_sparql_pattern_parse_var_or_term (TrackerSparqlPattern* self, GString* sql, gboolean* is_var, GError** error) {
	gboolean _vala_is_var = FALSE;
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	TrackerSparqlTokenType _tmp1_;
	GError * _inner_error_ = NULL;
#line 519 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 520 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = g_strdup ("");
#line 520 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_result_ = _tmp0_;
#line 521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_vala_is_var = FALSE;
#line 522 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = tracker_sparql_pattern_current (self);
#line 522 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp1_ == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
#line 5022 "tracker-sparql-pattern.c"
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_vala_is_var = TRUE;
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_next (self, &_inner_error_);
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_result_);
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 5040 "tracker-sparql-pattern.c"
			} else {
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_result_);
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 5050 "tracker-sparql-pattern.c"
			}
		}
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = _tmp2_;
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = string_substring (_tmp3_, (glong) 1, (glong) -1);
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_result_);
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_result_ = _tmp4_;
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp3_);
#line 5065 "tracker-sparql-pattern.c"
	} else {
		TrackerSparqlTokenType _tmp5_;
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_ = tracker_sparql_pattern_current (self);
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp5_ == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
#line 5072 "tracker-sparql-pattern.c"
			gchar* _tmp6_;
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_next (self, &_inner_error_);
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_result_);
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 5086 "tracker-sparql-pattern.c"
				} else {
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_result_);
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 5096 "tracker-sparql-pattern.c"
				}
			}
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp6_ = tracker_sparql_pattern_get_last_string (self, 1);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_result_);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_result_ = _tmp6_;
#line 5105 "tracker-sparql-pattern.c"
		} else {
			TrackerSparqlTokenType _tmp7_;
#line 529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp7_ = tracker_sparql_pattern_current (self);
#line 529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp7_ == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
#line 5112 "tracker-sparql-pattern.c"
				gchar* ns = NULL;
				gchar* _tmp8_;
				gchar* _tmp9_ = NULL;
				TrackerSparqlQuery* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_next (self, &_inner_error_);
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_result_);
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 5137 "tracker-sparql-pattern.c"
					} else {
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_result_);
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 5147 "tracker-sparql-pattern.c"
					}
				}
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp8_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				ns = _tmp8_;
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (ns);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_result_);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 5168 "tracker-sparql-pattern.c"
					} else {
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (ns);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_result_);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 5180 "tracker-sparql-pattern.c"
					}
				}
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp10_ = self->priv->query;
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp11_ = ns;
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp12_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp13_ = _tmp12_;
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp14_ = string_substring (_tmp13_, (glong) 1, (glong) -1);
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp15_ = _tmp14_;
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp16_ = tracker_sparql_query_resolve_prefixed_name (_tmp10_, _tmp11_, _tmp15_, &_inner_error_);
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp17_ = _tmp16_;
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp15_);
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp13_);
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp9_ = _tmp17_;
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (ns);
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_result_);
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 5217 "tracker-sparql-pattern.c"
					} else {
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (ns);
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_result_);
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 5229 "tracker-sparql-pattern.c"
					}
				}
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp18_ = _tmp9_;
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp9_ = NULL;
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_result_);
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_result_ = _tmp18_;
#line 529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp9_);
#line 529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (ns);
#line 5244 "tracker-sparql-pattern.c"
			} else {
				TrackerSparqlTokenType _tmp19_;
#line 535 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp19_ = tracker_sparql_pattern_current (self);
#line 535 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp19_ == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
#line 5251 "tracker-sparql-pattern.c"
					gchar* _tmp20_ = NULL;
					TrackerSparqlQuery* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_next (self, &_inner_error_);
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_result_);
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 5273 "tracker-sparql-pattern.c"
						} else {
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_result_);
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 5283 "tracker-sparql-pattern.c"
						}
					}
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp21_ = self->priv->query;
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp22_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp23_ = _tmp22_;
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp24_ = string_substring (_tmp23_, (glong) 1, (glong) -1);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp25_ = _tmp24_;
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp26_ = tracker_sparql_query_resolve_prefixed_name (_tmp21_, "", _tmp25_, &_inner_error_);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp27_ = _tmp26_;
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp25_);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp23_);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp20_ = _tmp27_;
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_result_);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 5316 "tracker-sparql-pattern.c"
						} else {
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_result_);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 5326 "tracker-sparql-pattern.c"
						}
					}
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp28_ = _tmp20_;
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp20_ = NULL;
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_result_);
#line 538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_result_ = _tmp28_;
#line 535 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp20_);
#line 5339 "tracker-sparql-pattern.c"
				} else {
					gboolean _tmp29_ = FALSE;
					gboolean _tmp30_;
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp30_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, &_inner_error_);
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp29_ = _tmp30_;
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_result_);
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 5357 "tracker-sparql-pattern.c"
						} else {
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_result_);
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 5367 "tracker-sparql-pattern.c"
						}
					}
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp29_) {
#line 5372 "tracker-sparql-pattern.c"
						TrackerSparqlQuery* _tmp31_;
						gchar* _tmp32_;
						gchar* _tmp33_;
						gchar* _tmp34_;
						gchar* _tmp35_;
						gchar* _tmp36_;
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_propagate_error (error, _inner_error_);
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (_result_);
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 5391 "tracker-sparql-pattern.c"
							} else {
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (_result_);
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_clear_error (&_inner_error_);
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 5401 "tracker-sparql-pattern.c"
							}
						}
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp31_ = self->priv->query;
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp32_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp33_ = _tmp32_;
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp34_ = string_substring (_tmp33_, (glong) 1, (glong) -1);
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp35_ = _tmp34_;
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp36_ = tracker_sparql_query_generate_bnodeid (_tmp31_, _tmp35_);
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_result_);
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_result_ = _tmp36_;
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp35_);
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp33_);
#line 5424 "tracker-sparql-pattern.c"
					} else {
						TrackerSparqlTokenType _tmp37_;
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp37_ = tracker_sparql_pattern_current (self);
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_tmp37_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1) {
#line 5431 "tracker-sparql-pattern.c"
							gchar* _tmp38_ = NULL;
							TrackerSparqlExpression* _tmp39_;
							gchar* _tmp40_;
							gchar* _tmp41_;
#line 544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp39_ = self->priv->expression;
#line 544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp40_ = tracker_sparql_expression_parse_string_literal (_tmp39_, NULL, &_inner_error_);
#line 544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp38_ = _tmp40_;
#line 544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_propagate_error (error, _inner_error_);
#line 544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_result_);
#line 544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return NULL;
#line 5452 "tracker-sparql-pattern.c"
								} else {
#line 544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_result_);
#line 544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_clear_error (&_inner_error_);
#line 544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return NULL;
#line 5462 "tracker-sparql-pattern.c"
								}
							}
#line 544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp41_ = _tmp38_;
#line 544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp38_ = NULL;
#line 544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_result_);
#line 544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_result_ = _tmp41_;
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_tmp38_);
#line 5475 "tracker-sparql-pattern.c"
						} else {
							TrackerSparqlTokenType _tmp42_;
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp42_ = tracker_sparql_pattern_current (self);
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_tmp42_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2) {
#line 5482 "tracker-sparql-pattern.c"
								gchar* _tmp43_ = NULL;
								TrackerSparqlExpression* _tmp44_;
								gchar* _tmp45_;
								gchar* _tmp46_;
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp44_ = self->priv->expression;
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp45_ = tracker_sparql_expression_parse_string_literal (_tmp44_, NULL, &_inner_error_);
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp43_ = _tmp45_;
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_propagate_error (error, _inner_error_);
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_g_free0 (_result_);
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										return NULL;
#line 5503 "tracker-sparql-pattern.c"
									} else {
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_g_free0 (_result_);
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_clear_error (&_inner_error_);
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										return NULL;
#line 5513 "tracker-sparql-pattern.c"
									}
								}
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp46_ = _tmp43_;
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp43_ = NULL;
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (_result_);
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_result_ = _tmp46_;
#line 545 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (_tmp43_);
#line 5526 "tracker-sparql-pattern.c"
							} else {
								TrackerSparqlTokenType _tmp47_;
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp47_ = tracker_sparql_pattern_current (self);
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp47_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1) {
#line 5533 "tracker-sparql-pattern.c"
									gchar* _tmp48_ = NULL;
									TrackerSparqlExpression* _tmp49_;
									gchar* _tmp50_;
									gchar* _tmp51_;
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp49_ = self->priv->expression;
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp50_ = tracker_sparql_expression_parse_string_literal (_tmp49_, NULL, &_inner_error_);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp48_ = _tmp50_;
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											g_propagate_error (error, _inner_error_);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_result_);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											return NULL;
#line 5554 "tracker-sparql-pattern.c"
										} else {
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_result_);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											g_clear_error (&_inner_error_);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											return NULL;
#line 5564 "tracker-sparql-pattern.c"
										}
									}
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp51_ = _tmp48_;
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp48_ = NULL;
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_result_);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_result_ = _tmp51_;
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_tmp48_);
#line 5577 "tracker-sparql-pattern.c"
								} else {
									TrackerSparqlTokenType _tmp52_;
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp52_ = tracker_sparql_pattern_current (self);
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp52_ == TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2) {
#line 5584 "tracker-sparql-pattern.c"
										gchar* _tmp53_ = NULL;
										TrackerSparqlExpression* _tmp54_;
										gchar* _tmp55_;
										gchar* _tmp56_;
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp54_ = self->priv->expression;
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp55_ = tracker_sparql_expression_parse_string_literal (_tmp54_, NULL, &_inner_error_);
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp53_ = _tmp55_;
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												g_propagate_error (error, _inner_error_);
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_g_free0 (_result_);
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												return NULL;
#line 5605 "tracker-sparql-pattern.c"
											} else {
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_g_free0 (_result_);
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												g_clear_error (&_inner_error_);
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												return NULL;
#line 5615 "tracker-sparql-pattern.c"
											}
										}
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp56_ = _tmp53_;
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp53_ = NULL;
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_g_free0 (_result_);
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_result_ = _tmp56_;
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_g_free0 (_tmp53_);
#line 5628 "tracker-sparql-pattern.c"
									} else {
										TrackerSparqlTokenType _tmp57_;
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp57_ = tracker_sparql_pattern_current (self);
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										if (_tmp57_ == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
#line 5635 "tracker-sparql-pattern.c"
											gchar* _tmp58_;
#line 552 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											tracker_sparql_pattern_next (self, &_inner_error_);
#line 552 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 552 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 552 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													g_propagate_error (error, _inner_error_);
#line 552 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_g_free0 (_result_);
#line 552 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													return NULL;
#line 5649 "tracker-sparql-pattern.c"
												} else {
#line 552 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_g_free0 (_result_);
#line 552 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 552 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													g_clear_error (&_inner_error_);
#line 552 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													return NULL;
#line 5659 "tracker-sparql-pattern.c"
												}
											}
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp58_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_result_);
#line 553 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_result_ = _tmp58_;
#line 5668 "tracker-sparql-pattern.c"
										} else {
											TrackerSparqlTokenType _tmp59_;
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp59_ = tracker_sparql_pattern_current (self);
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											if (_tmp59_ == TRACKER_SPARQL_TOKEN_TYPE_DECIMAL) {
#line 5675 "tracker-sparql-pattern.c"
												gchar* _tmp60_;
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												tracker_sparql_pattern_next (self, &_inner_error_);
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														g_propagate_error (error, _inner_error_);
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														_g_free0 (_result_);
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														return NULL;
#line 5689 "tracker-sparql-pattern.c"
													} else {
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														_g_free0 (_result_);
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														g_clear_error (&_inner_error_);
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														return NULL;
#line 5699 "tracker-sparql-pattern.c"
													}
												}
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_tmp60_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_g_free0 (_result_);
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_result_ = _tmp60_;
#line 5708 "tracker-sparql-pattern.c"
											} else {
												TrackerSparqlTokenType _tmp61_;
#line 557 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_tmp61_ = tracker_sparql_pattern_current (self);
#line 557 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												if (_tmp61_ == TRACKER_SPARQL_TOKEN_TYPE_DOUBLE) {
#line 5715 "tracker-sparql-pattern.c"
													gchar* _tmp62_;
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													tracker_sparql_pattern_next (self, &_inner_error_);
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															g_propagate_error (error, _inner_error_);
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															_g_free0 (_result_);
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															return NULL;
#line 5729 "tracker-sparql-pattern.c"
														} else {
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															_g_free0 (_result_);
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															g_clear_error (&_inner_error_);
#line 558 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															return NULL;
#line 5739 "tracker-sparql-pattern.c"
														}
													}
#line 559 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_tmp62_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 559 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_g_free0 (_result_);
#line 559 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_result_ = _tmp62_;
#line 5748 "tracker-sparql-pattern.c"
												} else {
													TrackerSparqlTokenType _tmp63_;
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_tmp63_ = tracker_sparql_pattern_current (self);
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													if (_tmp63_ == TRACKER_SPARQL_TOKEN_TYPE_TRUE) {
#line 5755 "tracker-sparql-pattern.c"
														gchar* _tmp64_;
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														tracker_sparql_pattern_next (self, &_inner_error_);
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																g_propagate_error (error, _inner_error_);
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_g_free0 (_result_);
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																return NULL;
#line 5769 "tracker-sparql-pattern.c"
															} else {
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_g_free0 (_result_);
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																g_clear_error (&_inner_error_);
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																return NULL;
#line 5779 "tracker-sparql-pattern.c"
															}
														}
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														_tmp64_ = g_strdup ("true");
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														_g_free0 (_result_);
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														_result_ = _tmp64_;
#line 5788 "tracker-sparql-pattern.c"
													} else {
														TrackerSparqlTokenType _tmp65_;
#line 563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														_tmp65_ = tracker_sparql_pattern_current (self);
#line 563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
														if (_tmp65_ == TRACKER_SPARQL_TOKEN_TYPE_FALSE) {
#line 5795 "tracker-sparql-pattern.c"
															gchar* _tmp66_;
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															tracker_sparql_pattern_next (self, &_inner_error_);
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	g_propagate_error (error, _inner_error_);
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	_g_free0 (_result_);
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	return NULL;
#line 5809 "tracker-sparql-pattern.c"
																} else {
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	_g_free0 (_result_);
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	g_clear_error (&_inner_error_);
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	return NULL;
#line 5819 "tracker-sparql-pattern.c"
																}
															}
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															_tmp66_ = g_strdup ("false");
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															_g_free0 (_result_);
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															_result_ = _tmp66_;
#line 5828 "tracker-sparql-pattern.c"
														} else {
															TrackerSparqlTokenType _tmp67_;
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															_tmp67_ = tracker_sparql_pattern_current (self);
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
															if (_tmp67_ == TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET) {
#line 5835 "tracker-sparql-pattern.c"
																TrackerSparqlQuery* _tmp68_;
																gchar* _tmp69_;
																gchar* old_subject = NULL;
																const gchar* _tmp70_;
																gchar* _tmp71_;
																gboolean old_subject_is_var = FALSE;
																gboolean _tmp72_;
																const gchar* _tmp73_;
																gchar* _tmp74_;
																GString* _tmp75_;
																const gchar* _tmp76_;
																gchar* _tmp77_;
																gboolean _tmp78_;
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																tracker_sparql_pattern_next (self, &_inner_error_);
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_propagate_error (error, _inner_error_);
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (_result_);
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		return NULL;
#line 5861 "tracker-sparql-pattern.c"
																	} else {
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (_result_);
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_clear_error (&_inner_error_);
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		return NULL;
#line 5871 "tracker-sparql-pattern.c"
																	}
																}
#line 569 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp68_ = self->priv->query;
#line 569 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp69_ = tracker_sparql_query_generate_bnodeid (_tmp68_, NULL);
#line 569 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_g_free0 (_result_);
#line 569 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_result_ = _tmp69_;
#line 571 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp70_ = self->priv->current_subject;
#line 571 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp71_ = g_strdup (_tmp70_);
#line 571 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																old_subject = _tmp71_;
#line 572 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp72_ = self->priv->current_subject_is_var;
#line 572 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																old_subject_is_var = _tmp72_;
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp73_ = _result_;
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp74_ = g_strdup (_tmp73_);
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_g_free0 (self->priv->current_subject);
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																self->priv->current_subject = _tmp74_;
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																self->priv->current_subject_is_var = TRUE;
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp75_ = sql;
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																tracker_sparql_pattern_parse_property_list_not_empty (self, _tmp75_, FALSE, &_inner_error_);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_propagate_error (error, _inner_error_);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (old_subject);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (_result_);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		return NULL;
#line 5918 "tracker-sparql-pattern.c"
																	} else {
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (old_subject);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (_result_);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_clear_error (&_inner_error_);
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		return NULL;
#line 5930 "tracker-sparql-pattern.c"
																	}
																}
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, &_inner_error_);
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_propagate_error (error, _inner_error_);
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (old_subject);
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (_result_);
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		return NULL;
#line 5947 "tracker-sparql-pattern.c"
																	} else {
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (old_subject);
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		_g_free0 (_result_);
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		g_clear_error (&_inner_error_);
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																		return NULL;
#line 5959 "tracker-sparql-pattern.c"
																	}
																}
#line 579 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp76_ = old_subject;
#line 579 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp77_ = g_strdup (_tmp76_);
#line 579 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_g_free0 (self->priv->current_subject);
#line 579 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																self->priv->current_subject = _tmp77_;
#line 580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp78_ = old_subject_is_var;
#line 580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																self->priv->current_subject_is_var = _tmp78_;
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_vala_is_var = TRUE;
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_g_free0 (old_subject);
#line 5978 "tracker-sparql-pattern.c"
															} else {
																GError* _tmp79_;
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_tmp79_ = tracker_sparql_pattern_get_error (self, "expected variable or term");
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																_inner_error_ = _tmp79_;
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	g_propagate_error (error, _inner_error_);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	_g_free0 (_result_);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	return NULL;
#line 5993 "tracker-sparql-pattern.c"
																} else {
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	_g_free0 (_result_);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	g_clear_error (&_inner_error_);
#line 584 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
																	return NULL;
#line 6003 "tracker-sparql-pattern.c"
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _result_;
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (is_var) {
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*is_var = _vala_is_var;
#line 6026 "tracker-sparql-pattern.c"
	}
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 6030 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_parse_object_list (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error) {
	GError * _inner_error_ = NULL;
#line 589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	while (TRUE) {
#line 6042 "tracker-sparql-pattern.c"
		GString* _tmp0_;
		gboolean _tmp1_;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp0_ = sql;
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp1_ = in_simple_optional;
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_parse_object (self, _tmp0_, _tmp1_, &_inner_error_);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6061 "tracker-sparql-pattern.c"
			} else {
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6069 "tracker-sparql-pattern.c"
			}
		}
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COMMA, &_inner_error_);
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = _tmp3_;
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6084 "tracker-sparql-pattern.c"
			} else {
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6092 "tracker-sparql-pattern.c"
			}
		}
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp2_) {
#line 593 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			continue;
#line 6099 "tracker-sparql-pattern.c"
		}
#line 595 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		break;
#line 6103 "tracker-sparql-pattern.c"
	}
}


static void tracker_sparql_pattern_parse_property_list_not_empty (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error) {
	GError * _inner_error_ = NULL;
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 600 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	while (TRUE) {
#line 6116 "tracker-sparql-pattern.c"
		gchar* old_predicate = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gboolean old_predicate_is_var = FALSE;
		gboolean _tmp2_;
		TrackerSparqlTokenType _tmp3_;
		GString* _tmp34_;
		gboolean _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gboolean _tmp38_;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp40_;
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp0_ = self->priv->current_predicate;
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp1_ = g_strdup (_tmp0_);
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		old_predicate = _tmp1_;
#line 602 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = self->priv->current_predicate_is_var;
#line 602 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		old_predicate_is_var = _tmp2_;
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (self->priv->current_predicate);
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->current_predicate = NULL;
#line 605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->current_predicate_is_var = FALSE;
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = tracker_sparql_pattern_current (self);
#line 606 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp3_ == TRACKER_SPARQL_TOKEN_TYPE_VAR) {
#line 6150 "tracker-sparql-pattern.c"
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
#line 607 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			self->priv->current_predicate_is_var = TRUE;
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_next (self, &_inner_error_);
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (old_predicate);
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 6168 "tracker-sparql-pattern.c"
				} else {
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (old_predicate);
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 6178 "tracker-sparql-pattern.c"
				}
			}
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp4_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp5_ = _tmp4_;
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp6_ = string_substring (_tmp5_, (glong) 1, (glong) -1);
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (self->priv->current_predicate);
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			self->priv->current_predicate = _tmp6_;
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp5_);
#line 6193 "tracker-sparql-pattern.c"
		} else {
			TrackerSparqlTokenType _tmp7_;
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp7_ = tracker_sparql_pattern_current (self);
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp7_ == TRACKER_SPARQL_TOKEN_TYPE_IRI_REF) {
#line 6200 "tracker-sparql-pattern.c"
				gchar* _tmp8_;
#line 611 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_next (self, &_inner_error_);
#line 611 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 611 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 611 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 611 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (old_predicate);
#line 611 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 6214 "tracker-sparql-pattern.c"
					} else {
#line 611 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (old_predicate);
#line 611 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 611 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 611 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 6224 "tracker-sparql-pattern.c"
					}
				}
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp8_ = tracker_sparql_pattern_get_last_string (self, 1);
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (self->priv->current_predicate);
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->priv->current_predicate = _tmp8_;
#line 6233 "tracker-sparql-pattern.c"
			} else {
				TrackerSparqlTokenType _tmp9_;
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp9_ = tracker_sparql_pattern_current (self);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp9_ == TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX) {
#line 6240 "tracker-sparql-pattern.c"
					gchar* ns = NULL;
					gchar* _tmp10_;
					gchar* _tmp11_ = NULL;
					TrackerSparqlQuery* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
#line 614 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_next (self, &_inner_error_);
#line 614 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 614 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 614 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 614 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_predicate);
#line 614 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6265 "tracker-sparql-pattern.c"
						} else {
#line 614 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_predicate);
#line 614 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 614 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 614 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6275 "tracker-sparql-pattern.c"
						}
					}
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp10_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					ns = _tmp10_;
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (ns);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_predicate);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6296 "tracker-sparql-pattern.c"
						} else {
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (ns);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_predicate);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6308 "tracker-sparql-pattern.c"
						}
					}
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp12_ = self->priv->query;
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp13_ = ns;
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp14_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp15_ = _tmp14_;
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp16_ = string_substring (_tmp15_, (glong) 1, (glong) -1);
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp17_ = _tmp16_;
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp18_ = tracker_sparql_query_resolve_prefixed_name (_tmp12_, _tmp13_, _tmp17_, &_inner_error_);
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp19_ = _tmp18_;
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp17_);
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp15_);
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp11_ = _tmp19_;
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (ns);
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_predicate);
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6345 "tracker-sparql-pattern.c"
						} else {
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (ns);
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_predicate);
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6357 "tracker-sparql-pattern.c"
						}
					}
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp20_ = _tmp11_;
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp11_ = NULL;
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (self->priv->current_predicate);
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					self->priv->current_predicate = _tmp20_;
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp11_);
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (ns);
#line 6372 "tracker-sparql-pattern.c"
				} else {
					TrackerSparqlTokenType _tmp21_;
#line 618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp21_ = tracker_sparql_pattern_current (self);
#line 618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp21_ == TRACKER_SPARQL_TOKEN_TYPE_COLON) {
#line 6379 "tracker-sparql-pattern.c"
						gchar* _tmp22_ = NULL;
						TrackerSparqlQuery* _tmp23_;
						gchar* _tmp24_;
						gchar* _tmp25_;
						gchar* _tmp26_;
						gchar* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						gchar* _tmp30_;
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_next (self, &_inner_error_);
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_propagate_error (error, _inner_error_);
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_predicate);
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return;
#line 6401 "tracker-sparql-pattern.c"
							} else {
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_predicate);
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_clear_error (&_inner_error_);
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return;
#line 6411 "tracker-sparql-pattern.c"
							}
						}
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp23_ = self->priv->query;
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp24_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp25_ = _tmp24_;
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp26_ = string_substring (_tmp25_, (glong) 1, (glong) -1);
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp27_ = _tmp26_;
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp28_ = tracker_sparql_query_resolve_prefixed_name (_tmp23_, "", _tmp27_, &_inner_error_);
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp29_ = _tmp28_;
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp27_);
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp25_);
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp22_ = _tmp29_;
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_propagate_error (error, _inner_error_);
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_predicate);
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return;
#line 6444 "tracker-sparql-pattern.c"
							} else {
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_predicate);
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_clear_error (&_inner_error_);
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return;
#line 6454 "tracker-sparql-pattern.c"
							}
						}
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp30_ = _tmp22_;
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp22_ = NULL;
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (self->priv->current_predicate);
#line 620 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						self->priv->current_predicate = _tmp30_;
#line 618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp22_);
#line 6467 "tracker-sparql-pattern.c"
					} else {
						TrackerSparqlTokenType _tmp31_;
#line 621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp31_ = tracker_sparql_pattern_current (self);
#line 621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_tmp31_ == TRACKER_SPARQL_TOKEN_TYPE_A) {
#line 6474 "tracker-sparql-pattern.c"
							gchar* _tmp32_;
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							tracker_sparql_pattern_next (self, &_inner_error_);
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_propagate_error (error, _inner_error_);
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (old_predicate);
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return;
#line 6488 "tracker-sparql-pattern.c"
								} else {
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (old_predicate);
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_clear_error (&_inner_error_);
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return;
#line 6498 "tracker-sparql-pattern.c"
								}
							}
#line 623 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp32_ = g_strdup ("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
#line 623 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (self->priv->current_predicate);
#line 623 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							self->priv->current_predicate = _tmp32_;
#line 6507 "tracker-sparql-pattern.c"
						} else {
							GError* _tmp33_;
#line 625 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp33_ = tracker_sparql_pattern_get_error (self, "expected non-empty property list");
#line 625 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_inner_error_ = _tmp33_;
#line 625 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 625 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_propagate_error (error, _inner_error_);
#line 625 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_predicate);
#line 625 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return;
#line 6522 "tracker-sparql-pattern.c"
							} else {
#line 625 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_predicate);
#line 625 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 625 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_clear_error (&_inner_error_);
#line 625 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return;
#line 6532 "tracker-sparql-pattern.c"
							}
						}
					}
				}
			}
		}
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp34_ = sql;
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp35_ = in_simple_optional;
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_parse_object_list (self, _tmp34_, _tmp35_, &_inner_error_);
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (old_predicate);
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6555 "tracker-sparql-pattern.c"
			} else {
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (old_predicate);
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6565 "tracker-sparql-pattern.c"
			}
		}
#line 629 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp36_ = old_predicate;
#line 629 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp37_ = g_strdup (_tmp36_);
#line 629 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (self->priv->current_predicate);
#line 629 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->current_predicate = _tmp37_;
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp38_ = old_predicate_is_var;
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->current_predicate_is_var = _tmp38_;
#line 632 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp40_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, &_inner_error_);
#line 632 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp39_ = _tmp40_;
#line 632 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 632 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 632 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 632 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (old_predicate);
#line 632 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6594 "tracker-sparql-pattern.c"
			} else {
#line 632 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (old_predicate);
#line 632 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 632 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 632 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6604 "tracker-sparql-pattern.c"
			}
		}
#line 632 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp39_) {
#line 6609 "tracker-sparql-pattern.c"
			TrackerSparqlTokenType _tmp41_;
#line 633 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp41_ = tracker_sparql_pattern_current (self);
#line 633 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp41_ == TRACKER_SPARQL_TOKEN_TYPE_DOT) {
#line 635 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (old_predicate);
#line 635 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				break;
#line 6619 "tracker-sparql-pattern.c"
			}
#line 637 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (old_predicate);
#line 637 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			continue;
#line 6625 "tracker-sparql-pattern.c"
		}
#line 639 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (old_predicate);
#line 639 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		break;
#line 6631 "tracker-sparql-pattern.c"
	}
}


static void tracker_sparql_pattern_translate_filter (TrackerSparqlPattern* self, GString* sql, GError** error) {
	TrackerSparqlExpression* _tmp0_;
	GString* _tmp1_;
	GError * _inner_error_ = NULL;
#line 643 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 643 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_FILTER, &_inner_error_);
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6654 "tracker-sparql-pattern.c"
		} else {
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6662 "tracker-sparql-pattern.c"
		}
	}
#line 645 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->expression;
#line 645 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = sql;
#line 645 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_expression_translate_constraint (_tmp0_, _tmp1_, &_inner_error_);
#line 645 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 645 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 645 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 645 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6679 "tracker-sparql-pattern.c"
		} else {
#line 645 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 645 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 645 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6687 "tracker-sparql-pattern.c"
		}
	}
}


static void tracker_sparql_pattern_skip_filter (TrackerSparqlPattern* self, GError** error) {
	TrackerSparqlTokenType _tmp0_;
	gint n_parens = 0;
	GError * _inner_error_ = NULL;
#line 648 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_FILTER, &_inner_error_);
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6709 "tracker-sparql-pattern.c"
		} else {
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6717 "tracker-sparql-pattern.c"
		}
	}
#line 651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = tracker_sparql_pattern_current (self);
#line 651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	switch (_tmp0_) {
#line 651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
#line 651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
#line 651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
#line 651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
#line 651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
#line 651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
#line 651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
#line 651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
#line 651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
#line 651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
#line 651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
#line 6746 "tracker-sparql-pattern.c"
		{
#line 663 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_next (self, &_inner_error_);
#line 663 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 663 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 663 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 663 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 6758 "tracker-sparql-pattern.c"
				} else {
#line 663 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 663 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 663 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 6766 "tracker-sparql-pattern.c"
				}
			}
#line 664 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			break;
#line 6771 "tracker-sparql-pattern.c"
		}
		default:
		{
#line 666 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			break;
#line 6777 "tracker-sparql-pattern.c"
		}
	}
#line 669 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 669 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 669 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 669 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 669 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6790 "tracker-sparql-pattern.c"
		} else {
#line 669 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 669 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 669 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 6798 "tracker-sparql-pattern.c"
		}
	}
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	n_parens = 1;
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	while (TRUE) {
#line 6805 "tracker-sparql-pattern.c"
		gint _tmp1_;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp1_ = n_parens;
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!(_tmp1_ > 0)) {
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			break;
#line 6815 "tracker-sparql-pattern.c"
		}
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = _tmp3_;
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6829 "tracker-sparql-pattern.c"
			} else {
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 6837 "tracker-sparql-pattern.c"
			}
		}
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp2_) {
#line 6842 "tracker-sparql-pattern.c"
			gint _tmp4_;
#line 673 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp4_ = n_parens;
#line 673 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			n_parens = _tmp4_ + 1;
#line 6848 "tracker-sparql-pattern.c"
		} else {
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_;
#line 674 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp6_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 674 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp5_ = _tmp6_;
#line 674 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 674 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 674 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 674 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 6864 "tracker-sparql-pattern.c"
				} else {
#line 674 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 674 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 674 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 6872 "tracker-sparql-pattern.c"
				}
			}
#line 674 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp5_) {
#line 6877 "tracker-sparql-pattern.c"
				gint _tmp7_;
#line 675 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp7_ = n_parens;
#line 675 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				n_parens = _tmp7_ - 1;
#line 6883 "tracker-sparql-pattern.c"
			} else {
				TrackerSparqlTokenType _tmp8_;
#line 676 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp8_ = tracker_sparql_pattern_current (self);
#line 676 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp8_ == TRACKER_SPARQL_TOKEN_TYPE_EOF) {
#line 6890 "tracker-sparql-pattern.c"
					GError* _tmp9_;
#line 677 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp9_ = tracker_sparql_pattern_get_error (self, "unexpected end of query, expected )");
#line 677 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_inner_error_ = _tmp9_;
#line 677 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 677 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 677 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 6902 "tracker-sparql-pattern.c"
					} else {
#line 677 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 677 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 677 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 6910 "tracker-sparql-pattern.c"
					}
				} else {
#line 680 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_next (self, &_inner_error_);
#line 680 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 680 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 680 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 680 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6923 "tracker-sparql-pattern.c"
						} else {
#line 680 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 680 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 680 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 6931 "tracker-sparql-pattern.c"
						}
					}
				}
			}
		}
	}
}


static void tracker_sparql_pattern_start_triples_block (TrackerSparqlPattern* self, GString* sql, GError** error) {
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlContext* _tmp1_;
	TrackerSparqlContext* _tmp2_;
	TrackerSparqlPatternTripleContext* _tmp3_;
	TrackerSparqlPatternTripleContext* _tmp4_;
	GString* _tmp5_;
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 686 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 686 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = tracker_sparql_pattern_get_context (self);
#line 686 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = _tmp1_;
#line 686 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = tracker_sparql_pattern_triple_context_new (_tmp0_, _tmp2_);
#line 686 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (self->priv->triple_context);
#line 686 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->priv->triple_context = _tmp3_;
#line 686 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp4_ = self->priv->triple_context;
#line 686 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, (TrackerSparqlContext*) _tmp4_);
#line 688 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp5_ = sql;
#line 688 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_append (_tmp5_, "SELECT ");
#line 6972 "tracker-sparql-pattern.c"
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_;
	gint _tmp3__length1;
#line 1078 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = separator;
#line 1078 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp0_ == NULL) {
#line 1079 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		separator = "";
#line 6989 "tracker-sparql-pattern.c"
	}
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = str_array;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3__length1 = str_array_length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp2_ = TRUE;
#line 6999 "tracker-sparql-pattern.c"
	} else {
		gchar** _tmp4_;
		gint _tmp4__length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = str_array;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4__length1 = str_array_length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp4__length1 > 0;
#line 7009 "tracker-sparql-pattern.c"
	}
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp2_) {
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 7015 "tracker-sparql-pattern.c"
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_;
		gint _tmp6__length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = str_array;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6__length1 = str_array_length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		if (_tmp6__length1 == -1) {
#line 7026 "tracker-sparql-pattern.c"
			gchar** _tmp7_;
			gint _tmp7__length1;
			const gchar* _tmp8_;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp7_ = str_array;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp7__length1 = str_array_length1;
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp8_ = _tmp7_[0];
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp5_ = _tmp8_ != NULL;
#line 7038 "tracker-sparql-pattern.c"
		} else {
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp5_ = FALSE;
#line 7042 "tracker-sparql-pattern.c"
		}
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp1_ = _tmp5_;
#line 7046 "tracker-sparql-pattern.c"
	}
#line 1081 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 7050 "tracker-sparql-pattern.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_;
		gint _tmp33_;
		gint _tmp34_;
		gsize _tmp35_;
		const gchar* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		const gchar* res = NULL;
		gsize _tmp40_;
		void* _tmp41_;
		void* ptr = NULL;
		const gchar* _tmp42_;
		gchar** _tmp43_;
		gint _tmp43__length1;
		const gchar* _tmp44_;
		void* _tmp45_;
		const gchar* _tmp62_;
#line 1083 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		len = (gsize) 1;
#line 7073 "tracker-sparql-pattern.c"
		{
			gboolean _tmp9_ = FALSE;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			i = 0;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp9_ = TRUE;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 7082 "tracker-sparql-pattern.c"
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gint _tmp21_ = 0;
				gchar** _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				const gchar* _tmp24_;
				gsize _tmp30_;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (!_tmp9_) {
#line 7095 "tracker-sparql-pattern.c"
					gint _tmp10_;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp10_ = i;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					i = _tmp10_ + 1;
#line 7101 "tracker-sparql-pattern.c"
				}
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp9_ = FALSE;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp13_ = str_array;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp13__length1 = str_array_length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (_tmp13__length1 != -1) {
#line 7111 "tracker-sparql-pattern.c"
					gint _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp14_ = i;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp15_ = str_array;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp15__length1 = str_array_length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp12_ = _tmp14_ < _tmp15__length1;
#line 7123 "tracker-sparql-pattern.c"
				} else {
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp12_ = FALSE;
#line 7127 "tracker-sparql-pattern.c"
				}
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (_tmp12_) {
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp11_ = TRUE;
#line 7133 "tracker-sparql-pattern.c"
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_;
					gint _tmp17__length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp17_ = str_array;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp17__length1 = str_array_length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					if (_tmp17__length1 == -1) {
#line 7144 "tracker-sparql-pattern.c"
						gchar** _tmp18_;
						gint _tmp18__length1;
						gint _tmp19_;
						const gchar* _tmp20_;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp18_ = str_array;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp18__length1 = str_array_length1;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp19_ = i;
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp20_ = _tmp18_[_tmp19_];
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp16_ = _tmp20_ != NULL;
#line 7159 "tracker-sparql-pattern.c"
					} else {
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
						_tmp16_ = FALSE;
#line 7163 "tracker-sparql-pattern.c"
					}
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp11_ = _tmp16_;
#line 7167 "tracker-sparql-pattern.c"
				}
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (!_tmp11_) {
#line 1084 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					break;
#line 7173 "tracker-sparql-pattern.c"
				}
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp22_ = str_array;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp22__length1 = str_array_length1;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp23_ = i;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp24_ = _tmp22_[_tmp23_];
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (_tmp24_ != NULL) {
#line 7185 "tracker-sparql-pattern.c"
					gchar** _tmp25_;
					gint _tmp25__length1;
					gint _tmp26_;
					const gchar* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp25_ = str_array;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp25__length1 = str_array_length1;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp26_ = i;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp27_ = _tmp25_[_tmp26_];
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp28_ = strlen ((const gchar*) _tmp27_);
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp29_ = _tmp28_;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp21_ = _tmp29_;
#line 7206 "tracker-sparql-pattern.c"
				} else {
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp21_ = 0;
#line 7210 "tracker-sparql-pattern.c"
				}
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp30_ = len;
#line 1085 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				len = _tmp30_ + _tmp21_;
#line 7216 "tracker-sparql-pattern.c"
			}
		}
#line 1087 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp31_ = i;
#line 1087 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		if (_tmp31_ == 0) {
#line 7223 "tracker-sparql-pattern.c"
			gchar* _tmp32_;
#line 1088 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp32_ = g_strdup ("");
#line 1088 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			result = _tmp32_;
#line 1088 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			return result;
#line 7231 "tracker-sparql-pattern.c"
		}
#line 1090 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp33_ = i;
#line 1090 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		str_array_length1 = _tmp33_;
#line 1090 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp34_ = str_array_length1;
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp35_ = len;
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp36_ = separator;
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp37_ = strlen ((const gchar*) _tmp36_);
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp38_ = _tmp37_;
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp39_ = i;
#line 1091 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
#line 1093 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp40_ = len;
#line 1093 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp41_ = g_malloc (_tmp40_);
#line 1093 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		res = _tmp41_;
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp42_ = res;
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp43_ = str_array;
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp43__length1 = str_array_length1;
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp44_ = _tmp43_[0];
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
#line 1094 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		ptr = _tmp45_;
#line 7269 "tracker-sparql-pattern.c"
		{
			gboolean _tmp46_ = FALSE;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			i = 1;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			_tmp46_ = TRUE;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 7278 "tracker-sparql-pattern.c"
				gint _tmp48_;
				gchar** _tmp49_;
				gint _tmp49__length1;
				void* _tmp50_;
				const gchar* _tmp51_;
				void* _tmp52_;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_;
				gint _tmp54__length1;
				gint _tmp55_;
				const gchar* _tmp56_;
				void* _tmp60_;
				void* _tmp61_;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (!_tmp46_) {
#line 7294 "tracker-sparql-pattern.c"
					gint _tmp47_;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp47_ = i;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					i = _tmp47_ + 1;
#line 7300 "tracker-sparql-pattern.c"
				}
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp46_ = FALSE;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp48_ = i;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp49_ = str_array;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp49__length1 = str_array_length1;
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (!(_tmp48_ < _tmp49__length1)) {
#line 1095 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					break;
#line 7314 "tracker-sparql-pattern.c"
				}
#line 1096 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp50_ = ptr;
#line 1096 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp51_ = separator;
#line 1096 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
#line 1096 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				ptr = _tmp52_;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp54_ = str_array;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp54__length1 = str_array_length1;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp55_ = i;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp56_ = _tmp54_[_tmp55_];
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				if (_tmp56_ != NULL) {
#line 7334 "tracker-sparql-pattern.c"
					gchar** _tmp57_;
					gint _tmp57__length1;
					gint _tmp58_;
					const gchar* _tmp59_;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp57_ = str_array;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp57__length1 = str_array_length1;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp58_ = i;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp59_ = _tmp57_[_tmp58_];
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp53_ = (const gchar*) _tmp59_;
#line 7349 "tracker-sparql-pattern.c"
				} else {
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
					_tmp53_ = "";
#line 7353 "tracker-sparql-pattern.c"
				}
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp60_ = ptr;
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
#line 1097 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
				ptr = _tmp61_;
#line 7361 "tracker-sparql-pattern.c"
			}
		}
#line 1100 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp62_ = res;
#line 1100 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		res = NULL;
#line 1100 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = (gchar*) _tmp62_;
#line 1100 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 7372 "tracker-sparql-pattern.c"
	} else {
		gchar* _tmp63_;
#line 1102 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp63_ = g_strdup ("");
#line 1102 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = _tmp63_;
#line 1102 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 7381 "tracker-sparql-pattern.c"
	}
}


static void tracker_sparql_pattern_end_triples_block (TrackerSparqlPattern* self, GString* sql, gboolean* first_where, gboolean in_group_graph_pattern, GError** error) {
	GString* _tmp0_;
	GString* _tmp1_;
	gssize _tmp2_;
	GString* _tmp3_;
	gboolean first = FALSE;
	TrackerSparqlPatternTripleContext* _tmp4_;
	GList* _tmp5_;
	TrackerSparqlPatternTripleContext* _tmp23_;
	GList* _tmp24_;
	TrackerSparqlPatternTripleContext* _tmp80_;
	GList* _tmp81_;
	gboolean _tmp113_;
	TrackerSparqlContext* _tmp115_;
	TrackerSparqlContext* _tmp116_;
	GHashTable* _tmp117_;
	GList* _tmp118_;
	TrackerSparqlContext* _tmp125_;
	TrackerSparqlContext* _tmp126_;
	TrackerSparqlContext* _tmp127_;
	GError * _inner_error_ = NULL;
#line 691 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 691 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 693 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = sql;
#line 693 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = sql;
#line 693 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = _tmp1_->len;
#line 693 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_truncate (_tmp0_, (gsize) (_tmp2_ - 2));
#line 695 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = sql;
#line 695 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_string_append (_tmp3_, " FROM ");
#line 696 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	first = TRUE;
#line 697 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp4_ = self->priv->triple_context;
#line 697 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp5_ = _tmp4_->tables;
#line 7429 "tracker-sparql-pattern.c"
	{
		GList* table_collection = NULL;
		GList* table_it = NULL;
#line 697 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		table_collection = _tmp5_;
#line 697 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (table_it = table_collection; table_it != NULL; table_it = table_it->next) {
#line 7437 "tracker-sparql-pattern.c"
			TrackerSparqlDataTable* _tmp6_;
			TrackerSparqlDataTable* table = NULL;
#line 697 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp6_ = _g_object_ref0 ((TrackerSparqlDataTable*) table_it->data);
#line 697 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			table = _tmp6_;
#line 7444 "tracker-sparql-pattern.c"
			{
				gboolean _tmp7_;
				TrackerSparqlDataTable* _tmp9_;
				const gchar* _tmp10_;
				GString* _tmp20_;
				TrackerSparqlDataTable* _tmp21_;
				const gchar* _tmp22_;
#line 698 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp7_ = first;
#line 698 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp7_) {
#line 7456 "tracker-sparql-pattern.c"
					GString* _tmp8_;
#line 699 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp8_ = sql;
#line 699 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp8_, ", ");
#line 7462 "tracker-sparql-pattern.c"
				} else {
#line 701 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					first = FALSE;
#line 7466 "tracker-sparql-pattern.c"
				}
#line 703 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp9_ = table;
#line 703 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp10_ = _tmp9_->sql_db_tablename;
#line 703 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp10_ != NULL) {
#line 7474 "tracker-sparql-pattern.c"
					GString* _tmp11_;
					TrackerSparqlDataTable* _tmp12_;
					const gchar* _tmp13_;
#line 704 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp11_ = sql;
#line 704 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp12_ = table;
#line 704 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp13_ = _tmp12_->sql_db_tablename;
#line 704 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append_printf (_tmp11_, "\"%s\"", _tmp13_);
#line 7486 "tracker-sparql-pattern.c"
				} else {
					gchar* _tmp14_ = NULL;
					TrackerSparqlDataTable* _tmp15_;
					TrackerSparqlPredicateVariable* _tmp16_;
					TrackerSparqlQuery* _tmp17_;
					gchar* _tmp18_;
					GString* _tmp19_;
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp15_ = table;
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp16_ = _tmp15_->predicate_variable;
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp17_ = self->priv->query;
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp18_ = tracker_sparql_predicate_variable_get_sql_query (_tmp16_, _tmp17_, &_inner_error_);
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp14_ = _tmp18_;
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (table);
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 7514 "tracker-sparql-pattern.c"
						} else {
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (table);
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 7524 "tracker-sparql-pattern.c"
						}
					}
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp19_ = sql;
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append_printf (_tmp19_, "(%s)", _tmp14_);
#line 703 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp14_);
#line 7533 "tracker-sparql-pattern.c"
				}
#line 708 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp20_ = sql;
#line 708 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp21_ = table;
#line 708 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp22_ = _tmp21_->sql_query_tablename;
#line 708 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append_printf (_tmp20_, " AS \"%s\"", _tmp22_);
#line 697 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (table);
#line 7545 "tracker-sparql-pattern.c"
			}
		}
	}
#line 711 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp23_ = self->priv->triple_context;
#line 711 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp24_ = _tmp23_->variables;
#line 7553 "tracker-sparql-pattern.c"
	{
		GList* variable_collection = NULL;
		GList* variable_it = NULL;
#line 711 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		variable_collection = _tmp24_;
#line 711 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (variable_it = variable_collection; variable_it != NULL; variable_it = variable_it->next) {
#line 7561 "tracker-sparql-pattern.c"
			TrackerSparqlVariable* _tmp25_;
			TrackerSparqlVariable* variable = NULL;
#line 711 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp25_ = _g_object_ref0 ((TrackerSparqlVariable*) variable_it->data);
#line 711 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			variable = _tmp25_;
#line 7568 "tracker-sparql-pattern.c"
			{
				gboolean maybe_null = FALSE;
				gboolean in_simple_optional = FALSE;
				TrackerPropertyType last_type = 0;
				gchar* last_name = NULL;
				TrackerSparqlPatternTripleContext* _tmp26_;
				GHashTable* _tmp27_;
				TrackerSparqlVariable* _tmp28_;
				gconstpointer _tmp29_;
				GList* _tmp30_;
				gboolean _tmp70_ = FALSE;
				gboolean _tmp71_;
#line 712 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				maybe_null = TRUE;
#line 713 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				in_simple_optional = FALSE;
#line 714 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				last_type = TRACKER_PROPERTY_TYPE_UNKNOWN;
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				last_name = NULL;
#line 716 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp26_ = self->priv->triple_context;
#line 716 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp27_ = _tmp26_->var_bindings;
#line 716 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp28_ = variable;
#line 716 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp29_ = g_hash_table_lookup (_tmp27_, _tmp28_);
#line 716 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp30_ = ((TrackerSparqlVariableBindingList*) _tmp29_)->list;
#line 7599 "tracker-sparql-pattern.c"
				{
					GList* binding_collection = NULL;
					GList* binding_it = NULL;
#line 716 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					binding_collection = _tmp30_;
#line 716 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
#line 7607 "tracker-sparql-pattern.c"
						TrackerSparqlVariableBinding* _tmp31_;
						TrackerSparqlVariableBinding* binding = NULL;
#line 716 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp31_ = _g_object_ref0 ((TrackerSparqlVariableBinding*) binding_it->data);
#line 716 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						binding = _tmp31_;
#line 7614 "tracker-sparql-pattern.c"
						{
							gchar* name = NULL;
							TrackerSparqlVariableBinding* _tmp32_;
							TrackerSparqlDataTable* _tmp33_;
							TrackerPropertyType type = 0;
							TrackerSparqlVariableBinding* _tmp42_;
							TrackerPropertyType _tmp43_;
							const gchar* _tmp44_;
							const gchar* _tmp63_;
							gchar* _tmp64_;
							TrackerPropertyType _tmp65_;
							TrackerSparqlVariableBinding* _tmp66_;
							gboolean _tmp67_;
							TrackerSparqlVariableBinding* _tmp68_;
							gboolean _tmp69_;
#line 718 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp32_ = binding;
#line 718 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp33_ = ((TrackerSparqlDataBinding*) _tmp32_)->table;
#line 718 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_tmp33_ != NULL) {
#line 7636 "tracker-sparql-pattern.c"
								TrackerSparqlVariableBinding* _tmp34_;
								const gchar* _tmp35_;
								const gchar* _tmp36_;
								gchar* _tmp37_;
#line 719 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp34_ = binding;
#line 719 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp35_ = tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) _tmp34_);
#line 719 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp36_ = _tmp35_;
#line 719 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp37_ = g_strdup (_tmp36_);
#line 719 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (name);
#line 719 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								name = _tmp37_;
#line 7653 "tracker-sparql-pattern.c"
							} else {
								TrackerSparqlVariable* _tmp38_;
								const gchar* _tmp39_;
								const gchar* _tmp40_;
								gchar* _tmp41_;
#line 723 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp38_ = variable;
#line 723 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp39_ = tracker_sparql_variable_get_sql_expression (_tmp38_);
#line 723 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp40_ = _tmp39_;
#line 723 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp41_ = g_strdup (_tmp40_);
#line 723 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (name);
#line 723 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								name = _tmp41_;
#line 7671 "tracker-sparql-pattern.c"
							}
#line 725 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp42_ = binding;
#line 725 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp43_ = ((TrackerSparqlDataBinding*) _tmp42_)->data_type;
#line 725 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							type = _tmp43_;
#line 726 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp44_ = last_name;
#line 726 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_tmp44_ != NULL) {
#line 7683 "tracker-sparql-pattern.c"
								gboolean _tmp45_;
								gboolean _tmp48_ = FALSE;
								TrackerPropertyType _tmp49_;
								GString* _tmp55_;
								gboolean _tmp56_ = FALSE;
								TrackerPropertyType _tmp57_;
#line 727 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp45_ = *first_where;
#line 727 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (!_tmp45_) {
#line 7694 "tracker-sparql-pattern.c"
									GString* _tmp46_;
#line 728 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp46_ = sql;
#line 728 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp46_, " AND ");
#line 7700 "tracker-sparql-pattern.c"
								} else {
									GString* _tmp47_;
#line 730 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp47_ = sql;
#line 730 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp47_, " WHERE ");
#line 731 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									*first_where = FALSE;
#line 7709 "tracker-sparql-pattern.c"
								}
#line 734 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp49_ = last_type;
#line 734 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp49_ == TRACKER_PROPERTY_TYPE_STRING) {
#line 7715 "tracker-sparql-pattern.c"
									TrackerPropertyType _tmp50_;
#line 734 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp50_ = type;
#line 734 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp48_ = _tmp50_ == TRACKER_PROPERTY_TYPE_RESOURCE;
#line 7721 "tracker-sparql-pattern.c"
								} else {
#line 734 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp48_ = FALSE;
#line 7725 "tracker-sparql-pattern.c"
								}
#line 734 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp48_) {
#line 7729 "tracker-sparql-pattern.c"
									GString* _tmp51_;
									const gchar* _tmp52_;
#line 735 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp51_ = sql;
#line 735 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp52_ = last_name;
#line 735 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp51_, "(SELECT ID FROM Resource WHERE Uri = %s)", _tmp52_);
#line 7738 "tracker-sparql-pattern.c"
								} else {
									GString* _tmp53_;
									const gchar* _tmp54_;
#line 737 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp53_ = sql;
#line 737 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp54_ = last_name;
#line 737 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp53_, _tmp54_);
#line 7748 "tracker-sparql-pattern.c"
								}
#line 740 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp55_ = sql;
#line 740 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_string_append (_tmp55_, " = ");
#line 742 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp57_ = last_type;
#line 742 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp57_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 7758 "tracker-sparql-pattern.c"
									TrackerPropertyType _tmp58_;
#line 742 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp58_ = type;
#line 742 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp56_ = _tmp58_ == TRACKER_PROPERTY_TYPE_STRING;
#line 7764 "tracker-sparql-pattern.c"
								} else {
#line 742 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp56_ = FALSE;
#line 7768 "tracker-sparql-pattern.c"
								}
#line 742 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp56_) {
#line 7772 "tracker-sparql-pattern.c"
									GString* _tmp59_;
									const gchar* _tmp60_;
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp59_ = sql;
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp60_ = name;
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp59_, "(SELECT ID FROM Resource WHERE Uri = %s)", _tmp60_);
#line 7781 "tracker-sparql-pattern.c"
								} else {
									GString* _tmp61_;
									const gchar* _tmp62_;
#line 745 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp61_ = sql;
#line 745 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp62_ = name;
#line 745 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp61_, _tmp62_);
#line 7791 "tracker-sparql-pattern.c"
								}
							}
#line 748 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp63_ = name;
#line 748 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp64_ = g_strdup (_tmp63_);
#line 748 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (last_name);
#line 748 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							last_name = _tmp64_;
#line 749 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp65_ = type;
#line 749 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							last_type = _tmp65_;
#line 750 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp66_ = binding;
#line 750 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp67_ = _tmp66_->maybe_null;
#line 750 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (!_tmp67_) {
#line 751 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								maybe_null = FALSE;
#line 7814 "tracker-sparql-pattern.c"
							}
#line 753 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp68_ = binding;
#line 753 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp69_ = _tmp68_->in_simple_optional;
#line 753 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							in_simple_optional = _tmp69_;
#line 716 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (name);
#line 716 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 7826 "tracker-sparql-pattern.c"
						}
					}
				}
#line 756 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp71_ = maybe_null;
#line 756 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp71_) {
#line 7834 "tracker-sparql-pattern.c"
					gboolean _tmp72_;
#line 756 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp72_ = in_simple_optional;
#line 756 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp70_ = !_tmp72_;
#line 7840 "tracker-sparql-pattern.c"
				} else {
#line 756 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp70_ = FALSE;
#line 7844 "tracker-sparql-pattern.c"
				}
#line 756 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp70_) {
#line 7848 "tracker-sparql-pattern.c"
					gboolean _tmp73_;
					GString* _tmp76_;
					TrackerSparqlVariable* _tmp77_;
					const gchar* _tmp78_;
					const gchar* _tmp79_;
#line 759 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp73_ = *first_where;
#line 759 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp73_) {
#line 7858 "tracker-sparql-pattern.c"
						GString* _tmp74_;
#line 760 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp74_ = sql;
#line 760 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp74_, " AND ");
#line 7864 "tracker-sparql-pattern.c"
					} else {
						GString* _tmp75_;
#line 762 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp75_ = sql;
#line 762 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp75_, " WHERE ");
#line 763 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						*first_where = FALSE;
#line 7873 "tracker-sparql-pattern.c"
					}
#line 765 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp76_ = sql;
#line 765 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp77_ = variable;
#line 765 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp78_ = tracker_sparql_variable_get_sql_expression (_tmp77_);
#line 765 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp79_ = _tmp78_;
#line 765 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append_printf (_tmp76_, "%s IS NOT NULL", _tmp79_);
#line 7885 "tracker-sparql-pattern.c"
				}
#line 711 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (last_name);
#line 711 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (variable);
#line 7891 "tracker-sparql-pattern.c"
			}
		}
	}
#line 768 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp80_ = self->priv->triple_context;
#line 768 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp81_ = _tmp80_->bindings;
#line 7899 "tracker-sparql-pattern.c"
	{
		GList* binding_collection = NULL;
		GList* binding_it = NULL;
#line 768 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		binding_collection = _tmp81_;
#line 768 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
#line 7907 "tracker-sparql-pattern.c"
			TrackerSparqlLiteralBinding* _tmp82_;
			TrackerSparqlLiteralBinding* binding = NULL;
#line 768 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp82_ = _g_object_ref0 ((TrackerSparqlLiteralBinding*) binding_it->data);
#line 768 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			binding = _tmp82_;
#line 7914 "tracker-sparql-pattern.c"
			{
				gboolean _tmp83_;
				GString* _tmp86_;
				TrackerSparqlLiteralBinding* _tmp87_;
				const gchar* _tmp88_;
				const gchar* _tmp89_;
				TrackerSparqlLiteralBinding* _tmp90_;
				gboolean _tmp91_;
#line 769 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp83_ = *first_where;
#line 769 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp83_) {
#line 7927 "tracker-sparql-pattern.c"
					GString* _tmp84_;
#line 770 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp84_ = sql;
#line 770 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp84_, " AND ");
#line 7933 "tracker-sparql-pattern.c"
				} else {
					GString* _tmp85_;
#line 772 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp85_ = sql;
#line 772 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp85_, " WHERE ");
#line 773 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					*first_where = FALSE;
#line 7942 "tracker-sparql-pattern.c"
				}
#line 775 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp86_ = sql;
#line 775 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp87_ = binding;
#line 775 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp88_ = tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) _tmp87_);
#line 775 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp89_ = _tmp88_;
#line 775 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append (_tmp86_, _tmp89_);
#line 776 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp90_ = binding;
#line 776 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp91_ = _tmp90_->is_fts_match;
#line 776 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp91_) {
#line 7960 "tracker-sparql-pattern.c"
					gchar* escaped_literal = NULL;
					TrackerSparqlLiteralBinding* _tmp92_;
					const gchar* _tmp93_;
					gchar** _tmp94_;
					gchar** _tmp95_;
					gchar** _tmp96_;
					gint _tmp96__length1;
					gchar* _tmp97_;
					gchar* _tmp98_;
					GString* _tmp99_;
					const gchar* _tmp100_;
					GString* _tmp101_;
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp92_ = binding;
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp93_ = _tmp92_->literal;
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp95_ = _tmp94_ = g_strsplit (_tmp93_, "'", 0);
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp96_ = _tmp95_;
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp96__length1 = _vala_array_length (_tmp94_);
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp97_ = _vala_g_strjoinv ("''", _tmp96_, _vala_array_length (_tmp94_));
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp98_ = _tmp97_;
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp96_ = (_vala_array_free (_tmp96_, _tmp96__length1, (GDestroyNotify) g_free), NULL);
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					escaped_literal = _tmp98_;
#line 779 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp99_ = sql;
#line 779 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp100_ = escaped_literal;
#line 779 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append_printf (_tmp99_, " MATCH '%s'", _tmp100_);
#line 781 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp101_ = self->match_str;
#line 781 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp101_ == NULL) {
#line 8001 "tracker-sparql-pattern.c"
						GString* _tmp102_;
						GString* _tmp103_;
						const gchar* _tmp104_;
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp102_ = g_string_new ("");
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (self->match_str);
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						self->match_str = _tmp102_;
#line 783 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp103_ = self->match_str;
#line 783 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp104_ = escaped_literal;
#line 783 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append_printf (_tmp103_, " MATCH '%s'", _tmp104_);
#line 8017 "tracker-sparql-pattern.c"
					}
#line 776 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (escaped_literal);
#line 8021 "tracker-sparql-pattern.c"
				} else {
					GString* _tmp105_;
					TrackerSparqlLiteralBinding* _tmp106_;
					TrackerPropertyType _tmp107_;
					TrackerSparqlQuery* _tmp110_;
					TrackerSparqlLiteralBinding* _tmp111_;
					TrackerSparqlLiteralBinding* _tmp112_;
#line 786 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp105_ = sql;
#line 786 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp105_, " = ");
#line 787 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp106_ = binding;
#line 787 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp107_ = ((TrackerSparqlDataBinding*) _tmp106_)->data_type;
#line 787 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp107_ == TRACKER_PROPERTY_TYPE_RESOURCE) {
#line 8039 "tracker-sparql-pattern.c"
						GString* _tmp108_;
#line 788 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp108_ = sql;
#line 788 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp108_, "(SELECT ID FROM Resource WHERE Uri = ?)");
#line 8045 "tracker-sparql-pattern.c"
					} else {
						GString* _tmp109_;
#line 790 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp109_ = sql;
#line 790 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp109_, "?");
#line 8052 "tracker-sparql-pattern.c"
					}
#line 792 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp110_ = self->priv->query;
#line 792 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp111_ = binding;
#line 792 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp112_ = _g_object_ref0 (_tmp111_);
#line 792 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp110_->bindings = g_list_append (_tmp110_->bindings, _tmp112_);
#line 8062 "tracker-sparql-pattern.c"
				}
#line 768 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding);
#line 8066 "tracker-sparql-pattern.c"
			}
		}
	}
#line 796 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp113_ = in_group_graph_pattern;
#line 796 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp113_) {
#line 8074 "tracker-sparql-pattern.c"
		GString* _tmp114_;
#line 797 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp114_ = sql;
#line 797 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp114_, ")");
#line 8080 "tracker-sparql-pattern.c"
	}
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp115_ = tracker_sparql_pattern_get_context (self);
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp116_ = _tmp115_;
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp117_ = _tmp116_->var_set;
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp118_ = g_hash_table_get_keys (_tmp117_);
#line 8090 "tracker-sparql-pattern.c"
	{
		GList* v_collection = NULL;
		GList* v_it = NULL;
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		v_collection = _tmp118_;
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
#line 8098 "tracker-sparql-pattern.c"
			TrackerSparqlVariable* v = NULL;
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			v = (TrackerSparqlVariable*) v_it->data;
#line 8102 "tracker-sparql-pattern.c"
			{
				TrackerSparqlContext* _tmp119_;
				TrackerSparqlContext* _tmp120_;
				TrackerSparqlContext* _tmp121_;
				GHashTable* _tmp122_;
				TrackerSparqlVariable* _tmp123_;
				TrackerSparqlVariable* _tmp124_;
#line 801 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp119_ = tracker_sparql_pattern_get_context (self);
#line 801 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp120_ = _tmp119_;
#line 801 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp121_ = _tmp120_->parent_context;
#line 801 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp122_ = _tmp121_->var_set;
#line 801 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp123_ = v;
#line 801 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp124_ = _g_object_ref0 (_tmp123_);
#line 801 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_hash_table_insert (_tmp122_, _tmp124_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)));
#line 8124 "tracker-sparql-pattern.c"
			}
		}
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_list_free0 (v_collection);
#line 8129 "tracker-sparql-pattern.c"
	}
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (self->priv->triple_context);
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->priv->triple_context = NULL;
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp125_ = tracker_sparql_pattern_get_context (self);
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp126_ = _tmp125_;
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp127_ = _tmp126_->parent_context;
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, _tmp127_);
#line 8143 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_parse_triples (TrackerSparqlPattern* self, GString* sql, glong group_graph_pattern_start, gboolean* in_triples_block, gboolean* first_where, gboolean* in_group_graph_pattern, gboolean found_simple_optional, GError** error) {
	GError * _inner_error_ = NULL;
#line 808 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 808 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 809 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	while (TRUE) {
#line 8155 "tracker-sparql-pattern.c"
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		TrackerSparqlTokenType _tmp4_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_;
		gboolean _tmp16_;
		gchar* _tmp22_ = NULL;
		GString* _tmp23_;
		gboolean _tmp24_ = FALSE;
		gchar* _tmp25_;
		gchar* _tmp26_;
		GString* _tmp27_;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_;
#line 810 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = tracker_sparql_pattern_current (self);
#line 810 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp4_ != TRACKER_SPARQL_TOKEN_TYPE_VAR) {
#line 8177 "tracker-sparql-pattern.c"
			TrackerSparqlTokenType _tmp5_;
#line 811 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp5_ = tracker_sparql_pattern_current (self);
#line 811 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp3_ = _tmp5_ != TRACKER_SPARQL_TOKEN_TYPE_IRI_REF;
#line 8183 "tracker-sparql-pattern.c"
		} else {
#line 810 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp3_ = FALSE;
#line 8187 "tracker-sparql-pattern.c"
		}
#line 810 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp3_) {
#line 8191 "tracker-sparql-pattern.c"
			TrackerSparqlTokenType _tmp6_;
#line 812 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp6_ = tracker_sparql_pattern_current (self);
#line 812 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp2_ = _tmp6_ != TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX;
#line 8197 "tracker-sparql-pattern.c"
		} else {
#line 810 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp2_ = FALSE;
#line 8201 "tracker-sparql-pattern.c"
		}
#line 810 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp2_) {
#line 8205 "tracker-sparql-pattern.c"
			TrackerSparqlTokenType _tmp7_;
#line 813 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp7_ = tracker_sparql_pattern_current (self);
#line 813 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp1_ = _tmp7_ != TRACKER_SPARQL_TOKEN_TYPE_COLON;
#line 8211 "tracker-sparql-pattern.c"
		} else {
#line 810 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp1_ = FALSE;
#line 8215 "tracker-sparql-pattern.c"
		}
#line 810 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp1_) {
#line 8219 "tracker-sparql-pattern.c"
			TrackerSparqlTokenType _tmp8_;
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp8_ = tracker_sparql_pattern_current (self);
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp0_ = _tmp8_ != TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET;
#line 8225 "tracker-sparql-pattern.c"
		} else {
#line 810 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp0_ = FALSE;
#line 8229 "tracker-sparql-pattern.c"
		}
#line 810 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp0_) {
#line 815 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			break;
#line 8235 "tracker-sparql-pattern.c"
		}
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp11_ = *in_triples_block;
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp11_) {
#line 8241 "tracker-sparql-pattern.c"
			gboolean _tmp12_;
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp12_ = *in_group_graph_pattern;
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp10_ = !_tmp12_;
#line 8247 "tracker-sparql-pattern.c"
		} else {
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp10_ = FALSE;
#line 8251 "tracker-sparql-pattern.c"
		}
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp10_) {
#line 8255 "tracker-sparql-pattern.c"
			gboolean _tmp13_;
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp13_ = found_simple_optional;
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp9_ = _tmp13_;
#line 8261 "tracker-sparql-pattern.c"
		} else {
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp9_ = FALSE;
#line 8265 "tracker-sparql-pattern.c"
		}
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp9_) {
#line 8269 "tracker-sparql-pattern.c"
			GString* _tmp14_;
			gboolean _tmp15_;
#line 821 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp14_ = sql;
#line 821 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp15_ = *in_group_graph_pattern;
#line 821 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_end_triples_block (self, _tmp14_, first_where, _tmp15_, &_inner_error_);
#line 821 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 821 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 821 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 821 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 8286 "tracker-sparql-pattern.c"
				} else {
#line 821 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 821 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 821 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 8294 "tracker-sparql-pattern.c"
				}
			}
#line 822 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			*in_triples_block = FALSE;
#line 823 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			*in_group_graph_pattern = TRUE;
#line 8301 "tracker-sparql-pattern.c"
		}
#line 825 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp16_ = *in_triples_block;
#line 825 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp16_) {
#line 8307 "tracker-sparql-pattern.c"
			gboolean _tmp17_;
			GString* _tmp21_;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp17_ = *in_group_graph_pattern;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp17_) {
#line 8314 "tracker-sparql-pattern.c"
				GString* _tmp18_;
				glong _tmp19_;
				GString* _tmp20_;
#line 827 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp18_ = sql;
#line 827 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp19_ = group_graph_pattern_start;
#line 827 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_insert (_tmp18_, (gssize) _tmp19_, "SELECT * FROM (");
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp20_ = sql;
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append (_tmp20_, ") NATURAL INNER JOIN (");
#line 8328 "tracker-sparql-pattern.c"
			}
#line 830 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			*in_triples_block = TRUE;
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			*first_where = TRUE;
#line 832 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp21_ = sql;
#line 832 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_start_triples_block (self, _tmp21_, &_inner_error_);
#line 832 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 832 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 832 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 832 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 8346 "tracker-sparql-pattern.c"
				} else {
#line 832 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 832 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 832 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 8354 "tracker-sparql-pattern.c"
				}
			}
		}
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp23_ = sql;
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp25_ = tracker_sparql_pattern_parse_var_or_term (self, _tmp23_, &_tmp24_, &_inner_error_);
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->current_subject_is_var = _tmp24_;
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp22_ = _tmp25_;
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 8374 "tracker-sparql-pattern.c"
			} else {
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 8382 "tracker-sparql-pattern.c"
			}
		}
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp26_ = _tmp22_;
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp22_ = NULL;
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (self->priv->current_subject);
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->current_subject = _tmp26_;
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp27_ = sql;
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_parse_property_list_not_empty (self, _tmp27_, FALSE, &_inner_error_);
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp22_);
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 8407 "tracker-sparql-pattern.c"
			} else {
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp22_);
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 8417 "tracker-sparql-pattern.c"
			}
		}
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp29_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp28_ = _tmp29_;
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp22_);
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 8434 "tracker-sparql-pattern.c"
			} else {
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp22_);
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return;
#line 8444 "tracker-sparql-pattern.c"
			}
		}
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp28_) {
#line 839 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp22_);
#line 839 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			break;
#line 8453 "tracker-sparql-pattern.c"
		}
#line 809 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp22_);
#line 8457 "tracker-sparql-pattern.c"
	}
}


static gboolean tracker_sparql_pattern_is_subclass (TrackerSparqlPattern* self, TrackerClass* class1, TrackerClass* class2) {
	gboolean result = FALSE;
	TrackerClass* _tmp0_;
	TrackerClass* _tmp1_;
	TrackerClass* _tmp2_;
	TrackerClass** _tmp3_;
	TrackerClass** _tmp4_;
#line 844 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 844 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (class1 != NULL, FALSE);
#line 844 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (class2 != NULL, FALSE);
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = class1;
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = class2;
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp0_ == _tmp1_) {
#line 846 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		result = TRUE;
#line 846 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		return result;
#line 8485 "tracker-sparql-pattern.c"
	}
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = class1;
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp4_ = _tmp3_ = tracker_class_get_super_classes (_tmp2_);
#line 8491 "tracker-sparql-pattern.c"
	{
		TrackerClass** superclass_collection = NULL;
		gint superclass_collection_length1 = 0;
		gint _superclass_collection_size_ = 0;
		gint superclass_it = 0;
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		superclass_collection = _tmp4_;
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		superclass_collection_length1 = _vala_array_length (_tmp3_);
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		for (superclass_it = 0; superclass_it < _vala_array_length (_tmp3_); superclass_it = superclass_it + 1) {
#line 8503 "tracker-sparql-pattern.c"
			TrackerClass* _tmp5_;
			TrackerClass* superclass = NULL;
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp5_ = _g_object_ref0 (superclass_collection[superclass_it]);
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			superclass = _tmp5_;
#line 8510 "tracker-sparql-pattern.c"
			{
				TrackerClass* _tmp6_;
				TrackerClass* _tmp7_;
				gboolean _tmp8_;
#line 849 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp6_ = superclass;
#line 849 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp7_ = class2;
#line 849 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp8_ = tracker_sparql_pattern_is_subclass (self, _tmp6_, _tmp7_);
#line 849 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp8_) {
#line 850 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					result = TRUE;
#line 850 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (superclass);
#line 850 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return result;
#line 8529 "tracker-sparql-pattern.c"
				}
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (superclass);
#line 8533 "tracker-sparql-pattern.c"
			}
		}
	}
#line 853 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = FALSE;
#line 853 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 8541 "tracker-sparql-pattern.c"
}


static gboolean tracker_sparql_pattern_is_simple_optional (TrackerSparqlPattern* self) {
	gboolean result = FALSE;
	TrackerSourceLocation optional_start = {0};
	TrackerSourceLocation _tmp0_ = {0};
	gboolean _tmp132_ = FALSE;
	GError * _inner_error_ = NULL;
#line 856 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_get_location (self, &_tmp0_);
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	optional_start = _tmp0_;
#line 8557 "tracker-sparql-pattern.c"
	{
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
		TrackerSparqlVariable* left_variable = NULL;
		TrackerSparqlContext* _tmp8_;
		TrackerSparqlContext* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		TrackerSparqlVariable* _tmp14_;
		TrackerSparqlVariable* _tmp15_;
		TrackerSparqlVariable* _tmp16_;
		gint left_variable_state = 0;
		TrackerSparqlContext* _tmp17_;
		TrackerSparqlContext* _tmp18_;
		GHashTable* _tmp19_;
		TrackerSparqlVariable* _tmp20_;
		gconstpointer _tmp21_;
		gchar* predicate = NULL;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_;
		TrackerOntologies* ontologies = NULL;
		TrackerDataManager* _tmp62_;
		TrackerOntologies* _tmp63_;
		TrackerOntologies* _tmp64_;
		TrackerProperty* prop = NULL;
		TrackerOntologies* _tmp65_;
		const gchar* _tmp66_;
		TrackerProperty* _tmp67_;
		TrackerProperty* _tmp68_;
		TrackerProperty* _tmp69_;
		gboolean _tmp71_ = FALSE;
		gboolean _tmp72_;
		TrackerSparqlVariable* right_variable = NULL;
		TrackerSparqlContext* _tmp76_;
		TrackerSparqlContext* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		TrackerSparqlVariable* _tmp82_;
		TrackerSparqlVariable* _tmp83_;
		TrackerSparqlVariable* _tmp84_;
		gint right_variable_state = 0;
		TrackerSparqlContext* _tmp85_;
		TrackerSparqlContext* _tmp86_;
		GHashTable* _tmp87_;
		TrackerSparqlVariable* _tmp88_;
		gconstpointer _tmp89_;
		gboolean _tmp92_ = FALSE;
		gboolean _tmp93_;
		gboolean _tmp97_ = FALSE;
		gboolean _tmp98_ = FALSE;
		gint _tmp99_;
#line 869 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
#line 869 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8617 "tracker-sparql-pattern.c"
			gboolean _tmp2_ = FALSE;
#line 869 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8621 "tracker-sparql-pattern.c"
				goto __catch1_tracker_sparql_error;
			}
			{
				TrackerSourceLocation _tmp1_;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp1_ = optional_start;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp1_);
#line 8630 "tracker-sparql-pattern.c"
			}
#line 869 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 869 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 869 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp2_;
#line 8638 "tracker-sparql-pattern.c"
		}
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = _tmp4_;
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8646 "tracker-sparql-pattern.c"
			gboolean _tmp6_ = FALSE;
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8650 "tracker-sparql-pattern.c"
				goto __catch1_tracker_sparql_error;
			}
			{
				TrackerSourceLocation _tmp5_;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp5_ = optional_start;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp5_);
#line 8659 "tracker-sparql-pattern.c"
			}
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp6_;
#line 8667 "tracker-sparql-pattern.c"
		}
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp3_) {
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			result = FALSE;
#line 8673 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp7_;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp7_ = optional_start;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp7_);
#line 8680 "tracker-sparql-pattern.c"
			}
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return result;
#line 8684 "tracker-sparql-pattern.c"
		}
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp8_ = tracker_sparql_pattern_get_context (self);
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp9_ = _tmp8_;
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp10_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp11_ = _tmp10_;
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp12_ = string_substring (_tmp11_, (glong) 1, (glong) -1);
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp13_ = _tmp12_;
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp14_ = tracker_sparql_context_get_variable (_tmp9_, _tmp13_);
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp15_ = _g_object_ref0 (_tmp14_);
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp16_ = _tmp15_;
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp13_);
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp11_);
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		left_variable = _tmp16_;
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp17_ = tracker_sparql_pattern_get_context (self);
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp18_ = _tmp17_;
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp19_ = _tmp18_->var_set;
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp20_ = left_variable;
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp21_ = g_hash_table_lookup (_tmp19_, _tmp20_);
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		left_variable_state = (gint) ((gintptr) _tmp21_);
#line 880 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp23_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, &_inner_error_);
#line 880 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp22_ = _tmp23_;
#line 880 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8728 "tracker-sparql-pattern.c"
			gboolean _tmp25_ = FALSE;
#line 880 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 880 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 880 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8736 "tracker-sparql-pattern.c"
				goto __catch1_tracker_sparql_error;
			}
#line 880 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 880 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 8743 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp24_;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp24_ = optional_start;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp24_);
#line 8750 "tracker-sparql-pattern.c"
			}
#line 880 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 880 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 880 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp25_;
#line 8758 "tracker-sparql-pattern.c"
		}
#line 880 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp22_) {
#line 8762 "tracker-sparql-pattern.c"
			gchar* _tmp26_;
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp26_ = tracker_sparql_pattern_get_last_string (self, 1);
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			predicate = _tmp26_;
#line 8770 "tracker-sparql-pattern.c"
		} else {
			gboolean _tmp27_ = FALSE;
			gboolean _tmp28_;
#line 882 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp28_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, &_inner_error_);
#line 882 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp27_ = _tmp28_;
#line 882 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8780 "tracker-sparql-pattern.c"
				gboolean _tmp30_ = FALSE;
#line 882 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (predicate);
#line 882 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (left_variable);
#line 882 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8788 "tracker-sparql-pattern.c"
					goto __catch1_tracker_sparql_error;
				}
#line 882 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (predicate);
#line 882 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (left_variable);
#line 8795 "tracker-sparql-pattern.c"
				{
					TrackerSourceLocation _tmp29_;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp29_ = optional_start;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_set_location (self, &_tmp29_);
#line 8802 "tracker-sparql-pattern.c"
				}
#line 882 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 882 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 882 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return _tmp30_;
#line 8810 "tracker-sparql-pattern.c"
			}
#line 882 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp27_) {
#line 8814 "tracker-sparql-pattern.c"
				gchar* ns = NULL;
				gchar* _tmp31_;
				gchar* _tmp34_ = NULL;
				TrackerSparqlQuery* _tmp35_;
				const gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp45_;
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp31_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				ns = _tmp31_;
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8835 "tracker-sparql-pattern.c"
					gboolean _tmp33_ = FALSE;
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (ns);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (left_variable);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8845 "tracker-sparql-pattern.c"
						goto __catch1_tracker_sparql_error;
					}
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (ns);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (left_variable);
#line 8854 "tracker-sparql-pattern.c"
					{
						TrackerSourceLocation _tmp32_;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp32_ = optional_start;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_set_location (self, &_tmp32_);
#line 8861 "tracker-sparql-pattern.c"
					}
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return _tmp33_;
#line 8869 "tracker-sparql-pattern.c"
				}
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp35_ = self->priv->query;
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp36_ = ns;
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp37_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp38_ = _tmp37_;
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp39_ = string_substring (_tmp38_, (glong) 1, (glong) -1);
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp40_ = _tmp39_;
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp41_ = tracker_sparql_query_resolve_prefixed_name (_tmp35_, _tmp36_, _tmp40_, &_inner_error_);
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp42_ = _tmp41_;
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp40_);
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp38_);
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp34_ = _tmp42_;
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8895 "tracker-sparql-pattern.c"
					gboolean _tmp44_ = FALSE;
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (ns);
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (left_variable);
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8905 "tracker-sparql-pattern.c"
						goto __catch1_tracker_sparql_error;
					}
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (ns);
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (left_variable);
#line 8914 "tracker-sparql-pattern.c"
					{
						TrackerSourceLocation _tmp43_;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp43_ = optional_start;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_set_location (self, &_tmp43_);
#line 8921 "tracker-sparql-pattern.c"
					}
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return _tmp44_;
#line 8929 "tracker-sparql-pattern.c"
				}
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp45_ = _tmp34_;
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp34_ = NULL;
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (predicate);
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				predicate = _tmp45_;
#line 882 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp34_);
#line 882 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (ns);
#line 8943 "tracker-sparql-pattern.c"
			} else {
				gboolean _tmp46_ = FALSE;
				gboolean _tmp47_;
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp47_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_COLON, &_inner_error_);
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp46_ = _tmp47_;
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8953 "tracker-sparql-pattern.c"
					gboolean _tmp49_ = FALSE;
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (left_variable);
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 8961 "tracker-sparql-pattern.c"
						goto __catch1_tracker_sparql_error;
					}
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (left_variable);
#line 8968 "tracker-sparql-pattern.c"
					{
						TrackerSourceLocation _tmp48_;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp48_ = optional_start;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_set_location (self, &_tmp48_);
#line 8975 "tracker-sparql-pattern.c"
					}
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return _tmp49_;
#line 8983 "tracker-sparql-pattern.c"
				}
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp46_) {
#line 8987 "tracker-sparql-pattern.c"
					gchar* _tmp50_ = NULL;
					TrackerSparqlQuery* _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					gchar* _tmp54_;
					gchar* _tmp55_;
					gchar* _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp60_;
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp51_ = self->priv->query;
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp52_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp53_ = _tmp52_;
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp54_ = string_substring (_tmp53_, (glong) 1, (glong) -1);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp55_ = _tmp54_;
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp56_ = tracker_sparql_query_resolve_prefixed_name (_tmp51_, "", _tmp55_, &_inner_error_);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp57_ = _tmp56_;
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp55_);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp53_);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp50_ = _tmp57_;
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9019 "tracker-sparql-pattern.c"
						gboolean _tmp59_ = FALSE;
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (predicate);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (left_variable);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 9027 "tracker-sparql-pattern.c"
							goto __catch1_tracker_sparql_error;
						}
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (predicate);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (left_variable);
#line 9034 "tracker-sparql-pattern.c"
						{
							TrackerSourceLocation _tmp58_;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp58_ = optional_start;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							tracker_sparql_pattern_set_location (self, &_tmp58_);
#line 9041 "tracker-sparql-pattern.c"
						}
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return _tmp59_;
#line 9049 "tracker-sparql-pattern.c"
					}
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp60_ = _tmp50_;
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp50_ = NULL;
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					predicate = _tmp60_;
#line 886 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp50_);
#line 9061 "tracker-sparql-pattern.c"
				} else {
#line 889 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					result = FALSE;
#line 889 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (predicate);
#line 889 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (left_variable);
#line 9069 "tracker-sparql-pattern.c"
					{
						TrackerSourceLocation _tmp61_;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp61_ = optional_start;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_set_location (self, &_tmp61_);
#line 9076 "tracker-sparql-pattern.c"
					}
#line 889 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return result;
#line 9080 "tracker-sparql-pattern.c"
				}
			}
		}
#line 891 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp62_ = self->priv->manager;
#line 891 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp63_ = tracker_data_manager_get_ontologies (_tmp62_);
#line 891 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp64_ = _g_object_ref0 (_tmp63_);
#line 891 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		ontologies = _tmp64_;
#line 892 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp65_ = ontologies;
#line 892 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp66_ = predicate;
#line 892 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp67_ = tracker_ontologies_get_property_by_uri (_tmp65_, _tmp66_);
#line 892 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp68_ = _g_object_ref0 (_tmp67_);
#line 892 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		prop = _tmp68_;
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp69_ = prop;
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp69_ == NULL) {
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			result = FALSE;
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (ontologies);
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 9116 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp70_;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp70_ = optional_start;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp70_);
#line 9123 "tracker-sparql-pattern.c"
			}
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return result;
#line 9127 "tracker-sparql-pattern.c"
		}
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp72_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp71_ = _tmp72_;
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9135 "tracker-sparql-pattern.c"
			gboolean _tmp74_ = FALSE;
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (ontologies);
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 9147 "tracker-sparql-pattern.c"
				goto __catch1_tracker_sparql_error;
			}
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (ontologies);
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 9158 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp73_;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp73_ = optional_start;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp73_);
#line 9165 "tracker-sparql-pattern.c"
			}
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp74_;
#line 9173 "tracker-sparql-pattern.c"
		}
#line 898 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp71_) {
#line 899 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			result = FALSE;
#line 899 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 899 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (ontologies);
#line 899 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 899 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 9187 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp75_;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp75_ = optional_start;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp75_);
#line 9194 "tracker-sparql-pattern.c"
			}
#line 899 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return result;
#line 9198 "tracker-sparql-pattern.c"
		}
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp76_ = tracker_sparql_pattern_get_context (self);
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp77_ = _tmp76_;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp78_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp79_ = _tmp78_;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp80_ = string_substring (_tmp79_, (glong) 1, (glong) -1);
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp81_ = _tmp80_;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp82_ = tracker_sparql_context_get_variable (_tmp77_, _tmp81_);
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp83_ = _g_object_ref0 (_tmp82_);
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp84_ = _tmp83_;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp81_);
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp79_);
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		right_variable = _tmp84_;
#line 902 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp85_ = tracker_sparql_pattern_get_context (self);
#line 902 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp86_ = _tmp85_;
#line 902 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp87_ = _tmp86_->var_set;
#line 902 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp88_ = right_variable;
#line 902 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp89_ = g_hash_table_lookup (_tmp87_, _tmp88_);
#line 902 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		right_variable_state = (gint) ((gintptr) _tmp89_);
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9240 "tracker-sparql-pattern.c"
			gboolean _tmp91_ = FALSE;
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (right_variable);
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (ontologies);
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 9254 "tracker-sparql-pattern.c"
				goto __catch1_tracker_sparql_error;
			}
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (right_variable);
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (ontologies);
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 9267 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp90_;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp90_ = optional_start;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp90_);
#line 9274 "tracker-sparql-pattern.c"
			}
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp91_;
#line 9282 "tracker-sparql-pattern.c"
		}
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp93_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp92_ = _tmp93_;
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9290 "tracker-sparql-pattern.c"
			gboolean _tmp95_ = FALSE;
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (right_variable);
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (ontologies);
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 9304 "tracker-sparql-pattern.c"
				goto __catch1_tracker_sparql_error;
			}
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (right_variable);
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (ontologies);
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 9317 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp94_;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp94_ = optional_start;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp94_);
#line 9324 "tracker-sparql-pattern.c"
			}
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return _tmp95_;
#line 9332 "tracker-sparql-pattern.c"
		}
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp92_) {
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			result = FALSE;
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (right_variable);
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (prop);
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (ontologies);
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (predicate);
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (left_variable);
#line 9348 "tracker-sparql-pattern.c"
			{
				TrackerSourceLocation _tmp96_;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp96_ = optional_start;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_location (self, &_tmp96_);
#line 9355 "tracker-sparql-pattern.c"
			}
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return result;
#line 9359 "tracker-sparql-pattern.c"
		}
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp99_ = left_variable_state;
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp99_ == ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)) {
#line 9365 "tracker-sparql-pattern.c"
			TrackerProperty* _tmp100_;
			gboolean _tmp101_;
			gboolean _tmp102_;
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp100_ = prop;
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp101_ = tracker_property_get_multiple_values (_tmp100_);
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp102_ = _tmp101_;
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp98_ = !_tmp102_;
#line 9377 "tracker-sparql-pattern.c"
		} else {
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp98_ = FALSE;
#line 9381 "tracker-sparql-pattern.c"
		}
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp98_) {
#line 9385 "tracker-sparql-pattern.c"
			gint _tmp103_;
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp103_ = right_variable_state;
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp97_ = _tmp103_ == 0;
#line 9391 "tracker-sparql-pattern.c"
		} else {
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp97_ = FALSE;
#line 9395 "tracker-sparql-pattern.c"
		}
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp97_) {
#line 9399 "tracker-sparql-pattern.c"
			gboolean in_domain = FALSE;
			TrackerSparqlPatternTripleContext* _tmp104_;
			GHashTable* _tmp105_;
			TrackerSparqlVariable* _tmp106_;
			gconstpointer _tmp107_;
			GList* _tmp108_;
			gboolean _tmp119_;
#line 913 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			in_domain = FALSE;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp104_ = self->priv->triple_context;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp105_ = _tmp104_->var_bindings;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp106_ = left_variable;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp107_ = g_hash_table_lookup (_tmp105_, _tmp106_);
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp108_ = ((TrackerSparqlVariableBindingList*) _tmp107_)->list;
#line 9419 "tracker-sparql-pattern.c"
			{
				GList* binding_collection = NULL;
				GList* binding_it = NULL;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				binding_collection = _tmp108_;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
#line 9427 "tracker-sparql-pattern.c"
					TrackerSparqlVariableBinding* _tmp109_;
					TrackerSparqlVariableBinding* binding = NULL;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp109_ = _g_object_ref0 ((TrackerSparqlVariableBinding*) binding_it->data);
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					binding = _tmp109_;
#line 9434 "tracker-sparql-pattern.c"
					{
						gboolean _tmp110_ = FALSE;
						TrackerSparqlVariableBinding* _tmp111_;
						TrackerClass* _tmp112_;
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp111_ = binding;
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp112_ = _tmp111_->type;
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_tmp112_ != NULL) {
#line 9445 "tracker-sparql-pattern.c"
							TrackerSparqlVariableBinding* _tmp113_;
							TrackerClass* _tmp114_;
							TrackerProperty* _tmp115_;
							TrackerClass* _tmp116_;
							TrackerClass* _tmp117_;
							gboolean _tmp118_;
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp113_ = binding;
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp114_ = _tmp113_->type;
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp115_ = prop;
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp116_ = tracker_property_get_domain (_tmp115_);
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp117_ = _tmp116_;
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp118_ = tracker_sparql_pattern_is_subclass (self, _tmp114_, _tmp117_);
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp110_ = _tmp118_;
#line 9466 "tracker-sparql-pattern.c"
						} else {
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp110_ = FALSE;
#line 9470 "tracker-sparql-pattern.c"
						}
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_tmp110_) {
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							in_domain = TRUE;
#line 917 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 917 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							break;
#line 9480 "tracker-sparql-pattern.c"
						}
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (binding);
#line 9484 "tracker-sparql-pattern.c"
					}
				}
			}
#line 921 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp119_ = in_domain;
#line 921 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp119_) {
#line 923 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				result = TRUE;
#line 923 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (right_variable);
#line 923 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (prop);
#line 923 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (ontologies);
#line 923 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (predicate);
#line 923 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (left_variable);
#line 9504 "tracker-sparql-pattern.c"
				{
					TrackerSourceLocation _tmp120_;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp120_ = optional_start;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_set_location (self, &_tmp120_);
#line 9511 "tracker-sparql-pattern.c"
				}
#line 923 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return result;
#line 9515 "tracker-sparql-pattern.c"
			}
		} else {
			gboolean _tmp121_ = FALSE;
			gboolean _tmp122_ = FALSE;
			gint _tmp123_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp123_ = left_variable_state;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp123_ == 0) {
#line 9525 "tracker-sparql-pattern.c"
				TrackerProperty* _tmp124_;
				gboolean _tmp125_;
				gboolean _tmp126_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp124_ = prop;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp125_ = tracker_property_get_is_inverse_functional_property (_tmp124_);
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp126_ = _tmp125_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp122_ = _tmp126_;
#line 9537 "tracker-sparql-pattern.c"
			} else {
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp122_ = FALSE;
#line 9541 "tracker-sparql-pattern.c"
			}
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp122_) {
#line 9545 "tracker-sparql-pattern.c"
				gint _tmp127_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp127_ = right_variable_state;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp121_ = _tmp127_ == ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND);
#line 9551 "tracker-sparql-pattern.c"
			} else {
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp121_ = FALSE;
#line 9555 "tracker-sparql-pattern.c"
			}
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp121_) {
#line 927 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				result = TRUE;
#line 927 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (right_variable);
#line 927 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (prop);
#line 927 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (ontologies);
#line 927 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (predicate);
#line 927 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (left_variable);
#line 9571 "tracker-sparql-pattern.c"
				{
					TrackerSourceLocation _tmp128_;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp128_ = optional_start;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_set_location (self, &_tmp128_);
#line 9578 "tracker-sparql-pattern.c"
				}
#line 927 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return result;
#line 9582 "tracker-sparql-pattern.c"
			}
		}
#line 931 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		result = FALSE;
#line 931 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (right_variable);
#line 931 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (prop);
#line 931 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (ontologies);
#line 931 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (predicate);
#line 931 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (left_variable);
#line 9597 "tracker-sparql-pattern.c"
		{
			TrackerSourceLocation _tmp129_;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp129_ = optional_start;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_set_location (self, &_tmp129_);
#line 9604 "tracker-sparql-pattern.c"
		}
#line 931 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		return result;
#line 9608 "tracker-sparql-pattern.c"
	}
	goto __finally1;
	__catch1_tracker_sparql_error:
	{
		GError* e = NULL;
#line 858 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		e = _inner_error_;
#line 858 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_inner_error_ = NULL;
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		result = FALSE;
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_error_free0 (e);
#line 9622 "tracker-sparql-pattern.c"
		{
			TrackerSourceLocation _tmp130_;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp130_ = optional_start;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_set_location (self, &_tmp130_);
#line 9629 "tracker-sparql-pattern.c"
		}
#line 933 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		return result;
#line 9633 "tracker-sparql-pattern.c"
	}
	__finally1:
	{
		TrackerSourceLocation _tmp131_;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp131_ = optional_start;
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_set_location (self, &_tmp131_);
#line 9642 "tracker-sparql-pattern.c"
	}
#line 858 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 858 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_clear_error (&_inner_error_);
#line 858 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return _tmp132_;
#line 9650 "tracker-sparql-pattern.c"
}


static gpointer _g_hash_table_ref0 (gpointer self) {
#line 948 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return self ? g_hash_table_ref (self) : NULL;
#line 9657 "tracker-sparql-pattern.c"
}


static guint _tracker_sparql_variable_hash_ghash_func (gconstpointer key) {
	guint result;
	result = tracker_sparql_variable_hash ((TrackerSparqlVariable*) key);
#line 949 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 9666 "tracker-sparql-pattern.c"
}


static gboolean _tracker_sparql_variable_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = tracker_sparql_variable_equal ((TrackerSparqlVariable*) a, (TrackerSparqlVariable*) b);
#line 949 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 9675 "tracker-sparql-pattern.c"
}


static void _vala_array_add8 (TrackerSourceLocation* * array, int* length, int* size, const TrackerSourceLocation* value) {
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if ((*length) == (*size)) {
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*array = g_renew (TrackerSourceLocation, *array, *size);
#line 9686 "tracker-sparql-pattern.c"
	}
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[(*length)++] = *value;
#line 9690 "tracker-sparql-pattern.c"
}


TrackerSparqlContext* tracker_sparql_pattern_translate_group_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error) {
	TrackerSparqlContext* result = NULL;
	TrackerSparqlTokenType _tmp0_;
	TrackerSparqlContext* _result_ = NULL;
	TrackerSparqlQuery* _tmp17_;
	TrackerSparqlContext* _tmp18_;
	TrackerSparqlContext* _tmp19_;
	TrackerSparqlContext* _tmp20_;
	TrackerSparqlContext* _tmp21_;
	TrackerSourceLocation* filters = NULL;
	TrackerSourceLocation* _tmp22_;
	gint filters_length1;
	gint _filters_size_;
	gboolean in_triples_block = FALSE;
	gboolean in_group_graph_pattern = FALSE;
	gboolean first_where = FALSE;
	gboolean found_simple_optional = FALSE;
	glong group_graph_pattern_start = 0L;
	GString* _tmp23_;
	gssize _tmp24_;
	GString* _tmp25_;
	glong _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp316_ = FALSE;
	gboolean _tmp317_;
	gboolean _tmp323_;
	TrackerSourceLocation* _tmp324_;
	gint _tmp324__length1;
	TrackerSparqlContext* _tmp333_;
	TrackerSparqlContext* _tmp334_;
	TrackerSparqlContext* _tmp335_;
	GError * _inner_error_ = NULL;
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (sql != NULL, NULL);
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 9740 "tracker-sparql-pattern.c"
		} else {
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 9748 "tracker-sparql-pattern.c"
		}
	}
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = tracker_sparql_pattern_current (self);
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp0_ == TRACKER_SPARQL_TOKEN_TYPE_SELECT) {
#line 9755 "tracker-sparql-pattern.c"
		TrackerSparqlSelectContext* _result_ = NULL;
		GString* _tmp1_;
		TrackerSparqlSelectContext* _tmp2_;
		TrackerSparqlSelectContext* _tmp3_;
		TrackerSparqlContext* _tmp4_;
		TrackerSparqlContext* _tmp5_;
		TrackerSparqlContext* _tmp6_;
		TrackerSparqlContext* _tmp7_;
		GHashTable* _tmp8_;
		GHashTable* _tmp9_;
		TrackerSparqlContext* _tmp10_;
		TrackerSparqlContext* _tmp11_;
		GDestroyNotify _tmp12_;
		GHashTable* _tmp13_;
		TrackerSparqlContext* _tmp14_;
		TrackerSparqlContext* _tmp15_;
		TrackerSparqlContext* _tmp16_;
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp1_ = sql;
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = tracker_sparql_pattern_translate_select (self, _tmp1_, TRUE, FALSE, &_inner_error_);
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_result_ = _tmp2_;
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 9787 "tracker-sparql-pattern.c"
			} else {
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 9795 "tracker-sparql-pattern.c"
			}
		}
#line 945 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = _result_;
#line 945 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_set_context (self, (TrackerSparqlContext*) _tmp3_);
#line 948 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = tracker_sparql_pattern_get_context (self);
#line 948 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_ = _tmp4_;
#line 948 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp6_ = tracker_sparql_pattern_get_context (self);
#line 948 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp7_ = _tmp6_;
#line 948 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp8_ = _tmp7_->select_var_set;
#line 948 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp9_ = _g_hash_table_ref0 (_tmp8_);
#line 948 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_hash_table_unref0 (_tmp5_->var_set);
#line 948 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_->var_set = _tmp9_;
#line 949 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp10_ = tracker_sparql_pattern_get_context (self);
#line 949 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp11_ = _tmp10_;
#line 949 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp12_ = g_object_unref;
#line 949 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp13_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, _tmp12_, NULL);
#line 949 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_hash_table_unref0 (_tmp11_->select_var_set);
#line 949 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp11_->select_var_set = _tmp13_;
#line 951 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
#line 951 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 951 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 951 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 951 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 951 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 9842 "tracker-sparql-pattern.c"
			} else {
#line 951 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 951 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 951 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 951 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 9852 "tracker-sparql-pattern.c"
			}
		}
#line 953 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp14_ = tracker_sparql_pattern_get_context (self);
#line 953 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp15_ = _tmp14_;
#line 953 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp16_ = _tmp15_->parent_context;
#line 953 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_set_context (self, _tmp16_);
#line 954 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		result = (TrackerSparqlContext*) _result_;
#line 954 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		return result;
#line 9867 "tracker-sparql-pattern.c"
	}
#line 957 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp17_ = self->priv->query;
#line 957 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp18_ = tracker_sparql_pattern_get_context (self);
#line 957 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp19_ = _tmp18_;
#line 957 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp20_ = tracker_sparql_context_new (_tmp17_, _tmp19_);
#line 957 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_result_ = _tmp20_;
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp21_ = _result_;
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, _tmp21_);
#line 960 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp22_ = g_new0 (TrackerSourceLocation, 0);
#line 960 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	filters = _tmp22_;
#line 960 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	filters_length1 = 0;
#line 960 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_filters_size_ = filters_length1;
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	in_triples_block = FALSE;
#line 963 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	in_group_graph_pattern = FALSE;
#line 964 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	first_where = TRUE;
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	found_simple_optional = FALSE;
#line 966 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp23_ = sql;
#line 966 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp24_ = _tmp23_->len;
#line 966 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	group_graph_pattern_start = (glong) _tmp24_;
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp25_ = sql;
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp26_ = group_graph_pattern_start;
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp27_ = found_simple_optional;
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_parse_triples (self, _tmp25_, _tmp26_, &in_triples_block, &first_where, &in_group_graph_pattern, _tmp27_, &_inner_error_);
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			filters = (g_free (filters), NULL);
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 9925 "tracker-sparql-pattern.c"
		} else {
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			filters = (g_free (filters), NULL);
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 9937 "tracker-sparql-pattern.c"
		}
	}
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	while (TRUE) {
#line 9942 "tracker-sparql-pattern.c"
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_;
		GString* _tmp313_;
		glong _tmp314_;
		gboolean _tmp315_;
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp29_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL, &_inner_error_);
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp28_ = _tmp29_;
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				filters = (g_free (filters), NULL);
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 9964 "tracker-sparql-pattern.c"
			} else {
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				filters = (g_free (filters), NULL);
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 9976 "tracker-sparql-pattern.c"
			}
		}
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp28_) {
#line 9981 "tracker-sparql-pattern.c"
			gboolean _tmp30_ = FALSE;
			gboolean _tmp31_;
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp31_ = in_group_graph_pattern;
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (!_tmp31_) {
#line 9988 "tracker-sparql-pattern.c"
				gboolean _tmp32_;
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp32_ = tracker_sparql_pattern_is_simple_optional (self);
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp30_ = _tmp32_;
#line 9994 "tracker-sparql-pattern.c"
			} else {
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp30_ = FALSE;
#line 9998 "tracker-sparql-pattern.c"
			}
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp30_) {
#line 10002 "tracker-sparql-pattern.c"
				gchar* _tmp33_ = NULL;
				GString* _tmp34_;
				gboolean _tmp35_ = FALSE;
				gchar* _tmp36_;
				gchar* _tmp37_;
				GString* _tmp38_;
#line 976 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				found_simple_optional = TRUE;
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, &_inner_error_);
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10025 "tracker-sparql-pattern.c"
					} else {
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10037 "tracker-sparql-pattern.c"
					}
				}
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp34_ = sql;
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp36_ = tracker_sparql_pattern_parse_var_or_term (self, _tmp34_, &_tmp35_, &_inner_error_);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->priv->current_subject_is_var = _tmp35_;
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp33_ = _tmp36_;
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10060 "tracker-sparql-pattern.c"
					} else {
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10072 "tracker-sparql-pattern.c"
					}
				}
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp37_ = _tmp33_;
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp33_ = NULL;
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (self->priv->current_subject);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->priv->current_subject = _tmp37_;
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp38_ = sql;
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_parse_property_list_not_empty (self, _tmp38_, TRUE, &_inner_error_);
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp33_);
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10101 "tracker-sparql-pattern.c"
					} else {
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp33_);
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10115 "tracker-sparql-pattern.c"
					}
				}
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp33_);
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10134 "tracker-sparql-pattern.c"
					} else {
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp33_);
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 982 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10148 "tracker-sparql-pattern.c"
					}
				}
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp33_);
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10167 "tracker-sparql-pattern.c"
					} else {
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp33_);
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10181 "tracker-sparql-pattern.c"
					}
				}
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp33_);
#line 10186 "tracker-sparql-pattern.c"
			} else {
				gboolean _tmp39_ = FALSE;
				gboolean _tmp40_;
				gboolean _tmp46_;
				GString* select = NULL;
				GString* _tmp47_;
				gint left_index = 0;
				gint _tmp48_;
				gint _tmp49_;
				gint right_index = 0;
				gint _tmp50_;
				gint _tmp51_;
				GString* _tmp52_;
				gint _tmp53_;
				TrackerSparqlContext* _tmp54_ = NULL;
				GString* _tmp55_;
				TrackerSparqlContext* _tmp56_;
				GString* _tmp57_;
				gint _tmp58_;
				gboolean first = FALSE;
				gboolean first_common = FALSE;
				TrackerSparqlContext* _tmp59_;
				TrackerSparqlContext* _tmp60_;
				GHashTable* _tmp61_;
				GList* _tmp62_;
				TrackerSparqlContext* _tmp180_;
				TrackerSparqlContext* _tmp181_;
				TrackerSparqlContext* _tmp182_;
				GHashTable* _tmp183_;
				GList* _tmp184_;
				gboolean _tmp210_;
				TrackerSparqlContext* _tmp212_;
				TrackerSparqlContext* _tmp213_;
				TrackerSparqlContext* _tmp214_;
				GString* _tmp215_;
				GString* _tmp216_;
				glong _tmp217_;
				GString* _tmp218_;
				const gchar* _tmp219_;
				GString* _tmp220_;
				glong _tmp221_;
				GString* _tmp222_;
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp40_ = in_triples_block;
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp40_) {
#line 10233 "tracker-sparql-pattern.c"
					gboolean _tmp41_;
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp41_ = in_group_graph_pattern;
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp39_ = !_tmp41_;
#line 10239 "tracker-sparql-pattern.c"
				} else {
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp39_ = FALSE;
#line 10243 "tracker-sparql-pattern.c"
				}
#line 985 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp39_) {
#line 10247 "tracker-sparql-pattern.c"
					GString* _tmp42_;
#line 988 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp42_ = sql;
#line 988 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp42_, "SELECT 1");
#line 10253 "tracker-sparql-pattern.c"
				} else {
					gboolean _tmp43_;
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp43_ = in_triples_block;
#line 989 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp43_) {
#line 10260 "tracker-sparql-pattern.c"
						GString* _tmp44_;
						gboolean _tmp45_;
#line 990 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp44_ = sql;
#line 990 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp45_ = in_group_graph_pattern;
#line 990 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_end_triples_block (self, _tmp44_, &first_where, _tmp45_, &_inner_error_);
#line 990 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 990 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 990 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_propagate_error (error, _inner_error_);
#line 990 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								filters = (g_free (filters), NULL);
#line 990 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tracker_sparql_context_unref0 (_result_);
#line 990 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 10281 "tracker-sparql-pattern.c"
							} else {
#line 990 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								filters = (g_free (filters), NULL);
#line 990 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tracker_sparql_context_unref0 (_result_);
#line 990 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 990 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_clear_error (&_inner_error_);
#line 990 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 10293 "tracker-sparql-pattern.c"
							}
						}
#line 991 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						in_triples_block = FALSE;
#line 10298 "tracker-sparql-pattern.c"
					}
				}
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp46_ = in_group_graph_pattern;
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp46_) {
#line 994 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					in_group_graph_pattern = TRUE;
#line 10307 "tracker-sparql-pattern.c"
				}
#line 997 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp47_ = g_string_new ("SELECT ");
#line 997 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				select = _tmp47_;
#line 999 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp48_ = self->priv->next_table_index;
#line 999 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->priv->next_table_index = _tmp48_ + 1;
#line 999 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp49_ = self->priv->next_table_index;
#line 999 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				left_index = _tmp49_;
#line 1000 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp50_ = self->priv->next_table_index;
#line 1000 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->priv->next_table_index = _tmp50_ + 1;
#line 1000 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp51_ = self->priv->next_table_index;
#line 1000 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				right_index = _tmp51_;
#line 1002 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp52_ = sql;
#line 1002 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp53_ = left_index;
#line 1002 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append_printf (_tmp52_, ") AS t%d_g LEFT JOIN (", _tmp53_);
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp55_ = sql;
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp56_ = tracker_sparql_pattern_translate_group_graph_pattern (self, _tmp55_, &_inner_error_);
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp54_ = _tmp56_;
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (select);
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10355 "tracker-sparql-pattern.c"
					} else {
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (select);
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 10369 "tracker-sparql-pattern.c"
					}
				}
#line 1004 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_context (self, _tmp54_);
#line 1006 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp57_ = sql;
#line 1006 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp58_ = right_index;
#line 1006 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append_printf (_tmp57_, ") AS t%d_g", _tmp58_);
#line 1008 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				first = TRUE;
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				first_common = TRUE;
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp59_ = tracker_sparql_pattern_get_context (self);
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp60_ = _tmp59_;
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp61_ = _tmp60_->var_set;
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp62_ = g_hash_table_get_keys (_tmp61_);
#line 10392 "tracker-sparql-pattern.c"
				{
					GList* v_collection = NULL;
					GList* v_it = NULL;
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					v_collection = _tmp62_;
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
#line 10400 "tracker-sparql-pattern.c"
						TrackerSparqlVariable* v = NULL;
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						v = (TrackerSparqlVariable*) v_it->data;
#line 10404 "tracker-sparql-pattern.c"
						{
							gboolean _tmp63_;
							gint old_state = 0;
							TrackerSparqlContext* _tmp65_;
							TrackerSparqlContext* _tmp66_;
							TrackerSparqlContext* _tmp67_;
							GHashTable* _tmp68_;
							TrackerSparqlVariable* _tmp69_;
							gconstpointer _tmp70_;
							gint _tmp71_;
#line 1011 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp63_ = first;
#line 1011 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_tmp63_) {
#line 1012 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								first = FALSE;
#line 10421 "tracker-sparql-pattern.c"
							} else {
								GString* _tmp64_;
#line 1014 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp64_ = select;
#line 1014 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_string_append (_tmp64_, ", ");
#line 10428 "tracker-sparql-pattern.c"
							}
#line 1017 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp65_ = tracker_sparql_pattern_get_context (self);
#line 1017 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp66_ = _tmp65_;
#line 1017 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp67_ = _tmp66_->parent_context;
#line 1017 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp68_ = _tmp67_->var_set;
#line 1017 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp69_ = v;
#line 1017 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp70_ = g_hash_table_lookup (_tmp68_, _tmp69_);
#line 1017 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							old_state = (gint) ((gintptr) _tmp70_);
#line 1018 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp71_ = old_state;
#line 1018 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_tmp71_ == 0) {
#line 10448 "tracker-sparql-pattern.c"
								TrackerSparqlContext* _tmp72_;
								TrackerSparqlContext* _tmp73_;
								TrackerSparqlContext* _tmp74_;
								GHashTable* _tmp75_;
								TrackerSparqlVariable* _tmp76_;
								TrackerSparqlVariable* _tmp77_;
								GString* _tmp78_;
								gint _tmp79_;
								TrackerSparqlVariable* _tmp80_;
								const gchar* _tmp81_;
								const gchar* _tmp82_;
								TrackerSparqlVariable* _tmp83_;
								TrackerSparqlVariableBinding* _tmp84_;
								TrackerPropertyType _tmp85_;
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp72_ = tracker_sparql_pattern_get_context (self);
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp73_ = _tmp72_;
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp74_ = _tmp73_->parent_context;
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp75_ = _tmp74_->var_set;
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp76_ = v;
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp77_ = _g_object_ref0 (_tmp76_);
#line 1020 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_hash_table_insert (_tmp75_, _tmp77_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL)));
#line 1021 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp78_ = select;
#line 1021 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp79_ = right_index;
#line 1021 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp80_ = v;
#line 1021 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp81_ = tracker_sparql_variable_get_sql_expression (_tmp80_);
#line 1021 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp82_ = _tmp81_;
#line 1021 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_string_append_printf (_tmp78_, "t%d_g.%s", _tmp79_, _tmp82_);
#line 1023 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp83_ = v;
#line 1023 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp84_ = _tmp83_->binding;
#line 1023 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp85_ = ((TrackerSparqlDataBinding*) _tmp84_)->data_type;
#line 1023 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp85_ == TRACKER_PROPERTY_TYPE_DATETIME) {
#line 10497 "tracker-sparql-pattern.c"
									GString* _tmp86_;
									gint _tmp87_;
									TrackerSparqlVariable* _tmp88_;
									gchar* _tmp89_;
									gchar* _tmp90_;
									GString* _tmp91_;
									gint _tmp92_;
									TrackerSparqlVariable* _tmp93_;
									gchar* _tmp94_;
									gchar* _tmp95_;
#line 1024 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp86_ = select;
#line 1024 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp87_ = right_index;
#line 1024 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp88_ = v;
#line 1024 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp89_ = tracker_sparql_variable_get_extra_sql_expression (_tmp88_, "localDate");
#line 1024 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp90_ = _tmp89_;
#line 1024 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp86_, ", t%d_g.%s", _tmp87_, _tmp90_);
#line 1024 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_tmp90_);
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp91_ = select;
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp92_ = right_index;
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp93_ = v;
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp94_ = tracker_sparql_variable_get_extra_sql_expression (_tmp93_, "localTime");
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp95_ = _tmp94_;
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp91_, ", t%d_g.%s", _tmp92_, _tmp95_);
#line 1025 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_tmp95_);
#line 10536 "tracker-sparql-pattern.c"
								}
							} else {
								gboolean _tmp96_;
								gint _tmp99_;
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp96_ = first_common;
#line 1028 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp96_) {
#line 10545 "tracker-sparql-pattern.c"
									GString* _tmp97_;
#line 1029 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp97_ = sql;
#line 1029 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp97_, " ON ");
#line 1030 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									first_common = FALSE;
#line 10553 "tracker-sparql-pattern.c"
								} else {
									GString* _tmp98_;
#line 1032 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp98_ = sql;
#line 1032 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp98_, " AND ");
#line 10560 "tracker-sparql-pattern.c"
								}
#line 1035 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp99_ = old_state;
#line 1035 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp99_ == ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)) {
#line 10566 "tracker-sparql-pattern.c"
									GString* _tmp100_;
									gint _tmp101_;
									TrackerSparqlVariable* _tmp102_;
									const gchar* _tmp103_;
									const gchar* _tmp104_;
									gint _tmp105_;
									TrackerSparqlVariable* _tmp106_;
									const gchar* _tmp107_;
									const gchar* _tmp108_;
									GString* _tmp109_;
									gint _tmp110_;
									TrackerSparqlVariable* _tmp111_;
									const gchar* _tmp112_;
									const gchar* _tmp113_;
									TrackerSparqlVariable* _tmp114_;
									TrackerSparqlVariableBinding* _tmp115_;
									TrackerPropertyType _tmp116_;
#line 1037 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp100_ = sql;
#line 1037 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp101_ = left_index;
#line 1037 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp102_ = v;
#line 1037 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp103_ = tracker_sparql_variable_get_sql_expression (_tmp102_);
#line 1037 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp104_ = _tmp103_;
#line 1037 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp105_ = right_index;
#line 1037 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp106_ = v;
#line 1037 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp107_ = tracker_sparql_variable_get_sql_expression (_tmp106_);
#line 1037 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp108_ = _tmp107_;
#line 1037 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp100_, "t%d_g.%s = t%d_g.%s", _tmp101_, _tmp104_, _tmp105_, _tmp108_);
#line 1038 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp109_ = select;
#line 1038 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp110_ = left_index;
#line 1038 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp111_ = v;
#line 1038 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp112_ = tracker_sparql_variable_get_sql_expression (_tmp111_);
#line 1038 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp113_ = _tmp112_;
#line 1038 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp109_, "t%d_g.%s", _tmp110_, _tmp113_);
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp114_ = v;
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp115_ = _tmp114_->binding;
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp116_ = ((TrackerSparqlDataBinding*) _tmp115_)->data_type;
#line 1040 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp116_ == TRACKER_PROPERTY_TYPE_DATETIME) {
#line 10624 "tracker-sparql-pattern.c"
										GString* _tmp117_;
										gint _tmp118_;
										TrackerSparqlVariable* _tmp119_;
										gchar* _tmp120_;
										gchar* _tmp121_;
										GString* _tmp122_;
										gint _tmp123_;
										TrackerSparqlVariable* _tmp124_;
										gchar* _tmp125_;
										gchar* _tmp126_;
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp117_ = select;
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp118_ = left_index;
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp119_ = v;
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp120_ = tracker_sparql_variable_get_extra_sql_expression (_tmp119_, "localDate");
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp121_ = _tmp120_;
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp117_, ", t%d_g.%s", _tmp118_, _tmp121_);
#line 1041 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_g_free0 (_tmp121_);
#line 1042 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp122_ = select;
#line 1042 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp123_ = left_index;
#line 1042 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp124_ = v;
#line 1042 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp125_ = tracker_sparql_variable_get_extra_sql_expression (_tmp124_, "localTime");
#line 1042 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp126_ = _tmp125_;
#line 1042 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp122_, ", t%d_g.%s", _tmp123_, _tmp126_);
#line 1042 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_g_free0 (_tmp126_);
#line 10663 "tracker-sparql-pattern.c"
									}
								} else {
									gint _tmp127_;
#line 1044 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp127_ = old_state;
#line 1044 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp127_ == ((gint) TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL)) {
#line 10671 "tracker-sparql-pattern.c"
										GString* _tmp128_;
										gint _tmp129_;
										TrackerSparqlVariable* _tmp130_;
										const gchar* _tmp131_;
										const gchar* _tmp132_;
										gint _tmp133_;
										TrackerSparqlVariable* _tmp134_;
										const gchar* _tmp135_;
										const gchar* _tmp136_;
										gint _tmp137_;
										TrackerSparqlVariable* _tmp138_;
										const gchar* _tmp139_;
										const gchar* _tmp140_;
										GString* _tmp141_;
										gint _tmp142_;
										TrackerSparqlVariable* _tmp143_;
										const gchar* _tmp144_;
										const gchar* _tmp145_;
										gint _tmp146_;
										TrackerSparqlVariable* _tmp147_;
										const gchar* _tmp148_;
										const gchar* _tmp149_;
										TrackerSparqlVariable* _tmp150_;
										const gchar* _tmp151_;
										const gchar* _tmp152_;
										TrackerSparqlVariable* _tmp153_;
										TrackerSparqlVariableBinding* _tmp154_;
										TrackerPropertyType _tmp155_;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp128_ = sql;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp129_ = left_index;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp130_ = v;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp131_ = tracker_sparql_variable_get_sql_expression (_tmp130_);
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp132_ = _tmp131_;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp133_ = left_index;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp134_ = v;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp135_ = tracker_sparql_variable_get_sql_expression (_tmp134_);
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp136_ = _tmp135_;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp137_ = right_index;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp138_ = v;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp139_ = tracker_sparql_variable_get_sql_expression (_tmp138_);
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp140_ = _tmp139_;
#line 1046 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp128_, "(t%d_g.%s IS NULL OR t%d_g.%s = t%d_g.%s)", _tmp129_, _tmp132_, _tmp133_, _tmp136_, _tmp137_, _tmp140_);
#line 1047 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp141_ = select;
#line 1047 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp142_ = left_index;
#line 1047 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp143_ = v;
#line 1047 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp144_ = tracker_sparql_variable_get_sql_expression (_tmp143_);
#line 1047 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp145_ = _tmp144_;
#line 1047 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp146_ = right_index;
#line 1047 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp147_ = v;
#line 1047 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp148_ = tracker_sparql_variable_get_sql_expression (_tmp147_);
#line 1047 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp149_ = _tmp148_;
#line 1047 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp150_ = v;
#line 1047 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp151_ = tracker_sparql_variable_get_sql_expression (_tmp150_);
#line 1047 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp152_ = _tmp151_;
#line 1047 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_string_append_printf (_tmp141_, "COALESCE (t%d_g.%s, t%d_g.%s) AS %s", _tmp142_, _tmp145_, _tmp146_, _tmp149_, _tmp152_);
#line 1049 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp153_ = v;
#line 1049 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp154_ = _tmp153_->binding;
#line 1049 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tmp155_ = ((TrackerSparqlDataBinding*) _tmp154_)->data_type;
#line 1049 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										if (_tmp155_ == TRACKER_PROPERTY_TYPE_DATETIME) {
#line 10762 "tracker-sparql-pattern.c"
											GString* _tmp156_;
											gint _tmp157_;
											TrackerSparqlVariable* _tmp158_;
											gchar* _tmp159_;
											gchar* _tmp160_;
											gint _tmp161_;
											TrackerSparqlVariable* _tmp162_;
											gchar* _tmp163_;
											gchar* _tmp164_;
											TrackerSparqlVariable* _tmp165_;
											gchar* _tmp166_;
											gchar* _tmp167_;
											GString* _tmp168_;
											gint _tmp169_;
											TrackerSparqlVariable* _tmp170_;
											gchar* _tmp171_;
											gchar* _tmp172_;
											gint _tmp173_;
											TrackerSparqlVariable* _tmp174_;
											gchar* _tmp175_;
											gchar* _tmp176_;
											TrackerSparqlVariable* _tmp177_;
											gchar* _tmp178_;
											gchar* _tmp179_;
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp156_ = select;
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp157_ = left_index;
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp158_ = v;
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp159_ = tracker_sparql_variable_get_extra_sql_expression (_tmp158_, "localDate");
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp160_ = _tmp159_;
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp161_ = right_index;
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp162_ = v;
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp163_ = tracker_sparql_variable_get_extra_sql_expression (_tmp162_, "localDate");
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp164_ = _tmp163_;
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp165_ = v;
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp166_ = tracker_sparql_variable_get_extra_sql_expression (_tmp165_, "localDate");
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp167_ = _tmp166_;
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											g_string_append_printf (_tmp156_, ", COALESCE (t%d_g.%s, t%d_g.%s) AS %s", _tmp157_, _tmp160_, _tmp161_, _tmp164_, _tmp167_);
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_tmp167_);
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_tmp164_);
#line 1050 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_tmp160_);
#line 1051 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp168_ = select;
#line 1051 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp169_ = left_index;
#line 1051 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp170_ = v;
#line 1051 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp171_ = tracker_sparql_variable_get_extra_sql_expression (_tmp170_, "localTime");
#line 1051 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp172_ = _tmp171_;
#line 1051 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp173_ = right_index;
#line 1051 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp174_ = v;
#line 1051 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp175_ = tracker_sparql_variable_get_extra_sql_expression (_tmp174_, "localTime");
#line 1051 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp176_ = _tmp175_;
#line 1051 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp177_ = v;
#line 1051 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp178_ = tracker_sparql_variable_get_extra_sql_expression (_tmp177_, "localTime");
#line 1051 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp179_ = _tmp178_;
#line 1051 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											g_string_append_printf (_tmp168_, ", COALESCE (t%d_g.%s, t%d_g.%s) AS %s", _tmp169_, _tmp172_, _tmp173_, _tmp176_, _tmp179_);
#line 1051 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_tmp179_);
#line 1051 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_tmp176_);
#line 1051 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_g_free0 (_tmp172_);
#line 10851 "tracker-sparql-pattern.c"
										}
									}
								}
							}
						}
					}
#line 1010 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_list_free0 (v_collection);
#line 10860 "tracker-sparql-pattern.c"
				}
#line 1056 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp180_ = tracker_sparql_pattern_get_context (self);
#line 1056 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp181_ = _tmp180_;
#line 1056 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp182_ = _tmp181_->parent_context;
#line 1056 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp183_ = _tmp182_->var_set;
#line 1056 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp184_ = g_hash_table_get_keys (_tmp183_);
#line 10872 "tracker-sparql-pattern.c"
				{
					GList* v_collection = NULL;
					GList* v_it = NULL;
#line 1056 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					v_collection = _tmp184_;
#line 1056 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
#line 10880 "tracker-sparql-pattern.c"
						TrackerSparqlVariable* v = NULL;
#line 1056 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						v = (TrackerSparqlVariable*) v_it->data;
#line 10884 "tracker-sparql-pattern.c"
						{
							TrackerSparqlContext* _tmp185_;
							TrackerSparqlContext* _tmp186_;
							GHashTable* _tmp187_;
							TrackerSparqlVariable* _tmp188_;
							gconstpointer _tmp189_;
#line 1057 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp185_ = tracker_sparql_pattern_get_context (self);
#line 1057 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp186_ = _tmp185_;
#line 1057 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp187_ = _tmp186_->var_set;
#line 1057 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp188_ = v;
#line 1057 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp189_ = g_hash_table_lookup (_tmp187_, _tmp188_);
#line 1057 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (((gint) ((gintptr) _tmp189_)) == 0) {
#line 10903 "tracker-sparql-pattern.c"
								gboolean _tmp190_;
								GString* _tmp192_;
								gint _tmp193_;
								TrackerSparqlVariable* _tmp194_;
								const gchar* _tmp195_;
								const gchar* _tmp196_;
								TrackerSparqlVariable* _tmp197_;
								TrackerSparqlVariableBinding* _tmp198_;
								TrackerPropertyType _tmp199_;
#line 1059 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp190_ = first;
#line 1059 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp190_) {
#line 1060 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									first = FALSE;
#line 10919 "tracker-sparql-pattern.c"
								} else {
									GString* _tmp191_;
#line 1062 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp191_ = select;
#line 1062 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp191_, ", ");
#line 10926 "tracker-sparql-pattern.c"
								}
#line 1065 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp192_ = select;
#line 1065 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp193_ = left_index;
#line 1065 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp194_ = v;
#line 1065 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp195_ = tracker_sparql_variable_get_sql_expression (_tmp194_);
#line 1065 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp196_ = _tmp195_;
#line 1065 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_string_append_printf (_tmp192_, "t%d_g.%s", _tmp193_, _tmp196_);
#line 1067 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp197_ = v;
#line 1067 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp198_ = _tmp197_->binding;
#line 1067 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp199_ = ((TrackerSparqlDataBinding*) _tmp198_)->data_type;
#line 1067 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_tmp199_ == TRACKER_PROPERTY_TYPE_DATETIME) {
#line 10948 "tracker-sparql-pattern.c"
									GString* _tmp200_;
									gint _tmp201_;
									TrackerSparqlVariable* _tmp202_;
									gchar* _tmp203_;
									gchar* _tmp204_;
									GString* _tmp205_;
									gint _tmp206_;
									TrackerSparqlVariable* _tmp207_;
									gchar* _tmp208_;
									gchar* _tmp209_;
#line 1068 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp200_ = select;
#line 1068 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp201_ = left_index;
#line 1068 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp202_ = v;
#line 1068 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp203_ = tracker_sparql_variable_get_extra_sql_expression (_tmp202_, "localDate");
#line 1068 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp204_ = _tmp203_;
#line 1068 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp200_, ", t%d_g.%s", _tmp201_, _tmp204_);
#line 1068 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_tmp204_);
#line 1069 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp205_ = select;
#line 1069 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp206_ = left_index;
#line 1069 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp207_ = v;
#line 1069 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp208_ = tracker_sparql_variable_get_extra_sql_expression (_tmp207_, "localTime");
#line 1069 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp209_ = _tmp208_;
#line 1069 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append_printf (_tmp205_, ", t%d_g.%s", _tmp206_, _tmp209_);
#line 1069 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_free0 (_tmp209_);
#line 10987 "tracker-sparql-pattern.c"
								}
							}
						}
					}
#line 1056 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_list_free0 (v_collection);
#line 10994 "tracker-sparql-pattern.c"
				}
#line 1073 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp210_ = first;
#line 1073 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp210_) {
#line 11000 "tracker-sparql-pattern.c"
					GString* _tmp211_;
#line 1075 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp211_ = select;
#line 1075 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp211_, "1");
#line 11006 "tracker-sparql-pattern.c"
				}
#line 1078 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp212_ = tracker_sparql_pattern_get_context (self);
#line 1078 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp213_ = _tmp212_;
#line 1078 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp214_ = _tmp213_->parent_context;
#line 1078 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_set_context (self, _tmp214_);
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp215_ = select;
#line 1080 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append (_tmp215_, " FROM (");
#line 1081 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp216_ = sql;
#line 1081 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp217_ = group_graph_pattern_start;
#line 1081 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp218_ = select;
#line 1081 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp219_ = _tmp218_->str;
#line 1081 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_insert (_tmp216_, (gssize) _tmp217_, _tmp219_);
#line 1085 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp220_ = sql;
#line 1085 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp221_ = group_graph_pattern_start;
#line 1085 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_insert (_tmp220_, (gssize) _tmp221_, "SELECT * FROM (");
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp222_ = sql;
#line 1086 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append (_tmp222_, ")");
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_tmp54_);
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_string_free0 (select);
#line 11044 "tracker-sparql-pattern.c"
			}
		} else {
			gboolean _tmp223_ = FALSE;
			gboolean _tmp224_;
#line 1088 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp224_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_GRAPH, &_inner_error_);
#line 1088 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp223_ = _tmp224_;
#line 1088 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1088 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1088 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 1088 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					filters = (g_free (filters), NULL);
#line 1088 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 1088 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 11065 "tracker-sparql-pattern.c"
				} else {
#line 1088 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					filters = (g_free (filters), NULL);
#line 1088 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 1088 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1088 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 1088 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 11077 "tracker-sparql-pattern.c"
				}
			}
#line 1088 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp223_) {
#line 11082 "tracker-sparql-pattern.c"
				gchar* old_graph = NULL;
				const gchar* _tmp225_;
				gchar* _tmp226_;
				gboolean old_graph_is_var = FALSE;
				gboolean _tmp227_;
				gchar* _tmp228_ = NULL;
				GString* _tmp229_;
				gboolean _tmp230_ = FALSE;
				gchar* _tmp231_;
				gchar* _tmp232_;
				gboolean _tmp233_ = FALSE;
				gboolean _tmp234_;
				const gchar* _tmp249_;
				gchar* _tmp250_;
				gboolean _tmp251_;
#line 1089 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp225_ = self->current_graph;
#line 1089 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp226_ = g_strdup (_tmp225_);
#line 1089 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				old_graph = _tmp226_;
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp227_ = self->priv->current_graph_is_var;
#line 1090 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				old_graph_is_var = _tmp227_;
#line 1091 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp229_ = sql;
#line 1091 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp231_ = tracker_sparql_pattern_parse_var_or_term (self, _tmp229_, &_tmp230_, &_inner_error_);
#line 1091 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->priv->current_graph_is_var = _tmp230_;
#line 1091 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp228_ = _tmp231_;
#line 1091 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1091 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1091 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 1091 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (old_graph);
#line 1091 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 1091 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 1091 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 11130 "tracker-sparql-pattern.c"
					} else {
#line 1091 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (old_graph);
#line 1091 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 1091 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 1091 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1091 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 1091 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 11144 "tracker-sparql-pattern.c"
					}
				}
#line 1091 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp232_ = _tmp228_;
#line 1091 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp228_ = NULL;
#line 1091 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (self->current_graph);
#line 1091 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->current_graph = _tmp232_;
#line 1093 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp234_ = in_triples_block;
#line 1093 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp234_) {
#line 11159 "tracker-sparql-pattern.c"
					gboolean _tmp235_;
#line 1093 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp235_ = in_group_graph_pattern;
#line 1093 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp233_ = !_tmp235_;
#line 11165 "tracker-sparql-pattern.c"
				} else {
#line 1093 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp233_ = FALSE;
#line 11169 "tracker-sparql-pattern.c"
				}
#line 1093 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp233_) {
#line 11173 "tracker-sparql-pattern.c"
					GString* _tmp236_;
					glong _tmp237_;
					GString* _tmp238_;
					GString* _tmp239_;
#line 1094 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					in_group_graph_pattern = TRUE;
#line 1096 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp236_ = sql;
#line 1096 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp237_ = group_graph_pattern_start;
#line 1096 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_insert (_tmp236_, (gssize) _tmp237_, "SELECT * FROM (");
#line 1097 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp238_ = sql;
#line 1097 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, _tmp238_, &_inner_error_);
#line 1097 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1097 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1097 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1097 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_tmp228_);
#line 1097 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_graph);
#line 1097 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1097 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1097 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11206 "tracker-sparql-pattern.c"
						} else {
#line 1097 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_tmp228_);
#line 1097 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_graph);
#line 1097 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1097 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1097 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1097 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1097 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11222 "tracker-sparql-pattern.c"
						}
					}
#line 1098 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp239_ = sql;
#line 1098 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp239_, ")");
#line 11229 "tracker-sparql-pattern.c"
				} else {
					gboolean _tmp240_;
					gboolean _tmp243_;
					GString* _tmp244_;
					glong _tmp245_;
					GString* _tmp246_;
					GString* _tmp247_;
					GString* _tmp248_;
#line 1100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp240_ = in_triples_block;
#line 1100 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp240_) {
#line 11242 "tracker-sparql-pattern.c"
						GString* _tmp241_;
						gboolean _tmp242_;
#line 1101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp241_ = sql;
#line 1101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp242_ = in_group_graph_pattern;
#line 1101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_end_triples_block (self, _tmp241_, &first_where, _tmp242_, &_inner_error_);
#line 1101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_propagate_error (error, _inner_error_);
#line 1101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (_tmp228_);
#line 1101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_graph);
#line 1101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								filters = (g_free (filters), NULL);
#line 1101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tracker_sparql_context_unref0 (_result_);
#line 1101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 11267 "tracker-sparql-pattern.c"
							} else {
#line 1101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (_tmp228_);
#line 1101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_free0 (old_graph);
#line 1101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								filters = (g_free (filters), NULL);
#line 1101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tracker_sparql_context_unref0 (_result_);
#line 1101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_clear_error (&_inner_error_);
#line 1101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								return NULL;
#line 11283 "tracker-sparql-pattern.c"
							}
						}
#line 1102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						in_triples_block = FALSE;
#line 11288 "tracker-sparql-pattern.c"
					}
#line 1104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp243_ = in_group_graph_pattern;
#line 1104 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp243_) {
#line 1105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						in_group_graph_pattern = TRUE;
#line 11296 "tracker-sparql-pattern.c"
					}
#line 1108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp244_ = sql;
#line 1108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp245_ = group_graph_pattern_start;
#line 1108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_insert (_tmp244_, (gssize) _tmp245_, "SELECT * FROM (");
#line 1109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp246_ = sql;
#line 1109 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp246_, ") NATURAL INNER JOIN (");
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp247_ = sql;
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, _tmp247_, &_inner_error_);
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_tmp228_);
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_graph);
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11328 "tracker-sparql-pattern.c"
						} else {
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (_tmp228_);
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (old_graph);
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1110 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11344 "tracker-sparql-pattern.c"
						}
					}
#line 1111 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp248_ = sql;
#line 1111 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp248_, ")");
#line 11351 "tracker-sparql-pattern.c"
				}
#line 1114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp249_ = old_graph;
#line 1114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp250_ = g_strdup (_tmp249_);
#line 1114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (self->current_graph);
#line 1114 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->current_graph = _tmp250_;
#line 1115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp251_ = old_graph_is_var;
#line 1115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				self->priv->current_graph_is_var = _tmp251_;
#line 1088 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp228_);
#line 1088 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (old_graph);
#line 11369 "tracker-sparql-pattern.c"
			} else {
				gboolean _tmp252_ = FALSE;
				gboolean _tmp253_;
#line 1116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp253_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_BIND, &_inner_error_);
#line 1116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp252_ = _tmp253_;
#line 1116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 1116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 1116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 1116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 11389 "tracker-sparql-pattern.c"
					} else {
#line 1116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						filters = (g_free (filters), NULL);
#line 1116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tracker_sparql_context_unref0 (_result_);
#line 1116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 1116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return NULL;
#line 11401 "tracker-sparql-pattern.c"
					}
				}
#line 1116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp252_) {
#line 11406 "tracker-sparql-pattern.c"
					TrackerSparqlVariableBinding* binding = NULL;
					TrackerSparqlVariableBinding* _tmp254_;
					GString* bind_sql = NULL;
					GString* _tmp255_;
					TrackerSparqlContext* _tmp256_;
					TrackerSparqlContext* _tmp257_;
					gboolean _tmp258_;
					TrackerSparqlExpression* _tmp259_;
					GString* _tmp260_;
					TrackerSparqlContext* _tmp261_;
					TrackerSparqlContext* _tmp262_;
					TrackerSparqlVariableBinding* _tmp263_;
					GString* _tmp264_;
					const gchar* _tmp265_;
					TrackerSparqlVariable* as_var = NULL;
					TrackerSparqlContext* _tmp266_;
					TrackerSparqlContext* _tmp267_;
					gchar* _tmp268_;
					gchar* _tmp269_;
					gchar* _tmp270_;
					gchar* _tmp271_;
					TrackerSparqlVariable* _tmp272_;
					TrackerSparqlVariable* _tmp273_;
					TrackerSparqlVariable* _tmp274_;
					TrackerSparqlVariable* _tmp275_;
					TrackerSparqlVariableBinding* _tmp276_;
					TrackerSparqlVariableBinding* _tmp279_;
					TrackerSparqlVariable* _tmp280_;
					gboolean _tmp281_;
#line 1117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp254_ = tracker_sparql_variable_binding_new ();
#line 1117 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					binding = _tmp254_;
#line 1118 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp255_ = g_string_new ("");
#line 1118 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					bind_sql = _tmp255_;
#line 1120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, &_inner_error_);
#line 1120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11462 "tracker-sparql-pattern.c"
						} else {
#line 1120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1120 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11478 "tracker-sparql-pattern.c"
						}
					}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp256_ = tracker_sparql_pattern_get_context (self);
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp257_ = _tmp256_;
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp258_ = in_group_graph_pattern;
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp257_->need_binding_expression = !_tmp258_;
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp259_ = self->priv->expression;
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp260_ = bind_sql;
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_expression_translate_expression (_tmp259_, _tmp260_, &_inner_error_);
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11511 "tracker-sparql-pattern.c"
						} else {
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11527 "tracker-sparql-pattern.c"
						}
					}
#line 1127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp261_ = tracker_sparql_pattern_get_context (self);
#line 1127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp262_ = _tmp261_;
#line 1127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp262_->need_binding_expression = FALSE;
#line 1128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp263_ = binding;
#line 1128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp264_ = bind_sql;
#line 1128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp265_ = _tmp264_->str;
#line 1128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_data_binding_set_sql_expression ((TrackerSparqlDataBinding*) _tmp263_, _tmp265_);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_AS, &_inner_error_);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11562 "tracker-sparql-pattern.c"
						} else {
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11578 "tracker-sparql-pattern.c"
						}
					}
#line 1131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_VAR, &_inner_error_);
#line 1131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11599 "tracker-sparql-pattern.c"
						} else {
#line 1131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11615 "tracker-sparql-pattern.c"
						}
					}
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp266_ = tracker_sparql_pattern_get_context (self);
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp267_ = _tmp266_;
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp268_ = tracker_sparql_pattern_get_last_string (self, 0);
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp269_ = _tmp268_;
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp270_ = string_substring (_tmp269_, (glong) 1, (glong) -1);
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp271_ = _tmp270_;
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp272_ = tracker_sparql_context_get_variable (_tmp267_, _tmp271_);
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp273_ = _g_object_ref0 (_tmp272_);
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp274_ = _tmp273_;
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp271_);
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp269_);
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					as_var = _tmp274_;
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp275_ = as_var;
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp276_ = _tmp275_->binding;
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp276_ != NULL) {
#line 11648 "tracker-sparql-pattern.c"
						TrackerSparqlQuery* _tmp277_;
						GError* _tmp278_;
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp277_ = self->priv->query;
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp278_ = tracker_sparql_query_get_internal_error (_tmp277_, "Expected undefined variable in BIND alias");
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_inner_error_ = _tmp278_;
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (as_var);
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11673 "tracker-sparql-pattern.c"
						} else {
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (as_var);
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11691 "tracker-sparql-pattern.c"
						}
					}
#line 1139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp279_ = binding;
#line 1139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp280_ = as_var;
#line 1139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp279_->variable = _tmp280_;
#line 1141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp281_ = in_group_graph_pattern;
#line 1141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp281_) {
#line 11704 "tracker-sparql-pattern.c"
						GString* binding_sql = NULL;
						GString* _tmp282_;
						GString* _tmp283_;
						TrackerSparqlVariableBinding* _tmp284_;
						GString* _tmp285_;
						GString* _tmp286_;
						glong _tmp287_;
						GString* _tmp288_;
						const gchar* _tmp289_;
						GString* _tmp290_;
#line 1144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp282_ = g_string_new ("SELECT ");
#line 1144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						binding_sql = _tmp282_;
#line 1145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp283_ = binding_sql;
#line 1145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp284_ = binding;
#line 1145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_add_variable_binding (self, _tmp283_, _tmp284_, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
#line 1146 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp285_ = binding_sql;
#line 1146 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp285_, " * FROM (");
#line 1147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp286_ = sql;
#line 1147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp287_ = group_graph_pattern_start;
#line 1147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp288_ = binding_sql;
#line 1147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp289_ = _tmp288_->str;
#line 1147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_insert (_tmp286_, (gssize) _tmp287_, _tmp289_);
#line 1148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp290_ = sql;
#line 1148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp290_, ")");
#line 1141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_string_free0 (binding_sql);
#line 11745 "tracker-sparql-pattern.c"
					} else {
						GString* _tmp291_;
						TrackerSparqlVariableBinding* _tmp292_;
#line 1153 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp291_ = sql;
#line 1153 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp292_ = binding;
#line 1153 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						tracker_sparql_pattern_add_variable_binding (self, _tmp291_, _tmp292_, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
#line 11755 "tracker-sparql-pattern.c"
					}
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, &_inner_error_);
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (as_var);
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11777 "tracker-sparql-pattern.c"
						} else {
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (as_var);
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_string_free0 (bind_sql);
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (binding);
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 11795 "tracker-sparql-pattern.c"
						}
					}
#line 1116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (as_var);
#line 1116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (bind_sql);
#line 1116 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (binding);
#line 11804 "tracker-sparql-pattern.c"
				} else {
					TrackerSparqlTokenType _tmp293_;
#line 1157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp293_ = tracker_sparql_pattern_current (self);
#line 1157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp293_ == TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE) {
#line 11811 "tracker-sparql-pattern.c"
						gboolean _tmp294_ = FALSE;
						gboolean _tmp295_;
#line 1158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp295_ = in_triples_block;
#line 1158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (!_tmp295_) {
#line 11818 "tracker-sparql-pattern.c"
							gboolean _tmp296_;
#line 1158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp296_ = in_group_graph_pattern;
#line 1158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp294_ = !_tmp296_;
#line 11824 "tracker-sparql-pattern.c"
						} else {
#line 1158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp294_ = FALSE;
#line 11828 "tracker-sparql-pattern.c"
						}
#line 1158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_tmp294_) {
#line 11832 "tracker-sparql-pattern.c"
							GString* _tmp297_;
							glong _tmp298_;
							GString* _tmp299_;
							GString* _tmp300_;
#line 1159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							in_group_graph_pattern = TRUE;
#line 1161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp297_ = sql;
#line 1161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp298_ = group_graph_pattern_start;
#line 1161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_string_insert (_tmp297_, (gssize) _tmp298_, "SELECT * FROM (");
#line 1162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp299_ = sql;
#line 1162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, _tmp299_, &_inner_error_);
#line 1162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_propagate_error (error, _inner_error_);
#line 1162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									filters = (g_free (filters), NULL);
#line 1162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tracker_sparql_context_unref0 (_result_);
#line 1162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return NULL;
#line 11861 "tracker-sparql-pattern.c"
								} else {
#line 1162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									filters = (g_free (filters), NULL);
#line 1162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tracker_sparql_context_unref0 (_result_);
#line 1162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_clear_error (&_inner_error_);
#line 1162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return NULL;
#line 11873 "tracker-sparql-pattern.c"
								}
							}
#line 1163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp300_ = sql;
#line 1163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_string_append (_tmp300_, ")");
#line 11880 "tracker-sparql-pattern.c"
						} else {
							gboolean _tmp301_;
							gboolean _tmp304_;
							GString* _tmp305_;
							glong _tmp306_;
							GString* _tmp307_;
							GString* _tmp308_;
							GString* _tmp309_;
#line 1165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp301_ = in_triples_block;
#line 1165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (_tmp301_) {
#line 11893 "tracker-sparql-pattern.c"
								GString* _tmp302_;
								gboolean _tmp303_;
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp302_ = sql;
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp303_ = in_group_graph_pattern;
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								tracker_sparql_pattern_end_triples_block (self, _tmp302_, &first_where, _tmp303_, &_inner_error_);
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_propagate_error (error, _inner_error_);
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										filters = (g_free (filters), NULL);
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tracker_sparql_context_unref0 (_result_);
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										return NULL;
#line 11914 "tracker-sparql-pattern.c"
									} else {
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										filters = (g_free (filters), NULL);
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_tracker_sparql_context_unref0 (_result_);
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										g_clear_error (&_inner_error_);
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										return NULL;
#line 11926 "tracker-sparql-pattern.c"
									}
								}
#line 1167 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								in_triples_block = FALSE;
#line 11931 "tracker-sparql-pattern.c"
							}
#line 1169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp304_ = in_group_graph_pattern;
#line 1169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (!_tmp304_) {
#line 1170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								in_group_graph_pattern = TRUE;
#line 11939 "tracker-sparql-pattern.c"
							}
#line 1173 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp305_ = sql;
#line 1173 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp306_ = group_graph_pattern_start;
#line 1173 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_string_insert (_tmp305_, (gssize) _tmp306_, "SELECT * FROM (");
#line 1174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp307_ = sql;
#line 1174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_string_append (_tmp307_, ") NATURAL INNER JOIN (");
#line 1175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp308_ = sql;
#line 1175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							tracker_sparql_pattern_translate_group_or_union_graph_pattern (self, _tmp308_, &_inner_error_);
#line 1175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_propagate_error (error, _inner_error_);
#line 1175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									filters = (g_free (filters), NULL);
#line 1175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tracker_sparql_context_unref0 (_result_);
#line 1175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return NULL;
#line 11967 "tracker-sparql-pattern.c"
								} else {
#line 1175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									filters = (g_free (filters), NULL);
#line 1175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tracker_sparql_context_unref0 (_result_);
#line 1175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_clear_error (&_inner_error_);
#line 1175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return NULL;
#line 11979 "tracker-sparql-pattern.c"
								}
							}
#line 1176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp309_ = sql;
#line 1176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_string_append (_tmp309_, ")");
#line 11986 "tracker-sparql-pattern.c"
						}
					} else {
						TrackerSparqlTokenType _tmp310_;
#line 1178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp310_ = tracker_sparql_pattern_current (self);
#line 1178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_tmp310_ == TRACKER_SPARQL_TOKEN_TYPE_FILTER) {
#line 11994 "tracker-sparql-pattern.c"
							TrackerSourceLocation* _tmp311_;
							gint _tmp311__length1;
							TrackerSourceLocation _tmp312_ = {0};
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp311_ = filters;
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp311__length1 = filters_length1;
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							tracker_sparql_pattern_get_location (self, &_tmp312_);
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_vala_array_add8 (&filters, &filters_length1, &_filters_size_, &_tmp312_);
#line 1180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							tracker_sparql_pattern_skip_filter (self, &_inner_error_);
#line 1180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_propagate_error (error, _inner_error_);
#line 1180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									filters = (g_free (filters), NULL);
#line 1180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tracker_sparql_context_unref0 (_result_);
#line 1180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return NULL;
#line 12020 "tracker-sparql-pattern.c"
								} else {
#line 1180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									filters = (g_free (filters), NULL);
#line 1180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tracker_sparql_context_unref0 (_result_);
#line 1180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_clear_error (&_inner_error_);
#line 1180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									return NULL;
#line 12032 "tracker-sparql-pattern.c"
								}
							}
						} else {
#line 1182 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							break;
#line 12038 "tracker-sparql-pattern.c"
						}
					}
				}
			}
		}
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_DOT, &_inner_error_);
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				filters = (g_free (filters), NULL);
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 12058 "tracker-sparql-pattern.c"
			} else {
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				filters = (g_free (filters), NULL);
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 12070 "tracker-sparql-pattern.c"
			}
		}
#line 1188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp313_ = sql;
#line 1188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp314_ = group_graph_pattern_start;
#line 1188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp315_ = found_simple_optional;
#line 1188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_parse_triples (self, _tmp313_, _tmp314_, &in_triples_block, &first_where, &in_group_graph_pattern, _tmp315_, &_inner_error_);
#line 1188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_propagate_error (error, _inner_error_);
#line 1188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				filters = (g_free (filters), NULL);
#line 1188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 1188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 12093 "tracker-sparql-pattern.c"
			} else {
#line 1188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				filters = (g_free (filters), NULL);
#line 1188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tracker_sparql_context_unref0 (_result_);
#line 1188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_clear_error (&_inner_error_);
#line 1188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				return NULL;
#line 12105 "tracker-sparql-pattern.c"
			}
		}
	}
#line 1191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_expect (self, TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, &_inner_error_);
#line 1191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 1191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			filters = (g_free (filters), NULL);
#line 1191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 1191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 12123 "tracker-sparql-pattern.c"
		} else {
#line 1191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			filters = (g_free (filters), NULL);
#line 1191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_result_);
#line 1191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 1191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return NULL;
#line 12135 "tracker-sparql-pattern.c"
		}
	}
#line 1193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp317_ = in_triples_block;
#line 1193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (!_tmp317_) {
#line 12142 "tracker-sparql-pattern.c"
		gboolean _tmp318_;
#line 1193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp318_ = in_group_graph_pattern;
#line 1193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp316_ = !_tmp318_;
#line 12148 "tracker-sparql-pattern.c"
	} else {
#line 1193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp316_ = FALSE;
#line 12152 "tracker-sparql-pattern.c"
	}
#line 1193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp316_) {
#line 12156 "tracker-sparql-pattern.c"
		GString* _tmp319_;
#line 1195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp319_ = sql;
#line 1195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp319_, "SELECT 1");
#line 12162 "tracker-sparql-pattern.c"
	} else {
		gboolean _tmp320_;
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp320_ = in_triples_block;
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp320_) {
#line 12169 "tracker-sparql-pattern.c"
			GString* _tmp321_;
			gboolean _tmp322_;
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp321_ = sql;
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp322_ = in_group_graph_pattern;
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_end_triples_block (self, _tmp321_, &first_where, _tmp322_, &_inner_error_);
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					filters = (g_free (filters), NULL);
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 12190 "tracker-sparql-pattern.c"
				} else {
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					filters = (g_free (filters), NULL);
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (_result_);
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return NULL;
#line 12202 "tracker-sparql-pattern.c"
				}
			}
#line 1198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			in_triples_block = FALSE;
#line 12207 "tracker-sparql-pattern.c"
		}
	}
#line 1201 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp323_ = in_group_graph_pattern;
#line 1201 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp323_) {
#line 1202 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		first_where = TRUE;
#line 12216 "tracker-sparql-pattern.c"
	}
#line 1206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp324_ = filters;
#line 1206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp324__length1 = filters_length1;
#line 1206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp324__length1 > 0) {
#line 12224 "tracker-sparql-pattern.c"
		TrackerSourceLocation end = {0};
		TrackerSourceLocation _tmp325_ = {0};
		TrackerSourceLocation* _tmp326_;
		gint _tmp326__length1;
		TrackerSourceLocation _tmp332_;
#line 1207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_get_location (self, &_tmp325_);
#line 1207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		end = _tmp325_;
#line 1209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp326_ = filters;
#line 1209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp326__length1 = filters_length1;
#line 12238 "tracker-sparql-pattern.c"
		{
			TrackerSourceLocation* filter_location_collection = NULL;
			gint filter_location_collection_length1 = 0;
			gint _filter_location_collection_size_ = 0;
			gint filter_location_it = 0;
#line 1209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			filter_location_collection = _tmp326_;
#line 1209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			filter_location_collection_length1 = _tmp326__length1;
#line 1209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			for (filter_location_it = 0; filter_location_it < _tmp326__length1; filter_location_it = filter_location_it + 1) {
#line 12250 "tracker-sparql-pattern.c"
				TrackerSourceLocation filter_location = {0};
#line 1209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				filter_location = filter_location_collection[filter_location_it];
#line 12254 "tracker-sparql-pattern.c"
				{
					gboolean _tmp327_;
					TrackerSourceLocation _tmp330_;
					GString* _tmp331_;
#line 1210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp327_ = first_where;
#line 1210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp327_) {
#line 12263 "tracker-sparql-pattern.c"
						GString* _tmp328_;
#line 1211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp328_ = sql;
#line 1211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp328_, " AND ");
#line 12269 "tracker-sparql-pattern.c"
					} else {
						GString* _tmp329_;
#line 1213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp329_ = sql;
#line 1213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp329_, " WHERE ");
#line 1214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						first_where = FALSE;
#line 12278 "tracker-sparql-pattern.c"
					}
#line 1217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp330_ = filter_location;
#line 1217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_set_location (self, &_tmp330_);
#line 1218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp331_ = sql;
#line 1218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					tracker_sparql_pattern_translate_filter (self, _tmp331_, &_inner_error_);
#line 1218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 12300 "tracker-sparql-pattern.c"
						} else {
#line 1218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							filters = (g_free (filters), NULL);
#line 1218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tracker_sparql_context_unref0 (_result_);
#line 1218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return NULL;
#line 12312 "tracker-sparql-pattern.c"
						}
					}
				}
			}
		}
#line 1221 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp332_ = end;
#line 1221 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_set_location (self, &_tmp332_);
#line 12322 "tracker-sparql-pattern.c"
	}
#line 1224 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp333_ = tracker_sparql_pattern_get_context (self);
#line 1224 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp334_ = _tmp333_;
#line 1224 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp335_ = _tmp334_->parent_context;
#line 1224 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_set_context (self, _tmp335_);
#line 1225 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _result_;
#line 1225 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	filters = (g_free (filters), NULL);
#line 1225 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 12338 "tracker-sparql-pattern.c"
}


static void _vala_array_add9 (glong* * array, int* length, int* size, glong value) {
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if ((*length) == (*size)) {
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*array = g_renew (glong, *array, *size);
#line 12349 "tracker-sparql-pattern.c"
	}
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[(*length)++] = value;
#line 12353 "tracker-sparql-pattern.c"
}


static void _vala_array_add10 (TrackerSparqlContext** * array, int* length, int* size, TrackerSparqlContext* value) {
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if ((*length) == (*size)) {
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*array = g_renew (TrackerSparqlContext*, *array, (*size) + 1);
#line 12364 "tracker-sparql-pattern.c"
	}
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[(*length)++] = value;
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[*length] = NULL;
#line 12370 "tracker-sparql-pattern.c"
}


static gpointer _tracker_sparql_context_ref0 (gpointer self) {
#line 1244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return self ? tracker_sparql_context_ref (self) : NULL;
#line 12377 "tracker-sparql-pattern.c"
}


static void _vala_array_add11 (TrackerSparqlVariable** * array, int* length, int* size, TrackerSparqlVariable* value) {
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if ((*length) == (*size)) {
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*array = g_renew (TrackerSparqlVariable*, *array, (*size) + 1);
#line 12388 "tracker-sparql-pattern.c"
	}
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[(*length)++] = value;
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	(*array)[*length] = NULL;
#line 12394 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_translate_group_or_union_graph_pattern (TrackerSparqlPattern* self, GString* sql, GError** error) {
	TrackerSparqlVariable** all_vars = NULL;
	TrackerSparqlVariable** _tmp0_;
	gint all_vars_length1;
	gint _all_vars_size_;
	GHashTable* all_var_set = NULL;
	GDestroyNotify _tmp1_;
	GHashTable* _tmp2_;
	TrackerSparqlContext** contexts = NULL;
	TrackerSparqlContext** _tmp3_;
	gint contexts_length1;
	gint _contexts_size_;
	glong* offsets = NULL;
	glong* _tmp4_;
	gint offsets_length1;
	gint _offsets_size_;
	TrackerSparqlContext** _tmp16_;
	gint _tmp16__length1;
	GError * _inner_error_ = NULL;
#line 1228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 1228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 1229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = g_new0 (TrackerSparqlVariable*, 0 + 1);
#line 1229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	all_vars = _tmp0_;
#line 1229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	all_vars_length1 = 0;
#line 1229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_all_vars_size_ = all_vars_length1;
#line 1230 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = g_object_unref;
#line 1230 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, _tmp1_, NULL);
#line 1230 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	all_var_set = _tmp2_;
#line 1232 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = g_new0 (TrackerSparqlContext*, 0 + 1);
#line 1232 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	contexts = _tmp3_;
#line 1232 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	contexts_length1 = 0;
#line 1232 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_contexts_size_ = contexts_length1;
#line 1233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp4_ = g_new0 (glong, 0);
#line 1233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	offsets = _tmp4_;
#line 1233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	offsets_length1 = 0;
#line 1233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_offsets_size_ = offsets_length1;
#line 12451 "tracker-sparql-pattern.c"
	{
		gboolean _tmp5_ = FALSE;
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_ = TRUE;
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		while (TRUE) {
#line 12458 "tracker-sparql-pattern.c"
			glong* _tmp8_;
			gint _tmp8__length1;
			GString* _tmp9_;
			gssize _tmp10_;
			TrackerSparqlContext* _tmp11_ = NULL;
			GString* _tmp12_;
			TrackerSparqlContext* _tmp13_;
			TrackerSparqlContext** _tmp14_;
			gint _tmp14__length1;
			TrackerSparqlContext* _tmp15_;
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (!_tmp5_) {
#line 12471 "tracker-sparql-pattern.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_;
#line 1238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp7_ = tracker_sparql_pattern_accept (self, TRACKER_SPARQL_TOKEN_TYPE_UNION, &_inner_error_);
#line 1238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp6_ = _tmp7_;
#line 1238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 1238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						offsets = (g_free (offsets), NULL);
#line 1238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
#line 1238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_hash_table_unref0 (all_var_set);
#line 1238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 12494 "tracker-sparql-pattern.c"
					} else {
#line 1238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						offsets = (g_free (offsets), NULL);
#line 1238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
#line 1238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_hash_table_unref0 (all_var_set);
#line 1238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 1238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 12510 "tracker-sparql-pattern.c"
					}
				}
#line 1238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp6_) {
#line 1238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					break;
#line 12517 "tracker-sparql-pattern.c"
				}
			}
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp5_ = FALSE;
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp8_ = offsets;
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp8__length1 = offsets_length1;
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp9_ = sql;
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp10_ = _tmp9_->len;
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_vala_array_add9 (&offsets, &offsets_length1, &_offsets_size_, (glong) _tmp10_);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp12_ = sql;
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp13_ = tracker_sparql_pattern_translate_group_graph_pattern (self, _tmp12_, &_inner_error_);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp11_ = _tmp13_;
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					offsets = (g_free (offsets), NULL);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_hash_table_unref0 (all_var_set);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 12554 "tracker-sparql-pattern.c"
				} else {
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					offsets = (g_free (offsets), NULL);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_hash_table_unref0 (all_var_set);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 12570 "tracker-sparql-pattern.c"
				}
			}
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp14_ = contexts;
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp14__length1 = contexts_length1;
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp15_ = _tmp11_;
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp11_ = NULL;
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_vala_array_add10 (&contexts, &contexts_length1, &_contexts_size_, _tmp15_);
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (_tmp11_);
#line 12585 "tracker-sparql-pattern.c"
		}
	}
#line 1240 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp16_ = contexts;
#line 1240 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp16__length1 = contexts_length1;
#line 1240 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp16__length1 > 1) {
#line 12594 "tracker-sparql-pattern.c"
		TrackerSparqlContext** _tmp17_;
		gint _tmp17__length1;
		glong extra_offset = 0L;
		GString* _tmp71_;
#line 1244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp17_ = contexts;
#line 1244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp17__length1 = contexts_length1;
#line 12603 "tracker-sparql-pattern.c"
		{
			TrackerSparqlContext** sub_context_collection = NULL;
			gint sub_context_collection_length1 = 0;
			gint _sub_context_collection_size_ = 0;
			gint sub_context_it = 0;
#line 1244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			sub_context_collection = _tmp17_;
#line 1244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			sub_context_collection_length1 = _tmp17__length1;
#line 1244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			for (sub_context_it = 0; sub_context_it < _tmp17__length1; sub_context_it = sub_context_it + 1) {
#line 12615 "tracker-sparql-pattern.c"
				TrackerSparqlContext* _tmp18_;
				TrackerSparqlContext* sub_context = NULL;
#line 1244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp18_ = _tracker_sparql_context_ref0 (sub_context_collection[sub_context_it]);
#line 1244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				sub_context = _tmp18_;
#line 12622 "tracker-sparql-pattern.c"
				{
					TrackerSparqlContext* _tmp19_;
					GHashTable* _tmp20_;
					GList* _tmp21_;
#line 1245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp19_ = sub_context;
#line 1245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp20_ = _tmp19_->var_set;
#line 1245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp21_ = g_hash_table_get_keys (_tmp20_);
#line 12633 "tracker-sparql-pattern.c"
					{
						GList* v_collection = NULL;
						GList* v_it = NULL;
#line 1245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						v_collection = _tmp21_;
#line 1245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
#line 12641 "tracker-sparql-pattern.c"
							TrackerSparqlVariable* v = NULL;
#line 1245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							v = (TrackerSparqlVariable*) v_it->data;
#line 12645 "tracker-sparql-pattern.c"
							{
								GHashTable* _tmp22_;
								TrackerSparqlVariable* _tmp23_;
								gconstpointer _tmp24_;
#line 1246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp22_ = all_var_set;
#line 1246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp23_ = v;
#line 1246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp24_ = g_hash_table_lookup (_tmp22_, _tmp23_);
#line 1246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (((gint) ((gintptr) _tmp24_)) == 0) {
#line 12658 "tracker-sparql-pattern.c"
									TrackerSparqlVariable** _tmp25_;
									gint _tmp25__length1;
									TrackerSparqlVariable* _tmp26_;
									TrackerSparqlVariable* _tmp27_;
									GHashTable* _tmp28_;
									TrackerSparqlVariable* _tmp29_;
									TrackerSparqlVariable* _tmp30_;
									TrackerSparqlContext* _tmp31_;
									TrackerSparqlContext* _tmp32_;
									GHashTable* _tmp33_;
									TrackerSparqlVariable* _tmp34_;
									TrackerSparqlVariable* _tmp35_;
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp25_ = all_vars;
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp25__length1 = all_vars_length1;
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp26_ = v;
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp27_ = _g_object_ref0 (_tmp26_);
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_vala_array_add11 (&all_vars, &all_vars_length1, &_all_vars_size_, _tmp27_);
#line 1248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp28_ = all_var_set;
#line 1248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp29_ = v;
#line 1248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp30_ = _g_object_ref0 (_tmp29_);
#line 1248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_hash_table_insert (_tmp28_, _tmp30_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)));
#line 1249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp31_ = tracker_sparql_pattern_get_context (self);
#line 1249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp32_ = _tmp31_;
#line 1249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp33_ = _tmp32_->var_set;
#line 1249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp34_ = v;
#line 1249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp35_ = _g_object_ref0 (_tmp34_);
#line 1249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_hash_table_insert (_tmp33_, _tmp35_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)));
#line 12701 "tracker-sparql-pattern.c"
								}
							}
						}
#line 1245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_list_free0 (v_collection);
#line 12707 "tracker-sparql-pattern.c"
					}
#line 1244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tracker_sparql_context_unref0 (sub_context);
#line 12711 "tracker-sparql-pattern.c"
				}
			}
		}
#line 1254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		extra_offset = (glong) 0;
#line 12717 "tracker-sparql-pattern.c"
		{
			gint i = 0;
#line 1255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			i = 0;
#line 12722 "tracker-sparql-pattern.c"
			{
				gboolean _tmp36_ = FALSE;
#line 1255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp36_ = TRUE;
#line 1255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				while (TRUE) {
#line 12729 "tracker-sparql-pattern.c"
					gint _tmp38_;
					TrackerSparqlContext** _tmp39_;
					gint _tmp39__length1;
					GString* projection = NULL;
					GString* _tmp40_;
					gint _tmp41_;
					GString* _tmp43_;
					TrackerSparqlVariable** _tmp44_;
					gint _tmp44__length1;
					GString* _tmp57_;
					GString* _tmp58_;
					gssize _tmp59_;
					GString* _tmp60_;
					GString* _tmp61_;
					glong* _tmp62_;
					gint _tmp62__length1;
					gint _tmp63_;
					glong _tmp64_;
					glong _tmp65_;
					GString* _tmp66_;
					const gchar* _tmp67_;
					glong _tmp68_;
					GString* _tmp69_;
					gssize _tmp70_;
#line 1255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!_tmp36_) {
#line 12756 "tracker-sparql-pattern.c"
						gint _tmp37_;
#line 1255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp37_ = i;
#line 1255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						i = _tmp37_ + 1;
#line 12762 "tracker-sparql-pattern.c"
					}
#line 1255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp36_ = FALSE;
#line 1255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp38_ = i;
#line 1255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp39_ = contexts;
#line 1255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp39__length1 = contexts_length1;
#line 1255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (!(_tmp38_ < _tmp39__length1)) {
#line 1255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						break;
#line 12776 "tracker-sparql-pattern.c"
					}
#line 1256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp40_ = g_string_new ("");
#line 1256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					projection = _tmp40_;
#line 1257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp41_ = i;
#line 1257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp41_ > 0) {
#line 12786 "tracker-sparql-pattern.c"
						GString* _tmp42_;
#line 1258 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp42_ = projection;
#line 1258 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_string_append (_tmp42_, ") UNION ALL ");
#line 12792 "tracker-sparql-pattern.c"
					}
#line 1260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp43_ = projection;
#line 1260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp43_, "SELECT ");
#line 1261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp44_ = all_vars;
#line 1261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp44__length1 = all_vars_length1;
#line 12802 "tracker-sparql-pattern.c"
					{
						TrackerSparqlVariable** v_collection = NULL;
						gint v_collection_length1 = 0;
						gint _v_collection_size_ = 0;
						gint v_it = 0;
#line 1261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						v_collection = _tmp44_;
#line 1261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						v_collection_length1 = _tmp44__length1;
#line 1261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						for (v_it = 0; v_it < _tmp44__length1; v_it = v_it + 1) {
#line 12814 "tracker-sparql-pattern.c"
							TrackerSparqlVariable* _tmp45_;
							TrackerSparqlVariable* v = NULL;
#line 1261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_tmp45_ = _g_object_ref0 (v_collection[v_it]);
#line 1261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							v = _tmp45_;
#line 12821 "tracker-sparql-pattern.c"
							{
								TrackerSparqlContext** _tmp46_;
								gint _tmp46__length1;
								gint _tmp47_;
								TrackerSparqlContext* _tmp48_;
								GHashTable* _tmp49_;
								TrackerSparqlVariable* _tmp50_;
								gconstpointer _tmp51_;
								GString* _tmp53_;
								TrackerSparqlVariable* _tmp54_;
								const gchar* _tmp55_;
								const gchar* _tmp56_;
#line 1262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp46_ = contexts;
#line 1262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp46__length1 = contexts_length1;
#line 1262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp47_ = i;
#line 1262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp48_ = _tmp46_[_tmp47_];
#line 1262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp49_ = _tmp48_->var_set;
#line 1262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp50_ = v;
#line 1262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp51_ = g_hash_table_lookup (_tmp49_, _tmp50_);
#line 1262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								if (((gint) ((gintptr) _tmp51_)) == 0) {
#line 12850 "tracker-sparql-pattern.c"
									GString* _tmp52_;
#line 1265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp52_ = projection;
#line 1265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									g_string_append (_tmp52_, "NULL AS ");
#line 12856 "tracker-sparql-pattern.c"
								}
#line 1267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp53_ = projection;
#line 1267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp54_ = v;
#line 1267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp55_ = tracker_sparql_variable_get_sql_expression (_tmp54_);
#line 1267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp56_ = _tmp55_;
#line 1267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								g_string_append_printf (_tmp53_, "%s, ", _tmp56_);
#line 1261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_g_object_unref0 (v);
#line 12870 "tracker-sparql-pattern.c"
							}
						}
					}
#line 1270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp57_ = projection;
#line 1270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp58_ = projection;
#line 1270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp59_ = _tmp58_->len;
#line 1270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_truncate (_tmp57_, (gsize) (_tmp59_ - 2));
#line 1271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp60_ = projection;
#line 1271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append (_tmp60_, " FROM (");
#line 1273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp61_ = sql;
#line 1273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp62_ = offsets;
#line 1273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp62__length1 = offsets_length1;
#line 1273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp63_ = i;
#line 1273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp64_ = _tmp62_[_tmp63_];
#line 1273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp65_ = extra_offset;
#line 1273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp66_ = projection;
#line 1273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp67_ = _tmp66_->str;
#line 1273 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_insert (_tmp61_, (gssize) (_tmp64_ + _tmp65_), _tmp67_);
#line 1274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp68_ = extra_offset;
#line 1274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp69_ = projection;
#line 1274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp70_ = _tmp69_->len;
#line 1274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					extra_offset = _tmp68_ + _tmp70_;
#line 1255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_string_free0 (projection);
#line 12914 "tracker-sparql-pattern.c"
				}
			}
		}
#line 1276 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp71_ = sql;
#line 1276 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp71_, ")");
#line 12922 "tracker-sparql-pattern.c"
	} else {
		TrackerSparqlContext** _tmp72_;
		gint _tmp72__length1;
		TrackerSparqlContext* _tmp73_;
		GHashTable* _tmp74_;
		GList* _tmp75_;
#line 1278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp72_ = contexts;
#line 1278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp72__length1 = contexts_length1;
#line 1278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp73_ = _tmp72_[0];
#line 1278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp74_ = _tmp73_->var_set;
#line 1278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp75_ = g_hash_table_get_keys (_tmp74_);
#line 12939 "tracker-sparql-pattern.c"
		{
			GList* key_collection = NULL;
			GList* key_it = NULL;
#line 1278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			key_collection = _tmp75_;
#line 1278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
#line 12947 "tracker-sparql-pattern.c"
				TrackerSparqlVariable* key = NULL;
#line 1278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				key = (TrackerSparqlVariable*) key_it->data;
#line 12951 "tracker-sparql-pattern.c"
				{
					TrackerSparqlContext* _tmp76_;
					TrackerSparqlContext* _tmp77_;
					GHashTable* _tmp78_;
					TrackerSparqlVariable* _tmp79_;
					TrackerSparqlVariable* _tmp80_;
#line 1279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp76_ = tracker_sparql_pattern_get_context (self);
#line 1279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp77_ = _tmp76_;
#line 1279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp78_ = _tmp77_->var_set;
#line 1279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp79_ = key;
#line 1279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp80_ = _g_object_ref0 (_tmp79_);
#line 1279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_hash_table_insert (_tmp78_, _tmp80_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)));
#line 12970 "tracker-sparql-pattern.c"
				}
			}
#line 1278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_list_free0 (key_collection);
#line 12975 "tracker-sparql-pattern.c"
		}
	}
#line 1228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	offsets = (g_free (offsets), NULL);
#line 1228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	contexts = (_vala_array_free (contexts, contexts_length1, (GDestroyNotify) tracker_sparql_context_unref), NULL);
#line 1228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_hash_table_unref0 (all_var_set);
#line 1228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	all_vars = (_vala_array_free (all_vars, all_vars_length1, (GDestroyNotify) g_object_unref), NULL);
#line 12986 "tracker-sparql-pattern.c"
}


static TrackerSparqlVariableBindingList* tracker_sparql_pattern_get_variable_binding_list (TrackerSparqlPattern* self, TrackerSparqlVariable* variable) {
	TrackerSparqlVariableBindingList* result = NULL;
	TrackerSparqlVariableBindingList* binding_list = NULL;
	TrackerSparqlPatternTripleContext* _tmp0_;
	gboolean _tmp6_ = FALSE;
	TrackerSparqlVariableBindingList* _tmp7_;
#line 1284 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1284 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (variable != NULL, NULL);
#line 1285 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	binding_list = NULL;
#line 1286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->triple_context;
#line 1286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp0_ != NULL) {
#line 13006 "tracker-sparql-pattern.c"
		TrackerSparqlPatternTripleContext* _tmp1_;
		GHashTable* _tmp2_;
		TrackerSparqlVariable* _tmp3_;
		gconstpointer _tmp4_;
		TrackerSparqlVariableBindingList* _tmp5_;
#line 1287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp1_ = self->priv->triple_context;
#line 1287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp2_ = _tmp1_->var_bindings;
#line 1287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp3_ = variable;
#line 1287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = g_hash_table_lookup (_tmp2_, _tmp3_);
#line 1287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_ = _g_object_ref0 ((TrackerSparqlVariableBindingList*) _tmp4_);
#line 1287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (binding_list);
#line 1287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		binding_list = _tmp5_;
#line 13026 "tracker-sparql-pattern.c"
	}
#line 1289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp7_ = binding_list;
#line 1289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp7_ == NULL) {
#line 13032 "tracker-sparql-pattern.c"
		TrackerSparqlVariable* _tmp8_;
		TrackerSparqlVariableBinding* _tmp9_;
#line 1289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp8_ = variable;
#line 1289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp9_ = _tmp8_->binding;
#line 1289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp6_ = _tmp9_ != NULL;
#line 13041 "tracker-sparql-pattern.c"
	} else {
#line 1289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp6_ = FALSE;
#line 13045 "tracker-sparql-pattern.c"
	}
#line 1289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp6_) {
#line 13049 "tracker-sparql-pattern.c"
		TrackerSparqlContext* current_context = NULL;
		TrackerSparqlContext* _tmp10_;
		TrackerSparqlContext* _tmp11_;
		TrackerSparqlContext* _tmp12_;
#line 1291 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp10_ = tracker_sparql_pattern_get_context (self);
#line 1291 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp11_ = _tmp10_;
#line 1291 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp12_ = _tracker_sparql_context_ref0 (_tmp11_);
#line 1291 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		current_context = _tmp12_;
#line 1292 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		while (TRUE) {
#line 13064 "tracker-sparql-pattern.c"
			TrackerSparqlContext* _tmp13_;
			gboolean _tmp14_ = FALSE;
			TrackerSparqlContext* _tmp15_;
			gboolean _tmp16_;
			TrackerSparqlContext* _tmp62_;
			TrackerSparqlContext* _tmp63_;
			TrackerSparqlContext* _tmp64_;
#line 1292 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp13_ = current_context;
#line 1292 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (!(_tmp13_ != NULL)) {
#line 1292 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				break;
#line 13078 "tracker-sparql-pattern.c"
			}
#line 1295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp15_ = current_context;
#line 1295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp16_ = _tmp15_->scalar_subquery;
#line 1295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp16_) {
#line 13086 "tracker-sparql-pattern.c"
				TrackerSparqlContext* _tmp17_;
				TrackerSparqlContext* _tmp18_;
				GHashTable* _tmp19_;
				TrackerSparqlVariable* _tmp20_;
				gconstpointer _tmp21_;
#line 1295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp17_ = current_context;
#line 1295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp18_ = _tmp17_->parent_context;
#line 1295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp19_ = _tmp18_->var_set;
#line 1295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp20_ = variable;
#line 1295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp21_ = g_hash_table_lookup (_tmp19_, _tmp20_);
#line 1295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp14_ = ((gint) ((gintptr) _tmp21_)) != 0;
#line 13104 "tracker-sparql-pattern.c"
			} else {
#line 1295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp14_ = FALSE;
#line 13108 "tracker-sparql-pattern.c"
			}
#line 1295 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp14_) {
#line 13112 "tracker-sparql-pattern.c"
				TrackerSparqlVariableBinding* binding = NULL;
				TrackerSparqlVariableBinding* _tmp22_;
				TrackerSparqlVariableBinding* _tmp23_;
				TrackerSparqlVariable* _tmp24_;
				TrackerSparqlVariableBinding* _tmp25_;
				TrackerPropertyType _tmp26_;
				TrackerSparqlVariableBinding* _tmp27_;
				TrackerSparqlContext* _tmp28_;
				TrackerSparqlContext* _tmp29_;
				TrackerSparqlVariable* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				TrackerSparqlVariable* _tmp33_;
				TrackerSparqlVariableBinding* _tmp34_;
				TrackerSparqlVariable* _tmp35_;
				TrackerSparqlVariableBinding* _tmp36_;
				TrackerClass* _tmp37_;
				TrackerClass* _tmp38_;
				TrackerSparqlVariableBinding* _tmp39_;
				TrackerSparqlVariable* _tmp40_;
				const gchar* _tmp41_;
				const gchar* _tmp42_;
				TrackerSparqlVariableBindingList* _tmp43_;
				TrackerSparqlPatternTripleContext* _tmp44_;
				TrackerSparqlContext* _tmp54_;
				TrackerSparqlContext* _tmp55_;
				GHashTable* _tmp56_;
				TrackerSparqlVariable* _tmp57_;
				TrackerSparqlVariable* _tmp58_;
				TrackerSparqlVariableBindingList* _tmp59_;
				TrackerSparqlVariableBinding* _tmp60_;
				TrackerSparqlVariableBinding* _tmp61_;
#line 1297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp22_ = tracker_sparql_variable_binding_new ();
#line 1297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				binding = _tmp22_;
#line 1298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp23_ = binding;
#line 1298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp24_ = variable;
#line 1298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp25_ = _tmp24_->binding;
#line 1298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp26_ = ((TrackerSparqlDataBinding*) _tmp25_)->data_type;
#line 1298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp23_)->data_type = _tmp26_;
#line 1299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp27_ = binding;
#line 1299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp28_ = tracker_sparql_pattern_get_context (self);
#line 1299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp29_ = _tmp28_;
#line 1299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp30_ = variable;
#line 1299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp31_ = tracker_sparql_variable_get_name (_tmp30_);
#line 1299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp32_ = _tmp31_;
#line 1299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp33_ = tracker_sparql_context_get_variable (_tmp29_, _tmp32_);
#line 1299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp27_->variable = _tmp33_;
#line 1300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp34_ = binding;
#line 1300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp35_ = variable;
#line 1300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp36_ = _tmp35_->binding;
#line 1300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp37_ = _tmp36_->type;
#line 1300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp38_ = _g_object_ref0 (_tmp37_);
#line 1300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (_tmp34_->type);
#line 1300 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp34_->type = _tmp38_;
#line 1301 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp39_ = binding;
#line 1301 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp40_ = variable;
#line 1301 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp41_ = tracker_sparql_variable_get_sql_expression (_tmp40_);
#line 1301 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp42_ = _tmp41_;
#line 1301 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_data_binding_set_sql_expression ((TrackerSparqlDataBinding*) _tmp39_, _tmp42_);
#line 1302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp43_ = tracker_sparql_variable_binding_list_new ();
#line 1302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding_list);
#line 1302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				binding_list = _tmp43_;
#line 1303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp44_ = self->priv->triple_context;
#line 1303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp44_ != NULL) {
#line 13209 "tracker-sparql-pattern.c"
					TrackerSparqlPatternTripleContext* _tmp45_;
					TrackerSparqlVariable* _tmp46_;
					TrackerSparqlVariable* _tmp47_;
					TrackerSparqlPatternTripleContext* _tmp48_;
					GHashTable* _tmp49_;
					TrackerSparqlVariable* _tmp50_;
					TrackerSparqlVariable* _tmp51_;
					TrackerSparqlVariableBindingList* _tmp52_;
					TrackerSparqlVariableBindingList* _tmp53_;
#line 1304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp45_ = self->priv->triple_context;
#line 1304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp46_ = variable;
#line 1304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp47_ = _g_object_ref0 (_tmp46_);
#line 1304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp45_->variables = g_list_append (_tmp45_->variables, _tmp47_);
#line 1305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp48_ = self->priv->triple_context;
#line 1305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp49_ = _tmp48_->var_bindings;
#line 1305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp50_ = variable;
#line 1305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp51_ = _g_object_ref0 (_tmp50_);
#line 1305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp52_ = binding_list;
#line 1305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp53_ = _g_object_ref0 (_tmp52_);
#line 1305 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_hash_table_insert (_tmp49_, _tmp51_, _tmp53_);
#line 13241 "tracker-sparql-pattern.c"
				}
#line 1308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp54_ = tracker_sparql_pattern_get_context (self);
#line 1308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp55_ = _tmp54_;
#line 1308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp56_ = _tmp55_->var_set;
#line 1308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp57_ = variable;
#line 1308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp58_ = _g_object_ref0 (_tmp57_);
#line 1308 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_hash_table_insert (_tmp56_, _tmp58_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_BOUND)));
#line 1309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp59_ = binding_list;
#line 1309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp60_ = binding;
#line 1309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp61_ = _g_object_ref0 (_tmp60_);
#line 1309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp59_->list = g_list_append (_tmp59_->list, _tmp61_);
#line 1310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding);
#line 1310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				break;
#line 13267 "tracker-sparql-pattern.c"
			}
#line 1312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp62_ = current_context;
#line 1312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp63_ = _tmp62_->parent_context;
#line 1312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp64_ = _tracker_sparql_context_ref0 (_tmp63_);
#line 1312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tracker_sparql_context_unref0 (current_context);
#line 1312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			current_context = _tmp64_;
#line 13279 "tracker-sparql-pattern.c"
		}
#line 1289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tracker_sparql_context_unref0 (current_context);
#line 13283 "tracker-sparql-pattern.c"
	}
#line 1315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = binding_list;
#line 1315 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 13289 "tracker-sparql-pattern.c"
}


void tracker_sparql_pattern_add_variable_binding (TrackerSparqlPattern* self, GString* sql, TrackerSparqlVariableBinding* binding, TrackerSparqlVariableState variable_state) {
	TrackerSparqlVariableBindingList* binding_list = NULL;
	TrackerSparqlVariableBinding* _tmp0_;
	TrackerSparqlVariable* _tmp1_;
	TrackerSparqlVariableBindingList* _tmp2_;
	TrackerSparqlVariableBindingList* _tmp3_;
	TrackerSparqlVariableBindingList* _tmp50_;
	TrackerSparqlVariableBinding* _tmp51_;
	TrackerSparqlVariableBinding* _tmp52_;
	TrackerSparqlVariableBinding* _tmp53_;
	TrackerSparqlVariable* _tmp54_;
	TrackerSparqlVariableBinding* _tmp55_;
#line 1318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 1318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 1318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (binding != NULL);
#line 1319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = binding;
#line 1319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = _tmp0_->variable;
#line 1319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = tracker_sparql_pattern_get_variable_binding_list (self, _tmp1_);
#line 1319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	binding_list = _tmp2_;
#line 1320 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = binding_list;
#line 1320 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp3_ == NULL) {
#line 13323 "tracker-sparql-pattern.c"
		TrackerSparqlVariableBindingList* _tmp4_;
		TrackerSparqlPatternTripleContext* _tmp5_;
		GString* _tmp17_;
		TrackerSparqlVariableBinding* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		TrackerSparqlVariableBinding* _tmp21_;
		TrackerSparqlVariable* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		TrackerSparqlVariableBinding* _tmp25_;
		TrackerPropertyType _tmp26_;
		TrackerSparqlContext* _tmp43_;
		TrackerSparqlContext* _tmp44_;
		GHashTable* _tmp45_;
		TrackerSparqlVariableBinding* _tmp46_;
		TrackerSparqlVariable* _tmp47_;
		TrackerSparqlVariable* _tmp48_;
		TrackerSparqlVariableState _tmp49_;
#line 1321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = tracker_sparql_variable_binding_list_new ();
#line 1321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (binding_list);
#line 1321 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		binding_list = _tmp4_;
#line 1322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_ = self->priv->triple_context;
#line 1322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp5_ != NULL) {
#line 13353 "tracker-sparql-pattern.c"
			TrackerSparqlPatternTripleContext* _tmp6_;
			TrackerSparqlVariableBinding* _tmp7_;
			TrackerSparqlVariable* _tmp8_;
			TrackerSparqlVariable* _tmp9_;
			TrackerSparqlPatternTripleContext* _tmp10_;
			GHashTable* _tmp11_;
			TrackerSparqlVariableBinding* _tmp12_;
			TrackerSparqlVariable* _tmp13_;
			TrackerSparqlVariable* _tmp14_;
			TrackerSparqlVariableBindingList* _tmp15_;
			TrackerSparqlVariableBindingList* _tmp16_;
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp6_ = self->priv->triple_context;
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp7_ = binding;
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp8_ = _tmp7_->variable;
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp9_ = _g_object_ref0 (_tmp8_);
#line 1323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp6_->variables = g_list_append (_tmp6_->variables, _tmp9_);
#line 1324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp10_ = self->priv->triple_context;
#line 1324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp11_ = _tmp10_->var_bindings;
#line 1324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp12_ = binding;
#line 1324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp13_ = _tmp12_->variable;
#line 1324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp14_ = _g_object_ref0 (_tmp13_);
#line 1324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp15_ = binding_list;
#line 1324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp16_ = _g_object_ref0 (_tmp15_);
#line 1324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_hash_table_insert (_tmp11_, _tmp14_, _tmp16_);
#line 13391 "tracker-sparql-pattern.c"
		}
#line 1327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp17_ = sql;
#line 1327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp18_ = binding;
#line 1327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp19_ = tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) _tmp18_);
#line 1327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp20_ = _tmp19_;
#line 1327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp21_ = binding;
#line 1327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp22_ = _tmp21_->variable;
#line 1327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp23_ = tracker_sparql_variable_get_sql_expression (_tmp22_);
#line 1327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp24_ = _tmp23_;
#line 1327 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append_printf (_tmp17_, "%s AS %s, ", _tmp20_, _tmp24_);
#line 1331 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp25_ = binding;
#line 1331 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp26_ = ((TrackerSparqlDataBinding*) _tmp25_)->data_type;
#line 1331 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp26_ == TRACKER_PROPERTY_TYPE_DATETIME) {
#line 13417 "tracker-sparql-pattern.c"
			GString* _tmp27_;
			TrackerSparqlVariableBinding* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			TrackerSparqlVariableBinding* _tmp31_;
			TrackerSparqlVariable* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			GString* _tmp35_;
			TrackerSparqlVariableBinding* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			TrackerSparqlVariableBinding* _tmp39_;
			TrackerSparqlVariable* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
#line 1332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp27_ = sql;
#line 1332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp28_ = binding;
#line 1332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp29_ = tracker_sparql_data_binding_get_extra_sql_expression ((TrackerSparqlDataBinding*) _tmp28_, "localDate");
#line 1332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp30_ = _tmp29_;
#line 1332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp31_ = binding;
#line 1332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp32_ = _tmp31_->variable;
#line 1332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp33_ = tracker_sparql_variable_get_extra_sql_expression (_tmp32_, "localDate");
#line 1332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp34_ = _tmp33_;
#line 1332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_string_append_printf (_tmp27_, "%s AS %s, ", _tmp30_, _tmp34_);
#line 1332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp34_);
#line 1332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp30_);
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp35_ = sql;
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp36_ = binding;
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp37_ = tracker_sparql_data_binding_get_extra_sql_expression ((TrackerSparqlDataBinding*) _tmp36_, "localTime");
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp38_ = _tmp37_;
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp39_ = binding;
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp40_ = _tmp39_->variable;
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp41_ = tracker_sparql_variable_get_extra_sql_expression (_tmp40_, "localTime");
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp42_ = _tmp41_;
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_string_append_printf (_tmp35_, "%s AS %s, ", _tmp38_, _tmp42_);
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp42_);
#line 1335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp38_);
#line 13478 "tracker-sparql-pattern.c"
		}
#line 1340 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp43_ = tracker_sparql_pattern_get_context (self);
#line 1340 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp44_ = _tmp43_;
#line 1340 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp45_ = _tmp44_->var_set;
#line 1340 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp46_ = binding;
#line 1340 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp47_ = _tmp46_->variable;
#line 1340 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp48_ = _g_object_ref0 (_tmp47_);
#line 1340 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp49_ = variable_state;
#line 1340 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_hash_table_insert (_tmp45_, _tmp48_, (gpointer) ((gintptr) ((gint) _tmp49_)));
#line 13496 "tracker-sparql-pattern.c"
	}
#line 1342 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp50_ = binding_list;
#line 1342 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp51_ = binding;
#line 1342 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp52_ = _g_object_ref0 (_tmp51_);
#line 1342 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp50_->list = g_list_append (_tmp50_->list, _tmp52_);
#line 1343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp53_ = binding;
#line 1343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp54_ = _tmp53_->variable;
#line 1343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp55_ = _tmp54_->binding;
#line 1343 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp55_ == NULL) {
#line 13514 "tracker-sparql-pattern.c"
		TrackerSparqlVariableBinding* _tmp56_;
		TrackerSparqlVariable* _tmp57_;
		TrackerSparqlVariableBinding* _tmp58_;
		TrackerSparqlVariableBinding* _tmp59_;
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp56_ = binding;
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp57_ = _tmp56_->variable;
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp58_ = binding;
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp59_ = _g_object_ref0 (_tmp58_);
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (_tmp57_->binding);
#line 1344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp57_->binding = _tmp59_;
#line 13531 "tracker-sparql-pattern.c"
	}
#line 1318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (binding_list);
#line 13535 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_parse_object (TrackerSparqlPattern* self, GString* sql, gboolean in_simple_optional, GError** error) {
	glong begin_sql_len = 0L;
	GString* _tmp0_;
	gssize _tmp1_;
	gboolean object_is_var = FALSE;
	gchar* object = NULL;
	GString* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* db_table = NULL;
	gboolean rdftype = FALSE;
	gboolean share_table = FALSE;
	gboolean is_fts_match = FALSE;
	gboolean newtable = FALSE;
	TrackerSparqlDataTable* table = NULL;
	TrackerProperty* prop = NULL;
	TrackerClass* subject_type = NULL;
	TrackerOntologies* ontologies = NULL;
	TrackerDataManager* _tmp5_;
	TrackerOntologies* _tmp6_;
	TrackerOntologies* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp270_;
	gboolean _tmp305_;
	GString* _tmp441_;
	gssize _tmp442_;
	glong _tmp443_;
	GError * _inner_error_ = NULL;
#line 1348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 1348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (sql != NULL);
#line 1349 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = sql;
#line 1349 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = _tmp0_->len;
#line 1349 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	begin_sql_len = (glong) _tmp1_;
#line 1352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = sql;
#line 1352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp4_ = tracker_sparql_pattern_parse_var_or_term (self, _tmp2_, &_tmp3_, &_inner_error_);
#line 1352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	object_is_var = _tmp3_;
#line 1352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	object = _tmp4_;
#line 1352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_propagate_error (error, _inner_error_);
#line 1352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 13593 "tracker-sparql-pattern.c"
		} else {
#line 1352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_clear_error (&_inner_error_);
#line 1352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			return;
#line 13601 "tracker-sparql-pattern.c"
		}
	}
#line 1354 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	db_table = NULL;
#line 1355 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	rdftype = FALSE;
#line 1356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	share_table = TRUE;
#line 1357 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	is_fts_match = FALSE;
#line 1361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	prop = NULL;
#line 1363 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	subject_type = NULL;
#line 1365 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp5_ = self->priv->manager;
#line 1365 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp6_ = tracker_data_manager_get_ontologies (_tmp5_);
#line 1365 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 1365 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	ontologies = _tmp7_;
#line 1367 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp8_ = self->priv->current_predicate_is_var;
#line 1367 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (!_tmp8_) {
#line 13628 "tracker-sparql-pattern.c"
		TrackerOntologies* _tmp9_;
		const gchar* _tmp10_;
		TrackerProperty* _tmp11_;
		TrackerProperty* _tmp12_;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		const gchar* _tmp15_;
		const gchar* _tmp201_;
		const gchar* _tmp202_;
		gboolean _tmp203_;
		gboolean _tmp204_ = FALSE;
		TrackerSparqlDataTable* _tmp205_;
#line 1368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp9_ = ontologies;
#line 1368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp10_ = self->priv->current_predicate;
#line 1368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp11_ = tracker_ontologies_get_property_by_uri (_tmp9_, _tmp10_);
#line 1368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp12_ = _g_object_ref0 (_tmp11_);
#line 1368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (prop);
#line 1368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		prop = _tmp12_;
#line 1370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp15_ = self->priv->current_predicate;
#line 1370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (g_strcmp0 (_tmp15_, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type") == 0) {
#line 13657 "tracker-sparql-pattern.c"
			gboolean _tmp16_;
#line 1371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp16_ = object_is_var;
#line 1371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp14_ = !_tmp16_;
#line 13663 "tracker-sparql-pattern.c"
		} else {
#line 1370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp14_ = FALSE;
#line 13667 "tracker-sparql-pattern.c"
		}
#line 1370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp14_) {
#line 13671 "tracker-sparql-pattern.c"
			const gchar* _tmp17_;
#line 1371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp17_ = self->current_graph;
#line 1371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp13_ = _tmp17_ == NULL;
#line 13677 "tracker-sparql-pattern.c"
		} else {
#line 1370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp13_ = FALSE;
#line 13681 "tracker-sparql-pattern.c"
		}
#line 1370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp13_) {
#line 13685 "tracker-sparql-pattern.c"
			TrackerClass* cl = NULL;
			TrackerOntologies* _tmp18_;
			const gchar* _tmp19_;
			TrackerClass* _tmp20_;
			TrackerClass* _tmp21_;
			TrackerClass* _tmp22_;
			TrackerClass* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			TrackerClass* _tmp32_;
			TrackerClass* _tmp33_;
#line 1374 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			rdftype = TRUE;
#line 1375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp18_ = ontologies;
#line 1375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp19_ = object;
#line 1375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp20_ = tracker_ontologies_get_class_by_uri (_tmp18_, _tmp19_);
#line 1375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp21_ = _g_object_ref0 (_tmp20_);
#line 1375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			cl = _tmp21_;
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp22_ = cl;
#line 1376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp22_ == NULL) {
#line 13714 "tracker-sparql-pattern.c"
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				GError* _tmp26_;
				GError* _tmp27_;
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp23_ = object;
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp24_ = g_strdup_printf ("Unknown class `%s'", _tmp23_);
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp25_ = _tmp24_;
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp26_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNKNOWN_CLASS, _tmp25_);
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp27_ = _tmp26_;
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp25_);
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_inner_error_ = _tmp27_;
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_propagate_error (error, _inner_error_);
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (cl);
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (ontologies);
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (subject_type);
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (prop);
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (table);
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (db_table);
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (object);
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 13754 "tracker-sparql-pattern.c"
				} else {
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (cl);
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (ontologies);
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (subject_type);
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (prop);
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (table);
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (db_table);
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (object);
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_clear_error (&_inner_error_);
#line 1377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 13776 "tracker-sparql-pattern.c"
				}
			}
#line 1379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp28_ = cl;
#line 1379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp29_ = tracker_class_get_name (_tmp28_);
#line 1379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp30_ = _tmp29_;
#line 1379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp31_ = g_strdup (_tmp30_);
#line 1379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (db_table);
#line 1379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			db_table = _tmp31_;
#line 1380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp32_ = cl;
#line 1380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp33_ = _g_object_ref0 (_tmp32_);
#line 1380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (subject_type);
#line 1380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			subject_type = _tmp33_;
#line 1370 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (cl);
#line 13801 "tracker-sparql-pattern.c"
		} else {
			TrackerProperty* _tmp34_;
#line 1381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp34_ = prop;
#line 1381 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp34_ == NULL) {
#line 13808 "tracker-sparql-pattern.c"
				const gchar* _tmp35_;
#line 1382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp35_ = self->priv->current_predicate;
#line 1382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (g_strcmp0 (_tmp35_, "http://www.tracker-project.org/ontologies/fts#match") == 0) {
#line 13814 "tracker-sparql-pattern.c"
					gchar* _tmp36_;
					TrackerSparqlContext* _tmp37_;
					TrackerSparqlContext* _tmp38_;
					const gchar* _tmp39_;
					TrackerSparqlVariable* _tmp40_;
					TrackerSparqlVariable* _tmp41_;
#line 1384 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp36_ = g_strdup ("fts5");
#line 1384 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (db_table);
#line 1384 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					db_table = _tmp36_;
#line 1385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					share_table = FALSE;
#line 1386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					is_fts_match = TRUE;
#line 1387 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp37_ = tracker_sparql_pattern_get_context (self);
#line 1387 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp38_ = _tmp37_;
#line 1387 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp39_ = self->priv->current_subject;
#line 1387 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp40_ = tracker_sparql_context_get_variable (_tmp38_, _tmp39_);
#line 1387 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp41_ = _g_object_ref0 (_tmp40_);
#line 1387 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (self->fts_subject);
#line 1387 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					self->fts_subject = _tmp41_;
#line 13845 "tracker-sparql-pattern.c"
				} else {
					const gchar* _tmp42_;
					gchar* _tmp43_;
					gchar* _tmp44_;
					GError* _tmp45_;
					GError* _tmp46_;
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp42_ = self->priv->current_predicate;
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp43_ = g_strdup_printf ("Unknown property `%s'", _tmp42_);
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp44_ = _tmp43_;
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp45_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNKNOWN_PROPERTY, _tmp44_);
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp46_ = _tmp45_;
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (_tmp44_);
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_inner_error_ = _tmp46_;
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_propagate_error (error, _inner_error_);
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (ontologies);
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (subject_type);
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (prop);
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (table);
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (db_table);
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (object);
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 13884 "tracker-sparql-pattern.c"
					} else {
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (ontologies);
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (subject_type);
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (prop);
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (table);
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (db_table);
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (object);
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_clear_error (&_inner_error_);
#line 1389 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						return;
#line 13904 "tracker-sparql-pattern.c"
					}
				}
			} else {
				gboolean _tmp47_ = FALSE;
				gboolean _tmp48_ = FALSE;
				const gchar* _tmp49_;
				gboolean _tmp87_;
				const gchar* _tmp117_;
				TrackerProperty* _tmp122_;
				gboolean _tmp123_;
				gboolean _tmp124_;
				TrackerProperty* _tmp125_;
				TrackerClass* _tmp126_;
				TrackerClass* _tmp127_;
				TrackerClass* _tmp128_;
				gboolean _tmp129_ = FALSE;
				gboolean _tmp130_;
#line 1392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp49_ = self->priv->current_predicate;
#line 1392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (g_strcmp0 (_tmp49_, "http://www.w3.org/2000/01/rdf-schema#domain") == 0) {
#line 13926 "tracker-sparql-pattern.c"
					gboolean _tmp50_;
#line 1393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp50_ = self->priv->current_subject_is_var;
#line 1393 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp48_ = _tmp50_;
#line 13932 "tracker-sparql-pattern.c"
				} else {
#line 1392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp48_ = FALSE;
#line 13936 "tracker-sparql-pattern.c"
				}
#line 1392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp48_) {
#line 13940 "tracker-sparql-pattern.c"
					gboolean _tmp51_;
#line 1394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp51_ = object_is_var;
#line 1394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp47_ = !_tmp51_;
#line 13946 "tracker-sparql-pattern.c"
				} else {
#line 1392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp47_ = FALSE;
#line 13950 "tracker-sparql-pattern.c"
				}
#line 1392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp47_) {
#line 13954 "tracker-sparql-pattern.c"
					TrackerClass* domain = NULL;
					TrackerOntologies* _tmp52_;
					const gchar* _tmp53_;
					TrackerClass* _tmp54_;
					TrackerClass* _tmp55_;
					TrackerClass* _tmp56_;
					TrackerSparqlPredicateVariable* pv = NULL;
					TrackerSparqlContext* _tmp62_;
					TrackerSparqlContext* _tmp63_;
					GHashTable* _tmp64_;
					TrackerSparqlContext* _tmp65_;
					TrackerSparqlContext* _tmp66_;
					const gchar* _tmp67_;
					TrackerSparqlVariable* _tmp68_;
					gconstpointer _tmp69_;
					TrackerSparqlPredicateVariable* _tmp70_;
					TrackerSparqlPredicateVariable* _tmp71_;
					TrackerSparqlPredicateVariable* _tmp84_;
					TrackerClass* _tmp85_;
					TrackerClass* _tmp86_;
#line 1396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp52_ = ontologies;
#line 1396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp53_ = object;
#line 1396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp54_ = tracker_ontologies_get_class_by_uri (_tmp52_, _tmp53_);
#line 1396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp55_ = _g_object_ref0 (_tmp54_);
#line 1396 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					domain = _tmp55_;
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp56_ = domain;
#line 1397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp56_ == NULL) {
#line 13989 "tracker-sparql-pattern.c"
						const gchar* _tmp57_;
						gchar* _tmp58_;
						gchar* _tmp59_;
						GError* _tmp60_;
						GError* _tmp61_;
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp57_ = object;
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp58_ = g_strdup_printf ("Unknown class `%s'", _tmp57_);
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp59_ = _tmp58_;
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp60_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNKNOWN_CLASS, _tmp59_);
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp61_ = _tmp60_;
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_free0 (_tmp59_);
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_inner_error_ = _tmp61_;
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_propagate_error (error, _inner_error_);
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (domain);
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (ontologies);
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (subject_type);
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (prop);
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (table);
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (db_table);
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (object);
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 14029 "tracker-sparql-pattern.c"
						} else {
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (domain);
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (ontologies);
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (subject_type);
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (prop);
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_object_unref0 (table);
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (db_table);
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							_g_free0 (object);
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							g_clear_error (&_inner_error_);
#line 1398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							return;
#line 14051 "tracker-sparql-pattern.c"
						}
					}
#line 1400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp62_ = tracker_sparql_pattern_get_context (self);
#line 1400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp63_ = _tmp62_;
#line 1400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp64_ = _tmp63_->predicate_variable_map;
#line 1400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp65_ = tracker_sparql_pattern_get_context (self);
#line 1400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp66_ = _tmp65_;
#line 1400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp67_ = self->priv->current_subject;
#line 1400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp68_ = tracker_sparql_context_get_variable (_tmp66_, _tmp67_);
#line 1400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp69_ = g_hash_table_lookup (_tmp64_, _tmp68_);
#line 1400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp70_ = _g_object_ref0 ((TrackerSparqlPredicateVariable*) _tmp69_);
#line 1400 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					pv = _tmp70_;
#line 1401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp71_ = pv;
#line 1401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp71_ == NULL) {
#line 14078 "tracker-sparql-pattern.c"
						TrackerDataManager* _tmp72_;
						TrackerSparqlPredicateVariable* _tmp73_;
						TrackerSparqlContext* _tmp74_;
						TrackerSparqlContext* _tmp75_;
						GHashTable* _tmp76_;
						TrackerSparqlContext* _tmp77_;
						TrackerSparqlContext* _tmp78_;
						const gchar* _tmp79_;
						TrackerSparqlVariable* _tmp80_;
						TrackerSparqlVariable* _tmp81_;
						TrackerSparqlPredicateVariable* _tmp82_;
						TrackerSparqlPredicateVariable* _tmp83_;
#line 1402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp72_ = self->priv->manager;
#line 1402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp73_ = tracker_sparql_predicate_variable_new (_tmp72_);
#line 1402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_g_object_unref0 (pv);
#line 1402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						pv = _tmp73_;
#line 1403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp74_ = tracker_sparql_pattern_get_context (self);
#line 1403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp75_ = _tmp74_;
#line 1403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp76_ = _tmp75_->predicate_variable_map;
#line 1403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp77_ = tracker_sparql_pattern_get_context (self);
#line 1403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp78_ = _tmp77_;
#line 1403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp79_ = self->priv->current_subject;
#line 1403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp80_ = tracker_sparql_context_get_variable (_tmp78_, _tmp79_);
#line 1403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp81_ = _g_object_ref0 (_tmp80_);
#line 1403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp82_ = pv;
#line 1403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp83_ = _g_object_ref0 (_tmp82_);
#line 1403 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						g_hash_table_insert (_tmp76_, _tmp81_, _tmp83_);
#line 14121 "tracker-sparql-pattern.c"
					}
#line 1405 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp84_ = pv;
#line 1405 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp85_ = domain;
#line 1405 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp86_ = _g_object_ref0 (_tmp85_);
#line 1405 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (_tmp84_->domain);
#line 1405 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp84_->domain = _tmp86_;
#line 1392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (pv);
#line 1392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (domain);
#line 14137 "tracker-sparql-pattern.c"
				}
#line 1408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp87_ = self->priv->current_subject_is_var;
#line 1408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp87_) {
#line 14143 "tracker-sparql-pattern.c"
					TrackerSparqlVariable* v = NULL;
					TrackerSparqlContext* _tmp88_;
					TrackerSparqlContext* _tmp89_;
					const gchar* _tmp90_;
					TrackerSparqlVariable* _tmp91_;
					TrackerSparqlVariable* _tmp92_;
					TrackerSparqlVariableBindingList* list = NULL;
					TrackerSparqlPatternTripleContext* _tmp93_;
					GHashTable* _tmp94_;
					TrackerSparqlVariable* _tmp95_;
					gconstpointer _tmp96_;
					TrackerSparqlVariableBindingList* _tmp97_;
					gboolean _tmp98_ = FALSE;
					TrackerSparqlVariableBindingList* _tmp99_;
#line 1410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp88_ = tracker_sparql_pattern_get_context (self);
#line 1410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp89_ = _tmp88_;
#line 1410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp90_ = self->priv->current_subject;
#line 1410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp91_ = tracker_sparql_context_get_variable (_tmp89_, _tmp90_);
#line 1410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp92_ = _g_object_ref0 (_tmp91_);
#line 1410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					v = _tmp92_;
#line 1411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp93_ = self->priv->triple_context;
#line 1411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp94_ = _tmp93_->var_bindings;
#line 1411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp95_ = v;
#line 1411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp96_ = g_hash_table_lookup (_tmp94_, _tmp95_);
#line 1411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp97_ = _g_object_ref0 ((TrackerSparqlVariableBindingList*) _tmp96_);
#line 1411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					list = _tmp97_;
#line 1413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp99_ = list;
#line 1413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp99_ != NULL) {
#line 14186 "tracker-sparql-pattern.c"
						TrackerSparqlVariableBindingList* _tmp100_;
						GList* _tmp101_;
#line 1413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp100_ = list;
#line 1413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp101_ = _tmp100_->list;
#line 1413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp98_ = _tmp101_ != NULL;
#line 14195 "tracker-sparql-pattern.c"
					} else {
#line 1413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp98_ = FALSE;
#line 14199 "tracker-sparql-pattern.c"
					}
#line 1413 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					if (_tmp98_) {
#line 14203 "tracker-sparql-pattern.c"
						gboolean stop = FALSE;
						TrackerProperty* _tmp102_;
						TrackerClass** _tmp103_;
						TrackerClass** _tmp104_;
#line 1414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						stop = FALSE;
#line 1415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp102_ = prop;
#line 1415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
						_tmp104_ = _tmp103_ = tracker_property_get_domain_indexes (_tmp102_);
#line 14214 "tracker-sparql-pattern.c"
						{
							TrackerClass** cl_collection = NULL;
							gint cl_collection_length1 = 0;
							gint _cl_collection_size_ = 0;
							gint cl_it = 0;
#line 1415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							cl_collection = _tmp104_;
#line 1415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							cl_collection_length1 = _vala_array_length (_tmp103_);
#line 1415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
							for (cl_it = 0; cl_it < _vala_array_length (_tmp103_); cl_it = cl_it + 1) {
#line 14226 "tracker-sparql-pattern.c"
								TrackerClass* _tmp105_;
								TrackerClass* cl = NULL;
#line 1415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								_tmp105_ = _g_object_ref0 (cl_collection[cl_it]);
#line 1415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
								cl = _tmp105_;
#line 14233 "tracker-sparql-pattern.c"
								{
									TrackerSparqlVariableBindingList* _tmp106_;
									GList* _tmp107_;
									gboolean _tmp116_;
#line 1416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp106_ = list;
#line 1416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp107_ = _tmp106_->list;
#line 14242 "tracker-sparql-pattern.c"
									{
										GList* b_collection = NULL;
										GList* b_it = NULL;
#line 1416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										b_collection = _tmp107_;
#line 1416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
#line 14250 "tracker-sparql-pattern.c"
											TrackerSparqlVariableBinding* _tmp108_;
											TrackerSparqlVariableBinding* b = NULL;
#line 1416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											_tmp108_ = _g_object_ref0 ((TrackerSparqlVariableBinding*) b_it->data);
#line 1416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
											b = _tmp108_;
#line 14257 "tracker-sparql-pattern.c"
											{
												TrackerSparqlVariableBinding* _tmp109_;
												TrackerClass* _tmp110_;
												TrackerClass* _tmp111_;
#line 1417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_tmp109_ = b;
#line 1417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_tmp110_ = _tmp109_->type;
#line 1417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_tmp111_ = cl;
#line 1417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												if (_tmp110_ == _tmp111_) {
#line 14270 "tracker-sparql-pattern.c"
													TrackerClass* _tmp112_;
													const gchar* _tmp113_;
													const gchar* _tmp114_;
													gchar* _tmp115_;
#line 1418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_tmp112_ = cl;
#line 1418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_tmp113_ = tracker_class_get_name (_tmp112_);
#line 1418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_tmp114_ = _tmp113_;
#line 1418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_tmp115_ = g_strdup (_tmp114_);
#line 1418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_g_free0 (db_table);
#line 1418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													db_table = _tmp115_;
#line 1419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													stop = TRUE;
#line 1420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													_g_object_unref0 (b);
#line 1420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
													break;
#line 14293 "tracker-sparql-pattern.c"
												}
#line 1416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
												_g_object_unref0 (b);
#line 14297 "tracker-sparql-pattern.c"
											}
										}
									}
#line 1423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_tmp116_ = stop;
#line 1423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									if (_tmp116_) {
#line 1424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										_g_object_unref0 (cl);
#line 1424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
										break;
#line 14309 "tracker-sparql-pattern.c"
									}
#line 1415 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
									_g_object_unref0 (cl);
#line 14313 "tracker-sparql-pattern.c"
								}
							}
						}
					}
#line 1408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (list);
#line 1408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (v);
#line 14322 "tracker-sparql-pattern.c"
				}
#line 1430 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp117_ = db_table;
#line 1430 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp117_ == NULL) {
#line 14328 "tracker-sparql-pattern.c"
					TrackerProperty* _tmp118_;
					const gchar* _tmp119_;
					const gchar* _tmp120_;
					gchar* _tmp121_;
#line 1431 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp118_ = prop;
#line 1431 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp119_ = tracker_property_get_table_name (_tmp118_);
#line 1431 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp120_ = _tmp119_;
#line 1431 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp121_ = g_strdup (_tmp120_);
#line 1431 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (db_table);
#line 1431 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					db_table = _tmp121_;
#line 14345 "tracker-sparql-pattern.c"
				}
#line 1433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp122_ = prop;
#line 1433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp123_ = tracker_property_get_multiple_values (_tmp122_);
#line 1433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp124_ = _tmp123_;
#line 1433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp124_) {
#line 1436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					share_table = FALSE;
#line 14357 "tracker-sparql-pattern.c"
				}
#line 1438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp125_ = prop;
#line 1438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp126_ = tracker_property_get_domain (_tmp125_);
#line 1438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp127_ = _tmp126_;
#line 1438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp128_ = _g_object_ref0 (_tmp127_);
#line 1438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (subject_type);
#line 1438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				subject_type = _tmp128_;
#line 1440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp130_ = in_simple_optional;
#line 1440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp130_) {
#line 14375 "tracker-sparql-pattern.c"
					TrackerSparqlContext* _tmp131_;
					TrackerSparqlContext* _tmp132_;
					GHashTable* _tmp133_;
					TrackerSparqlContext* _tmp134_;
					TrackerSparqlContext* _tmp135_;
					const gchar* _tmp136_;
					TrackerSparqlVariable* _tmp137_;
					gconstpointer _tmp138_;
#line 1440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp131_ = tracker_sparql_pattern_get_context (self);
#line 1440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp132_ = _tmp131_;
#line 1440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp133_ = _tmp132_->var_set;
#line 1440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp134_ = tracker_sparql_pattern_get_context (self);
#line 1440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp135_ = _tmp134_;
#line 1440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp136_ = self->priv->current_subject;
#line 1440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp137_ = tracker_sparql_context_get_variable (_tmp135_, _tmp136_);
#line 1440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp138_ = g_hash_table_lookup (_tmp133_, _tmp137_);
#line 1440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp129_ = ((gint) ((gintptr) _tmp138_)) == 0;
#line 14402 "tracker-sparql-pattern.c"
				} else {
#line 1440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp129_ = FALSE;
#line 14406 "tracker-sparql-pattern.c"
				}
#line 1440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp129_) {
#line 14410 "tracker-sparql-pattern.c"
					TrackerSparqlVariableBinding* binding = NULL;
					TrackerSparqlVariableBinding* _tmp139_;
					TrackerSparqlVariableBinding* _tmp140_;
					TrackerSparqlVariableBinding* _tmp141_;
					TrackerSparqlContext* _tmp142_;
					TrackerSparqlContext* _tmp143_;
					const gchar* _tmp144_;
					TrackerSparqlVariable* _tmp145_;
					TrackerSparqlPatternTripleContext* _tmp146_;
					GHashTable* _tmp147_;
					TrackerSparqlVariableBinding* _tmp148_;
					TrackerSparqlVariable* _tmp149_;
					gconstpointer _tmp150_;
					TrackerSparqlVariableBindingList* binding_list = NULL;
					TrackerSparqlVariableBindingList* _tmp151_;
					TrackerSparqlPatternTripleContext* _tmp152_;
					TrackerSparqlVariableBinding* _tmp153_;
					TrackerSparqlVariable* _tmp154_;
					TrackerSparqlVariable* _tmp155_;
					TrackerSparqlPatternTripleContext* _tmp156_;
					GHashTable* _tmp157_;
					TrackerSparqlVariableBinding* _tmp158_;
					TrackerSparqlVariable* _tmp159_;
					TrackerSparqlVariable* _tmp160_;
					TrackerSparqlVariableBindingList* _tmp161_;
					TrackerSparqlVariableBindingList* _tmp162_;
					TrackerSparqlVariableBinding* object_binding = NULL;
					TrackerSparqlPatternTripleContext* _tmp163_;
					GHashTable* _tmp164_;
					TrackerSparqlContext* _tmp165_;
					TrackerSparqlContext* _tmp166_;
					const gchar* _tmp167_;
					TrackerSparqlVariable* _tmp168_;
					gconstpointer _tmp169_;
					GList* _tmp170_;
					gconstpointer _tmp171_;
					TrackerSparqlVariableBinding* _tmp172_;
					GString* _tmp173_;
					const gchar* _tmp174_;
					TrackerProperty* _tmp175_;
					const gchar* _tmp176_;
					const gchar* _tmp177_;
					TrackerSparqlVariableBinding* _tmp178_;
					const gchar* _tmp179_;
					const gchar* _tmp180_;
					TrackerSparqlVariableBinding* _tmp181_;
					TrackerSparqlVariable* _tmp182_;
					const gchar* _tmp183_;
					const gchar* _tmp184_;
					TrackerSparqlContext* _tmp185_;
					TrackerSparqlContext* _tmp186_;
					GHashTable* _tmp187_;
					TrackerSparqlVariableBinding* _tmp188_;
					TrackerSparqlVariable* _tmp189_;
					TrackerSparqlVariable* _tmp190_;
					TrackerSparqlVariableBindingList* _tmp191_;
					TrackerSparqlVariableBinding* _tmp192_;
					TrackerSparqlVariableBinding* _tmp193_;
					TrackerSparqlVariableBinding* _tmp194_;
					TrackerSparqlVariable* _tmp195_;
					TrackerSparqlVariableBinding* _tmp196_;
					TrackerSparqlVariableBinding* _tmp197_;
					TrackerSparqlVariable* _tmp198_;
					TrackerSparqlVariableBinding* _tmp199_;
					TrackerSparqlVariableBinding* _tmp200_;
#line 1443 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp139_ = tracker_sparql_variable_binding_new ();
#line 1443 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					binding = _tmp139_;
#line 1444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp140_ = binding;
#line 1444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp140_)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp141_ = binding;
#line 1445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp142_ = tracker_sparql_pattern_get_context (self);
#line 1445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp143_ = _tmp142_;
#line 1445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp144_ = self->priv->current_subject;
#line 1445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp145_ = tracker_sparql_context_get_variable (_tmp143_, _tmp144_);
#line 1445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp141_->variable = _tmp145_;
#line 1447 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp146_ = self->priv->triple_context;
#line 1447 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp147_ = _tmp146_->var_bindings;
#line 1447 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp148_ = binding;
#line 1447 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp149_ = _tmp148_->variable;
#line 1447 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp150_ = g_hash_table_lookup (_tmp147_, _tmp149_);
#line 1447 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_vala_assert (((TrackerSparqlVariableBindingList*) _tmp150_) == NULL, "triple_context.var_bindings.lookup (binding.variable) == null");
#line 1448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp151_ = tracker_sparql_variable_binding_list_new ();
#line 1448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					binding_list = _tmp151_;
#line 1449 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp152_ = self->priv->triple_context;
#line 1449 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp153_ = binding;
#line 1449 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp154_ = _tmp153_->variable;
#line 1449 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp155_ = _g_object_ref0 (_tmp154_);
#line 1449 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp152_->variables = g_list_append (_tmp152_->variables, _tmp155_);
#line 1450 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp156_ = self->priv->triple_context;
#line 1450 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp157_ = _tmp156_->var_bindings;
#line 1450 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp158_ = binding;
#line 1450 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp159_ = _tmp158_->variable;
#line 1450 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp160_ = _g_object_ref0 (_tmp159_);
#line 1450 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp161_ = binding_list;
#line 1450 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp162_ = _g_object_ref0 (_tmp161_);
#line 1450 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_hash_table_insert (_tmp157_, _tmp160_, _tmp162_);
#line 1453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp163_ = self->priv->triple_context;
#line 1453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp164_ = _tmp163_->var_bindings;
#line 1453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp165_ = tracker_sparql_pattern_get_context (self);
#line 1453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp166_ = _tmp165_;
#line 1453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp167_ = object;
#line 1453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp168_ = tracker_sparql_context_get_variable (_tmp166_, _tmp167_);
#line 1453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp169_ = g_hash_table_lookup (_tmp164_, _tmp168_);
#line 1453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp170_ = ((TrackerSparqlVariableBindingList*) _tmp169_)->list;
#line 1453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp171_ = _tmp170_->data;
#line 1453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp172_ = _g_object_ref0 ((TrackerSparqlVariableBinding*) _tmp171_);
#line 1453 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					object_binding = _tmp172_;
#line 1455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp173_ = sql;
#line 1455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp174_ = db_table;
#line 1455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp175_ = prop;
#line 1455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp176_ = tracker_property_get_name (_tmp175_);
#line 1455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp177_ = _tmp176_;
#line 1455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp178_ = object_binding;
#line 1455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp179_ = tracker_sparql_data_binding_get_sql_expression ((TrackerSparqlDataBinding*) _tmp178_);
#line 1455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp180_ = _tmp179_;
#line 1455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp181_ = binding;
#line 1455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp182_ = _tmp181_->variable;
#line 1455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp183_ = tracker_sparql_variable_get_sql_expression (_tmp182_);
#line 1455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp184_ = _tmp183_;
#line 1455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_string_append_printf (_tmp173_, "(SELECT ID FROM \"%s\" WHERE \"%s\" = %s) AS %s, ", _tmp174_, _tmp177_, _tmp180_, _tmp184_);
#line 1461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp185_ = tracker_sparql_pattern_get_context (self);
#line 1461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp186_ = _tmp185_;
#line 1461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp187_ = _tmp186_->var_set;
#line 1461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp188_ = binding;
#line 1461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp189_ = _tmp188_->variable;
#line 1461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp190_ = _g_object_ref0 (_tmp189_);
#line 1461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					g_hash_table_insert (_tmp187_, _tmp190_, (gpointer) ((gintptr) ((gint) TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL)));
#line 1462 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp191_ = binding_list;
#line 1462 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp192_ = binding;
#line 1462 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp193_ = _g_object_ref0 (_tmp192_);
#line 1462 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp191_->list = g_list_append (_tmp191_->list, _tmp193_);
#line 1464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp194_ = binding;
#line 1464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp195_ = _tmp194_->variable;
#line 1464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp196_ = _tmp195_->binding;
#line 1464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_vala_assert (_tmp196_ == NULL, "binding.variable.binding == null");
#line 1465 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp197_ = binding;
#line 1465 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp198_ = _tmp197_->variable;
#line 1465 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp199_ = binding;
#line 1465 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp200_ = _g_object_ref0 (_tmp199_);
#line 1465 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (_tmp198_->binding);
#line 1465 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp198_->binding = _tmp200_;
#line 1467 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (object_binding);
#line 1467 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (binding_list);
#line 1467 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (binding);
#line 1467 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (ontologies);
#line 1467 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (subject_type);
#line 1467 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (prop);
#line 1467 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_object_unref0 (table);
#line 1467 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (db_table);
#line 1467 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (object);
#line 1467 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					return;
#line 14648 "tracker-sparql-pattern.c"
				}
			}
		}
#line 1470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp201_ = self->priv->current_subject;
#line 1470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp202_ = db_table;
#line 1470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp203_ = share_table;
#line 1470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp205_ = tracker_sparql_pattern_get_table (self, _tmp201_, _tmp202_, _tmp203_, &_tmp204_);
#line 1470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		newtable = _tmp204_;
#line 1470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (table);
#line 1470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		table = _tmp205_;
#line 14666 "tracker-sparql-pattern.c"
	} else {
		TrackerSparqlDataTable* _tmp206_;
		TrackerSparqlDataTable* _tmp207_;
		TrackerSparqlContext* _tmp208_;
		TrackerSparqlContext* _tmp209_;
		GHashTable* _tmp210_;
		TrackerSparqlContext* _tmp211_;
		TrackerSparqlContext* _tmp212_;
		const gchar* _tmp213_;
		TrackerSparqlVariable* _tmp214_;
		gconstpointer _tmp215_;
		TrackerSparqlPredicateVariable* _tmp216_;
		TrackerSparqlDataTable* _tmp217_;
		TrackerSparqlPredicateVariable* _tmp218_;
		gboolean _tmp233_;
		gboolean _tmp238_;
		const gchar* _tmp243_;
		TrackerSparqlDataTable* _tmp246_;
		const gchar* _tmp247_;
		gint _tmp248_;
		gint _tmp249_;
		gchar* _tmp250_;
		gchar* _tmp251_;
		gchar* _tmp252_;
		TrackerSparqlPatternTripleContext* _tmp253_;
		TrackerSparqlDataTable* _tmp254_;
		TrackerSparqlDataTable* _tmp255_;
		TrackerSparqlVariableBinding* binding = NULL;
		TrackerSparqlVariableBinding* _tmp256_;
		TrackerSparqlVariableBinding* _tmp257_;
		TrackerSparqlVariableBinding* _tmp258_;
		TrackerSparqlContext* _tmp259_;
		TrackerSparqlContext* _tmp260_;
		const gchar* _tmp261_;
		TrackerSparqlVariable* _tmp262_;
		TrackerSparqlVariableBinding* _tmp263_;
		TrackerSparqlDataTable* _tmp264_;
		TrackerSparqlDataTable* _tmp265_;
		TrackerSparqlVariableBinding* _tmp266_;
		gchar* _tmp267_;
		GString* _tmp268_;
		TrackerSparqlVariableBinding* _tmp269_;
#line 1473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		newtable = TRUE;
#line 1474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp206_ = tracker_sparql_data_table_new ();
#line 1474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (table);
#line 1474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		table = _tmp206_;
#line 1475 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp207_ = table;
#line 1475 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp208_ = tracker_sparql_pattern_get_context (self);
#line 1475 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp209_ = _tmp208_;
#line 1475 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp210_ = _tmp209_->predicate_variable_map;
#line 1475 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp211_ = tracker_sparql_pattern_get_context (self);
#line 1475 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp212_ = _tmp211_;
#line 1475 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp213_ = self->priv->current_predicate;
#line 1475 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp214_ = tracker_sparql_context_get_variable (_tmp212_, _tmp213_);
#line 1475 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp215_ = g_hash_table_lookup (_tmp210_, _tmp214_);
#line 1475 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp216_ = _g_object_ref0 ((TrackerSparqlPredicateVariable*) _tmp215_);
#line 1475 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (_tmp207_->predicate_variable);
#line 1475 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp207_->predicate_variable = _tmp216_;
#line 1476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp217_ = table;
#line 1476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp218_ = _tmp217_->predicate_variable;
#line 1476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp218_ == NULL) {
#line 14747 "tracker-sparql-pattern.c"
			TrackerSparqlDataTable* _tmp219_;
			TrackerDataManager* _tmp220_;
			TrackerSparqlPredicateVariable* _tmp221_;
			TrackerSparqlContext* _tmp222_;
			TrackerSparqlContext* _tmp223_;
			GHashTable* _tmp224_;
			TrackerSparqlContext* _tmp225_;
			TrackerSparqlContext* _tmp226_;
			const gchar* _tmp227_;
			TrackerSparqlVariable* _tmp228_;
			TrackerSparqlVariable* _tmp229_;
			TrackerSparqlDataTable* _tmp230_;
			TrackerSparqlPredicateVariable* _tmp231_;
			TrackerSparqlPredicateVariable* _tmp232_;
#line 1477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp219_ = table;
#line 1477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp220_ = self->priv->manager;
#line 1477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp221_ = tracker_sparql_predicate_variable_new (_tmp220_);
#line 1477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (_tmp219_->predicate_variable);
#line 1477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp219_->predicate_variable = _tmp221_;
#line 1478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp222_ = tracker_sparql_pattern_get_context (self);
#line 1478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp223_ = _tmp222_;
#line 1478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp224_ = _tmp223_->predicate_variable_map;
#line 1478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp225_ = tracker_sparql_pattern_get_context (self);
#line 1478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp226_ = _tmp225_;
#line 1478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp227_ = self->priv->current_predicate;
#line 1478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp228_ = tracker_sparql_context_get_variable (_tmp226_, _tmp227_);
#line 1478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp229_ = _g_object_ref0 (_tmp228_);
#line 1478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp230_ = table;
#line 1478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp231_ = _tmp230_->predicate_variable;
#line 1478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp232_ = _g_object_ref0 (_tmp231_);
#line 1478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			g_hash_table_insert (_tmp224_, _tmp229_, _tmp232_);
#line 14796 "tracker-sparql-pattern.c"
		}
#line 1480 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp233_ = self->priv->current_subject_is_var;
#line 1480 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp233_) {
#line 14802 "tracker-sparql-pattern.c"
			TrackerSparqlDataTable* _tmp234_;
			TrackerSparqlPredicateVariable* _tmp235_;
			const gchar* _tmp236_;
			gchar* _tmp237_;
#line 1482 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp234_ = table;
#line 1482 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp235_ = _tmp234_->predicate_variable;
#line 1482 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp236_ = self->priv->current_subject;
#line 1482 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp237_ = g_strdup (_tmp236_);
#line 1482 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp235_->subject);
#line 1482 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp235_->subject = _tmp237_;
#line 14819 "tracker-sparql-pattern.c"
		}
#line 1484 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp238_ = object_is_var;
#line 1484 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (!_tmp238_) {
#line 14825 "tracker-sparql-pattern.c"
			TrackerSparqlDataTable* _tmp239_;
			TrackerSparqlPredicateVariable* _tmp240_;
			const gchar* _tmp241_;
			gchar* _tmp242_;
#line 1486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp239_ = table;
#line 1486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp240_ = _tmp239_->predicate_variable;
#line 1486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp241_ = object;
#line 1486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp242_ = g_strdup (_tmp241_);
#line 1486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp240_->object);
#line 1486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp240_->object = _tmp242_;
#line 14842 "tracker-sparql-pattern.c"
		}
#line 1488 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp243_ = self->current_graph;
#line 1488 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp243_ != NULL) {
#line 14848 "tracker-sparql-pattern.c"
			TrackerSparqlDataTable* _tmp244_;
			TrackerSparqlPredicateVariable* _tmp245_;
#line 1489 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp244_ = table;
#line 1489 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp245_ = _tmp244_->predicate_variable;
#line 1489 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp245_->return_graph = TRUE;
#line 14857 "tracker-sparql-pattern.c"
		}
#line 1491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp246_ = table;
#line 1491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp247_ = self->priv->current_predicate;
#line 1491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp248_ = self->priv->counter;
#line 1491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->counter = _tmp248_ + 1;
#line 1491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp249_ = self->priv->counter;
#line 1491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp250_ = g_strdup_printf ("%i", _tmp249_);
#line 1491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp251_ = _tmp250_;
#line 1491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp252_ = g_strconcat (_tmp247_, _tmp251_, NULL);
#line 1491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp246_->sql_query_tablename);
#line 1491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp246_->sql_query_tablename = _tmp252_;
#line 1491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp251_);
#line 1492 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp253_ = self->priv->triple_context;
#line 1492 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp254_ = table;
#line 1492 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp255_ = _g_object_ref0 (_tmp254_);
#line 1492 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp253_->tables = g_list_append (_tmp253_->tables, _tmp255_);
#line 1495 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp256_ = tracker_sparql_variable_binding_new ();
#line 1495 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		binding = _tmp256_;
#line 1496 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp257_ = binding;
#line 1496 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		((TrackerSparqlDataBinding*) _tmp257_)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1497 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp258_ = binding;
#line 1497 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp259_ = tracker_sparql_pattern_get_context (self);
#line 1497 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp260_ = _tmp259_;
#line 1497 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp261_ = self->priv->current_predicate;
#line 1497 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp262_ = tracker_sparql_context_get_variable (_tmp260_, _tmp261_);
#line 1497 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp258_->variable = _tmp262_;
#line 1498 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp263_ = binding;
#line 1498 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp264_ = table;
#line 1498 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp265_ = _g_object_ref0 (_tmp264_);
#line 1498 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp263_)->table);
#line 1498 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		((TrackerSparqlDataBinding*) _tmp263_)->table = _tmp265_;
#line 1499 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp266_ = binding;
#line 1499 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp267_ = g_strdup ("predicate");
#line 1499 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (((TrackerSparqlDataBinding*) _tmp266_)->sql_db_column_name);
#line 1499 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		((TrackerSparqlDataBinding*) _tmp266_)->sql_db_column_name = _tmp267_;
#line 1501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp268_ = sql;
#line 1501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp269_ = binding;
#line 1501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		tracker_sparql_pattern_add_variable_binding (self, _tmp268_, _tmp269_, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
#line 1367 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (binding);
#line 14935 "tracker-sparql-pattern.c"
	}
#line 1504 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp270_ = newtable;
#line 1504 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp270_) {
#line 14941 "tracker-sparql-pattern.c"
		gboolean _tmp271_;
#line 1505 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp271_ = self->priv->current_subject_is_var;
#line 1505 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp271_) {
#line 14947 "tracker-sparql-pattern.c"
			TrackerSparqlVariableBinding* binding = NULL;
			TrackerSparqlVariableBinding* _tmp272_;
			TrackerSparqlVariableBinding* _tmp273_;
			TrackerSparqlVariableBinding* _tmp274_;
			TrackerSparqlContext* _tmp275_;
			TrackerSparqlContext* _tmp276_;
			const gchar* _tmp277_;
			TrackerSparqlVariable* _tmp278_;
			TrackerSparqlVariableBinding* _tmp279_;
			TrackerSparqlDataTable* _tmp280_;
			TrackerSparqlDataTable* _tmp281_;
			TrackerSparqlVariableBinding* _tmp282_;
			TrackerClass* _tmp283_;
			TrackerClass* _tmp284_;
			gboolean _tmp285_;
			GString* _tmp290_;
			TrackerSparqlVariableBinding* _tmp291_;
#line 1506 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp272_ = tracker_sparql_variable_binding_new ();
#line 1506 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			binding = _tmp272_;
#line 1507 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp273_ = binding;
#line 1507 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp273_)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp274_ = binding;
#line 1508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp275_ = tracker_sparql_pattern_get_context (self);
#line 1508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp276_ = _tmp275_;
#line 1508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp277_ = self->priv->current_subject;
#line 1508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp278_ = tracker_sparql_context_get_variable (_tmp276_, _tmp277_);
#line 1508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp274_->variable = _tmp278_;
#line 1509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp279_ = binding;
#line 1509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp280_ = table;
#line 1509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp281_ = _g_object_ref0 (_tmp280_);
#line 1509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp279_)->table);
#line 1509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp279_)->table = _tmp281_;
#line 1510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp282_ = binding;
#line 1510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp283_ = subject_type;
#line 1510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp284_ = _g_object_ref0 (_tmp283_);
#line 1510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (_tmp282_->type);
#line 1510 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp282_->type = _tmp284_;
#line 1511 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp285_ = is_fts_match;
#line 1511 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp285_) {
#line 15009 "tracker-sparql-pattern.c"
				TrackerSparqlVariableBinding* _tmp286_;
				gchar* _tmp287_;
#line 1512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp286_ = binding;
#line 1512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp287_ = g_strdup ("rowid");
#line 1512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (((TrackerSparqlDataBinding*) _tmp286_)->sql_db_column_name);
#line 1512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp286_)->sql_db_column_name = _tmp287_;
#line 15020 "tracker-sparql-pattern.c"
			} else {
				TrackerSparqlVariableBinding* _tmp288_;
				gchar* _tmp289_;
#line 1514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp288_ = binding;
#line 1514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp289_ = g_strdup ("ID");
#line 1514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (((TrackerSparqlDataBinding*) _tmp288_)->sql_db_column_name);
#line 1514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp288_)->sql_db_column_name = _tmp289_;
#line 15032 "tracker-sparql-pattern.c"
			}
#line 1517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp290_ = sql;
#line 1517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp291_ = binding;
#line 1517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_add_variable_binding (self, _tmp290_, _tmp291_, TRACKER_SPARQL_VARIABLE_STATE_BOUND);
#line 1505 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (binding);
#line 15042 "tracker-sparql-pattern.c"
		} else {
			TrackerSparqlLiteralBinding* binding = NULL;
			TrackerSparqlLiteralBinding* _tmp292_;
			TrackerSparqlLiteralBinding* _tmp293_;
			TrackerSparqlLiteralBinding* _tmp294_;
			const gchar* _tmp295_;
			gchar* _tmp296_;
			TrackerSparqlLiteralBinding* _tmp297_;
			TrackerSparqlDataTable* _tmp298_;
			TrackerSparqlDataTable* _tmp299_;
			TrackerSparqlLiteralBinding* _tmp300_;
			gchar* _tmp301_;
			TrackerSparqlPatternTripleContext* _tmp302_;
			TrackerSparqlLiteralBinding* _tmp303_;
			TrackerSparqlLiteralBinding* _tmp304_;
#line 1519 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp292_ = tracker_sparql_literal_binding_new ();
#line 1519 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			binding = _tmp292_;
#line 1520 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp293_ = binding;
#line 1520 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp293_)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp294_ = binding;
#line 1521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp295_ = self->priv->current_subject;
#line 1521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp296_ = g_strdup (_tmp295_);
#line 1521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (_tmp294_->literal);
#line 1521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp294_->literal = _tmp296_;
#line 1523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp297_ = binding;
#line 1523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp298_ = table;
#line 1523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp299_ = _g_object_ref0 (_tmp298_);
#line 1523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp297_)->table);
#line 1523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp297_)->table = _tmp299_;
#line 1524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp300_ = binding;
#line 1524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp301_ = g_strdup ("ID");
#line 1524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_free0 (((TrackerSparqlDataBinding*) _tmp300_)->sql_db_column_name);
#line 1524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp300_)->sql_db_column_name = _tmp301_;
#line 1525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp302_ = self->priv->triple_context;
#line 1525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp303_ = binding;
#line 1525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp304_ = _g_object_ref0 (_tmp303_);
#line 1525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp302_->bindings = g_list_append (_tmp302_->bindings, _tmp304_);
#line 1505 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (binding);
#line 15104 "tracker-sparql-pattern.c"
		}
	}
#line 1529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp305_ = rdftype;
#line 1529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (!_tmp305_) {
#line 15111 "tracker-sparql-pattern.c"
		gboolean _tmp306_;
		const gchar* _tmp395_;
#line 1530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp306_ = object_is_var;
#line 1530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp306_) {
#line 15118 "tracker-sparql-pattern.c"
			TrackerSparqlVariableBinding* binding = NULL;
			TrackerSparqlVariableBinding* _tmp307_;
			TrackerSparqlVariableBinding* _tmp308_;
			TrackerSparqlContext* _tmp309_;
			TrackerSparqlContext* _tmp310_;
			const gchar* _tmp311_;
			TrackerSparqlVariable* _tmp312_;
			TrackerSparqlVariableBinding* _tmp313_;
			TrackerSparqlDataTable* _tmp314_;
			TrackerSparqlDataTable* _tmp315_;
			TrackerProperty* _tmp316_;
			TrackerSparqlVariableState state = 0;
			gboolean _tmp341_;
			GString* _tmp342_;
			TrackerSparqlVariableBinding* _tmp343_;
			TrackerSparqlVariableState _tmp344_;
#line 1531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp307_ = tracker_sparql_variable_binding_new ();
#line 1531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			binding = _tmp307_;
#line 1532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp308_ = binding;
#line 1532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp309_ = tracker_sparql_pattern_get_context (self);
#line 1532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp310_ = _tmp309_;
#line 1532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp311_ = object;
#line 1532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp312_ = tracker_sparql_context_get_variable (_tmp310_, _tmp311_);
#line 1532 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp308_->variable = _tmp312_;
#line 1533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp313_ = binding;
#line 1533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp314_ = table;
#line 1533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp315_ = _g_object_ref0 (_tmp314_);
#line 1533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp313_)->table);
#line 1533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			((TrackerSparqlDataBinding*) _tmp313_)->table = _tmp315_;
#line 1534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp316_ = prop;
#line 1534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp316_ != NULL) {
#line 15165 "tracker-sparql-pattern.c"
				TrackerSparqlVariableBinding* _tmp317_;
				TrackerProperty* _tmp318_;
				TrackerClass* _tmp319_;
				TrackerClass* _tmp320_;
				TrackerClass* _tmp321_;
				TrackerSparqlVariableBinding* _tmp322_;
				TrackerProperty* _tmp323_;
				TrackerPropertyType _tmp324_;
				TrackerPropertyType _tmp325_;
				TrackerSparqlVariableBinding* _tmp326_;
				TrackerProperty* _tmp327_;
				const gchar* _tmp328_;
				const gchar* _tmp329_;
				gchar* _tmp330_;
				TrackerProperty* _tmp331_;
				gboolean _tmp332_;
				gboolean _tmp333_;
#line 1536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp317_ = binding;
#line 1536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp318_ = prop;
#line 1536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp319_ = tracker_property_get_range (_tmp318_);
#line 1536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp320_ = _tmp319_;
#line 1536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp321_ = _g_object_ref0 (_tmp320_);
#line 1536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (_tmp317_->type);
#line 1536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp317_->type = _tmp321_;
#line 1538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp322_ = binding;
#line 1538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp323_ = prop;
#line 1538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp324_ = tracker_property_get_data_type (_tmp323_);
#line 1538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp325_ = _tmp324_;
#line 1538 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp322_)->data_type = _tmp325_;
#line 1539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp326_ = binding;
#line 1539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp327_ = prop;
#line 1539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp328_ = tracker_property_get_name (_tmp327_);
#line 1539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp329_ = _tmp328_;
#line 1539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp330_ = g_strdup (_tmp329_);
#line 1539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (((TrackerSparqlDataBinding*) _tmp326_)->sql_db_column_name);
#line 1539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp326_)->sql_db_column_name = _tmp330_;
#line 1540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp331_ = prop;
#line 1540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp332_ = tracker_property_get_multiple_values (_tmp331_);
#line 1540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp333_ = _tmp332_;
#line 1540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (!_tmp333_) {
#line 15229 "tracker-sparql-pattern.c"
					TrackerSparqlVariableBinding* _tmp334_;
					TrackerSparqlVariableBinding* _tmp335_;
					gboolean _tmp336_;
#line 1543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp334_ = binding;
#line 1543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp334_->maybe_null = TRUE;
#line 1544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp335_ = binding;
#line 1544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp336_ = in_simple_optional;
#line 1544 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp335_->in_simple_optional = _tmp336_;
#line 15243 "tracker-sparql-pattern.c"
				}
			} else {
				TrackerSparqlVariableBinding* _tmp337_;
				TrackerSparqlVariableBinding* _tmp338_;
				gchar* _tmp339_;
				TrackerSparqlVariableBinding* _tmp340_;
#line 1548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp337_ = binding;
#line 1548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp337_)->data_type = TRACKER_PROPERTY_TYPE_STRING;
#line 1549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp338_ = binding;
#line 1549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp339_ = g_strdup ("object");
#line 1549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (((TrackerSparqlDataBinding*) _tmp338_)->sql_db_column_name);
#line 1549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp338_)->sql_db_column_name = _tmp339_;
#line 1550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp340_ = binding;
#line 1550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp340_->maybe_null = TRUE;
#line 15266 "tracker-sparql-pattern.c"
			}
#line 1554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp341_ = in_simple_optional;
#line 1554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp341_) {
#line 1555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				state = TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL;
#line 15274 "tracker-sparql-pattern.c"
			} else {
#line 1557 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				state = TRACKER_SPARQL_VARIABLE_STATE_BOUND;
#line 15278 "tracker-sparql-pattern.c"
			}
#line 1560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp342_ = sql;
#line 1560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp343_ = binding;
#line 1560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp344_ = state;
#line 1560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			tracker_sparql_pattern_add_variable_binding (self, _tmp342_, _tmp343_, _tmp344_);
#line 1530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_g_object_unref0 (binding);
#line 15290 "tracker-sparql-pattern.c"
		} else {
			gboolean _tmp345_;
#line 1561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp345_ = is_fts_match;
#line 1561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp345_) {
#line 15297 "tracker-sparql-pattern.c"
				TrackerSparqlLiteralBinding* binding = NULL;
				TrackerSparqlLiteralBinding* _tmp346_;
				TrackerSparqlLiteralBinding* _tmp347_;
				TrackerSparqlLiteralBinding* _tmp348_;
				const gchar* _tmp349_;
				gchar* _tmp350_;
				TrackerSparqlLiteralBinding* _tmp351_;
				TrackerSparqlDataTable* _tmp352_;
				TrackerSparqlDataTable* _tmp353_;
				TrackerSparqlLiteralBinding* _tmp354_;
				gchar* _tmp355_;
				TrackerSparqlPatternTripleContext* _tmp356_;
				TrackerSparqlLiteralBinding* _tmp357_;
				TrackerSparqlLiteralBinding* _tmp358_;
				GString* _tmp359_;
				TrackerSparqlLiteralBinding* _tmp360_;
				TrackerSparqlDataTable* _tmp361_;
				const gchar* _tmp362_;
				GString* _tmp363_;
				TrackerSparqlLiteralBinding* _tmp364_;
				TrackerSparqlDataTable* _tmp365_;
				const gchar* _tmp366_;
				TrackerSparqlContext* _tmp367_;
				TrackerSparqlContext* _tmp368_;
				const gchar* _tmp369_;
				TrackerSparqlVariable* _tmp370_;
				const gchar* _tmp371_;
				const gchar* _tmp372_;
#line 1562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp346_ = tracker_sparql_literal_binding_new ();
#line 1562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				binding = _tmp346_;
#line 1563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp347_ = binding;
#line 1563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp347_->is_fts_match = TRUE;
#line 1564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp348_ = binding;
#line 1564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp349_ = object;
#line 1564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp350_ = g_strdup (_tmp349_);
#line 1564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp348_->literal);
#line 1564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp348_->literal = _tmp350_;
#line 1566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp351_ = binding;
#line 1566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp352_ = table;
#line 1566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp353_ = _g_object_ref0 (_tmp352_);
#line 1566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp351_)->table);
#line 1566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp351_)->table = _tmp353_;
#line 1567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp354_ = binding;
#line 1567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp355_ = g_strdup ("fts5");
#line 1567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (((TrackerSparqlDataBinding*) _tmp354_)->sql_db_column_name);
#line 1567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp354_)->sql_db_column_name = _tmp355_;
#line 1568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp356_ = self->priv->triple_context;
#line 1568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp357_ = binding;
#line 1568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp358_ = _g_object_ref0 (_tmp357_);
#line 1568 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp356_->bindings = g_list_append (_tmp356_->bindings, _tmp358_);
#line 1570 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp359_ = sql;
#line 1570 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp360_ = binding;
#line 1570 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp361_ = ((TrackerSparqlDataBinding*) _tmp360_)->table;
#line 1570 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp362_ = _tmp361_->sql_query_tablename;
#line 1570 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append_printf (_tmp359_, "\"%s\".\"rowid\" AS \"ID\", ", _tmp362_);
#line 1572 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp363_ = sql;
#line 1572 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp364_ = binding;
#line 1572 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp365_ = ((TrackerSparqlDataBinding*) _tmp364_)->table;
#line 1572 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp366_ = _tmp365_->sql_query_tablename;
#line 1572 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp367_ = tracker_sparql_pattern_get_context (self);
#line 1572 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp368_ = _tmp367_;
#line 1572 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp369_ = self->priv->current_subject;
#line 1572 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp370_ = tracker_sparql_context_get_variable (_tmp368_, _tmp369_);
#line 1572 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp371_ = tracker_sparql_variable_get_name (_tmp370_);
#line 1572 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp372_ = _tmp371_;
#line 1572 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				g_string_append_printf (_tmp363_, "\"%s\".\"rank\" AS \"%s_u_rank\", ", _tmp366_, _tmp372_);
#line 1561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding);
#line 15404 "tracker-sparql-pattern.c"
			} else {
				TrackerSparqlLiteralBinding* binding = NULL;
				TrackerSparqlLiteralBinding* _tmp373_;
				TrackerSparqlLiteralBinding* _tmp374_;
				const gchar* _tmp375_;
				gchar* _tmp376_;
				TrackerSparqlLiteralBinding* _tmp377_;
				TrackerSparqlDataTable* _tmp378_;
				TrackerSparqlDataTable* _tmp379_;
				TrackerProperty* _tmp380_;
				TrackerSparqlPatternTripleContext* _tmp392_;
				TrackerSparqlLiteralBinding* _tmp393_;
				TrackerSparqlLiteralBinding* _tmp394_;
#line 1576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp373_ = tracker_sparql_literal_binding_new ();
#line 1576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				binding = _tmp373_;
#line 1577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp374_ = binding;
#line 1577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp375_ = object;
#line 1577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp376_ = g_strdup (_tmp375_);
#line 1577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp374_->literal);
#line 1577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp374_->literal = _tmp376_;
#line 1579 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp377_ = binding;
#line 1579 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp378_ = table;
#line 1579 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp379_ = _g_object_ref0 (_tmp378_);
#line 1579 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp377_)->table);
#line 1579 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp377_)->table = _tmp379_;
#line 1580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp380_ = prop;
#line 1580 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp380_ != NULL) {
#line 15446 "tracker-sparql-pattern.c"
					TrackerSparqlLiteralBinding* _tmp381_;
					TrackerProperty* _tmp382_;
					TrackerPropertyType _tmp383_;
					TrackerPropertyType _tmp384_;
					TrackerSparqlLiteralBinding* _tmp385_;
					TrackerProperty* _tmp386_;
					const gchar* _tmp387_;
					const gchar* _tmp388_;
					gchar* _tmp389_;
#line 1581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp381_ = binding;
#line 1581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp382_ = prop;
#line 1581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp383_ = tracker_property_get_data_type (_tmp382_);
#line 1581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp384_ = _tmp383_;
#line 1581 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp381_)->data_type = _tmp384_;
#line 1582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp385_ = binding;
#line 1582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp386_ = prop;
#line 1582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp387_ = tracker_property_get_name (_tmp386_);
#line 1582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp388_ = _tmp387_;
#line 1582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp389_ = g_strdup (_tmp388_);
#line 1582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (((TrackerSparqlDataBinding*) _tmp385_)->sql_db_column_name);
#line 1582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp385_)->sql_db_column_name = _tmp389_;
#line 15480 "tracker-sparql-pattern.c"
				} else {
					TrackerSparqlLiteralBinding* _tmp390_;
					gchar* _tmp391_;
#line 1585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp390_ = binding;
#line 1585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp391_ = g_strdup ("object");
#line 1585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (((TrackerSparqlDataBinding*) _tmp390_)->sql_db_column_name);
#line 1585 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp390_)->sql_db_column_name = _tmp391_;
#line 15492 "tracker-sparql-pattern.c"
				}
#line 1587 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp392_ = self->priv->triple_context;
#line 1587 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp393_ = binding;
#line 1587 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp394_ = _g_object_ref0 (_tmp393_);
#line 1587 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp392_->bindings = g_list_append (_tmp392_->bindings, _tmp394_);
#line 1561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding);
#line 15504 "tracker-sparql-pattern.c"
			}
		}
#line 1590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp395_ = self->current_graph;
#line 1590 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		if (_tmp395_ != NULL) {
#line 15511 "tracker-sparql-pattern.c"
			gboolean _tmp396_;
#line 1591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			_tmp396_ = self->priv->current_graph_is_var;
#line 1591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
			if (_tmp396_) {
#line 15517 "tracker-sparql-pattern.c"
				TrackerSparqlVariableBinding* binding = NULL;
				TrackerSparqlVariableBinding* _tmp397_;
				TrackerSparqlVariableBinding* _tmp398_;
				TrackerSparqlContext* _tmp399_;
				TrackerSparqlContext* _tmp400_;
				const gchar* _tmp401_;
				TrackerSparqlVariable* _tmp402_;
				TrackerSparqlVariableBinding* _tmp403_;
				TrackerSparqlDataTable* _tmp404_;
				TrackerSparqlDataTable* _tmp405_;
				TrackerSparqlVariableBinding* _tmp406_;
				TrackerProperty* _tmp407_;
				TrackerSparqlVariableBinding* _tmp415_;
				TrackerSparqlVariableBinding* _tmp416_;
				gboolean _tmp417_;
				TrackerSparqlVariableState state = 0;
				gboolean _tmp418_;
				GString* _tmp419_;
				TrackerSparqlVariableBinding* _tmp420_;
				TrackerSparqlVariableState _tmp421_;
#line 1592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp397_ = tracker_sparql_variable_binding_new ();
#line 1592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				binding = _tmp397_;
#line 1593 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp398_ = binding;
#line 1593 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp399_ = tracker_sparql_pattern_get_context (self);
#line 1593 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp400_ = _tmp399_;
#line 1593 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp401_ = self->current_graph;
#line 1593 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp402_ = tracker_sparql_context_get_variable (_tmp400_, _tmp401_);
#line 1593 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp398_->variable = _tmp402_;
#line 1594 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp403_ = binding;
#line 1594 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp404_ = table;
#line 1594 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp405_ = _g_object_ref0 (_tmp404_);
#line 1594 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp403_)->table);
#line 1594 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp403_)->table = _tmp405_;
#line 1595 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp406_ = binding;
#line 1595 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp406_)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp407_ = prop;
#line 1597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp407_ != NULL) {
#line 15572 "tracker-sparql-pattern.c"
					TrackerSparqlVariableBinding* _tmp408_;
					TrackerProperty* _tmp409_;
					const gchar* _tmp410_;
					const gchar* _tmp411_;
					gchar* _tmp412_;
#line 1598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp408_ = binding;
#line 1598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp409_ = prop;
#line 1598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp410_ = tracker_property_get_name (_tmp409_);
#line 1598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp411_ = _tmp410_;
#line 1598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp412_ = g_strconcat (_tmp411_, ":graph", NULL);
#line 1598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (((TrackerSparqlDataBinding*) _tmp408_)->sql_db_column_name);
#line 1598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp408_)->sql_db_column_name = _tmp412_;
#line 15592 "tracker-sparql-pattern.c"
				} else {
					TrackerSparqlVariableBinding* _tmp413_;
					gchar* _tmp414_;
#line 1601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp413_ = binding;
#line 1601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp414_ = g_strdup ("graph");
#line 1601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (((TrackerSparqlDataBinding*) _tmp413_)->sql_db_column_name);
#line 1601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp413_)->sql_db_column_name = _tmp414_;
#line 15604 "tracker-sparql-pattern.c"
				}
#line 1604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp415_ = binding;
#line 1604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp415_->maybe_null = TRUE;
#line 1605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp416_ = binding;
#line 1605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp417_ = in_simple_optional;
#line 1605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp416_->in_simple_optional = _tmp417_;
#line 1608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp418_ = in_simple_optional;
#line 1608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp418_) {
#line 1609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					state = TRACKER_SPARQL_VARIABLE_STATE_OPTIONAL;
#line 15622 "tracker-sparql-pattern.c"
				} else {
#line 1611 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					state = TRACKER_SPARQL_VARIABLE_STATE_BOUND;
#line 15626 "tracker-sparql-pattern.c"
				}
#line 1614 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp419_ = sql;
#line 1614 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp420_ = binding;
#line 1614 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp421_ = state;
#line 1614 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				tracker_sparql_pattern_add_variable_binding (self, _tmp419_, _tmp420_, _tmp421_);
#line 1591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding);
#line 15638 "tracker-sparql-pattern.c"
			} else {
				TrackerSparqlLiteralBinding* binding = NULL;
				TrackerSparqlLiteralBinding* _tmp422_;
				TrackerSparqlLiteralBinding* _tmp423_;
				const gchar* _tmp424_;
				gchar* _tmp425_;
				TrackerSparqlLiteralBinding* _tmp426_;
				TrackerSparqlDataTable* _tmp427_;
				TrackerSparqlDataTable* _tmp428_;
				TrackerSparqlLiteralBinding* _tmp429_;
				TrackerProperty* _tmp430_;
				TrackerSparqlPatternTripleContext* _tmp438_;
				TrackerSparqlLiteralBinding* _tmp439_;
				TrackerSparqlLiteralBinding* _tmp440_;
#line 1616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp422_ = tracker_sparql_literal_binding_new ();
#line 1616 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				binding = _tmp422_;
#line 1617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp423_ = binding;
#line 1617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp424_ = self->current_graph;
#line 1617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp425_ = g_strdup (_tmp424_);
#line 1617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_free0 (_tmp423_->literal);
#line 1617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp423_->literal = _tmp425_;
#line 1618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp426_ = binding;
#line 1618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp427_ = table;
#line 1618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp428_ = _g_object_ref0 (_tmp427_);
#line 1618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (((TrackerSparqlDataBinding*) _tmp426_)->table);
#line 1618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp426_)->table = _tmp428_;
#line 1619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp429_ = binding;
#line 1619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				((TrackerSparqlDataBinding*) _tmp429_)->data_type = TRACKER_PROPERTY_TYPE_RESOURCE;
#line 1621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp430_ = prop;
#line 1621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				if (_tmp430_ != NULL) {
#line 15685 "tracker-sparql-pattern.c"
					TrackerSparqlLiteralBinding* _tmp431_;
					TrackerProperty* _tmp432_;
					const gchar* _tmp433_;
					const gchar* _tmp434_;
					gchar* _tmp435_;
#line 1622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp431_ = binding;
#line 1622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp432_ = prop;
#line 1622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp433_ = tracker_property_get_name (_tmp432_);
#line 1622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp434_ = _tmp433_;
#line 1622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp435_ = g_strconcat (_tmp434_, ":graph", NULL);
#line 1622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (((TrackerSparqlDataBinding*) _tmp431_)->sql_db_column_name);
#line 1622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp431_)->sql_db_column_name = _tmp435_;
#line 15705 "tracker-sparql-pattern.c"
				} else {
					TrackerSparqlLiteralBinding* _tmp436_;
					gchar* _tmp437_;
#line 1625 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp436_ = binding;
#line 1625 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_tmp437_ = g_strdup ("graph");
#line 1625 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					_g_free0 (((TrackerSparqlDataBinding*) _tmp436_)->sql_db_column_name);
#line 1625 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
					((TrackerSparqlDataBinding*) _tmp436_)->sql_db_column_name = _tmp437_;
#line 15717 "tracker-sparql-pattern.c"
				}
#line 1628 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp438_ = self->priv->triple_context;
#line 1628 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp439_ = binding;
#line 1628 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp440_ = _g_object_ref0 (_tmp439_);
#line 1628 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_tmp438_->bindings = g_list_append (_tmp438_->bindings, _tmp440_);
#line 1591 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
				_g_object_unref0 (binding);
#line 15729 "tracker-sparql-pattern.c"
			}
		}
	}
#line 1633 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp441_ = sql;
#line 1633 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp442_ = _tmp441_->len;
#line 1633 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp443_ = begin_sql_len;
#line 1633 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp442_ == ((gssize) _tmp443_)) {
#line 15741 "tracker-sparql-pattern.c"
		GString* _tmp444_;
#line 1636 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp444_ = sql;
#line 1636 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_string_append (_tmp444_, "1, ");
#line 15747 "tracker-sparql-pattern.c"
	}
#line 1348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (ontologies);
#line 1348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (subject_type);
#line 1348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (prop);
#line 1348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (table);
#line 1348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (db_table);
#line 1348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (object);
#line 15761 "tracker-sparql-pattern.c"
}


static TrackerSparqlDataTable* tracker_sparql_pattern_get_table (TrackerSparqlPattern* self, const gchar* subject, const gchar* db_table, gboolean share_table, gboolean* newtable) {
	gboolean _vala_newtable = FALSE;
	TrackerSparqlDataTable* result = NULL;
	gchar* tablestring = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	TrackerSparqlDataTable* table = NULL;
	gboolean _tmp3_;
	TrackerSparqlDataTable* _tmp9_;
#line 1640 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1640 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (subject != NULL, NULL);
#line 1640 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (db_table != NULL, NULL);
#line 1641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = subject;
#line 1641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = db_table;
#line 1641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = g_strdup_printf ("%s.%s", _tmp0_, _tmp1_);
#line 1641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tablestring = _tmp2_;
#line 1642 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	table = NULL;
#line 1643 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_vala_newtable = FALSE;
#line 1644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = share_table;
#line 1644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp3_) {
#line 15797 "tracker-sparql-pattern.c"
		TrackerSparqlPatternTripleContext* _tmp4_;
		GHashTable* _tmp5_;
		const gchar* _tmp6_;
		gconstpointer _tmp7_;
		TrackerSparqlDataTable* _tmp8_;
#line 1645 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp4_ = self->priv->triple_context;
#line 1645 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp5_ = _tmp4_->table_map;
#line 1645 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp6_ = tablestring;
#line 1645 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp7_ = g_hash_table_lookup (_tmp5_, _tmp6_);
#line 1645 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp8_ = _g_object_ref0 ((TrackerSparqlDataTable*) _tmp7_);
#line 1645 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (table);
#line 1645 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		table = _tmp8_;
#line 15817 "tracker-sparql-pattern.c"
	}
#line 1647 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp9_ = table;
#line 1647 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (_tmp9_ == NULL) {
#line 15823 "tracker-sparql-pattern.c"
		TrackerSparqlDataTable* _tmp10_;
		TrackerSparqlDataTable* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		TrackerSparqlDataTable* _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		TrackerSparqlPatternTripleContext* _tmp21_;
		TrackerSparqlDataTable* _tmp22_;
		TrackerSparqlDataTable* _tmp23_;
		TrackerSparqlPatternTripleContext* _tmp24_;
		GHashTable* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		TrackerSparqlDataTable* _tmp28_;
		TrackerSparqlDataTable* _tmp29_;
#line 1648 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_vala_newtable = TRUE;
#line 1649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp10_ = tracker_sparql_data_table_new ();
#line 1649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_object_unref0 (table);
#line 1649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		table = _tmp10_;
#line 1650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp11_ = table;
#line 1650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp12_ = db_table;
#line 1650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp13_ = g_strdup (_tmp12_);
#line 1650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp11_->sql_db_tablename);
#line 1650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp11_->sql_db_tablename = _tmp13_;
#line 1651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp14_ = table;
#line 1651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp15_ = db_table;
#line 1651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp16_ = self->priv->counter;
#line 1651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		self->priv->counter = _tmp16_ + 1;
#line 1651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp17_ = self->priv->counter;
#line 1651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp18_ = g_strdup_printf ("%i", _tmp17_);
#line 1651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp19_ = _tmp18_;
#line 1651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp20_ = g_strconcat (_tmp15_, _tmp19_, NULL);
#line 1651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp14_->sql_query_tablename);
#line 1651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp14_->sql_query_tablename = _tmp20_;
#line 1651 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_g_free0 (_tmp19_);
#line 1652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp21_ = self->priv->triple_context;
#line 1652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp22_ = table;
#line 1652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp23_ = _g_object_ref0 (_tmp22_);
#line 1652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp21_->tables = g_list_append (_tmp21_->tables, _tmp23_);
#line 1653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp24_ = self->priv->triple_context;
#line 1653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp25_ = _tmp24_->table_map;
#line 1653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp26_ = tablestring;
#line 1653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp27_ = g_strdup (_tmp26_);
#line 1653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp28_ = table;
#line 1653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		_tmp29_ = _g_object_ref0 (_tmp28_);
#line 1653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		g_hash_table_insert (_tmp25_, _tmp27_, _tmp29_);
#line 15906 "tracker-sparql-pattern.c"
	}
#line 1655 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = table;
#line 1655 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (tablestring);
#line 1655 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	if (newtable) {
#line 1655 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		*newtable = _vala_newtable;
#line 15916 "tracker-sparql-pattern.c"
	}
#line 1655 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 15920 "tracker-sparql-pattern.c"
}


static TrackerSparqlContext* tracker_sparql_pattern_get_context (TrackerSparqlPattern* self) {
	TrackerSparqlContext* result;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlContext* _tmp1_;
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = _tmp0_->context;
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	result = _tmp1_;
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return result;
#line 15938 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_set_context (TrackerSparqlPattern* self, TrackerSparqlContext* value) {
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlContext* _tmp1_;
	TrackerSparqlContext* _tmp2_;
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_if_fail (self != NULL);
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = self->priv->query;
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = value;
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = _tracker_sparql_context_ref0 (_tmp1_);
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (_tmp0_->context);
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_->context = _tmp2_;
#line 15958 "tracker-sparql-pattern.c"
}


static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_construct (GType object_type, TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
	TrackerSparqlPatternTripleContext* self = NULL;
	TrackerSparqlQuery* _tmp0_;
	TrackerSparqlContext* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GDestroyNotify _tmp4_;
	GDestroyNotify _tmp5_;
	GHashTable* _tmp6_;
	GDestroyNotify _tmp7_;
	GDestroyNotify _tmp8_;
	GHashTable* _tmp9_;
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_return_val_if_fail (parent_context != NULL, NULL);
#line 240 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp0_ = query;
#line 240 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp1_ = parent_context;
#line 240 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self = (TrackerSparqlPatternTripleContext*) tracker_sparql_context_construct (object_type, _tmp0_, _tmp1_);
#line 242 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (self->tables);
#line 242 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->tables = NULL;
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp2_ = g_str_hash;
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp3_ = g_str_equal;
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp4_ = g_free;
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp5_ = g_object_unref;
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp6_ = g_hash_table_new_full (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_hash_table_unref0 (self->table_map);
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->table_map = _tmp6_;
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (self->variables);
#line 245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->variables = NULL;
#line 246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp7_ = g_object_unref;
#line 246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp8_ = g_object_unref;
#line 246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tmp9_ = g_hash_table_new_full (_tracker_sparql_variable_hash_ghash_func, _tracker_sparql_variable_equal_gequal_func, _tmp7_, _tmp8_);
#line 246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_hash_table_unref0 (self->var_bindings);
#line 246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->var_bindings = _tmp9_;
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (self->bindings);
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->bindings = NULL;
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return self;
#line 16022 "tracker-sparql-pattern.c"
}


static TrackerSparqlPatternTripleContext* tracker_sparql_pattern_triple_context_new (TrackerSparqlQuery* query, TrackerSparqlContext* parent_context) {
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	return tracker_sparql_pattern_triple_context_construct (TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, query, parent_context);
#line 16029 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_triple_context_class_init (TrackerSparqlPatternTripleContextClass * klass) {
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_triple_context_parent_class = g_type_class_peek_parent (klass);
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	((TrackerSparqlContextClass *) klass)->finalize = tracker_sparql_pattern_triple_context_finalize;
#line 16038 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_triple_context_instance_init (TrackerSparqlPatternTripleContext * self) {
}


static void tracker_sparql_pattern_triple_context_finalize (TrackerSparqlContext * obj) {
	TrackerSparqlPatternTripleContext * self;
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_PATTERN_TYPE_TRIPLE_CONTEXT, TrackerSparqlPatternTripleContext);
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (self->tables);
#line 232 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_hash_table_unref0 (self->table_map);
#line 234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (self->bindings);
#line 236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	__g_list_free__g_object_unref0_0 (self->variables);
#line 237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_hash_table_unref0 (self->var_bindings);
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	TRACKER_SPARQL_CONTEXT_CLASS (tracker_sparql_pattern_triple_context_parent_class)->finalize (obj);
#line 16062 "tracker-sparql-pattern.c"
}


static GType tracker_sparql_pattern_triple_context_get_type (void) {
	static volatile gsize tracker_sparql_pattern_triple_context_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_pattern_triple_context_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlPatternTripleContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_pattern_triple_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlPatternTripleContext), 0, (GInstanceInitFunc) tracker_sparql_pattern_triple_context_instance_init, NULL };
		GType tracker_sparql_pattern_triple_context_type_id;
		tracker_sparql_pattern_triple_context_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONTEXT, "TrackerSparqlPatternTripleContext", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_pattern_triple_context_type_id__volatile, tracker_sparql_pattern_triple_context_type_id);
	}
	return tracker_sparql_pattern_triple_context_type_id__volatile;
}


static void tracker_sparql_pattern_class_init (TrackerSparqlPatternClass * klass) {
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	tracker_sparql_pattern_parent_class = g_type_class_peek_parent (klass);
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlPatternPrivate));
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_sparql_pattern_get_property;
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_sparql_pattern_set_property;
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_pattern_finalize;
#line 16089 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_instance_init (TrackerSparqlPattern * self) {
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->priv = TRACKER_SPARQL_PATTERN_GET_PRIVATE (self);
#line 182 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->queries_fts_data = FALSE;
#line 16098 "tracker-sparql-pattern.c"
}


static void tracker_sparql_pattern_finalize (GObject * obj) {
	TrackerSparqlPattern * self;
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern);
#line 173 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (self->current_graph);
#line 175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (self->priv->current_subject);
#line 177 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_free0 (self->priv->current_predicate);
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (self->fts_subject);
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	self->fts_variables = (_vala_array_free (self->fts_variables, self->fts_variables_length1, (GDestroyNotify) g_free), NULL);
#line 181 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_string_free0 (self->match_str);
#line 184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_g_object_unref0 (self->priv->manager);
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	_tracker_sparql_context_unref0 (self->priv->triple_context);
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	G_OBJECT_CLASS (tracker_sparql_pattern_parent_class)->finalize (obj);
#line 16124 "tracker-sparql-pattern.c"
}


GType tracker_sparql_pattern_get_type (void) {
	static volatile gsize tracker_sparql_pattern_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_pattern_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlPatternClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_pattern_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlPattern), 0, (GInstanceInitFunc) tracker_sparql_pattern_instance_init, NULL };
		GType tracker_sparql_pattern_type_id;
		tracker_sparql_pattern_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlPattern", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_pattern_type_id__volatile, tracker_sparql_pattern_type_id);
	}
	return tracker_sparql_pattern_type_id__volatile;
}


static void _vala_tracker_sparql_pattern_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerSparqlPattern * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern);
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	switch (property_id) {
#line 16145 "tracker-sparql-pattern.c"
		default:
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		break;
#line 16151 "tracker-sparql-pattern.c"
	}
}


static void _vala_tracker_sparql_pattern_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerSparqlPattern * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_SPARQL_TYPE_PATTERN, TrackerSparqlPattern);
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
	switch (property_id) {
#line 16161 "tracker-sparql-pattern.c"
		default:
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-pattern.vala"
		break;
#line 16167 "tracker-sparql-pattern.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



